'use strict';

exports.__esModule = true;

var _reactDesc = require('react-desc');

var _utils = require('../../utils');

exports.default = function (Distribution) {
  var DocumentedDistribution = (0, _reactDesc.describe)(Distribution).availableAt((0, _utils.getAvailableAtBadge)('Distribution')).description('Approximately proportionally sized grid of boxes. The\n      area given to each box isn\'t mathematically precise according to the\n      ratio to the total values. Instead, the boxes are laid out in a\n      manner that makes them more visually easy to scan. For example,\n      two values of 48 and 52 will actually each get 50% of the area.').usage("import { Distribution } from 'grommet';\n<Distribution />");

  DocumentedDistribution.propTypes = {
    children: _reactDesc.PropTypes.func.description('Function that will be called when each value is rendered.'),
    gap: _reactDesc.PropTypes.oneOf(['xsmall', 'small', 'medium', 'large', 'xlarge']).description('The amount of spacing between child elements.'),
    values: _reactDesc.PropTypes.arrayOf(_reactDesc.PropTypes.shape({
      value: _reactDesc.PropTypes.number.isRequired
    })).description('Array of objects containing a value. The caller can put other\n      properties in the object. The children function will be called to\n      render the contents of each value.').isRequired
  };

  return DocumentedDistribution;
};