import { describe, PropTypes } from 'react-desc';

import { getAvailableAtBadge } from '../../utils';

export default (function (Stack) {
  var DocumentedStack = describe(Stack).availableAt(getAvailableAtBadge('Stack')).description('Stacks components on top of the first child component.').usage('import { Stack } from \'grommet\';\n<Stack />');

  DocumentedStack.propTypes = {
    anchor: PropTypes.oneOf(['center', 'left', 'right', 'top', 'bottom', 'top-left', 'bottom-left', 'top-right', 'bottom-right']).description('Where to anchor children from. If not specified, children\n      fill the guiding child\'s area.'),
    fill: PropTypes.bool.description('Whether to expand to fill\n      all of the available width and height in the parent container.'),
    guidingChild: PropTypes.oneOfType([PropTypes.number, PropTypes.oneOf(['first', 'last'])]).description('Which child to guide layout from. All other children\n      will be positioned within that area. Defaults to \'first\'.').defaultValue('first')
  };

  return DocumentedStack;
});