# Contributing to Halfmoon

Please read this short document if you want to contribute to Halfmoon.

## Our goal

Before getting to the issues and pull requests, it is important to understand what the framework is trying to do.

Halfmoon's stated goal is really simple - create a customizable frontend framework, with a built-in dark mode, that is great for building dashboards and tools. However, our other goals are more implicit:

- Everything has to be **super functional and snappy**. Ideally, that means no performance issues and just consistently good execution. 
- Everything has to **look good** as well, and have a **single, consistent style**.

The most important thing here is building a **really good (looking) framework that also works very well**, and that should always be the top priority.

## Issues

Please keep the following things in mind when raising issues:

- Feature requests are welcome. However, please make sure that the feature you are requesting falls under the scope of the project.
-  **Do not** post personal support questions as issues. For those, use this [tag on Stack Overflow](https://stackoverflow.com/questions/tagged/halfmoon).
- When raising an issue, please be as thorough as possible. For possible bugs, reproducible code is always a great sign.

## Pull requests

**Please ask first** before you put in work for a pull request. Things are constantly being worked on, and it is very difficult to share everything publicly in a meaningful way. So asking lets us avoid working on the same thing, or worse, someone putting in a lot of work for a PR that does not fit into the scope of the project. Please do not take this the wrong way; at this stage, the project needs strong leadership to become something special.

The best way to ask is through email: [hey.halfmoon@gmail.com](mailto:hey.halfmoon@gmail.com). I am always open to proper discussions about the framework, especially when it comes to contributions and pull requests. 

## License

Any contribution you make will fall under the license being used by the framework: [MIT license](https://www.gethalfmoon.com/license/).
