"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isEmptyElement = isEmptyElement;
const EMPTY_ELEMENTS = ['area', 'base', 'br', 'col', 'embed', 'hr', 'img', 'input', 'link', 'meta', 'param', 'source', 'track', 'wbr']; // Don't want to require a Set() polyfill

const EMPTY_ELEMENTS_OBJ = {};

for (let element of EMPTY_ELEMENTS) {
  EMPTY_ELEMENTS_OBJ[element] = true;
}

function isEmptyElement(tagName) {
  return EMPTY_ELEMENTS_OBJ.hasOwnProperty(tagName) && Boolean(EMPTY_ELEMENTS_OBJ[tagName]);
}