"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseOpenPartialTag = parseOpenPartialTag;
exports.parsePartialTagEnd = parsePartialTagEnd;
const OPEN_PARTIAL_TAG_REGEX = /^<([a-zA-Z]+)(\s+[^>]*)$/;

function parseOpenPartialTag(fragment) {
  let match = fragment.match(OPEN_PARTIAL_TAG_REGEX);

  if (match != null) {
    let tagName = match[1];
    let content = match[2];
    return {
      tagName,
      content
    };
  }
}

function parsePartialTagEnd(fragment) {
  // This is obviously simplistic but should work well enough for our use case
  let index = fragment.indexOf('>');

  if (index !== -1) {
    return {
      content: fragment.substring(0, index),
      remaining: fragment.substring(index + 1)
    };
  }
}