"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HandlebarsEnvironment = HandlebarsEnvironment;
Object.defineProperty(exports, "createFrame", {
  enumerable: true,
  get: function () {
    return _utils.createFrame;
  }
});
Object.defineProperty(exports, "logger", {
  enumerable: true,
  get: function () {
    return _logger.default;
  }
});
exports.log = exports.REVISION_CHANGES = exports.COMPILER_REVISION = exports.VERSION = void 0;

var _utils = require("./utils");

var _exception = _interopRequireDefault(require("./exception"));

var _helpers = require("./helpers");

var _decorators = require("./decorators");

var _logger = _interopRequireDefault(require("./logger"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const VERSION = '4.1.0';
exports.VERSION = VERSION;
const COMPILER_REVISION = 7;
exports.COMPILER_REVISION = COMPILER_REVISION;
const REVISION_CHANGES = {
  1: '<= 1.0.rc.2',
  // 1.0.rc.2 is actually rev2 but doesn't report it
  2: '== 1.0.0-rc.3',
  3: '== 1.0.0-rc.4',
  4: '== 1.x.x',
  5: '== 2.0.0-alpha.x',
  6: '>= 2.0.0-beta.1',
  7: '>= 4.0.0'
};
exports.REVISION_CHANGES = REVISION_CHANGES;
const objectType = '[object Object]';

function HandlebarsEnvironment(helpers, partials, decorators) {
  this.helpers = helpers || {};
  this.partials = partials || {};
  this.decorators = decorators || {};
  (0, _helpers.registerDefaultHelpers)(this);
  (0, _decorators.registerDefaultDecorators)(this);
}

HandlebarsEnvironment.prototype = {
  constructor: HandlebarsEnvironment,
  logger: _logger.default,
  log: _logger.default.log,
  registerHelper: function (name, fn) {
    if (_utils.toString.call(name) === objectType) {
      if (fn) {
        throw new _exception.default('Arg not supported with multiple helpers');
      }

      (0, _utils.extend)(this.helpers, name);
    } else {
      this.helpers[name] = fn;
    }
  },
  unregisterHelper: function (name) {
    delete this.helpers[name];
  },
  registerPartial: function (name, partial) {
    if (_utils.toString.call(name) === objectType) {
      (0, _utils.extend)(this.partials, name);
    } else {
      if (typeof partial === 'undefined') {
        throw new _exception.default(`Attempting to register a partial called "${name}" as undefined`);
      }

      this.partials[name] = partial;
    }
  },
  unregisterPartial: function (name) {
    delete this.partials[name];
  },
  registerDecorator: function (name, fn) {
    if (_utils.toString.call(name) === objectType) {
      if (fn) {
        throw new _exception.default('Arg not supported with multiple decorators');
      }

      (0, _utils.extend)(this.decorators, name);
    } else {
      this.decorators[name] = fn;
    }
  },
  unregisterDecorator: function (name) {
    delete this.decorators[name];
  }
};
let log = _logger.default.log;
exports.log = log;