"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parse = parse;
Object.defineProperty(exports, "parser", {
  enumerable: true,
  get: function () {
    return _parser.default;
  }
});

var _parser = _interopRequireDefault(require("./parser"));

var _whitespaceControl = _interopRequireDefault(require("./whitespace-control"));

var Helpers = _interopRequireWildcard(require("./helpers"));

var _utils = require("../utils");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let yy = {};
(0, _utils.extend)(yy, Helpers);

function parse(input, options) {
  // Just return if an already-compiled AST was passed in.
  if (input.type === 'Program') {
    return input;
  }

  _parser.default.yy = yy; // Altering the shared object here, but this is ok as parser is a sync operation

  yy.locInfo = function (locInfo) {
    return new yy.SourceLocation(options && options.srcName, locInfo);
  };

  let strip = new _whitespaceControl.default(options);
  return strip.accept(_parser.default.parse(input));
}