"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _utils = require("../utils");

function _default(instance) {
  instance.registerDecorator('inline', function (fn, props, container, options) {
    let ret = fn;

    if (!props.partials) {
      props.partials = {};

      ret = function (context, options) {
        // Create a new partials stack frame prior to exec.
        let original = container.partials;
        container.partials = (0, _utils.extend)({}, original, props.partials);
        let ret = fn(context, options);
        container.partials = original;
        return ret;
      };
    }

    props.partials[options.args[0]] = options.fn;
    return ret;
  });
}

module.exports = exports.default;
module.exports.default = exports.default;