'use strict';

exports.__esModule = true;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _element = require('./../../helpers/dom/element');

var _object = require('./../../helpers/object');

var _function = require('./../../helpers/function');

var _eventManager = require('./../../eventManager');

var _eventManager2 = _interopRequireDefault(_eventManager);

var _src = require('./../../3rdparty/walkontable/src');

var _plugins = require('./../../plugins');

var _base = require('./../_base');

var _base2 = _interopRequireDefault(_base);

var _commentEditor = require('./commentEditor');

var _commentEditor2 = _interopRequireDefault(_commentEditor);

var _utils = require('./../contextMenu/utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var privatePool = new WeakMap();
var META_COMMENT = 'comment';
var META_COMMENT_VALUE = 'value';
var META_STYLE = 'style';
var META_READONLY = 'readOnly';

/**
 * @plugin Comments
 *
 * @description
 * This plugin allows setting and managing cell comments by either an option in the context menu or with the use of the API.
 *
 * To enable the plugin, you'll need to set the comments property of the config object to `true`:
 * ```js
 * ...
 * comments: true
 * ...
 * ```
 *
 * To add comments at the table initialization, define the `comment` property in the `cell` config array as in an example below.
 *
 * @example
 *
 * ```js
 * ...
 * var hot = new Handsontable(document.getElementById('example'), {
 *   date: getData(),
 *   comments: true,
 *   cell: [
 *     {row: 1, col: 1, comment: {value: 'Foo'}},
 *     {row: 2, col: 2, comment: {value: 'Bar'}}
 *   ]
 * });
 *
 * // Access to the Comments plugin instance:
 * var commentsPlugin = hot.getPlugin('comments');
 *
 * // Manage comments programmatically:
 * commentsPlugin.editor.setCommentAtCell(1, 6, 'Comment contents');
 * commentsPlugin.showAtCell(1, 6);
 * commentsPlugin.removeCommentAtCell(1, 6);
 *
 * // You can also set range once and use proper methods:
 * commentsPlugin.setRange({row: 1, col: 6});
 * commentsPlugin.setComment('Comment contents');
 * commentsPlugin.show();
 * commentsPlugin.removeComment();
 * ...
 * ```
 */

var Comments = function (_BasePlugin) {
  _inherits(Comments, _BasePlugin);

  function Comments(hotInstance) {
    _classCallCheck(this, Comments);

    /**
     * Instance of {@link CommentEditor}.
     *
     * @type {CommentEditor}
     */
    var _this = _possibleConstructorReturn(this, (Comments.__proto__ || Object.getPrototypeOf(Comments)).call(this, hotInstance));

    _this.editor = null;
    /**
     * Instance of {@link EventManager}.
     *
     * @private
     * @type {EventManager}
     */
    _this.eventManager = null;
    /**
     * Current cell range.
     *
     * @type {Object}
     */
    _this.range = {};
    /**
     * @private
     * @type {Boolean}
     */
    _this.mouseDown = false;
    /**
     * @private
     * @type {Boolean}
     */
    _this.contextMenuEvent = false;
    /**
     * @private
     * @type {*}
     */
    _this.timer = null;
    /**
     * Delay used when showing/hiding the comments (in milliseconds).
     *
     * @type {Number}
     */
    _this.displayDelay = 250;

    privatePool.set(_this, {
      tempEditorDimensions: {},
      cellBelowCursor: null
    });
    return _this;
  }

  /**
   * Check if the plugin is enabled in the Handsontable settings.
   *
   * @returns {Boolean}
   */


  _createClass(Comments, [{
    key: 'isEnabled',
    value: function isEnabled() {
      return !!this.hot.getSettings().comments;
    }

    /**
     * Enable plugin for this Handsontable instance.
     */

  }, {
    key: 'enablePlugin',
    value: function enablePlugin() {
      var _this2 = this;

      if (this.enabled) {
        return;
      }

      if (!this.editor) {
        this.editor = new _commentEditor2.default();
      }

      if (!this.eventManager) {
        this.eventManager = new _eventManager2.default(this);
      }

      this.addHook('afterContextMenuDefaultOptions', function (options) {
        return _this2.addToContextMenu(options);
      });
      this.addHook('afterRenderer', function (TD, row, col, prop, value, cellProperties) {
        return _this2.onAfterRenderer(TD, cellProperties);
      });
      this.addHook('afterScrollHorizontally', function () {
        return _this2.hide();
      });
      this.addHook('afterScrollVertically', function () {
        return _this2.hide();
      });

      this.addHook('afterBeginEditing', function (args) {
        return _this2.onAfterBeginEditing(args);
      });

      this.registerListeners();

      _get(Comments.prototype.__proto__ || Object.getPrototypeOf(Comments.prototype), 'enablePlugin', this).call(this);
    }

    /**
     * Disable plugin for this Handsontable instance.
     */

  }, {
    key: 'disablePlugin',
    value: function disablePlugin() {
      _get(Comments.prototype.__proto__ || Object.getPrototypeOf(Comments.prototype), 'disablePlugin', this).call(this);
    }

    /**
     * Register all necessary DOM listeners.
     *
     * @private
     */

  }, {
    key: 'registerListeners',
    value: function registerListeners() {
      var _this3 = this;

      this.eventManager.addEventListener(document, 'mouseover', function (event) {
        return _this3.onMouseOver(event);
      });
      this.eventManager.addEventListener(document, 'mousedown', function (event) {
        return _this3.onMouseDown(event);
      });
      this.eventManager.addEventListener(document, 'mouseup', function (event) {
        return _this3.onMouseUp(event);
      });
      this.eventManager.addEventListener(this.editor.getInputElement(), 'blur', function (event) {
        return _this3.onEditorBlur(event);
      });
      this.eventManager.addEventListener(this.editor.getInputElement(), 'mousedown', function (event) {
        return _this3.onEditorMouseDown(event);
      });
      this.eventManager.addEventListener(this.editor.getInputElement(), 'mouseup', function (event) {
        return _this3.onEditorMouseUp(event);
      });
    }

    /**
     * Set current cell range to be able to use general methods like {@link Comments#setComment},
     * {@link Comments#removeComment}, {@link Comments#show}.
     *
     * @param {Object} range Object with `from` and `to` properties, each with `row` and `col` properties.
     */

  }, {
    key: 'setRange',
    value: function setRange(range) {
      this.range = range;
    }

    /**
     * Clear the currently selected cell.
     */

  }, {
    key: 'clearRange',
    value: function clearRange() {
      this.range = {};
    }

    /**
     * Check if the event target is a cell containing a comment.
     *
     * @param {Event} event DOM event
     * @returns {Boolean}
     */

  }, {
    key: 'targetIsCellWithComment',
    value: function targetIsCellWithComment(event) {
      var closestCell = (0, _element.closest)(event.target, 'TD', 'TBODY');

      return !!(closestCell && (0, _element.hasClass)(closestCell, 'htCommentCell') && (0, _element.closest)(closestCell, [this.hot.rootElement]));
    }

    /**
     * Check if the event target is a comment textarea.
     *
     * @param {Event} event DOM event.
     * @returns {Boolean}
     */

  }, {
    key: 'targetIsCommentTextArea',
    value: function targetIsCommentTextArea(event) {
      return this.editor.getInputElement() === event.target;
    }

    /**
     * Set a comment for a cell according to the previously set range (see {@link Comments#setRange}).
     *
     * @param {String} value Comment contents.
     */

  }, {
    key: 'setComment',
    value: function setComment(value) {
      if (!this.range.from) {
        throw new Error('Before using this method, first set cell range (hot.getPlugin("comment").setRange())');
      }
      var editorValue = this.editor.getValue();
      var comment = '';

      if (value != null) {
        comment = value;
      } else if (editorValue != null) {
        comment = editorValue;
      }

      var row = this.range.from.row;
      var col = this.range.from.col;

      this.updateCommentMeta(row, col, _defineProperty({}, META_COMMENT_VALUE, comment));
      this.hot.render();
    }

    /**
     * Set a comment for a cell.
     *
     * @param {Number} row Row index.
     * @param {Number} col Column index.
     * @param {String} value Comment contents.
     */

  }, {
    key: 'setCommentAtCell',
    value: function setCommentAtCell(row, col, value) {
      this.setRange({
        from: new _src.CellCoords(row, col)
      });
      this.setComment(value);
    }

    /**
     * Remove a comment from a cell according to previously set range (see {@link Comments#setRange}).
     *
     * @param {Boolean} [forceRender = true] If set to `true`, the table will be re-rendered at the end of the operation.
     */

  }, {
    key: 'removeComment',
    value: function removeComment() {
      var forceRender = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

      if (!this.range.from) {
        throw new Error('Before using this method, first set cell range (hot.getPlugin("comment").setRange())');
      }

      this.hot.setCellMeta(this.range.from.row, this.range.from.col, META_COMMENT, void 0);

      if (forceRender) {
        this.hot.render();
      }

      this.hide();
    }

    /**
     * Remove comment from a cell.
     *
     * @param {Number} row Row index.
     * @param {Number} col Column index.
     * @param {Boolean} [forceRender = true] If `true`, the table will be re-rendered at the end of the operation.
     */

  }, {
    key: 'removeCommentAtCell',
    value: function removeCommentAtCell(row, col) {
      var forceRender = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      this.setRange({
        from: new _src.CellCoords(row, col)
      });
      this.removeComment(forceRender);
    }

    /**
     * Get comment from a cell at the predefined range.
     */

  }, {
    key: 'getComment',
    value: function getComment() {
      var row = this.range.from.row;
      var column = this.range.from.col;

      return this.getCommentMeta(row, column, META_COMMENT_VALUE);
    }

    /**
     * Get comment from a cell at the provided coordinates.
     *
     * @param {Number} row Row index.
     * @param {Number} column Column index.
     */

  }, {
    key: 'getCommentAtCell',
    value: function getCommentAtCell(row, column) {
      return this.getCommentMeta(row, column, META_COMMENT_VALUE);
    }

    /**
     * Show the comment editor accordingly to the previously set range (see {@link Comments#setRange}).
     *
     * @returns {Boolean} Returns `true` if comment editor was shown.
     */

  }, {
    key: 'show',
    value: function show() {
      if (!this.range.from) {
        throw new Error('Before using this method, first set cell range (hot.getPlugin("comment").setRange())');
      }
      var meta = this.hot.getCellMeta(this.range.from.row, this.range.from.col);

      this.refreshEditor(true);
      this.editor.setValue(meta[META_COMMENT] ? meta[META_COMMENT][META_COMMENT_VALUE] : null || '');

      if (this.editor.hidden) {
        this.editor.show();
      }

      return true;
    }

    /**
     * Show comment editor according to cell coordinates.
     *
     * @param {Number} row Row index.
     * @param {Number} col Column index.
     * @returns {Boolean} Returns `true` if comment editor was shown.
     */

  }, {
    key: 'showAtCell',
    value: function showAtCell(row, col) {
      this.setRange({
        from: new _src.CellCoords(row, col)
      });

      return this.show();
    }

    /**
     * Hide the comment editor.
     */

  }, {
    key: 'hide',
    value: function hide() {
      if (!this.editor.hidden) {
        this.editor.hide();
      }
    }

    /**
     * Refresh comment editor position and styling.
     *
     * @param {Boolean} [force=false] If `true` then recalculation will be forced.
     */

  }, {
    key: 'refreshEditor',
    value: function refreshEditor() {
      var force = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

      if (!force && (!this.range.from || !this.editor.isVisible())) {
        return;
      }
      var scrollableElement = (0, _element.getScrollableElement)(this.hot.view.wt.wtTable.TABLE);
      var TD = this.hot.view.wt.wtTable.getCell(this.range.from);
      var row = this.range.from.row;
      var column = this.range.from.col;
      var cellOffset = (0, _element.offset)(TD);
      var lastColWidth = this.hot.view.wt.wtTable.getStretchedColumnWidth(column);
      var cellTopOffset = cellOffset.top < 0 ? 0 : cellOffset.top;
      var cellLeftOffset = cellOffset.left;

      if (this.hot.view.wt.wtViewport.hasVerticalScroll() && scrollableElement !== window) {
        cellTopOffset -= this.hot.view.wt.wtOverlays.topOverlay.getScrollPosition();
      }

      if (this.hot.view.wt.wtViewport.hasHorizontalScroll() && scrollableElement !== window) {
        cellLeftOffset -= this.hot.view.wt.wtOverlays.leftOverlay.getScrollPosition();
      }

      var x = cellLeftOffset + lastColWidth;
      var y = cellTopOffset;

      var commentStyle = this.getCommentMeta(row, column, META_STYLE);
      var readOnly = this.getCommentMeta(row, column, META_READONLY);

      if (commentStyle) {
        this.editor.setSize(commentStyle.width, commentStyle.height);
      } else {
        this.editor.resetSize();
      }

      this.editor.setReadOnlyState(readOnly);

      this.editor.setPosition(x, y);
    }

    /**
     * Check if there is a comment for selected range.
     *
     * @private
     * @returns {Boolean}
     */

  }, {
    key: 'checkSelectionCommentsConsistency',
    value: function checkSelectionCommentsConsistency() {
      var selected = this.hot.getSelectedRange();

      if (!selected) {
        return false;
      }
      var hasComment = false;
      var cell = selected.from; // IN EXCEL THERE IS COMMENT ONLY FOR TOP LEFT CELL IN SELECTION

      if (this.getCommentMeta(cell.row, cell.col, META_COMMENT_VALUE)) {
        hasComment = true;
      }

      return hasComment;
    }

    /**
     * Set or update the comment-related cell meta.
     *
     * @param {Number} row Row index.
     * @param {Number} column Column index.
     * @param {Object} metaObject Object defining all the comment-related meta information.
     */

  }, {
    key: 'updateCommentMeta',
    value: function updateCommentMeta(row, column, metaObject) {
      var oldComment = this.hot.getCellMeta(row, column)[META_COMMENT];
      var newComment = void 0;

      if (oldComment) {
        newComment = (0, _object.deepClone)(oldComment);
        (0, _object.deepExtend)(newComment, metaObject);
      } else {
        newComment = metaObject;
      }

      this.hot.setCellMeta(row, column, META_COMMENT, newComment);
    }

    /**
     * Get the comment related meta information.
     *
     * @param {Number} row Row index.
     * @param {Number} column Column index.
     * @param {String} property Cell meta property.
     * @returns {Mixed}
     */

  }, {
    key: 'getCommentMeta',
    value: function getCommentMeta(row, column, property) {
      var cellMeta = this.hot.getCellMeta(row, column);

      if (!cellMeta[META_COMMENT]) {
        return void 0;
      }

      return cellMeta[META_COMMENT][property];
    }

    /**
     * `mousedown` event callback.
     *
     * @private
     * @param {MouseEvent} event The `mousedown` event.
     */

  }, {
    key: 'onMouseDown',
    value: function onMouseDown(event) {
      this.mouseDown = true;

      if (!this.hot.view || !this.hot.view.wt) {
        return;
      }

      if (!this.contextMenuEvent && !this.targetIsCommentTextArea(event)) {
        var eventCell = (0, _element.closest)(event.target, 'TD', 'TBODY');
        var coordinates = null;

        if (eventCell) {
          coordinates = this.hot.view.wt.wtTable.getCoords(eventCell);
        }

        if (!eventCell || this.range.from && coordinates && (this.range.from.row !== coordinates.row || this.range.from.col !== coordinates.col)) {
          this.hide();
        }
      }
      this.contextMenuEvent = false;
    }

    /**
     * `mouseover` event callback.
     *
     * @private
     * @param {MouseEvent} event The `mouseover` event.
     */

  }, {
    key: 'onMouseOver',
    value: function onMouseOver(event) {
      var _this4 = this;

      if (this.mouseDown || this.editor.isFocused()) {
        return;
      }
      var priv = privatePool.get(this);
      priv.cellBelowCursor = document.elementFromPoint(event.clientX, event.clientY);

      (0, _function.debounce)(function () {
        if ((0, _element.hasClass)(event.target, 'wtBorder') || priv.cellBelowCursor !== event.target || !_this4.editor) {
          return;
        }

        if (_this4.targetIsCellWithComment(event)) {
          var coordinates = _this4.hot.view.wt.wtTable.getCoords(event.target);
          var range = {
            from: new _src.CellCoords(coordinates.row, coordinates.col)
          };

          _this4.setRange(range);
          _this4.show();
        } else if ((0, _element.isChildOf)(event.target, document) && !_this4.targetIsCommentTextArea(event) && !_this4.editor.isFocused()) {
          _this4.hide();
        }
      }, this.displayDelay)();
    }

    /**
     * `mouseup` event callback.
     *
     * @private
     * @param {MouseEvent} event The `mouseup` event.
     */

  }, {
    key: 'onMouseUp',
    value: function onMouseUp(event) {
      this.mouseDown = false;
    }

    /** *
     * The `afterRenderer` hook callback..
     *
     * @private
     * @param {HTMLTableCellElement} TD The rendered `TD` element.
     * @param {Object} cellProperties The rendered cell's property object.
     */

  }, {
    key: 'onAfterRenderer',
    value: function onAfterRenderer(TD, cellProperties) {
      if (cellProperties[META_COMMENT] && cellProperties[META_COMMENT][META_COMMENT_VALUE]) {
        (0, _element.addClass)(TD, cellProperties.commentedCellClassName);
      }
    }

    /**
     * `blur` event callback for the comment editor.
     *
     * @private
     * @param {Event} event The `blur` event.
     */

  }, {
    key: 'onEditorBlur',
    value: function onEditorBlur(event) {
      this.setComment();
    }

    /**
     * `mousedown` hook. Along with `onEditorMouseUp` used to simulate the textarea resizing event.
     *
     * @private
     * @param {MouseEvent} event The `mousedown` event.
     */

  }, {
    key: 'onEditorMouseDown',
    value: function onEditorMouseDown(event) {
      var priv = privatePool.get(this);

      priv.tempEditorDimensions = {
        width: (0, _element.outerWidth)(event.target),
        height: (0, _element.outerHeight)(event.target)
      };
    }

    /**
     * `mouseup` hook. Along with `onEditorMouseDown` used to simulate the textarea resizing event.
     *
     * @private
     * @param {MouseEvent} event The `mouseup` event.
     */

  }, {
    key: 'onEditorMouseUp',
    value: function onEditorMouseUp(event) {
      var priv = privatePool.get(this);
      var currentWidth = (0, _element.outerWidth)(event.target);
      var currentHeight = (0, _element.outerHeight)(event.target);

      if (currentWidth !== priv.tempEditorDimensions.width + 1 || currentHeight !== priv.tempEditorDimensions.height + 2) {
        this.updateCommentMeta(this.range.from.row, this.range.from.col, _defineProperty({}, META_STYLE, {
          width: currentWidth,
          height: currentHeight
        }));
      }
    }

    /**
     * Context Menu's "Add comment" callback. Results in showing the comment editor.
     *
     * @private
     */

  }, {
    key: 'onContextMenuAddComment',
    value: function onContextMenuAddComment() {
      var _this5 = this;

      var coords = this.hot.getSelectedRange();

      this.contextMenuEvent = true;
      this.setRange({
        from: coords.from
      });
      this.show();
      setTimeout(function () {
        if (_this5.hot) {
          _this5.hot.deselectCell();
          _this5.editor.focus();
        }
      }, 10);
    }

    /**
     * Context Menu's "remove comment" callback.
     *
     * @private
     * @param {Object} selection The current selection.
     */

  }, {
    key: 'onContextMenuRemoveComment',
    value: function onContextMenuRemoveComment(selection) {
      this.contextMenuEvent = true;

      for (var i = selection.start.row; i <= selection.end.row; i++) {
        for (var j = selection.start.col; j <= selection.end.col; j++) {
          this.removeCommentAtCell(i, j, false);
        }
      }

      this.hot.render();
    }

    /**
     * Context Menu's "make comment read-only" callback.
     *
     * @private
     * @param {Object} selection The current selection.
     */

  }, {
    key: 'onContextMenuMakeReadOnly',
    value: function onContextMenuMakeReadOnly(selection) {
      this.contextMenuEvent = true;

      for (var i = selection.start.row; i <= selection.end.row; i++) {
        for (var j = selection.start.col; j <= selection.end.col; j++) {
          var currentState = !!this.getCommentMeta(i, j, META_READONLY);

          this.updateCommentMeta(i, j, _defineProperty({}, META_READONLY, !currentState));
        }
      }
    }

    /**
     * Add Comments plugin options to the Context Menu.
     *
     * @private
     * @param {Object} defaultOptions
     */

  }, {
    key: 'addToContextMenu',
    value: function addToContextMenu(defaultOptions) {
      var _this6 = this;

      defaultOptions.items.push((0, _plugins.getPlugin)(this.hot, 'contextMenu').constructor.SEPARATOR, {
        key: 'commentsAddEdit',
        name: function name() {
          return _this6.checkSelectionCommentsConsistency() ? 'Edit comment' : 'Add comment';
        },
        callback: function callback() {
          return _this6.onContextMenuAddComment();
        },
        disabled: function disabled() {
          return !(this.getSelected() && !this.selection.selectedHeader.corner);
        }
      }, {
        key: 'commentsRemove',
        name: function name() {
          return 'Delete comment';
        },

        callback: function callback(key, selection) {
          return _this6.onContextMenuRemoveComment(selection);
        },
        disabled: function disabled() {
          return _this6.hot.selection.selectedHeader.corner;
        }
      }, {
        key: 'commentsReadOnly',
        name: function name() {
          var _this7 = this;

          var label = 'Read only comment';
          var hasProperty = (0, _utils.checkSelectionConsistency)(this.getSelectedRange(), function (row, col) {
            var readOnlyProperty = _this7.getCellMeta(row, col)[META_COMMENT];
            if (readOnlyProperty) {
              readOnlyProperty = readOnlyProperty[META_READONLY];
            }

            if (readOnlyProperty) {
              return true;
            }
          });

          if (hasProperty) {
            label = (0, _utils.markLabelAsSelected)(label);
          }

          return label;
        },

        callback: function callback(key, selection) {
          return _this6.onContextMenuMakeReadOnly(selection);
        },
        disabled: function disabled() {
          return _this6.hot.selection.selectedHeader.corner || !_this6.checkSelectionCommentsConsistency();
        }
      });
    }

    /**
     * `afterBeginEditing` hook callback.
     *
     * @private
     * @param {Number} row Row index of the currently edited cell.
     * @param {Number} column Column index of the currently edited cell.
     */

  }, {
    key: 'onAfterBeginEditing',
    value: function onAfterBeginEditing(row, column) {
      this.hide();
    }

    /**
     * Destroy plugin instance.
     */

  }, {
    key: 'destroy',
    value: function destroy() {
      if (this.editor) {
        this.editor.destroy();
      }
      _get(Comments.prototype.__proto__ || Object.getPrototypeOf(Comments.prototype), 'destroy', this).call(this);
    }
  }]);

  return Comments;
}(_base2.default);

(0, _plugins.registerPlugin)('comments', Comments);

exports.default = Comments;