import BaseEditor from './_baseEditor';
import {hasClass} from './../helpers/dom/element';

/**
 * @private
 * @editor CheckboxEditor
 * @class CheckboxEditor
 */
class CheckboxEditor extends BaseEditor {
  beginEditing(initialValue, event) {
    // editorManager return double click event as undefined
    if (event === void 0) {
      let checkbox = this.TD.querySelector('input[type="checkbox"]');

      if (!hasClass(checkbox, 'htBadValue')) {
        checkbox.click();
      }
    }
  }

  finishEditing() {}
  init() {}
  open() {}
  close() {}
  getValue() {}
  setValue() {}
  focus() {}
}

export default CheckboxEditor;
