/*!
 * Copyright (c) HANDSONCODE sp. z o. o.
 *
 * HANDSONTABLE is a software distributed by HANDSONCODE sp. z o. o., a Polish corporation based in
 * Gdynia, Poland, at Aleja Zwyciestwa 96-98, registered by the District Court in Gdansk under number
 * 538651, EU tax ID number: PL5862294002, share capital: PLN 62,800.00.
 *
 * This software is protected by applicable copyright laws, including international treaties, and dual-
 * licensed - depending on whether your use for commercial purposes, meaning intended for or
 * resulting in commercial advantage or monetary compensation, or not.
 *
 * If your use is strictly personal or solely for evaluation purposes, meaning for the purposes of testing
 * the suitability, performance, and usefulness of this software outside the production environment,
 * you agree to be bound by the terms included in the "handsontable-non-commercial-license.pdf" file.
 *
 * Your use of this software for commercial purposes is subject to the terms included in an applicable
 * license agreement.
 *
 * In any case, you must not make any such use of this software as to develop software which may be
 * considered competitive with this software.
 *
 * UNLESS EXPRESSLY AGREED OTHERWISE, HANDSONCODE PROVIDES THIS SOFTWARE ON AN "AS IS"
 * BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, AND IN NO EVENT AND UNDER NO
 * LEGAL THEORY, SHALL HANDSONCODE BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER ARISING FROM
 * USE OR INABILITY TO USE THIS SOFTWARE.
 *
 * Version: 14.3.0
 * Release date: 16/04/2024 (built at 16/04/2024 10:23:56)
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define("Handsontable",[],t):"object"==typeof exports?exports.Handsontable=t():e.Handsontable=t()}("undefined"!=typeof self?self:this,(()=>(()=>{var e={44820:(e,t,r)=>{"use strict";r.d(t,{iz:()=>lt,Ay:()=>ph});var n,s,o={};r.r(o),r.d(o,{AbsPlugin:()=>ti,AddressPlugin:()=>Jo,ArrayPlugin:()=>ei,BitShiftPlugin:()=>ni,BitwiseLogicOperationsPlugin:()=>ai,BooleanPlugin:()=>li,CharPlugin:()=>hi,CodePlugin:()=>ui,ComplexPlugin:()=>Ql,ConditionalAggregationPlugin:()=>ma,CountBlankPlugin:()=>ci,CountUniquePlugin:()=>di,DateTimePlugin:()=>pi,DegreesPlugin:()=>yi,DeltaPlugin:()=>wi,ExpPlugin:()=>Ci,FinancialPlugin:()=>Ri,FormulaTextPlugin:()=>Mi,HyperlinkPlugin:()=>Ai,InformationPlugin:()=>bi,IsEvenPlugin:()=>Ii,IsOddPlugin:()=>Oi,LogarithmPlugin:()=>xi,LookupPlugin:()=>Ra,MathConstantsPlugin:()=>Li,MathPlugin:()=>$l,MatrixPlugin:()=>Hi,MedianPlugin:()=>Fi,ModuloPlugin:()=>Ui,NumericAggregationPlugin:()=>Wi,PowerPlugin:()=>Gi,RadiansPlugin:()=>zi,RadixConversionPlugin:()=>Ki,RandomPlugin:()=>ta,RomanPlugin:()=>va,RoundingPlugin:()=>sa,SimpleArithmerticPlugin:()=>Na,SqrtPlugin:()=>oa,StatisticalAggregationPlugin:()=>hh,StatisticalPlugin:()=>zl,SumprodPlugin:()=>Ea,TextPlugin:()=>ya,TrigonometryPlugin:()=>wa}),function(e){e.RELATIVE="RELATIVE",e.ABSOLUTE="ABSOLUTE"}(n||(n={}));class i{constructor(e,t,r){this.type=e,this.col=t,this.sheet=r}static absolute(e,t){return new i(n.ABSOLUTE,e,t)}static relative(e,t){return new i(n.RELATIVE,e,t)}static compareByAbsoluteAddress(e){return(t,r)=>t.toSimpleColumnAddress(e).col-r.toSimpleColumnAddress(e).col}isColumnAbsolute(){return this.type===n.ABSOLUTE}isColumnRelative(){return this.type===n.RELATIVE}isAbsolute(){return this.type===n.ABSOLUTE&&void 0!==this.sheet}moved(e,t,r){const n=void 0===this.sheet?void 0:e;return new i(this.type,this.col+t,n)}shiftedByColumns(e){return new i(this.type,this.col+e,this.sheet)}toSimpleColumnAddress(e){const t=Lr(this,e);let r=this.col;return this.isColumnRelative()&&(r=e.col+this.col),Mr(t,r)}shiftRelativeDimensions(e,t){const r=this.isColumnRelative()?this.col+e:this.col;return new i(this.type,r,this.sheet)}shiftAbsoluteDimensions(e,t){const r=this.isColumnAbsolute()?this.col+e:this.col;return new i(this.type,r,this.sheet)}withSheet(e){return new i(this.type,this.col,e)}isInvalid(e){return this.toSimpleColumnAddress(e).col<0}hash(e){const t=e&&void 0!==this.sheet?`#${this.sheet}`:"";switch(this.type){case n.RELATIVE:return`${t}#COLR${this.col}`;case n.ABSOLUTE:return`${t}#COLA${this.col}`}}unparse(e){const t=this.toSimpleColumnAddress(e);if(Ar(t))return;const r=P(t.col);return`${this.type===n.ABSOLUTE?"$":""}${r}`}exceedsSheetSizeLimits(e){return this.col>=e}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class a{constructor(e,t,r){this.type=e,this.row=t,this.sheet=r}static absolute(e,t){return new a(n.ABSOLUTE,e,t)}static relative(e,t){return new a(n.RELATIVE,e,t)}static compareByAbsoluteAddress(e){return(t,r)=>t.toSimpleRowAddress(e).row-r.toSimpleRowAddress(e).row}isRowAbsolute(){return this.type===n.ABSOLUTE}isRowRelative(){return this.type===n.RELATIVE}isAbsolute(){return this.type===n.ABSOLUTE&&void 0!==this.sheet}moved(e,t,r){const n=void 0===this.sheet?void 0:e;return new a(this.type,this.row+r,n)}shiftedByRows(e){return new a(this.type,this.row+e,this.sheet)}toSimpleRowAddress(e){const t=Lr(this,e);let r=this.row;return this.isRowRelative()&&(r=e.row+this.row),Nr(t,r)}shiftRelativeDimensions(e,t){const r=this.isRowRelative()?this.row+t:this.row;return new a(this.type,r,this.sheet)}shiftAbsoluteDimensions(e,t){const r=this.isRowAbsolute()?this.row+t:this.row;return new a(this.type,r,this.sheet)}withSheet(e){return new a(this.type,this.row,e)}isInvalid(e){return this.toSimpleRowAddress(e).row<0}hash(e){const t=e&&void 0!==this.sheet?`#${this.sheet}`:"";switch(this.type){case n.RELATIVE:return`${t}#ROWR${this.row}`;case n.ABSOLUTE:return`${t}#ROWA${this.row}`}}unparse(e){const t=this.toSimpleRowAddress(e);if(_r(t))return;return`${this.type===n.ABSOLUTE?"$":""}${t.row+1}`}exceedsSheetSizeLimits(e){return this.row>=e}}!function(e){e.CELL_REFERENCE_RELATIVE="CELL_REFERENCE",e.CELL_REFERENCE_ABSOLUTE="CELL_REFERENCE_ABSOLUTE",e.CELL_REFERENCE_ABSOLUTE_COL="CELL_REFERENCE_ABSOLUTE_COL",e.CELL_REFERENCE_ABSOLUTE_ROW="CELL_REFERENCE_ABSOLUTE_ROW"}(s||(s={}));class l{constructor(e,t,r,n){this.col=e,this.row=t,this.type=r,this.sheet=n}static fromColAndRow(e,t,r){return(e.isColumnAbsolute()&&t.isRowAbsolute()?l.absolute.bind(this):e.isColumnAbsolute()?l.absoluteCol.bind(this):t.isRowAbsolute()?l.absoluteRow.bind(this):l.relative.bind(this))(e.col,t.row,r)}static relative(e,t,r){return new l(e,t,s.CELL_REFERENCE_RELATIVE,r)}static absolute(e,t,r){return new l(e,t,s.CELL_REFERENCE_ABSOLUTE,r)}static absoluteCol(e,t,r){return new l(e,t,s.CELL_REFERENCE_ABSOLUTE_COL,r)}static absoluteRow(e,t,r){return new l(e,t,s.CELL_REFERENCE_ABSOLUTE_ROW,r)}toSimpleCellAddress(e){const t=Lr(this,e);return this.type===s.CELL_REFERENCE_ABSOLUTE?br(t,this.col,this.row):this.type===s.CELL_REFERENCE_ABSOLUTE_ROW?br(t,e.col+this.col,this.row):this.type===s.CELL_REFERENCE_ABSOLUTE_COL?br(t,this.col,e.row+this.row):br(t,e.col+this.col,e.row+this.row)}toColumnAddress(){const e=this.isColumnRelative()?n.RELATIVE:n.ABSOLUTE;return new i(e,this.col,this.sheet)}toRowAddress(){const e=this.isRowRelative()?n.RELATIVE:n.ABSOLUTE;return new a(e,this.row,this.sheet)}toSimpleColumnAddress(e){const t=Lr(this,e);let r=this.col;return this.isColumnRelative()&&(r+=e.col),Mr(t,r)}toSimpleRowAddress(e){const t=Lr(this,e);let r=this.row;return this.isRowRelative()&&(r+=e.row),Nr(t,r)}isRowAbsolute(){return this.type===s.CELL_REFERENCE_ABSOLUTE||this.type===s.CELL_REFERENCE_ABSOLUTE_ROW}isColumnAbsolute(){return this.type===s.CELL_REFERENCE_ABSOLUTE||this.type===s.CELL_REFERENCE_ABSOLUTE_COL}isColumnRelative(){return this.type===s.CELL_REFERENCE_RELATIVE||this.type===s.CELL_REFERENCE_ABSOLUTE_ROW}isRowRelative(){return this.type===s.CELL_REFERENCE_RELATIVE||this.type===s.CELL_REFERENCE_ABSOLUTE_COL}isAbsolute(){return this.type===s.CELL_REFERENCE_ABSOLUTE&&void 0!==this.sheet}shiftedByRows(e){return new l(this.col,this.row+e,this.type,this.sheet)}shiftedByColumns(e){return new l(this.col+e,this.row,this.type,this.sheet)}moved(e,t,r){const n=void 0===this.sheet?void 0:e;return new l(this.col+t,this.row+r,this.type,n)}withSheet(e){return new l(this.col,this.row,this.type,e)}isInvalid(e){return Ir(this.toSimpleCellAddress(e))}shiftRelativeDimensions(e,t){const r=this.isColumnAbsolute()?this.col:this.col+e,n=this.isRowAbsolute()?this.row:this.row+t;return new l(r,n,this.type,this.sheet)}shiftAbsoluteDimensions(e,t){const r=this.isColumnRelative()?this.col:this.col+e,n=this.isRowRelative()?this.row:this.row+t;return new l(r,n,this.type,this.sheet)}hash(e){const t=e&&void 0!==this.sheet?`#${this.sheet}`:"";switch(this.type){case s.CELL_REFERENCE_RELATIVE:return`${t}#${this.row}R${this.col}`;case s.CELL_REFERENCE_ABSOLUTE:return`${t}#${this.row}A${this.col}`;case s.CELL_REFERENCE_ABSOLUTE_COL:return`${t}#${this.row}AC${this.col}`;case s.CELL_REFERENCE_ABSOLUTE_ROW:return`${t}#${this.row}AR${this.col}`}}unparse(e){const t=this.toSimpleCellAddress(e);if(Ir(t))return;const r=P(t.col),n=this.type===s.CELL_REFERENCE_ABSOLUTE||this.type===s.CELL_REFERENCE_ABSOLUTE_ROW?"$":"";return`${this.type===s.CELL_REFERENCE_ABSOLUTE||this.type===s.CELL_REFERENCE_ABSOLUTE_COL?"$":""}${r}${n}${t.row+1}`}exceedsSheetSizeLimits(e,t){return this.row>=t||this.col>=e}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const h=":",u="$",c="A-Za-zÀ-ʯ",d=`${c}0-9_.`,p=`[${c}0-9_]+`,g=`(${p}|'(((?!').|'')*)')!`,f=`(${g})?\\${u}?[A-Za-z]+\\${u}?[0-9]+`,m=`(${g})?\\${u}?[A-Za-z]+`,E=`(${g})?\\${u}?[0-9]+`,y="[rR][0-9]*[cC][0-9]*",w=`(${f})[^${d}]`,C=`[${c}_][${d}]*`,R=["0","1","2","3","4","5","6","7","8","9"],v=[...Array.from(Array(26)).map(((e,t)=>t+"A".charCodeAt(0))),...Array.from(Array(26)).map(((e,t)=>t+"a".charCodeAt(0))),...Array.from(Array(496)).map(((e,t)=>t+192))].map((e=>String.fromCharCode(e))),S=new RegExp(`^(${g})?(\\${u}?)([A-Za-z]+)(\\${u}?)([0-9]+)$`),T=new RegExp(`^(${g})?(\\${u}?)([A-Za-z]+)$`),N=new RegExp(`^(${g})?(\\${u}?)([0-9]+)$`),_=new RegExp(`^${p}$`),M=(e,t,r)=>{const n=S.exec(t),s=x(n[6]);let o=D(n,e);if(void 0===o)return;null===o&&(o=void 0);const i=Number(n[8])-1;return n[5]===u&&n[7]===u?l.absolute(s,i,o):n[5]===u?l.absoluteCol(s,i-r.row,o):n[7]===u?l.absoluteRow(s-r.col,i,o):l.relative(s-r.col,i-r.row,o)},A=(e,t,r)=>{const n=T.exec(t);let s=D(n,e);if(void 0===s)return;null===s&&(s=void 0);const o=x(n[6]);return n[5]===u?i.absolute(o,s):i.relative(o-r.col,s)},b=(e,t,r)=>{const n=N.exec(t);let s=D(n,e);if(void 0===s)return;null===s&&(s=void 0);const o=Number(n[6])-1;return n[5]===u?a.absolute(o,s):a.relative(o-r.row,s)},I=(e,t,r)=>{const n=S.exec(t);if(!n)return;const s=x(n[6]);let o=D(n,e);if(void 0===o)return;null===o&&(o=r);const i=Number(n[8])-1;return br(o,s,i)},O=(e,t,r)=>{const n=P(t.col),s=L(t.sheet,e);if(void 0!==s)return r!==t.sheet?`${s}!${n}${t.row+1}`:`${n}${t.row+1}`};function x(e){return 1===e.length?e.toUpperCase().charCodeAt(0)-65:e.split("").reduce(((e,t)=>26*e+(t.toUpperCase().charCodeAt(0)-64)),0)-1}function P(e){let t="";for(;e>=0;)t=String.fromCharCode(e%26+97)+t,e=Math.floor(e/26)-1;return t.toUpperCase()}function L(e,t){let r=t(e);if(void 0!==r)return _.test(r)?r:(r=r.replace(/'/g,"''"),`'${r}'`)}function D(e,t){var r;let n=null!==(r=e[3])&&void 0!==r?r:e[2];return n?(n=n.replace(/''/g,"'"),t(n)):null}var k=r(83012);
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const H=(e,t)=>({type:e,message:t});var F,U,V;!function(e){e.LexingError="LexingError",e.ParserError="ParsingError",e.StaticOffsetError="StaticOffsetError",e.StaticOffsetOutOfRangeError="StaticOffsetOutOfRangeError",e.RangeOffsetNotAllowed="RangeOffsetNotAllowed",e.InvalidRangeSize="InvalidRangeSize"}(F||(F={})),function(e){e.EMPTY="EMPTY",e.NUMBER="NUMBER",e.STRING="STRING",e.MINUS_UNARY_OP="MINUS_UNARY_OP",e.PLUS_UNARY_OP="PLUS_UNARY_OP",e.PERCENT_OP="PERCENT_OP",e.CONCATENATE_OP="CONCATENATE_OP",e.EQUALS_OP="EQUALS_OP",e.NOT_EQUAL_OP="NOT_EQUAL_OP",e.GREATER_THAN_OP="GREATER_THAN_OP",e.LESS_THAN_OP="LESS_THAN_OP",e.GREATER_THAN_OR_EQUAL_OP="GREATER_THAN_OR_EQUAL_OP",e.LESS_THAN_OR_EQUAL_OP="LESS_THAN_OR_EQUAL_OP",e.PLUS_OP="PLUS_OP",e.MINUS_OP="MINUS_OP",e.TIMES_OP="TIMES_OP",e.DIV_OP="DIV_OP",e.POWER_OP="POWER_OP",e.FUNCTION_CALL="FUNCTION_CALL",e.NAMED_EXPRESSION="NAMED_EXPRESSION",e.PARENTHESIS="PARENTHESES",e.CELL_REFERENCE="CELL_REFERENCE",e.CELL_RANGE="CELL_RANGE",e.COLUMN_RANGE="COLUMN_RANGE",e.ROW_RANGE="ROW_RANGE",e.ERROR="ERROR",e.ERROR_WITH_RAW_INPUT="ERROR_WITH_RAW_INPUT",e.ARRAY="ARRAY"}(U||(U={})),function(e){e[e.RELATIVE=0]="RELATIVE",e[e.START_ABSOLUTE=1]="START_ABSOLUTE",e[e.BOTH_ABSOLUTE=2]="BOTH_ABSOLUTE"}(V||(V={}));const B=(e,t)=>({type:U.CELL_REFERENCE,reference:e,leadingWhitespace:null==t?void 0:t.image}),W=(e,t,r,n)=>($(e,t,r),{type:U.CELL_RANGE,start:e,end:t,sheetReferenceType:r,leadingWhitespace:n}),Y=(e,t,r)=>({type:U.ARRAY,args:e,leadingWhitespace:null==t?void 0:t.image,internalWhitespace:null==r?void 0:r.image}),j=(e,t)=>({type:U.ERROR,error:e,leadingWhitespace:null==t?void 0:t.image}),G=(e,t,r)=>({type:U.ERROR_WITH_RAW_INPUT,error:t,rawInput:e,leadingWhitespace:null==r?void 0:r.image}),z=()=>({type:U.ERROR,error:Tr.parsingError()});function $(e,t,r){if(void 0!==e.sheet&&void 0===t.sheet||void 0===e.sheet&&void 0!==t.sheet)throw new Error("Start address inconsistent with end address");if(void 0===e.sheet&&r!==V.RELATIVE||void 0!==e.sheet&&r===V.RELATIVE)throw new Error("Sheet address inconsistent with sheet reference type")}function K(e,t){return(null!=t?t:"")+e}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const X={[U.PLUS_OP]:"+",[U.MINUS_OP]:"-",[U.TIMES_OP]:"*",[U.DIV_OP]:"/",[U.CONCATENATE_OP]:"&",[U.POWER_OP]:"^",[U.EQUALS_OP]:"=",[U.NOT_EQUAL_OP]:"<>",[U.GREATER_THAN_OP]:">",[U.GREATER_THAN_OR_EQUAL_OP]:">=",[U.LESS_THAN_OP]:"<",[U.LESS_THAN_OR_EQUAL_OP]:"<="};class q{constructor(e){this.functionRegistry=e,this.cache=new Map}set(e,t){const r=((e,t,r,n)=>({ast:e,relativeDependencies:t,hasVolatileFunction:r,hasStructuralChangeFunction:n}))(t,ke(t,this.functionRegistry),Q(t,this.functionRegistry.isFunctionVolatile),Q(t,this.functionRegistry.isFunctionDependentOnSheetStructureChange));return this.cache.set(e,r),r}get(e){return this.cache.get(e)}maybeSetAndThenGet(e,t){const r=this.cache.get(e);return void 0!==r?r.ast:(this.set(e,t),t)}}const Q=(e,t)=>{switch(e.type){case U.EMPTY:case U.NUMBER:case U.STRING:case U.ERROR:case U.ERROR_WITH_RAW_INPUT:case U.CELL_REFERENCE:case U.CELL_RANGE:case U.COLUMN_RANGE:case U.ROW_RANGE:case U.NAMED_EXPRESSION:return!1;case U.PERCENT_OP:case U.PLUS_UNARY_OP:case U.MINUS_UNARY_OP:return Q(e.value,t);case U.CONCATENATE_OP:case U.EQUALS_OP:case U.NOT_EQUAL_OP:case U.LESS_THAN_OP:case U.GREATER_THAN_OP:case U.LESS_THAN_OR_EQUAL_OP:case U.GREATER_THAN_OR_EQUAL_OP:case U.MINUS_OP:case U.PLUS_OP:case U.TIMES_OP:case U.DIV_OP:case U.POWER_OP:return Q(e.left,t)||Q(e.right,t);case U.PARENTHESIS:return Q(e.expression,t);case U.FUNCTION_CALL:return!!t(e.procedureName)||e.args.some((e=>Q(e,t)));case U.ARRAY:return e.args.some((e=>e.some((e=>Q(e,t)))))}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Z{}Z.DistinctSigns="Distinct signs.",Z.WrongArgNumber="Wrong number of arguments.",Z.EmptyArg="Empty function argument.",Z.EmptyArray="Empty array not allowed.",Z.ArrayDimensions="Array dimensions are not compatible.",Z.NoSpaceForArrayResult="No space for array result.",Z.ValueSmall="Value too small.",Z.ValueLarge="Value too large.",Z.BadCriterion="Incorrect criterion.",Z.RangeManySheets="Range spans more than one sheet.",Z.CellRangeExpected="Cell range expected.",Z.WrongDimension="Wrong range dimension.",Z.ScalarExpected="Cell range not allowed.",Z.NumberCoercion="Value cannot be coerced to number.",Z.NumberExpected="Number argument expected.",Z.IntegerExpected="Value needs to be an integer.",Z.BadMode="Mode not recognized.",Z.DateBounds="Date outside of bounds.",Z.OutOfSheet="Resulting reference is out of the sheet.",Z.WrongType="Wrong type of argument.",Z.NaN="NaN or infinite value encountered.",Z.EqualLength="Ranges need to be of equal length.",Z.Negative="Value cannot be negative.",Z.NotBinary="String does not represent a binary number.",Z.NotOctal="String does not represent an octal number.",Z.NotHex="String does not represent a hexadecimal number.",Z.EndStartPeriod="End period needs to be at least start period.",Z.CellRefExpected="Cell reference expected.",Z.EmptyRange="Empty range not allowed.",Z.BadRef="Address is not correct.",Z.NumberRange="Number-only range expected.",Z.ValueNotFound="Value not found.",Z.ValueBaseLarge="Value in base too large.",Z.ValueBaseSmall="Value in base too small.",Z.ValueBaseLong="Value in base too long.",Z.NegativeLength="Length cannot be negative.",Z.PatternNotFound="Pattern not found.",Z.OneValue="Needs at least one value.",Z.TwoValues="Range needs to contain at least two elements.",Z.ThreeValues="Range needs to contain at least three elements.",Z.IndexBounds="Index out of bounds.",Z.IndexLarge="Index too large.",Z.Formula="Expected formula.",Z.NegativeCount="Count cannot be negative.",Z.ParseError="Parsing error.",Z.SheetRef="Sheet does not exist.",Z.PeriodLong="Period number cannot exceed life length.",Z.InvalidDate="Invalid date.",Z.BitshiftLong="Result of bitshift is too long.",Z.EmptyString="Empty-string argument not allowed.",Z.LengthBounds="Length out of bounds.",Z.NegativeTime="Time cannot be negative.",Z.NoDefault="No default option.",Z.NoConditionMet="None of the conditions were met.",Z.Selector="Selector cannot exceed the number of arguments.",Z.StartEndDate="Start date needs to be earlier than end date.",Z.IncorrectDateTime="String does not represent correct DateTime.",Z.CharacterCodeBounds="Character code out of bounds.",Z.NonZero="Argument cannot be 0.",Z.LessThanOne="Argument cannot be less than 1.",Z.WeekendString="Incorrect weekend bitmask string.",Z.InvalidRoman="Invalid roman numeral.",Z.WrongOrder="Wrong order of values.",Z.ComplexNumberExpected="Complex number expected.",Z.ShouldBeIorJ="Should be 'i' or 'j'.",Z.SizeMismatch="Array dimensions mismatched.",Z.FunctionName=e=>`Function name ${e} not recognized.`,Z.NamedExpressionName=e=>`Named expression ${e} not recognized.`,Z.LicenseKey=e=>`License key is ${e}.`;
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const J=(0,k.createToken)({name:"AdditionOp",pattern:k.Lexer.NA}),ee=(0,k.createToken)({name:"PlusOp",pattern:/\+/,categories:J}),te=(0,k.createToken)({name:"MinusOp",pattern:/-/,categories:J}),re=(0,k.createToken)({name:"MultiplicationOp",pattern:k.Lexer.NA}),ne=(0,k.createToken)({name:"TimesOp",pattern:/\*/,categories:re}),se=(0,k.createToken)({name:"DivOp",pattern:/\//,categories:re}),oe=(0,k.createToken)({name:"PowerOp",pattern:/\^/}),ie=(0,k.createToken)({name:"PercentOp",pattern:/%/}),ae=(0,k.createToken)({name:"BooleanOp",pattern:k.Lexer.NA}),le=(0,k.createToken)({name:"EqualsOp",pattern:/=/,categories:ae}),he=(0,k.createToken)({name:"NotEqualOp",pattern:/<>/,categories:ae}),ue=(0,k.createToken)({name:"GreaterThanOp",pattern:/>/,categories:ae}),ce=(0,k.createToken)({name:"LessThanOp",pattern:/</,categories:ae}),de=(0,k.createToken)({name:"GreaterThanOrEqualOp",pattern:/>=/,categories:ae}),pe=(0,k.createToken)({name:"LessThanOrEqualOp",pattern:/<=/,categories:ae}),ge=(0,k.createToken)({name:"ConcatenateOp",pattern:/&/}),fe=(0,k.createToken)({name:"LParen",pattern:/\(/}),me=(0,k.createToken)({name:"RParen",pattern:/\)/}),Ee=(0,k.createToken)({name:"ArrayLParen",pattern:/{/}),ye=(0,k.createToken)({name:"ArrayRParen",pattern:/}/}),we=(0,k.createToken)({name:"StringLiteral",pattern:/"([^"\\]*(\\.[^"\\]*)*)"/}),Ce=(0,k.createToken)({name:"ErrorLiteral",pattern:/#[A-Za-z0-9\/]+[?!]?/}),Re=(0,k.createToken)({name:"RangeSeparator",pattern:new RegExp(h)}),ve=(0,k.createToken)({name:"ColumnRange",pattern:new RegExp(`${m}${h}${m}`)}),Se=(0,k.createToken)({name:"RowRange",pattern:new RegExp(`${E}${h}${E}`)}),Te=(0,k.createToken)({name:"ProcedureName",pattern:new RegExp(`([${c}][${d}]*)\\(`)}),Ne=new
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class{constructor(){this.POSSIBLE_START_CHARACTERS=[...v,...R,u,"'","_"],this.cellReferenceRegexp=new RegExp(w,"y")}match(e,t){this.cellReferenceRegexp.lastIndex=t;const r=this.cellReferenceRegexp.exec(e+"@");return null==r||null==r[1]?null:(r[0]=r[1],r)}},_e=(0,k.createToken)({name:"CellReference",pattern:Ne.match.bind(Ne),start_chars_hint:Ne.POSSIBLE_START_CHARACTERS,line_breaks:!1}),Me=new
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class{constructor(){this.POSSIBLE_START_CHARACTERS=[...v,"_"],this.namedExpressionRegexp=new RegExp(C,"y"),this.r1c1CellRefRegexp=new RegExp(`^${y}$`)}match(e,t){this.namedExpressionRegexp.lastIndex=t;const r=this.namedExpressionRegexp.exec(e);return null==r||null==r[0]||this.r1c1CellRefRegexp.test(r[0])?null:r}},Ae=(0,k.createToken)({name:"NamedExpression",pattern:Me.match.bind(Me),start_chars_hint:Me.POSSIBLE_START_CHARACTERS,line_breaks:!1}),be=e=>{const t=e.translationPackage.getFunctionTranslation("OFFSET"),r=e.errorMapping,n=e.translationPackage.buildFunctionMapping(),s=new RegExp("standard"===e.ignoreWhiteSpace?"[ \\t\\n\\r]+":"\\s+"),o=(0,k.createToken)({name:"WhiteSpace",pattern:s}),i=(0,k.createToken)({name:"ArrayRowSep",pattern:e.arrayRowSeparator}),a=(0,k.createToken)({name:"ArrayColSep",pattern:e.arrayColumnSeparator}),l=(0,k.createToken)({name:"NumberLiteral",pattern:new RegExp(`(([${e.decimalSeparator}]\\d+)|(\\d+([${e.decimalSeparator}]\\d*)?))(e[+-]?\\d+)?`)}),h=(0,k.createToken)({name:"OffsetProcedureName",pattern:new RegExp(t,"i")});let u,c;e.functionArgSeparator===e.arrayColumnSeparator?(u=a,c=[]):e.functionArgSeparator===e.arrayRowSeparator?(u=i,c=[]):(u=(0,k.createToken)({name:"ArgSeparator",pattern:e.functionArgSeparator}),c=[u]);return{ArgSeparator:u,NumberLiteral:l,OffsetProcedureName:h,ArrayRowSeparator:i,ArrayColSeparator:a,WhiteSpace:o,allTokens:[o,ee,te,ne,se,oe,le,he,ie,de,pe,ue,ce,fe,me,Ee,ye,h,Te,Re,...c,ve,Se,l,we,Ce,ge,ae,J,re,_e,Ae,i,a],errorMapping:r,functionMapping:n,decimalSeparator:e.decimalSeparator,maxColumns:e.maxColumns,maxRows:e.maxRows}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ie extends k.EmbeddedActionsParser{constructor(e,t){super(e.allTokens,{outputCst:!1,maxLookahead:7}),this.booleanExpressionOrEmpty=this.RULE("booleanExpressionOrEmpty",(()=>{return this.OR([{ALT:()=>this.SUBRULE(this.booleanExpression)},{ALT:(0,k.EMPTY_ALT)({type:U.EMPTY,leadingWhitespace:null==e?void 0:e.image})}]);var e})),this.procedureExpression=this.RULE("procedureExpression",(()=>{var e;const t=this.CONSUME(Te),r=t.image.toUpperCase().slice(0,-1),n=null!==(e=this.lexerConfig.functionMapping[r])&&void 0!==e?e:r,s=[];let o=this.SUBRULE(this.booleanExpressionOrEmpty);this.MANY((()=>{var e;const t=this.CONSUME(this.lexerConfig.ArgSeparator);o.type===U.EMPTY&&(o.leadingWhitespace=null===(e=t.leadingWhitespace)||void 0===e?void 0:e.image),s.push(o),o=this.SUBRULE2(this.booleanExpressionOrEmpty)})),s.push(o),1===s.length&&s[0].type===U.EMPTY&&(s.length=0);const i=this.CONSUME(me);return((e,t,r,n,s)=>({type:U.FUNCTION_CALL,procedureName:e,args:t,leadingWhitespace:null==r?void 0:r.image,internalWhitespace:null==n?void 0:n.image,hyperlink:s}))(n,s,t.leadingWhitespace,i.leadingWhitespace)})),this.namedExpressionExpression=this.RULE("namedExpressionExpression",(()=>{const e=this.CONSUME(Ae);return t=e.image,r=e.leadingWhitespace,{type:U.NAMED_EXPRESSION,expressionName:t,leadingWhitespace:null==r?void 0:r.image};var t,r})),this.offsetProcedureExpression=this.RULE("offsetProcedureExpression",(()=>{const e=[];return this.CONSUME(this.lexerConfig.OffsetProcedureName),this.CONSUME(fe),this.MANY_SEP({SEP:this.lexerConfig.ArgSeparator,DEF:()=>{e.push(this.SUBRULE(this.booleanExpression))}}),this.CONSUME(me),this.handleOffsetHeuristic(e)})),this.columnRangeExpression=this.RULE("columnRangeExpression",(()=>{const e=this.CONSUME(ve),[t,r]=e.image.split(":"),n=this.ACTION((()=>A(this.sheetMapping,t,this.formulaAddress))),s=this.ACTION((()=>A(this.sheetMapping,r,this.formulaAddress)));if(void 0===n||void 0===s)return j(new Tr(or.REF));if(n.exceedsSheetSizeLimits(this.lexerConfig.maxColumns)||s.exceedsSheetSizeLimits(this.lexerConfig.maxColumns))return G(e.image,new Tr(or.NAME),e.leadingWhitespace);if(void 0===n.sheet&&void 0!==s.sheet)return this.parsingError(F.ParserError,"Malformed range expression");const{firstEnd:o,secondEnd:i,sheetRefType:a}=Ie.fixSheetIdsForRangeEnds(n,s);return l=o,h=i,u=a,c=e.leadingWhitespace,$(l,h,u),{type:U.COLUMN_RANGE,start:l,end:h,sheetReferenceType:u,leadingWhitespace:null==c?void 0:c.image};var l,h,u,c})),this.rowRangeExpression=this.RULE("rowRangeExpression",(()=>{const e=this.CONSUME(Se),[t,r]=e.image.split(":"),n=this.ACTION((()=>b(this.sheetMapping,t,this.formulaAddress))),s=this.ACTION((()=>b(this.sheetMapping,r,this.formulaAddress)));if(void 0===n||void 0===s)return j(new Tr(or.REF));if(n.exceedsSheetSizeLimits(this.lexerConfig.maxRows)||s.exceedsSheetSizeLimits(this.lexerConfig.maxRows))return G(e.image,new Tr(or.NAME),e.leadingWhitespace);if(void 0===n.sheet&&void 0!==s.sheet)return this.parsingError(F.ParserError,"Malformed range expression");const{firstEnd:o,secondEnd:i,sheetRefType:a}=Ie.fixSheetIdsForRangeEnds(n,s);return l=o,h=i,u=a,c=e.leadingWhitespace,$(l,h,u),{type:U.ROW_RANGE,start:l,end:h,sheetReferenceType:u,leadingWhitespace:null==c?void 0:c.image};var l,h,u,c})),this.cellReference=this.RULE("cellReference",(()=>{const e=this.CONSUME(_e),t=this.ACTION((()=>M(this.sheetMapping,e.image,this.formulaAddress)));return void 0===t?G(e.image,new Tr(or.REF),e.leadingWhitespace):t.exceedsSheetSizeLimits(this.lexerConfig.maxColumns,this.lexerConfig.maxRows)?G(e.image,new Tr(or.NAME),e.leadingWhitespace):B(t,e.leadingWhitespace)})),this.endRangeReference=this.RULE("endRangeReference",(e=>{var t;const r=this.CONSUME(_e),n=this.ACTION((()=>M(this.sheetMapping,e.image,this.formulaAddress))),s=this.ACTION((()=>M(this.sheetMapping,r.image,this.formulaAddress)));return void 0===n||void 0===s?this.ACTION((()=>G(`${e.image}:${r.image}`,new Tr(or.REF),e.leadingWhitespace))):n.exceedsSheetSizeLimits(this.lexerConfig.maxColumns,this.lexerConfig.maxRows)||s.exceedsSheetSizeLimits(this.lexerConfig.maxColumns,this.lexerConfig.maxRows)?this.ACTION((()=>G(`${e.image}:${r.image}`,new Tr(or.NAME),e.leadingWhitespace))):this.buildCellRange(n,s,null===(t=e.leadingWhitespace)||void 0===t?void 0:t.image)})),this.endOfRangeExpression=this.RULE("endOfRangeExpression",(e=>this.OR([{ALT:()=>this.SUBRULE(this.endRangeReference,{ARGS:[e]})},{ALT:()=>{var t;const r=this.SUBRULE(this.offsetProcedureExpression),n=this.ACTION((()=>M(this.sheetMapping,e.image,this.formulaAddress)));return void 0===n?j(new Tr(or.REF)):r.type===U.CELL_REFERENCE?this.buildCellRange(n,r.reference,null===(t=e.leadingWhitespace)||void 0===t?void 0:t.image):this.parsingError(F.RangeOffsetNotAllowed,"Range offset not allowed here")}}]))),this.cellRangeExpression=this.RULE("cellRangeExpression",(()=>{const e=this.CONSUME(_e);return this.CONSUME2(Re),this.SUBRULE(this.endOfRangeExpression,{ARGS:[e]})})),this.endRangeWithOffsetStartReference=this.RULE("endRangeWithOffsetStartReference",(e=>{const t=this.CONSUME(_e),r=this.ACTION((()=>M(this.sheetMapping,t.image,this.formulaAddress)));return void 0===r?this.ACTION((()=>j(new Tr(or.REF)))):this.buildCellRange(e.reference,r,e.leadingWhitespace)})),this.endOfRangeWithOffsetStartExpression=this.RULE("endOfRangeWithOffsetStartExpression",(e=>this.OR([{ALT:()=>this.SUBRULE(this.endRangeWithOffsetStartReference,{ARGS:[e]})},{ALT:()=>{const t=this.SUBRULE(this.offsetProcedureExpression);return t.type===U.CELL_REFERENCE?this.buildCellRange(e.reference,t.reference,e.leadingWhitespace):this.parsingError(F.RangeOffsetNotAllowed,"Range offset not allowed here")}}]))),this.offsetExpression=this.RULE("offsetExpression",(()=>{const e=this.SUBRULE(this.offsetProcedureExpression);let t;return this.OPTION((()=>{this.CONSUME(Re),t=e.type===U.CELL_RANGE?this.parsingError(F.RangeOffsetNotAllowed,"Range offset not allowed here"):this.SUBRULE(this.endOfRangeWithOffsetStartExpression,{ARGS:[e]})})),void 0!==t?t:e})),this.insideArrayExpression=this.RULE("insideArrayExpression",(()=>{const e=[[]];return e[e.length-1].push(this.SUBRULE(this.booleanExpression)),this.MANY((()=>{this.OR([{ALT:()=>{this.CONSUME(this.lexerConfig.ArrayColSeparator),e[e.length-1].push(this.SUBRULE2(this.booleanExpression))}},{ALT:()=>{this.CONSUME(this.lexerConfig.ArrayRowSeparator),e.push([]),e[e.length-1].push(this.SUBRULE3(this.booleanExpression))}}])})),Y(e)})),this.parenthesisExpression=this.RULE("parenthesisExpression",(()=>{const e=this.CONSUME(fe),t=this.SUBRULE(this.booleanExpression),r=this.CONSUME(me);return((e,t,r)=>({type:U.PARENTHESIS,expression:e,leadingWhitespace:null==t?void 0:t.image,internalWhitespace:null==r?void 0:r.image}))(t,e.leadingWhitespace,r.leadingWhitespace)})),this.arrayExpression=this.RULE("arrayExpression",(()=>this.OR([{ALT:()=>{const e=this.CONSUME(Ee),t=this.SUBRULE(this.insideArrayExpression),r=this.CONSUME(ye);return Y(t.args,e.leadingWhitespace,r.leadingWhitespace)}},{ALT:()=>this.SUBRULE(this.parenthesisExpression)}]))),this.numericStringToNumber=e=>{const t=e.replace(this.lexerConfig.decimalSeparator,".");return Number(t)},this.positiveAtomicExpression=this.RULE("positiveAtomicExpression",(()=>{var e;return this.OR(null!==(e=this.atomicExpCache)&&void 0!==e?e:this.atomicExpCache=[{ALT:()=>this.SUBRULE(this.arrayExpression)},{ALT:()=>this.SUBRULE(this.cellRangeExpression)},{ALT:()=>this.SUBRULE(this.columnRangeExpression)},{ALT:()=>this.SUBRULE(this.rowRangeExpression)},{ALT:()=>this.SUBRULE(this.offsetExpression)},{ALT:()=>this.SUBRULE(this.cellReference)},{ALT:()=>this.SUBRULE(this.procedureExpression)},{ALT:()=>this.SUBRULE(this.namedExpressionExpression)},{ALT:()=>{const e=this.CONSUME(this.lexerConfig.NumberLiteral);return t=this.numericStringToNumber(e.image),r=e.leadingWhitespace,{type:U.NUMBER,value:t,leadingWhitespace:null==r?void 0:r.image};var t,r}},{ALT:()=>(e=>{var t;return{type:U.STRING,value:e.image.slice(1,-1),leadingWhitespace:null===(t=e.leadingWhitespace)||void 0===t?void 0:t.image}})(this.CONSUME(we))},{ALT:()=>{const e=this.CONSUME(Ce),t=e.image.toUpperCase(),r=this.lexerConfig.errorMapping[t];return r?j(new Tr(r),e.leadingWhitespace):this.parsingError(F.ParserError,"Unknown error literal")}}])})),this.rightUnaryOpAtomicExpression=this.RULE("rightUnaryOpAtomicExpression",(()=>{const e=this.SUBRULE(this.positiveAtomicExpression),t=this.OPTION((()=>this.CONSUME(ie)));return t?(r=e,n=t.leadingWhitespace,{type:U.PERCENT_OP,value:r,leadingWhitespace:null==n?void 0:n.image}):e;var r,n})),this.atomicExpression=this.RULE("atomicExpression",(()=>this.OR([{ALT:()=>{const e=this.CONSUME(J),t=this.SUBRULE(this.atomicExpression);return(0,k.tokenMatcher)(e,ee)?((e,t)=>({type:U.PLUS_UNARY_OP,value:e,leadingWhitespace:null==t?void 0:t.image}))(t,e.leadingWhitespace):(0,k.tokenMatcher)(e,te)?((e,t)=>({type:U.MINUS_UNARY_OP,value:e,leadingWhitespace:null==t?void 0:t.image}))(t,e.leadingWhitespace):(this.customParsingError=H(F.ParserError,"Mismatched token type"),this.customParsingError)}},{ALT:()=>this.SUBRULE2(this.rightUnaryOpAtomicExpression)}]))),this.powerExpression=this.RULE("powerExpression",(()=>{let e=this.SUBRULE(this.atomicExpression);return this.MANY((()=>{const t=this.CONSUME(oe),r=this.SUBRULE2(this.atomicExpression);var n,s,o;(0,k.tokenMatcher)(t,oe)?(n=e,s=r,o=t.leadingWhitespace,e={type:U.POWER_OP,left:n,right:s,leadingWhitespace:null==o?void 0:o.image}):this.ACTION((()=>{throw Error("Operator not supported")}))})),e})),this.multiplicationExpression=this.RULE("multiplicationExpression",(()=>{let e=this.SUBRULE(this.powerExpression);return this.MANY((()=>{const t=this.CONSUME(re),r=this.SUBRULE2(this.powerExpression);var n,s,o;(0,k.tokenMatcher)(t,ne)?(n=e,s=r,o=t.leadingWhitespace,e={type:U.TIMES_OP,left:n,right:s,leadingWhitespace:null==o?void 0:o.image}):(0,k.tokenMatcher)(t,se)?e=((e,t,r)=>({type:U.DIV_OP,left:e,right:t,leadingWhitespace:null==r?void 0:r.image}))(e,r,t.leadingWhitespace):this.ACTION((()=>{throw Error("Operator not supported")}))})),e})),this.additionExpression=this.RULE("additionExpression",(()=>{let e=this.SUBRULE(this.multiplicationExpression);return this.MANY((()=>{const t=this.CONSUME(J),r=this.SUBRULE2(this.multiplicationExpression);var n,s,o;(0,k.tokenMatcher)(t,ee)?(n=e,s=r,o=t.leadingWhitespace,e={type:U.PLUS_OP,left:n,right:s,leadingWhitespace:null==o?void 0:o.image}):(0,k.tokenMatcher)(t,te)?e=((e,t,r)=>({type:U.MINUS_OP,left:e,right:t,leadingWhitespace:null==r?void 0:r.image}))(e,r,t.leadingWhitespace):this.ACTION((()=>{throw Error("Operator not supported")}))})),e})),this.concatenateExpression=this.RULE("concatenateExpression",(()=>{let e=this.SUBRULE(this.additionExpression);return this.MANY((()=>{const t=this.CONSUME(ge),r=this.SUBRULE2(this.additionExpression);var n,s,o;n=e,s=r,o=t.leadingWhitespace,e={type:U.CONCATENATE_OP,left:n,right:s,leadingWhitespace:null==o?void 0:o.image}})),e})),this.booleanExpression=this.RULE("booleanExpression",(()=>{let e=this.SUBRULE(this.concatenateExpression);return this.MANY((()=>{const t=this.CONSUME(ae),r=this.SUBRULE2(this.concatenateExpression);var n,s,o;(0,k.tokenMatcher)(t,le)?(n=e,s=r,o=t.leadingWhitespace,e={type:U.EQUALS_OP,left:n,right:s,leadingWhitespace:null==o?void 0:o.image}):(0,k.tokenMatcher)(t,he)?e=((e,t,r)=>({type:U.NOT_EQUAL_OP,left:e,right:t,leadingWhitespace:null==r?void 0:r.image}))(e,r,t.leadingWhitespace):(0,k.tokenMatcher)(t,ue)?e=((e,t,r)=>({type:U.GREATER_THAN_OP,left:e,right:t,leadingWhitespace:null==r?void 0:r.image}))(e,r,t.leadingWhitespace):(0,k.tokenMatcher)(t,ce)?e=((e,t,r)=>({type:U.LESS_THAN_OP,left:e,right:t,leadingWhitespace:null==r?void 0:r.image}))(e,r,t.leadingWhitespace):(0,k.tokenMatcher)(t,de)?e=((e,t,r)=>({type:U.GREATER_THAN_OR_EQUAL_OP,left:e,right:t,leadingWhitespace:null==r?void 0:r.image}))(e,r,t.leadingWhitespace):(0,k.tokenMatcher)(t,pe)?e=((e,t,r)=>({type:U.LESS_THAN_OR_EQUAL_OP,left:e,right:t,leadingWhitespace:null==r?void 0:r.image}))(e,r,t.leadingWhitespace):this.ACTION((()=>{throw Error("Operator not supported")}))})),e})),this.formula=this.RULE("formula",(()=>(this.CONSUME(le),this.SUBRULE(this.booleanExpression)))),this.lexerConfig=e,this.sheetMapping=t,this.formulaAddress=br(0,0,0),this.performSelfAnalysis()}parseFromTokens(e,t){this.input=e;let r=this.formulaWithContext(t),n=[];return this.customParsingError&&n.push(this.customParsingError),n=n.concat(this.errors.map((e=>({type:F.ParserError,message:e.message})))),n.length>0&&(r=z()),{ast:r,errors:n}}reset(){super.reset(),this.customParsingError=void 0}formulaWithContext(e){return this.formulaAddress=e,this.formula()}buildCellRange(e,t,r){if(void 0===e.sheet&&void 0!==t.sheet)return this.parsingError(F.ParserError,"Malformed range expression");const{firstEnd:n,secondEnd:s,sheetRefType:o}=Ie.fixSheetIdsForRangeEnds(e,t);return W(n,s,o,r)}static fixSheetIdsForRangeEnds(e,t){const r=Ie.rangeSheetReferenceType(e.sheet,t.sheet);return{firstEnd:e,secondEnd:void 0!==e.sheet&&void 0===t.sheet?t.withSheet(e.sheet):t,sheetRefType:r}}handleOffsetHeuristic(e){const t=e[0];if(t.type!==U.CELL_REFERENCE)return this.parsingError(F.StaticOffsetError,"First argument to OFFSET is not a reference");const r=e[1];let n;if(r.type===U.NUMBER&&Number.isInteger(r.value))n=r.value;else if(r.type===U.PLUS_UNARY_OP&&r.value.type===U.NUMBER&&Number.isInteger(r.value.value))n=r.value.value;else{if(r.type!==U.MINUS_UNARY_OP||r.value.type!==U.NUMBER||!Number.isInteger(r.value.value))return this.parsingError(F.StaticOffsetError,"Second argument to OFFSET is not a static number");n=-r.value.value}const o=e[2];let i;if(o.type===U.NUMBER&&Number.isInteger(o.value))i=o.value;else if(o.type===U.PLUS_UNARY_OP&&o.value.type===U.NUMBER&&Number.isInteger(o.value.value))i=o.value.value;else{if(o.type!==U.MINUS_UNARY_OP||o.value.type!==U.NUMBER||!Number.isInteger(o.value.value))return this.parsingError(F.StaticOffsetError,"Third argument to OFFSET is not a static number");i=-o.value.value}const a=e[3];let h;if(void 0===a)h=1;else{if(a.type!==U.NUMBER)return this.parsingError(F.StaticOffsetError,"Fourth argument to OFFSET is not a static number");if(h=a.value,h<1)return this.parsingError(F.StaticOffsetError,"Fourth argument to OFFSET is too small number");if(!Number.isInteger(h))return this.parsingError(F.StaticOffsetError,"Fourth argument to OFFSET is not integer")}const u=e[4];let c;if(void 0===u)c=1;else{if(u.type!==U.NUMBER)return this.parsingError(F.StaticOffsetError,"Fifth argument to OFFSET is not a static number");if(c=u.value,c<1)return this.parsingError(F.StaticOffsetError,"Fifth argument to OFFSET is too small number");if(!Number.isInteger(c))return this.parsingError(F.StaticOffsetError,"Fifth argument to OFFSET is not integer")}const d=new l(t.reference.col+i,t.reference.row+n,t.reference.type);let p=d.col,g=d.row;if(t.reference.type!==s.CELL_REFERENCE_RELATIVE&&t.reference.type!==s.CELL_REFERENCE_ABSOLUTE_COL||(g+=this.formulaAddress.row),t.reference.type!==s.CELL_REFERENCE_RELATIVE&&t.reference.type!==s.CELL_REFERENCE_ABSOLUTE_ROW||(p+=this.formulaAddress.col),p<0||g<0)return j(new Tr(or.REF,Z.OutOfSheet));if(1===c&&1===h)return B(d);{const e=new l(d.col+c-1,d.row+h-1,d.type);return W(d,e,V.RELATIVE)}}parsingError(e,t){return this.customParsingError=H(e,t),z()}static rangeSheetReferenceType(e,t){return void 0===e?V.RELATIVE:void 0===t?V.START_ABSOLUTE:V.BOTH_ABSOLUTE}}class Oe{constructor(e){this.lexerConfig=e,this.lexer=new k.Lexer(e.allTokens,{ensureOptimizations:!0})}tokenizeFormula(e){const t=this.lexer.tokenize(e);let r=t.tokens;return r=this.trimTrailingWhitespaces(r),r=this.skipWhitespacesInsideRanges(r),r=this.skipWhitespacesBeforeArgSeparators(r),t.tokens=r,t}skipWhitespacesInsideRanges(e){return Oe.filterTokensByNeighbors(e,((e,t,r)=>((0,k.tokenMatcher)(e,_e)||(0,k.tokenMatcher)(e,Re))&&(0,k.tokenMatcher)(t,this.lexerConfig.WhiteSpace)&&((0,k.tokenMatcher)(r,_e)||(0,k.tokenMatcher)(r,Re))))}skipWhitespacesBeforeArgSeparators(e){return Oe.filterTokensByNeighbors(e,((e,t,r)=>!(0,k.tokenMatcher)(e,this.lexerConfig.ArgSeparator)&&(0,k.tokenMatcher)(t,this.lexerConfig.WhiteSpace)&&(0,k.tokenMatcher)(r,this.lexerConfig.ArgSeparator)))}static filterTokensByNeighbors(e,t){if(e.length<3)return e;let r=0;const n=[e[r++]];for(;r<e.length-1;)t(e[r-1],e[r],e[r+1])||n.push(e[r]),++r;return n.push(e[r]),n}trimTrailingWhitespaces(e){return e.length>0&&(0,k.tokenMatcher)(e[e.length-1],this.lexerConfig.WhiteSpace)&&e.pop(),e}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class xe{constructor(e,t,r,n){this.config=e,this.lexerConfig=t,this.sheetMappingFn=r,this.namedExpressions=n}unparse(e,t){return"="+this.unparseAst(e,t)}unparseAst(e,t){var r,n;switch(e.type){case U.EMPTY:return K("",e.leadingWhitespace);case U.NUMBER:return K(Pe(e.value,this.config.decimalSeparator),e.leadingWhitespace);case U.STRING:return K('"'+e.value+'"',e.leadingWhitespace);case U.FUNCTION_CALL:{const r=e.args.map((e=>void 0!==e?this.unparseAst(e,t):"")).join(this.config.functionArgSeparator),n=(this.config.translationPackage.isFunctionTranslated(e.procedureName)?this.config.translationPackage.getFunctionTranslation(e.procedureName):e.procedureName)+"("+r+K(")",e.internalWhitespace);return K(n,e.leadingWhitespace)}case U.NAMED_EXPRESSION:return K((null===(r=this.namedExpressions.nearestNamedExpression(e.expressionName,t.sheet))||void 0===r?void 0:r.displayName)||e.expressionName,e.leadingWhitespace);case U.CELL_REFERENCE:{let r;return r=void 0!==e.reference.sheet?this.unparseSheetName(e.reference.sheet)+"!":"",r+=null!==(n=e.reference.unparse(t))&&void 0!==n?n:this.config.translationPackage.getErrorTranslation(or.REF),K(r,e.leadingWhitespace)}case U.COLUMN_RANGE:case U.ROW_RANGE:case U.CELL_RANGE:return K(this.formatRange(e,t),e.leadingWhitespace);case U.PLUS_UNARY_OP:{const r=this.unparseAst(e.value,t);return K("+",e.leadingWhitespace)+r}case U.MINUS_UNARY_OP:{const r=this.unparseAst(e.value,t);return K("-",e.leadingWhitespace)+r}case U.PERCENT_OP:return this.unparseAst(e.value,t)+K("%",e.leadingWhitespace);case U.ERROR:return K(this.config.translationPackage.getErrorTranslation(e.error?e.error.type:or.ERROR),e.leadingWhitespace);case U.ERROR_WITH_RAW_INPUT:return K(e.rawInput,e.leadingWhitespace);case U.PARENTHESIS:{const r="("+this.unparseAst(e.expression,t)+K(")",e.internalWhitespace);return K(r,e.leadingWhitespace)}case U.ARRAY:{const r="{"+e.args.map((e=>e.map((e=>this.unparseAst(e,t))).join(this.config.arrayColumnSeparator))).join(this.config.arrayRowSeparator)+K("}",e.internalWhitespace);return K(r,e.leadingWhitespace)}default:{const r=this.unparseAst(e.left,t),n=this.unparseAst(e.right,t);return r+K(X[e.type],e.leadingWhitespace)+n}}}unparseSheetName(e){const t=L(e,this.sheetMappingFn);if(void 0===t)throw new lt(e);return t}formatRange(e,t){let r="",n="";void 0!==e.start.sheet&&e.sheetReferenceType!==V.RELATIVE&&(r=this.unparseSheetName(e.start.sheet)+"!"),void 0!==e.end.sheet&&e.sheetReferenceType===V.BOTH_ABSOLUTE&&(n=this.unparseSheetName(e.end.sheet)+"!");const s=e.start.unparse(t),o=e.end.unparse(t);return void 0===s||void 0===o?this.config.translationPackage.getErrorTranslation(or.REF):`${r}${s}:${n}${o}`}}function Pe(e,t){return e.toString().replace(".",t)}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Le{constructor(e,t,r){this.config=e,this.functionRegistry=t,this.sheetMapping=r,this.statsCacheUsed=0,this.lexerConfig=be(e),this.lexer=new Oe(this.lexerConfig),this.formulaParser=new Ie(this.lexerConfig,this.sheetMapping),this.cache=new q(this.functionRegistry)}parse(e,t){this.formulaAddress=t;const r=this.tokenizeFormula(e);if(r.errors.length>0){const e=r.errors.map((e=>({type:F.LexingError,message:e.message})));return{ast:z(),errors:e,hasVolatileFunction:!1,hasStructuralChangeFunction:!1,dependencies:[]}}const n=this.computeHashFromTokens(r.tokens,t);let s=this.cache.get(n);if(void 0!==s)++this.statsCacheUsed;else{const e=this.bindWhitespacesToTokens(r.tokens),o=this.formulaParser.parseFromTokens(e,t);if(o.errors.length>0)return Object.assign(Object.assign({},o),{hasVolatileFunction:!1,hasStructuralChangeFunction:!1,dependencies:[]});s=this.cache.set(n,o.ast)}const{ast:o,hasVolatileFunction:i,hasStructuralChangeFunction:a}=s,l=this.convertReversedRangesToRegularRanges(o);return{ast:l,errors:[],hasVolatileFunction:i,hasStructuralChangeFunction:a,dependencies:ke(l,this.functionRegistry)}}convertReversedRangesToRegularRanges(e){switch(e.type){case U.EMPTY:case U.NUMBER:case U.STRING:case U.ERROR:case U.ERROR_WITH_RAW_INPUT:case U.CELL_REFERENCE:case U.NAMED_EXPRESSION:return e;case U.CELL_RANGE:{const{start:t,end:r}=e,n=this.orderCellRangeEnds(t,r);return Object.assign(Object.assign({},e),{start:n.start,end:n.end})}case U.COLUMN_RANGE:{const{start:t,end:r}=e,n=this.orderColumnRangeEnds(t,r);return Object.assign(Object.assign({},e),{start:n.start,end:n.end})}case U.ROW_RANGE:{const{start:t,end:r}=e,n=this.orderRowRangeEnds(t,r);return Object.assign(Object.assign({},e),{start:n.start,end:n.end})}case U.PERCENT_OP:case U.PLUS_UNARY_OP:case U.MINUS_UNARY_OP:{const t=this.convertReversedRangesToRegularRanges(e.value);return Object.assign(Object.assign({},e),{value:t})}case U.CONCATENATE_OP:case U.EQUALS_OP:case U.NOT_EQUAL_OP:case U.LESS_THAN_OP:case U.GREATER_THAN_OP:case U.LESS_THAN_OR_EQUAL_OP:case U.GREATER_THAN_OR_EQUAL_OP:case U.MINUS_OP:case U.PLUS_OP:case U.TIMES_OP:case U.DIV_OP:case U.POWER_OP:{const t=this.convertReversedRangesToRegularRanges(e.left),r=this.convertReversedRangesToRegularRanges(e.right);return Object.assign(Object.assign({},e),{left:t,right:r})}case U.PARENTHESIS:{const t=this.convertReversedRangesToRegularRanges(e.expression);return Object.assign(Object.assign({},e),{expression:t})}case U.FUNCTION_CALL:{const t=e.args.map((e=>this.convertReversedRangesToRegularRanges(e)));return Object.assign(Object.assign({},e),{args:t})}case U.ARRAY:{const t=e.args.map((e=>e.map((e=>this.convertReversedRangesToRegularRanges(e)))));return Object.assign(Object.assign({},e),{args:t})}}}orderCellRangeEnds(e,t){const r=[e,t],[n,s]=r.map((e=>e.toColumnAddress())).sort(i.compareByAbsoluteAddress(this.formulaAddress)),[o,h]=r.map((e=>e.toRowAddress())).sort(a.compareByAbsoluteAddress(this.formulaAddress)),[u,c]=r.map((e=>e.sheet)).sort(Le.compareSheetIds.bind(this));return{start:l.fromColAndRow(n,o,u),end:l.fromColAndRow(s,h,c)}}orderColumnRangeEnds(e,t){const r=[e,t],[n,s]=r.sort(i.compareByAbsoluteAddress(this.formulaAddress)),[o,a]=r.map((e=>e.sheet)).sort(Le.compareSheetIds.bind(this));return{start:new i(n.type,n.col,o),end:new i(s.type,s.col,a)}}orderRowRangeEnds(e,t){const r=[e,t],[n,s]=r.sort(a.compareByAbsoluteAddress(this.formulaAddress)),[o,i]=r.map((e=>e.sheet)).sort(Le.compareSheetIds.bind(this));return{start:new a(n.type,n.row,o),end:new a(s.type,s.row,i)}}static compareSheetIds(e,t){return(e=null!=e?e:1/0)-(t=null!=t?t:1/0)}fetchCachedResultForAst(e){const t=this.computeHashFromAst(e);return this.fetchCachedResult(t)}fetchCachedResult(e){const t=this.cache.get(e);if(void 0===t)throw new Error("There is no AST with such key in the cache");{const{ast:e,hasVolatileFunction:r,hasStructuralChangeFunction:n,relativeDependencies:s}=t;return{ast:e,errors:[],hasVolatileFunction:r,hasStructuralChangeFunction:n,dependencies:s}}}computeHashFromTokens(e,t){var r;let n="",s=0;for(;s<e.length;){const o=e[s];if((0,k.tokenMatcher)(o,_e)){const e=M(this.sheetMapping,o.image,t);n=void 0===e?n.concat(o.image):n.concat(e.hash(!0))}else if((0,k.tokenMatcher)(o,Te)){const e=o.image.toUpperCase().slice(0,-1),t=null!==(r=this.lexerConfig.functionMapping[e])&&void 0!==r?r:e;n=n.concat(t,"(")}else if((0,k.tokenMatcher)(o,ve)){const[e,r]=o.image.split(":"),s=A(this.sheetMapping,e,t),i=A(this.sheetMapping,r,t);n=void 0===s||void 0===i?n.concat("!REF"):n.concat(s.hash(!0),":",i.hash(!0))}else if((0,k.tokenMatcher)(o,Se)){const[e,r]=o.image.split(":"),s=b(this.sheetMapping,e,t),i=b(this.sheetMapping,r,t);n=void 0===s||void 0===i?n.concat("!REF"):n.concat(s.hash(!0),":",i.hash(!0))}else n=n.concat(o.image);s++}return n}rememberNewAst(e){const t=this.computeHashFromAst(e);return this.cache.maybeSetAndThenGet(t,e)}computeHashFromAst(e){return"="+this.computeHashOfAstNode(e)}computeHashOfAstNode(e){switch(e.type){case U.EMPTY:return e.leadingWhitespace||"";case U.NUMBER:return K(Pe(e.value,this.config.decimalSeparator),e.leadingWhitespace);case U.STRING:return K('"'+e.value+'"',e.leadingWhitespace);case U.NAMED_EXPRESSION:return K(e.expressionName,e.leadingWhitespace);case U.FUNCTION_CALL:{const t=e.args.map((e=>this.computeHashOfAstNode(e))).join(this.config.functionArgSeparator),r=e.procedureName+"("+t+K(")",e.internalWhitespace);return K(r,e.leadingWhitespace)}case U.CELL_REFERENCE:return K(e.reference.hash(!0),e.leadingWhitespace);case U.COLUMN_RANGE:case U.ROW_RANGE:case U.CELL_RANGE:return K(e.start.hash(e.sheetReferenceType!==V.RELATIVE)+":"+e.end.hash(e.sheetReferenceType===V.BOTH_ABSOLUTE),e.leadingWhitespace);case U.MINUS_UNARY_OP:return K("-"+this.computeHashOfAstNode(e.value),e.leadingWhitespace);case U.PLUS_UNARY_OP:return K("+"+this.computeHashOfAstNode(e.value),e.leadingWhitespace);case U.PERCENT_OP:return this.computeHashOfAstNode(e.value)+K("%",e.leadingWhitespace);case U.ERROR:return K(this.config.translationPackage.getErrorTranslation(e.error?e.error.type:or.ERROR),e.leadingWhitespace);case U.ERROR_WITH_RAW_INPUT:return K(e.rawInput,e.leadingWhitespace);case U.ARRAY:return K("{"+e.args.map((e=>e.map((e=>this.computeHashOfAstNode(e))).join(","))).join(";")+K("}",e.internalWhitespace),e.leadingWhitespace);case U.PARENTHESIS:{const t="("+this.computeHashOfAstNode(e.expression)+K(")",e.internalWhitespace);return K(t,e.leadingWhitespace)}default:return this.computeHashOfAstNode(e.left)+K(X[e.type],e.leadingWhitespace)+this.computeHashOfAstNode(e.right)}}bindWhitespacesToTokens(e){const t=[],r=e[0];(0,k.tokenMatcher)(r,this.lexerConfig.WhiteSpace)||t.push(r);for(let r=1;r<e.length;++r){const n=e[r];if((0,k.tokenMatcher)(n,this.lexerConfig.WhiteSpace))continue;const s=e[r-1];(0,k.tokenMatcher)(s,this.lexerConfig.WhiteSpace)&&(n.leadingWhitespace=s),t.push(n)}return t}tokenizeFormula(e){return this.lexer.tokenizeFormula(e)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const De=(e,t,r,n)=>{switch(e.type){case U.EMPTY:case U.NUMBER:case U.STRING:case U.ERROR:return;case U.NAMED_EXPRESSION:return void(n&&r.push(new Be(e.expressionName)));case U.CELL_REFERENCE:return void(n&&r.push(new He(e.reference)));case U.CELL_RANGE:return void(n&&e.start.sheet===e.end.sheet&&r.push(new Fe(e.start,e.end)));case U.COLUMN_RANGE:return void(n&&e.start.sheet===e.end.sheet&&r.push(new Ue(e.start,e.end)));case U.ROW_RANGE:return void(n&&e.start.sheet===e.end.sheet&&r.push(new Ve(e.start,e.end)));case U.PERCENT_OP:case U.PLUS_UNARY_OP:case U.MINUS_UNARY_OP:return void De(e.value,t,r,!0);case U.CONCATENATE_OP:case U.EQUALS_OP:case U.NOT_EQUAL_OP:case U.LESS_THAN_OP:case U.GREATER_THAN_OP:case U.LESS_THAN_OR_EQUAL_OP:case U.GREATER_THAN_OR_EQUAL_OP:case U.MINUS_OP:case U.PLUS_OP:case U.TIMES_OP:case U.DIV_OP:case U.POWER_OP:return De(e.left,t,r,!0),void De(e.right,t,r,!0);case U.PARENTHESIS:return void De(e.expression,t,r,n);case U.FUNCTION_CALL:{const n=!t.doesFunctionNeedArgumentToBeComputed(e.procedureName);return void e.args.forEach((e=>De(e,t,r,n)))}}},ke=(e,t)=>{const r=new Array;return De(e,t,r,!0),r};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class He{constructor(e){this.dependency=e}absolutize(e){return this.dependency.toSimpleCellAddress(e)}}class Fe{constructor(e,t){this.start=e,this.end=t}absolutize(e){return new Fr(this.start.toSimpleCellAddress(e),this.end.toSimpleCellAddress(e))}}class Ue{constructor(e,t){this.start=e,this.end=t}absolutize(e){const t=this.start.toSimpleColumnAddress(e),r=this.end.toSimpleColumnAddress(e);return new Ur(t.sheet,t.col,r.col)}}class Ve{constructor(e,t){this.start=e,this.end=t}absolutize(e){const t=this.start.toSimpleRowAddress(e),r=this.end.toSimpleRowAddress(e);return new Vr(t.sheet,t.row,r.row)}}class Be{constructor(e){this.name=e}absolutize(e){return this}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const We=(e,t)=>e.map((e=>e.absolutize(t))),Ye=Symbol("Empty value");function je(e){return e instanceof Ge?e.val:e}class Ge{constructor(e,t){this.val=e,this.format=t}fromNumber(e){return new this.constructor(e)}}function ze(e,t){if("number"==typeof e)return t;{const r=e.fromNumber(t);return r.format=e.format,r}}class $e extends Ge{getDetailedType(){return Je.NUMBER_DATE}}class Ke extends Ge{getDetailedType(){return Je.NUMBER_CURRENCY}}class Xe extends Ge{getDetailedType(){return Je.NUMBER_TIME}}class qe extends Ge{getDetailedType(){return Je.NUMBER_DATETIME}}class Qe extends Ge{getDetailedType(){return Je.NUMBER_PERCENT}}function Ze(e){return"number"==typeof e||e instanceof Ge}var Je,et;function tt(e){return e instanceof Ge?{type:e.getDetailedType(),format:e.format}:{type:Je.NUMBER_RAW}}!function(e){e.NUMBER_RAW="NUMBER_RAW",e.NUMBER_DATE="NUMBER_DATE",e.NUMBER_TIME="NUMBER_TIME",e.NUMBER_DATETIME="NUMBER_DATETIME",e.NUMBER_CURRENCY="NUMBER_CURRENCY",e.NUMBER_PERCENT="NUMBER_PERCENT"}(Je||(Je={}));
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class rt{constructor(e,t,r,n){this._data=e,this.range=t,this.dependencyGraph=r,this._hasOnlyNumbers=n,this.size=void 0===e?new cn(t.effectiveWidth(r),t.effectiveHeight(r)):new cn(e[0].length,e.length)}get data(){return this.ensureThatComputed(),this._data}static fromRange(e,t,r){return new rt(e,t,r,!0)}static onlyNumbers(e){return new rt(e,void 0,void 0,!0)}static onlyValues(e){return new rt(e,void 0,void 0,void 0)}static onlyRange(e,t){return new rt(void 0,e,t,void 0)}static fromScalar(e){return new rt([[e]],void 0,void 0,void 0)}isAdHoc(){return void 0===this.range}width(){return this.size.width}height(){return this.size.height}valuesFromTopLeftCorner(){this.ensureThatComputed();const e=[];for(let t=0;t<this._data.length;t++)for(let r=0;r<this._data[0].length;r++)e.push(this._data[t][r]);return e}*effectiveAddressesFromData(e){for(let t=0;t<this.data.length;++t){const r=this.data[t];for(let n=0;n<r.length;++n)yield br(e.sheet,e.col+n,e.row+t)}}*entriesFromTopLeftCorner(e){this.ensureThatComputed();for(let t=0;t<this.size.height;++t)for(let r=0;r<this.size.width;++r)yield[this._data[t][r],br(e.sheet,e.col+r,e.row+t)]}*iterateValuesFromTopLeftCorner(){yield*this.valuesFromTopLeftCorner()}numberOfElements(){return this.size.width*this.size.height}hasOnlyNumbers(){if(void 0===this._hasOnlyNumbers){this._hasOnlyNumbers=!0;for(const e of this.data)for(const t of e)if("number"!=typeof t)return this._hasOnlyNumbers=!1,!1}return this._hasOnlyNumbers}rawNumbers(){return this._data}rawData(){var e;return this.ensureThatComputed(),null!==(e=this._data)&&void 0!==e?e:[]}sameDimensionsAs(e){return this.width()===e.width()&&this.height()===e.height()}ensureThatComputed(){void 0===this._data&&(this._hasOnlyNumbers=!0,this._data=this.range.addressesArrayMap(this.dependencyGraph,(e=>{const t=this.dependencyGraph.getCellValue(e);return t instanceof rt?(this._hasOnlyNumbers=!1,new Tr(or.VALUE,Z.ScalarExpected)):(Ze(t)||(this._hasOnlyNumbers=!1),t)})))}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class nt{constructor(){this.changes=new Map}static empty(){return new nt}addAll(e){for(const t of e.changes.values())this.add(t.address,t);return this}addChange(e,t,r){this.addInterpreterValue(e,t,r)}exportChanges(e){let t=[];return this.changes.forEach((r=>{const n=e.exportChange(r);Array.isArray(n)?t=t.concat(n):t.push(n)})),t}getChanges(){return Array.from(this.changes.values())}isEmpty(){return 0===this.changes.size}add(e,t){const r=t.value;if(r instanceof rt)for(const t of r.effectiveAddressesFromData(e))this.changes.delete(xr(t));this.changes.set(xr(e),t)}addInterpreterValue(e,t,r){this.add(t,{address:t,value:e,oldValue:r})}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class st{constructor(e,t,r){if(this.sheet=e,this.rowStart=t,this.rowEnd=r,t<0)throw Error("Starting row cant be less than 0");if(r<t)throw Error("Row span cant end before start")}get numberOfRows(){return this.rowEnd-this.rowStart+1}get start(){return this.rowStart}get end(){return this.rowEnd}static fromNumberOfRows(e,t,r){return new st(e,t,t+r-1)}static fromRowStartAndEnd(e,t,r){return new st(e,t,r)}*rows(){for(let e=this.rowStart;e<=this.rowEnd;++e)yield e}intersect(e){if(this.sheet!==e.sheet)throw Error("Can't intersect spans from different sheets");const t=Math.max(this.rowStart,e.rowStart),r=Math.min(this.rowEnd,e.rowEnd);return t>r?null:new st(this.sheet,t,r)}firstRow(){return new st(this.sheet,this.rowStart,this.rowStart)}}class ot{constructor(e,t,r){if(this.sheet=e,this.columnStart=t,this.columnEnd=r,t<0)throw Error("Starting column cant be less than 0");if(r<t)throw Error("Column span cant end before start")}get numberOfColumns(){return this.columnEnd-this.columnStart+1}get start(){return this.columnStart}get end(){return this.columnEnd}static fromNumberOfColumns(e,t,r){return new ot(e,t,t+r-1)}static fromColumnStartAndEnd(e,t,r){return new ot(e,t,r)}*columns(){for(let e=this.columnStart;e<=this.columnEnd;++e)yield e}intersect(e){if(this.sheet!==e.sheet)throw Error("Can't intersect spans from different sheets");const t=Math.max(this.columnStart,e.columnStart),r=Math.min(this.columnEnd,e.columnEnd);return t>r?null:new ot(this.sheet,t,r)}firstColumn(){return new ot(this.sheet,this.columnStart,this.columnStart)}}!function(e){e.BUILD_ENGINE_TOTAL="BUILD_ENGINE_TOTAL",e.PARSER="PARSER",e.GRAPH_BUILD="GRAPH_BUILD",e.COLLECT_DEPENDENCIES="COLLECT_DEPENDENCIES",e.PROCESS_DEPENDENCIES="PROCESS_DEPENDENCIES",e.TOP_SORT="TOP_SORT",e.BUILD_COLUMN_INDEX="BUILD_COLUMN_INDEX",e.EVALUATION="EVALUATION",e.VLOOKUP="VLOOKUP",e.TRANSFORM_ASTS="TRANSFORM_ASTS",e.TRANSFORM_ASTS_POSTPONED="TRANSFORM_ASTS_POSTPONED",e.ADJUSTING_ADDRESS_MAPPING="ADJUSTING_ADDRESS_MAPPING",e.ADJUSTING_ARRAY_MAPPING="ADJUSTING_ARRAY_MAPPING",e.ADJUSTING_RANGES="ADJUSTING_RANGES",e.ADJUSTING_GRAPH="ADJUSTING_GRAPH",e.CRITERION_FUNCTION_FULL_CACHE_USED="CRITERION_FUNCTION_FULL_CACHE_USED",e.CRITERION_FUNCTION_PARTIAL_CACHE_USED="CRITERION_FUNCTION_PARTIAL_CACHE_USED"}(et||(et={}));
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class it{constructor(){this.stats=new Map([[et.CRITERION_FUNCTION_FULL_CACHE_USED,0],[et.CRITERION_FUNCTION_PARTIAL_CACHE_USED,0]]),this.startTimes=new Map}incrementCriterionFunctionFullCacheUsed(){var e;const t=(null!==(e=this.stats.get(et.CRITERION_FUNCTION_FULL_CACHE_USED))&&void 0!==e?e:0)+1;this.stats.set(et.CRITERION_FUNCTION_FULL_CACHE_USED,t)}incrementCriterionFunctionPartialCacheUsed(){var e;const t=(null!==(e=this.stats.get(et.CRITERION_FUNCTION_PARTIAL_CACHE_USED))&&void 0!==e?e:0)+1;this.stats.set(et.CRITERION_FUNCTION_PARTIAL_CACHE_USED,t)}reset(){this.stats.clear(),this.startTimes.clear(),this.stats.set(et.CRITERION_FUNCTION_FULL_CACHE_USED,0),this.stats.set(et.CRITERION_FUNCTION_PARTIAL_CACHE_USED,0)}start(e){if(this.startTimes.get(e))throw Error(`Statistics ${e} already started`);this.startTimes.set(e,Date.now())}end(e){var t;const r=Date.now(),n=this.startTimes.get(e);if(!n)throw Error(`Statistics ${e} not started`);{let s=null!==(t=this.stats.get(e))&&void 0!==t?t:0;s+=r-n,this.stats.set(e,s),this.startTimes.delete(e)}}measure(e,t){this.start(e);const r=t();return this.end(e),r}snapshot(){return new Map(this.stats)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class at extends it{incrementCriterionFunctionFullCacheUsed(){}incrementCriterionFunctionPartialCacheUsed(){}start(e){}end(e){}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class lt extends Error{constructor(e){super(`There's no sheet with id = ${e}`)}}class ht extends Error{constructor(e){super(`There's no sheet with name '${e}'`)}}class ut extends Error{constructor(e){super(`Sheet with name ${e} already exists`)}}class ct extends Error{constructor(){super("Sheet size limit exceeded")}}class dt extends Error{constructor(){super("This is not a formula")}}class pt extends Error{constructor(e){super(`Address (row = ${e.row}, col = ${e.col}) is invalid`)}}class gt extends Error{constructor(e){super(`Invalid arguments, expected ${e}`)}}class ft extends Error{constructor(e,t){super(`Sheets ${e} and ${t} are not equal.`)}}class mt extends Error{constructor(e){super(`Name of Named Expression '${e}' is already present`)}}class Et extends Error{constructor(e){super(`Name of Named Expression '${e}' is invalid`)}}class yt extends Error{constructor(e){super(`Named Expression '${e}' does not exist`)}}class wt extends Error{constructor(){super("There is no operation to undo")}}class Ct extends Error{constructor(){super("There is no operation to redo")}}class Rt extends Error{constructor(){super("There is nothing to paste")}}function vt(e,t){switch(typeof t){case"function":case"symbol":return t.toString();case"bigint":return"BigInt("+t.toString()+")";default:return t instanceof RegExp?"RegExp("+t.toString()+")":t}}class St extends Error{constructor(e){super(`Unable to parse value: ${JSON.stringify(e,vt,4)}`)}}class Tt extends Error{constructor(e,t){super(`Expected value of type: ${e} for config parameter: ${t}`)}}class Nt extends Error{constructor(e){super(`Config parameter ${e} cannot be empty.`)}}class _t extends Error{constructor(e,t){super(`Config parameter ${e} should be at least ${t}`)}}class Mt extends Error{constructor(e,t){super(`Config parameter ${e} should be at most ${t}`)}}class At extends Error{constructor(e,t){super(`Expected one of ${e} for config parameter: ${t}`)}}class bt extends Error{constructor(){super("Computations are suspended")}}class It extends Error{constructor(e){super(`Translation for ${e} is missing in the translation package you're using.`)}}class Ot extends Error{constructor(e){super(`Cannot register translation for function with id: ${e}`)}}class xt extends Error{constructor(){super("Language not registered.")}}class Pt extends Error{constructor(){super("Language already registered.")}}class Lt extends Error{static functionNotDeclaredInPlugin(e,t){return new Lt(`Function with id ${e} not declared in plugin ${t}`)}static functionMethodNotFound(e,t){return new Lt(`Function method ${e} not found in plugin ${t}`)}}class Dt extends Error{static cannotRegisterFunctionWithId(e){return new Dt(`Cannot register function with id ${e}`)}static cannotUnregisterFunctionWithId(e){return new Dt(`Cannot unregister function with id ${e}`)}static cannotUnregisterProtectedPlugin(){return new Dt("Cannot unregister protected plugin")}}class kt extends Error{constructor(){super("Cannot perform this operation, source location has an array inside.")}}class Ht extends Error{constructor(){super("Cannot perform this operation, target location has an array inside.")}}class Ft extends Error{constructor(){super("Relative addresses not allowed in named expressions.")}}class Ut extends Error{constructor(e,t){super(`Alias id ${e} in plugin ${t} already defined as a function or alias.`)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Vt{constructor(e){this.policy=e,this.mapping=new Map}getCell(e){const t=this.mapping.get(e.sheet);if(void 0===t)throw new lt(e.sheet);return t.getCell(e)}fetchCell(e){const t=this.mapping.get(e.sheet);if(void 0===t)throw new lt(e.sheet);const r=t.getCell(e);if(!r)throw Error("Vertex for address missing in AddressMapping");return r}strategyFor(e){const t=this.mapping.get(e);if(void 0===t)throw new lt(e);return t}addSheet(e,t){if(this.mapping.has(e))throw Error("Sheet already added");this.mapping.set(e,t)}autoAddSheet(e,t){const{height:r,width:n,fill:s}=t,o=this.policy.call(s);this.addSheet(e,new o(n,r))}getCellValue(e){const t=this.getCell(e);return void 0===t?Ye:t instanceof zt?t.getArrayCellValue(e):t.getCellValue()}getRawValue(e){const t=this.getCell(e);return t instanceof dr?t.getValues().rawValue:t instanceof zt?t.getArrayCellRawValue(e):null}setCell(e,t){const r=this.mapping.get(e.sheet);if(!r)throw Error("Sheet not initialized");r.setCell(e,t)}moveCell(e,t){const r=this.mapping.get(e.sheet);if(!r)throw Error("Sheet not initialized.");if(e.sheet!==t.sheet)throw Error("Cannot move cells between sheets.");if(r.has(t))throw new Error("Cannot move cell. Destination already occupied.");const n=r.getCell(e);if(void 0===n)throw new Error("Cannot move cell. No cell with such address.");this.setCell(t,n),this.removeCell(e)}removeCell(e){const t=this.mapping.get(e.sheet);if(!t)throw Error("Sheet not initialized");t.removeCell(e)}has(e){const t=this.mapping.get(e.sheet);return void 0!==t&&t.has(e)}getHeight(e){const t=this.mapping.get(e);if(void 0===t)throw new lt(e);return t.getHeight()}getWidth(e){const t=this.mapping.get(e);if(!t)throw new lt(e);return t.getWidth()}addRows(e,t,r){const n=this.mapping.get(e);if(void 0===n)throw new lt(e);n.addRows(t,r)}removeRows(e){const t=this.mapping.get(e.sheet);if(void 0===t)throw new lt(e.sheet);t.removeRows(e)}removeSheet(e){this.mapping.delete(e)}addColumns(e,t,r){const n=this.mapping.get(e);if(void 0===n)throw new lt(e);n.addColumns(t,r)}removeColumns(e){const t=this.mapping.get(e.sheet);if(void 0===t)throw new lt(e.sheet);t.removeColumns(e)}*verticesFromRowsSpan(e){yield*this.mapping.get(e.sheet).verticesFromRowsSpan(e)}*verticesFromColumnsSpan(e){yield*this.mapping.get(e.sheet).verticesFromColumnsSpan(e)}*entriesFromRowsSpan(e){yield*this.mapping.get(e.sheet).entriesFromRowsSpan(e)}*entriesFromColumnsSpan(e){yield*this.mapping.get(e.sheet).entriesFromColumnsSpan(e)}*entries(){for(const[e,t]of this.mapping.entries())yield*t.getEntries(e)}*sheetEntries(e){const t=this.mapping.get(e);if(void 0===t)throw new lt(e);yield*t.getEntries(e)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Bt{constructor(){this.arrayMapping=new Map}getArray(e){const t=this.getArrayByCorner(e.start);if(null==t?void 0:t.getRange().sameAs(e))return t}getArrayByCorner(e){return this.arrayMapping.get(xr(e))}setArray(e,t){this.arrayMapping.set(xr(e.start),t)}removeArray(e){"string"==typeof e?this.arrayMapping.delete(e):this.arrayMapping.delete(xr(e.start))}count(){return this.arrayMapping.size}*arraysInRows(e){for(const[t,r]of this.arrayMapping.entries())r.spansThroughSheetRows(e.sheet,e.rowStart,e.rowEnd)&&(yield[t,r])}*arraysInCols(e){for(const[t,r]of this.arrayMapping.entries())r.spansThroughSheetColumn(e.sheet,e.columnStart,e.columnEnd)&&(yield[t,r])}isFormulaArrayInRow(e,t){for(const r of this.arrayMapping.values())if(r.spansThroughSheetRows(e,t))return!0;return!1}isFormulaArrayInAllRows(e){let t=!0;for(const r of e.rows())this.isFormulaArrayInRow(e.sheet,r)||(t=!1);return t}isFormulaArrayInColumn(e,t){for(const r of this.arrayMapping.values())if(r.spansThroughSheetColumn(e,t))return!0;return!1}isFormulaArrayInAllColumns(e){let t=!0;for(const r of e.columns())this.isFormulaArrayInColumn(e.sheet,r)||(t=!1);return t}isFormulaArrayInRange(e){for(const t of this.arrayMapping.values())if(t.getRange().doesOverlap(e))return!0;return!1}isFormulaArrayAtAddress(e){for(const t of this.arrayMapping.values())if(t.getRange().addressInRange(e))return!0;return!1}moveArrayVerticesAfterRowByRows(e,t,r){this.updateArrayVerticesInSheet(e,((e,n)=>{const s=n.getRange();return t<=s.start.row?[s.shifted(0,r),n]:void 0}))}moveArrayVerticesAfterColumnByColumns(e,t,r){this.updateArrayVerticesInSheet(e,((e,n)=>{const s=n.getRange();return t<=s.start.col?[s.shifted(r,0),n]:void 0}))}updateArrayVerticesInSheet(e,t){const r=Array();for(const[n,s]of this.arrayMapping.entries()){if(s.sheet!==e)continue;const o=t(n,s);void 0!==o&&(this.removeArray(n),r.push(o))}r.forEach((([e,t])=>{this.setArray(e,t)}))}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Wt{constructor(e){this.size=e}width(){return this.size.width}height(){return this.size.height}get(e,t){throw Error("Array not computed yet.")}simpleRangeValue(){throw Error("Array not computed yet.")}}class Yt{constructor(e){if(this.size=new cn(e.length>0?e[0].length:0,e.length),this.array=e,this.size.width<=0||this.size.height<=0)throw Error("Incorrect array size")}static fromInterpreterValue(e){return new Yt(e instanceof rt?e.data:[[e]])}simpleRangeValue(){return rt.onlyValues(this.array)}addRows(e,t){this.array.splice(e,0,...this.nullArrays(t,this.width())),this.size.height+=t}addColumns(e,t){for(let r=0;r<this.height();r++)this.array[r].splice(e,0,...new Array(t).fill(Ye));this.size.width+=t}removeRows(e,t){if(this.outOfBound(0,e)||this.outOfBound(0,t))throw Error("Array index out of bound");const r=t-e+1;this.array.splice(e,r),this.size.height-=r}removeColumns(e,t){if(this.outOfBound(e,0)||this.outOfBound(t,0))throw Error("Array index out of bound");const r=t-e+1;for(const t of this.array)t.splice(e,r);this.size.width-=r}nullArrays(e,t){const r=[];for(let n=0;n<e;++n)r.push(new Array(t).fill(Ye));return r}get(e,t){if(this.outOfBound(e,t))throw Error("Array index out of bound");return this.array[t][e]}set(e,t,r){if(this.outOfBound(e,t))throw Error("Array index out of bound");this.array[t][e]=r}width(){return this.size.width}height(){return this.size.height}raw(){return this.array}resize(e){if(this.height()<e.height&&isFinite(e.height)&&this.addRows(this.height(),e.height-this.height()),this.height()>e.height)throw Error("Resizing to smaller array");if(this.width()<e.width&&isFinite(e.width)&&this.addColumns(this.width(),e.width-this.width()),this.width()>e.width)throw Error("Resizing to smaller array")}outOfBound(e,t){return e<0||t<0||t>this.size.height-1||e>this.size.width-1}}class jt{constructor(e,t){this.error=e,this.size=t}get(e,t){return this.error}width(){return this.size.width}height(){return this.size.height}simpleRangeValue(){return this.error}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Gt{constructor(e,t,r){this.formula=e,this.cellAddress=t,this.version=r}get width(){return 1}get height(){return 1}static fromAst(e,t,r,n){return r.isScalar()?new $t(e,t,n):new zt(e,t,r,n)}getFormula(e){return this.ensureRecentData(e),this.formula}ensureRecentData(e){if(this.version!=e.version()){const[t,r,n]=e.applyTransformations(this.formula,this.cellAddress,this.version);this.formula=t,this.cellAddress=r,this.version=n}}getAddress(e){return this.ensureRecentData(e),this.cellAddress}}class zt extends Gt{constructor(e,t,r,n=0){super(e,t,n),r.isRef?this.array=new jt(new Tr(or.REF,Z.NoSpaceForArrayResult),cn.error()):this.array=new Wt(r)}get width(){return this.array.width()}get height(){return this.array.height()}get sheet(){return this.cellAddress.sheet}get leftCorner(){return this.cellAddress}setCellValue(e){if(e instanceof Tr)return this.setErrorValue(e),e;const t=Yt.fromInterpreterValue(e);return t.resize(this.array.size),this.array=t,e}getCellValue(){if(this.array instanceof Wt)throw Error("Array not computed yet.");return this.array.simpleRangeValue()}valueOrUndef(){if(!(this.array instanceof Wt))return this.array.simpleRangeValue()}getArrayCellValue(e){const t=e.col-this.cellAddress.col,r=e.row-this.cellAddress.row;try{return this.array.get(t,r)}catch(e){return new Tr(or.REF)}}getArrayCellRawValue(e){const t=this.getArrayCellValue(e);return t instanceof Tr||t===Ye?void 0:je(t)}setArrayCellValue(e,t){const r=e.col-this.cellAddress.col,n=e.row-this.cellAddress.row;this.array instanceof Yt&&this.array.set(r,n,t)}setNoSpace(){return this.array=new jt(new Tr(or.SPILL,Z.NoSpaceForArrayResult),cn.error()),this.getCellValue()}getRange(){return Fr.spanFrom(this.cellAddress,this.width,this.height)}getRangeOrUndef(){return Fr.spanFromOrUndef(this.cellAddress,this.width,this.height)}setAddress(e){this.cellAddress=e}setFormula(e){this.formula=e}spansThroughSheetRows(e,t,r=t){return this.cellAddress.sheet===e&&this.cellAddress.row<=r&&t<this.cellAddress.row+this.height}spansThroughSheetColumn(e,t,r=t){return this.cellAddress.sheet===e&&this.cellAddress.col<=r&&t<this.cellAddress.col+this.width}isComputed(){return!(this.array instanceof Wt)}columnsFromArray(){return ot.fromNumberOfColumns(this.cellAddress.sheet,this.cellAddress.col,this.width)}rowsFromArray(){return st.fromNumberOfRows(this.cellAddress.sheet,this.cellAddress.row,this.height)}ensureRecentData(e){}isLeftCorner(e){return Dr(this.cellAddress,e)}setErrorValue(e){this.array=new jt(e,this.array.size)}}class $t extends Gt{constructor(e,t,r){super(e,t,r)}valueOrUndef(){return this.cachedCellValue}setCellValue(e){return this.cachedCellValue=e,this.cachedCellValue}getCellValue(){if(void 0!==this.cachedCellValue)return this.cachedCellValue;throw Error("Value of the formula cell is not computed.")}isComputed(){return void 0!==this.cachedCellValue}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Kt{constructor(e){this.range=e,this.functionCache=new Map,this.criterionFunctionCache=new Map,this.dependentCacheRanges=new Set,this.bruteForce=!1}get start(){return this.range.start}get end(){return this.range.end}get sheet(){return this.range.start.sheet}getFunctionValue(e){return this.functionCache.get(e)}setFunctionValue(e,t){this.functionCache.set(e,t)}getCriterionFunctionValue(e,t){var r;return null===(r=this.getCriterionFunctionValues(e).get(t))||void 0===r?void 0:r[0]}getCriterionFunctionValues(e){var t;return null!==(t=this.criterionFunctionCache.get(e))&&void 0!==t?t:new Map}setCriterionFunctionValues(e,t){this.criterionFunctionCache.set(e,t)}addDependentCacheRange(e){e!==this&&this.dependentCacheRanges.add(e)}clearCache(){this.functionCache.clear(),this.criterionFunctionCache.clear(),this.dependentCacheRanges.forEach((e=>e.criterionFunctionCache.clear())),this.dependentCacheRanges.clear()}getStart(){return this.start}getEnd(){return this.end}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const Xt=(e,t,r,n,s)=>{if(t instanceof Kt){const e=t.range.intersectionWith(r);return void 0!==e?Array.from(e.addresses(s)):[]}let o,i;return t instanceof Gt?(o=t.getFormula(n),i=t.getAddress(n),ke(o,e).filter((e=>e instanceof He)).map((e=>e.dependency.toSimpleCellAddress(i))).filter((e=>r.addressInRange(e)))):[]};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
var qt;!function(e){e[e.ON_STACK=0]="ON_STACK",e[e.PROCESSED=1]="PROCESSED",e[e.POPPED=2]="POPPED"}(qt||(qt={}));class Qt{constructor(e=[],t=[]){this.nodesSparseArray=e,this.edgesSparseArray=t,this.entranceTime=[],this.low=[],this.parent=[],this.inSCC=[],this.nodeStatus=[],this.order=[],this.sccNonSingletons=[],this.timeCounter=0}getTopSortedWithSccSubgraphFrom(e,t,r){const n=e.reverse();return n.forEach((e=>this.runDFS(e))),this.postprocess(n,r,t)}getAdjacentNodeIds(e){return this.edgesSparseArray[e].filter((e=>void 0!==e&&this.nodesSparseArray[e]))}runDFS(e){if(void 0!==this.nodeStatus[e])return;this.nodeStatus[e]=qt.ON_STACK;const t=[e],r=[];for(;t.length>0;){const e=t[t.length-1];switch(this.nodeStatus[e]){case qt.ON_STACK:this.handleOnStack(e,r,t);break;case qt.PROCESSED:this.handleProcessed(e,r,t);break;case qt.POPPED:t.pop()}}}handleOnStack(e,t,r){this.entranceTime[e]=this.timeCounter,this.low[e]=this.timeCounter,this.timeCounter++,t.push(e),this.getAdjacentNodeIds(e).forEach((t=>{void 0===this.entranceTime[t]&&(r.push(t),this.parent[t]=e,this.nodeStatus[t]=qt.ON_STACK)})),this.nodeStatus[e]=qt.PROCESSED}handleProcessed(e,t,r){let n=this.entranceTime[e];if(this.getAdjacentNodeIds(e).forEach((t=>{this.inSCC[t]||(n=this.parent[t]===e?Math.min(n,this.low[t]):Math.min(n,this.entranceTime[t]))})),this.low[e]=n,n===this.entranceTime[e]){const r=[];do{r.push(t[t.length-1]),t.pop()}while(r[r.length-1]!==e);r.forEach((e=>{this.inSCC[e]=!0})),this.order.push(...r),r.length>1&&r.forEach((e=>{this.sccNonSingletons[e]=!0}))}r.pop(),this.nodeStatus[e]=qt.POPPED}postprocess(e,t,r){const n=[];e.forEach((e=>{n[e]=!0}));const s=[],o=[];return this.order.reverse(),this.order.forEach((e=>{const i=this.getAdjacentNodeIds(e);this.sccNonSingletons[e]||i.includes(e)?(o.push(this.nodesSparseArray[e]),t(this.nodesSparseArray[e]),i.forEach((e=>n[e]=!0))):(s.push(this.nodesSparseArray[e]),n[e]&&r(this.nodesSparseArray[e])&&i.forEach((e=>n[e]=!0)))})),{sorted:s,cycled:o}}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Zt{constructor(e,t){this.rawValue=e,this.processFn=t,this.processedValue=null}getProcessedValue(){return null===this.processedValue&&(this.processedValue=this.processFn(this.rawValue)),this.processedValue}markAsModified(){this.processedValue=null}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Jt{constructor(e){this.dependencyQuery=e,this.nodesSparseArray=[],this.edgesSparseArray=[],this.nodesIds=new Map,this.dirtyAndVolatileNodeIds=new Zt({dirty:[],volatile:[]},(e=>this.processDirtyAndVolatileNodeIds(e))),this.infiniteRangeIds=new Set,this.changingWithStructureNodeIds=[],this.nextId=0}getNodes(){return this.nodesSparseArray.filter((e=>void 0!==e))}hasNode(e){return this.nodesIds.has(e)}existsEdge(e,t){const r=this.getNodeId(e),n=this.getNodeId(t);return void 0!==r&&void 0!==n&&this.edgesSparseArray[r].includes(n)}adjacentNodes(e){const t=this.getNodeId(e);if(void 0===t)throw this.missingNodeError(e);return new Set(this.edgesSparseArray[t].filter((e=>void 0!==e)).map((e=>this.nodesSparseArray[e])))}adjacentNodesCount(e){const t=this.getNodeId(e);if(void 0===t)throw this.missingNodeError(e);return this.fixEdgesArrayForNode(t).length}addNodeAndReturnId(e){const t=this.nodesIds.get(e);if(void 0!==t)return t;const r=this.nextId;return this.nextId++,this.nodesSparseArray[r]=e,this.edgesSparseArray[r]=[],this.nodesIds.set(e,r),r}addEdge(e,t){const r=this.getNodeIdIfNotNumber(e),n=this.getNodeIdIfNotNumber(t);if(void 0===r)throw this.missingNodeError(e);if(void 0===n)throw this.missingNodeError(t);this.edgesSparseArray[r].includes(n)||this.edgesSparseArray[r].push(n)}removeNode(e){const t=this.getNodeId(e);if(void 0===t)throw this.missingNodeError(e);this.edgesSparseArray[t].length>0&&(this.edgesSparseArray[t].forEach((e=>this.dirtyAndVolatileNodeIds.rawValue.dirty.push(e))),this.dirtyAndVolatileNodeIds.markAsModified());const r=this.removeDependencies(e);return delete this.nodesSparseArray[t],delete this.edgesSparseArray[t],this.infiniteRangeIds.delete(t),this.nodesIds.delete(e),r}removeEdge(e,t){const r=this.getNodeIdIfNotNumber(e),n=this.getNodeIdIfNotNumber(t);if(void 0===r)throw this.missingNodeError(e);if(void 0===n)throw this.missingNodeError(t);const s=this.edgesSparseArray[r].indexOf(n);if(-1===s)throw new Error("Edge does not exist");delete this.edgesSparseArray[r][s]}removeEdgeIfExists(e,t){const r=this.getNodeId(e),n=this.getNodeId(t);if(void 0===r)return;if(void 0===n)return;const s=this.edgesSparseArray[r].indexOf(n);-1!==s&&delete this.edgesSparseArray[r][s]}topSortWithScc(){return this.getTopSortedWithSccSubgraphFrom(this.getNodes(),(()=>!0),(()=>{}))}getTopSortedWithSccSubgraphFrom(e,t,r){const n=new Qt(this.nodesSparseArray,this.edgesSparseArray),s=e.map((e=>this.getNodeId(e))).filter((e=>void 0!==e));return n.getTopSortedWithSccSubgraphFrom(s,t,r)}markNodeAsVolatile(e){const t=this.getNodeId(e);void 0!==t&&(this.dirtyAndVolatileNodeIds.rawValue.volatile.push(t),this.dirtyAndVolatileNodeIds.markAsModified())}markNodeAsDirty(e){const t=this.getNodeId(e);void 0!==t&&(this.dirtyAndVolatileNodeIds.rawValue.dirty.push(t),this.dirtyAndVolatileNodeIds.markAsModified())}getDirtyAndVolatileNodes(){return this.dirtyAndVolatileNodeIds.getProcessedValue()}clearDirtyNodes(){this.dirtyAndVolatileNodeIds.rawValue.dirty=[],this.dirtyAndVolatileNodeIds.markAsModified()}markNodeAsChangingWithStructure(e){const t=this.getNodeId(e);void 0!==t&&this.changingWithStructureNodeIds.push(t)}markChangingWithStructureNodesAsDirty(){this.changingWithStructureNodeIds.length<=0||(this.dirtyAndVolatileNodeIds.rawValue.dirty=[...this.dirtyAndVolatileNodeIds.rawValue.dirty,...this.changingWithStructureNodeIds],this.dirtyAndVolatileNodeIds.markAsModified())}markNodeAsInfiniteRange(e){const t=this.getNodeIdIfNotNumber(e);void 0!==t&&this.infiniteRangeIds.add(t)}getInfiniteRanges(){return[...this.infiniteRangeIds].map((e=>({node:this.nodesSparseArray[e],id:e})))}getNodeId(e){return this.nodesIds.get(e)}getNodeIdIfNotNumber(e){return"number"==typeof e?e:this.nodesIds.get(e)}fixEdgesArrayForNode(e){const t=this.edgesSparseArray[e];return this.edgesSparseArray[e]=t.filter((e=>void 0!==e&&this.nodesSparseArray[e])),this.edgesSparseArray[e]}removeDependencies(e){const t=this.dependencyQuery(e);return t.forEach((([t,r])=>{this.removeEdgeIfExists(r,e)})),t}processDirtyAndVolatileNodeIds({dirty:e,volatile:t}){return[...new Set([...e,...t])].map((e=>this.nodesSparseArray[e])).filter((e=>void 0!==e))}missingNodeError(e){return new Error(`Unknown node ${e}`)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class er{constructor(){this.rangeMapping=new Map}getMappingSize(e){var t,r;return null!==(r=null===(t=this.rangeMapping.get(e))||void 0===t?void 0:t.size)&&void 0!==r?r:0}setRange(e){let t=this.rangeMapping.get(e.getStart().sheet);void 0===t&&(t=new Map,this.rangeMapping.set(e.getStart().sheet,t));const r=tr(e.getStart(),e.getEnd());t.set(r,e)}removeRange(e){const t=e.getStart().sheet,r=this.rangeMapping.get(t);if(void 0===r)return;const n=tr(e.getStart(),e.getEnd());r.delete(n),0===r.size&&this.rangeMapping.delete(t)}getRange(e,t){const r=this.rangeMapping.get(e.sheet),n=tr(e,t);return null==r?void 0:r.get(n)}fetchRange(e,t){const r=this.getRange(e,t);if(!r)throw Error("Range does not exist");return r}truncateRanges(e,t){const r=Array(),n=Array(),s=Array(),o=e.sheet;for(const[i,a]of this.entriesFromSheet(e.sheet)){const l=a.range;e.start<=t(a.range.end)&&(l.removeSpan(e),l.shouldBeRemoved()?(this.removeByKey(o,i),r.push(a)):n.push([i,a]),s.push(a))}const i=[];n.sort(((e,r)=>rr(e[1],r[1],t)));for(const[e,t]of n){const r=tr((a=t.range).start,a.end);if(r===e)continue;const n=this.getByKey(o,r);this.removeByKey(o,e),void 0!==n&&t!=n?i.push([n,t]):this.setRange(t)}var a;return{verticesToRemove:r,verticesToMerge:i,verticesWithChangedSize:s}}moveAllRangesInSheetAfterRowByRows(e,t,r){return this.updateVerticesFromSheet(e,((e,n)=>t<=n.start.row?(n.range.shiftByRows(r),{changedSize:!1,vertex:n}):t>n.start.row&&t<=n.end.row?(n.range.expandByRows(r),{changedSize:!0,vertex:n}):void 0))}moveAllRangesInSheetAfterColumnByColumns(e,t,r){return this.updateVerticesFromSheet(e,((e,n)=>t<=n.start.col?(n.range.shiftByColumns(r),{changedSize:!1,vertex:n}):t>n.start.col&&t<=n.end.col?(n.range.expandByColumns(r),{changedSize:!0,vertex:n}):void 0))}moveRangesInsideSourceRange(e,t,r,n){this.updateVerticesFromSheet(e.sheet,((s,o)=>e.containsRange(o.range)?(o.range.shiftByColumns(t),o.range.shiftByRows(r),o.range.moveToSheet(n),{changedSize:!1,vertex:o}):void 0))}removeRangesInSheet(e){if(this.rangeMapping.has(e)){const t=this.rangeMapping.get(e).values();return this.rangeMapping.delete(e),t}return[][Symbol.iterator]()}*rangesInSheet(e){const t=this.rangeMapping.get(e);t&&(yield*t.values())}*rangeVerticesContainedInRange(e){for(const t of this.rangesInSheet(e.sheet))e.containsRange(t.range)&&(yield t)}findSmallerRange(e){if(e.height()>1&&Number.isFinite(e.height())){const t=br(e.end.sheet,e.end.col,e.end.row-1),r=this.getRange(e.start,t);if(void 0!==r){return{smallerRangeVertex:r,restRange:Fr.fromSimpleCellAddresses(br(e.start.sheet,e.start.col,e.end.row),e.end)}}}return{restRange:e}}*entriesFromSheet(e){const t=this.rangeMapping.get(e);t&&(yield*t.entries())}removeByKey(e,t){this.rangeMapping.get(e).delete(t)}getByKey(e,t){var r;return null===(r=this.rangeMapping.get(e))||void 0===r?void 0:r.get(t)}updateVerticesFromSheet(e,t){const r=Array();for(const[n,s]of this.entriesFromSheet(e)){const o=t(n,s);void 0!==o&&(this.removeByKey(e,n),r.push(o))}return r.forEach((e=>{this.setRange(e.vertex)})),{verticesWithChangedSize:r.filter((e=>e.changedSize)).map((e=>e.vertex))}}}function tr(e,t){return`${e.col},${e.row},${t.col},${t.row}`}const rr=(e,t,r)=>{const n=r(e.range.start),s=r(e.range.start);if(n===s){return r(e.range.end)-r(t.range.end)}return n-s};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class nr{constructor(e,t,r){this.functions=e,this.errors=t,this.ui=r,this._protectedTranslations={VERSION:"VERSION"},this.checkUI(),this.checkErrors(),this.checkFunctionTranslations(this.functions),Object.assign(this.functions,this._protectedTranslations)}extendFunctions(e){this.checkFunctionTranslations(e),Object.assign(this.functions,e)}buildFunctionMapping(){return Object.keys(this.functions).reduce(((e,t)=>(e[this.functions[t]]=t,e)),{})}buildErrorMapping(){return Object.keys(this.errors).reduce(((e,t)=>(e[this.errors[t]]=t,e)),{})}isFunctionTranslated(e){return void 0!==this.functions[e]}getFunctionTranslations(e){const t=[];for(const r of e)this.isFunctionTranslated(r)&&t.push(this.functions[r]);return t}getFunctionTranslation(e){const t=this.functions[e];if(void 0===t)throw new It(`functions.${e}`);return t}getMaybeFunctionTranslation(e){return this.functions[e]}getErrorTranslation(e){if(e===or.LIC)return`#${or.LIC}!`;const t=this.errors[e];if(void 0===t)throw new It(`errors.${e}`);return t}getUITranslation(e){const t=this.ui[e];if(void 0===t)throw new It(`ui.${e}`);return t}checkUI(){for(const e of Object.values(sr))if(!(e in this.ui))throw new It(`ui.${e}`)}checkErrors(){for(const e of Object.values(or))if(!(e in this.errors)&&e!==or.LIC)throw new It(`errors.${e}`)}checkFunctionTranslations(e){const t=new Set(Object.getOwnPropertyNames(e));for(const e of Object.getOwnPropertyNames(this._protectedTranslations))if(t.has(e))throw new Ot(e)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
var sr,or,ir;
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function ar(e){return e.toLowerCase()}!function(e){e.NEW_SHEET_PREFIX="NEW_SHEET_PREFIX"}(sr||(sr={}));class lr{constructor(e,t){this.id=e,this.displayName=t}get canonicalName(){return ar(this.displayName)}}class hr{constructor(e){this.languages=e,this.mappingFromCanonicalName=new Map,this.mappingFromId=new Map,this.lastSheetId=-1,this.fetch=e=>{const t=this.mappingFromCanonicalName.get(ar(e));if(void 0===t)throw new ht(e);return t.id},this.get=e=>{var t;return null===(t=this.mappingFromCanonicalName.get(ar(e)))||void 0===t?void 0:t.id},this.fetchDisplayName=e=>this.fetchSheetById(e).displayName,this.sheetNamePrefix=e.getUITranslation(sr.NEW_SHEET_PREFIX)}addSheet(e=`${this.sheetNamePrefix}${this.lastSheetId+2}`){const t=ar(e);if(this.mappingFromCanonicalName.has(t))throw new ut(e);this.lastSheetId++;const r=new lr(this.lastSheetId,e);return this.store(r),r.id}removeSheet(e){const t=this.fetchSheetById(e);e==this.lastSheetId&&--this.lastSheetId,this.mappingFromCanonicalName.delete(t.canonicalName),this.mappingFromId.delete(t.id)}getDisplayName(e){var t;return null===(t=this.mappingFromId.get(e))||void 0===t?void 0:t.displayName}*displayNames(){for(const e of this.mappingFromCanonicalName.values())yield e.displayName}numberOfSheets(){return this.mappingFromCanonicalName.size}hasSheetWithId(e){return this.mappingFromId.has(e)}hasSheetWithName(e){return this.mappingFromCanonicalName.has(ar(e))}renameSheet(e,t){const r=this.fetchSheetById(e),n=r.displayName;if(n===t)return;const s=this.mappingFromCanonicalName.get(ar(t));if(void 0!==s&&s.id!==r.id)throw new ut(t);const o=r.canonicalName;return this.mappingFromCanonicalName.delete(o),r.displayName=t,this.store(r),n}sheetNames(){return Array.from(this.mappingFromId.values()).map((e=>e.displayName))}store(e){this.mappingFromId.set(e.id,e),this.mappingFromCanonicalName.set(e.canonicalName,e)}fetchSheetById(e){const t=this.mappingFromId.get(e);if(void 0===t)throw new lt(e);return t}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ur{constructor(e,t,r,n,s,o,i,a){this.addressMapping=e,this.rangeMapping=t,this.sheetMapping=r,this.arrayMapping=n,this.stats=s,this.lazilyTransformingAstService=o,this.functionRegistry=i,this.namedExpressions=a,this.changes=nt.empty(),this.dependencyQueryAddresses=e=>{if(e instanceof Kt)return this.rangeDependencyQuery(e).map((([e,t])=>e));{const t=this.formulaDependencyQuery(e);if(void 0!==t){const[e,r]=t;return r.map((t=>t instanceof Be?this.namedExpressions.namedExpressionOrPlaceholder(t.name,e.sheet).address:Pr(t)?t:Hr(t.start,t.end)))}return[]}},this.dependencyQueryVertices=e=>{if(e instanceof Kt)return this.rangeDependencyQuery(e);{const t=this.formulaDependencyQuery(e);if(void 0!==t){const[e,r]=t;return r.map((t=>{if(t instanceof Fr)return[t.start,this.rangeMapping.fetchRange(t.start,t.end)];if(t instanceof Be){const r=this.namedExpressions.namedExpressionOrPlaceholder(t.name,e.sheet);return[r.address,this.addressMapping.fetchCell(r.address)]}return[t,this.addressMapping.fetchCell(t)]}))}return[]}},this.rangeDependencyQuery=e=>{const t=[],{smallerRangeVertex:r,restRange:n}=this.rangeMapping.findSmallerRange(e.range);let s;void 0!==r&&this.graph.adjacentNodes(r).has(e)?(s=n,t.push([new Fr(r.start,r.end),r])):s=e.range;for(const e of s.addresses(this)){const r=this.addressMapping.getCell(e);void 0!==r&&t.push([e,r])}return t},this.formulaDependencyQuery=e=>{let t,r;if(!(e instanceof Gt))return;r=e.getAddress(this.lazilyTransformingAstService),t=e.getFormula(this.lazilyTransformingAstService);const n=ke(t,this.functionRegistry);return[r,We(n,r)]},this.graph=new Jt(this.dependencyQueryVertices)}static buildEmpty(e,t,r,n,s){return new ur(new Vt(t.chooseAddressMappingPolicy),new er,new hr(t.translationPackage),new Bt,s,e,r,n)}setFormulaToCell(e,t,r,n,s,o){const i=Gt.fromAst(t,e,n,this.lazilyTransformingAstService.version());return this.exchangeOrAddFormulaVertex(i),this.processCellDependencies(r,i),this.graph.markNodeAsDirty(i),s&&this.markAsVolatile(i),o&&this.markAsDependentOnStructureChange(i),this.correctInfiniteRangesDependency(e),this.getAndClearContentChanges()}setParsingErrorToCell(e,t){const r=this.shrinkPossibleArrayAndGetCell(e);return this.exchangeOrAddGraphNode(r,t),this.addressMapping.setCell(e,t),this.graph.markNodeAsDirty(t),this.correctInfiniteRangesDependency(e),this.getAndClearContentChanges()}setValueToCell(e,t){const r=this.shrinkPossibleArrayAndGetCell(e);if(r instanceof zt&&this.arrayMapping.removeArray(r.getRange()),r instanceof dr){r.getValues().rawValue!==t.rawValue&&(r.setValues(t),this.graph.markNodeAsDirty(r))}else{const n=new dr(t.parsedValue,t.rawValue);this.exchangeOrAddGraphNode(r,n),this.addressMapping.setCell(e,n),this.graph.markNodeAsDirty(n)}return this.correctInfiniteRangesDependency(e),this.getAndClearContentChanges()}setCellEmpty(e){const t=this.shrinkPossibleArrayAndGetCell(e);if(void 0===t)return nt.empty();if(this.graph.adjacentNodes(t).size>0){const r=new cr;this.exchangeGraphNode(t,r),0===this.graph.adjacentNodesCount(r)?(this.removeVertex(r),this.addressMapping.removeCell(e)):(this.graph.markNodeAsDirty(r),this.addressMapping.setCell(e,r))}else this.removeVertex(t),this.addressMapping.removeCell(e);return this.getAndClearContentChanges()}clearDirtyVertices(){this.graph.clearDirtyNodes()}verticesToRecompute(){return this.graph.getDirtyAndVolatileNodes()}processCellDependencies(e,t){const r=this.graph.getNodeId(t);e.forEach((e=>{if(e instanceof Fr){const t=e;let n=this.getRange(t.start,t.end);void 0===n&&(n=new Kt(t),this.rangeMapping.setRange(n)),this.graph.addNodeAndReturnId(n);const s=this.graph.getNodeId(n);t.isFinite()||this.graph.markNodeAsInfiniteRange(s);const{smallerRangeVertex:o,restRange:i}=this.rangeMapping.findSmallerRange(t);if(void 0!==o){if(this.graph.addEdge(o,s),n.bruteForce){n.bruteForce=!1;for(const e of t.addresses(this))this.graph.removeEdge(this.fetchCell(e),s)}}else n.bruteForce=!0;const a=this.arrayMapping.getArray(i);if(void 0!==a)this.graph.addEdge(a,s);else for(const e of i.addresses(this)){const{vertex:t,id:r}=this.fetchCellOrCreateEmpty(e);this.graph.addEdge(null!=r?r:t,s)}this.graph.addEdge(s,r),t.isFinite()&&this.correctInfiniteRangesDependenciesByRangeVertex(n)}else if(e instanceof Be){const n=t.getAddress(this.lazilyTransformingAstService).sheet,{vertex:s,id:o}=this.fetchNamedExpressionVertex(e.name,n);this.graph.addEdge(null!=o?o:s,r)}else{const{vertex:t,id:n}=this.fetchCellOrCreateEmpty(e);this.graph.addEdge(null!=n?n:t,r)}}))}fetchNamedExpressionVertex(e,t){const r=this.namedExpressions.namedExpressionOrPlaceholder(e,t);return this.fetchCellOrCreateEmpty(r.address)}exchangeNode(e,t){const r=this.fetchCellOrCreateEmpty(e).vertex,n=this.fetchCellOrCreateEmpty(t).vertex;this.addressMapping.removeCell(e),this.exchangeGraphNode(r,n)}fetchCellOrCreateEmpty(e){const t=this.addressMapping.getCell(e);if(void 0!==t)return{vertex:t,id:void 0};const r=new cr,n=this.graph.addNodeAndReturnId(r);return this.addressMapping.setCell(e,r),{vertex:r,id:n}}removeRows(e){this.stats.measure(et.ADJUSTING_GRAPH,(()=>{for(const[t,r]of this.addressMapping.entriesFromRowsSpan(e)){for(const e of this.graph.adjacentNodes(r))this.graph.markNodeAsDirty(e);if(r instanceof zt){if(!r.isLeftCorner(t))continue;this.shrinkArrayToCorner(r),this.arrayMapping.removeArray(r.getRange())}this.removeVertex(r)}})),this.stats.measure(et.ADJUSTING_ADDRESS_MAPPING,(()=>{this.addressMapping.removeRows(e)}));const t=this.stats.measure(et.ADJUSTING_RANGES,(()=>{const t=this.truncateRanges(e,(e=>e.row));return this.getArrayVerticesRelatedToRanges(t)}));return this.stats.measure(et.ADJUSTING_ARRAY_MAPPING,(()=>{this.fixArraysAfterRemovingRows(e.sheet,e.rowStart,e.numberOfRows)})),this.addStructuralNodesToChangeSet(),{affectedArrays:t,contentChanges:this.getAndClearContentChanges()}}removeSheet(e){this.clearSheet(e);for(const[t,r]of this.addressMapping.sheetEntries(e)){for(const e of this.graph.adjacentNodes(r))this.graph.markNodeAsDirty(e);this.removeVertex(r),this.addressMapping.removeCell(t)}this.stats.measure(et.ADJUSTING_RANGES,(()=>{const t=this.rangeMapping.removeRangesInSheet(e);for(const e of t)this.removeVertex(e);this.stats.measure(et.ADJUSTING_ADDRESS_MAPPING,(()=>{this.addressMapping.removeSheet(e)}))}))}clearSheet(e){const t=new Set;for(const[r,n]of this.addressMapping.sheetEntries(e))n instanceof zt?t.add(n):this.setCellEmpty(r);for(const e of t.values())this.setArrayEmpty(e);this.addStructuralNodesToChangeSet()}removeColumns(e){this.stats.measure(et.ADJUSTING_GRAPH,(()=>{for(const[t,r]of this.addressMapping.entriesFromColumnsSpan(e)){for(const e of this.graph.adjacentNodes(r))this.graph.markNodeAsDirty(e);if(r instanceof zt){if(!r.isLeftCorner(t))continue;this.shrinkArrayToCorner(r),this.arrayMapping.removeArray(r.getRange())}this.removeVertex(r)}})),this.stats.measure(et.ADJUSTING_ADDRESS_MAPPING,(()=>{this.addressMapping.removeColumns(e)}));const t=this.stats.measure(et.ADJUSTING_RANGES,(()=>{const t=this.truncateRanges(e,(e=>e.col));return this.getArrayVerticesRelatedToRanges(t)}));return this.stats.measure(et.ADJUSTING_ARRAY_MAPPING,(()=>this.fixArraysAfterRemovingColumns(e.sheet,e.columnStart,e.numberOfColumns))),this.addStructuralNodesToChangeSet(),{affectedArrays:t,contentChanges:this.getAndClearContentChanges()}}addRows(e){this.stats.measure(et.ADJUSTING_ADDRESS_MAPPING,(()=>{this.addressMapping.addRows(e.sheet,e.rowStart,e.numberOfRows)}));const t=this.stats.measure(et.ADJUSTING_RANGES,(()=>{const t=this.rangeMapping.moveAllRangesInSheetAfterRowByRows(e.sheet,e.rowStart,e.numberOfRows);return this.fixRangesWhenAddingRows(e.sheet,e.rowStart,e.numberOfRows),this.getArrayVerticesRelatedToRanges(t.verticesWithChangedSize)}));this.stats.measure(et.ADJUSTING_ARRAY_MAPPING,(()=>{this.fixArraysAfterAddingRow(e.sheet,e.rowStart,e.numberOfRows)}));for(const t of this.addressMapping.verticesFromRowsSpan(e))this.graph.markNodeAsDirty(t);return this.addStructuralNodesToChangeSet(),{affectedArrays:t}}addColumns(e){this.stats.measure(et.ADJUSTING_ADDRESS_MAPPING,(()=>{this.addressMapping.addColumns(e.sheet,e.columnStart,e.numberOfColumns)}));const t=this.stats.measure(et.ADJUSTING_RANGES,(()=>{const t=this.rangeMapping.moveAllRangesInSheetAfterColumnByColumns(e.sheet,e.columnStart,e.numberOfColumns);return this.fixRangesWhenAddingColumns(e.sheet,e.columnStart,e.numberOfColumns),this.getArrayVerticesRelatedToRanges(t.verticesWithChangedSize)}));this.stats.measure(et.ADJUSTING_ARRAY_MAPPING,(()=>this.fixArraysAfterAddingColumn(e.sheet,e.columnStart,e.numberOfColumns)));for(const t of this.addressMapping.verticesFromColumnsSpan(e))this.graph.markNodeAsDirty(t);return this.addStructuralNodesToChangeSet(),{affectedArrays:t,contentChanges:this.getAndClearContentChanges()}}isThereSpaceForArray(e){const t=e.getRangeOrUndef();if(void 0===t)return!1;for(const r of t.addresses(this)){const t=this.addressMapping.getCell(r);if(void 0!==t&&!(t instanceof cr)&&t!==e)return!1}return!0}moveCells(e,t,r,n){for(const s of e.addressesWithDirection(t,r,this)){const o=br(n,s.col+t,s.row+r);let i=this.addressMapping.getCell(s);const a=this.addressMapping.getCell(o);if(this.addressMapping.removeCell(s),void 0!==i){let t;this.graph.markNodeAsDirty(i),this.addressMapping.setCell(o,i);for(const r of this.graph.adjacentNodes(i))r instanceof Kt&&!e.containsRange(r.range)&&(t=null!=t?t:this.fetchCellOrCreateEmpty(s).vertex,this.graph.addEdge(t,r),this.graph.removeEdge(i,r));t&&(this.graph.markNodeAsDirty(t),this.addressMapping.setCell(s,t))}if(void 0!==a){void 0===i&&this.addressMapping.removeCell(o);for(const e of this.graph.adjacentNodes(a))i=null!=i?i:this.fetchCellOrCreateEmpty(o).vertex,this.graph.addEdge(i,e),this.graph.markNodeAsDirty(i);this.removeVertex(a)}}for(const t of this.rangeMapping.rangeVerticesContainedInRange(e))for(const r of this.graph.adjacentNodes(t))if(r instanceof Kt&&!e.containsRange(r.range)){this.graph.removeEdge(t,r);for(const e of t.range.addresses(this)){const{vertex:t,id:n}=this.fetchCellOrCreateEmpty(e);this.graph.addEdge(null!=n?n:t,r),this.addressMapping.setCell(e,t),this.graph.markNodeAsDirty(t)}}this.rangeMapping.moveRangesInsideSourceRange(e,t,r,n)}setArrayEmpty(e){const t=Fr.spanFrom(e.getAddress(this.lazilyTransformingAstService),e.width,e.height),r=this.graph.adjacentNodes(e);for(const e of t.addresses(this))this.addressMapping.removeCell(e);for(const t of r.values()){const r=Xt(this.functionRegistry,t,e.getRange(),this.lazilyTransformingAstService,this);for(const e of r){const{vertex:r,id:n}=this.fetchCellOrCreateEmpty(e);this.graph.addEdge(null!=n?n:r,t)}r.length>0&&this.graph.markNodeAsDirty(t)}this.removeVertex(e),this.arrayMapping.removeArray(e.getRange())}addVertex(e,t){this.graph.addNodeAndReturnId(t),this.addressMapping.setCell(e,t)}addArrayVertex(e,t){this.graph.addNodeAndReturnId(t),this.setAddressMappingForArrayVertex(t,e)}*arrayFormulaNodes(){for(const e of this.graph.getNodes())e instanceof zt&&(yield e)}*entriesFromRowsSpan(e){yield*this.addressMapping.entriesFromRowsSpan(e)}*entriesFromColumnsSpan(e){yield*this.addressMapping.entriesFromColumnsSpan(e)}fetchCell(e){return this.addressMapping.fetchCell(e)}getCell(e){return this.addressMapping.getCell(e)}getCellValue(e){return this.addressMapping.getCellValue(e)}getRawValue(e){return this.addressMapping.getRawValue(e)}getScalarValue(e){const t=this.addressMapping.getCellValue(e);return t instanceof rt?new Tr(or.VALUE,Z.ScalarExpected):t}existsEdge(e,t){return this.graph.existsEdge(e,t)}getSheetId(e){return this.sheetMapping.fetch(e)}getSheetHeight(e){return this.addressMapping.getHeight(e)}getSheetWidth(e){return this.addressMapping.getWidth(e)}getArray(e){return this.arrayMapping.getArray(e)}getRange(e,t){return this.rangeMapping.getRange(e,t)}topSortWithScc(){return this.graph.topSortWithScc()}markAsVolatile(e){this.graph.markNodeAsVolatile(e)}markAsDependentOnStructureChange(e){this.graph.markNodeAsChangingWithStructure(e)}forceApplyPostponedTransformations(){for(const e of this.graph.getNodes())e instanceof $t&&e.ensureRecentData(this.lazilyTransformingAstService)}*rawValuesFromRange(e){for(const t of e.addresses(this)){const e=this.getScalarValue(t);e!==Ye&&(yield[je(e),t])}}computeListOfValuesInRange(e){const t=[];for(const r of e.addresses(this)){const e=this.getScalarValue(r);t.push(e)}return t}shrinkArrayToCorner(e){this.cleanAddressMappingUnderArray(e);for(const t of this.adjacentArrayVertices(e)){let r;r=t instanceof Gt?this.formulaDirectDependenciesToArray(t,e):this.rangeDirectDependenciesToArray(t,e);let n=!1;for(const[s,o]of r)e.isLeftCorner(s)&&(n=!0),this.graph.addEdge(o,t),this.graph.markNodeAsDirty(o);n||this.graph.removeEdge(e,t)}this.graph.markNodeAsDirty(e)}isArrayInternalCell(e){const t=this.getCell(e);return t instanceof zt&&!t.isLeftCorner(e)}getAndClearContentChanges(){const e=this.changes;return this.changes=nt.empty(),e}getAdjacentNodesAddresses(e){const t=this.graph.adjacentNodes(e),r=[];return t.forEach((e=>{const t=e;t instanceof Kt?r.push(Hr(t.start,t.end)):r.push(t.getAddress(this.lazilyTransformingAstService))})),r}exchangeGraphNode(e,t){this.graph.addNodeAndReturnId(t);const r=this.graph.adjacentNodes(e);this.removeVertex(e),r.forEach((e=>{this.graph.hasNode(e)&&this.graph.addEdge(t,e)}))}setArray(e,t){this.arrayMapping.setArray(e,t)}correctInfiniteRangesDependency(e){const t=this.graph.getInfiniteRanges().filter((({node:t})=>t.range.addressInRange(e)));if(t.length<=0)return;const{vertex:r,id:n}=this.fetchCellOrCreateEmpty(e),s=null!=n?n:this.graph.getNodeId(r);t.forEach((({id:e})=>{this.graph.addEdge(s,e)}))}exchangeOrAddGraphNode(e,t){e?this.exchangeGraphNode(e,t):this.graph.addNodeAndReturnId(t)}getArrayVerticesRelatedToRanges(e){const t=new Set;return e.forEach((e=>{this.graph.hasNode(e)&&this.graph.adjacentNodes(e).forEach((e=>{e instanceof zt&&t.add(e)}))})),t}correctInfiniteRangesDependenciesByRangeVertex(e){this.graph.getInfiniteRanges().forEach((({id:t,node:r})=>{const n=e.range.intersectionWith(r.range);void 0!==n&&n.addresses(this).forEach((e=>{const{vertex:r,id:n}=this.fetchCellOrCreateEmpty(e);this.graph.addEdge(null!=n?n:r,t)}))}))}cleanAddressMappingUnderArray(e){const t=e.getRange();for(const r of t.addresses(this)){const t=e.getArrayCellValue(r);this.getCell(r)===e?e.isLeftCorner(r)?this.changes.addChange(new Tr(or.REF),r,t):(this.addressMapping.removeCell(r),this.changes.addChange(Ye,r,t)):this.changes.addChange(Ye,r,t)}}*formulaDirectDependenciesToArray(e,t){var r;const[,n]=null!==(r=this.formulaDependencyQuery(e))&&void 0!==r?r:[];if(void 0!==n)for(const e of n)if(!(e instanceof Be||e instanceof Fr)&&t.getRange().addressInRange(e)){const t=this.fetchCellOrCreateEmpty(e).vertex;yield[e,t]}}*rangeDirectDependenciesToArray(e,t){const{restRange:r}=this.rangeMapping.findSmallerRange(e.range);for(const e of r.addresses(this))if(t.getRange().addressInRange(e)){const t=this.fetchCellOrCreateEmpty(e).vertex;yield[e,t]}}*adjacentArrayVertices(e){const t=this.graph.adjacentNodes(e);for(const e of t)(e instanceof Gt||e instanceof Kt)&&(yield e)}addStructuralNodesToChangeSet(){this.graph.markChangingWithStructureNodesAsDirty()}fixRangesWhenAddingRows(e,t,r){const n=Array.from(this.rangeMapping.rangesInSheet(e));for(const e of n)if(e.range.includesRow(t+r))if(e.bruteForce){const n=e.range.rangeWithSameWidth(t,r);for(const t of n.addresses(this)){const{vertex:r,id:n}=this.fetchCellOrCreateEmpty(t);this.graph.addEdge(null!=n?n:r,e)}}else{let t=e,r=this.rangeMapping.findSmallerRange(t.range);if(void 0!==r.smallerRangeVertex)continue;for(;void 0===r.smallerRangeVertex;){const e=new Kt(Fr.spanFrom(t.range.start,t.range.width(),t.range.height()-1));this.rangeMapping.setRange(e),this.graph.addNodeAndReturnId(e);const n=new Fr(br(t.range.start.sheet,t.range.start.col,t.range.end.row),t.range.end);this.addAllFromRange(n,t),this.graph.addEdge(e,t),t=e,r=this.rangeMapping.findSmallerRange(t.range)}this.graph.addEdge(r.smallerRangeVertex,t),this.addAllFromRange(r.restRange,t),this.graph.removeEdge(r.smallerRangeVertex,e)}}addAllFromRange(e,t){for(const r of e.addresses(this)){const{vertex:e,id:n}=this.fetchCellOrCreateEmpty(r);this.graph.addEdge(null!=n?n:e,t)}}fixRangesWhenAddingColumns(e,t,r){for(const n of this.rangeMapping.rangesInSheet(e))if(n.range.includesColumn(t+r)){let s;s=n.bruteForce?n.range.rangeWithSameHeight(t,r):Fr.spanFrom(br(e,t,n.range.end.row),r,1);for(const e of s.addresses(this)){const{vertex:t,id:r}=this.fetchCellOrCreateEmpty(e);this.graph.addEdge(null!=r?r:t,n)}}}exchangeOrAddFormulaVertex(e){const t=e.getAddress(this.lazilyTransformingAstService),r=Fr.spanFrom(t,e.width,e.height),n=this.shrinkPossibleArrayAndGetCell(t);if(e instanceof zt&&this.setArray(r,e),this.exchangeOrAddGraphNode(n,e),this.addressMapping.setCell(t,e),e instanceof zt){if(!this.isThereSpaceForArray(e))return;for(const t of r.addresses(this)){if(e.isLeftCorner(t))continue;const r=this.getCell(t);this.exchangeOrAddGraphNode(r,e)}}for(const t of r.addresses(this))this.addressMapping.setCell(t,e)}setAddressMappingForArrayVertex(e,t){if(this.addressMapping.setCell(t,e),!(e instanceof zt))return;const r=Fr.spanFromOrUndef(t,e.width,e.height);if(void 0!==r&&(this.setArray(r,e),this.isThereSpaceForArray(e)))for(const t of r.addresses(this))this.addressMapping.setCell(t,e)}truncateRanges(e,t){const{verticesToRemove:r,verticesToMerge:n,verticesWithChangedSize:s}=this.rangeMapping.truncateRanges(e,t);for(const[e,t]of n)this.mergeRangeVertices(e,t);for(const e of r)this.removeVertexAndCleanupDependencies(e);return s}fixArraysAfterAddingRow(e,t,r){if(this.arrayMapping.moveArrayVerticesAfterRowByRows(e,t,r),!(t<=0))for(const[,n]of this.arrayMapping.arraysInRows(st.fromRowStartAndEnd(e,t-1,t-1))){const s=n.getRange();for(let o=s.start.col;o<=s.end.col;++o)for(let i=t;i<=s.end.row;++i){const t=br(e,o,i),s=br(e,o,i+r),a=n.getArrayCellValue(t);this.addressMapping.moveCell(s,t),this.changes.addChange(Ye,s,a)}}}fixArraysAfterRemovingRows(e,t,r){if(this.arrayMapping.moveArrayVerticesAfterRowByRows(e,t,-r),!(t<=0))for(const[,r]of this.arrayMapping.arraysInRows(st.fromRowStartAndEnd(e,t-1,t-1)))if(this.isThereSpaceForArray(r))for(const e of r.getRange().addresses(this))this.addressMapping.setCell(e,r);else this.setNoSpaceIfArray(r)}fixArraysAfterAddingColumn(e,t,r){if(this.arrayMapping.moveArrayVerticesAfterColumnByColumns(e,t,r),!(t<=0))for(const[,n]of this.arrayMapping.arraysInCols(ot.fromColumnStartAndEnd(e,t-1,t-1))){const s=n.getRange();for(let o=s.start.row;o<=s.end.row;++o)for(let i=t;i<=s.end.col;++i){const t=br(e,i,o),s=br(e,i+r,o),a=n.getArrayCellValue(t);this.addressMapping.moveCell(s,t),this.changes.addChange(Ye,s,a)}}}fixArraysAfterRemovingColumns(e,t,r){if(this.arrayMapping.moveArrayVerticesAfterColumnByColumns(e,t,-r),!(t<=0))for(const[,r]of this.arrayMapping.arraysInCols(ot.fromColumnStartAndEnd(e,t-1,t-1)))if(this.isThereSpaceForArray(r))for(const e of r.getRange().addresses(this))this.addressMapping.setCell(e,r);else this.setNoSpaceIfArray(r)}shrinkPossibleArrayAndGetCell(e){const t=this.getCell(e);return t instanceof zt?(this.setNoSpaceIfArray(t),this.getCell(e)):t}setNoSpaceIfArray(e){e instanceof zt&&(this.shrinkArrayToCorner(e),e.setNoSpace())}removeVertex(e){this.removeVertexAndCleanupDependencies(e),e instanceof Kt&&this.rangeMapping.removeRange(e)}mergeRangeVertices(e,t){const r=this.graph.adjacentNodes(t);this.removeVertexAndCleanupDependencies(t),this.graph.removeEdgeIfExists(e,t),r.forEach((t=>{this.graph.hasNode(t)&&this.graph.addEdge(e,t)}))}removeVertexAndCleanupDependencies(e){const t=new Set(this.graph.removeNode(e));for(;t.size>0;){const e=t.values().next().value;t.delete(e);const[r,n]=e;this.graph.hasNode(n)&&0===this.graph.adjacentNodesCount(n)&&((n instanceof Kt||n instanceof cr)&&this.graph.removeNode(n).forEach((e=>t.add(e))),n instanceof Kt?this.rangeMapping.removeRange(n):n instanceof cr&&this.addressMapping.removeCell(r))}}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class cr{constructor(){}getCellValue(){return Ye}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class dr{constructor(e,t){this.parsedValue=e,this.rawValue=t}getValues(){return{parsedValue:this.parsedValue,rawValue:this.rawValue}}setValues(e){this.parsedValue=e.parsedValue,this.rawValue=e.rawValue}getCellValue(){return this.parsedValue}setCellValue(e){throw Error("SetCellValue is deprecated for ValueCellVertex")}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class pr{constructor(e,t){this.errors=e,this.rawInput=t}getCellValue(){const e=this.errors.map((e=>e.message)).find((e=>e));return Tr.parsingError(e)}getFormula(){return this.rawInput}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class gr{constructor(e,t){this.width=e,this.height=t,this.mapping=new Map}getCell(e){var t;return null===(t=this.mapping.get(e.col))||void 0===t?void 0:t.get(e.row)}setCell(e,t){this.width=Math.max(this.width,e.col+1),this.height=Math.max(this.height,e.row+1);let r=this.mapping.get(e.col);r||(r=new Map,this.mapping.set(e.col,r)),r.set(e.row,t)}has(e){var t;return!!(null===(t=this.mapping.get(e.col))||void 0===t?void 0:t.get(e.row))}getHeight(){return this.height}getWidth(){return this.width}removeCell(e){var t;null===(t=this.mapping.get(e.col))||void 0===t||t.delete(e.row)}addRows(e,t){this.mapping.forEach((r=>{const n=new Map;r.forEach(((s,o)=>{o>=e&&(n.set(o+t,s),r.delete(o))})),n.forEach(((e,t)=>{r.set(t,e)}))})),this.height+=t}addColumns(e,t){const r=new Map;this.mapping.forEach(((n,s)=>{s>=e&&(r.set(s+t,n),this.mapping.delete(s))})),r.forEach(((e,t)=>{this.mapping.set(t,e)})),this.width+=t}removeRows(e){this.mapping.forEach((t=>{const r=new Map;t.forEach(((n,s)=>{s>=e.rowStart&&(t.delete(s),s>e.rowEnd&&r.set(s-e.numberOfRows,n))})),r.forEach(((e,r)=>{t.set(r,e)}))}));const t=Math.min(this.height-1,e.rowEnd),r=Math.max(0,t-e.rowStart+1);this.height=Math.max(0,this.height-r)}removeColumns(e){const t=new Map;this.mapping.forEach(((r,n)=>{n>=e.columnStart&&(this.mapping.delete(n),n>e.columnEnd&&t.set(n-e.numberOfColumns,r))})),t.forEach(((e,t)=>{this.mapping.set(t,e)}));const r=Math.min(this.width-1,e.columnEnd),n=Math.max(0,r-e.columnStart+1);this.width=Math.max(0,this.width-n)}*getEntries(e){for(const[t,r]of this.mapping)for(const[n,s]of r)yield[br(e,t,n),s]}*verticesFromColumn(e){const t=this.mapping.get(e);if(void 0!==t)for(const[e,r]of t)yield r}*verticesFromRow(e){for(const t of this.mapping.values()){const r=t.get(e);void 0!==r&&(yield r)}}*verticesFromColumnsSpan(e){for(const t of e.columns()){const e=this.mapping.get(t);if(void 0!==e)for(const[t,r]of e)yield r}}*verticesFromRowsSpan(e){for(const t of this.mapping.values())for(const r of e.rows()){const e=t.get(r);void 0!==e&&(yield e)}}*entriesFromRowsSpan(e){for(const[t,r]of this.mapping.entries())for(const n of e.rows()){const s=r.get(n);void 0!==s&&(yield[br(e.sheet,t,n),s])}}*entriesFromColumnsSpan(e){for(const t of e.columns()){const r=this.mapping.get(t);if(void 0!==r)for(const[n,s]of r.entries())yield[br(e.sheet,t,n),s]}}*vertices(){for(const[e,t]of this.mapping)for(const[e,r]of t)void 0!==r&&(yield r)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class fr{constructor(e,t){this.width=e,this.height=t,this.mapping=new Array(t);for(let r=0;r<t;r++)this.mapping[r]=new Array(e)}getCell(e){return this.getCellVertex(e.col,e.row)}setCell(e,t){this.width=Math.max(this.width,e.col+1),this.height=Math.max(this.height,e.row+1);this.mapping[e.row]||(this.mapping[e.row]=new Array(this.width)),this.mapping[e.row][e.col]=t}has(e){const t=this.mapping[e.row];return!!t&&!!t[e.col]}getHeight(){return this.height}getWidth(){return this.width}removeCell(e){void 0!==this.mapping[e.row]&&delete this.mapping[e.row][e.col]}addRows(e,t){const r=[];for(let e=0;e<t;e++)r.push(new Array(this.width));this.mapping.splice(e,0,...r),this.height+=t}addColumns(e,t){for(let r=0;r<this.height;r++)this.mapping[r].splice(e,0,...new Array(t));this.width+=t}removeRows(e){this.mapping.splice(e.rowStart,e.numberOfRows);const t=Math.min(this.height-1,e.rowEnd),r=Math.max(0,t-e.rowStart+1);this.height=Math.max(0,this.height-r)}removeColumns(e){for(let t=0;t<this.height;t++)this.mapping[t].splice(e.columnStart,e.numberOfColumns);const t=Math.min(this.width-1,e.columnEnd),r=Math.max(0,t-e.columnStart+1);this.width=Math.max(0,this.width-r)}*getEntries(e){for(let t=0;t<this.height;++t)for(let r=0;r<this.width;++r){const n=this.getCellVertex(r,t);n&&(yield[br(e,r,t),n])}}*verticesFromColumn(e){for(let t=0;t<this.height;++t){const r=this.getCellVertex(e,t);r&&(yield r)}}*verticesFromRow(e){for(let t=0;t<this.width;++t){const r=this.getCellVertex(t,e);r&&(yield r)}}*verticesFromColumnsSpan(e){for(let t=e.columnStart;t<=e.columnEnd;++t)for(let e=0;e<this.height;++e){const r=this.getCellVertex(t,e);r&&(yield r)}}*verticesFromRowsSpan(e){for(let t=0;t<this.width;++t)for(let r=e.rowStart;r<=e.rowEnd;++r){const e=this.getCellVertex(t,r);e&&(yield e)}}*entriesFromRowsSpan(e){for(let t=0;t<this.width;++t)for(let r=e.rowStart;r<=e.rowEnd;++r){const n=this.getCellVertex(t,r);n&&(yield[br(e.sheet,t,r),n])}}*entriesFromColumnsSpan(e){for(let t=e.columnStart;t<=e.columnEnd;++t)for(let r=0;r<this.height;++r){const n=this.getCellVertex(t,r);n&&(yield[br(e.sheet,t,r),n])}}*vertices(){for(let e=0;e<this.height;++e)for(let t=0;t<this.width;++t){const r=this.getCellVertex(t,e);r&&(yield r)}}getCellVertex(e,t){var r;return null===(r=this.mapping[t])||void 0===r?void 0:r[e]}}!function(e){e.DIV_BY_ZERO="DIV_BY_ZERO",e.NAME="NAME",e.VALUE="VALUE",e.NUM="NUM",e.NA="NA",e.CYCLE="CYCLE",e.REF="REF",e.SPILL="SPILL",e.LIC="LIC",e.ERROR="ERROR"}(or||(or={})),function(e){e.FORMULA="FORMULA",e.VALUE="VALUE",e.ARRAY="ARRAY",e.EMPTY="EMPTY",e.ARRAYFORMULA="ARRAYFORMULA"}(ir||(ir={}));var mr,Er;!function(e){e.EMPTY="EMPTY",e.NUMBER="NUMBER",e.STRING="STRING",e.BOOLEAN="BOOLEAN",e.ERROR="ERROR"}(mr||(mr={})),function(e){e.NUMBER="NUMBER"}(Er||(Er={}));const yr=Object.assign(Object.assign({},mr),Er),wr=Object.assign(Object.assign({},mr),Je),Cr=e=>{switch(e){case yr.EMPTY:return 0;case yr.NUMBER:return 1;case yr.STRING:return 2;case yr.BOOLEAN:return 3;case yr.ERROR:return 4}throw new Error("Cell value not computed")},Rr=e=>{if(e===Ye)return yr.EMPTY;if(e instanceof Tr||e instanceof rt)return yr.ERROR;if("string"==typeof e)return yr.STRING;if(Ze(e))return yr.NUMBER;if("boolean"==typeof e)return yr.BOOLEAN;throw new Error("Cell value not computed")},vr=e=>{return Ze(e)?(t=e)instanceof Ge?t.getDetailedType():Je.NUMBER_RAW:Rr(e);var t},Sr=e=>{return Ze(e)&&(t=e)instanceof Ge?t.format:void 0;var t};class Tr{constructor(e,t,r){this.type=e,this.message=t,this.root=r}static parsingError(e){return new Tr(or.ERROR,`${Z.ParseError}${e?" "+e:""}`)}attachRootVertex(e){return void 0===this.root?new Tr(this.type,this.message,e):this}}const Nr=(e,t)=>({sheet:e,row:t}),_r=e=>e.row<0,Mr=(e,t)=>({sheet:e,col:t}),Ar=e=>e.col<0,br=(e,t,r)=>({sheet:e,col:t,row:r}),Ir=e=>e.col<0||e.row<0,Or=(e,t,r,n)=>br(t,e.col+r,e.row+n),xr=e=>`${e.sheet},${e.row},${e.col}`;function Pr(e){var t,r,n;return e&&("object"==typeof e||"function"==typeof e)&&"number"==typeof(null===(t=e)||void 0===t?void 0:t.sheet)&&"number"==typeof(null===(r=e)||void 0===r?void 0:r.col)&&"number"==typeof(null===(n=e)||void 0===n?void 0:n.row)}const Lr=(e,t)=>{var r;return null!==(r=e.sheet)&&void 0!==r?r:t.sheet},Dr=(e,t)=>e.sheet===t.sheet&&e.col===t.col&&e.row===t.row;function kr(e){return!(!e||"object"!=typeof e&&"function"!=typeof e)&&("start"in e&&Pr(e.start)&&"end"in e&&Pr(e.end))}const Hr=(e,t)=>({start:e,end:t});class Fr{constructor(e,t){if(e.sheet!==t.sheet)throw new ft(e.sheet,t.sheet);this.start=br(e.sheet,e.col,e.row),this.end=br(t.sheet,t.col,t.row)}get sheet(){return this.start.sheet}static fromSimpleCellAddresses(e,t){if(e.sheet!==t.sheet)throw new ft(e.sheet,t.sheet);const r=t.col-e.col,n=t.row-e.row;return Number.isFinite(n)&&Number.isFinite(r)?new Fr(e,t):Number.isFinite(n)?new Vr(e.sheet,e.row,t.row):new Ur(e.sheet,e.col,t.col)}static fromAst(e,t){return e.type===U.CELL_RANGE?Fr.fromCellRange(e,t):e.type===U.COLUMN_RANGE?Ur.fromColumnRange(e,t):Vr.fromRowRangeAst(e,t)}static fromAstOrUndef(e,t){try{return Fr.fromAst(e,t)}catch(e){return}}static fromCellRange(e,t){return new Fr(e.start.toSimpleCellAddress(t),e.end.toSimpleCellAddress(t))}static spanFrom(e,t,r){const n=Fr.spanFromOrUndef(e,t,r);if(void 0===n)throw new Error("AbsoluteCellRange: Wrong range size");return n}static spanFromOrUndef(e,t,r){if(!Number.isFinite(t)&&Number.isFinite(r)){if(0!==e.col)return;return new Vr(e.sheet,e.row,e.row+r-1)}if(!Number.isFinite(r)&&Number.isFinite(t)){if(0!==e.row)return;return new Ur(e.sheet,e.col,e.col+t-1)}if(Number.isFinite(r)&&Number.isFinite(t))return new Fr(e,br(e.sheet,e.col+t-1,e.row+r-1))}static fromCoordinates(e,t,r,n,s){return new Fr(br(e,t,r),br(e,n,s))}isFinite(){return Number.isFinite(this.size())}doesOverlap(e){return this.start.sheet==e.start.sheet&&(!(this.end.row<e.start.row||this.start.row>e.end.row)&&!(this.end.col<e.start.col||this.start.col>e.end.col))}addressInRange(e){return this.sheet===e.sheet&&(this.start.row<=e.row&&this.end.row>=e.row&&this.start.col<=e.col&&this.end.col>=e.col)}columnInRange(e){return this.sheet===e.sheet&&(this.start.col<=e.col&&this.end.col>=e.col)}rowInRange(e){return this.sheet===e.sheet&&(this.start.row<=e.row&&this.end.row>=e.row)}containsRange(e){return this.addressInRange(e.start)&&this.addressInRange(e.end)}intersectionWith(e){if(this.sheet!==e.start.sheet)return;const t=Math.max(this.start.row,e.start.row),r=Math.min(this.end.row,e.end.row),n=Math.max(this.start.col,e.start.col),s=Math.min(this.end.col,e.end.col);return t>r||n>s?void 0:new Fr(br(this.sheet,n,t),br(this.sheet,s,r))}includesRow(e){return this.start.row<e&&this.end.row>=e}includesColumn(e){return this.start.col<e&&this.end.col>=e}shiftByRows(e){this.start.row+=e,this.end.row+=e}expandByRows(e){this.end.row+=e}shiftByColumns(e){this.start.col+=e,this.end.col+=e}shifted(e,t){return Fr.spanFrom(br(this.sheet,this.start.col+e,this.start.row+t),this.width(),this.height())}expandByColumns(e){this.end.col+=e}moveToSheet(e){this.start.sheet=e,this.end.sheet=e}removeSpan(e){e instanceof st?this.removeRows(e.start,e.end):this.removeColumns(e.start,e.end)}shouldBeRemoved(){return this.width()<=0||this.height()<=0}rangeWithSameWidth(e,t){return Fr.spanFrom(br(this.sheet,this.start.col,e),this.width(),t)}rangeWithSameHeight(e,t){return Fr.spanFrom(br(this.sheet,e,this.start.row),t,this.height())}toString(){return`${this.start.sheet},${this.start.col},${this.start.row},${this.end.col},${this.end.row}`}width(){return this.end.col-this.start.col+1}height(){return this.end.row-this.start.row+1}size(){return this.height()*this.width()}arrayOfAddressesInRange(){const e=[];for(let t=0;t<this.height();++t){e[t]=[];for(let r=0;r<this.width();++r){const n=br(this.sheet,this.start.col+r,this.start.row+t);e[t].push(n)}}return e}withStart(e){return new Fr(e,this.end)}sameDimensionsAs(e){return this.width()===e.width()&&this.height()===e.height()}sameAs(e){return Dr(this.start,e.start)&&Dr(this.end,e.end)}addressesArrayMap(e,t){const r=[];let n=this.start.row;for(;n<=this.effectiveEndRow(e);){let s=this.start.col;const o=[];for(;s<=this.effectiveEndColumn(e);)o.push(t(br(this.start.sheet,s,n))),s++;r.push(o),n++}return r}addresses(e){const t=[];let r=this.start.row;const n=this.effectiveEndRow(e),s=this.effectiveEndColumn(e);for(;r<=n;){let e=this.start.col;for(;e<=s;)t.push(br(this.start.sheet,e,r)),e++;r++}return t}*addressesWithDirection(e,t,r){if(e>0)if(t>0){let e=this.effectiveEndRow(r);for(;e>=this.start.row;){let t=this.effectiveEndColumn(r);for(;t>=this.start.col;)yield br(this.start.sheet,t,e),t-=1;e-=1}}else{let e=this.start.row;for(;e<=this.effectiveEndRow(r);){let t=this.effectiveEndColumn(r);for(;t>=this.start.col;)yield br(this.start.sheet,t,e),t-=1;e+=1}}else if(t>0){let e=this.effectiveEndRow(r);for(;e>=this.start.row;){let t=this.start.col;for(;t<=this.effectiveEndColumn(r);)yield br(this.start.sheet,t,e),t+=1;e-=1}}else{let e=this.start.row;for(;e<=this.effectiveEndRow(r);){let t=this.start.col;for(;t<=this.effectiveEndColumn(r);)yield br(this.start.sheet,t,e),t+=1;e+=1}}}getAddress(e,t){if(e<0||t<0||t>this.height()-1||e>this.width()-1)throw Error("Index out of bound");return br(this.start.sheet,this.start.col+e,this.start.row+t)}exceedsSheetSizeLimits(e,t){return this.end.col>=e||this.end.row>=t}effectiveEndColumn(e){return this.end.col}effectiveEndRow(e){return this.end.row}effectiveWidth(e){return this.width()}effectiveHeight(e){return this.height()}removeRows(e,t){if(!(e>this.end.row)){if(t<this.start.row){const r=t-e+1;return this.shiftByRows(-r)}e<=this.start.row&&(this.start.row=e),this.end.row-=Math.min(t,this.end.row)-e+1}}removeColumns(e,t){if(!(e>this.end.col)){if(t<this.start.col){const r=t-e+1;return this.shiftByColumns(-r)}e<=this.start.col&&(this.start.col=e),this.end.col-=Math.min(t,this.end.col)-e+1}}}class Ur extends Fr{constructor(e,t,r){super(br(e,t,0),br(e,r,Number.POSITIVE_INFINITY))}static fromColumnRange(e,t){const r=e.start.toSimpleColumnAddress(t),n=e.end.toSimpleColumnAddress(t);if(r.sheet!==n.sheet)throw new ft(r.sheet,n.sheet);return new Ur(r.sheet,r.col,n.col)}shouldBeRemoved(){return this.width()<=0}shiftByRows(e){}expandByRows(e){}shifted(e,t){return new Ur(this.sheet,this.start.col+e,this.end.col+e)}rangeWithSameHeight(e,t){return new Ur(this.sheet,e,e+t-1)}exceedsSheetSizeLimits(e,t){return this.end.col>=e}effectiveEndRow(e){return this.effectiveHeight(e)-1}effectiveHeight(e){return e.getSheetHeight(this.sheet)}removeRows(e,t){}}class Vr extends Fr{constructor(e,t,r){super(br(e,0,t),br(e,Number.POSITIVE_INFINITY,r))}static fromRowRangeAst(e,t){const r=e.start.toSimpleRowAddress(t),n=e.end.toSimpleRowAddress(t);if(r.sheet!==n.sheet)throw new ft(r.sheet,n.sheet);return new Vr(r.sheet,r.row,n.row)}shouldBeRemoved(){return this.height()<=0}shiftByColumns(e){}expandByColumns(e){}shifted(e,t){return new Vr(this.sheet,this.start.row+t,this.end.row+t)}rangeWithSameWidth(e,t){return new Vr(this.sheet,e,e+t-1)}exceedsSheetSizeLimits(e,t){return this.end.row>=t}effectiveEndColumn(e){return this.effectiveWidth(e)-1}effectiveWidth(e){return e.getSheetWidth(this.sheet)}removeColumns(e,t){}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Br{constructor(e,t,r){this.formulaAddress=e,this.arraysFlag=t,this.formulaVertex=r}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const Wr=/^\s*([+-]?)\s*(([\d\.,]+(e[+-]?\d+)?)\s*([ij]?)|([ij]))\s*(([+-])\s*([+-]?)\s*(([\d\.,]+(e[+-]?\d+)?)\s*([ij]?)|([ij])))?$/;class Yr{constructor(e,t,r){this.config=e,this.dateTimeHelper=t,this.numberLiteralsHelper=r,this.lt=(e,t)=>this.compare(e,t)<0,this.leq=(e,t)=>this.compare(e,t)<=0,this.gt=(e,t)=>this.compare(e,t)>0,this.geq=(e,t)=>this.compare(e,t)>=0,this.eq=(e,t)=>0===this.compare(e,t),this.neq=(e,t)=>0!==this.compare(e,t),this.pow=(e,t)=>Math.pow(je(e),je(t)),this.addWithEpsilonRaw=(e,t)=>{const r=e+t;return Math.abs(r)<this.actualEps*Math.abs(e)?0:r},this.addWithEpsilon=(e,t)=>{const r=nn(e,t);return this.ExtendedNumberFactory(this.addWithEpsilonRaw(je(e),je(t)),r)},this.unaryMinus=e=>ze(e,-je(e)),this.unaryPlus=e=>e,this.unaryPercent=e=>new Qe(je(e)/100),this.concat=(e,t)=>e.concat(t),this.nonstrictadd=(e,t)=>e instanceof Tr?e:t instanceof Tr?t:"number"==typeof e?"number"==typeof t?this.addWithEpsilonRaw(e,t):e:"number"==typeof t?t:0,this.subtract=(e,t)=>{const r=nn(e,t),n=je(e);let s=n-je(t);return Math.abs(s)<this.actualEps*Math.abs(n)&&(s=0),this.ExtendedNumberFactory(s,r)},this.divide=(e,t)=>{const r=je(e),n=je(t);if(0===n)return new Tr(or.DIV_BY_ZERO);{const s=sn(e,t);return this.ExtendedNumberFactory(r/n,s)}},this.multiply=(e,t)=>{const r=sn(e,t);return this.ExtendedNumberFactory(je(e)*je(t),r)},this.manyToExactComplex=e=>{const t=[];for(const r of e){if(r instanceof Tr)return r;if(Ze(r)||"string"==typeof r){const e=this.coerceScalarToComplex(r);e instanceof Tr||t.push(e)}}return t},this.coerceNumbersExactRanges=e=>this.manyToNumbers(e,this.manyToExactNumbers),this.coerceNumbersCoerceRangesDropNulls=e=>this.manyToNumbers(e,this.manyToCoercedNumbersDropNulls),this.manyToExactNumbers=e=>{const t=[];for(const r of e){if(r instanceof Tr)return r;Ze(r)&&t.push(je(r))}return t},this.manyToOnlyNumbersDropNulls=e=>{const t=[];for(const r of e){if(r instanceof Tr)return r;if(Ze(r))t.push(je(r));else if(r!==Ye)return new Tr(or.VALUE,Z.NumberExpected)}return t},this.manyToCoercedNumbersDropNulls=e=>{const t=[];for(const r of e){if(r instanceof Tr)return r;if(r===Ye)continue;const e=this.coerceScalarToNumberOrError(r);Ze(e)&&t.push(je(e))}return t},this.collator=
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function(e){const t=e.caseSensitive?e.accentSensitive?"variant":"case":e.accentSensitive?"accent":"base",r=e.caseFirst,n=e.ignorePunctuation;return new Intl.Collator(e.localeLang,{sensitivity:t,caseFirst:r,ignorePunctuation:n})}(e),this.actualEps=e.smartRounding?e.precisionEpsilon:0}eqMatcherFunction(e){const t=this.buildRegex(e);return e=>"string"==typeof e&&t.test(this.normalizeString(e))}neqMatcherFunction(e){const t=this.buildRegex(e);return e=>!("string"==typeof e&&t.test(this.normalizeString(e)))}searchString(e,t){var r;const n=this.buildRegex(e,!1).exec(t);return null!==(r=null==n?void 0:n.index)&&void 0!==r?r:-1}requiresRegex(e){if(!this.config.useRegularExpressions&&!this.config.useWildcards)return!this.config.matchWholeCell;for(let t=0;t<e.length;t++){const r=e.charAt(t);if(en(r)||this.config.useRegularExpressions&&rn(r))return!0}return!1}floatCmp(e,t){const r=je(e),n=je(t),s=1+this.actualEps;return n>=0&&r*s>=n&&r<=n*s||n<=0&&r*s<=n&&r>=n*s?0:r>n?1:-1}coerceScalarToNumberOrError(e){var t;return e instanceof Tr?e:null!==(t=this.coerceToMaybeNumber(e))&&void 0!==t?t:new Tr(or.VALUE,Z.NumberCoercion)}coerceToMaybeNumber(e){var t;return null!==(t=this.coerceNonDateScalarToMaybeNumber(e))&&void 0!==t?t:"string"==typeof e?this.dateTimeHelper.dateStringToDateNumber(e):void 0}coerceNonDateScalarToMaybeNumber(e){if(e===Ye)return 0;if("string"==typeof e){if(""===e)return 0;const t=this.coerceStringToMaybePercentNumber(e);if(void 0!==t)return t;const r=this.coerceStringToMaybeCurrencyNumber(e);return void 0!==r?r:this.numberLiteralsHelper.numericStringToMaybeNumber(e.trim())}return Ze(e)?e:"boolean"==typeof e?Number(e):void 0}coerceStringToMaybePercentNumber(e){const t=e.trim();if(t.endsWith("%")){const e=t.slice(0,t.length-1).trim(),r=this.numberLiteralsHelper.numericStringToMaybeNumber(e);if(void 0!==r)return new Qe(r/100)}}coerceStringToMaybeCurrencyNumber(e){const t=this.currencyMatcher(e.trim());if(void 0!==t){const[e,r]=t,n=this.numberLiteralsHelper.numericStringToMaybeNumber(r);if(void 0!==n)return new Ke(n,e)}}currencyMatcher(e){for(const t of this.config.currencySymbol){if(e.startsWith(t))return[t,e.slice(t.length).trim()];if(e.endsWith(t))return[t,e.slice(0,e.length-t.length).trim()]}}coerceComplexExactRanges(e){const t=[];for(const r of e)if(r instanceof rt)t.push(r);else if(r!==Ye){const e=this.coerceScalarToComplex(r);if(e instanceof Tr)return e;t.push(e)}const r=[];for(const e of t)if(e instanceof rt){const t=this.manyToExactComplex(e.valuesFromTopLeftCorner());if(t instanceof Tr)return t;r.push(...t)}else r.push(e);return r}coerceScalarToComplex(e){return e instanceof Tr?e:e===Ye?[0,0]:Ze(e)?[je(e),0]:"string"==typeof e?this.coerceStringToComplex(e):new Tr(or.NUM,Z.ComplexNumberExpected)}ExtendedNumberFactory(e,t){const{type:r,format:n}=t;switch(r){case Je.NUMBER_RAW:return e;case Je.NUMBER_CURRENCY:return new Ke(e,null!=n?n:this.config.currencySymbol[0]);case Je.NUMBER_DATE:return new $e(e,n);case Je.NUMBER_DATETIME:return new qe(e,n);case Je.NUMBER_TIME:return new Xe(e,n);case Je.NUMBER_PERCENT:return new Qe(e,n)}}buildRegex(e,t=!0){let r;e=this.normalizeString(e);let n=this.config.useWildcards,s=this.config.useRegularExpressions;if(s)try{RegExp(e)}catch(e){s=!1,n=!1}return r=s?function(e,t){let r="";for(let n=0;n<e.length;n++){const s=e.charAt(n);en(s)||rn(s)?r+=s:r+=t?s:s.toLowerCase()}return r}(e,this.config.caseSensitive):n?function(e,t){let r="";for(let n=0;n<e.length;n++){const s=e.charAt(n);if("~"===s){if(n==e.length-1){r+="~";continue}const t=e.charAt(n+1);en(t)||rn(t)?(r+="\\"+t,n++):(r+=t,n++)}else en(s)?r+="."+s:rn(s)?r+="\\"+s:r+=t?s:s.toLowerCase()}return r}(e,this.config.caseSensitive):function(e,t){let r="";for(let n=0;n<e.length;n++){const s=e.charAt(n);en(s)||rn(s)?r+="\\"+s:r+=t?s:s.toLowerCase()}return r}(e,this.config.caseSensitive),this.config.matchWholeCell&&t?RegExp("^("+r+")$"):RegExp(r)}normalizeString(e){return this.config.caseSensitive||(e=e.toLowerCase()),this.config.accentSensitive||(e=ln(e,"nfd").replace(/[\u0300-\u036f]/g,"")),e}compare(e,t){if("string"==typeof e||"string"==typeof t){const r="string"==typeof e?this.dateTimeHelper.dateStringToDateNumber(e):e,n="string"==typeof t?this.dateTimeHelper.dateStringToDateNumber(t):t;if(Ze(r)&&Ze(n))return this.floatCmp(r,n)}return e===Ye?e=$r(t):t===Ye&&(t=$r(e)),"string"==typeof e&&"string"==typeof t?this.stringCmp(e,t):"boolean"==typeof e&&"boolean"==typeof t?Qr(zr(e),zr(t)):Ze(e)&&Ze(t)?this.floatCmp(e,t):e===Ye&&t===Ye?0:Qr(Cr(Rr(e)),Cr(Rr(t)))}stringCmp(e,t){return this.collator.compare(e,t)}manyToNumbers(e,t){const r=[];for(const t of e)if(t instanceof rt)r.push(t);else{const e=je(this.coerceScalarToNumberOrError(t));if(e instanceof Tr)return e;r.push(e)}const n=[];for(const e of r)if(e instanceof rt){const r=t(e.valuesFromTopLeftCorner());if(r instanceof Tr)return r;n.push(...r)}else n.push(e);return n}coerceStringToComplex(e){const t=Wr.exec(e);if(null===t)return new Tr(or.NUM,Z.ComplexNumberExpected);let r,n;return r=void 0!==t[6]?"-"===t[1]?[0,-1]:[0,1]:this.parseComplexToken(t[1]+t[3],t[5]),r instanceof Tr||void 0===t[8]?r:(n=void 0!==t[14]?"-"===t[9]?[0,-1]:[0,1]:this.parseComplexToken(t[9]+t[11],t[13]),n instanceof Tr?n:""!==t[5]||""===t[13]?new Tr(or.NUM,Z.ComplexNumberExpected):"+"===t[8]?[r[0]+n[0],r[1]+n[1]]:[r[0]-n[0],r[1]-n[1]])}parseComplexToken(e,t){const r=je(this.coerceNonDateScalarToMaybeNumber(e));return void 0===r?new Tr(or.NUM,Z.ComplexNumberExpected):""===t?[r,0]:[0,r]}}function jr([e,t],r){if(!isFinite(e)||!isFinite(t))return new Tr(or.NUM,Z.NaN);if(r=null!=r?r:"i",0===t)return`${e}`;const n=`${-1===t||1===t?"":Math.abs(t)}${r}`;return 0===e?`${t<0?"-":""}${n}`:`${e}${t<0?"-":"+"}${n}`}function Gr(e){return e instanceof rt?e:rt.fromScalar(e)}function zr(e){return Number(e)}function $r(e){return"string"==typeof e?"":Ze(e)?0:"boolean"!=typeof e&&Ye}function Kr(e){if(e instanceof Tr||"boolean"==typeof e)return e;if(e===Ye)return!1;if(Ze(e))return 0!==je(e);{const t=e.toUpperCase();return"TRUE"===t||"FALSE"!==t&&(""!==t&&void 0)}}function Xr(e){return e instanceof Tr||"string"==typeof e?e:e===Ye?"":Ze(e)?je(e).toString():e?"TRUE":"FALSE"}function qr(e){return e===Ye?0:e}function Qr(e,t){const r=je(e),n=je(t);return r>n?1:r<n?-1:0}function Zr(e){return isNaN(e)||e===1/0||e===-1/0}function Jr(e){return 0===e?0:e}function en(e){return["*","?"].includes(e)}const tn=["{","}","[","]","(",")","<",">","=",".","+","-",",","\\","$","^","!"];function rn(e){return tn.includes(e)}function nn(e,t){const{type:r,format:n}=tt(e),{type:s,format:o}=tt(t);if(r===Je.NUMBER_RAW)return{type:s,format:o};if(s===Je.NUMBER_RAW)return{type:r,format:n};if(!(r!==Je.NUMBER_DATETIME&&r!==Je.NUMBER_DATE||s!==Je.NUMBER_DATETIME&&s!==Je.NUMBER_DATE))return{type:Je.NUMBER_RAW};if(r===Je.NUMBER_TIME){if(s===Je.NUMBER_DATE)return{type:Je.NUMBER_DATETIME,format:`${o} ${n}`};if(s===Je.NUMBER_DATETIME)return{type:Je.NUMBER_DATETIME,format:o}}if(s===Je.NUMBER_TIME){if(r===Je.NUMBER_DATE)return{type:Je.NUMBER_DATETIME,format:`${n} ${o}`};if(r===Je.NUMBER_DATETIME)return{type:Je.NUMBER_DATETIME,format:n}}return{type:r,format:n}}function sn(e,t){let{type:r,format:n}=tt(e),{type:s,format:o}=tt(t);return r===Je.NUMBER_PERCENT&&(r=Je.NUMBER_RAW,n=void 0),s===Je.NUMBER_PERCENT&&(s=Je.NUMBER_RAW,o=void 0),r===Je.NUMBER_RAW?{type:s,format:o}:s===Je.NUMBER_RAW?{type:r,format:n}:{type:Je.NUMBER_RAW}}function on(e){return ln(e.toLowerCase(),"nfd").replace(/[\u0300-\u036f]/g,"")}function an(e,t){var r;if(e.isAdHoc())return null===(r=e.data[0])||void 0===r?void 0:r[0];const n=e.range;if(t.formulaAddress.sheet===n.sheet)if(1===n.width()){const r=t.formulaAddress.row-n.start.row;if(r>=0&&r<n.height())return e.data[r][0]}else if(1===n.height()){const r=t.formulaAddress.col-n.start.col;if(r>=0&&r<n.width())return e.data[0][r]}}function ln(e,t){return e.normalize(t.toUpperCase())}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
var hn;!function(e){e.STRING="STRING",e.NUMBER="NUMBER",e.BOOLEAN="BOOLEAN",e.SCALAR="SCALAR",e.NOERROR="NOERROR",e.RANGE="RANGE",e.INTEGER="INTEGER",e.COMPLEX="COMPLEX",e.ANY="ANY"}(hn||(hn={}));class un{constructor(e){this.coerceScalarToNumberOrError=e=>this.arithmeticHelper.coerceScalarToNumberOrError(e),this.runFunction=(e,t,r,n)=>{const s=this.evaluateArguments(e,t,r),o=s.map((([e,t])=>e)),i=s.map((([e,t])=>t)),a=this.buildMetadataForEachArgumentValue(o.length,r),l=t.arraysFlag&&!r.vectorizationForbidden;if(!this.isNumberOfArgumentValuesValid(a,o.length))return new Tr(or.NA,Z.WrongArgNumber);const[h,u]=l?this.calculateSizeOfVectorizedResultArray(o,a):[1,1];if(1===h&&1===u){const e=this.vectorizeAndBroadcastArgumentsIfNecessary(l,o,a,0,0);return this.calculateSingleCellOfResultArray(t,e,a,i,n,r.returnNumberType)}const c=[...Array(h).keys()].map((e=>[...Array(u).keys()].map((s=>{const h=this.vectorizeAndBroadcastArgumentsIfNecessary(l,o,a,e,s),u=this.calculateSingleCellOfResultArray(t,h,a,i,n,r.returnNumberType);if(u instanceof rt)throw new Error("Function returning array cannot be vectorized.");return u}))));return rt.onlyValues(c)},this.runFunctionWithReferenceArgument=(e,t,r,n,s,o=(()=>new Tr(or.NA,Z.CellRefExpected)))=>{if(0===e.length)return this.returnNumberWrapper(n(),r.returnNumberType);if(e.length>1)return new Tr(or.NA,Z.WrongArgNumber);let i,a=e[0];for(;a.type===U.PARENTHESIS;)a=a.expression;if(a.type===U.CELL_REFERENCE)i=a.reference.toSimpleCellAddress(t.formulaAddress);else if(a.type===U.CELL_RANGE||a.type===U.COLUMN_RANGE||a.type===U.ROW_RANGE)try{i=Fr.fromAst(a,t.formulaAddress).start}catch(e){return new Tr(or.REF,Z.CellRefExpected)}return void 0!==i?this.returnNumberWrapper(s(i),r.returnNumberType):this.runFunction(e,t,r,o)},this.interpreter=e,this.dependencyGraph=e.dependencyGraph,this.columnSearch=e.columnSearch,this.config=e.config,this.serialization=e.serialization,this.arraySizePredictor=e.arraySizePredictor,this.dateTimeHelper=e.dateTimeHelper,this.arithmeticHelper=e.arithmeticHelper}evaluateAst(e,t){return this.interpreter.evaluateAst(e,t)}arraySizeForAst(e,t){return this.arraySizePredictor.checkArraySizeForAst(e,t)}listOfScalarValues(e,t){const r=[];for(const n of e){const e=this.evaluateAst(n,t);if(e instanceof rt)for(const t of e.valuesFromTopLeftCorner())r.push([t,!0]);else r.push([e,!1])}return r}coerceToType(e,t,r){let n;if(e instanceof rt)switch(t.argumentType){case hn.RANGE:case hn.ANY:n=e;break;default:{const t=an(e,r);if(void 0===t)return;e=t}}if(!(e instanceof rt))switch(t.argumentType){case hn.INTEGER:case hn.NUMBER:const r=this.coerceScalarToNumberOrError(e);if(!Ze(r)){n=r;break}const s=je(r);if(void 0!==t.maxValue&&s>t.maxValue)return new Tr(or.NUM,Z.ValueLarge);if(void 0!==t.minValue&&s<t.minValue)return new Tr(or.NUM,Z.ValueSmall);if(void 0!==t.lessThan&&s>=t.lessThan)return new Tr(or.NUM,Z.ValueLarge);if(void 0!==t.greaterThan&&s<=t.greaterThan)return new Tr(or.NUM,Z.ValueSmall);if(t.argumentType===hn.INTEGER&&!Number.isInteger(s))return new Tr(or.NUM,Z.IntegerExpected);n=r;break;case hn.STRING:n=Xr(e);break;case hn.BOOLEAN:n=Kr(e);break;case hn.SCALAR:case hn.NOERROR:case hn.ANY:n=e;break;case hn.RANGE:if(e instanceof Tr)return e;n=Gr(e);break;case hn.COMPLEX:return this.arithmeticHelper.coerceScalarToComplex(je(e))}return t.passSubtype||void 0===n?n:je(n)}calculateSingleCellOfResultArray(e,t,r,n,s,o){const i=this.coerceArgumentsToRequiredTypes(e,t,r,n);if(i instanceof Tr)return i;const a=s(...i);return this.returnNumberWrapper(a,o)}coerceArgumentsToRequiredTypes(e,t,r,n){const s=[];for(let o=0;o<r.length;o++){const i=r[o],a=void 0!==t[o]?t[o]:null==i?void 0:i.defaultValue;if(void 0===a){s.push(void 0);continue}const l=this.coerceToType(a,i,e);if(void 0===l&&!n[o])return new Tr(or.VALUE,Z.WrongType);if(l instanceof Tr&&i.argumentType!==hn.SCALAR)return l;s.push(l)}return s}vectorizeAndBroadcastArgumentsIfNecessary(e,t,r,n,s){return t.map(((t,o)=>e&&this.isRangePassedAsAScalarArgument(t,r[o])?this.vectorizeAndBroadcastRangeArgument(t,n,s):t))}vectorizeAndBroadcastRangeArgument(e,t,r){var n;const s=1===e.height()?0:t,o=1===e.width()?0:r;return null===(n=e.data[s])||void 0===n?void 0:n[o]}evaluateArguments(e,t,r){return r.expandRanges?this.listOfScalarValues(e,t):e.map((e=>[this.evaluateAst(e,t),!1]))}buildMetadataForEachArgumentValue(e,t){const r=t.parameters?[...t.parameters]:[];if(void 0!==t.repeatLastArgs&&Number.isInteger(t.repeatLastArgs)&&t.repeatLastArgs>0)for(;e>r.length;)r.push(...r.slice(r.length-t.repeatLastArgs));return r}isNumberOfArgumentValuesValid(e,t){if(t>e.length)return!1;if(t<e.length){return e.slice(t).every((e=>(null==e?void 0:e.optionalArg)||void 0!==(null==e?void 0:e.defaultValue)))}return!0}calculateSizeOfVectorizedResultArray(e,t){const r=e.filter(((e,r)=>this.isRangePassedAsAScalarArgument(e,t[r])));return[Math.max(1,...r.map((e=>e.height()))),Math.max(1,...r.map((e=>e.width())))]}isRangePassedAsAScalarArgument(e,t){return null!=e&&null!=t&&(e instanceof rt&&![hn.RANGE,hn.ANY].includes(t.argumentType))}metadata(e){const t=this.constructor.implementedFunctions[e];if(void 0!==t)return t;throw new Error(`No metadata for function ${e}.`)}returnNumberWrapper(e,t,r){return void 0!==t&&Ze(e)?this.arithmeticHelper.ExtendedNumberFactory(je(e),{type:t,format:r}):e}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class cn{constructor(e,t,r=!1){this.width=e,this.height=t,this.isRef=r}static error(){return new cn(1,1,!0)}static scalar(){return new cn(1,1,!1)}isScalar(){return 1===this.width&&1===this.height||this.isRef}}class dn{constructor(e,t){this.config=e,this.functionRegistry=t}checkArraySize(e,t){return this.checkArraySizeForAst(e,{formulaAddress:t,arraysFlag:this.config.useArrayArithmetic})}checkArraySizeForAst(e,t){switch(e.type){case U.FUNCTION_CALL:return this.checkArraySizeForFunction(e,t);case U.COLUMN_RANGE:case U.ROW_RANGE:case U.CELL_RANGE:{const r=Fr.fromAstOrUndef(e,t.formulaAddress);return void 0===r?cn.error():new cn(r.width(),r.height(),!0)}case U.ARRAY:{const r=[],n=[];for(const s of e.args){const e=s.map((e=>this.checkArraySizeForAst(e,t))),o=Math.min(...e.map((e=>e.height))),i=e.reduce(((e,t)=>e+t.width),0);r.push(o),n.push(i)}const s=r.reduce(((e,t)=>e+t),0),o=Math.min(...n);return new cn(o,s)}case U.STRING:case U.NUMBER:return cn.scalar();case U.CELL_REFERENCE:return new cn(1,1,!0);case U.DIV_OP:case U.CONCATENATE_OP:case U.EQUALS_OP:case U.GREATER_THAN_OP:case U.GREATER_THAN_OR_EQUAL_OP:case U.LESS_THAN_OP:case U.LESS_THAN_OR_EQUAL_OP:case U.MINUS_OP:case U.NOT_EQUAL_OP:case U.PLUS_OP:case U.POWER_OP:case U.TIMES_OP:{const r=this.checkArraySizeForAst(e.left,t),o=this.checkArraySizeForAst(e.right,t);return!t.arraysFlag&&(r.height>1||r.width>1||o.height>1||o.width>1)?cn.error():(n=r,s=o,new cn(Math.max(n.width,s.width),Math.max(n.height,s.height)))}case U.MINUS_UNARY_OP:case U.PLUS_UNARY_OP:case U.PERCENT_OP:{const n=this.checkArraySizeForAst(e.value,t);return!t.arraysFlag&&(n.height>1||n.width>1)?cn.error():new cn((r=n).width,r.height)}case U.PARENTHESIS:return this.checkArraySizeForAst(e.expression,t);case U.EMPTY:default:return cn.error()}var r,n,s}checkArraySizeForFunction(e,t){const r=this.functionRegistry.getArraySizeFunction(e.procedureName);if(void 0!==r)return r(e,t);const n=this.functionRegistry.getMetadata(e.procedureName);if(void 0===n||n.expandRanges||!t.arraysFlag||n.vectorizationForbidden||void 0===n.parameters)return new cn(1,1);const s=e.args.map((e=>{var r;return this.checkArraySizeForAst(e,new Br(t.formulaAddress,t.arraysFlag||null!==(r=null==n?void 0:n.arrayFunction)&&void 0!==r&&r))})),o=[...n.parameters];if(void 0!==n.repeatLastArgs&&o.length<s.length&&(s.length-o.length)%n.repeatLastArgs!=0)return cn.error();for(;o.length<s.length;){if(void 0===n.repeatLastArgs)return cn.error();o.push(...o.slice(o.length-n.repeatLastArgs))}let i=1,a=1;for(let e=0;e<s.length;e++)o[e].argumentType!==hn.RANGE&&o[e].argumentType!==hn.ANY&&(a=Math.max(a,s[e].height),i=Math.max(i,s[e].width));return new cn(i,a)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class pn{constructor(e,t,r){var n;this.value=t,this.address=r,this.type=e.type,this.message=null!==(n=e.message)&&void 0!==n?n:""}toString(){return this.value}valueOf(){return this.value}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function gn(e,t,r){if(void 0===e)return Xo.defaultConfig[r];if("string"==typeof t){if(typeof e===t)return e;throw new Tt(t,r)}if(t.includes(e))return e;throw new At(t.map((e=>`'${e}'`)).join(" "),r)}function fn(e,t,r){if(e<r)throw new _t(t,r)}function mn(e,t,r,n){if(t(e))return e;if(void 0===e)return Xo.defaultConfig[n];throw new Tt(r,n)}function En(...e){const t=new Map;e.forEach((e=>{const r=t.get(e.value)||[];r.push(e.name),t.set(e.value,r)}));const r=[];for(const e of t.values())e.length>1&&r.push(e);if(r.length>0){r.forEach((e=>e.sort()));const e=r.map((e=>`[${e}]`)).join("; ");throw new Error(`Config initialization failed. Parameters in conflict: ${e}`)}}function yn(e,t,r){if(typeof e!==t)throw new Tt(t,r)}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const wn=new RegExp("^ss(\\.(s+|0+))?$"),Cn=new RegExp("^[0-9/.\\-: ]+[ap]?m?$"),Rn=new RegExp("\\s+"),vn=new RegExp("[ /.-]"),Sn=1e3,Tn=An((function(e){const t=e.toLowerCase().trim(),r=(t.endsWith("am/pm")?t.substring(0,t.length-5):t.endsWith("a/p")?t.substring(0,e.length-3):t).trim().split(":");return{itemsCount:r.length,hourItem:r.indexOf("hh"),minuteItem:r.indexOf("mm"),secondItem:r.findIndex((e=>wn.test(e)))}})),Nn=An((function(e){const t=e.toLowerCase().trim().split(vn);return{itemsCount:t.length,dayItem:t.indexOf("dd"),monthItem:t.indexOf("mm"),shortYearItem:t.indexOf("yy"),longYearItem:t.indexOf("yyyy")}}));function _n(e,t){var r,n,s;if(void 0===t)return;const{itemsCount:o,hourItem:i,minuteItem:a,secondItem:l}=Tn(t);let h;if("am"===e[e.length-1]||"a"===e[e.length-1]?(h=!1,e.pop()):"pm"!==e[e.length-1]&&"p"!==e[e.length-1]||(h=!0,e.pop()),e.length!==o)return;const u=Number(null!==(r=e[l])&&void 0!==r?r:"0");if(!Number.isFinite(u))return;const c=Math.round(u*Sn)/Sn,d=Number(null!==(n=e[a])&&void 0!==n?n:"0");if(!Number.isFinite(d)||!Number.isInteger(d))return;const p=Number(null!==(s=e[i])&&void 0!==s?s:"0");if(!Number.isFinite(p)||!Number.isInteger(p))return;if(void 0!==h&&(p<0||p>12))return;return{hours:void 0!==h?p%12+(h?12:0):p,minutes:d,seconds:c}}function Mn(e,t){var r;if(void 0===t)return;const{itemsCount:n,dayItem:s,monthItem:o,shortYearItem:i,longYearItem:a}=Nn(t);if(e.length!==n)return;const l=Number(e[s]);if(!Number.isFinite(l)||!Number.isInteger(l))return;const h=Number(e[o]);if(!Number.isFinite(h)||!Number.isInteger(h))return;if(e[a]&&e[i])return;const u=Number(null!==(r=e[a])&&void 0!==r?r:e[i]);return Number.isFinite(u)&&Number.isInteger(u)&&!(e[a]&&(u<1e3||u>9999)||e[i]&&(u<0||u>99))?{year:u,month:h,day:l}:void 0}function An(e){const t={};return r=>{const n=t[r];if(void 0!==n)return n;const s=e(r);return t[r]=s,s}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const bn=[31,28,31,30,31,30,31,31,30,31,30,31],In=[0,31,59,90,120,151,181,212,243,273,304,334],On=60,xn=60,Pn=24;function Ln(e){return!(!e||"object"!=typeof e&&"function"!=typeof e)&&("year"in e&&"number"==typeof e.year&&"month"in e&&"number"==typeof e.month&&"day"in e&&"number"==typeof e.day)}function Dn(e){return!(!e||"object"!=typeof e&&"function"!=typeof e)&&("hours"in e&&"number"==typeof e.hours&&"minutes"in e&&"number"==typeof e.minutes&&"seconds"in e&&"number"==typeof e.seconds)}const kn={year:9999,month:12,day:31};class Hn{constructor(e){this.config=e,this.minDateAbsoluteValue=this.dateToNumberFromZero(e.nullDate),this.maxDateValue=this.dateToNumber(kn),this.leapYear1900=e.leapYear1900,!this.leapYear1900&&0<=this.dateToNumber({year:1900,month:2,day:28})?this.epochYearZero=this.numberToSimpleDate(2).year:this.epochYearZero=this.numberToSimpleDate(1).year,this.parseDateTime=e.parseDateTime}getWithinBounds(e){return e<=this.maxDateValue&&e>=0?e:void 0}dateStringToDateNumber(e){const{dateTime:t,dateFormat:r="",timeFormat:n=""}=this.parseDateTimeFromConfigFormats(e);if(void 0!==t)return Dn(t)?Ln(t)?new qe(Bn(t)+this.dateToNumber(t),r+" "+n):new Xe(Bn(t),n):Ln(t)?new $e(this.dateToNumber(t),r):0}parseDateTimeFromConfigFormats(e){return this.parseDateTimeFromFormats(e,this.config.dateFormats,this.config.timeFormats)}getNullYear(){return this.config.nullYear}getEpochYearZero(){return this.epochYearZero}isValidDate(e){return!(isNaN(e.year)||isNaN(e.month)||isNaN(e.day))&&(e.day===Math.round(e.day)&&e.month===Math.round(e.month)&&e.year===Math.round(e.year)&&(!(e.year<1582)&&(!(e.month<1||e.month>12)&&(!(e.day<1)&&(this.isLeapYear(e.year)&&2===e.month?e.day<=29:e.day<=bn[e.month-1])))))}dateToNumber(e){return this.dateToNumberFromZero(e)-this.minDateAbsoluteValue}relativeNumberToAbsoluteNumber(e){return e+this.minDateAbsoluteValue-(this.leapYear1900?1:0)}numberToSimpleDate(e){const t=Math.floor(e)+this.minDateAbsoluteValue;let r=Math.floor(t/365.2425);this.dateToNumberFromZero({year:r+1,month:1,day:1})<=t?r++:this.dateToNumberFromZero({year:r-1,month:1,day:1})>t&&r--;const n=t-this.dateToNumberFromZero({year:r,month:1,day:1}),s=function(e){let t=0;In[t+6]<=e&&(t+=6);In[t+3]<=e&&(t+=3);In[t+2]<=e?t+=2:In[t+1]<=e&&(t+=1);return t}(n-(this.isLeapYear(r)&&n>=59?1:0));return{year:r,month:s+1,day:n-In[s]-(this.isLeapYear(r)&&s>1?1:0)+1}}numberToSimpleDateTime(e){const t=Vn(e%1),r=Math.floor(t.hours/Pn);t.hours=t.hours%Pn;const n=this.numberToSimpleDate(Math.floor(e)+r);return Object.assign(Object.assign({},n),t)}leapYearsCount(e){return Math.floor(e/4)-Math.floor(e/100)+Math.floor(e/400)+(this.config.leapYear1900&&e>=1900?1:0)}daysInMonth(e,t){return this.isLeapYear(e)&&2===t?29:bn[t-1]}endOfMonth(e){return{year:e.year,month:e.month,day:this.daysInMonth(e.year,e.month)}}toBasisUS(e,t){return 31===e.day&&(e.day=30),30===e.day&&31===t.day&&(t.day=30),2===e.month&&e.day===this.daysInMonth(e.year,e.month)&&(e.day=30,2===t.month&&t.day===this.daysInMonth(t.year,t.month)&&(t.day=30)),[e,t]}yearLengthForBasis(e,t){return e.year!==t.year?e.year+1!==t.year||e.month<t.month||e.month===t.month&&e.day<t.day?(this.leapYearsCount(t.year)-this.leapYearsCount(e.year-1))/(t.year-e.year+1)+365:this.countLeapDays(t)!==this.countLeapDays({year:e.year,month:e.month,day:e.day-1})?366:365:this.isLeapYear(e.year)?366:365}parseSingleFormat(e,t,r){const n=this.parseDateTime(e,t,r);if(!Ln(n)||(n.year>=0&&n.year<100&&(n.year<this.getNullYear()?n.year+=2e3:n.year+=1900),this.isValidDate(n)))return n}parseDateTimeFromFormats(e,t,r){const n=0===t.length?[void 0]:t,s=0===r.length?[void 0]:r;for(const t of n)for(const r of s){const n=this.parseSingleFormat(e,t,r);if(void 0!==n)return{dateTime:n,timeFormat:r,dateFormat:t}}return{}}countLeapDays(e){return e.month>2||2===e.month&&e.day>=29?this.leapYearsCount(e.year):this.leapYearsCount(e.year-1)}dateToNumberFromZero(e){return 365*e.year+In[e.month-1]+e.day-1+(e.month<=2?this.leapYearsCount(e.year-1):this.leapYearsCount(e.year))}isLeapYear(e){return!(e%4)&&(!!(e%100)||(!(e%400)||1900===e&&this.config.leapYear1900))}}function Fn(e,t){const r=12*e.year+e.month-1+t;return{year:Math.floor(r/12),month:r%12+1,day:e.day}}function Un(e){return Math.round(3600*e*24)/86400}function Vn(e){const t=e*Pn*xn*On,r=function(e,t=1){return Math.round(e*t)/t}(t%On,1e5)%On,n=(t-r)/On,s=Math.round(n%xn)%xn,o=(n-s)/xn;return{hours:Math.round(o),minutes:s,seconds:r}}function Bn(e){return((e.seconds/60+e.minutes)/60+e.hours)/24}function Wn(e){return{year:e.year,month:e.month,day:Math.min(30,e.day)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const Yn=/(\\.|dd|DD|d|D|mm|MM|m|M|YYYY|YY|yyyy|yy|HH|hh|H|h|ss(\.(0+|s+))?|s|AM\/PM|am\/pm|A\/P|a\/p|\[mm]|\[MM]|\[hh]|\[HH])/g,jn=/(\\.|[#0]+(\.[#0]*)?)/g;var Gn,zn;function $n(e,t){return{type:e,value:t}}function Kn(e,t){const r=[];let n=0;for(let s=0;s<e.length;++s){const o=e[s];if(o.index!==n){const e=t.substr(n,o.index-n);r.push($n(Gn.FREE_TEXT,e))}o[0].startsWith("\\")?r.push($n(Gn.FREE_TEXT,o[0])):r.push($n(Gn.FORMAT,o[0])),n=o.index+o[0].length}const s=e[e.length-1];if(s.index+s[0].length<t.length){const e=t.substr(s.index+s[0].length,t.length);r.push($n(Gn.FREE_TEXT,e))}return r}function Xn(e){const t=function(e){Yn.lastIndex=0;const t=[];let r;do{r=Yn.exec(e),null!==r&&t.push(r)}while(r);return t}(e);return t.every((e=>Qn(e)))?void 0:{type:zn.DATE,tokens:Kn(t,e)}}function qn(e){const t=function(e){jn.lastIndex=0;const t=jn.exec(e);return null!==t?[t]:[]}(e);return t.every((e=>Qn(e)))?void 0:{type:zn.NUMBER,tokens:Kn(t,e)}}function Qn(e){return e[0].startsWith("\\")}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function Zn(e,t,r,n){const s=r.stringifyDateTime(n.numberToSimpleDateTime(e),t);if(void 0!==s)return s;const o=r.stringifyDuration(Vn(e),t);if(void 0!==o)return o;const i=qn(t);return void 0!==i?function(e,t){let r="";for(let n=0;n<e.length;++n){const s=e[n];if(s.type===Gn.FREE_TEXT){r+=s.value;continue}const o=s.value.split("."),i=o[0],a=o[1]||"",l=o[1]?".":"",h=Number(t.toFixed(a.length)).toString().split(".");let u=h[0]||"",c=h[1]||"";if(i.length>u.length){u=Jn(u,ts(i.substr(0,i.length-u.length),"0")+u.length)}c=es(c,ts(a.substr(c.length,a.length-c.length),"0")+c.length),r+=u+l+c}return r}(i.tokens,e):t}function Jn(e,t){let r=`${e}`;for(;r.length<t;)r="0"+r;return r}function es(e,t){let r=`${e}`;for(;r.length<t;)r+="0";return r}function ts(e,t){return e.split(t).length-1}!function(e){e.FORMAT="FORMAT",e.FREE_TEXT="FREE_TEXT"}(Gn||(Gn={})),function(e){e.DATE="DATE",e.NUMBER="NUMBER",e.STRING="STRING"}(zn||(zn={}));
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const rs="length",ns=e=>parseInt(e,16),ss=e=>parseInt(e,10),os=e=>(e+"").replace(/\-/g,""),is=(e,t,r)=>e.substr(t,r),as=e=>e.codePointAt(0)-65;
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const ls={invalid:()=>"The license key for HyperFormula is invalid.",expired:({keyValidityDate:e})=>`The license key for HyperFormula expired on ${e}, and is not valid for the installed version.`,missing:()=>"The license key for HyperFormula is missing."};let hs=!1;function us(e){const t={template:"missing",vars:{}};if("gpl-v3"===e||"internal-use-in-handsontable"===e)t.template="valid";else if("string"==typeof e&&function(e){if((e=(e+"").replace(/\-/g,""))[rs]!==as("Z"))return!1;let t=0;return[[0,as("G")+1],[as("H"),as("H")-1],[as("G")+as("H"),as("G")]].reduce(((r,[n,s],o)=>(r|=(ss(`${ss(ns(is(e,t+n-(0===o?0:2),s+(o?2:0)))+(ns(is(e,t+n+s,2))+[]).padStart(2,"0"))}`)%97||2)>>1,t+=2,r)),as("A"))===[]+1>>1}(e)){const[n,s,o]="15/02/2024".split("/"),i=Math.floor(new Date(`${s}/${n}/${o}`).getTime()/864e5),a=25===os(r=e)[rs]?ns(is(os(r),ns("12"),as("F")))/(ns(is(os(r),as("C"),as("Y")>>4))||1+(![][rs]<<3)):0;t.vars.keyValidityDate=function(e){const t=["January","February","March","April","May","June","July","August","September","October","November","December"][e.getMonth()],r=e.getDate(),n=e.getFullYear();return`${t} ${r}, ${n}`}(new Date(864e5*(a+1))),t.template=i>a?"expired":"valid"}else""!==e&&(t.template="invalid");var r;return hs||"valid"===t.template||(console.warn(ls[t.template](t.vars)),hs=!0),t.template}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
var cs,ds,ps;!function(e){e.Number=class{constructor(e){this.value=e,this.value=ze(this.value,Jr(je(this.value)))}};e.String=class{constructor(e){this.value=e}};e.Boolean=class{constructor(e){this.value=e}};class t{static getSingletonInstance(){return t.instance||(t.instance=new t),t.instance}}e.Empty=t;e.Formula=class{constructor(e){this.formula=e}};e.Error=class{constructor(e,t){this.value=new Tr(e,t)}}}(cs||(cs={}));class gs{constructor(e,t,r){this.config=e,this.dateHelper=t,this.numberLiteralsHelper=r}parse(e){if(null==e)return cs.Empty.getSingletonInstance();if("number"==typeof e)return Zr(e)?new cs.Error(or.NUM,Z.ValueLarge):new cs.Number(e);if("boolean"==typeof e)return new cs.Boolean(e);if(e instanceof Date){const t=this.dateHelper.dateToNumber({day:e.getDate(),month:e.getMonth()+1,year:e.getFullYear()})+Bn({hours:e.getHours(),minutes:e.getMinutes(),seconds:e.getSeconds()+e.getMilliseconds()/1e3});return t<0?new cs.Error(or.NUM,Z.DateBounds):t%1==0?new cs.Number(new $e(t,"Date()")):t<1?new cs.Number(new Xe(t,"Date()")):new cs.Number(new qe(t,"Date()"))}if("string"==typeof e){if(function(e){const t=e.toLowerCase();return"true"===t||"false"===t}(e))return new cs.Boolean("true"===e.toLowerCase());if(e.startsWith("="))return new cs.Formula(e);if(function(e,t){const r=e.toUpperCase();return/#[A-Za-z0-9\/]+[?!]?/.test(r)&&Object.prototype.hasOwnProperty.call(t,r)}(e,this.config.errorMapping))return new cs.Error(this.config.errorMapping[e.toUpperCase()]);{let t,r=e.trim(),n=0;if(r.endsWith("%"))n=1,r=r.slice(0,r.length-1);else{const e=this.currencyMatcher(r);void 0!==e&&(n=2,[t,r]=e)}const s=this.numberLiteralsHelper.numericStringToMaybeNumber(r);if(void 0!==s){let e;return e=1===n?new Qe(s/100):2===n?new Ke(s,t):s,new cs.Number(e)}const o=this.dateHelper.dateStringToDateNumber(r);return void 0!==o?new cs.Number(o):new cs.String(e.startsWith("'")?e.slice(1):e)}}throw new St(e)}currencyMatcher(e){for(const t of this.config.currencySymbol){if(e.startsWith(t))return[t,e.slice(t.length)];if(e.endsWith(t))return[t,e.slice(0,e.length-t.length)]}}}!function(e){e[e.COPY=0]="COPY",e[e.CUT=1]="CUT"}(ds||(ds={})),function(e){e[e.VALUE=0]="VALUE",e[e.EMPTY=1]="EMPTY",e[e.FORMULA=2]="FORMULA",e[e.PARSING_ERROR=3]="PARSING_ERROR"}(ps||(ps={}));class fs{constructor(e,t,r,n,s){this.sourceLeftCorner=e,this.width=t,this.height=r,this.type=n,this.content=s}*getContent(e){if(void 0!==this.content)for(let t=0;t<this.height;++t)for(let r=0;r<this.width;++r)yield[br(e.sheet,e.col+r,e.row+t),this.content[t][r]]}}class ms{constructor(e,t,r){this.dependencyGraph=t,this.operations=r,this.maxRows=e.maxRows,this.maxColumns=e.maxColumns}cut(e,t,r){this.clipboard=new fs(e,t,r,ds.CUT)}copy(e,t,r){const n=[];for(let s=0;s<r;++s){n[s]=[];for(let r=0;r<t;++r){const t=this.operations.getClipboardCell(br(e.sheet,e.col+r,e.row+s));n[s].push(t)}}this.clipboard=new fs(e,t,r,ds.COPY,n)}abortCut(){this.clipboard&&this.clipboard.type===ds.CUT&&this.clear()}clear(){this.clipboard=void 0}ensureItIsPossibleToCopyPaste(e){if(void 0===this.clipboard)return;if(Ir(e)||!this.dependencyGraph.sheetMapping.hasSheetWithId(e.sheet))throw new gt("a valid target address.");const t=Fr.spanFrom(e,this.clipboard.width,this.clipboard.height);if(t.exceedsSheetSizeLimits(this.maxColumns,this.maxRows))throw new ct;if(this.dependencyGraph.arrayMapping.isFormulaArrayInRange(t))throw new Error("It is not possible to paste onto an array")}isCutClipboard(){return void 0!==this.clipboard&&this.clipboard.type===ds.CUT}isCopyClipboard(){return void 0!==this.clipboard&&this.clipboard.type===ds.COPY}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Es{constructor(e,t,r,n){this.displayName=e,this.address=t,this.added=r,this.options=n}normalizeExpressionName(){return this.displayName.toLowerCase()}copy(){return new Es(this.displayName,this.address,this.added,this.options)}}class ys{constructor(){this.mapping=new Map}has(e){return this.mapping.has(this.normalizeExpressionName(e))}isNameAvailable(e){const t=this.normalizeExpressionName(e),r=this.mapping.get(t);return!(r&&r.added)}add(e){this.mapping.set(e.normalizeExpressionName(),e)}get(e){return this.mapping.get(this.normalizeExpressionName(e))}getExisting(e){const t=this.mapping.get(this.normalizeExpressionName(e));return t&&t.added?t:void 0}remove(e){const t=this.normalizeExpressionName(e),r=this.mapping.get(t);r&&(r.added=!1)}getAllNamedExpressions(){return Array.from(this.mapping.values()).filter((e=>e.added))}normalizeExpressionName(e){return e.toLowerCase()}}class ws{constructor(){this.mapping=new Map}add(e){this.mapping.set(this.normalizeExpressionName(e.displayName),e)}get(e){return this.mapping.get(this.normalizeExpressionName(e))}has(e){return this.mapping.has(this.normalizeExpressionName(e))}getAllNamedExpressions(){return Array.from(this.mapping.values()).filter((e=>e.added))}isNameAvailable(e){const t=this.normalizeExpressionName(e);return!this.mapping.has(t)}remove(e){const t=this.normalizeExpressionName(e);this.mapping.get(t)&&this.mapping.delete(t)}normalizeExpressionName(e){return e.toLowerCase()}}class Cs{constructor(){this.nextNamedExpressionRow=0,this.workbookStore=new ys,this.worksheetStores=new Map,this.addressCache=new Map}isNameAvailable(e,t){var r,n;return void 0===t?this.workbookStore.isNameAvailable(e):null===(n=null===(r=this.worksheetStore(t))||void 0===r?void 0:r.isNameAvailable(e))||void 0===n||n}namedExpressionInAddress(e){const t=this.addressCache.get(e);return t&&t.added?t:void 0}namedExpressionForScope(e,t){var r;return void 0===t?this.workbookStore.getExisting(e):null===(r=this.worksheetStore(t))||void 0===r?void 0:r.get(e)}nearestNamedExpression(e,t){var r,n;return null!==(n=null===(r=this.worksheetStore(t))||void 0===r?void 0:r.get(e))&&void 0!==n?n:this.workbookStore.getExisting(e)}isExpressionInScope(e,t){var r,n;return null!==(n=null===(r=this.worksheetStore(t))||void 0===r?void 0:r.has(e))&&void 0!==n&&n}isNameValid(e){const t=new RegExp(`^${f}$`),r=new RegExp(`^${y}$`),n=new RegExp(`^${C}$`);return!t.test(e)&&!r.test(e)&&n.test(e)}addNamedExpression(e,t,r){const n=void 0===t?this.workbookStore:this.worksheetStoreOrCreate(t);let s=n.get(e);return void 0!==s?(s.added=!0,s.displayName=e,s.options=r):(s=new Es(e,this.nextAddress(),!0,r),n.add(s)),this.addressCache.set(s.address.row,s),s}restoreNamedExpression(e,t){const r=void 0===t?this.workbookStore:this.worksheetStoreOrCreate(t);return e.added=!0,r.add(e),this.addressCache.set(e.address.row,e),e}namedExpressionOrPlaceholder(e,t){var r;return null!==(r=this.worksheetStoreOrCreate(t).get(e))&&void 0!==r?r:this.workbookNamedExpressionOrPlaceholder(e)}workbookNamedExpressionOrPlaceholder(e){let t=this.workbookStore.get(e);return void 0===t&&(t=new Es(e,this.nextAddress(),!1),this.workbookStore.add(t)),t}remove(e,t){let r;r=void 0===t?this.workbookStore:this.worksheetStore(t);const n=null==r?void 0:r.get(e);if(void 0===r||void 0===n||!n.added)throw Error("Named expression does not exist");r.remove(e),r instanceof ws&&0===r.mapping.size&&this.worksheetStores.delete(t),this.addressCache.delete(n.address.row)}getAllNamedExpressionsNamesInScope(e){return this.getAllNamedExpressions().filter((({scope:t})=>t===e)).map((e=>e.expression.displayName))}getAllNamedExpressionsNames(){return this.getAllNamedExpressions().map((e=>e.expression.displayName))}getAllNamedExpressions(){const e=[];return this.workbookStore.getAllNamedExpressions().forEach((t=>{e.push({expression:t,scope:void 0})})),this.worksheetStores.forEach(((t,r)=>{t.getAllNamedExpressions().forEach((t=>{e.push({expression:t,scope:r})}))})),e}getAllNamedExpressionsForScope(e){var t,r;return void 0===e?this.workbookStore.getAllNamedExpressions():null!==(r=null===(t=this.worksheetStores.get(e))||void 0===t?void 0:t.getAllNamedExpressions())&&void 0!==r?r:[]}worksheetStoreOrCreate(e){let t=this.worksheetStores.get(e);return t||(t=new ws,this.worksheetStores.set(e,t)),t}worksheetStore(e){return this.worksheetStores.get(e)}nextAddress(){return br(Cs.SHEET_FOR_WORKBOOK_EXPRESSIONS,0,this.nextNamedExpressionRow++)}}Cs.SHEET_FOR_WORKBOOK_EXPRESSIONS=-1;const Rs=e=>{switch(e.type){case U.EMPTY:case U.NUMBER:case U.STRING:case U.ERROR:case U.ERROR_WITH_RAW_INPUT:return!1;case U.CELL_REFERENCE:return!e.reference.isAbsolute();case U.CELL_RANGE:case U.COLUMN_RANGE:case U.ROW_RANGE:return!e.start.isAbsolute();case U.NAMED_EXPRESSION:return!1;case U.PERCENT_OP:case U.PLUS_UNARY_OP:case U.MINUS_UNARY_OP:return Rs(e.value);case U.CONCATENATE_OP:case U.EQUALS_OP:case U.NOT_EQUAL_OP:case U.LESS_THAN_OP:case U.GREATER_THAN_OP:case U.LESS_THAN_OR_EQUAL_OP:case U.GREATER_THAN_OR_EQUAL_OP:case U.MINUS_OP:case U.PLUS_OP:case U.TIMES_OP:case U.DIV_OP:case U.POWER_OP:return Rs(e.left)||Rs(e.right);case U.PARENTHESIS:return Rs(e.expression);case U.FUNCTION_CALL:return e.args.some((e=>Rs(e)));case U.ARRAY:return e.args.some((e=>e.some((e=>Rs(e)))))}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class vs{performEagerTransformations(e,t){for(const r of e.arrayFormulaNodes()){const[n,s]=this.transformSingleAst(r.getFormula(e.lazilyTransformingAstService),r.getAddress(e.lazilyTransformingAstService)),o=t.rememberNewAst(n);r.setFormula(o),r.setAddress(s)}}transformSingleAst(e,t){return[this.transformAst(e,t),this.fixNodeAddress(t)]}transformAst(e,t){switch(e.type){case U.CELL_REFERENCE:return this.transformCellReferenceAst(e,t);case U.CELL_RANGE:return this.transformCellRangeAst(e,t);case U.COLUMN_RANGE:return this.transformColumnRangeAst(e,t);case U.ROW_RANGE:return this.transformRowRangeAst(e,t);case U.EMPTY:case U.ERROR:case U.NUMBER:case U.NAMED_EXPRESSION:case U.ERROR_WITH_RAW_INPUT:case U.STRING:return e;case U.PERCENT_OP:case U.MINUS_UNARY_OP:case U.PLUS_UNARY_OP:return Object.assign(Object.assign({},e),{value:this.transformAst(e.value,t)});case U.FUNCTION_CALL:return Object.assign(Object.assign({},e),{procedureName:e.procedureName,args:e.args.map((e=>this.transformAst(e,t)))});case U.PARENTHESIS:return Object.assign(Object.assign({},e),{expression:this.transformAst(e.expression,t)});case U.ARRAY:return Object.assign(Object.assign({},e),{args:e.args.map((e=>e.map((e=>this.transformAst(e,t)))))});default:return Object.assign(Object.assign({},e),{left:this.transformAst(e.left,t),right:this.transformAst(e.right,t)})}}transformCellReferenceAst(e,t){const r=this.transformCellAddress(e.reference,t);return r instanceof l?Object.assign(Object.assign({},e),{reference:r}):r===or.REF?j(new Tr(or.REF)):e}transformCellRangeAst(e,t){const r=this.transformCellRange(e.start,e.end,t);return Array.isArray(r)?Object.assign(Object.assign({},e),{start:r[0],end:r[1]}):r===or.REF?j(new Tr(or.REF)):e}transformColumnRangeAst(e,t){const r=this.transformColumnRange(e.start,e.end,t);return Array.isArray(r)?Object.assign(Object.assign({},e),{start:r[0],end:r[1]}):r===or.REF?j(new Tr(or.REF)):e}transformRowRangeAst(e,t){const r=this.transformRowRange(e.start,e.end,t);return Array.isArray(r)?Object.assign(Object.assign({},e),{start:r[0],end:r[1]}):r===or.REF?j(new Tr(or.REF)):e}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ss extends vs{constructor(e){super(),this.columnsSpan=e}get sheet(){return this.columnsSpan.sheet}isIrreversible(){return!1}transformRowRangeAst(e,t){return e}transformCellRange(e,t,r){return this.transformRange(e,t,r)}transformRowRange(e,t,r){throw Error("Not implemented")}transformColumnRange(e,t,r){return this.transformRange(e,t,r)}transformCellAddress(e,t){const r=Lr(e,t);if(r!==this.columnsSpan.sheet&&t.sheet!==this.columnsSpan.sheet)return!1;const n=e.toSimpleColumnAddress(t);if(r===this.columnsSpan.sheet&&t.sheet!==this.columnsSpan.sheet)return this.columnsSpan.columnStart<=n.col&&e.shiftedByColumns(this.columnsSpan.numberOfColumns);if(t.sheet===this.columnsSpan.sheet&&r!==this.columnsSpan.sheet)return!e.isColumnAbsolute()&&(!(t.col<this.columnsSpan.columnStart)&&e.shiftedByColumns(-this.columnsSpan.numberOfColumns));if(e.isColumnAbsolute())return!(e.col<this.columnsSpan.columnStart)&&e.shiftedByColumns(this.columnsSpan.numberOfColumns);return e.toSimpleColumnAddress(t).col<this.columnsSpan.columnStart?!(t.col<this.columnsSpan.columnStart)&&e.shiftedByColumns(-this.columnsSpan.numberOfColumns):t.col<this.columnsSpan.columnStart&&e.shiftedByColumns(this.columnsSpan.numberOfColumns)}fixNodeAddress(e){return this.columnsSpan.sheet===e.sheet&&this.columnsSpan.columnStart<=e.col?Object.assign(Object.assign({},e),{col:e.col+this.columnsSpan.numberOfColumns}):e}transformRange(e,t,r){const n=this.transformCellAddress(e,r),s=this.transformCellAddress(t,r);return n===or.REF||s===or.REF?or.REF:!(!n&&!s)&&[n||e,s||t]}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ts extends vs{constructor(e){super(),this.rowsSpan=e}get sheet(){return this.rowsSpan.sheet}isIrreversible(){return!1}transformColumnRangeAst(e,t){return e}transformCellRange(e,t,r){return this.transformRange(e,t,r)}transformRowRange(e,t,r){return this.transformRange(e,t,r)}transformColumnRange(e,t,r){throw Error("Not implemented")}transformCellAddress(e,t){const r=Lr(e,t);if(r!==this.rowsSpan.sheet&&t.sheet!==this.rowsSpan.sheet)return!1;const n=e.toSimpleRowAddress(t);return r===this.rowsSpan.sheet&&t.sheet!==this.rowsSpan.sheet?this.rowsSpan.rowStart<=n.row&&e.shiftedByRows(this.rowsSpan.numberOfRows):t.sheet===this.rowsSpan.sheet&&r!==this.rowsSpan.sheet?!e.isRowAbsolute()&&(!(t.row<this.rowsSpan.rowStart)&&e.shiftedByRows(-this.rowsSpan.numberOfRows)):e.isRowAbsolute()?!(e.row<this.rowsSpan.rowStart)&&e.shiftedByRows(this.rowsSpan.numberOfRows):n.row<this.rowsSpan.rowStart?!(t.row<this.rowsSpan.rowStart)&&e.shiftedByRows(-this.rowsSpan.numberOfRows):t.row<this.rowsSpan.rowStart&&e.shiftedByRows(this.rowsSpan.numberOfRows)}fixNodeAddress(e){return this.rowsSpan.sheet===e.sheet&&this.rowsSpan.rowStart<=e.row?Object.assign(Object.assign({},e),{row:e.row+this.rowsSpan.numberOfRows}):e}transformRange(e,t,r){const n=this.transformCellAddress(e,r),s=this.transformCellAddress(t,r);return n===or.REF||s===or.REF?or.REF:!(!n&&!s)&&[n||e,s||t]}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ns extends vs{constructor(e){super(),this.sheet=e}isIrreversible(){return!0}fixNodeAddress(e){return e}transformCellAddress(e,t){return!!e.isInvalid(t)&&or.REF}transformCellRange(e,t,r){return!(!e.isInvalid(r)&&!t.isInvalid(r))&&or.REF}transformColumnRange(e,t,r){return!(!e.isInvalid(r)&&!t.isInvalid(r))&&or.REF}transformRowRange(e,t,r){return!(!e.isInvalid(r)&&!t.isInvalid(r))&&or.REF}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class _s extends vs{constructor(e,t,r,n){super(),this.sourceRange=e,this.toRight=t,this.toBottom=r,this.toSheet=n,this.dependentFormulaTransformer=new Ms(e,t,r,n)}get sheet(){return this.sourceRange.sheet}isIrreversible(){return!0}transformSingleAst(e,t){if(this.sourceRange.addressInRange(t)){return[this.transformAst(e,t),this.fixNodeAddress(t)]}return this.dependentFormulaTransformer.transformSingleAst(e,t)}fixNodeAddress(e){return br(this.toSheet,e.col+this.toRight,e.row+this.toBottom)}transformCellAddress(e,t){return this.transformAddress(e,t)}transformCellRange(e,t,r){return this.transformRange(e,t,r)}transformColumnRange(e,t,r){return this.transformRange(e,t,r)}transformRowRange(e,t,r){return this.transformRange(e,t,r)}transformAddress(e,t){const r=this.sourceRange;if(e instanceof l){const n=e.toSimpleCellAddress(t);if(r.addressInRange(n))return e.shiftAbsoluteDimensions(this.toRight,this.toBottom)}return e.shiftRelativeDimensions(-this.toRight,-this.toBottom)}transformRange(e,t,r){const n=this.sourceRange;if(e instanceof l&&t instanceof l){const s=e.toSimpleCellAddress(r),o=t.toSimpleCellAddress(r);if(n.addressInRange(s)&&n.addressInRange(o))return[e.shiftAbsoluteDimensions(this.toRight,this.toBottom),t.shiftAbsoluteDimensions(this.toRight,this.toBottom)]}return[e.shiftRelativeDimensions(-this.toRight,-this.toBottom),t.shiftRelativeDimensions(-this.toRight,-this.toBottom)]}}class Ms extends vs{constructor(e,t,r,n){super(),this.sourceRange=e,this.toRight=t,this.toBottom=r,this.toSheet=n}get sheet(){return this.sourceRange.sheet}isIrreversible(){return!0}fixNodeAddress(e){return e}transformCellAddress(e,t){return!!this.shouldMove(e,t)&&e.moved(this.toSheet,this.toRight,this.toBottom)}transformCellRange(e,t,r){return this.transformRange(e,t,r)}transformColumnRange(e,t,r){return this.transformRange(e,t,r)}transformRowRange(e,t,r){return this.transformRange(e,t,r)}shouldMove(e,t){return e instanceof l?this.sourceRange.addressInRange(e.toSimpleCellAddress(t)):e instanceof a?this.sourceRange.rowInRange(e.toSimpleRowAddress(t))&&!this.sourceRange.isFinite():this.sourceRange.columnInRange(e.toSimpleColumnAddress(t))&&!this.sourceRange.isFinite()}transformRange(e,t,r){const n=this.transformCellAddress(e,r),s=this.transformCellAddress(t,r);return!(!n||!s)&&[n,s]}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class As extends vs{constructor(e){super(),this.columnsSpan=e}get sheet(){return this.columnsSpan.sheet}isIrreversible(){return!0}transformRowRangeAst(e,t){return e}transformCellRange(e,t,r){return this.transformRange(e,t,r)}transformRowRange(e,t,r){throw Error("Not implemented")}transformColumnRange(e,t,r){return this.transformRange(e,t,r)}transformCellAddress(e,t){const r=Lr(e,t);if(this.columnsSpan.sheet!==t.sheet&&this.columnsSpan.sheet!==r)return!1;if(this.columnsSpan.sheet!==t.sheet&&this.columnsSpan.sheet===r){const r=e.toSimpleColumnAddress(t);if(r.col<this.columnsSpan.columnStart)return!1;if(r.col>this.columnsSpan.columnEnd)return e.shiftedByColumns(-this.columnsSpan.numberOfColumns)}if(this.columnsSpan.sheet===t.sheet&&this.columnsSpan.sheet!==r){if(e.isColumnAbsolute())return!1;if(t.col<this.columnsSpan.columnStart)return!1;if(t.col>this.columnsSpan.columnEnd)return e.shiftedByColumns(this.columnsSpan.numberOfColumns)}if(this.columnsSpan.sheet===t.sheet&&this.columnsSpan.sheet===r)if(e.isColumnAbsolute()){if(e.col<this.columnsSpan.columnStart)return!1;if(e.col>this.columnsSpan.columnEnd)return e.shiftedByColumns(-this.columnsSpan.numberOfColumns)}else{const r=e.toSimpleColumnAddress(t);if(r.col<this.columnsSpan.columnStart){if(t.col<this.columnsSpan.columnStart)return!1;if(t.col>this.columnsSpan.columnEnd)return e.shiftedByColumns(this.columnsSpan.numberOfColumns)}else if(r.col>this.columnsSpan.columnEnd){if(t.col<this.columnsSpan.columnStart)return e.shiftedByColumns(-this.columnsSpan.numberOfColumns);if(t.col>this.columnsSpan.columnEnd)return!1}}return or.REF}fixNodeAddress(e){return this.columnsSpan.sheet===e.sheet&&this.columnsSpan.columnStart<=e.col?Object.assign(Object.assign({},e),{col:e.col-this.columnsSpan.numberOfColumns}):e}transformRange(e,t,r){const n=Lr(e,r);let s=e,o=t;if(this.columnsSpan.sheet===n){const n=e.toSimpleColumnAddress(r),i=t.toSimpleColumnAddress(r);if(this.columnsSpan.columnStart<=n.col&&this.columnsSpan.columnEnd>=i.col)return or.REF;n.col>=this.columnsSpan.columnStart&&n.col<=this.columnsSpan.columnEnd&&(s=e.shiftedByColumns(this.columnsSpan.columnEnd-n.col+1)),i.col>=this.columnsSpan.columnStart&&i.col<=this.columnsSpan.columnEnd&&(o=t.shiftedByColumns(-(i.col-this.columnsSpan.columnStart+1)))}const i=this.transformCellAddress(s,r),a=this.transformCellAddress(o,r);if(!1===i&&!1===a)return[s,o];if(i===or.REF||a===or.REF)throw Error("Cannot happen");return[i||s,a||o]}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class bs extends vs{constructor(e){super(),this.rowsSpan=e}get sheet(){return this.rowsSpan.sheet}isIrreversible(){return!0}transformColumnRangeAst(e,t){return e}transformCellAddress(e,t){const r=Lr(e,t);if(this.rowsSpan.sheet!==t.sheet&&this.rowsSpan.sheet!==r)return!1;if(this.rowsSpan.sheet!==t.sheet&&this.rowsSpan.sheet===r){const r=e.toSimpleRowAddress(t);if(r.row<this.rowsSpan.rowStart)return!1;if(r.row>this.rowsSpan.rowEnd)return e.shiftedByRows(-this.rowsSpan.numberOfRows)}if(this.rowsSpan.sheet===t.sheet&&this.rowsSpan.sheet!==r){if(e.isRowAbsolute())return!1;if(t.row<this.rowsSpan.rowStart)return!1;if(t.row>this.rowsSpan.rowEnd)return e.shiftedByRows(this.rowsSpan.numberOfRows)}if(this.rowsSpan.sheet===t.sheet&&this.rowsSpan.sheet===r)if(e.isRowAbsolute()){if(e.row<this.rowsSpan.rowStart)return!1;if(e.row>this.rowsSpan.rowEnd)return e.shiftedByRows(-this.rowsSpan.numberOfRows)}else{const r=e.toSimpleRowAddress(t);if(r.row<this.rowsSpan.rowStart){if(t.row<this.rowsSpan.rowStart)return!1;if(t.row>this.rowsSpan.rowEnd)return e.shiftedByRows(this.rowsSpan.numberOfRows)}else if(r.row>this.rowsSpan.rowEnd){if(t.row<this.rowsSpan.rowStart)return e.shiftedByRows(-this.rowsSpan.numberOfRows);if(t.row>this.rowsSpan.rowEnd)return!1}}return or.REF}transformCellRange(e,t,r){return this.transformRange(e,t,r)}transformRowRange(e,t,r){return this.transformRange(e,t,r)}transformColumnRange(e,t,r){throw Error("Not implemented")}fixNodeAddress(e){return this.rowsSpan.sheet===e.sheet&&this.rowsSpan.rowStart<=e.row?Object.assign(Object.assign({},e),{row:e.row-this.rowsSpan.numberOfRows}):e}transformRange(e,t,r){const n=Lr(e,r);let s=e,o=t;if(this.rowsSpan.sheet===n){const n=e.toSimpleRowAddress(r),i=t.toSimpleRowAddress(r);if(this.rowsSpan.rowStart<=n.row&&this.rowsSpan.rowEnd>=i.row)return or.REF;n.row>=this.rowsSpan.rowStart&&n.row<=this.rowsSpan.rowEnd&&(s=e.shiftedByRows(this.rowsSpan.rowEnd-n.row+1)),i.row>=this.rowsSpan.rowStart&&i.row<=this.rowsSpan.rowEnd&&(o=t.shiftedByRows(-(i.row-this.rowsSpan.rowStart+1)))}const i=this.transformCellAddress(s,r),a=this.transformCellAddress(o,r);return!1===i&&!1===a?[s,o]:i===or.REF||a===or.REF?or.REF:[i||s,a||o]}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Is extends vs{constructor(e){super(),this.sheet=e}isIrreversible(){return!0}performEagerTransformations(e,t){for(const t of e.arrayFormulaNodes()){const[r]=this.transformSingleAst(t.getFormula(e.lazilyTransformingAstService),t.getAddress(e.lazilyTransformingAstService));t.setFormula(r)}}fixNodeAddress(e){return e}transformCellAddress(e,t){return this.transformAddress(e)}transformCellRange(e,t,r){return this.transformAddress(e)}transformColumnRange(e,t,r){return this.transformAddress(e)}transformRowRange(e,t,r){return this.transformAddress(e)}transformAddress(e){return e.sheet===this.sheet&&or.REF}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function Os(e){if(!Array.isArray(e))throw new gt("an array of arrays.");for(let t=0;t<e.length;t++)if(!Array.isArray(e[t]))throw new gt("an array of arrays.")}function xs(e){let t=0,r=0,n=0;for(let s=0;s<e.length;s++){let o=0;for(let t=0;t<e[s].length;t++){const r=e[s][t];null!=r&&(o=t+1,++n)}t=Math.max(t,o),o>0&&(r=s+1)}const s=t*r;return{height:r,width:t,fill:0===s?0:n/s}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ps{constructor(e,t){this.sheet=e,this.indexes=t}normalizedIndexes(){return Fs(this.indexes)}rowsSpans(){return this.normalizedIndexes().map((e=>st.fromNumberOfRows(this.sheet,e[0],e[1])))}}class Ls{constructor(e,t){this.sheet=e,this.indexes=t}normalizedIndexes(){return Us(this.indexes)}rowsSpans(){return this.normalizedIndexes().map((e=>st.fromNumberOfRows(this.sheet,e[0],e[1])))}}class Ds{constructor(e,t){this.sheet=e,this.indexes=t}normalizedIndexes(){return Us(this.indexes)}columnsSpans(){return this.normalizedIndexes().map((e=>ot.fromNumberOfColumns(this.sheet,e[0],e[1])))}}class ks{constructor(e,t){this.sheet=e,this.indexes=t}normalizedIndexes(){return Fs(this.indexes)}columnsSpans(){return this.normalizedIndexes().map((e=>ot.fromNumberOfColumns(this.sheet,e[0],e[1])))}}class Hs{constructor(e,t,r,n,s,o,i,a,l){this.dependencyGraph=t,this.columnSearch=r,this.cellContentParser=n,this.parser=s,this.stats=o,this.lazilyTransformingAstService=i,this.namedExpressions=a,this.arraySizePredictor=l,this.changes=nt.empty(),this.allocateNamedExpressionAddressSpace(),this.maxColumns=e.maxColumns,this.maxRows=e.maxRows}get sheetMapping(){return this.dependencyGraph.sheetMapping}get addressMapping(){return this.dependencyGraph.addressMapping}removeRows(e){const t=[];for(const r of e.rowsSpans()){const e=this.doRemoveRows(r);e&&t.push(e)}return t}addRows(e){for(const t of e.rowsSpans())this.doAddRows(t)}addColumns(e){for(const t of e.columnsSpans())this.doAddColumns(t)}removeColumns(e){const t=[];for(const r of e.columnsSpans()){const e=this.doRemoveColumns(r);e&&t.push(e)}return t}removeSheet(e){this.dependencyGraph.removeSheet(e);let t=0;this.stats.measure(et.TRANSFORM_ASTS,(()=>{const r=new Is(e);r.performEagerTransformations(this.dependencyGraph,this.parser),t=this.lazilyTransformingAstService.addTransformation(r)})),this.sheetMapping.removeSheet(e),this.columnSearch.removeSheet(e);const r=this.namedExpressions.getAllNamedExpressionsForScope(e).map((t=>this.removeNamedExpression(t.normalizeExpressionName(),e)));return{version:t,scopedNamedExpressions:r}}removeSheetByName(e){const t=this.sheetMapping.fetch(e);return this.removeSheet(t)}clearSheet(e){this.dependencyGraph.clearSheet(e),this.columnSearch.removeSheet(e)}addSheet(e){const t=this.sheetMapping.addSheet(e);return this.dependencyGraph.addressMapping.autoAddSheet(t,xs([])),this.sheetMapping.fetchDisplayName(t)}renameSheet(e,t){return this.sheetMapping.renameSheet(e,t)}moveRows(e,t,r,n){const s=st.fromNumberOfRows(e,n,r);this.lazilyTransformingAstService.beginCombinedMode(e),this.doAddRows(s),n<t&&(t+=r);const o=br(e,0,t),i=br(e,0,n);this.moveCells(o,Number.POSITIVE_INFINITY,r,i);const a=st.fromNumberOfRows(e,t,r);return this.doRemoveRows(a),this.lazilyTransformingAstService.commitCombinedMode()}moveColumns(e,t,r,n){const s=ot.fromNumberOfColumns(e,n,r);this.lazilyTransformingAstService.beginCombinedMode(e),this.doAddColumns(s),n<t&&(t+=r);const o=br(e,t,0),i=br(e,n,0);this.moveCells(o,r,Number.POSITIVE_INFINITY,i);const a=ot.fromNumberOfColumns(e,t,r);return this.doRemoveColumns(a),this.lazilyTransformingAstService.commitCombinedMode()}moveCells(e,t,r,n){this.ensureItIsPossibleToMoveCells(e,t,r,n);const s=Fr.spanFrom(e,t,r),o=Fr.spanFrom(n,t,r),i=n.col-e.col,a=n.row-e.row,l=n.sheet,h=this.getRangeClipboardCells(o),u=this.dependencyGraph.rawValuesFromRange(o);this.columnSearch.removeValues(u);const c=this.dependencyGraph.rawValuesFromRange(s);this.columnSearch.moveValues(c,i,a,l);let d=0;this.stats.measure(et.TRANSFORM_ASTS,(()=>{const e=new _s(s,i,a,l);e.performEagerTransformations(this.dependencyGraph,this.parser),d=this.lazilyTransformingAstService.addTransformation(e)})),this.dependencyGraph.moveCells(s,i,a,l);const p=this.updateNamedExpressionsForMovedCells(e,t,r,n);return{version:d,overwrittenCellsData:h,addedGlobalNamedExpressions:p}}setRowOrder(e,t){const r=[];let n=[];for(const[s,o]of t)if(s!==o){const t=Fr.spanFrom({sheet:e,col:0,row:s},1/0,1),i=this.getRangeClipboardCells(t);n=n.concat(i),r.push(i.map((([{sheet:e,col:t},r])=>[{sheet:e,col:t,row:o},r])))}return r.forEach((t=>this.restoreClipboardCells(e,t.values()))),n}setColumnOrder(e,t){const r=[];let n=[];for(const[s,o]of t)if(s!==o){const t=Fr.spanFrom({sheet:e,col:s,row:0},1,1/0),i=this.getRangeClipboardCells(t);n=n.concat(i),r.push(i.map((([{sheet:e,col:t,row:r},n])=>[{sheet:e,col:o,row:r},n])))}return r.forEach((t=>this.restoreClipboardCells(e,t.values()))),n}addNamedExpression(e,t,r,n){const s=this.namedExpressions.addNamedExpression(e,r,n);this.storeNamedExpressionInCell(s.address,t),this.adjustNamedExpressionEdges(s,e,r)}restoreNamedExpression(e,t,r){const n=e.displayName;this.restoreCell(e.address,t);const s=this.namedExpressions.restoreNamedExpression(e,r);this.adjustNamedExpressionEdges(s,n,r)}changeNamedExpressionExpression(e,t,r,n){const s=this.namedExpressions.namedExpressionForScope(e,r);if(!s)throw new yt(e);const o=s.copy();s.options=n;const i=this.getClipboardCell(s.address);return this.storeNamedExpressionInCell(s.address,t),[o,i]}removeNamedExpression(e,t){const r=this.namedExpressions.namedExpressionForScope(e,t);if(!r)throw new yt(e);this.namedExpressions.remove(r.displayName,t);const n=this.getClipboardCell(r.address);if(void 0!==t){const t=this.namedExpressions.workbookNamedExpressionOrPlaceholder(e);this.dependencyGraph.exchangeNode(r.address,t.address)}else this.dependencyGraph.setCellEmpty(r.address);return[r,n]}ensureItIsPossibleToMoveCells(e,t,r,n){if(Ir(e)||!(Vs(t)&&Vs(r)||function(e,t,r){return 0===e.row&&Vs(t)&&r===Number.POSITIVE_INFINITY||0===e.col&&Vs(r)&&t===Number.POSITIVE_INFINITY}(e,t,r))||Ir(n)||!this.sheetMapping.hasSheetWithId(e.sheet)||!this.sheetMapping.hasSheetWithId(n.sheet))throw new gt("a valid range of cells to move.");const s=Fr.spanFrom(e,t,r),o=Fr.spanFrom(n,t,r);if(o.exceedsSheetSizeLimits(this.maxColumns,this.maxRows))throw new ct;if(this.dependencyGraph.arrayMapping.isFormulaArrayInRange(s))throw new kt;if(this.dependencyGraph.arrayMapping.isFormulaArrayInRange(o))throw new Ht}restoreClipboardCells(e,t){const r=[];for(const[n,s]of t)if(this.restoreCell(n,s),s.type===ps.FORMULA){const{dependencies:t}=this.parser.fetchCachedResult(s.hash);r.push(...this.updateNamedExpressionsForTargetAddress(e,n,t))}return r}restoreCell(e,t){switch(t.type){case ps.VALUE:this.setValueToCell(t,e);break;case ps.FORMULA:this.setFormulaToCellFromCache(t.hash,e);break;case ps.EMPTY:this.setCellEmpty(e);break;case ps.PARSING_ERROR:this.setParsingErrorToCell(t.rawInput,t.errors,e)}}getOldContent(e){const t=this.dependencyGraph.getCell(e);if(void 0===t||t instanceof cr)return[e,{type:ps.EMPTY}];if(t instanceof dr)return[e,Object.assign({type:ps.VALUE},t.getValues())];if(t instanceof Gt)return[t.getAddress(this.lazilyTransformingAstService),{type:ps.FORMULA,hash:this.parser.computeHashFromAst(t.getFormula(this.lazilyTransformingAstService))}];if(t instanceof pr)return[e,{type:ps.PARSING_ERROR,rawInput:t.rawInput,errors:t.errors}];throw Error("Trying to copy unsupported type")}getClipboardCell(e){const t=this.dependencyGraph.getCell(e);if(void 0===t||t instanceof cr)return{type:ps.EMPTY};if(t instanceof dr)return Object.assign({type:ps.VALUE},t.getValues());if(t instanceof zt){const r=t.getArrayCellValue(e);return r===Ye?{type:ps.EMPTY}:{type:ps.VALUE,parsedValue:r,rawValue:t.getArrayCellRawValue(e)}}if(t instanceof $t)return{type:ps.FORMULA,hash:this.parser.computeHashFromAst(t.getFormula(this.lazilyTransformingAstService))};if(t instanceof pr)return{type:ps.PARSING_ERROR,rawInput:t.rawInput,errors:t.errors};throw Error("Trying to copy unsupported type")}getSheetClipboardCells(e){const t=this.dependencyGraph.getSheetHeight(e),r=this.dependencyGraph.getSheetWidth(e),n=new Array(t);for(let s=0;s<t;s++){n[s]=new Array(r);for(let t=0;t<r;t++){const r=br(e,t,s);n[s][t]=this.getClipboardCell(r)}}return n}getRangeClipboardCells(e){const t=[];for(const r of e.addresses(this.dependencyGraph))t.push([r,this.getClipboardCell(r)]);return t}setCellContent(e,t){const r=this.cellContentParser.parse(t),n=this.getOldContent(e);if(r instanceof cs.Formula){const t=this.parser.parse(r.formula,e),{ast:n,errors:s}=t;if(s.length>0)this.setParsingErrorToCell(r.formula,s,e);else try{const r=this.arraySizePredictor.checkArraySize(n,e);if(r.width<=0||r.height<=0)throw Error("Incorrect array size");this.setFormulaToCell(e,r,t)}catch(t){if(!t.message)throw t;const n={type:F.InvalidRangeSize,message:"Invalid range size."};this.setParsingErrorToCell(r.formula,[n],e)}}else r instanceof cs.Empty?this.setCellEmpty(e):this.setValueToCell({parsedValue:r.value,rawValue:t},e);return n}setSheetContent(e,t){this.clearSheet(e);for(let r=0;r<t.length;r++)for(let n=0;n<t[r].length;n++){const s=br(e,n,r);this.setCellContent(s,t[r][n])}}setParsingErrorToCell(e,t,r){const n=this.dependencyGraph.getCellValue(r),s=new pr(t,e),o=this.dependencyGraph.setParsingErrorToCell(r,s);this.columnSearch.remove(je(n),r),this.columnSearch.applyChanges(o.getChanges()),this.changes.addAll(o),this.changes.addChange(s.getCellValue(),r)}setFormulaToCell(e,t,{ast:r,hasVolatileFunction:n,hasStructuralChangeFunction:s,dependencies:o}){const i=this.dependencyGraph.getCellValue(e),a=this.dependencyGraph.setFormulaToCell(e,r,We(o,e),t,n,s);this.columnSearch.remove(je(i),e),this.columnSearch.applyChanges(a.getChanges()),this.changes.addAll(a)}setValueToCell(e,t){const r=this.dependencyGraph.getCellValue(t),n=this.dependencyGraph.setValueToCell(t,e);this.columnSearch.change(je(r),je(e.parsedValue),t),this.columnSearch.applyChanges(n.getChanges().filter((e=>!Dr(e.address,t)))),this.changes.addAll(n),this.changes.addChange(e.parsedValue,t)}setCellEmpty(e){if(this.dependencyGraph.isArrayInternalCell(e))return;const t=this.dependencyGraph.getCellValue(e),r=this.dependencyGraph.setCellEmpty(e);this.columnSearch.remove(je(t),e),this.columnSearch.applyChanges(r.getChanges()),this.changes.addAll(r),this.changes.addChange(Ye,e)}setFormulaToCellFromCache(e,t){const{ast:r,hasVolatileFunction:n,hasStructuralChangeFunction:s,dependencies:o}=this.parser.fetchCachedResult(e),i=We(o,t),[a]=new Ns(t.sheet).transformSingleAst(r,t);this.parser.rememberNewAst(a);const l=i.filter((e=>e instanceof Be||(e instanceof Fr?!(Ir(e.start)||Ir(e.end)):!Ir(e))));const h=this.arraySizePredictor.checkArraySize(r,t);this.dependencyGraph.setFormulaToCell(t,a,l,h,n,s)}rowEffectivelyNotInSheet(e,t){return e>=this.dependencyGraph.addressMapping.getHeight(t)}getAndClearContentChanges(){const e=this.changes;return this.changes=nt.empty(),e}forceApplyPostponedTransformations(){this.dependencyGraph.forceApplyPostponedTransformations()}doRemoveRows(e){if(this.rowEffectivelyNotInSheet(e.rowStart,e.sheet))return;const t=[];for(const[r]of this.dependencyGraph.entriesFromRowsSpan(e))t.push({address:r,cellType:this.getClipboardCell(r)});const{affectedArrays:r,contentChanges:n}=this.dependencyGraph.removeRows(e);this.columnSearch.applyChanges(n.getChanges());let s=0;return this.stats.measure(et.TRANSFORM_ASTS,(()=>{const t=new bs(e);t.performEagerTransformations(this.dependencyGraph,this.parser),s=this.lazilyTransformingAstService.addTransformation(t)})),this.rewriteAffectedArrays(r),{version:s,removedCells:t,rowFrom:e.rowStart,rowCount:e.numberOfRows}}doRemoveColumns(e){if(this.columnEffectivelyNotInSheet(e.columnStart,e.sheet))return;const t=[];for(const[r]of this.dependencyGraph.entriesFromColumnsSpan(e))t.push({address:r,cellType:this.getClipboardCell(r)});const{affectedArrays:r,contentChanges:n}=this.dependencyGraph.removeColumns(e);this.columnSearch.applyChanges(n.getChanges()),this.columnSearch.removeColumns(e);let s=0;return this.stats.measure(et.TRANSFORM_ASTS,(()=>{const t=new As(e);t.performEagerTransformations(this.dependencyGraph,this.parser),s=this.lazilyTransformingAstService.addTransformation(t)})),this.rewriteAffectedArrays(r),{version:s,removedCells:t,columnFrom:e.columnStart,columnCount:e.numberOfColumns}}doAddRows(e){if(this.rowEffectivelyNotInSheet(e.rowStart,e.sheet))return;const{affectedArrays:t}=this.dependencyGraph.addRows(e);this.stats.measure(et.TRANSFORM_ASTS,(()=>{const t=new Ts(e);t.performEagerTransformations(this.dependencyGraph,this.parser),this.lazilyTransformingAstService.addTransformation(t)})),this.rewriteAffectedArrays(t)}rewriteAffectedArrays(e){for(const t of e.values()){if(t.array.size.isRef)continue;const e=t.getFormula(this.lazilyTransformingAstService),r=t.getAddress(this.lazilyTransformingAstService),n=this.parser.computeHashFromAst(e);this.setFormulaToCellFromCache(n,r)}}doAddColumns(e){if(this.columnEffectivelyNotInSheet(e.columnStart,e.sheet))return;const{affectedArrays:t,contentChanges:r}=this.dependencyGraph.addColumns(e);this.columnSearch.addColumns(e),this.columnSearch.applyChanges(r.getChanges()),this.stats.measure(et.TRANSFORM_ASTS,(()=>{const t=new Ss(e);t.performEagerTransformations(this.dependencyGraph,this.parser),this.lazilyTransformingAstService.addTransformation(t)})),this.rewriteAffectedArrays(t)}columnEffectivelyNotInSheet(e,t){return e>=this.dependencyGraph.addressMapping.getWidth(t)}adjustNamedExpressionEdges(e,t,r){if(void 0===r)return;const{vertex:n,id:s}=this.dependencyGraph.fetchCellOrCreateEmpty(e.address),o=null!=s?s:this.dependencyGraph.graph.getNodeId(n),i=this.namedExpressions.workbookNamedExpressionOrPlaceholder(t),{vertex:a,id:l}=this.dependencyGraph.fetchCellOrCreateEmpty(i.address),h=null!=l?l:this.dependencyGraph.graph.getNodeId(a);for(const t of this.dependencyGraph.graph.adjacentNodes(a))if(t instanceof $t&&t.getAddress(this.lazilyTransformingAstService).sheet===r){const r=t.getFormula(this.lazilyTransformingAstService),n=t.getAddress(this.lazilyTransformingAstService),{dependencies:s}=this.parser.fetchCachedResultForAst(r);for(const r of We(s,n))r instanceof Be&&r.name.toLowerCase()===e.displayName.toLowerCase()&&(this.dependencyGraph.graph.removeEdge(h,t),this.dependencyGraph.graph.addEdge(o,t))}}storeNamedExpressionInCell(e,t){const r=this.cellContentParser.parse(t);if(r instanceof cs.Formula){const t=this.parser.parse(r.formula,br(-1,0,0));if(Rs(t.ast))throw new Ft;const{ast:n,hasVolatileFunction:s,hasStructuralChangeFunction:o,dependencies:i}=t;this.dependencyGraph.setFormulaToCell(e,n,We(i,e),cn.scalar(),s,o)}else r instanceof cs.Empty?this.setCellEmpty(e):this.setValueToCell({parsedValue:r.value,rawValue:t},e)}updateNamedExpressionsForMovedCells(e,t,r,n){if(e.sheet===n.sheet)return[];const s=[],o=Fr.spanFrom(n,t,r);for(const t of o.addresses(this.dependencyGraph)){const r=this.addressMapping.fetchCell(t);if(r instanceof $t&&t.sheet!==e.sheet){const n=r.getFormula(this.lazilyTransformingAstService),{dependencies:o}=this.parser.fetchCachedResultForAst(n);s.push(...this.updateNamedExpressionsForTargetAddress(e.sheet,t,o))}}return s}updateNamedExpressionsForTargetAddress(e,t,r){if(e===t.sheet)return[];const n=[],s=this.addressMapping.fetchCell(t);for(const o of We(r,t)){if(!(o instanceof Be))continue;const r=o.name,i=this.dependencyGraph.fetchNamedExpressionVertex(r,e).vertex,a=this.namedExpressions.isExpressionInScope(r,t.sheet)?this.dependencyGraph.fetchNamedExpressionVertex(r,t.sheet).vertex:this.copyOrFetchGlobalNamedExpressionVertex(r,i,n);a!==i&&(this.dependencyGraph.graph.removeEdgeIfExists(i,s),this.dependencyGraph.graph.addEdge(a,s))}return n}allocateNamedExpressionAddressSpace(){this.dependencyGraph.addressMapping.addSheet(Cs.SHEET_FOR_WORKBOOK_EXPRESSIONS,new gr(0,0))}copyOrFetchGlobalNamedExpressionVertex(e,t,r){let n=this.namedExpressions.namedExpressionForScope(e);if(void 0===n)if(n=this.namedExpressions.addNamedExpression(e),r.push(n.normalizeExpressionName()),t instanceof $t){const e=this.parser.fetchCachedResultForAst(t.getFormula(this.lazilyTransformingAstService)),{ast:r,hasVolatileFunction:s,hasStructuralChangeFunction:o,dependencies:i}=e;this.dependencyGraph.setFormulaToCell(n.address,r,We(i,n.address),cn.scalar(),s,o)}else t instanceof cr?this.setCellEmpty(n.address):t instanceof dr&&this.setValueToCell(t.getValues(),n.address);return this.dependencyGraph.fetchCellOrCreateEmpty(n.address).vertex}}function Fs(e){if(e.length<=1)return e;const t=[...e].sort((([e],[t])=>e-t)),r=t.reduce(((e,[t,r])=>{const n=e[e.length-1],s=n[0]+n[1];return t<=s?n[1]+=Math.max(0,r-(s-t)):e.push([t,r]),e}),[t[0]]);let n=0;for(let e=0;e<r.length;++e)r[e][0]-=n,n+=r[e][1];return r}function Us(e){if(e.length<=1)return e;const t=[...e].sort((([e],[t])=>e-t)),r=t.reduce(((e,[t,r])=>{const n=e[e.length-1];return t===n[0]?n[1]=Math.max(n[1],r):e.push([t,r]),e}),[t[0]]);let n=0;for(let e=0;e<r.length;++e)r[e][0]+=n,n+=r[e][1];return r}function Vs(e){return Number.isInteger(e)&&e>0}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Bs{}class Ws extends Bs{constructor(e,t){super(),this.command=e,this.rowsRemovals=t}doUndo(e){e.undoRemoveRows(this)}doRedo(e){e.redoRemoveRows(this)}}class Ys extends Bs{constructor(e,t,r,n,s,o,i){super(),this.sourceLeftCorner=e,this.width=t,this.height=r,this.destinationLeftCorner=n,this.overwrittenCellsData=s,this.addedGlobalNamedExpressions=o,this.version=i}doUndo(e){e.undoMoveCells(this)}doRedo(e){e.redoMoveCells(this)}}class js extends Bs{constructor(e){super(),this.command=e}doUndo(e){e.undoAddRows(this)}doRedo(e){e.redoAddRows(this)}}class Gs extends Bs{constructor(e,t,r){super(),this.sheetId=e,this.rowMapping=t,this.oldContent=r}doUndo(e){e.undoSetRowOrder(this)}doRedo(e){e.redoSetRowOrder(this)}}class zs extends Bs{constructor(e,t,r){super(),this.sheetId=e,this.columnMapping=t,this.oldContent=r}doUndo(e){e.undoSetColumnOrder(this)}doRedo(e){e.redoSetColumnOrder(this)}}class $s extends Bs{constructor(e,t,r){super(),this.sheetId=e,this.oldSheetContent=t,this.newSheetContent=r}doUndo(e){e.undoSetSheetContent(this)}doRedo(e){e.redoSetSheetContent(this)}}class Ks extends Bs{constructor(e,t,r,n,s){super(),this.sheet=e,this.startRow=t,this.numberOfRows=r,this.targetRow=n,this.version=s,this.undoStart=this.startRow<this.targetRow?this.targetRow-this.numberOfRows:this.targetRow,this.undoEnd=this.startRow>this.targetRow?this.startRow+this.numberOfRows:this.startRow}doUndo(e){e.undoMoveRows(this)}doRedo(e){e.redoMoveRows(this)}}class Xs extends Bs{constructor(e,t,r,n,s){super(),this.sheet=e,this.startColumn=t,this.numberOfColumns=r,this.targetColumn=n,this.version=s,this.undoStart=this.startColumn<this.targetColumn?this.targetColumn-this.numberOfColumns:this.targetColumn,this.undoEnd=this.startColumn>this.targetColumn?this.startColumn+this.numberOfColumns:this.startColumn}doUndo(e){e.undoMoveColumns(this)}doRedo(e){e.redoMoveColumns(this)}}class qs extends Bs{constructor(e){super(),this.command=e}doUndo(e){e.undoAddColumns(this)}doRedo(e){e.redoAddColumns(this)}}class Qs extends Bs{constructor(e,t){super(),this.command=e,this.columnsRemovals=t}doUndo(e){e.undoRemoveColumns(this)}doRedo(e){e.redoRemoveColumns(this)}}class Zs extends Bs{constructor(e){super(),this.sheetName=e}doUndo(e){e.undoAddSheet(this)}doRedo(e){e.redoAddSheet(this)}}class Js extends Bs{constructor(e,t,r,n,s){super(),this.sheetName=e,this.sheetId=t,this.oldSheetContent=r,this.scopedNamedExpressions=n,this.version=s}doUndo(e){e.undoRemoveSheet(this)}doRedo(e){e.redoRemoveSheet(this)}}class eo extends Bs{constructor(e,t,r){super(),this.sheetId=e,this.oldName=t,this.newName=r}doUndo(e){e.undoRenameSheet(this)}doRedo(e){e.redoRenameSheet(this)}}class to extends Bs{constructor(e,t){super(),this.sheetId=e,this.oldSheetContent=t}doUndo(e){e.undoClearSheet(this)}doRedo(e){e.redoClearSheet(this)}}class ro extends Bs{constructor(e){super(),this.cellContents=e}doUndo(e){e.undoSetCellContents(this)}doRedo(e){e.redoSetCellContents(this)}}class no extends Bs{constructor(e,t,r,n){super(),this.targetLeftCorner=e,this.oldContent=t,this.newContent=r,this.addedGlobalNamedExpressions=n}doUndo(e){e.undoPaste(this)}doRedo(e){e.redoPaste(this)}}class so extends Bs{constructor(e,t,r,n){super(),this.name=e,this.newContent=t,this.scope=r,this.options=n}doUndo(e){e.undoAddNamedExpression(this)}doRedo(e){e.redoAddNamedExpression(this)}}class oo extends Bs{constructor(e,t,r){super(),this.namedExpression=e,this.content=t,this.scope=r}doUndo(e){e.undoRemoveNamedExpression(this)}doRedo(e){e.redoRemoveNamedExpression(this)}}class io extends Bs{constructor(e,t,r,n,s){super(),this.namedExpression=e,this.newContent=t,this.oldContent=r,this.scope=n,this.options=s}doUndo(e){e.undoChangeNamedExpression(this)}doRedo(e){e.redoChangeNamedExpression(this)}}class ao extends Bs{constructor(){super(...arguments),this.operations=[]}add(e){this.operations.push(e)}*reversedOperations(){for(let e=this.operations.length-1;e>=0;e--)yield this.operations[e]}doUndo(e){e.undoBatch(this)}doRedo(e){e.redoBatch(this)}}class lo{constructor(e,t){this.operations=t,this.oldData=new Map,this.undoStack=[],this.redoStack=[],this.undoLimit=e.undoLimit}saveOperation(e){void 0!==this.batchUndoEntry?this.batchUndoEntry.add(e):this.addUndoEntry(e)}beginBatchMode(){this.batchUndoEntry=new ao}commitBatchMode(){if(void 0===this.batchUndoEntry)throw Error("Batch mode wasn't started");this.addUndoEntry(this.batchUndoEntry),this.batchUndoEntry=void 0}storeDataForVersion(e,t,r){this.oldData.has(e)||this.oldData.set(e,[]);this.oldData.get(e).push([t,r])}clearRedoStack(){this.redoStack=[]}clearUndoStack(){this.undoStack=[]}isUndoStackEmpty(){return 0===this.undoStack.length}isRedoStackEmpty(){return 0===this.redoStack.length}undo(){const e=this.undoStack.pop();if(!e)throw Error("Attempted to undo without operation on stack");this.undoEntry(e),this.redoStack.push(e)}undoBatch(e){for(const t of e.reversedOperations())this.undoEntry(t)}undoRemoveRows(e){this.operations.forceApplyPostponedTransformations();const{command:{sheet:t},rowsRemovals:r}=e;for(let e=r.length-1;e>=0;--e){const n=r[e];this.operations.addRows(new Ls(t,[[n.rowFrom,n.rowCount]]));for(const{address:e,cellType:t}of n.removedCells)this.operations.restoreCell(e,t);this.restoreOldDataFromVersion(n.version-1)}}undoRemoveColumns(e){this.operations.forceApplyPostponedTransformations();const{command:{sheet:t},columnsRemovals:r}=e;for(let e=r.length-1;e>=0;--e){const n=r[e];this.operations.addColumns(new Ds(t,[[n.columnFrom,n.columnCount]]));for(const{address:e,cellType:t}of n.removedCells)this.operations.restoreCell(e,t);this.restoreOldDataFromVersion(n.version-1)}}undoAddRows(e){const t=e.command.rowsSpans();for(let r=t.length-1;r>=0;--r){const n=t[r];this.operations.removeRows(new Ps(e.command.sheet,[[n.rowStart,n.numberOfRows]]))}}undoAddColumns(e){const t=e.command.columnsSpans();for(let r=t.length-1;r>=0;--r){const n=t[r];this.operations.removeColumns(new ks(e.command.sheet,[[n.columnStart,n.numberOfColumns]]))}}undoSetCellContents(e){for(const t of e.cellContents){const e=t.address,[r,n]=t.oldContent;Dr(e,r)||this.operations.setCellEmpty(e),this.operations.restoreCell(r,n)}}undoPaste(e){this.restoreOperationOldContent(e.oldContent);for(const t of e.addedGlobalNamedExpressions)this.operations.removeNamedExpression(t)}undoMoveRows(e){const{sheet:t}=e;this.operations.moveRows(t,e.undoStart,e.numberOfRows,e.undoEnd),this.restoreOldDataFromVersion(e.version-1)}undoMoveColumns(e){const{sheet:t}=e;this.operations.moveColumns(t,e.undoStart,e.numberOfColumns,e.undoEnd),this.restoreOldDataFromVersion(e.version-1)}undoMoveCells(e){this.operations.forceApplyPostponedTransformations(),this.operations.moveCells(e.destinationLeftCorner,e.width,e.height,e.sourceLeftCorner),this.restoreOperationOldContent(e.overwrittenCellsData),this.restoreOldDataFromVersion(e.version-1);for(const t of e.addedGlobalNamedExpressions)this.operations.removeNamedExpression(t)}undoAddSheet(e){const{sheetName:t}=e;this.operations.removeSheetByName(t)}undoRemoveSheet(e){this.operations.forceApplyPostponedTransformations();const{oldSheetContent:t,sheetId:r}=e;this.operations.addSheet(e.sheetName);for(let e=0;e<t.length;e++){const n=t[e];for(let t=0;t<n.length;t++){const s=n[t],o=br(r,t,e);this.operations.restoreCell(o,s)}}for(const[t,n]of e.scopedNamedExpressions)this.operations.restoreNamedExpression(t,n,r);this.restoreOldDataFromVersion(e.version-1)}undoRenameSheet(e){this.operations.renameSheet(e.sheetId,e.oldName)}undoClearSheet(e){const{oldSheetContent:t,sheetId:r}=e;for(let e=0;e<t.length;e++){const n=t[e];for(let t=0;t<n.length;t++){const s=n[t],o=br(r,t,e);this.operations.restoreCell(o,s)}}}undoSetSheetContent(e){const{oldSheetContent:t,sheetId:r}=e;this.operations.clearSheet(r);for(let e=0;e<t.length;e++){const n=t[e];for(let t=0;t<n.length;t++){const s=n[t],o=br(r,t,e);this.operations.restoreCell(o,s)}}}undoAddNamedExpression(e){this.operations.removeNamedExpression(e.name,e.scope)}undoRemoveNamedExpression(e){this.operations.restoreNamedExpression(e.namedExpression,e.content,e.scope)}undoChangeNamedExpression(e){this.operations.restoreNamedExpression(e.namedExpression,e.oldContent,e.scope)}undoSetRowOrder(e){this.restoreOperationOldContent(e.oldContent)}undoSetColumnOrder(e){this.restoreOperationOldContent(e.oldContent)}redo(){const e=this.redoStack.pop();if(!e)throw Error("Attempted to redo without operation on stack");this.redoEntry(e),this.undoStack.push(e)}redoBatch(e){for(const t of e.operations)this.redoEntry(t)}redoRemoveRows(e){this.operations.removeRows(e.command)}redoMoveCells(e){this.operations.moveCells(e.sourceLeftCorner,e.width,e.height,e.destinationLeftCorner)}redoRemoveColumns(e){this.operations.removeColumns(e.command)}redoPaste(e){const{targetLeftCorner:t,newContent:r}=e,n=r.length,s=r[0].length;for(let e=0;e<n;++e)for(let n=0;n<s;++n){const s=br(t.sheet,t.col+n,t.row+e);this.operations.restoreCell(s,r[e][n])}}redoSetCellContents(e){for(const t of e.cellContents)this.operations.setCellContent(t.address,t.newContent)}redoAddRows(e){this.operations.addRows(e.command)}redoAddColumns(e){this.operations.addColumns(e.command)}redoRemoveSheet(e){this.operations.removeSheetByName(e.sheetName)}redoAddSheet(e){this.operations.addSheet(e.sheetName)}redoRenameSheet(e){this.operations.renameSheet(e.sheetId,e.newName)}redoMoveRows(e){this.operations.moveRows(e.sheet,e.startRow,e.numberOfRows,e.targetRow)}redoMoveColumns(e){this.operations.moveColumns(e.sheet,e.startColumn,e.numberOfColumns,e.targetColumn)}redoClearSheet(e){this.operations.clearSheet(e.sheetId)}redoSetSheetContent(e){const{sheetId:t,newSheetContent:r}=e;this.operations.setSheetContent(t,r)}redoAddNamedExpression(e){this.operations.addNamedExpression(e.name,e.newContent,e.scope,e.options)}redoRemoveNamedExpression(e){this.operations.removeNamedExpression(e.namedExpression.displayName,e.scope)}redoChangeNamedExpression(e){this.operations.changeNamedExpressionExpression(e.namedExpression.displayName,e.newContent,e.scope,e.options)}redoSetRowOrder(e){this.operations.setRowOrder(e.sheetId,e.rowMapping)}redoSetColumnOrder(e){this.operations.setColumnOrder(e.sheetId,e.columnMapping)}addUndoEntry(e){this.undoStack.push(e),this.undoStack.splice(0,Math.max(0,this.undoStack.length-this.undoLimit))}undoEntry(e){e.doUndo(this)}restoreOperationOldContent(e){for(const[t,r]of e)this.operations.restoreCell(t,r)}redoEntry(e){e.doRedo(this)}restoreOldDataFromVersion(e){const t=this.oldData.get(e)||[];for(const e of t){const[t,r]=e;this.operations.setFormulaToCellFromCache(r,t)}}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ho{constructor(e,t,r,n,s,o,i,a,l,h){this.operations=t,this.undoRedo=r,this.clipboardOperations=n,this.dependencyGraph=s,this.columnSearch=o,this.parser=i,this.cellContentParser=a,this.lazilyTransformingAstService=l,this.namedExpressions=h,this.maxRows=e.maxRows,this.maxColumns=e.maxColumns}get sheetMapping(){return this.dependencyGraph.sheetMapping}addRows(e,...t){const r=new Ls(e,t);this.ensureItIsPossibleToAddRows(e,...t),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut(),this.operations.addRows(r),this.undoRedo.saveOperation(new js(r))}removeRows(e,...t){const r=new Ps(e,t);this.ensureItIsPossibleToRemoveRows(e,...t),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const n=this.operations.removeRows(r);this.undoRedo.saveOperation(new Ws(r,n))}addColumns(e,...t){const r=new Ds(e,t);this.ensureItIsPossibleToAddColumns(e,...t),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut(),this.operations.addColumns(r),this.undoRedo.saveOperation(new qs(r))}removeColumns(e,...t){const r=new ks(e,t);this.ensureItIsPossibleToRemoveColumns(e,...t),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const n=this.operations.removeColumns(r);this.undoRedo.saveOperation(new Qs(r,n))}moveCells(e,t,r,n){this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const{version:s,overwrittenCellsData:o,addedGlobalNamedExpressions:i}=this.operations.moveCells(e,t,r,n);this.undoRedo.saveOperation(new Ys(e,t,r,n,o,i,s))}moveRows(e,t,r,n){this.ensureItIsPossibleToMoveRows(e,t,r,n),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const s=this.operations.moveRows(e,t,r,n);this.undoRedo.saveOperation(new Ks(e,t,r,n,s))}moveColumns(e,t,r,n){this.ensureItIsPossibleToMoveColumns(e,t,r,n),this.undoRedo.clearRedoStack();const s=this.operations.moveColumns(e,t,r,n);this.undoRedo.saveOperation(new Xs(e,t,r,n,s))}cut(e,t,r){this.clipboardOperations.cut(e,t,r)}ensureItIsPossibleToCopy(e,t,r){if(!uo(t))throw new gt("width to be positive integer.");if(!uo(r))throw new gt("height to be positive integer.")}copy(e,t,r){this.ensureItIsPossibleToCopy(e,t,r),this.clipboardOperations.copy(e,t,r)}paste(e){const t=this.clipboardOperations.clipboard;if(void 0===t)throw new Rt;if(this.clipboardOperations.isCutClipboard())this.moveCells(t.sourceLeftCorner,t.width,t.height,e);else if(this.clipboardOperations.isCopyClipboard()){this.clipboardOperations.ensureItIsPossibleToCopyPaste(e);const r=Fr.spanFrom(e,t.width,t.height),n=this.operations.getRangeClipboardCells(r);this.undoRedo.clearRedoStack();const s=this.operations.restoreClipboardCells(t.sourceLeftCorner.sheet,t.getContent(e));this.undoRedo.saveOperation(new no(e,n,t.content,s))}}beginUndoRedoBatchMode(){this.undoRedo.beginBatchMode()}commitUndoRedoBatchMode(){this.undoRedo.commitBatchMode()}isClipboardEmpty(){return void 0===this.clipboardOperations.clipboard}clearClipboard(){this.clipboardOperations.clear()}addSheet(e){void 0!==e&&this.ensureItIsPossibleToAddSheet(e),this.undoRedo.clearRedoStack();const t=this.operations.addSheet(e);return this.undoRedo.saveOperation(new Zs(t)),t}removeSheet(e){this.ensureScopeIdIsValid(e),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const t=this.sheetMapping.fetchDisplayName(e),r=this.operations.getSheetClipboardCells(e),{version:n,scopedNamedExpressions:s}=this.operations.removeSheet(e);this.undoRedo.saveOperation(new Js(t,e,r,s,n))}renameSheet(e,t){this.ensureItIsPossibleToRenameSheet(e,t);const r=this.operations.renameSheet(e,t);return void 0!==r&&(this.undoRedo.clearRedoStack(),this.undoRedo.saveOperation(new eo(e,r,t))),r}clearSheet(e){this.ensureScopeIdIsValid(e),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const t=this.operations.getSheetClipboardCells(e);this.operations.clearSheet(e),this.undoRedo.saveOperation(new to(e,t))}setCellContents(e,t){if(t instanceof Array){for(let e=0;e<t.length;e++)if(!(t[e]instanceof Array))throw new gt("an array of arrays or a raw cell value.")}else t=[[t]];this.ensureItIsPossibleToChangeCellContents(e,t),this.undoRedo.clearRedoStack();const r=[];for(let n=0;n<t.length;n++)for(let s=0;s<t[n].length;s++){const o={sheet:e.sheet,row:e.row+n,col:e.col+s},i=t[n][s];this.clipboardOperations.abortCut();const a=this.operations.setCellContent(o,i);r.push({address:o,newContent:i,oldContent:a})}this.undoRedo.saveOperation(new ro(r))}setSheetContent(e,t){this.ensureScopeIdIsValid(e),this.ensureItIsPossibleToChangeSheetContents(e,t),Os(t),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const r=this.operations.getSheetClipboardCells(e);this.operations.setSheetContent(e,t),this.undoRedo.saveOperation(new $s(e,r,t))}setRowOrder(e,t){this.validateSwapRowIndexes(e,t),this.testRowOrderForArrays(e,t),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const r=this.operations.setRowOrder(e,t);this.undoRedo.saveOperation(new Gs(e,t,r))}validateSwapRowIndexes(e,t){if(!this.sheetMapping.hasSheetWithId(e))throw new lt(e);this.validateRowOrColumnMapping(e,t,"row")}testColumnOrderForArrays(e,t){for(const[r,n]of t)if(r!==n){const t=Fr.spanFrom({sheet:e,col:r,row:0},1,1/0);if(this.dependencyGraph.arrayMapping.isFormulaArrayInRange(t))throw new kt}}setColumnOrder(e,t){this.validateSwapColumnIndexes(e,t),this.testColumnOrderForArrays(e,t),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const r=this.operations.setColumnOrder(e,t);this.undoRedo.saveOperation(new zs(e,t,r))}validateSwapColumnIndexes(e,t){if(!this.sheetMapping.hasSheetWithId(e))throw new lt(e);this.validateRowOrColumnMapping(e,t,"column")}testRowOrderForArrays(e,t){for(const[r,n]of t)if(r!==n){const t=Fr.spanFrom({sheet:e,col:0,row:r},1/0,1);if(this.dependencyGraph.arrayMapping.isFormulaArrayInRange(t))throw new kt}}mappingFromOrder(e,t,r){if(!this.sheetMapping.hasSheetWithId(e))throw new lt(e);const n="row"===r?this.dependencyGraph.getSheetHeight(e):this.dependencyGraph.getSheetWidth(e);if(t.length!==n)throw new gt(`number of ${r}s provided to be sheet ${"row"===r?"height":"width"}.`);const s=[];for(let e=0;e<n;e++)t[e]!==e&&s.push([e,t[e]]);return s}undo(){if(this.undoRedo.isUndoStackEmpty())throw new wt;this.clipboardOperations.abortCut(),this.undoRedo.undo()}redo(){if(this.undoRedo.isRedoStackEmpty())throw new Ct;this.clipboardOperations.abortCut(),this.undoRedo.redo()}addNamedExpression(e,t,r,n){this.ensureItIsPossibleToAddNamedExpression(e,t,r),this.operations.addNamedExpression(e,t,r,n),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut(),this.undoRedo.saveOperation(new so(e,t,r,n))}changeNamedExpressionExpression(e,t,r,n){this.ensureItIsPossibleToChangeNamedExpression(e,r,t);const[s,o]=this.operations.changeNamedExpressionExpression(e,r,t,n);this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut(),this.undoRedo.saveOperation(new io(s,r,o,t,n))}removeNamedExpression(e,t){this.ensureScopeIdIsValid(t);const[r,n]=this.operations.removeNamedExpression(e,t);return this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut(),this.undoRedo.saveOperation(new oo(r,n,t)),r}ensureItIsPossibleToAddNamedExpression(e,t,r){this.ensureScopeIdIsValid(r),this.ensureNamedExpressionNameIsValid(e,r),this.ensureNamedExpressionIsValid(t)}ensureItIsPossibleToChangeNamedExpression(e,t,r){if(this.ensureScopeIdIsValid(r),void 0===this.namedExpressions.namedExpressionForScope(e,r))throw new yt(e);this.ensureNamedExpressionIsValid(t)}isItPossibleToRemoveNamedExpression(e,t){if(this.ensureScopeIdIsValid(t),void 0===this.namedExpressions.namedExpressionForScope(e,t))throw new yt(e)}ensureItIsPossibleToAddRows(e,...t){if(!this.sheetMapping.hasSheetWithId(e))throw new lt(e);if(this.dependencyGraph.getSheetHeight(e)+t.map((e=>e[1])).reduce(((e,t)=>e+t),0)>this.maxRows)throw new ct;for(const[e,r]of t)if(!co(e)||!uo(r))throw new gt("row number to be nonnegative and number of rows to add to be positive.")}ensureItIsPossibleToRemoveRows(e,...t){for(const[r,n]of t){const t=r+n-1;if(!co(r)||!co(t))throw new gt("starting and ending row to be nonnegative.");if(t<r)throw new gt("starting row to be smaller than the ending row.");if(!this.sheetMapping.hasSheetWithId(e))throw new lt(e)}}ensureItIsPossibleToAddColumns(e,...t){if(!this.sheetMapping.hasSheetWithId(e))throw new lt(e);if(this.dependencyGraph.getSheetWidth(e)+t.map((e=>e[1])).reduce(((e,t)=>e+t),0)>this.maxColumns)throw new ct;for(const[e,r]of t)if(!co(e)||!uo(r))throw new gt("column number to be nonnegative and number of columns to add to be positive.")}ensureItIsPossibleToRemoveColumns(e,...t){for(const[r,n]of t){const t=r+n-1;if(!co(r)||!co(t))throw new gt("starting and ending column to be nonnegative.");if(t<r)throw new gt("starting column to be smaller than the ending column.");if(!this.sheetMapping.hasSheetWithId(e))throw new lt(e)}}ensureItIsPossibleToMoveRows(e,t,r,n){this.ensureItIsPossibleToAddRows(e,[n,r]);const s=br(e,0,t),o=br(e,0,n);if(!this.sheetMapping.hasSheetWithId(e)||Ir(s)||Ir(o)||!uo(r)||n<=t+r&&n>=t)throw new gt("a valid range of rows to move.");const i=this.dependencyGraph.getSheetWidth(e),a=Fr.spanFrom(s,i,r);if(this.dependencyGraph.arrayMapping.isFormulaArrayInRange(a))throw new kt;if(n>0&&this.dependencyGraph.arrayMapping.isFormulaArrayInAllRows(st.fromNumberOfRows(e,n-1,2)))throw new Ht}ensureItIsPossibleToMoveColumns(e,t,r,n){this.ensureItIsPossibleToAddColumns(e,[n,r]);const s=br(e,t,0),o=br(e,n,0);if(!this.sheetMapping.hasSheetWithId(e)||Ir(s)||Ir(o)||!uo(r)||n<=t+r&&n>=t)throw new gt("a valid range of columns to move.");const i=this.dependencyGraph.getSheetHeight(e),a=Fr.spanFrom(s,r,i);if(this.dependencyGraph.arrayMapping.isFormulaArrayInRange(a))throw new kt;if(n>0&&this.dependencyGraph.arrayMapping.isFormulaArrayInAllColumns(ot.fromNumberOfColumns(e,n-1,2)))throw new Ht}ensureItIsPossibleToAddSheet(e){if(this.sheetMapping.hasSheetWithName(e))throw new ut(e)}ensureItIsPossibleToRenameSheet(e,t){if(!this.sheetMapping.hasSheetWithId(e))throw new lt(e);const r=this.sheetMapping.get(t);if(void 0!==r&&r!==e)throw new ut(t)}ensureItIsPossibleToChangeContent(e){if(Ir(e))throw new pt(e);if(!this.sheetMapping.hasSheetWithId(e.sheet))throw new lt(e.sheet)}ensureItIsPossibleToChangeCellContents(e,t){const r=xs(t),n=Fr.spanFrom(e,r.width,r.height);this.ensureRangeInSizeLimits(n);for(const e of n.addresses(this.dependencyGraph))this.ensureItIsPossibleToChangeContent(e)}ensureItIsPossibleToChangeSheetContents(e,t){const r=xs(t),n=Fr.spanFrom(br(e,0,0),r.width,r.height);this.ensureRangeInSizeLimits(n)}ensureRangeInSizeLimits(e){if(e.exceedsSheetSizeLimits(this.maxColumns,this.maxRows))throw new ct}isThereSomethingToUndo(){return!this.undoRedo.isUndoStackEmpty()}isThereSomethingToRedo(){return!this.undoRedo.isRedoStackEmpty()}getAndClearContentChanges(){return this.operations.getAndClearContentChanges()}ensureScopeIdIsValid(e){if(void 0!==e&&!this.sheetMapping.hasSheetWithId(e))throw new lt(e)}validateRowOrColumnMapping(e,t,r){const n="row"===r?this.dependencyGraph.getSheetHeight(e):this.dependencyGraph.getSheetWidth(e),s=t.map((([e,t])=>e)).sort(((e,t)=>e-t)),o=t.map((([e,t])=>t)).sort(((e,t)=>e-t));for(let e=0;e<s.length;e++){if(!co(s[e])||s[e]>=n)throw new gt(`${r} numbers to be nonnegative integers and less than sheet ${"row"===r?"height":"width"}.`);if(s[e]===s[e+1])throw new gt(`source ${r} numbers to be unique.`);if(s[e]!==o[e])throw new gt(`target ${r} numbers to be permutation of source ${r} numbers.`)}}ensureNamedExpressionNameIsValid(e,t){if(!this.namedExpressions.isNameValid(e))throw new Et(e);if(!this.namedExpressions.isNameAvailable(e,t))throw new mt(e)}ensureNamedExpressionIsValid(e){const t=this.cellContentParser.parse(e);if(t instanceof cs.Formula){const e=this.parser.parse(t.formula,br(-1,0,0));if(Rs(e.ast))throw new Ft}}}function uo(e){return Number.isInteger(e)&&e>0}function co(e){return Number.isInteger(e)&&e>=0}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class po{constructor(e,t,r,n,s,o){this.config=e,this.stats=t,this.interpreter=r,this.lazilyTransformingAstService=n,this.dependencyGraph=s,this.columnSearch=o}run(){this.stats.start(et.TOP_SORT);const{sorted:e,cycled:t}=this.dependencyGraph.topSortWithScc();this.stats.end(et.TOP_SORT),this.stats.measure(et.EVALUATION,(()=>{this.recomputeFormulas(t,e)}))}partialRun(e){const t=nt.empty();return this.stats.measure(et.EVALUATION,(()=>{this.dependencyGraph.graph.getTopSortedWithSccSubgraphFrom(e,(e=>{if(e instanceof Gt){const r=e.isComputed()?e.getCellValue():void 0,n=this.recomputeFormulaVertexValue(e);if(n!==r){const s=e.getAddress(this.lazilyTransformingAstService);return t.addChange(n,s),this.columnSearch.change(je(r),je(n),s),!0}return!1}return!(e instanceof Kt)||(e.clearCache(),!0)}),(e=>{if(e instanceof Kt)e.clearCache();else if(e instanceof Gt){const r=e.getAddress(this.lazilyTransformingAstService);this.columnSearch.remove(je(e.valueOrUndef()),r);const n=new Tr(or.CYCLE,void 0,e);e.setCellValue(n),t.addChange(n,r)}}))})),t}runAndForget(e,t,r){const n=[];for(const e of We(r,t))if(e instanceof Fr){const t=e;if(void 0===this.dependencyGraph.getRange(t.start,t.end)){const e=new Kt(t);this.dependencyGraph.rangeMapping.setRange(e),n.push(e)}}const s=this.evaluateAstToCellValue(e,new Br(t,this.config.useArrayArithmetic));return n.forEach((e=>{this.dependencyGraph.rangeMapping.removeRange(e)})),s}recomputeFormulas(e,t){e.forEach((e=>{e instanceof Gt&&e.setCellValue(new Tr(or.CYCLE,void 0,e))})),t.forEach((e=>{if(e instanceof Gt){const t=this.recomputeFormulaVertexValue(e),r=e.getAddress(this.lazilyTransformingAstService);this.columnSearch.add(je(t),r)}else e instanceof Kt&&e.clearCache()}))}recomputeFormulaVertexValue(e){const t=e.getAddress(this.lazilyTransformingAstService);if(e instanceof zt&&(e.array.size.isRef||!this.dependencyGraph.isThereSpaceForArray(e)))return e.setNoSpace();{const r=e.getFormula(this.lazilyTransformingAstService),n=this.evaluateAstToCellValue(r,new Br(t,this.config.useArrayArithmetic,e));return e.setCellValue(n)}}evaluateAstToCellValue(e,t){const r=this.interpreter.evaluateAst(e,t);return r instanceof rt?r:r===Ye&&this.config.evaluateNullToZero?0:r}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class go{constructor(e,t){this.address=e,this.newValue=t}get col(){return this.address.col}get row(){return this.address.row}get sheet(){return this.address.sheet}get value(){return this.newValue}}class fo{constructor(e,t){this.name=e,this.newValue=t}}class mo{constructor(e,t,r,n){this.config=e,this.namedExpressions=t,this.sheetIndexMapping=r,this.lazilyTransformingService=n}exportChange(e){const t=e.value,r=e.address;if(r.sheet===Cs.SHEET_FOR_WORKBOOK_EXPRESSIONS){const e=this.namedExpressions.namedExpressionInAddress(r.row);if(!e)throw new Error("Missing named expression");return new fo(e.displayName,this.exportScalarOrRange(t))}if(t instanceof rt){const e=[];for(const[n,s]of t.entriesFromTopLeftCorner(r))e.push(new go(s,this.exportValue(n)));return e}return new go(r,this.exportValue(t))}exportValue(e){return e instanceof rt?this.detailedError(new Tr(or.VALUE,Z.ScalarExpected)):this.config.smartRounding&&Ze(e)?this.cellValueRounding(je(e)):e instanceof Tr?this.detailedError(e):e===Ye?null:je(e)}exportScalarOrRange(e){return e instanceof rt?e.rawData().map((e=>e.map((e=>this.exportValue(e))))):this.exportValue(e)}detailedError(e){var t,r;let n;const s=null===(t=e.root)||void 0===t?void 0:t.getAddress(this.lazilyTransformingService);return void 0!==s&&(n=s.sheet===Cs.SHEET_FOR_WORKBOOK_EXPRESSIONS?null===(r=this.namedExpressions.namedExpressionInAddress(s.row))||void 0===r?void 0:r.displayName:O(this.sheetIndexMapping,s,-1)),new pn(e,this.config.translationPackage.getErrorTranslation(e.type),n)}cellValueRounding(e){if(0===e)return e;const t=Math.floor(Math.log10(Math.abs(e))),r=Math.pow(10,this.config.precisionRounding-t);return e<0?-Math.round(-e*r)/r:Math.round(e*r)/r}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Eo{constructor(e,t,r,n,s,o){this.dependencyGraph=e,this.columnSearch=t,this.parser=r,this.cellContentParser=n,this.stats=s,this.arraySizePredictor=o,this.buildStrategy=new yo(e,t,r,s,n,o)}buildGraph(e,t){const r=t.measure(et.COLLECT_DEPENDENCIES,(()=>this.buildStrategy.run(e)));this.dependencyGraph.getAndClearContentChanges(),t.measure(et.PROCESS_DEPENDENCIES,(()=>this.processDependencies(r)))}processDependencies(e){e.forEach(((e,t)=>{this.dependencyGraph.processCellDependencies(e,t)}))}}class yo{constructor(e,t,r,n,s,o){this.dependencyGraph=e,this.columnIndex=t,this.parser=r,this.stats=n,this.cellContentParser=s,this.arraySizePredictor=o}run(e){const t=new Map;for(const r in e){const n=this.dependencyGraph.getSheetId(r),s=e[r];for(let e=0;e<s.length;++e){const r=s[e];for(let s=0;s<r.length;++s){const o=r[s],i=br(n,s,e),a=this.cellContentParser.parse(o);if(a instanceof cs.Formula){const e=this.stats.measure(et.PARSER,(()=>this.parser.parse(a.formula,i)));if(e.errors.length>0){this.shrinkArrayIfNeeded(i);const t=new pr(e.errors,a.formula);this.dependencyGraph.addVertex(i,t)}else{this.shrinkArrayIfNeeded(i);const r=this.arraySizePredictor.checkArraySize(e.ast,i);if(r.isScalar()){const r=new $t(e.ast,i,0);t.set(r,We(e.dependencies,i)),this.dependencyGraph.addVertex(i,r),e.hasVolatileFunction&&this.dependencyGraph.markAsVolatile(r),e.hasStructuralChangeFunction&&this.dependencyGraph.markAsDependentOnStructureChange(r)}else{const n=new zt(e.ast,i,new cn(r.width,r.height));t.set(n,We(e.dependencies,i)),this.dependencyGraph.addArrayVertex(i,n)}}}else if(a instanceof cs.Empty);else{this.shrinkArrayIfNeeded(i);const e=new dr(a.value,o);this.columnIndex.add(je(a.value),i),this.dependencyGraph.addVertex(i,e)}}}}return t}shrinkArrayIfNeeded(e){const t=this.dependencyGraph.getCell(e);t instanceof zt&&this.dependencyGraph.shrinkArrayToCorner(t)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const wo=new Map([["gpl-v3",1],["missing",2],["invalid",3],["expired",4]]);class Co extends un{version(e,t){return this.runFunction(e.args,t,this.metadata("VERSION"),(()=>{const{licenseKeyValidityState:e,licenseKey:t}=this.config;let r;return wo.has(t)?r=wo.get(t):wo.has(e)?r=wo.get(e):"valid"===e&&(r=t.slice(-5)),`HyperFormula v${$o.version}, ${r}`}))}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function Ro(e,t){var r;let n=t.implementedFunctions[e];const s=null===(r=t.aliases)||void 0===r?void 0:r[e];if(void 0!==s){if(void 0!==n)throw new Ut(e,t.name);n=t.implementedFunctions[s]}if(void 0===n)throw Lt.functionNotDeclaredInPlugin(e,t.name);return n}Co.implementedFunctions={VERSION:{method:"version",parameters:[]}};class vo{constructor(e){if(this.config=e,this.functions=new Map,this.arraySizeFunctions=new Map,this.volatileFunctions=new Set,this.arrayFunctions=new Set,this.structuralChangeFunctions=new Set,this.functionsWhichDoesNotNeedArgumentsToBeComputed=new Set,this.functionsMetadata=new Map,this.doesFunctionNeedArgumentToBeComputed=e=>this.functionsWhichDoesNotNeedArgumentsToBeComputed.has(e),this.isFunctionVolatile=e=>this.volatileFunctions.has(e),this.isArrayFunction=e=>this.arrayFunctions.has(e),this.isFunctionDependentOnSheetStructureChange=e=>this.structuralChangeFunctions.has(e),e.functionPlugins.length>0){this.instancePlugins=new Map;for(const t of e.functionPlugins)vo.loadPluginFunctions(t,this.instancePlugins)}else this.instancePlugins=new Map(vo.plugins);for(const[e,t]of vo.protectedFunctions())vo.loadFunctionUnprotected(t,e,this.instancePlugins);for(const[e,t]of this.instancePlugins.entries())this.categorizeFunction(e,Ro(e,t))}static registerFunctionPlugin(e,t){this.loadPluginFunctions(e,this.plugins),void 0!==t&&this.loadTranslations(t)}static registerFunction(e,t,r){this.loadPluginFunction(t,e,this.plugins),void 0!==r&&this.loadTranslations(r)}static unregisterFunction(e){if(this.functionIsProtected(e))throw Dt.cannotUnregisterFunctionWithId(e);this.plugins.delete(e)}static unregisterFunctionPlugin(e){for(const t of this.protectedPlugins())if(t===e)throw Dt.cannotUnregisterProtectedPlugin();for(const[t,r]of this.plugins.entries())r===e&&this.plugins.delete(t)}static unregisterAll(){this.plugins.clear()}static getRegisteredFunctionIds(){return[...Array.from(this.plugins.keys()),...Array.from(this._protectedPlugins.keys())]}static getPlugins(){return Array.from(new Set(this.plugins.values()).values())}static getFunctionPlugin(e){return this.functionIsProtected(e)?void 0:this.plugins.get(e)}static functionIsProtected(e){return this._protectedPlugins.has(e)}static loadTranslations(e){const t=new Set($o.getRegisteredLanguagesCodes());Object.keys(e).forEach((r=>{t.has(r)&&$o.getLanguage(r).extendFunctions(e[r])}))}static loadPluginFunctions(e,t){Object.keys(e.implementedFunctions).forEach((r=>{this.loadPluginFunction(e,r,t)})),void 0!==e.aliases&&Object.keys(e.aliases).forEach((r=>{this.loadPluginFunction(e,r,t)}))}static loadPluginFunction(e,t,r){if(this.functionIsProtected(t))throw Dt.cannotRegisterFunctionWithId(t);this.loadFunctionUnprotected(e,t,r)}static loadFunctionUnprotected(e,t,r){const n=Ro(t,e).method;if(!Object.prototype.hasOwnProperty.call(e.prototype,n))throw Lt.functionMethodNotFound(n,e.name);r.set(t,e)}static*protectedFunctions(){for(const[e,t]of this._protectedPlugins)void 0!==t&&(yield[e,t])}static*protectedPlugins(){for(const[,e]of this._protectedPlugins)void 0!==e&&(yield e)}initializePlugins(e){const t=[];for(const[r,n]of this.instancePlugins.entries()){let s=t.find((e=>e instanceof n));void 0===s&&(s=new n(e),t.push(s));const o=Ro(r,n),i=o.method;this.functions.set(r,[i,s]);const a=o.arraySizeMethod;void 0!==a&&this.arraySizeFunctions.set(r,[a,s])}}getFunctionPlugin(e){if(!vo.functionIsProtected(e))return this.instancePlugins.get(e)}getFunction(e){const t=this.functions.get(e);if(void 0!==t&&this.config.translationPackage.isFunctionTranslated(e)){const[e,r]=t;return(t,n)=>r[e](t,n)}}getArraySizeFunction(e){const t=this.arraySizeFunctions.get(e);if(void 0!==t&&this.config.translationPackage.isFunctionTranslated(e)){const[e,r]=t;return(t,n)=>r[e](t,n)}}getMetadata(e){return this.functionsMetadata.get(e)}getPlugins(){const e=new Set;for(const[t,r]of this.instancePlugins)vo.functionIsProtected(t)||e.add(r);return Array.from(e)}getRegisteredFunctionIds(){return Array.from(this.functions.keys())}categorizeFunction(e,t){t.isVolatile&&this.volatileFunctions.add(e),t.arrayFunction&&this.arrayFunctions.add(e),t.doesNotNeedArgumentsToBeComputed&&this.functionsWhichDoesNotNeedArgumentsToBeComputed.add(e),t.isDependentOnSheetStructureChange&&this.structuralChangeFunctions.add(e),this.functionsMetadata.set(e,t)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
var So;vo.plugins=new Map,vo._protectedPlugins=new Map([["VERSION",Co],["OFFSET",void 0]]),function(e){e.GREATER_THAN="GREATER_THAN",e.GREATER_THAN_OR_EQUAL="GREATER_THAN_OR_EQUAL",e.LESS_THAN="LESS_THAN",e.LESS_THAN_OR_EQUAL="LESS_THAN_OR_EQUAL",e.NOT_EQUAL="NOT_EQUAL",e.EQUAL="EQUAL"}(So||(So={}));const To=(e,t)=>({operator:e,value:t});class No{constructor(e){var t,r,n,s;this.trueString=null!==(r=null===(t=e.translationPackage.getMaybeFunctionTranslation("TRUE"))||void 0===t?void 0:t.toLowerCase())&&void 0!==r?r:"true",this.falseString=null!==(s=null===(n=e.translationPackage.getMaybeFunctionTranslation("FALSE"))||void 0===n?void 0:n.toLowerCase())&&void 0!==s?s:"false"}fromCellValue(e,t){if("string"!=typeof e&&"boolean"!=typeof e&&"number"!=typeof e)return;const r=this.parseCriterion(e,t);return void 0!==r?{raw:e,lambda:Mo(r,t)}:void 0}parseCriterion(e,t){if("number"==typeof e||"boolean"==typeof e)return To(So.EQUAL,e);if("string"==typeof e){const r=_o.exec(e);let n,s;r?(s=function(e){switch(e){case">":return So.GREATER_THAN;case">=":return So.GREATER_THAN_OR_EQUAL;case"<":return So.LESS_THAN;case"<=":return So.LESS_THAN_OR_EQUAL;case"<>":return So.NOT_EQUAL;case"=":return So.EQUAL;default:return}}(r[1]),n=r[2]):(s=So.EQUAL,n=e);const o=t.coerceToMaybeNumber(n),i=n.toLowerCase()===this.trueString||n.toLowerCase()!==this.falseString&&void 0;if(void 0===s)return;if(""===n)return To(s,null);if(void 0!==o)return To(s,je(o));if(s===So.EQUAL||s===So.NOT_EQUAL)return To(s,null!=i?i:n)}}}const _o=/([<>=]+)(.*)/;const Mo=(e,t)=>{switch(e.operator){case So.GREATER_THAN:return"number"==typeof e.value?r=>"number"==typeof r&&t.floatCmp(r,e.value)>0:e=>!1;case So.GREATER_THAN_OR_EQUAL:return"number"==typeof e.value?r=>"number"==typeof r&&t.floatCmp(r,e.value)>=0:e=>!1;case So.LESS_THAN:return"number"==typeof e.value?r=>"number"==typeof r&&t.floatCmp(r,e.value)<0:e=>!1;case So.LESS_THAN_OR_EQUAL:return"number"==typeof e.value?r=>"number"==typeof r&&t.floatCmp(r,e.value)<=0:e=>!1;case So.EQUAL:return"number"==typeof e.value?r=>{if("number"==typeof r)return 0===t.floatCmp(r,e.value);if("string"==typeof r){if(""===r)return!1;const n=t.coerceToMaybeNumber(r);return void 0!==n&&0===t.floatCmp(n,e.value)}return!1}:"string"==typeof e.value?t.eqMatcherFunction(e.value):"boolean"==typeof e.value?t=>"boolean"==typeof t&&t===e.value:e=>e===Ye;case So.NOT_EQUAL:return"number"==typeof e.value?r=>{if("number"==typeof r)return 0!==t.floatCmp(r,e.value);if("string"==typeof r){if(""===r)return!0;const n=t.coerceToMaybeNumber(r);return void 0===n||0!==t.floatCmp(n,e.value)}return!0}:"string"==typeof e.value?t.neqMatcherFunction(e.value):"boolean"==typeof e.value?t=>"boolean"!=typeof t||t!==e.value:e=>e!==Ye}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ao{constructor(e,t,r,n,s,o,i,a,l,h){this.config=e,this.dependencyGraph=t,this.columnSearch=r,this.stats=n,this.arithmeticHelper=s,this.functionRegistry=o,this.namedExpressions=i,this.serialization=a,this.arraySizePredictor=l,this.dateTimeHelper=h,this.equalOp=(e,t)=>Io(this.arithmeticHelper.eq,e,t),this.notEqualOp=(e,t)=>Io(this.arithmeticHelper.neq,e,t),this.greaterThanOp=(e,t)=>Io(this.arithmeticHelper.gt,e,t),this.lessThanOp=(e,t)=>Io(this.arithmeticHelper.lt,e,t),this.greaterThanOrEqualOp=(e,t)=>Io(this.arithmeticHelper.geq,e,t),this.lessThanOrEqualOp=(e,t)=>Io(this.arithmeticHelper.leq,e,t),this.concatOp=(e,t)=>Io(this.arithmeticHelper.concat,Xr(e),Xr(t)),this.plusOp=(e,t)=>Io(this.arithmeticHelper.addWithEpsilon,this.arithmeticHelper.coerceScalarToNumberOrError(e),this.arithmeticHelper.coerceScalarToNumberOrError(t)),this.minusOp=(e,t)=>Io(this.arithmeticHelper.subtract,this.arithmeticHelper.coerceScalarToNumberOrError(e),this.arithmeticHelper.coerceScalarToNumberOrError(t)),this.timesOp=(e,t)=>Io(this.arithmeticHelper.multiply,this.arithmeticHelper.coerceScalarToNumberOrError(e),this.arithmeticHelper.coerceScalarToNumberOrError(t)),this.powerOp=(e,t)=>Io(this.arithmeticHelper.pow,this.arithmeticHelper.coerceScalarToNumberOrError(e),this.arithmeticHelper.coerceScalarToNumberOrError(t)),this.divOp=(e,t)=>Io(this.arithmeticHelper.divide,this.arithmeticHelper.coerceScalarToNumberOrError(e),this.arithmeticHelper.coerceScalarToNumberOrError(t)),this.unaryMinusOp=e=>bo(this.arithmeticHelper.unaryMinus,this.arithmeticHelper.coerceScalarToNumberOrError(e)),this.percentOp=e=>bo(this.arithmeticHelper.unaryPercent,this.arithmeticHelper.coerceScalarToNumberOrError(e)),this.unaryPlusOp=e=>this.arithmeticHelper.unaryPlus(e),this.functionRegistry.initializePlugins(this),this.criterionBuilder=new No(e)}evaluateAst(e,t){let r=this.evaluateAstWithoutPostprocessing(e,t);if(Ze(r)){if(Zr(je(r)))return new Tr(or.NUM,Z.NaN);r=ze(r,Jr(je(r)))}return r instanceof rt&&1===r.height()&&1===r.width()&&([[r]]=r.data),function(e,t){if(e instanceof Tr&&void 0!==t)return e.attachRootVertex(t);return e}(r,t.formulaVertex)}evaluateAstWithoutPostprocessing(e,t){switch(e.type){case U.EMPTY:return Ye;case U.CELL_REFERENCE:{const r=e.reference.toSimpleCellAddress(t.formulaAddress);return Ir(r)?new Tr(or.REF,Z.BadRef):this.dependencyGraph.getCellValue(r)}case U.NUMBER:case U.STRING:return e.value;case U.CONCATENATE_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.concatOp,r,n,t)}case U.EQUALS_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.equalOp,r,n,t)}case U.NOT_EQUAL_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.notEqualOp,r,n,t)}case U.GREATER_THAN_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.greaterThanOp,r,n,t)}case U.LESS_THAN_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.lessThanOp,r,n,t)}case U.GREATER_THAN_OR_EQUAL_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.greaterThanOrEqualOp,r,n,t)}case U.LESS_THAN_OR_EQUAL_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.lessThanOrEqualOp,r,n,t)}case U.PLUS_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.plusOp,r,n,t)}case U.MINUS_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.minusOp,r,n,t)}case U.TIMES_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.timesOp,r,n,t)}case U.POWER_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.powerOp,r,n,t)}case U.DIV_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.divOp,r,n,t)}case U.PLUS_UNARY_OP:{const r=this.evaluateAst(e.value,t);return this.unaryRangeWrapper(this.unaryPlusOp,r,t)}case U.MINUS_UNARY_OP:{const r=this.evaluateAst(e.value,t);return this.unaryRangeWrapper(this.unaryMinusOp,r,t)}case U.PERCENT_OP:{const r=this.evaluateAst(e.value,t);return this.unaryRangeWrapper(this.percentOp,r,t)}case U.FUNCTION_CALL:{if("valid"!==this.config.licenseKeyValidityState&&!vo.functionIsProtected(e.procedureName))return new Tr(or.LIC,Z.LicenseKey(this.config.licenseKeyValidityState));const r=this.functionRegistry.getFunction(e.procedureName);return void 0!==r?r(e,new Br(t.formulaAddress,t.arraysFlag||this.functionRegistry.isArrayFunction(e.procedureName),t.formulaVertex)):new Tr(or.NAME,Z.FunctionName(e.procedureName))}case U.NAMED_EXPRESSION:{const r=this.namedExpressions.nearestNamedExpression(e.expressionName,t.formulaAddress.sheet);return r?this.dependencyGraph.getCellValue(r.address):new Tr(or.NAME,Z.NamedExpressionName(e.expressionName))}case U.CELL_RANGE:{if(!this.rangeSpansOneSheet(e))return new Tr(or.REF,Z.RangeManySheets);const r=Fr.fromCellRange(e,t.formulaAddress),n=this.dependencyGraph.getArray(r);if(n){const e=n.array;if(e instanceof Wt)throw new Error("Array should be already computed");if(e instanceof Tr)return e;if(e instanceof Yt)return rt.fromRange(e.raw(),r,this.dependencyGraph);throw new Error("Unknown array")}return rt.onlyRange(r,this.dependencyGraph)}case U.COLUMN_RANGE:{if(!this.rangeSpansOneSheet(e))return new Tr(or.REF,Z.RangeManySheets);const r=Ur.fromColumnRange(e,t.formulaAddress);return rt.onlyRange(r,this.dependencyGraph)}case U.ROW_RANGE:{if(!this.rangeSpansOneSheet(e))return new Tr(or.REF,Z.RangeManySheets);const r=Vr.fromRowRangeAst(e,t.formulaAddress);return rt.onlyRange(r,this.dependencyGraph)}case U.PARENTHESIS:return this.evaluateAst(e.expression,t);case U.ARRAY:{let r;const n=[];for(const s of e.args){let e;const o=[];for(const r of s){const n=Gr(this.evaluateAst(r,t)),s=n.height();if(void 0===e)e=s,o.push(...n.data);else{if(e!==s)return new Tr(or.REF,Z.SizeMismatch);for(let e=0;e<s;e++)o[e].push(...n.data[e])}}const i=o[0].length;if(void 0===r)r=i,n.push(...o);else{if(r!==i)return new Tr(or.REF,Z.SizeMismatch);n.push(...o)}}return rt.onlyValues(n)}case U.ERROR_WITH_RAW_INPUT:case U.ERROR:return e.error}}rangeSpansOneSheet(e){return e.start.sheet===e.end.sheet}unaryRangeWrapper(e,t,r){var n;if(t instanceof rt&&!r.arraysFlag&&(t=null!==(n=an(t,r))&&void 0!==n?n:new Tr(or.VALUE,Z.ScalarExpected)),t instanceof Tr)return t;if(t instanceof rt){const r=t.data.map((t=>t.map(e)));return rt.onlyValues(r)}return e(t)}binaryRangeWrapper(e,t,r,n){var s,o;if(t instanceof rt&&!n.arraysFlag&&(t=null!==(s=an(t,n))&&void 0!==s?s:new Tr(or.VALUE,Z.ScalarExpected)),t instanceof Tr)return t;if(r instanceof rt&&!n.arraysFlag&&(r=null!==(o=an(r,n))&&void 0!==o?o:new Tr(or.VALUE,Z.ScalarExpected)),r instanceof Tr)return r;if(t instanceof rt||r instanceof rt){if(!(t instanceof rt)){if(r.isAdHoc()){const n=r.data;for(let r=0;r<n.length;r++)for(let s=0;s<n[0].length;s++)n[r][s]=e(t,n[r][s]);return rt.onlyValues(n)}t=rt.fromScalar(t)}if(!(r instanceof rt)){if(t.isAdHoc()){const n=t.data;for(let t=0;t<n.length;t++)for(let s=0;s<n[0].length;s++)n[t][s]=e(n[t][s],r);return rt.onlyValues(n)}r=rt.fromScalar(r)}if(t.width()===r.width()&&t.height()===r.height()){if(t.isAdHoc()){const n=t.data,s=r.data;for(let t=0;t<n.length;t++)for(let r=0;r<n[0].length;r++)n[t][r]=e(n[t][r],s[t][r]);return rt.onlyValues(n)}if(r.isAdHoc()){const n=t.data,s=r.data;for(let t=0;t<n.length;t++)for(let r=0;r<n[0].length;r++)s[t][r]=e(n[t][r],s[t][r]);return rt.onlyValues(s)}}const n=Math.max(t.width(),r.width()),s=Math.max(t.height(),r.height()),o=Array(s);for(let e=0;e<s;e++)o[e]=Array(n);for(let i=0;i<s;i++){const s=1!==t.height()?i:0,a=1!==r.height()?i:0;for(let l=0;l<n;l++){const n=1!==t.width()?l:0,h=1!==r.width()?l:0;s<t.height()&&a<r.height()&&n<t.width()&&h<r.width()?o[i][l]=e(t.data[s][n],r.data[a][h]):o[i][l]=new Tr(or.NA)}}return rt.onlyValues(o)}return e(t,r)}}function bo(e,t){return t instanceof Tr?t:e(t)}function Io(e,t,r){return t instanceof Tr?t:r instanceof Tr?r:e(t,r)}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Oo{constructor(e){this.sheet=e,this.transformations=[]}add(e){this.transformations.push(e)}performEagerTransformations(e,t){this.transformations.forEach((r=>r.performEagerTransformations(e,t)))}transformSingleAst(e,t){let[r,n]=[e,t];return this.transformations.forEach((e=>{[r,n]=e.transformSingleAst(r,n)})),[r,n]}isIrreversible(){return!0}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class xo{constructor(e){this.stats=e,this.transformations=[]}version(){return this.transformations.length}addTransformation(e){return void 0!==this.combinedTransformer?this.combinedTransformer.add(e):this.transformations.push(e),this.version()}beginCombinedMode(e){this.combinedTransformer=new Oo(e)}commitCombinedMode(){if(void 0===this.combinedTransformer)throw Error("Combined mode wasn't started");return this.transformations.push(this.combinedTransformer),this.combinedTransformer=void 0,this.version()}applyTransformations(e,t,r){this.stats.start(et.TRANSFORM_ASTS_POSTPONED);for(let n=r;n<this.transformations.length;n++){const r=this.transformations[n];r.isIrreversible()&&(this.undoRedo.storeDataForVersion(n,t,this.parser.computeHashFromAst(e)),this.parser.rememberNewAst(e));const[s,o]=r.transformSingleAst(e,t);e=s,t=o}const n=this.parser.rememberNewAst(e);return this.stats.end(et.TRANSFORM_ASTS_POSTPONED),[n,t,this.transformations.length]}*getTransformationsFrom(e,t){for(let r=e;r<this.transformations.length;r++){const e=this.transformations[r];t&&!t(e)||(yield e)}}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const Po=-1;function Lo(e,t,r){let n=t,s=r;for(;n<s;){const t=Math.ceil((n+s)/2);e(t)?n=t:s=t-1}return n===s&&e(n)?n:Po}function Do(e,t){return typeof e==typeof t?e===Ye?0:e<t?-1:e>t?1:0:e===Ye?-1:t===Ye?1:t instanceof Tr||"number"==typeof e&&"string"==typeof t||"number"==typeof e&&"boolean"==typeof t?-1:"string"==typeof e&&"number"==typeof t?1:"string"==typeof e&&"boolean"==typeof t?-1:1}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ko{constructor(e){this.dependencyGraph=e}advancedFind(e,t){let r;const n=t.range;r=void 0===n?t.valuesFromTopLeftCorner():this.dependencyGraph.computeListOfValuesInRange(n);for(let t=0;t<r.length;t++)if(e(je(r[t])))return t;return-1}basicFind(e,t,r,{ordering:n,matchExactly:s}){const o="string"==typeof e?on(e):e,i=t.range;return void 0===i?this.findNormalizedValue(o,t.valuesFromTopLeftCorner()):"none"===n?this.findNormalizedValue(o,this.dependencyGraph.computeListOfValuesInRange(i)):function(e,t,{searchCoordinate:r,orderingDirection:n,matchExactly:s},o){const i=t.start[r],a="col"===r?t.effectiveEndColumn(o):t.effectiveEndRow(o),l="col"===r?e=>je(o.getCellValue(br(t.sheet,e,t.start.row))):e=>je(o.getCellValue(br(t.sheet,t.start.col,e))),h="asc"===n?(e,t)=>Do(e,t):(e,t)=>-Do(e,t),u=Lo((t=>h(e,l(t))>=0),i,a),c=l(u);return u===Po||typeof c!=typeof e||s&&c!==e?Po:u-i}(o,i,{searchCoordinate:r,orderingDirection:n,matchExactly:s},this.dependencyGraph)}findNormalizedValue(e,t){return t.map(je).map((e=>"string"==typeof e?on(e):e)).indexOf(e)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ho extends ko{constructor(e){super(e),this.dependencyGraph=e}add(e,t){}remove(e,t){}change(e,t,r){}applyChanges(e){}addColumns(e){}removeColumns(e){}removeSheet(e){}moveValues(e,t,r,n){}removeValues(e){}find(e,t,r){return this.basicFind(e,t,"row",r)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Fo{constructor(e,t,r){this.dependencyGraph=e,this.config=t,this.stats=r,this.index=new Map,this.transformingService=this.dependencyGraph.lazilyTransformingAstService,this.binarySearchStrategy=new Ho(e)}add(e,t){if(!(e===Ye||e instanceof Tr))if(e instanceof rt)for(const[r,n]of e.entriesFromTopLeftCorner(t))this.addSingleCellValue(je(r),n);else this.addSingleCellValue(e,t)}remove(e,t){if(void 0!==e)if(e instanceof rt)for(const[r,n]of e.entriesFromTopLeftCorner(t))this.removeSingleValue(je(r),n);else this.removeSingleValue(e,t)}change(e,t,r){e!==t&&(this.remove(e,r),this.add(t,r))}applyChanges(e){for(const t of e)void 0!==t.oldValue&&this.change(je(t.oldValue),je(t.value),t.address)}moveValues(e,t,r,n){for(const[s,o]of e){const e=Or(o,n,t,r);this.remove(s,o),this.add(s,e)}}removeValues(e){for(const[t,r]of e)this.remove(t,r)}find(e,t,{ordering:r,matchExactly:n}){const s=!0===n?"findFirst":"findLast",o=this.findUsingColumnIndex(e,t,s);return void 0!==o?o:this.binarySearchStrategy.find(e,t,{ordering:r,matchExactly:n})}findUsingColumnIndex(e,t,r){const n=t.range;if(void 0===n)return;this.ensureRecentData(n.sheet,n.start.col,e);const s=this.getColumnMap(n.sheet,n.start.col);if(!s)return-1;const o="string"==typeof e?on(e):e,i=s.get(o);if(!i||!i.index||0===i.index.length)return;const a=Fo.findRowBelongingToRange(i,n,r);return void 0!==a?a-n.start.row:void 0}static findRowBelongingToRange(e,t,r){const n=t.start.row,s=t.end.row,o="findFirst"===r?Uo(n,e.index,"upperBound"):Uo(s,e.index,"lowerBound");if(-1===o)return;const i=e.index[o];return i>=n&&i<=s?i:void 0}advancedFind(e,t){return this.binarySearchStrategy.advancedFind(e,t)}addColumns(e){const t=this.index.get(e.sheet);t&&t.splice(e.columnStart,0,...Array(e.numberOfColumns))}removeColumns(e){const t=this.index.get(e.sheet);t&&t.splice(e.columnStart,e.numberOfColumns)}removeSheet(e){this.index.delete(e)}getColumnMap(e,t){this.index.has(e)||this.index.set(e,[]);const r=this.index.get(e);let n=r[t];return n||(n=new Map,r[t]=n),n}getValueIndex(e,t,r){const n=this.getColumnMap(e,t);let s=this.getColumnMap(e,t).get(r);return s||(s={version:this.transformingService.version(),index:[]},n.set(r,s)),s}ensureRecentData(e,t,r){const n=this.getValueIndex(e,t,r),s=this.transformingService.version();if(n.version===s)return;const o=this.transformingService.getTransformationsFrom(n.version,(t=>t.sheet===e&&(t instanceof Ts||t instanceof bs)));for(const e of o)e instanceof Ts?this.addRows(t,e.rowsSpan,r):e instanceof bs&&this.removeRows(t,e.rowsSpan,r);n.version=s}addSingleCellValue(e,t){this.stats.measure(et.BUILD_COLUMN_INDEX,(()=>{this.ensureRecentData(t.sheet,t.col,e),"string"==typeof e&&(e=on(e));const r=this.getValueIndex(t.sheet,t.col,e);Fo.addValue(r,t.row)}))}removeSingleValue(e,t){this.stats.measure(et.BUILD_COLUMN_INDEX,(()=>{this.ensureRecentData(t.sheet,t.col,e);const r=this.getColumnMap(t.sheet,t.col);"string"==typeof e&&(e=on(e));const n=r.get(e);if(!n)return;const s=Uo(t.row,n.index);s>-1&&n.index.splice(s,1),0===n.index.length&&r.delete(e),0===r.size&&delete this.index.get(t.sheet)[t.col]}))}addRows(e,t,r){const n=this.getValueIndex(t.sheet,e,r);Fo.shiftRows(n,t.rowStart,t.numberOfRows)}removeRows(e,t,r){const n=this.getValueIndex(t.sheet,e,r);Fo.removeRowsFromValues(n,t),Fo.shiftRows(n,t.rowEnd+1,-t.numberOfRows)}static addValue(e,t){const r=Uo(t,e.index,"lowerBound");e.index[r]===t||e.index.splice(r+1,0,t)}static removeRowsFromValues(e,t){const r=Uo(t.rowStart,e.index,"upperBound"),n=Uo(t.rowEnd,e.index,"lowerBound");r>-1&&n>-1&&r<=n&&e.index[r]<=t.rowEnd&&e.index.splice(r,n-r+1)}static shiftRows(e,t,r){const n=Uo(t,e.index,"upperBound");if(-1!==n)for(let t=n;t<e.index.length;++t)e.index[t]+=r}}function Uo(e,t,r="upperBound"){let n=0,s=t.length-1;for(;n<=s;){const r=Math.floor((n+s)/2);if(e>t[r])n=r+1;else{if(!(e<t[r]))return r;s=r-1}}const o="lowerBound"===r?s:n;return o>=0&&o<=t.length?o:-1}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Vo{constructor(e){this.config=e;const t="."===this.config.thousandSeparator?`\\${this.config.thousandSeparator}`:this.config.thousandSeparator,r="."===this.config.decimalSeparator?`\\${this.config.decimalSeparator}`:this.config.decimalSeparator;this.numberPattern=new RegExp(`^([+-]?((${r}\\d+)|(\\d+(${t}\\d{3,})*(${r}\\d*)?)))(e[+-]?\\d+)?$`),this.allThousandSeparatorsRegex=new RegExp(`${t}`,"g")}numericStringToMaybeNumber(e){if(this.numberPattern.test(e)){const t=this.numericStringToNumber(e);if(isNaN(t))return;return t}}numericStringToNumber(e){const t=e.replace(this.allThousandSeparatorsRegex,"").replace(this.config.decimalSeparator,".");return Number(t)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Bo{constructor(e,t,r){this.dependencyGraph=e,this.unparser=t,this.exporter=r}getCellHyperlink(e){const t=this.dependencyGraph.getCell(e);if(t instanceof $t){const e=t.getFormula(this.dependencyGraph.lazilyTransformingAstService);if("HYPERLINK"===e.procedureName)return e.hyperlink}}getCellFormula(e,t){const r=this.dependencyGraph.getCell(e);if(r instanceof $t){const n=r.getFormula(this.dependencyGraph.lazilyTransformingAstService);return t=null!=t?t:e,this.unparser.unparse(n,t)}if(r instanceof zt){const n=r.getAddress(this.dependencyGraph.lazilyTransformingAstService);if(n.row!==e.row||n.col!==e.col||n.sheet!==e.sheet)return;t=null!=t?t:e;const s=r.getFormula(this.dependencyGraph.lazilyTransformingAstService);if(void 0!==s)return this.unparser.unparse(s,t)}else if(r instanceof pr)return r.getFormula()}getCellSerialized(e,t){var r;return null!==(r=this.getCellFormula(e,t))&&void 0!==r?r:this.getRawValue(e)}getCellValue(e){return this.exporter.exportValue(this.dependencyGraph.getScalarValue(e))}getRawValue(e){return this.dependencyGraph.getRawValue(e)}getSheetValues(e){return this.genericSheetGetter(e,(e=>this.getCellValue(e)))}getSheetFormulas(e){return this.genericSheetGetter(e,(e=>this.getCellFormula(e)))}genericSheetGetter(e,t){const r=this.dependencyGraph.getSheetHeight(e),n=this.dependencyGraph.getSheetWidth(e),s=new Array(r);for(let o=0;o<r;o++){s[o]=new Array(n);for(let r=0;r<n;r++){const n=br(e,r,o);s[o][r]=t(n)}for(let e=n-1;e>=0&&(null===s[o][e]||void 0===s[o][e]);e--)s[o].pop()}for(let e=r-1;e>=0&&0===s[e].length;e--)s.pop();return s}genericAllSheetsGetter(e){const t={};for(const r of this.dependencyGraph.sheetMapping.displayNames()){const n=this.dependencyGraph.sheetMapping.fetch(r);t[r]=e(n)}return t}getSheetSerialized(e){return this.genericSheetGetter(e,(e=>this.getCellSerialized(e)))}getAllSheetsValues(){return this.genericAllSheetsGetter((e=>this.getSheetValues(e)))}getAllSheetsFormulas(){return this.genericAllSheetsGetter((e=>this.getSheetFormulas(e)))}getAllSheetsSerialized(){return this.genericAllSheetsGetter((e=>this.getSheetSerialized(e)))}getAllNamedExpressionsSerialized(){const e=[];let t=0;for(const r of this.dependencyGraph.sheetMapping.displayNames()){const n=this.dependencyGraph.sheetMapping.fetch(r);e[n]=t,t++}return this.dependencyGraph.namedExpressions.getAllNamedExpressions().map((t=>({name:t.expression.displayName,expression:this.getCellSerialized(t.expression.address),scope:void 0!==t.scope?e[t.scope]:void 0,options:t.expression.options})))}withNewConfig(e,t){const r=new xe(e,be(e),this.dependencyGraph.sheetMapping.fetchDisplayName,t);return new Bo(this.dependencyGraph,r,this.exporter)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Wo{static buildFromSheets(e,t={},r=[]){const n=new Xo(t);return this.buildEngine(n,e,r)}static buildFromSheet(e,t={},r=[]){const n=new Xo(t),s=n.translationPackage.getUITranslation(sr.NEW_SHEET_PREFIX)+"1";return this.buildEngine(n,{[s]:e},r)}static buildEmpty(e={},t=[]){return this.buildEngine(new Xo(e),{},t)}static rebuildWithConfig(e,t,r,n){return this.buildEngine(e,t,r,n)}static buildEngine(e,t={},r=[],n=(e.useStats?new it:new at)){n.start(et.BUILD_ENGINE_TOTAL);const s=new Cs,o=new vo(e),i=new xo(n),a=ur.buildEmpty(i,e,o,s,n),l=
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function(e,t,r){return t.useColumnIndex?new Fo(e,t,r):new Ho(e)}(a,e,n),h=a.sheetMapping,u=a.addressMapping;for(const r in t)if(Object.prototype.hasOwnProperty.call(t,r)){const n=t[r];Os(n);const s=xs(n);if(s.height>e.maxRows||s.width>e.maxColumns)throw new ct;const o=h.addSheet(r);u.autoAddSheet(o,s)}const c=new Le(e,o,h.get);i.parser=c;const d=new xe(e,be(e),h.fetchDisplayName,s),p=new Hn(e),g=new Vo(e),f=new Yr(e,p,g),m=new gs(e,p,g),E=new dn(e,o),y=new Hs(e,a,l,m,c,n,i,s,E),w=new lo(e,y);i.undoRedo=w;const C=new ms(e,a,y),R=new ho(e,y,w,C,a,l,c,m,i,s);r.forEach((e=>{R.ensureItIsPossibleToAddNamedExpression(e.name,e.expression,e.scope),R.operations.addNamedExpression(e.name,e.expression,e.scope,e.options)}));const v=new mo(e,s,h.fetchDisplayName,i),S=new Bo(a,d,v),T=new Ao(e,a,l,n,f,o,s,S,E,p);n.measure(et.GRAPH_BUILD,(()=>{new Eo(a,l,c,m,n,E).buildGraph(t,n)}));const N=new po(e,n,T,i,a,l);return N.run(),n.end(et.BUILD_ENGINE_TOTAL),{config:e,stats:n,dependencyGraph:a,columnSearch:l,parser:c,unparser:d,cellContentParser:m,evaluator:N,lazilyTransformingAstService:i,crudOperations:R,exporter:v,namedExpressions:s,serialization:S,functionRegistry:o}}}function Yo(e){return()=>{throw new Error(`The "${e}" method cannot be called because this HyperFormula instance has been destroyed`)}}var jo,Go=r(23420);!function(e){e.SheetAdded="sheetAdded",e.SheetRemoved="sheetRemoved",e.SheetRenamed="sheetRenamed",e.NamedExpressionAdded="namedExpressionAdded",e.NamedExpressionRemoved="namedExpressionRemoved",e.ValuesUpdated="valuesUpdated",e.EvaluationSuspended="evaluationSuspended",e.EvaluationResumed="evaluationResumed"}(jo||(jo={}));class zo extends Go.TinyEmitter{emit(e,...t){return super.emit(e,...t),this}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class $o{constructor(e,t,r,n,s,o,i,a,l,h,u,c,d,p){this._config=e,this._stats=t,this._dependencyGraph=r,this._columnSearch=n,this._parser=s,this._unparser=o,this._cellContentParser=i,this._evaluator=a,this._lazilyTransformingAstService=l,this._crudOperations=h,this._exporter=u,this._namedExpressions=c,this._serialization=d,this._functionRegistry=p,this._emitter=new zo,this._evaluationSuspended=!1}static get defaultConfig(){return qo({})}get graph(){return this.dependencyGraph.graph}get rangeMapping(){return this.dependencyGraph.rangeMapping}get arrayMapping(){return this.dependencyGraph.arrayMapping}get sheetMapping(){return this.dependencyGraph.sheetMapping}get addressMapping(){return this.dependencyGraph.addressMapping}get dependencyGraph(){return this._dependencyGraph}get evaluator(){return this._evaluator}get columnSearch(){return this._columnSearch}get lazilyTransformingAstService(){return this._lazilyTransformingAstService}get licenseKeyValidityState(){return this._config.licenseKeyValidityState}static buildFromArray(e,t={},r=[]){return this.buildFromEngineState(Wo.buildFromSheet(e,t,r))}static buildFromSheets(e,t={},r=[]){return this.buildFromEngineState(Wo.buildFromSheets(e,t,r))}static buildEmpty(e={},t=[]){return this.buildFromEngineState(Wo.buildEmpty(e,t))}static getLanguage(e){yn(e,"string","languageCode");const t=this.registeredLanguages.get(e);if(void 0===t)throw new xt;return t}static registerLanguage(e,t){if(yn(e,"string","languageCode"),this.registeredLanguages.has(e))throw new Pt;var r;this.registeredLanguages.set(e,(r=t,new nr(Object.assign({},r.functions),Object.assign({},r.errors),Object.assign({},r.ui))))}static unregisterLanguage(e){if(yn(e,"string","languageCode"),!this.registeredLanguages.has(e))throw new xt;this.registeredLanguages.delete(e)}static getRegisteredLanguagesCodes(){return Array.from(this.registeredLanguages.keys())}static registerFunctionPlugin(e,t){vo.registerFunctionPlugin(e,t)}static unregisterFunctionPlugin(e){vo.unregisterFunctionPlugin(e)}static registerFunction(e,t,r){yn(e,"string","functionId"),vo.registerFunction(e,t,r)}static unregisterFunction(e){yn(e,"string","functionId"),vo.unregisterFunction(e)}static unregisterAllFunctions(){vo.unregisterAll()}static getRegisteredFunctionNames(e){yn(e,"string","code");const t=vo.getRegisteredFunctionIds();return this.getLanguage(e).getFunctionTranslations(t)}static getFunctionPlugin(e){return yn(e,"string","functionId"),vo.getFunctionPlugin(e)}static getAllFunctionPlugins(){return vo.getPlugins()}static buildFromEngineState(e){return new $o(e.config,e.stats,e.dependencyGraph,e.columnSearch,e.parser,e.unparser,e.cellContentParser,e.evaluator,e.lazilyTransformingAstService,e.crudOperations,e.exporter,e.namedExpressions,e.serialization,e.functionRegistry)}getCellValue(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");return this.ensureEvaluationIsNotSuspended(),this._serialization.getCellValue(e)}getCellFormula(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");return this._serialization.getCellFormula(e)}getCellHyperlink(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");return this.ensureEvaluationIsNotSuspended(),this._serialization.getCellHyperlink(e)}getCellSerialized(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");return this.ensureEvaluationIsNotSuspended(),this._serialization.getCellSerialized(e)}getSheetValues(e){return yn(e,"number","sheetId"),this.ensureEvaluationIsNotSuspended(),this._serialization.getSheetValues(e)}getSheetFormulas(e){return yn(e,"number","sheetId"),this._serialization.getSheetFormulas(e)}getSheetSerialized(e){return yn(e,"number","sheetId"),this.ensureEvaluationIsNotSuspended(),this._serialization.getSheetSerialized(e)}getAllSheetsDimensions(){return this._serialization.genericAllSheetsGetter((e=>this.getSheetDimensions(e)))}getSheetDimensions(e){return yn(e,"number","sheetId"),{width:this.dependencyGraph.getSheetWidth(e),height:this.dependencyGraph.getSheetHeight(e)}}getAllSheetsValues(){return this.ensureEvaluationIsNotSuspended(),this._serialization.getAllSheetsValues()}getAllSheetsFormulas(){return this._serialization.getAllSheetsFormulas()}getAllSheetsSerialized(){return this.ensureEvaluationIsNotSuspended(),this._serialization.getAllSheetsSerialized()}updateConfig(e){Object.entries(e).every((([e,t])=>this._config[e]===t))||this.rebuildWithConfig(e)}getConfig(){return this._config.getConfig()}rebuildAndRecalculate(){this.rebuildWithConfig({})}getStats(){return this._stats.snapshot()}undo(){return this._crudOperations.undo(),this.recomputeIfDependencyGraphNeedsIt()}redo(){return this._crudOperations.redo(),this.recomputeIfDependencyGraphNeedsIt()}isThereSomethingToUndo(){return this._crudOperations.isThereSomethingToUndo()}isThereSomethingToRedo(){return this._crudOperations.isThereSomethingToRedo()}isItPossibleToSetCellContents(e){let t;if(Pr(e))t=new Fr(e,e);else{if(!kr(e))throw new Tt("SimpleCellAddress | SimpleCellRange","address");t=new Fr(e.start,e.end)}try{this._crudOperations.ensureRangeInSizeLimits(t);for(const e of t.addresses(this._dependencyGraph))this._crudOperations.ensureItIsPossibleToChangeContent(e)}catch(e){return!1}return!0}setCellContents(e,t){return this._crudOperations.setCellContents(e,t),this.recomputeIfDependencyGraphNeedsIt()}swapRowIndexes(e,t){return yn(e,"number","sheetId"),this._crudOperations.setRowOrder(e,t),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToSwapRowIndexes(e,t){yn(e,"number","sheetId");try{return this._crudOperations.validateSwapRowIndexes(e,t),this._crudOperations.testRowOrderForArrays(e,t),!0}catch(e){return!1}}setRowOrder(e,t){yn(e,"number","sheetId");const r=this._crudOperations.mappingFromOrder(e,t,"row");return this.swapRowIndexes(e,r)}isItPossibleToSetRowOrder(e,t){yn(e,"number","sheetId");try{const r=this._crudOperations.mappingFromOrder(e,t,"row");return this._crudOperations.validateSwapRowIndexes(e,r),this._crudOperations.testRowOrderForArrays(e,r),!0}catch(e){return!1}}swapColumnIndexes(e,t){return yn(e,"number","sheetId"),this._crudOperations.setColumnOrder(e,t),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToSwapColumnIndexes(e,t){yn(e,"number","sheetId");try{return this._crudOperations.validateSwapColumnIndexes(e,t),this._crudOperations.testColumnOrderForArrays(e,t),!0}catch(e){return!1}}setColumnOrder(e,t){yn(e,"number","sheetId");const r=this._crudOperations.mappingFromOrder(e,t,"column");return this.swapColumnIndexes(e,r)}isItPossibleToSetColumnOrder(e,t){yn(e,"number","sheetId");try{const r=this._crudOperations.mappingFromOrder(e,t,"column");return this._crudOperations.validateSwapColumnIndexes(e,r),this._crudOperations.testColumnOrderForArrays(e,r),!0}catch(e){return!1}}isItPossibleToAddRows(e,...t){yn(e,"number","sheetId");const r=Us(t);try{return this._crudOperations.ensureItIsPossibleToAddRows(e,...r),!0}catch(e){return!1}}addRows(e,...t){return yn(e,"number","sheetId"),this._crudOperations.addRows(e,...t),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToRemoveRows(e,...t){yn(e,"number","sheetId");const r=Fs(t);try{return this._crudOperations.ensureItIsPossibleToRemoveRows(e,...r),!0}catch(e){return!1}}removeRows(e,...t){return yn(e,"number","sheetId"),this._crudOperations.removeRows(e,...t),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToAddColumns(e,...t){yn(e,"number","sheetId");const r=Us(t);try{return this._crudOperations.ensureItIsPossibleToAddColumns(e,...r),!0}catch(e){return!1}}addColumns(e,...t){return yn(e,"number","sheetId"),this._crudOperations.addColumns(e,...t),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToRemoveColumns(e,...t){yn(e,"number","sheetId");const r=Fs(t);try{return this._crudOperations.ensureItIsPossibleToRemoveColumns(e,...r),!0}catch(e){return!1}}removeColumns(e,...t){return yn(e,"number","sheetId"),this._crudOperations.removeColumns(e,...t),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToMoveCells(e,t){if(!Pr(t))throw new Tt("SimpleCellAddress","destinationLeftCorner");if(!kr(e))throw new Tt("SimpleCellRange","source");try{const r=new Fr(e.start,e.end);return this._crudOperations.operations.ensureItIsPossibleToMoveCells(r.start,r.width(),r.height(),t),!0}catch(e){return!1}}moveCells(e,t){if(!Pr(t))throw new Tt("SimpleCellAddress","destinationLeftCorner");if(!kr(e))throw new Tt("SimpleCellRange","source");const r=new Fr(e.start,e.end);return this._crudOperations.moveCells(r.start,r.width(),r.height(),t),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToMoveRows(e,t,r,n){yn(e,"number","sheetId"),yn(t,"number","startRow"),yn(r,"number","numberOfRows"),yn(n,"number","targetRow");try{return this._crudOperations.ensureItIsPossibleToMoveRows(e,t,r,n),!0}catch(e){return!1}}moveRows(e,t,r,n){return yn(e,"number","sheetId"),yn(t,"number","startRow"),yn(r,"number","numberOfRows"),yn(n,"number","targetRow"),this._crudOperations.moveRows(e,t,r,n),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToMoveColumns(e,t,r,n){yn(e,"number","sheetId"),yn(t,"number","startColumn"),yn(r,"number","numberOfColumns"),yn(n,"number","targetColumn");try{return this._crudOperations.ensureItIsPossibleToMoveColumns(e,t,r,n),!0}catch(e){return!1}}moveColumns(e,t,r,n){return yn(e,"number","sheetId"),yn(t,"number","startColumn"),yn(r,"number","numberOfColumns"),yn(n,"number","targetColumn"),this._crudOperations.moveColumns(e,t,r,n),this.recomputeIfDependencyGraphNeedsIt()}copy(e){if(!kr(e))throw new Tt("SimpleCellRange","source");const t=new Fr(e.start,e.end);return this._crudOperations.copy(t.start,t.width(),t.height()),this.getRangeValues(e)}cut(e){if(!kr(e))throw new Tt("SimpleCellRange","source");const t=new Fr(e.start,e.end);return this._crudOperations.cut(t.start,t.width(),t.height()),this.getRangeValues(e)}paste(e){if(!Pr(e))throw new Tt("SimpleCellAddress","targetLeftCorner");return this.ensureEvaluationIsNotSuspended(),this._crudOperations.paste(e),this.recomputeIfDependencyGraphNeedsIt()}isClipboardEmpty(){return this._crudOperations.isClipboardEmpty()}clearClipboard(){this._crudOperations.clearClipboard()}clearRedoStack(){this._crudOperations.undoRedo.clearRedoStack()}clearUndoStack(){this._crudOperations.undoRedo.clearUndoStack()}getRangeValues(e){if(!kr(e))throw new Tt("SimpleCellRange","source");return new Fr(e.start,e.end).arrayOfAddressesInRange().map((e=>e.map((e=>this.getCellValue(e)))))}getRangeFormulas(e){if(!kr(e))throw new Tt("SimpleCellRange","source");return new Fr(e.start,e.end).arrayOfAddressesInRange().map((e=>e.map((e=>this.getCellFormula(e)))))}getRangeSerialized(e){if(!kr(e))throw new Tt("SimpleCellRange","source");return new Fr(e.start,e.end).arrayOfAddressesInRange().map((e=>e.map((e=>this.getCellSerialized(e)))))}getFillRangeData(e,t,r=!1){if(!kr(e))throw new Tt("SimpleCellRange","source");if(!kr(t))throw new Tt("SimpleCellRange","target");const n=new Fr(e.start,e.end),s=new Fr(t.start,t.end);return this.ensureEvaluationIsNotSuspended(),s.arrayOfAddressesInRange().map((s=>s.map((s=>{const o=((s.row-(r?t:e).start.row)%n.height()+n.height())%n.height()+e.start.row,i=((s.col-(r?t:e).start.col)%n.width()+n.width())%n.width()+e.start.col;return this._serialization.getCellSerialized({row:o,col:i,sheet:n.sheet},s)}))))}isItPossibleToAddSheet(e){yn(e,"string","sheetName");try{return this._crudOperations.ensureItIsPossibleToAddSheet(e),!0}catch(e){return!1}}addSheet(e){void 0!==e&&yn(e,"string","sheetName");const t=this._crudOperations.addSheet(e);return this._emitter.emit(jo.SheetAdded,t),t}isItPossibleToRemoveSheet(e){yn(e,"number","sheetId");try{return this._crudOperations.ensureScopeIdIsValid(e),!0}catch(e){return!1}}removeSheet(e){yn(e,"number","sheetId");const t=this.sheetMapping.getDisplayName(e);this._crudOperations.removeSheet(e);const r=this.recomputeIfDependencyGraphNeedsIt();return this._emitter.emit(jo.SheetRemoved,t,r),r}isItPossibleToClearSheet(e){yn(e,"number","sheetId");try{return this._crudOperations.ensureScopeIdIsValid(e),!0}catch(e){return!1}}clearSheet(e){return yn(e,"number","sheetId"),this._crudOperations.clearSheet(e),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToReplaceSheetContent(e,t){yn(e,"number","sheetId");try{return this._crudOperations.ensureScopeIdIsValid(e),this._crudOperations.ensureItIsPossibleToChangeSheetContents(e,t),!0}catch(e){return!1}}setSheetContent(e,t){return yn(e,"number","sheetId"),this._crudOperations.setSheetContent(e,t),this.recomputeIfDependencyGraphNeedsIt()}simpleCellAddressFromString(e,t){return yn(e,"string","cellAddress"),yn(t,"number","sheetId"),I(this.sheetMapping.get,e,t)}simpleCellRangeFromString(e,t){return yn(e,"string","cellRange"),yn(t,"number","sheetId"),((e,t,r)=>{const n=t.split(h);if(2!==n.length)return;const[s,o]=n,i=I(e,s,r);if(void 0===i)return;const a=I(e,o,i.sheet);return void 0!==a&&i.sheet===a.sheet?Hr(i,a):void 0})(this.sheetMapping.get,e,t)}simpleCellAddressToString(e,t){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");return yn(t,"number","sheetId"),O(this.sheetMapping.fetchDisplayName,e,t)}simpleCellRangeToString(e,t){if(!kr(e))throw new Tt("SimpleCellRange","cellRange");return yn(t,"number","sheetId"),((e,t,r)=>{const n=O(e,t.start,r),s=O(e,t.end,t.start.sheet);return void 0===n||void 0===s?void 0:`${n}${h}${s}`})(this.sheetMapping.fetchDisplayName,e,t)}getCellDependents(e){let t;if(Pr(e))t=this._dependencyGraph.addressMapping.getCell(e);else{if(!kr(e))throw new Tt("SimpleCellAddress | SimpleCellRange",e);t=this._dependencyGraph.rangeMapping.getRange(e.start,e.end)}return void 0===t?[]:this._dependencyGraph.getAdjacentNodesAddresses(t)}getCellPrecedents(e){let t;if(Pr(e))t=this._dependencyGraph.addressMapping.getCell(e);else{if(!kr(e))throw new Tt("SimpleCellAddress | SimpleCellRange",e);t=this._dependencyGraph.rangeMapping.getRange(e.start,e.end)}return void 0===t?[]:this._dependencyGraph.dependencyQueryAddresses(t)}getSheetName(e){return yn(e,"number","sheetId"),this.sheetMapping.getDisplayName(e)}getSheetNames(){return this.sheetMapping.sheetNames()}getSheetId(e){return yn(e,"string","sheetName"),this.sheetMapping.get(e)}doesSheetExist(e){return yn(e,"string","sheetName"),this.sheetMapping.hasSheetWithName(e)}getCellType(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");return((e,t)=>e instanceof zt?e.isLeftCorner(t)?ir.ARRAYFORMULA:ir.ARRAY:e instanceof $t||e instanceof pr?ir.FORMULA:e instanceof dr?ir.VALUE:ir.EMPTY)(this.dependencyGraph.getCell(e),e)}doesCellHaveSimpleValue(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");return this.getCellType(e)===ir.VALUE}doesCellHaveFormula(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");const t=this.getCellType(e);return t===ir.FORMULA||t===ir.ARRAYFORMULA}isCellEmpty(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");return this.getCellType(e)===ir.EMPTY}isCellPartOfArray(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");const t=this.getCellType(e);return t===ir.ARRAY||t===ir.ARRAYFORMULA}getCellValueType(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");this.ensureEvaluationIsNotSuspended();const t=this.dependencyGraph.getCellValue(e);return Rr(t)}getCellValueDetailedType(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");this.ensureEvaluationIsNotSuspended();const t=this.dependencyGraph.getCellValue(e);return vr(t)}getCellValueFormat(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");this.ensureEvaluationIsNotSuspended();const t=this.dependencyGraph.getCellValue(e);return Sr(t)}countSheets(){return this.sheetMapping.numberOfSheets()}isItPossibleToRenameSheet(e,t){yn(e,"number","sheetId"),yn(t,"string","newName");try{return this._crudOperations.ensureItIsPossibleToRenameSheet(e,t),!0}catch(e){return!1}}renameSheet(e,t){yn(e,"number","sheetId"),yn(t,"string","newName");const r=this._crudOperations.renameSheet(e,t);void 0!==r&&this._emitter.emit(jo.SheetRenamed,r,t)}batch(e){this.suspendEvaluation(),this._crudOperations.beginUndoRedoBatchMode();try{e()}catch(e){throw this._crudOperations.commitUndoRedoBatchMode(),this.resumeEvaluation(),e}return this._crudOperations.commitUndoRedoBatchMode(),this.resumeEvaluation()}suspendEvaluation(){this._evaluationSuspended=!0,this._emitter.emit(jo.EvaluationSuspended)}resumeEvaluation(){this._evaluationSuspended=!1;const e=this.recomputeIfDependencyGraphNeedsIt();return this._emitter.emit(jo.EvaluationResumed,e),e}isEvaluationSuspended(){return this._evaluationSuspended}isItPossibleToAddNamedExpression(e,t,r){yn(e,"string","expressionName"),void 0!==r&&yn(r,"number","scope");try{return this._crudOperations.ensureItIsPossibleToAddNamedExpression(e,t,r),!0}catch(e){return!1}}addNamedExpression(e,t,r,n){yn(e,"string","expressionName"),void 0!==r&&yn(r,"number","scope"),this._crudOperations.addNamedExpression(e,t,r,n);const s=this.recomputeIfDependencyGraphNeedsIt();return this._emitter.emit(jo.NamedExpressionAdded,e,s),s}getNamedExpressionValue(e,t){yn(e,"string","expressionName"),void 0!==t&&yn(t,"number","scope"),this.ensureEvaluationIsNotSuspended(),this._crudOperations.ensureScopeIdIsValid(t);const r=this._namedExpressions.namedExpressionForScope(e,t);return r?this._serialization.getCellValue(r.address):void 0}getNamedExpressionFormula(e,t){yn(e,"string","expressionName"),void 0!==t&&yn(t,"number","scope"),this._crudOperations.ensureScopeIdIsValid(t);const r=this._namedExpressions.namedExpressionForScope(e,t);return void 0===r?void 0:this._serialization.getCellFormula(r.address)}getNamedExpression(e,t){yn(e,"string","expressionName"),void 0!==t&&yn(t,"number","scope");const r=this._namedExpressions.namedExpressionForScope(e,t);if(void 0===r)return;return{name:e,scope:t,expression:this._serialization.getCellFormula(r.address),options:r.options}}isItPossibleToChangeNamedExpression(e,t,r){yn(e,"string","expressionName"),void 0!==r&&yn(r,"number","scope");try{return this._crudOperations.ensureItIsPossibleToChangeNamedExpression(e,t,r),!0}catch(e){return!1}}changeNamedExpression(e,t,r,n){return yn(e,"string","expressionName"),void 0!==r&&yn(r,"number","scope"),this._crudOperations.changeNamedExpressionExpression(e,r,t,n),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToRemoveNamedExpression(e,t){yn(e,"string","expressionName"),void 0!==t&&yn(t,"number","scope");try{return this._crudOperations.isItPossibleToRemoveNamedExpression(e,t),!0}catch(e){return!1}}removeNamedExpression(e,t){yn(e,"string","expressionName"),void 0!==t&&yn(t,"number","scope");const r=this._crudOperations.removeNamedExpression(e,t);if(r){const e=this.recomputeIfDependencyGraphNeedsIt();return this._emitter.emit(jo.NamedExpressionRemoved,r.displayName,e),e}return[]}listNamedExpressions(e){return void 0!==e&&yn(e,"number","scope"),this._crudOperations.ensureScopeIdIsValid(e),this._namedExpressions.getAllNamedExpressionsNamesInScope(e)}getAllNamedExpressionsSerialized(){return this._serialization.getAllNamedExpressionsSerialized()}normalizeFormula(e){yn(e,"string","formulaString");const{ast:t,address:r}=this.extractTemporaryFormula(e);if(void 0===t)throw new dt;return this._unparser.unparse(t,r)}calculateFormula(e,t){yn(e,"string","formulaString"),yn(t,"number","sheetId"),this._crudOperations.ensureScopeIdIsValid(t);const{ast:r,address:n,dependencies:s}=this.extractTemporaryFormula(e,t);if(void 0===r)throw new dt;const o=this.evaluator.runAndForget(r,n,s);return this._exporter.exportScalarOrRange(o)}validateFormula(e){yn(e,"string","formulaString");const{ast:t}=this.extractTemporaryFormula(e);return void 0!==t&&!(t.type===U.ERROR&&!t.error)}getRegisteredFunctionNames(){return $o.getLanguage(this._config.language).getFunctionTranslations(this._functionRegistry.getRegisteredFunctionIds())}getFunctionPlugin(e){return yn(e,"string","functionId"),this._functionRegistry.getFunctionPlugin(e)}getAllFunctionPlugins(){return this._functionRegistry.getPlugins()}numberToDateTime(e){return yn(e,"number","val"),this._evaluator.interpreter.dateTimeHelper.numberToSimpleDateTime(e)}numberToDate(e){return yn(e,"number","val"),this._evaluator.interpreter.dateTimeHelper.numberToSimpleDate(e)}numberToTime(e){return yn(e,"number","val"),Vn(e)}on(e,t){this._emitter.on(e,t)}once(e,t){this._emitter.once(e,t)}off(e,t){this._emitter.off(e,t)}destroy(){!
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function(e){for(const[t,r]of Object.entries(e))r instanceof Function?e[t]=Yo(r):delete e[t]}(this)}ensureEvaluationIsNotSuspended(){if(this._evaluationSuspended)throw new bt}extractTemporaryFormula(e,t=1){const r=this._cellContentParser.parse(e),n={sheet:t,col:0,row:0};if(!(r instanceof cs.Formula))return{address:n,dependencies:[]};const{ast:s,errors:o,dependencies:i}=this._parser.parse(r.formula,n);return o.length>0?{address:n,dependencies:[]}:{ast:s,address:n,dependencies:i}}rebuildWithConfig(e){const t=this._config.mergeConfig(e),r=this._config.mergeConfig({language:e.language}),n=this._serialization.withNewConfig(r,this._namedExpressions).getAllSheetsSerialized(),s=this._serialization.getAllNamedExpressionsSerialized(),o=Wo.rebuildWithConfig(t,n,s,this._stats);this._config=o.config,this._stats=o.stats,this._dependencyGraph=o.dependencyGraph,this._columnSearch=o.columnSearch,this._parser=o.parser,this._unparser=o.unparser,this._cellContentParser=o.cellContentParser,this._evaluator=o.evaluator,this._lazilyTransformingAstService=o.lazilyTransformingAstService,this._crudOperations=o.crudOperations,this._exporter=o.exporter,this._namedExpressions=o.namedExpressions,this._serialization=o.serialization,this._functionRegistry=o.functionRegistry}recomputeIfDependencyGraphNeedsIt(){if(this._evaluationSuspended)return[];{const e=this._crudOperations.getAndClearContentChanges(),t=this.dependencyGraph.verticesToRecompute();this.dependencyGraph.clearDirtyVertices(),t.length>0&&e.addAll(this.evaluator.partialRun(t));const r=e.exportChanges(this._exporter);return e.isEmpty()||this._emitter.emit(jo.ValuesUpdated,r),r}}}$o.version="2.6.2",$o.buildDate="15/02/2024 12:03:19",$o.releaseDate="15/02/2024",$o.languages={},$o.registeredLanguages=new Map;
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const Ko=new WeakMap;class Xo{constructor(e={},t=!0){const{accentSensitive:r,binarySearchThreshold:n,caseSensitive:s,caseFirst:o,chooseAddressMappingPolicy:i,currencySymbol:a,dateFormats:l,decimalSeparator:h,evaluateNullToZero:u,functionArgSeparator:c,functionPlugins:d,ignorePunctuation:p,leapYear1900:g,localeLang:f,language:m,ignoreWhiteSpace:E,licenseKey:y,matchWholeCell:w,arrayColumnSeparator:C,arrayRowSeparator:R,maxRows:v,maxColumns:S,nullYear:T,nullDate:N,parseDateTime:_,precisionEpsilon:M,precisionRounding:A,stringifyDateTime:b,stringifyDuration:I,smartRounding:O,timeFormats:x,thousandSeparator:P,useArrayArithmetic:L,useStats:D,undoLimit:k,useColumnIndex:H,useRegularExpressions:F,useWildcards:U}=e;t&&Xo.warnDeprecatedOptions(e),this.useArrayArithmetic=gn(L,"boolean","useArrayArithmetic"),this.accentSensitive=gn(r,"boolean","accentSensitive"),this.caseSensitive=gn(s,"boolean","caseSensitive"),this.caseFirst=gn(o,["upper","lower","false"],"caseFirst"),this.ignorePunctuation=gn(p,"boolean","ignorePunctuation"),this.chooseAddressMappingPolicy=null!=i?i:Xo.defaultConfig.chooseAddressMappingPolicy,this.dateFormats=[...mn(l,Array.isArray,"array","dateFormats")],this.timeFormats=[...mn(x,Array.isArray,"array","timeFormats")],this.functionArgSeparator=gn(c,"string","functionArgSeparator"),this.decimalSeparator=gn(h,[".",","],"decimalSeparator"),this.language=gn(m,"string","language"),this.ignoreWhiteSpace=gn(E,["standard","any"],"ignoreWhiteSpace"),this.licenseKey=gn(y,"string","licenseKey"),this.thousandSeparator=gn(P,["",","," ","."],"thousandSeparator"),this.arrayColumnSeparator=gn(C,[",",";"],"arrayColumnSeparator"),this.arrayRowSeparator=gn(R,[";","|"],"arrayRowSeparator"),this.localeLang=gn(f,"string","localeLang"),this.functionPlugins=[...null!=d?d:Xo.defaultConfig.functionPlugins],this.smartRounding=gn(O,"boolean","smartRounding"),this.evaluateNullToZero=gn(u,"boolean","evaluateNullToZero"),this.nullYear=gn(T,"number","nullYear"),fn(this.nullYear,"nullYear",0),function(e,t,r){if(e>r)throw new Mt(t,r)}(this.nullYear,"nullYear",100),this.precisionRounding=gn(A,"number","precisionRounding"),fn(this.precisionRounding,"precisionRounding",0),this.precisionEpsilon=gn(M,"number","precisionEpsilon"),fn(this.precisionEpsilon,"precisionEpsilon",0),this.useColumnIndex=gn(H,"boolean","useColumnIndex"),this.useStats=gn(D,"boolean","useStats"),this.binarySearchThreshold=null!=n?n:Xo.defaultConfig.binarySearchThreshold,this.parseDateTime=gn(_,"function","parseDateTime"),this.stringifyDateTime=gn(b,"function","stringifyDateTime"),this.stringifyDuration=gn(I,"function","stringifyDuration"),this.translationPackage=$o.getLanguage(this.language),this.errorMapping=this.translationPackage.buildErrorMapping(),this.nullDate=mn(N,Ln,"IDate","nullDate"),this.leapYear1900=gn(g,"boolean","leapYear1900"),this.undoLimit=gn(k,"number","undoLimit"),this.useRegularExpressions=gn(F,"boolean","useRegularExpressions"),this.useWildcards=gn(U,"boolean","useWildcards"),this.matchWholeCell=gn(w,"boolean","matchWholeCell"),fn(this.undoLimit,"undoLimit",0),this.maxRows=gn(v,"number","maxRows"),fn(this.maxRows,"maxRows",1),this.maxColumns=gn(S,"number","maxColumns"),this.currencySymbol=this.setupCurrencySymbol(a),fn(this.maxColumns,"maxColumns",1),Ko.set(this,{licenseKeyValidityState:us(this.licenseKey)}),En({value:this.decimalSeparator,name:"decimalSeparator"},{value:this.functionArgSeparator,name:"functionArgSeparator"},{value:this.thousandSeparator,name:"thousandSeparator"}),En({value:this.arrayRowSeparator,name:"arrayRowSeparator"},{value:this.arrayColumnSeparator,name:"arrayColumnSeparator"})}setupCurrencySymbol(e){const t=[...mn(e,Array.isArray,"array","currencySymbol")];return t.forEach((e=>{if("string"!=typeof e)throw new Tt("string[]","currencySymbol");if(""===e)throw new Nt("currencySymbol")})),t}get licenseKeyValidityState(){return Ko.get(this).licenseKeyValidityState}getConfig(){return qo(this)}mergeConfig(e){const t=Object.assign({},this.getConfig(),e);return Xo.warnDeprecatedOptions(e),new Xo(t,!1)}static warnDeprecatedOptions(e){Xo.warnDeprecatedIfUsed(e.binarySearchThreshold,"binarySearchThreshold","1.1")}static warnDeprecatedIfUsed(e,t,r,n){void 0!==e&&(void 0===n?console.warn(`${t} option is deprecated since ${r}`):console.warn(`${t} option is deprecated since ${r}, please use ${n}`))}}function qo(e){var t;const r={};for(const n in Xo.defaultConfig){const s=null!==(t=e[n])&&void 0!==t?t:Xo.defaultConfig[n];Array.isArray(s)?r[n]=[...s]:r[n]=s}return r}Xo.defaultConfig={accentSensitive:!1,binarySearchThreshold:20,currencySymbol:["$"],caseSensitive:!1,caseFirst:"lower",chooseAddressMappingPolicy:new class{call(){return fr}},dateFormats:["DD/MM/YYYY","DD/MM/YY"],decimalSeparator:".",evaluateNullToZero:!1,functionArgSeparator:",",functionPlugins:[],ignorePunctuation:!1,language:"enGB",ignoreWhiteSpace:"standard",licenseKey:"",leapYear1900:!1,localeLang:"en",matchWholeCell:!0,arrayColumnSeparator:",",arrayRowSeparator:";",maxRows:4e4,maxColumns:18278,nullYear:30,nullDate:{year:1899,month:12,day:30},parseDateTime:function(e,t,r){if(void 0===t&&void 0===r)return;let n=e.replace(Rn," ").trim().toLowerCase();if(!function(e){return Cn.test(e)}(n))return;let s=n.substring(n.length-2);"am"===s||"pm"===s?n=n.substring(0,n.length-2).trim():(s=n.substring(n.length-1),"a"===s||"p"===s?n=n.substring(0,n.length-1).trim():s=void 0);const o=n.split(vn);o.length>=2&&o[o.length-2].includes(":")&&(o[o.length-2]=o[o.length-2]+"."+o[o.length-1],o.pop());const i=o[o.length-1].split(":");if(void 0!==s&&i.push(s),1===o.length)return _n(i,r);if(1===i.length)return Mn(o,t);const a=Mn(o.slice(0,o.length-1),t),l=_n(i,r);return void 0===a||void 0===l?void 0:Object.assign(Object.assign({},a),l)},precisionEpsilon:1e-13,precisionRounding:14,smartRounding:!0,stringifyDateTime:function(e,t){const r=Xn(t);if(void 0===r)return;const n=r.tokens;let s="",o=!1;const i=n.some((e=>e.type===Gn.FORMAT&&("a/p"===e.value||"A/P"===e.value||"am/pm"===e.value||"AM/PM"===e.value)));for(let t=0;t<n.length;t++){const r=n[t];if(r.type!==Gn.FREE_TEXT)switch(r.value.toLowerCase()){case"h":case"hh":o=!0,s+=Jn(i?(e.hours+11)%12+1:e.hours,r.value.length);break;case"d":case"dd":s+=Jn(e.day,r.value.length);break;case"s":case"ss":s+=Jn(Math.floor(e.seconds),r.value.length);break;case"m":case"mm":t+1<n.length&&n[t+1].value.startsWith(":")&&(o=!0),s+=Jn(o?e.minutes:e.month,r.value.length),o=!0;break;case"yy":s+=Jn(e.year%100,r.value.length);break;case"yyyy":s+=e.year;break;case"am/pm":case"a/p":{const[t,n]=r.value.split("/");s+=e.hours<12?t:n;break}default:if(wn.test(r.value)){const t=r.value.length-3;s+=`${e.seconds<10?"0":""}${Math.floor(e.seconds*Math.pow(10,t))/Math.pow(10,t)}`;continue}return}else s+=r.value}return s},stringifyDuration:function(e,t){const r=Xn(t);if(void 0===r)return;const n=r.tokens;let s="";for(const t of n)if(t.type!==Gn.FREE_TEXT)switch(t.value.toLowerCase()){case"h":case"hh":s+=Jn(e.hours,t.value.length),e.hours=0;break;case"[hh]":s+=Jn(e.hours,t.value.length-2),e.hours=0;break;case"m":case"mm":s+=Jn(e.minutes,t.value.length),e.minutes=0;break;case"[mm]":s+=Jn(e.minutes+60*e.hours,t.value.length-2),e.minutes=0,e.hours=0;break;case"s":case"ss":s+=Jn(Math.floor(e.seconds),t.value.length);break;default:if(wn.test(t.value)){const r=Math.max(t.value.length-3,0);s+=`${e.seconds<10?"0":""}${Math.floor(e.seconds*Math.pow(10,r))/Math.pow(10,r)}`;continue}return}else s+=t.value;return s},timeFormats:["hh:mm","hh:mm:ss.sss"],thousandSeparator:"",undoLimit:20,useRegularExpressions:!1,useWildcards:!0,useColumnIndex:!1,useStats:!1,useArrayArithmetic:!1};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const Qo={errors:{CYCLE:"#CYCLE!",DIV_BY_ZERO:"#DIV/0!",ERROR:"#ERROR!",NA:"#N/A",NAME:"#NAME?",NUM:"#NUM!",REF:"#REF!",SPILL:"#SPILL!",VALUE:"#VALUE!"},functions:{FILTER:"FILTER",ADDRESS:"ADDRESS",ARRAY_CONSTRAIN:"ARRAY_CONSTRAIN",ARRAYFORMULA:"ARRAYFORMULA",ABS:"ABS",ACOS:"ACOS",ACOSH:"ACOSH",ACOT:"ACOT",ACOTH:"ACOTH",AND:"AND",ARABIC:"ARABIC",ASIN:"ASIN",ASINH:"ASINH",ATAN2:"ATAN2",ATAN:"ATAN",ATANH:"ATANH",AVERAGE:"AVERAGE",AVERAGEA:"AVERAGEA",AVERAGEIF:"AVERAGEIF",BASE:"BASE",BIN2DEC:"BIN2DEC",BIN2HEX:"BIN2HEX",BIN2OCT:"BIN2OCT",BITAND:"BITAND",BITLSHIFT:"BITLSHIFT",BITOR:"BITOR",BITRSHIFT:"BITRSHIFT",BITXOR:"BITXOR",CEILING:"CEILING",CHAR:"CHAR",CHOOSE:"CHOOSE",CLEAN:"CLEAN",CODE:"CODE",COLUMN:"COLUMN",COLUMNS:"COLUMNS",CONCATENATE:"CONCATENATE",CORREL:"CORREL",COS:"COS",COSH:"COSH",COT:"COT",COTH:"COTH",COUNT:"COUNT",COUNTA:"COUNTA",COUNTBLANK:"COUNTBLANK",COUNTIF:"COUNTIF",COUNTIFS:"COUNTIFS",COUNTUNIQUE:"COUNTUNIQUE",CSC:"CSC",CSCH:"CSCH",CUMIPMT:"CUMIPMT",CUMPRINC:"CUMPRINC",DATE:"DATE",DATEDIF:"DATEDIF",DATEVALUE:"DATEVALUE",DAY:"DAY",DAYS360:"DAYS360",DAYS:"DAYS",DB:"DB",DDB:"DDB",DEC2BIN:"DEC2BIN",DEC2HEX:"DEC2HEX",DEC2OCT:"DEC2OCT",DECIMAL:"DECIMAL",DEGREES:"DEGREES",DELTA:"DELTA",DOLLARDE:"DOLLARDE",DOLLARFR:"DOLLARFR",EDATE:"EDATE",EFFECT:"EFFECT",EOMONTH:"EOMONTH",ERF:"ERF",ERFC:"ERFC",EVEN:"EVEN",EXACT:"EXACT",EXP:"EXP",FALSE:"FALSE",FIND:"FIND",FORMULATEXT:"FORMULATEXT",FV:"FV",FVSCHEDULE:"FVSCHEDULE",HEX2BIN:"HEX2BIN",HEX2DEC:"HEX2DEC",HEX2OCT:"HEX2OCT",HLOOKUP:"HLOOKUP",HOUR:"HOUR",HYPERLINK:"HYPERLINK",IF:"IF",IFERROR:"IFERROR",IFNA:"IFNA",IFS:"IFS",INDEX:"INDEX",INT:"INT",INTERVAL:"INTERVAL",IPMT:"IPMT",ISBINARY:"ISBINARY",ISBLANK:"ISBLANK",ISERR:"ISERR",ISERROR:"ISERROR",ISEVEN:"ISEVEN",ISFORMULA:"ISFORMULA",ISLOGICAL:"ISLOGICAL",ISNA:"ISNA",ISNONTEXT:"ISNONTEXT",ISNUMBER:"ISNUMBER",ISODD:"ISODD",ISOWEEKNUM:"ISOWEEKNUM",ISPMT:"ISPMT",ISREF:"ISREF",ISTEXT:"ISTEXT",LEFT:"LEFT",LEN:"LEN",LN:"LN",LOG10:"LOG10",LOG:"LOG",LOWER:"LOWER",MATCH:"MATCH",MAX:"MAX",MAXA:"MAXA",MAXIFS:"MAXIFS",MAXPOOL:"MAXPOOL",MEDIAN:"MEDIAN",MEDIANPOOL:"MEDIANPOOL",MID:"MID",MIN:"MIN",MINA:"MINA",MINIFS:"MINIFS",MINUTE:"MINUTE",MIRR:"MIRR",MMULT:"MMULT",MOD:"MOD",MONTH:"MONTH",NA:"NA",NETWORKDAYS:"NETWORKDAYS","NETWORKDAYS.INTL":"NETWORKDAYS.INTL",NOMINAL:"NOMINAL",NOT:"NOT",NOW:"NOW",NPER:"NPER",NPV:"NPV",OCT2BIN:"OCT2BIN",OCT2DEC:"OCT2DEC",OCT2HEX:"OCT2HEX",ODD:"ODD",OFFSET:"OFFSET",OR:"OR",PI:"PI",PMT:"PMT",PDURATION:"PDURATION",PRODUCT:"PRODUCT",POWER:"POWER",PPMT:"PPMT",PROPER:"PROPER",PV:"PV",RADIANS:"RADIANS",RAND:"RAND",RATE:"RATE",REPLACE:"REPLACE",REPT:"REPT",RIGHT:"RIGHT",ROMAN:"ROMAN",ROUND:"ROUND",ROUNDDOWN:"ROUNDDOWN",ROUNDUP:"ROUNDUP",ROW:"ROW",ROWS:"ROWS",RRI:"RRI",SEARCH:"SEARCH",SEC:"SEC",SECH:"SECH",SECOND:"SECOND",SHEET:"SHEET",SHEETS:"SHEETS",SIN:"SIN",SINH:"SINH",SLN:"SLN",SPLIT:"SPLIT",SQRT:"SQRT",STDEVA:"STDEVA","STDEV.P":"STDEV.P",STDEVPA:"STDEVPA","STDEV.S":"STDEV.S",SUBSTITUTE:"SUBSTITUTE",SUBTOTAL:"SUBTOTAL",SUM:"SUM",SUMIF:"SUMIF",SUMIFS:"SUMIFS",SUMPRODUCT:"SUMPRODUCT",SUMSQ:"SUMSQ",SWITCH:"SWITCH",SYD:"SYD",T:"T",TAN:"TAN",TANH:"TANH",TBILLEQ:"TBILLEQ",TBILLPRICE:"TBILLPRICE",TBILLYIELD:"TBILLYIELD",TEXT:"TEXT",TIME:"TIME",TIMEVALUE:"TIMEVALUE",TODAY:"TODAY",TRANSPOSE:"TRANSPOSE",TRIM:"TRIM",TRUE:"TRUE",TRUNC:"TRUNC",UNICHAR:"UNICHAR",UNICODE:"UNICODE",UPPER:"UPPER",VARA:"VARA","VAR.P":"VAR.P",VARPA:"VARPA","VAR.S":"VAR.S",VLOOKUP:"VLOOKUP",WEEKDAY:"WEEKDAY",WEEKNUM:"WEEKNUM",WORKDAY:"WORKDAY","WORKDAY.INTL":"WORKDAY.INTL",XNPV:"XNPV",XOR:"XOR",YEAR:"YEAR",YEARFRAC:"YEARFRAC","HF.ADD":"HF.ADD","HF.CONCAT":"HF.CONCAT","HF.DIVIDE":"HF.DIVIDE","HF.EQ":"HF.EQ","HF.GT":"HF.GT","HF.GTE":"HF.GTE","HF.LT":"HF.LT","HF.LTE":"HF.LTE","HF.MINUS":"HF.MINUS","HF.MULTIPLY":"HF.MULTIPLY","HF.NE":"HF.NE","HF.POW":"HF.POW","HF.UMINUS":"HF.UMINUS","HF.UNARY_PERCENT":"HF.UNARY_PERCENT","HF.UPLUS":"HF.UPLUS",VARP:"VARP",VAR:"VAR",STDEVP:"STDEVP",STDEV:"STDEV","EXPON.DIST":"EXPON.DIST",FISHER:"FISHER",FISHERINV:"FISHERINV",GAMMA:"GAMMA","GAMMA.DIST":"GAMMA.DIST",GAMMALN:"GAMMALN","GAMMALN.PRECISE":"GAMMALN.PRECISE","GAMMA.INV":"GAMMA.INV",GAUSS:"GAUSS",FACT:"FACT",FACTDOUBLE:"FACTDOUBLE",COMBIN:"COMBIN",COMBINA:"COMBINA",GCD:"GCD",LCM:"LCM",MROUND:"MROUND",MULTINOMIAL:"MULTINOMIAL",QUOTIENT:"QUOTIENT",RANDBETWEEN:"RANDBETWEEN",SERIESSUM:"SERIESSUM",SIGN:"SIGN",SQRTPI:"SQRTPI",SUMX2MY2:"SUMX2MY2",SUMX2PY2:"SUMX2PY2",SUMXMY2:"SUMXMY2",EXPONDIST:"EXPONDIST",GAMMADIST:"GAMMADIST",GAMMAINV:"GAMMAINV","BETA.DIST":"BETA.DIST",BETADIST:"BETADIST","BETA.INV":"BETA.INV",BETAINV:"BETAINV","BINOM.DIST":"BINOM.DIST",BINOMDIST:"BINOMDIST","BINOM.INV":"BINOM.INV",BESSELI:"BESSELI",BESSELJ:"BESSELJ",BESSELK:"BESSELK",BESSELY:"BESSELY","CHISQ.DIST":"CHISQ.DIST","CHISQ.DIST.RT":"CHISQ.DIST.RT","CHISQ.INV":"CHISQ.INV","CHISQ.INV.RT":"CHISQ.INV.RT",CHIDIST:"CHIDIST",CHIINV:"CHIINV","F.DIST":"F.DIST","F.DIST.RT":"F.DIST.RT","F.INV":"F.INV","F.INV.RT":"F.INV.RT",FDIST:"FDIST",FINV:"FINV",WEIBULL:"WEIBULL","WEIBULL.DIST":"WEIBULL.DIST",POISSON:"POISSON","POISSON.DIST":"POISSON.DIST","HYPGEOM.DIST":"HYPGEOM.DIST",HYPGEOMDIST:"HYPGEOMDIST","T.DIST":"T.DIST","T.DIST.2T":"T.DIST.2T","T.DIST.RT":"T.DIST.RT","T.INV":"T.INV","T.INV.2T":"T.INV.2T",TDIST:"TDIST",TINV:"TINV",LOGINV:"LOGINV","LOGNORM.DIST":"LOGNORM.DIST","LOGNORM.INV":"LOGNORM.INV",LOGNORMDIST:"LOGNORMDIST","NORM.DIST":"NORM.DIST","NORM.INV":"NORM.INV","NORM.S.DIST":"NORM.S.DIST","NORM.S.INV":"NORM.S.INV",NORMDIST:"NORMDIST",NORMINV:"NORMINV",NORMSDIST:"NORMSDIST",NORMSINV:"NORMSINV",PHI:"PHI","NEGBINOM.DIST":"NEGBINOM.DIST",NEGBINOMDIST:"NEGBINOMDIST",COMPLEX:"COMPLEX",IMABS:"IMABS",IMAGINARY:"IMAGINARY",IMARGUMENT:"IMARGUMENT",IMCONJUGATE:"IMCONJUGATE",IMCOS:"IMCOS",IMCOSH:"IMCOSH",IMCOT:"IMCOT",IMCSC:"IMCSC",IMCSCH:"IMCSCH",IMDIV:"IMDIV",IMEXP:"IMEXP",IMLN:"IMLN",IMLOG10:"IMLOG10",IMLOG2:"IMLOG2",IMPOWER:"IMPOWER",IMPRODUCT:"IMPRODUCT",IMREAL:"IMREAL",IMSEC:"IMSEC",IMSECH:"IMSECH",IMSIN:"IMSIN",IMSINH:"IMSINH",IMSQRT:"IMSQRT",IMSUB:"IMSUB",IMSUM:"IMSUM",IMTAN:"IMTAN",LARGE:"LARGE",SMALL:"SMALL",AVEDEV:"AVEDEV",CONFIDENCE:"CONFIDENCE","CONFIDENCE.NORM":"CONFIDENCE.NORM","CONFIDENCE.T":"CONFIDENCE.T",DEVSQ:"DEVSQ",GEOMEAN:"GEOMEAN",HARMEAN:"HARMEAN",CRITBINOM:"CRITBINOM","COVARIANCE.P":"COVARIANCE.P","COVARIANCE.S":"COVARIANCE.S",COVAR:"COVAR",PEARSON:"PEARSON",RSQ:"RSQ",STANDARDIZE:"STANDARDIZE","Z.TEST":"Z.TEST",ZTEST:"ZTEST","F.TEST":"F.TEST",FTEST:"FTEST",STEYX:"STEYX",SLOPE:"SLOPE","CHISQ.TEST":"CHISQ.TEST",CHITEST:"CHITEST","T.TEST":"T.TEST",TTEST:"TTEST",SKEW:"SKEW","SKEW.P":"SKEW.P",WEIBULLDIST:"WEIBULLDIST",VARS:"VARS",TINV2T:"TINV2T",TDISTRT:"TDISTRT",TDIST2T:"TDIST2T",STDEVS:"STDEVS",FINVRT:"FINVRT",FDISTRT:"FDISTRT",CHIDISTRT:"CHIDISTRT",CHIINVRT:"CHIINVRT",COVARIANCEP:"COVARIANCEP",COVARIANCES:"COVARIANCES",LOGNORMINV:"LOGNORMINV",POISSONDIST:"POISSONDIST",SKEWP:"SKEWP","CEILING.MATH":"CEILING.MATH",FLOOR:"FLOOR","FLOOR.MATH":"FLOOR.MATH","CEILING.PRECISE":"CEILING.PRECISE","FLOOR.PRECISE":"FLOOR.PRECISE","ISO.CEILING":"ISO.CEILING"},langCode:"enGB",ui:{NEW_SHEET_PREFIX:"Sheet"}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
var Zo;!function(e){e[e.FullyAbsolute=1]="FullyAbsolute",e[e.RowAbsoluteColRelative=2]="RowAbsoluteColRelative",e[e.RowRelativeColAbsolute=3]="RowRelativeColAbsolute",e[e.FullyRelative=4]="FullyRelative"}(Zo||(Zo={}));class Jo extends un{verifyAddressArguments(e,t,r,n){if(n){if(e<1||t<1)return new Tr(or.VALUE,Z.LessThanOne)}else if(Zo.FullyAbsolute==r){if(e<1||t<1)return new Tr(or.VALUE,Z.LessThanOne)}else if(Zo.RowAbsoluteColRelative==r){if(e<1)return new Tr(or.VALUE,Z.LessThanOne)}else if(Zo.RowRelativeColAbsolute==r&&t<1)return new Tr(or.VALUE,Z.LessThanOne)}address(e,t){return this.runFunction(e.args,t,this.metadata("ADDRESS"),((e,t,r,n,s)=>{const o=this.verifyAddressArguments(e,t,r,n);if(void 0!==o)return o;const i=P(t-1);let a="";null!=s&&(a=`${s}!`);const l=0==t?"C":`C[${t}]`,h=0==e?"R":`R[${e}]`;return Zo.FullyRelative==r?n?`${a}${i}${e}`:`${a}${h}${l}`:Zo.RowRelativeColAbsolute==r?n?`${a}$${i}${e}`:`${a}${h}C${t}`:Zo.RowAbsoluteColRelative==r?n?`${a}${i}$${e}`:`${a}R${e}${l}`:n?`${a}$${i}$${e}`:`${a}R${e}C${t}`}))}}Jo.implementedFunctions={ADDRESS:{method:"address",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,optionalArg:!0,defaultValue:1,minValue:1,maxValue:4},{argumentType:hn.BOOLEAN,optionalArg:!0,defaultValue:!0},{argumentType:hn.STRING,optionalArg:!0}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ei extends un{arrayformula(e,t){return this.runFunction(e.args,t,this.metadata("ARRAYFORMULA"),(e=>e))}arrayformulaArraySize(e,t){if(1!==e.args.length)return cn.error();const r=this.metadata("ARRAYFORMULA");return e.args.map((e=>{var n;return this.arraySizeForAst(e,new Br(t.formulaAddress,t.arraysFlag||null!==(n=null==r?void 0:r.arrayFunction)&&void 0!==n&&n))}))[0]}arrayconstrain(e,t){return this.runFunction(e.args,t,this.metadata("ARRAY_CONSTRAIN"),((e,t,r)=>{t=Math.min(t,e.height()),r=Math.min(r,e.width());const n=e.data,s=[];for(let e=0;e<t;e++)s.push(n[e].slice(0,r));return rt.onlyValues(s)}))}arrayconstrainArraySize(e,t){if(3!==e.args.length)return cn.error();const r=this.metadata("ARRAY_CONSTRAIN"),n=e.args.map((e=>{var n;return this.arraySizeForAst(e,new Br(t.formulaAddress,t.arraysFlag||null!==(n=null==r?void 0:r.arrayFunction)&&void 0!==n&&n))}));let{height:s,width:o}=n[0];return e.args[1].type===U.NUMBER&&(s=Math.min(s,e.args[1].value)),e.args[2].type===U.NUMBER&&(o=Math.min(o,e.args[2].value)),s<1||o<1||!Number.isInteger(s)||!Number.isInteger(o)?cn.error():new cn(o,s)}filter(e,t){return this.runFunction(e.args,t,this.metadata("FILTER"),((e,...t)=>{for(const r of t)if(e.width()!==r.width()||e.height()!==r.height())return new Tr(or.NA,Z.EqualLength);if(e.width()>1&&e.height()>1)return new Tr(or.NA,Z.WrongDimension);const r=e.data,n=[];for(let s=0;s<e.height();s++){const o=[];for(let n=0;n<e.width();n++){let e=!0;for(const r of t){if(!0!==Kr(r.data[s][n])){e=!1;break}}e&&o.push(r[s][n])}o.length>0&&n.push(o)}return n.length>0?rt.onlyValues(n):new Tr(or.NA,Z.EmptyRange)}))}filterArraySize(e,t){if(e.args.length<=1)return cn.error();const r=this.metadata("FILTER"),n=e.args.map((e=>{var n;return this.arraySizeForAst(e,new Br(t.formulaAddress,t.arraysFlag||null!==(n=null==r?void 0:r.arrayFunction)&&void 0!==n&&n))})),s=Math.max(...n.map((e=>e.width))),o=Math.max(...n.map((e=>e.height)));return new cn(s,o)}}ei.implementedFunctions={ARRAYFORMULA:{method:"arrayformula",arraySizeMethod:"arrayformulaArraySize",arrayFunction:!0,parameters:[{argumentType:hn.ANY}]},ARRAY_CONSTRAIN:{method:"arrayconstrain",arraySizeMethod:"arrayconstrainArraySize",parameters:[{argumentType:hn.RANGE},{argumentType:hn.INTEGER,minValue:1},{argumentType:hn.INTEGER,minValue:1}],vectorizationForbidden:!0},FILTER:{method:"filter",arraySizeMethod:"filterArraySize",arrayFunction:!0,parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}],repeatLastArgs:1}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ti extends un{abs(e,t){return this.runFunction(e.args,t,this.metadata("ABS"),Math.abs)}}ti.implementedFunctions={ABS:{method:"abs",parameters:[{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const ri=0xffffffffffff;class ni extends un{bitlshift(e,t){return this.runFunction(e.args,t,this.metadata("BITLSHIFT"),si)}bitrshift(e,t){return this.runFunction(e.args,t,this.metadata("BITRSHIFT"),oi)}}function si(e,t){return t<0?oi(e,-t):ii(e*Math.pow(2,t))}function oi(e,t){return t<0?si(e,-t):ii(Math.floor(e/Math.pow(2,t)))}function ii(e){return e>ri?new Tr(or.NUM,Z.BitshiftLong):e}ni.implementedFunctions={BITLSHIFT:{method:"bitlshift",parameters:[{argumentType:hn.INTEGER,minValue:0},{argumentType:hn.INTEGER,minValue:-53,maxValue:53}]},BITRSHIFT:{method:"bitrshift",parameters:[{argumentType:hn.INTEGER,minValue:0},{argumentType:hn.INTEGER,minValue:-53,maxValue:53}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ai extends un{bitand(e,t){return this.runFunction(e.args,t,this.metadata("BITAND"),((e,t)=>e&t))}bitor(e,t){return this.runFunction(e.args,t,this.metadata("BITOR"),((e,t)=>e|t))}bitxor(e,t){return this.runFunction(e.args,t,this.metadata("BITXOR"),((e,t)=>e^t))}}ai.implementedFunctions={BITAND:{method:"bitand",parameters:[{argumentType:hn.INTEGER,minValue:0},{argumentType:hn.INTEGER,minValue:0}]},BITOR:{method:"bitor",parameters:[{argumentType:hn.INTEGER,minValue:0},{argumentType:hn.INTEGER,minValue:0}]},BITXOR:{method:"bitxor",parameters:[{argumentType:hn.INTEGER,minValue:0},{argumentType:hn.INTEGER,minValue:0}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class li extends un{literalTrue(e,t){return this.runFunction(e.args,t,this.metadata("TRUE"),(()=>!0))}literalFalse(e,t){return this.runFunction(e.args,t,this.metadata("FALSE"),(()=>!1))}conditionalIf(e,t){return this.runFunction(e.args,t,this.metadata("IF"),((e,t,r)=>e?t:r))}ifs(e,t){return this.runFunction(e.args,t,this.metadata("IFS"),((...e)=>{for(let t=0;t<e.length;t+=2)if(e[t])return e[t+1];return new Tr(or.NA,Z.NoConditionMet)}))}and(e,t){return this.runFunction(e.args,t,this.metadata("AND"),((...e)=>e.filter((e=>void 0!==e)).every((e=>!!e))))}or(e,t){return this.runFunction(e.args,t,this.metadata("OR"),((...e)=>e.filter((e=>void 0!==e)).some((e=>e))))}not(e,t){return this.runFunction(e.args,t,this.metadata("NOT"),(e=>!e))}xor(e,t){return this.runFunction(e.args,t,this.metadata("XOR"),((...e)=>{let t=0;return e.filter((e=>void 0!==e)).forEach((e=>{e&&t++})),t%2==1}))}switch(e,t){return this.runFunction(e.args,t,this.metadata("SWITCH"),((e,...t)=>{const r=t.length;let n=0;for(;n+1<r;n+=2)if(!(t[n]instanceof Tr)&&this.arithmeticHelper.eq(e,t[n]))return t[n+1];return n<r?t[n]:new Tr(or.NA,Z.NoDefault)}))}iferror(e,t){return this.runFunction(e.args,t,this.metadata("IFERROR"),((e,t)=>e instanceof Tr?t:e))}ifna(e,t){return this.runFunction(e.args,t,this.metadata("IFNA"),((e,t)=>e instanceof Tr&&e.type===or.NA?t:e))}choose(e,t){return this.runFunction(e.args,t,this.metadata("CHOOSE"),((e,...t)=>e>t.length?new Tr(or.NUM,Z.Selector):t[e-1]))}}li.implementedFunctions={TRUE:{method:"literalTrue",parameters:[]},FALSE:{method:"literalFalse",parameters:[]},IF:{method:"conditionalIf",parameters:[{argumentType:hn.BOOLEAN},{argumentType:hn.SCALAR,passSubtype:!0},{argumentType:hn.SCALAR,defaultValue:!1,passSubtype:!0}]},IFS:{method:"ifs",parameters:[{argumentType:hn.BOOLEAN},{argumentType:hn.SCALAR,passSubtype:!0}],repeatLastArgs:2},AND:{method:"and",parameters:[{argumentType:hn.BOOLEAN}],repeatLastArgs:1,expandRanges:!0},OR:{method:"or",parameters:[{argumentType:hn.BOOLEAN}],repeatLastArgs:1,expandRanges:!0},XOR:{method:"xor",parameters:[{argumentType:hn.BOOLEAN}],repeatLastArgs:1,expandRanges:!0},NOT:{method:"not",parameters:[{argumentType:hn.BOOLEAN}]},SWITCH:{method:"switch",parameters:[{argumentType:hn.NOERROR},{argumentType:hn.SCALAR,passSubtype:!0},{argumentType:hn.SCALAR,passSubtype:!0}],repeatLastArgs:1},IFERROR:{method:"iferror",parameters:[{argumentType:hn.SCALAR,passSubtype:!0},{argumentType:hn.SCALAR,passSubtype:!0}]},IFNA:{method:"ifna",parameters:[{argumentType:hn.SCALAR,passSubtype:!0},{argumentType:hn.SCALAR,passSubtype:!0}]},CHOOSE:{method:"choose",parameters:[{argumentType:hn.INTEGER,minValue:1},{argumentType:hn.SCALAR,passSubtype:!0}],repeatLastArgs:1}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class hi extends un{char(e,t){return this.runFunction(e.args,t,this.metadata("CHAR"),(e=>e<1||e>=256?new Tr(or.VALUE,Z.CharacterCodeBounds):String.fromCharCode(Math.trunc(e))))}unichar(e,t){return this.runFunction(e.args,t,this.metadata("CHAR"),(e=>e<1||e>=1114112?new Tr(or.VALUE,Z.CharacterCodeBounds):String.fromCodePoint(Math.trunc(e))))}}hi.implementedFunctions={CHAR:{method:"char",parameters:[{argumentType:hn.NUMBER}]},UNICHAR:{method:"unichar",parameters:[{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ui extends un{code(e,t){return this.runFunction(e.args,t,this.metadata("CODE"),(e=>0===e.length?new Tr(or.VALUE,Z.EmptyString):e.charCodeAt(0)))}unicode(e,t){return this.runFunction(e.args,t,this.metadata("UNICODE"),(e=>{var t;return null!==(t=e.codePointAt(0))&&void 0!==t?t:new Tr(or.VALUE,Z.EmptyString)}))}}ui.implementedFunctions={CODE:{method:"code",parameters:[{argumentType:hn.STRING}]},UNICODE:{method:"unicode",parameters:[{argumentType:hn.STRING}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ci extends un{countblank(e,t){return this.runFunction(e.args,t,this.metadata("COUNTBLANK"),((...e)=>{let t=0;return e.forEach((e=>{e===Ye&&t++})),t}))}}ci.implementedFunctions={COUNTBLANK:{method:"countblank",parameters:[{argumentType:hn.SCALAR}],repeatLastArgs:1,expandRanges:!0}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class di extends un{countunique(e,t){return this.runFunction(e.args,t,this.metadata("COUNTUNIQUE"),((...e)=>{const t=new Set,r=new Set;for(const n of e)n instanceof Tr?r.add(n.type):""!==n&&t.add(n);return t.size+r.size}))}}di.implementedFunctions={COUNTUNIQUE:{method:"countunique",parameters:[{argumentType:hn.SCALAR}],repeatLastArgs:1,expandRanges:!0}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class pi extends un{constructor(){super(...arguments),this.isoweeknumCore=e=>{const t=Math.floor(this.dateTimeHelper.relativeNumberToAbsoluteNumber(e)),r=this.dateTimeHelper.numberToSimpleDate(e),n=this.dateTimeHelper.dateToNumber({year:r.year,month:1,day:1}),s=this.dateTimeHelper.relativeNumberToAbsoluteNumber(n),o=s+((4-s)%7+7)%7,i=Math.floor((t-1)/7)-Math.floor((o-1)/7)+1;return 0===i?this.isoweeknumCore(e-7)+1:i},this.days360Core=(e,t,r)=>{const n=this.dateTimeHelper.numberToSimpleDate(e),s=this.dateTimeHelper.numberToSimpleDate(t);let o,i;return r?(o=Wn(n),i=Wn(s)):[o,i]=this.dateTimeHelper.toBasisUS(n,s),360*(i.year-o.year)+30*(i.month-o.month)+i.day-o.day}}date(e,t){return this.runFunction(e.args,t,this.metadata("DATE"),((e,t,r)=>{const n=Math.trunc(r);let s=Math.trunc(t),o=Math.trunc(e);o<this.dateTimeHelper.getEpochYearZero()&&(o+=this.dateTimeHelper.getEpochYearZero());const i=Math.floor((s-1)/12);o+=i,s-=12*i;const a={year:o,month:s,day:1};if(this.dateTimeHelper.isValidDate(a)){let e=this.dateTimeHelper.dateToNumber(a)+(n-1);return e=this.dateTimeHelper.getWithinBounds(e),void 0===e?new Tr(or.NUM,Z.DateBounds):e}return new Tr(or.VALUE,Z.InvalidDate)}))}time(e,t){return this.runFunction(e.args,t,this.metadata("TIME"),((e,t,r)=>{const n=Bn({hours:Math.trunc(e),minutes:Math.trunc(t),seconds:Math.trunc(r)});return n<0?new Tr(or.NUM,Z.NegativeTime):n%1}))}eomonth(e,t){return this.runFunction(e.args,t,this.metadata("EOMONTH"),((e,t)=>{const r=this.dateTimeHelper.numberToSimpleDate(e);let n=this.dateTimeHelper.dateToNumber(this.dateTimeHelper.endOfMonth(Fn(r,t)));return n=this.dateTimeHelper.getWithinBounds(n),void 0===n?new Tr(or.NUM,Z.DateBounds):n}))}day(e,t){return this.runFunction(e.args,t,this.metadata("DAY"),(e=>this.dateTimeHelper.numberToSimpleDate(e).day))}days(e,t){return this.runFunction(e.args,t,this.metadata("DAYS"),((e,t)=>Math.trunc(e)-Math.trunc(t)))}month(e,t){return this.runFunction(e.args,t,this.metadata("MONTH"),(e=>this.dateTimeHelper.numberToSimpleDate(e).month))}year(e,t){return this.runFunction(e.args,t,this.metadata("YEAR"),(e=>this.dateTimeHelper.numberToSimpleDate(e).year))}hour(e,t){return this.runFunction(e.args,t,this.metadata("HOUR"),(e=>Vn(Un(e)%1).hours))}minute(e,t){return this.runFunction(e.args,t,this.metadata("MINUTE"),(e=>Vn(Un(e)%1).minutes))}second(e,t){return this.runFunction(e.args,t,this.metadata("SECOND"),(e=>Vn(Un(e)%1).seconds))}text(e,t){return this.runFunction(e.args,t,this.metadata("TEXT"),((e,t)=>Zn(e,t,this.config,this.dateTimeHelper)))}weekday(e,t){return this.runFunction(e.args,t,this.metadata("WEEKDAY"),((e,t)=>{const r=Math.floor(this.dateTimeHelper.relativeNumberToAbsoluteNumber(e));if(3===t)return(r-1)%7;const n=mi.get(t);return void 0===n?new Tr(or.NUM,Z.BadMode):(r-n)%7+1}))}weeknum(e,t){return this.runFunction(e.args,t,this.metadata("WEEKNUM"),((e,t)=>{const r=Math.floor(this.dateTimeHelper.relativeNumberToAbsoluteNumber(e)),n=this.dateTimeHelper.numberToSimpleDate(e),s=this.dateTimeHelper.dateToNumber({year:n.year,month:1,day:1}),o=this.dateTimeHelper.relativeNumberToAbsoluteNumber(s);if(21===t)return this.isoweeknumCore(e);const i=mi.get(t);return void 0===i?new Tr(or.NUM,Z.BadMode):Math.floor((r-i)/7)-Math.floor((o-i)/7)+1}))}isoweeknum(e,t){return this.runFunction(e.args,t,this.metadata("ISOWEEKNUM"),this.isoweeknumCore)}datevalue(e,t){return this.runFunction(e.args,t,this.metadata("DATEVALUE"),(e=>{const{dateTime:t}=this.dateTimeHelper.parseDateTimeFromConfigFormats(e);return void 0===t?new Tr(or.VALUE,Z.IncorrectDateTime):Ln(t)?(Dn(t)?Math.trunc(Bn(t)):0)+this.dateTimeHelper.dateToNumber(t):0}))}timevalue(e,t){return this.runFunction(e.args,t,this.metadata("TIMEVALUE"),(e=>{const t=this.dateTimeHelper.dateStringToDateNumber(e);return void 0===t?new Tr(or.VALUE,Z.IncorrectDateTime):je(t)%1}))}now(e,t){return this.runFunction(e.args,t,this.metadata("NOW"),(()=>{const e=new Date(Date.now());return Bn({hours:e.getHours(),minutes:e.getMinutes(),seconds:e.getSeconds()})+this.dateTimeHelper.dateToNumber({year:e.getFullYear(),month:e.getMonth()+1,day:e.getDate()})}))}today(e,t){return this.runFunction(e.args,t,this.metadata("TODAY"),(()=>{const e=new Date(Date.now());return this.dateTimeHelper.dateToNumber({year:e.getFullYear(),month:e.getMonth()+1,day:e.getDate()})}))}edate(e,t){return this.runFunction(e.args,t,this.metadata("EDATE"),((e,t)=>{const r=function(e){return{year:e.year,month:e.month,day:Math.min(e.day,bn[e.month-1])}}(Fn(this.dateTimeHelper.numberToSimpleDate(e),t));let n=this.dateTimeHelper.dateToNumber(r);return n=this.dateTimeHelper.getWithinBounds(n),void 0===n?new Tr(or.NUM,Z.DateBounds):n}))}datedif(e,t){return this.runFunction(e.args,t,this.metadata("DATEDIF"),((e,t,r)=>{if(e>t)return new Tr(or.NUM,Z.StartEndDate);if("D"===r)return Math.floor(t)-Math.floor(e);const n=this.dateTimeHelper.numberToSimpleDate(e),s=this.dateTimeHelper.numberToSimpleDate(t);switch(r){case"M":return 12*(s.year-n.year)+(s.month-n.month)-(s.day<n.day?1:0);case"YM":return(s.month-n.month+12-(s.day<n.day?1:0))%12;case"Y":return s.month>n.month||s.month===n.month&&s.day>=n.day?s.year-n.year:s.year-n.year-1;case"MD":if(s.day>=n.day)return s.day-n.day;{const e=1===s.month?12:s.month-1,t=1===s.month?s.year-1:s.year;return this.dateTimeHelper.daysInMonth(t,e)+s.day-n.day}case"YD":return s.month>n.month||s.month===n.month&&s.day>=n.day?Math.floor(t)-this.dateTimeHelper.dateToNumber({year:s.year,month:n.month,day:n.day}):Math.floor(t)-Math.floor(e)-365*(s.year-n.year-1)-this.dateTimeHelper.leapYearsCount(s.year-1)+this.dateTimeHelper.leapYearsCount(n.year);default:return new Tr(or.NUM,Z.BadMode)}}))}days360(e,t){return this.runFunction(e.args,t,this.metadata("DAYS360"),this.days360Core)}yearfrac(e,t){return this.runFunction(e.args,t,this.metadata("YEARFRAC"),((e,t,r)=>{switch((e=Math.trunc(e))>(t=Math.trunc(t))&&([e,t]=[t,e]),r){case 0:return this.days360Core(e,t,!1)/360;case 1:return(t-e)/this.dateTimeHelper.yearLengthForBasis(this.dateTimeHelper.numberToSimpleDate(e),this.dateTimeHelper.numberToSimpleDate(t));case 2:return(t-e)/360;case 3:return(t-e)/365;case 4:return this.days360Core(e,t,!0)/360}throw new Error("Should not be reachable.")}))}interval(e,t){return this.runFunction(e.args,t,this.metadata("INTERVAL"),(e=>{const t=(e=Math.trunc(e))%60,r=(e=Math.trunc(e/60))%60,n=(e=Math.trunc(e/60))%24,s=(e=Math.trunc(e/24))%30,o=(e=Math.trunc(e/30))%12,i=Math.trunc(e/12);return"P"+(i>0?`${i}Y`:"")+(o>0?`${o}M`:"")+(s>0?`${s}D`:"")+"T"+(n>0?`${n}H`:"")+(r>0?`${r}M`:"")+(t>0?`${t}S`:"")}))}networkdays(e,t){return this.runFunction(e.args,t,this.metadata("NETWORKDAYS"),((e,t,r)=>this.networkdayscore(e,t,1,r)))}networkdaysintl(e,t){return this.runFunction(e.args,t,this.metadata("NETWORKDAYS.INTL"),((e,t,r,n)=>this.networkdayscore(e,t,r,n)))}workday(e,t){return this.runFunction(e.args,t,this.metadata("WORKDAY"),((e,t,r)=>this.workdaycore(e,t,1,r)))}workdayintl(e,t){return this.runFunction(e.args,t,this.metadata("WORKDAY.INTL"),((e,t,r,n)=>this.workdaycore(e,t,r,n)))}networkdayscore(e,t,r,n){let s=1;(e=Math.trunc(e))>(t=Math.trunc(t))&&([e,t]=[t,e],s=-1);const o=fi(r);if(o instanceof Tr)return o;const i=this.simpleRangeToFilteredHolidays(o,n);return i instanceof Tr?i:s*this.countWorkdays(e,t,o,i)}workdaycore(e,t,r,n){e=Math.trunc(e),t=Math.trunc(t);const s=fi(r);if(s instanceof Tr)return s;const o=this.simpleRangeToFilteredHolidays(s,n);if(o instanceof Tr)return o;if(t>0){let r=1;for(;this.countWorkdays(e+1,e+r,s,o)<t;)r*=2;let n=1;for(;n+1<r;){const i=Math.trunc((n+r)/2);this.countWorkdays(e+1,e+i,s,o)<t?n=i:r=i}return e+r}if(t<0){t*=-1;let r=1;for(;this.countWorkdays(e-r,e-1,s,o)<t;)r*=2;let n=1;for(;n+1<r;){const i=Math.trunc((n+r)/2);this.countWorkdays(e-i,e-1,s,o)<t?n=i:r=i}return e-r}return e}countWorkdays(e,t,r,n){const s=Math.floor(this.dateTimeHelper.relativeNumberToAbsoluteNumber(t)),o=Math.floor(this.dateTimeHelper.relativeNumberToAbsoluteNumber(e));let i=0;for(let e=0;e<7;e++)"0"===r.charAt(e)&&(i+=Math.floor((s+6-e)/7),i-=Math.floor((o-1+6-e)/7));return i-=gi(t+1,n)-gi(e,n),i}simpleRangeToFilteredHolidays(e,t){var r;const n=null!==(r=null==t?void 0:t.valuesFromTopLeftCorner())&&void 0!==r?r:[];for(const e of n)if(e instanceof Tr)return e;const s=[];for(const e of n)if(e!==Ye){if(!Ze(e))return new Tr(or.VALUE,Z.WrongType);s.push(Math.trunc(je(e)))}return[...new Set(s)].sort(((e,t)=>e-t)).filter((t=>{const r=(this.dateTimeHelper.relativeNumberToAbsoluteNumber(t)-1)%7;return"0"===e.charAt(r)}))}}function gi(e,t){if(0===t.length)return 0;if(e<=t[0])return 0;if(t[t.length-1]<e)return t.length;let r=0,n=t.length-1;for(;r+1<n;){const s=Math.floor((n+r)/2);t[s]>=e?n=s:r=s}return n}function fi(e){var t;return"number"!=typeof e&&"string"!=typeof e?new Tr(or.VALUE,Z.WrongType):"string"==typeof e?7===e.length&&/^(0|1)*$/.test(e)&&"1111111"!==e?e:new Tr(or.NUM,Z.WeekendString):null!==(t=Ei.get(e))&&void 0!==t?t:new Tr(or.NUM,Z.BadMode)}pi.implementedFunctions={DATE:{method:"date",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}],returnNumberType:Je.NUMBER_DATE},TIME:{method:"time",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}],returnNumberType:Je.NUMBER_TIME},MONTH:{method:"month",parameters:[{argumentType:hn.NUMBER,minValue:0}]},YEAR:{method:"year",parameters:[{argumentType:hn.NUMBER,minValue:0}]},HOUR:{method:"hour",parameters:[{argumentType:hn.NUMBER,minValue:0}]},MINUTE:{method:"minute",parameters:[{argumentType:hn.NUMBER,minValue:0}]},SECOND:{method:"second",parameters:[{argumentType:hn.NUMBER,minValue:0}]},TEXT:{method:"text",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.STRING}]},EOMONTH:{method:"eomonth",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER}],returnNumberType:Je.NUMBER_DATE},DAY:{method:"day",parameters:[{argumentType:hn.NUMBER,minValue:0}]},DAYS:{method:"days",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0}]},WEEKDAY:{method:"weekday",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,defaultValue:1}]},WEEKNUM:{method:"weeknum",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,defaultValue:1}]},ISOWEEKNUM:{method:"isoweeknum",parameters:[{argumentType:hn.NUMBER,minValue:0}]},DATEVALUE:{method:"datevalue",parameters:[{argumentType:hn.STRING}],returnNumberType:Je.NUMBER_DATE},TIMEVALUE:{method:"timevalue",parameters:[{argumentType:hn.STRING}],returnNumberType:Je.NUMBER_TIME},NOW:{method:"now",parameters:[],isVolatile:!0,returnNumberType:Je.NUMBER_DATETIME},TODAY:{method:"today",parameters:[],isVolatile:!0,returnNumberType:Je.NUMBER_DATE},EDATE:{method:"edate",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER}],returnNumberType:Je.NUMBER_DATE},DAYS360:{method:"days360",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.BOOLEAN,defaultValue:!1}]},DATEDIF:{method:"datedif",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.STRING}]},YEARFRAC:{method:"yearfrac",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.INTEGER,defaultValue:0,minValue:0,maxValue:4}]},INTERVAL:{method:"interval",parameters:[{argumentType:hn.NUMBER,minValue:0}]},NETWORKDAYS:{method:"networkdays",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.RANGE,optionalArg:!0}]},"NETWORKDAYS.INTL":{method:"networkdaysintl",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NOERROR,defaultValue:1},{argumentType:hn.RANGE,optionalArg:!0}]},WORKDAY:{method:"workday",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER},{argumentType:hn.RANGE,optionalArg:!0}]},"WORKDAY.INTL":{method:"workdayintl",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER},{argumentType:hn.NOERROR,defaultValue:1},{argumentType:hn.RANGE,optionalArg:!0}]}};const mi=new Map([[1,0],[2,1],[11,1],[12,2],[13,3],[14,4],[15,5],[16,6],[17,0]]),Ei=new Map([[1,"0000011"],[2,"1000001"],[3,"1100000"],[4,"0110000"],[5,"0011000"],[6,"0001100"],[7,"0000110"],[11,"0000001"],[12,"1000000"],[13,"0100000"],[14,"0010000"],[15,"0001000"],[16,"0000100"],[17,"0000010"]]);
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class yi extends un{degrees(e,t){return this.runFunction(e.args,t,this.metadata("DEGREES"),(e=>e*(180/Math.PI)))}}yi.implementedFunctions={DEGREES:{method:"degrees",parameters:[{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class wi extends un{delta(e,t){return this.runFunction(e.args,t,this.metadata("DELTA"),((e,t)=>e===t?1:0))}}wi.implementedFunctions={DELTA:{method:"delta",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ci extends un{exp(e,t){return this.runFunction(e.args,t,this.metadata("EXP"),Math.exp)}}Ci.implementedFunctions={EXP:{method:"exp",parameters:[{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ri extends un{pmt(e,t){return this.runFunction(e.args,t,this.metadata("PMT"),vi)}ipmt(e,t){return this.runFunction(e.args,t,this.metadata("IPMT"),Si)}ppmt(e,t){return this.runFunction(e.args,t,this.metadata("PPMT"),Ni)}fv(e,t){return this.runFunction(e.args,t,this.metadata("FV"),Ti)}cumipmt(e,t){return this.runFunction(e.args,t,this.metadata("CUMIPMT"),((e,t,r,n,s,o)=>{if(n>s)return new Tr(or.NUM,Z.EndStartPeriod);let i=0;for(let a=n;a<=s;a++)i+=Si(e,a,t,r,0,o);return i}))}cumprinc(e,t){return this.runFunction(e.args,t,this.metadata("CUMPRINC"),((e,t,r,n,s,o)=>{if(n>s)return new Tr(or.NUM,Z.EndStartPeriod);let i=0;for(let a=n;a<=s;a++)i+=Ni(e,a,t,r,0,o);return i}))}db(e,t){return this.runFunction(e.args,t,this.metadata("DB"),((e,t,r,n,s)=>{if(12===s&&n>r||n>r+1)return new Tr(or.NUM,Z.PeriodLong);if(t>=e)return 0;const o=Math.round(1e3*(1-Math.pow(t/e,1/r)))/1e3,i=e*o*s/12;if(1===n)return i;let a=i;for(let t=0;t<n-2;t++)a+=(e-a)*o;return n===r+1?(e-a)*o*(12-s)/12:(e-a)*o}))}ddb(e,t){return this.runFunction(e.args,t,this.metadata("DDB"),((e,t,r,n,s)=>{if(n>r)return new Tr(or.NUM);let o,i=s/r;i>=1?(i=1,o=1===n?e:0):o=e*Math.pow(1-i,n-1);const a=e*Math.pow(1-i,n);return Math.max(o-Math.max(t,a),0)}))}dollarde(e,t){return this.runFunction(e.args,t,this.metadata("DOLLARDE"),((e,t)=>{if(t<1)return new Tr(or.DIV_BY_ZERO);for(t=Math.trunc(t);t>10;)t/=10;return Math.trunc(e)+10*(e-Math.trunc(e))/t}))}dollarfr(e,t){return this.runFunction(e.args,t,this.metadata("DOLLARFR"),((e,t)=>{if(t<1)return new Tr(or.DIV_BY_ZERO);for(t=Math.trunc(t);t>10;)t/=10;return Math.trunc(e)+(e-Math.trunc(e))*t/10}))}effect(e,t){return this.runFunction(e.args,t,this.metadata("EFFECT"),((e,t)=>(t=Math.trunc(t),Math.pow(1+e/t,t)-1)))}ispmt(e,t){return this.runFunction(e.args,t,this.metadata("ISPMT"),((e,t,r,n)=>0===r?new Tr(or.DIV_BY_ZERO):n*e*(t/r-1)))}nominal(e,t){return this.runFunction(e.args,t,this.metadata("NOMINAL"),((e,t)=>(t=Math.trunc(t),(Math.pow(e+1,1/t)-1)*t)))}nper(e,t){return this.runFunction(e.args,t,this.metadata("NPER"),((e,t,r,n,s)=>0===e?0===t?new Tr(or.DIV_BY_ZERO):(-r-n)/t:(s&&(t*=1+e),Math.log((t-n*e)/(r*e+t))/Math.log(1+e))))}rate(e,t){return this.runFunction(e.args,t,this.metadata("RATE"),((e,t,r,n,s,o)=>{if(o<=-1)return new Tr(or.VALUE);const i=1e-7;let a=o;s=s?1:0;for(let o=0;o<50;o++){if(a<=-1)return new Tr(or.NUM);let o,l;if(Math.abs(a)<i)o=r*(1+e*a)+t*(1+a*s)*e+n;else{const i=Math.pow(1+a,e);o=r*i+t*(1/a+s)*(i-1)+n}if(Math.abs(o)<i)return a;if(Math.abs(a)<i)l=r*e+t*s*e;else{const n=Math.pow(1+a,e),o=e*Math.pow(1+a,e-1);l=r*o+t*(1/a+s)*o+t*(-1/(a*a))*(n-1)}a-=o/l}return new Tr(or.NUM)}))}pv(e,t){return this.runFunction(e.args,t,this.metadata("PV"),((e,t,r,n,s)=>(s=s?1:0,-1===e?new Tr(0===t?or.NUM:or.DIV_BY_ZERO):0===e?-r*t-n:((1-Math.pow(1+e,t))*r*(1+e*s)/e-n)/Math.pow(1+e,t))))}rri(e,t){return this.runFunction(e.args,t,this.metadata("RRI"),((e,t,r)=>0===t||r<0&&t>0||r>0&&t<0?new Tr(or.NUM):Math.pow(r/t,1/e)-1))}sln(e,t){return this.runFunction(e.args,t,this.metadata("SLN"),((e,t,r)=>0===r?new Tr(or.DIV_BY_ZERO):(e-t)/r))}syd(e,t){return this.runFunction(e.args,t,this.metadata("SYD"),((e,t,r,n)=>n>r?new Tr(or.NUM):(e-t)*(r-n+1)*2/(r*(r+1))))}tbilleq(e,t){return this.runFunction(e.args,t,this.metadata("TBILLEQ"),((e,t,r)=>{if((e=Math.round(e))>=(t=Math.round(t)))return new Tr(or.NUM);const n=this.dateTimeHelper.numberToSimpleDate(e),s=this.dateTimeHelper.numberToSimpleDate(t);if(s.year>n.year+1||s.year===n.year+1&&(s.month>n.month||s.month===n.month&&s.day>n.day))return new Tr(or.NUM);const o=360-r*(t-e);return 0===o?0:o<0?new Tr(or.NUM):365*r/o}))}tbillprice(e,t){return this.runFunction(e.args,t,this.metadata("TBILLPRICE"),((e,t,r)=>{if((e=Math.round(e))>=(t=Math.round(t)))return new Tr(or.NUM);const n=this.dateTimeHelper.numberToSimpleDate(e),s=this.dateTimeHelper.numberToSimpleDate(t);if(s.year>n.year+1||s.year===n.year+1&&(s.month>n.month||s.month===n.month&&s.day>n.day))return new Tr(or.NUM);const o=360-r*(t-e);return 0===o?0:o<0?new Tr(or.NUM):100*(1-r*(t-e)/360)}))}tbillyield(e,t){return this.runFunction(e.args,t,this.metadata("TBILLYIELD"),((e,t,r)=>{if((e=Math.round(e))>=(t=Math.round(t)))return new Tr(or.NUM);const n=this.dateTimeHelper.numberToSimpleDate(e),s=this.dateTimeHelper.numberToSimpleDate(t);return s.year>n.year+1||s.year===n.year+1&&(s.month>n.month||s.month===n.month&&s.day>n.day)?new Tr(or.NUM):360*(100-r)/(r*(t-e))}))}fvschedule(e,t){return this.runFunction(e.args,t,this.metadata("FVSCHEDULE"),((e,t)=>{const r=t.valuesFromTopLeftCorner();for(const e of r)if(e instanceof Tr)return e;for(const t of r)if(Ze(t))e*=1+je(t);else if(t!==Ye)return new Tr(or.VALUE,Z.NumberExpected);return e}))}npv(e,t){return this.runFunction(e.args,t,this.metadata("NPV"),((e,...t)=>{const r=this.arithmeticHelper.coerceNumbersExactRanges(t);return r instanceof Tr?r:_i(e,r)}))}mirr(e,t){return this.runFunction(e.args,t,this.metadata("MIRR"),((e,t,r)=>{const n=this.arithmeticHelper.manyToExactNumbers(e.valuesFromTopLeftCorner());if(n instanceof Tr)return n;let s=!1,o=!1;const i=[],a=[];for(const e of n)e>0?(s=!0,i.push(e),a.push(0)):e<0?(o=!0,a.push(e),i.push(0)):(a.push(0),i.push(0));if(!s||!o)return new Tr(or.DIV_BY_ZERO);const l=n.length,h=_i(r,i);if(h instanceof Tr)return h;const u=_i(t,a);return u instanceof Tr?u:Math.pow(-h*Math.pow(1+r,l)/u/(1+t),1/(l-1))-1}))}pduration(e,t){return this.runFunction(e.args,t,this.metadata("PDURATION"),((e,t,r)=>(Math.log(r)-Math.log(t))/Math.log(1+e)))}xnpv(e,t){return this.runFunction(e.args,t,this.metadata("XNPV"),((e,t,r)=>{const n=t.valuesFromTopLeftCorner();for(const e of n)if("number"!=typeof e)return new Tr(or.VALUE,Z.NumberExpected);const s=n,o=r.valuesFromTopLeftCorner();for(const e of o)if("number"!=typeof e)return new Tr(or.VALUE,Z.NumberExpected);const i=o;if(i.length!==s.length)return new Tr(or.NUM,Z.EqualLength);const a=i.length;let l=0;if(i[0]<0)return new Tr(or.NUM,Z.ValueSmall);for(let t=0;t<a;t++){if(i[t]=Math.floor(i[t]),i[t]<i[0])return new Tr(or.NUM,Z.ValueSmall);l+=s[t]/Math.pow(1+e,(i[t]-i[0])/365)}return l}))}}function vi(e,t,r,n,s){if(0===e)return(-r-n)/t;{const o=Math.pow(1+e,t);return(n*e+r*e*o)*(s?1/(1+e):1)/(1-o)}}function Si(e,t,r,n,s,o){const i=vi(e,r,n,s,o);return 1===t?e*(o?0:-n):e*(o?Ti(e,t-2,i,n,o)-i:Ti(e,t-1,i,n,o))}function Ti(e,t,r,n,s){if(0===e)return-n-r*t;{const o=Math.pow(1+e,t);return r*(s?1+e:1)*(1-o)/e-n*o}}function Ni(e,t,r,n,s,o){return vi(e,r,n,s,o)-Si(e,t,r,n,s,o)}function _i(e,t){let r=0;for(let n=t.length-1;n>=0;n--){if(r+=t[n],-1===e){if(0===r)continue;return new Tr(or.DIV_BY_ZERO)}r/=1+e}return r}Ri.implementedFunctions={PMT:{method:"pmt",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:0}],returnNumberType:Je.NUMBER_CURRENCY},IPMT:{method:"ipmt",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:0}],returnNumberType:Je.NUMBER_CURRENCY},PPMT:{method:"ppmt",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:0}],returnNumberType:Je.NUMBER_CURRENCY},FV:{method:"fv",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:0}],returnNumberType:Je.NUMBER_CURRENCY},CUMIPMT:{method:"cumipmt",parameters:[{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.INTEGER,minValue:1},{argumentType:hn.INTEGER,minValue:1},{argumentType:hn.INTEGER,minValue:0,maxValue:1}],returnNumberType:Je.NUMBER_CURRENCY},CUMPRINC:{method:"cumprinc",parameters:[{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.INTEGER,minValue:1},{argumentType:hn.INTEGER,minValue:1},{argumentType:hn.INTEGER,minValue:0,maxValue:1}],returnNumberType:Je.NUMBER_CURRENCY},DB:{method:"db",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.INTEGER,minValue:0},{argumentType:hn.INTEGER,minValue:0},{argumentType:hn.INTEGER,minValue:1,maxValue:12,defaultValue:12}],returnNumberType:Je.NUMBER_CURRENCY},DDB:{method:"ddb",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.INTEGER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,greaterThan:0,defaultValue:2}],returnNumberType:Je.NUMBER_CURRENCY},DOLLARDE:{method:"dollarde",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:0}]},DOLLARFR:{method:"dollarfr",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:0}]},EFFECT:{method:"effect",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:1}],returnNumberType:Je.NUMBER_PERCENT},ISPMT:{method:"ispmt",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]},NOMINAL:{method:"nominal",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:1}],returnNumberType:Je.NUMBER_PERCENT},NPER:{method:"nper",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:0}]},PV:{method:"pv",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:0}],returnNumberType:Je.NUMBER_CURRENCY},RATE:{method:"rate",parameters:[{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:.1}],returnNumberType:Je.NUMBER_PERCENT},RRI:{method:"rri",parameters:[{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}],returnNumberType:Je.NUMBER_PERCENT},SLN:{method:"sln",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}],returnNumberType:Je.NUMBER_CURRENCY},SYD:{method:"syd",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0}],returnNumberType:Je.NUMBER_CURRENCY},TBILLEQ:{method:"tbilleq",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,greaterThan:0}],returnNumberType:Je.NUMBER_PERCENT},TBILLPRICE:{method:"tbillprice",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,greaterThan:0}],returnNumberType:Je.NUMBER_CURRENCY},TBILLYIELD:{method:"tbillyield",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,greaterThan:0}],returnNumberType:Je.NUMBER_PERCENT},FVSCHEDULE:{method:"fvschedule",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.RANGE}],returnNumberType:Je.NUMBER_CURRENCY},NPV:{method:"npv",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.ANY}],repeatLastArgs:1,returnNumberType:Je.NUMBER_CURRENCY},MIRR:{method:"mirr",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}],returnNumberType:Je.NUMBER_PERCENT},PDURATION:{method:"pduration",parameters:[{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0}]},XNPV:{method:"xnpv",parameters:[{argumentType:hn.NUMBER,greaterThan:-1},{argumentType:hn.RANGE},{argumentType:hn.RANGE}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Mi extends un{formulatext(e,t){return this.runFunctionWithReferenceArgument(e.args,t,this.metadata("FORMULATEXT"),(()=>new Tr(or.NA,Z.WrongArgNumber)),(e=>{var t;return null!==(t=this.serialization.getCellFormula(e))&&void 0!==t?t:new Tr(or.NA,Z.Formula)}))}}Mi.implementedFunctions={FORMULATEXT:{method:"formulatext",parameters:[{argumentType:hn.NOERROR}],doesNotNeedArgumentsToBeComputed:!0,isDependentOnSheetStructureChange:!0,vectorizationForbidden:!0}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ai extends un{hyperlink(e,t){return this.runFunction(e.args,t,this.metadata("HYPERLINK"),((t,r)=>(e.hyperlink=t,null!=r?r:t)))}}Ai.implementedFunctions={HYPERLINK:{method:"hyperlink",parameters:[{argumentType:hn.STRING},{argumentType:hn.STRING,optionalArg:!0}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class bi extends un{isbinary(e,t){return this.runFunction(e.args,t,this.metadata("ISBINARY"),(e=>/^[01]{1,10}$/.test(e)))}iserr(e,t){return this.runFunction(e.args,t,this.metadata("ISERR"),(e=>e instanceof Tr&&e.type!==or.NA))}iserror(e,t){return this.runFunction(e.args,t,this.metadata("ISERROR"),(e=>e instanceof Tr))}isformula(e,t){return this.runFunctionWithReferenceArgument(e.args,t,this.metadata("ISFORMULA"),(()=>new Tr(or.NA,Z.WrongArgNumber)),(e=>this.dependencyGraph.addressMapping.getCell(e)instanceof Gt))}isblank(e,t){return this.runFunction(e.args,t,this.metadata("ISBLANK"),(e=>e===Ye))}isna(e,t){return this.runFunction(e.args,t,this.metadata("ISNA"),(e=>e instanceof Tr&&e.type==or.NA))}isnumber(e,t){return this.runFunction(e.args,t,this.metadata("ISNUMBER"),Ze)}islogical(e,t){return this.runFunction(e.args,t,this.metadata("ISLOGICAL"),(e=>"boolean"==typeof e))}isref(e,t){return this.runFunction(e.args,t,this.metadata("ISREF"),(e=>e instanceof Tr&&(e.type==or.REF||e.type==or.CYCLE)))}istext(e,t){return this.runFunction(e.args,t,this.metadata("ISTEXT"),(e=>"string"==typeof e))}isnontext(e,t){return this.runFunction(e.args,t,this.metadata("ISNONTEXT"),(e=>!("string"==typeof e)))}column(e,t){return this.runFunctionWithReferenceArgument(e.args,t,this.metadata("COLUMN"),(()=>t.formulaAddress.col+1),(e=>e.col+1))}columns(e,t){if(1!==e.args.length)return new Tr(or.NA,Z.WrongArgNumber);if(e.args.some((e=>e.type===U.EMPTY)))return new Tr(or.NUM,Z.EmptyArg);let r=e.args[0];for(;r.type===U.PARENTHESIS;)r=r.expression;if(r.type===U.CELL_RANGE||r.type===U.COLUMN_RANGE)return r.end.col-r.start.col+1;if(r.type===U.CELL_REFERENCE)return 1;if(r.type===U.ROW_RANGE)return this.config.maxColumns;{const e=this.evaluateAst(r,t);return e instanceof rt?e.width():e instanceof Tr?e:1}}row(e,t){return this.runFunctionWithReferenceArgument(e.args,t,this.metadata("ROW"),(()=>t.formulaAddress.row+1),(e=>e.row+1))}rows(e,t){if(1!==e.args.length)return new Tr(or.NA,Z.WrongArgNumber);if(e.args.some((e=>e.type===U.EMPTY)))return new Tr(or.NUM,Z.EmptyArg);let r=e.args[0];for(;r.type===U.PARENTHESIS;)r=r.expression;if(r.type===U.CELL_RANGE||r.type===U.ROW_RANGE)return r.end.row-r.start.row+1;if(r.type===U.CELL_REFERENCE)return 1;if(r.type===U.COLUMN_RANGE)return this.config.maxRows;{const e=this.evaluateAst(r,t);return e instanceof rt?e.height():e instanceof Tr?e:1}}index(e,t){return this.runFunction(e.args,t,this.metadata("INDEX"),((e,t,r)=>{var n,s,o,i,a,l;return r<1||t<1?new Tr(or.VALUE,Z.LessThanOne):r>e.width()||t>e.height()?new Tr(or.NUM,Z.ValueLarge):null!==(l=null!==(o=null===(s=null===(n=null==e?void 0:e.data)||void 0===n?void 0:n[t-1])||void 0===s?void 0:s[r-1])&&void 0!==o?o:null===(a=null===(i=null==e?void 0:e.data)||void 0===i?void 0:i[0])||void 0===a?void 0:a[0])&&void 0!==l?l:new Tr(or.VALUE,Z.CellRangeExpected)}))}na(e,t){return new Tr(or.NA)}sheet(e,t){return this.runFunctionWithReferenceArgument(e.args,t,this.metadata("SHEET"),(()=>t.formulaAddress.sheet+1),(e=>e.sheet+1),(e=>{const t=this.dependencyGraph.sheetMapping.get(e);return void 0!==t?t+1:new Tr(or.NA,Z.SheetRef)}))}sheets(e,t){return this.runFunctionWithReferenceArgument(e.args,t,this.metadata("SHEETS"),(()=>this.dependencyGraph.sheetMapping.numberOfSheets()),(()=>1),(()=>new Tr(or.VALUE,Z.CellRefExpected)))}}bi.implementedFunctions={COLUMN:{method:"column",parameters:[{argumentType:hn.NOERROR,optionalArg:!0}],isDependentOnSheetStructureChange:!0,doesNotNeedArgumentsToBeComputed:!0,vectorizationForbidden:!0},COLUMNS:{method:"columns",parameters:[{argumentType:hn.RANGE}],isDependentOnSheetStructureChange:!0,doesNotNeedArgumentsToBeComputed:!0,vectorizationForbidden:!0},ISBINARY:{method:"isbinary",parameters:[{argumentType:hn.STRING}]},ISERR:{method:"iserr",parameters:[{argumentType:hn.SCALAR}]},ISFORMULA:{method:"isformula",parameters:[{argumentType:hn.NOERROR}],doesNotNeedArgumentsToBeComputed:!0,vectorizationForbidden:!0},ISNA:{method:"isna",parameters:[{argumentType:hn.SCALAR}]},ISREF:{method:"isref",parameters:[{argumentType:hn.SCALAR}],vectorizationForbidden:!0},ISERROR:{method:"iserror",parameters:[{argumentType:hn.SCALAR}]},ISBLANK:{method:"isblank",parameters:[{argumentType:hn.SCALAR}]},ISNUMBER:{method:"isnumber",parameters:[{argumentType:hn.SCALAR}]},ISLOGICAL:{method:"islogical",parameters:[{argumentType:hn.SCALAR}]},ISTEXT:{method:"istext",parameters:[{argumentType:hn.SCALAR}]},ISNONTEXT:{method:"isnontext",parameters:[{argumentType:hn.SCALAR}]},INDEX:{method:"index",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:1}]},NA:{method:"na",parameters:[]},ROW:{method:"row",parameters:[{argumentType:hn.NOERROR,optionalArg:!0}],isDependentOnSheetStructureChange:!0,doesNotNeedArgumentsToBeComputed:!0,vectorizationForbidden:!0},ROWS:{method:"rows",parameters:[{argumentType:hn.RANGE}],isDependentOnSheetStructureChange:!0,doesNotNeedArgumentsToBeComputed:!0,vectorizationForbidden:!0},SHEET:{method:"sheet",parameters:[{argumentType:hn.STRING}],doesNotNeedArgumentsToBeComputed:!0,vectorizationForbidden:!0},SHEETS:{method:"sheets",parameters:[{argumentType:hn.STRING}],doesNotNeedArgumentsToBeComputed:!0,vectorizationForbidden:!0}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ii extends un{iseven(e,t){return this.runFunction(e.args,t,this.metadata("ISEVEN"),(e=>e%2==0))}}Ii.implementedFunctions={ISEVEN:{method:"iseven",parameters:[{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Oi extends un{isodd(e,t){return this.runFunction(e.args,t,this.metadata("ISODD"),(e=>e%2==1))}}Oi.implementedFunctions={ISODD:{method:"isodd",parameters:[{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class xi extends un{log10(e,t){return this.runFunction(e.args,t,this.metadata("LOG10"),Math.log10)}log(e,t){return this.runFunction(e.args,t,this.metadata("LOG"),((e,t)=>Math.log(e)/Math.log(t)))}ln(e,t){return this.runFunction(e.args,t,this.metadata("LN"),Math.log)}}xi.implementedFunctions={LOG10:{method:"log10",parameters:[{argumentType:hn.NUMBER}]},LOG:{method:"log",parameters:[{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,defaultValue:10,greaterThan:0}]},LN:{method:"ln",parameters:[{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const Pi=parseFloat(Math.PI.toFixed(14));class Li extends un{pi(e,t){return this.runFunction(e.args,t,this.metadata("PI"),(()=>Pi))}sqrtpi(e,t){return this.runFunction(e.args,t,this.metadata("SQRTPI"),(e=>Math.sqrt(Pi*e)))}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function Di(e,t){return new cn(t.width,e.height)}function ki(e,t,r){return new cn(1+(e.width-t)/r,1+(e.height-t)/r)}Li.implementedFunctions={PI:{method:"pi",parameters:[]},SQRTPI:{method:"sqrtpi",parameters:[{argumentType:hn.NUMBER,minValue:0}]}};class Hi extends un{mmult(e,t){return this.runFunction(e.args,t,this.metadata("MMULT"),((e,t)=>{if(!e.hasOnlyNumbers()||!t.hasOnlyNumbers())return new Tr(or.VALUE,Z.NumberRange);if(t.height()!==e.width())return new Tr(or.VALUE,Z.ArrayDimensions);const r=Di(e.size,t.size),n=this.createKernel((function(e,t,r){let n=0;for(let s=0;s<r;++s)n+=e[this.thread.y][s]*t[s][this.thread.x];return n}),r)(e.rawNumbers(),t.rawNumbers(),e.width());return rt.onlyNumbers(n)}))}mmultArraySize(e,t){if(2!==e.args.length)return cn.error();const r=this.metadata("MMULT"),n=e.args.map((e=>{var n;return this.arraySizeForAst(e,new Br(t.formulaAddress,t.arraysFlag||null!==(n=null==r?void 0:r.arrayFunction)&&void 0!==n&&n))})),[s,o]=n;return Di(s,o)}maxpool(e,t){return this.runFunction(e.args,t,this.metadata("MAXPOOL"),((e,t,r=t)=>{if(!e.hasOnlyNumbers())return new Tr(or.VALUE,Z.NumberRange);const n=ki(e.size,t,r),s=this.createKernel((function(e,t,r){const n=this.thread.x*r,s=this.thread.y*r;let o=e[s][n];for(let r=0;r<t;r++)for(let i=0;i<t;i++)o=Math.max(o,e[s+r][n+i]);return o}),n)(e.rawNumbers(),t,r);return rt.onlyNumbers(s)}))}medianpool(e,t){return this.runFunction(e.args,t,this.metadata("MEDIANPOOL"),((e,t,r=t)=>{if(!e.hasOnlyNumbers())return new Tr(or.VALUE,Z.NumberRange);const n=ki(e.size,t,r),s=this.createKernel((function(e,t,r){const n=this.thread.x*r,s=this.thread.y*r;let o=e[s][n];for(let r=0;r<t;r++)for(let i=0;i<t;i++)o=Math.max(o,e[s+r][n+i]);let i=e[s][n];for(let r=0;r<t;r++)for(let o=0;o<t;o++)i=Math.min(i,e[s+r][n+o]);const a=t*t;let l=i,h=o,u=42;for(let r=0;r<32;r++){const r=(l+h)/2;let o=0;for(let i=0;i<t;i++)for(let a=0;a<t;a++)e[s+i][n+a]>r&&o++;if(t%2==0){if(o===a/2){u=r;break}o>a/2?l=r:h=r}else{if(o===(a-1)/2){u=r;break}o>(a-1)/2?l=r:h=r}}return u}),n)(e.rawNumbers(),t,r);return rt.onlyNumbers(s)}))}maxpoolArraySize(e,t){if(e.args.length<2||e.args.length>3)return cn.error();const r=this.metadata("MAXPOOL"),n=e.args.map((e=>{var n;return this.arraySizeForAst(e,new Br(t.formulaAddress,t.arraysFlag||null!==(n=null==r?void 0:r.arrayFunction)&&void 0!==n&&n))}))[0],s=e.args[1];let o;o=s.type===U.NUMBER?s.value:1;let i=o;if(3===e.args.length){const t=e.args[2];i=t.type===U.NUMBER?t.value:1}return o>n.width||o>n.height||i>o||(n.width-o)%i!=0||(n.height-o)%i!=0?cn.error():ki(n,o,i)}medianpoolArraySize(e,t){return this.maxpoolArraySize(e,t)}transpose(e,t){return this.runFunction(e.args,t,this.metadata("TRANSPOSE"),(e=>{const t=e.rawData(),r=e.size,n=[];for(let e=0;e<r.width;++e){n[e]=[];for(let s=0;s<r.height;++s)n[e][s]=t[s][e]}return rt.onlyValues(n)}))}transposeArraySize(e,t){if(1!==e.args.length)return cn.error();const r=this.metadata("TRANSPOSE"),n=e.args.map((e=>{var n;return this.arraySizeForAst(e,new Br(t.formulaAddress,t.arraysFlag||null!==(n=null==r?void 0:r.arrayFunction)&&void 0!==n&&n))})),[s]=n;return new cn(s.height,s.width)}createKernel(e,t){return function(...r){const n=[];for(let s=0;s<t.height;++s){n.push([]);for(let o=0;o<t.width;++o)n[s][o]=e.apply({thread:{x:o,y:s}},r)}return n}}}Hi.implementedFunctions={MMULT:{method:"mmult",arraySizeMethod:"mmultArraySize",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}],vectorizationForbidden:!0},TRANSPOSE:{method:"transpose",arraySizeMethod:"transposeArraySize",parameters:[{argumentType:hn.RANGE}],vectorizationForbidden:!0},MAXPOOL:{method:"maxpool",arraySizeMethod:"maxpoolArraySize",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,optionalArg:!0}],vectorizationForbidden:!0},MEDIANPOOL:{method:"medianpool",arraySizeMethod:"medianpoolArraySize",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,optionalArg:!0}],vectorizationForbidden:!0}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Fi extends un{median(e,t){return this.runFunction(e.args,t,this.metadata("MEDIAN"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersExactRanges(e);return t instanceof Tr?t:0===t.length?new Tr(or.NUM,Z.OneValue):(t.sort(((e,t)=>e-t)),t.length%2==0?(t[t.length/2-1]+t[t.length/2])/2:t[Math.floor(t.length/2)])}))}large(e,t){return this.runFunction(e.args,t,this.metadata("LARGE"),((e,t)=>{const r=this.arithmeticHelper.manyToExactNumbers(e.valuesFromTopLeftCorner());return r instanceof Tr?r:(r.sort(((e,t)=>e-t)),(t=Math.trunc(t))>r.length?new Tr(or.NUM,Z.ValueLarge):r[r.length-t])}))}small(e,t){return this.runFunction(e.args,t,this.metadata("SMALL"),((e,t)=>{const r=this.arithmeticHelper.manyToExactNumbers(e.valuesFromTopLeftCorner());return r instanceof Tr?r:(r.sort(((e,t)=>e-t)),(t=Math.trunc(t))>r.length?new Tr(or.NUM,Z.ValueLarge):r[t-1])}))}}Fi.implementedFunctions={MEDIAN:{method:"median",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},LARGE:{method:"large",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NUMBER,minValue:1}]},SMALL:{method:"small",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NUMBER,minValue:1}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ui extends un{mod(e,t){return this.runFunction(e.args,t,this.metadata("MOD"),((e,t)=>0===t?new Tr(or.DIV_BY_ZERO):e%t))}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function Vi(e){return Ze(e)&&!Number.isFinite(je(e))?0:e}Ui.implementedFunctions={MOD:{method:"mod",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]}};class Bi{constructor(e,t,r){this.sumsq=e,this.sum=t,this.count=r}static single(e){return new Bi(e*e,e,1)}compose(e){return new Bi(this.sumsq+e.sumsq,this.sum+e.sum,this.count+e.count)}averageValue(){return this.count>0?this.sum/this.count:void 0}varSValue(){return this.count>1?(this.sumsq-this.sum*this.sum/this.count)/(this.count-1):void 0}varPValue(){return this.count>0?(this.sumsq-this.sum*this.sum/this.count)/this.count:void 0}}Bi.empty=new Bi(0,0,0);class Wi extends un{constructor(){super(...arguments),this.addWithEpsilonRaw=(e,t)=>this.arithmeticHelper.addWithEpsilonRaw(e,t)}sum(e,t){return this.doSum(e.args,t)}sumsq(e,t){return this.reduce(e.args,t,0,"SUMSQ",this.addWithEpsilonRaw,(e=>Math.pow(je(e),2)),Yi)}max(e,t){return this.doMax(e.args,t)}maxa(e,t){return Vi(this.reduce(e.args,t,Number.NEGATIVE_INFINITY,"MAXA",((e,t)=>Math.max(e,t)),je,ji))}min(e,t){return this.doMin(e.args,t)}mina(e,t){return Vi(this.reduce(e.args,t,Number.POSITIVE_INFINITY,"MINA",((e,t)=>Math.min(e,t)),je,ji))}count(e,t){return this.doCount(e.args,t)}counta(e,t){return this.doCounta(e.args,t)}average(e,t){return this.doAverage(e.args,t)}averagea(e,t){var r;const n=this.reduce(e.args,t,Bi.empty,"_AGGREGATE_A",((e,t)=>e.compose(t)),(e=>Bi.single(je(e))),ji);return n instanceof Tr?n:null!==(r=n.averageValue())&&void 0!==r?r:new Tr(or.DIV_BY_ZERO)}vars(e,t){return this.doVarS(e.args,t)}varp(e,t){return this.doVarP(e.args,t)}vara(e,t){var r;const n=this.reduceAggregateA(e.args,t);return n instanceof Tr?n:null!==(r=n.varSValue())&&void 0!==r?r:new Tr(or.DIV_BY_ZERO)}varpa(e,t){var r;const n=this.reduceAggregateA(e.args,t);return n instanceof Tr?n:null!==(r=n.varPValue())&&void 0!==r?r:new Tr(or.DIV_BY_ZERO)}stdevs(e,t){return this.doStdevS(e.args,t)}stdevp(e,t){return this.doStdevP(e.args,t)}stdeva(e,t){const r=this.reduceAggregateA(e.args,t);if(r instanceof Tr)return r;{const e=r.varSValue();return void 0===e?new Tr(or.DIV_BY_ZERO):Math.sqrt(e)}}stdevpa(e,t){const r=this.reduceAggregateA(e.args,t);if(r instanceof Tr)return r;{const e=r.varPValue();return void 0===e?new Tr(or.DIV_BY_ZERO):Math.sqrt(e)}}product(e,t){return this.doProduct(e.args,t)}subtotal(e,t){if(e.args.length<2)return new Tr(or.NA,Z.WrongArgNumber);const r=this.coerceToType(this.evaluateAst(e.args[0],t),{argumentType:hn.NUMBER},t),n=e.args.slice(1);switch(r){case 1:case 101:return this.doAverage(n,t);case 2:case 102:return this.doCount(n,t);case 3:case 103:return this.doCounta(n,t);case 4:case 104:return this.doMax(n,t);case 5:case 105:return this.doMin(n,t);case 6:case 106:return this.doProduct(n,t);case 7:case 107:return this.doStdevS(n,t);case 8:case 108:return this.doStdevP(n,t);case 9:case 109:return this.doSum(n,t);case 10:case 110:return this.doVarS(n,t);case 11:case 111:return this.doVarP(n,t);default:return new Tr(or.VALUE,Z.BadMode)}}reduceAggregate(e,t){return this.reduce(e,t,Bi.empty,"_AGGREGATE",((e,t)=>e.compose(t)),(e=>Bi.single(je(e))),Yi)}reduceAggregateA(e,t){return this.reduce(e,t,Bi.empty,"_AGGREGATE_A",((e,t)=>e.compose(t)),(e=>Bi.single(je(e))),ji)}doAverage(e,t){var r;const n=this.reduceAggregate(e,t);return n instanceof Tr?n:null!==(r=n.averageValue())&&void 0!==r?r:new Tr(or.DIV_BY_ZERO)}doVarS(e,t){var r;const n=this.reduceAggregate(e,t);return n instanceof Tr?n:null!==(r=n.varSValue())&&void 0!==r?r:new Tr(or.DIV_BY_ZERO)}doVarP(e,t){var r;const n=this.reduceAggregate(e,t);return n instanceof Tr?n:null!==(r=n.varPValue())&&void 0!==r?r:new Tr(or.DIV_BY_ZERO)}doStdevS(e,t){const r=this.reduceAggregate(e,t);if(r instanceof Tr)return r;{const e=r.varSValue();return void 0===e?new Tr(or.DIV_BY_ZERO):Math.sqrt(e)}}doStdevP(e,t){const r=this.reduceAggregate(e,t);if(r instanceof Tr)return r;{const e=r.varPValue();return void 0===e?new Tr(or.DIV_BY_ZERO):Math.sqrt(e)}}doCount(e,t){return this.reduce(e,t,0,"COUNT",((e,t)=>e+t),je,(e=>Ze(e)?1:0))}doCounta(e,t){return this.reduce(e,t,0,"COUNTA",((e,t)=>e+t),je,(e=>e===Ye?0:1))}doMax(e,t){return Vi(this.reduce(e,t,Number.NEGATIVE_INFINITY,"MAX",((e,t)=>Math.max(e,t)),je,Yi))}doMin(e,t){return Vi(this.reduce(e,t,Number.POSITIVE_INFINITY,"MIN",((e,t)=>Math.min(e,t)),je,Yi))}doSum(e,t){return this.reduce(e,t,0,"SUM",this.addWithEpsilonRaw,je,Yi)}doProduct(e,t){return this.reduce(e,t,1,"PRODUCT",((e,t)=>e*t),je,Yi)}reduce(e,t,r,n,s,o,i){return e.length<1?new Tr(or.NA,Z.WrongArgNumber):e.reduce(((e,a)=>{if(e instanceof Tr)return e;if(a.type===U.CELL_RANGE||a.type===U.COLUMN_RANGE||a.type===U.ROW_RANGE){const l=this.evaluateRange(a,t,r,n,s,o,i);return l instanceof Tr?l:s(l,e)}let l;if(l=this.evaluateAst(a,t),l instanceof rt){const t=Array.from(l.valuesFromTopLeftCorner()).map(i).filter((e=>void 0!==e));return t.map((e=>e instanceof Tr?e:o(e))).reduce(((e,t)=>e instanceof Tr?e:t instanceof Tr?t:s(e,t)),e)}if(a.type===U.CELL_REFERENCE){if(l=i(l),void 0===l)return e}else if(l=this.coerceScalarToNumberOrError(l),l=i(l),void 0===l)return e;return l instanceof Tr?l:s(e,o(l))}),r)}evaluateRange(e,t,r,n,s,o,i){let a;try{a=Fr.fromAst(e,t.formulaAddress)}catch(e){if(e instanceof ft)return new Tr(or.REF,Z.RangeManySheets);throw e}const l=this.dependencyGraph.getRange(a.start,a.end);if(void 0===l)throw new Error("Range does not exists in graph");let h=l.getFunctionValue(n);if(void 0===h){h=this.getRangeValues(n,a,l,o,i).reduce(((e,t)=>e instanceof Tr?e:t instanceof Tr?t:s(e,t)),r),l.setFunctionValue(n,h)}return h}getRangeValues(e,t,r,n,s){const o=[],{smallerRangeVertex:i,restRange:a}=this.dependencyGraph.rangeMapping.findSmallerRange(t);let l;if(void 0!==i&&this.dependencyGraph.existsEdge(i,r)){const t=i.getFunctionValue(e);if(void 0!==t)o.push(t);else for(const e of i.range.addresses(this.dependencyGraph)){const t=s(this.dependencyGraph.getScalarValue(e));t instanceof Tr?o.push(t):void 0!==t&&o.push(n(t))}l=a}else l=t;for(const e of l.addresses(this.dependencyGraph)){const t=s(this.dependencyGraph.getScalarValue(e));t instanceof Tr?o.push(t):void 0!==t&&o.push(n(t))}return o}}function Yi(e){return Ze(e)||e instanceof Tr?e:void 0}function ji(e){return"boolean"==typeof e?zr(e):Ze(e)||e instanceof Tr?e:"string"==typeof e?0:void 0}Wi.implementedFunctions={SUM:{method:"sum",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},SUMSQ:{method:"sumsq",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},MAX:{method:"max",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},MIN:{method:"min",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},MAXA:{method:"maxa",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},MINA:{method:"mina",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},COUNT:{method:"count",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},COUNTA:{method:"counta",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},AVERAGE:{method:"average",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},AVERAGEA:{method:"averagea",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},PRODUCT:{method:"product",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},"VAR.S":{method:"vars",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},"VAR.P":{method:"varp",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},VARA:{method:"vara",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},VARPA:{method:"varpa",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},"STDEV.S":{method:"stdevs",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},"STDEV.P":{method:"stdevp",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},STDEVA:{method:"stdeva",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},STDEVPA:{method:"stdevpa",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},SUBTOTAL:{method:"subtotal",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.ANY}],repeatLastArgs:1}},Wi.aliases={VAR:"VAR.S",VARP:"VAR.P",STDEV:"STDEV.S",STDEVP:"STDEV.P",VARS:"VAR.S",STDEVS:"STDEV.S"};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Gi extends un{power(e,t){return this.runFunction(e.args,t,this.metadata("POWER"),Math.pow)}}Gi.implementedFunctions={POWER:{method:"power",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class zi extends un{radians(e,t){return this.runFunction(e.args,t,this.metadata("RADIANS"),(e=>e*(Math.PI/180)))}}zi.implementedFunctions={RADIANS:{method:"radians",parameters:[{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const $i=10;class Ki extends un{dec2bin(e,t){return this.runFunction(e.args,t,this.metadata("DEC2BIN"),((e,t)=>qi(e,2,t)))}dec2oct(e,t){return this.runFunction(e.args,t,this.metadata("DEC2OCT"),((e,t)=>qi(e,8,t)))}dec2hex(e,t){return this.runFunction(e.args,t,this.metadata("DEC2HEX"),((e,t)=>qi(e,16,t)))}bin2dec(e,t){return this.runFunction(e.args,t,this.metadata("BIN2DEC"),(e=>{const t=Xi(e,2,$i);return void 0===t?new Tr(or.NUM,Z.NotBinary):ea(t,2)}))}bin2oct(e,t){return this.runFunction(e.args,t,this.metadata("BIN2OCT"),((e,t)=>{const r=Xi(e,2,$i);return void 0===r?new Tr(or.NUM,Z.NotBinary):qi(ea(r,2),8,t)}))}bin2hex(e,t){return this.runFunction(e.args,t,this.metadata("BIN2HEX"),((e,t)=>{const r=Xi(e,2,$i);return void 0===r?new Tr(or.NUM,Z.NotBinary):qi(ea(r,2),16,t)}))}oct2dec(e,t){return this.runFunction(e.args,t,this.metadata("OCT2DEC"),(e=>{const t=Xi(e,8,$i);return void 0===t?new Tr(or.NUM,Z.NotOctal):ea(t,8)}))}oct2bin(e,t){return this.runFunction(e.args,t,this.metadata("OCT2BIN"),((e,t)=>{const r=Xi(e,8,$i);return void 0===r?new Tr(or.NUM,Z.NotOctal):qi(ea(r,8),2,t)}))}oct2hex(e,t){return this.runFunction(e.args,t,this.metadata("OCT2HEX"),((e,t)=>{const r=Xi(e,8,$i);return void 0===r?new Tr(or.NUM,Z.NotOctal):qi(ea(r,8),16,t)}))}hex2dec(e,t){return this.runFunction(e.args,t,this.metadata("HEX2DEC"),(e=>{const t=Xi(e,16,$i);return void 0===t?new Tr(or.NUM,Z.NotHex):ea(t,16)}))}hex2bin(e,t){return this.runFunction(e.args,t,this.metadata("HEX2BIN"),((e,t)=>{const r=Xi(e,16,$i);return void 0===r?new Tr(or.NUM,Z.NotHex):qi(ea(r,16),2,t)}))}hex2oct(e,t){return this.runFunction(e.args,t,this.metadata("HEX2OCT"),((e,t)=>{const r=Xi(e,16,$i);return void 0===r?new Tr(or.NUM,Z.NotHex):qi(ea(r,16),8,t)}))}base(e,t){return this.runFunction(e.args,t,this.metadata("BASE"),Zi)}decimal(e,t){return this.runFunction(e.args,t,this.metadata("DECIMAL"),((e,t)=>{const r=Xi(e,t,255);return void 0===r?new Tr(or.NUM,Z.NotHex):parseInt(r,t)}))}}function Xi(e,t,r){const n="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".substr(0,t),s=new RegExp(`^[${n}]+$`);if(!(e.length>r)&&s.test(e))return e}function qi(e,t,r){if(e>function(e){return-Qi(e)-1}(t))return new Tr(or.NUM,Z.ValueBaseLarge);if(e<Qi(t))return new Tr(or.NUM,Z.ValueBaseSmall);const n=Ji(e,t);return void 0===r||e<0?n:n.length>r?new Tr(or.NUM,Z.ValueBaseLong):Jn(n,r)}function Qi(e){return-Math.pow(e,$i)/2}function Zi(e,t,r){const n=Ji(e,t);return void 0!==r&&r>n.length?Jn(n,r):n}function Ji(e,t){return(e+(e<0?Math.pow(t,$i):0)).toString(t).toUpperCase()}function ea(e,t){const r=parseInt(e,t),n=Math.pow(t,$i);return r>=n/2?r-n:r}Ki.implementedFunctions={DEC2BIN:{method:"dec2bin",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,optionalArg:!0,minValue:1,maxValue:10}]},DEC2OCT:{method:"dec2oct",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,optionalArg:!0,minValue:1,maxValue:10}]},DEC2HEX:{method:"dec2hex",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,optionalArg:!0,minValue:1,maxValue:10}]},BIN2DEC:{method:"bin2dec",parameters:[{argumentType:hn.STRING}]},BIN2OCT:{method:"bin2oct",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,optionalArg:!0,minValue:0,maxValue:$i}]},BIN2HEX:{method:"bin2hex",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,optionalArg:!0,minValue:0,maxValue:$i}]},OCT2DEC:{method:"oct2dec",parameters:[{argumentType:hn.STRING}]},OCT2BIN:{method:"oct2bin",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,optionalArg:!0,minValue:0,maxValue:$i}]},OCT2HEX:{method:"oct2hex",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,optionalArg:!0,minValue:0,maxValue:$i}]},HEX2DEC:{method:"hex2dec",parameters:[{argumentType:hn.STRING}]},HEX2BIN:{method:"hex2bin",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,optionalArg:!0,minValue:0,maxValue:$i}]},HEX2OCT:{method:"hex2oct",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,optionalArg:!0,minValue:0,maxValue:$i}]},DECIMAL:{method:"decimal",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,minValue:2,maxValue:36}]},BASE:{method:"base",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:2,maxValue:36},{argumentType:hn.NUMBER,optionalArg:!0,minValue:0,maxValue:255}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ta extends un{rand(e,t){return this.runFunction(e.args,t,this.metadata("RAND"),Math.random)}randbetween(e,t){return this.runFunction(e.args,t,this.metadata("RANDBETWEEN"),((e,t)=>t<e?new Tr(or.NUM,Z.WrongOrder):((e=Math.ceil(e))===(t=Math.floor(t)+1)&&(t+=1),e+Math.floor(Math.random()*(t-e)))))}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function ra(e){const t=Math.ceil(e);return t%2==1?t:t+1}function na(e){const t=Math.ceil(e);return t%2==0?t:t+1}ta.implementedFunctions={RAND:{method:"rand",parameters:[],isVolatile:!0},RANDBETWEEN:{method:"randbetween",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}],isVolatile:!0}};class sa extends un{roundup(e,t){return this.runFunction(e.args,t,this.metadata("ROUNDDOWN"),((e,t)=>{const r=Math.pow(10,t);return e<0?-Math.ceil(-e*r)/r:Math.ceil(e*r)/r}))}rounddown(e,t){return this.runFunction(e.args,t,this.metadata("ROUNDDOWN"),((e,t)=>{const r=Math.pow(10,t);return e<0?-Math.floor(-e*r)/r:Math.floor(e*r)/r}))}round(e,t){return this.runFunction(e.args,t,this.metadata("ROUND"),((e,t)=>{const r=Math.pow(10,t);return e<0?-Math.round(-e*r)/r:Math.round(e*r)/r}))}intFunc(e,t){return this.runFunction(e.args,t,this.metadata("INT"),(e=>e<0?-Math.floor(-e):Math.floor(e)))}even(e,t){return this.runFunction(e.args,t,this.metadata("EVEN"),(e=>e<0?-na(-e):na(e)))}odd(e,t){return this.runFunction(e.args,t,this.metadata("ODD"),(e=>e<0?-ra(-e):ra(e)))}ceilingmath(e,t){return this.runFunction(e.args,t,this.metadata("CEILING.MATH"),((e,t,r)=>0===t||0===e?0:(t=Math.abs(t),1===r&&e<0&&(t=-t),Math.ceil(e/t)*t)))}ceiling(e,t){return this.runFunction(e.args,t,this.metadata("CEILING"),((e,t)=>0===e?0:0===t?new Tr(or.DIV_BY_ZERO):e>0&&t<0?new Tr(or.NUM,Z.DistinctSigns):Math.ceil(e/t)*t))}ceilingprecise(e,t){return this.runFunction(e.args,t,this.metadata("CEILING.PRECISE"),((e,t)=>0===t||0===e?0:(t=Math.abs(t),Math.ceil(e/t)*t)))}floormath(e,t){return this.runFunction(e.args,t,this.metadata("FLOOR.MATH"),((e,t,r)=>0===t||0===e?0:(t=Math.abs(t),1===r&&e<0&&(t*=-1),Math.floor(e/t)*t)))}floor(e,t){return this.runFunction(e.args,t,this.metadata("FLOOR"),((e,t)=>0===e?0:0===t?new Tr(or.DIV_BY_ZERO):e>0&&t<0?new Tr(or.NUM,Z.DistinctSigns):Math.floor(e/t)*t))}floorprecise(e,t){return this.runFunction(e.args,t,this.metadata("FLOOR.PRECISE"),((e,t)=>0===t||0===e?0:(t=Math.abs(t),Math.floor(e/t)*t)))}}sa.implementedFunctions={ROUNDUP:{method:"roundup",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0}]},ROUNDDOWN:{method:"rounddown",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0}]},ROUND:{method:"round",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0}]},INT:{method:"intFunc",parameters:[{argumentType:hn.NUMBER}]},EVEN:{method:"even",parameters:[{argumentType:hn.NUMBER}]},ODD:{method:"odd",parameters:[{argumentType:hn.NUMBER}]},"CEILING.MATH":{method:"ceilingmath",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:1},{argumentType:hn.NUMBER,defaultValue:0}]},CEILING:{method:"ceiling",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]},"CEILING.PRECISE":{method:"ceilingprecise",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:1}]},"FLOOR.MATH":{method:"floormath",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:1},{argumentType:hn.NUMBER,defaultValue:0}]},FLOOR:{method:"floor",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]},"FLOOR.PRECISE":{method:"floorprecise",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:1}]}},sa.aliases={"ISO.CEILING":"CEILING.PRECISE",TRUNC:"ROUNDDOWN"};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class oa extends un{sqrt(e,t){return this.runFunction(e.args,t,this.metadata("SQRT"),Math.sqrt)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function*ia(){}function aa(e){const t=e[Symbol.iterator](),{done:r,value:n}=t.next();return r?{rest:ia()}:{value:n,rest:t}}oa.implementedFunctions={SQRT:{method:"sqrt",parameters:[{argumentType:hn.NUMBER}]}};class la{constructor(e,t,r,n,s){this.interpreter=e,this.cacheKey=t,this.reduceInitialValue=r,this.composeFunction=n,this.mapFunction=s,this.dependencyGraph=this.interpreter.dependencyGraph}compute(e,t){for(const r of t)if(!r.conditionRange.sameDimensionsAs(e))return new Tr(or.VALUE,Z.EqualLength);const r=this.tryToGetRangeVertexForRangeValue(e),n=t.map((e=>this.tryToGetRangeVertexForRangeValue(e.conditionRange)));if(r&&n.every((e=>void 0!==e))){const s=t.map((e=>e.criterionPackage.raw)).join(","),o=this.findAlreadyComputedValueInCache(r,this.cacheKey(t),s);if(void 0!==o)return this.interpreter.stats.incrementCriterionFunctionFullCacheUsed(),o;const i=this.buildNewCriterionCache(this.cacheKey(t),t.map((e=>e.conditionRange.range)),e.range);return i.has(s)||i.set(s,[this.evaluateRangeValue(e,t),t.map((e=>e.criterionPackage.lambda))]),r.setCriterionFunctionValues(this.cacheKey(t),i),n.forEach((e=>{void 0!==e&&e.addDependentCacheRange(r)})),i.get(s)[0]}return this.evaluateRangeValue(e,t)}tryToGetRangeVertexForRangeValue(e){const t=e.range;return void 0===t?void 0:this.dependencyGraph.getRange(t.start,t.end)}reduceFunction(e){let t=this.reduceInitialValue;for(const r of e)t=this.composeFunction(t,r);return t}findAlreadyComputedValueInCache(e,t,r){return e.getCriterionFunctionValue(t,r)}evaluateRangeValue(e,t){const r=t.map((e=>e.criterionPackage.lambda)),n=Array.from(e.valuesFromTopLeftCorner()).map(this.mapFunction)[Symbol.iterator](),s=ca(r,t.map((e=>e.conditionRange.iterateValuesFromTopLeftCorner())),n);return this.reduceFunction(s)}buildNewCriterionCache(e,t,r){const n=this.dependencyGraph.getRange(r.start,r.end),{smallerRangeVertex:s,restConditionRanges:o,restValuesRange:i}=((e,t,r)=>{if(r.end.row>r.start.row){const n=br(r.end.sheet,r.end.col,r.end.row-1),s=e.getRange(r.start,n);if(void 0!==s)return{smallerRangeVertex:s,restValuesRange:r.withStart(br(r.start.sheet,r.start.col,r.end.row)),restConditionRanges:t.map((e=>e.withStart(br(e.start.sheet,e.start.col,e.end.row))))}}return{restValuesRange:r,restConditionRanges:t}})(this.dependencyGraph,t,r);let a;a=void 0!==s&&this.dependencyGraph.existsEdge(s,n)?s.getCriterionFunctionValues(e):new Map;const l=new Map;return a.forEach((([e,t],r)=>{const n=ca(t,o.map((e=>ua(this.dependencyGraph,e))),Array.from(ua(this.dependencyGraph,i)).map(this.mapFunction)[Symbol.iterator]()),s=this.composeFunction(e,this.reduceFunction(n));this.interpreter.stats.incrementCriterionFunctionPartialCacheUsed(),l.set(r,[s,t])})),l}}class ha{constructor(e,t){this.conditionRange=e,this.criterionPackage=t}}function*ua(e,t){for(const r of t.addresses(e))yield je(e.getScalarValue(r))}function*ca(e,t,r){for(const n of r){const r=t.map((e=>aa(e)));if(!r.every((e=>Object.prototype.hasOwnProperty.call(e,"value"))))return;da(r.map((e=>je(e.value))),e).every((([e,t])=>t(e)))&&(yield n),t=r.map((e=>e.rest))}}function da(e,t){const r=[];for(let n=0;n<Math.min(e.length,t.length);n++)r.push([e[n],t[n]]);return r}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class pa{constructor(e,t){this.sum=e,this.count=t}static single(e){return new pa(e,1)}compose(e){return new pa(this.sum+e.sum,this.count+e.count)}averageValue(){return this.count>0?this.sum/this.count:void 0}}function ga(e){return Ze(e)&&!Number.isFinite(je(e))?0:e}function fa(e){return e instanceof Tr?e:Ze(e)?je(e):void 0}pa.empty=new pa(0,0);class ma extends un{sumif(e,t){const r="SUMIF";return this.runFunction(e.args,t,this.metadata(r),((e,t,n)=>this.computeConditionalAggregationFunction(null!=n?n:e,[e,t],r,0,((e,t)=>this.arithmeticHelper.nonstrictadd(e,t)),fa)))}sumifs(e,t){const r="SUMIFS";return this.runFunction(e.args,t,this.metadata(r),((e,...t)=>this.computeConditionalAggregationFunction(e,t,r,0,((e,t)=>this.arithmeticHelper.nonstrictadd(e,t)),fa)))}averageif(e,t){const r="AVERAGEIF";return this.runFunction(e.args,t,this.metadata(r),((e,t,n)=>{const s=this.computeConditionalAggregationFunction(null!=n?n:e,[e,t],r,pa.empty,((e,t)=>e.compose(t)),(e=>Ze(e)?pa.single(je(e)):pa.empty));return s instanceof Tr?s:s.averageValue()||new Tr(or.DIV_BY_ZERO)}))}countif(e,t){const r="COUNTIF";return this.runFunction(e.args,t,this.metadata(r),((e,t)=>this.computeConditionalAggregationFunction(e,[e,t],r,0,((e,t)=>e+t),(()=>1))))}countifs(e,t){const r="COUNTIFS";return this.runFunction(e.args,t,this.metadata(r),((...e)=>this.computeConditionalAggregationFunction(e[0],e,r,0,((e,t)=>e+t),(()=>1))))}minifs(e,t){const r="MINIFS",n=(e,t)=>void 0===t||void 0===e?void 0===t?e:t:Math.min(e,t);return this.runFunction(e.args,t,this.metadata(r),((e,...t)=>ga(this.computeConditionalAggregationFunction(e,t,r,Number.POSITIVE_INFINITY,n,fa))))}maxifs(e,t){const r="MAXIFS",n=(e,t)=>void 0===t||void 0===e?void 0===t?e:t:Math.max(e,t);return this.runFunction(e.args,t,this.metadata(r),((e,...t)=>ga(this.computeConditionalAggregationFunction(e,t,r,Number.NEGATIVE_INFINITY,n,fa))))}computeConditionalAggregationFunction(e,t,r,n,s,o){const i=[];for(let e=0;e<t.length;e+=2){const r=t[e],n=this.interpreter.criterionBuilder.fromCellValue(t[e+1],this.arithmeticHelper);if(void 0===n)return new Tr(or.VALUE,Z.BadCriterion);i.push(new ha(r,n))}return new la(this.interpreter,function(e){return t=>{const r=t.map((e=>`${e.conditionRange.range.sheet},${e.conditionRange.range.start.col},${e.conditionRange.range.start.row}`));return[e,...r].join(",")}}(r),n,s,o).compute(e,i)}}ma.implementedFunctions={SUMIF:{method:"sumif",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NOERROR},{argumentType:hn.RANGE,optionalArg:!0}]},COUNTIF:{method:"countif",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NOERROR}]},AVERAGEIF:{method:"averageif",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NOERROR},{argumentType:hn.RANGE,optionalArg:!0}]},SUMIFS:{method:"sumifs",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE},{argumentType:hn.NOERROR}],repeatLastArgs:2},COUNTIFS:{method:"countifs",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NOERROR}],repeatLastArgs:2},MINIFS:{method:"minifs",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE},{argumentType:hn.NOERROR}],repeatLastArgs:2},MAXIFS:{method:"maxifs",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE},{argumentType:hn.NOERROR}],repeatLastArgs:2}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ea extends un{sumproduct(e,t){return this.runFunction(e.args,t,this.metadata("SUMPRODUCT"),((...e)=>{const t=e[0].width(),r=e[0].height();for(const n of e)if(n.width()!==t||n.height()!==r)return new Tr(or.VALUE,Z.EqualLength);let n=0;const s=e.map((e=>e.iterateValuesFromTopLeftCorner()));for(let e=0;e<t*r;e++){let e=1;for(const t of s){const r=t.next().value;if(r instanceof Tr)return r;const n=this.coerceScalarToNumberOrError(r);Ze(n)?e*=je(n):e=0}n+=e}return n}))}}Ea.implementedFunctions={SUMPRODUCT:{method:"sumproduct",parameters:[{argumentType:hn.RANGE}],repeatLastArgs:1}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ya extends un{concatenate(e,t){return this.runFunction(e.args,t,this.metadata("CONCATENATE"),((...e)=>"".concat(...e)))}split(e,t){return this.runFunction(e.args,t,this.metadata("SPLIT"),((e,t)=>{const r=e.split(" ");return t>=r.length||t<0?new Tr(or.VALUE,Z.IndexBounds):r[t]}))}len(e,t){return this.runFunction(e.args,t,this.metadata("LEN"),(e=>e.length))}lower(e,t){return this.runFunction(e.args,t,this.metadata("LOWER"),(e=>e.toLowerCase()))}trim(e,t){return this.runFunction(e.args,t,this.metadata("TRIM"),(e=>e.replace(/^ +| +$/g,"").replace(/ +/g," ")))}proper(e,t){return this.runFunction(e.args,t,this.metadata("PROPER"),(e=>e.replace(/\p{L}+/gu,(e=>e.charAt(0).toUpperCase()+e.substring(1).toLowerCase()))))}clean(e,t){return this.runFunction(e.args,t,this.metadata("CLEAN"),(e=>e.replace(/[\u0000-\u001F]/g,"")))}exact(e,t){return this.runFunction(e.args,t,this.metadata("EXACT"),((e,t)=>e===t))}rept(e,t){return this.runFunction(e.args,t,this.metadata("REPT"),((e,t)=>t<0?new Tr(or.VALUE,Z.NegativeCount):e.repeat(t)))}right(e,t){return this.runFunction(e.args,t,this.metadata("RIGHT"),((e,t)=>t<0?new Tr(or.VALUE,Z.NegativeLength):0===t?"":e.slice(-t)))}left(e,t){return this.runFunction(e.args,t,this.metadata("LEFT"),((e,t)=>t<0?new Tr(or.VALUE,Z.NegativeLength):e.slice(0,t)))}mid(e,t){return this.runFunction(e.args,t,this.metadata("MID"),((e,t,r)=>t<1?new Tr(or.VALUE,Z.LessThanOne):r<0?new Tr(or.VALUE,Z.NegativeLength):e.substring(t-1,t+r-1)))}replace(e,t){return this.runFunction(e.args,t,this.metadata("REPLACE"),((e,t,r,n)=>t<1?new Tr(or.VALUE,Z.LessThanOne):r<0?new Tr(or.VALUE,Z.NegativeLength):e.substring(0,t-1)+n+e.substring(t+r-1)))}search(e,t){return this.runFunction(e.args,t,this.metadata("SEARCH"),((e,t,r)=>{if(r<1||r>t.length)return new Tr(or.VALUE,Z.LengthBounds);const n=e.toLowerCase(),s=t.substring(r-1).toLowerCase(),o=this.arithmeticHelper.requiresRegex(n)?this.arithmeticHelper.searchString(n,s):s.indexOf(n);return o>-1?o+r:new Tr(or.VALUE,Z.PatternNotFound)}))}substitute(e,t){return this.runFunction(e.args,t,this.metadata("SUBSTITUTE"),((e,t,r,n)=>{const s=this.escapeRegExpSpecialCharacters(t),o=new RegExp(s,"g");if(void 0===n)return e.replace(o,r);if(n<1)return new Tr(or.VALUE,Z.LessThanOne);let i,a=0;for(;null!==(i=o.exec(e));)if(n===++a)return e.substring(0,i.index)+r+e.substring(o.lastIndex);return e}))}find(e,t){return this.runFunction(e.args,t,this.metadata("FIND"),((e,t,r)=>{if(r<1||r>t.length)return new Tr(or.VALUE,Z.IndexBounds);const n=t.substring(r-1).indexOf(e)+r;return n>0?n:new Tr(or.VALUE,Z.PatternNotFound)}))}t(e,t){return this.runFunction(e.args,t,this.metadata("T"),(e=>e instanceof Tr||"string"==typeof e?e:""))}upper(e,t){return this.runFunction(e.args,t,this.metadata("UPPER"),(e=>e.toUpperCase()))}escapeRegExpSpecialCharacters(e){return e.replace(/[.*+?^${}()|[\]\\]/g,"\\$&")}}ya.implementedFunctions={CONCATENATE:{method:"concatenate",parameters:[{argumentType:hn.STRING}],repeatLastArgs:1,expandRanges:!0},EXACT:{method:"exact",parameters:[{argumentType:hn.STRING},{argumentType:hn.STRING}]},SPLIT:{method:"split",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER}]},LEN:{method:"len",parameters:[{argumentType:hn.STRING}]},LOWER:{method:"lower",parameters:[{argumentType:hn.STRING}]},MID:{method:"mid",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]},TRIM:{method:"trim",parameters:[{argumentType:hn.STRING}]},T:{method:"t",parameters:[{argumentType:hn.SCALAR}]},PROPER:{method:"proper",parameters:[{argumentType:hn.STRING}]},CLEAN:{method:"clean",parameters:[{argumentType:hn.STRING}]},REPT:{method:"rept",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER}]},RIGHT:{method:"right",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,defaultValue:1}]},LEFT:{method:"left",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,defaultValue:1}]},REPLACE:{method:"replace",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.STRING}]},SEARCH:{method:"search",parameters:[{argumentType:hn.STRING},{argumentType:hn.STRING},{argumentType:hn.NUMBER,defaultValue:1}]},SUBSTITUTE:{method:"substitute",parameters:[{argumentType:hn.STRING},{argumentType:hn.STRING},{argumentType:hn.STRING},{argumentType:hn.NUMBER,optionalArg:!0}]},FIND:{method:"find",parameters:[{argumentType:hn.STRING},{argumentType:hn.STRING},{argumentType:hn.NUMBER,defaultValue:1}]},UPPER:{method:"upper",parameters:[{argumentType:hn.STRING}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class wa extends un{acos(e,t){return this.runFunction(e.args,t,this.metadata("ACOS"),Math.acos)}asin(e,t){return this.runFunction(e.args,t,this.metadata("ASIN"),Math.asin)}cos(e,t){return this.runFunction(e.args,t,this.metadata("COS"),Math.cos)}sin(e,t){return this.runFunction(e.args,t,this.metadata("SIN"),Math.sin)}tan(e,t){return this.runFunction(e.args,t,this.metadata("TAN"),Math.tan)}atan(e,t){return this.runFunction(e.args,t,this.metadata("ATAN"),Math.atan)}atan2(e,t){return this.runFunction(e.args,t,this.metadata("ATAN2"),((e,t)=>0===e&&0===t?new Tr(or.DIV_BY_ZERO):Math.atan2(t,e)))}cot(e,t){return this.runFunction(e.args,t,this.metadata("COT"),(e=>0===e?new Tr(or.DIV_BY_ZERO):1/Math.tan(e)))}acot(e,t){return this.runFunction(e.args,t,this.metadata("ACOT"),(e=>0===e?Pi/2:Math.atan(1/e)))}sec(e,t){return this.runFunction(e.args,t,this.metadata("SEC"),(e=>1/Math.cos(e)))}csc(e,t){return this.runFunction(e.args,t,this.metadata("CSC"),(e=>0===e?new Tr(or.DIV_BY_ZERO):1/Math.sin(e)))}sinh(e,t){return this.runFunction(e.args,t,this.metadata("SINH"),Math.sinh)}asinh(e,t){return this.runFunction(e.args,t,this.metadata("ASINH"),Math.asinh)}cosh(e,t){return this.runFunction(e.args,t,this.metadata("COSH"),Math.cosh)}acosh(e,t){return this.runFunction(e.args,t,this.metadata("ACOSH"),Math.acosh)}tanh(e,t){return this.runFunction(e.args,t,this.metadata("TANH"),Math.tanh)}atanh(e,t){return this.runFunction(e.args,t,this.metadata("ATANH"),Math.atanh)}coth(e,t){return this.runFunction(e.args,t,this.metadata("COTH"),(e=>0===e?new Tr(or.DIV_BY_ZERO):1/Math.tanh(e)))}acoth(e,t){return this.runFunction(e.args,t,this.metadata("ACOTH"),(e=>0===e?new Tr(or.NUM,Z.NonZero):Math.atanh(1/e)))}sech(e,t){return this.runFunction(e.args,t,this.metadata("SECH"),(e=>1/Math.cosh(e)))}csch(e,t){return this.runFunction(e.args,t,this.metadata("CSCH"),(e=>0===e?new Tr(or.DIV_BY_ZERO):1/Math.sinh(e)))}}wa.implementedFunctions={ACOS:{method:"acos",parameters:[{argumentType:hn.NUMBER}]},ASIN:{method:"asin",parameters:[{argumentType:hn.NUMBER}]},COS:{method:"cos",parameters:[{argumentType:hn.NUMBER}]},SIN:{method:"sin",parameters:[{argumentType:hn.NUMBER}]},TAN:{method:"tan",parameters:[{argumentType:hn.NUMBER}]},ATAN:{method:"atan",parameters:[{argumentType:hn.NUMBER}]},ATAN2:{method:"atan2",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]},COT:{method:"cot",parameters:[{argumentType:hn.NUMBER}]},SEC:{method:"sec",parameters:[{argumentType:hn.NUMBER}]},CSC:{method:"csc",parameters:[{argumentType:hn.NUMBER}]},SINH:{method:"sinh",parameters:[{argumentType:hn.NUMBER}]},COSH:{method:"cosh",parameters:[{argumentType:hn.NUMBER}]},TANH:{method:"tanh",parameters:[{argumentType:hn.NUMBER}]},COTH:{method:"coth",parameters:[{argumentType:hn.NUMBER}]},SECH:{method:"sech",parameters:[{argumentType:hn.NUMBER}]},CSCH:{method:"csch",parameters:[{argumentType:hn.NUMBER}]},ACOT:{method:"acot",parameters:[{argumentType:hn.NUMBER}]},ASINH:{method:"asinh",parameters:[{argumentType:hn.NUMBER}]},ACOSH:{method:"acosh",parameters:[{argumentType:hn.NUMBER}]},ATANH:{method:"atanh",parameters:[{argumentType:hn.NUMBER}]},ACOTH:{method:"acoth",parameters:[{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ca extends ko{constructor(e){super(e),this.dependencyGraph=e}find(e,t,r){return this.basicFind(e,t,"col",r)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ra extends un{constructor(){super(...arguments),this.rowSearch=new Ca(this.dependencyGraph)}vlookup(e,t){return this.runFunction(e.args,t,this.metadata("VLOOKUP"),((e,t,r,n)=>{const s=t.range;return void 0===s?new Tr(or.VALUE,Z.WrongType):r<1?new Tr(or.VALUE,Z.LessThanOne):r>s.width()?new Tr(or.REF,Z.IndexLarge):this.doVlookup(qr(e),t,r-1,n)}))}hlookup(e,t){return this.runFunction(e.args,t,this.metadata("HLOOKUP"),((e,t,r,n)=>{const s=t.range;return void 0===s?new Tr(or.VALUE,Z.WrongType):r<1?new Tr(or.VALUE,Z.LessThanOne):r>s.height()?new Tr(or.REF,Z.IndexLarge):this.doHlookup(qr(e),t,r-1,n)}))}match(e,t){return this.runFunction(e.args,t,this.metadata("MATCH"),((e,t,r)=>this.doMatch(qr(e),t,r)))}searchInRange(e,t,r,n){if(!r&&"string"==typeof e&&this.arithmeticHelper.requiresRegex(e))return n.advancedFind(this.arithmeticHelper.eqMatcherFunction(e),t);{const s=r?{ordering:"asc"}:{ordering:"none",matchExactly:!0};return n.find(e,t,s)}}doVlookup(e,t,r,n){this.dependencyGraph.stats.start(et.VLOOKUP);const s=t.range;let o;o=void 0===s?rt.onlyValues(t.data.map((e=>[e[0]]))):rt.onlyRange(Fr.spanFrom(s.start,1,s.height()),this.dependencyGraph);const i=this.searchInRange(e,o,n,this.columnSearch);if(this.dependencyGraph.stats.end(et.VLOOKUP),-1===i)return new Tr(or.NA,Z.ValueNotFound);let a;if(void 0===s)a=t.data[i][r];else{const e=br(s.sheet,s.start.col+r,s.start.row+i);a=this.dependencyGraph.getCellValue(e)}return a instanceof rt?new Tr(or.VALUE,Z.WrongType):a}doHlookup(e,t,r,n){const s=t.range;let o;o=void 0===s?rt.onlyValues([t.data[0]]):rt.onlyRange(Fr.spanFrom(s.start,s.width(),1),this.dependencyGraph);const i=this.searchInRange(e,o,n,this.rowSearch);if(-1===i)return new Tr(or.NA,Z.ValueNotFound);let a;if(void 0===s)a=t.data[r][i];else{const e=br(s.sheet,s.start.col+i,s.start.row+r);a=this.dependencyGraph.getCellValue(e)}return a instanceof rt?new Tr(or.VALUE,Z.WrongType):a}doMatch(e,t,r){if(![-1,0,1].includes(r))return new Tr(or.VALUE,Z.BadMode);if(t.width()>1&&t.height()>1)return new Tr(or.NA);const n=0===r?{ordering:"none",matchExactly:!0}:{ordering:-1===r?"desc":"asc"},s=(1===t.width()?this.columnSearch:this.rowSearch).find(e,t,n);return-1===s?new Tr(or.NA,Z.ValueNotFound):s+1}}Ra.implementedFunctions={VLOOKUP:{method:"vlookup",parameters:[{argumentType:hn.NOERROR},{argumentType:hn.RANGE},{argumentType:hn.NUMBER},{argumentType:hn.BOOLEAN,defaultValue:!0}]},HLOOKUP:{method:"hlookup",parameters:[{argumentType:hn.NOERROR},{argumentType:hn.RANGE},{argumentType:hn.NUMBER},{argumentType:hn.BOOLEAN,defaultValue:!0}]},MATCH:{method:"match",parameters:[{argumentType:hn.NOERROR},{argumentType:hn.RANGE},{argumentType:hn.NUMBER,defaultValue:1}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class va extends un{roman(e,t){return this.runFunction(e.args,t,this.metadata("ROMAN"),((e,t)=>(e=Math.trunc(e),!1===t?t=4:!0===t&&(t=0),(t=je(this.coerceScalarToNumberOrError(t)))instanceof Tr?t:(t=Math.trunc(t))<0?new Tr(or.VALUE,Z.ValueSmall):t>4?new Tr(or.VALUE,Z.ValueLarge):function(e,t){const r={val:e%1e3,acc:"M".repeat(Math.floor(e/1e3))};4===t&&(Ta(r,"IM",999,1e3),Ta(r,"ID",499,500));t>=3&&(Ta(r,"VM",995,1e3),Ta(r,"VD",495,500));t>=2&&(Ta(r,"XM",990,1e3),Ta(r,"XD",490,500));t>=1&&(Ta(r,"LM",950,1e3),Ta(r,"LD",450,500));Ta(r,"CM",900,1e3),Ta(r,"CD",400,500),Ta(r,"D",500,900),r.acc+="C".repeat(Math.floor(r.val/100)),r.val%=100,t>=2&&(Ta(r,"IC",99,100),Ta(r,"IL",49,50));t>=1&&(Ta(r,"VC",95,100),Ta(r,"VL",45,50));return Ta(r,"XC",90,100),Ta(r,"XL",40,50),Ta(r,"L",50,90),r.acc+="X".repeat(Math.floor(r.val/10)),r.val%=10,Ta(r,"IX",9,10),Ta(r,"IV",4,5),Ta(r,"V",5,9),r.acc+="I".repeat(r.val),r.acc}(e,t))))}arabic(e,t){return this.runFunction(e.args,t,this.metadata("ARABIC"),(e=>{let t=!1;if((e=e.trim().toUpperCase()).startsWith("-")&&(t=!0,""===(e=e.slice(1))))return new Tr(or.VALUE,Z.InvalidRoman);const r={input:e,acc:0};return Sa(r,{token:"MMM",val:3e3},{token:"MM",val:2e3},{token:"M",val:1e3}),Sa(r,{token:"IM",val:999},{token:"VM",val:995},{token:"XM",val:990},{token:"LM",val:950},{token:"CM",val:900}),Sa(r,{token:"D",val:500},{token:"ID",val:499},{token:"VD",val:495},{token:"XD",val:490},{token:"LD",val:450},{token:"CD",val:400}),Sa(r,{token:"CCC",val:300},{token:"CC",val:200},{token:"C",val:100}),Sa(r,{token:"IC",val:99},{token:"VC",val:95},{token:"XC",val:90}),Sa(r,{token:"L",val:50},{token:"IL",val:49},{token:"VL",val:45},{token:"XL",val:40}),Sa(r,{token:"XXX",val:30},{token:"XX",val:20},{token:"X",val:10}),Sa(r,{token:"IX",val:9}),Sa(r,{token:"V",val:5},{token:"IV",val:4}),Sa(r,{token:"III",val:3},{token:"II",val:2},{token:"I",val:1}),""!==r.input?new Tr(or.VALUE,Z.InvalidRoman):t?-r.acc:r.acc}))}}function Sa(e,...t){for(const r of t)if(e.input.startsWith(r.token)){e.input=e.input.slice(r.token.length),e.acc+=r.val;break}}function Ta(e,t,r,n){e.val>=r&&e.val<n&&(e.val-=r,e.acc+=t)}va.implementedFunctions={ROMAN:{method:"roman",parameters:[{argumentType:hn.NUMBER,minValue:1,lessThan:4e3},{argumentType:hn.NOERROR,optionalArg:!0,defaultValue:0}]},ARABIC:{method:"arabic",parameters:[{argumentType:hn.STRING}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Na extends un{add(e,t){return this.runFunction(e.args,t,this.metadata("HF.ADD"),this.arithmeticHelper.addWithEpsilon)}concat(e,t){return this.runFunction(e.args,t,this.metadata("HF.CONCAT"),this.arithmeticHelper.concat)}divide(e,t){return this.runFunction(e.args,t,this.metadata("HF.DIVIDE"),this.arithmeticHelper.divide)}eq(e,t){return this.runFunction(e.args,t,this.metadata("HF.EQ"),this.arithmeticHelper.eq)}gt(e,t){return this.runFunction(e.args,t,this.metadata("HF.GT"),this.arithmeticHelper.gt)}gte(e,t){return this.runFunction(e.args,t,this.metadata("HF.GTE"),this.arithmeticHelper.geq)}lt(e,t){return this.runFunction(e.args,t,this.metadata("HF.LT"),this.arithmeticHelper.lt)}lte(e,t){return this.runFunction(e.args,t,this.metadata("HF.LTE"),this.arithmeticHelper.leq)}minus(e,t){return this.runFunction(e.args,t,this.metadata("HF.MINUS"),this.arithmeticHelper.subtract)}multiply(e,t){return this.runFunction(e.args,t,this.metadata("HF.MULTIPLY"),this.arithmeticHelper.multiply)}ne(e,t){return this.runFunction(e.args,t,this.metadata("HF.NE"),this.arithmeticHelper.neq)}pow(e,t){return this.runFunction(e.args,t,this.metadata("HF.POW"),this.arithmeticHelper.pow)}uminus(e,t){return this.runFunction(e.args,t,this.metadata("HF.UMINUS"),this.arithmeticHelper.unaryMinus)}upercent(e,t){return this.runFunction(e.args,t,this.metadata("HF.UNARY_PERCENT"),this.arithmeticHelper.unaryPercent)}uplus(e,t){return this.runFunction(e.args,t,this.metadata("HF.UPLUS"),this.arithmeticHelper.unaryPlus)}}Na.implementedFunctions={"HF.ADD":{method:"add",parameters:[{argumentType:hn.NUMBER,passSubtype:!0},{argumentType:hn.NUMBER,passSubtype:!0}]},"HF.CONCAT":{method:"concat",parameters:[{argumentType:hn.STRING,passSubtype:!0},{argumentType:hn.STRING,passSubtype:!0}]},"HF.DIVIDE":{method:"divide",parameters:[{argumentType:hn.NUMBER,passSubtype:!0},{argumentType:hn.NUMBER,passSubtype:!0}]},"HF.EQ":{method:"eq",parameters:[{argumentType:hn.NOERROR,passSubtype:!0},{argumentType:hn.NOERROR,passSubtype:!0}]},"HF.GT":{method:"gt",parameters:[{argumentType:hn.NOERROR,passSubtype:!0},{argumentType:hn.NOERROR,passSubtype:!0}]},"HF.GTE":{method:"gte",parameters:[{argumentType:hn.NOERROR,passSubtype:!0},{argumentType:hn.NOERROR,passSubtype:!0}]},"HF.LT":{method:"lt",parameters:[{argumentType:hn.NOERROR,passSubtype:!0},{argumentType:hn.NOERROR,passSubtype:!0}]},"HF.LTE":{method:"lte",parameters:[{argumentType:hn.NOERROR,passSubtype:!0},{argumentType:hn.NOERROR,passSubtype:!0}]},"HF.MINUS":{method:"minus",parameters:[{argumentType:hn.NUMBER,passSubtype:!0},{argumentType:hn.NUMBER,passSubtype:!0}]},"HF.MULTIPLY":{method:"multiply",parameters:[{argumentType:hn.NUMBER,passSubtype:!0},{argumentType:hn.NUMBER,passSubtype:!0}]},"HF.NE":{method:"ne",parameters:[{argumentType:hn.NOERROR,passSubtype:!0},{argumentType:hn.NOERROR,passSubtype:!0}]},"HF.POW":{method:"pow",parameters:[{argumentType:hn.NUMBER,passSubtype:!0},{argumentType:hn.NUMBER,passSubtype:!0}]},"HF.UMINUS":{method:"uminus",parameters:[{argumentType:hn.NUMBER,passSubtype:!0}]},"HF.UNARY_PERCENT":{method:"upercent",parameters:[{argumentType:hn.NUMBER,passSubtype:!0}]},"HF.UPLUS":{method:"uplus",parameters:[{argumentType:hn.NUMBER,passSubtype:!0}]}};
/**
 * @license
 bessel.js (C) 2013-present SheetJS -- http://sheetjs.com

 Apache License
 Version 2.0, January 2004
 http://www.apache.org/licenses/

 TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

 1. Definitions.

 "License" shall mean the terms and conditions for use, reproduction,
 and distribution as defined by Sections 1 through 9 of this document.

 "Licensor" shall mean the copyright owner or entity authorized by
 the copyright owner that is granting the License.

 "Legal Entity" shall mean the union of the acting entity and all
 other entities that control, are controlled by, or are under common
 control with that entity. For the purposes of this definition,
 "control" means (i) the power, direct or indirect, to cause the
 direction or management of such entity, whether by contract or
 otherwise, or (ii) ownership of fifty percent (50%) or more of the
 outstanding shares, or (iii) beneficial ownership of such entity.

 "You" (or "Your") shall mean an individual or Legal Entity
 exercising permissions granted by this License.

 "Source" form shall mean the preferred form for making modifications,
 including but not limited to software source code, documentation
 source, and configuration files.

 "Object" form shall mean any form resulting from mechanical
 transformation or translation of a Source form, including but
 not limited to compiled object code, generated documentation,
 and conversions to other media types.

 "Work" shall mean the work of authorship, whether in Source or
 Object form, made available under the License, as indicated by a
 copyright notice that is included in or attached to the work
 (an example is provided in the Appendix below).

 "Derivative Works" shall mean any work, whether in Source or Object
 form, that is based on (or derived from) the Work and for which the
 editorial revisions, annotations, elaborations, or other modifications
 represent, as a whole, an original work of authorship. For the purposes
 of this License, Derivative Works shall not include works that remain
 separable from, or merely link (or bind by name) to the interfaces of,
 the Work and Derivative Works thereof.

 "Contribution" shall mean any work of authorship, including
 the original version of the Work and any modifications or additions
 to that Work or Derivative Works thereof, that is intentionally
 submitted to Licensor for inclusion in the Work by the copyright owner
 or by an individual or Legal Entity authorized to submit on behalf of
 the copyright owner. For the purposes of this definition, "submitted"
 means any form of electronic, verbal, or written communication sent
 to the Licensor or its representatives, including but not limited to
 communication on electronic mailing lists, source code control systems,
 and issue tracking systems that are managed by, or on behalf of, the
 Licensor for the purpose of discussing and improving the Work, but
 excluding communication that is conspicuously marked or otherwise
 designated in writing by the copyright owner as "Not a Contribution."

 "Contributor" shall mean Licensor and any individual or Legal Entity
 on behalf of whom a Contribution has been received by Licensor and
 subsequently incorporated within the Work.

 2. Grant of Copyright License. Subject to the terms and conditions of
 this License, each Contributor hereby grants to You a perpetual,
 worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 copyright license to reproduce, prepare Derivative Works of,
 publicly display, publicly perform, sublicense, and distribute the
 Work and such Derivative Works in Source or Object form.

 3. Grant of Patent License. Subject to the terms and conditions of
 this License, each Contributor hereby grants to You a perpetual,
 worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 (except as stated in this section) patent license to make, have made,
 use, offer to sell, sell, import, and otherwise transfer the Work,
 where such license applies only to those patent claims licensable
 by such Contributor that are necessarily infringed by their
 Contribution(s) alone or by combination of their Contribution(s)
 with the Work to which such Contribution(s) was submitted. If You
 institute patent litigation against any entity (including a
 cross-claim or counterclaim in a lawsuit) alleging that the Work
 or a Contribution incorporated within the Work constitutes direct
 or contributory patent infringement, then any patent licenses
 granted to You under this License for that Work shall terminate
 as of the date such litigation is filed.

 4. Redistribution. You may reproduce and distribute copies of the
 Work or Derivative Works thereof in any medium, with or without
 modifications, and in Source or Object form, provided that You
 meet the following conditions:

 (a) You must give any other recipients of the Work or
 Derivative Works a copy of this License; and

 (b) You must cause any modified files to carry prominent notices
 stating that You changed the files; and

 (c) You must retain, in the Source form of any Derivative Works
 that You distribute, all copyright, patent, trademark, and
 attribution notices from the Source form of the Work,
 excluding those notices that do not pertain to any part of
 the Derivative Works; and

 (d) If the Work includes a "NOTICE" text file as part of its
 distribution, then any Derivative Works that You distribute must
 include a readable copy of the attribution notices contained
 within such NOTICE file, excluding those notices that do not
 pertain to any part of the Derivative Works, in at least one
 of the following places: within a NOTICE text file distributed
 as part of the Derivative Works; within the Source form or
 documentation, if provided along with the Derivative Works; or,
 within a display generated by the Derivative Works, if and
 wherever such third-party notices normally appear. The contents
 of the NOTICE file are for informational purposes only and
 do not modify the License. You may add Your own attribution
 notices within Derivative Works that You distribute, alongside
 or as an addendum to the NOTICE text from the Work, provided
 that such additional attribution notices cannot be construed
 as modifying the License.

 You may add Your own copyright statement to Your modifications and
 may provide additional or different license terms and conditions
 for use, reproduction, or distribution of Your modifications, or
 for any such Derivative Works as a whole, provided Your use,
 reproduction, and distribution of the Work otherwise complies with
 the conditions stated in this License.

 5. Submission of Contributions. Unless You explicitly state otherwise,
 any Contribution intentionally submitted for inclusion in the Work
 by You to the Licensor shall be under the terms and conditions of
 this License, without any additional terms or conditions.
 Notwithstanding the above, nothing herein shall supersede or modify
 the terms of any separate license agreement you may have executed
 with Licensor regarding such Contributions.

 6. Trademarks. This License does not grant permission to use the trade
 names, trademarks, service marks, or product names of the Licensor,
 except as required for reasonable and customary use in describing the
 origin of the Work and reproducing the content of the NOTICE file.

 7. Disclaimer of Warranty. Unless required by applicable law or
 agreed to in writing, Licensor provides the Work (and each
 Contributor provides its Contributions) on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 implied, including, without limitation, any warranties or conditions
 of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
 PARTICULAR PURPOSE. You are solely responsible for determining the
 appropriateness of using or redistributing the Work and assume any
 risks associated with Your exercise of permissions under this License.

 8. Limitation of Liability. In no event and under no legal theory,
 whether in tort (including negligence), contract, or otherwise,
 unless required by applicable law (such as deliberate and grossly
 negligent acts) or agreed to in writing, shall any Contributor be
 liable to You for damages, including any direct, indirect, special,
 incidental, or consequential damages of any character arising as a
 result of this License or out of the use or inability to use the
 Work (including but not limited to damages for loss of goodwill,
 work stoppage, computer failure or malfunction, or any and all
 other commercial damages or losses), even if such Contributor
 has been advised of the possibility of such damages.

 9. Accepting Warranty or Additional Liability. While redistributing
 the Work or Derivative Works thereof, You may choose to offer,
 and charge a fee for, acceptance of support, warranty, indemnity,
 or other liability obligations and/or rights consistent with this
 License. However, in accepting such obligations, You may act only
 on Your own behalf and on Your sole responsibility, not on behalf
 of any other Contributor, and only if You agree to indemnify,
 defend, and hold each Contributor harmless for any liability
 incurred by, or claims asserted against, such Contributor by reason
 of your accepting any such warranty or additional liability.

 END OF TERMS AND CONDITIONS

 APPENDIX: How to apply the Apache License to your work.

 To apply the Apache License to your work, attach the following
 boilerplate notice, with the fields enclosed by brackets "{}"
 replaced with your own identifying information. (Don't include
 the brackets!)  The text should be enclosed in the appropriate
 comment syntax for the file format. We also recommend that a
 file or class name and description of purpose be included on the
 same "printed page" as the copyright notice for easier
 identification within third-party archives.

 Copyright (C) 2013-present   SheetJS LLC

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 */
var _a=Math;function Ma(e,t){for(var r=0,n=0;r<e.length;++r)n=t*n+e[r];return n}function Aa(e,t,r,n,s){if(0===t)return r;if(1===t)return n;for(var o=2/e,i=n,a=1;a<t;++a)i=n*a*o+s*r,r=n,n=i;return i}function ba(e,t,r,n,s){return function(r,o){if(n){if(0===r)return 1==n?-1/0:1/0;if(r<0)return NaN}return 0===o?e(r):1===o?t(r):o<0?NaN:Aa(r,o|=0,e(r),t(r),s)}}var Ia,Oa,xa,Pa,La,Da,ka,Ha,Fa,Ua,Va,Ba,Wa,Ya=function(){var e=.636619772,t=[57568490574,-13362590354,651619640.7,-11214424.18,77392.33017,-184.9052456].reverse(),r=[57568490411,1029532985,9494680.718,59272.64853,267.8532712,1].reverse(),n=[1,-.001098628627,2734510407e-14,-2073370639e-15,2.093887211e-7].reverse(),s=[-.01562499995,.0001430488765,-6911147651e-15,7.621095161e-7,-9.34935152e-8].reverse();function o(o){var i=0,a=0,l=0,h=o*o;if(o<8)i=(a=Ma(t,h))/(l=Ma(r,h));else{var u=o-.785398164;a=Ma(n,h=64/h),l=Ma(s,h),i=_a.sqrt(e/o)*(_a.cos(u)*a-_a.sin(u)*l*8/o)}return i}var i=[72362614232,-7895059235,242396853.1,-2972611.439,15704.4826,-30.16036606].reverse(),a=[144725228442,2300535178,18583304.74,99447.43394,376.9991397,1].reverse(),l=[1,.00183105,-3516396496e-14,2457520174e-15,-2.40337019e-7].reverse(),h=[.04687499995,-.0002002690873,8449199096e-15,-8.8228987e-7,1.05787412e-7].reverse();function u(t){var r=0,n=0,s=0,o=t*t,u=_a.abs(t)-2.356194491;return Math.abs(t)<8?r=(n=t*Ma(i,o))/(s=Ma(a,o)):(n=Ma(l,o=64/o),s=Ma(h,o),r=_a.sqrt(e/_a.abs(t))*(_a.cos(u)*n-_a.sin(u)*s*8/_a.abs(t)),t<0&&(r=-r)),r}return function e(t,r){if(r=Math.round(r),!isFinite(t))return isNaN(t)?t:0;if(r<0)return(r%2?-1:1)*e(t,-r);if(t<0)return(r%2?-1:1)*e(-t,r);if(0===r)return o(t);if(1===r)return u(t);if(0===t)return 0;var n=0;if(t>r)n=Aa(t,r,o(t),u(t),-1);else{for(var s=!1,i=0,a=0,l=1,h=0,c=2/t,d=2*_a.floor((r+_a.floor(_a.sqrt(40*r)))/2);d>0;d--)h=d*c*l-i,i=l,l=h,_a.abs(l)>1e10&&(l*=1e-10,i*=1e-10,n*=1e-10,a*=1e-10),s&&(a+=l),s=!s,d==r&&(n=i);n/=a=2*a-l}return n}}(),ja=(Ia=.636619772,Oa=[-2957821389,7062834065,-512359803.6,10879881.29,-86327.92757,228.4622733].reverse(),xa=[40076544269,745249964.8,7189466.438,47447.2647,226.1030244,1].reverse(),Pa=[1,-.001098628627,2734510407e-14,-2073370639e-15,2.093887211e-7].reverse(),La=[-.01562499995,.0001430488765,-6911147651e-15,7.621095161e-7,-9.34945152e-8].reverse(),Da=[-4900604943e3,127527439e4,-51534381390,734926455.1,-4237922.726,8511.937935].reverse(),ka=[249958057e5,424441966400,3733650367,22459040.02,102042.605,354.9632885,1].reverse(),Ha=[1,.00183105,-3516396496e-14,2457520174e-15,-2.40337019e-7].reverse(),Fa=[.04687499995,-.0002002690873,8449199096e-15,-8.8228987e-7,1.05787412e-7].reverse(),ba((function(e){var t=0,r=0,n=0,s=e*e,o=e-.785398164;return e<8?t=(r=Ma(Oa,s))/(n=Ma(xa,s))+Ia*Ya(e,0)*_a.log(e):(r=Ma(Pa,s=64/s),n=Ma(La,s),t=_a.sqrt(Ia/e)*(_a.sin(o)*r+_a.cos(o)*n*8/e)),t}),(function(e){var t=0,r=0,n=0,s=e*e,o=e-2.356194491;return e<8?t=(r=e*Ma(Da,s))/(n=Ma(ka,s))+Ia*(Ya(e,1)*_a.log(e)-1/e):(r=Ma(Ha,s=64/s),n=Ma(Fa,s),t=_a.sqrt(Ia/e)*(_a.sin(o)*r+_a.cos(o)*n*8/e)),t}),0,1,-1)),Ga=(Ua=[1,3.5156229,3.0899424,1.2067492,.2659732,.0360768,.0045813].reverse(),Va=[.39894228,.01328592,.00225319,-.00157565,.00916281,-.02057706,.02635537,-.01647633,.00392377].reverse(),Ba=[.5,.87890594,.51498869,.15084934,.02658733,.00301532,32411e-8].reverse(),Wa=[.39894228,-.03988024,-.00362018,.00163801,-.01031555,.02282967,-.02895312,.01787654,-.00420059].reverse(),function e(t,r){if(0===(r=Math.round(r)))return function(e){return e<=3.75?Ma(Ua,e*e/14.0625):_a.exp(_a.abs(e))/_a.sqrt(_a.abs(e))*Ma(Va,3.75/_a.abs(e))}(t);if(1===r)return function(e){return e<3.75?e*Ma(Ba,e*e/14.0625):(e<0?-1:1)*_a.exp(_a.abs(e))/_a.sqrt(_a.abs(e))*Ma(Wa,3.75/_a.abs(e))}(t);if(r<0)return NaN;if(0===_a.abs(t))return 0;if(t==1/0)return 1/0;var n,s=0,o=2/_a.abs(t),i=0,a=1,l=0;for(n=2*_a.round((r+_a.round(_a.sqrt(40*r)))/2);n>0;n--)l=n*o*a+i,i=a,a=l,_a.abs(a)>1e10&&(a*=1e-10,i*=1e-10,s*=1e-10),n==r&&(s=i);return s*=e(t,0)/a,t<0&&r%2?-s:s}),za=function(){var e=[-.57721566,.4227842,.23069756,.0348859,.00262698,1075e-7,74e-7].reverse(),t=[1.25331414,-.07832358,.02189568,-.01062446,.00587872,-.0025154,53208e-8].reverse();var r=[1,.15443144,-.67278579,-.18156897,-.01919402,-.00110404,-4686e-8].reverse(),n=[1.25331414,.23498619,-.0365562,.01504268,-.00780353,.00325614,-68245e-8].reverse();return ba((function(r){return r<=2?-_a.log(r/2)*Ga(r,0)+Ma(e,r*r/4):_a.exp(-r)/_a.sqrt(r)*Ma(t,2/r)}),(function(e){return e<=2?_a.log(e/2)*Ga(e,1)+1/e*Ma(r,e*e/4):_a.exp(-e)/_a.sqrt(e)*Ma(n,2/e)}),0,2,1)}();
/**
 * @license
 Copyright (c) 2013 jStat

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 */
function $a(e){const t=[-1.3026537197817094,.6419697923564902,.019476473204185836,-.00956151478680863,-.000946595344482036,.000366839497852761,42523324806907e-18,-20278578112534e-18,-1624290004647e-18,130365583558e-17,1.5626441722e-8,-8.5238095915e-8,6.529054439e-9,5.059343495e-9,-9.91364156e-10,-2.27365122e-10,96467911e-18,2394038e-18,-6886027e-18,894487e-18,313092e-18,-112708e-18,381e-18,7106e-18,-1523e-18,-94e-18,121e-18,-28e-18];let r,n,s,o,i=t.length-1,a=!1,l=0,h=0;if(0===e)return 0;for(e<0&&(e=-e,a=!0),r=2/(2+e),n=4*r-2;i>0;i--)s=l,l=n*l-h+t[i],h=s;return o=r*Math.exp(-e*e+.5*(t[0]+n*l)-h),a?o-1:1-o}function Ka(e){return 1-$a(e)}function Xa(e){let t,r,n,s,o=0;if(e>=2)return-100;if(e<=0)return 100;for(s=e<1?e:2-e,n=Math.sqrt(-2*Math.log(s/2)),t=-.70711*((2.30753+.27061*n)/(1+n*(.99229+.04481*n))-n);o<2;o++)r=Ka(t)-s,t+=r/(1.1283791670955126*Math.exp(-t*t)-t*r);return e<1?t:-t}const qa=(e,t)=>e<0?0:t*Math.exp(-t*e),Qa=(e,t)=>e<0?0:1-Math.exp(-t*e);function Za(e){const t=[-1.716185138865495,24.76565080557592,-379.80425647094563,629.3311553128184,866.9662027904133,-31451.272968848367,-36144.413418691176,66456.14382024054],r=[-30.8402300119739,315.35062697960416,-1015.1563674902192,-3107.771671572311,22538.11842098015,4755.846277527881,-134659.9598649693,-115132.2596755535];let n,s,o,i,a=!1,l=0,h=0,u=0,c=e;if(e>171.6243769536076)return 1/0;if(c<=0){if(i=c%1,!i)return 1/0;a=(1&c?-1:1)*Math.PI/Math.sin(Math.PI*i),c=1-c}for(o=c,s=c<1?c++:(c-=l=(0|c)-1)-1,n=0;n<8;++n)u=(u+t[n])*s,h=h*s+r[n];if(i=u/h+1,o<c)i/=o;else if(o>c)for(n=0;n<l;++n)i*=c,c++;return a&&(i=a/i),i}const Ja=function(e,t,r){return e<0?0:0===e&&1===t?1/r:Math.exp((t-1)*Math.log(e)-e/r-rl(t)-t*Math.log(r))},el=function(e,t,r){return e<0?0:nl(t,e/r)},tl=function(e,t,r){return sl(e,t)*r};function rl(e){let t=0;const r=[76.18009172947146,-86.50532032941678,24.01409824083091,-1.231739572450155,.001208650973866179,-5395239384953e-18];let n,s,o,i=1.000000000190015;for(o=(s=n=e)+5.5,o-=(n+.5)*Math.log(o);t<6;t++)i+=r[t]/++s;return Math.log(2.5066282746310007*i/n)-o}function nl(e,t){const r=rl(e);let n=e,s=1/e,o=s,i=t+1-e,a=1/1e-30,l=1/i,h=l,u=1;const c=-~(8.5*Math.log(e>=1?e:1/e)+.4*e+17);let d;if(t<0||e<=0)return NaN;if(t<e+1){for(;u<=c;u++)s+=o*=t/++n;return s*Math.exp(-t+e*Math.log(t)-r)}for(;u<=c;u++)d=-u*(u-e),i+=2,l=d*l+i,a=i+d/a,l=1/l,h*=l*a;return 1-h*Math.exp(-t+e*Math.log(t)-r)}function sl(e,t){let r=0;const n=t-1,s=rl(t);let o,i,a,l,h,u,c;if(e>=1)return Math.max(100,t+100*Math.sqrt(t));if(e<=0)return 0;for(t>1?(u=Math.log(n),c=Math.exp(n*(u-1)-s),h=e<.5?e:1-e,a=Math.sqrt(-2*Math.log(h)),o=(2.30753+.27061*a)/(1+a*(.99229+.04481*a))-a,e<.5&&(o=-o),o=Math.max(.001,t*Math.pow(1-1/(9*t)-o/(3*Math.sqrt(t)),3))):(a=1-t*(.253+.12*t),o=e<a?Math.pow(e/a,1/t):1-Math.log(1-(e-a)/(1-a)));r<12;r++){if(o<=0)return 0;if(i=nl(t,o)-e,a=t>1?c*Math.exp(-(o-n)+n*(Math.log(o)-u)):Math.exp(-o+n*Math.log(o)-s),l=i/a,o-=a=l/(1-.5*Math.min(1,l*((t-1)/o-1))),o<=0&&(o=.5*(o+a)),Math.abs(a)<1e-8*o)break}return o}const ol=function(e,t,r){return Math.exp(-.5*Math.log(2*Math.PI)-Math.log(r)-Math.pow(e-t,2)/(2*r*r))},il=function(e,t,r){return.5*(1+$a((e-t)/Math.sqrt(2*r*r)))},al=function(e,t,r){return-1.4142135623730951*r*Xa(2*e)+t},ll=function(e,t,r){return e>1||e<0?0:1==t&&1==r?1:t<512&&r<512?Math.pow(e,t-1)*Math.pow(1-e,r-1)/cl(t,r):Math.exp((t-1)*Math.log(e)+(r-1)*Math.log(1-e)-dl(t,r))},hl=function(e,t,r){return e>1||e<0?+(e>1):gl(e,t,r)},ul=function(e,t,r){return pl(e,t,r)};function cl(e,t){if(!(e<=0||t<=0))return e+t>170?Math.exp(dl(e,t)):Za(e)*Za(t)/Za(e+t)}function dl(e,t){return rl(e)+rl(t)-rl(e+t)}function pl(e,t,r){var n,s,o,i,a,l,h,u,c,d,p=t-1,g=r-1,f=0;if(e<=0)return 0;if(e>=1)return 1;for(t>=1&&r>=1?(o=e<.5?e:1-e,l=(2.30753+.27061*(i=Math.sqrt(-2*Math.log(o))))/(1+i*(.99229+.04481*i))-i,e<.5&&(l=-l),h=(l*l-3)/6,u=2/(1/(2*t-1)+1/(2*r-1)),c=l*Math.sqrt(h+u)/u-(1/(2*r-1)-1/(2*t-1))*(h+5/6-2/(3*u)),l=t/(t+r*Math.exp(2*c))):(n=Math.log(t/(t+r)),s=Math.log(r/(t+r)),l=e<(i=Math.exp(t*n)/t)/(c=i+(a=Math.exp(r*s)/r))?Math.pow(t*c*e,1/t):1-Math.pow(r*c*(1-e),1/r)),d=-rl(t)-rl(r)+rl(t+r);f<10;f++){if(0===l||1===l)return l;if((l-=i=(a=(gl(l,t,r)-e)/(i=Math.exp(p*Math.log(l)+g*Math.log(1-l)+d)))/(1-.5*Math.min(1,a*(p/l-g/(1-l)))))<=0&&(l=.5*(l+i)),l>=1&&(l=.5*(l+i+1)),Math.abs(i)<1e-8*l&&f>0)break}return l}function gl(e,t,r){var n=0===e||1===e?0:Math.exp(rl(t+r)-rl(t)-rl(r)+t*Math.log(e)+r*Math.log(1-e));return!(e<0||e>1)&&(e<(t+1)/(t+r+2)?n*fl(e,t,r)/t:1-n*fl(1-e,r,t)/r)}function fl(e,t,r){var n,s,o,i,a=1e-30,l=1,h=t+r,u=t+1,c=t-1,d=1,p=1-h*e/u;for(Math.abs(p)<a&&(p=a),i=p=1/p;l<=100&&(p=1+(s=l*(r-l)*e/((c+(n=2*l))*(t+n)))*p,Math.abs(p)<a&&(p=a),d=1+s/d,Math.abs(d)<a&&(d=a),i*=(p=1/p)*d,p=1+(s=-(t+l)*(h+l)*e/((t+n)*(u+n)))*p,Math.abs(p)<a&&(p=a),d=1+s/d,Math.abs(d)<a&&(d=a),i*=o=(p=1/p)*d,!(Math.abs(o-1)<3e-7));l++);return i}const ml=function(e,t,r){return 0===r||1===r?t*r===e?1:0:wl(t,e)*Math.pow(r,e)*Math.pow(1-r,t-e)},El=function(e,t,r){var n,s=1e-10;if(e<0)return 0;if(e>=t)return 1;if(r<0||r>1||t<=0)return NaN;var o=r,i=(e=Math.floor(e))+1,a=t-e,l=i+a,h=Math.exp(rl(l)-rl(a)-rl(i)+i*Math.log(o)+a*Math.log(1-o));return n=o<(i+1)/(l+2)?h*yl(o,i,a,s):1-h*yl(1-o,a,i,s),Math.round(1/s*(1-n))/(1/s)};function yl(e,t,r,n){for(var s,o=0,i=1,a=1,l=1,h=0,u=0;Math.abs((a-u)/a)>n;)u=a,i=l+(s=-(t+h)*(t+r+h)*e/(t+2*h)/(t+2*h+1))*i,a=(o=a+s*o)+(s=(h+=1)*(r-h)*e/(t+2*h-1)/(t+2*h))*a,o/=l=i+s*l,i/=l,a/=l,l=1;return a/t}function wl(e,t){return e>170||t>170?Math.exp(function(e,t){return Cl(e)-Cl(t)-Cl(e-t)}(e,t)):Rl(e)/Rl(t)/Rl(e-t)}function Cl(e){return e<0?NaN:rl(e+1)}function Rl(e){return e<0?NaN:Za(e+1)}const vl=function(e,t){return e<0?0:0===e&&2===t?.5:Math.exp((t/2-1)*Math.log(e)-e/2-t/2*Math.log(2)-rl(t/2))},Sl=function(e,t){return e<0?0:nl(t/2,e/2)},Tl=function(e,t){return 2*sl(e,.5*t)},Nl=function(e,t,r){return e<0?0:t<=2?0===e&&t<2?1/0:0===e&&2===t?1:1/cl(t/2,r/2)*Math.pow(t/r,t/2)*Math.pow(e,t/2-1)*Math.pow(1+t/r*e,-(t+r)/2):t*(r/(r+e*t))/2*ml((t-2)/2,(t+r-2)/2,t*e/(r+e*t))},_l=function(e,t,r){return e<0?0:gl(t*e/(t*e+r),t/2,r/2)},Ml=function(e,t,r){return r/(t*(1/pl(e,t/2,r/2)-1))},Al=function(e,t,r){return e<0||t<0||r<0?0:r/t*Math.pow(e/t,r-1)*Math.exp(-Math.pow(e/t,r))},bl=function(e,t,r){return e<0?0:1-Math.exp(-Math.pow(e/t,r))},Il={pdf:function(e,t){return t<0||e%1!=0||e<0?0:Math.pow(t,e)*Math.exp(-t)/Rl(e)},cdf:function(e,t){var r=0;if(e<0)return 0;for(var n=0;r<=e;r++)n+=Il.pdf(r,t);return n}},Ol={pdf:function(e,t,r,n){if(e<0||e<r-(t-n))return 0;if(e>n||e>r)return 0;if(2*r>t)return 2*n>t?Ol.pdf(t-r-n+e,t,t-r,t-n):Ol.pdf(n-e,t,t-r,n);if(2*n>t)return Ol.pdf(r-e,t,r,t-n);if(r<n)return Ol.pdf(e,t,n,r);for(var s=1,o=0,i=0;i<e;i++){for(;s>1&&o<n;)s*=1-r/(t-o),o++;s*=(n-i)*(r-i)/((i+1)*(t-r-n+i+1))}for(;o<n;o++)s*=1-r/(t-o);return Math.min(1,Math.max(0,s))},cdf:function e(t,r,n,s){if(t<0||t<n-(r-s))return 0;if(t>=s||t>=n)return 1;if(2*n>r)return 2*s>r?e(r-n-s+t,r,r-n,r-s):1-Ol.cdf(s-t-1,r,r-n,s);if(2*s>r)return 1-Ol.cdf(n-t-1,r,n,r-s);if(n<s)return Ol.cdf(t,r,s,n);for(var o=1,i=1,a=0,l=0;l<t;l++){for(;o>1&&a<s;){var h=1-n/(r-a);i*=h,o*=h,a++}o+=i*=(s-l)*(n-l)/((l+1)*(r-n-s+l+1))}for(;a<s;a++)o*=1-n/(r-a);return Math.min(1,Math.max(0,o))}},xl=function(e,t){return t=t>1e100?1e100:t,1/(Math.sqrt(t)*cl(.5,t/2))*Math.pow(1+e*e/t,-(t+1)/2)},Pl=function(e,t){var r=t/2;return gl((e+Math.sqrt(e*e+t))/(2*Math.sqrt(e*e+t)),r,r)},Ll=function(e,t){var r=pl(2*Math.min(e,1-e),.5*t,.5);return r=Math.sqrt(t*(1-r)/r),e>.5?r:-r},Dl=function(e,t,r){return e<=0?0:Math.exp(-Math.log(e)-.5*Math.log(2*Math.PI)-Math.log(r)-Math.pow(Math.log(e)-t,2)/(2*r*r))},kl=function(e,t,r){return e<0?0:.5+.5*$a((Math.log(e)-t)/Math.sqrt(2*r*r))},Hl=function(e,t,r){return Math.exp(-1.4142135623730951*r*Xa(2*e)+t)},Fl={pdf:function(e,t,r){return e===e>>>0&&(e<0?0:wl(e+t-1,t-1)*Math.pow(1-r,e)*Math.pow(r,t))},cdf:function(e,t,r){var n=0,s=0;if(e<0)return 0;for(;s<=e;s++)n+=Fl.pdf(s,t,r);return n}};function Ul(e){for(var t=0,r=e.length;--r>=0;)t+=e[r];return t}function Vl(e){return Ul(e)/e.length}function Bl(e){for(var t,r=Vl(e),n=0,s=e.length;--s>=0;)n+=(t=e[s]-r)*t;return n}function Wl(e,t){return Bl(e)/(e.length-(t?1:0))}function Yl(e,t){return Math.sqrt(Wl(e,t))}function jl(e,t){var r,n=Vl(e),s=Vl(t),o=e.length,i=new Array(o);for(r=0;r<o;r++)i[r]=(e[r]-n)*(t[r]-s);return Ul(i)/(o-1)}function Gl(e,t){return jl(e,t)/Yl(e,1)/Yl(t,1)}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class zl extends un{erf(e,t){return this.runFunction(e.args,t,this.metadata("ERF"),((e,t)=>void 0===t?$a(e):$a(t)-$a(e)))}erfc(e,t){return this.runFunction(e.args,t,this.metadata("ERFC"),Ka)}expondist(e,t){return this.runFunction(e.args,t,this.metadata("EXPON.DIST"),((e,t,r)=>r?Qa(e,t):qa(e,t)))}fisher(e,t){return this.runFunction(e.args,t,this.metadata("FISHER"),(e=>Math.log((1+e)/(1-e))/2))}fisherinv(e,t){return this.runFunction(e.args,t,this.metadata("FISHERINV"),(e=>1-2/(Math.exp(2*e)+1)))}gamma(e,t){return this.runFunction(e.args,t,this.metadata("GAMMA"),Za)}gammadist(e,t){return this.runFunction(e.args,t,this.metadata("GAMMA.DIST"),((e,t,r,n)=>n?el(e,t,r):Ja(e,t,r)))}gammaln(e,t){return this.runFunction(e.args,t,this.metadata("GAMMALN"),rl)}gammainv(e,t){return this.runFunction(e.args,t,this.metadata("GAMMA.INV"),tl)}gauss(e,t){return this.runFunction(e.args,t,this.metadata("GAUSS"),(e=>il(e,0,1)-.5))}betadist(e,t){return this.runFunction(e.args,t,this.metadata("BETA.DIST"),((e,t,r,n,s,o)=>e<=s?new Tr(or.NUM,Z.ValueSmall):e>=o?new Tr(or.NUM,Z.ValueLarge):(e=(e-s)/(o-s),n?hl(e,t,r):ll(e,t,r))))}betainv(e,t){return this.runFunction(e.args,t,this.metadata("BETA.INV"),((e,t,r,n,s)=>n>=s?new Tr(or.NUM,Z.WrongOrder):ul(e,t,r)*(s-n)+n))}binomialdist(e,t){return this.runFunction(e.args,t,this.metadata("BINOM.DIST"),((e,t,r,n)=>e>t?new Tr(or.NUM,Z.WrongOrder):(e=Math.trunc(e),t=Math.trunc(t),n?El(e,t,r):ml(e,t,r))))}binomialinv(e,t){return this.runFunction(e.args,t,this.metadata("BINOM.INV"),((e,t,r)=>{let n=-1,s=e=Math.trunc(e);for(;s>n+1;){const o=Math.trunc((n+s)/2);El(o,e,t)>=r?s=o:n=o}return s}))}besselifn(e,t){return this.runFunction(e.args,t,this.metadata("BESSELI"),((e,t)=>Ga(e,Math.trunc(t))))}besseljfn(e,t){return this.runFunction(e.args,t,this.metadata("BESSELJ"),((e,t)=>Ya(e,Math.trunc(t))))}besselkfn(e,t){return this.runFunction(e.args,t,this.metadata("BESSELK"),((e,t)=>za(e,Math.trunc(t))))}besselyfn(e,t){return this.runFunction(e.args,t,this.metadata("BESSELY"),((e,t)=>ja(e,Math.trunc(t))))}chisqdist(e,t){return this.runFunction(e.args,t,this.metadata("CHISQ.DIST"),((e,t,r)=>(t=Math.trunc(t),r?Sl(e,t):vl(e,t))))}chisqdistrt(e,t){return this.runFunction(e.args,t,this.metadata("CHISQ.DIST.RT"),((e,t)=>1-Sl(e,Math.trunc(t))))}chisqinv(e,t){return this.runFunction(e.args,t,this.metadata("CHISQ.INV"),((e,t)=>Tl(e,Math.trunc(t))))}chisqinvrt(e,t){return this.runFunction(e.args,t,this.metadata("CHISQ.INV.RT"),((e,t)=>Tl(1-e,Math.trunc(t))))}fdist(e,t){return this.runFunction(e.args,t,this.metadata("F.DIST"),((e,t,r,n)=>(t=Math.trunc(t),r=Math.trunc(r),n?_l(e,t,r):Nl(e,t,r))))}fdistrt(e,t){return this.runFunction(e.args,t,this.metadata("F.DIST.RT"),((e,t,r)=>1-_l(e,Math.trunc(t),Math.trunc(r))))}finv(e,t){return this.runFunction(e.args,t,this.metadata("F.INV"),((e,t,r)=>Ml(e,Math.trunc(t),Math.trunc(r))))}finvrt(e,t){return this.runFunction(e.args,t,this.metadata("F.INV.RT"),((e,t,r)=>Ml(1-e,Math.trunc(t),Math.trunc(r))))}weibulldist(e,t){return this.runFunction(e.args,t,this.metadata("WEIBULL.DIST"),((e,t,r,n)=>n?bl(e,r,t):Al(e,r,t)))}poissondist(e,t){return this.runFunction(e.args,t,this.metadata("POISSON.DIST"),((e,t,r)=>(e=Math.trunc(e),r?Il.cdf(e,t):Il.pdf(e,t))))}hypgeomdist(e,t){return this.runFunction(e.args,t,this.metadata("HYPGEOM.DIST"),((e,t,r,n,s)=>e>t||e>r||t>n||r>n||e+n<r+t?new Tr(or.NUM,Z.ValueLarge):(e=Math.trunc(e),t=Math.trunc(t),r=Math.trunc(r),n=Math.trunc(n),s?Ol.cdf(e,n,r,t):Ol.pdf(e,n,r,t))))}tdist(e,t){return this.runFunction(e.args,t,this.metadata("T.DIST"),((e,t,r)=>(t=Math.trunc(t),r?Pl(e,t):xl(e,t))))}tdist2t(e,t){return this.runFunction(e.args,t,this.metadata("T.DIST.2T"),((e,t)=>2*(1-Pl(e,Math.trunc(t)))))}tdistrt(e,t){return this.runFunction(e.args,t,this.metadata("T.DIST.RT"),((e,t)=>1-Pl(e,Math.trunc(t))))}tdistold(e,t){return this.runFunction(e.args,t,this.metadata("TDIST"),((e,t,r)=>r*(1-Pl(e,Math.trunc(t)))))}tinv(e,t){return this.runFunction(e.args,t,this.metadata("T.INV"),((e,t)=>Ll(e,Math.trunc(t))))}tinv2t(e,t){return this.runFunction(e.args,t,this.metadata("T.INV.2T"),((e,t)=>Ll(1-e/2,Math.trunc(t))))}lognormdist(e,t){return this.runFunction(e.args,t,this.metadata("LOGNORM.DIST"),((e,t,r,n)=>n?kl(e,t,r):Dl(e,t,r)))}lognorminv(e,t){return this.runFunction(e.args,t,this.metadata("LOGNORM.INV"),((e,t,r)=>Hl(e,t,r)))}normdist(e,t){return this.runFunction(e.args,t,this.metadata("NORM.DIST"),((e,t,r,n)=>n?il(e,t,r):ol(e,t,r)))}norminv(e,t){return this.runFunction(e.args,t,this.metadata("NORM.INV"),((e,t,r)=>al(e,t,r)))}normsdist(e,t){return this.runFunction(e.args,t,this.metadata("NORM.S.DIST"),((e,t)=>t?il(e,0,1):ol(e,0,1)))}normsinv(e,t){return this.runFunction(e.args,t,this.metadata("NORM.S.INV"),(e=>al(e,0,1)))}phi(e,t){return this.runFunction(e.args,t,this.metadata("PHI"),(e=>ol(e,0,1)))}negbinomdist(e,t){return this.runFunction(e.args,t,this.metadata("NEGBINOM.DIST"),((e,t,r,n)=>(e=Math.trunc(e),t=Math.trunc(t),n?Fl.cdf(e,t,r):Fl.pdf(e,t,r))))}confidencenorm(e,t){return this.runFunction(e.args,t,this.metadata("CONFIDENCE.NORM"),((e,t,r)=>function(){var e,t=[].slice.call(arguments),r=new Array(2);return e=4===t.length?Math.abs(al(t[1]/2,0,1)*t[2]/Math.sqrt(t[3])):Math.abs(al(t[1]/2,0,1)*Yl(t[2])/Math.sqrt(t[2].length)),r[0]=t[0]-e,r[1]=t[0]+e,r}(1,e,t,Math.trunc(r))[1]-1))}confidencet(e,t){return this.runFunction(e.args,t,this.metadata("CONFIDENCE.T"),((e,t,r)=>1===(r=Math.trunc(r))?new Tr(or.DIV_BY_ZERO):function(){var e,t=[].slice.call(arguments),r=new Array(2);return e=4===t.length?Math.abs(Ll(t[1]/2,t[3]-1)*t[2]/Math.sqrt(t[3])):Math.abs(Ll(t[1]/2,t[2].length-1)*Yl(t[2],!0)/Math.sqrt(t[2].length)),r[0]=t[0]-e,r[1]=t[0]+e,r}(1,e,t,r)[1]-1))}standardize(e,t){return this.runFunction(e.args,t,this.metadata("STANDARDIZE"),((e,t,r)=>(e-t)/r))}}zl.implementedFunctions={ERF:{method:"erf",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,optionalArg:!0}]},ERFC:{method:"erfc",parameters:[{argumentType:hn.NUMBER}]},"EXPON.DIST":{method:"expondist",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.BOOLEAN}]},FISHER:{method:"fisher",parameters:[{argumentType:hn.NUMBER,greaterThan:-1,lessThan:1}]},FISHERINV:{method:"fisherinv",parameters:[{argumentType:hn.NUMBER}]},GAMMA:{method:"gamma",parameters:[{argumentType:hn.NUMBER}]},"GAMMA.DIST":{method:"gammadist",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.BOOLEAN}]},GAMMALN:{method:"gammaln",parameters:[{argumentType:hn.NUMBER,greaterThan:0}]},"GAMMA.INV":{method:"gammainv",parameters:[{argumentType:hn.NUMBER,minValue:0,lessThan:1},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0}]},GAUSS:{method:"gauss",parameters:[{argumentType:hn.NUMBER}]},"BETA.DIST":{method:"betadist",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.BOOLEAN},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:1}]},"BETA.INV":{method:"betainv",parameters:[{argumentType:hn.NUMBER,greaterThan:0,maxValue:1},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:1}]},"BINOM.DIST":{method:"binomialdist",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0,maxValue:1},{argumentType:hn.BOOLEAN}]},"BINOM.INV":{method:"binomialinv",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0,maxValue:1},{argumentType:hn.NUMBER,greaterThan:0,lessThan:1}]},BESSELI:{method:"besselifn",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:0}]},BESSELJ:{method:"besseljfn",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:0}]},BESSELK:{method:"besselkfn",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:0}]},BESSELY:{method:"besselyfn",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:0}]},"CHISQ.DIST":{method:"chisqdist",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:1,maxValue:1e10},{argumentType:hn.BOOLEAN}]},"CHISQ.DIST.RT":{method:"chisqdistrt",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:1,maxValue:1e10}]},"CHISQ.INV":{method:"chisqinv",parameters:[{argumentType:hn.NUMBER,minValue:0,maxValue:1},{argumentType:hn.NUMBER,minValue:1,maxValue:1e10}]},"CHISQ.INV.RT":{method:"chisqinvrt",parameters:[{argumentType:hn.NUMBER,minValue:0,maxValue:1},{argumentType:hn.NUMBER,minValue:1}]},"F.DIST":{method:"fdist",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:1},{argumentType:hn.NUMBER,minValue:1},{argumentType:hn.BOOLEAN}]},"F.DIST.RT":{method:"fdistrt",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:1},{argumentType:hn.NUMBER,minValue:1}]},"F.INV":{method:"finv",parameters:[{argumentType:hn.NUMBER,minValue:0,maxValue:1},{argumentType:hn.NUMBER,minValue:1},{argumentType:hn.NUMBER,minValue:1}]},"F.INV.RT":{method:"finvrt",parameters:[{argumentType:hn.NUMBER,minValue:0,maxValue:1},{argumentType:hn.NUMBER,minValue:1},{argumentType:hn.NUMBER,minValue:1}]},"WEIBULL.DIST":{method:"weibulldist",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.BOOLEAN}]},"POISSON.DIST":{method:"poissondist",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.BOOLEAN}]},"HYPGEOM.DIST":{method:"hypgeomdist",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.BOOLEAN}]},"T.DIST":{method:"tdist",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:1},{argumentType:hn.BOOLEAN}]},"T.DIST.2T":{method:"tdist2t",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:1}]},"T.DIST.RT":{method:"tdistrt",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:1}]},TDIST:{method:"tdistold",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:1},{argumentType:hn.INTEGER,minValue:1,maxValue:2}]},"T.INV":{method:"tinv",parameters:[{argumentType:hn.NUMBER,greaterThan:0,lessThan:1},{argumentType:hn.NUMBER,minValue:1}]},"T.INV.2T":{method:"tinv2t",parameters:[{argumentType:hn.NUMBER,greaterThan:0,maxValue:1},{argumentType:hn.NUMBER,minValue:1}]},"LOGNORM.DIST":{method:"lognormdist",parameters:[{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.BOOLEAN}]},"LOGNORM.INV":{method:"lognorminv",parameters:[{argumentType:hn.NUMBER,greaterThan:0,lessThan:1},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,greaterThan:0}]},"NORM.DIST":{method:"normdist",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.BOOLEAN}]},"NORM.INV":{method:"norminv",parameters:[{argumentType:hn.NUMBER,greaterThan:0,lessThan:1},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,greaterThan:0}]},"NORM.S.DIST":{method:"normsdist",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.BOOLEAN}]},"NORM.S.INV":{method:"normsinv",parameters:[{argumentType:hn.NUMBER,greaterThan:0,lessThan:1}]},PHI:{method:"phi",parameters:[{argumentType:hn.NUMBER}]},"NEGBINOM.DIST":{method:"negbinomdist",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:1},{argumentType:hn.NUMBER,minValue:0,maxValue:1},{argumentType:hn.BOOLEAN}]},"CONFIDENCE.NORM":{method:"confidencenorm",parameters:[{argumentType:hn.NUMBER,greaterThan:0,lessThan:1},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,minValue:1}]},"CONFIDENCE.T":{method:"confidencet",parameters:[{argumentType:hn.NUMBER,greaterThan:0,lessThan:1},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,minValue:1}]},STANDARDIZE:{method:"standardize",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,greaterThan:0}]}},zl.aliases={NEGBINOMDIST:"NEGBINOM.DIST",EXPONDIST:"EXPON.DIST",BETADIST:"BETA.DIST",NORMDIST:"NORM.DIST",NORMINV:"NORM.INV",NORMSDIST:"NORM.S.DIST",NORMSINV:"NORM.S.INV",LOGNORMDIST:"LOGNORM.DIST",LOGINV:"LOGNORM.INV",TINV:"T.INV.2T",HYPGEOMDIST:"HYPGEOM.DIST",POISSON:"POISSON.DIST",WEIBULL:"WEIBULL.DIST",FINV:"F.INV.RT",FDIST:"F.DIST.RT",CHIDIST:"CHISQ.DIST.RT",CHIINV:"CHISQ.INV.RT",GAMMADIST:"GAMMA.DIST","GAMMALN.PRECISE":"GAMMALN",GAMMAINV:"GAMMA.INV",BETAINV:"BETA.INV",BINOMDIST:"BINOM.DIST",CONFIDENCE:"CONFIDENCE.NORM",CRITBINOM:"BINOM.INV",WEIBULLDIST:"WEIBULL.DIST",TINV2T:"T.INV.2T",TDISTRT:"T.DIST.RT",TDIST2T:"T.DIST.2T",FINVRT:"F.INV.RT",FDISTRT:"F.DIST.RT",CHIDISTRT:"CHISQ.DIST.RT",CHIINVRT:"CHISQ.INV.RT",LOGNORMINV:"LOGNORM.INV",POISSONDIST:"POISSON.DIST"};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class $l extends un{fact(e,t){return this.runFunction(e.args,t,this.metadata("FACT"),(e=>{e=Math.trunc(e);let t=1;for(let r=1;r<=e;r++)t*=r;return t}))}factdouble(e,t){return this.runFunction(e.args,t,this.metadata("FACTDOUBLE"),(e=>{let t=1;for(let r=e=Math.trunc(e);r>=1;r-=2)t*=r;return t}))}combin(e,t){return this.runFunction(e.args,t,this.metadata("COMBIN"),((e,t)=>t>e?new Tr(or.NUM,Z.WrongOrder):Kl(e=Math.trunc(e),t=Math.trunc(t))))}combina(e,t){return this.runFunction(e.args,t,this.metadata("COMBINA"),((e,t)=>(e=Math.trunc(e))+(t=Math.trunc(t))-1>=1030?new Tr(or.NUM,Z.ValueLarge):0===e&&0===t?1:Kl(e+t-1,t)))}gcd(e,t){return this.runFunction(e.args,t,this.metadata("GCD"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersCoerceRangesDropNulls(e);if(t instanceof Tr)return t;let r=0;for(const e of t){if(e<0)return new Tr(or.NUM,Z.ValueSmall);r=Xl(r,Math.trunc(e))}return r>Number.MAX_SAFE_INTEGER?new Tr(or.NUM,Z.ValueLarge):r}))}lcm(e,t){return this.runFunction(e.args,t,this.metadata("LCM"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersCoerceRangesDropNulls(e);if(t instanceof Tr)return t;let r=1;for(const e of t){if(e<0)return new Tr(or.NUM,Z.ValueSmall);r=ql(r,Math.trunc(e))}return r>Number.MAX_SAFE_INTEGER?new Tr(or.NUM,Z.ValueLarge):r}))}mround(e,t){return this.runFunction(e.args,t,this.metadata("MROUND"),((e,t)=>0===t?0:e>0&&t<0||e<0&&t>0?new Tr(or.NUM,Z.DistinctSigns):Math.round(e/t)*t))}multinomial(e,t){return this.runFunction(e.args,t,this.metadata("MULTINOMIAL"),((...e)=>{let t=0,r=1;for(let n of e){if(n<0)return new Tr(or.NUM,Z.ValueSmall);n=Math.trunc(n);for(let e=1;e<=n;e++)r*=(t+e)/e;t+=n}return Math.round(r)}))}quotient(e,t){return this.runFunction(e.args,t,this.metadata("QUOTIENT"),((e,t)=>0===t?new Tr(or.DIV_BY_ZERO):Math.trunc(e/t)))}seriessum(e,t){return this.runFunction(e.args,t,this.metadata("SERIESSUM"),((e,t,r,n)=>{const s=this.arithmeticHelper.manyToOnlyNumbersDropNulls(n.valuesFromTopLeftCorner());if(s instanceof Tr)return s;let o=0;s.reverse();for(const t of s)o*=Math.pow(e,r),o+=t;return o*Math.pow(e,t)}))}sign(e,t){return this.runFunction(e.args,t,this.metadata("SIGN"),(e=>e>0?1:e<0?-1:0))}sumx2my2(e,t){return this.runFunction(e.args,t,this.metadata("SUMX2MY2"),((e,t)=>{const r=e.valuesFromTopLeftCorner(),n=t.valuesFromTopLeftCorner();if(r.length!==n.length)return new Tr(or.NA,Z.EqualLength);const s=r.length;let o=0;for(let e=0;e<s;e++){const t=r[e],s=n[e];if(t instanceof Tr)return t;if(s instanceof Tr)return s;"number"==typeof t&&"number"==typeof s&&(o+=Math.pow(t,2)-Math.pow(s,2))}return o}))}sumx2py2(e,t){return this.runFunction(e.args,t,this.metadata("SUMX2PY2"),((e,t)=>{const r=e.valuesFromTopLeftCorner(),n=t.valuesFromTopLeftCorner();if(r.length!==n.length)return new Tr(or.NA,Z.EqualLength);const s=r.length;let o=0;for(let e=0;e<s;e++){const t=r[e],s=n[e];if(t instanceof Tr)return t;if(s instanceof Tr)return s;"number"==typeof t&&"number"==typeof s&&(o+=Math.pow(t,2)+Math.pow(s,2))}return o}))}sumxmy2(e,t){return this.runFunction(e.args,t,this.metadata("SUMXMY2"),((e,t)=>{const r=e.valuesFromTopLeftCorner(),n=t.valuesFromTopLeftCorner();if(r.length!==n.length)return new Tr(or.NA,Z.EqualLength);const s=r.length;let o=0;for(let e=0;e<s;e++){const t=r[e],s=n[e];if(t instanceof Tr)return t;if(s instanceof Tr)return s;"number"==typeof t&&"number"==typeof s&&(o+=Math.pow(t-s,2))}return o}))}}function Kl(e,t){2*t>e&&(t=e-t);let r=1;for(let n=1;n<=t;n++)r*=(e-t+n)/n;return Math.round(r)}function Xl(e,t){for(e<t&&([e,t]=[t,e]);t>0;)[e,t]=[t,e%t];return e}function ql(e,t){return 0===e||0===t?0:e*(t/Xl(e,t))}$l.implementedFunctions={FACT:{method:"fact",parameters:[{argumentType:hn.NUMBER,minValue:0,maxValue:170}]},FACTDOUBLE:{method:"factdouble",parameters:[{argumentType:hn.NUMBER,minValue:0,maxValue:288}]},COMBIN:{method:"combin",parameters:[{argumentType:hn.NUMBER,minValue:0,lessThan:1030},{argumentType:hn.NUMBER,minValue:0}]},COMBINA:{method:"combina",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0}]},GCD:{method:"gcd",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},LCM:{method:"lcm",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},MROUND:{method:"mround",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]},MULTINOMIAL:{method:"multinomial",parameters:[{argumentType:hn.NUMBER}],repeatLastArgs:1,expandRanges:!0},QUOTIENT:{method:"quotient",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]},SERIESSUM:{method:"seriessum",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.RANGE}]},SIGN:{method:"sign",parameters:[{argumentType:hn.NUMBER}]},SUMX2MY2:{method:"sumx2my2",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},SUMX2PY2:{method:"sumx2py2",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},SUMXMY2:{method:"sumxmy2",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ql extends un{complex(e,t){return this.runFunction(e.args,t,this.metadata("COMPLEX"),((e,t,r)=>"i"!==r&&"j"!==r?new Tr(or.VALUE,Z.ShouldBeIorJ):jr([e,t],r)))}imabs(e,t){return this.runFunction(e.args,t,this.metadata("IMABS"),ih)}imaginary(e,t){return this.runFunction(e.args,t,this.metadata("IMAGINARY"),(([e,t])=>t))}imreal(e,t){return this.runFunction(e.args,t,this.metadata("IMREAL"),(([e,t])=>e))}imargument(e,t){return this.runFunction(e.args,t,this.metadata("IMARGUMENT"),(([e,t])=>0===e&&0===t?new Tr(or.DIV_BY_ZERO):Math.atan2(t,e)))}imconjugate(e,t){return this.runFunction(e.args,t,this.metadata("IMCONJUGATE"),(([e,t])=>jr([e,-t])))}imcos(e,t){return this.runFunction(e.args,t,this.metadata("IMCOS"),(e=>jr(th(e))))}imcosh(e,t){return this.runFunction(e.args,t,this.metadata("IMCOSH"),(e=>jr(rh(e))))}imcot(e,t){return this.runFunction(e.args,t,this.metadata("IMCOT"),(e=>jr(eh(th(e),nh(e)))))}imcsc(e,t){return this.runFunction(e.args,t,this.metadata("IMCSC"),(e=>jr(eh([1,0],nh(e)))))}imcsch(e,t){return this.runFunction(e.args,t,this.metadata("IMCSCH"),(e=>jr(eh([1,0],sh(e)))))}imsec(e,t){return this.runFunction(e.args,t,this.metadata("IMSEC"),(e=>jr(eh([1,0],th(e)))))}imsech(e,t){return this.runFunction(e.args,t,this.metadata("IMSECH"),(e=>jr(eh([1,0],rh(e)))))}imsin(e,t){return this.runFunction(e.args,t,this.metadata("IMSIN"),(e=>jr(nh(e))))}imsinh(e,t){return this.runFunction(e.args,t,this.metadata("IMSINH"),(e=>jr(sh(e))))}imtan(e,t){return this.runFunction(e.args,t,this.metadata("IMTAN"),(e=>jr(eh(nh(e),th(e)))))}imdiv(e,t){return this.runFunction(e.args,t,this.metadata("IMDIV"),((e,t)=>jr(eh(e,t))))}improduct(e,t){return this.runFunction(e.args,t,this.metadata("IMPRODUCT"),((...e)=>{const t=this.arithmeticHelper.coerceComplexExactRanges(e);if(t instanceof Tr)return t;let r=[1,0];for(const e of t)r=Jl(r,e);return jr(r)}))}imsum(e,t){return this.runFunction(e.args,t,this.metadata("IMSUM"),((...e)=>{const t=this.arithmeticHelper.coerceComplexExactRanges(e);if(t instanceof Tr)return t;let r=[0,0];for(const e of t)r=Zl(r,e);return jr(r)}))}imsub(e,t){return this.runFunction(e.args,t,this.metadata("IMSUB"),((e,t)=>jr(function([e,t],[r,n]){return[e-r,t-n]}(e,t))))}imexp(e,t){return this.runFunction(e.args,t,this.metadata("IMEXP"),(e=>jr(oh(e))))}imln(e,t){return this.runFunction(e.args,t,this.metadata("IMLN"),(e=>jr(ah(e))))}imlog10(e,t){return this.runFunction(e.args,t,this.metadata("IMLOG10"),(e=>{const[t,r]=ah(e),n=Math.log(10);return jr([t/n,r/n])}))}imlog2(e,t){return this.runFunction(e.args,t,this.metadata("IMLOG2"),(e=>{const[t,r]=ah(e),n=Math.log(2);return jr([t/n,r/n])}))}impower(e,t){return this.runFunction(e.args,t,this.metadata("IMPOWER"),((e,t)=>jr(lh(e,t))))}imsqrt(e,t){return this.runFunction(e.args,t,this.metadata("IMSQRT"),(e=>jr(lh(e,.5))))}}function Zl([e,t],[r,n]){return[e+r,t+n]}function Jl([e,t],[r,n]){return[e*r-t*n,e*n+r*t]}function eh([e,t],[r,n]){const s=Math.pow(r,2)+Math.pow(n,2),[o,i]=Jl([e,t],[r,-n]);return[o/s,i/s]}function th([e,t]){return[Math.cos(e)*Math.cosh(t),-Math.sin(e)*Math.sinh(t)]}function rh([e,t]){return[Math.cosh(e)*Math.cos(t),Math.sinh(e)*Math.sin(t)]}function nh([e,t]){return[Math.sin(e)*Math.cosh(t),Math.cos(e)*Math.sinh(t)]}function sh([e,t]){return[Math.sinh(e)*Math.cos(t),Math.cosh(e)*Math.sin(t)]}function oh([e,t]){return[Math.exp(e)*Math.cos(t),Math.exp(e)*Math.sin(t)]}function ih([e,t]){return Math.sqrt(e*e+t*t)}function ah([e,t]){return[Math.log(ih([e,t])),Math.atan2(t,e)]}function lh(e,t){const[r,n]=ah(e);return oh([t*r,t*n])}Ql.implementedFunctions={COMPLEX:{method:"complex",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.STRING,defaultValue:"i"}]},IMABS:{method:"imabs",parameters:[{argumentType:hn.COMPLEX}]},IMAGINARY:{method:"imaginary",parameters:[{argumentType:hn.COMPLEX}]},IMREAL:{method:"imreal",parameters:[{argumentType:hn.COMPLEX}]},IMARGUMENT:{method:"imargument",parameters:[{argumentType:hn.COMPLEX}]},IMCONJUGATE:{method:"imconjugate",parameters:[{argumentType:hn.COMPLEX}]},IMCOS:{method:"imcos",parameters:[{argumentType:hn.COMPLEX}]},IMCOSH:{method:"imcosh",parameters:[{argumentType:hn.COMPLEX}]},IMCOT:{method:"imcot",parameters:[{argumentType:hn.COMPLEX}]},IMCSC:{method:"imcsc",parameters:[{argumentType:hn.COMPLEX}]},IMCSCH:{method:"imcsch",parameters:[{argumentType:hn.COMPLEX}]},IMSEC:{method:"imsec",parameters:[{argumentType:hn.COMPLEX}]},IMSECH:{method:"imsech",parameters:[{argumentType:hn.COMPLEX}]},IMSIN:{method:"imsin",parameters:[{argumentType:hn.COMPLEX}]},IMSINH:{method:"imsinh",parameters:[{argumentType:hn.COMPLEX}]},IMTAN:{method:"imtan",parameters:[{argumentType:hn.COMPLEX}]},IMDIV:{method:"imdiv",parameters:[{argumentType:hn.COMPLEX},{argumentType:hn.COMPLEX}]},IMPRODUCT:{method:"improduct",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},IMSUM:{method:"imsum",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},IMSUB:{method:"imsub",parameters:[{argumentType:hn.COMPLEX},{argumentType:hn.COMPLEX}]},IMEXP:{method:"imexp",parameters:[{argumentType:hn.COMPLEX}]},IMLN:{method:"imln",parameters:[{argumentType:hn.COMPLEX}]},IMLOG10:{method:"imlog10",parameters:[{argumentType:hn.COMPLEX}]},IMLOG2:{method:"imlog2",parameters:[{argumentType:hn.COMPLEX}]},IMPOWER:{method:"impower",parameters:[{argumentType:hn.COMPLEX},{argumentType:hn.NUMBER}]},IMSQRT:{method:"imsqrt",parameters:[{argumentType:hn.COMPLEX}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class hh extends un{avedev(e,t){return this.runFunction(e.args,t,this.metadata("AVEDEV"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersExactRanges(e);if(t instanceof Tr)return t;if(0===t.length)return new Tr(or.DIV_BY_ZERO);const r=Vl(t);return t.reduce(((e,t)=>e+Math.abs(t-r)),0)/t.length}))}devsq(e,t){return this.runFunction(e.args,t,this.metadata("DEVSQ"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersExactRanges(e);return t instanceof Tr?t:0===t.length?0:Bl(t)}))}geomean(e,t){return this.runFunction(e.args,t,this.metadata("GEOMEAN"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersExactRanges(e);if(t instanceof Tr)return t;if(0===t.length)return new Tr(or.NUM,Z.OneValue);for(const e of t)if(e<=0)return new Tr(or.NUM,Z.ValueSmall);return r=t,Math.pow(function(e){for(var t=1,r=e.length;--r>=0;)t*=e[r];return t}(r),1/r.length);var r}))}harmean(e,t){return this.runFunction(e.args,t,this.metadata("HARMEAN"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersExactRanges(e);if(t instanceof Tr)return t;if(0===t.length)return new Tr(or.NUM,Z.OneValue);for(const e of t)if(e<=0)return new Tr(or.NUM,Z.ValueSmall);return t.length/t.reduce(((e,t)=>e+1/t),0)}))}correl(e,t){return this.runFunction(e.args,t,this.metadata("CORREL"),((e,t)=>{if(e.numberOfElements()!==t.numberOfElements())return new Tr(or.NA,Z.EqualLength);const r=uh(e,t);if(r instanceof Tr)return r;return r[0].length<=1?new Tr(or.DIV_BY_ZERO,Z.TwoValues):Gl(r[0],r[1])}))}rsq(e,t){return this.runFunction(e.args,t,this.metadata("RSQ"),((e,t)=>{if(e.numberOfElements()!==t.numberOfElements())return new Tr(or.NA,Z.EqualLength);const r=uh(e,t);if(r instanceof Tr)return r;return r[0].length<=1?new Tr(or.DIV_BY_ZERO,Z.TwoValues):Math.pow(Gl(r[0],r[1]),2)}))}covariancep(e,t){return this.runFunction(e.args,t,this.metadata("COVARIANCE.P"),((e,t)=>{if(e.numberOfElements()!==t.numberOfElements())return new Tr(or.NA,Z.EqualLength);const r=uh(e,t);if(r instanceof Tr)return r;const n=r[0].length;return n<1?new Tr(or.DIV_BY_ZERO,Z.OneValue):1===n?0:jl(r[0],r[1])*(n-1)/n}))}covariances(e,t){return this.runFunction(e.args,t,this.metadata("COVARIANCE.S"),((e,t)=>{if(e.numberOfElements()!==t.numberOfElements())return new Tr(or.NA,Z.EqualLength);const r=uh(e,t);if(r instanceof Tr)return r;return r[0].length<=1?new Tr(or.DIV_BY_ZERO,Z.TwoValues):jl(r[0],r[1])}))}ztest(e,t){return this.runFunction(e.args,t,this.metadata("Z.TEST"),((e,t,r)=>{const n=this.arithmeticHelper.manyToExactNumbers(e.valuesFromTopLeftCorner());if(n instanceof Tr)return n;const s=n.length;if(void 0===r){if(s<2)return new Tr(or.DIV_BY_ZERO,Z.TwoValues);r=Yl(n,!0)}return s<1?new Tr(or.NA,Z.OneValue):0===r?new Tr(or.DIV_BY_ZERO):1-il((Vl(n)-t)/(r/Math.sqrt(s)),0,1)}))}ftest(e,t){return this.runFunction(e.args,t,this.metadata("F.TEST"),((e,t)=>{const r=this.arithmeticHelper.manyToExactNumbers(e.valuesFromTopLeftCorner()),n=this.arithmeticHelper.manyToExactNumbers(t.valuesFromTopLeftCorner());if(r instanceof Tr)return r;if(n instanceof Tr)return n;if(r.length<=1||n.length<=1)return new Tr(or.DIV_BY_ZERO);const s=Wl(r,!0),o=Wl(n,!0);if(0===s||0===o)return new Tr(or.DIV_BY_ZERO);const i=_l(s/o,r.length-1,n.length-1);return 2*Math.min(i,1-i)}))}steyx(e,t){return this.runFunction(e.args,t,this.metadata("STEYX"),((e,t)=>{if(e.numberOfElements()!==t.numberOfElements())return new Tr(or.NA,Z.EqualLength);const r=uh(e,t);if(r instanceof Tr)return r;const n=r[0].length;return n<=2?new Tr(or.DIV_BY_ZERO,Z.ThreeValues):Math.sqrt((Bl(r[0])-Math.pow(jl(r[0],r[1])*(n-1),2)/Bl(r[1]))/(n-2))}))}slope(e,t){return this.runFunction(e.args,t,this.metadata("SLOPE"),((e,t)=>{if(e.numberOfElements()!==t.numberOfElements())return new Tr(or.NA,Z.EqualLength);const r=uh(e,t);if(r instanceof Tr)return r;const n=r[0].length;return n<=1?new Tr(or.DIV_BY_ZERO,Z.TwoValues):jl(r[0],r[1])*(n-1)/Bl(r[1])}))}chisqtest(e,t){return this.runFunction(e.args,t,this.metadata("CHISQ.TEST"),((e,t)=>{const r=e.height(),n=e.width();if(t.height()!==r||t.width()!==n)return new Tr(or.NA,Z.EqualLength);const s=uh(e,t);if(s instanceof Tr)return s;if(s[0].length<=1)return new Tr(or.DIV_BY_ZERO,Z.TwoValues);let o=0;for(let e=0;e<s[0].length;e++){if(0===s[1][e])return new Tr(or.DIV_BY_ZERO);o+=Math.pow(s[0][e]-s[1][e],2)/s[1][e]}return o<0?new Tr(or.NUM,Z.NaN):1-Sl(o,r>1&&n>1?(r-1)*(n-1):r*n-1)}))}ttest(e,t){return this.runFunction(e.args,t,this.metadata("T.TEST"),((e,t,r,n)=>{const s=this.arithmeticHelper.manyToExactNumbers(e.valuesFromTopLeftCorner()),o=this.arithmeticHelper.manyToExactNumbers(t.valuesFromTopLeftCorner());if(s instanceof Tr)return s;if(o instanceof Tr)return o;const i=s.length,a=o.length;if(1===n){if(a!==i)return new Tr(or.NA,Z.EqualLength);if(i<=1)return new Tr(or.DIV_BY_ZERO,Z.TwoValues);const e=Array(i);for(let t=0;t<i;t++)e[t]=s[t]-o[t];const t=Yl(e,!0);if(0===t)return new Tr(or.DIV_BY_ZERO);const n=Math.abs(Math.sqrt(i)*Vl(e)/t);return r*(1-Pl(n,i-1))}if(2===n){if(i<=1||a<=1)return new Tr(or.DIV_BY_ZERO,Z.TwoValues);const e=(Bl(s)+Bl(o))/(i+a-2);if(0===e)return new Tr(or.DIV_BY_ZERO);const t=Math.abs((Vl(s)-Vl(o))/Math.sqrt(e*(1/i+1/a)));return r*(1-Pl(t,i+a-2))}{if(i<=1||a<=1)return new Tr(or.DIV_BY_ZERO,Z.TwoValues);const e=Wl(s,!0),t=Wl(o,!0);if(0===e&&0===t)return new Tr(or.DIV_BY_ZERO);const n=Math.abs((Vl(s)-Vl(o))/Math.sqrt(e/i+t/a)),l=Math.pow(e/i+t/a,2)/(Math.pow(e/i,2)/(i-1)+Math.pow(t/a,2)/(a-1));return r*(1-Pl(n,l))}}))}skew(e,t){return this.runFunction(e.args,t,this.metadata("SKEW"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersExactRanges(e);if(t instanceof Tr)return t;const r=t.length;if(r<3)return new Tr(or.DIV_BY_ZERO,Z.ThreeValues);const n=Vl(t),s=Yl(t,!0);return 0===s?new Tr(or.DIV_BY_ZERO):t.reduce(((e,t)=>e+Math.pow((t-n)/s,3)),0)*r/(r-1)/(r-2)}))}skewp(e,t){return this.runFunction(e.args,t,this.metadata("SKEW.P"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersExactRanges(e);if(t instanceof Tr)return t;const r=t.length;if(r<3)return new Tr(or.DIV_BY_ZERO,Z.ThreeValues);const n=Vl(t),s=Yl(t,!1);return 0===s?new Tr(or.DIV_BY_ZERO):t.reduce(((e,t)=>e+Math.pow((t-n)/s,3)),0)/r}))}}function uh(e,t){const r=e.iterateValuesFromTopLeftCorner(),n=t.iterateValuesFromTopLeftCorner();let s,o;const i=[],a=[];for(;s=r.next(),o=n.next(),!s.done&&!o.done;){const e=s.value,t=o.value;if(e instanceof Tr)return e;if(t instanceof Tr)return t;Ze(e)&&Ze(t)&&(i.push(je(e)),a.push(je(t)))}return[i,a]}hh.implementedFunctions={AVEDEV:{method:"avedev",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},DEVSQ:{method:"devsq",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},GEOMEAN:{method:"geomean",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},HARMEAN:{method:"harmean",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},CORREL:{method:"correl",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},RSQ:{method:"rsq",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},"COVARIANCE.P":{method:"covariancep",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},"COVARIANCE.S":{method:"covariances",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},"Z.TEST":{method:"ztest",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,optionalArg:!0}]},"F.TEST":{method:"ftest",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},STEYX:{method:"steyx",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},SLOPE:{method:"slope",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},"CHISQ.TEST":{method:"chisqtest",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},"T.TEST":{method:"ttest",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE},{argumentType:hn.INTEGER,minValue:1,maxValue:2},{argumentType:hn.INTEGER,minValue:1,maxValue:3}]},SKEW:{method:"skew",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},"SKEW.P":{method:"skewp",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1}},hh.aliases={COVAR:"COVARIANCE.P",FTEST:"F.TEST",PEARSON:"CORREL",ZTEST:"Z.TEST",CHITEST:"CHISQ.TEST",TTEST:"T.TEST",COVARIANCEP:"COVARIANCE.P",COVARIANCES:"COVARIANCE.S",SKEWP:"SKEW.P"};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ch extends $o{}ch.HyperFormula=$o,ch.ErrorType=or,ch.CellError=Tr,ch.CellType=ir,ch.CellValueType=yr,ch.CellValueDetailedType=wr,ch.DetailedCellError=pn,ch.ExportedCellChange=go,ch.ExportedNamedExpressionChange=fo,ch.ConfigValueTooBigError=Mt,ch.ConfigValueTooSmallError=_t,ch.EvaluationSuspendedError=bt,ch.ExpectedOneOfValuesError=At,ch.ExpectedValueOfTypeError=Tt,ch.ArraySize=cn,ch.SimpleRangeValue=rt,ch.EmptyValue=Ye,ch.FunctionPlugin=un,ch.FunctionArgumentType=hn,ch.FunctionPluginValidationError=Lt,ch.InvalidAddressError=pt,ch.InvalidArgumentsError=gt,ch.LanguageNotRegisteredError=xt,ch.LanguageAlreadyRegisteredError=Pt,ch.MissingTranslationError=It,ch.NamedExpressionDoesNotExistError=yt,ch.NamedExpressionNameIsAlreadyTakenError=mt,ch.NamedExpressionNameIsInvalidError=Et,ch.NoOperationToRedoError=Ct,ch.NoOperationToUndoError=wt,ch.NoRelativeAddressesAllowedError=Ft,ch.NoSheetWithIdError=lt,ch.NoSheetWithNameError=ht,ch.NotAFormulaError=dt,ch.NothingToPasteError=Rt,ch.ProtectedFunctionTranslationError=Ot,ch.SheetNameAlreadyTakenError=ut,ch.SheetSizeLimitExceededError=ct,ch.SourceLocationHasArrayError=kt,ch.TargetLocationHasArrayError=Ht,ch.UnableToParseError=St;const dh=Xo.defaultConfig.language;$o.registerLanguage(dh,Qo),$o.languages[Qo.langCode]=Qo;for(const e of Object.getOwnPropertyNames(o))e.startsWith("_")||$o.registerFunctionPlugin(o[e]);const ph=ch;window.HyperFormula=r(44820).Ay},14130:function(e,t,r){e.exports=function(){"use strict";function e(t){return e="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},e(t)}function t(e,r){return t=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},t(e,r)}function r(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}function n(e,s,o){return n=r()?Reflect.construct:function(e,r,n){var s=[null];s.push.apply(s,r);var o=new(Function.bind.apply(e,s));return n&&t(o,n.prototype),o},n.apply(null,arguments)}function s(e){return o(e)||i(e)||a(e)||h()}function o(e){if(Array.isArray(e))return l(e)}function i(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}function a(e,t){if(e){if("string"==typeof e)return l(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);return"Object"===r&&e.constructor&&(r=e.constructor.name),"Map"===r||"Set"===r?Array.from(e):"Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r)?l(e,t):void 0}}function l(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,n=new Array(t);r<t;r++)n[r]=e[r];return n}function h(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var u=Object.hasOwnProperty,c=Object.setPrototypeOf,d=Object.isFrozen,p=Object.getPrototypeOf,g=Object.getOwnPropertyDescriptor,f=Object.freeze,m=Object.seal,E=Object.create,y="undefined"!=typeof Reflect&&Reflect,w=y.apply,C=y.construct;w||(w=function(e,t,r){return e.apply(t,r)}),f||(f=function(e){return e}),m||(m=function(e){return e}),C||(C=function(e,t){return n(e,s(t))});var R=x(Array.prototype.forEach),v=x(Array.prototype.pop),S=x(Array.prototype.push),T=x(String.prototype.toLowerCase),N=x(String.prototype.toString),_=x(String.prototype.match),M=x(String.prototype.replace),A=x(String.prototype.indexOf),b=x(String.prototype.trim),I=x(RegExp.prototype.test),O=P(TypeError);function x(e){return function(t){for(var r=arguments.length,n=new Array(r>1?r-1:0),s=1;s<r;s++)n[s-1]=arguments[s];return w(e,t,n)}}function P(e){return function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return C(e,r)}}function L(e,t,r){var n;r=null!==(n=r)&&void 0!==n?n:T,c&&c(e,null);for(var s=t.length;s--;){var o=t[s];if("string"==typeof o){var i=r(o);i!==o&&(d(t)||(t[s]=i),o=i)}e[o]=!0}return e}function D(e){var t,r=E(null);for(t in e)!0===w(u,e,[t])&&(r[t]=e[t]);return r}function k(e,t){for(;null!==e;){var r=g(e,t);if(r){if(r.get)return x(r.get);if("function"==typeof r.value)return x(r.value)}e=p(e)}function n(e){return console.warn("fallback value for",e),null}return n}var H=f(["a","abbr","acronym","address","area","article","aside","audio","b","bdi","bdo","big","blink","blockquote","body","br","button","canvas","caption","center","cite","code","col","colgroup","content","data","datalist","dd","decorator","del","details","dfn","dialog","dir","div","dl","dt","element","em","fieldset","figcaption","figure","font","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","img","input","ins","kbd","label","legend","li","main","map","mark","marquee","menu","menuitem","meter","nav","nobr","ol","optgroup","option","output","p","picture","pre","progress","q","rp","rt","ruby","s","samp","section","select","shadow","small","source","spacer","span","strike","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","tr","track","tt","u","ul","var","video","wbr"]),F=f(["svg","a","altglyph","altglyphdef","altglyphitem","animatecolor","animatemotion","animatetransform","circle","clippath","defs","desc","ellipse","filter","font","g","glyph","glyphref","hkern","image","line","lineargradient","marker","mask","metadata","mpath","path","pattern","polygon","polyline","radialgradient","rect","stop","style","switch","symbol","text","textpath","title","tref","tspan","view","vkern"]),U=f(["feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feImage","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence"]),V=f(["animate","color-profile","cursor","discard","fedropshadow","font-face","font-face-format","font-face-name","font-face-src","font-face-uri","foreignobject","hatch","hatchpath","mesh","meshgradient","meshpatch","meshrow","missing-glyph","script","set","solidcolor","unknown","use"]),B=f(["math","menclose","merror","mfenced","mfrac","mglyph","mi","mlabeledtr","mmultiscripts","mn","mo","mover","mpadded","mphantom","mroot","mrow","ms","mspace","msqrt","mstyle","msub","msup","msubsup","mtable","mtd","mtext","mtr","munder","munderover"]),W=f(["maction","maligngroup","malignmark","mlongdiv","mscarries","mscarry","msgroup","mstack","msline","msrow","semantics","annotation","annotation-xml","mprescripts","none"]),Y=f(["#text"]),j=f(["accept","action","align","alt","autocapitalize","autocomplete","autopictureinpicture","autoplay","background","bgcolor","border","capture","cellpadding","cellspacing","checked","cite","class","clear","color","cols","colspan","controls","controlslist","coords","crossorigin","datetime","decoding","default","dir","disabled","disablepictureinpicture","disableremoteplayback","download","draggable","enctype","enterkeyhint","face","for","headers","height","hidden","high","href","hreflang","id","inputmode","integrity","ismap","kind","label","lang","list","loading","loop","low","max","maxlength","media","method","min","minlength","multiple","muted","name","nonce","noshade","novalidate","nowrap","open","optimum","pattern","placeholder","playsinline","poster","preload","pubdate","radiogroup","readonly","rel","required","rev","reversed","role","rows","rowspan","spellcheck","scope","selected","shape","size","sizes","span","srclang","start","src","srcset","step","style","summary","tabindex","title","translate","type","usemap","valign","value","width","xmlns","slot"]),G=f(["accent-height","accumulate","additive","alignment-baseline","ascent","attributename","attributetype","azimuth","basefrequency","baseline-shift","begin","bias","by","class","clip","clippathunits","clip-path","clip-rule","color","color-interpolation","color-interpolation-filters","color-profile","color-rendering","cx","cy","d","dx","dy","diffuseconstant","direction","display","divisor","dur","edgemode","elevation","end","fill","fill-opacity","fill-rule","filter","filterunits","flood-color","flood-opacity","font-family","font-size","font-size-adjust","font-stretch","font-style","font-variant","font-weight","fx","fy","g1","g2","glyph-name","glyphref","gradientunits","gradienttransform","height","href","id","image-rendering","in","in2","k","k1","k2","k3","k4","kerning","keypoints","keysplines","keytimes","lang","lengthadjust","letter-spacing","kernelmatrix","kernelunitlength","lighting-color","local","marker-end","marker-mid","marker-start","markerheight","markerunits","markerwidth","maskcontentunits","maskunits","max","mask","media","method","mode","min","name","numoctaves","offset","operator","opacity","order","orient","orientation","origin","overflow","paint-order","path","pathlength","patterncontentunits","patterntransform","patternunits","points","preservealpha","preserveaspectratio","primitiveunits","r","rx","ry","radius","refx","refy","repeatcount","repeatdur","restart","result","rotate","scale","seed","shape-rendering","specularconstant","specularexponent","spreadmethod","startoffset","stddeviation","stitchtiles","stop-color","stop-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke","stroke-width","style","surfacescale","systemlanguage","tabindex","targetx","targety","transform","transform-origin","text-anchor","text-decoration","text-rendering","textlength","type","u1","u2","unicode","values","viewbox","visibility","version","vert-adv-y","vert-origin-x","vert-origin-y","width","word-spacing","wrap","writing-mode","xchannelselector","ychannelselector","x","x1","x2","xmlns","y","y1","y2","z","zoomandpan"]),z=f(["accent","accentunder","align","bevelled","close","columnsalign","columnlines","columnspan","denomalign","depth","dir","display","displaystyle","encoding","fence","frame","height","href","id","largeop","length","linethickness","lspace","lquote","mathbackground","mathcolor","mathsize","mathvariant","maxsize","minsize","movablelimits","notation","numalign","open","rowalign","rowlines","rowspacing","rowspan","rspace","rquote","scriptlevel","scriptminsize","scriptsizemultiplier","selection","separator","separators","stretchy","subscriptshift","supscriptshift","symmetric","voffset","width","xmlns"]),$=f(["xlink:href","xml:id","xlink:title","xml:space","xmlns:xlink"]),K=m(/\{\{[\w\W]*|[\w\W]*\}\}/gm),X=m(/<%[\w\W]*|[\w\W]*%>/gm),q=m(/\${[\w\W]*}/gm),Q=m(/^data-[\-\w.\u00B7-\uFFFF]/),Z=m(/^aria-[\-\w]+$/),J=m(/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i),ee=m(/^(?:\w+script|data):/i),te=m(/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g),re=m(/^html$/i),ne=m(/^[a-z][.\w]*(-[.\w]+)+$/i),se=function(){return"undefined"==typeof window?null:window},oe=function(t,r){if("object"!==e(t)||"function"!=typeof t.createPolicy)return null;var n=null,s="data-tt-policy-suffix";r.currentScript&&r.currentScript.hasAttribute(s)&&(n=r.currentScript.getAttribute(s));var o="dompurify"+(n?"#"+n:"");try{return t.createPolicy(o,{createHTML:function(e){return e},createScriptURL:function(e){return e}})}catch(e){return console.warn("TrustedTypes policy "+o+" could not be created."),null}};function ie(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:se(),r=function(e){return ie(e)};if(r.version="2.5.0",r.removed=[],!t||!t.document||9!==t.document.nodeType)return r.isSupported=!1,r;var n=t.document,o=t.document,i=t.DocumentFragment,a=t.HTMLTemplateElement,l=t.Node,h=t.Element,u=t.NodeFilter,c=t.NamedNodeMap,d=void 0===c?t.NamedNodeMap||t.MozNamedAttrMap:c,p=t.HTMLFormElement,g=t.DOMParser,m=t.trustedTypes,E=h.prototype,y=k(E,"cloneNode"),w=k(E,"nextSibling"),C=k(E,"childNodes"),x=k(E,"parentNode");if("function"==typeof a){var P=o.createElement("template");P.content&&P.content.ownerDocument&&(o=P.content.ownerDocument)}var ae=oe(m,n),le=ae?ae.createHTML(""):"",he=o,ue=he.implementation,ce=he.createNodeIterator,de=he.createDocumentFragment,pe=he.getElementsByTagName,ge=n.importNode,fe={};try{fe=D(o).documentMode?o.documentMode:{}}catch(e){}var me={};r.isSupported="function"==typeof x&&ue&&void 0!==ue.createHTMLDocument&&9!==fe;var Ee,ye,we=K,Ce=X,Re=q,ve=Q,Se=Z,Te=ee,Ne=te,_e=ne,Me=J,Ae=null,be=L({},[].concat(s(H),s(F),s(U),s(B),s(Y))),Ie=null,Oe=L({},[].concat(s(j),s(G),s(z),s($))),xe=Object.seal(Object.create(null,{tagNameCheck:{writable:!0,configurable:!1,enumerable:!0,value:null},attributeNameCheck:{writable:!0,configurable:!1,enumerable:!0,value:null},allowCustomizedBuiltInElements:{writable:!0,configurable:!1,enumerable:!0,value:!1}})),Pe=null,Le=null,De=!0,ke=!0,He=!1,Fe=!0,Ue=!1,Ve=!0,Be=!1,We=!1,Ye=!1,je=!1,Ge=!1,ze=!1,$e=!0,Ke=!1,Xe="user-content-",qe=!0,Qe=!1,Ze={},Je=null,et=L({},["annotation-xml","audio","colgroup","desc","foreignobject","head","iframe","math","mi","mn","mo","ms","mtext","noembed","noframes","noscript","plaintext","script","style","svg","template","thead","title","video","xmp"]),tt=null,rt=L({},["audio","video","img","source","image","track"]),nt=null,st=L({},["alt","class","for","id","label","name","pattern","placeholder","role","summary","title","value","style","xmlns"]),ot="http://www.w3.org/1998/Math/MathML",it="http://www.w3.org/2000/svg",at="http://www.w3.org/1999/xhtml",lt=at,ht=!1,ut=null,ct=L({},[ot,it,at],N),dt=["application/xhtml+xml","text/html"],pt="text/html",gt=null,ft=o.createElement("form"),mt=function(e){return e instanceof RegExp||e instanceof Function},Et=function(t){gt&&gt===t||(t&&"object"===e(t)||(t={}),t=D(t),Ee=Ee=-1===dt.indexOf(t.PARSER_MEDIA_TYPE)?pt:t.PARSER_MEDIA_TYPE,ye="application/xhtml+xml"===Ee?N:T,Ae="ALLOWED_TAGS"in t?L({},t.ALLOWED_TAGS,ye):be,Ie="ALLOWED_ATTR"in t?L({},t.ALLOWED_ATTR,ye):Oe,ut="ALLOWED_NAMESPACES"in t?L({},t.ALLOWED_NAMESPACES,N):ct,nt="ADD_URI_SAFE_ATTR"in t?L(D(st),t.ADD_URI_SAFE_ATTR,ye):st,tt="ADD_DATA_URI_TAGS"in t?L(D(rt),t.ADD_DATA_URI_TAGS,ye):rt,Je="FORBID_CONTENTS"in t?L({},t.FORBID_CONTENTS,ye):et,Pe="FORBID_TAGS"in t?L({},t.FORBID_TAGS,ye):{},Le="FORBID_ATTR"in t?L({},t.FORBID_ATTR,ye):{},Ze="USE_PROFILES"in t&&t.USE_PROFILES,De=!1!==t.ALLOW_ARIA_ATTR,ke=!1!==t.ALLOW_DATA_ATTR,He=t.ALLOW_UNKNOWN_PROTOCOLS||!1,Fe=!1!==t.ALLOW_SELF_CLOSE_IN_ATTR,Ue=t.SAFE_FOR_TEMPLATES||!1,Ve=!1!==t.SAFE_FOR_XML,Be=t.WHOLE_DOCUMENT||!1,je=t.RETURN_DOM||!1,Ge=t.RETURN_DOM_FRAGMENT||!1,ze=t.RETURN_TRUSTED_TYPE||!1,Ye=t.FORCE_BODY||!1,$e=!1!==t.SANITIZE_DOM,Ke=t.SANITIZE_NAMED_PROPS||!1,qe=!1!==t.KEEP_CONTENT,Qe=t.IN_PLACE||!1,Me=t.ALLOWED_URI_REGEXP||Me,lt=t.NAMESPACE||at,xe=t.CUSTOM_ELEMENT_HANDLING||{},t.CUSTOM_ELEMENT_HANDLING&&mt(t.CUSTOM_ELEMENT_HANDLING.tagNameCheck)&&(xe.tagNameCheck=t.CUSTOM_ELEMENT_HANDLING.tagNameCheck),t.CUSTOM_ELEMENT_HANDLING&&mt(t.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)&&(xe.attributeNameCheck=t.CUSTOM_ELEMENT_HANDLING.attributeNameCheck),t.CUSTOM_ELEMENT_HANDLING&&"boolean"==typeof t.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements&&(xe.allowCustomizedBuiltInElements=t.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements),Ue&&(ke=!1),Ge&&(je=!0),Ze&&(Ae=L({},s(Y)),Ie=[],!0===Ze.html&&(L(Ae,H),L(Ie,j)),!0===Ze.svg&&(L(Ae,F),L(Ie,G),L(Ie,$)),!0===Ze.svgFilters&&(L(Ae,U),L(Ie,G),L(Ie,$)),!0===Ze.mathMl&&(L(Ae,B),L(Ie,z),L(Ie,$))),t.ADD_TAGS&&(Ae===be&&(Ae=D(Ae)),L(Ae,t.ADD_TAGS,ye)),t.ADD_ATTR&&(Ie===Oe&&(Ie=D(Ie)),L(Ie,t.ADD_ATTR,ye)),t.ADD_URI_SAFE_ATTR&&L(nt,t.ADD_URI_SAFE_ATTR,ye),t.FORBID_CONTENTS&&(Je===et&&(Je=D(Je)),L(Je,t.FORBID_CONTENTS,ye)),qe&&(Ae["#text"]=!0),Be&&L(Ae,["html","head","body"]),Ae.table&&(L(Ae,["tbody"]),delete Pe.tbody),f&&f(t),gt=t)},yt=L({},["mi","mo","mn","ms","mtext"]),wt=L({},["foreignobject","desc","title","annotation-xml"]),Ct=L({},["title","style","font","a","script"]),Rt=L({},F);L(Rt,U),L(Rt,V);var vt=L({},B);L(vt,W);var St=function(e){var t=x(e);t&&t.tagName||(t={namespaceURI:lt,tagName:"template"});var r=T(e.tagName),n=T(t.tagName);return!!ut[e.namespaceURI]&&(e.namespaceURI===it?t.namespaceURI===at?"svg"===r:t.namespaceURI===ot?"svg"===r&&("annotation-xml"===n||yt[n]):Boolean(Rt[r]):e.namespaceURI===ot?t.namespaceURI===at?"math"===r:t.namespaceURI===it?"math"===r&&wt[n]:Boolean(vt[r]):e.namespaceURI===at?!(t.namespaceURI===it&&!wt[n])&&!(t.namespaceURI===ot&&!yt[n])&&!vt[r]&&(Ct[r]||!Rt[r]):!("application/xhtml+xml"!==Ee||!ut[e.namespaceURI]))},Tt=function(e){S(r.removed,{element:e});try{e.parentNode.removeChild(e)}catch(t){try{e.outerHTML=le}catch(t){e.remove()}}},Nt=function(e,t){try{S(r.removed,{attribute:t.getAttributeNode(e),from:t})}catch(e){S(r.removed,{attribute:null,from:t})}if(t.removeAttribute(e),"is"===e&&!Ie[e])if(je||Ge)try{Tt(t)}catch(e){}else try{t.setAttribute(e,"")}catch(e){}},_t=function(e){var t,r;if(Ye)e="<remove></remove>"+e;else{var n=_(e,/^[\r\n\t ]+/);r=n&&n[0]}"application/xhtml+xml"===Ee&&lt===at&&(e='<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>'+e+"</body></html>");var s=ae?ae.createHTML(e):e;if(lt===at)try{t=(new g).parseFromString(s,Ee)}catch(e){}if(!t||!t.documentElement){t=ue.createDocument(lt,"template",null);try{t.documentElement.innerHTML=ht?le:s}catch(e){}}var i=t.body||t.documentElement;return e&&r&&i.insertBefore(o.createTextNode(r),i.childNodes[0]||null),lt===at?pe.call(t,Be?"html":"body")[0]:Be?t.documentElement:i},Mt=function(e){return ce.call(e.ownerDocument||e,e,u.SHOW_ELEMENT|u.SHOW_COMMENT|u.SHOW_TEXT|u.SHOW_PROCESSING_INSTRUCTION|u.SHOW_CDATA_SECTION,null,!1)},At=function(e){return e instanceof p&&("string"!=typeof e.nodeName||"string"!=typeof e.textContent||"function"!=typeof e.removeChild||!(e.attributes instanceof d)||"function"!=typeof e.removeAttribute||"function"!=typeof e.setAttribute||"string"!=typeof e.namespaceURI||"function"!=typeof e.insertBefore||"function"!=typeof e.hasChildNodes)},bt=function(t){return"object"===e(l)?t instanceof l:t&&"object"===e(t)&&"number"==typeof t.nodeType&&"string"==typeof t.nodeName},It=function(e,t,n){me[e]&&R(me[e],(function(e){e.call(r,t,n,gt)}))},Ot=function(e){var t;if(It("beforeSanitizeElements",e,null),At(e))return Tt(e),!0;if(I(/[\u0080-\uFFFF]/,e.nodeName))return Tt(e),!0;var n=ye(e.nodeName);if(It("uponSanitizeElement",e,{tagName:n,allowedTags:Ae}),e.hasChildNodes()&&!bt(e.firstElementChild)&&(!bt(e.content)||!bt(e.content.firstElementChild))&&I(/<[/\w]/g,e.innerHTML)&&I(/<[/\w]/g,e.textContent))return Tt(e),!0;if("select"===n&&I(/<template/i,e.innerHTML))return Tt(e),!0;if(7===e.nodeType)return Tt(e),!0;if(Ve&&8===e.nodeType&&I(/<[/\w]/g,e.data))return Tt(e),!0;if(!Ae[n]||Pe[n]){if(!Pe[n]&&Pt(n)){if(xe.tagNameCheck instanceof RegExp&&I(xe.tagNameCheck,n))return!1;if(xe.tagNameCheck instanceof Function&&xe.tagNameCheck(n))return!1}if(qe&&!Je[n]){var s=x(e)||e.parentNode,o=C(e)||e.childNodes;if(o&&s)for(var i=o.length-1;i>=0;--i)s.insertBefore(y(o[i],!0),w(e))}return Tt(e),!0}return e instanceof h&&!St(e)?(Tt(e),!0):"noscript"!==n&&"noembed"!==n&&"noframes"!==n||!I(/<\/no(script|embed|frames)/i,e.innerHTML)?(Ue&&3===e.nodeType&&(t=e.textContent,t=M(t,we," "),t=M(t,Ce," "),t=M(t,Re," "),e.textContent!==t&&(S(r.removed,{element:e.cloneNode()}),e.textContent=t)),It("afterSanitizeElements",e,null),!1):(Tt(e),!0)},xt=function(e,t,r){if($e&&("id"===t||"name"===t)&&(r in o||r in ft))return!1;if(ke&&!Le[t]&&I(ve,t));else if(De&&I(Se,t));else if(!Ie[t]||Le[t]){if(!(Pt(e)&&(xe.tagNameCheck instanceof RegExp&&I(xe.tagNameCheck,e)||xe.tagNameCheck instanceof Function&&xe.tagNameCheck(e))&&(xe.attributeNameCheck instanceof RegExp&&I(xe.attributeNameCheck,t)||xe.attributeNameCheck instanceof Function&&xe.attributeNameCheck(t))||"is"===t&&xe.allowCustomizedBuiltInElements&&(xe.tagNameCheck instanceof RegExp&&I(xe.tagNameCheck,r)||xe.tagNameCheck instanceof Function&&xe.tagNameCheck(r))))return!1}else if(nt[t]);else if(I(Me,M(r,Ne,"")));else if("src"!==t&&"xlink:href"!==t&&"href"!==t||"script"===e||0!==A(r,"data:")||!tt[e])if(He&&!I(Te,M(r,Ne,"")));else if(r)return!1;return!0},Pt=function(e){return"annotation-xml"!==e&&_(e,_e)},Lt=function(t){var n,s,o,i;It("beforeSanitizeAttributes",t,null);var a=t.attributes;if(a){var l={attrName:"",attrValue:"",keepAttr:!0,allowedAttributes:Ie};for(i=a.length;i--;){var h=n=a[i],u=h.name,c=h.namespaceURI;if(s="value"===u?n.value:b(n.value),o=ye(u),l.attrName=o,l.attrValue=s,l.keepAttr=!0,l.forceKeepAttr=void 0,It("uponSanitizeAttribute",t,l),s=l.attrValue,!l.forceKeepAttr&&(Nt(u,t),l.keepAttr))if(Fe||!I(/\/>/i,s)){Ue&&(s=M(s,we," "),s=M(s,Ce," "),s=M(s,Re," "));var d=ye(t.nodeName);if(xt(d,o,s)){if(!Ke||"id"!==o&&"name"!==o||(Nt(u,t),s=Xe+s),ae&&"object"===e(m)&&"function"==typeof m.getAttributeType)if(c);else switch(m.getAttributeType(d,o)){case"TrustedHTML":s=ae.createHTML(s);break;case"TrustedScriptURL":s=ae.createScriptURL(s)}try{c?t.setAttributeNS(c,u,s):t.setAttribute(u,s),v(r.removed)}catch(e){}}}else Nt(u,t)}It("afterSanitizeAttributes",t,null)}},Dt=function e(t){var r,n=Mt(t);for(It("beforeSanitizeShadowDOM",t,null);r=n.nextNode();)It("uponSanitizeShadowNode",r,null),Ot(r)||(r.content instanceof i&&e(r.content),Lt(r));It("afterSanitizeShadowDOM",t,null)};return r.sanitize=function(s){var o,a,h,u,c,d=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if((ht=!s)&&(s="\x3c!--\x3e"),"string"!=typeof s&&!bt(s)){if("function"!=typeof s.toString)throw O("toString is not a function");if("string"!=typeof(s=s.toString()))throw O("dirty is not a string, aborting")}if(!r.isSupported){if("object"===e(t.toStaticHTML)||"function"==typeof t.toStaticHTML){if("string"==typeof s)return t.toStaticHTML(s);if(bt(s))return t.toStaticHTML(s.outerHTML)}return s}if(We||Et(d),r.removed=[],"string"==typeof s&&(Qe=!1),Qe){if(s.nodeName){var p=ye(s.nodeName);if(!Ae[p]||Pe[p])throw O("root node is forbidden and cannot be sanitized in-place")}}else if(s instanceof l)1===(a=(o=_t("\x3c!----\x3e")).ownerDocument.importNode(s,!0)).nodeType&&"BODY"===a.nodeName||"HTML"===a.nodeName?o=a:o.appendChild(a);else{if(!je&&!Ue&&!Be&&-1===s.indexOf("<"))return ae&&ze?ae.createHTML(s):s;if(!(o=_t(s)))return je?null:ze?le:""}o&&Ye&&Tt(o.firstChild);for(var g=Mt(Qe?s:o);h=g.nextNode();)3===h.nodeType&&h===u||Ot(h)||(h.content instanceof i&&Dt(h.content),Lt(h),u=h);if(u=null,Qe)return s;if(je){if(Ge)for(c=de.call(o.ownerDocument);o.firstChild;)c.appendChild(o.firstChild);else c=o;return(Ie.shadowroot||Ie.shadowrootmod)&&(c=ge.call(n,c,!0)),c}var f=Be?o.outerHTML:o.innerHTML;return Be&&Ae["!doctype"]&&o.ownerDocument&&o.ownerDocument.doctype&&o.ownerDocument.doctype.name&&I(re,o.ownerDocument.doctype.name)&&(f="<!DOCTYPE "+o.ownerDocument.doctype.name+">\n"+f),Ue&&(f=M(f,we," "),f=M(f,Ce," "),f=M(f,Re," ")),ae&&ze?ae.createHTML(f):f},r.setConfig=function(e){Et(e),We=!0},r.clearConfig=function(){gt=null,We=!1},r.isValidAttribute=function(e,t,r){gt||Et({});var n=ye(e),s=ye(t);return xt(n,s,r)},r.addHook=function(e,t){"function"==typeof t&&(me[e]=me[e]||[],S(me[e],t))},r.removeHook=function(e){if(me[e])return v(me[e])},r.removeHooks=function(e){me[e]&&(me[e]=[])},r.removeAllHooks=function(){me={}},r}return ie()}(),window.DOMPurify=r(14130)},2079:()=>{},36382:()=>{},83854:()=>{},63091:()=>{},1178:()=>{},90640:()=>{},56050:()=>{},51115:()=>{},74563:()=>{},99605:()=>{},1011:()=>{},10589:()=>{},91511:()=>{},12468:()=>{},11995:()=>{},6288:()=>{},13159:()=>{},18672:()=>{},69514:()=>{},5045:()=>{},68392:()=>{},19955:()=>{},70485:()=>{},35019:()=>{},1367:()=>{},85850:()=>{},23717:()=>{},42730:()=>{},87608:()=>{},62357:()=>{},52722:()=>{},56217:()=>{},79575:()=>{},47644:()=>{},53246:()=>{},59292:()=>{},50972:()=>{},67964:()=>{},73493:()=>{},30952:()=>{},27517:()=>{},77950:()=>{},57917:()=>{},23637:()=>{},11981:()=>{},21911:()=>{},33877:()=>{},18590:()=>{},6084:()=>{},70469:()=>{},52100:()=>{},53839:()=>{},66855:()=>{},11682:()=>{},35021:()=>{},49896:()=>{},99379:()=>{},86655:()=>{},65274:()=>{},85315:()=>{},60886:()=>{},49993:()=>{},28780:()=>{},96325:()=>{},80665:()=>{},89729:()=>{},56836:()=>{},78072:()=>{},73306:()=>{},52828:()=>{},59781:()=>{},29062:()=>{},99636:()=>{},62976:()=>{},18238:()=>{},27673:()=>{},24824:()=>{},54914:()=>{},13654:()=>{},71250:()=>{},85960:()=>{},82013:()=>{},18107:()=>{},76743:()=>{},80203:()=>{},52592:()=>{},1509:()=>{},44002:()=>{},46460:()=>{},94921:()=>{},98214:()=>{},25090:()=>{},52472:()=>{},57444:()=>{},38523:()=>{},37804:()=>{},32213:()=>{},84420:()=>{},76619:()=>{},72149:()=>{},20307:()=>{},12204:()=>{},56616:()=>{},32850:()=>{},88763:()=>{},32528:()=>{},73608:()=>{},33417:()=>{},86202:()=>{},49381:()=>{},18662:()=>{},35907:()=>{},62119:()=>{},92667:()=>{},70921:()=>{},31012:()=>{},55597:()=>{},91669:()=>{},49586:()=>{},79798:()=>{},88472:()=>{},3046:()=>{},22831:()=>{},47320:()=>{},95360:()=>{},79503:()=>{},53777:()=>{},92519:()=>{},80709:()=>{},44661:()=>{},9032:()=>{},35586:()=>{},28046:()=>{},24131:()=>{},71542:()=>{},56476:function(e,t,r){(e=r.nmd(e)).exports=function(){"use strict";var t,n;function s(){return t.apply(null,arguments)}function o(e){t=e}function i(e){return e instanceof Array||"[object Array]"===Object.prototype.toString.call(e)}function a(e){return null!=e&&"[object Object]"===Object.prototype.toString.call(e)}function l(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function h(e){if(Object.getOwnPropertyNames)return 0===Object.getOwnPropertyNames(e).length;var t;for(t in e)if(l(e,t))return!1;return!0}function u(e){return void 0===e}function c(e){return"number"==typeof e||"[object Number]"===Object.prototype.toString.call(e)}function d(e){return e instanceof Date||"[object Date]"===Object.prototype.toString.call(e)}function p(e,t){var r,n=[],s=e.length;for(r=0;r<s;++r)n.push(t(e[r],r));return n}function g(e,t){for(var r in t)l(t,r)&&(e[r]=t[r]);return l(t,"toString")&&(e.toString=t.toString),l(t,"valueOf")&&(e.valueOf=t.valueOf),e}function f(e,t,r,n){return Kr(e,t,r,n,!0).utc()}function m(){return{empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidEra:null,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],era:null,meridiem:null,rfc2822:!1,weekdayMismatch:!1}}function E(e){return null==e._pf&&(e._pf=m()),e._pf}function y(e){if(null==e._isValid){var t=E(e),r=n.call(t.parsedDateParts,(function(e){return null!=e})),s=!isNaN(e._d.getTime())&&t.overflow<0&&!t.empty&&!t.invalidEra&&!t.invalidMonth&&!t.invalidWeekday&&!t.weekdayMismatch&&!t.nullInput&&!t.invalidFormat&&!t.userInvalidated&&(!t.meridiem||t.meridiem&&r);if(e._strict&&(s=s&&0===t.charsLeftOver&&0===t.unusedTokens.length&&void 0===t.bigHour),null!=Object.isFrozen&&Object.isFrozen(e))return s;e._isValid=s}return e._isValid}function w(e){var t=f(NaN);return null!=e?g(E(t),e):E(t).userInvalidated=!0,t}n=Array.prototype.some?Array.prototype.some:function(e){var t,r=Object(this),n=r.length>>>0;for(t=0;t<n;t++)if(t in r&&e.call(this,r[t],t,r))return!0;return!1};var C=s.momentProperties=[],R=!1;function v(e,t){var r,n,s,o=C.length;if(u(t._isAMomentObject)||(e._isAMomentObject=t._isAMomentObject),u(t._i)||(e._i=t._i),u(t._f)||(e._f=t._f),u(t._l)||(e._l=t._l),u(t._strict)||(e._strict=t._strict),u(t._tzm)||(e._tzm=t._tzm),u(t._isUTC)||(e._isUTC=t._isUTC),u(t._offset)||(e._offset=t._offset),u(t._pf)||(e._pf=E(t)),u(t._locale)||(e._locale=t._locale),o>0)for(r=0;r<o;r++)u(s=t[n=C[r]])||(e[n]=s);return e}function S(e){v(this,e),this._d=new Date(null!=e._d?e._d.getTime():NaN),this.isValid()||(this._d=new Date(NaN)),!1===R&&(R=!0,s.updateOffset(this),R=!1)}function T(e){return e instanceof S||null!=e&&null!=e._isAMomentObject}function N(e){!1===s.suppressDeprecationWarnings&&"undefined"!=typeof console&&console.warn&&console.warn("Deprecation warning: "+e)}function _(e,t){var r=!0;return g((function(){if(null!=s.deprecationHandler&&s.deprecationHandler(null,e),r){var n,o,i,a=[],h=arguments.length;for(o=0;o<h;o++){if(n="","object"==typeof arguments[o]){for(i in n+="\n["+o+"] ",arguments[0])l(arguments[0],i)&&(n+=i+": "+arguments[0][i]+", ");n=n.slice(0,-2)}else n=arguments[o];a.push(n)}N(e+"\nArguments: "+Array.prototype.slice.call(a).join("")+"\n"+(new Error).stack),r=!1}return t.apply(this,arguments)}),t)}var M,A={};function b(e,t){null!=s.deprecationHandler&&s.deprecationHandler(e,t),A[e]||(N(t),A[e]=!0)}function I(e){return"undefined"!=typeof Function&&e instanceof Function||"[object Function]"===Object.prototype.toString.call(e)}function O(e){var t,r;for(r in e)l(e,r)&&(I(t=e[r])?this[r]=t:this["_"+r]=t);this._config=e,this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+"|"+/\d{1,2}/.source)}function x(e,t){var r,n=g({},e);for(r in t)l(t,r)&&(a(e[r])&&a(t[r])?(n[r]={},g(n[r],e[r]),g(n[r],t[r])):null!=t[r]?n[r]=t[r]:delete n[r]);for(r in e)l(e,r)&&!l(t,r)&&a(e[r])&&(n[r]=g({},n[r]));return n}function P(e){null!=e&&this.set(e)}s.suppressDeprecationWarnings=!1,s.deprecationHandler=null,M=Object.keys?Object.keys:function(e){var t,r=[];for(t in e)l(e,t)&&r.push(t);return r};var L={sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"};function D(e,t,r){var n=this._calendar[e]||this._calendar.sameElse;return I(n)?n.call(t,r):n}function k(e,t,r){var n=""+Math.abs(e),s=t-n.length;return(e>=0?r?"+":"":"-")+Math.pow(10,Math.max(0,s)).toString().substr(1)+n}var H=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|N{1,5}|YYYYYY|YYYYY|YYYY|YY|y{2,4}|yo?|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,F=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,U={},V={};function B(e,t,r,n){var s=n;"string"==typeof n&&(s=function(){return this[n]()}),e&&(V[e]=s),t&&(V[t[0]]=function(){return k(s.apply(this,arguments),t[1],t[2])}),r&&(V[r]=function(){return this.localeData().ordinal(s.apply(this,arguments),e)})}function W(e){return e.match(/\[[\s\S]/)?e.replace(/^\[|\]$/g,""):e.replace(/\\/g,"")}function Y(e){var t,r,n=e.match(H);for(t=0,r=n.length;t<r;t++)V[n[t]]?n[t]=V[n[t]]:n[t]=W(n[t]);return function(t){var s,o="";for(s=0;s<r;s++)o+=I(n[s])?n[s].call(t,e):n[s];return o}}function j(e,t){return e.isValid()?(t=G(t,e.localeData()),U[t]=U[t]||Y(t),U[t](e)):e.localeData().invalidDate()}function G(e,t){var r=5;function n(e){return t.longDateFormat(e)||e}for(F.lastIndex=0;r>=0&&F.test(e);)e=e.replace(F,n),F.lastIndex=0,r-=1;return e}var z={LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"};function $(e){var t=this._longDateFormat[e],r=this._longDateFormat[e.toUpperCase()];return t||!r?t:(this._longDateFormat[e]=r.match(H).map((function(e){return"MMMM"===e||"MM"===e||"DD"===e||"dddd"===e?e.slice(1):e})).join(""),this._longDateFormat[e])}var K="Invalid date";function X(){return this._invalidDate}var q="%d",Q=/\d{1,2}/;function Z(e){return this._ordinal.replace("%d",e)}var J={future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",w:"a week",ww:"%d weeks",M:"a month",MM:"%d months",y:"a year",yy:"%d years"};function ee(e,t,r,n){var s=this._relativeTime[r];return I(s)?s(e,t,r,n):s.replace(/%d/i,e)}function te(e,t){var r=this._relativeTime[e>0?"future":"past"];return I(r)?r(t):r.replace(/%s/i,t)}var re={};function ne(e,t){var r=e.toLowerCase();re[r]=re[r+"s"]=re[t]=e}function se(e){return"string"==typeof e?re[e]||re[e.toLowerCase()]:void 0}function oe(e){var t,r,n={};for(r in e)l(e,r)&&(t=se(r))&&(n[t]=e[r]);return n}var ie={};function ae(e,t){ie[e]=t}function le(e){var t,r=[];for(t in e)l(e,t)&&r.push({unit:t,priority:ie[t]});return r.sort((function(e,t){return e.priority-t.priority})),r}function he(e){return e%4==0&&e%100!=0||e%400==0}function ue(e){return e<0?Math.ceil(e)||0:Math.floor(e)}function ce(e){var t=+e,r=0;return 0!==t&&isFinite(t)&&(r=ue(t)),r}function de(e,t){return function(r){return null!=r?(ge(this,e,r),s.updateOffset(this,t),this):pe(this,e)}}function pe(e,t){return e.isValid()?e._d["get"+(e._isUTC?"UTC":"")+t]():NaN}function ge(e,t,r){e.isValid()&&!isNaN(r)&&("FullYear"===t&&he(e.year())&&1===e.month()&&29===e.date()?(r=ce(r),e._d["set"+(e._isUTC?"UTC":"")+t](r,e.month(),et(r,e.month()))):e._d["set"+(e._isUTC?"UTC":"")+t](r))}function fe(e){return I(this[e=se(e)])?this[e]():this}function me(e,t){if("object"==typeof e){var r,n=le(e=oe(e)),s=n.length;for(r=0;r<s;r++)this[n[r].unit](e[n[r].unit])}else if(I(this[e=se(e)]))return this[e](t);return this}var Ee,ye=/\d/,we=/\d\d/,Ce=/\d{3}/,Re=/\d{4}/,ve=/[+-]?\d{6}/,Se=/\d\d?/,Te=/\d\d\d\d?/,Ne=/\d\d\d\d\d\d?/,_e=/\d{1,3}/,Me=/\d{1,4}/,Ae=/[+-]?\d{1,6}/,be=/\d+/,Ie=/[+-]?\d+/,Oe=/Z|[+-]\d\d:?\d\d/gi,xe=/Z|[+-]\d\d(?::?\d\d)?/gi,Pe=/[+-]?\d+(\.\d{1,3})?/,Le=/[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i;function De(e,t,r){Ee[e]=I(t)?t:function(e,n){return e&&r?r:t}}function ke(e,t){return l(Ee,e)?Ee[e](t._strict,t._locale):new RegExp(He(e))}function He(e){return Fe(e.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,(function(e,t,r,n,s){return t||r||n||s})))}function Fe(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}Ee={};var Ue={};function Ve(e,t){var r,n,s=t;for("string"==typeof e&&(e=[e]),c(t)&&(s=function(e,r){r[t]=ce(e)}),n=e.length,r=0;r<n;r++)Ue[e[r]]=s}function Be(e,t){Ve(e,(function(e,r,n,s){n._w=n._w||{},t(e,n._w,n,s)}))}function We(e,t,r){null!=t&&l(Ue,e)&&Ue[e](t,r._a,r,e)}var Ye,je=0,Ge=1,ze=2,$e=3,Ke=4,Xe=5,qe=6,Qe=7,Ze=8;function Je(e,t){return(e%t+t)%t}function et(e,t){if(isNaN(e)||isNaN(t))return NaN;var r=Je(t,12);return e+=(t-r)/12,1===r?he(e)?29:28:31-r%7%2}Ye=Array.prototype.indexOf?Array.prototype.indexOf:function(e){var t;for(t=0;t<this.length;++t)if(this[t]===e)return t;return-1},B("M",["MM",2],"Mo",(function(){return this.month()+1})),B("MMM",0,0,(function(e){return this.localeData().monthsShort(this,e)})),B("MMMM",0,0,(function(e){return this.localeData().months(this,e)})),ne("month","M"),ae("month",8),De("M",Se),De("MM",Se,we),De("MMM",(function(e,t){return t.monthsShortRegex(e)})),De("MMMM",(function(e,t){return t.monthsRegex(e)})),Ve(["M","MM"],(function(e,t){t[Ge]=ce(e)-1})),Ve(["MMM","MMMM"],(function(e,t,r,n){var s=r._locale.monthsParse(e,n,r._strict);null!=s?t[Ge]=s:E(r).invalidMonth=e}));var tt="January_February_March_April_May_June_July_August_September_October_November_December".split("_"),rt="Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),nt=/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,st=Le,ot=Le;function it(e,t){return e?i(this._months)?this._months[e.month()]:this._months[(this._months.isFormat||nt).test(t)?"format":"standalone"][e.month()]:i(this._months)?this._months:this._months.standalone}function at(e,t){return e?i(this._monthsShort)?this._monthsShort[e.month()]:this._monthsShort[nt.test(t)?"format":"standalone"][e.month()]:i(this._monthsShort)?this._monthsShort:this._monthsShort.standalone}function lt(e,t,r){var n,s,o,i=e.toLocaleLowerCase();if(!this._monthsParse)for(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],n=0;n<12;++n)o=f([2e3,n]),this._shortMonthsParse[n]=this.monthsShort(o,"").toLocaleLowerCase(),this._longMonthsParse[n]=this.months(o,"").toLocaleLowerCase();return r?"MMM"===t?-1!==(s=Ye.call(this._shortMonthsParse,i))?s:null:-1!==(s=Ye.call(this._longMonthsParse,i))?s:null:"MMM"===t?-1!==(s=Ye.call(this._shortMonthsParse,i))||-1!==(s=Ye.call(this._longMonthsParse,i))?s:null:-1!==(s=Ye.call(this._longMonthsParse,i))||-1!==(s=Ye.call(this._shortMonthsParse,i))?s:null}function ht(e,t,r){var n,s,o;if(this._monthsParseExact)return lt.call(this,e,t,r);for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),n=0;n<12;n++){if(s=f([2e3,n]),r&&!this._longMonthsParse[n]&&(this._longMonthsParse[n]=new RegExp("^"+this.months(s,"").replace(".","")+"$","i"),this._shortMonthsParse[n]=new RegExp("^"+this.monthsShort(s,"").replace(".","")+"$","i")),r||this._monthsParse[n]||(o="^"+this.months(s,"")+"|^"+this.monthsShort(s,""),this._monthsParse[n]=new RegExp(o.replace(".",""),"i")),r&&"MMMM"===t&&this._longMonthsParse[n].test(e))return n;if(r&&"MMM"===t&&this._shortMonthsParse[n].test(e))return n;if(!r&&this._monthsParse[n].test(e))return n}}function ut(e,t){var r;if(!e.isValid())return e;if("string"==typeof t)if(/^\d+$/.test(t))t=ce(t);else if(!c(t=e.localeData().monthsParse(t)))return e;return r=Math.min(e.date(),et(e.year(),t)),e._d["set"+(e._isUTC?"UTC":"")+"Month"](t,r),e}function ct(e){return null!=e?(ut(this,e),s.updateOffset(this,!0),this):pe(this,"Month")}function dt(){return et(this.year(),this.month())}function pt(e){return this._monthsParseExact?(l(this,"_monthsRegex")||ft.call(this),e?this._monthsShortStrictRegex:this._monthsShortRegex):(l(this,"_monthsShortRegex")||(this._monthsShortRegex=st),this._monthsShortStrictRegex&&e?this._monthsShortStrictRegex:this._monthsShortRegex)}function gt(e){return this._monthsParseExact?(l(this,"_monthsRegex")||ft.call(this),e?this._monthsStrictRegex:this._monthsRegex):(l(this,"_monthsRegex")||(this._monthsRegex=ot),this._monthsStrictRegex&&e?this._monthsStrictRegex:this._monthsRegex)}function ft(){function e(e,t){return t.length-e.length}var t,r,n=[],s=[],o=[];for(t=0;t<12;t++)r=f([2e3,t]),n.push(this.monthsShort(r,"")),s.push(this.months(r,"")),o.push(this.months(r,"")),o.push(this.monthsShort(r,""));for(n.sort(e),s.sort(e),o.sort(e),t=0;t<12;t++)n[t]=Fe(n[t]),s[t]=Fe(s[t]);for(t=0;t<24;t++)o[t]=Fe(o[t]);this._monthsRegex=new RegExp("^("+o.join("|")+")","i"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp("^("+s.join("|")+")","i"),this._monthsShortStrictRegex=new RegExp("^("+n.join("|")+")","i")}function mt(e){return he(e)?366:365}B("Y",0,0,(function(){var e=this.year();return e<=9999?k(e,4):"+"+e})),B(0,["YY",2],0,(function(){return this.year()%100})),B(0,["YYYY",4],0,"year"),B(0,["YYYYY",5],0,"year"),B(0,["YYYYYY",6,!0],0,"year"),ne("year","y"),ae("year",1),De("Y",Ie),De("YY",Se,we),De("YYYY",Me,Re),De("YYYYY",Ae,ve),De("YYYYYY",Ae,ve),Ve(["YYYYY","YYYYYY"],je),Ve("YYYY",(function(e,t){t[je]=2===e.length?s.parseTwoDigitYear(e):ce(e)})),Ve("YY",(function(e,t){t[je]=s.parseTwoDigitYear(e)})),Ve("Y",(function(e,t){t[je]=parseInt(e,10)})),s.parseTwoDigitYear=function(e){return ce(e)+(ce(e)>68?1900:2e3)};var Et=de("FullYear",!0);function yt(){return he(this.year())}function wt(e,t,r,n,s,o,i){var a;return e<100&&e>=0?(a=new Date(e+400,t,r,n,s,o,i),isFinite(a.getFullYear())&&a.setFullYear(e)):a=new Date(e,t,r,n,s,o,i),a}function Ct(e){var t,r;return e<100&&e>=0?((r=Array.prototype.slice.call(arguments))[0]=e+400,t=new Date(Date.UTC.apply(null,r)),isFinite(t.getUTCFullYear())&&t.setUTCFullYear(e)):t=new Date(Date.UTC.apply(null,arguments)),t}function Rt(e,t,r){var n=7+t-r;return-(7+Ct(e,0,n).getUTCDay()-t)%7+n-1}function vt(e,t,r,n,s){var o,i,a=1+7*(t-1)+(7+r-n)%7+Rt(e,n,s);return a<=0?i=mt(o=e-1)+a:a>mt(e)?(o=e+1,i=a-mt(e)):(o=e,i=a),{year:o,dayOfYear:i}}function St(e,t,r){var n,s,o=Rt(e.year(),t,r),i=Math.floor((e.dayOfYear()-o-1)/7)+1;return i<1?n=i+Tt(s=e.year()-1,t,r):i>Tt(e.year(),t,r)?(n=i-Tt(e.year(),t,r),s=e.year()+1):(s=e.year(),n=i),{week:n,year:s}}function Tt(e,t,r){var n=Rt(e,t,r),s=Rt(e+1,t,r);return(mt(e)-n+s)/7}function Nt(e){return St(e,this._week.dow,this._week.doy).week}B("w",["ww",2],"wo","week"),B("W",["WW",2],"Wo","isoWeek"),ne("week","w"),ne("isoWeek","W"),ae("week",5),ae("isoWeek",5),De("w",Se),De("ww",Se,we),De("W",Se),De("WW",Se,we),Be(["w","ww","W","WW"],(function(e,t,r,n){t[n.substr(0,1)]=ce(e)}));var _t={dow:0,doy:6};function Mt(){return this._week.dow}function At(){return this._week.doy}function bt(e){var t=this.localeData().week(this);return null==e?t:this.add(7*(e-t),"d")}function It(e){var t=St(this,1,4).week;return null==e?t:this.add(7*(e-t),"d")}function Ot(e,t){return"string"!=typeof e?e:isNaN(e)?"number"==typeof(e=t.weekdaysParse(e))?e:null:parseInt(e,10)}function xt(e,t){return"string"==typeof e?t.weekdaysParse(e)%7||7:isNaN(e)?null:e}function Pt(e,t){return e.slice(t,7).concat(e.slice(0,t))}B("d",0,"do","day"),B("dd",0,0,(function(e){return this.localeData().weekdaysMin(this,e)})),B("ddd",0,0,(function(e){return this.localeData().weekdaysShort(this,e)})),B("dddd",0,0,(function(e){return this.localeData().weekdays(this,e)})),B("e",0,0,"weekday"),B("E",0,0,"isoWeekday"),ne("day","d"),ne("weekday","e"),ne("isoWeekday","E"),ae("day",11),ae("weekday",11),ae("isoWeekday",11),De("d",Se),De("e",Se),De("E",Se),De("dd",(function(e,t){return t.weekdaysMinRegex(e)})),De("ddd",(function(e,t){return t.weekdaysShortRegex(e)})),De("dddd",(function(e,t){return t.weekdaysRegex(e)})),Be(["dd","ddd","dddd"],(function(e,t,r,n){var s=r._locale.weekdaysParse(e,n,r._strict);null!=s?t.d=s:E(r).invalidWeekday=e})),Be(["d","e","E"],(function(e,t,r,n){t[n]=ce(e)}));var Lt="Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),Dt="Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),kt="Su_Mo_Tu_We_Th_Fr_Sa".split("_"),Ht=Le,Ft=Le,Ut=Le;function Vt(e,t){var r=i(this._weekdays)?this._weekdays:this._weekdays[e&&!0!==e&&this._weekdays.isFormat.test(t)?"format":"standalone"];return!0===e?Pt(r,this._week.dow):e?r[e.day()]:r}function Bt(e){return!0===e?Pt(this._weekdaysShort,this._week.dow):e?this._weekdaysShort[e.day()]:this._weekdaysShort}function Wt(e){return!0===e?Pt(this._weekdaysMin,this._week.dow):e?this._weekdaysMin[e.day()]:this._weekdaysMin}function Yt(e,t,r){var n,s,o,i=e.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],n=0;n<7;++n)o=f([2e3,1]).day(n),this._minWeekdaysParse[n]=this.weekdaysMin(o,"").toLocaleLowerCase(),this._shortWeekdaysParse[n]=this.weekdaysShort(o,"").toLocaleLowerCase(),this._weekdaysParse[n]=this.weekdays(o,"").toLocaleLowerCase();return r?"dddd"===t?-1!==(s=Ye.call(this._weekdaysParse,i))?s:null:"ddd"===t?-1!==(s=Ye.call(this._shortWeekdaysParse,i))?s:null:-1!==(s=Ye.call(this._minWeekdaysParse,i))?s:null:"dddd"===t?-1!==(s=Ye.call(this._weekdaysParse,i))||-1!==(s=Ye.call(this._shortWeekdaysParse,i))||-1!==(s=Ye.call(this._minWeekdaysParse,i))?s:null:"ddd"===t?-1!==(s=Ye.call(this._shortWeekdaysParse,i))||-1!==(s=Ye.call(this._weekdaysParse,i))||-1!==(s=Ye.call(this._minWeekdaysParse,i))?s:null:-1!==(s=Ye.call(this._minWeekdaysParse,i))||-1!==(s=Ye.call(this._weekdaysParse,i))||-1!==(s=Ye.call(this._shortWeekdaysParse,i))?s:null}function jt(e,t,r){var n,s,o;if(this._weekdaysParseExact)return Yt.call(this,e,t,r);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),n=0;n<7;n++){if(s=f([2e3,1]).day(n),r&&!this._fullWeekdaysParse[n]&&(this._fullWeekdaysParse[n]=new RegExp("^"+this.weekdays(s,"").replace(".","\\.?")+"$","i"),this._shortWeekdaysParse[n]=new RegExp("^"+this.weekdaysShort(s,"").replace(".","\\.?")+"$","i"),this._minWeekdaysParse[n]=new RegExp("^"+this.weekdaysMin(s,"").replace(".","\\.?")+"$","i")),this._weekdaysParse[n]||(o="^"+this.weekdays(s,"")+"|^"+this.weekdaysShort(s,"")+"|^"+this.weekdaysMin(s,""),this._weekdaysParse[n]=new RegExp(o.replace(".",""),"i")),r&&"dddd"===t&&this._fullWeekdaysParse[n].test(e))return n;if(r&&"ddd"===t&&this._shortWeekdaysParse[n].test(e))return n;if(r&&"dd"===t&&this._minWeekdaysParse[n].test(e))return n;if(!r&&this._weekdaysParse[n].test(e))return n}}function Gt(e){if(!this.isValid())return null!=e?this:NaN;var t=this._isUTC?this._d.getUTCDay():this._d.getDay();return null!=e?(e=Ot(e,this.localeData()),this.add(e-t,"d")):t}function zt(e){if(!this.isValid())return null!=e?this:NaN;var t=(this.day()+7-this.localeData()._week.dow)%7;return null==e?t:this.add(e-t,"d")}function $t(e){if(!this.isValid())return null!=e?this:NaN;if(null!=e){var t=xt(e,this.localeData());return this.day(this.day()%7?t:t-7)}return this.day()||7}function Kt(e){return this._weekdaysParseExact?(l(this,"_weekdaysRegex")||Qt.call(this),e?this._weekdaysStrictRegex:this._weekdaysRegex):(l(this,"_weekdaysRegex")||(this._weekdaysRegex=Ht),this._weekdaysStrictRegex&&e?this._weekdaysStrictRegex:this._weekdaysRegex)}function Xt(e){return this._weekdaysParseExact?(l(this,"_weekdaysRegex")||Qt.call(this),e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(l(this,"_weekdaysShortRegex")||(this._weekdaysShortRegex=Ft),this._weekdaysShortStrictRegex&&e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)}function qt(e){return this._weekdaysParseExact?(l(this,"_weekdaysRegex")||Qt.call(this),e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(l(this,"_weekdaysMinRegex")||(this._weekdaysMinRegex=Ut),this._weekdaysMinStrictRegex&&e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)}function Qt(){function e(e,t){return t.length-e.length}var t,r,n,s,o,i=[],a=[],l=[],h=[];for(t=0;t<7;t++)r=f([2e3,1]).day(t),n=Fe(this.weekdaysMin(r,"")),s=Fe(this.weekdaysShort(r,"")),o=Fe(this.weekdays(r,"")),i.push(n),a.push(s),l.push(o),h.push(n),h.push(s),h.push(o);i.sort(e),a.sort(e),l.sort(e),h.sort(e),this._weekdaysRegex=new RegExp("^("+h.join("|")+")","i"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp("^("+l.join("|")+")","i"),this._weekdaysShortStrictRegex=new RegExp("^("+a.join("|")+")","i"),this._weekdaysMinStrictRegex=new RegExp("^("+i.join("|")+")","i")}function Zt(){return this.hours()%12||12}function Jt(){return this.hours()||24}function er(e,t){B(e,0,0,(function(){return this.localeData().meridiem(this.hours(),this.minutes(),t)}))}function tr(e,t){return t._meridiemParse}function rr(e){return"p"===(e+"").toLowerCase().charAt(0)}B("H",["HH",2],0,"hour"),B("h",["hh",2],0,Zt),B("k",["kk",2],0,Jt),B("hmm",0,0,(function(){return""+Zt.apply(this)+k(this.minutes(),2)})),B("hmmss",0,0,(function(){return""+Zt.apply(this)+k(this.minutes(),2)+k(this.seconds(),2)})),B("Hmm",0,0,(function(){return""+this.hours()+k(this.minutes(),2)})),B("Hmmss",0,0,(function(){return""+this.hours()+k(this.minutes(),2)+k(this.seconds(),2)})),er("a",!0),er("A",!1),ne("hour","h"),ae("hour",13),De("a",tr),De("A",tr),De("H",Se),De("h",Se),De("k",Se),De("HH",Se,we),De("hh",Se,we),De("kk",Se,we),De("hmm",Te),De("hmmss",Ne),De("Hmm",Te),De("Hmmss",Ne),Ve(["H","HH"],$e),Ve(["k","kk"],(function(e,t,r){var n=ce(e);t[$e]=24===n?0:n})),Ve(["a","A"],(function(e,t,r){r._isPm=r._locale.isPM(e),r._meridiem=e})),Ve(["h","hh"],(function(e,t,r){t[$e]=ce(e),E(r).bigHour=!0})),Ve("hmm",(function(e,t,r){var n=e.length-2;t[$e]=ce(e.substr(0,n)),t[Ke]=ce(e.substr(n)),E(r).bigHour=!0})),Ve("hmmss",(function(e,t,r){var n=e.length-4,s=e.length-2;t[$e]=ce(e.substr(0,n)),t[Ke]=ce(e.substr(n,2)),t[Xe]=ce(e.substr(s)),E(r).bigHour=!0})),Ve("Hmm",(function(e,t,r){var n=e.length-2;t[$e]=ce(e.substr(0,n)),t[Ke]=ce(e.substr(n))})),Ve("Hmmss",(function(e,t,r){var n=e.length-4,s=e.length-2;t[$e]=ce(e.substr(0,n)),t[Ke]=ce(e.substr(n,2)),t[Xe]=ce(e.substr(s))}));var nr=/[ap]\.?m?\.?/i,sr=de("Hours",!0);function or(e,t,r){return e>11?r?"pm":"PM":r?"am":"AM"}var ir,ar={calendar:L,longDateFormat:z,invalidDate:K,ordinal:q,dayOfMonthOrdinalParse:Q,relativeTime:J,months:tt,monthsShort:rt,week:_t,weekdays:Lt,weekdaysMin:kt,weekdaysShort:Dt,meridiemParse:nr},lr={},hr={};function ur(e,t){var r,n=Math.min(e.length,t.length);for(r=0;r<n;r+=1)if(e[r]!==t[r])return r;return n}function cr(e){return e?e.toLowerCase().replace("_","-"):e}function dr(e){for(var t,r,n,s,o=0;o<e.length;){for(t=(s=cr(e[o]).split("-")).length,r=(r=cr(e[o+1]))?r.split("-"):null;t>0;){if(n=gr(s.slice(0,t).join("-")))return n;if(r&&r.length>=t&&ur(s,r)>=t-1)break;t--}o++}return ir}function pr(e){return null!=e.match("^[^/\\\\]*$")}function gr(t){var n=null;if(void 0===lr[t]&&e&&e.exports&&pr(t))try{n=ir._abbr,r(61738)("./"+t),fr(n)}catch(e){lr[t]=null}return lr[t]}function fr(e,t){var r;return e&&((r=u(t)?yr(e):mr(e,t))?ir=r:"undefined"!=typeof console&&console.warn&&console.warn("Locale "+e+" not found. Did you forget to load it?")),ir._abbr}function mr(e,t){if(null!==t){var r,n=ar;if(t.abbr=e,null!=lr[e])b("defineLocaleOverride","use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info."),n=lr[e]._config;else if(null!=t.parentLocale)if(null!=lr[t.parentLocale])n=lr[t.parentLocale]._config;else{if(null==(r=gr(t.parentLocale)))return hr[t.parentLocale]||(hr[t.parentLocale]=[]),hr[t.parentLocale].push({name:e,config:t}),null;n=r._config}return lr[e]=new P(x(n,t)),hr[e]&&hr[e].forEach((function(e){mr(e.name,e.config)})),fr(e),lr[e]}return delete lr[e],null}function Er(e,t){if(null!=t){var r,n,s=ar;null!=lr[e]&&null!=lr[e].parentLocale?lr[e].set(x(lr[e]._config,t)):(null!=(n=gr(e))&&(s=n._config),t=x(s,t),null==n&&(t.abbr=e),(r=new P(t)).parentLocale=lr[e],lr[e]=r),fr(e)}else null!=lr[e]&&(null!=lr[e].parentLocale?(lr[e]=lr[e].parentLocale,e===fr()&&fr(e)):null!=lr[e]&&delete lr[e]);return lr[e]}function yr(e){var t;if(e&&e._locale&&e._locale._abbr&&(e=e._locale._abbr),!e)return ir;if(!i(e)){if(t=gr(e))return t;e=[e]}return dr(e)}function wr(){return M(lr)}function Cr(e){var t,r=e._a;return r&&-2===E(e).overflow&&(t=r[Ge]<0||r[Ge]>11?Ge:r[ze]<1||r[ze]>et(r[je],r[Ge])?ze:r[$e]<0||r[$e]>24||24===r[$e]&&(0!==r[Ke]||0!==r[Xe]||0!==r[qe])?$e:r[Ke]<0||r[Ke]>59?Ke:r[Xe]<0||r[Xe]>59?Xe:r[qe]<0||r[qe]>999?qe:-1,E(e)._overflowDayOfYear&&(t<je||t>ze)&&(t=ze),E(e)._overflowWeeks&&-1===t&&(t=Qe),E(e)._overflowWeekday&&-1===t&&(t=Ze),E(e).overflow=t),e}var Rr=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,vr=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d|))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,Sr=/Z|[+-]\d\d(?::?\d\d)?/,Tr=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,!1],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,!1],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,!1],["YYYYDDD",/\d{7}/],["YYYYMM",/\d{6}/,!1],["YYYY",/\d{4}/,!1]],Nr=[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]],_r=/^\/?Date\((-?\d+)/i,Mr=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/,Ar={UT:0,GMT:0,EDT:-240,EST:-300,CDT:-300,CST:-360,MDT:-360,MST:-420,PDT:-420,PST:-480};function br(e){var t,r,n,s,o,i,a=e._i,l=Rr.exec(a)||vr.exec(a),h=Tr.length,u=Nr.length;if(l){for(E(e).iso=!0,t=0,r=h;t<r;t++)if(Tr[t][1].exec(l[1])){s=Tr[t][0],n=!1!==Tr[t][2];break}if(null==s)return void(e._isValid=!1);if(l[3]){for(t=0,r=u;t<r;t++)if(Nr[t][1].exec(l[3])){o=(l[2]||" ")+Nr[t][0];break}if(null==o)return void(e._isValid=!1)}if(!n&&null!=o)return void(e._isValid=!1);if(l[4]){if(!Sr.exec(l[4]))return void(e._isValid=!1);i="Z"}e._f=s+(o||"")+(i||""),Br(e)}else e._isValid=!1}function Ir(e,t,r,n,s,o){var i=[Or(e),rt.indexOf(t),parseInt(r,10),parseInt(n,10),parseInt(s,10)];return o&&i.push(parseInt(o,10)),i}function Or(e){var t=parseInt(e,10);return t<=49?2e3+t:t<=999?1900+t:t}function xr(e){return e.replace(/\([^()]*\)|[\n\t]/g," ").replace(/(\s\s+)/g," ").replace(/^\s\s*/,"").replace(/\s\s*$/,"")}function Pr(e,t,r){return!e||Dt.indexOf(e)===new Date(t[0],t[1],t[2]).getDay()||(E(r).weekdayMismatch=!0,r._isValid=!1,!1)}function Lr(e,t,r){if(e)return Ar[e];if(t)return 0;var n=parseInt(r,10),s=n%100;return(n-s)/100*60+s}function Dr(e){var t,r=Mr.exec(xr(e._i));if(r){if(t=Ir(r[4],r[3],r[2],r[5],r[6],r[7]),!Pr(r[1],t,e))return;e._a=t,e._tzm=Lr(r[8],r[9],r[10]),e._d=Ct.apply(null,e._a),e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),E(e).rfc2822=!0}else e._isValid=!1}function kr(e){var t=_r.exec(e._i);null===t?(br(e),!1===e._isValid&&(delete e._isValid,Dr(e),!1===e._isValid&&(delete e._isValid,e._strict?e._isValid=!1:s.createFromInputFallback(e)))):e._d=new Date(+t[1])}function Hr(e,t,r){return null!=e?e:null!=t?t:r}function Fr(e){var t=new Date(s.now());return e._useUTC?[t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate()]:[t.getFullYear(),t.getMonth(),t.getDate()]}function Ur(e){var t,r,n,s,o,i=[];if(!e._d){for(n=Fr(e),e._w&&null==e._a[ze]&&null==e._a[Ge]&&Vr(e),null!=e._dayOfYear&&(o=Hr(e._a[je],n[je]),(e._dayOfYear>mt(o)||0===e._dayOfYear)&&(E(e)._overflowDayOfYear=!0),r=Ct(o,0,e._dayOfYear),e._a[Ge]=r.getUTCMonth(),e._a[ze]=r.getUTCDate()),t=0;t<3&&null==e._a[t];++t)e._a[t]=i[t]=n[t];for(;t<7;t++)e._a[t]=i[t]=null==e._a[t]?2===t?1:0:e._a[t];24===e._a[$e]&&0===e._a[Ke]&&0===e._a[Xe]&&0===e._a[qe]&&(e._nextDay=!0,e._a[$e]=0),e._d=(e._useUTC?Ct:wt).apply(null,i),s=e._useUTC?e._d.getUTCDay():e._d.getDay(),null!=e._tzm&&e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),e._nextDay&&(e._a[$e]=24),e._w&&void 0!==e._w.d&&e._w.d!==s&&(E(e).weekdayMismatch=!0)}}function Vr(e){var t,r,n,s,o,i,a,l,h;null!=(t=e._w).GG||null!=t.W||null!=t.E?(o=1,i=4,r=Hr(t.GG,e._a[je],St(Xr(),1,4).year),n=Hr(t.W,1),((s=Hr(t.E,1))<1||s>7)&&(l=!0)):(o=e._locale._week.dow,i=e._locale._week.doy,h=St(Xr(),o,i),r=Hr(t.gg,e._a[je],h.year),n=Hr(t.w,h.week),null!=t.d?((s=t.d)<0||s>6)&&(l=!0):null!=t.e?(s=t.e+o,(t.e<0||t.e>6)&&(l=!0)):s=o),n<1||n>Tt(r,o,i)?E(e)._overflowWeeks=!0:null!=l?E(e)._overflowWeekday=!0:(a=vt(r,n,s,o,i),e._a[je]=a.year,e._dayOfYear=a.dayOfYear)}function Br(e){if(e._f!==s.ISO_8601)if(e._f!==s.RFC_2822){e._a=[],E(e).empty=!0;var t,r,n,o,i,a,l,h=""+e._i,u=h.length,c=0;for(l=(n=G(e._f,e._locale).match(H)||[]).length,t=0;t<l;t++)o=n[t],(r=(h.match(ke(o,e))||[])[0])&&((i=h.substr(0,h.indexOf(r))).length>0&&E(e).unusedInput.push(i),h=h.slice(h.indexOf(r)+r.length),c+=r.length),V[o]?(r?E(e).empty=!1:E(e).unusedTokens.push(o),We(o,r,e)):e._strict&&!r&&E(e).unusedTokens.push(o);E(e).charsLeftOver=u-c,h.length>0&&E(e).unusedInput.push(h),e._a[$e]<=12&&!0===E(e).bigHour&&e._a[$e]>0&&(E(e).bigHour=void 0),E(e).parsedDateParts=e._a.slice(0),E(e).meridiem=e._meridiem,e._a[$e]=Wr(e._locale,e._a[$e],e._meridiem),null!==(a=E(e).era)&&(e._a[je]=e._locale.erasConvertYear(a,e._a[je])),Ur(e),Cr(e)}else Dr(e);else br(e)}function Wr(e,t,r){var n;return null==r?t:null!=e.meridiemHour?e.meridiemHour(t,r):null!=e.isPM?((n=e.isPM(r))&&t<12&&(t+=12),n||12!==t||(t=0),t):t}function Yr(e){var t,r,n,s,o,i,a=!1,l=e._f.length;if(0===l)return E(e).invalidFormat=!0,void(e._d=new Date(NaN));for(s=0;s<l;s++)o=0,i=!1,t=v({},e),null!=e._useUTC&&(t._useUTC=e._useUTC),t._f=e._f[s],Br(t),y(t)&&(i=!0),o+=E(t).charsLeftOver,o+=10*E(t).unusedTokens.length,E(t).score=o,a?o<n&&(n=o,r=t):(null==n||o<n||i)&&(n=o,r=t,i&&(a=!0));g(e,r||t)}function jr(e){if(!e._d){var t=oe(e._i),r=void 0===t.day?t.date:t.day;e._a=p([t.year,t.month,r,t.hour,t.minute,t.second,t.millisecond],(function(e){return e&&parseInt(e,10)})),Ur(e)}}function Gr(e){var t=new S(Cr(zr(e)));return t._nextDay&&(t.add(1,"d"),t._nextDay=void 0),t}function zr(e){var t=e._i,r=e._f;return e._locale=e._locale||yr(e._l),null===t||void 0===r&&""===t?w({nullInput:!0}):("string"==typeof t&&(e._i=t=e._locale.preparse(t)),T(t)?new S(Cr(t)):(d(t)?e._d=t:i(r)?Yr(e):r?Br(e):$r(e),y(e)||(e._d=null),e))}function $r(e){var t=e._i;u(t)?e._d=new Date(s.now()):d(t)?e._d=new Date(t.valueOf()):"string"==typeof t?kr(e):i(t)?(e._a=p(t.slice(0),(function(e){return parseInt(e,10)})),Ur(e)):a(t)?jr(e):c(t)?e._d=new Date(t):s.createFromInputFallback(e)}function Kr(e,t,r,n,s){var o={};return!0!==t&&!1!==t||(n=t,t=void 0),!0!==r&&!1!==r||(n=r,r=void 0),(a(e)&&h(e)||i(e)&&0===e.length)&&(e=void 0),o._isAMomentObject=!0,o._useUTC=o._isUTC=s,o._l=r,o._i=e,o._f=t,o._strict=n,Gr(o)}function Xr(e,t,r,n){return Kr(e,t,r,n,!1)}s.createFromInputFallback=_("value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",(function(e){e._d=new Date(e._i+(e._useUTC?" UTC":""))})),s.ISO_8601=function(){},s.RFC_2822=function(){};var qr=_("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",(function(){var e=Xr.apply(null,arguments);return this.isValid()&&e.isValid()?e<this?this:e:w()})),Qr=_("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",(function(){var e=Xr.apply(null,arguments);return this.isValid()&&e.isValid()?e>this?this:e:w()}));function Zr(e,t){var r,n;if(1===t.length&&i(t[0])&&(t=t[0]),!t.length)return Xr();for(r=t[0],n=1;n<t.length;++n)t[n].isValid()&&!t[n][e](r)||(r=t[n]);return r}function Jr(){return Zr("isBefore",[].slice.call(arguments,0))}function en(){return Zr("isAfter",[].slice.call(arguments,0))}var tn=function(){return Date.now?Date.now():+new Date},rn=["year","quarter","month","week","day","hour","minute","second","millisecond"];function nn(e){var t,r,n=!1,s=rn.length;for(t in e)if(l(e,t)&&(-1===Ye.call(rn,t)||null!=e[t]&&isNaN(e[t])))return!1;for(r=0;r<s;++r)if(e[rn[r]]){if(n)return!1;parseFloat(e[rn[r]])!==ce(e[rn[r]])&&(n=!0)}return!0}function sn(){return this._isValid}function on(){return bn(NaN)}function an(e){var t=oe(e),r=t.year||0,n=t.quarter||0,s=t.month||0,o=t.week||t.isoWeek||0,i=t.day||0,a=t.hour||0,l=t.minute||0,h=t.second||0,u=t.millisecond||0;this._isValid=nn(t),this._milliseconds=+u+1e3*h+6e4*l+1e3*a*60*60,this._days=+i+7*o,this._months=+s+3*n+12*r,this._data={},this._locale=yr(),this._bubble()}function ln(e){return e instanceof an}function hn(e){return e<0?-1*Math.round(-1*e):Math.round(e)}function un(e,t,r){var n,s=Math.min(e.length,t.length),o=Math.abs(e.length-t.length),i=0;for(n=0;n<s;n++)(r&&e[n]!==t[n]||!r&&ce(e[n])!==ce(t[n]))&&i++;return i+o}function cn(e,t){B(e,0,0,(function(){var e=this.utcOffset(),r="+";return e<0&&(e=-e,r="-"),r+k(~~(e/60),2)+t+k(~~e%60,2)}))}cn("Z",":"),cn("ZZ",""),De("Z",xe),De("ZZ",xe),Ve(["Z","ZZ"],(function(e,t,r){r._useUTC=!0,r._tzm=pn(xe,e)}));var dn=/([\+\-]|\d\d)/gi;function pn(e,t){var r,n,s=(t||"").match(e);return null===s?null:0===(n=60*(r=((s[s.length-1]||[])+"").match(dn)||["-",0,0])[1]+ce(r[2]))?0:"+"===r[0]?n:-n}function gn(e,t){var r,n;return t._isUTC?(r=t.clone(),n=(T(e)||d(e)?e.valueOf():Xr(e).valueOf())-r.valueOf(),r._d.setTime(r._d.valueOf()+n),s.updateOffset(r,!1),r):Xr(e).local()}function fn(e){return-Math.round(e._d.getTimezoneOffset())}function mn(e,t,r){var n,o=this._offset||0;if(!this.isValid())return null!=e?this:NaN;if(null!=e){if("string"==typeof e){if(null===(e=pn(xe,e)))return this}else Math.abs(e)<16&&!r&&(e*=60);return!this._isUTC&&t&&(n=fn(this)),this._offset=e,this._isUTC=!0,null!=n&&this.add(n,"m"),o!==e&&(!t||this._changeInProgress?Ln(this,bn(e-o,"m"),1,!1):this._changeInProgress||(this._changeInProgress=!0,s.updateOffset(this,!0),this._changeInProgress=null)),this}return this._isUTC?o:fn(this)}function En(e,t){return null!=e?("string"!=typeof e&&(e=-e),this.utcOffset(e,t),this):-this.utcOffset()}function yn(e){return this.utcOffset(0,e)}function wn(e){return this._isUTC&&(this.utcOffset(0,e),this._isUTC=!1,e&&this.subtract(fn(this),"m")),this}function Cn(){if(null!=this._tzm)this.utcOffset(this._tzm,!1,!0);else if("string"==typeof this._i){var e=pn(Oe,this._i);null!=e?this.utcOffset(e):this.utcOffset(0,!0)}return this}function Rn(e){return!!this.isValid()&&(e=e?Xr(e).utcOffset():0,(this.utcOffset()-e)%60==0)}function vn(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()}function Sn(){if(!u(this._isDSTShifted))return this._isDSTShifted;var e,t={};return v(t,this),(t=zr(t))._a?(e=t._isUTC?f(t._a):Xr(t._a),this._isDSTShifted=this.isValid()&&un(t._a,e.toArray())>0):this._isDSTShifted=!1,this._isDSTShifted}function Tn(){return!!this.isValid()&&!this._isUTC}function Nn(){return!!this.isValid()&&this._isUTC}function _n(){return!!this.isValid()&&this._isUTC&&0===this._offset}s.updateOffset=function(){};var Mn=/^(-|\+)?(?:(\d*)[. ])?(\d+):(\d+)(?::(\d+)(\.\d*)?)?$/,An=/^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;function bn(e,t){var r,n,s,o=e,i=null;return ln(e)?o={ms:e._milliseconds,d:e._days,M:e._months}:c(e)||!isNaN(+e)?(o={},t?o[t]=+e:o.milliseconds=+e):(i=Mn.exec(e))?(r="-"===i[1]?-1:1,o={y:0,d:ce(i[ze])*r,h:ce(i[$e])*r,m:ce(i[Ke])*r,s:ce(i[Xe])*r,ms:ce(hn(1e3*i[qe]))*r}):(i=An.exec(e))?(r="-"===i[1]?-1:1,o={y:In(i[2],r),M:In(i[3],r),w:In(i[4],r),d:In(i[5],r),h:In(i[6],r),m:In(i[7],r),s:In(i[8],r)}):null==o?o={}:"object"==typeof o&&("from"in o||"to"in o)&&(s=xn(Xr(o.from),Xr(o.to)),(o={}).ms=s.milliseconds,o.M=s.months),n=new an(o),ln(e)&&l(e,"_locale")&&(n._locale=e._locale),ln(e)&&l(e,"_isValid")&&(n._isValid=e._isValid),n}function In(e,t){var r=e&&parseFloat(e.replace(",","."));return(isNaN(r)?0:r)*t}function On(e,t){var r={};return r.months=t.month()-e.month()+12*(t.year()-e.year()),e.clone().add(r.months,"M").isAfter(t)&&--r.months,r.milliseconds=+t-+e.clone().add(r.months,"M"),r}function xn(e,t){var r;return e.isValid()&&t.isValid()?(t=gn(t,e),e.isBefore(t)?r=On(e,t):((r=On(t,e)).milliseconds=-r.milliseconds,r.months=-r.months),r):{milliseconds:0,months:0}}function Pn(e,t){return function(r,n){var s;return null===n||isNaN(+n)||(b(t,"moment()."+t+"(period, number) is deprecated. Please use moment()."+t+"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info."),s=r,r=n,n=s),Ln(this,bn(r,n),e),this}}function Ln(e,t,r,n){var o=t._milliseconds,i=hn(t._days),a=hn(t._months);e.isValid()&&(n=null==n||n,a&&ut(e,pe(e,"Month")+a*r),i&&ge(e,"Date",pe(e,"Date")+i*r),o&&e._d.setTime(e._d.valueOf()+o*r),n&&s.updateOffset(e,i||a))}bn.fn=an.prototype,bn.invalid=on;var Dn=Pn(1,"add"),kn=Pn(-1,"subtract");function Hn(e){return"string"==typeof e||e instanceof String}function Fn(e){return T(e)||d(e)||Hn(e)||c(e)||Vn(e)||Un(e)||null==e}function Un(e){var t,r,n=a(e)&&!h(e),s=!1,o=["years","year","y","months","month","M","days","day","d","dates","date","D","hours","hour","h","minutes","minute","m","seconds","second","s","milliseconds","millisecond","ms"],i=o.length;for(t=0;t<i;t+=1)r=o[t],s=s||l(e,r);return n&&s}function Vn(e){var t=i(e),r=!1;return t&&(r=0===e.filter((function(t){return!c(t)&&Hn(e)})).length),t&&r}function Bn(e){var t,r,n=a(e)&&!h(e),s=!1,o=["sameDay","nextDay","lastDay","nextWeek","lastWeek","sameElse"];for(t=0;t<o.length;t+=1)r=o[t],s=s||l(e,r);return n&&s}function Wn(e,t){var r=e.diff(t,"days",!0);return r<-6?"sameElse":r<-1?"lastWeek":r<0?"lastDay":r<1?"sameDay":r<2?"nextDay":r<7?"nextWeek":"sameElse"}function Yn(e,t){1===arguments.length&&(arguments[0]?Fn(arguments[0])?(e=arguments[0],t=void 0):Bn(arguments[0])&&(t=arguments[0],e=void 0):(e=void 0,t=void 0));var r=e||Xr(),n=gn(r,this).startOf("day"),o=s.calendarFormat(this,n)||"sameElse",i=t&&(I(t[o])?t[o].call(this,r):t[o]);return this.format(i||this.localeData().calendar(o,this,Xr(r)))}function jn(){return new S(this)}function Gn(e,t){var r=T(e)?e:Xr(e);return!(!this.isValid()||!r.isValid())&&("millisecond"===(t=se(t)||"millisecond")?this.valueOf()>r.valueOf():r.valueOf()<this.clone().startOf(t).valueOf())}function zn(e,t){var r=T(e)?e:Xr(e);return!(!this.isValid()||!r.isValid())&&("millisecond"===(t=se(t)||"millisecond")?this.valueOf()<r.valueOf():this.clone().endOf(t).valueOf()<r.valueOf())}function $n(e,t,r,n){var s=T(e)?e:Xr(e),o=T(t)?t:Xr(t);return!!(this.isValid()&&s.isValid()&&o.isValid())&&("("===(n=n||"()")[0]?this.isAfter(s,r):!this.isBefore(s,r))&&(")"===n[1]?this.isBefore(o,r):!this.isAfter(o,r))}function Kn(e,t){var r,n=T(e)?e:Xr(e);return!(!this.isValid()||!n.isValid())&&("millisecond"===(t=se(t)||"millisecond")?this.valueOf()===n.valueOf():(r=n.valueOf(),this.clone().startOf(t).valueOf()<=r&&r<=this.clone().endOf(t).valueOf()))}function Xn(e,t){return this.isSame(e,t)||this.isAfter(e,t)}function qn(e,t){return this.isSame(e,t)||this.isBefore(e,t)}function Qn(e,t,r){var n,s,o;if(!this.isValid())return NaN;if(!(n=gn(e,this)).isValid())return NaN;switch(s=6e4*(n.utcOffset()-this.utcOffset()),t=se(t)){case"year":o=Zn(this,n)/12;break;case"month":o=Zn(this,n);break;case"quarter":o=Zn(this,n)/3;break;case"second":o=(this-n)/1e3;break;case"minute":o=(this-n)/6e4;break;case"hour":o=(this-n)/36e5;break;case"day":o=(this-n-s)/864e5;break;case"week":o=(this-n-s)/6048e5;break;default:o=this-n}return r?o:ue(o)}function Zn(e,t){if(e.date()<t.date())return-Zn(t,e);var r=12*(t.year()-e.year())+(t.month()-e.month()),n=e.clone().add(r,"months");return-(r+(t-n<0?(t-n)/(n-e.clone().add(r-1,"months")):(t-n)/(e.clone().add(r+1,"months")-n)))||0}function Jn(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")}function es(e){if(!this.isValid())return null;var t=!0!==e,r=t?this.clone().utc():this;return r.year()<0||r.year()>9999?j(r,t?"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYYYY-MM-DD[T]HH:mm:ss.SSSZ"):I(Date.prototype.toISOString)?t?this.toDate().toISOString():new Date(this.valueOf()+60*this.utcOffset()*1e3).toISOString().replace("Z",j(r,"Z")):j(r,t?"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYY-MM-DD[T]HH:mm:ss.SSSZ")}function ts(){if(!this.isValid())return"moment.invalid(/* "+this._i+" */)";var e,t,r,n,s="moment",o="";return this.isLocal()||(s=0===this.utcOffset()?"moment.utc":"moment.parseZone",o="Z"),e="["+s+'("]',t=0<=this.year()&&this.year()<=9999?"YYYY":"YYYYYY",r="-MM-DD[T]HH:mm:ss.SSS",n=o+'[")]',this.format(e+t+r+n)}function rs(e){e||(e=this.isUtc()?s.defaultFormatUtc:s.defaultFormat);var t=j(this,e);return this.localeData().postformat(t)}function ns(e,t){return this.isValid()&&(T(e)&&e.isValid()||Xr(e).isValid())?bn({to:this,from:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()}function ss(e){return this.from(Xr(),e)}function os(e,t){return this.isValid()&&(T(e)&&e.isValid()||Xr(e).isValid())?bn({from:this,to:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()}function is(e){return this.to(Xr(),e)}function as(e){var t;return void 0===e?this._locale._abbr:(null!=(t=yr(e))&&(this._locale=t),this)}s.defaultFormat="YYYY-MM-DDTHH:mm:ssZ",s.defaultFormatUtc="YYYY-MM-DDTHH:mm:ss[Z]";var ls=_("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",(function(e){return void 0===e?this.localeData():this.locale(e)}));function hs(){return this._locale}var us=1e3,cs=60*us,ds=60*cs,ps=3506328*ds;function gs(e,t){return(e%t+t)%t}function fs(e,t,r){return e<100&&e>=0?new Date(e+400,t,r)-ps:new Date(e,t,r).valueOf()}function ms(e,t,r){return e<100&&e>=0?Date.UTC(e+400,t,r)-ps:Date.UTC(e,t,r)}function Es(e){var t,r;if(void 0===(e=se(e))||"millisecond"===e||!this.isValid())return this;switch(r=this._isUTC?ms:fs,e){case"year":t=r(this.year(),0,1);break;case"quarter":t=r(this.year(),this.month()-this.month()%3,1);break;case"month":t=r(this.year(),this.month(),1);break;case"week":t=r(this.year(),this.month(),this.date()-this.weekday());break;case"isoWeek":t=r(this.year(),this.month(),this.date()-(this.isoWeekday()-1));break;case"day":case"date":t=r(this.year(),this.month(),this.date());break;case"hour":t=this._d.valueOf(),t-=gs(t+(this._isUTC?0:this.utcOffset()*cs),ds);break;case"minute":t=this._d.valueOf(),t-=gs(t,cs);break;case"second":t=this._d.valueOf(),t-=gs(t,us)}return this._d.setTime(t),s.updateOffset(this,!0),this}function ys(e){var t,r;if(void 0===(e=se(e))||"millisecond"===e||!this.isValid())return this;switch(r=this._isUTC?ms:fs,e){case"year":t=r(this.year()+1,0,1)-1;break;case"quarter":t=r(this.year(),this.month()-this.month()%3+3,1)-1;break;case"month":t=r(this.year(),this.month()+1,1)-1;break;case"week":t=r(this.year(),this.month(),this.date()-this.weekday()+7)-1;break;case"isoWeek":t=r(this.year(),this.month(),this.date()-(this.isoWeekday()-1)+7)-1;break;case"day":case"date":t=r(this.year(),this.month(),this.date()+1)-1;break;case"hour":t=this._d.valueOf(),t+=ds-gs(t+(this._isUTC?0:this.utcOffset()*cs),ds)-1;break;case"minute":t=this._d.valueOf(),t+=cs-gs(t,cs)-1;break;case"second":t=this._d.valueOf(),t+=us-gs(t,us)-1}return this._d.setTime(t),s.updateOffset(this,!0),this}function ws(){return this._d.valueOf()-6e4*(this._offset||0)}function Cs(){return Math.floor(this.valueOf()/1e3)}function Rs(){return new Date(this.valueOf())}function vs(){var e=this;return[e.year(),e.month(),e.date(),e.hour(),e.minute(),e.second(),e.millisecond()]}function Ss(){var e=this;return{years:e.year(),months:e.month(),date:e.date(),hours:e.hours(),minutes:e.minutes(),seconds:e.seconds(),milliseconds:e.milliseconds()}}function Ts(){return this.isValid()?this.toISOString():null}function Ns(){return y(this)}function _s(){return g({},E(this))}function Ms(){return E(this).overflow}function As(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}}function bs(e,t){var r,n,o,i=this._eras||yr("en")._eras;for(r=0,n=i.length;r<n;++r)switch("string"==typeof i[r].since&&(o=s(i[r].since).startOf("day"),i[r].since=o.valueOf()),typeof i[r].until){case"undefined":i[r].until=1/0;break;case"string":o=s(i[r].until).startOf("day").valueOf(),i[r].until=o.valueOf()}return i}function Is(e,t,r){var n,s,o,i,a,l=this.eras();for(e=e.toUpperCase(),n=0,s=l.length;n<s;++n)if(o=l[n].name.toUpperCase(),i=l[n].abbr.toUpperCase(),a=l[n].narrow.toUpperCase(),r)switch(t){case"N":case"NN":case"NNN":if(i===e)return l[n];break;case"NNNN":if(o===e)return l[n];break;case"NNNNN":if(a===e)return l[n]}else if([o,i,a].indexOf(e)>=0)return l[n]}function Os(e,t){var r=e.since<=e.until?1:-1;return void 0===t?s(e.since).year():s(e.since).year()+(t-e.offset)*r}function xs(){var e,t,r,n=this.localeData().eras();for(e=0,t=n.length;e<t;++e){if(r=this.clone().startOf("day").valueOf(),n[e].since<=r&&r<=n[e].until)return n[e].name;if(n[e].until<=r&&r<=n[e].since)return n[e].name}return""}function Ps(){var e,t,r,n=this.localeData().eras();for(e=0,t=n.length;e<t;++e){if(r=this.clone().startOf("day").valueOf(),n[e].since<=r&&r<=n[e].until)return n[e].narrow;if(n[e].until<=r&&r<=n[e].since)return n[e].narrow}return""}function Ls(){var e,t,r,n=this.localeData().eras();for(e=0,t=n.length;e<t;++e){if(r=this.clone().startOf("day").valueOf(),n[e].since<=r&&r<=n[e].until)return n[e].abbr;if(n[e].until<=r&&r<=n[e].since)return n[e].abbr}return""}function Ds(){var e,t,r,n,o=this.localeData().eras();for(e=0,t=o.length;e<t;++e)if(r=o[e].since<=o[e].until?1:-1,n=this.clone().startOf("day").valueOf(),o[e].since<=n&&n<=o[e].until||o[e].until<=n&&n<=o[e].since)return(this.year()-s(o[e].since).year())*r+o[e].offset;return this.year()}function ks(e){return l(this,"_erasNameRegex")||Ys.call(this),e?this._erasNameRegex:this._erasRegex}function Hs(e){return l(this,"_erasAbbrRegex")||Ys.call(this),e?this._erasAbbrRegex:this._erasRegex}function Fs(e){return l(this,"_erasNarrowRegex")||Ys.call(this),e?this._erasNarrowRegex:this._erasRegex}function Us(e,t){return t.erasAbbrRegex(e)}function Vs(e,t){return t.erasNameRegex(e)}function Bs(e,t){return t.erasNarrowRegex(e)}function Ws(e,t){return t._eraYearOrdinalRegex||be}function Ys(){var e,t,r=[],n=[],s=[],o=[],i=this.eras();for(e=0,t=i.length;e<t;++e)n.push(Fe(i[e].name)),r.push(Fe(i[e].abbr)),s.push(Fe(i[e].narrow)),o.push(Fe(i[e].name)),o.push(Fe(i[e].abbr)),o.push(Fe(i[e].narrow));this._erasRegex=new RegExp("^("+o.join("|")+")","i"),this._erasNameRegex=new RegExp("^("+n.join("|")+")","i"),this._erasAbbrRegex=new RegExp("^("+r.join("|")+")","i"),this._erasNarrowRegex=new RegExp("^("+s.join("|")+")","i")}function js(e,t){B(0,[e,e.length],0,t)}function Gs(e){return Qs.call(this,e,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)}function zs(e){return Qs.call(this,e,this.isoWeek(),this.isoWeekday(),1,4)}function $s(){return Tt(this.year(),1,4)}function Ks(){return Tt(this.isoWeekYear(),1,4)}function Xs(){var e=this.localeData()._week;return Tt(this.year(),e.dow,e.doy)}function qs(){var e=this.localeData()._week;return Tt(this.weekYear(),e.dow,e.doy)}function Qs(e,t,r,n,s){var o;return null==e?St(this,n,s).year:(t>(o=Tt(e,n,s))&&(t=o),Zs.call(this,e,t,r,n,s))}function Zs(e,t,r,n,s){var o=vt(e,t,r,n,s),i=Ct(o.year,0,o.dayOfYear);return this.year(i.getUTCFullYear()),this.month(i.getUTCMonth()),this.date(i.getUTCDate()),this}function Js(e){return null==e?Math.ceil((this.month()+1)/3):this.month(3*(e-1)+this.month()%3)}B("N",0,0,"eraAbbr"),B("NN",0,0,"eraAbbr"),B("NNN",0,0,"eraAbbr"),B("NNNN",0,0,"eraName"),B("NNNNN",0,0,"eraNarrow"),B("y",["y",1],"yo","eraYear"),B("y",["yy",2],0,"eraYear"),B("y",["yyy",3],0,"eraYear"),B("y",["yyyy",4],0,"eraYear"),De("N",Us),De("NN",Us),De("NNN",Us),De("NNNN",Vs),De("NNNNN",Bs),Ve(["N","NN","NNN","NNNN","NNNNN"],(function(e,t,r,n){var s=r._locale.erasParse(e,n,r._strict);s?E(r).era=s:E(r).invalidEra=e})),De("y",be),De("yy",be),De("yyy",be),De("yyyy",be),De("yo",Ws),Ve(["y","yy","yyy","yyyy"],je),Ve(["yo"],(function(e,t,r,n){var s;r._locale._eraYearOrdinalRegex&&(s=e.match(r._locale._eraYearOrdinalRegex)),r._locale.eraYearOrdinalParse?t[je]=r._locale.eraYearOrdinalParse(e,s):t[je]=parseInt(e,10)})),B(0,["gg",2],0,(function(){return this.weekYear()%100})),B(0,["GG",2],0,(function(){return this.isoWeekYear()%100})),js("gggg","weekYear"),js("ggggg","weekYear"),js("GGGG","isoWeekYear"),js("GGGGG","isoWeekYear"),ne("weekYear","gg"),ne("isoWeekYear","GG"),ae("weekYear",1),ae("isoWeekYear",1),De("G",Ie),De("g",Ie),De("GG",Se,we),De("gg",Se,we),De("GGGG",Me,Re),De("gggg",Me,Re),De("GGGGG",Ae,ve),De("ggggg",Ae,ve),Be(["gggg","ggggg","GGGG","GGGGG"],(function(e,t,r,n){t[n.substr(0,2)]=ce(e)})),Be(["gg","GG"],(function(e,t,r,n){t[n]=s.parseTwoDigitYear(e)})),B("Q",0,"Qo","quarter"),ne("quarter","Q"),ae("quarter",7),De("Q",ye),Ve("Q",(function(e,t){t[Ge]=3*(ce(e)-1)})),B("D",["DD",2],"Do","date"),ne("date","D"),ae("date",9),De("D",Se),De("DD",Se,we),De("Do",(function(e,t){return e?t._dayOfMonthOrdinalParse||t._ordinalParse:t._dayOfMonthOrdinalParseLenient})),Ve(["D","DD"],ze),Ve("Do",(function(e,t){t[ze]=ce(e.match(Se)[0])}));var eo=de("Date",!0);function to(e){var t=Math.round((this.clone().startOf("day")-this.clone().startOf("year"))/864e5)+1;return null==e?t:this.add(e-t,"d")}B("DDD",["DDDD",3],"DDDo","dayOfYear"),ne("dayOfYear","DDD"),ae("dayOfYear",4),De("DDD",_e),De("DDDD",Ce),Ve(["DDD","DDDD"],(function(e,t,r){r._dayOfYear=ce(e)})),B("m",["mm",2],0,"minute"),ne("minute","m"),ae("minute",14),De("m",Se),De("mm",Se,we),Ve(["m","mm"],Ke);var ro=de("Minutes",!1);B("s",["ss",2],0,"second"),ne("second","s"),ae("second",15),De("s",Se),De("ss",Se,we),Ve(["s","ss"],Xe);var no,so,oo=de("Seconds",!1);for(B("S",0,0,(function(){return~~(this.millisecond()/100)})),B(0,["SS",2],0,(function(){return~~(this.millisecond()/10)})),B(0,["SSS",3],0,"millisecond"),B(0,["SSSS",4],0,(function(){return 10*this.millisecond()})),B(0,["SSSSS",5],0,(function(){return 100*this.millisecond()})),B(0,["SSSSSS",6],0,(function(){return 1e3*this.millisecond()})),B(0,["SSSSSSS",7],0,(function(){return 1e4*this.millisecond()})),B(0,["SSSSSSSS",8],0,(function(){return 1e5*this.millisecond()})),B(0,["SSSSSSSSS",9],0,(function(){return 1e6*this.millisecond()})),ne("millisecond","ms"),ae("millisecond",16),De("S",_e,ye),De("SS",_e,we),De("SSS",_e,Ce),no="SSSS";no.length<=9;no+="S")De(no,be);function io(e,t){t[qe]=ce(1e3*("0."+e))}for(no="S";no.length<=9;no+="S")Ve(no,io);function ao(){return this._isUTC?"UTC":""}function lo(){return this._isUTC?"Coordinated Universal Time":""}so=de("Milliseconds",!1),B("z",0,0,"zoneAbbr"),B("zz",0,0,"zoneName");var ho=S.prototype;function uo(e){return Xr(1e3*e)}function co(){return Xr.apply(null,arguments).parseZone()}function po(e){return e}ho.add=Dn,ho.calendar=Yn,ho.clone=jn,ho.diff=Qn,ho.endOf=ys,ho.format=rs,ho.from=ns,ho.fromNow=ss,ho.to=os,ho.toNow=is,ho.get=fe,ho.invalidAt=Ms,ho.isAfter=Gn,ho.isBefore=zn,ho.isBetween=$n,ho.isSame=Kn,ho.isSameOrAfter=Xn,ho.isSameOrBefore=qn,ho.isValid=Ns,ho.lang=ls,ho.locale=as,ho.localeData=hs,ho.max=Qr,ho.min=qr,ho.parsingFlags=_s,ho.set=me,ho.startOf=Es,ho.subtract=kn,ho.toArray=vs,ho.toObject=Ss,ho.toDate=Rs,ho.toISOString=es,ho.inspect=ts,"undefined"!=typeof Symbol&&null!=Symbol.for&&(ho[Symbol.for("nodejs.util.inspect.custom")]=function(){return"Moment<"+this.format()+">"}),ho.toJSON=Ts,ho.toString=Jn,ho.unix=Cs,ho.valueOf=ws,ho.creationData=As,ho.eraName=xs,ho.eraNarrow=Ps,ho.eraAbbr=Ls,ho.eraYear=Ds,ho.year=Et,ho.isLeapYear=yt,ho.weekYear=Gs,ho.isoWeekYear=zs,ho.quarter=ho.quarters=Js,ho.month=ct,ho.daysInMonth=dt,ho.week=ho.weeks=bt,ho.isoWeek=ho.isoWeeks=It,ho.weeksInYear=Xs,ho.weeksInWeekYear=qs,ho.isoWeeksInYear=$s,ho.isoWeeksInISOWeekYear=Ks,ho.date=eo,ho.day=ho.days=Gt,ho.weekday=zt,ho.isoWeekday=$t,ho.dayOfYear=to,ho.hour=ho.hours=sr,ho.minute=ho.minutes=ro,ho.second=ho.seconds=oo,ho.millisecond=ho.milliseconds=so,ho.utcOffset=mn,ho.utc=yn,ho.local=wn,ho.parseZone=Cn,ho.hasAlignedHourOffset=Rn,ho.isDST=vn,ho.isLocal=Tn,ho.isUtcOffset=Nn,ho.isUtc=_n,ho.isUTC=_n,ho.zoneAbbr=ao,ho.zoneName=lo,ho.dates=_("dates accessor is deprecated. Use date instead.",eo),ho.months=_("months accessor is deprecated. Use month instead",ct),ho.years=_("years accessor is deprecated. Use year instead",Et),ho.zone=_("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",En),ho.isDSTShifted=_("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",Sn);var go=P.prototype;function fo(e,t,r,n){var s=yr(),o=f().set(n,t);return s[r](o,e)}function mo(e,t,r){if(c(e)&&(t=e,e=void 0),e=e||"",null!=t)return fo(e,t,r,"month");var n,s=[];for(n=0;n<12;n++)s[n]=fo(e,n,r,"month");return s}function Eo(e,t,r,n){"boolean"==typeof e?(c(t)&&(r=t,t=void 0),t=t||""):(r=t=e,e=!1,c(t)&&(r=t,t=void 0),t=t||"");var s,o=yr(),i=e?o._week.dow:0,a=[];if(null!=r)return fo(t,(r+i)%7,n,"day");for(s=0;s<7;s++)a[s]=fo(t,(s+i)%7,n,"day");return a}function yo(e,t){return mo(e,t,"months")}function wo(e,t){return mo(e,t,"monthsShort")}function Co(e,t,r){return Eo(e,t,r,"weekdays")}function Ro(e,t,r){return Eo(e,t,r,"weekdaysShort")}function vo(e,t,r){return Eo(e,t,r,"weekdaysMin")}go.calendar=D,go.longDateFormat=$,go.invalidDate=X,go.ordinal=Z,go.preparse=po,go.postformat=po,go.relativeTime=ee,go.pastFuture=te,go.set=O,go.eras=bs,go.erasParse=Is,go.erasConvertYear=Os,go.erasAbbrRegex=Hs,go.erasNameRegex=ks,go.erasNarrowRegex=Fs,go.months=it,go.monthsShort=at,go.monthsParse=ht,go.monthsRegex=gt,go.monthsShortRegex=pt,go.week=Nt,go.firstDayOfYear=At,go.firstDayOfWeek=Mt,go.weekdays=Vt,go.weekdaysMin=Wt,go.weekdaysShort=Bt,go.weekdaysParse=jt,go.weekdaysRegex=Kt,go.weekdaysShortRegex=Xt,go.weekdaysMinRegex=qt,go.isPM=rr,go.meridiem=or,fr("en",{eras:[{since:"0001-01-01",until:1/0,offset:1,name:"Anno Domini",narrow:"AD",abbr:"AD"},{since:"0000-12-31",until:-1/0,offset:1,name:"Before Christ",narrow:"BC",abbr:"BC"}],dayOfMonthOrdinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(e){var t=e%10;return e+(1===ce(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th")}}),s.lang=_("moment.lang is deprecated. Use moment.locale instead.",fr),s.langData=_("moment.langData is deprecated. Use moment.localeData instead.",yr);var So=Math.abs;function To(){var e=this._data;return this._milliseconds=So(this._milliseconds),this._days=So(this._days),this._months=So(this._months),e.milliseconds=So(e.milliseconds),e.seconds=So(e.seconds),e.minutes=So(e.minutes),e.hours=So(e.hours),e.months=So(e.months),e.years=So(e.years),this}function No(e,t,r,n){var s=bn(t,r);return e._milliseconds+=n*s._milliseconds,e._days+=n*s._days,e._months+=n*s._months,e._bubble()}function _o(e,t){return No(this,e,t,1)}function Mo(e,t){return No(this,e,t,-1)}function Ao(e){return e<0?Math.floor(e):Math.ceil(e)}function bo(){var e,t,r,n,s,o=this._milliseconds,i=this._days,a=this._months,l=this._data;return o>=0&&i>=0&&a>=0||o<=0&&i<=0&&a<=0||(o+=864e5*Ao(Oo(a)+i),i=0,a=0),l.milliseconds=o%1e3,e=ue(o/1e3),l.seconds=e%60,t=ue(e/60),l.minutes=t%60,r=ue(t/60),l.hours=r%24,i+=ue(r/24),a+=s=ue(Io(i)),i-=Ao(Oo(s)),n=ue(a/12),a%=12,l.days=i,l.months=a,l.years=n,this}function Io(e){return 4800*e/146097}function Oo(e){return 146097*e/4800}function xo(e){if(!this.isValid())return NaN;var t,r,n=this._milliseconds;if("month"===(e=se(e))||"quarter"===e||"year"===e)switch(t=this._days+n/864e5,r=this._months+Io(t),e){case"month":return r;case"quarter":return r/3;case"year":return r/12}else switch(t=this._days+Math.round(Oo(this._months)),e){case"week":return t/7+n/6048e5;case"day":return t+n/864e5;case"hour":return 24*t+n/36e5;case"minute":return 1440*t+n/6e4;case"second":return 86400*t+n/1e3;case"millisecond":return Math.floor(864e5*t)+n;default:throw new Error("Unknown unit "+e)}}function Po(){return this.isValid()?this._milliseconds+864e5*this._days+this._months%12*2592e6+31536e6*ce(this._months/12):NaN}function Lo(e){return function(){return this.as(e)}}var Do=Lo("ms"),ko=Lo("s"),Ho=Lo("m"),Fo=Lo("h"),Uo=Lo("d"),Vo=Lo("w"),Bo=Lo("M"),Wo=Lo("Q"),Yo=Lo("y");function jo(){return bn(this)}function Go(e){return e=se(e),this.isValid()?this[e+"s"]():NaN}function zo(e){return function(){return this.isValid()?this._data[e]:NaN}}var $o=zo("milliseconds"),Ko=zo("seconds"),Xo=zo("minutes"),qo=zo("hours"),Qo=zo("days"),Zo=zo("months"),Jo=zo("years");function ei(){return ue(this.days()/7)}var ti=Math.round,ri={ss:44,s:45,m:45,h:22,d:26,w:null,M:11};function ni(e,t,r,n,s){return s.relativeTime(t||1,!!r,e,n)}function si(e,t,r,n){var s=bn(e).abs(),o=ti(s.as("s")),i=ti(s.as("m")),a=ti(s.as("h")),l=ti(s.as("d")),h=ti(s.as("M")),u=ti(s.as("w")),c=ti(s.as("y")),d=o<=r.ss&&["s",o]||o<r.s&&["ss",o]||i<=1&&["m"]||i<r.m&&["mm",i]||a<=1&&["h"]||a<r.h&&["hh",a]||l<=1&&["d"]||l<r.d&&["dd",l];return null!=r.w&&(d=d||u<=1&&["w"]||u<r.w&&["ww",u]),(d=d||h<=1&&["M"]||h<r.M&&["MM",h]||c<=1&&["y"]||["yy",c])[2]=t,d[3]=+e>0,d[4]=n,ni.apply(null,d)}function oi(e){return void 0===e?ti:"function"==typeof e&&(ti=e,!0)}function ii(e,t){return void 0!==ri[e]&&(void 0===t?ri[e]:(ri[e]=t,"s"===e&&(ri.ss=t-1),!0))}function ai(e,t){if(!this.isValid())return this.localeData().invalidDate();var r,n,s=!1,o=ri;return"object"==typeof e&&(t=e,e=!1),"boolean"==typeof e&&(s=e),"object"==typeof t&&(o=Object.assign({},ri,t),null!=t.s&&null==t.ss&&(o.ss=t.s-1)),n=si(this,!s,o,r=this.localeData()),s&&(n=r.pastFuture(+this,n)),r.postformat(n)}var li=Math.abs;function hi(e){return(e>0)-(e<0)||+e}function ui(){if(!this.isValid())return this.localeData().invalidDate();var e,t,r,n,s,o,i,a,l=li(this._milliseconds)/1e3,h=li(this._days),u=li(this._months),c=this.asSeconds();return c?(e=ue(l/60),t=ue(e/60),l%=60,e%=60,r=ue(u/12),u%=12,n=l?l.toFixed(3).replace(/\.?0+$/,""):"",s=c<0?"-":"",o=hi(this._months)!==hi(c)?"-":"",i=hi(this._days)!==hi(c)?"-":"",a=hi(this._milliseconds)!==hi(c)?"-":"",s+"P"+(r?o+r+"Y":"")+(u?o+u+"M":"")+(h?i+h+"D":"")+(t||e||l?"T":"")+(t?a+t+"H":"")+(e?a+e+"M":"")+(l?a+n+"S":"")):"P0D"}var ci=an.prototype;return ci.isValid=sn,ci.abs=To,ci.add=_o,ci.subtract=Mo,ci.as=xo,ci.asMilliseconds=Do,ci.asSeconds=ko,ci.asMinutes=Ho,ci.asHours=Fo,ci.asDays=Uo,ci.asWeeks=Vo,ci.asMonths=Bo,ci.asQuarters=Wo,ci.asYears=Yo,ci.valueOf=Po,ci._bubble=bo,ci.clone=jo,ci.get=Go,ci.milliseconds=$o,ci.seconds=Ko,ci.minutes=Xo,ci.hours=qo,ci.days=Qo,ci.weeks=ei,ci.months=Zo,ci.years=Jo,ci.humanize=ai,ci.toISOString=ui,ci.toString=ui,ci.toJSON=ui,ci.locale=as,ci.localeData=hs,ci.toIsoString=_("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",ui),ci.lang=ls,B("X",0,0,"unix"),B("x",0,0,"valueOf"),De("x",Ie),De("X",Pe),Ve("X",(function(e,t,r){r._d=new Date(1e3*parseFloat(e))})),Ve("x",(function(e,t,r){r._d=new Date(ce(e))})),
//! moment.js
s.version="2.29.4",o(Xr),s.fn=ho,s.min=Jr,s.max=en,s.now=tn,s.utc=f,s.unix=uo,s.months=yo,s.isDate=d,s.locale=fr,s.invalid=w,s.duration=bn,s.isMoment=T,s.weekdays=Co,s.parseZone=co,s.localeData=yr,s.isDuration=ln,s.monthsShort=wo,s.weekdaysMin=vo,s.defineLocale=mr,s.updateLocale=Er,s.locales=wr,s.weekdaysShort=Ro,s.normalizeUnits=se,s.relativeTimeRounding=oi,s.relativeTimeThreshold=ii,s.calendarFormat=Wn,s.prototype=ho,s.HTML5_FMT={DATETIME_LOCAL:"YYYY-MM-DDTHH:mm",DATETIME_LOCAL_SECONDS:"YYYY-MM-DDTHH:mm:ss",DATETIME_LOCAL_MS:"YYYY-MM-DDTHH:mm:ss.SSS",DATE:"YYYY-MM-DD",TIME:"HH:mm",TIME_SECONDS:"HH:mm:ss",TIME_MS:"HH:mm:ss.SSS",WEEK:"GGGG-[W]WW",MONTH:"YYYY-MM"},s}(),window.moment=r(56476)},63192:(e,t,r)=>{e.exports=function e(t,r,n){function s(i,a){if(!r[i]){if(!t[i]){if(o)return o(i,!0);var l=new Error("Cannot find module '"+i+"'");throw l.code="MODULE_NOT_FOUND",l}var h=r[i]={exports:{}};t[i][0].call(h.exports,(function(e){return s(t[i][1][e]||e)}),h,h.exports,e,t,r,n)}return r[i].exports}for(var o=void 0,i=0;i<n.length;i++)s(n[i]);return s}({1:[function(e,t,r){!function(e){"use strict";var r,n=/^-?(?:\d+(?:\.\d*)?|\.\d+)(?:e[+-]?\d+)?$/i,s=Math.ceil,o=Math.floor,i="[BigNumber Error] ",a=i+"Number primitive has more than 15 significant digits: ",l=1e14,h=14,u=9007199254740991,c=[1,10,100,1e3,1e4,1e5,1e6,1e7,1e8,1e9,1e10,1e11,1e12,1e13],d=1e7,p=1e9;function g(e){var t=0|e;return 0<e||e===t?t:t-1}function f(e){for(var t,r,n=1,s=e.length,o=e[0]+"";n<s;){for(t=e[n++]+"",r=h-t.length;r--;t="0"+t);o+=t}for(s=o.length;48===o.charCodeAt(--s););return o.slice(0,s+1||1)}function m(e,t){var r,n,s=e.c,o=t.c,i=e.s,a=t.s,l=e.e,h=t.e;if(!i||!a)return null;if(r=s&&!s[0],n=o&&!o[0],r||n)return r?n?0:-a:i;if(i!=a)return i;if(r=i<0,n=l==h,!s||!o)return n?0:!s^r?1:-1;if(!n)return h<l^r?1:-1;for(a=(l=s.length)<(h=o.length)?l:h,i=0;i<a;i++)if(s[i]!=o[i])return s[i]>o[i]^r?1:-1;return l==h?0:h<l^r?1:-1}function E(e,t,r,n){if(e<t||r<e||e!==(e<0?s(e):o(e)))throw Error(i+(n||"Argument")+("number"==typeof e?e<t||r<e?" out of range: ":" not an integer: ":" not a primitive number: ")+String(e))}function y(e){var t=e.c.length-1;return g(e.e/h)==t&&e.c[t]%2!=0}function w(e,t){return(1<e.length?e.charAt(0)+"."+e.slice(1):e)+(t<0?"e":"e+")+t}function C(e,t,r){var n,s;if(t<0){for(s=r+".";++t;s+=r);e=s+e}else if(++t>(n=e.length)){for(s=r,t-=n;--t;s+=r);e+=s}else t<n&&(e=e.slice(0,t)+"."+e.slice(t));return e}(r=function e(t){var r,R,v,S,T,N,_,M,A,b,I=Y.prototype={constructor:Y,toString:null,valueOf:null},O=new Y(1),x=20,P=4,L=-7,D=21,k=-1e7,H=1e7,F=!1,U=1,V=0,B={prefix:"",groupSize:3,secondaryGroupSize:0,groupSeparator:",",decimalSeparator:".",fractionGroupSize:0,fractionGroupSeparator:" ",suffix:""},W="0123456789abcdefghijklmnopqrstuvwxyz";function Y(e,t){var r,s,i,l,c,d,p,g,f=this;if(!(f instanceof Y))return new Y(e,t);if(null==t){if(e instanceof Y)return f.s=e.s,f.e=e.e,void(f.c=(e=e.c)?e.slice():e);if((d="number"==typeof e)&&0*e==0){if(f.s=1/e<0?(e=-e,-1):1,e===~~e){for(l=0,c=e;10<=c;c/=10,l++);return f.e=l,void(f.c=[e])}g=String(e)}else{if(g=String(e),!n.test(g))return v(f,g,d);f.s=45==g.charCodeAt(0)?(g=g.slice(1),-1):1}-1<(l=g.indexOf("."))&&(g=g.replace(".","")),0<(c=g.search(/e/i))?(l<0&&(l=c),l+=+g.slice(c+1),g=g.substring(0,c)):l<0&&(l=g.length)}else{if(E(t,2,W.length,"Base"),g=String(e),10==t)return $(f=new Y(e instanceof Y?e:g),x+f.e+1,P);if(d="number"==typeof e){if(0*e!=0)return v(f,g,d,t);if(f.s=1/e<0?(g=g.slice(1),-1):1,Y.DEBUG&&15<g.replace(/^0\.0*|\./,"").length)throw Error(a+e);d=!1}else f.s=45===g.charCodeAt(0)?(g=g.slice(1),-1):1;for(r=W.slice(0,t),l=c=0,p=g.length;c<p;c++)if(r.indexOf(s=g.charAt(c))<0){if("."==s){if(l<c){l=p;continue}}else if(!i&&(g==g.toUpperCase()&&(g=g.toLowerCase())||g==g.toLowerCase()&&(g=g.toUpperCase()))){i=!0,c=-1,l=0;continue}return v(f,String(e),d,t)}-1<(l=(g=R(g,t,10,f.s)).indexOf("."))?g=g.replace(".",""):l=g.length}for(c=0;48===g.charCodeAt(c);c++);for(p=g.length;48===g.charCodeAt(--p););if(g=g.slice(c,++p)){if(p-=c,d&&Y.DEBUG&&15<p&&(u<e||e!==o(e)))throw Error(a+f.s*e);if(H<(l=l-c-1))f.c=f.e=null;else if(l<k)f.c=[f.e=0];else{if(f.e=l,f.c=[],c=(l+1)%h,l<0&&(c+=h),c<p){for(c&&f.c.push(+g.slice(0,c)),p-=h;c<p;)f.c.push(+g.slice(c,c+=h));g=g.slice(c),c=h-g.length}else c-=p;for(;c--;g+="0");f.c.push(+g)}}else f.c=[f.e=0]}function j(e,t,r,n){var s,o,i,a,l;if(null==r?r=P:E(r,0,8),!e.c)return e.toString();if(s=e.c[0],i=e.e,null==t)l=f(e.c),l=1==n||2==n&&(i<=L||D<=i)?w(l,i):C(l,i,"0");else if(o=(e=$(new Y(e),t,r)).e,a=(l=f(e.c)).length,1==n||2==n&&(t<=o||o<=L)){for(;a<t;l+="0",a++);l=w(l,o)}else if(t-=i,l=C(l,o,"0"),a<o+1){if(0<--t)for(l+=".";t--;l+="0");}else if(0<(t+=o-a))for(o+1==a&&(l+=".");t--;l+="0");return e.s<0&&s?"-"+l:l}function G(e,t){for(var r,n=1,s=new Y(e[0]);n<e.length;n++){if(!(r=new Y(e[n])).s){s=r;break}t.call(s,r)&&(s=r)}return s}function z(e,t,r){for(var n=1,s=t.length;!t[--s];t.pop());for(s=t[0];10<=s;s/=10,n++);return(r=n+r*h-1)>H?e.c=e.e=null:e.c=r<k?[e.e=0]:(e.e=r,t),e}function $(e,t,r,n){var i,a,u,d,p,g,f,m=e.c,E=c;if(m){e:{for(i=1,d=m[0];10<=d;d/=10,i++);if((a=t-i)<0)a+=h,u=t,f=(p=m[g=0])/E[i-u-1]%10|0;else if((g=s((a+1)/h))>=m.length){if(!n)break e;for(;m.length<=g;m.push(0));p=f=0,u=(a%=h)-h+(i=1)}else{for(p=d=m[g],i=1;10<=d;d/=10,i++);f=(u=(a%=h)-h+i)<0?0:p/E[i-u-1]%10|0}if(n=n||t<0||null!=m[g+1]||(u<0?p:p%E[i-u-1]),n=r<4?(f||n)&&(0==r||r==(e.s<0?3:2)):5<f||5==f&&(4==r||n||6==r&&(0<a?0<u?p/E[i-u]:0:m[g-1])%10&1||r==(e.s<0?8:7)),t<1||!m[0])return m.length=0,n?(t-=e.e+1,m[0]=E[(h-t%h)%h],e.e=-t||0):m[0]=e.e=0,e;if(0==a?(m.length=g,d=1,g--):(m.length=g+1,d=E[h-a],m[g]=0<u?o(p/E[i-u]%E[u])*d:0),n)for(;;){if(0==g){for(a=1,u=m[0];10<=u;u/=10,a++);for(u=m[0]+=d,d=1;10<=u;u/=10,d++);a!=d&&(e.e++,m[0]==l&&(m[0]=1));break}if(m[g]+=d,m[g]!=l)break;m[g--]=0,d=1}for(a=m.length;0===m[--a];m.pop());}e.e>H?e.c=e.e=null:e.e<k&&(e.c=[e.e=0])}return e}function K(e){var t,r=e.e;return null===r?e.toString():(t=f(e.c),t=r<=L||D<=r?w(t,r):C(t,r,"0"),e.s<0?"-"+t:t)}return Y.clone=e,Y.ROUND_UP=0,Y.ROUND_DOWN=1,Y.ROUND_CEIL=2,Y.ROUND_FLOOR=3,Y.ROUND_HALF_UP=4,Y.ROUND_HALF_DOWN=5,Y.ROUND_HALF_EVEN=6,Y.ROUND_HALF_CEIL=7,Y.ROUND_HALF_FLOOR=8,Y.EUCLID=9,Y.config=Y.set=function(e){var t,r;if(null!=e){if("object"!=typeof e)throw Error(i+"Object expected: "+e);if(e.hasOwnProperty(t="DECIMAL_PLACES")&&(E(r=e[t],0,p,t),x=r),e.hasOwnProperty(t="ROUNDING_MODE")&&(E(r=e[t],0,8,t),P=r),e.hasOwnProperty(t="EXPONENTIAL_AT")&&((r=e[t])&&r.pop?(E(r[0],-p,0,t),E(r[1],0,p,t),L=r[0],D=r[1]):(E(r,-p,p,t),L=-(D=r<0?-r:r))),e.hasOwnProperty(t="RANGE"))if((r=e[t])&&r.pop)E(r[0],-p,-1,t),E(r[1],1,p,t),k=r[0],H=r[1];else{if(E(r,-p,p,t),!r)throw Error(i+t+" cannot be zero: "+r);k=-(H=r<0?-r:r)}if(e.hasOwnProperty(t="CRYPTO")){if((r=e[t])!==!!r)throw Error(i+t+" not true or false: "+r);if(r){if("undefined"==typeof crypto||!crypto||!crypto.getRandomValues&&!crypto.randomBytes)throw F=!r,Error(i+"crypto unavailable");F=r}else F=r}if(e.hasOwnProperty(t="MODULO_MODE")&&(E(r=e[t],0,9,t),U=r),e.hasOwnProperty(t="POW_PRECISION")&&(E(r=e[t],0,p,t),V=r),e.hasOwnProperty(t="FORMAT")){if("object"!=typeof(r=e[t]))throw Error(i+t+" not an object: "+r);B=r}if(e.hasOwnProperty(t="ALPHABET")){if("string"!=typeof(r=e[t])||/^.$|[+-.\s]|(.).*\1/.test(r))throw Error(i+t+" invalid: "+r);W=r}}return{DECIMAL_PLACES:x,ROUNDING_MODE:P,EXPONENTIAL_AT:[L,D],RANGE:[k,H],CRYPTO:F,MODULO_MODE:U,POW_PRECISION:V,FORMAT:B,ALPHABET:W}},Y.isBigNumber=function(e){return e instanceof Y||e&&!0===e._isBigNumber||!1},Y.maximum=Y.max=function(){return G(arguments,I.lt)},Y.minimum=Y.min=function(){return G(arguments,I.gt)},Y.random=(S=9007199254740992,T=Math.random()*S&2097151?function(){return o(Math.random()*S)}:function(){return 8388608*(1073741824*Math.random()|0)+(8388608*Math.random()|0)},function(e){var t,r,n,a,l,u=0,d=[],g=new Y(O);if(null==e?e=x:E(e,0,p),a=s(e/h),F)if(crypto.getRandomValues){for(t=crypto.getRandomValues(new Uint32Array(a*=2));u<a;)9e15<=(l=131072*t[u]+(t[u+1]>>>11))?(r=crypto.getRandomValues(new Uint32Array(2)),t[u]=r[0],t[u+1]=r[1]):(d.push(l%1e14),u+=2);u=a/2}else{if(!crypto.randomBytes)throw F=!1,Error(i+"crypto unavailable");for(t=crypto.randomBytes(a*=7);u<a;)9e15<=(l=281474976710656*(31&t[u])+1099511627776*t[u+1]+4294967296*t[u+2]+16777216*t[u+3]+(t[u+4]<<16)+(t[u+5]<<8)+t[u+6])?crypto.randomBytes(7).copy(t,u):(d.push(l%1e14),u+=7);u=a/7}if(!F)for(;u<a;)(l=T())<9e15&&(d[u++]=l%1e14);for(a=d[--u],e%=h,a&&e&&(l=c[h-e],d[u]=o(a/l)*l);0===d[u];d.pop(),u--);if(u<0)d=[n=0];else{for(n=-1;0===d[0];d.splice(0,1),n-=h);for(u=1,l=d[0];10<=l;l/=10,u++);u<h&&(n-=h-u)}return g.e=n,g.c=d,g}),Y.sum=function(){for(var e=1,t=arguments,r=new Y(t[0]);e<t.length;)r=r.plus(t[e++]);return r},R=function(){var e="0123456789";function t(e,t,r,n){for(var s,o,i=[0],a=0,l=e.length;a<l;){for(o=i.length;o--;i[o]*=t);for(i[0]+=n.indexOf(e.charAt(a++)),s=0;s<i.length;s++)i[s]>r-1&&(null==i[s+1]&&(i[s+1]=0),i[s+1]+=i[s]/r|0,i[s]%=r)}return i.reverse()}return function(n,s,o,i,a){var l,h,u,c,d,p,g,m,E=n.indexOf("."),y=x,w=P;for(0<=E&&(c=V,V=0,n=n.replace(".",""),p=(m=new Y(s)).pow(n.length-E),V=c,m.c=t(C(f(p.c),p.e,"0"),10,o,e),m.e=m.c.length),u=c=(g=t(n,s,o,a?(l=W,e):(l=e,W))).length;0==g[--c];g.pop());if(!g[0])return l.charAt(0);if(E<0?--u:(p.c=g,p.e=u,p.s=i,g=(p=r(p,m,y,w,o)).c,d=p.r,u=p.e),E=g[h=u+y+1],c=o/2,d=d||h<0||null!=g[h+1],d=w<4?(null!=E||d)&&(0==w||w==(p.s<0?3:2)):c<E||E==c&&(4==w||d||6==w&&1&g[h-1]||w==(p.s<0?8:7)),h<1||!g[0])n=d?C(l.charAt(1),-y,l.charAt(0)):l.charAt(0);else{if(g.length=h,d)for(--o;++g[--h]>o;)g[h]=0,h||(++u,g=[1].concat(g));for(c=g.length;!g[--c];);for(E=0,n="";E<=c;n+=l.charAt(g[E++]));n=C(n,u,l.charAt(0))}return n}}(),r=function(){function e(e,t,r){var n,s,o,i,a=0,l=e.length,h=t%d,u=t/d|0;for(e=e.slice();l--;)a=((s=h*(o=e[l]%d)+(n=u*o+(i=e[l]/d|0)*h)%d*d+a)/r|0)+(n/d|0)+u*i,e[l]=s%r;return a&&(e=[a].concat(e)),e}function t(e,t,r,n){var s,o;if(r!=n)o=n<r?1:-1;else for(s=o=0;s<r;s++)if(e[s]!=t[s]){o=e[s]>t[s]?1:-1;break}return o}function r(e,t,r,n){for(var s=0;r--;)e[r]-=s,s=e[r]<t[r]?1:0,e[r]=s*n+e[r]-t[r];for(;!e[0]&&1<e.length;e.splice(0,1));}return function(n,s,i,a,u){var c,d,p,f,m,E,y,w,C,R,v,S,T,N,_,M,A,b=n.s==s.s?1:-1,I=n.c,O=s.c;if(!(I&&I[0]&&O&&O[0]))return new Y(n.s&&s.s&&(I?!O||I[0]!=O[0]:O)?I&&0==I[0]||!O?0*b:b/0:NaN);for(C=(w=new Y(b)).c=[],b=i+(d=n.e-s.e)+1,u||(u=l,d=g(n.e/h)-g(s.e/h),b=b/h|0),p=0;O[p]==(I[p]||0);p++);if(O[p]>(I[p]||0)&&d--,b<0)C.push(1),f=!0;else{for(N=I.length,M=O.length,b+=2,1<(m=o(u/(O[p=0]+1)))&&(O=e(O,m,u),I=e(I,m,u),M=O.length,N=I.length),T=M,v=(R=I.slice(0,M)).length;v<M;R[v++]=0);A=O.slice(),A=[0].concat(A),_=O[0],O[1]>=u/2&&_++;do{if(m=0,(c=t(O,R,M,v))<0){if(S=R[0],M!=v&&(S=S*u+(R[1]||0)),1<(m=o(S/_)))for(u<=m&&(m=u-1),y=(E=e(O,m,u)).length,v=R.length;1==t(E,R,y,v);)m--,r(E,M<y?A:O,y,u),y=E.length,c=1;else 0==m&&(c=m=1),y=(E=O.slice()).length;if(y<v&&(E=[0].concat(E)),r(R,E,v,u),v=R.length,-1==c)for(;t(O,R,M,v)<1;)m++,r(R,M<v?A:O,v,u),v=R.length}else 0===c&&(m++,R=[0]);C[p++]=m,R[0]?R[v++]=I[T]||0:(R=[I[T]],v=1)}while((T++<N||null!=R[0])&&b--);f=null!=R[0],C[0]||C.splice(0,1)}if(u==l){for(p=1,b=C[0];10<=b;b/=10,p++);$(w,i+(w.e=p+d*h-1)+1,a,f)}else w.e=d,w.r=+f;return w}}(),N=/^(-?)0([xbo])(?=\w[\w.]*$)/i,_=/^([^.]+)\.$/,M=/^\.([^.]+)$/,A=/^-?(Infinity|NaN)$/,b=/^\s*\+(?=[\w.])|^\s+|\s+$/g,v=function(e,t,r,n){var s,o=r?t:t.replace(b,"");if(A.test(o))e.s=isNaN(o)?null:o<0?-1:1,e.c=e.e=null;else{if(!r&&(o=o.replace(N,(function(e,t,r){return s="x"==(r=r.toLowerCase())?16:"b"==r?2:8,n&&n!=s?e:t})),n&&(s=n,o=o.replace(_,"$1").replace(M,"0.$1")),t!=o))return new Y(o,s);if(Y.DEBUG)throw Error(i+"Not a"+(n?" base "+n:"")+" number: "+t);e.c=e.e=e.s=null}},I.absoluteValue=I.abs=function(){var e=new Y(this);return e.s<0&&(e.s=1),e},I.comparedTo=function(e,t){return m(this,new Y(e,t))},I.decimalPlaces=I.dp=function(e,t){var r,n,s;if(null!=e)return E(e,0,p),null==t?t=P:E(t,0,8),$(new Y(this),e+this.e+1,t);if(!(r=this.c))return null;if(n=((s=r.length-1)-g(this.e/h))*h,s=r[s])for(;s%10==0;s/=10,n--);return n<0&&(n=0),n},I.dividedBy=I.div=function(e,t){return r(this,new Y(e,t),x,P)},I.dividedToIntegerBy=I.idiv=function(e,t){return r(this,new Y(e,t),0,1)},I.exponentiatedBy=I.pow=function(e,t){var r,n,a,l,u,c,d,p,g=this;if((e=new Y(e)).c&&!e.isInteger())throw Error(i+"Exponent not an integer: "+K(e));if(null!=t&&(t=new Y(t)),u=14<e.e,!g.c||!g.c[0]||1==g.c[0]&&!g.e&&1==g.c.length||!e.c||!e.c[0])return p=new Y(Math.pow(+K(g),u?2-y(e):+K(e))),t?p.mod(t):p;if(c=e.s<0,t){if(t.c?!t.c[0]:!t.s)return new Y(NaN);(n=!c&&g.isInteger()&&t.isInteger())&&(g=g.mod(t))}else{if(9<e.e&&(0<g.e||g.e<-1||(0==g.e?1<g.c[0]||u&&24e7<=g.c[1]:g.c[0]<8e13||u&&g.c[0]<=9999975e7)))return l=g.s<0&&y(e)?-0:0,-1<g.e&&(l=1/l),new Y(c?1/l:l);V&&(l=s(V/h+2))}for(d=u?(r=new Y(.5),c&&(e.s=1),y(e)):(a=Math.abs(+K(e)))%2,p=new Y(O);;){if(d){if(!(p=p.times(g)).c)break;l?p.c.length>l&&(p.c.length=l):n&&(p=p.mod(t))}if(a){if(0===(a=o(a/2)))break;d=a%2}else if($(e=e.times(r),e.e+1,1),14<e.e)d=y(e);else{if(0==(a=+K(e)))break;d=a%2}g=g.times(g),l?g.c&&g.c.length>l&&(g.c.length=l):n&&(g=g.mod(t))}return n?p:(c&&(p=O.div(p)),t?p.mod(t):l?$(p,V,P,void 0):p)},I.integerValue=function(e){var t=new Y(this);return null==e?e=P:E(e,0,8),$(t,t.e+1,e)},I.isEqualTo=I.eq=function(e,t){return 0===m(this,new Y(e,t))},I.isFinite=function(){return!!this.c},I.isGreaterThan=I.gt=function(e,t){return 0<m(this,new Y(e,t))},I.isGreaterThanOrEqualTo=I.gte=function(e,t){return 1===(t=m(this,new Y(e,t)))||0===t},I.isInteger=function(){return!!this.c&&g(this.e/h)>this.c.length-2},I.isLessThan=I.lt=function(e,t){return m(this,new Y(e,t))<0},I.isLessThanOrEqualTo=I.lte=function(e,t){return-1===(t=m(this,new Y(e,t)))||0===t},I.isNaN=function(){return!this.s},I.isNegative=function(){return this.s<0},I.isPositive=function(){return 0<this.s},I.isZero=function(){return!!this.c&&0==this.c[0]},I.minus=function(e,t){var r,n,s,o,i=this,a=i.s;if(t=(e=new Y(e,t)).s,!a||!t)return new Y(NaN);if(a!=t)return e.s=-t,i.plus(e);var u=i.e/h,c=e.e/h,d=i.c,p=e.c;if(!u||!c){if(!d||!p)return d?(e.s=-t,e):new Y(p?i:NaN);if(!d[0]||!p[0])return p[0]?(e.s=-t,e):new Y(d[0]?i:3==P?-0:0)}if(u=g(u),c=g(c),d=d.slice(),a=u-c){for((s=(o=a<0)?(a=-a,d):(c=u,p)).reverse(),t=a;t--;s.push(0));s.reverse()}else for(n=(o=(a=d.length)<(t=p.length))?a:t,a=t=0;t<n;t++)if(d[t]!=p[t]){o=d[t]<p[t];break}if(o&&(s=d,d=p,p=s,e.s=-e.s),0<(t=(n=p.length)-(r=d.length)))for(;t--;d[r++]=0);for(t=l-1;a<n;){if(d[--n]<p[n]){for(r=n;r&&!d[--r];d[r]=t);--d[r],d[n]+=l}d[n]-=p[n]}for(;0==d[0];d.splice(0,1),--c);return d[0]?z(e,d,c):(e.s=3==P?-1:1,e.c=[e.e=0],e)},I.modulo=I.mod=function(e,t){var n,s,o=this;return e=new Y(e,t),!o.c||!e.s||e.c&&!e.c[0]?new Y(NaN):!e.c||o.c&&!o.c[0]?new Y(o):(9==U?(s=e.s,e.s=1,n=r(o,e,0,3),e.s=s,n.s*=s):n=r(o,e,0,U),(e=o.minus(n.times(e))).c[0]||1!=U||(e.s=o.s),e)},I.multipliedBy=I.times=function(e,t){var r,n,s,o,i,a,u,c,p,f,m,E,y,w,C,R=this,v=R.c,S=(e=new Y(e,t)).c;if(!(v&&S&&v[0]&&S[0]))return!R.s||!e.s||v&&!v[0]&&!S||S&&!S[0]&&!v?e.c=e.e=e.s=null:(e.s*=R.s,v&&S?(e.c=[0],e.e=0):e.c=e.e=null),e;for(n=g(R.e/h)+g(e.e/h),e.s*=R.s,(u=v.length)<(f=S.length)&&(y=v,v=S,S=y,s=u,u=f,f=s),s=u+f,y=[];s--;y.push(0));for(w=l,C=d,s=f;0<=--s;){for(r=0,m=S[s]%C,E=S[s]/C|0,o=s+(i=u);s<o;)r=((c=m*(c=v[--i]%C)+(a=E*c+(p=v[i]/C|0)*m)%C*C+y[o]+r)/w|0)+(a/C|0)+E*p,y[o--]=c%w;y[o]=r}return r?++n:y.splice(0,1),z(e,y,n)},I.negated=function(){var e=new Y(this);return e.s=-e.s||null,e},I.plus=function(e,t){var r,n=this,s=n.s;if(t=(e=new Y(e,t)).s,!s||!t)return new Y(NaN);if(s!=t)return e.s=-t,n.minus(e);var o=n.e/h,i=e.e/h,a=n.c,u=e.c;if(!o||!i){if(!a||!u)return new Y(s/0);if(!a[0]||!u[0])return u[0]?e:new Y(a[0]?n:0*s)}if(o=g(o),i=g(i),a=a.slice(),s=o-i){for((r=0<s?(i=o,u):(s=-s,a)).reverse();s--;r.push(0));r.reverse()}for((s=a.length)-(t=u.length)<0&&(r=u,u=a,a=r,t=s),s=0;t;)s=(a[--t]=a[t]+u[t]+s)/l|0,a[t]=l===a[t]?0:a[t]%l;return s&&(a=[s].concat(a),++i),z(e,a,i)},I.precision=I.sd=function(e,t){var r,n,s;if(null!=e&&e!==!!e)return E(e,1,p),null==t?t=P:E(t,0,8),$(new Y(this),e,t);if(!(r=this.c))return null;if(n=(s=r.length-1)*h+1,s=r[s]){for(;s%10==0;s/=10,n--);for(s=r[0];10<=s;s/=10,n++);}return e&&this.e+1>n&&(n=this.e+1),n},I.shiftedBy=function(e){return E(e,-u,u),this.times("1e"+e)},I.squareRoot=I.sqrt=function(){var e,t,n,s,o,i=this,a=i.c,l=i.s,h=i.e,u=x+4,c=new Y("0.5");if(1!==l||!a||!a[0])return new Y(!l||l<0&&(!a||a[0])?NaN:a?i:1/0);if((n=0==(l=Math.sqrt(+K(i)))||l==1/0?(((t=f(a)).length+h)%2==0&&(t+="0"),l=Math.sqrt(+t),h=g((h+1)/2)-(h<0||h%2),new Y(t=l==1/0?"1e"+h:(t=l.toExponential()).slice(0,t.indexOf("e")+1)+h)):new Y(l+"")).c[0])for((l=(h=n.e)+u)<3&&(l=0);;)if(o=n,n=c.times(o.plus(r(i,o,u,1))),f(o.c).slice(0,l)===(t=f(n.c)).slice(0,l)){if(n.e<h&&--l,"9999"!=(t=t.slice(l-3,l+1))&&(s||"4999"!=t)){+t&&(+t.slice(1)||"5"!=t.charAt(0))||($(n,n.e+x+2,1),e=!n.times(n).eq(i));break}if(!s&&($(o,o.e+x+2,0),o.times(o).eq(i))){n=o;break}u+=4,l+=4,s=1}return $(n,n.e+x+1,P,e)},I.toExponential=function(e,t){return null!=e&&(E(e,0,p),e++),j(this,e,t,1)},I.toFixed=function(e,t){return null!=e&&(E(e,0,p),e=e+this.e+1),j(this,e,t)},I.toFormat=function(e,t,r){var n;if(null==r)null!=e&&t&&"object"==typeof t?(r=t,t=null):e&&"object"==typeof e?(r=e,e=t=null):r=B;else if("object"!=typeof r)throw Error(i+"Argument not an object: "+r);if(n=this.toFixed(e,t),this.c){var s,o=n.split("."),a=+r.groupSize,l=+r.secondaryGroupSize,h=r.groupSeparator||"",u=o[0],c=o[1],d=this.s<0,p=d?u.slice(1):u,g=p.length;if(l&&(s=a,a=l,g-=l=s),0<a&&0<g){for(s=g%a||a,u=p.substr(0,s);s<g;s+=a)u+=h+p.substr(s,a);0<l&&(u+=h+p.slice(s)),d&&(u="-"+u)}n=c?u+(r.decimalSeparator||"")+((l=+r.fractionGroupSize)?c.replace(new RegExp("\\d{"+l+"}\\B","g"),"$&"+(r.fractionGroupSeparator||"")):c):u}return(r.prefix||"")+n+(r.suffix||"")},I.toFraction=function(e){var t,n,s,o,a,l,u,d,p,g,m,E,y=this,w=y.c;if(null!=e&&(!(u=new Y(e)).isInteger()&&(u.c||1!==u.s)||u.lt(O)))throw Error(i+"Argument "+(u.isInteger()?"out of range: ":"not an integer: ")+K(u));if(!w)return new Y(y);for(t=new Y(O),p=n=new Y(O),s=d=new Y(O),E=f(w),a=t.e=E.length-y.e-1,t.c[0]=c[(l=a%h)<0?h+l:l],e=!e||0<u.comparedTo(t)?0<a?t:p:u,l=H,H=1/0,u=new Y(E),d.c[0]=0;g=r(u,t,0,1),1!=(o=n.plus(g.times(s))).comparedTo(e);)n=s,s=o,p=d.plus(g.times(o=p)),d=o,t=u.minus(g.times(o=t)),u=o;return o=r(e.minus(n),s,0,1),d=d.plus(o.times(p)),n=n.plus(o.times(s)),d.s=p.s=y.s,m=r(p,s,a*=2,P).minus(y).abs().comparedTo(r(d,n,a,P).minus(y).abs())<1?[p,s]:[d,n],H=l,m},I.toNumber=function(){return+K(this)},I.toPrecision=function(e,t){return null!=e&&E(e,1,p),j(this,e,t,2)},I.toString=function(e){var t,r=this,n=r.s,s=r.e;return null===s?n?(t="Infinity",n<0&&(t="-"+t)):t="NaN":(t=null==e?s<=L||D<=s?w(f(r.c),s):C(f(r.c),s,"0"):10===e?C(f((r=$(new Y(r),x+s+1,P)).c),r.e,"0"):(E(e,2,W.length,"Base"),R(C(f(r.c),s,"0"),10,e,n,!0)),n<0&&r.c[0]&&(t="-"+t)),t},I.valueOf=I.toJSON=function(){return K(this)},I._isBigNumber=!0,"function"==typeof Symbol&&"symbol"==typeof Symbol.iterator&&(I[Symbol.toStringTag]="BigNumber",I[Symbol.for("nodejs.util.inspect.custom")]=I.valueOf),null!=t&&Y.set(t),Y}()).default=r.BigNumber=r,void 0!==t&&t.exports?t.exports=r:(e||(e="undefined"!=typeof self&&self?self:window),e.BigNumber=r)}(this)},{}],2:[function(e,t,r){"use strict";t.exports={languageTag:"en-US",delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},spaceSeparated:!1,ordinal:function(e){var t=e%10;return 1==~~(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th"},currency:{symbol:"$",position:"prefix",code:"USD"},currencyFormat:{thousandSeparated:!0,totalLength:4,spaceSeparated:!0},formats:{fourDigits:{totalLength:4,spaceSeparated:!0},fullWithTwoDecimals:{output:"currency",thousandSeparated:!0,mantissa:2},fullWithTwoDecimalsNoCurrency:{thousandSeparated:!0,mantissa:2},fullWithNoDecimals:{output:"currency",thousandSeparated:!0,mantissa:0}}}},{}],3:[function(e,t,r){"use strict";function n(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){var r=[],n=!0,s=!1,o=void 0;try{for(var i,a=e[Symbol.iterator]();!(n=(i=a.next()).done)&&(r.push(i.value),!t||r.length!==t);n=!0);}catch(e){s=!0,o=e}finally{try{n||null==a.return||a.return()}finally{if(s)throw o}}return r}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}()}var s=e("./globalState"),o=e("./validating"),i=e("./parsing"),a=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],l={general:{scale:1024,suffixes:a,marker:"bd"},binary:{scale:1024,suffixes:["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],marker:"b"},decimal:{scale:1e3,suffixes:a,marker:"d"}},h={totalLength:0,characteristic:0,forceAverage:!1,average:!1,mantissa:-1,optionalMantissa:!0,thousandSeparated:!1,spaceSeparated:!1,negative:"sign",forceSign:!1};function u(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r=2<arguments.length?arguments[2]:void 0;if("string"==typeof t&&(t=i.parseFormat(t)),!o.validateFormat(t))return"ERROR: invalid format";var n=t.prefix||"",a=t.postfix||"",u=function(e,t,r){switch(t.output){case"currency":return function(e,t,r){var n=r.currentCurrency(),s=Object.assign({},h,t),o=void 0,i="",a=!!s.totalLength||!!s.forceAverage||s.average,l=t.currencyPosition||n.position,u=t.currencySymbol||n.symbol;s.spaceSeparated&&(i=" "),"infix"===l&&(o=i+u+i);var c=g({instance:e,providedFormat:t,state:r,decimalSeparator:o});return"prefix"===l&&(c=e._value<0&&"sign"===s.negative?"-".concat(i).concat(u).concat(c.slice(1)):u+i+c),l&&"postfix"!==l||(c=c+(i=a?"":i)+u),c}(e,t=f(t,s.currentCurrencyDefaultFormat()),s);case"percent":return function(e,t,r,n){var s=t.prefixSymbol,o=g({instance:n(100*e._value),providedFormat:t,state:r}),i=Object.assign({},h,t);return s?"%".concat(i.spaceSeparated?" ":"").concat(o):"".concat(o).concat(i.spaceSeparated?" ":"","%")}(e,t=f(t,s.currentPercentageDefaultFormat()),s,r);case"byte":return t=f(t,s.currentByteDefaultFormat()),C=e,v=s,S=r,T=(R=t).base||"binary",N=l[T],M=(_=c(C._value,N.suffixes,N.scale)).value,A=_.suffix,b=g({instance:S(M),providedFormat:R,state:v,defaults:v.currentByteDefaultFormat()}),I=v.currentAbbreviations(),"".concat(b).concat(I.spaced?" ":"").concat(A);case"time":return t=f(t,s.currentTimeDefaultFormat()),m=e,E=Math.floor(m._value/60/60),y=Math.floor((m._value-60*E*60)/60),w=Math.round(m._value-60*E*60-60*y),"".concat(E,":").concat(y<10?"0":"").concat(y,":").concat(w<10?"0":"").concat(w);case"ordinal":return n=e,o=t=f(t,s.currentOrdinalDefaultFormat()),a=(i=s).currentOrdinal(),u=Object.assign({},h,o),d=g({instance:n,providedFormat:o,state:i}),p=a(n._value),"".concat(d).concat(u.spaceSeparated?" ":"").concat(p);default:return g({instance:e,providedFormat:t,numbro:r})}var n,o,i,a,u,d,p,m,E,y,w,C,R,v,S,T,N,_,M,A,b,I}(e,t,r);return(u=n+u)+a}function c(e,t,r){var n=t[0],s=Math.abs(e);if(r<=s){for(var o=1;o<t.length;++o){var i=Math.pow(r,o),a=Math.pow(r,o+1);if(i<=s&&s<a){n=t[o],e/=i;break}}n===t[0]&&(e/=Math.pow(r,t.length-1),n=t[t.length-1])}return{value:e,suffix:n}}function d(e){for(var t="",r=0;r<e;r++)t+="0";return t}function p(e,t){return-1!==e.toString().indexOf("e")?function(e,t){var r=e.toString(),s=n(r.split("e"),2),o=s[0],i=s[1],a=n(o.split("."),2),l=a[0],h=a[1],u=void 0===h?"":h;if(0<+i)r=l+u+d(i-u.length);else{var c=".";c=+l<0?"-0".concat(c):"0".concat(c);var p=(d(-i-1)+Math.abs(l)+u).substr(0,t);p.length<t&&(p+=d(t-p.length)),r=c+p}return 0<+i&&0<t&&(r+=".".concat(d(t))),r}(e,t):(Math.round(+"".concat(e,"e+").concat(t))/Math.pow(10,t)).toFixed(t)}function g(e){var t=e.instance,r=e.providedFormat,o=e.state,i=void 0===o?s:o,a=e.decimalSeparator,l=e.defaults,u=void 0===l?i.currentDefaults():l,c=t._value;if(0===c&&i.hasZeroFormat())return i.getZeroFormat();if(!isFinite(c))return c.toString();var d,g,f,m,E,y,w,C,R=Object.assign({},h,u,r),v=R.totalLength,S=v?0:R.characteristic,T=R.optionalCharacteristic,N=R.forceAverage,_=!!v||!!N||R.average,M=v?-1:_&&void 0===r.mantissa?0:R.mantissa,A=!v&&(void 0===r.optionalMantissa?-1===M:R.optionalMantissa),b=R.trimMantissa,I=R.thousandSeparated,O=R.spaceSeparated,x=R.negative,P=R.forceSign,L=R.exponential,D="";if(_){var k=function(e){var t=e.value,r=e.forceAverage,n=e.abbreviations,s=e.spaceSeparated,o=void 0!==s&&s,i=e.totalLength,a=void 0===i?0:i,l="",h=Math.abs(t),u=-1;if(h>=Math.pow(10,12)&&!r||"trillion"===r?(l=n.trillion,t/=Math.pow(10,12)):h<Math.pow(10,12)&&h>=Math.pow(10,9)&&!r||"billion"===r?(l=n.billion,t/=Math.pow(10,9)):h<Math.pow(10,9)&&h>=Math.pow(10,6)&&!r||"million"===r?(l=n.million,t/=Math.pow(10,6)):(h<Math.pow(10,6)&&h>=Math.pow(10,3)&&!r||"thousand"===r)&&(l=n.thousand,t/=Math.pow(10,3)),l&&(l=(o?" ":"")+l),a){var c=t.toString().split(".")[0];u=Math.max(a-c.length,0)}return{value:t,abbreviation:l,mantissaPrecision:u}}({value:c,forceAverage:N,abbreviations:i.currentAbbreviations(),spaceSeparated:O,totalLength:v});c=k.value,D+=k.abbreviation,v&&(M=k.mantissaPrecision)}if(L){var H=(g=(d={value:c,characteristicPrecision:S}).value,m=void 0===(f=d.characteristicPrecision)?0:f,y=(E=n(g.toExponential().split("e"),2))[0],w=E[1],C=+y,m&&1<m&&(C*=Math.pow(10,m-1),w=0<=(w=+w-(m-1))?"+".concat(w):w),{value:C,abbreviation:"e".concat(w)});c=H.value,D=H.abbreviation+D}var F,U,V,B=function(e,t,r,s,o){if(-1===s)return e;var i=p(t,s),a=n(i.toString().split("."),2),l=a[0],h=a[1],u=void 0===h?"":h;if(u.match(/^0+$/)&&(r||o))return l;var c=u.match(/0+$/);return o&&c?"".concat(l,".").concat(u.toString().slice(0,c.index)):i.toString()}(c.toString(),c,A,M,b);return B=function(e,t,r,n,s){var o=n.currentDelimiters(),i=o.thousands;s=s||o.decimal;var a=o.thousandsSize||3,l=e.toString(),h=l.split(".")[0],u=l.split(".")[1];return r&&(t<0&&(h=h.slice(1)),function(e,t){for(var r=[],n=0,s=e;0<s;s--)n===t&&(r.unshift(s),n=0),n++;return r}(h.length,a).forEach((function(e,t){h=h.slice(0,e+t)+i+h.slice(e+t)})),t<0&&(h="-".concat(h))),u?h+s+u:h}(B=function(e,t,r,s){var o=e,i=n(o.toString().split("."),2),a=i[0],l=i[1];if(a.match(/^-?0$/)&&r)return l?"".concat(a.replace("0",""),".").concat(l):a.replace("0","");if(a.length<s)for(var h=s-a.length,u=0;u<h;u++)o="0".concat(o);return o.toString()}(B,0,T,S),c,I,i,a),(_||L)&&(B+=D),(P||c<0)&&(F=B,V=x,B=0===(U=c)?F:0==+F?F.replace("-",""):0<U?"+".concat(F):"sign"===V?F:"(".concat(F.replace("-",""),")")),B}function f(e,t){if(!e)return t;var r=Object.keys(e);return 1===r.length&&"output"===r[0]?t:e}t.exports=function(e){return{format:function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return u.apply(void 0,r.concat([e]))},getByteUnit:function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return function(e){var t=l.general;return c(e._value,t.suffixes,t.scale).suffix}.apply(void 0,r.concat([e]))},getBinaryByteUnit:function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return function(e){var t=l.binary;return c(e._value,t.suffixes,t.scale).suffix}.apply(void 0,r.concat([e]))},getDecimalByteUnit:function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return function(e){var t=l.decimal;return c(e._value,t.suffixes,t.scale).suffix}.apply(void 0,r.concat([e]))},formatOrDefault:f}}},{"./globalState":4,"./parsing":8,"./validating":10}],4:[function(e,t,r){"use strict";var n=e("./en-US"),s=e("./validating"),o=e("./parsing"),i={},a=void 0,l={},h=null,u={};function c(e){a=e}function d(){return l[a]}i.languages=function(){return Object.assign({},l)},i.currentLanguage=function(){return a},i.currentCurrency=function(){return d().currency},i.currentAbbreviations=function(){return d().abbreviations},i.currentDelimiters=function(){return d().delimiters},i.currentOrdinal=function(){return d().ordinal},i.currentDefaults=function(){return Object.assign({},d().defaults,u)},i.currentOrdinalDefaultFormat=function(){return Object.assign({},i.currentDefaults(),d().ordinalFormat)},i.currentByteDefaultFormat=function(){return Object.assign({},i.currentDefaults(),d().byteFormat)},i.currentPercentageDefaultFormat=function(){return Object.assign({},i.currentDefaults(),d().percentageFormat)},i.currentCurrencyDefaultFormat=function(){return Object.assign({},i.currentDefaults(),d().currencyFormat)},i.currentTimeDefaultFormat=function(){return Object.assign({},i.currentDefaults(),d().timeFormat)},i.setDefaults=function(e){e=o.parseFormat(e),s.validateFormat(e)&&(u=e)},i.getZeroFormat=function(){return h},i.setZeroFormat=function(e){return h="string"==typeof e?e:null},i.hasZeroFormat=function(){return null!==h},i.languageData=function(e){if(e){if(l[e])return l[e];throw new Error('Unknown tag "'.concat(e,'"'))}return d()},i.registerLanguage=function(e){var t=1<arguments.length&&void 0!==arguments[1]&&arguments[1];if(!s.validateLanguage(e))throw new Error("Invalid language data");l[e.languageTag]=e,t&&c(e.languageTag)},i.setLanguage=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:n.languageTag;if(!l[e]){var r=e.split("-")[0],s=Object.keys(l).find((function(e){return e.split("-")[0]===r}));return l[s]?void c(s):void c(t)}c(e)},i.registerLanguage(n),a=n.languageTag,t.exports=i},{"./en-US":2,"./parsing":8,"./validating":10}],5:[function(e,t,r){"use strict";t.exports=function(t){return{loadLanguagesInNode:function(r){return n=t,void r.forEach((function(t){var r=void 0;try{r=e("../languages/".concat(t))}catch(r){console.error('Unable to load "'.concat(t,'". No matching language file found.'))}r&&n.registerLanguage(r)}));var n}}}},{}],6:[function(e,t,r){"use strict";var n=e("bignumber.js");function s(e,t,r){var s=new n(e._value),o=t;return r.isNumbro(t)&&(o=t._value),o=new n(o),e._value=s.minus(o).toNumber(),e}t.exports=function(e){return{add:function(t,r){return o=r,i=e,a=new n((s=t)._value),l=o,i.isNumbro(o)&&(l=o._value),l=new n(l),s._value=a.plus(l).toNumber(),s;var s,o,i,a,l},subtract:function(t,r){return s(t,r,e)},multiply:function(t,r){return o=r,i=e,a=new n((s=t)._value),l=o,i.isNumbro(o)&&(l=o._value),l=new n(l),s._value=a.times(l).toNumber(),s;var s,o,i,a,l},divide:function(t,r){return o=r,i=e,a=new n((s=t)._value),l=o,i.isNumbro(o)&&(l=o._value),l=new n(l),s._value=a.dividedBy(l).toNumber(),s;var s,o,i,a,l},set:function(t,r){return n=t,o=s=r,e.isNumbro(s)&&(o=s._value),n._value=o,n;var n,s,o},difference:function(t,r){return n=r,s(i=(o=e)(t._value),n,o),Math.abs(i._value);var n,o,i}}}},{"bignumber.js":1}],7:[function(e,t,r){"use strict";function n(e,t){for(var r=0;r<t.length;r++){var n=t[r];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var s=e("./globalState"),o=e("./validating"),i=e("./loading")(p),a=e("./unformatting"),l=e("./formatting")(p),h=e("./manipulating")(p),u=e("./parsing"),c=function(){function e(t){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this._value=t}var t,r,o;return t=e,(r=[{key:"clone",value:function(){return p(this._value)}},{key:"format",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{};return l.format(this,e)}},{key:"formatCurrency",value:function(e){return"string"==typeof e&&(e=u.parseFormat(e)),(e=l.formatOrDefault(e,s.currentCurrencyDefaultFormat())).output="currency",l.format(this,e)}},{key:"formatTime",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{};return e.output="time",l.format(this,e)}},{key:"binaryByteUnits",value:function(){return l.getBinaryByteUnit(this)}},{key:"decimalByteUnits",value:function(){return l.getDecimalByteUnit(this)}},{key:"byteUnits",value:function(){return l.getByteUnit(this)}},{key:"difference",value:function(e){return h.difference(this,e)}},{key:"add",value:function(e){return h.add(this,e)}},{key:"subtract",value:function(e){return h.subtract(this,e)}},{key:"multiply",value:function(e){return h.multiply(this,e)}},{key:"divide",value:function(e){return h.divide(this,e)}},{key:"set",value:function(e){return h.set(this,d(e))}},{key:"value",value:function(){return this._value}},{key:"valueOf",value:function(){return this._value}}])&&n(t.prototype,r),o&&n(t,o),e}();function d(e){var t=e;return p.isNumbro(e)?t=e._value:"string"==typeof e?t=p.unformat(e):isNaN(e)&&(t=NaN),t}function p(e){return new c(d(e))}p.version="2.1.2",p.isNumbro=function(e){return e instanceof c},p.language=s.currentLanguage,p.registerLanguage=s.registerLanguage,p.setLanguage=s.setLanguage,p.languages=s.languages,p.languageData=s.languageData,p.zeroFormat=s.setZeroFormat,p.defaultFormat=s.currentDefaults,p.setDefaults=s.setDefaults,p.defaultCurrencyFormat=s.currentCurrencyDefaultFormat,p.validate=o.validate,p.loadLanguagesInNode=i.loadLanguagesInNode,p.unformat=a.unformat,t.exports=p},{"./formatting":3,"./globalState":4,"./loading":5,"./manipulating":6,"./parsing":8,"./unformatting":9,"./validating":10}],8:[function(e,t,r){"use strict";t.exports={parseFormat:function(e){var t,r,n,s,o,i,a,l,h,u,c,d,p,g,f,m,E,y,w,C,R=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};return"string"!=typeof e?e:(r=R,o=R,function(e,t){if(-1===e.indexOf("$")){if(-1===e.indexOf("%"))return-1!==e.indexOf("bd")?(t.output="byte",t.base="general"):-1!==e.indexOf("b")?(t.output="byte",t.base="binary"):-1!==e.indexOf("d")?(t.output="byte",t.base="decimal"):-1===e.indexOf(":")?-1!==e.indexOf("o")&&(t.output="ordinal"):t.output="time";t.output="percent"}else t.output="currency"}(e=(i=(s=e=(n=(t=e).match(/^{([^}]*)}/))?(r.prefix=n[1],t.slice(n[0].length)):t).match(/{([^}]*)}$/))?(o.postfix=i[1],s.slice(0,-i[0].length)):s,R),a=R,(l=e.match(/[1-9]+[0-9]*/))&&(a.totalLength=+l[0]),h=R,(u=e.split(".")[0].match(/0+/))&&(h.characteristic=u[0].length),function(e,t){if(-1!==e.indexOf(".")){var r=e.split(".")[0];t.optionalCharacteristic=-1===r.indexOf("0")}}(e,R),c=R,-1!==e.indexOf("a")&&(c.average=!0),p=R,-1!==(d=e).indexOf("K")?p.forceAverage="thousand":-1!==d.indexOf("M")?p.forceAverage="million":-1!==d.indexOf("B")?p.forceAverage="billion":-1!==d.indexOf("T")&&(p.forceAverage="trillion"),function(e,t){var r=e.split(".")[1];if(r){var n=r.match(/0+/);n&&(t.mantissa=n[0].length)}}(e,R),f=R,(g=e).match(/\[\.]/)?f.optionalMantissa=!0:g.match(/\./)&&(f.optionalMantissa=!1),m=R,-1!==e.indexOf(",")&&(m.thousandSeparated=!0),E=R,-1!==e.indexOf(" ")&&(E.spaceSeparated=!0),w=R,(y=e).match(/^\+?\([^)]*\)$/)&&(w.negative="parenthesis"),y.match(/^\+?-/)&&(w.negative="sign"),C=R,e.match(/^\+/)&&(C.forceSign=!0),R)}}},{}],9:[function(e,t,r){"use strict";var n=[{key:"ZiB",factor:Math.pow(1024,7)},{key:"ZB",factor:Math.pow(1e3,7)},{key:"YiB",factor:Math.pow(1024,8)},{key:"YB",factor:Math.pow(1e3,8)},{key:"TiB",factor:Math.pow(1024,4)},{key:"TB",factor:Math.pow(1e3,4)},{key:"PiB",factor:Math.pow(1024,5)},{key:"PB",factor:Math.pow(1e3,5)},{key:"MiB",factor:Math.pow(1024,2)},{key:"MB",factor:Math.pow(1e3,2)},{key:"KiB",factor:Math.pow(1024,1)},{key:"KB",factor:Math.pow(1e3,1)},{key:"GiB",factor:Math.pow(1024,3)},{key:"GB",factor:Math.pow(1e3,3)},{key:"EiB",factor:Math.pow(1024,6)},{key:"EB",factor:Math.pow(1e3,6)},{key:"B",factor:1}];function s(e){return e.replace(/[-/\\^$*+?.()|[\]{}]/g,"\\$&")}function o(e,t){var r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:"",o=3<arguments.length?arguments[3]:void 0,i=4<arguments.length?arguments[4]:void 0,a=5<arguments.length?arguments[5]:void 0,l=6<arguments.length?arguments[6]:void 0;if(""!==e)return e===i?0:function e(t,r){var o=2<arguments.length&&void 0!==arguments[2]?arguments[2]:"",i=3<arguments.length?arguments[3]:void 0,a=4<arguments.length?arguments[4]:void 0,l=5<arguments.length?arguments[5]:void 0,h=6<arguments.length?arguments[6]:void 0;if(!isNaN(+t))return+t;var u="",c=t.replace(/(^[^(]*)\((.*)\)([^)]*$)/,"$1$2$3");if(c!==t)return-1*e(c,r,o,i,a,l,h);for(var d=0;d<n.length;d++){var p=n[d];if((u=t.replace(p.key,""))!==t)return e(u,r,o,i,a,l,h)*p.factor}if((u=t.replace("%",""))!==t)return e(u,r,o,i,a,l,h)/100;var g=parseFloat(t);if(!isNaN(g)){var f=i(g);if(f&&"."!==f&&(u=t.replace(new RegExp("".concat(s(f),"$")),""))!==t)return e(u,r,o,i,a,l,h);var m={};Object.keys(l).forEach((function(e){m[l[e]]=e}));for(var E=Object.keys(m).sort().reverse(),y=E.length,w=0;w<y;w++){var C=E[w],R=m[C];if((u=t.replace(C,""))!==t){var v=void 0;switch(R){case"thousand":v=Math.pow(10,3);break;case"million":v=Math.pow(10,6);break;case"billion":v=Math.pow(10,9);break;case"trillion":v=Math.pow(10,12)}return e(u,r,o,i,a,l,h)*v}}}}(function(e,t){var r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:"",n=e.replace(r,"");return(n=n.replace(new RegExp("([0-9])".concat(s(t.thousands),"([0-9])"),"g"),"$1$2")).replace(t.decimal,".")}(e,t,r),t,r,o,i,a,l)}t.exports={unformat:function(t,r){var n,s,i,a=e("./globalState"),l=a.currentDelimiters(),h=a.currentCurrency().symbol,u=a.currentOrdinal(),c=a.getZeroFormat(),d=a.currentAbbreviations(),p=void 0;if("string"==typeof t)p=function(e,t){if(!e.indexOf(":")||":"===t.thousands)return!1;var r=e.split(":");if(3!==r.length)return!1;var n=+r[0],s=+r[1],o=+r[2];return!isNaN(n)&&!isNaN(s)&&!isNaN(o)}(t,l)?(s=+(n=t.split(":"))[0],i=+n[1],+n[2]+60*i+3600*s):o(t,l,h,u,c,d,r);else{if("number"!=typeof t)return;p=t}if(void 0!==p)return p}}},{"./globalState":4}],10:[function(e,t,r){"use strict";function n(e){return function(e){if(Array.isArray(e)){for(var t=0,r=new Array(e.length);t<e.length;t++)r[t]=e[t];return r}}(e)||function(e){if(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e))return Array.from(e)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance")}()}function s(e){return(s="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var o=e("./unformatting"),i=/^[a-z]{2,3}(-[a-zA-Z]{4})?(-([A-Z]{2}|[0-9]{3}))?$/,a={output:{type:"string",validValues:["currency","percent","byte","time","ordinal","number"]},base:{type:"string",validValues:["decimal","binary","general"],restriction:function(e,t){return"byte"===t.output},message:"`base` must be provided only when the output is `byte`",mandatory:function(e){return"byte"===e.output}},characteristic:{type:"number",restriction:function(e){return 0<=e},message:"value must be positive"},prefix:"string",postfix:"string",forceAverage:{type:"string",validValues:["trillion","billion","million","thousand"]},average:"boolean",currencyPosition:{type:"string",validValues:["prefix","infix","postfix"]},currencySymbol:"string",totalLength:{type:"number",restrictions:[{restriction:function(e){return 0<=e},message:"value must be positive"},{restriction:function(e,t){return!t.exponential},message:"`totalLength` is incompatible with `exponential`"}]},mantissa:{type:"number",restriction:function(e){return 0<=e},message:"value must be positive"},optionalMantissa:"boolean",trimMantissa:"boolean",optionalCharacteristic:"boolean",thousandSeparated:"boolean",spaceSeparated:"boolean",abbreviations:{type:"object",children:{thousand:"string",million:"string",billion:"string",trillion:"string"}},negative:{type:"string",validValues:["sign","parenthesis"]},forceSign:"boolean",exponential:{type:"boolean"},prefixSymbol:{type:"boolean",restriction:function(e,t){return"percent"===t.output},message:"`prefixSymbol` can be provided only when the output is `percent`"}},l={languageTag:{type:"string",mandatory:!0,restriction:function(e){return e.match(i)},message:"the language tag must follow the BCP 47 specification (see https://tools.ieft.org/html/bcp47)"},delimiters:{type:"object",children:{thousands:"string",decimal:"string",thousandsSize:"number"},mandatory:!0},abbreviations:{type:"object",children:{thousand:{type:"string",mandatory:!0},million:{type:"string",mandatory:!0},billion:{type:"string",mandatory:!0},trillion:{type:"string",mandatory:!0}},mandatory:!0},spaceSeparated:"boolean",ordinal:{type:"function",mandatory:!0},currency:{type:"object",children:{symbol:"string",position:"string",code:"string"},mandatory:!0},defaults:"format",ordinalFormat:"format",byteFormat:"format",percentageFormat:"format",currencyFormat:"format",timeDefaults:"format",formats:{type:"object",children:{fourDigits:{type:"format",mandatory:!0},fullWithTwoDecimals:{type:"format",mandatory:!0},fullWithTwoDecimalsNoCurrency:{type:"format",mandatory:!0},fullWithNoDecimals:{type:"format",mandatory:!0}}}};function h(e){return!!o.unformat(e)}function u(e,t,r){var o=3<arguments.length&&void 0!==arguments[3]&&arguments[3],i=Object.keys(e).map((function(n){if(!t[n])return console.error("".concat(r," Invalid key: ").concat(n)),!1;var o=e[n],i=t[n];if("string"==typeof i&&(i={type:i}),"format"===i.type){if(!u(o,a,"[Validate ".concat(n,"]"),!0))return!1}else if(s(o)!==i.type)return console.error("".concat(r," ").concat(n,' type mismatched: "').concat(i.type,'" expected, "').concat(s(o),'" provided')),!1;if(i.restrictions&&i.restrictions.length)for(var l=i.restrictions.length,h=0;h<l;h++){var c=i.restrictions[h],d=c.restriction,p=c.message;if(!d(o,e))return console.error("".concat(r," ").concat(n," invalid value: ").concat(p)),!1}return i.restriction&&!i.restriction(o,e)?(console.error("".concat(r," ").concat(n," invalid value: ").concat(i.message)),!1):i.validValues&&-1===i.validValues.indexOf(o)?(console.error("".concat(r," ").concat(n," invalid value: must be among ").concat(JSON.stringify(i.validValues),', "').concat(o,'" provided')),!1):!(i.children&&!u(o,i.children,"[Validate ".concat(n,"]")))}));return o||i.push.apply(i,n(Object.keys(t).map((function(n){var s=t[n];if("string"==typeof s&&(s={type:s}),s.mandatory){var o=s.mandatory;if("function"==typeof o&&(o=o(e)),o&&void 0===e[n])return console.error("".concat(r,' Missing mandatory key "').concat(n,'"')),!1}return!0})))),i.reduce((function(e,t){return e&&t}),!0)}function c(e){return u(e,a,"[Validate format]")}t.exports={validate:function(e,t){var r=h(e),n=c(t);return r&&n},validateFormat:c,validateInput:h,validateLanguage:function(e){return u(e,l,"[Validate language]")}}},{"./unformatting":9}]},{},[7])(7),window.numbro=r(63192)},83740:(e,t)=>{"use strict";t.__esModule=!0,t.parse=function(e){const t=[[""]];if(0===e.length)return t;let o,i=0,a=0;for(;e.length>0&&o!==e.length;)if(o=e.length,e.match(s))e=e.replace(s,""),i+=1,t[a][i]="";else if(e.match(r))e=e.replace(r,""),i=0,a+=1,t[a]=[""];else{let r="";if(e.startsWith('"')){let t=0,n=!0;for(;n;){const s=e.slice(0,1);'"'===s&&(t+=1),r+=s,(0===(e=e.slice(1)).length||e.match(/^[\t\r\n]/)&&t%2==0)&&(n=!1)}r=r.replace(/^"/,"").replace(/"$/,"").replace(/["]*/g,(e=>new Array(Math.floor(e.length/2)).fill('"').join("")))}else{const t=e.match(n);r=t?t[0]:"",e=e.slice(r.length)}t[a][i]=r}return t},t.stringify=function(e){let t,r,n,s,o,i="";for(t=0,r=e.length;t<r;t+=1){for(s=e[t].length,n=0;n<s;n+=1)n>0&&(i+="\t"),o=e[t][n],"string"==typeof o?o.indexOf("\n")>-1?i+=`"${o.replace(/"/g,'""')}"`:i+=o:i+=null==o?"":o;t!==r-1&&(i+="\n")}return i};const r=/^(\r\n|\n\r|\r|\n)/,n=/^[^\t\r\n]+/,s=/^\t/},70389:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(83740);t.parse=n.parse,t.stringify=n.stringify},89495:(e,t)=>{"use strict";t.__esModule=!0;t.RENDER_TYPE=1,t.FULLY_VISIBLE_TYPE=2,t.PARTIALLY_VISIBLE_TYPE=3},44038:(e,t,r)=>{"use strict";t.__esModule=!0;var n={RenderAllColumnsCalculator:!0,RenderAllRowsCalculator:!0,ViewportColumnsCalculator:!0,ViewportRowsCalculator:!0},s=r(97142);t.RenderAllColumnsCalculator=s.RenderAllColumnsCalculator;var o=r(97832);t.RenderAllRowsCalculator=o.RenderAllRowsCalculator;var i=r(71915);t.ViewportColumnsCalculator=i.ViewportColumnsCalculator;var a=r(4703);t.ViewportRowsCalculator=a.ViewportRowsCalculator;var l=r(89495);Object.keys(l).forEach((function(e){"default"!==e&&"__esModule"!==e&&(Object.prototype.hasOwnProperty.call(n,e)||e in t&&t[e]===l[e]||(t[e]=l[e]))}))},97142:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.RenderAllColumnsCalculator=class{constructor(e){(0,s.default)(this,"count",0),(0,s.default)(this,"startColumn",0),(0,s.default)(this,"endColumn",0),(0,s.default)(this,"startPosition",0),this.count=e.totalColumns,this.endColumn=this.count-1}}},97832:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.RenderAllRowsCalculator=class{constructor(e){(0,s.default)(this,"count",0),(0,s.default)(this,"startRow",0),(0,s.default)(this,"endRow",0),(0,s.default)(this,"startPosition",0),this.count=e.totalRows,this.endRow=this.count-1}}},71915:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(95913),r(15724);var s=n(r(85707)),o=r(89495);function i(e,t,r){!function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}(e,t),t.set(e,r)}function a(e,t){return e.get(l(e,t))}function l(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var h=new WeakMap;class u{static get DEFAULT_WIDTH(){return 50}constructor(e){var t,r,n;(0,s.default)(this,"count",0),(0,s.default)(this,"startColumn",null),(0,s.default)(this,"endColumn",null),(0,s.default)(this,"startPosition",null),(0,s.default)(this,"isVisibleInTrimmingContainer",!1),i(this,h,void 0),r=this,n=e,(t=h).set(l(t,r),n),this.calculate()}calculate(){const{calculationType:e,overrideFn:t,scrollOffset:r,totalColumns:n,viewportWidth:s}=a(h,this),i=Math.max(a(h,this).scrollOffset,0),l=i>0?s+1:s;let u=0,c=!0;const d=[];let p,g=0,f=0;for(let t=0;t<n;t++)if(p=this._getColumnWidth(t),u<=i&&e!==o.FULLY_VISIBLE_TYPE&&(this.startColumn=t,g=p),u>=i&&u+(e===o.FULLY_VISIBLE_TYPE?p:0)<=i+l&&(null!==this.startColumn&&void 0!==this.startColumn||(this.startColumn=t,g=p),this.endColumn=t),d.push(u),u+=p,f=p,e!==o.FULLY_VISIBLE_TYPE&&(this.endColumn=t),u>=i+s){c=!1;break}const m=r+s-l,E=e===o.FULLY_VISIBLE_TYPE?0:f,y=e===o.FULLY_VISIBLE_TYPE?g:0;if(m<-1*a(h,this).inlineStartOffset||r>d.at(-1)+E||-1*a(h,this).scrollOffset-a(h,this).viewportWidth>-1*y?this.isVisibleInTrimmingContainer=!1:this.isVisibleInTrimmingContainer=!0,this.endColumn===n-1&&c)for(this.startColumn=this.endColumn;this.startColumn>0;){const t=d[this.endColumn]+p-d[this.startColumn-1];if((t<=s||e!==o.FULLY_VISIBLE_TYPE)&&(this.startColumn-=1),t>s)break}e===o.RENDER_TYPE&&null!==this.startColumn&&t&&t(this),this.startPosition=d[this.startColumn],void 0===this.startPosition&&(this.startPosition=null),n<this.endColumn&&(this.endColumn=n-1),null!==this.startColumn&&(this.count=this.endColumn-this.startColumn+1)}_getColumnWidth(e){let t=a(h,this).columnWidthFn(e);return isNaN(t)&&(t=u.DEFAULT_WIDTH),t}}t.ViewportColumnsCalculator=u},4703:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(95913),r(15724);var s=n(r(85707)),o=r(89495);function i(e,t,r){!function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}(e,t),t.set(e,r)}function a(e,t){return e.get(l(e,t))}function l(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var h=new WeakMap;class u{static get DEFAULT_HEIGHT(){return 23}constructor(e){var t,r,n;(0,s.default)(this,"count",0),(0,s.default)(this,"startRow",null),(0,s.default)(this,"endRow",null),(0,s.default)(this,"startPosition",null),(0,s.default)(this,"isVisibleInTrimmingContainer",!1),i(this,h,void 0),r=this,n=e,(t=h).set(l(t,r),n),this.calculate()}calculate(){const{calculationType:e,overrideFn:t,rowHeightFn:r,scrollOffset:n,totalRows:s,viewportHeight:i}=a(h,this),l=Math.max(a(h,this).scrollOffset,0),c=a(h,this).horizontalScrollbarHeight||0;let d=0,p=!0;const g=[];let f,m=0,E=0;for(let t=0;t<s;t++)if(f=r(t),isNaN(f)&&(f=u.DEFAULT_HEIGHT),d<=l&&e!==o.FULLY_VISIBLE_TYPE&&(this.startRow=t,m=f),d>=l&&d+(e===o.FULLY_VISIBLE_TYPE?f:0)<=l+i-c&&(null===this.startRow&&(this.startRow=t,m=f),this.endRow=t),g.push(d),d+=f,E=f,e!==o.FULLY_VISIBLE_TYPE&&(this.endRow=t),d>=l+i-c){p=!1;break}const y=n+i-c,w=e===o.FULLY_VISIBLE_TYPE?m:0,C=e===o.FULLY_VISIBLE_TYPE?0:E;if(y<w||n>g.at(-1)+C?this.isVisibleInTrimmingContainer=!1:this.isVisibleInTrimmingContainer=!0,this.endRow===s-1&&p)for(this.startRow=this.endRow;this.startRow>0;){const t=g[this.endRow]+f-g[this.startRow-1];if((t<=i-c||e!==o.FULLY_VISIBLE_TYPE)&&(this.startRow-=1),t>=i-c)break}e===o.RENDER_TYPE&&null!==this.startRow&&t&&t(this),this.startPosition=g[this.startRow],void 0===this.startPosition&&(this.startPosition=null),s<this.endRow&&(this.endRow=s-1),null!==this.startRow&&(this.count=this.endRow-this.startRow+1)}}t.ViewportRowsCalculator=u},26022:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707));function o(e,t,r){!function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}(e,t),t.set(e,r)}function i(e,t){return e.get(l(e,t))}function a(e,t,r){return e.set(l(e,t),r),r}function l(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var h=new WeakMap;class u{constructor(e,t){let r=arguments.length>2&&void 0!==arguments[2]&&arguments[2];(0,s.default)(this,"row",null),(0,s.default)(this,"col",null),o(this,h,!1),a(h,this,r),void 0!==e&&void 0!==t&&(this.row=e,this.col=t)}isValid(e){const{countRows:t,countCols:r,countRowHeaders:n,countColHeaders:s}={countRows:0,countCols:0,countRowHeaders:0,countColHeaders:0,...e};return!(!Number.isInteger(this.row)||!Number.isInteger(this.col))&&(!(this.row<-s||this.col<-n)&&!(this.row>=t||this.col>=r))}isEqual(e){return e===this||this.row===e.row&&this.col===e.col}isHeader(){return!this.isCell()}isCell(){return this.row>=0&&this.col>=0}isRtl(){return i(h,this)}isSouthEastOf(e){return this.row>=e.row&&(i(h,this)?this.col<=e.col:this.col>=e.col)}isNorthWestOf(e){return this.row<=e.row&&(i(h,this)?this.col>=e.col:this.col<=e.col)}isSouthWestOf(e){return this.row>=e.row&&(i(h,this)?this.col>=e.col:this.col<=e.col)}isNorthEastOf(e){return this.row<=e.row&&(i(h,this)?this.col<=e.col:this.col>=e.col)}normalize(){return this.row=null===this.row?this.row:Math.max(this.row,0),this.col=null===this.col?this.col:Math.max(this.col,0),this}assign(e){return Number.isInteger(null==e?void 0:e.row)&&(this.row=e.row),Number.isInteger(null==e?void 0:e.col)&&(this.col=e.col),e instanceof u&&a(h,this,e.isRtl()),this}clone(){return new u(this.row,this.col,i(h,this))}toObject(){return{row:this.row,col:this.col}}}t.default=u},55139:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724);var s=n(r(85707)),o=n(r(26022));function i(e,t,r){!function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}(e,t),t.set(e,r)}function a(e,t){return e.get(l(e,t))}function l(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var h=new WeakMap;class u{constructor(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:e,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:e,n=arguments.length>3&&void 0!==arguments[3]&&arguments[3];var o,a,u;(0,s.default)(this,"highlight",null),(0,s.default)(this,"from",null),(0,s.default)(this,"to",null),i(this,h,!1),this.highlight=e.clone(),this.from=t.clone(),this.to=r.clone(),a=this,u=n,(o=h).set(l(o,a),u)}setHighlight(e){return this.highlight=e.clone(),this}setFrom(e){return this.from=e.clone(),this}setTo(e){return this.to=e.clone(),this}isValid(e){return this.from.isValid(e)&&this.to.isValid(e)}isSingle(){return this.isSingleCell()||this.isSingleHeader()}isSingleCell(){return this.from.row>=0&&this.from.row===this.to.row&&this.from.col>=0&&this.from.col===this.to.col}isSingleHeader(){return(this.from.row<0||this.from.col<0)&&this.from.row===this.to.row&&this.from.col===this.to.col}isHeader(){return!(!this.from.isHeader()||!this.to.isHeader())||(this.from.col<0&&this.to.col<0||this.from.row<0&&this.to.row<0)}containsHeaders(){return this.from.isHeader()||this.to.isHeader()}getOuterHeight(){return Math.max(this.from.row,this.to.row)-Math.min(this.from.row,this.to.row)+1}getOuterWidth(){return Math.max(this.from.col,this.to.col)-Math.min(this.from.col,this.to.col)+1}getHeight(){if(this.from.row<0&&this.to.row<0)return 0;const e=Math.max(this.from.row,0),t=Math.max(this.to.row,0);return Math.max(e,t)-Math.min(e,t)+1}getWidth(){if(this.from.col<0&&this.to.col<0)return 0;const e=Math.max(this.from.col,0),t=Math.max(this.to.col,0);return Math.max(e,t)-Math.min(e,t)+1}getCellsCount(){return this.getWidth()*this.getHeight()}includes(e){const{row:t,col:r}=e,n=this.getOuterTopStartCorner(),s=this.getOuterBottomEndCorner();return n.row<=t&&s.row>=t&&n.col<=r&&s.col>=r}includesRange(e){return this.includes(e.getOuterTopStartCorner())&&this.includes(e.getOuterBottomEndCorner())}isEqual(e){return Math.min(this.from.row,this.to.row)===Math.min(e.from.row,e.to.row)&&Math.max(this.from.row,this.to.row)===Math.max(e.from.row,e.to.row)&&Math.min(this.from.col,this.to.col)===Math.min(e.from.col,e.to.col)&&Math.max(this.from.col,this.to.col)===Math.max(e.from.col,e.to.col)}overlaps(e){return e.isSouthEastOf(this.getOuterTopLeftCorner())&&e.isNorthWestOf(this.getOuterBottomRightCorner())}isSouthEastOf(e){return this.getOuterTopLeftCorner().isSouthEastOf(e)||this.getOuterBottomRightCorner().isSouthEastOf(e)}isNorthWestOf(e){return this.getOuterTopLeftCorner().isNorthWestOf(e)||this.getOuterBottomRightCorner().isNorthWestOf(e)}isOverlappingHorizontally(e){return this.getOuterTopEndCorner().col>=e.getOuterTopStartCorner().col&&this.getOuterTopEndCorner().col<=e.getOuterTopEndCorner().col||this.getOuterTopStartCorner().col<=e.getOuterTopEndCorner().col&&this.getOuterTopStartCorner().col>=e.getOuterTopStartCorner().col}isOverlappingVertically(e){return this.getOuterBottomStartCorner().row>=e.getOuterTopRightCorner().row&&this.getOuterBottomStartCorner().row<=e.getOuterBottomStartCorner().row||this.getOuterTopEndCorner().row<=e.getOuterBottomStartCorner().row&&this.getOuterTopEndCorner().row>=e.getOuterTopRightCorner().row}expand(e){const t=this.getOuterTopStartCorner(),r=this.getOuterBottomEndCorner();return(e.row<t.row||e.col<t.col||e.row>r.row||e.col>r.col)&&(this.from=this._createCellCoords(Math.min(t.row,e.row),Math.min(t.col,e.col)),this.to=this._createCellCoords(Math.max(r.row,e.row),Math.max(r.col,e.col)),!0)}expandByRange(e){let t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];if(this.includesRange(e)||!this.overlaps(e))return!1;const r=this.getOuterTopStartCorner(),n=this.getOuterBottomEndCorner(),s=this.getDirection(),o=e.getOuterTopStartCorner(),i=e.getOuterBottomEndCorner(),a=Math.min(r.row,o.row),l=Math.min(r.col,o.col),h=Math.max(n.row,i.row),u=Math.max(n.col,i.col),c=this._createCellCoords(a,l),d=this._createCellCoords(h,u);return this.from=c,this.to=d,this.setDirection(s),t&&(this.highlight.row===this.getOuterBottomRightCorner().row&&"N-S"===this.getVerticalDirection()&&this.flipDirectionVertically(),this.highlight.col===this.getOuterTopRightCorner().col&&"W-E"===this.getHorizontalDirection()&&this.flipDirectionHorizontally()),!0}getDirection(){return this.from.isNorthWestOf(this.to)?"NW-SE":this.from.isNorthEastOf(this.to)?"NE-SW":this.from.isSouthEastOf(this.to)?"SE-NW":this.from.isSouthWestOf(this.to)?"SW-NE":void 0}setDirection(e){switch(e){case"NW-SE":[this.from,this.to]=[this.getOuterTopLeftCorner(),this.getOuterBottomRightCorner()];break;case"NE-SW":[this.from,this.to]=[this.getOuterTopRightCorner(),this.getOuterBottomLeftCorner()];break;case"SE-NW":[this.from,this.to]=[this.getOuterBottomRightCorner(),this.getOuterTopLeftCorner()];break;case"SW-NE":[this.from,this.to]=[this.getOuterBottomLeftCorner(),this.getOuterTopRightCorner()]}}getVerticalDirection(){return["NE-SW","NW-SE"].indexOf(this.getDirection())>-1?"N-S":"S-N"}getHorizontalDirection(){return["NW-SE","SW-NE"].indexOf(this.getDirection())>-1?"W-E":"E-W"}flipDirectionVertically(){switch(this.getDirection()){case"NW-SE":this.setDirection("SW-NE");break;case"NE-SW":this.setDirection("SE-NW");break;case"SE-NW":this.setDirection("NE-SW");break;case"SW-NE":this.setDirection("NW-SE")}}flipDirectionHorizontally(){switch(this.getDirection()){case"NW-SE":this.setDirection("NE-SW");break;case"NE-SW":this.setDirection("NW-SE");break;case"SE-NW":this.setDirection("SW-NE");break;case"SW-NE":this.setDirection("SE-NW")}}getTopStartCorner(){return this._createCellCoords(Math.min(this.from.row,this.to.row),Math.min(this.from.col,this.to.col)).normalize()}getTopLeftCorner(){return a(h,this)?this.getTopEndCorner():this.getTopStartCorner()}getBottomEndCorner(){return this._createCellCoords(Math.max(this.from.row,this.to.row),Math.max(this.from.col,this.to.col)).normalize()}getBottomRightCorner(){return a(h,this)?this.getBottomStartCorner():this.getBottomEndCorner()}getTopEndCorner(){return this._createCellCoords(Math.min(this.from.row,this.to.row),Math.max(this.from.col,this.to.col)).normalize()}getTopRightCorner(){return a(h,this)?this.getTopStartCorner():this.getTopEndCorner()}getBottomStartCorner(){return this._createCellCoords(Math.max(this.from.row,this.to.row),Math.min(this.from.col,this.to.col)).normalize()}getBottomLeftCorner(){return a(h,this)?this.getBottomEndCorner():this.getBottomStartCorner()}getOuterTopStartCorner(){return this._createCellCoords(Math.min(this.from.row,this.to.row),Math.min(this.from.col,this.to.col))}getOuterTopLeftCorner(){return a(h,this)?this.getOuterTopEndCorner():this.getOuterTopStartCorner()}getOuterBottomEndCorner(){return this._createCellCoords(Math.max(this.from.row,this.to.row),Math.max(this.from.col,this.to.col))}getOuterBottomRightCorner(){return a(h,this)?this.getOuterBottomStartCorner():this.getOuterBottomEndCorner()}getOuterTopEndCorner(){return this._createCellCoords(Math.min(this.from.row,this.to.row),Math.max(this.from.col,this.to.col))}getOuterTopRightCorner(){return a(h,this)?this.getOuterTopStartCorner():this.getOuterTopEndCorner()}getOuterBottomStartCorner(){return this._createCellCoords(Math.max(this.from.row,this.to.row),Math.min(this.from.col,this.to.col))}getOuterBottomLeftCorner(){return a(h,this)?this.getOuterBottomEndCorner():this.getOuterBottomStartCorner()}isCorner(e){return e.isEqual(this.getOuterTopLeftCorner())||e.isEqual(this.getOuterTopRightCorner())||e.isEqual(this.getOuterBottomLeftCorner())||e.isEqual(this.getOuterBottomRightCorner())}getOppositeCorner(e){return e instanceof o.default&&(e.isEqual(this.getOuterBottomEndCorner())?this.getOuterTopStartCorner():e.isEqual(this.getOuterTopStartCorner())?this.getOuterBottomEndCorner():e.isEqual(this.getOuterTopEndCorner())?this.getOuterBottomStartCorner():e.isEqual(this.getOuterBottomStartCorner())?this.getOuterTopEndCorner():void 0)}getBordersSharedWith(e){if(!this.includesRange(e))return[];const t=Math.min(this.from.row,this.to.row),r=Math.max(this.from.row,this.to.row),n=Math.min(this.from.col,this.to.col),s=Math.max(this.from.col,this.to.col),o=Math.min(e.from.row,e.to.row),i=Math.max(e.from.row,e.to.row),l=Math.min(e.from.col,e.to.col),u=Math.max(e.from.col,e.to.col),c=[];return t===o&&c.push("top"),s===u&&c.push(a(h,this)?"left":"right"),r===i&&c.push("bottom"),n===l&&c.push(a(h,this)?"right":"left"),c}getInner(){const e=this.getOuterTopStartCorner(),t=this.getOuterBottomEndCorner(),r=[];for(let n=e.row;n<=t.row;n++)for(let s=e.col;s<=t.col;s++)this.from.row===n&&this.from.col===s||this.to.row===n&&this.to.col===s||r.push(this._createCellCoords(n,s));return r}getAll(){const e=this.getOuterTopStartCorner(),t=this.getOuterBottomEndCorner(),r=[];for(let n=e.row;n<=t.row;n++)for(let s=e.col;s<=t.col;s++)e.row===n&&e.col===s?r.push(e):t.row===n&&t.col===s?r.push(t):r.push(this._createCellCoords(n,s));return r}forAll(e){const t=this.getOuterTopStartCorner(),r=this.getOuterBottomEndCorner();for(let n=t.row;n<=r.row;n++)for(let s=t.col;s<=r.col;s++){if(!1===e(n,s))return}}clone(){return new u(this.highlight,this.from,this.to,a(h,this))}toObject(){return{from:this.from.toObject(),to:this.to.toObject()}}_createCellCoords(e,t){return new o.default(e,t,a(h,this))}}t.default=u},7625:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724);var s=n(r(85707)),o=r(49536),i=r(69114),a=n(r(63286)),l=n(r(19184)),h=n(r(26022)),u=n(r(55139));t.default=class{get eventManager(){return new a.default(this)}constructor(e,t){(0,s.default)(this,"wtTable",void 0),(0,s.default)(this,"wtScroll",void 0),(0,s.default)(this,"wtViewport",void 0),(0,s.default)(this,"wtOverlays",void 0),(0,s.default)(this,"selectionManager",void 0),(0,s.default)(this,"wtEvent",void 0),(0,s.default)(this,"guid",`wt_${(0,i.randomString)()}`),(0,s.default)(this,"drawInterrupted",!1),(0,s.default)(this,"drawn",!1),(0,s.default)(this,"domBindings",void 0),(0,s.default)(this,"wtSettings",void 0),this.domBindings={rootTable:e,rootDocument:e.ownerDocument,rootWindow:e.ownerDocument.defaultView},this.wtSettings=t,this.wtScroll=new l.default(this.createScrollDao())}findOriginalHeaders(){const e=[];if(this.wtTable.THEAD.childNodes.length&&this.wtTable.THEAD.childNodes[0].childNodes.length){for(let t=0,r=this.wtTable.THEAD.childNodes[0].childNodes.length;t<r;t++)e.push(this.wtTable.THEAD.childNodes[0].childNodes[t].innerHTML);this.wtSettings.getSetting("columnHeaders").length||this.wtSettings.update("columnHeaders",[function(t,r){(0,o.fastInnerText)(r,e[t])}])}}createCellCoords(e,t){return new h.default(e,t,this.wtSettings.getSetting("rtlMode"))}createCellRange(e,t,r){return new u.default(e,t,r,this.wtSettings.getSetting("rtlMode"))}draw(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];return this.drawInterrupted=!1,e||this.wtTable.isVisible()?this.wtTable.draw(e):this.drawInterrupted=!0,this}getCell(e){if(!(arguments.length>1&&void 0!==arguments[1]&&arguments[1]))return this.wtTable.getCell(e);const t=this.wtSettings.getSetting("totalRows"),r=this.wtSettings.getSetting("fixedRowsTop"),n=this.wtSettings.getSetting("fixedRowsBottom"),s=this.wtSettings.getSetting("fixedColumnsStart");if(e.row<r&&e.col<s)return this.wtOverlays.topInlineStartCornerOverlay.clone.wtTable.getCell(e);if(e.row<r)return this.wtOverlays.topOverlay.clone.wtTable.getCell(e);if(e.col<s&&e.row>=t-n){if(this.wtOverlays.bottomInlineStartCornerOverlay&&this.wtOverlays.bottomInlineStartCornerOverlay.clone)return this.wtOverlays.bottomInlineStartCornerOverlay.clone.wtTable.getCell(e)}else{if(e.col<s)return this.wtOverlays.inlineStartOverlay.clone.wtTable.getCell(e);if(e.row<t&&e.row>=t-n&&this.wtOverlays.bottomOverlay&&this.wtOverlays.bottomOverlay.clone)return this.wtOverlays.bottomOverlay.clone.wtTable.getCell(e)}return this.wtTable.getCell(e)}scrollViewport(e,t,r,n,s){return!(e.col<0||e.row<0)&&this.wtScroll.scrollViewport(e,t,r,n,s)}scrollViewportHorizontally(e,t,r){return!(e<0)&&this.wtScroll.scrollViewportHorizontally(e,t,r)}scrollViewportVertically(e,t,r){return!(e<0)&&this.wtScroll.scrollViewportVertically(e,t,r)}getViewport(){return[this.wtTable.getFirstVisibleRow(),this.wtTable.getFirstVisibleColumn(),this.wtTable.getLastVisibleRow(),this.wtTable.getLastVisibleColumn()]}destroy(){this.wtOverlays.destroy(),this.wtEvent.destroy()}createScrollDao(){const e=this;return{get drawn(){return e.drawn},get topOverlay(){return e.wtOverlays.topOverlay},get inlineStartOverlay(){return e.wtOverlays.inlineStartOverlay},get wtTable(){return e.wtTable},get wtViewport(){return e.wtViewport},get wtSettings(){return e.wtSettings},get rootWindow(){return e.domBindings.rootWindow},get totalRows(){return e.wtSettings.getSetting("totalRows")},get totalColumns(){return e.wtSettings.getSetting("totalColumns")},get fixedRowsTop(){return e.wtSettings.getSetting("fixedRowsTop")},get fixedRowsBottom(){return e.wtSettings.getSetting("fixedRowsBottom")},get fixedColumnsStart(){return e.wtSettings.getSetting("fixedColumnsStart")}}}getTableDao(){const e=this;return{get wot(){return e},get parentTableOffset(){return e.cloneSource.wtTable.tableOffset},get cloneSource(){return e.cloneSource},get workspaceWidth(){return e.wtViewport.getWorkspaceWidth()},get wtViewport(){return e.wtViewport},get wtOverlays(){return e.wtOverlays},get selectionManager(){return e.selectionManager},get drawn(){return e.drawn},set drawn(t){e.drawn=t},get wtTable(){return e.wtTable},get startColumnRendered(){return e.wtViewport.columnsRenderCalculator.startColumn},get startColumnVisible(){return e.wtViewport.columnsVisibleCalculator.startColumn},get startColumnPartiallyVisible(){return e.wtViewport.columnsPartiallyVisibleCalculator.startColumn},get endColumnRendered(){return e.wtViewport.columnsRenderCalculator.endColumn},get endColumnVisible(){return e.wtViewport.columnsVisibleCalculator.endColumn},get endColumnPartiallyVisible(){return e.wtViewport.columnsPartiallyVisibleCalculator.endColumn},get countColumnsRendered(){return e.wtViewport.columnsRenderCalculator.count},get countColumnsVisible(){return e.wtViewport.columnsVisibleCalculator.count},get startRowRendered(){return e.wtViewport.rowsRenderCalculator.startRow},get startRowVisible(){return e.wtViewport.rowsVisibleCalculator.startRow},get startRowPartiallyVisible(){return e.wtViewport.rowsPartiallyVisibleCalculator.startRow},get endRowRendered(){return e.wtViewport.rowsRenderCalculator.endRow},get endRowVisible(){return e.wtViewport.rowsVisibleCalculator.endRow},get endRowPartiallyVisible(){return e.wtViewport.rowsPartiallyVisibleCalculator.endRow},get countRowsRendered(){return e.wtViewport.rowsRenderCalculator.count},get countRowsVisible(){return e.wtViewport.rowsVisibleCalculator.count},get columnHeaders(){return e.wtSettings.getSetting("columnHeaders")},get rowHeaders(){return e.wtSettings.getSetting("rowHeaders")}}}}},56736:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),o=n(r(28273)),i=n(r(7625));class a extends i.default{constructor(e,t,r){super(e,t),(0,s.default)(this,"cloneSource",void 0),(0,s.default)(this,"cloneOverlay",void 0);const n=this.wtSettings.getSetting("facade",this);this.cloneSource=r.source,this.cloneOverlay=r.overlay,this.wtTable=this.cloneOverlay.createTable(this.getTableDao(),n,this.domBindings,this.wtSettings),this.wtViewport=r.viewport,this.selectionManager=r.selectionManager,this.wtEvent=new o.default(n,this.domBindings,this.wtSettings,this.eventManager,this.wtTable,this.selectionManager,r.event),this.findOriginalHeaders()}}t.default=a},45778:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724);var s=n(r(28273)),o=n(r(78144)),i=n(r(20068)),a=n(r(43410)),l=n(r(86203)),h=n(r(7625)),u=r(34263),c=r(58460),d=r(49536);class p extends h.default{constructor(e,t){super(e,new i.default(t));const r=this.wtSettings.getSetting("facade",this);this.wtTable=new a.default(this.getTableDao(),r,this.domBindings,this.wtSettings),this.wtViewport=new l.default(this.getViewportDao(),this.domBindings,this.wtSettings,this.eventManager,this.wtTable),this.selectionManager=new u.SelectionManager(this.wtSettings.getSetting("selections")),this.wtEvent=new s.default(r,this.domBindings,this.wtSettings,this.eventManager,this.wtTable,this.selectionManager),this.wtOverlays=new o.default(this,r,this.domBindings,this.wtSettings,this.eventManager,this.wtTable),this.exportSettingsAsClassNames(),this.findOriginalHeaders()}exportSettingsAsClassNames(){const e=[],t=[];(0,c.objectEach)({rowHeaders:"htRowHeaders",columnHeaders:"htColumnHeaders"},((r,n)=>{this.wtSettings.getSetting(n).length&&t.push(r),e.push(r)})),(0,d.removeClass)(this.wtTable.wtRootElement.parentNode,e),(0,d.addClass)(this.wtTable.wtRootElement.parentNode,t)}getViewportDao(){const e=this;return{get wot(){return e},get topOverlayTrimmingContainer(){return e.wtOverlays.topOverlay.trimmingContainer},get inlineStartOverlayTrimmingContainer(){return e.wtOverlays.inlineStartOverlay.trimmingContainer},get topScrollPosition(){return e.wtOverlays.topOverlay.getScrollPosition()},get topParentOffset(){return e.wtOverlays.topOverlay.getTableParentOffset()},get inlineStartScrollPosition(){return e.wtOverlays.inlineStartOverlay.getScrollPosition()},get inlineStartParentOffset(){return e.wtOverlays.inlineStartOverlay.getTableParentOffset()},get topOverlay(){return e.wtOverlays.topOverlay},get inlineStartOverlay(){return e.wtOverlays.inlineStartOverlay},get bottomOverlay(){return e.wtOverlays.bottomOverlay}}}}t.default=p},28273:(e,t,r)=>{"use strict";t.__esModule=!0,r(67834);var n=r(49536),s=r(25735),o=r(36201),i=r(1479),a=r(67508);function l(e,t,r){!function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}(e,t),t.set(e,r)}function h(e,t){return e.get(c(e,t))}function u(e,t,r){return e.set(c(e,t),r),r}function c(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var d=new WeakMap,p=new WeakMap,g=new WeakMap,f=new WeakMap,m=new WeakMap,E=new WeakMap,y=new WeakMap,w=new WeakMap,C=new WeakMap,R=new WeakMap;t.default=class{constructor(e,t,r,n,s,o){let i=arguments.length>6&&void 0!==arguments[6]?arguments[6]:null;l(this,d,void 0),l(this,p,void 0),l(this,g,void 0),l(this,f,void 0),l(this,m,void 0),l(this,E,void 0),l(this,y,void 0),l(this,w,void 0),l(this,C,[null,null]),l(this,R,[null,null]),u(d,this,r),u(p,this,t),u(g,this,s),u(f,this,o),u(m,this,i),u(E,this,n),u(y,this,e),this.registerEvents()}registerEvents(){h(E,this).addEventListener(h(g,this).holder,"contextmenu",(e=>this.onContextMenu(e))),h(E,this).addEventListener(h(g,this).TABLE,"mouseover",(e=>this.onMouseOver(e))),h(E,this).addEventListener(h(g,this).TABLE,"mouseout",(e=>this.onMouseOut(e)));const e=()=>{h(E,this).addEventListener(h(g,this).holder,"touchstart",(e=>this.onTouchStart(e))),h(E,this).addEventListener(h(g,this).holder,"touchend",(e=>this.onTouchEnd(e))),this.momentumScrolling||(this.momentumScrolling={}),h(E,this).addEventListener(h(g,this).holder,"scroll",(()=>{clearTimeout(this.momentumScrolling._timeout),this.momentumScrolling.ongoing||h(d,this).getSetting("onBeforeTouchScroll"),this.momentumScrolling.ongoing=!0,this.momentumScrolling._timeout=setTimeout((()=>{this.touchApplied||(this.momentumScrolling.ongoing=!1,h(d,this).getSetting("onAfterMomentumScroll"))}),200)}))},t=()=>{h(E,this).addEventListener(h(g,this).holder,"mouseup",(e=>this.onMouseUp(e))),h(E,this).addEventListener(h(g,this).holder,"mousedown",(e=>this.onMouseDown(e)))};(0,i.isMobileBrowser)()?e():((0,o.isTouchSupported)()&&e(),t())}selectedCellWasTouched(e){const t=this.parentCell(e).coords;if(h(w,this)&&t){const[e,r]=[t.row,h(w,this).from.row],[n,s]=[t.col,h(w,this).from.col];return e===r&&n===s}return!1}parentCell(e){const t={},r=h(g,this).TABLE,s=(0,n.closestDown)(e,["TD","TH"],r);return s?(t.coords=h(g,this).getCoords(s),t.TD=s):(0,n.hasClass)(e,"wtBorder")&&(0,n.hasClass)(e,"current")?(t.coords=h(f,this).getFocusSelection().cellRange.highlight,t.TD=h(g,this).getCell(t.coords)):(0,n.hasClass)(e,"wtBorder")&&(0,n.hasClass)(e,"area")&&h(f,this).getAreaSelection().cellRange&&(t.coords=h(f,this).getAreaSelection().cellRange.to,t.TD=h(g,this).getCell(t.coords)),t}onMouseDown(e){const t=h(p,this).rootDocument.activeElement,r=(0,s.partial)(n.getParent,e.target),o=e.target;if(!["TD","TH"].includes(t.nodeName)&&(o===t||r(0)===t||r(1)===t))return;const i=this.parentCell(o);(0,n.hasClass)(o,"corner")?h(d,this).getSetting("onCellCornerMouseDown",e,o):i.TD&&h(d,this).has("onCellMouseDown")&&this.callListener("onCellMouseDown",e,i.coords,i.TD),(0===e.button||this.touchApplied)&&i.TD&&(h(R,this)[0]=i.TD,clearTimeout(h(C,this)[0]),h(C,this)[0]=setTimeout((()=>{h(R,this)[0]=null}),1e3))}onContextMenu(e){if(h(d,this).has("onCellContextMenu")){const t=this.parentCell(e.target);t.TD&&this.callListener("onCellContextMenu",e,t.coords,t.TD)}}onMouseOver(e){if(!h(d,this).has("onCellMouseOver"))return;const t=h(g,this).TABLE,r=(0,n.closestDown)(e.target,["TD","TH"],t),s=h(m,this)||this;r&&r!==s.lastMouseOver&&(0,n.isChildOf)(r,t)&&(s.lastMouseOver=r,this.callListener("onCellMouseOver",e,h(g,this).getCoords(r),r))}onMouseOut(e){if(!h(d,this).has("onCellMouseOut"))return;const t=h(g,this).TABLE,r=(0,n.closestDown)(e.target,["TD","TH"],t),s=(0,n.closestDown)(e.relatedTarget,["TD","TH"],t),o=h(m,this)||this;r&&r!==s&&(0,n.isChildOf)(r,t)&&(this.callListener("onCellMouseOut",e,h(g,this).getCoords(r),r),null===s&&(o.lastMouseOver=null))}onMouseUp(e){const t=this.parentCell(e.target);t.TD&&h(d,this).has("onCellMouseUp")&&this.callListener("onCellMouseUp",e,t.coords,t.TD),(0===e.button||this.touchApplied)&&(t.TD===h(R,this)[0]&&t.TD===h(R,this)[1]?((0,n.hasClass)(e.target,"corner")?this.callListener("onCellCornerDblClick",e,t.coords,t.TD):this.callListener("onCellDblClick",e,t.coords,t.TD),h(R,this)[0]=null,h(R,this)[1]=null):t.TD===h(R,this)[0]&&(h(R,this)[1]=t.TD,clearTimeout(h(C,this)[1]),h(C,this)[1]=setTimeout((()=>{h(R,this)[1]=null}),500)))}onTouchStart(e){u(w,this,h(f,this).getFocusSelection().cellRange),this.touchApplied=!0,this.onMouseDown(e)}onTouchEnd(e){var t;const r=e.target,n=null===(t=this.parentCell(r))||void 0===t?void 0:t.coords,s=(0,a.isDefined)(n)&&n.row>=0&&n.col>=0;if(e.cancelable&&s&&h(d,this).getSetting("isDataViewInstance")){const t=["A","BUTTON","INPUT"];(0,i.isIOS)()&&((0,i.isChromeWebKit)()||(0,i.isFirefoxWebKit)())&&this.selectedCellWasTouched(r)&&!t.includes(r.tagName)?e.preventDefault():this.selectedCellWasTouched(r)||e.preventDefault()}this.onMouseUp(e),this.touchApplied=!1}callListener(e,t,r,n){const s=h(d,this).getSettingPure(e);s&&s(t,r,n,h(y,this).call(this))}destroy(){clearTimeout(h(C,this)[0]),clearTimeout(h(C,this)[1]),h(E,this).destroy()}}},5421:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(45778)),o=n(r(7625));class i{constructor(e){e instanceof o.default?this._wot=e:this._initFromSettings(e)}_initFromSettings(e){e.facade=e=>{const t=new i(e);return()=>t},this._wot=new s.default(e.table,e)}get guid(){return this._wot.guid}get rootDocument(){return this._wot.domBindings.rootDocument}get rootWindow(){return this._wot.domBindings.rootWindow}get wtSettings(){return this._wot.wtSettings}get cloneSource(){return this._wot.cloneSource}get cloneOverlay(){return this._wot.cloneOverlay}get selectionManager(){return this._wot.selectionManager}get wtViewport(){return this._wot.wtViewport}get wtOverlays(){return this._wot.wtOverlays}get wtTable(){return this._wot.wtTable}get wtEvent(){return this._wot.wtEvent}get wtScroll(){return this._wot.wtScroll}get drawn(){return this._wot.drawn}set drawn(e){this._wot.drawn=e}get drawInterrupted(){return this._wot.drawInterrupted}set drawInterrupted(e){this._wot.drawInterrupted=e}get lastMouseOver(){return this._wot.lastMouseOver}set lastMouseOver(e){this._wot.lastMouseOver=e}get momentumScrolling(){return this._wot.momentumScrolling}set momentumScrolling(e){this._wot.momentumScrolling=e}get touchApplied(){return this._wot.touchApplied}set touchApplied(e){this._wot.touchApplied=e}get domBindings(){return this._wot.domBindings}get eventListeners(){return this._wot.eventListeners}set eventListeners(e){this._wot.eventListeners=e}get eventManager(){return this._wot.eventManager}createCellCoords(e,t){return this._wot.createCellCoords(e,t)}createCellRange(e,t,r){return this._wot.createCellRange(e,t,r)}draw(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];return this._wot.draw(e),this}getCell(e){let t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];return this._wot.getCell(e,t)}scrollViewport(e,t,r,n,s){return this._wot.scrollViewport(e,t,r,n,s)}scrollViewportHorizontally(e,t,r){return this._wot.scrollViewportHorizontally(e,t,r)}scrollViewportVertically(e,t,r){return this._wot.scrollViewportVertically(e,t,r)}getViewport(){return this._wot.getViewport()}getOverlayName(){return this._wot.cloneOverlay?this._wot.cloneOverlay.type:"master"}exportSettingsAsClassNames(){return this._wot.exportSettingsAsClassNames()}update(e,t){return this._wot.wtSettings.update(e,t),this}getSetting(e,t,r,n,s){return this._wot.wtSettings.getSetting(e,t,r,n,s)}hasSetting(e){return this._wot.wtSettings.hasSetting(e)}destroy(){this._wot.destroy()}}t.default=i},86296:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.default=class{constructor(e,t,r){(0,s.default)(this,"offset",void 0),(0,s.default)(this,"total",void 0),(0,s.default)(this,"countTH",void 0),this.offset=e,this.total=t,this.countTH=r}offsetted(e){return e+this.offset}unOffsetted(e){return e-this.offset}renderedToSource(e){return this.offsetted(e)}sourceToRendered(e){return this.unOffsetted(e)}offsettedTH(e){return e-this.countTH}unOffsettedTH(e){return e+this.countTH}visibleRowHeadedColumnToSourceColumn(e){return this.renderedToSource(this.offsettedTH(e))}sourceColumnToVisibleRowHeadedColumn(e){return this.unOffsettedTH(this.sourceToRendered(e))}}},81956:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.default=class{constructor(e,t,r){(0,s.default)(this,"offset",void 0),(0,s.default)(this,"total",void 0),(0,s.default)(this,"countTH",void 0),this.offset=e,this.total=t,this.countTH=r}offsetted(e){return e+this.offset}unOffsetted(e){return e-this.offset}renderedToSource(e){return this.offsetted(e)}sourceToRendered(e){return this.unOffsetted(e)}offsettedTH(e){return e-this.countTH}unOffsettedTH(e){return e+this.countTH}visibleColHeadedRowToSourceRow(e){return this.renderedToSource(this.offsettedTH(e))}sourceRowToVisibleColHeadedRow(e){return this.unOffsettedTH(this.sourceToRendered(e))}}},6697:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=r(44038);t.ViewportColumnsCalculator=s.ViewportColumnsCalculator,t.ViewportRowsCalculator=s.ViewportRowsCalculator;var o=n(r(26022));t.CellCoords=o.default;var i=n(r(55139));t.CellRange=i.default;var a=n(r(5421));t.default=a.default,t.Core=a.default;var l=r(37364);t.Selection=l.Selection,t.HIGHLIGHT_ACTIVE_HEADER_TYPE=l.ACTIVE_HEADER_TYPE,t.HIGHLIGHT_AREA_TYPE=l.AREA_TYPE,t.HIGHLIGHT_FOCUS_TYPE=l.FOCUS_TYPE,t.HIGHLIGHT_FILL_TYPE=l.FILL_TYPE,t.HIGHLIGHT_HEADER_TYPE=l.HEADER_TYPE,t.HIGHLIGHT_ROW_TYPE=l.ROW_TYPE,t.HIGHLIGHT_COLUMN_TYPE=l.COLUMN_TYPE,t.HIGHLIGHT_CUSTOM_SELECTION_TYPE=l.CUSTOM_SELECTION_TYPE;var h=function(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var r=d(t);if(r&&r.has(e))return r.get(e);var n={__proto__:null},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&{}.hasOwnProperty.call(e,o)){var i=s?Object.getOwnPropertyDescriptor(e,o):null;i&&(i.get||i.set)?Object.defineProperty(n,o,i):n[o]=e[o]}return n.default=e,r&&r.set(e,n),n}(r(7961));t.Renderer=h;var u=r(64625);t.OrderView=u.OrderView,t.SharedOrderView=u.SharedOrderView;var c=r(63286);function d(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,r=new WeakMap;return(d=function(e){return e?r:t})(e)}t.getListenersCounter=c.getListenersCounter},42278:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),o=r(49536),i=r(58460),a=r(98758),l=r(39874),h=r(79119),u=n(r(56736)),c=r(81595);t.Overlay=class{constructor(e,t,r,n,a){(0,s.default)(this,"wtSettings",null),(0,i.defineGetter)(this,"wot",e,{writable:!1}),this.domBindings=a,this.facadeGetter=t,this.wtSettings=n;const{TABLE:l,hider:h,spreader:u,holder:c,wtRootElement:d}=this.wot.wtTable;this.instance=this.wot,this.type=r,this.mainTableScrollableElement=null,this.TABLE=l,this.hider=h,this.spreader=u,this.holder=c,this.wtRootElement=d,this.trimmingContainer=(0,o.getTrimmingContainer)(this.hider.parentNode.parentNode),this.updateStateOfRendering(),this.clone=this.makeClone()}updateStateOfRendering(){const e=this.needFullRender;this.needFullRender=this.shouldBeRendered();const t=e!==this.needFullRender;return t&&!this.needFullRender&&this.reset(),t}shouldBeRendered(){return!0}updateTrimmingContainer(){this.trimmingContainer=(0,o.getTrimmingContainer)(this.hider.parentNode.parentNode)}updateMainScrollableElement(){const{wtTable:e}=this.wot,{rootWindow:t}=this.domBindings;"hidden"===t.getComputedStyle(e.wtRootElement.parentNode).getPropertyValue("overflow")?this.mainTableScrollableElement=this.wot.wtTable.holder:this.mainTableScrollableElement=(0,o.getScrollableElement)(e.TABLE)}getRelativeCellPosition(e,t,r){if(!1===this.clone.wtTable.holder.contains(e))return void(0,l.warn)(`The provided element is not a child of the ${this.type} overlay`);const n=this.mainTableScrollableElement===this.domBindings.rootWindow,s=r<this.wtSettings.getSetting("fixedColumnsStart"),o=t<this.wtSettings.getSetting("fixedRowsTop"),i=t>=this.wtSettings.getSetting("totalRows")-this.wtSettings.getSetting("fixedRowsBottom"),a=this.clone.wtTable.spreader,h={start:this.getRelativeStartPosition(a),top:a.offsetTop},u={start:this.getRelativeStartPosition(e),top:e.offsetTop};let c=null;return c=n?this.getRelativeCellPositionWithinWindow(o,s,u,h):this.getRelativeCellPositionWithinHolder(o,i,s,u,h),c}getRelativeStartPosition(e){return this.isRtl()?e.offsetParent.offsetWidth-e.offsetLeft-e.offsetWidth:e.offsetLeft}getRelativeCellPositionWithinWindow(e,t,r,n){const s=this.wot.wtTable.wtRootElement.getBoundingClientRect();let i=0,a=0;if(t){let e=s.left;this.isRtl()&&(e=this.domBindings.rootWindow.innerWidth-(s.left+s.width+(0,o.getScrollbarWidth)())),i=e<=0?-1*e:0}else i=n.start;if(e){a=this.clone.wtTable.TABLE.getBoundingClientRect().top-s.top}else a=n.top;return{start:r.start+i,top:r.top+a}}getRelativeCellPositionWithinHolder(e,t,r,n,s){const o=this.wot.wtOverlays.inlineStartOverlay.getScrollPosition(),i=this.wot.wtOverlays.topOverlay.getScrollPosition();let a=0,l=0;if(r||(a=o-s.start),t){const e=this.wot.wtTable.wtRootElement.getBoundingClientRect();l=-1*this.clone.wtTable.TABLE.getBoundingClientRect().top+e.top}else e||(l=i-s.top);return{start:n.start-a,top:n.top-l}}makeClone(){if(-1===h.CLONE_TYPES.indexOf(this.type))throw new Error(`Clone type "${this.type}" is not supported.`);const{wtTable:e,wtSettings:t}=this.wot,{rootDocument:r,rootWindow:n}=this.domBindings,s=r.createElement("div"),i=r.createElement("table"),a=e.wtRootElement.parentNode;s.className=`${h.CLONE_CLASS_NAMES.get(this.type)} handsontable`,s.setAttribute("dir",this.isRtl()?"rtl":"ltr"),s.style.position="absolute",s.style.top=0,s.style.overflow="visible",this.isRtl()?s.style.right=0:s.style.left=0,t.getSetting("ariaTags")&&(0,o.setAttribute)(s,[(0,c.A11Y_PRESENTATION)()]),i.className=e.TABLE.className;e.TABLE.getAttribute("role")&&i.setAttribute("role",e.TABLE.getAttribute("role")),s.appendChild(i),a.appendChild(s);const l=this.wtSettings.getSetting("preventOverflow");return!0===l||"horizontal"===l&&this.type===h.CLONE_TOP||"vertical"===l&&this.type===h.CLONE_INLINE_START?this.mainTableScrollableElement=n:"hidden"===n.getComputedStyle(a).getPropertyValue("overflow")?this.mainTableScrollableElement=e.holder:this.mainTableScrollableElement=(0,o.getScrollableElement)(e.TABLE),new u.default(i,this.wtSettings,{source:this.wot,overlay:this,viewport:this.wot.wtViewport,event:this.wot.wtEvent,selectionManager:this.wot.selectionManager})}refresh(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];const t=this.shouldBeRendered();this.clone&&(this.needFullRender||t)&&this.clone.draw(e),this.needFullRender=t}reset(){if(!this.clone)return;const e=this.clone.wtTable.holder,t=this.clone.wtTable.hider,r=e.style,n=t.style,s=e.parentNode.style;(0,a.arrayEach)([r,n,s],(e=>{e.width="",e.height=""}))}isRtl(){return this.wtSettings.getSetting("rtlMode")}destroy(){this.clone.eventManager.destroy()}}},47327:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),o=r(49536),i=n(r(60763)),a=r(42278),l=r(79119);class h extends a.Overlay{constructor(e,t,r,n){super(e,t,l.CLONE_BOTTOM,r,n),(0,s.default)(this,"cachedFixedRowsBottom",-1),this.cachedFixedRowsBottom=this.wtSettings.getSetting("fixedRowsBottom")}createTable(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return new i.default(...t)}shouldBeRendered(){return this.wtSettings.getSetting("shouldRenderBottomOverlay")}resetFixedPosition(){if(!this.needFullRender||!this.wot.wtTable.holder.parentNode)return!1;const{rootWindow:e}=this.domBindings,t=this.clone.wtTable.holder.parentNode;t.style.top="";let r=0;const n=this.wtSettings.getSetting("preventOverflow");this.trimmingContainer!==e||n&&"vertical"===n?(r=this.getScrollPosition(),this.repositionOverlay()):(r=this.getOverlayOffset(),t.style.bottom=`${r}px`);const s=this.adjustHeaderBordersPosition(r);return this.adjustElementsSize(),s}repositionOverlay(){const{wtTable:e,wtViewport:t}=this.wot,{rootDocument:r}=this.domBindings,n=this.clone.wtTable.holder.parentNode;let s=0;t.hasVerticalScroll()||(s+=t.getWorkspaceHeight()-e.getTotalHeight()),t.hasVerticalScroll()&&t.hasHorizontalScroll()&&(s+=(0,o.getScrollbarWidth)(r)),n.style.bottom=`${s}px`}setScrollPosition(e){const{rootWindow:t}=this.domBindings;let r=!1;return this.mainTableScrollableElement===t?(t.scrollTo((0,o.getWindowScrollLeft)(t),e),r=!0):this.mainTableScrollableElement.scrollTop!==e&&(this.mainTableScrollableElement.scrollTop=e,r=!0),r}onScroll(){this.wtSettings.getSetting("onScrollHorizontally")}sumCellSizes(e,t){const{wtTable:r,wtSettings:n}=this.wot,s=n.getSetting("defaultRowHeight");let o=e,i=0;for(;o<t;){const e=r.getRowHeight(o);i+=void 0===e?s:e,o+=1}return i}adjustElementsSize(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];this.updateTrimmingContainer(),(this.needFullRender||e)&&(this.adjustRootElementSize(),this.adjustRootChildrenSize())}adjustRootElementSize(){const{wtTable:e,wtViewport:t}=this.wot,{rootDocument:r,rootWindow:n}=this.domBindings,s=(0,o.getScrollbarWidth)(r),i=this.clone.wtTable.holder.parentNode.style,a=this.wtSettings.getSetting("preventOverflow");if(this.trimmingContainer!==n||"horizontal"===a){let r=t.getWorkspaceWidth();this.wot.wtOverlays.hasScrollbarRight&&(r-=s),r=Math.min(r,e.wtRootElement.scrollWidth),i.width=`${r}px`}else i.width="";this.clone.wtTable.holder.style.width=i.width;let l=(0,o.outerHeight)(this.clone.wtTable.TABLE);this.wot.wtTable.hasDefinedSize()||(l=0),i.height=`${l}px`}adjustRootChildrenSize(){const{holder:e}=this.clone.wtTable;this.clone.wtTable.hider.style.width=this.hider.style.width,e.style.width=e.parentNode.style.width,e.style.height=e.parentNode.style.height}applyToDOM(){const e=this.wtSettings.getSetting("totalRows");if("number"==typeof this.wot.wtViewport.rowsRenderCalculator.startPosition)this.spreader.style.top=`${this.wot.wtViewport.rowsRenderCalculator.startPosition}px`;else{if(0!==e)throw new Error("Incorrect value of the rowsRenderCalculator");this.spreader.style.top="0"}this.spreader.style.bottom="",this.needFullRender&&this.syncOverlayOffset()}syncOverlayOffset(){const e=this.isRtl()?"right":"left",{spreader:t}=this.clone.wtTable;"number"==typeof this.wot.wtViewport.columnsRenderCalculator.startPosition?t.style[e]=`${this.wot.wtViewport.columnsRenderCalculator.startPosition}px`:t.style[e]=""}scrollTo(e,t){let r=this.getTableParentOffset();const n=(this.wot.cloneSource?this.wot.cloneSource:this.wot).wtTable.holder;let s=0;t&&n.offsetHeight!==n.clientHeight&&(s=(0,o.getScrollbarWidth)(this.domBindings.rootDocument)),t?(r+=this.sumCellSizes(0,e+1),r-=this.wot.wtViewport.getViewportHeight(),r+=1):r+=this.sumCellSizes(this.wtSettings.getSetting("fixedRowsBottom"),e),r+=s,this.setScrollPosition(r)}getTableParentOffset(){return this.mainTableScrollableElement===this.domBindings.rootWindow?this.wot.wtTable.holderOffset.top:0}getScrollPosition(){return(0,o.getScrollTop)(this.mainTableScrollableElement,this.domBindings.rootWindow)}getOverlayOffset(){const{rootWindow:e}=this.domBindings,t=this.wtSettings.getSetting("preventOverflow");let r=0;if(this.trimmingContainer===e&&(!t||"vertical"!==t)){const e=this.wot.wtTable.getTotalHeight(),t=e-this.clone.wtTable.getTotalHeight(),n=this.domBindings.rootDocument.documentElement.clientHeight;r=Math.max(this.getTableParentOffset()-this.getScrollPosition()-n+e,0),r>t&&(r=0)}return r}adjustHeaderBordersPosition(e){const t=this.wtSettings.getSetting("fixedRowsBottom"),r=this.cachedFixedRowsBottom!==t,n=this.wtSettings.getSetting("columnHeaders");let s=!1;if((r||0===t)&&n.length>0){const t=this.wot.wtTable.holder.parentNode,r=(0,o.hasClass)(t,"innerBorderBottom");this.cachedFixedRowsBottom=this.wtSettings.getSetting("fixedRowsBottom"),e||0===this.wtSettings.getSetting("totalRows")?((0,o.addClass)(t,"innerBorderBottom"),s=!r):((0,o.removeClass)(t,"innerBorderBottom"),s=r)}return s}}t.BottomOverlay=h},69081:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=r(49536),o=n(r(69365)),i=r(42278),a=r(79119);class l extends i.Overlay{constructor(e,t,r,n,s,o){super(e,t,a.CLONE_BOTTOM_INLINE_START_CORNER,r,n),this.bottomOverlay=s,this.inlineStartOverlay=o}createTable(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return new o.default(...t)}shouldBeRendered(){return this.wtSettings.getSetting("shouldRenderBottomOverlay")&&this.wtSettings.getSetting("shouldRenderInlineStartOverlay")}resetFixedPosition(){const{wot:e}=this;if(this.updateTrimmingContainer(),!e.wtTable.holder.parentNode)return!1;const t=this.clone.wtTable.holder.parentNode;if(t.style.top="",this.trimmingContainer===this.domBindings.rootWindow){const e=this.inlineStartOverlay.getOverlayOffset(),r=this.bottomOverlay.getOverlayOffset();t.style[this.isRtl()?"right":"left"]=`${e}px`,t.style.bottom=`${r}px`}else(0,s.resetCssTransform)(t),this.repositionOverlay();let r=(0,s.outerHeight)(this.clone.wtTable.TABLE);const n=(0,s.outerWidth)(this.clone.wtTable.TABLE);return this.wot.wtTable.hasDefinedSize()||(r=0),t.style.height=`${r}px`,t.style.width=`${n}px`,!1}repositionOverlay(){const{wtTable:e,wtViewport:t}=this.wot,{rootDocument:r}=this.domBindings,n=this.clone.wtTable.holder.parentNode;let o=0;t.hasVerticalScroll()||(o+=t.getWorkspaceHeight()-e.getTotalHeight()),t.hasVerticalScroll()&&t.hasHorizontalScroll()&&(o+=(0,s.getScrollbarWidth)(r)),n.style.bottom=`${o}px`}}t.BottomInlineStartCornerOverlay=l},79119:(e,t)=>{"use strict";t.__esModule=!0;const r=t.CLONE_TOP="top",n=t.CLONE_BOTTOM="bottom",s=t.CLONE_INLINE_START="inline_start",o=t.CLONE_TOP_INLINE_START_CORNER="top_inline_start_corner",i=t.CLONE_BOTTOM_INLINE_START_CORNER="bottom_inline_start_corner";t.CLONE_TYPES=[r,n,s,o,i],t.CLONE_CLASS_NAMES=new Map([[r,`ht_clone_${r}`],[n,`ht_clone_${n}`],[s,`ht_clone_${s} ht_clone_left`],[o,`ht_clone_${o} ht_clone_top_left_corner`],[i,`ht_clone_${i} ht_clone_bottom_left_corner`]])},68574:(e,t,r)=>{"use strict";t.__esModule=!0;var n={BottomInlineStartCornerOverlay:!0,BottomOverlay:!0,InlineStartOverlay:!0,Overlay:!0,TopInlineStartCornerOverlay:!0,TopOverlay:!0},s=r(69081);t.BottomInlineStartCornerOverlay=s.BottomInlineStartCornerOverlay;var o=r(47327);t.BottomOverlay=o.BottomOverlay;var i=r(27777);t.InlineStartOverlay=i.InlineStartOverlay;var a=r(42278);t.Overlay=a.Overlay;var l=r(56563);t.TopInlineStartCornerOverlay=l.TopInlineStartCornerOverlay;var h=r(85321);t.TopOverlay=h.TopOverlay;var u=r(79119);Object.keys(u).forEach((function(e){"default"!==e&&"__esModule"!==e&&(Object.prototype.hasOwnProperty.call(n,e)||e in t&&t[e]===u[e]||(t[e]=u[e]))}))},27777:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=r(49536),o=n(r(14477)),i=r(42278),a=r(37364),l=r(79119);class h extends i.Overlay{constructor(e,t,r,n){super(e,t,l.CLONE_INLINE_START,r,n)}createTable(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return new o.default(...t)}shouldBeRendered(){return this.wtSettings.getSetting("shouldRenderInlineStartOverlay")}resetFixedPosition(){const{wtTable:e}=this.wot;if(!this.needFullRender||!e.holder.parentNode)return!1;const{rootWindow:t}=this.domBindings,r=this.clone.wtTable.holder.parentNode,n=this.wtSettings.getSetting("preventOverflow");let o=0;this.trimmingContainer!==t||n&&"horizontal"===n?(o=this.getScrollPosition(),(0,s.resetCssTransform)(r)):(o=this.getOverlayOffset()*(this.isRtl()?-1:1),(0,s.setOverlayPosition)(r,`${o}px`,"0px"));const i=this.adjustHeaderBordersPosition(o);return this.adjustElementsSize(),i}setScrollPosition(e){const{rootWindow:t}=this.domBindings;let r=!1;return this.isRtl()&&(e=-e),this.mainTableScrollableElement===t&&t.scrollX!==e?(t.scrollTo(e,(0,s.getWindowScrollTop)(t)),r=!0):this.mainTableScrollableElement.scrollLeft!==e&&(this.mainTableScrollableElement.scrollLeft=e,r=!0),r}onScroll(){this.wtSettings.getSetting("onScrollVertically")}sumCellSizes(e,t){const r=this.wtSettings.getSetting("defaultColumnWidth");let n=e,s=0;for(;n<t;)s+=this.wot.wtTable.getStretchedColumnWidth(n)||r,n+=1;return s}adjustElementsSize(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];this.updateTrimmingContainer(),(this.needFullRender||e)&&(this.adjustRootElementSize(),this.adjustRootChildrenSize())}adjustRootElementSize(){const{wtTable:e}=this.wot,{rootDocument:t,rootWindow:r}=this.domBindings,n=(0,s.getScrollbarWidth)(t),o=this.clone.wtTable.holder.parentNode.style,i=this.wtSettings.getSetting("preventOverflow");if(this.trimmingContainer!==r||"vertical"===i){let t=this.wot.wtViewport.getWorkspaceHeight();this.wot.wtOverlays.hasScrollbarBottom&&(t-=n),t=Math.min(t,e.wtRootElement.scrollHeight),o.height=`${t}px`}else o.height="";this.clone.wtTable.holder.style.height=o.height;const a=(0,s.outerWidth)(this.clone.wtTable.TABLE);o.width=`${a}px`}adjustRootChildrenSize(){const{holder:e}=this.clone.wtTable,t=this.wot.selectionManager.getFocusSelection()?parseInt(a.CORNER_DEFAULT_STYLE.width,10)/2:0;this.clone.wtTable.hider.style.height=this.hider.style.height,e.style.height=e.parentNode.style.height,e.style.width=`${parseInt(e.parentNode.style.width,10)+t}px`}applyToDOM(){const e=this.wtSettings.getSetting("totalColumns"),t=this.isRtl()?"right":"left";if("number"==typeof this.wot.wtViewport.columnsRenderCalculator.startPosition)this.spreader.style[t]=`${this.wot.wtViewport.columnsRenderCalculator.startPosition}px`;else{if(0!==e)throw new Error("Incorrect value of the columnsRenderCalculator");this.spreader.style[t]="0"}this.isRtl()?this.spreader.style.left="":this.spreader.style.right="",this.needFullRender&&this.syncOverlayOffset()}syncOverlayOffset(){"number"==typeof this.wot.wtViewport.rowsRenderCalculator.startPosition?this.clone.wtTable.spreader.style.top=`${this.wot.wtViewport.rowsRenderCalculator.startPosition}px`:this.clone.wtTable.spreader.style.top=""}scrollTo(e,t){const{wtSettings:r}=this,n=r.getSetting("rowHeaders"),o=r.getSetting("fixedColumnsStart"),i=(this.wot.cloneSource?this.wot.cloneSource:this.wot).wtTable.holder,a=0===o&&n.length>0&&!(0,s.hasClass)(i.parentNode,"innerBorderInlineStart")?1:0;let l=this.getTableParentOffset(),h=0;if(t){this.wot.wtTable.getColumnWidth(e)>this.wot.wtViewport.getViewportWidth()&&(t=!1)}return t&&i.offsetWidth!==i.clientWidth&&(h=(0,s.getScrollbarWidth)(this.domBindings.rootDocument)),t?(l+=this.sumCellSizes(0,e+1),l-=this.wot.wtViewport.getViewportWidth(),l+=a):l+=this.sumCellSizes(this.wtSettings.getSetting("fixedColumnsStart"),e),l+=h,(0,s.getMaximumScrollLeft)(this.mainTableScrollableElement)===l-a&&a>0&&this.wot.wtOverlays.expandHiderHorizontallyBy(a),this.setScrollPosition(l)}getTableParentOffset(){let e=0;return this.wtSettings.getSetting("preventOverflow")||this.trimmingContainer!==this.domBindings.rootWindow||(e=this.wot.wtTable.holderOffset.left),e}getScrollPosition(){return Math.abs((0,s.getScrollLeft)(this.mainTableScrollableElement,this.domBindings.rootWindow))}getOverlayOffset(){const{rootWindow:e}=this.domBindings,t=this.wtSettings.getSetting("preventOverflow");let r=0;if(this.trimmingContainer===e&&(!t||"horizontal"!==t)){r=this.isRtl()?Math.abs(Math.min(this.getTableParentOffset()-this.getScrollPosition(),0)):Math.max(this.getScrollPosition()-this.getTableParentOffset(),0);r>this.wot.wtTable.getTotalWidth()-this.clone.wtTable.getTotalWidth()&&(r=0)}return r}adjustHeaderBordersPosition(e){const t=this.wot.wtTable.holder.parentNode,r=this.wtSettings.getSetting("rowHeaders"),n=this.wtSettings.getSetting("fixedColumnsStart");this.wtSettings.getSetting("totalRows")?(0,s.removeClass)(t,"emptyRows"):(0,s.addClass)(t,"emptyRows");let o=!1;if(n&&!r.length)(0,s.addClass)(t,"innerBorderLeft innerBorderInlineStart");else if(!n&&r.length){const r=(0,s.hasClass)(t,"innerBorderInlineStart");e?((0,s.addClass)(t,"innerBorderLeft innerBorderInlineStart"),o=!r):((0,s.removeClass)(t,"innerBorderLeft innerBorderInlineStart"),o=r)}return o}}t.InlineStartOverlay=h},85321:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),o=r(49536),i=n(r(55477)),a=r(42278),l=r(37364),h=r(79119);class u extends a.Overlay{constructor(e,t,r,n){super(e,t,h.CLONE_TOP,r,n),(0,s.default)(this,"cachedFixedRowsTop",-1),this.cachedFixedRowsTop=this.wtSettings.getSetting("fixedRowsTop")}createTable(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return new i.default(...t)}shouldBeRendered(){return this.wtSettings.getSetting("shouldRenderTopOverlay")}resetFixedPosition(){if(!this.needFullRender||!this.wot.wtTable.holder.parentNode)return!1;const e=this.clone.wtTable.holder.parentNode,{rootWindow:t}=this.domBindings,r=this.wtSettings.getSetting("preventOverflow");let n=0,s=!1;if(this.trimmingContainer!==t||r&&"vertical"===r)n=this.getScrollPosition(),(0,o.resetCssTransform)(e);else{const{wtTable:t}=this.wot,r=t.hider.getBoundingClientRect();s=Math.ceil(r.bottom)===e.offsetHeight,n=this.getOverlayOffset(),(0,o.setOverlayPosition)(e,"0px",`${n}px`)}const i=this.adjustHeaderBordersPosition(n,s);return this.adjustElementsSize(),i}setScrollPosition(e){const t=this.domBindings.rootWindow;let r=!1;return this.mainTableScrollableElement===t&&t.scrollY!==e?(t.scrollTo((0,o.getWindowScrollLeft)(t),e),r=!0):this.mainTableScrollableElement.scrollTop!==e&&(this.mainTableScrollableElement.scrollTop=e,r=!0),r}onScroll(){this.wtSettings.getSetting("onScrollHorizontally")}sumCellSizes(e,t){const r=this.wtSettings.getSetting("defaultRowHeight");let n=e,s=0;for(;n<t;){const e=this.wot.wtTable.getRowHeight(n);s+=void 0===e?r:e,n+=1}return s}adjustElementsSize(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];this.updateTrimmingContainer(),(this.needFullRender||e)&&(this.adjustRootElementSize(),this.adjustRootChildrenSize())}adjustRootElementSize(){const{wtTable:e}=this.wot,{rootDocument:t,rootWindow:r}=this.domBindings,n=(0,o.getScrollbarWidth)(t),s=this.clone.wtTable.holder.parentNode.style,i=this.wtSettings.getSetting("preventOverflow");if(this.trimmingContainer!==r||"horizontal"===i){let t=this.wot.wtViewport.getWorkspaceWidth();this.wot.wtOverlays.hasScrollbarRight&&(t-=n),t=Math.min(t,e.wtRootElement.scrollWidth),s.width=`${t}px`}else s.width="";this.clone.wtTable.holder.style.width=s.width;let a=(0,o.outerHeight)(this.clone.wtTable.TABLE);this.wot.wtTable.hasDefinedSize()||(a=0),s.height=`${a}px`}adjustRootChildrenSize(){const{holder:e}=this.clone.wtTable,t=this.wot.selectionManager.getFocusSelection()?parseInt(l.CORNER_DEFAULT_STYLE.height,10)/2:0;this.clone.wtTable.hider.style.width=this.hider.style.width,e.style.width=e.parentNode.style.width,e.style.height=`${parseInt(e.parentNode.style.height,10)+t}px`}applyToDOM(){const e=this.wtSettings.getSetting("totalRows");if("number"==typeof this.wot.wtViewport.rowsRenderCalculator.startPosition)this.spreader.style.top=`${this.wot.wtViewport.rowsRenderCalculator.startPosition}px`;else{if(0!==e)throw new Error("Incorrect value of the rowsRenderCalculator");this.spreader.style.top="0"}this.spreader.style.bottom="",this.needFullRender&&this.syncOverlayOffset()}syncOverlayOffset(){const e=this.isRtl()?"right":"left",{spreader:t}=this.clone.wtTable;"number"==typeof this.wot.wtViewport.columnsRenderCalculator.startPosition?t.style[e]=`${this.wot.wtViewport.columnsRenderCalculator.startPosition}px`:t.style[e]=""}scrollTo(e,t){const{wot:r,wtSettings:n}=this,s=(r.cloneSource?r.cloneSource:r).wtTable.holder,i=n.getSetting("columnHeaders"),a=0===n.getSetting("fixedRowsTop")&&i.length>0&&!(0,o.hasClass)(s.parentNode,"innerBorderTop")?1:0;let l=this.getTableParentOffset(),h=0;if(t){this.wot.wtTable.getRowHeight(e)>this.wot.wtViewport.getViewportHeight()&&(t=!1)}if(t&&s.offsetHeight!==s.clientHeight&&(h=(0,o.getScrollbarWidth)(this.domBindings.rootDocument)),t){const t=n.getSetting("fixedRowsBottom"),s=n.getSetting("totalRows");l+=this.sumCellSizes(0,e+1),l-=r.wtViewport.getViewportHeight()-this.sumCellSizes(s-t,s),l+=1,l+=a}else l+=this.sumCellSizes(n.getSetting("fixedRowsTop"),e);return l+=h,(0,o.getMaximumScrollTop)(this.mainTableScrollableElement)===l-a&&a>0&&this.wot.wtOverlays.expandHiderVerticallyBy(a),this.setScrollPosition(l)}getTableParentOffset(){return this.mainTableScrollableElement===this.domBindings.rootWindow?this.wot.wtTable.holderOffset.top:0}getScrollPosition(){return(0,o.getScrollTop)(this.mainTableScrollableElement,this.domBindings.rootWindow)}getOverlayOffset(){const{rootWindow:e}=this.domBindings,t=this.wtSettings.getSetting("preventOverflow");let r=0;if(this.trimmingContainer===e&&(!t||"vertical"!==t)){const e=this.wot.wtTable.getTotalHeight()-this.clone.wtTable.getTotalHeight();r=Math.max(this.getScrollPosition()-this.getTableParentOffset(),0),r>e&&(r=0)}return r}adjustHeaderBordersPosition(e){let t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];const r=this.wot.wtTable.holder.parentNode;this.wtSettings.getSetting("totalColumns")?(0,o.removeClass)(r,"emptyColumns"):(0,o.addClass)(r,"emptyColumns");let n=!1;if(!t){const t=this.wtSettings.getSetting("fixedRowsTop"),s=this.cachedFixedRowsTop!==t,i=this.wtSettings.getSetting("columnHeaders");if((s||0===t)&&i.length>0){const t=(0,o.hasClass)(r,"innerBorderTop");this.cachedFixedRowsTop=this.wtSettings.getSetting("fixedRowsTop"),e||0===this.wtSettings.getSetting("totalRows")?((0,o.addClass)(r,"innerBorderTop"),n=!t):((0,o.removeClass)(r,"innerBorderTop"),n=t)}}return n}}t.TopOverlay=u},56563:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),o=r(49536),i=n(r(94159)),a=r(42278),l=r(79119);class h extends a.Overlay{constructor(e,t,r,n,o,i){super(e,t,l.CLONE_TOP_INLINE_START_CORNER,r,n),(0,s.default)(this,"topOverlay",void 0),(0,s.default)(this,"inlineStartOverlay",void 0),this.topOverlay=o,this.inlineStartOverlay=i}createTable(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return new i.default(...t)}shouldBeRendered(){return this.wtSettings.getSetting("shouldRenderTopOverlay")&&this.wtSettings.getSetting("shouldRenderInlineStartOverlay")}resetFixedPosition(){if(this.updateTrimmingContainer(),!this.wot.wtTable.holder.parentNode)return!1;const e=this.clone.wtTable.holder.parentNode;if(this.trimmingContainer===this.domBindings.rootWindow){const t=this.inlineStartOverlay.getOverlayOffset()*(this.isRtl()?-1:1),r=this.topOverlay.getOverlayOffset();(0,o.setOverlayPosition)(e,`${t}px`,`${r}px`)}else(0,o.resetCssTransform)(e);let t=(0,o.outerHeight)(this.clone.wtTable.TABLE);const r=(0,o.outerWidth)(this.clone.wtTable.TABLE);return this.wot.wtTable.hasDefinedSize()||(t=0),e.style.height=`${t}px`,e.style.width=`${r}px`,!1}}t.TopInlineStartCornerOverlay=h},78144:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724);var s=n(r(85707)),o=r(49536),i=r(36201),a=r(98758),l=r(35592),h=r(1479),u=r(68574);t.default=class{constructor(e,t,r,n,a,l){(0,s.default)(this,"wot",null),(0,s.default)(this,"topOverlay",null),(0,s.default)(this,"bottomOverlay",null),(0,s.default)(this,"inlineStartOverlay",null),(0,s.default)(this,"topInlineStartCornerOverlay",null),(0,s.default)(this,"bottomInlineStartCornerOverlay",null),(0,s.default)(this,"browserLineHeight",void 0),(0,s.default)(this,"wtSettings",null),(0,s.default)(this,"resizeObserver",new ResizeObserver((e=>{(0,i.requestAnimationFrame)((()=>{Array.isArray(e)&&e.length&&this.wtSettings.getSetting("onContainerElementResize")}))}))),this.wot=e,this.wtSettings=n,this.domBindings=r,this.facadeGetter=t,this.wtTable=l;const{rootDocument:h,rootWindow:u}=this.domBindings;this.instance=this.wot,this.eventManager=a,this.scrollbarSize=(0,o.getScrollbarWidth)(h);const c="hidden"===u.getComputedStyle(l.wtRootElement.parentNode).getPropertyValue("overflow");this.scrollableElement=c?l.holder:(0,o.getScrollableElement)(l.TABLE),this.initOverlays(),this.hasScrollbarBottom=!1,this.hasScrollbarRight=!1,this.destroyed=!1,this.keyPressed=!1,this.spreaderLastSize={width:null,height:null},this.verticalScrolling=!1,this.horizontalScrolling=!1,this.initBrowserLineHeight(),this.registerListeners(),this.lastScrollX=u.scrollX,this.lastScrollY=u.scrollY}getOverlays(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];const t=[this.topOverlay,this.topInlineStartCornerOverlay,this.inlineStartOverlay,this.bottomOverlay,this.bottomInlineStartCornerOverlay];return e&&t.push(this.wtTable),t}initBrowserLineHeight(){const{rootWindow:e,rootDocument:t}=this.domBindings,r=e.getComputedStyle(t.body),n=parseInt(r.lineHeight,10),s=1.2*parseInt(r.fontSize,10);this.browserLineHeight=n||s}initOverlays(){const e=[this.wot,this.facadeGetter,this.wtSettings,this.domBindings];this.topOverlay=new u.TopOverlay(...e),this.bottomOverlay=new u.BottomOverlay(...e),this.inlineStartOverlay=new u.InlineStartOverlay(...e),this.topInlineStartCornerOverlay=new u.TopInlineStartCornerOverlay(...e,this.topOverlay,this.inlineStartOverlay),this.bottomInlineStartCornerOverlay=new u.BottomInlineStartCornerOverlay(...e,this.bottomOverlay,this.inlineStartOverlay)}updateStateOfRendering(){let e=this.topOverlay.updateStateOfRendering();return e=this.bottomOverlay.updateStateOfRendering()||e,e=this.inlineStartOverlay.updateStateOfRendering()||e,this.inlineStartOverlay.needFullRender&&(this.topOverlay.needFullRender&&(e=this.topInlineStartCornerOverlay.updateStateOfRendering()||e),this.bottomOverlay.needFullRender&&(e=this.bottomInlineStartCornerOverlay.updateStateOfRendering()||e)),e}refreshAll(){this.wot.drawn&&(this.wtTable.holder.parentNode?(this.wot.draw(!0),this.verticalScrolling&&this.inlineStartOverlay.onScroll(),this.horizontalScrolling&&this.topOverlay.onScroll(),this.verticalScrolling=!1,this.horizontalScrolling=!1):this.destroy())}registerListeners(){const{rootDocument:e,rootWindow:t}=this.domBindings,{mainTableScrollableElement:r}=this.topOverlay,{mainTableScrollableElement:n}=this.inlineStartOverlay;this.eventManager.addEventListener(e.documentElement,"keydown",(e=>this.onKeyDown(e))),this.eventManager.addEventListener(e.documentElement,"keyup",(()=>this.onKeyUp())),this.eventManager.addEventListener(e,"visibilitychange",(()=>this.onKeyUp())),this.eventManager.addEventListener(r,"scroll",(e=>this.onTableScroll(e)),{passive:!0}),r!==n&&this.eventManager.addEventListener(n,"scroll",(e=>this.onTableScroll(e)),{passive:!0});const s=t.devicePixelRatio&&t.devicePixelRatio>1,o=this.scrollableElement===t,i=this.wtSettings.getSetting("preventWheel"),a={passive:o};(i||s||!(0,h.isChrome)())&&this.eventManager.addEventListener(this.wtTable.wtRootElement,"wheel",(e=>this.onCloneWheel(e,i)),a);let l;[this.topOverlay,this.bottomOverlay,this.inlineStartOverlay,this.topInlineStartCornerOverlay,this.bottomInlineStartCornerOverlay].forEach((e=>{if(e&&e.needFullRender){const{holder:t}=e.clone.wtTable;this.eventManager.addEventListener(t,"wheel",(e=>this.onCloneWheel(e,i)),a)}})),this.eventManager.addEventListener(t,"resize",(()=>{clearTimeout(l),l=setTimeout((()=>{this.wtSettings.getSetting("onWindowResize")}),200)})),o||this.resizeObserver.observe(this.wtTable.wtRootElement.parentElement)}deregisterListeners(){this.eventManager.clearEvents(!0)}onTableScroll(e){const t=this.domBindings.rootWindow,r=this.inlineStartOverlay.mainTableScrollableElement,n=this.topOverlay.mainTableScrollableElement,s=e.target;this.keyPressed&&(n!==t&&s!==t&&!e.target.contains(n)||r!==t&&s!==t&&!e.target.contains(r))||this.syncScrollPositions(e)}onCloneWheel(e,t){const{rootWindow:r}=this.domBindings,n=this.inlineStartOverlay.mainTableScrollableElement,s=this.topOverlay.mainTableScrollableElement,o=e.target,i=s!==r&&o!==r&&!o.contains(s),a=n!==r&&o!==r&&!o.contains(n);if(this.keyPressed&&(i||a))return;const l=this.translateMouseWheelToScroll(e);(t||this.scrollableElement!==r&&l)&&e.preventDefault()}onKeyDown(e){this.keyPressed=(0,l.isKey)(e.keyCode,"ARROW_UP|ARROW_RIGHT|ARROW_DOWN|ARROW_LEFT")}onKeyUp(){this.keyPressed=!1}translateMouseWheelToScroll(e){let t=isNaN(e.deltaY)?-1*e.wheelDeltaY:e.deltaY,r=isNaN(e.deltaX)?-1*e.wheelDeltaX:e.deltaX;1===e.deltaMode&&(r+=r*this.browserLineHeight,t+=t*this.browserLineHeight);const n=this.scrollVertically(t),s=this.scrollHorizontally(r);return n||s}scrollVertically(e){const t=this.scrollableElement.scrollTop;return this.scrollableElement.scrollTop+=e,t!==this.scrollableElement.scrollTop}scrollHorizontally(e){const t=this.scrollableElement.scrollLeft;return this.scrollableElement.scrollLeft+=e,t!==this.scrollableElement.scrollLeft}syncScrollPositions(){if(this.destroyed)return;const{rootWindow:e}=this.domBindings,t=this.topOverlay.clone.wtTable.holder,r=this.inlineStartOverlay.clone.wtTable.holder,[n,s]=[this.scrollableElement.scrollLeft,this.scrollableElement.scrollTop];if(this.horizontalScrolling=t.scrollLeft!==n||this.lastScrollX!==e.scrollX,this.verticalScrolling=r.scrollTop!==s||this.lastScrollY!==e.scrollY,this.lastScrollX=e.scrollX,this.lastScrollY=e.scrollY,this.horizontalScrolling){t.scrollLeft=n;const e=this.bottomOverlay.needFullRender?this.bottomOverlay.clone.wtTable.holder:null;e&&(e.scrollLeft=n)}this.verticalScrolling&&(r.scrollTop=s),this.refreshAll()}syncScrollWithMaster(){const e=this.topOverlay.mainTableScrollableElement,{scrollLeft:t,scrollTop:r}=e;this.topOverlay.needFullRender&&(this.topOverlay.clone.wtTable.holder.scrollLeft=t),this.bottomOverlay.needFullRender&&(this.bottomOverlay.clone.wtTable.holder.scrollLeft=t),this.inlineStartOverlay.needFullRender&&(this.inlineStartOverlay.clone.wtTable.holder.scrollTop=r)}updateMainScrollableElements(){this.deregisterListeners(),this.inlineStartOverlay.updateMainScrollableElement(),this.topOverlay.updateMainScrollableElement(),this.bottomOverlay.needFullRender&&this.bottomOverlay.updateMainScrollableElement();const{wtTable:e}=this,{rootWindow:t}=this.domBindings;"hidden"===t.getComputedStyle(e.wtRootElement.parentNode).getPropertyValue("overflow")?this.scrollableElement=e.holder:this.scrollableElement=(0,o.getScrollableElement)(e.TABLE),this.registerListeners()}destroy(){this.resizeObserver.disconnect(),this.eventManager.destroy(),this.topOverlay.destroy(),this.bottomOverlay.clone&&this.bottomOverlay.destroy(),this.inlineStartOverlay.destroy(),this.topInlineStartCornerOverlay&&this.topInlineStartCornerOverlay.destroy(),this.bottomInlineStartCornerOverlay&&this.bottomInlineStartCornerOverlay.clone&&this.bottomInlineStartCornerOverlay.destroy(),this.destroyed=!0}refresh(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];this.updateLastSpreaderSize()&&this.adjustElementsSize(),this.bottomOverlay.clone&&this.bottomOverlay.refresh(e),this.inlineStartOverlay.refresh(e),this.topOverlay.refresh(e),this.topInlineStartCornerOverlay&&this.topInlineStartCornerOverlay.refresh(e),this.bottomInlineStartCornerOverlay&&this.bottomInlineStartCornerOverlay.clone&&this.bottomInlineStartCornerOverlay.refresh(e)}updateLastSpreaderSize(){const e=this.wtTable.spreader,t=e.clientWidth,r=e.clientHeight,n=t!==this.spreaderLastSize.width||r!==this.spreaderLastSize.height;return n&&(this.spreaderLastSize.width=t,this.spreaderLastSize.height=r),n}adjustElementsSize(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];const{wtViewport:t}=this.wot,{wtTable:r}=this,{rootWindow:n}=this.domBindings,s=this.scrollableElement===n,o=this.wtSettings.getSetting("totalColumns"),i=this.wtSettings.getSetting("totalRows"),a=t.getRowHeaderWidth(),l=t.getColumnHeaderHeight()+this.topOverlay.sumCellSizes(0,i)+1,h=a+this.inlineStartOverlay.sumCellSizes(0,o),u=r.hider.style,c=(()=>!s&&this.scrollableElement.scrollTop>Math.max(0,l-r.holder.clientHeight))()?1:0,d=(()=>!s&&this.scrollableElement.scrollLeft>Math.max(0,h-r.holder.clientWidth))()?1:0;if(u.width=`${h+d}px`,u.height=`${l+c}px`,this.scrollbarSize>0){const{scrollHeight:e,scrollWidth:t}=r.wtRootElement,{scrollHeight:n,scrollWidth:s}=r.holder;this.hasScrollbarRight=e<n,this.hasScrollbarBottom=t<s,this.hasScrollbarRight&&r.hider.scrollWidth+this.scrollbarSize>t?this.hasScrollbarBottom=!0:this.hasScrollbarBottom&&r.hider.scrollHeight+this.scrollbarSize>e&&(this.hasScrollbarRight=!0)}this.topOverlay.adjustElementsSize(e),this.inlineStartOverlay.adjustElementsSize(e),this.bottomOverlay.adjustElementsSize(e)}expandHiderVerticallyBy(e){const{wtTable:t}=this;t.hider.style.height=`${parseInt(t.hider.style.height,10)+e}px`}expandHiderHorizontallyBy(e){const{wtTable:t}=this;t.hider.style.width=`${parseInt(t.hider.style.width,10)+e}px`}applyToDOM(){this.wtTable.isVisible()&&(this.topOverlay.applyToDOM(),this.bottomOverlay.clone&&this.bottomOverlay.applyToDOM(),this.inlineStartOverlay.applyToDOM())}getParentOverlay(e){if(!e)return null;const t=[this.topOverlay,this.inlineStartOverlay,this.bottomOverlay,this.topInlineStartCornerOverlay,this.bottomInlineStartCornerOverlay];let r=null;return(0,a.arrayEach)(t,(t=>{t&&t.clone&&t.clone.wtTable.TABLE.contains(e)&&(r=t.clone)})),r}syncOverlayTableClassNames(){const e=this.wtTable.TABLE,t=[this.topOverlay,this.inlineStartOverlay,this.bottomOverlay,this.topInlineStartCornerOverlay,this.bottomInlineStartCornerOverlay];(0,a.arrayEach)(t,(t=>{t&&(t.clone.wtTable.TABLE.className=e.className)}))}}},54493:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),o=n(r(63912));t.default=class{constructor(e,t){(0,s.default)(this,"nodesPool",null),(0,s.default)(this,"nodeType",void 0),(0,s.default)(this,"rootNode",void 0),(0,s.default)(this,"table",null),(0,s.default)(this,"renderedNodes",0),this.nodesPool="string"==typeof e?new o.default(e):null,this.nodeType=e,this.rootNode=t}setTable(e){this.nodesPool&&this.nodesPool.setRootDocument(e.rootDocument),this.table=e}adjust(){}render(){}}},90720:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),o=r(49536),i=r(64625),a=n(r(54493)),l=r(81595);class h extends a.default{constructor(){super("TD"),(0,s.default)(this,"orderViews",new WeakMap),(0,s.default)(this,"sourceRowIndex",0)}obtainOrderView(e){let t;return this.orderViews.has(e)?t=this.orderViews.get(e):(t=new i.SharedOrderView(e,(e=>this.nodesPool.obtain(this.sourceRowIndex,e)),this.nodeType),this.orderViews.set(e,t)),t}render(){const{rowsToRender:e,columnsToRender:t,rows:r,rowHeaders:n}=this.table;for(let a=0;a<e;a++){const e=this.table.renderedRowToSource(a),h=r.getRenderedNode(a);this.sourceRowIndex=e;const u=this.obtainOrderView(h),c=n.obtainOrderView(h);u.prependView(c).setSize(t).setOffset(this.table.renderedColumnToSource(0)).start();for(let r=0;r<t;r++){u.render();const t=u.getCurrentNode(),n=this.table.renderedColumnToSource(r);var s,i;if((0,o.hasClass)(t,"hide")||(t.className=""),t.removeAttribute("style"),t.removeAttribute("dir"),(0,o.removeAttribute)(t,[new RegExp("aria-(.*)"),new RegExp("role")]),this.table.cellRenderer(e,n,t),this.table.isAriaEnabled())(0,o.setAttribute)(t,[...t.hasAttribute("role")?[]:[(0,l.A11Y_GRIDCELL)()],(0,l.A11Y_TABINDEX)(-1),(0,l.A11Y_COLINDEX)(n+(null!==(s=null===(i=this.table.rowUtils)||void 0===i||null===(i=i.dataAccessObject)||void 0===i?void 0:i.rowHeaders.length)&&void 0!==s?s:0)+1)])}u.end()}}}t.default=h},23792:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(54493)),o=r(39874),i=r(12556),a=r(49536);let l=!1;class h extends s.default{constructor(e){super(null,e)}adjust(){const{columnsToRender:e,rowHeadersCount:t}=this.table,r=e+t;for(;this.renderedNodes<r;)this.rootNode.appendChild(this.table.rootDocument.createElement("col")),this.renderedNodes+=1;for(;this.renderedNodes>r;)this.rootNode.removeChild(this.rootNode.lastChild),this.renderedNodes-=1}render(){this.adjust();const{columnsToRender:e,rowHeadersCount:t}=this.table;!l&&e>1e3&&(l=!0,(0,o.warn)(i.toSingleLine`Performance tip: Handsontable rendered more than 1000 visible columns.\x20
        Consider limiting the number of rendered columns by specifying the table width and/or\x20
        turning off the "renderAllColumns" option.`));for(let e=0;e<t;e++){const t=this.table.renderedColumnToSource(e),r=this.table.columnUtils.getHeaderWidth(t);this.rootNode.childNodes[e].style.width=`${r}px`}for(let r=0;r<e;r++){const e=this.table.renderedColumnToSource(r),n=this.table.columnUtils.getStretchedColumnWidth(e);this.rootNode.childNodes[r+t].style.width=`${n}px`}const r=this.rootNode.firstChild;r&&(0,a.addClass)(r,"rowHeader")}}t.default=h},83013:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=r(49536),o=n(r(54493)),i=r(81595);class a extends o.default{constructor(e){super(null,e)}adjust(){const{columnHeadersCount:e,rowHeadersCount:t}=this.table;let r=this.rootNode.firstChild;if(e){const{columnsToRender:n}=this.table,s=n+t;for(let t=0,n=e;t<n;t++){for(r=this.rootNode.childNodes[t],r||(r=this.table.rootDocument.createElement("tr"),this.rootNode.appendChild(r)),this.renderedNodes=r.childNodes.length;this.renderedNodes<s;)r.appendChild(this.table.rootDocument.createElement("th")),this.renderedNodes+=1;for(;this.renderedNodes>s;)r.removeChild(r.lastChild),this.renderedNodes-=1}const o=this.rootNode.childNodes.length;if(o>e)for(let t=e;t<o;t++)this.rootNode.removeChild(this.rootNode.lastChild)}else r&&(0,s.empty)(r)}render(){const{columnHeadersCount:e}=this.table;this.table.isAriaEnabled()&&(0,s.setAttribute)(this.rootNode,[(0,i.A11Y_ROWGROUP)()]);for(let t=0;t<e;t+=1){const{columnHeaderFunctions:e,columnsToRender:r,rowHeadersCount:n}=this.table,o=this.rootNode.childNodes[t];this.table.isAriaEnabled()&&(0,s.setAttribute)(o,[(0,i.A11Y_ROW)(),(0,i.A11Y_ROWINDEX)(t+1)]);for(let a=-1*n;a<r;a+=1){const r=this.table.renderedColumnToSource(a),l=o.childNodes[a+n];l.className="",l.removeAttribute("style"),(0,s.removeAttribute)(l,[new RegExp("aria-(.*)"),new RegExp("role")]),this.table.isAriaEnabled()&&(0,s.setAttribute)(l,[(0,i.A11Y_COLINDEX)(a+1+this.table.rowHeadersCount),(0,i.A11Y_TABINDEX)(-1),(0,i.A11Y_COLUMNHEADER)(),...a>=0?[(0,i.A11Y_SCOPE_COL)()]:[(0,i.A11Y_ROW)()]]),e[t](r,l,t)}}}}t.default=a},7961:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(31211));t.RowHeadersRenderer=s.default;var o=n(r(83013));t.ColumnHeadersRenderer=o.default;var i=n(r(23792));t.ColGroupRenderer=i.default;var a=n(r(84140));t.RowsRenderer=a.default;var l=n(r(90720));t.CellsRenderer=l.default;var h=n(r(95593));t.TableRenderer=h.default;t.Renderer=class{constructor(){let{TABLE:e,THEAD:t,COLGROUP:r,TBODY:n,rowUtils:u,columnUtils:c,cellRenderer:d}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};this.renderer=new h.default(e,{cellRenderer:d}),this.renderer.setRenderers({rowHeaders:new s.default,columnHeaders:new o.default(t),colGroup:new i.default(r),rows:new a.default(n),cells:new l.default}),this.renderer.setAxisUtils(u,c)}setFilters(e,t){return this.renderer.setFilters(e,t),this}setViewportSize(e,t){return this.renderer.setViewportSize(e,t),this}setHeaderContentRenderers(e,t){return this.renderer.setHeaderContentRenderers(e,t),this}adjust(){this.renderer.adjust()}render(){this.renderer.render()}}},31211:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),o=r(64625),i=n(r(54493)),a=r(49536),l=r(81595);class h extends i.default{constructor(){super("TH"),(0,s.default)(this,"orderViews",new WeakMap),(0,s.default)(this,"sourceRowIndex",0)}obtainOrderView(e){let t;return this.orderViews.has(e)?t=this.orderViews.get(e):(t=new o.SharedOrderView(e,(e=>this.nodesPool.obtain(this.sourceRowIndex,e)),this.nodeType),this.orderViews.set(e,t)),t}render(){const{rowsToRender:e,rowHeaderFunctions:t,rowHeadersCount:r,rows:n,cells:s}=this.table;for(let o=0;o<e;o++){const e=this.table.renderedRowToSource(o),i=n.getRenderedNode(o);this.sourceRowIndex=e;const h=this.obtainOrderView(i),u=s.obtainOrderView(i);h.appendView(u).setSize(r).setOffset(this.table.renderedColumnToSource(0)).start();for(let n=0;n<r;n++){h.render();const r=h.getCurrentNode();r.className="",r.removeAttribute("style"),(0,a.removeAttribute)(r,[new RegExp("aria-(.*)"),new RegExp("role")]),this.table.isAriaEnabled()&&(0,a.setAttribute)(r,[(0,l.A11Y_ROWHEADER)(),(0,l.A11Y_SCOPE_ROW)(),(0,l.A11Y_COLINDEX)(n+1),(0,l.A11Y_TABINDEX)(-1)]),t[n](e,r,n)}h.end()}}}t.default=h},84140:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),o=n(r(54493)),i=r(39874),a=r(12556),l=r(64625),h=r(49536),u=r(81595);let c=!1;class d extends o.default{constructor(e){super("TR",e),(0,s.default)(this,"orderView",void 0),this.orderView=new l.OrderView(e,(e=>this.nodesPool.obtain(e)),this.nodeType)}getRenderedNode(e){return this.orderView.getNode(e)}render(){const{rowsToRender:e}=this.table;!c&&e>1e3&&(c=!0,(0,i.warn)(a.toSingleLine`Performance tip: Handsontable rendered more than 1000 visible rows.\x20
        Consider limiting the number of rendered rows by specifying the table height and/or\x20
        turning off the "renderAllRows" option.`)),this.table.isAriaEnabled()&&(0,h.setAttribute)(this.rootNode,[(0,u.A11Y_ROWGROUP)()]),this.orderView.setSize(e).setOffset(this.table.renderedRowToSource(0)).start();for(let n=0;n<e;n++){this.orderView.render();const e=this.orderView.getCurrentNode(),s=this.table.renderedRowToSource(n);var t,r;if(this.table.isAriaEnabled())(0,h.setAttribute)(e,[(0,u.A11Y_ROW)(),(0,u.A11Y_ROWINDEX)(s+(null!==(t=null===(r=this.table.rowUtils)||void 0===r||null===(r=r.dataAccessObject)||void 0===r?void 0:r.columnHeaders.length)&&void 0!==t?t:0)+1)])}this.orderView.end()}}t.default=d},95593:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.default=class{constructor(e){let{cellRenderer:t}=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};(0,s.default)(this,"rootNode",void 0),(0,s.default)(this,"rootDocument",void 0),(0,s.default)(this,"rowHeaders",null),(0,s.default)(this,"columnHeaders",null),(0,s.default)(this,"colGroup",null),(0,s.default)(this,"rows",null),(0,s.default)(this,"cells",null),(0,s.default)(this,"rowFilter",null),(0,s.default)(this,"columnFilter",null),(0,s.default)(this,"rowUtils",null),(0,s.default)(this,"columnUtils",null),(0,s.default)(this,"rowsToRender",0),(0,s.default)(this,"columnsToRender",0),(0,s.default)(this,"rowHeaderFunctions",[]),(0,s.default)(this,"rowHeadersCount",0),(0,s.default)(this,"columnHeaderFunctions",[]),(0,s.default)(this,"columnHeadersCount",0),(0,s.default)(this,"cellRenderer",void 0),this.rootNode=e,this.rootDocument=this.rootNode.ownerDocument,this.cellRenderer=t}setAxisUtils(e,t){this.rowUtils=e,this.columnUtils=t}setViewportSize(e,t){this.rowsToRender=e,this.columnsToRender=t}setFilters(e,t){this.rowFilter=e,this.columnFilter=t}setHeaderContentRenderers(e,t){this.rowHeaderFunctions=e,this.rowHeadersCount=e.length,this.columnHeaderFunctions=t,this.columnHeadersCount=t.length}setRenderers(){let{rowHeaders:e,columnHeaders:t,colGroup:r,rows:n,cells:s}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};e.setTable(this),t.setTable(this),r.setTable(this),n.setTable(this),s.setTable(this),this.rowHeaders=e,this.columnHeaders=t,this.colGroup=r,this.rows=n,this.cells=s}renderedRowToSource(e){return this.rowFilter.renderedToSource(e)}renderedColumnToSource(e){return this.columnFilter.renderedToSource(e)}isAriaEnabled(){return this.rowUtils.wtSettings.getSetting("ariaTags")}render(){this.colGroup.adjust(),this.columnHeaders.adjust(),this.rows.adjust(),this.rowHeaders.adjust(),this.columnHeaders.render(),this.rows.render(),this.rowHeaders.render(),this.cells.render(),this.columnUtils.calculateWidths(),this.colGroup.render();const{rowsToRender:e,rows:t}=this;for(let r=0;r<e;r++){const e=t.getRenderedNode(r);if(e.firstChild){const t=this.renderedRowToSource(r),n=this.rowUtils.getHeight(t);e.firstChild.style.height=n?n-1+"px":""}}}}},19184:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),o=r(49536);function i(e,t){!function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}(e,t),t.add(e)}function a(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var l=new WeakSet;function h(e){const{wtSettings:t,inlineStartOverlay:r,wtTable:n,wtViewport:s,totalColumns:i,rootWindow:a}=this.dataAccessObject;if(r.mainTableScrollableElement===a){let l=null;if(t.getSetting("rtlMode")){const e=n.TABLE.getBoundingClientRect(),t=this.dataAccessObject.rootWindow.document.documentElement.offsetWidth;l=Math.abs(e.right-t)}else{l=(0,o.offset)(n.wtRootElement).left}const h=Math.abs((0,o.getScrollLeft)(a,a));if(l>h){const t=(0,o.innerWidth)(a);let n=s.getRowHeaderWidth();for(let s=1;s<=i;s++)if(n+=r.sumCellSizes(s-1,s),l+n-h>=t){e=s-2;break}}}return e}function u(e){const{topOverlay:t,wtTable:r,wtViewport:n,totalRows:s,rootWindow:i}=this.dataAccessObject;if(t.mainTableScrollableElement===i){const a=(0,o.offset)(r.wtRootElement),l=(0,o.getScrollTop)(i,i);if(a.top>l){const r=(0,o.innerHeight)(i);let h=n.getColumnHeaderHeight();for(let n=1;n<=s;n++)if(h+=t.sumCellSizes(n-1,n),a.top+h-l>=r){e=n-2;break}}}return e}t.default=class{constructor(e){i(this,l),(0,s.default)(this,"dataAccessObject",void 0),this.dataAccessObject=e}scrollViewport(e,t,r,n,s){const o=this.scrollViewportHorizontally(e.col,r,s),i=this.scrollViewportVertically(e.row,t,n);return o||i}scrollViewportHorizontally(e,t,r){const{drawn:n,totalColumns:s}=this.dataAccessObject;if(!n||!Number.isInteger(e)||e<0||e>s)return!1;const o=void 0===t&&void 0===r,{fixedColumnsStart:i,inlineStartOverlay:a}=this.dataAccessObject;if(o&&e<i)return!1;if(e=this.dataAccessObject.wtSettings.getSetting("onBeforeViewportScrollHorizontally",e),!Number.isInteger(e)||e<0||e>s)return!1;const l=this.getFirstVisibleColumn(),h=this.getLastVisibleColumn();let u=!1;return(o&&(e<l||e>h)||!o)&&(u=a.scrollTo(e,o?e>=this.getLastPartiallyVisibleColumn():t)),u}scrollViewportVertically(e,t,r){const{drawn:n,totalRows:s}=this.dataAccessObject;if(!n||!Number.isInteger(e)||e<0||e>s)return!1;const o=void 0===t&&void 0===r,{fixedRowsBottom:i,fixedRowsTop:a,topOverlay:l}=this.dataAccessObject;if(o&&(e<a||e>s-i-1))return!1;if(e=this.dataAccessObject.wtSettings.getSetting("onBeforeViewportScrollVertically",e),!Number.isInteger(e)||e<0||e>s)return!1;const h=this.getFirstVisibleRow(),u=this.getLastVisibleRow();let c=!1;return(o&&(e<h||e>u)||!o)&&(c=l.scrollTo(e,o?e>=this.getLastPartiallyVisibleRow():r)),c}getFirstVisibleRow(){return this.dataAccessObject.wtTable.getFirstVisibleRow()}getLastVisibleRow(){return a(l,this,u).call(this,this.dataAccessObject.wtTable.getLastVisibleRow())}getFirstPartiallyVisibleRow(){return this.dataAccessObject.wtTable.getFirstPartiallyVisibleRow()}getLastPartiallyVisibleRow(){return a(l,this,u).call(this,this.dataAccessObject.wtTable.getLastPartiallyVisibleRow())}getFirstVisibleColumn(){return this.dataAccessObject.wtTable.getFirstVisibleColumn()}getLastVisibleColumn(){return a(l,this,h).call(this,this.dataAccessObject.wtTable.getLastVisibleColumn())}getFirstPartiallyVisibleColumn(){return this.dataAccessObject.wtTable.getFirstPartiallyVisibleColumn()}getLastPartiallyVisibleColumn(){return a(l,this,h).call(this,this.dataAccessObject.wtTable.getLastPartiallyVisibleColumn())}}},73717:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(49536),s=r(24456),o=r(58460),i=r(1479),a=r(98290);t.default=class{constructor(e,t){t&&(this.eventManager=e.eventManager,this.instance=e,this.wot=e,this.settings=t,this.mouseDown=!1,this.main=null,this.top=null,this.bottom=null,this.start=null,this.end=null,this.topStyle=null,this.bottomStyle=null,this.startStyle=null,this.endStyle=null,this.cornerDefaultStyle=a.CORNER_DEFAULT_STYLE,this.cornerCenterPointOffset=-parseInt(this.cornerDefaultStyle.width,10)/2,this.corner=null,this.cornerStyle=null,this.createBorders(t),this.registerListeners())}registerListeners(){const e=this.wot.rootDocument.body;this.eventManager.addEventListener(e,"mousedown",(()=>this.onMouseDown())),this.eventManager.addEventListener(e,"mouseup",(()=>this.onMouseUp()));for(let e=0,t=this.main.childNodes.length;e<t;e++){const t=this.main.childNodes[e];this.eventManager.addEventListener(t,"mouseenter",(t=>this.onMouseEnter(t,this.main.childNodes[e])))}}onMouseDown(){this.mouseDown=!0}onMouseUp(){this.mouseDown=!1}onMouseEnter(e,t){if(!this.mouseDown||!this.wot.getSetting("hideBorderOnMouseDownOver"))return;e.preventDefault(),(0,s.stopImmediatePropagation)(e);const r=this,n=this.wot.rootDocument.body,o=t.getBoundingClientRect();t.style.display="none",this.eventManager.addEventListener(n,"mousemove",(function e(s){var i;((i=s).clientY<Math.floor(o.top)||i.clientY>Math.ceil(o.top+o.height)||i.clientX<Math.floor(o.left)||i.clientX>Math.ceil(o.left+o.width))&&(r.eventManager.removeEventListener(n,"mousemove",e),t.style.display="block")}))}createBorders(e){const{rootDocument:t}=this.wot;this.main=t.createElement("div");const r=["top","start","bottom","end","corner"];let n=this.main.style;n.position="absolute",n.top=0,n.left=0;for(let s=0;s<5;s++){const o=r[s],i=t.createElement("div");i.className=`wtBorder ${this.settings.className||""}`,this.settings[o]&&this.settings[o].hide&&(i.className+=" hidden"),n=i.style,n.backgroundColor=this.settings[o]&&this.settings[o].color?this.settings[o].color:e.border.color,n.height=this.settings[o]&&this.settings[o].width?`${this.settings[o].width}px`:`${e.border.width}px`,n.width=this.settings[o]&&this.settings[o].width?`${this.settings[o].width}px`:`${e.border.width}px`,this.main.appendChild(i)}this.top=this.main.childNodes[0],this.start=this.main.childNodes[1],this.bottom=this.main.childNodes[2],this.end=this.main.childNodes[3],this.topStyle=this.top.style,this.startStyle=this.start.style,this.bottomStyle=this.bottom.style,this.endStyle=this.end.style,this.corner=this.main.childNodes[4],this.corner.className+=" corner",this.cornerStyle=this.corner.style,this.cornerStyle.width=this.cornerDefaultStyle.width,this.cornerStyle.height=this.cornerDefaultStyle.height,this.cornerStyle.border=[this.cornerDefaultStyle.borderWidth,this.cornerDefaultStyle.borderStyle,this.cornerDefaultStyle.borderColor].join(" "),(0,i.isMobileBrowser)()&&this.instance.getSetting("isDataViewInstance")&&this.createMultipleSelectorHandles(),this.disappear();const{wtTable:s}=this.wot;let o=s.bordersHolder;o||(o=t.createElement("div"),o.className="htBorders",s.bordersHolder=o,s.spreader.appendChild(o)),o.appendChild(this.main)}createMultipleSelectorHandles(){const{rootDocument:e}=this.wot;this.selectionHandles={top:e.createElement("DIV"),topHitArea:e.createElement("DIV"),bottom:e.createElement("DIV"),bottomHitArea:e.createElement("DIV")};this.selectionHandles.top.className="topSelectionHandle topLeftSelectionHandle",this.selectionHandles.topHitArea.className="topSelectionHandle-HitArea topLeftSelectionHandle-HitArea",this.selectionHandles.bottom.className="bottomSelectionHandle bottomRightSelectionHandle",this.selectionHandles.bottomHitArea.className="bottomSelectionHandle-HitArea bottomRightSelectionHandle-HitArea",this.selectionHandles.styles={top:this.selectionHandles.top.style,topHitArea:this.selectionHandles.topHitArea.style,bottom:this.selectionHandles.bottom.style,bottomHitArea:this.selectionHandles.bottomHitArea.style};const t={position:"absolute",height:"40px",width:"40px","border-radius":`${parseInt(40/1.5,10)}px`};(0,o.objectEach)(t,((e,t)=>{this.selectionHandles.styles.bottomHitArea[t]=e,this.selectionHandles.styles.topHitArea[t]=e}));const r={position:"absolute",height:"10px",width:"10px","border-radius":`${parseInt(10/1.5,10)}px`,background:"#F5F5FF",border:"1px solid #4285c8"};(0,o.objectEach)(r,((e,t)=>{this.selectionHandles.styles.bottom[t]=e,this.selectionHandles.styles.top[t]=e})),this.main.appendChild(this.selectionHandles.top),this.main.appendChild(this.selectionHandles.bottom),this.main.appendChild(this.selectionHandles.topHitArea),this.main.appendChild(this.selectionHandles.bottomHitArea)}isPartRange(e,t){const r=this.wot.selectionManager.getAreaSelection();return!(!r.cellRange||e===r.cellRange.to.row&&t===r.cellRange.to.col)}updateMultipleSelectionHandlesPosition(e,t,r,n,s,o){const i=this.wot.wtSettings.getSetting("rtlMode")?"right":"left",{top:a,topHitArea:l,bottom:h,bottomHitArea:u}=this.selectionHandles.styles,c=parseInt(a.borderWidth,10),d=parseInt(a.width,10),p=parseInt(l.width,10),g=this.wot.wtTable.getWidth(),f=this.wot.wtTable.getHeight();a.top=`${parseInt(r-d-1,10)}px`,a[i]=`${parseInt(n-d-1,10)}px`,l.top=`${parseInt(r-p/4*3,10)}px`,l[i]=`${parseInt(n-p/4*3,10)}px`;const m=Math.min(parseInt(n+s,10),g-d-2*c),E=Math.min(parseInt(n+s-p/4,10),g-p-2*c);h[i]=`${m}px`,u[i]=`${E}px`;const y=Math.min(parseInt(r+o,10),f-d-2*c),w=Math.min(parseInt(r+o-p/4,10),f-p-2*c);h.top=`${y}px`,u.top=`${w}px`,this.settings.border.cornerVisible&&this.settings.border.cornerVisible()?(a.display="block",l.display="block",this.isPartRange(e,t)?(h.display="none",u.display="none"):(h.display="block",u.display="block")):(a.display="none",h.display="none",l.display="none",u.display="none"),e===this.wot.wtSettings.getSetting("fixedRowsTop")||t===this.wot.wtSettings.getSetting("fixedColumnsStart")?(a.zIndex="9999",l.zIndex="9999"):(a.zIndex="",l.zIndex="")}appear(e){if(this.disabled)return;const{wtTable:t,rootDocument:r,rootWindow:s}=this.wot;let o,a,l,h,u,c;const d=t.getRenderedRowsCount();for(let r=0;r<d;r+=1){const n=t.rowFilter.renderedToSource(r);if(n>=e[0]&&n<=e[2]){o=n,u=e[0];break}}for(let r=d-1;r>=0;r-=1){const n=t.rowFilter.renderedToSource(r);if(n>=e[0]&&n<=e[2]){a=n;break}}const p=t.getRenderedColumnsCount();for(let r=0;r<p;r+=1){const n=t.columnFilter.renderedToSource(r);if(n>=e[1]&&n<=e[3]){l=n,c=e[1];break}}for(let r=p-1;r>=0;r-=1){const n=t.columnFilter.renderedToSource(r);if(n>=e[1]&&n<=e[3]){h=n;break}}if(void 0===o||void 0===l)return void this.disappear();let g=t.getCell(this.wot.createCellCoords(o,l));const f=o!==a||l!==h,m=f?t.getCell(this.wot.createCellCoords(a,h)):g,E=(0,n.offset)(g),y=f?(0,n.offset)(m):E,w=(0,n.offset)(t.TABLE),C=(0,n.outerWidth)(t.TABLE),R=E.top,v=E.left,S=this.wot.wtSettings.getSetting("rtlMode");let T=0,N=0;if(S){const e=(0,n.outerWidth)(g),t=s.innerWidth-w.left-C;N=v+e-y.left,T=s.innerWidth-v-e-t-1}else N=y.left+(0,n.outerWidth)(m)-v,T=v-w.left-1;if(this.isEntireColumnSelected(o,a)){const e=this.getDimensionsFromHeader("columns",l,h,u,w);let t=null;e&&([t,T,N]=e),t&&(g=t)}let _=R-w.top-1,M=y.top+(0,n.outerHeight)(m)-R;if(this.isEntireRowSelected(l,h)){const e=this.getDimensionsFromHeader("rows",o,a,c,w);let t=null;e&&([t,_,M]=e),t&&(g=t)}const A=(0,n.getComputedStyle)(g,s);parseInt(A.borderTopWidth,10)>0&&(_+=1,M=M>0?M-1:0),parseInt(A[S?"borderRightWidth":"borderLeftWidth"],10)>0&&(T+=1,N=N>0?N-1:0);const b=S?"right":"left";this.topStyle.top=`${_}px`,this.topStyle[b]=`${T}px`,this.topStyle.width=`${N}px`,this.topStyle.display="block",this.startStyle.top=`${_}px`,this.startStyle[b]=`${T}px`,this.startStyle.height=`${M}px`,this.startStyle.display="block";const I=Math.floor(this.settings.border.width/2);this.bottomStyle.top=_+M-I+"px",this.bottomStyle[b]=`${T}px`,this.bottomStyle.width=`${N}px`,this.bottomStyle.display="block",this.endStyle.top=`${_}px`,this.endStyle[b]=T+N-I+"px",this.endStyle.height=`${M+1}px`,this.endStyle.display="block";let O=this.settings.border.cornerVisible;O="function"==typeof O?O(this.settings.layerLevel):O;const x=this.wot.getSetting("onModifyGetCellCoords",a,h);let[P,L]=[a,h];if(x&&Array.isArray(x)&&([,,P,L]=x),(0,i.isMobileBrowser)()||!O||this.isPartRange(P,L))this.cornerStyle.display="none";else{this.cornerStyle.top=_+M+this.cornerCenterPointOffset-1+"px",this.cornerStyle[b]=T+N+this.cornerCenterPointOffset-1+"px",this.cornerStyle.borderRightWidth=this.cornerDefaultStyle.borderWidth,this.cornerStyle.width=this.cornerDefaultStyle.width,this.cornerStyle.display="none";let e=(0,n.getTrimmingContainer)(t.TABLE);const o=e===s;o&&(e=r.documentElement);const i=parseInt(this.cornerDefaultStyle.width,10)/2,l=parseInt(this.cornerDefaultStyle.height,10)/2;if(h===this.wot.getSetting("totalColumns")-1){const t=o?m.getBoundingClientRect().left:m.offsetLeft;let r=!1,s=0;S?(s=t-parseInt(this.cornerDefaultStyle.width,10)/2,r=s<0):(s=t+(0,n.outerWidth)(m)+parseInt(this.cornerDefaultStyle.width,10)/2,r=s>=(0,n.innerWidth)(e)),r&&(this.cornerStyle[b]=`${Math.floor(T+N+this.cornerCenterPointOffset-i)}px`,this.cornerStyle[S?"borderLeftWidth":"borderRightWidth"]=0)}if(a===this.wot.getSetting("totalRows")-1){(o?m.getBoundingClientRect().top:m.offsetTop)+(0,n.outerHeight)(m)+parseInt(this.cornerDefaultStyle.height,10)/2>=(0,n.innerHeight)(e)&&(this.cornerStyle.top=`${Math.floor(_+M+this.cornerCenterPointOffset-l)}px`,this.cornerStyle.borderBottomWidth=0)}this.cornerStyle.display="block"}(0,i.isMobileBrowser)()&&this.instance.getSetting("isDataViewInstance")&&this.updateMultipleSelectionHandlesPosition(a,h,_,T,N,M)}isEntireColumnSelected(e,t){return e===this.wot.wtTable.getFirstRenderedRow()&&t===this.wot.wtTable.getLastRenderedRow()}isEntireRowSelected(e,t){return e===this.wot.wtTable.getFirstRenderedColumn()&&t===this.wot.wtTable.getLastRenderedColumn()}getDimensionsFromHeader(e,t,r,s,o){const{wtTable:i}=this.wot,a=i.wtRootElement.parentNode;let l=null,h=null,u=null,c=null,d=null,p=null,g=null,f=null;switch(e){case"rows":l=function(){return i.getRowHeader(...arguments)},h=function(){return(0,n.outerHeight)(...arguments)},u="ht__selection--rows",p="top";break;case"columns":l=function(){return i.getColumnHeader(...arguments)},h=function(){return(0,n.outerWidth)(...arguments)},u="ht__selection--columns",p="left"}if(a.classList.contains(u)){const e=this.wot.getSetting("columnHeaders").length;if(g=l(t,e-s),f=l(r,e-s),!g||!f)return!1;const i=(0,n.offset)(g),a=(0,n.offset)(f);return g&&f&&(c=i[p]-o[p]-1,d=a[p]+h(f)-i[p]),[g,c,d]}return!1}changeBorderStyle(e,t){const r=this[e].style,s=t[e];!s||s.hide?(0,n.addClass)(this[e],"hidden"):((0,n.hasClass)(this[e],"hidden")&&(0,n.removeClass)(this[e],"hidden"),r.backgroundColor=s.color,"top"!==e&&"bottom"!==e||(r.height=`${s.width}px`),"start"!==e&&"end"!==e||(r.width=`${s.width}px`))}changeBorderToDefaultStyle(e){const t=1,r="#000",n=this[e].style;n.backgroundColor=r,n.width=`${t}px`,n.height=`${t}px`}toggleHiddenClass(e,t){this.changeBorderToDefaultStyle(e),t?(0,n.addClass)(this[e],"hidden"):(0,n.removeClass)(this[e],"hidden")}disappear(){this.topStyle.display="none",this.bottomStyle.display="none",this.startStyle.display="none",this.endStyle.display="none",this.cornerStyle.display="none",(0,i.isMobileBrowser)()&&this.instance.getSetting("isDataViewInstance")&&(this.selectionHandles.styles.top.display="none",this.selectionHandles.styles.topHitArea.display="none",this.selectionHandles.styles.bottom.display="none",this.selectionHandles.styles.bottomHitArea.display="none")}destroy(){this.eventManager.destroyWithOwnEventsOnly(),this.main.parentNode.removeChild(this.main)}}},98290:(e,t)=>{"use strict";t.__esModule=!0;t.CORNER_DEFAULT_STYLE=Object.freeze({width:"6px",height:"6px",borderWidth:"1px",borderStyle:"solid",borderColor:"#FFF"})},74361:(e,t)=>{"use strict";t.__esModule=!0;t.ACTIVE_HEADER_TYPE="active-header",t.HEADER_TYPE="header",t.AREA_TYPE="area",t.FOCUS_TYPE="focus",t.FILL_TYPE="fill",t.ROW_TYPE="row",t.COLUMN_TYPE="column",t.CUSTOM_SELECTION_TYPE="custom-selection"},37364:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s={SelectionManager:!0,Selection:!0},o=n(r(8858));t.Selection=o.default;var i=r(74361);Object.keys(i).forEach((function(e){"default"!==e&&"__esModule"!==e&&(Object.prototype.hasOwnProperty.call(s,e)||e in t&&t[e]===i[e]||(t[e]=i[e]))}));var a=r(98290);Object.keys(a).forEach((function(e){"default"!==e&&"__esModule"!==e&&(Object.prototype.hasOwnProperty.call(s,e)||e in t&&t[e]===a[e]||(t[e]=a[e]))}));var l=r(34263);t.SelectionManager=l.SelectionManager},34263:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724),r(25352);var s=r(49536),o=r(76842),i=n(r(73717));function a(e,t,r){l(e,t),t.set(e,r)}function l(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function h(e,t){return e.get(c(e,t))}function u(e,t,r){return e.set(c(e,t),r),r}function c(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var d=new WeakMap,p=new WeakMap,g=new WeakMap,f=new WeakMap,m=new WeakMap,E=new WeakMap,y=new WeakSet;function w(){const e=h(f,this).get(h(d,this)),t=h(d,this).wtSettings.getSetting("onBeforeRemoveCellClassNames");if(Array.isArray(t))for(let r=0;r<t.length;r++)e.add(t[r]);e.forEach((e=>{var t,r;const n=h(d,this).wtTable.TABLE.querySelectorAll(`.${e}`);let o=[];Array.isArray(null===(t=h(p,this).options)||void 0===t?void 0:t.cellAttributes)&&(o=h(p,this).options.cellAttributes.map((e=>e[0]))),Array.isArray(null===(r=h(p,this).options)||void 0===r?void 0:r.headerAttributes)&&(o=[...o,...h(p,this).options.headerAttributes.map((e=>e[0]))]);for(let t=0,r=n.length;t<r;t++)(0,s.removeClass)(n[t],e),(0,s.removeAttribute)(n[t],o)})),e.clear()}t.SelectionManager=class{constructor(e){var t,r;l(t=this,r=y),r.add(t),a(this,d,void 0),a(this,p,void 0),a(this,g,new o.SelectionScanner),a(this,f,new WeakMap),a(this,m,new WeakSet),a(this,E,new Map),u(p,this,e)}setActiveOverlay(e){return u(d,this,e),h(g,this).setActiveOverlay(h(d,this)),h(f,this).has(h(d,this))||h(f,this).set(h(d,this),new Set),this}getFocusSelection(){return null!==h(p,this)?h(p,this).getFocus():null}getAreaSelection(){return null!==h(p,this)?h(p,this).createLayeredArea():null}getBorderInstance(e){if(!e.settings.border)return null;if(h(E,this).has(e)){const t=h(E,this).get(e);if(t.has(h(d,this)))return t.get(h(d,this));const r=new i.default(h(d,this),e.settings);return t.set(h(d,this),r),r}const t=new i.default(h(d,this),e.settings);return h(E,this).set(e,new Map([[h(d,this),t]])),t}getBorderInstances(e){var t,r;return Array.from(null!==(t=null===(r=h(E,this).get(e))||void 0===r?void 0:r.values())&&void 0!==t?t:[])}destroyBorders(e){h(E,this).get(e).forEach((e=>e.destroy())),h(E,this).delete(e)}render(e){if(null===h(p,this))return;e&&c(y,this,w).call(this);const t=Array.from(h(p,this)),r=new Map,n=new Map;for(let e=0;e<t.length;e++){const s=t[e],{className:o,headerAttributes:i,createLayers:a,selectionType:l}=s.settings;h(m,this).has(s)||(h(m,this).add(s),s.addLocalHook("destroy",(()=>this.destroyBorders(s))));const u=this.getBorderInstance(s);if(s.isEmpty()){null==u||u.disappear();continue}if(o){h(g,this).setActiveSelection(s).scan().forEach((e=>{if(r.has(e)){const t=r.get(e);t.has(o)&&!0===a?t.set(o,t.get(o)+1):t.set(o,1)}else r.set(e,new Map([[o,1]]));i&&(n.has(e)||n.set(e,[]),"TH"===e.nodeName&&n.get(e).push(...i))}))}const c=s.getCorners();h(d,this).getSetting("onBeforeDrawBorders",c,l),null==u||u.appear(c)}r.forEach(((e,t)=>{var r;const n=Array.from(e).map((e=>{let[t,r]=e;return 1===r?t:[t,...Array.from({length:r-1},((e,r)=>`${t}-${r+1}`))]})).flat();n.forEach((e=>h(f,this).get(h(d,this)).add(e))),(0,s.addClass)(t,n),"TD"===t.nodeName&&Array.isArray(null===(r=h(p,this).options)||void 0===r?void 0:r.cellAttributes)&&(0,s.setAttribute)(t,h(p,this).options.cellAttributes)})),Array.from(n.keys()).forEach((e=>{(0,s.setAttribute)(e,[...n.get(e)])}))}}},76842:(e,t,r)=>{"use strict";t.__esModule=!0,r(67834);var n=r(49536);function s(e,t,r){o(e,t),t.set(e,r)}function o(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function i(e,t){return e.get(l(e,t))}function a(e,t,r){return e.set(l(e,t),r),r}function l(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var h=new WeakMap,u=new WeakMap,c=new WeakSet;function d(e){const{wtTable:t}=i(u,this),r=t.getRenderedRowsCount(),n=t.getRenderedColumnsCount();for(let s=0;s<r;s+=1){const r=t.rowFilter.renderedToSource(s);for(let s=0;s<n;s+=1)e(r,t.columnFilter.renderedToSource(s))}}t.SelectionScanner=class{constructor(){var e,t;o(e=this,t=c),t.add(e),s(this,h,void 0),s(this,u,void 0)}setActiveOverlay(e){return a(u,this,e),this}setActiveSelection(e){return a(h,this,e),this}scan(){const e=i(h,this).settings.selectionType,t=new Set;return"active-header"===e?(this.scanColumnsInHeadersRange((e=>t.add(e))),this.scanRowsInHeadersRange((e=>t.add(e)))):"area"===e?this.scanCellsRange((e=>t.add(e))):"focus"===e?(this.scanColumnsInHeadersRange((e=>t.add(e))),this.scanRowsInHeadersRange((e=>t.add(e))),this.scanCellsRange((e=>t.add(e)))):"fill"===e?this.scanCellsRange((e=>t.add(e))):"header"===e?(this.scanColumnsInHeadersRange((e=>t.add(e))),this.scanRowsInHeadersRange((e=>t.add(e)))):"row"===e?(this.scanRowsInHeadersRange((e=>t.add(e))),this.scanRowsInCellsRange((e=>t.add(e)))):"column"===e&&(this.scanColumnsInHeadersRange((e=>t.add(e))),this.scanColumnsInCellsRange((e=>t.add(e)))),t}scanColumnsInHeadersRange(e){const[t,r,n,s]=i(h,this).getCorners(),{wtTable:o}=i(u,this),a=o.getRenderedColumnsCount(),l=o.getColumnHeadersCount();let c=0;for(let d=-o.getRowHeadersCount();d<a;d++){const a=o.columnFilter.renderedToSource(d);if(!(a<r||a>s)){for(let d=-l;d<0;d++){if(d<t||d>n)continue;const p=d+l;let g=o.getColumnHeader(a,p);const f=i(u,this).getSetting("onBeforeHighlightingColumnHeader",a,p,{selectionType:i(h,this).settings.selectionType,columnCursor:c,selectionWidth:s-r+1});null!==f&&(f!==a&&(g=o.getColumnHeader(f,p)),e(g))}c+=1}}}scanRowsInHeadersRange(e){const[t,r,n,s]=i(h,this).getCorners(),{wtTable:o}=i(u,this),a=o.getRenderedRowsCount(),l=o.getRowHeadersCount();let c=0;for(let d=-o.getColumnHeadersCount();d<a;d++){const a=o.rowFilter.renderedToSource(d);if(!(a<t||a>n)){for(let d=-l;d<0;d++){if(d<r||d>s)continue;const p=d+l;let g=o.getRowHeader(a,p);const f=i(u,this).getSetting("onBeforeHighlightingRowHeader",a,p,{selectionType:i(h,this).settings.selectionType,rowCursor:c,selectionHeight:n-t+1});null!==f&&(f!==a&&(g=o.getRowHeader(f,p)),e(g))}c+=1}}}scanCellsRange(e){const[t,r,s,o]=i(h,this).getCorners(),{wtTable:a}=i(u,this);l(c,this,d).call(this,((l,c)=>{if(l>=t&&l<=s&&c>=r&&c<=o){const t=a.getCell(i(u,this).createCellCoords(l,c)),r=i(u,this).getSetting("onAfterDrawSelection",l,c,i(h,this).settings.layerLevel);"string"==typeof r&&(0,n.addClass)(t,r),e(t)}}))}scanRowsInCellsRange(e){const[t,,r]=i(h,this).getCorners(),{wtTable:n}=i(u,this);l(c,this,d).call(this,((s,o)=>{if(s>=t&&s<=r){const t=n.getCell(i(u,this).createCellCoords(s,o));e(t)}}))}scanColumnsInCellsRange(e){const[,t,,r]=i(h,this).getCorners(),{wtTable:n}=i(u,this);l(c,this,d).call(this,((s,o)=>{if(o>=t&&o<=r){const t=n.getCell(i(u,this).createCellCoords(s,o));e(t)}}))}}},8858:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=r(58460),o=n(r(48499));class i{constructor(e,t){this.settings=e,this.cellRange=t||null}isEmpty(){return null===this.cellRange}add(e){return this.isEmpty()?this.cellRange=this.settings.createCellRange(e):this.cellRange.expand(e),this}replace(e,t){if(!this.isEmpty()){if(this.cellRange.from.isEqual(e))return this.cellRange.from=t,!0;if(this.cellRange.to.isEqual(e))return this.cellRange.to=t,!0}return!1}clear(){return this.cellRange=null,this}getCorners(){const e=this.cellRange.getOuterTopStartCorner(),t=this.cellRange.getOuterBottomEndCorner();return[e.row,e.col,t.row,t.col]}destroy(){this.runLocalHooks("destroy")}}(0,s.mixin)(i,o.default);t.default=i},20068:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),o=r(49536),i=r(58460);t.default=class{constructor(e){(0,s.default)(this,"settings",{}),(0,s.default)(this,"defaults",Object.freeze(this.getDefaults())),(0,i.objectEach)(this.defaults,((t,r)=>{if(void 0!==e[r])this.settings[r]=e[r];else{if(void 0===t)throw new Error(`A required setting "${r}" was not provided`);this.settings[r]=t}}))}getDefaults(){return{facade:void 0,table:void 0,isDataViewInstance:!0,externalRowCalculator:!1,stretchH:"none",currentRowClassName:null,currentColumnClassName:null,preventOverflow:()=>!1,preventWheel:!1,data:void 0,freezeOverlays:!1,fixedColumnsStart:0,fixedRowsTop:0,fixedRowsBottom:0,shouldRenderInlineStartOverlay:()=>this.getSetting("fixedColumnsStart")>0||this.getSetting("rowHeaders").length>0,shouldRenderTopOverlay:()=>this.getSetting("fixedRowsTop")>0||this.getSetting("columnHeaders").length>0,shouldRenderBottomOverlay:()=>this.getSetting("fixedRowsBottom")>0,minSpareRows:0,rowHeaders:()=>[],columnHeaders:()=>[],totalRows:void 0,totalColumns:void 0,cellRenderer:(e,t,r)=>{const n=this.getSetting("data",e,t);(0,o.fastInnerText)(r,null==n?"":n)},columnWidth(){},rowHeight(){},defaultRowHeight:23,defaultColumnWidth:50,selections:null,hideBorderOnMouseDownOver:!1,viewportRowCalculatorOverride:null,viewportColumnCalculatorOverride:null,onCellMouseDown:null,onCellContextMenu:null,onCellMouseOver:null,onCellMouseOut:null,onCellMouseUp:null,onCellDblClick:null,onCellCornerMouseDown:null,onCellCornerDblClick:null,beforeDraw:null,onDraw:null,onBeforeRemoveCellClassNames:null,onAfterDrawSelection:null,onBeforeDrawBorders:null,onBeforeViewportScrollHorizontally:e=>e,onBeforeViewportScrollVertically:e=>e,onScrollHorizontally:null,onScrollVertically:null,onBeforeTouchScroll:null,onAfterMomentumScroll:null,onBeforeStretchingColumnWidth:e=>e,onModifyRowHeaderWidth:null,onModifyGetCellCoords:null,onBeforeHighlightingRowHeader:e=>e,onBeforeHighlightingColumnHeader:e=>e,onWindowResize:null,onContainerElementResize:null,renderAllColumns:!1,renderAllRows:!1,groups:!1,rowHeaderWidth:null,columnHeaderHeight:null,headerClassName:null,rtlMode:!1,ariaTags:!0}}update(e,t){return void 0===t?(0,i.objectEach)(e,((e,t)=>{this.settings[t]=e})):this.settings[e]=t,this}getSetting(e,t,r,n,s){return"function"==typeof this.settings[e]?this.settings[e](t,r,n,s):void 0!==t&&Array.isArray(this.settings[e])?this.settings[e][t]:this.settings[e]}getSettingPure(e){return this.settings[e]}has(e){return!!this.settings[e]}}},89817:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724);var s=n(r(85707)),o=r(49536),i=r(25735),a=n(r(86296)),l=n(r(81956)),h=r(7961),u=n(r(40205)),c=n(r(58299)),d=r(68574),p=r(81595);t.default=class{constructor(e,t,r,n,i){(0,s.default)(this,"wtSettings",null),(0,s.default)(this,"domBindings",void 0),(0,s.default)(this,"TBODY",null),(0,s.default)(this,"THEAD",null),(0,s.default)(this,"COLGROUP",null),(0,s.default)(this,"hasTableHeight",!0),(0,s.default)(this,"hasTableWidth",!0),(0,s.default)(this,"isTableVisible",!1),(0,s.default)(this,"tableOffset",0),(0,s.default)(this,"holderOffset",0),this.domBindings=r,this.isMaster="master"===i,this.name=i,this.dataAccessObject=e,this.facadeGetter=t,this.wtSettings=n,this.instance=this.dataAccessObject.wot,this.wot=this.dataAccessObject.wot,this.TABLE=r.rootTable,(0,o.removeTextNodes)(this.TABLE),this.spreader=this.createSpreader(this.TABLE),this.hider=this.createHider(this.spreader),this.holder=this.createHolder(this.hider),this.wtRootElement=this.holder.parentNode,this.isMaster&&this.alignOverlaysWithTrimmingContainer(),this.fixTableDomTree(),this.rowFilter=null,this.columnFilter=null,this.correctHeaderWidth=!1;const a=this.wtSettings.getSettingPure("rowHeaderWidth");this.wtSettings.update("rowHeaderWidth",(()=>this._modifyRowHeaderWidth(a))),this.rowUtils=new c.default(this.dataAccessObject,this.wtSettings),this.columnUtils=new u.default(this.dataAccessObject,this.wtSettings),this.tableRenderer=new h.Renderer({TABLE:this.TABLE,THEAD:this.THEAD,COLGROUP:this.COLGROUP,TBODY:this.TBODY,rowUtils:this.rowUtils,columnUtils:this.columnUtils,cellRenderer:this.wtSettings.getSettingPure("cellRenderer")})}is(e){return this.name===e}fixTableDomTree(){const e=this.domBindings.rootDocument;this.TBODY=this.TABLE.querySelector("tbody"),this.TBODY||(this.TBODY=e.createElement("tbody"),this.TABLE.appendChild(this.TBODY)),this.THEAD=this.TABLE.querySelector("thead"),this.THEAD||(this.THEAD=e.createElement("thead"),this.TABLE.insertBefore(this.THEAD,this.TBODY)),this.COLGROUP=this.TABLE.querySelector("colgroup"),this.COLGROUP||(this.COLGROUP=e.createElement("colgroup"),this.TABLE.insertBefore(this.COLGROUP,this.THEAD))}createSpreader(e){const t=e.parentNode;let r;return t&&t.nodeType===Node.ELEMENT_NODE&&(0,o.hasClass)(t,"wtHolder")||(r=this.domBindings.rootDocument.createElement("div"),r.className="wtSpreader",t&&t.insertBefore(r,e),r.appendChild(e)),r.style.position="relative",this.wtSettings.getSetting("ariaTags")&&(0,o.setAttribute)(r,[(0,p.A11Y_PRESENTATION)()]),r}createHider(e){const t=e.parentNode;let r;return t&&t.nodeType===Node.ELEMENT_NODE&&(0,o.hasClass)(t,"wtHolder")||(r=this.domBindings.rootDocument.createElement("div"),r.className="wtHider",t&&t.insertBefore(r,e),r.appendChild(e)),this.wtSettings.getSetting("ariaTags")&&(0,o.setAttribute)(r,[(0,p.A11Y_PRESENTATION)()]),r}createHolder(e){const t=e.parentNode;let r;return t&&t.nodeType===Node.ELEMENT_NODE&&(0,o.hasClass)(t,"wtHolder")||(r=this.domBindings.rootDocument.createElement("div"),r.style.position="relative",r.className="wtHolder",t&&t.insertBefore(r,e),this.isMaster&&(r.parentNode.className+="ht_master handsontable",r.parentNode.setAttribute("dir",this.wtSettings.getSettingPure("rtlMode")?"rtl":"ltr"),this.wtSettings.getSetting("ariaTags")&&(0,o.setAttribute)(r.parentNode,[(0,p.A11Y_PRESENTATION)()])),r.appendChild(e)),this.wtSettings.getSetting("ariaTags")&&(0,o.setAttribute)(r,[(0,p.A11Y_PRESENTATION)()]),r}draw(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];const{wtSettings:t}=this,{wtOverlays:r,wtViewport:n}=this.dataAccessObject,s=t.getSetting("totalRows"),i=t.getSetting("totalColumns"),h=t.getSetting("rowHeaders"),u=h.length,c=t.getSetting("columnHeaders"),p=c.length;let g=!1,f=e;if(this.isMaster&&(this.holderOffset=(0,o.offset)(this.holder),f=n.createRenderCalculators(f),u&&!t.getSetting("fixedColumnsStart"))){const e=r.inlineStartOverlay.getScrollPosition(),t=this.correctHeaderWidth;this.correctHeaderWidth=0!==e,t!==this.correctHeaderWidth&&(f=!1)}if(this.isMaster&&(g=r.updateStateOfRendering()),f)this.isMaster&&(n.createVisibleCalculators(),n.createPartiallyVisibleCalculators()),r&&r.refresh(!0);else{this.isMaster?this.tableOffset=(0,o.offset)(this.TABLE):this.tableOffset=this.dataAccessObject.parentTableOffset;const e=s>0?this.getFirstRenderedRow():0,t=i>0?this.getFirstRenderedColumn():0;this.rowFilter=new l.default(e,s,p),this.columnFilter=new a.default(t,i,u);let r=!0;if(this.isMaster){this.alignOverlaysWithTrimmingContainer();const e={};this.wtSettings.getSetting("beforeDraw",!0,e),r=!0!==e.skipRender}if(r){let e;if(this.tableRenderer.setHeaderContentRenderers(h,c),(this.is(d.CLONE_BOTTOM)||this.is(d.CLONE_BOTTOM_INLINE_START_CORNER))&&this.tableRenderer.setHeaderContentRenderers(h,[]),this.resetOversizedRows(),this.tableRenderer.setViewportSize(this.getRenderedRowsCount(),this.getRenderedColumnsCount()).setFilters(this.rowFilter,this.columnFilter).render(),this.isMaster&&(e=this.dataAccessObject.workspaceWidth,this.dataAccessObject.wtViewport.containerWidth=null,this.markOversizedColumnHeaders()),this.adjustColumnHeaderHeights(),(this.isMaster||this.is(d.CLONE_BOTTOM))&&this.markOversizedRows(),this.isMaster){this.dataAccessObject.wtViewport.createVisibleCalculators(),this.dataAccessObject.wtViewport.createPartiallyVisibleCalculators(),this.dataAccessObject.wtOverlays.refresh(!1),this.dataAccessObject.wtOverlays.applyToDOM();const t=(0,o.outerWidth)(this.hider),r=(0,o.outerWidth)(this.TABLE);0!==t&&r!==t&&(this.columnUtils.calculateWidths(),this.tableRenderer.renderer.colGroup.render()),e!==this.dataAccessObject.wtViewport.getWorkspaceWidth()&&(this.dataAccessObject.wtViewport.containerWidth=null,this.columnUtils.calculateWidths(),this.tableRenderer.renderer.colGroup.render()),this.wtSettings.getSetting("onDraw",!0)}else this.is(d.CLONE_BOTTOM)&&this.dataAccessObject.cloneSource.wtOverlays.adjustElementsSize()}}let m=!1;return this.isMaster&&(m=r.topOverlay.resetFixedPosition(),r.bottomOverlay.clone&&(m=r.bottomOverlay.resetFixedPosition()||m),m=r.inlineStartOverlay.resetFixedPosition()||m,r.topInlineStartCornerOverlay&&r.topInlineStartCornerOverlay.resetFixedPosition(),r.bottomInlineStartCornerOverlay&&r.bottomInlineStartCornerOverlay.clone&&r.bottomInlineStartCornerOverlay.resetFixedPosition()),m?(r.refreshAll(),r.adjustElementsSize()):this.dataAccessObject.selectionManager.setActiveOverlay(this.facadeGetter()).render(f),g&&r.syncScrollWithMaster(),this.dataAccessObject.drawn=!0,this}markIfOversizedColumnHeader(e){const t=this.columnFilter.renderedToSource(e);let r=this.wtSettings.getSetting("columnHeaders").length;const n=this.wtSettings.getSetting("defaultRowHeight");let s,i,a;const l=this.wtSettings.getSetting("columnHeaderHeight")||[];for(;r;)r-=1,s=this.getColumnHeaderHeight(r),i=this.getColumnHeader(t,r),i&&(a=(0,o.innerHeight)(i),(!s&&n<a||s<a)&&(this.dataAccessObject.wtViewport.oversizedColumnHeaders[r]=a),Array.isArray(l)?null!==l[r]&&void 0!==l[r]&&(this.dataAccessObject.wtViewport.oversizedColumnHeaders[r]=l[r]):isNaN(l)||(this.dataAccessObject.wtViewport.oversizedColumnHeaders[r]=l),this.dataAccessObject.wtViewport.oversizedColumnHeaders[r]<(l[r]||l)&&(this.dataAccessObject.wtViewport.oversizedColumnHeaders[r]=l[r]||l))}adjustColumnHeaderHeights(){const{wtSettings:e}=this,t=this.THEAD.childNodes,r=this.dataAccessObject.wtViewport.oversizedColumnHeaders;for(let n=0,s=e.getSetting("columnHeaders").length;n<s;n++)if(r[n]){if(!t[n]||0===t[n].childNodes.length)return;t[n].childNodes[0].style.height=`${r[n]}px`}}resetOversizedRows(){const{wtSettings:e}=this,{wtViewport:t}=this.dataAccessObject;if((this.isMaster||this.is(d.CLONE_BOTTOM))&&!e.getSetting("externalRowCalculator")){const e=this.getRenderedRowsCount();for(let r=0;r<e;r++){const e=this.rowFilter.renderedToSource(r);t.oversizedRows&&t.oversizedRows[e]&&(t.oversizedRows[e]=void 0)}}}getCell(e){let t=e.row,r=e.col;const n=this.wtSettings.getSetting("onModifyGetCellCoords",t,r);if(n&&Array.isArray(n)&&([t,r]=n),this.isRowBeforeRenderedRows(t))return-1;if(this.isRowAfterRenderedRows(t))return-2;if(this.isColumnBeforeRenderedColumns(r))return-3;if(this.isColumnAfterRenderedColumns(r))return-4;const s=this.getRow(t);if(!s&&t>=0)throw new Error("TR was expected to be rendered but is not");const o=s.childNodes[this.columnFilter.sourceColumnToVisibleRowHeadedColumn(r)];if(!o&&r>=0)throw new Error("TD or TH was expected to be rendered but is not");return o}getRow(e){let t=null,r=null;var n,s;e<0?(t=null===(n=this.rowFilter)||void 0===n?void 0:n.sourceRowToVisibleColHeadedRow(e),r=this.THEAD):(t=null===(s=this.rowFilter)||void 0===s?void 0:s.sourceToRendered(e),r=this.TBODY);return void 0!==t&&void 0!==r&&(!(r.childNodes.length<t+1)&&r.childNodes[t])}getColumnHeader(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;const r=this.THEAD.childNodes[t];return null==r?void 0:r.childNodes[this.columnFilter.sourceColumnToVisibleRowHeadedColumn(e)]}getColumnHeaders(e){const t=[],r=this.columnFilter.sourceColumnToVisibleRowHeadedColumn(e);return this.THEAD.childNodes.forEach((e=>{const n=e.childNodes[r];n&&t.push(n)})),t}getRowHeader(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;if(t>=this.wtSettings.getSetting("rowHeaders").length)return;const r=this.rowFilter.sourceToRendered(e),n=r<0?this.rowFilter.sourceRowToVisibleColHeadedRow(e):r,s=(r<0?this.THEAD:this.TBODY).childNodes[n];return null==s?void 0:s.childNodes[t]}getRowHeaders(e){const t=[],r=this.wtSettings.getSetting("rowHeaders").length;for(let n=0;n<r;n++){const r=this.TBODY.childNodes[this.rowFilter.sourceToRendered(e)],s=null==r?void 0:r.childNodes[n];s&&t.push(s)}return t}getCoords(e){let t=e;if("TD"!==t.nodeName&&"TH"!==t.nodeName&&(t=(0,o.closest)(t,["TD","TH"])),null===t)return null;const r=t.parentNode,n=r.parentNode;let s=(0,o.index)(r),i=t.cellIndex;if((0,o.overlayContainsElement)(d.CLONE_TOP_INLINE_START_CORNER,t,this.wtRootElement)||(0,o.overlayContainsElement)(d.CLONE_TOP,t,this.wtRootElement))"THEAD"===n.nodeName&&(s-=n.childNodes.length);else if((0,o.overlayContainsElement)(d.CLONE_BOTTOM_INLINE_START_CORNER,t,this.wtRootElement)||(0,o.overlayContainsElement)(d.CLONE_BOTTOM,t,this.wtRootElement)){s=this.wtSettings.getSetting("totalRows")-n.childNodes.length+s}else s=n===this.THEAD?this.rowFilter.visibleColHeadedRowToSourceRow(s):this.rowFilter.renderedToSource(s);return i=(0,o.overlayContainsElement)(d.CLONE_TOP_INLINE_START_CORNER,t,this.wtRootElement)||(0,o.overlayContainsElement)(d.CLONE_INLINE_START,t,this.wtRootElement)||(0,o.overlayContainsElement)(d.CLONE_BOTTOM_INLINE_START_CORNER,t,this.wtRootElement)?this.columnFilter.offsettedTH(i):this.columnFilter.visibleRowHeadedColumnToSourceColumn(i),this.wot.createCellCoords(s,i)}markOversizedRows(){if(this.wtSettings.getSetting("externalRowCalculator"))return;let e=this.TBODY.childNodes.length;let t,r,n,s,i;if(e*this.wtSettings.getSetting("defaultRowHeight")!==(0,o.innerHeight)(this.TBODY)-1||this.wtSettings.getSetting("fixedRowsBottom"))for(;e;)e-=1,n=this.rowFilter.renderedToSource(e),t=this.getRowHeight(n),s=this.getTrForRow(n),i=s.querySelector("th"),r=i?(0,o.innerHeight)(i):(0,o.innerHeight)(s)-1,(!t&&this.wtSettings.getSetting("defaultRowHeight")<r||t<r)&&(r+=1,this.dataAccessObject.wtViewport.oversizedRows[n]=r)}getTrForRow(e){return this.TBODY.childNodes[this.rowFilter.sourceToRendered(e)]}isColumnHeaderRendered(e){if(e>=0)return!1;const t=this.wtSettings.getSetting("rowHeaders").length;return Math.abs(e)<=t}isRowHeaderRendered(e){if(e>=0)return!1;const t=this.wtSettings.getSetting("columnHeaders").length;return Math.abs(e)<=t}isRowBeforeRenderedRows(e){const t=this.getFirstRenderedRow();return e<0&&t<=0?!this.isRowHeaderRendered(e):e<t}isRowAfterRenderedRows(e){return e>this.getLastRenderedRow()}isColumnBeforeRenderedColumns(e){const t=this.getFirstRenderedColumn();return e<0&&t<=0?!this.isColumnHeaderRendered(e):e<t}isColumnAfterRenderedColumns(e){return this.columnFilter&&e>this.getLastRenderedColumn()}isColumnAfterViewport(e){return this.columnFilter&&e>this.getLastVisibleColumn()}isRowAfterViewport(e){return this.rowFilter&&e>this.getLastVisibleRow()}isColumnBeforeViewport(e){return this.columnFilter&&this.columnFilter.sourceToRendered(e)<0&&e>=0}isLastRowFullyVisible(){return this.getLastVisibleRow()===this.getLastRenderedRow()}isLastColumnFullyVisible(){return this.getLastVisibleColumn()===this.getLastRenderedColumn()}allRowsInViewport(){return this.wtSettings.getSetting("totalRows")===this.getVisibleRowsCount()}allColumnsInViewport(){return this.wtSettings.getSetting("totalColumns")===this.getVisibleColumnsCount()}getRowHeight(e){return this.rowUtils.getHeight(e)}getColumnHeaderHeight(e){return this.columnUtils.getHeaderHeight(e)}getColumnWidth(e){return this.columnUtils.getWidth(e)}getStretchedColumnWidth(e){return this.columnUtils.getStretchedColumnWidth(e)}hasDefinedSize(){return this.hasTableHeight&&this.hasTableWidth}getWidth(){return(0,o.outerWidth)(this.TABLE)}getHeight(){return(0,o.outerHeight)(this.TABLE)}getTotalWidth(){const e=(0,o.outerWidth)(this.hider);return 0!==e?e:this.getWidth()}getTotalHeight(){const e=(0,o.outerHeight)(this.hider);return 0!==e?e:this.getHeight()}isVisible(){return(0,o.isVisible)(this.TABLE)}_modifyRowHeaderWidth(e){let t=(0,i.isFunction)(e)?e():null;return Array.isArray(t)?(t=[...t],t[t.length-1]=this._correctRowHeaderWidth(t[t.length-1])):t=this._correctRowHeaderWidth(t),t}_correctRowHeaderWidth(e){let t=e;return"number"!=typeof e&&(t=this.wtSettings.getSetting("defaultColumnWidth")),this.correctHeaderWidth&&(t+=1),t}}},60763:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(89817)),o=n(r(92927)),i=n(r(94343)),a=r(58460),l=r(68574);class h extends s.default{constructor(e,t,r,n){super(e,t,r,n,l.CLONE_BOTTOM)}}(0,a.mixin)(h,o.default),(0,a.mixin)(h,i.default);t.default=h},69365:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(89817)),o=n(r(92927)),i=n(r(51672)),a=r(58460),l=r(68574);class h extends s.default{constructor(e,t,r,n){super(e,t,r,n,l.CLONE_BOTTOM_INLINE_START_CORNER)}}(0,a.mixin)(h,o.default),(0,a.mixin)(h,i.default);t.default=h},14477:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(89817)),o=n(r(30155)),i=n(r(51672)),a=r(58460),l=r(68574);class h extends s.default{constructor(e,t,r,n){super(e,t,r,n,l.CLONE_INLINE_START)}}(0,a.mixin)(h,o.default),(0,a.mixin)(h,i.default);t.default=h},43410:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=r(49536),o=n(r(89817)),i=n(r(30155)),a=n(r(94343)),l=r(58460);class h extends o.default{constructor(e,t,r,n){super(e,t,r,n,"master")}alignOverlaysWithTrimmingContainer(){const e=(0,s.getTrimmingContainer)(this.wtRootElement),{rootWindow:t}=this.domBindings;if(e===t){this.wtSettings.getSetting("preventOverflow")||(this.holder.style.overflow="visible",this.wtRootElement.style.overflow="visible")}else{const r=e.parentElement,n=(0,s.getStyle)(e,"height",t),o=(0,s.getStyle)(e,"overflow",t),i=this.holder.style,{scrollWidth:a,scrollHeight:l}=e;let h=e.offsetWidth,u=e.offsetHeight;if(r&&["auto","hidden","scroll"].includes(o)){const n=e.cloneNode(!1);n.style.overflow="auto",n.style.position="absolute",e.nextElementSibling?r.insertBefore(n,e.nextElementSibling):r.appendChild(n);const o=parseInt((0,s.getComputedStyle)(n,t).height,10);r.removeChild(n),0===o&&(u=0)}u=Math.min(u,l),i.height="auto"===n?"auto":`${u}px`,h=Math.min(h,a),i.width=`${h}px`,i.overflow="",this.hasTableHeight="auto"===i.height||u>0,this.hasTableWidth=h>0}this.isTableVisible=(0,s.isVisible)(this.TABLE)}markOversizedColumnHeaders(){const{wtSettings:e}=this,{wtViewport:t}=this.dataAccessObject,r="master",n=e.getSetting("columnHeaders").length;if(n&&!t.hasOversizedColumnHeadersMarked[r]){const s=e.getSetting("rowHeaders").length,o=this.getRenderedColumnsCount();for(let e=0;e<n;e++)for(let e=-1*s;e<o;e++)this.markIfOversizedColumnHeader(e);t.hasOversizedColumnHeadersMarked[r]=!0}}}(0,l.mixin)(h,i.default),(0,l.mixin)(h,a.default);t.default=h},94343:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(58460);const s={getFirstRenderedColumn(){const e=this.dataAccessObject.startColumnRendered;return null===e?-1:e},getFirstVisibleColumn(){const e=this.dataAccessObject.startColumnVisible;return null===e?-1:e},getFirstPartiallyVisibleColumn(){const e=this.dataAccessObject.startColumnPartiallyVisible;return null===e?-1:e},getLastRenderedColumn(){const e=this.dataAccessObject.endColumnRendered;return null===e?-1:e},getLastVisibleColumn(){const e=this.dataAccessObject.endColumnVisible;return null===e?-1:e},getLastPartiallyVisibleColumn(){const e=this.dataAccessObject.endColumnPartiallyVisible;return null===e?-1:e},getRenderedColumnsCount(){return this.dataAccessObject.countColumnsRendered},getVisibleColumnsCount(){return this.dataAccessObject.countColumnsVisible},getRowHeadersCount(){return this.dataAccessObject.rowHeaders.length}};(0,n.defineGetter)(s,"MIXIN_NAME","calculatedColumns",{writable:!1,enumerable:!1});t.default=s},30155:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(58460);const s={getFirstRenderedRow(){const e=this.dataAccessObject.startRowRendered;return null===e?-1:e},getFirstVisibleRow(){const e=this.dataAccessObject.startRowVisible;return null===e?-1:e},getFirstPartiallyVisibleRow(){const e=this.dataAccessObject.startRowPartiallyVisible;return null===e?-1:e},getLastRenderedRow(){const e=this.dataAccessObject.endRowRendered;return null===e?-1:e},getLastVisibleRow(){const e=this.dataAccessObject.endRowVisible;return null===e?-1:e},getLastPartiallyVisibleRow(){const e=this.dataAccessObject.endRowPartiallyVisible;return null===e?-1:e},getRenderedRowsCount(){return this.dataAccessObject.countRowsRendered},getVisibleRowsCount(){return this.dataAccessObject.countRowsVisible},getColumnHeadersCount(){return this.dataAccessObject.columnHeaders.length}};(0,n.defineGetter)(s,"MIXIN_NAME","calculatedRows",{writable:!1,enumerable:!1});t.default=s},51672:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(58460);const s={getFirstRenderedColumn(){return 0===this.wtSettings.getSetting("totalColumns")?-1:0},getFirstVisibleColumn(){return this.getFirstRenderedColumn()},getFirstPartiallyVisibleColumn(){return this.getFirstRenderedColumn()},getLastRenderedColumn(){return this.getRenderedColumnsCount()-1},getLastVisibleColumn(){return this.getLastRenderedColumn()},getLastPartiallyVisibleColumn(){return this.getLastRenderedColumn()},getRenderedColumnsCount(){const e=this.wtSettings.getSetting("totalColumns");return Math.min(this.wtSettings.getSetting("fixedColumnsStart"),e)},getVisibleColumnsCount(){return this.getRenderedColumnsCount()},getRowHeadersCount(){return this.dataAccessObject.rowHeaders.length}};(0,n.defineGetter)(s,"MIXIN_NAME","stickyColumnsStart",{writable:!1,enumerable:!1});t.default=s},92927:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(58460);const s={getFirstRenderedRow(){const e=this.wtSettings.getSetting("totalRows"),t=this.wtSettings.getSetting("fixedRowsBottom"),r=e-t;return 0===e||0===t?-1:r<0?0:r},getFirstVisibleRow(){return this.getFirstRenderedRow()},getFirstPartiallyVisibleRow(){return this.getFirstRenderedRow()},getLastRenderedRow(){return this.wtSettings.getSetting("totalRows")-1},getLastVisibleRow(){return this.getLastRenderedRow()},getLastPartiallyVisibleRow(){return this.getLastRenderedRow()},getRenderedRowsCount(){const e=this.wtSettings.getSetting("totalRows");return Math.min(this.wtSettings.getSetting("fixedRowsBottom"),e)},getVisibleRowsCount(){return this.getRenderedRowsCount()},getColumnHeadersCount:()=>0};(0,n.defineGetter)(s,"MIXIN_NAME","stickyRowsBottom",{writable:!1,enumerable:!1});t.default=s},58825:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(58460);const s={getFirstRenderedRow(){return 0===this.wtSettings.getSetting("totalRows")?-1:0},getFirstVisibleRow(){return this.getFirstRenderedRow()},getFirstPartiallyVisibleRow(){return this.getFirstRenderedRow()},getLastRenderedRow(){return this.getRenderedRowsCount()-1},getLastVisibleRow(){return this.getLastRenderedRow()},getLastPartiallyVisibleRow(){return this.getLastRenderedRow()},getRenderedRowsCount(){const e=this.wtSettings.getSetting("totalRows");return Math.min(this.wtSettings.getSetting("fixedRowsTop"),e)},getVisibleRowsCount(){return this.getRenderedRowsCount()},getColumnHeadersCount(){return this.dataAccessObject.columnHeaders.length}};(0,n.defineGetter)(s,"MIXIN_NAME","stickyRowsTop",{writable:!1,enumerable:!1});t.default=s},55477:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(89817)),o=n(r(58825)),i=n(r(94343)),a=r(58460),l=r(68574);class h extends s.default{constructor(e,t,r,n){super(e,t,r,n,l.CLONE_TOP)}}(0,a.mixin)(h,o.default),(0,a.mixin)(h,i.default);t.default=h},94159:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(89817)),o=n(r(58825)),i=n(r(51672)),a=r(58460),l=r(68574);class h extends s.default{constructor(e,t,r,n){super(e,t,r,n,l.CLONE_TOP_INLINE_START_CORNER)}}(0,a.mixin)(h,o.default),(0,a.mixin)(h,i.default);t.default=h},40205:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),o=r(49536),i=r(58210);t.default=class{constructor(e,t){(0,s.default)(this,"dataAccessObject",void 0),(0,s.default)(this,"wtSettings",void 0),(0,s.default)(this,"headerWidths",new Map),(0,s.default)(this,"stretching",void 0),this.dataAccessObject=e,this.wtSettings=t,this.stretching=new i.ColumnStretching({totalColumns:()=>this.wtSettings.getSetting("totalColumns"),stretchMode:()=>this.wtSettings.getSetting("stretchH"),stretchingColumnWidthFn:(e,t)=>this.wtSettings.getSetting("onBeforeStretchingColumnWidth",e,t),columnWidthFn:e=>this.dataAccessObject.wtTable.getColumnWidth(e)})}getWidth(e){return this.wtSettings.getSetting("columnWidth",e)||this.wtSettings.getSetting("defaultColumnWidth")}getStretchedColumnWidth(e){let t=this.getWidth(e);const r=this.stretching.getStretchedColumnWidth(e,t);return r&&(t=r),t}getHeaderHeight(e){let t=this.wtSettings.getSetting("defaultRowHeight");const r=this.dataAccessObject.wtViewport.oversizedColumnHeaders[e];return void 0!==r&&(t=t?Math.max(t,r):r),t}getHeaderWidth(e){return this.headerWidths.get(this.dataAccessObject.wtTable.columnFilter.sourceToRendered(e))}refreshStretching(){const{wtTable:e,wtViewport:t,cloneSource:r}=this.dataAccessObject,n=r?r.wtTable.holder:e.holder,s=n.offsetHeight<n.scrollHeight?(0,o.getScrollbarWidth)():0;this.stretching.refreshStretching(t.getViewportWidth()-s)}calculateWidths(){const{wtSettings:e}=this;let t=e.getSetting("rowHeaderWidth");if(this.refreshStretching(),t=e.getSetting("onModifyRowHeaderWidth",t),null!=t){const r=e.getSetting("rowHeaders").length,n=e.getSetting("defaultColumnWidth");for(let e=0;e<r;e++){let r=Array.isArray(t)?t[e]:t;r=null==r?n:r,this.headerWidths.set(e,r)}}}}},58210:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707));function o(e,t,r){!function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}(e,t),t.set(e,r)}function i(e,t){return e.get(l(e,t))}function a(e,t,r){return e.set(l(e,t),r),r}function l(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var h=new WeakMap,u=new WeakMap,c=new WeakMap,d=new WeakMap,p=new WeakMap;class g{static get DEFAULT_WIDTH(){return 50}constructor(e){let{totalColumns:t,stretchMode:r,stretchingColumnWidthFn:n,columnWidthFn:l}=e;(0,s.default)(this,"stretchAllRatio",0),(0,s.default)(this,"stretchLastWidth",0),(0,s.default)(this,"stretchAllColumnsWidth",[]),o(this,h,0),(0,s.default)(this,"needVerifyLastColumnWidth",!0),o(this,u,(()=>0)),o(this,c,(e=>e)),o(this,d,(e=>e)),o(this,p,(()=>"none")),a(u,this,t),a(p,this,r),a(c,this,null!=n?n:i(c,this)),a(d,this,null!=l?l:i(d,this))}refreshStretching(e){if("none"===i(p,this).call(this))return;a(h,this,e);let t=0;for(let r=0;r<i(u,this).call(this);r++){const n=this._getColumnWidth(r),s=i(c,this).call(this,void 0,r);"number"==typeof s?e-=s:t+=n}const r=e-t;if("all"===i(p,this).call(this)&&r>0)this.stretchAllRatio=e/t,this.stretchAllColumnsWidth=[],this.needVerifyLastColumnWidth=!0;else if("last"===i(p,this).call(this)&&e!==1/0){const e=this._getColumnWidth(i(u,this).call(this)-1),t=r+e;this.stretchLastWidth=t>=0?t:e}}getStretchedColumnWidth(e,t){let r=null;return"all"===i(p,this).call(this)&&0!==this.stretchAllRatio?r=this._getStretchedAllColumnWidth(e,t):"last"===i(p,this).call(this)&&0!==this.stretchLastWidth&&(r=this._getStretchedLastColumnWidth(e)),r}_getStretchedAllColumnWidth(e,t){let r=0;if(!this.stretchAllColumnsWidth[e]){const r=Math.round(t*this.stretchAllRatio),n=i(c,this).call(this,r,e);this.stretchAllColumnsWidth[e]=void 0===n?r:isNaN(n)?this._getColumnWidth(e):n}if(this.stretchAllColumnsWidth.length===i(u,this).call(this)&&this.needVerifyLastColumnWidth){this.needVerifyLastColumnWidth=!1;for(let e=0;e<this.stretchAllColumnsWidth.length;e++)r+=this.stretchAllColumnsWidth[e];r!==i(h,this)&&(this.stretchAllColumnsWidth[this.stretchAllColumnsWidth.length-1]+=i(h,this)-r)}return this.stretchAllColumnsWidth[e]}_getStretchedLastColumnWidth(e){return e===i(u,this).call(this)-1?this.stretchLastWidth:null}_getColumnWidth(e){let t=i(d,this).call(this,e);return isNaN(t)&&(t=g.DEFAULT_WIDTH),t}}t.ColumnStretching=g},63912:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.default=class{constructor(e){(0,s.default)(this,"nodeType",void 0),this.nodeType=e.toUpperCase()}setRootDocument(e){this.rootDocument=e}obtain(){return this.rootDocument.createElement(this.nodeType)}}},38104:(e,t)=>{"use strict";t.__esModule=!0;t.WORKING_SPACE_ALL=0,t.WORKING_SPACE_TOP=1,t.WORKING_SPACE_BOTTOM=2},64625:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(27528));t.OrderView=s.default;var o=n(r(84013));t.SharedOrderView=o.default},84013:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(27528));class o extends s.default{prependView(e){return this.sizeSet.prepend(e.sizeSet),e.sizeSet.append(this.sizeSet),this}appendView(e){return this.sizeSet.append(e.sizeSet),e.sizeSet.prepend(this.sizeSet),this}}t.default=o},27528:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724);var s=n(r(85707)),o=r(38104),i=n(r(57637));t.default=class{constructor(e,t,r){(0,s.default)(this,"rootNode",void 0),(0,s.default)(this,"nodesPool",void 0),(0,s.default)(this,"sizeSet",new i.default),(0,s.default)(this,"childNodeType",void 0),(0,s.default)(this,"visualIndex",0),(0,s.default)(this,"collectedNodes",[]),this.rootNode=e,this.nodesPool=t,this.childNodeType=r.toUpperCase()}setSize(e){return this.sizeSet.setSize(e),this}setOffset(e){return this.sizeSet.setOffset(e),this}isSharedViewSet(){return this.sizeSet.isShared()}getNode(e){return e<this.collectedNodes.length?this.collectedNodes[e]:null}getCurrentNode(){const e=this.collectedNodes.length;return e>0?this.collectedNodes[e-1]:null}getRenderedChildCount(){const{rootNode:e,sizeSet:t}=this;let r=0;if(this.isSharedViewSet()){let n=e.firstElementChild;for(;n;){if(n.tagName===this.childNodeType)r+=1;else if(t.isPlaceOn(o.WORKING_SPACE_TOP))break;n=n.nextElementSibling}}else r=e.childElementCount;return r}start(){this.collectedNodes.length=0,this.visualIndex=0;const{rootNode:e,sizeSet:t}=this,r=this.isSharedViewSet(),{nextSize:n}=t.getViewSize();let s=this.getRenderedChildCount();for(;s<n;){const n=this.nodesPool();!r||r&&t.isPlaceOn(o.WORKING_SPACE_BOTTOM)?e.appendChild(n):e.insertBefore(n,e.firstChild),s+=1}const i=r&&t.isPlaceOn(o.WORKING_SPACE_TOP);for(;s>n;)e.removeChild(i?e.firstChild:e.lastChild),s-=1}render(){const{rootNode:e,sizeSet:t}=this;let r=this.visualIndex;this.isSharedViewSet()&&t.isPlaceOn(o.WORKING_SPACE_BOTTOM)&&(r+=t.sharedSize.nextSize);let n=e.childNodes[r];if(n.tagName!==this.childNodeType){const t=this.nodesPool();e.replaceChild(t,n),n=t}this.collectedNodes.push(n),this.visualIndex+=1}end(){}}},56269:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.default=class{constructor(){(0,s.default)(this,"currentSize",0),(0,s.default)(this,"nextSize",0),(0,s.default)(this,"currentOffset",0),(0,s.default)(this,"nextOffset",0)}setSize(e){this.currentSize=this.nextSize,this.nextSize=e}setOffset(e){this.currentOffset=this.nextOffset,this.nextOffset=e}}},57637:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),o=n(r(56269)),i=r(38104);t.default=class{constructor(){(0,s.default)(this,"size",new o.default),(0,s.default)(this,"workingSpace",i.WORKING_SPACE_ALL),(0,s.default)(this,"sharedSize",null)}setSize(e){this.size.setSize(e)}setOffset(e){this.size.setOffset(e)}getViewSize(){return this.size}isShared(){return this.sharedSize instanceof o.default}isPlaceOn(e){return this.workingSpace===e}append(e){this.workingSpace=i.WORKING_SPACE_TOP,e.workingSpace=i.WORKING_SPACE_BOTTOM,this.sharedSize=e.getViewSize()}prepend(e){this.workingSpace=i.WORKING_SPACE_BOTTOM,e.workingSpace=i.WORKING_SPACE_TOP,this.sharedSize=e.getViewSize()}}},58299:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.default=class{constructor(e,t){(0,s.default)(this,"dataAccessObject",void 0),(0,s.default)(this,"wtSettings",void 0),this.dataAccessObject=e,this.wtSettings=t}getHeight(e){let t=this.wtSettings.getSetting("rowHeight",e);const r=this.dataAccessObject.wtViewport.oversizedRows[e];return void 0!==r&&(t=void 0===t?r:Math.max(t,r)),t}}},86203:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(49536),s=r(58460),o=r(44038);t.default=class{constructor(e,t,r,n,s){this.dataAccessObject=e,this.wot=e.wot,this.instance=this.wot,this.domBindings=t,this.wtSettings=r,this.wtTable=s,this.oversizedRows=[],this.oversizedColumnHeaders=[],this.hasOversizedColumnHeadersMarked={},this.clientHeight=0,this.containerWidth=NaN,this.rowHeaderWidth=NaN,this.rowsVisibleCalculator=null,this.columnsVisibleCalculator=null,this.eventManager=n,this.eventManager.addEventListener(this.domBindings.rootWindow,"resize",(()=>{this.clientHeight=this.getWorkspaceHeight()}))}getWorkspaceHeight(){const e=this.domBindings.rootDocument,t=this.dataAccessObject.topOverlayTrimmingContainer;let r=0;if(t===this.domBindings.rootWindow)r=e.documentElement.clientHeight;else{r=(0,n.outerHeight)(t)>0&&t.clientHeight>0?t.clientHeight:1/0}return r}getWorkspaceWidth(){const{wtSettings:e}=this,{rootDocument:t,rootWindow:r}=this.domBindings,s=this.dataAccessObject.inlineStartOverlayTrimmingContainer,o=t.documentElement.offsetWidth,i=e.getSetting("totalColumns"),a=e.getSetting("preventOverflow"),l=e.getSetting("rtlMode"),h=this.wtTable.TABLE.getBoundingClientRect(),u=o-(l?h.right-o:h.left);let c,d;if(a)return(0,n.outerWidth)(this.wtTable.wtRootElement);if(c=e.getSetting("freezeOverlays")?Math.min(u,o):Math.min(this.getContainerFillWidth(),u,o),s===r&&i>0&&this.sumColumnWidths(0,i-1)>c)return t.documentElement.clientWidth;if(s!==r&&(d=(0,n.getStyle)(this.dataAccessObject.inlineStartOverlayTrimmingContainer,"overflow",r),"scroll"===d||"hidden"===d||"auto"===d))return Math.max(c,s.clientWidth);const p=e.getSetting("stretchH");return"none"!==p&&p?c:Math.max(c,(0,n.outerWidth)(this.wtTable.TABLE))}hasVerticalScroll(){return this.wtTable.hider.offsetHeight>this.getWorkspaceHeight()}hasHorizontalScroll(){return this.wtTable.hider.offsetWidth>this.getWorkspaceWidth()}sumColumnWidths(e,t){let r=0,n=e;for(;n<t;)r+=this.wtTable.getColumnWidth(n),n+=1;return r}getContainerFillWidth(){if(this.containerWidth)return this.containerWidth;const e=this.wtTable.holder,t=this.domBindings.rootDocument.createElement("div");t.style.width="100%",t.style.height="1px",e.appendChild(t);const r=t.offsetWidth;return this.containerWidth=r,e.removeChild(t),r}getWorkspaceOffset(){return(0,n.offset)(this.wtTable.TABLE)}getColumnHeaderHeight(){return this.wtSettings.getSetting("columnHeaders").length?isNaN(this.columnHeaderHeight)&&(this.columnHeaderHeight=(0,n.outerHeight)(this.wtTable.THEAD)):this.columnHeaderHeight=0,this.columnHeaderHeight}getViewportHeight(){let e=this.getWorkspaceHeight();if(e===1/0)return e;const t=this.getColumnHeaderHeight();return t>0&&(e-=t),e}getRowHeaderWidth(){const e=this.wtSettings.getSetting("rowHeaderWidth"),t=this.wtSettings.getSetting("rowHeaders");if(e){this.rowHeaderWidth=0;for(let r=0,n=t.length;r<n;r++)this.rowHeaderWidth+=e[r]||e}if(isNaN(this.rowHeaderWidth))if(t.length){let e=this.wtTable.TABLE.querySelector("TH");this.rowHeaderWidth=0;for(let r=0,s=t.length;r<s;r++)e?(this.rowHeaderWidth+=(0,n.outerWidth)(e),e=e.nextSibling):this.rowHeaderWidth+=50}else this.rowHeaderWidth=0;return this.rowHeaderWidth=this.wtSettings.getSetting("onModifyRowHeaderWidth",this.rowHeaderWidth)||this.rowHeaderWidth,this.rowHeaderWidth}getViewportWidth(){const e=this.getWorkspaceWidth();if(e===1/0)return e;const t=this.getRowHeaderWidth();return t>0?e-t:e}createRowsCalculator(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:o.RENDER_TYPE;const{wtSettings:t,wtTable:r}=this;if(t.getSetting("renderAllRows")&&e===o.RENDER_TYPE)return new o.RenderAllRowsCalculator({totalRows:t.getSetting("totalRows")});let s,i,a=this.getViewportHeight();this.rowHeaderWidth=NaN;let l=this.dataAccessObject.topScrollPosition-this.dataAccessObject.topParentOffset;const h=t.getSetting("fixedRowsTop"),u=t.getSetting("fixedRowsBottom"),c=t.getSetting("totalRows");return h&&l>=0&&(i=this.dataAccessObject.topOverlay.sumCellSizes(0,h),l+=i,a-=i),u&&this.dataAccessObject.bottomOverlay.clone&&(i=this.dataAccessObject.bottomOverlay.sumCellSizes(c-u,c),a-=i),s=r.holder.clientHeight===r.holder.offsetHeight?0:(0,n.getScrollbarWidth)(this.domBindings.rootDocument),new o.ViewportRowsCalculator({viewportHeight:a,scrollOffset:l,totalRows:t.getSetting("totalRows"),rowHeightFn:e=>r.getRowHeight(e),overrideFn:t.getSettingPure("viewportRowCalculatorOverride"),calculationType:e,horizontalScrollbarHeight:s})}createColumnsCalculator(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:o.RENDER_TYPE;const{wtSettings:t,wtTable:r}=this;if(t.getSetting("renderAllColumns")&&e===o.RENDER_TYPE)return new o.RenderAllColumnsCalculator({totalColumns:t.getSetting("totalColumns")});let s=this.getViewportWidth(),i=Math.abs(this.dataAccessObject.inlineStartScrollPosition)-this.dataAccessObject.inlineStartParentOffset;this.columnHeaderHeight=NaN;const a=t.getSetting("fixedColumnsStart");if(a&&i>=0){const e=this.dataAccessObject.inlineStartOverlay.sumCellSizes(0,a);i+=e,s-=e}return r.holder.clientWidth!==r.holder.offsetWidth&&(s-=(0,n.getScrollbarWidth)(this.domBindings.rootDocument)),new o.ViewportColumnsCalculator({viewportWidth:s,scrollOffset:i,totalColumns:t.getSetting("totalColumns"),columnWidthFn:e=>r.getColumnWidth(e),overrideFn:t.getSettingPure("viewportColumnCalculatorOverride"),calculationType:e,inlineStartOffset:this.dataAccessObject.inlineStartParentOffset})}createRenderCalculators(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];const{wtSettings:t}=this;if(e&&!t.getSetting("renderAllRows")){const t=this.createRowsCalculator(o.FULLY_VISIBLE_TYPE);e=this.areAllProposedVisibleRowsAlreadyRendered(t)}if(e&&!t.getSetting("renderAllColumns")){const t=this.createColumnsCalculator(o.FULLY_VISIBLE_TYPE);e=this.areAllProposedVisibleColumnsAlreadyRendered(t)}return e||(this.rowsRenderCalculator=this.createRowsCalculator(o.RENDER_TYPE),this.columnsRenderCalculator=this.createColumnsCalculator(o.RENDER_TYPE)),this.rowsVisibleCalculator=null,this.columnsVisibleCalculator=null,e}createVisibleCalculators(){this.rowsVisibleCalculator=this.createRowsCalculator(o.FULLY_VISIBLE_TYPE),this.columnsVisibleCalculator=this.createColumnsCalculator(o.FULLY_VISIBLE_TYPE)}createPartiallyVisibleCalculators(){this.rowsPartiallyVisibleCalculator=this.createRowsCalculator(o.PARTIALLY_VISIBLE_TYPE),this.columnsPartiallyVisibleCalculator=this.createColumnsCalculator(o.PARTIALLY_VISIBLE_TYPE)}areAllProposedVisibleRowsAlreadyRendered(e){if(!this.rowsVisibleCalculator)return!1;const{startRow:t,endRow:r,isVisibleInTrimmingContainer:n}=e;if(null===t&&null===r)return!n;const{startRow:s,endRow:o}=this.rowsRenderCalculator;return!(t<s||t===s&&t>0)&&!(r>o||r===o&&r<this.wtSettings.getSetting("totalRows")-1)}areAllProposedVisibleColumnsAlreadyRendered(e){if(!this.columnsVisibleCalculator)return!1;const{startColumn:t,endColumn:r,isVisibleInTrimmingContainer:n}=e;if(null===t&&null===r)return!n;const{startColumn:s,endColumn:o}=this.columnsRenderCalculator;return!(t<s||t===s&&t>0)&&!(r>o||r===o&&r<this.wtSettings.getSetting("totalColumns")-1)}resetHasOversizedColumnHeadersMarked(){(0,s.objectEach)(this.hasOversizedColumnHeadersMarked,((e,t,r)=>{r[t]=void 0}))}}},25188:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(6254),r(20512),r(23844),r(38594);var s=n(r(87910)),o=r(26048),i=r(56988),a=n(r(37056)),l=r(63055),h=r(36528),u=r(96431),c=r(47009),d=r(6697);function p(e,t){const r=new s.default(e,t||{},o.rootInstanceSymbol);return r.init(),r}t.CellCoords=d.CellCoords,t.CellRange=d.CellRange,(0,h.registerCellType)(u.TextCellType),p.editors={BaseEditor:c.BaseEditor},p.Core=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return new s.default(e,t,o.rootInstanceSymbol)},p.DefaultSettings=(0,i.metaSchemaFactory)(),p.hooks=a.default.getSingleton(),p.CellCoords=d.CellCoords,p.CellRange=d.CellRange,p.packageName="handsontable",p.buildDate="16/04/2024 10:23:56",p.version="14.3.0",p.languages={dictionaryKeys:l.dictionaryKeys,getLanguageDictionary:l.getLanguageDictionary,getLanguagesDictionaries:l.getLanguagesDictionaries,registerLanguageDictionary:l.registerLanguageDictionary,getTranslatedPhrase:l.getTranslatedPhrase};t.default=p},87222:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(29328),s=r(19920),o=r(2560);const i=t.CELL_TYPE="autocomplete";t.AutocompleteCellType={CELL_TYPE:i,editor:n.AutocompleteEditor,renderer:s.autocompleteRenderer,validator:o.autocompleteValidator}},44760:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(87222);t.AutocompleteCellType=n.AutocompleteCellType,t.CELL_TYPE=n.CELL_TYPE},24976:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(78457),s=r(97177);const o=t.CELL_TYPE="checkbox";t.CheckboxCellType={CELL_TYPE:o,editor:n.CheckboxEditor,renderer:s.checkboxRenderer}},65517:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(24976);t.CELL_TYPE=n.CELL_TYPE,t.CheckboxCellType=n.CheckboxCellType},46330:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(66436),s=r(8920),o=r(64228);const i=t.CELL_TYPE="date";t.DateCellType={CELL_TYPE:i,editor:n.DateEditor,renderer:s.dateRenderer,validator:o.dateValidator}},64936:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(46330);t.CELL_TYPE=n.CELL_TYPE,t.DateCellType=n.DateCellType},82464:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(54185),s=r(3001),o=r(44795);const i=t.CELL_TYPE="dropdown";t.DropdownCellType={CELL_TYPE:i,editor:n.DropdownEditor,renderer:s.dropdownRenderer,validator:o.dropdownValidator}},47041:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(82464);t.CELL_TYPE=n.CELL_TYPE,t.DropdownCellType=n.DropdownCellType},37648:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(76545),s=r(94553);const o=t.CELL_TYPE="handsontable";t.HandsontableCellType={CELL_TYPE:o,editor:n.HandsontableEditor,renderer:s.handsontableRenderer}},7661:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(37648);t.CELL_TYPE=n.CELL_TYPE,t.HandsontableCellType=n.HandsontableCellType},39151:(e,t,r)=>{"use strict";t.__esModule=!0,t.registerAllCellTypes=function(){(0,p.registerCellType)(n.AutocompleteCellType),(0,p.registerCellType)(s.CheckboxCellType),(0,p.registerCellType)(o.DateCellType),(0,p.registerCellType)(i.DropdownCellType),(0,p.registerCellType)(a.HandsontableCellType),(0,p.registerCellType)(l.NumericCellType),(0,p.registerCellType)(h.PasswordCellType),(0,p.registerCellType)(u.SelectCellType),(0,p.registerCellType)(c.TextCellType),(0,p.registerCellType)(d.TimeCellType)};var n=r(44760);t.AutocompleteCellType=n.AutocompleteCellType,t.AUTOCOMPLETE_TYPE=n.CELL_TYPE;var s=r(65517);t.CheckboxCellType=s.CheckboxCellType,t.CHECKBOX_TYPE=s.CELL_TYPE;var o=r(64936);t.DateCellType=o.DateCellType,t.DATE_TYPE=o.CELL_TYPE;var i=r(47041);t.DropdownCellType=i.DropdownCellType,t.DROPDOWN_TYPE=i.CELL_TYPE;var a=r(7661);t.HandsontableCellType=a.HandsontableCellType,t.HANDSONTABLE_TYPE=a.CELL_TYPE;var l=r(26523);t.NumericCellType=l.NumericCellType,t.NUMERIC_TYPE=l.CELL_TYPE;var h=r(33685);t.PasswordCellType=h.PasswordCellType,t.PASSWORD_TYPE=h.CELL_TYPE;var u=r(92292);t.SelectCellType=u.SelectCellType,t.SELECT_TYPE=u.CELL_TYPE;var c=r(96431);t.TextCellType=c.TextCellType,t.TEXT_TYPE=c.CELL_TYPE;var d=r(79301);t.TimeCellType=d.TimeCellType,t.TIME_TYPE=d.CELL_TYPE;var p=r(36528);t.registerCellType=p.registerCellType,t.getCellType=p.getCellType,t.getRegisteredCellTypeNames=p.getRegisteredCellTypeNames,t.getRegisteredCellTypes=p.getRegisteredCellTypes,t.hasCellType=p.hasCellType},26523:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(57032);t.CELL_TYPE=n.CELL_TYPE,t.NumericCellType=n.NumericCellType},57032:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(59889),s=r(73981),o=r(42777);const i=t.CELL_TYPE="numeric";t.NumericCellType={CELL_TYPE:i,editor:n.NumericEditor,renderer:s.numericRenderer,validator:o.numericValidator,dataType:"number"}},33685:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(41288);t.CELL_TYPE=n.CELL_TYPE,t.PasswordCellType=n.PasswordCellType},41288:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(14961),s=r(7473);const o=t.CELL_TYPE="password";t.PasswordCellType={CELL_TYPE:o,editor:n.PasswordEditor,renderer:s.passwordRenderer,copyable:!1}},36528:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.getCellType=function(e){if(!u(e))throw Error(`You declared cell type "${e}" as a string that is not mapped to a known object.\n                 Cell type must be an object or a string mapped to an object registered by\n                 "Handsontable.cellTypes.registerCellType" method`);return h(e)},t.registerCellType=function(e,t){"string"!=typeof e&&(e=(t=e).CELL_TYPE);const{editor:r,renderer:n,validator:s}=t;r&&(0,o.registerEditor)(e,r);n&&(0,i.registerRenderer)(e,n);s&&(0,a.registerValidator)(e,s);l(e,t)},r(67834);var s=n(r(45212)),o=r(39761),i=r(94539),a=r(19434);const{register:l,getItem:h,hasItem:u,getNames:c,getValues:d}=(0,s.default)("cellTypes");t.getRegisteredCellTypes=d,t.getRegisteredCellTypeNames=c,t.hasCellType=u},92292:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(34282);t.CELL_TYPE=n.CELL_TYPE,t.SelectCellType=n.SelectCellType},34282:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(51656),s=r(93276);const o=t.CELL_TYPE="select";t.SelectCellType={CELL_TYPE:o,editor:n.SelectEditor,renderer:s.selectRenderer}},96431:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(34712);t.CELL_TYPE=n.CELL_TYPE,t.TextCellType=n.TextCellType},34712:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(48043),s=r(6135);const o=t.CELL_TYPE="text";t.TextCellType={CELL_TYPE:o,editor:n.TextEditor,renderer:s.textRenderer}},79301:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(66884);t.CELL_TYPE=n.CELL_TYPE,t.TimeCellType=n.TimeCellType},66884:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(54837),s=r(38537),o=r(16691);const i=t.CELL_TYPE="time";t.TimeCellType={CELL_TYPE:i,editor:n.TimeEditor,renderer:s.timeRenderer,validator:o.timeValidator}},87910:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.default=function(e,t){var r,n=this;let H=arguments.length>2&&void 0!==arguments[2]&&arguments[2],F=this;const U=new h.default(F);let V,B,W,Y,j,G,z=!0;(0,T.hasValidParameter)(H)&&(0,T.registerAsRootInstance)(this);this.rootElement=e,this.rootDocument=e.ownerDocument,this.rootWindow=this.rootDocument.defaultView,this.isDestroyed=!1,this.renderSuspendedCounter=0,this.executionSuspendedCounter=0;const $=null!==(r=null==t?void 0:t.layoutDirection)&&void 0!==r?r:"inherit",K=["rtl","ltr"].includes($)?$:this.rootWindow.getComputedStyle(this.rootElement).direction;this.rootElement.setAttribute("dir",K),this.isRtl=function(){return"rtl"===K},this.isLtr=function(){return!F.isRtl()},this.getDirectionFactor=function(){return F.isLtr()?1:-1},t.language=(0,M.getValidLanguageCode)(t.language);const X=new I.MetaManager(F,t,[I.DynamicCellMetaMod,I.ExtendMetaPropertiesMod]),q=X.getTableMeta(),Q=X.getGlobalMeta(),Z=(0,x.createUniqueMap)();this.container=this.rootDocument.createElement("div"),this.renderCall=!1,e.insertBefore(this.container,e.firstChild),(0,T.isRootInstance)(this)&&(0,i._injectProductInfo)(t.licenseKey,e);this.guid=`ht_${(0,y.randomString)()}`,k.set(this.guid,this),this.columnIndexMapper=new S.IndexMapper,this.rowIndexMapper=new S.IndexMapper,this.columnIndexMapper.addLocalHook("indexesSequenceChange",(e=>{F.runHooks("afterColumnSequenceChange",e)})),this.rowIndexMapper.addLocalHook("indexesSequenceChange",(e=>{F.runHooks("afterRowSequenceChange",e)})),B=new R.default(F),this.rootElement.id&&"ht_"!==this.rootElement.id.substring(0,3)||(this.rootElement.id=this.guid);let J=new b.Selection(q,{rowIndexMapper:F.rowIndexMapper,columnIndexMapper:F.columnIndexMapper,countCols:()=>F.countCols(),countRows:()=>F.countRows(),propToCol:e=>V.propToCol(e),isEditorOpened:()=>!!F.getActiveEditor()&&F.getActiveEditor().isOpened(),countRenderableColumns:()=>this.view.countRenderableColumns(),countRenderableRows:()=>this.view.countRenderableRows(),countRowHeaders:()=>this.countRowHeaders(),countColHeaders:()=>this.countColHeaders(),countRenderableRowsInRange:function(){return n.view.countRenderableRowsInRange(...arguments)},countRenderableColumnsInRange:function(){return n.view.countRenderableColumnsInRange(...arguments)},getShortcutManager:()=>F.getShortcutManager(),createCellCoords:(e,t)=>F._createCellCoords(e,t),createCellRange:(e,t,r)=>F._createCellRange(e,t,r),visualToRenderableCoords:e=>{const{row:t,col:r}=e;return F._createCellCoords(t>=0?F.rowIndexMapper.getRenderableFromVisualIndex(t):t,r>=0?F.columnIndexMapper.getRenderableFromVisualIndex(r):r)},renderableToVisualCoords:e=>{const{row:t,col:r}=e;return F._createCellCoords(t>=0?F.rowIndexMapper.getVisualFromRenderableIndex(t):t,r>=0?F.columnIndexMapper.getVisualFromRenderableIndex(r):r)},findFirstNonHiddenRenderableRow:(e,t)=>{const r=t>e?1:-1,n=Math.min(e,t),s=Math.max(e,t),o=F.rowIndexMapper.getNearestNotHiddenIndex(e,r);return null===o||1===r&&o>s||-1===r&&o<n?null:o>=0?F.rowIndexMapper.getRenderableFromVisualIndex(o):o},findFirstNonHiddenRenderableColumn:(e,t)=>{const r=t>e?1:-1,n=Math.min(e,t),s=Math.max(e,t),o=F.columnIndexMapper.getNearestNotHiddenIndex(e,r);return null===o||1===r&&o>s||-1===r&&o<n?null:o>=0?F.columnIndexMapper.getRenderableFromVisualIndex(o):o},isDisabledCellSelection:(e,t)=>e<0||t<0?F.getSettings().disableVisualSelection:F.getCellMeta(e,t).disableVisualSelection});this.selection=J;const ee=e=>{let{hiddenIndexesChanged:t}=e;t&&this.selection.refresh()};function te(e){const t=(0,A.normalizeLanguageCode)(e);(0,M.hasLanguageDictionary)(t)?(F.runHooks("beforeLanguageChange",t),Q.language=t,F.runHooks("afterLanguageChange",t)):(0,A.warnUserAboutLanguageRegistration)(e)}function re(e,t){const r="className"===e?F.rootElement:F.table;if(z)(0,s.addClass)(r,t);else{let n=[],o=[];Q[e]&&(n=Array.isArray(Q[e])?Q[e]:(0,d.stringToArray)(Q[e])),t&&(o=Array.isArray(t)?t:(0,d.stringToArray)(t));const i=(0,d.getDifferenceOfArrays)(n,o),a=(0,d.getDifferenceOfArrays)(o,n);i.length&&(0,s.removeClass)(r,i),a.length&&(0,s.addClass)(r,a)}Q[e]=t}function ne(){let e=!1;return{validatorsInQueue:0,valid:!0,addValidatorToQueue(){this.validatorsInQueue+=1,e=!1},removeValidatorFormQueue(){this.validatorsInQueue=this.validatorsInQueue-1<0?0:this.validatorsInQueue-1,this.checkIfQueueIsEmpty()},onQueueEmpty(){},checkIfQueueIsEmpty(){0===this.validatorsInQueue&&!1===e&&(e=!0,this.onQueueEmpty(this.valid))}}}function se(e){const t=e.replace(",",".");return!1===isNaN(parseFloat(t))?parseFloat(t):e}function oe(e,t,r){if(!e.length)return;const n=F.getActiveEditor(),o=new ne;let i=!0;o.onQueueEmpty=e=>{n&&i&&n.cancelChanges(),r(e)};for(let r=e.length-1;r>=0;r--){const[n,a,,l]=e[r],h=V.propToCol(a),u=F.getCellMeta(n,h);"numeric"===u.type&&"string"==typeof l&&(0,w.isNumericLike)(l)&&(e[r][3]=se(l)),F.getCellValidator(u)&&(o.addValidatorToQueue(),F.validateCell(e[r][3],u,function(t,r){return function(n){if("boolean"!=typeof n)throw new Error("Validation error: result is not boolean");if(!1===n&&!1===r.allowInvalid){i=!1,e.splice(t,1),r.valid=!0;const n=F.getCell(r.visualRow,r.visualCol);null!==n&&(0,s.removeClass)(n,q.invalidCellClassName)}o.removeValidatorFormQueue()}}(r,u),t))}o.checkIfQueueIsEmpty()}function ie(e,t){let r=e.length-1;if(r<0)return;for(;r>=0;r--){let n=!1;if(null!==e[r]){if(null!==e[r][2]&&void 0!==e[r][2]||null!==e[r][3]&&void 0!==e[r][3]){if(q.allowInsertRow)for(;e[r][0]>F.countRows()-1;){const{delta:e}=V.createRow(void 0,void 0,{source:t});if(0===e){n=!0;break}}if("array"===F.dataType&&(!q.columns||0===q.columns.length)&&q.allowInsertColumn)for(;V.propToCol(e[r][1])>F.countCols()-1;){const{delta:e}=V.createCol(void 0,void 0,{source:t});if(0===e){n=!0;break}}n||V.set(e[r][0],e[r][1],e[r][3])}}else e.splice(r,1)}F.forceFullRender=!0,W.adjustRowsAndCols(),F.runHooks("beforeChangeRender",e,t),Y.lockEditor(),F._refreshBorders(null),Y.unlockEditor(),F.view.adjustElementsSize(),F.runHooks("afterChange",e,t||"edit");const n=F.getActiveEditor();n&&(0,i.isDefined)(n.refreshValue)&&n.refreshValue()}function ae(e,t,r){return Array.isArray(e)?e:[[e,t,r]]}function le(e,t){const r=F.getActiveEditor(),n=F.runHooks("beforeChange",e,t||"edit"),s=e.filter((e=>null!==e));return!1===n||0===s.length?(r&&r.cancelChanges(),[]):s}this.columnIndexMapper.addLocalHook("cacheUpdated",ee),this.rowIndexMapper.addLocalHook("cacheUpdated",ee),this.selection.addLocalHook("afterSetRangeEnd",((e,t)=>{const r=(0,u.createObjectPropListener)(!1),n=this.selection.getSelectedRange(),{from:o,to:i}=n.current(),a=n.size()-1;this.runHooks("afterSelection",o.row,o.col,i.row,i.col,r,a),this.runHooks("afterSelectionByProp",o.row,F.colToProp(o.col),i.row,F.colToProp(i.col),r,a),t&&(!r.isTouched()||r.isTouched()&&!r.value)&&G.scrollTo(e);const l=J.isSelectedByRowHeader(),h=J.isSelectedByColumnHeader();l&&h?(0,s.addClass)(this.rootElement,["ht__selection--rows","ht__selection--columns"]):l?((0,s.removeClass)(this.rootElement,"ht__selection--columns"),(0,s.addClass)(this.rootElement,"ht__selection--rows")):h?((0,s.removeClass)(this.rootElement,"ht__selection--rows"),(0,s.addClass)(this.rootElement,"ht__selection--columns")):(0,s.removeClass)(this.rootElement,["ht__selection--rows","ht__selection--columns"]),this._refreshBorders(null)})),this.selection.addLocalHook("beforeSetFocus",(e=>{this.runHooks("beforeSelectionFocusSet",e.row,e.col)})),this.selection.addLocalHook("afterSetFocus",(e=>{const t=(0,u.createObjectPropListener)(!1);this.runHooks("afterSelectionFocusSet",e.row,e.col,t),(!t.isTouched()||t.isTouched()&&!t.value)&&G.scrollTo(e),this._refreshBorders(null)})),this.selection.addLocalHook("afterSelectionFinished",(e=>{const t=e.length-1,{from:r,to:n}=e[t];this.runHooks("afterSelectionEnd",r.row,r.col,n.row,n.col,t),this.runHooks("afterSelectionEndByProp",r.row,F.colToProp(r.col),n.row,F.colToProp(n.col),t)})),this.selection.addLocalHook("afterIsMultipleSelection",(e=>{const t=this.runHooks("afterIsMultipleSelection",e.value);e.value&&(e.value=t)})),this.selection.addLocalHook("afterDeselect",(()=>{Y.destroyEditor(),this._refreshBorders(),(0,s.removeClass)(this.rootElement,["ht__selection--rows","ht__selection--columns"]),this.runHooks("afterDeselect")})),this.selection.addLocalHook("beforeHighlightSet",(()=>this.runHooks("beforeSelectionHighlightSet"))).addLocalHook("beforeSetRangeStart",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("beforeSetRangeStart",...t)})).addLocalHook("beforeSetRangeStartOnly",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("beforeSetRangeStartOnly",...t)})).addLocalHook("beforeSetRangeEnd",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("beforeSetRangeEnd",...t)})).addLocalHook("beforeSelectColumns",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("beforeSelectColumns",...t)})).addLocalHook("afterSelectColumns",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("afterSelectColumns",...t)})).addLocalHook("beforeSelectRows",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("beforeSelectRows",...t)})).addLocalHook("afterSelectRows",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("afterSelectRows",...t)})).addLocalHook("beforeModifyTransformStart",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("modifyTransformStart",...t)})).addLocalHook("afterModifyTransformStart",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("afterModifyTransformStart",...t)})).addLocalHook("beforeModifyTransformFocus",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("modifyTransformFocus",...t)})).addLocalHook("afterModifyTransformFocus",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("afterModifyTransformFocus",...t)})).addLocalHook("beforeModifyTransformEnd",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("modifyTransformEnd",...t)})).addLocalHook("afterModifyTransformEnd",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("afterModifyTransformEnd",...t)})).addLocalHook("beforeRowWrap",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("beforeRowWrap",...t)})).addLocalHook("beforeColumnWrap",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("beforeColumnWrap",...t)})).addLocalHook("insertRowRequire",(e=>this.alter("insert_row_above",e,1,"auto"))).addLocalHook("insertColRequire",(e=>this.alter("insert_col_start",e,1,"auto"))),W={alter(e,t){var r,n;let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:1,o=arguments.length>3?arguments[3]:void 0,a=arguments.length>4?arguments[4]:void 0;const l=e=>{if(0===e.length)return[];const t=[...e];t.sort(((e,t)=>{let[r]=e,[n]=t;return r===n?0:r>n?1:-1}));return(0,d.arrayReduce)(t,((e,t)=>{let[r,n]=t;const s=e[e.length-1],[o,i]=s,a=o+i;if(r<=a){const e=Math.max(n-(a-r),0);s[1]+=e}else e.push([r,n]);return e}),[t[0]])};switch(e){case"insert_row_below":case"insert_row_above":const a=F.countSourceRows();if(q.maxRows===a)return;const h="insert_row_below"===e?"below":"above";t=null!==(r=t)&&void 0!==r?r:"below"===h?a:0;const{delta:u,startPhysicalIndex:c}=V.createRow(t,s,{source:o,mode:h});if(u){const e=J.selectedRange.current(),t=null==e?void 0:e.from,r=null==t?void 0:t.row,n=F.toVisualRow(c);if(J.isSelectedByCorner())J.selectAll(!0,!0,{disableHeadersHighlight:!0});else if((0,i.isDefined)(r)&&r>=n){const{row:n,col:s}=e.to;let o=t.col;J.isSelectedByRowHeader()&&(o=-1),J.getSelectedRange().pop(),J.setRangeStartOnly(F._createCellCoords(r+u,o),!0),J.setRangeEnd(F._createCellCoords(n+u,s))}else F._refreshBorders()}break;case"insert_col_start":case"insert_col_end":const p="insert_col_end"===e?"end":"start";t=null!==(n=t)&&void 0!==n?n:"end"===p?F.countSourceCols():0;const{delta:g,startPhysicalIndex:f}=V.createCol(t,s,{source:o,mode:p});if(g){if(Array.isArray(q.colHeaders)){const e=[F.toVisualColumn(f),0];e.length+=g,Array.prototype.splice.apply(q.colHeaders,e)}const e=J.selectedRange.current(),t=null==e?void 0:e.from,r=null==t?void 0:t.col,n=F.toVisualColumn(f);if(J.isSelectedByCorner())J.selectAll(!0,!0,{disableHeadersHighlight:!0});else if((0,i.isDefined)(r)&&r>=n){const{row:n,col:s}=e.to;let o=t.row;J.isSelectedByColumnHeader()&&(o=-1),J.getSelectedRange().pop(),J.setRangeStartOnly(F._createCellCoords(o,r+g),!0),J.setRangeEnd(F._createCellCoords(n,s+g))}else F._refreshBorders()}break;case"remove_row":const m=e=>{let t=0;(0,d.arrayEach)(e,(e=>{let[r,n]=e;const s=(0,i.isEmpty)(r)?F.countRows()-1:Math.max(r-t,0);Number.isInteger(r)&&(r=Math.max(r-t,0));if(!V.removeRow(r,n,o))return;const a=F.countRows(),l=q.fixedRowsTop;l>=s+1&&(q.fixedRowsTop-=Math.min(n,l-s));const h=q.fixedRowsBottom;h&&s>=a-h&&(q.fixedRowsBottom-=Math.min(n,h)),t+=n}))};Array.isArray(t)?m(l(t)):m([[t,s]]),W.adjustRowsAndCols(),F._refreshBorders();break;case"remove_col":const E=e=>{let t=0;(0,d.arrayEach)(e,(e=>{let[r,n]=e;const s=(0,i.isEmpty)(r)?F.countCols()-1:Math.max(r-t,0);let a=F.toPhysicalColumn(s);Number.isInteger(r)&&(r=Math.max(r-t,0));if(!V.removeCol(r,n,o))return;const l=q.fixedColumnsStart;l>=s+1&&(q.fixedColumnsStart-=Math.min(n,l-s)),Array.isArray(q.colHeaders)&&(void 0===a&&(a=-1),q.colHeaders.splice(a,n)),t+=n}))};Array.isArray(t)?E(l(t)):E([[t,s]]),W.adjustRowsAndCols(),F._refreshBorders();break;default:throw new Error(`There is no such action "${e}"`)}a||W.adjustRowsAndCols()},adjustRowsAndCols(){const e=q.minRows,t=q.minSpareRows,r=q.minCols,n=q.minSpareCols;if(0===F.countRows()&&0===F.countCols()&&J.deselect(),e){const t=F.countRows();t<e&&V.createRow(t,e-t,{source:"auto"})}if(t){const e=F.countEmptyRows(!0);if(e<t){const r=t-e,n=Math.min(r,q.maxRows-F.countSourceRows());V.createRow(F.countRows(),n,{source:"auto"})}}{let e;(r||n)&&(e=F.countEmptyCols(!0));let t=F.countCols();if(r&&!q.columns&&t<r){const n=r-t;e+=n,V.createCol(t,n,{source:"auto"})}if(n&&!q.columns&&"array"===F.dataType&&e<n){t=F.countCols();const r=n-e,s=Math.min(r,q.maxCols-t);V.createCol(t,s,{source:"auto"})}}if(J.isSelected()){const e=F.countRows(),t=F.countCols();(0,d.arrayEach)(J.selectedRange,(r=>{let n=!1,s=r.from.row,o=r.from.col,i=r.to.row,a=r.to.col;s>e-1?(s=e-1,n=!0,i>s&&(i=s)):i>e-1&&(i=e-1,n=!0,s>i&&(s=i)),o>t-1?(o=t-1,n=!0,a>o&&(a=o)):a>t-1&&(a=t-1,n=!0,o>a&&(o=a)),n&&(o<0?F.selectRows(s,i,o):s<0?F.selectColumns(o,a,s):F.selectCell(s,o,i,a))}))}F.view&&F.view.adjustElementsSize()},populateFromArray(e,t,r,n,s){let o,i,a,l;const h=[],c={},p=[],g=e.row,f=e.col;if(i=t.length,0===i)return!1;let m=0,E=0;switch((0,u.isObject)(r)&&(m=r.col-f+1,E=r.row-g+1),s){case"shift_down":const s=(0,d.pivot)(t),y=s.length,w=Math.max(y,m),C=F.getData().slice(g),R=(0,d.pivot)(C).slice(f,f+w);for(a=0;a<w;a+=1)if(a<y){for(o=0,i=s[a].length;o<E-i;o+=1)s[a].push(s[a][o%i]);a<R.length?p.push(s[a].concat(R[a])):p.push(s[a].concat(new Array(C.length).fill(null)))}else p.push(s[a%y].concat(R[a]));F.populateFromArray(g,f,(0,d.pivot)(p));break;case"shift_right":const v=t.length,S=Math.max(v,E),T=F.getData().slice(g).map((e=>e.slice(f)));for(o=0;o<S;o+=1)if(o<v){for(a=0,l=t[o].length;a<m-l;a+=1)t[o].push(t[o][a%l]);if(o<T.length)for(let e=0;e<T[o].length;e+=1)t[o].push(T[o][e]);else t[o].push(...new Array(T[0].length).fill(null))}else t.push(t[o%i].slice(0,S).concat(T[o]));F.populateFromArray(g,f,t);break;default:c.row=e.row,c.col=e.col;let N,_=0,M=0,A=!0;const b=function(e){let r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;const n=t[e%t.length];return null!==r?n[r%n.length]:n},I=t.length,O=r?r.row-e.row+1:0;for(i=r?O:Math.max(I,O),o=0;o<i&&!(r&&c.row>r.row&&O>I||!q.allowInsertRow&&c.row>F.countRows()-1||c.row>=q.maxRows);o++){const t=o-_,s=b(t).length,d=r?r.col-e.col+1:0;if(l=r?d:Math.max(s,d),c.col=e.col,N=F.getCellMeta(c.row,c.col),"CopyPaste.paste"!==n&&"Autofill.fill"!==n||!N.skipRowOnPaste){for(M=0,a=0;a<l&&!(r&&c.col>r.col&&d>s||!q.allowInsertColumn&&c.col>F.countCols()-1||c.col>=q.maxCols);a++){if(N=F.getCellMeta(c.row,c.col),("CopyPaste.paste"===n||"Autofill.fill"===n)&&N.skipColumnOnPaste){M+=1,c.col+=1,l+=1;continue}if(N.readOnly&&"UndoRedo.undo"!==n){c.col+=1;continue}let e=b(t,a-M),r=F.getDataAtCell(c.row,c.col);if(null!==e&&"object"==typeof e)if(Array.isArray(e)&&null===r&&(r=[]),null===r||"object"!=typeof r)A=!1;else{const t=(0,u.duckSchema)(Array.isArray(r)?r:r[0]||r),n=(0,u.duckSchema)(Array.isArray(e)?e:e[0]||e);(0,u.isObjectEqual)(t,n)||Array.isArray(t)&&Array.isArray(n)?e=(0,u.deepClone)(e):A=!1}else null!==r&&"object"==typeof r&&(A=!1);A&&h.push([c.row,c.col,e]),A=!0,c.col+=1}c.row+=1}else _+=1,c.row+=1,i+=1}F.setDataAtCell(h,null,null,n||"populateFromArray")}}},this.init=function(){B.setData(q.data),F.runHooks("beforeInit"),((0,a.isMobileBrowser)()||(0,a.isIpadOS)())&&(0,s.addClass)(F.rootElement,"mobile"),this.updateSettings(q,!0),this.view=new C.default(this),Y=l.default.getInstance(F,q,J),G=(0,O.createViewportScroller)(F),j=new c.FocusManager(F),(0,T.isRootInstance)(this)&&(0,O.installFocusCatcher)(F),F.runHooks("init"),this.forceFullRender=!0,this.view.render(),z&&null===F.rootElement.offsetParent&&(0,s.observeVisibilityChangeOnce)(F.rootElement,(()=>{F.view._wt.wtOverlays.updateLastSpreaderSize(),F.render(),F.view.adjustElementsSize()})),"object"==typeof z&&(F.runHooks("afterChange",z[0],z[1]),z=!1),F.runHooks("afterInit")},this._createCellCoords=function(e,t){return F.view._wt.createCellCoords(e,t)},this._createCellRange=function(e,t,r){return F.view._wt.createCellRange(e,t,r)},this.validateCell=function(e,t,r,n){let s=F.getCellValidator(t);function a(e){if(!(!(arguments.length>1&&void 0!==arguments[1])||arguments[1])||!0===t.hidden)return void r(e);const n=t.visualCol,s=t.visualRow,o=F.getCell(s,n,!0);if(o&&"TH"!==o.nodeName){const e=F.rowIndexMapper.getRenderableFromVisualIndex(s),t=F.columnIndexMapper.getRenderableFromVisualIndex(n);F.view._wt.getSetting("cellRenderer",e,t,o)}r(e)}var l;(0,i.isRegExp)(s)&&(l=s,s=function(e,t){t(l.test(e))}),(0,o.isFunction)(s)?(e=F.runHooks("beforeValidate",e,t.visualRow,t.prop,n),F._registerImmediate((()=>{s.call(t,e,(r=>{F&&(r=F.runHooks("afterValidate",r,e,t.visualRow,t.prop,n),t.valid=r,a(r),F.runHooks("postAfterValidate",r,e,t.visualRow,t.prop,n))}))}))):F._registerImmediate((()=>{t.valid=!0,a(t.valid,!1)}))},this.setDataAtCell=function(e,t,r,n){const s=ae(e,t,r),o=[];let i,a,l,h=n;for(i=0,a=s.length;i<a;i++){if("object"!=typeof s[i])throw new Error("Method `setDataAtCell` accepts row number or changes array of arrays as its first parameter");if("number"!=typeof s[i][1])throw new Error("Method `setDataAtCell` accepts row and column number as its parameters. If you want to use object property name, use method `setDataAtRowProp`");l=s[i][1]>=this.countCols()?s[i][1]:V.colToProp(s[i][1]),o.push([s[i][0],l,B.getAtCell(this.toPhysicalRow(s[i][0]),s[i][1]),s[i][2]])}h||"object"!=typeof e||(h=t);const u=le(o,n);F.runHooks("afterSetDataAtCell",u,h),oe(u,h,(()=>{ie(u,h)}))},this.setDataAtRowProp=function(e,t,r,n){const s=ae(e,t,r),o=[];let i,a,l=n;for(i=0,a=s.length;i<a;i++)o.push([s[i][0],s[i][1],B.getAtCell(this.toPhysicalRow(s[i][0]),s[i][1]),s[i][2]]);l||"object"!=typeof e||(l=t);const h=le(o,n);F.runHooks("afterSetDataAtRowProp",h,l),oe(h,l,(()=>{ie(h,l)}))},this.listen=function(){F&&!F.isListening()&&(k.forEach((e=>{F!==e&&e.unlisten()})),D=F.guid,F.runHooks("afterListen"))},this.unlisten=function(){this.isListening()&&(D=null,F.runHooks("afterUnlisten"))},this.isListening=function(){return D===F.guid},this.destroyEditor=function(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0],t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];F._refreshBorders(e,t)},this.populateFromArray=function(e,t,r,n,s,o,i){if("object"!=typeof r||"object"!=typeof r[0])throw new Error("populateFromArray parameter `input` must be an array of arrays");const a="number"==typeof n?F._createCellCoords(n,s):null;return W.populateFromArray(F._createCellCoords(e,t),r,a,o,i)},this.spliceCol=function(e,t,r){for(var n=arguments.length,s=new Array(n>3?n-3:0),o=3;o<n;o++)s[o-3]=arguments[o];return V.spliceCol(e,t,r,...s)},this.spliceRow=function(e,t,r){for(var n=arguments.length,s=new Array(n>3?n-3:0),o=3;o<n;o++)s[o-3]=arguments[o];return V.spliceRow(e,t,r,...s)},this.getSelected=function(){if(J.isSelected())return(0,d.arrayMap)(J.getSelectedRange(),(e=>{let{from:t,to:r}=e;return[t.row,t.col,r.row,r.col]}))},this.getSelectedLast=function(){const e=this.getSelected();let t;return e&&e.length>0&&(t=e[e.length-1]),t},this.getSelectedRange=function(){if(J.isSelected())return Array.from(J.getSelectedRange())},this.getSelectedRangeLast=function(){const e=this.getSelectedRange();let t;return e&&e.length>0&&(t=e[e.length-1]),t},this.emptySelectedCells=function(e){if(!J.isSelected()||0===this.countRows()||0===this.countCols())return;const t=[];(0,d.arrayEach)(J.getSelectedRange(),(e=>{if(e.isSingleHeader())return;const r=e.getTopStartCorner(),n=e.getBottomEndCorner();(0,w.rangeEach)(r.row,n.row,(e=>{(0,w.rangeEach)(r.col,n.col,(r=>{this.getCellMeta(e,r).readOnly||t.push([e,r,null])}))}))})),t.length>0&&this.setDataAtCell(t,e)},this.isRenderSuspended=function(){return this.renderSuspendedCounter>0},this.suspendRender=function(){this.renderSuspendedCounter+=1},this.resumeRender=function(){const e=this.renderSuspendedCounter-1;this.renderSuspendedCounter=Math.max(e,0),this.isRenderSuspended()||e!==this.renderSuspendedCounter||(this.renderCall?this.render():this._refreshBorders(null))},this.render=function(){this.view&&(this.renderCall=!0,this.forceFullRender=!0,this.isRenderSuspended()||(Y.lockEditor(),this._refreshBorders(null),Y.unlockEditor()))},this.batchRender=function(e){this.suspendRender();const t=e();return this.resumeRender(),t},this.isExecutionSuspended=function(){return this.executionSuspendedCounter>0},this.suspendExecution=function(){this.executionSuspendedCounter+=1,this.columnIndexMapper.suspendOperations(),this.rowIndexMapper.suspendOperations()},this.resumeExecution=function(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];const t=this.executionSuspendedCounter-1;this.executionSuspendedCounter=Math.max(t,0),(!this.isExecutionSuspended()&&t===this.executionSuspendedCounter||e)&&(this.columnIndexMapper.resumeOperations(),this.rowIndexMapper.resumeOperations())},this.batchExecution=function(e){let t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];this.suspendExecution();const r=e();return this.resumeExecution(t),r},this.batch=function(e){this.suspendRender(),this.suspendExecution();const t=e();return this.resumeExecution(),this.resumeRender(),t},this.refreshDimensions=function(){if(!F.view)return;const{width:e,height:t}=F.view.getLastSize(),{width:r,height:n}=F.rootElement.getBoundingClientRect(),s=r!==e||n!==t;!1===F.runHooks("beforeRefreshDimensions",{width:e,height:t},{width:r,height:n},s)||((s||F.view._wt.wtOverlays.scrollableElement===F.rootWindow)&&(F.view.setLastSize(r,n),F.render()),F.runHooks("afterRefreshDimensions",{width:e,height:t},{width:r,height:n},s))},this.updateData=function(e,t){(0,I.replaceData)(e,(e=>{V=e}),(e=>{V=e,F.columnIndexMapper.fitToLength(this.getInitialColumnCount()),F.rowIndexMapper.fitToLength(this.countSourceRows()),W.adjustRowsAndCols()}),{hotInstance:F,dataMap:V,dataSource:B,internalSource:"updateData",source:t,metaManager:X,firstRun:z})},this.loadData=function(e,t){(0,I.replaceData)(e,(e=>{V=e}),(()=>{X.clearCellsCache(),F.initIndexMappers(),W.adjustRowsAndCols(),z&&(z=[null,"loadData"])}),{hotInstance:F,dataMap:V,dataSource:B,internalSource:"loadData",source:t,metaManager:X,firstRun:z})},this.getInitialColumnCount=function(){const e=q.columns;let t=0;if(Array.isArray(e))t=e.length;else if((0,o.isFunction)(e))if("array"===F.dataType){const r=this.countSourceCols();for(let n=0;n<r;n+=1)e(n)&&(t+=1)}else"object"!==F.dataType&&"function"!==F.dataType||(t=V.colToPropCache.length);else if((0,i.isDefined)(q.dataSchema)){const e=V.getSchema();t=Array.isArray(e)?e.length:(0,u.deepObjectSize)(e)}else t=this.countSourceCols();return t},this.initIndexMappers=function(){this.columnIndexMapper.initToLength(this.getInitialColumnCount()),this.rowIndexMapper.initToLength(this.countSourceRows())},this.getData=function(e,t,r,n){return(0,i.isUndefined)(e)?V.getAll():V.getRange(F._createCellCoords(e,t),F._createCellCoords(r,n),V.DESTINATION_RENDERER)},this.getCopyableText=function(e,t,r,n){return V.getCopyableText(F._createCellCoords(e,t),F._createCellCoords(r,n))},this.getCopyableData=function(e,t){return V.getCopyable(e,V.colToProp(t))},this.getSchema=function(){return V.getSchema()},this.updateSettings=function(e){let t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];const r=(z?F.loadData:F.updateData).bind(this);let n,s,a=!1;if((0,i.isDefined)(e.rows))throw new Error('The "rows" setting is no longer supported. Do you mean startRows, minRows or maxRows?');if((0,i.isDefined)(e.cols))throw new Error('The "cols" setting is no longer supported. Do you mean startCols, minCols or maxCols?');if((0,i.isDefined)(e.ganttChart))throw new Error('Since 8.0.0 the "ganttChart" setting is no longer supported.');for(n in e)"data"===n||("language"===n?te(e.language):"className"===n?re("className",e.className):"tableClassName"===n&&F.table?(re("tableClassName",e.tableClassName),F.view._wt.wtOverlays.syncOverlayTableClassNames()):_.default.getSingleton().isRegistered(n)||_.default.getSingleton().isDeprecated(n)?((0,o.isFunction)(e[n])||Array.isArray(e[n]))&&(e[n].initialHook=!0,F.addHook(n,e[n])):!t&&(0,u.hasOwnProperty)(e,n)&&(Q[n]=e[n]));void 0===e.data&&void 0===q.data?r(null,"updateSettings"):void 0!==e.data?r(e.data,"updateSettings"):void 0!==e.columns&&(V.createMap(),F.initIndexMappers());const l=F.countCols(),h=q.columns;if(h&&(0,o.isFunction)(h)&&(a=!0),void 0===e.cell&&void 0===e.cells&&void 0===e.columns||X.clearCache(),l>0)for(n=0,s=0;n<l;n++){if(h){const e=a?h(n):h[s];e&&X.updateColumnMeta(s,e)}s+=1}(0,i.isDefined)(e.cell)&&(0,u.objectEach)(e.cell,(e=>{F.setCellMetaObject(e.row,e.col,e)})),F.runHooks("afterCellMetaReset");let c=F.rootElement.style.height;""!==c&&(c=parseInt(F.rootElement.style.height,10));let d=e.height;if((0,o.isFunction)(d)&&(d=d()),t){F.rootElement.getAttribute("style")&&F.rootElement.setAttribute("data-initialstyle",F.rootElement.getAttribute("style"))}if(null===d){const e=F.rootElement.getAttribute("data-initialstyle");e&&(e.indexOf("height")>-1||e.indexOf("overflow")>-1)?F.rootElement.setAttribute("style",e):(F.rootElement.style.height="",F.rootElement.style.overflow="")}else void 0!==d&&(F.rootElement.style.height=isNaN(d)?`${d}`:`${d}px`,F.rootElement.style.overflow="hidden");if(void 0!==e.width){let t=e.width;(0,o.isFunction)(t)&&(t=t()),F.rootElement.style.width=isNaN(t)?`${t}`:`${t}px`}t||(F.view&&(F.view._wt.wtViewport.resetHasOversizedColumnHeadersMarked(),F.view._wt.exportSettingsAsClassNames()),F.runHooks("afterUpdateSettings",e)),W.adjustRowsAndCols(),F.view&&!z&&(F.forceFullRender=!0,Y.lockEditor(),F._refreshBorders(null),F.view._wt.wtOverlays.adjustElementsSize(),Y.unlockEditor()),t||!F.view||""!==c&&""!==d&&void 0!==d||c===d||F.view._wt.wtOverlays.updateMainScrollableElements()},this.getValue=function(){const e=F.getSelectedLast();if(q.getValue){if((0,o.isFunction)(q.getValue))return q.getValue.call(F);if(e)return F.getData()[e[0][0]][q.getValue]}else if(e)return F.getDataAtCell(e[0],e[1])},this.getSettings=function(){return q},this.clear=function(){this.selectAll(),this.emptySelectedCells()},this.alter=function(e,t,r,n,s){W.alter(e,t,r,n,s)},this.getCell=function(e,t){let r=arguments.length>2&&void 0!==arguments[2]&&arguments[2],n=t,s=e;if(t>=0){if(this.columnIndexMapper.isHidden(this.toPhysicalColumn(t)))return null;n=this.columnIndexMapper.getRenderableFromVisualIndex(t)}if(e>=0){if(this.rowIndexMapper.isHidden(this.toPhysicalRow(e)))return null;s=this.rowIndexMapper.getRenderableFromVisualIndex(e)}return null===s||null===n?null:F.view.getCellAtCoords(F._createCellCoords(s,n),r)},this.getCoords=function(e){const t=this.view._wt.wtTable.getCoords(e);if(null===t)return null;const{row:r,col:n}=t;let s=r,o=n;return r>=0&&(s=this.rowIndexMapper.getVisualFromRenderableIndex(r)),n>=0&&(o=this.columnIndexMapper.getVisualFromRenderableIndex(n)),F._createCellCoords(s,o)},this.colToProp=function(e){return V.colToProp(e)},this.propToCol=function(e){return V.propToCol(e)},this.toVisualRow=e=>this.rowIndexMapper.getVisualFromPhysicalIndex(e),this.toVisualColumn=e=>this.columnIndexMapper.getVisualFromPhysicalIndex(e),this.toPhysicalRow=e=>this.rowIndexMapper.getPhysicalFromVisualIndex(e),this.toPhysicalColumn=e=>this.columnIndexMapper.getPhysicalFromVisualIndex(e),this.getDataAtCell=function(e,t){return V.get(e,V.colToProp(t))},this.getDataAtRowProp=function(e,t){return V.get(e,t)},this.getDataAtCol=function(e){const t=[],r=V.getRange(F._createCellCoords(0,e),F._createCellCoords(q.data.length-1,e),V.DESTINATION_RENDERER);for(let e=0;e<r.length;e+=1)for(let n=0;n<r[e].length;n+=1)t.push(r[e][n]);return t},this.getDataAtProp=function(e){const t=[],r=V.getRange(F._createCellCoords(0,V.propToCol(e)),F._createCellCoords(q.data.length-1,V.propToCol(e)),V.DESTINATION_RENDERER);for(let e=0;e<r.length;e+=1)for(let n=0;n<r[e].length;n+=1)t.push(r[e][n]);return t},this.getSourceData=function(e,t,r,n){let s;return s=void 0===e?B.getData():B.getByRange(F._createCellCoords(e,t),F._createCellCoords(r,n)),s},this.getSourceDataArray=function(e,t,r,n){let s;return s=void 0===e?B.getData(!0):B.getByRange(F._createCellCoords(e,t),F._createCellCoords(r,n),!0),s},this.getSourceDataAtCol=function(e){return B.getAtColumn(e)},this.setSourceDataAtCell=function(e,t,r,n){const s=ae(e,t,r),o=this.hasHook("afterSetSourceDataAtCell"),a=[];o&&(0,d.arrayEach)(s,(e=>{let[t,r,n]=e;a.push([t,r,B.getAtCell(t,r),n])})),(0,d.arrayEach)(s,(e=>{let[t,r,n]=e;B.setAtCell(t,r,n)})),o&&this.runHooks("afterSetSourceDataAtCell",a,n),this.render();const l=F.getActiveEditor();l&&(0,i.isDefined)(l.refreshValue)&&l.refreshValue()},this.getSourceDataAtRow=function(e){return B.getAtRow(e)},this.getSourceDataAtCell=function(e,t){return B.getAtCell(e,t)},this.getDataAtRow=function(e){return V.getRange(F._createCellCoords(e,0),F._createCellCoords(e,this.countCols()-1),V.DESTINATION_RENDERER)[0]||[]},this.getDataType=function(e,t,r,n){const s=void 0===e?[0,0,this.countRows(),this.countCols()]:[e,t,r,n],[o,i]=s;let[,,a,l]=s,h=null,u=null;void 0===a&&(a=o),void 0===l&&(l=i);let c="mixed";return(0,w.rangeEach)(Math.max(Math.min(o,a),0),Math.max(o,a),(e=>{let t=!0;return(0,w.rangeEach)(Math.max(Math.min(i,l),0),Math.max(i,l),(r=>{const n=this.getCellMeta(e,r);return u=n.type,h?t=h===u:h=u,t})),c=t?u:"mixed",t})),c},this.removeCellMeta=function(e,t,r){const[n,s]=[this.toPhysicalRow(e),this.toPhysicalColumn(t)];let o=X.getCellMetaKeyValue(n,s,r);!1!==F.runHooks("beforeRemoveCellMeta",e,t,r,o)&&(X.removeCellMeta(n,s,r),F.runHooks("afterRemoveCellMeta",e,t,r,o)),o=null},this.spliceCellsMeta=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;for(var r=arguments.length,n=new Array(r>2?r-2:0),s=2;s<r;s++)n[s-2]=arguments[s];if(n.length>0&&!Array.isArray(n[0]))throw new Error("The 3rd argument (cellMetaRows) has to be passed as an array of cell meta objects array.");t>0&&X.removeRow(this.toPhysicalRow(e),t),n.length>0&&(0,d.arrayEach)(n.reverse(),(t=>{X.createRow(this.toPhysicalRow(e)),(0,d.arrayEach)(t,((t,r)=>this.setCellMetaObject(e,r,t)))})),F.render()},this.setCellMetaObject=function(e,t,r){"object"==typeof r&&(0,u.objectEach)(r,((r,n)=>{this.setCellMeta(e,t,n,r)}))},this.setCellMeta=function(e,t,r,n){if(!1===F.runHooks("beforeSetCellMeta",e,t,r,n))return;let s=e,o=t;e<this.countRows()&&(s=this.toPhysicalRow(e)),t<this.countCols()&&(o=this.toPhysicalColumn(t)),X.setCellMeta(s,o,r,n),F.runHooks("afterSetCellMeta",e,t,r,n)},this.getCellsMeta=function(){return X.getCellsMeta()},this.getCellMeta=function(e,t){let r=this.toPhysicalRow(e),n=this.toPhysicalColumn(t);return null===r&&(r=e),null===n&&(n=t),X.getCellMeta(r,n,{visualRow:e,visualColumn:t})},this.getCellMetaAtRow=function(e){return X.getCellsMetaAtRow(e)},this.isColumnModificationAllowed=function(){return!("object"===F.dataType||q.columns)},this.getCellRenderer=function(e,t){const r="number"==typeof e?F.getCellMeta(e,t).renderer:e.renderer;return"string"==typeof r?(0,f.getRenderer)(r):(0,i.isUndefined)(r)?(0,f.getRenderer)("text"):r},this.getCellEditor=function(e,t){const r="number"==typeof e?F.getCellMeta(e,t).editor:e.editor;return"string"==typeof r?(0,m.getEditor)(r):(0,i.isUndefined)(r)?(0,m.getEditor)("text"):r},this.getCellValidator=function(e,t){const r="number"==typeof e?F.getCellMeta(e,t).validator:e.validator;return"string"==typeof r?(0,E.getValidator)(r):r},this.validateCells=function(e){this._validateCells(e)},this.validateRows=function(e,t){if(!Array.isArray(e))throw new Error("validateRows parameter `rows` must be an array");this._validateCells(t,e)},this.validateColumns=function(e,t){if(!Array.isArray(e))throw new Error("validateColumns parameter `columns` must be an array");this._validateCells(t,void 0,e)},this._validateCells=function(e,t,r){const n=new ne;e&&(n.onQueueEmpty=e);let s=F.countRows()-1;for(;s>=0;){if(void 0!==t&&-1===t.indexOf(s)){s-=1;continue}let e=F.countCols()-1;for(;e>=0;)void 0===r||-1!==r.indexOf(e)?(n.addValidatorToQueue(),F.validateCell(F.getDataAtCell(s,e),F.getCellMeta(s,e),(e=>{if("boolean"!=typeof e)throw new Error("Validation error: result is not boolean");!1===e&&(n.valid=!1),n.removeValidatorFormQueue()}),"validateCells"),e-=1):e-=1;s-=1}n.checkIfQueueIsEmpty()},this.getRowHeader=function(e){let t=q.rowHeaders,r=e;return void 0!==r&&(r=F.runHooks("modifyRowHeader",r)),void 0===r?(t=[],(0,w.rangeEach)(F.countRows()-1,(e=>{t.push(F.getRowHeader(e))}))):Array.isArray(t)&&void 0!==t[r]?t=t[r]:(0,o.isFunction)(t)?t=t(r):t&&"string"!=typeof t&&"number"!=typeof t&&(t=r+1),t},this.hasRowHeaders=function(){return!!q.rowHeaders},this.hasColHeaders=function(){if(void 0!==q.colHeaders&&null!==q.colHeaders)return!!q.colHeaders;for(let e=0,t=F.countCols();e<t;e++)if(F.getColHeader(e))return!0;return!1},this.getColHeader=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:-1;const r=F.runHooks("modifyColHeader",e);if(void 0===r){const e=[],t=F.countCols();for(let r=0;r<t;r++)e.push(F.getColHeader(r));return e}let n=q.colHeaders;const s=F.toPhysicalColumn(r),i=function(e){const t=[],r=F.countCols();let n=0;for(;n<r;n++)(0,o.isFunction)(q.columns)&&q.columns(n)&&t.push(n);return t[e]}(s);return!1===q.colHeaders?n=null:q.columns&&(0,o.isFunction)(q.columns)&&q.columns(i)&&q.columns(i).title?n=q.columns(i).title:q.columns&&q.columns[s]&&q.columns[s].title?n=q.columns[s].title:Array.isArray(q.colHeaders)&&void 0!==q.colHeaders[s]?n=q.colHeaders[s]:(0,o.isFunction)(q.colHeaders)?n=q.colHeaders(s):q.colHeaders&&"string"!=typeof q.colHeaders&&"number"!=typeof q.colHeaders&&(n=(0,v.spreadsheetColumnLabel)(r)),n=F.runHooks("modifyColumnHeaderValue",n,e,t),n},this._getColWidthFromSettings=function(e){let t;if(e>=0){t=F.getCellMeta(0,e).width}if(void 0!==t&&t!==q.width||(t=q.colWidths),null!=t){switch(typeof t){case"object":t=t[e];break;case"function":t=t(e)}"string"==typeof t&&(t=parseInt(t,10))}return t},this.getColWidth=function(e){let t=F._getColWidthFromSettings(e);return t=F.runHooks("modifyColWidth",t,e),void 0===t&&(t=N.ViewportColumnsCalculator.DEFAULT_WIDTH),t},this._getRowHeightFromSettings=function(e){let t=q.rowHeights;if(null!=t){switch(typeof t){case"object":t=t[e];break;case"function":t=t(e)}"string"==typeof t&&(t=parseInt(t,10))}return t},this.getRowHeight=function(e){let t=F._getRowHeightFromSettings(e);return t=F.runHooks("modifyRowHeight",t,e),t},this.countSourceRows=function(){return B.countRows()},this.countSourceCols=function(){return B.countFirstRowKeys()},this.countRows=function(){return V.getLength()},this.countCols=function(){const e=q.maxCols,t=this.columnIndexMapper.getNotTrimmedIndexesLength();return Math.min(e,t)},this.countRenderedRows=function(){return F.view._wt.drawn?F.view._wt.wtTable.getRenderedRowsCount():-1},this.countVisibleRows=function(){return F.view._wt.drawn?F.view._wt.wtTable.getVisibleRowsCount():-1},this.countRenderedCols=function(){return F.view._wt.drawn?F.view._wt.wtTable.getRenderedColumnsCount():-1},this.countVisibleCols=function(){return F.view._wt.drawn?F.view._wt.wtTable.getVisibleColumnsCount():-1},this.countRowHeaders=function(){return this.view.getRowHeadersCount()},this.countColHeaders=function(){return this.view.getColumnHeadersCount()},this.countEmptyRows=function(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0],t=0;return(0,w.rangeEachReverse)(F.countRows()-1,(r=>{if(F.isEmptyRow(r))t+=1;else if(!0===e)return!1})),t},this.countEmptyCols=function(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0],t=0;return(0,w.rangeEachReverse)(F.countCols()-1,(r=>{if(F.isEmptyCol(r))t+=1;else if(!0===e)return!1})),t},this.isEmptyRow=function(e){return q.isEmptyRow.call(F,e)},this.isEmptyCol=function(e){return q.isEmptyCol.call(F,e)},this.selectCell=function(e,t,r,n){let s=!(arguments.length>4&&void 0!==arguments[4])||arguments[4],o=!(arguments.length>5&&void 0!==arguments[5])||arguments[5];return!(0,i.isUndefined)(e)&&!(0,i.isUndefined)(t)&&this.selectCells([[e,t,r,n]],s,o)},this.selectCells=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[[]],t=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];!1===(!(arguments.length>1&&void 0!==arguments[1])||arguments[1])&&G.suspend();const r=J.selectCells(e);return r&&t&&F.listen(),G.resume(),r},this.selectColumns=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:e,r=arguments.length>2?arguments[2]:void 0;return J.selectColumns(e,t,r)},this.selectRows=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:e,r=arguments.length>2?arguments[2]:void 0;return J.selectRows(e,t,r)},this.deselectCell=function(){J.deselect()},this.selectAll=function(){let e=!(arguments.length>0&&void 0!==arguments[0])||arguments[0],t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:e,r=arguments.length>2?arguments[2]:void 0;G.skipNextScrollCycle(),J.selectAll(e,t,r)};const he=(e,t)=>e.getNearestNotHiddenIndex(t,1,!0);this.scrollViewportTo=function(e){var t,r;"number"==typeof e&&(e={row:arguments[0],col:arguments[1],verticalSnap:arguments[2]?"bottom":"top",horizontalSnap:arguments[3]?"end":"start",considerHiddenIndexes:null===(r=arguments[4])||void 0===r||r});const{row:n,col:s,verticalSnap:o,horizontalSnap:i,considerHiddenIndexes:a}=null!==(t=e)&&void 0!==t?t:{};let l,h,u,c;void 0!==o&&(l="top"===o,h=!l),void 0!==i&&(u="start"===i,c=!u);let d=n,p=s;if(void 0===a||a){const e=Number.isInteger(n)&&n>=0,t=Number.isInteger(s)&&s>=0,r=e?he(this.rowIndexMapper,n):void 0,o=t?he(this.columnIndexMapper,s):void 0;if(null===r||null===o)return!1;d=e?F.rowIndexMapper.getRenderableFromVisualIndex(r):n,p=t?F.columnIndexMapper.getRenderableFromVisualIndex(o):s}const g=Number.isInteger(d),f=Number.isInteger(p);return g&&d>=0&&f&&p>=0?F.view.scrollViewport(F._createCellCoords(d,p),l,c,h,u):g&&d>=0&&(f&&p<0||!f)?F.view.scrollViewportVertically(d,l,h):!!(f&&p>=0&&(g&&d<0||!g))&&F.view.scrollViewportHorizontally(p,c,u)},this.scrollToFocusedCell=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:()=>{};if(!this.selection.isSelected())return;this.addHookOnce("afterScroll",e);const{highlight:t}=this.getSelectedRangeLast();this.scrollViewportTo(t.toObject())?this.view.render():(this.removeHook("afterScroll",e),this._registerImmediate((()=>e())))},this.destroy=function(){if(F._clearTimeouts(),F._clearImmediates(),F.view&&F.view.destroy(),B&&B.destroy(),B=null,this.getShortcutManager().destroy(),X.clearCache(),k.delete(this.guid),(0,T.isRootInstance)(F)){const e=this.rootDocument.querySelector(".hot-display-license-info");e&&e.parentNode.removeChild(e)}(0,s.empty)(F.rootElement),U.destroy(),Y&&Y.destroy(),F.batchExecution((()=>{F.rowIndexMapper.unregisterAll(),F.columnIndexMapper.unregisterAll(),Z.getItems().forEach((e=>{let[,t]=e;t.destroy()})),Z.clear(),F.runHooks("afterDestroy")}),!0),_.default.getSingleton().destroy(F),(0,u.objectEach)(F,((e,t,r)=>{var n;(0,o.isFunction)(e)?r[t]=(n=t,()=>{throw new Error(`The "${n}" method cannot be called because this Handsontable instance has been destroyed`)}):"guid"!==t&&(r[t]=null)})),F.isDestroyed=!0,V&&V.destroy(),V=null,W=null,J=null,Y=null,F=null},this.getActiveEditor=function(){return Y.getActiveEditor()},this.getPlugin=function(e){const t=(0,y.toUpperCaseFirst)(e);return"UndoRedo"===t?this.undoRedo:Z.getItem(t)},this.getPluginName=function(e){return e===this.undoRedo?this.undoRedo.constructor.PLUGIN_KEY:Z.getId(e)},this.getInstance=function(){return F},this.addHook=function(e,t){_.default.getSingleton().add(e,t,F)},this.hasHook=function(e){return _.default.getSingleton().has(e,F)||_.default.getSingleton().has(e)},this.addHookOnce=function(e,t){_.default.getSingleton().once(e,t,F)},this.removeHook=function(e,t){_.default.getSingleton().remove(e,t,F)},this.runHooks=function(e,t,r,n,s,o,i){return _.default.getSingleton().run(F,e,t,r,n,s,o,i)},this.getTranslatedPhrase=function(e,t){return(0,M.getTranslatedPhrase)(q.language,e,t)},this.toHTML=()=>(0,p.instanceToHTML)(this),this.toTableElement=()=>{const e=this.rootDocument.createElement("div");return e.insertAdjacentHTML("afterbegin",(0,p.instanceToHTML)(this)),e.firstElementChild},this.timeouts=[],this._registerTimeout=function(e){let t=e;"function"==typeof t&&(t=setTimeout(t,arguments.length>1&&void 0!==arguments[1]?arguments[1]:0)),this.timeouts.push(t)},this._clearTimeouts=function(){(0,d.arrayEach)(this.timeouts,(e=>{clearTimeout(e)}))},this.immediates=[],this._registerImmediate=function(e){this.immediates.push(setImmediate(e))},this._clearImmediates=function(){(0,d.arrayEach)(this.immediates,(e=>{clearImmediate(e)}))},this._refreshBorders=function(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0],t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];Y.destroyEditor(e),F.view.render(),t&&J.isSelected()&&Y.prepareEditor()},this._getEditorManager=function(){return Y},this.isRtl=function(){return"rtl"===F.rootWindow.getComputedStyle(F.rootElement).direction},this.isLtr=function(){return!F.isRtl()},this.getDirectionFactor=function(){return F.isLtr()?1:-1};const ue=(0,P.createShortcutManager)({handleEvent:()=>F.isListening(),beforeKeyDown:e=>this.runHooks("beforeKeyDown",e),afterKeyDown:e=>{this.isDestroyed||F.runHooks("afterDocumentKeyDown",e)},ownerWindow:this.rootWindow});this.addHook("beforeOnCellMouseDown",(e=>{!1===e.ctrlKey&&!1===e.metaKey&&ue.releasePressedKeys()})),this.getShortcutManager=function(){return ue},this.getFocusManager=function(){return j},(0,g.getPluginsNames)().forEach((e=>{const t=(0,g.getPlugin)(e);Z.addItem(e,new t(this))})),(0,L.registerAllShortcutContexts)(F),ue.setActiveContextName("grid"),_.default.getSingleton().run(F,"construct")},r(67834),r(15724),r(71766);var s=r(49536),o=r(25735),i=r(67508),a=r(1479),l=n(r(6637)),h=n(r(63286)),u=r(58460),c=r(24638),d=r(98758),p=r(33050),g=r(9415),f=r(94539),m=r(39761),E=r(19434),y=r(69114),w=r(27050),C=n(r(81212)),R=n(r(26499)),v=r(37671),S=r(65686),T=r(26048),N=r(6697),_=n(r(37056)),M=r(63055),A=r(51127),b=r(78700),I=r(56988),O=r(75893),x=r(22781),P=r(5061),L=r(52684);let D=null;const k=new Map;new Set},13436:(e,t,r)=>{"use strict";t.__esModule=!0,t.installFocusDetector=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const r=e.rootElement,n=o(e),s=o(e);return n.addEventListener("focus",(()=>null==t?void 0:t.onFocusFromTop())),s.addEventListener("focus",(()=>null==t?void 0:t.onFocusFromBottom())),r.firstChild.before(n),r.lastChild.after(s),{activate(){e._registerTimeout((()=>{n.tabIndex=0,s.tabIndex=0}),10)},deactivate(){e._registerTimeout((()=>{n.tabIndex=-1,s.tabIndex=-1}),10)}}};var n=r(49536),s=r(81595);function o(e){const t=e.rootDocument.createElement("input");return t.type="text",t.classList.add("htFocusCatcher"),e.getSettings().ariaTags&&(0,n.setAttribute)(t,[(0,s.A11Y_PRESENTATION)(),(0,s.A11Y_HIDDEN)()]),t}},70994:(e,t,r)=>{"use strict";t.__esModule=!0,t.installFocusCatcher=function(e){const t=function(e){return t=>{if(!t)return null;const r=o(e),n=i(e);return t.col<r.col&&(t.col=r.col),t.col>n.col&&(t.col=n.col),t.row<r.row&&(t.row=r.row),t.row>n.row&&(t.row=n.row),t}}(e);let r;const{activate:a,deactivate:l}=(0,s.installFocusDetector)(e,{onFocusFromTop(){var n;const s=null!==(n=t(r))&&void 0!==n?n:o(e);s&&(e.runHooks("modifyFocusOnTabNavigation","from_above",s),e.selectCell(s.row,s.col)),e.listen()},onFocusFromBottom(){var n;const s=null!==(n=t(r))&&void 0!==n?n:i(e);s&&(e.runHooks("modifyFocusOnTabNavigation","from_below",s),e.selectCell(s.row,s.col)),e.listen()}}),h={wrapped:!1,flipped:!1};let u=!0,c=!1,d=!1;e.addHook("afterListen",(()=>l())),e.addHook("afterUnlisten",(()=>a())),e.addHook("afterSelection",((t,n,s,o,i)=>{var a;(c&&(h.wrapped&&h.flipped||d)&&(d=!1,i.value=!0),u)&&(r=null===(a=e.getSelectedRangeLast())||void 0===a?void 0:a.highlight)})),e.addHook("beforeRowWrap",((e,t,r)=>{h.wrapped=!0,h.flipped=r}));const p={keys:[["Tab"],["Shift","Tab"]],preventDefault:!1,stopPropagation:!1,relativeToGroup:n.GRID_GROUP,group:"focusCatcher"};e.getShortcutManager().getContext("grid").addShortcuts([{...p,callback:()=>{const{tabNavigation:t}=e.getSettings();c=!0,e.getSelectedRangeLast()&&!t&&(u=!1),t||(d=!0)},position:"before"},{...p,callback:t=>{const{tabNavigation:n,autoWrapRow:s}=e.getSettings();if(c=!1,u=!0,!n||!e.selection.isSelected()||s&&h.wrapped&&h.flipped||!s&&h.wrapped)return s&&h.wrapped&&h.flipped&&(r=t.shiftKey?o(e):i(e)),h.wrapped=!1,h.flipped=!1,e.deselectCell(),e.unlisten(),!1;t.preventDefault()},position:"after"}])};var n=r(52684),s=r(13436);function o(e){const{rowIndexMapper:t,columnIndexMapper:r}=e,{navigableHeaders:n}=e.getSettings();let s=n&&e.countColHeaders()>0?-e.countColHeaders():0,o=n&&e.countRowHeaders()>0?-e.countRowHeaders():0;return 0===s&&(s=t.getVisualFromRenderableIndex(s)),0===o&&(o=r.getVisualFromRenderableIndex(o)),null===s||null===o?null:e._createCellCoords(s,o)}function i(e){var t,r;const{rowIndexMapper:n,columnIndexMapper:s}=e,{navigableHeaders:o}=e.getSettings();let i=n.getRenderableIndexesLength()-1,a=s.getRenderableIndexesLength()-1;if(i<0){if(!o||0===e.countColHeaders())return null;i=-1}if(a<0){if(!o||0===e.countColHeaders())return null;a=-1}return e._createCellCoords(null!==(t=n.getVisualFromRenderableIndex(i))&&void 0!==t?t:i,null!==(r=s.getVisualFromRenderableIndex(a))&&void 0!==r?r:a)}},75893:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(70994);Object.keys(n).forEach((function(e){"default"!==e&&"__esModule"!==e&&(e in t&&t[e]===n[e]||(t[e]=n[e]))}));var s=r(49697);Object.keys(s).forEach((function(e){"default"!==e&&"__esModule"!==e&&(e in t&&t[e]===s[e]||(t[e]=s[e]))}))},49697:(e,t,r)=>{"use strict";t.__esModule=!0,t.createViewportScroller=function(e){const{selection:t}=e;let r=!1,u=!1;return{resume(){u=!1},suspend(){u=!0},skipNextScrollCycle(){r=!0},scrollTo(c){var d;if(r||u)return void(r=!1);let p;t.isFocusSelectionChanged()?p=(0,o.focusScrollStrategy)(e):t.isSelectedByCorner()?p=(0,s.cornerHeaderScrollStrategy)(e):t.isSelectedByRowHeader()?p=(0,l.rowHeaderScrollStrategy)(e):t.isSelectedByColumnHeader()?p=(0,n.columnHeaderScrollStrategy)(e):1===t.getSelectedRange().size()&&t.isMultiple()?p=(0,i.multipleScrollStrategy)(e):1!==t.getSelectedRange().size()||t.isMultiple()?t.getSelectedRange().size()>1&&(p=(0,a.noncontiguousScrollStrategy)(e)):p=(0,h.singleScrollStrategy)(e),null===(d=p)||void 0===d||d(c)}}};var n=r(34710),s=r(32373),o=r(47315),i=r(85817),a=r(8088),l=r(35126),h=r(51829)},34710:(e,t)=>{"use strict";t.__esModule=!0,t.columnHeaderScrollStrategy=function(e){return t=>{let{col:r}=t;e.scrollViewportTo({col:r})}}},32373:(e,t)=>{"use strict";t.__esModule=!0,t.cornerHeaderScrollStrategy=function(){return()=>{}}},47315:(e,t)=>{"use strict";t.__esModule=!0,t.focusScrollStrategy=function(e){return t=>{e.scrollViewportTo(t.toObject())}}},85817:(e,t)=>{"use strict";t.__esModule=!0,t.multipleScrollStrategy=function(e){return t=>{e.scrollViewportTo(t.toObject())}}},8088:(e,t)=>{"use strict";t.__esModule=!0,t.noncontiguousScrollStrategy=function(e){return t=>{e.scrollViewportTo(t.toObject())}}},35126:(e,t)=>{"use strict";t.__esModule=!0,t.rowHeaderScrollStrategy=function(e){return t=>{let{row:r}=t;e.scrollViewportTo({row:r})}}},51829:(e,t)=>{"use strict";t.__esModule=!0,t.singleScrollStrategy=function(e){return t=>{const r=e.selection.getSelectionSource(),{row:n,col:s}=t;if(n<0&&s>=0)e.scrollViewportTo({col:s});else if(s<0&&n>=0)e.scrollViewportTo({row:n});else{if("mouse"===r&&(s===e.view.getLastPartiallyVisibleColumn()||n===e.view.getLastPartiallyVisibleRow()))return;e.scrollViewportTo({row:n,col:s})}}}},35078:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724);var s=n(r(85707)),o=r(70389),i=r(37671),a=r(58460),l=r(98758),h=r(27050),u=r(67508);class c{static get DESTINATION_RENDERER(){return 1}static get DESTINATION_CLIPBOARD_GENERATOR(){return 2}constructor(e,t,r){(0,s.default)(this,"hot",void 0),(0,s.default)(this,"metaManager",void 0),(0,s.default)(this,"tableMeta",void 0),(0,s.default)(this,"dataSource",void 0),(0,s.default)(this,"duckSchema",void 0),(0,s.default)(this,"colToPropCache",void 0),(0,s.default)(this,"propToColCache",void 0),this.hot=e,this.metaManager=r,this.tableMeta=r.getTableMeta(),this.dataSource=t,this.duckSchema=this.createDuckSchema(),this.createMap()}createMap(){const e=this.getSchema();if(void 0===e)throw new Error("trying to create `columns` definition but you didn't provide `schema` nor `data`");const t=this.tableMeta.columns;let r;if(this.colToPropCache=[],this.propToColCache=new Map,t){let n=0,s=0,o=!1;if("function"==typeof t){const t=(0,a.deepObjectSize)(e);n=t>0?t:this.countFirstRowKeys(),o=!0}else{const e=this.tableMeta.maxCols;n=Math.min(e,t.length)}for(r=0;r<n;r++){const e=o?t(r):t[r];if((0,a.isObject)(e)){if(void 0!==e.data){const t=o?s:r;this.colToPropCache[t]=e.data,this.propToColCache.set(e.data,t)}s+=1}}}else this.recursiveDuckColumns(e)}countFirstRowKeys(){return(0,i.countFirstRowKeys)(this.dataSource)}recursiveDuckColumns(e,t,r){let n,s=t,o=r;return void 0===s&&(s=0,o=""),"object"!=typeof e||Array.isArray(e)||(0,a.objectEach)(e,((e,t)=>{null===e?(n=o+t,this.colToPropCache.push(n),this.propToColCache.set(n,s),s+=1):s=this.recursiveDuckColumns(e,s,`${t}.`)})),s}colToProp(e){if(!1===Number.isInteger(e))return e;const t=this.hot.toPhysicalColumn(e);return null===t?e:this.colToPropCache&&(0,u.isDefined)(this.colToPropCache[t])?this.colToPropCache[t]:t}propToCol(e){const t=this.propToColCache.get(e);if((0,u.isDefined)(t))return this.hot.toVisualColumn(t);const r=this.hot.toVisualColumn(e);return null===r?e:r}getSchema(){const e=this.tableMeta.dataSchema;return e?"function"==typeof e?e():e:this.duckSchema}createDuckSchema(){return this.dataSource&&this.dataSource[0]?(0,a.duckSchema)(this.dataSource[0]):{}}refreshDuckSchema(){this.duckSchema=this.createDuckSchema()}createRow(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,{source:r,mode:n="above"}=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const s=this.hot.countSourceRows();let o=s,i=0,l=e;("number"!=typeof l||l>=s)&&(l=s),l<this.hot.countRows()&&(o=this.hot.toPhysicalRow(l));if(!1===this.hot.runHooks("beforeCreateRow",l,t,r)||null===o)return{delta:0};const u=this.tableMeta.maxRows,c=this.getSchema().length,d=[];for(;i<t&&s+i<u;){let e=null;"array"===this.hot.dataType?this.tableMeta.dataSchema?e=(0,a.deepClone)(this.getSchema()):(e=[],(0,h.rangeEach)(c-1,(()=>e.push(null)))):"function"===this.hot.dataType?e=this.tableMeta.dataSchema(l+i):(e={},(0,a.deepExtend)(e,this.getSchema())),d.push(e),i+=1}this.hot.rowIndexMapper.insertIndexes(l,i),"below"===n&&(o=Math.min(o+1,s)),this.spliceData(o,0,d);const p=this.hot.toVisualRow(o);return this.hot.countSourceRows()===d.length&&this.hot.columnIndexMapper.initToLength(this.hot.getInitialColumnCount()),i>0&&(null==e?this.metaManager.createRow(null,i):"auto"!==r&&this.metaManager.createRow(o,t)),this.hot.runHooks("afterCreateRow",p,i,r),this.hot.forceFullRender=!0,{delta:i,startPhysicalIndex:o}}createCol(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,{source:r,mode:n="start"}=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(!this.hot.isColumnModificationAllowed())throw new Error("Cannot create new column. When data source in an object, you can only have as much columns as defined in first data row, data schema or in the 'columns' setting.If you want to be able to add new columns, you have to use array datasource.");const s=this.dataSource,o=this.tableMeta.maxCols,i=this.hot.countSourceCols();let a=e;("number"!=typeof a||a>=i)&&(a=i);if(!1===this.hot.runHooks("beforeCreateCol",a,t,r))return{delta:0};let l=i;a<this.hot.countCols()&&(l=this.hot.toPhysicalColumn(a));const h=this.hot.countSourceRows();let u=this.hot.countCols(),c=0,d=l;"end"===n&&(d=Math.min(d+1,i));const p=d;for(;c<t&&u<o;){if("number"!=typeof a||a>=u)if(h>0)for(let e=0;e<h;e+=1)void 0===s[e]&&(s[e]=[]),s[e].push(null);else s.push([null]);else for(let e=0;e<h;e++)s[e].splice(d,0,null);c+=1,d+=1,u+=1}this.hot.columnIndexMapper.insertIndexes(a,c),c>0&&(null==e?this.metaManager.createColumn(null,c):"auto"!==r&&this.metaManager.createColumn(p,t));const g=this.hot.toVisualColumn(p);return this.hot.runHooks("afterCreateCol",g,c,r),this.hot.forceFullRender=!0,this.refreshDuckSchema(),{delta:c,startPhysicalIndex:p}}removeRow(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,r=arguments.length>2?arguments[2]:void 0,n=Number.isInteger(e)?e:-t;const s=this.visualRowsToPhysical(n,t),o=this.hot.countSourceRows();n=(o+n)%o;if(!1===this.hot.runHooks("beforeRemoveRow",n,s.length,s,r))return!1;const i=s.length;if(this.filterData(n,i,s),n<this.hot.countRows()){this.hot.rowIndexMapper.removeIndexes(s);const e=(0,u.isDefined)(this.tableMeta.columns)||(0,u.isDefined)(this.tableMeta.dataSchema);0===this.hot.rowIndexMapper.getNotTrimmedIndexesLength()&&!1===e&&this.hot.columnIndexMapper.setIndexesSequence([])}return s.slice(0).sort(((e,t)=>t-e)).forEach((e=>{this.metaManager.removeRow(e,1)})),this.hot.runHooks("afterRemoveRow",n,i,s,r),this.hot.forceFullRender=!0,!0}removeCol(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,r=arguments.length>2?arguments[2]:void 0;if("object"===this.hot.dataType||this.tableMeta.columns)throw new Error("cannot remove column with object data source or columns option specified");let n="number"!=typeof e?-t:e;n=(this.hot.countCols()+n)%this.hot.countCols();const s=this.visualColumnsToPhysical(n,t),o=s.slice(0).sort(((e,t)=>t-e));if(!1===this.hot.runHooks("beforeRemoveCol",n,t,s,r))return!1;let i=!0;const a=o.length,l=this.dataSource;for(let e=0;e<a;e++)i&&s[0]!==s[e]-e&&(i=!1);if(i)for(let e=0,r=this.hot.countSourceRows();e<r;e++)l[e].splice(s[0],t),0===e&&this.metaManager.removeColumn(s[0],t);else for(let e=0,t=this.hot.countSourceRows();e<t;e++)for(let t=0;t<a;t++)l[e].splice(o[t],1),0===e&&this.metaManager.removeColumn(o[t],1);return n<this.hot.countCols()&&(this.hot.columnIndexMapper.removeIndexes(s),0===this.hot.columnIndexMapper.getNotTrimmedIndexesLength()&&this.hot.rowIndexMapper.setIndexesSequence([])),this.hot.runHooks("afterRemoveCol",n,t,s,r),this.hot.forceFullRender=!0,this.refreshDuckSchema(),!0}spliceCol(e,t,r){const n=this.hot.getDataAtCol(e),s=n.slice(t,t+r),o=n.slice(t+r);for(var i=arguments.length,a=new Array(i>3?i-3:0),h=3;h<i;h++)a[h-3]=arguments[h];(0,l.extendArray)(a,o);let u=0;for(;u<r;)a.push(null),u+=1;return(0,l.to2dArray)(a),this.hot.populateFromArray(t,e,a,null,null,"spliceCol"),s}spliceRow(e,t,r){const n=this.hot.getSourceDataAtRow(e),s=n.slice(t,t+r),o=n.slice(t+r);for(var i=arguments.length,a=new Array(i>3?i-3:0),h=3;h<i;h++)a[h-3]=arguments[h];(0,l.extendArray)(a,o);let u=0;for(;u<r;)a.push(null),u+=1;return this.hot.populateFromArray(e,t,[a],null,null,"spliceRow"),s}spliceData(e,t,r){if(!1!==this.hot.runHooks("beforeDataSplice",e,t,r)){const t=[...this.dataSource.slice(0,e),...r,...this.dataSource.slice(e)];this.dataSource.length=0,t.forEach((e=>this.dataSource.push(e)))}}filterData(e,t,r){let n=this.hot.runHooks("filterData",e,t,r);!1===Array.isArray(n)&&(n=this.dataSource.filter(((e,t)=>-1===r.indexOf(t)))),this.dataSource.length=0,Array.prototype.push.apply(this.dataSource,n)}get(e,t){const r=this.hot.toPhysicalRow(e);let n=this.dataSource[r];const s=this.hot.runHooks("modifyRowData",r);n=isNaN(s)?s:n;let o=null;if(n&&n.hasOwnProperty&&(0,a.hasOwnProperty)(n,t))o=n[t];else if("string"==typeof t&&t.indexOf(".")>-1){const e=t.split(".");let r=n;if(!r)return null;for(let t=0,n=e.length;t<n;t++)if(r=r[e[t]],void 0===r)return null;o=r}else"function"==typeof t&&(o=t(this.dataSource.slice(r,r+1)[0]));if(this.hot.hasHook("modifyData")){const e=(0,a.createObjectPropListener)(o);this.hot.runHooks("modifyData",r,this.propToCol(t),e,"get"),e.isTouched()&&(o=e.value)}return o}getCopyable(e,t){return this.hot.getCellMeta(e,this.propToCol(t)).copyable?this.get(e,t):""}set(e,t,r){const n=this.hot.toPhysicalRow(e);let s=r,o=this.dataSource[n];const i=this.hot.runHooks("modifyRowData",n);if(o=isNaN(i)?i:o,this.hot.hasHook("modifyData")){const e=(0,a.createObjectPropListener)(s);this.hot.runHooks("modifyData",n,this.propToCol(t),e,"set"),e.isTouched()&&(s=e.value)}if(o&&o.hasOwnProperty&&(0,a.hasOwnProperty)(o,t))o[t]=s;else if("string"==typeof t&&t.indexOf(".")>-1){const e=t.split(".");let r,n=o,i=0;for(i=0,r=e.length-1;i<r;i++)void 0===n[e[i]]&&(n[e[i]]={}),n=n[e[i]];n[e[i]]=s}else"function"==typeof t?t(this.dataSource.slice(n,n+1)[0],s):o[t]=s}visualRowsToPhysical(e,t){const r=this.hot.countSourceRows(),n=[];let s,o=(r+e)%r,i=t;for(;o<r&&i;)s=this.hot.toPhysicalRow(o),n.push(s),i-=1,o+=1;return n}visualColumnsToPhysical(e,t){const r=this.hot.countCols(),n=[];let s=(r+e)%r,o=t;for(;s<r&&o;){const e=this.hot.toPhysicalColumn(s);n.push(e),o-=1,s+=1}return n}clear(){for(let e=0;e<this.hot.countSourceRows();e++)for(let t=0;t<this.hot.countCols();t++)this.set(e,this.colToProp(t),"")}getLength(){const e=this.tableMeta.maxRows;let t;t=e<0||0===e?0:e||1/0;const r=this.hot.rowIndexMapper.getNotTrimmedIndexesLength();return Math.min(r,t)}getAll(){const e={row:0,col:0},t={row:Math.max(this.hot.countRows()-1,0),col:Math.max(this.hot.countCols()-1,0)};return e.row-t.row!=0||this.hot.countSourceRows()?this.getRange(e,t,c.DESTINATION_RENDERER):[]}countCachedColumns(){return this.colToPropCache.length}getRange(e,t,r){const n=[];let s,o,i;const a=this.tableMeta.maxRows,l=this.tableMeta.maxCols;if(0===a||0===l)return[];const h=r===c.DESTINATION_CLIPBOARD_GENERATOR?this.getCopyable:this.get,u=Math.min(Math.max(a-1,0),Math.max(e.row,t.row)),d=Math.min(Math.max(l-1,0),Math.max(e.col,t.col));for(s=Math.min(e.row,t.row);s<=u;s++){i=[];const r=s>=0?this.hot.toPhysicalRow(s):s;for(o=Math.min(e.col,t.col);o<=d&&null!==r;o++)i.push(h.call(this,s,this.colToProp(o)));null!==r&&n.push(i)}return n}getText(e,t){return(0,o.stringify)(this.getRange(e,t,c.DESTINATION_RENDERER))}getCopyableText(e,t){return(0,o.stringify)(this.getRange(e,t,c.DESTINATION_CLIPBOARD_GENERATOR))}destroy(){this.hot=null,this.metaManager=null,this.dataSource=null,this.duckSchema=null,this.colToPropCache.length=0,this.propToColCache.clear(),this.propToColCache=void 0}}t.default=c},26499:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724);var s=n(r(85707)),o=r(58460),i=r(37671),a=r(98758),l=r(27050),h=r(25735);t.default=class{constructor(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];(0,s.default)(this,"hot",void 0),(0,s.default)(this,"data",void 0),(0,s.default)(this,"dataType","array"),(0,s.default)(this,"colToProp",(()=>{})),(0,s.default)(this,"propToCol",(()=>{})),this.hot=e,this.data=t}modifyRowData(e){let t;return this.hot.hasHook("modifyRowData")&&(t=this.hot.runHooks("modifyRowData",e)),void 0===t||Number.isInteger(t)?this.data[e]:t}getData(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];return this.data&&0!==this.data.length?this.getByRange(null,null,e):this.data}setData(e){this.data=e}getAtColumn(e){const t=[];return(0,a.arrayEach)(this.data,((r,n)=>{const s=this.getAtCell(n,e);t.push(s)})),t}getAtRow(e,t,r){let n=arguments.length>3&&void 0!==arguments[3]&&arguments[3];const s=void 0===t&&void 0===r;let i=null,a=null;if(i=this.modifyRowData(e),Array.isArray(i))a=[],s?i.forEach(((t,r)=>{a[r]=this.getAtPhysicalCell(e,r,i)})):(0,l.rangeEach)(t,r,(r=>{a[r-t]=this.getAtPhysicalCell(e,r,i)}));else if((0,o.isObject)(i)||(0,h.isFunction)(i))if(a=n?[]:{},!s||n){const s=0,h=this.countFirstRowKeys()-1;(0,l.rangeEach)(s,h,(l=>{const u=this.colToProp(l);if(l>=(t||s)&&l<=(r||h)&&!Number.isInteger(u)){const t=this.getAtPhysicalCell(e,u,i);n?a.push(t):(0,o.setProperty)(a,u,t)}}))}else(0,o.objectEach)(i,((t,r)=>{(0,o.setProperty)(a,r,this.getAtPhysicalCell(e,r,i))}));return a}setAtCell(e,t,r){if(!(e>=this.countRows()||t>=this.countFirstRowKeys())){if(this.hot.hasHook("modifySourceData")){const n=(0,o.createObjectPropListener)(r);this.hot.runHooks("modifySourceData",e,t,n,"set"),n.isTouched()&&(r=n.value)}Number.isInteger(t)?this.data[e][t]=r:(0,o.setProperty)(this.data[e],t,r)}}getAtPhysicalCell(e,t,r){let n=null;if(r&&(n="string"==typeof t?(0,o.getProperty)(r,t):"function"==typeof t?t(r):r[t]),this.hot.hasHook("modifySourceData")){const r=(0,o.createObjectPropListener)(n);this.hot.runHooks("modifySourceData",e,t,r,"get"),r.isTouched()&&(n=r.value)}return n}getAtCell(e,t){const r=this.modifyRowData(e);return this.getAtPhysicalCell(e,this.colToProp(t),r)}getByRange(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,r=arguments.length>2&&void 0!==arguments[2]&&arguments[2],n=!1,s=null,o=null,i=null,a=null;null===e||null===t?(n=!0,s=0,i=this.countRows()-1):(s=Math.min(e.row,t.row),o=Math.min(e.col,t.col),i=Math.max(e.row,t.row),a=Math.max(e.col,t.col));const h=[];return(0,l.rangeEach)(s,i,(e=>{h.push(n?this.getAtRow(e,void 0,void 0,r):this.getAtRow(e,o,a,r))})),h}countRows(){if(this.hot.hasHook("modifySourceLength")){const e=this.hot.runHooks("modifySourceLength");if(Number.isInteger(e))return e}return this.data.length}countFirstRowKeys(){return(0,i.countFirstRowKeys)(this.data)}destroy(){this.data=null,this.hot=null}}},56988:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(35078));t.DataMap=s.default;var o=n(r(10615));t.MetaManager=o.default;var i=n(r(51909));t.metaSchemaFactory=i.default;var a=r(52604);t.replaceData=a.replaceData;var l=r(37313);t.DynamicCellMetaMod=l.DynamicCellMetaMod;var h=r(36645);t.ExtendMetaPropertiesMod=h.ExtendMetaPropertiesMod},10615:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(7649)),o=n(r(69502)),i=n(r(4936)),a=n(r(54934)),l=n(r(48499)),h=r(58460);class u{constructor(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:[];this.hot=e,this.globalMeta=new s.default(e),this.tableMeta=new o.default(this.globalMeta),this.columnMeta=new i.default(this.globalMeta),this.cellMeta=new a.default(this.columnMeta),r.forEach((e=>new e(this))),this.globalMeta.updateMeta(t)}getGlobalMeta(){return this.globalMeta.getMeta()}updateGlobalMeta(e){this.globalMeta.updateMeta(e)}getTableMeta(){return this.tableMeta.getMeta()}updateTableMeta(e){this.tableMeta.updateMeta(e)}getColumnMeta(e){return this.columnMeta.getMeta(e)}updateColumnMeta(e,t){this.columnMeta.updateMeta(e,t)}getCellMeta(e,t,r){let{visualRow:n,visualColumn:s}=r;const o=this.cellMeta.getMeta(e,t);return o.visualRow=n,o.visualCol=s,o.row=e,o.col=t,this.runLocalHooks("afterGetCellMeta",o),o}getCellMetaKeyValue(e,t,r){if("string"!=typeof r)throw new Error("The passed cell meta object key is not a string");return this.cellMeta.getMeta(e,t,r)}setCellMeta(e,t,r,n){this.cellMeta.setMeta(e,t,r,n)}updateCellMeta(e,t,r){this.cellMeta.updateMeta(e,t,r)}removeCellMeta(e,t,r){this.cellMeta.removeMeta(e,t,r)}getCellsMeta(){return this.cellMeta.getMetas()}getCellsMetaAtRow(e){return this.cellMeta.getMetasAtRow(e)}createRow(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;this.cellMeta.createRow(e,t)}removeRow(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;this.cellMeta.removeRow(e,t)}createColumn(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;this.cellMeta.createColumn(e,t),this.columnMeta.createColumn(e,t)}removeColumn(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;this.cellMeta.removeColumn(e,t),this.columnMeta.removeColumn(e,t)}clearCellsCache(){this.cellMeta.clearCache()}clearCache(){this.cellMeta.clearCache(),this.columnMeta.clearCache()}}t.default=u,(0,h.mixin)(u,l.default)},257:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724);var s=n(r(85707)),o=r(98758),i=r(30594);class a{constructor(e){(0,s.default)(this,"valueFactory",void 0),(0,s.default)(this,"data",[]),(0,s.default)(this,"index",[]),(0,s.default)(this,"holes",new Set),this.valueFactory=e}obtain(e){(0,i.assert)((()=>(0,i.isUnsignedNumber)(e)),"Expecting an unsigned number.");const t=this._getStorageIndexByKey(e);let r;if(t>=0)r=this.data[t],void 0===r&&(r=this.valueFactory(e),this.data[t]=r);else if(r=this.valueFactory(e),this.holes.size>0){const t=this.holes.values().next().value;this.holes.delete(t),this.data[t]=r,this.index[e]=t}else this.data.push(r),this.index[e]=this.data.length-1;return r}insert(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;(0,i.assert)((()=>(0,i.isUnsignedNumber)(e)||(0,i.isNullish)(e)),"Expecting an unsigned number or null/undefined argument.");const r=[],n=this.data.length;for(let e=0;e<t;e++)r.push(n+e),this.data.push(void 0);const s=(0,i.isNullish)(e)?this.index.length:e;this.index=[...this.index.slice(0,s),...r,...this.index.slice(s)]}remove(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;(0,i.assert)((()=>(0,i.isUnsignedNumber)(e)||(0,i.isNullish)(e)),"Expecting an unsigned number or null/undefined argument.");const r=this.index.splice((0,i.isNullish)(e)?this.index.length-t:e,t);for(let e=0;e<r.length;e++){const t=r[e];"number"==typeof t&&this.holes.add(t)}}size(){return this.data.length-this.holes.size}values(){return(0,o.arrayFilter)(this.data,((e,t)=>!this.holes.has(t)))[Symbol.iterator]()}entries(){const e=[];for(let t=0;t<this.data.length;t++){const r=this._getKeyByStorageIndex(t);-1!==r&&e.push([r,this.data[t]])}let t=0;return{next:()=>{if(t<e.length){const r=e[t];return t+=1,{value:r,done:!1}}return{done:!0}}}}clear(){this.data=[],this.index=[],this.holes.clear()}_getStorageIndexByKey(e){return this.index.length>e?this.index[e]:-1}_getKeyByStorageIndex(e){return this.index.indexOf(e)}[Symbol.iterator](){return this.entries()}}t.default=a},54934:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724);var s=n(r(85707)),o=r(58460),i=r(30594),a=n(r(257)),l=r(67508);t.default=class{constructor(e){(0,s.default)(this,"columnMeta",void 0),(0,s.default)(this,"metas",new a.default((()=>this._createRow()))),this.columnMeta=e}updateMeta(e,t,r){const n=this.getMeta(e,t);(0,o.extend)(n,r),(0,i.extendByMetaType)(n,r)}createRow(e,t){this.metas.insert(e,t)}createColumn(e,t){for(let r=0;r<this.metas.size();r++)this.metas.obtain(r).insert(e,t)}removeRow(e,t){this.metas.remove(e,t)}removeColumn(e,t){for(let r=0;r<this.metas.size();r++)this.metas.obtain(r).remove(e,t)}getMeta(e,t,r){const n=this.metas.obtain(e).obtain(t);return void 0===r?n:n[r]}setMeta(e,t,r,n){var s;const o=this.metas.obtain(e).obtain(t);null===(s=o._automaticallyAssignedMetaProps)||void 0===s||s.delete(r),o[r]=n}removeMeta(e,t,r){delete this.metas.obtain(e).obtain(t)[r]}getMetas(){const e=[],t=Array.from(this.metas.values());for(let r=0;r<t.length;r++)(0,l.isDefined)(t[r])&&e.push(...t[r].values());return e}getMetasAtRow(e){(0,i.assert)((()=>(0,i.isUnsignedNumber)(e)),"Expecting an unsigned number.");const t=new Map(this.metas);return t.has(e)?Array.from(t.get(e).values()):[]}clearCache(){this.metas.clear()}_createRow(){return new a.default((e=>this._createMeta(e)))}_createMeta(e){return new(this.columnMeta.getMetaConstructor(e))}}},4936:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),o=r(58460),i=r(30594),a=n(r(257));const l=["data","width"];t.default=class{constructor(e){(0,s.default)(this,"globalMeta",void 0),(0,s.default)(this,"metas",new a.default((()=>this._createMeta()))),this.globalMeta=e,this.metas=new a.default((()=>this._createMeta()))}updateMeta(e,t){const r=this.getMeta(e);(0,o.extend)(r,t),(0,i.extendByMetaType)(r,t)}createColumn(e,t){this.metas.insert(e,t)}removeColumn(e,t){this.metas.remove(e,t)}getMeta(e){return this.metas.obtain(e)}getMetaConstructor(e){return this.metas.obtain(e).constructor}clearCache(){this.metas.clear()}_createMeta(){return(0,i.columnFactory)(this.globalMeta.getMetaConstructor(),l).prototype}}},7649:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),o=r(58460),i=r(30594),a=n(r(51909));t.default=class{constructor(e){(0,s.default)(this,"metaCtor",class{}),(0,s.default)(this,"meta",void 0),this.meta=this.metaCtor.prototype,(0,o.extend)(this.meta,(0,a.default)()),this.meta.instance=e}getMetaConstructor(){return this.metaCtor}getMeta(){return this.meta}updateMeta(e){var t;(0,o.extend)(this.meta,e),(0,i.extendByMetaType)(this.meta,{...e,type:null!==(t=e.type)&&void 0!==t?t:this.meta.type},e)}}},69502:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),o=r(58460),i=r(30594);t.default=class{constructor(e){(0,s.default)(this,"meta",void 0);const t=e.getMetaConstructor();this.meta=new t}getMeta(){return this.meta}updateMeta(e){(0,o.extend)(this.meta,e),(0,i.extendByMetaType)(this.meta,e,e)}}},51909:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(67508),s=r(58460);t.default=()=>({_automaticallyAssignedMetaProps:void 0,activeHeaderClassName:"ht__active_highlight",allowEmpty:!0,allowHtml:!1,allowInsertColumn:!0,allowInsertRow:!0,allowInvalid:!0,allowRemoveColumn:!0,allowRemoveRow:!0,ariaTags:!0,autoColumnSize:void 0,autoRowSize:void 0,autoWrapCol:!1,autoWrapRow:!1,bindRowsWithHeaders:void 0,cell:[],cells:void 0,checkedTemplate:void 0,className:void 0,colHeaders:null,collapsibleColumns:void 0,columnHeaderHeight:void 0,columns:void 0,columnSorting:void 0,columnSummary:void 0,colWidths:void 0,commentedCellClassName:"htCommentCell",comments:!1,contextMenu:void 0,copyable:!0,copyPaste:!0,correctFormat:!1,currentColClassName:void 0,currentHeaderClassName:"ht__highlight",currentRowClassName:void 0,customBorders:!1,data:void 0,dataSchema:void 0,dateFormat:"DD/MM/YYYY",datePickerConfig:void 0,defaultDate:void 0,disableVisualSelection:!1,dragToScroll:!0,dropdownMenu:void 0,editor:void 0,enterBeginsEditing:!0,enterMoves:{col:0,row:1},fillHandle:{autoInsertRow:!1},filter:!0,filteringCaseSensitive:!1,filters:void 0,fixedColumnsLeft:0,fixedColumnsStart:0,fixedRowsBottom:0,fixedRowsTop:0,formulas:void 0,fragmentSelection:!1,height:void 0,hiddenColumns:void 0,hiddenRows:void 0,invalidCellClassName:"htInvalid",imeFastEdit:!1,isEmptyCol(e){let t,r,s;for(t=0,r=this.countRows();t<r;t++)if(s=this.getDataAtCell(t,e),!1===(0,n.isEmpty)(s))return!1;return!0},isEmptyRow(e){let t,r,o,i;for(t=0,r=this.countCols();t<r;t++)if(o=this.getDataAtCell(e,t),!1===(0,n.isEmpty)(o))return"object"==typeof o&&(i=this.getCellMeta(e,t),(0,s.isObjectEqual)(this.getSchema()[i.prop],o));return!0},label:void 0,language:"en-US",layoutDirection:"inherit",licenseKey:void 0,locale:"en-US",manualColumnFreeze:void 0,manualColumnMove:void 0,manualColumnResize:void 0,manualRowMove:void 0,manualRowResize:void 0,maxCols:1/0,maxRows:1/0,mergeCells:!1,minCols:0,minRows:0,minSpareCols:0,minSpareRows:0,multiColumnSorting:void 0,navigableHeaders:!1,tabNavigation:!0,nestedHeaders:void 0,nestedRows:void 0,noWordWrapClassName:"htNoWrap",numericFormat:void 0,observeDOMVisibility:!0,outsideClickDeselects:!0,persistentState:void 0,placeholder:void 0,placeholderCellClassName:"htPlaceholder",preventOverflow:!1,preventWheel:!1,readOnly:!1,readOnlyCellClassName:"htDimmed",renderAllRows:!1,renderAllColumns:!1,renderer:void 0,rowHeaders:void 0,rowHeaderWidth:void 0,rowHeights:void 0,search:!1,selectionMode:"multiple",selectOptions:void 0,skipColumnOnPaste:!1,skipRowOnPaste:!1,sortByRelevance:!0,source:void 0,startCols:5,startRows:5,stretchH:"none",strict:void 0,tableClassName:void 0,tabMoves:{row:0,col:1},title:void 0,trimDropdown:!0,trimRows:void 0,trimWhitespace:!0,type:"text",uncheckedTemplate:void 0,undo:void 0,validator:void 0,viewportColumnRenderingOffset:"auto",viewportRowRenderingOffset:"auto",visibleRows:10,width:void 0,wordWrap:!0})},37313:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),o=n(r(37056)),i=r(58460),a=r(25735);t.DynamicCellMetaMod=class{constructor(e){(0,s.default)(this,"metaManager",void 0),(0,s.default)(this,"metaSyncMemo",new Map),this.metaManager=e,e.addLocalHook("afterGetCellMeta",(e=>this.extendCellMeta(e))),o.default.getSingleton().add("beforeRender",(e=>{e&&this.metaSyncMemo.clear()}),this.metaManager.hot)}extendCellMeta(e){var t;const{row:r,col:n}=e;if(null!==(t=this.metaSyncMemo.get(r))&&void 0!==t&&t.has(n))return;const{visualRow:s,visualCol:o}=e,l=this.metaManager.hot,h=l.colToProp(o);e.prop=h,l.runHooks("beforeGetCellMeta",s,o,e);const u=(0,i.hasOwnProperty)(e,"type")?e.type:null;let c=(0,a.isFunction)(e.cells)?e.cells(r,n,h):null;var d;u&&(c?c.type=null!==(d=c.type)&&void 0!==d?d:u:c={type:u});c&&this.metaManager.updateCellMeta(r,n,c),l.runHooks("afterGetCellMeta",s,o,e),this.metaSyncMemo.has(r)||this.metaSyncMemo.set(r,new Set),this.metaSyncMemo.get(r).add(n)}}},36645:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707));t.ExtendMetaPropertiesMod=class{constructor(e){(0,s.default)(this,"metaManager",void 0),(0,s.default)(this,"usageTracker",new Set),(0,s.default)(this,"propDescriptors",new Map([["ariaTags",{onChange(e,t,r){if(!r)throw new Error(`The \`${e}\` option can not be updated after the Handsontable instance was initialized.`)}}],["fixedColumnsLeft",{target:"fixedColumnsStart",onChange(e){if(this.metaManager.hot.isRtl()&&"fixedColumnsLeft"===e)throw new Error("The `fixedColumnsLeft` is not supported for RTL. Please use option `fixedColumnsStart`.");if(this.usageTracker.has("fixedColumnsLeft")&&this.usageTracker.has("fixedColumnsStart"))throw new Error("The `fixedColumnsLeft` and `fixedColumnsStart` should not be used together. Please use only the option `fixedColumnsStart`.")}}],["layoutDirection",{onChange(e,t,r){if(!r)throw new Error(`The \`${e}\` option can not be updated after the Handsontable is initialized.`)}}]])),this.metaManager=e,this.extendMetaProps()}extendMetaProps(){this.propDescriptors.forEach(((e,t)=>{const{target:r,onChange:n=(()=>{})}=e,s="string"==typeof r,o=s?r:t,i=`_${o}`;this.metaManager.globalMeta.meta[i]=this.metaManager.globalMeta.meta[o],this.installPropWatcher(t,i,n),s&&this.installPropWatcher(r,i,n)}))}installPropWatcher(e,t,r){const n=this;Object.defineProperty(this.metaManager.globalMeta.meta,e,{get(){return this[t]},set(s){const o=!n.usageTracker.has(e);n.usageTracker.add(e),r.call(n,e,s,o),this[t]=s},enumerable:!0,configurable:!0})}}},30594:(e,t,r)=>{"use strict";t.__esModule=!0,t.assert=function(e,t){if(!e())throw new Error(`Assertion failed: ${t}`)},t.columnFactory=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];function r(){}(0,n.inherit)(r,e);for(let e=0;e<t.length;e++)r.prototype[t[e]]=void 0;return r},t.extendByMetaType=function(e,t){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:e;const o="string"==typeof t.type?(0,s.getCellType)(t.type):t.type;e._automaticallyAssignedMetaProps&&(0,n.objectEach)(t,((t,r)=>{e._automaticallyAssignedMetaProps.delete(r)}));if(!(0,n.isObject)(o))return;r!==e||e._automaticallyAssignedMetaProps||(e._automaticallyAssignedMetaProps=new Set);const i={};(0,n.objectEach)(o,((t,s)=>{var o;(function(e,t){var r;if("CELL_TYPE"===e)return!1;return(null===(r=t._automaticallyAssignedMetaProps)||void 0===r?void 0:r.has(e))||!(0,n.hasOwnProperty)(t,e)})(s,r)&&(i[s]=t,null===(o=e._automaticallyAssignedMetaProps)||void 0===o||o.add(s))})),(0,n.extend)(e,i)},t.isNullish=function(e){return null==e},t.isUnsignedNumber=function(e){return Number.isInteger(e)&&e>=0},r(67834);var n=r(58460),s=r(36528)},52604:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.replaceData=function(e,t,r,n){const{hotInstance:u,dataMap:c,dataSource:d,internalSource:p,source:g,metaManager:f,firstRun:m}=n,E=(0,s.toUpperCaseFirst)(p),y=u.getSettings();Array.isArray(y.dataSchema)?u.dataType="array":(0,o.isFunction)(y.dataSchema)?u.dataType="function":u.dataType="object";c&&c.destroy();e=u.runHooks(`before${E}`,e,m,g);const w=new i.default(u,e,f);if(t(w),"object"==typeof e&&null!==e)e.push&&e.splice||(e=[e]);else{if(null!==e)throw new Error(`${p} only accepts array of objects or array of arrays (${typeof e} given)`);{const t=w.getSchema();let r;e=[];let n=0,s=0;for(n=0,s=y.startRows;n<s;n++)if("object"!==u.dataType&&"function"!==u.dataType||!y.dataSchema)if("array"===u.dataType)r=(0,a.deepClone)(t[0]),e.push(r);else{r=[];for(let e=0,t=y.startCols;e<t;e++)r.push(null);e.push(r)}else r=(0,a.deepClone)(t),e.push(r)}}Array.isArray(e[0])&&(u.dataType="array");y.data=e,w.dataSource=e,d.data=e,d.dataType=u.dataType,d.colToProp=w.colToProp.bind(w),d.propToCol=w.propToCol.bind(w),d.countCachedColumns=w.countCachedColumns.bind(w),r(w),u.runHooks(`after${E}`,e,m,g),m||(u.runHooks("afterChange",null,p),u.render());u.getSettings().ariaTags&&(0,l.setAttribute)(u.rootElement,[(0,h.A11Y_ROWCOUNT)(-1),(0,h.A11Y_COLCOUNT)(u.countCols()+(u.view?u.countRowHeaders():0))])},r(67834),r(15724);var s=r(69114),o=r(25735),i=n(r(35078)),a=r(58460),l=r(49536),h=r(81595)},6637:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),o=r(35592),i=r(24456),a=r(39761),l=n(r(63286)),h=r(67508);function u(e,t){!function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}(e,t),t.add(e)}function c(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}const d=t.SHORTCUTS_GROUP_NAVIGATION="editorManager.navigation";var p=new WeakSet;class g{constructor(e,t,r){u(this,p),(0,s.default)(this,"hot",void 0),(0,s.default)(this,"tableMeta",void 0),(0,s.default)(this,"selection",void 0),(0,s.default)(this,"eventManager",void 0),(0,s.default)(this,"destroyed",!1),(0,s.default)(this,"lock",!1),(0,s.default)(this,"activeEditor",void 0),(0,s.default)(this,"cellProperties",void 0),this.hot=e,this.tableMeta=t,this.selection=r,this.eventManager=new l.default(e),this.hot.addHook("afterDocumentKeyDown",(e=>c(p,this,f).call(this,e))),this.eventManager.addEventListener(this.hot.rootDocument.documentElement,"compositionstart",(e=>{!this.destroyed&&this.hot.isListening()&&this.openEditor("",e)})),this.hot.view._wt.update("onCellDblClick",((e,t,r)=>c(p,this,m).call(this,e,t,r)))}lockEditor(){this.lock=!0}unlockEditor(){this.lock=!1}destroyEditor(e){this.lock||this.closeEditor(e)}getActiveEditor(){return this.activeEditor}prepareEditor(){var e;if(this.lock)return;if(this.activeEditor&&this.activeEditor.isWaiting())return void this.closeEditor(!1,!1,(e=>{e&&this.prepareEditor()}));const t=null===(e=this.hot.getSelectedRangeLast())||void 0===e?void 0:e.highlight;if(!t||t.isHeader())return;const{row:r,col:n}=t,s=this.hot.runHooks("modifyGetCellCoords",r,n);let o=r,i=n;if(Array.isArray(s)&&([o,i]=s),this.cellProperties=this.hot.getCellMeta(o,i),!this.isCellEditable())return void this.clearActiveEditor();const l=this.hot.getCell(r,n,!0);if(l){const e=this.hot.getCellEditor(this.cellProperties),t=this.hot.colToProp(i),s=this.hot.getSourceDataAtCell(this.hot.toPhysicalRow(o),i);this.activeEditor=(0,a.getEditorInstance)(e,this.hot),this.activeEditor.prepare(r,n,t,l,s,this.cellProperties)}}isEditorOpened(){return this.activeEditor&&this.activeEditor.isOpened()}openEditor(e,t){let r=arguments.length>2&&void 0!==arguments[2]&&arguments[2];if(!this.isCellEditable())return void this.clearActiveEditor();const n=this.hot.getSelectedRangeLast();let s=this.hot.runHooks("beforeBeginEditing",n.highlight.row,n.highlight.col,e,t,r);t instanceof MouseEvent&&"boolean"!=typeof s&&(s=0===this.hot.selection.getLayerLevel()&&n.isSingle()),!1!==s?(this.activeEditor||(this.hot.scrollToFocusedCell(),this.prepareEditor()),this.activeEditor&&(r&&this.activeEditor.enableFullEditMode(),this.activeEditor.beginEditing(e,t))):this.clearActiveEditor()}closeEditor(e,t,r){this.activeEditor?this.activeEditor.finishEditing(e,t,r):r&&r(!1)}closeEditorAndSaveChanges(e){this.closeEditor(!1,e)}closeEditorAndRestoreOriginalValue(e){this.closeEditor(!0,e)}clearActiveEditor(){this.activeEditor=void 0}isCellEditable(){const e=this.hot.getSelectedRangeLast();if(!e)return!1;const t=this.hot.getCellEditor(this.cellProperties),{row:r,col:n}=e.highlight,{rowIndexMapper:s,columnIndexMapper:o}=this.hot,i=s.isHidden(this.hot.toPhysicalRow(r))||o.isHidden(this.hot.toPhysicalColumn(n));return!(this.cellProperties.readOnly||!t||i)}moveSelectionAfterEnter(e){const t={..."function"==typeof this.tableMeta.enterMoves?this.tableMeta.enterMoves(e):this.tableMeta.enterMoves};e.shiftKey&&(t.row=-t.row,t.col=-t.col),this.hot.selection.isMultiple()?this.selection.transformFocus(t.row,t.col):this.selection.transformStart(t.row,t.col,!0)}destroy(){this.destroyed=!0,this.eventManager.destroy()}}function f(e){const t=this.hot.getSelectedRangeLast();if(!this.hot.isListening()||!t||t.highlight.isHeader()||(0,i.isImmediatePropagationStopped)(e))return;const{keyCode:r}=e,n=(e.ctrlKey||e.metaKey)&&!e.altKey;if((!this.activeEditor||this.activeEditor&&!this.activeEditor.isWaiting())&&!((0,o.isFunctionKey)(r)||(0,o.isCtrlMetaKey)(r)||n||this.isEditorOpened())){const t=this.hot.getShortcutManager().getContext("editor"),r={runOnlyIf:()=>(0,h.isDefined)(this.hot.getSelected()),group:d};t.addShortcuts([{keys:[["ArrowUp"]],callback:()=>{this.hot.selection.transformStart(-1,0)}},{keys:[["ArrowDown"]],callback:()=>{this.hot.selection.transformStart(1,0)}},{keys:[["ArrowLeft"]],callback:()=>{this.hot.selection.transformStart(0,-1*this.hot.getDirectionFactor())}},{keys:[["ArrowRight"]],callback:()=>{this.hot.selection.transformStart(0,this.hot.getDirectionFactor())}}],r),this.openEditor("",e)}}function m(e,t){t.isCell()&&this.openEditor(null,e,!0)}const E=new WeakMap;g.getInstance=function(e,t,r){let n=E.get(e);return n||(n=new g(e,t,r),E.set(e,n)),n};t.default=g},57847:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724);var s=n(r(85707)),o=r(76545),i=r(98758),a=r(49536),l=r(67508),h=r(69114),u=r(35592),c=r(1479),d=r(6135),p=r(81595);function g(e,t,r){!function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}(e,t),t.set(e,r)}function f(e,t){return e.get(function(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}(e,t))}const m=t.EDITOR_TYPE="autocomplete";var E=new WeakMap;class y extends o.HandsontableEditor{constructor(){super(...arguments),(0,s.default)(this,"query",null),(0,s.default)(this,"strippedChoices",[]),(0,s.default)(this,"rawChoices",[]),g(this,E,this.hot.guid.slice(0,9)),(0,s.default)(this,"sortByRelevance",(function(e,t,r){const n=[],s=[],o=e.length;let i,a,u,c,d=t.length;if(0===o){for(u=0;u<d;u++)s.push(u);return s}for(u=0;u<d;u++){if(a=(0,h.stripTags)((0,l.stringify)(t[u])),r)c=a.indexOf(e);else{const t=this.cellProperties.locale;c=a.toLocaleLowerCase(t).indexOf(e.toLocaleLowerCase(t))}-1!==c&&(i=a.length-c-o,n.push({baseIndex:u,index:c,charsLeft:i,value:a}))}for(n.sort(((e,t)=>{if(-1===t.index)return-1;if(-1===e.index)return 1;if(e.index<t.index)return-1;if(t.index<e.index)return 1;if(e.index===t.index){if(e.charsLeft<t.charsLeft)return-1;if(e.charsLeft>t.charsLeft)return 1}return 0})),u=0,d=n.length;u<d;u++)s.push(n[u].baseIndex);return s}))}static get EDITOR_TYPE(){return m}getValue(){const e=this.rawChoices.find((e=>this.stripValueIfNeeded(e)===this.TEXTAREA.value));return(0,l.isDefined)(e)?e:this.TEXTAREA.value}createElements(){super.createElements(),(0,a.addClass)(this.htContainer,"autocompleteEditor"),(0,a.addClass)(this.htContainer,-1===this.hot.rootWindow.navigator.platform.indexOf("Mac")?"":"htMacScroll"),this.hot.getSettings().ariaTags&&(0,a.setAttribute)(this.TEXTAREA,[(0,p.A11Y_TEXT)(),(0,p.A11Y_COMBOBOX)(),(0,p.A11Y_HASPOPUP)("listbox"),(0,p.A11Y_AUTOCOMPLETE)()])}prepare(e,t,r,n,s,o){super.prepare(e,t,r,n,s,o),this.hot.getSettings().ariaTags&&(0,a.setAttribute)(this.TEXTAREA,[(0,p.A11Y_EXPANDED)("false"),(0,p.A11Y_CONTROLS)(`${f(E,this)}-listbox-${e}-${t}`)])}open(){super.open();const e=void 0===this.cellProperties.trimDropdown||this.cellProperties.trimDropdown,t=this.hot.getSettings().ariaTags,r=Array.isArray(this.cellProperties.source)?this.cellProperties.source:null,n=null==r?void 0:r.length,{row:s,col:o}=this;this.showEditableElement(),this.focus();let i=(0,a.getScrollbarWidth)();0===i&&(0,c.isMacOS)()&&(i+=15),this.addHook("beforeKeyDown",(e=>this.onBeforeKeyDown(e))),this.htEditor.updateSettings({colWidths:e?[(0,a.outerWidth)(this.TEXTAREA)-2]:void 0,width:e?(0,a.outerWidth)(this.TEXTAREA)+i:void 0,autoColumnSize:!0,renderer:(e,s,o,i,h,u,c)=>{(0,d.textRenderer)(e,s,o,i,h,u,c);const{filteringCaseSensitive:g,allowHtml:f,locale:m}=this.cellProperties,E=this.query;let y,w,C=(0,l.stringify)(u);C&&!f&&(y=!0===g?C.indexOf(E):C.toLocaleLowerCase(m).indexOf(E.toLocaleLowerCase(m)),-1!==y&&(w=C.substr(y,E.length),C=C.replace(w,`<strong>${w}</strong>`))),t&&(0,a.setAttribute)(s,[(0,p.A11Y_OPTION)(),...r?[(0,p.A11Y_SETSIZE)(n)]:[],...r?[(0,p.A11Y_POSINSET)(r.indexOf(u)+1)]:[],["id",`${this.htEditor.rootElement.id}_${o}-${i}`]]),s.innerHTML=C},afterSelectionEnd:(e,r)=>{if(t){const t=this.htEditor.getCell(e,r,!0);(0,a.setAttribute)(t,[(0,p.A11Y_SELECTED)()]),(0,a.setAttribute)(this.TEXTAREA,...(0,p.A11Y_ACTIVEDESCENDANT)(t.id))}}}),t&&((0,a.setAttribute)(this.htEditor.view._wt.wtOverlays.wtTable.TABLE,...(0,p.A11Y_PRESENTATION)()),(0,a.setAttribute)(this.htEditor.rootElement,[(0,p.A11Y_LISTBOX)(),(0,p.A11Y_LIVE)("polite"),(0,p.A11Y_RELEVANT)("text"),["id",`${f(E,this)}-listbox-${s}-${o}`]]),(0,a.setAttribute)(this.TEXTAREA,...(0,p.A11Y_EXPANDED)("true"))),this.hot._registerTimeout((()=>{this.queryChoices(this.TEXTAREA.value)}))}close(){this.removeHooksByKey("beforeKeyDown"),super.close(),this.hot.getSettings().ariaTags&&(0,a.setAttribute)(this.TEXTAREA,[(0,p.A11Y_EXPANDED)("false")])}discardEditor(e){super.discardEditor(e),this.hot.view.render()}queryChoices(e){const t=this.cellProperties.source;this.query=e,"function"==typeof t?t.call(this.cellProperties,e,(e=>{this.rawChoices=e,this.updateChoicesList(this.stripValuesIfNeeded(e))})):Array.isArray(t)?(this.rawChoices=t,this.updateChoicesList(this.stripValuesIfNeeded(t))):this.updateChoicesList([])}updateChoicesList(e){const t=(0,a.getCaretPosition)(this.TEXTAREA),r=(0,a.getSelectionEndPosition)(this.TEXTAREA),n=this.cellProperties.sortByRelevance,s=this.cellProperties.filter;let o=null,l=null,h=e;n&&(o=this.sortByRelevance(this.stripValueIfNeeded(this.getValue()),h,this.cellProperties.filteringCaseSensitive));const u=Array.isArray(o)?o.length:0;if(!1===s)u&&(l=o[0]);else{const e=[];for(let t=0,r=h.length;t<r&&!(n&&u<=t);t++)u?e.push(h[o[t]]):e.push(h[t]);l=0,h=e}this.strippedChoices=h,this.htEditor.loadData((0,i.pivot)([h])),0===h.length?this.htEditor.rootElement.style.display="none":(this.htEditor.rootElement.style.display="",this.updateDropdownHeight(),this.flipDropdownIfNeeded(),!0===this.cellProperties.strict&&this.highlightBestMatchingChoice(l)),this.hot.listen(),(0,a.setCaretPosition)(this.TEXTAREA,t,t===r?void 0:r)}flipDropdownIfNeeded(){const e=(0,a.getTrimmingContainer)(this.hot.view._wt.wtTable.TABLE),t=e===this.hot.rootWindow,r=this.cellProperties.preventOverflow;if(t||!t&&(r||"horizontal"===r))return!1;const n=(0,a.offset)(this.TEXTAREA),s=(0,a.outerHeight)(this.TEXTAREA),o=this.getDropdownHeight(),i=e.scrollTop,l=(0,a.outerHeight)(this.hot.view._wt.wtTable.THEAD),h=(0,a.offset)(e),u=n.top-h.top-l+i,c=e.scrollHeight-u-l-s,d=o>c&&u>c;return d?this.flipDropdown(o):this.unflipDropdown(),this.limitDropdownIfNeeded(d?u:c,o),d}limitDropdownIfNeeded(e,t){if(t>e){let r=0,n=0,s=0,o=null;do{s=this.htEditor.getRowHeight(n)||this.htEditor.view._wt.getSetting("defaultRowHeight"),r+=s,n+=1}while(r<e);o=r-s,this.htEditor.flipped&&(this.htEditor.rootElement.style.top=parseInt(this.htEditor.rootElement.style.top,10)+t-o+"px"),this.setDropdownHeight(r-s)}}flipDropdown(e){const t=this.htEditor.rootElement.style;t.position="absolute",t.top=-e+"px",this.htEditor.flipped=!0}unflipDropdown(){const e=this.htEditor.rootElement.style;e.position="absolute",e.top="",this.htEditor.flipped=void 0}updateDropdownHeight(){const e=this.htEditor.getColWidth(0)+(0,a.getScrollbarWidth)(this.hot.rootDocument)+2,t=this.cellProperties.trimDropdown;this.htEditor.updateSettings({height:this.getDropdownHeight(),width:t?void 0:e}),this.htEditor.view._wt.wtTable.alignOverlaysWithTrimmingContainer()}setDropdownHeight(e){this.htEditor.updateSettings({height:e})}highlightBestMatchingChoice(e){"number"==typeof e?this.htEditor.selectCell(e,0,void 0,void 0,void 0,!1):this.htEditor.deselectCell()}getDropdownHeight(){const e=this.htEditor.getRowHeight(0)||23,t=this.cellProperties.visibleRows;return this.strippedChoices.length>=t?t*e:this.strippedChoices.length*e+8}stripValueIfNeeded(e){return this.stripValuesIfNeeded([e])[0]}stripValuesIfNeeded(e){const{allowHtml:t}=this.cellProperties,r=(0,i.arrayMap)(e,(e=>(0,l.stringify)(e)));return(0,i.arrayMap)(r,(e=>t?e:(0,h.stripTags)(e)))}allowKeyEventPropagation(e){const t=this.htEditor.getSelectedRangeLast(),r=t?t.from.row:-1;let n=!1;return e===u.KEY_CODES.ARROW_DOWN&&r>0&&r<this.htEditor.countRows()-1&&(n=!0),e===u.KEY_CODES.ARROW_UP&&r>-1&&(n=!0),n}onBeforeKeyDown(e){if((0,u.isPrintableChar)(e.keyCode)||e.keyCode===u.KEY_CODES.BACKSPACE||e.keyCode===u.KEY_CODES.DELETE||e.keyCode===u.KEY_CODES.INSERT){let t=10;if(e.keyCode===u.KEY_CODES.C&&(e.ctrlKey||e.metaKey))return;this.isOpened()||(t+=10),this.htEditor&&this.hot._registerTimeout((()=>{this.queryChoices(this.TEXTAREA.value)}),t)}}}t.AutocompleteEditor=y},29328:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(57847);t.EDITOR_TYPE=n.EDITOR_TYPE,t.AutocompleteEditor=n.AutocompleteEditor},86861:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),o=r(67508),i=r(58460),a=r(6637),l=n(r(15129)),h=r(49536);const u=t.EDITOR_TYPE="base",c=t.EDITOR_STATE=Object.freeze({VIRGIN:"STATE_VIRGIN",EDITING:"STATE_EDITING",WAITING:"STATE_WAITING",FINISHED:"STATE_FINISHED"}),d=t.SHORTCUTS_GROUP_EDITOR="baseEditor";class p{static get EDITOR_TYPE(){return u}constructor(e){(0,s.default)(this,"hot",void 0),(0,s.default)(this,"state",c.VIRGIN),(0,s.default)(this,"_opened",!1),(0,s.default)(this,"_fullEditMode",!1),(0,s.default)(this,"_closeCallback",null),(0,s.default)(this,"TD",null),(0,s.default)(this,"row",null),(0,s.default)(this,"col",null),(0,s.default)(this,"prop",null),(0,s.default)(this,"originalValue",null),(0,s.default)(this,"cellProperties",null),this.hot=e,this.init()}_fireCallbacks(e){this._closeCallback&&(this._closeCallback(e),this._closeCallback=null)}init(){}getValue(){throw Error("Editor getValue() method unimplemented")}setValue(){throw Error("Editor setValue() method unimplemented")}open(){throw Error("Editor open() method unimplemented")}close(){throw Error("Editor close() method unimplemented")}prepare(e,t,r,n,s,o){this.TD=n,this.row=e,this.col=t,this.prop=r,this.originalValue=s,this.cellProperties=o,this.state=c.VIRGIN}extend(){return class extends this.constructor{}}saveValue(e,t){let r,n,s,i;if(t){const e=this.hot.getSelectedLast();r=Math.max(Math.min(e[0],e[2]),0),n=Math.max(Math.min(e[1],e[3]),0),s=Math.max(e[0],e[2]),i=Math.max(e[1],e[3])}else[r,n,s,i]=[this.row,this.col,null,null];const a=this.hot.runHooks("modifyGetCellCoords",r,n);Array.isArray(a)&&([r,n]=a);const l=this.hot.getShortcutManager().getContext("editor"),h={runOnlyIf:()=>(0,o.isDefined)(this.hot.getSelected()),group:d};this.isInFullEditMode()&&l.addShortcuts([{keys:[["ArrowUp"]],callback:()=>{this.hot.selection.transformStart(-1,0)}},{keys:[["ArrowDown"]],callback:()=>{this.hot.selection.transformStart(1,0)}},{keys:[["ArrowLeft"]],callback:()=>{this.hot.selection.transformStart(0,-1*this.hot.getDirectionFactor())}},{keys:[["ArrowRight"]],callback:()=>{this.hot.selection.transformStart(0,this.hot.getDirectionFactor())}}],h),this.hot.populateFromArray(r,n,e,s,i,"edit")}beginEditing(e,t){if(this.state!==c.VIRGIN)return;const r=this.hot,n=r.rowIndexMapper.getRenderableFromVisualIndex(this.row),s=r.columnIndexMapper.getRenderableFromVisualIndex(this.col);if(r.view.scrollViewport(r._createCellCoords(n,s)),this.state=c.EDITING,this.isInFullEditMode()){const t="string"==typeof e?e:(0,o.stringify)(this.originalValue);this.setValue(t)}this.open(t),this._opened=!0,this.focus(),r.view.render(),r.runHooks("afterBeginEditing",this.row,this.col)}finishEditing(e,t,r){let n;if(r){const e=this._closeCallback;this._closeCallback=t=>{e&&e(t),r(t),this.hot.view.render()}}if(this.isWaiting())return;const s=this.hot.getShortcutManager().getContext("editor");if(s.removeShortcutsByGroup(d),s.removeShortcutsByGroup(a.SHORTCUTS_GROUP_NAVIGATION),this.state!==c.VIRGIN){if(this.state===c.EDITING){if(e)return this.cancelChanges(),void this.hot.view.render();const r=this.getValue();n=this.cellProperties.trimWhitespace?[["string"==typeof r?String.prototype.trim.call(r||""):r]]:[[r]],this.state=c.WAITING,this.saveValue(n,t),this.hot.getCellValidator(this.cellProperties)?this.hot.addHookOnce("postAfterValidate",(e=>{this.state=c.FINISHED,this.discardEditor(e)})):(this.state=c.FINISHED,this.discardEditor(!0))}}else this.hot._registerTimeout((()=>{this._fireCallbacks(!0)}))}cancelChanges(){this.state=c.FINISHED,this.discardEditor()}discardEditor(e){if(this.state===c.FINISHED)if(!1===e&&!0!==this.cellProperties.allowInvalid)this.hot.selectCell(this.row,this.col),this.focus(),this.state=c.EDITING,this._fireCallbacks(!1);else{this.close(),this._opened=!1,this._fullEditMode=!1,this.state=c.VIRGIN,this._fireCallbacks(!0);this.hot.getShortcutManager().setActiveContextName("grid")}}enableFullEditMode(){this._fullEditMode=!0}isInFullEditMode(){return this._fullEditMode}isOpened(){return this._opened}isWaiting(){return this.state===c.WAITING}getEditedCellRect(){var e;const t=this.getEditedCell();if(!t)return;const{wtOverlays:r,wtViewport:n}=this.hot.view._wt,s=this.hot.rootWindow,o=(0,h.offset)(t),i=(0,h.outerWidth)(t),a=(0,h.offset)(this.hot.rootElement),l=(0,h.outerWidth)(this.hot.rootElement),u=r.topOverlay.holder,c=r.inlineStartOverlay.holder,d=u!==s?u.scrollTop:0,p=c!==s?c.scrollLeft:0,g=s.innerWidth-a.left-l,{wtTable:f}=null!==(e=r.getParentOverlay(t))&&void 0!==e?e:this.hot.view._wt,m=f.name,E=["master","inline_start"].includes(m)?d:0,y=["master","top","bottom"].includes(m)?p:0,w=o.top===a.top?0:1;let C=o.top-a.top-w-E,R=0;R=this.hot.isRtl()?s.innerWidth-o.left-i-g-1+y:o.left-a.left-1-y,["top","top_inline_start_corner"].includes(m)&&(C+=r.topOverlay.getOverlayOffset()),["inline_start","top_inline_start_corner"].includes(m)&&(R+=Math.abs(r.inlineStartOverlay.getOverlayOffset()));const v=this.hot.hasColHeaders(),S=this.hot.rowIndexMapper.getRenderableFromVisualIndex(this.row),T=this.hot.columnIndexMapper.getRenderableFromVisualIndex(this.col),N=this.hot.rowIndexMapper.getRenderableIndexesLength()-this.hot.view._wt.getSetting("fixedRowsBottom");(v&&S<=0||S===N)&&(C+=1),T<=0&&(R+=1);const _=n.rowsRenderCalculator.startPosition,M=n.columnsRenderCalculator.startPosition,A=Math.abs(r.inlineStartOverlay.getScrollPosition()),b=r.topOverlay.getScrollPosition(),I=(0,h.getScrollbarWidth)(this.hot.rootDocument);let O=t.offsetTop;if(["inline_start","master"].includes(m)&&(O+=_-b),["bottom","bottom_inline_start_corner"].includes(m)){const{wtViewport:e,wtTable:t}=r.bottomOverlay.clone;O+=e.getWorkspaceHeight()-t.getHeight()-I}let x=t.offsetLeft;this.hot.isRtl()?(x=x>=0?f.getWidth()-t.offsetLeft:Math.abs(x),x+=M-A-i):["top","master","bottom"].includes(m)&&(x+=M-A);const P=(0,h.getComputedStyle)(this.TD,this.hot.rootWindow),L=this.hot.isRtl()?"borderRightWidth":"borderLeftWidth",D=parseInt(P[L],10)>0?0:1,k=parseInt(P.borderTopWidth,10)>0?0:1,H=(0,h.outerWidth)(t)+D,F=(0,h.outerHeight)(t)+k,U=(0,h.hasVerticalScrollbar)(u)?I:0,V=(0,h.hasHorizontalScrollbar)(c)?I:0,B=this.hot.view.maximumVisibleElementWidth(x)-U+D;return{top:C,start:R,height:F,maxHeight:Math.max(this.hot.view.maximumVisibleElementHeight(O)-V+k,23),width:H,maxWidth:B}}getEditedCellsLayerClass(){switch(this.checkEditorSection()){case"inline-start":return"ht_clone_left ht_clone_inline_start";case"bottom":return"ht_clone_bottom";case"bottom-inline-start-corner":return"ht_clone_bottom_left_corner ht_clone_bottom_inline_start_corner";case"top":return"ht_clone_top";case"top-inline-start-corner":return"ht_clone_top_left_corner ht_clone_top_inline_start_corner";default:return"ht_clone_master"}}getEditedCell(){return this.hot.getCell(this.row,this.col,!0)}checkEditorSection(){const e=this.hot.countRows();let t="";return this.row<this.hot.getSettings().fixedRowsTop?t=this.col<this.hot.getSettings().fixedColumnsStart?"top-inline-start-corner":"top":this.hot.getSettings().fixedRowsBottom&&this.row>=e-this.hot.getSettings().fixedRowsBottom?t=this.col<this.hot.getSettings().fixedColumnsStart?"bottom-inline-start-corner":"bottom":this.col<this.hot.getSettings().fixedColumnsStart&&(t="inline-start"),t}}t.BaseEditor=p,(0,i.mixin)(p,l.default)},47009:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(86861);t.EDITOR_STATE=n.EDITOR_STATE,t.EDITOR_TYPE=n.EDITOR_TYPE,t.BaseEditor=n.BaseEditor},9357:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(47009),s=r(49536);const o=t.EDITOR_TYPE="checkbox";class i extends n.BaseEditor{static get EDITOR_TYPE(){return o}beginEditing(e,t){if(t&&"mouseup"===t.type&&"TD"===t.target.nodeName){const e=this.TD.querySelector('input[type="checkbox"]');(0,s.hasClass)(e,"htBadValue")||e.click()}}finishEditing(){}init(){}open(){}close(){}getValue(){}setValue(){}focus(){}}t.CheckboxEditor=i},78457:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(9357);t.EDITOR_TYPE=n.EDITOR_TYPE,t.CheckboxEditor=n.CheckboxEditor},73911:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),o=n(r(56476)),i=n(r(44499)),a=r(47009),l=r(48043),h=r(49536),u=r(58460),c=r(35592);r(57447);const d=t.EDITOR_TYPE="date",p="dateEditor";class g extends l.TextEditor{constructor(){super(...arguments),(0,s.default)(this,"defaultDateFormat","DD/MM/YYYY"),(0,s.default)(this,"parentDestroyed",!1),(0,s.default)(this,"$datePicker",null)}static get EDITOR_TYPE(){return d}init(){if("function"!=typeof o.default)throw new Error("You need to include moment.js to your project.");if("function"!=typeof i.default)throw new Error("You need to include Pikaday to your project.");super.init(),this.hot.addHook("afterDestroy",(()=>{this.parentDestroyed=!0,this.destroyElements()}))}createElements(){super.createElements(),this.datePicker=this.hot.rootDocument.createElement("DIV"),this.datePickerStyle=this.datePicker.style,this.datePickerStyle.position="absolute",this.datePickerStyle.top=0,this.datePickerStyle.left=0,this.datePickerStyle.zIndex=9999,this.datePicker.setAttribute("dir",this.hot.isRtl()?"rtl":"ltr"),(0,h.addClass)(this.datePicker,"htDatepickerHolder"),this.hot.rootDocument.body.appendChild(this.datePicker),this.eventManager.addEventListener(this.datePicker,"mousedown",(e=>{(0,h.hasClass)(e.target,"pika-day")&&this.hideDatepicker(),e.stopPropagation()}))}destroyElements(){const e=this.datePicker.parentNode;this.$datePicker&&this.$datePicker.destroy(),e&&e.removeChild(this.datePicker)}prepare(e,t,r,n,s,o){super.prepare(e,t,r,n,s,o)}open(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;const t=this.hot.getShortcutManager().getContext("editor");this.showDatepicker(e),super.open(),t.addShortcuts([{keys:[["ArrowLeft"]],callback:()=>{this.$datePicker.adjustDate("subtract",1)}},{keys:[["ArrowRight"]],callback:()=>{this.$datePicker.adjustDate("add",1)}},{keys:[["ArrowUp"]],callback:()=>{this.$datePicker.adjustDate("subtract",7)}},{keys:[["ArrowDown"]],callback:()=>{this.$datePicker.adjustDate("add",7)}}],{group:p})}close(){var e;this._opened=!1,null!==(e=this.$datePicker)&&void 0!==e&&e.destroy&&this.$datePicker.destroy(),this.hot._registerTimeout((()=>{this.hot._refreshBorders()}));this.hot.getShortcutManager().getContext("editor").removeShortcutsByGroup(p),super.close()}finishEditing(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0],t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];super.finishEditing(e,t)}showDatepicker(e){const t=this.cellProperties.dateFormat||this.defaultDateFormat,r=this.hot.view.isMouseDown(),n=!!e&&(0,c.isFunctionKey)(e.keyCode);let s;this.datePicker.style.display="block",this.$datePicker=new i.default(this.getDatePickerConfig()),"function"==typeof this.$datePicker.useMoment&&this.$datePicker.useMoment(o.default),this.$datePicker._onInputFocus=function(){},this.originalValue?(s=this.originalValue,(0,o.default)(s,t,!0).isValid()&&this.$datePicker.setMoment((0,o.default)(s,t),!0),this.getValue()!==this.originalValue&&this.setValue(this.originalValue),n||r||this.setValue("")):this.cellProperties.defaultDate?(s=this.cellProperties.defaultDate,(0,o.default)(s,t,!0).isValid()&&this.$datePicker.setMoment((0,o.default)(s,t),!0),n||r||this.setValue("")):this.$datePicker.gotoToday()}hideDatepicker(){this.datePickerStyle.display="none",this.$datePicker.hide()}getDatePickerConfig(){const e=this.TEXTAREA,t={};this.cellProperties&&this.cellProperties.datePickerConfig&&(0,u.deepExtend)(t,this.cellProperties.datePickerConfig);const r=t.onSelect,n=t.onClose;return t.field=e,t.trigger=e,t.container=this.datePicker,t.bound=!1,t.keyboardInput=!1,t.format=t.format||this.defaultDateFormat,t.reposition=t.reposition||!1,t.isRTL=!1,t.onSelect=e=>{let t=e;isNaN(t.getTime())||(t=(0,o.default)(t).format(this.cellProperties.dateFormat||this.defaultDateFormat)),this.setValue(t),r&&r()},t.onClose=()=>{this.parentDestroyed||this.finishEditing(!1),n&&n()},t}refreshDimensions(e){var t;if(super.refreshDimensions(e),this.state!==a.EDITOR_STATE.EDITING)return;if(this.TD=this.getEditedCell(),!this.TD)return void this.hideDatepicker();const{rowIndexMapper:r,columnIndexMapper:n}=this.hot,{wtOverlays:s}=this.hot.view._wt,{wtTable:o}=null!==(t=s.getParentOverlay(this.TD))&&void 0!==t?t:this.hot.view._wt,i=r.getVisualFromRenderableIndex(o.getFirstPartiallyVisibleRow()),l=r.getVisualFromRenderableIndex(o.getLastPartiallyVisibleRow()),u=n.getVisualFromRenderableIndex(o.getFirstPartiallyVisibleColumn()),c=n.getVisualFromRenderableIndex(o.getLastPartiallyVisibleColumn());if(this.row>=i&&this.row<=l&&this.col>=u&&this.col<=c){const e=this.TD.getBoundingClientRect();this.datePickerStyle.top=`${this.hot.rootWindow.pageYOffset+e.top+(0,h.outerHeight)(this.TD)}px`;let t=this.hot.rootWindow.pageXOffset;this.hot.isRtl()?t+=e.right-(0,h.outerWidth)(this.datePicker):t+=e.left,this.datePickerStyle.left=`${t}px`}else this.hideDatepicker()}}t.DateEditor=g},66436:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(73911);t.EDITOR_TYPE=n.EDITOR_TYPE,t.DateEditor=n.DateEditor},77929:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=r(29328),o=n(r(37056));const i=t.EDITOR_TYPE="dropdown";class a extends s.AutocompleteEditor{static get EDITOR_TYPE(){return i}prepare(e,t,r,n,s,o){super.prepare(e,t,r,n,s,o),this.cellProperties.filter=!1,this.cellProperties.strict=!0}}t.DropdownEditor=a,o.default.getSingleton().add("beforeValidate",(function(e,t,r){const n=this.getCellMeta(t,this.propToCol(r));n.editor===a&&void 0===n.strict&&(n.filter=!1,n.strict=!0)}))},54185:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(77929);t.EDITOR_TYPE=n.EDITOR_TYPE,t.DropdownEditor=n.DropdownEditor},68157:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(48043),s=r(49536),o=r(24456),i=r(58460),a=r(6637);const l="handsontableEditor",h=t.EDITOR_TYPE="handsontable";class u extends n.TextEditor{static get EDITOR_TYPE(){return h}open(){super.open(),this.htEditor&&this.htEditor.destroy(),"none"===this.htContainer.style.display&&(this.htContainer.style.display=""),this.htEditor=new this.hot.constructor(this.htContainer,this.htOptions),this.htEditor.init(),this.htEditor.rootElement.style.display="",this.cellProperties.strict?this.htEditor.selectCell(0,0):this.htEditor.deselectCell(),(0,s.setCaretPosition)(this.TEXTAREA,0,this.TEXTAREA.value.length),this.refreshDimensions()}close(){this.htEditor&&(this.htEditor.rootElement.style.display="none"),this.removeHooksByKey("beforeKeyDown"),super.close()}prepare(e,t,r,n,s,o){super.prepare(e,t,r,n,s,o);const a=this,l={startRows:0,startCols:0,minRows:0,minCols:0,className:"listbox",copyPaste:!1,autoColumnSize:!1,autoRowSize:!1,readOnly:!0,fillHandle:!1,autoWrapCol:!1,autoWrapRow:!1,ariaTags:!1,afterOnCellMouseDown(e,t){const r=this.getSourceData(t.row,t.col);void 0!==r&&a.setValue(r),a.hot.destroyEditor()},preventWheel:!0,layoutDirection:this.hot.isRtl()?"rtl":"ltr"};this.cellProperties.handsontable&&(0,i.extend)(l,o.handsontable),this.htOptions=l}beginEditing(e,t){const r=this.hot.getSettings().onBeginEditing;r&&!1===r()||super.beginEditing(e,t)}createElements(){super.createElements();const e=this.hot.rootDocument.createElement("DIV");e.className="handsontableEditor",this.TEXTAREA_PARENT.appendChild(e),this.htContainer=e,this.assignHooks()}finishEditing(e,t,r){if(this.htEditor&&this.htEditor.isListening()&&this.hot.listen(),this.htEditor&&this.htEditor.getSelectedLast()){const e=this.htEditor.getValue();void 0!==e&&this.setValue(e)}super.finishEditing(e,t,r)}assignHooks(){this.hot.addHook("afterDestroy",(()=>{this.htEditor&&this.htEditor.destroy()}))}registerShortcuts(){const e=this.hot.getShortcutManager().getContext("editor");super.registerShortcuts();const t={group:l,relativeToGroup:a.SHORTCUTS_GROUP_NAVIGATION,position:"before"},r=(e,t)=>{const r=this.htEditor;if(void 0!==e&&(e<0||r.flipped&&e>r.countRows()-1?r.deselectCell():r.selectCell(e,0),r.getData().length))return t.preventDefault(),(0,o.stopImmediatePropagation)(t),this.hot.listen(),this.TEXTAREA.focus(),!1};e.addShortcuts([{keys:[["ArrowUp"]],callback:e=>{const t=this.htEditor;let n,s;return!t.getSelectedLast()&&t.flipped?n=t.countRows()-1:t.getSelectedLast()&&(t.flipped?(s=t.getSelectedLast()[0],n=Math.max(0,s-1)):(s=t.getSelectedLast()[0],n=s-1)),r(n,e)},preventDefault:!1},{keys:[["ArrowDown"]],callback:e=>{const t=this.htEditor;let n,s;if(t.getSelectedLast()||t.flipped){if(t.getSelectedLast())if(t.flipped)n=t.getSelectedLast()[0]+1;else if(!t.flipped){const e=t.countRows()-1;s=t.getSelectedLast()[0],n=Math.min(e,s+1)}}else n=0;return r(n,e)},preventDefault:!1}],t)}unregisterShortcuts(){super.unregisterShortcuts();this.hot.getShortcutManager().getContext("editor").removeShortcutsByGroup(l)}}t.HandsontableEditor=u},76545:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(68157);t.EDITOR_TYPE=n.EDITOR_TYPE,t.HandsontableEditor=n.HandsontableEditor},28144:(e,t,r)=>{"use strict";t.__esModule=!0,t.registerAllEditors=function(){(0,g.registerEditor)(s.BaseEditor),(0,g.registerEditor)(n.AutocompleteEditor),(0,g.registerEditor)(o.CheckboxEditor),(0,g.registerEditor)(i.DateEditor),(0,g.registerEditor)(a.DropdownEditor),(0,g.registerEditor)(l.HandsontableEditor),(0,g.registerEditor)(h.NumericEditor),(0,g.registerEditor)(u.PasswordEditor),(0,g.registerEditor)(c.SelectEditor),(0,g.registerEditor)(d.TextEditor),(0,g.registerEditor)(p.TimeEditor)};var n=r(29328);t.AutocompleteEditor=n.AutocompleteEditor,t.AUTOCOMPLETE_EDITOR=n.EDITOR_TYPE;var s=r(47009);t.BaseEditor=s.BaseEditor,t.BASE_EDITOR=s.EDITOR_TYPE;var o=r(78457);t.CheckboxEditor=o.CheckboxEditor,t.CHECKBOX_EDITOR=o.EDITOR_TYPE;var i=r(66436);t.DateEditor=i.DateEditor,t.DATE_EDITOR=i.EDITOR_TYPE;var a=r(54185);t.DropdownEditor=a.DropdownEditor,t.DROPDOWN_EDITOR=a.EDITOR_TYPE;var l=r(76545);t.HandsontableEditor=l.HandsontableEditor,t.HANDSONTABLE_EDITOR=l.EDITOR_TYPE;var h=r(59889);t.NumericEditor=h.NumericEditor,t.NUMERIC_EDITOR=h.EDITOR_TYPE;var u=r(14961);t.PasswordEditor=u.PasswordEditor,t.PASSWORD_EDITOR=u.EDITOR_TYPE;var c=r(51656);t.SelectEditor=c.SelectEditor,t.SELECT_EDITOR=c.EDITOR_TYPE;var d=r(48043);t.TextEditor=d.TextEditor,t.TEXT_EDITOR=d.EDITOR_TYPE;var p=r(54837);t.TimeEditor=p.TimeEditor,t.TIME_EDITOR=p.EDITOR_TYPE;var g=r(39761);t.registerEditor=g.registerEditor,t.RegisteredEditor=g.RegisteredEditor,t._getEditorInstance=g._getEditorInstance,t.getEditor=g.getEditor,t.getEditorInstance=g.getEditorInstance,t.getRegisteredEditorNames=g.getRegisteredEditorNames,t.getRegisteredEditors=g.getRegisteredEditors,t.hasEditor=g.hasEditor},59889:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(78343);t.EDITOR_TYPE=n.EDITOR_TYPE,t.NumericEditor=n.NumericEditor},78343:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(48043);const s=t.EDITOR_TYPE="numeric";class o extends n.TextEditor{static get EDITOR_TYPE(){return s}}t.NumericEditor=o},14961:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(66461);t.EDITOR_TYPE=n.EDITOR_TYPE,t.PasswordEditor=n.PasswordEditor},66461:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(48043),s=r(49536),o=r(81595);const i=t.EDITOR_TYPE="password";class a extends n.TextEditor{static get EDITOR_TYPE(){return i}createElements(){super.createElements(),this.TEXTAREA=this.hot.rootDocument.createElement("input"),this.TEXTAREA.setAttribute("type","password"),this.TEXTAREA.setAttribute("data-hot-input",""),this.TEXTAREA.className="handsontableInput",this.textareaStyle=this.TEXTAREA.style,this.textareaStyle.width=0,this.textareaStyle.height=0,this.hot.getSettings().ariaTags&&(0,s.setAttribute)(this.TEXTAREA,[(0,o.A11Y_HIDDEN)()]),(0,s.empty)(this.TEXTAREA_PARENT),this.TEXTAREA_PARENT.appendChild(this.TEXTAREA)}}t.PasswordEditor=a},39761:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.RegisteredEditor=d,t.getEditorInstance=t._getEditorInstance=function(e,t){let r;if("function"==typeof e)i.get(e)||p(null,e),r=i.get(e);else{if("string"!=typeof e)throw Error('Only strings and functions can be passed as "editor" parameter');r=l(e)}if(!r)throw Error(`No editor registered under name "${e}"`);return r.getInstance(t)},t.getEditor=function(e){if("function"==typeof e)return e;if(!h(e))throw Error(`No registered editor found under "${e}" name`);return l(e).getConstructor()},t.registerEditor=p,r(67834);var s=n(r(37056)),o=n(r(45212));const i=new WeakMap,{register:a,getItem:l,hasItem:h,getNames:u,getValues:c}=(0,o.default)("editors");function d(e){const t={},r=e;this.getConstructor=function(){return e},this.getInstance=function(e){return e.guid in t||(t[e.guid]=new r(e)),t[e.guid]},s.default.getSingleton().add("afterDestroy",(function(){t[this.guid]=null}))}function p(e,t){e&&"string"!=typeof e&&(e=(t=e).EDITOR_TYPE);const r=new d(t);"string"==typeof e&&a(e,r),i.set(t,r)}t.getRegisteredEditors=c,t.getRegisteredEditorNames=u,t.hasEditor=h},51656:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(7383);t.EDITOR_TYPE=n.EDITOR_TYPE,t.SelectEditor=n.SelectEditor},7383:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(47009),s=r(49536),o=r(58460);const i="ht_editor_visible",a="selectEditor",l=t.EDITOR_TYPE="select";class h extends n.BaseEditor{static get EDITOR_TYPE(){return l}init(){this.select=this.hot.rootDocument.createElement("select"),this.select.setAttribute("data-hot-input","true"),this.select.style.display="none",(0,s.addClass)(this.select,"htSelectEditor"),this.hot.rootElement.appendChild(this.select),this.registerHooks()}getValue(){return this.select.value}setValue(e){this.select.value=e}open(){this._opened=!0,this.refreshDimensions(),this.select.style.display="";this.hot.getShortcutManager().setActiveContextName("editor"),this.registerShortcuts()}close(){this._opened=!1,this.select.style.display="none",(0,s.hasClass)(this.select,i)&&(0,s.removeClass)(this.select,i),this.unregisterShortcuts(),this.clearHooks()}focus(){this.select.focus()}registerHooks(){this.addHook("afterScrollHorizontally",(()=>this.refreshDimensions())),this.addHook("afterScrollVertically",(()=>this.refreshDimensions())),this.addHook("afterColumnResize",(()=>this.refreshDimensions())),this.addHook("afterRowResize",(()=>this.refreshDimensions()))}prepare(e,t,r,n,i,a){super.prepare(e,t,r,n,i,a);const l=this.cellProperties.selectOptions;let h;h="function"==typeof l?this.prepareOptions(l(this.row,this.col,this.prop)):this.prepareOptions(l),(0,s.empty)(this.select),(0,o.objectEach)(h,((e,t)=>{const r=this.hot.rootDocument.createElement("OPTION");r.value=t,(0,s.fastInnerHTML)(r,e),this.select.appendChild(r)}))}prepareOptions(e){let t={};if(Array.isArray(e))for(let r=0,n=e.length;r<n;r++)t[e[r]]=e[r];else"object"==typeof e&&(t=e);return t}refreshValue(){const e=this.hot.getSourceDataAtCell(this.row,this.prop);this.originalValue=e,this.setValue(e),this.refreshDimensions()}refreshDimensions(){if(this.state!==n.EDITOR_STATE.EDITING)return;if(this.TD=this.getEditedCell(),!this.TD)return void this.close();const{top:e,start:t,width:r,height:o}=this.getEditedCellRect(),a=this.select.style;a.height=`${o}px`,a.width=`${r}px`,a.top=`${e}px`,a[this.hot.isRtl()?"right":"left"]=`${t}px`,a.margin="0px",(0,s.addClass)(this.select,i)}registerShortcuts(){const e=this.hot.getShortcutManager(),t=e.getContext("editor"),r=e.getContext("grid"),n={group:a};t.addShortcuts([{keys:[["Tab"],["Shift","Tab"]],forwardToContext:r,callback:()=>{}}],n),!0===this.isInFullEditMode()&&t.addShortcuts([{keys:[["ArrowUp"]],callback:()=>{const e=this.select.selectedIndex-1;e>=0&&(this.select[e].selected=!0)}},{keys:[["ArrowDown"]],callback:()=>{const e=this.select.selectedIndex+1;e<=this.select.length-1&&(this.select[e].selected=!0)}}],n)}unregisterShortcuts(){this.hot.getShortcutManager().getContext("editor").removeShortcutsByGroup(a)}}t.SelectEditor=h},88328:(e,t,r)=>{"use strict";t.__esModule=!0,t.updateCaretPosition=function(e,t){const r=(0,n.getCaretPosition)(t),s=t.value.split("\n");let o=r,i=0;for(let t=0;t<s.length;t++){const n=s[t];0!==t&&(i+=s[t-1].length+1);const a=i+n.length;if("home"===e?o=i:"end"===e&&(o=a),r<=a)break}(0,n.setCaretPosition)(t,o)};var n=r(49536)},48043:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(98173);t.EDITOR_TYPE=n.EDITOR_TYPE,t.TextEditor=n.TextEditor},98173:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),o=r(47009),i=n(r(63286)),a=r(1479),l=r(49536),h=r(27050),u=r(37028),c=r(67508),d=r(6637),p=r(86861),g=r(88328),f=r(81595);const m="ht_editor_hidden",E="textEditor",y=t.EDITOR_TYPE="text";class w extends o.BaseEditor{static get EDITOR_TYPE(){return y}constructor(e){super(e),(0,s.default)(this,"eventManager",new i.default(this)),(0,s.default)(this,"autoResize",(0,u.createInputElementResizer)(this.hot.rootDocument)),(0,s.default)(this,"TEXTAREA",void 0),(0,s.default)(this,"textareaStyle",void 0),(0,s.default)(this,"TEXTAREA_PARENT",void 0),(0,s.default)(this,"textareaParentStyle",void 0),(0,s.default)(this,"layerClass",void 0),this.eventManager=new i.default(this),this.createElements(),this.bindEvents(),this.hot.addHookOnce("afterDestroy",(()=>this.destroy()))}getValue(){return this.TEXTAREA.value}setValue(e){this.TEXTAREA.value=e}open(){this.refreshDimensions(),this.showEditableElement(),this.hot.getShortcutManager().setActiveContextName("editor"),this.registerShortcuts()}close(){this.autoResize.unObserve(),(0,l.isThisHotChild)(this.hot.rootDocument.activeElement,this.hot.rootElement)&&this.hot.listen(),this.hideEditableElement(),this.unregisterShortcuts()}prepare(e,t,r,n,s,i){const a=this.state;if(super.prepare(e,t,r,n,s,i),!i.readOnly){this.refreshDimensions(!0);const{allowInvalid:e}=i;e&&(this.TEXTAREA.value=""),a!==o.EDITOR_STATE.FINISHED&&this.hideEditableElement()}}beginEditing(e,t){this.state===o.EDITOR_STATE.VIRGIN&&(this.TEXTAREA.value="",super.beginEditing(e,t))}focus(){this.TEXTAREA.select(),(0,l.setCaretPosition)(this.TEXTAREA,this.TEXTAREA.value.length)}createElements(){const{rootDocument:e}=this.hot;this.TEXTAREA=e.createElement("TEXTAREA"),(0,l.setAttribute)(this.TEXTAREA,[["data-hot-input",""],(0,f.A11Y_TABINDEX)(-1)]),this.hot.getSettings().ariaTags&&(0,l.setAttribute)(this.TEXTAREA,[(0,f.A11Y_HIDDEN)()]),(0,l.addClass)(this.TEXTAREA,"handsontableInput"),this.textareaStyle=this.TEXTAREA.style,this.textareaStyle.width=0,this.textareaStyle.height=0,this.textareaStyle.overflowY="visible",this.TEXTAREA_PARENT=e.createElement("DIV"),(0,l.addClass)(this.TEXTAREA_PARENT,"handsontableInputHolder"),(0,l.hasClass)(this.TEXTAREA_PARENT,this.layerClass)&&(0,l.removeClass)(this.TEXTAREA_PARENT,this.layerClass),(0,l.addClass)(this.TEXTAREA_PARENT,m),this.textareaParentStyle=this.TEXTAREA_PARENT.style,this.TEXTAREA_PARENT.appendChild(this.TEXTAREA),this.hot.rootElement.appendChild(this.TEXTAREA_PARENT)}hideEditableElement(){(0,a.isEdge)()&&(this.textareaStyle.textIndent="-99999px"),this.textareaStyle.overflowY="visible",this.textareaParentStyle.opacity="0",this.textareaParentStyle.height="1px",(0,l.removeClass)(this.TEXTAREA_PARENT,this.layerClass),(0,l.addClass)(this.TEXTAREA_PARENT,m)}showEditableElement(){this.textareaParentStyle.height="",this.textareaParentStyle.overflow="",this.textareaParentStyle.position="",this.textareaParentStyle[this.hot.isRtl()?"left":"right"]="auto",this.textareaParentStyle.opacity="1",this.textareaStyle.textIndent="";const e=this.TEXTAREA_PARENT.childNodes;let t=!1;(0,h.rangeEach)(e.length-1,(r=>{const n=e[r];if((0,l.hasClass)(n,"handsontableEditor"))return t=!0,!1})),(0,l.hasClass)(this.TEXTAREA_PARENT,m)&&(0,l.removeClass)(this.TEXTAREA_PARENT,m),t?(this.layerClass="ht_editor_visible",(0,l.addClass)(this.TEXTAREA_PARENT,this.layerClass)):(this.layerClass=this.getEditedCellsLayerClass(),(0,l.addClass)(this.TEXTAREA_PARENT,this.layerClass))}refreshValue(){const e=this.hot.toPhysicalRow(this.row),t=this.hot.getSourceDataAtCell(e,this.col);this.originalValue=t,this.setValue(t),this.refreshDimensions()}refreshDimensions(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];if(this.state!==o.EDITOR_STATE.EDITING&&!e)return;if(this.TD=this.getEditedCell(),!this.TD)return void(e||this.close());const{top:t,start:r,width:n,maxWidth:s,height:i,maxHeight:a}=this.getEditedCellRect();this.textareaParentStyle.top=`${t}px`,this.textareaParentStyle[this.hot.isRtl()?"right":"left"]=`${r}px`,this.showEditableElement();const h=(0,l.getComputedStyle)(this.TD,this.hot.rootWindow);this.TEXTAREA.style.fontSize=h.fontSize,this.TEXTAREA.style.fontFamily=h.fontFamily,this.TEXTAREA.style.backgroundColor=this.TD.style.backgroundColor;const u=(0,l.getComputedStyle)(this.TEXTAREA),c=parseInt(u.paddingLeft,10)+parseInt(u.paddingRight,10),d=parseInt(u.paddingTop,10)+parseInt(u.paddingBottom,10),p=n-c,g=i-d,f=s-c,m=a-d;this.autoResize.init(this.TEXTAREA,{minWidth:Math.min(p,f),minHeight:Math.min(g,m),maxWidth:f,maxHeight:m},!0)}bindEvents(){(0,a.isIOS)()&&this.eventManager.addEventListener(this.TEXTAREA,"focusout",(()=>this.finishEditing(!1))),this.addHook("afterScrollHorizontally",(()=>this.refreshDimensions())),this.addHook("afterScrollVertically",(()=>this.refreshDimensions())),this.addHook("afterColumnResize",(()=>{this.refreshDimensions(),this.state===o.EDITOR_STATE.EDITING&&this.focus()})),this.addHook("afterRowResize",(()=>{this.refreshDimensions(),this.state===o.EDITOR_STATE.EDITING&&this.focus()}))}allowKeyEventPropagation(){}destroy(){this.eventManager.destroy(),this.clearHooks()}registerShortcuts(){const e=this.hot.getShortcutManager(),t=e.getContext("editor"),r=e.getContext("grid"),n={runOnlyIf:()=>(0,c.isDefined)(this.hot.getSelected()),group:E},s=()=>{this.hot.rootDocument.execCommand("insertText",!1,"\n")};t.addShortcuts([{keys:[["Tab"],["Shift","Tab"],["PageUp"],["PageDown"]],forwardToContext:r,callback:()=>{}},{keys:[["Control","Enter"]],callback:()=>(s(),!1),runOnlyIf:e=>!this.hot.selection.isMultiple()&&!e.altKey},{keys:[["Meta","Enter"]],callback:()=>(s(),!1),runOnlyIf:()=>!this.hot.selection.isMultiple()},{keys:[["Alt","Enter"]],callback:()=>(s(),!1)},{keys:[["Home"]],callback:(e,t)=>{let[r]=t;(0,g.updateCaretPosition)(r,this.TEXTAREA)}},{keys:[["End"]],callback:(e,t)=>{let[r]=t;(0,g.updateCaretPosition)(r,this.TEXTAREA)}}],n)}unregisterShortcuts(){const e=this.hot.getShortcutManager().getContext("editor");e.removeShortcutsByGroup(d.SHORTCUTS_GROUP_NAVIGATION),e.removeShortcutsByGroup(E),e.removeShortcutsByGroup(p.SHORTCUTS_GROUP_EDITOR)}}t.TextEditor=w},54837:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(79685);t.EDITOR_TYPE=n.EDITOR_TYPE,t.TimeEditor=n.TimeEditor},79685:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(48043);const s=t.EDITOR_TYPE="time";class o extends n.TextEditor{static get EDITOR_TYPE(){return s}prepare(e,t,r,n,s,o){super.prepare(e,t,r,n,s,o),this.TEXTAREA.dir="ltr"}}t.TimeEditor=o},63286:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.getListenersCounter=function(){return i},r(15724);var s=n(r(85707)),o=r(24456);let i=0;t.default=class{constructor(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;(0,s.default)(this,"context",void 0),this.context=e||this,this.context.eventListeners||(this.context.eventListeners=[])}addEventListener(e,t,r){let n=arguments.length>3&&void 0!==arguments[3]&&arguments[3];function s(e){r.call(this,function(e){const t=e.stopImmediatePropagation;return e.stopImmediatePropagation=function(){t.apply(this),(0,o.stopImmediatePropagation)(this)},e}(e))}return this.context.eventListeners.push({element:e,event:t,callback:r,callbackProxy:s,options:n,eventManager:this}),e.addEventListener(t,s,n),i+=1,()=>{this.removeEventListener(e,t,r)}}removeEventListener(e,t,r){let n,s=arguments.length>3&&void 0!==arguments[3]&&arguments[3],o=this.context.eventListeners.length;for(;o;)if(o-=1,n=this.context.eventListeners[o],n.event===t&&n.element===e){if(r&&r!==n.callback)continue;if(s&&n.eventManager!==this)continue;this.context.eventListeners.splice(o,1),n.element.removeEventListener(n.event,n.callbackProxy,n.options),i-=1}}clearEvents(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];if(!this.context)return;let t=this.context.eventListeners.length;for(;t;){t-=1;const r=this.context.eventListeners[t];e&&r.eventManager!==this||(this.context.eventListeners.splice(t,1),r.element.removeEventListener(r.event,r.callbackProxy,r.options),i-=1)}}clear(){this.clearEvents()}destroy(){this.clearEvents(),this.context=null}destroyWithOwnEventsOnly(){this.clearEvents(!0),this.context=null}fireEvent(e,t){let r=e.document,n=e;r||(r=e.ownerDocument?e.ownerDocument:e,n=r.defaultView);const s={bubbles:!0,cancelable:"mousemove"!==t,view:n,detail:0,screenX:0,screenY:0,clientX:1,clientY:1,ctrlKey:!1,altKey:!1,shiftKey:!1,metaKey:!1,button:0,relatedTarget:void 0};let o;r.createEvent?(o=r.createEvent("MouseEvents"),o.initMouseEvent(t,s.bubbles,s.cancelable,s.view,s.detail,s.screenX,s.screenY,s.clientX,s.clientY,s.ctrlKey,s.altKey,s.shiftKey,s.metaKey,s.button,s.relatedTarget||r.body.parentNode)):o=r.createEventObject(),e.dispatchEvent?e.dispatchEvent(o):e.fireEvent(`on${t}`,o)}}},24638:(e,t,r)=>{"use strict";t.__esModule=!0,r(67834);var n=r(39874),s=r(49536),o=r(25735);function i(e,t,r){a(e,t),t.set(e,r)}function a(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function l(e,t){return e.get(u(e,t))}function h(e,t,r){return e.set(u(e,t),r),r}function u(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}const c=Object.freeze({CELL:"cell",MIXED:"mixed"});var d=new WeakMap,p=new WeakMap,g=new WeakMap,f=new WeakMap,m=new WeakMap,E=new WeakSet;function y(e){var t;const r=null===(t=l(d,this).getSelectedRangeLast())||void 0===t?void 0:t.highlight;if(!r||!l(d,this).selection.isCellVisible(r))return void e(null);const n=l(d,this).getCell(r.row,r.col,!0);null===n?l(d,this).addHookOnce("afterScroll",(()=>{e(l(d,this).getCell(r.row,r.col,!0))})):e(n)}function w(){u(E,this,y).call(this,(e=>{const{activeElement:t}=l(d,this).rootDocument;t&&(0,s.isOutsideInput)(t)&&t.blur(),this.focusOnHighlightedCell(e)}))}function C(){u(E,this,y).call(this,(e=>{this.getFocusMode()===c.MIXED&&"TD"===e.nodeName&&this.refocusToEditorTextarea()}))}function R(e){e.imeFastEdit&&this.getFocusMode()!==c.MIXED?this.setFocusMode(c.MIXED):e.imeFastEdit||this.getFocusMode()===c.CELL||this.setFocusMode(c.CELL)}t.FocusManager=class{constructor(e){var t,r,n=this;a(t=this,r=E),r.add(t),i(this,d,void 0),i(this,p,void 0),i(this,g,50),i(this,f,null),i(this,m,new Map);const s=e.getSettings();h(d,this,e),h(p,this,s.imeFastEdit?c.MIXED:c.CELL),l(d,this).addHook("afterUpdateSettings",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return u(E,n,R).call(n,...t)})),l(d,this).addHook("afterSelection",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return u(E,n,w).call(n,...t)})),l(d,this).addHook("afterSelectionFocusSet",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return u(E,n,w).call(n,...t)})),l(d,this).addHook("afterSelectionEnd",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return u(E,n,C).call(n,...t)}))}getFocusMode(){return l(p,this)}setFocusMode(e){Object.values(c).includes(e)?h(p,this,e):(0,n.warn)(`"${e}" is not a valid focus mode.`)}getRefocusDelay(){return l(g,this)}setRefocusDelay(e){h(g,this,e)}setRefocusElementGetter(e){h(f,this,e)}getRefocusElement(){return"function"==typeof l(f,this)?l(f,this).call(this):null===(e=l(d,this).getActiveEditor())||void 0===e?void 0:e.TEXTAREA;var e}focusOnHighlightedCell(e){const t=e=>{var t,r;const n=null===(t=l(d,this).getSelectedRangeLast())||void 0===t?void 0:t.highlight;if(!n)return;let s=l(d,this).runHooks("modifyFocusedElement",n.row,n.col,e);s instanceof HTMLElement||(s=e),!s||null!==(r=l(d,this).getActiveEditor())&&void 0!==r&&r.isOpened()||s.focus({preventScroll:!0})};e?t(e):u(E,this,y).call(this,(e=>t(e)))}refocusToEditorTextarea(){var e;let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:l(g,this);const r=this.getRefocusElement();!l(d,this).getSettings().imeFastEdit||null!==(e=l(d,this).getActiveEditor())&&void 0!==e&&e.isOpened()||!r||(l(m,this).has(t)||l(m,this).set(t,(0,o.debounce)((()=>{r.select()}),t)),l(m,this).get(t)())}}},81595:(e,t)=>{"use strict";t.__esModule=!0;t.A11Y_TABINDEX=e=>["tabindex",e];t.A11Y_TREEGRID=()=>["role","treegrid"];t.A11Y_PRESENTATION=()=>["role","presentation"];t.A11Y_GRIDCELL=()=>["role","gridcell"];t.A11Y_ROWHEADER=()=>["role","rowheader"];t.A11Y_ROWGROUP=()=>["role","rowgroup"];t.A11Y_COLUMNHEADER=()=>["role","columnheader"];t.A11Y_ROW=()=>["role","row"];t.A11Y_MENU=()=>["role","menu"];t.A11Y_MENU_ITEM=()=>["role","menuitem"];t.A11Y_COMBOBOX=()=>["role","combobox"];t.A11Y_LISTBOX=()=>["role","listbox"];t.A11Y_OPTION=()=>["role","option"];t.A11Y_CHECKBOX=()=>["role","checkbox"];t.A11Y_SCOPE_COL=()=>["scope","col"];t.A11Y_SCOPE_ROW=()=>["scope","row"];t.A11Y_TEXT=()=>["type","text"];t.A11Y_LABEL=e=>["aria-label",e];t.A11Y_HIDDEN=()=>["aria-hidden","true"];t.A11Y_DISABLED=()=>["aria-disabled","true"];t.A11Y_MULTISELECTABLE=()=>["aria-multiselectable","true"];t.A11Y_HASPOPUP=e=>["aria-haspopup",e];t.A11Y_ROWCOUNT=e=>["aria-rowcount",e];t.A11Y_COLCOUNT=e=>["aria-colcount",e];t.A11Y_ROWINDEX=e=>["aria-rowindex",e];t.A11Y_COLINDEX=e=>["aria-colindex",e];t.A11Y_EXPANDED=e=>["aria-expanded",e];t.A11Y_SORT=e=>["aria-sort",e];t.A11Y_READONLY=()=>["aria-readonly","true"];t.A11Y_INVALID=()=>["aria-invalid","true"];t.A11Y_CHECKED=e=>["aria-checked",e];t.A11Y_SELECTED=()=>["aria-selected","true"];t.A11Y_AUTOCOMPLETE=()=>["aria-autocomplete","list"];t.A11Y_CONTROLS=e=>["aria-controls",e];t.A11Y_ACTIVEDESCENDANT=e=>["aria-activedescendant",e];t.A11Y_LIVE=e=>["aria-live",e];t.A11Y_RELEVANT=e=>["aria-relevant",e];t.A11Y_SETSIZE=e=>["aria-setsize",e];t.A11Y_POSINSET=e=>["aria-posinset",e]},98758:(e,t,r)=>{"use strict";function n(e,t,r,n){let s=-1,o=e,i=r;Array.isArray(e)||(o=Array.from(e));const a=o.length;for(n&&a&&(s+=1,i=o[s]),s+=1;s<a;)i=t(i,o[s],s,o),s+=1;return i}function s(e,t){let r=0,n=e;Array.isArray(e)||(n=Array.from(e));const s=n.length;for(;r<s&&!1!==t(n[r],r,n);)r+=1;return e}function o(e){return n(e,((e,t)=>e+t),0)}t.__esModule=!0,t.arrayAvg=function(e){if(!e.length)return 0;return o(e)/e.length},t.arrayEach=s,t.arrayFilter=function(e,t){let r=0,n=e;Array.isArray(e)||(n=Array.from(e));const s=n.length,o=[];let i=-1;for(;r<s;){const e=n[r];t(e,r,n)&&(i+=1,o[i]=e),r+=1}return o},t.arrayFlatten=function e(t){return n(t,((t,r)=>t.concat(Array.isArray(r)?e(r):r)),[])},t.arrayMap=function(e,t){let r=0,n=e;Array.isArray(e)||(n=Array.from(e));const s=n.length,o=[];let i=-1;for(;r<s;){const e=n[r];i+=1,o[i]=t(e,r,n),r+=1}return o},t.arrayMax=function(e){return n(e,((e,t)=>e>t?e:t),Array.isArray(e)?e[0]:void 0)},t.arrayMin=function(e){return n(e,((e,t)=>e<t?e:t),Array.isArray(e)?e[0]:void 0)},t.arrayReduce=n,t.arraySum=o,t.arrayUnique=function(e){const t=[];return s(e,(e=>{-1===t.indexOf(e)&&t.push(e)})),t},t.extendArray=function(e,t){const r=t.length;let n=0;for(;n<r;)e.push(t[n]),n+=1},t.getDifferenceOfArrays=function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];const[n,...o]=[...t];let i=n;return s(o,(e=>{i=i.filter((t=>!e.includes(t)))})),i},t.getIntersectionOfArrays=function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];const[n,...o]=[...t];let i=n;return s(o,(e=>{i=i.filter((t=>e.includes(t)))})),i},t.getUnionOfArrays=function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];const[n,...o]=[...t],i=new Set(n);return s(o,(e=>{s(e,(e=>{i.has(e)||i.add(e)}))})),Array.from(i)},t.pivot=function(e){const t=[];if(!e||0===e.length||!e[0]||0===e[0].length)return t;const r=e.length,n=e[0].length;for(let s=0;s<r;s++)for(let r=0;r<n;r++)t[r]||(t[r]=[]),t[r][s]=e[s][r];return t},t.stringToArray=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:" ";return e.split(t)},t.to2dArray=function(e){const t=e.length;let r=0;for(;r<t;)e[r]=[e[r]],r+=1},r(15724)},1479:(e,t,r)=>{"use strict";t.__esModule=!0,t.isChrome=function(){return i.chrome.value},t.isChromeWebKit=function(){return i.chromeWebKit.value},t.isEdge=function(){return i.edge.value},t.isEdgeWebKit=function(){return i.edgeWebKit.value},t.isFirefox=function(){return i.firefox.value},t.isFirefoxWebKit=function(){return i.firefoxWebKit.value},t.isIOS=function(){return a.ios.value},t.isIpadOS=function(){let{maxTouchPoints:e}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:navigator;return e>2&&a.mac.value},t.isLinuxOS=function(){return a.linux.value},t.isMacOS=function(){return a.mac.value},t.isMobileBrowser=function(){return i.mobile.value},t.isSafari=function(){return i.safari.value},t.isWindowsOS=function(){return a.win.value},t.setBrowserMeta=l,t.setPlatformMeta=h;var n=r(58460),s=r(36201);const o=e=>{const t={value:!1,test:(r,n)=>{t.value=e(r,n)}};return t},i={chrome:o(((e,t)=>/Chrome/.test(e)&&/Google/.test(t))),chromeWebKit:o((e=>/CriOS/.test(e))),edge:o((e=>/Edge/.test(e))),edgeWebKit:o((e=>/EdgiOS/.test(e))),firefox:o((e=>/Firefox/.test(e))),firefoxWebKit:o((e=>/FxiOS/.test(e))),mobile:o((e=>/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(e))),safari:o(((e,t)=>/Safari/.test(e)&&/Apple Computer/.test(t)))},a={mac:o((e=>/^Mac/.test(e))),win:o((e=>/^Win/.test(e))),linux:o((e=>/^Linux/.test(e))),ios:o((e=>/iPhone|iPad|iPod/i.test(e)))};function l(){let{userAgent:e=navigator.userAgent,vendor:t=navigator.vendor}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};(0,n.objectEach)(i,(r=>{let{test:n}=r;n(e,t)}))}function h(){let{platform:e=navigator.platform}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};(0,n.objectEach)(a,(t=>{let{test:r}=t;r(e)}))}(0,s.isCSR)()&&(l(),h())},39874:(e,t,r)=>{"use strict";t.__esModule=!0,t.error=function(){(0,n.isDefined)(console)&&console.error(...arguments)},t.info=function(){(0,n.isDefined)(console)&&console.info(...arguments)},t.log=function(){(0,n.isDefined)(console)&&console.log(...arguments)},t.warn=function(){(0,n.isDefined)(console)&&console.warn(...arguments)};var n=r(67508)},37671:(e,t,r)=>{"use strict";t.__esModule=!0,t.countFirstRowKeys=function(e){let t=0;Array.isArray(e)&&(e[0]&&Array.isArray(e[0])?t=e[0].length:e[0]&&(0,n.isObject)(e[0])&&(t=(0,n.deepObjectSize)(e[0])));return t},t.createEmptySpreadsheetData=function(e,t){const r=[];let n;for(let s=0;s<e;s++){n=[];for(let e=0;e<t;e++)n.push("");r.push(n)}return r},t.createSpreadsheetData=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:100,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:4;const r=[];let n,s;for(n=0;n<e;n++){const e=[];for(s=0;s<t;s++)e.push(i(s)+(n+1));r.push(e)}return r},t.createSpreadsheetObjectData=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:100,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:4;const r=[];let n,s;for(n=0;n<e;n++){const e={};for(s=0;s<t;s++)e[`prop${s}`]=i(s)+(n+1);r.push(e)}return r},t.dataRowToChangesArray=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,r=e;const n=[];Array.isArray(e)&&Array.isArray(e[0])||(r=[e]);return r.forEach(((e,r)=>{Array.isArray(e)?e.forEach(((e,s)=>{n.push([r+t,s,e])})):Object.keys(e).forEach((s=>{n.push([r+t,s,e[s]])}))})),n},t.isArrayOfArrays=function(e){return!!(Array.isArray(e)&&e.length&&e.every((e=>Array.isArray(e))))},t.isArrayOfObjects=function(e){return!!(Array.isArray(e)&&e.length&&e.every((e=>"object"==typeof e&&!Array.isArray(e)&&null!==e)))},t.spreadsheetColumnIndex=function(e){let t=0;if(e)for(let r=0,n=e.length-1;r<e.length;r+=1,n-=1)t+=o**n*(s.indexOf(e[r])+1);return t-=1,t},t.spreadsheetColumnLabel=i,r(15724);var n=r(58460);const s="ABCDEFGHIJKLMNOPQRSTUVWXYZ",o=s.length;function i(e){let t,r=e+1,n="";for(;r>0;)t=(r-1)%o,n=String.fromCharCode(65+t)+n,r=parseInt((r-t)/o,10);return n}},11459:(e,t)=>{"use strict";t.__esModule=!0,t.getNormalizedDate=function(e){const t=new Date(e);if(!isNaN(new Date(`${e}T00:00`).getDate()))return new Date(t.getTime()+6e4*t.getTimezoneOffset());return t}},49536:(e,t,r)=>{"use strict";t.__esModule=!0,t.addClass=h,t.addEvent=function(e,t,r){e.addEventListener(t,r,!1)},t.clearTextSelection=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:window;e.getSelection&&(e.getSelection().empty?e.getSelection().empty():e.getSelection().removeAllRanges&&e.getSelection().removeAllRanges())},t.closest=i,t.closestDown=function(e,t,r){const n=[];let s=e;for(;s&&(s=i(s,t,r),s&&(!r||r.contains(s)));)n.push(s),s=s.host&&s.nodeType===Node.DOCUMENT_FRAGMENT_NODE?s.host:s.parentNode;const o=n.length;return o?n[o-1]:null},t.empty=d,t.fastInnerHTML=function(e,t){let r=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];p.test(t)?e.innerHTML=r?(0,n.sanitize)(t):t:g(e,t)},t.fastInnerText=g,t.getCaretPosition=function(e){if(e.selectionStart)return e.selectionStart;return 0},t.getComputedStyle=E,t.getCssTransform=function(e){let t;if(e.style.transform&&""!==(t=e.style.transform))return["transform",t];return-1},t.getFrameElement=o,t.getMaximumScrollLeft=function(e){return e.scrollWidth-e.clientWidth},t.getMaximumScrollTop=function(e){return e.scrollHeight-e.clientHeight},t.getParent=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,r=-1,n=null,s=e;for(;null!==s;){if(r===t){n=s;break}s.host&&s.nodeType===Node.DOCUMENT_FRAGMENT_NODE?s=s.host:(r+=1,s=s.parentNode)}return n},t.getParentWindow=function(e){return o(e)&&e.parent},t.getScrollLeft=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:window;if(e===t)return m(t);return e.scrollLeft},t.getScrollTop=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:window;if(e===t)return f(t);return e.scrollTop},t.getScrollableElement=function(e){let t=e.ownerDocument,r=t?t.defaultView:void 0;t||(t=e.document?e.document:e,r=t.defaultView);const n=["auto","scroll"];let s=e.parentNode;for(;s&&s.style&&t.body!==s;){let{overflow:e,overflowX:t,overflowY:o}=s.style;if([e,t,o].includes("scroll"))return s;if(({overflow:e,overflowX:t,overflowY:o}=r.getComputedStyle(s)),n.includes(e)||n.includes(t)||n.includes(o))return s;if(s.clientHeight<=s.scrollHeight+1&&(n.includes(o)||n.includes(e)))return s;if(s.clientWidth<=s.scrollWidth+1&&(n.includes(t)||n.includes(e)))return s;s=s.parentNode}return r},t.getScrollbarWidth=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:document;void 0===y&&(y=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:document;const t=e.createElement("div");t.style.height="200px",t.style.width="100%";const r=e.createElement("div");r.style.boxSizing="content-box",r.style.height="150px",r.style.left="0px",r.style.overflow="hidden",r.style.position="absolute",r.style.top="0px",r.style.width="200px",r.style.visibility="hidden",r.appendChild(t),(e.body||e.documentElement).appendChild(r);const n=t.offsetWidth;r.style.overflow="scroll";let s=t.offsetWidth;n===s&&(s=r.clientWidth);return(e.body||e.documentElement).removeChild(r),n-s}(e));return y},t.getSelectionEndPosition=function(e){if(e.selectionEnd)return e.selectionEnd;return 0},t.getSelectionText=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:window;const t=e.document;let r="";e.getSelection?r=e.getSelection().toString():t.selection&&"Control"!==t.selection.type&&(r=t.selection.createRange().text);return r},t.getStyle=function(e,t){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:window;if(!e)return;if(e===r)return"width"===t?`${r.innerWidth}px`:"height"===t?`${r.innerHeight}px`:void 0;const n=e.style[t];if(""!==n&&void 0!==n)return n;const s=E(e,r);if(""!==s[t]&&void 0!==s[t])return s[t]},t.getTrimmingContainer=function(e){const t=e.ownerDocument,r=t.defaultView;let n=e.parentNode;for(;n&&n.style&&t.body!==n;){if("visible"!==n.style.overflow&&""!==n.style.overflow)return n;const e=E(n,r),t=["scroll","hidden","auto"],s=e.getPropertyValue("overflow"),o=e.getPropertyValue("overflow-y"),i=e.getPropertyValue("overflow-x");if(t.includes(s)||t.includes(o)||t.includes(i))return n;n=n.parentNode}return r},t.getWindowScrollLeft=m,t.getWindowScrollTop=f,t.hasAccessToParentWindow=function(e){return!!Object.getPrototypeOf(e.parent)},t.hasClass=function(e,t){if(void 0===e.classList||"string"!=typeof t||""===t)return!1;return e.classList.contains(t)},t.hasHorizontalScrollbar=function(e){return e.offsetHeight!==e.clientHeight},t.hasVerticalScrollbar=function(e){return e.offsetWidth!==e.clientWidth},t.index=function(e){let t=0,r=e;if(r.previousSibling)for(;r=r.previousSibling;)t+=1;return t},t.innerHeight=function(e){return e.clientHeight||e.innerHeight},t.innerWidth=function(e){return e.clientWidth||e.innerWidth},t.isChildOf=function(e,t){let r=e.parentNode,n=[];"string"==typeof t?n=e.defaultView?Array.prototype.slice.call(e.querySelectorAll(t),0):Array.prototype.slice.call(e.ownerDocument.querySelectorAll(t),0):n.push(t);for(;null!==r;){if(n.indexOf(r)>-1)return!0;r=r.parentNode}return!1},t.isDetached=function(e){return!e.parentNode},t.isInput=w,t.isOutsideInput=C,t.isThisHotChild=function(e,t){const r=e.closest(".handsontable");return!!r&&(r.parentNode===t||r===t)},t.isVisible=function e(t){const r=t.ownerDocument.documentElement;let n=t;for(;n!==r;){if(null===n)return!1;if(n.nodeType===Node.DOCUMENT_FRAGMENT_NODE){if(n.host){if(n.host.impl)return e(n.host.impl);if(n.host)return e(n.host);throw new Error("Lost in Web Components world")}return!1}if("none"===E(n).display)return!1;n=n.parentNode}return!0},t.makeElementContentEditableAndSelectItsContent=R,t.matchesCSSRules=function(e,t){const{selectorText:r}=t;let n=!1;t.type===CSSRule.STYLE_RULE&&r&&(e.msMatchesSelector?n=e.msMatchesSelector(r):e.matches&&(n=e.matches(r)));return n},t.observeVisibilityChangeOnce=function(e,t){new IntersectionObserver(((r,n)=>{r.forEach((r=>{r.isIntersecting&&null!==e.offsetParent&&(t(),n.unobserve(e))}))}),{root:e.ownerDocument.body}).observe(e)},t.offset=function(e){const t=e.ownerDocument,r=t.defaultView,n=t.documentElement;let s,o,i,a=e;s=a.offsetLeft,o=a.offsetTop,i=a;for(;(a=a.offsetParent)&&a!==t.body&&"offsetLeft"in a;)s+=a.offsetLeft,o+=a.offsetTop,i=a;i&&"fixed"===i.style.position&&(s+=r.pageXOffset||n.scrollLeft,o+=r.pageYOffset||n.scrollTop);return{left:s,top:o}},t.outerHeight=function(e){return e.offsetHeight},t.outerWidth=function(e){return e.offsetWidth},t.overlayContainsElement=function(e,t,r){const n=r.parentElement.querySelector(`.ht_clone_${e}`);return n?n.contains(t):null},t.removeAttribute=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];"string"==typeof t?t=t.split(" "):t instanceof RegExp&&(t=[t]);const{regexFree:r,regexes:n}=l(t,!0);r.forEach((t=>{""!==t&&e.removeAttribute(t)})),n.forEach((t=>{e.getAttributeNames().forEach((r=>{t.test(r)&&e.removeAttribute(r)}))}))},t.removeClass=u,t.removeContentEditableFromElementAndDeselect=v,t.removeEvent=function(e,t,r){e.removeEventListener(t,r,!1)},t.removeTextNodes=function e(t){if(3===t.nodeType)t.parentNode.removeChild(t);else if(["TABLE","THEAD","TBODY","TFOOT","TR"].indexOf(t.nodeName)>-1){const r=t.childNodes;for(let t=r.length-1;t>=0;t--)e(r[t])}},t.resetCssTransform=function(e){e.style.transform&&""!==e.style.transform&&(e.style.transform="")},t.runWithSelectedContendEditableElement=function(e,t){let r=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];R(e,r),t(),v(e,r)},t.selectElementIfAllowed=function(e){C(e.ownerDocument.activeElement)||e.select()},t.setAttribute=c,t.setCaretPosition=function(e,t,r){void 0===r&&(r=t);if(e.setSelectionRange){e.focus();try{e.setSelectionRange(t,r)}catch(n){const s=e.parentNode,o=s.style.display;s.style.display="block",e.setSelectionRange(t,r),s.style.display=o}}},t.setOverlayPosition=function(e,t,r){e.style.transform=`translate3d(${t},${r},0)`},r(67834),r(15724);var n=r(69114),s=r(81595);function o(e){return Object.getPrototypeOf(e.parent)&&e.frameElement}function i(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],r=arguments.length>2?arguments[2]:void 0;const{ELEMENT_NODE:n,DOCUMENT_FRAGMENT_NODE:s}=Node;let o=e;for(;null!=o&&o!==r;){const{nodeType:e,nodeName:r}=o;if(e===n&&(t.includes(r)||t.includes(o)))return o;const{host:i}=o;o=i&&e===s?i:o.parentNode}return null}function a(e){return e&&e.length?e.filter((e=>!!e)):[]}function l(e,t){if(!e||!e.length)return t?{regexFree:[],regexes:[]}:[];const r=[],n=[];return n.push(...e.filter((e=>{const n=e instanceof RegExp;return n&&t&&r.push(e),!n}))),t?{regexFree:n,regexes:r}:n}function h(e,t){"string"==typeof t&&(t=t.split(" ")),(t=a(t)).length>0&&e.classList.add(...t)}function u(e,t){"string"==typeof t?t=t.split(" "):t instanceof RegExp&&(t=[t]);let{regexFree:r,regexes:n}=l(t,!0);r=a(r),r.length>0&&e.classList.remove(...r),n.forEach((t=>{e.classList.forEach((r=>{t.test(r)&&e.classList.remove(r)}))}))}function c(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],r=arguments.length>2?arguments[2]:void 0;Array.isArray(t)||(t=[[t,r]]),t.forEach((t=>{Array.isArray(t)&&""!==t[0]&&e.setAttribute(...t)}))}function d(e){let t;for(;t=e.lastChild;)e.removeChild(t)}const p=t.HTML_CHARACTERS=/(<(.*)>|&(.*);)/;function g(e,t){const r=e.firstChild;r&&3===r.nodeType&&null===r.nextSibling?r.textContent=t:(d(e),e.appendChild(e.ownerDocument.createTextNode(t)))}function f(){return(arguments.length>0&&void 0!==arguments[0]?arguments[0]:window).scrollY}function m(){return(arguments.length>0&&void 0!==arguments[0]?arguments[0]:window).scrollX}function E(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:window;return e.currentStyle||t.getComputedStyle(e)}let y;function w(e){return e&&(["INPUT","SELECT","TEXTAREA"].indexOf(e.nodeName)>-1||"true"===e.contentEditable)}function C(e){return w(e)&&!1===e.hasAttribute("data-hot-input")}function R(e){let t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1],r=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];const n=e.ownerDocument,o=n.createRange(),i=n.defaultView.getSelection();c(e,"contenteditable",!0),r&&c(e,...(0,s.A11Y_HIDDEN)()),t&&h(e,"invisibleSelection"),o.selectNodeContents(e),i.removeAllRanges(),i.addRange(o)}function v(e){let t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];const r=e.ownerDocument.defaultView.getSelection();e.hasAttribute("aria-hidden")&&e.removeAttribute("aria-hidden"),r.removeAllRanges(),t&&u(e,"invisibleSelection"),e.removeAttribute("contenteditable")}},24456:(e,t)=>{"use strict";t.__esModule=!0,t.isImmediatePropagationStopped=function(e){return!1===e.isImmediatePropagationEnabled},t.isLeftClick=function(e){return 0===e.button},t.isRightClick=function(e){return 2===e.button},t.offsetRelativeTo=function(e,t){const r={x:e.offsetX,y:e.offsetY};let n=e.target;if(!(t instanceof HTMLElement)||n!==t&&n.contains(t))return r;for(;n!==t;)r.x+=n.offsetLeft,r.y+=n.offsetTop,n=n.offsetParent;return r},t.stopImmediatePropagation=function(e){e.isImmediatePropagationEnabled=!1,e.cancelBubble=!0}},36201:(e,t)=>{"use strict";let r;t.__esModule=!0,t.cancelAnimationFrame=function(e){window.cancelAnimationFrame(e)},t.getComparisonFunction=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(r)return r;r="object"==typeof Intl?new Intl.Collator(e,t).compare:"function"==typeof String.prototype.localeCompare?(e,t)=>`${e}`.localeCompare(t):(e,t)=>e===t?0:e>t?-1:1;return r},t.isCSR=function(){return"undefined"!=typeof window},t.isTouchSupported=function(){return"ontouchstart"in window},t.requestAnimationFrame=function(e){return window.requestAnimationFrame(e)}},25735:(e,t,r)=>{"use strict";t.__esModule=!0,t.curry=function(e){const t=e.length;return function r(n){return function(){for(var s=arguments.length,o=new Array(s),i=0;i<s;i++)o[i]=arguments[i];const a=n.concat(o);let l;return l=a.length>=t?e.apply(this,a):r(a),l}}([])},t.curryRight=function(e){const t=e.length;return function r(n){return function(){for(var s=arguments.length,o=new Array(s),i=0;i<s;i++)o[i]=arguments[i];const a=n.concat(o.reverse());let l;return l=a.length>=t?e.apply(this,a):r(a),l}}([])},t.debounce=function(e){let t,r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:200,n=null;return function(){for(var s=arguments.length,o=new Array(s),i=0;i<s;i++)o[i]=arguments[i];return n&&clearTimeout(n),n=setTimeout((()=>{t=e.apply(this,o)}),r),t}},t.fastCall=function(e,t,r,n,o,i,a,l){if((0,s.isDefined)(l))return e.call(t,r,n,o,i,a,l);if((0,s.isDefined)(a))return e.call(t,r,n,o,i,a);if((0,s.isDefined)(i))return e.call(t,r,n,o,i);if((0,s.isDefined)(o))return e.call(t,r,n,o);if((0,s.isDefined)(n))return e.call(t,r,n);if((0,s.isDefined)(r))return e.call(t,r);return e.call(t)},t.isFunction=function(e){return"function"==typeof e},t.partial=function(e){for(var t=arguments.length,r=new Array(t>1?t-1:0),n=1;n<t;n++)r[n-1]=arguments[n];return function(){for(var t=arguments.length,n=new Array(t),s=0;s<t;s++)n[s]=arguments[s];return e.apply(this,r.concat(n))}},t.pipe=function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];const[s,...o]=t;return function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return(0,n.arrayReduce)(o,((e,t)=>t(e)),s.apply(this,t))}},t.throttle=o,t.throttleAfterHits=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:200,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:10;const n=o(e,t);let s=r;function i(){for(var t=arguments.length,r=new Array(t),o=0;o<t;o++)r[o]=arguments[o];return s?(s-=1,e.apply(this,r)):n.apply(this,r)}return i.clearHits=function(){s=r},i};var n=r(98758),s=r(67508);function o(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:200,r=0;const n={lastCallThrottled:!0};let s=null;return function(){for(var o=arguments.length,i=new Array(o),a=0;a<o;a++)i[a]=arguments[a];const l=Date.now();let h=!1;n.lastCallThrottled=!0,r||(r=l,h=!0);const u=t-(l-r);return h?(n.lastCallThrottled=!1,e.apply(this,i)):(s&&clearTimeout(s),s=setTimeout((()=>{n.lastCallThrottled=!1,e.apply(this,i),r=0,s=void 0}),u)),n}}},67508:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t._injectProductInfo=function(e,t){const r=!a(e),n="string"==typeof e&&"non-commercial-and-evaluation"===e.toLowerCase(),o="14.3.0";let i,w="invalid",C="invalid";const R=function(e){let t=[][l],r=t;if(e[l]!==d("Z"))return!1;for(let t="",n="B<H4P+".split(""),s=d(n.shift());s;s=d(n.shift()||"A"))--s<""[l]?r|=(u(`${u(h(t)+(h(c(e,Math.abs(s),2))+[]).padStart(2,"0"))}`)%97||2)>>1:t=c(e,s,s?1===n[l]?9:8:6);return r===t}(e=p(e||""));if(r||n||R)if(R){const t=(0,s.default)("16/04/2024","DD/MM/YYYY"),r=Math.floor(t.toDate().getTime()/864e5),n=g(e);i=(0,s.default)(864e5*(n+1),"x").format("MMMM DD, YYYY"),r>n?(w="expired",C="expired"):(w="valid",C="valid")}else n?(w="non_commercial",C="valid"):(w="invalid",C="invalid");else w="missing",C="missing";f()&&(w="valid",C="valid");if(!m&&"valid"!==w){E[w]({keyValidityDate:i,hotVersion:o})&&console["non_commercial"===w?"info":"warn"](E[w]({keyValidityDate:i,hotVersion:o})),m=!0}if("valid"!==C&&t.parentNode){if(y[C]({keyValidityDate:i,hotVersion:o})){const e=document.createElement("div");e.className="hot-display-license-info",e.innerHTML=y[C]({keyValidityDate:i,hotVersion:o}),t.parentNode.insertBefore(e,t.nextSibling)}}},t.isDefined=function(e){return void 0!==e},t.isEmpty=a,t.isRegExp=function(e){return"[object RegExp]"===Object.prototype.toString.call(e)},t.isUndefined=i,t.stringify=function(e){let t;switch(typeof e){case"string":case"number":t=`${e}`;break;case"object":t=null===e?"":e.toString();break;case"undefined":t="";break;default:t=e.toString()}return t};var s=n(r(56476)),o=r(12556);function i(e){return void 0===e}function a(e){return null===e||""===e||i(e)}const l="length",h=e=>parseInt(e,16),u=e=>parseInt(e,10),c=(e,t,r)=>e.substr(t,r),d=e=>e.codePointAt(0)-65,p=e=>`${e}`.replace(/\-/g,""),g=e=>h(c(p(e),h("12"),d("F")))/(h(c(p(e),d("B"),~~![][l]))||9),f=()=>"undefined"!=typeof location&&/^([a-z0-9\-]+\.)?\x68\x61\x6E\x64\x73\x6F\x6E\x74\x61\x62\x6C\x65\x2E\x63\x6F\x6D$/i.test(location.host);let m=!1;const E={invalid:()=>o.toSingleLine`
    The license key for Handsontable is invalid.\x20
    If you need any help, contact us at support@handsontable.com.`,expired:e=>{let{keyValidityDate:t,hotVersion:r}=e;return o.toSingleLine`
    The license key for Handsontable expired on ${t}, and is not valid for the installed\x20
    version ${r}. Renew your license key at handsontable.com or downgrade to a version released prior\x20
    to ${t}. If you need any help, contact us at sales@handsontable.com.`},missing:()=>o.toSingleLine`
    The license key for Handsontable is missing. Use your purchased key to activate the product.\x20
    Alternatively, you can activate Handsontable to use for non-commercial purposes by\x20
    passing the key: 'non-commercial-and-evaluation'. If you need any help, contact\x20
    us at support@handsontable.com.`,non_commercial:()=>""},y={invalid:()=>o.toSingleLine`
    The license key for Handsontable is invalid.\x20
    <a href="https://handsontable.com/docs/tutorial-license-key.html" target="_blank">Read more</a> on how to\x20
    install it properly or contact us at <a href="mailto:support@handsontable.com">support@handsontable.com</a>.`,expired:e=>{let{keyValidityDate:t,hotVersion:r}=e;return o.toSingleLine`
    The license key for Handsontable expired on ${t}, and is not valid for the installed\x20
    version ${r}. <a href="https://handsontable.com/pricing" target="_blank">Renew</a> your\x20
    license key or downgrade to a version released prior to ${t}. If you need any\x20
    help, contact us at <a href="mailto:sales@handsontable.com">sales@handsontable.com</a>.`},missing:()=>o.toSingleLine`
    The license key for Handsontable is missing. Use your purchased key to activate the product.\x20
    Alternatively, you can activate Handsontable to use for non-commercial purposes by\x20
    passing the key: 'non-commercial-and-evaluation'.\x20
    <a href="https://handsontable.com/docs/tutorial-license-key.html" target="_blank">Read more</a> about it in\x20
    the documentation or contact us at <a href="mailto:support@handsontable.com">support@handsontable.com</a>.`,non_commercial:()=>""}},34261:(e,t,r)=>{"use strict";t.__esModule=!0,t.getMoves=function(e,t,r){return function(e){return e.forEach(((t,r)=>{e.slice(r+1).forEach((e=>{const r=e.from<e.to;e.from>t.from&&r&&(e.from-=1)}))})),e}(function(e,t){const r=[];return e.forEach((e=>{const n={from:e,to:t};r.forEach((e=>{const t=e.from>e.to,r=e.to<=n.from;e.from>n.from&&r&&t&&(n.from+=1)})),n.from>=t&&(t+=1),r.push(n)})),r}(e,function(e,t,r){const n=Array.from(Array(r).keys()).filter((t=>!1===e.includes(t)));var s;return 0===t?null!==(s=n[t])&&void 0!==s?s:0:n[t-1]+1}(e,t,r)))},r(15724)},27050:(e,t)=>{"use strict";function r(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];const r=typeof e;if("number"===r)return!isNaN(e)&&isFinite(e);if("string"===r){if(0===e.length)return!1;if(1===e.length)return/\d/.test(e);const r=Array.from(new Set([".",...t])).map((e=>`\\${e}`)).join("|");return new RegExp(`^[+-]?\\s*(((${r})?\\d+((${r})\\d+)?(e[+-]?\\d+)?)|(0x[a-f\\d]+))$`,"i").test(e.trim())}return"object"===r&&!(!e||"number"!=typeof e.valueOf()||e instanceof Date)}t.__esModule=!0,t.clamp=function(e,t,r){if(Math.min(e,t)===e)return t;if(Math.max(e,r)===e)return r;return e},t.isNumeric=r,t.isNumericLike=function(e){return r(e,[","])},t.rangeEach=function(e,t,r){let n=-1;"function"==typeof t?(r=t,t=e):n=e-1;for(;++n<=t&&!1!==r(n););},t.rangeEachReverse=function(e,t,r){let n=e+1;"function"==typeof t&&(r=t,t=0);for(;--n>=t&&!1!==r(n););},t.valueAccordingPercent=function(e,t){return t=parseInt(t.toString().replace("%",""),10),t=isNaN(t)?0:t,parseInt(e*t/100,10)}},58460:(e,t,r)=>{"use strict";t.__esModule=!0,t.clone=function(e){const t={};return i(e,((e,r)=>{t[r]=e})),t},t.createObjectPropListener=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"value";const r=`_${t}`,n={_touched:!1,[r]:e,isTouched(){return this._touched}};return Object.defineProperty(n,t,{get(){return this[r]},set(e){this._touched=!0,this[r]=e},enumerable:!0,configurable:!0}),n},t.deepClone=s,t.deepExtend=function e(t,r){i(r,((n,s)=>{r[s]&&"object"==typeof r[s]?(t[s]||(Array.isArray(r[s])?t[s]=[]:"[object Date]"===Object.prototype.toString.call(r[s])?t[s]=r[s]:t[s]={}),e(t[s],r[s])):t[s]=r[s]}))},t.deepObjectSize=function(e){if(!o(e))return 0;const t=function(e){let r=0;return o(e)?i(e,((e,n)=>{"__children"!==n&&(r+=t(e))})):r+=1,r};return t(e)},t.defineGetter=function(e,t,r,n){n.value=r,n.writable=!1!==n.writable,n.enumerable=!1!==n.enumerable,n.configurable=!1!==n.configurable,Object.defineProperty(e,t,n)},t.duckSchema=function e(t){let r;Array.isArray(t)?r=t.length?new Array(t.length).fill(null):[]:(r={},i(t,((t,n)=>{"__children"!==n&&(t&&"object"==typeof t&&!Array.isArray(t)?r[n]=e(t):Array.isArray(t)?t.length&&"object"==typeof t[0]&&!Array.isArray(t[0])?r[n]=[e(t[0])]:r[n]=[]:r[n]=null)})));return r},t.extend=function(e,t,r){const n=Array.isArray(r);return i(t,((t,s)=>{(!1===n||r.includes(s))&&(e[s]=t)})),e},t.getProperty=function(e,t){const r=t.split(".");let n=e;return i(r,(e=>{if(n=n[e],void 0===n)return n=void 0,!1})),n},t.hasOwnProperty=a,t.inherit=function(e,t){return t.prototype.constructor=t,e.prototype=new t,e.prototype.constructor=e,e},t.isObject=o,t.isObjectEqual=function(e,t){return JSON.stringify(e)===JSON.stringify(t)},t.mixin=function(e){e.MIXINS||(e.MIXINS=[]);for(var t=arguments.length,r=new Array(t>1?t-1:0),a=1;a<t;a++)r[a-1]=arguments[a];return(0,n.arrayEach)(r,(t=>{e.MIXINS.push(t.MIXIN_NAME),i(t,((t,r)=>{if(void 0!==e.prototype[r])throw new Error(`Mixin conflict. Property '${r}' already exist and cannot be overwritten.`);if("function"==typeof t)e.prototype[r]=t;else{const n=function(e,t){const r=`_${e}`;return function(){return void 0===this[r]&&(this[r]=(e=>{let t=e;return(Array.isArray(t)||o(t))&&(t=s(t)),t})(t)),this[r]}},i=function(e){const t=`_${e}`;return function(e){this[t]=e}};Object.defineProperty(e.prototype,r,{get:n(r,t),set:i(r),configurable:!0})}}))})),e},t.objectEach=i,t.setProperty=function(e,t,r){const n=t.split(".");let s=e;n.forEach(((e,t)=>{t!==n.length-1?(a(s,e)||(s[e]={}),s=s[e]):s[e]=r}))},r(67834),r(15724),r(66184);var n=r(98758);function s(e){return"object"==typeof e?JSON.parse(JSON.stringify(e)):e}function o(e){return"[object Object]"===Object.prototype.toString.call(e)}function i(e,t){for(const r in e)if((!e.hasOwnProperty||e.hasOwnProperty&&Object.prototype.hasOwnProperty.call(e,r))&&!1===t(e[r],r,e))break;return e}function a(e,t){return Object.prototype.hasOwnProperty.call(e,t)}},69114:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.equalsIgnoreCase=function(){const e=[];for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];let s=r.length;for(;s;){s-=1;const t=(0,o.stringify)(r[s]).toLowerCase();-1===e.indexOf(t)&&e.push(t)}return 1===e.length},t.isPercentValue=function(e){return/^([0-9][0-9]?%$)|(^100%$)/.test(e)},t.randomString=function(){function e(){return Math.floor(65536*(1+Math.random())).toString(16).substring(1)}return e()+e()+e()+e()},t.sanitize=i,t.stripTags=function(e){return i(`${e}`,{ALLOWED_TAGS:[]})},t.substitute=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return`${e}`.replace(/(?:\\)?\[([^[\]]+)]/g,((e,r)=>"\\"===e.charAt(0)?e.substr(1,e.length-1):void 0===t[r]?"":t[r]))},t.toUpperCaseFirst=function(e){return e[0].toUpperCase()+e.substr(1)},r(15724);var s=n(r(14130)),o=r(67508);function i(e,t){return s.default.sanitize(e,t)}},12556:(e,t,r)=>{"use strict";t.__esModule=!0,t.toSingleLine=function(e){for(var t=arguments.length,r=new Array(t>1?t-1:0),s=1;s<t;s++)r[s-1]=arguments[s];return(0,n.arrayReduce)(e,((e,t,n)=>e+t.replace(/\r?\n\s*/g,"")+(r[n]?r[n]:"")),"").trim()};var n=r(98758)},35592:(e,t,r)=>{"use strict";t.__esModule=!0,t.isCtrlKey=function(e){const t=[];(0,s.isMacOS)()?t.push(o.COMMAND_LEFT,o.COMMAND_RIGHT,o.COMMAND_FIREFOX):t.push(o.CONTROL);return t.includes(e)},t.isCtrlMetaKey=function(e){return[o.CONTROL,o.COMMAND_LEFT,o.COMMAND_RIGHT,o.COMMAND_FIREFOX].includes(e)},t.isFunctionKey=function(e){return i.includes(e)},t.isKey=function(e,t){const r=t.split("|");let s=!1;return(0,n.arrayEach)(r,(t=>{if(e===o[t])return s=!0,!1})),s},t.isPrintableChar=function(e){return 32===e||e>=48&&e<=57||e>=96&&e<=111||e>=186&&e<=192||e>=219&&e<=222||e>=226||e>=65&&e<=90},r(15724);var n=r(98758),s=r(1479);const o=t.KEY_CODES={ALT:18,ARROW_DOWN:40,ARROW_LEFT:37,ARROW_RIGHT:39,ARROW_UP:38,AUDIO_DOWN:(0,s.isFirefox)()?182:174,AUDIO_MUTE:(0,s.isFirefox)()?181:173,AUDIO_UP:(0,s.isFirefox)()?183:175,BACKSPACE:8,CAPS_LOCK:20,COMMA:188,COMMAND_LEFT:91,COMMAND_RIGHT:93,COMMAND_FIREFOX:224,CONTROL:17,DELETE:46,END:35,ENTER:13,ESCAPE:27,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,F12:123,F13:124,F14:125,F15:126,F16:127,F17:128,F18:129,F19:130,HOME:36,INSERT:45,MEDIA_NEXT:176,MEDIA_PLAY_PAUSE:179,MEDIA_PREV:177,MEDIA_STOP:178,NULL:0,NUM_LOCK:144,PAGE_DOWN:34,PAGE_UP:33,PAUSE:19,PERIOD:190,SCROLL_LOCK:145,SHIFT:16,SPACE:32,TAB:9,A:65,C:67,D:68,F:70,L:76,O:79,P:80,S:83,V:86,X:88,Y:89,Z:90},i=[o.ALT,o.ARROW_DOWN,o.ARROW_LEFT,o.ARROW_RIGHT,o.ARROW_UP,o.AUDIO_DOWN,o.AUDIO_MUTE,o.AUDIO_UP,o.BACKSPACE,o.CAPS_LOCK,o.DELETE,o.END,o.ENTER,o.ESCAPE,o.F1,o.F2,o.F3,o.F4,o.F5,o.F6,o.F7,o.F8,o.F9,o.F10,o.F11,o.F12,o.F13,o.F14,o.F15,o.F16,o.F17,o.F18,o.F19,o.HOME,o.INSERT,o.MEDIA_NEXT,o.MEDIA_PLAY_PAUSE,o.MEDIA_PREV,o.MEDIA_STOP,o.NULL,o.NUM_LOCK,o.PAGE_DOWN,o.PAGE_UP,o.PAUSE,o.SCROLL_LOCK,o.SHIFT,o.TAB]},27952:(e,t,r)=>{"use strict";t.__esModule=!0,t.default=function(e){const t="undefined"!=typeof window&&window.jQuery;if(!t)return;t.fn.handsontable=function(t){const r=this.first();let n,s=r.data("handsontable");if("string"!=typeof t){const n=t||{};return s?s.updateSettings(n):(s=new e.Core(r[0],n),r.data("handsontable",s),s.init()),r}if(s){if(void 0===s[t])throw new Error(`Handsontable do not provide action: ${t}`);for(var o=arguments.length,i=new Array(o>1?o-1:0),a=1;a<o;a++)i[a-1]=arguments[a];n=s[t].call(s,...i),"destroy"===t&&r.removeData()}return n}},r(67834)},63751:(e,t)=>{"use strict";t.__esModule=!0;const r=t.CONTEXT_MENU_ITEMS_NAMESPACE="ContextMenu:items",n=(t.CONTEXTMENU_ITEMS_NO_ITEMS=`${r}.noItems`,t.CONTEXTMENU_ITEMS_ROW_ABOVE=`${r}.insertRowAbove`,t.CONTEXTMENU_ITEMS_ROW_BELOW=`${r}.insertRowBelow`,t.CONTEXTMENU_ITEMS_INSERT_LEFT=`${r}.insertColumnOnTheLeft`,t.CONTEXTMENU_ITEMS_INSERT_RIGHT=`${r}.insertColumnOnTheRight`,t.CONTEXTMENU_ITEMS_REMOVE_ROW=`${r}.removeRow`,t.CONTEXTMENU_ITEMS_REMOVE_COLUMN=`${r}.removeColumn`,t.CONTEXTMENU_ITEMS_UNDO=`${r}.undo`,t.CONTEXTMENU_ITEMS_REDO=`${r}.redo`,t.CONTEXTMENU_ITEMS_READ_ONLY=`${r}.readOnly`,t.CONTEXTMENU_ITEMS_CLEAR_COLUMN=`${r}.clearColumn`,t.CONTEXTMENU_ITEMS_COPY=`${r}.copy`,t.CONTEXTMENU_ITEMS_COPY_WITH_COLUMN_HEADERS=`${r}.copyWithHeaders`,t.CONTEXTMENU_ITEMS_COPY_WITH_COLUMN_GROUP_HEADERS=`${r}.copyWithGroupHeaders`,t.CONTEXTMENU_ITEMS_COPY_COLUMN_HEADERS_ONLY=`${r}.copyHeadersOnly`,t.CONTEXTMENU_ITEMS_CUT=`${r}.cut`,t.CONTEXTMENU_ITEMS_FREEZE_COLUMN=`${r}.freezeColumn`,t.CONTEXTMENU_ITEMS_UNFREEZE_COLUMN=`${r}.unfreezeColumn`,t.CONTEXTMENU_ITEMS_MERGE_CELLS=`${r}.mergeCells`,t.CONTEXTMENU_ITEMS_UNMERGE_CELLS=`${r}.unmergeCells`,t.CONTEXTMENU_ITEMS_ADD_COMMENT=`${r}.addComment`,t.CONTEXTMENU_ITEMS_EDIT_COMMENT=`${r}.editComment`,t.CONTEXTMENU_ITEMS_REMOVE_COMMENT=`${r}.removeComment`,t.CONTEXTMENU_ITEMS_READ_ONLY_COMMENT=`${r}.readOnlyComment`,t.CONTEXTMENU_ITEMS_ALIGNMENT=`${r}.align`,t.CONTEXTMENU_ITEMS_ALIGNMENT_LEFT=`${r}.align.left`,t.CONTEXTMENU_ITEMS_ALIGNMENT_CENTER=`${r}.align.center`,t.CONTEXTMENU_ITEMS_ALIGNMENT_RIGHT=`${r}.align.right`,t.CONTEXTMENU_ITEMS_ALIGNMENT_JUSTIFY=`${r}.align.justify`,t.CONTEXTMENU_ITEMS_ALIGNMENT_TOP=`${r}.align.top`,t.CONTEXTMENU_ITEMS_ALIGNMENT_MIDDLE=`${r}.align.middle`,t.CONTEXTMENU_ITEMS_ALIGNMENT_BOTTOM=`${r}.align.bottom`,t.CONTEXTMENU_ITEMS_BORDERS=`${r}.borders`,t.CONTEXTMENU_ITEMS_BORDERS_TOP=`${r}.borders.top`,t.CONTEXTMENU_ITEMS_BORDERS_RIGHT=`${r}.borders.right`,t.CONTEXTMENU_ITEMS_BORDERS_BOTTOM=`${r}.borders.bottom`,t.CONTEXTMENU_ITEMS_BORDERS_LEFT=`${r}.borders.left`,t.CONTEXTMENU_ITEMS_REMOVE_BORDERS=`${r}.borders.remove`,t.CONTEXTMENU_ITEMS_NESTED_ROWS_INSERT_CHILD=`${r}.nestedHeaders.insertChildRow`,t.CONTEXTMENU_ITEMS_NESTED_ROWS_DETACH_CHILD=`${r}.nestedHeaders.detachFromParent`,t.CONTEXTMENU_ITEMS_HIDE_COLUMN=`${r}.hideColumn`,t.CONTEXTMENU_ITEMS_SHOW_COLUMN=`${r}.showColumn`,t.CONTEXTMENU_ITEMS_HIDE_ROW=`${r}.hideRow`,t.CONTEXTMENU_ITEMS_SHOW_ROW=`${r}.showRow`,t.FILTERS_NAMESPACE="Filters:"),s=t.FILTERS_CONDITIONS_NAMESPACE=`${n}conditions`,o=(t.FILTERS_CONDITIONS_NONE=`${s}.none`,t.FILTERS_CONDITIONS_EMPTY=`${s}.isEmpty`,t.FILTERS_CONDITIONS_NOT_EMPTY=`${s}.isNotEmpty`,t.FILTERS_CONDITIONS_EQUAL=`${s}.isEqualTo`,t.FILTERS_CONDITIONS_NOT_EQUAL=`${s}.isNotEqualTo`,t.FILTERS_CONDITIONS_BEGINS_WITH=`${s}.beginsWith`,t.FILTERS_CONDITIONS_ENDS_WITH=`${s}.endsWith`,t.FILTERS_CONDITIONS_CONTAINS=`${s}.contains`,t.FILTERS_CONDITIONS_NOT_CONTAIN=`${s}.doesNotContain`,t.FILTERS_CONDITIONS_BY_VALUE=`${s}.byValue`,t.FILTERS_CONDITIONS_GREATER_THAN=`${s}.greaterThan`,t.FILTERS_CONDITIONS_GREATER_THAN_OR_EQUAL=`${s}.greaterThanOrEqualTo`,t.FILTERS_CONDITIONS_LESS_THAN=`${s}.lessThan`,t.FILTERS_CONDITIONS_LESS_THAN_OR_EQUAL=`${s}.lessThanOrEqualTo`,t.FILTERS_CONDITIONS_BETWEEN=`${s}.isBetween`,t.FILTERS_CONDITIONS_NOT_BETWEEN=`${s}.isNotBetween`,t.FILTERS_CONDITIONS_AFTER=`${s}.after`,t.FILTERS_CONDITIONS_BEFORE=`${s}.before`,t.FILTERS_CONDITIONS_TODAY=`${s}.today`,t.FILTERS_CONDITIONS_TOMORROW=`${s}.tomorrow`,t.FILTERS_CONDITIONS_YESTERDAY=`${s}.yesterday`,t.FILTERS_DIVS_FILTER_BY_CONDITION=`${n}labels.filterByCondition`,t.FILTERS_DIVS_FILTER_BY_VALUE=`${n}labels.filterByValue`,t.FILTERS_LABELS_CONJUNCTION=`${n}labels.conjunction`,t.FILTERS_LABELS_DISJUNCTION=`${n}labels.disjunction`,t.FILTERS_VALUES_BLANK_CELLS=`${n}values.blankCells`,t.FILTERS_BUTTONS_SELECT_ALL=`${n}buttons.selectAll`,t.FILTERS_BUTTONS_CLEAR=`${n}buttons.clear`,t.FILTERS_BUTTONS_OK=`${n}buttons.ok`,t.FILTERS_BUTTONS_CANCEL=`${n}buttons.cancel`,t.FILTERS_BUTTONS_PLACEHOLDER_SEARCH=`${n}buttons.placeholder.search`,t.FILTERS_BUTTONS_PLACEHOLDER_VALUE=`${n}buttons.placeholder.value`,t.FILTERS_BUTTONS_PLACEHOLDER_SECOND_VALUE=`${n}buttons.placeholder.secondValue`,t.CHECKBOX_RENDERER_NAMESPACE="CheckboxRenderer:");t.CHECKBOX_CHECKED=`${o}checked`,t.CHECKBOX_UNCHECKED=`${o}unchecked`},33064:(e,t,r)=>{"use strict";t.__esModule=!0;var n=function(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var r=s(t);if(r&&r.has(e))return r.get(e);var n={__proto__:null},o=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var i in e)if("default"!==i&&{}.hasOwnProperty.call(e,i)){var a=o?Object.getOwnPropertyDescriptor(e,i):null;a&&(a.get||a.set)?Object.defineProperty(n,i,a):n[i]=e[i]}return n.default=e,r&&r.set(e,n),n
/**
 * @preserve
 * Authors: Handsoncode
 * Last updated: Nov 15, 2017
 *
 * Description: Definition file for English - United States language-country.
 */}(r(63751));function s(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,r=new WeakMap;return(s=function(e){return e?r:t})(e)}const o={languageCode:"en-US",[n.CONTEXTMENU_ITEMS_NO_ITEMS]:"No available options",[n.CONTEXTMENU_ITEMS_ROW_ABOVE]:"Insert row above",[n.CONTEXTMENU_ITEMS_ROW_BELOW]:"Insert row below",[n.CONTEXTMENU_ITEMS_INSERT_LEFT]:"Insert column left",[n.CONTEXTMENU_ITEMS_INSERT_RIGHT]:"Insert column right",[n.CONTEXTMENU_ITEMS_REMOVE_ROW]:["Remove row","Remove rows"],[n.CONTEXTMENU_ITEMS_REMOVE_COLUMN]:["Remove column","Remove columns"],[n.CONTEXTMENU_ITEMS_UNDO]:"Undo",[n.CONTEXTMENU_ITEMS_REDO]:"Redo",[n.CONTEXTMENU_ITEMS_READ_ONLY]:"Read only",[n.CONTEXTMENU_ITEMS_CLEAR_COLUMN]:"Clear column",[n.CONTEXTMENU_ITEMS_ALIGNMENT]:"Alignment",[n.CONTEXTMENU_ITEMS_ALIGNMENT_LEFT]:"Left",[n.CONTEXTMENU_ITEMS_ALIGNMENT_CENTER]:"Center",[n.CONTEXTMENU_ITEMS_ALIGNMENT_RIGHT]:"Right",[n.CONTEXTMENU_ITEMS_ALIGNMENT_JUSTIFY]:"Justify",[n.CONTEXTMENU_ITEMS_ALIGNMENT_TOP]:"Top",[n.CONTEXTMENU_ITEMS_ALIGNMENT_MIDDLE]:"Middle",[n.CONTEXTMENU_ITEMS_ALIGNMENT_BOTTOM]:"Bottom",[n.CONTEXTMENU_ITEMS_FREEZE_COLUMN]:"Freeze column",[n.CONTEXTMENU_ITEMS_UNFREEZE_COLUMN]:"Unfreeze column",[n.CONTEXTMENU_ITEMS_BORDERS]:"Borders",[n.CONTEXTMENU_ITEMS_BORDERS_TOP]:"Top",[n.CONTEXTMENU_ITEMS_BORDERS_RIGHT]:"Right",[n.CONTEXTMENU_ITEMS_BORDERS_BOTTOM]:"Bottom",[n.CONTEXTMENU_ITEMS_BORDERS_LEFT]:"Left",[n.CONTEXTMENU_ITEMS_REMOVE_BORDERS]:"Remove border(s)",[n.CONTEXTMENU_ITEMS_ADD_COMMENT]:"Add comment",[n.CONTEXTMENU_ITEMS_EDIT_COMMENT]:"Edit comment",[n.CONTEXTMENU_ITEMS_REMOVE_COMMENT]:"Delete comment",[n.CONTEXTMENU_ITEMS_READ_ONLY_COMMENT]:"Read-only comment",[n.CONTEXTMENU_ITEMS_MERGE_CELLS]:"Merge cells",[n.CONTEXTMENU_ITEMS_UNMERGE_CELLS]:"Unmerge cells",[n.CONTEXTMENU_ITEMS_COPY]:"Copy",[n.CONTEXTMENU_ITEMS_COPY_WITH_COLUMN_HEADERS]:["Copy with header","Copy with headers"],[n.CONTEXTMENU_ITEMS_COPY_WITH_COLUMN_GROUP_HEADERS]:["Copy with group header","Copy with group headers"],[n.CONTEXTMENU_ITEMS_COPY_COLUMN_HEADERS_ONLY]:["Copy header only","Copy headers only"],[n.CONTEXTMENU_ITEMS_CUT]:"Cut",[n.CONTEXTMENU_ITEMS_NESTED_ROWS_INSERT_CHILD]:"Insert child row",[n.CONTEXTMENU_ITEMS_NESTED_ROWS_DETACH_CHILD]:"Detach from parent",[n.CONTEXTMENU_ITEMS_HIDE_COLUMN]:["Hide column","Hide columns"],[n.CONTEXTMENU_ITEMS_SHOW_COLUMN]:["Show column","Show columns"],[n.CONTEXTMENU_ITEMS_HIDE_ROW]:["Hide row","Hide rows"],[n.CONTEXTMENU_ITEMS_SHOW_ROW]:["Show row","Show rows"],[n.FILTERS_CONDITIONS_NONE]:"None",[n.FILTERS_CONDITIONS_EMPTY]:"Is empty",[n.FILTERS_CONDITIONS_NOT_EMPTY]:"Is not empty",[n.FILTERS_CONDITIONS_EQUAL]:"Is equal to",[n.FILTERS_CONDITIONS_NOT_EQUAL]:"Is not equal to",[n.FILTERS_CONDITIONS_BEGINS_WITH]:"Begins with",[n.FILTERS_CONDITIONS_ENDS_WITH]:"Ends with",[n.FILTERS_CONDITIONS_CONTAINS]:"Contains",[n.FILTERS_CONDITIONS_NOT_CONTAIN]:"Does not contain",[n.FILTERS_CONDITIONS_GREATER_THAN]:"Greater than",[n.FILTERS_CONDITIONS_GREATER_THAN_OR_EQUAL]:"Greater than or equal to",[n.FILTERS_CONDITIONS_LESS_THAN]:"Less than",[n.FILTERS_CONDITIONS_LESS_THAN_OR_EQUAL]:"Less than or equal to",[n.FILTERS_CONDITIONS_BETWEEN]:"Is between",[n.FILTERS_CONDITIONS_NOT_BETWEEN]:"Is not between",[n.FILTERS_CONDITIONS_AFTER]:"After",[n.FILTERS_CONDITIONS_BEFORE]:"Before",[n.FILTERS_CONDITIONS_TODAY]:"Today",[n.FILTERS_CONDITIONS_TOMORROW]:"Tomorrow",[n.FILTERS_CONDITIONS_YESTERDAY]:"Yesterday",[n.FILTERS_VALUES_BLANK_CELLS]:"Blank cells",[n.FILTERS_DIVS_FILTER_BY_CONDITION]:"Filter by condition",[n.FILTERS_DIVS_FILTER_BY_VALUE]:"Filter by value",[n.FILTERS_LABELS_CONJUNCTION]:"And",[n.FILTERS_LABELS_DISJUNCTION]:"Or",[n.FILTERS_BUTTONS_SELECT_ALL]:"Select all",[n.FILTERS_BUTTONS_CLEAR]:"Clear",[n.FILTERS_BUTTONS_OK]:"OK",[n.FILTERS_BUTTONS_CANCEL]:"Cancel",[n.FILTERS_BUTTONS_PLACEHOLDER_SEARCH]:"Search",[n.FILTERS_BUTTONS_PLACEHOLDER_VALUE]:"Value",[n.FILTERS_BUTTONS_PLACEHOLDER_SECOND_VALUE]:"Second value",[n.CHECKBOX_CHECKED]:"Checked",[n.CHECKBOX_UNCHECKED]:"Unchecked"};t.default=o},45309:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.getPhraseFormatters=t.getAll=function(){return a()},t.registerPhraseFormatter=t.register=l;var s=n(r(45212)),o=n(r(20037));const{register:i,getValues:a}=(0,s.default)("phraseFormatters");function l(e,t){i(e,t)}l("pluralize",o.default)},20037:(e,t)=>{"use strict";t.__esModule=!0,t.default=function(e,t){if(Array.isArray(e)&&Number.isInteger(t))return e[t];return e}},63055:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.getDefaultLanguageDictionary=function(){return u.default},t.getLanguageDictionary=w,t.getLanguagesDictionaries=function(){return E()},t.getTranslatedPhrase=function(e,t,r){const n=w(e);if(null===n)return null;const s=n[t];if((0,i.isUndefined)(s))return null;const a=function(e,t){let r=e;return(0,o.arrayEach)((0,h.getPhraseFormatters)(),(n=>{r=n(e,t)})),r}(s,r);if(Array.isArray(a))return a[0];return a},t.getValidLanguageCode=function(e){let t=(0,a.normalizeLanguageCode)(e);C(t)||(t=p,(0,a.warnUserAboutLanguageRegistration)(e));return t},t.hasLanguageDictionary=C,t.registerLanguageDictionary=y;var s=r(58460),o=r(98758),i=r(67508),a=r(51127),l=n(r(45212)),h=r(45309),u=n(r(33064)),c=function(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var r=d(t);if(r&&r.has(e))return r.get(e);var n={__proto__:null},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&{}.hasOwnProperty.call(e,o)){var i=s?Object.getOwnPropertyDescriptor(e,o):null;i&&(i.get||i.set)?Object.defineProperty(n,o,i):n[o]=e[o]}return n.default=e,r&&r.set(e,n),n}(r(63751));function d(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,r=new WeakMap;return(d=function(e){return e?r:t})(e)}t.dictionaryKeys=c;const p=t.DEFAULT_LANGUAGE_CODE=u.default.languageCode,{register:g,getItem:f,hasItem:m,getValues:E}=(0,l.default)("languagesDictionaries");function y(e,t){let r=e,n=t;return(0,s.isObject)(e)&&(n=e,r=n.languageCode),function(e,t){e!==p&&(0,a.extendNotExistingKeys)(t,f(p))}(r,n),g(r,(0,s.deepClone)(n)),(0,s.deepClone)(n)}function w(e){return C(e)?(0,s.deepClone)(f(e)):null}function C(e){return m(e)}y(u.default)},51127:(e,t,r)=>{"use strict";t.__esModule=!0,t.createCellHeadersRange=function(e,t){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:e,n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:t,[s,o]=[r,n];e>t&&([s,o]=[o,s]);return`${s}-${o}`},t.extendNotExistingKeys=function(e,t){return(0,s.objectEach)(t,((t,r)=>{(0,n.isUndefined)(e[r])&&(e[r]=t)})),e},t.normalizeLanguageCode=function(e){const t=/^([a-zA-Z]{2})-([a-zA-Z]{2})$/.exec(e);if(t)return`${t[1].toLowerCase()}-${t[2].toUpperCase()}`;return e},t.warnUserAboutLanguageRegistration=function(e){(0,n.isDefined)(e)&&(0,o.error)(i.toSingleLine`Language with code "${e}" was not found. You should register particular language\x20
    before using it. Read more about this issue at: https://docs.handsontable.com/i18n/missing-language-code.`)};var n=r(67508),s=r(58460),o=r(39874),i=r(12556)},8945:(e,t,r)=>{"use strict";var n=r(96784);var s=k(r(25188));s.CellCoords,s.CellRange;var o,i,a,l,h,u=r(21642),c=k(r(63286)),d=r(65686),p=n(r(27952)),g=n(r(95754)),f=k(r(33050)),m=k(r(98758)),E=k(r(1479)),y=k(r(37671)),w=k(r(11459)),C=k(r(36201)),R=k(r(25735)),v=k(r(67508)),S=k(r(27050)),T=k(r(58460)),N=k(r(69114)),_=k(r(35592)),M=k(r(49536)),A=k(r(24456)),b=r(39761),I=r(94539),O=r(19434),x=r(36528),P=r(9415),L=r(55006);function D(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,r=new WeakMap;return(D=function(e){return e?r:t})(e)}function k(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var r=D(t);if(r&&r.has(e))return r.get(e);var n={__proto__:null},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&{}.hasOwnProperty.call(e,o)){var i=s?Object.getOwnPropertyDescriptor(e,o):null;i&&(i.get||i.set)?Object.defineProperty(n,o,i):n[o]=e[o]}return n.default=e,r&&r.set(e,n),n}(0,u.registerAllModules)(),(0,p.default)(s.default),s.default.__GhostTable=g.default,s.default._getListenersCounter=c.getListenersCounter,s.default._getRegisteredMapsCounter=d.getRegisteredMapsCounter,s.default.EventManager=c.default;const H=[m,E,y,w,C,R,v,S,T,N,_,f],F=[M,A];s.default.helper={},s.default.dom={},m.arrayEach(H,(e=>{m.arrayEach(Object.getOwnPropertyNames(e),(t=>{"_"!==t.charAt(0)&&(s.default.helper[t]=e[t])}))})),m.arrayEach(F,(e=>{m.arrayEach(Object.getOwnPropertyNames(e),(t=>{"_"!==t.charAt(0)&&(s.default.dom[t]=e[t])}))})),s.default.cellTypes=null!==(o=s.default.cellTypes)&&void 0!==o?o:{},m.arrayEach((0,x.getRegisteredCellTypeNames)(),(e=>{s.default.cellTypes[e]=(0,x.getCellType)(e)})),s.default.cellTypes.registerCellType=x.registerCellType,s.default.cellTypes.getCellType=x.getCellType,s.default.editors=null!==(i=s.default.editors)&&void 0!==i?i:{},m.arrayEach((0,b.getRegisteredEditorNames)(),(e=>{s.default.editors[`${N.toUpperCaseFirst(e)}Editor`]=(0,b.getEditor)(e)})),s.default.editors.registerEditor=b.registerEditor,s.default.editors.getEditor=b.getEditor,s.default.renderers=null!==(a=s.default.renderers)&&void 0!==a?a:{},m.arrayEach((0,I.getRegisteredRendererNames)(),(e=>{const t=(0,I.getRenderer)(e);"base"===e&&(s.default.renderers.cellDecorator=t),s.default.renderers[`${N.toUpperCaseFirst(e)}Renderer`]=t})),s.default.renderers.registerRenderer=I.registerRenderer,s.default.renderers.getRenderer=I.getRenderer,s.default.validators=null!==(l=s.default.validators)&&void 0!==l?l:{},m.arrayEach((0,O.getRegisteredValidatorNames)(),(e=>{s.default.validators[`${N.toUpperCaseFirst(e)}Validator`]=(0,O.getValidator)(e)})),s.default.validators.registerValidator=O.registerValidator,s.default.validators.getValidator=O.getValidator,s.default.plugins=null!==(h=s.default.plugins)&&void 0!==h?h:{},m.arrayEach((0,P.getPluginsNames)(),(e=>{s.default.plugins[e]=(0,P.getPlugin)(e)})),s.default.plugins[`${N.toUpperCaseFirst(L.BasePlugin.PLUGIN_KEY)}Plugin`]=L.BasePlugin,s.default.plugins.registerPlugin=P.registerPlugin,s.default.plugins.getPlugin=P.getPlugin;t.default=s.default},15129:(e,t,r)=>{"use strict";t.__esModule=!0,r(15724);var n=r(98758),s=r(58460);const o={_hooksStorage:Object.create(null),addHook(e,t){return this._hooksStorage[e]||(this._hooksStorage[e]=[]),this.hot.addHook(e,t),this._hooksStorage[e].push(t),this},removeHooksByKey(e){(0,n.arrayEach)(this._hooksStorage[e]||[],(t=>{this.hot.removeHook(e,t)}))},clearHooks(){(0,s.objectEach)(this._hooksStorage,((e,t)=>this.removeHooksByKey(t))),this._hooksStorage={}}};(0,s.defineGetter)(o,"MIXIN_NAME","hooksRefRegisterer",{writable:!1,enumerable:!1});t.default=o},48499:(e,t,r)=>{"use strict";t.__esModule=!0,r(15724);var n=r(58460),s=r(25735);const o={_localHooks:Object.create(null),addLocalHook(e,t){return this._localHooks[e]||(this._localHooks[e]=[]),this._localHooks[e].push(t),this},runLocalHooks(e,t,r,n,o,i,a){if(this._localHooks[e]){const l=this._localHooks[e].length;for(let h=0;h<l;h++)(0,s.fastCall)(this._localHooks[e][h],this,t,r,n,o,i,a)}},clearLocalHooks(){return this._localHooks={},this}};(0,n.defineGetter)(o,"MIXIN_NAME","localHooks",{writable:!1,enumerable:!1});t.default=o},37056:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724);var s=n(r(85707)),o=r(98758),i=r(58460),a=r(69114),l=r(39874),h=r(12556),u=r(25735);const c=["afterCellMetaReset","afterChange","afterContextMenuDefaultOptions","beforeContextMenuSetItems","afterDropdownMenuDefaultOptions","beforeDropdownMenuSetItems","afterContextMenuHide","beforeContextMenuShow","afterContextMenuShow","afterCopyLimit","beforeCreateCol","afterColumnSequenceChange","afterCreateCol","beforeCreateRow","afterCreateRow","afterDeselect","afterDestroy","afterDocumentKeyDown","afterDrawSelection","beforeRemoveCellClassNames","afterGetCellMeta","afterGetColHeader","afterGetRowHeader","afterInit","afterLoadData","afterUpdateData","afterMomentumScroll","afterOnCellCornerMouseDown","afterOnCellCornerDblClick","afterOnCellMouseDown","afterOnCellMouseUp","afterOnCellContextMenu","afterOnCellMouseOver","afterOnCellMouseOut","afterRemoveCol","afterRemoveRow","beforeRenderer","afterRenderer","afterRowSequenceChange","beforeViewportScrollVertically","beforeViewportScrollHorizontally","beforeViewportScroll","afterScrollHorizontally","afterScrollVertically","afterScroll","afterSelection","afterSelectionByProp","afterSelectionEnd","afterSelectionEndByProp","afterSelectionFocusSet","beforeSelectColumns","afterSelectColumns","beforeSelectRows","afterSelectRows","afterSetCellMeta","afterRemoveCellMeta","afterSetDataAtCell","afterSetDataAtRowProp","afterSetSourceDataAtCell","afterUpdateSettings","afterValidate","beforeLanguageChange","afterLanguageChange","beforeAutofill","afterAutofill","beforeCellAlignment","beforeChange","beforeChangeRender","beforeDrawBorders","beforeGetCellMeta","beforeRemoveCellMeta","beforeInit","beforeInitWalkontable","beforeLoadData","beforeUpdateData","beforeKeyDown","beforeOnCellMouseDown","beforeOnCellMouseUp","beforeOnCellContextMenu","beforeOnCellMouseOver","beforeOnCellMouseOut","beforeRemoveCol","beforeRemoveRow","beforeViewRender","afterViewRender","beforeRender","afterRender","beforeRowWrap","beforeColumnWrap","beforeSetCellMeta","beforeSelectionFocusSet","beforeSetRangeStartOnly","beforeSetRangeStart","beforeSetRangeEnd","beforeSelectionHighlightSet","beforeTouchScroll","beforeValidate","beforeValueRender","construct","init","modifyColHeader","modifyColWidth","modifyFiltersMultiSelectValue","modifyFocusedElement","modifyRowHeader","modifyRowHeight","modifyData","modifySourceData","modifyRowData","modifyGetCellCoords","modifyFocusOnTabNavigation","beforeHighlightingRowHeader","beforeHighlightingColumnHeader","persistentStateLoad","persistentStateReset","persistentStateSave","beforeColumnSort","afterColumnSort","modifyAutofillRange","modifyCopyableRange","beforeCut","afterCut","beforeCopy","afterCopy","beforePaste","afterPaste","beforeColumnFreeze","afterColumnFreeze","beforeColumnMove","afterColumnMove","beforeColumnUnfreeze","afterColumnUnfreeze","beforeRowMove","afterRowMove","beforeColumnResize","afterColumnResize","beforeRowResize","afterRowResize","afterGetColumnHeaderRenderers","afterGetRowHeaderRenderers","beforeStretchingColumnWidth","beforeFilter","afterFilter","afterFormulasValuesUpdate","afterNamedExpressionAdded","afterNamedExpressionRemoved","afterSheetAdded","afterSheetRenamed","afterSheetRemoved","modifyColumnHeaderHeight","modifyColumnHeaderValue","beforeUndo","beforeUndoStackChange","afterUndo","afterUndoStackChange","beforeRedo","beforeRedoStackChange","afterRedo","afterRedoStackChange","modifyRowHeaderWidth","modifyTransformFocus","modifyTransformStart","modifyTransformEnd","afterModifyTransformFocus","afterModifyTransformStart","afterModifyTransformEnd","afterViewportRowCalculatorOverride","afterViewportColumnCalculatorOverride","afterPluginsInitialized","beforeHideRows","afterHideRows","beforeUnhideRows","afterUnhideRows","beforeHideColumns","afterHideColumns","beforeUnhideColumns","afterUnhideColumns","beforeTrimRow","afterTrimRow","beforeUntrimRow","afterUntrimRow","beforeDropdownMenuShow","afterDropdownMenuShow","afterDropdownMenuHide","beforeAddChild","afterAddChild","beforeDetachChild","afterDetachChild","beforeBeginEditing","afterBeginEditing","beforeMergeCells","afterMergeCells","beforeUnmergeCells","afterUnmergeCells","afterListen","afterUnlisten","afterRefreshDimensions","beforeRefreshDimensions","beforeColumnCollapse","afterColumnCollapse","beforeColumnExpand","afterColumnExpand","modifyAutoColumnSizeSeed"],d=h.toSingleLine`The plugin hook "[hookName]" was removed in Handsontable [removedInVersion].\x20
  Please consult release notes https://github.com/handsontable/handsontable/releases/tag/[removedInVersion] to\x20
  learn about the migration path.`,p=new Map([["modifyRow","8.0.0"],["modifyCol","8.0.0"],["unmodifyRow","8.0.0"],["unmodifyCol","8.0.0"],["skipLengthCache","8.0.0"],["hiddenColumn","8.0.0"],["hiddenRow","8.0.0"]]),g=new Map([[]]);class f{static getSingleton(){return m}constructor(){(0,s.default)(this,"globalBucket",void 0),this.globalBucket=this.createEmptyBucket()}createEmptyBucket(){const e=Object.create(null);return(0,o.arrayEach)(c,(t=>e[t]=[])),e}getBucket(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;return e?(e.pluginHookBucket||(e.pluginHookBucket=this.createEmptyBucket()),e.pluginHookBucket):this.globalBucket}add(e,t){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;if(Array.isArray(t))(0,o.arrayEach)(t,(t=>this.add(e,t,r)));else{p.has(e)&&(0,l.warn)((0,a.substitute)(d,{hookName:e,removedInVersion:p.get(e)})),g.has(e)&&(0,l.warn)(g.get(e));const n=this.getBucket(r);if(void 0===n[e]&&(this.register(e),n[e]=[]),t.skip=!1,-1===n[e].indexOf(t)){let r=!1;t.initialHook&&(0,o.arrayEach)(n[e],((s,o)=>{if(s.initialHook)return n[e][o]=t,r=!0,!1})),r||n[e].push(t)}}return this}once(e,t){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;Array.isArray(t)?(0,o.arrayEach)(t,(t=>this.once(e,t,r))):(t.runOnce=!0,this.add(e,t,r))}remove(e,t){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;const n=this.getBucket(r);return void 0!==n[e]&&n[e].indexOf(t)>=0&&(t.skip=!0,!0)}has(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;const r=this.getBucket(t);return!(void 0===r[e]||!r[e].length)}run(e,t,r,n,s,o,i,a){{const l=this.globalBucket[t],h=l?l.length:0;let c=0;if(h)for(;c<h;){if(!l[c]||l[c].skip){c+=1;continue}const h=(0,u.fastCall)(l[c],e,r,n,s,o,i,a);void 0!==h&&(r=h),l[c]&&l[c].runOnce&&this.remove(t,l[c]),c+=1}}{const l=this.getBucket(e)[t],h=l?l.length:0;let c=0;if(h)for(;c<h;){if(!l[c]||l[c].skip){c+=1;continue}const h=(0,u.fastCall)(l[c],e,r,n,s,o,i,a);void 0!==h&&(r=h),l[c]&&l[c].runOnce&&this.remove(t,l[c],e),c+=1}}return r}destroy(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;(0,i.objectEach)(this.getBucket(e),((e,t,r)=>r[t].length=0))}register(e){this.isRegistered(e)||c.push(e)}deregister(e){this.isRegistered(e)&&c.splice(c.indexOf(e),1)}isDeprecated(e){return g.has(e)||p.has(e)}isRegistered(e){return c.indexOf(e)>=0}getRegistered(){return c}}const m=new f;t.default=f},859:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724);var s=n(r(85707)),o=r(55006),i=r(98758),a=r(36201),l=n(r(95754)),h=n(r(37056)),u=r(58460),c=r(27050),d=n(r(3791)),p=r(69114),g=r(6697),f=r(65686),m=r(67508);function E(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function y(e,t){return e.get(w(e,t))}function w(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}h.default.getSingleton().register("modifyAutoColumnSizeSeed");const C=t.PLUGIN_KEY="autoColumnSize",R=t.PLUGIN_PRIORITY=10;var v=new WeakMap,S=new WeakSet;class T extends o.BasePlugin{static get PLUGIN_KEY(){return C}static get PLUGIN_PRIORITY(){return R}static get SETTING_KEYS(){return!0}static get CALCULATION_STEP(){return 50}static get SYNC_CALCULATION_LIMIT(){return 50}constructor(e){var t,r;super(e),E(t=this,r=S),r.add(t),(0,s.default)(this,"ghostTable",new l.default(this.hot)),(0,s.default)(this,"samplesGenerator",new d.default(((e,t)=>{const r=this.hot.toPhysicalRow(e),n=this.hot.toPhysicalColumn(t);if(this.hot.rowIndexMapper.isHidden(r)||this.hot.columnIndexMapper.isHidden(n))return!1;const s=this.hot.getCellMeta(e,t);let o="";s.spanned||(o=this.hot.getDataAtCell(e,t));let i="";return this.hot.hasHook("modifyAutoColumnSizeSeed")&&(i=this.hot.runHooks("modifyAutoColumnSizeSeed",i,s,o)),{value:o,bundleSeed:i}}))),(0,s.default)(this,"firstCalculation",!0),(0,s.default)(this,"inProgress",!1),(0,s.default)(this,"measuredColumns",0),(0,s.default)(this,"columnWidthsMap",new f.PhysicalIndexToValueMap),function(e,t,r){E(e,t),t.set(e,r)}(this,v,[]),this.hot.columnIndexMapper.registerMap("autoColumnSize",this.columnWidthsMap),this.addHook("beforeColumnResize",((e,t,r)=>w(S,this,A).call(this,e,t,r)))}isEnabled(){return!1!==this.hot.getSettings()[C]&&!this.hot.getSettings().colWidths}enablePlugin(){var e=this;if(this.enabled)return;const t=this.hot.getSettings()[C];t&&null!==t.useHeaders&&void 0!==t.useHeaders&&this.ghostTable.setSetting("useHeaders",t.useHeaders),this.setSamplingOptions(),this.addHook("afterLoadData",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return w(S,e,_).call(e,...r)})),this.addHook("beforeChangeRender",(e=>w(S,this,M).call(this,e))),this.addHook("afterFormulasValuesUpdate",(e=>w(S,this,I).call(this,e))),this.addHook("beforeViewRender",(e=>w(S,this,N).call(this,e))),this.addHook("modifyColWidth",((e,t)=>this.getColumnWidth(t,e))),this.addHook("afterInit",(()=>w(S,this,b).call(this))),super.enablePlugin()}updatePlugin(){const e=this.findColumnsWhereHeaderWasChanged();e.length&&(this.clearCache(e),this.calculateVisibleColumnsWidth()),super.updatePlugin()}disablePlugin(){super.disablePlugin(),this.addHook("beforeColumnResize",((e,t,r)=>w(S,this,A).call(this,e,t,r)))}calculateVisibleColumnsWidth(){if(!this.hot.countRows())return;const e=this.hot.renderCall,t=this.getFirstVisibleColumn(),r=this.getLastVisibleColumn();-1!==t&&-1!==r&&this.calculateColumnsWidth({from:t,to:r},void 0,e)}calculateColumnsWidth(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{from:0,to:this.hot.countCols()-1},t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{from:0,to:this.hot.countRows()-1},r=arguments.length>2&&void 0!==arguments[2]&&arguments[2];const n="number"==typeof e?{from:e,to:e}:e,s="number"==typeof t?{from:t,to:t}:t;(0,c.rangeEach)(n.from,n.to,(e=>{let t=this.hot.toPhysicalColumn(e);if(null===t&&(t=e),r||null===this.columnWidthsMap.getValueAtIndex(t)&&!this.hot._getColWidthFromSettings(t)){const t=this.samplesGenerator.generateColumnSamples(e,s);(0,i.arrayEach)(t,(e=>{let[t,r]=e;return this.ghostTable.addColumn(t,r)}))}})),this.ghostTable.columns.length&&(this.hot.batchExecution((()=>{this.ghostTable.getWidths(((e,t)=>{const r=this.hot.toPhysicalColumn(e);this.columnWidthsMap.setValueAtIndex(r,t)}))}),!0),this.measuredColumns=n.to+1,this.ghostTable.clean())}calculateAllColumnsWidth(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{from:0,to:this.hot.countRows()-1},t=0;const r=this.hot.countCols()-1;let n=null;this.inProgress=!0;const s=()=>{if(!this.hot)return(0,a.cancelAnimationFrame)(n),void(this.inProgress=!1);this.calculateColumnsWidth({from:t,to:Math.min(t+T.CALCULATION_STEP,r)},e),t=t+T.CALCULATION_STEP+1,t<r?n=(0,a.requestAnimationFrame)(s):((0,a.cancelAnimationFrame)(n),this.inProgress=!1,this.hot.view.adjustElementsSize())},o=this.getSyncCalculationLimit();this.firstCalculation&&o>=0&&(this.calculateColumnsWidth({from:0,to:o},e),this.firstCalculation=!1,t=o+1),t<r?s():this.inProgress=!1}setSamplingOptions(){const e=this.hot.getSettings()[C],t=e&&(0,u.hasOwnProperty)(e,"samplingRatio")?e.samplingRatio:void 0,r=e&&(0,u.hasOwnProperty)(e,"allowSampleDuplicates")?e.allowSampleDuplicates:void 0;t&&!isNaN(t)&&this.samplesGenerator.setSampleCount(parseInt(t,10)),r&&this.samplesGenerator.setAllowDuplicates(r)}recalculateAllColumnsWidth(){this.hot.view&&this.hot.view._wt.wtTable.isVisible()&&(this.clearCache(),this.calculateAllColumnsWidth())}getSyncCalculationLimit(){const e=this.hot.getSettings()[C];let t=T.SYNC_CALCULATION_LIMIT;const r=this.hot.countCols()-1;return(0,u.isObject)(e)&&(t=e.syncLimit,(0,p.isPercentValue)(t)?t=(0,c.valueAccordingPercent)(r,t):t>>=0),Math.min(t,r)}getColumnWidth(e){let t=!(arguments.length>2&&void 0!==arguments[2])||arguments[2],r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:void 0;return void 0===r&&(r=this.columnWidthsMap.getValueAtIndex(this.hot.toPhysicalColumn(e)),t&&"number"==typeof r&&(r=Math.max(r,g.ViewportColumnsCalculator.DEFAULT_WIDTH))),r}getFirstVisibleColumn(){const e=this.hot.view._wt;if(e.wtViewport.columnsVisibleCalculator){const t=e.wtTable.getFirstVisibleColumn();if(-1!==t)return this.hot.columnIndexMapper.getVisualFromRenderableIndex(t)}if(e.wtViewport.columnsRenderCalculator){const t=e.wtTable.getFirstRenderedColumn();if(-1!==t)return this.hot.columnIndexMapper.getVisualFromRenderableIndex(t)}return-1}getLastVisibleColumn(){const e=this.hot.view._wt;if(e.wtViewport.columnsVisibleCalculator){const t=e.wtTable.getLastVisibleColumn();if(-1!==t)return this.hot.columnIndexMapper.getVisualFromRenderableIndex(t)}if(e.wtViewport.columnsRenderCalculator){const t=e.wtTable.getLastRenderedColumn();if(-1!==t)return this.hot.columnIndexMapper.getVisualFromRenderableIndex(t)}return-1}findColumnsWhereHeaderWasChanged(){const e=this.hot.getColHeader();return(0,i.arrayReduce)(e,((e,t,r)=>{const n=y(v,this).length;return(n-1<r||y(v,this)[r]!==t)&&e.push(r),n-1<r?y(v,this).push(t):y(v,this)[r]=t,e}),[])}clearCache(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[];e.length?this.hot.batchExecution((()=>{(0,i.arrayEach)(e,(e=>{this.columnWidthsMap.setValueAtIndex(e,null)}))}),!0):this.columnWidthsMap.clear()}isNeedRecalculate(){return!!(0,i.arrayFilter)(this.columnWidthsMap.getValues().slice(0,this.measuredColumns),(e=>null===e)).length}destroy(){this.ghostTable.clean(),super.destroy()}}function N(){this.calculateVisibleColumnsWidth(),this.isNeedRecalculate()&&!this.inProgress&&this.calculateAllColumnsWidth()}function _(){this.hot.view?this.recalculateAllColumnsWidth():setTimeout((()=>{this.hot&&this.recalculateAllColumnsWidth()}),0)}function M(e){const t=(0,i.arrayMap)(e,(e=>{let[,t]=e;return this.hot.toPhysicalColumn(this.hot.propToCol(t))}));this.clearCache(Array.from(new Set(t)))}function A(e,t,r){let n=e;return r&&(this.calculateColumnsWidth(t,void 0,!0),n=this.getColumnWidth(t,void 0,!1)),n}function b(){var e,t,r;e=v,t=this,r=this.hot.getColHeader(),e.set(w(e,t),r)}function I(e){const t=(0,i.arrayFilter)(e,(e=>{var t;return(0,m.isDefined)(null===(t=e.address)||void 0===t?void 0:t.col)})),r=(0,i.arrayMap)(t,(e=>e.address.col));this.clearCache(Array.from(new Set(r)))}t.AutoColumnSize=T},61555:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(859);t.PLUGIN_KEY=n.PLUGIN_KEY,t.PLUGIN_PRIORITY=n.PLUGIN_PRIORITY,t.AutoColumnSize=n.AutoColumnSize},4909:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),o=r(55006),i=r(98758),a=r(36201),l=r(49536),h=n(r(95754)),u=r(58460),c=r(27050),d=n(r(3791)),p=r(69114),g=r(65686);function f(e,t){!function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}(e,t),t.add(e)}function m(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}const E=t.PLUGIN_KEY="autoRowSize",y=t.PLUGIN_PRIORITY=40;var w=new WeakSet;class C extends o.BasePlugin{static get PLUGIN_KEY(){return E}static get PLUGIN_PRIORITY(){return y}static get SETTING_KEYS(){return!0}static get CALCULATION_STEP(){return 50}static get SYNC_CALCULATION_LIMIT(){return 500}constructor(e){super(e),f(this,w),(0,s.default)(this,"headerHeight",null),(0,s.default)(this,"ghostTable",new h.default(this.hot)),(0,s.default)(this,"samplesGenerator",new d.default(((e,t)=>{const r=this.hot.toPhysicalRow(e),n=this.hot.toPhysicalColumn(t);if(this.hot.rowIndexMapper.isHidden(r)||this.hot.columnIndexMapper.isHidden(n))return!1;if(e>=0&&t>=0){if(this.hot.getCellMeta(e,t).hidden)return!1}let s;return e>=0?s=this.hot.getDataAtCell(e,t):-1===e&&(s=this.hot.getColHeader(t)),{value:s}}))),(0,s.default)(this,"firstCalculation",!0),(0,s.default)(this,"inProgress",!1),(0,s.default)(this,"measuredRows",0),(0,s.default)(this,"rowHeightsMap",new g.PhysicalIndexToValueMap),this.hot.rowIndexMapper.registerMap("autoRowSize",this.rowHeightsMap),this.addHook("beforeRowResize",((e,t,r)=>m(w,this,v).call(this,e,t,r)))}isEnabled(){const e=this.hot.getSettings()[E];return!0===e||(0,u.isObject)(e)}enablePlugin(){var e=this;this.enabled||(this.setSamplingOptions(),this.addHook("afterLoadData",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return m(w,e,S).call(e,...r)})),this.addHook("beforeChangeRender",(e=>m(w,this,T).call(this,e))),this.addHook("beforeColumnResize",(()=>this.recalculateAllRowsHeight())),this.addHook("beforeViewRender",(e=>m(w,this,R).call(this,e))),this.addHook("modifyRowHeight",((e,t)=>this.getRowHeight(t,e))),this.addHook("modifyColumnHeaderHeight",(()=>this.getColumnHeaderHeight())),super.enablePlugin())}disablePlugin(){this.headerHeight=null,super.disablePlugin(),this.addHook("beforeRowResize",((e,t,r)=>m(w,this,v).call(this,e,t,r)))}calculateRowsHeight(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{from:0,to:this.hot.countRows()-1},t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{from:0,to:this.hot.countCols()-1},r=arguments.length>2&&void 0!==arguments[2]&&arguments[2];const n="number"==typeof e?{from:e,to:e}:e,s="number"==typeof t?{from:t,to:t}:t;if(null!==this.hot.getColHeader(0)){const e=this.samplesGenerator.generateRowSamples(-1,s);this.ghostTable.addColumnHeadersRow(e.get(-1))}(0,c.rangeEach)(n.from,n.to,(e=>{if(r||null===this.rowHeightsMap.getValueAtIndex(e)){const t=this.samplesGenerator.generateRowSamples(e,s);(0,i.arrayEach)(t,(e=>{let[t,r]=e;return this.ghostTable.addRow(t,r)}))}})),this.ghostTable.rows.length&&(this.hot.batchExecution((()=>{this.ghostTable.getHeights(((e,t)=>{e<0?this.headerHeight=t:this.rowHeightsMap.setValueAtIndex(this.hot.toPhysicalRow(e),t)}))}),!0),this.measuredRows=n.to+1,this.ghostTable.clean())}calculateAllRowsHeight(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{from:0,to:this.hot.countCols()-1},t=0;const r=this.hot.countRows()-1;let n=null;this.inProgress=!0;const s=()=>{if(!this.hot)return(0,a.cancelAnimationFrame)(n),void(this.inProgress=!1);this.calculateRowsHeight({from:t,to:Math.min(t+C.CALCULATION_STEP,r)},e),t=t+C.CALCULATION_STEP+1,t<r?n=(0,a.requestAnimationFrame)(s):((0,a.cancelAnimationFrame)(n),this.inProgress=!1,this.hot.view.adjustElementsSize(!0),this.hot.view._wt.wtOverlays.inlineStartOverlay.needFullRender&&this.hot.view._wt.wtOverlays.inlineStartOverlay.clone.draw())},o=this.getSyncCalculationLimit();this.firstCalculation&&o>=0&&(this.calculateRowsHeight({from:0,to:o},e),this.firstCalculation=!1,t=o+1),t<r?s():(this.inProgress=!1,this.hot.view.adjustElementsSize(!1))}setSamplingOptions(){const e=this.hot.getSettings()[E],t=e&&(0,u.hasOwnProperty)(e,"samplingRatio")?e.samplingRatio:void 0,r=e&&(0,u.hasOwnProperty)(e,"allowSampleDuplicates")?e.allowSampleDuplicates:void 0;t&&!isNaN(t)&&this.samplesGenerator.setSampleCount(parseInt(t,10)),r&&this.samplesGenerator.setAllowDuplicates(r)}recalculateAllRowsHeight(){(0,l.isVisible)(this.hot.view._wt.wtTable.TABLE)&&(this.clearCache(),this.calculateAllRowsHeight())}getSyncCalculationLimit(){const e=this.hot.getSettings()[E];let t=C.SYNC_CALCULATION_LIMIT;const r=this.hot.countRows()-1;return(0,u.isObject)(e)&&(t=e.syncLimit,(0,p.isPercentValue)(t)?t=(0,c.valueAccordingPercent)(r,t):t>>=0),Math.min(t,r)}getRowHeight(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:void 0;const r=e<0?this.headerHeight:this.rowHeightsMap.getValueAtIndex(this.hot.toPhysicalRow(e));let n=t;return null!==r&&r>(t||0)&&(n=r),n}getColumnHeaderHeight(){return this.headerHeight}getFirstVisibleRow(){const e=this.hot.view._wt;return e.wtViewport.rowsVisibleCalculator?e.wtTable.getFirstVisibleRow():e.wtViewport.rowsRenderCalculator?e.wtTable.getFirstRenderedRow():-1}getLastVisibleRow(){const e=this.hot.view._wt;return e.wtViewport.rowsVisibleCalculator?e.wtTable.getLastVisibleRow():e.wtViewport.rowsRenderCalculator?e.wtTable.getLastRenderedRow():-1}clearCache(){this.headerHeight=null,this.rowHeightsMap.init()}clearCacheByRange(e){const{from:t,to:r}="number"==typeof e?{from:e,to:e}:e;this.hot.batchExecution((()=>{(0,c.rangeEach)(Math.min(t,r),Math.max(t,r),(e=>{this.rowHeightsMap.setValueAtIndex(e,null)}))}),!0)}isNeedRecalculate(){return!!(0,i.arrayFilter)(this.rowHeightsMap.getValues().slice(0,this.measuredRows),(e=>null===e)).length}destroy(){this.ghostTable.clean(),super.destroy()}}function R(){const e=this.hot.renderCall,t=this.hot.getSettings().fixedRowsBottom,r=this.getFirstVisibleRow(),n=this.getLastVisibleRow();if(-1!==r&&-1!==n){if(this.calculateRowsHeight({from:r,to:n},void 0,e),t){const e=this.hot.countRows()-1;this.calculateRowsHeight({from:e-t,to:e})}this.isNeedRecalculate()&&!this.inProgress&&this.calculateAllRowsHeight()}}function v(e,t,r){let n=e;return r&&(this.calculateRowsHeight(t,void 0,!0),n=this.getRowHeight(t)),n}function S(){this.hot.view?this.recalculateAllRowsHeight():this.hot._registerTimeout((()=>{this.hot&&this.recalculateAllRowsHeight()}))}function T(e){let t=null;1===e.length?t=e[0][0]:e.length>1&&(t={from:e[0][0],to:e[e.length-1][0]}),null!==t&&this.clearCacheByRange(t)}t.AutoRowSize=C},54225:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(4909);t.PLUGIN_KEY=n.PLUGIN_KEY,t.PLUGIN_PRIORITY=n.PLUGIN_PRIORITY,t.AutoRowSize=n.AutoRowSize},15611:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724);var s=n(r(85707)),o=r(55006),i=n(r(37056)),a=r(49536),l=r(98758),h=r(67508),u=r(54744);function c(e,t){!function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}(e,t),t.add(e)}function d(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}i.default.getSingleton().register("modifyAutofillRange"),i.default.getSingleton().register("beforeAutofill"),i.default.getSingleton().register("afterAutofill");const p=t.PLUGIN_KEY="autofill",g=t.PLUGIN_PRIORITY=20,f=["fillHandle"];var m=new WeakSet;class E extends o.BasePlugin{constructor(){super(...arguments),c(this,m),(0,s.default)(this,"addingStarted",!1),(0,s.default)(this,"mouseDownOnCellCorner",!1),(0,s.default)(this,"mouseDragOutside",!1),(0,s.default)(this,"handleDraggedCells",0),(0,s.default)(this,"directions",[]),(0,s.default)(this,"autoInsertRow",!1)}static get PLUGIN_KEY(){return p}static get PLUGIN_PRIORITY(){return g}static get SETTING_KEYS(){return[p,...f]}isEnabled(){return this.hot.getSettings().fillHandle}enablePlugin(){this.enabled||(this.mapSettings(),this.registerEvents(),this.addHook("afterOnCellCornerMouseDown",(e=>d(m,this,w).call(this,e))),this.addHook("afterOnCellCornerDblClick",(e=>d(m,this,y).call(this,e))),this.addHook("beforeOnCellMouseOver",((e,t)=>d(m,this,C).call(this,t))),super.enablePlugin())}updatePlugin(){this.disablePlugin(),this.enablePlugin(),super.updatePlugin()}disablePlugin(){this.clearMappedSettings(),super.disablePlugin()}getSelectionData(){const e=this.hot.getSelectedRangeLast(),{row:t,col:r}=e.getTopStartCorner(),{row:n,col:s}=e.getBottomEndCorner(),o=this.hot.runHooks("modifyCopyableRange",[{startRow:t,startCol:r,endRow:n,endCol:s}]),i=[],a=[],h=[];return(0,l.arrayEach)(o,(e=>{for(let t=e.startRow;t<=e.endRow;t+=1)-1===i.indexOf(t)&&i.push(t);for(let t=e.startCol;t<=e.endCol;t+=1)-1===a.indexOf(t)&&a.push(t)})),(0,l.arrayEach)(i,(e=>{const t=[];(0,l.arrayEach)(a,(r=>{t.push(this.hot.getCopyableData(e,r))})),h.push(t)})),h}fillIn(){if(this.hot.selection.highlight.getFill().isEmpty())return!1;const[e,t,r,n]=this.hot.selection.highlight.getFill().getVisualCorners(),s=this.hot.getSelectedRangeLast(),o=s.getTopStartCorner(),i=s.getBottomEndCorner();this.resetSelectionOfDraggedArea();const a=[o.row,o.col,i.row,i.col],l=this.hot.runHooks("modifyAutofillRange",[Math.min(o.row,e),Math.min(o.col,t),Math.max(i.row,r),Math.max(i.col,n)],a),{directionOfDrag:h,startOfDragCoords:c,endOfDragCoords:d}=(0,u.getDragDirectionAndRange)(a,l,((e,t)=>this.hot._createCellCoords(e,t)));if(c&&c.row>-1&&c.col>-1){const e=this.getSelectionData(),t=s.clone(),r=this.hot._createCellRange(c,c,d),n=this.hot.runHooks("beforeAutofill",e,t,r,h);if(!1===n)return this.hot.selection.highlight.getFill().clear(),this.hot.render(),!1;let o=n;const i=n;if(["up","left"].indexOf(h)>-1&&(1!==i.length||0!==i[0].length))if(o=[],"up"===h){const e=d.row-c.row+1,t=e%i.length;for(let r=0;r<e;r++)o.push(i[(r+(i.length-t))%i.length])}else{const e=d.col-c.col+1,t=e%i[0].length;for(let r=0;r<i.length;r++){o.push([]);for(let n=0;n<e;n++)o[r].push(i[r][(n+(i[r].length-t))%i[r].length])}}this.hot.populateFromArray(c.row,c.col,o,d.row,d.col,`${this.pluginName}.fill`,null),this.setSelection(l),this.hot.runHooks("afterAutofill",o,t,r,h),this.hot.render()}else this.hot._refreshBorders();return!0}reduceSelectionAreaIfNeeded(e){return e.row<0&&(e.row=0),e.col<0&&(e.col=0),e}getCoordsOfDragAndDropBorders(e){const t=this.hot.getSelectedRangeLast(),r=t.getBottomEndCorner();let n=e;if(this.directions.includes(u.DIRECTIONS.vertical)&&this.directions.includes(u.DIRECTIONS.horizontal)){const s=t.getTopStartCorner();(r.col<=e.col||s.col>=e.col)&&(n=this.hot._createCellCoords(r.row,e.col)),(r.row<e.row||s.row>e.row)&&(n=this.hot._createCellCoords(e.row,r.col))}else if(this.directions.includes(u.DIRECTIONS.vertical))n=this.hot._createCellCoords(e.row,r.col);else{if(!this.directions.includes(u.DIRECTIONS.horizontal))return;n=this.hot._createCellCoords(r.row,e.col)}return this.reduceSelectionAreaIfNeeded(n)}showBorder(e){const t=this.getCoordsOfDragAndDropBorders(e);t&&this.redrawBorders(t)}addRow(){this.hot._registerTimeout((()=>{this.hot.alter("insert_row_below",void 0,1,`${this.pluginName}.fill`),this.addingStarted=!1}),200)}addNewRowIfNeeded(){if(!this.hot.selection.highlight.getFill().isEmpty()&&!1===this.addingStarted&&this.autoInsertRow){const e=this.hot.getSelectedLast(),t=this.hot.selection.highlight.getFill().getVisualCorners(),r=this.hot.countRows();e[2]<r-1&&t[2]===r-1&&(this.addingStarted=!0,this.addRow())}}getIndexOfLastAdjacentFilledInRow(e){const t=this.hot.getData(),r=this.hot.countRows();let n;for(let s=e[2]+1;s<r;s++){for(let r=e[1];r<=e[3];r++){const e=t[s][r];if(!(0,h.isEmpty)(e))return-1}const r=t[s][e[1]-1],o=t[s][e[3]+1];(0,h.isEmpty)(r)&&(0,h.isEmpty)(o)||(n=s)}return n}addSelectionFromStartAreaToSpecificRowIndex(e,t){this.hot.selection.highlight.getFill().clear().add(this.hot._createCellCoords(e[0],e[1])).add(this.hot._createCellCoords(t,e[3])).commit()}setSelection(e){this.hot.selectCell(...(0,l.arrayMap)(e,(e=>Math.max(e,0))),!1,!1)}selectAdjacent(){const e=this.hot.getSelectedLast(),t=this.getIndexOfLastAdjacentFilledInRow(e);return-1!==t&&void 0!==t&&(this.addSelectionFromStartAreaToSpecificRowIndex(e,t),!0)}resetSelectionOfDraggedArea(){this.handleDraggedCells=0,this.hot.selection.highlight.getFill().clear()}redrawBorders(e){this.hot.selection.highlight.getFill().clear().add(this.hot.getSelectedRangeLast().from).add(this.hot.getSelectedRangeLast().to).add(e).commit(),this.hot.view.render()}getIfMouseWasDraggedOutside(e){const{documentElement:t}=this.hot.rootDocument,r=(0,a.offset)(this.hot.table).top-(this.hot.rootWindow.pageYOffset||t.scrollTop)+(0,a.outerHeight)(this.hot.table),n=(0,a.offset)(this.hot.table).left-(this.hot.rootWindow.pageXOffset||t.scrollLeft)+(0,a.outerWidth)(this.hot.table);return e.clientY>r&&e.clientX<=n}registerEvents(){const{documentElement:e}=this.hot.rootDocument;this.eventManager.addEventListener(e,"mouseup",(()=>d(m,this,R).call(this))),this.eventManager.addEventListener(e,"mousemove",(e=>d(m,this,v).call(this,e)))}clearMappedSettings(){this.directions.length=0,this.autoInsertRow=!1}mapSettings(){const e=(0,u.getMappedFillHandleSetting)(this.hot.getSettings().fillHandle);this.directions=e.directions,this.autoInsertRow=e.autoInsertRow}destroy(){super.destroy()}}function y(){this.selectAdjacent()&&this.fillIn()}function w(){this.handleDraggedCells=1,this.mouseDownOnCellCorner=!0}function C(e){this.mouseDownOnCellCorner&&!this.hot.view.isMouseDown()&&this.handleDraggedCells&&(this.handleDraggedCells+=1,this.showBorder(e),this.addNewRowIfNeeded())}function R(){this.handleDraggedCells&&(this.handleDraggedCells>1&&this.fillIn(),this.handleDraggedCells=0,this.mouseDownOnCellCorner=!1)}function v(e){const t=this.getIfMouseWasDraggedOutside(e);!1===this.addingStarted&&this.handleDraggedCells>0&&t?(this.mouseDragOutside=!0,this.addingStarted=!0):this.mouseDragOutside=!1,this.mouseDragOutside&&this.autoInsertRow&&this.addRow()}t.Autofill=E},34061:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(15611);t.PLUGIN_KEY=n.PLUGIN_KEY,t.PLUGIN_PRIORITY=n.PLUGIN_PRIORITY,t.Autofill=n.Autofill},54744:(e,t,r)=>{"use strict";t.__esModule=!0,t.getDragDirectionAndRange=function(e,t,r){let n,s,o;t[0]===e[0]&&t[1]<e[1]?(o="left",n=r(t[0],t[1]),s=r(t[2],e[1]-1)):t[2]===e[2]&&t[0]===e[0]&&t[3]>e[3]?(o="right",n=r(t[0],e[3]+1),s=r(t[2],t[3])):t[0]<e[0]&&t[1]===e[1]?(o="up",n=r(t[0],t[1]),s=r(e[0]-1,t[3])):t[2]>e[2]&&t[1]===e[1]&&(o="down",n=r(e[2]+1,t[1]),s=r(t[2],t[3]));n&&n.normalize();s&&s.normalize();return{directionOfDrag:o,startOfDragCoords:n,endOfDragCoords:s}},t.getMappedFillHandleSetting=function(e){const t={};!0===e?(t.directions=Object.keys(o),t.autoInsertRow=!0):(0,n.isObject)(e)?((0,s.isDefined)(e.autoInsertRow)?e.direction===o.horizontal?t.autoInsertRow=!1:t.autoInsertRow=e.autoInsertRow:t.autoInsertRow=!1,(0,s.isDefined)(e.direction)?t.directions=[e.direction]:t.directions=Object.keys(o)):"string"==typeof e?(t.directions=[e],t.autoInsertRow=!0):(t.directions=[],t.autoInsertRow=!1);return t};var n=r(58460),s=r(67508);const o=t.DIRECTIONS={horizontal:"horizontal",vertical:"vertical"}},44965:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724);var s=n(r(85707)),o=r(58460),i=r(98758),a=r(9415),l=r(36528),h=r(39761),u=r(94539),c=r(19434),d=n(r(63286));function p(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function g(e,t){return e.get(f(e,t))}function f(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}const m=new Map([["plugin",a.hasPlugin],["cell-type",l.hasCellType],["editor",h.hasEditor],["renderer",u.hasRenderer],["validator",c.hasValidator]]),E=t.PLUGIN_KEY="base",y=[];let w=null;var C=new WeakMap,R=new WeakSet;function v(e){if(!e)return!1;const t=this.constructor.SETTING_KEYS;if("boolean"==typeof t)return t;for(let r=0;r<t.length;r++)if(void 0!==e[t[r]])return!0;return!1}t.BasePlugin=class{static get PLUGIN_KEY(){return E}static get SETTING_KEYS(){return[this.PLUGIN_KEY]}constructor(e){var t,r;p(t=this,r=R),r.add(t),(0,s.default)(this,"eventManager",new d.default(this)),(0,s.default)(this,"pluginName",null),(0,s.default)(this,"pluginsInitializedCallbacks",[]),(0,s.default)(this,"isPluginsReady",!1),(0,s.default)(this,"enabled",!1),(0,s.default)(this,"initialized",!1),function(e,t,r){p(e,t),t.set(e,r)}(this,C,{}),(0,o.defineGetter)(this,"hot",e,{writable:!1}),w=null,this.hot.addHook("afterPluginsInitialized",(()=>this.onAfterPluginsInitialized())),this.hot.addHook("afterUpdateSettings",(e=>this.onUpdateSettings(e))),this.hot.addHook("beforeInit",(()=>this.init()))}init(){this.pluginName=this.hot.getPluginName(this);const e=this.constructor.PLUGIN_DEPS,t=Array.isArray(e)?e:[];if(t.length>0){const e=[];if(t.forEach((t=>{const[r,n]=t.split(":");if(!m.has(r))throw new Error(`Unknown plugin dependency type "${r}" was found.`);m.get(r)(n)||e.push(` - ${n} (${r})`)})),e.length>0){const t=[`The ${this.pluginName} plugin requires the following modules:\n`,`${e.join("\n")}\n`].join("");y.push(t)}}w||(w=(0,a.getPluginsNames)()),w.indexOf("UndoRedo")>=0&&w.splice(w.indexOf("UndoRedo"),1),w.indexOf(this.pluginName)>=0&&w.splice(w.indexOf(this.pluginName),1),this.hot.addHookOnce("afterPluginsInitialized",(()=>{this.isEnabled&&this.isEnabled()&&this.enablePlugin()}));if(0===w.length){if(y.length>0){const e=[`${y.join("\n")}\n`,"You have to import and register them manually."].join("");throw new Error(e)}this.hot.runHooks("afterPluginsInitialized")}this.initialized=!0}enablePlugin(){this.enabled=!0}disablePlugin(){var e;null===(e=this.eventManager)||void 0===e||e.clear(),this.clearHooks(),this.enabled=!1}addHook(e,t){g(C,this)[e]=g(C,this)[e]||[];const r=g(C,this)[e];this.hot.addHook(e,t),r.push(t),g(C,this)[e]=r}removeHooks(e){(0,i.arrayEach)(g(C,this)[e]||[],(t=>{this.hot.removeHook(e,t)}))}clearHooks(){const e=g(C,this);(0,o.objectEach)(e,((e,t)=>this.removeHooks(t))),e.length=0}callOnPluginsReady(e){this.isPluginsReady?e():this.pluginsInitializedCallbacks.push(e)}onAfterPluginsInitialized(){(0,i.arrayEach)(this.pluginsInitializedCallbacks,(e=>e())),this.pluginsInitializedCallbacks.length=0,this.isPluginsReady=!0}onUpdateSettings(e){const t=f(R,this,v).call(this,e);this.isEnabled&&(this.enabled&&!this.isEnabled()&&this.disablePlugin(),!this.enabled&&this.isEnabled()&&this.enablePlugin(),this.enabled&&this.isEnabled()&&t&&this.updatePlugin(e))}updatePlugin(){}destroy(){var e;null===(e=this.eventManager)||void 0===e||e.destroy(),this.clearHooks(),(0,o.objectEach)(this,((e,t)=>{"hot"!==t&&(this[t]=null)})),delete this.t,delete this.hot}}},55006:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(44965);t.PLUGIN_KEY=n.PLUGIN_KEY,t.BasePlugin=n.BasePlugin},34229:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),o=r(55006),i=n(r(86305)),a=n(r(52242));function l(e,t){!function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}(e,t),t.add(e)}const h=t.PLUGIN_KEY="bindRowsWithHeaders",u=t.PLUGIN_PRIORITY=210,c=new Map([["loose",i.default],["strict",a.default]]);var d=new WeakSet;class p extends o.BasePlugin{constructor(){super(...arguments),l(this,d),(0,s.default)(this,"headerIndexes",null)}static get PLUGIN_KEY(){return h}static get PLUGIN_PRIORITY(){return u}isEnabled(){return!!this.hot.getSettings()[h]}enablePlugin(){if(this.enabled)return;let e=this.hot.getSettings()[h];"string"!=typeof e&&(e="loose");const t=c.get(e);this.headerIndexes=this.hot.rowIndexMapper.registerMap("bindRowsWithHeaders",new t),this.addHook("modifyRowHeader",(e=>function(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}(d,this,g).call(this,e))),super.enablePlugin()}disablePlugin(){this.hot.rowIndexMapper.unregisterMap("bindRowsWithHeaders"),super.disablePlugin()}destroy(){super.destroy()}}function g(e){return this.headerIndexes.getValueAtIndex(this.hot.toPhysicalRow(e))}t.BindRowsWithHeaders=p},20061:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(34229);t.PLUGIN_KEY=n.PLUGIN_KEY,t.PLUGIN_PRIORITY=n.PLUGIN_PRIORITY,t.BindRowsWithHeaders=n.BindRowsWithHeaders},86305:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(65686);const{getListWithInsertedItems:s,getListWithRemovedItems:o}=(0,n.alterUtilsFactory)("physicallyIndexed");class i extends n.IndexMap{constructor(){super((e=>e))}insert(e,t){const r=(0,n.getIncreasedIndexes)(this.indexedValues,t);this.indexedValues=s(r,e,t,this.initValueOrFn),super.insert(e,t)}remove(e){const t=o(this.indexedValues,e);this.indexedValues=(0,n.getDecreasedIndexes)(t,e),super.remove(e)}}t.default=i},52242:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(65686);const{getListWithInsertedItems:s,getListWithRemovedItems:o}=(0,n.alterUtilsFactory)("physicallyIndexed");class i extends n.IndexMap{constructor(){super((e=>e))}insert(e,t){this.indexedValues=s(this.indexedValues,e,t,((e,t)=>this.getNextValue(t))),super.insert(e,t)}remove(e){this.indexedValues=o(this.indexedValues,e),super.remove(e)}getNextValue(e){return Math.max(...this.getValues())+1+e}}t.default=i},83057:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724);var s=n(r(85707)),o=r(55006),i=r(98758),a=r(27050),l=r(39874),h=r(49536),u=r(24456),c=r(52684),d=r(81595);function p(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function g(e,t){return e.get(m(e,t))}function f(e,t,r){return e.set(m(e,t),r),r}function m(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}const E=t.PLUGIN_KEY="collapsibleColumns",y=t.PLUGIN_PRIORITY=290,w=["nestedHeaders"],C="collapsibleIndicator",R=E,v=new Map([["collapse",{hideColumn:!0,beforeHook:"beforeColumnCollapse",afterHook:"afterColumnCollapse"}],["expand",{hideColumn:!1,beforeHook:"beforeColumnExpand",afterHook:"afterColumnExpand"}]]);var S=new WeakMap,T=new WeakSet;class N extends o.BasePlugin{constructor(){var e,t;super(...arguments),p(e=this,t=T),t.add(e),(0,s.default)(this,"nestedHeadersPlugin",null),(0,s.default)(this,"headerStateManager",null),function(e,t,r){p(e,t),t.set(e,r)}(this,S,null)}static get PLUGIN_KEY(){return E}static get PLUGIN_PRIORITY(){return y}static get PLUGIN_DEPS(){return["plugin:NestedHeaders"]}static get SETTING_KEYS(){return[E,...w]}isEnabled(){return!!this.hot.getSettings()[E]}enablePlugin(){var e=this;if(this.enabled)return;const{nestedHeaders:t}=this.hot.getSettings();t||(0,l.warn)("You need to configure the Nested Headers plugin in order to use collapsible headers."),f(S,this,this.hot.columnIndexMapper.createAndRegisterIndexMap(this.pluginName,"hiding")),this.nestedHeadersPlugin=this.hot.getPlugin("nestedHeaders"),this.headerStateManager=this.nestedHeadersPlugin.getStateManager(),this.addHook("init",(()=>m(T,this,A).call(this))),this.addHook("afterLoadData",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return m(T,e,b).call(e,...r)})),this.addHook("afterGetColHeader",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return m(T,e,_).call(e,...r)})),this.addHook("beforeOnCellMouseDown",((e,t,r)=>m(T,this,M).call(this,e,t,r))),this.registerShortcuts(),super.enablePlugin(),this.updatePlugin()}updatePlugin(){if(this.hot.view){if(!this.nestedHeadersPlugin.detectedOverlappedHeaders){const{collapsibleColumns:e}=this.hot.getSettings();"boolean"==typeof e?this.headerStateManager.mapState((e=>({collapsible:e.origColspan>1}))):Array.isArray(e)&&(this.headerStateManager.mapState((()=>({collapsible:!1}))),this.headerStateManager.mergeStateWith(e))}super.updatePlugin()}}disablePlugin(){this.hot.columnIndexMapper.unregisterMap(this.pluginName),f(S,this,null),this.nestedHeadersPlugin=null,this.unregisterShortcuts(),this.clearButtons(),super.disablePlugin()}registerShortcuts(){this.hot.getShortcutManager().getContext("grid").addShortcut({keys:[["Enter"]],callback:()=>{var e;const{row:t,col:r}=this.hot.getSelectedRangeLast().highlight,{collapsible:n,isCollapsed:s,columnIndex:o}=null!==(e=this.headerStateManager.getHeaderTreeNodeData(t,r))&&void 0!==e?e:{};if(n)return s?this.expandSection({row:t,col:o}):this.collapseSection({row:t,col:o}),!1},runOnlyIf:()=>{var e,t;return(null===(e=this.hot.getSelectedRangeLast())||void 0===e?void 0:e.isSingle())&&(null===(t=this.hot.getSelectedRangeLast())||void 0===t?void 0:t.highlight.isHeader())},group:R,relativeToGroup:c.EDITOR_EDIT_GROUP,position:"before"})}unregisterShortcuts(){this.hot.getShortcutManager().getContext("grid").removeShortcutsByGroup(R)}clearButtons(){if(!this.hot.view)return;const e=this.hot.view._wt.getSetting("columnHeaders").length,t=this.hot.view._wt.wtTable.THEAD,r=this.hot.view._wt.wtOverlays.topOverlay.clone.wtTable.THEAD,n=this.hot.view._wt.wtOverlays.topInlineStartCornerOverlay?this.hot.view._wt.wtOverlays.topInlineStartCornerOverlay.clone.wtTable.THEAD:null,s=function(e){e&&e.parentNode.removeChild(e)};(0,a.rangeEach)(0,e-1,(e=>{const o=t.childNodes[e],i=r.childNodes[e],l=n?n.childNodes[e]:null;(0,a.rangeEach)(0,o.childNodes.length-1,(e=>{let t=o.childNodes[e].querySelector(`.${C}`);s(t),i&&i.childNodes[e]&&(t=i.childNodes[e].querySelector(`.${C}`),s(t)),n&&l&&l.childNodes[e]&&(t=l.childNodes[e].querySelector(`.${C}`),s(t))}))}),!0)}expandSection(e){this.toggleCollapsibleSection([e],"expand")}collapseSection(e){this.toggleCollapsibleSection([e],"collapse")}toggleAllCollapsibleSections(e){const t=this.headerStateManager.mapNodes((t=>{const{collapsible:r,origColspan:n,headerLevel:s,columnIndex:o,isCollapsed:i}=t;if(!0===r&&n>1&&(i&&"expand"===e||!i&&"collapse"===e))return{row:this.headerStateManager.levelToRowCoords(s),col:o}}));this.toggleCollapsibleSection(t,e)}collapseAll(){this.toggleAllCollapsibleSections("collapse")}expandAll(){this.toggleAllCollapsibleSections("expand")}toggleCollapsibleSection(e,t){if(!v.has(t))throw new Error(`Unsupported action is passed (${t}).`);if(!Array.isArray(e))return;const r=(0,i.arrayFilter)(e,(e=>{let{row:t}=e;return t<0}));let n=r.length>0;(0,i.arrayEach)(r,(e=>{var r;let{row:s,col:o}=e;const{collapsible:i,isCollapsed:a}=null!==(r=this.headerStateManager.getHeaderSettings(s,o))&&void 0!==r?r:{};if(!i||a&&"collapse"===t||!a&&"expand"===t)return n=!1,!1}));const s=[],o=[];n&&(0,i.arrayEach)(r,(e=>{let{row:r,col:n}=e;const{colspanCompensation:i,affectedColumns:a,rollbackModification:l}=this.headerStateManager.triggerNodeModification(t,r,n);i>0&&(o.push(...a),s.push(l))}));const a=this.getCollapsedColumns();let l=[];"collapse"===t?l=(0,i.arrayUnique)([...a,...o]):"expand"===t&&(l=(0,i.arrayFilter)(a,(e=>!o.includes(e))));const h=v.get(t);if(!1===this.hot.runHooks(h.beforeHook,a,l,n))return void(0,i.arrayEach)(s,(e=>{e()}));this.hot.batchExecution((()=>{(0,i.arrayEach)(o,(e=>{g(S,this).setValueAtIndex(this.hot.toPhysicalColumn(e),h.hideColumn)}))}),!0);const u=this.getCollapsedColumns().length!==a.length,c=this.hot.getSelectedRangeLast();if("collapse"===t&&u&&c){const{row:e,col:t}=c.highlight;if((this.hot.rowIndexMapper.isHidden(e)||this.hot.columnIndexMapper.isHidden(t))&&o.includes(t)){const r=e>=0?this.hot.rowIndexMapper.getNearestNotHiddenIndex(e,1,!0):e,n=t>=0?this.hot.columnIndexMapper.getNearestNotHiddenIndex(t,1,!0):t;null!==r&&null!==n&&this.hot.selectCell(r,n)}}this.hot.runHooks(h.afterHook,a,l,n,u),this.hot.render(),this.hot.view.adjustElementsSize(!0)}getCollapsedColumns(){return g(S,this).getHiddenIndexes()}destroy(){f(S,this,null),super.destroy()}}function _(e,t,r){var n;const{collapsible:s,origColspan:o,isCollapsed:i}=null!==(n=this.headerStateManager.getHeaderSettings(r,e))&&void 0!==n?n:{},a=s&&o>1&&e>=this.hot.getSettings().fixedColumnsStart,l=this.hot.getSettings().ariaTags;let u=t.querySelector(`.${C}`);var c;((0,h.removeAttribute)(t,[(0,d.A11Y_EXPANDED)("")[0]]),a)?(u||(u=this.hot.rootDocument.createElement("div"),(0,h.addClass)(u,C),t.querySelector("div:first-child").appendChild(u)),(0,h.removeClass)(u,["collapsed","expanded"]),i?((0,h.addClass)(u,"collapsed"),(0,h.fastInnerText)(u,"+"),l&&(0,h.setAttribute)(t,...(0,d.A11Y_EXPANDED)(!1))):((0,h.addClass)(u,"expanded"),(0,h.fastInnerText)(u,"-"),l&&(0,h.setAttribute)(t,...(0,d.A11Y_EXPANDED)(!0))),l&&(0,h.setAttribute)(u,...(0,d.A11Y_HIDDEN)())):null===(c=u)||void 0===c||c.remove()}function M(e,t){(0,h.hasClass)(e.target,C)&&((0,h.hasClass)(e.target,"expanded")?(this.eventManager.fireEvent(e.target,"mouseup"),this.toggleCollapsibleSection([t],"collapse")):(0,h.hasClass)(e.target,"collapsed")&&(this.eventManager.fireEvent(e.target,"mouseup"),this.toggleCollapsibleSection([t],"expand")),(0,u.stopImmediatePropagation)(e))}function A(){this.updatePlugin()}function b(e,t){t||this.updatePlugin()}t.CollapsibleColumns=N},7144:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(83057);t.PLUGIN_KEY=n.PLUGIN_KEY,t.PLUGIN_PRIORITY=n.PLUGIN_PRIORITY,t.CollapsibleColumns=n.CollapsibleColumns},625:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724);var s=n(r(85707)),o=r(49536),i=r(67508),a=r(58460),l=r(25735),h=r(98758),u=r(55006),c=r(65686),d=n(r(37056)),p=r(55480),g=r(52684),f=r(14430),m=r(4598),E=r(61067),y=r(46595),w=r(81595);function C(e,t){!function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}(e,t),t.add(e)}function R(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}const v=t.PLUGIN_KEY="columnSorting",S=t.PLUGIN_PRIORITY=50,T=t.APPEND_COLUMN_CONFIG_STRATEGY="append",N=t.REPLACE_COLUMN_CONFIG_STRATEGY="replace",_=v;(0,y.registerRootComparator)(v,E.rootComparator),d.default.getSingleton().register("beforeColumnSort"),d.default.getSingleton().register("afterColumnSort");var M=new WeakSet;class A extends u.BasePlugin{constructor(){super(...arguments),C(this,M),(0,s.default)(this,"columnStatesManager",null),(0,s.default)(this,"columnMetaCache",null),(0,s.default)(this,"pluginKey",v),(0,s.default)(this,"indexesSequenceCache",null)}static get PLUGIN_KEY(){return v}static get PLUGIN_PRIORITY(){return S}isEnabled(){return!!this.hot.getSettings()[this.pluginKey]}enablePlugin(){var e=this;this.enabled||(this.columnStatesManager=new p.ColumnStatesManager(this.hot,`${this.pluginKey}.sortingStates`),this.columnMetaCache=new c.PhysicalIndexToValueMap((e=>{let t=this.hot.toVisualColumn(e);return null===t&&(t=e),this.getMergedPluginSettings(t)})),this.hot.columnIndexMapper.registerMap(`${this.pluginKey}.columnMeta`,this.columnMetaCache),this.addHook("afterGetColHeader",((e,t)=>R(M,this,I).call(this,e,t))),this.addHook("beforeOnCellMouseDown",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return R(M,e,x).call(e,...r)})),this.addHook("afterOnCellMouseDown",((e,t)=>this.onAfterOnCellMouseDown(e,t))),this.addHook("afterInit",(()=>R(M,this,b).call(this))),this.addHook("afterLoadData",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return R(M,e,O).call(e,...r)})),this.hot.view&&R(M,this,b).call(this),this.registerShortcuts(),super.enablePlugin())}disablePlugin(){const e=(e,t)=>{const r=(0,f.getHeaderSpanElement)(t);!1!==(0,f.isFirstLevelColumnHeader)(e,t)&&null!==r&&this.updateHeaderClasses(r)};this.hot.addHook("afterGetColHeader",e),this.hot.addHookOnce("afterViewRender",(()=>{this.hot.removeHook("afterGetColHeader",e)})),this.hot.batchExecution((()=>{null!==this.indexesSequenceCache&&(this.hot.rowIndexMapper.setIndexesSequence(this.indexesSequenceCache.getValues()),this.hot.rowIndexMapper.unregisterMap(this.pluginKey))}),!0),this.hot.columnIndexMapper.unregisterMap(`${this.pluginKey}.columnMeta`),this.columnStatesManager.destroy(),this.columnMetaCache=null,this.columnStatesManager=null,this.unregisterShortcuts(),super.disablePlugin()}registerShortcuts(){this.hot.getShortcutManager().getContext("grid").addShortcut({keys:[["Enter"]],callback:()=>{const{highlight:e}=this.hot.getSelectedRangeLast();return this.sort(this.getColumnNextConfig(e.col)),!1},runOnlyIf:()=>{var e,t;const r=null===(e=this.hot.getSelectedRangeLast())||void 0===e?void 0:e.highlight;return r&&(null===(t=this.hot.getSelectedRangeLast())||void 0===t?void 0:t.isSingle())&&this.hot.selection.isCellVisible(r)&&-1===r.row&&r.col>=0},relativeToGroup:g.EDITOR_EDIT_GROUP,position:"before",group:_})}unregisterShortcuts(){this.hot.getShortcutManager().getContext("grid").removeShortcutsByGroup(_)}sort(e){const t=this.getSortConfig(),r=this.getNormalizedSortConfigs(e),n=this.areValidSortConfigs(r);!1!==this.hot.runHooks("beforeColumnSort",t,r,n)&&(0===t.length&&null===this.indexesSequenceCache&&(this.indexesSequenceCache=this.hot.rowIndexMapper.registerMap(this.pluginKey,new c.IndexesSequence),this.indexesSequenceCache.setValues(this.hot.rowIndexMapper.getIndexesSequence())),n&&(this.columnStatesManager.setSortStates(r),this.sortByPresetSortStates(r),this.saveAllSortSettings(r)),this.hot.runHooks("afterColumnSort",t,n?r:t,n),n&&(this.hot.render(),this.hot.forceFullRender=!1,this.hot.view.render()))}clearSort(){this.sort([])}isSorted(){return this.enabled&&!this.columnStatesManager.isListOfSortedColumnsEmpty()}getSortConfig(e){return(0,i.isDefined)(e)?this.columnStatesManager.getColumnSortState(e):this.columnStatesManager.getSortStates()}setSortConfig(e){const t=this.getNormalizedSortConfigs(e);this.areValidSortConfigs(t)&&this.columnStatesManager.setSortStates(t)}getNormalizedSortConfigs(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[];return Array.isArray(e)?e.slice(0,1):[e]}areValidSortConfigs(e){const t=this.hot.countCols();return(0,f.areValidSortStates)(e)&&e.every((e=>{let{column:r}=e;return r<=t&&r>=0}))}saveAllSortSettings(e){const t=this.columnStatesManager.getAllColumnsProperties();t.initialConfig=(0,h.arrayMap)(e,(e=>{let{column:t,...r}=e;return{column:this.hot.toPhysicalColumn(t),...r}})),this.hot.runHooks("persistentStateSave","columnSorting",t)}getAllSavedSortSettings(){const e={};this.hot.runHooks("persistentStateLoad","columnSorting",e);const t=e.value,r=e=>{let{column:t,...r}=e;return{column:this.hot.toVisualColumn(t),...r}};return(0,i.isDefined)(t)&&Array.isArray(t.initialConfig)&&(t.initialConfig=(0,h.arrayMap)(t.initialConfig,r)),t}getColumnNextConfig(e){const t=this.columnStatesManager.getSortOrderOfColumn(e);if((0,i.isDefined)(t)){const r=(0,f.getNextSortOrder)(t);return(0,i.isDefined)(r)?{column:e,sortOrder:r}:void 0}const r=this.hot.countCols();if(Number.isInteger(e)&&e>=0&&e<r)return{column:e,sortOrder:(0,f.getNextSortOrder)()}}getNextSortConfig(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:T;const r=this.columnStatesManager.getIndexOfColumnInSortQueue(e),n=-1!==r,s=this.getSortConfig(),o=this.getColumnNextConfig(e);if(n){if((0,i.isUndefined)(o))return[...s.slice(0,r),...s.slice(r+1)];if(t===T)return[...s.slice(0,r),...s.slice(r+1),o];if(t===N)return[...s.slice(0,r),o,...s.slice(r+1)]}return(0,i.isDefined)(o)?s.concat(o):s}getPluginColumnConfig(e){if((0,a.isObject)(e)){const t=e[this.pluginKey];if((0,a.isObject)(t))return t}return{}}getMergedPluginSettings(e){const t=this.hot.getSettings()[this.pluginKey],r=this.columnStatesManager.getAllColumnsProperties(),n=this.hot.getCellMeta(0,e),s=Object.getPrototypeOf(n);return Array.isArray(s.columns)?Object.assign(r,t,this.getPluginColumnConfig(s.columns[e])):(0,l.isFunction)(s.columns)?Object.assign(r,t,this.getPluginColumnConfig(s.columns(e))):Object.assign(r,t)}getFirstCellSettings(e){const t=this.hot.getCellMeta(0,e),r=Object.create(t);return r[this.pluginKey]=this.columnMetaCache.getValueAtIndex(this.hot.toPhysicalColumn(e)),r}getNumberOfRowsToSort(e){const t=this.hot.getSettings();return t.maxRows<=e?t.maxRows:e-t.minSpareRows}sortByPresetSortStates(e){if(0===e.length)return void this.hot.rowIndexMapper.setIndexesSequence(this.indexesSequenceCache.getValues());const t=[],r=this.hot.countRows(),n=t=>(0,h.arrayMap)(e,(e=>this.hot.getDataAtCell(t,e.column)));for(let e=0;e<this.getNumberOfRowsToSort(r);e+=1)t.push([this.hot.toPhysicalRow(e)].concat(n(e)));const s=(0,h.arrayMap)(t,(e=>e[0]));(0,y.sort)(t,this.pluginKey,(0,h.arrayMap)(e,(e=>e.sortOrder)),(0,h.arrayMap)(e,(e=>this.getFirstCellSettings(e.column))));for(let e=t.length;e<r;e+=1)t.push([e].concat(n(e)));const o=(0,h.arrayMap)(t,(e=>e[0])),i=new Map((0,h.arrayMap)(s,((e,t)=>[e,o[t]]))),a=(0,h.arrayMap)(this.hot.rowIndexMapper.getIndexesSequence(),(e=>i.has(e)?i.get(e):e));this.hot.rowIndexMapper.setIndexesSequence(a)}sortBySettings(e){if((0,a.isObject)(e)){this.columnStatesManager.updateAllColumnsProperties(e);const t=e.initialConfig;(Array.isArray(t)||(0,a.isObject)(t))&&this.sort(t)}else this.hot.render()}updateHeaderClasses(e){if((0,o.removeClass)(e,(0,m.getClassesToRemove)(e)),!1!==this.enabled){for(var t=arguments.length,r=new Array(t>1?t-1:0),n=1;n<t;n++)r[n-1]=arguments[n];(0,o.addClass)(e,(0,m.getClassesToAdd)(...r))}}onUpdateSettings(e){super.onUpdateSettings(),null!==this.columnMetaCache&&this.columnMetaCache.init(this.hot.columnIndexMapper.getNumberOfIndexes()),(0,i.isDefined)(e[this.pluginKey])&&this.sortBySettings(e[this.pluginKey])}wasClickableHeaderClicked(e,t){return this.getFirstCellSettings(t)[this.pluginKey].headerAction&&(0,o.hasClass)(e.target,f.HEADER_SPAN_CLASS)}onAfterOnCellMouseDown(e,t){!1!==(0,f.wasHeaderClickedProperly)(t.row,t.col,e)&&this.wasClickableHeaderClicked(e,t.col)&&(this.hot.getShortcutManager().isCtrlPressed()&&(this.hot.deselectCell(),this.hot.selectColumns(t.col)),this.sort(this.getColumnNextConfig(t.col)))}destroy(){var e;null===(e=this.columnStatesManager)||void 0===e||e.destroy(),super.destroy()}}function b(){const e=this.getAllSavedSortSettings();if((0,a.isObject)(e))this.sortBySettings(e);else{const e=this.hot.getSettings()[this.pluginKey];this.sortBySettings(e)}}function I(e,t){const r=(0,f.getHeaderSpanElement)(t);if(!1===(0,f.isFirstLevelColumnHeader)(e,t)||null===r)return;const n=this.getFirstCellSettings(e)[this.pluginKey],s=n.indicator,i=n.headerAction;if(this.updateHeaderClasses(r,this.columnStatesManager,e,s,i),this.hot.getSettings().ariaTags){const r=this.columnStatesManager.getSortOrderOfColumn(e);(0,o.setAttribute)(t,...(0,w.A11Y_SORT)(r?`${r}ending`:"none"))}}function O(e){!0===e&&this.hot.view&&R(M,this,b).call(this)}function x(e,t,r,n){!1!==(0,f.wasHeaderClickedProperly)(t.row,t.col,e)&&this.wasClickableHeaderClicked(e,t.col)&&this.hot.getShortcutManager().isCtrlPressed()&&(n.column=!0)}t.ColumnSorting=A},55480:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),o=r(58460),i=r(65686),a=r(67508);const l=["sortEmptyCells","indicator","headerAction","compareFunctionFactory"];t.ColumnStatesManager=class{constructor(e,t){(0,s.default)(this,"hot",void 0),(0,s.default)(this,"sortingStates",new i.LinkedPhysicalIndexToValueMap),(0,s.default)(this,"sortEmptyCells",false),(0,s.default)(this,"indicator",true),(0,s.default)(this,"headerAction",true),(0,s.default)(this,"compareFunctionFactory",void 0),(0,s.default)(this,"mapName",void 0),this.hot=e,this.mapName=t,this.hot.columnIndexMapper.registerMap(t,this.sortingStates)}updateAllColumnsProperties(e){(0,o.isObject)(e)&&(0,o.objectEach)(e,((e,t)=>{l.includes(t)&&(this[t]=e)}))}getAllColumnsProperties(){const e={sortEmptyCells:this.sortEmptyCells,indicator:this.indicator,headerAction:this.headerAction};return"function"==typeof this.compareFunctionFactory&&(e.compareFunctionFactory=this.compareFunctionFactory),e}getSortOrderOfColumn(e){var t;return null===(t=this.sortingStates.getValueAtIndex(this.hot.toPhysicalColumn(e)))||void 0===t?void 0:t.sortOrder}getIndexOfColumnInSortQueue(e){return e=this.hot.toPhysicalColumn(e),this.sortingStates.getEntries().findIndex((t=>{let[r]=t;return r===e}))}getNumberOfSortedColumns(){return this.sortingStates.getLength()}isListOfSortedColumnsEmpty(){return 0===this.getNumberOfSortedColumns()}isColumnSorted(e){return(0,o.isObject)(this.sortingStates.getValueAtIndex(this.hot.toPhysicalColumn(e)))}getSortStates(){if(null===this.sortingStates)return[];return this.sortingStates.getEntries().map((e=>{let[t,r]=e;return{column:this.hot.toVisualColumn(t),...r}}))}getColumnSortState(e){const t=this.getSortOrderOfColumn(e);if((0,a.isDefined)(t))return{column:e,sortOrder:t}}setSortStates(e){this.sortingStates.clear();for(let t=0;t<e.length;t+=1)this.sortingStates.setValueAtIndex(this.hot.toPhysicalColumn(e[t].column),{sortOrder:e[t].sortOrder})}destroy(){this.hot.columnIndexMapper.unregisterMap(this.mapName),this.sortingStates=null}}},4598:(e,t,r)=>{"use strict";t.__esModule=!0,t.getClassesToAdd=function(e,t,r,s){const h=[i];s&&h.push(a);if(!1===r)return h.push(o),h;const u=e.getSortOrderOfColumn(t);(0,n.isDefined)(u)&&h.push(l.get(u));return h},t.getClassesToRemove=function(){return Array.from(l.values()).concat(a,o,i)},r(15724);var n=r(67508),s=r(14430);const o="indicatorDisabled",i="columnSorting",a="sortAction",l=new Map([[s.ASC_SORT_STATE,"ascending"],[s.DESC_SORT_STATE,"descending"]])},39651:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(625);t.PLUGIN_KEY=n.PLUGIN_KEY,t.PLUGIN_PRIORITY=n.PLUGIN_PRIORITY,t.ColumnSorting=n.ColumnSorting,t.APPEND_COLUMN_CONFIG_STRATEGY=n.APPEND_COLUMN_CONFIG_STRATEGY,t.REPLACE_COLUMN_CONFIG_STRATEGY=n.REPLACE_COLUMN_CONFIG_STRATEGY},61067:(e,t,r)=>{"use strict";t.__esModule=!0,t.rootComparator=function(e,t){return function(r,s){const[,...o]=r,[,...i]=s;return function(r){const s=e[r],a=t[r],l=o[r],h=i[r],u=a.columnSorting;return(u.compareFunctionFactory?u.compareFunctionFactory:(0,n.getCompareFunctionFactory)(a.type))(s,a,u)(l,h)}(0)}};var n=r(46595)},21547:(e,t,r)=>{"use strict";t.__esModule=!0,t.compareFunctionFactory=function(e,t,r){const i=t.checkedTemplate,a=t.uncheckedTemplate,{sortEmptyCells:l}=r;return function(h,u){const c=(0,o.isEmpty)(h),d=(0,o.isEmpty)(u),p=c?a:h,g=d?a:u,f=p===a||p===i,m=g===a||g===i;if(!1===l){if(c&&!1===d)return n.FIRST_AFTER_SECOND;if(!1===c&&d)return n.FIRST_BEFORE_SECOND}return!1===f&&m?"asc"===e?n.FIRST_BEFORE_SECOND:n.FIRST_AFTER_SECOND:f&&!1===m?"asc"===e?n.FIRST_AFTER_SECOND:n.FIRST_BEFORE_SECOND:!1===f&&!1===m?(0,s.compareFunctionFactory)(e,t,r)(h,u):p===a&&g===i?"asc"===e?n.FIRST_BEFORE_SECOND:n.FIRST_AFTER_SECOND:p===i&&g===a?"asc"===e?n.FIRST_AFTER_SECOND:n.FIRST_BEFORE_SECOND:n.DO_NOT_SWAP}};var n=r(46595),s=r(22157),o=r(67508);t.COLUMN_DATA_TYPE="checkbox"},61654:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.compareFunctionFactory=function(e,t,r){return function(n,a){const{sortEmptyCells:l}=r;if(n===a)return i.DO_NOT_SWAP;if((0,o.isEmpty)(n))return(0,o.isEmpty)(a)?i.DO_NOT_SWAP:l&&"asc"===e?i.FIRST_BEFORE_SECOND:i.FIRST_AFTER_SECOND;if((0,o.isEmpty)(a))return l&&"asc"===e?i.FIRST_AFTER_SECOND:i.FIRST_BEFORE_SECOND;const h=t.dateFormat,u=(0,s.default)(n,h),c=(0,s.default)(a,h);return u.isValid()?c.isValid()?c.isAfter(u)?"asc"===e?i.FIRST_BEFORE_SECOND:i.FIRST_AFTER_SECOND:c.isBefore(u)?"asc"===e?i.FIRST_AFTER_SECOND:i.FIRST_BEFORE_SECOND:i.DO_NOT_SWAP:i.FIRST_BEFORE_SECOND:i.FIRST_AFTER_SECOND}};var s=n(r(56476)),o=r(67508),i=r(46595);t.COLUMN_DATA_TYPE="date"},22157:(e,t,r)=>{"use strict";t.__esModule=!0,t.compareFunctionFactory=function(e,t,r){const o=t.locale;return function(t,i){const{sortEmptyCells:a}=r;return"string"==typeof t&&(t=t.toLocaleLowerCase(o)),"string"==typeof i&&(i=i.toLocaleLowerCase(o)),t===i?s.DO_NOT_SWAP:(0,n.isEmpty)(t)?(0,n.isEmpty)(i)?s.DO_NOT_SWAP:a&&"asc"===e?s.FIRST_BEFORE_SECOND:s.FIRST_AFTER_SECOND:(0,n.isEmpty)(i)?a&&"asc"===e?s.FIRST_AFTER_SECOND:s.FIRST_BEFORE_SECOND:isNaN(t)&&!isNaN(i)?"asc"===e?s.FIRST_AFTER_SECOND:s.FIRST_BEFORE_SECOND:!isNaN(t)&&isNaN(i)?"asc"===e?s.FIRST_BEFORE_SECOND:s.FIRST_AFTER_SECOND:(isNaN(t)||isNaN(i)||(t=parseFloat(t),i=parseFloat(i)),t<i?"asc"===e?s.FIRST_BEFORE_SECOND:s.FIRST_AFTER_SECOND:t>i?"asc"===e?s.FIRST_AFTER_SECOND:s.FIRST_BEFORE_SECOND:s.DO_NOT_SWAP)}};var n=r(67508),s=r(46595);t.COLUMN_DATA_TYPE="default"},6651:(e,t,r)=>{"use strict";t.__esModule=!0,t.compareFunctionFactory=function(e,t,r){return function(t,o){const i=parseFloat(t),a=parseFloat(o),{sortEmptyCells:l}=r;if(i===a||isNaN(i)&&isNaN(a))return s.DO_NOT_SWAP;if(l){if((0,n.isEmpty)(t))return"asc"===e?s.FIRST_BEFORE_SECOND:s.FIRST_AFTER_SECOND;if((0,n.isEmpty)(o))return"asc"===e?s.FIRST_AFTER_SECOND:s.FIRST_BEFORE_SECOND}return isNaN(i)?s.FIRST_AFTER_SECOND:isNaN(a)?s.FIRST_BEFORE_SECOND:i<a?"asc"===e?s.FIRST_BEFORE_SECOND:s.FIRST_AFTER_SECOND:i>a?"asc"===e?s.FIRST_AFTER_SECOND:s.FIRST_BEFORE_SECOND:s.DO_NOT_SWAP}};var n=r(67508),s=r(46595);t.COLUMN_DATA_TYPE="numeric"},22845:(e,t,r)=>{"use strict";t.__esModule=!0,t.sort=function(e,t){const r=(0,n.getRootComparator)(t);for(var s=arguments.length,o=new Array(s>2?s-2:0),i=2;i<s;i++)o[i-2]=arguments[i];e.sort(r(...o))};var n=r(59804);t.DO_NOT_SWAP=0,t.FIRST_BEFORE_SECOND=-1,t.FIRST_AFTER_SECOND=1},46595:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(59804);t.registerRootComparator=n.registerRootComparator,t.getRootComparator=n.getRootComparator,t.getCompareFunctionFactory=n.getCompareFunctionFactory;var s=r(22845);t.FIRST_AFTER_SECOND=s.FIRST_AFTER_SECOND,t.FIRST_BEFORE_SECOND=s.FIRST_BEFORE_SECOND,t.DO_NOT_SWAP=s.DO_NOT_SWAP,t.sort=s.sort},59804:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.getCompareFunctionFactory=function(e){if(c(e))return u(e);return u(s.COLUMN_DATA_TYPE)};var s=r(22157),o=r(6651),i=r(21547),a=r(61654),l=n(r(45212));const{register:h,getItem:u,hasItem:c}=(0,l.default)("sorting.compareFunctionFactory"),{register:d,getItem:p}=(0,l.default)("sorting.mainSortComparator");t.getRootComparator=p,t.registerRootComparator=d,h(o.COLUMN_DATA_TYPE,o.compareFunctionFactory),h(i.COLUMN_DATA_TYPE,i.compareFunctionFactory),h(a.COLUMN_DATA_TYPE,a.compareFunctionFactory),h(s.COLUMN_DATA_TYPE,s.compareFunctionFactory)},14430:(e,t,r)=>{"use strict";t.__esModule=!0,t.areValidSortStates=function(e){if(e.some((e=>!1===function(e){if(!1===(0,n.isObject)(e))return!1;const{column:t,sortOrder:r}=e;return Number.isInteger(t)&&[o,i].includes(r)}(e))))return!1;const t=e.map((e=>{let{column:t}=e;return t}));return new Set(t).size===t.length},t.getHeaderSpanElement=function(e){return e.querySelector(`.${a}`)},t.getNextSortOrder=function(e){if(e===i)return;if(e===o)return i;return o},t.isFirstLevelColumnHeader=function(e,t){if(e<0||!t.parentNode)return!1;const r=t.parentNode.parentNode.childNodes;if(Array.from(r).indexOf(t.parentNode)-r.length!=-1)return!1;return!0},t.wasHeaderClickedProperly=function(e,t,r){return-1===e&&t>=0&&!1===(0,s.isRightClick)(r)};var n=r(58460),s=r(24456);const o=t.ASC_SORT_STATE="asc",i=t.DESC_SORT_STATE="desc",a=t.HEADER_SPAN_CLASS="colHeader"},4885:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),o=r(55006),i=r(58460),a=n(r(66677)),l=r(12556),h=r(68674);function u(e,t){!function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}(e,t),t.add(e)}function c(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}const d=t.PLUGIN_KEY="columnSummary",p=t.PLUGIN_PRIORITY=220;var g=new WeakSet;class f extends o.BasePlugin{constructor(){super(...arguments),u(this,g),(0,s.default)(this,"endpoints",null)}static get PLUGIN_KEY(){return d}static get PLUGIN_PRIORITY(){return p}isEnabled(){return!!this.hot.getSettings()[d]}enablePlugin(){var e=this;this.enabled||(this.settings=this.hot.getSettings()[d],this.endpoints=new a.default(this,this.settings),this.addHook("afterInit",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return c(g,e,m).call(e,...r)})),this.addHook("afterChange",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return c(g,e,E).call(e,...r)})),this.addHook("beforeCreateRow",((e,t,r)=>this.endpoints.resetSetupBeforeStructureAlteration("insert_row",e,t,null,r))),this.addHook("beforeCreateCol",((e,t,r)=>this.endpoints.resetSetupBeforeStructureAlteration("insert_col",e,t,null,r))),this.addHook("beforeRemoveRow",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return e.endpoints.resetSetupBeforeStructureAlteration("remove_row",...r)})),this.addHook("beforeRemoveCol",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return e.endpoints.resetSetupBeforeStructureAlteration("remove_col",...r)})),this.addHook("afterCreateRow",((e,t,r)=>this.endpoints.resetSetupAfterStructureAlteration("insert_row",e,t,null,r))),this.addHook("afterCreateCol",((e,t,r)=>this.endpoints.resetSetupAfterStructureAlteration("insert_col",e,t,null,r))),this.addHook("afterRemoveRow",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return e.endpoints.resetSetupAfterStructureAlteration("remove_row",...r)})),this.addHook("afterRemoveCol",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return e.endpoints.resetSetupAfterStructureAlteration("remove_col",...r)})),this.addHook("afterRowMove",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return c(g,e,y).call(e,...r)})),super.enablePlugin())}disablePlugin(){this.endpoints=null,this.settings=null,this.currentEndpoint=null,super.disablePlugin()}updatePlugin(){this.disablePlugin(),this.enablePlugin(),this.endpoints.initEndpoints(),super.updatePlugin()}calculate(e){switch(e.type.toLowerCase()){case"sum":e.result=this.calculateSum(e);break;case"min":case"max":e.result=this.calculateMinMax(e,e.type);break;case"count":e.result=this.countEntries(e);break;case"average":e.result=this.calculateAverage(e);break;case"custom":e.result=e.customFunction.call(this,e)}}calculateSum(e){let t=0;return(0,i.objectEach)(e.ranges,(r=>{t+=this.getPartialSum(r,e.sourceColumn)})),t}getPartialSum(e,t){let r=0,n=e[1]||e[0],s=null,o=0;do{if(s=this.getCellValue(n,t),s=(0,h.isNullishOrNaN)(s)?null:s,null!==s){const e=(`${s}`.split(".")[1]||[]).length||1;e>o&&(o=e)}r+=s||0,n-=1}while(n>=e[0]);return Math.round(r*10**o)/10**o}calculateMinMax(e,t){let r=null;return(0,i.objectEach)(e.ranges,(n=>{const s=this.getPartialMinMax(n,e.sourceColumn,t);if(null===r&&null!==s&&(r=s),null!==s)switch(t){case"min":r=Math.min(r,s);break;case"max":r=Math.max(r,s)}})),null===r?"Not enough data":r}getPartialMinMax(e,t,r){let n,s=null,o=e[1]||e[0];do{if(n=this.getCellValue(o,t),n=(0,h.isNullishOrNaN)(n)?null:n,null===s)s=n;else if(null!==n)switch(r){case"min":s=Math.min(s,n);break;case"max":s=Math.max(s,n)}o-=1}while(o>=e[0]);return s}countEmpty(e,t){let r,n=0,s=e[1]||e[0];do{r=this.getCellValue(s,t),r=(0,h.isNullishOrNaN)(r)?null:r,null===r&&(n+=1),s-=1}while(s>=e[0]);return n}countEntries(e){let t=0;const r=e.ranges;return(0,i.objectEach)(r,(r=>{const n=void 0===r[1]?1:r[1]-r[0]+1,s=this.countEmpty(r,e.sourceColumn);t+=n,t-=s})),t}calculateAverage(e){return this.calculateSum(e)/this.countEntries(e)}getCellValue(e,t){const r=this.hot.toVisualRow(e),n=this.hot.toVisualColumn(t);let s=this.hot.getSourceDataAtCell(e,t),o="";if(null!==r&&null!==n&&(o=this.hot.getCellMeta(r,n).className||""),o.indexOf("columnSummaryResult")>-1)return null;if(this.endpoints.currentEndpoint.forceNumeric&&("string"==typeof s&&(s=s.replace(/,/,".")),s=parseFloat(s)),isNaN(s)&&!this.endpoints.currentEndpoint.suppressDataTypeErrors)throw new Error(l.toSingleLine`ColumnSummary plugin: cell at (${e}, ${t}) is not in a\x20
          numeric format. Cannot do the calculation.`);return s}}function m(){this.endpoints.initEndpoints()}function E(e,t){e&&"ColumnSummary.reset"!==t&&"ColumnSummary.set"!==t&&"loadData"!==t&&this.endpoints.refreshChangedEndpoints(e)}function y(e,t){this.endpoints.resetSetupBeforeStructureAlteration("move_row",e[0],e.length,e,this.pluginName),this.endpoints.resetSetupAfterStructureAlteration("move_row",t,e.length,e,this.pluginName)}t.ColumnSummary=f},66677:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724);var s=n(r(85707)),o=r(98758),i=r(39874);t.default=class{constructor(e,t){(0,s.default)(this,"plugin",void 0),(0,s.default)(this,"hot",void 0),(0,s.default)(this,"endpoints",[]),(0,s.default)(this,"settings",void 0),(0,s.default)(this,"settingsType","array"),(0,s.default)(this,"currentEndpoint",null),(0,s.default)(this,"cellsToSetCache",[]),this.plugin=e,this.hot=this.plugin.hot,this.settings=t}initEndpoints(){this.endpoints=this.parseSettings(),this.refreshAllEndpoints()}getEndpoint(e){return"function"===this.settingsType?this.fillMissingEndpointData(this.settings)[e]:this.endpoints[e]}getAllEndpoints(){return"function"===this.settingsType?this.fillMissingEndpointData(this.settings):this.endpoints}fillMissingEndpointData(e){return this.parseSettings(e.call(this))}parseSettings(e){const t=[];let r=e;if(r||"function"!=typeof this.settings)return r||(r=this.settings),(0,o.arrayEach)(r,(e=>{const r={};this.assignSetting(e,r,"ranges",[[0,this.hot.countRows()-1]]),this.assignSetting(e,r,"reversedRowCoords",!1),this.assignSetting(e,r,"destinationRow",new Error("\n        You must provide a destination row for the Column Summary plugin in order to work properly!\n      ")),this.assignSetting(e,r,"destinationColumn",new Error("\n        You must provide a destination column for the Column Summary plugin in order to work properly!\n      ")),this.assignSetting(e,r,"sourceColumn",e.destinationColumn),this.assignSetting(e,r,"type","sum"),this.assignSetting(e,r,"forceNumeric",!1),this.assignSetting(e,r,"suppressDataTypeErrors",!0),this.assignSetting(e,r,"customFunction",null),this.assignSetting(e,r,"readOnly",!0),this.assignSetting(e,r,"roundFloat",!1),t.push(r)})),t;this.settingsType="function"}assignSetting(e,t,r,n){if("ranges"!==r||void 0!==e[r]){if("ranges"!==r||0!==e[r].length)if(void 0===e[r]){if(n instanceof Error)throw n;t[r]=n}else"destinationRow"===r&&t.reversedRowCoords?t[r]=this.hot.countRows()-e[r]-1:t[r]=e[r]}else t[r]=n}resetSetupBeforeStructureAlteration(e,t,r){if("function"!==this.settingsType)return;const n=e.indexOf("row")>-1?"row":"col",s=this.getAllEndpoints();(0,o.arrayEach)(s,(s=>{"row"===n&&s.destinationRow>=t&&("insert_row"===e?s.alterRowOffset=r:"remove_row"===e&&(s.alterRowOffset=-1*r)),"col"===n&&s.destinationColumn>=t&&("insert_col"===e?s.alterColumnOffset=r:"remove_col"===e&&(s.alterColumnOffset=-1*r))})),this.resetAllEndpoints(s,!1)}resetSetupAfterStructureAlteration(e,t,r,n,s){let i=!(arguments.length>5&&void 0!==arguments[5])||arguments[5];if("function"===this.settingsType){const e=()=>(this.hot.removeHook("beforeViewRender",e),this.refreshAllEndpoints());return void this.hot.addHookOnce("beforeViewRender",e)}const a=e.indexOf("row")>-1?"row":"col",l=e.indexOf("remove")>-1?-1:1,h=this.getAllEndpoints(),u=0===e.indexOf("move_row"),c=t;(0,o.arrayEach)(h,(e=>{"row"===a&&e.destinationRow>=c&&(e.alterRowOffset=l*r),"col"===a&&e.destinationColumn>=c&&(e.alterColumnOffset=l*r)})),this.resetAllEndpoints(h,!u),u?(0,o.arrayEach)(h,(e=>{this.extendEndpointRanges(e,c,n[0],n.length),this.recreatePhysicalRanges(e),this.clearOffsetInformation(e)})):(0,o.arrayEach)(h,(e=>{this.shiftEndpointCoordinates(e,c)})),i&&this.refreshAllEndpoints()}clearOffsetInformation(e){e.alterRowOffset=void 0,e.alterColumnOffset=void 0}extendEndpointRanges(e,t,r,n){(0,o.arrayEach)(e.ranges,(e=>{e[1]&&(t>=e[0]&&t<=e[1]?r>e[1]?e[1]+=n:r<e[0]&&(e[0]-=n):r>=e[0]&&r<=e[1]&&(e[1]-=n,t<=e[0]&&(e[0]+=1,e[1]+=1)))}))}recreatePhysicalRanges(e){const t=e.ranges,r=[],n=[];(0,o.arrayEach)(t,(e=>{const t=[];if(e[1])for(let r=e[0];r<=e[1];r++)t.push(this.hot.toPhysicalRow(r));else t.push(this.hot.toPhysicalRow(e[0]));n.push(t)})),(0,o.arrayEach)(n,(e=>{let t=[];(0,o.arrayEach)(e,((n,s)=>{0===s?t.push(n):e[s]!==e[s-1]+1&&(t.push(e[s-1]),r.push(t),t=[],t.push(n)),s===e.length-1&&(t.push(n),r.push(t))}))})),e.ranges=r}shiftEndpointCoordinates(e,t){e.alterRowOffset&&0!==e.alterRowOffset?(e.destinationRow+=e.alterRowOffset||0,(0,o.arrayEach)(e.ranges,(r=>{(0,o.arrayEach)(r,((n,s)=>{n>=t&&(r[s]+=e.alterRowOffset||0)}))}))):e.alterColumnOffset&&0!==e.alterColumnOffset&&(e.destinationColumn+=e.alterColumnOffset||0,e.sourceColumn+=e.alterColumnOffset||0)}resetAllEndpoints(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getAllEndpoints(),t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];e.some((e=>{const t=e.alterRowOffset||0,r=e.alterColumnOffset||0;return e.destinationRow+t>=this.hot.countRows()||e.destinationColumn+r>=this.hot.countCols()}))||(this.cellsToSetCache=[],(0,o.arrayEach)(e,(e=>{this.resetEndpointValue(e,t)})),this.hot.setDataAtCell(this.cellsToSetCache,"ColumnSummary.reset"),this.cellsToSetCache=[])}refreshAllEndpoints(){this.cellsToSetCache=[],(0,o.arrayEach)(this.getAllEndpoints(),(e=>{this.currentEndpoint=e,this.plugin.calculate(e),this.setEndpointValue(e,"init")})),this.currentEndpoint=null,this.hot.setDataAtCell(this.cellsToSetCache,"ColumnSummary.reset"),this.cellsToSetCache=[]}refreshChangedEndpoints(e){const t=[];this.cellsToSetCache=[],(0,o.arrayEach)(e,((e,r,n)=>{`${e[2]||""}`!=`${e[3]}`&&(0,o.arrayEach)(this.getAllEndpoints(),((e,s)=>{this.hot.propToCol(n[r][1])===e.sourceColumn&&-1===t.indexOf(s)&&t.push(s)}))})),(0,o.arrayEach)(t,(e=>{this.refreshEndpoint(this.getEndpoint(e))})),this.hot.setDataAtCell(this.cellsToSetCache,"ColumnSummary.reset"),this.cellsToSetCache=[]}refreshEndpoint(e){this.currentEndpoint=e,this.plugin.calculate(e),this.setEndpointValue(e),this.currentEndpoint=null}resetEndpointValue(e){let t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];const r=e.alterRowOffset||0,n=e.alterColumnOffset||0;this.cellsToSetCache.push([this.hot.toVisualRow(e.destinationRow+(t?r:0)),this.hot.toVisualColumn(e.destinationColumn+(t?n:0)),""])}setEndpointValue(e,t){let r=arguments.length>2&&void 0!==arguments[2]&&arguments[2];const n=this.hot.toVisualRow(e.destinationRow);if(e.destinationRow>=this.hot.countRows()||e.destinationColumn>=this.hot.countCols())return void this.throwOutOfBoundsWarning();const s=this.hot.toVisualRow(e.destinationRow);if(null!==s){const r=this.hot.getCellMeta(s,e.destinationColumn);"init"!==t&&r.readOnly===e.readOnly||(r.readOnly=e.readOnly,r.className="columnSummaryResult")}if((!0===e.roundFloat||Number.isInteger(e.roundFloat))&&!isNaN(e.result)){const t=e.roundFloat;let r=0;Number.isInteger(t)&&(r=Math.min(Math.max(0,t),100)),e.result=e.result.toFixed(r)}r?this.hot.setDataAtCell(n,e.destinationColumn,e.result,"ColumnSummary.set"):this.cellsToSetCache.push([n,e.destinationColumn,e.result]),e.alterRowOffset=void 0,e.alterColumnOffset=void 0}throwOutOfBoundsWarning(){(0,i.warn)("One of the Column Summary plugins' destination points you provided is beyond the table boundaries!")}}},48695:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(4885);t.PLUGIN_KEY=n.PLUGIN_KEY,t.PLUGIN_PRIORITY=n.PLUGIN_PRIORITY,t.ColumnSummary=n.ColumnSummary},68674:(e,t)=>{"use strict";t.__esModule=!0,t.isNullishOrNaN=function(e){return null==e||isNaN(e)}},55181:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),o=r(49536);class i{static get CLASS_EDITOR_CONTAINER(){return"htCommentsContainer"}static get CLASS_EDITOR(){return"htComments"}static get CLASS_INPUT(){return"htCommentTextArea"}static get CLASS_CELL(){return"htCommentCell"}constructor(e,t){(0,s.default)(this,"rootDocument",void 0),(0,s.default)(this,"isRtl",!1),(0,s.default)(this,"container",null),(0,s.default)(this,"editor",void 0),(0,s.default)(this,"editorStyle",void 0),(0,s.default)(this,"hidden",!0),this.rootDocument=e,this.isRtl=t,this.editor=this.createEditor(),this.editorStyle=this.editor.style,this.hide()}setPosition(e,t){this.editorStyle.left=`${e}px`,this.editorStyle.top=`${t}px`}setSize(e,t){if(e&&t){const r=this.getInputElement();r.style.width=`${e}px`,r.style.height=`${t}px`}}getSize(){return{width:(0,o.outerWidth)(this.getInputElement()),height:(0,o.outerHeight)(this.getInputElement())}}resetSize(){const e=this.getInputElement();e.style.width="",e.style.height=""}setReadOnlyState(e){this.getInputElement().readOnly=e}show(){this.editorStyle.display="block",this.hidden=!1}hide(){this.hidden||(this.editorStyle.display="none"),this.hidden=!0}isVisible(){return"block"===this.editorStyle.display}setValue(){const e=(arguments.length>0&&void 0!==arguments[0]?arguments[0]:"")||"";this.getInputElement().value=e}getValue(){return this.getInputElement().value}isFocused(){return this.rootDocument.activeElement===this.getInputElement()}focus(){this.getInputElement().focus()}createEditor(){const e=this.rootDocument.createElement("div"),t=this.rootDocument.createElement("textarea");return e.style.display="none",this.container=this.rootDocument.createElement("div"),this.container.setAttribute("dir",this.isRtl?"rtl":"ltr"),(0,o.addClass)(this.container,i.CLASS_EDITOR_CONTAINER),this.rootDocument.body.appendChild(this.container),(0,o.addClass)(e,i.CLASS_EDITOR),(0,o.addClass)(t,i.CLASS_INPUT),t.setAttribute("data-hot-input",!0),e.appendChild(t),this.container.appendChild(e),e}getInputElement(){return this.editor.querySelector(`.${i.CLASS_INPUT}`)}destroy(){const e=this.container?this.container.parentNode:null;this.editor.parentNode.removeChild(this.editor),this.editor=null,this.editorStyle=null,e&&e.removeChild(this.container)}}t.default=i},3387:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724);var s=n(r(85707)),o=r(49536),i=r(24456),a=r(58460),l=r(55006),h=n(r(55181)),u=n(r(29395)),c=r(35944),d=n(r(82721)),p=n(r(92792)),g=n(r(61690));function f(e,t,r){m(e,t),t.set(e,r)}function m(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function E(e,t,r){return e.set(w(e,t),r),r}function y(e,t){return e.get(w(e,t))}function w(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}r(19501);const C=t.PLUGIN_KEY="comments",R=t.PLUGIN_PRIORITY=60,v=t.META_COMMENT="comment",S=t.META_COMMENT_VALUE="value",T=t.META_STYLE="style",N=t.META_READONLY="readOnly",_=C,M=`plugin:${C}`;var A=new WeakMap,b=new WeakMap,I=new WeakMap,O=new WeakMap,x=new WeakMap,P=new WeakMap,L=new WeakMap,D=new WeakSet;class k extends l.BasePlugin{constructor(){var e,t;super(...arguments),m(e=this,t=D),t.add(e),(0,s.default)(this,"range",{}),f(this,A,null),f(this,b,null),f(this,I,!1),f(this,O,!1),f(this,x,{}),f(this,P,null),f(this,L,"")}static get PLUGIN_KEY(){return C}static get PLUGIN_PRIORITY(){return R}isEnabled(){return!!this.hot.getSettings()[C]}enablePlugin(){this.enabled||(y(A,this)||E(A,this,new h.default(this.hot.rootDocument,this.hot.isRtl())),y(b,this)||E(b,this,new u.default(this.getDisplayDelaySetting())),this.addHook("afterContextMenuDefaultOptions",(e=>this.addToContextMenu(e))),this.addHook("afterRenderer",((e,t,r,n,s,o)=>w(D,this,V).call(this,e,o))),this.addHook("afterScroll",(()=>w(D,this,z).call(this))),this.addHook("afterBeginEditing",(()=>this.hide())),this.addHook("afterDocumentKeyDown",(e=>w(D,this,G).call(this,e))),y(b,this).addLocalHook("hide",(()=>this.hide())),y(b,this).addLocalHook("show",((e,t)=>this.showAtCell(e,t))),this.registerShortcuts(),this.registerListeners(),super.enablePlugin())}updatePlugin(){y(b,this).updateDelay(this.getDisplayDelaySetting()),super.updatePlugin()}disablePlugin(){this.unregisterShortcuts(),super.disablePlugin()}registerShortcuts(){const e=this.hot.getShortcutManager(),t=e.getContext("grid"),r=e.addContext(M);t.addShortcut({keys:[["Control","Alt","M"]],callback:()=>{const t=this.hot.getSelectedRangeLast();E(O,this,!0),this.hot.scrollToFocusedCell((()=>{this.setRange(t),this.show(),this.focusEditor(),e.setActiveContextName(M),this.hot._registerTimeout((()=>{E(O,this,!1)}))}))},stopPropagation:!0,runOnlyIf:()=>{var e;return(null===(e=this.hot.getSelectedRangeLast())||void 0===e?void 0:e.highlight.isCell())&&!y(A,this).isVisible()},group:_}),r.addShortcut({keys:[["Escape"]],callback:()=>{y(A,this).setValue(y(L,this)),this.hide(),e.setActiveContextName("grid")},runOnlyIf:()=>{var e;return(null===(e=this.hot.getSelectedRangeLast())||void 0===e?void 0:e.highlight.isCell())&&y(A,this).isVisible()},group:_}),r.addShortcut({keys:[["Control/Meta","Enter"]],callback:()=>{this.hide(),e.setActiveContextName("grid")},runOnlyIf:()=>{var e;return(null===(e=this.hot.getSelectedRangeLast())||void 0===e?void 0:e.highlight.isCell())&&y(A,this).isVisible()},group:_})}unregisterShortcuts(){this.hot.getShortcutManager().getContext("grid").removeShortcutsByGroup(_)}registerListeners(){const{rootDocument:e}=this.hot,t=this.getEditorInputElement();this.eventManager.addEventListener(e,"mouseover",(e=>w(D,this,F).call(this,e))),this.eventManager.addEventListener(e,"mousedown",(e=>w(D,this,H).call(this,e))),this.eventManager.addEventListener(e,"mouseup",(()=>w(D,this,U).call(this))),this.eventManager.addEventListener(t,"focus",(()=>w(D,this,W).call(this))),this.eventManager.addEventListener(t,"blur",(()=>w(D,this,B).call(this))),this.eventManager.addEventListener(t,"mousedown",(e=>w(D,this,Y).call(this,e))),this.eventManager.addEventListener(t,"mouseup",(e=>w(D,this,j).call(this,e)))}setRange(e){this.range=e}clearRange(){this.range={}}targetIsCellWithComment(e){const t=(0,o.closest)(e.target,"TD","TBODY");return!!(t&&(0,o.hasClass)(t,"htCommentCell")&&(0,o.closest)(t,[this.hot.rootElement]))}targetIsCommentTextArea(e){return this.getEditorInputElement()===e.target}setComment(e){if(!this.range.from)throw new Error('Before using this method, first set cell range (hot.getPlugin("comment").setRange())');const t=y(A,this).getValue();let r="";null!=e?r=e:null!=t&&(r=t);const n=this.range.from.row,s=this.range.from.col;this.updateCommentMeta(n,s,{[S]:r}),this.hot.render()}setCommentAtCell(e,t,r){this.setRange({from:this.hot._createCellCoords(e,t)}),this.setComment(r)}removeComment(){let e=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];if(!this.range.from)throw new Error('Before using this method, first set cell range (hot.getPlugin("comment").setRange())');this.hot.setCellMeta(this.range.from.row,this.range.from.col,v),e&&this.hot.render(),this.hide()}removeCommentAtCell(e,t){let r=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];this.setRange({from:this.hot._createCellCoords(e,t)}),this.removeComment(r)}getComment(){const e=this.range.from.row,t=this.range.from.col;return this.getCommentMeta(e,t,S)}getCommentAtCell(e,t){return this.getCommentMeta(e,t,S)}show(){var e;if(!this.range.from)throw new Error('Before using this method, first set cell range (hot.getPlugin("comment").setRange())');const{from:{row:t,col:r}}=this.range;if(t<0||t>this.hot.countSourceRows()-1||r<0||r>this.hot.countSourceCols()-1)return!1;const n=this.hot.getCellMeta(this.range.from.row,this.range.from.col);return y(b,this).cancelHiding(),y(A,this).setValue(null!==(e=n[v]?n[v][S]:null)&&void 0!==e?e:""),y(A,this).show(),this.refreshEditor(!0),!0}showAtCell(e,t){return this.setRange({from:this.hot._createCellCoords(e,t)}),this.show()}hide(){y(A,this).hide()}refreshEditor(){var e,t;if(!(arguments.length>0&&void 0!==arguments[0]&&arguments[0]||this.range.from&&y(A,this).isVisible()))return;const{rowIndexMapper:r,columnIndexMapper:n}=this.hot,{row:s,col:i}=this.range.from;let a=r.getRenderableFromVisualIndex(s),l=n.getRenderableFromVisualIndex(i);const h=null===a;y(A,this).setPosition(0,0),null===a&&(a=r.getRenderableFromVisualIndex(r.getNearestNotHiddenIndex(s,-1))),null===l&&(l=n.getRenderableFromVisualIndex(n.getNearestNotHiddenIndex(i,-1)));const u=null===a,c=null===l;a=null!==(e=a)&&void 0!==e?e:0,l=null!==(t=l)&&void 0!==t?t:0;const{rootWindow:d,view:{_wt:p}}=this.hot,{wtTable:g}=p,f=p.getCell({row:a,col:l},!0),m=this.getCommentMeta(s,i,T);m?y(A,this).setSize(m.width,m.height):y(A,this).resetSize();const E=c?0:g.getStretchedColumnWidth(l),w=h&&!u?(0,o.outerHeight)(f):0,{left:C,top:R,width:v,height:S}=f.getBoundingClientRect(),{width:_,height:M}=y(A,this).getSize(),{innerWidth:b,innerHeight:I}=this.hot.rootWindow,O=this.hot.rootDocument.documentElement;let x=C+d.scrollX+E,P=R+d.scrollY+w;this.hot.isRtl()&&(x-=_+E),this.hot.isLtr()&&C+v+_>b?x=C+d.scrollX-_-1:this.hot.isRtl()&&x<-(O.scrollWidth-O.clientWidth)&&(x=C+d.scrollX+E+1),R+M>I&&(P-=M-S+1),y(A,this).setPosition(x,P),y(A,this).setReadOnlyState(this.getCommentMeta(s,i,N))}focusEditor(){y(A,this).focus()}updateCommentMeta(e,t,r){const n=this.hot.getCellMeta(e,t)[v];let s;n?(s=(0,a.deepClone)(n),(0,a.deepExtend)(s,r)):s=r,this.hot.setCellMeta(e,t,v,s)}getCommentMeta(e,t,r){const n=this.hot.getCellMeta(e,t);if(n[v])return n[v][r]}addToContextMenu(e){e.items.push({name:c.SEPARATOR},(0,d.default)(this),(0,p.default)(this),(0,g.default)(this))}getDisplayDelaySetting(){const e=this.hot.getSettings()[C];if((0,a.isObject)(e))return e.displayDelay}getEditorInputElement(){return y(A,this).getInputElement()}destroy(){y(A,this)&&y(A,this).destroy(),y(b,this)&&y(b,this).destroy(),super.destroy()}}function H(e){if(this.hot.view&&this.hot.view._wt&&!y(I,this)&&!this.targetIsCommentTextArea(e)){const t=(0,o.closest)(e.target,"TD","TBODY");let r=null;t&&(r=this.hot.getCoords(t)),(!t||this.range.from&&r&&(this.range.from.row!==r.row||this.range.from.col!==r.col))&&this.hide()}}function F(e){const{rootDocument:t}=this.hot;if(!(y(I,this)||y(A,this).isFocused()||(0,o.hasClass)(e.target,"wtBorder")||y(P,this)===e.target)&&y(A,this))if(E(P,this,t.elementFromPoint(e.clientX,e.clientY)),this.targetIsCellWithComment(e)){const t=this.hot._createCellRange(this.hot.getCoords(e.target));y(b,this).show(t)}else(0,o.isChildOf)(e.target,t)&&!this.targetIsCommentTextArea(e)&&y(b,this).hide()}function U(){E(I,this,!1)}function V(e,t){t[v]&&t[v][S]&&(0,o.addClass)(e,t.commentedCellClassName)}function B(){E(L,this,""),this.hot.getShortcutManager().setActiveContextName("grid"),this.setComment()}function W(){E(L,this,this.getComment()),this.hot.listen(),this.hot.getShortcutManager().setActiveContextName(M)}function Y(e){E(x,this,{width:(0,o.outerWidth)(e.target),height:(0,o.outerHeight)(e.target)})}function j(e){const t=(0,o.outerWidth)(e.target),r=(0,o.outerHeight)(e.target);t===y(x,this).width+1&&r===y(x,this).height+2||this.updateCommentMeta(this.range.from.row,this.range.from.col,{[T]:{width:t,height:r}})}function G(e){y(A,this).isVisible()&&(0,i.stopImmediatePropagation)(e)}function z(){y(O,this)||this.hide()}t.Comments=k},82721:(e,t,r)=>{"use strict";t.__esModule=!0,t.default=function(e){return{key:"commentsAddEdit",name(){var t;const r=null===(t=this.getSelectedRangeLast())||void 0===t?void 0:t.highlight;return null!=r&&r.isCell()&&e.getCommentAtCell(r.row,r.col)?this.getTranslatedPhrase(n.CONTEXTMENU_ITEMS_EDIT_COMMENT):this.getTranslatedPhrase(n.CONTEXTMENU_ITEMS_ADD_COMMENT)},callback(){const t=this.getSelectedRangeLast();this.deselectCell(),e.setRange(t),e.show(),e.focusEditor()},disabled(){const e=this.getSelectedRangeLast();return!!(!e||e.highlight.isHeader()||this.selection.isEntireRowSelected()&&this.selection.isEntireColumnSelected()||0===this.countRenderedRows()||0===this.countRenderedCols())}}};var n=function(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var r=s(t);if(r&&r.has(e))return r.get(e);var n={__proto__:null},o=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var i in e)if("default"!==i&&{}.hasOwnProperty.call(e,i)){var a=o?Object.getOwnPropertyDescriptor(e,i):null;a&&(a.get||a.set)?Object.defineProperty(n,i,a):n[i]=e[i]}return n.default=e,r&&r.set(e,n),n}(r(63751));function s(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,r=new WeakMap;return(s=function(e){return e?r:t})(e)}},61690:(e,t,r)=>{"use strict";t.__esModule=!0,t.default=function(e){return{key:"commentsReadOnly",name(){const t=this.getTranslatedPhrase(n.CONTEXTMENU_ITEMS_READ_ONLY_COMMENT);return(0,s.checkSelectionConsistency)(this.getSelectedRange(),((t,r)=>e.getCommentMeta(t,r,o.META_READONLY)))?(0,s.markLabelAsSelected)(t):t},callback(){this.getSelectedRangeLast().forAll(((t,r)=>{if(t>=0&&r>=0){const n=!!e.getCommentMeta(t,r,o.META_READONLY);e.updateCommentMeta(t,r,{[o.META_READONLY]:!n})}}))},disabled(){const t=this.getSelectedRangeLast();return!!(!t||t.highlight.isHeader()||!e.getCommentAtCell(t.highlight.row,t.highlight.col)||this.selection.isEntireRowSelected()&&this.selection.isEntireColumnSelected()||0===this.countRenderedRows()||0===this.countRenderedCols())}}};var n=function(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var r=i(t);if(r&&r.has(e))return r.get(e);var n={__proto__:null},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&{}.hasOwnProperty.call(e,o)){var a=s?Object.getOwnPropertyDescriptor(e,o):null;a&&(a.get||a.set)?Object.defineProperty(n,o,a):n[o]=e[o]}return n.default=e,r&&r.set(e,n),n}(r(63751)),s=r(69988),o=r(3387);function i(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,r=new WeakMap;return(i=function(e){return e?r:t})(e)}},92792:(e,t,r)=>{"use strict";t.__esModule=!0,t.default=function(e){return{key:"commentsRemove",name(){return this.getTranslatedPhrase(n.CONTEXTMENU_ITEMS_REMOVE_COMMENT)},callback(){this.getSelectedRangeLast().forAll(((t,r)=>{t>=0&&r>=0&&e.removeCommentAtCell(t,r,!1)})),this.render()},disabled(){const e=this.getSelectedRangeLast();return!!(!e||e.highlight.isHeader()||this.selection.isEntireRowSelected()&&this.selection.isEntireColumnSelected()||0===this.countRenderedRows()||0===this.countRenderedCols())}}};var n=function(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var r=s(t);if(r&&r.has(e))return r.get(e);var n={__proto__:null},o=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var i in e)if("default"!==i&&{}.hasOwnProperty.call(e,i)){var a=o?Object.getOwnPropertyDescriptor(e,i):null;a&&(a.get||a.set)?Object.defineProperty(n,i,a):n[i]=e[i]}return n.default=e,r&&r.set(e,n),n}(r(63751));function s(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,r=new WeakMap;return(s=function(e){return e?r:t})(e)}},29395:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),o=r(25735),i=r(58460),a=n(r(48499));class l{constructor(e){(0,s.default)(this,"wasLastActionShow",!0),(0,s.default)(this,"showDebounced",null),(0,s.default)(this,"hidingTimer",null),this.updateDelay(e)}hide(){this.wasLastActionShow=!1,this.hidingTimer=setTimeout((()=>{!1===this.wasLastActionShow&&this.runLocalHooks("hide")}),250)}show(e){this.wasLastActionShow=!0,this.showDebounced(e)}cancelHiding(){this.wasLastActionShow=!0,clearTimeout(this.hidingTimer),this.hidingTimer=null}updateDelay(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:250;this.showDebounced=(0,o.debounce)((e=>{this.wasLastActionShow&&this.runLocalHooks("show",e.from.row,e.from.col)}),e)}destroy(){this.clearLocalHooks()}}(0,i.mixin)(l,a.default);t.default=l},63121:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(3387);t.PLUGIN_KEY=n.PLUGIN_KEY,t.PLUGIN_PRIORITY=n.PLUGIN_PRIORITY,t.Comments=n.Comments},13097:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724),r(54999);var s=n(r(85707)),o=r(98758),i=r(58460);t.CommandExecutor=class{constructor(e){(0,s.default)(this,"hot",void 0),(0,s.default)(this,"commands",{}),(0,s.default)(this,"commonCallback",null),this.hot=e}registerCommand(e,t){this.commands[e]=t}setCommonCallback(e){this.commonCallback=e}execute(e){for(var t=arguments.length,r=new Array(t>1?t-1:0),n=1;n<t;n++)r[n-1]=arguments[n];const s=e.split(":"),a=s[0],l=2===s.length?s[1]:null;let h=this.commands[a];if(!h)throw new Error(`Menu command '${a}' not exists.`);if(l&&h.submenu&&(h=function(e,t){let r;return(0,o.arrayEach)(t,(t=>{const n=t.key?t.key.split(":"):null;if(Array.isArray(n)&&n[1]===e)return r=t,!1})),r}(l,h.submenu.items)),!0===h.disabled)return;if("function"==typeof h.disabled&&!0===h.disabled.call(this.hot))return;if((0,i.hasOwnProperty)(h,"submenu"))return;const u=[];"function"==typeof h.callback&&u.push(h.callback),"function"==typeof this.commonCallback&&u.push(this.commonCallback),r.unshift(s.join(":")),(0,o.arrayEach)(u,(e=>e.apply(this.hot,r)))}}},70509:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),o=r(55006),i=n(r(37056)),a=r(98758),l=r(58460),h=r(13097),u=r(21847),c=r(52381),d=r(69988),p=r(49536),g=r(35944);function f(e,t){!function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}(e,t),t.add(e)}function m(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}r(21151);const E=t.PLUGIN_KEY="contextMenu",y=t.PLUGIN_PRIORITY=70,w=E;i.default.getSingleton().register("afterContextMenuDefaultOptions"),i.default.getSingleton().register("beforeContextMenuShow"),i.default.getSingleton().register("afterContextMenuShow"),i.default.getSingleton().register("afterContextMenuHide"),i.default.getSingleton().register("afterContextMenuExecute");var C=new WeakSet;class R extends o.BasePlugin{constructor(){super(...arguments),f(this,C),(0,s.default)(this,"commandExecutor",new h.CommandExecutor(this.hot)),(0,s.default)(this,"itemsFactory",null),(0,s.default)(this,"menu",null)}static get PLUGIN_KEY(){return E}static get PLUGIN_PRIORITY(){return y}static get PLUGIN_DEPS(){return["plugin:AutoColumnSize"]}static get DEFAULT_ITEMS(){return[g.ROW_ABOVE,g.ROW_BELOW,g.SEPARATOR,g.COLUMN_LEFT,g.COLUMN_RIGHT,g.SEPARATOR,g.REMOVE_ROW,g.REMOVE_COLUMN,g.SEPARATOR,g.UNDO,g.REDO,g.SEPARATOR,g.READ_ONLY,g.SEPARATOR,g.ALIGNMENT]}isEnabled(){return!!this.hot.getSettings()[E]}enablePlugin(){var e=this;if(this.enabled)return;const t=this.hot.getSettings()[E];"function"==typeof t.callback&&this.commandExecutor.setCommonCallback(t.callback),this.menu=new c.Menu(this.hot,{className:"htContextMenu",keepInViewport:!0,container:t.uiContainer||this.hot.rootDocument.body}),this.menu.addLocalHook("beforeOpen",(()=>m(C,this,S).call(this))),this.menu.addLocalHook("afterOpen",(()=>m(C,this,T).call(this))),this.menu.addLocalHook("afterClose",(()=>m(C,this,N).call(this))),this.menu.addLocalHook("executeCommand",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return e.executeCommand.call(e,...r)})),this.addHook("afterOnCellContextMenu",(e=>m(C,this,v).call(this,e))),this.registerShortcuts(),super.enablePlugin()}updatePlugin(){this.disablePlugin(),this.enablePlugin(),super.updatePlugin()}disablePlugin(){this.close(),this.menu&&(this.menu.destroy(),this.menu=null),this.unregisterShortcuts(),super.disablePlugin()}registerShortcuts(){this.hot.getShortcutManager().getContext("grid").addShortcut({keys:[["Control/Meta","Shift","Backslash"],["Shift","F10"]],callback:()=>{const{highlight:e}=this.hot.getSelectedRangeLast();this.hot.scrollToFocusedCell();const t=this.hot.getCell(e.row,e.col,!0).getBoundingClientRect(),r=(0,d.getDocumentOffsetByElement)(this.menu.container,this.hot.rootDocument);this.open({left:t.left+r.left,top:t.top+r.top-1+t.height},{left:t.width,above:-t.height}),this.menu.getNavigator().toFirstItem()},runOnlyIf:()=>{var e;const t=null===(e=this.hot.getSelectedRangeLast())||void 0===e?void 0:e.highlight;return t&&this.hot.selection.isCellVisible(t)&&!this.menu.isOpened()},group:w})}unregisterShortcuts(){this.hot.getShortcutManager().getContext("grid").removeShortcutsByGroup(w)}open(e){var t;let r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{above:0,below:0,left:0,right:0};null!==(t=this.menu)&&void 0!==t&&t.isOpened()||(this.prepareMenuItems(),this.menu.open(),(0,l.objectEach)(r,((e,t)=>{this.menu.setOffset(t,e)})),this.menu.setPosition(e))}close(){var e;null===(e=this.menu)||void 0===e||e.close(),this.itemsFactory=null}executeCommand(e){null===this.itemsFactory&&this.prepareMenuItems();for(var t=arguments.length,r=new Array(t>1?t-1:0),n=1;n<t;n++)r[n-1]=arguments[n];this.commandExecutor.execute(e,...r)}prepareMenuItems(){this.itemsFactory=new u.ItemsFactory(this.hot,R.DEFAULT_ITEMS);const e=this.hot.getSettings()[E],t={items:this.itemsFactory.getItems(e)};this.hot.runHooks("afterContextMenuDefaultOptions",t),this.itemsFactory.setPredefinedItems(t.items);const r=this.itemsFactory.getItems(e);this.hot.runHooks("beforeContextMenuSetItems",r),this.menu.setMenuItems(r),(0,a.arrayEach)(r,(e=>this.commandExecutor.registerCommand(e.key,e)))}destroy(){this.close(),this.menu&&this.menu.destroy(),super.destroy()}}function v(e){const t=this.hot.getSettings(),r=t.rowHeaders,n=t.colHeaders;const s=e.target;if(this.close(),(0,p.hasClass)(s,"handsontableInput"))return;if(e.preventDefault(),e.stopPropagation(),!r&&!n&&!(function(e){return"TD"===e.nodeName||"TD"===e.parentNode.nodeName}(s)||(0,p.hasClass)(s,"current")&&(0,p.hasClass)(s,"wtBorder")))return;const o=(0,d.getDocumentOffsetByElement)(this.menu.container,this.hot.rootDocument);this.open({top:e.clientY+o.top,left:e.clientX+o.left})}function S(){this.hot.runHooks("beforeContextMenuShow",this)}function T(){this.hot.runHooks("afterContextMenuShow",this)}function N(){this.hot.listen(),this.hot.runHooks("afterContextMenuHide",this)}t.ContextMenu=R,R.SEPARATOR={name:g.SEPARATOR}},5737:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(70509);t.PLUGIN_KEY=n.PLUGIN_KEY,t.PLUGIN_PRIORITY=n.PLUGIN_PRIORITY,t.ContextMenu=n.ContextMenu},21847:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724);var s=n(r(85707)),o=r(58460),i=r(98758),a=r(35944);t.ItemsFactory=class{constructor(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;(0,s.default)(this,"hot",void 0),(0,s.default)(this,"predefinedItems",(0,a.predefinedItems)()),(0,s.default)(this,"defaultOrderPattern",void 0),this.hot=e,this.defaultOrderPattern=t}setPredefinedItems(e){const t={};this.defaultOrderPattern.length=0,(0,o.objectEach)(e,((e,r)=>{let n="";e.name===a.SEPARATOR?(t[a.SEPARATOR]=e,n=a.SEPARATOR):isNaN(parseInt(r,10))?(e.key=void 0===e.key?r:e.key,t[r]=e,n=e.key):(t[e.key]=e,n=e.key),this.defaultOrderPattern.push(n)})),this.predefinedItems=t}getItems(){return function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const n=[];let s=e;s&&s.items?s=s.items:Array.isArray(s)||(s=t);(0,o.isObject)(s)?(0,o.objectEach)(s,((e,t)=>{let s=r["string"==typeof e?e:t];s||(s=e),(0,o.isObject)(e)?(0,o.extend)(s,e):"string"==typeof s&&(s={name:s}),void 0===s.key&&(s.key=t),n.push(s)})):(0,i.arrayEach)(s,((e,t)=>{let s=r[e];!s&&a.ITEMS.indexOf(e)>=0||(s||(s={name:e,key:`${t}`}),(0,o.isObject)(e)&&(0,o.extend)(s,e),void 0===s.key&&(s.key=t),n.push(s))}));return n}(arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,this.defaultOrderPattern,this.predefinedItems)}}},32139:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.Cursor=class{constructor(e,t){(0,s.default)(this,"top",void 0),(0,s.default)(this,"topRelative",void 0),(0,s.default)(this,"left",void 0),(0,s.default)(this,"leftRelative",void 0),(0,s.default)(this,"scrollTop",void 0),(0,s.default)(this,"scrollLeft",void 0),(0,s.default)(this,"cellHeight",void 0),(0,s.default)(this,"cellWidth",void 0);const r=t.scrollY,n=t.scrollX;let o,i,a,l,h,u;this.rootWindow=t,this.type=this.getSourceType(e),"literal"===this.type?(o=parseInt(e.top,10),a=parseInt(e.left,10),h=e.height||0,u=e.width||0,i=o,l=a,o+=r,a+=n):"event"===this.type&&(o=parseInt(e.pageY,10),a=parseInt(e.pageX,10),h=e.target.clientHeight,u=e.target.clientWidth,i=o-r,l=a-n),this.top=o,this.topRelative=i,this.left=a,this.leftRelative=l,this.scrollTop=r,this.scrollLeft=n,this.cellHeight=h,this.cellWidth=u}getSourceType(e){let t="literal";return e instanceof Event&&(t="event"),t}fitsAbove(e){return this.topRelative>=e.offsetHeight}fitsBelow(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.rootWindow.innerHeight;return this.topRelative+e.offsetHeight<=t}fitsOnRight(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.rootWindow.innerWidth;return this.leftRelative+this.cellWidth+e.offsetWidth<=t}fitsOnLeft(e){return this.leftRelative>=e.offsetWidth}}},42093:(e,t)=>{"use strict";t.__esModule=!0,t.createDefaultShortcutsList=function(e){const{hot:t,hotMenu:r}=e;return[{keys:[["Control/Meta","A"]],forwardToContext:t.getShortcutManager().getContext("grid"),callback:()=>e.close(!0)},{keys:[["Tab"],["Shift","Tab"]],callback:(r,n)=>{const s=t.getSettings(),o="function"==typeof s.tabMoves?s.tabMoves(r):s.tabMoves;n.includes("shift")?t.selection.transformStart(-o.row,-o.col):t.selection.transformStart(o.row,o.col),e.close(!0)}},{keys:[["Escape"]],callback:()=>e.close()},{keys:[["ArrowDown"]],callback:()=>e.getNavigator().toNextItem()},{keys:[["ArrowUp"]],callback:()=>e.getNavigator().toPreviousItem()},{keys:[["ArrowRight"]],callback:()=>{const t=r.getSelectedLast();if(t){const r=e.openSubMenu(t[0]);r&&r.getNavigator().toFirstItem()}}},{keys:[["ArrowLeft"]],callback:()=>{r.getSelectedLast()&&e.isSubMenu()&&(e.close(),e.isSubMenu()&&e.parentMenu.hotMenu.listen())}},{keys:[["Control/Meta","ArrowUp"],["Home"]],callback:()=>e.getNavigator().toFirstItem()},{keys:[["Control/Meta","ArrowDown"],["End"]],callback:()=>e.getNavigator().toLastItem()},{keys:[["Enter"],["Space"]],callback:t=>{const n=r.getSelectedLast();n&&(r.getSourceDataAtRow(n[0]).submenu?e.openSubMenu(n[0]).getNavigator().toFirstItem():(e.executeCommand(t),e.close(!0)))}},{keys:[["PageUp"]],callback:()=>{r.getSelectedLast()?r.selection.transformStart(-r.countVisibleRows(),0):e.getNavigator().toFirstItem()}},{keys:[["PageDown"]],callback:()=>{r.getSelectedLast()?r.selection.transformStart(r.countVisibleRows(),0):e.getNavigator().toLastItem()}}]}},52381:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(4674);Object.keys(n).forEach((function(e){"default"!==e&&"__esModule"!==e&&(e in t&&t[e]===n[e]||(t[e]=n[e]))}))},4674:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724);var s=n(r(85707)),o=r(50165),i=r(16652),a=r(61642),l=r(35944),h=r(76968),u=n(r(63286)),c=r(98758),d=r(1479),p=r(49536),g=r(24456),f=r(25735),m=r(67508),E=r(58460),y=n(r(48499)),w=r(31130),C=r(81595);function R(e,t,r){!function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}(e,t),t.set(e,r)}function v(e,t,r){return e.set(T(e,t),r),r}function S(e,t){return e.get(T(e,t))}function T(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var N=new WeakMap,_=new WeakMap;class M{constructor(e,t){var r=this;(0,s.default)(this,"hot",void 0),(0,s.default)(this,"options",void 0),(0,s.default)(this,"eventManager",new u.default(this)),(0,s.default)(this,"container",void 0),(0,s.default)(this,"positioner",void 0),(0,s.default)(this,"hotMenu",null),(0,s.default)(this,"hotSubMenus",{}),(0,s.default)(this,"parentMenu",void 0),(0,s.default)(this,"menuItems",null),(0,s.default)(this,"origOutsideClickDeselects",null),R(this,N,void 0),R(this,_,void 0),this.hot=e,this.options=t||{parent:null,name:null,className:"",keepInViewport:!0,standalone:!1,minWidth:215,container:this.hot.rootDocument.documentElement},this.container=this.createContainer(this.options.name),this.positioner=new o.Positioner(this.options.keepInViewport),this.parentMenu=this.options.parent||null,this.registerEvents(),this.isSubMenu()&&this.addLocalHook("afterSelectionChange",(function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return r.parentMenu.runLocalHooks("afterSelectionChange",...t)}))}registerEvents(){let e=this.hot.rootWindow;for(;e;)this.eventManager.addEventListener(e.document,"mousedown",(e=>this.onDocumentMouseDown(e))),this.eventManager.addEventListener(e.document,"contextmenu",(e=>this.onDocumentContextMenu(e))),e=(0,p.getParentWindow)(e)}setMenuItems(e){this.menuItems=e}getNavigator(){return S(N,this)}getKeyboardShortcutsCtrl(){return S(_,this)}getSelectedItem(){return this.hasSelectedItem()?this.hotMenu.getSourceDataAtRow(this.hotMenu.getSelectedLast()[0]):null}hasSelectedItem(){return Array.isArray(this.hotMenu.getSelectedLast())}isSubMenu(){return null!==this.parentMenu}open(){this.runLocalHooks("beforeOpen"),this.container.removeAttribute("style"),this.container.style.display="block";const e=(0,f.debounce)((e=>this.openSubMenu(e)),300),t=this.options.minWidth||215;let r=!1,n=(0,c.arrayFilter)(this.menuItems,(e=>(e.key===l.NO_ITEMS&&(r=!0),(0,h.isItemHidden)(e,this.hot))));if(n.length<1&&!r)n.push((0,l.predefinedItems)()[l.NO_ITEMS]);else if(0===n.length)return;n=(0,h.filterSeparators)(n,l.SEPARATOR);let s=!1;const o={data:n,colHeaders:!1,autoColumnSize:!0,autoWrapRow:!1,modifyColWidth:e=>(0,m.isDefined)(e)&&e<t?t:e,autoRowSize:!1,readOnly:!0,editor:!1,copyPaste:!1,hiddenRows:!0,maxCols:1,columns:[{data:"name",renderer:(0,w.createMenuItemRenderer)(this.hot)}],renderAllRows:!0,fragmentSelection:!1,outsideClickDeselects:!1,disableVisualSelection:"area",layoutDirection:this.hot.isRtl()?"rtl":"ltr",ariaTags:!1,beforeOnCellMouseOver:(e,t)=>{S(N,this).setCurrentPage(t.row)},afterOnCellMouseOver:(t,r)=>{this.isAllSubMenusClosed()?e(r.row):this.openSubMenu(r.row)},rowHeights:e=>n[e].name===l.SEPARATOR?1:23,afterOnCellContextMenu:e=>{e.preventDefault(),(0,d.isWindowsOS)()&&s&&this.hasSelectedItem()&&this.close(!0)},afterSelection:(e,t,r,n,s)=>{this.hotMenu.view.isMouseDown()&&(s.value=!0),this.runLocalHooks("afterSelectionChange",this.getSelectedItem())},beforeOnCellMouseUp:e=>{this.hasSelectedItem()&&(s=!this.isCommandPassive(this.getSelectedItem()),this.executeCommand(e))},afterOnCellMouseUp:e=>{(0,d.isWindowsOS)()&&(0,g.isRightClick)(e)||!s||!this.hasSelectedItem()||((0,d.isMobileBrowser)()||(0,d.isIpadOS)()?this.hot._registerTimeout((()=>this.close(!0)),325):this.close(!0))},afterUnlisten:()=>{!this.hasSelectedItem()&&this.isOpened()&&this.hotMenu.listen()}};this.origOutsideClickDeselects=this.hot.getSettings().outsideClickDeselects,this.hot.getSettings().outsideClickDeselects=!1,this.hotMenu=new this.hot.constructor(this.container,o),this.hotMenu.addHook("afterInit",(()=>this.onAfterInit())),this.hotMenu.init(),v(N,this,(0,i.createMenuNavigator)(this.hotMenu)),v(_,this,(0,a.createKeyboardShortcutsCtrl)(this)),S(_,this).listen(),this.focus(),this.isSubMenu()&&this.addLocalHook("afterOpen",(()=>this.parentMenu.runLocalHooks("afterSubmenuOpen",this))),this.runLocalHooks("afterOpen",this)}close(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];if(this.isOpened())if(e&&this.isSubMenu())this.parentMenu.close();else if(S(N,this).clear(),this.closeAllSubMenus(),this.container.style.display="none",this.hotMenu.destroy(),this.hotMenu=null,this.hot.getSettings().outsideClickDeselects=this.origOutsideClickDeselects,this.runLocalHooks("afterClose"),this.isSubMenu()){if(this.hot.getSettings().ariaTags){const e=this.parentMenu.hotMenu.getSelectedLast();if(e){const t=this.parentMenu.hotMenu.getCell(e[0],0);(0,p.setAttribute)(t,[(0,C.A11Y_EXPANDED)(!1)])}}this.parentMenu.hotMenu.listen()}}openSubMenu(e){if(!this.hotMenu)return!1;const t=this.hotMenu.getCell(e,0);if(this.closeAllSubMenus(),!t||!(0,h.hasSubMenu)(t))return!1;const r=this.hotMenu.getSourceDataAtRow(e),n=new M(this.hot,{parent:this,name:r.name,className:this.options.className,keepInViewport:!0,container:this.options.container});return n.setMenuItems(r.submenu.items),n.open(),n.setPosition(t.getBoundingClientRect()),this.hotSubMenus[r.key]=n,this.hot.getSettings().ariaTags&&(0,p.setAttribute)(t,[(0,C.A11Y_EXPANDED)(!0)]),n}closeSubMenu(e){const t=this.hotMenu.getSourceDataAtRow(e),r=this.hotSubMenus[t.key];if(r){r.destroy(),delete this.hotSubMenus[t.key];const n=this.hotMenu.getCell(e,0);this.hot.getSettings().ariaTags&&(0,p.setAttribute)(n,[(0,C.A11Y_EXPANDED)(!1)])}}closeAllSubMenus(){(0,c.arrayEach)(this.hotMenu.getData(),((e,t)=>this.closeSubMenu(t)))}isAllSubMenusClosed(){return 0===Object.keys(this.hotSubMenus).length}focus(){this.isOpened()&&(this.hotMenu.rootElement.focus({preventScroll:!0}),this.getKeyboardShortcutsCtrl().listen(),this.hotMenu.listen())}destroy(){const e=this.container.parentNode;this.clearLocalHooks(),this.close(),this.parentMenu=null,this.eventManager.destroy(),e&&e.removeChild(this.container)}isOpened(){return null!==this.hotMenu}executeCommand(e){if(!this.isOpened()||!this.hasSelectedItem())return;const t=this.getSelectedItem();if(this.runLocalHooks("select",t,e),this.isCommandPassive(t))return;const r=this.hot.getSelectedRange(),n=r?(0,h.normalizeSelection)(r):[];this.runLocalHooks("executeCommand",t.key,n,e),this.isSubMenu()&&this.parentMenu.runLocalHooks("executeCommand",t.key,n,e)}isCommandPassive(e){return!1===e.isCommand||(0,h.isItemSeparator)(e)||(0,h.isItemDisabled)(e,this.hot)||(0,h.isItemSubMenu)(e)}setOffset(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;this.positioner.setOffset(e,t)}setPosition(e){this.isSubMenu()&&this.positioner.setParentElement(this.parentMenu.container),this.positioner.setElement(this.container).updatePosition(e)}createContainer(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;const t=this.options.container.ownerDocument;let r,n=e;return n&&((0,f.isFunction)(n)&&(n=n.call(this.hot),n=null===n||(0,m.isUndefined)(n)?"":n.toString()),n=n.replace(/[^A-z0-9]/g,"_"),n=`${this.options.className}Sub_${n}`,r=t.querySelector(`.${this.options.className}.${n}`)),r||(r=t.createElement("div"),(0,p.addClass)(r,`htMenu ${this.options.className}`),n&&(0,p.addClass)(r,n),this.options.container.appendChild(r)),r}onAfterInit(){const{wtTable:e}=this.hotMenu.view._wt,t=this.hotMenu.getSettings().data,r=e.hider.style,n=e.holder.style,s=parseInt(r.width,10),o=(0,c.arrayReduce)(t,((e,t)=>e+(t.name===l.SEPARATOR?1:26)),0);n.width=`${s+3}px`,n.height=`${o+3}px`,r.height=n.height,this.hot.getSettings().ariaTags&&(0,p.setAttribute)(this.hotMenu.rootElement,[(0,C.A11Y_MENU)(),(0,C.A11Y_TABINDEX)(-1)])}onDocumentMouseDown(e){this.isOpened()&&(this.options.standalone&&this.hotMenu&&!(0,p.isChildOf)(e.target,this.hotMenu.rootElement)?this.close(!0):!this.isAllSubMenusClosed()&&!this.isSubMenu()||(0,p.isChildOf)(e.target,".htMenu")||this.close(!0))}onDocumentContextMenu(e){this.isOpened()&&(0,p.hasClass)(e.target,"htCore")&&(0,p.isChildOf)(e.target,this.hotMenu.rootElement)&&e.preventDefault()}}t.Menu=M,(0,E.mixin)(M,y.default)},31130:(e,t,r)=>{"use strict";t.__esModule=!0,t.createMenuItemRenderer=function(e){return(t,r,i,a,l,h)=>{if(r.hasAttribute("ghost-table"))return;const u=t.getSourceDataAtRow(i),c=e.rootDocument.createElement("div"),d="function"==typeof h?h.call(e):h;if((0,s.empty)(r),(0,s.addClass)(c,"htItemWrapper"),e.getSettings().ariaTags){const t=!(0,n.isItemDisabled)(u,e)&&!(0,n.isItemSelectionDisabled)(u)&&!(0,n.isItemSeparator)(u);(0,s.setAttribute)(r,[(0,o.A11Y_MENU_ITEM)(),(0,o.A11Y_LABEL)(d),...t?[(0,o.A11Y_TABINDEX)(-1)]:[],...(0,n.isItemDisabled)(u,e)?[(0,o.A11Y_DISABLED)()]:[],...(0,n.isItemSubMenu)(u)?[(0,o.A11Y_EXPANDED)(!1)]:[]])}r.className="",r.appendChild(c),(0,n.isItemSeparator)(u)?(0,s.addClass)(r,"htSeparator"):"function"==typeof u.renderer?((0,s.addClass)(r,"htCustomMenuRenderer"),r.appendChild(u.renderer(t,c,i,a,l,d))):(0,s.fastInnerHTML)(c,d),(0,n.isItemDisabled)(u,e)?(0,s.addClass)(r,"htDisabled"):(0,n.isItemSelectionDisabled)(u)?(0,s.addClass)(r,"htSelectionDisabled"):(0,n.isItemSubMenu)(u)&&(0,s.addClass)(r,"htSubmenu")}};var n=r(76968),s=r(49536),o=r(81595)},16652:(e,t,r)=>{"use strict";t.__esModule=!0,t.createMenuNavigator=function(e){return(0,n.createPaginator)({size:()=>e.countRows(),onItemSelect(t,r){const n=e.getCell(t,0);if(!n||(0,s.isSeparator)(n)||(0,s.isDisabled)(n)||(0,s.isSelectionDisabled)(n))return!1;e.selectCell(t,0,...r?[t,0,!1,!1]:[])},onClear(){e.deselectCell()}})};var n=r(54232),s=r(76968)},50165:(e,t,