/*!
 * Copyright (c) HANDSONCODE sp. z o. o.
 *
 * HANDSONTABLE is a software distributed by HANDSONCODE sp. z o. o., a Polish corporation based in
 * Gdynia, Poland, at Aleja Zwyciestwa 96-98, registered by the District Court in Gdansk under number
 * 538651, EU tax ID number: PL5862294002, share capital: PLN 62,800.00.
 *
 * This software is protected by applicable copyright laws, including international treaties, and dual-
 * licensed - depending on whether your use for commercial purposes, meaning intended for or
 * resulting in commercial advantage or monetary compensation, or not.
 *
 * If your use is strictly personal or solely for evaluation purposes, meaning for the purposes of testing
 * the suitability, performance, and usefulness of this software outside the production environment,
 * you agree to be bound by the terms included in the "handsontable-non-commercial-license.pdf" file.
 *
 * Your use of this software for commercial purposes is subject to the terms included in an applicable
 * license agreement.
 *
 * In any case, you must not make any such use of this software as to develop software which may be
 * considered competitive with this software.
 *
 * UNLESS EXPRESSLY AGREED OTHERWISE, HANDSONCODE PROVIDES THIS SOFTWARE ON AN "AS IS"
 * BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, AND IN NO EVENT AND UNDER NO
 * LEGAL THEORY, SHALL HANDSONCODE BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER ARISING FROM
 * USE OR INABILITY TO USE THIS SOFTWARE.
 *
 * Version: 15.0.0
 * Release date: 16/12/2024 (built at 16/12/2024 13:19:50)
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define("Handsontable",[],t):"object"==typeof exports?exports.Handsontable=t():e.Handsontable=t()}("undefined"!=typeof self?self:this,(()=>(()=>{var e={88088:()=>{},53879:(e,t,r)=>{"use strict";r.d(t,{iz:()=>lt,Ay:()=>ah});var n,s,i={};r.r(i),r.d(i,{AbsPlugin:()=>Xi,AddressPlugin:()=>$i,ArrayPlugin:()=>Ki,BitShiftPlugin:()=>qi,BitwiseLogicOperationsPlugin:()=>eo,BooleanPlugin:()=>to,CharPlugin:()=>ro,CodePlugin:()=>no,ComplexPlugin:()=>jl,ConditionalAggregationPlugin:()=>ua,CountBlankPlugin:()=>so,CountUniquePlugin:()=>io,DateTimePlugin:()=>oo,DegreesPlugin:()=>co,DeltaPlugin:()=>po,ExpPlugin:()=>go,FinancialPlugin:()=>fo,FormulaTextPlugin:()=>vo,HyperlinkPlugin:()=>Ro,InformationPlugin:()=>So,IsEvenPlugin:()=>To,IsOddPlugin:()=>No,LogarithmPlugin:()=>Mo,LookupPlugin:()=>fa,MathConstantsPlugin:()=>bo,MathPlugin:()=>Bl,MatrixPlugin:()=>Io,MedianPlugin:()=>xo,ModuloPlugin:()=>Po,NumericAggregationPlugin:()=>ko,PowerPlugin:()=>Uo,RadiansPlugin:()=>Vo,RadixConversionPlugin:()=>Wo,RandomPlugin:()=>Xo,RomanPlugin:()=>ma,RoundingPlugin:()=>Zo,SimpleArithmerticPlugin:()=>wa,SqrtPlugin:()=>Jo,StatisticalAggregationPlugin:()=>nh,StatisticalPlugin:()=>Vl,SumprodPlugin:()=>ca,TextPlugin:()=>da,TrigonometryPlugin:()=>pa}),function(e){e.RELATIVE="RELATIVE",e.ABSOLUTE="ABSOLUTE"}(n||(n={}));class o{constructor(e,t,r){this.type=e,this.col=t,this.sheet=r}static absolute(e,t){return new o(n.ABSOLUTE,e,t)}static relative(e,t){return new o(n.RELATIVE,e,t)}static compareByAbsoluteAddress(e){return(t,r)=>t.toSimpleColumnAddress(e).col-r.toSimpleColumnAddress(e).col}isColumnAbsolute(){return this.type===n.ABSOLUTE}isColumnRelative(){return this.type===n.RELATIVE}isAbsolute(){return this.type===n.ABSOLUTE&&void 0!==this.sheet}moved(e,t,r){const n=void 0===this.sheet?void 0:e;return new o(this.type,this.col+t,n)}shiftedByColumns(e){return new o(this.type,this.col+e,this.sheet)}toSimpleColumnAddress(e){const t=Lr(this,e);let r=this.col;return this.isColumnRelative()&&(r=e.col+this.col),_r(t,r)}shiftRelativeDimensions(e,t){const r=this.isColumnRelative()?this.col+e:this.col;return new o(this.type,r,this.sheet)}shiftAbsoluteDimensions(e,t){const r=this.isColumnAbsolute()?this.col+e:this.col;return new o(this.type,r,this.sheet)}withSheet(e){return new o(this.type,this.col,e)}isInvalid(e){return this.toSimpleColumnAddress(e).col<0}hash(e){const t=e&&void 0!==this.sheet?`#${this.sheet}`:"";switch(this.type){case n.RELATIVE:return`${t}#COLR${this.col}`;case n.ABSOLUTE:return`${t}#COLA${this.col}`}}unparse(e){const t=this.toSimpleColumnAddress(e);if(br(t))return;const r=P(t.col);return`${this.type===n.ABSOLUTE?"$":""}${r}`}exceedsSheetSizeLimits(e){return this.col>=e}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class a{constructor(e,t,r){this.type=e,this.row=t,this.sheet=r}static absolute(e,t){return new a(n.ABSOLUTE,e,t)}static relative(e,t){return new a(n.RELATIVE,e,t)}static compareByAbsoluteAddress(e){return(t,r)=>t.toSimpleRowAddress(e).row-r.toSimpleRowAddress(e).row}isRowAbsolute(){return this.type===n.ABSOLUTE}isRowRelative(){return this.type===n.RELATIVE}isAbsolute(){return this.type===n.ABSOLUTE&&void 0!==this.sheet}moved(e,t,r){const n=void 0===this.sheet?void 0:e;return new a(this.type,this.row+r,n)}shiftedByRows(e){return new a(this.type,this.row+e,this.sheet)}toSimpleRowAddress(e){const t=Lr(this,e);let r=this.row;return this.isRowRelative()&&(r=e.row+this.row),Nr(t,r)}shiftRelativeDimensions(e,t){const r=this.isRowRelative()?this.row+t:this.row;return new a(this.type,r,this.sheet)}shiftAbsoluteDimensions(e,t){const r=this.isRowAbsolute()?this.row+t:this.row;return new a(this.type,r,this.sheet)}withSheet(e){return new a(this.type,this.row,e)}isInvalid(e){return this.toSimpleRowAddress(e).row<0}hash(e){const t=e&&void 0!==this.sheet?`#${this.sheet}`:"";switch(this.type){case n.RELATIVE:return`${t}#ROWR${this.row}`;case n.ABSOLUTE:return`${t}#ROWA${this.row}`}}unparse(e){const t=this.toSimpleRowAddress(e);if(Mr(t))return;return`${this.type===n.ABSOLUTE?"$":""}${t.row+1}`}exceedsSheetSizeLimits(e){return this.row>=e}}!function(e){e.CELL_REFERENCE_RELATIVE="CELL_REFERENCE",e.CELL_REFERENCE_ABSOLUTE="CELL_REFERENCE_ABSOLUTE",e.CELL_REFERENCE_ABSOLUTE_COL="CELL_REFERENCE_ABSOLUTE_COL",e.CELL_REFERENCE_ABSOLUTE_ROW="CELL_REFERENCE_ABSOLUTE_ROW"}(s||(s={}));class l{constructor(e,t,r,n){this.col=e,this.row=t,this.type=r,this.sheet=n}static fromColAndRow(e,t,r){return(e.isColumnAbsolute()&&t.isRowAbsolute()?l.absolute.bind(this):e.isColumnAbsolute()?l.absoluteCol.bind(this):t.isRowAbsolute()?l.absoluteRow.bind(this):l.relative.bind(this))(e.col,t.row,r)}static relative(e,t,r){return new l(e,t,s.CELL_REFERENCE_RELATIVE,r)}static absolute(e,t,r){return new l(e,t,s.CELL_REFERENCE_ABSOLUTE,r)}static absoluteCol(e,t,r){return new l(e,t,s.CELL_REFERENCE_ABSOLUTE_COL,r)}static absoluteRow(e,t,r){return new l(e,t,s.CELL_REFERENCE_ABSOLUTE_ROW,r)}toSimpleCellAddress(e){const t=Lr(this,e);return this.type===s.CELL_REFERENCE_ABSOLUTE?Ar(t,this.col,this.row):this.type===s.CELL_REFERENCE_ABSOLUTE_ROW?Ar(t,e.col+this.col,this.row):this.type===s.CELL_REFERENCE_ABSOLUTE_COL?Ar(t,this.col,e.row+this.row):Ar(t,e.col+this.col,e.row+this.row)}toColumnAddress(){const e=this.isColumnRelative()?n.RELATIVE:n.ABSOLUTE;return new o(e,this.col,this.sheet)}toRowAddress(){const e=this.isRowRelative()?n.RELATIVE:n.ABSOLUTE;return new a(e,this.row,this.sheet)}toSimpleColumnAddress(e){const t=Lr(this,e);let r=this.col;return this.isColumnRelative()&&(r+=e.col),_r(t,r)}toSimpleRowAddress(e){const t=Lr(this,e);let r=this.row;return this.isRowRelative()&&(r+=e.row),Nr(t,r)}isRowAbsolute(){return this.type===s.CELL_REFERENCE_ABSOLUTE||this.type===s.CELL_REFERENCE_ABSOLUTE_ROW}isColumnAbsolute(){return this.type===s.CELL_REFERENCE_ABSOLUTE||this.type===s.CELL_REFERENCE_ABSOLUTE_COL}isColumnRelative(){return this.type===s.CELL_REFERENCE_RELATIVE||this.type===s.CELL_REFERENCE_ABSOLUTE_ROW}isRowRelative(){return this.type===s.CELL_REFERENCE_RELATIVE||this.type===s.CELL_REFERENCE_ABSOLUTE_COL}isAbsolute(){return this.type===s.CELL_REFERENCE_ABSOLUTE&&void 0!==this.sheet}shiftedByRows(e){return new l(this.col,this.row+e,this.type,this.sheet)}shiftedByColumns(e){return new l(this.col+e,this.row,this.type,this.sheet)}moved(e,t,r){const n=void 0===this.sheet?void 0:e;return new l(this.col+t,this.row+r,this.type,n)}withSheet(e){return new l(this.col,this.row,this.type,e)}isInvalid(e){return Or(this.toSimpleCellAddress(e))}shiftRelativeDimensions(e,t){const r=this.isColumnAbsolute()?this.col:this.col+e,n=this.isRowAbsolute()?this.row:this.row+t;return new l(r,n,this.type,this.sheet)}shiftAbsoluteDimensions(e,t){const r=this.isColumnRelative()?this.col:this.col+e,n=this.isRowRelative()?this.row:this.row+t;return new l(r,n,this.type,this.sheet)}hash(e){const t=e&&void 0!==this.sheet?`#${this.sheet}`:"";switch(this.type){case s.CELL_REFERENCE_RELATIVE:return`${t}#${this.row}R${this.col}`;case s.CELL_REFERENCE_ABSOLUTE:return`${t}#${this.row}A${this.col}`;case s.CELL_REFERENCE_ABSOLUTE_COL:return`${t}#${this.row}AC${this.col}`;case s.CELL_REFERENCE_ABSOLUTE_ROW:return`${t}#${this.row}AR${this.col}`}}unparse(e){const t=this.toSimpleCellAddress(e);if(Or(t))return;const r=P(t.col),n=this.type===s.CELL_REFERENCE_ABSOLUTE||this.type===s.CELL_REFERENCE_ABSOLUTE_ROW?"$":"";return`${this.type===s.CELL_REFERENCE_ABSOLUTE||this.type===s.CELL_REFERENCE_ABSOLUTE_COL?"$":""}${r}${n}${t.row+1}`}exceedsSheetSizeLimits(e,t){return this.row>=t||this.col>=e}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const h=":",u="$",c="A-Za-zÀ-ʯ",d=`${c}0-9_.`,p=`[${c}0-9_]+`,g=`(${p}|'(((?!').|'')*)')!`,f=`(${g})?\\${u}?[A-Za-z]+\\${u}?[0-9]+`,m=`(${g})?\\${u}?[A-Za-z]+`,y=`(${g})?\\${u}?[0-9]+`,E="[rR][0-9]*[cC][0-9]*",w=`(${f})[^${d}]`,C=`[${c}_][${d}]*`,v=["0","1","2","3","4","5","6","7","8","9"],R=[...Array.from(Array(26)).map(((e,t)=>t+"A".charCodeAt(0))),...Array.from(Array(26)).map(((e,t)=>t+"a".charCodeAt(0))),...Array.from(Array(496)).map(((e,t)=>t+192))].map((e=>String.fromCharCode(e))),S=new RegExp(`^(${g})?(\\${u}?)([A-Za-z]+)(\\${u}?)([0-9]+)$`),T=new RegExp(`^(${g})?(\\${u}?)([A-Za-z]+)$`),N=new RegExp(`^(${g})?(\\${u}?)([0-9]+)$`),M=new RegExp(`^${p}$`),_=(e,t,r)=>{const n=S.exec(t),s=x(n[6]);let i=D(n,e);if(void 0===i)return;null===i&&(i=void 0);const o=Number(n[8])-1;return n[5]===u&&n[7]===u?l.absolute(s,o,i):n[5]===u?l.absoluteCol(s,o-r.row,i):n[7]===u?l.absoluteRow(s-r.col,o,i):l.relative(s-r.col,o-r.row,i)},b=(e,t,r)=>{const n=T.exec(t);let s=D(n,e);if(void 0===s)return;null===s&&(s=void 0);const i=x(n[6]);return n[5]===u?o.absolute(i,s):o.relative(i-r.col,s)},A=(e,t,r)=>{const n=N.exec(t);let s=D(n,e);if(void 0===s)return;null===s&&(s=void 0);const i=Number(n[6])-1;return n[5]===u?a.absolute(i,s):a.relative(i-r.row,s)},O=(e,t,r)=>{const n=S.exec(t);if(!n)return;const s=x(n[6]);let i=D(n,e);if(void 0===i)return;null===i&&(i=r);const o=Number(n[8])-1;return Ar(i,s,o)},I=(e,t,r)=>{const n=P(t.col),s=L(t.sheet,e);if(void 0!==s)return r!==t.sheet?`${s}!${n}${t.row+1}`:`${n}${t.row+1}`};function x(e){return 1===e.length?e.toUpperCase().charCodeAt(0)-65:e.split("").reduce(((e,t)=>26*e+(t.toUpperCase().charCodeAt(0)-64)),0)-1}function P(e){let t="";for(;e>=0;)t=String.fromCharCode(e%26+97)+t,e=Math.floor(e/26)-1;return t.toUpperCase()}function L(e,t){let r=t(e);if(void 0!==r)return M.test(r)?r:(r=r.replace(/'/g,"''"),`'${r}'`)}function D(e,t){var r;let n=null!==(r=e[3])&&void 0!==r?r:e[2];return n?(n=n.replace(/''/g,"'"),t(n)):null}var k=r(83012);
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const H=(e,t)=>({type:e,message:t});var F,U,V;!function(e){e.LexingError="LexingError",e.ParserError="ParsingError",e.StaticOffsetError="StaticOffsetError",e.StaticOffsetOutOfRangeError="StaticOffsetOutOfRangeError",e.RangeOffsetNotAllowed="RangeOffsetNotAllowed",e.InvalidRangeSize="InvalidRangeSize"}(F||(F={})),function(e){e.EMPTY="EMPTY",e.NUMBER="NUMBER",e.STRING="STRING",e.MINUS_UNARY_OP="MINUS_UNARY_OP",e.PLUS_UNARY_OP="PLUS_UNARY_OP",e.PERCENT_OP="PERCENT_OP",e.CONCATENATE_OP="CONCATENATE_OP",e.EQUALS_OP="EQUALS_OP",e.NOT_EQUAL_OP="NOT_EQUAL_OP",e.GREATER_THAN_OP="GREATER_THAN_OP",e.LESS_THAN_OP="LESS_THAN_OP",e.GREATER_THAN_OR_EQUAL_OP="GREATER_THAN_OR_EQUAL_OP",e.LESS_THAN_OR_EQUAL_OP="LESS_THAN_OR_EQUAL_OP",e.PLUS_OP="PLUS_OP",e.MINUS_OP="MINUS_OP",e.TIMES_OP="TIMES_OP",e.DIV_OP="DIV_OP",e.POWER_OP="POWER_OP",e.FUNCTION_CALL="FUNCTION_CALL",e.NAMED_EXPRESSION="NAMED_EXPRESSION",e.PARENTHESIS="PARENTHESES",e.CELL_REFERENCE="CELL_REFERENCE",e.CELL_RANGE="CELL_RANGE",e.COLUMN_RANGE="COLUMN_RANGE",e.ROW_RANGE="ROW_RANGE",e.ERROR="ERROR",e.ERROR_WITH_RAW_INPUT="ERROR_WITH_RAW_INPUT",e.ARRAY="ARRAY"}(U||(U={})),function(e){e[e.RELATIVE=0]="RELATIVE",e[e.START_ABSOLUTE=1]="START_ABSOLUTE",e[e.BOTH_ABSOLUTE=2]="BOTH_ABSOLUTE"}(V||(V={}));const B=(e,t)=>({type:U.CELL_REFERENCE,reference:e,leadingWhitespace:null==t?void 0:t.image}),W=(e,t,r,n)=>($(e,t,r),{type:U.CELL_RANGE,start:e,end:t,sheetReferenceType:r,leadingWhitespace:n}),Y=(e,t,r)=>({type:U.ARRAY,args:e,leadingWhitespace:null==t?void 0:t.image,internalWhitespace:null==r?void 0:r.image}),G=(e,t)=>({type:U.ERROR,error:e,leadingWhitespace:null==t?void 0:t.image}),j=(e,t,r)=>({type:U.ERROR_WITH_RAW_INPUT,error:t,rawInput:e,leadingWhitespace:null==r?void 0:r.image}),z=()=>({type:U.ERROR,error:Tr.parsingError()});function $(e,t,r){if(void 0!==e.sheet&&void 0===t.sheet||void 0===e.sheet&&void 0!==t.sheet)throw new Error("Start address inconsistent with end address");if(void 0===e.sheet&&r!==V.RELATIVE||void 0!==e.sheet&&r===V.RELATIVE)throw new Error("Sheet address inconsistent with sheet reference type")}function K(e,t){return(null!=t?t:"")+e}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const X={[U.PLUS_OP]:"+",[U.MINUS_OP]:"-",[U.TIMES_OP]:"*",[U.DIV_OP]:"/",[U.CONCATENATE_OP]:"&",[U.POWER_OP]:"^",[U.EQUALS_OP]:"=",[U.NOT_EQUAL_OP]:"<>",[U.GREATER_THAN_OP]:">",[U.GREATER_THAN_OR_EQUAL_OP]:">=",[U.LESS_THAN_OP]:"<",[U.LESS_THAN_OR_EQUAL_OP]:"<="};class q{constructor(e){this.functionRegistry=e,this.cache=new Map}set(e,t){const r=((e,t,r,n)=>({ast:e,relativeDependencies:t,hasVolatileFunction:r,hasStructuralChangeFunction:n}))(t,ke(t,this.functionRegistry),Q(t,this.functionRegistry.isFunctionVolatile),Q(t,this.functionRegistry.isFunctionDependentOnSheetStructureChange));return this.cache.set(e,r),r}get(e){return this.cache.get(e)}maybeSetAndThenGet(e,t){const r=this.cache.get(e);return void 0!==r?r.ast:(this.set(e,t),t)}}const Q=(e,t)=>{switch(e.type){case U.EMPTY:case U.NUMBER:case U.STRING:case U.ERROR:case U.ERROR_WITH_RAW_INPUT:case U.CELL_REFERENCE:case U.CELL_RANGE:case U.COLUMN_RANGE:case U.ROW_RANGE:case U.NAMED_EXPRESSION:return!1;case U.PERCENT_OP:case U.PLUS_UNARY_OP:case U.MINUS_UNARY_OP:return Q(e.value,t);case U.CONCATENATE_OP:case U.EQUALS_OP:case U.NOT_EQUAL_OP:case U.LESS_THAN_OP:case U.GREATER_THAN_OP:case U.LESS_THAN_OR_EQUAL_OP:case U.GREATER_THAN_OR_EQUAL_OP:case U.MINUS_OP:case U.PLUS_OP:case U.TIMES_OP:case U.DIV_OP:case U.POWER_OP:return Q(e.left,t)||Q(e.right,t);case U.PARENTHESIS:return Q(e.expression,t);case U.FUNCTION_CALL:return!!t(e.procedureName)||e.args.some((e=>Q(e,t)));case U.ARRAY:return e.args.some((e=>e.some((e=>Q(e,t)))))}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Z{}Z.DistinctSigns="Distinct signs.",Z.WrongArgNumber="Wrong number of arguments.",Z.EmptyArg="Empty function argument.",Z.EmptyArray="Empty array not allowed.",Z.ArrayDimensions="Array dimensions are not compatible.",Z.NoSpaceForArrayResult="No space for array result.",Z.ValueSmall="Value too small.",Z.ValueLarge="Value too large.",Z.BadCriterion="Incorrect criterion.",Z.RangeManySheets="Range spans more than one sheet.",Z.CellRangeExpected="Cell range expected.",Z.WrongDimension="Wrong range dimension.",Z.ScalarExpected="Cell range not allowed.",Z.NumberCoercion="Value cannot be coerced to number.",Z.NumberExpected="Number argument expected.",Z.IntegerExpected="Value needs to be an integer.",Z.BadMode="Mode not recognized.",Z.DateBounds="Date outside of bounds.",Z.OutOfSheet="Resulting reference is out of the sheet.",Z.WrongType="Wrong type of argument.",Z.NaN="NaN or infinite value encountered.",Z.EqualLength="Ranges need to be of equal length.",Z.Negative="Value cannot be negative.",Z.NotBinary="String does not represent a binary number.",Z.NotOctal="String does not represent an octal number.",Z.NotHex="String does not represent a hexadecimal number.",Z.EndStartPeriod="End period needs to be at least start period.",Z.CellRefExpected="Cell reference expected.",Z.EmptyRange="Empty range not allowed.",Z.BadRef="Address is not correct.",Z.NumberRange="Number-only range expected.",Z.ValueNotFound="Value not found.",Z.ValueBaseLarge="Value in base too large.",Z.ValueBaseSmall="Value in base too small.",Z.ValueBaseLong="Value in base too long.",Z.NegativeLength="Length cannot be negative.",Z.PatternNotFound="Pattern not found.",Z.OneValue="Needs at least one value.",Z.TwoValues="Range needs to contain at least two elements.",Z.ThreeValues="Range needs to contain at least three elements.",Z.IndexBounds="Index out of bounds.",Z.IndexLarge="Index too large.",Z.Formula="Expected formula.",Z.NegativeCount="Count cannot be negative.",Z.ParseError="Parsing error.",Z.SheetRef="Sheet does not exist.",Z.PeriodLong="Period number cannot exceed life length.",Z.InvalidDate="Invalid date.",Z.BitshiftLong="Result of bitshift is too long.",Z.EmptyString="Empty-string argument not allowed.",Z.LengthBounds="Length out of bounds.",Z.NegativeTime="Time cannot be negative.",Z.NoDefault="No default option.",Z.NoConditionMet="None of the conditions were met.",Z.Selector="Selector cannot exceed the number of arguments.",Z.StartEndDate="Start date needs to be earlier than end date.",Z.IncorrectDateTime="String does not represent correct DateTime.",Z.CharacterCodeBounds="Character code out of bounds.",Z.NonZero="Argument cannot be 0.",Z.LessThanOne="Argument cannot be less than 1.",Z.WeekendString="Incorrect weekend bitmask string.",Z.InvalidRoman="Invalid roman numeral.",Z.WrongOrder="Wrong order of values.",Z.ComplexNumberExpected="Complex number expected.",Z.ShouldBeIorJ="Should be 'i' or 'j'.",Z.SizeMismatch="Array dimensions mismatched.",Z.FunctionName=e=>`Function name ${e} not recognized.`,Z.NamedExpressionName=e=>`Named expression ${e} not recognized.`,Z.LicenseKey=e=>`License key is ${e}.`;
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const J=(0,k.createToken)({name:"AdditionOp",pattern:k.Lexer.NA}),ee=(0,k.createToken)({name:"PlusOp",pattern:/\+/,categories:J}),te=(0,k.createToken)({name:"MinusOp",pattern:/-/,categories:J}),re=(0,k.createToken)({name:"MultiplicationOp",pattern:k.Lexer.NA}),ne=(0,k.createToken)({name:"TimesOp",pattern:/\*/,categories:re}),se=(0,k.createToken)({name:"DivOp",pattern:/\//,categories:re}),ie=(0,k.createToken)({name:"PowerOp",pattern:/\^/}),oe=(0,k.createToken)({name:"PercentOp",pattern:/%/}),ae=(0,k.createToken)({name:"BooleanOp",pattern:k.Lexer.NA}),le=(0,k.createToken)({name:"EqualsOp",pattern:/=/,categories:ae}),he=(0,k.createToken)({name:"NotEqualOp",pattern:/<>/,categories:ae}),ue=(0,k.createToken)({name:"GreaterThanOp",pattern:/>/,categories:ae}),ce=(0,k.createToken)({name:"LessThanOp",pattern:/</,categories:ae}),de=(0,k.createToken)({name:"GreaterThanOrEqualOp",pattern:/>=/,categories:ae}),pe=(0,k.createToken)({name:"LessThanOrEqualOp",pattern:/<=/,categories:ae}),ge=(0,k.createToken)({name:"ConcatenateOp",pattern:/&/}),fe=(0,k.createToken)({name:"LParen",pattern:/\(/}),me=(0,k.createToken)({name:"RParen",pattern:/\)/}),ye=(0,k.createToken)({name:"ArrayLParen",pattern:/{/}),Ee=(0,k.createToken)({name:"ArrayRParen",pattern:/}/}),we=(0,k.createToken)({name:"StringLiteral",pattern:/"([^"\\]*(\\.[^"\\]*)*)"/}),Ce=(0,k.createToken)({name:"ErrorLiteral",pattern:/#[A-Za-z0-9\/]+[?!]?/}),ve=(0,k.createToken)({name:"RangeSeparator",pattern:new RegExp(h)}),Re=(0,k.createToken)({name:"ColumnRange",pattern:new RegExp(`${m}${h}${m}`)}),Se=(0,k.createToken)({name:"RowRange",pattern:new RegExp(`${y}${h}${y}`)}),Te=(0,k.createToken)({name:"ProcedureName",pattern:new RegExp(`([${c}][${d}]*)\\(`)}),Ne=new
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class{constructor(){this.POSSIBLE_START_CHARACTERS=[...R,...v,u,"'","_"],this.cellReferenceRegexp=new RegExp(w,"y")}match(e,t){this.cellReferenceRegexp.lastIndex=t;const r=this.cellReferenceRegexp.exec(e+"@");return null==r||null==r[1]?null:(r[0]=r[1],r)}},Me=(0,k.createToken)({name:"CellReference",pattern:Ne.match.bind(Ne),start_chars_hint:Ne.POSSIBLE_START_CHARACTERS,line_breaks:!1}),_e=new
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class{constructor(){this.POSSIBLE_START_CHARACTERS=[...R,"_"],this.namedExpressionRegexp=new RegExp(C,"y"),this.r1c1CellRefRegexp=new RegExp(`^${E}$`)}match(e,t){this.namedExpressionRegexp.lastIndex=t;const r=this.namedExpressionRegexp.exec(e);return null==r||null==r[0]||this.r1c1CellRefRegexp.test(r[0])?null:r}},be=(0,k.createToken)({name:"NamedExpression",pattern:_e.match.bind(_e),start_chars_hint:_e.POSSIBLE_START_CHARACTERS,line_breaks:!1}),Ae=e=>{const t=e.translationPackage.getFunctionTranslation("OFFSET"),r=e.errorMapping,n=e.translationPackage.buildFunctionMapping(),s=new RegExp("standard"===e.ignoreWhiteSpace?"[ \\t\\n\\r]+":"\\s+"),i=(0,k.createToken)({name:"WhiteSpace",pattern:s}),o=(0,k.createToken)({name:"ArrayRowSep",pattern:e.arrayRowSeparator}),a=(0,k.createToken)({name:"ArrayColSep",pattern:e.arrayColumnSeparator}),l=(0,k.createToken)({name:"NumberLiteral",pattern:new RegExp(`(([${e.decimalSeparator}]\\d+)|(\\d+([${e.decimalSeparator}]\\d*)?))(e[+-]?\\d+)?`)}),h=(0,k.createToken)({name:"OffsetProcedureName",pattern:new RegExp(t,"i")});let u,c;e.functionArgSeparator===e.arrayColumnSeparator?(u=a,c=[]):e.functionArgSeparator===e.arrayRowSeparator?(u=o,c=[]):(u=(0,k.createToken)({name:"ArgSeparator",pattern:e.functionArgSeparator}),c=[u]);return{ArgSeparator:u,NumberLiteral:l,OffsetProcedureName:h,ArrayRowSeparator:o,ArrayColSeparator:a,WhiteSpace:i,allTokens:[i,ee,te,ne,se,ie,le,he,oe,de,pe,ue,ce,fe,me,ye,Ee,h,Te,ve,...c,Re,Se,l,we,Ce,ge,ae,J,re,Me,be,o,a],errorMapping:r,functionMapping:n,decimalSeparator:e.decimalSeparator,maxColumns:e.maxColumns,maxRows:e.maxRows}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Oe extends k.EmbeddedActionsParser{constructor(e,t){super(e.allTokens,{outputCst:!1,maxLookahead:7}),this.booleanExpressionOrEmpty=this.RULE("booleanExpressionOrEmpty",(()=>{return this.OR([{ALT:()=>this.SUBRULE(this.booleanExpression)},{ALT:(0,k.EMPTY_ALT)({type:U.EMPTY,leadingWhitespace:null==e?void 0:e.image})}]);var e})),this.procedureExpression=this.RULE("procedureExpression",(()=>{var e;const t=this.CONSUME(Te),r=t.image.toUpperCase().slice(0,-1),n=null!==(e=this.lexerConfig.functionMapping[r])&&void 0!==e?e:r,s=[];let i=this.SUBRULE(this.booleanExpressionOrEmpty);this.MANY((()=>{var e;const t=this.CONSUME(this.lexerConfig.ArgSeparator);i.type===U.EMPTY&&(i.leadingWhitespace=null===(e=t.leadingWhitespace)||void 0===e?void 0:e.image),s.push(i),i=this.SUBRULE2(this.booleanExpressionOrEmpty)})),s.push(i),1===s.length&&s[0].type===U.EMPTY&&(s.length=0);const o=this.CONSUME(me);return((e,t,r,n,s)=>({type:U.FUNCTION_CALL,procedureName:e,args:t,leadingWhitespace:null==r?void 0:r.image,internalWhitespace:null==n?void 0:n.image,hyperlink:s}))(n,s,t.leadingWhitespace,o.leadingWhitespace)})),this.namedExpressionExpression=this.RULE("namedExpressionExpression",(()=>{const e=this.CONSUME(be);return t=e.image,r=e.leadingWhitespace,{type:U.NAMED_EXPRESSION,expressionName:t,leadingWhitespace:null==r?void 0:r.image};var t,r})),this.offsetProcedureExpression=this.RULE("offsetProcedureExpression",(()=>{const e=[];return this.CONSUME(this.lexerConfig.OffsetProcedureName),this.CONSUME(fe),this.MANY_SEP({SEP:this.lexerConfig.ArgSeparator,DEF:()=>{e.push(this.SUBRULE(this.booleanExpression))}}),this.CONSUME(me),this.handleOffsetHeuristic(e)})),this.columnRangeExpression=this.RULE("columnRangeExpression",(()=>{const e=this.CONSUME(Re),[t,r]=e.image.split(":"),n=this.ACTION((()=>b(this.sheetMapping,t,this.formulaAddress))),s=this.ACTION((()=>b(this.sheetMapping,r,this.formulaAddress)));if(void 0===n||void 0===s)return G(new Tr(ir.REF));if(n.exceedsSheetSizeLimits(this.lexerConfig.maxColumns)||s.exceedsSheetSizeLimits(this.lexerConfig.maxColumns))return j(e.image,new Tr(ir.NAME),e.leadingWhitespace);if(void 0===n.sheet&&void 0!==s.sheet)return this.parsingError(F.ParserError,"Malformed range expression");const{firstEnd:i,secondEnd:o,sheetRefType:a}=Oe.fixSheetIdsForRangeEnds(n,s);return l=i,h=o,u=a,c=e.leadingWhitespace,$(l,h,u),{type:U.COLUMN_RANGE,start:l,end:h,sheetReferenceType:u,leadingWhitespace:null==c?void 0:c.image};var l,h,u,c})),this.rowRangeExpression=this.RULE("rowRangeExpression",(()=>{const e=this.CONSUME(Se),[t,r]=e.image.split(":"),n=this.ACTION((()=>A(this.sheetMapping,t,this.formulaAddress))),s=this.ACTION((()=>A(this.sheetMapping,r,this.formulaAddress)));if(void 0===n||void 0===s)return G(new Tr(ir.REF));if(n.exceedsSheetSizeLimits(this.lexerConfig.maxRows)||s.exceedsSheetSizeLimits(this.lexerConfig.maxRows))return j(e.image,new Tr(ir.NAME),e.leadingWhitespace);if(void 0===n.sheet&&void 0!==s.sheet)return this.parsingError(F.ParserError,"Malformed range expression");const{firstEnd:i,secondEnd:o,sheetRefType:a}=Oe.fixSheetIdsForRangeEnds(n,s);return l=i,h=o,u=a,c=e.leadingWhitespace,$(l,h,u),{type:U.ROW_RANGE,start:l,end:h,sheetReferenceType:u,leadingWhitespace:null==c?void 0:c.image};var l,h,u,c})),this.cellReference=this.RULE("cellReference",(()=>{const e=this.CONSUME(Me),t=this.ACTION((()=>_(this.sheetMapping,e.image,this.formulaAddress)));return void 0===t?j(e.image,new Tr(ir.REF),e.leadingWhitespace):t.exceedsSheetSizeLimits(this.lexerConfig.maxColumns,this.lexerConfig.maxRows)?j(e.image,new Tr(ir.NAME),e.leadingWhitespace):B(t,e.leadingWhitespace)})),this.endRangeReference=this.RULE("endRangeReference",(e=>{var t;const r=this.CONSUME(Me),n=this.ACTION((()=>_(this.sheetMapping,e.image,this.formulaAddress))),s=this.ACTION((()=>_(this.sheetMapping,r.image,this.formulaAddress)));return void 0===n||void 0===s?this.ACTION((()=>j(`${e.image}:${r.image}`,new Tr(ir.REF),e.leadingWhitespace))):n.exceedsSheetSizeLimits(this.lexerConfig.maxColumns,this.lexerConfig.maxRows)||s.exceedsSheetSizeLimits(this.lexerConfig.maxColumns,this.lexerConfig.maxRows)?this.ACTION((()=>j(`${e.image}:${r.image}`,new Tr(ir.NAME),e.leadingWhitespace))):this.buildCellRange(n,s,null===(t=e.leadingWhitespace)||void 0===t?void 0:t.image)})),this.endOfRangeExpression=this.RULE("endOfRangeExpression",(e=>this.OR([{ALT:()=>this.SUBRULE(this.endRangeReference,{ARGS:[e]})},{ALT:()=>{var t;const r=this.SUBRULE(this.offsetProcedureExpression),n=this.ACTION((()=>_(this.sheetMapping,e.image,this.formulaAddress)));return void 0===n?G(new Tr(ir.REF)):r.type===U.CELL_REFERENCE?this.buildCellRange(n,r.reference,null===(t=e.leadingWhitespace)||void 0===t?void 0:t.image):this.parsingError(F.RangeOffsetNotAllowed,"Range offset not allowed here")}}]))),this.cellRangeExpression=this.RULE("cellRangeExpression",(()=>{const e=this.CONSUME(Me);return this.CONSUME2(ve),this.SUBRULE(this.endOfRangeExpression,{ARGS:[e]})})),this.endRangeWithOffsetStartReference=this.RULE("endRangeWithOffsetStartReference",(e=>{const t=this.CONSUME(Me),r=this.ACTION((()=>_(this.sheetMapping,t.image,this.formulaAddress)));return void 0===r?this.ACTION((()=>G(new Tr(ir.REF)))):this.buildCellRange(e.reference,r,e.leadingWhitespace)})),this.endOfRangeWithOffsetStartExpression=this.RULE("endOfRangeWithOffsetStartExpression",(e=>this.OR([{ALT:()=>this.SUBRULE(this.endRangeWithOffsetStartReference,{ARGS:[e]})},{ALT:()=>{const t=this.SUBRULE(this.offsetProcedureExpression);return t.type===U.CELL_REFERENCE?this.buildCellRange(e.reference,t.reference,e.leadingWhitespace):this.parsingError(F.RangeOffsetNotAllowed,"Range offset not allowed here")}}]))),this.offsetExpression=this.RULE("offsetExpression",(()=>{const e=this.SUBRULE(this.offsetProcedureExpression);let t;return this.OPTION((()=>{this.CONSUME(ve),t=e.type===U.CELL_RANGE?this.parsingError(F.RangeOffsetNotAllowed,"Range offset not allowed here"):this.SUBRULE(this.endOfRangeWithOffsetStartExpression,{ARGS:[e]})})),void 0!==t?t:e})),this.insideArrayExpression=this.RULE("insideArrayExpression",(()=>{const e=[[]];return e[e.length-1].push(this.SUBRULE(this.booleanExpression)),this.MANY((()=>{this.OR([{ALT:()=>{this.CONSUME(this.lexerConfig.ArrayColSeparator),e[e.length-1].push(this.SUBRULE2(this.booleanExpression))}},{ALT:()=>{this.CONSUME(this.lexerConfig.ArrayRowSeparator),e.push([]),e[e.length-1].push(this.SUBRULE3(this.booleanExpression))}}])})),Y(e)})),this.parenthesisExpression=this.RULE("parenthesisExpression",(()=>{const e=this.CONSUME(fe),t=this.SUBRULE(this.booleanExpression),r=this.CONSUME(me);return((e,t,r)=>({type:U.PARENTHESIS,expression:e,leadingWhitespace:null==t?void 0:t.image,internalWhitespace:null==r?void 0:r.image}))(t,e.leadingWhitespace,r.leadingWhitespace)})),this.arrayExpression=this.RULE("arrayExpression",(()=>this.OR([{ALT:()=>{const e=this.CONSUME(ye),t=this.SUBRULE(this.insideArrayExpression),r=this.CONSUME(Ee);return Y(t.args,e.leadingWhitespace,r.leadingWhitespace)}},{ALT:()=>this.SUBRULE(this.parenthesisExpression)}]))),this.numericStringToNumber=e=>{const t=e.replace(this.lexerConfig.decimalSeparator,".");return Number(t)},this.positiveAtomicExpression=this.RULE("positiveAtomicExpression",(()=>{var e;return this.OR(null!==(e=this.atomicExpCache)&&void 0!==e?e:this.atomicExpCache=[{ALT:()=>this.SUBRULE(this.arrayExpression)},{ALT:()=>this.SUBRULE(this.cellRangeExpression)},{ALT:()=>this.SUBRULE(this.columnRangeExpression)},{ALT:()=>this.SUBRULE(this.rowRangeExpression)},{ALT:()=>this.SUBRULE(this.offsetExpression)},{ALT:()=>this.SUBRULE(this.cellReference)},{ALT:()=>this.SUBRULE(this.procedureExpression)},{ALT:()=>this.SUBRULE(this.namedExpressionExpression)},{ALT:()=>{const e=this.CONSUME(this.lexerConfig.NumberLiteral);return t=this.numericStringToNumber(e.image),r=e.leadingWhitespace,{type:U.NUMBER,value:t,leadingWhitespace:null==r?void 0:r.image};var t,r}},{ALT:()=>(e=>{var t;return{type:U.STRING,value:e.image.slice(1,-1),leadingWhitespace:null===(t=e.leadingWhitespace)||void 0===t?void 0:t.image}})(this.CONSUME(we))},{ALT:()=>{const e=this.CONSUME(Ce),t=e.image.toUpperCase(),r=this.lexerConfig.errorMapping[t];return r?G(new Tr(r),e.leadingWhitespace):this.parsingError(F.ParserError,"Unknown error literal")}}])})),this.rightUnaryOpAtomicExpression=this.RULE("rightUnaryOpAtomicExpression",(()=>{const e=this.SUBRULE(this.positiveAtomicExpression),t=this.OPTION((()=>this.CONSUME(oe)));return t?(r=e,n=t.leadingWhitespace,{type:U.PERCENT_OP,value:r,leadingWhitespace:null==n?void 0:n.image}):e;var r,n})),this.atomicExpression=this.RULE("atomicExpression",(()=>this.OR([{ALT:()=>{const e=this.CONSUME(J),t=this.SUBRULE(this.atomicExpression);return(0,k.tokenMatcher)(e,ee)?((e,t)=>({type:U.PLUS_UNARY_OP,value:e,leadingWhitespace:null==t?void 0:t.image}))(t,e.leadingWhitespace):(0,k.tokenMatcher)(e,te)?((e,t)=>({type:U.MINUS_UNARY_OP,value:e,leadingWhitespace:null==t?void 0:t.image}))(t,e.leadingWhitespace):(this.customParsingError=H(F.ParserError,"Mismatched token type"),this.customParsingError)}},{ALT:()=>this.SUBRULE2(this.rightUnaryOpAtomicExpression)}]))),this.powerExpression=this.RULE("powerExpression",(()=>{let e=this.SUBRULE(this.atomicExpression);return this.MANY((()=>{const t=this.CONSUME(ie),r=this.SUBRULE2(this.atomicExpression);var n,s,i;(0,k.tokenMatcher)(t,ie)?(n=e,s=r,i=t.leadingWhitespace,e={type:U.POWER_OP,left:n,right:s,leadingWhitespace:null==i?void 0:i.image}):this.ACTION((()=>{throw Error("Operator not supported")}))})),e})),this.multiplicationExpression=this.RULE("multiplicationExpression",(()=>{let e=this.SUBRULE(this.powerExpression);return this.MANY((()=>{const t=this.CONSUME(re),r=this.SUBRULE2(this.powerExpression);var n,s,i;(0,k.tokenMatcher)(t,ne)?(n=e,s=r,i=t.leadingWhitespace,e={type:U.TIMES_OP,left:n,right:s,leadingWhitespace:null==i?void 0:i.image}):(0,k.tokenMatcher)(t,se)?e=((e,t,r)=>({type:U.DIV_OP,left:e,right:t,leadingWhitespace:null==r?void 0:r.image}))(e,r,t.leadingWhitespace):this.ACTION((()=>{throw Error("Operator not supported")}))})),e})),this.additionExpression=this.RULE("additionExpression",(()=>{let e=this.SUBRULE(this.multiplicationExpression);return this.MANY((()=>{const t=this.CONSUME(J),r=this.SUBRULE2(this.multiplicationExpression);var n,s,i;(0,k.tokenMatcher)(t,ee)?(n=e,s=r,i=t.leadingWhitespace,e={type:U.PLUS_OP,left:n,right:s,leadingWhitespace:null==i?void 0:i.image}):(0,k.tokenMatcher)(t,te)?e=((e,t,r)=>({type:U.MINUS_OP,left:e,right:t,leadingWhitespace:null==r?void 0:r.image}))(e,r,t.leadingWhitespace):this.ACTION((()=>{throw Error("Operator not supported")}))})),e})),this.concatenateExpression=this.RULE("concatenateExpression",(()=>{let e=this.SUBRULE(this.additionExpression);return this.MANY((()=>{const t=this.CONSUME(ge),r=this.SUBRULE2(this.additionExpression);var n,s,i;n=e,s=r,i=t.leadingWhitespace,e={type:U.CONCATENATE_OP,left:n,right:s,leadingWhitespace:null==i?void 0:i.image}})),e})),this.booleanExpression=this.RULE("booleanExpression",(()=>{let e=this.SUBRULE(this.concatenateExpression);return this.MANY((()=>{const t=this.CONSUME(ae),r=this.SUBRULE2(this.concatenateExpression);var n,s,i;(0,k.tokenMatcher)(t,le)?(n=e,s=r,i=t.leadingWhitespace,e={type:U.EQUALS_OP,left:n,right:s,leadingWhitespace:null==i?void 0:i.image}):(0,k.tokenMatcher)(t,he)?e=((e,t,r)=>({type:U.NOT_EQUAL_OP,left:e,right:t,leadingWhitespace:null==r?void 0:r.image}))(e,r,t.leadingWhitespace):(0,k.tokenMatcher)(t,ue)?e=((e,t,r)=>({type:U.GREATER_THAN_OP,left:e,right:t,leadingWhitespace:null==r?void 0:r.image}))(e,r,t.leadingWhitespace):(0,k.tokenMatcher)(t,ce)?e=((e,t,r)=>({type:U.LESS_THAN_OP,left:e,right:t,leadingWhitespace:null==r?void 0:r.image}))(e,r,t.leadingWhitespace):(0,k.tokenMatcher)(t,de)?e=((e,t,r)=>({type:U.GREATER_THAN_OR_EQUAL_OP,left:e,right:t,leadingWhitespace:null==r?void 0:r.image}))(e,r,t.leadingWhitespace):(0,k.tokenMatcher)(t,pe)?e=((e,t,r)=>({type:U.LESS_THAN_OR_EQUAL_OP,left:e,right:t,leadingWhitespace:null==r?void 0:r.image}))(e,r,t.leadingWhitespace):this.ACTION((()=>{throw Error("Operator not supported")}))})),e})),this.formula=this.RULE("formula",(()=>(this.CONSUME(le),this.SUBRULE(this.booleanExpression)))),this.lexerConfig=e,this.sheetMapping=t,this.formulaAddress=Ar(0,0,0),this.performSelfAnalysis()}parseFromTokens(e,t){this.input=e;let r=this.formulaWithContext(t),n=[];return this.customParsingError&&n.push(this.customParsingError),n=n.concat(this.errors.map((e=>({type:F.ParserError,message:e.message})))),n.length>0&&(r=z()),{ast:r,errors:n}}reset(){super.reset(),this.customParsingError=void 0}formulaWithContext(e){return this.formulaAddress=e,this.formula()}buildCellRange(e,t,r){if(void 0===e.sheet&&void 0!==t.sheet)return this.parsingError(F.ParserError,"Malformed range expression");const{firstEnd:n,secondEnd:s,sheetRefType:i}=Oe.fixSheetIdsForRangeEnds(e,t);return W(n,s,i,r)}static fixSheetIdsForRangeEnds(e,t){const r=Oe.rangeSheetReferenceType(e.sheet,t.sheet);return{firstEnd:e,secondEnd:void 0!==e.sheet&&void 0===t.sheet?t.withSheet(e.sheet):t,sheetRefType:r}}handleOffsetHeuristic(e){const t=e[0];if(t.type!==U.CELL_REFERENCE)return this.parsingError(F.StaticOffsetError,"First argument to OFFSET is not a reference");const r=e[1];let n;if(r.type===U.NUMBER&&Number.isInteger(r.value))n=r.value;else if(r.type===U.PLUS_UNARY_OP&&r.value.type===U.NUMBER&&Number.isInteger(r.value.value))n=r.value.value;else{if(r.type!==U.MINUS_UNARY_OP||r.value.type!==U.NUMBER||!Number.isInteger(r.value.value))return this.parsingError(F.StaticOffsetError,"Second argument to OFFSET is not a static number");n=-r.value.value}const i=e[2];let o;if(i.type===U.NUMBER&&Number.isInteger(i.value))o=i.value;else if(i.type===U.PLUS_UNARY_OP&&i.value.type===U.NUMBER&&Number.isInteger(i.value.value))o=i.value.value;else{if(i.type!==U.MINUS_UNARY_OP||i.value.type!==U.NUMBER||!Number.isInteger(i.value.value))return this.parsingError(F.StaticOffsetError,"Third argument to OFFSET is not a static number");o=-i.value.value}const a=e[3];let h;if(void 0===a)h=1;else{if(a.type!==U.NUMBER)return this.parsingError(F.StaticOffsetError,"Fourth argument to OFFSET is not a static number");if(h=a.value,h<1)return this.parsingError(F.StaticOffsetError,"Fourth argument to OFFSET is too small number");if(!Number.isInteger(h))return this.parsingError(F.StaticOffsetError,"Fourth argument to OFFSET is not integer")}const u=e[4];let c;if(void 0===u)c=1;else{if(u.type!==U.NUMBER)return this.parsingError(F.StaticOffsetError,"Fifth argument to OFFSET is not a static number");if(c=u.value,c<1)return this.parsingError(F.StaticOffsetError,"Fifth argument to OFFSET is too small number");if(!Number.isInteger(c))return this.parsingError(F.StaticOffsetError,"Fifth argument to OFFSET is not integer")}const d=new l(t.reference.col+o,t.reference.row+n,t.reference.type);let p=d.col,g=d.row;if(t.reference.type!==s.CELL_REFERENCE_RELATIVE&&t.reference.type!==s.CELL_REFERENCE_ABSOLUTE_COL||(g+=this.formulaAddress.row),t.reference.type!==s.CELL_REFERENCE_RELATIVE&&t.reference.type!==s.CELL_REFERENCE_ABSOLUTE_ROW||(p+=this.formulaAddress.col),p<0||g<0)return G(new Tr(ir.REF,Z.OutOfSheet));if(1===c&&1===h)return B(d);{const e=new l(d.col+c-1,d.row+h-1,d.type);return W(d,e,V.RELATIVE)}}parsingError(e,t){return this.customParsingError=H(e,t),z()}static rangeSheetReferenceType(e,t){return void 0===e?V.RELATIVE:void 0===t?V.START_ABSOLUTE:V.BOTH_ABSOLUTE}}class Ie{constructor(e){this.lexerConfig=e,this.lexer=new k.Lexer(e.allTokens,{ensureOptimizations:!0})}tokenizeFormula(e){const t=this.lexer.tokenize(e);let r=t.tokens;return r=this.trimTrailingWhitespaces(r),r=this.skipWhitespacesInsideRanges(r),r=this.skipWhitespacesBeforeArgSeparators(r),t.tokens=r,t}skipWhitespacesInsideRanges(e){return Ie.filterTokensByNeighbors(e,((e,t,r)=>((0,k.tokenMatcher)(e,Me)||(0,k.tokenMatcher)(e,ve))&&(0,k.tokenMatcher)(t,this.lexerConfig.WhiteSpace)&&((0,k.tokenMatcher)(r,Me)||(0,k.tokenMatcher)(r,ve))))}skipWhitespacesBeforeArgSeparators(e){return Ie.filterTokensByNeighbors(e,((e,t,r)=>!(0,k.tokenMatcher)(e,this.lexerConfig.ArgSeparator)&&(0,k.tokenMatcher)(t,this.lexerConfig.WhiteSpace)&&(0,k.tokenMatcher)(r,this.lexerConfig.ArgSeparator)))}static filterTokensByNeighbors(e,t){if(e.length<3)return e;let r=0;const n=[e[r++]];for(;r<e.length-1;)t(e[r-1],e[r],e[r+1])||n.push(e[r]),++r;return n.push(e[r]),n}trimTrailingWhitespaces(e){return e.length>0&&(0,k.tokenMatcher)(e[e.length-1],this.lexerConfig.WhiteSpace)&&e.pop(),e}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class xe{constructor(e,t,r,n){this.config=e,this.lexerConfig=t,this.sheetMappingFn=r,this.namedExpressions=n}unparse(e,t){return"="+this.unparseAst(e,t)}unparseAst(e,t){var r,n;switch(e.type){case U.EMPTY:return K("",e.leadingWhitespace);case U.NUMBER:return K(Pe(e.value,this.config.decimalSeparator),e.leadingWhitespace);case U.STRING:return K('"'+e.value+'"',e.leadingWhitespace);case U.FUNCTION_CALL:{const r=e.args.map((e=>void 0!==e?this.unparseAst(e,t):"")).join(this.config.functionArgSeparator),n=(this.config.translationPackage.isFunctionTranslated(e.procedureName)?this.config.translationPackage.getFunctionTranslation(e.procedureName):e.procedureName)+"("+r+K(")",e.internalWhitespace);return K(n,e.leadingWhitespace)}case U.NAMED_EXPRESSION:return K((null===(r=this.namedExpressions.nearestNamedExpression(e.expressionName,t.sheet))||void 0===r?void 0:r.displayName)||e.expressionName,e.leadingWhitespace);case U.CELL_REFERENCE:{let r;return r=void 0!==e.reference.sheet?this.unparseSheetName(e.reference.sheet)+"!":"",r+=null!==(n=e.reference.unparse(t))&&void 0!==n?n:this.config.translationPackage.getErrorTranslation(ir.REF),K(r,e.leadingWhitespace)}case U.COLUMN_RANGE:case U.ROW_RANGE:case U.CELL_RANGE:return K(this.formatRange(e,t),e.leadingWhitespace);case U.PLUS_UNARY_OP:{const r=this.unparseAst(e.value,t);return K("+",e.leadingWhitespace)+r}case U.MINUS_UNARY_OP:{const r=this.unparseAst(e.value,t);return K("-",e.leadingWhitespace)+r}case U.PERCENT_OP:return this.unparseAst(e.value,t)+K("%",e.leadingWhitespace);case U.ERROR:return K(this.config.translationPackage.getErrorTranslation(e.error?e.error.type:ir.ERROR),e.leadingWhitespace);case U.ERROR_WITH_RAW_INPUT:return K(e.rawInput,e.leadingWhitespace);case U.PARENTHESIS:{const r="("+this.unparseAst(e.expression,t)+K(")",e.internalWhitespace);return K(r,e.leadingWhitespace)}case U.ARRAY:{const r="{"+e.args.map((e=>e.map((e=>this.unparseAst(e,t))).join(this.config.arrayColumnSeparator))).join(this.config.arrayRowSeparator)+K("}",e.internalWhitespace);return K(r,e.leadingWhitespace)}default:{const r=this.unparseAst(e.left,t),n=this.unparseAst(e.right,t);return r+K(X[e.type],e.leadingWhitespace)+n}}}unparseSheetName(e){const t=L(e,this.sheetMappingFn);if(void 0===t)throw new lt(e);return t}formatRange(e,t){let r="",n="";void 0!==e.start.sheet&&e.sheetReferenceType!==V.RELATIVE&&(r=this.unparseSheetName(e.start.sheet)+"!"),void 0!==e.end.sheet&&e.sheetReferenceType===V.BOTH_ABSOLUTE&&(n=this.unparseSheetName(e.end.sheet)+"!");const s=e.start.unparse(t),i=e.end.unparse(t);return void 0===s||void 0===i?this.config.translationPackage.getErrorTranslation(ir.REF):`${r}${s}:${n}${i}`}}function Pe(e,t){return e.toString().replace(".",t)}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Le{constructor(e,t,r){this.config=e,this.functionRegistry=t,this.sheetMapping=r,this.statsCacheUsed=0,this.lexerConfig=Ae(e),this.lexer=new Ie(this.lexerConfig),this.formulaParser=new Oe(this.lexerConfig,this.sheetMapping),this.cache=new q(this.functionRegistry)}parse(e,t){this.formulaAddress=t;const r=this.tokenizeFormula(e);if(r.errors.length>0){const e=r.errors.map((e=>({type:F.LexingError,message:e.message})));return{ast:z(),errors:e,hasVolatileFunction:!1,hasStructuralChangeFunction:!1,dependencies:[]}}const n=this.computeHashFromTokens(r.tokens,t);let s=this.cache.get(n);if(void 0!==s)++this.statsCacheUsed;else{const e=this.bindWhitespacesToTokens(r.tokens),i=this.formulaParser.parseFromTokens(e,t);if(i.errors.length>0)return Object.assign(Object.assign({},i),{hasVolatileFunction:!1,hasStructuralChangeFunction:!1,dependencies:[]});s=this.cache.set(n,i.ast)}const{ast:i,hasVolatileFunction:o,hasStructuralChangeFunction:a}=s,l=this.convertReversedRangesToRegularRanges(i);return{ast:l,errors:[],hasVolatileFunction:o,hasStructuralChangeFunction:a,dependencies:ke(l,this.functionRegistry)}}convertReversedRangesToRegularRanges(e){switch(e.type){case U.EMPTY:case U.NUMBER:case U.STRING:case U.ERROR:case U.ERROR_WITH_RAW_INPUT:case U.CELL_REFERENCE:case U.NAMED_EXPRESSION:return e;case U.CELL_RANGE:{const{start:t,end:r}=e,n=this.orderCellRangeEnds(t,r);return Object.assign(Object.assign({},e),{start:n.start,end:n.end})}case U.COLUMN_RANGE:{const{start:t,end:r}=e,n=this.orderColumnRangeEnds(t,r);return Object.assign(Object.assign({},e),{start:n.start,end:n.end})}case U.ROW_RANGE:{const{start:t,end:r}=e,n=this.orderRowRangeEnds(t,r);return Object.assign(Object.assign({},e),{start:n.start,end:n.end})}case U.PERCENT_OP:case U.PLUS_UNARY_OP:case U.MINUS_UNARY_OP:{const t=this.convertReversedRangesToRegularRanges(e.value);return Object.assign(Object.assign({},e),{value:t})}case U.CONCATENATE_OP:case U.EQUALS_OP:case U.NOT_EQUAL_OP:case U.LESS_THAN_OP:case U.GREATER_THAN_OP:case U.LESS_THAN_OR_EQUAL_OP:case U.GREATER_THAN_OR_EQUAL_OP:case U.MINUS_OP:case U.PLUS_OP:case U.TIMES_OP:case U.DIV_OP:case U.POWER_OP:{const t=this.convertReversedRangesToRegularRanges(e.left),r=this.convertReversedRangesToRegularRanges(e.right);return Object.assign(Object.assign({},e),{left:t,right:r})}case U.PARENTHESIS:{const t=this.convertReversedRangesToRegularRanges(e.expression);return Object.assign(Object.assign({},e),{expression:t})}case U.FUNCTION_CALL:{const t=e.args.map((e=>this.convertReversedRangesToRegularRanges(e)));return Object.assign(Object.assign({},e),{args:t})}case U.ARRAY:{const t=e.args.map((e=>e.map((e=>this.convertReversedRangesToRegularRanges(e)))));return Object.assign(Object.assign({},e),{args:t})}}}orderCellRangeEnds(e,t){const r=[e,t],[n,s]=r.map((e=>e.toColumnAddress())).sort(o.compareByAbsoluteAddress(this.formulaAddress)),[i,h]=r.map((e=>e.toRowAddress())).sort(a.compareByAbsoluteAddress(this.formulaAddress)),[u,c]=r.map((e=>e.sheet)).sort(Le.compareSheetIds.bind(this));return{start:l.fromColAndRow(n,i,u),end:l.fromColAndRow(s,h,c)}}orderColumnRangeEnds(e,t){const r=[e,t],[n,s]=r.sort(o.compareByAbsoluteAddress(this.formulaAddress)),[i,a]=r.map((e=>e.sheet)).sort(Le.compareSheetIds.bind(this));return{start:new o(n.type,n.col,i),end:new o(s.type,s.col,a)}}orderRowRangeEnds(e,t){const r=[e,t],[n,s]=r.sort(a.compareByAbsoluteAddress(this.formulaAddress)),[i,o]=r.map((e=>e.sheet)).sort(Le.compareSheetIds.bind(this));return{start:new a(n.type,n.row,i),end:new a(s.type,s.row,o)}}static compareSheetIds(e,t){return(e=null!=e?e:1/0)-(t=null!=t?t:1/0)}fetchCachedResultForAst(e){const t=this.computeHashFromAst(e);return this.fetchCachedResult(t)}fetchCachedResult(e){const t=this.cache.get(e);if(void 0===t)throw new Error("There is no AST with such key in the cache");{const{ast:e,hasVolatileFunction:r,hasStructuralChangeFunction:n,relativeDependencies:s}=t;return{ast:e,errors:[],hasVolatileFunction:r,hasStructuralChangeFunction:n,dependencies:s}}}computeHashFromTokens(e,t){var r;let n="",s=0;for(;s<e.length;){const i=e[s];if((0,k.tokenMatcher)(i,Me)){const e=_(this.sheetMapping,i.image,t);n=void 0===e?n.concat(i.image):n.concat(e.hash(!0))}else if((0,k.tokenMatcher)(i,Te)){const e=i.image.toUpperCase().slice(0,-1),t=null!==(r=this.lexerConfig.functionMapping[e])&&void 0!==r?r:e;n=n.concat(t,"(")}else if((0,k.tokenMatcher)(i,Re)){const[e,r]=i.image.split(":"),s=b(this.sheetMapping,e,t),o=b(this.sheetMapping,r,t);n=void 0===s||void 0===o?n.concat("!REF"):n.concat(s.hash(!0),":",o.hash(!0))}else if((0,k.tokenMatcher)(i,Se)){const[e,r]=i.image.split(":"),s=A(this.sheetMapping,e,t),o=A(this.sheetMapping,r,t);n=void 0===s||void 0===o?n.concat("!REF"):n.concat(s.hash(!0),":",o.hash(!0))}else n=n.concat(i.image);s++}return n}rememberNewAst(e){const t=this.computeHashFromAst(e);return this.cache.maybeSetAndThenGet(t,e)}computeHashFromAst(e){return"="+this.computeHashOfAstNode(e)}computeHashOfAstNode(e){switch(e.type){case U.EMPTY:return e.leadingWhitespace||"";case U.NUMBER:return K(Pe(e.value,this.config.decimalSeparator),e.leadingWhitespace);case U.STRING:return K('"'+e.value+'"',e.leadingWhitespace);case U.NAMED_EXPRESSION:return K(e.expressionName,e.leadingWhitespace);case U.FUNCTION_CALL:{const t=e.args.map((e=>this.computeHashOfAstNode(e))).join(this.config.functionArgSeparator),r=e.procedureName+"("+t+K(")",e.internalWhitespace);return K(r,e.leadingWhitespace)}case U.CELL_REFERENCE:return K(e.reference.hash(!0),e.leadingWhitespace);case U.COLUMN_RANGE:case U.ROW_RANGE:case U.CELL_RANGE:return K(e.start.hash(e.sheetReferenceType!==V.RELATIVE)+":"+e.end.hash(e.sheetReferenceType===V.BOTH_ABSOLUTE),e.leadingWhitespace);case U.MINUS_UNARY_OP:return K("-"+this.computeHashOfAstNode(e.value),e.leadingWhitespace);case U.PLUS_UNARY_OP:return K("+"+this.computeHashOfAstNode(e.value),e.leadingWhitespace);case U.PERCENT_OP:return this.computeHashOfAstNode(e.value)+K("%",e.leadingWhitespace);case U.ERROR:return K(this.config.translationPackage.getErrorTranslation(e.error?e.error.type:ir.ERROR),e.leadingWhitespace);case U.ERROR_WITH_RAW_INPUT:return K(e.rawInput,e.leadingWhitespace);case U.ARRAY:return K("{"+e.args.map((e=>e.map((e=>this.computeHashOfAstNode(e))).join(","))).join(";")+K("}",e.internalWhitespace),e.leadingWhitespace);case U.PARENTHESIS:{const t="("+this.computeHashOfAstNode(e.expression)+K(")",e.internalWhitespace);return K(t,e.leadingWhitespace)}default:return this.computeHashOfAstNode(e.left)+K(X[e.type],e.leadingWhitespace)+this.computeHashOfAstNode(e.right)}}bindWhitespacesToTokens(e){const t=[],r=e[0];(0,k.tokenMatcher)(r,this.lexerConfig.WhiteSpace)||t.push(r);for(let r=1;r<e.length;++r){const n=e[r];if((0,k.tokenMatcher)(n,this.lexerConfig.WhiteSpace))continue;const s=e[r-1];(0,k.tokenMatcher)(s,this.lexerConfig.WhiteSpace)&&(n.leadingWhitespace=s),t.push(n)}return t}tokenizeFormula(e){return this.lexer.tokenizeFormula(e)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const De=(e,t,r,n)=>{switch(e.type){case U.EMPTY:case U.NUMBER:case U.STRING:case U.ERROR:return;case U.NAMED_EXPRESSION:return void(n&&r.push(new Be(e.expressionName)));case U.CELL_REFERENCE:return void(n&&r.push(new He(e.reference)));case U.CELL_RANGE:return void(n&&e.start.sheet===e.end.sheet&&r.push(new Fe(e.start,e.end)));case U.COLUMN_RANGE:return void(n&&e.start.sheet===e.end.sheet&&r.push(new Ue(e.start,e.end)));case U.ROW_RANGE:return void(n&&e.start.sheet===e.end.sheet&&r.push(new Ve(e.start,e.end)));case U.PERCENT_OP:case U.PLUS_UNARY_OP:case U.MINUS_UNARY_OP:return void De(e.value,t,r,!0);case U.CONCATENATE_OP:case U.EQUALS_OP:case U.NOT_EQUAL_OP:case U.LESS_THAN_OP:case U.GREATER_THAN_OP:case U.LESS_THAN_OR_EQUAL_OP:case U.GREATER_THAN_OR_EQUAL_OP:case U.MINUS_OP:case U.PLUS_OP:case U.TIMES_OP:case U.DIV_OP:case U.POWER_OP:return De(e.left,t,r,!0),void De(e.right,t,r,!0);case U.PARENTHESIS:return void De(e.expression,t,r,n);case U.FUNCTION_CALL:{const n=!t.doesFunctionNeedArgumentToBeComputed(e.procedureName);return void e.args.forEach((e=>De(e,t,r,n)))}}},ke=(e,t)=>{const r=new Array;return De(e,t,r,!0),r};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class He{constructor(e){this.dependency=e}absolutize(e){return this.dependency.toSimpleCellAddress(e)}}class Fe{constructor(e,t){this.start=e,this.end=t}absolutize(e){return new Fr(this.start.toSimpleCellAddress(e),this.end.toSimpleCellAddress(e))}}class Ue{constructor(e,t){this.start=e,this.end=t}absolutize(e){const t=this.start.toSimpleColumnAddress(e),r=this.end.toSimpleColumnAddress(e);return new Ur(t.sheet,t.col,r.col)}}class Ve{constructor(e,t){this.start=e,this.end=t}absolutize(e){const t=this.start.toSimpleRowAddress(e),r=this.end.toSimpleRowAddress(e);return new Vr(t.sheet,t.row,r.row)}}class Be{constructor(e){this.name=e}absolutize(e){return this}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const We=(e,t)=>e.map((e=>e.absolutize(t))),Ye=Symbol("Empty value");function Ge(e){return e instanceof je?e.val:e}class je{constructor(e,t){this.val=e,this.format=t}fromNumber(e){return new this.constructor(e)}}function ze(e,t){if("number"==typeof e)return t;{const r=e.fromNumber(t);return r.format=e.format,r}}class $e extends je{getDetailedType(){return Je.NUMBER_DATE}}class Ke extends je{getDetailedType(){return Je.NUMBER_CURRENCY}}class Xe extends je{getDetailedType(){return Je.NUMBER_TIME}}class qe extends je{getDetailedType(){return Je.NUMBER_DATETIME}}class Qe extends je{getDetailedType(){return Je.NUMBER_PERCENT}}function Ze(e){return"number"==typeof e||e instanceof je}var Je,et;function tt(e){return e instanceof je?{type:e.getDetailedType(),format:e.format}:{type:Je.NUMBER_RAW}}!function(e){e.NUMBER_RAW="NUMBER_RAW",e.NUMBER_DATE="NUMBER_DATE",e.NUMBER_TIME="NUMBER_TIME",e.NUMBER_DATETIME="NUMBER_DATETIME",e.NUMBER_CURRENCY="NUMBER_CURRENCY",e.NUMBER_PERCENT="NUMBER_PERCENT"}(Je||(Je={}));
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class rt{constructor(e,t,r,n){this._data=e,this.range=t,this.dependencyGraph=r,this._hasOnlyNumbers=n,this.size=void 0===e?new cn(t.effectiveWidth(r),t.effectiveHeight(r)):new cn(e[0].length,e.length)}get data(){return this.ensureThatComputed(),this._data}static fromRange(e,t,r){return new rt(e,t,r,!0)}static onlyNumbers(e){return new rt(e,void 0,void 0,!0)}static onlyValues(e){return new rt(e,void 0,void 0,void 0)}static onlyRange(e,t){return new rt(void 0,e,t,void 0)}static fromScalar(e){return new rt([[e]],void 0,void 0,void 0)}isAdHoc(){return void 0===this.range}width(){return this.size.width}height(){return this.size.height}valuesFromTopLeftCorner(){this.ensureThatComputed();const e=[];for(let t=0;t<this._data.length;t++)for(let r=0;r<this._data[0].length;r++)e.push(this._data[t][r]);return e}*effectiveAddressesFromData(e){for(let t=0;t<this.data.length;++t){const r=this.data[t];for(let n=0;n<r.length;++n)yield Ar(e.sheet,e.col+n,e.row+t)}}*entriesFromTopLeftCorner(e){this.ensureThatComputed();for(let t=0;t<this.size.height;++t)for(let r=0;r<this.size.width;++r)yield[this._data[t][r],Ar(e.sheet,e.col+r,e.row+t)]}*iterateValuesFromTopLeftCorner(){yield*this.valuesFromTopLeftCorner()}numberOfElements(){return this.size.width*this.size.height}hasOnlyNumbers(){if(void 0===this._hasOnlyNumbers){this._hasOnlyNumbers=!0;for(const e of this.data)for(const t of e)if("number"!=typeof t)return this._hasOnlyNumbers=!1,!1}return this._hasOnlyNumbers}rawNumbers(){return this._data}rawData(){var e;return this.ensureThatComputed(),null!==(e=this._data)&&void 0!==e?e:[]}sameDimensionsAs(e){return this.width()===e.width()&&this.height()===e.height()}ensureThatComputed(){void 0===this._data&&(this._hasOnlyNumbers=!0,this._data=this.range.addressesArrayMap(this.dependencyGraph,(e=>{const t=this.dependencyGraph.getCellValue(e);return t instanceof rt?(this._hasOnlyNumbers=!1,new Tr(ir.VALUE,Z.ScalarExpected)):(Ze(t)||(this._hasOnlyNumbers=!1),t)})))}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class nt{constructor(){this.changes=new Map}static empty(){return new nt}addAll(e){for(const t of e.changes.values())this.add(t.address,t);return this}addChange(e,t,r){this.addInterpreterValue(e,t,r)}exportChanges(e){let t=[];return this.changes.forEach((r=>{const n=e.exportChange(r);Array.isArray(n)?t=t.concat(n):t.push(n)})),t}getChanges(){return Array.from(this.changes.values())}isEmpty(){return 0===this.changes.size}add(e,t){const r=t.value;if(r instanceof rt)for(const t of r.effectiveAddressesFromData(e))this.changes.delete(xr(t));this.changes.set(xr(e),t)}addInterpreterValue(e,t,r){this.add(t,{address:t,value:e,oldValue:r})}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class st{constructor(e,t,r){if(this.sheet=e,this.rowStart=t,this.rowEnd=r,t<0)throw Error("Starting row cant be less than 0");if(r<t)throw Error("Row span cant end before start")}get numberOfRows(){return this.rowEnd-this.rowStart+1}get start(){return this.rowStart}get end(){return this.rowEnd}static fromNumberOfRows(e,t,r){return new st(e,t,t+r-1)}static fromRowStartAndEnd(e,t,r){return new st(e,t,r)}*rows(){for(let e=this.rowStart;e<=this.rowEnd;++e)yield e}intersect(e){if(this.sheet!==e.sheet)throw Error("Can't intersect spans from different sheets");const t=Math.max(this.rowStart,e.rowStart),r=Math.min(this.rowEnd,e.rowEnd);return t>r?null:new st(this.sheet,t,r)}firstRow(){return new st(this.sheet,this.rowStart,this.rowStart)}}class it{constructor(e,t,r){if(this.sheet=e,this.columnStart=t,this.columnEnd=r,t<0)throw Error("Starting column cant be less than 0");if(r<t)throw Error("Column span cant end before start")}get numberOfColumns(){return this.columnEnd-this.columnStart+1}get start(){return this.columnStart}get end(){return this.columnEnd}static fromNumberOfColumns(e,t,r){return new it(e,t,t+r-1)}static fromColumnStartAndEnd(e,t,r){return new it(e,t,r)}*columns(){for(let e=this.columnStart;e<=this.columnEnd;++e)yield e}intersect(e){if(this.sheet!==e.sheet)throw Error("Can't intersect spans from different sheets");const t=Math.max(this.columnStart,e.columnStart),r=Math.min(this.columnEnd,e.columnEnd);return t>r?null:new it(this.sheet,t,r)}firstColumn(){return new it(this.sheet,this.columnStart,this.columnStart)}}!function(e){e.BUILD_ENGINE_TOTAL="BUILD_ENGINE_TOTAL",e.PARSER="PARSER",e.GRAPH_BUILD="GRAPH_BUILD",e.COLLECT_DEPENDENCIES="COLLECT_DEPENDENCIES",e.PROCESS_DEPENDENCIES="PROCESS_DEPENDENCIES",e.TOP_SORT="TOP_SORT",e.BUILD_COLUMN_INDEX="BUILD_COLUMN_INDEX",e.EVALUATION="EVALUATION",e.VLOOKUP="VLOOKUP",e.TRANSFORM_ASTS="TRANSFORM_ASTS",e.TRANSFORM_ASTS_POSTPONED="TRANSFORM_ASTS_POSTPONED",e.ADJUSTING_ADDRESS_MAPPING="ADJUSTING_ADDRESS_MAPPING",e.ADJUSTING_ARRAY_MAPPING="ADJUSTING_ARRAY_MAPPING",e.ADJUSTING_RANGES="ADJUSTING_RANGES",e.ADJUSTING_GRAPH="ADJUSTING_GRAPH",e.CRITERION_FUNCTION_FULL_CACHE_USED="CRITERION_FUNCTION_FULL_CACHE_USED",e.CRITERION_FUNCTION_PARTIAL_CACHE_USED="CRITERION_FUNCTION_PARTIAL_CACHE_USED"}(et||(et={}));
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ot{constructor(){this.stats=new Map([[et.CRITERION_FUNCTION_FULL_CACHE_USED,0],[et.CRITERION_FUNCTION_PARTIAL_CACHE_USED,0]]),this.startTimes=new Map}incrementCriterionFunctionFullCacheUsed(){var e;const t=(null!==(e=this.stats.get(et.CRITERION_FUNCTION_FULL_CACHE_USED))&&void 0!==e?e:0)+1;this.stats.set(et.CRITERION_FUNCTION_FULL_CACHE_USED,t)}incrementCriterionFunctionPartialCacheUsed(){var e;const t=(null!==(e=this.stats.get(et.CRITERION_FUNCTION_PARTIAL_CACHE_USED))&&void 0!==e?e:0)+1;this.stats.set(et.CRITERION_FUNCTION_PARTIAL_CACHE_USED,t)}reset(){this.stats.clear(),this.startTimes.clear(),this.stats.set(et.CRITERION_FUNCTION_FULL_CACHE_USED,0),this.stats.set(et.CRITERION_FUNCTION_PARTIAL_CACHE_USED,0)}start(e){if(this.startTimes.get(e))throw Error(`Statistics ${e} already started`);this.startTimes.set(e,Date.now())}end(e){var t;const r=Date.now(),n=this.startTimes.get(e);if(!n)throw Error(`Statistics ${e} not started`);{let s=null!==(t=this.stats.get(e))&&void 0!==t?t:0;s+=r-n,this.stats.set(e,s),this.startTimes.delete(e)}}measure(e,t){this.start(e);const r=t();return this.end(e),r}snapshot(){return new Map(this.stats)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class at extends ot{incrementCriterionFunctionFullCacheUsed(){}incrementCriterionFunctionPartialCacheUsed(){}start(e){}end(e){}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class lt extends Error{constructor(e){super(`There's no sheet with id = ${e}`)}}class ht extends Error{constructor(e){super(`There's no sheet with name '${e}'`)}}class ut extends Error{constructor(e){super(`Sheet with name ${e} already exists`)}}class ct extends Error{constructor(){super("Sheet size limit exceeded")}}class dt extends Error{constructor(){super("This is not a formula")}}class pt extends Error{constructor(e){super(`Address (row = ${e.row}, col = ${e.col}) is invalid`)}}class gt extends Error{constructor(e){super(`Invalid arguments, expected ${e}`)}}class ft extends Error{constructor(e,t){super(`Sheets ${e} and ${t} are not equal.`)}}class mt extends Error{constructor(e){super(`Name of Named Expression '${e}' is already present`)}}class yt extends Error{constructor(e){super(`Name of Named Expression '${e}' is invalid`)}}class Et extends Error{constructor(e){super(`Named Expression '${e}' does not exist`)}}class wt extends Error{constructor(){super("There is no operation to undo")}}class Ct extends Error{constructor(){super("There is no operation to redo")}}class vt extends Error{constructor(){super("There is nothing to paste")}}function Rt(e,t){switch(typeof t){case"function":case"symbol":return t.toString();case"bigint":return"BigInt("+t.toString()+")";default:return t instanceof RegExp?"RegExp("+t.toString()+")":t}}class St extends Error{constructor(e){super(`Unable to parse value: ${JSON.stringify(e,Rt,4)}`)}}class Tt extends Error{constructor(e,t){super(`Expected value of type: ${e} for config parameter: ${t}`)}}class Nt extends Error{constructor(e){super(`Config parameter ${e} cannot be empty.`)}}class Mt extends Error{constructor(e,t){super(`Config parameter ${e} should be at least ${t}`)}}class _t extends Error{constructor(e,t){super(`Config parameter ${e} should be at most ${t}`)}}class bt extends Error{constructor(e,t){super(`Expected one of ${e} for config parameter: ${t}`)}}class At extends Error{constructor(){super("Computations are suspended")}}class Ot extends Error{constructor(e){super(`Translation for ${e} is missing in the translation package you're using.`)}}class It extends Error{constructor(e){super(`Cannot register translation for function with id: ${e}`)}}class xt extends Error{constructor(){super("Language not registered.")}}class Pt extends Error{constructor(){super("Language already registered.")}}class Lt extends Error{static functionNotDeclaredInPlugin(e,t){return new Lt(`Function with id ${e} not declared in plugin ${t}`)}static functionMethodNotFound(e,t){return new Lt(`Function method ${e} not found in plugin ${t}`)}}class Dt extends Error{static cannotRegisterFunctionWithId(e){return new Dt(`Cannot register function with id ${e}`)}static cannotUnregisterFunctionWithId(e){return new Dt(`Cannot unregister function with id ${e}`)}static cannotUnregisterProtectedPlugin(){return new Dt("Cannot unregister protected plugin")}}class kt extends Error{constructor(){super("Cannot perform this operation, source location has an array inside.")}}class Ht extends Error{constructor(){super("Cannot perform this operation, target location has an array inside.")}}class Ft extends Error{constructor(){super("Relative addresses not allowed in named expressions.")}}class Ut extends Error{constructor(e,t){super(`Alias id ${e} in plugin ${t} already defined as a function or alias.`)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Vt{constructor(e){this.policy=e,this.mapping=new Map}getCell(e){const t=this.mapping.get(e.sheet);if(void 0===t)throw new lt(e.sheet);return t.getCell(e)}fetchCell(e){const t=this.mapping.get(e.sheet);if(void 0===t)throw new lt(e.sheet);const r=t.getCell(e);if(!r)throw Error("Vertex for address missing in AddressMapping");return r}strategyFor(e){const t=this.mapping.get(e);if(void 0===t)throw new lt(e);return t}addSheet(e,t){if(this.mapping.has(e))throw Error("Sheet already added");this.mapping.set(e,t)}autoAddSheet(e,t){const{height:r,width:n,fill:s}=t,i=this.policy.call(s);this.addSheet(e,new i(n,r))}getCellValue(e){const t=this.getCell(e);return void 0===t?Ye:t instanceof zt?t.getArrayCellValue(e):t.getCellValue()}getRawValue(e){const t=this.getCell(e);return t instanceof dr?t.getValues().rawValue:t instanceof zt?t.getArrayCellRawValue(e):null}setCell(e,t){const r=this.mapping.get(e.sheet);if(!r)throw Error("Sheet not initialized");r.setCell(e,t)}moveCell(e,t){const r=this.mapping.get(e.sheet);if(!r)throw Error("Sheet not initialized.");if(e.sheet!==t.sheet)throw Error("Cannot move cells between sheets.");if(r.has(t))throw new Error("Cannot move cell. Destination already occupied.");const n=r.getCell(e);if(void 0===n)throw new Error("Cannot move cell. No cell with such address.");this.setCell(t,n),this.removeCell(e)}removeCell(e){const t=this.mapping.get(e.sheet);if(!t)throw Error("Sheet not initialized");t.removeCell(e)}has(e){const t=this.mapping.get(e.sheet);return void 0!==t&&t.has(e)}getHeight(e){const t=this.mapping.get(e);if(void 0===t)throw new lt(e);return t.getHeight()}getWidth(e){const t=this.mapping.get(e);if(!t)throw new lt(e);return t.getWidth()}addRows(e,t,r){const n=this.mapping.get(e);if(void 0===n)throw new lt(e);n.addRows(t,r)}removeRows(e){const t=this.mapping.get(e.sheet);if(void 0===t)throw new lt(e.sheet);t.removeRows(e)}removeSheet(e){this.mapping.delete(e)}addColumns(e,t,r){const n=this.mapping.get(e);if(void 0===n)throw new lt(e);n.addColumns(t,r)}removeColumns(e){const t=this.mapping.get(e.sheet);if(void 0===t)throw new lt(e.sheet);t.removeColumns(e)}*verticesFromRowsSpan(e){yield*this.mapping.get(e.sheet).verticesFromRowsSpan(e)}*verticesFromColumnsSpan(e){yield*this.mapping.get(e.sheet).verticesFromColumnsSpan(e)}*entriesFromRowsSpan(e){yield*this.mapping.get(e.sheet).entriesFromRowsSpan(e)}*entriesFromColumnsSpan(e){yield*this.mapping.get(e.sheet).entriesFromColumnsSpan(e)}*entries(){for(const[e,t]of this.mapping.entries())yield*t.getEntries(e)}*sheetEntries(e){const t=this.mapping.get(e);if(void 0===t)throw new lt(e);yield*t.getEntries(e)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Bt{constructor(){this.arrayMapping=new Map}getArray(e){const t=this.getArrayByCorner(e.start);if(null==t?void 0:t.getRange().sameAs(e))return t}getArrayByCorner(e){return this.arrayMapping.get(xr(e))}setArray(e,t){this.arrayMapping.set(xr(e.start),t)}removeArray(e){"string"==typeof e?this.arrayMapping.delete(e):this.arrayMapping.delete(xr(e.start))}count(){return this.arrayMapping.size}*arraysInRows(e){for(const[t,r]of this.arrayMapping.entries())r.spansThroughSheetRows(e.sheet,e.rowStart,e.rowEnd)&&(yield[t,r])}*arraysInCols(e){for(const[t,r]of this.arrayMapping.entries())r.spansThroughSheetColumn(e.sheet,e.columnStart,e.columnEnd)&&(yield[t,r])}isFormulaArrayInRow(e,t){for(const r of this.arrayMapping.values())if(r.spansThroughSheetRows(e,t))return!0;return!1}isFormulaArrayInAllRows(e){let t=!0;for(const r of e.rows())this.isFormulaArrayInRow(e.sheet,r)||(t=!1);return t}isFormulaArrayInColumn(e,t){for(const r of this.arrayMapping.values())if(r.spansThroughSheetColumn(e,t))return!0;return!1}isFormulaArrayInAllColumns(e){let t=!0;for(const r of e.columns())this.isFormulaArrayInColumn(e.sheet,r)||(t=!1);return t}isFormulaArrayInRange(e){for(const t of this.arrayMapping.values())if(t.getRange().doesOverlap(e))return!0;return!1}isFormulaArrayAtAddress(e){for(const t of this.arrayMapping.values())if(t.getRange().addressInRange(e))return!0;return!1}moveArrayVerticesAfterRowByRows(e,t,r){this.updateArrayVerticesInSheet(e,((e,n)=>{const s=n.getRange();return t<=s.start.row?[s.shifted(0,r),n]:void 0}))}moveArrayVerticesAfterColumnByColumns(e,t,r){this.updateArrayVerticesInSheet(e,((e,n)=>{const s=n.getRange();return t<=s.start.col?[s.shifted(r,0),n]:void 0}))}updateArrayVerticesInSheet(e,t){const r=Array();for(const[n,s]of this.arrayMapping.entries()){if(s.sheet!==e)continue;const i=t(n,s);void 0!==i&&(this.removeArray(n),r.push(i))}r.forEach((([e,t])=>{this.setArray(e,t)}))}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Wt{constructor(e){this.size=e}width(){return this.size.width}height(){return this.size.height}get(e,t){throw Error("Array not computed yet.")}simpleRangeValue(){throw Error("Array not computed yet.")}}class Yt{constructor(e){if(this.size=new cn(e.length>0?e[0].length:0,e.length),this.array=e,this.size.width<=0||this.size.height<=0)throw Error("Incorrect array size")}static fromInterpreterValue(e){return new Yt(e instanceof rt?e.data:[[e]])}simpleRangeValue(){return rt.onlyValues(this.array)}addRows(e,t){this.array.splice(e,0,...this.nullArrays(t,this.width())),this.size.height+=t}addColumns(e,t){for(let r=0;r<this.height();r++)this.array[r].splice(e,0,...new Array(t).fill(Ye));this.size.width+=t}removeRows(e,t){if(this.outOfBound(0,e)||this.outOfBound(0,t))throw Error("Array index out of bound");const r=t-e+1;this.array.splice(e,r),this.size.height-=r}removeColumns(e,t){if(this.outOfBound(e,0)||this.outOfBound(t,0))throw Error("Array index out of bound");const r=t-e+1;for(const t of this.array)t.splice(e,r);this.size.width-=r}nullArrays(e,t){const r=[];for(let n=0;n<e;++n)r.push(new Array(t).fill(Ye));return r}get(e,t){if(this.outOfBound(e,t))throw Error("Array index out of bound");return this.array[t][e]}set(e,t,r){if(this.outOfBound(e,t))throw Error("Array index out of bound");this.array[t][e]=r}width(){return this.size.width}height(){return this.size.height}raw(){return this.array}resize(e){if(this.height()<e.height&&isFinite(e.height)&&this.addRows(this.height(),e.height-this.height()),this.height()>e.height)throw Error("Resizing to smaller array");if(this.width()<e.width&&isFinite(e.width)&&this.addColumns(this.width(),e.width-this.width()),this.width()>e.width)throw Error("Resizing to smaller array")}outOfBound(e,t){return e<0||t<0||t>this.size.height-1||e>this.size.width-1}}class Gt{constructor(e,t){this.error=e,this.size=t}get(e,t){return this.error}width(){return this.size.width}height(){return this.size.height}simpleRangeValue(){return this.error}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class jt{constructor(e,t,r){this.formula=e,this.cellAddress=t,this.version=r}get width(){return 1}get height(){return 1}static fromAst(e,t,r,n){return r.isScalar()?new $t(e,t,n):new zt(e,t,r,n)}getFormula(e){return this.ensureRecentData(e),this.formula}ensureRecentData(e){if(this.version!=e.version()){const[t,r,n]=e.applyTransformations(this.formula,this.cellAddress,this.version);this.formula=t,this.cellAddress=r,this.version=n}}getAddress(e){return this.ensureRecentData(e),this.cellAddress}}class zt extends jt{constructor(e,t,r,n=0){super(e,t,n),r.isRef?this.array=new Gt(new Tr(ir.REF,Z.NoSpaceForArrayResult),cn.error()):this.array=new Wt(r)}get width(){return this.array.width()}get height(){return this.array.height()}get sheet(){return this.cellAddress.sheet}get leftCorner(){return this.cellAddress}setCellValue(e){if(e instanceof Tr)return this.setErrorValue(e),e;const t=Yt.fromInterpreterValue(e);return t.resize(this.array.size),this.array=t,e}getCellValue(){if(this.array instanceof Wt)throw Error("Array not computed yet.");return this.array.simpleRangeValue()}valueOrUndef(){if(!(this.array instanceof Wt))return this.array.simpleRangeValue()}getArrayCellValue(e){const t=e.col-this.cellAddress.col,r=e.row-this.cellAddress.row;try{return this.array.get(t,r)}catch(e){return new Tr(ir.REF)}}getArrayCellRawValue(e){const t=this.getArrayCellValue(e);return t instanceof Tr||t===Ye?void 0:Ge(t)}setArrayCellValue(e,t){const r=e.col-this.cellAddress.col,n=e.row-this.cellAddress.row;this.array instanceof Yt&&this.array.set(r,n,t)}setNoSpace(){return this.array=new Gt(new Tr(ir.SPILL,Z.NoSpaceForArrayResult),cn.error()),this.getCellValue()}getRange(){return Fr.spanFrom(this.cellAddress,this.width,this.height)}getRangeOrUndef(){return Fr.spanFromOrUndef(this.cellAddress,this.width,this.height)}setAddress(e){this.cellAddress=e}setFormula(e){this.formula=e}spansThroughSheetRows(e,t,r=t){return this.cellAddress.sheet===e&&this.cellAddress.row<=r&&t<this.cellAddress.row+this.height}spansThroughSheetColumn(e,t,r=t){return this.cellAddress.sheet===e&&this.cellAddress.col<=r&&t<this.cellAddress.col+this.width}isComputed(){return!(this.array instanceof Wt)}columnsFromArray(){return it.fromNumberOfColumns(this.cellAddress.sheet,this.cellAddress.col,this.width)}rowsFromArray(){return st.fromNumberOfRows(this.cellAddress.sheet,this.cellAddress.row,this.height)}ensureRecentData(e){}isLeftCorner(e){return Dr(this.cellAddress,e)}setErrorValue(e){this.array=new Gt(e,this.array.size)}}class $t extends jt{constructor(e,t,r){super(e,t,r)}valueOrUndef(){return this.cachedCellValue}setCellValue(e){return this.cachedCellValue=e,this.cachedCellValue}getCellValue(){if(void 0!==this.cachedCellValue)return this.cachedCellValue;throw Error("Value of the formula cell is not computed.")}isComputed(){return void 0!==this.cachedCellValue}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Kt{constructor(e){this.range=e,this.functionCache=new Map,this.criterionFunctionCache=new Map,this.dependentCacheRanges=new Set,this.bruteForce=!1}get start(){return this.range.start}get end(){return this.range.end}get sheet(){return this.range.start.sheet}getFunctionValue(e){return this.functionCache.get(e)}setFunctionValue(e,t){this.functionCache.set(e,t)}getCriterionFunctionValue(e,t){var r;return null===(r=this.getCriterionFunctionValues(e).get(t))||void 0===r?void 0:r[0]}getCriterionFunctionValues(e){var t;return null!==(t=this.criterionFunctionCache.get(e))&&void 0!==t?t:new Map}setCriterionFunctionValues(e,t){this.criterionFunctionCache.set(e,t)}addDependentCacheRange(e){e!==this&&this.dependentCacheRanges.add(e)}clearCache(){this.functionCache.clear(),this.criterionFunctionCache.clear(),this.dependentCacheRanges.forEach((e=>e.criterionFunctionCache.clear())),this.dependentCacheRanges.clear()}getStart(){return this.start}getEnd(){return this.end}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const Xt=(e,t,r,n,s)=>{if(t instanceof Kt){const e=t.range.intersectionWith(r);return void 0!==e?Array.from(e.addresses(s)):[]}let i,o;return t instanceof jt?(i=t.getFormula(n),o=t.getAddress(n),ke(i,e).filter((e=>e instanceof He)).map((e=>e.dependency.toSimpleCellAddress(o))).filter((e=>r.addressInRange(e)))):[]};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
var qt;!function(e){e[e.ON_STACK=0]="ON_STACK",e[e.PROCESSED=1]="PROCESSED",e[e.POPPED=2]="POPPED"}(qt||(qt={}));class Qt{constructor(e=[],t=[]){this.nodesSparseArray=e,this.edgesSparseArray=t,this.entranceTime=[],this.low=[],this.parent=[],this.inSCC=[],this.nodeStatus=[],this.order=[],this.sccNonSingletons=[],this.timeCounter=0}getTopSortedWithSccSubgraphFrom(e,t,r){const n=e.reverse();return n.forEach((e=>this.runDFS(e))),this.postprocess(n,r,t)}getAdjacentNodeIds(e){return this.edgesSparseArray[e].filter((e=>void 0!==e&&this.nodesSparseArray[e]))}runDFS(e){if(void 0!==this.nodeStatus[e])return;this.nodeStatus[e]=qt.ON_STACK;const t=[e],r=[];for(;t.length>0;){const e=t[t.length-1];switch(this.nodeStatus[e]){case qt.ON_STACK:this.handleOnStack(e,r,t);break;case qt.PROCESSED:this.handleProcessed(e,r,t);break;case qt.POPPED:t.pop()}}}handleOnStack(e,t,r){this.entranceTime[e]=this.timeCounter,this.low[e]=this.timeCounter,this.timeCounter++,t.push(e),this.getAdjacentNodeIds(e).forEach((t=>{void 0===this.entranceTime[t]&&(r.push(t),this.parent[t]=e,this.nodeStatus[t]=qt.ON_STACK)})),this.nodeStatus[e]=qt.PROCESSED}handleProcessed(e,t,r){let n=this.entranceTime[e];if(this.getAdjacentNodeIds(e).forEach((t=>{this.inSCC[t]||(n=this.parent[t]===e?Math.min(n,this.low[t]):Math.min(n,this.entranceTime[t]))})),this.low[e]=n,n===this.entranceTime[e]){const r=[];do{r.push(t[t.length-1]),t.pop()}while(r[r.length-1]!==e);r.forEach((e=>{this.inSCC[e]=!0})),this.order.push(...r),r.length>1&&r.forEach((e=>{this.sccNonSingletons[e]=!0}))}r.pop(),this.nodeStatus[e]=qt.POPPED}postprocess(e,t,r){const n=[];e.forEach((e=>{n[e]=!0}));const s=[],i=[];return this.order.reverse(),this.order.forEach((e=>{const o=this.getAdjacentNodeIds(e);this.sccNonSingletons[e]||o.includes(e)?(i.push(this.nodesSparseArray[e]),t(this.nodesSparseArray[e]),o.forEach((e=>n[e]=!0))):(s.push(this.nodesSparseArray[e]),n[e]&&r(this.nodesSparseArray[e])&&o.forEach((e=>n[e]=!0)))})),{sorted:s,cycled:i}}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Zt{constructor(e,t){this.rawValue=e,this.processFn=t,this.processedValue=null}getProcessedValue(){return null===this.processedValue&&(this.processedValue=this.processFn(this.rawValue)),this.processedValue}markAsModified(){this.processedValue=null}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Jt{constructor(e){this.dependencyQuery=e,this.nodesSparseArray=[],this.edgesSparseArray=[],this.nodesIds=new Map,this.dirtyAndVolatileNodeIds=new Zt({dirty:[],volatile:[]},(e=>this.processDirtyAndVolatileNodeIds(e))),this.infiniteRangeIds=new Set,this.changingWithStructureNodeIds=[],this.nextId=0}getNodes(){return this.nodesSparseArray.filter((e=>void 0!==e))}hasNode(e){return this.nodesIds.has(e)}existsEdge(e,t){const r=this.getNodeId(e),n=this.getNodeId(t);return void 0!==r&&void 0!==n&&this.edgesSparseArray[r].includes(n)}adjacentNodes(e){const t=this.getNodeId(e);if(void 0===t)throw this.missingNodeError(e);return new Set(this.edgesSparseArray[t].filter((e=>void 0!==e)).map((e=>this.nodesSparseArray[e])))}adjacentNodesCount(e){const t=this.getNodeId(e);if(void 0===t)throw this.missingNodeError(e);return this.fixEdgesArrayForNode(t).length}addNodeAndReturnId(e){const t=this.nodesIds.get(e);if(void 0!==t)return t;const r=this.nextId;return this.nextId++,this.nodesSparseArray[r]=e,this.edgesSparseArray[r]=[],this.nodesIds.set(e,r),r}addEdge(e,t){const r=this.getNodeIdIfNotNumber(e),n=this.getNodeIdIfNotNumber(t);if(void 0===r)throw this.missingNodeError(e);if(void 0===n)throw this.missingNodeError(t);this.edgesSparseArray[r].includes(n)||this.edgesSparseArray[r].push(n)}removeNode(e){const t=this.getNodeId(e);if(void 0===t)throw this.missingNodeError(e);this.edgesSparseArray[t].length>0&&(this.edgesSparseArray[t].forEach((e=>this.dirtyAndVolatileNodeIds.rawValue.dirty.push(e))),this.dirtyAndVolatileNodeIds.markAsModified());const r=this.removeDependencies(e);return delete this.nodesSparseArray[t],delete this.edgesSparseArray[t],this.infiniteRangeIds.delete(t),this.nodesIds.delete(e),r}removeEdge(e,t){const r=this.getNodeIdIfNotNumber(e),n=this.getNodeIdIfNotNumber(t);if(void 0===r)throw this.missingNodeError(e);if(void 0===n)throw this.missingNodeError(t);const s=this.edgesSparseArray[r].indexOf(n);if(-1===s)throw new Error("Edge does not exist");delete this.edgesSparseArray[r][s]}removeEdgeIfExists(e,t){const r=this.getNodeId(e),n=this.getNodeId(t);if(void 0===r)return;if(void 0===n)return;const s=this.edgesSparseArray[r].indexOf(n);-1!==s&&delete this.edgesSparseArray[r][s]}topSortWithScc(){return this.getTopSortedWithSccSubgraphFrom(this.getNodes(),(()=>!0),(()=>{}))}getTopSortedWithSccSubgraphFrom(e,t,r){const n=new Qt(this.nodesSparseArray,this.edgesSparseArray),s=e.map((e=>this.getNodeId(e))).filter((e=>void 0!==e));return n.getTopSortedWithSccSubgraphFrom(s,t,r)}markNodeAsVolatile(e){const t=this.getNodeId(e);void 0!==t&&(this.dirtyAndVolatileNodeIds.rawValue.volatile.push(t),this.dirtyAndVolatileNodeIds.markAsModified())}markNodeAsDirty(e){const t=this.getNodeId(e);void 0!==t&&(this.dirtyAndVolatileNodeIds.rawValue.dirty.push(t),this.dirtyAndVolatileNodeIds.markAsModified())}getDirtyAndVolatileNodes(){return this.dirtyAndVolatileNodeIds.getProcessedValue()}clearDirtyNodes(){this.dirtyAndVolatileNodeIds.rawValue.dirty=[],this.dirtyAndVolatileNodeIds.markAsModified()}markNodeAsChangingWithStructure(e){const t=this.getNodeId(e);void 0!==t&&this.changingWithStructureNodeIds.push(t)}markChangingWithStructureNodesAsDirty(){this.changingWithStructureNodeIds.length<=0||(this.dirtyAndVolatileNodeIds.rawValue.dirty=[...this.dirtyAndVolatileNodeIds.rawValue.dirty,...this.changingWithStructureNodeIds],this.dirtyAndVolatileNodeIds.markAsModified())}markNodeAsInfiniteRange(e){const t=this.getNodeIdIfNotNumber(e);void 0!==t&&this.infiniteRangeIds.add(t)}getInfiniteRanges(){return[...this.infiniteRangeIds].map((e=>({node:this.nodesSparseArray[e],id:e})))}getNodeId(e){return this.nodesIds.get(e)}getNodeIdIfNotNumber(e){return"number"==typeof e?e:this.nodesIds.get(e)}fixEdgesArrayForNode(e){const t=this.edgesSparseArray[e];return this.edgesSparseArray[e]=t.filter((e=>void 0!==e&&this.nodesSparseArray[e])),this.edgesSparseArray[e]}removeDependencies(e){const t=this.dependencyQuery(e);return t.forEach((([t,r])=>{this.removeEdgeIfExists(r,e)})),t}processDirtyAndVolatileNodeIds({dirty:e,volatile:t}){return[...new Set([...e,...t])].map((e=>this.nodesSparseArray[e])).filter((e=>void 0!==e))}missingNodeError(e){return new Error(`Unknown node ${e}`)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class er{constructor(){this.rangeMapping=new Map}getMappingSize(e){var t,r;return null!==(r=null===(t=this.rangeMapping.get(e))||void 0===t?void 0:t.size)&&void 0!==r?r:0}setRange(e){let t=this.rangeMapping.get(e.getStart().sheet);void 0===t&&(t=new Map,this.rangeMapping.set(e.getStart().sheet,t));const r=tr(e.getStart(),e.getEnd());t.set(r,e)}removeRange(e){const t=e.getStart().sheet,r=this.rangeMapping.get(t);if(void 0===r)return;const n=tr(e.getStart(),e.getEnd());r.delete(n),0===r.size&&this.rangeMapping.delete(t)}getRange(e,t){const r=this.rangeMapping.get(e.sheet),n=tr(e,t);return null==r?void 0:r.get(n)}fetchRange(e,t){const r=this.getRange(e,t);if(!r)throw Error("Range does not exist");return r}truncateRanges(e,t){const r=Array(),n=Array(),s=Array(),i=e.sheet;for(const[o,a]of this.entriesFromSheet(e.sheet)){const l=a.range;e.start<=t(a.range.end)&&(l.removeSpan(e),l.shouldBeRemoved()?(this.removeByKey(i,o),r.push(a)):n.push([o,a]),s.push(a))}const o=[];n.sort(((e,r)=>rr(e[1],r[1],t)));for(const[e,t]of n){const r=tr((a=t.range).start,a.end);if(r===e)continue;const n=this.getByKey(i,r);this.removeByKey(i,e),void 0!==n&&t!=n?o.push([n,t]):this.setRange(t)}var a;return{verticesToRemove:r,verticesToMerge:o,verticesWithChangedSize:s}}moveAllRangesInSheetAfterRowByRows(e,t,r){return this.updateVerticesFromSheet(e,((e,n)=>t<=n.start.row?(n.range.shiftByRows(r),{changedSize:!1,vertex:n}):t>n.start.row&&t<=n.end.row?(n.range.expandByRows(r),{changedSize:!0,vertex:n}):void 0))}moveAllRangesInSheetAfterColumnByColumns(e,t,r){return this.updateVerticesFromSheet(e,((e,n)=>t<=n.start.col?(n.range.shiftByColumns(r),{changedSize:!1,vertex:n}):t>n.start.col&&t<=n.end.col?(n.range.expandByColumns(r),{changedSize:!0,vertex:n}):void 0))}moveRangesInsideSourceRange(e,t,r,n){this.updateVerticesFromSheet(e.sheet,((s,i)=>e.containsRange(i.range)?(i.range.shiftByColumns(t),i.range.shiftByRows(r),i.range.moveToSheet(n),{changedSize:!1,vertex:i}):void 0))}removeRangesInSheet(e){if(this.rangeMapping.has(e)){const t=this.rangeMapping.get(e).values();return this.rangeMapping.delete(e),t}return[][Symbol.iterator]()}*rangesInSheet(e){const t=this.rangeMapping.get(e);t&&(yield*t.values())}*rangeVerticesContainedInRange(e){for(const t of this.rangesInSheet(e.sheet))e.containsRange(t.range)&&(yield t)}findSmallerRange(e){if(e.height()>1&&Number.isFinite(e.height())){const t=Ar(e.end.sheet,e.end.col,e.end.row-1),r=this.getRange(e.start,t);if(void 0!==r){return{smallerRangeVertex:r,restRange:Fr.fromSimpleCellAddresses(Ar(e.start.sheet,e.start.col,e.end.row),e.end)}}}return{restRange:e}}*entriesFromSheet(e){const t=this.rangeMapping.get(e);t&&(yield*t.entries())}removeByKey(e,t){this.rangeMapping.get(e).delete(t)}getByKey(e,t){var r;return null===(r=this.rangeMapping.get(e))||void 0===r?void 0:r.get(t)}updateVerticesFromSheet(e,t){const r=Array();for(const[n,s]of this.entriesFromSheet(e)){const i=t(n,s);void 0!==i&&(this.removeByKey(e,n),r.push(i))}return r.forEach((e=>{this.setRange(e.vertex)})),{verticesWithChangedSize:r.filter((e=>e.changedSize)).map((e=>e.vertex))}}}function tr(e,t){return`${e.col},${e.row},${t.col},${t.row}`}const rr=(e,t,r)=>{const n=r(e.range.start),s=r(e.range.start);if(n===s){return r(e.range.end)-r(t.range.end)}return n-s};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class nr{constructor(e,t,r){this.functions=e,this.errors=t,this.ui=r,this._protectedTranslations={VERSION:"VERSION"},this.checkUI(),this.checkErrors(),this.checkFunctionTranslations(this.functions),Object.assign(this.functions,this._protectedTranslations)}extendFunctions(e){this.checkFunctionTranslations(e),Object.assign(this.functions,e)}buildFunctionMapping(){return Object.keys(this.functions).reduce(((e,t)=>(e[this.functions[t]]=t,e)),{})}buildErrorMapping(){return Object.keys(this.errors).reduce(((e,t)=>(e[this.errors[t]]=t,e)),{})}isFunctionTranslated(e){return void 0!==this.functions[e]}getFunctionTranslations(e){const t=[];for(const r of e)this.isFunctionTranslated(r)&&t.push(this.functions[r]);return t}getFunctionTranslation(e){const t=this.functions[e];if(void 0===t)throw new Ot(`functions.${e}`);return t}getMaybeFunctionTranslation(e){return this.functions[e]}getErrorTranslation(e){if(e===ir.LIC)return`#${ir.LIC}!`;const t=this.errors[e];if(void 0===t)throw new Ot(`errors.${e}`);return t}getUITranslation(e){const t=this.ui[e];if(void 0===t)throw new Ot(`ui.${e}`);return t}checkUI(){for(const e of Object.values(sr))if(!(e in this.ui))throw new Ot(`ui.${e}`)}checkErrors(){for(const e of Object.values(ir))if(!(e in this.errors)&&e!==ir.LIC)throw new Ot(`errors.${e}`)}checkFunctionTranslations(e){const t=new Set(Object.getOwnPropertyNames(e));for(const e of Object.getOwnPropertyNames(this._protectedTranslations))if(t.has(e))throw new It(e)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
var sr,ir,or;
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function ar(e){return e.toLowerCase()}!function(e){e.NEW_SHEET_PREFIX="NEW_SHEET_PREFIX"}(sr||(sr={}));class lr{constructor(e,t){this.id=e,this.displayName=t}get canonicalName(){return ar(this.displayName)}}class hr{constructor(e){this.languages=e,this.mappingFromCanonicalName=new Map,this.mappingFromId=new Map,this.lastSheetId=-1,this.fetch=e=>{const t=this.mappingFromCanonicalName.get(ar(e));if(void 0===t)throw new ht(e);return t.id},this.get=e=>{var t;return null===(t=this.mappingFromCanonicalName.get(ar(e)))||void 0===t?void 0:t.id},this.fetchDisplayName=e=>this.fetchSheetById(e).displayName,this.sheetNamePrefix=e.getUITranslation(sr.NEW_SHEET_PREFIX)}addSheet(e=`${this.sheetNamePrefix}${this.lastSheetId+2}`){const t=ar(e);if(this.mappingFromCanonicalName.has(t))throw new ut(e);this.lastSheetId++;const r=new lr(this.lastSheetId,e);return this.store(r),r.id}removeSheet(e){const t=this.fetchSheetById(e);e==this.lastSheetId&&--this.lastSheetId,this.mappingFromCanonicalName.delete(t.canonicalName),this.mappingFromId.delete(t.id)}getDisplayName(e){var t;return null===(t=this.mappingFromId.get(e))||void 0===t?void 0:t.displayName}*displayNames(){for(const e of this.mappingFromCanonicalName.values())yield e.displayName}numberOfSheets(){return this.mappingFromCanonicalName.size}hasSheetWithId(e){return this.mappingFromId.has(e)}hasSheetWithName(e){return this.mappingFromCanonicalName.has(ar(e))}renameSheet(e,t){const r=this.fetchSheetById(e),n=r.displayName;if(n===t)return;const s=this.mappingFromCanonicalName.get(ar(t));if(void 0!==s&&s.id!==r.id)throw new ut(t);const i=r.canonicalName;return this.mappingFromCanonicalName.delete(i),r.displayName=t,this.store(r),n}sheetNames(){return Array.from(this.mappingFromId.values()).map((e=>e.displayName))}store(e){this.mappingFromId.set(e.id,e),this.mappingFromCanonicalName.set(e.canonicalName,e)}fetchSheetById(e){const t=this.mappingFromId.get(e);if(void 0===t)throw new lt(e);return t}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ur{constructor(e,t,r,n,s,i,o,a){this.addressMapping=e,this.rangeMapping=t,this.sheetMapping=r,this.arrayMapping=n,this.stats=s,this.lazilyTransformingAstService=i,this.functionRegistry=o,this.namedExpressions=a,this.changes=nt.empty(),this.dependencyQueryAddresses=e=>{if(e instanceof Kt)return this.rangeDependencyQuery(e).map((([e,t])=>e));{const t=this.formulaDependencyQuery(e);if(void 0!==t){const[e,r]=t;return r.map((t=>t instanceof Be?this.namedExpressions.namedExpressionOrPlaceholder(t.name,e.sheet).address:Pr(t)?t:Hr(t.start,t.end)))}return[]}},this.dependencyQueryVertices=e=>{if(e instanceof Kt)return this.rangeDependencyQuery(e);{const t=this.formulaDependencyQuery(e);if(void 0!==t){const[e,r]=t;return r.map((t=>{if(t instanceof Fr)return[t.start,this.rangeMapping.fetchRange(t.start,t.end)];if(t instanceof Be){const r=this.namedExpressions.namedExpressionOrPlaceholder(t.name,e.sheet);return[r.address,this.addressMapping.fetchCell(r.address)]}return[t,this.addressMapping.fetchCell(t)]}))}return[]}},this.rangeDependencyQuery=e=>{const t=[],{smallerRangeVertex:r,restRange:n}=this.rangeMapping.findSmallerRange(e.range);let s;void 0!==r&&this.graph.adjacentNodes(r).has(e)?(s=n,t.push([new Fr(r.start,r.end),r])):s=e.range;for(const e of s.addresses(this)){const r=this.addressMapping.getCell(e);void 0!==r&&t.push([e,r])}return t},this.formulaDependencyQuery=e=>{let t,r;if(!(e instanceof jt))return;r=e.getAddress(this.lazilyTransformingAstService),t=e.getFormula(this.lazilyTransformingAstService);const n=ke(t,this.functionRegistry);return[r,We(n,r)]},this.graph=new Jt(this.dependencyQueryVertices)}static buildEmpty(e,t,r,n,s){return new ur(new Vt(t.chooseAddressMappingPolicy),new er,new hr(t.translationPackage),new Bt,s,e,r,n)}setFormulaToCell(e,t,r,n,s,i){const o=jt.fromAst(t,e,n,this.lazilyTransformingAstService.version());return this.exchangeOrAddFormulaVertex(o),this.processCellDependencies(r,o),this.graph.markNodeAsDirty(o),s&&this.markAsVolatile(o),i&&this.markAsDependentOnStructureChange(o),this.correctInfiniteRangesDependency(e),this.getAndClearContentChanges()}setParsingErrorToCell(e,t){const r=this.shrinkPossibleArrayAndGetCell(e);return this.exchangeOrAddGraphNode(r,t),this.addressMapping.setCell(e,t),this.graph.markNodeAsDirty(t),this.correctInfiniteRangesDependency(e),this.getAndClearContentChanges()}setValueToCell(e,t){const r=this.shrinkPossibleArrayAndGetCell(e);if(r instanceof zt&&this.arrayMapping.removeArray(r.getRange()),r instanceof dr){r.getValues().rawValue!==t.rawValue&&(r.setValues(t),this.graph.markNodeAsDirty(r))}else{const n=new dr(t.parsedValue,t.rawValue);this.exchangeOrAddGraphNode(r,n),this.addressMapping.setCell(e,n),this.graph.markNodeAsDirty(n)}return this.correctInfiniteRangesDependency(e),this.getAndClearContentChanges()}setCellEmpty(e){const t=this.shrinkPossibleArrayAndGetCell(e);if(void 0===t)return nt.empty();if(this.graph.adjacentNodes(t).size>0){const r=new cr;this.exchangeGraphNode(t,r),0===this.graph.adjacentNodesCount(r)?(this.removeVertex(r),this.addressMapping.removeCell(e)):(this.graph.markNodeAsDirty(r),this.addressMapping.setCell(e,r))}else this.removeVertex(t),this.addressMapping.removeCell(e);return this.getAndClearContentChanges()}clearDirtyVertices(){this.graph.clearDirtyNodes()}verticesToRecompute(){return this.graph.getDirtyAndVolatileNodes()}processCellDependencies(e,t){const r=this.graph.getNodeId(t);e.forEach((e=>{if(e instanceof Fr){const t=e;let n=this.getRange(t.start,t.end);void 0===n&&(n=new Kt(t),this.rangeMapping.setRange(n)),this.graph.addNodeAndReturnId(n);const s=this.graph.getNodeId(n);t.isFinite()||this.graph.markNodeAsInfiniteRange(s);const{smallerRangeVertex:i,restRange:o}=this.rangeMapping.findSmallerRange(t);if(void 0!==i){if(this.graph.addEdge(i,s),n.bruteForce){n.bruteForce=!1;for(const e of t.addresses(this))this.graph.removeEdge(this.fetchCell(e),s)}}else n.bruteForce=!0;const a=this.arrayMapping.getArray(o);if(void 0!==a)this.graph.addEdge(a,s);else for(const e of o.addresses(this)){const{vertex:t,id:r}=this.fetchCellOrCreateEmpty(e);this.graph.addEdge(null!=r?r:t,s)}this.graph.addEdge(s,r),t.isFinite()&&this.correctInfiniteRangesDependenciesByRangeVertex(n)}else if(e instanceof Be){const n=t.getAddress(this.lazilyTransformingAstService).sheet,{vertex:s,id:i}=this.fetchNamedExpressionVertex(e.name,n);this.graph.addEdge(null!=i?i:s,r)}else{const{vertex:t,id:n}=this.fetchCellOrCreateEmpty(e);this.graph.addEdge(null!=n?n:t,r)}}))}fetchNamedExpressionVertex(e,t){const r=this.namedExpressions.namedExpressionOrPlaceholder(e,t);return this.fetchCellOrCreateEmpty(r.address)}exchangeNode(e,t){const r=this.fetchCellOrCreateEmpty(e).vertex,n=this.fetchCellOrCreateEmpty(t).vertex;this.addressMapping.removeCell(e),this.exchangeGraphNode(r,n)}fetchCellOrCreateEmpty(e){const t=this.addressMapping.getCell(e);if(void 0!==t)return{vertex:t,id:void 0};const r=new cr,n=this.graph.addNodeAndReturnId(r);return this.addressMapping.setCell(e,r),{vertex:r,id:n}}removeRows(e){this.stats.measure(et.ADJUSTING_GRAPH,(()=>{for(const[t,r]of this.addressMapping.entriesFromRowsSpan(e)){for(const e of this.graph.adjacentNodes(r))this.graph.markNodeAsDirty(e);if(r instanceof zt){if(!r.isLeftCorner(t))continue;this.shrinkArrayToCorner(r),this.arrayMapping.removeArray(r.getRange())}this.removeVertex(r)}})),this.stats.measure(et.ADJUSTING_ADDRESS_MAPPING,(()=>{this.addressMapping.removeRows(e)}));const t=this.stats.measure(et.ADJUSTING_RANGES,(()=>{const t=this.truncateRanges(e,(e=>e.row));return this.getArrayVerticesRelatedToRanges(t)}));return this.stats.measure(et.ADJUSTING_ARRAY_MAPPING,(()=>{this.fixArraysAfterRemovingRows(e.sheet,e.rowStart,e.numberOfRows)})),this.addStructuralNodesToChangeSet(),{affectedArrays:t,contentChanges:this.getAndClearContentChanges()}}removeSheet(e){this.clearSheet(e);for(const[t,r]of this.addressMapping.sheetEntries(e)){for(const e of this.graph.adjacentNodes(r))this.graph.markNodeAsDirty(e);this.removeVertex(r),this.addressMapping.removeCell(t)}this.stats.measure(et.ADJUSTING_RANGES,(()=>{const t=this.rangeMapping.removeRangesInSheet(e);for(const e of t)this.removeVertex(e);this.stats.measure(et.ADJUSTING_ADDRESS_MAPPING,(()=>{this.addressMapping.removeSheet(e)}))}))}clearSheet(e){const t=new Set;for(const[r,n]of this.addressMapping.sheetEntries(e))n instanceof zt?t.add(n):this.setCellEmpty(r);for(const e of t.values())this.setArrayEmpty(e);this.addStructuralNodesToChangeSet()}removeColumns(e){this.stats.measure(et.ADJUSTING_GRAPH,(()=>{for(const[t,r]of this.addressMapping.entriesFromColumnsSpan(e)){for(const e of this.graph.adjacentNodes(r))this.graph.markNodeAsDirty(e);if(r instanceof zt){if(!r.isLeftCorner(t))continue;this.shrinkArrayToCorner(r),this.arrayMapping.removeArray(r.getRange())}this.removeVertex(r)}})),this.stats.measure(et.ADJUSTING_ADDRESS_MAPPING,(()=>{this.addressMapping.removeColumns(e)}));const t=this.stats.measure(et.ADJUSTING_RANGES,(()=>{const t=this.truncateRanges(e,(e=>e.col));return this.getArrayVerticesRelatedToRanges(t)}));return this.stats.measure(et.ADJUSTING_ARRAY_MAPPING,(()=>this.fixArraysAfterRemovingColumns(e.sheet,e.columnStart,e.numberOfColumns))),this.addStructuralNodesToChangeSet(),{affectedArrays:t,contentChanges:this.getAndClearContentChanges()}}addRows(e){this.stats.measure(et.ADJUSTING_ADDRESS_MAPPING,(()=>{this.addressMapping.addRows(e.sheet,e.rowStart,e.numberOfRows)}));const t=this.stats.measure(et.ADJUSTING_RANGES,(()=>{const t=this.rangeMapping.moveAllRangesInSheetAfterRowByRows(e.sheet,e.rowStart,e.numberOfRows);return this.fixRangesWhenAddingRows(e.sheet,e.rowStart,e.numberOfRows),this.getArrayVerticesRelatedToRanges(t.verticesWithChangedSize)}));this.stats.measure(et.ADJUSTING_ARRAY_MAPPING,(()=>{this.fixArraysAfterAddingRow(e.sheet,e.rowStart,e.numberOfRows)}));for(const t of this.addressMapping.verticesFromRowsSpan(e))this.graph.markNodeAsDirty(t);return this.addStructuralNodesToChangeSet(),{affectedArrays:t}}addColumns(e){this.stats.measure(et.ADJUSTING_ADDRESS_MAPPING,(()=>{this.addressMapping.addColumns(e.sheet,e.columnStart,e.numberOfColumns)}));const t=this.stats.measure(et.ADJUSTING_RANGES,(()=>{const t=this.rangeMapping.moveAllRangesInSheetAfterColumnByColumns(e.sheet,e.columnStart,e.numberOfColumns);return this.fixRangesWhenAddingColumns(e.sheet,e.columnStart,e.numberOfColumns),this.getArrayVerticesRelatedToRanges(t.verticesWithChangedSize)}));this.stats.measure(et.ADJUSTING_ARRAY_MAPPING,(()=>this.fixArraysAfterAddingColumn(e.sheet,e.columnStart,e.numberOfColumns)));for(const t of this.addressMapping.verticesFromColumnsSpan(e))this.graph.markNodeAsDirty(t);return this.addStructuralNodesToChangeSet(),{affectedArrays:t,contentChanges:this.getAndClearContentChanges()}}isThereSpaceForArray(e){const t=e.getRangeOrUndef();if(void 0===t)return!1;for(const r of t.addresses(this)){const t=this.addressMapping.getCell(r);if(void 0!==t&&!(t instanceof cr)&&t!==e)return!1}return!0}moveCells(e,t,r,n){for(const s of e.addressesWithDirection(t,r,this)){const i=Ar(n,s.col+t,s.row+r);let o=this.addressMapping.getCell(s);const a=this.addressMapping.getCell(i);if(this.addressMapping.removeCell(s),void 0!==o){let t;this.graph.markNodeAsDirty(o),this.addressMapping.setCell(i,o);for(const r of this.graph.adjacentNodes(o))r instanceof Kt&&!e.containsRange(r.range)&&(t=null!=t?t:this.fetchCellOrCreateEmpty(s).vertex,this.graph.addEdge(t,r),this.graph.removeEdge(o,r));t&&(this.graph.markNodeAsDirty(t),this.addressMapping.setCell(s,t))}if(void 0!==a){void 0===o&&this.addressMapping.removeCell(i);for(const e of this.graph.adjacentNodes(a))o=null!=o?o:this.fetchCellOrCreateEmpty(i).vertex,this.graph.addEdge(o,e),this.graph.markNodeAsDirty(o);this.removeVertex(a)}}for(const t of this.rangeMapping.rangeVerticesContainedInRange(e))for(const r of this.graph.adjacentNodes(t))if(r instanceof Kt&&!e.containsRange(r.range)){this.graph.removeEdge(t,r);for(const e of t.range.addresses(this)){const{vertex:t,id:n}=this.fetchCellOrCreateEmpty(e);this.graph.addEdge(null!=n?n:t,r),this.addressMapping.setCell(e,t),this.graph.markNodeAsDirty(t)}}this.rangeMapping.moveRangesInsideSourceRange(e,t,r,n)}setArrayEmpty(e){const t=Fr.spanFrom(e.getAddress(this.lazilyTransformingAstService),e.width,e.height),r=this.graph.adjacentNodes(e);for(const e of t.addresses(this))this.addressMapping.removeCell(e);for(const t of r.values()){const r=Xt(this.functionRegistry,t,e.getRange(),this.lazilyTransformingAstService,this);for(const e of r){const{vertex:r,id:n}=this.fetchCellOrCreateEmpty(e);this.graph.addEdge(null!=n?n:r,t)}r.length>0&&this.graph.markNodeAsDirty(t)}this.removeVertex(e),this.arrayMapping.removeArray(e.getRange())}addVertex(e,t){this.graph.addNodeAndReturnId(t),this.addressMapping.setCell(e,t)}addArrayVertex(e,t){this.graph.addNodeAndReturnId(t),this.setAddressMappingForArrayVertex(t,e)}*arrayFormulaNodes(){for(const e of this.graph.getNodes())e instanceof zt&&(yield e)}*entriesFromRowsSpan(e){yield*this.addressMapping.entriesFromRowsSpan(e)}*entriesFromColumnsSpan(e){yield*this.addressMapping.entriesFromColumnsSpan(e)}fetchCell(e){return this.addressMapping.fetchCell(e)}getCell(e){return this.addressMapping.getCell(e)}getCellValue(e){return this.addressMapping.getCellValue(e)}getRawValue(e){return this.addressMapping.getRawValue(e)}getScalarValue(e){const t=this.addressMapping.getCellValue(e);return t instanceof rt?new Tr(ir.VALUE,Z.ScalarExpected):t}existsEdge(e,t){return this.graph.existsEdge(e,t)}getSheetId(e){return this.sheetMapping.fetch(e)}getSheetHeight(e){return this.addressMapping.getHeight(e)}getSheetWidth(e){return this.addressMapping.getWidth(e)}getArray(e){return this.arrayMapping.getArray(e)}getRange(e,t){return this.rangeMapping.getRange(e,t)}topSortWithScc(){return this.graph.topSortWithScc()}markAsVolatile(e){this.graph.markNodeAsVolatile(e)}markAsDependentOnStructureChange(e){this.graph.markNodeAsChangingWithStructure(e)}forceApplyPostponedTransformations(){for(const e of this.graph.getNodes())e instanceof $t&&e.ensureRecentData(this.lazilyTransformingAstService)}*rawValuesFromRange(e){for(const t of e.addresses(this)){const e=this.getScalarValue(t);e!==Ye&&(yield[Ge(e),t])}}computeListOfValuesInRange(e){const t=[];for(const r of e.addresses(this)){const e=this.getScalarValue(r);t.push(e)}return t}shrinkArrayToCorner(e){this.cleanAddressMappingUnderArray(e);for(const t of this.adjacentArrayVertices(e)){let r;r=t instanceof jt?this.formulaDirectDependenciesToArray(t,e):this.rangeDirectDependenciesToArray(t,e);let n=!1;for(const[s,i]of r)e.isLeftCorner(s)&&(n=!0),this.graph.addEdge(i,t),this.graph.markNodeAsDirty(i);n||this.graph.removeEdge(e,t)}this.graph.markNodeAsDirty(e)}isArrayInternalCell(e){const t=this.getCell(e);return t instanceof zt&&!t.isLeftCorner(e)}getAndClearContentChanges(){const e=this.changes;return this.changes=nt.empty(),e}getAdjacentNodesAddresses(e){const t=this.graph.adjacentNodes(e),r=[];return t.forEach((e=>{const t=e;t instanceof Kt?r.push(Hr(t.start,t.end)):r.push(t.getAddress(this.lazilyTransformingAstService))})),r}exchangeGraphNode(e,t){this.graph.addNodeAndReturnId(t);const r=this.graph.adjacentNodes(e);this.removeVertex(e),r.forEach((e=>{this.graph.hasNode(e)&&this.graph.addEdge(t,e)}))}setArray(e,t){this.arrayMapping.setArray(e,t)}correctInfiniteRangesDependency(e){const t=this.graph.getInfiniteRanges().filter((({node:t})=>t.range.addressInRange(e)));if(t.length<=0)return;const{vertex:r,id:n}=this.fetchCellOrCreateEmpty(e),s=null!=n?n:this.graph.getNodeId(r);t.forEach((({id:e})=>{this.graph.addEdge(s,e)}))}exchangeOrAddGraphNode(e,t){e?this.exchangeGraphNode(e,t):this.graph.addNodeAndReturnId(t)}getArrayVerticesRelatedToRanges(e){const t=new Set;return e.forEach((e=>{this.graph.hasNode(e)&&this.graph.adjacentNodes(e).forEach((e=>{e instanceof zt&&t.add(e)}))})),t}correctInfiniteRangesDependenciesByRangeVertex(e){this.graph.getInfiniteRanges().forEach((({id:t,node:r})=>{const n=e.range.intersectionWith(r.range);void 0!==n&&n.addresses(this).forEach((e=>{const{vertex:r,id:n}=this.fetchCellOrCreateEmpty(e);this.graph.addEdge(null!=n?n:r,t)}))}))}cleanAddressMappingUnderArray(e){const t=e.getRange();for(const r of t.addresses(this)){const t=e.getArrayCellValue(r);this.getCell(r)===e?e.isLeftCorner(r)?this.changes.addChange(new Tr(ir.REF),r,t):(this.addressMapping.removeCell(r),this.changes.addChange(Ye,r,t)):this.changes.addChange(Ye,r,t)}}*formulaDirectDependenciesToArray(e,t){var r;const[,n]=null!==(r=this.formulaDependencyQuery(e))&&void 0!==r?r:[];if(void 0!==n)for(const e of n)if(!(e instanceof Be||e instanceof Fr)&&t.getRange().addressInRange(e)){const t=this.fetchCellOrCreateEmpty(e).vertex;yield[e,t]}}*rangeDirectDependenciesToArray(e,t){const{restRange:r}=this.rangeMapping.findSmallerRange(e.range);for(const e of r.addresses(this))if(t.getRange().addressInRange(e)){const t=this.fetchCellOrCreateEmpty(e).vertex;yield[e,t]}}*adjacentArrayVertices(e){const t=this.graph.adjacentNodes(e);for(const e of t)(e instanceof jt||e instanceof Kt)&&(yield e)}addStructuralNodesToChangeSet(){this.graph.markChangingWithStructureNodesAsDirty()}fixRangesWhenAddingRows(e,t,r){const n=Array.from(this.rangeMapping.rangesInSheet(e));for(const e of n)if(e.range.includesRow(t+r))if(e.bruteForce){const n=e.range.rangeWithSameWidth(t,r);for(const t of n.addresses(this)){const{vertex:r,id:n}=this.fetchCellOrCreateEmpty(t);this.graph.addEdge(null!=n?n:r,e)}}else{let t=e,r=this.rangeMapping.findSmallerRange(t.range);if(void 0!==r.smallerRangeVertex)continue;for(;void 0===r.smallerRangeVertex;){const e=new Kt(Fr.spanFrom(t.range.start,t.range.width(),t.range.height()-1));this.rangeMapping.setRange(e),this.graph.addNodeAndReturnId(e);const n=new Fr(Ar(t.range.start.sheet,t.range.start.col,t.range.end.row),t.range.end);this.addAllFromRange(n,t),this.graph.addEdge(e,t),t=e,r=this.rangeMapping.findSmallerRange(t.range)}this.graph.addEdge(r.smallerRangeVertex,t),this.addAllFromRange(r.restRange,t),this.graph.removeEdge(r.smallerRangeVertex,e)}}addAllFromRange(e,t){for(const r of e.addresses(this)){const{vertex:e,id:n}=this.fetchCellOrCreateEmpty(r);this.graph.addEdge(null!=n?n:e,t)}}fixRangesWhenAddingColumns(e,t,r){for(const n of this.rangeMapping.rangesInSheet(e))if(n.range.includesColumn(t+r)){let s;s=n.bruteForce?n.range.rangeWithSameHeight(t,r):Fr.spanFrom(Ar(e,t,n.range.end.row),r,1);for(const e of s.addresses(this)){const{vertex:t,id:r}=this.fetchCellOrCreateEmpty(e);this.graph.addEdge(null!=r?r:t,n)}}}exchangeOrAddFormulaVertex(e){const t=e.getAddress(this.lazilyTransformingAstService),r=Fr.spanFrom(t,e.width,e.height),n=this.shrinkPossibleArrayAndGetCell(t);if(e instanceof zt&&this.setArray(r,e),this.exchangeOrAddGraphNode(n,e),this.addressMapping.setCell(t,e),e instanceof zt){if(!this.isThereSpaceForArray(e))return;for(const t of r.addresses(this)){if(e.isLeftCorner(t))continue;const r=this.getCell(t);this.exchangeOrAddGraphNode(r,e)}}for(const t of r.addresses(this))this.addressMapping.setCell(t,e)}setAddressMappingForArrayVertex(e,t){if(this.addressMapping.setCell(t,e),!(e instanceof zt))return;const r=Fr.spanFromOrUndef(t,e.width,e.height);if(void 0!==r&&(this.setArray(r,e),this.isThereSpaceForArray(e)))for(const t of r.addresses(this))this.addressMapping.setCell(t,e)}truncateRanges(e,t){const{verticesToRemove:r,verticesToMerge:n,verticesWithChangedSize:s}=this.rangeMapping.truncateRanges(e,t);for(const[e,t]of n)this.mergeRangeVertices(e,t);for(const e of r)this.removeVertexAndCleanupDependencies(e);return s}fixArraysAfterAddingRow(e,t,r){if(this.arrayMapping.moveArrayVerticesAfterRowByRows(e,t,r),!(t<=0))for(const[,n]of this.arrayMapping.arraysInRows(st.fromRowStartAndEnd(e,t-1,t-1))){const s=n.getRange();for(let i=s.start.col;i<=s.end.col;++i)for(let o=t;o<=s.end.row;++o){const t=Ar(e,i,o),s=Ar(e,i,o+r),a=n.getArrayCellValue(t);this.addressMapping.moveCell(s,t),this.changes.addChange(Ye,s,a)}}}fixArraysAfterRemovingRows(e,t,r){if(this.arrayMapping.moveArrayVerticesAfterRowByRows(e,t,-r),!(t<=0))for(const[,r]of this.arrayMapping.arraysInRows(st.fromRowStartAndEnd(e,t-1,t-1)))if(this.isThereSpaceForArray(r))for(const e of r.getRange().addresses(this))this.addressMapping.setCell(e,r);else this.setNoSpaceIfArray(r)}fixArraysAfterAddingColumn(e,t,r){if(this.arrayMapping.moveArrayVerticesAfterColumnByColumns(e,t,r),!(t<=0))for(const[,n]of this.arrayMapping.arraysInCols(it.fromColumnStartAndEnd(e,t-1,t-1))){const s=n.getRange();for(let i=s.start.row;i<=s.end.row;++i)for(let o=t;o<=s.end.col;++o){const t=Ar(e,o,i),s=Ar(e,o+r,i),a=n.getArrayCellValue(t);this.addressMapping.moveCell(s,t),this.changes.addChange(Ye,s,a)}}}fixArraysAfterRemovingColumns(e,t,r){if(this.arrayMapping.moveArrayVerticesAfterColumnByColumns(e,t,-r),!(t<=0))for(const[,r]of this.arrayMapping.arraysInCols(it.fromColumnStartAndEnd(e,t-1,t-1)))if(this.isThereSpaceForArray(r))for(const e of r.getRange().addresses(this))this.addressMapping.setCell(e,r);else this.setNoSpaceIfArray(r)}shrinkPossibleArrayAndGetCell(e){const t=this.getCell(e);return t instanceof zt?(this.setNoSpaceIfArray(t),this.getCell(e)):t}setNoSpaceIfArray(e){e instanceof zt&&(this.shrinkArrayToCorner(e),e.setNoSpace())}removeVertex(e){this.removeVertexAndCleanupDependencies(e),e instanceof Kt&&this.rangeMapping.removeRange(e)}mergeRangeVertices(e,t){const r=this.graph.adjacentNodes(t);this.removeVertexAndCleanupDependencies(t),this.graph.removeEdgeIfExists(e,t),r.forEach((t=>{this.graph.hasNode(t)&&this.graph.addEdge(e,t)}))}removeVertexAndCleanupDependencies(e){const t=new Set(this.graph.removeNode(e));for(;t.size>0;){const e=t.values().next().value;t.delete(e);const[r,n]=e;this.graph.hasNode(n)&&0===this.graph.adjacentNodesCount(n)&&((n instanceof Kt||n instanceof cr)&&this.graph.removeNode(n).forEach((e=>t.add(e))),n instanceof Kt?this.rangeMapping.removeRange(n):n instanceof cr&&this.addressMapping.removeCell(r))}}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class cr{constructor(){}getCellValue(){return Ye}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class dr{constructor(e,t){this.parsedValue=e,this.rawValue=t}getValues(){return{parsedValue:this.parsedValue,rawValue:this.rawValue}}setValues(e){this.parsedValue=e.parsedValue,this.rawValue=e.rawValue}getCellValue(){return this.parsedValue}setCellValue(e){throw Error("SetCellValue is deprecated for ValueCellVertex")}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class pr{constructor(e,t){this.errors=e,this.rawInput=t}getCellValue(){const e=this.errors.map((e=>e.message)).find((e=>e));return Tr.parsingError(e)}getFormula(){return this.rawInput}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class gr{constructor(e,t){this.width=e,this.height=t,this.mapping=new Map}getCell(e){var t;return null===(t=this.mapping.get(e.col))||void 0===t?void 0:t.get(e.row)}setCell(e,t){this.width=Math.max(this.width,e.col+1),this.height=Math.max(this.height,e.row+1);let r=this.mapping.get(e.col);r||(r=new Map,this.mapping.set(e.col,r)),r.set(e.row,t)}has(e){var t;return!!(null===(t=this.mapping.get(e.col))||void 0===t?void 0:t.get(e.row))}getHeight(){return this.height}getWidth(){return this.width}removeCell(e){var t;null===(t=this.mapping.get(e.col))||void 0===t||t.delete(e.row)}addRows(e,t){this.mapping.forEach((r=>{const n=new Map;r.forEach(((s,i)=>{i>=e&&(n.set(i+t,s),r.delete(i))})),n.forEach(((e,t)=>{r.set(t,e)}))})),this.height+=t}addColumns(e,t){const r=new Map;this.mapping.forEach(((n,s)=>{s>=e&&(r.set(s+t,n),this.mapping.delete(s))})),r.forEach(((e,t)=>{this.mapping.set(t,e)})),this.width+=t}removeRows(e){this.mapping.forEach((t=>{const r=new Map;t.forEach(((n,s)=>{s>=e.rowStart&&(t.delete(s),s>e.rowEnd&&r.set(s-e.numberOfRows,n))})),r.forEach(((e,r)=>{t.set(r,e)}))}));const t=Math.min(this.height-1,e.rowEnd),r=Math.max(0,t-e.rowStart+1);this.height=Math.max(0,this.height-r)}removeColumns(e){const t=new Map;this.mapping.forEach(((r,n)=>{n>=e.columnStart&&(this.mapping.delete(n),n>e.columnEnd&&t.set(n-e.numberOfColumns,r))})),t.forEach(((e,t)=>{this.mapping.set(t,e)}));const r=Math.min(this.width-1,e.columnEnd),n=Math.max(0,r-e.columnStart+1);this.width=Math.max(0,this.width-n)}*getEntries(e){for(const[t,r]of this.mapping)for(const[n,s]of r)yield[Ar(e,t,n),s]}*verticesFromColumn(e){const t=this.mapping.get(e);if(void 0!==t)for(const[e,r]of t)yield r}*verticesFromRow(e){for(const t of this.mapping.values()){const r=t.get(e);void 0!==r&&(yield r)}}*verticesFromColumnsSpan(e){for(const t of e.columns()){const e=this.mapping.get(t);if(void 0!==e)for(const[t,r]of e)yield r}}*verticesFromRowsSpan(e){for(const t of this.mapping.values())for(const r of e.rows()){const e=t.get(r);void 0!==e&&(yield e)}}*entriesFromRowsSpan(e){for(const[t,r]of this.mapping.entries())for(const n of e.rows()){const s=r.get(n);void 0!==s&&(yield[Ar(e.sheet,t,n),s])}}*entriesFromColumnsSpan(e){for(const t of e.columns()){const r=this.mapping.get(t);if(void 0!==r)for(const[n,s]of r.entries())yield[Ar(e.sheet,t,n),s]}}*vertices(){for(const[e,t]of this.mapping)for(const[e,r]of t)void 0!==r&&(yield r)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class fr{constructor(e,t){this.width=e,this.height=t,this.mapping=new Array(t);for(let r=0;r<t;r++)this.mapping[r]=new Array(e)}getCell(e){return this.getCellVertex(e.col,e.row)}setCell(e,t){this.width=Math.max(this.width,e.col+1),this.height=Math.max(this.height,e.row+1);this.mapping[e.row]||(this.mapping[e.row]=new Array(this.width)),this.mapping[e.row][e.col]=t}has(e){const t=this.mapping[e.row];return!!t&&!!t[e.col]}getHeight(){return this.height}getWidth(){return this.width}removeCell(e){void 0!==this.mapping[e.row]&&delete this.mapping[e.row][e.col]}addRows(e,t){const r=[];for(let e=0;e<t;e++)r.push(new Array(this.width));this.mapping.splice(e,0,...r),this.height+=t}addColumns(e,t){for(let r=0;r<this.height;r++)void 0!==this.mapping[r]&&this.mapping[r].splice(e,0,...new Array(t));this.width+=t}removeRows(e){this.mapping.splice(e.rowStart,e.numberOfRows);const t=Math.min(this.height-1,e.rowEnd),r=Math.max(0,t-e.rowStart+1);this.height=Math.max(0,this.height-r)}removeColumns(e){for(let t=0;t<this.height;t++)void 0!==this.mapping[t]&&this.mapping[t].splice(e.columnStart,e.numberOfColumns);const t=Math.min(this.width-1,e.columnEnd),r=Math.max(0,t-e.columnStart+1);this.width=Math.max(0,this.width-r)}*getEntries(e){for(let t=0;t<this.height;++t)for(let r=0;r<this.width;++r){const n=this.getCellVertex(r,t);n&&(yield[Ar(e,r,t),n])}}*verticesFromColumn(e){for(let t=0;t<this.height;++t){const r=this.getCellVertex(e,t);r&&(yield r)}}*verticesFromRow(e){for(let t=0;t<this.width;++t){const r=this.getCellVertex(t,e);r&&(yield r)}}*verticesFromColumnsSpan(e){for(let t=e.columnStart;t<=e.columnEnd;++t)for(let e=0;e<this.height;++e){const r=this.getCellVertex(t,e);r&&(yield r)}}*verticesFromRowsSpan(e){for(let t=0;t<this.width;++t)for(let r=e.rowStart;r<=e.rowEnd;++r){const e=this.getCellVertex(t,r);e&&(yield e)}}*entriesFromRowsSpan(e){for(let t=0;t<this.width;++t)for(let r=e.rowStart;r<=e.rowEnd;++r){const n=this.getCellVertex(t,r);n&&(yield[Ar(e.sheet,t,r),n])}}*entriesFromColumnsSpan(e){for(let t=e.columnStart;t<=e.columnEnd;++t)for(let r=0;r<this.height;++r){const n=this.getCellVertex(t,r);n&&(yield[Ar(e.sheet,t,r),n])}}*vertices(){for(let e=0;e<this.height;++e)for(let t=0;t<this.width;++t){const r=this.getCellVertex(t,e);r&&(yield r)}}getCellVertex(e,t){var r;return null===(r=this.mapping[t])||void 0===r?void 0:r[e]}}!function(e){e.DIV_BY_ZERO="DIV_BY_ZERO",e.NAME="NAME",e.VALUE="VALUE",e.NUM="NUM",e.NA="NA",e.CYCLE="CYCLE",e.REF="REF",e.SPILL="SPILL",e.LIC="LIC",e.ERROR="ERROR"}(ir||(ir={})),function(e){e.FORMULA="FORMULA",e.VALUE="VALUE",e.ARRAY="ARRAY",e.EMPTY="EMPTY",e.ARRAYFORMULA="ARRAYFORMULA"}(or||(or={}));var mr,yr;!function(e){e.EMPTY="EMPTY",e.NUMBER="NUMBER",e.STRING="STRING",e.BOOLEAN="BOOLEAN",e.ERROR="ERROR"}(mr||(mr={})),function(e){e.NUMBER="NUMBER"}(yr||(yr={}));const Er=Object.assign(Object.assign({},mr),yr),wr=Object.assign(Object.assign({},mr),Je),Cr=e=>{switch(e){case Er.EMPTY:return 0;case Er.NUMBER:return 1;case Er.STRING:return 2;case Er.BOOLEAN:return 3;case Er.ERROR:return 4}throw new Error("Cell value not computed")},vr=e=>{if(e===Ye)return Er.EMPTY;if(e instanceof Tr||e instanceof rt)return Er.ERROR;if("string"==typeof e)return Er.STRING;if(Ze(e))return Er.NUMBER;if("boolean"==typeof e)return Er.BOOLEAN;throw new Error("Cell value not computed")},Rr=e=>{return Ze(e)?(t=e)instanceof je?t.getDetailedType():Je.NUMBER_RAW:vr(e);var t},Sr=e=>{return Ze(e)&&(t=e)instanceof je?t.format:void 0;var t};class Tr{constructor(e,t,r){this.type=e,this.message=t,this.root=r}static parsingError(e){return new Tr(ir.ERROR,`${Z.ParseError}${e?" "+e:""}`)}attachRootVertex(e){return void 0===this.root?new Tr(this.type,this.message,e):this}}const Nr=(e,t)=>({sheet:e,row:t}),Mr=e=>e.row<0,_r=(e,t)=>({sheet:e,col:t}),br=e=>e.col<0,Ar=(e,t,r)=>({sheet:e,col:t,row:r}),Or=e=>e.col<0||e.row<0,Ir=(e,t,r,n)=>Ar(t,e.col+r,e.row+n),xr=e=>`${e.sheet},${e.row},${e.col}`;function Pr(e){var t,r,n;return e&&("object"==typeof e||"function"==typeof e)&&"number"==typeof(null===(t=e)||void 0===t?void 0:t.sheet)&&"number"==typeof(null===(r=e)||void 0===r?void 0:r.col)&&"number"==typeof(null===(n=e)||void 0===n?void 0:n.row)}const Lr=(e,t)=>{var r;return null!==(r=e.sheet)&&void 0!==r?r:t.sheet},Dr=(e,t)=>e.sheet===t.sheet&&e.col===t.col&&e.row===t.row;function kr(e){return!(!e||"object"!=typeof e&&"function"!=typeof e)&&("start"in e&&Pr(e.start)&&"end"in e&&Pr(e.end))}const Hr=(e,t)=>({start:e,end:t});class Fr{constructor(e,t){if(e.sheet!==t.sheet)throw new ft(e.sheet,t.sheet);this.start=Ar(e.sheet,e.col,e.row),this.end=Ar(t.sheet,t.col,t.row)}get sheet(){return this.start.sheet}static fromSimpleCellAddresses(e,t){if(e.sheet!==t.sheet)throw new ft(e.sheet,t.sheet);const r=t.col-e.col,n=t.row-e.row;return Number.isFinite(n)&&Number.isFinite(r)?new Fr(e,t):Number.isFinite(n)?new Vr(e.sheet,e.row,t.row):new Ur(e.sheet,e.col,t.col)}static fromAst(e,t){return e.type===U.CELL_RANGE?Fr.fromCellRange(e,t):e.type===U.COLUMN_RANGE?Ur.fromColumnRange(e,t):Vr.fromRowRangeAst(e,t)}static fromAstOrUndef(e,t){try{return Fr.fromAst(e,t)}catch(e){return}}static fromCellRange(e,t){return new Fr(e.start.toSimpleCellAddress(t),e.end.toSimpleCellAddress(t))}static spanFrom(e,t,r){const n=Fr.spanFromOrUndef(e,t,r);if(void 0===n)throw new Error("AbsoluteCellRange: Wrong range size");return n}static spanFromOrUndef(e,t,r){if(!Number.isFinite(t)&&Number.isFinite(r)){if(0!==e.col)return;return new Vr(e.sheet,e.row,e.row+r-1)}if(!Number.isFinite(r)&&Number.isFinite(t)){if(0!==e.row)return;return new Ur(e.sheet,e.col,e.col+t-1)}if(Number.isFinite(r)&&Number.isFinite(t))return new Fr(e,Ar(e.sheet,e.col+t-1,e.row+r-1))}static fromCoordinates(e,t,r,n,s){return new Fr(Ar(e,t,r),Ar(e,n,s))}isFinite(){return Number.isFinite(this.size())}doesOverlap(e){return this.start.sheet==e.start.sheet&&(!(this.end.row<e.start.row||this.start.row>e.end.row)&&!(this.end.col<e.start.col||this.start.col>e.end.col))}addressInRange(e){return this.sheet===e.sheet&&(this.start.row<=e.row&&this.end.row>=e.row&&this.start.col<=e.col&&this.end.col>=e.col)}columnInRange(e){return this.sheet===e.sheet&&(this.start.col<=e.col&&this.end.col>=e.col)}rowInRange(e){return this.sheet===e.sheet&&(this.start.row<=e.row&&this.end.row>=e.row)}containsRange(e){return this.addressInRange(e.start)&&this.addressInRange(e.end)}intersectionWith(e){if(this.sheet!==e.start.sheet)return;const t=Math.max(this.start.row,e.start.row),r=Math.min(this.end.row,e.end.row),n=Math.max(this.start.col,e.start.col),s=Math.min(this.end.col,e.end.col);return t>r||n>s?void 0:new Fr(Ar(this.sheet,n,t),Ar(this.sheet,s,r))}includesRow(e){return this.start.row<e&&this.end.row>=e}includesColumn(e){return this.start.col<e&&this.end.col>=e}shiftByRows(e){this.start.row+=e,this.end.row+=e}expandByRows(e){this.end.row+=e}shiftByColumns(e){this.start.col+=e,this.end.col+=e}shifted(e,t){return Fr.spanFrom(Ar(this.sheet,this.start.col+e,this.start.row+t),this.width(),this.height())}expandByColumns(e){this.end.col+=e}moveToSheet(e){this.start.sheet=e,this.end.sheet=e}removeSpan(e){e instanceof st?this.removeRows(e.start,e.end):this.removeColumns(e.start,e.end)}shouldBeRemoved(){return this.width()<=0||this.height()<=0}rangeWithSameWidth(e,t){return Fr.spanFrom(Ar(this.sheet,this.start.col,e),this.width(),t)}rangeWithSameHeight(e,t){return Fr.spanFrom(Ar(this.sheet,e,this.start.row),t,this.height())}toString(){return`${this.start.sheet},${this.start.col},${this.start.row},${this.end.col},${this.end.row}`}width(){return this.end.col-this.start.col+1}height(){return this.end.row-this.start.row+1}size(){return this.height()*this.width()}arrayOfAddressesInRange(){const e=[];for(let t=0;t<this.height();++t){e[t]=[];for(let r=0;r<this.width();++r){const n=Ar(this.sheet,this.start.col+r,this.start.row+t);e[t].push(n)}}return e}withStart(e){return new Fr(e,this.end)}sameDimensionsAs(e){return this.width()===e.width()&&this.height()===e.height()}sameAs(e){return Dr(this.start,e.start)&&Dr(this.end,e.end)}addressesArrayMap(e,t){const r=[];let n=this.start.row;for(;n<=this.effectiveEndRow(e);){let s=this.start.col;const i=[];for(;s<=this.effectiveEndColumn(e);)i.push(t(Ar(this.start.sheet,s,n))),s++;r.push(i),n++}return r}addresses(e){const t=[];let r=this.start.row;const n=this.effectiveEndRow(e),s=this.effectiveEndColumn(e);for(;r<=n;){let e=this.start.col;for(;e<=s;)t.push(Ar(this.start.sheet,e,r)),e++;r++}return t}*addressesWithDirection(e,t,r){if(e>0)if(t>0){let e=this.effectiveEndRow(r);for(;e>=this.start.row;){let t=this.effectiveEndColumn(r);for(;t>=this.start.col;)yield Ar(this.start.sheet,t,e),t-=1;e-=1}}else{let e=this.start.row;for(;e<=this.effectiveEndRow(r);){let t=this.effectiveEndColumn(r);for(;t>=this.start.col;)yield Ar(this.start.sheet,t,e),t-=1;e+=1}}else if(t>0){let e=this.effectiveEndRow(r);for(;e>=this.start.row;){let t=this.start.col;for(;t<=this.effectiveEndColumn(r);)yield Ar(this.start.sheet,t,e),t+=1;e-=1}}else{let e=this.start.row;for(;e<=this.effectiveEndRow(r);){let t=this.start.col;for(;t<=this.effectiveEndColumn(r);)yield Ar(this.start.sheet,t,e),t+=1;e+=1}}}getAddress(e,t){if(e<0||t<0||t>this.height()-1||e>this.width()-1)throw Error("Index out of bound");return Ar(this.start.sheet,this.start.col+e,this.start.row+t)}exceedsSheetSizeLimits(e,t){return this.end.col>=e||this.end.row>=t}effectiveEndColumn(e){return this.end.col}effectiveEndRow(e){return this.end.row}effectiveWidth(e){return this.width()}effectiveHeight(e){return this.height()}removeRows(e,t){if(!(e>this.end.row)){if(t<this.start.row){const r=t-e+1;return this.shiftByRows(-r)}e<=this.start.row&&(this.start.row=e),this.end.row-=Math.min(t,this.end.row)-e+1}}removeColumns(e,t){if(!(e>this.end.col)){if(t<this.start.col){const r=t-e+1;return this.shiftByColumns(-r)}e<=this.start.col&&(this.start.col=e),this.end.col-=Math.min(t,this.end.col)-e+1}}}class Ur extends Fr{constructor(e,t,r){super(Ar(e,t,0),Ar(e,r,Number.POSITIVE_INFINITY))}static fromColumnRange(e,t){const r=e.start.toSimpleColumnAddress(t),n=e.end.toSimpleColumnAddress(t);if(r.sheet!==n.sheet)throw new ft(r.sheet,n.sheet);return new Ur(r.sheet,r.col,n.col)}shouldBeRemoved(){return this.width()<=0}shiftByRows(e){}expandByRows(e){}shifted(e,t){return new Ur(this.sheet,this.start.col+e,this.end.col+e)}rangeWithSameHeight(e,t){return new Ur(this.sheet,e,e+t-1)}exceedsSheetSizeLimits(e,t){return this.end.col>=e}effectiveEndRow(e){return this.effectiveHeight(e)-1}effectiveHeight(e){return e.getSheetHeight(this.sheet)}removeRows(e,t){}}class Vr extends Fr{constructor(e,t,r){super(Ar(e,0,t),Ar(e,Number.POSITIVE_INFINITY,r))}static fromRowRangeAst(e,t){const r=e.start.toSimpleRowAddress(t),n=e.end.toSimpleRowAddress(t);if(r.sheet!==n.sheet)throw new ft(r.sheet,n.sheet);return new Vr(r.sheet,r.row,n.row)}shouldBeRemoved(){return this.height()<=0}shiftByColumns(e){}expandByColumns(e){}shifted(e,t){return new Vr(this.sheet,this.start.row+t,this.end.row+t)}rangeWithSameWidth(e,t){return new Vr(this.sheet,e,e+t-1)}exceedsSheetSizeLimits(e,t){return this.end.row>=t}effectiveEndColumn(e){return this.effectiveWidth(e)-1}effectiveWidth(e){return e.getSheetWidth(this.sheet)}removeColumns(e,t){}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Br{constructor(e,t,r){this.formulaAddress=e,this.arraysFlag=t,this.formulaVertex=r}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const Wr=/^\s*([+-]?)\s*(([\d\.,]+(e[+-]?\d+)?)\s*([ij]?)|([ij]))\s*(([+-])\s*([+-]?)\s*(([\d\.,]+(e[+-]?\d+)?)\s*([ij]?)|([ij])))?$/;class Yr{constructor(e,t,r){this.config=e,this.dateTimeHelper=t,this.numberLiteralsHelper=r,this.lt=(e,t)=>this.compare(e,t)<0,this.leq=(e,t)=>this.compare(e,t)<=0,this.gt=(e,t)=>this.compare(e,t)>0,this.geq=(e,t)=>this.compare(e,t)>=0,this.eq=(e,t)=>0===this.compare(e,t),this.neq=(e,t)=>0!==this.compare(e,t),this.pow=(e,t)=>Math.pow(Ge(e),Ge(t)),this.addWithEpsilonRaw=(e,t)=>{const r=e+t;return Math.abs(r)<this.actualEps*Math.abs(e)?0:r},this.addWithEpsilon=(e,t)=>{const r=nn(e,t);return this.ExtendedNumberFactory(this.addWithEpsilonRaw(Ge(e),Ge(t)),r)},this.unaryMinus=e=>ze(e,-Ge(e)),this.unaryPlus=e=>e,this.unaryPercent=e=>new Qe(Ge(e)/100),this.concat=(e,t)=>e.concat(t),this.nonstrictadd=(e,t)=>e instanceof Tr?e:t instanceof Tr?t:"number"==typeof e?"number"==typeof t?this.addWithEpsilonRaw(e,t):e:"number"==typeof t?t:0,this.subtract=(e,t)=>{const r=nn(e,t),n=Ge(e);let s=n-Ge(t);return Math.abs(s)<this.actualEps*Math.abs(n)&&(s=0),this.ExtendedNumberFactory(s,r)},this.divide=(e,t)=>{const r=Ge(e),n=Ge(t);if(0===n)return new Tr(ir.DIV_BY_ZERO);{const s=sn(e,t);return this.ExtendedNumberFactory(r/n,s)}},this.multiply=(e,t)=>{const r=sn(e,t);return this.ExtendedNumberFactory(Ge(e)*Ge(t),r)},this.manyToExactComplex=e=>{const t=[];for(const r of e){if(r instanceof Tr)return r;if(Ze(r)||"string"==typeof r){const e=this.coerceScalarToComplex(r);e instanceof Tr||t.push(e)}}return t},this.coerceNumbersExactRanges=e=>this.manyToNumbers(e,this.manyToExactNumbers),this.coerceNumbersCoerceRangesDropNulls=e=>this.manyToNumbers(e,this.manyToCoercedNumbersDropNulls),this.manyToExactNumbers=e=>{const t=[];for(const r of e){if(r instanceof Tr)return r;Ze(r)&&t.push(Ge(r))}return t},this.manyToOnlyNumbersDropNulls=e=>{const t=[];for(const r of e){if(r instanceof Tr)return r;if(Ze(r))t.push(Ge(r));else if(r!==Ye)return new Tr(ir.VALUE,Z.NumberExpected)}return t},this.manyToCoercedNumbersDropNulls=e=>{const t=[];for(const r of e){if(r instanceof Tr)return r;if(r===Ye)continue;const e=this.coerceScalarToNumberOrError(r);Ze(e)&&t.push(Ge(e))}return t},this.collator=
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function(e){const t=e.caseSensitive?e.accentSensitive?"variant":"case":e.accentSensitive?"accent":"base",r=e.caseFirst,n=e.ignorePunctuation;return new Intl.Collator(e.localeLang,{sensitivity:t,caseFirst:r,ignorePunctuation:n})}(e),this.actualEps=e.smartRounding?e.precisionEpsilon:0}eqMatcherFunction(e){const t=this.buildRegex(e);return e=>"string"==typeof e&&t.test(this.normalizeString(e))}neqMatcherFunction(e){const t=this.buildRegex(e);return e=>!("string"==typeof e&&t.test(this.normalizeString(e)))}searchString(e,t){var r;const n=this.buildRegex(e,!1).exec(t);return null!==(r=null==n?void 0:n.index)&&void 0!==r?r:-1}requiresRegex(e){if(!this.config.useRegularExpressions&&!this.config.useWildcards)return!this.config.matchWholeCell;for(let t=0;t<e.length;t++){const r=e.charAt(t);if(en(r)||this.config.useRegularExpressions&&rn(r))return!0}return!1}floatCmp(e,t){const r=Ge(e),n=Ge(t),s=1+this.actualEps;return n>=0&&r*s>=n&&r<=n*s||n<=0&&r*s<=n&&r>=n*s?0:r>n?1:-1}coerceScalarToNumberOrError(e){var t;return e instanceof Tr?e:null!==(t=this.coerceToMaybeNumber(e))&&void 0!==t?t:new Tr(ir.VALUE,Z.NumberCoercion)}coerceToMaybeNumber(e){var t;return null!==(t=this.coerceNonDateScalarToMaybeNumber(e))&&void 0!==t?t:"string"==typeof e?this.dateTimeHelper.dateStringToDateNumber(e):void 0}coerceNonDateScalarToMaybeNumber(e){if(e===Ye)return 0;if("string"==typeof e){if(""===e)return 0;const t=this.coerceStringToMaybePercentNumber(e);if(void 0!==t)return t;const r=this.coerceStringToMaybeCurrencyNumber(e);return void 0!==r?r:this.numberLiteralsHelper.numericStringToMaybeNumber(e.trim())}return Ze(e)?e:"boolean"==typeof e?Number(e):void 0}coerceStringToMaybePercentNumber(e){const t=e.trim();if(t.endsWith("%")){const e=t.slice(0,t.length-1).trim(),r=this.numberLiteralsHelper.numericStringToMaybeNumber(e);if(void 0!==r)return new Qe(r/100)}}coerceStringToMaybeCurrencyNumber(e){const t=this.currencyMatcher(e.trim());if(void 0!==t){const[e,r]=t,n=this.numberLiteralsHelper.numericStringToMaybeNumber(r);if(void 0!==n)return new Ke(n,e)}}currencyMatcher(e){for(const t of this.config.currencySymbol){if(e.startsWith(t))return[t,e.slice(t.length).trim()];if(e.endsWith(t))return[t,e.slice(0,e.length-t.length).trim()]}}coerceComplexExactRanges(e){const t=[];for(const r of e)if(r instanceof rt)t.push(r);else if(r!==Ye){const e=this.coerceScalarToComplex(r);if(e instanceof Tr)return e;t.push(e)}const r=[];for(const e of t)if(e instanceof rt){const t=this.manyToExactComplex(e.valuesFromTopLeftCorner());if(t instanceof Tr)return t;r.push(...t)}else r.push(e);return r}coerceScalarToComplex(e){return e instanceof Tr?e:e===Ye?[0,0]:Ze(e)?[Ge(e),0]:"string"==typeof e?this.coerceStringToComplex(e):new Tr(ir.NUM,Z.ComplexNumberExpected)}ExtendedNumberFactory(e,t){const{type:r,format:n}=t;switch(r){case Je.NUMBER_RAW:return e;case Je.NUMBER_CURRENCY:return new Ke(e,null!=n?n:this.config.currencySymbol[0]);case Je.NUMBER_DATE:return new $e(e,n);case Je.NUMBER_DATETIME:return new qe(e,n);case Je.NUMBER_TIME:return new Xe(e,n);case Je.NUMBER_PERCENT:return new Qe(e,n)}}buildRegex(e,t=!0){let r;e=this.normalizeString(e);let n=this.config.useWildcards,s=this.config.useRegularExpressions;if(s)try{RegExp(e)}catch(e){s=!1,n=!1}return r=s?function(e,t){let r="";for(let n=0;n<e.length;n++){const s=e.charAt(n);en(s)||rn(s)?r+=s:r+=t?s:s.toLowerCase()}return r}(e,this.config.caseSensitive):n?function(e,t){let r="";for(let n=0;n<e.length;n++){const s=e.charAt(n);if("~"===s){if(n==e.length-1){r+="~";continue}const t=e.charAt(n+1);en(t)||rn(t)?(r+="\\"+t,n++):(r+=t,n++)}else en(s)?r+="."+s:rn(s)?r+="\\"+s:r+=t?s:s.toLowerCase()}return r}(e,this.config.caseSensitive):function(e,t){let r="";for(let n=0;n<e.length;n++){const s=e.charAt(n);en(s)||rn(s)?r+="\\"+s:r+=t?s:s.toLowerCase()}return r}(e,this.config.caseSensitive),this.config.matchWholeCell&&t?RegExp("^("+r+")$"):RegExp(r)}normalizeString(e){return this.config.caseSensitive||(e=e.toLowerCase()),this.config.accentSensitive||(e=ln(e,"nfd").replace(/[\u0300-\u036f]/g,"")),e}compare(e,t){if("string"==typeof e||"string"==typeof t){const r="string"==typeof e?this.dateTimeHelper.dateStringToDateNumber(e):e,n="string"==typeof t?this.dateTimeHelper.dateStringToDateNumber(t):t;if(Ze(r)&&Ze(n))return this.floatCmp(r,n)}return e===Ye?e=$r(t):t===Ye&&(t=$r(e)),"string"==typeof e&&"string"==typeof t?this.stringCmp(e,t):"boolean"==typeof e&&"boolean"==typeof t?Qr(zr(e),zr(t)):Ze(e)&&Ze(t)?this.floatCmp(e,t):e===Ye&&t===Ye?0:Qr(Cr(vr(e)),Cr(vr(t)))}stringCmp(e,t){return this.collator.compare(e,t)}manyToNumbers(e,t){const r=[];for(const t of e)if(t instanceof rt)r.push(t);else{const e=Ge(this.coerceScalarToNumberOrError(t));if(e instanceof Tr)return e;r.push(e)}const n=[];for(const e of r)if(e instanceof rt){const r=t(e.valuesFromTopLeftCorner());if(r instanceof Tr)return r;n.push(...r)}else n.push(e);return n}coerceStringToComplex(e){const t=Wr.exec(e);if(null===t)return new Tr(ir.NUM,Z.ComplexNumberExpected);let r,n;return r=void 0!==t[6]?"-"===t[1]?[0,-1]:[0,1]:this.parseComplexToken(t[1]+t[3],t[5]),r instanceof Tr||void 0===t[8]?r:(n=void 0!==t[14]?"-"===t[9]?[0,-1]:[0,1]:this.parseComplexToken(t[9]+t[11],t[13]),n instanceof Tr?n:""!==t[5]||""===t[13]?new Tr(ir.NUM,Z.ComplexNumberExpected):"+"===t[8]?[r[0]+n[0],r[1]+n[1]]:[r[0]-n[0],r[1]-n[1]])}parseComplexToken(e,t){const r=Ge(this.coerceNonDateScalarToMaybeNumber(e));return void 0===r?new Tr(ir.NUM,Z.ComplexNumberExpected):""===t?[r,0]:[0,r]}}function Gr([e,t],r){if(!isFinite(e)||!isFinite(t))return new Tr(ir.NUM,Z.NaN);if(r=null!=r?r:"i",0===t)return`${e}`;const n=`${-1===t||1===t?"":Math.abs(t)}${r}`;return 0===e?`${t<0?"-":""}${n}`:`${e}${t<0?"-":"+"}${n}`}function jr(e){return e instanceof rt?e:rt.fromScalar(e)}function zr(e){return Number(e)}function $r(e){return"string"==typeof e?"":Ze(e)?0:"boolean"!=typeof e&&Ye}function Kr(e){if(e instanceof Tr||"boolean"==typeof e)return e;if(e===Ye)return!1;if(Ze(e))return 0!==Ge(e);{const t=e.toUpperCase();return"TRUE"===t||"FALSE"!==t&&(""!==t&&void 0)}}function Xr(e){return e instanceof Tr||"string"==typeof e?e:e===Ye?"":Ze(e)?Ge(e).toString():e?"TRUE":"FALSE"}function qr(e){return e===Ye?0:e}function Qr(e,t){const r=Ge(e),n=Ge(t);return r>n?1:r<n?-1:0}function Zr(e){return isNaN(e)||e===1/0||e===-1/0}function Jr(e){return 0===e?0:e}function en(e){return["*","?"].includes(e)}const tn=["{","}","[","]","(",")","<",">","=",".","+","-",",","\\","$","^","!"];function rn(e){return tn.includes(e)}function nn(e,t){const{type:r,format:n}=tt(e),{type:s,format:i}=tt(t);if(r===Je.NUMBER_RAW)return{type:s,format:i};if(s===Je.NUMBER_RAW)return{type:r,format:n};if(!(r!==Je.NUMBER_DATETIME&&r!==Je.NUMBER_DATE||s!==Je.NUMBER_DATETIME&&s!==Je.NUMBER_DATE))return{type:Je.NUMBER_RAW};if(r===Je.NUMBER_TIME){if(s===Je.NUMBER_DATE)return{type:Je.NUMBER_DATETIME,format:`${i} ${n}`};if(s===Je.NUMBER_DATETIME)return{type:Je.NUMBER_DATETIME,format:i}}if(s===Je.NUMBER_TIME){if(r===Je.NUMBER_DATE)return{type:Je.NUMBER_DATETIME,format:`${n} ${i}`};if(r===Je.NUMBER_DATETIME)return{type:Je.NUMBER_DATETIME,format:n}}return{type:r,format:n}}function sn(e,t){let{type:r,format:n}=tt(e),{type:s,format:i}=tt(t);return r===Je.NUMBER_PERCENT&&(r=Je.NUMBER_RAW,n=void 0),s===Je.NUMBER_PERCENT&&(s=Je.NUMBER_RAW,i=void 0),r===Je.NUMBER_RAW?{type:s,format:i}:s===Je.NUMBER_RAW?{type:r,format:n}:{type:Je.NUMBER_RAW}}function on(e){return ln(e.toLowerCase(),"nfd").replace(/[\u0300-\u036f]/g,"")}function an(e,t){var r;if(e.isAdHoc())return null===(r=e.data[0])||void 0===r?void 0:r[0];const n=e.range;if(t.formulaAddress.sheet===n.sheet)if(1===n.width()){const r=t.formulaAddress.row-n.start.row;if(r>=0&&r<n.height())return e.data[r][0]}else if(1===n.height()){const r=t.formulaAddress.col-n.start.col;if(r>=0&&r<n.width())return e.data[0][r]}}function ln(e,t){return e.normalize(t.toUpperCase())}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
var hn;!function(e){e.STRING="STRING",e.NUMBER="NUMBER",e.BOOLEAN="BOOLEAN",e.SCALAR="SCALAR",e.NOERROR="NOERROR",e.RANGE="RANGE",e.INTEGER="INTEGER",e.COMPLEX="COMPLEX",e.ANY="ANY"}(hn||(hn={}));class un{constructor(e){this.coerceScalarToNumberOrError=e=>this.arithmeticHelper.coerceScalarToNumberOrError(e),this.runFunction=(e,t,r,n)=>{const s=this.evaluateArguments(e,t,r),i=s.map((([e,t])=>e)),o=s.map((([e,t])=>t)),a=this.buildMetadataForEachArgumentValue(i.length,r),l=t.arraysFlag&&!r.vectorizationForbidden;if(!this.isNumberOfArgumentValuesValid(a,i.length))return new Tr(ir.NA,Z.WrongArgNumber);const[h,u]=l?this.calculateSizeOfVectorizedResultArray(i,a):[1,1];if(1===h&&1===u){const e=this.vectorizeAndBroadcastArgumentsIfNecessary(l,i,a,0,0);return this.calculateSingleCellOfResultArray(t,e,a,o,n,r.returnNumberType)}const c=[...Array(h).keys()].map((e=>[...Array(u).keys()].map((s=>{const h=this.vectorizeAndBroadcastArgumentsIfNecessary(l,i,a,e,s),u=this.calculateSingleCellOfResultArray(t,h,a,o,n,r.returnNumberType);if(u instanceof rt)throw new Error("Function returning array cannot be vectorized.");return u}))));return rt.onlyValues(c)},this.runFunctionWithReferenceArgument=(e,t,r,n,s,i=()=>new Tr(ir.NA,Z.CellRefExpected))=>{if(0===e.length)return this.returnNumberWrapper(n(),r.returnNumberType);if(e.length>1)return new Tr(ir.NA,Z.WrongArgNumber);let o,a=e[0];for(;a.type===U.PARENTHESIS;)a=a.expression;if(a.type===U.CELL_REFERENCE)o=a.reference.toSimpleCellAddress(t.formulaAddress);else if(a.type===U.CELL_RANGE||a.type===U.COLUMN_RANGE||a.type===U.ROW_RANGE)try{o=Fr.fromAst(a,t.formulaAddress).start}catch(e){return new Tr(ir.REF,Z.CellRefExpected)}return void 0!==o?this.returnNumberWrapper(s(o),r.returnNumberType):this.runFunction(e,t,r,i)},this.interpreter=e,this.dependencyGraph=e.dependencyGraph,this.columnSearch=e.columnSearch,this.config=e.config,this.serialization=e.serialization,this.arraySizePredictor=e.arraySizePredictor,this.dateTimeHelper=e.dateTimeHelper,this.arithmeticHelper=e.arithmeticHelper}evaluateAst(e,t){return this.interpreter.evaluateAst(e,t)}arraySizeForAst(e,t){return this.arraySizePredictor.checkArraySizeForAst(e,t)}listOfScalarValues(e,t){const r=[];for(const n of e){const e=this.evaluateAst(n,t);if(e instanceof rt)for(const t of e.valuesFromTopLeftCorner())r.push([t,!0]);else r.push([e,!1])}return r}coerceToType(e,t,r){let n;if(e instanceof rt)switch(t.argumentType){case hn.RANGE:case hn.ANY:n=e;break;default:{const t=an(e,r);if(void 0===t)return;e=t}}if(!(e instanceof rt))switch(t.argumentType){case hn.INTEGER:case hn.NUMBER:const r=this.coerceScalarToNumberOrError(e);if(!Ze(r)){n=r;break}const s=Ge(r);if(void 0!==t.maxValue&&s>t.maxValue)return new Tr(ir.NUM,Z.ValueLarge);if(void 0!==t.minValue&&s<t.minValue)return new Tr(ir.NUM,Z.ValueSmall);if(void 0!==t.lessThan&&s>=t.lessThan)return new Tr(ir.NUM,Z.ValueLarge);if(void 0!==t.greaterThan&&s<=t.greaterThan)return new Tr(ir.NUM,Z.ValueSmall);if(t.argumentType===hn.INTEGER&&!Number.isInteger(s))return new Tr(ir.NUM,Z.IntegerExpected);n=r;break;case hn.STRING:n=Xr(e);break;case hn.BOOLEAN:n=Kr(e);break;case hn.SCALAR:case hn.NOERROR:case hn.ANY:n=e;break;case hn.RANGE:if(e instanceof Tr)return e;n=jr(e);break;case hn.COMPLEX:return this.arithmeticHelper.coerceScalarToComplex(Ge(e))}return t.passSubtype||void 0===n?n:Ge(n)}calculateSingleCellOfResultArray(e,t,r,n,s,i){const o=this.coerceArgumentsToRequiredTypes(e,t,r,n);if(o instanceof Tr)return o;const a=s(...o);return this.returnNumberWrapper(a,i)}coerceArgumentsToRequiredTypes(e,t,r,n){const s=[];for(let i=0;i<r.length;i++){const o=r[i],a=void 0!==t[i]?t[i]:null==o?void 0:o.defaultValue;if(void 0===a){s.push(void 0);continue}const l=this.coerceToType(a,o,e);if(void 0===l&&!n[i])return new Tr(ir.VALUE,Z.WrongType);if(l instanceof Tr&&o.argumentType!==hn.SCALAR)return l;s.push(l)}return s}vectorizeAndBroadcastArgumentsIfNecessary(e,t,r,n,s){return t.map(((t,i)=>e&&this.isRangePassedAsAScalarArgument(t,r[i])?this.vectorizeAndBroadcastRangeArgument(t,n,s):t))}vectorizeAndBroadcastRangeArgument(e,t,r){var n;const s=1===e.height()?0:t,i=1===e.width()?0:r;return null===(n=e.data[s])||void 0===n?void 0:n[i]}evaluateArguments(e,t,r){return r.expandRanges?this.listOfScalarValues(e,t):e.map((e=>[this.evaluateAst(e,t),!1]))}buildMetadataForEachArgumentValue(e,t){const r=t.parameters?[...t.parameters]:[];if(void 0!==t.repeatLastArgs&&Number.isInteger(t.repeatLastArgs)&&t.repeatLastArgs>0)for(;e>r.length;)r.push(...r.slice(r.length-t.repeatLastArgs));return r}isNumberOfArgumentValuesValid(e,t){if(t>e.length)return!1;if(t<e.length){return e.slice(t).every((e=>(null==e?void 0:e.optionalArg)||void 0!==(null==e?void 0:e.defaultValue)))}return!0}calculateSizeOfVectorizedResultArray(e,t){const r=e.filter(((e,r)=>this.isRangePassedAsAScalarArgument(e,t[r])));return[Math.max(1,...r.map((e=>e.height()))),Math.max(1,...r.map((e=>e.width())))]}isRangePassedAsAScalarArgument(e,t){return null!=e&&null!=t&&(e instanceof rt&&![hn.RANGE,hn.ANY].includes(t.argumentType))}metadata(e){const t=this.constructor.implementedFunctions[e];if(void 0!==t)return t;throw new Error(`No metadata for function ${e}.`)}returnNumberWrapper(e,t,r){return void 0!==t&&Ze(e)?this.arithmeticHelper.ExtendedNumberFactory(Ge(e),{type:t,format:r}):e}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class cn{constructor(e,t,r=!1){this.width=e,this.height=t,this.isRef=r}static error(){return new cn(1,1,!0)}static scalar(){return new cn(1,1,!1)}isScalar(){return 1===this.width&&1===this.height||this.isRef}}class dn{constructor(e,t){this.config=e,this.functionRegistry=t}checkArraySize(e,t){return this.checkArraySizeForAst(e,{formulaAddress:t,arraysFlag:this.config.useArrayArithmetic})}checkArraySizeForAst(e,t){switch(e.type){case U.FUNCTION_CALL:return this.checkArraySizeForFunction(e,t);case U.COLUMN_RANGE:case U.ROW_RANGE:case U.CELL_RANGE:{const r=Fr.fromAstOrUndef(e,t.formulaAddress);return void 0===r?cn.error():new cn(r.width(),r.height(),!0)}case U.ARRAY:{const r=[],n=[];for(const s of e.args){const e=s.map((e=>this.checkArraySizeForAst(e,t))),i=Math.min(...e.map((e=>e.height))),o=e.reduce(((e,t)=>e+t.width),0);r.push(i),n.push(o)}const s=r.reduce(((e,t)=>e+t),0),i=Math.min(...n);return new cn(i,s)}case U.STRING:case U.NUMBER:return cn.scalar();case U.CELL_REFERENCE:return new cn(1,1,!0);case U.DIV_OP:case U.CONCATENATE_OP:case U.EQUALS_OP:case U.GREATER_THAN_OP:case U.GREATER_THAN_OR_EQUAL_OP:case U.LESS_THAN_OP:case U.LESS_THAN_OR_EQUAL_OP:case U.MINUS_OP:case U.NOT_EQUAL_OP:case U.PLUS_OP:case U.POWER_OP:case U.TIMES_OP:{const r=this.checkArraySizeForAst(e.left,t),i=this.checkArraySizeForAst(e.right,t);return!t.arraysFlag&&(r.height>1||r.width>1||i.height>1||i.width>1)?cn.error():(n=r,s=i,new cn(Math.max(n.width,s.width),Math.max(n.height,s.height)))}case U.MINUS_UNARY_OP:case U.PLUS_UNARY_OP:case U.PERCENT_OP:{const n=this.checkArraySizeForAst(e.value,t);return!t.arraysFlag&&(n.height>1||n.width>1)?cn.error():new cn((r=n).width,r.height)}case U.PARENTHESIS:return this.checkArraySizeForAst(e.expression,t);case U.EMPTY:default:return cn.error()}var r,n,s}checkArraySizeForFunction(e,t){const r=this.functionRegistry.getArraySizeFunction(e.procedureName);if(void 0!==r)return r(e,t);const n=this.functionRegistry.getMetadata(e.procedureName);if(void 0===n||n.expandRanges||!t.arraysFlag||n.vectorizationForbidden||void 0===n.parameters)return new cn(1,1);const s=e.args.map((e=>{var r;return this.checkArraySizeForAst(e,new Br(t.formulaAddress,t.arraysFlag||null!==(r=null==n?void 0:n.arrayFunction)&&void 0!==r&&r))})),i=[...n.parameters];if(void 0!==n.repeatLastArgs&&i.length<s.length&&(s.length-i.length)%n.repeatLastArgs!=0)return cn.error();for(;i.length<s.length;){if(void 0===n.repeatLastArgs)return cn.error();i.push(...i.slice(i.length-n.repeatLastArgs))}let o=1,a=1;for(let e=0;e<s.length;e++)i[e].argumentType!==hn.RANGE&&i[e].argumentType!==hn.ANY&&(a=Math.max(a,s[e].height),o=Math.max(o,s[e].width));return new cn(o,a)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class pn{constructor(e,t,r){var n;this.value=t,this.address=r,this.type=e.type,this.message=null!==(n=e.message)&&void 0!==n?n:""}toString(){return this.value}valueOf(){return this.value}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function gn(e,t,r){if(void 0===e)return Yi.defaultConfig[r];if("string"==typeof t){if(typeof e===t)return e;throw new Tt(t,r)}if(t.includes(e))return e;throw new bt(t.map((e=>`'${e}'`)).join(" "),r)}function fn(e,t,r){if(e<r)throw new Mt(t,r)}function mn(e,t,r,n){if(t(e))return e;if(void 0===e)return Yi.defaultConfig[n];throw new Tt(r,n)}function yn(...e){const t=new Map;e.forEach((e=>{const r=t.get(e.value)||[];r.push(e.name),t.set(e.value,r)}));const r=[];for(const e of t.values())e.length>1&&r.push(e);if(r.length>0){r.forEach((e=>e.sort()));const e=r.map((e=>`[${e}]`)).join("; ");throw new Error(`Config initialization failed. Parameters in conflict: ${e}`)}}function En(e,t,r){if(typeof e!==t)throw new Tt(t,r)}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const wn=new RegExp("^ss(\\.(s+|0+))?$"),Cn=new RegExp("^[0-9/.\\-: ]+[ap]?m?$"),vn=new RegExp("\\s+"),Rn=new RegExp("[ /.-]"),Sn=_n((function(e){const t=e.toLowerCase().trim(),r=(t.endsWith("am/pm")?t.substring(0,t.length-5):t.endsWith("a/p")?t.substring(0,e.length-3):t).trim().split(":");return{itemsCount:r.length,hourItem:r.indexOf("hh"),minuteItem:r.indexOf("mm"),secondItem:r.findIndex((e=>wn.test(e)))}})),Tn=_n((function(e){const t=e.toLowerCase().trim().split(Rn);return{itemsCount:t.length,dayItem:t.indexOf("dd"),monthItem:t.indexOf("mm"),shortYearItem:t.indexOf("yy"),longYearItem:t.indexOf("yyyy")}}));function Nn(e,t){var r,n,s;if(void 0===t)return;const{itemsCount:i,hourItem:o,minuteItem:a,secondItem:l}=Sn(t);let h;if("am"===e[e.length-1]||"a"===e[e.length-1]?(h=!1,e.pop()):"pm"!==e[e.length-1]&&"p"!==e[e.length-1]||(h=!0,e.pop()),e.length!==i)return;const u=Number(null!==(r=e[l])&&void 0!==r?r:"0");if(!Number.isFinite(u))return;const c=Math.round(1e3*u)/1e3,d=Number(null!==(n=e[a])&&void 0!==n?n:"0");if(!Number.isFinite(d)||!Number.isInteger(d))return;const p=Number(null!==(s=e[o])&&void 0!==s?s:"0");if(!Number.isFinite(p)||!Number.isInteger(p))return;if(void 0!==h&&(p<0||p>12))return;return{hours:void 0!==h?p%12+(h?12:0):p,minutes:d,seconds:c}}function Mn(e,t){var r;if(void 0===t)return;const{itemsCount:n,dayItem:s,monthItem:i,shortYearItem:o,longYearItem:a}=Tn(t);if(e.length!==n)return;const l=Number(e[s]);if(!Number.isFinite(l)||!Number.isInteger(l))return;const h=Number(e[i]);if(!Number.isFinite(h)||!Number.isInteger(h))return;if(e[a]&&e[o])return;const u=Number(null!==(r=e[a])&&void 0!==r?r:e[o]);return Number.isFinite(u)&&Number.isInteger(u)&&!(e[a]&&(u<1e3||u>9999)||e[o]&&(u<0||u>99))?{year:u,month:h,day:l}:void 0}function _n(e){const t={};return r=>{const n=t[r];if(void 0!==n)return n;const s=e(r);return t[r]=s,s}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const bn=[31,28,31,30,31,30,31,31,30,31,30,31],An=[0,31,59,90,120,151,181,212,243,273,304,334];function On(e){return!(!e||"object"!=typeof e&&"function"!=typeof e)&&("year"in e&&"number"==typeof e.year&&"month"in e&&"number"==typeof e.month&&"day"in e&&"number"==typeof e.day)}function In(e){return!(!e||"object"!=typeof e&&"function"!=typeof e)&&("hours"in e&&"number"==typeof e.hours&&"minutes"in e&&"number"==typeof e.minutes&&"seconds"in e&&"number"==typeof e.seconds)}const xn={year:9999,month:12,day:31};class Pn{constructor(e){this.config=e,this.minDateAbsoluteValue=this.dateToNumberFromZero(e.nullDate),this.maxDateValue=this.dateToNumber(xn),this.leapYear1900=e.leapYear1900,!this.leapYear1900&&0<=this.dateToNumber({year:1900,month:2,day:28})?this.epochYearZero=this.numberToSimpleDate(2).year:this.epochYearZero=this.numberToSimpleDate(1).year,this.parseDateTime=e.parseDateTime}getWithinBounds(e){return e<=this.maxDateValue&&e>=0?e:void 0}dateStringToDateNumber(e){const{dateTime:t,dateFormat:r="",timeFormat:n=""}=this.parseDateTimeFromConfigFormats(e);if(void 0!==t)return In(t)?On(t)?new qe(Hn(t)+this.dateToNumber(t),r+" "+n):new Xe(Hn(t),n):On(t)?new $e(this.dateToNumber(t),r):0}parseDateTimeFromConfigFormats(e){return this.parseDateTimeFromFormats(e,this.config.dateFormats,this.config.timeFormats)}getNullYear(){return this.config.nullYear}getEpochYearZero(){return this.epochYearZero}isValidDate(e){return!(isNaN(e.year)||isNaN(e.month)||isNaN(e.day))&&(e.day===Math.round(e.day)&&e.month===Math.round(e.month)&&e.year===Math.round(e.year)&&(!(e.year<1582)&&(!(e.month<1||e.month>12)&&(!(e.day<1)&&(this.isLeapYear(e.year)&&2===e.month?e.day<=29:e.day<=bn[e.month-1])))))}dateToNumber(e){return this.dateToNumberFromZero(e)-this.minDateAbsoluteValue}relativeNumberToAbsoluteNumber(e){return e+this.minDateAbsoluteValue-(this.leapYear1900?1:0)}numberToSimpleDate(e){const t=Math.floor(e)+this.minDateAbsoluteValue;let r=Math.floor(t/365.2425);this.dateToNumberFromZero({year:r+1,month:1,day:1})<=t?r++:this.dateToNumberFromZero({year:r-1,month:1,day:1})>t&&r--;const n=t-this.dateToNumberFromZero({year:r,month:1,day:1}),s=function(e){let t=0;An[t+6]<=e&&(t+=6);An[t+3]<=e&&(t+=3);An[t+2]<=e?t+=2:An[t+1]<=e&&(t+=1);return t}(n-(this.isLeapYear(r)&&n>=59?1:0));return{year:r,month:s+1,day:n-An[s]-(this.isLeapYear(r)&&s>1?1:0)+1}}numberToSimpleDateTime(e){const t=kn(e%1),r=Math.floor(t.hours/24);t.hours=t.hours%24;const n=this.numberToSimpleDate(Math.floor(e)+r);return Object.assign(Object.assign({},n),t)}leapYearsCount(e){return Math.floor(e/4)-Math.floor(e/100)+Math.floor(e/400)+(this.config.leapYear1900&&e>=1900?1:0)}daysInMonth(e,t){return this.isLeapYear(e)&&2===t?29:bn[t-1]}endOfMonth(e){return{year:e.year,month:e.month,day:this.daysInMonth(e.year,e.month)}}toBasisUS(e,t){return 31===e.day&&(e.day=30),30===e.day&&31===t.day&&(t.day=30),2===e.month&&e.day===this.daysInMonth(e.year,e.month)&&(e.day=30,2===t.month&&t.day===this.daysInMonth(t.year,t.month)&&(t.day=30)),[e,t]}yearLengthForBasis(e,t){return e.year!==t.year?e.year+1!==t.year||e.month<t.month||e.month===t.month&&e.day<t.day?(this.leapYearsCount(t.year)-this.leapYearsCount(e.year-1))/(t.year-e.year+1)+365:this.countLeapDays(t)!==this.countLeapDays({year:e.year,month:e.month,day:e.day-1})?366:365:this.isLeapYear(e.year)?366:365}parseSingleFormat(e,t,r){const n=this.parseDateTime(e,t,r);if(!On(n)||(n.year>=0&&n.year<100&&(n.year<this.getNullYear()?n.year+=2e3:n.year+=1900),this.isValidDate(n)))return n}parseDateTimeFromFormats(e,t,r){const n=0===t.length?[void 0]:t,s=0===r.length?[void 0]:r;for(const t of n)for(const r of s){const n=this.parseSingleFormat(e,t,r);if(void 0!==n)return{dateTime:n,timeFormat:r,dateFormat:t}}return{}}countLeapDays(e){return e.month>2||2===e.month&&e.day>=29?this.leapYearsCount(e.year):this.leapYearsCount(e.year-1)}dateToNumberFromZero(e){return 365*e.year+An[e.month-1]+e.day-1+(e.month<=2?this.leapYearsCount(e.year-1):this.leapYearsCount(e.year))}isLeapYear(e){return!(e%4)&&(!!(e%100)||(!(e%400)||1900===e&&this.config.leapYear1900))}}function Ln(e,t){const r=12*e.year+e.month-1+t;return{year:Math.floor(r/12),month:r%12+1,day:e.day}}function Dn(e){return Math.round(3600*e*24)/86400}function kn(e){const t=24*e*60*60,r=function(e,t=1){return Math.round(e*t)/t}(t%60,1e5)%60,n=(t-r)/60,s=Math.round(n%60)%60,i=(n-s)/60;return{hours:Math.round(i),minutes:s,seconds:r}}function Hn(e){return((e.seconds/60+e.minutes)/60+e.hours)/24}function Fn(e){return{year:e.year,month:e.month,day:Math.min(30,e.day)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const Un=/(\\.|dd|DD|d|D|mm|MM|m|M|YYYY|YY|yyyy|yy|HH|hh|H|h|ss(\.(0+|s+))?|s|AM\/PM|am\/pm|A\/P|a\/p|\[mm]|\[MM]|\[hh]|\[HH])/g,Vn=/(\\.|[#0]+(\.[#0]*)?)/g;var Bn,Wn;function Yn(e,t){return{type:e,value:t}}function Gn(e,t){const r=[];let n=0;for(let s=0;s<e.length;++s){const i=e[s];if(i.index!==n){const e=t.substr(n,i.index-n);r.push(Yn(Bn.FREE_TEXT,e))}i[0].startsWith("\\")?r.push(Yn(Bn.FREE_TEXT,i[0])):r.push(Yn(Bn.FORMAT,i[0])),n=i.index+i[0].length}const s=e[e.length-1];if(s.index+s[0].length<t.length){const e=t.substr(s.index+s[0].length,t.length);r.push(Yn(Bn.FREE_TEXT,e))}return r}function jn(e){const t=function(e){Un.lastIndex=0;const t=[];let r;do{r=Un.exec(e),null!==r&&t.push(r)}while(r);return t}(e);return t.every((e=>$n(e)))?void 0:{type:Wn.DATE,tokens:Gn(t,e)}}function zn(e){const t=function(e){Vn.lastIndex=0;const t=Vn.exec(e);return null!==t?[t]:[]}(e);return t.every((e=>$n(e)))?void 0:{type:Wn.NUMBER,tokens:Gn(t,e)}}function $n(e){return e[0].startsWith("\\")}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function Kn(e,t,r,n){const s=r.stringifyDateTime(n.numberToSimpleDateTime(e),t);if(void 0!==s)return s;const i=r.stringifyDuration(kn(e),t);if(void 0!==i)return i;const o=zn(t);return void 0!==o?function(e,t){let r="";for(let n=0;n<e.length;++n){const s=e[n];if(s.type===Bn.FREE_TEXT){r+=s.value;continue}const i=s.value.split("."),o=i[0],a=i[1]||"",l=i[1]?".":"",h=Number(t.toFixed(a.length)).toString().split(".");let u=h[0]||"",c=h[1]||"";if(o.length>u.length){u=Xn(u,Qn(o.substr(0,o.length-u.length),"0")+u.length)}c=qn(c,Qn(a.substr(c.length,a.length-c.length),"0")+c.length),r+=u+l+c}return r}(o.tokens,e):t}function Xn(e,t){let r=`${e}`;for(;r.length<t;)r="0"+r;return r}function qn(e,t){let r=`${e}`;for(;r.length<t;)r+="0";return r}function Qn(e,t){return e.split(t).length-1}!function(e){e.FORMAT="FORMAT",e.FREE_TEXT="FREE_TEXT"}(Bn||(Bn={})),function(e){e.DATE="DATE",e.NUMBER="NUMBER",e.STRING="STRING"}(Wn||(Wn={}));
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const Zn="length",Jn=e=>parseInt(e,16),es=e=>parseInt(e,10),ts=e=>(e+"").replace(/\-/g,""),rs=(e,t,r)=>e.substr(t,r),ns=e=>e.codePointAt(0)-65;
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const ss={invalid:()=>"The license key for HyperFormula is invalid.",expired:({keyValidityDate:e})=>`The license key for HyperFormula expired on ${e}, and is not valid for the installed version.`,missing:()=>"The license key for HyperFormula is missing."};let is=!1;function os(e){const t={template:"missing",vars:{}};if("gpl-v3"===e||"internal-use-in-handsontable"===e)t.template="valid";else if("string"==typeof e&&function(e){if((e=(e+"").replace(/\-/g,""))[Zn]!==ns("Z"))return!1;let t=0;return[[0,ns("G")+1],[ns("H"),ns("H")-1],[ns("G")+ns("H"),ns("G")]].reduce(((r,[n,s],i)=>(r|=(es(`${es(Jn(rs(e,t+n-(0===i?0:2),s+(i?2:0)))+(Jn(rs(e,t+n+s,2))+[]).padStart(2,"0"))}`)%97||2)>>1,t+=2,r)),ns("A"))===[]+1>>1}(e)){const[n,s,i]="18/07/2024".split("/"),o=Math.floor(new Date(`${s}/${n}/${i}`).getTime()/864e5),a=25===ts(r=e)[Zn]?Jn(rs(ts(r),Jn("12"),ns("F")))/(Jn(rs(ts(r),ns("C"),ns("Y")>>4))||1+(![][Zn]<<3)):0;t.vars.keyValidityDate=function(e){const t=["January","February","March","April","May","June","July","August","September","October","November","December"][e.getMonth()],r=e.getDate(),n=e.getFullYear();return`${t} ${r}, ${n}`}(new Date(864e5*(a+1))),t.template=o>a?"expired":"valid"}else""!==e&&(t.template="invalid");var r;return is||"valid"===t.template||(console.warn(ss[t.template](t.vars)),is=!0),t.template}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
var as,ls,hs;!function(e){e.Number=class{constructor(e){this.value=e,this.value=ze(this.value,Jr(Ge(this.value)))}};e.String=class{constructor(e){this.value=e}};e.Boolean=class{constructor(e){this.value=e}};class t{static getSingletonInstance(){return t.instance||(t.instance=new t),t.instance}}e.Empty=t;e.Formula=class{constructor(e){this.formula=e}};e.Error=class{constructor(e,t){this.value=new Tr(e,t)}}}(as||(as={}));class us{constructor(e,t,r){this.config=e,this.dateHelper=t,this.numberLiteralsHelper=r}parse(e){if(null==e)return as.Empty.getSingletonInstance();if("number"==typeof e)return Zr(e)?new as.Error(ir.NUM,Z.ValueLarge):new as.Number(e);if("boolean"==typeof e)return new as.Boolean(e);if(e instanceof Date){const t=this.dateHelper.dateToNumber({day:e.getDate(),month:e.getMonth()+1,year:e.getFullYear()})+Hn({hours:e.getHours(),minutes:e.getMinutes(),seconds:e.getSeconds()+e.getMilliseconds()/1e3});return t<0?new as.Error(ir.NUM,Z.DateBounds):t%1==0?new as.Number(new $e(t,"Date()")):t<1?new as.Number(new Xe(t,"Date()")):new as.Number(new qe(t,"Date()"))}if("string"==typeof e){if(function(e){const t=e.toLowerCase();return"true"===t||"false"===t}(e))return new as.Boolean("true"===e.toLowerCase());if(e.startsWith("="))return new as.Formula(e);if(function(e,t){const r=e.toUpperCase();return/#[A-Za-z0-9\/]+[?!]?/.test(r)&&Object.prototype.hasOwnProperty.call(t,r)}(e,this.config.errorMapping))return new as.Error(this.config.errorMapping[e.toUpperCase()]);{let t,r=e.trim(),n=0;if(r.endsWith("%"))n=1,r=r.slice(0,r.length-1);else{const e=this.currencyMatcher(r);void 0!==e&&(n=2,[t,r]=e)}const s=this.numberLiteralsHelper.numericStringToMaybeNumber(r);if(void 0!==s){let e;return e=1===n?new Qe(s/100):2===n?new Ke(s,t):s,new as.Number(e)}const i=this.dateHelper.dateStringToDateNumber(r);return void 0!==i?new as.Number(i):new as.String(e.startsWith("'")?e.slice(1):e)}}throw new St(e)}currencyMatcher(e){for(const t of this.config.currencySymbol){if(e.startsWith(t))return[t,e.slice(t.length)];if(e.endsWith(t))return[t,e.slice(0,e.length-t.length)]}}}!function(e){e[e.COPY=0]="COPY",e[e.CUT=1]="CUT"}(ls||(ls={})),function(e){e[e.VALUE=0]="VALUE",e[e.EMPTY=1]="EMPTY",e[e.FORMULA=2]="FORMULA",e[e.PARSING_ERROR=3]="PARSING_ERROR"}(hs||(hs={}));class cs{constructor(e,t,r,n,s){this.sourceLeftCorner=e,this.width=t,this.height=r,this.type=n,this.content=s}*getContent(e){if(void 0!==this.content)for(let t=0;t<this.height;++t)for(let r=0;r<this.width;++r)yield[Ar(e.sheet,e.col+r,e.row+t),this.content[t][r]]}}class ds{constructor(e,t,r){this.dependencyGraph=t,this.operations=r,this.maxRows=e.maxRows,this.maxColumns=e.maxColumns}cut(e,t,r){this.clipboard=new cs(e,t,r,ls.CUT)}copy(e,t,r){const n=[];for(let s=0;s<r;++s){n[s]=[];for(let r=0;r<t;++r){const t=this.operations.getClipboardCell(Ar(e.sheet,e.col+r,e.row+s));n[s].push(t)}}this.clipboard=new cs(e,t,r,ls.COPY,n)}abortCut(){this.clipboard&&this.clipboard.type===ls.CUT&&this.clear()}clear(){this.clipboard=void 0}ensureItIsPossibleToCopyPaste(e){if(void 0===this.clipboard)return;if(Or(e)||!this.dependencyGraph.sheetMapping.hasSheetWithId(e.sheet))throw new gt("a valid target address.");const t=Fr.spanFrom(e,this.clipboard.width,this.clipboard.height);if(t.exceedsSheetSizeLimits(this.maxColumns,this.maxRows))throw new ct;if(this.dependencyGraph.arrayMapping.isFormulaArrayInRange(t))throw new Error("It is not possible to paste onto an array")}isCutClipboard(){return void 0!==this.clipboard&&this.clipboard.type===ls.CUT}isCopyClipboard(){return void 0!==this.clipboard&&this.clipboard.type===ls.COPY}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ps{constructor(e,t,r,n){this.displayName=e,this.address=t,this.added=r,this.options=n}normalizeExpressionName(){return this.displayName.toLowerCase()}copy(){return new ps(this.displayName,this.address,this.added,this.options)}}class gs{constructor(){this.mapping=new Map}has(e){return this.mapping.has(this.normalizeExpressionName(e))}isNameAvailable(e){const t=this.normalizeExpressionName(e),r=this.mapping.get(t);return!(r&&r.added)}add(e){this.mapping.set(e.normalizeExpressionName(),e)}get(e){return this.mapping.get(this.normalizeExpressionName(e))}getExisting(e){const t=this.mapping.get(this.normalizeExpressionName(e));return t&&t.added?t:void 0}remove(e){const t=this.normalizeExpressionName(e),r=this.mapping.get(t);r&&(r.added=!1)}getAllNamedExpressions(){return Array.from(this.mapping.values()).filter((e=>e.added))}normalizeExpressionName(e){return e.toLowerCase()}}class fs{constructor(){this.mapping=new Map}add(e){this.mapping.set(this.normalizeExpressionName(e.displayName),e)}get(e){return this.mapping.get(this.normalizeExpressionName(e))}has(e){return this.mapping.has(this.normalizeExpressionName(e))}getAllNamedExpressions(){return Array.from(this.mapping.values()).filter((e=>e.added))}isNameAvailable(e){const t=this.normalizeExpressionName(e);return!this.mapping.has(t)}remove(e){const t=this.normalizeExpressionName(e);this.mapping.get(t)&&this.mapping.delete(t)}normalizeExpressionName(e){return e.toLowerCase()}}class ms{constructor(){this.nextNamedExpressionRow=0,this.workbookStore=new gs,this.worksheetStores=new Map,this.addressCache=new Map}isNameAvailable(e,t){var r,n;return void 0===t?this.workbookStore.isNameAvailable(e):null===(n=null===(r=this.worksheetStore(t))||void 0===r?void 0:r.isNameAvailable(e))||void 0===n||n}namedExpressionInAddress(e){const t=this.addressCache.get(e);return t&&t.added?t:void 0}namedExpressionForScope(e,t){var r;return void 0===t?this.workbookStore.getExisting(e):null===(r=this.worksheetStore(t))||void 0===r?void 0:r.get(e)}nearestNamedExpression(e,t){var r,n;return null!==(n=null===(r=this.worksheetStore(t))||void 0===r?void 0:r.get(e))&&void 0!==n?n:this.workbookStore.getExisting(e)}isExpressionInScope(e,t){var r,n;return null!==(n=null===(r=this.worksheetStore(t))||void 0===r?void 0:r.has(e))&&void 0!==n&&n}isNameValid(e){const t=new RegExp(`^${f}$`),r=new RegExp(`^${E}$`),n=new RegExp(`^${C}$`);return!t.test(e)&&!r.test(e)&&n.test(e)}addNamedExpression(e,t,r){const n=void 0===t?this.workbookStore:this.worksheetStoreOrCreate(t);let s=n.get(e);return void 0!==s?(s.added=!0,s.displayName=e,s.options=r):(s=new ps(e,this.nextAddress(),!0,r),n.add(s)),this.addressCache.set(s.address.row,s),s}restoreNamedExpression(e,t){const r=void 0===t?this.workbookStore:this.worksheetStoreOrCreate(t);return e.added=!0,r.add(e),this.addressCache.set(e.address.row,e),e}namedExpressionOrPlaceholder(e,t){var r;return null!==(r=this.worksheetStoreOrCreate(t).get(e))&&void 0!==r?r:this.workbookNamedExpressionOrPlaceholder(e)}workbookNamedExpressionOrPlaceholder(e){let t=this.workbookStore.get(e);return void 0===t&&(t=new ps(e,this.nextAddress(),!1),this.workbookStore.add(t)),t}remove(e,t){let r;r=void 0===t?this.workbookStore:this.worksheetStore(t);const n=null==r?void 0:r.get(e);if(void 0===r||void 0===n||!n.added)throw Error("Named expression does not exist");r.remove(e),r instanceof fs&&0===r.mapping.size&&this.worksheetStores.delete(t),this.addressCache.delete(n.address.row)}getAllNamedExpressionsNamesInScope(e){return this.getAllNamedExpressions().filter((({scope:t})=>t===e)).map((e=>e.expression.displayName))}getAllNamedExpressionsNames(){return this.getAllNamedExpressions().map((e=>e.expression.displayName))}getAllNamedExpressions(){const e=[];return this.workbookStore.getAllNamedExpressions().forEach((t=>{e.push({expression:t,scope:void 0})})),this.worksheetStores.forEach(((t,r)=>{t.getAllNamedExpressions().forEach((t=>{e.push({expression:t,scope:r})}))})),e}getAllNamedExpressionsForScope(e){var t,r;return void 0===e?this.workbookStore.getAllNamedExpressions():null!==(r=null===(t=this.worksheetStores.get(e))||void 0===t?void 0:t.getAllNamedExpressions())&&void 0!==r?r:[]}worksheetStoreOrCreate(e){let t=this.worksheetStores.get(e);return t||(t=new fs,this.worksheetStores.set(e,t)),t}worksheetStore(e){return this.worksheetStores.get(e)}nextAddress(){return Ar(ms.SHEET_FOR_WORKBOOK_EXPRESSIONS,0,this.nextNamedExpressionRow++)}}ms.SHEET_FOR_WORKBOOK_EXPRESSIONS=-1;const ys=e=>{switch(e.type){case U.EMPTY:case U.NUMBER:case U.STRING:case U.ERROR:case U.ERROR_WITH_RAW_INPUT:return!1;case U.CELL_REFERENCE:return!e.reference.isAbsolute();case U.CELL_RANGE:case U.COLUMN_RANGE:case U.ROW_RANGE:return!e.start.isAbsolute();case U.NAMED_EXPRESSION:return!1;case U.PERCENT_OP:case U.PLUS_UNARY_OP:case U.MINUS_UNARY_OP:return ys(e.value);case U.CONCATENATE_OP:case U.EQUALS_OP:case U.NOT_EQUAL_OP:case U.LESS_THAN_OP:case U.GREATER_THAN_OP:case U.LESS_THAN_OR_EQUAL_OP:case U.GREATER_THAN_OR_EQUAL_OP:case U.MINUS_OP:case U.PLUS_OP:case U.TIMES_OP:case U.DIV_OP:case U.POWER_OP:return ys(e.left)||ys(e.right);case U.PARENTHESIS:return ys(e.expression);case U.FUNCTION_CALL:return e.args.some((e=>ys(e)));case U.ARRAY:return e.args.some((e=>e.some((e=>ys(e)))))}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Es{performEagerTransformations(e,t){for(const r of e.arrayFormulaNodes()){const[n,s]=this.transformSingleAst(r.getFormula(e.lazilyTransformingAstService),r.getAddress(e.lazilyTransformingAstService)),i=t.rememberNewAst(n);r.setFormula(i),r.setAddress(s)}}transformSingleAst(e,t){return[this.transformAst(e,t),this.fixNodeAddress(t)]}transformAst(e,t){switch(e.type){case U.CELL_REFERENCE:return this.transformCellReferenceAst(e,t);case U.CELL_RANGE:return this.transformCellRangeAst(e,t);case U.COLUMN_RANGE:return this.transformColumnRangeAst(e,t);case U.ROW_RANGE:return this.transformRowRangeAst(e,t);case U.EMPTY:case U.ERROR:case U.NUMBER:case U.NAMED_EXPRESSION:case U.ERROR_WITH_RAW_INPUT:case U.STRING:return e;case U.PERCENT_OP:case U.MINUS_UNARY_OP:case U.PLUS_UNARY_OP:return Object.assign(Object.assign({},e),{value:this.transformAst(e.value,t)});case U.FUNCTION_CALL:return Object.assign(Object.assign({},e),{procedureName:e.procedureName,args:e.args.map((e=>this.transformAst(e,t)))});case U.PARENTHESIS:return Object.assign(Object.assign({},e),{expression:this.transformAst(e.expression,t)});case U.ARRAY:return Object.assign(Object.assign({},e),{args:e.args.map((e=>e.map((e=>this.transformAst(e,t)))))});default:return Object.assign(Object.assign({},e),{left:this.transformAst(e.left,t),right:this.transformAst(e.right,t)})}}transformCellReferenceAst(e,t){const r=this.transformCellAddress(e.reference,t);return r instanceof l?Object.assign(Object.assign({},e),{reference:r}):r===ir.REF?G(new Tr(ir.REF)):e}transformCellRangeAst(e,t){const r=this.transformCellRange(e.start,e.end,t);return Array.isArray(r)?Object.assign(Object.assign({},e),{start:r[0],end:r[1]}):r===ir.REF?G(new Tr(ir.REF)):e}transformColumnRangeAst(e,t){const r=this.transformColumnRange(e.start,e.end,t);return Array.isArray(r)?Object.assign(Object.assign({},e),{start:r[0],end:r[1]}):r===ir.REF?G(new Tr(ir.REF)):e}transformRowRangeAst(e,t){const r=this.transformRowRange(e.start,e.end,t);return Array.isArray(r)?Object.assign(Object.assign({},e),{start:r[0],end:r[1]}):r===ir.REF?G(new Tr(ir.REF)):e}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ws extends Es{constructor(e){super(),this.columnsSpan=e}get sheet(){return this.columnsSpan.sheet}isIrreversible(){return!1}transformRowRangeAst(e,t){return e}transformCellRange(e,t,r){return this.transformRange(e,t,r)}transformRowRange(e,t,r){throw Error("Not implemented")}transformColumnRange(e,t,r){return this.transformRange(e,t,r)}transformCellAddress(e,t){const r=Lr(e,t);if(r!==this.columnsSpan.sheet&&t.sheet!==this.columnsSpan.sheet)return!1;const n=e.toSimpleColumnAddress(t);if(r===this.columnsSpan.sheet&&t.sheet!==this.columnsSpan.sheet)return this.columnsSpan.columnStart<=n.col&&e.shiftedByColumns(this.columnsSpan.numberOfColumns);if(t.sheet===this.columnsSpan.sheet&&r!==this.columnsSpan.sheet)return!e.isColumnAbsolute()&&(!(t.col<this.columnsSpan.columnStart)&&e.shiftedByColumns(-this.columnsSpan.numberOfColumns));if(e.isColumnAbsolute())return!(e.col<this.columnsSpan.columnStart)&&e.shiftedByColumns(this.columnsSpan.numberOfColumns);return e.toSimpleColumnAddress(t).col<this.columnsSpan.columnStart?!(t.col<this.columnsSpan.columnStart)&&e.shiftedByColumns(-this.columnsSpan.numberOfColumns):t.col<this.columnsSpan.columnStart&&e.shiftedByColumns(this.columnsSpan.numberOfColumns)}fixNodeAddress(e){return this.columnsSpan.sheet===e.sheet&&this.columnsSpan.columnStart<=e.col?Object.assign(Object.assign({},e),{col:e.col+this.columnsSpan.numberOfColumns}):e}transformRange(e,t,r){const n=this.transformCellAddress(e,r),s=this.transformCellAddress(t,r);return n===ir.REF||s===ir.REF?ir.REF:!(!n&&!s)&&[n||e,s||t]}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Cs extends Es{constructor(e){super(),this.rowsSpan=e}get sheet(){return this.rowsSpan.sheet}isIrreversible(){return!1}transformColumnRangeAst(e,t){return e}transformCellRange(e,t,r){return this.transformRange(e,t,r)}transformRowRange(e,t,r){return this.transformRange(e,t,r)}transformColumnRange(e,t,r){throw Error("Not implemented")}transformCellAddress(e,t){const r=Lr(e,t);if(r!==this.rowsSpan.sheet&&t.sheet!==this.rowsSpan.sheet)return!1;const n=e.toSimpleRowAddress(t);return r===this.rowsSpan.sheet&&t.sheet!==this.rowsSpan.sheet?this.rowsSpan.rowStart<=n.row&&e.shiftedByRows(this.rowsSpan.numberOfRows):t.sheet===this.rowsSpan.sheet&&r!==this.rowsSpan.sheet?!e.isRowAbsolute()&&(!(t.row<this.rowsSpan.rowStart)&&e.shiftedByRows(-this.rowsSpan.numberOfRows)):e.isRowAbsolute()?!(e.row<this.rowsSpan.rowStart)&&e.shiftedByRows(this.rowsSpan.numberOfRows):n.row<this.rowsSpan.rowStart?!(t.row<this.rowsSpan.rowStart)&&e.shiftedByRows(-this.rowsSpan.numberOfRows):t.row<this.rowsSpan.rowStart&&e.shiftedByRows(this.rowsSpan.numberOfRows)}fixNodeAddress(e){return this.rowsSpan.sheet===e.sheet&&this.rowsSpan.rowStart<=e.row?Object.assign(Object.assign({},e),{row:e.row+this.rowsSpan.numberOfRows}):e}transformRange(e,t,r){const n=this.transformCellAddress(e,r),s=this.transformCellAddress(t,r);return n===ir.REF||s===ir.REF?ir.REF:!(!n&&!s)&&[n||e,s||t]}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class vs extends Es{constructor(e){super(),this.sheet=e}isIrreversible(){return!0}fixNodeAddress(e){return e}transformCellAddress(e,t){return!!e.isInvalid(t)&&ir.REF}transformCellRange(e,t,r){return!(!e.isInvalid(r)&&!t.isInvalid(r))&&ir.REF}transformColumnRange(e,t,r){return!(!e.isInvalid(r)&&!t.isInvalid(r))&&ir.REF}transformRowRange(e,t,r){return!(!e.isInvalid(r)&&!t.isInvalid(r))&&ir.REF}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Rs extends Es{constructor(e,t,r,n){super(),this.sourceRange=e,this.toRight=t,this.toBottom=r,this.toSheet=n,this.dependentFormulaTransformer=new Ss(e,t,r,n)}get sheet(){return this.sourceRange.sheet}isIrreversible(){return!0}transformSingleAst(e,t){if(this.sourceRange.addressInRange(t)){return[this.transformAst(e,t),this.fixNodeAddress(t)]}return this.dependentFormulaTransformer.transformSingleAst(e,t)}fixNodeAddress(e){return Ar(this.toSheet,e.col+this.toRight,e.row+this.toBottom)}transformCellAddress(e,t){return this.transformAddress(e,t)}transformCellRange(e,t,r){return this.transformRange(e,t,r)}transformColumnRange(e,t,r){return this.transformRange(e,t,r)}transformRowRange(e,t,r){return this.transformRange(e,t,r)}transformAddress(e,t){const r=this.sourceRange;if(e instanceof l){const n=e.toSimpleCellAddress(t);if(r.addressInRange(n))return e.shiftAbsoluteDimensions(this.toRight,this.toBottom)}return e.shiftRelativeDimensions(-this.toRight,-this.toBottom)}transformRange(e,t,r){const n=this.sourceRange;if(e instanceof l&&t instanceof l){const s=e.toSimpleCellAddress(r),i=t.toSimpleCellAddress(r);if(n.addressInRange(s)&&n.addressInRange(i))return[e.shiftAbsoluteDimensions(this.toRight,this.toBottom),t.shiftAbsoluteDimensions(this.toRight,this.toBottom)]}return[e.shiftRelativeDimensions(-this.toRight,-this.toBottom),t.shiftRelativeDimensions(-this.toRight,-this.toBottom)]}}class Ss extends Es{constructor(e,t,r,n){super(),this.sourceRange=e,this.toRight=t,this.toBottom=r,this.toSheet=n}get sheet(){return this.sourceRange.sheet}isIrreversible(){return!0}fixNodeAddress(e){return e}transformCellAddress(e,t){return!!this.shouldMove(e,t)&&e.moved(this.toSheet,this.toRight,this.toBottom)}transformCellRange(e,t,r){return this.transformRange(e,t,r)}transformColumnRange(e,t,r){return this.transformRange(e,t,r)}transformRowRange(e,t,r){return this.transformRange(e,t,r)}shouldMove(e,t){return e instanceof l?this.sourceRange.addressInRange(e.toSimpleCellAddress(t)):e instanceof a?this.sourceRange.rowInRange(e.toSimpleRowAddress(t))&&!this.sourceRange.isFinite():this.sourceRange.columnInRange(e.toSimpleColumnAddress(t))&&!this.sourceRange.isFinite()}transformRange(e,t,r){const n=this.transformCellAddress(e,r),s=this.transformCellAddress(t,r);return!(!n||!s)&&[n,s]}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ts extends Es{constructor(e){super(),this.columnsSpan=e}get sheet(){return this.columnsSpan.sheet}isIrreversible(){return!0}transformRowRangeAst(e,t){return e}transformCellRange(e,t,r){return this.transformRange(e,t,r)}transformRowRange(e,t,r){throw Error("Not implemented")}transformColumnRange(e,t,r){return this.transformRange(e,t,r)}transformCellAddress(e,t){const r=Lr(e,t);if(this.columnsSpan.sheet!==t.sheet&&this.columnsSpan.sheet!==r)return!1;if(this.columnsSpan.sheet!==t.sheet&&this.columnsSpan.sheet===r){const r=e.toSimpleColumnAddress(t);if(r.col<this.columnsSpan.columnStart)return!1;if(r.col>this.columnsSpan.columnEnd)return e.shiftedByColumns(-this.columnsSpan.numberOfColumns)}if(this.columnsSpan.sheet===t.sheet&&this.columnsSpan.sheet!==r){if(e.isColumnAbsolute())return!1;if(t.col<this.columnsSpan.columnStart)return!1;if(t.col>this.columnsSpan.columnEnd)return e.shiftedByColumns(this.columnsSpan.numberOfColumns)}if(this.columnsSpan.sheet===t.sheet&&this.columnsSpan.sheet===r)if(e.isColumnAbsolute()){if(e.col<this.columnsSpan.columnStart)return!1;if(e.col>this.columnsSpan.columnEnd)return e.shiftedByColumns(-this.columnsSpan.numberOfColumns)}else{const r=e.toSimpleColumnAddress(t);if(r.col<this.columnsSpan.columnStart){if(t.col<this.columnsSpan.columnStart)return!1;if(t.col>this.columnsSpan.columnEnd)return e.shiftedByColumns(this.columnsSpan.numberOfColumns)}else if(r.col>this.columnsSpan.columnEnd){if(t.col<this.columnsSpan.columnStart)return e.shiftedByColumns(-this.columnsSpan.numberOfColumns);if(t.col>this.columnsSpan.columnEnd)return!1}}return ir.REF}fixNodeAddress(e){return this.columnsSpan.sheet===e.sheet&&this.columnsSpan.columnStart<=e.col?Object.assign(Object.assign({},e),{col:e.col-this.columnsSpan.numberOfColumns}):e}transformRange(e,t,r){const n=Lr(e,r);let s=e,i=t;if(this.columnsSpan.sheet===n){const n=e.toSimpleColumnAddress(r),o=t.toSimpleColumnAddress(r);if(this.columnsSpan.columnStart<=n.col&&this.columnsSpan.columnEnd>=o.col)return ir.REF;n.col>=this.columnsSpan.columnStart&&n.col<=this.columnsSpan.columnEnd&&(s=e.shiftedByColumns(this.columnsSpan.columnEnd-n.col+1)),o.col>=this.columnsSpan.columnStart&&o.col<=this.columnsSpan.columnEnd&&(i=t.shiftedByColumns(-(o.col-this.columnsSpan.columnStart+1)))}const o=this.transformCellAddress(s,r),a=this.transformCellAddress(i,r);if(!1===o&&!1===a)return[s,i];if(o===ir.REF||a===ir.REF)throw Error("Cannot happen");return[o||s,a||i]}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ns extends Es{constructor(e){super(),this.rowsSpan=e}get sheet(){return this.rowsSpan.sheet}isIrreversible(){return!0}transformColumnRangeAst(e,t){return e}transformCellAddress(e,t){const r=Lr(e,t);if(this.rowsSpan.sheet!==t.sheet&&this.rowsSpan.sheet!==r)return!1;if(this.rowsSpan.sheet!==t.sheet&&this.rowsSpan.sheet===r){const r=e.toSimpleRowAddress(t);if(r.row<this.rowsSpan.rowStart)return!1;if(r.row>this.rowsSpan.rowEnd)return e.shiftedByRows(-this.rowsSpan.numberOfRows)}if(this.rowsSpan.sheet===t.sheet&&this.rowsSpan.sheet!==r){if(e.isRowAbsolute())return!1;if(t.row<this.rowsSpan.rowStart)return!1;if(t.row>this.rowsSpan.rowEnd)return e.shiftedByRows(this.rowsSpan.numberOfRows)}if(this.rowsSpan.sheet===t.sheet&&this.rowsSpan.sheet===r)if(e.isRowAbsolute()){if(e.row<this.rowsSpan.rowStart)return!1;if(e.row>this.rowsSpan.rowEnd)return e.shiftedByRows(-this.rowsSpan.numberOfRows)}else{const r=e.toSimpleRowAddress(t);if(r.row<this.rowsSpan.rowStart){if(t.row<this.rowsSpan.rowStart)return!1;if(t.row>this.rowsSpan.rowEnd)return e.shiftedByRows(this.rowsSpan.numberOfRows)}else if(r.row>this.rowsSpan.rowEnd){if(t.row<this.rowsSpan.rowStart)return e.shiftedByRows(-this.rowsSpan.numberOfRows);if(t.row>this.rowsSpan.rowEnd)return!1}}return ir.REF}transformCellRange(e,t,r){return this.transformRange(e,t,r)}transformRowRange(e,t,r){return this.transformRange(e,t,r)}transformColumnRange(e,t,r){throw Error("Not implemented")}fixNodeAddress(e){return this.rowsSpan.sheet===e.sheet&&this.rowsSpan.rowStart<=e.row?Object.assign(Object.assign({},e),{row:e.row-this.rowsSpan.numberOfRows}):e}transformRange(e,t,r){const n=Lr(e,r);let s=e,i=t;if(this.rowsSpan.sheet===n){const n=e.toSimpleRowAddress(r),o=t.toSimpleRowAddress(r);if(this.rowsSpan.rowStart<=n.row&&this.rowsSpan.rowEnd>=o.row)return ir.REF;n.row>=this.rowsSpan.rowStart&&n.row<=this.rowsSpan.rowEnd&&(s=e.shiftedByRows(this.rowsSpan.rowEnd-n.row+1)),o.row>=this.rowsSpan.rowStart&&o.row<=this.rowsSpan.rowEnd&&(i=t.shiftedByRows(-(o.row-this.rowsSpan.rowStart+1)))}const o=this.transformCellAddress(s,r),a=this.transformCellAddress(i,r);return!1===o&&!1===a?[s,i]:o===ir.REF||a===ir.REF?ir.REF:[o||s,a||i]}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ms extends Es{constructor(e){super(),this.sheet=e}isIrreversible(){return!0}performEagerTransformations(e,t){for(const t of e.arrayFormulaNodes()){const[r]=this.transformSingleAst(t.getFormula(e.lazilyTransformingAstService),t.getAddress(e.lazilyTransformingAstService));t.setFormula(r)}}fixNodeAddress(e){return e}transformCellAddress(e,t){return this.transformAddress(e)}transformCellRange(e,t,r){return this.transformAddress(e)}transformColumnRange(e,t,r){return this.transformAddress(e)}transformRowRange(e,t,r){return this.transformAddress(e)}transformAddress(e){return e.sheet===this.sheet&&ir.REF}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function _s(e){if(!Array.isArray(e))throw new gt("an array of arrays.");for(let t=0;t<e.length;t++)if(!Array.isArray(e[t]))throw new gt("an array of arrays.")}function bs(e){let t=0,r=0,n=0;for(let s=0;s<e.length;s++){let i=0;for(let t=0;t<e[s].length;t++){const r=e[s][t];null!=r&&(i=t+1,++n)}t=Math.max(t,i),i>0&&(r=s+1)}const s=t*r;return{height:r,width:t,fill:0===s?0:n/s}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class As{constructor(e,t){this.sheet=e,this.indexes=t}normalizedIndexes(){return Ls(this.indexes)}rowsSpans(){return this.normalizedIndexes().map((e=>st.fromNumberOfRows(this.sheet,e[0],e[1])))}}class Os{constructor(e,t){this.sheet=e,this.indexes=t}normalizedIndexes(){return Ds(this.indexes)}rowsSpans(){return this.normalizedIndexes().map((e=>st.fromNumberOfRows(this.sheet,e[0],e[1])))}}class Is{constructor(e,t){this.sheet=e,this.indexes=t}normalizedIndexes(){return Ds(this.indexes)}columnsSpans(){return this.normalizedIndexes().map((e=>it.fromNumberOfColumns(this.sheet,e[0],e[1])))}}class xs{constructor(e,t){this.sheet=e,this.indexes=t}normalizedIndexes(){return Ls(this.indexes)}columnsSpans(){return this.normalizedIndexes().map((e=>it.fromNumberOfColumns(this.sheet,e[0],e[1])))}}class Ps{constructor(e,t,r,n,s,i,o,a,l){this.dependencyGraph=t,this.columnSearch=r,this.cellContentParser=n,this.parser=s,this.stats=i,this.lazilyTransformingAstService=o,this.namedExpressions=a,this.arraySizePredictor=l,this.changes=nt.empty(),this.allocateNamedExpressionAddressSpace(),this.maxColumns=e.maxColumns,this.maxRows=e.maxRows}get sheetMapping(){return this.dependencyGraph.sheetMapping}get addressMapping(){return this.dependencyGraph.addressMapping}removeRows(e){const t=[];for(const r of e.rowsSpans()){const e=this.doRemoveRows(r);e&&t.push(e)}return t}addRows(e){for(const t of e.rowsSpans())this.doAddRows(t)}addColumns(e){for(const t of e.columnsSpans())this.doAddColumns(t)}removeColumns(e){const t=[];for(const r of e.columnsSpans()){const e=this.doRemoveColumns(r);e&&t.push(e)}return t}removeSheet(e){this.dependencyGraph.removeSheet(e);let t=0;this.stats.measure(et.TRANSFORM_ASTS,(()=>{const r=new Ms(e);r.performEagerTransformations(this.dependencyGraph,this.parser),t=this.lazilyTransformingAstService.addTransformation(r)})),this.sheetMapping.removeSheet(e),this.columnSearch.removeSheet(e);const r=this.namedExpressions.getAllNamedExpressionsForScope(e).map((t=>this.removeNamedExpression(t.normalizeExpressionName(),e)));return{version:t,scopedNamedExpressions:r}}removeSheetByName(e){const t=this.sheetMapping.fetch(e);return this.removeSheet(t)}clearSheet(e){this.dependencyGraph.clearSheet(e),this.columnSearch.removeSheet(e)}addSheet(e){const t=this.sheetMapping.addSheet(e);return this.dependencyGraph.addressMapping.autoAddSheet(t,bs([])),this.sheetMapping.fetchDisplayName(t)}renameSheet(e,t){return this.sheetMapping.renameSheet(e,t)}moveRows(e,t,r,n){const s=st.fromNumberOfRows(e,n,r);this.lazilyTransformingAstService.beginCombinedMode(e),this.doAddRows(s),n<t&&(t+=r);const i=Ar(e,0,t),o=Ar(e,0,n);this.moveCells(i,Number.POSITIVE_INFINITY,r,o);const a=st.fromNumberOfRows(e,t,r);return this.doRemoveRows(a),this.lazilyTransformingAstService.commitCombinedMode()}moveColumns(e,t,r,n){const s=it.fromNumberOfColumns(e,n,r);this.lazilyTransformingAstService.beginCombinedMode(e),this.doAddColumns(s),n<t&&(t+=r);const i=Ar(e,t,0),o=Ar(e,n,0);this.moveCells(i,r,Number.POSITIVE_INFINITY,o);const a=it.fromNumberOfColumns(e,t,r);return this.doRemoveColumns(a),this.lazilyTransformingAstService.commitCombinedMode()}moveCells(e,t,r,n){this.ensureItIsPossibleToMoveCells(e,t,r,n);const s=Fr.spanFrom(e,t,r),i=Fr.spanFrom(n,t,r),o=n.col-e.col,a=n.row-e.row,l=n.sheet,h=this.getRangeClipboardCells(i),u=this.dependencyGraph.rawValuesFromRange(i);this.columnSearch.removeValues(u);const c=this.dependencyGraph.rawValuesFromRange(s);this.columnSearch.moveValues(c,o,a,l);let d=0;this.stats.measure(et.TRANSFORM_ASTS,(()=>{const e=new Rs(s,o,a,l);e.performEagerTransformations(this.dependencyGraph,this.parser),d=this.lazilyTransformingAstService.addTransformation(e)})),this.dependencyGraph.moveCells(s,o,a,l);const p=this.updateNamedExpressionsForMovedCells(e,t,r,n);return{version:d,overwrittenCellsData:h,addedGlobalNamedExpressions:p}}setRowOrder(e,t){const r=[];let n=[];for(const[s,i]of t)if(s!==i){const t=Fr.spanFrom({sheet:e,col:0,row:s},1/0,1),o=this.getRangeClipboardCells(t);n=n.concat(o),r.push(o.map((([{sheet:e,col:t},r])=>[{sheet:e,col:t,row:i},r])))}return r.forEach((t=>this.restoreClipboardCells(e,t.values()))),n}setColumnOrder(e,t){const r=[];let n=[];for(const[s,i]of t)if(s!==i){const t=Fr.spanFrom({sheet:e,col:s,row:0},1,1/0),o=this.getRangeClipboardCells(t);n=n.concat(o),r.push(o.map((([{sheet:e,col:t,row:r},n])=>[{sheet:e,col:i,row:r},n])))}return r.forEach((t=>this.restoreClipboardCells(e,t.values()))),n}addNamedExpression(e,t,r,n){const s=this.namedExpressions.addNamedExpression(e,r,n);this.storeNamedExpressionInCell(s.address,t),this.adjustNamedExpressionEdges(s,e,r)}restoreNamedExpression(e,t,r){const n=e.displayName;this.restoreCell(e.address,t);const s=this.namedExpressions.restoreNamedExpression(e,r);this.adjustNamedExpressionEdges(s,n,r)}changeNamedExpressionExpression(e,t,r,n){const s=this.namedExpressions.namedExpressionForScope(e,r);if(!s)throw new Et(e);const i=s.copy();s.options=n;const o=this.getClipboardCell(s.address);return this.storeNamedExpressionInCell(s.address,t),[i,o]}removeNamedExpression(e,t){const r=this.namedExpressions.namedExpressionForScope(e,t);if(!r)throw new Et(e);this.namedExpressions.remove(r.displayName,t);const n=this.getClipboardCell(r.address);if(void 0!==t){const t=this.namedExpressions.workbookNamedExpressionOrPlaceholder(e);this.dependencyGraph.exchangeNode(r.address,t.address)}else this.dependencyGraph.setCellEmpty(r.address);return[r,n]}ensureItIsPossibleToMoveCells(e,t,r,n){if(Or(e)||!(ks(t)&&ks(r)||function(e,t,r){return 0===e.row&&ks(t)&&r===Number.POSITIVE_INFINITY||0===e.col&&ks(r)&&t===Number.POSITIVE_INFINITY}(e,t,r))||Or(n)||!this.sheetMapping.hasSheetWithId(e.sheet)||!this.sheetMapping.hasSheetWithId(n.sheet))throw new gt("a valid range of cells to move.");const s=Fr.spanFrom(e,t,r),i=Fr.spanFrom(n,t,r);if(i.exceedsSheetSizeLimits(this.maxColumns,this.maxRows))throw new ct;if(this.dependencyGraph.arrayMapping.isFormulaArrayInRange(s))throw new kt;if(this.dependencyGraph.arrayMapping.isFormulaArrayInRange(i))throw new Ht}restoreClipboardCells(e,t){const r=[];for(const[n,s]of t)if(this.restoreCell(n,s),s.type===hs.FORMULA){const{dependencies:t}=this.parser.fetchCachedResult(s.hash);r.push(...this.updateNamedExpressionsForTargetAddress(e,n,t))}return r}restoreCell(e,t){switch(t.type){case hs.VALUE:this.setValueToCell(t,e);break;case hs.FORMULA:this.setFormulaToCellFromCache(t.hash,e);break;case hs.EMPTY:this.setCellEmpty(e);break;case hs.PARSING_ERROR:this.setParsingErrorToCell(t.rawInput,t.errors,e)}}getOldContent(e){const t=this.dependencyGraph.getCell(e);if(void 0===t||t instanceof cr)return[e,{type:hs.EMPTY}];if(t instanceof dr)return[e,Object.assign({type:hs.VALUE},t.getValues())];if(t instanceof jt)return[t.getAddress(this.lazilyTransformingAstService),{type:hs.FORMULA,hash:this.parser.computeHashFromAst(t.getFormula(this.lazilyTransformingAstService))}];if(t instanceof pr)return[e,{type:hs.PARSING_ERROR,rawInput:t.rawInput,errors:t.errors}];throw Error("Trying to copy unsupported type")}getClipboardCell(e){const t=this.dependencyGraph.getCell(e);if(void 0===t||t instanceof cr)return{type:hs.EMPTY};if(t instanceof dr)return Object.assign({type:hs.VALUE},t.getValues());if(t instanceof zt){const r=t.getArrayCellValue(e);return r===Ye?{type:hs.EMPTY}:{type:hs.VALUE,parsedValue:r,rawValue:t.getArrayCellRawValue(e)}}if(t instanceof $t)return{type:hs.FORMULA,hash:this.parser.computeHashFromAst(t.getFormula(this.lazilyTransformingAstService))};if(t instanceof pr)return{type:hs.PARSING_ERROR,rawInput:t.rawInput,errors:t.errors};throw Error("Trying to copy unsupported type")}getSheetClipboardCells(e){const t=this.dependencyGraph.getSheetHeight(e),r=this.dependencyGraph.getSheetWidth(e),n=new Array(t);for(let s=0;s<t;s++){n[s]=new Array(r);for(let t=0;t<r;t++){const r=Ar(e,t,s);n[s][t]=this.getClipboardCell(r)}}return n}getRangeClipboardCells(e){const t=[];for(const r of e.addresses(this.dependencyGraph))t.push([r,this.getClipboardCell(r)]);return t}setCellContent(e,t){const r=this.cellContentParser.parse(t),n=this.getOldContent(e);if(r instanceof as.Formula){const t=this.parser.parse(r.formula,e),{ast:n,errors:s}=t;if(s.length>0)this.setParsingErrorToCell(r.formula,s,e);else try{const r=this.arraySizePredictor.checkArraySize(n,e);if(r.width<=0||r.height<=0)throw Error("Incorrect array size");this.setFormulaToCell(e,r,t)}catch(t){if(!t.message)throw t;const n={type:F.InvalidRangeSize,message:"Invalid range size."};this.setParsingErrorToCell(r.formula,[n],e)}}else r instanceof as.Empty?this.setCellEmpty(e):this.setValueToCell({parsedValue:r.value,rawValue:t},e);return n}setSheetContent(e,t){this.clearSheet(e);for(let r=0;r<t.length;r++)for(let n=0;n<t[r].length;n++){const s=Ar(e,n,r);this.setCellContent(s,t[r][n])}}setParsingErrorToCell(e,t,r){const n=this.dependencyGraph.getCellValue(r),s=new pr(t,e),i=this.dependencyGraph.setParsingErrorToCell(r,s);this.columnSearch.remove(Ge(n),r),this.columnSearch.applyChanges(i.getChanges()),this.changes.addAll(i),this.changes.addChange(s.getCellValue(),r)}setFormulaToCell(e,t,{ast:r,hasVolatileFunction:n,hasStructuralChangeFunction:s,dependencies:i}){const o=this.dependencyGraph.getCellValue(e),a=this.dependencyGraph.setFormulaToCell(e,r,We(i,e),t,n,s);this.columnSearch.remove(Ge(o),e),this.columnSearch.applyChanges(a.getChanges()),this.changes.addAll(a)}setValueToCell(e,t){const r=this.dependencyGraph.getCellValue(t),n=this.dependencyGraph.setValueToCell(t,e);this.columnSearch.change(Ge(r),Ge(e.parsedValue),t),this.columnSearch.applyChanges(n.getChanges().filter((e=>!Dr(e.address,t)))),this.changes.addAll(n),this.changes.addChange(e.parsedValue,t)}setCellEmpty(e){if(this.dependencyGraph.isArrayInternalCell(e))return;const t=this.dependencyGraph.getCellValue(e),r=this.dependencyGraph.setCellEmpty(e);this.columnSearch.remove(Ge(t),e),this.columnSearch.applyChanges(r.getChanges()),this.changes.addAll(r),this.changes.addChange(Ye,e)}setFormulaToCellFromCache(e,t){const{ast:r,hasVolatileFunction:n,hasStructuralChangeFunction:s,dependencies:i}=this.parser.fetchCachedResult(e),o=We(i,t),[a]=new vs(t.sheet).transformSingleAst(r,t);this.parser.rememberNewAst(a);const l=o.filter((e=>e instanceof Be||(e instanceof Fr?!(Or(e.start)||Or(e.end)):!Or(e))));const h=this.arraySizePredictor.checkArraySize(r,t);this.dependencyGraph.setFormulaToCell(t,a,l,h,n,s)}rowEffectivelyNotInSheet(e,t){return e>=this.dependencyGraph.addressMapping.getHeight(t)}getAndClearContentChanges(){const e=this.changes;return this.changes=nt.empty(),e}forceApplyPostponedTransformations(){this.dependencyGraph.forceApplyPostponedTransformations()}doRemoveRows(e){if(this.rowEffectivelyNotInSheet(e.rowStart,e.sheet))return;const t=[];for(const[r]of this.dependencyGraph.entriesFromRowsSpan(e))t.push({address:r,cellType:this.getClipboardCell(r)});const{affectedArrays:r,contentChanges:n}=this.dependencyGraph.removeRows(e);this.columnSearch.applyChanges(n.getChanges());let s=0;return this.stats.measure(et.TRANSFORM_ASTS,(()=>{const t=new Ns(e);t.performEagerTransformations(this.dependencyGraph,this.parser),s=this.lazilyTransformingAstService.addTransformation(t)})),this.rewriteAffectedArrays(r),{version:s,removedCells:t,rowFrom:e.rowStart,rowCount:e.numberOfRows}}doRemoveColumns(e){if(this.columnEffectivelyNotInSheet(e.columnStart,e.sheet))return;const t=[];for(const[r]of this.dependencyGraph.entriesFromColumnsSpan(e))t.push({address:r,cellType:this.getClipboardCell(r)});const{affectedArrays:r,contentChanges:n}=this.dependencyGraph.removeColumns(e);this.columnSearch.applyChanges(n.getChanges()),this.columnSearch.removeColumns(e);let s=0;return this.stats.measure(et.TRANSFORM_ASTS,(()=>{const t=new Ts(e);t.performEagerTransformations(this.dependencyGraph,this.parser),s=this.lazilyTransformingAstService.addTransformation(t)})),this.rewriteAffectedArrays(r),{version:s,removedCells:t,columnFrom:e.columnStart,columnCount:e.numberOfColumns}}doAddRows(e){if(this.rowEffectivelyNotInSheet(e.rowStart,e.sheet))return;const{affectedArrays:t}=this.dependencyGraph.addRows(e);this.stats.measure(et.TRANSFORM_ASTS,(()=>{const t=new Cs(e);t.performEagerTransformations(this.dependencyGraph,this.parser),this.lazilyTransformingAstService.addTransformation(t)})),this.rewriteAffectedArrays(t)}rewriteAffectedArrays(e){for(const t of e.values()){if(t.array.size.isRef)continue;const e=t.getFormula(this.lazilyTransformingAstService),r=t.getAddress(this.lazilyTransformingAstService),n=this.parser.computeHashFromAst(e);this.setFormulaToCellFromCache(n,r)}}doAddColumns(e){if(this.columnEffectivelyNotInSheet(e.columnStart,e.sheet))return;const{affectedArrays:t,contentChanges:r}=this.dependencyGraph.addColumns(e);this.columnSearch.addColumns(e),this.columnSearch.applyChanges(r.getChanges()),this.stats.measure(et.TRANSFORM_ASTS,(()=>{const t=new ws(e);t.performEagerTransformations(this.dependencyGraph,this.parser),this.lazilyTransformingAstService.addTransformation(t)})),this.rewriteAffectedArrays(t)}columnEffectivelyNotInSheet(e,t){return e>=this.dependencyGraph.addressMapping.getWidth(t)}adjustNamedExpressionEdges(e,t,r){if(void 0===r)return;const{vertex:n,id:s}=this.dependencyGraph.fetchCellOrCreateEmpty(e.address),i=null!=s?s:this.dependencyGraph.graph.getNodeId(n),o=this.namedExpressions.workbookNamedExpressionOrPlaceholder(t),{vertex:a,id:l}=this.dependencyGraph.fetchCellOrCreateEmpty(o.address),h=null!=l?l:this.dependencyGraph.graph.getNodeId(a);for(const t of this.dependencyGraph.graph.adjacentNodes(a))if(t instanceof $t&&t.getAddress(this.lazilyTransformingAstService).sheet===r){const r=t.getFormula(this.lazilyTransformingAstService),n=t.getAddress(this.lazilyTransformingAstService),{dependencies:s}=this.parser.fetchCachedResultForAst(r);for(const r of We(s,n))r instanceof Be&&r.name.toLowerCase()===e.displayName.toLowerCase()&&(this.dependencyGraph.graph.removeEdge(h,t),this.dependencyGraph.graph.addEdge(i,t))}}storeNamedExpressionInCell(e,t){const r=this.cellContentParser.parse(t);if(r instanceof as.Formula){const t=this.parser.parse(r.formula,Ar(-1,0,0));if(ys(t.ast))throw new Ft;const{ast:n,hasVolatileFunction:s,hasStructuralChangeFunction:i,dependencies:o}=t;this.dependencyGraph.setFormulaToCell(e,n,We(o,e),cn.scalar(),s,i)}else r instanceof as.Empty?this.setCellEmpty(e):this.setValueToCell({parsedValue:r.value,rawValue:t},e)}updateNamedExpressionsForMovedCells(e,t,r,n){if(e.sheet===n.sheet)return[];const s=[],i=Fr.spanFrom(n,t,r);for(const t of i.addresses(this.dependencyGraph)){const r=this.addressMapping.fetchCell(t);if(r instanceof $t&&t.sheet!==e.sheet){const n=r.getFormula(this.lazilyTransformingAstService),{dependencies:i}=this.parser.fetchCachedResultForAst(n);s.push(...this.updateNamedExpressionsForTargetAddress(e.sheet,t,i))}}return s}updateNamedExpressionsForTargetAddress(e,t,r){if(e===t.sheet)return[];const n=[],s=this.addressMapping.fetchCell(t);for(const i of We(r,t)){if(!(i instanceof Be))continue;const r=i.name,o=this.dependencyGraph.fetchNamedExpressionVertex(r,e).vertex,a=this.namedExpressions.isExpressionInScope(r,t.sheet)?this.dependencyGraph.fetchNamedExpressionVertex(r,t.sheet).vertex:this.copyOrFetchGlobalNamedExpressionVertex(r,o,n);a!==o&&(this.dependencyGraph.graph.removeEdgeIfExists(o,s),this.dependencyGraph.graph.addEdge(a,s))}return n}allocateNamedExpressionAddressSpace(){this.dependencyGraph.addressMapping.addSheet(ms.SHEET_FOR_WORKBOOK_EXPRESSIONS,new gr(0,0))}copyOrFetchGlobalNamedExpressionVertex(e,t,r){let n=this.namedExpressions.namedExpressionForScope(e);if(void 0===n)if(n=this.namedExpressions.addNamedExpression(e),r.push(n.normalizeExpressionName()),t instanceof $t){const e=this.parser.fetchCachedResultForAst(t.getFormula(this.lazilyTransformingAstService)),{ast:r,hasVolatileFunction:s,hasStructuralChangeFunction:i,dependencies:o}=e;this.dependencyGraph.setFormulaToCell(n.address,r,We(o,n.address),cn.scalar(),s,i)}else t instanceof cr?this.setCellEmpty(n.address):t instanceof dr&&this.setValueToCell(t.getValues(),n.address);return this.dependencyGraph.fetchCellOrCreateEmpty(n.address).vertex}}function Ls(e){if(e.length<=1)return e;const t=[...e].sort((([e],[t])=>e-t)),r=t.reduce(((e,[t,r])=>{const n=e[e.length-1],s=n[0]+n[1];return t<=s?n[1]+=Math.max(0,r-(s-t)):e.push([t,r]),e}),[t[0]]);let n=0;for(let e=0;e<r.length;++e)r[e][0]-=n,n+=r[e][1];return r}function Ds(e){if(e.length<=1)return e;const t=[...e].sort((([e],[t])=>e-t)),r=t.reduce(((e,[t,r])=>{const n=e[e.length-1];return t===n[0]?n[1]=Math.max(n[1],r):e.push([t,r]),e}),[t[0]]);let n=0;for(let e=0;e<r.length;++e)r[e][0]+=n,n+=r[e][1];return r}function ks(e){return Number.isInteger(e)&&e>0}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Hs{}class Fs extends Hs{constructor(e,t){super(),this.command=e,this.rowsRemovals=t}doUndo(e){e.undoRemoveRows(this)}doRedo(e){e.redoRemoveRows(this)}}class Us extends Hs{constructor(e,t,r,n,s,i,o){super(),this.sourceLeftCorner=e,this.width=t,this.height=r,this.destinationLeftCorner=n,this.overwrittenCellsData=s,this.addedGlobalNamedExpressions=i,this.version=o}doUndo(e){e.undoMoveCells(this)}doRedo(e){e.redoMoveCells(this)}}class Vs extends Hs{constructor(e){super(),this.command=e}doUndo(e){e.undoAddRows(this)}doRedo(e){e.redoAddRows(this)}}class Bs extends Hs{constructor(e,t,r){super(),this.sheetId=e,this.rowMapping=t,this.oldContent=r}doUndo(e){e.undoSetRowOrder(this)}doRedo(e){e.redoSetRowOrder(this)}}class Ws extends Hs{constructor(e,t,r){super(),this.sheetId=e,this.columnMapping=t,this.oldContent=r}doUndo(e){e.undoSetColumnOrder(this)}doRedo(e){e.redoSetColumnOrder(this)}}class Ys extends Hs{constructor(e,t,r){super(),this.sheetId=e,this.oldSheetContent=t,this.newSheetContent=r}doUndo(e){e.undoSetSheetContent(this)}doRedo(e){e.redoSetSheetContent(this)}}class Gs extends Hs{constructor(e,t,r,n,s){super(),this.sheet=e,this.startRow=t,this.numberOfRows=r,this.targetRow=n,this.version=s,this.undoStart=this.startRow<this.targetRow?this.targetRow-this.numberOfRows:this.targetRow,this.undoEnd=this.startRow>this.targetRow?this.startRow+this.numberOfRows:this.startRow}doUndo(e){e.undoMoveRows(this)}doRedo(e){e.redoMoveRows(this)}}class js extends Hs{constructor(e,t,r,n,s){super(),this.sheet=e,this.startColumn=t,this.numberOfColumns=r,this.targetColumn=n,this.version=s,this.undoStart=this.startColumn<this.targetColumn?this.targetColumn-this.numberOfColumns:this.targetColumn,this.undoEnd=this.startColumn>this.targetColumn?this.startColumn+this.numberOfColumns:this.startColumn}doUndo(e){e.undoMoveColumns(this)}doRedo(e){e.redoMoveColumns(this)}}class zs extends Hs{constructor(e){super(),this.command=e}doUndo(e){e.undoAddColumns(this)}doRedo(e){e.redoAddColumns(this)}}class $s extends Hs{constructor(e,t){super(),this.command=e,this.columnsRemovals=t}doUndo(e){e.undoRemoveColumns(this)}doRedo(e){e.redoRemoveColumns(this)}}class Ks extends Hs{constructor(e){super(),this.sheetName=e}doUndo(e){e.undoAddSheet(this)}doRedo(e){e.redoAddSheet(this)}}class Xs extends Hs{constructor(e,t,r,n,s){super(),this.sheetName=e,this.sheetId=t,this.oldSheetContent=r,this.scopedNamedExpressions=n,this.version=s}doUndo(e){e.undoRemoveSheet(this)}doRedo(e){e.redoRemoveSheet(this)}}class qs extends Hs{constructor(e,t,r){super(),this.sheetId=e,this.oldName=t,this.newName=r}doUndo(e){e.undoRenameSheet(this)}doRedo(e){e.redoRenameSheet(this)}}class Qs extends Hs{constructor(e,t){super(),this.sheetId=e,this.oldSheetContent=t}doUndo(e){e.undoClearSheet(this)}doRedo(e){e.redoClearSheet(this)}}class Zs extends Hs{constructor(e){super(),this.cellContents=e}doUndo(e){e.undoSetCellContents(this)}doRedo(e){e.redoSetCellContents(this)}}class Js extends Hs{constructor(e,t,r,n){super(),this.targetLeftCorner=e,this.oldContent=t,this.newContent=r,this.addedGlobalNamedExpressions=n}doUndo(e){e.undoPaste(this)}doRedo(e){e.redoPaste(this)}}class ei extends Hs{constructor(e,t,r,n){super(),this.name=e,this.newContent=t,this.scope=r,this.options=n}doUndo(e){e.undoAddNamedExpression(this)}doRedo(e){e.redoAddNamedExpression(this)}}class ti extends Hs{constructor(e,t,r){super(),this.namedExpression=e,this.content=t,this.scope=r}doUndo(e){e.undoRemoveNamedExpression(this)}doRedo(e){e.redoRemoveNamedExpression(this)}}class ri extends Hs{constructor(e,t,r,n,s){super(),this.namedExpression=e,this.newContent=t,this.oldContent=r,this.scope=n,this.options=s}doUndo(e){e.undoChangeNamedExpression(this)}doRedo(e){e.redoChangeNamedExpression(this)}}class ni extends Hs{constructor(){super(...arguments),this.operations=[]}add(e){this.operations.push(e)}*reversedOperations(){for(let e=this.operations.length-1;e>=0;e--)yield this.operations[e]}doUndo(e){e.undoBatch(this)}doRedo(e){e.redoBatch(this)}}class si{constructor(e,t){this.operations=t,this.oldData=new Map,this.undoStack=[],this.redoStack=[],this.undoLimit=e.undoLimit}saveOperation(e){void 0!==this.batchUndoEntry?this.batchUndoEntry.add(e):this.addUndoEntry(e)}beginBatchMode(){this.batchUndoEntry=new ni}commitBatchMode(){if(void 0===this.batchUndoEntry)throw Error("Batch mode wasn't started");this.addUndoEntry(this.batchUndoEntry),this.batchUndoEntry=void 0}storeDataForVersion(e,t,r){this.oldData.has(e)||this.oldData.set(e,[]);this.oldData.get(e).push([t,r])}clearRedoStack(){this.redoStack=[]}clearUndoStack(){this.undoStack=[]}isUndoStackEmpty(){return 0===this.undoStack.length}isRedoStackEmpty(){return 0===this.redoStack.length}undo(){const e=this.undoStack.pop();if(!e)throw Error("Attempted to undo without operation on stack");this.undoEntry(e),this.redoStack.push(e)}undoBatch(e){for(const t of e.reversedOperations())this.undoEntry(t)}undoRemoveRows(e){this.operations.forceApplyPostponedTransformations();const{command:{sheet:t},rowsRemovals:r}=e;for(let e=r.length-1;e>=0;--e){const n=r[e];this.operations.addRows(new Os(t,[[n.rowFrom,n.rowCount]]));for(const{address:e,cellType:t}of n.removedCells)this.operations.restoreCell(e,t);this.restoreOldDataFromVersion(n.version-1)}}undoRemoveColumns(e){this.operations.forceApplyPostponedTransformations();const{command:{sheet:t},columnsRemovals:r}=e;for(let e=r.length-1;e>=0;--e){const n=r[e];this.operations.addColumns(new Is(t,[[n.columnFrom,n.columnCount]]));for(const{address:e,cellType:t}of n.removedCells)this.operations.restoreCell(e,t);this.restoreOldDataFromVersion(n.version-1)}}undoAddRows(e){const t=e.command.rowsSpans();for(let r=t.length-1;r>=0;--r){const n=t[r];this.operations.removeRows(new As(e.command.sheet,[[n.rowStart,n.numberOfRows]]))}}undoAddColumns(e){const t=e.command.columnsSpans();for(let r=t.length-1;r>=0;--r){const n=t[r];this.operations.removeColumns(new xs(e.command.sheet,[[n.columnStart,n.numberOfColumns]]))}}undoSetCellContents(e){for(const t of e.cellContents){const e=t.address,[r,n]=t.oldContent;Dr(e,r)||this.operations.setCellEmpty(e),this.operations.restoreCell(r,n)}}undoPaste(e){this.restoreOperationOldContent(e.oldContent);for(const t of e.addedGlobalNamedExpressions)this.operations.removeNamedExpression(t)}undoMoveRows(e){const{sheet:t}=e;this.operations.moveRows(t,e.undoStart,e.numberOfRows,e.undoEnd),this.restoreOldDataFromVersion(e.version-1)}undoMoveColumns(e){const{sheet:t}=e;this.operations.moveColumns(t,e.undoStart,e.numberOfColumns,e.undoEnd),this.restoreOldDataFromVersion(e.version-1)}undoMoveCells(e){this.operations.forceApplyPostponedTransformations(),this.operations.moveCells(e.destinationLeftCorner,e.width,e.height,e.sourceLeftCorner),this.restoreOperationOldContent(e.overwrittenCellsData),this.restoreOldDataFromVersion(e.version-1);for(const t of e.addedGlobalNamedExpressions)this.operations.removeNamedExpression(t)}undoAddSheet(e){const{sheetName:t}=e;this.operations.removeSheetByName(t)}undoRemoveSheet(e){this.operations.forceApplyPostponedTransformations();const{oldSheetContent:t,sheetId:r}=e;this.operations.addSheet(e.sheetName);for(let e=0;e<t.length;e++){const n=t[e];for(let t=0;t<n.length;t++){const s=n[t],i=Ar(r,t,e);this.operations.restoreCell(i,s)}}for(const[t,n]of e.scopedNamedExpressions)this.operations.restoreNamedExpression(t,n,r);this.restoreOldDataFromVersion(e.version-1)}undoRenameSheet(e){this.operations.renameSheet(e.sheetId,e.oldName)}undoClearSheet(e){const{oldSheetContent:t,sheetId:r}=e;for(let e=0;e<t.length;e++){const n=t[e];for(let t=0;t<n.length;t++){const s=n[t],i=Ar(r,t,e);this.operations.restoreCell(i,s)}}}undoSetSheetContent(e){const{oldSheetContent:t,sheetId:r}=e;this.operations.clearSheet(r);for(let e=0;e<t.length;e++){const n=t[e];for(let t=0;t<n.length;t++){const s=n[t],i=Ar(r,t,e);this.operations.restoreCell(i,s)}}}undoAddNamedExpression(e){this.operations.removeNamedExpression(e.name,e.scope)}undoRemoveNamedExpression(e){this.operations.restoreNamedExpression(e.namedExpression,e.content,e.scope)}undoChangeNamedExpression(e){this.operations.restoreNamedExpression(e.namedExpression,e.oldContent,e.scope)}undoSetRowOrder(e){this.restoreOperationOldContent(e.oldContent)}undoSetColumnOrder(e){this.restoreOperationOldContent(e.oldContent)}redo(){const e=this.redoStack.pop();if(!e)throw Error("Attempted to redo without operation on stack");this.redoEntry(e),this.undoStack.push(e)}redoBatch(e){for(const t of e.operations)this.redoEntry(t)}redoRemoveRows(e){this.operations.removeRows(e.command)}redoMoveCells(e){this.operations.moveCells(e.sourceLeftCorner,e.width,e.height,e.destinationLeftCorner)}redoRemoveColumns(e){this.operations.removeColumns(e.command)}redoPaste(e){const{targetLeftCorner:t,newContent:r}=e,n=r.length,s=r[0].length;for(let e=0;e<n;++e)for(let n=0;n<s;++n){const s=Ar(t.sheet,t.col+n,t.row+e);this.operations.restoreCell(s,r[e][n])}}redoSetCellContents(e){for(const t of e.cellContents)this.operations.setCellContent(t.address,t.newContent)}redoAddRows(e){this.operations.addRows(e.command)}redoAddColumns(e){this.operations.addColumns(e.command)}redoRemoveSheet(e){this.operations.removeSheetByName(e.sheetName)}redoAddSheet(e){this.operations.addSheet(e.sheetName)}redoRenameSheet(e){this.operations.renameSheet(e.sheetId,e.newName)}redoMoveRows(e){this.operations.moveRows(e.sheet,e.startRow,e.numberOfRows,e.targetRow)}redoMoveColumns(e){this.operations.moveColumns(e.sheet,e.startColumn,e.numberOfColumns,e.targetColumn)}redoClearSheet(e){this.operations.clearSheet(e.sheetId)}redoSetSheetContent(e){const{sheetId:t,newSheetContent:r}=e;this.operations.setSheetContent(t,r)}redoAddNamedExpression(e){this.operations.addNamedExpression(e.name,e.newContent,e.scope,e.options)}redoRemoveNamedExpression(e){this.operations.removeNamedExpression(e.namedExpression.displayName,e.scope)}redoChangeNamedExpression(e){this.operations.changeNamedExpressionExpression(e.namedExpression.displayName,e.newContent,e.scope,e.options)}redoSetRowOrder(e){this.operations.setRowOrder(e.sheetId,e.rowMapping)}redoSetColumnOrder(e){this.operations.setColumnOrder(e.sheetId,e.columnMapping)}addUndoEntry(e){this.undoStack.push(e),this.undoStack.splice(0,Math.max(0,this.undoStack.length-this.undoLimit))}undoEntry(e){e.doUndo(this)}restoreOperationOldContent(e){for(const[t,r]of e)this.operations.restoreCell(t,r)}redoEntry(e){e.doRedo(this)}restoreOldDataFromVersion(e){const t=this.oldData.get(e)||[];for(const e of t){const[t,r]=e;this.operations.setFormulaToCellFromCache(r,t)}}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ii{constructor(e,t,r,n,s,i,o,a,l,h){this.operations=t,this.undoRedo=r,this.clipboardOperations=n,this.dependencyGraph=s,this.columnSearch=i,this.parser=o,this.cellContentParser=a,this.lazilyTransformingAstService=l,this.namedExpressions=h,this.maxRows=e.maxRows,this.maxColumns=e.maxColumns}get sheetMapping(){return this.dependencyGraph.sheetMapping}addRows(e,...t){const r=new Os(e,t);this.ensureItIsPossibleToAddRows(e,...t),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut(),this.operations.addRows(r),this.undoRedo.saveOperation(new Vs(r))}removeRows(e,...t){const r=new As(e,t);this.ensureItIsPossibleToRemoveRows(e,...t),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const n=this.operations.removeRows(r);this.undoRedo.saveOperation(new Fs(r,n))}addColumns(e,...t){const r=new Is(e,t);this.ensureItIsPossibleToAddColumns(e,...t),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut(),this.operations.addColumns(r),this.undoRedo.saveOperation(new zs(r))}removeColumns(e,...t){const r=new xs(e,t);this.ensureItIsPossibleToRemoveColumns(e,...t),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const n=this.operations.removeColumns(r);this.undoRedo.saveOperation(new $s(r,n))}moveCells(e,t,r,n){this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const{version:s,overwrittenCellsData:i,addedGlobalNamedExpressions:o}=this.operations.moveCells(e,t,r,n);this.undoRedo.saveOperation(new Us(e,t,r,n,i,o,s))}moveRows(e,t,r,n){this.ensureItIsPossibleToMoveRows(e,t,r,n),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const s=this.operations.moveRows(e,t,r,n);this.undoRedo.saveOperation(new Gs(e,t,r,n,s))}moveColumns(e,t,r,n){this.ensureItIsPossibleToMoveColumns(e,t,r,n),this.undoRedo.clearRedoStack();const s=this.operations.moveColumns(e,t,r,n);this.undoRedo.saveOperation(new js(e,t,r,n,s))}cut(e,t,r){this.clipboardOperations.cut(e,t,r)}ensureItIsPossibleToCopy(e,t,r){if(!oi(t))throw new gt("width to be positive integer.");if(!oi(r))throw new gt("height to be positive integer.")}copy(e,t,r){this.ensureItIsPossibleToCopy(e,t,r),this.clipboardOperations.copy(e,t,r)}paste(e){const t=this.clipboardOperations.clipboard;if(void 0===t)throw new vt;if(this.clipboardOperations.isCutClipboard())this.moveCells(t.sourceLeftCorner,t.width,t.height,e);else if(this.clipboardOperations.isCopyClipboard()){this.clipboardOperations.ensureItIsPossibleToCopyPaste(e);const r=Fr.spanFrom(e,t.width,t.height),n=this.operations.getRangeClipboardCells(r);this.undoRedo.clearRedoStack();const s=this.operations.restoreClipboardCells(t.sourceLeftCorner.sheet,t.getContent(e));this.undoRedo.saveOperation(new Js(e,n,t.content,s))}}beginUndoRedoBatchMode(){this.undoRedo.beginBatchMode()}commitUndoRedoBatchMode(){this.undoRedo.commitBatchMode()}isClipboardEmpty(){return void 0===this.clipboardOperations.clipboard}clearClipboard(){this.clipboardOperations.clear()}addSheet(e){void 0!==e&&this.ensureItIsPossibleToAddSheet(e),this.undoRedo.clearRedoStack();const t=this.operations.addSheet(e);return this.undoRedo.saveOperation(new Ks(t)),t}removeSheet(e){this.ensureScopeIdIsValid(e),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const t=this.sheetMapping.fetchDisplayName(e),r=this.operations.getSheetClipboardCells(e),{version:n,scopedNamedExpressions:s}=this.operations.removeSheet(e);this.undoRedo.saveOperation(new Xs(t,e,r,s,n))}renameSheet(e,t){this.ensureItIsPossibleToRenameSheet(e,t);const r=this.operations.renameSheet(e,t);return void 0!==r&&(this.undoRedo.clearRedoStack(),this.undoRedo.saveOperation(new qs(e,r,t))),r}clearSheet(e){this.ensureScopeIdIsValid(e),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const t=this.operations.getSheetClipboardCells(e);this.operations.clearSheet(e),this.undoRedo.saveOperation(new Qs(e,t))}setCellContents(e,t){if(t instanceof Array){for(let e=0;e<t.length;e++)if(!(t[e]instanceof Array))throw new gt("an array of arrays or a raw cell value.")}else t=[[t]];this.ensureItIsPossibleToChangeCellContents(e,t),this.undoRedo.clearRedoStack();const r=[];for(let n=0;n<t.length;n++)for(let s=0;s<t[n].length;s++){const i={sheet:e.sheet,row:e.row+n,col:e.col+s},o=t[n][s];this.clipboardOperations.abortCut();const a=this.operations.setCellContent(i,o);r.push({address:i,newContent:o,oldContent:a})}this.undoRedo.saveOperation(new Zs(r))}setSheetContent(e,t){this.ensureScopeIdIsValid(e),this.ensureItIsPossibleToChangeSheetContents(e,t),_s(t),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const r=this.operations.getSheetClipboardCells(e);this.operations.setSheetContent(e,t),this.undoRedo.saveOperation(new Ys(e,r,t))}setRowOrder(e,t){this.validateSwapRowIndexes(e,t),this.testRowOrderForArrays(e,t),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const r=this.operations.setRowOrder(e,t);this.undoRedo.saveOperation(new Bs(e,t,r))}validateSwapRowIndexes(e,t){if(!this.sheetMapping.hasSheetWithId(e))throw new lt(e);this.validateRowOrColumnMapping(e,t,"row")}testColumnOrderForArrays(e,t){for(const[r,n]of t)if(r!==n){const t=Fr.spanFrom({sheet:e,col:r,row:0},1,1/0);if(this.dependencyGraph.arrayMapping.isFormulaArrayInRange(t))throw new kt}}setColumnOrder(e,t){this.validateSwapColumnIndexes(e,t),this.testColumnOrderForArrays(e,t),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut();const r=this.operations.setColumnOrder(e,t);this.undoRedo.saveOperation(new Ws(e,t,r))}validateSwapColumnIndexes(e,t){if(!this.sheetMapping.hasSheetWithId(e))throw new lt(e);this.validateRowOrColumnMapping(e,t,"column")}testRowOrderForArrays(e,t){for(const[r,n]of t)if(r!==n){const t=Fr.spanFrom({sheet:e,col:0,row:r},1/0,1);if(this.dependencyGraph.arrayMapping.isFormulaArrayInRange(t))throw new kt}}mappingFromOrder(e,t,r){if(!this.sheetMapping.hasSheetWithId(e))throw new lt(e);const n="row"===r?this.dependencyGraph.getSheetHeight(e):this.dependencyGraph.getSheetWidth(e);if(t.length!==n)throw new gt(`number of ${r}s provided to be sheet ${"row"===r?"height":"width"}.`);const s=[];for(let e=0;e<n;e++)t[e]!==e&&s.push([e,t[e]]);return s}undo(){if(this.undoRedo.isUndoStackEmpty())throw new wt;this.clipboardOperations.abortCut(),this.undoRedo.undo()}redo(){if(this.undoRedo.isRedoStackEmpty())throw new Ct;this.clipboardOperations.abortCut(),this.undoRedo.redo()}addNamedExpression(e,t,r,n){this.ensureItIsPossibleToAddNamedExpression(e,t,r),this.operations.addNamedExpression(e,t,r,n),this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut(),this.undoRedo.saveOperation(new ei(e,t,r,n))}changeNamedExpressionExpression(e,t,r,n){this.ensureItIsPossibleToChangeNamedExpression(e,r,t);const[s,i]=this.operations.changeNamedExpressionExpression(e,r,t,n);this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut(),this.undoRedo.saveOperation(new ri(s,r,i,t,n))}removeNamedExpression(e,t){this.ensureScopeIdIsValid(t);const[r,n]=this.operations.removeNamedExpression(e,t);return this.undoRedo.clearRedoStack(),this.clipboardOperations.abortCut(),this.undoRedo.saveOperation(new ti(r,n,t)),r}ensureItIsPossibleToAddNamedExpression(e,t,r){this.ensureScopeIdIsValid(r),this.ensureNamedExpressionNameIsValid(e,r),this.ensureNamedExpressionIsValid(t)}ensureItIsPossibleToChangeNamedExpression(e,t,r){if(this.ensureScopeIdIsValid(r),void 0===this.namedExpressions.namedExpressionForScope(e,r))throw new Et(e);this.ensureNamedExpressionIsValid(t)}isItPossibleToRemoveNamedExpression(e,t){if(this.ensureScopeIdIsValid(t),void 0===this.namedExpressions.namedExpressionForScope(e,t))throw new Et(e)}ensureItIsPossibleToAddRows(e,...t){if(!this.sheetMapping.hasSheetWithId(e))throw new lt(e);if(this.dependencyGraph.getSheetHeight(e)+t.map((e=>e[1])).reduce(((e,t)=>e+t),0)>this.maxRows)throw new ct;for(const[e,r]of t)if(!ai(e)||!oi(r))throw new gt("row number to be nonnegative and number of rows to add to be positive.")}ensureItIsPossibleToRemoveRows(e,...t){for(const[r,n]of t){const t=r+n-1;if(!ai(r)||!ai(t))throw new gt("starting and ending row to be nonnegative.");if(t<r)throw new gt("starting row to be smaller than the ending row.");if(!this.sheetMapping.hasSheetWithId(e))throw new lt(e)}}ensureItIsPossibleToAddColumns(e,...t){if(!this.sheetMapping.hasSheetWithId(e))throw new lt(e);if(this.dependencyGraph.getSheetWidth(e)+t.map((e=>e[1])).reduce(((e,t)=>e+t),0)>this.maxColumns)throw new ct;for(const[e,r]of t)if(!ai(e)||!oi(r))throw new gt("column number to be nonnegative and number of columns to add to be positive.")}ensureItIsPossibleToRemoveColumns(e,...t){for(const[r,n]of t){const t=r+n-1;if(!ai(r)||!ai(t))throw new gt("starting and ending column to be nonnegative.");if(t<r)throw new gt("starting column to be smaller than the ending column.");if(!this.sheetMapping.hasSheetWithId(e))throw new lt(e)}}ensureItIsPossibleToMoveRows(e,t,r,n){this.ensureItIsPossibleToAddRows(e,[n,r]);const s=Ar(e,0,t),i=Ar(e,0,n);if(!this.sheetMapping.hasSheetWithId(e)||Or(s)||Or(i)||!oi(r)||n<=t+r&&n>=t)throw new gt("a valid range of rows to move.");const o=this.dependencyGraph.getSheetWidth(e),a=Fr.spanFrom(s,o,r);if(this.dependencyGraph.arrayMapping.isFormulaArrayInRange(a))throw new kt;if(n>0&&this.dependencyGraph.arrayMapping.isFormulaArrayInAllRows(st.fromNumberOfRows(e,n-1,2)))throw new Ht}ensureItIsPossibleToMoveColumns(e,t,r,n){this.ensureItIsPossibleToAddColumns(e,[n,r]);const s=Ar(e,t,0),i=Ar(e,n,0);if(!this.sheetMapping.hasSheetWithId(e)||Or(s)||Or(i)||!oi(r)||n<=t+r&&n>=t)throw new gt("a valid range of columns to move.");const o=this.dependencyGraph.getSheetHeight(e),a=Fr.spanFrom(s,r,o);if(this.dependencyGraph.arrayMapping.isFormulaArrayInRange(a))throw new kt;if(n>0&&this.dependencyGraph.arrayMapping.isFormulaArrayInAllColumns(it.fromNumberOfColumns(e,n-1,2)))throw new Ht}ensureItIsPossibleToAddSheet(e){if(this.sheetMapping.hasSheetWithName(e))throw new ut(e)}ensureItIsPossibleToRenameSheet(e,t){if(!this.sheetMapping.hasSheetWithId(e))throw new lt(e);const r=this.sheetMapping.get(t);if(void 0!==r&&r!==e)throw new ut(t)}ensureItIsPossibleToChangeContent(e){if(Or(e))throw new pt(e);if(!this.sheetMapping.hasSheetWithId(e.sheet))throw new lt(e.sheet)}ensureItIsPossibleToChangeCellContents(e,t){const r=bs(t),n=Fr.spanFrom(e,r.width,r.height);this.ensureRangeInSizeLimits(n);for(const e of n.addresses(this.dependencyGraph))this.ensureItIsPossibleToChangeContent(e)}ensureItIsPossibleToChangeSheetContents(e,t){const r=bs(t),n=Fr.spanFrom(Ar(e,0,0),r.width,r.height);this.ensureRangeInSizeLimits(n)}ensureRangeInSizeLimits(e){if(e.exceedsSheetSizeLimits(this.maxColumns,this.maxRows))throw new ct}isThereSomethingToUndo(){return!this.undoRedo.isUndoStackEmpty()}isThereSomethingToRedo(){return!this.undoRedo.isRedoStackEmpty()}getAndClearContentChanges(){return this.operations.getAndClearContentChanges()}ensureScopeIdIsValid(e){if(void 0!==e&&!this.sheetMapping.hasSheetWithId(e))throw new lt(e)}validateRowOrColumnMapping(e,t,r){const n="row"===r?this.dependencyGraph.getSheetHeight(e):this.dependencyGraph.getSheetWidth(e),s=t.map((([e,t])=>e)).sort(((e,t)=>e-t)),i=t.map((([e,t])=>t)).sort(((e,t)=>e-t));for(let e=0;e<s.length;e++){if(!ai(s[e])||s[e]>=n)throw new gt(`${r} numbers to be nonnegative integers and less than sheet ${"row"===r?"height":"width"}.`);if(s[e]===s[e+1])throw new gt(`source ${r} numbers to be unique.`);if(s[e]!==i[e])throw new gt(`target ${r} numbers to be permutation of source ${r} numbers.`)}}ensureNamedExpressionNameIsValid(e,t){if(!this.namedExpressions.isNameValid(e))throw new yt(e);if(!this.namedExpressions.isNameAvailable(e,t))throw new mt(e)}ensureNamedExpressionIsValid(e){const t=this.cellContentParser.parse(e);if(t instanceof as.Formula){const e=this.parser.parse(t.formula,Ar(-1,0,0));if(ys(e.ast))throw new Ft}}}function oi(e){return Number.isInteger(e)&&e>0}function ai(e){return Number.isInteger(e)&&e>=0}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class li{constructor(e,t,r,n,s,i){this.config=e,this.stats=t,this.interpreter=r,this.lazilyTransformingAstService=n,this.dependencyGraph=s,this.columnSearch=i}run(){this.stats.start(et.TOP_SORT);const{sorted:e,cycled:t}=this.dependencyGraph.topSortWithScc();this.stats.end(et.TOP_SORT),this.stats.measure(et.EVALUATION,(()=>{this.recomputeFormulas(t,e)}))}partialRun(e){const t=nt.empty();return this.stats.measure(et.EVALUATION,(()=>{this.dependencyGraph.graph.getTopSortedWithSccSubgraphFrom(e,(e=>{if(e instanceof jt){const r=e.isComputed()?e.getCellValue():void 0,n=this.recomputeFormulaVertexValue(e);if(n!==r){const s=e.getAddress(this.lazilyTransformingAstService);return t.addChange(n,s),this.columnSearch.change(Ge(r),Ge(n),s),!0}return!1}return!(e instanceof Kt)||(e.clearCache(),!0)}),(e=>{if(e instanceof Kt)e.clearCache();else if(e instanceof jt){const r=e.getAddress(this.lazilyTransformingAstService);this.columnSearch.remove(Ge(e.valueOrUndef()),r);const n=new Tr(ir.CYCLE,void 0,e);e.setCellValue(n),t.addChange(n,r)}}))})),t}runAndForget(e,t,r){const n=[];for(const e of We(r,t))if(e instanceof Fr){const t=e;if(void 0===this.dependencyGraph.getRange(t.start,t.end)){const e=new Kt(t);this.dependencyGraph.rangeMapping.setRange(e),n.push(e)}}const s=this.evaluateAstToCellValue(e,new Br(t,this.config.useArrayArithmetic));return n.forEach((e=>{this.dependencyGraph.rangeMapping.removeRange(e)})),s}recomputeFormulas(e,t){e.forEach((e=>{e instanceof jt&&e.setCellValue(new Tr(ir.CYCLE,void 0,e))})),t.forEach((e=>{if(e instanceof jt){const t=this.recomputeFormulaVertexValue(e),r=e.getAddress(this.lazilyTransformingAstService);this.columnSearch.add(Ge(t),r)}else e instanceof Kt&&e.clearCache()}))}recomputeFormulaVertexValue(e){const t=e.getAddress(this.lazilyTransformingAstService);if(e instanceof zt&&(e.array.size.isRef||!this.dependencyGraph.isThereSpaceForArray(e)))return e.setNoSpace();{const r=e.getFormula(this.lazilyTransformingAstService),n=this.evaluateAstToCellValue(r,new Br(t,this.config.useArrayArithmetic,e));return e.setCellValue(n)}}evaluateAstToCellValue(e,t){const r=this.interpreter.evaluateAst(e,t);return r instanceof rt?r:r===Ye&&this.config.evaluateNullToZero?0:r}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class hi{constructor(e,t){this.address=e,this.newValue=t}get col(){return this.address.col}get row(){return this.address.row}get sheet(){return this.address.sheet}get value(){return this.newValue}}class ui{constructor(e,t){this.name=e,this.newValue=t}}class ci{constructor(e,t,r,n){this.config=e,this.namedExpressions=t,this.sheetIndexMapping=r,this.lazilyTransformingService=n}exportChange(e){const t=e.value,r=e.address;if(r.sheet===ms.SHEET_FOR_WORKBOOK_EXPRESSIONS){const e=this.namedExpressions.namedExpressionInAddress(r.row);if(!e)throw new Error("Missing named expression");return new ui(e.displayName,this.exportScalarOrRange(t))}if(t instanceof rt){const e=[];for(const[n,s]of t.entriesFromTopLeftCorner(r))e.push(new hi(s,this.exportValue(n)));return e}return new hi(r,this.exportValue(t))}exportValue(e){return e instanceof rt?this.detailedError(new Tr(ir.VALUE,Z.ScalarExpected)):this.config.smartRounding&&Ze(e)?this.cellValueRounding(Ge(e)):e instanceof Tr?this.detailedError(e):e===Ye?null:Ge(e)}exportScalarOrRange(e){return e instanceof rt?e.rawData().map((e=>e.map((e=>this.exportValue(e))))):this.exportValue(e)}detailedError(e){var t,r;let n;const s=null===(t=e.root)||void 0===t?void 0:t.getAddress(this.lazilyTransformingService);return void 0!==s&&(n=s.sheet===ms.SHEET_FOR_WORKBOOK_EXPRESSIONS?null===(r=this.namedExpressions.namedExpressionInAddress(s.row))||void 0===r?void 0:r.displayName:I(this.sheetIndexMapping,s,-1)),new pn(e,this.config.translationPackage.getErrorTranslation(e.type),n)}cellValueRounding(e){if(0===e)return e;const t=Math.floor(Math.log10(Math.abs(e))),r=Math.pow(10,this.config.precisionRounding-t);return e<0?-Math.round(-e*r)/r:Math.round(e*r)/r}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class di{constructor(e,t,r,n,s,i){this.dependencyGraph=e,this.columnSearch=t,this.parser=r,this.cellContentParser=n,this.stats=s,this.arraySizePredictor=i,this.buildStrategy=new pi(e,t,r,s,n,i)}buildGraph(e,t){const r=t.measure(et.COLLECT_DEPENDENCIES,(()=>this.buildStrategy.run(e)));this.dependencyGraph.getAndClearContentChanges(),t.measure(et.PROCESS_DEPENDENCIES,(()=>this.processDependencies(r)))}processDependencies(e){e.forEach(((e,t)=>{this.dependencyGraph.processCellDependencies(e,t)}))}}class pi{constructor(e,t,r,n,s,i){this.dependencyGraph=e,this.columnIndex=t,this.parser=r,this.stats=n,this.cellContentParser=s,this.arraySizePredictor=i}run(e){const t=new Map;for(const r in e){const n=this.dependencyGraph.getSheetId(r),s=e[r];for(let e=0;e<s.length;++e){const r=s[e];for(let s=0;s<r.length;++s){const i=r[s],o=Ar(n,s,e),a=this.cellContentParser.parse(i);if(a instanceof as.Formula){const e=this.stats.measure(et.PARSER,(()=>this.parser.parse(a.formula,o)));if(e.errors.length>0){this.shrinkArrayIfNeeded(o);const t=new pr(e.errors,a.formula);this.dependencyGraph.addVertex(o,t)}else{this.shrinkArrayIfNeeded(o);const r=this.arraySizePredictor.checkArraySize(e.ast,o);if(r.isScalar()){const r=new $t(e.ast,o,0);t.set(r,We(e.dependencies,o)),this.dependencyGraph.addVertex(o,r),e.hasVolatileFunction&&this.dependencyGraph.markAsVolatile(r),e.hasStructuralChangeFunction&&this.dependencyGraph.markAsDependentOnStructureChange(r)}else{const n=new zt(e.ast,o,new cn(r.width,r.height));t.set(n,We(e.dependencies,o)),this.dependencyGraph.addArrayVertex(o,n)}}}else if(a instanceof as.Empty);else{this.shrinkArrayIfNeeded(o);const e=new dr(a.value,i);this.columnIndex.add(Ge(a.value),o),this.dependencyGraph.addVertex(o,e)}}}}return t}shrinkArrayIfNeeded(e){const t=this.dependencyGraph.getCell(e);t instanceof zt&&this.dependencyGraph.shrinkArrayToCorner(t)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const gi=new Map([["gpl-v3",1],["missing",2],["invalid",3],["expired",4]]);class fi extends un{version(e,t){return this.runFunction(e.args,t,this.metadata("VERSION"),(()=>{const{licenseKeyValidityState:e,licenseKey:t}=this.config;let r;return gi.has(t)?r=gi.get(t):gi.has(e)?r=gi.get(e):"valid"===e&&(r=t.slice(-5)),`HyperFormula v${Bi.version}, ${r}`}))}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function mi(e,t){var r;let n=t.implementedFunctions[e];const s=null===(r=t.aliases)||void 0===r?void 0:r[e];if(void 0!==s){if(void 0!==n)throw new Ut(e,t.name);n=t.implementedFunctions[s]}if(void 0===n)throw Lt.functionNotDeclaredInPlugin(e,t.name);return n}fi.implementedFunctions={VERSION:{method:"version",parameters:[]}};class yi{constructor(e){if(this.config=e,this.functions=new Map,this.arraySizeFunctions=new Map,this.volatileFunctions=new Set,this.arrayFunctions=new Set,this.structuralChangeFunctions=new Set,this.functionsWhichDoesNotNeedArgumentsToBeComputed=new Set,this.functionsMetadata=new Map,this.doesFunctionNeedArgumentToBeComputed=e=>this.functionsWhichDoesNotNeedArgumentsToBeComputed.has(e),this.isFunctionVolatile=e=>this.volatileFunctions.has(e),this.isArrayFunction=e=>this.arrayFunctions.has(e),this.isFunctionDependentOnSheetStructureChange=e=>this.structuralChangeFunctions.has(e),e.functionPlugins.length>0){this.instancePlugins=new Map;for(const t of e.functionPlugins)yi.loadPluginFunctions(t,this.instancePlugins)}else this.instancePlugins=new Map(yi.plugins);for(const[e,t]of yi.protectedFunctions())yi.loadFunctionUnprotected(t,e,this.instancePlugins);for(const[e,t]of this.instancePlugins.entries())this.categorizeFunction(e,mi(e,t))}static registerFunctionPlugin(e,t){this.loadPluginFunctions(e,this.plugins),void 0!==t&&this.loadTranslations(t)}static registerFunction(e,t,r){this.loadPluginFunction(t,e,this.plugins),void 0!==r&&this.loadTranslations(r)}static unregisterFunction(e){if(this.functionIsProtected(e))throw Dt.cannotUnregisterFunctionWithId(e);this.plugins.delete(e)}static unregisterFunctionPlugin(e){for(const t of this.protectedPlugins())if(t===e)throw Dt.cannotUnregisterProtectedPlugin();for(const[t,r]of this.plugins.entries())r===e&&this.plugins.delete(t)}static unregisterAll(){this.plugins.clear()}static getRegisteredFunctionIds(){return[...Array.from(this.plugins.keys()),...Array.from(this._protectedPlugins.keys())]}static getPlugins(){return Array.from(new Set(this.plugins.values()).values())}static getFunctionPlugin(e){return this.functionIsProtected(e)?void 0:this.plugins.get(e)}static functionIsProtected(e){return this._protectedPlugins.has(e)}static loadTranslations(e){const t=new Set(Bi.getRegisteredLanguagesCodes());Object.keys(e).forEach((r=>{t.has(r)&&Bi.getLanguage(r).extendFunctions(e[r])}))}static loadPluginFunctions(e,t){Object.keys(e.implementedFunctions).forEach((r=>{this.loadPluginFunction(e,r,t)})),void 0!==e.aliases&&Object.keys(e.aliases).forEach((r=>{this.loadPluginFunction(e,r,t)}))}static loadPluginFunction(e,t,r){if(this.functionIsProtected(t))throw Dt.cannotRegisterFunctionWithId(t);this.loadFunctionUnprotected(e,t,r)}static loadFunctionUnprotected(e,t,r){const n=mi(t,e).method;if(!Object.prototype.hasOwnProperty.call(e.prototype,n))throw Lt.functionMethodNotFound(n,e.name);r.set(t,e)}static*protectedFunctions(){for(const[e,t]of this._protectedPlugins)void 0!==t&&(yield[e,t])}static*protectedPlugins(){for(const[,e]of this._protectedPlugins)void 0!==e&&(yield e)}initializePlugins(e){const t=[];for(const[r,n]of this.instancePlugins.entries()){let s=t.find((e=>e instanceof n));void 0===s&&(s=new n(e),t.push(s));const i=mi(r,n),o=i.method;this.functions.set(r,[o,s]);const a=i.arraySizeMethod;void 0!==a&&this.arraySizeFunctions.set(r,[a,s])}}getFunctionPlugin(e){if(!yi.functionIsProtected(e))return this.instancePlugins.get(e)}getFunction(e){const t=this.functions.get(e);if(void 0!==t&&this.config.translationPackage.isFunctionTranslated(e)){const[e,r]=t;return(t,n)=>r[e](t,n)}}getArraySizeFunction(e){const t=this.arraySizeFunctions.get(e);if(void 0!==t&&this.config.translationPackage.isFunctionTranslated(e)){const[e,r]=t;return(t,n)=>r[e](t,n)}}getMetadata(e){return this.functionsMetadata.get(e)}getPlugins(){const e=new Set;for(const[t,r]of this.instancePlugins)yi.functionIsProtected(t)||e.add(r);return Array.from(e)}getRegisteredFunctionIds(){return Array.from(this.functions.keys())}categorizeFunction(e,t){t.isVolatile&&this.volatileFunctions.add(e),t.arrayFunction&&this.arrayFunctions.add(e),t.doesNotNeedArgumentsToBeComputed&&this.functionsWhichDoesNotNeedArgumentsToBeComputed.add(e),t.isDependentOnSheetStructureChange&&this.structuralChangeFunctions.add(e),this.functionsMetadata.set(e,t)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
var Ei;yi.plugins=new Map,yi._protectedPlugins=new Map([["VERSION",fi],["OFFSET",void 0]]),function(e){e.GREATER_THAN="GREATER_THAN",e.GREATER_THAN_OR_EQUAL="GREATER_THAN_OR_EQUAL",e.LESS_THAN="LESS_THAN",e.LESS_THAN_OR_EQUAL="LESS_THAN_OR_EQUAL",e.NOT_EQUAL="NOT_EQUAL",e.EQUAL="EQUAL"}(Ei||(Ei={}));const wi=(e,t)=>({operator:e,value:t});class Ci{constructor(e){var t,r,n,s;this.trueString=null!==(r=null===(t=e.translationPackage.getMaybeFunctionTranslation("TRUE"))||void 0===t?void 0:t.toLowerCase())&&void 0!==r?r:"true",this.falseString=null!==(s=null===(n=e.translationPackage.getMaybeFunctionTranslation("FALSE"))||void 0===n?void 0:n.toLowerCase())&&void 0!==s?s:"false"}fromCellValue(e,t){if("string"!=typeof e&&"boolean"!=typeof e&&"number"!=typeof e)return;const r=this.parseCriterion(e,t);return void 0!==r?{raw:e,lambda:Ri(r,t)}:void 0}parseCriterion(e,t){if("number"==typeof e||"boolean"==typeof e)return wi(Ei.EQUAL,e);if("string"==typeof e){const r=vi.exec(e);let n,s;r?(s=function(e){switch(e){case">":return Ei.GREATER_THAN;case">=":return Ei.GREATER_THAN_OR_EQUAL;case"<":return Ei.LESS_THAN;case"<=":return Ei.LESS_THAN_OR_EQUAL;case"<>":return Ei.NOT_EQUAL;case"=":return Ei.EQUAL;default:return}}(r[1]),n=r[2]):(s=Ei.EQUAL,n=e);const i=t.coerceToMaybeNumber(n),o=n.toLowerCase()===this.trueString||n.toLowerCase()!==this.falseString&&void 0;if(void 0===s)return;if(""===n)return wi(s,null);if(void 0!==i)return wi(s,Ge(i));if(s===Ei.EQUAL||s===Ei.NOT_EQUAL)return wi(s,null!=o?o:n)}}}const vi=/([<>=]+)(.*)/;const Ri=(e,t)=>{switch(e.operator){case Ei.GREATER_THAN:return"number"==typeof e.value?r=>"number"==typeof r&&t.floatCmp(r,e.value)>0:e=>!1;case Ei.GREATER_THAN_OR_EQUAL:return"number"==typeof e.value?r=>"number"==typeof r&&t.floatCmp(r,e.value)>=0:e=>!1;case Ei.LESS_THAN:return"number"==typeof e.value?r=>"number"==typeof r&&t.floatCmp(r,e.value)<0:e=>!1;case Ei.LESS_THAN_OR_EQUAL:return"number"==typeof e.value?r=>"number"==typeof r&&t.floatCmp(r,e.value)<=0:e=>!1;case Ei.EQUAL:return"number"==typeof e.value?r=>{if("number"==typeof r)return 0===t.floatCmp(r,e.value);if("string"==typeof r){if(""===r)return!1;const n=t.coerceToMaybeNumber(r);return void 0!==n&&0===t.floatCmp(n,e.value)}return!1}:"string"==typeof e.value?t.eqMatcherFunction(e.value):"boolean"==typeof e.value?t=>"boolean"==typeof t&&t===e.value:e=>e===Ye;case Ei.NOT_EQUAL:return"number"==typeof e.value?r=>{if("number"==typeof r)return 0!==t.floatCmp(r,e.value);if("string"==typeof r){if(""===r)return!0;const n=t.coerceToMaybeNumber(r);return void 0===n||0!==t.floatCmp(n,e.value)}return!0}:"string"==typeof e.value?t.neqMatcherFunction(e.value):"boolean"==typeof e.value?t=>"boolean"!=typeof t||t!==e.value:e=>e!==Ye}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Si{constructor(e,t,r,n,s,i,o,a,l,h){this.config=e,this.dependencyGraph=t,this.columnSearch=r,this.stats=n,this.arithmeticHelper=s,this.functionRegistry=i,this.namedExpressions=o,this.serialization=a,this.arraySizePredictor=l,this.dateTimeHelper=h,this.equalOp=(e,t)=>Ni(this.arithmeticHelper.eq,e,t),this.notEqualOp=(e,t)=>Ni(this.arithmeticHelper.neq,e,t),this.greaterThanOp=(e,t)=>Ni(this.arithmeticHelper.gt,e,t),this.lessThanOp=(e,t)=>Ni(this.arithmeticHelper.lt,e,t),this.greaterThanOrEqualOp=(e,t)=>Ni(this.arithmeticHelper.geq,e,t),this.lessThanOrEqualOp=(e,t)=>Ni(this.arithmeticHelper.leq,e,t),this.concatOp=(e,t)=>Ni(this.arithmeticHelper.concat,Xr(e),Xr(t)),this.plusOp=(e,t)=>Ni(this.arithmeticHelper.addWithEpsilon,this.arithmeticHelper.coerceScalarToNumberOrError(e),this.arithmeticHelper.coerceScalarToNumberOrError(t)),this.minusOp=(e,t)=>Ni(this.arithmeticHelper.subtract,this.arithmeticHelper.coerceScalarToNumberOrError(e),this.arithmeticHelper.coerceScalarToNumberOrError(t)),this.timesOp=(e,t)=>Ni(this.arithmeticHelper.multiply,this.arithmeticHelper.coerceScalarToNumberOrError(e),this.arithmeticHelper.coerceScalarToNumberOrError(t)),this.powerOp=(e,t)=>Ni(this.arithmeticHelper.pow,this.arithmeticHelper.coerceScalarToNumberOrError(e),this.arithmeticHelper.coerceScalarToNumberOrError(t)),this.divOp=(e,t)=>Ni(this.arithmeticHelper.divide,this.arithmeticHelper.coerceScalarToNumberOrError(e),this.arithmeticHelper.coerceScalarToNumberOrError(t)),this.unaryMinusOp=e=>Ti(this.arithmeticHelper.unaryMinus,this.arithmeticHelper.coerceScalarToNumberOrError(e)),this.percentOp=e=>Ti(this.arithmeticHelper.unaryPercent,this.arithmeticHelper.coerceScalarToNumberOrError(e)),this.unaryPlusOp=e=>this.arithmeticHelper.unaryPlus(e),this.functionRegistry.initializePlugins(this),this.criterionBuilder=new Ci(e)}evaluateAst(e,t){let r=this.evaluateAstWithoutPostprocessing(e,t);if(Ze(r)){if(Zr(Ge(r)))return new Tr(ir.NUM,Z.NaN);r=ze(r,Jr(Ge(r)))}return r instanceof rt&&1===r.height()&&1===r.width()&&([[r]]=r.data),function(e,t){if(e instanceof Tr&&void 0!==t)return e.attachRootVertex(t);return e}(r,t.formulaVertex)}evaluateAstWithoutPostprocessing(e,t){switch(e.type){case U.EMPTY:return Ye;case U.CELL_REFERENCE:{const r=e.reference.toSimpleCellAddress(t.formulaAddress);return Or(r)?new Tr(ir.REF,Z.BadRef):this.dependencyGraph.getCellValue(r)}case U.NUMBER:case U.STRING:return e.value;case U.CONCATENATE_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.concatOp,r,n,t)}case U.EQUALS_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.equalOp,r,n,t)}case U.NOT_EQUAL_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.notEqualOp,r,n,t)}case U.GREATER_THAN_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.greaterThanOp,r,n,t)}case U.LESS_THAN_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.lessThanOp,r,n,t)}case U.GREATER_THAN_OR_EQUAL_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.greaterThanOrEqualOp,r,n,t)}case U.LESS_THAN_OR_EQUAL_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.lessThanOrEqualOp,r,n,t)}case U.PLUS_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.plusOp,r,n,t)}case U.MINUS_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.minusOp,r,n,t)}case U.TIMES_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.timesOp,r,n,t)}case U.POWER_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.powerOp,r,n,t)}case U.DIV_OP:{const r=this.evaluateAst(e.left,t),n=this.evaluateAst(e.right,t);return this.binaryRangeWrapper(this.divOp,r,n,t)}case U.PLUS_UNARY_OP:{const r=this.evaluateAst(e.value,t);return this.unaryRangeWrapper(this.unaryPlusOp,r,t)}case U.MINUS_UNARY_OP:{const r=this.evaluateAst(e.value,t);return this.unaryRangeWrapper(this.unaryMinusOp,r,t)}case U.PERCENT_OP:{const r=this.evaluateAst(e.value,t);return this.unaryRangeWrapper(this.percentOp,r,t)}case U.FUNCTION_CALL:{if("valid"!==this.config.licenseKeyValidityState&&!yi.functionIsProtected(e.procedureName))return new Tr(ir.LIC,Z.LicenseKey(this.config.licenseKeyValidityState));const r=this.functionRegistry.getFunction(e.procedureName);return void 0!==r?r(e,new Br(t.formulaAddress,t.arraysFlag||this.functionRegistry.isArrayFunction(e.procedureName),t.formulaVertex)):new Tr(ir.NAME,Z.FunctionName(e.procedureName))}case U.NAMED_EXPRESSION:{const r=this.namedExpressions.nearestNamedExpression(e.expressionName,t.formulaAddress.sheet);return r?this.dependencyGraph.getCellValue(r.address):new Tr(ir.NAME,Z.NamedExpressionName(e.expressionName))}case U.CELL_RANGE:{if(!this.rangeSpansOneSheet(e))return new Tr(ir.REF,Z.RangeManySheets);const r=Fr.fromCellRange(e,t.formulaAddress),n=this.dependencyGraph.getArray(r);if(n){const e=n.array;if(e instanceof Wt)throw new Error("Array should be already computed");if(e instanceof Tr)return e;if(e instanceof Yt)return rt.fromRange(e.raw(),r,this.dependencyGraph);throw new Error("Unknown array")}return rt.onlyRange(r,this.dependencyGraph)}case U.COLUMN_RANGE:{if(!this.rangeSpansOneSheet(e))return new Tr(ir.REF,Z.RangeManySheets);const r=Ur.fromColumnRange(e,t.formulaAddress);return rt.onlyRange(r,this.dependencyGraph)}case U.ROW_RANGE:{if(!this.rangeSpansOneSheet(e))return new Tr(ir.REF,Z.RangeManySheets);const r=Vr.fromRowRangeAst(e,t.formulaAddress);return rt.onlyRange(r,this.dependencyGraph)}case U.PARENTHESIS:return this.evaluateAst(e.expression,t);case U.ARRAY:{let r;const n=[];for(const s of e.args){let e;const i=[];for(const r of s){const n=jr(this.evaluateAst(r,t)),s=n.height();if(void 0===e)e=s,i.push(...n.data);else{if(e!==s)return new Tr(ir.REF,Z.SizeMismatch);for(let e=0;e<s;e++)i[e].push(...n.data[e])}}const o=i[0].length;if(void 0===r)r=o,n.push(...i);else{if(r!==o)return new Tr(ir.REF,Z.SizeMismatch);n.push(...i)}}return rt.onlyValues(n)}case U.ERROR_WITH_RAW_INPUT:case U.ERROR:return e.error}}rangeSpansOneSheet(e){return e.start.sheet===e.end.sheet}unaryRangeWrapper(e,t,r){var n;if(t instanceof rt&&!r.arraysFlag&&(t=null!==(n=an(t,r))&&void 0!==n?n:new Tr(ir.VALUE,Z.ScalarExpected)),t instanceof Tr)return t;if(t instanceof rt){const r=t.data.map((t=>t.map(e)));return rt.onlyValues(r)}return e(t)}binaryRangeWrapper(e,t,r,n){var s,i;if(t instanceof rt&&!n.arraysFlag&&(t=null!==(s=an(t,n))&&void 0!==s?s:new Tr(ir.VALUE,Z.ScalarExpected)),t instanceof Tr)return t;if(r instanceof rt&&!n.arraysFlag&&(r=null!==(i=an(r,n))&&void 0!==i?i:new Tr(ir.VALUE,Z.ScalarExpected)),r instanceof Tr)return r;if(t instanceof rt||r instanceof rt){if(!(t instanceof rt)){if(r.isAdHoc()){const n=r.data;for(let r=0;r<n.length;r++)for(let s=0;s<n[0].length;s++)n[r][s]=e(t,n[r][s]);return rt.onlyValues(n)}t=rt.fromScalar(t)}if(!(r instanceof rt)){if(t.isAdHoc()){const n=t.data;for(let t=0;t<n.length;t++)for(let s=0;s<n[0].length;s++)n[t][s]=e(n[t][s],r);return rt.onlyValues(n)}r=rt.fromScalar(r)}if(t.width()===r.width()&&t.height()===r.height()){if(t.isAdHoc()){const n=t.data,s=r.data;for(let t=0;t<n.length;t++)for(let r=0;r<n[0].length;r++)n[t][r]=e(n[t][r],s[t][r]);return rt.onlyValues(n)}if(r.isAdHoc()){const n=t.data,s=r.data;for(let t=0;t<n.length;t++)for(let r=0;r<n[0].length;r++)s[t][r]=e(n[t][r],s[t][r]);return rt.onlyValues(s)}}const n=Math.max(t.width(),r.width()),s=Math.max(t.height(),r.height()),i=Array(s);for(let e=0;e<s;e++)i[e]=Array(n);for(let o=0;o<s;o++){const s=1!==t.height()?o:0,a=1!==r.height()?o:0;for(let l=0;l<n;l++){const n=1!==t.width()?l:0,h=1!==r.width()?l:0;s<t.height()&&a<r.height()&&n<t.width()&&h<r.width()?i[o][l]=e(t.data[s][n],r.data[a][h]):i[o][l]=new Tr(ir.NA)}}return rt.onlyValues(i)}return e(t,r)}}function Ti(e,t){return t instanceof Tr?t:e(t)}function Ni(e,t,r){return t instanceof Tr?t:r instanceof Tr?r:e(t,r)}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Mi{constructor(e){this.sheet=e,this.transformations=[]}add(e){this.transformations.push(e)}performEagerTransformations(e,t){this.transformations.forEach((r=>r.performEagerTransformations(e,t)))}transformSingleAst(e,t){let[r,n]=[e,t];return this.transformations.forEach((e=>{[r,n]=e.transformSingleAst(r,n)})),[r,n]}isIrreversible(){return!0}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class _i{constructor(e){this.stats=e,this.transformations=[]}version(){return this.transformations.length}addTransformation(e){return void 0!==this.combinedTransformer?this.combinedTransformer.add(e):this.transformations.push(e),this.version()}beginCombinedMode(e){this.combinedTransformer=new Mi(e)}commitCombinedMode(){if(void 0===this.combinedTransformer)throw Error("Combined mode wasn't started");return this.transformations.push(this.combinedTransformer),this.combinedTransformer=void 0,this.version()}applyTransformations(e,t,r){this.stats.start(et.TRANSFORM_ASTS_POSTPONED);for(let n=r;n<this.transformations.length;n++){const r=this.transformations[n];r.isIrreversible()&&(this.undoRedo.storeDataForVersion(n,t,this.parser.computeHashFromAst(e)),this.parser.rememberNewAst(e));const[s,i]=r.transformSingleAst(e,t);e=s,t=i}const n=this.parser.rememberNewAst(e);return this.stats.end(et.TRANSFORM_ASTS_POSTPONED),[n,t,this.transformations.length]}*getTransformationsFrom(e,t){for(let r=e;r<this.transformations.length;r++){const e=this.transformations[r];t&&!t(e)||(yield e)}}}function bi(e,t,r){let n=t,s=r;for(;n<s;){const t=Math.ceil((n+s)/2);e(t)?n=t:s=t-1}return n===s&&e(n)?n:-1}function Ai(e,t){return typeof e==typeof t?e===Ye?0:e<t?-1:e>t?1:0:e===Ye?-1:t===Ye?1:t instanceof Tr||"number"==typeof e&&"string"==typeof t||"number"==typeof e&&"boolean"==typeof t?-1:"string"==typeof e&&"number"==typeof t?1:"string"==typeof e&&"boolean"==typeof t?-1:1}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Oi{constructor(e){this.dependencyGraph=e}advancedFind(e,t){let r;const n=t.range;r=void 0===n?t.valuesFromTopLeftCorner():this.dependencyGraph.computeListOfValuesInRange(n);for(let t=0;t<r.length;t++)if(e(Ge(r[t])))return t;return-1}basicFind(e,t,r,{ordering:n,matchExactly:s}){const i="string"==typeof e?on(e):e,o=t.range;return void 0===o?this.findNormalizedValue(i,t.valuesFromTopLeftCorner()):"none"===n?this.findNormalizedValue(i,this.dependencyGraph.computeListOfValuesInRange(o)):function(e,t,{searchCoordinate:r,orderingDirection:n,matchExactly:s},i){const o=t.start[r],a="col"===r?t.effectiveEndColumn(i):t.effectiveEndRow(i),l="col"===r?e=>Ge(i.getCellValue(Ar(t.sheet,e,t.start.row))):e=>Ge(i.getCellValue(Ar(t.sheet,t.start.col,e))),h="asc"===n?(e,t)=>Ai(e,t):(e,t)=>-Ai(e,t),u=bi((t=>h(e,l(t))>=0),o,a),c=l(u);return-1===u||typeof c!=typeof e||s&&c!==e?-1:u-o}(i,o,{searchCoordinate:r,orderingDirection:n,matchExactly:s},this.dependencyGraph)}findNormalizedValue(e,t){return t.map(Ge).map((e=>"string"==typeof e?on(e):e)).indexOf(e)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ii extends Oi{constructor(e){super(e),this.dependencyGraph=e}add(e,t){}remove(e,t){}change(e,t,r){}applyChanges(e){}addColumns(e){}removeColumns(e){}removeSheet(e){}moveValues(e,t,r,n){}removeValues(e){}find(e,t,r){return this.basicFind(e,t,"row",r)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class xi{constructor(e,t,r){this.dependencyGraph=e,this.config=t,this.stats=r,this.index=new Map,this.transformingService=this.dependencyGraph.lazilyTransformingAstService,this.binarySearchStrategy=new Ii(e)}add(e,t){if(!(e===Ye||e instanceof Tr))if(e instanceof rt)for(const[r,n]of e.entriesFromTopLeftCorner(t))this.addSingleCellValue(Ge(r),n);else this.addSingleCellValue(e,t)}remove(e,t){if(void 0!==e)if(e instanceof rt)for(const[r,n]of e.entriesFromTopLeftCorner(t))this.removeSingleValue(Ge(r),n);else this.removeSingleValue(e,t)}change(e,t,r){e!==t&&(this.remove(e,r),this.add(t,r))}applyChanges(e){for(const t of e)void 0!==t.oldValue&&this.change(Ge(t.oldValue),Ge(t.value),t.address)}moveValues(e,t,r,n){for(const[s,i]of e){const e=Ir(i,n,t,r);this.remove(s,i),this.add(s,e)}}removeValues(e){for(const[t,r]of e)this.remove(t,r)}find(e,t,{ordering:r,matchExactly:n}){const s=!0===n?"findFirst":"findLast",i=this.findUsingColumnIndex(e,t,s);return void 0!==i?i:this.binarySearchStrategy.find(e,t,{ordering:r,matchExactly:n})}findUsingColumnIndex(e,t,r){const n=t.range;if(void 0===n)return;this.ensureRecentData(n.sheet,n.start.col,e);const s=this.getColumnMap(n.sheet,n.start.col);if(!s)return-1;const i="string"==typeof e?on(e):e,o=s.get(i);if(!o||!o.index||0===o.index.length)return;const a=xi.findRowBelongingToRange(o,n,r);return void 0!==a?a-n.start.row:void 0}static findRowBelongingToRange(e,t,r){const n=t.start.row,s=t.end.row,i="findFirst"===r?Pi(n,e.index,"upperBound"):Pi(s,e.index,"lowerBound");if(-1===i)return;const o=e.index[i];return o>=n&&o<=s?o:void 0}advancedFind(e,t){return this.binarySearchStrategy.advancedFind(e,t)}addColumns(e){const t=this.index.get(e.sheet);t&&t.splice(e.columnStart,0,...Array(e.numberOfColumns))}removeColumns(e){const t=this.index.get(e.sheet);t&&t.splice(e.columnStart,e.numberOfColumns)}removeSheet(e){this.index.delete(e)}getColumnMap(e,t){this.index.has(e)||this.index.set(e,[]);const r=this.index.get(e);let n=r[t];return n||(n=new Map,r[t]=n),n}getValueIndex(e,t,r){const n=this.getColumnMap(e,t);let s=this.getColumnMap(e,t).get(r);return s||(s={version:this.transformingService.version(),index:[]},n.set(r,s)),s}ensureRecentData(e,t,r){const n=this.getValueIndex(e,t,r),s=this.transformingService.version();if(n.version===s)return;const i=this.transformingService.getTransformationsFrom(n.version,(t=>t.sheet===e&&(t instanceof Cs||t instanceof Ns)));for(const e of i)e instanceof Cs?this.addRows(t,e.rowsSpan,r):e instanceof Ns&&this.removeRows(t,e.rowsSpan,r);n.version=s}addSingleCellValue(e,t){this.stats.measure(et.BUILD_COLUMN_INDEX,(()=>{this.ensureRecentData(t.sheet,t.col,e),"string"==typeof e&&(e=on(e));const r=this.getValueIndex(t.sheet,t.col,e);xi.addValue(r,t.row)}))}removeSingleValue(e,t){this.stats.measure(et.BUILD_COLUMN_INDEX,(()=>{this.ensureRecentData(t.sheet,t.col,e);const r=this.getColumnMap(t.sheet,t.col);"string"==typeof e&&(e=on(e));const n=r.get(e);if(!n)return;const s=Pi(t.row,n.index);s>-1&&n.index.splice(s,1),0===n.index.length&&r.delete(e),0===r.size&&delete this.index.get(t.sheet)[t.col]}))}addRows(e,t,r){const n=this.getValueIndex(t.sheet,e,r);xi.shiftRows(n,t.rowStart,t.numberOfRows)}removeRows(e,t,r){const n=this.getValueIndex(t.sheet,e,r);xi.removeRowsFromValues(n,t),xi.shiftRows(n,t.rowEnd+1,-t.numberOfRows)}static addValue(e,t){const r=Pi(t,e.index,"lowerBound");e.index[r]===t||e.index.splice(r+1,0,t)}static removeRowsFromValues(e,t){const r=Pi(t.rowStart,e.index,"upperBound"),n=Pi(t.rowEnd,e.index,"lowerBound");r>-1&&n>-1&&r<=n&&e.index[r]<=t.rowEnd&&e.index.splice(r,n-r+1)}static shiftRows(e,t,r){const n=Pi(t,e.index,"upperBound");if(-1!==n)for(let t=n;t<e.index.length;++t)e.index[t]+=r}}function Pi(e,t,r="upperBound"){let n=0,s=t.length-1;for(;n<=s;){const r=Math.floor((n+s)/2);if(e>t[r])n=r+1;else{if(!(e<t[r]))return r;s=r-1}}const i="lowerBound"===r?s:n;return i>=0&&i<=t.length?i:-1}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Li{constructor(e){this.config=e;const t="."===this.config.thousandSeparator?`\\${this.config.thousandSeparator}`:this.config.thousandSeparator,r="."===this.config.decimalSeparator?`\\${this.config.decimalSeparator}`:this.config.decimalSeparator;this.numberPattern=new RegExp(`^([+-]?((${r}\\d+)|(\\d+(${t}\\d{3,})*(${r}\\d*)?)))(e[+-]?\\d+)?$`),this.allThousandSeparatorsRegex=new RegExp(`${t}`,"g")}numericStringToMaybeNumber(e){if(this.numberPattern.test(e)){const t=this.numericStringToNumber(e);if(isNaN(t))return;return t}}numericStringToNumber(e){const t=e.replace(this.allThousandSeparatorsRegex,"").replace(this.config.decimalSeparator,".");return Number(t)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Di{constructor(e,t,r){this.dependencyGraph=e,this.unparser=t,this.exporter=r}getCellHyperlink(e){const t=this.dependencyGraph.getCell(e);if(t instanceof $t){const e=t.getFormula(this.dependencyGraph.lazilyTransformingAstService);if("HYPERLINK"===e.procedureName)return e.hyperlink}}getCellFormula(e,t){const r=this.dependencyGraph.getCell(e);if(r instanceof $t){const n=r.getFormula(this.dependencyGraph.lazilyTransformingAstService);return t=null!=t?t:e,this.unparser.unparse(n,t)}if(r instanceof zt){const n=r.getAddress(this.dependencyGraph.lazilyTransformingAstService);if(n.row!==e.row||n.col!==e.col||n.sheet!==e.sheet)return;t=null!=t?t:e;const s=r.getFormula(this.dependencyGraph.lazilyTransformingAstService);if(void 0!==s)return this.unparser.unparse(s,t)}else if(r instanceof pr)return r.getFormula()}getCellSerialized(e,t){var r;return null!==(r=this.getCellFormula(e,t))&&void 0!==r?r:this.getRawValue(e)}getCellValue(e){return this.exporter.exportValue(this.dependencyGraph.getScalarValue(e))}getRawValue(e){return this.dependencyGraph.getRawValue(e)}getSheetValues(e){return this.genericSheetGetter(e,(e=>this.getCellValue(e)))}getSheetFormulas(e){return this.genericSheetGetter(e,(e=>this.getCellFormula(e)))}genericSheetGetter(e,t){const r=this.dependencyGraph.getSheetHeight(e),n=this.dependencyGraph.getSheetWidth(e),s=new Array(r);for(let i=0;i<r;i++){s[i]=new Array(n);for(let r=0;r<n;r++){const n=Ar(e,r,i);s[i][r]=t(n)}for(let e=n-1;e>=0&&(null===s[i][e]||void 0===s[i][e]);e--)s[i].pop()}for(let e=r-1;e>=0&&0===s[e].length;e--)s.pop();return s}genericAllSheetsGetter(e){const t={};for(const r of this.dependencyGraph.sheetMapping.displayNames()){const n=this.dependencyGraph.sheetMapping.fetch(r);t[r]=e(n)}return t}getSheetSerialized(e){return this.genericSheetGetter(e,(e=>this.getCellSerialized(e)))}getAllSheetsValues(){return this.genericAllSheetsGetter((e=>this.getSheetValues(e)))}getAllSheetsFormulas(){return this.genericAllSheetsGetter((e=>this.getSheetFormulas(e)))}getAllSheetsSerialized(){return this.genericAllSheetsGetter((e=>this.getSheetSerialized(e)))}getAllNamedExpressionsSerialized(){const e=[];let t=0;for(const r of this.dependencyGraph.sheetMapping.displayNames()){const n=this.dependencyGraph.sheetMapping.fetch(r);e[n]=t,t++}return this.dependencyGraph.namedExpressions.getAllNamedExpressions().map((t=>({name:t.expression.displayName,expression:this.getCellSerialized(t.expression.address),scope:void 0!==t.scope?e[t.scope]:void 0,options:t.expression.options})))}withNewConfig(e,t){const r=new xe(e,Ae(e),this.dependencyGraph.sheetMapping.fetchDisplayName,t);return new Di(this.dependencyGraph,r,this.exporter)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ki{static buildFromSheets(e,t={},r=[]){const n=new Yi(t);return this.buildEngine(n,e,r)}static buildFromSheet(e,t={},r=[]){const n=new Yi(t),s=n.translationPackage.getUITranslation(sr.NEW_SHEET_PREFIX)+"1";return this.buildEngine(n,{[s]:e},r)}static buildEmpty(e={},t=[]){return this.buildEngine(new Yi(e),{},t)}static rebuildWithConfig(e,t,r,n){return this.buildEngine(e,t,r,n)}static buildEngine(e,t={},r=[],n=(e.useStats?new ot:new at)){n.start(et.BUILD_ENGINE_TOTAL);const s=new ms,i=new yi(e),o=new _i(n),a=ur.buildEmpty(o,e,i,s,n),l=
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function(e,t,r){return t.useColumnIndex?new xi(e,t,r):new Ii(e)}(a,e,n),h=a.sheetMapping,u=a.addressMapping;for(const r in t)if(Object.prototype.hasOwnProperty.call(t,r)){const n=t[r];_s(n);const s=bs(n);if(s.height>e.maxRows||s.width>e.maxColumns)throw new ct;const i=h.addSheet(r);u.autoAddSheet(i,s)}const c=new Le(e,i,h.get);o.parser=c;const d=new xe(e,Ae(e),h.fetchDisplayName,s),p=new Pn(e),g=new Li(e),f=new Yr(e,p,g),m=new us(e,p,g),y=new dn(e,i),E=new Ps(e,a,l,m,c,n,o,s,y),w=new si(e,E);o.undoRedo=w;const C=new ds(e,a,E),v=new ii(e,E,w,C,a,l,c,m,o,s);r.forEach((e=>{v.ensureItIsPossibleToAddNamedExpression(e.name,e.expression,e.scope),v.operations.addNamedExpression(e.name,e.expression,e.scope,e.options)}));const R=new ci(e,s,h.fetchDisplayName,o),S=new Di(a,d,R),T=new Si(e,a,l,n,f,i,s,S,y,p);n.measure(et.GRAPH_BUILD,(()=>{new di(a,l,c,m,n,y).buildGraph(t,n)}));const N=new li(e,n,T,o,a,l);return N.run(),n.end(et.BUILD_ENGINE_TOTAL),{config:e,stats:n,dependencyGraph:a,columnSearch:l,parser:c,unparser:d,cellContentParser:m,evaluator:N,lazilyTransformingAstService:o,crudOperations:v,exporter:R,namedExpressions:s,serialization:S,functionRegistry:i}}}function Hi(e){return()=>{throw new Error(`The "${e}" method cannot be called because this HyperFormula instance has been destroyed`)}}var Fi,Ui=r(23420);!function(e){e.SheetAdded="sheetAdded",e.SheetRemoved="sheetRemoved",e.SheetRenamed="sheetRenamed",e.NamedExpressionAdded="namedExpressionAdded",e.NamedExpressionRemoved="namedExpressionRemoved",e.ValuesUpdated="valuesUpdated",e.EvaluationSuspended="evaluationSuspended",e.EvaluationResumed="evaluationResumed"}(Fi||(Fi={}));class Vi extends Ui.TinyEmitter{emit(e,...t){return super.emit(e,...t),this}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Bi{constructor(e,t,r,n,s,i,o,a,l,h,u,c,d,p){this._config=e,this._stats=t,this._dependencyGraph=r,this._columnSearch=n,this._parser=s,this._unparser=i,this._cellContentParser=o,this._evaluator=a,this._lazilyTransformingAstService=l,this._crudOperations=h,this._exporter=u,this._namedExpressions=c,this._serialization=d,this._functionRegistry=p,this._emitter=new Vi,this._evaluationSuspended=!1}static get defaultConfig(){return Gi({})}get graph(){return this.dependencyGraph.graph}get rangeMapping(){return this.dependencyGraph.rangeMapping}get arrayMapping(){return this.dependencyGraph.arrayMapping}get sheetMapping(){return this.dependencyGraph.sheetMapping}get addressMapping(){return this.dependencyGraph.addressMapping}get dependencyGraph(){return this._dependencyGraph}get evaluator(){return this._evaluator}get columnSearch(){return this._columnSearch}get lazilyTransformingAstService(){return this._lazilyTransformingAstService}get licenseKeyValidityState(){return this._config.licenseKeyValidityState}static buildFromArray(e,t={},r=[]){return this.buildFromEngineState(ki.buildFromSheet(e,t,r))}static buildFromSheets(e,t={},r=[]){return this.buildFromEngineState(ki.buildFromSheets(e,t,r))}static buildEmpty(e={},t=[]){return this.buildFromEngineState(ki.buildEmpty(e,t))}static getLanguage(e){En(e,"string","languageCode");const t=this.registeredLanguages.get(e);if(void 0===t)throw new xt;return t}static registerLanguage(e,t){if(En(e,"string","languageCode"),this.registeredLanguages.has(e))throw new Pt;var r;this.registeredLanguages.set(e,(r=t,new nr(Object.assign({},r.functions),Object.assign({},r.errors),Object.assign({},r.ui))))}static unregisterLanguage(e){if(En(e,"string","languageCode"),!this.registeredLanguages.has(e))throw new xt;this.registeredLanguages.delete(e)}static getRegisteredLanguagesCodes(){return Array.from(this.registeredLanguages.keys())}static registerFunctionPlugin(e,t){yi.registerFunctionPlugin(e,t)}static unregisterFunctionPlugin(e){yi.unregisterFunctionPlugin(e)}static registerFunction(e,t,r){En(e,"string","functionId"),yi.registerFunction(e,t,r)}static unregisterFunction(e){En(e,"string","functionId"),yi.unregisterFunction(e)}static unregisterAllFunctions(){yi.unregisterAll()}static getRegisteredFunctionNames(e){En(e,"string","code");const t=yi.getRegisteredFunctionIds();return this.getLanguage(e).getFunctionTranslations(t)}static getFunctionPlugin(e){return En(e,"string","functionId"),yi.getFunctionPlugin(e)}static getAllFunctionPlugins(){return yi.getPlugins()}static buildFromEngineState(e){return new Bi(e.config,e.stats,e.dependencyGraph,e.columnSearch,e.parser,e.unparser,e.cellContentParser,e.evaluator,e.lazilyTransformingAstService,e.crudOperations,e.exporter,e.namedExpressions,e.serialization,e.functionRegistry)}getCellValue(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");return this.ensureEvaluationIsNotSuspended(),this._serialization.getCellValue(e)}getCellFormula(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");return this._serialization.getCellFormula(e)}getCellHyperlink(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");return this.ensureEvaluationIsNotSuspended(),this._serialization.getCellHyperlink(e)}getCellSerialized(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");return this.ensureEvaluationIsNotSuspended(),this._serialization.getCellSerialized(e)}getSheetValues(e){return En(e,"number","sheetId"),this.ensureEvaluationIsNotSuspended(),this._serialization.getSheetValues(e)}getSheetFormulas(e){return En(e,"number","sheetId"),this._serialization.getSheetFormulas(e)}getSheetSerialized(e){return En(e,"number","sheetId"),this.ensureEvaluationIsNotSuspended(),this._serialization.getSheetSerialized(e)}getAllSheetsDimensions(){return this._serialization.genericAllSheetsGetter((e=>this.getSheetDimensions(e)))}getSheetDimensions(e){return En(e,"number","sheetId"),{width:this.dependencyGraph.getSheetWidth(e),height:this.dependencyGraph.getSheetHeight(e)}}getAllSheetsValues(){return this.ensureEvaluationIsNotSuspended(),this._serialization.getAllSheetsValues()}getAllSheetsFormulas(){return this._serialization.getAllSheetsFormulas()}getAllSheetsSerialized(){return this.ensureEvaluationIsNotSuspended(),this._serialization.getAllSheetsSerialized()}updateConfig(e){Object.entries(e).every((([e,t])=>this._config[e]===t))||this.rebuildWithConfig(e)}getConfig(){return this._config.getConfig()}rebuildAndRecalculate(){this.rebuildWithConfig({})}getStats(){return this._stats.snapshot()}undo(){return this._crudOperations.undo(),this.recomputeIfDependencyGraphNeedsIt()}redo(){return this._crudOperations.redo(),this.recomputeIfDependencyGraphNeedsIt()}isThereSomethingToUndo(){return this._crudOperations.isThereSomethingToUndo()}isThereSomethingToRedo(){return this._crudOperations.isThereSomethingToRedo()}isItPossibleToSetCellContents(e){let t;if(Pr(e))t=new Fr(e,e);else{if(!kr(e))throw new Tt("SimpleCellAddress | SimpleCellRange","address");t=new Fr(e.start,e.end)}try{this._crudOperations.ensureRangeInSizeLimits(t);for(const e of t.addresses(this._dependencyGraph))this._crudOperations.ensureItIsPossibleToChangeContent(e)}catch(e){return!1}return!0}setCellContents(e,t){return this._crudOperations.setCellContents(e,t),this.recomputeIfDependencyGraphNeedsIt()}swapRowIndexes(e,t){return En(e,"number","sheetId"),this._crudOperations.setRowOrder(e,t),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToSwapRowIndexes(e,t){En(e,"number","sheetId");try{return this._crudOperations.validateSwapRowIndexes(e,t),this._crudOperations.testRowOrderForArrays(e,t),!0}catch(e){return!1}}setRowOrder(e,t){En(e,"number","sheetId");const r=this._crudOperations.mappingFromOrder(e,t,"row");return this.swapRowIndexes(e,r)}isItPossibleToSetRowOrder(e,t){En(e,"number","sheetId");try{const r=this._crudOperations.mappingFromOrder(e,t,"row");return this._crudOperations.validateSwapRowIndexes(e,r),this._crudOperations.testRowOrderForArrays(e,r),!0}catch(e){return!1}}swapColumnIndexes(e,t){return En(e,"number","sheetId"),this._crudOperations.setColumnOrder(e,t),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToSwapColumnIndexes(e,t){En(e,"number","sheetId");try{return this._crudOperations.validateSwapColumnIndexes(e,t),this._crudOperations.testColumnOrderForArrays(e,t),!0}catch(e){return!1}}setColumnOrder(e,t){En(e,"number","sheetId");const r=this._crudOperations.mappingFromOrder(e,t,"column");return this.swapColumnIndexes(e,r)}isItPossibleToSetColumnOrder(e,t){En(e,"number","sheetId");try{const r=this._crudOperations.mappingFromOrder(e,t,"column");return this._crudOperations.validateSwapColumnIndexes(e,r),this._crudOperations.testColumnOrderForArrays(e,r),!0}catch(e){return!1}}isItPossibleToAddRows(e,...t){En(e,"number","sheetId");const r=Ds(t);try{return this._crudOperations.ensureItIsPossibleToAddRows(e,...r),!0}catch(e){return!1}}addRows(e,...t){return En(e,"number","sheetId"),this._crudOperations.addRows(e,...t),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToRemoveRows(e,...t){En(e,"number","sheetId");const r=Ls(t);try{return this._crudOperations.ensureItIsPossibleToRemoveRows(e,...r),!0}catch(e){return!1}}removeRows(e,...t){return En(e,"number","sheetId"),this._crudOperations.removeRows(e,...t),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToAddColumns(e,...t){En(e,"number","sheetId");const r=Ds(t);try{return this._crudOperations.ensureItIsPossibleToAddColumns(e,...r),!0}catch(e){return!1}}addColumns(e,...t){return En(e,"number","sheetId"),this._crudOperations.addColumns(e,...t),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToRemoveColumns(e,...t){En(e,"number","sheetId");const r=Ls(t);try{return this._crudOperations.ensureItIsPossibleToRemoveColumns(e,...r),!0}catch(e){return!1}}removeColumns(e,...t){return En(e,"number","sheetId"),this._crudOperations.removeColumns(e,...t),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToMoveCells(e,t){if(!Pr(t))throw new Tt("SimpleCellAddress","destinationLeftCorner");if(!kr(e))throw new Tt("SimpleCellRange","source");try{const r=new Fr(e.start,e.end);return this._crudOperations.operations.ensureItIsPossibleToMoveCells(r.start,r.width(),r.height(),t),!0}catch(e){return!1}}moveCells(e,t){if(!Pr(t))throw new Tt("SimpleCellAddress","destinationLeftCorner");if(!kr(e))throw new Tt("SimpleCellRange","source");const r=new Fr(e.start,e.end);return this._crudOperations.moveCells(r.start,r.width(),r.height(),t),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToMoveRows(e,t,r,n){En(e,"number","sheetId"),En(t,"number","startRow"),En(r,"number","numberOfRows"),En(n,"number","targetRow");try{return this._crudOperations.ensureItIsPossibleToMoveRows(e,t,r,n),!0}catch(e){return!1}}moveRows(e,t,r,n){return En(e,"number","sheetId"),En(t,"number","startRow"),En(r,"number","numberOfRows"),En(n,"number","targetRow"),this._crudOperations.moveRows(e,t,r,n),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToMoveColumns(e,t,r,n){En(e,"number","sheetId"),En(t,"number","startColumn"),En(r,"number","numberOfColumns"),En(n,"number","targetColumn");try{return this._crudOperations.ensureItIsPossibleToMoveColumns(e,t,r,n),!0}catch(e){return!1}}moveColumns(e,t,r,n){return En(e,"number","sheetId"),En(t,"number","startColumn"),En(r,"number","numberOfColumns"),En(n,"number","targetColumn"),this._crudOperations.moveColumns(e,t,r,n),this.recomputeIfDependencyGraphNeedsIt()}copy(e){if(!kr(e))throw new Tt("SimpleCellRange","source");const t=new Fr(e.start,e.end);return this._crudOperations.copy(t.start,t.width(),t.height()),this.getRangeValues(e)}cut(e){if(!kr(e))throw new Tt("SimpleCellRange","source");const t=new Fr(e.start,e.end);return this._crudOperations.cut(t.start,t.width(),t.height()),this.getRangeValues(e)}paste(e){if(!Pr(e))throw new Tt("SimpleCellAddress","targetLeftCorner");return this.ensureEvaluationIsNotSuspended(),this._crudOperations.paste(e),this.recomputeIfDependencyGraphNeedsIt()}isClipboardEmpty(){return this._crudOperations.isClipboardEmpty()}clearClipboard(){this._crudOperations.clearClipboard()}clearRedoStack(){this._crudOperations.undoRedo.clearRedoStack()}clearUndoStack(){this._crudOperations.undoRedo.clearUndoStack()}getRangeValues(e){if(!kr(e))throw new Tt("SimpleCellRange","source");return new Fr(e.start,e.end).arrayOfAddressesInRange().map((e=>e.map((e=>this.getCellValue(e)))))}getRangeFormulas(e){if(!kr(e))throw new Tt("SimpleCellRange","source");return new Fr(e.start,e.end).arrayOfAddressesInRange().map((e=>e.map((e=>this.getCellFormula(e)))))}getRangeSerialized(e){if(!kr(e))throw new Tt("SimpleCellRange","source");return new Fr(e.start,e.end).arrayOfAddressesInRange().map((e=>e.map((e=>this.getCellSerialized(e)))))}getFillRangeData(e,t,r=!1){if(!kr(e))throw new Tt("SimpleCellRange","source");if(!kr(t))throw new Tt("SimpleCellRange","target");const n=new Fr(e.start,e.end),s=new Fr(t.start,t.end);return this.ensureEvaluationIsNotSuspended(),s.arrayOfAddressesInRange().map((s=>s.map((s=>{const i=((s.row-(r?t:e).start.row)%n.height()+n.height())%n.height()+e.start.row,o=((s.col-(r?t:e).start.col)%n.width()+n.width())%n.width()+e.start.col;return this._serialization.getCellSerialized({row:i,col:o,sheet:n.sheet},s)}))))}isItPossibleToAddSheet(e){En(e,"string","sheetName");try{return this._crudOperations.ensureItIsPossibleToAddSheet(e),!0}catch(e){return!1}}addSheet(e){void 0!==e&&En(e,"string","sheetName");const t=this._crudOperations.addSheet(e);return this._emitter.emit(Fi.SheetAdded,t),t}isItPossibleToRemoveSheet(e){En(e,"number","sheetId");try{return this._crudOperations.ensureScopeIdIsValid(e),!0}catch(e){return!1}}removeSheet(e){En(e,"number","sheetId");const t=this.sheetMapping.getDisplayName(e);this._crudOperations.removeSheet(e);const r=this.recomputeIfDependencyGraphNeedsIt();return this._emitter.emit(Fi.SheetRemoved,t,r),r}isItPossibleToClearSheet(e){En(e,"number","sheetId");try{return this._crudOperations.ensureScopeIdIsValid(e),!0}catch(e){return!1}}clearSheet(e){return En(e,"number","sheetId"),this._crudOperations.clearSheet(e),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToReplaceSheetContent(e,t){En(e,"number","sheetId");try{return this._crudOperations.ensureScopeIdIsValid(e),this._crudOperations.ensureItIsPossibleToChangeSheetContents(e,t),!0}catch(e){return!1}}setSheetContent(e,t){return En(e,"number","sheetId"),this._crudOperations.setSheetContent(e,t),this.recomputeIfDependencyGraphNeedsIt()}simpleCellAddressFromString(e,t){return En(e,"string","cellAddress"),En(t,"number","sheetId"),O(this.sheetMapping.get,e,t)}simpleCellRangeFromString(e,t){return En(e,"string","cellRange"),En(t,"number","sheetId"),((e,t,r)=>{const n=t.split(h);if(2!==n.length)return;const[s,i]=n,o=O(e,s,r);if(void 0===o)return;const a=O(e,i,o.sheet);return void 0!==a&&o.sheet===a.sheet?Hr(o,a):void 0})(this.sheetMapping.get,e,t)}simpleCellAddressToString(e,t){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");return En(t,"number","sheetId"),I(this.sheetMapping.fetchDisplayName,e,t)}simpleCellRangeToString(e,t){if(!kr(e))throw new Tt("SimpleCellRange","cellRange");return En(t,"number","sheetId"),((e,t,r)=>{const n=I(e,t.start,r),s=I(e,t.end,t.start.sheet);return void 0===n||void 0===s?void 0:`${n}${h}${s}`})(this.sheetMapping.fetchDisplayName,e,t)}getCellDependents(e){let t;if(Pr(e))t=this._dependencyGraph.addressMapping.getCell(e);else{if(!kr(e))throw new Tt("SimpleCellAddress | SimpleCellRange",e);t=this._dependencyGraph.rangeMapping.getRange(e.start,e.end)}return void 0===t?[]:this._dependencyGraph.getAdjacentNodesAddresses(t)}getCellPrecedents(e){let t;if(Pr(e))t=this._dependencyGraph.addressMapping.getCell(e);else{if(!kr(e))throw new Tt("SimpleCellAddress | SimpleCellRange",e);t=this._dependencyGraph.rangeMapping.getRange(e.start,e.end)}return void 0===t?[]:this._dependencyGraph.dependencyQueryAddresses(t)}getSheetName(e){return En(e,"number","sheetId"),this.sheetMapping.getDisplayName(e)}getSheetNames(){return this.sheetMapping.sheetNames()}getSheetId(e){return En(e,"string","sheetName"),this.sheetMapping.get(e)}doesSheetExist(e){return En(e,"string","sheetName"),this.sheetMapping.hasSheetWithName(e)}getCellType(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");return((e,t)=>e instanceof zt?e.isLeftCorner(t)?or.ARRAYFORMULA:or.ARRAY:e instanceof $t||e instanceof pr?or.FORMULA:e instanceof dr?or.VALUE:or.EMPTY)(this.dependencyGraph.getCell(e),e)}doesCellHaveSimpleValue(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");return this.getCellType(e)===or.VALUE}doesCellHaveFormula(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");const t=this.getCellType(e);return t===or.FORMULA||t===or.ARRAYFORMULA}isCellEmpty(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");return this.getCellType(e)===or.EMPTY}isCellPartOfArray(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");const t=this.getCellType(e);return t===or.ARRAY||t===or.ARRAYFORMULA}getCellValueType(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");this.ensureEvaluationIsNotSuspended();const t=this.dependencyGraph.getCellValue(e);return vr(t)}getCellValueDetailedType(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");this.ensureEvaluationIsNotSuspended();const t=this.dependencyGraph.getCellValue(e);return Rr(t)}getCellValueFormat(e){if(!Pr(e))throw new Tt("SimpleCellAddress","cellAddress");this.ensureEvaluationIsNotSuspended();const t=this.dependencyGraph.getCellValue(e);return Sr(t)}countSheets(){return this.sheetMapping.numberOfSheets()}isItPossibleToRenameSheet(e,t){En(e,"number","sheetId"),En(t,"string","newName");try{return this._crudOperations.ensureItIsPossibleToRenameSheet(e,t),!0}catch(e){return!1}}renameSheet(e,t){En(e,"number","sheetId"),En(t,"string","newName");const r=this._crudOperations.renameSheet(e,t);void 0!==r&&this._emitter.emit(Fi.SheetRenamed,r,t)}batch(e){this.suspendEvaluation(),this._crudOperations.beginUndoRedoBatchMode();try{e()}catch(e){throw this._crudOperations.commitUndoRedoBatchMode(),this.resumeEvaluation(),e}return this._crudOperations.commitUndoRedoBatchMode(),this.resumeEvaluation()}suspendEvaluation(){this._evaluationSuspended=!0,this._emitter.emit(Fi.EvaluationSuspended)}resumeEvaluation(){this._evaluationSuspended=!1;const e=this.recomputeIfDependencyGraphNeedsIt();return this._emitter.emit(Fi.EvaluationResumed,e),e}isEvaluationSuspended(){return this._evaluationSuspended}isItPossibleToAddNamedExpression(e,t,r){En(e,"string","expressionName"),void 0!==r&&En(r,"number","scope");try{return this._crudOperations.ensureItIsPossibleToAddNamedExpression(e,t,r),!0}catch(e){return!1}}addNamedExpression(e,t,r,n){En(e,"string","expressionName"),void 0!==r&&En(r,"number","scope"),this._crudOperations.addNamedExpression(e,t,r,n);const s=this.recomputeIfDependencyGraphNeedsIt();return this._emitter.emit(Fi.NamedExpressionAdded,e,s),s}getNamedExpressionValue(e,t){En(e,"string","expressionName"),void 0!==t&&En(t,"number","scope"),this.ensureEvaluationIsNotSuspended(),this._crudOperations.ensureScopeIdIsValid(t);const r=this._namedExpressions.namedExpressionForScope(e,t);return r?this._serialization.getCellValue(r.address):void 0}getNamedExpressionFormula(e,t){En(e,"string","expressionName"),void 0!==t&&En(t,"number","scope"),this._crudOperations.ensureScopeIdIsValid(t);const r=this._namedExpressions.namedExpressionForScope(e,t);return void 0===r?void 0:this._serialization.getCellFormula(r.address)}getNamedExpression(e,t){En(e,"string","expressionName"),void 0!==t&&En(t,"number","scope");const r=this._namedExpressions.namedExpressionForScope(e,t);if(void 0===r)return;return{name:e,scope:t,expression:this._serialization.getCellFormula(r.address),options:r.options}}isItPossibleToChangeNamedExpression(e,t,r){En(e,"string","expressionName"),void 0!==r&&En(r,"number","scope");try{return this._crudOperations.ensureItIsPossibleToChangeNamedExpression(e,t,r),!0}catch(e){return!1}}changeNamedExpression(e,t,r,n){return En(e,"string","expressionName"),void 0!==r&&En(r,"number","scope"),this._crudOperations.changeNamedExpressionExpression(e,r,t,n),this.recomputeIfDependencyGraphNeedsIt()}isItPossibleToRemoveNamedExpression(e,t){En(e,"string","expressionName"),void 0!==t&&En(t,"number","scope");try{return this._crudOperations.isItPossibleToRemoveNamedExpression(e,t),!0}catch(e){return!1}}removeNamedExpression(e,t){En(e,"string","expressionName"),void 0!==t&&En(t,"number","scope");const r=this._crudOperations.removeNamedExpression(e,t);if(r){const e=this.recomputeIfDependencyGraphNeedsIt();return this._emitter.emit(Fi.NamedExpressionRemoved,r.displayName,e),e}return[]}listNamedExpressions(e){return void 0!==e&&En(e,"number","scope"),this._crudOperations.ensureScopeIdIsValid(e),this._namedExpressions.getAllNamedExpressionsNamesInScope(e)}getAllNamedExpressionsSerialized(){return this._serialization.getAllNamedExpressionsSerialized()}normalizeFormula(e){En(e,"string","formulaString");const{ast:t,address:r}=this.extractTemporaryFormula(e);if(void 0===t)throw new dt;return this._unparser.unparse(t,r)}calculateFormula(e,t){En(e,"string","formulaString"),En(t,"number","sheetId"),this._crudOperations.ensureScopeIdIsValid(t);const{ast:r,address:n,dependencies:s}=this.extractTemporaryFormula(e,t);if(void 0===r)throw new dt;const i=this.evaluator.runAndForget(r,n,s);return this._exporter.exportScalarOrRange(i)}getNamedExpressionsFromFormula(e){En(e,"string","formulaString");const{ast:t,dependencies:r}=this.extractTemporaryFormula(e);if(void 0===t)throw new dt;const n=r.filter((e=>e instanceof Be)).map((e=>e.name));return[...new Set(n)]}validateFormula(e){En(e,"string","formulaString");const{ast:t}=this.extractTemporaryFormula(e);return void 0!==t}getRegisteredFunctionNames(){return Bi.getLanguage(this._config.language).getFunctionTranslations(this._functionRegistry.getRegisteredFunctionIds())}getFunctionPlugin(e){return En(e,"string","functionId"),this._functionRegistry.getFunctionPlugin(e)}getAllFunctionPlugins(){return this._functionRegistry.getPlugins()}numberToDateTime(e){return En(e,"number","val"),this._evaluator.interpreter.dateTimeHelper.numberToSimpleDateTime(e)}numberToDate(e){return En(e,"number","val"),this._evaluator.interpreter.dateTimeHelper.numberToSimpleDate(e)}numberToTime(e){return En(e,"number","val"),kn(e)}on(e,t){this._emitter.on(e,t)}once(e,t){this._emitter.once(e,t)}off(e,t){this._emitter.off(e,t)}destroy(){!
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function(e){for(const[t,r]of Object.entries(e))r instanceof Function?e[t]=Hi(r):delete e[t]}(this)}ensureEvaluationIsNotSuspended(){if(this._evaluationSuspended)throw new At}extractTemporaryFormula(e,t=1){const r=this._cellContentParser.parse(e),n={sheet:t,col:0,row:0};if(!(r instanceof as.Formula))return{address:n,dependencies:[]};const{ast:s,errors:i,dependencies:o}=this._parser.parse(r.formula,n);return i.length>0?{address:n,dependencies:[]}:{ast:s,address:n,dependencies:o}}rebuildWithConfig(e){const t=this._config.mergeConfig(e),r=this._config.mergeConfig({language:e.language}),n=this._serialization.withNewConfig(r,this._namedExpressions).getAllSheetsSerialized(),s=this._serialization.getAllNamedExpressionsSerialized(),i=ki.rebuildWithConfig(t,n,s,this._stats);this._config=i.config,this._stats=i.stats,this._dependencyGraph=i.dependencyGraph,this._columnSearch=i.columnSearch,this._parser=i.parser,this._unparser=i.unparser,this._cellContentParser=i.cellContentParser,this._evaluator=i.evaluator,this._lazilyTransformingAstService=i.lazilyTransformingAstService,this._crudOperations=i.crudOperations,this._exporter=i.exporter,this._namedExpressions=i.namedExpressions,this._serialization=i.serialization,this._functionRegistry=i.functionRegistry}recomputeIfDependencyGraphNeedsIt(){if(this._evaluationSuspended)return[];{const e=this._crudOperations.getAndClearContentChanges(),t=this.dependencyGraph.verticesToRecompute();this.dependencyGraph.clearDirtyVertices(),t.length>0&&e.addAll(this.evaluator.partialRun(t));const r=e.exportChanges(this._exporter);return e.isEmpty()||this._emitter.emit(Fi.ValuesUpdated,r),r}}}Bi.version="2.7.1",Bi.buildDate="18/07/2024 11:23:17",Bi.releaseDate="18/07/2024",Bi.languages={},Bi.registeredLanguages=new Map;
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const Wi=new WeakMap;class Yi{constructor(e={},t=!0){const{accentSensitive:r,binarySearchThreshold:n,caseSensitive:s,caseFirst:i,chooseAddressMappingPolicy:o,context:a,currencySymbol:l,dateFormats:h,decimalSeparator:u,evaluateNullToZero:c,functionArgSeparator:d,functionPlugins:p,ignorePunctuation:g,leapYear1900:f,localeLang:m,language:y,ignoreWhiteSpace:E,licenseKey:w,matchWholeCell:C,arrayColumnSeparator:v,arrayRowSeparator:R,maxRows:S,maxColumns:T,nullYear:N,nullDate:M,parseDateTime:_,precisionEpsilon:b,precisionRounding:A,stringifyDateTime:O,stringifyDuration:I,smartRounding:x,timeFormats:P,thousandSeparator:L,useArrayArithmetic:D,useStats:k,undoLimit:H,useColumnIndex:F,useRegularExpressions:U,useWildcards:V}=e;t&&Yi.warnDeprecatedOptions(e),this.useArrayArithmetic=gn(D,"boolean","useArrayArithmetic"),this.accentSensitive=gn(r,"boolean","accentSensitive"),this.caseSensitive=gn(s,"boolean","caseSensitive"),this.caseFirst=gn(i,["upper","lower","false"],"caseFirst"),this.ignorePunctuation=gn(g,"boolean","ignorePunctuation"),this.chooseAddressMappingPolicy=null!=o?o:Yi.defaultConfig.chooseAddressMappingPolicy,this.dateFormats=[...mn(h,Array.isArray,"array","dateFormats")],this.timeFormats=[...mn(P,Array.isArray,"array","timeFormats")],this.functionArgSeparator=gn(d,"string","functionArgSeparator"),this.decimalSeparator=gn(u,[".",","],"decimalSeparator"),this.language=gn(y,"string","language"),this.ignoreWhiteSpace=gn(E,["standard","any"],"ignoreWhiteSpace"),this.licenseKey=gn(w,"string","licenseKey"),this.thousandSeparator=gn(L,["",","," ","."],"thousandSeparator"),this.arrayColumnSeparator=gn(v,[",",";"],"arrayColumnSeparator"),this.arrayRowSeparator=gn(R,[";","|"],"arrayRowSeparator"),this.localeLang=gn(m,"string","localeLang"),this.functionPlugins=[...null!=p?p:Yi.defaultConfig.functionPlugins],this.smartRounding=gn(x,"boolean","smartRounding"),this.evaluateNullToZero=gn(c,"boolean","evaluateNullToZero"),this.nullYear=gn(N,"number","nullYear"),fn(this.nullYear,"nullYear",0),function(e,t,r){if(e>r)throw new _t(t,r)}(this.nullYear,"nullYear",100),this.precisionRounding=gn(A,"number","precisionRounding"),fn(this.precisionRounding,"precisionRounding",0),this.precisionEpsilon=gn(b,"number","precisionEpsilon"),fn(this.precisionEpsilon,"precisionEpsilon",0),this.useColumnIndex=gn(F,"boolean","useColumnIndex"),this.useStats=gn(k,"boolean","useStats"),this.binarySearchThreshold=null!=n?n:Yi.defaultConfig.binarySearchThreshold,this.parseDateTime=gn(_,"function","parseDateTime"),this.stringifyDateTime=gn(O,"function","stringifyDateTime"),this.stringifyDuration=gn(I,"function","stringifyDuration"),this.translationPackage=Bi.getLanguage(this.language),this.errorMapping=this.translationPackage.buildErrorMapping(),this.nullDate=mn(M,On,"IDate","nullDate"),this.leapYear1900=gn(f,"boolean","leapYear1900"),this.undoLimit=gn(H,"number","undoLimit"),this.useRegularExpressions=gn(U,"boolean","useRegularExpressions"),this.useWildcards=gn(V,"boolean","useWildcards"),this.matchWholeCell=gn(C,"boolean","matchWholeCell"),fn(this.undoLimit,"undoLimit",0),this.maxRows=gn(S,"number","maxRows"),fn(this.maxRows,"maxRows",1),this.maxColumns=gn(T,"number","maxColumns"),this.currencySymbol=this.setupCurrencySymbol(l),fn(this.maxColumns,"maxColumns",1),this.context=a,Wi.set(this,{licenseKeyValidityState:os(this.licenseKey)}),yn({value:this.decimalSeparator,name:"decimalSeparator"},{value:this.functionArgSeparator,name:"functionArgSeparator"},{value:this.thousandSeparator,name:"thousandSeparator"}),yn({value:this.arrayRowSeparator,name:"arrayRowSeparator"},{value:this.arrayColumnSeparator,name:"arrayColumnSeparator"})}setupCurrencySymbol(e){const t=[...mn(e,Array.isArray,"array","currencySymbol")];return t.forEach((e=>{if("string"!=typeof e)throw new Tt("string[]","currencySymbol");if(""===e)throw new Nt("currencySymbol")})),t}get licenseKeyValidityState(){return Wi.get(this).licenseKeyValidityState}getConfig(){return Gi(this)}mergeConfig(e){const t=Object.assign({},this.getConfig(),e);return Yi.warnDeprecatedOptions(e),new Yi(t,!1)}static warnDeprecatedOptions(e){Yi.warnDeprecatedIfUsed(e.binarySearchThreshold,"binarySearchThreshold","1.1")}static warnDeprecatedIfUsed(e,t,r,n){void 0!==e&&(void 0===n?console.warn(`${t} option is deprecated since ${r}`):console.warn(`${t} option is deprecated since ${r}, please use ${n}`))}}function Gi(e){var t;const r={};for(const n in Yi.defaultConfig){const s=null!==(t=e[n])&&void 0!==t?t:Yi.defaultConfig[n];Array.isArray(s)?r[n]=[...s]:r[n]=s}return r}Yi.defaultConfig={accentSensitive:!1,binarySearchThreshold:20,currencySymbol:["$"],caseSensitive:!1,caseFirst:"lower",context:void 0,chooseAddressMappingPolicy:new class{call(){return fr}},dateFormats:["DD/MM/YYYY","DD/MM/YY"],decimalSeparator:".",evaluateNullToZero:!1,functionArgSeparator:",",functionPlugins:[],ignorePunctuation:!1,language:"enGB",ignoreWhiteSpace:"standard",licenseKey:"",leapYear1900:!1,localeLang:"en",matchWholeCell:!0,arrayColumnSeparator:",",arrayRowSeparator:";",maxRows:4e4,maxColumns:18278,nullYear:30,nullDate:{year:1899,month:12,day:30},parseDateTime:function(e,t,r){if(void 0===t&&void 0===r)return;let n=e.replace(vn," ").trim().toLowerCase();if(!function(e){return Cn.test(e)}(n))return;let s=n.substring(n.length-2);"am"===s||"pm"===s?n=n.substring(0,n.length-2).trim():(s=n.substring(n.length-1),"a"===s||"p"===s?n=n.substring(0,n.length-1).trim():s=void 0);const i=n.split(Rn);i.length>=2&&i[i.length-2].includes(":")&&(i[i.length-2]=i[i.length-2]+"."+i[i.length-1],i.pop());const o=i[i.length-1].split(":");if(void 0!==s&&o.push(s),1===i.length)return Nn(o,r);if(1===o.length)return Mn(i,t);const a=Mn(i.slice(0,i.length-1),t),l=Nn(o,r);return void 0===a||void 0===l?void 0:Object.assign(Object.assign({},a),l)},precisionEpsilon:1e-13,precisionRounding:14,smartRounding:!0,stringifyDateTime:function(e,t){const r=jn(t);if(void 0===r)return;const n=r.tokens;let s="",i=!1;const o=n.some((e=>e.type===Bn.FORMAT&&("a/p"===e.value||"A/P"===e.value||"am/pm"===e.value||"AM/PM"===e.value)));for(let t=0;t<n.length;t++){const r=n[t];if(r.type!==Bn.FREE_TEXT)switch(r.value.toLowerCase()){case"h":case"hh":i=!0,s+=Xn(o?(e.hours+11)%12+1:e.hours,r.value.length);break;case"d":case"dd":s+=Xn(e.day,r.value.length);break;case"s":case"ss":s+=Xn(Math.floor(e.seconds),r.value.length);break;case"m":case"mm":t+1<n.length&&n[t+1].value.startsWith(":")&&(i=!0),s+=Xn(i?e.minutes:e.month,r.value.length),i=!0;break;case"yy":s+=Xn(e.year%100,r.value.length);break;case"yyyy":s+=e.year;break;case"am/pm":case"a/p":{const[t,n]=r.value.split("/");s+=e.hours<12?t:n;break}default:if(wn.test(r.value)){const t=r.value.length-3;s+=`${e.seconds<10?"0":""}${Math.floor(e.seconds*Math.pow(10,t))/Math.pow(10,t)}`;continue}return}else s+=r.value}return s},stringifyDuration:function(e,t){const r=jn(t);if(void 0===r)return;const n=r.tokens;let s="";for(const t of n)if(t.type!==Bn.FREE_TEXT)switch(t.value.toLowerCase()){case"h":case"hh":s+=Xn(e.hours,t.value.length),e.hours=0;break;case"[hh]":s+=Xn(e.hours,t.value.length-2),e.hours=0;break;case"m":case"mm":s+=Xn(e.minutes,t.value.length),e.minutes=0;break;case"[mm]":s+=Xn(e.minutes+60*e.hours,t.value.length-2),e.minutes=0,e.hours=0;break;case"s":case"ss":s+=Xn(Math.floor(e.seconds),t.value.length);break;default:if(wn.test(t.value)){const r=Math.max(t.value.length-3,0);s+=`${e.seconds<10?"0":""}${Math.floor(e.seconds*Math.pow(10,r))/Math.pow(10,r)}`;continue}return}else s+=t.value;return s},timeFormats:["hh:mm","hh:mm:ss.sss"],thousandSeparator:"",undoLimit:20,useRegularExpressions:!1,useWildcards:!0,useColumnIndex:!1,useStats:!1,useArrayArithmetic:!1};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const ji={errors:{CYCLE:"#CYCLE!",DIV_BY_ZERO:"#DIV/0!",ERROR:"#ERROR!",NA:"#N/A",NAME:"#NAME?",NUM:"#NUM!",REF:"#REF!",SPILL:"#SPILL!",VALUE:"#VALUE!"},functions:{FILTER:"FILTER",ADDRESS:"ADDRESS",ARRAY_CONSTRAIN:"ARRAY_CONSTRAIN",ARRAYFORMULA:"ARRAYFORMULA",ABS:"ABS",ACOS:"ACOS",ACOSH:"ACOSH",ACOT:"ACOT",ACOTH:"ACOTH",AND:"AND",ARABIC:"ARABIC",ASIN:"ASIN",ASINH:"ASINH",ATAN2:"ATAN2",ATAN:"ATAN",ATANH:"ATANH",AVERAGE:"AVERAGE",AVERAGEA:"AVERAGEA",AVERAGEIF:"AVERAGEIF",BASE:"BASE",BIN2DEC:"BIN2DEC",BIN2HEX:"BIN2HEX",BIN2OCT:"BIN2OCT",BITAND:"BITAND",BITLSHIFT:"BITLSHIFT",BITOR:"BITOR",BITRSHIFT:"BITRSHIFT",BITXOR:"BITXOR",CEILING:"CEILING",CHAR:"CHAR",CHOOSE:"CHOOSE",CLEAN:"CLEAN",CODE:"CODE",COLUMN:"COLUMN",COLUMNS:"COLUMNS",CONCATENATE:"CONCATENATE",CORREL:"CORREL",COS:"COS",COSH:"COSH",COT:"COT",COTH:"COTH",COUNT:"COUNT",COUNTA:"COUNTA",COUNTBLANK:"COUNTBLANK",COUNTIF:"COUNTIF",COUNTIFS:"COUNTIFS",COUNTUNIQUE:"COUNTUNIQUE",CSC:"CSC",CSCH:"CSCH",CUMIPMT:"CUMIPMT",CUMPRINC:"CUMPRINC",DATE:"DATE",DATEDIF:"DATEDIF",DATEVALUE:"DATEVALUE",DAY:"DAY",DAYS360:"DAYS360",DAYS:"DAYS",DB:"DB",DDB:"DDB",DEC2BIN:"DEC2BIN",DEC2HEX:"DEC2HEX",DEC2OCT:"DEC2OCT",DECIMAL:"DECIMAL",DEGREES:"DEGREES",DELTA:"DELTA",DOLLARDE:"DOLLARDE",DOLLARFR:"DOLLARFR",EDATE:"EDATE",EFFECT:"EFFECT",EOMONTH:"EOMONTH",ERF:"ERF",ERFC:"ERFC",EVEN:"EVEN",EXACT:"EXACT",EXP:"EXP",FALSE:"FALSE",FIND:"FIND",FORMULATEXT:"FORMULATEXT",FV:"FV",FVSCHEDULE:"FVSCHEDULE",HEX2BIN:"HEX2BIN",HEX2DEC:"HEX2DEC",HEX2OCT:"HEX2OCT",HLOOKUP:"HLOOKUP",HOUR:"HOUR",HYPERLINK:"HYPERLINK",IF:"IF",IFERROR:"IFERROR",IFNA:"IFNA",IFS:"IFS",INDEX:"INDEX",INT:"INT",INTERVAL:"INTERVAL",IPMT:"IPMT",ISBINARY:"ISBINARY",ISBLANK:"ISBLANK",ISERR:"ISERR",ISERROR:"ISERROR",ISEVEN:"ISEVEN",ISFORMULA:"ISFORMULA",ISLOGICAL:"ISLOGICAL",ISNA:"ISNA",ISNONTEXT:"ISNONTEXT",ISNUMBER:"ISNUMBER",ISODD:"ISODD",ISOWEEKNUM:"ISOWEEKNUM",ISPMT:"ISPMT",ISREF:"ISREF",ISTEXT:"ISTEXT",LEFT:"LEFT",LEN:"LEN",LN:"LN",LOG10:"LOG10",LOG:"LOG",LOWER:"LOWER",MATCH:"MATCH",MAX:"MAX",MAXA:"MAXA",MAXIFS:"MAXIFS",MAXPOOL:"MAXPOOL",MEDIAN:"MEDIAN",MEDIANPOOL:"MEDIANPOOL",MID:"MID",MIN:"MIN",MINA:"MINA",MINIFS:"MINIFS",MINUTE:"MINUTE",MIRR:"MIRR",MMULT:"MMULT",MOD:"MOD",MONTH:"MONTH",NA:"NA",NETWORKDAYS:"NETWORKDAYS","NETWORKDAYS.INTL":"NETWORKDAYS.INTL",NOMINAL:"NOMINAL",NOT:"NOT",NOW:"NOW",NPER:"NPER",NPV:"NPV",OCT2BIN:"OCT2BIN",OCT2DEC:"OCT2DEC",OCT2HEX:"OCT2HEX",ODD:"ODD",OFFSET:"OFFSET",OR:"OR",PI:"PI",PMT:"PMT",PDURATION:"PDURATION",PRODUCT:"PRODUCT",POWER:"POWER",PPMT:"PPMT",PROPER:"PROPER",PV:"PV",RADIANS:"RADIANS",RAND:"RAND",RATE:"RATE",REPLACE:"REPLACE",REPT:"REPT",RIGHT:"RIGHT",ROMAN:"ROMAN",ROUND:"ROUND",ROUNDDOWN:"ROUNDDOWN",ROUNDUP:"ROUNDUP",ROW:"ROW",ROWS:"ROWS",RRI:"RRI",SEARCH:"SEARCH",SEC:"SEC",SECH:"SECH",SECOND:"SECOND",SHEET:"SHEET",SHEETS:"SHEETS",SIN:"SIN",SINH:"SINH",SLN:"SLN",SPLIT:"SPLIT",SQRT:"SQRT",STDEVA:"STDEVA","STDEV.P":"STDEV.P",STDEVPA:"STDEVPA","STDEV.S":"STDEV.S",SUBSTITUTE:"SUBSTITUTE",SUBTOTAL:"SUBTOTAL",SUM:"SUM",SUMIF:"SUMIF",SUMIFS:"SUMIFS",SUMPRODUCT:"SUMPRODUCT",SUMSQ:"SUMSQ",SWITCH:"SWITCH",SYD:"SYD",T:"T",TAN:"TAN",TANH:"TANH",TBILLEQ:"TBILLEQ",TBILLPRICE:"TBILLPRICE",TBILLYIELD:"TBILLYIELD",TEXT:"TEXT",TIME:"TIME",TIMEVALUE:"TIMEVALUE",TODAY:"TODAY",TRANSPOSE:"TRANSPOSE",TRIM:"TRIM",TRUE:"TRUE",TRUNC:"TRUNC",UNICHAR:"UNICHAR",UNICODE:"UNICODE",UPPER:"UPPER",VARA:"VARA","VAR.P":"VAR.P",VARPA:"VARPA","VAR.S":"VAR.S",VLOOKUP:"VLOOKUP",WEEKDAY:"WEEKDAY",WEEKNUM:"WEEKNUM",WORKDAY:"WORKDAY","WORKDAY.INTL":"WORKDAY.INTL",XNPV:"XNPV",XOR:"XOR",YEAR:"YEAR",YEARFRAC:"YEARFRAC","HF.ADD":"HF.ADD","HF.CONCAT":"HF.CONCAT","HF.DIVIDE":"HF.DIVIDE","HF.EQ":"HF.EQ","HF.GT":"HF.GT","HF.GTE":"HF.GTE","HF.LT":"HF.LT","HF.LTE":"HF.LTE","HF.MINUS":"HF.MINUS","HF.MULTIPLY":"HF.MULTIPLY","HF.NE":"HF.NE","HF.POW":"HF.POW","HF.UMINUS":"HF.UMINUS","HF.UNARY_PERCENT":"HF.UNARY_PERCENT","HF.UPLUS":"HF.UPLUS",VARP:"VARP",VAR:"VAR",STDEVP:"STDEVP",STDEV:"STDEV","EXPON.DIST":"EXPON.DIST",FISHER:"FISHER",FISHERINV:"FISHERINV",GAMMA:"GAMMA","GAMMA.DIST":"GAMMA.DIST",GAMMALN:"GAMMALN","GAMMALN.PRECISE":"GAMMALN.PRECISE","GAMMA.INV":"GAMMA.INV",GAUSS:"GAUSS",FACT:"FACT",FACTDOUBLE:"FACTDOUBLE",COMBIN:"COMBIN",COMBINA:"COMBINA",GCD:"GCD",LCM:"LCM",MROUND:"MROUND",MULTINOMIAL:"MULTINOMIAL",QUOTIENT:"QUOTIENT",RANDBETWEEN:"RANDBETWEEN",SERIESSUM:"SERIESSUM",SIGN:"SIGN",SQRTPI:"SQRTPI",SUMX2MY2:"SUMX2MY2",SUMX2PY2:"SUMX2PY2",SUMXMY2:"SUMXMY2",EXPONDIST:"EXPONDIST",GAMMADIST:"GAMMADIST",GAMMAINV:"GAMMAINV","BETA.DIST":"BETA.DIST",BETADIST:"BETADIST","BETA.INV":"BETA.INV",BETAINV:"BETAINV","BINOM.DIST":"BINOM.DIST",BINOMDIST:"BINOMDIST","BINOM.INV":"BINOM.INV",BESSELI:"BESSELI",BESSELJ:"BESSELJ",BESSELK:"BESSELK",BESSELY:"BESSELY","CHISQ.DIST":"CHISQ.DIST","CHISQ.DIST.RT":"CHISQ.DIST.RT","CHISQ.INV":"CHISQ.INV","CHISQ.INV.RT":"CHISQ.INV.RT",CHIDIST:"CHIDIST",CHIINV:"CHIINV","F.DIST":"F.DIST","F.DIST.RT":"F.DIST.RT","F.INV":"F.INV","F.INV.RT":"F.INV.RT",FDIST:"FDIST",FINV:"FINV",WEIBULL:"WEIBULL","WEIBULL.DIST":"WEIBULL.DIST",POISSON:"POISSON","POISSON.DIST":"POISSON.DIST","HYPGEOM.DIST":"HYPGEOM.DIST",HYPGEOMDIST:"HYPGEOMDIST","T.DIST":"T.DIST","T.DIST.2T":"T.DIST.2T","T.DIST.RT":"T.DIST.RT","T.INV":"T.INV","T.INV.2T":"T.INV.2T",TDIST:"TDIST",TINV:"TINV",LOGINV:"LOGINV","LOGNORM.DIST":"LOGNORM.DIST","LOGNORM.INV":"LOGNORM.INV",LOGNORMDIST:"LOGNORMDIST","NORM.DIST":"NORM.DIST","NORM.INV":"NORM.INV","NORM.S.DIST":"NORM.S.DIST","NORM.S.INV":"NORM.S.INV",NORMDIST:"NORMDIST",NORMINV:"NORMINV",NORMSDIST:"NORMSDIST",NORMSINV:"NORMSINV",PHI:"PHI","NEGBINOM.DIST":"NEGBINOM.DIST",NEGBINOMDIST:"NEGBINOMDIST",COMPLEX:"COMPLEX",IMABS:"IMABS",IMAGINARY:"IMAGINARY",IMARGUMENT:"IMARGUMENT",IMCONJUGATE:"IMCONJUGATE",IMCOS:"IMCOS",IMCOSH:"IMCOSH",IMCOT:"IMCOT",IMCSC:"IMCSC",IMCSCH:"IMCSCH",IMDIV:"IMDIV",IMEXP:"IMEXP",IMLN:"IMLN",IMLOG10:"IMLOG10",IMLOG2:"IMLOG2",IMPOWER:"IMPOWER",IMPRODUCT:"IMPRODUCT",IMREAL:"IMREAL",IMSEC:"IMSEC",IMSECH:"IMSECH",IMSIN:"IMSIN",IMSINH:"IMSINH",IMSQRT:"IMSQRT",IMSUB:"IMSUB",IMSUM:"IMSUM",IMTAN:"IMTAN",LARGE:"LARGE",SMALL:"SMALL",AVEDEV:"AVEDEV",CONFIDENCE:"CONFIDENCE","CONFIDENCE.NORM":"CONFIDENCE.NORM","CONFIDENCE.T":"CONFIDENCE.T",DEVSQ:"DEVSQ",GEOMEAN:"GEOMEAN",HARMEAN:"HARMEAN",CRITBINOM:"CRITBINOM","COVARIANCE.P":"COVARIANCE.P","COVARIANCE.S":"COVARIANCE.S",COVAR:"COVAR",PEARSON:"PEARSON",RSQ:"RSQ",STANDARDIZE:"STANDARDIZE","Z.TEST":"Z.TEST",ZTEST:"ZTEST","F.TEST":"F.TEST",FTEST:"FTEST",STEYX:"STEYX",SLOPE:"SLOPE","CHISQ.TEST":"CHISQ.TEST",CHITEST:"CHITEST","T.TEST":"T.TEST",TTEST:"TTEST",SKEW:"SKEW","SKEW.P":"SKEW.P",WEIBULLDIST:"WEIBULLDIST",VARS:"VARS",TINV2T:"TINV2T",TDISTRT:"TDISTRT",TDIST2T:"TDIST2T",STDEVS:"STDEVS",FINVRT:"FINVRT",FDISTRT:"FDISTRT",CHIDISTRT:"CHIDISTRT",CHIINVRT:"CHIINVRT",COVARIANCEP:"COVARIANCEP",COVARIANCES:"COVARIANCES",LOGNORMINV:"LOGNORMINV",POISSONDIST:"POISSONDIST",SKEWP:"SKEWP","CEILING.MATH":"CEILING.MATH",FLOOR:"FLOOR","FLOOR.MATH":"FLOOR.MATH","CEILING.PRECISE":"CEILING.PRECISE","FLOOR.PRECISE":"FLOOR.PRECISE","ISO.CEILING":"ISO.CEILING"},langCode:"enGB",ui:{NEW_SHEET_PREFIX:"Sheet"}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
var zi;!function(e){e[e.FullyAbsolute=1]="FullyAbsolute",e[e.RowAbsoluteColRelative=2]="RowAbsoluteColRelative",e[e.RowRelativeColAbsolute=3]="RowRelativeColAbsolute",e[e.FullyRelative=4]="FullyRelative"}(zi||(zi={}));class $i extends un{verifyAddressArguments(e,t,r,n){if(n){if(e<1||t<1)return new Tr(ir.VALUE,Z.LessThanOne)}else if(zi.FullyAbsolute==r){if(e<1||t<1)return new Tr(ir.VALUE,Z.LessThanOne)}else if(zi.RowAbsoluteColRelative==r){if(e<1)return new Tr(ir.VALUE,Z.LessThanOne)}else if(zi.RowRelativeColAbsolute==r&&t<1)return new Tr(ir.VALUE,Z.LessThanOne)}address(e,t){return this.runFunction(e.args,t,this.metadata("ADDRESS"),((e,t,r,n,s)=>{const i=this.verifyAddressArguments(e,t,r,n);if(void 0!==i)return i;const o=P(t-1);let a="";null!=s&&(a=`${s}!`);const l=0==t?"C":`C[${t}]`,h=0==e?"R":`R[${e}]`;return zi.FullyRelative==r?n?`${a}${o}${e}`:`${a}${h}${l}`:zi.RowRelativeColAbsolute==r?n?`${a}$${o}${e}`:`${a}${h}C${t}`:zi.RowAbsoluteColRelative==r?n?`${a}${o}$${e}`:`${a}R${e}${l}`:n?`${a}$${o}$${e}`:`${a}R${e}C${t}`}))}}$i.implementedFunctions={ADDRESS:{method:"address",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,optionalArg:!0,defaultValue:1,minValue:1,maxValue:4},{argumentType:hn.BOOLEAN,optionalArg:!0,defaultValue:!0},{argumentType:hn.STRING,optionalArg:!0}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ki extends un{arrayformula(e,t){return this.runFunction(e.args,t,this.metadata("ARRAYFORMULA"),(e=>e))}arrayformulaArraySize(e,t){if(1!==e.args.length)return cn.error();const r=this.metadata("ARRAYFORMULA");return e.args.map((e=>{var n;return this.arraySizeForAst(e,new Br(t.formulaAddress,t.arraysFlag||null!==(n=null==r?void 0:r.arrayFunction)&&void 0!==n&&n))}))[0]}arrayconstrain(e,t){return this.runFunction(e.args,t,this.metadata("ARRAY_CONSTRAIN"),((e,t,r)=>{t=Math.min(t,e.height()),r=Math.min(r,e.width());const n=e.data,s=[];for(let e=0;e<t;e++)s.push(n[e].slice(0,r));return rt.onlyValues(s)}))}arrayconstrainArraySize(e,t){if(3!==e.args.length)return cn.error();const r=this.metadata("ARRAY_CONSTRAIN"),n=e.args.map((e=>{var n;return this.arraySizeForAst(e,new Br(t.formulaAddress,t.arraysFlag||null!==(n=null==r?void 0:r.arrayFunction)&&void 0!==n&&n))}));let{height:s,width:i}=n[0];return e.args[1].type===U.NUMBER&&(s=Math.min(s,e.args[1].value)),e.args[2].type===U.NUMBER&&(i=Math.min(i,e.args[2].value)),s<1||i<1||!Number.isInteger(s)||!Number.isInteger(i)?cn.error():new cn(i,s)}filter(e,t){return this.runFunction(e.args,t,this.metadata("FILTER"),((e,...t)=>{for(const r of t)if(e.width()!==r.width()||e.height()!==r.height())return new Tr(ir.NA,Z.EqualLength);if(e.width()>1&&e.height()>1)return new Tr(ir.NA,Z.WrongDimension);const r=e.data,n=[];for(let s=0;s<e.height();s++){const i=[];for(let n=0;n<e.width();n++){let e=!0;for(const r of t){if(!0!==Kr(r.data[s][n])){e=!1;break}}e&&i.push(r[s][n])}i.length>0&&n.push(i)}return n.length>0?rt.onlyValues(n):new Tr(ir.NA,Z.EmptyRange)}))}filterArraySize(e,t){if(e.args.length<=1)return cn.error();const r=this.metadata("FILTER"),n=e.args.map((e=>{var n;return this.arraySizeForAst(e,new Br(t.formulaAddress,t.arraysFlag||null!==(n=null==r?void 0:r.arrayFunction)&&void 0!==n&&n))})),s=Math.max(...n.map((e=>e.width))),i=Math.max(...n.map((e=>e.height)));return new cn(s,i)}}Ki.implementedFunctions={ARRAYFORMULA:{method:"arrayformula",arraySizeMethod:"arrayformulaArraySize",arrayFunction:!0,parameters:[{argumentType:hn.ANY}]},ARRAY_CONSTRAIN:{method:"arrayconstrain",arraySizeMethod:"arrayconstrainArraySize",parameters:[{argumentType:hn.RANGE},{argumentType:hn.INTEGER,minValue:1},{argumentType:hn.INTEGER,minValue:1}],vectorizationForbidden:!0},FILTER:{method:"filter",arraySizeMethod:"filterArraySize",arrayFunction:!0,parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}],repeatLastArgs:1}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Xi extends un{abs(e,t){return this.runFunction(e.args,t,this.metadata("ABS"),Math.abs)}}Xi.implementedFunctions={ABS:{method:"abs",parameters:[{argumentType:hn.NUMBER}]}};class qi extends un{bitlshift(e,t){return this.runFunction(e.args,t,this.metadata("BITLSHIFT"),Qi)}bitrshift(e,t){return this.runFunction(e.args,t,this.metadata("BITRSHIFT"),Zi)}}function Qi(e,t){return t<0?Zi(e,-t):Ji(e*Math.pow(2,t))}function Zi(e,t){return t<0?Qi(e,-t):Ji(Math.floor(e/Math.pow(2,t)))}function Ji(e){return e>0xffffffffffff?new Tr(ir.NUM,Z.BitshiftLong):e}qi.implementedFunctions={BITLSHIFT:{method:"bitlshift",parameters:[{argumentType:hn.INTEGER,minValue:0},{argumentType:hn.INTEGER,minValue:-53,maxValue:53}]},BITRSHIFT:{method:"bitrshift",parameters:[{argumentType:hn.INTEGER,minValue:0},{argumentType:hn.INTEGER,minValue:-53,maxValue:53}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class eo extends un{bitand(e,t){return this.runFunction(e.args,t,this.metadata("BITAND"),((e,t)=>e&t))}bitor(e,t){return this.runFunction(e.args,t,this.metadata("BITOR"),((e,t)=>e|t))}bitxor(e,t){return this.runFunction(e.args,t,this.metadata("BITXOR"),((e,t)=>e^t))}}eo.implementedFunctions={BITAND:{method:"bitand",parameters:[{argumentType:hn.INTEGER,minValue:0},{argumentType:hn.INTEGER,minValue:0}]},BITOR:{method:"bitor",parameters:[{argumentType:hn.INTEGER,minValue:0},{argumentType:hn.INTEGER,minValue:0}]},BITXOR:{method:"bitxor",parameters:[{argumentType:hn.INTEGER,minValue:0},{argumentType:hn.INTEGER,minValue:0}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class to extends un{literalTrue(e,t){return this.runFunction(e.args,t,this.metadata("TRUE"),(()=>!0))}literalFalse(e,t){return this.runFunction(e.args,t,this.metadata("FALSE"),(()=>!1))}conditionalIf(e,t){return this.runFunction(e.args,t,this.metadata("IF"),((e,t,r)=>e?t:r))}ifs(e,t){return this.runFunction(e.args,t,this.metadata("IFS"),((...e)=>{for(let t=0;t<e.length;t+=2)if(e[t])return e[t+1];return new Tr(ir.NA,Z.NoConditionMet)}))}and(e,t){return this.runFunction(e.args,t,this.metadata("AND"),((...e)=>e.filter((e=>void 0!==e)).every((e=>!!e))))}or(e,t){return this.runFunction(e.args,t,this.metadata("OR"),((...e)=>e.filter((e=>void 0!==e)).some((e=>e))))}not(e,t){return this.runFunction(e.args,t,this.metadata("NOT"),(e=>!e))}xor(e,t){return this.runFunction(e.args,t,this.metadata("XOR"),((...e)=>{let t=0;return e.filter((e=>void 0!==e)).forEach((e=>{e&&t++})),t%2==1}))}switch(e,t){return this.runFunction(e.args,t,this.metadata("SWITCH"),((e,...t)=>{const r=t.length;let n=0;for(;n+1<r;n+=2)if(!(t[n]instanceof Tr)&&this.arithmeticHelper.eq(e,t[n]))return t[n+1];return n<r?t[n]:new Tr(ir.NA,Z.NoDefault)}))}iferror(e,t){return this.runFunction(e.args,t,this.metadata("IFERROR"),((e,t)=>e instanceof Tr?t:e))}ifna(e,t){return this.runFunction(e.args,t,this.metadata("IFNA"),((e,t)=>e instanceof Tr&&e.type===ir.NA?t:e))}choose(e,t){return this.runFunction(e.args,t,this.metadata("CHOOSE"),((e,...t)=>e>t.length?new Tr(ir.NUM,Z.Selector):t[e-1]))}}to.implementedFunctions={TRUE:{method:"literalTrue",parameters:[]},FALSE:{method:"literalFalse",parameters:[]},IF:{method:"conditionalIf",parameters:[{argumentType:hn.BOOLEAN},{argumentType:hn.SCALAR,passSubtype:!0},{argumentType:hn.SCALAR,defaultValue:!1,passSubtype:!0}]},IFS:{method:"ifs",parameters:[{argumentType:hn.BOOLEAN},{argumentType:hn.SCALAR,passSubtype:!0}],repeatLastArgs:2},AND:{method:"and",parameters:[{argumentType:hn.BOOLEAN}],repeatLastArgs:1,expandRanges:!0},OR:{method:"or",parameters:[{argumentType:hn.BOOLEAN}],repeatLastArgs:1,expandRanges:!0},XOR:{method:"xor",parameters:[{argumentType:hn.BOOLEAN}],repeatLastArgs:1,expandRanges:!0},NOT:{method:"not",parameters:[{argumentType:hn.BOOLEAN}]},SWITCH:{method:"switch",parameters:[{argumentType:hn.NOERROR},{argumentType:hn.SCALAR,passSubtype:!0},{argumentType:hn.SCALAR,passSubtype:!0}],repeatLastArgs:1},IFERROR:{method:"iferror",parameters:[{argumentType:hn.SCALAR,passSubtype:!0},{argumentType:hn.SCALAR,passSubtype:!0}]},IFNA:{method:"ifna",parameters:[{argumentType:hn.SCALAR,passSubtype:!0},{argumentType:hn.SCALAR,passSubtype:!0}]},CHOOSE:{method:"choose",parameters:[{argumentType:hn.INTEGER,minValue:1},{argumentType:hn.SCALAR,passSubtype:!0}],repeatLastArgs:1}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ro extends un{char(e,t){return this.runFunction(e.args,t,this.metadata("CHAR"),(e=>e<1||e>=256?new Tr(ir.VALUE,Z.CharacterCodeBounds):String.fromCharCode(Math.trunc(e))))}unichar(e,t){return this.runFunction(e.args,t,this.metadata("CHAR"),(e=>e<1||e>=1114112?new Tr(ir.VALUE,Z.CharacterCodeBounds):String.fromCodePoint(Math.trunc(e))))}}ro.implementedFunctions={CHAR:{method:"char",parameters:[{argumentType:hn.NUMBER}]},UNICHAR:{method:"unichar",parameters:[{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class no extends un{code(e,t){return this.runFunction(e.args,t,this.metadata("CODE"),(e=>0===e.length?new Tr(ir.VALUE,Z.EmptyString):e.charCodeAt(0)))}unicode(e,t){return this.runFunction(e.args,t,this.metadata("UNICODE"),(e=>{var t;return null!==(t=e.codePointAt(0))&&void 0!==t?t:new Tr(ir.VALUE,Z.EmptyString)}))}}no.implementedFunctions={CODE:{method:"code",parameters:[{argumentType:hn.STRING}]},UNICODE:{method:"unicode",parameters:[{argumentType:hn.STRING}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class so extends un{countblank(e,t){return this.runFunction(e.args,t,this.metadata("COUNTBLANK"),((...e)=>{let t=0;return e.forEach((e=>{e===Ye&&t++})),t}))}}so.implementedFunctions={COUNTBLANK:{method:"countblank",parameters:[{argumentType:hn.SCALAR}],repeatLastArgs:1,expandRanges:!0}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class io extends un{countunique(e,t){return this.runFunction(e.args,t,this.metadata("COUNTUNIQUE"),((...e)=>{const t=new Set,r=new Set;for(const n of e)n instanceof Tr?r.add(n.type):""!==n&&t.add(n);return t.size+r.size}))}}io.implementedFunctions={COUNTUNIQUE:{method:"countunique",parameters:[{argumentType:hn.SCALAR}],repeatLastArgs:1,expandRanges:!0}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class oo extends un{constructor(){super(...arguments),this.isoweeknumCore=e=>{const t=Math.floor(this.dateTimeHelper.relativeNumberToAbsoluteNumber(e)),r=this.dateTimeHelper.numberToSimpleDate(e),n=this.dateTimeHelper.dateToNumber({year:r.year,month:1,day:1}),s=this.dateTimeHelper.relativeNumberToAbsoluteNumber(n),i=s+((4-s)%7+7)%7,o=Math.floor((t-1)/7)-Math.floor((i-1)/7)+1;return 0===o?this.isoweeknumCore(e-7)+1:o},this.days360Core=(e,t,r)=>{const n=this.dateTimeHelper.numberToSimpleDate(e),s=this.dateTimeHelper.numberToSimpleDate(t);let i,o;return r?(i=Fn(n),o=Fn(s)):[i,o]=this.dateTimeHelper.toBasisUS(n,s),360*(o.year-i.year)+30*(o.month-i.month)+o.day-i.day}}date(e,t){return this.runFunction(e.args,t,this.metadata("DATE"),((e,t,r)=>{const n=Math.trunc(r);let s=Math.trunc(t),i=Math.trunc(e);i<this.dateTimeHelper.getEpochYearZero()&&(i+=this.dateTimeHelper.getEpochYearZero());const o=Math.floor((s-1)/12);i+=o,s-=12*o;const a={year:i,month:s,day:1};if(this.dateTimeHelper.isValidDate(a)){let e=this.dateTimeHelper.dateToNumber(a)+(n-1);return e=this.dateTimeHelper.getWithinBounds(e),void 0===e?new Tr(ir.NUM,Z.DateBounds):e}return new Tr(ir.VALUE,Z.InvalidDate)}))}time(e,t){return this.runFunction(e.args,t,this.metadata("TIME"),((e,t,r)=>{const n=Hn({hours:Math.trunc(e),minutes:Math.trunc(t),seconds:Math.trunc(r)});return n<0?new Tr(ir.NUM,Z.NegativeTime):n%1}))}eomonth(e,t){return this.runFunction(e.args,t,this.metadata("EOMONTH"),((e,t)=>{const r=this.dateTimeHelper.numberToSimpleDate(e);let n=this.dateTimeHelper.dateToNumber(this.dateTimeHelper.endOfMonth(Ln(r,t)));return n=this.dateTimeHelper.getWithinBounds(n),void 0===n?new Tr(ir.NUM,Z.DateBounds):n}))}day(e,t){return this.runFunction(e.args,t,this.metadata("DAY"),(e=>this.dateTimeHelper.numberToSimpleDate(e).day))}days(e,t){return this.runFunction(e.args,t,this.metadata("DAYS"),((e,t)=>Math.trunc(e)-Math.trunc(t)))}month(e,t){return this.runFunction(e.args,t,this.metadata("MONTH"),(e=>this.dateTimeHelper.numberToSimpleDate(e).month))}year(e,t){return this.runFunction(e.args,t,this.metadata("YEAR"),(e=>this.dateTimeHelper.numberToSimpleDate(e).year))}hour(e,t){return this.runFunction(e.args,t,this.metadata("HOUR"),(e=>kn(Dn(e)%1).hours))}minute(e,t){return this.runFunction(e.args,t,this.metadata("MINUTE"),(e=>kn(Dn(e)%1).minutes))}second(e,t){return this.runFunction(e.args,t,this.metadata("SECOND"),(e=>kn(Dn(e)%1).seconds))}text(e,t){return this.runFunction(e.args,t,this.metadata("TEXT"),((e,t)=>Kn(e,t,this.config,this.dateTimeHelper)))}weekday(e,t){return this.runFunction(e.args,t,this.metadata("WEEKDAY"),((e,t)=>{const r=Math.floor(this.dateTimeHelper.relativeNumberToAbsoluteNumber(e));if(3===t)return(r-1)%7;const n=ho.get(t);return void 0===n?new Tr(ir.NUM,Z.BadMode):(r-n)%7+1}))}weeknum(e,t){return this.runFunction(e.args,t,this.metadata("WEEKNUM"),((e,t)=>{const r=Math.floor(this.dateTimeHelper.relativeNumberToAbsoluteNumber(e)),n=this.dateTimeHelper.numberToSimpleDate(e),s=this.dateTimeHelper.dateToNumber({year:n.year,month:1,day:1}),i=this.dateTimeHelper.relativeNumberToAbsoluteNumber(s);if(21===t)return this.isoweeknumCore(e);const o=ho.get(t);return void 0===o?new Tr(ir.NUM,Z.BadMode):Math.floor((r-o)/7)-Math.floor((i-o)/7)+1}))}isoweeknum(e,t){return this.runFunction(e.args,t,this.metadata("ISOWEEKNUM"),this.isoweeknumCore)}datevalue(e,t){return this.runFunction(e.args,t,this.metadata("DATEVALUE"),(e=>{const{dateTime:t}=this.dateTimeHelper.parseDateTimeFromConfigFormats(e);return void 0===t?new Tr(ir.VALUE,Z.IncorrectDateTime):On(t)?(In(t)?Math.trunc(Hn(t)):0)+this.dateTimeHelper.dateToNumber(t):0}))}timevalue(e,t){return this.runFunction(e.args,t,this.metadata("TIMEVALUE"),(e=>{const t=this.dateTimeHelper.dateStringToDateNumber(e);return void 0===t?new Tr(ir.VALUE,Z.IncorrectDateTime):Ge(t)%1}))}now(e,t){return this.runFunction(e.args,t,this.metadata("NOW"),(()=>{const e=new Date(Date.now());return Hn({hours:e.getHours(),minutes:e.getMinutes(),seconds:e.getSeconds()})+this.dateTimeHelper.dateToNumber({year:e.getFullYear(),month:e.getMonth()+1,day:e.getDate()})}))}today(e,t){return this.runFunction(e.args,t,this.metadata("TODAY"),(()=>{const e=new Date(Date.now());return this.dateTimeHelper.dateToNumber({year:e.getFullYear(),month:e.getMonth()+1,day:e.getDate()})}))}edate(e,t){return this.runFunction(e.args,t,this.metadata("EDATE"),((e,t)=>{const r=function(e){return{year:e.year,month:e.month,day:Math.min(e.day,bn[e.month-1])}}(Ln(this.dateTimeHelper.numberToSimpleDate(e),t));let n=this.dateTimeHelper.dateToNumber(r);return n=this.dateTimeHelper.getWithinBounds(n),void 0===n?new Tr(ir.NUM,Z.DateBounds):n}))}datedif(e,t){return this.runFunction(e.args,t,this.metadata("DATEDIF"),((e,t,r)=>{if(e>t)return new Tr(ir.NUM,Z.StartEndDate);if("D"===r)return Math.floor(t)-Math.floor(e);const n=this.dateTimeHelper.numberToSimpleDate(e),s=this.dateTimeHelper.numberToSimpleDate(t);switch(r){case"M":return 12*(s.year-n.year)+(s.month-n.month)-(s.day<n.day?1:0);case"YM":return(s.month-n.month+12-(s.day<n.day?1:0))%12;case"Y":return s.month>n.month||s.month===n.month&&s.day>=n.day?s.year-n.year:s.year-n.year-1;case"MD":if(s.day>=n.day)return s.day-n.day;{const e=1===s.month?12:s.month-1,t=1===s.month?s.year-1:s.year;return this.dateTimeHelper.daysInMonth(t,e)+s.day-n.day}case"YD":return s.month>n.month||s.month===n.month&&s.day>=n.day?Math.floor(t)-this.dateTimeHelper.dateToNumber({year:s.year,month:n.month,day:n.day}):Math.floor(t)-Math.floor(e)-365*(s.year-n.year-1)-this.dateTimeHelper.leapYearsCount(s.year-1)+this.dateTimeHelper.leapYearsCount(n.year);default:return new Tr(ir.NUM,Z.BadMode)}}))}days360(e,t){return this.runFunction(e.args,t,this.metadata("DAYS360"),this.days360Core)}yearfrac(e,t){return this.runFunction(e.args,t,this.metadata("YEARFRAC"),((e,t,r)=>{switch((e=Math.trunc(e))>(t=Math.trunc(t))&&([e,t]=[t,e]),r){case 0:return this.days360Core(e,t,!1)/360;case 1:return(t-e)/this.dateTimeHelper.yearLengthForBasis(this.dateTimeHelper.numberToSimpleDate(e),this.dateTimeHelper.numberToSimpleDate(t));case 2:return(t-e)/360;case 3:return(t-e)/365;case 4:return this.days360Core(e,t,!0)/360}throw new Error("Should not be reachable.")}))}interval(e,t){return this.runFunction(e.args,t,this.metadata("INTERVAL"),(e=>{const t=(e=Math.trunc(e))%60,r=(e=Math.trunc(e/60))%60,n=(e=Math.trunc(e/60))%24,s=(e=Math.trunc(e/24))%30,i=(e=Math.trunc(e/30))%12,o=Math.trunc(e/12);return"P"+(o>0?`${o}Y`:"")+(i>0?`${i}M`:"")+(s>0?`${s}D`:"")+"T"+(n>0?`${n}H`:"")+(r>0?`${r}M`:"")+(t>0?`${t}S`:"")}))}networkdays(e,t){return this.runFunction(e.args,t,this.metadata("NETWORKDAYS"),((e,t,r)=>this.networkdayscore(e,t,1,r)))}networkdaysintl(e,t){return this.runFunction(e.args,t,this.metadata("NETWORKDAYS.INTL"),((e,t,r,n)=>this.networkdayscore(e,t,r,n)))}workday(e,t){return this.runFunction(e.args,t,this.metadata("WORKDAY"),((e,t,r)=>this.workdaycore(e,t,1,r)))}workdayintl(e,t){return this.runFunction(e.args,t,this.metadata("WORKDAY.INTL"),((e,t,r,n)=>this.workdaycore(e,t,r,n)))}networkdayscore(e,t,r,n){let s=1;(e=Math.trunc(e))>(t=Math.trunc(t))&&([e,t]=[t,e],s=-1);const i=lo(r);if(i instanceof Tr)return i;const o=this.simpleRangeToFilteredHolidays(i,n);return o instanceof Tr?o:s*this.countWorkdays(e,t,i,o)}workdaycore(e,t,r,n){e=Math.trunc(e),t=Math.trunc(t);const s=lo(r);if(s instanceof Tr)return s;const i=this.simpleRangeToFilteredHolidays(s,n);if(i instanceof Tr)return i;if(t>0){let r=1;for(;this.countWorkdays(e+1,e+r,s,i)<t;)r*=2;let n=1;for(;n+1<r;){const o=Math.trunc((n+r)/2);this.countWorkdays(e+1,e+o,s,i)<t?n=o:r=o}return e+r}if(t<0){t*=-1;let r=1;for(;this.countWorkdays(e-r,e-1,s,i)<t;)r*=2;let n=1;for(;n+1<r;){const o=Math.trunc((n+r)/2);this.countWorkdays(e-o,e-1,s,i)<t?n=o:r=o}return e-r}return e}countWorkdays(e,t,r,n){const s=Math.floor(this.dateTimeHelper.relativeNumberToAbsoluteNumber(t)),i=Math.floor(this.dateTimeHelper.relativeNumberToAbsoluteNumber(e));let o=0;for(let e=0;e<7;e++)"0"===r.charAt(e)&&(o+=Math.floor((s+6-e)/7),o-=Math.floor((i-1+6-e)/7));return o-=ao(t+1,n)-ao(e,n),o}simpleRangeToFilteredHolidays(e,t){var r;const n=null!==(r=null==t?void 0:t.valuesFromTopLeftCorner())&&void 0!==r?r:[];for(const e of n)if(e instanceof Tr)return e;const s=[];for(const e of n)if(e!==Ye){if(!Ze(e))return new Tr(ir.VALUE,Z.WrongType);s.push(Math.trunc(Ge(e)))}return[...new Set(s)].sort(((e,t)=>e-t)).filter((t=>{const r=(this.dateTimeHelper.relativeNumberToAbsoluteNumber(t)-1)%7;return"0"===e.charAt(r)}))}}function ao(e,t){if(0===t.length)return 0;if(e<=t[0])return 0;if(t[t.length-1]<e)return t.length;let r=0,n=t.length-1;for(;r+1<n;){const s=Math.floor((n+r)/2);t[s]>=e?n=s:r=s}return n}function lo(e){var t;return"number"!=typeof e&&"string"!=typeof e?new Tr(ir.VALUE,Z.WrongType):"string"==typeof e?7===e.length&&/^(0|1)*$/.test(e)&&"1111111"!==e?e:new Tr(ir.NUM,Z.WeekendString):null!==(t=uo.get(e))&&void 0!==t?t:new Tr(ir.NUM,Z.BadMode)}oo.implementedFunctions={DATE:{method:"date",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}],returnNumberType:Je.NUMBER_DATE},TIME:{method:"time",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}],returnNumberType:Je.NUMBER_TIME},MONTH:{method:"month",parameters:[{argumentType:hn.NUMBER,minValue:0}]},YEAR:{method:"year",parameters:[{argumentType:hn.NUMBER,minValue:0}]},HOUR:{method:"hour",parameters:[{argumentType:hn.NUMBER,minValue:0}]},MINUTE:{method:"minute",parameters:[{argumentType:hn.NUMBER,minValue:0}]},SECOND:{method:"second",parameters:[{argumentType:hn.NUMBER,minValue:0}]},TEXT:{method:"text",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.STRING}]},EOMONTH:{method:"eomonth",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER}],returnNumberType:Je.NUMBER_DATE},DAY:{method:"day",parameters:[{argumentType:hn.NUMBER,minValue:0}]},DAYS:{method:"days",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0}]},WEEKDAY:{method:"weekday",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,defaultValue:1}]},WEEKNUM:{method:"weeknum",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,defaultValue:1}]},ISOWEEKNUM:{method:"isoweeknum",parameters:[{argumentType:hn.NUMBER,minValue:0}]},DATEVALUE:{method:"datevalue",parameters:[{argumentType:hn.STRING}],returnNumberType:Je.NUMBER_DATE},TIMEVALUE:{method:"timevalue",parameters:[{argumentType:hn.STRING}],returnNumberType:Je.NUMBER_TIME},NOW:{method:"now",parameters:[],isVolatile:!0,returnNumberType:Je.NUMBER_DATETIME},TODAY:{method:"today",parameters:[],isVolatile:!0,returnNumberType:Je.NUMBER_DATE},EDATE:{method:"edate",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER}],returnNumberType:Je.NUMBER_DATE},DAYS360:{method:"days360",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.BOOLEAN,defaultValue:!1}]},DATEDIF:{method:"datedif",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.STRING}]},YEARFRAC:{method:"yearfrac",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.INTEGER,defaultValue:0,minValue:0,maxValue:4}]},INTERVAL:{method:"interval",parameters:[{argumentType:hn.NUMBER,minValue:0}]},NETWORKDAYS:{method:"networkdays",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.RANGE,optionalArg:!0}]},"NETWORKDAYS.INTL":{method:"networkdaysintl",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NOERROR,defaultValue:1},{argumentType:hn.RANGE,optionalArg:!0}]},WORKDAY:{method:"workday",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER},{argumentType:hn.RANGE,optionalArg:!0}]},"WORKDAY.INTL":{method:"workdayintl",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER},{argumentType:hn.NOERROR,defaultValue:1},{argumentType:hn.RANGE,optionalArg:!0}]}};const ho=new Map([[1,0],[2,1],[11,1],[12,2],[13,3],[14,4],[15,5],[16,6],[17,0]]),uo=new Map([[1,"0000011"],[2,"1000001"],[3,"1100000"],[4,"0110000"],[5,"0011000"],[6,"0001100"],[7,"0000110"],[11,"0000001"],[12,"1000000"],[13,"0100000"],[14,"0010000"],[15,"0001000"],[16,"0000100"],[17,"0000010"]]);
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class co extends un{degrees(e,t){return this.runFunction(e.args,t,this.metadata("DEGREES"),(e=>e*(180/Math.PI)))}}co.implementedFunctions={DEGREES:{method:"degrees",parameters:[{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class po extends un{delta(e,t){return this.runFunction(e.args,t,this.metadata("DELTA"),((e,t)=>e===t?1:0))}}po.implementedFunctions={DELTA:{method:"delta",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class go extends un{exp(e,t){return this.runFunction(e.args,t,this.metadata("EXP"),Math.exp)}}go.implementedFunctions={EXP:{method:"exp",parameters:[{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class fo extends un{pmt(e,t){return this.runFunction(e.args,t,this.metadata("PMT"),mo)}ipmt(e,t){return this.runFunction(e.args,t,this.metadata("IPMT"),yo)}ppmt(e,t){return this.runFunction(e.args,t,this.metadata("PPMT"),wo)}fv(e,t){return this.runFunction(e.args,t,this.metadata("FV"),Eo)}cumipmt(e,t){return this.runFunction(e.args,t,this.metadata("CUMIPMT"),((e,t,r,n,s,i)=>{if(n>s)return new Tr(ir.NUM,Z.EndStartPeriod);let o=0;for(let a=n;a<=s;a++)o+=yo(e,a,t,r,0,i);return o}))}cumprinc(e,t){return this.runFunction(e.args,t,this.metadata("CUMPRINC"),((e,t,r,n,s,i)=>{if(n>s)return new Tr(ir.NUM,Z.EndStartPeriod);let o=0;for(let a=n;a<=s;a++)o+=wo(e,a,t,r,0,i);return o}))}db(e,t){return this.runFunction(e.args,t,this.metadata("DB"),((e,t,r,n,s)=>{if(12===s&&n>r||n>r+1)return new Tr(ir.NUM,Z.PeriodLong);if(t>=e)return 0;const i=Math.round(1e3*(1-Math.pow(t/e,1/r)))/1e3,o=e*i*s/12;if(1===n)return o;let a=o;for(let t=0;t<n-2;t++)a+=(e-a)*i;return n===r+1?(e-a)*i*(12-s)/12:(e-a)*i}))}ddb(e,t){return this.runFunction(e.args,t,this.metadata("DDB"),((e,t,r,n,s)=>{if(n>r)return new Tr(ir.NUM);let i,o=s/r;o>=1?(o=1,i=1===n?e:0):i=e*Math.pow(1-o,n-1);const a=e*Math.pow(1-o,n);return Math.max(i-Math.max(t,a),0)}))}dollarde(e,t){return this.runFunction(e.args,t,this.metadata("DOLLARDE"),((e,t)=>{if(t<1)return new Tr(ir.DIV_BY_ZERO);for(t=Math.trunc(t);t>10;)t/=10;return Math.trunc(e)+10*(e-Math.trunc(e))/t}))}dollarfr(e,t){return this.runFunction(e.args,t,this.metadata("DOLLARFR"),((e,t)=>{if(t<1)return new Tr(ir.DIV_BY_ZERO);for(t=Math.trunc(t);t>10;)t/=10;return Math.trunc(e)+(e-Math.trunc(e))*t/10}))}effect(e,t){return this.runFunction(e.args,t,this.metadata("EFFECT"),((e,t)=>(t=Math.trunc(t),Math.pow(1+e/t,t)-1)))}ispmt(e,t){return this.runFunction(e.args,t,this.metadata("ISPMT"),((e,t,r,n)=>0===r?new Tr(ir.DIV_BY_ZERO):n*e*(t/r-1)))}nominal(e,t){return this.runFunction(e.args,t,this.metadata("NOMINAL"),((e,t)=>(t=Math.trunc(t),(Math.pow(e+1,1/t)-1)*t)))}nper(e,t){return this.runFunction(e.args,t,this.metadata("NPER"),((e,t,r,n,s)=>0===e?0===t?new Tr(ir.DIV_BY_ZERO):(-r-n)/t:(s&&(t*=1+e),Math.log((t-n*e)/(r*e+t))/Math.log(1+e))))}rate(e,t){return this.runFunction(e.args,t,this.metadata("RATE"),((e,t,r,n,s,i)=>{if(i<=-1)return new Tr(ir.VALUE);const o=1e-7;let a=i;s=s?1:0;for(let i=0;i<50;i++){if(a<=-1)return new Tr(ir.NUM);let i,l;if(Math.abs(a)<o)i=r*(1+e*a)+t*(1+a*s)*e+n;else{const o=Math.pow(1+a,e);i=r*o+t*(1/a+s)*(o-1)+n}if(Math.abs(i)<o)return a;if(Math.abs(a)<o)l=r*e+t*s*e;else{const n=Math.pow(1+a,e),i=e*Math.pow(1+a,e-1);l=r*i+t*(1/a+s)*i+t*(-1/(a*a))*(n-1)}a-=i/l}return new Tr(ir.NUM)}))}pv(e,t){return this.runFunction(e.args,t,this.metadata("PV"),((e,t,r,n,s)=>(s=s?1:0,-1===e?new Tr(0===t?ir.NUM:ir.DIV_BY_ZERO):0===e?-r*t-n:((1-Math.pow(1+e,t))*r*(1+e*s)/e-n)/Math.pow(1+e,t))))}rri(e,t){return this.runFunction(e.args,t,this.metadata("RRI"),((e,t,r)=>0===t||r<0&&t>0||r>0&&t<0?new Tr(ir.NUM):Math.pow(r/t,1/e)-1))}sln(e,t){return this.runFunction(e.args,t,this.metadata("SLN"),((e,t,r)=>0===r?new Tr(ir.DIV_BY_ZERO):(e-t)/r))}syd(e,t){return this.runFunction(e.args,t,this.metadata("SYD"),((e,t,r,n)=>n>r?new Tr(ir.NUM):(e-t)*(r-n+1)*2/(r*(r+1))))}tbilleq(e,t){return this.runFunction(e.args,t,this.metadata("TBILLEQ"),((e,t,r)=>{if((e=Math.round(e))>=(t=Math.round(t)))return new Tr(ir.NUM);const n=this.dateTimeHelper.numberToSimpleDate(e),s=this.dateTimeHelper.numberToSimpleDate(t);if(s.year>n.year+1||s.year===n.year+1&&(s.month>n.month||s.month===n.month&&s.day>n.day))return new Tr(ir.NUM);const i=360-r*(t-e);return 0===i?0:i<0?new Tr(ir.NUM):365*r/i}))}tbillprice(e,t){return this.runFunction(e.args,t,this.metadata("TBILLPRICE"),((e,t,r)=>{if((e=Math.round(e))>=(t=Math.round(t)))return new Tr(ir.NUM);const n=this.dateTimeHelper.numberToSimpleDate(e),s=this.dateTimeHelper.numberToSimpleDate(t);if(s.year>n.year+1||s.year===n.year+1&&(s.month>n.month||s.month===n.month&&s.day>n.day))return new Tr(ir.NUM);const i=360-r*(t-e);return 0===i?0:i<0?new Tr(ir.NUM):100*(1-r*(t-e)/360)}))}tbillyield(e,t){return this.runFunction(e.args,t,this.metadata("TBILLYIELD"),((e,t,r)=>{if((e=Math.round(e))>=(t=Math.round(t)))return new Tr(ir.NUM);const n=this.dateTimeHelper.numberToSimpleDate(e),s=this.dateTimeHelper.numberToSimpleDate(t);return s.year>n.year+1||s.year===n.year+1&&(s.month>n.month||s.month===n.month&&s.day>n.day)?new Tr(ir.NUM):360*(100-r)/(r*(t-e))}))}fvschedule(e,t){return this.runFunction(e.args,t,this.metadata("FVSCHEDULE"),((e,t)=>{const r=t.valuesFromTopLeftCorner();for(const e of r)if(e instanceof Tr)return e;for(const t of r)if(Ze(t))e*=1+Ge(t);else if(t!==Ye)return new Tr(ir.VALUE,Z.NumberExpected);return e}))}npv(e,t){return this.runFunction(e.args,t,this.metadata("NPV"),((e,...t)=>{const r=this.arithmeticHelper.coerceNumbersExactRanges(t);return r instanceof Tr?r:Co(e,r)}))}mirr(e,t){return this.runFunction(e.args,t,this.metadata("MIRR"),((e,t,r)=>{const n=this.arithmeticHelper.manyToExactNumbers(e.valuesFromTopLeftCorner());if(n instanceof Tr)return n;let s=!1,i=!1;const o=[],a=[];for(const e of n)e>0?(s=!0,o.push(e),a.push(0)):e<0?(i=!0,a.push(e),o.push(0)):(a.push(0),o.push(0));if(!s||!i)return new Tr(ir.DIV_BY_ZERO);const l=n.length,h=Co(r,o);if(h instanceof Tr)return h;const u=Co(t,a);return u instanceof Tr?u:Math.pow(-h*Math.pow(1+r,l)/u/(1+t),1/(l-1))-1}))}pduration(e,t){return this.runFunction(e.args,t,this.metadata("PDURATION"),((e,t,r)=>(Math.log(r)-Math.log(t))/Math.log(1+e)))}xnpv(e,t){return this.runFunction(e.args,t,this.metadata("XNPV"),((e,t,r)=>{const n=t.valuesFromTopLeftCorner();for(const e of n)if("number"!=typeof e)return new Tr(ir.VALUE,Z.NumberExpected);const s=n,i=r.valuesFromTopLeftCorner();for(const e of i)if("number"!=typeof e)return new Tr(ir.VALUE,Z.NumberExpected);const o=i;if(o.length!==s.length)return new Tr(ir.NUM,Z.EqualLength);const a=o.length;let l=0;if(o[0]<0)return new Tr(ir.NUM,Z.ValueSmall);for(let t=0;t<a;t++){if(o[t]=Math.floor(o[t]),o[t]<o[0])return new Tr(ir.NUM,Z.ValueSmall);l+=s[t]/Math.pow(1+e,(o[t]-o[0])/365)}return l}))}}function mo(e,t,r,n,s){if(0===e)return(-r-n)/t;{const i=Math.pow(1+e,t);return(n*e+r*e*i)*(s?1/(1+e):1)/(1-i)}}function yo(e,t,r,n,s,i){const o=mo(e,r,n,s,i);return 1===t?e*(i?0:-n):e*(i?Eo(e,t-2,o,n,i)-o:Eo(e,t-1,o,n,i))}function Eo(e,t,r,n,s){if(0===e)return-n-r*t;{const i=Math.pow(1+e,t);return r*(s?1+e:1)*(1-i)/e-n*i}}function wo(e,t,r,n,s,i){return mo(e,r,n,s,i)-yo(e,t,r,n,s,i)}function Co(e,t){let r=0;for(let n=t.length-1;n>=0;n--){if(r+=t[n],-1===e){if(0===r)continue;return new Tr(ir.DIV_BY_ZERO)}r/=1+e}return r}fo.implementedFunctions={PMT:{method:"pmt",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:0}],returnNumberType:Je.NUMBER_CURRENCY},IPMT:{method:"ipmt",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:0}],returnNumberType:Je.NUMBER_CURRENCY},PPMT:{method:"ppmt",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:0}],returnNumberType:Je.NUMBER_CURRENCY},FV:{method:"fv",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:0}],returnNumberType:Je.NUMBER_CURRENCY},CUMIPMT:{method:"cumipmt",parameters:[{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.INTEGER,minValue:1},{argumentType:hn.INTEGER,minValue:1},{argumentType:hn.INTEGER,minValue:0,maxValue:1}],returnNumberType:Je.NUMBER_CURRENCY},CUMPRINC:{method:"cumprinc",parameters:[{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.INTEGER,minValue:1},{argumentType:hn.INTEGER,minValue:1},{argumentType:hn.INTEGER,minValue:0,maxValue:1}],returnNumberType:Je.NUMBER_CURRENCY},DB:{method:"db",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.INTEGER,minValue:0},{argumentType:hn.INTEGER,minValue:0},{argumentType:hn.INTEGER,minValue:1,maxValue:12,defaultValue:12}],returnNumberType:Je.NUMBER_CURRENCY},DDB:{method:"ddb",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.INTEGER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,greaterThan:0,defaultValue:2}],returnNumberType:Je.NUMBER_CURRENCY},DOLLARDE:{method:"dollarde",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:0}]},DOLLARFR:{method:"dollarfr",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:0}]},EFFECT:{method:"effect",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:1}],returnNumberType:Je.NUMBER_PERCENT},ISPMT:{method:"ispmt",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]},NOMINAL:{method:"nominal",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:1}],returnNumberType:Je.NUMBER_PERCENT},NPER:{method:"nper",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:0}]},PV:{method:"pv",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:0}],returnNumberType:Je.NUMBER_CURRENCY},RATE:{method:"rate",parameters:[{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:.1}],returnNumberType:Je.NUMBER_PERCENT},RRI:{method:"rri",parameters:[{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}],returnNumberType:Je.NUMBER_PERCENT},SLN:{method:"sln",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}],returnNumberType:Je.NUMBER_CURRENCY},SYD:{method:"syd",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0}],returnNumberType:Je.NUMBER_CURRENCY},TBILLEQ:{method:"tbilleq",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,greaterThan:0}],returnNumberType:Je.NUMBER_PERCENT},TBILLPRICE:{method:"tbillprice",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,greaterThan:0}],returnNumberType:Je.NUMBER_CURRENCY},TBILLYIELD:{method:"tbillyield",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,greaterThan:0}],returnNumberType:Je.NUMBER_PERCENT},FVSCHEDULE:{method:"fvschedule",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.RANGE}],returnNumberType:Je.NUMBER_CURRENCY},NPV:{method:"npv",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.ANY}],repeatLastArgs:1,returnNumberType:Je.NUMBER_CURRENCY},MIRR:{method:"mirr",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}],returnNumberType:Je.NUMBER_PERCENT},PDURATION:{method:"pduration",parameters:[{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0}]},XNPV:{method:"xnpv",parameters:[{argumentType:hn.NUMBER,greaterThan:-1},{argumentType:hn.RANGE},{argumentType:hn.RANGE}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class vo extends un{formulatext(e,t){return this.runFunctionWithReferenceArgument(e.args,t,this.metadata("FORMULATEXT"),(()=>new Tr(ir.NA,Z.WrongArgNumber)),(e=>{var t;return null!==(t=this.serialization.getCellFormula(e))&&void 0!==t?t:new Tr(ir.NA,Z.Formula)}))}}vo.implementedFunctions={FORMULATEXT:{method:"formulatext",parameters:[{argumentType:hn.NOERROR}],doesNotNeedArgumentsToBeComputed:!0,isDependentOnSheetStructureChange:!0,vectorizationForbidden:!0}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Ro extends un{hyperlink(e,t){return this.runFunction(e.args,t,this.metadata("HYPERLINK"),((t,r)=>(e.hyperlink=t,null!=r?r:t)))}}Ro.implementedFunctions={HYPERLINK:{method:"hyperlink",parameters:[{argumentType:hn.STRING},{argumentType:hn.STRING,optionalArg:!0}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class So extends un{isbinary(e,t){return this.runFunction(e.args,t,this.metadata("ISBINARY"),(e=>/^[01]{1,10}$/.test(e)))}iserr(e,t){return this.runFunction(e.args,t,this.metadata("ISERR"),(e=>e instanceof Tr&&e.type!==ir.NA))}iserror(e,t){return this.runFunction(e.args,t,this.metadata("ISERROR"),(e=>e instanceof Tr))}isformula(e,t){return this.runFunctionWithReferenceArgument(e.args,t,this.metadata("ISFORMULA"),(()=>new Tr(ir.NA,Z.WrongArgNumber)),(e=>this.dependencyGraph.addressMapping.getCell(e)instanceof jt))}isblank(e,t){return this.runFunction(e.args,t,this.metadata("ISBLANK"),(e=>e===Ye))}isna(e,t){return this.runFunction(e.args,t,this.metadata("ISNA"),(e=>e instanceof Tr&&e.type==ir.NA))}isnumber(e,t){return this.runFunction(e.args,t,this.metadata("ISNUMBER"),Ze)}islogical(e,t){return this.runFunction(e.args,t,this.metadata("ISLOGICAL"),(e=>"boolean"==typeof e))}isref(e,t){return this.runFunction(e.args,t,this.metadata("ISREF"),(e=>e instanceof Tr&&(e.type==ir.REF||e.type==ir.CYCLE)))}istext(e,t){return this.runFunction(e.args,t,this.metadata("ISTEXT"),(e=>"string"==typeof e))}isnontext(e,t){return this.runFunction(e.args,t,this.metadata("ISNONTEXT"),(e=>!("string"==typeof e)))}column(e,t){return this.runFunctionWithReferenceArgument(e.args,t,this.metadata("COLUMN"),(()=>t.formulaAddress.col+1),(e=>e.col+1))}columns(e,t){if(1!==e.args.length)return new Tr(ir.NA,Z.WrongArgNumber);if(e.args.some((e=>e.type===U.EMPTY)))return new Tr(ir.NUM,Z.EmptyArg);let r=e.args[0];for(;r.type===U.PARENTHESIS;)r=r.expression;if(r.type===U.CELL_RANGE||r.type===U.COLUMN_RANGE)return r.end.col-r.start.col+1;if(r.type===U.CELL_REFERENCE)return 1;if(r.type===U.ROW_RANGE)return this.config.maxColumns;{const e=this.evaluateAst(r,t);return e instanceof rt?e.width():e instanceof Tr?e:1}}row(e,t){return this.runFunctionWithReferenceArgument(e.args,t,this.metadata("ROW"),(()=>t.formulaAddress.row+1),(e=>e.row+1))}rows(e,t){if(1!==e.args.length)return new Tr(ir.NA,Z.WrongArgNumber);if(e.args.some((e=>e.type===U.EMPTY)))return new Tr(ir.NUM,Z.EmptyArg);let r=e.args[0];for(;r.type===U.PARENTHESIS;)r=r.expression;if(r.type===U.CELL_RANGE||r.type===U.ROW_RANGE)return r.end.row-r.start.row+1;if(r.type===U.CELL_REFERENCE)return 1;if(r.type===U.COLUMN_RANGE)return this.config.maxRows;{const e=this.evaluateAst(r,t);return e instanceof rt?e.height():e instanceof Tr?e:1}}index(e,t){return this.runFunction(e.args,t,this.metadata("INDEX"),((e,t,r)=>{var n,s,i,o,a,l;return r<1||t<1?new Tr(ir.VALUE,Z.LessThanOne):r>e.width()||t>e.height()?new Tr(ir.NUM,Z.ValueLarge):null!==(l=null!==(i=null===(s=null===(n=null==e?void 0:e.data)||void 0===n?void 0:n[t-1])||void 0===s?void 0:s[r-1])&&void 0!==i?i:null===(a=null===(o=null==e?void 0:e.data)||void 0===o?void 0:o[0])||void 0===a?void 0:a[0])&&void 0!==l?l:new Tr(ir.VALUE,Z.CellRangeExpected)}))}na(e,t){return new Tr(ir.NA)}sheet(e,t){return this.runFunctionWithReferenceArgument(e.args,t,this.metadata("SHEET"),(()=>t.formulaAddress.sheet+1),(e=>e.sheet+1),(e=>{const t=this.dependencyGraph.sheetMapping.get(e);return void 0!==t?t+1:new Tr(ir.NA,Z.SheetRef)}))}sheets(e,t){return this.runFunctionWithReferenceArgument(e.args,t,this.metadata("SHEETS"),(()=>this.dependencyGraph.sheetMapping.numberOfSheets()),(()=>1),(()=>new Tr(ir.VALUE,Z.CellRefExpected)))}}So.implementedFunctions={COLUMN:{method:"column",parameters:[{argumentType:hn.NOERROR,optionalArg:!0}],isDependentOnSheetStructureChange:!0,doesNotNeedArgumentsToBeComputed:!0,vectorizationForbidden:!0},COLUMNS:{method:"columns",parameters:[{argumentType:hn.RANGE}],isDependentOnSheetStructureChange:!0,doesNotNeedArgumentsToBeComputed:!0,vectorizationForbidden:!0},ISBINARY:{method:"isbinary",parameters:[{argumentType:hn.STRING}]},ISERR:{method:"iserr",parameters:[{argumentType:hn.SCALAR}]},ISFORMULA:{method:"isformula",parameters:[{argumentType:hn.NOERROR}],doesNotNeedArgumentsToBeComputed:!0,vectorizationForbidden:!0},ISNA:{method:"isna",parameters:[{argumentType:hn.SCALAR}]},ISREF:{method:"isref",parameters:[{argumentType:hn.SCALAR}],vectorizationForbidden:!0},ISERROR:{method:"iserror",parameters:[{argumentType:hn.SCALAR}]},ISBLANK:{method:"isblank",parameters:[{argumentType:hn.SCALAR}]},ISNUMBER:{method:"isnumber",parameters:[{argumentType:hn.SCALAR}]},ISLOGICAL:{method:"islogical",parameters:[{argumentType:hn.SCALAR}]},ISTEXT:{method:"istext",parameters:[{argumentType:hn.SCALAR}]},ISNONTEXT:{method:"isnontext",parameters:[{argumentType:hn.SCALAR}]},INDEX:{method:"index",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:1}]},NA:{method:"na",parameters:[]},ROW:{method:"row",parameters:[{argumentType:hn.NOERROR,optionalArg:!0}],isDependentOnSheetStructureChange:!0,doesNotNeedArgumentsToBeComputed:!0,vectorizationForbidden:!0},ROWS:{method:"rows",parameters:[{argumentType:hn.RANGE}],isDependentOnSheetStructureChange:!0,doesNotNeedArgumentsToBeComputed:!0,vectorizationForbidden:!0},SHEET:{method:"sheet",parameters:[{argumentType:hn.STRING}],doesNotNeedArgumentsToBeComputed:!0,vectorizationForbidden:!0},SHEETS:{method:"sheets",parameters:[{argumentType:hn.STRING}],doesNotNeedArgumentsToBeComputed:!0,vectorizationForbidden:!0}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class To extends un{iseven(e,t){return this.runFunction(e.args,t,this.metadata("ISEVEN"),(e=>e%2==0))}}To.implementedFunctions={ISEVEN:{method:"iseven",parameters:[{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class No extends un{isodd(e,t){return this.runFunction(e.args,t,this.metadata("ISODD"),(e=>e%2==1))}}No.implementedFunctions={ISODD:{method:"isodd",parameters:[{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Mo extends un{log10(e,t){return this.runFunction(e.args,t,this.metadata("LOG10"),Math.log10)}log(e,t){return this.runFunction(e.args,t,this.metadata("LOG"),((e,t)=>Math.log(e)/Math.log(t)))}ln(e,t){return this.runFunction(e.args,t,this.metadata("LN"),Math.log)}}Mo.implementedFunctions={LOG10:{method:"log10",parameters:[{argumentType:hn.NUMBER}]},LOG:{method:"log",parameters:[{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,defaultValue:10,greaterThan:0}]},LN:{method:"ln",parameters:[{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const _o=parseFloat(Math.PI.toFixed(14));class bo extends un{pi(e,t){return this.runFunction(e.args,t,this.metadata("PI"),(()=>_o))}sqrtpi(e,t){return this.runFunction(e.args,t,this.metadata("SQRTPI"),(e=>Math.sqrt(_o*e)))}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function Ao(e,t){return new cn(t.width,e.height)}function Oo(e,t,r){return new cn(1+(e.width-t)/r,1+(e.height-t)/r)}bo.implementedFunctions={PI:{method:"pi",parameters:[]},SQRTPI:{method:"sqrtpi",parameters:[{argumentType:hn.NUMBER,minValue:0}]}};class Io extends un{mmult(e,t){return this.runFunction(e.args,t,this.metadata("MMULT"),((e,t)=>{if(!e.hasOnlyNumbers()||!t.hasOnlyNumbers())return new Tr(ir.VALUE,Z.NumberRange);if(t.height()!==e.width())return new Tr(ir.VALUE,Z.ArrayDimensions);const r=Ao(e.size,t.size),n=this.createKernel((function(e,t,r){let n=0;for(let s=0;s<r;++s)n+=e[this.thread.y][s]*t[s][this.thread.x];return n}),r)(e.rawNumbers(),t.rawNumbers(),e.width());return rt.onlyNumbers(n)}))}mmultArraySize(e,t){if(2!==e.args.length)return cn.error();const r=this.metadata("MMULT"),n=e.args.map((e=>{var n;return this.arraySizeForAst(e,new Br(t.formulaAddress,t.arraysFlag||null!==(n=null==r?void 0:r.arrayFunction)&&void 0!==n&&n))})),[s,i]=n;return Ao(s,i)}maxpool(e,t){return this.runFunction(e.args,t,this.metadata("MAXPOOL"),((e,t,r=t)=>{if(!e.hasOnlyNumbers())return new Tr(ir.VALUE,Z.NumberRange);const n=Oo(e.size,t,r),s=this.createKernel((function(e,t,r){const n=this.thread.x*r,s=this.thread.y*r;let i=e[s][n];for(let r=0;r<t;r++)for(let o=0;o<t;o++)i=Math.max(i,e[s+r][n+o]);return i}),n)(e.rawNumbers(),t,r);return rt.onlyNumbers(s)}))}medianpool(e,t){return this.runFunction(e.args,t,this.metadata("MEDIANPOOL"),((e,t,r=t)=>{if(!e.hasOnlyNumbers())return new Tr(ir.VALUE,Z.NumberRange);const n=Oo(e.size,t,r),s=this.createKernel((function(e,t,r){const n=this.thread.x*r,s=this.thread.y*r;let i=e[s][n];for(let r=0;r<t;r++)for(let o=0;o<t;o++)i=Math.max(i,e[s+r][n+o]);let o=e[s][n];for(let r=0;r<t;r++)for(let i=0;i<t;i++)o=Math.min(o,e[s+r][n+i]);const a=t*t;let l=o,h=i,u=42;for(let r=0;r<32;r++){const r=(l+h)/2;let i=0;for(let o=0;o<t;o++)for(let a=0;a<t;a++)e[s+o][n+a]>r&&i++;if(t%2==0){if(i===a/2){u=r;break}i>a/2?l=r:h=r}else{if(i===(a-1)/2){u=r;break}i>(a-1)/2?l=r:h=r}}return u}),n)(e.rawNumbers(),t,r);return rt.onlyNumbers(s)}))}maxpoolArraySize(e,t){if(e.args.length<2||e.args.length>3)return cn.error();const r=this.metadata("MAXPOOL"),n=e.args.map((e=>{var n;return this.arraySizeForAst(e,new Br(t.formulaAddress,t.arraysFlag||null!==(n=null==r?void 0:r.arrayFunction)&&void 0!==n&&n))}))[0],s=e.args[1];let i;i=s.type===U.NUMBER?s.value:1;let o=i;if(3===e.args.length){const t=e.args[2];o=t.type===U.NUMBER?t.value:1}return i>n.width||i>n.height||o>i||(n.width-i)%o!=0||(n.height-i)%o!=0?cn.error():Oo(n,i,o)}medianpoolArraySize(e,t){return this.maxpoolArraySize(e,t)}transpose(e,t){return this.runFunction(e.args,t,this.metadata("TRANSPOSE"),(e=>{const t=e.rawData(),r=e.size,n=[];for(let e=0;e<r.width;++e){n[e]=[];for(let s=0;s<r.height;++s)n[e][s]=t[s][e]}return rt.onlyValues(n)}))}transposeArraySize(e,t){if(1!==e.args.length)return cn.error();const r=this.metadata("TRANSPOSE"),n=e.args.map((e=>{var n;return this.arraySizeForAst(e,new Br(t.formulaAddress,t.arraysFlag||null!==(n=null==r?void 0:r.arrayFunction)&&void 0!==n&&n))})),[s]=n;return new cn(s.height,s.width)}createKernel(e,t){return function(...r){const n=[];for(let s=0;s<t.height;++s){n.push([]);for(let i=0;i<t.width;++i)n[s][i]=e.apply({thread:{x:i,y:s}},r)}return n}}}Io.implementedFunctions={MMULT:{method:"mmult",arraySizeMethod:"mmultArraySize",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}],vectorizationForbidden:!0},TRANSPOSE:{method:"transpose",arraySizeMethod:"transposeArraySize",parameters:[{argumentType:hn.RANGE}],vectorizationForbidden:!0},MAXPOOL:{method:"maxpool",arraySizeMethod:"maxpoolArraySize",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,optionalArg:!0}],vectorizationForbidden:!0},MEDIANPOOL:{method:"medianpool",arraySizeMethod:"medianpoolArraySize",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,optionalArg:!0}],vectorizationForbidden:!0}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class xo extends un{median(e,t){return this.runFunction(e.args,t,this.metadata("MEDIAN"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersExactRanges(e);return t instanceof Tr?t:0===t.length?new Tr(ir.NUM,Z.OneValue):(t.sort(((e,t)=>e-t)),t.length%2==0?(t[t.length/2-1]+t[t.length/2])/2:t[Math.floor(t.length/2)])}))}large(e,t){return this.runFunction(e.args,t,this.metadata("LARGE"),((e,t)=>{const r=this.arithmeticHelper.manyToExactNumbers(e.valuesFromTopLeftCorner());return r instanceof Tr?r:(r.sort(((e,t)=>e-t)),(t=Math.trunc(t))>r.length?new Tr(ir.NUM,Z.ValueLarge):r[r.length-t])}))}small(e,t){return this.runFunction(e.args,t,this.metadata("SMALL"),((e,t)=>{const r=this.arithmeticHelper.manyToExactNumbers(e.valuesFromTopLeftCorner());return r instanceof Tr?r:(r.sort(((e,t)=>e-t)),(t=Math.trunc(t))>r.length?new Tr(ir.NUM,Z.ValueLarge):r[t-1])}))}}xo.implementedFunctions={MEDIAN:{method:"median",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},LARGE:{method:"large",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NUMBER,minValue:1}]},SMALL:{method:"small",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NUMBER,minValue:1}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Po extends un{mod(e,t){return this.runFunction(e.args,t,this.metadata("MOD"),((e,t)=>0===t?new Tr(ir.DIV_BY_ZERO):e%t))}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function Lo(e){return Ze(e)&&!Number.isFinite(Ge(e))?0:e}Po.implementedFunctions={MOD:{method:"mod",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]}};class Do{constructor(e,t,r){this.sumsq=e,this.sum=t,this.count=r}static single(e){return new Do(e*e,e,1)}compose(e){return new Do(this.sumsq+e.sumsq,this.sum+e.sum,this.count+e.count)}averageValue(){return this.count>0?this.sum/this.count:void 0}varSValue(){return this.count>1?(this.sumsq-this.sum*this.sum/this.count)/(this.count-1):void 0}varPValue(){return this.count>0?(this.sumsq-this.sum*this.sum/this.count)/this.count:void 0}}Do.empty=new Do(0,0,0);class ko extends un{constructor(){super(...arguments),this.addWithEpsilonRaw=(e,t)=>this.arithmeticHelper.addWithEpsilonRaw(e,t)}sum(e,t){return this.doSum(e.args,t)}sumsq(e,t){return this.reduce(e.args,t,0,"SUMSQ",this.addWithEpsilonRaw,(e=>Math.pow(Ge(e),2)),Ho)}max(e,t){return this.doMax(e.args,t)}maxa(e,t){return Lo(this.reduce(e.args,t,Number.NEGATIVE_INFINITY,"MAXA",((e,t)=>Math.max(e,t)),Ge,Fo))}min(e,t){return this.doMin(e.args,t)}mina(e,t){return Lo(this.reduce(e.args,t,Number.POSITIVE_INFINITY,"MINA",((e,t)=>Math.min(e,t)),Ge,Fo))}count(e,t){return this.doCount(e.args,t)}counta(e,t){return this.doCounta(e.args,t)}average(e,t){return this.doAverage(e.args,t)}averagea(e,t){var r;const n=this.reduce(e.args,t,Do.empty,"_AGGREGATE_A",((e,t)=>e.compose(t)),(e=>Do.single(Ge(e))),Fo);return n instanceof Tr?n:null!==(r=n.averageValue())&&void 0!==r?r:new Tr(ir.DIV_BY_ZERO)}vars(e,t){return this.doVarS(e.args,t)}varp(e,t){return this.doVarP(e.args,t)}vara(e,t){var r;const n=this.reduceAggregateA(e.args,t);return n instanceof Tr?n:null!==(r=n.varSValue())&&void 0!==r?r:new Tr(ir.DIV_BY_ZERO)}varpa(e,t){var r;const n=this.reduceAggregateA(e.args,t);return n instanceof Tr?n:null!==(r=n.varPValue())&&void 0!==r?r:new Tr(ir.DIV_BY_ZERO)}stdevs(e,t){return this.doStdevS(e.args,t)}stdevp(e,t){return this.doStdevP(e.args,t)}stdeva(e,t){const r=this.reduceAggregateA(e.args,t);if(r instanceof Tr)return r;{const e=r.varSValue();return void 0===e?new Tr(ir.DIV_BY_ZERO):Math.sqrt(e)}}stdevpa(e,t){const r=this.reduceAggregateA(e.args,t);if(r instanceof Tr)return r;{const e=r.varPValue();return void 0===e?new Tr(ir.DIV_BY_ZERO):Math.sqrt(e)}}product(e,t){return this.doProduct(e.args,t)}subtotal(e,t){if(e.args.length<2)return new Tr(ir.NA,Z.WrongArgNumber);const r=this.coerceToType(this.evaluateAst(e.args[0],t),{argumentType:hn.NUMBER},t),n=e.args.slice(1);switch(r){case 1:case 101:return this.doAverage(n,t);case 2:case 102:return this.doCount(n,t);case 3:case 103:return this.doCounta(n,t);case 4:case 104:return this.doMax(n,t);case 5:case 105:return this.doMin(n,t);case 6:case 106:return this.doProduct(n,t);case 7:case 107:return this.doStdevS(n,t);case 8:case 108:return this.doStdevP(n,t);case 9:case 109:return this.doSum(n,t);case 10:case 110:return this.doVarS(n,t);case 11:case 111:return this.doVarP(n,t);default:return new Tr(ir.VALUE,Z.BadMode)}}reduceAggregate(e,t){return this.reduce(e,t,Do.empty,"_AGGREGATE",((e,t)=>e.compose(t)),(e=>Do.single(Ge(e))),Ho)}reduceAggregateA(e,t){return this.reduce(e,t,Do.empty,"_AGGREGATE_A",((e,t)=>e.compose(t)),(e=>Do.single(Ge(e))),Fo)}doAverage(e,t){var r;const n=this.reduceAggregate(e,t);return n instanceof Tr?n:null!==(r=n.averageValue())&&void 0!==r?r:new Tr(ir.DIV_BY_ZERO)}doVarS(e,t){var r;const n=this.reduceAggregate(e,t);return n instanceof Tr?n:null!==(r=n.varSValue())&&void 0!==r?r:new Tr(ir.DIV_BY_ZERO)}doVarP(e,t){var r;const n=this.reduceAggregate(e,t);return n instanceof Tr?n:null!==(r=n.varPValue())&&void 0!==r?r:new Tr(ir.DIV_BY_ZERO)}doStdevS(e,t){const r=this.reduceAggregate(e,t);if(r instanceof Tr)return r;{const e=r.varSValue();return void 0===e?new Tr(ir.DIV_BY_ZERO):Math.sqrt(e)}}doStdevP(e,t){const r=this.reduceAggregate(e,t);if(r instanceof Tr)return r;{const e=r.varPValue();return void 0===e?new Tr(ir.DIV_BY_ZERO):Math.sqrt(e)}}doCount(e,t){return this.reduce(e,t,0,"COUNT",((e,t)=>e+t),Ge,(e=>Ze(e)?1:0))}doCounta(e,t){return this.reduce(e,t,0,"COUNTA",((e,t)=>e+t),Ge,(e=>e===Ye?0:1))}doMax(e,t){return Lo(this.reduce(e,t,Number.NEGATIVE_INFINITY,"MAX",((e,t)=>Math.max(e,t)),Ge,Ho))}doMin(e,t){return Lo(this.reduce(e,t,Number.POSITIVE_INFINITY,"MIN",((e,t)=>Math.min(e,t)),Ge,Ho))}doSum(e,t){return this.reduce(e,t,0,"SUM",this.addWithEpsilonRaw,Ge,Ho)}doProduct(e,t){return this.reduce(e,t,1,"PRODUCT",((e,t)=>e*t),Ge,Ho)}reduce(e,t,r,n,s,i,o){return e.length<1?new Tr(ir.NA,Z.WrongArgNumber):e.reduce(((e,a)=>{if(e instanceof Tr)return e;if(a.type===U.CELL_RANGE||a.type===U.COLUMN_RANGE||a.type===U.ROW_RANGE){const l=this.evaluateRange(a,t,r,n,s,i,o);return l instanceof Tr?l:s(l,e)}let l;if(l=this.evaluateAst(a,t),l instanceof rt){const t=Array.from(l.valuesFromTopLeftCorner()).map(o).filter((e=>void 0!==e));return t.map((e=>e instanceof Tr?e:i(e))).reduce(((e,t)=>e instanceof Tr?e:t instanceof Tr?t:s(e,t)),e)}if(a.type===U.CELL_REFERENCE){if(l=o(l),void 0===l)return e}else if(l=this.coerceScalarToNumberOrError(l),l=o(l),void 0===l)return e;return l instanceof Tr?l:s(e,i(l))}),r)}evaluateRange(e,t,r,n,s,i,o){let a;try{a=Fr.fromAst(e,t.formulaAddress)}catch(e){if(e instanceof ft)return new Tr(ir.REF,Z.RangeManySheets);throw e}const l=this.dependencyGraph.getRange(a.start,a.end);if(void 0===l)throw new Error("Range does not exists in graph");let h=l.getFunctionValue(n);if(void 0===h){h=this.getRangeValues(n,a,l,i,o).reduce(((e,t)=>e instanceof Tr?e:t instanceof Tr?t:s(e,t)),r),l.setFunctionValue(n,h)}return h}getRangeValues(e,t,r,n,s){const i=[],{smallerRangeVertex:o,restRange:a}=this.dependencyGraph.rangeMapping.findSmallerRange(t);let l;if(void 0!==o&&this.dependencyGraph.existsEdge(o,r)){const t=o.getFunctionValue(e);if(void 0!==t)i.push(t);else for(const e of o.range.addresses(this.dependencyGraph)){const t=s(this.dependencyGraph.getScalarValue(e));t instanceof Tr?i.push(t):void 0!==t&&i.push(n(t))}l=a}else l=t;for(const e of l.addresses(this.dependencyGraph)){const t=s(this.dependencyGraph.getScalarValue(e));t instanceof Tr?i.push(t):void 0!==t&&i.push(n(t))}return i}}function Ho(e){return Ze(e)||e instanceof Tr?e:void 0}function Fo(e){return"boolean"==typeof e?zr(e):Ze(e)||e instanceof Tr?e:"string"==typeof e?0:void 0}ko.implementedFunctions={SUM:{method:"sum",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},SUMSQ:{method:"sumsq",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},MAX:{method:"max",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},MIN:{method:"min",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},MAXA:{method:"maxa",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},MINA:{method:"mina",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},COUNT:{method:"count",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},COUNTA:{method:"counta",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},AVERAGE:{method:"average",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},AVERAGEA:{method:"averagea",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},PRODUCT:{method:"product",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},"VAR.S":{method:"vars",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},"VAR.P":{method:"varp",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},VARA:{method:"vara",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},VARPA:{method:"varpa",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},"STDEV.S":{method:"stdevs",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},"STDEV.P":{method:"stdevp",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},STDEVA:{method:"stdeva",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},STDEVPA:{method:"stdevpa",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},SUBTOTAL:{method:"subtotal",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.ANY}],repeatLastArgs:1}},ko.aliases={VAR:"VAR.S",VARP:"VAR.P",STDEV:"STDEV.S",STDEVP:"STDEV.P",VARS:"VAR.S",STDEVS:"STDEV.S"};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Uo extends un{power(e,t){return this.runFunction(e.args,t,this.metadata("POWER"),Math.pow)}}Uo.implementedFunctions={POWER:{method:"power",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Vo extends un{radians(e,t){return this.runFunction(e.args,t,this.metadata("RADIANS"),(e=>e*(Math.PI/180)))}}Vo.implementedFunctions={RADIANS:{method:"radians",parameters:[{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
const Bo=10;class Wo extends un{dec2bin(e,t){return this.runFunction(e.args,t,this.metadata("DEC2BIN"),((e,t)=>Go(e,2,t)))}dec2oct(e,t){return this.runFunction(e.args,t,this.metadata("DEC2OCT"),((e,t)=>Go(e,8,t)))}dec2hex(e,t){return this.runFunction(e.args,t,this.metadata("DEC2HEX"),((e,t)=>Go(e,16,t)))}bin2dec(e,t){return this.runFunction(e.args,t,this.metadata("BIN2DEC"),(e=>{const t=Yo(e,2,Bo);return void 0===t?new Tr(ir.NUM,Z.NotBinary):Ko(t,2)}))}bin2oct(e,t){return this.runFunction(e.args,t,this.metadata("BIN2OCT"),((e,t)=>{const r=Yo(e,2,Bo);return void 0===r?new Tr(ir.NUM,Z.NotBinary):Go(Ko(r,2),8,t)}))}bin2hex(e,t){return this.runFunction(e.args,t,this.metadata("BIN2HEX"),((e,t)=>{const r=Yo(e,2,Bo);return void 0===r?new Tr(ir.NUM,Z.NotBinary):Go(Ko(r,2),16,t)}))}oct2dec(e,t){return this.runFunction(e.args,t,this.metadata("OCT2DEC"),(e=>{const t=Yo(e,8,Bo);return void 0===t?new Tr(ir.NUM,Z.NotOctal):Ko(t,8)}))}oct2bin(e,t){return this.runFunction(e.args,t,this.metadata("OCT2BIN"),((e,t)=>{const r=Yo(e,8,Bo);return void 0===r?new Tr(ir.NUM,Z.NotOctal):Go(Ko(r,8),2,t)}))}oct2hex(e,t){return this.runFunction(e.args,t,this.metadata("OCT2HEX"),((e,t)=>{const r=Yo(e,8,Bo);return void 0===r?new Tr(ir.NUM,Z.NotOctal):Go(Ko(r,8),16,t)}))}hex2dec(e,t){return this.runFunction(e.args,t,this.metadata("HEX2DEC"),(e=>{const t=Yo(e,16,Bo);return void 0===t?new Tr(ir.NUM,Z.NotHex):Ko(t,16)}))}hex2bin(e,t){return this.runFunction(e.args,t,this.metadata("HEX2BIN"),((e,t)=>{const r=Yo(e,16,Bo);return void 0===r?new Tr(ir.NUM,Z.NotHex):Go(Ko(r,16),2,t)}))}hex2oct(e,t){return this.runFunction(e.args,t,this.metadata("HEX2OCT"),((e,t)=>{const r=Yo(e,16,Bo);return void 0===r?new Tr(ir.NUM,Z.NotHex):Go(Ko(r,16),8,t)}))}base(e,t){return this.runFunction(e.args,t,this.metadata("BASE"),zo)}decimal(e,t){return this.runFunction(e.args,t,this.metadata("DECIMAL"),((e,t)=>{const r=Yo(e,t,255);return void 0===r?new Tr(ir.NUM,Z.NotHex):parseInt(r,t)}))}}function Yo(e,t,r){const n="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".substr(0,t),s=new RegExp(`^[${n}]+$`);if(!(e.length>r)&&s.test(e))return e}function Go(e,t,r){if(e>function(e){return-jo(e)-1}(t))return new Tr(ir.NUM,Z.ValueBaseLarge);if(e<jo(t))return new Tr(ir.NUM,Z.ValueBaseSmall);const n=$o(e,t);return void 0===r||e<0?n:n.length>r?new Tr(ir.NUM,Z.ValueBaseLong):Xn(n,r)}function jo(e){return-Math.pow(e,Bo)/2}function zo(e,t,r){const n=$o(e,t);return void 0!==r&&r>n.length?Xn(n,r):n}function $o(e,t){return(e+(e<0?Math.pow(t,Bo):0)).toString(t).toUpperCase()}function Ko(e,t){const r=parseInt(e,t),n=Math.pow(t,Bo);return r>=n/2?r-n:r}Wo.implementedFunctions={DEC2BIN:{method:"dec2bin",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,optionalArg:!0,minValue:1,maxValue:10}]},DEC2OCT:{method:"dec2oct",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,optionalArg:!0,minValue:1,maxValue:10}]},DEC2HEX:{method:"dec2hex",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,optionalArg:!0,minValue:1,maxValue:10}]},BIN2DEC:{method:"bin2dec",parameters:[{argumentType:hn.STRING}]},BIN2OCT:{method:"bin2oct",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,optionalArg:!0,minValue:0,maxValue:Bo}]},BIN2HEX:{method:"bin2hex",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,optionalArg:!0,minValue:0,maxValue:Bo}]},OCT2DEC:{method:"oct2dec",parameters:[{argumentType:hn.STRING}]},OCT2BIN:{method:"oct2bin",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,optionalArg:!0,minValue:0,maxValue:Bo}]},OCT2HEX:{method:"oct2hex",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,optionalArg:!0,minValue:0,maxValue:Bo}]},HEX2DEC:{method:"hex2dec",parameters:[{argumentType:hn.STRING}]},HEX2BIN:{method:"hex2bin",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,optionalArg:!0,minValue:0,maxValue:Bo}]},HEX2OCT:{method:"hex2oct",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,optionalArg:!0,minValue:0,maxValue:Bo}]},DECIMAL:{method:"decimal",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,minValue:2,maxValue:36}]},BASE:{method:"base",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:2,maxValue:36},{argumentType:hn.NUMBER,optionalArg:!0,minValue:0,maxValue:255}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Xo extends un{rand(e,t){return this.runFunction(e.args,t,this.metadata("RAND"),Math.random)}randbetween(e,t){return this.runFunction(e.args,t,this.metadata("RANDBETWEEN"),((e,t)=>t<e?new Tr(ir.NUM,Z.WrongOrder):((e=Math.ceil(e))===(t=Math.floor(t)+1)&&(t+=1),e+Math.floor(Math.random()*(t-e)))))}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function qo(e){const t=Math.ceil(e);return t%2==1?t:t+1}function Qo(e){const t=Math.ceil(e);return t%2==0?t:t+1}Xo.implementedFunctions={RAND:{method:"rand",parameters:[],isVolatile:!0},RANDBETWEEN:{method:"randbetween",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}],isVolatile:!0}};class Zo extends un{roundup(e,t){return this.runFunction(e.args,t,this.metadata("ROUNDDOWN"),((e,t)=>{const r=Math.pow(10,t);return e<0?-Math.ceil(-e*r)/r:Math.ceil(e*r)/r}))}rounddown(e,t){return this.runFunction(e.args,t,this.metadata("ROUNDDOWN"),((e,t)=>{const r=Math.pow(10,t);return e<0?-Math.floor(-e*r)/r:Math.floor(e*r)/r}))}round(e,t){return this.runFunction(e.args,t,this.metadata("ROUND"),((e,t)=>{const r=Math.pow(10,t);return e<0?-Math.round(-e*r)/r:Math.round(e*r)/r}))}intFunc(e,t){return this.runFunction(e.args,t,this.metadata("INT"),(e=>e<0?-Math.floor(-e):Math.floor(e)))}even(e,t){return this.runFunction(e.args,t,this.metadata("EVEN"),(e=>e<0?-Qo(-e):Qo(e)))}odd(e,t){return this.runFunction(e.args,t,this.metadata("ODD"),(e=>e<0?-qo(-e):qo(e)))}ceilingmath(e,t){return this.runFunction(e.args,t,this.metadata("CEILING.MATH"),((e,t,r)=>0===t||0===e?0:(t=Math.abs(t),1===r&&e<0&&(t=-t),Math.ceil(e/t)*t)))}ceiling(e,t){return this.runFunction(e.args,t,this.metadata("CEILING"),((e,t)=>0===e?0:0===t?new Tr(ir.DIV_BY_ZERO):e>0&&t<0?new Tr(ir.NUM,Z.DistinctSigns):Math.ceil(e/t)*t))}ceilingprecise(e,t){return this.runFunction(e.args,t,this.metadata("CEILING.PRECISE"),((e,t)=>0===t||0===e?0:(t=Math.abs(t),Math.ceil(e/t)*t)))}floormath(e,t){return this.runFunction(e.args,t,this.metadata("FLOOR.MATH"),((e,t,r)=>0===t||0===e?0:(t=Math.abs(t),1===r&&e<0&&(t*=-1),Math.floor(e/t)*t)))}floor(e,t){return this.runFunction(e.args,t,this.metadata("FLOOR"),((e,t)=>0===e?0:0===t?new Tr(ir.DIV_BY_ZERO):e>0&&t<0?new Tr(ir.NUM,Z.DistinctSigns):Math.floor(e/t)*t))}floorprecise(e,t){return this.runFunction(e.args,t,this.metadata("FLOOR.PRECISE"),((e,t)=>0===t||0===e?0:(t=Math.abs(t),Math.floor(e/t)*t)))}}Zo.implementedFunctions={ROUNDUP:{method:"roundup",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0}]},ROUNDDOWN:{method:"rounddown",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0}]},ROUND:{method:"round",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:0}]},INT:{method:"intFunc",parameters:[{argumentType:hn.NUMBER}]},EVEN:{method:"even",parameters:[{argumentType:hn.NUMBER}]},ODD:{method:"odd",parameters:[{argumentType:hn.NUMBER}]},"CEILING.MATH":{method:"ceilingmath",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:1},{argumentType:hn.NUMBER,defaultValue:0}]},CEILING:{method:"ceiling",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]},"CEILING.PRECISE":{method:"ceilingprecise",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:1}]},"FLOOR.MATH":{method:"floormath",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:1},{argumentType:hn.NUMBER,defaultValue:0}]},FLOOR:{method:"floor",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]},"FLOOR.PRECISE":{method:"floorprecise",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,defaultValue:1}]}},Zo.aliases={"ISO.CEILING":"CEILING.PRECISE",TRUNC:"ROUNDDOWN"};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Jo extends un{sqrt(e,t){return this.runFunction(e.args,t,this.metadata("SQRT"),Math.sqrt)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
function*ea(){}function ta(e){const t=e[Symbol.iterator](),{done:r,value:n}=t.next();return r?{rest:ea()}:{value:n,rest:t}}Jo.implementedFunctions={SQRT:{method:"sqrt",parameters:[{argumentType:hn.NUMBER}]}};class ra{constructor(e,t,r,n,s){this.interpreter=e,this.cacheKey=t,this.reduceInitialValue=r,this.composeFunction=n,this.mapFunction=s,this.dependencyGraph=this.interpreter.dependencyGraph}compute(e,t){for(const r of t)if(!r.conditionRange.sameDimensionsAs(e))return new Tr(ir.VALUE,Z.EqualLength);const r=this.tryToGetRangeVertexForRangeValue(e),n=t.map((e=>this.tryToGetRangeVertexForRangeValue(e.conditionRange)));if(r&&n.every((e=>void 0!==e))){const s=t.map((e=>e.criterionPackage.raw)).join(","),i=this.findAlreadyComputedValueInCache(r,this.cacheKey(t),s);if(void 0!==i)return this.interpreter.stats.incrementCriterionFunctionFullCacheUsed(),i;const o=this.buildNewCriterionCache(this.cacheKey(t),t.map((e=>e.conditionRange.range)),e.range);return o.has(s)||o.set(s,[this.evaluateRangeValue(e,t),t.map((e=>e.criterionPackage.lambda))]),r.setCriterionFunctionValues(this.cacheKey(t),o),n.forEach((e=>{void 0!==e&&e.addDependentCacheRange(r)})),o.get(s)[0]}return this.evaluateRangeValue(e,t)}tryToGetRangeVertexForRangeValue(e){const t=e.range;return void 0===t?void 0:this.dependencyGraph.getRange(t.start,t.end)}reduceFunction(e){let t=this.reduceInitialValue;for(const r of e)t=this.composeFunction(t,r);return t}findAlreadyComputedValueInCache(e,t,r){return e.getCriterionFunctionValue(t,r)}evaluateRangeValue(e,t){const r=t.map((e=>e.criterionPackage.lambda)),n=Array.from(e.valuesFromTopLeftCorner()).map(this.mapFunction)[Symbol.iterator](),s=ia(r,t.map((e=>e.conditionRange.iterateValuesFromTopLeftCorner())),n);return this.reduceFunction(s)}buildNewCriterionCache(e,t,r){const n=this.dependencyGraph.getRange(r.start,r.end),{smallerRangeVertex:s,restConditionRanges:i,restValuesRange:o}=((e,t,r)=>{if(r.end.row>r.start.row){const n=Ar(r.end.sheet,r.end.col,r.end.row-1),s=e.getRange(r.start,n);if(void 0!==s)return{smallerRangeVertex:s,restValuesRange:r.withStart(Ar(r.start.sheet,r.start.col,r.end.row)),restConditionRanges:t.map((e=>e.withStart(Ar(e.start.sheet,e.start.col,e.end.row))))}}return{restValuesRange:r,restConditionRanges:t}})(this.dependencyGraph,t,r);let a;a=void 0!==s&&this.dependencyGraph.existsEdge(s,n)?s.getCriterionFunctionValues(e):new Map;const l=new Map;return a.forEach((([e,t],r)=>{const n=ia(t,i.map((e=>sa(this.dependencyGraph,e))),Array.from(sa(this.dependencyGraph,o)).map(this.mapFunction)[Symbol.iterator]()),s=this.composeFunction(e,this.reduceFunction(n));this.interpreter.stats.incrementCriterionFunctionPartialCacheUsed(),l.set(r,[s,t])})),l}}class na{constructor(e,t){this.conditionRange=e,this.criterionPackage=t}}function*sa(e,t){for(const r of t.addresses(e))yield Ge(e.getScalarValue(r))}function*ia(e,t,r){for(const n of r){const r=t.map((e=>ta(e)));if(!r.every((e=>Object.prototype.hasOwnProperty.call(e,"value"))))return;oa(r.map((e=>Ge(e.value))),e).every((([e,t])=>t(e)))&&(yield n),t=r.map((e=>e.rest))}}function oa(e,t){const r=[];for(let n=0;n<Math.min(e.length,t.length);n++)r.push([e[n],t[n]]);return r}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class aa{constructor(e,t){this.sum=e,this.count=t}static single(e){return new aa(e,1)}compose(e){return new aa(this.sum+e.sum,this.count+e.count)}averageValue(){return this.count>0?this.sum/this.count:void 0}}function la(e){return Ze(e)&&!Number.isFinite(Ge(e))?0:e}function ha(e){return e instanceof Tr?e:Ze(e)?Ge(e):void 0}aa.empty=new aa(0,0);class ua extends un{sumif(e,t){const r="SUMIF";return this.runFunction(e.args,t,this.metadata(r),((e,t,n)=>this.computeConditionalAggregationFunction(null!=n?n:e,[e,t],r,0,((e,t)=>this.arithmeticHelper.nonstrictadd(e,t)),ha)))}sumifs(e,t){const r="SUMIFS";return this.runFunction(e.args,t,this.metadata(r),((e,...t)=>this.computeConditionalAggregationFunction(e,t,r,0,((e,t)=>this.arithmeticHelper.nonstrictadd(e,t)),ha)))}averageif(e,t){const r="AVERAGEIF";return this.runFunction(e.args,t,this.metadata(r),((e,t,n)=>{const s=this.computeConditionalAggregationFunction(null!=n?n:e,[e,t],r,aa.empty,((e,t)=>e.compose(t)),(e=>Ze(e)?aa.single(Ge(e)):aa.empty));return s instanceof Tr?s:s.averageValue()||new Tr(ir.DIV_BY_ZERO)}))}countif(e,t){const r="COUNTIF";return this.runFunction(e.args,t,this.metadata(r),((e,t)=>this.computeConditionalAggregationFunction(e,[e,t],r,0,((e,t)=>e+t),(()=>1))))}countifs(e,t){const r="COUNTIFS";return this.runFunction(e.args,t,this.metadata(r),((...e)=>this.computeConditionalAggregationFunction(e[0],e,r,0,((e,t)=>e+t),(()=>1))))}minifs(e,t){const r="MINIFS",n=(e,t)=>void 0===t||void 0===e?void 0===t?e:t:Math.min(e,t);return this.runFunction(e.args,t,this.metadata(r),((e,...t)=>la(this.computeConditionalAggregationFunction(e,t,r,Number.POSITIVE_INFINITY,n,ha))))}maxifs(e,t){const r="MAXIFS",n=(e,t)=>void 0===t||void 0===e?void 0===t?e:t:Math.max(e,t);return this.runFunction(e.args,t,this.metadata(r),((e,...t)=>la(this.computeConditionalAggregationFunction(e,t,r,Number.NEGATIVE_INFINITY,n,ha))))}computeConditionalAggregationFunction(e,t,r,n,s,i){const o=[];for(let e=0;e<t.length;e+=2){const r=t[e],n=this.interpreter.criterionBuilder.fromCellValue(t[e+1],this.arithmeticHelper);if(void 0===n)return new Tr(ir.VALUE,Z.BadCriterion);o.push(new na(r,n))}return new ra(this.interpreter,function(e){return t=>{const r=t.map((e=>`${e.conditionRange.range.sheet},${e.conditionRange.range.start.col},${e.conditionRange.range.start.row}`));return[e,...r].join(",")}}(r),n,s,i).compute(e,o)}}ua.implementedFunctions={SUMIF:{method:"sumif",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NOERROR},{argumentType:hn.RANGE,optionalArg:!0}]},COUNTIF:{method:"countif",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NOERROR}]},AVERAGEIF:{method:"averageif",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NOERROR},{argumentType:hn.RANGE,optionalArg:!0}]},SUMIFS:{method:"sumifs",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE},{argumentType:hn.NOERROR}],repeatLastArgs:2},COUNTIFS:{method:"countifs",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NOERROR}],repeatLastArgs:2},MINIFS:{method:"minifs",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE},{argumentType:hn.NOERROR}],repeatLastArgs:2},MAXIFS:{method:"maxifs",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE},{argumentType:hn.NOERROR}],repeatLastArgs:2}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ca extends un{sumproduct(e,t){return this.runFunction(e.args,t,this.metadata("SUMPRODUCT"),((...e)=>{const t=e[0].width(),r=e[0].height();for(const n of e)if(n.width()!==t||n.height()!==r)return new Tr(ir.VALUE,Z.EqualLength);let n=0;const s=e.map((e=>e.iterateValuesFromTopLeftCorner()));for(let e=0;e<t*r;e++){let e=1;for(const t of s){const r=t.next().value;if(r instanceof Tr)return r;const n=this.coerceScalarToNumberOrError(r);Ze(n)?e*=Ge(n):e=0}n+=e}return n}))}}ca.implementedFunctions={SUMPRODUCT:{method:"sumproduct",parameters:[{argumentType:hn.RANGE}],repeatLastArgs:1}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class da extends un{concatenate(e,t){return this.runFunction(e.args,t,this.metadata("CONCATENATE"),((...e)=>"".concat(...e)))}split(e,t){return this.runFunction(e.args,t,this.metadata("SPLIT"),((e,t)=>{const r=e.split(" ");return t>=r.length||t<0?new Tr(ir.VALUE,Z.IndexBounds):r[t]}))}len(e,t){return this.runFunction(e.args,t,this.metadata("LEN"),(e=>e.length))}lower(e,t){return this.runFunction(e.args,t,this.metadata("LOWER"),(e=>e.toLowerCase()))}trim(e,t){return this.runFunction(e.args,t,this.metadata("TRIM"),(e=>e.replace(/^ +| +$/g,"").replace(/ +/g," ")))}proper(e,t){return this.runFunction(e.args,t,this.metadata("PROPER"),(e=>e.replace(/\p{L}+/gu,(e=>e.charAt(0).toUpperCase()+e.substring(1).toLowerCase()))))}clean(e,t){return this.runFunction(e.args,t,this.metadata("CLEAN"),(e=>e.replace(/[\u0000-\u001F]/g,"")))}exact(e,t){return this.runFunction(e.args,t,this.metadata("EXACT"),((e,t)=>e===t))}rept(e,t){return this.runFunction(e.args,t,this.metadata("REPT"),((e,t)=>t<0?new Tr(ir.VALUE,Z.NegativeCount):e.repeat(t)))}right(e,t){return this.runFunction(e.args,t,this.metadata("RIGHT"),((e,t)=>t<0?new Tr(ir.VALUE,Z.NegativeLength):0===t?"":e.slice(-t)))}left(e,t){return this.runFunction(e.args,t,this.metadata("LEFT"),((e,t)=>t<0?new Tr(ir.VALUE,Z.NegativeLength):e.slice(0,t)))}mid(e,t){return this.runFunction(e.args,t,this.metadata("MID"),((e,t,r)=>t<1?new Tr(ir.VALUE,Z.LessThanOne):r<0?new Tr(ir.VALUE,Z.NegativeLength):e.substring(t-1,t+r-1)))}replace(e,t){return this.runFunction(e.args,t,this.metadata("REPLACE"),((e,t,r,n)=>t<1?new Tr(ir.VALUE,Z.LessThanOne):r<0?new Tr(ir.VALUE,Z.NegativeLength):e.substring(0,t-1)+n+e.substring(t+r-1)))}search(e,t){return this.runFunction(e.args,t,this.metadata("SEARCH"),((e,t,r)=>{if(r<1||r>t.length)return new Tr(ir.VALUE,Z.LengthBounds);const n=e.toLowerCase(),s=t.substring(r-1).toLowerCase(),i=this.arithmeticHelper.requiresRegex(n)?this.arithmeticHelper.searchString(n,s):s.indexOf(n);return i>-1?i+r:new Tr(ir.VALUE,Z.PatternNotFound)}))}substitute(e,t){return this.runFunction(e.args,t,this.metadata("SUBSTITUTE"),((e,t,r,n)=>{const s=this.escapeRegExpSpecialCharacters(t),i=new RegExp(s,"g");if(void 0===n)return e.replace(i,r);if(n<1)return new Tr(ir.VALUE,Z.LessThanOne);let o,a=0;for(;null!==(o=i.exec(e));)if(n===++a)return e.substring(0,o.index)+r+e.substring(i.lastIndex);return e}))}find(e,t){return this.runFunction(e.args,t,this.metadata("FIND"),((e,t,r)=>{if(r<1||r>t.length)return new Tr(ir.VALUE,Z.IndexBounds);const n=t.substring(r-1).indexOf(e)+r;return n>0?n:new Tr(ir.VALUE,Z.PatternNotFound)}))}t(e,t){return this.runFunction(e.args,t,this.metadata("T"),(e=>e instanceof Tr||"string"==typeof e?e:""))}upper(e,t){return this.runFunction(e.args,t,this.metadata("UPPER"),(e=>e.toUpperCase()))}escapeRegExpSpecialCharacters(e){return e.replace(/[.*+?^${}()|[\]\\]/g,"\\$&")}}da.implementedFunctions={CONCATENATE:{method:"concatenate",parameters:[{argumentType:hn.STRING}],repeatLastArgs:1,expandRanges:!0},EXACT:{method:"exact",parameters:[{argumentType:hn.STRING},{argumentType:hn.STRING}]},SPLIT:{method:"split",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER}]},LEN:{method:"len",parameters:[{argumentType:hn.STRING}]},LOWER:{method:"lower",parameters:[{argumentType:hn.STRING}]},MID:{method:"mid",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]},TRIM:{method:"trim",parameters:[{argumentType:hn.STRING}]},T:{method:"t",parameters:[{argumentType:hn.SCALAR}]},PROPER:{method:"proper",parameters:[{argumentType:hn.STRING}]},CLEAN:{method:"clean",parameters:[{argumentType:hn.STRING}]},REPT:{method:"rept",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER}]},RIGHT:{method:"right",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,defaultValue:1}]},LEFT:{method:"left",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER,defaultValue:1}]},REPLACE:{method:"replace",parameters:[{argumentType:hn.STRING},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.STRING}]},SEARCH:{method:"search",parameters:[{argumentType:hn.STRING},{argumentType:hn.STRING},{argumentType:hn.NUMBER,defaultValue:1}]},SUBSTITUTE:{method:"substitute",parameters:[{argumentType:hn.STRING},{argumentType:hn.STRING},{argumentType:hn.STRING},{argumentType:hn.NUMBER,optionalArg:!0}]},FIND:{method:"find",parameters:[{argumentType:hn.STRING},{argumentType:hn.STRING},{argumentType:hn.NUMBER,defaultValue:1}]},UPPER:{method:"upper",parameters:[{argumentType:hn.STRING}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class pa extends un{acos(e,t){return this.runFunction(e.args,t,this.metadata("ACOS"),Math.acos)}asin(e,t){return this.runFunction(e.args,t,this.metadata("ASIN"),Math.asin)}cos(e,t){return this.runFunction(e.args,t,this.metadata("COS"),Math.cos)}sin(e,t){return this.runFunction(e.args,t,this.metadata("SIN"),Math.sin)}tan(e,t){return this.runFunction(e.args,t,this.metadata("TAN"),Math.tan)}atan(e,t){return this.runFunction(e.args,t,this.metadata("ATAN"),Math.atan)}atan2(e,t){return this.runFunction(e.args,t,this.metadata("ATAN2"),((e,t)=>0===e&&0===t?new Tr(ir.DIV_BY_ZERO):Math.atan2(t,e)))}cot(e,t){return this.runFunction(e.args,t,this.metadata("COT"),(e=>0===e?new Tr(ir.DIV_BY_ZERO):1/Math.tan(e)))}acot(e,t){return this.runFunction(e.args,t,this.metadata("ACOT"),(e=>0===e?_o/2:Math.atan(1/e)))}sec(e,t){return this.runFunction(e.args,t,this.metadata("SEC"),(e=>1/Math.cos(e)))}csc(e,t){return this.runFunction(e.args,t,this.metadata("CSC"),(e=>0===e?new Tr(ir.DIV_BY_ZERO):1/Math.sin(e)))}sinh(e,t){return this.runFunction(e.args,t,this.metadata("SINH"),Math.sinh)}asinh(e,t){return this.runFunction(e.args,t,this.metadata("ASINH"),Math.asinh)}cosh(e,t){return this.runFunction(e.args,t,this.metadata("COSH"),Math.cosh)}acosh(e,t){return this.runFunction(e.args,t,this.metadata("ACOSH"),Math.acosh)}tanh(e,t){return this.runFunction(e.args,t,this.metadata("TANH"),Math.tanh)}atanh(e,t){return this.runFunction(e.args,t,this.metadata("ATANH"),Math.atanh)}coth(e,t){return this.runFunction(e.args,t,this.metadata("COTH"),(e=>0===e?new Tr(ir.DIV_BY_ZERO):1/Math.tanh(e)))}acoth(e,t){return this.runFunction(e.args,t,this.metadata("ACOTH"),(e=>0===e?new Tr(ir.NUM,Z.NonZero):Math.atanh(1/e)))}sech(e,t){return this.runFunction(e.args,t,this.metadata("SECH"),(e=>1/Math.cosh(e)))}csch(e,t){return this.runFunction(e.args,t,this.metadata("CSCH"),(e=>0===e?new Tr(ir.DIV_BY_ZERO):1/Math.sinh(e)))}}pa.implementedFunctions={ACOS:{method:"acos",parameters:[{argumentType:hn.NUMBER}]},ASIN:{method:"asin",parameters:[{argumentType:hn.NUMBER}]},COS:{method:"cos",parameters:[{argumentType:hn.NUMBER}]},SIN:{method:"sin",parameters:[{argumentType:hn.NUMBER}]},TAN:{method:"tan",parameters:[{argumentType:hn.NUMBER}]},ATAN:{method:"atan",parameters:[{argumentType:hn.NUMBER}]},ATAN2:{method:"atan2",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]},COT:{method:"cot",parameters:[{argumentType:hn.NUMBER}]},SEC:{method:"sec",parameters:[{argumentType:hn.NUMBER}]},CSC:{method:"csc",parameters:[{argumentType:hn.NUMBER}]},SINH:{method:"sinh",parameters:[{argumentType:hn.NUMBER}]},COSH:{method:"cosh",parameters:[{argumentType:hn.NUMBER}]},TANH:{method:"tanh",parameters:[{argumentType:hn.NUMBER}]},COTH:{method:"coth",parameters:[{argumentType:hn.NUMBER}]},SECH:{method:"sech",parameters:[{argumentType:hn.NUMBER}]},CSCH:{method:"csch",parameters:[{argumentType:hn.NUMBER}]},ACOT:{method:"acot",parameters:[{argumentType:hn.NUMBER}]},ASINH:{method:"asinh",parameters:[{argumentType:hn.NUMBER}]},ACOSH:{method:"acosh",parameters:[{argumentType:hn.NUMBER}]},ATANH:{method:"atanh",parameters:[{argumentType:hn.NUMBER}]},ACOTH:{method:"acoth",parameters:[{argumentType:hn.NUMBER}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ga extends Oi{constructor(e){super(e),this.dependencyGraph=e}find(e,t,r){return this.basicFind(e,t,"col",r)}}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class fa extends un{constructor(){super(...arguments),this.rowSearch=new ga(this.dependencyGraph)}vlookup(e,t){return this.runFunction(e.args,t,this.metadata("VLOOKUP"),((e,t,r,n)=>{const s=t.range;return void 0===s?new Tr(ir.VALUE,Z.WrongType):r<1?new Tr(ir.VALUE,Z.LessThanOne):r>s.width()?new Tr(ir.REF,Z.IndexLarge):this.doVlookup(qr(e),t,r-1,n)}))}hlookup(e,t){return this.runFunction(e.args,t,this.metadata("HLOOKUP"),((e,t,r,n)=>{const s=t.range;return void 0===s?new Tr(ir.VALUE,Z.WrongType):r<1?new Tr(ir.VALUE,Z.LessThanOne):r>s.height()?new Tr(ir.REF,Z.IndexLarge):this.doHlookup(qr(e),t,r-1,n)}))}match(e,t){return this.runFunction(e.args,t,this.metadata("MATCH"),((e,t,r)=>this.doMatch(qr(e),t,r)))}searchInRange(e,t,r,n){if(!r&&"string"==typeof e&&this.arithmeticHelper.requiresRegex(e))return n.advancedFind(this.arithmeticHelper.eqMatcherFunction(e),t);{const s=r?{ordering:"asc"}:{ordering:"none",matchExactly:!0};return n.find(e,t,s)}}doVlookup(e,t,r,n){this.dependencyGraph.stats.start(et.VLOOKUP);const s=t.range;let i;i=void 0===s?rt.onlyValues(t.data.map((e=>[e[0]]))):rt.onlyRange(Fr.spanFrom(s.start,1,s.height()),this.dependencyGraph);const o=this.searchInRange(e,i,n,this.columnSearch);if(this.dependencyGraph.stats.end(et.VLOOKUP),-1===o)return new Tr(ir.NA,Z.ValueNotFound);let a;if(void 0===s)a=t.data[o][r];else{const e=Ar(s.sheet,s.start.col+r,s.start.row+o);a=this.dependencyGraph.getCellValue(e)}return a instanceof rt?new Tr(ir.VALUE,Z.WrongType):a}doHlookup(e,t,r,n){const s=t.range;let i;i=void 0===s?rt.onlyValues([t.data[0]]):rt.onlyRange(Fr.spanFrom(s.start,s.width(),1),this.dependencyGraph);const o=this.searchInRange(e,i,n,this.rowSearch);if(-1===o)return new Tr(ir.NA,Z.ValueNotFound);let a;if(void 0===s)a=t.data[r][o];else{const e=Ar(s.sheet,s.start.col+o,s.start.row+r);a=this.dependencyGraph.getCellValue(e)}return a instanceof rt?new Tr(ir.VALUE,Z.WrongType):a}doMatch(e,t,r){if(![-1,0,1].includes(r))return new Tr(ir.VALUE,Z.BadMode);if(t.width()>1&&t.height()>1)return new Tr(ir.NA);const n=0===r?{ordering:"none",matchExactly:!0}:{ordering:-1===r?"desc":"asc"},s=(1===t.width()?this.columnSearch:this.rowSearch).find(e,t,n);return-1===s?new Tr(ir.NA,Z.ValueNotFound):s+1}}fa.implementedFunctions={VLOOKUP:{method:"vlookup",parameters:[{argumentType:hn.NOERROR},{argumentType:hn.RANGE},{argumentType:hn.NUMBER},{argumentType:hn.BOOLEAN,defaultValue:!0}]},HLOOKUP:{method:"hlookup",parameters:[{argumentType:hn.NOERROR},{argumentType:hn.RANGE},{argumentType:hn.NUMBER},{argumentType:hn.BOOLEAN,defaultValue:!0}]},MATCH:{method:"match",parameters:[{argumentType:hn.NOERROR},{argumentType:hn.RANGE},{argumentType:hn.NUMBER,defaultValue:1}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ma extends un{roman(e,t){return this.runFunction(e.args,t,this.metadata("ROMAN"),((e,t)=>(e=Math.trunc(e),!1===t?t=4:!0===t&&(t=0),(t=Ge(this.coerceScalarToNumberOrError(t)))instanceof Tr?t:(t=Math.trunc(t))<0?new Tr(ir.VALUE,Z.ValueSmall):t>4?new Tr(ir.VALUE,Z.ValueLarge):function(e,t){const r={val:e%1e3,acc:"M".repeat(Math.floor(e/1e3))};4===t&&(Ea(r,"IM",999,1e3),Ea(r,"ID",499,500));t>=3&&(Ea(r,"VM",995,1e3),Ea(r,"VD",495,500));t>=2&&(Ea(r,"XM",990,1e3),Ea(r,"XD",490,500));t>=1&&(Ea(r,"LM",950,1e3),Ea(r,"LD",450,500));Ea(r,"CM",900,1e3),Ea(r,"CD",400,500),Ea(r,"D",500,900),r.acc+="C".repeat(Math.floor(r.val/100)),r.val%=100,t>=2&&(Ea(r,"IC",99,100),Ea(r,"IL",49,50));t>=1&&(Ea(r,"VC",95,100),Ea(r,"VL",45,50));return Ea(r,"XC",90,100),Ea(r,"XL",40,50),Ea(r,"L",50,90),r.acc+="X".repeat(Math.floor(r.val/10)),r.val%=10,Ea(r,"IX",9,10),Ea(r,"IV",4,5),Ea(r,"V",5,9),r.acc+="I".repeat(r.val),r.acc}(e,t))))}arabic(e,t){return this.runFunction(e.args,t,this.metadata("ARABIC"),(e=>{let t=!1;if((e=e.trim().toUpperCase()).startsWith("-")&&(t=!0,""===(e=e.slice(1))))return new Tr(ir.VALUE,Z.InvalidRoman);const r={input:e,acc:0};return ya(r,{token:"MMM",val:3e3},{token:"MM",val:2e3},{token:"M",val:1e3}),ya(r,{token:"IM",val:999},{token:"VM",val:995},{token:"XM",val:990},{token:"LM",val:950},{token:"CM",val:900}),ya(r,{token:"D",val:500},{token:"ID",val:499},{token:"VD",val:495},{token:"XD",val:490},{token:"LD",val:450},{token:"CD",val:400}),ya(r,{token:"CCC",val:300},{token:"CC",val:200},{token:"C",val:100}),ya(r,{token:"IC",val:99},{token:"VC",val:95},{token:"XC",val:90}),ya(r,{token:"L",val:50},{token:"IL",val:49},{token:"VL",val:45},{token:"XL",val:40}),ya(r,{token:"XXX",val:30},{token:"XX",val:20},{token:"X",val:10}),ya(r,{token:"IX",val:9}),ya(r,{token:"V",val:5},{token:"IV",val:4}),ya(r,{token:"III",val:3},{token:"II",val:2},{token:"I",val:1}),""!==r.input?new Tr(ir.VALUE,Z.InvalidRoman):t?-r.acc:r.acc}))}}function ya(e,...t){for(const r of t)if(e.input.startsWith(r.token)){e.input=e.input.slice(r.token.length),e.acc+=r.val;break}}function Ea(e,t,r,n){e.val>=r&&e.val<n&&(e.val-=r,e.acc+=t)}ma.implementedFunctions={ROMAN:{method:"roman",parameters:[{argumentType:hn.NUMBER,minValue:1,lessThan:4e3},{argumentType:hn.NOERROR,optionalArg:!0,defaultValue:0}]},ARABIC:{method:"arabic",parameters:[{argumentType:hn.STRING}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class wa extends un{add(e,t){return this.runFunction(e.args,t,this.metadata("HF.ADD"),this.arithmeticHelper.addWithEpsilon)}concat(e,t){return this.runFunction(e.args,t,this.metadata("HF.CONCAT"),this.arithmeticHelper.concat)}divide(e,t){return this.runFunction(e.args,t,this.metadata("HF.DIVIDE"),this.arithmeticHelper.divide)}eq(e,t){return this.runFunction(e.args,t,this.metadata("HF.EQ"),this.arithmeticHelper.eq)}gt(e,t){return this.runFunction(e.args,t,this.metadata("HF.GT"),this.arithmeticHelper.gt)}gte(e,t){return this.runFunction(e.args,t,this.metadata("HF.GTE"),this.arithmeticHelper.geq)}lt(e,t){return this.runFunction(e.args,t,this.metadata("HF.LT"),this.arithmeticHelper.lt)}lte(e,t){return this.runFunction(e.args,t,this.metadata("HF.LTE"),this.arithmeticHelper.leq)}minus(e,t){return this.runFunction(e.args,t,this.metadata("HF.MINUS"),this.arithmeticHelper.subtract)}multiply(e,t){return this.runFunction(e.args,t,this.metadata("HF.MULTIPLY"),this.arithmeticHelper.multiply)}ne(e,t){return this.runFunction(e.args,t,this.metadata("HF.NE"),this.arithmeticHelper.neq)}pow(e,t){return this.runFunction(e.args,t,this.metadata("HF.POW"),this.arithmeticHelper.pow)}uminus(e,t){return this.runFunction(e.args,t,this.metadata("HF.UMINUS"),this.arithmeticHelper.unaryMinus)}upercent(e,t){return this.runFunction(e.args,t,this.metadata("HF.UNARY_PERCENT"),this.arithmeticHelper.unaryPercent)}uplus(e,t){return this.runFunction(e.args,t,this.metadata("HF.UPLUS"),this.arithmeticHelper.unaryPlus)}}wa.implementedFunctions={"HF.ADD":{method:"add",parameters:[{argumentType:hn.NUMBER,passSubtype:!0},{argumentType:hn.NUMBER,passSubtype:!0}]},"HF.CONCAT":{method:"concat",parameters:[{argumentType:hn.STRING,passSubtype:!0},{argumentType:hn.STRING,passSubtype:!0}]},"HF.DIVIDE":{method:"divide",parameters:[{argumentType:hn.NUMBER,passSubtype:!0},{argumentType:hn.NUMBER,passSubtype:!0}]},"HF.EQ":{method:"eq",parameters:[{argumentType:hn.NOERROR,passSubtype:!0},{argumentType:hn.NOERROR,passSubtype:!0}]},"HF.GT":{method:"gt",parameters:[{argumentType:hn.NOERROR,passSubtype:!0},{argumentType:hn.NOERROR,passSubtype:!0}]},"HF.GTE":{method:"gte",parameters:[{argumentType:hn.NOERROR,passSubtype:!0},{argumentType:hn.NOERROR,passSubtype:!0}]},"HF.LT":{method:"lt",parameters:[{argumentType:hn.NOERROR,passSubtype:!0},{argumentType:hn.NOERROR,passSubtype:!0}]},"HF.LTE":{method:"lte",parameters:[{argumentType:hn.NOERROR,passSubtype:!0},{argumentType:hn.NOERROR,passSubtype:!0}]},"HF.MINUS":{method:"minus",parameters:[{argumentType:hn.NUMBER,passSubtype:!0},{argumentType:hn.NUMBER,passSubtype:!0}]},"HF.MULTIPLY":{method:"multiply",parameters:[{argumentType:hn.NUMBER,passSubtype:!0},{argumentType:hn.NUMBER,passSubtype:!0}]},"HF.NE":{method:"ne",parameters:[{argumentType:hn.NOERROR,passSubtype:!0},{argumentType:hn.NOERROR,passSubtype:!0}]},"HF.POW":{method:"pow",parameters:[{argumentType:hn.NUMBER,passSubtype:!0},{argumentType:hn.NUMBER,passSubtype:!0}]},"HF.UMINUS":{method:"uminus",parameters:[{argumentType:hn.NUMBER,passSubtype:!0}]},"HF.UNARY_PERCENT":{method:"upercent",parameters:[{argumentType:hn.NUMBER,passSubtype:!0}]},"HF.UPLUS":{method:"uplus",parameters:[{argumentType:hn.NUMBER,passSubtype:!0}]}};
/**
 * @license
 bessel.js (C) 2013-present SheetJS -- http://sheetjs.com

 Apache License
 Version 2.0, January 2004
 http://www.apache.org/licenses/

 TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

 1. Definitions.

 "License" shall mean the terms and conditions for use, reproduction,
 and distribution as defined by Sections 1 through 9 of this document.

 "Licensor" shall mean the copyright owner or entity authorized by
 the copyright owner that is granting the License.

 "Legal Entity" shall mean the union of the acting entity and all
 other entities that control, are controlled by, or are under common
 control with that entity. For the purposes of this definition,
 "control" means (i) the power, direct or indirect, to cause the
 direction or management of such entity, whether by contract or
 otherwise, or (ii) ownership of fifty percent (50%) or more of the
 outstanding shares, or (iii) beneficial ownership of such entity.

 "You" (or "Your") shall mean an individual or Legal Entity
 exercising permissions granted by this License.

 "Source" form shall mean the preferred form for making modifications,
 including but not limited to software source code, documentation
 source, and configuration files.

 "Object" form shall mean any form resulting from mechanical
 transformation or translation of a Source form, including but
 not limited to compiled object code, generated documentation,
 and conversions to other media types.

 "Work" shall mean the work of authorship, whether in Source or
 Object form, made available under the License, as indicated by a
 copyright notice that is included in or attached to the work
 (an example is provided in the Appendix below).

 "Derivative Works" shall mean any work, whether in Source or Object
 form, that is based on (or derived from) the Work and for which the
 editorial revisions, annotations, elaborations, or other modifications
 represent, as a whole, an original work of authorship. For the purposes
 of this License, Derivative Works shall not include works that remain
 separable from, or merely link (or bind by name) to the interfaces of,
 the Work and Derivative Works thereof.

 "Contribution" shall mean any work of authorship, including
 the original version of the Work and any modifications or additions
 to that Work or Derivative Works thereof, that is intentionally
 submitted to Licensor for inclusion in the Work by the copyright owner
 or by an individual or Legal Entity authorized to submit on behalf of
 the copyright owner. For the purposes of this definition, "submitted"
 means any form of electronic, verbal, or written communication sent
 to the Licensor or its representatives, including but not limited to
 communication on electronic mailing lists, source code control systems,
 and issue tracking systems that are managed by, or on behalf of, the
 Licensor for the purpose of discussing and improving the Work, but
 excluding communication that is conspicuously marked or otherwise
 designated in writing by the copyright owner as "Not a Contribution."

 "Contributor" shall mean Licensor and any individual or Legal Entity
 on behalf of whom a Contribution has been received by Licensor and
 subsequently incorporated within the Work.

 2. Grant of Copyright License. Subject to the terms and conditions of
 this License, each Contributor hereby grants to You a perpetual,
 worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 copyright license to reproduce, prepare Derivative Works of,
 publicly display, publicly perform, sublicense, and distribute the
 Work and such Derivative Works in Source or Object form.

 3. Grant of Patent License. Subject to the terms and conditions of
 this License, each Contributor hereby grants to You a perpetual,
 worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 (except as stated in this section) patent license to make, have made,
 use, offer to sell, sell, import, and otherwise transfer the Work,
 where such license applies only to those patent claims licensable
 by such Contributor that are necessarily infringed by their
 Contribution(s) alone or by combination of their Contribution(s)
 with the Work to which such Contribution(s) was submitted. If You
 institute patent litigation against any entity (including a
 cross-claim or counterclaim in a lawsuit) alleging that the Work
 or a Contribution incorporated within the Work constitutes direct
 or contributory patent infringement, then any patent licenses
 granted to You under this License for that Work shall terminate
 as of the date such litigation is filed.

 4. Redistribution. You may reproduce and distribute copies of the
 Work or Derivative Works thereof in any medium, with or without
 modifications, and in Source or Object form, provided that You
 meet the following conditions:

 (a) You must give any other recipients of the Work or
 Derivative Works a copy of this License; and

 (b) You must cause any modified files to carry prominent notices
 stating that You changed the files; and

 (c) You must retain, in the Source form of any Derivative Works
 that You distribute, all copyright, patent, trademark, and
 attribution notices from the Source form of the Work,
 excluding those notices that do not pertain to any part of
 the Derivative Works; and

 (d) If the Work includes a "NOTICE" text file as part of its
 distribution, then any Derivative Works that You distribute must
 include a readable copy of the attribution notices contained
 within such NOTICE file, excluding those notices that do not
 pertain to any part of the Derivative Works, in at least one
 of the following places: within a NOTICE text file distributed
 as part of the Derivative Works; within the Source form or
 documentation, if provided along with the Derivative Works; or,
 within a display generated by the Derivative Works, if and
 wherever such third-party notices normally appear. The contents
 of the NOTICE file are for informational purposes only and
 do not modify the License. You may add Your own attribution
 notices within Derivative Works that You distribute, alongside
 or as an addendum to the NOTICE text from the Work, provided
 that such additional attribution notices cannot be construed
 as modifying the License.

 You may add Your own copyright statement to Your modifications and
 may provide additional or different license terms and conditions
 for use, reproduction, or distribution of Your modifications, or
 for any such Derivative Works as a whole, provided Your use,
 reproduction, and distribution of the Work otherwise complies with
 the conditions stated in this License.

 5. Submission of Contributions. Unless You explicitly state otherwise,
 any Contribution intentionally submitted for inclusion in the Work
 by You to the Licensor shall be under the terms and conditions of
 this License, without any additional terms or conditions.
 Notwithstanding the above, nothing herein shall supersede or modify
 the terms of any separate license agreement you may have executed
 with Licensor regarding such Contributions.

 6. Trademarks. This License does not grant permission to use the trade
 names, trademarks, service marks, or product names of the Licensor,
 except as required for reasonable and customary use in describing the
 origin of the Work and reproducing the content of the NOTICE file.

 7. Disclaimer of Warranty. Unless required by applicable law or
 agreed to in writing, Licensor provides the Work (and each
 Contributor provides its Contributions) on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 implied, including, without limitation, any warranties or conditions
 of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
 PARTICULAR PURPOSE. You are solely responsible for determining the
 appropriateness of using or redistributing the Work and assume any
 risks associated with Your exercise of permissions under this License.

 8. Limitation of Liability. In no event and under no legal theory,
 whether in tort (including negligence), contract, or otherwise,
 unless required by applicable law (such as deliberate and grossly
 negligent acts) or agreed to in writing, shall any Contributor be
 liable to You for damages, including any direct, indirect, special,
 incidental, or consequential damages of any character arising as a
 result of this License or out of the use or inability to use the
 Work (including but not limited to damages for loss of goodwill,
 work stoppage, computer failure or malfunction, or any and all
 other commercial damages or losses), even if such Contributor
 has been advised of the possibility of such damages.

 9. Accepting Warranty or Additional Liability. While redistributing
 the Work or Derivative Works thereof, You may choose to offer,
 and charge a fee for, acceptance of support, warranty, indemnity,
 or other liability obligations and/or rights consistent with this
 License. However, in accepting such obligations, You may act only
 on Your own behalf and on Your sole responsibility, not on behalf
 of any other Contributor, and only if You agree to indemnify,
 defend, and hold each Contributor harmless for any liability
 incurred by, or claims asserted against, such Contributor by reason
 of your accepting any such warranty or additional liability.

 END OF TERMS AND CONDITIONS

 APPENDIX: How to apply the Apache License to your work.

 To apply the Apache License to your work, attach the following
 boilerplate notice, with the fields enclosed by brackets "{}"
 replaced with your own identifying information. (Don't include
 the brackets!)  The text should be enclosed in the appropriate
 comment syntax for the file format. We also recommend that a
 file or class name and description of purpose be included on the
 same "printed page" as the copyright notice for easier
 identification within third-party archives.

 Copyright (C) 2013-present   SheetJS LLC

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 */
var Ca=Math;function va(e,t){for(var r=0,n=0;r<e.length;++r)n=t*n+e[r];return n}function Ra(e,t,r,n,s){if(0===t)return r;if(1===t)return n;for(var i=2/e,o=n,a=1;a<t;++a)o=n*a*i+s*r,r=n,n=o;return o}function Sa(e,t,r,n,s){return function(r,i){if(n){if(0===r)return 1==n?-1/0:1/0;if(r<0)return NaN}return 0===i?e(r):1===i?t(r):i<0?NaN:Ra(r,i|=0,e(r),t(r),s)}}var Ta,Na,Ma,_a,ba,Aa,Oa,Ia,xa,Pa,La,Da,ka,Ha=function(){var e=.636619772,t=[57568490574,-13362590354,651619640.7,-11214424.18,77392.33017,-184.9052456].reverse(),r=[57568490411,1029532985,9494680.718,59272.64853,267.8532712,1].reverse(),n=[1,-.001098628627,2734510407e-14,-2073370639e-15,2.093887211e-7].reverse(),s=[-.01562499995,.0001430488765,-6911147651e-15,7.621095161e-7,-9.34935152e-8].reverse();function i(i){var o=0,a=0,l=0,h=i*i;if(i<8)o=(a=va(t,h))/(l=va(r,h));else{var u=i-.785398164;a=va(n,h=64/h),l=va(s,h),o=Ca.sqrt(e/i)*(Ca.cos(u)*a-Ca.sin(u)*l*8/i)}return o}var o=[72362614232,-7895059235,242396853.1,-2972611.439,15704.4826,-30.16036606].reverse(),a=[144725228442,2300535178,18583304.74,99447.43394,376.9991397,1].reverse(),l=[1,.00183105,-3516396496e-14,2457520174e-15,-2.40337019e-7].reverse(),h=[.04687499995,-.0002002690873,8449199096e-15,-8.8228987e-7,1.05787412e-7].reverse();function u(t){var r=0,n=0,s=0,i=t*t,u=Ca.abs(t)-2.356194491;return Math.abs(t)<8?r=(n=t*va(o,i))/(s=va(a,i)):(n=va(l,i=64/i),s=va(h,i),r=Ca.sqrt(e/Ca.abs(t))*(Ca.cos(u)*n-Ca.sin(u)*s*8/Ca.abs(t)),t<0&&(r=-r)),r}return function e(t,r){if(r=Math.round(r),!isFinite(t))return isNaN(t)?t:0;if(r<0)return(r%2?-1:1)*e(t,-r);if(t<0)return(r%2?-1:1)*e(-t,r);if(0===r)return i(t);if(1===r)return u(t);if(0===t)return 0;var n=0;if(t>r)n=Ra(t,r,i(t),u(t),-1);else{for(var s=!1,o=0,a=0,l=1,h=0,c=2/t,d=2*Ca.floor((r+Ca.floor(Ca.sqrt(40*r)))/2);d>0;d--)h=d*c*l-o,o=l,l=h,Ca.abs(l)>1e10&&(l*=1e-10,o*=1e-10,n*=1e-10,a*=1e-10),s&&(a+=l),s=!s,d==r&&(n=o);n/=a=2*a-l}return n}}(),Fa=(Ta=.636619772,Na=[-2957821389,7062834065,-512359803.6,10879881.29,-86327.92757,228.4622733].reverse(),Ma=[40076544269,745249964.8,7189466.438,47447.2647,226.1030244,1].reverse(),_a=[1,-.001098628627,2734510407e-14,-2073370639e-15,2.093887211e-7].reverse(),ba=[-.01562499995,.0001430488765,-6911147651e-15,7.621095161e-7,-9.34945152e-8].reverse(),Aa=[-4900604943e3,127527439e4,-51534381390,734926455.1,-4237922.726,8511.937935].reverse(),Oa=[249958057e5,424441966400,3733650367,22459040.02,102042.605,354.9632885,1].reverse(),Ia=[1,.00183105,-3516396496e-14,2457520174e-15,-2.40337019e-7].reverse(),xa=[.04687499995,-.0002002690873,8449199096e-15,-8.8228987e-7,1.05787412e-7].reverse(),Sa((function(e){var t=0,r=0,n=0,s=e*e,i=e-.785398164;return e<8?t=(r=va(Na,s))/(n=va(Ma,s))+Ta*Ha(e,0)*Ca.log(e):(r=va(_a,s=64/s),n=va(ba,s),t=Ca.sqrt(Ta/e)*(Ca.sin(i)*r+Ca.cos(i)*n*8/e)),t}),(function(e){var t=0,r=0,n=0,s=e*e,i=e-2.356194491;return e<8?t=(r=e*va(Aa,s))/(n=va(Oa,s))+Ta*(Ha(e,1)*Ca.log(e)-1/e):(r=va(Ia,s=64/s),n=va(xa,s),t=Ca.sqrt(Ta/e)*(Ca.sin(i)*r+Ca.cos(i)*n*8/e)),t}),0,1,-1)),Ua=(Pa=[1,3.5156229,3.0899424,1.2067492,.2659732,.0360768,.0045813].reverse(),La=[.39894228,.01328592,.00225319,-.00157565,.00916281,-.02057706,.02635537,-.01647633,.00392377].reverse(),Da=[.5,.87890594,.51498869,.15084934,.02658733,.00301532,32411e-8].reverse(),ka=[.39894228,-.03988024,-.00362018,.00163801,-.01031555,.02282967,-.02895312,.01787654,-.00420059].reverse(),function e(t,r){if(0===(r=Math.round(r)))return function(e){return e<=3.75?va(Pa,e*e/14.0625):Ca.exp(Ca.abs(e))/Ca.sqrt(Ca.abs(e))*va(La,3.75/Ca.abs(e))}(t);if(1===r)return function(e){return e<3.75?e*va(Da,e*e/14.0625):(e<0?-1:1)*Ca.exp(Ca.abs(e))/Ca.sqrt(Ca.abs(e))*va(ka,3.75/Ca.abs(e))}(t);if(r<0)return NaN;if(0===Ca.abs(t))return 0;if(t==1/0)return 1/0;var n,s=0,i=2/Ca.abs(t),o=0,a=1,l=0;for(n=2*Ca.round((r+Ca.round(Ca.sqrt(40*r)))/2);n>0;n--)l=n*i*a+o,o=a,a=l,Ca.abs(a)>1e10&&(a*=1e-10,o*=1e-10,s*=1e-10),n==r&&(s=o);return s*=e(t,0)/a,t<0&&r%2?-s:s}),Va=function(){var e=[-.57721566,.4227842,.23069756,.0348859,.00262698,1075e-7,74e-7].reverse(),t=[1.25331414,-.07832358,.02189568,-.01062446,.00587872,-.0025154,53208e-8].reverse();var r=[1,.15443144,-.67278579,-.18156897,-.01919402,-.00110404,-4686e-8].reverse(),n=[1.25331414,.23498619,-.0365562,.01504268,-.00780353,.00325614,-68245e-8].reverse();return Sa((function(r){return r<=2?-Ca.log(r/2)*Ua(r,0)+va(e,r*r/4):Ca.exp(-r)/Ca.sqrt(r)*va(t,2/r)}),(function(e){return e<=2?Ca.log(e/2)*Ua(e,1)+1/e*va(r,e*e/4):Ca.exp(-e)/Ca.sqrt(e)*va(n,2/e)}),0,2,1)}();
/**
 * @license
 Copyright (c) 2013 jStat

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 */
function Ba(e){const t=[-1.3026537197817094,.6419697923564902,.019476473204185836,-.00956151478680863,-.000946595344482036,.000366839497852761,42523324806907e-18,-20278578112534e-18,-1624290004647e-18,130365583558e-17,1.5626441722e-8,-8.5238095915e-8,6.529054439e-9,5.059343495e-9,-9.91364156e-10,-2.27365122e-10,96467911e-18,2394038e-18,-6886027e-18,894487e-18,313092e-18,-112708e-18,381e-18,7106e-18,-1523e-18,-94e-18,121e-18,-28e-18];let r,n,s,i,o=t.length-1,a=!1,l=0,h=0;if(0===e)return 0;for(e<0&&(e=-e,a=!0),r=2/(2+e),n=4*r-2;o>0;o--)s=l,l=n*l-h+t[o],h=s;return i=r*Math.exp(-e*e+.5*(t[0]+n*l)-h),a?i-1:1-i}function Wa(e){return 1-Ba(e)}function Ya(e){let t,r,n,s,i=0;if(e>=2)return-100;if(e<=0)return 100;for(s=e<1?e:2-e,n=Math.sqrt(-2*Math.log(s/2)),t=-.70711*((2.30753+.27061*n)/(1+n*(.99229+.04481*n))-n);i<2;i++)r=Wa(t)-s,t+=r/(1.1283791670955126*Math.exp(-t*t)-t*r);return e<1?t:-t}const Ga=(e,t)=>e<0?0:t*Math.exp(-t*e),ja=(e,t)=>e<0?0:1-Math.exp(-t*e);function za(e){const t=[-1.716185138865495,24.76565080557592,-379.80425647094563,629.3311553128184,866.9662027904133,-31451.272968848367,-36144.413418691176,66456.14382024054],r=[-30.8402300119739,315.35062697960416,-1015.1563674902192,-3107.771671572311,22538.11842098015,4755.846277527881,-134659.9598649693,-115132.2596755535];let n,s,i,o,a=!1,l=0,h=0,u=0,c=e;if(e>171.6243769536076)return 1/0;if(c<=0){if(o=c%1,!o)return 1/0;a=(1&c?-1:1)*Math.PI/Math.sin(Math.PI*o),c=1-c}for(i=c,s=c<1?c++:(c-=l=(0|c)-1)-1,n=0;n<8;++n)u=(u+t[n])*s,h=h*s+r[n];if(o=u/h+1,i<c)o/=i;else if(i>c)for(n=0;n<l;++n)o*=c,c++;return a&&(o=a/o),o}const $a=function(e,t,r){return e<0?0:0===e&&1===t?1/r:Math.exp((t-1)*Math.log(e)-e/r-qa(t)-t*Math.log(r))},Ka=function(e,t,r){return e<0?0:Qa(t,e/r)},Xa=function(e,t,r){return Za(e,t)*r};function qa(e){let t=0;const r=[76.18009172947146,-86.50532032941678,24.01409824083091,-1.231739572450155,.001208650973866179,-5395239384953e-18];let n,s,i,o=1.000000000190015;for(i=(s=n=e)+5.5,i-=(n+.5)*Math.log(i);t<6;t++)o+=r[t]/++s;return Math.log(2.5066282746310007*o/n)-i}function Qa(e,t){const r=qa(e);let n=e,s=1/e,i=s,o=t+1-e,a=1/1e-30,l=1/o,h=l,u=1;const c=-~(8.5*Math.log(e>=1?e:1/e)+.4*e+17);let d;if(t<0||e<=0)return NaN;if(t<e+1){for(;u<=c;u++)s+=i*=t/++n;return s*Math.exp(-t+e*Math.log(t)-r)}for(;u<=c;u++)d=-u*(u-e),o+=2,l=d*l+o,a=o+d/a,l=1/l,h*=l*a;return 1-h*Math.exp(-t+e*Math.log(t)-r)}function Za(e,t){let r=0;const n=t-1,s=qa(t);let i,o,a,l,h,u,c;if(e>=1)return Math.max(100,t+100*Math.sqrt(t));if(e<=0)return 0;for(t>1?(u=Math.log(n),c=Math.exp(n*(u-1)-s),h=e<.5?e:1-e,a=Math.sqrt(-2*Math.log(h)),i=(2.30753+.27061*a)/(1+a*(.99229+.04481*a))-a,e<.5&&(i=-i),i=Math.max(.001,t*Math.pow(1-1/(9*t)-i/(3*Math.sqrt(t)),3))):(a=1-t*(.253+.12*t),i=e<a?Math.pow(e/a,1/t):1-Math.log(1-(e-a)/(1-a)));r<12;r++){if(i<=0)return 0;if(o=Qa(t,i)-e,a=t>1?c*Math.exp(-(i-n)+n*(Math.log(i)-u)):Math.exp(-i+n*Math.log(i)-s),l=o/a,i-=a=l/(1-.5*Math.min(1,l*((t-1)/i-1))),i<=0&&(i=.5*(i+a)),Math.abs(a)<1e-8*i)break}return i}const Ja=function(e,t,r){return Math.exp(-.5*Math.log(2*Math.PI)-Math.log(r)-Math.pow(e-t,2)/(2*r*r))},el=function(e,t,r){return.5*(1+Ba((e-t)/Math.sqrt(2*r*r)))},tl=function(e,t,r){return-1.4142135623730951*r*Ya(2*e)+t},rl=function(e,t,r){return e>1||e<0?0:1==t&&1==r?1:t<512&&r<512?Math.pow(e,t-1)*Math.pow(1-e,r-1)/il(t,r):Math.exp((t-1)*Math.log(e)+(r-1)*Math.log(1-e)-ol(t,r))},nl=function(e,t,r){return e>1||e<0?+(e>1):ll(e,t,r)},sl=function(e,t,r){return al(e,t,r)};function il(e,t){if(!(e<=0||t<=0))return e+t>170?Math.exp(ol(e,t)):za(e)*za(t)/za(e+t)}function ol(e,t){return qa(e)+qa(t)-qa(e+t)}function al(e,t,r){var n,s,i,o,a,l,h,u,c,d,p=t-1,g=r-1,f=0;if(e<=0)return 0;if(e>=1)return 1;for(t>=1&&r>=1?(i=e<.5?e:1-e,l=(2.30753+.27061*(o=Math.sqrt(-2*Math.log(i))))/(1+o*(.99229+.04481*o))-o,e<.5&&(l=-l),h=(l*l-3)/6,u=2/(1/(2*t-1)+1/(2*r-1)),c=l*Math.sqrt(h+u)/u-(1/(2*r-1)-1/(2*t-1))*(h+5/6-2/(3*u)),l=t/(t+r*Math.exp(2*c))):(n=Math.log(t/(t+r)),s=Math.log(r/(t+r)),l=e<(o=Math.exp(t*n)/t)/(c=o+(a=Math.exp(r*s)/r))?Math.pow(t*c*e,1/t):1-Math.pow(r*c*(1-e),1/r)),d=-qa(t)-qa(r)+qa(t+r);f<10;f++){if(0===l||1===l)return l;if((l-=o=(a=(ll(l,t,r)-e)/(o=Math.exp(p*Math.log(l)+g*Math.log(1-l)+d)))/(1-.5*Math.min(1,a*(p/l-g/(1-l)))))<=0&&(l=.5*(l+o)),l>=1&&(l=.5*(l+o+1)),Math.abs(o)<1e-8*l&&f>0)break}return l}function ll(e,t,r){var n=0===e||1===e?0:Math.exp(qa(t+r)-qa(t)-qa(r)+t*Math.log(e)+r*Math.log(1-e));return!(e<0||e>1)&&(e<(t+1)/(t+r+2)?n*hl(e,t,r)/t:1-n*hl(1-e,r,t)/r)}function hl(e,t,r){var n,s,i,o,a=1e-30,l=1,h=t+r,u=t+1,c=t-1,d=1,p=1-h*e/u;for(Math.abs(p)<a&&(p=a),o=p=1/p;l<=100&&(p=1+(s=l*(r-l)*e/((c+(n=2*l))*(t+n)))*p,Math.abs(p)<a&&(p=a),d=1+s/d,Math.abs(d)<a&&(d=a),o*=(p=1/p)*d,p=1+(s=-(t+l)*(h+l)*e/((t+n)*(u+n)))*p,Math.abs(p)<a&&(p=a),d=1+s/d,Math.abs(d)<a&&(d=a),o*=i=(p=1/p)*d,!(Math.abs(i-1)<3e-7));l++);return o}const ul=function(e,t,r){return 0===r||1===r?t*r===e?1:0:pl(t,e)*Math.pow(r,e)*Math.pow(1-r,t-e)},cl=function(e,t,r){var n,s=1e-10;if(e<0)return 0;if(e>=t)return 1;if(r<0||r>1||t<=0)return NaN;var i=r,o=(e=Math.floor(e))+1,a=t-e,l=o+a,h=Math.exp(qa(l)-qa(a)-qa(o)+o*Math.log(i)+a*Math.log(1-i));return n=i<(o+1)/(l+2)?h*dl(i,o,a,s):1-h*dl(1-i,a,o,s),Math.round(1/s*(1-n))/(1/s)};function dl(e,t,r,n){for(var s,i=0,o=1,a=1,l=1,h=0,u=0;Math.abs((a-u)/a)>n;)u=a,o=l+(s=-(t+h)*(t+r+h)*e/(t+2*h)/(t+2*h+1))*o,a=(i=a+s*i)+(s=(h+=1)*(r-h)*e/(t+2*h-1)/(t+2*h))*a,i/=l=o+s*l,o/=l,a/=l,l=1;return a/t}function pl(e,t){return e>170||t>170?Math.exp(function(e,t){return gl(e)-gl(t)-gl(e-t)}(e,t)):fl(e)/fl(t)/fl(e-t)}function gl(e){return e<0?NaN:qa(e+1)}function fl(e){return e<0?NaN:za(e+1)}const ml=function(e,t){return e<0?0:0===e&&2===t?.5:Math.exp((t/2-1)*Math.log(e)-e/2-t/2*Math.log(2)-qa(t/2))},yl=function(e,t){return e<0?0:Qa(t/2,e/2)},El=function(e,t){return 2*Za(e,.5*t)},wl=function(e,t,r){return e<0?0:t<=2?0===e&&t<2?1/0:0===e&&2===t?1:1/il(t/2,r/2)*Math.pow(t/r,t/2)*Math.pow(e,t/2-1)*Math.pow(1+t/r*e,-(t+r)/2):t*(r/(r+e*t))/2*ul((t-2)/2,(t+r-2)/2,t*e/(r+e*t))},Cl=function(e,t,r){return e<0?0:ll(t*e/(t*e+r),t/2,r/2)},vl=function(e,t,r){return r/(t*(1/al(e,t/2,r/2)-1))},Rl=function(e,t,r){return e<0||t<0||r<0?0:r/t*Math.pow(e/t,r-1)*Math.exp(-Math.pow(e/t,r))},Sl=function(e,t,r){return e<0?0:1-Math.exp(-Math.pow(e/t,r))},Tl={pdf:function(e,t){return t<0||e%1!=0||e<0?0:Math.pow(t,e)*Math.exp(-t)/fl(e)},cdf:function(e,t){var r=0;if(e<0)return 0;for(var n=0;r<=e;r++)n+=Tl.pdf(r,t);return n}},Nl={pdf:function(e,t,r,n){if(e<0||e<r-(t-n))return 0;if(e>n||e>r)return 0;if(2*r>t)return 2*n>t?Nl.pdf(t-r-n+e,t,t-r,t-n):Nl.pdf(n-e,t,t-r,n);if(2*n>t)return Nl.pdf(r-e,t,r,t-n);if(r<n)return Nl.pdf(e,t,n,r);for(var s=1,i=0,o=0;o<e;o++){for(;s>1&&i<n;)s*=1-r/(t-i),i++;s*=(n-o)*(r-o)/((o+1)*(t-r-n+o+1))}for(;i<n;i++)s*=1-r/(t-i);return Math.min(1,Math.max(0,s))},cdf:function e(t,r,n,s){if(t<0||t<n-(r-s))return 0;if(t>=s||t>=n)return 1;if(2*n>r)return 2*s>r?e(r-n-s+t,r,r-n,r-s):1-Nl.cdf(s-t-1,r,r-n,s);if(2*s>r)return 1-Nl.cdf(n-t-1,r,n,r-s);if(n<s)return Nl.cdf(t,r,s,n);for(var i=1,o=1,a=0,l=0;l<t;l++){for(;i>1&&a<s;){var h=1-n/(r-a);o*=h,i*=h,a++}i+=o*=(s-l)*(n-l)/((l+1)*(r-n-s+l+1))}for(;a<s;a++)i*=1-n/(r-a);return Math.min(1,Math.max(0,i))}},Ml=function(e,t){return t=t>1e100?1e100:t,1/(Math.sqrt(t)*il(.5,t/2))*Math.pow(1+e*e/t,-(t+1)/2)},_l=function(e,t){var r=t/2;return ll((e+Math.sqrt(e*e+t))/(2*Math.sqrt(e*e+t)),r,r)},bl=function(e,t){var r=al(2*Math.min(e,1-e),.5*t,.5);return r=Math.sqrt(t*(1-r)/r),e>.5?r:-r},Al=function(e,t,r){return e<=0?0:Math.exp(-Math.log(e)-.5*Math.log(2*Math.PI)-Math.log(r)-Math.pow(Math.log(e)-t,2)/(2*r*r))},Ol=function(e,t,r){return e<0?0:.5+.5*Ba((Math.log(e)-t)/Math.sqrt(2*r*r))},Il=function(e,t,r){return Math.exp(-1.4142135623730951*r*Ya(2*e)+t)},xl={pdf:function(e,t,r){return e===e>>>0&&(e<0?0:pl(e+t-1,t-1)*Math.pow(1-r,e)*Math.pow(r,t))},cdf:function(e,t,r){var n=0,s=0;if(e<0)return 0;for(;s<=e;s++)n+=xl.pdf(s,t,r);return n}};function Pl(e){for(var t=0,r=e.length;--r>=0;)t+=e[r];return t}function Ll(e){return Pl(e)/e.length}function Dl(e){for(var t,r=Ll(e),n=0,s=e.length;--s>=0;)n+=(t=e[s]-r)*t;return n}function kl(e,t){return Dl(e)/(e.length-(t?1:0))}function Hl(e,t){return Math.sqrt(kl(e,t))}function Fl(e,t){var r,n=Ll(e),s=Ll(t),i=e.length,o=new Array(i);for(r=0;r<i;r++)o[r]=(e[r]-n)*(t[r]-s);return Pl(o)/(i-1)}function Ul(e,t){return Fl(e,t)/Hl(e,1)/Hl(t,1)}
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Vl extends un{erf(e,t){return this.runFunction(e.args,t,this.metadata("ERF"),((e,t)=>void 0===t?Ba(e):Ba(t)-Ba(e)))}erfc(e,t){return this.runFunction(e.args,t,this.metadata("ERFC"),Wa)}expondist(e,t){return this.runFunction(e.args,t,this.metadata("EXPON.DIST"),((e,t,r)=>r?ja(e,t):Ga(e,t)))}fisher(e,t){return this.runFunction(e.args,t,this.metadata("FISHER"),(e=>Math.log((1+e)/(1-e))/2))}fisherinv(e,t){return this.runFunction(e.args,t,this.metadata("FISHERINV"),(e=>1-2/(Math.exp(2*e)+1)))}gamma(e,t){return this.runFunction(e.args,t,this.metadata("GAMMA"),za)}gammadist(e,t){return this.runFunction(e.args,t,this.metadata("GAMMA.DIST"),((e,t,r,n)=>n?Ka(e,t,r):$a(e,t,r)))}gammaln(e,t){return this.runFunction(e.args,t,this.metadata("GAMMALN"),qa)}gammainv(e,t){return this.runFunction(e.args,t,this.metadata("GAMMA.INV"),Xa)}gauss(e,t){return this.runFunction(e.args,t,this.metadata("GAUSS"),(e=>el(e,0,1)-.5))}betadist(e,t){return this.runFunction(e.args,t,this.metadata("BETA.DIST"),((e,t,r,n,s,i)=>e<=s?new Tr(ir.NUM,Z.ValueSmall):e>=i?new Tr(ir.NUM,Z.ValueLarge):(e=(e-s)/(i-s),n?nl(e,t,r):rl(e,t,r))))}betainv(e,t){return this.runFunction(e.args,t,this.metadata("BETA.INV"),((e,t,r,n,s)=>n>=s?new Tr(ir.NUM,Z.WrongOrder):sl(e,t,r)*(s-n)+n))}binomialdist(e,t){return this.runFunction(e.args,t,this.metadata("BINOM.DIST"),((e,t,r,n)=>e>t?new Tr(ir.NUM,Z.WrongOrder):(e=Math.trunc(e),t=Math.trunc(t),n?cl(e,t,r):ul(e,t,r))))}binomialinv(e,t){return this.runFunction(e.args,t,this.metadata("BINOM.INV"),((e,t,r)=>{let n=-1,s=e=Math.trunc(e);for(;s>n+1;){const i=Math.trunc((n+s)/2);cl(i,e,t)>=r?s=i:n=i}return s}))}besselifn(e,t){return this.runFunction(e.args,t,this.metadata("BESSELI"),((e,t)=>Ua(e,Math.trunc(t))))}besseljfn(e,t){return this.runFunction(e.args,t,this.metadata("BESSELJ"),((e,t)=>Ha(e,Math.trunc(t))))}besselkfn(e,t){return this.runFunction(e.args,t,this.metadata("BESSELK"),((e,t)=>Va(e,Math.trunc(t))))}besselyfn(e,t){return this.runFunction(e.args,t,this.metadata("BESSELY"),((e,t)=>Fa(e,Math.trunc(t))))}chisqdist(e,t){return this.runFunction(e.args,t,this.metadata("CHISQ.DIST"),((e,t,r)=>(t=Math.trunc(t),r?yl(e,t):ml(e,t))))}chisqdistrt(e,t){return this.runFunction(e.args,t,this.metadata("CHISQ.DIST.RT"),((e,t)=>1-yl(e,Math.trunc(t))))}chisqinv(e,t){return this.runFunction(e.args,t,this.metadata("CHISQ.INV"),((e,t)=>El(e,Math.trunc(t))))}chisqinvrt(e,t){return this.runFunction(e.args,t,this.metadata("CHISQ.INV.RT"),((e,t)=>El(1-e,Math.trunc(t))))}fdist(e,t){return this.runFunction(e.args,t,this.metadata("F.DIST"),((e,t,r,n)=>(t=Math.trunc(t),r=Math.trunc(r),n?Cl(e,t,r):wl(e,t,r))))}fdistrt(e,t){return this.runFunction(e.args,t,this.metadata("F.DIST.RT"),((e,t,r)=>1-Cl(e,Math.trunc(t),Math.trunc(r))))}finv(e,t){return this.runFunction(e.args,t,this.metadata("F.INV"),((e,t,r)=>vl(e,Math.trunc(t),Math.trunc(r))))}finvrt(e,t){return this.runFunction(e.args,t,this.metadata("F.INV.RT"),((e,t,r)=>vl(1-e,Math.trunc(t),Math.trunc(r))))}weibulldist(e,t){return this.runFunction(e.args,t,this.metadata("WEIBULL.DIST"),((e,t,r,n)=>n?Sl(e,r,t):Rl(e,r,t)))}poissondist(e,t){return this.runFunction(e.args,t,this.metadata("POISSON.DIST"),((e,t,r)=>(e=Math.trunc(e),r?Tl.cdf(e,t):Tl.pdf(e,t))))}hypgeomdist(e,t){return this.runFunction(e.args,t,this.metadata("HYPGEOM.DIST"),((e,t,r,n,s)=>e>t||e>r||t>n||r>n||e+n<r+t?new Tr(ir.NUM,Z.ValueLarge):(e=Math.trunc(e),t=Math.trunc(t),r=Math.trunc(r),n=Math.trunc(n),s?Nl.cdf(e,n,r,t):Nl.pdf(e,n,r,t))))}tdist(e,t){return this.runFunction(e.args,t,this.metadata("T.DIST"),((e,t,r)=>(t=Math.trunc(t),r?_l(e,t):Ml(e,t))))}tdist2t(e,t){return this.runFunction(e.args,t,this.metadata("T.DIST.2T"),((e,t)=>2*(1-_l(e,Math.trunc(t)))))}tdistrt(e,t){return this.runFunction(e.args,t,this.metadata("T.DIST.RT"),((e,t)=>1-_l(e,Math.trunc(t))))}tdistold(e,t){return this.runFunction(e.args,t,this.metadata("TDIST"),((e,t,r)=>r*(1-_l(e,Math.trunc(t)))))}tinv(e,t){return this.runFunction(e.args,t,this.metadata("T.INV"),((e,t)=>bl(e,Math.trunc(t))))}tinv2t(e,t){return this.runFunction(e.args,t,this.metadata("T.INV.2T"),((e,t)=>bl(1-e/2,Math.trunc(t))))}lognormdist(e,t){return this.runFunction(e.args,t,this.metadata("LOGNORM.DIST"),((e,t,r,n)=>n?Ol(e,t,r):Al(e,t,r)))}lognorminv(e,t){return this.runFunction(e.args,t,this.metadata("LOGNORM.INV"),((e,t,r)=>Il(e,t,r)))}normdist(e,t){return this.runFunction(e.args,t,this.metadata("NORM.DIST"),((e,t,r,n)=>n?el(e,t,r):Ja(e,t,r)))}norminv(e,t){return this.runFunction(e.args,t,this.metadata("NORM.INV"),((e,t,r)=>tl(e,t,r)))}normsdist(e,t){return this.runFunction(e.args,t,this.metadata("NORM.S.DIST"),((e,t)=>t?el(e,0,1):Ja(e,0,1)))}normsinv(e,t){return this.runFunction(e.args,t,this.metadata("NORM.S.INV"),(e=>tl(e,0,1)))}phi(e,t){return this.runFunction(e.args,t,this.metadata("PHI"),(e=>Ja(e,0,1)))}negbinomdist(e,t){return this.runFunction(e.args,t,this.metadata("NEGBINOM.DIST"),((e,t,r,n)=>(e=Math.trunc(e),t=Math.trunc(t),n?xl.cdf(e,t,r):xl.pdf(e,t,r))))}confidencenorm(e,t){return this.runFunction(e.args,t,this.metadata("CONFIDENCE.NORM"),((e,t,r)=>function(){var e,t=[].slice.call(arguments),r=new Array(2);return e=4===t.length?Math.abs(tl(t[1]/2,0,1)*t[2]/Math.sqrt(t[3])):Math.abs(tl(t[1]/2,0,1)*Hl(t[2])/Math.sqrt(t[2].length)),r[0]=t[0]-e,r[1]=t[0]+e,r}(1,e,t,Math.trunc(r))[1]-1))}confidencet(e,t){return this.runFunction(e.args,t,this.metadata("CONFIDENCE.T"),((e,t,r)=>1===(r=Math.trunc(r))?new Tr(ir.DIV_BY_ZERO):function(){var e,t=[].slice.call(arguments),r=new Array(2);return e=4===t.length?Math.abs(bl(t[1]/2,t[3]-1)*t[2]/Math.sqrt(t[3])):Math.abs(bl(t[1]/2,t[2].length-1)*Hl(t[2],!0)/Math.sqrt(t[2].length)),r[0]=t[0]-e,r[1]=t[0]+e,r}(1,e,t,r)[1]-1))}standardize(e,t){return this.runFunction(e.args,t,this.metadata("STANDARDIZE"),((e,t,r)=>(e-t)/r))}}Vl.implementedFunctions={ERF:{method:"erf",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,optionalArg:!0}]},ERFC:{method:"erfc",parameters:[{argumentType:hn.NUMBER}]},"EXPON.DIST":{method:"expondist",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.BOOLEAN}]},FISHER:{method:"fisher",parameters:[{argumentType:hn.NUMBER,greaterThan:-1,lessThan:1}]},FISHERINV:{method:"fisherinv",parameters:[{argumentType:hn.NUMBER}]},GAMMA:{method:"gamma",parameters:[{argumentType:hn.NUMBER}]},"GAMMA.DIST":{method:"gammadist",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.BOOLEAN}]},GAMMALN:{method:"gammaln",parameters:[{argumentType:hn.NUMBER,greaterThan:0}]},"GAMMA.INV":{method:"gammainv",parameters:[{argumentType:hn.NUMBER,minValue:0,lessThan:1},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0}]},GAUSS:{method:"gauss",parameters:[{argumentType:hn.NUMBER}]},"BETA.DIST":{method:"betadist",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.BOOLEAN},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:1}]},"BETA.INV":{method:"betainv",parameters:[{argumentType:hn.NUMBER,greaterThan:0,maxValue:1},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,defaultValue:0},{argumentType:hn.NUMBER,defaultValue:1}]},"BINOM.DIST":{method:"binomialdist",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0,maxValue:1},{argumentType:hn.BOOLEAN}]},"BINOM.INV":{method:"binomialinv",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0,maxValue:1},{argumentType:hn.NUMBER,greaterThan:0,lessThan:1}]},BESSELI:{method:"besselifn",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:0}]},BESSELJ:{method:"besseljfn",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:0}]},BESSELK:{method:"besselkfn",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:0}]},BESSELY:{method:"besselyfn",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:0}]},"CHISQ.DIST":{method:"chisqdist",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:1,maxValue:1e10},{argumentType:hn.BOOLEAN}]},"CHISQ.DIST.RT":{method:"chisqdistrt",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:1,maxValue:1e10}]},"CHISQ.INV":{method:"chisqinv",parameters:[{argumentType:hn.NUMBER,minValue:0,maxValue:1},{argumentType:hn.NUMBER,minValue:1,maxValue:1e10}]},"CHISQ.INV.RT":{method:"chisqinvrt",parameters:[{argumentType:hn.NUMBER,minValue:0,maxValue:1},{argumentType:hn.NUMBER,minValue:1}]},"F.DIST":{method:"fdist",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:1},{argumentType:hn.NUMBER,minValue:1},{argumentType:hn.BOOLEAN}]},"F.DIST.RT":{method:"fdistrt",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:1},{argumentType:hn.NUMBER,minValue:1}]},"F.INV":{method:"finv",parameters:[{argumentType:hn.NUMBER,minValue:0,maxValue:1},{argumentType:hn.NUMBER,minValue:1},{argumentType:hn.NUMBER,minValue:1}]},"F.INV.RT":{method:"finvrt",parameters:[{argumentType:hn.NUMBER,minValue:0,maxValue:1},{argumentType:hn.NUMBER,minValue:1},{argumentType:hn.NUMBER,minValue:1}]},"WEIBULL.DIST":{method:"weibulldist",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.BOOLEAN}]},"POISSON.DIST":{method:"poissondist",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.BOOLEAN}]},"HYPGEOM.DIST":{method:"hypgeomdist",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.BOOLEAN}]},"T.DIST":{method:"tdist",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:1},{argumentType:hn.BOOLEAN}]},"T.DIST.2T":{method:"tdist2t",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:1}]},"T.DIST.RT":{method:"tdistrt",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,minValue:1}]},TDIST:{method:"tdistold",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:1},{argumentType:hn.INTEGER,minValue:1,maxValue:2}]},"T.INV":{method:"tinv",parameters:[{argumentType:hn.NUMBER,greaterThan:0,lessThan:1},{argumentType:hn.NUMBER,minValue:1}]},"T.INV.2T":{method:"tinv2t",parameters:[{argumentType:hn.NUMBER,greaterThan:0,maxValue:1},{argumentType:hn.NUMBER,minValue:1}]},"LOGNORM.DIST":{method:"lognormdist",parameters:[{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.BOOLEAN}]},"LOGNORM.INV":{method:"lognorminv",parameters:[{argumentType:hn.NUMBER,greaterThan:0,lessThan:1},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,greaterThan:0}]},"NORM.DIST":{method:"normdist",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.BOOLEAN}]},"NORM.INV":{method:"norminv",parameters:[{argumentType:hn.NUMBER,greaterThan:0,lessThan:1},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,greaterThan:0}]},"NORM.S.DIST":{method:"normsdist",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.BOOLEAN}]},"NORM.S.INV":{method:"normsinv",parameters:[{argumentType:hn.NUMBER,greaterThan:0,lessThan:1}]},PHI:{method:"phi",parameters:[{argumentType:hn.NUMBER}]},"NEGBINOM.DIST":{method:"negbinomdist",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:1},{argumentType:hn.NUMBER,minValue:0,maxValue:1},{argumentType:hn.BOOLEAN}]},"CONFIDENCE.NORM":{method:"confidencenorm",parameters:[{argumentType:hn.NUMBER,greaterThan:0,lessThan:1},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,minValue:1}]},"CONFIDENCE.T":{method:"confidencet",parameters:[{argumentType:hn.NUMBER,greaterThan:0,lessThan:1},{argumentType:hn.NUMBER,greaterThan:0},{argumentType:hn.NUMBER,minValue:1}]},STANDARDIZE:{method:"standardize",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,greaterThan:0}]}},Vl.aliases={NEGBINOMDIST:"NEGBINOM.DIST",EXPONDIST:"EXPON.DIST",BETADIST:"BETA.DIST",NORMDIST:"NORM.DIST",NORMINV:"NORM.INV",NORMSDIST:"NORM.S.DIST",NORMSINV:"NORM.S.INV",LOGNORMDIST:"LOGNORM.DIST",LOGINV:"LOGNORM.INV",TINV:"T.INV.2T",HYPGEOMDIST:"HYPGEOM.DIST",POISSON:"POISSON.DIST",WEIBULL:"WEIBULL.DIST",FINV:"F.INV.RT",FDIST:"F.DIST.RT",CHIDIST:"CHISQ.DIST.RT",CHIINV:"CHISQ.INV.RT",GAMMADIST:"GAMMA.DIST","GAMMALN.PRECISE":"GAMMALN",GAMMAINV:"GAMMA.INV",BETAINV:"BETA.INV",BINOMDIST:"BINOM.DIST",CONFIDENCE:"CONFIDENCE.NORM",CRITBINOM:"BINOM.INV",WEIBULLDIST:"WEIBULL.DIST",TINV2T:"T.INV.2T",TDISTRT:"T.DIST.RT",TDIST2T:"T.DIST.2T",FINVRT:"F.INV.RT",FDISTRT:"F.DIST.RT",CHIDISTRT:"CHISQ.DIST.RT",CHIINVRT:"CHISQ.INV.RT",LOGNORMINV:"LOGNORM.INV",POISSONDIST:"POISSON.DIST"};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class Bl extends un{fact(e,t){return this.runFunction(e.args,t,this.metadata("FACT"),(e=>{e=Math.trunc(e);let t=1;for(let r=1;r<=e;r++)t*=r;return t}))}factdouble(e,t){return this.runFunction(e.args,t,this.metadata("FACTDOUBLE"),(e=>{let t=1;for(let r=e=Math.trunc(e);r>=1;r-=2)t*=r;return t}))}combin(e,t){return this.runFunction(e.args,t,this.metadata("COMBIN"),((e,t)=>t>e?new Tr(ir.NUM,Z.WrongOrder):Wl(e=Math.trunc(e),t=Math.trunc(t))))}combina(e,t){return this.runFunction(e.args,t,this.metadata("COMBINA"),((e,t)=>(e=Math.trunc(e))+(t=Math.trunc(t))-1>=1030?new Tr(ir.NUM,Z.ValueLarge):0===e&&0===t?1:Wl(e+t-1,t)))}gcd(e,t){return this.runFunction(e.args,t,this.metadata("GCD"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersCoerceRangesDropNulls(e);if(t instanceof Tr)return t;let r=0;for(const e of t){if(e<0)return new Tr(ir.NUM,Z.ValueSmall);r=Yl(r,Math.trunc(e))}return r>Number.MAX_SAFE_INTEGER?new Tr(ir.NUM,Z.ValueLarge):r}))}lcm(e,t){return this.runFunction(e.args,t,this.metadata("LCM"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersCoerceRangesDropNulls(e);if(t instanceof Tr)return t;let r=1;for(const e of t){if(e<0)return new Tr(ir.NUM,Z.ValueSmall);r=Gl(r,Math.trunc(e))}return r>Number.MAX_SAFE_INTEGER?new Tr(ir.NUM,Z.ValueLarge):r}))}mround(e,t){return this.runFunction(e.args,t,this.metadata("MROUND"),((e,t)=>0===t?0:e>0&&t<0||e<0&&t>0?new Tr(ir.NUM,Z.DistinctSigns):Math.round(e/t)*t))}multinomial(e,t){return this.runFunction(e.args,t,this.metadata("MULTINOMIAL"),((...e)=>{let t=0,r=1;for(let n of e){if(n<0)return new Tr(ir.NUM,Z.ValueSmall);n=Math.trunc(n);for(let e=1;e<=n;e++)r*=(t+e)/e;t+=n}return Math.round(r)}))}quotient(e,t){return this.runFunction(e.args,t,this.metadata("QUOTIENT"),((e,t)=>0===t?new Tr(ir.DIV_BY_ZERO):Math.trunc(e/t)))}seriessum(e,t){return this.runFunction(e.args,t,this.metadata("SERIESSUM"),((e,t,r,n)=>{const s=this.arithmeticHelper.manyToOnlyNumbersDropNulls(n.valuesFromTopLeftCorner());if(s instanceof Tr)return s;let i=0;s.reverse();for(const t of s)i*=Math.pow(e,r),i+=t;return i*Math.pow(e,t)}))}sign(e,t){return this.runFunction(e.args,t,this.metadata("SIGN"),(e=>e>0?1:e<0?-1:0))}sumx2my2(e,t){return this.runFunction(e.args,t,this.metadata("SUMX2MY2"),((e,t)=>{const r=e.valuesFromTopLeftCorner(),n=t.valuesFromTopLeftCorner();if(r.length!==n.length)return new Tr(ir.NA,Z.EqualLength);const s=r.length;let i=0;for(let e=0;e<s;e++){const t=r[e],s=n[e];if(t instanceof Tr)return t;if(s instanceof Tr)return s;"number"==typeof t&&"number"==typeof s&&(i+=Math.pow(t,2)-Math.pow(s,2))}return i}))}sumx2py2(e,t){return this.runFunction(e.args,t,this.metadata("SUMX2PY2"),((e,t)=>{const r=e.valuesFromTopLeftCorner(),n=t.valuesFromTopLeftCorner();if(r.length!==n.length)return new Tr(ir.NA,Z.EqualLength);const s=r.length;let i=0;for(let e=0;e<s;e++){const t=r[e],s=n[e];if(t instanceof Tr)return t;if(s instanceof Tr)return s;"number"==typeof t&&"number"==typeof s&&(i+=Math.pow(t,2)+Math.pow(s,2))}return i}))}sumxmy2(e,t){return this.runFunction(e.args,t,this.metadata("SUMXMY2"),((e,t)=>{const r=e.valuesFromTopLeftCorner(),n=t.valuesFromTopLeftCorner();if(r.length!==n.length)return new Tr(ir.NA,Z.EqualLength);const s=r.length;let i=0;for(let e=0;e<s;e++){const t=r[e],s=n[e];if(t instanceof Tr)return t;if(s instanceof Tr)return s;"number"==typeof t&&"number"==typeof s&&(i+=Math.pow(t-s,2))}return i}))}}function Wl(e,t){2*t>e&&(t=e-t);let r=1;for(let n=1;n<=t;n++)r*=(e-t+n)/n;return Math.round(r)}function Yl(e,t){for(e<t&&([e,t]=[t,e]);t>0;)[e,t]=[t,e%t];return e}function Gl(e,t){return 0===e||0===t?0:e*(t/Yl(e,t))}Bl.implementedFunctions={FACT:{method:"fact",parameters:[{argumentType:hn.NUMBER,minValue:0,maxValue:170}]},FACTDOUBLE:{method:"factdouble",parameters:[{argumentType:hn.NUMBER,minValue:0,maxValue:288}]},COMBIN:{method:"combin",parameters:[{argumentType:hn.NUMBER,minValue:0,lessThan:1030},{argumentType:hn.NUMBER,minValue:0}]},COMBINA:{method:"combina",parameters:[{argumentType:hn.NUMBER,minValue:0},{argumentType:hn.NUMBER,minValue:0}]},GCD:{method:"gcd",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},LCM:{method:"lcm",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},MROUND:{method:"mround",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]},MULTINOMIAL:{method:"multinomial",parameters:[{argumentType:hn.NUMBER}],repeatLastArgs:1,expandRanges:!0},QUOTIENT:{method:"quotient",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER}]},SERIESSUM:{method:"seriessum",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.RANGE}]},SIGN:{method:"sign",parameters:[{argumentType:hn.NUMBER}]},SUMX2MY2:{method:"sumx2my2",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},SUMX2PY2:{method:"sumx2py2",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},SUMXMY2:{method:"sumxmy2",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class jl extends un{complex(e,t){return this.runFunction(e.args,t,this.metadata("COMPLEX"),((e,t,r)=>"i"!==r&&"j"!==r?new Tr(ir.VALUE,Z.ShouldBeIorJ):Gr([e,t],r)))}imabs(e,t){return this.runFunction(e.args,t,this.metadata("IMABS"),eh)}imaginary(e,t){return this.runFunction(e.args,t,this.metadata("IMAGINARY"),(([e,t])=>t))}imreal(e,t){return this.runFunction(e.args,t,this.metadata("IMREAL"),(([e,t])=>e))}imargument(e,t){return this.runFunction(e.args,t,this.metadata("IMARGUMENT"),(([e,t])=>0===e&&0===t?new Tr(ir.DIV_BY_ZERO):Math.atan2(t,e)))}imconjugate(e,t){return this.runFunction(e.args,t,this.metadata("IMCONJUGATE"),(([e,t])=>Gr([e,-t])))}imcos(e,t){return this.runFunction(e.args,t,this.metadata("IMCOS"),(e=>Gr(Xl(e))))}imcosh(e,t){return this.runFunction(e.args,t,this.metadata("IMCOSH"),(e=>Gr(ql(e))))}imcot(e,t){return this.runFunction(e.args,t,this.metadata("IMCOT"),(e=>Gr(Kl(Xl(e),Ql(e)))))}imcsc(e,t){return this.runFunction(e.args,t,this.metadata("IMCSC"),(e=>Gr(Kl([1,0],Ql(e)))))}imcsch(e,t){return this.runFunction(e.args,t,this.metadata("IMCSCH"),(e=>Gr(Kl([1,0],Zl(e)))))}imsec(e,t){return this.runFunction(e.args,t,this.metadata("IMSEC"),(e=>Gr(Kl([1,0],Xl(e)))))}imsech(e,t){return this.runFunction(e.args,t,this.metadata("IMSECH"),(e=>Gr(Kl([1,0],ql(e)))))}imsin(e,t){return this.runFunction(e.args,t,this.metadata("IMSIN"),(e=>Gr(Ql(e))))}imsinh(e,t){return this.runFunction(e.args,t,this.metadata("IMSINH"),(e=>Gr(Zl(e))))}imtan(e,t){return this.runFunction(e.args,t,this.metadata("IMTAN"),(e=>Gr(Kl(Ql(e),Xl(e)))))}imdiv(e,t){return this.runFunction(e.args,t,this.metadata("IMDIV"),((e,t)=>Gr(Kl(e,t))))}improduct(e,t){return this.runFunction(e.args,t,this.metadata("IMPRODUCT"),((...e)=>{const t=this.arithmeticHelper.coerceComplexExactRanges(e);if(t instanceof Tr)return t;let r=[1,0];for(const e of t)r=$l(r,e);return Gr(r)}))}imsum(e,t){return this.runFunction(e.args,t,this.metadata("IMSUM"),((...e)=>{const t=this.arithmeticHelper.coerceComplexExactRanges(e);if(t instanceof Tr)return t;let r=[0,0];for(const e of t)r=zl(r,e);return Gr(r)}))}imsub(e,t){return this.runFunction(e.args,t,this.metadata("IMSUB"),((e,t)=>Gr(function([e,t],[r,n]){return[e-r,t-n]}(e,t))))}imexp(e,t){return this.runFunction(e.args,t,this.metadata("IMEXP"),(e=>Gr(Jl(e))))}imln(e,t){return this.runFunction(e.args,t,this.metadata("IMLN"),(e=>Gr(th(e))))}imlog10(e,t){return this.runFunction(e.args,t,this.metadata("IMLOG10"),(e=>{const[t,r]=th(e),n=Math.log(10);return Gr([t/n,r/n])}))}imlog2(e,t){return this.runFunction(e.args,t,this.metadata("IMLOG2"),(e=>{const[t,r]=th(e),n=Math.log(2);return Gr([t/n,r/n])}))}impower(e,t){return this.runFunction(e.args,t,this.metadata("IMPOWER"),((e,t)=>Gr(rh(e,t))))}imsqrt(e,t){return this.runFunction(e.args,t,this.metadata("IMSQRT"),(e=>Gr(rh(e,.5))))}}function zl([e,t],[r,n]){return[e+r,t+n]}function $l([e,t],[r,n]){return[e*r-t*n,e*n+r*t]}function Kl([e,t],[r,n]){const s=Math.pow(r,2)+Math.pow(n,2),[i,o]=$l([e,t],[r,-n]);return[i/s,o/s]}function Xl([e,t]){return[Math.cos(e)*Math.cosh(t),-Math.sin(e)*Math.sinh(t)]}function ql([e,t]){return[Math.cosh(e)*Math.cos(t),Math.sinh(e)*Math.sin(t)]}function Ql([e,t]){return[Math.sin(e)*Math.cosh(t),Math.cos(e)*Math.sinh(t)]}function Zl([e,t]){return[Math.sinh(e)*Math.cos(t),Math.cosh(e)*Math.sin(t)]}function Jl([e,t]){return[Math.exp(e)*Math.cos(t),Math.exp(e)*Math.sin(t)]}function eh([e,t]){return Math.sqrt(e*e+t*t)}function th([e,t]){return[Math.log(eh([e,t])),Math.atan2(t,e)]}function rh(e,t){const[r,n]=th(e);return Jl([t*r,t*n])}jl.implementedFunctions={COMPLEX:{method:"complex",parameters:[{argumentType:hn.NUMBER},{argumentType:hn.NUMBER},{argumentType:hn.STRING,defaultValue:"i"}]},IMABS:{method:"imabs",parameters:[{argumentType:hn.COMPLEX}]},IMAGINARY:{method:"imaginary",parameters:[{argumentType:hn.COMPLEX}]},IMREAL:{method:"imreal",parameters:[{argumentType:hn.COMPLEX}]},IMARGUMENT:{method:"imargument",parameters:[{argumentType:hn.COMPLEX}]},IMCONJUGATE:{method:"imconjugate",parameters:[{argumentType:hn.COMPLEX}]},IMCOS:{method:"imcos",parameters:[{argumentType:hn.COMPLEX}]},IMCOSH:{method:"imcosh",parameters:[{argumentType:hn.COMPLEX}]},IMCOT:{method:"imcot",parameters:[{argumentType:hn.COMPLEX}]},IMCSC:{method:"imcsc",parameters:[{argumentType:hn.COMPLEX}]},IMCSCH:{method:"imcsch",parameters:[{argumentType:hn.COMPLEX}]},IMSEC:{method:"imsec",parameters:[{argumentType:hn.COMPLEX}]},IMSECH:{method:"imsech",parameters:[{argumentType:hn.COMPLEX}]},IMSIN:{method:"imsin",parameters:[{argumentType:hn.COMPLEX}]},IMSINH:{method:"imsinh",parameters:[{argumentType:hn.COMPLEX}]},IMTAN:{method:"imtan",parameters:[{argumentType:hn.COMPLEX}]},IMDIV:{method:"imdiv",parameters:[{argumentType:hn.COMPLEX},{argumentType:hn.COMPLEX}]},IMPRODUCT:{method:"improduct",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},IMSUM:{method:"imsum",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},IMSUB:{method:"imsub",parameters:[{argumentType:hn.COMPLEX},{argumentType:hn.COMPLEX}]},IMEXP:{method:"imexp",parameters:[{argumentType:hn.COMPLEX}]},IMLN:{method:"imln",parameters:[{argumentType:hn.COMPLEX}]},IMLOG10:{method:"imlog10",parameters:[{argumentType:hn.COMPLEX}]},IMLOG2:{method:"imlog2",parameters:[{argumentType:hn.COMPLEX}]},IMPOWER:{method:"impower",parameters:[{argumentType:hn.COMPLEX},{argumentType:hn.NUMBER}]},IMSQRT:{method:"imsqrt",parameters:[{argumentType:hn.COMPLEX}]}};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class nh extends un{avedev(e,t){return this.runFunction(e.args,t,this.metadata("AVEDEV"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersExactRanges(e);if(t instanceof Tr)return t;if(0===t.length)return new Tr(ir.DIV_BY_ZERO);const r=Ll(t);return t.reduce(((e,t)=>e+Math.abs(t-r)),0)/t.length}))}devsq(e,t){return this.runFunction(e.args,t,this.metadata("DEVSQ"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersExactRanges(e);return t instanceof Tr?t:0===t.length?0:Dl(t)}))}geomean(e,t){return this.runFunction(e.args,t,this.metadata("GEOMEAN"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersExactRanges(e);if(t instanceof Tr)return t;if(0===t.length)return new Tr(ir.NUM,Z.OneValue);for(const e of t)if(e<=0)return new Tr(ir.NUM,Z.ValueSmall);return r=t,Math.pow(function(e){for(var t=1,r=e.length;--r>=0;)t*=e[r];return t}(r),1/r.length);var r}))}harmean(e,t){return this.runFunction(e.args,t,this.metadata("HARMEAN"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersExactRanges(e);if(t instanceof Tr)return t;if(0===t.length)return new Tr(ir.NUM,Z.OneValue);for(const e of t)if(e<=0)return new Tr(ir.NUM,Z.ValueSmall);return t.length/t.reduce(((e,t)=>e+1/t),0)}))}correl(e,t){return this.runFunction(e.args,t,this.metadata("CORREL"),((e,t)=>{if(e.numberOfElements()!==t.numberOfElements())return new Tr(ir.NA,Z.EqualLength);const r=sh(e,t);if(r instanceof Tr)return r;return r[0].length<=1?new Tr(ir.DIV_BY_ZERO,Z.TwoValues):Ul(r[0],r[1])}))}rsq(e,t){return this.runFunction(e.args,t,this.metadata("RSQ"),((e,t)=>{if(e.numberOfElements()!==t.numberOfElements())return new Tr(ir.NA,Z.EqualLength);const r=sh(e,t);if(r instanceof Tr)return r;return r[0].length<=1?new Tr(ir.DIV_BY_ZERO,Z.TwoValues):Math.pow(Ul(r[0],r[1]),2)}))}covariancep(e,t){return this.runFunction(e.args,t,this.metadata("COVARIANCE.P"),((e,t)=>{if(e.numberOfElements()!==t.numberOfElements())return new Tr(ir.NA,Z.EqualLength);const r=sh(e,t);if(r instanceof Tr)return r;const n=r[0].length;return n<1?new Tr(ir.DIV_BY_ZERO,Z.OneValue):1===n?0:Fl(r[0],r[1])*(n-1)/n}))}covariances(e,t){return this.runFunction(e.args,t,this.metadata("COVARIANCE.S"),((e,t)=>{if(e.numberOfElements()!==t.numberOfElements())return new Tr(ir.NA,Z.EqualLength);const r=sh(e,t);if(r instanceof Tr)return r;return r[0].length<=1?new Tr(ir.DIV_BY_ZERO,Z.TwoValues):Fl(r[0],r[1])}))}ztest(e,t){return this.runFunction(e.args,t,this.metadata("Z.TEST"),((e,t,r)=>{const n=this.arithmeticHelper.manyToExactNumbers(e.valuesFromTopLeftCorner());if(n instanceof Tr)return n;const s=n.length;if(void 0===r){if(s<2)return new Tr(ir.DIV_BY_ZERO,Z.TwoValues);r=Hl(n,!0)}return s<1?new Tr(ir.NA,Z.OneValue):0===r?new Tr(ir.DIV_BY_ZERO):1-el((Ll(n)-t)/(r/Math.sqrt(s)),0,1)}))}ftest(e,t){return this.runFunction(e.args,t,this.metadata("F.TEST"),((e,t)=>{const r=this.arithmeticHelper.manyToExactNumbers(e.valuesFromTopLeftCorner()),n=this.arithmeticHelper.manyToExactNumbers(t.valuesFromTopLeftCorner());if(r instanceof Tr)return r;if(n instanceof Tr)return n;if(r.length<=1||n.length<=1)return new Tr(ir.DIV_BY_ZERO);const s=kl(r,!0),i=kl(n,!0);if(0===s||0===i)return new Tr(ir.DIV_BY_ZERO);const o=Cl(s/i,r.length-1,n.length-1);return 2*Math.min(o,1-o)}))}steyx(e,t){return this.runFunction(e.args,t,this.metadata("STEYX"),((e,t)=>{if(e.numberOfElements()!==t.numberOfElements())return new Tr(ir.NA,Z.EqualLength);const r=sh(e,t);if(r instanceof Tr)return r;const n=r[0].length;return n<=2?new Tr(ir.DIV_BY_ZERO,Z.ThreeValues):Math.sqrt((Dl(r[0])-Math.pow(Fl(r[0],r[1])*(n-1),2)/Dl(r[1]))/(n-2))}))}slope(e,t){return this.runFunction(e.args,t,this.metadata("SLOPE"),((e,t)=>{if(e.numberOfElements()!==t.numberOfElements())return new Tr(ir.NA,Z.EqualLength);const r=sh(e,t);if(r instanceof Tr)return r;const n=r[0].length;return n<=1?new Tr(ir.DIV_BY_ZERO,Z.TwoValues):Fl(r[0],r[1])*(n-1)/Dl(r[1])}))}chisqtest(e,t){return this.runFunction(e.args,t,this.metadata("CHISQ.TEST"),((e,t)=>{const r=e.height(),n=e.width();if(t.height()!==r||t.width()!==n)return new Tr(ir.NA,Z.EqualLength);const s=sh(e,t);if(s instanceof Tr)return s;if(s[0].length<=1)return new Tr(ir.DIV_BY_ZERO,Z.TwoValues);let i=0;for(let e=0;e<s[0].length;e++){if(0===s[1][e])return new Tr(ir.DIV_BY_ZERO);i+=Math.pow(s[0][e]-s[1][e],2)/s[1][e]}return i<0?new Tr(ir.NUM,Z.NaN):1-yl(i,r>1&&n>1?(r-1)*(n-1):r*n-1)}))}ttest(e,t){return this.runFunction(e.args,t,this.metadata("T.TEST"),((e,t,r,n)=>{const s=this.arithmeticHelper.manyToExactNumbers(e.valuesFromTopLeftCorner()),i=this.arithmeticHelper.manyToExactNumbers(t.valuesFromTopLeftCorner());if(s instanceof Tr)return s;if(i instanceof Tr)return i;const o=s.length,a=i.length;if(1===n){if(a!==o)return new Tr(ir.NA,Z.EqualLength);if(o<=1)return new Tr(ir.DIV_BY_ZERO,Z.TwoValues);const e=Array(o);for(let t=0;t<o;t++)e[t]=s[t]-i[t];const t=Hl(e,!0);if(0===t)return new Tr(ir.DIV_BY_ZERO);const n=Math.abs(Math.sqrt(o)*Ll(e)/t);return r*(1-_l(n,o-1))}if(2===n){if(o<=1||a<=1)return new Tr(ir.DIV_BY_ZERO,Z.TwoValues);const e=(Dl(s)+Dl(i))/(o+a-2);if(0===e)return new Tr(ir.DIV_BY_ZERO);const t=Math.abs((Ll(s)-Ll(i))/Math.sqrt(e*(1/o+1/a)));return r*(1-_l(t,o+a-2))}{if(o<=1||a<=1)return new Tr(ir.DIV_BY_ZERO,Z.TwoValues);const e=kl(s,!0),t=kl(i,!0);if(0===e&&0===t)return new Tr(ir.DIV_BY_ZERO);const n=Math.abs((Ll(s)-Ll(i))/Math.sqrt(e/o+t/a)),l=Math.pow(e/o+t/a,2)/(Math.pow(e/o,2)/(o-1)+Math.pow(t/a,2)/(a-1));return r*(1-_l(n,l))}}))}skew(e,t){return this.runFunction(e.args,t,this.metadata("SKEW"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersExactRanges(e);if(t instanceof Tr)return t;const r=t.length;if(r<3)return new Tr(ir.DIV_BY_ZERO,Z.ThreeValues);const n=Ll(t),s=Hl(t,!0);return 0===s?new Tr(ir.DIV_BY_ZERO):t.reduce(((e,t)=>e+Math.pow((t-n)/s,3)),0)*r/(r-1)/(r-2)}))}skewp(e,t){return this.runFunction(e.args,t,this.metadata("SKEW.P"),((...e)=>{const t=this.arithmeticHelper.coerceNumbersExactRanges(e);if(t instanceof Tr)return t;const r=t.length;if(r<3)return new Tr(ir.DIV_BY_ZERO,Z.ThreeValues);const n=Ll(t),s=Hl(t,!1);return 0===s?new Tr(ir.DIV_BY_ZERO):t.reduce(((e,t)=>e+Math.pow((t-n)/s,3)),0)/r}))}}function sh(e,t){const r=e.iterateValuesFromTopLeftCorner(),n=t.iterateValuesFromTopLeftCorner();let s,i;const o=[],a=[];for(;s=r.next(),i=n.next(),!s.done&&!i.done;){const e=s.value,t=i.value;if(e instanceof Tr)return e;if(t instanceof Tr)return t;Ze(e)&&Ze(t)&&(o.push(Ge(e)),a.push(Ge(t)))}return[o,a]}nh.implementedFunctions={AVEDEV:{method:"avedev",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},DEVSQ:{method:"devsq",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},GEOMEAN:{method:"geomean",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},HARMEAN:{method:"harmean",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},CORREL:{method:"correl",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},RSQ:{method:"rsq",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},"COVARIANCE.P":{method:"covariancep",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},"COVARIANCE.S":{method:"covariances",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},"Z.TEST":{method:"ztest",parameters:[{argumentType:hn.RANGE},{argumentType:hn.NUMBER},{argumentType:hn.NUMBER,optionalArg:!0}]},"F.TEST":{method:"ftest",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},STEYX:{method:"steyx",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},SLOPE:{method:"slope",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},"CHISQ.TEST":{method:"chisqtest",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE}]},"T.TEST":{method:"ttest",parameters:[{argumentType:hn.RANGE},{argumentType:hn.RANGE},{argumentType:hn.INTEGER,minValue:1,maxValue:2},{argumentType:hn.INTEGER,minValue:1,maxValue:3}]},SKEW:{method:"skew",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1},"SKEW.P":{method:"skewp",parameters:[{argumentType:hn.ANY}],repeatLastArgs:1}},nh.aliases={COVAR:"COVARIANCE.P",FTEST:"F.TEST",PEARSON:"CORREL",ZTEST:"Z.TEST",CHITEST:"CHISQ.TEST",TTEST:"T.TEST",COVARIANCEP:"COVARIANCE.P",COVARIANCES:"COVARIANCE.S",SKEWP:"SKEW.P"};
/**
 * @license
 * Copyright (c) 2024 Handsoncode. All rights reserved.
 */
class ih extends Bi{}ih.HyperFormula=Bi,ih.ErrorType=ir,ih.CellError=Tr,ih.CellType=or,ih.CellValueType=Er,ih.CellValueDetailedType=wr,ih.DetailedCellError=pn,ih.ExportedCellChange=hi,ih.ExportedNamedExpressionChange=ui,ih.ConfigValueTooBigError=_t,ih.ConfigValueTooSmallError=Mt,ih.EvaluationSuspendedError=At,ih.ExpectedOneOfValuesError=bt,ih.ExpectedValueOfTypeError=Tt,ih.ArraySize=cn,ih.SimpleRangeValue=rt,ih.EmptyValue=Ye,ih.FunctionPlugin=un,ih.FunctionArgumentType=hn,ih.FunctionPluginValidationError=Lt,ih.InvalidAddressError=pt,ih.InvalidArgumentsError=gt,ih.LanguageNotRegisteredError=xt,ih.LanguageAlreadyRegisteredError=Pt,ih.MissingTranslationError=Ot,ih.NamedExpressionDoesNotExistError=Et,ih.NamedExpressionNameIsAlreadyTakenError=mt,ih.NamedExpressionNameIsInvalidError=yt,ih.NoOperationToRedoError=Ct,ih.NoOperationToUndoError=wt,ih.NoRelativeAddressesAllowedError=Ft,ih.NoSheetWithIdError=lt,ih.NoSheetWithNameError=ht,ih.NotAFormulaError=dt,ih.NothingToPasteError=vt,ih.ProtectedFunctionTranslationError=It,ih.SheetNameAlreadyTakenError=ut,ih.SheetSizeLimitExceededError=ct,ih.SourceLocationHasArrayError=kt,ih.TargetLocationHasArrayError=Ht,ih.UnableToParseError=St;const oh=Yi.defaultConfig.language;Bi.registerLanguage(oh,ji),Bi.languages[ji.langCode]=ji;for(const e of Object.getOwnPropertyNames(i))e.startsWith("_")||Bi.registerFunctionPlugin(i[e]);const ah=ih;window.HyperFormula=r(53879).Ay},98339:(e,t,r)=>{"use strict";
/*! @license DOMPurify 3.2.2 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/3.2.2/LICENSE */const{entries:n,setPrototypeOf:s,isFrozen:i,getPrototypeOf:o,getOwnPropertyDescriptor:a}=Object;let{freeze:l,seal:h,create:u}=Object,{apply:c,construct:d}="undefined"!=typeof Reflect&&Reflect;l||(l=function(e){return e}),h||(h=function(e){return e}),c||(c=function(e,t,r){return e.apply(t,r)}),d||(d=function(e,t){return new e(...t)});const p=M(Array.prototype.forEach),g=M(Array.prototype.pop),f=M(Array.prototype.push),m=M(String.prototype.toLowerCase),y=M(String.prototype.toString),E=M(String.prototype.match),w=M(String.prototype.replace),C=M(String.prototype.indexOf),v=M(String.prototype.trim),R=M(Object.prototype.hasOwnProperty),S=M(RegExp.prototype.test),T=(N=TypeError,function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return d(N,t)});var N;function M(e){return function(t){for(var r=arguments.length,n=new Array(r>1?r-1:0),s=1;s<r;s++)n[s-1]=arguments[s];return c(e,t,n)}}function _(e,t){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:m;s&&s(e,null);let n=t.length;for(;n--;){let s=t[n];if("string"==typeof s){const e=r(s);e!==s&&(i(t)||(t[n]=e),s=e)}e[s]=!0}return e}function b(e){for(let t=0;t<e.length;t++){R(e,t)||(e[t]=null)}return e}function A(e){const t=u(null);for(const[r,s]of n(e)){R(e,r)&&(Array.isArray(s)?t[r]=b(s):s&&"object"==typeof s&&s.constructor===Object?t[r]=A(s):t[r]=s)}return t}function O(e,t){for(;null!==e;){const r=a(e,t);if(r){if(r.get)return M(r.get);if("function"==typeof r.value)return M(r.value)}e=o(e)}return function(){return null}}const I=l(["a","abbr","acronym","address","area","article","aside","audio","b","bdi","bdo","big","blink","blockquote","body","br","button","canvas","caption","center","cite","code","col","colgroup","content","data","datalist","dd","decorator","del","details","dfn","dialog","dir","div","dl","dt","element","em","fieldset","figcaption","figure","font","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","img","input","ins","kbd","label","legend","li","main","map","mark","marquee","menu","menuitem","meter","nav","nobr","ol","optgroup","option","output","p","picture","pre","progress","q","rp","rt","ruby","s","samp","section","select","shadow","small","source","spacer","span","strike","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","tr","track","tt","u","ul","var","video","wbr"]),x=l(["svg","a","altglyph","altglyphdef","altglyphitem","animatecolor","animatemotion","animatetransform","circle","clippath","defs","desc","ellipse","filter","font","g","glyph","glyphref","hkern","image","line","lineargradient","marker","mask","metadata","mpath","path","pattern","polygon","polyline","radialgradient","rect","stop","style","switch","symbol","text","textpath","title","tref","tspan","view","vkern"]),P=l(["feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feDropShadow","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feImage","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence"]),L=l(["animate","color-profile","cursor","discard","font-face","font-face-format","font-face-name","font-face-src","font-face-uri","foreignobject","hatch","hatchpath","mesh","meshgradient","meshpatch","meshrow","missing-glyph","script","set","solidcolor","unknown","use"]),D=l(["math","menclose","merror","mfenced","mfrac","mglyph","mi","mlabeledtr","mmultiscripts","mn","mo","mover","mpadded","mphantom","mroot","mrow","ms","mspace","msqrt","mstyle","msub","msup","msubsup","mtable","mtd","mtext","mtr","munder","munderover","mprescripts"]),k=l(["maction","maligngroup","malignmark","mlongdiv","mscarries","mscarry","msgroup","mstack","msline","msrow","semantics","annotation","annotation-xml","mprescripts","none"]),H=l(["#text"]),F=l(["accept","action","align","alt","autocapitalize","autocomplete","autopictureinpicture","autoplay","background","bgcolor","border","capture","cellpadding","cellspacing","checked","cite","class","clear","color","cols","colspan","controls","controlslist","coords","crossorigin","datetime","decoding","default","dir","disabled","disablepictureinpicture","disableremoteplayback","download","draggable","enctype","enterkeyhint","face","for","headers","height","hidden","high","href","hreflang","id","inputmode","integrity","ismap","kind","label","lang","list","loading","loop","low","max","maxlength","media","method","min","minlength","multiple","muted","name","nonce","noshade","novalidate","nowrap","open","optimum","pattern","placeholder","playsinline","popover","popovertarget","popovertargetaction","poster","preload","pubdate","radiogroup","readonly","rel","required","rev","reversed","role","rows","rowspan","spellcheck","scope","selected","shape","size","sizes","span","srclang","start","src","srcset","step","style","summary","tabindex","title","translate","type","usemap","valign","value","width","wrap","xmlns","slot"]),U=l(["accent-height","accumulate","additive","alignment-baseline","amplitude","ascent","attributename","attributetype","azimuth","basefrequency","baseline-shift","begin","bias","by","class","clip","clippathunits","clip-path","clip-rule","color","color-interpolation","color-interpolation-filters","color-profile","color-rendering","cx","cy","d","dx","dy","diffuseconstant","direction","display","divisor","dur","edgemode","elevation","end","exponent","fill","fill-opacity","fill-rule","filter","filterunits","flood-color","flood-opacity","font-family","font-size","font-size-adjust","font-stretch","font-style","font-variant","font-weight","fx","fy","g1","g2","glyph-name","glyphref","gradientunits","gradienttransform","height","href","id","image-rendering","in","in2","intercept","k","k1","k2","k3","k4","kerning","keypoints","keysplines","keytimes","lang","lengthadjust","letter-spacing","kernelmatrix","kernelunitlength","lighting-color","local","marker-end","marker-mid","marker-start","markerheight","markerunits","markerwidth","maskcontentunits","maskunits","max","mask","media","method","mode","min","name","numoctaves","offset","operator","opacity","order","orient","orientation","origin","overflow","paint-order","path","pathlength","patterncontentunits","patterntransform","patternunits","points","preservealpha","preserveaspectratio","primitiveunits","r","rx","ry","radius","refx","refy","repeatcount","repeatdur","restart","result","rotate","scale","seed","shape-rendering","slope","specularconstant","specularexponent","spreadmethod","startoffset","stddeviation","stitchtiles","stop-color","stop-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke","stroke-width","style","surfacescale","systemlanguage","tabindex","tablevalues","targetx","targety","transform","transform-origin","text-anchor","text-decoration","text-rendering","textlength","type","u1","u2","unicode","values","viewbox","visibility","version","vert-adv-y","vert-origin-x","vert-origin-y","width","word-spacing","wrap","writing-mode","xchannelselector","ychannelselector","x","x1","x2","xmlns","y","y1","y2","z","zoomandpan"]),V=l(["accent","accentunder","align","bevelled","close","columnsalign","columnlines","columnspan","denomalign","depth","dir","display","displaystyle","encoding","fence","frame","height","href","id","largeop","length","linethickness","lspace","lquote","mathbackground","mathcolor","mathsize","mathvariant","maxsize","minsize","movablelimits","notation","numalign","open","rowalign","rowlines","rowspacing","rowspan","rspace","rquote","scriptlevel","scriptminsize","scriptsizemultiplier","selection","separator","separators","stretchy","subscriptshift","supscriptshift","symmetric","voffset","width","xmlns"]),B=l(["xlink:href","xml:id","xlink:title","xml:space","xmlns:xlink"]),W=h(/\{\{[\w\W]*|[\w\W]*\}\}/gm),Y=h(/<%[\w\W]*|[\w\W]*%>/gm),G=h(/\${[\w\W]*}/gm),j=h(/^data-[\-\w.\u00B7-\uFFFF]/),z=h(/^aria-[\-\w]+$/),$=h(/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|sms|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i),K=h(/^(?:\w+script|data):/i),X=h(/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g),q=h(/^html$/i),Q=h(/^[a-z][.\w]*(-[.\w]+)+$/i);var Z=Object.freeze({__proto__:null,ARIA_ATTR:z,ATTR_WHITESPACE:X,CUSTOM_ELEMENT:Q,DATA_ATTR:j,DOCTYPE_NAME:q,ERB_EXPR:Y,IS_ALLOWED_URI:$,IS_SCRIPT_OR_DATA:K,MUSTACHE_EXPR:W,TMPLIT_EXPR:G});const J=1,ee=3,te=7,re=8,ne=9,se=function(){return"undefined"==typeof window?null:window};var ie=function e(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:se();const r=t=>e(t);if(r.version="3.2.2",r.removed=[],!t||!t.document||t.document.nodeType!==ne)return r.isSupported=!1,r;let{document:s}=t;const i=s,o=i.currentScript,{DocumentFragment:a,HTMLTemplateElement:h,Node:c,Element:d,NodeFilter:N,NamedNodeMap:M=t.NamedNodeMap||t.MozNamedAttrMap,HTMLFormElement:b,DOMParser:W,trustedTypes:Y}=t,G=d.prototype,j=O(G,"cloneNode"),z=O(G,"remove"),K=O(G,"nextSibling"),X=O(G,"childNodes"),Q=O(G,"parentNode");if("function"==typeof h){const e=s.createElement("template");e.content&&e.content.ownerDocument&&(s=e.content.ownerDocument)}let ie,oe="";const{implementation:ae,createNodeIterator:le,createDocumentFragment:he,getElementsByTagName:ue}=s,{importNode:ce}=i;let de={afterSanitizeAttributes:[],afterSanitizeElements:[],afterSanitizeShadowDOM:[],beforeSanitizeAttributes:[],beforeSanitizeElements:[],beforeSanitizeShadowDOM:[],uponSanitizeAttribute:[],uponSanitizeElement:[],uponSanitizeShadowNode:[]};r.isSupported="function"==typeof n&&"function"==typeof Q&&ae&&void 0!==ae.createHTMLDocument;const{MUSTACHE_EXPR:pe,ERB_EXPR:ge,TMPLIT_EXPR:fe,DATA_ATTR:me,ARIA_ATTR:ye,IS_SCRIPT_OR_DATA:Ee,ATTR_WHITESPACE:we,CUSTOM_ELEMENT:Ce}=Z;let{IS_ALLOWED_URI:ve}=Z,Re=null;const Se=_({},[...I,...x,...P,...D,...H]);let Te=null;const Ne=_({},[...F,...U,...V,...B]);let Me=Object.seal(u(null,{tagNameCheck:{writable:!0,configurable:!1,enumerable:!0,value:null},attributeNameCheck:{writable:!0,configurable:!1,enumerable:!0,value:null},allowCustomizedBuiltInElements:{writable:!0,configurable:!1,enumerable:!0,value:!1}})),_e=null,be=null,Ae=!0,Oe=!0,Ie=!1,xe=!0,Pe=!1,Le=!0,De=!1,ke=!1,He=!1,Fe=!1,Ue=!1,Ve=!1,Be=!0,We=!1,Ye=!0,Ge=!1,je={},ze=null;const $e=_({},["annotation-xml","audio","colgroup","desc","foreignobject","head","iframe","math","mi","mn","mo","ms","mtext","noembed","noframes","noscript","plaintext","script","style","svg","template","thead","title","video","xmp"]);let Ke=null;const Xe=_({},["audio","video","img","source","image","track"]);let qe=null;const Qe=_({},["alt","class","for","id","label","name","pattern","placeholder","role","summary","title","value","style","xmlns"]),Ze="http://www.w3.org/1998/Math/MathML",Je="http://www.w3.org/2000/svg",et="http://www.w3.org/1999/xhtml";let tt=et,rt=!1,nt=null;const st=_({},[Ze,Je,et],y);let it=_({},["mi","mo","mn","ms","mtext"]),ot=_({},["annotation-xml"]);const at=_({},["title","style","font","a","script"]);let lt=null;const ht=["application/xhtml+xml","text/html"];let ut=null,ct=null;const dt=s.createElement("form"),pt=function(e){return e instanceof RegExp||e instanceof Function},gt=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};if(!ct||ct!==e){if(e&&"object"==typeof e||(e={}),e=A(e),lt=-1===ht.indexOf(e.PARSER_MEDIA_TYPE)?"text/html":e.PARSER_MEDIA_TYPE,ut="application/xhtml+xml"===lt?y:m,Re=R(e,"ALLOWED_TAGS")?_({},e.ALLOWED_TAGS,ut):Se,Te=R(e,"ALLOWED_ATTR")?_({},e.ALLOWED_ATTR,ut):Ne,nt=R(e,"ALLOWED_NAMESPACES")?_({},e.ALLOWED_NAMESPACES,y):st,qe=R(e,"ADD_URI_SAFE_ATTR")?_(A(Qe),e.ADD_URI_SAFE_ATTR,ut):Qe,Ke=R(e,"ADD_DATA_URI_TAGS")?_(A(Xe),e.ADD_DATA_URI_TAGS,ut):Xe,ze=R(e,"FORBID_CONTENTS")?_({},e.FORBID_CONTENTS,ut):$e,_e=R(e,"FORBID_TAGS")?_({},e.FORBID_TAGS,ut):{},be=R(e,"FORBID_ATTR")?_({},e.FORBID_ATTR,ut):{},je=!!R(e,"USE_PROFILES")&&e.USE_PROFILES,Ae=!1!==e.ALLOW_ARIA_ATTR,Oe=!1!==e.ALLOW_DATA_ATTR,Ie=e.ALLOW_UNKNOWN_PROTOCOLS||!1,xe=!1!==e.ALLOW_SELF_CLOSE_IN_ATTR,Pe=e.SAFE_FOR_TEMPLATES||!1,Le=!1!==e.SAFE_FOR_XML,De=e.WHOLE_DOCUMENT||!1,Fe=e.RETURN_DOM||!1,Ue=e.RETURN_DOM_FRAGMENT||!1,Ve=e.RETURN_TRUSTED_TYPE||!1,He=e.FORCE_BODY||!1,Be=!1!==e.SANITIZE_DOM,We=e.SANITIZE_NAMED_PROPS||!1,Ye=!1!==e.KEEP_CONTENT,Ge=e.IN_PLACE||!1,ve=e.ALLOWED_URI_REGEXP||$,tt=e.NAMESPACE||et,it=e.MATHML_TEXT_INTEGRATION_POINTS||it,ot=e.HTML_INTEGRATION_POINTS||ot,Me=e.CUSTOM_ELEMENT_HANDLING||{},e.CUSTOM_ELEMENT_HANDLING&&pt(e.CUSTOM_ELEMENT_HANDLING.tagNameCheck)&&(Me.tagNameCheck=e.CUSTOM_ELEMENT_HANDLING.tagNameCheck),e.CUSTOM_ELEMENT_HANDLING&&pt(e.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)&&(Me.attributeNameCheck=e.CUSTOM_ELEMENT_HANDLING.attributeNameCheck),e.CUSTOM_ELEMENT_HANDLING&&"boolean"==typeof e.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements&&(Me.allowCustomizedBuiltInElements=e.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements),Pe&&(Oe=!1),Ue&&(Fe=!0),je&&(Re=_({},H),Te=[],!0===je.html&&(_(Re,I),_(Te,F)),!0===je.svg&&(_(Re,x),_(Te,U),_(Te,B)),!0===je.svgFilters&&(_(Re,P),_(Te,U),_(Te,B)),!0===je.mathMl&&(_(Re,D),_(Te,V),_(Te,B))),e.ADD_TAGS&&(Re===Se&&(Re=A(Re)),_(Re,e.ADD_TAGS,ut)),e.ADD_ATTR&&(Te===Ne&&(Te=A(Te)),_(Te,e.ADD_ATTR,ut)),e.ADD_URI_SAFE_ATTR&&_(qe,e.ADD_URI_SAFE_ATTR,ut),e.FORBID_CONTENTS&&(ze===$e&&(ze=A(ze)),_(ze,e.FORBID_CONTENTS,ut)),Ye&&(Re["#text"]=!0),De&&_(Re,["html","head","body"]),Re.table&&(_(Re,["tbody"]),delete _e.tbody),e.TRUSTED_TYPES_POLICY){if("function"!=typeof e.TRUSTED_TYPES_POLICY.createHTML)throw T('TRUSTED_TYPES_POLICY configuration option must provide a "createHTML" hook.');if("function"!=typeof e.TRUSTED_TYPES_POLICY.createScriptURL)throw T('TRUSTED_TYPES_POLICY configuration option must provide a "createScriptURL" hook.');ie=e.TRUSTED_TYPES_POLICY,oe=ie.createHTML("")}else void 0===ie&&(ie=function(e,t){if("object"!=typeof e||"function"!=typeof e.createPolicy)return null;let r=null;const n="data-tt-policy-suffix";t&&t.hasAttribute(n)&&(r=t.getAttribute(n));const s="dompurify"+(r?"#"+r:"");try{return e.createPolicy(s,{createHTML:e=>e,createScriptURL:e=>e})}catch(e){return console.warn("TrustedTypes policy "+s+" could not be created."),null}}(Y,o)),null!==ie&&"string"==typeof oe&&(oe=ie.createHTML(""));l&&l(e),ct=e}},ft=_({},[...x,...P,...L]),mt=_({},[...D,...k]),yt=function(e){f(r.removed,{element:e});try{Q(e).removeChild(e)}catch(t){z(e)}},Et=function(e,t){try{f(r.removed,{attribute:t.getAttributeNode(e),from:t})}catch(e){f(r.removed,{attribute:null,from:t})}if(t.removeAttribute(e),"is"===e)if(Fe||Ue)try{yt(t)}catch(e){}else try{t.setAttribute(e,"")}catch(e){}},wt=function(e){let t=null,r=null;if(He)e="<remove></remove>"+e;else{const t=E(e,/^[\r\n\t ]+/);r=t&&t[0]}"application/xhtml+xml"===lt&&tt===et&&(e='<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>'+e+"</body></html>");const n=ie?ie.createHTML(e):e;if(tt===et)try{t=(new W).parseFromString(n,lt)}catch(e){}if(!t||!t.documentElement){t=ae.createDocument(tt,"template",null);try{t.documentElement.innerHTML=rt?oe:n}catch(e){}}const i=t.body||t.documentElement;return e&&r&&i.insertBefore(s.createTextNode(r),i.childNodes[0]||null),tt===et?ue.call(t,De?"html":"body")[0]:De?t.documentElement:i},Ct=function(e){return le.call(e.ownerDocument||e,e,N.SHOW_ELEMENT|N.SHOW_COMMENT|N.SHOW_TEXT|N.SHOW_PROCESSING_INSTRUCTION|N.SHOW_CDATA_SECTION,null)},vt=function(e){return e instanceof b&&("string"!=typeof e.nodeName||"string"!=typeof e.textContent||"function"!=typeof e.removeChild||!(e.attributes instanceof M)||"function"!=typeof e.removeAttribute||"function"!=typeof e.setAttribute||"string"!=typeof e.namespaceURI||"function"!=typeof e.insertBefore||"function"!=typeof e.hasChildNodes)},Rt=function(e){return"function"==typeof c&&e instanceof c};function St(e,t,n){p(e,(e=>{e.call(r,t,n,ct)}))}const Tt=function(e){let t=null;if(St(de.beforeSanitizeElements,e,null),vt(e))return yt(e),!0;const n=ut(e.nodeName);if(St(de.uponSanitizeElement,e,{tagName:n,allowedTags:Re}),e.hasChildNodes()&&!Rt(e.firstElementChild)&&S(/<[/\w]/g,e.innerHTML)&&S(/<[/\w]/g,e.textContent))return yt(e),!0;if(e.nodeType===te)return yt(e),!0;if(Le&&e.nodeType===re&&S(/<[/\w]/g,e.data))return yt(e),!0;if(!Re[n]||_e[n]){if(!_e[n]&&Mt(n)){if(Me.tagNameCheck instanceof RegExp&&S(Me.tagNameCheck,n))return!1;if(Me.tagNameCheck instanceof Function&&Me.tagNameCheck(n))return!1}if(Ye&&!ze[n]){const t=Q(e)||e.parentNode,r=X(e)||e.childNodes;if(r&&t){for(let n=r.length-1;n>=0;--n){const s=j(r[n],!0);s.__removalCount=(e.__removalCount||0)+1,t.insertBefore(s,K(e))}}}return yt(e),!0}return e instanceof d&&!function(e){let t=Q(e);t&&t.tagName||(t={namespaceURI:tt,tagName:"template"});const r=m(e.tagName),n=m(t.tagName);return!!nt[e.namespaceURI]&&(e.namespaceURI===Je?t.namespaceURI===et?"svg"===r:t.namespaceURI===Ze?"svg"===r&&("annotation-xml"===n||it[n]):Boolean(ft[r]):e.namespaceURI===Ze?t.namespaceURI===et?"math"===r:t.namespaceURI===Je?"math"===r&&ot[n]:Boolean(mt[r]):e.namespaceURI===et?!(t.namespaceURI===Je&&!ot[n])&&!(t.namespaceURI===Ze&&!it[n])&&!mt[r]&&(at[r]||!ft[r]):!("application/xhtml+xml"!==lt||!nt[e.namespaceURI]))}(e)?(yt(e),!0):"noscript"!==n&&"noembed"!==n&&"noframes"!==n||!S(/<\/no(script|embed|frames)/i,e.innerHTML)?(Pe&&e.nodeType===ee&&(t=e.textContent,p([pe,ge,fe],(e=>{t=w(t,e," ")})),e.textContent!==t&&(f(r.removed,{element:e.cloneNode()}),e.textContent=t)),St(de.afterSanitizeElements,e,null),!1):(yt(e),!0)},Nt=function(e,t,r){if(Be&&("id"===t||"name"===t)&&(r in s||r in dt))return!1;if(Oe&&!be[t]&&S(me,t));else if(Ae&&S(ye,t));else if(!Te[t]||be[t]){if(!(Mt(e)&&(Me.tagNameCheck instanceof RegExp&&S(Me.tagNameCheck,e)||Me.tagNameCheck instanceof Function&&Me.tagNameCheck(e))&&(Me.attributeNameCheck instanceof RegExp&&S(Me.attributeNameCheck,t)||Me.attributeNameCheck instanceof Function&&Me.attributeNameCheck(t))||"is"===t&&Me.allowCustomizedBuiltInElements&&(Me.tagNameCheck instanceof RegExp&&S(Me.tagNameCheck,r)||Me.tagNameCheck instanceof Function&&Me.tagNameCheck(r))))return!1}else if(qe[t]);else if(S(ve,w(r,we,"")));else if("src"!==t&&"xlink:href"!==t&&"href"!==t||"script"===e||0!==C(r,"data:")||!Ke[e]){if(Ie&&!S(Ee,w(r,we,"")));else if(r)return!1}else;return!0},Mt=function(e){return"annotation-xml"!==e&&E(e,Ce)},_t=function(e){St(de.beforeSanitizeAttributes,e,null);const{attributes:t}=e;if(!t)return;const n={attrName:"",attrValue:"",keepAttr:!0,allowedAttributes:Te,forceKeepAttr:void 0};let s=t.length;for(;s--;){const i=t[s],{name:o,namespaceURI:a,value:l}=i,h=ut(o);let u="value"===o?l:v(l);if(n.attrName=h,n.attrValue=u,n.keepAttr=!0,n.forceKeepAttr=void 0,St(de.uponSanitizeAttribute,e,n),u=n.attrValue,!We||"id"!==h&&"name"!==h||(Et(o,e),u="user-content-"+u),Le&&S(/((--!?|])>)|<\/(style|title)/i,u)){Et(o,e);continue}if(n.forceKeepAttr)continue;if(Et(o,e),!n.keepAttr)continue;if(!xe&&S(/\/>/i,u)){Et(o,e);continue}Pe&&p([pe,ge,fe],(e=>{u=w(u,e," ")}));const c=ut(e.nodeName);if(Nt(c,h,u)){if(ie&&"object"==typeof Y&&"function"==typeof Y.getAttributeType)if(a);else switch(Y.getAttributeType(c,h)){case"TrustedHTML":u=ie.createHTML(u);break;case"TrustedScriptURL":u=ie.createScriptURL(u)}try{a?e.setAttributeNS(a,o,u):e.setAttribute(o,u),vt(e)?yt(e):g(r.removed)}catch(e){}}}St(de.afterSanitizeAttributes,e,null)},bt=function e(t){let r=null;const n=Ct(t);for(St(de.beforeSanitizeShadowDOM,t,null);r=n.nextNode();)St(de.uponSanitizeShadowNode,r,null),Tt(r)||(r.content instanceof a&&e(r.content),_t(r));St(de.afterSanitizeShadowDOM,t,null)};return r.sanitize=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=null,s=null,o=null,l=null;if(rt=!e,rt&&(e="\x3c!--\x3e"),"string"!=typeof e&&!Rt(e)){if("function"!=typeof e.toString)throw T("toString is not a function");if("string"!=typeof(e=e.toString()))throw T("dirty is not a string, aborting")}if(!r.isSupported)return e;if(ke||gt(t),r.removed=[],"string"==typeof e&&(Ge=!1),Ge){if(e.nodeName){const t=ut(e.nodeName);if(!Re[t]||_e[t])throw T("root node is forbidden and cannot be sanitized in-place")}}else if(e instanceof c)n=wt("\x3c!----\x3e"),s=n.ownerDocument.importNode(e,!0),s.nodeType===J&&"BODY"===s.nodeName||"HTML"===s.nodeName?n=s:n.appendChild(s);else{if(!Fe&&!Pe&&!De&&-1===e.indexOf("<"))return ie&&Ve?ie.createHTML(e):e;if(n=wt(e),!n)return Fe?null:Ve?oe:""}n&&He&&yt(n.firstChild);const h=Ct(Ge?e:n);for(;o=h.nextNode();)Tt(o)||(o.content instanceof a&&bt(o.content),_t(o));if(Ge)return e;if(Fe){if(Ue)for(l=he.call(n.ownerDocument);n.firstChild;)l.appendChild(n.firstChild);else l=n;return(Te.shadowroot||Te.shadowrootmode)&&(l=ce.call(i,l,!0)),l}let u=De?n.outerHTML:n.innerHTML;return De&&Re["!doctype"]&&n.ownerDocument&&n.ownerDocument.doctype&&n.ownerDocument.doctype.name&&S(q,n.ownerDocument.doctype.name)&&(u="<!DOCTYPE "+n.ownerDocument.doctype.name+">\n"+u),Pe&&p([pe,ge,fe],(e=>{u=w(u,e," ")})),ie&&Ve?ie.createHTML(u):u},r.setConfig=function(){gt(arguments.length>0&&void 0!==arguments[0]?arguments[0]:{}),ke=!0},r.clearConfig=function(){ct=null,ke=!1},r.isValidAttribute=function(e,t,r){ct||gt({});const n=ut(e),s=ut(t);return Nt(n,s,r)},r.addHook=function(e,t){"function"==typeof t&&f(de[e],t)},r.removeHook=function(e){return g(de[e])},r.removeHooks=function(e){de[e]=[]},r.removeAllHooks=function(){de={afterSanitizeAttributes:[],afterSanitizeElements:[],afterSanitizeShadowDOM:[],beforeSanitizeAttributes:[],beforeSanitizeElements:[],beforeSanitizeShadowDOM:[],uponSanitizeAttribute:[],uponSanitizeElement:[],uponSanitizeShadowNode:[]}},r}();e.exports=ie,window.DOMPurify=r(98339)},37086:()=>{},17289:()=>{},65145:()=>{},70872:()=>{},66569:()=>{},90470:()=>{},25819:()=>{},39685:()=>{},73762:()=>{},38906:()=>{},22956:()=>{},11414:()=>{},42516:()=>{},49888:()=>{},63933:()=>{},30718:()=>{},44169:()=>{},96954:()=>{},97417:()=>{},97527:()=>{},92556:()=>{},67105:()=>{},14130:()=>{},18158:()=>{},98952:()=>{},21918:()=>{},53611:()=>{},25496:()=>{},28809:()=>{},7275:()=>{},57306:()=>{},2609:()=>{},82970:()=>{},46192:()=>{},20851:()=>{},97953:()=>{},5137:()=>{},30147:()=>{},49999:()=>{},17778:()=>{},18741:()=>{},75712:()=>{},65431:()=>{},61716:()=>{},61388:()=>{},7858:()=>{},89098:()=>{},55218:()=>{},58713:()=>{},72237:()=>{},31260:()=>{},25485:()=>{},39842:()=>{},4986:()=>{},18691:()=>{},87812:()=>{},28833:()=>{},63434:()=>{},24254:()=>{},87235:()=>{},26074:()=>{},63237:()=>{},58844:()=>{},86937:()=>{},4566:()=>{},5324:()=>{},38728:()=>{},49165:()=>{},17905:()=>{},82759:()=>{},7525:()=>{},77788:()=>{},59427:()=>{},92022:()=>{},88029:()=>{},5881:()=>{},60039:()=>{},45284:()=>{},5909:()=>{},47891:()=>{},52047:()=>{},4163:()=>{},47301:()=>{},46800:()=>{},84122:()=>{},17886:()=>{},11680:()=>{},51101:()=>{},70888:()=>{},18227:()=>{},78629:()=>{},12304:()=>{},45745:()=>{},40847:()=>{},11249:()=>{},45617:()=>{},24532:()=>{},51001:()=>{},77498:()=>{},43793:()=>{},95758:()=>{},34220:()=>{},34646:()=>{},26709:()=>{},37089:()=>{},18271:()=>{},11422:()=>{},67401:()=>{},65775:()=>{},17040:()=>{},40263:()=>{},92764:()=>{},74403:()=>{},65026:()=>{},58830:()=>{},4048:()=>{},86436:()=>{},18505:()=>{},33968:()=>{},63422:()=>{},45441:()=>{},92671:()=>{},4659:()=>{},67956:()=>{},80204:()=>{},65191:()=>{},21949:()=>{},23174:()=>{},19286:()=>{},26158:()=>{},12284:()=>{},14912:()=>{},59357:()=>{},1313:()=>{},73021:()=>{},21312:()=>{},16629:()=>{},6671:function(e,t,r){(e=r.nmd(e)).exports=function(){"use strict";var t,n;function s(){return t.apply(null,arguments)}function i(e){t=e}function o(e){return e instanceof Array||"[object Array]"===Object.prototype.toString.call(e)}function a(e){return null!=e&&"[object Object]"===Object.prototype.toString.call(e)}function l(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function h(e){if(Object.getOwnPropertyNames)return 0===Object.getOwnPropertyNames(e).length;var t;for(t in e)if(l(e,t))return!1;return!0}function u(e){return void 0===e}function c(e){return"number"==typeof e||"[object Number]"===Object.prototype.toString.call(e)}function d(e){return e instanceof Date||"[object Date]"===Object.prototype.toString.call(e)}function p(e,t){var r,n=[],s=e.length;for(r=0;r<s;++r)n.push(t(e[r],r));return n}function g(e,t){for(var r in t)l(t,r)&&(e[r]=t[r]);return l(t,"toString")&&(e.toString=t.toString),l(t,"valueOf")&&(e.valueOf=t.valueOf),e}function f(e,t,r,n){return Kr(e,t,r,n,!0).utc()}function m(){return{empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidEra:null,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],era:null,meridiem:null,rfc2822:!1,weekdayMismatch:!1}}function y(e){return null==e._pf&&(e._pf=m()),e._pf}function E(e){var t=null,r=!1,s=e._d&&!isNaN(e._d.getTime());return s&&(t=y(e),r=n.call(t.parsedDateParts,(function(e){return null!=e})),s=t.overflow<0&&!t.empty&&!t.invalidEra&&!t.invalidMonth&&!t.invalidWeekday&&!t.weekdayMismatch&&!t.nullInput&&!t.invalidFormat&&!t.userInvalidated&&(!t.meridiem||t.meridiem&&r),e._strict&&(s=s&&0===t.charsLeftOver&&0===t.unusedTokens.length&&void 0===t.bigHour)),null!=Object.isFrozen&&Object.isFrozen(e)?s:(e._isValid=s,e._isValid)}function w(e){var t=f(NaN);return null!=e?g(y(t),e):y(t).userInvalidated=!0,t}n=Array.prototype.some?Array.prototype.some:function(e){var t,r=Object(this),n=r.length>>>0;for(t=0;t<n;t++)if(t in r&&e.call(this,r[t],t,r))return!0;return!1};var C=s.momentProperties=[],v=!1;function R(e,t){var r,n,s,i=C.length;if(u(t._isAMomentObject)||(e._isAMomentObject=t._isAMomentObject),u(t._i)||(e._i=t._i),u(t._f)||(e._f=t._f),u(t._l)||(e._l=t._l),u(t._strict)||(e._strict=t._strict),u(t._tzm)||(e._tzm=t._tzm),u(t._isUTC)||(e._isUTC=t._isUTC),u(t._offset)||(e._offset=t._offset),u(t._pf)||(e._pf=y(t)),u(t._locale)||(e._locale=t._locale),i>0)for(r=0;r<i;r++)u(s=t[n=C[r]])||(e[n]=s);return e}function S(e){R(this,e),this._d=new Date(null!=e._d?e._d.getTime():NaN),this.isValid()||(this._d=new Date(NaN)),!1===v&&(v=!0,s.updateOffset(this),v=!1)}function T(e){return e instanceof S||null!=e&&null!=e._isAMomentObject}function N(e){!1===s.suppressDeprecationWarnings&&"undefined"!=typeof console&&console.warn&&console.warn("Deprecation warning: "+e)}function M(e,t){var r=!0;return g((function(){if(null!=s.deprecationHandler&&s.deprecationHandler(null,e),r){var n,i,o,a=[],h=arguments.length;for(i=0;i<h;i++){if(n="","object"==typeof arguments[i]){for(o in n+="\n["+i+"] ",arguments[0])l(arguments[0],o)&&(n+=o+": "+arguments[0][o]+", ");n=n.slice(0,-2)}else n=arguments[i];a.push(n)}N(e+"\nArguments: "+Array.prototype.slice.call(a).join("")+"\n"+(new Error).stack),r=!1}return t.apply(this,arguments)}),t)}var _,b={};function A(e,t){null!=s.deprecationHandler&&s.deprecationHandler(e,t),b[e]||(N(t),b[e]=!0)}function O(e){return"undefined"!=typeof Function&&e instanceof Function||"[object Function]"===Object.prototype.toString.call(e)}function I(e){var t,r;for(r in e)l(e,r)&&(O(t=e[r])?this[r]=t:this["_"+r]=t);this._config=e,this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+"|"+/\d{1,2}/.source)}function x(e,t){var r,n=g({},e);for(r in t)l(t,r)&&(a(e[r])&&a(t[r])?(n[r]={},g(n[r],e[r]),g(n[r],t[r])):null!=t[r]?n[r]=t[r]:delete n[r]);for(r in e)l(e,r)&&!l(t,r)&&a(e[r])&&(n[r]=g({},n[r]));return n}function P(e){null!=e&&this.set(e)}s.suppressDeprecationWarnings=!1,s.deprecationHandler=null,_=Object.keys?Object.keys:function(e){var t,r=[];for(t in e)l(e,t)&&r.push(t);return r};var L={sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"};function D(e,t,r){var n=this._calendar[e]||this._calendar.sameElse;return O(n)?n.call(t,r):n}function k(e,t,r){var n=""+Math.abs(e),s=t-n.length;return(e>=0?r?"+":"":"-")+Math.pow(10,Math.max(0,s)).toString().substr(1)+n}var H=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|N{1,5}|YYYYYY|YYYYY|YYYY|YY|y{2,4}|yo?|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,F=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,U={},V={};function B(e,t,r,n){var s=n;"string"==typeof n&&(s=function(){return this[n]()}),e&&(V[e]=s),t&&(V[t[0]]=function(){return k(s.apply(this,arguments),t[1],t[2])}),r&&(V[r]=function(){return this.localeData().ordinal(s.apply(this,arguments),e)})}function W(e){return e.match(/\[[\s\S]/)?e.replace(/^\[|\]$/g,""):e.replace(/\\/g,"")}function Y(e){var t,r,n=e.match(H);for(t=0,r=n.length;t<r;t++)V[n[t]]?n[t]=V[n[t]]:n[t]=W(n[t]);return function(t){var s,i="";for(s=0;s<r;s++)i+=O(n[s])?n[s].call(t,e):n[s];return i}}function G(e,t){return e.isValid()?(t=j(t,e.localeData()),U[t]=U[t]||Y(t),U[t](e)):e.localeData().invalidDate()}function j(e,t){var r=5;function n(e){return t.longDateFormat(e)||e}for(F.lastIndex=0;r>=0&&F.test(e);)e=e.replace(F,n),F.lastIndex=0,r-=1;return e}var z={LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"};function $(e){var t=this._longDateFormat[e],r=this._longDateFormat[e.toUpperCase()];return t||!r?t:(this._longDateFormat[e]=r.match(H).map((function(e){return"MMMM"===e||"MM"===e||"DD"===e||"dddd"===e?e.slice(1):e})).join(""),this._longDateFormat[e])}var K="Invalid date";function X(){return this._invalidDate}var q="%d",Q=/\d{1,2}/;function Z(e){return this._ordinal.replace("%d",e)}var J={future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",w:"a week",ww:"%d weeks",M:"a month",MM:"%d months",y:"a year",yy:"%d years"};function ee(e,t,r,n){var s=this._relativeTime[r];return O(s)?s(e,t,r,n):s.replace(/%d/i,e)}function te(e,t){var r=this._relativeTime[e>0?"future":"past"];return O(r)?r(t):r.replace(/%s/i,t)}var re={D:"date",dates:"date",date:"date",d:"day",days:"day",day:"day",e:"weekday",weekdays:"weekday",weekday:"weekday",E:"isoWeekday",isoweekdays:"isoWeekday",isoweekday:"isoWeekday",DDD:"dayOfYear",dayofyears:"dayOfYear",dayofyear:"dayOfYear",h:"hour",hours:"hour",hour:"hour",ms:"millisecond",milliseconds:"millisecond",millisecond:"millisecond",m:"minute",minutes:"minute",minute:"minute",M:"month",months:"month",month:"month",Q:"quarter",quarters:"quarter",quarter:"quarter",s:"second",seconds:"second",second:"second",gg:"weekYear",weekyears:"weekYear",weekyear:"weekYear",GG:"isoWeekYear",isoweekyears:"isoWeekYear",isoweekyear:"isoWeekYear",w:"week",weeks:"week",week:"week",W:"isoWeek",isoweeks:"isoWeek",isoweek:"isoWeek",y:"year",years:"year",year:"year"};function ne(e){return"string"==typeof e?re[e]||re[e.toLowerCase()]:void 0}function se(e){var t,r,n={};for(r in e)l(e,r)&&(t=ne(r))&&(n[t]=e[r]);return n}var ie={date:9,day:11,weekday:11,isoWeekday:11,dayOfYear:4,hour:13,millisecond:16,minute:14,month:8,quarter:7,second:15,weekYear:1,isoWeekYear:1,week:5,isoWeek:5,year:1};function oe(e){var t,r=[];for(t in e)l(e,t)&&r.push({unit:t,priority:ie[t]});return r.sort((function(e,t){return e.priority-t.priority})),r}var ae,le=/\d/,he=/\d\d/,ue=/\d{3}/,ce=/\d{4}/,de=/[+-]?\d{6}/,pe=/\d\d?/,ge=/\d\d\d\d?/,fe=/\d\d\d\d\d\d?/,me=/\d{1,3}/,ye=/\d{1,4}/,Ee=/[+-]?\d{1,6}/,we=/\d+/,Ce=/[+-]?\d+/,ve=/Z|[+-]\d\d:?\d\d/gi,Re=/Z|[+-]\d\d(?::?\d\d)?/gi,Se=/[+-]?\d+(\.\d{1,3})?/,Te=/[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i,Ne=/^[1-9]\d?/,Me=/^([1-9]\d|\d)/;function _e(e,t,r){ae[e]=O(t)?t:function(e,n){return e&&r?r:t}}function be(e,t){return l(ae,e)?ae[e](t._strict,t._locale):new RegExp(Ae(e))}function Ae(e){return Oe(e.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,(function(e,t,r,n,s){return t||r||n||s})))}function Oe(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}function Ie(e){return e<0?Math.ceil(e)||0:Math.floor(e)}function xe(e){var t=+e,r=0;return 0!==t&&isFinite(t)&&(r=Ie(t)),r}ae={};var Pe={};function Le(e,t){var r,n,s=t;for("string"==typeof e&&(e=[e]),c(t)&&(s=function(e,r){r[t]=xe(e)}),n=e.length,r=0;r<n;r++)Pe[e[r]]=s}function De(e,t){Le(e,(function(e,r,n,s){n._w=n._w||{},t(e,n._w,n,s)}))}function ke(e,t,r){null!=t&&l(Pe,e)&&Pe[e](t,r._a,r,e)}function He(e){return e%4==0&&e%100!=0||e%400==0}var Fe=0,Ue=1,Ve=2,Be=3,We=4,Ye=5,Ge=6,je=7,ze=8;function $e(e){return He(e)?366:365}B("Y",0,0,(function(){var e=this.year();return e<=9999?k(e,4):"+"+e})),B(0,["YY",2],0,(function(){return this.year()%100})),B(0,["YYYY",4],0,"year"),B(0,["YYYYY",5],0,"year"),B(0,["YYYYYY",6,!0],0,"year"),_e("Y",Ce),_e("YY",pe,he),_e("YYYY",ye,ce),_e("YYYYY",Ee,de),_e("YYYYYY",Ee,de),Le(["YYYYY","YYYYYY"],Fe),Le("YYYY",(function(e,t){t[Fe]=2===e.length?s.parseTwoDigitYear(e):xe(e)})),Le("YY",(function(e,t){t[Fe]=s.parseTwoDigitYear(e)})),Le("Y",(function(e,t){t[Fe]=parseInt(e,10)})),s.parseTwoDigitYear=function(e){return xe(e)+(xe(e)>68?1900:2e3)};var Ke,Xe=Qe("FullYear",!0);function qe(){return He(this.year())}function Qe(e,t){return function(r){return null!=r?(Je(this,e,r),s.updateOffset(this,t),this):Ze(this,e)}}function Ze(e,t){if(!e.isValid())return NaN;var r=e._d,n=e._isUTC;switch(t){case"Milliseconds":return n?r.getUTCMilliseconds():r.getMilliseconds();case"Seconds":return n?r.getUTCSeconds():r.getSeconds();case"Minutes":return n?r.getUTCMinutes():r.getMinutes();case"Hours":return n?r.getUTCHours():r.getHours();case"Date":return n?r.getUTCDate():r.getDate();case"Day":return n?r.getUTCDay():r.getDay();case"Month":return n?r.getUTCMonth():r.getMonth();case"FullYear":return n?r.getUTCFullYear():r.getFullYear();default:return NaN}}function Je(e,t,r){var n,s,i,o,a;if(e.isValid()&&!isNaN(r)){switch(n=e._d,s=e._isUTC,t){case"Milliseconds":return void(s?n.setUTCMilliseconds(r):n.setMilliseconds(r));case"Seconds":return void(s?n.setUTCSeconds(r):n.setSeconds(r));case"Minutes":return void(s?n.setUTCMinutes(r):n.setMinutes(r));case"Hours":return void(s?n.setUTCHours(r):n.setHours(r));case"Date":return void(s?n.setUTCDate(r):n.setDate(r));case"FullYear":break;default:return}i=r,o=e.month(),a=29!==(a=e.date())||1!==o||He(i)?a:28,s?n.setUTCFullYear(i,o,a):n.setFullYear(i,o,a)}}function et(e){return O(this[e=ne(e)])?this[e]():this}function tt(e,t){if("object"==typeof e){var r,n=oe(e=se(e)),s=n.length;for(r=0;r<s;r++)this[n[r].unit](e[n[r].unit])}else if(O(this[e=ne(e)]))return this[e](t);return this}function rt(e,t){return(e%t+t)%t}function nt(e,t){if(isNaN(e)||isNaN(t))return NaN;var r=rt(t,12);return e+=(t-r)/12,1===r?He(e)?29:28:31-r%7%2}Ke=Array.prototype.indexOf?Array.prototype.indexOf:function(e){var t;for(t=0;t<this.length;++t)if(this[t]===e)return t;return-1},B("M",["MM",2],"Mo",(function(){return this.month()+1})),B("MMM",0,0,(function(e){return this.localeData().monthsShort(this,e)})),B("MMMM",0,0,(function(e){return this.localeData().months(this,e)})),_e("M",pe,Ne),_e("MM",pe,he),_e("MMM",(function(e,t){return t.monthsShortRegex(e)})),_e("MMMM",(function(e,t){return t.monthsRegex(e)})),Le(["M","MM"],(function(e,t){t[Ue]=xe(e)-1})),Le(["MMM","MMMM"],(function(e,t,r,n){var s=r._locale.monthsParse(e,n,r._strict);null!=s?t[Ue]=s:y(r).invalidMonth=e}));var st="January_February_March_April_May_June_July_August_September_October_November_December".split("_"),it="Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),ot=/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,at=Te,lt=Te;function ht(e,t){return e?o(this._months)?this._months[e.month()]:this._months[(this._months.isFormat||ot).test(t)?"format":"standalone"][e.month()]:o(this._months)?this._months:this._months.standalone}function ut(e,t){return e?o(this._monthsShort)?this._monthsShort[e.month()]:this._monthsShort[ot.test(t)?"format":"standalone"][e.month()]:o(this._monthsShort)?this._monthsShort:this._monthsShort.standalone}function ct(e,t,r){var n,s,i,o=e.toLocaleLowerCase();if(!this._monthsParse)for(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],n=0;n<12;++n)i=f([2e3,n]),this._shortMonthsParse[n]=this.monthsShort(i,"").toLocaleLowerCase(),this._longMonthsParse[n]=this.months(i,"").toLocaleLowerCase();return r?"MMM"===t?-1!==(s=Ke.call(this._shortMonthsParse,o))?s:null:-1!==(s=Ke.call(this._longMonthsParse,o))?s:null:"MMM"===t?-1!==(s=Ke.call(this._shortMonthsParse,o))||-1!==(s=Ke.call(this._longMonthsParse,o))?s:null:-1!==(s=Ke.call(this._longMonthsParse,o))||-1!==(s=Ke.call(this._shortMonthsParse,o))?s:null}function dt(e,t,r){var n,s,i;if(this._monthsParseExact)return ct.call(this,e,t,r);for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),n=0;n<12;n++){if(s=f([2e3,n]),r&&!this._longMonthsParse[n]&&(this._longMonthsParse[n]=new RegExp("^"+this.months(s,"").replace(".","")+"$","i"),this._shortMonthsParse[n]=new RegExp("^"+this.monthsShort(s,"").replace(".","")+"$","i")),r||this._monthsParse[n]||(i="^"+this.months(s,"")+"|^"+this.monthsShort(s,""),this._monthsParse[n]=new RegExp(i.replace(".",""),"i")),r&&"MMMM"===t&&this._longMonthsParse[n].test(e))return n;if(r&&"MMM"===t&&this._shortMonthsParse[n].test(e))return n;if(!r&&this._monthsParse[n].test(e))return n}}function pt(e,t){if(!e.isValid())return e;if("string"==typeof t)if(/^\d+$/.test(t))t=xe(t);else if(!c(t=e.localeData().monthsParse(t)))return e;var r=t,n=e.date();return n=n<29?n:Math.min(n,nt(e.year(),r)),e._isUTC?e._d.setUTCMonth(r,n):e._d.setMonth(r,n),e}function gt(e){return null!=e?(pt(this,e),s.updateOffset(this,!0),this):Ze(this,"Month")}function ft(){return nt(this.year(),this.month())}function mt(e){return this._monthsParseExact?(l(this,"_monthsRegex")||Et.call(this),e?this._monthsShortStrictRegex:this._monthsShortRegex):(l(this,"_monthsShortRegex")||(this._monthsShortRegex=at),this._monthsShortStrictRegex&&e?this._monthsShortStrictRegex:this._monthsShortRegex)}function yt(e){return this._monthsParseExact?(l(this,"_monthsRegex")||Et.call(this),e?this._monthsStrictRegex:this._monthsRegex):(l(this,"_monthsRegex")||(this._monthsRegex=lt),this._monthsStrictRegex&&e?this._monthsStrictRegex:this._monthsRegex)}function Et(){function e(e,t){return t.length-e.length}var t,r,n,s,i=[],o=[],a=[];for(t=0;t<12;t++)r=f([2e3,t]),n=Oe(this.monthsShort(r,"")),s=Oe(this.months(r,"")),i.push(n),o.push(s),a.push(s),a.push(n);i.sort(e),o.sort(e),a.sort(e),this._monthsRegex=new RegExp("^("+a.join("|")+")","i"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp("^("+o.join("|")+")","i"),this._monthsShortStrictRegex=new RegExp("^("+i.join("|")+")","i")}function wt(e,t,r,n,s,i,o){var a;return e<100&&e>=0?(a=new Date(e+400,t,r,n,s,i,o),isFinite(a.getFullYear())&&a.setFullYear(e)):a=new Date(e,t,r,n,s,i,o),a}function Ct(e){var t,r;return e<100&&e>=0?((r=Array.prototype.slice.call(arguments))[0]=e+400,t=new Date(Date.UTC.apply(null,r)),isFinite(t.getUTCFullYear())&&t.setUTCFullYear(e)):t=new Date(Date.UTC.apply(null,arguments)),t}function vt(e,t,r){var n=7+t-r;return-(7+Ct(e,0,n).getUTCDay()-t)%7+n-1}function Rt(e,t,r,n,s){var i,o,a=1+7*(t-1)+(7+r-n)%7+vt(e,n,s);return a<=0?o=$e(i=e-1)+a:a>$e(e)?(i=e+1,o=a-$e(e)):(i=e,o=a),{year:i,dayOfYear:o}}function St(e,t,r){var n,s,i=vt(e.year(),t,r),o=Math.floor((e.dayOfYear()-i-1)/7)+1;return o<1?n=o+Tt(s=e.year()-1,t,r):o>Tt(e.year(),t,r)?(n=o-Tt(e.year(),t,r),s=e.year()+1):(s=e.year(),n=o),{week:n,year:s}}function Tt(e,t,r){var n=vt(e,t,r),s=vt(e+1,t,r);return($e(e)-n+s)/7}function Nt(e){return St(e,this._week.dow,this._week.doy).week}B("w",["ww",2],"wo","week"),B("W",["WW",2],"Wo","isoWeek"),_e("w",pe,Ne),_e("ww",pe,he),_e("W",pe,Ne),_e("WW",pe,he),De(["w","ww","W","WW"],(function(e,t,r,n){t[n.substr(0,1)]=xe(e)}));var Mt={dow:0,doy:6};function _t(){return this._week.dow}function bt(){return this._week.doy}function At(e){var t=this.localeData().week(this);return null==e?t:this.add(7*(e-t),"d")}function Ot(e){var t=St(this,1,4).week;return null==e?t:this.add(7*(e-t),"d")}function It(e,t){return"string"!=typeof e?e:isNaN(e)?"number"==typeof(e=t.weekdaysParse(e))?e:null:parseInt(e,10)}function xt(e,t){return"string"==typeof e?t.weekdaysParse(e)%7||7:isNaN(e)?null:e}function Pt(e,t){return e.slice(t,7).concat(e.slice(0,t))}B("d",0,"do","day"),B("dd",0,0,(function(e){return this.localeData().weekdaysMin(this,e)})),B("ddd",0,0,(function(e){return this.localeData().weekdaysShort(this,e)})),B("dddd",0,0,(function(e){return this.localeData().weekdays(this,e)})),B("e",0,0,"weekday"),B("E",0,0,"isoWeekday"),_e("d",pe),_e("e",pe),_e("E",pe),_e("dd",(function(e,t){return t.weekdaysMinRegex(e)})),_e("ddd",(function(e,t){return t.weekdaysShortRegex(e)})),_e("dddd",(function(e,t){return t.weekdaysRegex(e)})),De(["dd","ddd","dddd"],(function(e,t,r,n){var s=r._locale.weekdaysParse(e,n,r._strict);null!=s?t.d=s:y(r).invalidWeekday=e})),De(["d","e","E"],(function(e,t,r,n){t[n]=xe(e)}));var Lt="Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),Dt="Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),kt="Su_Mo_Tu_We_Th_Fr_Sa".split("_"),Ht=Te,Ft=Te,Ut=Te;function Vt(e,t){var r=o(this._weekdays)?this._weekdays:this._weekdays[e&&!0!==e&&this._weekdays.isFormat.test(t)?"format":"standalone"];return!0===e?Pt(r,this._week.dow):e?r[e.day()]:r}function Bt(e){return!0===e?Pt(this._weekdaysShort,this._week.dow):e?this._weekdaysShort[e.day()]:this._weekdaysShort}function Wt(e){return!0===e?Pt(this._weekdaysMin,this._week.dow):e?this._weekdaysMin[e.day()]:this._weekdaysMin}function Yt(e,t,r){var n,s,i,o=e.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],n=0;n<7;++n)i=f([2e3,1]).day(n),this._minWeekdaysParse[n]=this.weekdaysMin(i,"").toLocaleLowerCase(),this._shortWeekdaysParse[n]=this.weekdaysShort(i,"").toLocaleLowerCase(),this._weekdaysParse[n]=this.weekdays(i,"").toLocaleLowerCase();return r?"dddd"===t?-1!==(s=Ke.call(this._weekdaysParse,o))?s:null:"ddd"===t?-1!==(s=Ke.call(this._shortWeekdaysParse,o))?s:null:-1!==(s=Ke.call(this._minWeekdaysParse,o))?s:null:"dddd"===t?-1!==(s=Ke.call(this._weekdaysParse,o))||-1!==(s=Ke.call(this._shortWeekdaysParse,o))||-1!==(s=Ke.call(this._minWeekdaysParse,o))?s:null:"ddd"===t?-1!==(s=Ke.call(this._shortWeekdaysParse,o))||-1!==(s=Ke.call(this._weekdaysParse,o))||-1!==(s=Ke.call(this._minWeekdaysParse,o))?s:null:-1!==(s=Ke.call(this._minWeekdaysParse,o))||-1!==(s=Ke.call(this._weekdaysParse,o))||-1!==(s=Ke.call(this._shortWeekdaysParse,o))?s:null}function Gt(e,t,r){var n,s,i;if(this._weekdaysParseExact)return Yt.call(this,e,t,r);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),n=0;n<7;n++){if(s=f([2e3,1]).day(n),r&&!this._fullWeekdaysParse[n]&&(this._fullWeekdaysParse[n]=new RegExp("^"+this.weekdays(s,"").replace(".","\\.?")+"$","i"),this._shortWeekdaysParse[n]=new RegExp("^"+this.weekdaysShort(s,"").replace(".","\\.?")+"$","i"),this._minWeekdaysParse[n]=new RegExp("^"+this.weekdaysMin(s,"").replace(".","\\.?")+"$","i")),this._weekdaysParse[n]||(i="^"+this.weekdays(s,"")+"|^"+this.weekdaysShort(s,"")+"|^"+this.weekdaysMin(s,""),this._weekdaysParse[n]=new RegExp(i.replace(".",""),"i")),r&&"dddd"===t&&this._fullWeekdaysParse[n].test(e))return n;if(r&&"ddd"===t&&this._shortWeekdaysParse[n].test(e))return n;if(r&&"dd"===t&&this._minWeekdaysParse[n].test(e))return n;if(!r&&this._weekdaysParse[n].test(e))return n}}function jt(e){if(!this.isValid())return null!=e?this:NaN;var t=Ze(this,"Day");return null!=e?(e=It(e,this.localeData()),this.add(e-t,"d")):t}function zt(e){if(!this.isValid())return null!=e?this:NaN;var t=(this.day()+7-this.localeData()._week.dow)%7;return null==e?t:this.add(e-t,"d")}function $t(e){if(!this.isValid())return null!=e?this:NaN;if(null!=e){var t=xt(e,this.localeData());return this.day(this.day()%7?t:t-7)}return this.day()||7}function Kt(e){return this._weekdaysParseExact?(l(this,"_weekdaysRegex")||Qt.call(this),e?this._weekdaysStrictRegex:this._weekdaysRegex):(l(this,"_weekdaysRegex")||(this._weekdaysRegex=Ht),this._weekdaysStrictRegex&&e?this._weekdaysStrictRegex:this._weekdaysRegex)}function Xt(e){return this._weekdaysParseExact?(l(this,"_weekdaysRegex")||Qt.call(this),e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(l(this,"_weekdaysShortRegex")||(this._weekdaysShortRegex=Ft),this._weekdaysShortStrictRegex&&e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)}function qt(e){return this._weekdaysParseExact?(l(this,"_weekdaysRegex")||Qt.call(this),e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(l(this,"_weekdaysMinRegex")||(this._weekdaysMinRegex=Ut),this._weekdaysMinStrictRegex&&e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)}function Qt(){function e(e,t){return t.length-e.length}var t,r,n,s,i,o=[],a=[],l=[],h=[];for(t=0;t<7;t++)r=f([2e3,1]).day(t),n=Oe(this.weekdaysMin(r,"")),s=Oe(this.weekdaysShort(r,"")),i=Oe(this.weekdays(r,"")),o.push(n),a.push(s),l.push(i),h.push(n),h.push(s),h.push(i);o.sort(e),a.sort(e),l.sort(e),h.sort(e),this._weekdaysRegex=new RegExp("^("+h.join("|")+")","i"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp("^("+l.join("|")+")","i"),this._weekdaysShortStrictRegex=new RegExp("^("+a.join("|")+")","i"),this._weekdaysMinStrictRegex=new RegExp("^("+o.join("|")+")","i")}function Zt(){return this.hours()%12||12}function Jt(){return this.hours()||24}function er(e,t){B(e,0,0,(function(){return this.localeData().meridiem(this.hours(),this.minutes(),t)}))}function tr(e,t){return t._meridiemParse}function rr(e){return"p"===(e+"").toLowerCase().charAt(0)}B("H",["HH",2],0,"hour"),B("h",["hh",2],0,Zt),B("k",["kk",2],0,Jt),B("hmm",0,0,(function(){return""+Zt.apply(this)+k(this.minutes(),2)})),B("hmmss",0,0,(function(){return""+Zt.apply(this)+k(this.minutes(),2)+k(this.seconds(),2)})),B("Hmm",0,0,(function(){return""+this.hours()+k(this.minutes(),2)})),B("Hmmss",0,0,(function(){return""+this.hours()+k(this.minutes(),2)+k(this.seconds(),2)})),er("a",!0),er("A",!1),_e("a",tr),_e("A",tr),_e("H",pe,Me),_e("h",pe,Ne),_e("k",pe,Ne),_e("HH",pe,he),_e("hh",pe,he),_e("kk",pe,he),_e("hmm",ge),_e("hmmss",fe),_e("Hmm",ge),_e("Hmmss",fe),Le(["H","HH"],Be),Le(["k","kk"],(function(e,t,r){var n=xe(e);t[Be]=24===n?0:n})),Le(["a","A"],(function(e,t,r){r._isPm=r._locale.isPM(e),r._meridiem=e})),Le(["h","hh"],(function(e,t,r){t[Be]=xe(e),y(r).bigHour=!0})),Le("hmm",(function(e,t,r){var n=e.length-2;t[Be]=xe(e.substr(0,n)),t[We]=xe(e.substr(n)),y(r).bigHour=!0})),Le("hmmss",(function(e,t,r){var n=e.length-4,s=e.length-2;t[Be]=xe(e.substr(0,n)),t[We]=xe(e.substr(n,2)),t[Ye]=xe(e.substr(s)),y(r).bigHour=!0})),Le("Hmm",(function(e,t,r){var n=e.length-2;t[Be]=xe(e.substr(0,n)),t[We]=xe(e.substr(n))})),Le("Hmmss",(function(e,t,r){var n=e.length-4,s=e.length-2;t[Be]=xe(e.substr(0,n)),t[We]=xe(e.substr(n,2)),t[Ye]=xe(e.substr(s))}));var nr=/[ap]\.?m?\.?/i,sr=Qe("Hours",!0);function ir(e,t,r){return e>11?r?"pm":"PM":r?"am":"AM"}var or,ar={calendar:L,longDateFormat:z,invalidDate:K,ordinal:q,dayOfMonthOrdinalParse:Q,relativeTime:J,months:st,monthsShort:it,week:Mt,weekdays:Lt,weekdaysMin:kt,weekdaysShort:Dt,meridiemParse:nr},lr={},hr={};function ur(e,t){var r,n=Math.min(e.length,t.length);for(r=0;r<n;r+=1)if(e[r]!==t[r])return r;return n}function cr(e){return e?e.toLowerCase().replace("_","-"):e}function dr(e){for(var t,r,n,s,i=0;i<e.length;){for(t=(s=cr(e[i]).split("-")).length,r=(r=cr(e[i+1]))?r.split("-"):null;t>0;){if(n=gr(s.slice(0,t).join("-")))return n;if(r&&r.length>=t&&ur(s,r)>=t-1)break;t--}i++}return or}function pr(e){return!(!e||!e.match("^[^/\\\\]*$"))}function gr(t){var n=null;if(void 0===lr[t]&&e&&e.exports&&pr(t))try{n=or._abbr,r(35358)("./"+t),fr(n)}catch(e){lr[t]=null}return lr[t]}function fr(e,t){var r;return e&&((r=u(t)?Er(e):mr(e,t))?or=r:"undefined"!=typeof console&&console.warn&&console.warn("Locale "+e+" not found. Did you forget to load it?")),or._abbr}function mr(e,t){if(null!==t){var r,n=ar;if(t.abbr=e,null!=lr[e])A("defineLocaleOverride","use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info."),n=lr[e]._config;else if(null!=t.parentLocale)if(null!=lr[t.parentLocale])n=lr[t.parentLocale]._config;else{if(null==(r=gr(t.parentLocale)))return hr[t.parentLocale]||(hr[t.parentLocale]=[]),hr[t.parentLocale].push({name:e,config:t}),null;n=r._config}return lr[e]=new P(x(n,t)),hr[e]&&hr[e].forEach((function(e){mr(e.name,e.config)})),fr(e),lr[e]}return delete lr[e],null}function yr(e,t){if(null!=t){var r,n,s=ar;null!=lr[e]&&null!=lr[e].parentLocale?lr[e].set(x(lr[e]._config,t)):(null!=(n=gr(e))&&(s=n._config),t=x(s,t),null==n&&(t.abbr=e),(r=new P(t)).parentLocale=lr[e],lr[e]=r),fr(e)}else null!=lr[e]&&(null!=lr[e].parentLocale?(lr[e]=lr[e].parentLocale,e===fr()&&fr(e)):null!=lr[e]&&delete lr[e]);return lr[e]}function Er(e){var t;if(e&&e._locale&&e._locale._abbr&&(e=e._locale._abbr),!e)return or;if(!o(e)){if(t=gr(e))return t;e=[e]}return dr(e)}function wr(){return _(lr)}function Cr(e){var t,r=e._a;return r&&-2===y(e).overflow&&(t=r[Ue]<0||r[Ue]>11?Ue:r[Ve]<1||r[Ve]>nt(r[Fe],r[Ue])?Ve:r[Be]<0||r[Be]>24||24===r[Be]&&(0!==r[We]||0!==r[Ye]||0!==r[Ge])?Be:r[We]<0||r[We]>59?We:r[Ye]<0||r[Ye]>59?Ye:r[Ge]<0||r[Ge]>999?Ge:-1,y(e)._overflowDayOfYear&&(t<Fe||t>Ve)&&(t=Ve),y(e)._overflowWeeks&&-1===t&&(t=je),y(e)._overflowWeekday&&-1===t&&(t=ze),y(e).overflow=t),e}var vr=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,Rr=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d|))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,Sr=/Z|[+-]\d\d(?::?\d\d)?/,Tr=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,!1],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,!1],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,!1],["YYYYDDD",/\d{7}/],["YYYYMM",/\d{6}/,!1],["YYYY",/\d{4}/,!1]],Nr=[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]],Mr=/^\/?Date\((-?\d+)/i,_r=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/,br={UT:0,GMT:0,EDT:-240,EST:-300,CDT:-300,CST:-360,MDT:-360,MST:-420,PDT:-420,PST:-480};function Ar(e){var t,r,n,s,i,o,a=e._i,l=vr.exec(a)||Rr.exec(a),h=Tr.length,u=Nr.length;if(l){for(y(e).iso=!0,t=0,r=h;t<r;t++)if(Tr[t][1].exec(l[1])){s=Tr[t][0],n=!1!==Tr[t][2];break}if(null==s)return void(e._isValid=!1);if(l[3]){for(t=0,r=u;t<r;t++)if(Nr[t][1].exec(l[3])){i=(l[2]||" ")+Nr[t][0];break}if(null==i)return void(e._isValid=!1)}if(!n&&null!=i)return void(e._isValid=!1);if(l[4]){if(!Sr.exec(l[4]))return void(e._isValid=!1);o="Z"}e._f=s+(i||"")+(o||""),Br(e)}else e._isValid=!1}function Or(e,t,r,n,s,i){var o=[Ir(e),it.indexOf(t),parseInt(r,10),parseInt(n,10),parseInt(s,10)];return i&&o.push(parseInt(i,10)),o}function Ir(e){var t=parseInt(e,10);return t<=49?2e3+t:t<=999?1900+t:t}function xr(e){return e.replace(/\([^()]*\)|[\n\t]/g," ").replace(/(\s\s+)/g," ").replace(/^\s\s*/,"").replace(/\s\s*$/,"")}function Pr(e,t,r){return!e||Dt.indexOf(e)===new Date(t[0],t[1],t[2]).getDay()||(y(r).weekdayMismatch=!0,r._isValid=!1,!1)}function Lr(e,t,r){if(e)return br[e];if(t)return 0;var n=parseInt(r,10),s=n%100;return(n-s)/100*60+s}function Dr(e){var t,r=_r.exec(xr(e._i));if(r){if(t=Or(r[4],r[3],r[2],r[5],r[6],r[7]),!Pr(r[1],t,e))return;e._a=t,e._tzm=Lr(r[8],r[9],r[10]),e._d=Ct.apply(null,e._a),e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),y(e).rfc2822=!0}else e._isValid=!1}function kr(e){var t=Mr.exec(e._i);null===t?(Ar(e),!1===e._isValid&&(delete e._isValid,Dr(e),!1===e._isValid&&(delete e._isValid,e._strict?e._isValid=!1:s.createFromInputFallback(e)))):e._d=new Date(+t[1])}function Hr(e,t,r){return null!=e?e:null!=t?t:r}function Fr(e){var t=new Date(s.now());return e._useUTC?[t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate()]:[t.getFullYear(),t.getMonth(),t.getDate()]}function Ur(e){var t,r,n,s,i,o=[];if(!e._d){for(n=Fr(e),e._w&&null==e._a[Ve]&&null==e._a[Ue]&&Vr(e),null!=e._dayOfYear&&(i=Hr(e._a[Fe],n[Fe]),(e._dayOfYear>$e(i)||0===e._dayOfYear)&&(y(e)._overflowDayOfYear=!0),r=Ct(i,0,e._dayOfYear),e._a[Ue]=r.getUTCMonth(),e._a[Ve]=r.getUTCDate()),t=0;t<3&&null==e._a[t];++t)e._a[t]=o[t]=n[t];for(;t<7;t++)e._a[t]=o[t]=null==e._a[t]?2===t?1:0:e._a[t];24===e._a[Be]&&0===e._a[We]&&0===e._a[Ye]&&0===e._a[Ge]&&(e._nextDay=!0,e._a[Be]=0),e._d=(e._useUTC?Ct:wt).apply(null,o),s=e._useUTC?e._d.getUTCDay():e._d.getDay(),null!=e._tzm&&e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),e._nextDay&&(e._a[Be]=24),e._w&&void 0!==e._w.d&&e._w.d!==s&&(y(e).weekdayMismatch=!0)}}function Vr(e){var t,r,n,s,i,o,a,l,h;null!=(t=e._w).GG||null!=t.W||null!=t.E?(i=1,o=4,r=Hr(t.GG,e._a[Fe],St(Xr(),1,4).year),n=Hr(t.W,1),((s=Hr(t.E,1))<1||s>7)&&(l=!0)):(i=e._locale._week.dow,o=e._locale._week.doy,h=St(Xr(),i,o),r=Hr(t.gg,e._a[Fe],h.year),n=Hr(t.w,h.week),null!=t.d?((s=t.d)<0||s>6)&&(l=!0):null!=t.e?(s=t.e+i,(t.e<0||t.e>6)&&(l=!0)):s=i),n<1||n>Tt(r,i,o)?y(e)._overflowWeeks=!0:null!=l?y(e)._overflowWeekday=!0:(a=Rt(r,n,s,i,o),e._a[Fe]=a.year,e._dayOfYear=a.dayOfYear)}function Br(e){if(e._f!==s.ISO_8601)if(e._f!==s.RFC_2822){e._a=[],y(e).empty=!0;var t,r,n,i,o,a,l,h=""+e._i,u=h.length,c=0;for(l=(n=j(e._f,e._locale).match(H)||[]).length,t=0;t<l;t++)i=n[t],(r=(h.match(be(i,e))||[])[0])&&((o=h.substr(0,h.indexOf(r))).length>0&&y(e).unusedInput.push(o),h=h.slice(h.indexOf(r)+r.length),c+=r.length),V[i]?(r?y(e).empty=!1:y(e).unusedTokens.push(i),ke(i,r,e)):e._strict&&!r&&y(e).unusedTokens.push(i);y(e).charsLeftOver=u-c,h.length>0&&y(e).unusedInput.push(h),e._a[Be]<=12&&!0===y(e).bigHour&&e._a[Be]>0&&(y(e).bigHour=void 0),y(e).parsedDateParts=e._a.slice(0),y(e).meridiem=e._meridiem,e._a[Be]=Wr(e._locale,e._a[Be],e._meridiem),null!==(a=y(e).era)&&(e._a[Fe]=e._locale.erasConvertYear(a,e._a[Fe])),Ur(e),Cr(e)}else Dr(e);else Ar(e)}function Wr(e,t,r){var n;return null==r?t:null!=e.meridiemHour?e.meridiemHour(t,r):null!=e.isPM?((n=e.isPM(r))&&t<12&&(t+=12),n||12!==t||(t=0),t):t}function Yr(e){var t,r,n,s,i,o,a=!1,l=e._f.length;if(0===l)return y(e).invalidFormat=!0,void(e._d=new Date(NaN));for(s=0;s<l;s++)i=0,o=!1,t=R({},e),null!=e._useUTC&&(t._useUTC=e._useUTC),t._f=e._f[s],Br(t),E(t)&&(o=!0),i+=y(t).charsLeftOver,i+=10*y(t).unusedTokens.length,y(t).score=i,a?i<n&&(n=i,r=t):(null==n||i<n||o)&&(n=i,r=t,o&&(a=!0));g(e,r||t)}function Gr(e){if(!e._d){var t=se(e._i),r=void 0===t.day?t.date:t.day;e._a=p([t.year,t.month,r,t.hour,t.minute,t.second,t.millisecond],(function(e){return e&&parseInt(e,10)})),Ur(e)}}function jr(e){var t=new S(Cr(zr(e)));return t._nextDay&&(t.add(1,"d"),t._nextDay=void 0),t}function zr(e){var t=e._i,r=e._f;return e._locale=e._locale||Er(e._l),null===t||void 0===r&&""===t?w({nullInput:!0}):("string"==typeof t&&(e._i=t=e._locale.preparse(t)),T(t)?new S(Cr(t)):(d(t)?e._d=t:o(r)?Yr(e):r?Br(e):$r(e),E(e)||(e._d=null),e))}function $r(e){var t=e._i;u(t)?e._d=new Date(s.now()):d(t)?e._d=new Date(t.valueOf()):"string"==typeof t?kr(e):o(t)?(e._a=p(t.slice(0),(function(e){return parseInt(e,10)})),Ur(e)):a(t)?Gr(e):c(t)?e._d=new Date(t):s.createFromInputFallback(e)}function Kr(e,t,r,n,s){var i={};return!0!==t&&!1!==t||(n=t,t=void 0),!0!==r&&!1!==r||(n=r,r=void 0),(a(e)&&h(e)||o(e)&&0===e.length)&&(e=void 0),i._isAMomentObject=!0,i._useUTC=i._isUTC=s,i._l=r,i._i=e,i._f=t,i._strict=n,jr(i)}function Xr(e,t,r,n){return Kr(e,t,r,n,!1)}s.createFromInputFallback=M("value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",(function(e){e._d=new Date(e._i+(e._useUTC?" UTC":""))})),s.ISO_8601=function(){},s.RFC_2822=function(){};var qr=M("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",(function(){var e=Xr.apply(null,arguments);return this.isValid()&&e.isValid()?e<this?this:e:w()})),Qr=M("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",(function(){var e=Xr.apply(null,arguments);return this.isValid()&&e.isValid()?e>this?this:e:w()}));function Zr(e,t){var r,n;if(1===t.length&&o(t[0])&&(t=t[0]),!t.length)return Xr();for(r=t[0],n=1;n<t.length;++n)t[n].isValid()&&!t[n][e](r)||(r=t[n]);return r}function Jr(){return Zr("isBefore",[].slice.call(arguments,0))}function en(){return Zr("isAfter",[].slice.call(arguments,0))}var tn=function(){return Date.now?Date.now():+new Date},rn=["year","quarter","month","week","day","hour","minute","second","millisecond"];function nn(e){var t,r,n=!1,s=rn.length;for(t in e)if(l(e,t)&&(-1===Ke.call(rn,t)||null!=e[t]&&isNaN(e[t])))return!1;for(r=0;r<s;++r)if(e[rn[r]]){if(n)return!1;parseFloat(e[rn[r]])!==xe(e[rn[r]])&&(n=!0)}return!0}function sn(){return this._isValid}function on(){return An(NaN)}function an(e){var t=se(e),r=t.year||0,n=t.quarter||0,s=t.month||0,i=t.week||t.isoWeek||0,o=t.day||0,a=t.hour||0,l=t.minute||0,h=t.second||0,u=t.millisecond||0;this._isValid=nn(t),this._milliseconds=+u+1e3*h+6e4*l+1e3*a*60*60,this._days=+o+7*i,this._months=+s+3*n+12*r,this._data={},this._locale=Er(),this._bubble()}function ln(e){return e instanceof an}function hn(e){return e<0?-1*Math.round(-1*e):Math.round(e)}function un(e,t,r){var n,s=Math.min(e.length,t.length),i=Math.abs(e.length-t.length),o=0;for(n=0;n<s;n++)(r&&e[n]!==t[n]||!r&&xe(e[n])!==xe(t[n]))&&o++;return o+i}function cn(e,t){B(e,0,0,(function(){var e=this.utcOffset(),r="+";return e<0&&(e=-e,r="-"),r+k(~~(e/60),2)+t+k(~~e%60,2)}))}cn("Z",":"),cn("ZZ",""),_e("Z",Re),_e("ZZ",Re),Le(["Z","ZZ"],(function(e,t,r){r._useUTC=!0,r._tzm=pn(Re,e)}));var dn=/([\+\-]|\d\d)/gi;function pn(e,t){var r,n,s=(t||"").match(e);return null===s?null:0===(n=60*(r=((s[s.length-1]||[])+"").match(dn)||["-",0,0])[1]+xe(r[2]))?0:"+"===r[0]?n:-n}function gn(e,t){var r,n;return t._isUTC?(r=t.clone(),n=(T(e)||d(e)?e.valueOf():Xr(e).valueOf())-r.valueOf(),r._d.setTime(r._d.valueOf()+n),s.updateOffset(r,!1),r):Xr(e).local()}function fn(e){return-Math.round(e._d.getTimezoneOffset())}function mn(e,t,r){var n,i=this._offset||0;if(!this.isValid())return null!=e?this:NaN;if(null!=e){if("string"==typeof e){if(null===(e=pn(Re,e)))return this}else Math.abs(e)<16&&!r&&(e*=60);return!this._isUTC&&t&&(n=fn(this)),this._offset=e,this._isUTC=!0,null!=n&&this.add(n,"m"),i!==e&&(!t||this._changeInProgress?Ln(this,An(e-i,"m"),1,!1):this._changeInProgress||(this._changeInProgress=!0,s.updateOffset(this,!0),this._changeInProgress=null)),this}return this._isUTC?i:fn(this)}function yn(e,t){return null!=e?("string"!=typeof e&&(e=-e),this.utcOffset(e,t),this):-this.utcOffset()}function En(e){return this.utcOffset(0,e)}function wn(e){return this._isUTC&&(this.utcOffset(0,e),this._isUTC=!1,e&&this.subtract(fn(this),"m")),this}function Cn(){if(null!=this._tzm)this.utcOffset(this._tzm,!1,!0);else if("string"==typeof this._i){var e=pn(ve,this._i);null!=e?this.utcOffset(e):this.utcOffset(0,!0)}return this}function vn(e){return!!this.isValid()&&(e=e?Xr(e).utcOffset():0,(this.utcOffset()-e)%60==0)}function Rn(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()}function Sn(){if(!u(this._isDSTShifted))return this._isDSTShifted;var e,t={};return R(t,this),(t=zr(t))._a?(e=t._isUTC?f(t._a):Xr(t._a),this._isDSTShifted=this.isValid()&&un(t._a,e.toArray())>0):this._isDSTShifted=!1,this._isDSTShifted}function Tn(){return!!this.isValid()&&!this._isUTC}function Nn(){return!!this.isValid()&&this._isUTC}function Mn(){return!!this.isValid()&&this._isUTC&&0===this._offset}s.updateOffset=function(){};var _n=/^(-|\+)?(?:(\d*)[. ])?(\d+):(\d+)(?::(\d+)(\.\d*)?)?$/,bn=/^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;function An(e,t){var r,n,s,i=e,o=null;return ln(e)?i={ms:e._milliseconds,d:e._days,M:e._months}:c(e)||!isNaN(+e)?(i={},t?i[t]=+e:i.milliseconds=+e):(o=_n.exec(e))?(r="-"===o[1]?-1:1,i={y:0,d:xe(o[Ve])*r,h:xe(o[Be])*r,m:xe(o[We])*r,s:xe(o[Ye])*r,ms:xe(hn(1e3*o[Ge]))*r}):(o=bn.exec(e))?(r="-"===o[1]?-1:1,i={y:On(o[2],r),M:On(o[3],r),w:On(o[4],r),d:On(o[5],r),h:On(o[6],r),m:On(o[7],r),s:On(o[8],r)}):null==i?i={}:"object"==typeof i&&("from"in i||"to"in i)&&(s=xn(Xr(i.from),Xr(i.to)),(i={}).ms=s.milliseconds,i.M=s.months),n=new an(i),ln(e)&&l(e,"_locale")&&(n._locale=e._locale),ln(e)&&l(e,"_isValid")&&(n._isValid=e._isValid),n}function On(e,t){var r=e&&parseFloat(e.replace(",","."));return(isNaN(r)?0:r)*t}function In(e,t){var r={};return r.months=t.month()-e.month()+12*(t.year()-e.year()),e.clone().add(r.months,"M").isAfter(t)&&--r.months,r.milliseconds=+t-+e.clone().add(r.months,"M"),r}function xn(e,t){var r;return e.isValid()&&t.isValid()?(t=gn(t,e),e.isBefore(t)?r=In(e,t):((r=In(t,e)).milliseconds=-r.milliseconds,r.months=-r.months),r):{milliseconds:0,months:0}}function Pn(e,t){return function(r,n){var s;return null===n||isNaN(+n)||(A(t,"moment()."+t+"(period, number) is deprecated. Please use moment()."+t+"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info."),s=r,r=n,n=s),Ln(this,An(r,n),e),this}}function Ln(e,t,r,n){var i=t._milliseconds,o=hn(t._days),a=hn(t._months);e.isValid()&&(n=null==n||n,a&&pt(e,Ze(e,"Month")+a*r),o&&Je(e,"Date",Ze(e,"Date")+o*r),i&&e._d.setTime(e._d.valueOf()+i*r),n&&s.updateOffset(e,o||a))}An.fn=an.prototype,An.invalid=on;var Dn=Pn(1,"add"),kn=Pn(-1,"subtract");function Hn(e){return"string"==typeof e||e instanceof String}function Fn(e){return T(e)||d(e)||Hn(e)||c(e)||Vn(e)||Un(e)||null==e}function Un(e){var t,r,n=a(e)&&!h(e),s=!1,i=["years","year","y","months","month","M","days","day","d","dates","date","D","hours","hour","h","minutes","minute","m","seconds","second","s","milliseconds","millisecond","ms"],o=i.length;for(t=0;t<o;t+=1)r=i[t],s=s||l(e,r);return n&&s}function Vn(e){var t=o(e),r=!1;return t&&(r=0===e.filter((function(t){return!c(t)&&Hn(e)})).length),t&&r}function Bn(e){var t,r,n=a(e)&&!h(e),s=!1,i=["sameDay","nextDay","lastDay","nextWeek","lastWeek","sameElse"];for(t=0;t<i.length;t+=1)r=i[t],s=s||l(e,r);return n&&s}function Wn(e,t){var r=e.diff(t,"days",!0);return r<-6?"sameElse":r<-1?"lastWeek":r<0?"lastDay":r<1?"sameDay":r<2?"nextDay":r<7?"nextWeek":"sameElse"}function Yn(e,t){1===arguments.length&&(arguments[0]?Fn(arguments[0])?(e=arguments[0],t=void 0):Bn(arguments[0])&&(t=arguments[0],e=void 0):(e=void 0,t=void 0));var r=e||Xr(),n=gn(r,this).startOf("day"),i=s.calendarFormat(this,n)||"sameElse",o=t&&(O(t[i])?t[i].call(this,r):t[i]);return this.format(o||this.localeData().calendar(i,this,Xr(r)))}function Gn(){return new S(this)}function jn(e,t){var r=T(e)?e:Xr(e);return!(!this.isValid()||!r.isValid())&&("millisecond"===(t=ne(t)||"millisecond")?this.valueOf()>r.valueOf():r.valueOf()<this.clone().startOf(t).valueOf())}function zn(e,t){var r=T(e)?e:Xr(e);return!(!this.isValid()||!r.isValid())&&("millisecond"===(t=ne(t)||"millisecond")?this.valueOf()<r.valueOf():this.clone().endOf(t).valueOf()<r.valueOf())}function $n(e,t,r,n){var s=T(e)?e:Xr(e),i=T(t)?t:Xr(t);return!!(this.isValid()&&s.isValid()&&i.isValid())&&("("===(n=n||"()")[0]?this.isAfter(s,r):!this.isBefore(s,r))&&(")"===n[1]?this.isBefore(i,r):!this.isAfter(i,r))}function Kn(e,t){var r,n=T(e)?e:Xr(e);return!(!this.isValid()||!n.isValid())&&("millisecond"===(t=ne(t)||"millisecond")?this.valueOf()===n.valueOf():(r=n.valueOf(),this.clone().startOf(t).valueOf()<=r&&r<=this.clone().endOf(t).valueOf()))}function Xn(e,t){return this.isSame(e,t)||this.isAfter(e,t)}function qn(e,t){return this.isSame(e,t)||this.isBefore(e,t)}function Qn(e,t,r){var n,s,i;if(!this.isValid())return NaN;if(!(n=gn(e,this)).isValid())return NaN;switch(s=6e4*(n.utcOffset()-this.utcOffset()),t=ne(t)){case"year":i=Zn(this,n)/12;break;case"month":i=Zn(this,n);break;case"quarter":i=Zn(this,n)/3;break;case"second":i=(this-n)/1e3;break;case"minute":i=(this-n)/6e4;break;case"hour":i=(this-n)/36e5;break;case"day":i=(this-n-s)/864e5;break;case"week":i=(this-n-s)/6048e5;break;default:i=this-n}return r?i:Ie(i)}function Zn(e,t){if(e.date()<t.date())return-Zn(t,e);var r=12*(t.year()-e.year())+(t.month()-e.month()),n=e.clone().add(r,"months");return-(r+(t-n<0?(t-n)/(n-e.clone().add(r-1,"months")):(t-n)/(e.clone().add(r+1,"months")-n)))||0}function Jn(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")}function es(e){if(!this.isValid())return null;var t=!0!==e,r=t?this.clone().utc():this;return r.year()<0||r.year()>9999?G(r,t?"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYYYY-MM-DD[T]HH:mm:ss.SSSZ"):O(Date.prototype.toISOString)?t?this.toDate().toISOString():new Date(this.valueOf()+60*this.utcOffset()*1e3).toISOString().replace("Z",G(r,"Z")):G(r,t?"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYY-MM-DD[T]HH:mm:ss.SSSZ")}function ts(){if(!this.isValid())return"moment.invalid(/* "+this._i+" */)";var e,t,r,n,s="moment",i="";return this.isLocal()||(s=0===this.utcOffset()?"moment.utc":"moment.parseZone",i="Z"),e="["+s+'("]',t=0<=this.year()&&this.year()<=9999?"YYYY":"YYYYYY",r="-MM-DD[T]HH:mm:ss.SSS",n=i+'[")]',this.format(e+t+r+n)}function rs(e){e||(e=this.isUtc()?s.defaultFormatUtc:s.defaultFormat);var t=G(this,e);return this.localeData().postformat(t)}function ns(e,t){return this.isValid()&&(T(e)&&e.isValid()||Xr(e).isValid())?An({to:this,from:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()}function ss(e){return this.from(Xr(),e)}function is(e,t){return this.isValid()&&(T(e)&&e.isValid()||Xr(e).isValid())?An({from:this,to:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()}function os(e){return this.to(Xr(),e)}function as(e){var t;return void 0===e?this._locale._abbr:(null!=(t=Er(e))&&(this._locale=t),this)}s.defaultFormat="YYYY-MM-DDTHH:mm:ssZ",s.defaultFormatUtc="YYYY-MM-DDTHH:mm:ss[Z]";var ls=M("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",(function(e){return void 0===e?this.localeData():this.locale(e)}));function hs(){return this._locale}var us=1e3,cs=60*us,ds=60*cs,ps=3506328*ds;function gs(e,t){return(e%t+t)%t}function fs(e,t,r){return e<100&&e>=0?new Date(e+400,t,r)-ps:new Date(e,t,r).valueOf()}function ms(e,t,r){return e<100&&e>=0?Date.UTC(e+400,t,r)-ps:Date.UTC(e,t,r)}function ys(e){var t,r;if(void 0===(e=ne(e))||"millisecond"===e||!this.isValid())return this;switch(r=this._isUTC?ms:fs,e){case"year":t=r(this.year(),0,1);break;case"quarter":t=r(this.year(),this.month()-this.month()%3,1);break;case"month":t=r(this.year(),this.month(),1);break;case"week":t=r(this.year(),this.month(),this.date()-this.weekday());break;case"isoWeek":t=r(this.year(),this.month(),this.date()-(this.isoWeekday()-1));break;case"day":case"date":t=r(this.year(),this.month(),this.date());break;case"hour":t=this._d.valueOf(),t-=gs(t+(this._isUTC?0:this.utcOffset()*cs),ds);break;case"minute":t=this._d.valueOf(),t-=gs(t,cs);break;case"second":t=this._d.valueOf(),t-=gs(t,us)}return this._d.setTime(t),s.updateOffset(this,!0),this}function Es(e){var t,r;if(void 0===(e=ne(e))||"millisecond"===e||!this.isValid())return this;switch(r=this._isUTC?ms:fs,e){case"year":t=r(this.year()+1,0,1)-1;break;case"quarter":t=r(this.year(),this.month()-this.month()%3+3,1)-1;break;case"month":t=r(this.year(),this.month()+1,1)-1;break;case"week":t=r(this.year(),this.month(),this.date()-this.weekday()+7)-1;break;case"isoWeek":t=r(this.year(),this.month(),this.date()-(this.isoWeekday()-1)+7)-1;break;case"day":case"date":t=r(this.year(),this.month(),this.date()+1)-1;break;case"hour":t=this._d.valueOf(),t+=ds-gs(t+(this._isUTC?0:this.utcOffset()*cs),ds)-1;break;case"minute":t=this._d.valueOf(),t+=cs-gs(t,cs)-1;break;case"second":t=this._d.valueOf(),t+=us-gs(t,us)-1}return this._d.setTime(t),s.updateOffset(this,!0),this}function ws(){return this._d.valueOf()-6e4*(this._offset||0)}function Cs(){return Math.floor(this.valueOf()/1e3)}function vs(){return new Date(this.valueOf())}function Rs(){var e=this;return[e.year(),e.month(),e.date(),e.hour(),e.minute(),e.second(),e.millisecond()]}function Ss(){var e=this;return{years:e.year(),months:e.month(),date:e.date(),hours:e.hours(),minutes:e.minutes(),seconds:e.seconds(),milliseconds:e.milliseconds()}}function Ts(){return this.isValid()?this.toISOString():null}function Ns(){return E(this)}function Ms(){return g({},y(this))}function _s(){return y(this).overflow}function bs(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}}function As(e,t){var r,n,i,o=this._eras||Er("en")._eras;for(r=0,n=o.length;r<n;++r)switch("string"==typeof o[r].since&&(i=s(o[r].since).startOf("day"),o[r].since=i.valueOf()),typeof o[r].until){case"undefined":o[r].until=1/0;break;case"string":i=s(o[r].until).startOf("day").valueOf(),o[r].until=i.valueOf()}return o}function Os(e,t,r){var n,s,i,o,a,l=this.eras();for(e=e.toUpperCase(),n=0,s=l.length;n<s;++n)if(i=l[n].name.toUpperCase(),o=l[n].abbr.toUpperCase(),a=l[n].narrow.toUpperCase(),r)switch(t){case"N":case"NN":case"NNN":if(o===e)return l[n];break;case"NNNN":if(i===e)return l[n];break;case"NNNNN":if(a===e)return l[n]}else if([i,o,a].indexOf(e)>=0)return l[n]}function Is(e,t){var r=e.since<=e.until?1:-1;return void 0===t?s(e.since).year():s(e.since).year()+(t-e.offset)*r}function xs(){var e,t,r,n=this.localeData().eras();for(e=0,t=n.length;e<t;++e){if(r=this.clone().startOf("day").valueOf(),n[e].since<=r&&r<=n[e].until)return n[e].name;if(n[e].until<=r&&r<=n[e].since)return n[e].name}return""}function Ps(){var e,t,r,n=this.localeData().eras();for(e=0,t=n.length;e<t;++e){if(r=this.clone().startOf("day").valueOf(),n[e].since<=r&&r<=n[e].until)return n[e].narrow;if(n[e].until<=r&&r<=n[e].since)return n[e].narrow}return""}function Ls(){var e,t,r,n=this.localeData().eras();for(e=0,t=n.length;e<t;++e){if(r=this.clone().startOf("day").valueOf(),n[e].since<=r&&r<=n[e].until)return n[e].abbr;if(n[e].until<=r&&r<=n[e].since)return n[e].abbr}return""}function Ds(){var e,t,r,n,i=this.localeData().eras();for(e=0,t=i.length;e<t;++e)if(r=i[e].since<=i[e].until?1:-1,n=this.clone().startOf("day").valueOf(),i[e].since<=n&&n<=i[e].until||i[e].until<=n&&n<=i[e].since)return(this.year()-s(i[e].since).year())*r+i[e].offset;return this.year()}function ks(e){return l(this,"_erasNameRegex")||Ys.call(this),e?this._erasNameRegex:this._erasRegex}function Hs(e){return l(this,"_erasAbbrRegex")||Ys.call(this),e?this._erasAbbrRegex:this._erasRegex}function Fs(e){return l(this,"_erasNarrowRegex")||Ys.call(this),e?this._erasNarrowRegex:this._erasRegex}function Us(e,t){return t.erasAbbrRegex(e)}function Vs(e,t){return t.erasNameRegex(e)}function Bs(e,t){return t.erasNarrowRegex(e)}function Ws(e,t){return t._eraYearOrdinalRegex||we}function Ys(){var e,t,r,n,s,i=[],o=[],a=[],l=[],h=this.eras();for(e=0,t=h.length;e<t;++e)r=Oe(h[e].name),n=Oe(h[e].abbr),s=Oe(h[e].narrow),o.push(r),i.push(n),a.push(s),l.push(r),l.push(n),l.push(s);this._erasRegex=new RegExp("^("+l.join("|")+")","i"),this._erasNameRegex=new RegExp("^("+o.join("|")+")","i"),this._erasAbbrRegex=new RegExp("^("+i.join("|")+")","i"),this._erasNarrowRegex=new RegExp("^("+a.join("|")+")","i")}function Gs(e,t){B(0,[e,e.length],0,t)}function js(e){return Qs.call(this,e,this.week(),this.weekday()+this.localeData()._week.dow,this.localeData()._week.dow,this.localeData()._week.doy)}function zs(e){return Qs.call(this,e,this.isoWeek(),this.isoWeekday(),1,4)}function $s(){return Tt(this.year(),1,4)}function Ks(){return Tt(this.isoWeekYear(),1,4)}function Xs(){var e=this.localeData()._week;return Tt(this.year(),e.dow,e.doy)}function qs(){var e=this.localeData()._week;return Tt(this.weekYear(),e.dow,e.doy)}function Qs(e,t,r,n,s){var i;return null==e?St(this,n,s).year:(t>(i=Tt(e,n,s))&&(t=i),Zs.call(this,e,t,r,n,s))}function Zs(e,t,r,n,s){var i=Rt(e,t,r,n,s),o=Ct(i.year,0,i.dayOfYear);return this.year(o.getUTCFullYear()),this.month(o.getUTCMonth()),this.date(o.getUTCDate()),this}function Js(e){return null==e?Math.ceil((this.month()+1)/3):this.month(3*(e-1)+this.month()%3)}B("N",0,0,"eraAbbr"),B("NN",0,0,"eraAbbr"),B("NNN",0,0,"eraAbbr"),B("NNNN",0,0,"eraName"),B("NNNNN",0,0,"eraNarrow"),B("y",["y",1],"yo","eraYear"),B("y",["yy",2],0,"eraYear"),B("y",["yyy",3],0,"eraYear"),B("y",["yyyy",4],0,"eraYear"),_e("N",Us),_e("NN",Us),_e("NNN",Us),_e("NNNN",Vs),_e("NNNNN",Bs),Le(["N","NN","NNN","NNNN","NNNNN"],(function(e,t,r,n){var s=r._locale.erasParse(e,n,r._strict);s?y(r).era=s:y(r).invalidEra=e})),_e("y",we),_e("yy",we),_e("yyy",we),_e("yyyy",we),_e("yo",Ws),Le(["y","yy","yyy","yyyy"],Fe),Le(["yo"],(function(e,t,r,n){var s;r._locale._eraYearOrdinalRegex&&(s=e.match(r._locale._eraYearOrdinalRegex)),r._locale.eraYearOrdinalParse?t[Fe]=r._locale.eraYearOrdinalParse(e,s):t[Fe]=parseInt(e,10)})),B(0,["gg",2],0,(function(){return this.weekYear()%100})),B(0,["GG",2],0,(function(){return this.isoWeekYear()%100})),Gs("gggg","weekYear"),Gs("ggggg","weekYear"),Gs("GGGG","isoWeekYear"),Gs("GGGGG","isoWeekYear"),_e("G",Ce),_e("g",Ce),_e("GG",pe,he),_e("gg",pe,he),_e("GGGG",ye,ce),_e("gggg",ye,ce),_e("GGGGG",Ee,de),_e("ggggg",Ee,de),De(["gggg","ggggg","GGGG","GGGGG"],(function(e,t,r,n){t[n.substr(0,2)]=xe(e)})),De(["gg","GG"],(function(e,t,r,n){t[n]=s.parseTwoDigitYear(e)})),B("Q",0,"Qo","quarter"),_e("Q",le),Le("Q",(function(e,t){t[Ue]=3*(xe(e)-1)})),B("D",["DD",2],"Do","date"),_e("D",pe,Ne),_e("DD",pe,he),_e("Do",(function(e,t){return e?t._dayOfMonthOrdinalParse||t._ordinalParse:t._dayOfMonthOrdinalParseLenient})),Le(["D","DD"],Ve),Le("Do",(function(e,t){t[Ve]=xe(e.match(pe)[0])}));var ei=Qe("Date",!0);function ti(e){var t=Math.round((this.clone().startOf("day")-this.clone().startOf("year"))/864e5)+1;return null==e?t:this.add(e-t,"d")}B("DDD",["DDDD",3],"DDDo","dayOfYear"),_e("DDD",me),_e("DDDD",ue),Le(["DDD","DDDD"],(function(e,t,r){r._dayOfYear=xe(e)})),B("m",["mm",2],0,"minute"),_e("m",pe,Me),_e("mm",pe,he),Le(["m","mm"],We);var ri=Qe("Minutes",!1);B("s",["ss",2],0,"second"),_e("s",pe,Me),_e("ss",pe,he),Le(["s","ss"],Ye);var ni,si,ii=Qe("Seconds",!1);for(B("S",0,0,(function(){return~~(this.millisecond()/100)})),B(0,["SS",2],0,(function(){return~~(this.millisecond()/10)})),B(0,["SSS",3],0,"millisecond"),B(0,["SSSS",4],0,(function(){return 10*this.millisecond()})),B(0,["SSSSS",5],0,(function(){return 100*this.millisecond()})),B(0,["SSSSSS",6],0,(function(){return 1e3*this.millisecond()})),B(0,["SSSSSSS",7],0,(function(){return 1e4*this.millisecond()})),B(0,["SSSSSSSS",8],0,(function(){return 1e5*this.millisecond()})),B(0,["SSSSSSSSS",9],0,(function(){return 1e6*this.millisecond()})),_e("S",me,le),_e("SS",me,he),_e("SSS",me,ue),ni="SSSS";ni.length<=9;ni+="S")_e(ni,we);function oi(e,t){t[Ge]=xe(1e3*("0."+e))}for(ni="S";ni.length<=9;ni+="S")Le(ni,oi);function ai(){return this._isUTC?"UTC":""}function li(){return this._isUTC?"Coordinated Universal Time":""}si=Qe("Milliseconds",!1),B("z",0,0,"zoneAbbr"),B("zz",0,0,"zoneName");var hi=S.prototype;function ui(e){return Xr(1e3*e)}function ci(){return Xr.apply(null,arguments).parseZone()}function di(e){return e}hi.add=Dn,hi.calendar=Yn,hi.clone=Gn,hi.diff=Qn,hi.endOf=Es,hi.format=rs,hi.from=ns,hi.fromNow=ss,hi.to=is,hi.toNow=os,hi.get=et,hi.invalidAt=_s,hi.isAfter=jn,hi.isBefore=zn,hi.isBetween=$n,hi.isSame=Kn,hi.isSameOrAfter=Xn,hi.isSameOrBefore=qn,hi.isValid=Ns,hi.lang=ls,hi.locale=as,hi.localeData=hs,hi.max=Qr,hi.min=qr,hi.parsingFlags=Ms,hi.set=tt,hi.startOf=ys,hi.subtract=kn,hi.toArray=Rs,hi.toObject=Ss,hi.toDate=vs,hi.toISOString=es,hi.inspect=ts,"undefined"!=typeof Symbol&&null!=Symbol.for&&(hi[Symbol.for("nodejs.util.inspect.custom")]=function(){return"Moment<"+this.format()+">"}),hi.toJSON=Ts,hi.toString=Jn,hi.unix=Cs,hi.valueOf=ws,hi.creationData=bs,hi.eraName=xs,hi.eraNarrow=Ps,hi.eraAbbr=Ls,hi.eraYear=Ds,hi.year=Xe,hi.isLeapYear=qe,hi.weekYear=js,hi.isoWeekYear=zs,hi.quarter=hi.quarters=Js,hi.month=gt,hi.daysInMonth=ft,hi.week=hi.weeks=At,hi.isoWeek=hi.isoWeeks=Ot,hi.weeksInYear=Xs,hi.weeksInWeekYear=qs,hi.isoWeeksInYear=$s,hi.isoWeeksInISOWeekYear=Ks,hi.date=ei,hi.day=hi.days=jt,hi.weekday=zt,hi.isoWeekday=$t,hi.dayOfYear=ti,hi.hour=hi.hours=sr,hi.minute=hi.minutes=ri,hi.second=hi.seconds=ii,hi.millisecond=hi.milliseconds=si,hi.utcOffset=mn,hi.utc=En,hi.local=wn,hi.parseZone=Cn,hi.hasAlignedHourOffset=vn,hi.isDST=Rn,hi.isLocal=Tn,hi.isUtcOffset=Nn,hi.isUtc=Mn,hi.isUTC=Mn,hi.zoneAbbr=ai,hi.zoneName=li,hi.dates=M("dates accessor is deprecated. Use date instead.",ei),hi.months=M("months accessor is deprecated. Use month instead",gt),hi.years=M("years accessor is deprecated. Use year instead",Xe),hi.zone=M("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",yn),hi.isDSTShifted=M("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",Sn);var pi=P.prototype;function gi(e,t,r,n){var s=Er(),i=f().set(n,t);return s[r](i,e)}function fi(e,t,r){if(c(e)&&(t=e,e=void 0),e=e||"",null!=t)return gi(e,t,r,"month");var n,s=[];for(n=0;n<12;n++)s[n]=gi(e,n,r,"month");return s}function mi(e,t,r,n){"boolean"==typeof e?(c(t)&&(r=t,t=void 0),t=t||""):(r=t=e,e=!1,c(t)&&(r=t,t=void 0),t=t||"");var s,i=Er(),o=e?i._week.dow:0,a=[];if(null!=r)return gi(t,(r+o)%7,n,"day");for(s=0;s<7;s++)a[s]=gi(t,(s+o)%7,n,"day");return a}function yi(e,t){return fi(e,t,"months")}function Ei(e,t){return fi(e,t,"monthsShort")}function wi(e,t,r){return mi(e,t,r,"weekdays")}function Ci(e,t,r){return mi(e,t,r,"weekdaysShort")}function vi(e,t,r){return mi(e,t,r,"weekdaysMin")}pi.calendar=D,pi.longDateFormat=$,pi.invalidDate=X,pi.ordinal=Z,pi.preparse=di,pi.postformat=di,pi.relativeTime=ee,pi.pastFuture=te,pi.set=I,pi.eras=As,pi.erasParse=Os,pi.erasConvertYear=Is,pi.erasAbbrRegex=Hs,pi.erasNameRegex=ks,pi.erasNarrowRegex=Fs,pi.months=ht,pi.monthsShort=ut,pi.monthsParse=dt,pi.monthsRegex=yt,pi.monthsShortRegex=mt,pi.week=Nt,pi.firstDayOfYear=bt,pi.firstDayOfWeek=_t,pi.weekdays=Vt,pi.weekdaysMin=Wt,pi.weekdaysShort=Bt,pi.weekdaysParse=Gt,pi.weekdaysRegex=Kt,pi.weekdaysShortRegex=Xt,pi.weekdaysMinRegex=qt,pi.isPM=rr,pi.meridiem=ir,fr("en",{eras:[{since:"0001-01-01",until:1/0,offset:1,name:"Anno Domini",narrow:"AD",abbr:"AD"},{since:"0000-12-31",until:-1/0,offset:1,name:"Before Christ",narrow:"BC",abbr:"BC"}],dayOfMonthOrdinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(e){var t=e%10;return e+(1===xe(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th")}}),s.lang=M("moment.lang is deprecated. Use moment.locale instead.",fr),s.langData=M("moment.langData is deprecated. Use moment.localeData instead.",Er);var Ri=Math.abs;function Si(){var e=this._data;return this._milliseconds=Ri(this._milliseconds),this._days=Ri(this._days),this._months=Ri(this._months),e.milliseconds=Ri(e.milliseconds),e.seconds=Ri(e.seconds),e.minutes=Ri(e.minutes),e.hours=Ri(e.hours),e.months=Ri(e.months),e.years=Ri(e.years),this}function Ti(e,t,r,n){var s=An(t,r);return e._milliseconds+=n*s._milliseconds,e._days+=n*s._days,e._months+=n*s._months,e._bubble()}function Ni(e,t){return Ti(this,e,t,1)}function Mi(e,t){return Ti(this,e,t,-1)}function _i(e){return e<0?Math.floor(e):Math.ceil(e)}function bi(){var e,t,r,n,s,i=this._milliseconds,o=this._days,a=this._months,l=this._data;return i>=0&&o>=0&&a>=0||i<=0&&o<=0&&a<=0||(i+=864e5*_i(Oi(a)+o),o=0,a=0),l.milliseconds=i%1e3,e=Ie(i/1e3),l.seconds=e%60,t=Ie(e/60),l.minutes=t%60,r=Ie(t/60),l.hours=r%24,o+=Ie(r/24),a+=s=Ie(Ai(o)),o-=_i(Oi(s)),n=Ie(a/12),a%=12,l.days=o,l.months=a,l.years=n,this}function Ai(e){return 4800*e/146097}function Oi(e){return 146097*e/4800}function Ii(e){if(!this.isValid())return NaN;var t,r,n=this._milliseconds;if("month"===(e=ne(e))||"quarter"===e||"year"===e)switch(t=this._days+n/864e5,r=this._months+Ai(t),e){case"month":return r;case"quarter":return r/3;case"year":return r/12}else switch(t=this._days+Math.round(Oi(this._months)),e){case"week":return t/7+n/6048e5;case"day":return t+n/864e5;case"hour":return 24*t+n/36e5;case"minute":return 1440*t+n/6e4;case"second":return 86400*t+n/1e3;case"millisecond":return Math.floor(864e5*t)+n;default:throw new Error("Unknown unit "+e)}}function xi(e){return function(){return this.as(e)}}var Pi=xi("ms"),Li=xi("s"),Di=xi("m"),ki=xi("h"),Hi=xi("d"),Fi=xi("w"),Ui=xi("M"),Vi=xi("Q"),Bi=xi("y"),Wi=Pi;function Yi(){return An(this)}function Gi(e){return e=ne(e),this.isValid()?this[e+"s"]():NaN}function ji(e){return function(){return this.isValid()?this._data[e]:NaN}}var zi=ji("milliseconds"),$i=ji("seconds"),Ki=ji("minutes"),Xi=ji("hours"),qi=ji("days"),Qi=ji("months"),Zi=ji("years");function Ji(){return Ie(this.days()/7)}var eo=Math.round,to={ss:44,s:45,m:45,h:22,d:26,w:null,M:11};function ro(e,t,r,n,s){return s.relativeTime(t||1,!!r,e,n)}function no(e,t,r,n){var s=An(e).abs(),i=eo(s.as("s")),o=eo(s.as("m")),a=eo(s.as("h")),l=eo(s.as("d")),h=eo(s.as("M")),u=eo(s.as("w")),c=eo(s.as("y")),d=i<=r.ss&&["s",i]||i<r.s&&["ss",i]||o<=1&&["m"]||o<r.m&&["mm",o]||a<=1&&["h"]||a<r.h&&["hh",a]||l<=1&&["d"]||l<r.d&&["dd",l];return null!=r.w&&(d=d||u<=1&&["w"]||u<r.w&&["ww",u]),(d=d||h<=1&&["M"]||h<r.M&&["MM",h]||c<=1&&["y"]||["yy",c])[2]=t,d[3]=+e>0,d[4]=n,ro.apply(null,d)}function so(e){return void 0===e?eo:"function"==typeof e&&(eo=e,!0)}function io(e,t){return void 0!==to[e]&&(void 0===t?to[e]:(to[e]=t,"s"===e&&(to.ss=t-1),!0))}function oo(e,t){if(!this.isValid())return this.localeData().invalidDate();var r,n,s=!1,i=to;return"object"==typeof e&&(t=e,e=!1),"boolean"==typeof e&&(s=e),"object"==typeof t&&(i=Object.assign({},to,t),null!=t.s&&null==t.ss&&(i.ss=t.s-1)),n=no(this,!s,i,r=this.localeData()),s&&(n=r.pastFuture(+this,n)),r.postformat(n)}var ao=Math.abs;function lo(e){return(e>0)-(e<0)||+e}function ho(){if(!this.isValid())return this.localeData().invalidDate();var e,t,r,n,s,i,o,a,l=ao(this._milliseconds)/1e3,h=ao(this._days),u=ao(this._months),c=this.asSeconds();return c?(e=Ie(l/60),t=Ie(e/60),l%=60,e%=60,r=Ie(u/12),u%=12,n=l?l.toFixed(3).replace(/\.?0+$/,""):"",s=c<0?"-":"",i=lo(this._months)!==lo(c)?"-":"",o=lo(this._days)!==lo(c)?"-":"",a=lo(this._milliseconds)!==lo(c)?"-":"",s+"P"+(r?i+r+"Y":"")+(u?i+u+"M":"")+(h?o+h+"D":"")+(t||e||l?"T":"")+(t?a+t+"H":"")+(e?a+e+"M":"")+(l?a+n+"S":"")):"P0D"}var uo=an.prototype;return uo.isValid=sn,uo.abs=Si,uo.add=Ni,uo.subtract=Mi,uo.as=Ii,uo.asMilliseconds=Pi,uo.asSeconds=Li,uo.asMinutes=Di,uo.asHours=ki,uo.asDays=Hi,uo.asWeeks=Fi,uo.asMonths=Ui,uo.asQuarters=Vi,uo.asYears=Bi,uo.valueOf=Wi,uo._bubble=bi,uo.clone=Yi,uo.get=Gi,uo.milliseconds=zi,uo.seconds=$i,uo.minutes=Ki,uo.hours=Xi,uo.days=qi,uo.weeks=Ji,uo.months=Qi,uo.years=Zi,uo.humanize=oo,uo.toISOString=ho,uo.toString=ho,uo.toJSON=ho,uo.locale=as,uo.localeData=hs,uo.toIsoString=M("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",ho),uo.lang=ls,B("X",0,0,"unix"),B("x",0,0,"valueOf"),_e("x",Ce),_e("X",Se),Le("X",(function(e,t,r){r._d=new Date(1e3*parseFloat(e))})),Le("x",(function(e,t,r){r._d=new Date(xe(e))})),
//! moment.js
s.version="2.30.1",i(Xr),s.fn=hi,s.min=Jr,s.max=en,s.now=tn,s.utc=f,s.unix=ui,s.months=yi,s.isDate=d,s.locale=fr,s.invalid=w,s.duration=An,s.isMoment=T,s.weekdays=wi,s.parseZone=ci,s.localeData=Er,s.isDuration=ln,s.monthsShort=Ei,s.weekdaysMin=vi,s.defineLocale=mr,s.updateLocale=yr,s.locales=wr,s.weekdaysShort=Ci,s.normalizeUnits=ne,s.relativeTimeRounding=so,s.relativeTimeThreshold=io,s.calendarFormat=Wn,s.prototype=hi,s.HTML5_FMT={DATETIME_LOCAL:"YYYY-MM-DDTHH:mm",DATETIME_LOCAL_SECONDS:"YYYY-MM-DDTHH:mm:ss",DATETIME_LOCAL_MS:"YYYY-MM-DDTHH:mm:ss.SSS",DATE:"YYYY-MM-DD",TIME:"HH:mm",TIME_SECONDS:"HH:mm:ss",TIME_MS:"HH:mm:ss.SSS",WEEK:"GGGG-[W]WW",MONTH:"YYYY-MM"},s}(),window.moment=r(6671)},80586:(e,t,r)=>{"use strict";r.r(t),r.d(t,{default:()=>K});var n,s,i,o,a,l,h="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function u(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}
/*!
 * Copyright (c) 2017 Benjamin Van Ryseghem<benjamin@vanryseghem.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */function c(){return s?n:(s=1,n={languageTag:"en-US",delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},spaceSeparated:!1,ordinal:function(e){let t=e%10;return 1==~~(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th"},bytes:{binarySuffixes:["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],decimalSuffixes:["B","KB","MB","GB","TB","PB","EB","ZB","YB"]},currency:{symbol:"$",position:"prefix",code:"USD"},currencyFormat:{thousandSeparated:!0,totalLength:4,spaceSeparated:!0,spaceSeparatedCurrency:!0},formats:{fourDigits:{totalLength:4,spaceSeparated:!0},fullWithTwoDecimals:{output:"currency",thousandSeparated:!0,mantissa:2},fullWithTwoDecimalsNoCurrency:{thousandSeparated:!0,mantissa:2},fullWithNoDecimals:{output:"currency",thousandSeparated:!0,mantissa:0}}})}
/*!
 * Copyright (c) 2017 Benjamin Van Ryseghem<benjamin@vanryseghem.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */function d(){if(o)return i;o=1;const e=[{key:"ZiB",factor:Math.pow(1024,7)},{key:"ZB",factor:Math.pow(1e3,7)},{key:"YiB",factor:Math.pow(1024,8)},{key:"YB",factor:Math.pow(1e3,8)},{key:"TiB",factor:Math.pow(1024,4)},{key:"TB",factor:Math.pow(1e3,4)},{key:"PiB",factor:Math.pow(1024,5)},{key:"PB",factor:Math.pow(1e3,5)},{key:"MiB",factor:Math.pow(1024,2)},{key:"MB",factor:Math.pow(1e3,2)},{key:"KiB",factor:Math.pow(1024,1)},{key:"KB",factor:Math.pow(1e3,1)},{key:"GiB",factor:Math.pow(1024,3)},{key:"GB",factor:Math.pow(1e3,3)},{key:"EiB",factor:Math.pow(1024,6)},{key:"EB",factor:Math.pow(1e3,6)},{key:"B",factor:1}];function t(e){return e.replace(/[-/\\^$*+?.()|[\]{}]/g,"\\$&")}function r(n,s,i,o,a,l,h){if(!isNaN(+n))return+n;let u="",c=n.replace(/(^[^(]*)\((.*)\)([^)]*$)/,"$1$2$3");if(c!==n)return-1*r(c,s,i,o,a,l);for(let t=0;t<e.length;t++){let h=e[t];if(u=n.replace(RegExp(`([0-9 ])(${h.key})$`),"$1"),u!==n)return r(u,s,i,o,a,l)*h.factor}if(u=n.replace("%",""),u!==n)return r(u,s,i,o,a,l)/100;let d=parseFloat(n);if(isNaN(d))return;let p=o(d);if(p&&"."!==p&&(u=n.replace(new RegExp(`${t(p)}$`),""),u!==n))return r(u,s,i,o,a,l);let g={};Object.keys(l).forEach((e=>{g[l[e]]=e}));let f=Object.keys(g).sort().reverse(),m=f.length;for(let e=0;e<m;e++){let t=f[e],h=g[t];if(u=n.replace(t,""),u!==n){let e;switch(h){case"thousand":e=Math.pow(10,3);break;case"million":e=Math.pow(10,6);break;case"billion":e=Math.pow(10,9);break;case"trillion":e=Math.pow(10,12)}return r(u,s,i,o,a,l)*e}}}function n(e,n,s="",i,o,a,l){if(""===e)return;if(e===o)return 0;let h=function(e,r,n){let s=e.replace(n,"");return s=s.replace(new RegExp(`([0-9])${t(r.thousands)}([0-9])`,"g"),"$1$2"),s=s.replace(r.decimal,"."),s}(e,n,s);return r(h,n,s,i,o,a)}return i={unformat:function(e,t){const r=y();let s,i=r.currentDelimiters(),o=r.currentCurrency().symbol,a=r.currentOrdinal(),l=r.getZeroFormat(),h=r.currentAbbreviations();if("string"==typeof e)s=function(e,t){if(!e.indexOf(":")||":"===t.thousands)return!1;let r=e.split(":");if(3!==r.length)return!1;let n=+r[0],s=+r[1],i=+r[2];return!isNaN(n)&&!isNaN(s)&&!isNaN(i)}(e,i)?function(e){let t=e.split(":"),r=+t[0],n=+t[1];return+t[2]+60*n+3600*r}(e):n(e,i,o,a,l,h);else{if("number"!=typeof e)return;s=e}if(void 0!==s)return s}},i}
/*!
 * Copyright (c) 2017 Benjamin Van Ryseghem<benjamin@vanryseghem.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */function p(){if(l)return a;l=1;let e=d();const t=/^[a-z]{2,3}(-[a-zA-Z]{4})?(-([A-Z]{2}|[0-9]{3}))?$/,r={output:{type:"string",validValues:["currency","percent","byte","time","ordinal","number"]},base:{type:"string",validValues:["decimal","binary","general"],restriction:(e,t)=>"byte"===t.output,message:"`base` must be provided only when the output is `byte`",mandatory:e=>"byte"===e.output},characteristic:{type:"number",restriction:e=>e>=0,message:"value must be positive"},prefix:"string",postfix:"string",forceAverage:{type:"string",validValues:["trillion","billion","million","thousand"]},average:"boolean",lowPrecision:{type:"boolean",restriction:(e,t)=>!0===t.average,message:"`lowPrecision` must be provided only when the option `average` is set"},currencyPosition:{type:"string",validValues:["prefix","infix","postfix"]},currencySymbol:"string",totalLength:{type:"number",restrictions:[{restriction:e=>e>=0,message:"value must be positive"},{restriction:(e,t)=>!t.exponential,message:"`totalLength` is incompatible with `exponential`"}]},mantissa:{type:"number",restriction:e=>e>=0,message:"value must be positive"},optionalMantissa:"boolean",trimMantissa:"boolean",roundingFunction:"function",optionalCharacteristic:"boolean",thousandSeparated:"boolean",spaceSeparated:"boolean",spaceSeparatedCurrency:"boolean",spaceSeparatedAbbreviation:"boolean",abbreviations:{type:"object",children:{thousand:"string",million:"string",billion:"string",trillion:"string"}},negative:{type:"string",validValues:["sign","parenthesis"]},forceSign:"boolean",exponential:{type:"boolean"},prefixSymbol:{type:"boolean",restriction:(e,t)=>"percent"===t.output,message:"`prefixSymbol` can be provided only when the output is `percent`"}},n={languageTag:{type:"string",mandatory:!0,restriction:e=>e.match(t),message:"the language tag must follow the BCP 47 specification (see https://tools.ieft.org/html/bcp47)"},delimiters:{type:"object",children:{thousands:"string",decimal:"string",thousandsSize:"number"},mandatory:!0},abbreviations:{type:"object",children:{thousand:{type:"string",mandatory:!0},million:{type:"string",mandatory:!0},billion:{type:"string",mandatory:!0},trillion:{type:"string",mandatory:!0}},mandatory:!0},spaceSeparated:"boolean",spaceSeparatedCurrency:"boolean",ordinal:{type:"function",mandatory:!0},bytes:{type:"object",children:{binarySuffixes:"object",decimalSuffixes:"object"}},currency:{type:"object",children:{symbol:"string",position:"string",code:"string"},mandatory:!0},defaults:"format",ordinalFormat:"format",byteFormat:"format",percentageFormat:"format",currencyFormat:"format",timeDefaults:"format",formats:{type:"object",children:{fourDigits:{type:"format",mandatory:!0},fullWithTwoDecimals:{type:"format",mandatory:!0},fullWithTwoDecimalsNoCurrency:{type:"format",mandatory:!0},fullWithNoDecimals:{type:"format",mandatory:!0}}}};function s(t){return void 0!==e.unformat(t)}function i(e,t,n,s=!1){let o=Object.keys(e).map((s=>{if(!t[s])return console.error(`${n} Invalid key: ${s}`),!1;let o=e[s],a=t[s];if("string"==typeof a&&(a={type:a}),"format"===a.type){if(!i(o,r,`[Validate ${s}]`,!0))return!1}else if(typeof o!==a.type)return console.error(`${n} ${s} type mismatched: "${a.type}" expected, "${typeof o}" provided`),!1;if(a.restrictions&&a.restrictions.length){let t=a.restrictions.length;for(let r=0;r<t;r++){let{restriction:t,message:i}=a.restrictions[r];if(!t(o,e))return console.error(`${n} ${s} invalid value: ${i}`),!1}}if(a.restriction&&!a.restriction(o,e))return console.error(`${n} ${s} invalid value: ${a.message}`),!1;if(a.validValues&&-1===a.validValues.indexOf(o))return console.error(`${n} ${s} invalid value: must be among ${JSON.stringify(a.validValues)}, "${o}" provided`),!1;if(a.children){if(!i(o,a.children,`[Validate ${s}]`))return!1}return!0}));return s||o.push(...Object.keys(t).map((r=>{let s=t[r];if("string"==typeof s&&(s={type:s}),s.mandatory){let t=s.mandatory;if("function"==typeof t&&(t=t(e)),t&&void 0===e[r])return console.error(`${n} Missing mandatory key "${r}"`),!1}return!0}))),o.reduce(((e,t)=>e&&t),!0)}function o(e){return i(e,r,"[Validate format]")}return a={validate:function(e,t){let r=s(e),n=o(t);return r&&n},validateFormat:o,validateInput:s,validateLanguage:function(e){return i(e,n,"[Validate language]")}},a}
/*!
 * Copyright (c) 2017 Benjamin Van Ryseghem<benjamin@vanryseghem.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */var g,f,m={parseFormat:function(e,t={}){return"string"!=typeof e?e:(function(e,t){if(-1===e.indexOf("$")){if(-1===e.indexOf("%"))return-1!==e.indexOf("bd")?(t.output="byte",void(t.base="general")):-1!==e.indexOf("b")?(t.output="byte",void(t.base="binary")):-1!==e.indexOf("d")?(t.output="byte",void(t.base="decimal")):void(-1===e.indexOf(":")?-1!==e.indexOf("o")&&(t.output="ordinal"):t.output="time");t.output="percent"}else t.output="currency"}(e=function(e,t){let r=e.match(/{([^}]*)}$/);return r?(t.postfix=r[1],e.slice(0,-r[0].length)):e}(e=function(e,t){let r=e.match(/^{([^}]*)}/);return r?(t.prefix=r[1],e.slice(r[0].length)):e}(e,t),t),t),function(e,t){let r=e.match(/[1-9]+[0-9]*/);r&&(t.totalLength=+r[0])}(e,t),function(e,t){let r=e.split(".")[0].match(/0+/);r&&(t.characteristic=r[0].length)}(e,t),function(e,t){if(-1!==e.indexOf(".")){let r=e.split(".")[0];t.optionalCharacteristic=-1===r.indexOf("0")}}(e,t),function(e,t){-1!==e.indexOf("a")&&(t.average=!0)}(e,t),function(e,t){-1!==e.indexOf("K")?t.forceAverage="thousand":-1!==e.indexOf("M")?t.forceAverage="million":-1!==e.indexOf("B")?t.forceAverage="billion":-1!==e.indexOf("T")&&(t.forceAverage="trillion")}(e,t),function(e,t){let r=e.split(".")[1];if(r){let e=r.match(/0+/);e&&(t.mantissa=e[0].length)}}(e,t),function(e,t){e.match(/\[\.]/)?t.optionalMantissa=!0:e.match(/\./)&&(t.optionalMantissa=!1)}(e,t),function(e,t){const r=e.split(".")[1];r&&(t.trimMantissa=-1!==r.indexOf("["))}(e,t),function(e,t){-1!==e.indexOf(",")&&(t.thousandSeparated=!0)}(e,t),function(e,t){-1!==e.indexOf(" ")&&(t.spaceSeparated=!0,t.spaceSeparatedCurrency=!0,(t.average||t.forceAverage)&&(t.spaceSeparatedAbbreviation=!0))}(e,t),function(e,t){e.match(/^\+?\([^)]*\)$/)&&(t.negative="parenthesis"),e.match(/^\+?-/)&&(t.negative="sign")}(e,t),function(e,t){e.match(/^\+/)&&(t.forceSign=!0)}(e,t),t)}};
/*!
 * Copyright (c) 2017 Benjamin Van Ryseghem<benjamin@vanryseghem.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */function y(){if(f)return g;f=1;const e=c(),t=p(),r=m;let n,s={},i={},o=null,a={};function l(e){n=e}function h(){return i[n]}return s.languages=()=>Object.assign({},i),s.currentLanguage=()=>n,s.currentBytes=()=>h().bytes||{},s.currentCurrency=()=>h().currency,s.currentAbbreviations=()=>h().abbreviations,s.currentDelimiters=()=>h().delimiters,s.currentOrdinal=()=>h().ordinal,s.currentDefaults=()=>Object.assign({},h().defaults,a),s.currentOrdinalDefaultFormat=()=>Object.assign({},s.currentDefaults(),h().ordinalFormat),s.currentByteDefaultFormat=()=>Object.assign({},s.currentDefaults(),h().byteFormat),s.currentPercentageDefaultFormat=()=>Object.assign({},s.currentDefaults(),h().percentageFormat),s.currentCurrencyDefaultFormat=()=>Object.assign({},s.currentDefaults(),h().currencyFormat),s.currentTimeDefaultFormat=()=>Object.assign({},s.currentDefaults(),h().timeFormat),s.setDefaults=e=>{e=r.parseFormat(e),t.validateFormat(e)&&(a=e)},s.getZeroFormat=()=>o,s.setZeroFormat=e=>o="string"==typeof e?e:null,s.hasZeroFormat=()=>null!==o,s.languageData=e=>{if(e){if(i[e])return i[e];throw new Error(`Unknown tag "${e}"`)}return h()},s.registerLanguage=(e,r=!1)=>{if(!t.validateLanguage(e))throw new Error("Invalid language data");i[e.languageTag]=e,r&&l(e.languageTag)},s.setLanguage=(t,r=e.languageTag)=>{if(!i[t]){let e=t.split("-")[0],n=Object.keys(i).find((t=>t.split("-")[0]===e));return i[n]?void l(n):void l(r)}l(t)},s.registerLanguage(e),n=e.languageTag,g=s}
/*!
 * Copyright (c) 2017 Benjamin Van Ryseghem<benjamin@vanryseghem.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
function E(e,t){e.forEach((e=>{let r;try{r=function(e){throw new Error('Could not dynamically require "'+e+'". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.')}(`../languages/${e}`)}catch(t){console.error(`Unable to load "${e}". No matching language file found.`)}r&&t.registerLanguage(r)}))}var w={exports:{}};!function(e){!function(t){var r,n=/^-?(?:\d+(?:\.\d*)?|\.\d+)(?:e[+-]?\d+)?$/i,s=Math.ceil,i=Math.floor,o="[BigNumber Error] ",a=o+"Number primitive has more than 15 significant digits: ",l=1e14,h=14,u=9007199254740991,c=[1,10,100,1e3,1e4,1e5,1e6,1e7,1e8,1e9,1e10,1e11,1e12,1e13],d=1e7,p=1e9;function g(e){var t=0|e;return e>0||e===t?t:t-1}function f(e){for(var t,r,n=1,s=e.length,i=e[0]+"";n<s;){for(t=e[n++]+"",r=h-t.length;r--;t="0"+t);i+=t}for(s=i.length;48===i.charCodeAt(--s););return i.slice(0,s+1||1)}function m(e,t){var r,n,s=e.c,i=t.c,o=e.s,a=t.s,l=e.e,h=t.e;if(!o||!a)return null;if(r=s&&!s[0],n=i&&!i[0],r||n)return r?n?0:-a:o;if(o!=a)return o;if(r=o<0,n=l==h,!s||!i)return n?0:!s^r?1:-1;if(!n)return l>h^r?1:-1;for(a=(l=s.length)<(h=i.length)?l:h,o=0;o<a;o++)if(s[o]!=i[o])return s[o]>i[o]^r?1:-1;return l==h?0:l>h^r?1:-1}function y(e,t,r,n){if(e<t||e>r||e!==i(e))throw Error(o+(n||"Argument")+("number"==typeof e?e<t||e>r?" out of range: ":" not an integer: ":" not a primitive number: ")+String(e))}function E(e){var t=e.c.length-1;return g(e.e/h)==t&&e.c[t]%2!=0}function w(e,t){return(e.length>1?e.charAt(0)+"."+e.slice(1):e)+(t<0?"e":"e+")+t}function C(e,t,r){var n,s;if(t<0){for(s=r+".";++t;s+=r);e=s+e}else if(++t>(n=e.length)){for(s=r,t-=n;--t;s+=r);e+=s}else t<n&&(e=e.slice(0,t)+"."+e.slice(t));return e}r=function e(t){var r,v,R,S,T,N,M,_,b,A,O=G.prototype={constructor:G,toString:null,valueOf:null},I=new G(1),x=20,P=4,L=-7,D=21,k=-1e7,H=1e7,F=!1,U=1,V=0,B={prefix:"",groupSize:3,secondaryGroupSize:0,groupSeparator:",",decimalSeparator:".",fractionGroupSize:0,fractionGroupSeparator:" ",suffix:""},W="0123456789abcdefghijklmnopqrstuvwxyz",Y=!0;function G(e,t){var r,s,o,l,c,d,p,g,f=this;if(!(f instanceof G))return new G(e,t);if(null==t){if(e&&!0===e._isBigNumber)return f.s=e.s,void(!e.c||e.e>H?f.c=f.e=null:e.e<k?f.c=[f.e=0]:(f.e=e.e,f.c=e.c.slice()));if((d="number"==typeof e)&&0*e==0){if(f.s=1/e<0?(e=-e,-1):1,e===~~e){for(l=0,c=e;c>=10;c/=10,l++);return void(l>H?f.c=f.e=null:(f.e=l,f.c=[e]))}g=String(e)}else{if(!n.test(g=String(e)))return R(f,g,d);f.s=45==g.charCodeAt(0)?(g=g.slice(1),-1):1}(l=g.indexOf("."))>-1&&(g=g.replace(".","")),(c=g.search(/e/i))>0?(l<0&&(l=c),l+=+g.slice(c+1),g=g.substring(0,c)):l<0&&(l=g.length)}else{if(y(t,2,W.length,"Base"),10==t&&Y)return K(f=new G(e),x+f.e+1,P);if(g=String(e),d="number"==typeof e){if(0*e!=0)return R(f,g,d,t);if(f.s=1/e<0?(g=g.slice(1),-1):1,G.DEBUG&&g.replace(/^0\.0*|\./,"").length>15)throw Error(a+e)}else f.s=45===g.charCodeAt(0)?(g=g.slice(1),-1):1;for(r=W.slice(0,t),l=c=0,p=g.length;c<p;c++)if(r.indexOf(s=g.charAt(c))<0){if("."==s){if(c>l){l=p;continue}}else if(!o&&(g==g.toUpperCase()&&(g=g.toLowerCase())||g==g.toLowerCase()&&(g=g.toUpperCase()))){o=!0,c=-1,l=0;continue}return R(f,String(e),d,t)}d=!1,(l=(g=v(g,t,10,f.s)).indexOf("."))>-1?g=g.replace(".",""):l=g.length}for(c=0;48===g.charCodeAt(c);c++);for(p=g.length;48===g.charCodeAt(--p););if(g=g.slice(c,++p)){if(p-=c,d&&G.DEBUG&&p>15&&(e>u||e!==i(e)))throw Error(a+f.s*e);if((l=l-c-1)>H)f.c=f.e=null;else if(l<k)f.c=[f.e=0];else{if(f.e=l,f.c=[],c=(l+1)%h,l<0&&(c+=h),c<p){for(c&&f.c.push(+g.slice(0,c)),p-=h;c<p;)f.c.push(+g.slice(c,c+=h));c=h-(g=g.slice(c)).length}else c-=p;for(;c--;g+="0");f.c.push(+g)}}else f.c=[f.e=0]}function j(e,t,r,n){var s,i,o,a,l;if(null==r?r=P:y(r,0,8),!e.c)return e.toString();if(s=e.c[0],o=e.e,null==t)l=f(e.c),l=1==n||2==n&&(o<=L||o>=D)?w(l,o):C(l,o,"0");else if(i=(e=K(new G(e),t,r)).e,a=(l=f(e.c)).length,1==n||2==n&&(t<=i||i<=L)){for(;a<t;l+="0",a++);l=w(l,i)}else if(t-=o,l=C(l,i,"0"),i+1>a){if(--t>0)for(l+=".";t--;l+="0");}else if((t+=i-a)>0)for(i+1==a&&(l+=".");t--;l+="0");return e.s<0&&s?"-"+l:l}function z(e,t){for(var r,n,s=1,i=new G(e[0]);s<e.length;s++)(!(n=new G(e[s])).s||(r=m(i,n))===t||0===r&&i.s===t)&&(i=n);return i}function $(e,t,r){for(var n=1,s=t.length;!t[--s];t.pop());for(s=t[0];s>=10;s/=10,n++);return(r=n+r*h-1)>H?e.c=e.e=null:r<k?e.c=[e.e=0]:(e.e=r,e.c=t),e}function K(e,t,r,n){var o,a,u,d,p,g,f,m=e.c,y=c;if(m){e:{for(o=1,d=m[0];d>=10;d/=10,o++);if((a=t-o)<0)a+=h,u=t,p=m[g=0],f=i(p/y[o-u-1]%10);else if((g=s((a+1)/h))>=m.length){if(!n)break e;for(;m.length<=g;m.push(0));p=f=0,o=1,u=(a%=h)-h+1}else{for(p=d=m[g],o=1;d>=10;d/=10,o++);f=(u=(a%=h)-h+o)<0?0:i(p/y[o-u-1]%10)}if(n=n||t<0||null!=m[g+1]||(u<0?p:p%y[o-u-1]),n=r<4?(f||n)&&(0==r||r==(e.s<0?3:2)):f>5||5==f&&(4==r||n||6==r&&(a>0?u>0?p/y[o-u]:0:m[g-1])%10&1||r==(e.s<0?8:7)),t<1||!m[0])return m.length=0,n?(t-=e.e+1,m[0]=y[(h-t%h)%h],e.e=-t||0):m[0]=e.e=0,e;if(0==a?(m.length=g,d=1,g--):(m.length=g+1,d=y[h-a],m[g]=u>0?i(p/y[o-u]%y[u])*d:0),n)for(;;){if(0==g){for(a=1,u=m[0];u>=10;u/=10,a++);for(u=m[0]+=d,d=1;u>=10;u/=10,d++);a!=d&&(e.e++,m[0]==l&&(m[0]=1));break}if(m[g]+=d,m[g]!=l)break;m[g--]=0,d=1}for(a=m.length;0===m[--a];m.pop());}e.e>H?e.c=e.e=null:e.e<k&&(e.c=[e.e=0])}return e}function X(e){var t,r=e.e;return null===r?e.toString():(t=f(e.c),t=r<=L||r>=D?w(t,r):C(t,r,"0"),e.s<0?"-"+t:t)}return G.clone=e,G.ROUND_UP=0,G.ROUND_DOWN=1,G.ROUND_CEIL=2,G.ROUND_FLOOR=3,G.ROUND_HALF_UP=4,G.ROUND_HALF_DOWN=5,G.ROUND_HALF_EVEN=6,G.ROUND_HALF_CEIL=7,G.ROUND_HALF_FLOOR=8,G.EUCLID=9,G.config=G.set=function(e){var t,r;if(null!=e){if("object"!=typeof e)throw Error(o+"Object expected: "+e);if(e.hasOwnProperty(t="DECIMAL_PLACES")&&(y(r=e[t],0,p,t),x=r),e.hasOwnProperty(t="ROUNDING_MODE")&&(y(r=e[t],0,8,t),P=r),e.hasOwnProperty(t="EXPONENTIAL_AT")&&((r=e[t])&&r.pop?(y(r[0],-p,0,t),y(r[1],0,p,t),L=r[0],D=r[1]):(y(r,-p,p,t),L=-(D=r<0?-r:r))),e.hasOwnProperty(t="RANGE"))if((r=e[t])&&r.pop)y(r[0],-p,-1,t),y(r[1],1,p,t),k=r[0],H=r[1];else{if(y(r,-p,p,t),!r)throw Error(o+t+" cannot be zero: "+r);k=-(H=r<0?-r:r)}if(e.hasOwnProperty(t="CRYPTO")){if((r=e[t])!==!!r)throw Error(o+t+" not true or false: "+r);if(r){if("undefined"==typeof crypto||!crypto||!crypto.getRandomValues&&!crypto.randomBytes)throw F=!r,Error(o+"crypto unavailable");F=r}else F=r}if(e.hasOwnProperty(t="MODULO_MODE")&&(y(r=e[t],0,9,t),U=r),e.hasOwnProperty(t="POW_PRECISION")&&(y(r=e[t],0,p,t),V=r),e.hasOwnProperty(t="FORMAT")){if("object"!=typeof(r=e[t]))throw Error(o+t+" not an object: "+r);B=r}if(e.hasOwnProperty(t="ALPHABET")){if("string"!=typeof(r=e[t])||/^.?$|[+\-.\s]|(.).*\1/.test(r))throw Error(o+t+" invalid: "+r);Y="0123456789"==r.slice(0,10),W=r}}return{DECIMAL_PLACES:x,ROUNDING_MODE:P,EXPONENTIAL_AT:[L,D],RANGE:[k,H],CRYPTO:F,MODULO_MODE:U,POW_PRECISION:V,FORMAT:B,ALPHABET:W}},G.isBigNumber=function(e){if(!e||!0!==e._isBigNumber)return!1;if(!G.DEBUG)return!0;var t,r,n=e.c,s=e.e,a=e.s;e:if("[object Array]"=={}.toString.call(n)){if((1===a||-1===a)&&s>=-p&&s<=p&&s===i(s)){if(0===n[0]){if(0===s&&1===n.length)return!0;break e}if((t=(s+1)%h)<1&&(t+=h),String(n[0]).length==t){for(t=0;t<n.length;t++)if((r=n[t])<0||r>=l||r!==i(r))break e;if(0!==r)return!0}}}else if(null===n&&null===s&&(null===a||1===a||-1===a))return!0;throw Error(o+"Invalid BigNumber: "+e)},G.maximum=G.max=function(){return z(arguments,-1)},G.minimum=G.min=function(){return z(arguments,1)},G.random=(S=9007199254740992,T=Math.random()*S&2097151?function(){return i(Math.random()*S)}:function(){return 8388608*(1073741824*Math.random()|0)+(8388608*Math.random()|0)},function(e){var t,r,n,a,l,u=0,d=[],g=new G(I);if(null==e?e=x:y(e,0,p),a=s(e/h),F)if(crypto.getRandomValues){for(t=crypto.getRandomValues(new Uint32Array(a*=2));u<a;)(l=131072*t[u]+(t[u+1]>>>11))>=9e15?(r=crypto.getRandomValues(new Uint32Array(2)),t[u]=r[0],t[u+1]=r[1]):(d.push(l%1e14),u+=2);u=a/2}else{if(!crypto.randomBytes)throw F=!1,Error(o+"crypto unavailable");for(t=crypto.randomBytes(a*=7);u<a;)(l=281474976710656*(31&t[u])+1099511627776*t[u+1]+4294967296*t[u+2]+16777216*t[u+3]+(t[u+4]<<16)+(t[u+5]<<8)+t[u+6])>=9e15?crypto.randomBytes(7).copy(t,u):(d.push(l%1e14),u+=7);u=a/7}if(!F)for(;u<a;)(l=T())<9e15&&(d[u++]=l%1e14);for(a=d[--u],e%=h,a&&e&&(l=c[h-e],d[u]=i(a/l)*l);0===d[u];d.pop(),u--);if(u<0)d=[n=0];else{for(n=-1;0===d[0];d.splice(0,1),n-=h);for(u=1,l=d[0];l>=10;l/=10,u++);u<h&&(n-=h-u)}return g.e=n,g.c=d,g}),G.sum=function(){for(var e=1,t=arguments,r=new G(t[0]);e<t.length;)r=r.plus(t[e++]);return r},v=function(){var e="0123456789";function t(e,t,r,n){for(var s,i,o=[0],a=0,l=e.length;a<l;){for(i=o.length;i--;o[i]*=t);for(o[0]+=n.indexOf(e.charAt(a++)),s=0;s<o.length;s++)o[s]>r-1&&(null==o[s+1]&&(o[s+1]=0),o[s+1]+=o[s]/r|0,o[s]%=r)}return o.reverse()}return function(n,s,i,o,a){var l,h,u,c,d,p,g,m,y=n.indexOf("."),E=x,w=P;for(y>=0&&(c=V,V=0,n=n.replace(".",""),p=(m=new G(s)).pow(n.length-y),V=c,m.c=t(C(f(p.c),p.e,"0"),10,i,e),m.e=m.c.length),u=c=(g=t(n,s,i,a?(l=W,e):(l=e,W))).length;0==g[--c];g.pop());if(!g[0])return l.charAt(0);if(y<0?--u:(p.c=g,p.e=u,p.s=o,g=(p=r(p,m,E,w,i)).c,d=p.r,u=p.e),y=g[h=u+E+1],c=i/2,d=d||h<0||null!=g[h+1],d=w<4?(null!=y||d)&&(0==w||w==(p.s<0?3:2)):y>c||y==c&&(4==w||d||6==w&&1&g[h-1]||w==(p.s<0?8:7)),h<1||!g[0])n=d?C(l.charAt(1),-E,l.charAt(0)):l.charAt(0);else{if(g.length=h,d)for(--i;++g[--h]>i;)g[h]=0,h||(++u,g=[1].concat(g));for(c=g.length;!g[--c];);for(y=0,n="";y<=c;n+=l.charAt(g[y++]));n=C(n,u,l.charAt(0))}return n}}(),r=function(){function e(e,t,r){var n,s,i,o,a=0,l=e.length,h=t%d,u=t/d|0;for(e=e.slice();l--;)a=((s=h*(i=e[l]%d)+(n=u*i+(o=e[l]/d|0)*h)%d*d+a)/r|0)+(n/d|0)+u*o,e[l]=s%r;return a&&(e=[a].concat(e)),e}function t(e,t,r,n){var s,i;if(r!=n)i=r>n?1:-1;else for(s=i=0;s<r;s++)if(e[s]!=t[s]){i=e[s]>t[s]?1:-1;break}return i}function r(e,t,r,n){for(var s=0;r--;)e[r]-=s,s=e[r]<t[r]?1:0,e[r]=s*n+e[r]-t[r];for(;!e[0]&&e.length>1;e.splice(0,1));}return function(n,s,o,a,u){var c,d,p,f,m,y,E,w,C,v,R,S,T,N,M,_,b,A=n.s==s.s?1:-1,O=n.c,I=s.c;if(!(O&&O[0]&&I&&I[0]))return new G(n.s&&s.s&&(O?!I||O[0]!=I[0]:I)?O&&0==O[0]||!I?0*A:A/0:NaN);for(C=(w=new G(A)).c=[],A=o+(d=n.e-s.e)+1,u||(u=l,d=g(n.e/h)-g(s.e/h),A=A/h|0),p=0;I[p]==(O[p]||0);p++);if(I[p]>(O[p]||0)&&d--,A<0)C.push(1),f=!0;else{for(N=O.length,_=I.length,p=0,A+=2,(m=i(u/(I[0]+1)))>1&&(I=e(I,m,u),O=e(O,m,u),_=I.length,N=O.length),T=_,R=(v=O.slice(0,_)).length;R<_;v[R++]=0);b=I.slice(),b=[0].concat(b),M=I[0],I[1]>=u/2&&M++;do{if(m=0,(c=t(I,v,_,R))<0){if(S=v[0],_!=R&&(S=S*u+(v[1]||0)),(m=i(S/M))>1)for(m>=u&&(m=u-1),E=(y=e(I,m,u)).length,R=v.length;1==t(y,v,E,R);)m--,r(y,_<E?b:I,E,u),E=y.length,c=1;else 0==m&&(c=m=1),E=(y=I.slice()).length;if(E<R&&(y=[0].concat(y)),r(v,y,R,u),R=v.length,-1==c)for(;t(I,v,_,R)<1;)m++,r(v,_<R?b:I,R,u),R=v.length}else 0===c&&(m++,v=[0]);C[p++]=m,v[0]?v[R++]=O[T]||0:(v=[O[T]],R=1)}while((T++<N||null!=v[0])&&A--);f=null!=v[0],C[0]||C.splice(0,1)}if(u==l){for(p=1,A=C[0];A>=10;A/=10,p++);K(w,o+(w.e=p+d*h-1)+1,a,f)}else w.e=d,w.r=+f;return w}}(),N=/^(-?)0([xbo])(?=\w[\w.]*$)/i,M=/^([^.]+)\.$/,_=/^\.([^.]+)$/,b=/^-?(Infinity|NaN)$/,A=/^\s*\+(?=[\w.])|^\s+|\s+$/g,R=function(e,t,r,n){var s,i=r?t:t.replace(A,"");if(b.test(i))e.s=isNaN(i)?null:i<0?-1:1;else{if(!r&&(i=i.replace(N,(function(e,t,r){return s="x"==(r=r.toLowerCase())?16:"b"==r?2:8,n&&n!=s?e:t})),n&&(s=n,i=i.replace(M,"$1").replace(_,"0.$1")),t!=i))return new G(i,s);if(G.DEBUG)throw Error(o+"Not a"+(n?" base "+n:"")+" number: "+t);e.s=null}e.c=e.e=null},O.absoluteValue=O.abs=function(){var e=new G(this);return e.s<0&&(e.s=1),e},O.comparedTo=function(e,t){return m(this,new G(e,t))},O.decimalPlaces=O.dp=function(e,t){var r,n,s,i=this;if(null!=e)return y(e,0,p),null==t?t=P:y(t,0,8),K(new G(i),e+i.e+1,t);if(!(r=i.c))return null;if(n=((s=r.length-1)-g(this.e/h))*h,s=r[s])for(;s%10==0;s/=10,n--);return n<0&&(n=0),n},O.dividedBy=O.div=function(e,t){return r(this,new G(e,t),x,P)},O.dividedToIntegerBy=O.idiv=function(e,t){return r(this,new G(e,t),0,1)},O.exponentiatedBy=O.pow=function(e,t){var r,n,a,l,u,c,d,p,g=this;if((e=new G(e)).c&&!e.isInteger())throw Error(o+"Exponent not an integer: "+X(e));if(null!=t&&(t=new G(t)),u=e.e>14,!g.c||!g.c[0]||1==g.c[0]&&!g.e&&1==g.c.length||!e.c||!e.c[0])return p=new G(Math.pow(+X(g),u?e.s*(2-E(e)):+X(e))),t?p.mod(t):p;if(c=e.s<0,t){if(t.c?!t.c[0]:!t.s)return new G(NaN);(n=!c&&g.isInteger()&&t.isInteger())&&(g=g.mod(t))}else{if(e.e>9&&(g.e>0||g.e<-1||(0==g.e?g.c[0]>1||u&&g.c[1]>=24e7:g.c[0]<8e13||u&&g.c[0]<=9999975e7)))return l=g.s<0&&E(e)?-0:0,g.e>-1&&(l=1/l),new G(c?1/l:l);V&&(l=s(V/h+2))}for(u?(r=new G(.5),c&&(e.s=1),d=E(e)):d=(a=Math.abs(+X(e)))%2,p=new G(I);;){if(d){if(!(p=p.times(g)).c)break;l?p.c.length>l&&(p.c.length=l):n&&(p=p.mod(t))}if(a){if(0===(a=i(a/2)))break;d=a%2}else if(K(e=e.times(r),e.e+1,1),e.e>14)d=E(e);else{if(0===(a=+X(e)))break;d=a%2}g=g.times(g),l?g.c&&g.c.length>l&&(g.c.length=l):n&&(g=g.mod(t))}return n?p:(c&&(p=I.div(p)),t?p.mod(t):l?K(p,V,P,undefined):p)},O.integerValue=function(e){var t=new G(this);return null==e?e=P:y(e,0,8),K(t,t.e+1,e)},O.isEqualTo=O.eq=function(e,t){return 0===m(this,new G(e,t))},O.isFinite=function(){return!!this.c},O.isGreaterThan=O.gt=function(e,t){return m(this,new G(e,t))>0},O.isGreaterThanOrEqualTo=O.gte=function(e,t){return 1===(t=m(this,new G(e,t)))||0===t},O.isInteger=function(){return!!this.c&&g(this.e/h)>this.c.length-2},O.isLessThan=O.lt=function(e,t){return m(this,new G(e,t))<0},O.isLessThanOrEqualTo=O.lte=function(e,t){return-1===(t=m(this,new G(e,t)))||0===t},O.isNaN=function(){return!this.s},O.isNegative=function(){return this.s<0},O.isPositive=function(){return this.s>0},O.isZero=function(){return!!this.c&&0==this.c[0]},O.minus=function(e,t){var r,n,s,i,o=this,a=o.s;if(t=(e=new G(e,t)).s,!a||!t)return new G(NaN);if(a!=t)return e.s=-t,o.plus(e);var u=o.e/h,c=e.e/h,d=o.c,p=e.c;if(!u||!c){if(!d||!p)return d?(e.s=-t,e):new G(p?o:NaN);if(!d[0]||!p[0])return p[0]?(e.s=-t,e):new G(d[0]?o:3==P?-0:0)}if(u=g(u),c=g(c),d=d.slice(),a=u-c){for((i=a<0)?(a=-a,s=d):(c=u,s=p),s.reverse(),t=a;t--;s.push(0));s.reverse()}else for(n=(i=(a=d.length)<(t=p.length))?a:t,a=t=0;t<n;t++)if(d[t]!=p[t]){i=d[t]<p[t];break}if(i&&(s=d,d=p,p=s,e.s=-e.s),(t=(n=p.length)-(r=d.length))>0)for(;t--;d[r++]=0);for(t=l-1;n>a;){if(d[--n]<p[n]){for(r=n;r&&!d[--r];d[r]=t);--d[r],d[n]+=l}d[n]-=p[n]}for(;0==d[0];d.splice(0,1),--c);return d[0]?$(e,d,c):(e.s=3==P?-1:1,e.c=[e.e=0],e)},O.modulo=O.mod=function(e,t){var n,s,i=this;return e=new G(e,t),!i.c||!e.s||e.c&&!e.c[0]?new G(NaN):!e.c||i.c&&!i.c[0]?new G(i):(9==U?(s=e.s,e.s=1,n=r(i,e,0,3),e.s=s,n.s*=s):n=r(i,e,0,U),(e=i.minus(n.times(e))).c[0]||1!=U||(e.s=i.s),e)},O.multipliedBy=O.times=function(e,t){var r,n,s,i,o,a,u,c,p,f,m,y,E,w,C,v=this,R=v.c,S=(e=new G(e,t)).c;if(!(R&&S&&R[0]&&S[0]))return!v.s||!e.s||R&&!R[0]&&!S||S&&!S[0]&&!R?e.c=e.e=e.s=null:(e.s*=v.s,R&&S?(e.c=[0],e.e=0):e.c=e.e=null),e;for(n=g(v.e/h)+g(e.e/h),e.s*=v.s,(u=R.length)<(f=S.length)&&(E=R,R=S,S=E,s=u,u=f,f=s),s=u+f,E=[];s--;E.push(0));for(w=l,C=d,s=f;--s>=0;){for(r=0,m=S[s]%C,y=S[s]/C|0,i=s+(o=u);i>s;)r=((c=m*(c=R[--o]%C)+(a=y*c+(p=R[o]/C|0)*m)%C*C+E[i]+r)/w|0)+(a/C|0)+y*p,E[i--]=c%w;E[i]=r}return r?++n:E.splice(0,1),$(e,E,n)},O.negated=function(){var e=new G(this);return e.s=-e.s||null,e},O.plus=function(e,t){var r,n=this,s=n.s;if(t=(e=new G(e,t)).s,!s||!t)return new G(NaN);if(s!=t)return e.s=-t,n.minus(e);var i=n.e/h,o=e.e/h,a=n.c,u=e.c;if(!i||!o){if(!a||!u)return new G(s/0);if(!a[0]||!u[0])return u[0]?e:new G(a[0]?n:0*s)}if(i=g(i),o=g(o),a=a.slice(),s=i-o){for(s>0?(o=i,r=u):(s=-s,r=a),r.reverse();s--;r.push(0));r.reverse()}for((s=a.length)-(t=u.length)<0&&(r=u,u=a,a=r,t=s),s=0;t;)s=(a[--t]=a[t]+u[t]+s)/l|0,a[t]=l===a[t]?0:a[t]%l;return s&&(a=[s].concat(a),++o),$(e,a,o)},O.precision=O.sd=function(e,t){var r,n,s,i=this;if(null!=e&&e!==!!e)return y(e,1,p),null==t?t=P:y(t,0,8),K(new G(i),e,t);if(!(r=i.c))return null;if(n=(s=r.length-1)*h+1,s=r[s]){for(;s%10==0;s/=10,n--);for(s=r[0];s>=10;s/=10,n++);}return e&&i.e+1>n&&(n=i.e+1),n},O.shiftedBy=function(e){return y(e,-9007199254740991,u),this.times("1e"+e)},O.squareRoot=O.sqrt=function(){var e,t,n,s,i,o=this,a=o.c,l=o.s,h=o.e,u=x+4,c=new G("0.5");if(1!==l||!a||!a[0])return new G(!l||l<0&&(!a||a[0])?NaN:a?o:1/0);if(0==(l=Math.sqrt(+X(o)))||l==1/0?(((t=f(a)).length+h)%2==0&&(t+="0"),l=Math.sqrt(+t),h=g((h+1)/2)-(h<0||h%2),n=new G(t=l==1/0?"5e"+h:(t=l.toExponential()).slice(0,t.indexOf("e")+1)+h)):n=new G(l+""),n.c[0])for((l=(h=n.e)+u)<3&&(l=0);;)if(i=n,n=c.times(i.plus(r(o,i,u,1))),f(i.c).slice(0,l)===(t=f(n.c)).slice(0,l)){if(n.e<h&&--l,"9999"!=(t=t.slice(l-3,l+1))&&(s||"4999"!=t)){+t&&(+t.slice(1)||"5"!=t.charAt(0))||(K(n,n.e+x+2,1),e=!n.times(n).eq(o));break}if(!s&&(K(i,i.e+x+2,0),i.times(i).eq(o))){n=i;break}u+=4,l+=4,s=1}return K(n,n.e+x+1,P,e)},O.toExponential=function(e,t){return null!=e&&(y(e,0,p),e++),j(this,e,t,1)},O.toFixed=function(e,t){return null!=e&&(y(e,0,p),e=e+this.e+1),j(this,e,t)},O.toFormat=function(e,t,r){var n,s=this;if(null==r)null!=e&&t&&"object"==typeof t?(r=t,t=null):e&&"object"==typeof e?(r=e,e=t=null):r=B;else if("object"!=typeof r)throw Error(o+"Argument not an object: "+r);if(n=s.toFixed(e,t),s.c){var i,a=n.split("."),l=+r.groupSize,h=+r.secondaryGroupSize,u=r.groupSeparator||"",c=a[0],d=a[1],p=s.s<0,g=p?c.slice(1):c,f=g.length;if(h&&(i=l,l=h,h=i,f-=i),l>0&&f>0){for(i=f%l||l,c=g.substr(0,i);i<f;i+=l)c+=u+g.substr(i,l);h>0&&(c+=u+g.slice(i)),p&&(c="-"+c)}n=d?c+(r.decimalSeparator||"")+((h=+r.fractionGroupSize)?d.replace(new RegExp("\\d{"+h+"}\\B","g"),"$&"+(r.fractionGroupSeparator||"")):d):c}return(r.prefix||"")+n+(r.suffix||"")},O.toFraction=function(e){var t,n,s,i,a,l,u,d,p,g,m,y,E=this,w=E.c;if(null!=e&&(!(u=new G(e)).isInteger()&&(u.c||1!==u.s)||u.lt(I)))throw Error(o+"Argument "+(u.isInteger()?"out of range: ":"not an integer: ")+X(u));if(!w)return new G(E);for(t=new G(I),p=n=new G(I),s=d=new G(I),y=f(w),a=t.e=y.length-E.e-1,t.c[0]=c[(l=a%h)<0?h+l:l],e=!e||u.comparedTo(t)>0?a>0?t:p:u,l=H,H=1/0,u=new G(y),d.c[0]=0;g=r(u,t,0,1),1!=(i=n.plus(g.times(s))).comparedTo(e);)n=s,s=i,p=d.plus(g.times(i=p)),d=i,t=u.minus(g.times(i=t)),u=i;return i=r(e.minus(n),s,0,1),d=d.plus(i.times(p)),n=n.plus(i.times(s)),d.s=p.s=E.s,m=r(p,s,a*=2,P).minus(E).abs().comparedTo(r(d,n,a,P).minus(E).abs())<1?[p,s]:[d,n],H=l,m},O.toNumber=function(){return+X(this)},O.toPrecision=function(e,t){return null!=e&&y(e,1,p),j(this,e,t,2)},O.toString=function(e){var t,r=this,n=r.s,s=r.e;return null===s?n?(t="Infinity",n<0&&(t="-"+t)):t="NaN":(null==e?t=s<=L||s>=D?w(f(r.c),s):C(f(r.c),s,"0"):10===e&&Y?t=C(f((r=K(new G(r),x+s+1,P)).c),r.e,"0"):(y(e,2,W.length,"Base"),t=v(C(f(r.c),s,"0"),10,e,n,!0)),n<0&&r.c[0]&&(t="-"+t)),t},O.valueOf=O.toJSON=function(){return X(this)},O._isBigNumber=!0,null!=t&&G.set(t),G}(),r.default=r.BigNumber=r,e.exports?e.exports=r:(t||(t="undefined"!=typeof self&&self?self:window),t.BigNumber=r)}(h)}(w);var C=w.exports;
/*!
 * Copyright (c) 2017 Benjamin Van Ryseghem<benjamin@vanryseghem.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */const v=y(),R=p(),S=m,T=C,N={trillion:Math.pow(10,12),billion:Math.pow(10,9),million:Math.pow(10,6),thousand:Math.pow(10,3)},M={totalLength:0,characteristic:0,forceAverage:!1,average:!1,mantissa:-1,optionalMantissa:!0,thousandSeparated:!1,spaceSeparated:!1,negative:"sign",forceSign:!1,roundingFunction:Math.round,spaceSeparatedAbbreviation:!1},{binarySuffixes:_,decimalSuffixes:b}=v.currentBytes(),A={general:{scale:1024,suffixes:b,marker:"bd"},binary:{scale:1024,suffixes:_,marker:"b"},decimal:{scale:1e3,suffixes:b,marker:"d"}};function O(e,t={},r){if("string"==typeof t&&(t=S.parseFormat(t)),!R.validateFormat(t))return"ERROR: invalid format";let n=t.prefix||"",s=t.postfix||"",i=function(e,t,r){switch(t.output){case"currency":return function(e,t,r){const n=r.currentCurrency();let s,i=Object.assign({},t),o=Object.assign({},M,i),a="",l=!!o.totalLength||!!o.forceAverage||o.average,h=i.currencyPosition||n.position,u=i.currencySymbol||n.symbol;const c=void 0!==o.spaceSeparatedCurrency?o.spaceSeparatedCurrency:o.spaceSeparated;void 0===i.lowPrecision&&(i.lowPrecision=!1);c&&(a=" ");"infix"===h&&(s=a+u+a);let d=L({instance:e,providedFormat:i,state:r,decimalSeparator:s});"prefix"===h&&(d=e._value<0&&"sign"===o.negative?`-${a}${u}${d.slice(1)}`:e._value>0&&o.forceSign?`+${a}${u}${d.slice(1)}`:u+a+d);h&&"postfix"!==h||(a=!o.spaceSeparatedAbbreviation&&l?"":a,d=d+a+u);return d}(e,t=D(t,v.currentCurrencyDefaultFormat()),v);case"percent":return function(e,t,r,n){let s=t.prefixSymbol,i=L({instance:n(100*e._value),providedFormat:t,state:r}),o=Object.assign({},M,t);if(s)return`%${o.spaceSeparated?" ":""}${i}`;return`${i}${o.spaceSeparated?" ":""}%`}(e,t=D(t,v.currentPercentageDefaultFormat()),v,r);case"byte":return function(e,t,r,n){let s=t.base||"binary",i=Object.assign({},M,t);const{binarySuffixes:o,decimalSuffixes:a}=r.currentBytes();let l={general:{scale:1024,suffixes:a||b,marker:"bd"},binary:{scale:1024,suffixes:o||_,marker:"b"},decimal:{scale:1e3,suffixes:a||b,marker:"d"}}[s],{value:h,suffix:u}=I(e._value,l.suffixes,l.scale),c=L({instance:n(h),providedFormat:t,state:r,defaults:r.currentByteDefaultFormat()});return`${c}${i.spaceSeparated?" ":""}${u}`}(e,t=D(t,v.currentByteDefaultFormat()),v,r);case"time":return t=D(t,v.currentTimeDefaultFormat()),function(e){let t=Math.floor(e._value/60/60),r=Math.floor((e._value-60*t*60)/60),n=Math.round(e._value-60*t*60-60*r);return`${t}:${r<10?"0":""}${r}:${n<10?"0":""}${n}`}(e);case"ordinal":return function(e,t,r){let n=r.currentOrdinal(),s=Object.assign({},M,t),i=L({instance:e,providedFormat:t,state:r}),o=n(e._value);return`${i}${s.spaceSeparated?" ":""}${o}`}(e,t=D(t,v.currentOrdinalDefaultFormat()),v);default:return L({instance:e,providedFormat:t,numbro:r})}}(e,t,r);return i=function(e,t){return t+e}(i,n),i=function(e,t){return e+t}(i,s),i}function I(e,t,r){let n=t[0],s=Math.abs(e);if(s>=r){for(let i=1;i<t.length;++i){let o=Math.pow(r,i),a=Math.pow(r,i+1);if(s>=o&&s<a){n=t[i],e/=o;break}}n===t[0]&&(e/=Math.pow(r,t.length-1),n=t[t.length-1])}return{value:e,suffix:n}}function x(e){let t="";for(let r=0;r<e;r++)t+="0";return t}function P(e,t,r=Math.round){if(-1!==e.toString().indexOf("e"))return function(e,t){let r=e.toString(),[n,s]=r.split("e"),[i,o=""]=n.split(".");if(+s>0)r=i+o+x(s-o.length);else{let e=".";e=+i<0?`-0${e}`:`0${e}`;let n=(x(-s-1)+Math.abs(i)+o).substr(0,t);n.length<t&&(n+=x(t-n.length)),r=e+n}return+s>0&&t>0&&(r+=`.${x(t)}`),r}(e,t);return new T(r(+`${e}e+${t}`)/Math.pow(10,t)).toFixed(t)}function L({instance:e,providedFormat:t,state:r=v,decimalSeparator:n,defaults:s=r.currentDefaults()}){let i=e._value;if(0===i&&r.hasZeroFormat())return r.getZeroFormat();if(!isFinite(i))return i.toString();let o=Object.assign({},M,s,t),a=o.totalLength,l=a?0:o.characteristic,h=o.optionalCharacteristic,u=o.forceAverage,c=o.lowPrecision,d=!!a||!!u||o.average,p=a?-1:d&&void 0===t.mantissa?0:o.mantissa,g=!a&&(void 0===t.optionalMantissa?-1===p:o.optionalMantissa),f=o.trimMantissa,m=o.thousandSeparated,y=o.spaceSeparated,E=o.negative,w=o.forceSign,C=o.exponential,R=o.roundingFunction,S="";if(d){let e=function({value:e,forceAverage:t,lowPrecision:r=!0,abbreviations:n,spaceSeparated:s=!1,totalLength:i=0,roundingFunction:o=Math.round}){let a="",l=Math.abs(e),h=-1;if(t&&n[t]&&N[t]?(a=n[t],e/=N[t]):l>=N.trillion||r&&1===o(l/N.trillion)?(a=n.trillion,e/=N.trillion):l<N.trillion&&l>=N.billion||r&&1===o(l/N.billion)?(a=n.billion,e/=N.billion):l<N.billion&&l>=N.million||r&&1===o(l/N.million)?(a=n.million,e/=N.million):(l<N.million&&l>=N.thousand||r&&1===o(l/N.thousand))&&(a=n.thousand,e/=N.thousand),a&&(a=(s?" ":"")+a),i){let t=e<0,r=e.toString().split(".")[0],n=t?r.length-1:r.length;h=Math.max(i-n,0)}return{value:e,abbreviation:a,mantissaPrecision:h}}({value:i,forceAverage:u,lowPrecision:c,abbreviations:r.currentAbbreviations(),spaceSeparated:y,roundingFunction:R,totalLength:a});i=e.value,S+=e.abbreviation,a&&(p=e.mantissaPrecision)}if(C){let e=function({value:e,characteristicPrecision:t}){let[r,n]=e.toExponential().split("e"),s=+r;return t?(1<t&&(s*=Math.pow(10,t-1),n=+n-(t-1),n=n>=0?`+${n}`:n),{value:s,abbreviation:`e${n}`}):{value:s,abbreviation:`e${n}`}}({value:i,characteristicPrecision:l});i=e.value,S=e.abbreviation+S}let T=function(e,t,r,n,s,i){if(-1===n)return e;let o=P(t,n,i),[a,l=""]=o.toString().split(".");if(l.match(/^0+$/)&&(r||s))return a;let h=l.match(/0+$/);return s&&h?`${a}.${l.toString().slice(0,h.index)}`:o.toString()}(i.toString(),i,g,p,f,R);return T=function(e,t,r,n){let s=e,[i,o]=s.toString().split(".");if(i.match(/^-?0$/)&&r)return o?`${i.replace("0","")}.${o}`:i.replace("0","");const a=t<0&&0===i.indexOf("-");if(a&&(i=i.slice(1),s=s.slice(1)),i.length<n){let e=n-i.length;for(let t=0;t<e;t++)s=`0${s}`}return a&&(s=`-${s}`),s.toString()}(T,i,h,l),T=function(e,t,r,n,s){let i=n.currentDelimiters(),o=i.thousands;s=s||i.decimal;let a=i.thousandsSize||3,l=e.toString(),h=l.split(".")[0],u=l.split(".")[1];const c=t<0&&0===h.indexOf("-");if(r){c&&(h=h.slice(1));let e=function(e,t){let r=[],n=0;for(let s=e;s>0;s--)n===t&&(r.unshift(s),n=0),n++;return r}(h.length,a);e.forEach(((e,t)=>{h=h.slice(0,e+t)+o+h.slice(e+t)})),c&&(h=`-${h}`)}return l=u?h+s+u:h,l}(T,i,m,r,n),(d||C)&&(T=function(e,t){return e+t}(T,S)),(w||i<0)&&(T=function(e,t,r){return 0===t?e:0==+e?e.replace("-",""):t>0?`+${e}`:"sign"===r?e:`(${e.replace("-","")})`}(T,i,E)),T}function D(e,t){if(!e)return t;let r=Object.keys(e);return 1===r.length&&"output"===r[0]?t:e}
/*!
 * Copyright (c) 2017 Benjamin Van Ryseghem<benjamin@vanryseghem.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
const k=C;function H(e,t,r){let n=new k(e._value),s=t;return r.isNumbro(t)&&(s=t._value),s=new k(s),e._value=n.minus(s).toNumber(),e}
/*!
 * Copyright (c) 2017 Benjamin Van Ryseghem<benjamin@vanryseghem.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
const F=y(),U=p(),V=(e=>({loadLanguagesInNode:t=>E(t,e)}))($),B=d();let W=(e=>({format:(...t)=>O(...t,e),getByteUnit:(...t)=>function(e){let t=A.general;return I(e._value,t.suffixes,t.scale).suffix}(...t,e),getBinaryByteUnit:(...t)=>function(e){let t=A.binary;return I(e._value,t.suffixes,t.scale).suffix}(...t,e),getDecimalByteUnit:(...t)=>function(e){let t=A.decimal;return I(e._value,t.suffixes,t.scale).suffix}(...t,e),formatOrDefault:D}))($),Y=(e=>({add:(t,r)=>function(e,t,r){let n=new k(e._value),s=t;return r.isNumbro(t)&&(s=t._value),s=new k(s),e._value=n.plus(s).toNumber(),e}(t,r,e),subtract:(t,r)=>H(t,r,e),multiply:(t,r)=>function(e,t,r){let n=new k(e._value),s=t;return r.isNumbro(t)&&(s=t._value),s=new k(s),e._value=n.times(s).toNumber(),e}(t,r,e),divide:(t,r)=>function(e,t,r){let n=new k(e._value),s=t;return r.isNumbro(t)&&(s=t._value),s=new k(s),e._value=n.dividedBy(s).toNumber(),e}(t,r,e),set:(t,r)=>function(e,t,r){let n=t;return r.isNumbro(t)&&(n=t._value),e._value=n,e}(t,r,e),difference:(t,r)=>function(e,t,r){let n=r(e._value);return H(n,t,r),Math.abs(n._value)}(t,r,e),BigNumber:k}))($);const G=m;class j{constructor(e){this._value=e}clone(){return $(this._value)}format(e={}){return W.format(this,e)}formatCurrency(e){return"string"==typeof e&&(e=G.parseFormat(e)),(e=W.formatOrDefault(e,F.currentCurrencyDefaultFormat())).output="currency",W.format(this,e)}formatTime(e={}){return e.output="time",W.format(this,e)}binaryByteUnits(){return W.getBinaryByteUnit(this)}decimalByteUnits(){return W.getDecimalByteUnit(this)}byteUnits(){return W.getByteUnit(this)}difference(e){return Y.difference(this,e)}add(e){return Y.add(this,e)}subtract(e){return Y.subtract(this,e)}multiply(e){return Y.multiply(this,e)}divide(e){return Y.divide(this,e)}set(e){return Y.set(this,z(e))}value(){return this._value}valueOf(){return this._value}}function z(e){let t=e;return $.isNumbro(e)?t=e._value:"string"==typeof e?t=$.unformat(e):isNaN(e)&&(t=NaN),t}function $(e){return new j(z(e))}$.version="2.5.0",$.isNumbro=function(e){return e instanceof j},$.language=F.currentLanguage,$.registerLanguage=F.registerLanguage,$.setLanguage=F.setLanguage,$.languages=F.languages,$.languageData=F.languageData,$.zeroFormat=F.setZeroFormat,$.defaultFormat=F.currentDefaults,$.setDefaults=F.setDefaults,$.defaultCurrencyFormat=F.currentCurrencyDefaultFormat,$.validate=U.validate,$.loadLanguagesInNode=V.loadLanguagesInNode,$.unformat=B.unformat,$.BigNumber=Y.BigNumber;var K=u($);window.numbro=r(80586).default},35358:(e,t,r)=>{var n={"./af":37086,"./af.js":37086,"./ar":73762,"./ar-dz":17289,"./ar-dz.js":17289,"./ar-kw":65145,"./ar-kw.js":65145,"./ar-ly":70872,"./ar-ly.js":70872,"./ar-ma":66569,"./ar-ma.js":66569,"./ar-ps":90470,"./ar-ps.js":90470,"./ar-sa":25819,"./ar-sa.js":25819,"./ar-tn":39685,"./ar-tn.js":39685,"./ar.js":73762,"./az":38906,"./az.js":38906,"./be":22956,"./be.js":22956,"./bg":11414,"./bg.js":11414,"./bm":42516,"./bm.js":42516,"./bn":63933,"./bn-bd":49888,"./bn-bd.js":49888,"./bn.js":63933,"./bo":30718,"./bo.js":30718,"./br":44169,"./br.js":44169,"./bs":96954,"./bs.js":96954,"./ca":97417,"./ca.js":97417,"./cs":97527,"./cs.js":97527,"./cv":92556,"./cv.js":92556,"./cy":67105,"./cy.js":67105,"./da":14130,"./da.js":14130,"./de":21918,"./de-at":18158,"./de-at.js":18158,"./de-ch":98952,"./de-ch.js":98952,"./de.js":21918,"./dv":53611,"./dv.js":53611,"./el":25496,"./el.js":25496,"./en-au":28809,"./en-au.js":28809,"./en-ca":7275,"./en-ca.js":7275,"./en-gb":57306,"./en-gb.js":57306,"./en-ie":2609,"./en-ie.js":2609,"./en-il":82970,"./en-il.js":82970,"./en-in":46192,"./en-in.js":46192,"./en-nz":20851,"./en-nz.js":20851,"./en-sg":97953,"./en-sg.js":97953,"./eo":5137,"./eo.js":5137,"./es":18741,"./es-do":30147,"./es-do.js":30147,"./es-mx":49999,"./es-mx.js":49999,"./es-us":17778,"./es-us.js":17778,"./es.js":18741,"./et":75712,"./et.js":75712,"./eu":65431,"./eu.js":65431,"./fa":61716,"./fa.js":61716,"./fi":61388,"./fi.js":61388,"./fil":7858,"./fil.js":7858,"./fo":89098,"./fo.js":89098,"./fr":72237,"./fr-ca":55218,"./fr-ca.js":55218,"./fr-ch":58713,"./fr-ch.js":58713,"./fr.js":72237,"./fy":31260,"./fy.js":31260,"./ga":25485,"./ga.js":25485,"./gd":39842,"./gd.js":39842,"./gl":4986,"./gl.js":4986,"./gom-deva":18691,"./gom-deva.js":18691,"./gom-latn":87812,"./gom-latn.js":87812,"./gu":28833,"./gu.js":28833,"./he":63434,"./he.js":63434,"./hi":24254,"./hi.js":24254,"./hr":87235,"./hr.js":87235,"./hu":26074,"./hu.js":26074,"./hy-am":63237,"./hy-am.js":63237,"./id":58844,"./id.js":58844,"./is":86937,"./is.js":86937,"./it":5324,"./it-ch":4566,"./it-ch.js":4566,"./it.js":5324,"./ja":38728,"./ja.js":38728,"./jv":49165,"./jv.js":49165,"./ka":17905,"./ka.js":17905,"./kk":82759,"./kk.js":82759,"./km":7525,"./km.js":7525,"./kn":77788,"./kn.js":77788,"./ko":59427,"./ko.js":59427,"./ku":88029,"./ku-kmr":92022,"./ku-kmr.js":92022,"./ku.js":88029,"./ky":5881,"./ky.js":5881,"./lb":60039,"./lb.js":60039,"./lo":45284,"./lo.js":45284,"./lt":5909,"./lt.js":5909,"./lv":47891,"./lv.js":47891,"./me":52047,"./me.js":52047,"./mi":4163,"./mi.js":4163,"./mk":47301,"./mk.js":47301,"./ml":46800,"./ml.js":46800,"./mn":84122,"./mn.js":84122,"./mr":17886,"./mr.js":17886,"./ms":51101,"./ms-my":11680,"./ms-my.js":11680,"./ms.js":51101,"./mt":70888,"./mt.js":70888,"./my":18227,"./my.js":18227,"./nb":78629,"./nb.js":78629,"./ne":12304,"./ne.js":12304,"./nl":40847,"./nl-be":45745,"./nl-be.js":45745,"./nl.js":40847,"./nn":11249,"./nn.js":11249,"./oc-lnc":45617,"./oc-lnc.js":45617,"./pa-in":24532,"./pa-in.js":24532,"./pl":51001,"./pl.js":51001,"./pt":43793,"./pt-br":77498,"./pt-br.js":77498,"./pt.js":43793,"./ro":95758,"./ro.js":95758,"./ru":34220,"./ru.js":34220,"./sd":34646,"./sd.js":34646,"./se":26709,"./se.js":26709,"./si":37089,"./si.js":37089,"./sk":18271,"./sk.js":18271,"./sl":11422,"./sl.js":11422,"./sq":67401,"./sq.js":67401,"./sr":17040,"./sr-cyrl":65775,"./sr-cyrl.js":65775,"./sr.js":17040,"./ss":40263,"./ss.js":40263,"./sv":92764,"./sv.js":92764,"./sw":74403,"./sw.js":74403,"./ta":65026,"./ta.js":65026,"./te":58830,"./te.js":58830,"./tet":4048,"./tet.js":4048,"./tg":86436,"./tg.js":86436,"./th":18505,"./th.js":18505,"./tk":33968,"./tk.js":33968,"./tl-ph":63422,"./tl-ph.js":63422,"./tlh":45441,"./tlh.js":45441,"./tr":92671,"./tr.js":92671,"./tzl":4659,"./tzl.js":4659,"./tzm":80204,"./tzm-latn":67956,"./tzm-latn.js":67956,"./tzm.js":80204,"./ug-cn":65191,"./ug-cn.js":65191,"./uk":21949,"./uk.js":21949,"./ur":23174,"./ur.js":23174,"./uz":26158,"./uz-latn":19286,"./uz-latn.js":19286,"./uz.js":26158,"./vi":12284,"./vi.js":12284,"./x-pseudo":14912,"./x-pseudo.js":14912,"./yo":59357,"./yo.js":59357,"./zh-cn":1313,"./zh-cn.js":1313,"./zh-hk":73021,"./zh-hk.js":73021,"./zh-mo":21312,"./zh-mo.js":21312,"./zh-tw":16629,"./zh-tw.js":16629};function s(e){var t=i(e);return r(t)}function i(e){if(!r.o(n,e)){var t=new Error("Cannot find module '"+e+"'");throw t.code="MODULE_NOT_FOUND",t}return n[e]}s.keys=function(){return Object.keys(n)},s.resolve=i,e.exports=s,s.id=35358},72679:(e,t)=>{"use strict";t.__esModule=!0,t.parse=function(e){const t=[[""]];if(0===e.length)return t;let i,o=0,a=0;for(;e.length>0&&i!==e.length;)if(i=e.length,e.match(s))e=e.replace(s,""),o+=1,t[a][o]="";else if(e.match(r))e=e.replace(r,""),o=0,a+=1,t[a]=[""];else{let r="";if(e.startsWith('"')){let t=0,n=!0;for(;n;){const s=e.slice(0,1);'"'===s&&(t+=1),r+=s,(0===(e=e.slice(1)).length||e.match(/^[\t\r\n]/)&&t%2==0)&&(n=!1)}r=r.replace(/^"/,"").replace(/"$/,"").replace(/["]*/g,(e=>new Array(Math.floor(e.length/2)).fill('"').join("")))}else{const t=e.match(n);r=t?t[0]:"",e=e.slice(r.length)}t[a][o]=r}return t},t.stringify=function(e){let t,r,n,s,i,o="";for(t=0,r=e.length;t<r;t+=1){for(s=e[t].length,n=0;n<s;n+=1)n>0&&(o+="\t"),i=e[t][n],"string"==typeof i?i.indexOf("\n")>-1?o+=`"${i.replace(/"/g,'""')}"`:o+=i:o+=null==i?"":i;t!==r-1&&(o+="\n")}return o};const r=/^(\r\n|\n\r|\r|\n)/,n=/^[^\t\r\n]+/,s=/^\t/},42354:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(72679);t.parse=n.parse,t.stringify=n.stringify},60512:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(95913),r(12587);var s=n(r(85707));t.FullyVisibleColumnsCalculationType=class{constructor(){(0,s.default)(this,"count",0),(0,s.default)(this,"startColumn",null),(0,s.default)(this,"endColumn",null),(0,s.default)(this,"startPosition",null),(0,s.default)(this,"isVisibleInTrimmingContainer",!1)}initialize(){}process(e,t){const{totalCalculatedWidth:r,zeroBasedScrollOffset:n,viewportWidth:s,columnWidth:i}=t;r>=n&&r+i<=n+(n>0?s+1:s)&&(null!==this.startColumn&&void 0!==this.startColumn||(this.startColumn=e),this.endColumn=e)}finalize(e){var t;const{scrollOffset:r,viewportWidth:n,inlineStartOffset:s,zeroBasedScrollOffset:i,totalColumns:o,needReverse:a,startPositions:l,columnWidth:h}=e;if(this.endColumn===o-1&&a)for(this.startColumn=this.endColumn;this.startColumn>0;){const e=l[this.endColumn]+h-l[this.startColumn-1];if(e<=n&&(this.startColumn-=1),e>=n)break}this.startPosition=null!==(t=l[this.startColumn])&&void 0!==t?t:null;const u=r+n-(i>0?n+1:n),c=null===this.startColumn?0:e.getColumnWidth(this.startColumn);u<-1*s||r>l.at(-1)||-1*r-n>-1*c?this.isVisibleInTrimmingContainer=!1:this.isVisibleInTrimmingContainer=!0,o<this.endColumn&&(this.endColumn=o-1),null!==this.startColumn&&(this.count=this.endColumn-this.startColumn+1)}}},71782:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(95913),r(12587);var s=n(r(85707));t.FullyVisibleRowsCalculationType=class{constructor(){(0,s.default)(this,"count",0),(0,s.default)(this,"startRow",null),(0,s.default)(this,"endRow",null),(0,s.default)(this,"startPosition",null),(0,s.default)(this,"isVisibleInTrimmingContainer",!1)}initialize(){}process(e,t){const{totalCalculatedHeight:r,zeroBasedScrollOffset:n,innerViewportHeight:s,rowHeight:i}=t;r>=n&&r+i<=s&&(null===this.startRow&&(this.startRow=e),this.endRow=e)}finalize(e){var t;const{scrollOffset:r,viewportHeight:n,horizontalScrollbarHeight:s,totalRows:i,needReverse:o,startPositions:a,rowHeight:l}=e;if(this.endRow===i-1&&o)for(this.startRow=this.endRow;this.startRow>0;){const e=a[this.endRow]+l-a[this.startRow-1];if(e<=n-s&&(this.startRow-=1),e>=n-s)break}this.startPosition=null!==(t=a[this.startRow])&&void 0!==t?t:null;r+n-s<(null===this.startRow?0:e.getRowHeight(this.startRow))||r>a.at(-1)?this.isVisibleInTrimmingContainer=!1:this.isVisibleInTrimmingContainer=!0,i<this.endRow&&(this.endRow=i-1),null!==this.startRow&&(this.count=this.endRow-this.startRow+1)}}},48454:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(95913),r(12587);var s=n(r(85707));t.PartiallyVisibleColumnsCalculationType=class{constructor(){(0,s.default)(this,"count",0),(0,s.default)(this,"startColumn",null),(0,s.default)(this,"endColumn",null),(0,s.default)(this,"startPosition",null),(0,s.default)(this,"isVisibleInTrimmingContainer",!1)}initialize(){}process(e,t){const{totalCalculatedWidth:r,zeroBasedScrollOffset:n,viewportWidth:s}=t;r<=n&&(this.startColumn=e);r>=n&&r<=n+(n>0?s+1:s)&&(null!==this.startColumn&&void 0!==this.startColumn||(this.startColumn=e)),this.endColumn=e}finalize(e){var t;const{scrollOffset:r,viewportWidth:n,inlineStartOffset:s,zeroBasedScrollOffset:i,totalColumns:o,needReverse:a,startPositions:l,columnWidth:h}=e;if(this.endColumn===o-1&&a)for(this.startColumn=this.endColumn;this.startColumn>0;){const e=l[this.endColumn]+h-l[this.startColumn-1];if(this.startColumn-=1,e>n)break}this.startPosition=null!==(t=l[this.startColumn])&&void 0!==t?t:null;r+n-(i>0?n+1:n)<-1*s||r>l.at(-1)+h||-1*r-n>0?this.isVisibleInTrimmingContainer=!1:this.isVisibleInTrimmingContainer=!0,o<this.endColumn&&(this.endColumn=o-1),null!==this.startColumn&&(this.count=this.endColumn-this.startColumn+1)}}},22488:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(95913),r(12587);var s=n(r(85707));t.PartiallyVisibleRowsCalculationType=class{constructor(){(0,s.default)(this,"count",0),(0,s.default)(this,"startRow",null),(0,s.default)(this,"endRow",null),(0,s.default)(this,"startPosition",null),(0,s.default)(this,"isVisibleInTrimmingContainer",!1)}initialize(){}process(e,t){const{totalCalculatedHeight:r,zeroBasedScrollOffset:n,innerViewportHeight:s}=t;r<=n&&(this.startRow=e),r>=n&&r<=s&&null===this.startRow&&(this.startRow=e),this.endRow=e}finalize(e){var t;const{scrollOffset:r,viewportHeight:n,horizontalScrollbarHeight:s,totalRows:i,needReverse:o,startPositions:a,rowHeight:l}=e;if(this.endRow===i-1&&o)for(this.startRow=this.endRow;this.startRow>0;){const e=a[this.endRow]+l-a[this.startRow-1];if(this.startRow-=1,e>=n-s)break}this.startPosition=null!==(t=a[this.startRow])&&void 0!==t?t:null;r+n-s<0||r>a.at(-1)+l?this.isVisibleInTrimmingContainer=!1:this.isVisibleInTrimmingContainer=!0,i<this.endRow&&(this.endRow=i-1),null!==this.startRow&&(this.count=this.endRow-this.startRow+1)}}},24746:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.RenderedAllColumnsCalculationType=class{constructor(){(0,s.default)(this,"count",0),(0,s.default)(this,"startColumn",0),(0,s.default)(this,"endColumn",0),(0,s.default)(this,"startPosition",0),(0,s.default)(this,"isVisibleInTrimmingContainer",!0)}initialize(e){let{totalColumns:t}=e;this.count=t,this.endColumn=this.count-1}process(){}finalize(){}}},74892:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.RenderedAllRowsCalculationType=class{constructor(){(0,s.default)(this,"count",0),(0,s.default)(this,"startRow",0),(0,s.default)(this,"endRow",0),(0,s.default)(this,"startPosition",0),(0,s.default)(this,"isVisibleInTrimmingContainer",!0)}initialize(e){let{totalRows:t}=e;this.count=t,this.endRow=this.count-1}process(){}finalize(){}}},2069:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),i=r(48454);class o extends i.PartiallyVisibleColumnsCalculationType{constructor(){super(...arguments),(0,s.default)(this,"columnStartOffset",0),(0,s.default)(this,"columnEndOffset",0)}finalize(e){var t;super.finalize(e);const{overrideFn:r,totalColumns:n,startPositions:s}=e;if(null!==this.startColumn&&"function"==typeof r){const e=this.startColumn,t=this.endColumn;r(this),this.columnStartOffset=e-this.startColumn,this.columnEndOffset=this.endColumn-t}this.startColumn<0&&(this.startColumn=0),this.startPosition=null!==(t=s[this.startColumn])&&void 0!==t?t:null,n<this.endColumn&&(this.endColumn=n-1),null!==this.startColumn&&(this.count=this.endColumn-this.startColumn+1)}}t.RenderedColumnsCalculationType=o},79221:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),i=r(22488);class o extends i.PartiallyVisibleRowsCalculationType{constructor(){super(...arguments),(0,s.default)(this,"rowStartOffset",0),(0,s.default)(this,"rowEndOffset",0)}finalize(e){var t;super.finalize(e);const{overrideFn:r,totalRows:n,startPositions:s}=e;if(null!==this.startRow&&"function"==typeof r){const e=this.startRow,t=this.endRow;r(this),this.rowStartOffset=e-this.startRow,this.rowEndOffset=this.endRow-t}this.startRow<0&&(this.startRow=0),this.startPosition=null!==(t=s[this.startRow])&&void 0!==t?t:null,n<this.endRow&&(this.endRow=n-1),null!==this.startRow&&(this.count=this.endRow-this.startRow+1)}}t.RenderedRowsCalculationType=o},63059:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(60512);t.FullyVisibleColumnsCalculationType=n.FullyVisibleColumnsCalculationType;var s=r(71782);t.FullyVisibleRowsCalculationType=s.FullyVisibleRowsCalculationType;var i=r(48454);t.PartiallyVisibleColumnsCalculationType=i.PartiallyVisibleColumnsCalculationType;var o=r(22488);t.PartiallyVisibleRowsCalculationType=o.PartiallyVisibleRowsCalculationType;var a=r(24746);t.RenderedAllColumnsCalculationType=a.RenderedAllColumnsCalculationType;var l=r(74892);t.RenderedAllRowsCalculationType=l.RenderedAllRowsCalculationType;var h=r(2069);t.RenderedColumnsCalculationType=h.RenderedColumnsCalculationType;var u=r(79221);t.RenderedRowsCalculationType=u.RenderedRowsCalculationType;var c=r(83786);t.ViewportColumnsCalculator=c.ViewportColumnsCalculator,t.DEFAULT_COLUMN_WIDTH=c.DEFAULT_WIDTH;var d=r(7628);t.ViewportRowsCalculator=d.ViewportRowsCalculator},83820:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(14846),r(69655);var s=n(r(85707));t.ViewportBaseCalculator=class{constructor(e){(0,s.default)(this,"calculationTypes",[]),(0,s.default)(this,"calculationResults",new Map),this.calculationTypes=e}_initialize(e){this.calculationTypes.forEach((t=>{let[r,n]=t;this.calculationResults.set(r,n),n.initialize(e)}))}_process(e,t){this.calculationTypes.forEach((r=>{let[,n]=r;return n.process(e,t)}))}_finalize(e){this.calculationTypes.forEach((t=>{let[,r]=t;return r.finalize(e)}))}getResultsFor(e){return this.calculationResults.get(e)}}},83786:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724);var s=n(r(85707)),i=r(83820);const o=t.DEFAULT_WIDTH=50;class a extends i.ViewportBaseCalculator{constructor(e){let{calculationTypes:t,viewportWidth:r,scrollOffset:n,totalColumns:i,columnWidthFn:o,overrideFn:a,inlineStartOffset:l}=e;super(t),(0,s.default)(this,"viewportWidth",0),(0,s.default)(this,"scrollOffset",0),(0,s.default)(this,"zeroBasedScrollOffset",0),(0,s.default)(this,"totalColumns",0),(0,s.default)(this,"columnWidthFn",null),(0,s.default)(this,"columnWidth",0),(0,s.default)(this,"overrideFn",null),(0,s.default)(this,"inlineStartOffset",0),(0,s.default)(this,"totalCalculatedWidth",0),(0,s.default)(this,"startPositions",[]),(0,s.default)(this,"needReverse",!0),this.viewportWidth=r,this.scrollOffset=n,this.zeroBasedScrollOffset=Math.max(n,0),this.totalColumns=i,this.columnWidthFn=o,this.overrideFn=a,this.inlineStartOffset=l,this.calculate()}calculate(){this._initialize(this);for(let e=0;e<this.totalColumns;e++)if(this.columnWidth=this.getColumnWidth(e),this._process(e,this),this.startPositions.push(this.totalCalculatedWidth),this.totalCalculatedWidth+=this.columnWidth,this.totalCalculatedWidth>=this.zeroBasedScrollOffset+this.viewportWidth){this.needReverse=!1;break}this._finalize(this)}getColumnWidth(e){const t=this.columnWidthFn(e);return isNaN(t)?o:t}}t.ViewportColumnsCalculator=a},7628:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724);var s=n(r(85707)),i=r(83820);class o extends i.ViewportBaseCalculator{constructor(e){let{calculationTypes:t,viewportHeight:r,scrollOffset:n,totalRows:i,defaultRowHeight:o,rowHeightFn:a,overrideFn:l,horizontalScrollbarHeight:h}=e;super(t),(0,s.default)(this,"viewportHeight",0),(0,s.default)(this,"scrollOffset",0),(0,s.default)(this,"zeroBasedScrollOffset",0),(0,s.default)(this,"totalRows",0),(0,s.default)(this,"rowHeightFn",null),(0,s.default)(this,"rowHeight",0),(0,s.default)(this,"overrideFn",null),(0,s.default)(this,"horizontalScrollbarHeight",0),(0,s.default)(this,"innerViewportHeight",0),(0,s.default)(this,"totalCalculatedHeight",0),(0,s.default)(this,"startPositions",[]),(0,s.default)(this,"needReverse",!0),this.defaultHeight=o,this.viewportHeight=r,this.scrollOffset=n,this.zeroBasedScrollOffset=Math.max(n,0),this.totalRows=i,this.rowHeightFn=a,this.overrideFn=l,this.horizontalScrollbarHeight=null!=h?h:0,this.innerViewportHeight=this.zeroBasedScrollOffset+this.viewportHeight-this.horizontalScrollbarHeight,this.calculate()}calculate(){this._initialize(this);for(let e=0;e<this.totalRows;e++)if(this.rowHeight=this.getRowHeight(e),this._process(e,this),this.startPositions.push(this.totalCalculatedHeight),this.totalCalculatedHeight+=this.rowHeight,this.totalCalculatedHeight>=this.innerViewportHeight){this.needReverse=!1;break}this._finalize(this)}getRowHeight(e){const t=this.rowHeightFn(e);return isNaN(t)?this.defaultHeight:t}}t.ViewportRowsCalculator=o},2141:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707));function i(e,t,r){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,r)}function o(e,t){return e.get(l(e,t))}function a(e,t,r){return e.set(l(e,t),r),r}function l(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var h=new WeakMap;class u{constructor(e,t){let r=arguments.length>2&&void 0!==arguments[2]&&arguments[2];(0,s.default)(this,"row",null),(0,s.default)(this,"col",null),i(this,h,!1),a(h,this,r),void 0!==e&&void 0!==t&&(this.row=e,this.col=t)}isValid(e){const{countRows:t,countCols:r,countRowHeaders:n,countColHeaders:s}={countRows:0,countCols:0,countRowHeaders:0,countColHeaders:0,...e};return!(!Number.isInteger(this.row)||!Number.isInteger(this.col))&&(!(this.row<-s||this.col<-n)&&!(this.row>=t||this.col>=r))}isEqual(e){return e===this||this.row===e.row&&this.col===e.col}isHeader(){return!this.isCell()}isCell(){return this.row>=0&&this.col>=0}isRtl(){return o(h,this)}isSouthEastOf(e){return this.row>=e.row&&(o(h,this)?this.col<=e.col:this.col>=e.col)}isNorthWestOf(e){return this.row<=e.row&&(o(h,this)?this.col>=e.col:this.col<=e.col)}isSouthWestOf(e){return this.row>=e.row&&(o(h,this)?this.col>=e.col:this.col<=e.col)}isNorthEastOf(e){return this.row<=e.row&&(o(h,this)?this.col<=e.col:this.col>=e.col)}normalize(){return this.row=null===this.row?this.row:Math.max(this.row,0),this.col=null===this.col?this.col:Math.max(this.col,0),this}assign(e){return Number.isInteger(null==e?void 0:e.row)&&(this.row=e.row),Number.isInteger(null==e?void 0:e.col)&&(this.col=e.col),e instanceof u&&a(h,this,e.isRtl()),this}clone(){return new u(this.row,this.col,o(h,this))}toObject(){return{row:this.row,col:this.col}}}t.default=u},16818:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724);var s=n(r(85707)),i=n(r(2141));function o(e,t,r){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,r)}function a(e,t){return e.get(l(e,t))}function l(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var h=new WeakMap;class u{constructor(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:e,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:e,n=arguments.length>3&&void 0!==arguments[3]&&arguments[3];var i,a,u;(0,s.default)(this,"highlight",null),(0,s.default)(this,"from",null),(0,s.default)(this,"to",null),o(this,h,!1),this.highlight=e.clone(),this.from=t.clone(),this.to=r.clone(),a=this,u=n,(i=h).set(l(i,a),u)}setHighlight(e){return this.highlight=e.clone(),this}setFrom(e){return this.from=e.clone(),this}setTo(e){return this.to=e.clone(),this}isValid(e){return this.from.isValid(e)&&this.to.isValid(e)}isSingle(){return this.isSingleCell()||this.isSingleHeader()}isSingleCell(){return this.from.row>=0&&this.from.row===this.to.row&&this.from.col>=0&&this.from.col===this.to.col}isSingleHeader(){return(this.from.row<0||this.from.col<0)&&this.from.row===this.to.row&&this.from.col===this.to.col}isHeader(){return!(!this.from.isHeader()||!this.to.isHeader())||(this.from.col<0&&this.to.col<0||this.from.row<0&&this.to.row<0)}containsHeaders(){return this.from.isHeader()||this.to.isHeader()}getOuterHeight(){return Math.max(this.from.row,this.to.row)-Math.min(this.from.row,this.to.row)+1}getOuterWidth(){return Math.max(this.from.col,this.to.col)-Math.min(this.from.col,this.to.col)+1}getHeight(){if(this.from.row<0&&this.to.row<0)return 0;const e=Math.max(this.from.row,0),t=Math.max(this.to.row,0);return Math.max(e,t)-Math.min(e,t)+1}getWidth(){if(this.from.col<0&&this.to.col<0)return 0;const e=Math.max(this.from.col,0),t=Math.max(this.to.col,0);return Math.max(e,t)-Math.min(e,t)+1}getCellsCount(){return this.getWidth()*this.getHeight()}includes(e){const{row:t,col:r}=e,n=this.getOuterTopStartCorner(),s=this.getOuterBottomEndCorner();return n.row<=t&&s.row>=t&&n.col<=r&&s.col>=r}includesRange(e){return this.includes(e.getOuterTopStartCorner())&&this.includes(e.getOuterBottomEndCorner())}isEqual(e){return Math.min(this.from.row,this.to.row)===Math.min(e.from.row,e.to.row)&&Math.max(this.from.row,this.to.row)===Math.max(e.from.row,e.to.row)&&Math.min(this.from.col,this.to.col)===Math.min(e.from.col,e.to.col)&&Math.max(this.from.col,this.to.col)===Math.max(e.from.col,e.to.col)}overlaps(e){return e.isSouthEastOf(this.getOuterTopLeftCorner())&&e.isNorthWestOf(this.getOuterBottomRightCorner())}isSouthEastOf(e){return this.getOuterTopLeftCorner().isSouthEastOf(e)||this.getOuterBottomRightCorner().isSouthEastOf(e)}isNorthWestOf(e){return this.getOuterTopLeftCorner().isNorthWestOf(e)||this.getOuterBottomRightCorner().isNorthWestOf(e)}isOverlappingHorizontally(e){return this.getOuterTopEndCorner().col>=e.getOuterTopStartCorner().col&&this.getOuterTopEndCorner().col<=e.getOuterTopEndCorner().col||this.getOuterTopStartCorner().col<=e.getOuterTopEndCorner().col&&this.getOuterTopStartCorner().col>=e.getOuterTopStartCorner().col}isOverlappingVertically(e){return this.getOuterBottomStartCorner().row>=e.getOuterTopRightCorner().row&&this.getOuterBottomStartCorner().row<=e.getOuterBottomStartCorner().row||this.getOuterTopEndCorner().row<=e.getOuterBottomStartCorner().row&&this.getOuterTopEndCorner().row>=e.getOuterTopRightCorner().row}expand(e){const t=this.getOuterTopStartCorner(),r=this.getOuterBottomEndCorner();return(e.row<t.row||e.col<t.col||e.row>r.row||e.col>r.col)&&(this.from=this._createCellCoords(Math.min(t.row,e.row),Math.min(t.col,e.col)),this.to=this._createCellCoords(Math.max(r.row,e.row),Math.max(r.col,e.col)),!0)}expandByRange(e){let t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];if(this.includesRange(e)||!this.overlaps(e))return!1;const r=this.getOuterTopStartCorner(),n=this.getOuterBottomEndCorner(),s=this.getDirection(),i=e.getOuterTopStartCorner(),o=e.getOuterBottomEndCorner(),a=Math.min(r.row,i.row),l=Math.min(r.col,i.col),h=Math.max(n.row,o.row),u=Math.max(n.col,o.col),c=this._createCellCoords(a,l),d=this._createCellCoords(h,u);return this.from=c,this.to=d,this.setDirection(s),t&&(this.highlight.row===this.getOuterBottomRightCorner().row&&"N-S"===this.getVerticalDirection()&&this.flipDirectionVertically(),this.highlight.col===this.getOuterTopRightCorner().col&&"W-E"===this.getHorizontalDirection()&&this.flipDirectionHorizontally()),!0}getDirection(){return this.from.isNorthWestOf(this.to)?"NW-SE":this.from.isNorthEastOf(this.to)?"NE-SW":this.from.isSouthEastOf(this.to)?"SE-NW":this.from.isSouthWestOf(this.to)?"SW-NE":void 0}setDirection(e){switch(e){case"NW-SE":[this.from,this.to]=[this.getOuterTopLeftCorner(),this.getOuterBottomRightCorner()];break;case"NE-SW":[this.from,this.to]=[this.getOuterTopRightCorner(),this.getOuterBottomLeftCorner()];break;case"SE-NW":[this.from,this.to]=[this.getOuterBottomRightCorner(),this.getOuterTopLeftCorner()];break;case"SW-NE":[this.from,this.to]=[this.getOuterBottomLeftCorner(),this.getOuterTopRightCorner()]}}getVerticalDirection(){return["NE-SW","NW-SE"].indexOf(this.getDirection())>-1?"N-S":"S-N"}getHorizontalDirection(){return["NW-SE","SW-NE"].indexOf(this.getDirection())>-1?"W-E":"E-W"}flipDirectionVertically(){switch(this.getDirection()){case"NW-SE":this.setDirection("SW-NE");break;case"NE-SW":this.setDirection("SE-NW");break;case"SE-NW":this.setDirection("NE-SW");break;case"SW-NE":this.setDirection("NW-SE")}}flipDirectionHorizontally(){switch(this.getDirection()){case"NW-SE":this.setDirection("NE-SW");break;case"NE-SW":this.setDirection("NW-SE");break;case"SE-NW":this.setDirection("SW-NE");break;case"SW-NE":this.setDirection("SE-NW")}}getTopStartCorner(){return this._createCellCoords(Math.min(this.from.row,this.to.row),Math.min(this.from.col,this.to.col)).normalize()}getTopLeftCorner(){return a(h,this)?this.getTopEndCorner():this.getTopStartCorner()}getBottomEndCorner(){return this._createCellCoords(Math.max(this.from.row,this.to.row),Math.max(this.from.col,this.to.col)).normalize()}getBottomRightCorner(){return a(h,this)?this.getBottomStartCorner():this.getBottomEndCorner()}getTopEndCorner(){return this._createCellCoords(Math.min(this.from.row,this.to.row),Math.max(this.from.col,this.to.col)).normalize()}getTopRightCorner(){return a(h,this)?this.getTopStartCorner():this.getTopEndCorner()}getBottomStartCorner(){return this._createCellCoords(Math.max(this.from.row,this.to.row),Math.min(this.from.col,this.to.col)).normalize()}getBottomLeftCorner(){return a(h,this)?this.getBottomEndCorner():this.getBottomStartCorner()}getOuterTopStartCorner(){return this._createCellCoords(Math.min(this.from.row,this.to.row),Math.min(this.from.col,this.to.col))}getOuterTopLeftCorner(){return a(h,this)?this.getOuterTopEndCorner():this.getOuterTopStartCorner()}getOuterBottomEndCorner(){return this._createCellCoords(Math.max(this.from.row,this.to.row),Math.max(this.from.col,this.to.col))}getOuterBottomRightCorner(){return a(h,this)?this.getOuterBottomStartCorner():this.getOuterBottomEndCorner()}getOuterTopEndCorner(){return this._createCellCoords(Math.min(this.from.row,this.to.row),Math.max(this.from.col,this.to.col))}getOuterTopRightCorner(){return a(h,this)?this.getOuterTopStartCorner():this.getOuterTopEndCorner()}getOuterBottomStartCorner(){return this._createCellCoords(Math.max(this.from.row,this.to.row),Math.min(this.from.col,this.to.col))}getOuterBottomLeftCorner(){return a(h,this)?this.getOuterBottomEndCorner():this.getOuterBottomStartCorner()}isCorner(e){return e.isEqual(this.getOuterTopLeftCorner())||e.isEqual(this.getOuterTopRightCorner())||e.isEqual(this.getOuterBottomLeftCorner())||e.isEqual(this.getOuterBottomRightCorner())}getOppositeCorner(e){return e instanceof i.default&&(e.isEqual(this.getOuterBottomEndCorner())?this.getOuterTopStartCorner():e.isEqual(this.getOuterTopStartCorner())?this.getOuterBottomEndCorner():e.isEqual(this.getOuterTopEndCorner())?this.getOuterBottomStartCorner():e.isEqual(this.getOuterBottomStartCorner())?this.getOuterTopEndCorner():void 0)}getBordersSharedWith(e){if(!this.includesRange(e))return[];const t=Math.min(this.from.row,this.to.row),r=Math.max(this.from.row,this.to.row),n=Math.min(this.from.col,this.to.col),s=Math.max(this.from.col,this.to.col),i=Math.min(e.from.row,e.to.row),o=Math.max(e.from.row,e.to.row),l=Math.min(e.from.col,e.to.col),u=Math.max(e.from.col,e.to.col),c=[];return t===i&&c.push("top"),s===u&&c.push(a(h,this)?"left":"right"),r===o&&c.push("bottom"),n===l&&c.push(a(h,this)?"right":"left"),c}getInner(){const e=this.getOuterTopStartCorner(),t=this.getOuterBottomEndCorner(),r=[];for(let n=e.row;n<=t.row;n++)for(let s=e.col;s<=t.col;s++)this.from.row===n&&this.from.col===s||this.to.row===n&&this.to.col===s||r.push(this._createCellCoords(n,s));return r}getAll(){const e=this.getOuterTopStartCorner(),t=this.getOuterBottomEndCorner(),r=[];for(let n=e.row;n<=t.row;n++)for(let s=e.col;s<=t.col;s++)e.row===n&&e.col===s?r.push(e):t.row===n&&t.col===s?r.push(t):r.push(this._createCellCoords(n,s));return r}forAll(e){const t=this.getOuterTopStartCorner(),r=this.getOuterBottomEndCorner();for(let n=t.row;n<=r.row;n++)for(let s=t.col;s<=r.col;s++){if(!1===e(n,s))return}}clone(){return new u(this.highlight,this.from,this.to,a(h,this))}toObject(){return{from:this.from.toObject(),to:this.to.toObject()}}_createCellCoords(e,t){return new i.default(e,t,a(h,this))}}t.default=u},40564:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724);var s=n(r(85707)),i=r(62577),o=r(5893),a=n(r(3849)),l=n(r(15401)),h=n(r(2141)),u=n(r(16818));t.default=class{get eventManager(){return new a.default(this)}constructor(e,t){(0,s.default)(this,"wtTable",void 0),(0,s.default)(this,"wtScroll",void 0),(0,s.default)(this,"wtViewport",void 0),(0,s.default)(this,"wtOverlays",void 0),(0,s.default)(this,"selectionManager",void 0),(0,s.default)(this,"wtEvent",void 0),(0,s.default)(this,"guid",`wt_${(0,o.randomString)()}`),(0,s.default)(this,"drawInterrupted",!1),(0,s.default)(this,"drawn",!1),(0,s.default)(this,"activeOverlayName","master"),(0,s.default)(this,"domBindings",void 0),(0,s.default)(this,"wtSettings",void 0),this.domBindings={rootTable:e,rootDocument:e.ownerDocument,rootWindow:e.ownerDocument.defaultView},this.wtSettings=t,this.wtScroll=new l.default(this.createScrollDao())}findOriginalHeaders(){const e=[];if(this.wtTable.THEAD.childNodes.length&&this.wtTable.THEAD.childNodes[0].childNodes.length){for(let t=0,r=this.wtTable.THEAD.childNodes[0].childNodes.length;t<r;t++)e.push(this.wtTable.THEAD.childNodes[0].childNodes[t].innerHTML);this.wtSettings.getSetting("columnHeaders").length||this.wtSettings.update("columnHeaders",[function(t,r){(0,i.fastInnerText)(r,e[t])}])}}createCellCoords(e,t){return new h.default(e,t,this.wtSettings.getSetting("rtlMode"))}createCellRange(e,t,r){return new u.default(e,t,r,this.wtSettings.getSetting("rtlMode"))}draw(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];return this.drawInterrupted=!1,this.wtTable.isVisible()?this.wtTable.draw(e):this.drawInterrupted=!0,this}getCell(e){if(!(arguments.length>1&&void 0!==arguments[1]&&arguments[1]))return this.wtTable.getCell(e);const t=this.wtSettings.getSetting("totalRows"),r=this.wtSettings.getSetting("fixedRowsTop"),n=this.wtSettings.getSetting("fixedRowsBottom"),s=this.wtSettings.getSetting("fixedColumnsStart");if(e.row<r&&e.col<s)return this.wtOverlays.topInlineStartCornerOverlay.clone.wtTable.getCell(e);if(e.row<r)return this.wtOverlays.topOverlay.clone.wtTable.getCell(e);if(e.col<s&&e.row>=t-n){if(this.wtOverlays.bottomInlineStartCornerOverlay&&this.wtOverlays.bottomInlineStartCornerOverlay.clone)return this.wtOverlays.bottomInlineStartCornerOverlay.clone.wtTable.getCell(e)}else{if(e.col<s)return this.wtOverlays.inlineStartOverlay.clone.wtTable.getCell(e);if(e.row<t&&e.row>=t-n&&this.wtOverlays.bottomOverlay&&this.wtOverlays.bottomOverlay.clone)return this.wtOverlays.bottomOverlay.clone.wtTable.getCell(e)}return this.wtTable.getCell(e)}scrollViewport(e,t,r){return this.wtScroll.scrollViewport(e,t,r)}scrollViewportHorizontally(e,t){return this.wtScroll.scrollViewportHorizontally(e,t)}scrollViewportVertically(e,t){return this.wtScroll.scrollViewportVertically(e,t)}getViewport(){return[this.wtTable.getFirstVisibleRow(),this.wtTable.getFirstVisibleColumn(),this.wtTable.getLastVisibleRow(),this.wtTable.getLastVisibleColumn()]}destroy(){this.wtOverlays.destroy(),this.wtEvent.destroy()}createScrollDao(){const e=this;return{get drawn(){return e.drawn},get topOverlay(){return e.wtOverlays.topOverlay},get inlineStartOverlay(){return e.wtOverlays.inlineStartOverlay},get wtTable(){return e.wtTable},get wtViewport(){return e.wtViewport},get wtSettings(){return e.wtSettings},get rootWindow(){return e.domBindings.rootWindow},get totalRows(){return e.wtSettings.getSetting("totalRows")},get totalColumns(){return e.wtSettings.getSetting("totalColumns")},get fixedRowsTop(){return e.wtSettings.getSetting("fixedRowsTop")},get fixedRowsBottom(){return e.wtSettings.getSetting("fixedRowsBottom")},get fixedColumnsStart(){return e.wtSettings.getSetting("fixedColumnsStart")}}}getTableDao(){const e=this;return{get wot(){return e},get parentTableOffset(){return e.cloneSource.wtTable.tableOffset},get cloneSource(){return e.cloneSource},get workspaceWidth(){return e.wtViewport.getWorkspaceWidth()},get wtViewport(){return e.wtViewport},get wtOverlays(){return e.wtOverlays},get selectionManager(){return e.selectionManager},get stylesHandler(){return e.stylesHandler},get drawn(){return e.drawn},set drawn(t){e.drawn=t},get wtTable(){return e.wtTable},get startColumnRendered(){return e.wtViewport.columnsRenderCalculator.startColumn},get startColumnVisible(){return e.wtViewport.columnsVisibleCalculator.startColumn},get startColumnPartiallyVisible(){return e.wtViewport.columnsPartiallyVisibleCalculator.startColumn},get endColumnRendered(){return e.wtViewport.columnsRenderCalculator.endColumn},get endColumnVisible(){return e.wtViewport.columnsVisibleCalculator.endColumn},get endColumnPartiallyVisible(){return e.wtViewport.columnsPartiallyVisibleCalculator.endColumn},get countColumnsRendered(){return e.wtViewport.columnsRenderCalculator.count},get countColumnsVisible(){return e.wtViewport.columnsVisibleCalculator.count},get startRowRendered(){return e.wtViewport.rowsRenderCalculator.startRow},get startRowVisible(){return e.wtViewport.rowsVisibleCalculator.startRow},get startRowPartiallyVisible(){return e.wtViewport.rowsPartiallyVisibleCalculator.startRow},get endRowRendered(){return e.wtViewport.rowsRenderCalculator.endRow},get endRowVisible(){return e.wtViewport.rowsVisibleCalculator.endRow},get endRowPartiallyVisible(){return e.wtViewport.rowsPartiallyVisibleCalculator.endRow},get countRowsRendered(){return e.wtViewport.rowsRenderCalculator.count},get countRowsVisible(){return e.wtViewport.rowsVisibleCalculator.count},get columnHeaders(){return e.wtSettings.getSetting("columnHeaders")},get rowHeaders(){return e.wtSettings.getSetting("rowHeaders")}}}}},36817:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),i=n(r(15478)),o=n(r(40564));class a extends o.default{constructor(e,t,r){super(e,t),(0,s.default)(this,"cloneSource",void 0),(0,s.default)(this,"cloneOverlay",void 0);const n=this.wtSettings.getSetting("facade",this);this.cloneSource=r.source,this.cloneOverlay=r.overlay,this.stylesHandler=r.stylesHandler,this.wtTable=this.cloneOverlay.createTable(this.getTableDao(),n,this.domBindings,this.wtSettings),this.wtViewport=r.viewport,this.selectionManager=r.selectionManager,this.wtEvent=new i.default(n,this.domBindings,this.wtSettings,this.eventManager,this.wtTable,this.selectionManager,r.event),this.findOriginalHeaders()}}t.default=a},9717:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724);var s=n(r(15478)),i=n(r(66925)),o=r(69397),a=n(r(34117)),l=n(r(78951)),h=n(r(16598)),u=n(r(40564)),c=r(67600),d=r(25499),p=r(62577),g=r(52714);class f extends u.default{constructor(e,t){super(e,new a.default(t)),this.stylesHandler=new g.StylesHandler(this.domBindings);const r=this.wtSettings.getSetting("facade",this);this.wtTable=new l.default(this.getTableDao(),r,this.domBindings,this.wtSettings),this.wtViewport=new h.default(this.getViewportDao(),this.domBindings,this.wtSettings,this.eventManager,this.wtTable),this.selectionManager=new c.SelectionManager(this.wtSettings.getSetting("selections")),this.wtEvent=new s.default(r,this.domBindings,this.wtSettings,this.eventManager,this.wtTable,this.selectionManager),this.wtOverlays=new i.default(this,r,this.domBindings,this.wtSettings,this.eventManager,this.wtTable),this.exportSettingsAsClassNames(),this.findOriginalHeaders()}exportSettingsAsClassNames(){const e=[],t=[];(0,d.objectEach)({rowHeaders:"htRowHeaders",columnHeaders:"htColumnHeaders"},((r,n)=>{this.wtSettings.getSetting(n).length&&t.push(r),e.push(r)})),(0,p.removeClass)(this.wtTable.wtRootElement.parentNode,e),(0,p.addClass)(this.wtTable.wtRootElement.parentNode,t)}getOverlayByName(e){var t;if(!o.CLONE_TYPES.includes(e))return null;const r=e.replace(/_([a-z])/g,(e=>e[1].toUpperCase()));return null!==(t=this.wtOverlays[`${r}Overlay`])&&void 0!==t?t:null}getViewportDao(){const e=this;return{get wot(){return e},get topOverlayTrimmingContainer(){return e.wtOverlays.topOverlay.trimmingContainer},get inlineStartOverlayTrimmingContainer(){return e.wtOverlays.inlineStartOverlay.trimmingContainer},get topScrollPosition(){return e.wtOverlays.topOverlay.getScrollPosition()},get topParentOffset(){return e.wtOverlays.topOverlay.getTableParentOffset()},get inlineStartScrollPosition(){return e.wtOverlays.inlineStartOverlay.getScrollPosition()},get inlineStartParentOffset(){return e.wtOverlays.inlineStartOverlay.getTableParentOffset()},get topOverlay(){return e.wtOverlays.topOverlay},get inlineStartOverlay(){return e.wtOverlays.inlineStartOverlay},get bottomOverlay(){return e.wtOverlays.bottomOverlay}}}}t.default=f},15478:(e,t,r)=>{"use strict";t.__esModule=!0,r(67834);var n=r(62577),s=r(89804),i=r(85992),o=r(25046),a=r(70505);function l(e,t,r){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,r)}function h(e,t){return e.get(c(e,t))}function u(e,t,r){return e.set(c(e,t),r),r}function c(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var d=new WeakMap,p=new WeakMap,g=new WeakMap,f=new WeakMap,m=new WeakMap,y=new WeakMap,E=new WeakMap,w=new WeakMap,C=new WeakMap,v=new WeakMap;t.default=class{constructor(e,t,r,n,s,i){let o=arguments.length>6&&void 0!==arguments[6]?arguments[6]:null;l(this,d,void 0),l(this,p,void 0),l(this,g,void 0),l(this,f,void 0),l(this,m,void 0),l(this,y,void 0),l(this,E,void 0),l(this,w,void 0),l(this,C,[null,null]),l(this,v,[null,null]),u(d,this,r),u(p,this,t),u(g,this,s),u(f,this,i),u(m,this,o),u(y,this,n),u(E,this,e),this.registerEvents()}registerEvents(){h(y,this).addEventListener(h(g,this).holder,"contextmenu",(e=>this.onContextMenu(e))),h(y,this).addEventListener(h(g,this).TABLE,"mouseover",(e=>this.onMouseOver(e))),h(y,this).addEventListener(h(g,this).TABLE,"mouseout",(e=>this.onMouseOut(e)));const e=()=>{h(y,this).addEventListener(h(g,this).holder,"touchstart",(e=>this.onTouchStart(e))),h(y,this).addEventListener(h(g,this).holder,"touchend",(e=>this.onTouchEnd(e))),this.momentumScrolling||(this.momentumScrolling={}),h(y,this).addEventListener(h(g,this).holder,"scroll",(()=>{clearTimeout(this.momentumScrolling._timeout),this.momentumScrolling.ongoing||h(d,this).getSetting("onBeforeTouchScroll"),this.momentumScrolling.ongoing=!0,this.momentumScrolling._timeout=setTimeout((()=>{this.touchApplied||(this.momentumScrolling.ongoing=!1,h(d,this).getSetting("onAfterMomentumScroll"))}),200)}))},t=()=>{h(y,this).addEventListener(h(g,this).holder,"mouseup",(e=>this.onMouseUp(e))),h(y,this).addEventListener(h(g,this).holder,"mousedown",(e=>this.onMouseDown(e)))};(0,o.isMobileBrowser)()?e():((0,i.isTouchSupported)()&&e(),t())}selectedCellWasTouched(e){const t=this.parentCell(e).coords;if(h(w,this)&&t){const[e,r]=[t.row,h(w,this).from.row],[n,s]=[t.col,h(w,this).from.col];return e===r&&n===s}return!1}parentCell(e){const t={},r=h(g,this).TABLE,s=(0,n.closestDown)(e,["TD","TH"],r);return s?(t.coords=h(g,this).getCoords(s),t.TD=s):(0,n.hasClass)(e,"wtBorder")&&(0,n.hasClass)(e,"current")?(t.coords=h(f,this).getFocusSelection().cellRange.highlight,t.TD=h(g,this).getCell(t.coords)):(0,n.hasClass)(e,"wtBorder")&&(0,n.hasClass)(e,"area")&&h(f,this).getAreaSelection().cellRange&&(t.coords=h(f,this).getAreaSelection().cellRange.to,t.TD=h(g,this).getCell(t.coords)),t}onMouseDown(e){const t=h(p,this).rootDocument.activeElement,r=(0,s.partial)(n.getParent,e.target),i=e.target;if(!["TD","TH"].includes(t.nodeName)&&(i===t||r(0)===t||r(1)===t))return;const o=this.parentCell(i);(0,n.hasClass)(i,"corner")?h(d,this).getSetting("onCellCornerMouseDown",e,i):o.TD&&h(d,this).has("onCellMouseDown")&&this.callListener("onCellMouseDown",e,o.coords,o.TD),(0===e.button||this.touchApplied)&&o.TD&&(h(v,this)[0]=o.TD,clearTimeout(h(C,this)[0]),h(C,this)[0]=setTimeout((()=>{h(v,this)[0]=null}),1e3))}onContextMenu(e){if(h(d,this).has("onCellContextMenu")){const t=this.parentCell(e.target);t.TD&&this.callListener("onCellContextMenu",e,t.coords,t.TD)}}onMouseOver(e){if(!h(d,this).has("onCellMouseOver"))return;const t=h(g,this).TABLE,r=(0,n.closestDown)(e.target,["TD","TH"],t),s=h(m,this)||this;r&&r!==s.lastMouseOver&&(0,n.isChildOf)(r,t)&&(s.lastMouseOver=r,this.callListener("onCellMouseOver",e,h(g,this).getCoords(r),r))}onMouseOut(e){if(!h(d,this).has("onCellMouseOut"))return;const t=h(g,this).TABLE,r=(0,n.closestDown)(e.target,["TD","TH"],t),s=(0,n.closestDown)(e.relatedTarget,["TD","TH"],t),i=h(m,this)||this;r&&r!==s&&(0,n.isChildOf)(r,t)&&(this.callListener("onCellMouseOut",e,h(g,this).getCoords(r),r),null===s&&(i.lastMouseOver=null))}onMouseUp(e){const t=this.parentCell(e.target);t.TD&&h(d,this).has("onCellMouseUp")&&this.callListener("onCellMouseUp",e,t.coords,t.TD),(0===e.button||this.touchApplied)&&(t.TD===h(v,this)[0]&&t.TD===h(v,this)[1]?((0,n.hasClass)(e.target,"corner")?this.callListener("onCellCornerDblClick",e,t.coords,t.TD):this.callListener("onCellDblClick",e,t.coords,t.TD),h(v,this)[0]=null,h(v,this)[1]=null):t.TD===h(v,this)[0]&&(h(v,this)[1]=t.TD,clearTimeout(h(C,this)[1]),h(C,this)[1]=setTimeout((()=>{h(v,this)[1]=null}),500)))}onTouchStart(e){u(w,this,h(f,this).getFocusSelection().cellRange),this.touchApplied=!0,this.onMouseDown(e)}onTouchEnd(e){var t;const r=e.target,n=null===(t=this.parentCell(r))||void 0===t?void 0:t.coords,s=(0,a.isDefined)(n)&&n.row>=0&&n.col>=0;if(e.cancelable&&s&&h(d,this).getSetting("isDataViewInstance")){const t=["A","BUTTON","INPUT"];(0,o.isIOS)()&&((0,o.isChromeWebKit)()||(0,o.isFirefoxWebKit)())&&this.selectedCellWasTouched(r)&&!t.includes(r.tagName)?e.preventDefault():this.selectedCellWasTouched(r)||e.preventDefault()}this.onMouseUp(e),this.touchApplied=!1}callListener(e,t,r,n){const s=h(d,this).getSettingPure(e);s&&s(t,r,n,h(E,this).call(this))}destroy(){clearTimeout(h(C,this)[0]),clearTimeout(h(C,this)[1]),h(y,this).destroy()}}},11322:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(9717)),i=n(r(40564));class o{constructor(e){e instanceof i.default?this._wot=e:this._initFromSettings(e)}_initFromSettings(e){e.facade=e=>{const t=new o(e);return()=>t},this._wot=new s.default(e.table,e)}get guid(){return this._wot.guid}get rootDocument(){return this._wot.domBindings.rootDocument}get rootWindow(){return this._wot.domBindings.rootWindow}get wtSettings(){return this._wot.wtSettings}get cloneSource(){return this._wot.cloneSource}get cloneOverlay(){return this._wot.cloneOverlay}get selectionManager(){return this._wot.selectionManager}get wtViewport(){return this._wot.wtViewport}get wtOverlays(){return this._wot.wtOverlays}get wtTable(){return this._wot.wtTable}get wtEvent(){return this._wot.wtEvent}get wtScroll(){return this._wot.wtScroll}get drawn(){return this._wot.drawn}set drawn(e){this._wot.drawn=e}get activeOverlayName(){return this._wot.activeOverlayName}get drawInterrupted(){return this._wot.drawInterrupted}set drawInterrupted(e){this._wot.drawInterrupted=e}get lastMouseOver(){return this._wot.lastMouseOver}set lastMouseOver(e){this._wot.lastMouseOver=e}get momentumScrolling(){return this._wot.momentumScrolling}set momentumScrolling(e){this._wot.momentumScrolling=e}get touchApplied(){return this._wot.touchApplied}set touchApplied(e){this._wot.touchApplied=e}get domBindings(){return this._wot.domBindings}get eventListeners(){return this._wot.eventListeners}set eventListeners(e){this._wot.eventListeners=e}get eventManager(){return this._wot.eventManager}get stylesHandler(){return this._wot.stylesHandler}createCellCoords(e,t){return this._wot.createCellCoords(e,t)}createCellRange(e,t,r){return this._wot.createCellRange(e,t,r)}draw(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];return this._wot.draw(e),this}getCell(e){let t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];return this._wot.getCell(e,t)}scrollViewport(e,t,r){return this._wot.scrollViewport(e,t,r)}scrollViewportHorizontally(e,t){return this._wot.scrollViewportHorizontally(e,t)}scrollViewportVertically(e,t){return this._wot.scrollViewportVertically(e,t)}getViewport(){return this._wot.getViewport()}getOverlayName(){return this._wot.cloneOverlay?this._wot.cloneOverlay.type:"master"}getOverlayByName(e){return this._wot.getOverlayByName(e)}exportSettingsAsClassNames(){return this._wot.exportSettingsAsClassNames()}update(e,t){return this._wot.wtSettings.update(e,t),this}getSetting(e,t,r,n,s){return this._wot.wtSettings.getSetting(e,t,r,n,s)}hasSetting(e){return this._wot.wtSettings.hasSetting(e)}destroy(){this._wot.destroy()}}t.default=o},62383:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.default=class{constructor(e,t,r){(0,s.default)(this,"offset",void 0),(0,s.default)(this,"total",void 0),(0,s.default)(this,"countTH",void 0),this.offset=e,this.total=t,this.countTH=r}offsetted(e){return e+this.offset}unOffsetted(e){return e-this.offset}renderedToSource(e){return this.offsetted(e)}sourceToRendered(e){return this.unOffsetted(e)}offsettedTH(e){return e-this.countTH}unOffsettedTH(e){return e+this.countTH}visibleRowHeadedColumnToSourceColumn(e){return this.renderedToSource(this.offsettedTH(e))}sourceColumnToVisibleRowHeadedColumn(e){return this.unOffsettedTH(this.sourceToRendered(e))}}},82217:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.default=class{constructor(e,t,r){(0,s.default)(this,"offset",void 0),(0,s.default)(this,"total",void 0),(0,s.default)(this,"countTH",void 0),this.offset=e,this.total=t,this.countTH=r}offsetted(e){return e+this.offset}unOffsetted(e){return e-this.offset}renderedToSource(e){return this.offsetted(e)}sourceToRendered(e){return this.unOffsetted(e)}offsettedTH(e){return e-this.countTH}unOffsettedTH(e){return e+this.countTH}visibleColHeadedRowToSourceRow(e){return this.renderedToSource(this.offsettedTH(e))}sourceRowToVisibleColHeadedRow(e){return this.unOffsettedTH(this.sourceToRendered(e))}}},50206:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=r(63059);t.ViewportColumnsCalculator=s.ViewportColumnsCalculator,t.ViewportRowsCalculator=s.ViewportRowsCalculator,t.DEFAULT_COLUMN_WIDTH=s.DEFAULT_COLUMN_WIDTH;var i=n(r(2141));t.CellCoords=i.default;var o=n(r(16818));t.CellRange=o.default;var a=n(r(11322));t.default=a.default,t.Core=a.default;var l=r(70471);t.Selection=l.Selection,t.HIGHLIGHT_ACTIVE_HEADER_TYPE=l.ACTIVE_HEADER_TYPE,t.HIGHLIGHT_AREA_TYPE=l.AREA_TYPE,t.HIGHLIGHT_FOCUS_TYPE=l.FOCUS_TYPE,t.HIGHLIGHT_FILL_TYPE=l.FILL_TYPE,t.HIGHLIGHT_HEADER_TYPE=l.HEADER_TYPE,t.HIGHLIGHT_ROW_TYPE=l.ROW_TYPE,t.HIGHLIGHT_COLUMN_TYPE=l.COLUMN_TYPE,t.HIGHLIGHT_CUSTOM_SELECTION_TYPE=l.CUSTOM_SELECTION_TYPE;var h=function(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var r=d(t);if(r&&r.has(e))return r.get(e);var n={__proto__:null},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var i in e)if("default"!==i&&{}.hasOwnProperty.call(e,i)){var o=s?Object.getOwnPropertyDescriptor(e,i):null;o&&(o.get||o.set)?Object.defineProperty(n,i,o):n[i]=e[i]}return n.default=e,r&&r.set(e,n),n}(r(36936));t.Renderer=h;var u=r(97646);t.OrderView=u.OrderView,t.SharedOrderView=u.SharedOrderView;var c=r(3849);function d(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,r=new WeakMap;return(d=function(e){return e?r:t})(e)}t.getListenersCounter=c.getListenersCounter},18113:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(14846),r(69655);var s=n(r(85707)),i=r(62577),o=r(25499),a=r(14859),l=r(85484),h=n(r(36817)),u=r(71120);t.Overlay=class{constructor(e,t,r,n,a){(0,s.default)(this,"wtSettings",null),(0,o.defineGetter)(this,"wot",e,{writable:!1}),this.domBindings=a,this.facadeGetter=t,this.wtSettings=n;const{TABLE:l,hider:h,spreader:u,holder:c,wtRootElement:d}=this.wot.wtTable;this.instance=this.wot,this.type=r,this.mainTableScrollableElement=null,this.TABLE=l,this.hider=h,this.spreader=u,this.holder=c,this.wtRootElement=d,this.trimmingContainer=(0,i.getTrimmingContainer)(this.hider.parentNode.parentNode),this.needFullRender=this.shouldBeRendered(),this.clone=this.makeClone()}hasRenderingStateChanged(){return this.needFullRender!==this.shouldBeRendered()}updateStateOfRendering(e){"before"===e&&this.shouldBeRendered()?this.needFullRender=!0:"after"!==e||this.shouldBeRendered()||(this.needFullRender=!1)}shouldBeRendered(){return!0}updateTrimmingContainer(){this.trimmingContainer=(0,i.getTrimmingContainer)(this.hider.parentNode.parentNode)}updateMainScrollableElement(){const{wtTable:e}=this.wot,{rootWindow:t}=this.domBindings;"hidden"===t.getComputedStyle(e.wtRootElement.parentNode).getPropertyValue("overflow")?this.mainTableScrollableElement=this.wot.wtTable.holder:this.mainTableScrollableElement=(0,i.getScrollableElement)(e.TABLE)}getRelativeCellPosition(e,t,r){if(!1===this.clone.wtTable.holder.contains(e))return void(0,a.warn)(`The provided element is not a child of the ${this.type} overlay`);const n=this.mainTableScrollableElement===this.domBindings.rootWindow,s=r<this.wtSettings.getSetting("fixedColumnsStart"),i=t<this.wtSettings.getSetting("fixedRowsTop"),o=t>=this.wtSettings.getSetting("totalRows")-this.wtSettings.getSetting("fixedRowsBottom"),l=this.clone.wtTable.spreader,h={start:this.getRelativeStartPosition(l),top:l.offsetTop},u={start:this.getRelativeStartPosition(e),top:e.offsetTop};let c=null;return c=n?this.getRelativeCellPositionWithinWindow(i,s,u,h):this.getRelativeCellPositionWithinHolder(i,o,s,u,h),c}getRelativeStartPosition(e){return this.isRtl()?e.offsetParent.offsetWidth-e.offsetLeft-e.offsetWidth:e.offsetLeft}getRelativeCellPositionWithinWindow(e,t,r,n){const s=this.wot.wtTable.wtRootElement.getBoundingClientRect();let o=0,a=0;if(t){let e=s.left;this.isRtl()&&(e=this.domBindings.rootWindow.innerWidth-(s.left+s.width+(0,i.getScrollbarWidth)())),o=e<=0?-1*e:0}else o=n.start;if(e){a=this.clone.wtTable.TABLE.getBoundingClientRect().top-s.top}else a=n.top;return{start:r.start+o,top:r.top+a}}getRelativeCellPositionWithinHolder(e,t,r,n,s){const i=this.wot.wtOverlays.inlineStartOverlay.getScrollPosition(),o=this.wot.wtOverlays.topOverlay.getScrollPosition();let a=0,l=0;if(r||(a=i-s.start),t){const e=this.wot.wtTable.wtRootElement.getBoundingClientRect();l=-1*this.clone.wtTable.TABLE.getBoundingClientRect().top+e.top}else e||(l=o-s.top);return{start:n.start-a,top:n.top-l}}makeClone(){if(-1===l.CLONE_TYPES.indexOf(this.type))throw new Error(`Clone type "${this.type}" is not supported.`);const{wtTable:e,wtSettings:t}=this.wot,{rootDocument:r,rootWindow:n}=this.domBindings,s=r.createElement("div"),o=r.createElement("table"),a=e.wtRootElement.parentNode;s.className=`${l.CLONE_CLASS_NAMES.get(this.type)} handsontable`,s.setAttribute("dir",this.isRtl()?"rtl":"ltr"),s.style.position="absolute",s.style.top=0,s.style.overflow="visible",this.isRtl()?s.style.right=0:s.style.left=0,t.getSetting("ariaTags")&&(0,i.setAttribute)(s,[(0,u.A11Y_PRESENTATION)()]),o.className=e.TABLE.className;e.TABLE.getAttribute("role")&&o.setAttribute("role",e.TABLE.getAttribute("role")),s.appendChild(o),a.appendChild(s);const c=this.wtSettings.getSetting("preventOverflow");return!0===c||"horizontal"===c&&this.type===l.CLONE_TOP||"vertical"===c&&this.type===l.CLONE_INLINE_START?this.mainTableScrollableElement=n:"hidden"===n.getComputedStyle(a).getPropertyValue("overflow")?this.mainTableScrollableElement=e.holder:this.mainTableScrollableElement=(0,i.getScrollableElement)(e.TABLE),new h.default(o,this.wtSettings,{source:this.wot,overlay:this,viewport:this.wot.wtViewport,event:this.wot.wtEvent,selectionManager:this.wot.selectionManager,stylesHandler:this.wot.stylesHandler})}refresh(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];if(this.needFullRender){const t=this.clone.cloneSource;t.activeOverlayName=this.clone.wtTable.name,this.clone.draw(e),t.activeOverlayName="master"}}reset(){const e=this.clone.wtTable.holder,t=this.clone.wtTable.hider;[e.style,t.style,e.parentNode.style].forEach((e=>{e.width="",e.height=""}))}isRtl(){return this.wtSettings.getSetting("rtlMode")}destroy(){this.clone.eventManager.destroy()}}},12942:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),i=r(62577),o=n(r(55538)),a=r(18113),l=r(85484);class h extends a.Overlay{constructor(e,t,r,n){super(e,t,l.CLONE_BOTTOM,r,n),(0,s.default)(this,"cachedFixedRowsBottom",-1),this.cachedFixedRowsBottom=this.wtSettings.getSetting("fixedRowsBottom")}createTable(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return new o.default(...t)}shouldBeRendered(){return this.wtSettings.getSetting("shouldRenderBottomOverlay")}resetFixedPosition(){if(!this.needFullRender||!this.shouldBeRendered()||!this.wot.wtTable.holder.parentNode)return!1;const{rootWindow:e}=this.domBindings,t=this.clone.wtTable.holder.parentNode;t.style.top="";let r=0;const n=this.wtSettings.getSetting("preventOverflow");this.trimmingContainer!==e||n&&"vertical"===n?(r=this.getScrollPosition(),this.repositionOverlay()):(r=this.getOverlayOffset(),t.style.bottom=`${r}px`);const s=this.adjustHeaderBordersPosition(r);return this.adjustElementsSize(),s}repositionOverlay(){const{wtTable:e,wtViewport:t}=this.wot,{rootDocument:r}=this.domBindings,n=this.clone.wtTable.holder.parentNode;let s=0;t.hasVerticalScroll()||(s+=t.getWorkspaceHeight()-e.getTotalHeight()),t.hasVerticalScroll()&&t.hasHorizontalScroll()&&(s+=(0,i.getScrollbarWidth)(r)),n.style.bottom=`${s}px`}setScrollPosition(e){const{rootWindow:t}=this.domBindings;let r=!1;return this.mainTableScrollableElement===t?(t.scrollTo((0,i.getWindowScrollLeft)(t),e),r=!0):this.mainTableScrollableElement.scrollTop!==e&&(this.mainTableScrollableElement.scrollTop=e,r=!0),r}onScroll(){this.wtSettings.getSetting("onScrollHorizontally")}sumCellSizes(e,t){const{wtTable:r,stylesHandler:n}=this.wot,s=n.getDefaultRowHeight();let i=e,o=0;for(;i<t;){const e=r.getRowHeight(i);o+=void 0===e?s:e,i+=1}return o}adjustElementsSize(){this.updateTrimmingContainer(),this.needFullRender&&(this.adjustRootElementSize(),this.adjustRootChildrenSize())}adjustRootElementSize(){const{wtTable:e,wtViewport:t}=this.wot,{rootDocument:r,rootWindow:n}=this.domBindings,s=this.clone.wtTable.holder.parentNode.style,o=this.wtSettings.getSetting("preventOverflow");if(this.trimmingContainer!==n||"horizontal"===o){let n=t.getWorkspaceWidth();t.hasVerticalScroll()&&(n-=(0,i.getScrollbarWidth)(r)),n=Math.min(n,e.wtRootElement.scrollWidth),s.width=`${n}px`}else s.width="";this.clone.wtTable.holder.style.width=s.width;let a=(0,i.outerHeight)(this.clone.wtTable.TABLE);e.hasDefinedSize()||(a=0),s.height=`${a}px`}adjustRootChildrenSize(){const{holder:e}=this.clone.wtTable;this.clone.wtTable.hider.style.width=this.hider.style.width,e.style.width=e.parentNode.style.width,e.style.height=e.parentNode.style.height}applyToDOM(){const e=this.wtSettings.getSetting("totalRows");if("number"==typeof this.wot.wtViewport.rowsRenderCalculator.startPosition)this.spreader.style.top=`${this.wot.wtViewport.rowsRenderCalculator.startPosition}px`;else{if(0!==e)throw new Error("Incorrect value of the rowsRenderCalculator");this.spreader.style.top="0"}this.spreader.style.bottom="",this.needFullRender&&this.syncOverlayOffset()}syncOverlayOffset(){const e=this.isRtl()?"right":"left",{spreader:t}=this.clone.wtTable;"number"==typeof this.wot.wtViewport.columnsRenderCalculator.startPosition?t.style[e]=`${this.wot.wtViewport.columnsRenderCalculator.startPosition}px`:t.style[e]=""}scrollTo(e,t){let r=this.getTableParentOffset();const n=(this.wot.cloneSource?this.wot.cloneSource:this.wot).wtTable.holder;let s=0;t&&n.offsetHeight!==n.clientHeight&&(s=(0,i.getScrollbarWidth)(this.domBindings.rootDocument)),t?(r+=this.sumCellSizes(0,e+1),r-=this.wot.wtViewport.getViewportHeight(),r+=1):r+=this.sumCellSizes(this.wtSettings.getSetting("fixedRowsBottom"),e),r+=s,this.setScrollPosition(r)}getTableParentOffset(){return this.mainTableScrollableElement===this.domBindings.rootWindow?this.wot.wtTable.holderOffset.top:0}getScrollPosition(){return(0,i.getScrollTop)(this.mainTableScrollableElement,this.domBindings.rootWindow)}getOverlayOffset(){const{rootWindow:e}=this.domBindings,t=this.wtSettings.getSetting("preventOverflow");let r=0;if(this.trimmingContainer===e&&(!t||"vertical"!==t)){const e=this.wot.wtTable.getTotalHeight(),t=e-this.clone.wtTable.getTotalHeight(),n=this.domBindings.rootDocument.documentElement.clientHeight;r=Math.max(this.getTableParentOffset()-this.getScrollPosition()-n+e,0),r>t&&(r=0)}return r}adjustHeaderBordersPosition(e){const t=this.wtSettings.getSetting("fixedRowsBottom"),r=this.cachedFixedRowsBottom!==t,n=this.wtSettings.getSetting("columnHeaders");let s=!1;if((r||0===t)&&n.length>0){const t=this.wot.wtTable.holder.parentNode,r=(0,i.hasClass)(t,"innerBorderBottom");this.cachedFixedRowsBottom=this.wtSettings.getSetting("fixedRowsBottom"),e||0===this.wtSettings.getSetting("totalRows")?((0,i.addClass)(t,"innerBorderBottom"),s=!r):((0,i.removeClass)(t,"innerBorderBottom"),s=r)}return s}}t.BottomOverlay=h},72478:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=r(62577),i=n(r(41618)),o=r(18113),a=r(85484);class l extends o.Overlay{constructor(e,t,r,n,s,i){super(e,t,a.CLONE_BOTTOM_INLINE_START_CORNER,r,n),this.bottomOverlay=s,this.inlineStartOverlay=i}createTable(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return new i.default(...t)}shouldBeRendered(){return this.wtSettings.getSetting("shouldRenderBottomOverlay")&&this.wtSettings.getSetting("shouldRenderInlineStartOverlay")}resetFixedPosition(){const{wot:e}=this;if(this.updateTrimmingContainer(),!e.wtTable.holder.parentNode)return!1;const t=this.clone.wtTable.holder.parentNode;if(t.style.top="",this.trimmingContainer===this.domBindings.rootWindow){const e=this.inlineStartOverlay.getOverlayOffset(),r=this.bottomOverlay.getOverlayOffset();t.style[this.isRtl()?"right":"left"]=`${e}px`,t.style.bottom=`${r}px`}else(0,s.resetCssTransform)(t),this.repositionOverlay();let r=(0,s.outerHeight)(this.clone.wtTable.TABLE);const n=(0,s.outerWidth)(this.clone.wtTable.TABLE);return this.wot.wtTable.hasDefinedSize()||(r=0),t.style.height=`${r}px`,t.style.width=`${n}px`,!1}repositionOverlay(){const{wtTable:e,wtViewport:t}=this.wot,{rootDocument:r}=this.domBindings,n=this.clone.wtTable.holder.parentNode;let i=0;t.hasVerticalScroll()||(i+=t.getWorkspaceHeight()-e.getTotalHeight()),t.hasVerticalScroll()&&t.hasHorizontalScroll()&&(i+=(0,s.getScrollbarWidth)(r)),n.style.bottom=`${i}px`}}t.BottomInlineStartCornerOverlay=l},85484:(e,t)=>{"use strict";t.__esModule=!0;const r=t.CLONE_TOP="top",n=t.CLONE_BOTTOM="bottom",s=t.CLONE_INLINE_START="inline_start",i=t.CLONE_TOP_INLINE_START_CORNER="top_inline_start_corner",o=t.CLONE_BOTTOM_INLINE_START_CORNER="bottom_inline_start_corner";t.CLONE_TYPES=[r,n,s,i,o],t.CLONE_CLASS_NAMES=new Map([[r,`ht_clone_${r}`],[n,`ht_clone_${n}`],[s,`ht_clone_${s} ht_clone_left`],[i,`ht_clone_${i} ht_clone_top_left_corner`],[o,`ht_clone_${o} ht_clone_bottom_left_corner`]])},69397:(e,t,r)=>{"use strict";r(14846),r(69655),t.__esModule=!0;var n={BottomInlineStartCornerOverlay:!0,BottomOverlay:!0,InlineStartOverlay:!0,Overlay:!0,TopInlineStartCornerOverlay:!0,TopOverlay:!0},s=r(72478);t.BottomInlineStartCornerOverlay=s.BottomInlineStartCornerOverlay;var i=r(12942);t.BottomOverlay=i.BottomOverlay;var o=r(90122);t.InlineStartOverlay=o.InlineStartOverlay;var a=r(18113);t.Overlay=a.Overlay;var l=r(76922);t.TopInlineStartCornerOverlay=l.TopInlineStartCornerOverlay;var h=r(73114);t.TopOverlay=h.TopOverlay;var u=r(85484);Object.keys(u).forEach((function(e){"default"!==e&&"__esModule"!==e&&(Object.prototype.hasOwnProperty.call(n,e)||e in t&&t[e]===u[e]||(t[e]=u[e]))}))},90122:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=r(62577),i=n(r(80222)),o=r(18113),a=r(70471),l=r(85484);class h extends o.Overlay{constructor(e,t,r,n){super(e,t,l.CLONE_INLINE_START,r,n)}createTable(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return new i.default(...t)}shouldBeRendered(){return this.wtSettings.getSetting("shouldRenderInlineStartOverlay")}resetFixedPosition(){const{wtTable:e}=this.wot;if(!this.needFullRender||!this.shouldBeRendered()||!e.holder.parentNode)return!1;const{rootWindow:t}=this.domBindings,r=this.clone.wtTable.holder.parentNode,n=this.wtSettings.getSetting("preventOverflow");let i=0;this.trimmingContainer!==t||n&&"horizontal"===n?(i=this.getScrollPosition(),(0,s.resetCssTransform)(r)):(i=this.getOverlayOffset()*(this.isRtl()?-1:1),(0,s.setOverlayPosition)(r,`${i}px`,"0px"));const o=this.adjustHeaderBordersPosition(i);return this.adjustElementsSize(),o}setScrollPosition(e){const{rootWindow:t}=this.domBindings;let r=!1;return this.isRtl()&&(e=-e),this.mainTableScrollableElement===t&&t.scrollX!==e?(t.scrollTo(e,(0,s.getWindowScrollTop)(t)),r=!0):this.mainTableScrollableElement.scrollLeft!==e&&(this.mainTableScrollableElement.scrollLeft=e,r=!0),r}onScroll(){this.wtSettings.getSetting("onScrollVertically")}sumCellSizes(e,t){const r=this.wtSettings.getSetting("defaultColumnWidth");let n=e,s=0;for(;n<t;)s+=this.wot.wtTable.getColumnWidth(n)||r,n+=1;return s}adjustElementsSize(){this.updateTrimmingContainer(),this.needFullRender&&(this.adjustRootElementSize(),this.adjustRootChildrenSize())}adjustRootElementSize(){const{wtTable:e,wtViewport:t}=this.wot,{rootDocument:r,rootWindow:n}=this.domBindings,i=this.clone.wtTable.holder.parentNode.style,o=this.wtSettings.getSetting("preventOverflow");if(this.trimmingContainer!==n||"vertical"===o){let n=t.getWorkspaceHeight();t.hasHorizontalScroll()&&(n-=(0,s.getScrollbarWidth)(r)),n=Math.min(n,e.wtRootElement.scrollHeight),i.height=`${n}px`}else i.height="";this.clone.wtTable.holder.style.height=i.height;const a=(0,s.outerWidth)(this.clone.wtTable.TABLE);i.width=`${a}px`}adjustRootChildrenSize(){const{holder:e}=this.clone.wtTable,t=(0,a.getCornerStyle)(this.wot),r=this.wot.selectionManager.getFocusSelection()?parseInt(t.width,10)/2:0;this.clone.wtTable.hider.style.height=this.hider.style.height,e.style.height=e.parentNode.style.height,e.style.width=`${parseInt(e.parentNode.style.width,10)+r}px`}applyToDOM(){const e=this.wtSettings.getSetting("totalColumns"),t=this.isRtl()?"right":"left";if("number"==typeof this.wot.wtViewport.columnsRenderCalculator.startPosition)this.spreader.style[t]=`${this.wot.wtViewport.columnsRenderCalculator.startPosition}px`;else{if(0!==e)throw new Error("Incorrect value of the columnsRenderCalculator");this.spreader.style[t]="0"}this.isRtl()?this.spreader.style.left="":this.spreader.style.right="",this.needFullRender&&this.syncOverlayOffset()}syncOverlayOffset(){"number"==typeof this.wot.wtViewport.rowsRenderCalculator.startPosition?this.clone.wtTable.spreader.style.top=`${this.wot.wtViewport.rowsRenderCalculator.startPosition}px`:this.clone.wtTable.spreader.style.top=""}scrollTo(e,t){const{wtSettings:r}=this,n=r.getSetting("rowHeaders"),i=r.getSetting("fixedColumnsStart"),o=(this.wot.cloneSource?this.wot.cloneSource:this.wot).wtTable.holder,a=0===i&&n.length>0&&!(0,s.hasClass)(o.parentNode,"innerBorderInlineStart")?1:0;let l=this.getTableParentOffset(),h=0;if(t){this.wot.wtTable.getColumnWidth(e)>this.wot.wtViewport.getViewportWidth()&&(t=!1)}return t&&o.offsetWidth!==o.clientWidth&&(h=(0,s.getScrollbarWidth)(this.domBindings.rootDocument)),t?(l+=this.sumCellSizes(0,e+1),l-=this.wot.wtViewport.getViewportWidth(),l+=a):l+=this.sumCellSizes(this.wtSettings.getSetting("fixedColumnsStart"),e),l+=h,(0,s.getMaximumScrollLeft)(this.mainTableScrollableElement)===l-a&&a>0&&this.wot.wtOverlays.expandHiderHorizontallyBy(a),this.setScrollPosition(l)}getTableParentOffset(){let e=0;return this.wtSettings.getSetting("preventOverflow")||this.trimmingContainer!==this.domBindings.rootWindow||(e=this.wot.wtTable.holderOffset.left),e}getScrollPosition(){return Math.abs((0,s.getScrollLeft)(this.mainTableScrollableElement,this.domBindings.rootWindow))}getOverlayOffset(){const{rootWindow:e}=this.domBindings,t=this.wtSettings.getSetting("preventOverflow");let r=0;if(this.trimmingContainer===e&&(!t||"horizontal"!==t)){r=this.isRtl()?Math.abs(Math.min(this.getTableParentOffset()-this.getScrollPosition(),0)):Math.max(this.getScrollPosition()-this.getTableParentOffset(),0);r>this.wot.wtTable.getTotalWidth()-this.clone.wtTable.getTotalWidth()&&(r=0)}return r}adjustHeaderBordersPosition(e){const{wtSettings:t}=this,r=this.wot.wtTable.holder.parentNode,n=t.getSetting("rowHeaders"),i=t.getSetting("fixedColumnsStart"),o=t.getSetting("totalRows"),a="vertical"===t.getSetting("preventOverflow");o?(0,s.removeClass)(r,"emptyRows"):(0,s.addClass)(r,"emptyRows");let l=!1;if(!a)if(i&&!n.length)(0,s.addClass)(r,"innerBorderLeft innerBorderInlineStart");else if(!i&&n.length){const t=(0,s.hasClass)(r,"innerBorderInlineStart");e?((0,s.addClass)(r,"innerBorderLeft innerBorderInlineStart"),l=!t):((0,s.removeClass)(r,"innerBorderLeft innerBorderInlineStart"),l=t)}return l}}t.InlineStartOverlay=h},73114:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),i=r(62577),o=n(r(94318)),a=r(18113),l=r(70471),h=r(85484);class u extends a.Overlay{constructor(e,t,r,n){super(e,t,h.CLONE_TOP,r,n),(0,s.default)(this,"cachedFixedRowsTop",-1),this.cachedFixedRowsTop=this.wtSettings.getSetting("fixedRowsTop")}createTable(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return new o.default(...t)}shouldBeRendered(){return this.wtSettings.getSetting("shouldRenderTopOverlay")}resetFixedPosition(){if(!this.needFullRender||!this.shouldBeRendered()||!this.wot.wtTable.holder.parentNode)return!1;const e=this.clone.wtTable.holder.parentNode,{rootWindow:t}=this.domBindings,r=this.wtSettings.getSetting("preventOverflow");let n=0,s=!1;if(this.trimmingContainer!==t||r&&"vertical"===r)n=this.getScrollPosition(),(0,i.resetCssTransform)(e);else{const{wtTable:t}=this.wot,r=t.hider.getBoundingClientRect();s=Math.ceil(r.bottom)===e.offsetHeight,n=this.getOverlayOffset(),(0,i.setOverlayPosition)(e,"0px",`${n}px`)}const o=this.adjustHeaderBordersPosition(n,s);return this.adjustElementsSize(),o}setScrollPosition(e){const t=this.domBindings.rootWindow;let r=!1;return this.mainTableScrollableElement===t&&t.scrollY!==e?(t.scrollTo((0,i.getWindowScrollLeft)(t),e),r=!0):this.mainTableScrollableElement.scrollTop!==e&&(this.mainTableScrollableElement.scrollTop=e,r=!0),r}onScroll(){this.wtSettings.getSetting("onScrollHorizontally")}sumCellSizes(e,t){const r=this.wot.stylesHandler.getDefaultRowHeight();let n=e,s=0;for(;n<t;){const e=this.wot.wtTable.getRowHeight(n);s+=void 0===e?r:e,n+=1}return s}adjustElementsSize(){this.updateTrimmingContainer(),this.needFullRender&&(this.adjustRootElementSize(),this.adjustRootChildrenSize())}adjustRootElementSize(){const{wtTable:e,wtViewport:t}=this.wot,{rootDocument:r,rootWindow:n}=this.domBindings,s=this.clone.wtTable.holder.parentNode.style,o=this.wtSettings.getSetting("preventOverflow");if(this.trimmingContainer!==n||"horizontal"===o){let n=t.getWorkspaceWidth();t.hasVerticalScroll()&&(n-=(0,i.getScrollbarWidth)(r)),n=Math.min(n,e.wtRootElement.scrollWidth),s.width=`${n}px`}else s.width="";this.clone.wtTable.holder.style.width=s.width;let a=(0,i.outerHeight)(this.clone.wtTable.TABLE);e.hasDefinedSize()||(a=0),s.height=`${a}px`}adjustRootChildrenSize(){const{holder:e}=this.clone.wtTable,t=(0,l.getCornerStyle)(this.wot),r=this.wot.selectionManager.getFocusSelection()?parseInt(t.height,10)/2:0;this.clone.wtTable.hider.style.width=this.hider.style.width,e.style.width=e.parentNode.style.width,e.style.height=`${parseInt(e.parentNode.style.height,10)+r}px`}applyToDOM(){const e=this.wtSettings.getSetting("totalRows");if("number"==typeof this.wot.wtViewport.rowsRenderCalculator.startPosition)this.spreader.style.top=`${this.wot.wtViewport.rowsRenderCalculator.startPosition}px`;else{if(0!==e)throw new Error("Incorrect value of the rowsRenderCalculator");this.spreader.style.top="0"}this.spreader.style.bottom="",this.needFullRender&&this.syncOverlayOffset()}syncOverlayOffset(){const e=this.isRtl()?"right":"left",{spreader:t}=this.clone.wtTable;"number"==typeof this.wot.wtViewport.columnsRenderCalculator.startPosition?t.style[e]=`${this.wot.wtViewport.columnsRenderCalculator.startPosition}px`:t.style[e]=""}scrollTo(e,t){const{wot:r,wtSettings:n}=this,s=(r.cloneSource?r.cloneSource:r).wtTable.holder,o=n.getSetting("columnHeaders"),a=0===n.getSetting("fixedRowsTop")&&o.length>0&&!(0,i.hasClass)(s.parentNode,"innerBorderTop")?1:0;let l=this.getTableParentOffset(),h=0;if(t){this.wot.wtTable.getRowHeight(e)>this.wot.wtViewport.getViewportHeight()&&(t=!1)}if(t&&s.offsetHeight!==s.clientHeight&&(h=(0,i.getScrollbarWidth)(this.domBindings.rootDocument)),t){const t=n.getSetting("fixedRowsBottom"),s=n.getSetting("totalRows");l+=this.sumCellSizes(0,e+1),l-=r.wtViewport.getViewportHeight()-this.sumCellSizes(s-t,s),l+=1,l+=a}else l+=this.sumCellSizes(n.getSetting("fixedRowsTop"),e);return l+=h,(0,i.getMaximumScrollTop)(this.mainTableScrollableElement)===l-a&&a>0&&this.wot.wtOverlays.expandHiderVerticallyBy(a),this.setScrollPosition(l)}getTableParentOffset(){return this.mainTableScrollableElement===this.domBindings.rootWindow?this.wot.wtTable.holderOffset.top:0}getScrollPosition(){return(0,i.getScrollTop)(this.mainTableScrollableElement,this.domBindings.rootWindow)}getOverlayOffset(){const{rootWindow:e}=this.domBindings,t=this.wtSettings.getSetting("preventOverflow");let r=0;if(this.trimmingContainer===e&&(!t||"vertical"!==t)){const e=this.wot.wtTable.getTotalHeight()-this.clone.wtTable.getTotalHeight();r=Math.max(this.getScrollPosition()-this.getTableParentOffset(),0),r>e&&(r=0)}return r}adjustHeaderBordersPosition(e){let t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];const{wtSettings:r}=this,n=this.wot.wtTable.holder.parentNode,s=r.getSetting("totalColumns"),o="horizontal"===r.getSetting("preventOverflow");s?(0,i.removeClass)(n,"emptyColumns"):(0,i.addClass)(n,"emptyColumns");let a=!1;if(!t&&!o){const t=r.getSetting("fixedRowsTop"),s=this.cachedFixedRowsTop!==t,o=r.getSetting("columnHeaders");if((s||0===t)&&o.length>0){const t=(0,i.hasClass)(n,"innerBorderTop");this.cachedFixedRowsTop=r.getSetting("fixedRowsTop"),e||0===r.getSetting("totalRows")?((0,i.addClass)(n,"innerBorderTop"),a=!t):((0,i.removeClass)(n,"innerBorderTop"),a=t)}}return a}}t.TopOverlay=u},76922:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),i=r(62577),o=n(r(16318)),a=r(18113),l=r(85484);class h extends a.Overlay{constructor(e,t,r,n,i,o){super(e,t,l.CLONE_TOP_INLINE_START_CORNER,r,n),(0,s.default)(this,"topOverlay",void 0),(0,s.default)(this,"inlineStartOverlay",void 0),this.topOverlay=i,this.inlineStartOverlay=o}createTable(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return new o.default(...t)}shouldBeRendered(){return this.wtSettings.getSetting("shouldRenderTopOverlay")&&this.wtSettings.getSetting("shouldRenderInlineStartOverlay")}resetFixedPosition(){if(this.updateTrimmingContainer(),!this.wot.wtTable.holder.parentNode)return!1;const e=this.clone.wtTable.holder.parentNode;if(this.trimmingContainer===this.domBindings.rootWindow){const t=this.inlineStartOverlay.getOverlayOffset()*(this.isRtl()?-1:1),r=this.topOverlay.getOverlayOffset();(0,i.setOverlayPosition)(e,`${t}px`,`${r}px`)}else(0,i.resetCssTransform)(e);let t=(0,i.outerHeight)(this.clone.wtTable.TABLE);const r=(0,i.outerWidth)(this.clone.wtTable.TABLE);return this.wot.wtTable.hasDefinedSize()||(t=0),e.style.height=`${t}px`,e.style.width=`${r}px`,!1}}t.TopInlineStartCornerOverlay=h},66925:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724),r(14846),r(69655),r(90458);var s=n(r(85707)),i=r(62577),o=r(85992),a=r(10587),l=r(83445),h=r(25046),u=r(14859),c=r(69397);function d(e,t,r){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,r)}function p(e,t,r){return e.set(f(e,t),r),r}function g(e,t){return e.get(f(e,t))}function f(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var m=new WeakMap,y=new WeakMap,E=new WeakMap,w=new WeakMap;t.default=class{constructor(e,t,r,n,a,l){(0,s.default)(this,"wot",null),d(this,m,[]),(0,s.default)(this,"topOverlay",null),(0,s.default)(this,"bottomOverlay",null),(0,s.default)(this,"inlineStartOverlay",null),(0,s.default)(this,"topInlineStartCornerOverlay",null),(0,s.default)(this,"bottomInlineStartCornerOverlay",null),(0,s.default)(this,"browserLineHeight",void 0),(0,s.default)(this,"wtSettings",null),d(this,y,!1),d(this,E,0),d(this,w,null),(0,s.default)(this,"resizeObserver",new ResizeObserver((e=>{(0,o.requestAnimationFrame)((()=>{Array.isArray(e)&&e.length&&(p(E,this,g(E,this)+1),100===g(E,this)&&((0,u.warn)("The ResizeObserver callback was fired too many times in direct succession.\nThis may be due to an infinite loop caused by setting a dynamic height/width (for example, with the `dvh` units) to a Handsontable container's parent. \nThe observer will be disconnected."),this.resizeObserver.disconnect()),null!==g(w,this)&&clearTimeout(g(w,this)),p(w,this,setTimeout((()=>{p(E,this,0)}),100)),this.wtSettings.getSetting("onContainerElementResize"))}))}))),this.wot=e,this.wtSettings=n,this.domBindings=r,this.facadeGetter=t,this.wtTable=l;const{rootDocument:h,rootWindow:c}=this.domBindings;this.instance=this.wot,this.eventManager=a,this.scrollbarSize=(0,i.getScrollbarWidth)(h);const f="hidden"===c.getComputedStyle(l.wtRootElement.parentNode).getPropertyValue("overflow");this.scrollableElement=f?l.holder:(0,i.getScrollableElement)(l.TABLE),this.initOverlays(),this.destroyed=!1,this.keyPressed=!1,this.spreaderLastSize={width:null,height:null},this.verticalScrolling=!1,this.horizontalScrolling=!1,this.initBrowserLineHeight(),this.registerListeners(),this.lastScrollX=c.scrollX,this.lastScrollY=c.scrollY}getOverlays(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];const t=[...g(m,this)];return e&&t.push(this.wtTable),t}initBrowserLineHeight(){const{rootWindow:e,rootDocument:t}=this.domBindings,r=e.getComputedStyle(t.body),n=parseInt(r.lineHeight,10),s=1.2*parseInt(r.fontSize,10);this.browserLineHeight=n||s}initOverlays(){const e=[this.wot,this.facadeGetter,this.wtSettings,this.domBindings];this.topOverlay=new c.TopOverlay(...e),this.bottomOverlay=new c.BottomOverlay(...e),this.inlineStartOverlay=new c.InlineStartOverlay(...e),this.topInlineStartCornerOverlay=new c.TopInlineStartCornerOverlay(...e,this.topOverlay,this.inlineStartOverlay),this.bottomInlineStartCornerOverlay=new c.BottomInlineStartCornerOverlay(...e,this.bottomOverlay,this.inlineStartOverlay),p(m,this,[this.topOverlay,this.bottomOverlay,this.inlineStartOverlay,this.topInlineStartCornerOverlay,this.bottomInlineStartCornerOverlay])}beforeDraw(){p(y,this,g(m,this).reduce(((e,t)=>t.hasRenderingStateChanged()||e),!1)),g(m,this).forEach((e=>e.updateStateOfRendering("before")))}afterDraw(){this.syncScrollWithMaster(),g(m,this).forEach((e=>{const t=e.hasRenderingStateChanged();e.updateStateOfRendering("after"),t&&!e.needFullRender&&e.reset()}))}refreshAll(){this.wot.drawn&&(this.wtTable.holder.parentNode?(this.wot.draw(!0),this.verticalScrolling&&this.inlineStartOverlay.onScroll(),this.horizontalScrolling&&this.topOverlay.onScroll(),this.verticalScrolling=!1,this.horizontalScrolling=!1):this.destroy())}registerListeners(){const{rootDocument:e,rootWindow:t}=this.domBindings,{mainTableScrollableElement:r}=this.topOverlay,{mainTableScrollableElement:n}=this.inlineStartOverlay;this.eventManager.addEventListener(e.documentElement,"keydown",(e=>this.onKeyDown(e))),this.eventManager.addEventListener(e.documentElement,"keyup",(()=>this.onKeyUp())),this.eventManager.addEventListener(e,"visibilitychange",(()=>this.onKeyUp())),this.eventManager.addEventListener(r,"scroll",(e=>this.onTableScroll(e)),{passive:!0}),r!==n&&this.eventManager.addEventListener(n,"scroll",(e=>this.onTableScroll(e)),{passive:!0});const s=t.devicePixelRatio&&t.devicePixelRatio>1,i=this.scrollableElement===t,a=this.wtSettings.getSetting("preventWheel"),l={passive:i};(a||s||!(0,h.isChrome)())&&this.eventManager.addEventListener(this.wtTable.wtRootElement,"wheel",(e=>this.onCloneWheel(e,a)),l);let u;[this.topOverlay,this.bottomOverlay,this.inlineStartOverlay,this.topInlineStartCornerOverlay,this.bottomInlineStartCornerOverlay].forEach((e=>{if(e&&e.needFullRender){const{holder:t}=e.clone.wtTable;this.eventManager.addEventListener(t,"wheel",(e=>this.onCloneWheel(e,a)),l)}})),this.eventManager.addEventListener(t,"resize",(()=>{(0,o.requestAnimationFrame)((()=>{clearTimeout(u),this.wtSettings.getSetting("onWindowResize"),u=setTimeout((()=>{p(E,this,0)}),200)}))})),i||this.resizeObserver.observe(this.wtTable.wtRootElement.parentElement)}deregisterListeners(){this.eventManager.clearEvents(!0)}onTableScroll(e){const t=this.domBindings.rootWindow,r=this.inlineStartOverlay.mainTableScrollableElement,n=this.topOverlay.mainTableScrollableElement,s=e.target;this.keyPressed&&(n!==t&&s!==t&&!e.target.contains(n)||r!==t&&s!==t&&!e.target.contains(r))||this.syncScrollPositions(e)}onCloneWheel(e,t){const{rootWindow:r}=this.domBindings,n=this.inlineStartOverlay.mainTableScrollableElement,s=this.topOverlay.mainTableScrollableElement,i=e.target,o=s!==r&&i!==r&&!i.contains(s),a=n!==r&&i!==r&&!i.contains(n);if(this.keyPressed&&(o||a)||this.scrollableElement===r)return;const l=this.translateMouseWheelToScroll(e);(t||this.scrollableElement!==r&&l)&&e.preventDefault()}onKeyDown(e){this.keyPressed=(0,l.isKey)(e.keyCode,"ARROW_UP|ARROW_RIGHT|ARROW_DOWN|ARROW_LEFT")}onKeyUp(){this.keyPressed=!1}translateMouseWheelToScroll(e){let t=isNaN(e.deltaY)?-1*e.wheelDeltaY:e.deltaY,r=isNaN(e.deltaX)?-1*e.wheelDeltaX:e.deltaX;1===e.deltaMode&&(r+=r*this.browserLineHeight,t+=t*this.browserLineHeight);const n=this.scrollVertically(t),s=this.scrollHorizontally(r);return n||s}scrollVertically(e){const t=this.scrollableElement.scrollTop;return this.scrollableElement.scrollTop+=e,t!==this.scrollableElement.scrollTop}scrollHorizontally(e){const t=this.scrollableElement.scrollLeft;return this.scrollableElement.scrollLeft+=e,t!==this.scrollableElement.scrollLeft}syncScrollPositions(){if(this.destroyed)return;const{rootWindow:e}=this.domBindings,t=this.topOverlay.clone.wtTable.holder,r=this.inlineStartOverlay.clone.wtTable.holder,[n,s]=[this.scrollableElement.scrollLeft,this.scrollableElement.scrollTop];if(this.horizontalScrolling=t.scrollLeft!==n||this.lastScrollX!==e.scrollX,this.verticalScrolling=r.scrollTop!==s||this.lastScrollY!==e.scrollY,this.lastScrollX=e.scrollX,this.lastScrollY=e.scrollY,this.horizontalScrolling){t.scrollLeft=n;const e=this.bottomOverlay.needFullRender?this.bottomOverlay.clone.wtTable.holder:null;e&&(e.scrollLeft=n)}this.verticalScrolling&&(r.scrollTop=s),this.refreshAll()}syncScrollWithMaster(){if(!g(y,this))return;const e=this.topOverlay.mainTableScrollableElement,{scrollLeft:t,scrollTop:r}=e;this.topOverlay.needFullRender&&(this.topOverlay.clone.wtTable.holder.scrollLeft=t),this.bottomOverlay.needFullRender&&(this.bottomOverlay.clone.wtTable.holder.scrollLeft=t),this.inlineStartOverlay.needFullRender&&(this.inlineStartOverlay.clone.wtTable.holder.scrollTop=r),p(y,this,!1)}updateMainScrollableElements(){this.deregisterListeners(),this.inlineStartOverlay.updateMainScrollableElement(),this.topOverlay.updateMainScrollableElement(),this.bottomOverlay.needFullRender&&this.bottomOverlay.updateMainScrollableElement();const{wtTable:e}=this,{rootWindow:t}=this.domBindings;"hidden"===t.getComputedStyle(e.wtRootElement.parentNode).getPropertyValue("overflow")?this.scrollableElement=e.holder:this.scrollableElement=(0,i.getScrollableElement)(e.TABLE),this.registerListeners()}destroy(){this.resizeObserver.disconnect(),this.eventManager.destroy(),this.topOverlay.destroy(),this.bottomOverlay.clone&&this.bottomOverlay.destroy(),this.inlineStartOverlay.destroy(),this.topInlineStartCornerOverlay&&this.topInlineStartCornerOverlay.destroy(),this.bottomInlineStartCornerOverlay&&this.bottomInlineStartCornerOverlay.clone&&this.bottomInlineStartCornerOverlay.destroy(),this.destroyed=!0}refresh(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];this.updateLastSpreaderSize()&&this.adjustElementsSize(),this.bottomOverlay.clone&&this.bottomOverlay.refresh(e),this.inlineStartOverlay.refresh(e),this.topOverlay.refresh(e),this.topInlineStartCornerOverlay&&this.topInlineStartCornerOverlay.refresh(e),this.bottomInlineStartCornerOverlay&&this.bottomInlineStartCornerOverlay.clone&&this.bottomInlineStartCornerOverlay.refresh(e)}updateLastSpreaderSize(){const e=this.wtTable.spreader,t=e.clientWidth,r=e.clientHeight,n=t!==this.spreaderLastSize.width||r!==this.spreaderLastSize.height;return n&&(this.spreaderLastSize.width=t,this.spreaderLastSize.height=r),n}adjustElementsSize(){const{wtViewport:e}=this.wot,{wtTable:t}=this,{rootWindow:r}=this.domBindings,n=this.scrollableElement===r,s=this.wtSettings.getSetting("totalColumns"),i=this.wtSettings.getSetting("totalRows"),o=e.getRowHeaderWidth(),a=e.getColumnHeaderHeight()+this.topOverlay.sumCellSizes(0,i)+1,l=o+this.inlineStartOverlay.sumCellSizes(0,s),h=t.hider.style,u=(()=>!n&&this.scrollableElement.scrollTop>Math.max(0,a-t.holder.clientHeight))()?1:0,c=(()=>!n&&this.scrollableElement.scrollLeft>Math.max(0,l-t.holder.clientWidth))()?1:0;h.width=`${l+c}px`,h.height=`${a+u}px`,this.topOverlay.adjustElementsSize(),this.inlineStartOverlay.adjustElementsSize(),this.bottomOverlay.adjustElementsSize()}expandHiderVerticallyBy(e){const{wtTable:t}=this;t.hider.style.height=`${parseInt(t.hider.style.height,10)+e}px`}expandHiderHorizontallyBy(e){const{wtTable:t}=this;t.hider.style.width=`${parseInt(t.hider.style.width,10)+e}px`}applyToDOM(){this.wtTable.isVisible()&&(this.topOverlay.applyToDOM(),this.bottomOverlay.clone&&this.bottomOverlay.applyToDOM(),this.inlineStartOverlay.applyToDOM())}getParentOverlay(e){if(!e)return null;const t=[this.topOverlay,this.inlineStartOverlay,this.bottomOverlay,this.topInlineStartCornerOverlay,this.bottomInlineStartCornerOverlay];let r=null;return(0,a.arrayEach)(t,(t=>{t&&t.clone&&t.clone.wtTable.TABLE.contains(e)&&(r=t.clone)})),r}syncOverlayTableClassNames(){const e=this.wtTable.TABLE,t=[this.topOverlay,this.inlineStartOverlay,this.bottomOverlay,this.topInlineStartCornerOverlay,this.bottomInlineStartCornerOverlay];(0,a.arrayEach)(t,(t=>{t&&(t.clone.wtTable.TABLE.className=e.className)}))}}},41608:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),i=n(r(76095));t.default=class{constructor(e,t){(0,s.default)(this,"nodesPool",null),(0,s.default)(this,"nodeType",void 0),(0,s.default)(this,"rootNode",void 0),(0,s.default)(this,"table",null),(0,s.default)(this,"renderedNodes",0),this.nodesPool="string"==typeof e?new i.default(e):null,this.nodeType=e,this.rootNode=t}setTable(e){this.nodesPool&&this.nodesPool.setRootDocument(e.rootDocument),this.table=e}adjust(){}render(){}}},62861:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),i=r(62577),o=r(97646),a=n(r(41608)),l=r(71120);class h extends a.default{constructor(){super("TD"),(0,s.default)(this,"orderViews",new WeakMap),(0,s.default)(this,"sourceRowIndex",0)}obtainOrderView(e){let t;return this.orderViews.has(e)?t=this.orderViews.get(e):(t=new o.SharedOrderView(e,(e=>this.nodesPool.obtain(this.sourceRowIndex,e)),this.nodeType),this.orderViews.set(e,t)),t}render(){const{rowsToRender:e,columnsToRender:t,rows:r,rowHeaders:n}=this.table;for(let a=0;a<e;a++){const e=this.table.renderedRowToSource(a),h=r.getRenderedNode(a);this.sourceRowIndex=e;const u=this.obtainOrderView(h),c=n.obtainOrderView(h);u.prependView(c).setSize(t).setOffset(this.table.renderedColumnToSource(0)).start();for(let r=0;r<t;r++){u.render();const t=u.getCurrentNode(),n=this.table.renderedColumnToSource(r);var s,o;if((0,i.hasClass)(t,"hide")||(t.className=""),t.removeAttribute("style"),t.removeAttribute("dir"),(0,i.removeAttribute)(t,[new RegExp("aria-(.*)"),new RegExp("role")]),this.table.cellRenderer(e,n,t),this.table.isAriaEnabled())(0,i.setAttribute)(t,[...t.hasAttribute("role")?[]:[(0,l.A11Y_GRIDCELL)()],(0,l.A11Y_TABINDEX)(-1),(0,l.A11Y_COLINDEX)(n+(null!==(s=null===(o=this.table.rowUtils)||void 0===o||null===(o=o.dataAccessObject)||void 0===o?void 0:o.rowHeaders.length)&&void 0!==s?s:0)+1)])}u.end()}}}t.default=h},16951:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(41608)),i=r(14859),o=r(21595),a=r(62577);let l=!1;class h extends s.default{constructor(e){super(null,e)}adjust(){const{columnsToRender:e,rowHeadersCount:t}=this.table,r=e+t;for(;this.renderedNodes<r;)this.rootNode.appendChild(this.table.rootDocument.createElement("col")),this.renderedNodes+=1;for(;this.renderedNodes>r;)this.rootNode.removeChild(this.rootNode.lastChild),this.renderedNodes-=1}render(){this.adjust();const{columnsToRender:e,rowHeadersCount:t}=this.table;!l&&e>1e3&&(l=!0,(0,i.warn)(o.toSingleLine`Performance tip: Handsontable rendered more than 1000 visible columns.\x20
        Consider limiting the number of rendered columns by specifying the table width and/or\x20
        turning off the "renderAllColumns" option.`));for(let e=0;e<t;e++){const t=this.table.renderedColumnToSource(e),r=this.table.columnUtils.getHeaderWidth(t);this.rootNode.childNodes[e].style.width=`${r}px`}for(let r=0;r<e;r++){const e=this.table.renderedColumnToSource(r),n=this.table.columnUtils.getWidth(e);this.rootNode.childNodes[r+t].style.width=`${n}px`}const r=this.rootNode.firstChild;r&&(0,a.addClass)(r,"rowHeader")}}t.default=h},75396:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=r(62577),i=n(r(41608)),o=r(71120);class a extends i.default{constructor(e){super(null,e)}adjust(){const{columnHeadersCount:e,rowHeadersCount:t}=this.table;let r=this.rootNode.firstChild;if(e){const{columnsToRender:n}=this.table,s=n+t;for(let t=0,n=e;t<n;t++){for(r=this.rootNode.childNodes[t],r||(r=this.table.rootDocument.createElement("tr"),this.rootNode.appendChild(r)),this.renderedNodes=r.childNodes.length;this.renderedNodes<s;)r.appendChild(this.table.rootDocument.createElement("th")),this.renderedNodes+=1;for(;this.renderedNodes>s;)r.removeChild(r.lastChild),this.renderedNodes-=1}const i=this.rootNode.childNodes.length;if(i>e)for(let t=e;t<i;t++)this.rootNode.removeChild(this.rootNode.lastChild)}else r&&(0,s.empty)(r)}render(){const{columnHeadersCount:e}=this.table;this.table.isAriaEnabled()&&(0,s.setAttribute)(this.rootNode,[(0,o.A11Y_ROWGROUP)()]);for(let t=0;t<e;t+=1){const{columnHeaderFunctions:e,columnsToRender:r,rowHeadersCount:n}=this.table,i=this.rootNode.childNodes[t];this.table.isAriaEnabled()&&(0,s.setAttribute)(i,[(0,o.A11Y_ROW)(),(0,o.A11Y_ROWINDEX)(t+1)]);for(let a=-1*n;a<r;a+=1){const r=this.table.renderedColumnToSource(a),l=i.childNodes[a+n];l.className="",l.removeAttribute("style"),(0,s.removeAttribute)(l,[new RegExp("aria-(.*)"),new RegExp("role")]),this.table.isAriaEnabled()&&(0,s.setAttribute)(l,[(0,o.A11Y_COLINDEX)(a+1+this.table.rowHeadersCount),(0,o.A11Y_TABINDEX)(-1),(0,o.A11Y_COLUMNHEADER)(),...a>=0?[(0,o.A11Y_SCOPE_COL)()]:[(0,o.A11Y_ROW)()]]),e[t](r,l,t)}}}}t.default=a},36936:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(59376));t.RowHeadersRenderer=s.default;var i=n(r(75396));t.ColumnHeadersRenderer=i.default;var o=n(r(16951));t.ColGroupRenderer=o.default;var a=n(r(98575));t.RowsRenderer=a.default;var l=n(r(62861));t.CellsRenderer=l.default;var h=n(r(85604));t.TableRenderer=h.default;t.Renderer=class{constructor(){let{TABLE:e,THEAD:t,COLGROUP:r,TBODY:n,rowUtils:u,columnUtils:c,cellRenderer:d,stylesHandler:p}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};this.renderer=new h.default(e,{cellRenderer:d,stylesHandler:p}),this.renderer.setRenderers({rowHeaders:new s.default,columnHeaders:new i.default(t),colGroup:new o.default(r),rows:new a.default(n),cells:new l.default}),this.renderer.setAxisUtils(u,c)}setActiveOverlayName(e){return this.renderer.setActiveOverlayName(e),this}setFilters(e,t){return this.renderer.setFilters(e,t),this}setViewportSize(e,t){return this.renderer.setViewportSize(e,t),this}setHeaderContentRenderers(e,t){return this.renderer.setHeaderContentRenderers(e,t),this}adjust(){this.renderer.adjust()}render(){this.renderer.render()}}},59376:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),i=r(97646),o=n(r(41608)),a=r(62577),l=r(71120);class h extends o.default{constructor(){super("TH"),(0,s.default)(this,"orderViews",new WeakMap),(0,s.default)(this,"sourceRowIndex",0)}obtainOrderView(e){let t;return this.orderViews.has(e)?t=this.orderViews.get(e):(t=new i.SharedOrderView(e,(e=>this.nodesPool.obtain(this.sourceRowIndex,e)),this.nodeType),this.orderViews.set(e,t)),t}render(){const{rowsToRender:e,rowHeaderFunctions:t,rowHeadersCount:r,rows:n,cells:s}=this.table;for(let i=0;i<e;i++){const e=this.table.renderedRowToSource(i),o=n.getRenderedNode(i);this.sourceRowIndex=e;const h=this.obtainOrderView(o),u=s.obtainOrderView(o);h.appendView(u).setSize(r).setOffset(this.table.renderedColumnToSource(0)).start();for(let n=0;n<r;n++){h.render();const r=h.getCurrentNode();r.className="",r.removeAttribute("style"),(0,a.removeAttribute)(r,[new RegExp("aria-(.*)"),new RegExp("role")]),this.table.isAriaEnabled()&&(0,a.setAttribute)(r,[(0,l.A11Y_ROWHEADER)(),(0,l.A11Y_SCOPE_ROW)(),(0,l.A11Y_COLINDEX)(n+1),(0,l.A11Y_TABINDEX)(-1)]),t[n](e,r,n)}h.end()}}}t.default=h},98575:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),i=n(r(41608)),o=r(14859),a=r(21595),l=r(97646),h=r(62577),u=r(71120);const c="ht__row_even",d="ht__row_odd";let p=!1;class g extends i.default{constructor(e){super("TR",e),(0,s.default)(this,"orderView",void 0),this.orderView=new l.OrderView(e,(e=>this.nodesPool.obtain(e)),this.nodeType)}getRenderedNode(e){return this.orderView.getNode(e)}render(){const{rowsToRender:e}=this.table;!p&&e>1e3&&(p=!0,(0,o.warn)(a.toSingleLine`Performance tip: Handsontable rendered more than 1000 visible rows.\x20
        Consider limiting the number of rendered rows by specifying the table height and/or\x20
        turning off the "renderAllRows" option.`)),this.table.isAriaEnabled()&&(0,h.setAttribute)(this.rootNode,[(0,u.A11Y_ROWGROUP)()]),this.orderView.setSize(e).setOffset(this.table.renderedRowToSource(0)).start();for(let n=0;n<e;n++){this.orderView.render();const e=this.orderView.getCurrentNode(),s=this.table.renderedRowToSource(n);var t,r;if(this.table.isAriaEnabled())(0,h.setAttribute)(e,[(0,u.A11Y_ROW)(),(0,u.A11Y_ROWINDEX)(s+(null!==(t=null===(r=this.table.rowUtils)||void 0===r||null===(r=r.dataAccessObject)||void 0===r?void 0:r.columnHeaders.length)&&void 0!==t?t:0)+1)]);(0,h.removeClass)(e,[c,d]),(s+1)%2==0?(0,h.addClass)(e,c):(0,h.addClass)(e,d)}this.orderView.end()}}t.default=g},85604:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.default=class{constructor(e){let{cellRenderer:t,stylesHandler:r}=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};(0,s.default)(this,"rootNode",void 0),(0,s.default)(this,"rootDocument",void 0),(0,s.default)(this,"rowHeaders",null),(0,s.default)(this,"columnHeaders",null),(0,s.default)(this,"colGroup",null),(0,s.default)(this,"rows",null),(0,s.default)(this,"cells",null),(0,s.default)(this,"rowFilter",null),(0,s.default)(this,"columnFilter",null),(0,s.default)(this,"rowUtils",null),(0,s.default)(this,"columnUtils",null),(0,s.default)(this,"rowsToRender",0),(0,s.default)(this,"columnsToRender",0),(0,s.default)(this,"rowHeaderFunctions",[]),(0,s.default)(this,"rowHeadersCount",0),(0,s.default)(this,"columnHeaderFunctions",[]),(0,s.default)(this,"columnHeadersCount",0),(0,s.default)(this,"cellRenderer",void 0),(0,s.default)(this,"activeOverlayName",void 0),(0,s.default)(this,"stylesHandler",void 0),this.rootNode=e,this.rootDocument=this.rootNode.ownerDocument,this.cellRenderer=t,this.stylesHandler=r}setActiveOverlayName(e){this.activeOverlayName=e}setAxisUtils(e,t){this.rowUtils=e,this.columnUtils=t}setViewportSize(e,t){this.rowsToRender=e,this.columnsToRender=t}setFilters(e,t){this.rowFilter=e,this.columnFilter=t}setHeaderContentRenderers(e,t){this.rowHeaderFunctions=e,this.rowHeadersCount=e.length,this.columnHeaderFunctions=t,this.columnHeadersCount=t.length}setRenderers(){let{rowHeaders:e,columnHeaders:t,colGroup:r,rows:n,cells:s}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};e.setTable(this),t.setTable(this),r.setTable(this),n.setTable(this),s.setTable(this),this.rowHeaders=e,this.columnHeaders=t,this.colGroup=r,this.rows=n,this.cells=s}renderedRowToSource(e){return this.rowFilter.renderedToSource(e)}renderedColumnToSource(e){return this.columnFilter.renderedToSource(e)}isAriaEnabled(){return this.rowUtils.wtSettings.getSetting("ariaTags")}render(){this.colGroup.adjust(),this.columnHeaders.adjust(),this.rows.adjust(),this.rowHeaders.adjust(),this.columnHeaders.render(),this.rows.render(),this.rowHeaders.render(),this.cells.render(),this.columnUtils.calculateWidths(),this.colGroup.render();const{rowsToRender:e,rows:t}=this;for(let r=0;r<e;r++){const e=t.getRenderedNode(r),n=this.rowUtils;if(e.firstChild){const t=this.renderedRowToSource(r),s=n.getHeightByOverlayName(t,this.activeOverlayName),i=this.stylesHandler.areCellsBorderBox()?0:1;e.firstChild.style.height=s?s-i+"px":""}}}}},15401:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),i=r(62577),o=r(25499);function a(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function l(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var h=new WeakSet;function u(e){const{wtSettings:t,inlineStartOverlay:r,wtTable:n,wtViewport:s,totalColumns:o,rootWindow:a}=this.dataAccessObject;if(r.mainTableScrollableElement===a){let l=null;if(t.getSetting("rtlMode")){const e=n.TABLE.getBoundingClientRect(),t=this.dataAccessObject.rootWindow.document.documentElement.offsetWidth;l=Math.abs(e.right-t)}else{l=(0,i.offset)(n.wtRootElement).left}const h=Math.abs((0,i.getScrollLeft)(a,a));if(l>h){const t=(0,i.innerWidth)(a);let n=s.getRowHeaderWidth();for(let s=1;s<=o;s++)if(n+=r.sumCellSizes(s-1,s),l+n-h>=t){e=s-2;break}}}return e}function c(e){const{topOverlay:t,wtTable:r,wtViewport:n,totalRows:s,rootWindow:o}=this.dataAccessObject;if(t.mainTableScrollableElement===o){const a=(0,i.offset)(r.wtRootElement),l=(0,i.getScrollTop)(o,o);if(a.top>l){const r=(0,i.innerHeight)(o);let h=n.getColumnHeaderHeight();for(let n=1;n<=s;n++)if(h+=t.sumCellSizes(n-1,n),a.top+h-l>=r){e=n-2;break}}}return e}t.default=class{constructor(e){a(this,h),(0,s.default)(this,"dataAccessObject",void 0),this.dataAccessObject=e}scrollViewport(e,t,r){if(e.col<0||e.row<0)return!1;const n=this.scrollViewportHorizontally(e.col,t),s=this.scrollViewportVertically(e.row,r);return n||s}scrollViewportHorizontally(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"auto";const{drawn:r,totalColumns:n}=this.dataAccessObject;if(!r)return!1;const s=(0,o.createObjectPropListener)(t);if(e=this.dataAccessObject.wtSettings.getSetting("onBeforeViewportScrollHorizontally",e,s),!Number.isInteger(e)||e<0||e>n)return!1;t=s.value;const{fixedColumnsStart:i,inlineStartOverlay:a}=this.dataAccessObject,l="auto"===t;if(l&&e<i)return!1;const h=this.getFirstVisibleColumn(),u=this.getLastVisibleColumn();let c=!1;return(l&&(e<h||e>u)||!l)&&(c=a.scrollTo(e,l?e>=this.getLastPartiallyVisibleColumn():"end"===t)),c}scrollViewportVertically(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"auto";const{drawn:r,totalRows:n}=this.dataAccessObject;if(!r)return!1;const s=(0,o.createObjectPropListener)(t);if(e=this.dataAccessObject.wtSettings.getSetting("onBeforeViewportScrollVertically",e,s),!Number.isInteger(e)||e<0||e>n)return!1;t=s.value;const{fixedRowsBottom:i,fixedRowsTop:a,topOverlay:l}=this.dataAccessObject,h="auto"===t;if(h&&(e<a||e>n-i-1))return!1;const u=this.getFirstVisibleRow(),c=this.getLastVisibleRow();let d=!1;return(h&&(e<u||e>c)||!h)&&(d=l.scrollTo(e,h?e>=this.getLastPartiallyVisibleRow():"bottom"===t)),d}getFirstVisibleRow(){return this.dataAccessObject.wtTable.getFirstVisibleRow()}getLastVisibleRow(){return l(h,this,c).call(this,this.dataAccessObject.wtTable.getLastVisibleRow())}getFirstPartiallyVisibleRow(){return this.dataAccessObject.wtTable.getFirstPartiallyVisibleRow()}getLastPartiallyVisibleRow(){return l(h,this,c).call(this,this.dataAccessObject.wtTable.getLastPartiallyVisibleRow())}getFirstVisibleColumn(){return this.dataAccessObject.wtTable.getFirstVisibleColumn()}getLastVisibleColumn(){return l(h,this,u).call(this,this.dataAccessObject.wtTable.getLastVisibleColumn())}getFirstPartiallyVisibleColumn(){return this.dataAccessObject.wtTable.getFirstPartiallyVisibleColumn()}getLastPartiallyVisibleColumn(){return l(h,this,u).call(this,this.dataAccessObject.wtTable.getLastPartiallyVisibleColumn())}}},32506:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(62577),s=r(77661),i=r(25499),o=r(25046),a=r(38087);t.default=class{constructor(e,t){t&&(this.eventManager=e.eventManager,this.instance=e,this.wot=e,this.settings=t,this.mouseDown=!1,this.main=null,this.top=null,this.bottom=null,this.start=null,this.end=null,this.topStyle=null,this.bottomStyle=null,this.startStyle=null,this.endStyle=null,this.cornerDefaultStyle=(0,a.getCornerStyle)(this.instance),this.cornerCenterPointOffset=-Math.ceil(parseInt(this.cornerDefaultStyle.width,10)/2),this.corner=null,this.cornerStyle=null,this.createBorders(t),this.registerListeners())}registerListeners(){const e=this.wot.rootDocument.body;this.eventManager.addEventListener(e,"mousedown",(()=>this.onMouseDown())),this.eventManager.addEventListener(e,"mouseup",(()=>this.onMouseUp()));for(let e=0,t=this.main.childNodes.length;e<t;e++){const t=this.main.childNodes[e];this.eventManager.addEventListener(t,"mouseenter",(t=>this.onMouseEnter(t,this.main.childNodes[e])))}}onMouseDown(){this.mouseDown=!0}onMouseUp(){this.mouseDown=!1}onMouseEnter(e,t){if(!this.mouseDown||!this.wot.getSetting("hideBorderOnMouseDownOver"))return;e.preventDefault(),(0,s.stopImmediatePropagation)(e);const r=this,n=this.wot.rootDocument.body,i=t.getBoundingClientRect();t.style.display="none",this.eventManager.addEventListener(n,"mousemove",(function e(s){var o;((o=s).clientY<Math.floor(i.top)||o.clientY>Math.ceil(i.top+i.height)||o.clientX<Math.floor(i.left)||o.clientX>Math.ceil(i.left+i.width))&&(r.eventManager.removeEventListener(n,"mousemove",e),t.style.display="block")}))}createBorders(e){const{rootDocument:t}=this.wot;this.main=t.createElement("div");const r=["top","start","bottom","end","corner"];let n=this.main.style;n.position="absolute",n.top=0,n.left=0;for(let s=0;s<5;s++){const i=r[s],o=t.createElement("div");o.className=`wtBorder ${this.settings.className||""}`,this.settings[i]&&this.settings[i].hide&&(o.className+=" hidden"),n=o.style,n.backgroundColor=this.settings[i]&&this.settings[i].color?this.settings[i].color:e.border.color,n.height=this.settings[i]&&this.settings[i].width?`${this.settings[i].width}px`:`${e.border.width}px`,n.width=this.settings[i]&&this.settings[i].width?`${this.settings[i].width}px`:`${e.border.width}px`,this.main.appendChild(o)}this.top=this.main.childNodes[0],this.start=this.main.childNodes[1],this.bottom=this.main.childNodes[2],this.end=this.main.childNodes[3],this.topStyle=this.top.style,this.startStyle=this.start.style,this.bottomStyle=this.bottom.style,this.endStyle=this.end.style,this.corner=this.main.childNodes[4],this.corner.className+=" corner",this.cornerStyle=this.corner.style,this.cornerStyle.width=`${this.cornerDefaultStyle.width}px`,this.cornerStyle.height=`${this.cornerDefaultStyle.height}px`,this.cornerStyle.border=[`${this.cornerDefaultStyle.borderWidth}px`,this.cornerDefaultStyle.borderStyle,this.cornerDefaultStyle.borderColor].join(" "),(0,o.isMobileBrowser)()&&this.instance.getSetting("isDataViewInstance")&&this.createMultipleSelectorHandles(),this.disappear();const{wtTable:s}=this.wot;let i=s.bordersHolder;i||(i=t.createElement("div"),i.className="htBorders",s.bordersHolder=i,s.spreader.appendChild(i)),i.appendChild(this.main)}createMultipleSelectorHandles(){const{rootDocument:e}=this.wot;this.selectionHandles={top:e.createElement("DIV"),topHitArea:e.createElement("DIV"),bottom:e.createElement("DIV"),bottomHitArea:e.createElement("DIV")};this.selectionHandles.top.className="topSelectionHandle topLeftSelectionHandle",this.selectionHandles.topHitArea.className="topSelectionHandle-HitArea topLeftSelectionHandle-HitArea",this.selectionHandles.bottom.className="bottomSelectionHandle bottomRightSelectionHandle",this.selectionHandles.bottomHitArea.className="bottomSelectionHandle-HitArea bottomRightSelectionHandle-HitArea",this.selectionHandles.styles={top:this.selectionHandles.top.style,topHitArea:this.selectionHandles.topHitArea.style,bottom:this.selectionHandles.bottom.style,bottomHitArea:this.selectionHandles.bottomHitArea.style};const t={position:"absolute",height:"40px",width:"40px","border-radius":`${parseInt(40/1.5,10)}px`};(0,i.objectEach)(t,((e,t)=>{this.selectionHandles.styles.bottomHitArea[t]=e,this.selectionHandles.styles.topHitArea[t]=e}));const r={position:"absolute",height:"10px",width:"10px","border-radius":`${parseInt(10/1.5,10)}px`,background:"#F5F5FF",border:"1px solid #4285c8"};(0,i.objectEach)(r,((e,t)=>{this.selectionHandles.styles.bottom[t]=e,this.selectionHandles.styles.top[t]=e})),this.main.appendChild(this.selectionHandles.top),this.main.appendChild(this.selectionHandles.bottom),this.main.appendChild(this.selectionHandles.topHitArea),this.main.appendChild(this.selectionHandles.bottomHitArea)}isPartRange(e,t){const r=this.wot.selectionManager.getAreaSelection();return!(!r.cellRange||e===r.cellRange.to.row&&t===r.cellRange.to.col)}updateMultipleSelectionHandlesPosition(e,t,r,n,s,i){const o=this.wot.wtSettings.getSetting("rtlMode")?"right":"left",{top:a,topHitArea:l,bottom:h,bottomHitArea:u}=this.selectionHandles.styles,c=parseInt(a.borderWidth,10),d=parseInt(a.width,10),p=parseInt(l.width,10),g=this.wot.wtTable.getWidth(),f=this.wot.wtTable.getHeight();a.top=`${parseInt(r-d-1,10)}px`,a[o]=`${parseInt(n-d-1,10)}px`,l.top=`${parseInt(r-p/4*3,10)}px`,l[o]=`${parseInt(n-p/4*3,10)}px`;const m=Math.min(parseInt(n+s,10),g-d-2*c),y=Math.min(parseInt(n+s-p/4,10),g-p-2*c);h[o]=`${m}px`,u[o]=`${y}px`;const E=Math.min(parseInt(r+i,10),f-d-2*c),w=Math.min(parseInt(r+i-p/4,10),f-p-2*c);h.top=`${E}px`,u.top=`${w}px`,this.settings.border.cornerVisible&&this.settings.border.cornerVisible()?(a.display="block",l.display="block",this.isPartRange(e,t)?(h.display="none",u.display="none"):(h.display="block",u.display="block")):(a.display="none",h.display="none",l.display="none",u.display="none"),e===this.wot.wtSettings.getSetting("fixedRowsTop")||t===this.wot.wtSettings.getSetting("fixedColumnsStart")?(a.zIndex="9999",l.zIndex="9999"):(a.zIndex="",l.zIndex="")}appear(e){if(this.disabled)return;let[t,r,s,i]=e;if(t<0&&s<0||r<0&&i<0)return void this.disappear();const{wtTable:a,rootDocument:l,rootWindow:h}=this.wot,u=t!==s||r!==i,c=a.getFirstRenderedRow(),d=a.getLastRenderedRow(),p=a.getFirstRenderedColumn(),g=a.getLastRenderedColumn();let f;if(u){if(r=Math.max(r,p),i=Math.min(i,g),t=Math.max(t,c),s=Math.min(s,d),i<r||s<t)return void this.disappear();f=a.getCell(this.wot.createCellCoords(t,r))}else if(f=a.getCell(this.wot.createCellCoords(t,r)),!(f instanceof HTMLElement))return void this.disappear();const m=u?a.getCell(this.wot.createCellCoords(s,i)):f,y=(0,n.offset)(f),E=u?(0,n.offset)(m):y,w=(0,n.offset)(a.TABLE),C=y.top,v=y.left,R=this.wot.wtSettings.getSetting("rtlMode");let S=0,T=0;if(R){const e=(0,n.outerWidth)(a.TABLE),t=(0,n.outerWidth)(f),r=h.innerWidth-w.left-e;T=v+t-E.left,S=h.innerWidth-v-t-r-1}else T=E.left+(0,n.outerWidth)(m)-v,S=v-w.left-1;if(this.isEntireColumnSelected(t,s)){const e=t,n=this.getDimensionsFromHeader("columns",r,i,e,w);let s=null;n&&([s,S,T]=n),s&&(f=s)}let N=C-w.top-1,M=E.top+(0,n.outerHeight)(m)-C;if(this.isEntireRowSelected(r,i)){const e=r,n=this.getDimensionsFromHeader("rows",t,s,e,w);let i=null;n&&([i,N,M]=n),i&&(f=i)}const _=h.getComputedStyle(f);parseInt(_.borderTopWidth,10)>0&&(N+=1,M=M>0?M-1:0),parseInt(_[R?"borderRightWidth":"borderLeftWidth"],10)>0&&(S+=1,T=T>0?T-1:0);const b=R?"right":"left";this.topStyle.top=`${N}px`,this.topStyle[b]=`${S}px`,this.topStyle.width=`${T}px`,this.topStyle.display="block",this.startStyle.top=`${N}px`,this.startStyle[b]=`${S}px`,this.startStyle.height=`${M}px`,this.startStyle.display="block";const A=Math.floor(this.settings.border.width/2);this.bottomStyle.top=N+M-A+"px",this.bottomStyle[b]=`${S}px`,this.bottomStyle.width=`${T}px`,this.bottomStyle.display="block",this.endStyle.top=`${N}px`,this.endStyle[b]=S+T-A+"px",this.endStyle.height=`${M+1}px`,this.endStyle.display="block";let O=this.settings.border.cornerVisible;O="function"==typeof O?O(this.settings.layerLevel):O;const I=this.wot.getSetting("onModifyGetCellCoords",s,i,!1,"render");let[x,P]=[s,i];if(I&&Array.isArray(I)&&([,,x,P]=I),(0,o.isMobileBrowser)()||!O||this.isPartRange(x,P))this.cornerStyle.display="none";else{this.cornerStyle.top=N+M+this.cornerCenterPointOffset-this.cornerDefaultStyle.borderWidth+"px",this.cornerStyle[b]=S+T+this.cornerCenterPointOffset-this.cornerDefaultStyle.borderWidth+"px",this.cornerStyle.borderRightWidth=`${this.cornerDefaultStyle.borderWidth}px`,this.cornerStyle.borderLeftWidth=`${this.cornerDefaultStyle.borderWidth}px`,this.cornerStyle.borderBottomWidth=`${this.cornerDefaultStyle.borderWidth}px`,this.cornerStyle.width=this.cornerDefaultStyle.width,this.cornerStyle.display="none";let e=(0,n.getTrimmingContainer)(a.TABLE);const t=e===h;t&&(e=l.documentElement);const r=parseInt(this.cornerDefaultStyle.borderWidth,10)-1,o=Math.ceil(parseInt(this.cornerDefaultStyle.width,10)/2),u=Math.ceil(parseInt(this.cornerDefaultStyle.height,10)/2);if(i===this.wot.getSetting("totalColumns")-1){const s=t?m.getBoundingClientRect().left:m.offsetLeft;let i=!1,a=0;R?(a=s-parseInt(this.cornerDefaultStyle.width,10)/2,i=a<0):(a=s+(0,n.outerWidth)(m)+parseInt(this.cornerDefaultStyle.width,10)/2,i=a>=(0,n.innerWidth)(e)),i&&(this.cornerStyle[b]=`${Math.floor(S+T+this.cornerCenterPointOffset-o-r)}px`,this.cornerStyle[R?"borderLeftWidth":"borderRightWidth"]=0)}if(s===this.wot.getSetting("totalRows")-1){(t?m.getBoundingClientRect().top:m.offsetTop)+(0,n.outerHeight)(m)+parseInt(this.cornerDefaultStyle.height,10)/2>=(0,n.innerHeight)(e)&&(this.cornerStyle.top=`${Math.floor(N+M+this.cornerCenterPointOffset-u-r)}px`,this.cornerStyle.borderBottomWidth=0)}this.cornerStyle.display="block"}(0,o.isMobileBrowser)()&&this.instance.getSetting("isDataViewInstance")&&this.updateMultipleSelectionHandlesPosition(s,i,N,S,T,M)}isEntireColumnSelected(e,t){return e===this.wot.wtTable.getFirstRenderedRow()&&t===this.wot.wtTable.getLastRenderedRow()}isEntireRowSelected(e,t){return e===this.wot.wtTable.getFirstRenderedColumn()&&t===this.wot.wtTable.getLastRenderedColumn()}getDimensionsFromHeader(e,t,r,s,i){const{wtTable:o}=this.wot,a=o.wtRootElement.parentNode;let l=null,h=null,u=null,c=null,d=null,p=null,g=null,f=null;switch(e){case"rows":l=function(){return o.getRowHeader(...arguments)},h=function(){return(0,n.outerHeight)(...arguments)},u="ht__selection--rows",p="top";break;case"columns":l=function(){return o.getColumnHeader(...arguments)},h=function(){return(0,n.outerWidth)(...arguments)},u="ht__selection--columns",p="left"}if(a.classList.contains(u)){const e=this.wot.getSetting("columnHeaders").length;if(g=l(t,e-s),f=l(r,e-s),!g||!f)return!1;const o=(0,n.offset)(g),a=(0,n.offset)(f);return g&&f&&(c=o[p]-i[p]-1,d=a[p]+h(f)-o[p]),[g,c,d]}return!1}changeBorderStyle(e,t){const r=this[e].style,s=t[e];!s||s.hide?(0,n.addClass)(this[e],"hidden"):((0,n.hasClass)(this[e],"hidden")&&(0,n.removeClass)(this[e],"hidden"),r.backgroundColor=s.color,"top"!==e&&"bottom"!==e||(r.height=`${s.width}px`),"start"!==e&&"end"!==e||(r.width=`${s.width}px`))}changeBorderToDefaultStyle(e){const t=1,r="#000",n=this[e].style;n.backgroundColor=r,n.width=`${t}px`,n.height=`${t}px`}toggleHiddenClass(e,t){this.changeBorderToDefaultStyle(e),t?(0,n.addClass)(this[e],"hidden"):(0,n.removeClass)(this[e],"hidden")}disappear(){this.topStyle.display="none",this.bottomStyle.display="none",this.startStyle.display="none",this.endStyle.display="none",this.cornerStyle.display="none",(0,o.isMobileBrowser)()&&this.instance.getSetting("isDataViewInstance")&&(this.selectionHandles.styles.top.display="none",this.selectionHandles.styles.topHitArea.display="none",this.selectionHandles.styles.bottom.display="none",this.selectionHandles.styles.bottomHitArea.display="none")}destroy(){this.eventManager.destroyWithOwnEventsOnly(),this.main.parentNode.removeChild(this.main)}}},38087:(e,t)=>{"use strict";t.__esModule=!0;t.getCornerStyle=e=>{const t=e.stylesHandler;if(t.isClassicTheme())return Object.freeze({width:6,height:6,borderWidth:1,borderStyle:"solid",borderColor:"#FFF"});const r=t.getCSSVariableValue("cell-autofill-size"),n=t.getCSSVariableValue("cell-autofill-border-width"),s=t.getCSSVariableValue("cell-autofill-border-color");return Object.freeze({width:r,height:r,borderWidth:n,borderStyle:"solid",borderColor:s})}},20746:(e,t)=>{"use strict";t.__esModule=!0;t.ACTIVE_HEADER_TYPE="active-header",t.HEADER_TYPE="header",t.AREA_TYPE="area",t.FOCUS_TYPE="focus",t.FILL_TYPE="fill",t.ROW_TYPE="row",t.COLUMN_TYPE="column",t.CUSTOM_SELECTION_TYPE="custom-selection"},70471:(e,t,r)=>{"use strict";r(14846),r(69655);var n=r(96784);t.__esModule=!0;var s={SelectionManager:!0,Selection:!0},i=n(r(42157));t.Selection=i.default;var o=r(20746);Object.keys(o).forEach((function(e){"default"!==e&&"__esModule"!==e&&(Object.prototype.hasOwnProperty.call(s,e)||e in t&&t[e]===o[e]||(t[e]=o[e]))}));var a=r(38087);Object.keys(a).forEach((function(e){"default"!==e&&"__esModule"!==e&&(Object.prototype.hasOwnProperty.call(s,e)||e in t&&t[e]===a[e]||(t[e]=a[e]))}));var l=r(67600);t.SelectionManager=l.SelectionManager},67600:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724),r(25352),r(71336),r(41558),r(17663),r(68630),r(79645),r(89858),r(8620),r(14846),r(69655),r(94364);var s=r(62577),i=r(10917),o=n(r(32506));function a(e,t,r){l(e,t),t.set(e,r)}function l(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function h(e,t){return e.get(c(e,t))}function u(e,t,r){return e.set(c(e,t),r),r}function c(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var d=new WeakMap,p=new WeakMap,g=new WeakMap,f=new WeakMap,m=new WeakMap,y=new WeakMap,E=new WeakSet;function w(){const e=h(f,this).get(h(d,this)),t=h(d,this).wtSettings.getSetting("onBeforeRemoveCellClassNames");if(Array.isArray(t))for(let r=0;r<t.length;r++)e.add(t[r]);e.forEach((e=>{var t,r;const n=h(d,this).wtTable.TABLE.querySelectorAll(`.${e}`);let i=[];Array.isArray(null===(t=h(p,this).options)||void 0===t?void 0:t.cellAttributes)&&(i=h(p,this).options.cellAttributes.map((e=>e[0]))),Array.isArray(null===(r=h(p,this).options)||void 0===r?void 0:r.headerAttributes)&&(i=[...i,...h(p,this).options.headerAttributes.map((e=>e[0]))]);for(let t=0,r=n.length;t<r;t++)(0,s.removeClass)(n[t],e),(0,s.removeAttribute)(n[t],i)})),e.clear()}t.SelectionManager=class{constructor(e){var t,r;l(t=this,r=E),r.add(t),a(this,d,void 0),a(this,p,void 0),a(this,g,new i.SelectionScanner),a(this,f,new WeakMap),a(this,m,new WeakSet),a(this,y,new Map),u(p,this,e)}setActiveOverlay(e){return u(d,this,e),h(g,this).setActiveOverlay(h(d,this)),h(f,this).has(h(d,this))||h(f,this).set(h(d,this),new Set),this}getFocusSelection(){return null!==h(p,this)?h(p,this).getFocus():null}getAreaSelection(){return null!==h(p,this)?h(p,this).createLayeredArea():null}getBorderInstance(e){if(!e.settings.border)return null;if(h(y,this).has(e)){const t=h(y,this).get(e);if(t.has(h(d,this)))return t.get(h(d,this));const r=new o.default(h(d,this),e.settings);return t.set(h(d,this),r),r}const t=new o.default(h(d,this),e.settings);return h(y,this).set(e,new Map([[h(d,this),t]])),t}getBorderInstances(e){var t,r;return Array.from(null!==(t=null===(r=h(y,this).get(e))||void 0===r?void 0:r.values())&&void 0!==t?t:[])}destroyBorders(e){h(y,this).get(e).forEach((e=>e.destroy())),h(y,this).delete(e)}render(e){if(null===h(p,this))return;e&&c(E,this,w).call(this);const t=Array.from(h(p,this)),r=new Map,n=new Map;for(let e=0;e<t.length;e++){const s=t[e],{className:i,headerAttributes:o,createLayers:a,selectionType:l}=s.settings;h(m,this).has(s)||(h(m,this).add(s),s.addLocalHook("destroy",(()=>this.destroyBorders(s))));const u=this.getBorderInstance(s);if(s.isEmpty()){null==u||u.disappear();continue}if(i){h(g,this).setActiveSelection(s).scan().forEach((e=>{if(r.has(e)){const t=r.get(e);t.has(i)&&!0===a?t.set(i,t.get(i)+1):t.set(i,1)}else r.set(e,new Map([[i,1]]));o&&(n.has(e)||n.set(e,[]),"TH"===e.nodeName&&n.get(e).push(...o))}))}const c=s.getCorners();h(d,this).getSetting("onBeforeDrawBorders",c,l),null==u||u.appear(c)}r.forEach(((e,t)=>{var r;const n=Array.from(e).map((e=>{let[t,r]=e;return 1===r?t:[t,...Array.from({length:r-1},((e,r)=>`${t}-${r+1}`))]})).flat();n.forEach((e=>h(f,this).get(h(d,this)).add(e))),(0,s.addClass)(t,n),"TD"===t.nodeName&&Array.isArray(null===(r=h(p,this).options)||void 0===r?void 0:r.cellAttributes)&&(0,s.setAttribute)(t,h(p,this).options.cellAttributes)})),Array.from(n.keys()).forEach((e=>{(0,s.setAttribute)(e,[...n.get(e)])}))}}},10917:(e,t,r)=>{"use strict";t.__esModule=!0,r(67834),r(71336),r(41558),r(17663),r(68630),r(79645),r(89858),r(8620);var n=r(62577);function s(e,t,r){i(e,t),t.set(e,r)}function i(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function o(e,t){return e.get(l(e,t))}function a(e,t,r){return e.set(l(e,t),r),r}function l(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var h=new WeakMap,u=new WeakMap,c=new WeakSet;function d(e){let[t,r,n,s]=o(h,this).getCorners();if(t<0&&n<0||r<0&&s<0)return;const{wtTable:i}=o(u,this),a=t!==n||r!==s;if(r=Math.max(r,0),s=Math.max(s,0),t=Math.max(t,0),n=Math.max(n,0),a){if(r=Math.max(r,i.getFirstRenderedColumn()),s=Math.min(s,i.getLastRenderedColumn()),t=Math.max(t,i.getFirstRenderedRow()),n=Math.min(n,i.getLastRenderedRow()),s<r||n<t)return}else{if(!(i.getCell(o(u,this).createCellCoords(t,r))instanceof HTMLElement))return}for(let i=t;i<=n;i+=1)for(let t=r;t<=s;t+=1)e(i,t)}function p(e){const{wtTable:t}=o(u,this),r=t.getRenderedRowsCount(),n=t.getRenderedColumnsCount();for(let s=0;s<r;s+=1){const r=t.rowFilter.renderedToSource(s);for(let s=0;s<n;s+=1)e(r,t.columnFilter.renderedToSource(s))}}t.SelectionScanner=class{constructor(){var e,t;i(e=this,t=c),t.add(e),s(this,h,void 0),s(this,u,void 0)}setActiveOverlay(e){return a(u,this,e),this}setActiveSelection(e){return a(h,this,e),this}scan(){const e=o(h,this).settings.selectionType,t=new Set;return"active-header"===e?(this.scanColumnsInHeadersRange((e=>t.add(e))),this.scanRowsInHeadersRange((e=>t.add(e)))):"area"===e?this.scanCellsRange((e=>t.add(e))):"focus"===e?(this.scanColumnsInHeadersRange((e=>t.add(e))),this.scanRowsInHeadersRange((e=>t.add(e))),this.scanCellsRange((e=>t.add(e)))):"fill"===e?this.scanCellsRange((e=>t.add(e))):"header"===e?(this.scanColumnsInHeadersRange((e=>t.add(e))),this.scanRowsInHeadersRange((e=>t.add(e)))):"row"===e?(this.scanRowsInHeadersRange((e=>t.add(e))),this.scanRowsInCellsRange((e=>t.add(e)))):"column"===e&&(this.scanColumnsInHeadersRange((e=>t.add(e))),this.scanColumnsInCellsRange((e=>t.add(e)))),t}scanColumnsInHeadersRange(e){const[t,r,n,s]=o(h,this).getCorners(),{wtTable:i}=o(u,this),a=i.getRenderedColumnsCount(),l=i.getColumnHeadersCount();let c=0;for(let d=-i.getRowHeadersCount();d<a;d++){const a=i.columnFilter.renderedToSource(d);if(!(a<r||a>s)){for(let d=-l;d<0;d++){if(d<t||d>n)continue;const p=d+l;let g=i.getColumnHeader(a,p);const f=o(u,this).getSetting("onBeforeHighlightingColumnHeader",a,p,{selectionType:o(h,this).settings.selectionType,columnCursor:c,selectionWidth:s-r+1});null!==f&&(f!==a&&(g=i.getColumnHeader(f,p)),e(g))}c+=1}}}scanRowsInHeadersRange(e){const[t,r,n,s]=o(h,this).getCorners(),{wtTable:i}=o(u,this),a=i.getRenderedRowsCount(),l=i.getRowHeadersCount();let c=0;for(let d=-i.getColumnHeadersCount();d<a;d++){const a=i.rowFilter.renderedToSource(d);if(!(a<t||a>n)){for(let d=-l;d<0;d++){if(d<r||d>s)continue;const p=d+l;let g=i.getRowHeader(a,p);const f=o(u,this).getSetting("onBeforeHighlightingRowHeader",a,p,{selectionType:o(h,this).settings.selectionType,rowCursor:c,selectionHeight:n-t+1});null!==f&&(f!==a&&(g=i.getRowHeader(f,p)),e(g))}c+=1}}}scanCellsRange(e){const{wtTable:t}=o(u,this);l(c,this,d).call(this,((r,s)=>{const i=t.getCell(o(u,this).createCellCoords(r,s)),a=o(u,this).getSetting("onAfterDrawSelection",r,s,o(h,this).settings.layerLevel);"string"==typeof a&&(0,n.addClass)(i,a),e(i)}))}scanRowsInCellsRange(e){const[t,,r]=o(h,this).getCorners(),{wtTable:n}=o(u,this);l(c,this,p).call(this,((s,i)=>{if(s>=t&&s<=r){const t=n.getCell(o(u,this).createCellCoords(s,i));e(t)}}))}scanColumnsInCellsRange(e){const[,t,,r]=o(h,this).getCorners(),{wtTable:n}=o(u,this);l(c,this,p).call(this,((s,i)=>{if(i>=t&&i<=r){const t=n.getCell(o(u,this).createCellCoords(s,i));e(t)}}))}}},42157:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=r(25499),i=n(r(16050));class o{constructor(e,t){this.settings=e,this.cellRange=t||null}isEmpty(){return null===this.cellRange}add(e){return this.isEmpty()?this.cellRange=this.settings.createCellRange(e):this.cellRange.expand(e),this}replace(e,t){if(!this.isEmpty()){if(this.cellRange.from.isEqual(e))return this.cellRange.from=t,!0;if(this.cellRange.to.isEqual(e))return this.cellRange.to=t,!0}return!1}clear(){return this.cellRange=null,this}getCorners(){const e=this.cellRange.getOuterTopStartCorner(),t=this.cellRange.getOuterBottomEndCorner();return[e.row,e.col,t.row,t.col]}destroy(){this.runLocalHooks("destroy")}}(0,s.mixin)(o,i.default);t.default=o},34117:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),i=r(62577),o=r(25499);t.default=class{constructor(e){(0,s.default)(this,"settings",{}),(0,s.default)(this,"defaults",Object.freeze(this.getDefaults())),(0,o.objectEach)(this.defaults,((t,r)=>{if(void 0!==e[r])this.settings[r]=e[r];else{if(void 0===t)throw new Error(`A required setting "${r}" was not provided`);this.settings[r]=t}}))}getDefaults(){return{facade:void 0,table:void 0,isDataViewInstance:!0,externalRowCalculator:!1,currentRowClassName:null,currentColumnClassName:null,preventOverflow:()=>!1,preventWheel:!1,data:void 0,fixedColumnsStart:0,fixedRowsTop:0,fixedRowsBottom:0,shouldRenderInlineStartOverlay:()=>this.getSetting("fixedColumnsStart")>0||this.getSetting("rowHeaders").length>0,shouldRenderTopOverlay:()=>this.getSetting("fixedRowsTop")>0||this.getSetting("columnHeaders").length>0,shouldRenderBottomOverlay:()=>this.getSetting("fixedRowsBottom")>0,minSpareRows:0,rowHeaders:()=>[],columnHeaders:()=>[],totalRows:void 0,totalColumns:void 0,cellRenderer:(e,t,r)=>{const n=this.getSetting("data",e,t);(0,i.fastInnerText)(r,null==n?"":n)},columnWidth(){},rowHeight(){},rowHeightByOverlayName(){},defaultColumnWidth:50,selections:null,hideBorderOnMouseDownOver:!1,viewportRowCalculatorOverride:null,viewportColumnCalculatorOverride:null,viewportRowRenderingThreshold:null,viewportColumnRenderingThreshold:null,onCellMouseDown:null,onCellContextMenu:null,onCellMouseOver:null,onCellMouseOut:null,onCellMouseUp:null,onCellDblClick:null,onCellCornerMouseDown:null,onCellCornerDblClick:null,beforeDraw:null,onDraw:null,onBeforeRemoveCellClassNames:null,onAfterDrawSelection:null,onBeforeDrawBorders:null,onBeforeViewportScrollHorizontally:e=>e,onBeforeViewportScrollVertically:e=>e,onScrollHorizontally:null,onScrollVertically:null,onBeforeTouchScroll:null,onAfterMomentumScroll:null,onModifyRowHeaderWidth:null,onModifyGetCellCoords:null,onModifyGetCoordsElement:null,onModifyGetCoords:null,onBeforeHighlightingRowHeader:e=>e,onBeforeHighlightingColumnHeader:e=>e,onWindowResize:null,onContainerElementResize:null,renderAllColumns:!1,renderAllRows:!1,groups:!1,rowHeaderWidth:null,columnHeaderHeight:null,headerClassName:null,rtlMode:!1,ariaTags:!0}}update(e,t){return void 0===t?(0,o.objectEach)(e,((e,t)=>{this.settings[t]=e})):this.settings[e]=t,this}getSetting(e,t,r,n,s){return"function"==typeof this.settings[e]?this.settings[e](t,r,n,s):void 0!==t&&Array.isArray(this.settings[e])?this.settings[e][t]:this.settings[e]}getSettingPure(e){return this.settings[e]}has(e){return!!this.settings[e]}}},7346:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724),r(14846),r(69655);var s=n(r(85707)),i=r(62577),o=r(89804),a=n(r(62383)),l=n(r(82217)),h=r(36936),u=n(r(92020)),c=n(r(67920)),d=r(69397),p=r(71120);t.default=class{constructor(e,t,r,n,o){(0,s.default)(this,"wtSettings",null),(0,s.default)(this,"domBindings",void 0),(0,s.default)(this,"TBODY",null),(0,s.default)(this,"THEAD",null),(0,s.default)(this,"COLGROUP",null),(0,s.default)(this,"hasTableHeight",!0),(0,s.default)(this,"hasTableWidth",!0),(0,s.default)(this,"isTableVisible",!1),(0,s.default)(this,"tableOffset",0),(0,s.default)(this,"holderOffset",0),this.domBindings=r,this.isMaster="master"===o,this.name=o,this.dataAccessObject=e,this.facadeGetter=t,this.wtSettings=n,this.instance=this.dataAccessObject.wot,this.wot=this.dataAccessObject.wot,this.TABLE=r.rootTable,(0,i.removeTextNodes)(this.TABLE),this.spreader=this.createSpreader(this.TABLE),this.hider=this.createHider(this.spreader),this.holder=this.createHolder(this.hider),this.wtRootElement=this.holder.parentNode,this.isMaster&&this.alignOverlaysWithTrimmingContainer(),this.fixTableDomTree(),this.rowFilter=null,this.columnFilter=null,this.correctHeaderWidth=!1;const a=this.wtSettings.getSettingPure("rowHeaderWidth");this.wtSettings.update("rowHeaderWidth",(()=>this._modifyRowHeaderWidth(a))),this.rowUtils=new c.default(this.dataAccessObject,this.wtSettings),this.columnUtils=new u.default(this.dataAccessObject,this.wtSettings),this.tableRenderer=new h.Renderer({TABLE:this.TABLE,THEAD:this.THEAD,COLGROUP:this.COLGROUP,TBODY:this.TBODY,rowUtils:this.rowUtils,columnUtils:this.columnUtils,cellRenderer:this.wtSettings.getSettingPure("cellRenderer"),stylesHandler:this.dataAccessObject.stylesHandler})}is(e){return this.name===e}fixTableDomTree(){const e=this.domBindings.rootDocument;this.TBODY=this.TABLE.querySelector("tbody"),this.TBODY||(this.TBODY=e.createElement("tbody"),this.TABLE.appendChild(this.TBODY)),this.THEAD=this.TABLE.querySelector("thead"),this.THEAD||(this.THEAD=e.createElement("thead"),this.TABLE.insertBefore(this.THEAD,this.TBODY)),this.COLGROUP=this.TABLE.querySelector("colgroup"),this.COLGROUP||(this.COLGROUP=e.createElement("colgroup"),this.TABLE.insertBefore(this.COLGROUP,this.THEAD))}createSpreader(e){const t=e.parentNode;let r;return t&&t.nodeType===Node.ELEMENT_NODE&&(0,i.hasClass)(t,"wtHolder")||(r=this.domBindings.rootDocument.createElement("div"),r.className="wtSpreader",t&&t.insertBefore(r,e),r.appendChild(e)),r.style.position="relative",this.wtSettings.getSetting("ariaTags")&&(0,i.setAttribute)(r,[(0,p.A11Y_PRESENTATION)()]),r}createHider(e){const t=e.parentNode;let r;return t&&t.nodeType===Node.ELEMENT_NODE&&(0,i.hasClass)(t,"wtHolder")||(r=this.domBindings.rootDocument.createElement("div"),r.className="wtHider",t&&t.insertBefore(r,e),r.appendChild(e)),this.wtSettings.getSetting("ariaTags")&&(0,i.setAttribute)(r,[(0,p.A11Y_PRESENTATION)()]),r}createHolder(e){const t=e.parentNode;let r;return t&&t.nodeType===Node.ELEMENT_NODE&&(0,i.hasClass)(t,"wtHolder")||(r=this.domBindings.rootDocument.createElement("div"),r.style.position="relative",r.className="wtHolder",t&&t.insertBefore(r,e),this.isMaster&&(r.parentNode.className+="ht_master handsontable",r.parentNode.setAttribute("dir",this.wtSettings.getSettingPure("rtlMode")?"rtl":"ltr"),this.wtSettings.getSetting("ariaTags")&&(0,i.setAttribute)(r.parentNode,[(0,p.A11Y_PRESENTATION)()])),r.appendChild(e)),this.wtSettings.getSetting("ariaTags")&&(0,i.setAttribute)(r,[(0,p.A11Y_PRESENTATION)()]),r}draw(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];const{wtSettings:t}=this,{wtOverlays:r,wtViewport:n}=this.dataAccessObject,s=t.getSetting("totalRows"),o=t.getSetting("totalColumns"),h=t.getSetting("rowHeaders"),u=h.length,c=t.getSetting("columnHeaders"),p=c.length;let g=e;if(this.isMaster&&(r.beforeDraw(),this.holderOffset=(0,i.offset)(this.holder),g=n.createCalculators(g),u&&!t.getSetting("fixedColumnsStart"))){const e=r.inlineStartOverlay.getScrollPosition(),t=this.correctHeaderWidth;this.correctHeaderWidth=0!==e,t!==this.correctHeaderWidth&&(g=!1)}if(g)this.isMaster&&r.refresh(!0);else{this.isMaster?this.tableOffset=(0,i.offset)(this.TABLE):this.tableOffset=this.dataAccessObject.parentTableOffset;const e=s>0?this.getFirstRenderedRow():0,t=o>0?this.getFirstRenderedColumn():0;this.rowFilter=new l.default(e,s,p),this.columnFilter=new a.default(t,o,u);let g=!0;if(this.isMaster){this.alignOverlaysWithTrimmingContainer();const e={};this.wtSettings.getSetting("beforeDraw",!0,e),g=!0!==e.skipRender}g&&(this.tableRenderer.setHeaderContentRenderers(h,c),(this.is(d.CLONE_BOTTOM)||this.is(d.CLONE_BOTTOM_INLINE_START_CORNER))&&this.tableRenderer.setHeaderContentRenderers(h,[]),this.resetOversizedRows(),this.tableRenderer.setActiveOverlayName(this.name).setViewportSize(this.getRenderedRowsCount(),this.getRenderedColumnsCount()).setFilters(this.rowFilter,this.columnFilter).render(),this.isMaster&&this.markOversizedColumnHeaders(),this.adjustColumnHeaderHeights(),(this.isMaster||this.is(d.CLONE_BOTTOM))&&this.markOversizedRows(),this.isMaster?(this.wtSettings.getSetting("externalRowCalculator")||n.createVisibleCalculators(),r.refresh(!1),r.applyToDOM(),this.wtSettings.getSetting("onDraw",!0)):this.is(d.CLONE_BOTTOM)&&this.dataAccessObject.cloneSource.wtOverlays.adjustElementsSize())}let f=!1;return this.isMaster&&(f=r.topOverlay.resetFixedPosition(),r.bottomOverlay.clone&&(f=r.bottomOverlay.resetFixedPosition()||f),f=r.inlineStartOverlay.resetFixedPosition()||f,r.topInlineStartCornerOverlay&&r.topInlineStartCornerOverlay.resetFixedPosition(),r.bottomInlineStartCornerOverlay&&r.bottomInlineStartCornerOverlay.clone&&r.bottomInlineStartCornerOverlay.resetFixedPosition()),f?(r.refreshAll(),r.adjustElementsSize()):this.dataAccessObject.selectionManager.setActiveOverlay(this.facadeGetter()).render(g),this.isMaster&&r.afterDraw(),this.dataAccessObject.drawn=!0,this}markIfOversizedColumnHeader(e){const t=this.columnFilter.renderedToSource(e);let r=this.wtSettings.getSetting("columnHeaders").length;const n=this.dataAccessObject.stylesHandler.getDefaultRowHeight();let s,o,a;const l=this.wtSettings.getSetting("columnHeaderHeight")||[];for(;r;)r-=1,s=this.getColumnHeaderHeight(r),o=this.getColumnHeader(t,r),o&&(a=(0,i.innerHeight)(o),(!s&&n<a||s<a)&&(this.dataAccessObject.wtViewport.oversizedColumnHeaders[r]=a),Array.isArray(l)?null!==l[r]&&void 0!==l[r]&&(this.dataAccessObject.wtViewport.oversizedColumnHeaders[r]=l[r]):isNaN(l)||(this.dataAccessObject.wtViewport.oversizedColumnHeaders[r]=l),this.dataAccessObject.wtViewport.oversizedColumnHeaders[r]<(l[r]||l)&&(this.dataAccessObject.wtViewport.oversizedColumnHeaders[r]=l[r]||l))}adjustColumnHeaderHeights(){const{wtSettings:e}=this,t=this.THEAD.childNodes,r=this.dataAccessObject.wtViewport.oversizedColumnHeaders;for(let n=0,s=e.getSetting("columnHeaders").length;n<s;n++)if(r[n]){if(!t[n]||0===t[n].childNodes.length)return;t[n].childNodes[0].style.height=`${r[n]}px`}}resetOversizedRows(){const{wtSettings:e}=this,{wtViewport:t}=this.dataAccessObject;if((this.isMaster||this.is(d.CLONE_BOTTOM))&&!e.getSetting("externalRowCalculator")){const e=this.getRenderedRowsCount();for(let r=0;r<e;r++){const e=this.rowFilter.renderedToSource(r);t.oversizedRows&&t.oversizedRows[e]&&(t.oversizedRows[e]=void 0)}}}getCell(e){let t=e.row,r=e.col;const n=this.wtSettings.getSetting("onModifyGetCellCoords",t,r,!this.isMaster,"render");if(n&&Array.isArray(n)&&([t,r]=n),this.isRowBeforeRenderedRows(t))return-1;if(this.isRowAfterRenderedRows(t))return-2;if(this.isColumnBeforeRenderedColumns(r))return-3;if(this.isColumnAfterRenderedColumns(r))return-4;const s=this.getRow(t);if(!s&&t>=0)throw new Error("TR was expected to be rendered but is not");const i=s.childNodes[this.columnFilter.sourceColumnToVisibleRowHeadedColumn(r)];if(!i&&r>=0)throw new Error("TD or TH was expected to be rendered but is not");return i}getRow(e){let t=null,r=null;var n,s;e<0?(t=null===(n=this.rowFilter)||void 0===n?void 0:n.sourceRowToVisibleColHeadedRow(e),r=this.THEAD):(t=null===(s=this.rowFilter)||void 0===s?void 0:s.sourceToRendered(e),r=this.TBODY);return void 0!==t&&void 0!==r&&(!(r.childNodes.length<t+1)&&r.childNodes[t])}getColumnHeader(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;const r=this.THEAD.childNodes[t];return null==r?void 0:r.childNodes[this.columnFilter.sourceColumnToVisibleRowHeadedColumn(e)]}getColumnHeaders(e){const t=[],r=this.columnFilter.sourceColumnToVisibleRowHeadedColumn(e);return this.THEAD.childNodes.forEach((e=>{const n=e.childNodes[r];n&&t.push(n)})),t}getRowHeader(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;if(t>=this.wtSettings.getSetting("rowHeaders").length)return;const r=this.rowFilter.sourceToRendered(e),n=r<0?this.rowFilter.sourceRowToVisibleColHeadedRow(e):r,s=(r<0?this.THEAD:this.TBODY).childNodes[n];return null==s?void 0:s.childNodes[t]}getRowHeaders(e){const t=[],r=this.wtSettings.getSetting("rowHeaders").length;for(let n=0;n<r;n++){const r=this.TBODY.childNodes[this.rowFilter.sourceToRendered(e)],s=null==r?void 0:r.childNodes[n];s&&t.push(s)}return t}getCoords(e){let t=e;if("TD"!==t.nodeName&&"TH"!==t.nodeName&&(t=(0,i.closest)(t,["TD","TH"])),null===t)return null;const r=t.parentNode,n=r.parentNode;let s=(0,i.index)(r),o=t.cellIndex;if((0,i.overlayContainsElement)(d.CLONE_TOP_INLINE_START_CORNER,t,this.wtRootElement)||(0,i.overlayContainsElement)(d.CLONE_TOP,t,this.wtRootElement))"THEAD"===n.nodeName&&(s-=n.childNodes.length);else if((0,i.overlayContainsElement)(d.CLONE_BOTTOM_INLINE_START_CORNER,t,this.wtRootElement)||(0,i.overlayContainsElement)(d.CLONE_BOTTOM,t,this.wtRootElement)){s=this.wtSettings.getSetting("totalRows")-n.childNodes.length+s}else s=n===this.THEAD?this.rowFilter.visibleColHeadedRowToSourceRow(s):this.rowFilter.renderedToSource(s);o=(0,i.overlayContainsElement)(d.CLONE_TOP_INLINE_START_CORNER,t,this.wtRootElement)||(0,i.overlayContainsElement)(d.CLONE_INLINE_START,t,this.wtRootElement)||(0,i.overlayContainsElement)(d.CLONE_BOTTOM_INLINE_START_CORNER,t,this.wtRootElement)?this.columnFilter.offsettedTH(o):this.columnFilter.visibleRowHeadedColumnToSourceColumn(o);const a=this.wtSettings.getSetting("onModifyGetCoordsElement",s,o);return a&&Array.isArray(a)&&([s,o]=a),this.wot.createCellCoords(s,o)}markOversizedRows(){if(this.wtSettings.getSetting("externalRowCalculator"))return;let e=this.TBODY.childNodes.length;const t=e*this.dataAccessObject.stylesHandler.getDefaultRowHeight(),r=(0,i.innerHeight)(this.TBODY)-1,n=this.wot.stylesHandler.areCellsBorderBox(),s=n?i.outerHeight:i.innerHeight,o=n?0:1,a=n?1:0;let l,h,u,c,d;if(t!==r||this.wtSettings.getSetting("fixedRowsBottom"))for(;e;){e-=1,u=this.rowFilter.renderedToSource(e),l=this.getRowHeight(u),c=this.getTrForRow(u),d=c.querySelector("th");const t=0===u?a:0;h=d?s(d):s(c)-o,(!l&&this.dataAccessObject.stylesHandler.getDefaultRowHeight()<h-t||l<h)&&(n||(h+=1),this.dataAccessObject.wtViewport.oversizedRows[u]=h)}}getTrForRow(e){return this.TBODY.childNodes[this.rowFilter.sourceToRendered(e)]}isColumnHeaderRendered(e){if(e>=0)return!1;const t=this.wtSettings.getSetting("rowHeaders").length;return Math.abs(e)<=t}isRowHeaderRendered(e){if(e>=0)return!1;const t=this.wtSettings.getSetting("columnHeaders").length;return Math.abs(e)<=t}isRowBeforeRenderedRows(e){const t=this.getFirstRenderedRow();return e<0&&t<=0?!this.isRowHeaderRendered(e):e<t}isRowAfterRenderedRows(e){return e>this.getLastRenderedRow()}isColumnBeforeRenderedColumns(e){const t=this.getFirstRenderedColumn();return e<0&&t<=0?!this.isColumnHeaderRendered(e):e<t}isColumnAfterRenderedColumns(e){return this.columnFilter&&e>this.getLastRenderedColumn()}isColumnAfterViewport(e){return this.columnFilter&&e>this.getLastVisibleColumn()}isRowAfterViewport(e){return this.rowFilter&&e>this.getLastVisibleRow()}isColumnBeforeViewport(e){return this.columnFilter&&this.columnFilter.sourceToRendered(e)<0&&e>=0}isLastRowFullyVisible(){return this.getLastVisibleRow()===this.getLastRenderedRow()}isLastColumnFullyVisible(){return this.getLastVisibleColumn()===this.getLastRenderedColumn()}allRowsInViewport(){return this.wtSettings.getSetting("totalRows")===this.getVisibleRowsCount()}allColumnsInViewport(){return this.wtSettings.getSetting("totalColumns")===this.getVisibleColumnsCount()}getRowHeight(e){return this.rowUtils.getHeight(e)}getColumnHeaderHeight(e){return this.columnUtils.getHeaderHeight(e)}getColumnWidth(e){return this.columnUtils.getWidth(e)}hasDefinedSize(){return this.hasTableHeight&&this.hasTableWidth}getWidth(){return(0,i.outerWidth)(this.TABLE)}getHeight(){return(0,i.outerHeight)(this.TABLE)}getTotalWidth(){const e=(0,i.outerWidth)(this.hider);return 0!==e?e:this.getWidth()}getTotalHeight(){const e=(0,i.outerHeight)(this.hider);return 0!==e?e:this.getHeight()}isVisible(){return(0,i.isVisible)(this.TABLE)}_modifyRowHeaderWidth(e){let t=(0,o.isFunction)(e)?e():null;return Array.isArray(t)?(t=[...t],t[t.length-1]=this._correctRowHeaderWidth(t[t.length-1])):t=this._correctRowHeaderWidth(t),t}_correctRowHeaderWidth(e){let t=e;return"number"!=typeof e&&(t=this.wtSettings.getSetting("defaultColumnWidth")),this.correctHeaderWidth&&(t+=1),t}}},55538:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(7346)),i=n(r(96514)),o=n(r(29220)),a=r(25499),l=r(69397);class h extends s.default{constructor(e,t,r,n){super(e,t,r,n,l.CLONE_BOTTOM)}}(0,a.mixin)(h,i.default),(0,a.mixin)(h,o.default);t.default=h},41618:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(7346)),i=n(r(96514)),o=n(r(11381)),a=r(25499),l=r(69397);class h extends s.default{constructor(e,t,r,n){super(e,t,r,n,l.CLONE_BOTTOM_INLINE_START_CORNER)}}(0,a.mixin)(h,i.default),(0,a.mixin)(h,o.default);t.default=h},80222:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(7346)),i=n(r(9898)),o=n(r(11381)),a=r(25499),l=r(69397);class h extends s.default{constructor(e,t,r,n){super(e,t,r,n,l.CLONE_INLINE_START)}}(0,a.mixin)(h,i.default),(0,a.mixin)(h,o.default);t.default=h},78951:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=r(62577),i=n(r(7346)),o=n(r(9898)),a=n(r(29220)),l=r(25499);class h extends i.default{constructor(e,t,r,n){super(e,t,r,n,"master")}alignOverlaysWithTrimmingContainer(){const e=(0,s.getTrimmingContainer)(this.wtRootElement),{rootWindow:t}=this.domBindings;if(e===t){this.wtSettings.getSetting("preventOverflow")||(this.holder.style.overflow="visible",this.wtRootElement.style.overflow="visible")}else{const r=e.parentElement,n=(0,s.getStyle)(e,"height",t),i=(0,s.getStyle)(e,"overflow",t),o=this.holder.style,{scrollWidth:a,scrollHeight:l}=e;let h=e.offsetWidth,u=e.offsetHeight;if(r&&["auto","hidden","scroll"].includes(i)){const n=e.cloneNode(!1);n.style.overflow="auto",n.style.position="absolute",e.nextElementSibling?r.insertBefore(n,e.nextElementSibling):r.appendChild(n);const s=parseInt(t.getComputedStyle(n).height,10);r.removeChild(n),0===s&&(u=0)}u=Math.min(u,l),o.height="auto"===n?"auto":`${u}px`,h=Math.min(h,a),o.width=`${h}px`,o.overflow="",this.hasTableHeight="auto"===o.height||u>0,this.hasTableWidth=h>0}this.isTableVisible=(0,s.isVisible)(this.TABLE)}markOversizedColumnHeaders(){const{wtSettings:e}=this,{wtViewport:t}=this.dataAccessObject,r="master",n=e.getSetting("columnHeaders").length;if(n&&!t.hasOversizedColumnHeadersMarked[r]){const s=e.getSetting("rowHeaders").length,i=this.getRenderedColumnsCount();for(let e=0;e<n;e++)for(let e=-1*s;e<i;e++)this.markIfOversizedColumnHeader(e);t.hasOversizedColumnHeadersMarked[r]=!0}}}(0,l.mixin)(h,o.default),(0,l.mixin)(h,a.default);t.default=h},29220:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(25499);const s={getFirstRenderedColumn(){const e=this.dataAccessObject.startColumnRendered;return null===e?-1:e},getFirstVisibleColumn(){const e=this.dataAccessObject.startColumnVisible;return null===e?-1:e},getFirstPartiallyVisibleColumn(){const e=this.dataAccessObject.startColumnPartiallyVisible;return null===e?-1:e},getLastRenderedColumn(){const e=this.dataAccessObject.endColumnRendered;return null===e?-1:e},getLastVisibleColumn(){const e=this.dataAccessObject.endColumnVisible;return null===e?-1:e},getLastPartiallyVisibleColumn(){const e=this.dataAccessObject.endColumnPartiallyVisible;return null===e?-1:e},getRenderedColumnsCount(){return this.dataAccessObject.countColumnsRendered},getVisibleColumnsCount(){return this.dataAccessObject.countColumnsVisible},getRowHeadersCount(){return this.dataAccessObject.rowHeaders.length}};(0,n.defineGetter)(s,"MIXIN_NAME","calculatedColumns",{writable:!1,enumerable:!1});t.default=s},9898:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(25499);const s={getFirstRenderedRow(){const e=this.dataAccessObject.startRowRendered;return null===e?-1:e},getFirstVisibleRow(){const e=this.dataAccessObject.startRowVisible;return null===e?-1:e},getFirstPartiallyVisibleRow(){const e=this.dataAccessObject.startRowPartiallyVisible;return null===e?-1:e},getLastRenderedRow(){const e=this.dataAccessObject.endRowRendered;return null===e?-1:e},getLastVisibleRow(){const e=this.dataAccessObject.endRowVisible;return null===e?-1:e},getLastPartiallyVisibleRow(){const e=this.dataAccessObject.endRowPartiallyVisible;return null===e?-1:e},getRenderedRowsCount(){return this.dataAccessObject.countRowsRendered},getVisibleRowsCount(){return this.dataAccessObject.countRowsVisible},getColumnHeadersCount(){return this.dataAccessObject.columnHeaders.length}};(0,n.defineGetter)(s,"MIXIN_NAME","calculatedRows",{writable:!1,enumerable:!1});t.default=s},11381:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(25499);const s={getFirstRenderedColumn(){return 0===this.wtSettings.getSetting("totalColumns")?-1:0},getFirstVisibleColumn(){return this.getFirstRenderedColumn()},getFirstPartiallyVisibleColumn(){return this.getFirstRenderedColumn()},getLastRenderedColumn(){return this.getRenderedColumnsCount()-1},getLastVisibleColumn(){return this.getLastRenderedColumn()},getLastPartiallyVisibleColumn(){return this.getLastRenderedColumn()},getRenderedColumnsCount(){const e=this.wtSettings.getSetting("totalColumns");return Math.min(this.wtSettings.getSetting("fixedColumnsStart"),e)},getVisibleColumnsCount(){return this.getRenderedColumnsCount()},getRowHeadersCount(){return this.dataAccessObject.rowHeaders.length}};(0,n.defineGetter)(s,"MIXIN_NAME","stickyColumnsStart",{writable:!1,enumerable:!1});t.default=s},96514:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(25499);const s={getFirstRenderedRow(){const e=this.wtSettings.getSetting("totalRows"),t=this.wtSettings.getSetting("fixedRowsBottom"),r=e-t;return 0===e||0===t?-1:r<0?0:r},getFirstVisibleRow(){return this.getFirstRenderedRow()},getFirstPartiallyVisibleRow(){return this.getFirstRenderedRow()},getLastRenderedRow(){return this.wtSettings.getSetting("totalRows")-1},getLastVisibleRow(){return this.getLastRenderedRow()},getLastPartiallyVisibleRow(){return this.getLastRenderedRow()},getRenderedRowsCount(){const e=this.wtSettings.getSetting("totalRows");return Math.min(this.wtSettings.getSetting("fixedRowsBottom"),e)},getVisibleRowsCount(){return this.getRenderedRowsCount()},getColumnHeadersCount:()=>0};(0,n.defineGetter)(s,"MIXIN_NAME","stickyRowsBottom",{writable:!1,enumerable:!1});t.default=s},26814:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(25499);const s={getFirstRenderedRow(){return 0===this.wtSettings.getSetting("totalRows")?-1:0},getFirstVisibleRow(){return this.getFirstRenderedRow()},getFirstPartiallyVisibleRow(){return this.getFirstRenderedRow()},getLastRenderedRow(){return this.getRenderedRowsCount()-1},getLastVisibleRow(){return this.getLastRenderedRow()},getLastPartiallyVisibleRow(){return this.getLastRenderedRow()},getRenderedRowsCount(){const e=this.wtSettings.getSetting("totalRows");return Math.min(this.wtSettings.getSetting("fixedRowsTop"),e)},getVisibleRowsCount(){return this.getRenderedRowsCount()},getColumnHeadersCount(){return this.dataAccessObject.columnHeaders.length}};(0,n.defineGetter)(s,"MIXIN_NAME","stickyRowsTop",{writable:!1,enumerable:!1});t.default=s},94318:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(7346)),i=n(r(26814)),o=n(r(29220)),a=r(25499),l=r(69397);class h extends s.default{constructor(e,t,r,n){super(e,t,r,n,l.CLONE_TOP)}}(0,a.mixin)(h,i.default),(0,a.mixin)(h,o.default);t.default=h},16318:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(7346)),i=n(r(26814)),o=n(r(11381)),a=r(25499),l=r(69397);class h extends s.default{constructor(e,t,r,n){super(e,t,r,n,l.CLONE_TOP_INLINE_START_CORNER)}}(0,a.mixin)(h,i.default),(0,a.mixin)(h,o.default);t.default=h},92020:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.default=class{constructor(e,t){(0,s.default)(this,"dataAccessObject",void 0),(0,s.default)(this,"wtSettings",void 0),(0,s.default)(this,"headerWidths",new Map),this.dataAccessObject=e,this.wtSettings=t}getWidth(e){return this.wtSettings.getSetting("columnWidth",e)||this.wtSettings.getSetting("defaultColumnWidth")}getHeaderHeight(e){let t=this.dataAccessObject.stylesHandler.getDefaultRowHeight();const r=this.dataAccessObject.wtViewport.oversizedColumnHeaders[e];return void 0!==r&&(t=t?Math.max(t,r):r),t}getHeaderWidth(e){return this.headerWidths.get(this.dataAccessObject.wtTable.columnFilter.sourceToRendered(e))}calculateWidths(){const{wtSettings:e}=this;let t=e.getSetting("rowHeaderWidth");if(t=e.getSetting("onModifyRowHeaderWidth",t),null!=t){const r=e.getSetting("rowHeaders").length,n=e.getSetting("defaultColumnWidth");for(let e=0;e<r;e++){let r=Array.isArray(t)?t[e]:t;r=null==r?n:r,this.headerWidths.set(e,r)}}}}},76095:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.default=class{constructor(e){(0,s.default)(this,"nodeType",void 0),this.nodeType=e.toUpperCase()}setRootDocument(e){this.rootDocument=e}obtain(){return this.rootDocument.createElement(this.nodeType)}}},30303:(e,t)=>{"use strict";t.__esModule=!0;t.WORKING_SPACE_ALL=0,t.WORKING_SPACE_TOP=1,t.WORKING_SPACE_BOTTOM=2},97646:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(44653));t.OrderView=s.default;var i=n(r(7620));t.SharedOrderView=i.default},7620:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(44653));class i extends s.default{prependView(e){return this.sizeSet.prepend(e.sizeSet),e.sizeSet.append(this.sizeSet),this}appendView(e){return this.sizeSet.append(e.sizeSet),e.sizeSet.prepend(this.sizeSet),this}}t.default=i},44653:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724);var s=n(r(85707)),i=r(30303),o=n(r(70074));t.default=class{constructor(e,t,r){(0,s.default)(this,"rootNode",void 0),(0,s.default)(this,"nodesPool",void 0),(0,s.default)(this,"sizeSet",new o.default),(0,s.default)(this,"childNodeType",void 0),(0,s.default)(this,"visualIndex",0),(0,s.default)(this,"collectedNodes",[]),this.rootNode=e,this.nodesPool=t,this.childNodeType=r.toUpperCase()}setSize(e){return this.sizeSet.setSize(e),this}setOffset(e){return this.sizeSet.setOffset(e),this}isSharedViewSet(){return this.sizeSet.isShared()}getNode(e){return e<this.collectedNodes.length?this.collectedNodes[e]:null}getCurrentNode(){const e=this.collectedNodes.length;return e>0?this.collectedNodes[e-1]:null}getRenderedChildCount(){const{rootNode:e,sizeSet:t}=this;let r=0;if(this.isSharedViewSet()){let n=e.firstElementChild;for(;n;){if(n.tagName===this.childNodeType)r+=1;else if(t.isPlaceOn(i.WORKING_SPACE_TOP))break;n=n.nextElementSibling}}else r=e.childElementCount;return r}start(){this.collectedNodes.length=0,this.visualIndex=0;const{rootNode:e,sizeSet:t}=this,r=this.isSharedViewSet(),{nextSize:n}=t.getViewSize();let s=this.getRenderedChildCount();for(;s<n;){const n=this.nodesPool();!r||r&&t.isPlaceOn(i.WORKING_SPACE_BOTTOM)?e.appendChild(n):e.insertBefore(n,e.firstChild),s+=1}const o=r&&t.isPlaceOn(i.WORKING_SPACE_TOP);for(;s>n;)e.removeChild(o?e.firstChild:e.lastChild),s-=1}render(){const{rootNode:e,sizeSet:t}=this;let r=this.visualIndex;this.isSharedViewSet()&&t.isPlaceOn(i.WORKING_SPACE_BOTTOM)&&(r+=t.sharedSize.nextSize);let n=e.childNodes[r];if(n.tagName!==this.childNodeType){const t=this.nodesPool();e.replaceChild(t,n),n=t}this.collectedNodes.push(n),this.visualIndex+=1}end(){}}},67744:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.default=class{constructor(){(0,s.default)(this,"currentSize",0),(0,s.default)(this,"nextSize",0),(0,s.default)(this,"currentOffset",0),(0,s.default)(this,"nextOffset",0)}setSize(e){this.currentSize=this.nextSize,this.nextSize=e}setOffset(e){this.currentOffset=this.nextOffset,this.nextOffset=e}}},70074:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),i=n(r(67744)),o=r(30303);t.default=class{constructor(){(0,s.default)(this,"size",new i.default),(0,s.default)(this,"workingSpace",o.WORKING_SPACE_ALL),(0,s.default)(this,"sharedSize",null)}setSize(e){this.size.setSize(e)}setOffset(e){this.size.setOffset(e)}getViewSize(){return this.size}isShared(){return this.sharedSize instanceof i.default}isPlaceOn(e){return this.workingSpace===e}append(e){this.workingSpace=o.WORKING_SPACE_TOP,e.workingSpace=o.WORKING_SPACE_BOTTOM,this.sharedSize=e.getViewSize()}prepend(e){this.workingSpace=o.WORKING_SPACE_BOTTOM,e.workingSpace=o.WORKING_SPACE_TOP,this.sharedSize=e.getViewSize()}}},67920:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707));t.default=class{constructor(e,t){(0,s.default)(this,"dataAccessObject",void 0),(0,s.default)(this,"wtSettings",void 0),this.dataAccessObject=e,this.wtSettings=t}getHeight(e){let t=this.wtSettings.getSetting("rowHeight",e);const r=this.dataAccessObject.wtViewport.oversizedRows[e];return void 0!==r&&(t=void 0===t?r:Math.max(t,r)),t}getHeightByOverlayName(e,t){let r=this.wtSettings.getSetting("rowHeightByOverlayName",e,t);const n=this.dataAccessObject.wtViewport.oversizedRows[e];return void 0!==n&&(r=void 0===r?n:Math.max(r,n)),r}}},52714:(e,t,r)=>{"use strict";t.__esModule=!0,r(67834),r(14846),r(69655);var n=r(62577),s=r(14859);function i(e,t,r){o(e,t),t.set(e,r)}function o(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function a(e,t){return e.get(h(e,t))}function l(e,t,r){return e.set(h(e,t),r),r}function h(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var u=new WeakMap,c=new WeakMap,d=new WeakMap,p=new WeakMap,g=new WeakMap,f=new WeakMap,m=new WeakMap,y=new WeakSet;function E(){const e=this.getCSSVariableValue("line-height"),t=this.getCSSVariableValue("cell-vertical-padding"),r=Math.ceil(parseFloat(this.getStyleForTD("border-bottom-width")));return null===e||null===t||isNaN(r)?null:e+2*t+r}function w(){(0,n.removeClass)(a(c,this),/ht-theme-.*/g),(0,n.addClass)(a(c,this),a(u,this))}function C(){this.isClassicTheme()||l(d,this,getComputedStyle(a(c,this)));const e=h(y,this,v).call(this,["box-sizing","border-bottom-width"]);a(m,this).td={...a(m,this).td,"box-sizing":e["box-sizing"],"border-bottom-width":e["border-bottom-width"]}}function v(e){const t=a(p,this),r=a(c,this),n=t.createElement("table"),s=t.createElement("tbody"),i=t.createElement("tr"),o=t.createElement("tr"),l=t.createElement("td");o.appendChild(l),s.appendChild(i),s.appendChild(o),n.appendChild(s),r.appendChild(n);const h=getComputedStyle(l),u={};return e.forEach((e=>{u[e]=h.getPropertyValue(e)})),r.removeChild(n),u}function R(e){const t=Math.ceil(parseFloat(h(y,this,S).call(this,e)));return Number.isNaN(t)?null:t}function S(e){const t=a(d,this).getPropertyValue(e);return""===t?null:t}function T(){l(m,this,{}),l(f,this,{}),l(g,this,!0)}t.StylesHandler=class{constructor(e){var t,r;o(t=this,r=y),r.add(t),i(this,u,void 0),i(this,c,void 0),i(this,d,void 0),i(this,p,void 0),i(this,g,!0),i(this,f,{}),i(this,m,{}),l(c,this,e.rootTable.parentElement.parentElement),l(p,this,e.rootDocument)}isClassicTheme(){return a(g,this)}getCSSVariableValue(e){var t;if(a(g,this))return null;if(a(f,this)[`--ht-${e}`])return a(f,this)[`--ht-${e}`];const r=null!==(t=h(y,this,R).call(this,`--ht-${e}`))&&void 0!==t?t:h(y,this,S).call(this,`--ht-${e}`);return null!==r?(a(f,this)[`--ht-${e}`]=r,r):void 0}getStyleForTD(e){var t;return null===(t=a(m,this))||void 0===t?void 0:t.td[e]}getDefaultRowHeight(){if(a(g,this))return 23;const e=h(y,this,E).call(this);return!e&&(0,n.hasClass)(a(c,this),"ht-wrapper")?((0,s.warn)(`The "${a(u,this)}" theme is enabled, but its stylesheets are missing or not imported correctly. Import the correct CSS files in order to use that theme.`),l(g,this,!0),this.useTheme(),23):e}areCellsBorderBox(){return"border-box"===this.getStyleForTD("box-sizing")}useTheme(e){if(!e)return h(y,this,C).call(this),l(g,this,!0),void l(u,this,e||void 0);e&&e!==a(u,this)&&(a(u,this)&&h(y,this,T).call(this),l(u,this,e),l(g,this,!1),h(y,this,w).call(this),h(y,this,C).call(this))}getThemeName(){return a(u,this)}removeClassNames(){(0,n.hasClass)(a(c,this),a(u,this))&&(0,n.removeClass)(a(c,this),a(u,this))}}},16598:(e,t,r)=>{"use strict";t.__esModule=!0,r(94364);var n=r(62577),s=r(25499),i=r(63059);t.default=class{constructor(e,t,r,n,s){this.dataAccessObject=e,this.wot=e.wot,this.instance=this.wot,this.domBindings=t,this.wtSettings=r,this.wtTable=s,this.oversizedRows=[],this.oversizedColumnHeaders=[],this.hasOversizedColumnHeadersMarked={},this.clientHeight=0,this.rowHeaderWidth=NaN,this.rowsVisibleCalculator=null,this.columnsVisibleCalculator=null,this.rowsCalculatorTypes=new Map([["rendered",()=>this.wtSettings.getSetting("renderAllRows")?new i.RenderedAllRowsCalculationType:new i.RenderedRowsCalculationType],["fullyVisible",()=>new i.FullyVisibleRowsCalculationType],["partiallyVisible",()=>new i.PartiallyVisibleRowsCalculationType]]),this.columnsCalculatorTypes=new Map([["rendered",()=>this.wtSettings.getSetting("renderAllColumns")?new i.RenderedAllColumnsCalculationType:new i.RenderedColumnsCalculationType],["fullyVisible",()=>new i.FullyVisibleColumnsCalculationType],["partiallyVisible",()=>new i.PartiallyVisibleColumnsCalculationType]]),this.eventManager=n,this.eventManager.addEventListener(this.domBindings.rootWindow,"resize",(()=>{this.clientHeight=this.getWorkspaceHeight()}))}getWorkspaceHeight(){const e=this.domBindings.rootDocument,t=this.dataAccessObject.topOverlayTrimmingContainer;let r=0;if(t===this.domBindings.rootWindow)r=e.documentElement.clientHeight;else{r=(0,n.outerHeight)(t)>0&&t.clientHeight>0?t.clientHeight:1/0}return r}getViewportHeight(){let e=this.getWorkspaceHeight();if(e===1/0)return e;const t=this.getColumnHeaderHeight();return t>0&&(e-=t),e}getWorkspaceWidth(){const{rootDocument:e,rootWindow:t}=this.domBindings,r=this.dataAccessObject.inlineStartOverlayTrimmingContainer;let n;if(r===t){const t=this.wtSettings.getSetting("totalColumns");n=this.wtTable.holder.offsetWidth,this.getRowHeaderWidth()+this.sumColumnWidths(0,t)>n&&(n=e.documentElement.clientWidth)}else n=r.clientWidth;return n}getViewportWidth(){const e=this.getWorkspaceWidth();if(e===1/0)return e;const t=this.getRowHeaderWidth();return t>0?e-t:e}hasVerticalScroll(){return this.wtTable.hider.offsetHeight>this.getWorkspaceHeight()}hasHorizontalScroll(){return this.wtTable.hider.offsetWidth>this.getWorkspaceWidth()}isVerticallyScrollableByWindow(){return this.dataAccessObject.topOverlayTrimmingContainer===this.domBindings.rootWindow}isHorizontallyScrollableByWindow(){return this.dataAccessObject.inlineStartOverlayTrimmingContainer===this.domBindings.rootWindow}sumColumnWidths(e,t){let r=0,n=e;for(;n<t;)r+=this.wtTable.getColumnWidth(n),n+=1;return r}getWorkspaceOffset(){return(0,n.offset)(this.wtTable.TABLE)}getColumnHeaderHeight(){return this.wtSettings.getSetting("columnHeaders").length?isNaN(this.columnHeaderHeight)&&(this.columnHeaderHeight=(0,n.outerHeight)(this.wtTable.THEAD)):this.columnHeaderHeight=0,this.columnHeaderHeight}getRowHeaderWidth(){const e=this.wtSettings.getSetting("rowHeaderWidth"),t=this.wtSettings.getSetting("rowHeaders");if(e){this.rowHeaderWidth=0;for(let r=0,n=t.length;r<n;r++)this.rowHeaderWidth+=e[r]||e}if(isNaN(this.rowHeaderWidth))if(t.length){let e=this.wtTable.TABLE.querySelector("TH");this.rowHeaderWidth=0;for(let r=0,s=t.length;r<s;r++)e?(this.rowHeaderWidth+=(0,n.outerWidth)(e),e=e.nextSibling):this.rowHeaderWidth+=50}else this.rowHeaderWidth=0;return this.rowHeaderWidth=this.wtSettings.getSetting("onModifyRowHeaderWidth",this.rowHeaderWidth)||this.rowHeaderWidth,this.rowHeaderWidth}createRowsCalculator(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:["rendered","fullyVisible","partiallyVisible"];const{wtSettings:t,wtTable:r}=this;let s,o,a=this.getViewportHeight();this.rowHeaderWidth=NaN;let l=this.dataAccessObject.topScrollPosition-this.dataAccessObject.topParentOffset;const h=t.getSetting("fixedRowsTop"),u=t.getSetting("fixedRowsBottom"),c=t.getSetting("totalRows");return h&&l>=0&&(o=this.dataAccessObject.topOverlay.sumCellSizes(0,h),l+=o,a-=o),u&&this.dataAccessObject.bottomOverlay.clone&&(o=this.dataAccessObject.bottomOverlay.sumCellSizes(c-u,c),a-=o),s=r.holder.clientHeight===r.holder.offsetHeight?0:(0,n.getScrollbarWidth)(this.domBindings.rootDocument),new i.ViewportRowsCalculator({calculationTypes:e.map((e=>[e,this.rowsCalculatorTypes.get(e)()])),viewportHeight:a,scrollOffset:l,totalRows:t.getSetting("totalRows"),defaultRowHeight:this.instance.stylesHandler.getDefaultRowHeight(),rowHeightFn:e=>r.getRowHeight(e),overrideFn:t.getSettingPure("viewportRowCalculatorOverride"),horizontalScrollbarHeight:s})}createColumnsCalculator(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:["rendered","fullyVisible","partiallyVisible"];const{wtSettings:t,wtTable:r}=this;let s=this.getViewportWidth(),o=Math.abs(this.dataAccessObject.inlineStartScrollPosition)-this.dataAccessObject.inlineStartParentOffset;this.columnHeaderHeight=NaN;const a=t.getSetting("fixedColumnsStart");if(a&&o>=0){const e=this.dataAccessObject.inlineStartOverlay.sumCellSizes(0,a);o+=e,s-=e}return r.holder.clientWidth!==r.holder.offsetWidth&&(s-=(0,n.getScrollbarWidth)(this.domBindings.rootDocument)),new i.ViewportColumnsCalculator({calculationTypes:e.map((e=>[e,this.columnsCalculatorTypes.get(e)()])),viewportWidth:s,scrollOffset:o,totalColumns:t.getSetting("totalColumns"),columnWidthFn:e=>r.getColumnWidth(e),overrideFn:t.getSettingPure("viewportColumnCalculatorOverride"),inlineStartOffset:this.dataAccessObject.inlineStartParentOffset})}createCalculators(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];const{wtSettings:t}=this,r=this.createRowsCalculator(),n=this.createColumnsCalculator();if(e&&!t.getSetting("renderAllRows")){const t=r.getResultsFor("fullyVisible");e=this.areAllProposedVisibleRowsAlreadyRendered(t)}if(e&&!t.getSetting("renderAllColumns")){const t=n.getResultsFor("fullyVisible");e=this.areAllProposedVisibleColumnsAlreadyRendered(t)}return e||(this.rowsRenderCalculator=r.getResultsFor("rendered"),this.columnsRenderCalculator=n.getResultsFor("rendered")),this.rowsVisibleCalculator=r.getResultsFor("fullyVisible"),this.columnsVisibleCalculator=n.getResultsFor("fullyVisible"),this.rowsPartiallyVisibleCalculator=r.getResultsFor("partiallyVisible"),this.columnsPartiallyVisibleCalculator=n.getResultsFor("partiallyVisible"),e}createVisibleCalculators(){const e=this.createRowsCalculator(["fullyVisible","partiallyVisible"]),t=this.createColumnsCalculator(["fullyVisible","partiallyVisible"]);this.rowsVisibleCalculator=e.getResultsFor("fullyVisible"),this.columnsVisibleCalculator=t.getResultsFor("fullyVisible"),this.rowsPartiallyVisibleCalculator=e.getResultsFor("partiallyVisible"),this.columnsPartiallyVisibleCalculator=t.getResultsFor("partiallyVisible")}areAllProposedVisibleRowsAlreadyRendered(e){if(!this.rowsVisibleCalculator)return!1;let{startRow:t,endRow:r}=e;if(null===t&&null===r){if(!e.isVisibleInTrimmingContainer)return!0;t=this.rowsPartiallyVisibleCalculator.startRow,r=this.rowsPartiallyVisibleCalculator.endRow}const{startRow:n,endRow:s,rowStartOffset:i,rowEndOffset:o}=this.rowsRenderCalculator,a=this.wtSettings.getSetting("totalRows")-1,l=this.wtSettings.getSetting("viewportRowRenderingThreshold");return Number.isInteger(l)&&l>0?(t=Math.max(0,t-Math.min(i,l)),r=Math.min(a,r+Math.min(o,l))):"auto"===l&&(t=Math.max(0,t-Math.ceil(i/2)),r=Math.min(a,r+Math.ceil(o/2))),!(t<n||t===n&&t>0)&&!(r>s||r===s&&r<a)}areAllProposedVisibleColumnsAlreadyRendered(e){if(!this.columnsVisibleCalculator)return!1;let{startColumn:t,endColumn:r}=e;if(null===t&&null===r){if(!e.isVisibleInTrimmingContainer)return!0;t=this.columnsPartiallyVisibleCalculator.startColumn,r=this.columnsPartiallyVisibleCalculator.endColumn}const{startColumn:n,endColumn:s,columnStartOffset:i,columnEndOffset:o}=this.columnsRenderCalculator,a=this.wtSettings.getSetting("totalColumns")-1,l=this.wtSettings.getSetting("viewportColumnRenderingThreshold");return Number.isInteger(l)&&l>0?(t=Math.max(0,t-Math.min(i,l)),r=Math.min(a,r+Math.min(o,l))):"auto"===l&&(t=Math.max(0,t-Math.ceil(i/2)),r=Math.min(a,r+Math.ceil(o/2))),!(t<n||t===n&&t>0)&&!(r>s||r===s&&r<a)}resetHasOversizedColumnHeadersMarked(){(0,s.objectEach)(this.hasOversizedColumnHeadersMarked,((e,t,r)=>{r[t]=void 0}))}}},87935:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(88088);var s=n(r(83497)),i=r(45435),o=r(6521),a=r(28197),l=r(58570),h=r(1791),u=r(10912),c=r(74854),d=r(50206);function p(e,t){const r=new s.default(e,t||{},i.rootInstanceSymbol);return r.init(),r}t.CellCoords=d.CellCoords,t.CellRange=d.CellRange,(0,h.registerCellType)(u.TextCellType),p.editors={BaseEditor:c.BaseEditor},p.Core=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return new s.default(e,t,i.rootInstanceSymbol)},p.DefaultSettings=(0,o.metaSchemaFactory)(),p.hooks=a.Hooks.getSingleton(),p.CellCoords=d.CellCoords,p.CellRange=d.CellRange,p.packageName="handsontable",p.buildDate="16/12/2024 13:19:50",p.version="15.0.0",p.languages={dictionaryKeys:l.dictionaryKeys,getLanguageDictionary:l.getLanguageDictionary,getLanguagesDictionaries:l.getLanguagesDictionaries,registerLanguageDictionary:l.registerLanguageDictionary,getTranslatedPhrase:l.getTranslatedPhrase};t.default=p},76527:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(10463),s=r(36759),i=r(25799);const o=t.CELL_TYPE="autocomplete";t.AutocompleteCellType={CELL_TYPE:o,editor:n.AutocompleteEditor,renderer:s.autocompleteRenderer,validator:i.autocompleteValidator}},33023:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(76527);t.AutocompleteCellType=n.AutocompleteCellType,t.CELL_TYPE=n.CELL_TYPE},65829:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(12302),s=r(86510);const i=t.CELL_TYPE="checkbox";t.CheckboxCellType={CELL_TYPE:i,editor:n.CheckboxEditor,renderer:s.checkboxRenderer}},40834:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(65829);t.CELL_TYPE=n.CELL_TYPE,t.CheckboxCellType=n.CheckboxCellType},34135:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(16339),s=r(72375),i=r(5535);const o=t.CELL_TYPE="date";t.DateCellType={CELL_TYPE:o,editor:n.DateEditor,renderer:s.dateRenderer,validator:i.dateValidator}},41031:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(34135);t.CELL_TYPE=n.CELL_TYPE,t.DateCellType=n.DateCellType},62277:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(51034),s=r(24682),i=r(96);const o=t.CELL_TYPE="dropdown";t.DropdownCellType={CELL_TYPE:o,editor:n.DropdownEditor,renderer:s.dropdownRenderer,validator:i.dropdownValidator}},96306:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(62277);t.CELL_TYPE=n.CELL_TYPE,t.DropdownCellType=n.DropdownCellType},74845:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(82518),s=r(32278);const i=t.CELL_TYPE="handsontable";t.HandsontableCellType={CELL_TYPE:i,editor:n.HandsontableEditor,renderer:s.handsontableRenderer}},96618:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(74845);t.CELL_TYPE=n.CELL_TYPE,t.HandsontableCellType=n.HandsontableCellType},14758:(e,t,r)=>{"use strict";t.__esModule=!0,t.registerAllCellTypes=function(){(0,p.registerCellType)(n.AutocompleteCellType),(0,p.registerCellType)(s.CheckboxCellType),(0,p.registerCellType)(i.DateCellType),(0,p.registerCellType)(o.DropdownCellType),(0,p.registerCellType)(a.HandsontableCellType),(0,p.registerCellType)(l.NumericCellType),(0,p.registerCellType)(h.PasswordCellType),(0,p.registerCellType)(u.SelectCellType),(0,p.registerCellType)(c.TextCellType),(0,p.registerCellType)(d.TimeCellType)};var n=r(33023);t.AutocompleteCellType=n.AutocompleteCellType,t.AUTOCOMPLETE_TYPE=n.CELL_TYPE;var s=r(40834);t.CheckboxCellType=s.CheckboxCellType,t.CHECKBOX_TYPE=s.CELL_TYPE;var i=r(41031);t.DateCellType=i.DateCellType,t.DATE_TYPE=i.CELL_TYPE;var o=r(96306);t.DropdownCellType=o.DropdownCellType,t.DROPDOWN_TYPE=o.CELL_TYPE;var a=r(96618);t.HandsontableCellType=a.HandsontableCellType,t.HANDSONTABLE_TYPE=a.CELL_TYPE;var l=r(15718);t.NumericCellType=l.NumericCellType,t.NUMERIC_TYPE=l.CELL_TYPE;var h=r(20210);t.PasswordCellType=h.PasswordCellType,t.PASSWORD_TYPE=h.CELL_TYPE;var u=r(22315);t.SelectCellType=u.SelectCellType,t.SELECT_TYPE=u.CELL_TYPE;var c=r(10912);t.TextCellType=c.TextCellType,t.TEXT_TYPE=c.CELL_TYPE;var d=r(92858);t.TimeCellType=d.TimeCellType,t.TIME_TYPE=d.CELL_TYPE;var p=r(1791);t.registerCellType=p.registerCellType,t.getCellType=p.getCellType,t.getRegisteredCellTypeNames=p.getRegisteredCellTypeNames,t.getRegisteredCellTypes=p.getRegisteredCellTypes,t.hasCellType=p.hasCellType},15718:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(3421);t.CELL_TYPE=n.CELL_TYPE,t.NumericCellType=n.NumericCellType},3421:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(82304),s=r(17756),i=r(48636);const o=t.CELL_TYPE="numeric";t.NumericCellType={CELL_TYPE:o,editor:n.NumericEditor,renderer:s.numericRenderer,validator:i.numericValidator,dataType:"number"}},20210:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(24157);t.CELL_TYPE=n.CELL_TYPE,t.PasswordCellType=n.PasswordCellType},24157:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(14150),s=r(64910);const i=t.CELL_TYPE="password";t.PasswordCellType={CELL_TYPE:i,editor:n.PasswordEditor,renderer:s.passwordRenderer,copyable:!1}},1791:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.getCellType=function(e){if(!u(e))throw Error(`You declared cell type "${e}" as a string that is not mapped to a known object.\n                 Cell type must be an object or a string mapped to an object registered by\n                 "Handsontable.cellTypes.registerCellType" method`);return h(e)},t.registerCellType=function(e,t){"string"!=typeof e&&(e=(t=e).CELL_TYPE);const{editor:r,renderer:n,validator:s}=t;r&&(0,i.registerEditor)(e,r);n&&(0,o.registerRenderer)(e,n);s&&(0,a.registerValidator)(e,s);l(e,t)},r(67834);var s=n(r(28651)),i=r(8266),o=r(54852),a=r(17027);const{register:l,getItem:h,hasItem:u,getNames:c,getValues:d}=(0,s.default)("cellTypes");t.getRegisteredCellTypes=d,t.getRegisteredCellTypeNames=c,t.hasCellType=u},22315:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(19908);t.CELL_TYPE=n.CELL_TYPE,t.SelectCellType=n.SelectCellType},19908:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(63303),s=r(15651);const i=t.CELL_TYPE="select";t.SelectCellType={CELL_TYPE:i,editor:n.SelectEditor,renderer:s.selectRenderer}},10912:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(57489);t.CELL_TYPE=n.CELL_TYPE,t.TextCellType=n.TextCellType},57489:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(66420),s=r(85096);const i=t.CELL_TYPE="text";t.TextCellType={CELL_TYPE:i,editor:n.TextEditor,renderer:s.textRenderer}},92858:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(99421);t.CELL_TYPE=n.CELL_TYPE,t.TimeCellType=n.TimeCellType},99421:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(35442),s=r(70350),i=r(68864);const o=t.CELL_TYPE="time";t.TimeCellType={CELL_TYPE:o,editor:n.TimeEditor,renderer:s.timeRenderer,validator:i.timeValidator}},83497:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.default=function(e,t){var r,n=this;let F=arguments.length>2&&void 0!==arguments[2]&&arguments[2],U=this;const V=new h.default(U);let B,W,Y,G,j,z,$=!0;(0,T.hasValidParameter)(F)&&(0,T.registerAsRootInstance)(this);this.rootElement=e,this.rootDocument=e.ownerDocument,this.rootWindow=this.rootDocument.defaultView,this.isDestroyed=!1,this.renderSuspendedCounter=0,this.executionSuspendedCounter=0;const K=null!==(r=null==t?void 0:t.layoutDirection)&&void 0!==r?r:"inherit",X=["rtl","ltr"].includes(K)?K:this.rootWindow.getComputedStyle(this.rootElement).direction;this.rootElement.setAttribute("dir",X),this.isRtl=function(){return"rtl"===X},this.isLtr=function(){return!U.isRtl()},this.getDirectionFactor=function(){return U.isLtr()?1:-1},t.language=(0,_.getValidLanguageCode)(t.language);const q=new O.MetaManager(U,t,[O.DynamicCellMetaMod,O.ExtendMetaPropertiesMod]),Q=q.getTableMeta(),Z=q.getGlobalMeta(),J=(0,x.createUniqueMap)();this.container=this.rootDocument.createElement("div"),this.renderCall=!1,e.insertBefore(this.container,e.firstChild),(0,T.isRootInstance)(this)&&((0,o._injectProductInfo)(t.licenseKey,e),(0,s.addClass)(e,"ht-wrapper"));this.guid=`ht_${(0,E.randomString)()}`,H.set(this.guid,this),this.columnIndexMapper=new S.IndexMapper,this.rowIndexMapper=new S.IndexMapper,this.columnIndexMapper.addLocalHook("indexesSequenceChange",(e=>{U.runHooks("afterColumnSequenceChange",e)})),this.rowIndexMapper.addLocalHook("indexesSequenceChange",(e=>{U.runHooks("afterRowSequenceChange",e)})),W=new v.default(U),this.rootElement.id&&"ht_"!==this.rootElement.id.substring(0,3)||(this.rootElement.id=this.guid);let ee=new A.Selection(Q,{rowIndexMapper:U.rowIndexMapper,columnIndexMapper:U.columnIndexMapper,countCols:()=>U.countCols(),countRows:()=>U.countRows(),propToCol:e=>B.propToCol(e),isEditorOpened:()=>!!U.getActiveEditor()&&U.getActiveEditor().isOpened(),countRenderableColumns:()=>this.view.countRenderableColumns(),countRenderableRows:()=>this.view.countRenderableRows(),countRowHeaders:()=>this.countRowHeaders(),countColHeaders:()=>this.countColHeaders(),countRenderableRowsInRange:function(){return n.view.countRenderableRowsInRange(...arguments)},countRenderableColumnsInRange:function(){return n.view.countRenderableColumnsInRange(...arguments)},getShortcutManager:()=>U.getShortcutManager(),createCellCoords:(e,t)=>U._createCellCoords(e,t),createCellRange:(e,t,r)=>U._createCellRange(e,t,r),visualToRenderableCoords:e=>{const{row:t,col:r}=e;return U._createCellCoords(t>=0?U.rowIndexMapper.getRenderableFromVisualIndex(t):t,r>=0?U.columnIndexMapper.getRenderableFromVisualIndex(r):r)},renderableToVisualCoords:e=>{const{row:t,col:r}=e;return U._createCellCoords(t>=0?U.rowIndexMapper.getVisualFromRenderableIndex(t):t,r>=0?U.columnIndexMapper.getVisualFromRenderableIndex(r):r)},findFirstNonHiddenRenderableRow:(e,t)=>{const r=t>e?1:-1,n=Math.min(e,t),s=Math.max(e,t),i=U.rowIndexMapper.getNearestNotHiddenIndex(e,r);return null===i||1===r&&i>s||-1===r&&i<n?null:i>=0?U.rowIndexMapper.getRenderableFromVisualIndex(i):i},findFirstNonHiddenRenderableColumn:(e,t)=>{const r=t>e?1:-1,n=Math.min(e,t),s=Math.max(e,t),i=U.columnIndexMapper.getNearestNotHiddenIndex(e,r);return null===i||1===r&&i>s||-1===r&&i<n?null:i>=0?U.columnIndexMapper.getRenderableFromVisualIndex(i):i},isDisabledCellSelection:(e,t)=>e<0||t<0?U.getSettings().disableVisualSelection:U.getCellMeta(e,t).disableVisualSelection});this.selection=ee;const te=e=>{let{hiddenIndexesChanged:t}=e;t&&this.selection.commit()};function re(e){const t=(0,b.normalizeLanguageCode)(e);(0,_.hasLanguageDictionary)(t)?(U.runHooks("beforeLanguageChange",t),Z.language=t,U.runHooks("afterLanguageChange",t)):(0,b.warnUserAboutLanguageRegistration)(e)}function ne(e,t){const r="className"===e?U.rootElement:U.table;if($)(0,s.addClass)(r,t);else{let n=[],i=[];Z[e]&&(n=Array.isArray(Z[e])?Z[e]:(0,d.stringToArray)(Z[e])),t&&(i=Array.isArray(t)?t:(0,d.stringToArray)(t));const o=(0,d.getDifferenceOfArrays)(n,i),a=(0,d.getDifferenceOfArrays)(i,n);o.length&&(0,s.removeClass)(r,o),a.length&&(0,s.addClass)(r,a)}Z[e]=t}function se(){let e=!1;return{validatorsInQueue:0,valid:!0,addValidatorToQueue(){this.validatorsInQueue+=1,e=!1},removeValidatorFormQueue(){this.validatorsInQueue=this.validatorsInQueue-1<0?0:this.validatorsInQueue-1,this.checkIfQueueIsEmpty()},onQueueEmpty(){},checkIfQueueIsEmpty(){0===this.validatorsInQueue&&!1===e&&(e=!0,this.onQueueEmpty(this.valid))}}}function ie(e){const t=e.replace(",",".");return!1===isNaN(parseFloat(t))?parseFloat(t):e}function oe(e,t,r){if(!e.length)return void r();const n=U.getActiveEditor(),s=new se;let i=!0;s.onQueueEmpty=()=>{n&&i&&n.cancelChanges(),r()};for(let r=e.length-1;r>=0;r--){const[n,o,,a]=e[r],l=B.propToCol(o);let h;h=Number.isInteger(l)?U.getCellMeta(n,l):{...Object.getPrototypeOf(Q),...Q},"numeric"===h.type&&"string"==typeof a&&(0,w.isNumericLike)(a)&&(e[r][3]=ie(a)),U.getCellValidator(h)&&(s.addValidatorToQueue(),U.validateCell(e[r][3],h,function(t,r){return function(n){if("boolean"!=typeof n)throw new Error("Validation error: result is not boolean");!1===n&&!1===r.allowInvalid&&(i=!1,e.splice(t,1),r.valid=!0),s.removeValidatorFormQueue()}}(r,h),t))}s.checkIfQueueIsEmpty()}function ae(e,t){for(let r=e.length-1;r>=0;r--){let n=!1;if(null!==e[r]){if(null!==e[r][2]&&void 0!==e[r][2]||null!==e[r][3]&&void 0!==e[r][3]){if(Q.allowInsertRow)for(;e[r][0]>U.countRows()-1;){const{delta:e}=B.createRow(void 0,void 0,{source:t});if(0===e){n=!0;break}}if("array"===U.dataType&&(!Q.columns||0===Q.columns.length)&&Q.allowInsertColumn)for(;B.propToCol(e[r][1])>U.countCols()-1;){const{delta:e}=B.createCol(void 0,void 0,{source:t});if(0===e){n=!0;break}}n||B.set(e[r][0],e[r][1],e[r][3])}}else e.splice(r,1)}const r=e.length>0;if(U.forceFullRender=!0,r){Y.adjustRowsAndCols(),U.runHooks("beforeChangeRender",e,t),G.closeEditor(),U.view.render(),G.prepareEditor(),U.view.adjustElementsSize(),U.runHooks("afterChange",e,t||"edit");const r=U.getActiveEditor();r&&(0,o.isDefined)(r.refreshValue)&&r.refreshValue()}else U.view.render()}function le(e,t,r){return Array.isArray(e)?e:[[e,t,r]]}function he(e,t){const r=U.getActiveEditor(),n=U.runHooks("beforeChange",e,t||"edit"),s=e.filter((e=>null!==e));return!1===n||0===s.length?(r&&r.cancelChanges(),[]):s}this.columnIndexMapper.addLocalHook("cacheUpdated",te),this.rowIndexMapper.addLocalHook("cacheUpdated",te),this.selection.addLocalHook("afterSetRangeEnd",((e,t)=>{const r=(0,u.createObjectPropListener)(!1),n=this.selection.getSelectedRange(),{from:i,to:o}=n.current(),a=n.size()-1;this.runHooks("afterSelection",i.row,i.col,o.row,o.col,r,a),this.runHooks("afterSelectionByProp",i.row,U.colToProp(i.col),o.row,U.colToProp(o.col),r,a),t&&(!r.isTouched()||r.isTouched()&&!r.value)&&z.scrollTo(e);const l=ee.isSelectedByRowHeader(),h=ee.isSelectedByColumnHeader();l&&h?(0,s.addClass)(this.rootElement,["ht__selection--rows","ht__selection--columns"]):l?((0,s.removeClass)(this.rootElement,"ht__selection--columns"),(0,s.addClass)(this.rootElement,"ht__selection--rows")):h?((0,s.removeClass)(this.rootElement,"ht__selection--rows"),(0,s.addClass)(this.rootElement,"ht__selection--columns")):(0,s.removeClass)(this.rootElement,["ht__selection--rows","ht__selection--columns"]),"shift"!==ee.getSelectionSource()&&G.closeEditor(null),U.view.render(),G.prepareEditor()})),this.selection.addLocalHook("beforeSetFocus",(e=>{this.runHooks("beforeSelectionFocusSet",e.row,e.col)})),this.selection.addLocalHook("afterSetFocus",(e=>{const t=(0,u.createObjectPropListener)(!1);this.runHooks("afterSelectionFocusSet",e.row,e.col,t),(!t.isTouched()||t.isTouched()&&!t.value)&&z.scrollTo(e),G.closeEditor(),U.view.render(),G.prepareEditor()})),this.selection.addLocalHook("afterSelectionFinished",(e=>{const t=e.length-1,{from:r,to:n}=e[t];this.runHooks("afterSelectionEnd",r.row,r.col,n.row,n.col,t),this.runHooks("afterSelectionEndByProp",r.row,U.colToProp(r.col),n.row,U.colToProp(n.col),t)})),this.selection.addLocalHook("afterIsMultipleSelection",(e=>{const t=this.runHooks("afterIsMultipleSelection",e.value);e.value&&(e.value=t)})),this.selection.addLocalHook("afterDeselect",(()=>{G.closeEditor(),U.view.render(),(0,s.removeClass)(this.rootElement,["ht__selection--rows","ht__selection--columns"]),this.runHooks("afterDeselect")})),this.selection.addLocalHook("beforeHighlightSet",(()=>this.runHooks("beforeSelectionHighlightSet"))).addLocalHook("beforeSetRangeStart",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("beforeSetRangeStart",...t)})).addLocalHook("beforeSetRangeStartOnly",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("beforeSetRangeStartOnly",...t)})).addLocalHook("beforeSetRangeEnd",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("beforeSetRangeEnd",...t)})).addLocalHook("beforeSelectColumns",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("beforeSelectColumns",...t)})).addLocalHook("afterSelectColumns",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("afterSelectColumns",...t)})).addLocalHook("beforeSelectRows",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("beforeSelectRows",...t)})).addLocalHook("afterSelectRows",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("afterSelectRows",...t)})).addLocalHook("beforeModifyTransformStart",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("modifyTransformStart",...t)})).addLocalHook("afterModifyTransformStart",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("afterModifyTransformStart",...t)})).addLocalHook("beforeModifyTransformFocus",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("modifyTransformFocus",...t)})).addLocalHook("afterModifyTransformFocus",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("afterModifyTransformFocus",...t)})).addLocalHook("beforeModifyTransformEnd",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("modifyTransformEnd",...t)})).addLocalHook("afterModifyTransformEnd",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("afterModifyTransformEnd",...t)})).addLocalHook("beforeRowWrap",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("beforeRowWrap",...t)})).addLocalHook("beforeColumnWrap",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.runHooks("beforeColumnWrap",...t)})).addLocalHook("insertRowRequire",(e=>this.alter("insert_row_above",e,1,"auto"))).addLocalHook("insertColRequire",(e=>this.alter("insert_col_start",e,1,"auto"))),Y={alter(e,t){var r,n;let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:1,i=arguments.length>3?arguments[3]:void 0,a=arguments.length>4?arguments[4]:void 0;const l=e=>{if(0===e.length)return[];const t=[...e];t.sort(((e,t)=>{let[r]=e,[n]=t;return r===n?0:r>n?1:-1}));return(0,d.arrayReduce)(t,((e,t)=>{let[r,n]=t;const s=e[e.length-1],[i,o]=s,a=i+o;if(r<=a){const e=Math.max(n-(a-r),0);s[1]+=e}else e.push([r,n]);return e}),[t[0]])};switch(e){case"insert_row_below":case"insert_row_above":const a=U.countSourceRows();if(Q.maxRows===a)return;const h="insert_row_below"===e?"below":"above";t=null!==(r=t)&&void 0!==r?r:"below"===h?a:0;const{delta:u,startPhysicalIndex:c}=B.createRow(t,s,{source:i,mode:h});ee.shiftRows(U.toVisualRow(c),u);break;case"insert_col_start":case"insert_col_end":const p="insert_col_end"===e?"end":"start";t=null!==(n=t)&&void 0!==n?n:"end"===p?U.countSourceCols():0;const{delta:g,startPhysicalIndex:f}=B.createCol(t,s,{source:i,mode:p});if(g){if(Array.isArray(Q.colHeaders)){const e=[U.toVisualColumn(f),0];e.length+=g,Array.prototype.splice.apply(Q.colHeaders,e)}ee.shiftColumns(U.toVisualColumn(f),g)}break;case"remove_row":const m=e=>{let t=0;(0,d.arrayEach)(e,(e=>{let[r,n]=e;const s=(0,o.isEmpty)(r)?U.countRows()-1:Math.max(r-t,0);Number.isInteger(r)&&(r=Math.max(r-t,0));if(!B.removeRow(r,n,i))return;if(ee.isSelected()){const{row:e}=U.getSelectedRangeLast().highlight;e>=r&&e<=r+n-1&&G.closeEditor(!0)}const a=U.countRows();0===a?ee.deselect():"ContextMenu.removeRow"===i?ee.refresh():ee.shiftRows(r,-n);const l=Q.fixedRowsTop;l>=s+1&&(Q.fixedRowsTop-=Math.min(n,l-s));const h=Q.fixedRowsBottom;h&&s>=a-h&&(Q.fixedRowsBottom-=Math.min(n,h)),t+=n}))};Array.isArray(t)?m(l(t)):m([[t,s]]);break;case"remove_col":const y=e=>{let t=0;(0,d.arrayEach)(e,(e=>{let[r,n]=e;const s=(0,o.isEmpty)(r)?U.countCols()-1:Math.max(r-t,0);let a=U.toPhysicalColumn(s);Number.isInteger(r)&&(r=Math.max(r-t,0));if(!B.removeCol(r,n,i))return;if(ee.isSelected()){const{col:e}=U.getSelectedRangeLast().highlight;e>=r&&e<=r+n-1&&G.closeEditor(!0)}0===U.countCols()?ee.deselect():"ContextMenu.removeColumn"===i?ee.refresh():ee.shiftColumns(r,-n);const l=Q.fixedColumnsStart;l>=s+1&&(Q.fixedColumnsStart-=Math.min(n,l-s)),Array.isArray(Q.colHeaders)&&(void 0===a&&(a=-1),Q.colHeaders.splice(a,n)),t+=n}))};Array.isArray(t)?y(l(t)):y([[t,s]]);break;default:throw new Error(`There is no such action "${e}"`)}U.view.render(),a||Y.adjustRowsAndCols()},adjustRowsAndCols(){const e=Q.minRows,t=Q.minSpareRows,r=Q.minCols,n=Q.minSpareCols;if(e){const t=U.countRows();t<e&&B.createRow(t,e-t,{source:"auto"})}if(t){const e=U.countEmptyRows(!0);if(e<t){const r=t-e,n=Math.min(r,Q.maxRows-U.countSourceRows());B.createRow(U.countRows(),n,{source:"auto"})}}{let e;(r||n)&&(e=U.countEmptyCols(!0));let t=U.countCols();if(r&&!Q.columns&&t<r){const n=r-t;e+=n,B.createCol(t,n,{source:"auto"})}if(n&&!Q.columns&&"array"===U.dataType&&e<n){t=U.countCols();const r=n-e,s=Math.min(r,Q.maxCols-t);B.createCol(t,s,{source:"auto"})}}U.view&&U.view.adjustElementsSize()},populateFromArray(e,t,r,n,s){let i,o,a,l;const h=[],c={},p=[],g=e.row,f=e.col;if(o=t.length,0===o)return!1;let m=0,y=0;switch((0,u.isObject)(r)&&(m=r.col-f+1,y=r.row-g+1),s){case"shift_down":const s=(0,d.pivot)(t),E=s.length,w=Math.max(E,m),C=U.getData().slice(g),v=(0,d.pivot)(C).slice(f,f+w);for(a=0;a<w;a+=1)if(a<E){for(i=0,o=s[a].length;i<y-o;i+=1)s[a].push(s[a][i%o]);a<v.length?p.push(s[a].concat(v[a])):p.push(s[a].concat(new Array(C.length).fill(null)))}else p.push(s[a%E].concat(v[a]));U.populateFromArray(g,f,(0,d.pivot)(p));break;case"shift_right":const R=t.length,S=Math.max(R,y),T=U.getData().slice(g).map((e=>e.slice(f)));for(i=0;i<S;i+=1)if(i<R){for(a=0,l=t[i].length;a<m-l;a+=1)t[i].push(t[i][a%l]);if(i<T.length)for(let e=0;e<T[i].length;e+=1)t[i].push(T[i][e]);else t[i].push(...new Array(T[0].length).fill(null))}else t.push(t[i%o].slice(0,S).concat(T[i]));U.populateFromArray(g,f,t);break;default:c.row=e.row,c.col=e.col;let N,M=0,_=0,b=!0;const A=function(e){let r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;const n=t[e%t.length];return null!==r?n[r%n.length]:n},O=t.length,I=r?r.row-e.row+1:0;for(o=r?I:Math.max(O,I),i=0;i<o&&!(r&&c.row>r.row&&I>O||!Q.allowInsertRow&&c.row>U.countRows()-1||c.row>=Q.maxRows);i++){const t=i-M,s=A(t).length,d=r?r.col-e.col+1:0;if(l=r?d:Math.max(s,d),c.col=e.col,N=U.getCellMeta(c.row,c.col),"CopyPaste.paste"!==n&&"Autofill.fill"!==n||!N.skipRowOnPaste){for(_=0,a=0;a<l&&!(r&&c.col>r.col&&d>s||!Q.allowInsertColumn&&c.col>U.countCols()-1||c.col>=Q.maxCols);a++){if(N=U.getCellMeta(c.row,c.col),("CopyPaste.paste"===n||"Autofill.fill"===n)&&N.skipColumnOnPaste){_+=1,c.col+=1,l+=1;continue}if(N.readOnly&&"UndoRedo.undo"!==n){c.col+=1;continue}let e=A(t,a-_),r=U.getDataAtCell(c.row,c.col);if(null!==e&&"object"==typeof e)if(Array.isArray(e)&&null===r&&(r=[]),null===r||"object"!=typeof r)b=!1;else{const t=(0,u.duckSchema)(Array.isArray(r)?r:r[0]||r),n=(0,u.duckSchema)(Array.isArray(e)?e:e[0]||e);(0,u.isObjectEqual)(t,n)||Array.isArray(t)&&Array.isArray(n)?e=(0,u.deepClone)(e):b=!1}else null!==r&&"object"==typeof r&&(b=!1);b&&h.push([c.row,c.col,e]),b=!0,c.col+=1}c.row+=1}else M+=1,c.row+=1,o+=1}U.setDataAtCell(h,null,null,n||"populateFromArray")}}},this.init=function(){W.setData(Q.data),U.runHooks("beforeInit"),((0,a.isMobileBrowser)()||(0,a.isIpadOS)())&&(0,s.addClass)(U.rootElement,"mobile"),this.updateSettings(Q,!0),this.view=new C.default(this);const e=Q.themeName||(0,D.getThemeClassName)(U.rootElement);U.useTheme(e),U.view.addClassNameToLicenseElement(U.getCurrentThemeName()),G=l.default.getInstance(U,Q,ee),z=(0,I.createViewportScroller)(U),j=new c.FocusManager(U),(0,T.isRootInstance)(this)&&(0,I.installFocusCatcher)(U),U.runHooks("init"),this.forceFullRender=!0,this.view.render(),$&&null===U.rootElement.offsetParent&&(0,s.observeVisibilityChangeOnce)(U.rootElement,(()=>{U.view._wt.wtOverlays.updateLastSpreaderSize(),U.render(),U.view.adjustElementsSize()})),"object"==typeof $&&(U.runHooks("afterChange",$[0],$[1]),$=!1),U.runHooks("afterInit")},this._createCellCoords=function(e,t){return U.view._wt.createCellCoords(e,t)},this._createCellRange=function(e,t,r){return U.view._wt.createCellRange(e,t,r)},this.validateCell=function(e,t,r,n){let s=U.getCellValidator(t);function a(e){if(!(!(arguments.length>1&&void 0!==arguments[1])||arguments[1])||!0===t.hidden)return void r(e);const n=t.visualCol,s=t.visualRow,i=U.getCell(s,n,!0);if(i&&"TH"!==i.nodeName){const e=U.rowIndexMapper.getRenderableFromVisualIndex(s),t=U.columnIndexMapper.getRenderableFromVisualIndex(n);U.view._wt.getSetting("cellRenderer",e,t,i)}r(e)}var l;(0,o.isRegExp)(s)&&(l=s,s=function(e,t){t(l.test(e))}),(0,i.isFunction)(s)?(e=U.runHooks("beforeValidate",e,t.visualRow,t.prop,n),U._registerImmediate((()=>{s.call(t,e,(r=>{U&&(r=U.runHooks("afterValidate",r,e,t.visualRow,t.prop,n),t.valid=r,a(r),U.runHooks("postAfterValidate",r,e,t.visualRow,t.prop,n))}))}))):U._registerImmediate((()=>{t.valid=!0,a(t.valid,!1)}))},this.setDataAtCell=function(e,t,r,n){const s=le(e,t,r),i=[];let o,a,l,h=n;for(o=0,a=s.length;o<a;o++){if("object"!=typeof s[o])throw new Error("Method `setDataAtCell` accepts row number or changes array of arrays as its first parameter");if("number"!=typeof s[o][1])throw new Error("Method `setDataAtCell` accepts row and column number as its parameters. If you want to use object property name, use method `setDataAtRowProp`");l=s[o][1]>=this.countCols()?s[o][1]:B.colToProp(s[o][1]),i.push([s[o][0],l,W.getAtCell(this.toPhysicalRow(s[o][0]),s[o][1]),s[o][2]])}h||"object"!=typeof e||(h=t);const u=he(i,h);U.runHooks("afterSetDataAtCell",u,h),oe(u,h,(()=>{ae(u,h)}))},this.setDataAtRowProp=function(e,t,r,n){const s=le(e,t,r),i=[];let o,a,l=n;for(o=0,a=s.length;o<a;o++)i.push([s[o][0],s[o][1],W.getAtCell(this.toPhysicalRow(s[o][0]),s[o][1]),s[o][2]]);l||"object"!=typeof e||(l=t);const h=he(i,n);U.runHooks("afterSetDataAtRowProp",h,l),oe(h,l,(()=>{ae(h,l)}))},this.listen=function(){U&&!U.isListening()&&(H.forEach((e=>{U!==e&&e.unlisten()})),k=U.guid,U.runHooks("afterListen"))},this.unlisten=function(){this.isListening()&&(k=null,U.runHooks("afterUnlisten"))},this.isListening=function(){return k===U.guid},this.destroyEditor=function(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0],t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];G.closeEditor(e),U.view.render(),t&&ee.isSelected()&&G.prepareEditor()},this.populateFromArray=function(e,t,r,n,s,i,o){if("object"!=typeof r||"object"!=typeof r[0])throw new Error("populateFromArray parameter `input` must be an array of arrays");const a="number"==typeof n?U._createCellCoords(n,s):null;return Y.populateFromArray(U._createCellCoords(e,t),r,a,i,o)},this.spliceCol=function(e,t,r){for(var n=arguments.length,s=new Array(n>3?n-3:0),i=3;i<n;i++)s[i-3]=arguments[i];return B.spliceCol(e,t,r,...s)},this.spliceRow=function(e,t,r){for(var n=arguments.length,s=new Array(n>3?n-3:0),i=3;i<n;i++)s[i-3]=arguments[i];return B.spliceRow(e,t,r,...s)},this.getSelected=function(){if(ee.isSelected())return(0,d.arrayMap)(ee.getSelectedRange(),(e=>{let{from:t,to:r}=e;return[t.row,t.col,r.row,r.col]}))},this.getSelectedLast=function(){const e=this.getSelected();let t;return e&&e.length>0&&(t=e[e.length-1]),t},this.getSelectedRange=function(){if(ee.isSelected())return Array.from(ee.getSelectedRange())},this.getSelectedRangeLast=function(){const e=this.getSelectedRange();let t;return e&&e.length>0&&(t=e[e.length-1]),t},this.emptySelectedCells=function(e){if(!ee.isSelected()||0===this.countRows()||0===this.countCols())return;const t=[];(0,d.arrayEach)(ee.getSelectedRange(),(e=>{if(e.isSingleHeader())return;const r=e.getTopStartCorner(),n=e.getBottomEndCorner();(0,w.rangeEach)(r.row,n.row,(e=>{(0,w.rangeEach)(r.col,n.col,(r=>{this.getCellMeta(e,r).readOnly||t.push([e,r,null])}))}))})),t.length>0&&this.setDataAtCell(t,e)},this.isRenderSuspended=function(){return this.renderSuspendedCounter>0},this.suspendRender=function(){this.renderSuspendedCounter+=1},this.resumeRender=function(){const e=this.renderSuspendedCounter-1;this.renderSuspendedCounter=Math.max(e,0),this.isRenderSuspended()||e!==this.renderSuspendedCounter||(this.renderCall?this.render():U.view.render())},this.render=function(){this.view&&(this.renderCall=!0,this.forceFullRender=!0,this.isRenderSuspended()||U.view.render())},this.batchRender=function(e){this.suspendRender();const t=e();return this.resumeRender(),t},this.isExecutionSuspended=function(){return this.executionSuspendedCounter>0},this.suspendExecution=function(){this.executionSuspendedCounter+=1,this.columnIndexMapper.suspendOperations(),this.rowIndexMapper.suspendOperations()},this.resumeExecution=function(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];const t=this.executionSuspendedCounter-1;this.executionSuspendedCounter=Math.max(t,0),(!this.isExecutionSuspended()&&t===this.executionSuspendedCounter||e)&&(this.columnIndexMapper.resumeOperations(),this.rowIndexMapper.resumeOperations())},this.batchExecution=function(e){let t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];this.suspendExecution();const r=e();return this.resumeExecution(t),r},this.batch=function(e){this.suspendRender(),this.suspendExecution();const t=e();return this.resumeExecution(),this.resumeRender(),t},this.refreshDimensions=function(){if(!U.view)return;const{width:e,height:t}=U.view.getLastSize(),{width:r,height:n}=U.rootElement.getBoundingClientRect(),s=r!==e||n!==t;!1===U.runHooks("beforeRefreshDimensions",{width:e,height:t},{width:r,height:n},s)||((s||U.view._wt.wtOverlays.scrollableElement===U.rootWindow)&&(U.view.setLastSize(r,n),U.render()),U.runHooks("afterRefreshDimensions",{width:e,height:t},{width:r,height:n},s))},this.updateData=function(e,t){(0,O.replaceData)(e,(e=>{B=e}),(e=>{B=e,U.columnIndexMapper.fitToLength(this.getInitialColumnCount()),U.rowIndexMapper.fitToLength(this.countSourceRows()),Y.adjustRowsAndCols(),ee.refresh()}),{hotInstance:U,dataMap:B,dataSource:W,internalSource:"updateData",source:t,metaManager:q,firstRun:$})},this.loadData=function(e,t){(0,O.replaceData)(e,(e=>{B=e}),(()=>{q.clearCellsCache(),U.initIndexMappers(),Y.adjustRowsAndCols(),ee.refresh(),$&&($=[null,"loadData"])}),{hotInstance:U,dataMap:B,dataSource:W,internalSource:"loadData",source:t,metaManager:q,firstRun:$})},this.getInitialColumnCount=function(){const e=Q.columns;let t=0;if(Array.isArray(e))t=e.length;else if((0,i.isFunction)(e))if("array"===U.dataType){const r=this.countSourceCols();for(let n=0;n<r;n+=1)e(n)&&(t+=1)}else"object"!==U.dataType&&"function"!==U.dataType||(t=B.colToPropCache.length);else if((0,o.isDefined)(Q.dataSchema)){const e=B.getSchema();t=Array.isArray(e)?e.length:(0,u.deepObjectSize)(e)}else t=this.countSourceCols();return t},this.initIndexMappers=function(){this.columnIndexMapper.initToLength(this.getInitialColumnCount()),this.rowIndexMapper.initToLength(this.countSourceRows())},this.getData=function(e,t,r,n){return(0,o.isUndefined)(e)?B.getAll():B.getRange(U._createCellCoords(e,t),U._createCellCoords(r,n),B.DESTINATION_RENDERER)},this.getCopyableText=function(e,t,r,n){return B.getCopyableText(U._createCellCoords(e,t),U._createCellCoords(r,n))},this.getCopyableData=function(e,t){return B.getCopyable(e,B.colToProp(t))},this.getSchema=function(){return B.getSchema()},this.updateSettings=function(e){let t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];const r=($?U.loadData:U.updateData).bind(this);let n,s,a=!1;if((0,o.isDefined)(e.rows))throw new Error('The "rows" setting is no longer supported. Do you mean startRows, minRows or maxRows?');if((0,o.isDefined)(e.cols))throw new Error('The "cols" setting is no longer supported. Do you mean startCols, minCols or maxCols?');if((0,o.isDefined)(e.ganttChart))throw new Error('Since 8.0.0 the "ganttChart" setting is no longer supported.');for(n in e)"data"===n||("language"===n?re(e.language):"className"===n?ne("className",e.className):"tableClassName"===n&&U.table?(ne("tableClassName",e.tableClassName),U.view._wt.wtOverlays.syncOverlayTableClassNames()):M.Hooks.getSingleton().isRegistered(n)||M.Hooks.getSingleton().isDeprecated(n)?(0,i.isFunction)(e[n])?M.Hooks.getSingleton().addAsFixed(n,e[n],U):Array.isArray(e[n])&&M.Hooks.getSingleton().add(n,e[n],U):!t&&(0,u.hasOwnProperty)(e,n)&&(Z[n]=e[n]));void 0===e.data&&void 0===Q.data?r(null,"updateSettings"):void 0!==e.data?r(e.data,"updateSettings"):void 0!==e.columns&&(B.createMap(),U.initIndexMappers());const l=U.countCols(),h=Q.columns;if(h&&(0,i.isFunction)(h)&&(a=!0),void 0===e.cell&&void 0===e.cells&&void 0===e.columns||q.clearCache(),l>0)for(n=0,s=0;n<l;n++){if(h){const e=a?h(n):h[s];e&&q.updateColumnMeta(s,e)}s+=1}(0,o.isDefined)(e.cell)&&(0,u.objectEach)(e.cell,(e=>{U.setCellMetaObject(e.row,e.col,e)})),U.runHooks("afterCellMetaReset");let c=U.rootElement.style.height;""!==c&&(c=parseInt(U.rootElement.style.height,10));let d=e.height;if((0,i.isFunction)(d)&&(d=d()),t){U.rootElement.getAttribute("style")&&U.rootElement.setAttribute("data-initialstyle",U.rootElement.getAttribute("style"))}if(null===d){const e=U.rootElement.getAttribute("data-initialstyle");e&&(e.indexOf("height")>-1||e.indexOf("overflow")>-1)?U.rootElement.setAttribute("style",e):(U.rootElement.style.height="",U.rootElement.style.overflow="")}else void 0!==d&&(U.rootElement.style.height=isNaN(d)?`${d}`:`${d}px`,U.rootElement.style.overflow="hidden");if(void 0!==e.width){let t=e.width;(0,i.isFunction)(t)&&(t=t()),U.rootElement.style.width=isNaN(t)?`${t}`:`${t}px`}if(!t){if(U.view){U.view._wt.wtViewport.resetHasOversizedColumnHeadersMarked(),U.view._wt.exportSettingsAsClassNames();const t=U.getCurrentThemeName(),r=(0,u.hasOwnProperty)(e,"themeName");t&&r&&(U.view.getStylesHandler().removeClassNames(),U.view.removeClassNameFromLicenseElement(t));const n=r&&e.themeName||(0,D.getThemeClassName)(U.rootElement);U.useTheme(n),U.view.addClassNameToLicenseElement(U.getCurrentThemeName())}U.runHooks("afterUpdateSettings",e)}Y.adjustRowsAndCols(),U.view&&!$&&(U.forceFullRender=!0,U.view.render(),U.view._wt.wtOverlays.adjustElementsSize()),t||!U.view||""!==c&&""!==d&&void 0!==d||c===d||U.view._wt.wtOverlays.updateMainScrollableElements()},this.getValue=function(){const e=U.getSelectedLast();if(Q.getValue){if((0,i.isFunction)(Q.getValue))return Q.getValue.call(U);if(e)return U.getData()[e[0][0]][Q.getValue]}else if(e)return U.getDataAtCell(e[0],e[1])},this.getSettings=function(){return Q},this.clear=function(){this.selectAll(),this.emptySelectedCells()},this.alter=function(e,t,r,n,s){Y.alter(e,t,r,n,s)},this.getCell=function(e,t){let r=arguments.length>2&&void 0!==arguments[2]&&arguments[2],n=t,s=e;if(t>=0){if(this.columnIndexMapper.isHidden(this.toPhysicalColumn(t)))return null;n=this.columnIndexMapper.getRenderableFromVisualIndex(t)}if(e>=0){if(this.rowIndexMapper.isHidden(this.toPhysicalRow(e)))return null;s=this.rowIndexMapper.getRenderableFromVisualIndex(e)}return null===s||null===n||void 0===s||void 0===n?null:U.view.getCellAtCoords(U._createCellCoords(s,n),r)},this.getCoords=function(e){const t=this.view._wt.wtTable.getCoords(e);if(null===t)return null;const{row:r,col:n}=t;let s=r,i=n;return r>=0&&(s=this.rowIndexMapper.getVisualFromRenderableIndex(r)),n>=0&&(i=this.columnIndexMapper.getVisualFromRenderableIndex(n)),U._createCellCoords(s,i)},this.colToProp=function(e){return B.colToProp(e)},this.propToCol=function(e){return B.propToCol(e)},this.toVisualRow=e=>this.rowIndexMapper.getVisualFromPhysicalIndex(e),this.toVisualColumn=e=>this.columnIndexMapper.getVisualFromPhysicalIndex(e),this.toPhysicalRow=e=>this.rowIndexMapper.getPhysicalFromVisualIndex(e),this.toPhysicalColumn=e=>this.columnIndexMapper.getPhysicalFromVisualIndex(e),this.getDataAtCell=function(e,t){return B.get(e,B.colToProp(t))},this.getDataAtRowProp=function(e,t){return B.get(e,t)},this.getDataAtCol=function(e){const t=[],r=B.getRange(U._createCellCoords(0,e),U._createCellCoords(Q.data.length-1,e),B.DESTINATION_RENDERER);for(let e=0;e<r.length;e+=1)for(let n=0;n<r[e].length;n+=1)t.push(r[e][n]);return t},this.getDataAtProp=function(e){const t=[],r=B.getRange(U._createCellCoords(0,B.propToCol(e)),U._createCellCoords(Q.data.length-1,B.propToCol(e)),B.DESTINATION_RENDERER);for(let e=0;e<r.length;e+=1)for(let n=0;n<r[e].length;n+=1)t.push(r[e][n]);return t},this.getSourceData=function(e,t,r,n){let s;return s=void 0===e?W.getData():W.getByRange(U._createCellCoords(e,t),U._createCellCoords(r,n)),s},this.getSourceDataArray=function(e,t,r,n){let s;return s=void 0===e?W.getData(!0):W.getByRange(U._createCellCoords(e,t),U._createCellCoords(r,n),!0),s},this.getSourceDataAtCol=function(e){return W.getAtColumn(e)},this.setSourceDataAtCell=function(e,t,r,n){const s=le(e,t,r),i=this.hasHook("afterSetSourceDataAtCell"),a=[];i&&(0,d.arrayEach)(s,(e=>{let[t,r,n]=e;a.push([t,r,W.getAtCell(t,r),n])})),(0,d.arrayEach)(s,(e=>{let[t,r,n]=e;W.setAtCell(t,r,n)})),i&&this.runHooks("afterSetSourceDataAtCell",a,n),this.render();const l=U.getActiveEditor();l&&(0,o.isDefined)(l.refreshValue)&&l.refreshValue()},this.getSourceDataAtRow=function(e){return W.getAtRow(e)},this.getSourceDataAtCell=function(e,t){return W.getAtCell(e,t)},this.getDataAtRow=function(e){return B.getRange(U._createCellCoords(e,0),U._createCellCoords(e,this.countCols()-1),B.DESTINATION_RENDERER)[0]||[]},this.getDataType=function(e,t,r,n){const s=void 0===e?[0,0,this.countRows(),this.countCols()]:[e,t,r,n],[i,o]=s;let[,,a,l]=s,h=null,u=null;void 0===a&&(a=i),void 0===l&&(l=o);let c="mixed";return(0,w.rangeEach)(Math.max(Math.min(i,a),0),Math.max(i,a),(e=>{let t=!0;return(0,w.rangeEach)(Math.max(Math.min(o,l),0),Math.max(o,l),(r=>{const n=this.getCellMeta(e,r);return u=n.type,h?t=h===u:h=u,t})),c=t?u:"mixed",t})),c},this.removeCellMeta=function(e,t,r){const[n,s]=[this.toPhysicalRow(e),this.toPhysicalColumn(t)];let i=q.getCellMetaKeyValue(n,s,r);!1!==U.runHooks("beforeRemoveCellMeta",e,t,r,i)&&(q.removeCellMeta(n,s,r),U.runHooks("afterRemoveCellMeta",e,t,r,i)),i=null},this.spliceCellsMeta=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;for(var r=arguments.length,n=new Array(r>2?r-2:0),s=2;s<r;s++)n[s-2]=arguments[s];if(n.length>0&&!Array.isArray(n[0]))throw new Error("The 3rd argument (cellMetaRows) has to be passed as an array of cell meta objects array.");t>0&&q.removeRow(this.toPhysicalRow(e),t),n.length>0&&(0,d.arrayEach)(n.reverse(),(t=>{q.createRow(this.toPhysicalRow(e)),(0,d.arrayEach)(t,((t,r)=>this.setCellMetaObject(e,r,t)))})),U.render()},this.setCellMetaObject=function(e,t,r){"object"==typeof r&&(0,u.objectEach)(r,((r,n)=>{this.setCellMeta(e,t,n,r)}))},this.setCellMeta=function(e,t,r,n){if(!1===U.runHooks("beforeSetCellMeta",e,t,r,n))return;let s=e,i=t;e<this.countRows()&&(s=this.toPhysicalRow(e)),t<this.countCols()&&(i=this.toPhysicalColumn(t)),q.setCellMeta(s,i,r,n),U.runHooks("afterSetCellMeta",e,t,r,n)},this.getCellsMeta=function(){return q.getCellsMeta()},this.getCellMeta=function(e,t){let r=this.toPhysicalRow(e),n=this.toPhysicalColumn(t);return null===r&&(r=e),null===n&&(n=t),q.getCellMeta(r,n,{visualRow:e,visualColumn:t})},this.getColumnMeta=function(e){return q.getColumnMeta(this.toPhysicalColumn(e))},this.getCellMetaAtRow=function(e){return q.getCellsMetaAtRow(e)},this.isColumnModificationAllowed=function(){return!("object"===U.dataType||Q.columns)},this.getCellRenderer=function(e,t){const r="number"==typeof e?U.getCellMeta(e,t).renderer:e.renderer;return"string"==typeof r?(0,f.getRenderer)(r):(0,o.isUndefined)(r)?(0,f.getRenderer)("text"):r},this.getCellEditor=function(e,t){const r="number"==typeof e?U.getCellMeta(e,t).editor:e.editor;return"string"==typeof r?(0,m.getEditor)(r):(0,o.isUndefined)(r)?(0,m.getEditor)("text"):r},this.getCellValidator=function(e,t){const r="number"==typeof e?U.getCellMeta(e,t).validator:e.validator;return"string"==typeof r?(0,y.getValidator)(r):r},this.validateCells=function(e){this._validateCells(e)},this.validateRows=function(e,t){if(!Array.isArray(e))throw new Error("validateRows parameter `rows` must be an array");this._validateCells(t,e)},this.validateColumns=function(e,t){if(!Array.isArray(e))throw new Error("validateColumns parameter `columns` must be an array");this._validateCells(t,void 0,e)},this._validateCells=function(e,t,r){const n=new se;e&&(n.onQueueEmpty=e);let s=U.countRows()-1;for(;s>=0;){if(void 0!==t&&-1===t.indexOf(s)){s-=1;continue}let e=U.countCols()-1;for(;e>=0;)void 0===r||-1!==r.indexOf(e)?(n.addValidatorToQueue(),U.validateCell(U.getDataAtCell(s,e),U.getCellMeta(s,e),(e=>{if("boolean"!=typeof e)throw new Error("Validation error: result is not boolean");!1===e&&(n.valid=!1),n.removeValidatorFormQueue()}),"validateCells"),e-=1):e-=1;s-=1}n.checkIfQueueIsEmpty()},this.getRowHeader=function(e){let t=Q.rowHeaders,r=e;return void 0!==r&&(r=U.runHooks("modifyRowHeader",r)),void 0===r?(t=[],(0,w.rangeEach)(U.countRows()-1,(e=>{t.push(U.getRowHeader(e))}))):Array.isArray(t)&&void 0!==t[r]?t=t[r]:(0,i.isFunction)(t)?t=t(r):t&&"string"!=typeof t&&"number"!=typeof t&&(t=r+1),t},this.hasRowHeaders=function(){return!!Q.rowHeaders},this.hasColHeaders=function(){if(void 0!==Q.colHeaders&&null!==Q.colHeaders)return!!Q.colHeaders;for(let e=0,t=U.countCols();e<t;e++)if(U.getColHeader(e))return!0;return!1},this.getColHeader=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:-1;const r=U.runHooks("modifyColHeader",e);if(void 0===r){const e=[],t=U.countCols();for(let r=0;r<t;r++)e.push(U.getColHeader(r));return e}let n=Q.colHeaders;const s=U.toPhysicalColumn(r),o=function(e){const t=[],r=U.countCols();let n=0;for(;n<r;n++)(0,i.isFunction)(Q.columns)&&Q.columns(n)&&t.push(n);return t[e]}(s);return!1===Q.colHeaders?n=null:Q.columns&&(0,i.isFunction)(Q.columns)&&Q.columns(o)&&Q.columns(o).title?n=Q.columns(o).title:Q.columns&&Q.columns[s]&&Q.columns[s].title?n=Q.columns[s].title:Array.isArray(Q.colHeaders)&&void 0!==Q.colHeaders[s]?n=Q.colHeaders[s]:(0,i.isFunction)(Q.colHeaders)?n=Q.colHeaders(s):Q.colHeaders&&"string"!=typeof Q.colHeaders&&"number"!=typeof Q.colHeaders&&(n=(0,R.spreadsheetColumnLabel)(r)),n=U.runHooks("modifyColumnHeaderValue",n,e,t),n},this._getColWidthFromSettings=function(e){let t;if(e>=0){t=U.getCellMeta(0,e).width}if(void 0!==t&&t!==Q.width||(t=Q.colWidths),null!=t){switch(typeof t){case"object":t=t[e];break;case"function":t=t(e)}"string"==typeof t&&(t=parseInt(t,10))}return t},this.getColWidth=function(e,t){let r=U._getColWidthFromSettings(e);return r=U.runHooks("modifyColWidth",r,e,t),void 0===r&&(r=N.DEFAULT_COLUMN_WIDTH),r},this._getRowHeightFromSettings=function(e){let t=Q.rowHeights;if(null!=t){switch(typeof t){case"object":t=t[e];break;case"function":t=t(e)}"string"==typeof t&&(t=parseInt(t,10))}return t},this.getRowHeight=function(e,t){let r=U._getRowHeightFromSettings(e);return r=U.runHooks("modifyRowHeight",r,e,t),r},this.countSourceRows=function(){return W.countRows()},this.countSourceCols=function(){return W.countFirstRowKeys()},this.countRows=function(){return B.getLength()},this.countCols=function(){const e=Q.maxCols,t=this.columnIndexMapper.getNotTrimmedIndexesLength();return Math.min(e,t)},this.countRenderedRows=function(){return U.view._wt.drawn?U.view._wt.wtTable.getRenderedRowsCount():-1},this.countVisibleRows=function(){return U.view._wt.drawn?U.view._wt.wtTable.getVisibleRowsCount():-1},this.countRenderedCols=function(){return U.view._wt.drawn?U.view._wt.wtTable.getRenderedColumnsCount():-1},this.countVisibleCols=function(){return U.view._wt.drawn?U.view._wt.wtTable.getVisibleColumnsCount():-1},this.countRowHeaders=function(){return this.view.getRowHeadersCount()},this.countColHeaders=function(){return this.view.getColumnHeadersCount()},this.countEmptyRows=function(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0],t=0;return(0,w.rangeEachReverse)(U.countRows()-1,(r=>{if(U.isEmptyRow(r))t+=1;else if(!0===e)return!1})),t},this.countEmptyCols=function(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0],t=0;return(0,w.rangeEachReverse)(U.countCols()-1,(r=>{if(U.isEmptyCol(r))t+=1;else if(!0===e)return!1})),t},this.isEmptyRow=function(e){return Q.isEmptyRow.call(U,e)},this.isEmptyCol=function(e){return Q.isEmptyCol.call(U,e)},this.selectCell=function(e,t,r,n){let s=!(arguments.length>4&&void 0!==arguments[4])||arguments[4],i=!(arguments.length>5&&void 0!==arguments[5])||arguments[5];return!(0,o.isUndefined)(e)&&!(0,o.isUndefined)(t)&&this.selectCells([[e,t,r,n]],s,i)},this.selectCells=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[[]],t=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];!1===(!(arguments.length>1&&void 0!==arguments[1])||arguments[1])&&z.suspend();const r=ee.selectCells(e);return r&&t&&U.listen(),z.resume(),r},this.selectColumns=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:e,r=arguments.length>2?arguments[2]:void 0;return ee.selectColumns(e,t,r)},this.selectRows=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:e,r=arguments.length>2?arguments[2]:void 0;return ee.selectRows(e,t,r)},this.deselectCell=function(){ee.deselect()},this.selectAll=function(){let e=!(arguments.length>0&&void 0!==arguments[0])||arguments[0],t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:e,r=arguments.length>2?arguments[2]:void 0;z.skipNextScrollCycle(),ee.selectAll(e,t,r)};const ue=(e,t)=>e.getNearestNotHiddenIndex(t,1,!0);this.scrollViewportTo=function(e){var t,r;"number"==typeof e&&(e={row:arguments[0],col:arguments[1],verticalSnap:arguments[2]?"bottom":"top",horizontalSnap:arguments[3]?"end":"start",considerHiddenIndexes:null===(r=arguments[4])||void 0===r||r});const{row:n,col:s,considerHiddenIndexes:i}=null!==(t=e)&&void 0!==t?t:{};let o=n,a=s;if(void 0===i||i){const e=Number.isInteger(n)&&n>=0,t=Number.isInteger(s)&&s>=0,r=e?ue(this.rowIndexMapper,n):void 0,i=t?ue(this.columnIndexMapper,s):void 0;if(null===r||null===i)return!1;o=e?U.rowIndexMapper.getRenderableFromVisualIndex(r):n,a=t?U.columnIndexMapper.getRenderableFromVisualIndex(i):s}const l=Number.isInteger(o),h=Number.isInteger(a);return l&&o>=0&&h&&a>=0?U.view.scrollViewport(U._createCellCoords(o,a),e.horizontalSnap,e.verticalSnap):l&&o>=0&&(h&&a<0||!h)?U.view.scrollViewportVertically(o,e.verticalSnap):!!(h&&a>=0&&(l&&o<0||!l))&&U.view.scrollViewportHorizontally(a,e.horizontalSnap)},this.scrollToFocusedCell=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:()=>{};if(!this.selection.isSelected())return;this.addHookOnce("afterScroll",e);const{highlight:t}=this.getSelectedRangeLast();this.scrollViewportTo(t.toObject())?this.view.render():(this.removeHook("afterScroll",e),this._registerImmediate((()=>e())))},this.destroy=function(){if(U._clearTimeouts(),U._clearImmediates(),U.view&&U.view.destroy(),W&&W.destroy(),W=null,this.getShortcutManager().destroy(),q.clearCache(),H.delete(this.guid),(0,T.isRootInstance)(U)){const e=this.rootDocument.querySelector(".hot-display-license-info");e&&e.parentNode.removeChild(e)}(0,s.empty)(U.rootElement),V.destroy(),G&&G.destroy(),U.batchExecution((()=>{U.rowIndexMapper.unregisterAll(),U.columnIndexMapper.unregisterAll(),J.getItems().forEach((e=>{let[,t]=e;t.destroy()})),J.clear(),U.runHooks("afterDestroy")}),!0),M.Hooks.getSingleton().destroy(U),(0,u.objectEach)(U,((e,t,r)=>{var n;(0,i.isFunction)(e)?r[t]=(n=t,()=>{throw new Error(`The "${n}" method cannot be called because this Handsontable instance has been destroyed`)}):"guid"!==t&&(r[t]=null)})),U.isDestroyed=!0,B&&B.destroy(),B=null,Y=null,ee=null,G=null,U=null},this.getActiveEditor=function(){return G.getActiveEditor()},this.getFirstRenderedVisibleRow=function(){return U.view.getFirstRenderedVisibleRow()},this.getLastRenderedVisibleRow=function(){return U.view.getLastRenderedVisibleRow()},this.getFirstRenderedVisibleColumn=function(){return U.view.getFirstRenderedVisibleColumn()},this.getLastRenderedVisibleColumn=function(){return U.view.getLastRenderedVisibleColumn()},this.getFirstFullyVisibleRow=function(){return U.view.getFirstFullyVisibleRow()},this.getLastFullyVisibleRow=function(){return U.view.getLastFullyVisibleRow()},this.getFirstFullyVisibleColumn=function(){return U.view.getFirstFullyVisibleColumn()},this.getLastFullyVisibleColumn=function(){return U.view.getLastFullyVisibleColumn()},this.getFirstPartiallyVisibleRow=function(){return U.view.getFirstPartiallyVisibleRow()},this.getLastPartiallyVisibleRow=function(){return U.view.getLastPartiallyVisibleRow()},this.getFirstPartiallyVisibleColumn=function(){return U.view.getFirstPartiallyVisibleColumn()},this.getLastPartiallyVisibleColumn=function(){return U.view.getLastPartiallyVisibleColumn()},this.getPlugin=function(e){const t=(0,E.toUpperCaseFirst)(e);return"UndoRedo"===t?this.undoRedo:J.getItem(t)},this.getPluginName=function(e){return e===this.undoRedo?this.undoRedo.constructor.PLUGIN_KEY:J.getId(e)},this.getInstance=function(){return U},this.addHook=function(e,t,r){M.Hooks.getSingleton().add(e,t,U,r)},this.hasHook=function(e){return M.Hooks.getSingleton().has(e,U)||M.Hooks.getSingleton().has(e)},this.addHookOnce=function(e,t,r){M.Hooks.getSingleton().once(e,t,U,r)},this.removeHook=function(e,t){M.Hooks.getSingleton().remove(e,t,U)},this.runHooks=function(e,t,r,n,s,i,o){return M.Hooks.getSingleton().run(U,e,t,r,n,s,i,o)},this.getTranslatedPhrase=function(e,t){return(0,_.getTranslatedPhrase)(Q.language,e,t)},this.toHTML=()=>(0,p.instanceToHTML)(this),this.toTableElement=()=>{const e=this.rootDocument.createElement("div");return e.insertAdjacentHTML("afterbegin",(0,p.instanceToHTML)(this)),e.firstElementChild},this.timeouts=[],this.useTheme=e=>{this.view.getStylesHandler().useTheme(e),this.runHooks("afterSetTheme",e,!!$)},this.getCurrentThemeName=()=>this.view.getStylesHandler().getThemeName(),this._registerTimeout=function(e){let t=e;"function"==typeof t&&(t=setTimeout(t,arguments.length>1&&void 0!==arguments[1]?arguments[1]:0)),this.timeouts.push(t)},this._clearTimeouts=function(){(0,d.arrayEach)(this.timeouts,(e=>{clearTimeout(e)}))},this.immediates=[],this._registerImmediate=function(e){this.immediates.push(setImmediate(e))},this._clearImmediates=function(){(0,d.arrayEach)(this.immediates,(e=>{clearImmediate(e)}))},this._getEditorManager=function(){return G},this.isRtl=function(){return"rtl"===U.rootWindow.getComputedStyle(U.rootElement).direction},this.isLtr=function(){return!U.isRtl()},this.getDirectionFactor=function(){return U.isLtr()?1:-1};const ce=(0,P.createShortcutManager)({handleEvent:()=>U.isListening(),beforeKeyDown:e=>this.runHooks("beforeKeyDown",e),afterKeyDown:e=>{this.isDestroyed||U.runHooks("afterDocumentKeyDown",e)},ownerWindow:this.rootWindow});this.addHook("beforeOnCellMouseDown",(e=>{!1===e.ctrlKey&&!1===e.metaKey&&ce.releasePressedKeys()})),this.getShortcutManager=function(){return ce},this.getFocusManager=function(){return j},(0,g.getPluginsNames)().forEach((e=>{const t=(0,g.getPlugin)(e);J.addItem(e,new t(this))})),(0,L.registerAllShortcutContexts)(U),ce.setActiveContextName("grid"),M.Hooks.getSingleton().run(U,"construct")},r(67834),r(15724),r(71336),r(41558),r(17663),r(68630),r(79645),r(89858),r(8620),r(14846),r(27458),r(69655),r(94364),r(71766);var s=r(62577),i=r(89804),o=r(70505),a=r(25046),l=n(r(70892)),h=n(r(3849)),u=r(25499),c=r(19053),d=r(10587),p=r(96173),g=r(74672),f=r(54852),m=r(8266),y=r(17027),E=r(5893),w=r(22137),C=n(r(33925)),v=n(r(61068)),R=r(87124),S=r(61149),T=r(45435),N=r(50206),M=r(28197),_=r(58570),b=r(1052),A=r(76717),O=r(6521),I=r(97826),x=r(54394),P=r(89616),L=r(92399),D=r(73618);let k=null;const H=new Map;new Set},32741:(e,t,r)=>{"use strict";t.__esModule=!0,t.installFocusDetector=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const r=e.rootElement,n=i(e),s=i(e);return n.addEventListener("focus",(()=>null==t?void 0:t.onFocusFromTop())),s.addEventListener("focus",(()=>null==t?void 0:t.onFocusFromBottom())),r.firstChild.before(n),r.lastChild.after(s),{activate(){e._registerTimeout((()=>{n.tabIndex=0,s.tabIndex=0}),10)},deactivate(){e._registerTimeout((()=>{n.tabIndex=-1,s.tabIndex=-1}),10)}}};var n=r(62577),s=r(71120);function i(e){const t=e.rootDocument.createElement("input");return t.type="text",t.name="__htFocusCatcher",t.classList.add("htFocusCatcher"),e.getSettings().ariaTags&&(0,n.setAttribute)(t,[(0,s.A11Y_PRESENTATION)(),(0,s.A11Y_HIDDEN)()]),t}},20511:(e,t,r)=>{"use strict";t.__esModule=!0,t.installFocusCatcher=function(e){const t=function(e){return t=>{if(!t)return null;const r=i(e),n=o(e);return t.col<r.col&&(t.col=r.col),t.col>n.col&&(t.col=n.col),t.row<r.row&&(t.row=r.row),t.row>n.row&&(t.row=n.row),t}}(e);let r;const{activate:a,deactivate:l}=(0,s.installFocusDetector)(e,{onFocusFromTop(){var n;const s=null!==(n=t(r))&&void 0!==n?n:i(e);s&&(e.runHooks("modifyFocusOnTabNavigation","from_above",s),e.selectCell(s.row,s.col)),e.listen()},onFocusFromBottom(){var n;const s=null!==(n=t(r))&&void 0!==n?n:o(e);s&&(e.runHooks("modifyFocusOnTabNavigation","from_below",s),e.selectCell(s.row,s.col)),e.listen()}}),h={wrapped:!1,flipped:!1};let u=!0,c=!1,d=!1;e.addHook("afterListen",(()=>l())),e.addHook("afterUnlisten",(()=>a())),e.addHook("afterSelection",((t,n,s,i,o)=>{var a;(c&&(h.wrapped&&h.flipped||d)&&(d=!1,o.value=!0),u)&&(r=null===(a=e.getSelectedRangeLast())||void 0===a?void 0:a.highlight)})),e.addHook("beforeRowWrap",((e,t,r)=>{h.wrapped=!0,h.flipped=r}));const p={keys:[["Tab"],["Shift","Tab"]],preventDefault:!1,stopPropagation:!1,relativeToGroup:n.GRID_GROUP,group:"focusCatcher"};e.getShortcutManager().getContext("grid").addShortcuts([{...p,callback:()=>{const{tabNavigation:t}=e.getSettings();c=!0,e.getSelectedRangeLast()&&!t&&(u=!1),t||(d=!0)},position:"before"},{...p,callback:t=>{const{tabNavigation:n,autoWrapRow:s}=e.getSettings();if(c=!1,u=!0,!n||!e.selection.isSelected()||s&&h.wrapped&&h.flipped||!s&&h.wrapped)return s&&h.wrapped&&h.flipped&&(r=t.shiftKey?i(e):o(e)),h.wrapped=!1,h.flipped=!1,e.deselectCell(),e.unlisten(),!1;t.preventDefault()},position:"after"}])};var n=r(92399),s=r(32741);function i(e){const{rowIndexMapper:t,columnIndexMapper:r}=e,{navigableHeaders:n}=e.getSettings();let s=n&&e.countColHeaders()>0?-e.countColHeaders():0,i=n&&e.countRowHeaders()>0?-e.countRowHeaders():0;return 0===s&&(s=t.getVisualFromRenderableIndex(s)),0===i&&(i=r.getVisualFromRenderableIndex(i)),null===s||null===i?null:e._createCellCoords(s,i)}function o(e){var t,r;const{rowIndexMapper:n,columnIndexMapper:s}=e,{navigableHeaders:i}=e.getSettings();let o=n.getRenderableIndexesLength()-1,a=s.getRenderableIndexesLength()-1;if(o<0){if(!i||0===e.countColHeaders())return null;o=-1}if(a<0){if(!i||0===e.countColHeaders())return null;a=-1}return e._createCellCoords(null!==(t=n.getVisualFromRenderableIndex(o))&&void 0!==t?t:o,null!==(r=s.getVisualFromRenderableIndex(a))&&void 0!==r?r:a)}},39631:(e,t,r)=>{"use strict";t.__esModule=!0,r(67834),r(15724),r(79747),r(71336),r(41558),r(17663),r(68630),r(79645),r(89858),r(8620),r(14846),r(27458),r(6211),r(69655);var n=r(64924);function s(e,t,r){i(e,t),t.set(e,r)}function i(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function o(e,t,r){return e.set(l(e,t),r),r}function a(e,t){return e.get(l(e,t))}function l(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var h=new WeakMap,u=new WeakMap,c=new WeakMap,d=new WeakSet;function p(e){a(h,this).set(e,[]),a(u,this).set(e,0)}t.HooksBucket=class{constructor(){var e,t;i(e=this,t=d),t.add(e),s(this,h,new Map),s(this,u,new Map),s(this,c,new Set),n.REGISTERED_HOOKS.forEach((e=>l(d,this,p).call(this,e)))}getHooks(e){var t;return null!==(t=a(h,this).get(e))&&void 0!==t?t:[]}add(e,t){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};a(h,this).has(e)||(l(d,this,p).call(this,e),n.REGISTERED_HOOKS.push(e));const s=a(h,this).get(e);if(s.find((e=>e.callback===t)))return;const i=Number.isInteger(r.orderIndex)?r.orderIndex:0,o=!!r.runOnce,u=!!r.initialHook;let g=!1;if(u){const e=s.find((e=>e.initialHook));e&&(e.callback=t,g=!0)}if(!g){s.push({callback:t,orderIndex:i,runOnce:o,initialHook:u,skip:!1});let r=a(c,this).has(e);r||0===i||(r=!0,a(c,this).add(e)),r&&s.length>1&&a(h,this).set(e,s.toSorted(((e,t)=>e.orderIndex-t.orderIndex)))}}has(e){return a(h,this).has(e)&&a(h,this).get(e).length>0}remove(e,t){if(!a(h,this).has(e))return!1;const r=a(h,this).get(e),n=r.find((e=>e.callback===t));if(n){let t=a(u,this).get(e);return n.skip=!0,t+=1,t>100&&(a(h,this).set(e,r.filter((e=>!e.skip))),t=0),a(u,this).set(e,t),!0}return!1}destroy(){a(h,this).clear(),a(u,this).clear(),o(h,this,null),o(u,this,null)}}},64924:(e,t)=>{"use strict";t.__esModule=!0;t.REGISTERED_HOOKS=["afterCellMetaReset","afterChange","afterContextMenuDefaultOptions","beforeContextMenuSetItems","afterDropdownMenuDefaultOptions","beforeDropdownMenuSetItems","afterContextMenuHide","beforeContextMenuShow","afterContextMenuShow","afterCopyLimit","beforeCreateCol","afterColumnSequenceChange","afterCreateCol","beforeCreateRow","afterCreateRow","afterDeselect","afterDestroy","afterDocumentKeyDown","afterDrawSelection","beforeRemoveCellClassNames","afterGetCellMeta","afterGetColHeader","afterGetRowHeader","afterInit","afterLoadData","afterUpdateData","afterMomentumScroll","afterOnCellCornerMouseDown","afterOnCellCornerDblClick","afterOnCellMouseDown","afterOnCellMouseUp","afterOnCellContextMenu","afterOnCellMouseOver","afterOnCellMouseOut","afterRemoveCol","afterRemoveRow","beforeRenderer","afterRenderer","afterRowSequenceChange","beforeViewportScrollVertically","beforeViewportScrollHorizontally","beforeViewportScroll","afterScrollHorizontally","afterScrollVertically","afterScroll","afterSelection","afterSelectionByProp","afterSelectionEnd","afterSelectionEndByProp","afterSelectionFocusSet","beforeSelectColumns","afterSelectColumns","beforeSelectRows","afterSelectRows","afterSetCellMeta","afterRemoveCellMeta","afterSetDataAtCell","afterSetDataAtRowProp","afterSetSourceDataAtCell","afterSetTheme","afterUpdateSettings","afterValidate","beforeLanguageChange","afterLanguageChange","beforeAutofill","afterAutofill","beforeCellAlignment","beforeChange","beforeChangeRender","beforeDrawBorders","beforeGetCellMeta","beforeRemoveCellMeta","beforeInit","beforeInitWalkontable","beforeLoadData","beforeUpdateData","beforeKeyDown","beforeOnCellMouseDown","beforeOnCellMouseUp","beforeOnCellContextMenu","beforeOnCellMouseOver","beforeOnCellMouseOut","beforeRemoveCol","beforeRemoveRow","beforeViewRender","afterViewRender","beforeRender","afterRender","beforeRowWrap","beforeColumnWrap","beforeSetCellMeta","beforeSelectionFocusSet","beforeSetRangeStartOnly","beforeSetRangeStart","beforeSetRangeEnd","beforeSelectionHighlightSet","beforeTouchScroll","beforeValidate","beforeValueRender","construct","init","modifyColHeader","modifyColWidth","modifyFiltersMultiSelectValue","modifyFocusedElement","modifyRowHeader","modifyRowHeight","modifyRowHeightByOverlayName","modifyData","modifySourceData","modifyRowData","modifyGetCellCoords","modifyGetCoordsElement","modifyFocusOnTabNavigation","beforeHighlightingRowHeader","beforeHighlightingColumnHeader","persistentStateLoad","persistentStateReset","persistentStateSave","beforeColumnSort","afterColumnSort","modifyAutofillRange","modifyCopyableRange","beforeCut","afterCut","beforeCopy","afterCopy","beforePaste","afterPaste","beforeColumnFreeze","afterColumnFreeze","beforeColumnMove","afterColumnMove","beforeColumnUnfreeze","afterColumnUnfreeze","beforeRowMove","afterRowMove","beforeColumnResize","afterColumnResize","beforeRowResize","afterRowResize","afterGetColumnHeaderRenderers","afterGetRowHeaderRenderers","beforeStretchingColumnWidth","beforeFilter","afterFilter","afterFormulasValuesUpdate","afterNamedExpressionAdded","afterNamedExpressionRemoved","afterSheetAdded","afterSheetRenamed","afterSheetRemoved","modifyColumnHeaderHeight","modifyColumnHeaderValue","beforeUndo","beforeUndoStackChange","afterUndo","afterUndoStackChange","beforeRedo","beforeRedoStackChange","afterRedo","afterRedoStackChange","modifyRowHeaderWidth","modifyTransformFocus","modifyTransformStart","modifyTransformEnd","afterModifyTransformFocus","afterModifyTransformStart","afterModifyTransformEnd","afterViewportRowCalculatorOverride","afterViewportColumnCalculatorOverride","afterPluginsInitialized","beforeHideRows","afterHideRows","beforeUnhideRows","afterUnhideRows","beforeHideColumns","afterHideColumns","beforeUnhideColumns","afterUnhideColumns","beforeTrimRow","afterTrimRow","beforeUntrimRow","afterUntrimRow","beforeDropdownMenuShow","afterDropdownMenuShow","afterDropdownMenuHide","beforeAddChild","afterAddChild","beforeDetachChild","afterDetachChild","beforeBeginEditing","afterBeginEditing","beforeMergeCells","afterMergeCells","beforeUnmergeCells","afterUnmergeCells","afterListen","afterUnlisten","afterRefreshDimensions","beforeRefreshDimensions","beforeColumnCollapse","afterColumnCollapse","beforeColumnExpand","afterColumnExpand","modifyAutoColumnSizeSeed"],t.REMOVED_HOOKS=new Map([["modifyRow","8.0.0"],["modifyCol","8.0.0"],["unmodifyRow","8.0.0"],["unmodifyCol","8.0.0"],["skipLengthCache","8.0.0"],["hiddenColumn","8.0.0"],["hiddenRow","8.0.0"]]),t.DEPRECATED_HOOKS=new Map([[]])},28197:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724);var s=n(r(85707)),i=r(10587),o=r(5893),a=r(14859),l=r(21595),h=r(89804),u=r(64924),c=r(39631);const d=l.toSingleLine`The plugin hook "[hookName]" was removed in Handsontable [removedInVersion].\x20
  Please consult release notes https://github.com/handsontable/handsontable/releases/tag/[removedInVersion] to\x20
  learn about the migration path.`;class p{constructor(){(0,s.default)(this,"globalBucket",new c.HooksBucket)}static getSingleton(){return g}getBucket(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;return e?(e.pluginHookBucket||(e.pluginHookBucket=new c.HooksBucket),e.pluginHookBucket):this.globalBucket}add(e,t){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null,n=arguments.length>3?arguments[3]:void 0;return Array.isArray(t)?(0,i.arrayEach)(t,(t=>this.add(e,t,r))):(u.REMOVED_HOOKS.has(e)&&(0,a.warn)((0,o.substitute)(d,{hookName:e,removedInVersion:u.REMOVED_HOOKS.get(e)})),u.DEPRECATED_HOOKS.has(e)&&(0,a.warn)(u.DEPRECATED_HOOKS.get(e)),this.getBucket(r).add(e,t,{orderIndex:n,runOnce:!1})),this}once(e,t){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null,n=arguments.length>3?arguments[3]:void 0;return Array.isArray(t)?(0,i.arrayEach)(t,(t=>this.once(e,t,r))):this.getBucket(r).add(e,t,{orderIndex:n,runOnce:!0}),this}addAsFixed(e,t){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;return Array.isArray(t)?(0,i.arrayEach)(t,(t=>this.addAsFixed(e,t,r))):this.getBucket(r).add(e,t,{initialHook:!0}),this}remove(e,t){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;return this.getBucket(r).remove(e,t)}has(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;return this.getBucket(t).has(e)}run(e,t,r,n,s,i,o,a){{const l=this.getBucket().getHooks(t),u=l?l.length:0;let c=0;if(u)for(;c<u;){if(!l[c]||l[c].skip){c+=1;continue}const u=(0,h.fastCall)(l[c].callback,e,r,n,s,i,o,a);void 0!==u&&(r=u),l[c]&&l[c].runOnce&&this.remove(t,l[c].callback),c+=1}}{const l=this.getBucket(e).getHooks(t),u=l?l.length:0;let c=0;if(u)for(;c<u;){if(!l[c]||l[c].skip){c+=1;continue}const u=(0,h.fastCall)(l[c].callback,e,r,n,s,i,o,a);void 0!==u&&(r=u),l[c]&&l[c].runOnce&&this.remove(t,l[c].callback,e),c+=1}}return r}destroy(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;this.getBucket(e).destroy()}register(e){this.isRegistered(e)||u.REGISTERED_HOOKS.push(e)}deregister(e){this.isRegistered(e)&&u.REGISTERED_HOOKS.splice(u.REGISTERED_HOOKS.indexOf(e),1)}isDeprecated(e){return u.DEPRECATED_HOOKS.has(e)||u.REMOVED_HOOKS.has(e)}isRegistered(e){return u.REGISTERED_HOOKS.indexOf(e)>=0}getRegistered(){return u.REGISTERED_HOOKS}}t.Hooks=p;const g=new p;t.default=p},97826:(e,t,r)=>{"use strict";r(14846),r(69655),t.__esModule=!0;var n=r(20511);Object.keys(n).forEach((function(e){"default"!==e&&"__esModule"!==e&&(e in t&&t[e]===n[e]||(t[e]=n[e]))}));var s=r(92104);Object.keys(s).forEach((function(e){"default"!==e&&"__esModule"!==e&&(e in t&&t[e]===s[e]||(t[e]=s[e]))}))},92104:(e,t,r)=>{"use strict";t.__esModule=!0,t.createViewportScroller=function(e){const{selection:t}=e;let r=!1,u=!1;return{resume(){u=!1},suspend(){u=!0},skipNextScrollCycle(){r=!0},scrollTo(c){var d;if(r||u)return void(r=!1);let p;t.isFocusSelectionChanged()?p=(0,i.focusScrollStrategy)(e):t.isSelectedByCorner()?p=(0,s.cornerHeaderScrollStrategy)(e):t.isSelectedByRowHeader()?p=(0,l.rowHeaderScrollStrategy)(e):t.isSelectedByColumnHeader()?p=(0,n.columnHeaderScrollStrategy)(e):1===t.getSelectedRange().size()&&t.isMultiple()?p=(0,o.multipleScrollStrategy)(e):1!==t.getSelectedRange().size()||t.isMultiple()?t.getSelectedRange().size()>1&&(p=(0,a.noncontiguousScrollStrategy)(e)):p=(0,h.singleScrollStrategy)(e),null===(d=p)||void 0===d||d(c)}}};var n=r(58007),s=r(85924),i=r(53720),o=r(13312),a=r(70671),l=r(71725),h=r(39068)},58007:(e,t)=>{"use strict";t.__esModule=!0,t.columnHeaderScrollStrategy=function(e){return t=>{let{col:r}=t;e.scrollViewportTo({col:r})}}},85924:(e,t)=>{"use strict";t.__esModule=!0,t.cornerHeaderScrollStrategy=function(){return()=>{}}},53720:(e,t)=>{"use strict";t.__esModule=!0,t.focusScrollStrategy=function(e){return t=>{e.scrollViewportTo(t.toObject())}}},13312:(e,t)=>{"use strict";t.__esModule=!0,t.multipleScrollStrategy=function(e){return t=>{e.scrollViewportTo(t.toObject())}}},70671:(e,t)=>{"use strict";t.__esModule=!0,t.noncontiguousScrollStrategy=function(e){return t=>{e.scrollViewportTo(t.toObject())}}},71725:(e,t)=>{"use strict";t.__esModule=!0,t.rowHeaderScrollStrategy=function(e){return t=>{let{row:r}=t;e.scrollViewportTo({row:r})}}},39068:(e,t)=>{"use strict";t.__esModule=!0,t.singleScrollStrategy=function(e){return t=>{const r=e.selection.getSelectionSource(),{row:n,col:s}=t;if(n<0&&s>=0)e.scrollViewportTo({col:s});else if(s<0&&n>=0)e.scrollViewportTo({row:n});else{if("mouse"===r&&(s===e.view.getLastPartiallyVisibleColumn()||n===e.view.getLastPartiallyVisibleRow()))return;e.scrollViewportTo({row:n,col:s})}}}},78747:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724),r(14846),r(27458),r(69655);var s=n(r(85707)),i=r(42354),o=r(87124),a=r(25499),l=r(10587),h=r(22137),u=r(70505);class c{static get DESTINATION_RENDERER(){return 1}static get DESTINATION_CLIPBOARD_GENERATOR(){return 2}constructor(e,t,r){(0,s.default)(this,"hot",void 0),(0,s.default)(this,"metaManager",void 0),(0,s.default)(this,"tableMeta",void 0),(0,s.default)(this,"dataSource",void 0),(0,s.default)(this,"duckSchema",void 0),(0,s.default)(this,"colToPropCache",void 0),(0,s.default)(this,"propToColCache",void 0),this.hot=e,this.metaManager=r,this.tableMeta=r.getTableMeta(),this.dataSource=t,this.duckSchema=this.createDuckSchema(),this.createMap()}createMap(){const e=this.getSchema();if(void 0===e)throw new Error("trying to create `columns` definition but you didn't provide `schema` nor `data`");const t=this.tableMeta.columns;let r;if(this.colToPropCache=[],this.propToColCache=new Map,t){let n=0,s=0,i=!1;if("function"==typeof t){const t=(0,a.deepObjectSize)(e);n=t>0?t:this.countFirstRowKeys(),i=!0}else{const e=this.tableMeta.maxCols;n=Math.min(e,t.length)}for(r=0;r<n;r++){const e=i?t(r):t[r];if((0,a.isObject)(e)){if(void 0!==e.data){const t=i?s:r;this.colToPropCache[t]=e.data,this.propToColCache.set(e.data,t)}s+=1}}}else this.recursiveDuckColumns(e)}countFirstRowKeys(){return(0,o.countFirstRowKeys)(this.dataSource)}recursiveDuckColumns(e,t,r){let n,s=t,i=r;return void 0===s&&(s=0,i=""),"object"!=typeof e||Array.isArray(e)||(0,a.objectEach)(e,((e,t)=>{null===e?(n=i+t,this.colToPropCache.push(n),this.propToColCache.set(n,s),s+=1):s=this.recursiveDuckColumns(e,s,`${t}.`)})),s}colToProp(e){if(!1===Number.isInteger(e))return e;const t=this.hot.toPhysicalColumn(e);return null===t?e:this.colToPropCache&&(0,u.isDefined)(this.colToPropCache[t])?this.colToPropCache[t]:t}propToCol(e){const t=this.propToColCache.get(e);if((0,u.isDefined)(t))return this.hot.toVisualColumn(t);const r=this.hot.toVisualColumn(e);return null===r?e:r}getSchema(){const e=this.tableMeta.dataSchema;return e?"function"==typeof e?e():e:this.duckSchema}createDuckSchema(){return this.dataSource&&this.dataSource[0]?(0,a.duckSchema)(this.dataSource[0]):{}}refreshDuckSchema(){this.duckSchema=this.createDuckSchema()}createRow(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,{source:r,mode:n="above"}=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const s=this.hot.countSourceRows();let i=s,o=0,l=e;("number"!=typeof l||l>=s)&&(l=s),l<this.hot.countRows()&&(i=this.hot.toPhysicalRow(l));if(!1===this.hot.runHooks("beforeCreateRow",l,t,r)||null===i)return{delta:0};const u=this.tableMeta.maxRows,c=this.getSchema().length,d=[];for(;o<t&&s+o<u;){let e=null;"array"===this.hot.dataType?this.tableMeta.dataSchema?e=(0,a.deepClone)(this.getSchema()):(e=[],(0,h.rangeEach)(c-1,(()=>e.push(null)))):"function"===this.hot.dataType?e=this.tableMeta.dataSchema(l+o):(e={},(0,a.deepExtend)(e,this.getSchema())),d.push(e),o+=1}this.hot.rowIndexMapper.insertIndexes(l,o),"below"===n&&(i=Math.min(i+1,s)),this.spliceData(i,0,d);const p=this.hot.toVisualRow(i);return this.hot.countSourceRows()===d.length&&this.hot.columnIndexMapper.initToLength(this.hot.getInitialColumnCount()),o>0&&(null==e?this.metaManager.createRow(null,o):"auto"!==r&&this.metaManager.createRow(i,t)),this.hot.runHooks("afterCreateRow",p,o,r),this.hot.forceFullRender=!0,{delta:o,startPhysicalIndex:i}}createCol(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,{source:r,mode:n="start"}=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(!this.hot.isColumnModificationAllowed())throw new Error("Cannot create new column. When data source in an object, you can only have as much columns as defined in first data row, data schema or in the 'columns' setting.If you want to be able to add new columns, you have to use array datasource.");const s=this.dataSource,i=this.tableMeta.maxCols,o=this.hot.countSourceCols();let a=e;("number"!=typeof a||a>=o)&&(a=o);if(!1===this.hot.runHooks("beforeCreateCol",a,t,r))return{delta:0};let l=o;a<this.hot.countCols()&&(l=this.hot.toPhysicalColumn(a));const h=this.hot.countSourceRows();let u=this.hot.countCols(),c=0,d=l;"end"===n&&(d=Math.min(d+1,o));const p=d;for(;c<t&&u<i;){if("number"!=typeof a||a>=u)if(h>0)for(let e=0;e<h;e+=1)void 0===s[e]&&(s[e]=[]),s[e].push(null);else s.push([null]);else for(let e=0;e<h;e++)s[e].splice(d,0,null);c+=1,d+=1,u+=1}this.hot.columnIndexMapper.insertIndexes(a,c),c>0&&(null==e?this.metaManager.createColumn(null,c):"auto"!==r&&this.metaManager.createColumn(p,t));const g=this.hot.toVisualColumn(p);return this.hot.runHooks("afterCreateCol",g,c,r),this.hot.forceFullRender=!0,this.refreshDuckSchema(),{delta:c,startPhysicalIndex:p}}removeRow(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,r=arguments.length>2?arguments[2]:void 0,n=Number.isInteger(e)?e:-t;const s=this.visualRowsToPhysical(n,t),i=this.hot.countSourceRows();n=(i+n)%i;if(!1===this.hot.runHooks("beforeRemoveRow",n,s.length,s,r))return!1;const o=s.length;if(this.filterData(n,o,s),n<this.hot.countRows()){this.hot.rowIndexMapper.removeIndexes(s);const e=(0,u.isDefined)(this.tableMeta.columns)||(0,u.isDefined)(this.tableMeta.dataSchema);0===this.hot.rowIndexMapper.getNotTrimmedIndexesLength()&&!1===e&&this.hot.columnIndexMapper.setIndexesSequence([])}return s.slice(0).sort(((e,t)=>t-e)).forEach((e=>{this.metaManager.removeRow(e,1)})),this.hot.runHooks("afterRemoveRow",n,o,s,r),this.hot.forceFullRender=!0,!0}removeCol(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,r=arguments.length>2?arguments[2]:void 0;if("object"===this.hot.dataType||this.tableMeta.columns)throw new Error("cannot remove column with object data source or columns option specified");let n="number"!=typeof e?-t:e;n=(this.hot.countCols()+n)%this.hot.countCols();const s=this.visualColumnsToPhysical(n,t),i=s.slice(0).sort(((e,t)=>t-e));if(!1===this.hot.runHooks("beforeRemoveCol",n,t,s,r))return!1;let o=!0;const a=i.length,l=this.dataSource;for(let e=0;e<a;e++)o&&s[0]!==s[e]-e&&(o=!1);if(o)for(let e=0,r=this.hot.countSourceRows();e<r;e++)l[e].splice(s[0],t),0===e&&this.metaManager.removeColumn(s[0],t);else for(let e=0,t=this.hot.countSourceRows();e<t;e++)for(let t=0;t<a;t++)l[e].splice(i[t],1),0===e&&this.metaManager.removeColumn(i[t],1);return n<this.hot.countCols()&&(this.hot.columnIndexMapper.removeIndexes(s),0===this.hot.columnIndexMapper.getNotTrimmedIndexesLength()&&this.hot.rowIndexMapper.setIndexesSequence([])),this.hot.runHooks("afterRemoveCol",n,t,s,r),this.hot.forceFullRender=!0,this.refreshDuckSchema(),!0}spliceCol(e,t,r){const n=this.hot.getDataAtCol(e),s=n.slice(t,t+r),i=n.slice(t+r);for(var o=arguments.length,a=new Array(o>3?o-3:0),h=3;h<o;h++)a[h-3]=arguments[h];(0,l.extendArray)(a,i);let u=0;for(;u<r;)a.push(null),u+=1;return(0,l.to2dArray)(a),this.hot.populateFromArray(t,e,a,null,null,"spliceCol"),s}spliceRow(e,t,r){const n=this.hot.getSourceDataAtRow(e),s=n.slice(t,t+r),i=n.slice(t+r);for(var o=arguments.length,a=new Array(o>3?o-3:0),h=3;h<o;h++)a[h-3]=arguments[h];(0,l.extendArray)(a,i);let u=0;for(;u<r;)a.push(null),u+=1;return this.hot.populateFromArray(e,t,[a],null,null,"spliceRow"),s}spliceData(e,t,r){if(!1!==this.hot.runHooks("beforeDataSplice",e,t,r)){const t=[...this.dataSource.slice(0,e),...r,...this.dataSource.slice(e)];this.dataSource.length=0,t.forEach((e=>this.dataSource.push(e)))}}filterData(e,t,r){let n=this.hot.runHooks("filterData",e,t,r);!1===Array.isArray(n)&&(n=this.dataSource.filter(((e,t)=>-1===r.indexOf(t)))),this.dataSource.length=0,Array.prototype.push.apply(this.dataSource,n)}get(e,t){const r=this.hot.toPhysicalRow(e);let n=this.dataSource[r];const s=this.hot.runHooks("modifyRowData",r);n=isNaN(s)?s:n;const{dataDotNotation:i}=this.hot.getSettings();let o=null;if(n&&n.hasOwnProperty&&(0,a.hasOwnProperty)(n,t))o=n[t];else if(i&&"string"==typeof t&&t.indexOf(".")>-1){let e=n;if(!e)return null;const r=t.split(".");for(let t=0,n=r.length;t<n;t++)if(e=e[r[t]],void 0===e)return null;o=e}else"function"==typeof t&&(o=t(this.dataSource.slice(r,r+1)[0]));if(this.hot.hasHook("modifyData")){const e=(0,a.createObjectPropListener)(o);this.hot.runHooks("modifyData",r,this.propToCol(t),e,"get"),e.isTouched()&&(o=e.value)}return o}getCopyable(e,t){return this.hot.getCellMeta(e,this.propToCol(t)).copyable?this.get(e,t):""}set(e,t,r){const n=this.hot.toPhysicalRow(e);let s=r,i=this.dataSource[n];const o=this.hot.runHooks("modifyRowData",n);if(i=isNaN(o)?o:i,this.hot.hasHook("modifyData")){const e=(0,a.createObjectPropListener)(s);this.hot.runHooks("modifyData",n,this.propToCol(t),e,"set"),e.isTouched()&&(s=e.value)}const{dataDotNotation:l}=this.hot.getSettings();if(i&&i.hasOwnProperty&&(0,a.hasOwnProperty)(i,t))i[t]=s;else if(l&&"string"==typeof t&&t.indexOf(".")>-1){let e,r=i,n=0;const o=t.split(".");for(n=0,e=o.length-1;n<e;n++)void 0===r[o[n]]&&(r[o[n]]={}),r=r[o[n]];r[o[n]]=s}else"function"==typeof t?t(this.dataSource.slice(n,n+1)[0],s):i[t]=s}visualRowsToPhysical(e,t){const r=this.hot.countSourceRows(),n=[];let s,i=(r+e)%r,o=t;for(;i<r&&o;)s=this.hot.toPhysicalRow(i),n.push(s),o-=1,i+=1;return n}visualColumnsToPhysical(e,t){const r=this.hot.countCols(),n=[];let s=(r+e)%r,i=t;for(;s<r&&i;){const e=this.hot.toPhysicalColumn(s);n.push(e),i-=1,s+=1}return n}clear(){for(let e=0;e<this.hot.countSourceRows();e++)for(let t=0;t<this.hot.countCols();t++)this.set(e,this.colToProp(t),"")}getLength(){const e=this.tableMeta.maxRows;let t;t=e<0||0===e?0:e||1/0;const r=this.hot.rowIndexMapper.getNotTrimmedIndexesLength();return Math.min(r,t)}getAll(){const e={row:0,col:0},t={row:Math.max(this.hot.countRows()-1,0),col:Math.max(this.hot.countCols()-1,0)};return e.row-t.row!=0||this.hot.countSourceRows()?this.getRange(e,t,c.DESTINATION_RENDERER):[]}countCachedColumns(){return this.colToPropCache.length}getRange(e,t,r){const n=[];let s,i,o;const a=this.tableMeta.maxRows,l=this.tableMeta.maxCols;if(0===a||0===l)return[];const h=r===c.DESTINATION_CLIPBOARD_GENERATOR?this.getCopyable:this.get,u=Math.min(Math.max(a-1,0),Math.max(e.row,t.row)),d=Math.min(Math.max(l-1,0),Math.max(e.col,t.col));for(s=Math.min(e.row,t.row);s<=u;s++){o=[];const r=s>=0?this.hot.toPhysicalRow(s):s;for(i=Math.min(e.col,t.col);i<=d&&null!==r;i++)o.push(h.call(this,s,this.colToProp(i)));null!==r&&n.push(o)}return n}getText(e,t){return(0,i.stringify)(this.getRange(e,t,c.DESTINATION_RENDERER))}getCopyableText(e,t){return(0,i.stringify)(this.getRange(e,t,c.DESTINATION_CLIPBOARD_GENERATOR))}destroy(){this.hot=null,this.metaManager=null,this.dataSource=null,this.duckSchema=null,this.colToPropCache.length=0,this.propToColCache.clear(),this.propToColCache=void 0}}t.default=c},61068:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724),r(14846),r(69655);var s=n(r(85707)),i=r(25499),o=r(87124),a=r(10587),l=r(22137),h=r(89804);t.default=class{constructor(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];(0,s.default)(this,"hot",void 0),(0,s.default)(this,"data",void 0),(0,s.default)(this,"dataType","array"),(0,s.default)(this,"colToProp",(()=>{})),(0,s.default)(this,"propToCol",(()=>{})),this.hot=e,this.data=t}modifyRowData(e){let t;return this.hot.hasHook("modifyRowData")&&(t=this.hot.runHooks("modifyRowData",e)),void 0===t||Number.isInteger(t)?this.data[e]:t}getData(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];return this.data&&0!==this.data.length?this.getByRange(null,null,e):this.data}setData(e){this.data=e}getAtColumn(e){const t=[];return(0,a.arrayEach)(this.data,((r,n)=>{const s=this.getAtCell(n,e);t.push(s)})),t}getAtRow(e,t,r){let n=arguments.length>3&&void 0!==arguments[3]&&arguments[3];const s=void 0===t&&void 0===r,{dataDotNotation:o}=this.hot.getSettings();let a=null,u=null;if(a=this.modifyRowData(e),Array.isArray(a))u=[],s?a.forEach(((t,r)=>{u[r]=this.getAtPhysicalCell(e,r,a)})):(0,l.rangeEach)(t,r,(r=>{u[r-t]=this.getAtPhysicalCell(e,r,a)}));else if((0,i.isObject)(a)||(0,h.isFunction)(a))if(u=n?[]:{},!s||n){const s=0,h=this.countFirstRowKeys()-1;(0,l.rangeEach)(s,h,(l=>{const c=this.colToProp(l);if(l>=(t||s)&&l<=(r||h)&&!Number.isInteger(c)){const t=this.getAtPhysicalCell(e,c,a);n?u.push(t):o?(0,i.setProperty)(u,c,t):u[c]=t}}))}else(0,i.objectEach)(a,((t,r)=>{const n=this.getAtPhysicalCell(e,r,a);o?(0,i.setProperty)(u,r,n):u[r]=n}));return u}setAtCell(e,t,r){if(!(e>=this.countRows()||t>=this.countFirstRowKeys())){if(this.hot.hasHook("modifySourceData")){const n=(0,i.createObjectPropListener)(r);this.hot.runHooks("modifySourceData",e,t,n,"set"),n.isTouched()&&(r=n.value)}Number.isInteger(t)?this.data[e][t]=r:(0,i.setProperty)(this.data[e],t,r)}}getAtPhysicalCell(e,t,r){let n=null;if(r)if("string"==typeof t){const{dataDotNotation:e}=this.hot.getSettings();n=e?(0,i.getProperty)(r,t):r[t]}else n="function"==typeof t?t(r):r[t];if(this.hot.hasHook("modifySourceData")){const r=(0,i.createObjectPropListener)(n);this.hot.runHooks("modifySourceData",e,t,r,"get"),r.isTouched()&&(n=r.value)}return n}getAtCell(e,t){const r=this.modifyRowData(e);return this.getAtPhysicalCell(e,this.colToProp(t),r)}getByRange(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,r=arguments.length>2&&void 0!==arguments[2]&&arguments[2],n=!1,s=null,i=null,o=null,a=null;null===e||null===t?(n=!0,s=0,o=this.countRows()-1):(s=Math.min(e.row,t.row),i=Math.min(e.col,t.col),o=Math.max(e.row,t.row),a=Math.max(e.col,t.col));const h=[];return(0,l.rangeEach)(s,o,(e=>{h.push(n?this.getAtRow(e,void 0,void 0,r):this.getAtRow(e,i,a,r))})),h}countRows(){if(this.hot.hasHook("modifySourceLength")){const e=this.hot.runHooks("modifySourceLength");if(Number.isInteger(e))return e}return this.data.length}countFirstRowKeys(){return(0,o.countFirstRowKeys)(this.data)}destroy(){this.data=null,this.hot=null}}},6521:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(78747));t.DataMap=s.default;var i=n(r(47746));t.MetaManager=i.default;var o=n(r(954));t.metaSchemaFactory=o.default;var a=r(32465);t.replaceData=a.replaceData;var l=r(59594);t.DynamicCellMetaMod=l.DynamicCellMetaMod;var h=r(13944);t.ExtendMetaPropertiesMod=h.ExtendMetaPropertiesMod},47746:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(14846),r(69655);var s=n(r(98960)),i=n(r(7229)),o=n(r(72653)),a=n(r(66535)),l=n(r(16050)),h=r(25499);class u{constructor(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:[];this.hot=e,this.globalMeta=new s.default(e),this.tableMeta=new i.default(this.globalMeta),this.columnMeta=new o.default(this.globalMeta),this.cellMeta=new a.default(this.columnMeta),r.forEach((e=>new e(this))),this.globalMeta.updateMeta(t)}getGlobalMeta(){return this.globalMeta.getMeta()}updateGlobalMeta(e){this.globalMeta.updateMeta(e)}getTableMeta(){return this.tableMeta.getMeta()}updateTableMeta(e){this.tableMeta.updateMeta(e)}getColumnMeta(e){return this.columnMeta.getMeta(e)}updateColumnMeta(e,t){this.columnMeta.updateMeta(e,t)}getCellMeta(e,t,r){let{visualRow:n,visualColumn:s}=r;const i=this.cellMeta.getMeta(e,t);return i.visualRow=n,i.visualCol=s,i.row=e,i.col=t,this.runLocalHooks("afterGetCellMeta",i),i}getCellMetaKeyValue(e,t,r){if("string"!=typeof r)throw new Error("The passed cell meta object key is not a string");return this.cellMeta.getMeta(e,t,r)}setCellMeta(e,t,r,n){this.cellMeta.setMeta(e,t,r,n)}updateCellMeta(e,t,r){this.cellMeta.updateMeta(e,t,r)}removeCellMeta(e,t,r){this.cellMeta.removeMeta(e,t,r)}getCellsMeta(){return this.cellMeta.getMetas()}getCellsMetaAtRow(e){return this.cellMeta.getMetasAtRow(e)}createRow(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;this.cellMeta.createRow(e,t)}removeRow(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;this.cellMeta.removeRow(e,t)}createColumn(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;this.cellMeta.createColumn(e,t),this.columnMeta.createColumn(e,t)}removeColumn(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;this.cellMeta.removeColumn(e,t),this.columnMeta.removeColumn(e,t)}clearCellsCache(){this.cellMeta.clearCache()}clearCache(){this.cellMeta.clearCache(),this.columnMeta.clearCache()}}t.default=u,(0,h.mixin)(u,l.default)},86310:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724),r(71336),r(41558),r(17663),r(68630),r(79645),r(89858),r(8620);var s=n(r(85707)),i=r(10587),o=r(62979);class a{constructor(e){(0,s.default)(this,"valueFactory",void 0),(0,s.default)(this,"data",[]),(0,s.default)(this,"index",[]),(0,s.default)(this,"holes",new Set),this.valueFactory=e}obtain(e){(0,o.assert)((()=>(0,o.isUnsignedNumber)(e)),"Expecting an unsigned number.");const t=this._getStorageIndexByKey(e);let r;if(t>=0)r=this.data[t],void 0===r&&(r=this.valueFactory(e),this.data[t]=r);else if(r=this.valueFactory(e),this.holes.size>0){const t=this.holes.values().next().value;this.holes.delete(t),this.data[t]=r,this.index[e]=t}else this.data.push(r),this.index[e]=this.data.length-1;return r}insert(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;(0,o.assert)((()=>(0,o.isUnsignedNumber)(e)||(0,o.isNullish)(e)),"Expecting an unsigned number or null/undefined argument.");const r=[],n=this.data.length;for(let e=0;e<t;e++)r.push(n+e),this.data.push(void 0);const s=(0,o.isNullish)(e)?this.index.length:e;this.index=[...this.index.slice(0,s),...r,...this.index.slice(s)]}remove(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;(0,o.assert)((()=>(0,o.isUnsignedNumber)(e)||(0,o.isNullish)(e)),"Expecting an unsigned number or null/undefined argument.");const r=this.index.splice((0,o.isNullish)(e)?this.index.length-t:e,t);for(let e=0;e<r.length;e++){const t=r[e];"number"==typeof t&&this.holes.add(t)}}size(){return this.data.length-this.holes.size}values(){return(0,i.arrayFilter)(this.data,((e,t)=>!this.holes.has(t)))[Symbol.iterator]()}entries(){const e=[];for(let t=0;t<this.data.length;t++){const r=this._getKeyByStorageIndex(t);-1!==r&&e.push([r,this.data[t]])}let t=0;return{next:()=>{if(t<e.length){const r=e[t];return t+=1,{value:r,done:!1}}return{done:!0}}}}clear(){this.data=[],this.index=[],this.holes.clear()}_getStorageIndexByKey(e){return this.index.length>e?this.index[e]:-1}_getKeyByStorageIndex(e){return this.index.indexOf(e)}[Symbol.iterator](){return this.entries()}}t.default=a},66535:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(15724);var s=n(r(85707)),i=r(25499),o=r(62979),a=n(r(86310)),l=r(70505);t.default=class{constructor(e){(0,s.default)(this,"columnMeta",void 0),(0,s.default)(this,"metas",new a.default((()=>this._createRow()))),this.columnMeta=e}updateMeta(e,t,r){const n=this.getMeta(e,t);(0,i.extend)(n,r),(0,o.extendByMetaType)(n,r)}createRow(e,t){this.metas.insert(e,t)}createColumn(e,t){for(let r=0;r<this.metas.size();r++)this.metas.obtain(r).insert(e,t)}removeRow(e,t){this.metas.remove(e,t)}removeColumn(e,t){for(let r=0;r<this.metas.size();r++)this.metas.obtain(r).remove(e,t)}getMeta(e,t,r){const n=this.metas.obtain(e).obtain(t);return void 0===r?n:n[r]}setMeta(e,t,r,n){var s;const i=this.metas.obtain(e).obtain(t);null===(s=i._automaticallyAssignedMetaProps)||void 0===s||s.delete(r),i[r]=n}removeMeta(e,t,r){delete this.metas.obtain(e).obtain(t)[r]}getMetas(){const e=[],t=Array.from(this.metas.values());for(let r=0;r<t.length;r++)(0,l.isDefined)(t[r])&&e.push(...t[r].values());return e}getMetasAtRow(e){(0,o.assert)((()=>(0,o.isUnsignedNumber)(e)),"Expecting an unsigned number.");const t=new Map(this.metas);return t.has(e)?Array.from(t.get(e).values()):[]}clearCache(){this.metas.clear()}_createRow(){return new a.default((e=>this._createMeta(e)))}_createMeta(e){return new(this.columnMeta.getMetaConstructor(e))}}},72653:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),i=r(25499),o=r(62979),a=n(r(86310));const l=["data","width"];t.default=class{constructor(e){(0,s.default)(this,"globalMeta",void 0),(0,s.default)(this,"metas",new a.default((()=>this._createMeta()))),this.globalMeta=e,this.metas=new a.default((()=>this._createMeta()))}updateMeta(e,t){const r=this.getMeta(e);(0,i.extend)(r,t),(0,o.extendByMetaType)(r,t)}createColumn(e,t){this.metas.insert(e,t)}removeColumn(e,t){this.metas.remove(e,t)}getMeta(e){return this.metas.obtain(e)}getMetaConstructor(e){return this.metas.obtain(e).constructor}clearCache(){this.metas.clear()}_createMeta(){return(0,o.columnFactory)(this.globalMeta.getMetaConstructor(),l).prototype}}},98960:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),i=r(25499),o=r(62979),a=n(r(954));t.default=class{constructor(e){(0,s.default)(this,"metaCtor",class{}),(0,s.default)(this,"meta",void 0),this.meta=this.metaCtor.prototype,(0,i.extend)(this.meta,(0,a.default)()),this.meta.instance=e}getMetaConstructor(){return this.metaCtor}getMeta(){return this.meta}updateMeta(e){var t;(0,i.extend)(this.meta,e),(0,o.extendByMetaType)(this.meta,{...e,type:null!==(t=e.type)&&void 0!==t?t:this.meta.type},e)}}},7229:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),i=r(25499),o=r(62979);t.default=class{constructor(e){(0,s.default)(this,"meta",void 0);const t=e.getMetaConstructor();this.meta=new t}getMeta(){return this.meta}updateMeta(e){(0,i.extend)(this.meta,e),(0,o.extendByMetaType)(this.meta,e,e)}}},954:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(70505),s=r(25499);t.default=()=>({_automaticallyAssignedMetaProps:void 0,activeHeaderClassName:"ht__active_highlight",allowEmpty:!0,allowHtml:!1,allowInsertColumn:!0,allowInsertRow:!0,allowInvalid:!0,allowRemoveColumn:!0,allowRemoveRow:!0,ariaTags:!0,autoColumnSize:void 0,autoRowSize:void 0,autoWrapCol:!1,autoWrapRow:!1,bindRowsWithHeaders:void 0,cell:[],cells:void 0,checkedTemplate:void 0,className:void 0,colHeaders:null,collapsibleColumns:void 0,columnHeaderHeight:void 0,columns:void 0,columnSorting:void 0,columnSummary:void 0,colWidths:void 0,commentedCellClassName:"htCommentCell",comments:!1,contextMenu:void 0,copyable:!0,copyPaste:!0,correctFormat:!1,currentColClassName:void 0,currentHeaderClassName:"ht__highlight",currentRowClassName:void 0,customBorders:!1,data:void 0,dataDotNotation:!0,dataSchema:void 0,dateFormat:"DD/MM/YYYY",timeFormat:"h:mm:ss a",datePickerConfig:void 0,defaultDate:void 0,disableVisualSelection:!1,dragToScroll:!0,dropdownMenu:void 0,editor:void 0,enterBeginsEditing:!0,enterMoves:{col:0,row:1},fillHandle:{autoInsertRow:!1},filter:!0,filteringCaseSensitive:!1,filters:void 0,fixedColumnsLeft:0,fixedColumnsStart:0,fixedRowsBottom:0,fixedRowsTop:0,formulas:void 0,fragmentSelection:!1,headerClassName:void 0,height:void 0,hiddenColumns:void 0,hiddenRows:void 0,invalidCellClassName:"htInvalid",imeFastEdit:!1,isEmptyCol(e){let t,r,s;for(t=0,r=this.countRows();t<r;t++)if(s=this.getDataAtCell(t,e),!1===(0,n.isEmpty)(s))return!1;return!0},isEmptyRow(e){let t,r,i,o;for(t=0,r=this.countCols();t<r;t++)if(i=this.getDataAtCell(e,t),!1===(0,n.isEmpty)(i))return"object"==typeof i&&(o=this.getCellMeta(e,t),(0,s.isObjectEqual)(this.getSchema()[o.prop],i));return!0},label:void 0,language:"en-US",layoutDirection:"inherit",licenseKey:void 0,locale:"en-US",manualColumnFreeze:void 0,manualColumnMove:void 0,manualColumnResize:void 0,manualRowMove:void 0,manualRowResize:void 0,maxCols:1/0,maxRows:1/0,mergeCells:!1,minCols:0,minRows:0,minSpareCols:0,minSpareRows:0,multiColumnSorting:void 0,navigableHeaders:!1,tabNavigation:!0,nestedHeaders:void 0,nestedRows:void 0,noWordWrapClassName:"htNoWrap",numericFormat:void 0,observeDOMVisibility:!0,outsideClickDeselects:!0,persistentState:void 0,placeholder:void 0,placeholderCellClassName:"htPlaceholder",preventOverflow:!1,preventWheel:!1,readOnly:!1,readOnlyCellClassName:"htDimmed",renderAllRows:!1,renderAllColumns:!1,renderer:void 0,rowHeaders:void 0,rowHeaderWidth:void 0,rowHeights:void 0,search:!1,selectionMode:"multiple",selectOptions:void 0,skipColumnOnPaste:!1,skipRowOnPaste:!1,sortByRelevance:!0,source:void 0,startCols:5,startRows:5,stretchH:"none",strict:void 0,tableClassName:void 0,themeName:void 0,tabMoves:{row:0,col:1},title:void 0,trimDropdown:!0,trimRows:void 0,trimWhitespace:!0,type:"text",uncheckedTemplate:void 0,undo:void 0,validator:void 0,viewportColumnRenderingOffset:"auto",viewportRowRenderingOffset:"auto",viewportColumnRenderingThreshold:0,viewportRowRenderingThreshold:0,visibleRows:10,width:void 0,wordWrap:!0})},59594:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(71336),r(41558),r(17663),r(68630),r(79645),r(89858),r(8620);var s=n(r(85707)),i=r(28197),o=r(25499),a=r(89804);t.DynamicCellMetaMod=class{constructor(e){(0,s.default)(this,"metaManager",void 0),(0,s.default)(this,"metaSyncMemo",new Map),this.metaManager=e,e.addLocalHook("afterGetCellMeta",(e=>this.extendCellMeta(e))),i.Hooks.getSingleton().add("beforeRender",(e=>{e&&this.metaSyncMemo.clear()}),this.metaManager.hot)}extendCellMeta(e){var t;const{row:r,col:n}=e;if(null!==(t=this.metaSyncMemo.get(r))&&void 0!==t&&t.has(n))return;const{visualRow:s,visualCol:i}=e,l=this.metaManager.hot,h=l.colToProp(i);e.prop=h,l.runHooks("beforeGetCellMeta",s,i,e);const u=(0,o.hasOwnProperty)(e,"type")?e.type:null;let c=(0,a.isFunction)(e.cells)?e.cells(r,n,h):null;var d;u&&(c?c.type=null!==(d=c.type)&&void 0!==d?d:u:c={type:u});c&&this.metaManager.updateCellMeta(r,n,c),l.runHooks("afterGetCellMeta",s,i,e),this.metaSyncMemo.has(r)||this.metaSyncMemo.set(r,new Set),this.metaSyncMemo.get(r).add(n)}}},13944:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724),r(71336),r(41558),r(17663),r(68630),r(79645),r(89858),r(8620),r(14846),r(69655);var s=n(r(85707));function i(e,t,r){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,r)}function o(e,t){return e.get(function(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}(e,t))}var a=new WeakMap;t.ExtendMetaPropertiesMod=class{constructor(e){(0,s.default)(this,"metaManager",void 0),(0,s.default)(this,"usageTracker",new Set),(0,s.default)(this,"propDescriptors",new Map([["ariaTags",{initOnly:!0}],["fixedColumnsLeft",{target:"fixedColumnsStart",onChange(e){if(this.metaManager.hot.isRtl()&&"fixedColumnsLeft"===e)throw new Error("The `fixedColumnsLeft` is not supported for RTL. Please use option `fixedColumnsStart`.");if(this.usageTracker.has("fixedColumnsLeft")&&this.usageTracker.has("fixedColumnsStart"))throw new Error("The `fixedColumnsLeft` and `fixedColumnsStart` should not be used together. Please use only the option `fixedColumnsStart`.")}}],["layoutDirection",{initOnly:!0}],["renderAllColumns",{initOnly:!0}],["renderAllRows",{initOnly:!0}]])),i(this,a,((e,t,r)=>{if(!r)throw new Error(`The \`${e}\` option can not be updated after the Handsontable is initialized.`)})),this.metaManager=e,this.extendMetaProps()}extendMetaProps(){this.propDescriptors.forEach(((e,t)=>{const{initOnly:r,target:n,onChange:s}=e,i="string"==typeof n,l=i?n:t,h=`_${l}`;this.metaManager.globalMeta.meta[h]=this.metaManager.globalMeta.meta[l],s?(this.installPropWatcher(t,h,s),i&&this.installPropWatcher(n,h,s)):r&&(this.installPropWatcher(t,h,o(a,this)),this.metaManager.globalMeta.meta._initOnlySettings||(this.metaManager.globalMeta.meta._initOnlySettings=[]),this.metaManager.globalMeta.meta._initOnlySettings.push(t))}))}installPropWatcher(e,t,r){const n=this;Object.defineProperty(this.metaManager.globalMeta.meta,e,{get(){return this[t]},set(s){const i=!n.usageTracker.has(e);n.usageTracker.add(e),r.call(n,e,s,i),this[t]=s},enumerable:!0,configurable:!0})}}},62979:(e,t,r)=>{"use strict";t.__esModule=!0,t.assert=function(e,t){if(!e())throw new Error(`Assertion failed: ${t}`)},t.columnFactory=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];function r(){}(0,n.inherit)(r,e);for(let e=0;e<t.length;e++)r.prototype[t[e]]=void 0;return r},t.extendByMetaType=function(e,t){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:e;const i="string"==typeof t.type?(0,s.getCellType)(t.type):t.type;e._automaticallyAssignedMetaProps&&(0,n.objectEach)(t,((t,r)=>{e._automaticallyAssignedMetaProps.delete(r)}));if(!(0,n.isObject)(i))return;r!==e||e._automaticallyAssignedMetaProps||(e._automaticallyAssignedMetaProps=new Set);const o={};(0,n.objectEach)(i,((t,s)=>{var i;(function(e,t){var r;if("CELL_TYPE"===e)return!1;return(null===(r=t._automaticallyAssignedMetaProps)||void 0===r?void 0:r.has(e))||!(0,n.hasOwnProperty)(t,e)})(s,r)&&(o[s]=t,null===(i=e._automaticallyAssignedMetaProps)||void 0===i||i.add(s))})),(0,n.extend)(e,o)},t.isNullish=function(e){return null==e},t.isUnsignedNumber=function(e){return Number.isInteger(e)&&e>=0},r(67834),r(71336),r(41558),r(17663),r(68630),r(79645),r(89858),r(8620);var n=r(25499),s=r(1791)},32465:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.replaceData=function(e,t,r,n){const{hotInstance:u,dataMap:c,dataSource:d,internalSource:p,source:g,metaManager:f,firstRun:m}=n,y=(0,s.toUpperCaseFirst)(p),E=u.getSettings();Array.isArray(E.dataSchema)?u.dataType="array":(0,i.isFunction)(E.dataSchema)?u.dataType="function":u.dataType="object";c&&c.destroy();e=u.runHooks(`before${y}`,e,m,g);const w=new o.default(u,e,f);if(t(w),"object"==typeof e&&null!==e)e.push&&e.splice||(e=[e]);else{if(null!==e)throw new Error(`${p} only accepts array of objects or array of arrays (${typeof e} given)`);{const t=w.getSchema();let r;e=[];let n=0,s=0;for(n=0,s=E.startRows;n<s;n++)if("object"!==u.dataType&&"function"!==u.dataType||!E.dataSchema)if("array"===u.dataType)r=(0,a.deepClone)(t[0]),e.push(r);else{r=[];for(let e=0,t=E.startCols;e<t;e++)r.push(null);e.push(r)}else r=(0,a.deepClone)(t),e.push(r)}}Array.isArray(e[0])&&(u.dataType="array");E.data=e,w.dataSource=e,d.data=e,d.dataType=u.dataType,d.colToProp=w.colToProp.bind(w),d.propToCol=w.propToCol.bind(w),d.countCachedColumns=w.countCachedColumns.bind(w),r(w),u.runHooks(`after${y}`,e,m,g),m||(u.runHooks("afterChange",null,p),u.render());u.getSettings().ariaTags&&(0,l.setAttribute)(u.rootElement,[(0,h.A11Y_ROWCOUNT)(-1),(0,h.A11Y_COLCOUNT)(u.countCols()+(u.view?u.countRowHeaders():0))])},r(67834),r(15724);var s=r(5893),i=r(89804),o=n(r(78747)),a=r(25499),l=r(62577),h=r(71120)},70892:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),i=r(83445),o=r(77661),a=r(8266),l=n(r(3849));function h(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function u(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var c=new WeakSet;class d{constructor(e,t,r){h(this,c),(0,s.default)(this,"hot",void 0),(0,s.default)(this,"tableMeta",void 0),(0,s.default)(this,"selection",void 0),(0,s.default)(this,"eventManager",void 0),(0,s.default)(this,"destroyed",!1),(0,s.default)(this,"activeEditor",void 0),(0,s.default)(this,"cellProperties",void 0),this.hot=e,this.tableMeta=t,this.selection=r,this.eventManager=new l.default(e),this.hot.addHook("afterDocumentKeyDown",(e=>u(c,this,p).call(this,e))),this.eventManager.addEventListener(this.hot.rootDocument.documentElement,"compositionstart",(e=>{!this.destroyed&&this.hot.isListening()&&this.openEditor("",e)})),this.hot.view._wt.update("onCellDblClick",((e,t,r)=>u(c,this,g).call(this,e,t,r)))}getActiveEditor(){return this.activeEditor}prepareEditor(){var e;if(this.activeEditor&&this.activeEditor.isWaiting())return void this.closeEditor(!1,!1,(e=>{e&&this.prepareEditor()}));const t=null===(e=this.hot.getSelectedRangeLast())||void 0===e?void 0:e.highlight;if(!t||t.isHeader())return;const{row:r,col:n}=t,s=this.hot.runHooks("modifyGetCellCoords",r,n,!1,"meta");let i=r,o=n;if(Array.isArray(s)&&([i,o]=s),this.cellProperties=this.hot.getCellMeta(i,o),!this.isCellEditable())return void this.clearActiveEditor();const l=this.hot.getCell(r,n,!0);if(l){const e=this.hot.getCellEditor(this.cellProperties),t=this.hot.colToProp(o),s=this.hot.getSourceDataAtCell(this.hot.toPhysicalRow(i),o);this.activeEditor=(0,a.getEditorInstance)(e,this.hot),this.activeEditor.prepare(r,n,t,l,s,this.cellProperties)}}isEditorOpened(){return this.activeEditor&&this.activeEditor.isOpened()}openEditor(e,t){let r=arguments.length>2&&void 0!==arguments[2]&&arguments[2];if(!this.isCellEditable())return void this.clearActiveEditor();const n=this.hot.getSelectedRangeLast();let s=this.hot.runHooks("beforeBeginEditing",n.highlight.row,n.highlight.col,e,t,r);t instanceof MouseEvent&&"boolean"!=typeof s&&(s=0===this.hot.selection.getLayerLevel()&&n.isSingle()),!1!==s?(this.activeEditor||(this.hot.scrollToFocusedCell(),this.prepareEditor()),this.activeEditor&&(r&&this.activeEditor.enableFullEditMode(),this.activeEditor.beginEditing(e,t))):this.clearActiveEditor()}closeEditor(e,t,r){this.activeEditor?this.activeEditor.finishEditing(e,t,r):r&&r(!1)}closeEditorAndSaveChanges(e){this.closeEditor(!1,e)}closeEditorAndRestoreOriginalValue(e){this.closeEditor(!0,e)}clearActiveEditor(){this.activeEditor=void 0}isCellEditable(){const e=this.hot.getSelectedRangeLast();if(!e)return!1;const t=this.hot.getCellEditor(this.cellProperties),{row:r,col:n}=e.highlight,{rowIndexMapper:s,columnIndexMapper:i}=this.hot,o=s.isHidden(this.hot.toPhysicalRow(r))||i.isHidden(this.hot.toPhysicalColumn(n));return!(this.cellProperties.readOnly||!t||o)}moveSelectionAfterEnter(e){const t={..."function"==typeof this.tableMeta.enterMoves?this.tableMeta.enterMoves(e):this.tableMeta.enterMoves};e.shiftKey&&(t.row=-t.row,t.col=-t.col),this.hot.selection.isMultiple()?this.selection.transformFocus(t.row,t.col):this.selection.transformStart(t.row,t.col,!0)}destroy(){this.destroyed=!0,this.eventManager.destroy()}}function p(e){const t=this.hot.getSelectedRangeLast();if(!this.hot.isListening()||!t||t.highlight.isHeader()||(0,o.isImmediatePropagationStopped)(e))return;const{keyCode:r}=e,n=(e.ctrlKey||e.metaKey)&&!e.altKey;(!this.activeEditor||this.activeEditor&&!this.activeEditor.isWaiting())&&((0,i.isFunctionKey)(r)||(0,i.isCtrlMetaKey)(r)||n||this.isEditorOpened()||this.openEditor("",e))}function g(e,t){t.isCell()&&this.openEditor(null,e,!0)}const f=new WeakMap;d.getInstance=function(e,t,r){let n=f.get(e);return n||(n=new d(e,t,r),f.set(e,n)),n};t.default=d},28474:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724),r(14846),r(27458),r(6211),r(90458);var s=n(r(85707)),i=r(82518),o=r(10587),a=r(62577),l=r(70505),h=r(5893),u=r(83445),c=r(85096),d=r(71120);function p(e,t,r){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,r)}function g(e,t){return e.get(function(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}(e,t))}const f=t.EDITOR_TYPE="autocomplete";var m=new WeakMap;class y extends i.HandsontableEditor{constructor(){super(...arguments),(0,s.default)(this,"query",null),(0,s.default)(this,"strippedChoices",[]),(0,s.default)(this,"rawChoices",[]),p(this,m,this.hot.guid.slice(0,9)),(0,s.default)(this,"sortByRelevance",(function(e,t,r){const n=[],s=[],i=e.length;let o,a,u,c,d=t.length;if(0===i){for(u=0;u<d;u++)s.push(u);return s}for(u=0;u<d;u++){if(a=(0,h.stripTags)((0,l.stringify)(t[u])),r)c=a.indexOf(e);else{const t=this.cellProperties.locale;c=a.toLocaleLowerCase(t).indexOf(e.toLocaleLowerCase(t))}-1!==c&&(o=a.length-c-i,n.push({baseIndex:u,index:c,charsLeft:o,value:a}))}for(n.sort(((e,t)=>{if(-1===t.index)return-1;if(-1===e.index)return 1;if(e.index<t.index)return-1;if(t.index<e.index)return 1;if(e.index===t.index){if(e.charsLeft<t.charsLeft)return-1;if(e.charsLeft>t.charsLeft)return 1}return 0})),u=0,d=n.length;u<d;u++)s.push(n[u].baseIndex);return s}))}static get EDITOR_TYPE(){return f}getValue(){const e=this.rawChoices.find((e=>this.stripValueIfNeeded(e)===this.TEXTAREA.value));return(0,l.isDefined)(e)?e:this.TEXTAREA.value}createElements(){super.createElements(),(0,a.addClass)(this.htContainer,"autocompleteEditor"),(0,a.addClass)(this.htContainer,-1===this.hot.rootWindow.navigator.platform.indexOf("Mac")?"":"htMacScroll"),this.hot.getSettings().ariaTags&&(0,a.setAttribute)(this.TEXTAREA,[(0,d.A11Y_TEXT)(),(0,d.A11Y_COMBOBOX)(),(0,d.A11Y_HASPOPUP)("listbox"),(0,d.A11Y_AUTOCOMPLETE)()])}prepare(e,t,r,n,s,i){super.prepare(e,t,r,n,s,i),this.hot.getSettings().ariaTags&&(0,a.setAttribute)(this.TEXTAREA,[(0,d.A11Y_EXPANDED)("false"),(0,d.A11Y_CONTROLS)(`${g(m,this)}-listbox-${e}-${t}`)])}open(){super.open();const e=void 0===this.cellProperties.trimDropdown||this.cellProperties.trimDropdown,t=this.hot.getSettings().ariaTags,r=Array.isArray(this.cellProperties.source)?this.cellProperties.source:null,n=null==r?void 0:r.length,{row:s,col:i}=this;this.showEditableElement(),this.focus(),this.addHook("beforeKeyDown",(e=>this.onBeforeKeyDown(e))),this.htEditor.updateSettings({colWidths:e?[(0,a.outerWidth)(this.TEXTAREA)-2]:void 0,autoColumnSize:!0,autoRowSize:!0,renderer:(e,s,i,o,h,u,p)=>{(0,c.textRenderer)(e,s,i,o,h,u,p);const{filteringCaseSensitive:g,allowHtml:f,locale:m}=this.cellProperties,y=this.query;let E,w,C=(0,l.stringify)(u);C&&!f&&(E=!0===g?C.indexOf(y):C.toLocaleLowerCase(m).indexOf(y.toLocaleLowerCase(m)),-1!==E&&(w=C.substr(E,y.length),C=C.replace(w,`<strong>${w}</strong>`))),t&&(0,a.setAttribute)(s,[(0,d.A11Y_OPTION)(),...r?[(0,d.A11Y_SETSIZE)(n)]:[],...r?[(0,d.A11Y_POSINSET)(r.indexOf(u)+1)]:[],["id",`${this.htEditor.rootElement.id}_${i}-${o}`]]),s.innerHTML=C},afterSelectionEnd:(e,r)=>{if(t){const t=this.htEditor.getCell(e,r,!0);(0,a.setAttribute)(t,[(0,d.A11Y_SELECTED)()]),(0,a.setAttribute)(this.TEXTAREA,...(0,d.A11Y_ACTIVEDESCENDANT)(t.id))}}}),t&&((0,a.setAttribute)(this.htEditor.view._wt.wtOverlays.wtTable.TABLE,...(0,d.A11Y_PRESENTATION)()),(0,a.setAttribute)(this.htEditor.rootElement,[(0,d.A11Y_LISTBOX)(),(0,d.A11Y_LIVE)("polite"),(0,d.A11Y_RELEVANT)("text"),["id",`${g(m,this)}-listbox-${s}-${i}`]]),(0,a.setAttribute)(this.TEXTAREA,...(0,d.A11Y_EXPANDED)("true"))),this.hot._registerTimeout((()=>{this.queryChoices(this.TEXTAREA.value)}))}close(){this.removeHooksByKey("beforeKeyDown"),super.close(),this.hot.getSettings().ariaTags&&(0,a.setAttribute)(this.TEXTAREA,[(0,d.A11Y_EXPANDED)("false")])}discardEditor(e){super.discardEditor(e),this.hot.view.render()}queryChoices(e){const t=this.cellProperties.source;this.query=e,"function"==typeof t?t.call(this.cellProperties,e,(e=>{this.rawChoices=e,this.updateChoicesList(this.stripValuesIfNeeded(e))})):Array.isArray(t)?(this.rawChoices=t,this.updateChoicesList(this.stripValuesIfNeeded(t))):this.updateChoicesList([])}updateChoicesList(e){const t=(0,a.getCaretPosition)(this.TEXTAREA),r=(0,a.getSelectionEndPosition)(this.TEXTAREA),n=this.cellProperties.sortByRelevance,s=this.cellProperties.filter;let i=null,l=null,h=e;n&&(i=this.sortByRelevance(this.stripValueIfNeeded(this.getValue()),h,this.cellProperties.filteringCaseSensitive));const u=Array.isArray(i)?i.length:0;if(!1===s)u&&(l=i[0]);else{const e=[];for(let t=0,r=h.length;t<r&&!(n&&u<=t);t++)u?e.push(h[i[t]]):e.push(h[t]);l=0,h=e}this.strippedChoices=h,0===h.length?this.htEditor.rootElement.style.display="none":this.htEditor.rootElement.style.display="",this.htEditor.loadData((0,o.pivot)([h])),h.length>0&&(this.updateDropdownDimensions(),this.flipDropdownIfNeeded(),!0===this.cellProperties.strict&&this.highlightBestMatchingChoice(l)),this.hot.listen(),(0,a.setCaretPosition)(this.TEXTAREA,t,t===r?void 0:r)}flipDropdownIfNeeded(){const e=(0,a.getTrimmingContainer)(this.hot.view._wt.wtTable.TABLE),t=e===this.hot.rootWindow,r=this.cellProperties.preventOverflow;if(t||!t&&(r||"horizontal"===r))return!1;const n=(0,a.offset)(this.TEXTAREA),s=(0,a.outerHeight)(this.TEXTAREA),i=this.getHeight(),o=e.scrollTop,l=(0,a.outerHeight)(this.hot.view._wt.wtTable.THEAD),h=(0,a.offset)(e),u=n.top-h.top-l+o,c=e.scrollHeight-u-l-s,d=i>c&&u>c;return d?this.flipDropdown(i):this.unflipDropdown(),this.limitDropdownIfNeeded(d?u:c,i),d}limitDropdownIfNeeded(e,t){if(t>e){let r=0,n=0,s=0,i=null;do{s=this.htEditor.getRowHeight(n)||this.htEditor.view.getDefaultRowHeight(),r+=s,n+=1}while(r<e);i=r-s,this.htEditor.flipped&&(this.htEditor.rootElement.style.top=parseInt(this.htEditor.rootElement.style.top,10)+t-i+"px"),this.setDropdownHeight(r-s)}}flipDropdown(e){const t=this.htEditor.rootElement.style;t.position="absolute",t.top=-e+"px",this.htEditor.flipped=!0}unflipDropdown(){const e=this.htEditor.rootElement.style;e.position="absolute",e.top="",this.htEditor.flipped=void 0}updateDropdownDimensions(){this.htEditor.updateSettings({width:this.getWidth(),height:this.getHeight()}),this.htEditor.view.hasVerticalScroll()&&this.htEditor.updateSettings({width:this.htEditor.getSettings().width+(0,a.getScrollbarWidth)(this.hot.rootDocument)}),this.htEditor.view._wt.wtTable.alignOverlaysWithTrimmingContainer()}setDropdownHeight(e){this.htEditor.updateSettings({height:e})}highlightBestMatchingChoice(e){"number"==typeof e?this.htEditor.selectCell(e,0,void 0,void 0,void 0,!1):this.htEditor.deselectCell()}getHeight(){const e=this.hot.rootWindow.getComputedStyle(this.htContainer.querySelector(".htCore")),t=parseInt(e.borderTopWidth,10)+parseInt(e.borderBottomWidth,10),r=Math.min(this.cellProperties.visibleRows,this.strippedChoices.length);return Array.from({length:r},((e,t)=>t)).reduce(((e,t)=>e+this.htEditor.getRowHeight(t)),0)+t+1}getWidth(){const e=this.hot.rootWindow.getComputedStyle(this.htContainer.querySelector(".htCore")),t=parseInt(e.borderInlineStartWidth,10)+parseInt(e.borderInlineEndWidth,10);return this.htEditor.getColWidth(0)+t}stripValueIfNeeded(e){return this.stripValuesIfNeeded([e])[0]}stripValuesIfNeeded(e){const{allowHtml:t}=this.cellProperties,r=(0,o.arrayMap)(e,(e=>(0,l.stringify)(e)));return(0,o.arrayMap)(r,(e=>t?e:(0,h.stripTags)(e)))}allowKeyEventPropagation(e){const t=this.htEditor.getSelectedRangeLast(),r=t?t.from.row:-1;let n=!1;return e===u.KEY_CODES.ARROW_DOWN&&r>0&&r<this.htEditor.countRows()-1&&(n=!0),e===u.KEY_CODES.ARROW_UP&&r>-1&&(n=!0),n}onBeforeKeyDown(e){if((0,u.isPrintableChar)(e.keyCode)||e.keyCode===u.KEY_CODES.BACKSPACE||e.keyCode===u.KEY_CODES.DELETE||e.keyCode===u.KEY_CODES.INSERT){let t=10;if(e.keyCode===u.KEY_CODES.C&&(e.ctrlKey||e.metaKey))return;this.isOpened()||(t+=10),this.htEditor&&this.hot._registerTimeout((()=>{this.queryChoices(this.TEXTAREA.value)}),t)}}}t.AutocompleteEditor=y},10463:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(28474);t.EDITOR_TYPE=n.EDITOR_TYPE,t.AutocompleteEditor=n.AutocompleteEditor},60448:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),i=r(70505),o=r(25499),a=n(r(70292)),l=r(62577);const h=t.EDITOR_TYPE="base",u=t.EDITOR_STATE=Object.freeze({VIRGIN:"STATE_VIRGIN",EDITING:"STATE_EDITING",WAITING:"STATE_WAITING",FINISHED:"STATE_FINISHED"});class c{static get EDITOR_TYPE(){return h}constructor(e){(0,s.default)(this,"hot",void 0),(0,s.default)(this,"state",u.VIRGIN),(0,s.default)(this,"_opened",!1),(0,s.default)(this,"_fullEditMode",!1),(0,s.default)(this,"_closeCallback",null),(0,s.default)(this,"TD",null),(0,s.default)(this,"row",null),(0,s.default)(this,"col",null),(0,s.default)(this,"prop",null),(0,s.default)(this,"originalValue",null),(0,s.default)(this,"cellProperties",null),this.hot=e,this.init()}_fireCallbacks(e){this._closeCallback&&(this._closeCallback(e),this._closeCallback=null)}init(){}getValue(){throw Error("Editor getValue() method unimplemented")}setValue(){throw Error("Editor setValue() method unimplemented")}open(){throw Error("Editor open() method unimplemented")}close(){throw Error("Editor close() method unimplemented")}prepare(e,t,r,n,s,i){this.TD=n,this.row=e,this.col=t,this.prop=r,this.originalValue=s,this.cellProperties=i,this.state=this.isOpened()?this.state:u.VIRGIN}extend(){return class extends this.constructor{}}saveValue(e,t){let r,n,s,i;if(t){const e=this.hot.getSelectedLast();r=Math.max(Math.min(e[0],e[2]),0),n=Math.max(Math.min(e[1],e[3]),0),s=Math.max(e[0],e[2]),i=Math.max(e[1],e[3])}else[r,n,s,i]=[this.row,this.col,null,null];const o=this.hot.runHooks("modifyGetCellCoords",r,n,!1,"meta");Array.isArray(o)&&([r,n]=o),this.hot.populateFromArray(r,n,e,s,i,"edit")}beginEditing(e,t){if(this.state!==u.VIRGIN)return;const r=this.hot,n=r.rowIndexMapper.getRenderableFromVisualIndex(this.row),s=r.columnIndexMapper.getRenderableFromVisualIndex(this.col),o=()=>{if(this.state=u.EDITING,this.isInFullEditMode()){const t="string"==typeof e?e:(0,i.stringify)(this.originalValue);this.setValue(t)}this.open(t),this._opened=!0,this.focus(),r.view.render(),r.runHooks("afterBeginEditing",this.row,this.col)};this.hot.addHookOnce("afterScroll",o);r.view.scrollViewport(r._createCellCoords(n,s))||(this.hot.removeHook("afterScroll",o),o())}finishEditing(e,t,r){let n;if(r){const e=this._closeCallback;this._closeCallback=t=>{e&&e(t),r(t),this.hot.view.render()}}if(!this.isWaiting())if(this.state!==u.VIRGIN){if(this.state===u.EDITING){if(e)return this.cancelChanges(),void this.hot.view.render();const r=this.getValue();n=this.cellProperties.trimWhitespace?[["string"==typeof r?String.prototype.trim.call(r||""):r]]:[[r]],this.state=u.WAITING,this.saveValue(n,t),this.hot.getCellValidator(this.cellProperties)?this.hot.addHookOnce("postAfterValidate",(e=>{this.state=u.FINISHED,this.discardEditor(e)})):(this.state=u.FINISHED,this.discardEditor(!0))}}else this.hot._registerTimeout((()=>{this._fireCallbacks(!0)}))}cancelChanges(){this.state=u.FINISHED,this.discardEditor()}discardEditor(e){if(this.state===u.FINISHED)if(!1===e&&!0!==this.cellProperties.allowInvalid)this.hot.selectCell(this.row,this.col),this.focus(),this.state=u.EDITING,this._fireCallbacks(!1);else{this.close(),this._opened=!1,this._fullEditMode=!1,this.state=u.VIRGIN,this._fireCallbacks(!0);this.hot.getShortcutManager().setActiveContextName("grid")}}enableFullEditMode(){this._fullEditMode=!0}isInFullEditMode(){return this._fullEditMode}isOpened(){return this._opened}isWaiting(){return this.state===u.WAITING}getEditedCellRect(){var e;const t=this.getEditedCell();if(!t)return;const{wtOverlays:r,wtViewport:n}=this.hot.view._wt,s=this.hot.rootWindow,i=(0,l.offset)(t),o=(0,l.outerWidth)(t),a=(0,l.offset)(this.hot.rootElement),h=(0,l.outerWidth)(this.hot.rootElement),u=r.topOverlay.holder,c=r.inlineStartOverlay.holder,d=u!==s?u.scrollTop:0,p=c!==s?c.scrollLeft:0,g=s.innerWidth-a.left-h,{wtTable:f}=null!==(e=r.getParentOverlay(t))&&void 0!==e?e:this.hot.view._wt,m=f.name,y=["master","inline_start"].includes(m)?d:0,E=["master","top","bottom"].includes(m)?p:0,w=i.top===a.top?0:1;let C=i.top-a.top-w-y,v=0;v=this.hot.isRtl()?s.innerWidth-i.left-o-g-1+E:i.left-a.left-1-E,["top","top_inline_start_corner"].includes(m)&&(C+=r.topOverlay.getOverlayOffset()),["inline_start","top_inline_start_corner"].includes(m)&&(v+=Math.abs(r.inlineStartOverlay.getOverlayOffset()));const R=this.hot.hasColHeaders(),S=this.hot.rowIndexMapper.getRenderableFromVisualIndex(this.row),T=this.hot.columnIndexMapper.getRenderableFromVisualIndex(this.col),N=this.hot.rowIndexMapper.getRenderableIndexesLength()-this.hot.view._wt.getSetting("fixedRowsBottom");(R&&S<=0||S===N)&&(C+=1),T<=0&&(v+=1);const M=n.rowsRenderCalculator.startPosition,_=n.columnsRenderCalculator.startPosition,b=Math.abs(r.inlineStartOverlay.getScrollPosition()),A=r.topOverlay.getScrollPosition(),O=(0,l.getScrollbarWidth)(this.hot.rootDocument);let I=t.offsetTop;if(["inline_start","master"].includes(m)&&(I+=M-A),["bottom","bottom_inline_start_corner"].includes(m)){const{wtViewport:e,wtTable:t}=r.bottomOverlay.clone;I+=e.getWorkspaceHeight()-t.getHeight()-O}let x=t.offsetLeft;this.hot.isRtl()?(x=x>=0?f.getWidth()-t.offsetLeft:Math.abs(x),x+=_-b-o):["top","master","bottom"].includes(m)&&(x+=_-b);const P=s.getComputedStyle(this.TD),L=this.hot.isRtl()?"borderRightWidth":"borderLeftWidth",D=parseInt(P[L],10)>0?0:1,k=parseInt(P.borderTopWidth,10)>0?0:1,H=(0,l.outerWidth)(t)+D,F=(0,l.outerHeight)(t)+k,U=(0,l.hasVerticalScrollbar)(u)?O:0,V=(0,l.hasHorizontalScrollbar)(c)?O:0,B=this.hot.view.maximumVisibleElementWidth(x)-U+D;return{top:C,start:v,height:F,maxHeight:Math.max(this.hot.view.maximumVisibleElementHeight(I)-V+k,this.hot.view.getDefaultRowHeight()),width:H,maxWidth:B}}getEditedCellsLayerClass(){switch(this.checkEditorSection()){case"inline-start":return"ht_clone_left ht_clone_inline_start";case"bottom":return"ht_clone_bottom";case"bottom-inline-start-corner":return"ht_clone_bottom_left_corner ht_clone_bottom_inline_start_corner";case"top":return"ht_clone_top";case"top-inline-start-corner":return"ht_clone_top_left_corner ht_clone_top_inline_start_corner";default:return"ht_clone_master"}}getEditedCell(){return this.hot.getCell(this.row,this.col,!0)}checkEditorSection(){const e=this.hot.countRows();let t="";return this.row<this.hot.getSettings().fixedRowsTop?t=this.col<this.hot.getSettings().fixedColumnsStart?"top-inline-start-corner":"top":this.hot.getSettings().fixedRowsBottom&&this.row>=e-this.hot.getSettings().fixedRowsBottom?t=this.col<this.hot.getSettings().fixedColumnsStart?"bottom-inline-start-corner":"bottom":this.col<this.hot.getSettings().fixedColumnsStart&&(t="inline-start"),t}}t.BaseEditor=c,(0,o.mixin)(c,a.default)},74854:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(60448);t.EDITOR_STATE=n.EDITOR_STATE,t.EDITOR_TYPE=n.EDITOR_TYPE,t.BaseEditor=n.BaseEditor},11476:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(74854),s=r(62577);const i=t.EDITOR_TYPE="checkbox";class o extends n.BaseEditor{static get EDITOR_TYPE(){return i}beginEditing(e,t){if(t&&"mouseup"===t.type&&"TD"===t.target.nodeName){const e=this.TD.querySelector('input[type="checkbox"]');(0,s.hasClass)(e,"htBadValue")||e.click()}}finishEditing(){}init(){}open(){}close(){}getValue(){}setValue(){}focus(){}}t.CheckboxEditor=o},12302:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(11476);t.EDITOR_TYPE=n.EDITOR_TYPE,t.CheckboxEditor=n.CheckboxEditor},28150:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),i=n(r(6671)),o=n(r(44499)),a=r(74854),l=r(66420),h=r(62577),u=r(25499),c=r(83445);const d=t.EDITOR_TYPE="date",p="dateEditor";class g extends l.TextEditor{constructor(){super(...arguments),(0,s.default)(this,"defaultDateFormat","DD/MM/YYYY"),(0,s.default)(this,"parentDestroyed",!1),(0,s.default)(this,"$datePicker",null)}static get EDITOR_TYPE(){return d}init(){if("function"!=typeof i.default)throw new Error("You need to include moment.js to your project.");if("function"!=typeof o.default)throw new Error("You need to include Pikaday to your project.");super.init(),this.hot.addHook("afterDestroy",(()=>{this.parentDestroyed=!0,this.destroyElements()})),this.hot.addHook("afterSetTheme",((e,t)=>{t||((0,h.removeClass)(this.datePicker,/ht-theme-.*/g),(0,h.addClass)(this.datePicker,e))}))}createElements(){super.createElements(),this.datePicker=this.hot.rootDocument.createElement("DIV"),this.datePickerStyle=this.datePicker.style,this.datePickerStyle.position="absolute",this.datePickerStyle.top=0,this.datePickerStyle.left=0,this.datePickerStyle.zIndex=9999,this.datePicker.setAttribute("dir",this.hot.isRtl()?"rtl":"ltr"),(0,h.addClass)(this.datePicker,"htDatepickerHolder");const e=this.hot.getCurrentThemeName();(0,h.removeClass)(this.datePicker,/ht-theme-.*/g),(0,h.addClass)(this.datePicker,e),this.hot.rootDocument.body.appendChild(this.datePicker),this.eventManager.addEventListener(this.datePicker,"mousedown",(e=>{(0,h.hasClass)(e.target,"pika-day")&&this.hideDatepicker(),e.stopPropagation()}))}destroyElements(){const e=this.datePicker.parentNode;this.$datePicker&&this.$datePicker.destroy(),e&&e.removeChild(this.datePicker)}prepare(e,t,r,n,s,i){super.prepare(e,t,r,n,s,i)}open(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;const t=this.hot.getShortcutManager().getContext("editor");this.showDatepicker(e),super.open(),t.addShortcuts([{keys:[["ArrowLeft"]],callback:()=>{this.$datePicker.adjustDate("subtract",1)}},{keys:[["ArrowRight"]],callback:()=>{this.$datePicker.adjustDate("add",1)}},{keys:[["ArrowUp"]],callback:()=>{this.$datePicker.adjustDate("subtract",7)}},{keys:[["ArrowDown"]],callback:()=>{this.$datePicker.adjustDate("add",7)}}],{group:p})}close(){var e;this._opened=!1,null!==(e=this.$datePicker)&&void 0!==e&&e.destroy&&this.$datePicker.destroy(),this.hot._registerTimeout((()=>{const e=this.hot._getEditorManager();e.closeEditor(),this.hot.view.render(),e.prepareEditor()}));this.hot.getShortcutManager().getContext("editor").removeShortcutsByGroup(p),super.close()}finishEditing(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0],t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];super.finishEditing(e,t)}showDatepicker(e){const t=this.cellProperties.dateFormat||this.defaultDateFormat,r=this.hot.view.isMouseDown(),n=!!e&&(0,c.isFunctionKey)(e.keyCode);let s;this.datePicker.style.display="block",this.$datePicker=new o.default(this.getDatePickerConfig()),"function"==typeof this.$datePicker.useMoment&&this.$datePicker.useMoment(i.default),this.$datePicker._onInputFocus=function(){},this.originalValue?(s=this.originalValue,(0,i.default)(s,t,!0).isValid()&&this.$datePicker.setMoment((0,i.default)(s,t),!0),this.getValue()!==this.originalValue&&this.setValue(this.originalValue),n||r||this.setValue("")):this.cellProperties.defaultDate?(s=this.cellProperties.defaultDate,(0,i.default)(s,t,!0).isValid()&&this.$datePicker.setMoment((0,i.default)(s,t),!0),n||r||this.setValue("")):this.$datePicker.gotoToday()}hideDatepicker(){this.datePickerStyle.display="none",this.$datePicker.hide()}getDatePickerConfig(){const e=this.TEXTAREA,t={};this.cellProperties&&this.cellProperties.datePickerConfig&&(0,u.deepExtend)(t,this.cellProperties.datePickerConfig);const r=t.onSelect,n=t.onClose;return t.field=e,t.trigger=e,t.container=this.datePicker,t.bound=!1,t.keyboardInput=!1,t.format=t.format||this.defaultDateFormat,t.reposition=t.reposition||!1,t.isRTL=!1,t.onSelect=e=>{let t=e;isNaN(t.getTime())||(t=(0,i.default)(t).format(this.cellProperties.dateFormat||this.defaultDateFormat)),this.setValue(t),r&&r()},t.onClose=()=>{this.parentDestroyed||this.finishEditing(!1),n&&n()},t}refreshDimensions(e){var t;if(super.refreshDimensions(e),this.state!==a.EDITOR_STATE.EDITING)return;if(this.TD=this.getEditedCell(),!this.TD)return void this.hideDatepicker();const{rowIndexMapper:r,columnIndexMapper:n}=this.hot,{wtOverlays:s}=this.hot.view._wt,{wtTable:i}=null!==(t=s.getParentOverlay(this.TD))&&void 0!==t?t:this.hot.view._wt,o=r.getVisualFromRenderableIndex(i.getFirstPartiallyVisibleRow()),l=r.getVisualFromRenderableIndex(i.getLastPartiallyVisibleRow()),u=n.getVisualFromRenderableIndex(i.getFirstPartiallyVisibleColumn()),c=n.getVisualFromRenderableIndex(i.getLastPartiallyVisibleColumn());if(this.row>=o&&this.row<=l&&this.col>=u&&this.col<=c){const e=this.TD.getBoundingClientRect();this.datePickerStyle.top=`${this.hot.rootWindow.pageYOffset+e.top+(0,h.outerHeight)(this.TD)}px`;let t=this.hot.rootWindow.pageXOffset;this.hot.isRtl()?t+=e.right-(0,h.outerWidth)(this.datePicker):t+=e.left,this.datePickerStyle.left=`${t}px`}else this.hideDatepicker()}}t.DateEditor=g},16339:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(28150);t.EDITOR_TYPE=n.EDITOR_TYPE,t.DateEditor=n.DateEditor},97328:(e,t,r)=>{"use strict";t.__esModule=!0,r(14846),r(27458);var n=r(10463),s=r(28197);const i=t.EDITOR_TYPE="dropdown";class o extends n.AutocompleteEditor{static get EDITOR_TYPE(){return i}prepare(e,t,r,n,s,i){super.prepare(e,t,r,n,s,i),this.cellProperties.filter=!1,this.cellProperties.strict=!0}}t.DropdownEditor=o,s.Hooks.getSingleton().add("beforeValidate",(function(e,t,r){const n=this.propToCol(r);if(Number.isInteger(n)){const e=this.getCellMeta(t,n);e.editor===o&&void 0===e.strict&&(e.filter=!1,e.strict=!0)}}))},51034:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(97328);t.EDITOR_TYPE=n.EDITOR_TYPE,t.DropdownEditor=n.DropdownEditor},37300:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(66420),s=r(62577),i=r(77661),o=r(25499),a=r(92399);const l="handsontableEditor",h=t.EDITOR_TYPE="handsontable";class u extends n.TextEditor{static get EDITOR_TYPE(){return h}open(){super.open();const e=this.htContainer.style;this.htEditor&&(this.htEditor.destroy(),e.width="",e.height="",e.overflow=""),"none"===e.display&&(e.display=""),this.htEditor=new this.hot.constructor(this.htContainer,this.htOptions),this.htEditor.init(),this.htEditor.rootElement.style.display="",this.cellProperties.strict?this.htEditor.selectCell(0,0):this.htEditor.deselectCell(),(0,s.setCaretPosition)(this.TEXTAREA,0,this.TEXTAREA.value.length),this.htEditor.updateSettings({width:this.getWidth(),height:this.getHeight()}),this.refreshDimensions()}close(){this.htEditor&&(this.htEditor.rootElement.style.display="none"),this.removeHooksByKey("beforeKeyDown"),super.close()}prepare(e,t,r,n,s,i){super.prepare(e,t,r,n,s,i);const a=this,l={startRows:0,startCols:0,minRows:0,minCols:0,className:"listbox",copyPaste:!1,autoColumnSize:!1,autoRowSize:!1,readOnly:!0,fillHandle:!1,autoWrapCol:!1,autoWrapRow:!1,ariaTags:!1,themeName:this.hot.getCurrentThemeName(),afterOnCellMouseDown(e,t){const r=this.getSourceData(t.row,t.col);void 0!==r&&a.setValue(r),a.hot.destroyEditor()},preventWheel:!0,layoutDirection:this.hot.isRtl()?"rtl":"ltr"};this.cellProperties.handsontable&&(0,o.extend)(l,i.handsontable),this.htOptions=l}beginEditing(e,t){const r=this.hot.getSettings().onBeginEditing;r&&!1===r()||super.beginEditing(e,t)}createElements(){super.createElements();const e=this.hot.rootDocument.createElement("DIV");e.className="handsontableEditor",this.TEXTAREA_PARENT.appendChild(e),this.htContainer=e,this.assignHooks()}finishEditing(e,t,r){if(this.htEditor&&this.htEditor.isListening()&&this.hot.listen(),this.htEditor&&this.htEditor.getSelectedLast()){const e=this.htEditor.getValue();void 0!==e&&this.setValue(e)}super.finishEditing(e,t,r)}getHeight(){return this.htEditor.view.getTableHeight()+1}getWidth(){return this.htEditor.view.getTableWidth()}assignHooks(){this.hot.addHook("afterDestroy",(()=>{this.htEditor&&this.htEditor.destroy()})),this.hot.addHook("afterSetTheme",((e,t)=>{t||this.htEditor.useTheme(e)}))}registerShortcuts(){const e=this.hot.getShortcutManager().getContext("editor");super.registerShortcuts();const t={group:l,relativeToGroup:a.EDITOR_EDIT_GROUP,position:"before"},r=(e,t)=>{const r=this.htEditor;if(void 0!==e&&(e<0||r.flipped&&e>r.countRows()-1?r.deselectCell():r.selectCell(e,0),r.getData().length))return t.preventDefault(),(0,i.stopImmediatePropagation)(t),this.hot.listen(),this.TEXTAREA.focus(),!1};e.addShortcuts([{keys:[["ArrowUp"]],callback:e=>{const t=this.htEditor;let n,s;return!t.getSelectedLast()&&t.flipped?n=t.countRows()-1:t.getSelectedLast()&&(t.flipped?(s=t.getSelectedLast()[0],n=Math.max(0,s-1)):(s=t.getSelectedLast()[0],n=s-1)),r(n,e)},preventDefault:!1},{keys:[["ArrowDown"]],callback:e=>{const t=this.htEditor;let n,s;if(t.getSelectedLast()||t.flipped){if(t.getSelectedLast())if(t.flipped)n=t.getSelectedLast()[0]+1;else if(!t.flipped){const e=t.countRows()-1;s=t.getSelectedLast()[0],n=Math.min(e,s+1)}}else n=0;return r(n,e)},preventDefault:!1}],t)}unregisterShortcuts(){super.unregisterShortcuts();this.hot.getShortcutManager().getContext("editor").removeShortcutsByGroup(l)}}t.HandsontableEditor=u},82518:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(37300);t.EDITOR_TYPE=n.EDITOR_TYPE,t.HandsontableEditor=n.HandsontableEditor},14417:(e,t,r)=>{"use strict";t.__esModule=!0,t.registerAllEditors=function(){(0,g.registerEditor)(s.BaseEditor),(0,g.registerEditor)(n.AutocompleteEditor),(0,g.registerEditor)(i.CheckboxEditor),(0,g.registerEditor)(o.DateEditor),(0,g.registerEditor)(a.DropdownEditor),(0,g.registerEditor)(l.HandsontableEditor),(0,g.registerEditor)(h.NumericEditor),(0,g.registerEditor)(u.PasswordEditor),(0,g.registerEditor)(c.SelectEditor),(0,g.registerEditor)(d.TextEditor),(0,g.registerEditor)(p.TimeEditor)};var n=r(10463);t.AutocompleteEditor=n.AutocompleteEditor,t.AUTOCOMPLETE_EDITOR=n.EDITOR_TYPE;var s=r(74854);t.BaseEditor=s.BaseEditor,t.BASE_EDITOR=s.EDITOR_TYPE;var i=r(12302);t.CheckboxEditor=i.CheckboxEditor,t.CHECKBOX_EDITOR=i.EDITOR_TYPE;var o=r(16339);t.DateEditor=o.DateEditor,t.DATE_EDITOR=o.EDITOR_TYPE;var a=r(51034);t.DropdownEditor=a.DropdownEditor,t.DROPDOWN_EDITOR=a.EDITOR_TYPE;var l=r(82518);t.HandsontableEditor=l.HandsontableEditor,t.HANDSONTABLE_EDITOR=l.EDITOR_TYPE;var h=r(82304);t.NumericEditor=h.NumericEditor,t.NUMERIC_EDITOR=h.EDITOR_TYPE;var u=r(14150);t.PasswordEditor=u.PasswordEditor,t.PASSWORD_EDITOR=u.EDITOR_TYPE;var c=r(63303);t.SelectEditor=c.SelectEditor,t.SELECT_EDITOR=c.EDITOR_TYPE;var d=r(66420);t.TextEditor=d.TextEditor,t.TEXT_EDITOR=d.EDITOR_TYPE;var p=r(35442);t.TimeEditor=p.TimeEditor,t.TIME_EDITOR=p.EDITOR_TYPE;var g=r(8266);t.registerEditor=g.registerEditor,t.RegisteredEditor=g.RegisteredEditor,t._getEditorInstance=g._getEditorInstance,t.getEditor=g.getEditor,t.getEditorInstance=g.getEditorInstance,t.getRegisteredEditorNames=g.getRegisteredEditorNames,t.getRegisteredEditors=g.getRegisteredEditors,t.hasEditor=g.hasEditor},82304:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(90146);t.EDITOR_TYPE=n.EDITOR_TYPE,t.NumericEditor=n.NumericEditor},90146:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(66420);const s=t.EDITOR_TYPE="numeric";class i extends n.TextEditor{static get EDITOR_TYPE(){return s}}t.NumericEditor=i},14150:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(93884);t.EDITOR_TYPE=n.EDITOR_TYPE,t.PasswordEditor=n.PasswordEditor},93884:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),i=r(66420),o=r(17207),a=r(62577);const l=t.EDITOR_TYPE="password";class h extends i.TextEditor{constructor(){super(...arguments),(0,s.default)(this,"autoResize",(0,o.createInputElementResizer)(this.hot.rootDocument,{textContent:e=>"•".repeat(e.value.length)}))}static get EDITOR_TYPE(){return l}createElements(){super.createElements(),this.TEXTAREA=this.hot.rootDocument.createElement("input"),this.TEXTAREA.setAttribute("type","password"),this.TEXTAREA.setAttribute("data-hot-input",""),this.TEXTAREA.className="handsontableInput",this.textareaStyle=this.TEXTAREA.style,this.textareaStyle.width=0,this.textareaStyle.height=0,(0,a.empty)(this.TEXTAREA_PARENT),this.TEXTAREA_PARENT.appendChild(this.TEXTAREA)}}t.PasswordEditor=h},8266:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.RegisteredEditor=d,t.getEditorInstance=t._getEditorInstance=function(e,t){let r;if("function"==typeof e)o.get(e)||p(null,e),r=o.get(e);else{if("string"!=typeof e)throw Error('Only strings and functions can be passed as "editor" parameter');r=l(e)}if(!r)throw Error(`No editor registered under name "${e}"`);return r.getInstance(t)},t.getEditor=function(e){if("function"==typeof e)return e;if(!h(e))throw Error(`No registered editor found under "${e}" name`);return l(e).getConstructor()},t.registerEditor=p,r(67834);var s=r(28197),i=n(r(28651));const o=new WeakMap,{register:a,getItem:l,hasItem:h,getNames:u,getValues:c}=(0,i.default)("editors");function d(e){const t={},r=e;this.getConstructor=function(){return e},this.getInstance=function(e){return e.guid in t||(t[e.guid]=new r(e)),t[e.guid]},s.Hooks.getSingleton().add("afterDestroy",(function(){t[this.guid]=null}))}function p(e,t){e&&"string"!=typeof e&&(e=(t=e).EDITOR_TYPE);const r=new d(t);"string"==typeof e&&a(e,r),o.set(t,r)}t.getRegisteredEditors=c,t.getRegisteredEditorNames=u,t.hasEditor=h},63303:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(70638);t.EDITOR_TYPE=n.EDITOR_TYPE,t.SelectEditor=n.SelectEditor},70638:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(74854),s=r(62577),i=r(25499),o=r(71120);const a="ht_editor_visible",l="selectEditor",h=t.EDITOR_TYPE="select";class u extends n.BaseEditor{static get EDITOR_TYPE(){return h}init(){this.selectWrapper=this.hot.rootDocument.createElement("div"),this.select=this.hot.rootDocument.createElement("select"),this.select.setAttribute("data-hot-input","true"),this.selectWrapper.style.display="none";const e=this.hot.rootDocument.createElement("DIV"),t=this.hot.getSettings().ariaTags;e.className="htAutocompleteArrow",t&&e.setAttribute(...(0,o.A11Y_HIDDEN)()),e.appendChild(this.hot.rootDocument.createTextNode(String.fromCharCode(9660))),(0,s.addClass)(this.selectWrapper,"htSelectEditor"),this.selectWrapper.appendChild(this.select),this.selectWrapper.insertBefore(e,this.selectWrapper.firstChild),this.hot.rootElement.appendChild(this.selectWrapper),this.registerHooks()}getValue(){return this.select.value}setValue(e){this.select.value=e}open(){this._opened=!0,this.refreshDimensions(),this.selectWrapper.style.display="";this.hot.getShortcutManager().setActiveContextName("editor"),this.registerShortcuts()}close(){this._opened=!1,this.selectWrapper.style.display="none",(0,s.hasClass)(this.selectWrapper,a)&&(0,s.removeClass)(this.selectWrapper,a),this.unregisterShortcuts(),this.clearHooks()}focus(){this.select.focus()}registerHooks(){this.addHook("afterScrollHorizontally",(()=>this.refreshDimensions())),this.addHook("afterScrollVertically",(()=>this.refreshDimensions())),this.addHook("afterColumnResize",(()=>this.refreshDimensions())),this.addHook("afterRowResize",(()=>this.refreshDimensions()))}prepare(e,t,r,n,o,a){super.prepare(e,t,r,n,o,a);const l=this.cellProperties.selectOptions;let h;h="function"==typeof l?this.prepareOptions(l(this.row,this.col,this.prop)):this.prepareOptions(l),(0,s.empty)(this.select),(0,i.objectEach)(h,((e,t)=>{const r=this.hot.rootDocument.createElement("OPTION");r.value=t,(0,s.fastInnerHTML)(r,e),this.select.appendChild(r)}))}prepareOptions(e){let t={};if(Array.isArray(e))for(let r=0,n=e.length;r<n;r++)t[e[r]]=e[r];else"object"==typeof e&&(t=e);return t}refreshValue(){const e=this.hot.getSourceDataAtCell(this.row,this.prop);this.originalValue=e,this.setValue(e),this.refreshDimensions()}refreshDimensions(){if(this.state!==n.EDITOR_STATE.EDITING)return;if(this.TD=this.getEditedCell(),!this.TD)return void this.close();const{top:e,start:t,width:r,height:i}=this.getEditedCellRect(),o=this.selectWrapper.style;o.height=`${i}px`,o.width=`${r}px`,o.top=`${e}px`,o[this.hot.isRtl()?"right":"left"]=`${t}px`,o.margin="0px",(0,s.addClass)(this.selectWrapper,a)}registerShortcuts(){const e=this.hot.getShortcutManager().getContext("editor"),t={group:l};this.isInFullEditMode()&&e.addShortcuts([{keys:[["ArrowUp"]],callback:()=>{const e=this.select.selectedIndex-1;e>=0&&(this.select[e].selected=!0)}},{keys:[["ArrowDown"]],callback:()=>{const e=this.select.selectedIndex+1;e<=this.select.length-1&&(this.select[e].selected=!0)}}],t)}unregisterShortcuts(){this.hot.getShortcutManager().getContext("editor").removeShortcutsByGroup(l)}}t.SelectEditor=u},96667:(e,t,r)=>{"use strict";t.__esModule=!0,t.updateCaretPosition=function(e,t){const r=(0,n.getCaretPosition)(t),s=t.value.split("\n");let i=r,o=0;for(let t=0;t<s.length;t++){const n=s[t];0!==t&&(o+=s[t-1].length+1);const a=o+n.length;if("home"===e?i=o:"end"===e&&(i=a),r<=a)break}(0,n.setCaretPosition)(t,i)};var n=r(62577)},66420:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(85856);t.EDITOR_TYPE=n.EDITOR_TYPE,t.TextEditor=n.TextEditor},85856:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0;var s=n(r(85707)),i=r(74854),o=n(r(3849)),a=r(25046),l=r(62577),h=r(22137),u=r(17207),c=r(70505),d=r(96667),p=r(71120);const g="ht_editor_hidden",f="textEditor",m=t.EDITOR_TYPE="text";class y extends i.BaseEditor{static get EDITOR_TYPE(){return m}constructor(e){super(e),(0,s.default)(this,"eventManager",new o.default(this)),(0,s.default)(this,"autoResize",(0,u.createInputElementResizer)(this.hot.rootDocument)),(0,s.default)(this,"TEXTAREA",void 0),(0,s.default)(this,"textareaStyle",void 0),(0,s.default)(this,"TEXTAREA_PARENT",void 0),(0,s.default)(this,"textareaParentStyle",void 0),(0,s.default)(this,"layerClass",void 0),this.eventManager=new o.default(this),this.createElements(),this.bindEvents(),this.hot.addHookOnce("afterDestroy",(()=>this.destroy()))}getValue(){return this.TEXTAREA.value}setValue(e){this.TEXTAREA.value=e}open(){this.refreshDimensions(),this.showEditableElement(),this.hot.getShortcutManager().setActiveContextName("editor"),this.registerShortcuts()}close(){this.autoResize.unObserve(),(0,l.isThisHotChild)(this.hot.rootDocument.activeElement,this.hot.rootElement)&&this.hot.listen(),this.hideEditableElement(),this.unregisterShortcuts()}prepare(e,t,r,n,s,o){const a=this.state;if(super.prepare(e,t,r,n,s,o),!o.readOnly){this.refreshDimensions(!0);const{allowInvalid:e}=o;e&&!this.isOpened()&&(this.TEXTAREA.value=""),a===i.EDITOR_STATE.FINISHED||this.isOpened()||this.hideEditableElement()}}beginEditing(e,t){this.state===i.EDITOR_STATE.VIRGIN&&(this.TEXTAREA.value="",super.beginEditing(e,t))}focus(){this.TEXTAREA.select(),(0,l.setCaretPosition)(this.TEXTAREA,this.TEXTAREA.value.length)}createElements(){const{rootDocument:e}=this.hot;this.TEXTAREA=e.createElement("TEXTAREA"),(0,l.setAttribute)(this.TEXTAREA,[["data-hot-input",""],(0,p.A11Y_TABINDEX)(-1)]),(0,l.addClass)(this.TEXTAREA,"handsontableInput"),this.textareaStyle=this.TEXTAREA.style,this.textareaStyle.width=0,this.textareaStyle.height=0,this.textareaStyle.overflowY="visible",this.TEXTAREA_PARENT=e.createElement("DIV"),(0,l.addClass)(this.TEXTAREA_PARENT,"handsontableInputHolder"),(0,l.hasClass)(this.TEXTAREA_PARENT,this.layerClass)&&(0,l.removeClass)(this.TEXTAREA_PARENT,this.layerClass),(0,l.addClass)(this.TEXTAREA_PARENT,g),this.textareaParentStyle=this.TEXTAREA_PARENT.style,this.TEXTAREA_PARENT.appendChild(this.TEXTAREA),this.hot.rootElement.appendChild(this.TEXTAREA_PARENT)}hideEditableElement(){(0,a.isEdge)()&&(this.textareaStyle.textIndent="-99999px"),this.textareaStyle.overflowY="visible",this.textareaParentStyle.opacity="0",this.textareaParentStyle.height="1px",(0,l.removeClass)(this.TEXTAREA_PARENT,this.layerClass),(0,l.addClass)(this.TEXTAREA_PARENT,g)}showEditableElement(){this.textareaParentStyle.height="",this.textareaParentStyle.overflow="",this.textareaParentStyle.position="",this.textareaParentStyle[this.hot.isRtl()?"left":"right"]="auto",this.textareaParentStyle.opacity="1",this.textareaStyle.textIndent="";const e=this.TEXTAREA_PARENT.childNodes;let t=!1;(0,h.rangeEach)(e.length-1,(r=>{const n=e[r];if((0,l.hasClass)(n,"handsontableEditor"))return t=!0,!1})),(0,l.hasClass)(this.TEXTAREA_PARENT,g)&&(0,l.removeClass)(this.TEXTAREA_PARENT,g),t?(this.layerClass="ht_editor_visible",(0,l.addClass)(this.TEXTAREA_PARENT,this.layerClass)):(this.layerClass=this.getEditedCellsLayerClass(),(0,l.addClass)(this.TEXTAREA_PARENT,this.layerClass))}refreshValue(){const e=this.hot.toPhysicalRow(this.row),t=this.hot.getSourceDataAtCell(e,this.col);this.originalValue=t,this.setValue(t),this.refreshDimensions()}refreshDimensions(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];if(this.state!==i.EDITOR_STATE.EDITING&&!e)return;if(this.TD=this.getEditedCell(),!this.TD)return void(e||this.close());const{top:t,start:r,width:n,maxWidth:s,height:o,maxHeight:a}=this.getEditedCellRect();this.textareaParentStyle.top=`${t}px`,this.textareaParentStyle[this.hot.isRtl()?"right":"left"]=`${r}px`,this.showEditableElement();const l=this.hot.rootWindow.getComputedStyle(this.TD);this.TEXTAREA.style.fontSize=l.fontSize,this.TEXTAREA.style.fontFamily=l.fontFamily,this.TEXTAREA.style.backgroundColor=this.TD.style.backgroundColor,this.autoResize.init(this.TEXTAREA,{minWidth:Math.min(n,s),minHeight:Math.min(o,a),maxWidth:s,maxHeight:a},!0)}bindEvents(){(0,a.isIOS)()&&this.eventManager.addEventListener(this.TEXTAREA,"focusout",(()=>this.finishEditing(!1))),this.addHook("afterScrollHorizontally",(()=>this.refreshDimensions())),this.addHook("afterScrollVertically",(()=>this.refreshDimensions())),this.addHook("afterColumnResize",(()=>{this.refreshDimensions(),this.state===i.EDITOR_STATE.EDITING&&this.focus()})),this.addHook("afterRowResize",(()=>{this.refreshDimensions(),this.state===i.EDITOR_STATE.EDITING&&this.focus()}))}allowKeyEventPropagation(){}destroy(){this.eventManager.destroy(),this.clearHooks()}registerShortcuts(){const e=this.hot.getShortcutManager().getContext("editor"),t={runOnlyIf:()=>(0,c.isDefined)(this.hot.getSelected()),group:f},r=()=>{this.hot.rootDocument.execCommand("insertText",!1,"\n")};e.addShortcuts([{keys:[["Control","Enter"]],callback:()=>(r(),!1),runOnlyIf:e=>!this.hot.selection.isMultiple()&&!e.altKey},{keys:[["Meta","Enter"]],callback:()=>(r(),!1),runOnlyIf:()=>!this.hot.selection.isMultiple()},{keys:[["Alt","Enter"]],callback:()=>(r(),!1)},{keys:[["Home"]],callback:(e,t)=>{let[r]=t;(0,d.updateCaretPosition)(r,this.TEXTAREA)}},{keys:[["End"]],callback:(e,t)=>{let[r]=t;(0,d.updateCaretPosition)(r,this.TEXTAREA)}}],t)}unregisterShortcuts(){this.hot.getShortcutManager().getContext("editor").removeShortcutsByGroup(f)}}t.TextEditor=y},35442:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(55736);t.EDITOR_TYPE=n.EDITOR_TYPE,t.TimeEditor=n.TimeEditor},55736:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(66420);const s=t.EDITOR_TYPE="time";class i extends n.TextEditor{static get EDITOR_TYPE(){return s}prepare(e,t,r,n,s,i){super.prepare(e,t,r,n,s,i),this.TEXTAREA.dir="ltr"}}t.TimeEditor=i},3849:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.getListenersCounter=function(){return o},r(15724);var s=n(r(85707)),i=r(77661);let o=0;t.default=class{constructor(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;(0,s.default)(this,"context",void 0),this.context=e||this,this.context.eventListeners||(this.context.eventListeners=[])}addEventListener(e,t,r){let n=arguments.length>3&&void 0!==arguments[3]&&arguments[3];function s(e){r.call(this,function(e){const t=e.stopImmediatePropagation;return e.stopImmediatePropagation=function(){t.apply(this),(0,i.stopImmediatePropagation)(this)},e}(e))}return this.context.eventListeners.push({element:e,event:t,callback:r,callbackProxy:s,options:n,eventManager:this}),e.addEventListener(t,s,n),o+=1,()=>{this.removeEventListener(e,t,r)}}removeEventListener(e,t,r){let n,s=arguments.length>3&&void 0!==arguments[3]&&arguments[3],i=this.context.eventListeners.length;for(;i;)if(i-=1,n=this.context.eventListeners[i],n.event===t&&n.element===e){if(r&&r!==n.callback)continue;if(s&&n.eventManager!==this)continue;this.context.eventListeners.splice(i,1),n.element.removeEventListener(n.event,n.callbackProxy,n.options),o-=1}}clearEvents(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];if(!this.context)return;let t=this.context.eventListeners.length;for(;t;){t-=1;const r=this.context.eventListeners[t];e&&r.eventManager!==this||(this.context.eventListeners.splice(t,1),r.element.removeEventListener(r.event,r.callbackProxy,r.options),o-=1)}}clear(){this.clearEvents()}destroy(){this.clearEvents(),this.context=null}destroyWithOwnEventsOnly(){this.clearEvents(!0),this.context=null}fireEvent(e,t){let r=e.document,n=e;r||(r=e.ownerDocument?e.ownerDocument:e,n=r.defaultView);const s={bubbles:!0,cancelable:"mousemove"!==t,view:n,detail:0,screenX:0,screenY:0,clientX:1,clientY:1,ctrlKey:!1,altKey:!1,shiftKey:!1,metaKey:!1,button:0,relatedTarget:void 0};let i;r.createEvent?(i=r.createEvent("MouseEvents"),i.initMouseEvent(t,s.bubbles,s.cancelable,s.view,s.detail,s.screenX,s.screenY,s.clientX,s.clientY,s.ctrlKey,s.altKey,s.shiftKey,s.metaKey,s.button,s.relatedTarget||r.body.parentNode)):i=r.createEventObject(),e.dispatchEvent?e.dispatchEvent(i):e.fireEvent(`on${t}`,i)}}},19053:(e,t,r)=>{"use strict";t.__esModule=!0,r(67834);var n=r(14859),s=r(62577),i=r(89804);function o(e,t,r){a(e,t),t.set(e,r)}function a(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function l(e,t){return e.get(u(e,t))}function h(e,t,r){return e.set(u(e,t),r),r}function u(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}const c=Object.freeze({CELL:"cell",MIXED:"mixed"});var d=new WeakMap,p=new WeakMap,g=new WeakMap,f=new WeakMap,m=new WeakMap,y=new WeakSet;function E(e){var t;const r=null===(t=l(d,this).getSelectedRangeLast())||void 0===t?void 0:t.highlight;if(!r||!l(d,this).selection.isCellVisible(r))return void e(null);const n=l(d,this).getCell(r.row,r.col,!0);null===n?l(d,this).addHookOnce("afterScroll",(()=>{e(l(d,this).getCell(r.row,r.col,!0))})):e(n)}function w(){u(y,this,E).call(this,(e=>{const{activeElement:t}=l(d,this).rootDocument;t&&(0,s.isOutsideInput)(t)&&t.blur(),this.focusOnHighlightedCell(e)}))}function C(){u(y,this,E).call(this,(e=>{this.getFocusMode()===c.MIXED&&"TD"===e.nodeName&&this.refocusToEditorTextarea()}))}function v(e){"boolean"==typeof e.imeFastEdit&&this.setFocusMode(e.imeFastEdit?c.MIXED:c.CELL)}t.FocusManager=class{constructor(e){var t,r,n=this;a(t=this,r=y),r.add(t),o(this,d,void 0),o(this,p,void 0),o(this,g,1),o(this,f,null),o(this,m,new Map);const s=e.getSettings();h(d,this,e),h(p,this,s.imeFastEdit?c.MIXED:c.CELL),l(d,this).addHook("afterUpdateSettings",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return u(y,n,v).call(n,...t)})),l(d,this).addHook("afterSelection",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return u(y,n,w).call(n,...t)})),l(d,this).addHook("afterSelectionFocusSet",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return u(y,n,w).call(n,...t)})),l(d,this).addHook("afterSelectionEnd",(function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return u(y,n,C).call(n,...t)}))}getFocusMode(){return l(p,this)}setFocusMode(e){Object.values(c).includes(e)?h(p,this,e):(0,n.warn)(`"${e}" is not a valid focus mode.`)}getRefocusDelay(){return l(g,this)}setRefocusDelay(e){h(g,this,e)}setRefocusElementGetter(e){h(f,this,e)}getRefocusElement(){var e;return"function"==typeof l(f,this)?l(f,this).call(this):null===(e=l(d,this).getActiveEditor())||void 0===e?void 0:e.TEXTAREA}focusOnHighlightedCell(e){const t=e=>{var t,r;const n=null===(t=l(d,this).getSelectedRangeLast())||void 0===t?void 0:t.highlight;if(!n)return;let s=l(d,this).runHooks("modifyFocusedElement",n.row,n.col,e);s instanceof HTMLElement||(s=e),!s||null!==(r=l(d,this).getActiveEditor())&&void 0!==r&&r.isOpened()||s.focus({preventScroll:!0})};e?t(e):u(y,this,E).call(this,(e=>t(e)))}refocusToEditorTextarea(){var e;let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:l(g,this);!l(d,this).getSettings().imeFastEdit||null!==(e=l(d,this).getActiveEditor())&&void 0!==e&&e.isOpened()||(l(m,this).has(t)||l(m,this).set(t,(0,i.debounce)((()=>{var e;null===(e=this.getRefocusElement())||void 0===e||e.select()}),t)),l(m,this).get(t)())}}},71120:(e,t)=>{"use strict";t.__esModule=!0;t.A11Y_TABINDEX=e=>["tabindex",e];t.A11Y_TREEGRID=()=>["role","treegrid"];t.A11Y_PRESENTATION=()=>["role","presentation"];t.A11Y_GRIDCELL=()=>["role","gridcell"];t.A11Y_ROWHEADER=()=>["role","rowheader"];t.A11Y_ROWGROUP=()=>["role","rowgroup"];t.A11Y_COLUMNHEADER=()=>["role","columnheader"];t.A11Y_ROW=()=>["role","row"];t.A11Y_MENU=()=>["role","menu"];t.A11Y_MENU_ITEM=()=>["role","menuitem"];t.A11Y_MENU_ITEM_CHECKBOX=()=>["role","menuitemcheckbox"];t.A11Y_COMBOBOX=()=>["role","combobox"];t.A11Y_LISTBOX=()=>["role","listbox"];t.A11Y_OPTION=()=>["role","option"];t.A11Y_CHECKBOX=()=>["role","checkbox"];t.A11Y_SCOPE_COL=()=>["scope","col"];t.A11Y_SCOPE_ROW=()=>["scope","row"];t.A11Y_TEXT=()=>["type","text"];t.A11Y_LABEL=e=>["aria-label",e];t.A11Y_HIDDEN=()=>["aria-hidden","true"];t.A11Y_DISABLED=()=>["aria-disabled","true"];t.A11Y_MULTISELECTABLE=()=>["aria-multiselectable","true"];t.A11Y_HASPOPUP=e=>["aria-haspopup",e];t.A11Y_ROWCOUNT=e=>["aria-rowcount",e];t.A11Y_COLCOUNT=e=>["aria-colcount",e];t.A11Y_ROWINDEX=e=>["aria-rowindex",e];t.A11Y_COLINDEX=e=>["aria-colindex",e];t.A11Y_EXPANDED=e=>["aria-expanded",e];t.A11Y_SORT=e=>["aria-sort",e];t.A11Y_READONLY=()=>["aria-readonly","true"];t.A11Y_INVALID=()=>["aria-invalid","true"];t.A11Y_CHECKED=e=>["aria-checked",e];t.A11Y_SELECTED=()=>["aria-selected","true"];t.A11Y_AUTOCOMPLETE=()=>["aria-autocomplete","list"];t.A11Y_CONTROLS=e=>["aria-controls",e];t.A11Y_ACTIVEDESCENDANT=e=>["aria-activedescendant",e];t.A11Y_LIVE=e=>["aria-live",e];t.A11Y_RELEVANT=e=>["aria-relevant",e];t.A11Y_SETSIZE=e=>["aria-setsize",e];t.A11Y_POSINSET=e=>["aria-posinset",e]},10587:(e,t,r)=>{"use strict";function n(e,t,r,n){let s=-1,i=e,o=r;Array.isArray(e)||(i=Array.from(e));const a=i.length;for(n&&a&&(s+=1,o=i[s]),s+=1;s<a;)o=t(o,i[s],s,i),s+=1;return o}function s(e,t){let r=0,n=e;Array.isArray(e)||(n=Array.from(e));const s=n.length;for(;r<s&&!1!==t(n[r],r,n);)r+=1;return e}function i(e){return n(e,((e,t)=>e+t),0)}t.__esModule=!0,t.arrayAvg=function(e){if(!e.length)return 0;return i(e)/e.length},t.arrayEach=s,t.arrayFilter=function(e,t){let r=0,n=e;Array.isArray(e)||(n=Array.from(e));const s=n.length,i=[];let o=-1;for(;r<s;){const e=n[r];t(e,r,n)&&(o+=1,i[o]=e),r+=1}return i},t.arrayFlatten=function e(t){return n(t,((t,r)=>t.concat(Array.isArray(r)?e(r):r)),[])},t.arrayMap=function(e,t){let r=0,n=e;Array.isArray(e)||(n=Array.from(e));const s=n.length,i=[];let o=-1;for(;r<s;){const e=n[r];o+=1,i[o]=t(e,r,n),r+=1}return i},t.arrayMax=function(e){return n(e,((e,t)=>e>t?e:t),Array.isArray(e)?e[0]:void 0)},t.arrayMin=function(e){return n(e,((e,t)=>e<t?e:t),Array.isArray(e)?e[0]:void 0)},t.arrayReduce=n,t.arraySum=i,t.arrayUnique=function(e){const t=[];return s(e,(e=>{-1===t.indexOf(e)&&t.push(e)})),t},t.extendArray=function(e,t){const r=t.length;let n=0;for(;n<r;)e.push(t[n]),n+=1},t.getDifferenceOfArrays=function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];const[n,...i]=[...t];let o=n;return s(i,(e=>{o=o.filter((t=>!e.includes(t)))})),o},t.getIntersectionOfArrays=function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];const[n,...i]=[...t];let o=n;return s(i,(e=>{o=o.filter((t=>e.includes(t)))})),o},t.getUnionOfArrays=function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];const[n,...i]=[...t],o=new Set(n);return s(i,(e=>{s(e,(e=>{o.has(e)||o.add(e)}))})),Array.from(o)},t.pivot=function(e){const t=[];if(!e||0===e.length||!e[0]||0===e[0].length)return t;const r=e.length,n=e[0].length;for(let s=0;s<r;s++)for(let r=0;r<n;r++)t[r]||(t[r]=[]),t[r][s]=e[s][r];return t},t.stringToArray=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:" ";return e.split(t)},t.to2dArray=function(e){const t=e.length;let r=0;for(;r<t;)e[r]=[e[r]],r+=1},r(15724),r(71336),r(41558),r(17663),r(68630),r(79645),r(89858),r(8620),r(14846),r(27458)},25046:(e,t,r)=>{"use strict";t.__esModule=!0,t.isChrome=function(){return o.chrome.value},t.isChromeWebKit=function(){return o.chromeWebKit.value},t.isEdge=function(){return o.edge.value},t.isEdgeWebKit=function(){return o.edgeWebKit.value},t.isFirefox=function(){return o.firefox.value},t.isFirefoxWebKit=function(){return o.firefoxWebKit.value},t.isIOS=function(){return a.ios.value},t.isIpadOS=function(){let{maxTouchPoints:e}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:navigator;return e>2&&a.mac.value},t.isLinuxOS=function(){return a.linux.value},t.isMacOS=function(){return a.mac.value},t.isMobileBrowser=function(){return o.mobile.value},t.isSafari=function(){return o.safari.value},t.isWindowsOS=function(){return a.win.value},t.setBrowserMeta=l,t.setPlatformMeta=h;var n=r(25499),s=r(85992);const i=e=>{const t={value:!1,test:(r,n)=>{t.value=e(r,n)}};return t},o={chrome:i(((e,t)=>/Chrome/.test(e)&&/Google/.test(t))),chromeWebKit:i((e=>/CriOS/.test(e))),edge:i((e=>/Edge/.test(e))),edgeWebKit:i((e=>/EdgiOS/.test(e))),firefox:i((e=>/Firefox/.test(e))),firefoxWebKit:i((e=>/FxiOS/.test(e))),mobile:i((e=>/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(e))),safari:i(((e,t)=>/Safari/.test(e)&&/Apple Computer/.test(t)))},a={mac:i((e=>/^Mac/.test(e))),win:i((e=>/^Win/.test(e))),linux:i((e=>/^Linux/.test(e))),ios:i((e=>/iPhone|iPad|iPod/i.test(e)))};function l(){let{userAgent:e=navigator.userAgent,vendor:t=navigator.vendor}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};(0,n.objectEach)(o,(r=>{let{test:n}=r;n(e,t)}))}function h(){let{platform:e=navigator.platform}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};(0,n.objectEach)(a,(t=>{let{test:r}=t;r(e)}))}(0,s.isCSR)()&&(l(),h())},14859:(e,t,r)=>{"use strict";t.__esModule=!0,t.error=function(){(0,n.isDefined)(console)&&console.error(...arguments)},t.info=function(){(0,n.isDefined)(console)&&console.info(...arguments)},t.log=function(){(0,n.isDefined)(console)&&console.log(...arguments)},t.warn=function(){(0,n.isDefined)(console)&&console.warn(...arguments)};var n=r(70505)},87124:(e,t,r)=>{"use strict";t.__esModule=!0,t.countFirstRowKeys=function(e){let t=0;Array.isArray(e)&&(e[0]&&Array.isArray(e[0])?t=e[0].length:e[0]&&(0,n.isObject)(e[0])&&(t=(0,n.deepObjectSize)(e[0])));return t},t.createEmptySpreadsheetData=function(e,t){const r=[];let n;for(let s=0;s<e;s++){n=[];for(let e=0;e<t;e++)n.push("");r.push(n)}return r},t.createSpreadsheetData=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:100,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:4;const r=[];let n,s;for(n=0;n<e;n++){const e=[];for(s=0;s<t;s++)e.push(o(s)+(n+1));r.push(e)}return r},t.createSpreadsheetObjectData=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:100,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:4;const r=[];let n,s;for(n=0;n<e;n++){const e={};for(s=0;s<t;s++)e[`prop${s}`]=o(s)+(n+1);r.push(e)}return r},t.dataRowToChangesArray=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,r=e;const n=[];Array.isArray(e)&&Array.isArray(e[0])||(r=[e]);return r.forEach(((e,r)=>{Array.isArray(e)?e.forEach(((e,s)=>{n.push([r+t,s,e])})):Object.keys(e).forEach((s=>{n.push([r+t,s,e[s]])}))})),n},t.isArrayOfArrays=function(e){return!!(Array.isArray(e)&&e.length&&e.every((e=>Array.isArray(e))))},t.isArrayOfObjects=function(e){return!!(Array.isArray(e)&&e.length&&e.every((e=>"object"==typeof e&&!Array.isArray(e)&&null!==e)))},t.spreadsheetColumnIndex=function(e){let t=0;if(e)for(let r=0,n=e.length-1;r<e.length;r+=1,n-=1)t+=i**n*(s.indexOf(e[r])+1);return t-=1,t},t.spreadsheetColumnLabel=o,r(15724),r(14846),r(63333),r(69655);var n=r(25499);const s="ABCDEFGHIJKLMNOPQRSTUVWXYZ",i=s.length;function o(e){let t,r=e+1,n="";for(;r>0;)t=(r-1)%i,n=String.fromCharCode(65+t)+n,r=parseInt((r-t)/i,10);return n}},95976:(e,t)=>{"use strict";t.__esModule=!0,t.getNormalizedDate=function(e){const t=new Date(e);if(!isNaN(new Date(`${e}T00:00`).getDate()))return new Date(t.getTime()+6e4*t.getTimezoneOffset());return t}},62577:(e,t,r)=>{"use strict";t.__esModule=!0,t.addClass=h,t.addEvent=function(e,t,r){e.addEventListener(t,r,!1)},t.clearTextSelection=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:window;e.getSelection&&(e.getSelection().empty?e.getSelection().empty():e.getSelection().removeAllRanges&&e.getSelection().removeAllRanges())},t.closest=o,t.closestDown=function(e,t,r){const n=[];let s=e;for(;s&&(s=o(s,t,r),s&&(!r||r.contains(s)));)n.push(s),s=s.host&&s.nodeType===Node.DOCUMENT_FRAGMENT_NODE?s.host:s.parentNode;const i=n.length;return i?n[i-1]:null},t.empty=d,t.fastInnerHTML=function(e,t){let r=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];p.test(t)?e.innerHTML=r?(0,n.sanitize)(t):t:g(e,t)},t.fastInnerText=g,t.findFirstParentWithClass=function(e,t){const r={element:void 0,classNames:[]};let n=e;for(;null!==n&&n!==e.ownerDocument.documentElement&&!r.element;){if("string"==typeof t&&n.classList.contains(t))r.element=n,r.classNames.push(t);else if(t instanceof RegExp){const e=Array.from(n.classList).filter((e=>t.test(e)));e.length&&(r.element=n,r.classNames.push(...e))}n=n.parentElement}return r},t.getCaretPosition=function(e){if(e.selectionStart)return e.selectionStart;return 0},t.getCssTransform=function(e){let t;if(e.style.transform&&""!==(t=e.style.transform))return["transform",t];return-1},t.getFrameElement=i,t.getMaximumScrollLeft=function(e){return e.scrollWidth-e.clientWidth},t.getMaximumScrollTop=function(e){return e.scrollHeight-e.clientHeight},t.getParent=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,r=-1,n=null,s=e;for(;null!==s;){if(r===t){n=s;break}s.host&&s.nodeType===Node.DOCUMENT_FRAGMENT_NODE?s=s.host:(r+=1,s=s.parentNode)}return n},t.getParentWindow=function(e){return i(e)&&e.parent},t.getScrollLeft=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:window;if(e===t)return m(t);return e.scrollLeft},t.getScrollTop=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:window;if(e===t)return f(t);return e.scrollTop},t.getScrollableElement=function(e){let t=e.ownerDocument,r=t?t.defaultView:void 0;t||(t=e.document?e.document:e,r=t.defaultView);const n=["auto","scroll"];let s=e.parentNode;for(;s&&s.style&&t.body!==s;){let{overflow:e,overflowX:t,overflowY:i}=s.style;if([e,t,i].includes("scroll"))return s;if(({overflow:e,overflowX:t,overflowY:i}=r.getComputedStyle(s)),n.includes(e)||n.includes(t)||n.includes(i))return s;if(s.clientHeight<=s.scrollHeight+1&&(n.includes(i)||n.includes(e)))return s;if(s.clientWidth<=s.scrollWidth+1&&(n.includes(t)||n.includes(e)))return s;s=s.parentNode}return r},t.getScrollbarWidth=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:document;void 0===y&&(y=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:document;const t=e.createElement("div");t.style.height="200px",t.style.width="100%";const r=e.createElement("div");r.style.boxSizing="content-box",r.style.height="150px",r.style.left="0px",r.style.overflow="hidden",r.style.position="absolute",r.style.top="0px",r.style.width="200px",r.style.visibility="hidden",r.appendChild(t),(e.body||e.documentElement).appendChild(r);const n=t.offsetWidth;r.style.overflow="scroll";let s=t.offsetWidth;n===s&&(s=r.clientWidth);return(e.body||e.documentElement).removeChild(r),n-s}(e));return y},t.getSelectionEndPosition=function(e){if(e.selectionEnd)return e.selectionEnd;return 0},t.getSelectionText=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:window;const t=e.document;let r="";e.getSelection?r=e.getSelection().toString():t.selection&&"Control"!==t.selection.type&&(r=t.selection.createRange().text);return r},t.getStyle=function(e,t){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:window;if(!e)return;if(e===r)return"width"===t?`${r.innerWidth}px`:"height"===t?`${r.innerHeight}px`:void 0;const n=e.style[t];if(""!==n&&void 0!==n)return n;const s=r.getComputedStyle(e);if(""!==s[t]&&void 0!==s[t])return s[t]},t.getTrimmingContainer=function(e){const t=e.ownerDocument,r=t.defaultView;let n=e.parentNode;for(;n&&n.style&&t.body!==n;){if("visible"!==n.style.overflow&&""!==n.style.overflow)return n;const e=r.getComputedStyle(n),t=["scroll","hidden","auto"],s=e.getPropertyValue("overflow"),i=e.getPropertyValue("overflow-y"),o=e.getPropertyValue("overflow-x");if(t.includes(s)||t.includes(i)||t.includes(o))return n;n=n.parentNode}return r},t.getWindowScrollLeft=m,t.getWindowScrollTop=f,t.hasAccessToParentWindow=function(e){return!!Object.getPrototypeOf(e.parent)},t.hasClass=function(e,t){if(void 0===e.classList||"string"!=typeof t||""===t)return!1;return e.classList.contains(t)},t.hasHorizontalScrollbar=function(e){return e.offsetHeight!==e.clientHeight},t.hasVerticalScrollbar=function(e){return e.offsetWidth!==e.clientWidth},t.index=function(e){let t=0,r=e;if(r.previousSibling)for(;r=r.previousSibling;)t+=1;return t},t.innerHeight=function(e){return e.clientHeight||e.innerHeight},t.innerWidth=function(e){return e.clientWidth||e.innerWidth},t.isChildOf=function(e,t){let r=e.parentNode,n=[];"string"==typeof t?n=e.defaultView?Array.prototype.slice.call(e.querySelectorAll(t),0):Array.prototype.slice.call(e.ownerDocument.querySelectorAll(t),0):n.push(t);for(;null!==r;){if(n.indexOf(r)>-1)return!0;r=r.parentNode}return!1},t.isDetached=function(e){return!e.parentNode},t.isInput=E,t.isOutsideInput=w,t.isThisHotChild=function(e,t){const r=e.closest(".handsontable");return!!r&&(r.parentNode===t||r===t)},t.isVisible=function e(t){const r=t.ownerDocument.documentElement,n=t.ownerDocument.defaultView;let s=t;for(;s!==r;){if(null===s)return!1;if(s.nodeType===Node.DOCUMENT_FRAGMENT_NODE){if(s.host){if(s.host.impl)return e(s.host.impl);if(s.host)return e(s.host);throw new Error("Lost in Web Components world")}return!1}if("none"===n.getComputedStyle(s).display)return!1;s=s.parentNode}return!0},t.makeElementContentEditableAndSelectItsContent=C,t.matchesCSSRules=function(e,t){const{selectorText:r}=t;let n=!1;t.type===CSSRule.STYLE_RULE&&r&&(e.msMatchesSelector?n=e.msMatchesSelector(r):e.matches&&(n=e.matches(r)));return n},t.observeVisibilityChangeOnce=function(e,t){new IntersectionObserver(((r,n)=>{r.forEach((r=>{r.isIntersecting&&null!==e.offsetParent&&(t(),n.unobserve(e))}))}),{root:e.ownerDocument.body}).observe(e)},t.offset=function(e){const t=e.ownerDocument,r=t.defaultView,n=t.documentElement;let s,i,o,a=e;s=a.offsetLeft,i=a.offsetTop,o=a;for(;(a=a.offsetParent)&&a!==t.body&&"offsetLeft"in a;)s+=a.offsetLeft,i+=a.offsetTop,o=a;o&&"fixed"===o.style.position&&(s+=r.pageXOffset||n.scrollLeft,i+=r.pageYOffset||n.scrollTop);return{left:s,top:i}},t.outerHeight=function(e){return e.offsetHeight},t.outerWidth=function(e){return e.offsetWidth},t.overlayContainsElement=function(e,t,r){const n=r.parentElement.querySelector(`.ht_clone_${e}`);return n?n.contains(t):null},t.removeAttribute=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];"string"==typeof t?t=t.split(" "):t instanceof RegExp&&(t=[t]);const{regexFree:r,regexes:n}=l(t,!0);r.forEach((t=>{""!==t&&e.removeAttribute(t)})),n.forEach((t=>{e.getAttributeNames().forEach((r=>{t.test(r)&&e.removeAttribute(r)}))}))},t.removeClass=u,t.removeContentEditableFromElementAndDeselect=v,t.removeEvent=function(e,t,r){e.removeEventListener(t,r,!1)},t.removeTextNodes=function e(t){if(3===t.nodeType)t.parentNode.removeChild(t);else if(["TABLE","THEAD","TBODY","TFOOT","TR"].indexOf(t.nodeName)>-1){const r=t.childNodes;for(let t=r.length-1;t>=0;t--)e(r[t])}},t.resetCssTransform=function(e){e.style.transform&&""!==e.style.transform&&(e.style.transform="")},t.runWithSelectedContendEditableElement=function(e,t){let r=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];C(e,r),t(),v(e,r)},t.selectElementIfAllowed=function(e){w(e.ownerDocument.activeElement)||e.select()},t.setAttribute=c,t.setCaretPosition=function(e,t,r){void 0===r&&(r=t);if(e.setSelectionRange){e.focus();try{e.setSelectionRange(t,r)}catch(n){const s=e.parentNode,i=s.style.display;s.style.display="block",e.setSelectionRange(t,r),s.style.display=i}}},t.setOverlayPosition=function(e,t,r){e.style.transform=`translate3d(${t},${r},0)`},r(67834),r(15724),r(14846),r(27458),r(69655);var n=r(5893),s=r(71120);function i(e){return Object.getPrototypeOf(e.parent)&&e.frameElement}function o(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],r=arguments.length>2?arguments[2]:void 0;const{ELEMENT_NODE:n,DOCUMENT_FRAGMENT_NODE:s}=Node;let i=e;for(;null!=i&&i!==r;){const{nodeType:e,nodeName:r}=i;if(e===n&&(t.includes(r)||t.includes(i)))return i;const{host:o}=i;i=o&&e===s?o:i.parentNode}return null}function a(e){return e&&e.length?e.filter((e=>!!e)):[]}function l(e,t){if(!e||!e.length)return t?{regexFree:[],regexes:[]}:[];const r=[],n=[];return n.push(...e.filter((e=>{const n=e instanceof RegExp;return n&&t&&r.push(e),!n}))),t?{regexFree:n,regexes:r}:n}function h(e,t){"string"==typeof t&&(t=t.split(" ")),(t=a(t)).length>0&&e.classList.add(...t)}function u(e,t){"string"==typeof t?t=t.split(" "):t instanceof RegExp&&(t=[t]);let{regexFree:r,regexes:n}=l(t,!0);r=a(r),r.length>0&&e.classList.remove(...r),n.forEach((t=>{e.classList.forEach((r=>{t.test(r)&&e.classList.remove(r)}))}))}function c(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],r=arguments.length>2?arguments[2]:void 0;Array.isArray(t)||(t=[[t,r]]),t.forEach((t=>{Array.isArray(t)&&""!==t[0]&&e.setAttribute(...t)}))}function d(e){let t;for(;t=e.lastChild;)e.removeChild(t)}const p=t.HTML_CHARACTERS=/(<(.*)>|&(.*);)/;function g(e,t){const r=e.firstChild;r&&3===r.nodeType&&null===r.nextSibling?r.textContent=t:(d(e),e.appendChild(e.ownerDocument.createTextNode(t)))}function f(){return(arguments.length>0&&void 0!==arguments[0]?arguments[0]:window).scrollY}function m(){return(arguments.length>0&&void 0!==arguments[0]?arguments[0]:window).scrollX}let y;function E(e){return e&&(["INPUT","SELECT","TEXTAREA"].indexOf(e.nodeName)>-1||"true"===e.contentEditable)}function w(e){return E(e)&&!1===e.hasAttribute("data-hot-input")}function C(e){let t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1],r=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];const n=e.ownerDocument,i=n.createRange(),o=n.defaultView.getSelection();c(e,"contenteditable",!0),r&&c(e,...(0,s.A11Y_HIDDEN)()),t&&h(e,"invisibleSelection"),i.selectNodeContents(e),o.removeAllRanges(),o.addRange(i)}function v(e){let t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];const r=e.ownerDocument.defaultView.getSelection();e.hasAttribute("aria-hidden")&&e.removeAttribute("aria-hidden"),r.removeAllRanges(),t&&u(e,"invisibleSelection"),e.removeAttribute("contenteditable")}},77661:(e,t)=>{"use strict";t.__esModule=!0,t.isImmediatePropagationStopped=function(e){return!1===e.isImmediatePropagationEnabled},t.isLeftClick=function(e){return 0===e.button},t.isRightClick=function(e){return 2===e.button},t.isTouchEvent=function(e){return e instanceof TouchEvent},t.offsetRelativeTo=function(e,t){const r={x:e.offsetX,y:e.offsetY};let n=e.target;if(!(t instanceof HTMLElement)||n!==t&&n.contains(t))return r;for(;n!==t;)r.x+=n.offsetLeft,r.y+=n.offsetTop,n=n.offsetParent;return r},t.stopImmediatePropagation=function(e){e.isImmediatePropagationEnabled=!1,e.cancelBubble=!0}},85992:(e,t)=>{"use strict";let r;t.__esModule=!0,t.cancelAnimationFrame=function(e){window.cancelAnimationFrame(e)},t.getComparisonFunction=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(r)return r;r="object"==typeof Intl?new Intl.Collator(e,t).compare:"function"==typeof String.prototype.localeCompare?(e,t)=>`${e}`.localeCompare(t):(e,t)=>e===t?0:e>t?-1:1;return r},t.isCSR=function(){return"undefined"!=typeof window},t.isTouchSupported=function(){return"ontouchstart"in window},t.requestAnimationFrame=function(e){return window.requestAnimationFrame(e)}},89804:(e,t,r)=>{"use strict";t.__esModule=!0,t.curry=function(e){const t=e.length;return function r(n){return function(){for(var s=arguments.length,i=new Array(s),o=0;o<s;o++)i[o]=arguments[o];const a=n.concat(i);let l;return l=a.length>=t?e.apply(this,a):r(a),l}}([])},t.curryRight=function(e){const t=e.length;return function r(n){return function(){for(var s=arguments.length,i=new Array(s),o=0;o<s;o++)i[o]=arguments[o];const a=n.concat(i.reverse());let l;return l=a.length>=t?e.apply(this,a):r(a),l}}([])},t.debounce=function(e){let t,r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:200,n=null;return function(){for(var s=arguments.length,i=new Array(s),o=0;o<s;o++)i[o]=arguments[o];return n&&clearTimeout(n),n=setTimeout((()=>{t=e.apply(this,i)}),r),t}},t.fastCall=function(e,t,r,n,i,o,a,l){if((0,s.isDefined)(l))return e.call(t,r,n,i,o,a,l);if((0,s.isDefined)(a))return e.call(t,r,n,i,o,a);if((0,s.isDefined)(o))return e.call(t,r,n,i,o);if((0,s.isDefined)(i))return e.call(t,r,n,i);if((0,s.isDefined)(n))return e.call(t,r,n);if((0,s.isDefined)(r))return e.call(t,r);return e.call(t)},t.isFunction=function(e){return"function"==typeof e},t.partial=function(e){for(var t=arguments.length,r=new Array(t>1?t-1:0),n=1;n<t;n++)r[n-1]=arguments[n];return function(){for(var t=arguments.length,n=new Array(t),s=0;s<t;s++)n[s]=arguments[s];return e.apply(this,r.concat(n))}},t.pipe=function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];const[s,...i]=t;return function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return(0,n.arrayReduce)(i,((e,t)=>t(e)),s.apply(this,t))}},t.throttle=i,t.throttleAfterHits=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:200,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:10;const n=i(e,t);let s=r;function o(){for(var t=arguments.length,r=new Array(t),i=0;i<t;i++)r[i]=arguments[i];return s?(s-=1,e.apply(this,r)):n.apply(this,r)}return o.clearHits=function(){s=r},o};var n=r(10587),s=r(70505);function i(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:200,r=0;const n={lastCallThrottled:!0};let s=null;return function(){for(var i=arguments.length,o=new Array(i),a=0;a<i;a++)o[a]=arguments[a];const l=Date.now();let h=!1;n.lastCallThrottled=!0,r||(r=l,h=!0);const u=t-(l-r);return h?(n.lastCallThrottled=!1,e.apply(this,o)):(s&&clearTimeout(s),s=setTimeout((()=>{n.lastCallThrottled=!1,e.apply(this,o),r=0,s=void 0}),u)),n}}},70505:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t._injectProductInfo=function(e,t){const r=!a(e),n="string"==typeof e&&"non-commercial-and-evaluation"===e.toLowerCase(),i="15.0.0";let o,w="invalid",C="invalid";const v=function(e){let t=[][l],r=t;if(e[l]!==d("Z"))return!1;for(let t="",n="B<H4P+".split(""),s=d(n.shift());s;s=d(n.shift()||"A"))--s<""[l]?r|=(u(`${u(h(t)+(h(c(e,Math.abs(s),2))+[]).padStart(2,"0"))}`)%97||2)>>1:t=c(e,s,s?1===n[l]?9:8:6);return r===t}(e=p(e||""));if(r||n||v)if(v){const t=(0,s.default)("16/12/2024","DD/MM/YYYY"),r=Math.floor(t.toDate().getTime()/864e5),n=g(e);o=(0,s.default)(864e5*(n+1),"x").format("MMMM DD, YYYY"),r>n?(w="expired",C="expired"):(w="valid",C="valid")}else n?(w="non_commercial",C="valid"):(w="invalid",C="invalid");else w="missing",C="missing";f()&&(w="valid",C="valid");if(!m&&"valid"!==w){y[w]({keyValidityDate:o,hotVersion:i})&&console["non_commercial"===w?"info":"warn"](y[w]({keyValidityDate:o,hotVersion:i})),m=!0}if("valid"!==C&&t.parentNode){if(E[C]({keyValidityDate:o,hotVersion:i})){const e=document.createElement("div");e.className="handsontable hot-display-license-info",e.innerHTML=E[C]({keyValidityDate:o,hotVersion:i}),t.parentNode.insertBefore(e,t.nextSibling)}}},t.isDefined=function(e){return void 0!==e},t.isEmpty=a,t.isRegExp=function(e){return"[object RegExp]"===Object.prototype.toString.call(e)},t.isUndefined=o,t.stringify=function(e){let t;switch(typeof e){case"string":case"number":t=`${e}`;break;case"object":t=null===e?"":e.toString();break;case"undefined":t="";break;default:t=e.toString()}return t};var s=n(r(6671)),i=r(21595);function o(e){return void 0===e}function a(e){return null===e||""===e||o(e)}const l="length",h=e=>parseInt(e,16),u=e=>parseInt(e,10),c=(e,t,r)=>e.substr(t,r),d=e=>e.codePointAt(0)-65,p=e=>`${e}`.replace(/\-/g,""),g=e=>h(c(p(e),h("12"),d("F")))/(h(c(p(e),d("B"),~~![][l]))||9),f=()=>"undefined"!=typeof location&&/^([a-z0-9\-]+\.)?\x68\x61\x6E\x64\x73\x6F\x6E\x74\x61\x62\x6C\x65\x2E\x63\x6F\x6D$/i.test(location.host);let m=!1;const y={invalid:()=>i.toSingleLine`
    The license key for Handsontable is invalid.\x20
    If you need any help, contact us at support@handsontable.com.`,expired:e=>{let{keyValidityDate:t,hotVersion:r}=e;return i.toSingleLine`
    The license key for Handsontable expired on ${t}, and is not valid for the installed\x20
    version ${r}. Renew your license key at handsontable.com or downgrade to a version released prior\x20
    to ${t}. If you need any help, contact us at sales@handsontable.com.`},missing:()=>i.toSingleLine`
    The license key for Handsontable is missing. Use your purchased key to activate the product.\x20
    Alternatively, you can activate Handsontable to use for non-commercial purposes by\x20
    passing the key: 'non-commercial-and-evaluation'. If you need any help, contact\x20
    us at support@handsontable.com.`,non_commercial:()=>""},E={invalid:()=>i.toSingleLine`
    The license key for Handsontable is invalid.\x20
    <a href="https://handsontable.com/docs/tutorial-license-key.html" target="_blank">Read more</a> on how to\x20
    install it properly or contact us at <a href="mailto:support@handsontable.com">support@handsontable.com</a>.`,expired:e=>{let{keyValidityDate:t,hotVersion:r}=e;return i.toSingleLine`
    The license key for Handsontable expired on ${t}, and is not valid for the installed\x20
    version ${r}. <a href="https://handsontable.com/pricing" target="_blank">Renew</a> your\x20
    license key or downgrade to a version released prior to ${t}. If you need any\x20
    help, contact us at <a href="mailto:sales@handsontable.com">sales@handsontable.com</a>.`},missing:()=>i.toSingleLine`
    The license key for Handsontable is missing. Use your purchased key to activate the product.\x20
    Alternatively, you can activate Handsontable to use for non-commercial purposes by\x20
    passing the key: 'non-commercial-and-evaluation'.\x20
    <a href="https://handsontable.com/docs/tutorial-license-key.html" target="_blank">Read more</a> about it in\x20
    the documentation or contact us at <a href="mailto:support@handsontable.com">support@handsontable.com</a>.`,non_commercial:()=>""}},4980:(e,t,r)=>{"use strict";t.__esModule=!0,t.getMoves=function(e,t,r){return function(e){return e.forEach(((t,r)=>{e.slice(r+1).forEach((e=>{const r=e.from<e.to;e.from>t.from&&r&&(e.from-=1)}))})),e}(function(e,t){const r=[];return e.forEach((e=>{const n={from:e,to:t};r.forEach((e=>{const t=e.from>e.to,r=e.to<=n.from;e.from>n.from&&r&&t&&(n.from+=1)})),n.from>=t&&(t+=1),r.push(n)})),r}(e,function(e,t,r){const n=Array.from(Array(r).keys()).filter((t=>!1===e.includes(t)));var s;return 0===t?null!==(s=n[t])&&void 0!==s?s:0:n[t-1]+1}(e,t,r)))},r(15724),r(14846),r(27458),r(69655)},22137:(e,t,r)=>{"use strict";function n(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];const r=typeof e;if("number"===r)return!isNaN(e)&&isFinite(e);if("string"===r){if(0===e.length)return!1;if(1===e.length)return/\d/.test(e);const r=Array.from(new Set([".",...t])).map((e=>`\\${e}`)).join("|");return new RegExp(`^[+-]?(((${r})?\\d+((${r})\\d+)?(e[+-]?\\d+)?)|(0x[a-f\\d]+))$`,"i").test(e.trim())}return"object"===r&&!(!e||"number"!=typeof e.valueOf()||e instanceof Date)}t.__esModule=!0,t.clamp=function(e,t,r){if(Math.min(e,t)===e)return t;if(Math.max(e,r)===e)return r;return e},t.isNumeric=n,t.isNumericLike=function(e){return n(e,[","])},t.rangeEach=function(e,t,r){let n=-1;"function"==typeof t?(r=t,t=e):n=e-1;for(;++n<=t&&!1!==r(n););},t.rangeEachReverse=function(e,t,r){let n=e+1;"function"==typeof t&&(r=t,t=0);for(;--n>=t&&!1!==r(n););},t.valueAccordingPercent=function(e,t){return t=parseInt(t.toString().replace("%",""),10),t=isNaN(t)?0:t,parseInt(e*t/100,10)},r(71336),r(41558),r(17663),r(68630),r(79645),r(89858),r(8620),r(94364)},25499:(e,t,r)=>{"use strict";t.__esModule=!0,t.clone=function(e){const t={};return o(e,((e,r)=>{t[r]=e})),t},t.createObjectPropListener=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"value";const r=`_${t}`,n={_touched:!1,[r]:e,isTouched(){return this._touched}};return Object.defineProperty(n,t,{get(){return this[r]},set(e){this._touched=!0,this[r]=e},enumerable:!0,configurable:!0}),n},t.deepClone=s,t.deepExtend=function e(t,r){o(r,((n,s)=>{r[s]&&"object"==typeof r[s]?(t[s]||(Array.isArray(r[s])?t[s]=[]:"[object Date]"===Object.prototype.toString.call(r[s])?t[s]=r[s]:t[s]={}),e(t[s],r[s])):t[s]=r[s]}))},t.deepObjectSize=function(e){if(!i(e))return 0;const t=function(e){let r=0;return i(e)?o(e,((e,n)=>{"__children"!==n&&(r+=t(e))})):r+=1,r};return t(e)},t.defineGetter=function(e,t,r,n){n.value=r,n.writable=!1!==n.writable,n.enumerable=!1!==n.enumerable,n.configurable=!1!==n.configurable,Object.defineProperty(e,t,n)},t.duckSchema=function e(t){let r;Array.isArray(t)?r=t.length?new Array(t.length).fill(null):[]:(r={},o(t,((t,n)=>{"__children"!==n&&(t&&"object"==typeof t&&!Array.isArray(t)?r[n]=e(t):Array.isArray(t)?t.length&&"object"==typeof t[0]&&!Array.isArray(t[0])?r[n]=[e(t[0])]:r[n]=[]:r[n]=null)})));return r},t.extend=function(e,t,r){const n=Array.isArray(r);return o(t,((t,s)=>{(!1===n||r.includes(s))&&(e[s]=t)})),e},t.getProperty=function(e,t){const r=t.split(".");let n=e;return o(r,(e=>{if(n=n[e],void 0===n)return n=void 0,!1})),n},t.hasOwnProperty=a,t.inherit=function(e,t){return t.prototype.constructor=t,e.prototype=new t,e.prototype.constructor=e,e},t.isObject=i,t.isObjectEqual=function(e,t){return JSON.stringify(e)===JSON.stringify(t)},t.mixin=function(e){e.MIXINS||(e.MIXINS=[]);for(var t=arguments.length,r=new Array(t>1?t-1:0),a=1;a<t;a++)r[a-1]=arguments[a];return(0,n.arrayEach)(r,(t=>{e.MIXINS.push(t.MIXIN_NAME),o(t,((t,r)=>{if(void 0!==e.prototype[r])throw new Error(`Mixin conflict. Property '${r}' already exist and cannot be overwritten.`);if("function"==typeof t)e.prototype[r]=t;else{const n=function(e,t){const r=`_${e}`;return function(){return void 0===this[r]&&(this[r]=(e=>{let t=e;return(Array.isArray(t)||i(t))&&(t=s(t)),t})(t)),this[r]}},o=function(e){const t=`_${e}`;return function(e){this[t]=e}};Object.defineProperty(e.prototype,r,{get:n(r,t),set:o(r),configurable:!0})}}))})),e},t.objectEach=o,t.setProperty=function(e,t,r){const n=t.split(".");let s=e;n.forEach(((e,t)=>{t!==n.length-1?(a(s,e)||(s[e]={}),s=s[e]):s[e]=r}))},r(67834),r(15724),r(66184),r(14846),r(69655);var n=r(10587);function s(e){return"object"==typeof e?JSON.parse(JSON.stringify(e)):e}function i(e){return"[object Object]"===Object.prototype.toString.call(e)}function o(e,t){for(const r in e)if((!e.hasOwnProperty||e.hasOwnProperty&&Object.prototype.hasOwnProperty.call(e,r))&&!1===t(e[r],r,e))break;return e}function a(e,t){return Object.prototype.hasOwnProperty.call(e,t)}},5893:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.equalsIgnoreCase=function(){const e=[];for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];let s=r.length;for(;s;){s-=1;const t=(0,i.stringify)(r[s]).toLowerCase();-1===e.indexOf(t)&&e.push(t)}return 1===e.length},t.isPercentValue=function(e){return/^([0-9][0-9]?%$)|(^100%$)/.test(e)},t.randomString=function(){function e(){return Math.floor(65536*(1+Math.random())).toString(16).substring(1)}return e()+e()+e()+e()},t.sanitize=o,t.stripTags=function(e){return o(`${e}`,{ALLOWED_TAGS:[]})},t.substitute=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return`${e}`.replace(/(?:\\)?\[([^[\]]+)]/g,((e,r)=>"\\"===e.charAt(0)?e.substr(1,e.length-1):void 0===t[r]?"":t[r]))},t.toUpperCaseFirst=function(e){return e[0].toUpperCase()+e.substr(1)},r(15724);var s=n(r(98339)),i=r(70505);function o(e,t){return s.default.sanitize(e,t)}},21595:(e,t,r)=>{"use strict";t.__esModule=!0,t.toSingleLine=function(e){for(var t=arguments.length,r=new Array(t>1?t-1:0),s=1;s<t;s++)r[s-1]=arguments[s];return(0,n.arrayReduce)(e,((e,t,n)=>e+t.replace(/\r?\n\s*/g,"")+(r[n]?r[n]:"")),"").trim()};var n=r(10587)},73618:(e,t,r)=>{"use strict";t.__esModule=!0,t.getThemeClassName=function(e){const{classNames:t}=(0,n.findFirstParentWithClass)(e,/ht-theme-[a-zA-Z0-9_-]+/);return t.pop()};var n=r(62577)},83445:(e,t,r)=>{"use strict";t.__esModule=!0,t.isCtrlKey=function(e){const t=[];(0,s.isMacOS)()?t.push(i.COMMAND_LEFT,i.COMMAND_RIGHT,i.COMMAND_FIREFOX):t.push(i.CONTROL);return t.includes(e)},t.isCtrlMetaKey=function(e){return[i.CONTROL,i.COMMAND_LEFT,i.COMMAND_RIGHT,i.COMMAND_FIREFOX].includes(e)},t.isFunctionKey=function(e){return o.includes(e)},t.isKey=function(e,t){const r=t.split("|");let s=!1;return(0,n.arrayEach)(r,(t=>{if(e===i[t])return s=!0,!1})),s},t.isPrintableChar=function(e){return 32===e||e>=48&&e<=57||e>=96&&e<=111||e>=186&&e<=192||e>=219&&e<=222||e>=226||e>=65&&e<=90},r(15724);var n=r(10587),s=r(25046);const i=t.KEY_CODES={ALT:18,ARROW_DOWN:40,ARROW_LEFT:37,ARROW_RIGHT:39,ARROW_UP:38,AUDIO_DOWN:(0,s.isFirefox)()?182:174,AUDIO_MUTE:(0,s.isFirefox)()?181:173,AUDIO_UP:(0,s.isFirefox)()?183:175,BACKSPACE:8,CAPS_LOCK:20,COMMA:188,COMMAND_LEFT:91,COMMAND_RIGHT:93,COMMAND_FIREFOX:224,CONTROL:17,DELETE:46,END:35,ENTER:13,ESCAPE:27,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,F12:123,F13:124,F14:125,F15:126,F16:127,F17:128,F18:129,F19:130,HOME:36,INSERT:45,MEDIA_NEXT:176,MEDIA_PLAY_PAUSE:179,MEDIA_PREV:177,MEDIA_STOP:178,NULL:0,NUM_LOCK:144,PAGE_DOWN:34,PAGE_UP:33,PAUSE:19,PERIOD:190,SCROLL_LOCK:145,SHIFT:16,SPACE:32,TAB:9,A:65,C:67,D:68,F:70,L:76,O:79,P:80,S:83,V:86,X:88,Y:89,Z:90},o=[i.ALT,i.ARROW_DOWN,i.ARROW_LEFT,i.ARROW_RIGHT,i.ARROW_UP,i.AUDIO_DOWN,i.AUDIO_MUTE,i.AUDIO_UP,i.BACKSPACE,i.CAPS_LOCK,i.DELETE,i.END,i.ENTER,i.ESCAPE,i.F1,i.F2,i.F3,i.F4,i.F5,i.F6,i.F7,i.F8,i.F9,i.F10,i.F11,i.F12,i.F13,i.F14,i.F15,i.F16,i.F17,i.F18,i.F19,i.HOME,i.INSERT,i.MEDIA_NEXT,i.MEDIA_PLAY_PAUSE,i.MEDIA_PREV,i.MEDIA_STOP,i.NULL,i.NUM_LOCK,i.PAGE_DOWN,i.PAGE_UP,i.PAUSE,i.SCROLL_LOCK,i.SHIFT,i.TAB]},29861:(e,t,r)=>{"use strict";t.__esModule=!0,t.default=function(e){const t="undefined"!=typeof window&&window.jQuery;if(!t)return;t.fn.handsontable=function(t){const r=this.first();let n,s=r.data("handsontable");if("string"!=typeof t){const n=t||{};return s?s.updateSettings(n):(s=new e.Core(r[0],n),r.data("handsontable",s),s.init()),r}if(s){if(void 0===s[t])throw new Error(`Handsontable do not provide action: ${t}`);for(var i=arguments.length,o=new Array(i>1?i-1:0),a=1;a<i;a++)o[a-1]=arguments[a];n=s[t].call(s,...o),"destroy"===t&&r.removeData()}return n}},r(67834)},23384:(e,t)=>{"use strict";t.__esModule=!0;const r=t.CONTEXT_MENU_ITEMS_NAMESPACE="ContextMenu:items",n=(t.CONTEXTMENU_ITEMS_NO_ITEMS=`${r}.noItems`,t.CONTEXTMENU_ITEMS_ROW_ABOVE=`${r}.insertRowAbove`,t.CONTEXTMENU_ITEMS_ROW_BELOW=`${r}.insertRowBelow`,t.CONTEXTMENU_ITEMS_INSERT_LEFT=`${r}.insertColumnOnTheLeft`,t.CONTEXTMENU_ITEMS_INSERT_RIGHT=`${r}.insertColumnOnTheRight`,t.CONTEXTMENU_ITEMS_REMOVE_ROW=`${r}.removeRow`,t.CONTEXTMENU_ITEMS_REMOVE_COLUMN=`${r}.removeColumn`,t.CONTEXTMENU_ITEMS_UNDO=`${r}.undo`,t.CONTEXTMENU_ITEMS_REDO=`${r}.redo`,t.CONTEXTMENU_ITEMS_READ_ONLY=`${r}.readOnly`,t.CONTEXTMENU_ITEMS_CLEAR_COLUMN=`${r}.clearColumn`,t.CONTEXTMENU_ITEMS_COPY=`${r}.copy`,t.CONTEXTMENU_ITEMS_COPY_WITH_COLUMN_HEADERS=`${r}.copyWithHeaders`,t.CONTEXTMENU_ITEMS_COPY_WITH_COLUMN_GROUP_HEADERS=`${r}.copyWithGroupHeaders`,t.CONTEXTMENU_ITEMS_COPY_COLUMN_HEADERS_ONLY=`${r}.copyHeadersOnly`,t.CONTEXTMENU_ITEMS_CUT=`${r}.cut`,t.CONTEXTMENU_ITEMS_FREEZE_COLUMN=`${r}.freezeColumn`,t.CONTEXTMENU_ITEMS_UNFREEZE_COLUMN=`${r}.unfreezeColumn`,t.CONTEXTMENU_ITEMS_MERGE_CELLS=`${r}.mergeCells`,t.CONTEXTMENU_ITEMS_UNMERGE_CELLS=`${r}.unmergeCells`,t.CONTEXTMENU_ITEMS_ADD_COMMENT=`${r}.addComment`,t.CONTEXTMENU_ITEMS_EDIT_COMMENT=`${r}.editComment`,t.CONTEXTMENU_ITEMS_REMOVE_COMMENT=`${r}.removeComment`,t.CONTEXTMENU_ITEMS_READ_ONLY_COMMENT=`${r}.readOnlyComment`,t.CONTEXTMENU_ITEMS_ALIGNMENT=`${r}.align`,t.CONTEXTMENU_ITEMS_ALIGNMENT_LEFT=`${r}.align.left`,t.CONTEXTMENU_ITEMS_ALIGNMENT_CENTER=`${r}.align.center`,t.CONTEXTMENU_ITEMS_ALIGNMENT_RIGHT=`${r}.align.right`,t.CONTEXTMENU_ITEMS_ALIGNMENT_JUSTIFY=`${r}.align.justify`,t.CONTEXTMENU_ITEMS_ALIGNMENT_TOP=`${r}.align.top`,t.CONTEXTMENU_ITEMS_ALIGNMENT_MIDDLE=`${r}.align.middle`,t.CONTEXTMENU_ITEMS_ALIGNMENT_BOTTOM=`${r}.align.bottom`,t.CONTEXTMENU_ITEMS_BORDERS=`${r}.borders`,t.CONTEXTMENU_ITEMS_BORDERS_TOP=`${r}.borders.top`,t.CONTEXTMENU_ITEMS_BORDERS_RIGHT=`${r}.borders.right`,t.CONTEXTMENU_ITEMS_BORDERS_BOTTOM=`${r}.borders.bottom`,t.CONTEXTMENU_ITEMS_BORDERS_LEFT=`${r}.borders.left`,t.CONTEXTMENU_ITEMS_REMOVE_BORDERS=`${r}.borders.remove`,t.CONTEXTMENU_ITEMS_NESTED_ROWS_INSERT_CHILD=`${r}.nestedHeaders.insertChildRow`,t.CONTEXTMENU_ITEMS_NESTED_ROWS_DETACH_CHILD=`${r}.nestedHeaders.detachFromParent`,t.CONTEXTMENU_ITEMS_HIDE_COLUMN=`${r}.hideColumn`,t.CONTEXTMENU_ITEMS_SHOW_COLUMN=`${r}.showColumn`,t.CONTEXTMENU_ITEMS_HIDE_ROW=`${r}.hideRow`,t.CONTEXTMENU_ITEMS_SHOW_ROW=`${r}.showRow`,t.FILTERS_NAMESPACE="Filters:"),s=t.FILTERS_CONDITIONS_NAMESPACE=`${n}conditions`,i=(t.FILTERS_CONDITIONS_NONE=`${s}.none`,t.FILTERS_CONDITIONS_EMPTY=`${s}.isEmpty`,t.FILTERS_CONDITIONS_NOT_EMPTY=`${s}.isNotEmpty`,t.FILTERS_CONDITIONS_EQUAL=`${s}.isEqualTo`,t.FILTERS_CONDITIONS_NOT_EQUAL=`${s}.isNotEqualTo`,t.FILTERS_CONDITIONS_BEGINS_WITH=`${s}.beginsWith`,t.FILTERS_CONDITIONS_ENDS_WITH=`${s}.endsWith`,t.FILTERS_CONDITIONS_CONTAINS=`${s}.contains`,t.FILTERS_CONDITIONS_NOT_CONTAIN=`${s}.doesNotContain`,t.FILTERS_CONDITIONS_BY_VALUE=`${s}.byValue`,t.FILTERS_CONDITIONS_GREATER_THAN=`${s}.greaterThan`,t.FILTERS_CONDITIONS_GREATER_THAN_OR_EQUAL=`${s}.greaterThanOrEqualTo`,t.FILTERS_CONDITIONS_LESS_THAN=`${s}.lessThan`,t.FILTERS_CONDITIONS_LESS_THAN_OR_EQUAL=`${s}.lessThanOrEqualTo`,t.FILTERS_CONDITIONS_BETWEEN=`${s}.isBetween`,t.FILTERS_CONDITIONS_NOT_BETWEEN=`${s}.isNotBetween`,t.FILTERS_CONDITIONS_AFTER=`${s}.after`,t.FILTERS_CONDITIONS_BEFORE=`${s}.before`,t.FILTERS_CONDITIONS_TODAY=`${s}.today`,t.FILTERS_CONDITIONS_TOMORROW=`${s}.tomorrow`,t.FILTERS_CONDITIONS_YESTERDAY=`${s}.yesterday`,t.FILTERS_DIVS_FILTER_BY_CONDITION=`${n}labels.filterByCondition`,t.FILTERS_DIVS_FILTER_BY_VALUE=`${n}labels.filterByValue`,t.FILTERS_LABELS_CONJUNCTION=`${n}labels.conjunction`,t.FILTERS_LABELS_DISJUNCTION=`${n}labels.disjunction`,t.FILTERS_VALUES_BLANK_CELLS=`${n}values.blankCells`,t.FILTERS_BUTTONS_SELECT_ALL=`${n}buttons.selectAll`,t.FILTERS_BUTTONS_CLEAR=`${n}buttons.clear`,t.FILTERS_BUTTONS_OK=`${n}buttons.ok`,t.FILTERS_BUTTONS_CANCEL=`${n}buttons.cancel`,t.FILTERS_BUTTONS_PLACEHOLDER_SEARCH=`${n}buttons.placeholder.search`,t.FILTERS_BUTTONS_PLACEHOLDER_VALUE=`${n}buttons.placeholder.value`,t.FILTERS_BUTTONS_PLACEHOLDER_SECOND_VALUE=`${n}buttons.placeholder.secondValue`,t.CHECKBOX_RENDERER_NAMESPACE="CheckboxRenderer:");t.CHECKBOX_CHECKED=`${i}checked`,t.CHECKBOX_UNCHECKED=`${i}unchecked`},42303:(e,t,r)=>{"use strict";t.__esModule=!0;var n=function(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var r=s(t);if(r&&r.has(e))return r.get(e);var n={__proto__:null},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&{}.hasOwnProperty.call(e,o)){var a=i?Object.getOwnPropertyDescriptor(e,o):null;a&&(a.get||a.set)?Object.defineProperty(n,o,a):n[o]=e[o]}return n.default=e,r&&r.set(e,n),n
/**
 * @preserve
 * Authors: Handsoncode
 * Last updated: Nov 15, 2017
 *
 * Description: Definition file for English - United States language-country.
 */}(r(23384));function s(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,r=new WeakMap;return(s=function(e){return e?r:t})(e)}const i={languageCode:"en-US",[n.CONTEXTMENU_ITEMS_NO_ITEMS]:"No available options",[n.CONTEXTMENU_ITEMS_ROW_ABOVE]:"Insert row above",[n.CONTEXTMENU_ITEMS_ROW_BELOW]:"Insert row below",[n.CONTEXTMENU_ITEMS_INSERT_LEFT]:"Insert column left",[n.CONTEXTMENU_ITEMS_INSERT_RIGHT]:"Insert column right",[n.CONTEXTMENU_ITEMS_REMOVE_ROW]:["Remove row","Remove rows"],[n.CONTEXTMENU_ITEMS_REMOVE_COLUMN]:["Remove column","Remove columns"],[n.CONTEXTMENU_ITEMS_UNDO]:"Undo",[n.CONTEXTMENU_ITEMS_REDO]:"Redo",[n.CONTEXTMENU_ITEMS_READ_ONLY]:"Read only",[n.CONTEXTMENU_ITEMS_CLEAR_COLUMN]:"Clear column",[n.CONTEXTMENU_ITEMS_ALIGNMENT]:"Alignment",[n.CONTEXTMENU_ITEMS_ALIGNMENT_LEFT]:"Left",[n.CONTEXTMENU_ITEMS_ALIGNMENT_CENTER]:"Center",[n.CONTEXTMENU_ITEMS_ALIGNMENT_RIGHT]:"Right",[n.CONTEXTMENU_ITEMS_ALIGNMENT_JUSTIFY]:"Justify",[n.CONTEXTMENU_ITEMS_ALIGNMENT_TOP]:"Top",[n.CONTEXTMENU_ITEMS_ALIGNMENT_MIDDLE]:"Middle",[n.CONTEXTMENU_ITEMS_ALIGNMENT_BOTTOM]:"Bottom",[n.CONTEXTMENU_ITEMS_FREEZE_COLUMN]:"Freeze column",[n.CONTEXTMENU_ITEMS_UNFREEZE_COLUMN]:"Unfreeze column",[n.CONTEXTMENU_ITEMS_BORDERS]:"Borders",[n.CONTEXTMENU_ITEMS_BORDERS_TOP]:"Top",[n.CONTEXTMENU_ITEMS_BORDERS_RIGHT]:"Right",[n.CONTEXTMENU_ITEMS_BORDERS_BOTTOM]:"Bottom",[n.CONTEXTMENU_ITEMS_BORDERS_LEFT]:"Left",[n.CONTEXTMENU_ITEMS_REMOVE_BORDERS]:"Remove border(s)",[n.CONTEXTMENU_ITEMS_ADD_COMMENT]:"Add comment",[n.CONTEXTMENU_ITEMS_EDIT_COMMENT]:"Edit comment",[n.CONTEXTMENU_ITEMS_REMOVE_COMMENT]:"Delete comment",[n.CONTEXTMENU_ITEMS_READ_ONLY_COMMENT]:"Read-only comment",[n.CONTEXTMENU_ITEMS_MERGE_CELLS]:"Merge cells",[n.CONTEXTMENU_ITEMS_UNMERGE_CELLS]:"Unmerge cells",[n.CONTEXTMENU_ITEMS_COPY]:"Copy",[n.CONTEXTMENU_ITEMS_COPY_WITH_COLUMN_HEADERS]:["Copy with header","Copy with headers"],[n.CONTEXTMENU_ITEMS_COPY_WITH_COLUMN_GROUP_HEADERS]:["Copy with group header","Copy with group headers"],[n.CONTEXTMENU_ITEMS_COPY_COLUMN_HEADERS_ONLY]:["Copy header only","Copy headers only"],[n.CONTEXTMENU_ITEMS_CUT]:"Cut",[n.CONTEXTMENU_ITEMS_NESTED_ROWS_INSERT_CHILD]:"Insert child row",[n.CONTEXTMENU_ITEMS_NESTED_ROWS_DETACH_CHILD]:"Detach from parent",[n.CONTEXTMENU_ITEMS_HIDE_COLUMN]:["Hide column","Hide columns"],[n.CONTEXTMENU_ITEMS_SHOW_COLUMN]:["Show column","Show columns"],[n.CONTEXTMENU_ITEMS_HIDE_ROW]:["Hide row","Hide rows"],[n.CONTEXTMENU_ITEMS_SHOW_ROW]:["Show row","Show rows"],[n.FILTERS_CONDITIONS_NONE]:"None",[n.FILTERS_CONDITIONS_EMPTY]:"Is empty",[n.FILTERS_CONDITIONS_NOT_EMPTY]:"Is not empty",[n.FILTERS_CONDITIONS_EQUAL]:"Is equal to",[n.FILTERS_CONDITIONS_NOT_EQUAL]:"Is not equal to",[n.FILTERS_CONDITIONS_BEGINS_WITH]:"Begins with",[n.FILTERS_CONDITIONS_ENDS_WITH]:"Ends with",[n.FILTERS_CONDITIONS_CONTAINS]:"Contains",[n.FILTERS_CONDITIONS_NOT_CONTAIN]:"Does not contain",[n.FILTERS_CONDITIONS_GREATER_THAN]:"Greater than",[n.FILTERS_CONDITIONS_GREATER_THAN_OR_EQUAL]:"Greater than or equal to",[n.FILTERS_CONDITIONS_LESS_THAN]:"Less than",[n.FILTERS_CONDITIONS_LESS_THAN_OR_EQUAL]:"Less than or equal to",[n.FILTERS_CONDITIONS_BETWEEN]:"Is between",[n.FILTERS_CONDITIONS_NOT_BETWEEN]:"Is not between",[n.FILTERS_CONDITIONS_AFTER]:"After",[n.FILTERS_CONDITIONS_BEFORE]:"Before",[n.FILTERS_CONDITIONS_TODAY]:"Today",[n.FILTERS_CONDITIONS_TOMORROW]:"Tomorrow",[n.FILTERS_CONDITIONS_YESTERDAY]:"Yesterday",[n.FILTERS_VALUES_BLANK_CELLS]:"Blank cells",[n.FILTERS_DIVS_FILTER_BY_CONDITION]:"Filter by condition",[n.FILTERS_DIVS_FILTER_BY_VALUE]:"Filter by value",[n.FILTERS_LABELS_CONJUNCTION]:"And",[n.FILTERS_LABELS_DISJUNCTION]:"Or",[n.FILTERS_BUTTONS_SELECT_ALL]:"Select all",[n.FILTERS_BUTTONS_CLEAR]:"Clear",[n.FILTERS_BUTTONS_OK]:"OK",[n.FILTERS_BUTTONS_CANCEL]:"Cancel",[n.FILTERS_BUTTONS_PLACEHOLDER_SEARCH]:"Search",[n.FILTERS_BUTTONS_PLACEHOLDER_VALUE]:"Value",[n.FILTERS_BUTTONS_PLACEHOLDER_SECOND_VALUE]:"Second value",[n.CHECKBOX_CHECKED]:"Checked",[n.CHECKBOX_UNCHECKED]:"Unchecked"};t.default=i},83048:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.getPhraseFormatters=t.getAll=function(){return a()},t.registerPhraseFormatter=t.register=l;var s=n(r(28651)),i=n(r(11796));const{register:o,getValues:a}=(0,s.default)("phraseFormatters");function l(e,t){o(e,t)}l("pluralize",i.default)},11796:(e,t)=>{"use strict";t.__esModule=!0,t.default=function(e,t){if(Array.isArray(e)&&Number.isInteger(t))return e[t];return e}},58570:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.getDefaultLanguageDictionary=function(){return u.default},t.getLanguageDictionary=w,t.getLanguagesDictionaries=function(){return y()},t.getTranslatedPhrase=function(e,t,r){const n=w(e);if(null===n)return null;const s=n[t];if((0,o.isUndefined)(s))return null;const a=function(e,t){let r=e;return(0,i.arrayEach)((0,h.getPhraseFormatters)(),(n=>{r=n(e,t)})),r}(s,r);if(Array.isArray(a))return a[0];return a},t.getValidLanguageCode=function(e){let t=(0,a.normalizeLanguageCode)(e);C(t)||(t=p,(0,a.warnUserAboutLanguageRegistration)(e));return t},t.hasLanguageDictionary=C,t.registerLanguageDictionary=E;var s=r(25499),i=r(10587),o=r(70505),a=r(1052),l=n(r(28651)),h=r(83048),u=n(r(42303)),c=function(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var r=d(t);if(r&&r.has(e))return r.get(e);var n={__proto__:null},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var i in e)if("default"!==i&&{}.hasOwnProperty.call(e,i)){var o=s?Object.getOwnPropertyDescriptor(e,i):null;o&&(o.get||o.set)?Object.defineProperty(n,i,o):n[i]=e[i]}return n.default=e,r&&r.set(e,n),n}(r(23384));function d(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,r=new WeakMap;return(d=function(e){return e?r:t})(e)}t.dictionaryKeys=c;const p=t.DEFAULT_LANGUAGE_CODE=u.default.languageCode,{register:g,getItem:f,hasItem:m,getValues:y}=(0,l.default)("languagesDictionaries");function E(e,t){let r=e,n=t;return(0,s.isObject)(e)&&(n=e,r=n.languageCode),function(e,t){e!==p&&(0,a.extendNotExistingKeys)(t,f(p))}(r,n),g(r,(0,s.deepClone)(n)),(0,s.deepClone)(n)}function w(e){return C(e)?(0,s.deepClone)(f(e)):null}function C(e){return m(e)}E(u.default)},1052:(e,t,r)=>{"use strict";t.__esModule=!0,t.createCellHeadersRange=function(e,t){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:e,n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:t,[s,i]=[r,n];e>t&&([s,i]=[i,s]);return`${s}-${i}`},t.extendNotExistingKeys=function(e,t){return(0,s.objectEach)(t,((t,r)=>{(0,n.isUndefined)(e[r])&&(e[r]=t)})),e},t.normalizeLanguageCode=function(e){const t=/^([a-zA-Z]{2})-([a-zA-Z]{2})$/.exec(e);if(t)return`${t[1].toLowerCase()}-${t[2].toUpperCase()}`;return e},t.warnUserAboutLanguageRegistration=function(e){(0,n.isDefined)(e)&&(0,i.error)(o.toSingleLine`Language with code "${e}" was not found. You should register particular language\x20
    before using it. Read more about this issue at: https://docs.handsontable.com/i18n/missing-language-code.`)};var n=r(70505),s=r(25499),i=r(14859),o=r(21595)},31168:(e,t,r)=>{"use strict";var n=r(96784);var s=k(r(87935));s.CellCoords,s.CellRange;var i,o,a,l,h,u=r(45793),c=k(r(3849)),d=r(61149),p=n(r(29861)),g=n(r(4965)),f=k(r(96173)),m=k(r(10587)),y=k(r(25046)),E=k(r(87124)),w=k(r(95976)),C=k(r(85992)),v=k(r(89804)),R=k(r(70505)),S=k(r(22137)),T=k(r(25499)),N=k(r(5893)),M=k(r(83445)),_=k(r(62577)),b=k(r(77661)),A=r(8266),O=r(54852),I=r(17027),x=r(1791),P=r(74672),L=r(75089);function D(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,r=new WeakMap;return(D=function(e){return e?r:t})(e)}function k(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var r=D(t);if(r&&r.has(e))return r.get(e);var n={__proto__:null},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var i in e)if("default"!==i&&{}.hasOwnProperty.call(e,i)){var o=s?Object.getOwnPropertyDescriptor(e,i):null;o&&(o.get||o.set)?Object.defineProperty(n,i,o):n[i]=e[i]}return n.default=e,r&&r.set(e,n),n}(0,u.registerAllModules)(),(0,p.default)(s.default),s.default.__GhostTable=g.default,s.default._getListenersCounter=c.getListenersCounter,s.default._getRegisteredMapsCounter=d.getRegisteredMapsCounter,s.default.EventManager=c.default;const H=[m,y,E,w,C,v,R,S,T,N,M,f],F=[_,b];s.default.helper={},s.default.dom={},m.arrayEach(H,(e=>{m.arrayEach(Object.getOwnPropertyNames(e),(t=>{"_"!==t.charAt(0)&&(s.default.helper[t]=e[t])}))})),m.arrayEach(F,(e=>{m.arrayEach(Object.getOwnPropertyNames(e),(t=>{"_"!==t.charAt(0)&&(s.default.dom[t]=e[t])}))})),s.default.cellTypes=null!==(i=s.default.cellTypes)&&void 0!==i?i:{},m.arrayEach((0,x.getRegisteredCellTypeNames)(),(e=>{s.default.cellTypes[e]=(0,x.getCellType)(e)})),s.default.cellTypes.registerCellType=x.registerCellType,s.default.cellTypes.getCellType=x.getCellType,s.default.editors=null!==(o=s.default.editors)&&void 0!==o?o:{},m.arrayEach((0,A.getRegisteredEditorNames)(),(e=>{s.default.editors[`${N.toUpperCaseFirst(e)}Editor`]=(0,A.getEditor)(e)})),s.default.editors.registerEditor=A.registerEditor,s.default.editors.getEditor=A.getEditor,s.default.renderers=null!==(a=s.default.renderers)&&void 0!==a?a:{},m.arrayEach((0,O.getRegisteredRendererNames)(),(e=>{const t=(0,O.getRenderer)(e);"base"===e&&(s.default.renderers.cellDecorator=t),s.default.renderers[`${N.toUpperCaseFirst(e)}Renderer`]=t})),s.default.renderers.registerRenderer=O.registerRenderer,s.default.renderers.getRenderer=O.getRenderer,s.default.validators=null!==(l=s.default.validators)&&void 0!==l?l:{},m.arrayEach((0,I.getRegisteredValidatorNames)(),(e=>{s.default.validators[`${N.toUpperCaseFirst(e)}Validator`]=(0,I.getValidator)(e)})),s.default.validators.registerValidator=I.registerValidator,s.default.validators.getValidator=I.getValidator,s.default.plugins=null!==(h=s.default.plugins)&&void 0!==h?h:{},m.arrayEach((0,P.getPluginsNames)(),(e=>{s.default.plugins[e]=(0,P.getPlugin)(e)})),s.default.plugins[`${N.toUpperCaseFirst(L.BasePlugin.PLUGIN_KEY)}Plugin`]=L.BasePlugin,s.default.plugins.registerPlugin=P.registerPlugin,s.default.plugins.getPlugin=P.getPlugin;t.default=s.default},70292:(e,t,r)=>{"use strict";t.__esModule=!0,r(15724);var n=r(10587),s=r(25499);const i={_hooksStorage:Object.create(null),addHook(e,t){return this._hooksStorage[e]||(this._hooksStorage[e]=[]),this.hot.addHook(e,t),this._hooksStorage[e].push(t),this},removeHooksByKey(e){(0,n.arrayEach)(this._hooksStorage[e]||[],(t=>{this.hot.removeHook(e,t)}))},clearHooks(){(0,s.objectEach)(this._hooksStorage,((e,t)=>this.removeHooksByKey(t))),this._hooksStorage={}}};(0,s.defineGetter)(i,"MIXIN_NAME","hooksRefRegisterer",{writable:!1,enumerable:!1});t.default=i},16050:(e,t,r)=>{"use strict";t.__esModule=!0,r(15724);var n=r(25499),s=r(89804);const i={_localHooks:Object.create(null),addLocalHook(e,t){return this._localHooks[e]||(this._localHooks[e]=[]),this._localHooks[e].push(t),this},runLocalHooks(e,t,r,n,i,o,a){if(this._localHooks[e]){const l=this._localHooks[e].length;for(let h=0;h<l;h++)(0,s.fastCall)(this._localHooks[e][h],this,t,r,n,i,o,a)}},clearLocalHooks(){return this._localHooks={},this}};(0,n.defineGetter)(i,"MIXIN_NAME","localHooks",{writable:!1,enumerable:!1});t.default=i},2998:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724),r(14846),r(27458),r(69655),r(90458);var s=n(r(85707)),i=r(75089),o=r(85992),a=n(r(4965)),l=r(28197),h=r(25499),u=r(22137),c=n(r(93968)),d=r(5893),p=r(50206),g=r(61149);function f(e,t,r){m(e,t),t.set(e,r)}function m(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function y(e,t){return e.get(w(e,t))}function E(e,t,r){return e.set(w(e,t),r),r}function w(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}l.Hooks.getSingleton().register("modifyAutoColumnSizeSeed");const C=t.PLUGIN_KEY="autoColumnSize",v=t.PLUGIN_PRIORITY=10;var R=new WeakMap,S=new WeakMap,T=new WeakSet;class N extends i.BasePlugin{static get PLUGIN_KEY(){return C}static get PLUGIN_PRIORITY(){return v}static get SETTING_KEYS(){return!0}static get DEFAULT_SETTINGS(){return{useHeaders:!0,samplingRatio:null,allowSampleDuplicates:!1}}static get CALCULATION_STEP(){return 50}static get SYNC_CALCULATION_LIMIT(){return 50}constructor(e){var t,r;super(e),m(t=this,r=T),r.add(t),(0,s.default)(this,"ghostTable",new a.default(this.hot)),(0,s.default)(this,"samplesGenerator",new c.default(((e,t)=>{const r=this.hot.toPhysicalRow(e),n=this.hot.toPhysicalColumn(t);if(this.hot.rowIndexMapper.isHidden(r)||this.hot.columnIndexMapper.isHidden(n))return!1;const s=this.hot.getCellMeta(e,t);let i="";s.spanned||(i=this.hot.getDataAtCell(e,t));let o="";return this.hot.hasHook("modifyAutoColumnSizeSeed")&&(o=this.hot.runHooks("modifyAutoColumnSizeSeed",o,s,i)),{value:i,bundleSeed:o}}))),(0,s.default)(this,"inProgress",!1),(0,s.default)(this,"measuredColumns",0),(0,s.default)(this,"columnWidthsMap",new g.PhysicalIndexToValueMap),f(this,R,[]),f(this,S,[]),this.hot.columnIndexMapper.registerMap("autoColumnSize",this.columnWidthsMap),this.addHook("beforeColumnResize",((e,t,r)=>w(T,this,O).call(this,e,t,r)))}isEnabled(){return!1!==this.hot.getSettings()[C]&&!this.hot.getSettings().colWidths}enablePlugin(){var e=this;if(this.enabled)return;this.ghostTable.setSetting("useHeaders",this.getSetting("useHeaders")),this.samplesGenerator.setAllowDuplicates(this.getSetting("allowSampleDuplicates"));const t=this.getSetting("samplingRatio");t&&!isNaN(t)&&this.samplesGenerator.setSampleCount(parseInt(t,10)),this.addHook("afterLoadData",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return w(T,e,b).call(e,...r)})),this.addHook("beforeChangeRender",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return w(T,e,A).call(e,...r)})),this.addHook("afterFormulasValuesUpdate",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return w(T,e,x).call(e,...r)})),this.addHook("beforeRender",(()=>w(T,this,_).call(this))),this.addHook("modifyColWidth",((e,t)=>this.getColumnWidth(t,e))),this.addHook("init",(()=>w(T,this,I).call(this))),super.enablePlugin()}updatePlugin(){E(S,this,this.findColumnsWhereHeaderWasChanged()),super.updatePlugin()}disablePlugin(){super.disablePlugin(),this.addHook("beforeColumnResize",((e,t,r)=>w(T,this,O).call(this,e,t,r)))}calculateVisibleColumnsWidth(){if(!this.hot.countRows())return;const e=this.getFirstVisibleColumn(),t=this.getLastVisibleColumn();if(-1===e||-1===t)return;const r=this.hot.renderCall;this.calculateColumnsWidth({from:e,to:t},void 0,r)}calculateColumnsWidth(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{from:0,to:this.hot.countCols()-1},t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{from:0,to:this.hot.countRows()-1},r=arguments.length>2&&void 0!==arguments[2]&&arguments[2];const n="number"==typeof e?{from:e,to:e}:e,s="number"==typeof t?{from:t,to:t}:t;(0,u.rangeEach)(n.from,n.to,(e=>{let t=this.hot.toPhysicalColumn(e);if(null===t&&(t=e),r||null===this.columnWidthsMap.getValueAtIndex(t)&&!this.hot._getColWidthFromSettings(t)){this.samplesGenerator.generateColumnSamples(e,s).forEach(((e,t)=>this.ghostTable.addColumn(t,e)))}})),this.ghostTable.columns.length&&(this.hot.batchExecution((()=>{this.ghostTable.getWidths(((e,t)=>{const r=this.hot.toPhysicalColumn(e);this.columnWidthsMap.setValueAtIndex(r,t)}))}),!0),this.measuredColumns=n.to+1,this.ghostTable.clean())}calculateAllColumnsWidth(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{from:0,to:this.hot.countRows()-1},t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],r=0;const n=this.hot.countCols()-1;let s=null;this.inProgress=!0;const i=()=>{if(!this.hot)return(0,o.cancelAnimationFrame)(s),void(this.inProgress=!1);this.calculateColumnsWidth({from:r,to:Math.min(r+N.CALCULATION_STEP,n)},e,t),r=r+N.CALCULATION_STEP+1,r<n?s=(0,o.requestAnimationFrame)(i):((0,o.cancelAnimationFrame)(s),this.inProgress=!1,this.hot.view.adjustElementsSize())},a=this.getSyncCalculationLimit();a>=0&&(this.calculateColumnsWidth({from:0,to:a},e,t),r=a+1),r<n?i():this.inProgress=!1}recalculateAllColumnsWidth(){this.hot.view.isVisible()&&this.calculateAllColumnsWidth({from:0,to:this.hot.countRows()-1},!0)}getSyncCalculationLimit(){const e=this.hot.getSettings()[C];let t=N.SYNC_CALCULATION_LIMIT;const r=this.hot.countCols()-1;return(0,h.isObject)(e)&&(t=e.syncLimit,(0,d.isPercentValue)(t)?t=(0,u.valueAccordingPercent)(r,t):t>>=0),Math.min(t,r)}getColumnWidth(e,t){let r=!(arguments.length>2&&void 0!==arguments[2])||arguments[2],n=t;return void 0===n&&(n=this.columnWidthsMap.getValueAtIndex(this.hot.toPhysicalColumn(e)),r&&"number"==typeof n&&(n=Math.max(n,p.DEFAULT_COLUMN_WIDTH))),n}getFirstVisibleColumn(){var e;return null!==(e=this.hot.getFirstRenderedVisibleColumn())&&void 0!==e?e:-1}getLastVisibleColumn(){var e;return null!==(e=this.hot.getLastRenderedVisibleColumn())&&void 0!==e?e:-1}findColumnsWhereHeaderWasChanged(){return this.hot.getColHeader().reduce(((e,t,r)=>{const n=y(R,this).length;return(n-1<r||y(R,this)[r]!==t)&&e.push(this.hot.toVisualColumn(r)),n-1<r?y(R,this).push(t):y(R,this)[r]=t,e}),[])}clearCache(e){Array.isArray(e)?this.hot.batchExecution((()=>{e.forEach((e=>{this.columnWidthsMap.setValueAtIndex(e,null)}))}),!0):this.columnWidthsMap.clear()}isNeedRecalculate(){return!!this.columnWidthsMap.getValues().slice(0,this.measuredColumns).filter((e=>null===e)).length}destroy(){this.ghostTable.clean(),super.destroy()}}function M(e){const t={from:0,to:this.hot.countRows()-1};e.forEach((e=>{const r=this.hot.toPhysicalColumn(e);if(null!==r&&!this.hot._getColWidthFromSettings(r)){this.samplesGenerator.generateColumnSamples(e,t).forEach(((e,t)=>this.ghostTable.addColumn(t,e)))}})),this.ghostTable.columns.length&&(this.hot.batchExecution((()=>{this.ghostTable.getWidths(((e,t)=>{const r=this.hot.toPhysicalColumn(e);this.columnWidthsMap.setValueAtIndex(r,t)}))}),!0),this.ghostTable.clean())}function _(){this.calculateVisibleColumnsWidth(),this.inProgress||(w(T,this,M).call(this,y(S,this)),E(S,this,[]))}function b(e,t){t||this.recalculateAllColumnsWidth()}function A(e){const t=e.reduce(((e,t)=>{let[,r]=t;const n=this.hot.propToCol(r);return Number.isInteger(n)&&-1===e.indexOf(n)&&e.push(n),e}),[]);y(S,this).push(...t)}function O(e,t,r){let n=e;return r&&(this.calculateColumnsWidth(t,void 0,!0),n=this.getColumnWidth(t,void 0,!1)),n}function I(){E(R,this,this.hot.getColHeader()),this.recalculateAllColumnsWidth()}function x(e){const t=e.reduce(((e,t)=>{var r;const n=null===(r=t.address)||void 0===r?void 0:r.col;if(Number.isInteger(n)){const t=this.hot.toVisualColumn(n);-1===e.indexOf(t)&&e.push(t)}return e}),[]);y(S,this).push(...t)}t.AutoColumnSize=N},49912:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(2998);t.PLUGIN_KEY=n.PLUGIN_KEY,t.PLUGIN_PRIORITY=n.PLUGIN_PRIORITY,t.AutoColumnSize=n.AutoColumnSize},7496:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724),r(14846),r(27458),r(69655),r(90458);var s=n(r(85707)),i=r(75089),o=r(85992),a=n(r(4965)),l=r(25499),h=r(22137),u=n(r(93968)),c=r(5893),d=r(61149);function p(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function g(e,t){return e.get(f(e,t))}function f(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}const m=t.PLUGIN_KEY="autoRowSize",y=t.PLUGIN_PRIORITY=40;var E=new WeakMap,w=new WeakSet;class C extends i.BasePlugin{static get PLUGIN_KEY(){return m}static get PLUGIN_PRIORITY(){return y}static get SETTING_KEYS(){return!0}static get DEFAULT_SETTINGS(){return{useHeaders:!0,samplingRatio:null,allowSampleDuplicates:!1}}static get CALCULATION_STEP(){return 50}static get SYNC_CALCULATION_LIMIT(){return 500}constructor(e){var t,r;super(e),p(t=this,r=w),r.add(t),(0,s.default)(this,"headerHeight",null),(0,s.default)(this,"ghostTable",new a.default(this.hot)),(0,s.default)(this,"samplesGenerator",new u.default(((e,t)=>{const r=this.hot.toPhysicalRow(e),n=this.hot.toPhysicalColumn(t);if(this.hot.rowIndexMapper.isHidden(r)||this.hot.columnIndexMapper.isHidden(n))return!1;if(e>=0&&t>=0){if(this.hot.getCellMeta(e,t).hidden)return!1}let s;return e>=0?s=this.hot.getDataAtCell(e,t):-1===e&&(s=this.hot.getColHeader(t)),{value:s}}))),(0,s.default)(this,"inProgress",!1),(0,s.default)(this,"measuredRows",0),(0,s.default)(this,"rowHeightsMap",new d.PhysicalIndexToValueMap),function(e,t,r){p(e,t),t.set(e,r)}(this,E,[]),this.hot.rowIndexMapper.registerMap("autoRowSize",this.rowHeightsMap),this.addHook("beforeRowResize",((e,t,r)=>f(w,this,S).call(this,e,t,r)))}isEnabled(){const e=this.hot.getSettings()[m];return!0===e||(0,l.isObject)(e)}enablePlugin(){var e=this;if(this.enabled)return;this.samplesGenerator.setAllowDuplicates(this.getSetting("allowSampleDuplicates"));const t=this.getSetting("samplingRatio");t&&!isNaN(t)&&this.samplesGenerator.setSampleCount(parseInt(t,10)),this.addHook("afterLoadData",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return f(w,e,T).call(e,...r)})),this.addHook("beforeChangeRender",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return f(w,e,N).call(e,...r)})),this.addHook("beforeColumnResize",(()=>this.recalculateAllRowsHeight())),this.addHook("afterFormulasValuesUpdate",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return f(w,e,_).call(e,...r)})),this.addHook("beforeRender",(()=>f(w,this,R).call(this))),this.addHook("modifyRowHeight",((e,t)=>this.getRowHeight(t,e))),this.addHook("init",(()=>f(w,this,M).call(this))),this.addHook("modifyColumnHeaderHeight",(()=>this.getColumnHeaderHeight())),super.enablePlugin()}disablePlugin(){this.headerHeight=null,super.disablePlugin(),this.addHook("beforeRowResize",((e,t,r)=>f(w,this,S).call(this,e,t,r)))}calculateVisibleRowsHeight(){if(!this.hot.countCols())return;const e=this.getFirstVisibleRow(),t=this.getLastVisibleRow();if(-1===e||-1===t)return;const r=this.hot.renderCall;this.calculateRowsHeight({from:e,to:t},void 0,r)}calculateRowsHeight(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{from:0,to:this.hot.countRows()-1},t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{from:0,to:this.hot.countCols()-1},r=arguments.length>2&&void 0!==arguments[2]&&arguments[2];const n="number"==typeof e?{from:e,to:e}:e,s="number"==typeof t?{from:t,to:t}:t;if(null!==this.hot.getColHeader(0)){const e=this.samplesGenerator.generateRowSamples(-1,s);this.ghostTable.addColumnHeadersRow(e.get(-1))}(0,h.rangeEach)(n.from,n.to,(e=>{let t=this.hot.toPhysicalRow(e);if(null===t&&(t=e),r||null===this.rowHeightsMap.getValueAtIndex(t)){this.samplesGenerator.generateRowSamples(e,s).forEach(((e,t)=>this.ghostTable.addRow(t,e)))}})),this.ghostTable.rows.length&&(this.hot.batchExecution((()=>{this.ghostTable.getHeights(((e,t)=>{e<0?this.headerHeight=t:this.rowHeightsMap.setValueAtIndex(this.hot.toPhysicalRow(e),t)}))}),!0),this.measuredRows=n.to+1,this.ghostTable.clean())}calculateAllRowsHeight(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{from:0,to:this.hot.countCols()-1},t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],r=0;const n=this.hot.countRows()-1;let s=null;this.inProgress=!0;const i=()=>{if(!this.hot)return(0,o.cancelAnimationFrame)(s),void(this.inProgress=!1);this.calculateRowsHeight({from:r,to:Math.min(r+C.CALCULATION_STEP,n)},e,t),r=r+C.CALCULATION_STEP+1,r<n?s=(0,o.requestAnimationFrame)(i):((0,o.cancelAnimationFrame)(s),this.inProgress=!1,this.hot.view.adjustElementsSize(),this.hot.view._wt.wtOverlays.inlineStartOverlay.needFullRender&&this.hot.view._wt.wtOverlays.inlineStartOverlay.clone.draw())},a=this.getSyncCalculationLimit();a>=0&&(this.calculateRowsHeight({from:0,to:a},e,t),r=a+1),r<n?i():(this.inProgress=!1,this.hot.view.adjustElementsSize())}recalculateAllRowsHeight(){this.hot.view.isVisible()&&this.calculateAllRowsHeight({from:0,to:this.hot.countCols()-1},!0)}getSyncCalculationLimit(){const e=this.hot.getSettings()[m];let t=C.SYNC_CALCULATION_LIMIT;const r=this.hot.countRows()-1;return(0,l.isObject)(e)&&(t=e.syncLimit,(0,c.isPercentValue)(t)?t=(0,h.valueAccordingPercent)(r,t):t>>=0),Math.min(t,r)}getRowHeight(e,t){const r=e<0?this.headerHeight:this.rowHeightsMap.getValueAtIndex(this.hot.toPhysicalRow(e));let n=t;return null!==r&&r>(t||0)&&(n=r),n}getColumnHeaderHeight(){return this.headerHeight}getFirstVisibleRow(){var e;return null!==(e=this.hot.getFirstRenderedVisibleRow())&&void 0!==e?e:-1}getLastVisibleRow(){var e;return null!==(e=this.hot.getLastRenderedVisibleRow())&&void 0!==e?e:-1}clearCache(e){this.headerHeight=null,Array.isArray(e)?this.hot.batchExecution((()=>{e.forEach((e=>{this.rowHeightsMap.setValueAtIndex(e,null)}))}),!0):this.rowHeightsMap.clear()}clearCacheByRange(e){const{from:t,to:r}="number"==typeof e?{from:e,to:e}:e;this.hot.batchExecution((()=>{(0,h.rangeEach)(Math.min(t,r),Math.max(t,r),(e=>{this.rowHeightsMap.setValueAtIndex(e,null)}))}),!0)}isNeedRecalculate(){return!!this.rowHeightsMap.getValues().slice(0,this.measuredRows).filter((e=>null===e)).length}destroy(){this.ghostTable.clean(),super.destroy()}}function v(e){const t={from:0,to:this.hot.countCols()-1};e.forEach((e=>{this.samplesGenerator.generateRowSamples(e,t).forEach(((e,t)=>this.ghostTable.addRow(t,e)))})),this.ghostTable.rows.length&&(this.hot.batchExecution((()=>{this.ghostTable.getHeights(((e,t)=>{const r=this.hot.toPhysicalRow(e);this.rowHeightsMap.setValueAtIndex(r,t)}))}),!0),this.ghostTable.clean())}function R(){var e,t,r;this.calculateVisibleRowsHeight(),this.inProgress||(f(w,this,v).call(this,g(E,this)),t=this,r=[],(e=E).set(f(e,t),r))}function S(e,t,r){let n=e;return r&&(this.calculateRowsHeight(t,void 0,!0),n=this.getRowHeight(t)),n}function T(e,t){t||this.recalculateAllRowsHeight()}function N(e){const t=e.reduce(((e,t)=>{let[r]=t;return-1===e.indexOf(r)&&e.push(r),e}),[]);g(E,this).push(...t)}function M(){this.recalculateAllRowsHeight()}function _(e){const t=e.reduce(((e,t)=>{var r;const n=null===(r=t.address)||void 0===r?void 0:r.row;if(Number.isInteger(n)){const t=this.hot.toVisualRow(n);-1===e.indexOf(t)&&e.push(t)}return e}),[]);g(E,this).push(...t)}t.AutoRowSize=C},27864:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(7496);t.PLUGIN_KEY=n.PLUGIN_KEY,t.PLUGIN_PRIORITY=n.PLUGIN_PRIORITY,t.AutoRowSize=n.AutoRowSize},46222:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724);var s=n(r(85707)),i=r(75089),o=r(28197),a=r(62577),l=r(10587),h=r(70505),u=r(69615);function c(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function d(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}o.Hooks.getSingleton().register("modifyAutofillRange"),o.Hooks.getSingleton().register("beforeAutofill"),o.Hooks.getSingleton().register("afterAutofill");const p=t.PLUGIN_KEY="autofill",g=t.PLUGIN_PRIORITY=20,f=["fillHandle"];var m=new WeakSet;class y extends i.BasePlugin{constructor(){super(...arguments),c(this,m),(0,s.default)(this,"addingStarted",!1),(0,s.default)(this,"mouseDownOnCellCorner",!1),(0,s.default)(this,"mouseDragOutside",!1),(0,s.default)(this,"handleDraggedCells",0),(0,s.default)(this,"directions",[]),(0,s.default)(this,"autoInsertRow",!1)}static get PLUGIN_KEY(){return p}static get PLUGIN_PRIORITY(){return g}static get SETTING_KEYS(){return[p,...f]}isEnabled(){return this.hot.getSettings().fillHandle}enablePlugin(){this.enabled||(this.mapSettings(),this.registerEvents(),this.addHook("afterOnCellCornerMouseDown",(e=>d(m,this,w).call(this,e))),this.addHook("afterOnCellCornerDblClick",(e=>d(m,this,E).call(this,e))),this.addHook("beforeOnCellMouseOver",((e,t)=>d(m,this,C).call(this,t))),super.enablePlugin())}updatePlugin(){this.disablePlugin(),this.enablePlugin(),super.updatePlugin()}disablePlugin(){this.clearMappedSettings(),super.disablePlugin()}getSelectionData(){const e=this.hot.getSelectedRangeLast(),{row:t,col:r}=e.getTopStartCorner(),{row:n,col:s}=e.getBottomEndCorner(),i=this.hot.runHooks("modifyCopyableRange",[{startRow:t,startCol:r,endRow:n,endCol:s}]),o=[],a=[],h=[];return(0,l.arrayEach)(i,(e=>{for(let t=e.startRow;t<=e.endRow;t+=1)-1===o.indexOf(t)&&o.push(t);for(let t=e.startCol;t<=e.endCol;t+=1)-1===a.indexOf(t)&&a.push(t)})),(0,l.arrayEach)(o,(e=>{const t=[];(0,l.arrayEach)(a,(r=>{t.push(this.hot.getCopyableData(e,r))})),h.push(t)})),h}fillIn(){if(this.hot.selection.highlight.getFill().isEmpty())return!1;const[e,t,r,n]=this.hot.selection.highlight.getFill().getVisualCorners(),s=this.hot.getSelectedRangeLast(),i=s.getTopStartCorner(),o=s.getBottomEndCorner();this.resetSelectionOfDraggedArea();const a=[i.row,i.col,o.row,o.col],l=this.hot.runHooks("modifyAutofillRange",[Math.min(i.row,e),Math.min(i.col,t),Math.max(o.row,r),Math.max(o.col,n)],a),{directionOfDrag:h,startOfDragCoords:c,endOfDragCoords:d}=(0,u.getDragDirectionAndRange)(a,l,((e,t)=>this.hot._createCellCoords(e,t)));if(c&&c.row>-1&&c.col>-1){const e=this.getSelectionData(),t=s.clone(),r=this.hot._createCellRange(c,c,d),n=this.hot.runHooks("beforeAutofill",e,t,r,h);if(!1===n)return this.hot.selection.highlight.getFill().clear(),this.hot.render(),!1;let i=n;const o=n;if(["up","left"].indexOf(h)>-1&&(1!==o.length||0!==o[0].length))if(i=[],"up"===h){const e=d.row-c.row+1,t=e%o.length;for(let r=0;r<e;r++)i.push(o[(r+(o.length-t))%o.length])}else{const e=d.col-c.col+1,t=e%o[0].length;for(let r=0;r<o.length;r++){i.push([]);for(let n=0;n<e;n++)i[r].push(o[r][(n+(o[r].length-t))%o[r].length])}}this.hot.populateFromArray(c.row,c.col,i,d.row,d.col,`${this.pluginName}.fill`,null),this.setSelection(l),this.hot.runHooks("afterAutofill",i,t,r,h),this.hot.render()}else this.hot.view.render();return!0}reduceSelectionAreaIfNeeded(e){return e.row<0&&(e.row=0),e.col<0&&(e.col=0),e}getCoordsOfDragAndDropBorders(e){const t=this.hot.getSelectedRangeLast(),r=t.getBottomEndCorner();let n=e;if(this.directions.includes(u.DIRECTIONS.vertical)&&this.directions.includes(u.DIRECTIONS.horizontal)){const s=t.getTopStartCorner();(r.col<=e.col||s.col>=e.col)&&(n=this.hot._createCellCoords(r.row,e.col)),(r.row<e.row||s.row>e.row)&&(n=this.hot._createCellCoords(e.row,r.col))}else if(this.directions.includes(u.DIRECTIONS.vertical))n=this.hot._createCellCoords(e.row,r.col);else{if(!this.directions.includes(u.DIRECTIONS.horizontal))return;n=this.hot._createCellCoords(r.row,e.col)}return this.reduceSelectionAreaIfNeeded(n)}showBorder(e){const t=this.getCoordsOfDragAndDropBorders(e);t&&this.redrawBorders(t)}addRow(){this.hot._registerTimeout((()=>{this.hot.alter("insert_row_below",void 0,1,`${this.pluginName}.fill`),this.addingStarted=!1}),200)}addNewRowIfNeeded(){if(!this.hot.selection.highlight.getFill().isEmpty()&&!1===this.addingStarted&&this.autoInsertRow){const e=this.hot.getSelectedLast(),t=this.hot.selection.highlight.getFill().getVisualCorners(),r=this.hot.countRows();e[2]<r-1&&t[2]===r-1&&(this.addingStarted=!0,this.addRow())}}getIndexOfLastAdjacentFilledInRow(e){const t=this.hot.getData(),r=this.hot.countRows();let n;for(let s=e[2]+1;s<r;s++){for(let r=e[1];r<=e[3];r++){const e=t[s][r];if(!(0,h.isEmpty)(e))return-1}const r=t[s][e[1]-1],i=t[s][e[3]+1];(0,h.isEmpty)(r)&&(0,h.isEmpty)(i)||(n=s)}return n}addSelectionFromStartAreaToSpecificRowIndex(e,t){this.hot.selection.highlight.getFill().clear().add(this.hot._createCellCoords(e[0],e[1])).add(this.hot._createCellCoords(t,e[3])).commit()}setSelection(e){this.hot.selectCell(...(0,l.arrayMap)(e,(e=>Math.max(e,0))),!1,!1)}selectAdjacent(){const e=this.hot.getSelectedLast(),t=this.getIndexOfLastAdjacentFilledInRow(e);return-1!==t&&void 0!==t&&(this.addSelectionFromStartAreaToSpecificRowIndex(e,t),!0)}resetSelectionOfDraggedArea(){this.handleDraggedCells=0,this.hot.selection.highlight.getFill().clear()}redrawBorders(e){this.hot.selection.highlight.getFill().clear().add(this.hot.getSelectedRangeLast().from).add(this.hot.getSelectedRangeLast().to).add(e).commit(),this.hot.view.render()}getIfMouseWasDraggedOutside(e){const{documentElement:t}=this.hot.rootDocument,r=(0,a.offset)(this.hot.table).top-(this.hot.rootWindow.pageYOffset||t.scrollTop)+(0,a.outerHeight)(this.hot.table),n=(0,a.offset)(this.hot.table).left-(this.hot.rootWindow.pageXOffset||t.scrollLeft)+(0,a.outerWidth)(this.hot.table);return e.clientY>r&&e.clientX<=n}registerEvents(){const{documentElement:e}=this.hot.rootDocument;this.eventManager.addEventListener(e,"mouseup",(()=>d(m,this,v).call(this))),this.eventManager.addEventListener(e,"mousemove",(e=>d(m,this,R).call(this,e)))}clearMappedSettings(){this.directions.length=0,this.autoInsertRow=!1}mapSettings(){const e=(0,u.getMappedFillHandleSetting)(this.hot.getSettings().fillHandle);this.directions=e.directions,this.autoInsertRow=e.autoInsertRow}destroy(){super.destroy()}}function E(){this.selectAdjacent()&&this.fillIn()}function w(){this.handleDraggedCells=1,this.mouseDownOnCellCorner=!0}function C(e){this.mouseDownOnCellCorner&&!this.hot.view.isMouseDown()&&this.handleDraggedCells&&(this.handleDraggedCells+=1,this.showBorder(e),this.addNewRowIfNeeded())}function v(){this.handleDraggedCells&&(this.handleDraggedCells>1&&this.fillIn(),this.handleDraggedCells=0,this.mouseDownOnCellCorner=!1)}function R(e){const t=this.getIfMouseWasDraggedOutside(e);!1===this.addingStarted&&this.handleDraggedCells>0&&t?(this.mouseDragOutside=!0,this.addingStarted=!0):this.mouseDragOutside=!1,this.mouseDragOutside&&this.autoInsertRow&&this.addRow()}t.Autofill=y},32894:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(46222);t.PLUGIN_KEY=n.PLUGIN_KEY,t.PLUGIN_PRIORITY=n.PLUGIN_PRIORITY,t.Autofill=n.Autofill},69615:(e,t,r)=>{"use strict";t.__esModule=!0,t.getDragDirectionAndRange=function(e,t,r){let n,s,i;t[0]===e[0]&&t[1]<e[1]?(i="left",n=r(t[0],t[1]),s=r(t[2],e[1]-1)):t[2]===e[2]&&t[0]===e[0]&&t[3]>e[3]?(i="right",n=r(t[0],e[3]+1),s=r(t[2],t[3])):t[0]<e[0]&&t[1]===e[1]?(i="up",n=r(t[0],t[1]),s=r(e[0]-1,t[3])):t[2]>e[2]&&t[1]===e[1]&&(i="down",n=r(e[2]+1,t[1]),s=r(t[2],t[3]));n&&n.normalize();s&&s.normalize();return{directionOfDrag:i,startOfDragCoords:n,endOfDragCoords:s}},t.getMappedFillHandleSetting=function(e){const t={};!0===e?(t.directions=Object.keys(i),t.autoInsertRow=!0):(0,n.isObject)(e)?((0,s.isDefined)(e.autoInsertRow)?e.direction===i.horizontal?t.autoInsertRow=!1:t.autoInsertRow=e.autoInsertRow:t.autoInsertRow=!1,(0,s.isDefined)(e.direction)?t.directions=[e.direction]:t.directions=Object.keys(i)):"string"==typeof e?(t.directions=[e],t.autoInsertRow=!0):(t.directions=[],t.autoInsertRow=!1);return t};var n=r(25499),s=r(70505);const i=t.DIRECTIONS={horizontal:"horizontal",vertical:"vertical"}},57764:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724),r(14846),r(69655);var s=n(r(85707)),i=r(25499),o=r(10587),a=r(74672),l=r(1791),h=r(8266),u=r(54852),c=r(17027),d=n(r(3849));function p(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function g(e,t){return e.get(f(e,t))}function f(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}const m=new Map([["plugin",a.hasPlugin],["cell-type",l.hasCellType],["editor",h.hasEditor],["renderer",u.hasRenderer],["validator",c.hasValidator]]),y=t.defaultMainSettingSymbol=Symbol("mainSetting"),E=t.PLUGIN_KEY="base",w=[];let C=null;var v=new WeakMap,R=new WeakSet;function S(e){if(!e)return!1;const t=this.constructor.SETTING_KEYS;if("boolean"==typeof t)return t;for(let r=0;r<t.length;r++)if(void 0!==e[t[r]])return!0;return!1}t.BasePlugin=class{static get PLUGIN_KEY(){return E}static get SETTING_KEYS(){return[this.PLUGIN_KEY]}static get DEFAULT_SETTINGS(){return{}}constructor(e){var t,r;p(t=this,r=R),r.add(t),(0,s.default)(this,"eventManager",new d.default(this)),(0,s.default)(this,"pluginName",null),(0,s.default)(this,"pluginsInitializedCallbacks",[]),(0,s.default)(this,"isPluginsReady",!1),(0,s.default)(this,"enabled",!1),(0,s.default)(this,"initialized",!1),function(e,t,r){p(e,t),t.set(e,r)}(this,v,{}),(0,i.defineGetter)(this,"hot",e,{writable:!1}),C=null,this.hot.addHook("afterPluginsInitialized",(()=>this.onAfterPluginsInitialized())),this.hot.addHook("afterUpdateSettings",(e=>this.onUpdateSettings(e))),this.hot.addHook("beforeInit",(()=>this.init()))}init(){this.pluginName=this.hot.getPluginName(this);const e=this.constructor.PLUGIN_DEPS,t=Array.isArray(e)?e:[];if(t.length>0){const e=[];if(t.forEach((t=>{const[r,n]=t.split(":");if(!m.has(r))throw new Error(`Unknown plugin dependency type "${r}" was found.`);m.get(r)(n)||e.push(` - ${n} (${r})`)})),e.length>0){const t=[`The ${this.pluginName} plugin requires the following modules:\n`,`${e.join("\n")}\n`].join("");w.push(t)}}C||(C=(0,a.getPluginsNames)()),C.indexOf("UndoRedo")>=0&&C.splice(C.indexOf("UndoRedo"),1),C.indexOf(this.pluginName)>=0&&C.splice(C.indexOf(this.pluginName),1),this.hot.addHookOnce("afterPluginsInitialized",(()=>{this.isEnabled&&this.isEnabled()&&this.enablePlugin()}));if(0===C.length){if(w.length>0){const e=[`${w.join("\n")}\n`,"You have to import and register them manually."].join("");throw w.length=0,new Error(e)}this.hot.runHooks("afterPluginsInitialized")}this.initialized=!0}enablePlugin(){this.enabled=!0}disablePlugin(){var e;null===(e=this.eventManager)||void 0===e||e.clear(),this.clearHooks(),this.enabled=!1}getSetting(e){const t=this.hot.getSettings()[this.constructor.PLUGIN_KEY];if(void 0===e)return t;const r=this.constructor.DEFAULT_SETTINGS;var n,s;return(Array.isArray(t)||(0,i.isObject)(t))&&r[y]===e?Array.isArray(t)?t:null!==(n=t[e])&&void 0!==n?n:r[e]:(0,i.isObject)(t)&&null!==(s=t[e])&&void 0!==s?s:r[e]}addHook(e,t,r){g(v,this)[e]=g(v,this)[e]||[];const n=g(v,this)[e];this.hot.addHook(e,t,r),n.push(t),g(v,this)[e]=n}removeHooks(e){(0,o.arrayEach)(g(v,this)[e]||[],(t=>{this.hot.removeHook(e,t)}))}clearHooks(){const e=g(v,this);(0,i.objectEach)(e,((e,t)=>this.removeHooks(t))),e.length=0}callOnPluginsReady(e){this.isPluginsReady?e():this.pluginsInitializedCallbacks.push(e)}onAfterPluginsInitialized(){(0,o.arrayEach)(this.pluginsInitializedCallbacks,(e=>e())),this.pluginsInitializedCallbacks.length=0,this.isPluginsReady=!0}onUpdateSettings(e){const t=f(R,this,S).call(this,e);this.isEnabled&&(this.enabled&&!this.isEnabled()&&this.disablePlugin(),!this.enabled&&this.isEnabled()&&this.enablePlugin(),this.enabled&&this.isEnabled()&&t&&this.updatePlugin(e))}updatePlugin(){}destroy(){var e;null===(e=this.eventManager)||void 0===e||e.destroy(),this.clearHooks(),(0,i.objectEach)(this,((e,t)=>{"hot"!==t&&(this[t]=null)})),delete this.t,delete this.hot}}},75089:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(57764);t.PLUGIN_KEY=n.PLUGIN_KEY,t.BasePlugin=n.BasePlugin,t.defaultMainSettingSymbol=n.defaultMainSettingSymbol},73296:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),i=r(75089),o=n(r(32022)),a=n(r(44147));function l(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}const h=t.PLUGIN_KEY="bindRowsWithHeaders",u=t.PLUGIN_PRIORITY=210,c=new Map([["loose",o.default],["strict",a.default]]);var d=new WeakSet;class p extends i.BasePlugin{constructor(){super(...arguments),l(this,d),(0,s.default)(this,"headerIndexes",null)}static get PLUGIN_KEY(){return h}static get PLUGIN_PRIORITY(){return u}isEnabled(){return!!this.hot.getSettings()[h]}enablePlugin(){var e;if(this.enabled)return;const t=null!==(e=c.get(this.getSetting()))&&void 0!==e?e:c.get("loose");this.headerIndexes=this.hot.rowIndexMapper.registerMap("bindRowsWithHeaders",new t),this.addHook("modifyRowHeader",(e=>function(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}(d,this,g).call(this,e))),super.enablePlugin()}disablePlugin(){this.hot.rowIndexMapper.unregisterMap("bindRowsWithHeaders"),super.disablePlugin()}destroy(){super.destroy()}}function g(e){return this.headerIndexes.getValueAtIndex(this.hot.toPhysicalRow(e))}t.BindRowsWithHeaders=p},816:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(73296);t.PLUGIN_KEY=n.PLUGIN_KEY,t.PLUGIN_PRIORITY=n.PLUGIN_PRIORITY,t.BindRowsWithHeaders=n.BindRowsWithHeaders},32022:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(61149);const{getListWithInsertedItems:s,getListWithRemovedItems:i}=(0,n.alterUtilsFactory)("physicallyIndexed");class o extends n.IndexMap{constructor(){super((e=>e))}insert(e,t){const r=(0,n.getIncreasedIndexes)(this.indexedValues,t);this.indexedValues=s(r,e,t,this.initValueOrFn),super.insert(e,t)}remove(e){const t=i(this.indexedValues,e);this.indexedValues=(0,n.getDecreasedIndexes)(t,e),super.remove(e)}}t.default=o},44147:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(61149);const{getListWithInsertedItems:s,getListWithRemovedItems:i}=(0,n.alterUtilsFactory)("physicallyIndexed");class o extends n.IndexMap{constructor(){super((e=>e))}insert(e,t){this.indexedValues=s(this.indexedValues,e,t,((e,t)=>this.getNextValue(t))),super.insert(e,t)}remove(e){this.indexedValues=i(this.indexedValues,e),super.remove(e)}getNextValue(e){return Math.max(...this.getValues())+1+e}}t.default=o},39152:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724);var s=n(r(85707)),i=r(75089),o=r(10587),a=r(22137),l=r(14859),h=r(62577),u=r(77661),c=r(92399),d=r(71120);function p(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function g(e,t){return e.get(m(e,t))}function f(e,t,r){return e.set(m(e,t),r),r}function m(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}const y=t.PLUGIN_KEY="collapsibleColumns",E=t.PLUGIN_PRIORITY=290,w=["nestedHeaders"],C="collapsibleIndicator",v=y,R=new Map([["collapse",{hideColumn:!0,beforeHook:"beforeColumnCollapse",afterHook:"afterColumnCollapse"}],["expand",{hideColumn:!1,beforeHook:"beforeColumnExpand",afterHook:"afterColumnExpand"}]]);var S=new WeakMap,T=new WeakSet;class N extends i.BasePlugin{constructor(){var e,t;super(...arguments),p(e=this,t=T),t.add(e),(0,s.default)(this,"nestedHeadersPlugin",null),(0,s.default)(this,"headerStateManager",null),function(e,t,r){p(e,t),t.set(e,r)}(this,S,null)}static get PLUGIN_KEY(){return y}static get PLUGIN_PRIORITY(){return E}static get PLUGIN_DEPS(){return["plugin:NestedHeaders"]}static get SETTING_KEYS(){return[y,...w]}isEnabled(){return!!this.hot.getSettings()[y]}enablePlugin(){var e=this;if(this.enabled)return;const{nestedHeaders:t}=this.hot.getSettings();t||(0,l.warn)("You need to configure the Nested Headers plugin in order to use collapsible headers."),f(S,this,this.hot.columnIndexMapper.createAndRegisterIndexMap(this.pluginName,"hiding")),this.nestedHeadersPlugin=this.hot.getPlugin("nestedHeaders"),this.headerStateManager=this.nestedHeadersPlugin.getStateManager(),this.addHook("init",(()=>m(T,this,b).call(this))),this.addHook("afterLoadData",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return m(T,e,A).call(e,...r)})),this.addHook("afterGetColHeader",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return m(T,e,M).call(e,...r)})),this.addHook("beforeOnCellMouseDown",((e,t,r)=>m(T,this,_).call(this,e,t,r))),this.registerShortcuts(),super.enablePlugin(),this.updatePlugin()}updatePlugin(){if(this.hot.view){if(!this.nestedHeadersPlugin.detectedOverlappedHeaders){const{collapsibleColumns:e}=this.hot.getSettings();"boolean"==typeof e?this.headerStateManager.mapState((e=>({collapsible:e.origColspan>1}))):Array.isArray(e)&&(this.headerStateManager.mapState((()=>({collapsible:!1}))),this.headerStateManager.mergeStateWith(e))}super.updatePlugin()}}disablePlugin(){this.hot.columnIndexMapper.unregisterMap(this.pluginName),f(S,this,null),this.nestedHeadersPlugin=null,this.unregisterShortcuts(),this.clearButtons(),super.disablePlugin()}registerShortcuts(){this.hot.getShortcutManager().getContext("grid").addShortcut({keys:[["Enter"]],callback:()=>{var e;const{row:t,col:r}=this.hot.getSelectedRangeLast().highlight,{collapsible:n,isCollapsed:s,columnIndex:i}=null!==(e=this.headerStateManager.getHeaderTreeNodeData(t,r))&&void 0!==e?e:{};if(n)return s?this.expandSection({row:t,col:i}):this.collapseSection({row:t,col:i}),!1},runOnlyIf:()=>{var e,t;return(null===(e=this.hot.getSelectedRangeLast())||void 0===e?void 0:e.isSingle())&&(null===(t=this.hot.getSelectedRangeLast())||void 0===t?void 0:t.highlight.isHeader())},group:v,relativeToGroup:c.EDITOR_EDIT_GROUP,position:"before"})}unregisterShortcuts(){this.hot.getShortcutManager().getContext("grid").removeShortcutsByGroup(v)}clearButtons(){if(!this.hot.view)return;const e=this.hot.view._wt.getSetting("columnHeaders").length,t=this.hot.view._wt.wtTable.THEAD,r=this.hot.view._wt.wtOverlays.topOverlay.clone.wtTable.THEAD,n=this.hot.view._wt.wtOverlays.topInlineStartCornerOverlay?this.hot.view._wt.wtOverlays.topInlineStartCornerOverlay.clone.wtTable.THEAD:null,s=function(e){e&&e.parentNode.removeChild(e)};(0,a.rangeEach)(0,e-1,(e=>{const i=t.childNodes[e],o=r.childNodes[e],l=n?n.childNodes[e]:null;(0,a.rangeEach)(0,i.childNodes.length-1,(e=>{let t=i.childNodes[e].querySelector(`.${C}`);s(t),o&&o.childNodes[e]&&(t=o.childNodes[e].querySelector(`.${C}`),s(t)),n&&l&&l.childNodes[e]&&(t=l.childNodes[e].querySelector(`.${C}`),s(t))}))}),!0)}expandSection(e){this.toggleCollapsibleSection([e],"expand")}collapseSection(e){this.toggleCollapsibleSection([e],"collapse")}toggleAllCollapsibleSections(e){const t=this.headerStateManager.mapNodes((t=>{const{collapsible:r,origColspan:n,headerLevel:s,columnIndex:i,isCollapsed:o}=t;if(!0===r&&n>1&&(o&&"expand"===e||!o&&"collapse"===e))return{row:this.headerStateManager.levelToRowCoords(s),col:i}}));this.toggleCollapsibleSection(t,e)}collapseAll(){this.toggleAllCollapsibleSections("collapse")}expandAll(){this.toggleAllCollapsibleSections("expand")}toggleCollapsibleSection(e,t){if(!R.has(t))throw new Error(`Unsupported action is passed (${t}).`);if(!Array.isArray(e))return;const r=(0,o.arrayFilter)(e,(e=>{let{row:t}=e;return t<0}));let n=r.length>0;(0,o.arrayEach)(r,(e=>{var r;let{row:s,col:i}=e;const{collapsible:o,isCollapsed:a}=null!==(r=this.headerStateManager.getHeaderSettings(s,i))&&void 0!==r?r:{};if(!o||a&&"collapse"===t||!a&&"expand"===t)return n=!1,!1}));const s=[],i=[];n&&(0,o.arrayEach)(r,(e=>{let{row:r,col:n}=e;const{colspanCompensation:o,affectedColumns:a,rollbackModification:l}=this.headerStateManager.triggerNodeModification(t,r,n);o>0&&(i.push(...a),s.push(l))}));const a=this.getCollapsedColumns();let l=[];"collapse"===t?l=(0,o.arrayUnique)([...a,...i]):"expand"===t&&(l=(0,o.arrayFilter)(a,(e=>!i.includes(e))));const h=R.get(t);if(!1===this.hot.runHooks(h.beforeHook,a,l,n))return void(0,o.arrayEach)(s,(e=>{e()}));this.hot.batchExecution((()=>{(0,o.arrayEach)(i,(e=>{g(S,this).setValueAtIndex(this.hot.toPhysicalColumn(e),h.hideColumn)}))}),!0);const u=this.getCollapsedColumns().length!==a.length,c=this.hot.getSelectedRangeLast();if("collapse"===t&&u&&c){const{row:e,col:t}=c.highlight;if((this.hot.rowIndexMapper.isHidden(e)||this.hot.columnIndexMapper.isHidden(t))&&i.includes(t)){const r=e>=0?this.hot.rowIndexMapper.getNearestNotHiddenIndex(e,1,!0):e,n=t>=0?this.hot.columnIndexMapper.getNearestNotHiddenIndex(t,1,!0):t;null!==r&&null!==n&&this.hot.selectCell(r,n)}}this.hot.runHooks(h.afterHook,a,l,n,u),this.hot.render(),this.hot.view.adjustElementsSize()}getCollapsedColumns(){return g(S,this).getHiddenIndexes()}destroy(){f(S,this,null),super.destroy()}}function M(e,t,r){var n;const{collapsible:s,origColspan:i,isCollapsed:o}=null!==(n=this.headerStateManager.getHeaderSettings(r,e))&&void 0!==n?n:{},a=s&&i>1&&e>=this.hot.getSettings().fixedColumnsStart,l=this.hot.getSettings().ariaTags;let u=t.querySelector(`.${C}`);var c;((0,h.removeAttribute)(t,[(0,d.A11Y_EXPANDED)("")[0]]),a)?(u||(u=this.hot.rootDocument.createElement("div"),(0,h.addClass)(u,C),t.querySelector("div:first-child").appendChild(u)),(0,h.removeClass)(u,["collapsed","expanded"]),o?((0,h.addClass)(u,"collapsed"),(0,h.fastInnerText)(u,"+"),l&&(0,h.setAttribute)(t,...(0,d.A11Y_EXPANDED)(!1))):((0,h.addClass)(u,"expanded"),(0,h.fastInnerText)(u,"-"),l&&(0,h.setAttribute)(t,...(0,d.A11Y_EXPANDED)(!0))),l&&(0,h.setAttribute)(u,...(0,d.A11Y_HIDDEN)())):null===(c=u)||void 0===c||c.remove()}function _(e,t){(0,h.hasClass)(e.target,C)&&((0,h.hasClass)(e.target,"expanded")?(this.eventManager.fireEvent(e.target,"mouseup"),this.toggleCollapsibleSection([t],"collapse")):(0,h.hasClass)(e.target,"collapsed")&&(this.eventManager.fireEvent(e.target,"mouseup"),this.toggleCollapsibleSection([t],"expand")),(0,u.stopImmediatePropagation)(e))}function b(){this.updatePlugin()}function A(e,t){t||this.updatePlugin()}t.CollapsibleColumns=N},96987:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(39152);t.PLUGIN_KEY=n.PLUGIN_KEY,t.PLUGIN_PRIORITY=n.PLUGIN_PRIORITY,t.CollapsibleColumns=n.CollapsibleColumns},72036:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724),r(14846),r(63333);var s=n(r(85707)),i=r(62577),o=r(70505),a=r(25499),l=r(89804),h=r(10587),u=r(75089),c=r(61149),d=r(28197),p=r(6433),g=r(92399),f=r(41191),m=r(72061),y=r(4968),E=r(80118),w=r(71120);function C(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function v(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}const R=t.PLUGIN_KEY="columnSorting",S=t.PLUGIN_PRIORITY=50,T=t.APPEND_COLUMN_CONFIG_STRATEGY="append",N=t.REPLACE_COLUMN_CONFIG_STRATEGY="replace",M=R;(0,E.registerRootComparator)(R,y.rootComparator),d.Hooks.getSingleton().register("beforeColumnSort"),d.Hooks.getSingleton().register("afterColumnSort");var _=new WeakSet;class b extends u.BasePlugin{constructor(){super(...arguments),C(this,_),(0,s.default)(this,"columnStatesManager",null),(0,s.default)(this,"columnMetaCache",null),(0,s.default)(this,"pluginKey",R),(0,s.default)(this,"indexesSequenceCache",null)}static get PLUGIN_KEY(){return R}static get PLUGIN_PRIORITY(){return S}isEnabled(){return!!this.hot.getSettings()[this.pluginKey]}enablePlugin(){var e=this;this.enabled||(this.columnStatesManager=new p.ColumnStatesManager(this.hot,`${this.pluginKey}.sortingStates`),this.columnMetaCache=new c.PhysicalIndexToValueMap((e=>{let t=this.hot.toVisualColumn(e);return null===t&&(t=e),this.getMergedPluginSettings(t)})),this.hot.columnIndexMapper.registerMap(`${this.pluginKey}.columnMeta`,this.columnMetaCache),this.addHook("afterGetColHeader",((e,t)=>v(_,this,O).call(this,e,t))),this.addHook("beforeOnCellMouseDown",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return v(_,e,x).call(e,...r)})),this.addHook("afterOnCellMouseDown",((e,t)=>this.onAfterOnCellMouseDown(e,t))),this.addHook("afterInit",(()=>v(_,this,A).call(this))),this.addHook("afterLoadData",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return v(_,e,I).call(e,...r)})),this.hot.view&&v(_,this,A).call(this),this.registerShortcuts(),super.enablePlugin())}disablePlugin(){const e=(e,t)=>{const r=(0,f.getHeaderSpanElement)(t);!1!==(0,f.isFirstLevelColumnHeader)(e,t)&&null!==r&&this.updateHeaderClasses(r)};this.hot.addHook("afterGetColHeader",e),this.hot.addHookOnce("afterViewRender",(()=>{this.hot.removeHook("afterGetColHeader",e)})),this.hot.batchExecution((()=>{null!==this.indexesSequenceCache&&(this.hot.rowIndexMapper.setIndexesSequence(this.indexesSequenceCache.getValues()),this.hot.rowIndexMapper.unregisterMap(this.pluginKey),this.indexesSequenceCache=null)}),!0),this.hot.columnIndexMapper.unregisterMap(`${this.pluginKey}.columnMeta`),this.columnStatesManager.destroy(),this.columnMetaCache=null,this.columnStatesManager=null,this.unregisterShortcuts(),super.disablePlugin()}registerShortcuts(){this.hot.getShortcutManager().getContext("grid").addShortcut({keys:[["Enter"]],callback:()=>{const{highlight:e}=this.hot.getSelectedRangeLast();return this.sort(this.getColumnNextConfig(e.col)),!1},runOnlyIf:()=>{var e,t;const r=null===(e=this.hot.getSelectedRangeLast())||void 0===e?void 0:e.highlight;return r&&(null===(t=this.hot.getSelectedRangeLast())||void 0===t?void 0:t.isSingle())&&this.hot.selection.isCellVisible(r)&&-1===r.row&&r.col>=0},relativeToGroup:g.EDITOR_EDIT_GROUP,position:"before",group:M})}unregisterShortcuts(){this.hot.getShortcutManager().getContext("grid").removeShortcutsByGroup(M)}sort(e){const t=this.getSortConfig(),r=this.getNormalizedSortConfigs(e),n=this.areValidSortConfigs(r);!1!==this.hot.runHooks("beforeColumnSort",t,r,n)&&(0===t.length&&null===this.indexesSequenceCache&&(this.indexesSequenceCache=this.hot.rowIndexMapper.registerMap(this.pluginKey,new c.IndexesSequence),this.indexesSequenceCache.setValues(this.hot.rowIndexMapper.getIndexesSequence())),n&&(this.columnStatesManager.setSortStates(r),this.sortByPresetSortStates(r),this.saveAllSortSettings(r)),this.hot.runHooks("afterColumnSort",t,n?r:t,n),n&&(this.hot.render(),this.hot.forceFullRender=!1,this.hot.view.render()))}clearSort(){this.sort([])}isSorted(){return this.enabled&&!this.columnStatesManager.isListOfSortedColumnsEmpty()}getSortConfig(e){return(0,o.isDefined)(e)?this.columnStatesManager.getColumnSortState(e):this.columnStatesManager.getSortStates()}setSortConfig(e){const t=this.getNormalizedSortConfigs(e);this.areValidSortConfigs(t)&&this.columnStatesManager.setSortStates(t)}getNormalizedSortConfigs(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[];return Array.isArray(e)?e.slice(0,1):[e]}areValidSortConfigs(e){const t=this.hot.countCols();return(0,f.areValidSortStates)(e)&&e.every((e=>{let{column:r}=e;return r<=t&&r>=0}))}saveAllSortSettings(e){const t=this.columnStatesManager.getAllColumnsProperties();t.initialConfig=(0,h.arrayMap)(e,(e=>{let{column:t,...r}=e;return{column:this.hot.toPhysicalColumn(t),...r}})),this.hot.runHooks("persistentStateSave","columnSorting",t)}getAllSavedSortSettings(){const e={};this.hot.runHooks("persistentStateLoad","columnSorting",e);const t=e.value,r=e=>{let{column:t,...r}=e;return{column:this.hot.toVisualColumn(t),...r}};return(0,o.isDefined)(t)&&Array.isArray(t.initialConfig)&&(t.initialConfig=(0,h.arrayMap)(t.initialConfig,r)),t}getColumnNextConfig(e){const t=this.columnStatesManager.getSortOrderOfColumn(e);if((0,o.isDefined)(t)){const r=(0,f.getNextSortOrder)(t);return(0,o.isDefined)(r)?{column:e,sortOrder:r}:void 0}const r=this.hot.countCols();if(Number.isInteger(e)&&e>=0&&e<r)return{column:e,sortOrder:(0,f.getNextSortOrder)()}}getNextSortConfig(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:T;const r=this.columnStatesManager.getIndexOfColumnInSortQueue(e),n=-1!==r,s=this.getSortConfig(),i=this.getColumnNextConfig(e);if(n){if((0,o.isUndefined)(i))return[...s.slice(0,r),...s.slice(r+1)];if(t===T)return[...s.slice(0,r),...s.slice(r+1),i];if(t===N)return[...s.slice(0,r),i,...s.slice(r+1)]}return(0,o.isDefined)(i)?s.concat(i):s}getPluginColumnConfig(e){if((0,a.isObject)(e)){const t=e[this.pluginKey];if((0,a.isObject)(t))return t}return{}}getMergedPluginSettings(e){const t=this.hot.getSettings()[this.pluginKey],r=this.columnStatesManager.getAllColumnsProperties(),n=this.hot.getCellMeta(0,e),s=Object.getPrototypeOf(n);return Array.isArray(s.columns)?Object.assign(r,t,this.getPluginColumnConfig(s.columns[e])):(0,l.isFunction)(s.columns)?Object.assign(r,t,this.getPluginColumnConfig(s.columns(e))):Object.assign(r,t)}getFirstCellSettings(e){const t=this.hot.getCellMeta(0,e),r=Object.create(t);return r[this.pluginKey]=this.columnMetaCache.getValueAtIndex(this.hot.toPhysicalColumn(e)),r}getNumberOfRowsToSort(e){const t=this.hot.getSettings();return t.maxRows<=e?t.maxRows:e-t.minSpareRows}sortByPresetSortStates(e){if(this.hot.rowIndexMapper.setIndexesSequence(this.indexesSequenceCache.getValues()),0===e.length)return;const t=[],r=this.hot.countRows(),n=t=>(0,h.arrayMap)(e,(e=>this.hot.getDataAtCell(t,e.column)));for(let e=0;e<this.getNumberOfRowsToSort(r);e+=1)t.push([this.hot.toPhysicalRow(e)].concat(n(e)));const s=(0,h.arrayMap)(t,(e=>e[0]));(0,E.sort)(t,this.pluginKey,(0,h.arrayMap)(e,(e=>e.sortOrder)),(0,h.arrayMap)(e,(e=>this.getFirstCellSettings(e.column))));for(let e=t.length;e<r;e+=1)t.push([e].concat(n(e)));const i=(0,h.arrayMap)(t,(e=>e[0])),o=new Map((0,h.arrayMap)(s,((e,t)=>[e,i[t]]))),a=(0,h.arrayMap)(this.hot.rowIndexMapper.getIndexesSequence(),(e=>o.has(e)?o.get(e):e));this.hot.rowIndexMapper.setIndexesSequence(a)}sortBySettings(e){if((0,a.isObject)(e)){this.columnStatesManager.updateAllColumnsProperties(e);const t=e.initialConfig;(Array.isArray(t)||(0,a.isObject)(t))&&this.sort(t)}else this.hot.render()}updateHeaderClasses(e){if((0,i.removeClass)(e,(0,m.getClassesToRemove)(e)),!1!==this.enabled){for(var t=arguments.length,r=new Array(t>1?t-1:0),n=1;n<t;n++)r[n-1]=arguments[n];(0,i.addClass)(e,(0,m.getClassesToAdd)(...r))}}onUpdateSettings(e){super.onUpdateSettings(),null!==this.columnMetaCache&&this.columnMetaCache.init(this.hot.columnIndexMapper.getNumberOfIndexes()),(0,o.isDefined)(e[this.pluginKey])&&this.sortBySettings(e[this.pluginKey])}wasClickableHeaderClicked(e,t){return this.getFirstCellSettings(t)[this.pluginKey].headerAction&&(0,i.hasClass)(e.target,f.HEADER_SPAN_CLASS)}onAfterOnCellMouseDown(e,t){if(!1!==(0,f.wasHeaderClickedProperly)(t.row,t.col,e)&&this.wasClickableHeaderClicked(e,t.col)){this.hot.getShortcutManager().isCtrlPressed()&&(this.hot.deselectCell(),this.hot.selectColumns(t.col));const e=this.hot.getActiveEditor(),r=this.getColumnNextConfig(t.col);null!=e&&e.isOpened()&&this.hot.getCellValidator(e.row,e.col)?this.hot.addHookOnce("postAfterValidate",(()=>{this.sort(r)})):this.sort(r)}}destroy(){var e;null===(e=this.columnStatesManager)||void 0===e||e.destroy(),super.destroy()}}function A(){const e=this.getAllSavedSortSettings();if((0,a.isObject)(e))this.sortBySettings(e);else{const e=this.hot.getSettings()[this.pluginKey];this.sortBySettings(e)}}function O(e,t){const r=(0,f.getHeaderSpanElement)(t);if(!1===(0,f.isFirstLevelColumnHeader)(e,t)||null===r)return;const n=this.getFirstCellSettings(e)[this.pluginKey],s=n.indicator,o=n.headerAction;if(this.updateHeaderClasses(r,this.columnStatesManager,e,s,o),this.hot.getSettings().ariaTags){const r=this.columnStatesManager.getSortOrderOfColumn(e);(0,i.setAttribute)(t,...(0,w.A11Y_SORT)(r?`${r}ending`:"none"))}}function I(e){!0===e&&this.hot.view&&v(_,this,A).call(this)}function x(e,t,r,n){!1!==(0,f.wasHeaderClickedProperly)(t.row,t.col,e)&&this.wasClickableHeaderClicked(e,t.col)&&this.hot.getShortcutManager().isCtrlPressed()&&(n.column=!0)}t.ColumnSorting=b},6433:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(94364);var s=n(r(85707)),i=r(25499),o=r(61149),a=r(70505);const l=["sortEmptyCells","indicator","headerAction","compareFunctionFactory"];t.ColumnStatesManager=class{constructor(e,t){(0,s.default)(this,"hot",void 0),(0,s.default)(this,"sortingStates",new o.LinkedPhysicalIndexToValueMap),(0,s.default)(this,"sortEmptyCells",false),(0,s.default)(this,"indicator",true),(0,s.default)(this,"headerAction",true),(0,s.default)(this,"compareFunctionFactory",void 0),(0,s.default)(this,"mapName",void 0),this.hot=e,this.mapName=t,this.hot.columnIndexMapper.registerMap(t,this.sortingStates)}updateAllColumnsProperties(e){(0,i.isObject)(e)&&(0,i.objectEach)(e,((e,t)=>{l.includes(t)&&(this[t]=e)}))}getAllColumnsProperties(){const e={sortEmptyCells:this.sortEmptyCells,indicator:this.indicator,headerAction:this.headerAction};return"function"==typeof this.compareFunctionFactory&&(e.compareFunctionFactory=this.compareFunctionFactory),e}getSortOrderOfColumn(e){var t;return null===(t=this.sortingStates.getValueAtIndex(this.hot.toPhysicalColumn(e)))||void 0===t?void 0:t.sortOrder}getIndexOfColumnInSortQueue(e){return e=this.hot.toPhysicalColumn(e),this.sortingStates.getEntries().findIndex((t=>{let[r]=t;return r===e}))}getNumberOfSortedColumns(){return this.sortingStates.getLength()}isListOfSortedColumnsEmpty(){return 0===this.getNumberOfSortedColumns()}isColumnSorted(e){return(0,i.isObject)(this.sortingStates.getValueAtIndex(this.hot.toPhysicalColumn(e)))}getSortStates(){if(null===this.sortingStates)return[];return this.sortingStates.getEntries().map((e=>{let[t,r]=e;return{column:this.hot.toVisualColumn(t),...r}}))}getColumnSortState(e){const t=this.getSortOrderOfColumn(e);if((0,a.isDefined)(t))return{column:e,sortOrder:t}}setSortStates(e){this.sortingStates.clear();for(let t=0;t<e.length;t+=1)this.sortingStates.setValueAtIndex(this.hot.toPhysicalColumn(e[t].column),{sortOrder:e[t].sortOrder})}destroy(){this.hot.columnIndexMapper.unregisterMap(this.mapName),this.sortingStates=null}}},72061:(e,t,r)=>{"use strict";t.__esModule=!0,t.getClassesToAdd=function(e,t,r,s){const h=[o];s&&h.push(a);if(!1===r)return h.push(i),h;const u=e.getSortOrderOfColumn(t);(0,n.isDefined)(u)&&h.push(l.get(u));return h},t.getClassesToRemove=function(){return Array.from(l.values()).concat(a,i,o)},r(15724);var n=r(70505),s=r(41191);const i="indicatorDisabled",o="columnSorting",a="sortAction",l=new Map([[s.ASC_SORT_STATE,"ascending"],[s.DESC_SORT_STATE,"descending"]])},51206:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(72036);t.PLUGIN_KEY=n.PLUGIN_KEY,t.PLUGIN_PRIORITY=n.PLUGIN_PRIORITY,t.ColumnSorting=n.ColumnSorting,t.APPEND_COLUMN_CONFIG_STRATEGY=n.APPEND_COLUMN_CONFIG_STRATEGY,t.REPLACE_COLUMN_CONFIG_STRATEGY=n.REPLACE_COLUMN_CONFIG_STRATEGY},4968:(e,t,r)=>{"use strict";t.__esModule=!0,t.rootComparator=function(e,t){return function(r,s){const[,...i]=r,[,...o]=s;return function(r){const s=e[r],a=t[r],l=i[r],h=o[r],u=a.columnSorting;return(u.compareFunctionFactory?u.compareFunctionFactory:(0,n.getCompareFunctionFactory)(a.type))(s,a,u)(l,h)}(0)}};var n=r(80118)},54626:(e,t,r)=>{"use strict";t.__esModule=!0,t.compareFunctionFactory=function(e,t,r){const o=t.checkedTemplate,a=t.uncheckedTemplate,{sortEmptyCells:l}=r;return function(h,u){const c=(0,i.isEmpty)(h),d=(0,i.isEmpty)(u),p=c?a:h,g=d?a:u,f=p===a||p===o,m=g===a||g===o;if(!1===l){if(c&&!1===d)return n.FIRST_AFTER_SECOND;if(!1===c&&d)return n.FIRST_BEFORE_SECOND}return!1===f&&m?"asc"===e?n.FIRST_BEFORE_SECOND:n.FIRST_AFTER_SECOND:f&&!1===m?"asc"===e?n.FIRST_AFTER_SECOND:n.FIRST_BEFORE_SECOND:!1===f&&!1===m?(0,s.compareFunctionFactory)(e,t,r)(h,u):p===a&&g===o?"asc"===e?n.FIRST_BEFORE_SECOND:n.FIRST_AFTER_SECOND:p===o&&g===a?"asc"===e?n.FIRST_AFTER_SECOND:n.FIRST_BEFORE_SECOND:n.DO_NOT_SWAP}};var n=r(80118),s=r(36654),i=r(70505);t.COLUMN_DATA_TYPE="checkbox"},57355:(e,t,r)=>{"use strict";t.__esModule=!0,t.compareFunctionFactory=function(e,t,r){return(0,n.createDateTimeCompareFunction)(e,t.dateFormat,r)};var n=r(41191);t.COLUMN_DATA_TYPE="date"},36654:(e,t,r)=>{"use strict";t.__esModule=!0,t.compareFunctionFactory=function(e,t,r){const i=t.locale;return function(t,o){const{sortEmptyCells:a}=r;return"string"==typeof t&&(t=t.toLocaleLowerCase(i)),"string"==typeof o&&(o=o.toLocaleLowerCase(i)),t===o?s.DO_NOT_SWAP:(0,n.isEmpty)(t)?(0,n.isEmpty)(o)?s.DO_NOT_SWAP:a&&"asc"===e?s.FIRST_BEFORE_SECOND:s.FIRST_AFTER_SECOND:(0,n.isEmpty)(o)?a&&"asc"===e?s.FIRST_AFTER_SECOND:s.FIRST_BEFORE_SECOND:isNaN(t)&&!isNaN(o)?"asc"===e?s.FIRST_AFTER_SECOND:s.FIRST_BEFORE_SECOND:!isNaN(t)&&isNaN(o)?"asc"===e?s.FIRST_BEFORE_SECOND:s.FIRST_AFTER_SECOND:(isNaN(t)||isNaN(o)||(t=parseFloat(t),o=parseFloat(o)),t<o?"asc"===e?s.FIRST_BEFORE_SECOND:s.FIRST_AFTER_SECOND:t>o?"asc"===e?s.FIRST_AFTER_SECOND:s.FIRST_BEFORE_SECOND:s.DO_NOT_SWAP)}};var n=r(70505),s=r(80118);t.COLUMN_DATA_TYPE="default"},10144:(e,t,r)=>{"use strict";t.__esModule=!0,t.compareFunctionFactory=function(e,t,r){return function(t,i){const o=parseFloat(t),a=parseFloat(i),{sortEmptyCells:l}=r;if(o===a||isNaN(o)&&isNaN(a))return s.DO_NOT_SWAP;if(l){if((0,n.isEmpty)(t))return"asc"===e?s.FIRST_BEFORE_SECOND:s.FIRST_AFTER_SECOND;if((0,n.isEmpty)(i))return"asc"===e?s.FIRST_AFTER_SECOND:s.FIRST_BEFORE_SECOND}return isNaN(o)?s.FIRST_AFTER_SECOND:isNaN(a)?s.FIRST_BEFORE_SECOND:o<a?"asc"===e?s.FIRST_BEFORE_SECOND:s.FIRST_AFTER_SECOND:o>a?"asc"===e?s.FIRST_AFTER_SECOND:s.FIRST_BEFORE_SECOND:s.DO_NOT_SWAP}};var n=r(70505),s=r(80118);t.COLUMN_DATA_TYPE="numeric"},64706:(e,t,r)=>{"use strict";t.__esModule=!0,t.compareFunctionFactory=function(e,t,r){return(0,n.createDateTimeCompareFunction)(e,t.timeFormat,r)};var n=r(41191);t.COLUMN_DATA_TYPE="time"},76242:(e,t,r)=>{"use strict";t.__esModule=!0,t.sort=function(e,t){const r=(0,n.getRootComparator)(t);for(var s=arguments.length,i=new Array(s>2?s-2:0),o=2;o<s;o++)i[o-2]=arguments[o];e.sort(r(...i))};var n=r(33263);t.DO_NOT_SWAP=0,t.FIRST_BEFORE_SECOND=-1,t.FIRST_AFTER_SECOND=1},80118:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(33263);t.registerRootComparator=n.registerRootComparator,t.getRootComparator=n.getRootComparator,t.getCompareFunctionFactory=n.getCompareFunctionFactory;var s=r(76242);t.FIRST_AFTER_SECOND=s.FIRST_AFTER_SECOND,t.FIRST_BEFORE_SECOND=s.FIRST_BEFORE_SECOND,t.DO_NOT_SWAP=s.DO_NOT_SWAP,t.sort=s.sort},33263:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.getCompareFunctionFactory=function(e){if(d(e))return c(e);return c(s.COLUMN_DATA_TYPE)};var s=r(36654),i=r(10144),o=r(54626),a=r(57355),l=r(64706),h=n(r(28651));const{register:u,getItem:c,hasItem:d}=(0,h.default)("sorting.compareFunctionFactory"),{register:p,getItem:g}=(0,h.default)("sorting.mainSortComparator");t.getRootComparator=g,t.registerRootComparator=p,u(o.COLUMN_DATA_TYPE,o.compareFunctionFactory),u(a.COLUMN_DATA_TYPE,a.compareFunctionFactory),u(s.COLUMN_DATA_TYPE,s.compareFunctionFactory),u(i.COLUMN_DATA_TYPE,i.compareFunctionFactory),u(l.COLUMN_DATA_TYPE,l.compareFunctionFactory)},41191:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,t.areValidSortStates=function(e){if(e.some((e=>!1===function(e){if(!1===(0,i.isObject)(e))return!1;const{column:t,sortOrder:r}=e;return Number.isInteger(t)&&[h,u].includes(r)}(e))))return!1;const t=e.map((e=>{let{column:t}=e;return t}));return new Set(t).size===t.length},t.createDateTimeCompareFunction=function(e,t,r){return function(n,i){const{sortEmptyCells:o}=r;if(n===i)return l.DO_NOT_SWAP;if((0,a.isEmpty)(n))return(0,a.isEmpty)(i)?l.DO_NOT_SWAP:o&&"asc"===e?l.FIRST_BEFORE_SECOND:l.FIRST_AFTER_SECOND;if((0,a.isEmpty)(i))return o&&"asc"===e?l.FIRST_AFTER_SECOND:l.FIRST_BEFORE_SECOND;const h=(0,s.default)(n,t),u=(0,s.default)(i,t);return h.isValid()?u.isValid()?u.isAfter(h)?"asc"===e?l.FIRST_BEFORE_SECOND:l.FIRST_AFTER_SECOND:u.isBefore(h)?"asc"===e?l.FIRST_AFTER_SECOND:l.FIRST_BEFORE_SECOND:l.DO_NOT_SWAP:l.FIRST_BEFORE_SECOND:l.FIRST_AFTER_SECOND}},t.getHeaderSpanElement=function(e){return e.querySelector(`.${c}`)},t.getNextSortOrder=function(e){if(e===u)return;if(e===h)return u;return h},t.isFirstLevelColumnHeader=function(e,t){if(e<0||!t.parentNode)return!1;const r=t.parentNode.parentNode.childNodes;if(Array.from(r).indexOf(t.parentNode)-r.length!=-1)return!1;return!0},t.wasHeaderClickedProperly=function(e,t,r){return-1===e&&t>=0&&!1===(0,o.isRightClick)(r)},r(71336),r(41558),r(17663),r(68630),r(79645),r(89858),r(8620),r(14846),r(94364),r(75568);var s=n(r(6671)),i=r(25499),o=r(77661),a=r(70505),l=r(80118);const h=t.ASC_SORT_STATE="asc",u=t.DESC_SORT_STATE="desc",c=t.HEADER_SPAN_CLASS="colHeader"},25288:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=n(r(85707)),i=r(75089),o=r(25499),a=n(r(29664)),l=r(21595),h=r(19831);function u(e,t){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.add(e)}function c(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}const d=t.PLUGIN_KEY="columnSummary",p=t.PLUGIN_PRIORITY=220;var g=new WeakSet;class f extends i.BasePlugin{constructor(){super(...arguments),u(this,g),(0,s.default)(this,"endpoints",null)}static get PLUGIN_KEY(){return d}static get PLUGIN_PRIORITY(){return p}isEnabled(){return!!this.hot.getSettings()[d]}enablePlugin(){var e=this;this.enabled||(this.settings=this.hot.getSettings()[d],this.endpoints=new a.default(this,this.settings),this.addHook("afterInit",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return c(g,e,m).call(e,...r)})),this.addHook("afterChange",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return c(g,e,E).call(e,...r)})),this.addHook("afterUpdateSettings",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return c(g,e,y).call(e,...r)})),this.addHook("beforeCreateRow",((e,t,r)=>this.endpoints.resetSetupBeforeStructureAlteration("insert_row",e,t,null,r))),this.addHook("beforeCreateCol",((e,t,r)=>this.endpoints.resetSetupBeforeStructureAlteration("insert_col",e,t,null,r))),this.addHook("beforeRemoveRow",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return e.endpoints.resetSetupBeforeStructureAlteration("remove_row",...r)})),this.addHook("beforeRemoveCol",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return e.endpoints.resetSetupBeforeStructureAlteration("remove_col",...r)})),this.addHook("afterCreateRow",((e,t,r)=>this.endpoints.resetSetupAfterStructureAlteration("insert_row",e,t,null,r))),this.addHook("afterCreateCol",((e,t,r)=>this.endpoints.resetSetupAfterStructureAlteration("insert_col",e,t,null,r))),this.addHook("afterRemoveRow",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return e.endpoints.resetSetupAfterStructureAlteration("remove_row",...r)})),this.addHook("afterRemoveCol",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return e.endpoints.resetSetupAfterStructureAlteration("remove_col",...r)})),this.addHook("afterRowMove",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return c(g,e,w).call(e,...r)})),super.enablePlugin())}disablePlugin(){this.endpoints=null,this.settings=null,this.currentEndpoint=null,super.disablePlugin()}updatePlugin(){this.disablePlugin(),this.enablePlugin(),this.endpoints.initEndpoints(),super.updatePlugin()}calculate(e){switch(e.type.toLowerCase()){case"sum":e.result=this.calculateSum(e);break;case"min":case"max":e.result=this.calculateMinMax(e,e.type);break;case"count":e.result=this.countEntries(e);break;case"average":e.result=this.calculateAverage(e);break;case"custom":e.result=e.customFunction.call(this,e)}}calculateSum(e){let t=0;return(0,o.objectEach)(e.ranges,(r=>{t+=this.getPartialSum(r,e.sourceColumn)})),t}getPartialSum(e,t){let r=0,n=e[1]||e[0],s=null,i=0;do{if(s=this.getCellValue(n,t),s=(0,h.isNullishOrNaN)(s)?null:s,null!==s){const e=(`${s}`.split(".")[1]||[]).length||1;e>i&&(i=e)}r+=s||0,n-=1}while(n>=e[0]);return Math.round(r*10**i)/10**i}calculateMinMax(e,t){let r=null;return(0,o.objectEach)(e.ranges,(n=>{const s=this.getPartialMinMax(n,e.sourceColumn,t);if(null===r&&null!==s&&(r=s),null!==s)switch(t){case"min":r=Math.min(r,s);break;case"max":r=Math.max(r,s)}})),null===r?"Not enough data":r}getPartialMinMax(e,t,r){let n,s=null,i=e[1]||e[0];do{if(n=this.getCellValue(i,t),n=(0,h.isNullishOrNaN)(n)?null:n,null===s)s=n;else if(null!==n)switch(r){case"min":s=Math.min(s,n);break;case"max":s=Math.max(s,n)}i-=1}while(i>=e[0]);return s}countEmpty(e,t){let r,n=0,s=e[1]||e[0];do{r=this.getCellValue(s,t),r=(0,h.isNullishOrNaN)(r)?null:r,null===r&&(n+=1),s-=1}while(s>=e[0]);return n}countEntries(e){let t=0;const r=e.ranges;return(0,o.objectEach)(r,(r=>{const n=void 0===r[1]?1:r[1]-r[0]+1,s=this.countEmpty(r,e.sourceColumn);t+=n,t-=s})),t}calculateAverage(e){return this.calculateSum(e)/this.countEntries(e)}getCellValue(e,t){const r=this.hot.toVisualRow(e),n=this.hot.toVisualColumn(t);let s=this.hot.getSourceDataAtCell(e,t),i="";if(null!==r&&null!==n&&(i=this.hot.getCellMeta(r,n).className||""),i.indexOf("columnSummaryResult")>-1)return null;if(this.endpoints.currentEndpoint.forceNumeric&&("string"==typeof s&&(s=s.replace(/,/,".")),s=parseFloat(s)),isNaN(s)&&!this.endpoints.currentEndpoint.suppressDataTypeErrors)throw new Error(l.toSingleLine`ColumnSummary plugin: cell at (${e}, ${t}) is not in a\x20
          numeric format. Cannot do the calculation.`);return s}}function m(){this.endpoints.initEndpoints()}function y(e){void 0!==e.columns&&this.endpoints.refreshCellMetas()}function E(e,t){e&&"ColumnSummary.reset"!==t&&"ColumnSummary.set"!==t&&"loadData"!==t&&this.endpoints.refreshChangedEndpoints(e)}function w(e,t){this.endpoints.resetSetupBeforeStructureAlteration("move_row",e[0],e.length,e,this.pluginName),this.endpoints.resetSetupAfterStructureAlteration("move_row",t,e.length,e,this.pluginName)}t.ColumnSummary=f},29664:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724),r(14846),r(69655),r(75568);var s=n(r(85707)),i=r(10587),o=r(14859);t.default=class{constructor(e,t){(0,s.default)(this,"plugin",void 0),(0,s.default)(this,"hot",void 0),(0,s.default)(this,"endpoints",[]),(0,s.default)(this,"settings",void 0),(0,s.default)(this,"settingsType","array"),(0,s.default)(this,"currentEndpoint",null),(0,s.default)(this,"cellsToSetCache",[]),this.plugin=e,this.hot=this.plugin.hot,this.settings=t}initEndpoints(){this.endpoints=this.parseSettings(),this.refreshAllEndpoints()}getEndpoint(e){return"function"===this.settingsType?this.fillMissingEndpointData(this.settings)[e]:this.endpoints[e]}getAllEndpoints(){return"function"===this.settingsType?this.fillMissingEndpointData(this.settings):this.endpoints}fillMissingEndpointData(e){return this.parseSettings(e.call(this))}parseSettings(e){const t=[];let r=e;if(r||"function"!=typeof this.settings)return r||(r=this.settings),(0,i.arrayEach)(r,(e=>{const r={};this.assignSetting(e,r,"ranges",[[0,this.hot.countRows()-1]]),this.assignSetting(e,r,"reversedRowCoords",!1),this.assignSetting(e,r,"destinationRow",new Error("\n        You must provide a destination row for the Column Summary plugin in order to work properly!\n      ")),this.assignSetting(e,r,"destinationColumn",new Error("\n        You must provide a destination column for the Column Summary plugin in order to work properly!\n      ")),this.assignSetting(e,r,"sourceColumn",e.destinationColumn),this.assignSetting(e,r,"type","sum"),this.assignSetting(e,r,"forceNumeric",!1),this.assignSetting(e,r,"suppressDataTypeErrors",!0),this.assignSetting(e,r,"customFunction",null),this.assignSetting(e,r,"readOnly",!0),this.assignSetting(e,r,"roundFloat",!1),t.push(r)})),t;this.settingsType="function"}assignSetting(e,t,r,n){if("ranges"!==r||void 0!==e[r]){if("ranges"!==r||0!==e[r].length)if(void 0===e[r]){if(n instanceof Error)throw n;t[r]=n}else"destinationRow"===r&&t.reversedRowCoords?t[r]=this.hot.countRows()-e[r]-1:t[r]=e[r]}else t[r]=n}resetSetupBeforeStructureAlteration(e,t,r){if("function"!==this.settingsType)return;const n=e.indexOf("row")>-1?"row":"col",s=this.getAllEndpoints();(0,i.arrayEach)(s,(s=>{"row"===n&&s.destinationRow>=t&&("insert_row"===e?s.alterRowOffset=r:"remove_row"===e&&(s.alterRowOffset=-1*r)),"col"===n&&s.destinationColumn>=t&&("insert_col"===e?s.alterColumnOffset=r:"remove_col"===e&&(s.alterColumnOffset=-1*r))})),this.resetAllEndpoints(s,!1)}resetSetupAfterStructureAlteration(e,t,r,n,s){let o=!(arguments.length>5&&void 0!==arguments[5])||arguments[5];if("function"===this.settingsType){const e=()=>(this.hot.removeHook("beforeViewRender",e),this.refreshAllEndpoints());return void this.hot.addHookOnce("beforeViewRender",e)}const a=e.indexOf("row")>-1?"row":"col",l=e.indexOf("remove")>-1?-1:1,h=this.getAllEndpoints(),u=0===e.indexOf("move_row"),c=t;(0,i.arrayEach)(h,(e=>{"row"===a&&e.destinationRow>=c&&(e.alterRowOffset=l*r),"col"===a&&e.destinationColumn>=c&&(e.alterColumnOffset=l*r)})),this.resetAllEndpoints(h,!u),u?(0,i.arrayEach)(h,(e=>{this.extendEndpointRanges(e,c,n[0],n.length),this.recreatePhysicalRanges(e),this.clearOffsetInformation(e)})):(0,i.arrayEach)(h,(e=>{this.shiftEndpointCoordinates(e,c)})),o&&this.refreshAllEndpoints()}clearOffsetInformation(e){e.alterRowOffset=void 0,e.alterColumnOffset=void 0}extendEndpointRanges(e,t,r,n){(0,i.arrayEach)(e.ranges,(e=>{e[1]&&(t>=e[0]&&t<=e[1]?r>e[1]?e[1]+=n:r<e[0]&&(e[0]-=n):r>=e[0]&&r<=e[1]&&(e[1]-=n,t<=e[0]&&(e[0]+=1,e[1]+=1)))}))}recreatePhysicalRanges(e){const t=e.ranges,r=[],n=[];(0,i.arrayEach)(t,(e=>{const t=[];if(e[1])for(let r=e[0];r<=e[1];r++)t.push(this.hot.toPhysicalRow(r));else t.push(this.hot.toPhysicalRow(e[0]));n.push(t)})),(0,i.arrayEach)(n,(e=>{let t=[];(0,i.arrayEach)(e,((n,s)=>{0===s?t.push(n):e[s]!==e[s-1]+1&&(t.push(e[s-1]),r.push(t),t=[],t.push(n)),s===e.length-1&&(t.push(n),r.push(t))}))})),e.ranges=r}shiftEndpointCoordinates(e,t){e.alterRowOffset&&0!==e.alterRowOffset?(e.destinationRow+=e.alterRowOffset||0,(0,i.arrayEach)(e.ranges,(r=>{(0,i.arrayEach)(r,((n,s)=>{n>=t&&(r[s]+=e.alterRowOffset||0)}))}))):e.alterColumnOffset&&0!==e.alterColumnOffset&&(e.destinationColumn+=e.alterColumnOffset||0,e.sourceColumn+=e.alterColumnOffset||0)}resetAllEndpoints(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getAllEndpoints(),t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];e.some((e=>{const t=e.alterRowOffset||0,r=e.alterColumnOffset||0;return e.destinationRow+t>=this.hot.countRows()||e.destinationColumn+r>=this.hot.countCols()}))||(this.cellsToSetCache=[],(0,i.arrayEach)(e,(e=>{this.resetEndpointValue(e,t)})),this.hot.setDataAtCell(this.cellsToSetCache,"ColumnSummary.reset"),this.cellsToSetCache=[])}refreshAllEndpoints(){this.cellsToSetCache=[],(0,i.arrayEach)(this.getAllEndpoints(),(e=>{this.currentEndpoint=e,this.plugin.calculate(e),this.setEndpointValue(e,"init")})),this.currentEndpoint=null,this.hot.setDataAtCell(this.cellsToSetCache,"ColumnSummary.reset"),this.cellsToSetCache=[]}refreshChangedEndpoints(e){const t=[];this.cellsToSetCache=[],(0,i.arrayEach)(e,((e,r,n)=>{`${e[2]||""}`!=`${e[3]}`&&(0,i.arrayEach)(this.getAllEndpoints(),((e,s)=>{this.hot.propToCol(n[r][1])===e.sourceColumn&&-1===t.indexOf(s)&&t.push(s)}))})),(0,i.arrayEach)(t,(e=>{this.refreshEndpoint(this.getEndpoint(e))})),this.hot.setDataAtCell(this.cellsToSetCache,"ColumnSummary.reset"),this.cellsToSetCache=[]}refreshCellMetas(){this.endpoints.forEach((e=>{const t=this.hot.toVisualRow(e.destinationRow);if(null!==t){const r=this.hot.getCellMeta(t,e.destinationColumn);r.readOnly=e.readOnly,r.className="columnSummaryResult"}}))}refreshEndpoint(e){this.currentEndpoint=e,this.plugin.calculate(e),this.setEndpointValue(e),this.currentEndpoint=null}resetEndpointValue(e){let t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];const r=e.alterRowOffset||0,n=e.alterColumnOffset||0;this.cellsToSetCache.push([this.hot.toVisualRow(e.destinationRow+(t?r:0)),this.hot.toVisualColumn(e.destinationColumn+(t?n:0)),""])}setEndpointValue(e,t){let r=arguments.length>2&&void 0!==arguments[2]&&arguments[2];const n=this.hot.toVisualRow(e.destinationRow);if(e.destinationRow>=this.hot.countRows()||e.destinationColumn>=this.hot.countCols())return void this.throwOutOfBoundsWarning();const s=this.hot.toVisualRow(e.destinationRow);if(null!==s){const r=this.hot.getCellMeta(s,e.destinationColumn);"init"!==t&&r.readOnly===e.readOnly||(r.readOnly=e.readOnly,r.className="columnSummaryResult")}if((!0===e.roundFloat||Number.isInteger(e.roundFloat))&&!isNaN(e.result)){const t=e.roundFloat;let r=0;Number.isInteger(t)&&(r=Math.min(Math.max(0,t),100)),e.result=e.result.toFixed(r)}r?this.hot.setDataAtCell(n,e.destinationColumn,e.result,"ColumnSummary.set"):this.cellsToSetCache.push([n,e.destinationColumn,e.result]),e.alterRowOffset=void 0,e.alterColumnOffset=void 0}throwOutOfBoundsWarning(){(0,o.warn)("One of the Column Summary plugins' destination points you provided is beyond the table boundaries!")}}},66518:(e,t,r)=>{"use strict";t.__esModule=!0;var n=r(25288);t.PLUGIN_KEY=n.PLUGIN_KEY,t.PLUGIN_PRIORITY=n.PLUGIN_PRIORITY,t.ColumnSummary=n.ColumnSummary},19831:(e,t)=>{"use strict";t.__esModule=!0,t.isNullishOrNaN=function(e){return null==e||isNaN(e)}},21262:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834);var s=r(62577),i=r(25499),o=n(r(16050)),a=r(3899);function l(e,t,r){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,r)}function h(e,t){return e.get(c(e,t))}function u(e,t,r){return e.set(c(e,t),r),r}function c(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}var d=new WeakMap,p=new WeakMap,g=new WeakMap,f=new WeakMap,m=new WeakMap,y=new WeakMap,E=new WeakMap;class w{static get CLASS_EDITOR_CONTAINER(){return"htCommentsContainer"}static get CLASS_EDITOR(){return"htComments"}static get CLASS_INPUT(){return"htCommentTextArea"}static get CLASS_CELL(){return"htCommentCell"}constructor(e,t){var r=this;l(this,d,void 0),l(this,p,!1),l(this,g,null),l(this,f,void 0),l(this,m,void 0),l(this,y,!0),l(this,E,new a.EditorResizeObserver),u(d,this,e),u(p,this,t),u(f,this,this.createEditor()),u(m,this,h(f,this).style),h(E,this).setObservedElement(this.getInputElement()),h(E,this).addLocalHook("resize",(function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return r.runLocalHooks("resize",...t)})),this.hide()}setPosition(e,t){h(m,this).left=`${e}px`,h(m,this).top=`${t}px`}setSize(e,t){if(e&&t){const r=this.getInputElement();r.style.width=`${e}px`,r.style.height=`${t}px`}}getSize(){return{width:(0,s.outerWidth)(this.getInputElement()),height:(0,s.outerHeight)(this.getInputElement())}}observeSize(){h(E,this).observe()}resetSize(){const e=this.getInputElement();e.style.width="",e.style.height=""}setReadOnlyState(e){this.getInputElement().readOnly=e}show(){h(m,this).display="block",u(y,this,!1)}hide(){h(E,this).unobserve(),h(y,this)||(h(m,this).display="none"),u(y,this,!0)}isVisible(){return"block"===h(m,this).display}setValue(){const e=(arguments.length>0&&void 0!==arguments[0]?arguments[0]:"")||"";this.getInputElement().value=e}getValue(){return this.getInputElement().value}isFocused(){return h(d,this).activeElement===this.getInputElement()}focus(){this.getInputElement().focus()}createEditor(){const e=h(d,this).createElement("div"),t=h(d,this).createElement("textarea");return e.style.display="none",u(g,this,h(d,this).createElement("div")),h(g,this).setAttribute("dir",h(p,this)?"rtl":"ltr"),(0,s.addClass)(h(g,this),w.CLASS_EDITOR_CONTAINER),h(d,this).body.appendChild(h(g,this)),(0,s.addClass)(e,w.CLASS_EDITOR),(0,s.addClass)(t,w.CLASS_INPUT),t.setAttribute("data-hot-input",!0),e.appendChild(t),h(g,this).appendChild(e),e}getInputElement(){return h(f,this).querySelector(`.${w.CLASS_INPUT}`)}getEditorElement(){return h(f,this)}destroy(){const e=h(g,this)?h(g,this).parentNode:null;h(f,this).parentNode.removeChild(h(f,this)),u(f,this,null),u(m,this,null),h(E,this).destroy(),e&&e.removeChild(h(g,this))}}(0,i.mixin)(w,o.default);t.default=w},28062:(e,t,r)=>{"use strict";var n=r(96784);t.__esModule=!0,r(67834),r(15724);var s=n(r(85707)),i=r(62577),o=r(77661),a=r(25499),l=r(75089),h=n(r(21262)),u=n(r(75912)),c=r(30889),d=n(r(8924)),p=n(r(98423)),g=n(r(57757));function f(e,t,r){m(e,t),t.set(e,r)}function m(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function y(e,t,r){return e.set(w(e,t),r),r}function E(e,t){return e.get(w(e,t))}function w(e,t,r){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:r;throw new TypeError("Private element is not present on this object")}const C=t.PLUGIN_KEY="comments",v=t.PLUGIN_PRIORITY=60,R=t.META_COMMENT="comment",S=t.META_COMMENT_VALUE="value",T=t.META_STYLE="style",N=t.META_READONLY="readOnly",M=C,_=`plugin:${C}`;var b=new WeakMap,A=new WeakMap,O=new WeakMap,I=new WeakMap,x=new WeakMap,P=new WeakMap,L=new WeakSet;class D extends l.BasePlugin{constructor(){var e,t;super(...arguments),m(e=this,t=L),t.add(e),(0,s.default)(this,"range",{}),f(this,b,null),f(this,A,null),f(this,O,!1),f(this,I,!1),f(this,x,null),f(this,P,"")}static get PLUGIN_KEY(){return C}static get PLUGIN_PRIORITY(){return v}static get DEFAULT_SETTINGS(){return{displayDelay:250}}isEnabled(){return!!this.hot.getSettings()[C]}enablePlugin(){var e=this;this.enabled||(E(b,this)||(y(b,this,new h.default(this.hot.rootDocument,this.hot.isRtl())),E(b,this).addLocalHook("resize",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return w(L,e,W).call(e,...r)}))),E(A,this)||y(A,this,new u.default(this.getSetting("displayDelay"))),this.addHook("afterContextMenuDefaultOptions",(e=>this.addToContextMenu(e))),this.addHook("afterRenderer",((e,t,r,n,s,i)=>w(L,this,U).call(this,e,i))),this.addHook("afterScroll",(()=>w(L,this,G).call(this))),this.addHook("afterBeginEditing",(()=>this.hide())),this.addHook("afterDocumentKeyDown",(e=>w(L,this,Y).call(this,e))),this.addHook("afterSetTheme",(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return w(L,e,j).call(e,...r)})),E(A,this).addLocalHook("hide",(()=>this.hide())),E(A,this).addLocalHook("show",((e,t)=>this.showAtCell(e,t))),this.registerShortcuts(),this.registerListeners(),super.enablePlugin())}updatePlugin(){E(A,this).updateDelay(this.getSetting("displayDelay")),super.updatePlugin()}disablePlugin(){this.unregisterShortcuts(),super.disablePlugin()}registerShortcuts(){const e=this.hot.getShortcutManager(),t=e.getContext("grid"),r=e.addContext(_);t.addShortcut({keys:[["Control","Alt","M"]],callback:()=>{const t=this.hot.getSelectedRangeLast();y(I,this,!0),this.hot.scrollToFocusedCell((()=>{this.setRange(t),this.show(),this.focusEditor(),e.setActiveContextName(_),this.hot._registerTimeout((()=>{y(I,this,!1)}))}))},stopPropagation:!0,runOnlyIf:()=>{var e;return null===(e=this.hot.getSelectedRangeLast())||void 0===e?void 0:e.highlight.isCell()},group:M}),r.addShortcut({keys:[["Escape"]],callback:()=>{E(b,this).setValue(E(P,this)),this.hide(),e.setActiveContextName("grid")},runOnlyIf:()=>E(b,this).isVisible()&&E(b,this).isFocused(),group:M}),r.addShortcut({keys:[["Control/Meta","Enter"]],callback:()=>{this.hide(),e.setActiveContextName("grid")},runOnlyIf:()=>E(b,this).isVisible()&&E(b,this).isFocused(),group:M})}unregisterShortcuts(){this.hot.getShortcutManager().getContext("grid").removeShortcutsByGroup(M)}registerListeners(){const{rootDocument:e}=this.hot,t=this.getEditorInputElement();this.eventManager.addEventListener(e,"mouseover",(e=>w(L,this,H).call(this,e))),this.eventManager.addEventListener(e,"mousedown",(e=>w(L,this,k).call(this,e))),this.eventManager.addEventListener(e,"mouseup",(()=>w(L,this,F).call(this))),this.eventManager.addEventListener(t,"focus",(()=>w(L,this,B).call(this))),this.eventManager.addEventListener(t,"blur",(()=>w(L,this,V).call(this)))}setRange(e){this.range=e}clearRange(){this.range={}}targetIsCellWithComment(e){const t=(0,i.closest)(e.target,"TD","TBODY");return!!(t&&(0,i.hasClass)(t,"htCommentCell")&&(0,i.closest)(t,[this.hot.rootElement]))}targetIsCommentTextArea(e){return this.getEditorInputElement()===e.target}setComment(e){if(!this.range.from)throw new Error('Before using this method, first set cell range (h