"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Event.
 */
class Event {
    /**
     * Constructor.
     *
     * @param type Event type.
     * @param [eventInit] Event init.
     */
    constructor(type, eventInit = null) {
        this.composed = false;
        this.currentTarget = null;
        this.target = null;
        this.bubbles = false;
        this.cancelable = false;
        this.defaultPrevented = false;
        this._immediatePropagationStopped = false;
        this._propagationStopped = false;
        this.type = null;
        this.type = type;
        if (eventInit) {
            this.bubbles = eventInit.bubbles || false;
            this.cancelable = eventInit.cancelable || false;
            this.composed = eventInit.composed || false;
        }
    }
    /**
     * Returns composed path.
     *
     * @returns Composed path.
     */
    composedPath() {
        if (!this.target) {
            return [];
        }
        const composedPath = [];
        let eventTarget = this.target;
        while (eventTarget) {
            composedPath.push(eventTarget);
            if (this.bubbles) {
                if (this.composed && eventTarget.host) {
                    eventTarget = eventTarget.host;
                }
                else if (this.target.ownerDocument === eventTarget) {
                    eventTarget = this.target.ownerDocument.defaultView;
                }
                else {
                    eventTarget = eventTarget.parentNode || null;
                }
            }
        }
        return composedPath;
    }
    /**
     * Init event.
     *
     * @deprecated
     * @param type Type.
     * @param [bubbles=false] "true" if it bubbles.
     * @param [cancelable=false] "true" if it cancelable.
     */
    initEvent(type, bubbles = false, cancelable = false) {
        this.type = type;
        this.bubbles = bubbles;
        this.cancelable = cancelable;
    }
    /**
     * Prevents default.
     */
    preventDefault() {
        this.defaultPrevented = true;
    }
    /**
     * Stops immediate propagation.
     */
    stopImmediatePropagation() {
        this._immediatePropagationStopped = true;
    }
    /**
     * Stops propagation.
     */
    stopPropagation() {
        this._propagationStopped = true;
    }
}
exports.default = Event;
//# sourceMappingURL=Event.js.map