"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const RelativeURL_1 = __importDefault(require("../location/RelativeURL"));
const Response_1 = __importDefault(require("./Response"));
const node_fetch_1 = __importDefault(require("node-fetch"));
/**
 * Helper class for performing fetch.
 */
class FetchHandler {
    /**
     * Returns resource data asynchonously.
     *
     * @param document Document.
     * @param url URL to resource.
     * @param [init] Init.
     * @returns Response.
     */
    static fetch(document, url, init) {
        // We want to only load NodeFetch when it is needed to improve performance and not have direct dependencies to server side packages.
        const taskManager = document.defaultView.happyDOM.asyncTaskManager;
        return new Promise((resolve, reject) => {
            const taskID = taskManager.startTask();
            (0, node_fetch_1.default)(RelativeURL_1.default.getAbsoluteURL(document.defaultView.location, url), init)
                .then((response) => {
                if (taskManager.getTaskCount() === 0) {
                    reject(new Error('Failed to complete fetch request. Task was canceled.'));
                }
                else {
                    response.constructor['_ownerDocument'] = document;
                    for (const key of Object.keys(Response_1.default.prototype)) {
                        if (Response_1.default.prototype.hasOwnProperty(key) && key !== 'constructor') {
                            if (typeof Response_1.default.prototype[key] === 'function') {
                                response[key] = Response_1.default.prototype[key].bind(response);
                            }
                            else {
                                response[key] = Response_1.default.prototype[key];
                            }
                        }
                    }
                    taskManager.endTask(taskID);
                    resolve(response);
                }
            })
                .catch((error) => {
                reject(error);
                taskManager.cancelAll(error);
            });
        });
    }
}
exports.default = FetchHandler;
//# sourceMappingURL=FetchHandler.js.map