/// <reference types="node" />
import IHeadersInit from './IHeadersInit';
import IAbortSignal from './IAbortSignal';
import { URLSearchParams } from 'url';
import IFormData from '../form-data/IFormData';
/**
 * Fetch request init.
 */
export default interface IRequestInit {
    body?: ArrayBuffer | ArrayBufferView | NodeJS.ReadableStream | string | URLSearchParams | IFormData | null;
    headers?: IHeadersInit;
    method?: string;
    redirect?: 'error' | 'manual' | 'follow';
    signal?: IAbortSignal | null;
}
