/// <reference types="node" />
import * as NodeFetch from 'node-fetch';
import IRequest from './IRequest';
import IBlob from '../file/IBlob';
import IDocument from '../nodes/document/IDocument';
/**
 * Fetch request.
 */
export default class Request extends NodeFetch.Request implements IRequest {
    static _ownerDocument: IDocument;
    readonly _ownerDocument: IDocument;
    /**
     * Constructor.
     *
     * @param input Input.
     * @param [init] Init.
     */
    constructor(input: NodeFetch.RequestInfo, init?: NodeFetch.RequestInit);
    /**
     * Returns array buffer.
     *
     * @returns Array buffer.
     */
    arrayBuffer(): Promise<ArrayBuffer>;
    /**
     * Returns blob.
     *
     * @returns Blob.
     */
    blob(): Promise<IBlob>;
    /**
     * Returns buffer.
     *
     * @returns Buffer.
     */
    buffer(): Promise<Buffer>;
    /**
     * Returns json.
     *
     * @returns JSON.
     */
    json(): Promise<unknown>;
    /**
     * Returns json.
     *
     * @returns JSON.
     */
    text(): Promise<string>;
    /**
     * Returns json.
     *
     * @returns JSON.
     */
    textConverted(): Promise<string>;
    /**
     * Handles promise start.
     *
     * @returns Task ID.
     */
    private _handlePromiseStart;
    /**
     * Handles promise end.
     *
     * @param resolve Resolve.
     * @param reject Reject.
     * @param taskID Task ID.
     * @param response Response.
     */
    private _handlePromiseEnd;
    /**
     * Handles promise error.
     *
     * @param error
     * @param reject
     */
    private _handlePromiseError;
}
