"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const NodeFetch = __importStar(require("node-fetch"));
/**
 * Fetch request.
 */
class Request extends NodeFetch.Request {
    /**
     * Constructor.
     *
     * @param input Input.
     * @param [init] Init.
     */
    constructor(input, init) {
        super(input, init);
        this._ownerDocument = null;
        this._ownerDocument = this.constructor._ownerDocument;
    }
    /**
     * Returns array buffer.
     *
     * @returns Array buffer.
     */
    arrayBuffer() {
        return new Promise((resolve, reject) => {
            const taskID = this._handlePromiseStart();
            super
                .arrayBuffer()
                .then(this._handlePromiseEnd.bind(this, resolve, reject, taskID))
                .catch(this._handlePromiseError.bind(this, reject));
        });
    }
    /**
     * Returns blob.
     *
     * @returns Blob.
     */
    blob() {
        return new Promise((resolve, reject) => {
            const taskID = this._handlePromiseStart();
            super
                .blob()
                .then(this._handlePromiseEnd.bind(this, resolve, reject, taskID))
                .catch(this._handlePromiseError.bind(this, reject));
        });
    }
    /**
     * Returns buffer.
     *
     * @returns Buffer.
     */
    buffer() {
        return new Promise((resolve, reject) => {
            const taskID = this._handlePromiseStart();
            super
                .buffer()
                .then(this._handlePromiseEnd.bind(this, resolve, reject, taskID))
                .catch(this._handlePromiseError.bind(this, reject));
        });
    }
    /**
     * Returns json.
     *
     * @returns JSON.
     */
    json() {
        return new Promise((resolve, reject) => {
            const taskID = this._handlePromiseStart();
            super
                .json()
                .then(this._handlePromiseEnd.bind(this, resolve, reject, taskID))
                .catch(this._handlePromiseError.bind(this, reject));
        });
    }
    /**
     * Returns json.
     *
     * @returns JSON.
     */
    text() {
        return new Promise((resolve, reject) => {
            const taskID = this._handlePromiseStart();
            super
                .text()
                .then(this._handlePromiseEnd.bind(this, resolve, reject, taskID))
                .catch(this._handlePromiseError.bind(this, reject));
        });
    }
    /**
     * Returns json.
     *
     * @returns JSON.
     */
    textConverted() {
        return new Promise((resolve, reject) => {
            const taskID = this._handlePromiseStart();
            super
                .textConverted()
                .then(this._handlePromiseEnd.bind(this, resolve, reject, taskID))
                .catch(this._handlePromiseError.bind(this, reject));
        });
    }
    /**
     * Handles promise start.
     *
     * @returns Task ID.
     */
    _handlePromiseStart() {
        const taskManager = this._ownerDocument.defaultView.happyDOM.asyncTaskManager;
        return taskManager.startTask();
    }
    /**
     * Handles promise end.
     *
     * @param resolve Resolve.
     * @param reject Reject.
     * @param taskID Task ID.
     * @param response Response.
     */
    _handlePromiseEnd(resolve, reject, taskID, response) {
        const taskManager = this._ownerDocument.defaultView.happyDOM.asyncTaskManager;
        if (taskManager.getTaskCount() === 0) {
            reject(new Error('Failed to complete fetch request. Task was canceled.'));
        }
        else {
            resolve(response);
            taskManager.endTask(taskID);
        }
    }
    /**
     * Handles promise error.
     *
     * @param error
     * @param reject
     */
    _handlePromiseError(reject, error) {
        const taskManager = this._ownerDocument.defaultView.happyDOM.asyncTaskManager;
        reject(error);
        taskManager.cancelAll(error);
    }
}
exports.default = Request;
// Owner document is set by a sub-class in the Window constructor
Request._ownerDocument = null;
//# sourceMappingURL=Request.js.map