/// <reference types="node" />
import IResponse from './IResponse';
import IBlob from '../file/IBlob';
import IDocument from '../nodes/document/IDocument';
import * as NodeFetch from 'node-fetch';
/**
 * Fetch response.
 */
export default class Response extends NodeFetch.Response implements IResponse {
    static _ownerDocument: IDocument;
    readonly _ownerDocument: IDocument;
    /**
     * Constructor.
     *
     * @param [body] An object defining a body for the response (can be omitted)
     * @param [init] An options object containing any custom settings that you want to apply to the response, or an empty object (which is the default value)
     */
    constructor(body?: NodeFetch.BodyInit, init?: NodeFetch.ResponseInit);
    /**
     * Returns array buffer.
     *
     * @returns Array buffer.
     */
    arrayBuffer(): Promise<ArrayBuffer>;
    /**
     * Returns blob.
     *
     * @returns Blob.
     */
    blob(): Promise<IBlob>;
    /**
     * Returns buffer.
     *
     * @returns Buffer.
     */
    buffer(): Promise<Buffer>;
    /**
     * Returns json.
     *
     * @returns JSON.
     */
    json(): Promise<unknown>;
    /**
     * Returns json.
     *
     * @returns JSON.
     */
    text(): Promise<string>;
    /**
     * Returns json.
     *
     * @returns JSON.
     */
    textConverted(): Promise<string>;
    /**
     * Handles promise start.
     *
     * @returns Task ID.
     */
    private _handlePromiseStart;
    /**
     * Handles promise end.
     *
     * @param resolve Resolve.
     * @param reject Reject.
     * @param taskID Task ID.
     * @param response Response.
     */
    private _handlePromiseEnd;
    /**
     * Handles promise error.
     *
     * @param error
     * @param reject
     */
    private _handlePromiseError;
}
