"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const URL_1 = __importDefault(require("./URL"));
/**
 *
 */
class Location extends URL_1.default {
    /**
     * Constructor.
     */
    constructor() {
        super('');
    }
    /**
     * Replaces the current resource with the one at the provided URL. The difference from the assign() method is that after using replace() the current page will not be saved in session History, meaning the user won't be able to use the back button to navigate to it.
     *
     * @param url URL.
     */
    replace(url) {
        this.parse(url);
    }
    /**
     * Loads the resource at the URL provided in parameter.
     *
     * Note: Will do the same thing as "replace()" as server-dom does not support loading the URL.
     *
     * @param url
     * @see this.replace()
     */
    assign(url) {
        this.replace(url);
    }
    /**
     * Reloads the resource from the current URL.
     *
     * Note: Will do nothing as reloading is not supported in server-dom.
     */
    reload() {
        // Do nothing
    }
}
exports.default = Location;
//# sourceMappingURL=Location.js.map