"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Helper class for getting the URL relative to a Location object.
 */
class RelativeURL {
    /**
     * Returns a URL relative to the given Location object.
     *
     * @param location Location.
     * @param url URL.
     */
    static getAbsoluteURL(location, url) {
        if (url.startsWith('/')) {
            return location.origin + url;
        }
        if (!url.startsWith('https://') && !url.startsWith('http://')) {
            let pathname = location.pathname;
            if (pathname.endsWith('/')) {
                pathname = pathname.slice(0, -1);
            }
            return location.origin + pathname + '/' + url;
        }
        return url;
    }
}
exports.default = RelativeURL;
//# sourceMappingURL=RelativeURL.js.map