"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const EventTarget_1 = __importDefault(require("../event/EventTarget"));
/**
 * Media Query List.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/MediaQueryList.
 */
class MediaQueryList extends EventTarget_1.default {
    constructor() {
        super(...arguments);
        this._matches = false;
        this._media = '';
        this.onchange = null;
    }
    /**
     * Returns "true" if the document matches.
     *
     * @returns Matches.
     */
    get matches() {
        return this._matches;
    }
    /**
     * Returns the serialized media query.
     *
     * @returns Serialized media query.
     */
    get media() {
        return this._media;
    }
    /**
     * Adds a listener.
     *
     * @deprecated
     * @param callback Callback.
     */
    addListener(callback) {
        this.addEventListener('change', callback);
    }
    /**
     * Removes listener.
     *
     * @deprecated
     * @param callback Callback.
     */
    removeListener(callback) {
        this.removeEventListener('change', callback);
    }
}
exports.default = MediaQueryList;
//# sourceMappingURL=MediaQueryList.js.map