import HTMLElement from '../html-element/HTMLElement';
import IHTMLDialogElement from './IHTMLDialogElement';
/**
 * HTML Dialog Element.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/HTMLDialogElement.
 */
export default class HTMLDialogElement extends HTMLElement implements IHTMLDialogElement {
    returnValue: string;
    /**
     * Returns open.
     *
     * @returns Open.
     */
    get open(): boolean;
    /**
     * Closes the dialog.
     *
     * @param [returnValue] ReturnValue.
     */
    close(returnValue?: string): void;
    /**
     * Shows the modal.
     */
    showModal(): void;
    /**
     * Shows the dialog.
     */
    show(): void;
}
