"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Event_1 = __importDefault(require("../../event/Event"));
const HTMLElement_1 = __importDefault(require("../html-element/HTMLElement"));
/**
 * HTML Dialog Element.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/HTMLDialogElement.
 */
class HTMLDialogElement extends HTMLElement_1.default {
    constructor() {
        super(...arguments);
        this.returnValue = '';
    }
    /**
     * Returns open.
     *
     * @returns Open.
     */
    get open() {
        return this.hasAttributeNS(null, 'open');
    }
    /**
     * Closes the dialog.
     *
     * @param [returnValue] ReturnValue.
     */
    close(returnValue = '') {
        this.removeAttributeNS(null, 'open');
        this.returnValue = returnValue;
        this.dispatchEvent(new Event_1.default('close'));
    }
    /**
     * Shows the modal.
     */
    showModal() {
        this.setAttributeNS(null, 'open', '');
    }
    /**
     * Shows the dialog.
     */
    show() {
        this.setAttributeNS(null, 'open', '');
    }
}
exports.default = HTMLDialogElement;
//# sourceMappingURL=HTMLDialogElement.js.map