import HTMLElement from '../html-element/HTMLElement';
import IElement from '../element/IElement';
import IHTMLFormElement from './IHTMLFormElement';
/**
 * HTML Form Element.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/HTMLFormElement.
 */
export default class HTMLFormElement extends HTMLElement implements IHTMLFormElement {
    /**
     * Returns name.
     *
     * @returns Name.
     */
    get name(): string;
    /**
     * Sets name.
     *
     * @param name Name.
     */
    set name(name: string);
    /**
     * Returns method.
     *
     * @returns Method.
     */
    get method(): string;
    /**
     * Sets method.
     *
     * @param method Method.
     */
    set method(method: string);
    /**
     * Returns target.
     *
     * @returns Target.
     */
    get target(): string;
    /**
     * Sets target.
     *
     * @param target Target.
     */
    set target(target: string);
    /**
     * Returns action.
     *
     * @returns Action.
     */
    get action(): string;
    /**
     * Sets action.
     *
     * @param action Action.
     */
    set action(action: string);
    /**
     * Returns encoding.
     *
     * @returns Encoding.
     */
    get encoding(): string;
    /**
     * Sets encoding.
     *
     * @param encoding Encoding.
     */
    set encoding(encoding: string);
    /**
     * Returns enctype.
     *
     * @returns Enctype.
     */
    get enctype(): string;
    /**
     * Sets enctype.
     *
     * @param enctype Enctype.
     */
    set enctype(enctype: string);
    /**
     * Returns autocomplete.
     *
     * @returns Autocomplete.
     */
    get autocomplete(): string;
    /**
     * Sets autocomplete.
     *
     * @param autocomplete Autocomplete.
     */
    set autocomplete(autocomplete: string);
    /**
     * Returns accept charset.
     *
     * @returns Accept charset.
     */
    get acceptCharset(): string;
    /**
     * Sets accept charset.
     *
     * @param acceptCharset Accept charset.
     */
    set acceptCharset(acceptCharset: string);
    /**
     * Returns no validate.
     *
     * @returns No validate.
     */
    get noValidate(): string;
    /**
     * Sets no validate.
     *
     * @param noValidate No validate.
     */
    set noValidate(noValidate: string);
    /**
     * Returns input elements.
     *
     * @returns Elements.
     */
    get elements(): IElement[];
    /**
     * Returns number of input elements.
     *
     * @returns Length.
     */
    get length(): number;
    /**
     * Submits form.
     */
    submit(): void;
    /**
     * Resets form.
     */
    reset(): void;
    /**
     * Reports validity.
     */
    reportValidity(): void;
    /**
     * Checks validity.
     *
     * @returns "true" if validation does'nt fail.
     */
    checkValidity(): boolean;
    /**
     * Clones a node.
     *
     * @override
     * @param [deep=false] "true" to clone deep.
     * @returns Cloned node.
     */
    cloneNode(deep?: boolean): IHTMLFormElement;
}
