"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const HTMLElement_1 = __importDefault(require("../html-element/HTMLElement"));
/**
 * HTML Meta Element.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/HTMLMetaElement.
 */
class HTMLMetaElement extends HTMLElement_1.default {
    /**
     * Returns content.
     *
     * @returns Content.
     */
    get content() {
        return this.getAttributeNS(null, 'content') || '';
    }
    /**
     * Sets content.
     *
     * @param content Content.
     */
    set content(content) {
        this.setAttributeNS(null, 'content', content);
    }
    /**
     * Returns httpEquiv.
     *
     * @returns HttpEquiv.
     */
    get httpEquiv() {
        return this.getAttributeNS(null, 'http-equiv') || '';
    }
    /**
     * Sets httpEquiv.
     *
     * @param httpEquiv HttpEquiv.
     */
    set httpEquiv(httpEquiv) {
        this.setAttributeNS(null, 'http-equiv', httpEquiv);
    }
    /**
     * Returns name.
     *
     * @returns Name.
     */
    get name() {
        return this.getAttributeNS(null, 'name') || '';
    }
    /**
     * Sets name.
     *
     * @param name Name.
     */
    set name(name) {
        this.setAttributeNS(null, 'name', name);
    }
    /**
     * Returns scheme.
     *
     * @returns Name.
     */
    get scheme() {
        return this.getAttributeNS(null, 'scheme') || '';
    }
    /**
     * Sets scheme.
     *
     * @param scheme Scheme.
     */
    set scheme(scheme) {
        this.setAttributeNS(null, 'scheme', scheme);
    }
}
exports.default = HTMLMetaElement;
//# sourceMappingURL=HTMLMetaElement.js.map