"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const HTMLElement_1 = __importDefault(require("../html-element/HTMLElement"));
/**
 * HTML Opt Group Element.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/HTMLOptGroupElement.
 */
class HTMLOptGroupElement extends HTMLElement_1.default {
    /**
     * Returns label.
     *
     * @returns Label.
     */
    get label() {
        return this.getAttributeNS(null, 'label') || '';
    }
    /**
     * Sets label.
     *
     * @param label Label.
     */
    set label(label) {
        if (!label) {
            this.removeAttributeNS(null, 'label');
        }
        else {
            this.setAttributeNS(null, 'label', label);
        }
    }
    /**
     * Returns disabled.
     *
     * @returns Disabled.
     */
    get disabled() {
        return this.getAttributeNS(null, 'disabled') !== null;
    }
    /**
     * Sets disabled.
     *
     * @param disabled Disabled.
     */
    set disabled(disabled) {
        if (!disabled) {
            this.removeAttributeNS(null, 'disabled');
        }
        else {
            this.setAttributeNS(null, 'disabled', '');
        }
    }
}
exports.default = HTMLOptGroupElement;
//# sourceMappingURL=HTMLOptGroupElement.js.map