import HTMLCollection from '../element/HTMLCollection';
import HTMLOptGroupElement from '../html-opt-group-element/HTMLOptGroupElement';
import HTMLOptionElement from './HTMLOptionElement';
import IHTMLOptionsCollection from './IHTMLOptionsCollection';
/**
 * HTML Options Collection.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/HTMLOptionsCollection.
 */
export default class HTMLOptionsCollection extends HTMLCollection implements IHTMLOptionsCollection {
    _selectedIndex: number;
    /**
     * Returns selectedIndex.
     *
     * @returns SelectedIndex.
     */
    get selectedIndex(): number;
    /**
     * Sets selectedIndex.
     *
     * @param selectedIndex SelectedIndex.
     */
    set selectedIndex(selectedIndex: number);
    /**
     * Returns item by index.
     *
     * @param index Index.
     */
    item(index: number): HTMLOptionElement | HTMLOptGroupElement;
    /**
     *
     * @param element
     * @param before
     */
    add(element: HTMLOptionElement | HTMLOptGroupElement, before?: number | HTMLOptionElement | HTMLOptGroupElement): void;
    /**
     * Removes indexed element from collection.
     *
     * @param index Index.
     */
    remove(index: number): void;
}
