"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const DOMException_1 = __importDefault(require("../../exception/DOMException"));
const HTMLCollection_1 = __importDefault(require("../element/HTMLCollection"));
/**
 * HTML Options Collection.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/HTMLOptionsCollection.
 */
class HTMLOptionsCollection extends HTMLCollection_1.default {
    /**
     * Returns selectedIndex.
     *
     * @returns SelectedIndex.
     */
    get selectedIndex() {
        return this._selectedIndex;
    }
    /**
     * Sets selectedIndex.
     *
     * @param selectedIndex SelectedIndex.
     */
    set selectedIndex(selectedIndex) {
        this._selectedIndex = selectedIndex;
    }
    /**
     * Returns item by index.
     *
     * @param index Index.
     */
    item(index) {
        return this[index];
    }
    /**
     *
     * @param element
     * @param before
     */
    add(element, before) {
        if (!before && before !== 0) {
            this.push(element);
            return;
        }
        if (!Number.isNaN(Number(before))) {
            if (before < 0) {
                return;
            }
            this.splice(before, 0, element);
            return;
        }
        const idx = this.findIndex((element) => element === before);
        if (idx === -1) {
            throw new DOMException_1.default("Failed to execute 'add' on 'DOMException': The node before which the new node is to be inserted is not a child of this node.");
        }
        this.splice(idx, 0, element);
    }
    /**
     * Removes indexed element from collection.
     *
     * @param index Index.
     */
    remove(index) {
        this.splice(index, 1);
        if (index === this.selectedIndex) {
            if (this.length) {
                this.selectedIndex = 0;
            }
            else {
                this.selectedIndex = -1;
            }
        }
    }
}
exports.default = HTMLOptionsCollection;
//# sourceMappingURL=HTMLOptionsCollection.js.map