"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Event_1 = __importDefault(require("../../event/Event"));
const ErrorEvent_1 = __importDefault(require("../../event/events/ErrorEvent"));
const ResourceFetchHandler_1 = __importDefault(require("../../fetch/ResourceFetchHandler"));
/**
 * Helper class for getting the URL relative to a Location object.
 */
class ScriptUtility {
    /**
     * Returns a URL relative to the given Location object.
     *
     * @param options Options.
     * @param options.element Element.
     * @param element
     */
    static async loadExternalScript(element) {
        const src = element.getAttributeNS(null, 'src');
        const async = element.getAttributeNS(null, 'async') !== null;
        if (async) {
            let code = null;
            element.ownerDocument._readyStateManager.startTask();
            try {
                code = await ResourceFetchHandler_1.default.fetch(element.ownerDocument, src);
            }
            catch (error) {
                element.dispatchEvent(new ErrorEvent_1.default('error', {
                    message: error.message,
                    error
                }));
                element.ownerDocument.defaultView.dispatchEvent(new ErrorEvent_1.default('error', {
                    message: error.message,
                    error
                }));
                if (!element['_listeners']['error'] &&
                    !element.ownerDocument.defaultView['_listeners']['error']) {
                    element.ownerDocument.defaultView.console.error(error);
                }
            }
            if (code) {
                element.ownerDocument.defaultView.eval(code);
                element.dispatchEvent(new Event_1.default('load'));
            }
            element.ownerDocument._readyStateManager.endTask();
        }
        else {
            let code = null;
            try {
                code = ResourceFetchHandler_1.default.fetchSync(element.ownerDocument, src);
            }
            catch (error) {
                element.dispatchEvent(new ErrorEvent_1.default('error', {
                    message: error.message,
                    error
                }));
                element.ownerDocument.defaultView.dispatchEvent(new ErrorEvent_1.default('error', {
                    message: error.message,
                    error
                }));
                if (!element['_listeners']['error'] &&
                    !element.ownerDocument.defaultView['_listeners']['error']) {
                    element.ownerDocument.defaultView.console.error(error);
                }
            }
            if (code) {
                element.ownerDocument.defaultView.eval(code);
                element.dispatchEvent(new Event_1.default('load'));
            }
        }
    }
}
exports.default = ScriptUtility;
//# sourceMappingURL=ScriptUtility.js.map