"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const NEW_LINES_REGEXP = /[\n\r]/gm;
/**
 * HTML select element value sanitizer.
 */
class HTMLSelectElementValueSanitizer {
    /**
     * Sanitizes a value.
     *
     * @param value Value.
     */
    static sanitize(value) {
        return value.replace(NEW_LINES_REGEXP, '');
    }
}
exports.default = HTMLSelectElementValueSanitizer;
//# sourceMappingURL=HTMLSelectElementValueSanitizer.js.map