import EventTarget from '../../event/EventTarget';
import MutationListener from '../../mutation-observer/MutationListener';
import Event from '../../event/Event';
import INode from './INode';
import IDocument from '../document/IDocument';
import IElement from '../element/IElement';
import INodeList from './INodeList';
import NodeTypeEnum from './NodeTypeEnum';
/**
 * Node.
 */
export default class Node extends EventTarget implements INode {
    static _ownerDocument: IDocument;
    static readonly ELEMENT_NODE = NodeTypeEnum.elementNode;
    static readonly TEXT_NODE = NodeTypeEnum.textNode;
    static readonly COMMENT_NODE = NodeTypeEnum.commentNode;
    static readonly DOCUMENT_NODE = NodeTypeEnum.documentNode;
    static readonly DOCUMENT_TYPE_NODE = NodeTypeEnum.documentTypeNode;
    static readonly DOCUMENT_FRAGMENT_NODE = NodeTypeEnum.documentFragmentNode;
    static readonly PROCESSING_INSTRUCTION_NODE = NodeTypeEnum.processingInstructionNode;
    readonly ELEMENT_NODE = NodeTypeEnum.elementNode;
    readonly TEXT_NODE = NodeTypeEnum.textNode;
    readonly COMMENT_NODE = NodeTypeEnum.commentNode;
    readonly DOCUMENT_NODE = NodeTypeEnum.documentNode;
    readonly DOCUMENT_TYPE_NODE = NodeTypeEnum.documentTypeNode;
    readonly DOCUMENT_FRAGMENT_NODE = NodeTypeEnum.documentFragmentNode;
    readonly PROCESSING_INSTRUCTION_NODE = NodeTypeEnum.processingInstructionNode;
    readonly ownerDocument: IDocument;
    readonly parentNode: INode;
    readonly nodeType: number;
    readonly childNodes: INodeList<INode>;
    readonly isConnected: boolean;
    _rootNode: INode;
    _observers: MutationListener[];
    /**
     * Constructor.
     */
    constructor();
    /**
     * Get text value of children.
     *
     * @returns Text content.
     */
    get textContent(): string;
    /**
     * Sets text content.
     *
     * @param textContent Text content.
     */
    set textContent(_textContent: string);
    /**
     * Node value.
     *
     * @returns Node value.
     */
    get nodeValue(): string;
    /**
     * Sets node value.
     */
    set nodeValue(_nodeValue: string);
    /**
     * Node name.
     *
     * @returns Node name.
     */
    get nodeName(): string;
    /**
     * Previous sibling.
     *
     * @returns Node.
     */
    get previousSibling(): INode;
    /**
     * Next sibling.
     *
     * @returns Node.
     */
    get nextSibling(): INode;
    /**
     * First child.
     *
     * @returns Node.
     */
    get firstChild(): INode;
    /**
     * Last child.
     *
     * @returns Node.
     */
    get lastChild(): INode;
    /**
     * Returns parent element.
     *
     * @returns Element.
     */
    get parentElement(): IElement;
    /**
     * Returns base URI.
     *
     * @returns Base URI.
     */
    get baseURI(): string;
    /**
     * Connected callback.
     */
    connectedCallback?(): void;
    /**
     * Disconnected callback.
     */
    disconnectedCallback?(): void;
    /**
     * Returns "true" if the node has child nodes.
     *
     * @returns "true" if the node has child nodes.
     */
    hasChildNodes(): boolean;
    /**
     * Returns "true" if this node contains the other node.
     *
     * @param otherNode Node to test with.
     * @returns "true" if this node contains the other node.
     */
    contains(otherNode: INode): boolean;
    /**
     * Returns closest root node (Document or ShadowRoot).
     *
     * @param options Options.
     * @param options.composed A Boolean that indicates whether the shadow root should be returned (false, the default), or a root node beyond shadow root (true).
     * @returns Node.
     */
    getRootNode(options?: {
        composed: boolean;
    }): INode;
    /**
     * Clones a node.
     *
     * @param [deep=false] "true" to clone deep.
     * @returns Cloned node.
     */
    cloneNode(deep?: boolean): INode;
    /**
     * Append a child node to childNodes.
     *
     * @param  node Node to append.
     * @returns Appended node.
     */
    appendChild(node: INode): INode;
    /**
     * Remove Child element from childNodes array.
     *
     * @param node Node to remove.
     * @returns Removed node.
     */
    removeChild(node: INode): INode;
    /**
     * Inserts a node before another.
     *
     * @param newNode Node to insert.
     * @param [referenceNode] Node to insert before.
     * @returns Inserted node.
     */
    insertBefore(newNode: INode, referenceNode: INode | null): INode;
    /**
     * Replaces a node with another.
     *
     * @param newChild New child.
     * @param oldChild Old child.
     * @returns Replaced node.
     */
    replaceChild(newChild: INode, oldChild: INode): INode;
    /**
     * @override
     */
    dispatchEvent(event: Event): boolean;
    /**
     * Converts the node to a string.
     *
     * @param listener Listener.
     */
    toString(): string;
    /**
     * Observeres the node.
     * Used by MutationObserver, but it is not part of the HTML standard.
     *
     * @param listener Listener.
     */
    _observe(listener: MutationListener): void;
    /**
     * Stops observing the node.
     * Used by MutationObserver, but it is not part of the HTML standard.
     *
     * @param listener Listener.
     */
    _unobserve(listener: MutationListener): void;
    /**
     * Connects this element to another element.
     *
     * @param parentNode Parent node.
     */
    _connectToNode(parentNode?: INode): void;
}
