"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const HTMLInputElement_1 = __importDefault(require("../html-input-element/HTMLInputElement"));
/**
 * Input validity state.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/ValidityState
 */
class ValidityState {
    /**
     * Constructor.
     *
     * @param element Input element.
     */
    constructor(element) {
        this.badInput = false;
        this.customError = false;
        this.patternMismatch = false;
        this.rangeOverflow = false;
        this.rangeUnderflow = false;
        this.stepMismatch = false;
        this.element = null;
        this.element = element;
    }
    /**
     * Returns validity.
     *
     * @returns "true" if valid.
     */
    get tooLong() {
        if (this.element instanceof HTMLInputElement_1.default) {
            return this.element.maxLength && this.element.value.length > this.element.maxLength;
        }
        return false;
    }
    /**
     * Returns validity.
     *
     * @returns "true" if valid.
     */
    get tooShort() {
        if (this.element instanceof HTMLInputElement_1.default) {
            return this.element.minLength && this.element.value.length < this.element.minLength;
        }
        return false;
    }
    /**
     * Returns validity.
     *
     * @returns "true" if valid.
     */
    get typeMismatch() {
        return false;
    }
    /**
     * Returns validity.
     *
     * @returns "true" if valid.
     */
    get valueMissing() {
        return this.element.required && !this.element.value;
    }
    /**
     * Returns validity.
     *
     * @returns "true" if valid.
     */
    get valid() {
        for (const key of Object.keys(this)) {
            if (this[key]) {
                return false;
            }
        }
        return !this.tooLong && !this.tooShort && !this.typeMismatch && !this.valueMissing;
    }
}
exports.default = ValidityState;
//# sourceMappingURL=ValidityState.js.map