/// <reference types="node" />
import Window from './Window';
/**
 * Browser window.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/Window.
 */
export default class GlobalWindow extends Window {
    ArrayBuffer: ArrayBufferConstructor;
    Boolean: BooleanConstructor;
    Buffer: typeof Buffer;
    DataView: DataViewConstructor;
    Date: DateConstructor;
    Error: ErrorConstructor;
    EvalError: EvalErrorConstructor;
    Float32Array: Float32ArrayConstructor;
    Float64Array: Float64ArrayConstructor;
    GLOBAL: any;
    Infinity: number;
    Int16Array: Int16ArrayConstructor;
    Int32Array: Int32ArrayConstructor;
    Int8Array: Int8ArrayConstructor;
    Intl: typeof Intl;
    JSON: JSON;
    Map: MapConstructor;
    Math: Math;
    NaN: number;
    Number: NumberConstructor;
    Promise: PromiseConstructor;
    RangeError: RangeErrorConstructor;
    ReferenceError: ReferenceErrorConstructor;
    RegExp: RegExpConstructor;
    Reflect: ArrayBufferConstructor;
    Set: SetConstructor;
    Symbol: SymbolConstructor;
    SyntaxError: SyntaxErrorConstructor;
    String: StringConstructor;
    TypeError: TypeErrorConstructor;
    URIError: URIErrorConstructor;
    Uint16Array: Uint16ArrayConstructor;
    Uint32Array: Uint32ArrayConstructor;
    Uint8Array: Uint8ArrayConstructor;
    Uint8ClampedArray: Uint8ClampedArrayConstructor;
    WeakMap: WeakMapConstructor;
    WeakSet: WeakSetConstructor;
    clearImmediate: typeof clearImmediate;
    decodeURI: typeof decodeURI;
    decodeURIComponent: typeof decodeURIComponent;
    encodeURI: typeof encodeURI;
    encodeURIComponent: typeof encodeURIComponent;
    escape: typeof escape;
    global: NodeJS.Global & typeof globalThis;
    isFinite: typeof isFinite;
    isNaN: typeof isNaN;
    parseFloat: typeof parseFloat;
    parseInt: typeof parseInt;
    process: NodeJS.Process;
    root: ArrayBufferConstructor;
    setImmediate: typeof setImmediate;
    queueMicrotask: typeof queueMicrotask;
    undefined: ArrayBufferConstructor;
    unescape: typeof unescape;
    gc: any;
    v8debug: any;
    AbortController: {
        new (): AbortController;
        prototype: AbortController;
    };
    AbortSignal: {
        new (): AbortSignal;
        prototype: AbortSignal;
    };
    Array: ArrayConstructor;
    Object: ObjectConstructor;
    Function: FunctionConstructor;
    /**
     * Evaluates code.
     *
     * @param code Code.
     * @returns Result.
     */
    eval(code: string): unknown;
    /**
     * Setup of VM context.
     *
     * @override
     */
    protected _setupVMContext(): void;
}
