"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const CustomElementRegistry_1 = __importDefault(require("../custom-element/CustomElementRegistry"));
const Document_1 = __importDefault(require("../nodes/document/Document"));
const HTMLDocument_1 = __importDefault(require("../nodes/html-document/HTMLDocument"));
const XMLDocument_1 = __importDefault(require("../nodes/xml-document/XMLDocument"));
const SVGDocument_1 = __importDefault(require("../nodes/svg-document/SVGDocument"));
const Node_1 = __importDefault(require("../nodes/node/Node"));
const NodeFilter_1 = __importDefault(require("../tree-walker/NodeFilter"));
const Text_1 = __importDefault(require("../nodes/text/Text"));
const Comment_1 = __importDefault(require("../nodes/comment/Comment"));
const ShadowRoot_1 = __importDefault(require("../nodes/shadow-root/ShadowRoot"));
const Element_1 = __importDefault(require("../nodes/element/Element"));
const HTMLTemplateElement_1 = __importDefault(require("../nodes/html-template-element/HTMLTemplateElement"));
const HTMLFormElement_1 = __importDefault(require("../nodes/html-form-element/HTMLFormElement"));
const HTMLElement_1 = __importDefault(require("../nodes/html-element/HTMLElement"));
const HTMLUnknownElement_1 = __importDefault(require("../nodes/html-unknown-element/HTMLUnknownElement"));
const HTMLInputElement_1 = __importDefault(require("../nodes/html-input-element/HTMLInputElement"));
const HTMLTextAreaElement_1 = __importDefault(require("../nodes/html-text-area-element/HTMLTextAreaElement"));
const HTMLLinkElement_1 = __importDefault(require("../nodes/html-link-element/HTMLLinkElement"));
const HTMLStyleElement_1 = __importDefault(require("../nodes/html-style-element/HTMLStyleElement"));
const HTMLSlotElement_1 = __importDefault(require("../nodes/html-slot-element/HTMLSlotElement"));
const HTMLLabelElement_1 = __importDefault(require("../nodes/html-label-element/HTMLLabelElement"));
const HTMLMetaElement_1 = __importDefault(require("../nodes/html-meta-element/HTMLMetaElement"));
const HTMLBaseElement_1 = __importDefault(require("../nodes/html-base-element/HTMLBaseElement"));
const HTMLDialogElement_1 = __importDefault(require("../nodes/html-dialog-element/HTMLDialogElement"));
const SVGSVGElement_1 = __importDefault(require("../nodes/svg-element/SVGSVGElement"));
const SVGElement_1 = __importDefault(require("../nodes/svg-element/SVGElement"));
const HTMLScriptElement_1 = __importDefault(require("../nodes/html-script-element/HTMLScriptElement"));
const HTMLImageElement_1 = __importDefault(require("../nodes/html-image-element/HTMLImageElement"));
const Image_1 = __importDefault(require("../nodes/html-image-element/Image"));
const DocumentFragment_1 = __importDefault(require("../nodes/document-fragment/DocumentFragment"));
const CharacterData_1 = __importDefault(require("../nodes/character-data/CharacterData"));
const TreeWalker_1 = __importDefault(require("../tree-walker/TreeWalker"));
const Event_1 = __importDefault(require("../event/Event"));
const CustomEvent_1 = __importDefault(require("../event/events/CustomEvent"));
const AnimationEvent_1 = __importDefault(require("../event/events/AnimationEvent"));
const KeyboardEvent_1 = __importDefault(require("../event/events/KeyboardEvent"));
const ProgressEvent_1 = __importDefault(require("../event/events/ProgressEvent"));
const EventTarget_1 = __importDefault(require("../event/EventTarget"));
const URL_1 = __importDefault(require("../location/URL"));
const Location_1 = __importDefault(require("../location/Location"));
const NonImplementedEventTypes_1 = __importDefault(require("../event/NonImplementedEventTypes"));
const MutationObserver_1 = __importDefault(require("../mutation-observer/MutationObserver"));
const NonImplemenetedElementClasses_1 = __importDefault(require("../config/NonImplemenetedElementClasses"));
const DOMParser_1 = __importDefault(require("../dom-parser/DOMParser"));
const XMLSerializer_1 = __importDefault(require("../xml-serializer/XMLSerializer"));
const ResizeObserver_1 = __importDefault(require("../resize-observer/ResizeObserver"));
const Blob_1 = __importDefault(require("../file/Blob"));
const File_1 = __importDefault(require("../file/File"));
const DOMException_1 = __importDefault(require("../exception/DOMException"));
const FileReader_1 = __importDefault(require("../file/FileReader"));
const History_1 = __importDefault(require("../history/History"));
const CSSStyleSheet_1 = __importDefault(require("../css/CSSStyleSheet"));
const CSSStyleDeclaration_1 = __importDefault(require("../css/CSSStyleDeclaration"));
const CSS_1 = __importDefault(require("../css/CSS"));
const CSSUnitValue_1 = __importDefault(require("../css/CSSUnitValue"));
const MouseEvent_1 = __importDefault(require("../event/events/MouseEvent"));
const PointerEvent_1 = __importDefault(require("../event/events/PointerEvent"));
const FocusEvent_1 = __importDefault(require("../event/events/FocusEvent"));
const WheelEvent_1 = __importDefault(require("../event/events/WheelEvent"));
const DataTransfer_1 = __importDefault(require("../event/DataTransfer"));
const DataTransferItem_1 = __importDefault(require("../event/DataTransferItem"));
const DataTransferItemList_1 = __importDefault(require("../event/DataTransferItemList"));
const InputEvent_1 = __importDefault(require("../event/events/InputEvent"));
const UIEvent_1 = __importDefault(require("../event/UIEvent"));
const ErrorEvent_1 = __importDefault(require("../event/events/ErrorEvent"));
const StorageEvent_1 = __importDefault(require("../event/events/StorageEvent"));
const Screen_1 = __importDefault(require("../screen/Screen"));
const AsyncTaskManager_1 = __importDefault(require("../async-task-manager/AsyncTaskManager"));
const Headers_1 = __importDefault(require("../fetch/Headers"));
const Request_1 = __importDefault(require("../fetch/Request"));
const Response_1 = __importDefault(require("../fetch/Response"));
const Storage_1 = __importDefault(require("../storage/Storage"));
const HTMLCollection_1 = __importDefault(require("../nodes/element/HTMLCollection"));
const NodeList_1 = __importDefault(require("../nodes/node/NodeList"));
const MediaQueryList_1 = __importDefault(require("../match-media/MediaQueryList"));
const Selection_1 = __importDefault(require("../selection/Selection"));
const Navigator_1 = __importDefault(require("../navigator/Navigator"));
const MimeType_1 = __importDefault(require("../navigator/MimeType"));
const MimeTypeArray_1 = __importDefault(require("../navigator/MimeTypeArray"));
const Plugin_1 = __importDefault(require("../navigator/Plugin"));
const PluginArray_1 = __importDefault(require("../navigator/PluginArray"));
const url_1 = require("url");
const FetchHandler_1 = __importDefault(require("../fetch/FetchHandler"));
const Range_1 = __importDefault(require("../range/Range"));
const VMGlobalPropertyScript_1 = __importDefault(require("./VMGlobalPropertyScript"));
const PerfHooks = __importStar(require("perf_hooks"));
const vm_1 = __importDefault(require("vm"));
const buffer_1 = require("buffer");
const Base64_1 = __importDefault(require("../base64/Base64"));
const ORIGINAL_SET_TIMEOUT = setTimeout;
const ORIGINAL_CLEAR_TIMEOUT = clearTimeout;
const ORIGINAL_SET_INTERVAL = setInterval;
const ORIGINAL_CLEAR_INTERVAL = clearInterval;
/**
 * Browser window.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/Window.
 */
class Window extends EventTarget_1.default {
    /**
     * Constructor.
     */
    constructor() {
        super();
        this._setTimeout = ORIGINAL_SET_TIMEOUT;
        this._clearTimeout = ORIGINAL_CLEAR_TIMEOUT;
        this._setInterval = ORIGINAL_SET_INTERVAL;
        this._clearInterval = ORIGINAL_CLEAR_INTERVAL;
        // Non-implemented event types
        for (const eventType of NonImplementedEventTypes_1.default) {
            if (!this[eventType]) {
                this[eventType] = Event_1.default;
            }
        }
        // Non implemented element classes
        for (const className of NonImplemenetedElementClasses_1.default) {
            if (!this[className]) {
                this[className] = HTMLElement_1.default;
            }
        }
        // The Happy DOM property
        this.happyDOM = {
            whenAsyncComplete: async () => {
                return await this.happyDOM.asyncTaskManager.whenComplete();
            },
            cancelAsync: () => {
                this.happyDOM.asyncTaskManager.cancelAll();
            },
            asyncTaskManager: new AsyncTaskManager_1.default()
        };
        // Global classes
        this.Node = Node_1.default;
        this.HTMLElement = HTMLElement_1.default;
        this.HTMLUnknownElement = HTMLUnknownElement_1.default;
        this.HTMLTemplateElement = HTMLTemplateElement_1.default;
        this.HTMLFormElement = HTMLFormElement_1.default;
        this.HTMLInputElement = HTMLInputElement_1.default;
        this.HTMLTextAreaElement = HTMLTextAreaElement_1.default;
        this.HTMLImageElement = HTMLImageElement_1.default;
        this.HTMLScriptElement = HTMLScriptElement_1.default;
        this.HTMLLinkElement = HTMLLinkElement_1.default;
        this.HTMLStyleElement = HTMLStyleElement_1.default;
        this.HTMLLabelElement = HTMLLabelElement_1.default;
        this.HTMLSlotElement = HTMLSlotElement_1.default;
        this.HTMLMetaElement = HTMLMetaElement_1.default;
        this.HTMLBaseElement = HTMLBaseElement_1.default;
        this.HTMLDialogElement = HTMLDialogElement_1.default;
        this.SVGSVGElement = SVGSVGElement_1.default;
        this.SVGElement = SVGElement_1.default;
        this.Text = Text_1.default;
        this.Comment = Comment_1.default;
        this.ShadowRoot = ShadowRoot_1.default;
        this.Element = Element_1.default;
        this.DocumentFragment = DocumentFragment_1.default;
        this.CharacterData = CharacterData_1.default;
        this.NodeFilter = NodeFilter_1.default;
        this.TreeWalker = TreeWalker_1.default;
        this.MutationObserver = MutationObserver_1.default;
        this.Document = Document_1.default;
        this.HTMLDocument = HTMLDocument_1.default;
        this.XMLDocument = XMLDocument_1.default;
        this.SVGDocument = SVGDocument_1.default;
        this.Event = Event_1.default;
        this.UIEvent = UIEvent_1.default;
        this.CustomEvent = CustomEvent_1.default;
        this.AnimationEvent = AnimationEvent_1.default;
        this.KeyboardEvent = KeyboardEvent_1.default;
        this.MouseEvent = MouseEvent_1.default;
        this.PointerEvent = PointerEvent_1.default;
        this.FocusEvent = FocusEvent_1.default;
        this.WheelEvent = WheelEvent_1.default;
        this.InputEvent = InputEvent_1.default;
        this.ErrorEvent = ErrorEvent_1.default;
        this.StorageEvent = StorageEvent_1.default;
        this.ProgressEvent = ProgressEvent_1.default;
        this.EventTarget = EventTarget_1.default;
        this.DataTransfer = DataTransfer_1.default;
        this.DataTransferItem = DataTransferItem_1.default;
        this.DataTransferItemList = DataTransferItemList_1.default;
        this.URL = URL_1.default;
        this.Location = Location_1.default;
        this.CustomElementRegistry = CustomElementRegistry_1.default;
        this.Window = this.constructor;
        this.XMLSerializer = XMLSerializer_1.default;
        this.ResizeObserver = ResizeObserver_1.default;
        this.CSSStyleSheet = CSSStyleSheet_1.default;
        this.Blob = Blob_1.default;
        this.File = File_1.default;
        this.DOMException = DOMException_1.default;
        this.History = History_1.default;
        this.Screen = Screen_1.default;
        this.Storage = Storage_1.default;
        this.URLSearchParams = url_1.URLSearchParams;
        this.HTMLCollection = HTMLCollection_1.default;
        this.NodeList = NodeList_1.default;
        this.MediaQueryList = MediaQueryList_1.default;
        this.CSSUnitValue = CSSUnitValue_1.default;
        this.Selection = Selection_1.default;
        this.Navigator = Navigator_1.default;
        this.MimeType = MimeType_1.default;
        this.MimeTypeArray = MimeTypeArray_1.default;
        this.Plugin = Plugin_1.default;
        this.PluginArray = PluginArray_1.default;
        this.Headers = Headers_1.default;
        // Events
        this.onload = null;
        this.onerror = null;
        this.customElements = new CustomElementRegistry_1.default();
        this.location = new Location_1.default();
        this.history = new History_1.default();
        this.navigator = new Navigator_1.default();
        this.console = console;
        this.self = this;
        this.top = this;
        this.parent = this;
        this.window = this;
        this.globalThis = this;
        this.screen = new Screen_1.default();
        this.innerWidth = 1024;
        this.innerHeight = 768;
        this.devicePixelRatio = 1;
        this.sessionStorage = new Storage_1.default();
        this.localStorage = new Storage_1.default();
        this.performance = PerfHooks.performance;
        this.Buffer = buffer_1.Buffer;
        // Binds all methods to "this", so that it will use the correct context when called globally.
        for (const key of Object.getOwnPropertyNames(Window.prototype).concat(Object.getOwnPropertyNames(EventTarget_1.default.prototype))) {
            if (key !== 'constructor' &&
                key[0] !== '_' &&
                key[0] === key[0].toLowerCase() &&
                typeof this[key] === 'function') {
                this[key] = this[key].bind(this);
            }
        }
        HTMLDocument_1.default._defaultView = this;
        const document = new HTMLDocument_1.default();
        this.document = document;
        // We need to set the correct owner document when the class is constructed.
        // To achieve this we will extend the original implementation with a class that sets the owner document.
        Response_1.default._ownerDocument = document;
        Request_1.default._ownerDocument = document;
        Image_1.default._ownerDocument = document;
        FileReader_1.default._ownerDocument = document;
        DOMParser_1.default._ownerDocument = document;
        Range_1.default._ownerDocument = document;
        /* eslint-disable jsdoc/require-jsdoc */
        class Response extends Response_1.default {
        }
        Response._ownerDocument = document;
        class Request extends Request_1.default {
        }
        Request._ownerDocument = document;
        class Image extends Image_1.default {
        }
        Image._ownerDocument = document;
        class FileReader extends FileReader_1.default {
        }
        FileReader._ownerDocument = document;
        class DOMParser extends DOMParser_1.default {
        }
        DOMParser._ownerDocument = document;
        class Range extends Range_1.default {
        }
        Range._ownerDocument = document;
        /* eslint-enable jsdoc/require-jsdoc */
        this.Response = Response;
        this.Request = Request;
        this.Image = Image;
        this.FileReader = FileReader;
        this.DOMParser = DOMParser;
        this.Range = Range;
        this._setupVMContext();
        this.document._onWindowReady();
    }
    /**
     * The CSS interface holds useful CSS-related methods.
     *
     * @returns CSS interface.
     */
    get CSS() {
        return new CSS_1.default();
    }
    /**
     * Evaluates code.
     *
     * @override
     * @param code Code.
     * @returns Result.
     */
    eval(code) {
        if (vm_1.default.isContext(this)) {
            return vm_1.default.runInContext(code, this);
        }
        return eval(code);
    }
    /**
     * Returns an object containing the values of all CSS properties of an element.
     *
     * @param element Element.
     * @returns CSS style declaration.
     */
    getComputedStyle(element) {
        return new CSSStyleDeclaration_1.default(element._attributes, element);
    }
    /**
     * Returns selection.
     *
     * @returns Selection.
     */
    getSelection() {
        return this.document.getSelection();
    }
    /**
     * Scrolls to a particular set of coordinates.
     *
     * @param x X position or options object.
     * @param y Y position.
     */
    scroll(x, y) {
        if (typeof x === 'object') {
            if (x.behavior === 'smooth') {
                this.setTimeout(() => {
                    if (x.top !== undefined) {
                        this.document.documentElement.scrollTop = x.top;
                    }
                    if (x.left !== undefined) {
                        this.document.documentElement.scrollLeft = x.left;
                    }
                });
            }
            else {
                if (x.top !== undefined) {
                    this.document.documentElement.scrollTop = x.top;
                }
                if (x.left !== undefined) {
                    this.document.documentElement.scrollLeft = x.left;
                }
            }
        }
        else if (x !== undefined && y !== undefined) {
            this.document.documentElement.scrollLeft = x;
            this.document.documentElement.scrollTop = y;
        }
    }
    /**
     * Scrolls to a particular set of coordinates.
     *
     * @param x X position or options object.
     * @param y Y position.
     */
    scrollTo(x, y) {
        this.scroll(x, y);
    }
    /**
     * Returns a new MediaQueryList object that can then be used to determine if the document matches the media query string.
     *
     * @param mediaQueryString A string specifying the media query to parse into a MediaQueryList.
     * @returns A new MediaQueryList.
     */
    matchMedia(mediaQueryString) {
        const mediaQueryList = new MediaQueryList_1.default();
        mediaQueryList._media = mediaQueryString;
        return mediaQueryList;
    }
    /**
     * Sets a timer which executes a function once the timer expires.
     *
     * @override
     * @param callback Function to be executed.
     * @param [delay=0] Delay in ms.
     * @returns Timeout ID.
     */
    setTimeout(callback, delay = 0) {
        const id = this._setTimeout(() => {
            this.happyDOM.asyncTaskManager.endTimer(id);
            callback();
        }, delay);
        this.happyDOM.asyncTaskManager.startTimer(id);
        return id;
    }
    /**
     * Cancels a timeout previously established by calling setTimeout().
     *
     * @override
     * @param id ID of the timeout.
     */
    clearTimeout(id) {
        this._clearTimeout(id);
        this.happyDOM.asyncTaskManager.endTimer(id);
    }
    /**
     * Calls a function with a fixed time delay between each call.
     *
     * @override
     * @param callback Function to be executed.
     * @param [delay=0] Delay in ms.
     * @returns Interval ID.
     */
    setInterval(callback, delay = 0) {
        const id = this._setInterval(callback, delay);
        this.happyDOM.asyncTaskManager.startTimer(id);
        return id;
    }
    /**
     * Cancels a timed repeating action which was previously established by a call to setInterval().
     *
     * @override
     * @param id ID of the interval.
     */
    clearInterval(id) {
        this._clearInterval(id);
        this.happyDOM.asyncTaskManager.endTimer(id);
    }
    /**
     * Mock animation frames with timeouts.
     *
     * @override
     * @param callback Callback.
     * @returns Timeout ID.
     */
    requestAnimationFrame(callback) {
        return this.setTimeout(() => {
            callback(2);
        });
    }
    /**
     * Mock animation frames with timeouts.
     *
     * @override
     * @param id Timeout ID.
     */
    cancelAnimationFrame(id) {
        this.clearTimeout(id);
    }
    /**
     * This method provides an easy, logical way to fetch resources asynchronously across the network.
     *
     * @override
     * @param url URL.
     * @param [init] Init.
     * @returns Promise.
     */
    async fetch(url, init) {
        return await FetchHandler_1.default.fetch(this.document, url, init);
    }
    /**
     * Creates a Base64-encoded ASCII string from a binary string (i.e., a string in which each character in the string is treated as a byte of binary data).
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/API/btoa
     * @param data Binay data.
     * @returns Base64-encoded string.
     */
    btoa(data) {
        return Base64_1.default.btoa(data);
    }
    /**
     * Decodes a string of data which has been encoded using Base64 encoding.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/API/atob
     * @see https://infra.spec.whatwg.org/#forgiving-base64-encode.
     * @see Https://html.spec.whatwg.org/multipage/webappapis.html#btoa.
     * @param data Binay string.
     * @returns An ASCII string containing decoded data from encodedData.
     */
    atob(data) {
        return Base64_1.default.atob(data);
    }
    /**
     * Setup of VM context.
     */
    _setupVMContext() {
        if (!vm_1.default.isContext(this)) {
            vm_1.default.createContext(this);
            // Sets global properties from the VM to the Window object.
            // Otherwise "this.Array" will be undefined for example.
            vm_1.default.runInContext(VMGlobalPropertyScript_1.default, this);
        }
    }
}
exports.default = Window;
//# sourceMappingURL=Window.js.map