import CSSRule from '../CSSRule';
import MediaList from '../MediaList';

/**
 * CSSRule interface.
 */
export default class CSSMediaRule extends CSSRule {
	public readonly type = CSSRule.MEDIA_RULE;
	public readonly cssRules: CSSRule[] = [];
	public readonly media = new MediaList();

	/**
	 * Returns css text.
	 *
	 * @returns CSS text.
	 */
	public get cssText(): string {
		let cssText = '';
		for (const cssRule of this.cssRules) {
			cssText += cssRule.cssText;
		}
		return `@media ${this.conditionalText} { ${cssText} }`;
	}

	/**
	 * Returns conditional text.
	 *
	 * @returns Conditional text.
	 */
	public get conditionalText(): string {
		return this.media.mediaText;
	}
}
