import { IHasher } from './WASMInterface';
import { IDataType } from './util';
/**
 * Calculates SHA-2 (SHA-384) hash
 * @param data Input data (string, Buffer or TypedArray)
 * @returns Computed hash as a hexadecimal string
 */
export declare function sha384(data: IDataType): Promise<string>;
/**
 * Creates a new SHA-2 (SHA-384) hash instance
 */
export declare function createSHA384(): Promise<IHasher>;
