/**
 * @template {CreateElementLike} H
 *   Type of hyperscript function.
 * @param {H} h
 *   HyperScript function.
 * @param {Node} tree
 *   Tree to transform.
 * @param {string | boolean | Options | null | undefined} [options]
 *   Configuration (optional).
 * @returns {ReturnType<H>}
 *   Return type of the hyperscript function.
 */
export function toH<H extends CreateElementLike>(
  h: H,
  tree: Node,
  options?: string | boolean | Options | null | undefined
): ReturnType<H>
export type Schema = import('property-information').Schema
export type Content = import('hast').Content
export type Element = import('hast').Element
export type Root = import('hast').Root
export type Node = Root | Content
/**
 * Function that works somewhat like `React.createElement`.
 */
export type CreateElementLike = (
  name: string,
  attributes: any,
  children?: any[] | undefined
) => any
/**
 * Info passed around.
 */
export type State = {
  /**
   *  Current schema.
   */
  schema: Schema
  /**
   *  Prefix to use.
   */
  prefix: string | undefined
  /**
   *  Current key.
   */
  key: number
  /**
   *  Looks like React.
   */
  react: boolean
  /**
   *  Looks like Vue.
   */
  vue: boolean
  /**
   *  Looks like vdom.
   */
  vdom: boolean
  /**
   *  Looks like `hyperscript`.
   */
  hyperscript: boolean
}
/**
 * Configuration.
 */
export type Options = {
  /**
   * Prefix to use as a prefix for keys passed in `props` to `h()`, this
   * behavior is turned off by passing `false` and turned on by passing a
   * `string`.
   * By default, `h-` is used as a prefix if the given `h` is detected as being
   * `virtual-dom/h` or `React.createElement`
   */
  prefix?: string | null | undefined
  /**
   * Whether `node` is in the `'html'` or `'svg'` space.
   * If an `<svg>` element is found when inside the HTML space, `toH`
   * automatically switches to the SVG space when entering the element, and
   * switches back when exiting.
   */
  space?: 'html' | 'svg' | null | undefined
}
