/**
 * Given a hast tree and an optional vfile (for positional info), return a new
 * parsed-again hast tree.
 *
 * @param {Node} tree Original hast tree
 * @param {VFile} [file] Virtual file for positional info
 * @param {Options} [options] Configuration
 */
export function raw(
  tree: Node,
  file?: VFile,
  options?: Options
):
  | import('hast').Root
  | import('hast').DocType
  | import('hast').Element
  | import('hast').Text
  | import('hast').Comment
export type P5Document = import('parse5').Document
export type P5Fragment = import('parse5').DocumentFragment
export type P5Element = import('parse5').Element
export type P5Attribute = import('parse5').Attribute
export type P5Location = import('parse5').Location
export type P5ParserOptions = import('parse5').ParserOptions
export type UnistNode = import('unist').Node
export type Parent = import('hast').Parent
export type Literal = import('hast').Literal
export type Root = import('hast').Root
export type Doctype = import('hast').DocType
export type Element = import('hast').Element
export type Text = import('hast').Text
export type Comment = import('hast').Comment
export type Raw = Literal & {
  type: 'raw'
}
export type Child = Parent['children'][number]
export type Node = Child | Root | Raw
export type VFile = import('vfile').VFile
export type Stitch = Literal & {
  type: 'comment'
  value: {
    stitch: UnistNode
  }
}
export type Options = {
  /**
   * List of custom hast node types to pass through (keep) in hast. If the passed through nodes have children, those children are expected to be hast and will be handled
   */
  passThrough: Array<string>
}
export type HiddenTokenizer = {
  /**
   * Way too simple, but works for us.
   */
  __mixins: Array<HiddenLocationTracker>
  preprocessor: HiddenPreprocessor
  write: (value: string) => void
  tokenQueue: Array<HiddenToken>
  state: string
  returnState: string
  charRefCode: number
  tempBuff: Array<number>
  lastStartTagName: string
  consumedAfterSnapshot: number
  active: boolean
  currentCharacterToken: HiddenToken
  currentToken: HiddenToken
  currentAttr: unknown
}
export type HiddenToken = {
  [x: string]: unknown
} & {
  location: P5Location
}
export type HiddenPreprocessor = {
  html: string
  pos: number
  lastGapPos: number
  lastCharPos: number
  gapStack: Array<number>
  skipNextNewLine: boolean
  lastChunkWritten: boolean
  endOfChunkHit: boolean
}
export type HiddenLocationTracker = {
  currentAttrLocation: P5Location
  ctLoc: P5Location
  posTracker: HiddenPosTracker
}
export type HiddenPosTracker = {
  isEol: boolean
  lineStartPos: number
  droppedBufferSize: number
  offset: number
  col: number
  line: number
}
