/*!
 * @he-tree/vue3 v1.2.9
 * (c) phphe <phphe@outlook.com> (https://github.com/phphe)
 * Homepage: https://hetree.phphe.com
 * Released under the undefined License.
 */
import _asyncToGenerator from '@babel/runtime/helpers/asyncToGenerator';
import _toConsumableArray from '@babel/runtime/helpers/toConsumableArray';
import _defineProperty from '@babel/runtime/helpers/defineProperty';
import _regeneratorRuntime from '@babel/runtime/regenerator';
import { defineComponent, nextTick, openBlock, createElementBlock, createBlock, resolveDynamicComponent, normalizeClass, normalizeStyle, withCtx, Fragment, renderList, renderSlot, resolveComponent, createElementVNode, createTextVNode, toDisplayString } from 'vue';
import * as hp from 'helper-js';
import _classCallCheck from '@babel/runtime/helpers/classCallCheck';
import _createClass from '@babel/runtime/helpers/createClass';
import draggableHelper from 'draggable-helper';

function _createForOfIteratorHelper$3(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$3(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$3(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$3(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$3(o, minLen); }

function _arrayLikeToArray$3(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function genNodeID() {
  return "ht_".concat(hp.randString(12));
}
function initNode(node) {
  if (!node.$id) {
    node.$id = genNodeID();
  }

  if (!node.$children) {
    node.$children = [];
  }
}
function convertTreeDataToFlat(data) {
  var childrenKey = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "children";
  var idKey = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "id";
  var flatData = [];
  var mapForPid = new Map();
  hp.walkTreeData(data, function (node, index, parent) {
    var newNode = _objectSpread({
      $id: node[idKey],
      $pid: ""
    }, node);

    initNode(newNode);
    mapForPid.set(node, newNode.$id);
    newNode.$pid = parent && mapForPid.get(parent) || null;
    flatData.push(newNode);
  }, childrenKey);
  return convertFlatDataToStandard(flatData, "$id", "$pid");
}
function convertFlatDataToStandard(data) {
  var idKey = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "id";
  var pidKey = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "parent_id";
  var nodesByID = {};
  var nodes = data.map(function (node) {
    // @ts-ignore
    var newNode = _objectSpread(_objectSpread({
      $id: node[idKey],
      $pid: node[pidKey]
    }, node), {}, {
      $children: []
    });

    initNode(newNode);
    nodesByID[newNode.$id] = newNode;
    return newNode;
  });
  var top = [];

  var _iterator = _createForOfIteratorHelper$3(nodes),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var node = _step.value;

      if (node.$level == null) {
        node.$level = resolveLevel(node);
      }

      var parent = node.$pid && nodesByID[node.$pid];

      if (parent) {
        parent.$children.push(node);
      }

      if (node.$level === 1) {
        top.push(node);
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  nodes = [];
  hp.walkTreeData(top, function (node) {
    nodes.push(node);
  }, "$children");
  return {
    nodes: nodes,
    nodesByID: nodesByID
  }; //

  function resolveLevel(node) {
    if (node.$level && node.$level > 0) {
      return node.$level;
    } else {
      var parent = nodesByID[node.$pid || ""];

      if (!parent) {
        return 1;
      } else {
        return resolveLevel(parent) + 1;
      }
    }
  }
}

function _createForOfIteratorHelper$2(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$2(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$2(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$2(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$2(o, minLen); }

function _arrayLikeToArray$2(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }
var script$2 = defineComponent({
  props: {
    items: {
      type: Array,
      default: function _default() {
        return [];
      }
    },
    enabled: {
      type: Boolean,
      default: true
    },
    buffer: {
      type: Number,
      default: 200
    },
    minItemHeight: {
      type: Number,
      default: 20
    },
    prerender: {
      type: Number,
      default: 20
    },
    listTag: {
      type: String,
      default: "div"
    },
    listClass: {
      type: String
    },
    itemClass: {
      type: String,
      default: "vl-item"
    },
    gap: {
      type: Number,
      default: 0
    },
    afterCalcTop2: {
      type: Function
    },
    isForceVisible: {
      type: Function
    }
  },
  data: function data() {
    var _this = this;

    return {
      start: 0,
      end: -1,
      top: 0,
      bottom: 0,
      totalHeight: 0,
      itemsHeight: [],
      mountedPromise: new Promise(function (resolve, reject) {
        _this._mountedPromise_resolve = resolve;
      })
    };
  },
  computed: {
    visibleItems: function visibleItems() {
      var _this2 = this;

      var r = [];
      this.items.forEach(function (item, index) {
        if (!_this2.enabled) {
          r.push({
            item: item,
            index: index
          });
        } else if (index >= _this2.start && index <= _this2.end || _this2.isForceVisible && _this2.isForceVisible(item, index)) {
          r.push({
            item: item,
            index: index
          });
        }
      });
      return r;
    }
  },
  watch: {
    enabled: {
      immediate: true,
      handler: function handler() {
        if (!this.enabled) {
          // @ts-ignore
          this.totalHeight = undefined;
        }
      }
    }
  },
  methods: {
    getItemElHeight: function getItemElHeight(el) {
      return hp.getBoundingClientRect(el).height + this.gap;
    },
    update: function update() {
      var _this3 = this;

      var task = /*#__PURE__*/function () {
        var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2() {
          var existingHeight, i, _iterator, _step, child, _index, avgHeight, buffer, itemsHeight, items, _this3$$el, clientHeight, scrollTop, start, top, maxIndex, topSpace, newTop, top2, end, bottom, index, totalHeight, waitDOMUpdated, next;

          return _regeneratorRuntime.wrap(function _callee2$(_context2) {
            while (1) {
              switch (_context2.prev = _context2.next) {
                case 0:
                  if (_this3.enabled) {
                    _context2.next = 4;
                    break;
                  }

                  _this3.start = 0;
                  _this3.end = _this3.items.length;
                  return _context2.abrupt("return");

                case 4:
                  _context2.next = 6;
                  return _this3.mountedPromise;

                case 6:
                  existingHeight = 0;
                  i = 0;
                  _iterator = _createForOfIteratorHelper$2(_this3.$el.querySelector(".vl-items").children);

                  try {
                    for (_iterator.s(); !(_step = _iterator.n()).done;) {
                      child = _step.value;

                      if ((child.style.position === "" || child.style.position == null) && child.style.display !== "none") {
                        i++;
                        _index = parseInt(child.getAttribute("data-vindex"));
                        _this3.itemsHeight[_index] = _this3.getItemElHeight(child);
                        existingHeight += _this3.itemsHeight[_index];
                      }
                    }
                  } catch (err) {
                    _iterator.e(err);
                  } finally {
                    _iterator.f();
                  }

                  avgHeight = existingHeight / i || _this3.minItemHeight;
                  buffer = _this3.buffer, itemsHeight = _this3.itemsHeight, items = _this3.items;
                  _this3$$el = _this3.$el, clientHeight = _this3$$el.clientHeight, scrollTop = _this3$$el.scrollTop;
                  start = 0, top = 0;
                  maxIndex = items.length - 1;
                  topSpace = hp.notLessThan(scrollTop - buffer, 0);

                case 16:
                  if (!(top < topSpace && start <= maxIndex)) {
                    _context2.next = 24;
                    break;
                  }

                  newTop = top + (itemsHeight[start] || avgHeight);

                  if (!(newTop > topSpace)) {
                    _context2.next = 20;
                    break;
                  }

                  return _context2.abrupt("break", 24);

                case 20:
                  top = newTop;
                  start++;
                  _context2.next = 16;
                  break;

                case 24:
                  top2 = top;
                  end = start;

                  if (_this3.afterCalcTop2) {
                    top2 = _this3.afterCalcTop2(top2);
                  }

                  while (top2 < scrollTop + clientHeight + buffer && end <= maxIndex) {
                    top2 += itemsHeight[end] || avgHeight;
                    end++;
                  }

                  bottom = 0;

                  for (index = end + 1; index < items.length; index++) {
                    bottom += itemsHeight[index] || avgHeight;
                  }

                  totalHeight = top2 + bottom;
                  _this3.start = start;
                  _this3.end = end;
                  _this3.top = top;
                  _this3.bottom = bottom;

                  if (_this3.totalHeight == null || scrollTop + clientHeight > _this3.totalHeight - buffer || Math.abs(_this3.totalHeight - totalHeight) > 100) {
                    if (_this3.totalHeight !== totalHeight) {
                      _this3.totalHeight = totalHeight;
                    }
                  }

                  waitDOMUpdated = function waitDOMUpdated() {
                    // eslint-disable-next-line no-async-promise-executor
                    return new Promise( /*#__PURE__*/function () {
                      var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(resolve, reject) {
                        return _regeneratorRuntime.wrap(function _callee$(_context) {
                          while (1) {
                            switch (_context.prev = _context.next) {
                              case 0:
                                _context.next = 2;
                                return nextTick();

                              case 2:
                                _context.next = 4;
                                return hp.waitFor(function () {
                                  var startEl, endEl, startIndex, endIndex;
                                  startEl = _this3.$el.querySelector(".".concat(_this3.itemClass, "[data-v-render-index=\"0\"]"));
                                  endEl = _this3.$el.querySelector(".".concat(_this3.itemClass, "[data-v-render-index=\"").concat(_this3.visibleItems.length - 1, "\"]"));

                                  if (startEl && endEl) {
                                    startIndex = parseInt(startEl.getAttribute("data-vindex"));
                                    endIndex = parseInt(endEl.getAttribute("data-vindex"));
                                    return startIndex == _this3.start && endIndex === _this3.end;
                                  }

                                  return false;
                                }, 5, 10).promise.then(function (x) {//
                                  // console.log("success to wait DOM updated");
                                }).catch(function (error) {//
                                  // console.warn("failed to wait DOM updated");
                                });

                              case 4:
                                resolve(undefined);

                              case 5:
                              case "end":
                                return _context.stop();
                            }
                          }
                        }, _callee);
                      }));

                      return function (_x, _x2) {
                        return _ref2.apply(this, arguments);
                      };
                    }());
                  };

                  _context2.next = 39;
                  return waitDOMUpdated();

                case 39:
                  // @ts-ignore
                  if (_this3._waitingUpdate) {
                    // @ts-ignore
                    next = _this3._waitingUpdate;

                    if (next !== task) {
                      next();
                    } else {
                      // @ts-ignore
                      _this3._waitingUpdate = undefined;
                    }
                  }

                case 40:
                case "end":
                  return _context2.stop();
              }
            }
          }, _callee2);
        }));

        return function task() {
          return _ref.apply(this, arguments);
        };
      }(); // @ts-ignore


      if (!this._waitingUpdate) {
        // @ts-ignore
        this._waitingUpdate = task;
        task();
      } else {
        // @ts-ignore
        this._waitingUpdate = task;
      }
    }
  },
  created: function created() {
    this.bottom = this.prerender - 1;
  },
  mounted: function mounted() {
    var _this4 = this;

    // @ts-ignore
    this._mountedPromise_resolve(null);

    var updatedOnce = false;
    this.$watch(function () {
      return [_this4.items];
    }, function () {
      _this4.itemsHeight = [];
      nextTick(function () {
        _this4.update();

        if (!updatedOnce) {
          _this4.update();
        }

        updatedOnce = true;
      });
    }, {
      immediate: true
    });
    this.$watch(function () {
      return [_this4.buffer];
    }, function () {
      _this4.update();
    });
  }
});

function render$1(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: "VirtualizationList virtualization-list",
    onScrollPassive: _cache[0] || (_cache[0] = function () {
      return _ctx.update && _ctx.update.apply(_ctx, arguments);
    })
  }, [(openBlock(), createBlock(resolveDynamicComponent(_ctx.listTag), {
    class: normalizeClass(["vl-items", _ctx.listClass]),
    style: normalizeStyle(_ctx.enabled && {
      paddingTop: _ctx.top + 'px',
      paddingBottom: _ctx.bottom + 'px',
      height: _ctx.totalHeight + 'px'
    })
  }, {
    default: withCtx(function () {
      return [(openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.visibleItems, function (info, i) {
        return renderSlot(_ctx.$slots, "default", {
          key: info.item.$id,
          item: info.item,
          index: info.index,
          renderIndex: i,
          itemStyle: {
            marginBottom: _ctx.gap + 'px'
          }
        });
      }), 128
      /* KEYED_FRAGMENT */
      ))];
    }),
    _: 3
    /* FORWARDED */

  }, 8
  /* PROPS */
  , ["class", "style"]))], 32
  /* HYDRATE_EVENTS */
  );
}

script$2.render = render$1;
script$2.__file = "src/components/VirtualizationList.vue";

function _createForOfIteratorHelper$1(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$1(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$1(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$1(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$1(o, minLen); }

function _arrayLikeToArray$1(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }
var trees = {};
var script$1 = defineComponent({
  components: {
    VirtualizationList: script$2
  },
  props: {
    idKey: {
      type: String,
      default: "id"
    },
    parentIdKey: {
      type: String,
      default: "parent_id"
    },
    childrenKey: {
      type: String,
      default: "children"
    },
    textKey: {
      type: String,
      default: "text"
    },
    flatData: {
      type: Array
    },
    treeData: {
      type: Array
    },
    indent: {
      type: Number,
      default: 20
    },
    gap: {
      type: Number
    },
    rtl: {
      type: Boolean,
      default: false
    },
    virtualization: {
      type: Boolean,
      default: false
    },
    virtualizationPrerender: {
      type: Number,
      default: 20
    },
    childrenLazyLoading: {
      type: Boolean,
      default: false
    },
    childrenLoader: {
      type: Function
    },
    defaultFolded: {
      type: Boolean,
      default: false
    }
  },
  data: function data() {
    var _this = this;

    return {
      nodes: [],
      nodesByID: {},
      trees: trees,
      dragging: false,
      treeID: hp.randString(),
      tree: this,
      virtualizationListAfterCalcTop2: undefined,
      // for drag
      store: null,
      draggingNode: null,
      // is node force visible in virtual list
      isNodeForceVisibleInVL: function isNodeForceVisibleInVL(node, index) {
        // @ts-ignore
        return _this.draggingNode === node;
      }
    };
  },
  computed: {
    rootNodeChildren: function rootNodeChildren() {
      var _this2 = this;

      return this.nodes.filter(function (node) {
        return !node.$pid || !_this2.nodesByID[node.$pid];
      });
    },
    rootNode: function rootNode() {
      return {
        $level: 0,
        $children: this.rootNodeChildren
      };
    },
    visibleNodes: function visibleNodes() {
      var _this3 = this;

      return this.nodes.filter(function (node, index) {
        return _this3.isNodeVisible(node);
      });
    }
  },
  watch: {
    flatData: {
      immediate: true,
      handler: function handler(val) {
        if (val) {
          var t = convertFlatDataToStandard(val, this.idKey, this.parentIdKey);
          this.initNodes(t.nodes);
          this.nodes = t.nodes;
          this.nodesByID = t.nodesByID;
        } else {
          if (!this.treeData) {
            this.nodes = [];
            this.nodesByID = {};
          }
        }
      }
    },
    treeData: {
      immediate: true,
      handler: function handler(val) {
        if (val) {
          var t = convertTreeDataToFlat(val, this.childrenKey, this.idKey);
          this.initNodes(t.nodes);
          this.nodes = t.nodes;
          this.nodesByID = t.nodesByID;
        } else {
          if (!this.flatData) {
            this.nodes = [];
            this.nodesByID = {};
          }
        }
      }
    }
  },
  methods: {
    initNodes: function initNodes(nodes) {
      var nodeInitializators = [];

      for (var _i = 0, _Object$keys = Object.keys(this.$data); _i < _Object$keys.length; _i++) {
        var key = _Object$keys[_i];

        if (key.startsWith("nodeInitializator_")) {
          nodeInitializators.push(this.$data[key]);
        }
      }

      var idKey = this.idKey,
          parentIdKey = this.parentIdKey;

      var _iterator = _createForOfIteratorHelper$1(nodes),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var node = _step.value;

          if (node.$id == null) {
            node.$id = node[idKey];
          }

          if (node.$pid == null) {
            node.$pid = node[parentIdKey];
          }

          initNode(node);

          if (this.nodesByID) {
            this.nodesByID[node.$id] = node;
          }

          if (node.$folded == null) {
            node.$folded = this.defaultFolded;
          }

          if (node.$checked == null) {
            node.$checked = false;
          }

          var _iterator2 = _createForOfIteratorHelper$1(nodeInitializators),
              _step2;

          try {
            for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
              var func = _step2.value;
              func(node);
            }
          } catch (err) {
            _iterator2.e(err);
          } finally {
            _iterator2.f();
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    },
    getTreeVmByTreeEl: function getTreeVmByTreeEl(treeEl) {
      return this.trees[treeEl.getAttribute("id")];
    },
    nodeIndentStyle: function nodeIndentStyle(node) {
      return _defineProperty({}, !this.rtl ? "paddingLeft" : "paddingRight", this.indent * (node.$level - 1) + "px");
    },
    getNodeByEl: function getNodeByEl(el) {
      var el2 = hp.findParent(el, function (el) {
        return hp.hasClass(el, "tree-node-outer");
      }, {
        withSelf: true
      });
      var id = el2.getAttribute("data-id");
      return this.nodesByID[id];
    },
    getElByID: function getElByID(id) {
      return this.$el.querySelector("[data-id=\"".concat(id, "\"]"));
    },
    getParent: function getParent(node) {
      if (!node) {
        return undefined;
      }

      return node.$pid ? this.nodesByID[node.$pid] : undefined;
    },
    getChildren: function getChildren(node) {
      if (!node) {
        return this.rootNode.$children;
      }

      return node.$children;
    },
    countChildren: function countChildren(node) {
      var r = 0;
      var t = node || this.rootNode;
      hp.walkTreeData(t.$children, function (node) {
        r++;
      }, "$children");
      return r;
    },
    _checkIDExists: function _checkIDExists(id) {
      if (!this.nodesByID[id]) {
        throw new Error("Node not found by specified id ".concat(id));
      }
    },
    _pidIndexToListIndex: function _pidIndexToListIndex(pid, index) {
      pid != null && this._checkIDExists(pid);
      var parent = this.nodesByID[pid];
      var listIndex = 0;

      if (parent) {
        listIndex = this.nodes.indexOf(parent) + 1;
      }

      var parentChildren = this.getChildren(parent);

      for (var i = 0; i < index; i++) {
        listIndex += 1 + this.countChildren(parentChildren[i]);
      }

      return listIndex;
    },
    addNode: function addNode(node, parentId) {
      var _this4 = this,
          _this$nodes;

      var index = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      parentId != null && this._checkIDExists(parentId);
      var nodes = [];
      var parent = this.nodesByID[parentId];
      hp.walkTreeData(node, function (child, index, childParent) {
        _this4.initNodes([child]);

        var parent2 = childParent || parent;
        child.$level = parent2 ? parent2.$level + 1 : 1;
        child.$pid = parent2 ? parent2.$id : null;
        child.$children = child[_this4.childrenKey] || [];
        nodes.push(child);
      }, this.childrenKey);

      if (parent) {
        parent.$children.splice(index, 0, node);
      }

      var listIndex = this._pidIndexToListIndex(parentId, index);

      (_this$nodes = this.nodes).splice.apply(_this$nodes, [listIndex, 0].concat(nodes));
    },
    moveNode: function moveNode(node, parentId) {
      var _this$nodes2;

      var index = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      parentId != null && this._checkIDExists(parentId);
      var flatNodes = [];
      var oldParent = this.getParent(node);

      if (oldParent) {
        var oldIndex = oldParent.$children.indexOf(node);
        oldParent.$children.splice(oldIndex, 1);
      }

      var oldListIndex = this.nodes.indexOf(node);
      var removeLen = this.countChildren(node) + 1;
      this.nodes.splice(oldListIndex, removeLen);
      var newParent = this.nodesByID[parentId];
      hp.walkTreeData(node, function (child, index, childParent) {
        var parent2 = childParent || newParent;
        child.$level = parent2 ? parent2.$level + 1 : 1;
        flatNodes.push(child);
      }, "$children");
      node.$pid = parentId == null ? undefined : parentId;

      if (newParent) {
        newParent.$children.splice(index, 0, node);
      }

      var listIndex = this._pidIndexToListIndex(parentId, index);

      (_this$nodes2 = this.nodes).splice.apply(_this$nodes2, [listIndex, 0].concat(flatNodes));
    },
    removeNode: function removeNode(node) {
      var parent = this.getParent(node);

      if (parent) {
        var index = parent.$children.indexOf(node);
        parent.$children.splice(index, 1);
      }

      var listIndex = this.nodes.indexOf(node);
      var removeLen = this.countChildren(node) + 1;
      this.nodes.splice(listIndex, removeLen);
    },
    outputNestedData: function outputNestedData(parent) {
      var ignoreKeys = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

      var _returnFlat = arguments.length > 2 ? arguments[2] : undefined;

      var td = new hp.TreeData(parent || this.rootNode.$children);
      td.childrenKey = "$children";
      var data = td.clone();
      var nodes = [];
      hp.walkTreeData(data, function (child) {
        nodes.push(child);
      }, "$children");
      var idKey = this.idKey,
          childrenKey = this.childrenKey,
          parentIdKey = this.parentIdKey;
      var ignore = {};

      var _iterator3 = _createForOfIteratorHelper$1(ignoreKeys),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var _key = _step3.value;
          ignore[_key] = true;
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      for (var _i2 = 0, _nodes = nodes; _i2 < _nodes.length; _i2++) {
        var node = _nodes[_i2];

        if (idKey !== "$id") {
          node[idKey] = node.$id;
          delete node.$id;
        }

        if (parentIdKey !== "$pid") {
          node[parentIdKey] = node.$pid;
          delete node.$pid;
        }

        if (childrenKey !== "$children") {
          node[childrenKey] = node.$children;
          delete node.$children;
        }

        for (var _i3 = 0, _Object$keys2 = Object.keys(node); _i3 < _Object$keys2.length; _i3++) {
          var key = _Object$keys2[_i3];

          if (key[0] === "$" && !ignore[key]) {
            delete node[key];
          }
        }
      }

      if (_returnFlat) {
        return nodes;
      } else {
        return hp.isArray(data) ? data : [data];
      }
    },
    outputFlatData: function outputFlatData(parent) {
      var ignoreKeys = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      return this.outputNestedData(parent, ignoreKeys, true);
    },
    isNodeParentFolded: function isNodeParentFolded(node) {
      var parent = this.getParent(node);
      return Boolean(parent && (parent.$folded || this.isNodeParentFolded(parent)));
    },
    isNodeVisible: function isNodeVisible(node) {
      return !node.$hidden && !this.isNodeParentFolded(node);
    },
    foldAll: function foldAll() {
      var _iterator4 = _createForOfIteratorHelper$1(this.nodes),
          _step4;

      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var node = _step4.value;
          node.$folded = true;
          this.$emit("fold", node);
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }
    },
    loadChildren: function loadChildren(node) {
      var _this5 = this;

      if (!node.$childrenLoadStaus || node.$childrenLoadStaus.status === "error") {
        node.$childrenLoading = true;
        var promise = Promise.resolve(this.childrenLoader(node, this)).then(function (children) {
          var _this5$nodes;

          var _iterator5 = _createForOfIteratorHelper$1(children),
              _step5;

          try {
            for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
              var child = _step5.value;
              child.$pid = node.$id;
              child.$level = node.$level + 1;
              child.$folded = true;
            }
          } catch (err) {
            _iterator5.e(err);
          } finally {
            _iterator5.f();
          }

          _this5.initNodes(children);

          node.$children = children;

          (_this5$nodes = _this5.nodes).splice.apply(_this5$nodes, [_this5.nodes.indexOf(node) + 1, 0].concat(_toConsumableArray(children)));

          node.$childrenLoadStaus = {
            status: "success"
          };
          node.$childrenLoading = false;

          _this5.$emit("load-children-success", node);
        }, function (error) {
          node.$children = [];
          node.$childrenLoadStaus = {
            status: "error",
            error: error
          };
          node.$childrenLoading = false;

          _this5.$emit("load-children-error", node);

          console.warn("Failed to load children of node", node, error);
          throw error;
        });
        node.$childrenLoadStaus = {
          status: "loading",
          promise: promise
        };
        this.$emit("load-children", node);
        return promise;
      } else if (node.$childrenLoadStaus.status === "loading") {
        return node.$childrenLoadStaus.promise;
      } else {
        return Promise.resolve();
      }
    },
    loadAllChildren: function loadAllChildren(node) {
      var _this6 = this;

      return new Promise( /*#__PURE__*/function () {
        var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(resolve, reject) {
          var promises, nodes, failed, _iterator6, _step6, _node, newnNodes, _iterator7, _step7, _node2;

          return _regeneratorRuntime.wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  promises = [];
                  nodes = node ? [node] : _this6.nodes;
                  failed = false;

                case 3:
                  _iterator6 = _createForOfIteratorHelper$1(nodes);

                  try {
                    for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
                      _node = _step6.value;
                      promises.push(_this6.loadChildren(_node).then(function () {}, function () {}));
                    }
                  } catch (err) {
                    _iterator6.e(err);
                  } finally {
                    _iterator6.f();
                  }

                  _context.next = 7;
                  return Promise.all(promises).then(function () {}, function () {
                    failed = true;
                  });

                case 7:
                  newnNodes = [];
                  _iterator7 = _createForOfIteratorHelper$1(nodes);

                  try {
                    for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
                      _node2 = _step7.value;

                      if (!_node2.$children) {
                        console.log(_node2);
                      }

                      newnNodes.push.apply(newnNodes, _toConsumableArray(_node2.$children));
                    }
                  } catch (err) {
                    _iterator7.e(err);
                  } finally {
                    _iterator7.f();
                  }

                  nodes = newnNodes;
                  promises = [];

                case 12:
                  if (nodes.length > 0) {
                    _context.next = 3;
                    break;
                  }

                case 13:
                  if (failed) {
                    reject(new Error("Failed to load all children"));
                  } else {
                    resolve(undefined);
                  }

                case 14:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee);
        }));

        return function (_x, _x2) {
          return _ref2.apply(this, arguments);
        };
      }());
    },
    unfoldAll: function unfoldAll(node) {
      var _this7 = this;

      var doAction = function doAction() {
        hp.walkTreeData(node || _this7.nodes, function (node) {
          node.$folded = false;

          _this7.$emit("unfold", node);
        }, "$children");
      };

      if (this.childrenLazyLoading) {
        return this.loadAllChildren(node).then(function () {
          doAction();
        }, function (error) {
          doAction();
          throw error;
        });
      } else {
        doAction();
      }
    },
    unfold: function unfold(node) {
      var _this8 = this;

      if (this.childrenLazyLoading) {
        return this.loadChildren(node).then(function () {
          node.$folded = false;

          _this8.$emit("unfold", node);
        });
      } else {
        node.$folded = false;
        this.$emit("unfold", node);
      }
    },
    toggleFold: function toggleFold(node) {
      if (node.$folded) {
        return this.unfold(node);
      } else {
        node.$folded = true;
        this.$emit("fold", node);
      }
    },
    updateChecked: function updateChecked(node) {
      var _this9 = this;

      var checkParent = function checkParent(node) {
        var parent = _this9.getParent(node);

        if (parent) {
          var hasChecked;
          var hasUnchecked;

          var _iterator8 = _createForOfIteratorHelper$1(parent.$children),
              _step8;

          try {
            for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
              var child = _step8.value;

              if (child.$checked) {
                hasChecked = true;
              } else {
                hasUnchecked = true;

                if (hasChecked) {
                  break;
                }
              }
            }
          } catch (err) {
            _iterator8.e(err);
          } finally {
            _iterator8.f();
          }

          parent.$checked = !hasUnchecked ? true : hasChecked ? 0 : false;
          checkParent(parent);
        }
      };

      checkParent(node);
      hp.walkTreeData(node, function (childNode) {
        if (childNode.$checked !== node.$checked) {
          childNode.$checked = node.$checked;
        }
      }, "$children");
    },
    getAllCheckedNodes: function getAllCheckedNodes() {
      return this.nodes.filter(function (node) {
        return node.$checked;
      });
    }
  },
  mounted: function mounted() {
    this.treeID = "hetree_" + hp.randString();
    this.trees[this.treeID] = this;
  },
  beforeUnmount: function beforeUnmount() {
    delete trees[this.treeID];
  }
});

var _hoisted_1 = ["data-vindex", "data-v-render-index", "data-id"];
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _component_VirtualizationList = resolveComponent("VirtualizationList");

  return openBlock(), createBlock(_component_VirtualizationList, {
    class: normalizeClass(["he-tree", {
      'he-tree-rtl': _ctx.rtl,
      'he-tree-dragging': _ctx.dragging
    }]),
    id: _ctx.treeID,
    ref: "virtualizationList",
    items: _ctx.visibleNodes,
    enabled: _ctx.virtualization,
    prerender: _ctx.virtualizationPrerender,
    gap: _ctx.gap,
    afterCalcTop2: _ctx.virtualizationListAfterCalcTop2,
    isForceVisible: _ctx.isNodeForceVisibleInVL
  }, {
    default: withCtx(function (info) {
      return [createElementVNode("div", {
        class: normalizeClass(["tree-node-outer vl-item", info.item.$outerClass]),
        "data-vindex": info.index,
        "data-v-render-index": info.renderIndex,
        "data-id": info.item.$id,
        style: normalizeStyle([info.itemStyle, _ctx.nodeIndentStyle(info.item), info.item.$outerStyle, {
          display: info.item === _ctx.draggingNode && (!_ctx.store || !_ctx.store.isCloned) ? 'none' : ''
        }])
      }, [createElementVNode("div", {
        class: normalizeClass(["tree-node", info.item.$nodeClass]),
        style: normalizeStyle(info.item.$nodeStyle)
      }, [renderSlot(_ctx.$slots, "default", {
        node: info.item,
        tree: _ctx.tree
      }, function () {
        return [createTextVNode(toDisplayString(info.item[_ctx.textKey]), 1
        /* TEXT */
        )];
      })], 6
      /* CLASS, STYLE */
      )], 14
      /* CLASS, STYLE, PROPS */
      , _hoisted_1)];
    }),
    _: 3
    /* FORWARDED */

  }, 8
  /* PROPS */
  , ["id", "items", "enabled", "prerender", "gap", "afterCalcTop2", "isForceVisible", "class"]);
}

script$1.render = render;
script$1.__file = "src/BaseTree.vue";

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }
function makeTreeListDraggable(treeEl, options, hooks) {
  var defaultOptions = {
    updateMovedElementStyleManually: true,
    getMovedOrClonedElement: function getMovedOrClonedElement(directTriggerElement, store) {
      // find closest node from parents
      var el = hp.findParent(store.triggerElement, function (el) {
        return hp.hasClass(el, options.nodeOuterClass);
      }, {
        withSelf: true
      });
      return el;
    },
    // @ts-ignore
    beforeFirstMove: function beforeFirstMove(store, options) {
      store.startTreeEl = treeEl;

      if (hooks.beforeFirstMove && hooks.beforeFirstMove(store, options) === false) {
        return false;
      }
    },
    // it means onMove
    // @ts-ignore
    beforeMove: function beforeMove(store) {
      var _hooks$afterTargetTre2, _prevNodeAndIndex;

      // first move
      // 第一次移动
      if (store.movedCount === 0) {
        var _hooks$afterTargetTre, _hooks$afterFirstMove;

        // create placeholder
        // 创建占位元素
        var placeholder = hooks.createPlaceholder();
        store.placeholder = placeholder;
        store.targetTreeEl = store.startTreeEl;
        (_hooks$afterTargetTre = hooks.afterTargetTreeElUpdated) === null || _hooks$afterTargetTre === void 0 ? void 0 : _hooks$afterTargetTre.call(hooks, store);
        hooks.insertedPlaceholderAfterCreated(store);
        hooks.setPlaceholderLevel(store.placeholder, hooks.getNodeLevelByEl(store.movedOrClonedElement));
        store.updateMovedElementStyle();
        (_hooks$afterFirstMove = hooks.afterFirstMove) === null || _hooks$afterFirstMove === void 0 ? void 0 : _hooks$afterFirstMove.call(hooks, store, options); // skip first move
        // 跳过第一次移动

        hooks.moveEnd("first_move");
        return;
      } //


      store.updateMovedElementStyle(); //

      var movingEl = store.movedElement; // node
      // find closest node and hovering tree

      var tree;
      var movingNode = movingEl; // movingNodeOf and movingNodeRect are not always real. when RTL, there 'x' is top right. when draggingNodePositionMode is mouse, there x and y are mouse position. So don't calc them with their width or height.
      // movingNodeOf 和 movingNodeRect并非一直如字面意义是movingNode真实坐标. RTL时, x坐标是右上角. draggingNodePositionMode是mouse时, x和y是鼠标坐标.

      var movingNodeRealEl = movingNode.querySelector(".".concat(options.nodeClass)); // movingNode is node outer

      var movingNodeOf = hp.getOffset(movingNodeRealEl);
      var movingNodeRect = hp.getBoundingClientRect(movingNodeRealEl);

      if (options.draggingNodePositionMode === "mouse") {
        // use mouse position as dragging node position
        var moveEvent = store.moveEvent; // @ts-ignore

        movingNodeOf = {
          x: moveEvent.pageX,
          y: moveEvent.pageY
        }; // @ts-ignore

        movingNodeRect = {
          x: moveEvent.clientX,
          y: moveEvent.clientY
        };
      } else if (options.rtl) {
        movingNodeOf.x += movingNode.offsetWidth;
        movingNodeRect.x += movingNode.offsetWidth;
      } // find tree with elementsFromPoint


      var found;
      var firstElement;

      var _iterator = _createForOfIteratorHelper(hp.elementsFromPoint(movingNodeRect.x, movingNodeRect.y)),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var itemEl = _step.value;

          if (!firstElement) {
            firstElement = itemEl;
          }

          if (hp.hasClass(itemEl, options.treeClass)) {
            found = itemEl;
            break;
          }
        } // check if the found element is covered by other elements

      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      if (firstElement !== found && !hp.isDescendantOf(firstElement, found)) {
        found = null;
      }

      tree = found;

      if (!tree) {
        // out of tree or tree is covered by other elements
        hooks.moveEnd("no_target_tree");
        return;
      } // check if target tree right


      if (hooks.filterTargetTreeEl && hooks.filterTargetTreeEl(tree, store) === false) {
        hooks.moveEnd("disallowed_tree");
        return;
      }

      store.targetTreeEl = tree;
      (_hooks$afterTargetTre2 = hooks.afterTargetTreeElUpdated) === null || _hooks$afterTargetTre2 === void 0 ? void 0 : _hooks$afterTargetTre2.call(hooks, store);
      var indent = hooks.getTreeIndent(store.targetTreeEl, store); //

      var DecisionInfo = /*#__PURE__*/function () {
        function DecisionInfo() {
          _classCallCheck(this, DecisionInfo);

          _defineProperty(this, "_visibleNodesElements", void 0);

          _defineProperty(this, "_closestNodeElAndIndex", void 0);

          _defineProperty(this, "_prevNodeAndIndex", void 0);

          _defineProperty(this, "_prevNodeOffset", void 0);

          _defineProperty(this, "_prevNodeLevel", void 0);

          _defineProperty(this, "_nextNodeAndIndex", void 0);
        }

        _createClass(DecisionInfo, [{
          key: "visibleNodesElementsExcludeDragging",
          get: function get() {
            if (!this._visibleNodesElements) {
              this._visibleNodesElements = store.targetTreeEl.querySelectorAll(".".concat(options.nodeClass, ":not(.").concat(options.draggingClassName, " > .").concat(options.nodeClass, ")"));
            }

            var r = [];

            this._visibleNodesElements.forEach(function (node) {
              // @ts-ignore
              if (node.parentElement.style.display !== "none") {
                // node-outer visible
                r.push(node);
              }
            });

            return r;
          } // index is for visibleNodesElementsExcludeDragging

        }, {
          key: "closestNodeElAndIndex",
          get: function get() {
            if (this._closestNodeElAndIndex === undefined) {
              var nodes = this.visibleNodesElementsExcludeDragging; //

              if (nodes.length === 0) {
                this._closestNodeElAndIndex = null;
              } else {
                var _found, index;

                var t = hp.binarySearch(nodes, function (node) {
                  return hp.getOffset(node).y - movingNodeOf.y;
                }, {
                  returnNearestIfNoHit: true
                });

                if (t.hit) {
                  _found = t.value;
                  index = t.index;
                } else {
                  if (t.greater) {
                    index = t.index - 1;
                    _found = nodes[index] || t.value;
                  } else {
                    index = t.index;
                    _found = t.value;
                  }
                }

                this._closestNodeElAndIndex = {
                  el: _found,
                  index: index
                };
              }
            }

            return this._closestNodeElAndIndex;
          } // prev node is closest node when closest node is not placeholder, or is prev node of closest node when it is placeholder
          // closest node不是placeholder时, prev node是closest node, 否则是closest node上方的node

        }, {
          key: "prevNodeAndIndex",
          get: function get() {
            if (this._prevNodeAndIndex === undefined) {
              var el, index;

              if (this.closestNodeElAndIndex) {
                index = this.closestNodeElAndIndex.index; // can't reduce 1; 不能减1

                el = this.visibleNodesElementsExcludeDragging[index];

                if (el && hp.hasClass(el, options.placeholderClass)) {
                  index--;
                  el = this.visibleNodesElementsExcludeDragging[index];
                }

                if (el) {
                  this._prevNodeAndIndex = {
                    el: el,
                    index: index
                  };
                } else {
                  this._prevNodeAndIndex = null;
                }
              } else {
                this._prevNodeAndIndex = null;
              }
            }

            return this._prevNodeAndIndex;
          }
        }, {
          key: "prevtNodeOffset",
          get: function get() {
            if (this._prevNodeOffset === undefined) {
              this._prevNodeOffset = this.prevNodeAndIndex ? hp.getOffset(this.prevNodeAndIndex.el) : null;
            }

            return this._prevNodeOffset;
          }
        }, {
          key: "prevNodeLevel",
          get: function get() {
            if (this._prevNodeLevel === undefined) {
              this._prevNodeLevel = this.prevNodeAndIndex ? hooks.getNodeLevelByEl(this.prevNodeAndIndex.el) : null;
            }

            return this._prevNodeLevel;
          }
        }, {
          key: "nextNodeAndIndex",
          get: function get() {
            if (this._nextNodeAndIndex === undefined) {
              var el, index;

              if (this.closestNodeElAndIndex) {
                index = this.closestNodeElAndIndex.index + 1;
                el = this.visibleNodesElementsExcludeDragging[index];

                if (el && hp.hasClass(el, options.placeholderClass)) {
                  index++;
                  el = this.visibleNodesElementsExcludeDragging[index];
                }

                if (el) {
                  this._nextNodeAndIndex = {
                    el: el,
                    index: index
                  };
                } else {
                  this._nextNodeAndIndex = null;
                }
              } else {
                this._nextNodeAndIndex = null;
              }
            }

            return this._nextNodeAndIndex;
          }
        }]);

        return DecisionInfo;
      }();

      var info = new DecisionInfo();

      var onMiddleOfPrevNode = function onMiddleOfPrevNode() {
        return movingNodeOf.y < info.prevtNodeOffset.y + info.prevNodeAndIndex.el.offsetHeight / 2;
      }; // Positive number mean moving node at left of prev node


      var prevNodeLeftXReduceMovingNodeX = function prevNodeLeftXReduceMovingNodeX() {
        return !options.rtl ? info.prevtNodeOffset.x - movingNodeOf.x : movingNodeOf.x - (info.prevtNodeOffset.x + info.prevNodeAndIndex.el.offsetWidth);
      };

      var atRightOfPrevNodeIndent = function atRightOfPrevNodeIndent() {
        return !options.rtl ? movingNodeOf.x > info.prevtNodeOffset.x + indent : movingNodeOf.x < info.prevtNodeOffset.x + info.prevNodeAndIndex.el.offsetWidth - indent;
      }; //


      var targetLevel;
      var nextNodeLevel = info.nextNodeAndIndex ? hooks.getNodeLevelByEl(info.nextNodeAndIndex.el) : 1; // targetLevel max is nextNodeLevel

      var prevNodeAndIndex = info.prevNodeAndIndex;

      if (!prevNodeAndIndex || prevNodeAndIndex.index === 0 && onMiddleOfPrevNode()) {
        targetLevel = 1;
        prevNodeAndIndex = null;
        nextNodeLevel = 1;
      } else {
        var atLeft = prevNodeLeftXReduceMovingNodeX();

        if (atLeft > 0) {
          targetLevel = info.prevNodeLevel - Math.ceil(atLeft / indent);
        } else if (atRightOfPrevNodeIndent()) {
          targetLevel = info.prevNodeLevel + 1;
        } else {
          targetLevel = info.prevNodeLevel;
        }
      }

      if (targetLevel < nextNodeLevel) {
        targetLevel = nextNodeLevel;
      }

      hooks.movePlaceholder(store, (_prevNodeAndIndex = prevNodeAndIndex) === null || _prevNodeAndIndex === void 0 ? void 0 : _prevNodeAndIndex.el, targetLevel);
    },
    // @ts-ignore
    beforeDrop: function beforeDrop(store) {
      store.endEvent;
      store.movedElement;
      var placeholder = store.placeholder;
          store.movedCount;
          store.targetTreeEl;
          store.startTreeEl; // destroy placeholder

      var restoreStyle = function restoreStyle() {
        hp.removeEl(placeholder);
        store.updateMovedElementStyle();
      }; //


      return hooks.onDrop(store, restoreStyle);
    }
  };
  Object.keys(defaultOptions).forEach(function (key) {
    // @ts-ignore
    if (options[key] === undefined) {
      // @ts-ignore
      options[key] = defaultOptions[key];
    }
  });

  var _draggableHelper = draggableHelper(treeEl, options),
      destroy = _draggableHelper.destroy,
      draggableHelperOptions = _draggableHelper.options;

  return {
    destroy: destroy,
    options: draggableHelperOptions,
    hooks: hooks
  };
}

var placeholderID = "hetree_drag_placeholder";
var script = defineComponent({
  extends: script$1,
  props: {
    triggerClass: {
      type: String,
      default: "tree-node"
    },
    triggerBySelf: Boolean,
    draggable: {
      type: Boolean,
      default: true
    },
    droppable: {
      type: Boolean,
      default: true
    },
    eachDraggable: {
      type: [Boolean, Function],
      default: undefined
    },
    eachDroppable: {
      type: [Boolean, Function],
      default: undefined
    },
    rootDraggable: {
      type: Boolean,
      default: true
    },
    rootDroppable: {
      type: Boolean,
      default: true
    },
    ondragstart: {
      type: Function
    },
    ondragend: {
      type: Function
    },
    afterPlaceholderCreated: {
      type: Function
    },
    placeholderMaxHeight: {
      type: Number,
      default: 100
    },
    unfoldWhenDragover: {
      type: Boolean,
      default: true
    },
    unfoldWhenDragoverDelay: {
      type: Number,
      default: 80
    },
    isNodeUnfoldable: {
      type: Function
    },
    draggingNodePositionMode: {
      type: String,
      default: "top_left_corner"
    },
    preventTextSelection: {
      type: Boolean,
      default: true
    },
    edgeScroll: {
      type: Boolean
    },
    edgeScrollTriggerMargin: {
      type: Number,
      default: 50
    },
    edgeScrollSpeed: {
      type: Number,
      default: 0.35
    },
    edgeScrollTriggerMode: {
      type: String,
      default: "top_left_corner"
    },
    edgeScrollSpecifiedContainerX: {
      type: [Object, Function]
    },
    edgeScrollSpecifiedContainerY: {
      type: [Object, Function]
    } // type: HTMLElement | ((store: Store3) => HTMLElement)

  },
  data: function data() {
    var _this = this;

    return {
      draggingNode: null,
      store: null,
      virtualizationListAfterCalcTop2: function virtualizationListAfterCalcTop2(top2) {
        if (_this.dragging) {
          var placeholder = _this.$el.querySelector("#".concat(placeholderID));

          if (placeholder) {
            top2 += hp.getBoundingClientRect(placeholder).height + (_this.gap || 0);
          }
        }

        return top2;
      }
    };
  },
  methods: {
    isParentDragging: function isParentDragging(node) {
      var nodesByID = this.nodesByID,
          draggingNode = this.draggingNode;
      var parent = node.$pid && nodesByID[node.$pid];
      return Boolean(draggingNode && parent && (parent === draggingNode || this.isParentDragging(parent)));
    },
    isNodeVisible: function isNodeVisible(node) {
      if (this.draggingNode === node) {
        // keep event trigger, because touch event need it before event end
        return true;
      }

      if (this.draggingNode && this.store.isCloned && (node === this.draggingNode || this.isParentDragging(node))) {
        return true;
      }

      return !node.$hidden && !this.isNodeParentFolded(node) && (!this.draggingNode || node !== this.draggingNode && !this.isParentDragging(node));
    }
  },
  // hooks
  mounted: function mounted() {
    var _this2 = this;

    var options = {
      treeClass: "he-tree",
      nodeClass: "tree-node",
      nodeOuterClass: "tree-node-outer",
      draggingClassName: "dragging",
      placeholderClass: "tree-placeholder",
      clone: true,
      onClone: function onClone(store, options) {
        store.isCloned = false; // @ts-ignore

        if (_this2.cloneWhenDrag) {
          // @ts-ignore
          store.isCloned = store.isCloned ? _this2.onClone(store) : true;
        }

        return true;
      }
    };

    var syncOption = function syncOption(name, nameInOption) {
      if (!nameInOption) {
        nameInOption = name;
      } // @ts-ignore


      options[nameInOption] = _this2[name];

      _this2.$watch(name, function () {
        // @ts-ignore
        options[nameInOption] = _this2[name];
      });
    };

    syncOption("triggerClass", "triggerClassName");
    syncOption("triggerBySelf");
    syncOption("unfoldWhenDragover");
    syncOption("unfoldWhenDragoverDelay");
    syncOption("draggingNodePositionMode");
    syncOption("edgeScroll");
    syncOption("edgeScrollTriggerMargin");
    syncOption("edgeScrollSpeed");
    syncOption("edgeScrollTriggerMode");
    syncOption("edgeScrollSpecifiedContainerX");
    syncOption("edgeScrollSpecifiedContainerY");
    syncOption("rtl");
    syncOption("preventTextSelection");

    var isNodeDroppable0 = function isNodeDroppable0(store, node) {
      var vm = store.targetTree || _this2;

      if (!vm.droppable) {
        return false;
      }

      var droppableOpt = node ? node.$droppable !== undefined ? node.$droppable : vm.eachDroppable : vm.rootDroppable !== undefined ? vm.rootDroppable : vm.eachDroppable;
      var droppable = hp.resolveValueOrGettter(droppableOpt, [node, store, options, vm]);

      if (droppable === undefined) {
        var parent = vm.getParent(node);

        if (!parent) {
          return true;
        } else {
          return isNodeDroppable0(store, parent);
        }
      } else {
        return droppable;
      }
    };

    var isNodeUnfoldable = function isNodeUnfoldable(store, node) {
      var vm = store.targetTree || _this2;

      if (!vm.isNodeUnfoldable) {
        return _this2.unfoldWhenDragover;
      } else {
        return vm.isNodeUnfoldable(store);
      }
    };

    var _makeTreeListDraggabl = makeTreeListDraggable(this.$el, // @ts-ignore
    options, {
      beforeFirstMove: function beforeFirstMove(store, options) {
        _this2.store = store;
        store.startTree = _this2.getTreeVmByTreeEl(store.startTreeEl);
        var draggable = hp.resolveValueOrGettter(store.startTree.draggable, [store.startTree, store]);

        if (!draggable) {
          return false;
        }

        var startTree = store.startTree;
        store.draggingNode = startTree.getNodeByEl(store.movedOrClonedElement);

        var parent = _this2.getParent(store.draggingNode);

        var index = _this2.getChildren(parent).indexOf(store.draggingNode);

        store.startPath = {
          tree: _this2,
          parent: parent,
          index: index
        };

        var isNodeDraggable = function isNodeDraggable(node) {
          if (!_this2.draggable) {
            return false;
          }

          var opt = node.$draggable !== undefined ? node.$draggable : _this2.eachDraggable;
          var draggable = hp.resolveValueOrGettter(opt, [node, store, options, _this2]);

          if (draggable === undefined) {
            var _parent = _this2.getParent(node);

            if (!_parent) {
              return true;
            } else {
              return isNodeDraggable(_parent);
            }
          } else {
            return draggable;
          }
        };

        if (!isNodeDraggable(store.draggingNode)) {
          return false;
        }

        if (store.startTree.rootDraggable === false && store.draggingNode.$level === 1) {
          return false;
        }

        if (_this2.ondragstart && _this2.ondragstart(store) === false) {
          return false;
        }

        for (var _i = 0, _Object$values = Object.values(_this2.trees); _i < _Object$values.length; _i++) {
          var tree = _Object$values[_i];
          tree.dragging = true;
          tree.store = store;
        }

        store.startTree.$emit("before-first-move", store);
        store.startTree.$emit("drag", store);
      },
      afterFirstMove: function afterFirstMove(store) {
        _this2.draggingNode = store.draggingNode;
      },
      getNodeLevelByEl: function getNodeLevelByEl(el) {
        return _this2.store.targetTree.getNodeByEl(el).$level;
      },
      createPlaceholder: function createPlaceholder() {
        return hp.createElementFromHTML("\n          <div id=\"".concat(placeholderID, "\" class=\"tree-placeholder-outer tree-node-outer\" style=\"margin-bottom: ").concat(_this2.gap, "px;\">\n            <div class=\"").concat(options.placeholderClass, " tree-node\">\n            </div>\n          </div>\n        "));
      },
      setPlaceholderLevel: function setPlaceholderLevel(placeholder, level) {
        placeholder.style[!_this2.store.targetTree.rtl ? "paddingLeft" : "paddingRight"] = (level - 1) * _this2.store.targetTree.indent + "px";
        _this2.store.placeholderLevel = level;
      },
      filterTargetTreeEl: function filterTargetTreeEl(el, store) {
        var targetTree = _this2.getTreeVmByTreeEl(el);

        var startTree = store.startTree;

        if (startTree !== targetTree) {
          // @ts-ignore
          if (_this2._internal_hook_filterTargetTree) {
            if ( // @ts-ignore
            _this2._internal_hook_filterTargetTree(targetTree, store) === false) {
              return false;
            }
          } else {
            return false;
          }
        }

        var targetTreeDroppable = hp.resolveValueOrGettter(targetTree.droppable, [targetTree, store]);

        if (!targetTreeDroppable) {
          return false;
        }

        store.targetTree = targetTree;

        if (!hp.resolveValueOrGettter(store.startTree === store.targetTree) && // @ts-ignore
        hp.resolveValueOrGettter(_this2._Draggable_unfoldTargetNode, [false, store]) !== _this2.store) {
          return false;
        }
      },
      afterTargetTreeElUpdated: function afterTargetTreeElUpdated(store) {
        store.targetTree = _this2.getTreeVmByTreeEl(store.targetTreeEl);
      },
      insertedPlaceholderAfterCreated: function insertedPlaceholderAfterCreated(store) {
        var _this2$afterPlacehold;

        // set placeholder height
        var dragNodesCount = 1 + _this2.countChildren(store.draggingNode);

        var nodeHeight = store.movedOrClonedElement.offsetHeight;
        var placeholderHeight = hp.notGreaterThan(dragNodesCount * nodeHeight, _this2.placeholderMaxHeight);
        store.placeholder.querySelector(".tree-node").style.height = placeholderHeight + "px"; //

        //
        (_this2$afterPlacehold = _this2.afterPlaceholderCreated) === null || _this2$afterPlacehold === void 0 ? void 0 : _this2$afterPlacehold.call(_this2, store.placeholder, store);

        if (isNodeDroppable0(store, _this2.getParent(store.draggingNode))) {
          hp.insertAfter(store.placeholder, store.movedOrClonedElement);
          store.placeholderPrevNode = _this2.getNodeByEl(store.movedOrClonedElement);
          var placeholderPrevEl = store.movedOrClonedElement.previousElementSibling;

          if (placeholderPrevEl) {
            if (hp.hasClass(placeholderPrevEl, options.nodeOuterClass)) {
              store.placeholderPrevNodeInTree = _this2.getNodeByEl(placeholderPrevEl);
            }
          }
        }
      },
      getTreeIndent: function getTreeIndent(treeEl, store) {
        var _this2$getTreeVmByTre;

        return (_this2$getTreeVmByTre = _this2.getTreeVmByTreeEl(treeEl)) === null || _this2$getTreeVmByTre === void 0 ? void 0 : _this2$getTreeVmByTre.indent;
      },
      moveEnd: function moveEnd(action) {
        var info = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

        //
        if (_this2.store.targetTreeEl.querySelector("#".concat(placeholderID))) {
          _this2.store.placeholder.style["margin-bottom"] = "".concat(_this2.store.targetTree.gap, "px");
        } //


        //
        if (_this2.unfoldWhenDragoverInfo) {
          if (action !== "prepend" || info.node !== _this2.unfoldWhenDragoverInfo.node) {
            _this2.unfoldWhenDragoverInfo = undefined;
          }
        }
      },
      movePlaceholder: function movePlaceholder(store, el, targetLevel) {
        var isNodeDroppable = function isNodeDroppable(node) {
          return isNodeDroppable0(store, node);
        };

        var setPlaceholderLevel = function setPlaceholderLevel(level) {
          return hooks.setPlaceholderLevel(store.placeholder, level);
        };

        var that = store.targetTree;
        var parent, prevNode, prevNodeInTree; // prev droppable node
        // find parent

        // prev droppable node
        // find parent
        if (el) {
          prevNode = that.getNodeByEl(el);
          prevNodeInTree = prevNode;

          if (targetLevel > prevNode.$level) {
            if (isNodeDroppable(prevNode) && (!prevNode.$folded || isNodeUnfoldable(store))) {
              // prepend or append
              parent = prevNode;
            } else {
              // after
              parent = that.getParent(prevNode);
              targetLevel--;
            }
          } else if (targetLevel === prevNode.$level) {
            parent = that.getParent(prevNode);

            if (!isNodeDroppable(parent) && isNodeDroppable(prevNode) && (!prevNode.$folded || isNodeUnfoldable(store))) {
              // fallback to prepend
              parent = prevNode;
              targetLevel++;
            }
          } else {
            // targetLevel < prevNode.$level
            // found parent which's level equal targetLevel - 1
            parent = prevNode;

            while (parent) {
              if (parent.$level === targetLevel - 1) {
                break;
              }

              prevNodeInTree = parent;
              parent = that.getParent(parent);
            }
          }
        }

        var getLastChildNode = function getLastChildNode(node) {
          var children = node.$children || [];
          var index = children.length - 1;
          var last = children[index];

          if (!store.isCloned && last === _this2.draggingNode) {
            index--;
            last = children[index];
          }

          return last;
        };

        while (parent && !isNodeDroppable(parent)) {
          targetLevel--;
          prevNodeInTree = parent;
          prevNode = getLastChildNode(parent) || parent;
          parent = that.getParent(parent);
        }

        var parentDroppable = parent ? true : isNodeDroppable(); // isNodeDroppable() get root droppable

        // isNodeDroppable() get root droppable
        var noAction = false;

        if (parentDroppable) {
          if (!prevNode) {
            // prepend to root
            var root = that.$el;
            hp.prependTo(store.placeholder, root);
            setPlaceholderLevel(targetLevel);
            hooks.moveEnd("prepend_to_root");
          } else {
            // prevNode not null, prevNodeInTree not null
            var doInsert = function doInsert() {
              hp.insertAfter(store.placeholder, that.getElByID(prevNode.$id));
              setPlaceholderLevel(targetLevel);
            };

            if (targetLevel === prevNodeInTree.$level + 1) {
              // prepend
              // need to unfold node if node is folded
              if (!prevNodeInTree.$folded) {
                doInsert();
                hooks.moveEnd("prepend", {
                  node: prevNodeInTree
                });
              } else {
                hooks.moveEnd("prepend", {
                  node: prevNodeInTree
                });
                var info = _this2.unfoldWhenDragoverInfo;

                if (info) ; else {
                  var id = hp.randString();
                  _this2.unfoldWhenDragoverInfo = {
                    node: prevNodeInTree,
                    id: id
                  };

                  var delayAndUnfoldAndDoInsert = /*#__PURE__*/function () {
                    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
                      var cancelled;
                      return _regeneratorRuntime.wrap(function _callee$(_context) {
                        while (1) {
                          switch (_context.prev = _context.next) {
                            case 0:
                              _context.next = 2;
                              return hp.waitTime(store.targetTree.unfoldWhenDragoverDelay);

                            case 2:
                              cancelled = function cancelled() {
                                var _this2$unfoldWhenDrag;

                                return ((_this2$unfoldWhenDrag = _this2.unfoldWhenDragoverInfo) === null || _this2$unfoldWhenDrag === void 0 ? void 0 : _this2$unfoldWhenDrag.id) !== id;
                              };

                              if (!cancelled()) {
                                _context.next = 5;
                                break;
                              }

                              return _context.abrupt("return");

                            case 5:
                              _context.prev = 5;
                              _context.next = 8;
                              return store.targetTree.unfold(prevNodeInTree);

                            case 8:
                              if (!cancelled()) {
                                _context.next = 10;
                                break;
                              }

                              return _context.abrupt("return");

                            case 10:
                              doInsert();
                              _context.next = 15;
                              break;

                            case 13:
                              _context.prev = 13;
                              _context.t0 = _context["catch"](5);

                            case 15:
                            case "end":
                              return _context.stop();
                          }
                        }
                      }, _callee, null, [[5, 13]]);
                    }));

                    return function delayAndUnfoldAndDoInsert() {
                      return _ref.apply(this, arguments);
                    };
                  }();

                  delayAndUnfoldAndDoInsert();
                }
              }
            } else {
              // after
              doInsert();
              hooks.moveEnd("after", {
                node: prevNodeInTree
              });
            }
          }
        } else {
          // can't drop
          hooks.moveEnd("no_action");
          noAction = true;
        }

        if (!noAction) {
          store.placeholderPrevNode = prevNode;
          store.placeholderPrevNodeInTree = prevNodeInTree;
        }
      },
      onDrop: function () {
        var _onDrop = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(store, restoreStyle) {
          var done, dragChanged, that, startTree, targetTree, prevNodeInTree, tree, parent, index, level, _startPath, _targetPath, startPath, targetPath, draggingNode, _that$nodes, _listIndex, toRemove, _i2, _toRemove, node, insertNode, td, listIndex, toAdd, levelChange, _i3, _toAdd, _node, _i4, _Object$values2, _tree;

          return _regeneratorRuntime.wrap(function _callee2$(_context2) {
            while (1) {
              switch (_context2.prev = _context2.next) {
                case 0:
                  done = function done() {
                    // execute when completed or cancelled
                    _this2.draggingNode = null;
                  };

                  dragChanged = true;
                  that = store.targetTree;
                  startTree = store.startTree, targetTree = store.targetTree;

                  if (!document.getElementById(placeholderID) || !store.targetTreeEl) {
                    // not moved
                    dragChanged = false;
                  } else {
                    prevNodeInTree = store.placeholderPrevNodeInTree;
                    tree = store.targetTree;
                    level = store.placeholderLevel;

                    if (!prevNodeInTree) {
                      index = 0; // index = tree.rootNode.$children.indexOf()
                    } else if (level > prevNodeInTree.$level) {
                      parent = prevNodeInTree;
                      index = 0;
                    } else {
                      // after prevNodeInTree
                      parent = that.getParent(prevNodeInTree);
                      index = that.getChildren(parent).indexOf(prevNodeInTree) + 1;
                    }

                    store.targetPath = {
                      tree: tree,
                      parent: parent,
                      index: index
                    }; // correct index

                    // correct index
                    _startPath = store.startPath, _targetPath = store.targetPath;

                    if (_startPath.tree === _targetPath.tree && _startPath.parent === _targetPath.parent) {
                      if (!_this2.store.isCloned) {
                        if (_startPath.index < _targetPath.index) {
                          _targetPath.index--;
                        }

                        if (_startPath.index === _targetPath.index) {
                          dragChanged = false;
                        }
                      }
                    }
                  }

                  restoreStyle();
                  startPath = store.startPath, targetPath = store.targetPath;
                  draggingNode = _this2.draggingNode;
                  store.dragChanged = dragChanged; // hook ondragend

                  _context2.t0 = that.ondragend;

                  if (!_context2.t0) {
                    _context2.next = 15;
                    break;
                  }

                  _context2.next = 13;
                  return that.ondragend(store);

                case 13:
                  _context2.t1 = _context2.sent;
                  _context2.t0 = _context2.t1 === false;

                case 15:
                  if (!_context2.t0) {
                    _context2.next = 18;
                    break;
                  }

                  done();
                  return _context2.abrupt("return", false);

                case 18:
                  if (dragChanged) {
                    // need move
                    if (!store.isCloned) {
                      // remove from start path
                      if (startPath.parent) {
                        _this2.getChildren(startPath.parent).splice(startPath.index, 1);
                      }

                      _listIndex = _this2.nodes.indexOf(draggingNode);
                      toRemove = [];
                      hp.walkTreeData(draggingNode, function (node) {
                        toRemove.push(node);
                      }, "$children");

                      _this2.nodes.splice(_listIndex, toRemove.length);

                      for (_i2 = 0, _toRemove = toRemove; _i2 < _toRemove.length; _i2++) {
                        node = _toRemove[_i2];
                        delete _this2.nodesByID[node.$id];
                      }
                    } // insert to new position


                    // insert to new position
                    insertNode = draggingNode; // insertNode may be cloned

                    // insertNode may be cloned
                    if (store.isCloned) {
                      td = new hp.TreeData(insertNode);
                      td.childrenKey = "$children"; // @ts-ignore

                      // @ts-ignore
                      insertNode = td.clone();
                      hp.walkTreeData(insertNode, function (node, index, parent) {
                        node.$id = genNodeID();
                        node.$pid = parent && parent.$id;
                      }, "$children");
                    }

                    that.getChildren(targetPath.parent).splice(targetPath.index, 0, insertNode);
                    insertNode.$pid = targetPath.parent ? targetPath.parent.$id : undefined; // resolve start index in all nodes
                    // 新位置, 在所有节点中的索引

                    // resolve start index in all nodes
                    // 新位置, 在所有节点中的索引
                    listIndex = that._pidIndexToListIndex(targetPath.parent ? targetPath.parent.$id : null, targetPath.index);
                    toAdd = [];
                    levelChange = (targetPath.parent || that.rootNode).$level - (startPath.parent || _this2.rootNode).$level;
                    hp.walkTreeData(insertNode, function (node) {
                      node.$level += levelChange;
                      toAdd.push(node);
                    }, "$children");

                    (_that$nodes = that.nodes).splice.apply(_that$nodes, [listIndex, 0].concat(toAdd));

                    for (_i3 = 0, _toAdd = toAdd; _i3 < _toAdd.length; _i3++) {
                      _node = _toAdd[_i3];
                      that.nodesByID[_node.$id] = _node;
                    }
                  }

                  for (_i4 = 0, _Object$values2 = Object.values(_this2.trees); _i4 < _Object$values2.length; _i4++) {
                    _tree = _Object$values2[_i4];
                    _tree.dragging = false;
                  } // emit event


                  // emit event
                  startTree.$emit("drop", store);
                  targetTree.$emit("drop-into", store);

                  if (store.dragChanged) {
                    startTree.$emit("drop-change", store);

                    if (targetTree !== startTree) {
                      targetTree.$emit("drop-change", store);
                    }
                  }

                  done();

                case 24:
                case "end":
                  return _context2.stop();
              }
            }
          }, _callee2);
        }));

        function onDrop(_x, _x2) {
          return _onDrop.apply(this, arguments);
        }

        return onDrop;
      }()
    }),
        hooks = _makeTreeListDraggabl.hooks;
  }
});

script.__file = "src/draggable/Draggable.vue";

export { script$1 as BaseTree, script as Draggable, script$2 as VirtualizationList };
