/*!
 * @he-tree/vue3 v1.2.9
 * (c) phphe <phphe@outlook.com> (https://github.com/phphe)
 * Homepage: https://hetree.phphe.com
 * Released under the undefined License.
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue')) :
  typeof define === 'function' && define.amd ? define(['exports', 'vue'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.heTreeVue3 = {}, global.Vue));
})(this, (function (exports, vue) { 'use strict';

  function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
      var info = gen[key](arg);
      var value = info.value;
    } catch (error) {
      reject(error);
      return;
    }

    if (info.done) {
      resolve(value);
    } else {
      Promise.resolve(value).then(_next, _throw);
    }
  }

  function _asyncToGenerator(fn) {
    return function () {
      var self = this,
          args = arguments;
      return new Promise(function (resolve, reject) {
        var gen = fn.apply(self, args);

        function _next(value) {
          asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
        }

        function _throw(err) {
          asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
        }

        _next(undefined);
      });
    };
  }

  function _arrayLikeToArray$6(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) {
      arr2[i] = arr[i];
    }

    return arr2;
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray$6(arr);
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }

  function _unsupportedIterableToArray$6(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray$6(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$6(o, minLen);
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray$6(arr) || _nonIterableSpread();
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  var runtime = {exports: {}};

  /**
   * Copyright (c) 2014-present, Facebook, Inc.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */

  (function (module) {
  var runtime = (function (exports) {

    var Op = Object.prototype;
    var hasOwn = Op.hasOwnProperty;
    var undefined$1; // More compressible than void 0.
    var $Symbol = typeof Symbol === "function" ? Symbol : {};
    var iteratorSymbol = $Symbol.iterator || "@@iterator";
    var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
    var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";

    function define(obj, key, value) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
      return obj[key];
    }
    try {
      // IE 8 has a broken Object.defineProperty that only works on DOM objects.
      define({}, "");
    } catch (err) {
      define = function(obj, key, value) {
        return obj[key] = value;
      };
    }

    function wrap(innerFn, outerFn, self, tryLocsList) {
      // If outerFn provided and outerFn.prototype is a Generator, then outerFn.prototype instanceof Generator.
      var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
      var generator = Object.create(protoGenerator.prototype);
      var context = new Context(tryLocsList || []);

      // The ._invoke method unifies the implementations of the .next,
      // .throw, and .return methods.
      generator._invoke = makeInvokeMethod(innerFn, self, context);

      return generator;
    }
    exports.wrap = wrap;

    // Try/catch helper to minimize deoptimizations. Returns a completion
    // record like context.tryEntries[i].completion. This interface could
    // have been (and was previously) designed to take a closure to be
    // invoked without arguments, but in all the cases we care about we
    // already have an existing method we want to call, so there's no need
    // to create a new function object. We can even get away with assuming
    // the method takes exactly one argument, since that happens to be true
    // in every case, so we don't have to touch the arguments object. The
    // only additional allocation required is the completion record, which
    // has a stable shape and so hopefully should be cheap to allocate.
    function tryCatch(fn, obj, arg) {
      try {
        return { type: "normal", arg: fn.call(obj, arg) };
      } catch (err) {
        return { type: "throw", arg: err };
      }
    }

    var GenStateSuspendedStart = "suspendedStart";
    var GenStateSuspendedYield = "suspendedYield";
    var GenStateExecuting = "executing";
    var GenStateCompleted = "completed";

    // Returning this object from the innerFn has the same effect as
    // breaking out of the dispatch switch statement.
    var ContinueSentinel = {};

    // Dummy constructor functions that we use as the .constructor and
    // .constructor.prototype properties for functions that return Generator
    // objects. For full spec compliance, you may wish to configure your
    // minifier not to mangle the names of these two functions.
    function Generator() {}
    function GeneratorFunction() {}
    function GeneratorFunctionPrototype() {}

    // This is a polyfill for %IteratorPrototype% for environments that
    // don't natively support it.
    var IteratorPrototype = {};
    define(IteratorPrototype, iteratorSymbol, function () {
      return this;
    });

    var getProto = Object.getPrototypeOf;
    var NativeIteratorPrototype = getProto && getProto(getProto(values([])));
    if (NativeIteratorPrototype &&
        NativeIteratorPrototype !== Op &&
        hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
      // This environment has a native %IteratorPrototype%; use it instead
      // of the polyfill.
      IteratorPrototype = NativeIteratorPrototype;
    }

    var Gp = GeneratorFunctionPrototype.prototype =
      Generator.prototype = Object.create(IteratorPrototype);
    GeneratorFunction.prototype = GeneratorFunctionPrototype;
    define(Gp, "constructor", GeneratorFunctionPrototype);
    define(GeneratorFunctionPrototype, "constructor", GeneratorFunction);
    GeneratorFunction.displayName = define(
      GeneratorFunctionPrototype,
      toStringTagSymbol,
      "GeneratorFunction"
    );

    // Helper for defining the .next, .throw, and .return methods of the
    // Iterator interface in terms of a single ._invoke method.
    function defineIteratorMethods(prototype) {
      ["next", "throw", "return"].forEach(function(method) {
        define(prototype, method, function(arg) {
          return this._invoke(method, arg);
        });
      });
    }

    exports.isGeneratorFunction = function(genFun) {
      var ctor = typeof genFun === "function" && genFun.constructor;
      return ctor
        ? ctor === GeneratorFunction ||
          // For the native GeneratorFunction constructor, the best we can
          // do is to check its .name property.
          (ctor.displayName || ctor.name) === "GeneratorFunction"
        : false;
    };

    exports.mark = function(genFun) {
      if (Object.setPrototypeOf) {
        Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
      } else {
        genFun.__proto__ = GeneratorFunctionPrototype;
        define(genFun, toStringTagSymbol, "GeneratorFunction");
      }
      genFun.prototype = Object.create(Gp);
      return genFun;
    };

    // Within the body of any async function, `await x` is transformed to
    // `yield regeneratorRuntime.awrap(x)`, so that the runtime can test
    // `hasOwn.call(value, "__await")` to determine if the yielded value is
    // meant to be awaited.
    exports.awrap = function(arg) {
      return { __await: arg };
    };

    function AsyncIterator(generator, PromiseImpl) {
      function invoke(method, arg, resolve, reject) {
        var record = tryCatch(generator[method], generator, arg);
        if (record.type === "throw") {
          reject(record.arg);
        } else {
          var result = record.arg;
          var value = result.value;
          if (value &&
              typeof value === "object" &&
              hasOwn.call(value, "__await")) {
            return PromiseImpl.resolve(value.__await).then(function(value) {
              invoke("next", value, resolve, reject);
            }, function(err) {
              invoke("throw", err, resolve, reject);
            });
          }

          return PromiseImpl.resolve(value).then(function(unwrapped) {
            // When a yielded Promise is resolved, its final value becomes
            // the .value of the Promise<{value,done}> result for the
            // current iteration.
            result.value = unwrapped;
            resolve(result);
          }, function(error) {
            // If a rejected Promise was yielded, throw the rejection back
            // into the async generator function so it can be handled there.
            return invoke("throw", error, resolve, reject);
          });
        }
      }

      var previousPromise;

      function enqueue(method, arg) {
        function callInvokeWithMethodAndArg() {
          return new PromiseImpl(function(resolve, reject) {
            invoke(method, arg, resolve, reject);
          });
        }

        return previousPromise =
          // If enqueue has been called before, then we want to wait until
          // all previous Promises have been resolved before calling invoke,
          // so that results are always delivered in the correct order. If
          // enqueue has not been called before, then it is important to
          // call invoke immediately, without waiting on a callback to fire,
          // so that the async generator function has the opportunity to do
          // any necessary setup in a predictable way. This predictability
          // is why the Promise constructor synchronously invokes its
          // executor callback, and why async functions synchronously
          // execute code before the first await. Since we implement simple
          // async functions in terms of async generators, it is especially
          // important to get this right, even though it requires care.
          previousPromise ? previousPromise.then(
            callInvokeWithMethodAndArg,
            // Avoid propagating failures to Promises returned by later
            // invocations of the iterator.
            callInvokeWithMethodAndArg
          ) : callInvokeWithMethodAndArg();
      }

      // Define the unified helper method that is used to implement .next,
      // .throw, and .return (see defineIteratorMethods).
      this._invoke = enqueue;
    }

    defineIteratorMethods(AsyncIterator.prototype);
    define(AsyncIterator.prototype, asyncIteratorSymbol, function () {
      return this;
    });
    exports.AsyncIterator = AsyncIterator;

    // Note that simple async functions are implemented on top of
    // AsyncIterator objects; they just return a Promise for the value of
    // the final result produced by the iterator.
    exports.async = function(innerFn, outerFn, self, tryLocsList, PromiseImpl) {
      if (PromiseImpl === void 0) PromiseImpl = Promise;

      var iter = new AsyncIterator(
        wrap(innerFn, outerFn, self, tryLocsList),
        PromiseImpl
      );

      return exports.isGeneratorFunction(outerFn)
        ? iter // If outerFn is a generator, return the full iterator.
        : iter.next().then(function(result) {
            return result.done ? result.value : iter.next();
          });
    };

    function makeInvokeMethod(innerFn, self, context) {
      var state = GenStateSuspendedStart;

      return function invoke(method, arg) {
        if (state === GenStateExecuting) {
          throw new Error("Generator is already running");
        }

        if (state === GenStateCompleted) {
          if (method === "throw") {
            throw arg;
          }

          // Be forgiving, per 25.3.3.3.3 of the spec:
          // https://people.mozilla.org/~jorendorff/es6-draft.html#sec-generatorresume
          return doneResult();
        }

        context.method = method;
        context.arg = arg;

        while (true) {
          var delegate = context.delegate;
          if (delegate) {
            var delegateResult = maybeInvokeDelegate(delegate, context);
            if (delegateResult) {
              if (delegateResult === ContinueSentinel) continue;
              return delegateResult;
            }
          }

          if (context.method === "next") {
            // Setting context._sent for legacy support of Babel's
            // function.sent implementation.
            context.sent = context._sent = context.arg;

          } else if (context.method === "throw") {
            if (state === GenStateSuspendedStart) {
              state = GenStateCompleted;
              throw context.arg;
            }

            context.dispatchException(context.arg);

          } else if (context.method === "return") {
            context.abrupt("return", context.arg);
          }

          state = GenStateExecuting;

          var record = tryCatch(innerFn, self, context);
          if (record.type === "normal") {
            // If an exception is thrown from innerFn, we leave state ===
            // GenStateExecuting and loop back for another invocation.
            state = context.done
              ? GenStateCompleted
              : GenStateSuspendedYield;

            if (record.arg === ContinueSentinel) {
              continue;
            }

            return {
              value: record.arg,
              done: context.done
            };

          } else if (record.type === "throw") {
            state = GenStateCompleted;
            // Dispatch the exception by looping back around to the
            // context.dispatchException(context.arg) call above.
            context.method = "throw";
            context.arg = record.arg;
          }
        }
      };
    }

    // Call delegate.iterator[context.method](context.arg) and handle the
    // result, either by returning a { value, done } result from the
    // delegate iterator, or by modifying context.method and context.arg,
    // setting context.delegate to null, and returning the ContinueSentinel.
    function maybeInvokeDelegate(delegate, context) {
      var method = delegate.iterator[context.method];
      if (method === undefined$1) {
        // A .throw or .return when the delegate iterator has no .throw
        // method always terminates the yield* loop.
        context.delegate = null;

        if (context.method === "throw") {
          // Note: ["return"] must be used for ES3 parsing compatibility.
          if (delegate.iterator["return"]) {
            // If the delegate iterator has a return method, give it a
            // chance to clean up.
            context.method = "return";
            context.arg = undefined$1;
            maybeInvokeDelegate(delegate, context);

            if (context.method === "throw") {
              // If maybeInvokeDelegate(context) changed context.method from
              // "return" to "throw", let that override the TypeError below.
              return ContinueSentinel;
            }
          }

          context.method = "throw";
          context.arg = new TypeError(
            "The iterator does not provide a 'throw' method");
        }

        return ContinueSentinel;
      }

      var record = tryCatch(method, delegate.iterator, context.arg);

      if (record.type === "throw") {
        context.method = "throw";
        context.arg = record.arg;
        context.delegate = null;
        return ContinueSentinel;
      }

      var info = record.arg;

      if (! info) {
        context.method = "throw";
        context.arg = new TypeError("iterator result is not an object");
        context.delegate = null;
        return ContinueSentinel;
      }

      if (info.done) {
        // Assign the result of the finished delegate to the temporary
        // variable specified by delegate.resultName (see delegateYield).
        context[delegate.resultName] = info.value;

        // Resume execution at the desired location (see delegateYield).
        context.next = delegate.nextLoc;

        // If context.method was "throw" but the delegate handled the
        // exception, let the outer generator proceed normally. If
        // context.method was "next", forget context.arg since it has been
        // "consumed" by the delegate iterator. If context.method was
        // "return", allow the original .return call to continue in the
        // outer generator.
        if (context.method !== "return") {
          context.method = "next";
          context.arg = undefined$1;
        }

      } else {
        // Re-yield the result returned by the delegate method.
        return info;
      }

      // The delegate iterator is finished, so forget it and continue with
      // the outer generator.
      context.delegate = null;
      return ContinueSentinel;
    }

    // Define Generator.prototype.{next,throw,return} in terms of the
    // unified ._invoke helper method.
    defineIteratorMethods(Gp);

    define(Gp, toStringTagSymbol, "Generator");

    // A Generator should always return itself as the iterator object when the
    // @@iterator function is called on it. Some browsers' implementations of the
    // iterator prototype chain incorrectly implement this, causing the Generator
    // object to not be returned from this call. This ensures that doesn't happen.
    // See https://github.com/facebook/regenerator/issues/274 for more details.
    define(Gp, iteratorSymbol, function() {
      return this;
    });

    define(Gp, "toString", function() {
      return "[object Generator]";
    });

    function pushTryEntry(locs) {
      var entry = { tryLoc: locs[0] };

      if (1 in locs) {
        entry.catchLoc = locs[1];
      }

      if (2 in locs) {
        entry.finallyLoc = locs[2];
        entry.afterLoc = locs[3];
      }

      this.tryEntries.push(entry);
    }

    function resetTryEntry(entry) {
      var record = entry.completion || {};
      record.type = "normal";
      delete record.arg;
      entry.completion = record;
    }

    function Context(tryLocsList) {
      // The root entry object (effectively a try statement without a catch
      // or a finally block) gives us a place to store values thrown from
      // locations where there is no enclosing try statement.
      this.tryEntries = [{ tryLoc: "root" }];
      tryLocsList.forEach(pushTryEntry, this);
      this.reset(true);
    }

    exports.keys = function(object) {
      var keys = [];
      for (var key in object) {
        keys.push(key);
      }
      keys.reverse();

      // Rather than returning an object with a next method, we keep
      // things simple and return the next function itself.
      return function next() {
        while (keys.length) {
          var key = keys.pop();
          if (key in object) {
            next.value = key;
            next.done = false;
            return next;
          }
        }

        // To avoid creating an additional object, we just hang the .value
        // and .done properties off the next function object itself. This
        // also ensures that the minifier will not anonymize the function.
        next.done = true;
        return next;
      };
    };

    function values(iterable) {
      if (iterable) {
        var iteratorMethod = iterable[iteratorSymbol];
        if (iteratorMethod) {
          return iteratorMethod.call(iterable);
        }

        if (typeof iterable.next === "function") {
          return iterable;
        }

        if (!isNaN(iterable.length)) {
          var i = -1, next = function next() {
            while (++i < iterable.length) {
              if (hasOwn.call(iterable, i)) {
                next.value = iterable[i];
                next.done = false;
                return next;
              }
            }

            next.value = undefined$1;
            next.done = true;

            return next;
          };

          return next.next = next;
        }
      }

      // Return an iterator with no values.
      return { next: doneResult };
    }
    exports.values = values;

    function doneResult() {
      return { value: undefined$1, done: true };
    }

    Context.prototype = {
      constructor: Context,

      reset: function(skipTempReset) {
        this.prev = 0;
        this.next = 0;
        // Resetting context._sent for legacy support of Babel's
        // function.sent implementation.
        this.sent = this._sent = undefined$1;
        this.done = false;
        this.delegate = null;

        this.method = "next";
        this.arg = undefined$1;

        this.tryEntries.forEach(resetTryEntry);

        if (!skipTempReset) {
          for (var name in this) {
            // Not sure about the optimal order of these conditions:
            if (name.charAt(0) === "t" &&
                hasOwn.call(this, name) &&
                !isNaN(+name.slice(1))) {
              this[name] = undefined$1;
            }
          }
        }
      },

      stop: function() {
        this.done = true;

        var rootEntry = this.tryEntries[0];
        var rootRecord = rootEntry.completion;
        if (rootRecord.type === "throw") {
          throw rootRecord.arg;
        }

        return this.rval;
      },

      dispatchException: function(exception) {
        if (this.done) {
          throw exception;
        }

        var context = this;
        function handle(loc, caught) {
          record.type = "throw";
          record.arg = exception;
          context.next = loc;

          if (caught) {
            // If the dispatched exception was caught by a catch block,
            // then let that catch block handle the exception normally.
            context.method = "next";
            context.arg = undefined$1;
          }

          return !! caught;
        }

        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          var record = entry.completion;

          if (entry.tryLoc === "root") {
            // Exception thrown outside of any try block that could handle
            // it, so set the completion value of the entire function to
            // throw the exception.
            return handle("end");
          }

          if (entry.tryLoc <= this.prev) {
            var hasCatch = hasOwn.call(entry, "catchLoc");
            var hasFinally = hasOwn.call(entry, "finallyLoc");

            if (hasCatch && hasFinally) {
              if (this.prev < entry.catchLoc) {
                return handle(entry.catchLoc, true);
              } else if (this.prev < entry.finallyLoc) {
                return handle(entry.finallyLoc);
              }

            } else if (hasCatch) {
              if (this.prev < entry.catchLoc) {
                return handle(entry.catchLoc, true);
              }

            } else if (hasFinally) {
              if (this.prev < entry.finallyLoc) {
                return handle(entry.finallyLoc);
              }

            } else {
              throw new Error("try statement without catch or finally");
            }
          }
        }
      },

      abrupt: function(type, arg) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.tryLoc <= this.prev &&
              hasOwn.call(entry, "finallyLoc") &&
              this.prev < entry.finallyLoc) {
            var finallyEntry = entry;
            break;
          }
        }

        if (finallyEntry &&
            (type === "break" ||
             type === "continue") &&
            finallyEntry.tryLoc <= arg &&
            arg <= finallyEntry.finallyLoc) {
          // Ignore the finally entry if control is not jumping to a
          // location outside the try/catch block.
          finallyEntry = null;
        }

        var record = finallyEntry ? finallyEntry.completion : {};
        record.type = type;
        record.arg = arg;

        if (finallyEntry) {
          this.method = "next";
          this.next = finallyEntry.finallyLoc;
          return ContinueSentinel;
        }

        return this.complete(record);
      },

      complete: function(record, afterLoc) {
        if (record.type === "throw") {
          throw record.arg;
        }

        if (record.type === "break" ||
            record.type === "continue") {
          this.next = record.arg;
        } else if (record.type === "return") {
          this.rval = this.arg = record.arg;
          this.method = "return";
          this.next = "end";
        } else if (record.type === "normal" && afterLoc) {
          this.next = afterLoc;
        }

        return ContinueSentinel;
      },

      finish: function(finallyLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.finallyLoc === finallyLoc) {
            this.complete(entry.completion, entry.afterLoc);
            resetTryEntry(entry);
            return ContinueSentinel;
          }
        }
      },

      "catch": function(tryLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.tryLoc === tryLoc) {
            var record = entry.completion;
            if (record.type === "throw") {
              var thrown = record.arg;
              resetTryEntry(entry);
            }
            return thrown;
          }
        }

        // The context.catch method must only be called with a location
        // argument that corresponds to a known catch block.
        throw new Error("illegal catch attempt");
      },

      delegateYield: function(iterable, resultName, nextLoc) {
        this.delegate = {
          iterator: values(iterable),
          resultName: resultName,
          nextLoc: nextLoc
        };

        if (this.method === "next") {
          // Deliberately forget the last sent value so that we don't
          // accidentally pass it on to the delegate.
          this.arg = undefined$1;
        }

        return ContinueSentinel;
      }
    };

    // Regardless of whether this script is executing as a CommonJS module
    // or not, return the runtime object so that we can declare the variable
    // regeneratorRuntime in the outer scope, which allows this module to be
    // injected easily by `bin/regenerator --include-runtime script.js`.
    return exports;

  }(
    // If this script is executing as a CommonJS module, use module.exports
    // as the regeneratorRuntime namespace. Otherwise create a new empty
    // object. Either way, the resulting object will be used to initialize
    // the regeneratorRuntime variable at the top of this file.
    module.exports 
  ));

  try {
    regeneratorRuntime = runtime;
  } catch (accidentalStrictMode) {
    // This module should not be running in strict mode, so the above
    // assignment should always work unless something is misconfigured. Just
    // in case runtime.js accidentally runs in strict mode, in modern engines
    // we can explicitly access globalThis. In older engines we can escape
    // strict mode using a global Function call. This could conceivably fail
    // if a Content Security Policy forbids using Function, but in that case
    // the proper solution is to fix the accidental strict mode problem. If
    // you've misconfigured your bundler to force strict mode and applied a
    // CSP to forbid Function, and you're not willing to fix either of those
    // problems, please detail your unique predicament in a GitHub issue.
    if (typeof globalThis === "object") {
      globalThis.regeneratorRuntime = runtime;
    } else {
      Function("r", "regeneratorRuntime = r")(runtime);
    }
  }
  }(runtime));

  var regenerator = runtime.exports;

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    Object.defineProperty(Constructor, "prototype", {
      writable: false
    });
    return Constructor;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  /*! *****************************************************************************
  Copyright (c) Microsoft Corporation.

  Permission to use, copy, modify, and/or distribute this software for any
  purpose with or without fee is hereby granted.

  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
  REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
  AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
  INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
  LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
  OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
  PERFORMANCE OF THIS SOFTWARE.
  ***************************************************************************** */

  function __awaiter(thisArg, _arguments, P, generator) {
      function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
      return new (P || (P = Promise))(function (resolve, reject) {
          function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
          function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
          function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
          step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
  }

  /*!
   * helper-js v2.0.7
   * (c) phphe <phphe@outlook.com> (https://github.com/phphe)
   * Homepage: null
   * Released under the MIT License.
   */

  function _createForOfIteratorHelper$5(o, allowArrayLike) {
    var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];

    if (!it) {
      if (Array.isArray(o) || (it = _unsupportedIterableToArray$5(o)) || allowArrayLike && o && typeof o.length === "number") {
        if (it) o = it;
        var i = 0;

        var F = function F() {};

        return {
          s: F,
          n: function n() {
            if (i >= o.length) return {
              done: true
            };
            return {
              done: false,
              value: o[i++]
            };
          },
          e: function e(_e) {
            throw _e;
          },
          f: F
        };
      }

      throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }

    var normalCompletion = true,
        didErr = false,
        err;
    return {
      s: function s() {
        it = it.call(o);
      },
      n: function n() {
        var step = it.next();
        normalCompletion = step.done;
        return step;
      },
      e: function e(_e2) {
        didErr = true;
        err = _e2;
      },
      f: function f() {
        try {
          if (!normalCompletion && it.return != null) it.return();
        } finally {
          if (didErr) throw err;
        }
      }
    };
  }

  function _unsupportedIterableToArray$5(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray$5(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$5(o, minLen);
  }

  function _arrayLikeToArray$5(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) {
      arr2[i] = arr[i];
    }

    return arr2;
  } // 为此库有需要的方法存储信息

  function isArray(v) {
    return Object.prototype.toString.call(v) === "[object Array]";
  }

  function isFunction(v) {
    return typeof v === "function";
  }
  // 返回指定范围随机整数, 包括范围起始值和终止值


  function randInt(min, max) {
    return Math.floor(Math.random() * (max - min + 1) + min);
  } // rand item in array
  // 返回数组随机一项


  function randChoice(arr) {
    return arr[randInt(0, arr.length - 1)];
  } // Pad a string to a certain length with another string
  // 如果n小于min, 返回min, 否则n.


  function notLessThan(n, min) {
    return n < min ? min : n;
  } // If n greater than `max`, return `max`, else n.
  // 如果n大于max, 返回max, 否则n.


  function notGreaterThan(n, max) {
    return n < max ? n : max;
  } // ## string
  // 随机字符串


  function randString() {
    var len = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 8;
    var seeds = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    var r = "";

    for (var i = 0; i < len; i++) {
      r += randChoice(seeds);
    }

    return r;
  } // ## Array
  // 返回数组末项


  function arrayLast(arr) {
    return arr[arr.length - 1];
  } // return arr1 - arr2

  function toArrayIfNot(arrOrNot) {
    return isArray(arrOrNot) ? arrOrNot : [arrOrNot];
  }

  function objectAssignIfKeyNull(obj1, obj2) {
    Object.keys(obj2).forEach(function (key) {
      if (obj1[key] == null) {
        obj1[key] = obj2[key];
      }
    });
  }

  function depthFirstSearch(obj, handler) {
    var childrenKey = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "children";
    var opt = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
    var rootChildren = isArray(obj) ? obj : [obj]; //

    var StopException = /*#__PURE__*/_createClass(function StopException() {
      _classCallCheck(this, StopException);
    });

    var func = function func(children, parent, parentPath) {
      if (opt.reverse) {
        children = children.slice();
        children.reverse();
      }

      var len = children.length;

      for (var i = 0; i < len; i++) {
        var item = children[i];
        var index = opt.reverse ? len - i - 1 : i;
        var path = parentPath ? [].concat(_toConsumableArray(parentPath), [index]) : [];
        var r = handler(item, index, parent, path);

        if (r === false) {
          // stop
          throw new StopException();
        } else if (r === "skip children") {
          continue;
        } else if (r === "skip siblings") {
          break;
        }

        if (item[childrenKey] != null) {
          func(item[childrenKey], item, path);
        }
      }
    };

    try {
      func(rootChildren, null, isArray(obj) ? [] : null);
    } catch (e) {
      if (e instanceof StopException) ;else {
        throw e;
      }
    }
  } // refer [depthFirstSearch](#depthFirstSearch)


  var walkTreeData = depthFirstSearch; // tree data helpers

  var TreeData = /*#__PURE__*/function () {
    // data = null;
    function TreeData() {
      var data = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];

      _classCallCheck(this, TreeData);

      this.childrenKey = "children";
      this.data = data;
    }

    _createClass(TreeData, [{
      key: "rootChildren",
      get: function get() {
        var childrenKey = this.childrenKey;
        var data = this.data;
        return isArray(data) ? data : data[childrenKey];
      }
    }, {
      key: "iteratePath",
      value: /*#__PURE__*/regenerator.mark(function iteratePath(path) {
        var opt,
            childrenKey,
            rootChildren,
            prevPath,
            prevChildren,
            _iterator4,
            _step4,
            index,
            currentPath,
            currentNode,
            list,
            _iterator5,
            _step5,
            _step5$value,
            path0,
            node,
            _path,
            _args2 = arguments;

        return regenerator.wrap(function iteratePath$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                opt = _args2.length > 1 && _args2[1] !== undefined ? _args2[1] : {};
                childrenKey = this.childrenKey, rootChildren = this.rootChildren;

                if (opt.reverse) {
                  _context2.next = 29;
                  break;
                }

                prevPath = [];
                prevChildren = rootChildren;
                _iterator4 = _createForOfIteratorHelper$5(path);
                _context2.prev = 6;

                _iterator4.s();

              case 8:
                if ((_step4 = _iterator4.n()).done) {
                  _context2.next = 19;
                  break;
                }

                index = _step4.value;
                currentPath = [].concat(_toConsumableArray(prevPath), [index]);
                currentNode = prevChildren[index];
                _context2.next = 14;
                return {
                  path: currentPath,
                  node: currentNode
                };

              case 14:
                prevPath = currentPath;
                prevChildren = currentNode[childrenKey];

              case 17:
                _context2.next = 8;
                break;

              case 19:
                _context2.next = 24;
                break;

              case 21:
                _context2.prev = 21;
                _context2.t0 = _context2["catch"](6);

                _iterator4.e(_context2.t0);

              case 24:
                _context2.prev = 24;

                _iterator4.f();

                return _context2.finish(24);

              case 27:
                _context2.next = 49;
                break;

              case 29:
                list = _toConsumableArray(this.iteratePath(path, Object.assign(Object.assign({}, opt), {
                  reverse: false
                })));
                list.reverse();
                _iterator5 = _createForOfIteratorHelper$5(list);
                _context2.prev = 32;

                _iterator5.s();

              case 34:
                if ((_step5 = _iterator5.n()).done) {
                  _context2.next = 41;
                  break;
                }

                _step5$value = _step5.value, path0 = _step5$value.path, node = _step5$value.node;
                _path = path0;
                _context2.next = 39;
                return {
                  path: _path,
                  node: node
                };

              case 39:
                _context2.next = 34;
                break;

              case 41:
                _context2.next = 46;
                break;

              case 43:
                _context2.prev = 43;
                _context2.t1 = _context2["catch"](32);

                _iterator5.e(_context2.t1);

              case 46:
                _context2.prev = 46;

                _iterator5.f();

                return _context2.finish(46);

              case 49:
              case "end":
                return _context2.stop();
            }
          }
        }, iteratePath, this, [[6, 21, 24, 27], [32, 43, 46, 49]]);
      })
    }, {
      key: "getAllNodes",
      value: function getAllNodes(path) {
        var all = [];

        var _iterator6 = _createForOfIteratorHelper$5(this.iteratePath(path)),
            _step6;

        try {
          for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
            var node = _step6.value.node;
            all.push(node);
          }
        } catch (err) {
          _iterator6.e(err);
        } finally {
          _iterator6.f();
        }

        return all;
      }
    }, {
      key: "getNode",
      value: function getNode(path) {
        return arrayLast(this.getAllNodes(path));
      }
    }, {
      key: "getNodeIndexAndParent",
      value: function getNodeIndexAndParent(path) {
        var parentPath = path.slice();
        var index = parentPath.pop();
        return {
          parent: this.getNode(parentPath),
          index: index,
          parentPath: parentPath
        };
      }
    }, {
      key: "getNodeParent",
      value: function getNodeParent(path) {
        return this.getNodeIndexAndParent(path).parent;
      }
    }, {
      key: "setPathNode",
      value: function setPathNode(path, node) {
        if (path == null || path.length === 0) {
          this.data = node;
        } else {
          var childrenKey = this.childrenKey,
              rootChildren = this.rootChildren;

          var _this$getNodeIndexAnd = this.getNodeIndexAndParent(path),
              parent = _this$getNodeIndexAnd.parent,
              index = _this$getNodeIndexAnd.index;

          var parentChildren = path.length === 1 ? rootChildren : parent[childrenKey];
          parentChildren[index] = node;
        }
      }
    }, {
      key: "removeNode",
      value: function removeNode(path) {
        var childrenKey = this.childrenKey,
            rootChildren = this.rootChildren;

        var _this$getNodeIndexAnd2 = this.getNodeIndexAndParent(path),
            parent = _this$getNodeIndexAnd2.parent,
            index = _this$getNodeIndexAnd2.index;

        var parentChildren = path.length === 1 ? rootChildren : parent[childrenKey];
        var node = parentChildren[index];
        parentChildren.splice(index, 1);
        return node;
      }
    }, {
      key: "walk",
      value: function walk(handler, opt) {
        var childrenKey = this.childrenKey,
            data = this.data; // @ts-ignore

        return walkTreeData(data, handler, childrenKey, opt);
      }
    }, {
      key: "clone",
      value: function clone() {
        var opt = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {}; // opt.afterNodeCreated(newNode, {oldNode: node, index, parent, path})

        var childrenKey = this.childrenKey;
        var td = new TreeData();
        td.childrenKey = childrenKey;
        this.walk(function (node, index, parent, path) {
          var newNode = Object.assign({}, node);

          if (newNode[childrenKey]) {
            newNode[childrenKey] = [];
          }

          if (opt.afterNodeCreated) {
            opt.afterNodeCreated(newNode, {
              oldNode: node,
              index: index,
              parent: parent,
              path: path
            });
          }

          td.setPathNode(path, newNode);
        });
        return td.data;
      }
    }]);

    return TreeData;
  }(); // ## function
  // ## 函数
  // if it is function, return result, else return it directly.


  function resolveValueOrGettter(valueOrGetter) {
    var args = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

    if (isFunction(valueOrGetter)) {
      return valueOrGetter.apply(void 0, _toConsumableArray(args));
    } else {
      return valueOrGetter;
    }
  }
  // return NodeList if there are multiple top-level nodes


  function createElementFromHTML(htmlString) {
    var div = document.createElement("div");
    div.innerHTML = htmlString.trim();

    if (div.childNodes.length > 1) {
      return div.childNodes;
    } else {
      return div.childNodes[0];
    }
  }

  function isDescendantOf(el, parent) {
    while (true) {
      if (el.parentElement == null) {
        return false;
      } else if (el.parentElement === parent) {
        return true;
      } else {
        el = el.parentElement;
      }
    }
  }

  function removeEl(el) {
    if (el.parentNode !== null) {
      return el.parentNode.removeChild(el);
    }
  } // refer: https://stackoverflow.com/questions/871399/cross-browser-method-for-detecting-the-scrolltop-of-the-browser-window


  function getScroll() {
    if (typeof pageYOffset != "undefined") {
      //most browsers except IE before #9
      return {
        top: pageYOffset,
        left: pageXOffset
      };
    } else {
      var B = document.body; //IE 'quirks'

      var D = document.documentElement; //IE with doctype

      D = D.clientHeight ? D : B;
      return {
        top: D.scrollTop,
        left: D.scrollLeft
      };
    }
  } // refer: https://gist.github.com/aderaaij/89547e34617b95ac29d1


  function getOffset(el) {
    var rect = getBoundingClientRect(el);
    var scroll = getScroll();
    return {
      x: rect.left + scroll.left,
      y: rect.top + scroll.top
    };
  } // there is some trap in el.offsetParent, so use this func to fix

  function getBoundingClientRect(el) {
    // refer: http://www.51xuediannao.com/javascript/getBoundingClientRect.html
    var xy = el.getBoundingClientRect();
    var top = xy.top - document.documentElement.clientTop,
        //document.documentElement.clientTop 在IE67中始终为2，其他高级点的浏览器为0
    bottom = xy.bottom,
        left = xy.left - document.documentElement.clientLeft,
        //document.documentElement.clientLeft 在IE67中始终为2，其他高级点的浏览器为0
    right = xy.right,
        width = xy.width || right - left,
        //IE67不存在width 使用right - left获得
    height = xy.height || bottom - top;
    var x = left;
    var y = top;
    return {
      top: top,
      right: right,
      bottom: bottom,
      left: left,
      width: width,
      height: height,
      x: x,
      y: y
    };
  } // refer [getBoundingClientRect](#getBoundingClientRect)


  var getViewportPosition = getBoundingClientRect; // TODO not tested

  function findParent(el, callback) {
    var opt = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var cur = opt && opt.withSelf ? el : el.parentElement;

    while (cur) {
      var r = callback(cur);

      if (r === "break") {
        return;
      } else if (r) {
        return cur;
      } else {
        cur = cur.parentElement;
      }
    }
  }

  function backupAttr(el, name) {
    var key = "original_".concat(name);
    el[key] = el.getAttribute(name);
  }

  function restoreAttr(el, name) {
    var key = "original_".concat(name);
    var value = el[key];

    if (value == null) {
      el.removeAttribute(name);
    } else {
      el.setAttribute(name, value);
    }
  } // source: http://youmightnotneedjquery.com/


  function hasClass(el, className) {
    if (el.classList) {
      return el.classList.contains(className);
    } else {
      return new RegExp("(^| )" + className + "( |$)", "gi").test(el.className);
    }
  } // source: http://youmightnotneedjquery.com/


  function addClass(el, className) {
    if (!hasClass(el, className)) {
      if (el.classList) {
        el.classList.add(className);
      } else {
        el.className += " " + className;
      }
    }
  } // source: http://youmightnotneedjquery.com/

  function onDOM(el, name, handler) {
    for (var _len5 = arguments.length, args = new Array(_len5 > 3 ? _len5 - 3 : 0), _key6 = 3; _key6 < _len5; _key6++) {
      args[_key6 - 3] = arguments[_key6];
    }

    if (el.addEventListener) {
      // 所有主流浏览器，除了 IE 8 及更早 IE版本
      el.addEventListener.apply(el, [name, handler].concat(args)); // @ts-ignore
    } else if (el.attachEvent) {
      // IE 8 及更早 IE 版本
      // @ts-ignore
      el.attachEvent.apply(el, ["on".concat(name), handler].concat(args));
    }
  }

  function offDOM(el, name, handler) {
    for (var _len6 = arguments.length, args = new Array(_len6 > 3 ? _len6 - 3 : 0), _key7 = 3; _key7 < _len6; _key7++) {
      args[_key7 - 3] = arguments[_key7];
    }

    if (el.removeEventListener) {
      // 所有主流浏览器，除了 IE 8 及更早 IE版本
      el.removeEventListener.apply(el, [name, handler].concat(args)); // @ts-ignore
    } else if (el.detachEvent) {
      // IE 8 及更早 IE 版本
      // @ts-ignore
      el.detachEvent.apply(el, ["on".concat(name), handler].concat(args));
    }
  }

  function elementsFromPoint(x, y) {
    var args = [x, y];
    var func = document.elementsFromPoint || // @ts-ignore
    document.msElementsFromPoint || elementsFromPoint;
    return func.apply(document, args);

    function elementsFromPoint(x, y) {
      var parents = [];
      var parent = void 0;

      do {
        if (parent !== document.elementFromPoint(x, y)) {
          parent = document.elementFromPoint(x, y);
          parents.push(parent);
          parent.style.pointerEvents = "none";
        } else {
          parent = false;
        }
      } while (parent);

      parents.forEach(function (parent) {
        return parent.style.pointerEvents = "all";
      });
      return parents;
    }
  }
  /* scroll to a positon with duration
  from https://gist.github.com/andjosh/6764939
  interface options{
    x: number // nullable. don't scroll horizontally when null
    y: number // nullable. don't scroll vertically when null
    duration: number // default 0
    element: Element // default is the top scrollable element.
    beforeEveryFrame: (count: number) => boolean|void // call before requestAnimationFrame execution. return false to stop
  }
  return stop
  */


  function scrollTo(options) {
    if (!options.element) {
      options.element = document.scrollingElement || document.documentElement;
    }

    if (options.duration == null) {
      options.duration = 0;
    }

    var x = options.x,
        y = options.y,
        duration = options.duration,
        element = options.element;
    var requestAnimationFrameId;
    var count = 0;

    var startY = element.scrollTop,
        changeY = y - startY,
        startX = element.scrollLeft,
        changeX = x - startX,
        startDate = +new Date(),
        animateScroll = function animateScroll() {
      if (options.beforeEveryFrame && options.beforeEveryFrame(count) === false) {
        return;
      }

      var currentDate = new Date().getTime();
      var changedTime = currentDate - startDate;

      if (y != null) {
        element.scrollTop = parseInt(calc(startY, changeY, changedTime, duration));
      }

      if (x != null) {
        element.scrollLeft = parseInt(calc(startX, changeX, changedTime, duration));
      }

      if (changedTime < duration) {
        requestAnimationFrameId = requestAnimationFrame(animateScroll);
      } else {
        if (y != null) {
          element.scrollTop = y;
        }

        if (x != null) {
          element.scrollLeft = x;
        }
      }

      count++;
    };

    var stop = function stop() {
      cancelAnimationFrame(requestAnimationFrameId);
    };

    animateScroll(); // return stop

    return stop;

    function calc(startValue, changeInValue, changedTime, duration) {
      return startValue + changeInValue * (changedTime / duration);
    }
  } // ### DOM structure

  function insertAfter(el, target) {
    target.parentElement.insertBefore(el, target.nextSibling);
  }

  function prependTo(el, target) {
    target.insertBefore(el, target.firstChild);
  }

  function binarySearch(arr, callback) {
    var opt = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    opt = Object.assign({
      start: 0,
      end: arr.length - 1,
      maxTimes: 1000
    }, opt);
    var _opt = opt,
        start = _opt.start,
        end = _opt.end;
    var _opt2 = opt,
        returnNearestIfNoHit = _opt2.returnNearestIfNoHit,
        maxTimes = _opt2.maxTimes;
    var midNum;
    var mid;

    if (start == null) {
      start = 0;
      end = arr.length - 1;
    }

    var i = 0;
    var r;

    while (start >= 0 && start <= end) {
      if (i >= maxTimes) {
        throw Error("binarySearch: loop times is over ".concat(maxTimes, ", you can increase the limit."));
      }

      midNum = Math.floor((end - start) / 2 + start);
      mid = arr[midNum];
      r = callback(mid, i);

      if (r > 0) {
        end = midNum - 1;
      } else if (r < 0) {
        start = midNum + 1;
      } else {
        return {
          index: midNum,
          value: mid,
          count: i + 1,
          hit: true
        };
      }

      i++;
    }

    return returnNearestIfNoHit ? {
      index: midNum,
      value: mid,
      count: i + 1,
      hit: false,
      greater: r > 0
    } : null;
  } //

  function waitTime(milliseconds, callback) {
    return new Promise(function (resolve, reject) {
      setTimeout(function () {
        callback && callback();
        resolve();
      }, milliseconds);
    });
  }

  function waitFor(condition) {
    var time = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 100;
    var maxTimes = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1000;
    var interval;
    var promise = new Promise(function (resolve, reject) {
      var count = 0;

      function judge() {
        if (count <= maxTimes) {
          if (condition()) {
            stop();
            resolve();
          }
        } else {
          stop();
          reject(new Error("waitFor: Limit is reached"));
        }

        count++;
      }

      interval = setInterval(function () {
        judge();
      }, time);
      judge();
    });
    return {
      promise: promise,
      stop: stop
    };

    function stop() {
      clearInterval(interval);
    }
  }

  function _createForOfIteratorHelper$4(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$4(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

  function _unsupportedIterableToArray$4(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$4(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$4(o, minLen); }

  function _arrayLikeToArray$4(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

  function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

  function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
  function genNodeID() {
    return "ht_".concat(randString(12));
  }
  function initNode(node) {
    if (!node.$id) {
      node.$id = genNodeID();
    }

    if (!node.$children) {
      node.$children = [];
    }
  }
  function convertTreeDataToFlat(data) {
    var childrenKey = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "children";
    var idKey = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "id";
    var flatData = [];
    var mapForPid = new Map();
    walkTreeData(data, function (node, index, parent) {
      var newNode = _objectSpread({
        $id: node[idKey],
        $pid: ""
      }, node);

      initNode(newNode);
      mapForPid.set(node, newNode.$id);
      newNode.$pid = parent && mapForPid.get(parent) || null;
      flatData.push(newNode);
    }, childrenKey);
    return convertFlatDataToStandard(flatData, "$id", "$pid");
  }
  function convertFlatDataToStandard(data) {
    var idKey = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "id";
    var pidKey = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "parent_id";
    var nodesByID = {};
    var nodes = data.map(function (node) {
      // @ts-ignore
      var newNode = _objectSpread(_objectSpread({
        $id: node[idKey],
        $pid: node[pidKey]
      }, node), {}, {
        $children: []
      });

      initNode(newNode);
      nodesByID[newNode.$id] = newNode;
      return newNode;
    });
    var top = [];

    var _iterator = _createForOfIteratorHelper$4(nodes),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var node = _step.value;

        if (node.$level == null) {
          node.$level = resolveLevel(node);
        }

        var parent = node.$pid && nodesByID[node.$pid];

        if (parent) {
          parent.$children.push(node);
        }

        if (node.$level === 1) {
          top.push(node);
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    nodes = [];
    walkTreeData(top, function (node) {
      nodes.push(node);
    }, "$children");
    return {
      nodes: nodes,
      nodesByID: nodesByID
    }; //

    function resolveLevel(node) {
      if (node.$level && node.$level > 0) {
        return node.$level;
      } else {
        var parent = nodesByID[node.$pid || ""];

        if (!parent) {
          return 1;
        } else {
          return resolveLevel(parent) + 1;
        }
      }
    }
  }

  function _createForOfIteratorHelper$3(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$3(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

  function _unsupportedIterableToArray$3(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$3(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$3(o, minLen); }

  function _arrayLikeToArray$3(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }
  var script$2 = vue.defineComponent({
    props: {
      items: {
        type: Array,
        default: function _default() {
          return [];
        }
      },
      enabled: {
        type: Boolean,
        default: true
      },
      buffer: {
        type: Number,
        default: 200
      },
      minItemHeight: {
        type: Number,
        default: 20
      },
      prerender: {
        type: Number,
        default: 20
      },
      listTag: {
        type: String,
        default: "div"
      },
      listClass: {
        type: String
      },
      itemClass: {
        type: String,
        default: "vl-item"
      },
      gap: {
        type: Number,
        default: 0
      },
      afterCalcTop2: {
        type: Function
      },
      isForceVisible: {
        type: Function
      }
    },
    data: function data() {
      var _this = this;

      return {
        start: 0,
        end: -1,
        top: 0,
        bottom: 0,
        totalHeight: 0,
        itemsHeight: [],
        mountedPromise: new Promise(function (resolve, reject) {
          _this._mountedPromise_resolve = resolve;
        })
      };
    },
    computed: {
      visibleItems: function visibleItems() {
        var _this2 = this;

        var r = [];
        this.items.forEach(function (item, index) {
          if (!_this2.enabled) {
            r.push({
              item: item,
              index: index
            });
          } else if (index >= _this2.start && index <= _this2.end || _this2.isForceVisible && _this2.isForceVisible(item, index)) {
            r.push({
              item: item,
              index: index
            });
          }
        });
        return r;
      }
    },
    watch: {
      enabled: {
        immediate: true,
        handler: function handler() {
          if (!this.enabled) {
            // @ts-ignore
            this.totalHeight = undefined;
          }
        }
      }
    },
    methods: {
      getItemElHeight: function getItemElHeight(el) {
        return getBoundingClientRect(el).height + this.gap;
      },
      update: function update() {
        var _this3 = this;

        var task = /*#__PURE__*/function () {
          var _ref = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee2() {
            var existingHeight, i, _iterator, _step, child, _index, avgHeight, buffer, itemsHeight, items, _this3$$el, clientHeight, scrollTop, start, top, maxIndex, topSpace, newTop, top2, end, bottom, index, totalHeight, waitDOMUpdated, next;

            return regenerator.wrap(function _callee2$(_context2) {
              while (1) {
                switch (_context2.prev = _context2.next) {
                  case 0:
                    if (_this3.enabled) {
                      _context2.next = 4;
                      break;
                    }

                    _this3.start = 0;
                    _this3.end = _this3.items.length;
                    return _context2.abrupt("return");

                  case 4:
                    _context2.next = 6;
                    return _this3.mountedPromise;

                  case 6:
                    existingHeight = 0;
                    i = 0;
                    _iterator = _createForOfIteratorHelper$3(_this3.$el.querySelector(".vl-items").children);

                    try {
                      for (_iterator.s(); !(_step = _iterator.n()).done;) {
                        child = _step.value;

                        if ((child.style.position === "" || child.style.position == null) && child.style.display !== "none") {
                          i++;
                          _index = parseInt(child.getAttribute("data-vindex"));
                          _this3.itemsHeight[_index] = _this3.getItemElHeight(child);
                          existingHeight += _this3.itemsHeight[_index];
                        }
                      }
                    } catch (err) {
                      _iterator.e(err);
                    } finally {
                      _iterator.f();
                    }

                    avgHeight = existingHeight / i || _this3.minItemHeight;
                    buffer = _this3.buffer, itemsHeight = _this3.itemsHeight, items = _this3.items;
                    _this3$$el = _this3.$el, clientHeight = _this3$$el.clientHeight, scrollTop = _this3$$el.scrollTop;
                    start = 0, top = 0;
                    maxIndex = items.length - 1;
                    topSpace = notLessThan(scrollTop - buffer, 0);

                  case 16:
                    if (!(top < topSpace && start <= maxIndex)) {
                      _context2.next = 24;
                      break;
                    }

                    newTop = top + (itemsHeight[start] || avgHeight);

                    if (!(newTop > topSpace)) {
                      _context2.next = 20;
                      break;
                    }

                    return _context2.abrupt("break", 24);

                  case 20:
                    top = newTop;
                    start++;
                    _context2.next = 16;
                    break;

                  case 24:
                    top2 = top;
                    end = start;

                    if (_this3.afterCalcTop2) {
                      top2 = _this3.afterCalcTop2(top2);
                    }

                    while (top2 < scrollTop + clientHeight + buffer && end <= maxIndex) {
                      top2 += itemsHeight[end] || avgHeight;
                      end++;
                    }

                    bottom = 0;

                    for (index = end + 1; index < items.length; index++) {
                      bottom += itemsHeight[index] || avgHeight;
                    }

                    totalHeight = top2 + bottom;
                    _this3.start = start;
                    _this3.end = end;
                    _this3.top = top;
                    _this3.bottom = bottom;

                    if (_this3.totalHeight == null || scrollTop + clientHeight > _this3.totalHeight - buffer || Math.abs(_this3.totalHeight - totalHeight) > 100) {
                      if (_this3.totalHeight !== totalHeight) {
                        _this3.totalHeight = totalHeight;
                      }
                    }

                    waitDOMUpdated = function waitDOMUpdated() {
                      // eslint-disable-next-line no-async-promise-executor
                      return new Promise( /*#__PURE__*/function () {
                        var _ref2 = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee(resolve, reject) {
                          return regenerator.wrap(function _callee$(_context) {
                            while (1) {
                              switch (_context.prev = _context.next) {
                                case 0:
                                  _context.next = 2;
                                  return vue.nextTick();

                                case 2:
                                  _context.next = 4;
                                  return waitFor(function () {
                                    var startEl, endEl, startIndex, endIndex;
                                    startEl = _this3.$el.querySelector(".".concat(_this3.itemClass, "[data-v-render-index=\"0\"]"));
                                    endEl = _this3.$el.querySelector(".".concat(_this3.itemClass, "[data-v-render-index=\"").concat(_this3.visibleItems.length - 1, "\"]"));

                                    if (startEl && endEl) {
                                      startIndex = parseInt(startEl.getAttribute("data-vindex"));
                                      endIndex = parseInt(endEl.getAttribute("data-vindex"));
                                      return startIndex == _this3.start && endIndex === _this3.end;
                                    }

                                    return false;
                                  }, 5, 10).promise.then(function (x) {//
                                    // console.log("success to wait DOM updated");
                                  }).catch(function (error) {//
                                    // console.warn("failed to wait DOM updated");
                                  });

                                case 4:
                                  resolve(undefined);

                                case 5:
                                case "end":
                                  return _context.stop();
                              }
                            }
                          }, _callee);
                        }));

                        return function (_x, _x2) {
                          return _ref2.apply(this, arguments);
                        };
                      }());
                    };

                    _context2.next = 39;
                    return waitDOMUpdated();

                  case 39:
                    // @ts-ignore
                    if (_this3._waitingUpdate) {
                      // @ts-ignore
                      next = _this3._waitingUpdate;

                      if (next !== task) {
                        next();
                      } else {
                        // @ts-ignore
                        _this3._waitingUpdate = undefined;
                      }
                    }

                  case 40:
                  case "end":
                    return _context2.stop();
                }
              }
            }, _callee2);
          }));

          return function task() {
            return _ref.apply(this, arguments);
          };
        }(); // @ts-ignore


        if (!this._waitingUpdate) {
          // @ts-ignore
          this._waitingUpdate = task;
          task();
        } else {
          // @ts-ignore
          this._waitingUpdate = task;
        }
      }
    },
    created: function created() {
      this.bottom = this.prerender - 1;
    },
    mounted: function mounted() {
      var _this4 = this;

      // @ts-ignore
      this._mountedPromise_resolve(null);

      var updatedOnce = false;
      this.$watch(function () {
        return [_this4.items];
      }, function () {
        _this4.itemsHeight = [];
        vue.nextTick(function () {
          _this4.update();

          if (!updatedOnce) {
            _this4.update();
          }

          updatedOnce = true;
        });
      }, {
        immediate: true
      });
      this.$watch(function () {
        return [_this4.buffer];
      }, function () {
        _this4.update();
      });
    }
  });

  function render$1(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("div", {
      class: "VirtualizationList virtualization-list",
      onScrollPassive: _cache[0] || (_cache[0] = function () {
        return _ctx.update && _ctx.update.apply(_ctx, arguments);
      })
    }, [(vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.listTag), {
      class: vue.normalizeClass(["vl-items", _ctx.listClass]),
      style: vue.normalizeStyle(_ctx.enabled && {
        paddingTop: _ctx.top + 'px',
        paddingBottom: _ctx.bottom + 'px',
        height: _ctx.totalHeight + 'px'
      })
    }, {
      default: vue.withCtx(function () {
        return [(vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.visibleItems, function (info, i) {
          return vue.renderSlot(_ctx.$slots, "default", {
            key: info.item.$id,
            item: info.item,
            index: info.index,
            renderIndex: i,
            itemStyle: {
              marginBottom: _ctx.gap + 'px'
            }
          });
        }), 128
        /* KEYED_FRAGMENT */
        ))];
      }),
      _: 3
      /* FORWARDED */

    }, 8
    /* PROPS */
    , ["class", "style"]))], 32
    /* HYDRATE_EVENTS */
    );
  }

  script$2.render = render$1;
  script$2.__file = "src/components/VirtualizationList.vue";

  function _createForOfIteratorHelper$2(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$2(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

  function _unsupportedIterableToArray$2(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$2(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$2(o, minLen); }

  function _arrayLikeToArray$2(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }
  var trees = {};
  var script$1 = vue.defineComponent({
    components: {
      VirtualizationList: script$2
    },
    props: {
      idKey: {
        type: String,
        default: "id"
      },
      parentIdKey: {
        type: String,
        default: "parent_id"
      },
      childrenKey: {
        type: String,
        default: "children"
      },
      textKey: {
        type: String,
        default: "text"
      },
      flatData: {
        type: Array
      },
      treeData: {
        type: Array
      },
      indent: {
        type: Number,
        default: 20
      },
      gap: {
        type: Number
      },
      rtl: {
        type: Boolean,
        default: false
      },
      virtualization: {
        type: Boolean,
        default: false
      },
      virtualizationPrerender: {
        type: Number,
        default: 20
      },
      childrenLazyLoading: {
        type: Boolean,
        default: false
      },
      childrenLoader: {
        type: Function
      },
      defaultFolded: {
        type: Boolean,
        default: false
      }
    },
    data: function data() {
      var _this = this;

      return {
        nodes: [],
        nodesByID: {},
        trees: trees,
        dragging: false,
        treeID: randString(),
        tree: this,
        virtualizationListAfterCalcTop2: undefined,
        // for drag
        store: null,
        draggingNode: null,
        // is node force visible in virtual list
        isNodeForceVisibleInVL: function isNodeForceVisibleInVL(node, index) {
          // @ts-ignore
          return _this.draggingNode === node;
        }
      };
    },
    computed: {
      rootNodeChildren: function rootNodeChildren() {
        var _this2 = this;

        return this.nodes.filter(function (node) {
          return !node.$pid || !_this2.nodesByID[node.$pid];
        });
      },
      rootNode: function rootNode() {
        return {
          $level: 0,
          $children: this.rootNodeChildren
        };
      },
      visibleNodes: function visibleNodes() {
        var _this3 = this;

        return this.nodes.filter(function (node, index) {
          return _this3.isNodeVisible(node);
        });
      }
    },
    watch: {
      flatData: {
        immediate: true,
        handler: function handler(val) {
          if (val) {
            var t = convertFlatDataToStandard(val, this.idKey, this.parentIdKey);
            this.initNodes(t.nodes);
            this.nodes = t.nodes;
            this.nodesByID = t.nodesByID;
          } else {
            if (!this.treeData) {
              this.nodes = [];
              this.nodesByID = {};
            }
          }
        }
      },
      treeData: {
        immediate: true,
        handler: function handler(val) {
          if (val) {
            var t = convertTreeDataToFlat(val, this.childrenKey, this.idKey);
            this.initNodes(t.nodes);
            this.nodes = t.nodes;
            this.nodesByID = t.nodesByID;
          } else {
            if (!this.flatData) {
              this.nodes = [];
              this.nodesByID = {};
            }
          }
        }
      }
    },
    methods: {
      initNodes: function initNodes(nodes) {
        var nodeInitializators = [];

        for (var _i = 0, _Object$keys = Object.keys(this.$data); _i < _Object$keys.length; _i++) {
          var key = _Object$keys[_i];

          if (key.startsWith("nodeInitializator_")) {
            nodeInitializators.push(this.$data[key]);
          }
        }

        var idKey = this.idKey,
            parentIdKey = this.parentIdKey;

        var _iterator = _createForOfIteratorHelper$2(nodes),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var node = _step.value;

            if (node.$id == null) {
              node.$id = node[idKey];
            }

            if (node.$pid == null) {
              node.$pid = node[parentIdKey];
            }

            initNode(node);

            if (this.nodesByID) {
              this.nodesByID[node.$id] = node;
            }

            if (node.$folded == null) {
              node.$folded = this.defaultFolded;
            }

            if (node.$checked == null) {
              node.$checked = false;
            }

            var _iterator2 = _createForOfIteratorHelper$2(nodeInitializators),
                _step2;

            try {
              for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                var func = _step2.value;
                func(node);
              }
            } catch (err) {
              _iterator2.e(err);
            } finally {
              _iterator2.f();
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      },
      getTreeVmByTreeEl: function getTreeVmByTreeEl(treeEl) {
        return this.trees[treeEl.getAttribute("id")];
      },
      nodeIndentStyle: function nodeIndentStyle(node) {
        return _defineProperty({}, !this.rtl ? "paddingLeft" : "paddingRight", this.indent * (node.$level - 1) + "px");
      },
      getNodeByEl: function getNodeByEl(el) {
        var el2 = findParent(el, function (el) {
          return hasClass(el, "tree-node-outer");
        }, {
          withSelf: true
        });
        var id = el2.getAttribute("data-id");
        return this.nodesByID[id];
      },
      getElByID: function getElByID(id) {
        return this.$el.querySelector("[data-id=\"".concat(id, "\"]"));
      },
      getParent: function getParent(node) {
        if (!node) {
          return undefined;
        }

        return node.$pid ? this.nodesByID[node.$pid] : undefined;
      },
      getChildren: function getChildren(node) {
        if (!node) {
          return this.rootNode.$children;
        }

        return node.$children;
      },
      countChildren: function countChildren(node) {
        var r = 0;
        var t = node || this.rootNode;
        walkTreeData(t.$children, function (node) {
          r++;
        }, "$children");
        return r;
      },
      _checkIDExists: function _checkIDExists(id) {
        if (!this.nodesByID[id]) {
          throw new Error("Node not found by specified id ".concat(id));
        }
      },
      _pidIndexToListIndex: function _pidIndexToListIndex(pid, index) {
        pid != null && this._checkIDExists(pid);
        var parent = this.nodesByID[pid];
        var listIndex = 0;

        if (parent) {
          listIndex = this.nodes.indexOf(parent) + 1;
        }

        var parentChildren = this.getChildren(parent);

        for (var i = 0; i < index; i++) {
          listIndex += 1 + this.countChildren(parentChildren[i]);
        }

        return listIndex;
      },
      addNode: function addNode(node, parentId) {
        var _this4 = this,
            _this$nodes;

        var index = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
        parentId != null && this._checkIDExists(parentId);
        var nodes = [];
        var parent = this.nodesByID[parentId];
        walkTreeData(node, function (child, index, childParent) {
          _this4.initNodes([child]);

          var parent2 = childParent || parent;
          child.$level = parent2 ? parent2.$level + 1 : 1;
          child.$pid = parent2 ? parent2.$id : null;
          child.$children = child[_this4.childrenKey] || [];
          nodes.push(child);
        }, this.childrenKey);

        if (parent) {
          parent.$children.splice(index, 0, node);
        }

        var listIndex = this._pidIndexToListIndex(parentId, index);

        (_this$nodes = this.nodes).splice.apply(_this$nodes, [listIndex, 0].concat(nodes));
      },
      moveNode: function moveNode(node, parentId) {
        var _this$nodes2;

        var index = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
        parentId != null && this._checkIDExists(parentId);
        var flatNodes = [];
        var oldParent = this.getParent(node);

        if (oldParent) {
          var oldIndex = oldParent.$children.indexOf(node);
          oldParent.$children.splice(oldIndex, 1);
        }

        var oldListIndex = this.nodes.indexOf(node);
        var removeLen = this.countChildren(node) + 1;
        this.nodes.splice(oldListIndex, removeLen);
        var newParent = this.nodesByID[parentId];
        walkTreeData(node, function (child, index, childParent) {
          var parent2 = childParent || newParent;
          child.$level = parent2 ? parent2.$level + 1 : 1;
          flatNodes.push(child);
        }, "$children");
        node.$pid = parentId == null ? undefined : parentId;

        if (newParent) {
          newParent.$children.splice(index, 0, node);
        }

        var listIndex = this._pidIndexToListIndex(parentId, index);

        (_this$nodes2 = this.nodes).splice.apply(_this$nodes2, [listIndex, 0].concat(flatNodes));
      },
      removeNode: function removeNode(node) {
        var parent = this.getParent(node);

        if (parent) {
          var index = parent.$children.indexOf(node);
          parent.$children.splice(index, 1);
        }

        var listIndex = this.nodes.indexOf(node);
        var removeLen = this.countChildren(node) + 1;
        this.nodes.splice(listIndex, removeLen);
      },
      outputNestedData: function outputNestedData(parent) {
        var ignoreKeys = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

        var _returnFlat = arguments.length > 2 ? arguments[2] : undefined;

        var td = new TreeData(parent || this.rootNode.$children);
        td.childrenKey = "$children";
        var data = td.clone();
        var nodes = [];
        walkTreeData(data, function (child) {
          nodes.push(child);
        }, "$children");
        var idKey = this.idKey,
            childrenKey = this.childrenKey,
            parentIdKey = this.parentIdKey;
        var ignore = {};

        var _iterator3 = _createForOfIteratorHelper$2(ignoreKeys),
            _step3;

        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var _key = _step3.value;
            ignore[_key] = true;
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }

        for (var _i2 = 0, _nodes = nodes; _i2 < _nodes.length; _i2++) {
          var node = _nodes[_i2];

          if (idKey !== "$id") {
            node[idKey] = node.$id;
            delete node.$id;
          }

          if (parentIdKey !== "$pid") {
            node[parentIdKey] = node.$pid;
            delete node.$pid;
          }

          if (childrenKey !== "$children") {
            node[childrenKey] = node.$children;
            delete node.$children;
          }

          for (var _i3 = 0, _Object$keys2 = Object.keys(node); _i3 < _Object$keys2.length; _i3++) {
            var key = _Object$keys2[_i3];

            if (key[0] === "$" && !ignore[key]) {
              delete node[key];
            }
          }
        }

        if (_returnFlat) {
          return nodes;
        } else {
          return isArray(data) ? data : [data];
        }
      },
      outputFlatData: function outputFlatData(parent) {
        var ignoreKeys = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
        return this.outputNestedData(parent, ignoreKeys, true);
      },
      isNodeParentFolded: function isNodeParentFolded(node) {
        var parent = this.getParent(node);
        return Boolean(parent && (parent.$folded || this.isNodeParentFolded(parent)));
      },
      isNodeVisible: function isNodeVisible(node) {
        return !node.$hidden && !this.isNodeParentFolded(node);
      },
      foldAll: function foldAll() {
        var _iterator4 = _createForOfIteratorHelper$2(this.nodes),
            _step4;

        try {
          for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
            var node = _step4.value;
            node.$folded = true;
            this.$emit("fold", node);
          }
        } catch (err) {
          _iterator4.e(err);
        } finally {
          _iterator4.f();
        }
      },
      loadChildren: function loadChildren(node) {
        var _this5 = this;

        if (!node.$childrenLoadStaus || node.$childrenLoadStaus.status === "error") {
          node.$childrenLoading = true;
          var promise = Promise.resolve(this.childrenLoader(node, this)).then(function (children) {
            var _this5$nodes;

            var _iterator5 = _createForOfIteratorHelper$2(children),
                _step5;

            try {
              for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
                var child = _step5.value;
                child.$pid = node.$id;
                child.$level = node.$level + 1;
                child.$folded = true;
              }
            } catch (err) {
              _iterator5.e(err);
            } finally {
              _iterator5.f();
            }

            _this5.initNodes(children);

            node.$children = children;

            (_this5$nodes = _this5.nodes).splice.apply(_this5$nodes, [_this5.nodes.indexOf(node) + 1, 0].concat(_toConsumableArray(children)));

            node.$childrenLoadStaus = {
              status: "success"
            };
            node.$childrenLoading = false;

            _this5.$emit("load-children-success", node);
          }, function (error) {
            node.$children = [];
            node.$childrenLoadStaus = {
              status: "error",
              error: error
            };
            node.$childrenLoading = false;

            _this5.$emit("load-children-error", node);

            console.warn("Failed to load children of node", node, error);
            throw error;
          });
          node.$childrenLoadStaus = {
            status: "loading",
            promise: promise
          };
          this.$emit("load-children", node);
          return promise;
        } else if (node.$childrenLoadStaus.status === "loading") {
          return node.$childrenLoadStaus.promise;
        } else {
          return Promise.resolve();
        }
      },
      loadAllChildren: function loadAllChildren(node) {
        var _this6 = this;

        return new Promise( /*#__PURE__*/function () {
          var _ref2 = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee(resolve, reject) {
            var promises, nodes, failed, _iterator6, _step6, _node, newnNodes, _iterator7, _step7, _node2;

            return regenerator.wrap(function _callee$(_context) {
              while (1) {
                switch (_context.prev = _context.next) {
                  case 0:
                    promises = [];
                    nodes = node ? [node] : _this6.nodes;
                    failed = false;

                  case 3:
                    _iterator6 = _createForOfIteratorHelper$2(nodes);

                    try {
                      for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
                        _node = _step6.value;
                        promises.push(_this6.loadChildren(_node).then(function () {}, function () {}));
                      }
                    } catch (err) {
                      _iterator6.e(err);
                    } finally {
                      _iterator6.f();
                    }

                    _context.next = 7;
                    return Promise.all(promises).then(function () {}, function () {
                      failed = true;
                    });

                  case 7:
                    newnNodes = [];
                    _iterator7 = _createForOfIteratorHelper$2(nodes);

                    try {
                      for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
                        _node2 = _step7.value;

                        if (!_node2.$children) {
                          console.log(_node2);
                        }

                        newnNodes.push.apply(newnNodes, _toConsumableArray(_node2.$children));
                      }
                    } catch (err) {
                      _iterator7.e(err);
                    } finally {
                      _iterator7.f();
                    }

                    nodes = newnNodes;
                    promises = [];

                  case 12:
                    if (nodes.length > 0) {
                      _context.next = 3;
                      break;
                    }

                  case 13:
                    if (failed) {
                      reject(new Error("Failed to load all children"));
                    } else {
                      resolve(undefined);
                    }

                  case 14:
                  case "end":
                    return _context.stop();
                }
              }
            }, _callee);
          }));

          return function (_x, _x2) {
            return _ref2.apply(this, arguments);
          };
        }());
      },
      unfoldAll: function unfoldAll(node) {
        var _this7 = this;

        var doAction = function doAction() {
          walkTreeData(node || _this7.nodes, function (node) {
            node.$folded = false;

            _this7.$emit("unfold", node);
          }, "$children");
        };

        if (this.childrenLazyLoading) {
          return this.loadAllChildren(node).then(function () {
            doAction();
          }, function (error) {
            doAction();
            throw error;
          });
        } else {
          doAction();
        }
      },
      unfold: function unfold(node) {
        var _this8 = this;

        if (this.childrenLazyLoading) {
          return this.loadChildren(node).then(function () {
            node.$folded = false;

            _this8.$emit("unfold", node);
          });
        } else {
          node.$folded = false;
          this.$emit("unfold", node);
        }
      },
      toggleFold: function toggleFold(node) {
        if (node.$folded) {
          return this.unfold(node);
        } else {
          node.$folded = true;
          this.$emit("fold", node);
        }
      },
      updateChecked: function updateChecked(node) {
        var _this9 = this;

        var checkParent = function checkParent(node) {
          var parent = _this9.getParent(node);

          if (parent) {
            var hasChecked;
            var hasUnchecked;

            var _iterator8 = _createForOfIteratorHelper$2(parent.$children),
                _step8;

            try {
              for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
                var child = _step8.value;

                if (child.$checked) {
                  hasChecked = true;
                } else {
                  hasUnchecked = true;

                  if (hasChecked) {
                    break;
                  }
                }
              }
            } catch (err) {
              _iterator8.e(err);
            } finally {
              _iterator8.f();
            }

            parent.$checked = !hasUnchecked ? true : hasChecked ? 0 : false;
            checkParent(parent);
          }
        };

        checkParent(node);
        walkTreeData(node, function (childNode) {
          if (childNode.$checked !== node.$checked) {
            childNode.$checked = node.$checked;
          }
        }, "$children");
      },
      getAllCheckedNodes: function getAllCheckedNodes() {
        return this.nodes.filter(function (node) {
          return node.$checked;
        });
      }
    },
    mounted: function mounted() {
      this.treeID = "hetree_" + randString();
      this.trees[this.treeID] = this;
    },
    beforeUnmount: function beforeUnmount() {
      delete trees[this.treeID];
    }
  });

  var _hoisted_1 = ["data-vindex", "data-v-render-index", "data-id"];
  function render(_ctx, _cache, $props, $setup, $data, $options) {
    var _component_VirtualizationList = vue.resolveComponent("VirtualizationList");

    return vue.openBlock(), vue.createBlock(_component_VirtualizationList, {
      class: vue.normalizeClass(["he-tree", {
        'he-tree-rtl': _ctx.rtl,
        'he-tree-dragging': _ctx.dragging
      }]),
      id: _ctx.treeID,
      ref: "virtualizationList",
      items: _ctx.visibleNodes,
      enabled: _ctx.virtualization,
      prerender: _ctx.virtualizationPrerender,
      gap: _ctx.gap,
      afterCalcTop2: _ctx.virtualizationListAfterCalcTop2,
      isForceVisible: _ctx.isNodeForceVisibleInVL
    }, {
      default: vue.withCtx(function (info) {
        return [vue.createElementVNode("div", {
          class: vue.normalizeClass(["tree-node-outer vl-item", info.item.$outerClass]),
          "data-vindex": info.index,
          "data-v-render-index": info.renderIndex,
          "data-id": info.item.$id,
          style: vue.normalizeStyle([info.itemStyle, _ctx.nodeIndentStyle(info.item), info.item.$outerStyle, {
            display: info.item === _ctx.draggingNode && (!_ctx.store || !_ctx.store.isCloned) ? 'none' : ''
          }])
        }, [vue.createElementVNode("div", {
          class: vue.normalizeClass(["tree-node", info.item.$nodeClass]),
          style: vue.normalizeStyle(info.item.$nodeStyle)
        }, [vue.renderSlot(_ctx.$slots, "default", {
          node: info.item,
          tree: _ctx.tree
        }, function () {
          return [vue.createTextVNode(vue.toDisplayString(info.item[_ctx.textKey]), 1
          /* TEXT */
          )];
        })], 6
        /* CLASS, STYLE */
        )], 14
        /* CLASS, STYLE, PROPS */
        , _hoisted_1)];
      }),
      _: 3
      /* FORWARDED */

    }, 8
    /* PROPS */
    , ["id", "items", "enabled", "prerender", "gap", "afterCalcTop2", "isForceVisible", "class"]);
  }

  script$1.render = render;
  script$1.__file = "src/BaseTree.vue";

  /*!
   * drag-event-service v1.1.10
   * (c) phphe <phphe@outlook.com> (https://github.com/phphe)
   * Homepage: null
   * Released under the MIT License.
   */
  var events = {
    start: ['mousedown', 'touchstart'],
    move: ['mousemove', 'touchmove'],
    end: ['mouseup', 'touchend']
  };
  var DragEventService = {
    isTouch: function isTouch(e) {
      return e.type && e.type.startsWith('touch');
    },
    _getStore: function _getStore(el) {
      if (!el._wrapperStore) {
        el._wrapperStore = [];
      }

      return el._wrapperStore;
    },
    on: function on(el, name, handler, options) {
      var _hp$onDOM, _hp$onDOM2;

      var _resolveOptions = resolveOptions(options),
          args = _resolveOptions.args,
          mouseArgs = _resolveOptions.mouseArgs,
          touchArgs = _resolveOptions.touchArgs;

      var store = this._getStore(el);

      var ts = this;

      var wrapper = function wrapper(e) {
        var mouse;
        var isTouch = ts.isTouch(e);

        if (isTouch) {
          // touch
          mouse = {
            x: e.changedTouches[0].pageX,
            y: e.changedTouches[0].pageY,
            pageX: e.changedTouches[0].pageX,
            pageY: e.changedTouches[0].pageY,
            clientX: e.changedTouches[0].clientX,
            clientY: e.changedTouches[0].clientY,
            screenX: e.changedTouches[0].screenX,
            screenY: e.changedTouches[0].screenY
          };
        } else {
          // mouse
          mouse = {
            x: e.pageX,
            y: e.pageY,
            pageX: e.pageX,
            pageY: e.pageY,
            clientX: e.clientX,
            clientY: e.clientY,
            screenX: e.screenX,
            screenY: e.screenY
          };

          if (name === 'start' && e.which !== 1) {
            // not left button mousedown
            return;
          }
        }

        return handler.call(this, e, mouse);
      };

      store.push({
        handler: handler,
        wrapper: wrapper
      }); // follow format will cause big bundle size
      // 以下写法将会使打包工具认为hp是上下文, 导致打包整个hp
      // hp.onDOM(el, events[name][0], wrapper, ...args)

      (_hp$onDOM = onDOM).call.apply(_hp$onDOM, [null, el, events[name][0], wrapper].concat([].concat(_toConsumableArray(args), _toConsumableArray(mouseArgs))));

      (_hp$onDOM2 = onDOM).call.apply(_hp$onDOM2, [null, el, events[name][1], wrapper].concat([].concat(_toConsumableArray(args), _toConsumableArray(touchArgs))));
    },
    off: function off(el, name, handler, options) {
      var _resolveOptions2 = resolveOptions(options),
          args = _resolveOptions2.args,
          mouseArgs = _resolveOptions2.mouseArgs;

      var store = this._getStore(el);

      for (var i = store.length - 1; i >= 0; i--) {
        var _store$i = store[i],
            handler2 = _store$i.handler,
            wrapper = _store$i.wrapper;

        if (handler === handler2) {
          var _hp$offDOM, _hp$offDOM2;

          (_hp$offDOM = offDOM).call.apply(_hp$offDOM, [null, el, events[name][0], wrapper].concat([].concat(_toConsumableArray(args), _toConsumableArray(mouseArgs))));

          (_hp$offDOM2 = offDOM).call.apply(_hp$offDOM2, [null, el, events[name][1], wrapper].concat([].concat(_toConsumableArray(args), _toConsumableArray(mouseArgs))));

          store.splice(i, 1);
        }
      }
    }
  };

  function resolveOptions(options) {
    if (!options) {
      options = {};
    }

    var args = options.args || [];
    var mouseArgs = options.mouseArgs || [];
    var touchArgs = options.touchArgs || [];
    return {
      args: args,
      mouseArgs: mouseArgs,
      touchArgs: touchArgs
    };
  }

  /*!
   * draggable-helper v6.0.5
   * (c) phphe <phphe@outlook.com> (https://github.com/phphe)
   * Homepage: null
   * Released under the MIT License.
   */

  function _createForOfIteratorHelper$1(o, allowArrayLike) {
    var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];

    if (!it) {
      if (Array.isArray(o) || (it = _unsupportedIterableToArray$1(o)) || allowArrayLike && o && typeof o.length === "number") {
        if (it) o = it;
        var i = 0;

        var F = function F() {};

        return {
          s: F,
          n: function n() {
            if (i >= o.length) return {
              done: true
            };
            return {
              done: false,
              value: o[i++]
            };
          },
          e: function e(_e) {
            throw _e;
          },
          f: F
        };
      }

      throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }

    var normalCompletion = true,
        didErr = false,
        err;
    return {
      s: function s() {
        it = it.call(o);
      },
      n: function n() {
        var step = it.next();
        normalCompletion = step.done;
        return step;
      },
      e: function e(_e2) {
        didErr = true;
        err = _e2;
      },
      f: function f() {
        try {
          if (!normalCompletion && it.return != null) it.return();
        } finally {
          if (didErr) throw err;
        }
      }
    };
  }

  function _unsupportedIterableToArray$1(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray$1(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$1(o, minLen);
  }

  function _arrayLikeToArray$1(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) {
      arr2[i] = arr[i];
    }

    return arr2;
  }
  /* Default export, a function.
  ```js
  import draggableHelper from 'draggable-helper'
  draggableHelper(listenerElement, options)
  ```
  Arguments:
    listenerElement: HTMLElement. The element to bind mouse and touch event listener.
    options: Options. Optional.
   */

  /* 默认导出, 一个方法.
  ```js
  import draggableHelper from 'draggable-helper'
  draggableHelper(listenerElement, options)
  ```
  参数:
    listenerElement: HTMLElement. 绑定鼠标和触摸事件监听器的HTML元素.
    options: Options. 可选.
   */


  var _edgeScroll = {
    afterFirstMove: function afterFirstMove(store, opt) {},
    afterMove: function afterMove(store, opt) {},
    afterDrop: function afterDrop(store, opt) {}
  };

  function index(listenerElement) {
    var _this = this;

    var opt = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var store; // set default value of options
    // 设置options的默认值

    objectAssignIfKeyNull(opt, defaultOptions); // define the event listener of mousedown and touchstart
    // 定义mousedown和touchstart事件监听器

    var onMousedownOrTouchStart = function onMousedownOrTouchStart(e, mouse) {
      // execute native event hooks
      if (!DragEventService.isTouch(e)) {
        opt.onmousedown && opt.onmousedown(e);
      } else {
        opt.ontouchstart && opt.ontouchstart(e);
      }

      var target = e.target; // check if triggered by ignore tags
      // 检查是否由忽略的标签名触发

      if (opt.ingoreTags.includes(target.tagName)) {
        return;
      } // check if trigger element and its parent has undraggable class name
      // 检查触发事件的元素和其与element之间的父级是否有不允许拖动的类名


      if (hasClass(target, opt.undraggableClassName)) {
        return;
      }

      var isParentUndraggable = findParent(target, function (el) {
        if (hasClass(el, opt.undraggableClassName)) {
          return true;
        }

        if (el === listenerElement) {
          return 'break';
        }
      });

      if (isParentUndraggable) {
        return;
      } // Initialize store. Store start event, initial position
      // 初始化store. 存储开始事件, 事件触发坐标


      store = JSON.parse(JSON.stringify(initialStore));
      store.startEvent = e;
      store.listenerElement = listenerElement;
      store.directTriggerElement = target;
      store.initialMouse = Object.assign({}, mouse); // get triggerElement

      var triggerElementIsMovedOrClonedElement = false;

      if (opt.getTriggerElement) {
        var el = opt.getTriggerElement(store.directTriggerElement, store);

        if (!el) {
          return;
        }

        store.triggerElement = el;
      } else if (opt.triggerClassName) {
        var triggerElement;

        var _iterator = _createForOfIteratorHelper$1(toArrayIfNot(opt.triggerClassName)),
            _step;

        try {
          var _loop = function _loop() {
            var className = _step.value;
            triggerElement = findParent(store.directTriggerElement, function (el) {
              if (hasClass(el, className)) {
                return true;
              }

              if (el === listenerElement) {
                return 'break';
              }
            }, {
              withSelf: true
            });

            if (triggerElement) {
              return "break";
            }
          };

          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var _ret = _loop();

            if (_ret === "break") break;
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }

        if (!triggerElement) {
          return;
        }

        store.triggerElement = triggerElement;
      } else {
        triggerElementIsMovedOrClonedElement = true;
      } // get movedOrClonedElement


      store.movedOrClonedElement = opt.getMovedOrClonedElement ? opt.getMovedOrClonedElement(store.directTriggerElement, store, opt) : listenerElement;

      if (!store.movedOrClonedElement) {
        return;
      }

      if (triggerElementIsMovedOrClonedElement) {
        store.triggerElement = store.movedOrClonedElement;
      } // check if trigger element is same with directTriggerElement when options.triggerBySelf is true
      // options.triggerBySelf为true时, 检查触发事件的元素是否是允许触发的元素


      if (opt.triggerBySelf && store.triggerElement !== store.directTriggerElement) {
        return;
      } // prevent text be selected
      // 阻止文字被选中


      if (!DragEventService.isTouch(e)) {
        // Do not prevent when touch. Or the elements within the node can not trigger click event.
        // 不要在触摸时阻止事件. 否则将导致节点内的元素不触发点击事件.
        if (opt.preventTextSelection) {
          e.preventDefault();
        }
      } // listen mousemove and touchmove
      // 监听mousemove和touchmove


      DragEventService.on(document, 'move', onMousemoveOrTouchMove, {
        touchArgs: [{
          passive: false
        }]
      }); // listen mouseup and touchend
      // 监听mouseup和touchend

      DragEventService.on(window, 'end', onMouseupOrTouchEnd);
    }; // bind mousedown or touchstart event listener
    // 绑定mousedown和touchstart事件监听器


    DragEventService.on(listenerElement, 'start', onMousedownOrTouchStart, {
      touchArgs: [{
        passive: true
      }]
    }); // define the event listener of mousemove and touchmove
    // 定义mousemove和touchmove事件监听器

    var onMousemoveOrTouchMove = function onMousemoveOrTouchMove(e, mouse) {
      // execute native event hooks
      if (!DragEventService.isTouch(e)) {
        opt.onmousemove && opt.onmousemove(e);
      } else {
        opt.ontouchmove && opt.ontouchmove(e);
      } // 


      var _store = store,
          movedOrClonedElement = _store.movedOrClonedElement; // calc move and attach related info to store
      // 计算move并附加相关信息到store

      var move = store.move = {
        x: mouse.clientX - store.initialMouse.clientX,
        y: mouse.clientY - store.initialMouse.clientY
      };
      store.moveEvent = e;
      store.mouse = mouse;

      if (DragEventService.isTouch(e)) {
        // prevent page scroll when touch.
        // 当触摸时阻止屏幕被拖动.
        e.preventDefault();
      } else {
        // prevent text be selected
        // 阻止文字被选中
        if (opt.preventTextSelection) {
          e.preventDefault();
        }
      } // first move
      // 第一次移动


      if (store.movedCount === 0) {
        // check if min displacement exceeded.
        // 检查是否达到最小位移
        if (opt.minDisplacement) {
          var x2 = Math.pow(move.x, 2);
          var y2 = Math.pow(move.y, 2);
          var dtc = Math.pow(x2 + y2, 0.5);

          if (dtc < opt.minDisplacement) {
            return;
          }
        } // resolve elements


        store._isMovingElementCloned = Boolean(opt.clone && (!opt.onClone || opt.onClone(store, opt)));
        var movedElement = store._isMovingElementCloned ? movedOrClonedElement.cloneNode(true) : movedOrClonedElement;

        if (store._isMovingElementCloned) {
          movedElement.setAttribute('id', undefined);
        }

        var initialPosition = getViewportPosition(movedOrClonedElement); // attach elements and initialPosition to store
        // 附加元素和初始位置到store

        store.movedOrClonedElement = movedOrClonedElement;
        store.movedElement = movedElement;
        store.initialPositionRelativeToViewport = initialPosition;
        store.initialPosition = initialPosition; // define the function to update moved element style
        // 定义更新移动元素样式的方法

        var updateMovedElementStyle = function updateMovedElementStyle() {
          if (store._isMovingElementCloned) {
            store.movedOrClonedElement.parentElement.appendChild(movedElement);
          }

          var size = getBoundingClientRect(movedElement);
          var style = {
            width: "".concat(Math.ceil(size.width), "px"),
            height: "".concat(Math.ceil(size.height), "px"),
            zIndex: 9999,
            opacity: 0.8,
            position: 'fixed',
            left: initialPosition.x + 'px',
            top: initialPosition.y + 'px',
            pointerEvents: 'none'
          };
          backupAttr(movedElement, 'style');
          backupAttr(movedElement, 'class');
          backupAttr(document.body, 'style');

          for (var key in style) {
            movedElement.style[key] = style[key];
          }

          addClass(movedElement, opt.draggingClassName);
          document.body.style.cursor = 'grabbing';
          /*
          check if the changed position is expected and correct it. about stacking context.
          当某父元素使用了transform属性时, fixed不再以窗口左上角为坐标. 以下功能是在第一次移动后, 检查元素实际位置和期望位置是否相同, 不同则说明坐标系不是期望的. 则把初始位置减去偏移, 无论任何父元素导致了层叠上下文问题, 都能正确显示.
          */

          var nowPosition = getViewportPosition(movedElement);

          if (nowPosition.x !== initialPosition.x) {
            initialPosition.x = initialPosition.x - (nowPosition.x - initialPosition.x);
            initialPosition.y = initialPosition.y - (nowPosition.y - initialPosition.y);
            movedElement.style.left = initialPosition.x + 'px';
            movedElement.style.top = initialPosition.y + 'px';
          }
        };

        store.updateMovedElementStyle = updateMovedElementStyle; // call hook beforeFirstMove, beforeMove

        if (opt.beforeFirstMove && opt.beforeFirstMove(store, opt) === false) {
          return;
        }

        if (opt.beforeMove && opt.beforeMove(store, opt) === false) {
          return;
        } // try to update moved element style
        // 尝试更新移动元素样式


        if (!opt.updateMovedElementStyleManually) {
          store.updateMovedElementStyle();
        }

        _edgeScroll.afterFirstMove(store, opt);

        opt.afterFirstMove && opt.afterFirstMove(store, opt);
      } // Not the first move
      // 非第一次移动
      else {
        // define the function to update moved element style
        // 定义更新移动元素样式的方法
        var _updateMovedElementStyle = function _updateMovedElementStyle() {
          Object.assign(store.movedElement.style, {
            left: store.initialPosition.x + move.x + 'px',
            top: store.initialPosition.y + move.y + 'px'
          });
        };

        store.updateMovedElementStyle = _updateMovedElementStyle; // call hook beforeMove

        if (opt.beforeMove && opt.beforeMove(store, opt) === false) {
          return;
        } // try to update moved element style
        // 尝试更新移动元素样式


        if (!opt.updateMovedElementStyleManually) {
          store.updateMovedElementStyle();
        }
      }

      _edgeScroll.afterMove(store, opt);

      store.movedCount++;
      opt.afterMove && opt.afterMove(store, opt);
    }; // define the event listener of mouseup and touchend
    // 定义mouseup和touchend事件监听器


    var onMouseupOrTouchEnd = function onMouseupOrTouchEnd(e) {
      return __awaiter(_this, void 0, void 0, /*#__PURE__*/regenerator.mark(function _callee() {
        var _store2, movedElement, updateMovedElementStyle;

        return regenerator.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                // execute native event hooks
                if (!DragEventService.isTouch(e)) {
                  opt.onmousedown && opt.onmousedown(e);
                } else {
                  opt.ontouchend && opt.ontouchend(e);
                } // cancel listening mousemove, touchmove, mouseup, touchend
                // 取消监听事件mousemove, touchmove, mouseup, touchend


                DragEventService.off(document, 'move', onMousemoveOrTouchMove, {
                  touchArgs: [{
                    passive: false
                  }]
                });
                DragEventService.off(window, 'end', onMouseupOrTouchEnd); // 

                if (!(store.movedCount === 0)) {
                  _context.next = 5;
                  break;
                }

                return _context.abrupt("return");

              case 5:
                store.endEvent = e;
                _store2 = store, movedElement = _store2.movedElement; // define the function to update moved element style
                // 定义更新移动元素样式的方法

                updateMovedElementStyle = function updateMovedElementStyle() {
                  restoreAttr(movedElement, 'style');
                  restoreAttr(movedElement, 'class');
                  restoreAttr(document.body, 'style');

                  if (store._isMovingElementCloned) {
                    removeEl(movedElement);
                  }
                };

                store.updateMovedElementStyle = updateMovedElementStyle; // call hook beforeDrop

                _context.t0 = opt.beforeDrop;

                if (!_context.t0) {
                  _context.next = 15;
                  break;
                }

                _context.next = 13;
                return opt.beforeDrop(store, opt);

              case 13:
                _context.t1 = _context.sent;
                _context.t0 = _context.t1 === false;

              case 15:
                if (!_context.t0) {
                  _context.next = 17;
                  break;
                }

                return _context.abrupt("return");

              case 17:
                // try to update moved element style
                // 尝试更新移动元素样式
                if (!opt.updateMovedElementStyleManually) {
                  updateMovedElementStyle();
                }

                _edgeScroll.afterDrop(store, opt);

                _context.t2 = opt.afterDrop;

                if (!_context.t2) {
                  _context.next = 23;
                  break;
                }

                _context.next = 23;
                return opt.afterDrop(store, opt);

              case 23:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));
    }; // define the destroy function
    // 定义销毁/退出的方法


    var destroy = function destroy() {
      DragEventService.off(listenerElement, 'start', onMousedownOrTouchStart, {
        touchArgs: [{
          passive: true
        }]
      });
      DragEventService.off(document, 'move', onMousemoveOrTouchMove, {
        touchArgs: [{
          passive: false
        }]
      });
      DragEventService.off(window, 'end', onMouseupOrTouchEnd);
    }; // 


    return {
      destroy: destroy,
      options: opt
    };
  } // available options and default options value
  // 可用选项和默认选项值


  var defaultOptions = {
    ingoreTags: ['INPUT', 'TEXTAREA', 'SELECT', 'OPTGROUP', 'OPTION'],
    undraggableClassName: 'undraggable',
    minDisplacement: 10,
    draggingClassName: 'dragging',
    clone: false,
    updateMovedElementStyleManually: false,
    preventTextSelection: true,
    edgeScrollTriggerMargin: 50,
    edgeScrollSpeed: 0.35,
    edgeScrollTriggerMode: 'top_left_corner'
  }; // Info after event triggered. Created when mousedown or touchstart, destroied after mouseup or touchend.
  // 事件触发后的相关信息. mousedown或touchstart时创建, mouseup或touchend后销毁.

  var initialStore = {
    movedCount: 0
  }; // edge scroll
  // 边缘滚动

  var stopHorizontalScroll, stopVerticalScroll;

  _edgeScroll.afterMove = function (store, opt) {
    if (!opt.edgeScroll) {
      return;
    }

    var margin = opt.edgeScrollTriggerMargin;
    stopOldScrollAnimation(); // get triggerPoint. The point trigger edge scroll.

    var triggerPoint = {
      x: store.mouse.clientX,
      y: store.mouse.clientY
    };

    if (opt.edgeScrollTriggerMode === 'top_left_corner') {
      var vp = getViewportPosition(store.movedElement);
      triggerPoint = {
        x: vp.x,
        y: vp.y
      };
    } // 


    var foundHorizontal, foundVertical, prevElement, horizontalDir, verticalDir;
    var findInElements;
    var cachedElementsFromPoint; // find x container

    var minScrollableDisplacement = 10;

    if (opt.edgeScrollSpecifiedContainerX) {
      var containerX;

      if (typeof opt.edgeScrollSpecifiedContainerX === 'function') {
        containerX = opt.edgeScrollSpecifiedContainerX(store, opt);
      } else {
        containerX = opt.edgeScrollSpecifiedContainerX;
      }

      if (containerX) {
        findInElements = [containerX];
      }
    }

    if (!findInElements) {
      findInElements = elementsFromPoint(triggerPoint.x, triggerPoint.y);
      cachedElementsFromPoint = findInElements;
    }

    var _iterator2 = _createForOfIteratorHelper$1(findInElements),
        _step2;

    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var itemEl = _step2.value;

        if (prevElement && !isDescendantOf(prevElement, itemEl)) {
          // itemEl is being covered by other elements
          // itemEl被其他元素遮挡
          continue;
        }

        var t = minScrollableDisplacement; // min scrollable displacement. 最小可滚动距离, 小于此距离不触发滚动.

        if (!foundHorizontal) {
          if (itemEl.scrollWidth > itemEl.clientWidth) {
            var _vp = fixedGetViewportPosition(itemEl);

            if (triggerPoint.x <= _vp.left + margin) {
              if (scrollableDisplacement(itemEl, 'left') > t && isScrollable(itemEl, 'x')) {
                foundHorizontal = itemEl;
                horizontalDir = 'left';
              }
            } else if (triggerPoint.x >= _vp.left + itemEl.clientWidth - margin) {
              if (scrollableDisplacement(itemEl, 'right') > t && isScrollable(itemEl, 'x')) {
                foundHorizontal = itemEl;
                horizontalDir = 'right';
              }
            }
          }
        }

        if (foundHorizontal) {
          break;
        }

        prevElement = itemEl;
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }

    prevElement = null; // find y container

    findInElements = null;

    if (opt.edgeScrollSpecifiedContainerY) {
      var containerY;

      if (typeof opt.edgeScrollSpecifiedContainerY === 'function') {
        containerY = opt.edgeScrollSpecifiedContainerY(store, opt);
      } else {
        containerY = opt.edgeScrollSpecifiedContainerY;
      }

      if (containerY) {
        findInElements = [containerY];
      }
    }

    if (!findInElements) {
      findInElements = cachedElementsFromPoint || elementsFromPoint(triggerPoint.x, triggerPoint.y);
    }

    var _iterator3 = _createForOfIteratorHelper$1(findInElements),
        _step3;

    try {
      for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
        var _itemEl = _step3.value;

        if (prevElement && !isDescendantOf(prevElement, _itemEl)) {
          // itemEl is being covered by other elements
          // itemEl被其他元素遮挡
          continue;
        }

        var _t = minScrollableDisplacement; // min scrollable displacement. 最小可滚动距离, 小于此距离不触发滚动.

        if (!foundVertical) {
          if (_itemEl.scrollHeight > _itemEl.clientHeight) {
            var _vp2 = fixedGetViewportPosition(_itemEl);

            if (triggerPoint.y <= _vp2.top + margin) {
              if (scrollableDisplacement(_itemEl, 'up') > _t && isScrollable(_itemEl, 'y')) {
                foundVertical = _itemEl;
                verticalDir = 'up';
              }
            } else if (triggerPoint.y >= _vp2.top + _itemEl.clientHeight - margin) {
              if (scrollableDisplacement(_itemEl, 'down') > _t && isScrollable(_itemEl, 'y')) {
                foundVertical = _itemEl;
                verticalDir = 'down';
              }
            }
          }
        }

        if (foundVertical) {
          break;
        }

        prevElement = _itemEl;
      } // scroll

    } catch (err) {
      _iterator3.e(err);
    } finally {
      _iterator3.f();
    }

    if (foundHorizontal) {
      if (horizontalDir === 'left') {
        stopHorizontalScroll = scrollTo({
          x: 0,
          element: foundHorizontal,
          duration: scrollableDisplacement(foundHorizontal, 'left') / opt.edgeScrollSpeed
        });
      } else {
        stopHorizontalScroll = scrollTo({
          x: foundHorizontal.scrollWidth - foundHorizontal.clientWidth,
          element: foundHorizontal,
          duration: scrollableDisplacement(foundHorizontal, 'right') / opt.edgeScrollSpeed
        });
      }
    }

    if (foundVertical) {
      if (verticalDir === 'up') {
        stopVerticalScroll = scrollTo({
          y: 0,
          element: foundVertical,
          duration: scrollableDisplacement(foundVertical, 'up') / opt.edgeScrollSpeed
        });
      } else {
        stopVerticalScroll = scrollTo({
          y: foundVertical.scrollHeight - foundVertical.clientHeight,
          element: foundVertical,
          duration: scrollableDisplacement(foundVertical, 'down') / opt.edgeScrollSpeed
        });
      }
    } // is element scrollable in a direction
    // 元素某方向是否可滚动


    function isScrollable(el, dir) {
      var style = getComputedStyle(el);
      var key = "overflow-".concat(dir); // document.documentElement is special

      var special = document.scrollingElement || document.documentElement;

      if (el === special) {
        return style[key] === 'visible' || style[key] === 'auto' || style[key] === 'scroll';
      }

      return style[key] === 'auto' || style[key] === 'scroll';
    } // scrollable displacement of element  in a direction
    // 元素某方向可滚动距离


    function scrollableDisplacement(el, dir) {
      if (dir === 'up') {
        return el.scrollTop;
      } else if (dir === 'down') {
        return el.scrollHeight - el.scrollTop - el.clientHeight;
      } else if (dir === 'left') {
        return el.scrollLeft;
      } else if (dir === 'right') {
        return el.scrollWidth - el.scrollLeft - el.clientWidth;
      }
    }

    function fixedGetViewportPosition(el) {
      var r = getViewportPosition(el); // document.documentElement is special

      var special = document.scrollingElement || document.documentElement;

      if (el === special) {
        r.top = 0;
        r.left = 0;
      }

      return r;
    }
  };

  _edgeScroll.afterDrop = function (store, opt) {
    if (!opt.edgeScroll) {
      return;
    }

    stopOldScrollAnimation();
  }; // stop old scroll animation
  // 结束之前的滚动动画


  function stopOldScrollAnimation() {
    if (stopHorizontalScroll) {
      stopHorizontalScroll();
      stopHorizontalScroll = null;
    }

    if (stopVerticalScroll) {
      stopVerticalScroll();
      stopVerticalScroll = null;
    }
  }

  function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

  function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

  function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }
  function makeTreeListDraggable(treeEl, options, hooks) {
    var defaultOptions = {
      updateMovedElementStyleManually: true,
      getMovedOrClonedElement: function getMovedOrClonedElement(directTriggerElement, store) {
        // find closest node from parents
        var el = findParent(store.triggerElement, function (el) {
          return hasClass(el, options.nodeOuterClass);
        }, {
          withSelf: true
        });
        return el;
      },
      // @ts-ignore
      beforeFirstMove: function beforeFirstMove(store, options) {
        store.startTreeEl = treeEl;

        if (hooks.beforeFirstMove && hooks.beforeFirstMove(store, options) === false) {
          return false;
        }
      },
      // it means onMove
      // @ts-ignore
      beforeMove: function beforeMove(store) {
        var _hooks$afterTargetTre2, _prevNodeAndIndex;

        // first move
        // 第一次移动
        if (store.movedCount === 0) {
          var _hooks$afterTargetTre, _hooks$afterFirstMove;

          // create placeholder
          // 创建占位元素
          var placeholder = hooks.createPlaceholder();
          store.placeholder = placeholder;
          store.targetTreeEl = store.startTreeEl;
          (_hooks$afterTargetTre = hooks.afterTargetTreeElUpdated) === null || _hooks$afterTargetTre === void 0 ? void 0 : _hooks$afterTargetTre.call(hooks, store);
          hooks.insertedPlaceholderAfterCreated(store);
          hooks.setPlaceholderLevel(store.placeholder, hooks.getNodeLevelByEl(store.movedOrClonedElement));
          store.updateMovedElementStyle();
          (_hooks$afterFirstMove = hooks.afterFirstMove) === null || _hooks$afterFirstMove === void 0 ? void 0 : _hooks$afterFirstMove.call(hooks, store, options); // skip first move
          // 跳过第一次移动

          hooks.moveEnd("first_move");
          return;
        } //


        store.updateMovedElementStyle(); //

        var movingEl = store.movedElement; // node
        // find closest node and hovering tree

        var tree;
        var movingNode = movingEl; // movingNodeOf and movingNodeRect are not always real. when RTL, there 'x' is top right. when draggingNodePositionMode is mouse, there x and y are mouse position. So don't calc them with their width or height.
        // movingNodeOf 和 movingNodeRect并非一直如字面意义是movingNode真实坐标. RTL时, x坐标是右上角. draggingNodePositionMode是mouse时, x和y是鼠标坐标.

        var movingNodeRealEl = movingNode.querySelector(".".concat(options.nodeClass)); // movingNode is node outer

        var movingNodeOf = getOffset(movingNodeRealEl);
        var movingNodeRect = getBoundingClientRect(movingNodeRealEl);

        if (options.draggingNodePositionMode === "mouse") {
          // use mouse position as dragging node position
          var moveEvent = store.moveEvent; // @ts-ignore

          movingNodeOf = {
            x: moveEvent.pageX,
            y: moveEvent.pageY
          }; // @ts-ignore

          movingNodeRect = {
            x: moveEvent.clientX,
            y: moveEvent.clientY
          };
        } else if (options.rtl) {
          movingNodeOf.x += movingNode.offsetWidth;
          movingNodeRect.x += movingNode.offsetWidth;
        } // find tree with elementsFromPoint


        var found;
        var firstElement;

        var _iterator = _createForOfIteratorHelper(elementsFromPoint(movingNodeRect.x, movingNodeRect.y)),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var itemEl = _step.value;

            if (!firstElement) {
              firstElement = itemEl;
            }

            if (hasClass(itemEl, options.treeClass)) {
              found = itemEl;
              break;
            }
          } // check if the found element is covered by other elements

        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }

        if (firstElement !== found && !isDescendantOf(firstElement, found)) {
          found = null;
        }

        tree = found;

        if (!tree) {
          // out of tree or tree is covered by other elements
          hooks.moveEnd("no_target_tree");
          return;
        } // check if target tree right


        if (hooks.filterTargetTreeEl && hooks.filterTargetTreeEl(tree, store) === false) {
          hooks.moveEnd("disallowed_tree");
          return;
        }

        store.targetTreeEl = tree;
        (_hooks$afterTargetTre2 = hooks.afterTargetTreeElUpdated) === null || _hooks$afterTargetTre2 === void 0 ? void 0 : _hooks$afterTargetTre2.call(hooks, store);
        var indent = hooks.getTreeIndent(store.targetTreeEl, store); //

        var DecisionInfo = /*#__PURE__*/function () {
          function DecisionInfo() {
            _classCallCheck(this, DecisionInfo);

            _defineProperty(this, "_visibleNodesElements", void 0);

            _defineProperty(this, "_closestNodeElAndIndex", void 0);

            _defineProperty(this, "_prevNodeAndIndex", void 0);

            _defineProperty(this, "_prevNodeOffset", void 0);

            _defineProperty(this, "_prevNodeLevel", void 0);

            _defineProperty(this, "_nextNodeAndIndex", void 0);
          }

          _createClass(DecisionInfo, [{
            key: "visibleNodesElementsExcludeDragging",
            get: function get() {
              if (!this._visibleNodesElements) {
                this._visibleNodesElements = store.targetTreeEl.querySelectorAll(".".concat(options.nodeClass, ":not(.").concat(options.draggingClassName, " > .").concat(options.nodeClass, ")"));
              }

              var r = [];

              this._visibleNodesElements.forEach(function (node) {
                // @ts-ignore
                if (node.parentElement.style.display !== "none") {
                  // node-outer visible
                  r.push(node);
                }
              });

              return r;
            } // index is for visibleNodesElementsExcludeDragging

          }, {
            key: "closestNodeElAndIndex",
            get: function get() {
              if (this._closestNodeElAndIndex === undefined) {
                var nodes = this.visibleNodesElementsExcludeDragging; //

                if (nodes.length === 0) {
                  this._closestNodeElAndIndex = null;
                } else {
                  var _found, index;

                  var t = binarySearch(nodes, function (node) {
                    return getOffset(node).y - movingNodeOf.y;
                  }, {
                    returnNearestIfNoHit: true
                  });

                  if (t.hit) {
                    _found = t.value;
                    index = t.index;
                  } else {
                    if (t.greater) {
                      index = t.index - 1;
                      _found = nodes[index] || t.value;
                    } else {
                      index = t.index;
                      _found = t.value;
                    }
                  }

                  this._closestNodeElAndIndex = {
                    el: _found,
                    index: index
                  };
                }
              }

              return this._closestNodeElAndIndex;
            } // prev node is closest node when closest node is not placeholder, or is prev node of closest node when it is placeholder
            // closest node不是placeholder时, prev node是closest node, 否则是closest node上方的node

          }, {
            key: "prevNodeAndIndex",
            get: function get() {
              if (this._prevNodeAndIndex === undefined) {
                var el, index;

                if (this.closestNodeElAndIndex) {
                  index = this.closestNodeElAndIndex.index; // can't reduce 1; 不能减1

                  el = this.visibleNodesElementsExcludeDragging[index];

                  if (el && hasClass(el, options.placeholderClass)) {
                    index--;
                    el = this.visibleNodesElementsExcludeDragging[index];
                  }

                  if (el) {
                    this._prevNodeAndIndex = {
                      el: el,
                      index: index
                    };
                  } else {
                    this._prevNodeAndIndex = null;
                  }
                } else {
                  this._prevNodeAndIndex = null;
                }
              }

              return this._prevNodeAndIndex;
            }
          }, {
            key: "prevtNodeOffset",
            get: function get() {
              if (this._prevNodeOffset === undefined) {
                this._prevNodeOffset = this.prevNodeAndIndex ? getOffset(this.prevNodeAndIndex.el) : null;
              }

              return this._prevNodeOffset;
            }
          }, {
            key: "prevNodeLevel",
            get: function get() {
              if (this._prevNodeLevel === undefined) {
                this._prevNodeLevel = this.prevNodeAndIndex ? hooks.getNodeLevelByEl(this.prevNodeAndIndex.el) : null;
              }

              return this._prevNodeLevel;
            }
          }, {
            key: "nextNodeAndIndex",
            get: function get() {
              if (this._nextNodeAndIndex === undefined) {
                var el, index;

                if (this.closestNodeElAndIndex) {
                  index = this.closestNodeElAndIndex.index + 1;
                  el = this.visibleNodesElementsExcludeDragging[index];

                  if (el && hasClass(el, options.placeholderClass)) {
                    index++;
                    el = this.visibleNodesElementsExcludeDragging[index];
                  }

                  if (el) {
                    this._nextNodeAndIndex = {
                      el: el,
                      index: index
                    };
                  } else {
                    this._nextNodeAndIndex = null;
                  }
                } else {
                  this._nextNodeAndIndex = null;
                }
              }

              return this._nextNodeAndIndex;
            }
          }]);

          return DecisionInfo;
        }();

        var info = new DecisionInfo();

        var onMiddleOfPrevNode = function onMiddleOfPrevNode() {
          return movingNodeOf.y < info.prevtNodeOffset.y + info.prevNodeAndIndex.el.offsetHeight / 2;
        }; // Positive number mean moving node at left of prev node


        var prevNodeLeftXReduceMovingNodeX = function prevNodeLeftXReduceMovingNodeX() {
          return !options.rtl ? info.prevtNodeOffset.x - movingNodeOf.x : movingNodeOf.x - (info.prevtNodeOffset.x + info.prevNodeAndIndex.el.offsetWidth);
        };

        var atRightOfPrevNodeIndent = function atRightOfPrevNodeIndent() {
          return !options.rtl ? movingNodeOf.x > info.prevtNodeOffset.x + indent : movingNodeOf.x < info.prevtNodeOffset.x + info.prevNodeAndIndex.el.offsetWidth - indent;
        }; //


        var targetLevel;
        var nextNodeLevel = info.nextNodeAndIndex ? hooks.getNodeLevelByEl(info.nextNodeAndIndex.el) : 1; // targetLevel max is nextNodeLevel

        var prevNodeAndIndex = info.prevNodeAndIndex;

        if (!prevNodeAndIndex || prevNodeAndIndex.index === 0 && onMiddleOfPrevNode()) {
          targetLevel = 1;
          prevNodeAndIndex = null;
          nextNodeLevel = 1;
        } else {
          var atLeft = prevNodeLeftXReduceMovingNodeX();

          if (atLeft > 0) {
            targetLevel = info.prevNodeLevel - Math.ceil(atLeft / indent);
          } else if (atRightOfPrevNodeIndent()) {
            targetLevel = info.prevNodeLevel + 1;
          } else {
            targetLevel = info.prevNodeLevel;
          }
        }

        if (targetLevel < nextNodeLevel) {
          targetLevel = nextNodeLevel;
        }

        hooks.movePlaceholder(store, (_prevNodeAndIndex = prevNodeAndIndex) === null || _prevNodeAndIndex === void 0 ? void 0 : _prevNodeAndIndex.el, targetLevel);
      },
      // @ts-ignore
      beforeDrop: function beforeDrop(store) {
        store.endEvent;
        store.movedElement;
        var placeholder = store.placeholder;
            store.movedCount;
            store.targetTreeEl;
            store.startTreeEl; // destroy placeholder

        var restoreStyle = function restoreStyle() {
          removeEl(placeholder);
          store.updateMovedElementStyle();
        }; //


        return hooks.onDrop(store, restoreStyle);
      }
    };
    Object.keys(defaultOptions).forEach(function (key) {
      // @ts-ignore
      if (options[key] === undefined) {
        // @ts-ignore
        options[key] = defaultOptions[key];
      }
    });

    var _draggableHelper = index(treeEl, options),
        destroy = _draggableHelper.destroy,
        draggableHelperOptions = _draggableHelper.options;

    return {
      destroy: destroy,
      options: draggableHelperOptions,
      hooks: hooks
    };
  }

  var placeholderID = "hetree_drag_placeholder";
  var script = vue.defineComponent({
    extends: script$1,
    props: {
      triggerClass: {
        type: String,
        default: "tree-node"
      },
      triggerBySelf: Boolean,
      draggable: {
        type: Boolean,
        default: true
      },
      droppable: {
        type: Boolean,
        default: true
      },
      eachDraggable: {
        type: [Boolean, Function],
        default: undefined
      },
      eachDroppable: {
        type: [Boolean, Function],
        default: undefined
      },
      rootDraggable: {
        type: Boolean,
        default: true
      },
      rootDroppable: {
        type: Boolean,
        default: true
      },
      ondragstart: {
        type: Function
      },
      ondragend: {
        type: Function
      },
      afterPlaceholderCreated: {
        type: Function
      },
      placeholderMaxHeight: {
        type: Number,
        default: 100
      },
      unfoldWhenDragover: {
        type: Boolean,
        default: true
      },
      unfoldWhenDragoverDelay: {
        type: Number,
        default: 80
      },
      isNodeUnfoldable: {
        type: Function
      },
      draggingNodePositionMode: {
        type: String,
        default: "top_left_corner"
      },
      preventTextSelection: {
        type: Boolean,
        default: true
      },
      edgeScroll: {
        type: Boolean
      },
      edgeScrollTriggerMargin: {
        type: Number,
        default: 50
      },
      edgeScrollSpeed: {
        type: Number,
        default: 0.35
      },
      edgeScrollTriggerMode: {
        type: String,
        default: "top_left_corner"
      },
      edgeScrollSpecifiedContainerX: {
        type: [Object, Function]
      },
      edgeScrollSpecifiedContainerY: {
        type: [Object, Function]
      } // type: HTMLElement | ((store: Store3) => HTMLElement)

    },
    data: function data() {
      var _this = this;

      return {
        draggingNode: null,
        store: null,
        virtualizationListAfterCalcTop2: function virtualizationListAfterCalcTop2(top2) {
          if (_this.dragging) {
            var placeholder = _this.$el.querySelector("#".concat(placeholderID));

            if (placeholder) {
              top2 += getBoundingClientRect(placeholder).height + (_this.gap || 0);
            }
          }

          return top2;
        }
      };
    },
    methods: {
      isParentDragging: function isParentDragging(node) {
        var nodesByID = this.nodesByID,
            draggingNode = this.draggingNode;
        var parent = node.$pid && nodesByID[node.$pid];
        return Boolean(draggingNode && parent && (parent === draggingNode || this.isParentDragging(parent)));
      },
      isNodeVisible: function isNodeVisible(node) {
        if (this.draggingNode === node) {
          // keep event trigger, because touch event need it before event end
          return true;
        }

        if (this.draggingNode && this.store.isCloned && (node === this.draggingNode || this.isParentDragging(node))) {
          return true;
        }

        return !node.$hidden && !this.isNodeParentFolded(node) && (!this.draggingNode || node !== this.draggingNode && !this.isParentDragging(node));
      }
    },
    // hooks
    mounted: function mounted() {
      var _this2 = this;

      var options = {
        treeClass: "he-tree",
        nodeClass: "tree-node",
        nodeOuterClass: "tree-node-outer",
        draggingClassName: "dragging",
        placeholderClass: "tree-placeholder",
        clone: true,
        onClone: function onClone(store, options) {
          store.isCloned = false; // @ts-ignore

          if (_this2.cloneWhenDrag) {
            // @ts-ignore
            store.isCloned = store.isCloned ? _this2.onClone(store) : true;
          }

          return true;
        }
      };

      var syncOption = function syncOption(name, nameInOption) {
        if (!nameInOption) {
          nameInOption = name;
        } // @ts-ignore


        options[nameInOption] = _this2[name];

        _this2.$watch(name, function () {
          // @ts-ignore
          options[nameInOption] = _this2[name];
        });
      };

      syncOption("triggerClass", "triggerClassName");
      syncOption("triggerBySelf");
      syncOption("unfoldWhenDragover");
      syncOption("unfoldWhenDragoverDelay");
      syncOption("draggingNodePositionMode");
      syncOption("edgeScroll");
      syncOption("edgeScrollTriggerMargin");
      syncOption("edgeScrollSpeed");
      syncOption("edgeScrollTriggerMode");
      syncOption("edgeScrollSpecifiedContainerX");
      syncOption("edgeScrollSpecifiedContainerY");
      syncOption("rtl");
      syncOption("preventTextSelection");

      var isNodeDroppable0 = function isNodeDroppable0(store, node) {
        var vm = store.targetTree || _this2;

        if (!vm.droppable) {
          return false;
        }

        var droppableOpt = node ? node.$droppable !== undefined ? node.$droppable : vm.eachDroppable : vm.rootDroppable !== undefined ? vm.rootDroppable : vm.eachDroppable;
        var droppable = resolveValueOrGettter(droppableOpt, [node, store, options, vm]);

        if (droppable === undefined) {
          var parent = vm.getParent(node);

          if (!parent) {
            return true;
          } else {
            return isNodeDroppable0(store, parent);
          }
        } else {
          return droppable;
        }
      };

      var isNodeUnfoldable = function isNodeUnfoldable(store, node) {
        var vm = store.targetTree || _this2;

        if (!vm.isNodeUnfoldable) {
          return _this2.unfoldWhenDragover;
        } else {
          return vm.isNodeUnfoldable(store);
        }
      };

      var _makeTreeListDraggabl = makeTreeListDraggable(this.$el, // @ts-ignore
      options, {
        beforeFirstMove: function beforeFirstMove(store, options) {
          _this2.store = store;
          store.startTree = _this2.getTreeVmByTreeEl(store.startTreeEl);
          var draggable = resolveValueOrGettter(store.startTree.draggable, [store.startTree, store]);

          if (!draggable) {
            return false;
          }

          var startTree = store.startTree;
          store.draggingNode = startTree.getNodeByEl(store.movedOrClonedElement);

          var parent = _this2.getParent(store.draggingNode);

          var index = _this2.getChildren(parent).indexOf(store.draggingNode);

          store.startPath = {
            tree: _this2,
            parent: parent,
            index: index
          };

          var isNodeDraggable = function isNodeDraggable(node) {
            if (!_this2.draggable) {
              return false;
            }

            var opt = node.$draggable !== undefined ? node.$draggable : _this2.eachDraggable;
            var draggable = resolveValueOrGettter(opt, [node, store, options, _this2]);

            if (draggable === undefined) {
              var _parent = _this2.getParent(node);

              if (!_parent) {
                return true;
              } else {
                return isNodeDraggable(_parent);
              }
            } else {
              return draggable;
            }
          };

          if (!isNodeDraggable(store.draggingNode)) {
            return false;
          }

          if (store.startTree.rootDraggable === false && store.draggingNode.$level === 1) {
            return false;
          }

          if (_this2.ondragstart && _this2.ondragstart(store) === false) {
            return false;
          }

          for (var _i = 0, _Object$values = Object.values(_this2.trees); _i < _Object$values.length; _i++) {
            var tree = _Object$values[_i];
            tree.dragging = true;
            tree.store = store;
          }

          store.startTree.$emit("before-first-move", store);
          store.startTree.$emit("drag", store);
        },
        afterFirstMove: function afterFirstMove(store) {
          _this2.draggingNode = store.draggingNode;
        },
        getNodeLevelByEl: function getNodeLevelByEl(el) {
          return _this2.store.targetTree.getNodeByEl(el).$level;
        },
        createPlaceholder: function createPlaceholder() {
          return createElementFromHTML("\n          <div id=\"".concat(placeholderID, "\" class=\"tree-placeholder-outer tree-node-outer\" style=\"margin-bottom: ").concat(_this2.gap, "px;\">\n            <div class=\"").concat(options.placeholderClass, " tree-node\">\n            </div>\n          </div>\n        "));
        },
        setPlaceholderLevel: function setPlaceholderLevel(placeholder, level) {
          placeholder.style[!_this2.store.targetTree.rtl ? "paddingLeft" : "paddingRight"] = (level - 1) * _this2.store.targetTree.indent + "px";
          _this2.store.placeholderLevel = level;
        },
        filterTargetTreeEl: function filterTargetTreeEl(el, store) {
          var targetTree = _this2.getTreeVmByTreeEl(el);

          var startTree = store.startTree;

          if (startTree !== targetTree) {
            // @ts-ignore
            if (_this2._internal_hook_filterTargetTree) {
              if ( // @ts-ignore
              _this2._internal_hook_filterTargetTree(targetTree, store) === false) {
                return false;
              }
            } else {
              return false;
            }
          }

          var targetTreeDroppable = resolveValueOrGettter(targetTree.droppable, [targetTree, store]);

          if (!targetTreeDroppable) {
            return false;
          }

          store.targetTree = targetTree;

          if (!resolveValueOrGettter(store.startTree === store.targetTree) && // @ts-ignore
          resolveValueOrGettter(_this2._Draggable_unfoldTargetNode, [false, store]) !== _this2.store) {
            return false;
          }
        },
        afterTargetTreeElUpdated: function afterTargetTreeElUpdated(store) {
          store.targetTree = _this2.getTreeVmByTreeEl(store.targetTreeEl);
        },
        insertedPlaceholderAfterCreated: function insertedPlaceholderAfterCreated(store) {
          var _this2$afterPlacehold;

          // set placeholder height
          var dragNodesCount = 1 + _this2.countChildren(store.draggingNode);

          var nodeHeight = store.movedOrClonedElement.offsetHeight;
          var placeholderHeight = notGreaterThan(dragNodesCount * nodeHeight, _this2.placeholderMaxHeight);
          store.placeholder.querySelector(".tree-node").style.height = placeholderHeight + "px"; //

          //
          (_this2$afterPlacehold = _this2.afterPlaceholderCreated) === null || _this2$afterPlacehold === void 0 ? void 0 : _this2$afterPlacehold.call(_this2, store.placeholder, store);

          if (isNodeDroppable0(store, _this2.getParent(store.draggingNode))) {
            insertAfter(store.placeholder, store.movedOrClonedElement);
            store.placeholderPrevNode = _this2.getNodeByEl(store.movedOrClonedElement);
            var placeholderPrevEl = store.movedOrClonedElement.previousElementSibling;

            if (placeholderPrevEl) {
              if (hasClass(placeholderPrevEl, options.nodeOuterClass)) {
                store.placeholderPrevNodeInTree = _this2.getNodeByEl(placeholderPrevEl);
              }
            }
          }
        },
        getTreeIndent: function getTreeIndent(treeEl, store) {
          var _this2$getTreeVmByTre;

          return (_this2$getTreeVmByTre = _this2.getTreeVmByTreeEl(treeEl)) === null || _this2$getTreeVmByTre === void 0 ? void 0 : _this2$getTreeVmByTre.indent;
        },
        moveEnd: function moveEnd(action) {
          var info = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

          //
          if (_this2.store.targetTreeEl.querySelector("#".concat(placeholderID))) {
            _this2.store.placeholder.style["margin-bottom"] = "".concat(_this2.store.targetTree.gap, "px");
          } //


          //
          if (_this2.unfoldWhenDragoverInfo) {
            if (action !== "prepend" || info.node !== _this2.unfoldWhenDragoverInfo.node) {
              _this2.unfoldWhenDragoverInfo = undefined;
            }
          }
        },
        movePlaceholder: function movePlaceholder(store, el, targetLevel) {
          var isNodeDroppable = function isNodeDroppable(node) {
            return isNodeDroppable0(store, node);
          };

          var setPlaceholderLevel = function setPlaceholderLevel(level) {
            return hooks.setPlaceholderLevel(store.placeholder, level);
          };

          var that = store.targetTree;
          var parent, prevNode, prevNodeInTree; // prev droppable node
          // find parent

          // prev droppable node
          // find parent
          if (el) {
            prevNode = that.getNodeByEl(el);
            prevNodeInTree = prevNode;

            if (targetLevel > prevNode.$level) {
              if (isNodeDroppable(prevNode) && (!prevNode.$folded || isNodeUnfoldable(store))) {
                // prepend or append
                parent = prevNode;
              } else {
                // after
                parent = that.getParent(prevNode);
                targetLevel--;
              }
            } else if (targetLevel === prevNode.$level) {
              parent = that.getParent(prevNode);

              if (!isNodeDroppable(parent) && isNodeDroppable(prevNode) && (!prevNode.$folded || isNodeUnfoldable(store))) {
                // fallback to prepend
                parent = prevNode;
                targetLevel++;
              }
            } else {
              // targetLevel < prevNode.$level
              // found parent which's level equal targetLevel - 1
              parent = prevNode;

              while (parent) {
                if (parent.$level === targetLevel - 1) {
                  break;
                }

                prevNodeInTree = parent;
                parent = that.getParent(parent);
              }
            }
          }

          var getLastChildNode = function getLastChildNode(node) {
            var children = node.$children || [];
            var index = children.length - 1;
            var last = children[index];

            if (!store.isCloned && last === _this2.draggingNode) {
              index--;
              last = children[index];
            }

            return last;
          };

          while (parent && !isNodeDroppable(parent)) {
            targetLevel--;
            prevNodeInTree = parent;
            prevNode = getLastChildNode(parent) || parent;
            parent = that.getParent(parent);
          }

          var parentDroppable = parent ? true : isNodeDroppable(); // isNodeDroppable() get root droppable

          // isNodeDroppable() get root droppable
          var noAction = false;

          if (parentDroppable) {
            if (!prevNode) {
              // prepend to root
              var root = that.$el;
              prependTo(store.placeholder, root);
              setPlaceholderLevel(targetLevel);
              hooks.moveEnd("prepend_to_root");
            } else {
              // prevNode not null, prevNodeInTree not null
              var doInsert = function doInsert() {
                insertAfter(store.placeholder, that.getElByID(prevNode.$id));
                setPlaceholderLevel(targetLevel);
              };

              if (targetLevel === prevNodeInTree.$level + 1) {
                // prepend
                // need to unfold node if node is folded
                if (!prevNodeInTree.$folded) {
                  doInsert();
                  hooks.moveEnd("prepend", {
                    node: prevNodeInTree
                  });
                } else {
                  hooks.moveEnd("prepend", {
                    node: prevNodeInTree
                  });
                  var info = _this2.unfoldWhenDragoverInfo;

                  if (info) ; else {
                    var id = randString();
                    _this2.unfoldWhenDragoverInfo = {
                      node: prevNodeInTree,
                      id: id
                    };

                    var delayAndUnfoldAndDoInsert = /*#__PURE__*/function () {
                      var _ref = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee() {
                        var cancelled;
                        return regenerator.wrap(function _callee$(_context) {
                          while (1) {
                            switch (_context.prev = _context.next) {
                              case 0:
                                _context.next = 2;
                                return waitTime(store.targetTree.unfoldWhenDragoverDelay);

                              case 2:
                                cancelled = function cancelled() {
                                  var _this2$unfoldWhenDrag;

                                  return ((_this2$unfoldWhenDrag = _this2.unfoldWhenDragoverInfo) === null || _this2$unfoldWhenDrag === void 0 ? void 0 : _this2$unfoldWhenDrag.id) !== id;
                                };

                                if (!cancelled()) {
                                  _context.next = 5;
                                  break;
                                }

                                return _context.abrupt("return");

                              case 5:
                                _context.prev = 5;
                                _context.next = 8;
                                return store.targetTree.unfold(prevNodeInTree);

                              case 8:
                                if (!cancelled()) {
                                  _context.next = 10;
                                  break;
                                }

                                return _context.abrupt("return");

                              case 10:
                                doInsert();
                                _context.next = 15;
                                break;

                              case 13:
                                _context.prev = 13;
                                _context.t0 = _context["catch"](5);

                              case 15:
                              case "end":
                                return _context.stop();
                            }
                          }
                        }, _callee, null, [[5, 13]]);
                      }));

                      return function delayAndUnfoldAndDoInsert() {
                        return _ref.apply(this, arguments);
                      };
                    }();

                    delayAndUnfoldAndDoInsert();
                  }
                }
              } else {
                // after
                doInsert();
                hooks.moveEnd("after", {
                  node: prevNodeInTree
                });
              }
            }
          } else {
            // can't drop
            hooks.moveEnd("no_action");
            noAction = true;
          }

          if (!noAction) {
            store.placeholderPrevNode = prevNode;
            store.placeholderPrevNodeInTree = prevNodeInTree;
          }
        },
        onDrop: function () {
          var _onDrop = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee2(store, restoreStyle) {
            var done, dragChanged, that, startTree, targetTree, prevNodeInTree, tree, parent, index, level, _startPath, _targetPath, startPath, targetPath, draggingNode, _that$nodes, _listIndex, toRemove, _i2, _toRemove, node, insertNode, td, listIndex, toAdd, levelChange, _i3, _toAdd, _node, _i4, _Object$values2, _tree;

            return regenerator.wrap(function _callee2$(_context2) {
              while (1) {
                switch (_context2.prev = _context2.next) {
                  case 0:
                    done = function done() {
                      // execute when completed or cancelled
                      _this2.draggingNode = null;
                    };

                    dragChanged = true;
                    that = store.targetTree;
                    startTree = store.startTree, targetTree = store.targetTree;

                    if (!document.getElementById(placeholderID) || !store.targetTreeEl) {
                      // not moved
                      dragChanged = false;
                    } else {
                      prevNodeInTree = store.placeholderPrevNodeInTree;
                      tree = store.targetTree;
                      level = store.placeholderLevel;

                      if (!prevNodeInTree) {
                        index = 0; // index = tree.rootNode.$children.indexOf()
                      } else if (level > prevNodeInTree.$level) {
                        parent = prevNodeInTree;
                        index = 0;
                      } else {
                        // after prevNodeInTree
                        parent = that.getParent(prevNodeInTree);
                        index = that.getChildren(parent).indexOf(prevNodeInTree) + 1;
                      }

                      store.targetPath = {
                        tree: tree,
                        parent: parent,
                        index: index
                      }; // correct index

                      // correct index
                      _startPath = store.startPath, _targetPath = store.targetPath;

                      if (_startPath.tree === _targetPath.tree && _startPath.parent === _targetPath.parent) {
                        if (!_this2.store.isCloned) {
                          if (_startPath.index < _targetPath.index) {
                            _targetPath.index--;
                          }

                          if (_startPath.index === _targetPath.index) {
                            dragChanged = false;
                          }
                        }
                      }
                    }

                    restoreStyle();
                    startPath = store.startPath, targetPath = store.targetPath;
                    draggingNode = _this2.draggingNode;
                    store.dragChanged = dragChanged; // hook ondragend

                    _context2.t0 = that.ondragend;

                    if (!_context2.t0) {
                      _context2.next = 15;
                      break;
                    }

                    _context2.next = 13;
                    return that.ondragend(store);

                  case 13:
                    _context2.t1 = _context2.sent;
                    _context2.t0 = _context2.t1 === false;

                  case 15:
                    if (!_context2.t0) {
                      _context2.next = 18;
                      break;
                    }

                    done();
                    return _context2.abrupt("return", false);

                  case 18:
                    if (dragChanged) {
                      // need move
                      if (!store.isCloned) {
                        // remove from start path
                        if (startPath.parent) {
                          _this2.getChildren(startPath.parent).splice(startPath.index, 1);
                        }

                        _listIndex = _this2.nodes.indexOf(draggingNode);
                        toRemove = [];
                        walkTreeData(draggingNode, function (node) {
                          toRemove.push(node);
                        }, "$children");

                        _this2.nodes.splice(_listIndex, toRemove.length);

                        for (_i2 = 0, _toRemove = toRemove; _i2 < _toRemove.length; _i2++) {
                          node = _toRemove[_i2];
                          delete _this2.nodesByID[node.$id];
                        }
                      } // insert to new position


                      // insert to new position
                      insertNode = draggingNode; // insertNode may be cloned

                      // insertNode may be cloned
                      if (store.isCloned) {
                        td = new TreeData(insertNode);
                        td.childrenKey = "$children"; // @ts-ignore

                        // @ts-ignore
                        insertNode = td.clone();
                        walkTreeData(insertNode, function (node, index, parent) {
                          node.$id = genNodeID();
                          node.$pid = parent && parent.$id;
                        }, "$children");
                      }

                      that.getChildren(targetPath.parent).splice(targetPath.index, 0, insertNode);
                      insertNode.$pid = targetPath.parent ? targetPath.parent.$id : undefined; // resolve start index in all nodes
                      // 新位置, 在所有节点中的索引

                      // resolve start index in all nodes
                      // 新位置, 在所有节点中的索引
                      listIndex = that._pidIndexToListIndex(targetPath.parent ? targetPath.parent.$id : null, targetPath.index);
                      toAdd = [];
                      levelChange = (targetPath.parent || that.rootNode).$level - (startPath.parent || _this2.rootNode).$level;
                      walkTreeData(insertNode, function (node) {
                        node.$level += levelChange;
                        toAdd.push(node);
                      }, "$children");

                      (_that$nodes = that.nodes).splice.apply(_that$nodes, [listIndex, 0].concat(toAdd));

                      for (_i3 = 0, _toAdd = toAdd; _i3 < _toAdd.length; _i3++) {
                        _node = _toAdd[_i3];
                        that.nodesByID[_node.$id] = _node;
                      }
                    }

                    for (_i4 = 0, _Object$values2 = Object.values(_this2.trees); _i4 < _Object$values2.length; _i4++) {
                      _tree = _Object$values2[_i4];
                      _tree.dragging = false;
                    } // emit event


                    // emit event
                    startTree.$emit("drop", store);
                    targetTree.$emit("drop-into", store);

                    if (store.dragChanged) {
                      startTree.$emit("drop-change", store);

                      if (targetTree !== startTree) {
                        targetTree.$emit("drop-change", store);
                      }
                    }

                    done();

                  case 24:
                  case "end":
                    return _context2.stop();
                }
              }
            }, _callee2);
          }));

          function onDrop(_x, _x2) {
            return _onDrop.apply(this, arguments);
          }

          return onDrop;
        }()
      }),
          hooks = _makeTreeListDraggabl.hooks;
    }
  });

  script.__file = "src/draggable/Draggable.vue";

  exports.BaseTree = script$1;
  exports.Draggable = script;
  exports.VirtualizationList = script$2;

  Object.defineProperty(exports, '__esModule', { value: true });

}));
