# helper-markdown [![NPM version](https://img.shields.io/npm/v/helper-markdown.svg?style=flat)](https://www.npmjs.com/package/helper-markdown) [![NPM monthly downloads](https://img.shields.io/npm/dm/helper-markdown.svg?style=flat)](https://npmjs.org/package/helper-markdown)  [![NPM total downloads](https://img.shields.io/npm/dt/helper-markdown.svg?style=flat)](https://npmjs.org/package/helper-markdown) [![Linux Build Status](https://img.shields.io/travis/helpers/helper-markdown.svg?style=flat&label=Travis)](https://travis-ci.org/helpers/helper-markdown)

> Markdown template helper. Uses remarkable to render markdown in templates. Should work with Handlebars, Lo-Dash or any template engine that supports helper functions.

## Table of Contents

- [Install](#install)
- [API](#api)
- [Usage examples](#usage-examples)
- [Register the helper](#register-the-helper)
  * [templates](#templates)
  * [assemble](#assemble)
  * [verb](#verb)
  * [handlebars](#handlebars)
  * [lodash](#lodash)
- [About](#about)

_(TOC generated by [verb](https://github.com/verbose/verb) using [markdown-toc](https://github.com/jonschlinkert/markdown-toc))_

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save helper-markdown
```

Install with [yarn](https://yarnpkg.com):

```sh
$ yarn add helper-markdown
```

## API

```js
var markdown = require('helper');
```

Returns a function that returns the helper, allowing an options object to be passed:

```js
var hbs = require('handlebars');
hbs.registerHelper('markdown', markdown([options]));
```

**Example**

Pass a custom `highlight` function for syntax highlighting to [Remarkable][], the markdown renderer:

```js
var hljs = require('highlight.js');
var markdown = require('helper-markdown');

function highlight(code, lang) {
  try {
    try {
      return hljs.highlight(lang, code).value;
    } catch (err) {
      if (!/Unknown language/i.test(err.message)) {
        throw err;
      }
      return hljs.highlightAuto(code).value;
    }
  } catch (err) {
    return code;
  }
}

hbs.registerHelper('markdown', markdown({
  highlight: highlight  
}));
```

## Usage examples

With Handlebars:

```handlebars
<div>
{{#markdown}}
# Heading

> this is markdown

foo bar baz
{{/markdown}}
</div>
```

Results in:

```html
<h1>Heading</h1>
<blockquote>
<p>this is markdown</p>
</blockquote>
<p>foo bar baz</p>
```

## Register the helper

> This should work with any engine, here are a few examples

### templates

The `templates` library supports any templates engine supported by consolidate. To register the helper with [templates](https://github.com/jonschlinkert/templates):

```js
var templates = require('templates');
var app = templates();

app.helper('markdown', require('helper-markdown'));
```

### assemble

To register the helper for use with [assemble](https://github.com/assemble/assemble) v0.6.0 and higher:

```js
assemble.helper('markdown', require('helper-markdown'));
```

### verb

Register the helper for use with [verb](https://github.com/verbose/verb):

```js
var verb = require('verb');
verb.helper('markdown', require('helper-markdown'));
```

### handlebars

To register the helper with [handlebars](http://www.handlebarsjs.com/):

```js
var handlebars = require('handlebars');
handlebars.registerHelper('markdown', require('helper-markdown'));
```

### lodash

To register the helper with [Lo-Dash][] or [underscore](http://underscorejs.org):

```js
var markdown = require('helper-markdown');

// as a mixin
_.mixin({markdown: markdown});
_.template('<%= _.markdown("# heading") %>', {});
//=> '<h1>heading</h1>\n'

// passed on the context
_.template('<%= markdown("# heading") %>', {markdown: markdown});
//=> '<h1>heading</h1>\n'

// as an import
var settings = {imports: {markdown: markdown}};
_.template('<%= markdown("# heading") %>', {}, settings);
//=> '<h1>heading</h1>\n'
```

## About

### Related projects

* [assemble](https://www.npmjs.com/package/assemble): Get the rocks out of your socks! Assemble makes you fast at creating web projects… [more](https://github.com/assemble/assemble) | [homepage](https://github.com/assemble/assemble "Get the rocks out of your socks! Assemble makes you fast at creating web projects. Assemble is used by thousands of projects for rapid prototyping, creating themes, scaffolds, boilerplates, e-books, UI components, API documentation, blogs, building websit")
* [handlebars](https://www.npmjs.com/package/handlebars): Handlebars provides the power necessary to let you build semantic templates effectively with no frustration | [homepage](http://www.handlebarsjs.com/ "Handlebars provides the power necessary to let you build semantic templates effectively with no frustration")
* [lodash](https://www.npmjs.com/package/lodash): Lodash modular utilities. | [homepage](https://lodash.com/ "Lodash modular utilities.")
* [template](https://www.npmjs.com/package/template): Render templates using any engine. Supports, layouts, pages, partials and custom template types. Use template… [more](https://github.com/jonschlinkert/template) | [homepage](https://github.com/jonschlinkert/template "Render templates using any engine. Supports, layouts, pages, partials and custom template types. Use template helpers, middleware, routes, loaders, and lots more. Powers assemble, verb and other node.js apps.")
* [underscore](https://www.npmjs.com/package/underscore): JavaScript's functional programming helper library. | [homepage](http://underscorejs.org "JavaScript's functional programming helper library.")
* [verb](https://www.npmjs.com/package/verb): Documentation generator for GitHub projects. Verb is extremely powerful, easy to use, and is used… [more](https://github.com/verbose/verb) | [homepage](https://github.com/verbose/verb "Documentation generator for GitHub projects. Verb is extremely powerful, easy to use, and is used on hundreds of projects of all sizes to generate everything from API docs to readmes.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Contributors

| **Commits** | **Contributor** |  
| --- | --- |  
| 14 | [jonschlinkert](https://github.com/jonschlinkert) |  
| 2  | [almeidap](https://github.com/almeidap) |  
| 1  | [doowb](https://github.com/doowb) |  

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on May 22, 2017._