/**
 * Streamable row data
 */
export interface DataFrame {
    header: string[];
    numRows: number;
    rows(start: number, end: number): Promise<any[][]>;
}
interface TableProps {
    data: DataFrame;
    onDoubleClickCell?: (row: number, col: number) => void;
    onError?: (error: Error) => void;
}
/**
 * Render a table with streaming rows on demand from a DataFrame.
 */
export default function HighTable({ data, onDoubleClickCell, onError }: TableProps): import("react/jsx-runtime").JSX.Element | undefined;
/**
 * Robust stringification of any value, including json and bigints.
 */
export declare function stringify(value: any): string | undefined;
export {};
