/*eslint-disable no-empty */
'use strict';

exports.__esModule = true;
exports.saveState = saveState;
exports.readState = readState;
var KeyPrefix = '@@History/';

function createKey(key) {
  return KeyPrefix + key;
}

function saveState(key, state) {
  window.sessionStorage.setItem(createKey(key), JSON.stringify(state));
}

function readState(key) {
  var json = window.sessionStorage.getItem(createKey(key));

  if (json) {
    try {
      return JSON.parse(json);
    } catch (error) {
      // Ignore invalid JSON.
    }
  }

  return null;
}