'use strict';

exports.__esModule = true;
exports.locationsAreEqual = exports.createLocation = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _PathUtils = require('./PathUtils');

var createLocation = exports.createLocation = function createLocation(path, state, key) {
  var location = void 0;
  if (typeof path === 'string') {
    // Two-arg form: push(path, state)
    location = (0, _PathUtils.parsePath)(path);
    location.state = state;
  } else {
    // One-arg form: push(location)
    location = _extends({}, path);

    if (!location.pathname) location.pathname = '/';

    if (location.search && location.search.charAt(0) !== '?') location.search = '?' + location.search;

    if (location.hash && location.hash.charAt(0) !== '#') location.hash = '#' + location.hash;

    if (state !== undefined && location.state === undefined) location.state = state;
  }

  location.key = key;

  return location;
};

var looseEqual = function looseEqual(a, b) {
  if (a == null) return a == b;

  var typeofA = typeof a === 'undefined' ? 'undefined' : _typeof(a);
  var typeofB = typeof b === 'undefined' ? 'undefined' : _typeof(b);

  if (typeofA !== typeofB) return false;

  if (Array.isArray(a)) {
    if (!Array.isArray(b) || a.length !== b.length) return false;

    return a.every(function (item, index) {
      return looseEqual(item, b[index]);
    });
  } else if (typeofA === 'object') {
    var keysOfA = Object.keys(a);
    var keysOfB = Object.keys(b);

    if (keysOfA.length !== keysOfB.length) return false;

    return keysOfA.every(function (key) {
      return looseEqual(a[key], b[key]);
    });
  }

  return a === b;
};

var locationsAreEqual = exports.locationsAreEqual = function locationsAreEqual(a, b) {
  return a.pathname === b.pathname && a.search === b.search && a.hash === b.hash && a.key === b.key && looseEqual(a.state, b.state);
};