import { myQDevice, myQHwInfo } from "./myq-types.js";
import { myQLogging } from "./myq-logging.js";
export declare class myQApi {
    devices: myQDevice[];
    private accessToken;
    private refreshInterval;
    private refreshToken;
    private tokenScope;
    private accessTokenTimestamp;
    private email;
    private password;
    private accounts;
    private headers;
    private log;
    private lastAuthenticateCall;
    private lastRefreshDevicesCall;
    private myqRetrieve;
    private region;
    constructor(email: string, password: string, log?: myQLogging, region?: string);
    private oauthGetAuthPage;
    private oauthLogin;
    private oauthRedirect;
    private getOAuthToken;
    private refreshOAuthToken;
    private acquireAccessToken;
    private refreshAccessToken;
    refreshDevices(): Promise<boolean>;
    execute(device: myQDevice, command: string): Promise<boolean>;
    private getAccounts;
    private get myQCloud();
    getDevice(serial: string): myQDevice | null;
    getDeviceName(device: myQDevice): string;
    getHwInfo(serial: string): myQHwInfo | null;
    private trimSetCookie;
    private retrieve;
}
