import { Adapter } from "./native/adapter";
import { Session } from "./session";
import { Locatable } from "./url";
import { StreamMessage } from "./streams/stream_message";
import { StreamSource } from "./types";
import { VisitOptions } from "./drive/visit";
import { PageRenderer } from "./drive/page_renderer";
import { PageSnapshot } from "./drive/page_snapshot";
declare const session: Session;
declare const navigator: import("./drive/navigator").Navigator;
export { navigator, session, PageRenderer, PageSnapshot };
export declare function start(): void;
export declare function registerAdapter(adapter: Adapter): void;
export declare function visit(location: Locatable, options?: Partial<VisitOptions>): void;
export declare function connectStreamSource(source: StreamSource): void;
export declare function disconnectStreamSource(source: StreamSource): void;
export declare function renderStreamMessage(message: StreamMessage | string): void;
export declare function clearCache(): void;
export declare function setProgressBarDelay(delay: number): void;
