import { FrameElement, FrameElementDelegate, FrameLoadingStyle } from "../../elements/frame_element";
import { FetchRequest, FetchRequestDelegate, FetchRequestHeaders } from "../../http/fetch_request";
import { FetchResponse } from "../../http/fetch_response";
import { AppearanceObserver, AppearanceObserverDelegate } from "../../observers/appearance_observer";
import { FormSubmission, FormSubmissionDelegate } from "../drive/form_submission";
import { Snapshot } from "../snapshot";
import { ViewDelegate, ViewRenderOptions } from "../view";
import { FormSubmitObserver, FormSubmitObserverDelegate } from "../../observers/form_submit_observer";
import { FrameView } from "./frame_view";
import { LinkClickObserver, LinkClickObserverDelegate } from "../../observers/link_click_observer";
import { FormLinkClickObserver, FormLinkClickObserverDelegate } from "../../observers/form_link_click_observer";
export declare type TurboFrameMissingEvent = CustomEvent<{
    fetchResponse: FetchResponse;
}>;
export declare class FrameController implements AppearanceObserverDelegate, FetchRequestDelegate, FormSubmitObserverDelegate, FormSubmissionDelegate, FrameElementDelegate, FormLinkClickObserverDelegate, LinkClickObserverDelegate, ViewDelegate<FrameElement, Snapshot<FrameElement>> {
    readonly element: FrameElement;
    readonly view: FrameView;
    readonly appearanceObserver: AppearanceObserver;
    readonly formLinkClickObserver: FormLinkClickObserver;
    readonly linkClickObserver: LinkClickObserver;
    readonly formSubmitObserver: FormSubmitObserver;
    formSubmission?: FormSubmission;
    fetchResponseLoaded: (_fetchResponse: FetchResponse) => void;
    private currentFetchRequest;
    private resolveVisitPromise;
    private connected;
    private hasBeenLoaded;
    private ignoredAttributes;
    private action;
    private frame?;
    readonly restorationIdentifier: string;
    private previousFrameElement?;
    private currentNavigationElement?;
    constructor(element: FrameElement);
    connect(): void;
    disconnect(): void;
    disabledChanged(): void;
    sourceURLChanged(): void;
    completeChanged(): void;
    loadingStyleChanged(): void;
    private loadSourceURL;
    loadResponse(fetchResponse: FetchResponse): Promise<void>;
    elementAppearedInViewport(_element: Element): void;
    willSubmitFormLinkToLocation(link: Element): boolean;
    submittedFormLinkToLocation(link: Element, _location: URL, form: HTMLFormElement): void;
    willFollowLinkToLocation(element: Element): boolean;
    followedLinkToLocation(element: Element, location: URL): void;
    willSubmitForm(element: HTMLFormElement, submitter?: HTMLElement): boolean;
    formSubmitted(element: HTMLFormElement, submitter?: HTMLElement): void;
    prepareHeadersForRequest(headers: FetchRequestHeaders, request: FetchRequest): void;
    requestStarted(_request: FetchRequest): void;
    requestPreventedHandlingResponse(_request: FetchRequest, _response: FetchResponse): void;
    requestSucceededWithResponse(request: FetchRequest, response: FetchResponse): Promise<void>;
    requestFailedWithResponse(request: FetchRequest, response: FetchResponse): void;
    requestErrored(request: FetchRequest, error: Error): void;
    requestFinished(_request: FetchRequest): void;
    formSubmissionStarted({ formElement }: FormSubmission): void;
    formSubmissionSucceededWithResponse(formSubmission: FormSubmission, response: FetchResponse): void;
    formSubmissionFailedWithResponse(formSubmission: FormSubmission, fetchResponse: FetchResponse): void;
    formSubmissionErrored(formSubmission: FormSubmission, error: Error): void;
    formSubmissionFinished({ formElement }: FormSubmission): void;
    allowsImmediateRender({ element: newFrame }: Snapshot<FrameElement>, options: ViewRenderOptions<FrameElement>): boolean;
    viewRenderedSnapshot(_snapshot: Snapshot, _isPreview: boolean): void;
    preloadOnLoadLinksForView(element: Element): void;
    viewInvalidated(): void;
    willRenderFrame(currentElement: FrameElement, _newElement: FrameElement): void;
    visitCachedSnapshot: ({ element }: Snapshot) => void;
    private visit;
    private navigateFrame;
    private proposeVisitIfNavigatedWithAction;
    changeHistory(): void;
    private sessionWillHandleMissingFrame;
    private findFrameElement;
    extractForeignFrameElement(container: ParentNode): Promise<FrameElement | null>;
    private formActionIsVisitable;
    private shouldInterceptNavigation;
    get id(): string;
    get enabled(): boolean;
    get sourceURL(): string | undefined;
    set sourceURL(sourceURL: string | undefined);
    get loadingStyle(): FrameLoadingStyle;
    get isLoading(): boolean;
    get complete(): boolean;
    set complete(value: boolean);
    get isActive(): boolean;
    get rootLocation(): URL;
    private isIgnoringChangesTo;
    private ignoringChangesToAttribute;
    private withCurrentNavigationElement;
}
