// Generated by CoffeeScript 1.7.1
(function() {
  exports.XmlEntities = (function() {
    var alphaIndex, charIndex, charSIndex;

    function XmlEntities() {}

    alphaIndex = {
      '&lt': '<',
      '&gt': '>',
      '&quot': '"',
      '&apos': '\'',
      '&amp': '&',
      '&lt;': '<',
      '&gt;': '>',
      '&quot;': '"',
      '&apos;': '\'',
      '&amp;': '&'
    };

    charIndex = {
      60: 'lt',
      62: 'gt',
      34: 'quot',
      39: 'apos',
      38: 'amp'
    };

    charSIndex = {
      '<': '&lt;',
      '>': '&gt;',
      '"': '&quot;',
      '\'': '&apos;',
      '&': '&amp;'
    };

    XmlEntities.prototype.encode = function(str) {
      if (str.length === 0) {
        return '';
      }
      return str.replace(/<|>|"|'|&/g, function(s) {
        return charSIndex[s];
      });
    };

    XmlEntities.prototype.decode = function(str) {
      if (str.length === 0) {
        return '';
      }
      return str.replace(/&#?[0-9a-zA-Z]+;?/g, function(s) {
        var a, code;
        if (s.charAt(1) === '#') {
          if (s.charAt(2).toLowerCase() === 'x') {
            code = parseInt(s.substr(3), 16);
          } else {
            code = parseInt(s.substr(2));
          }
          if (isNaN(code) || code < -32768 || code > 65535) {
            return '';
          }
          return String.fromCharCode(code);
        } else {
          if (a = alphaIndex[s]) {
            return a;
          } else {
            return s;
          }
        }
      });
    };

    XmlEntities.prototype.encodeNonUTF = function(str) {
      var alpha, c, i, l, result;
      if (str.length === 0) {
        return '';
      }
      result = '';
      l = str.length;
      i = 0;
      while (i < l) {
        c = str.charCodeAt(i);
        if (alpha = charIndex[c]) {
          result += "&" + alpha + ";";
          i++;
          continue;
        }
        if (c < 32 || c > 126) {
          result += '&#' + c + ';';
        } else {
          result += str.charAt(i);
        }
        i++;
      }
      return result;
    };

    XmlEntities.prototype.encodeNonASCII = function(str) {
      var c, i, l, result;
      if (str.length === 0) {
        return '';
      }
      result = '';
      l = str.length;
      i = 0;
      while (i < l) {
        c = str.charCodeAt(i);
        if (c <= 255) {
          result += str[i++];
          continue;
        }
        result += '&#' + c + ';';
        i++;
      }
      return result;
    };

    return XmlEntities;

  })();

}).call(this);
