"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromCodePoint = String.fromCodePoint ||
    function (astralCodePoint) {
        return String.fromCharCode(Math.floor((astralCodePoint - 0x10000) / 0x400) + 0xd800, ((astralCodePoint - 0x10000) % 0x400) + 0xdc00);
    };
exports.getCodePoint = String.prototype.codePointAt
    ? function (input, position) {
        return input.codePointAt(position);
    }
    : function (input, position) {
        return (input.charCodeAt(position) - 0xd800) * 0x400 + input.charCodeAt(position + 1) - 0xdc00 + 0x10000;
    };
exports.highSurrogateFrom = 0xd800;
exports.highSurrogateTo = 0xdbff;
