(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
	typeof define === 'function' && define.amd ? define(['exports'], factory) :
	(global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.HTMLMinifier = {}));
})(this, (function (exports) { 'use strict';

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function getDefaultExportFromCjs (x) {
		return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
	}

	function getAugmentedNamespace(n) {
	  if (Object.prototype.hasOwnProperty.call(n, '__esModule')) return n;
	  var f = n.default;
		if (typeof f == "function") {
			var a = function a () {
				var isInstance = false;
	      try {
	        isInstance = this instanceof a;
	      } catch {}
				if (isInstance) {
	        return Reflect.construct(f, arguments, this.constructor);
				}
				return f.apply(this, arguments);
			};
			a.prototype = f.prototype;
	  } else a = {};
	  Object.defineProperty(a, '__esModule', {value: true});
		Object.keys(n).forEach(function (k) {
			var d = Object.getOwnPropertyDescriptor(n, k);
			Object.defineProperty(a, k, d.get ? d : {
				enumerable: true,
				get: function () {
					return n[k];
				}
			});
		});
		return a;
	}

	var global$1 = (typeof global !== "undefined" ? global :
	  typeof self !== "undefined" ? self :
	  typeof window !== "undefined" ? window : {});

	// shim for using process in browser
	// based off https://github.com/defunctzombie/node-process/blob/master/browser.js

	function defaultSetTimout() {
	    throw new Error('setTimeout has not been defined');
	}
	function defaultClearTimeout () {
	    throw new Error('clearTimeout has not been defined');
	}
	var cachedSetTimeout = defaultSetTimout;
	var cachedClearTimeout = defaultClearTimeout;
	if (typeof global$1.setTimeout === 'function') {
	    cachedSetTimeout = setTimeout;
	}
	if (typeof global$1.clearTimeout === 'function') {
	    cachedClearTimeout = clearTimeout;
	}

	function runTimeout(fun) {
	    if (cachedSetTimeout === setTimeout) {
	        //normal enviroments in sane situations
	        return setTimeout(fun, 0);
	    }
	    // if setTimeout wasn't available but was latter defined
	    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
	        cachedSetTimeout = setTimeout;
	        return setTimeout(fun, 0);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedSetTimeout(fun, 0);
	    } catch(e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
	            return cachedSetTimeout.call(null, fun, 0);
	        } catch(e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
	            return cachedSetTimeout.call(this, fun, 0);
	        }
	    }


	}
	function runClearTimeout(marker) {
	    if (cachedClearTimeout === clearTimeout) {
	        //normal enviroments in sane situations
	        return clearTimeout(marker);
	    }
	    // if clearTimeout wasn't available but was latter defined
	    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
	        cachedClearTimeout = clearTimeout;
	        return clearTimeout(marker);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedClearTimeout(marker);
	    } catch (e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
	            return cachedClearTimeout.call(null, marker);
	        } catch (e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
	            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
	            return cachedClearTimeout.call(this, marker);
	        }
	    }



	}
	var queue = [];
	var draining = false;
	var currentQueue;
	var queueIndex = -1;

	function cleanUpNextTick() {
	    if (!draining || !currentQueue) {
	        return;
	    }
	    draining = false;
	    if (currentQueue.length) {
	        queue = currentQueue.concat(queue);
	    } else {
	        queueIndex = -1;
	    }
	    if (queue.length) {
	        drainQueue();
	    }
	}

	function drainQueue() {
	    if (draining) {
	        return;
	    }
	    var timeout = runTimeout(cleanUpNextTick);
	    draining = true;

	    var len = queue.length;
	    while(len) {
	        currentQueue = queue;
	        queue = [];
	        while (++queueIndex < len) {
	            if (currentQueue) {
	                currentQueue[queueIndex].run();
	            }
	        }
	        queueIndex = -1;
	        len = queue.length;
	    }
	    currentQueue = null;
	    draining = false;
	    runClearTimeout(timeout);
	}
	function nextTick(fun) {
	    var args = new Array(arguments.length - 1);
	    if (arguments.length > 1) {
	        for (var i = 1; i < arguments.length; i++) {
	            args[i - 1] = arguments[i];
	        }
	    }
	    queue.push(new Item(fun, args));
	    if (queue.length === 1 && !draining) {
	        runTimeout(drainQueue);
	    }
	}
	// v8 likes predictible objects
	function Item(fun, array) {
	    this.fun = fun;
	    this.array = array;
	}
	Item.prototype.run = function () {
	    this.fun.apply(null, this.array);
	};
	var title = 'browser';
	var platform$1 = 'browser';
	var browser = true;
	var env = {};
	var argv = [];
	var version = ''; // empty string to avoid regexp issues
	var versions = {};
	var release$1 = {};
	var config = {};

	function noop$1() {}

	var on = noop$1;
	var addListener = noop$1;
	var once = noop$1;
	var off = noop$1;
	var removeListener = noop$1;
	var removeAllListeners = noop$1;
	var emit = noop$1;

	function binding(name) {
	    throw new Error('process.binding is not supported');
	}

	function cwd () { return '/' }
	function chdir (dir) {
	    throw new Error('process.chdir is not supported');
	}function umask() { return 0; }

	// from https://github.com/kumavis/browser-process-hrtime/blob/master/index.js
	var performance = global$1.performance || {};
	var performanceNow =
	  performance.now        ||
	  performance.mozNow     ||
	  performance.msNow      ||
	  performance.oNow       ||
	  performance.webkitNow  ||
	  function(){ return (new Date()).getTime() };

	// generate timestamp or delta
	// see http://nodejs.org/api/process.html#process_process_hrtime
	function hrtime(previousTimestamp){
	  var clocktime = performanceNow.call(performance)*1e-3;
	  var seconds = Math.floor(clocktime);
	  var nanoseconds = Math.floor((clocktime%1)*1e9);
	  if (previousTimestamp) {
	    seconds = seconds - previousTimestamp[0];
	    nanoseconds = nanoseconds - previousTimestamp[1];
	    if (nanoseconds<0) {
	      seconds--;
	      nanoseconds += 1e9;
	    }
	  }
	  return [seconds,nanoseconds]
	}

	var startTime = new Date();
	function uptime$1() {
	  var currentTime = new Date();
	  var dif = currentTime - startTime;
	  return dif / 1000;
	}

	var browser$1 = {
	  nextTick: nextTick,
	  title: title,
	  browser: browser,
	  env: env,
	  argv: argv,
	  version: version,
	  versions: versions,
	  on: on,
	  addListener: addListener,
	  once: once,
	  off: off,
	  removeListener: removeListener,
	  removeAllListeners: removeAllListeners,
	  emit: emit,
	  binding: binding,
	  cwd: cwd,
	  chdir: chdir,
	  umask: umask,
	  hrtime: hrtime,
	  platform: platform$1,
	  release: release$1,
	  config: config,
	  uptime: uptime$1
	};

	var clean = {exports: {}};

	var optimize$3;
	var hasRequiredOptimize$3;

	function requireOptimize$3 () {
		if (hasRequiredOptimize$3) return optimize$3;
		hasRequiredOptimize$3 = 1;
		function level0Optimize(tokens) {
		  // noop as level 0 means no optimizations!
		  return tokens;
		}

		optimize$3 = level0Optimize;
		return optimize$3;
	}

	var naturalCompare_1;
	var hasRequiredNaturalCompare;

	function requireNaturalCompare () {
		if (hasRequiredNaturalCompare) return naturalCompare_1;
		hasRequiredNaturalCompare = 1;
		// adapted from http://nedbatchelder.com/blog/200712.html#e20071211T054956

		var NUMBER_PATTERN = /([0-9]+)/;

		function naturalCompare(value1, value2) {
		  var keys1 = ('' + value1).split(NUMBER_PATTERN).map(tryParseInt);
		  var keys2 = ('' + value2).split(NUMBER_PATTERN).map(tryParseInt);
		  var key1;
		  var key2;
		  var compareFirst = Math.min(keys1.length, keys2.length);
		  var i, l;

		  for (i = 0, l = compareFirst; i < l; i++) {
		    key1 = keys1[i];
		    key2 = keys2[i];

		    if (key1 != key2) {
		      return key1 > key2 ? 1 : -1;
		    }
		  }

		  return keys1.length > keys2.length ? 1 : (keys1.length == keys2.length ? 0 : -1);
		}

		function tryParseInt(value) {
		  return ('' + parseInt(value)) == value
		    ? parseInt(value)
		    : value;
		}

		naturalCompare_1 = naturalCompare;
		return naturalCompare_1;
	}

	var sortSelectors_1;
	var hasRequiredSortSelectors;

	function requireSortSelectors () {
		if (hasRequiredSortSelectors) return sortSelectors_1;
		hasRequiredSortSelectors = 1;
		var naturalCompare = requireNaturalCompare();

		function naturalSorter(scope1, scope2) {
		  return naturalCompare(scope1[1], scope2[1]);
		}

		function standardSorter(scope1, scope2) {
		  return scope1[1] > scope2[1] ? 1 : -1;
		}

		function sortSelectors(selectors, method) {
		  switch (method) {
		  case 'natural':
		    return selectors.sort(naturalSorter);
		  case 'standard':
		    return selectors.sort(standardSorter);
		  case 'none':
		  case false:
		    return selectors;
		  }
		}

		sortSelectors_1 = sortSelectors;
		return sortSelectors_1;
	}

	var override_1;
	var hasRequiredOverride;

	function requireOverride () {
		if (hasRequiredOverride) return override_1;
		hasRequiredOverride = 1;
		function override(source1, source2) {
		  var target = {};
		  var key1;
		  var key2;
		  var item;

		  for (key1 in source1) {
		    item = source1[key1];

		    if (Array.isArray(item)) {
		      target[key1] = item.slice(0);
		    } else if (typeof item == 'object' && item !== null) {
		      target[key1] = override(item, {});
		    } else {
		      target[key1] = item;
		    }
		  }

		  for (key2 in source2) {
		    item = source2[key2];

		    if (key2 in target && Array.isArray(item)) {
		      target[key2] = item.slice(0);
		    } else if (key2 in target && typeof item == 'object' && item !== null) {
		      target[key2] = override(target[key2], item);
		    } else {
		      target[key2] = item;
		    }
		  }

		  return target;
		}

		override_1 = override;
		return override_1;
	}

	/*
	The MIT License (MIT)

	Copyright (c) 2016 CoderPuppy

	Permission is hereby granted, free of charge, to any person obtaining a copy
	of this software and associated documentation files (the "Software"), to deal
	in the Software without restriction, including without limitation the rights
	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	copies of the Software, and to permit persons to whom the Software is
	furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included in all
	copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
	SOFTWARE.

	*/
	var _endianness;
	function endianness() {
	  if (typeof _endianness === 'undefined') {
	    var a = new ArrayBuffer(2);
	    var b = new Uint8Array(a);
	    var c = new Uint16Array(a);
	    b[0] = 1;
	    b[1] = 2;
	    if (c[0] === 258) {
	      _endianness = 'BE';
	    } else if (c[0] === 513){
	      _endianness = 'LE';
	    } else {
	      throw new Error('unable to figure out endianess');
	    }
	  }
	  return _endianness;
	}

	function hostname() {
	  if (typeof global$1.location !== 'undefined') {
	    return global$1.location.hostname
	  } else return '';
	}

	function loadavg() {
	  return [];
	}

	function uptime() {
	  return 0;
	}

	function freemem() {
	  return Number.MAX_VALUE;
	}

	function totalmem() {
	  return Number.MAX_VALUE;
	}

	function cpus() {
	  return [];
	}

	function type() {
	  return 'Browser';
	}

	function release () {
	  if (typeof global$1.navigator !== 'undefined') {
	    return global$1.navigator.appVersion;
	  }
	  return '';
	}

	function networkInterfaces () {
	  return {};
	}

	function getNetworkInterfaces () {
	  return {};
	}

	function arch() {
	  return 'javascript';
	}

	function platform() {
	  return 'browser';
	}

	function tmpDir() {
	  return '/tmp';
	}
	var tmpdir = tmpDir;

	var EOL = '\n';

	function homedir(){
	  return '$HOME'
	}

	var _polyfillNode_os = {
	  homedir: homedir,
	  EOL: EOL,
	  arch: arch,
	  platform: platform,
	  tmpdir: tmpdir,
	  tmpDir: tmpDir,
	  networkInterfaces:networkInterfaces,
	  getNetworkInterfaces: getNetworkInterfaces,
	  release: release,
	  type: type,
	  cpus: cpus,
	  totalmem: totalmem,
	  freemem: freemem,
	  uptime: uptime,
	  loadavg: loadavg,
	  hostname: hostname,
	  endianness: endianness,
	};

	var _polyfillNode_os$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		EOL: EOL,
		arch: arch,
		cpus: cpus,
		default: _polyfillNode_os,
		endianness: endianness,
		freemem: freemem,
		getNetworkInterfaces: getNetworkInterfaces,
		homedir: homedir,
		hostname: hostname,
		loadavg: loadavg,
		networkInterfaces: networkInterfaces,
		platform: platform,
		release: release,
		tmpDir: tmpDir,
		tmpdir: tmpdir,
		totalmem: totalmem,
		type: type,
		uptime: uptime
	});

	var require$$1$2 = /*@__PURE__*/getAugmentedNamespace(_polyfillNode_os$1);

	var format$3;
	var hasRequiredFormat$1;

	function requireFormat$1 () {
		if (hasRequiredFormat$1) return format$3;
		hasRequiredFormat$1 = 1;
		var override = requireOverride();

		function getSystemLineBreak() {
		  var systemLineBreak = '\n';
		  try {
		    var os = require$$1$2;
		    systemLineBreak = os.EOL;
		  } catch (_) {
		    // no op
		  }
		  return systemLineBreak;
		}

		var Breaks = {
		  AfterAtRule: 'afterAtRule',
		  AfterBlockBegins: 'afterBlockBegins',
		  AfterBlockEnds: 'afterBlockEnds',
		  AfterComment: 'afterComment',
		  AfterProperty: 'afterProperty',
		  AfterRuleBegins: 'afterRuleBegins',
		  AfterRuleEnds: 'afterRuleEnds',
		  BeforeBlockEnds: 'beforeBlockEnds',
		  BetweenSelectors: 'betweenSelectors'
		};

		var BreakWith = {
		  CarriageReturnLineFeed: '\r\n',
		  LineFeed: '\n',
		  System: getSystemLineBreak()
		};

		var IndentWith = {
		  Space: ' ',
		  Tab: '\t'
		};

		var Spaces = {
		  AroundSelectorRelation: 'aroundSelectorRelation',
		  BeforeBlockBegins: 'beforeBlockBegins',
		  BeforeValue: 'beforeValue'
		};

		var DEFAULTS = {
		  breaks: breaks(false),
		  breakWith: BreakWith.System,
		  indentBy: 0,
		  indentWith: IndentWith.Space,
		  spaces: spaces(false),
		  wrapAt: false,
		  semicolonAfterLastProperty: false
		};

		var BEAUTIFY_ALIAS = 'beautify';
		var KEEP_BREAKS_ALIAS = 'keep-breaks';

		var OPTION_SEPARATOR = ';';
		var OPTION_NAME_VALUE_SEPARATOR = ':';
		var HASH_VALUES_OPTION_SEPARATOR = ',';
		var HASH_VALUES_NAME_VALUE_SEPARATOR = '=';

		var FALSE_KEYWORD_1 = 'false';
		var FALSE_KEYWORD_2 = 'off';
		var TRUE_KEYWORD_1 = 'true';
		var TRUE_KEYWORD_2 = 'on';

		function breaks(value) {
		  var breakOptions = {};

		  breakOptions[Breaks.AfterAtRule] = value;
		  breakOptions[Breaks.AfterBlockBegins] = value;
		  breakOptions[Breaks.AfterBlockEnds] = value;
		  breakOptions[Breaks.AfterComment] = value;
		  breakOptions[Breaks.AfterProperty] = value;
		  breakOptions[Breaks.AfterRuleBegins] = value;
		  breakOptions[Breaks.AfterRuleEnds] = value;
		  breakOptions[Breaks.BeforeBlockEnds] = value;
		  breakOptions[Breaks.BetweenSelectors] = value;

		  return breakOptions;
		}

		function spaces(value) {
		  var spaceOptions = {};

		  spaceOptions[Spaces.AroundSelectorRelation] = value;
		  spaceOptions[Spaces.BeforeBlockBegins] = value;
		  spaceOptions[Spaces.BeforeValue] = value;

		  return spaceOptions;
		}

		function formatFrom(source) {
		  if (source === undefined || source === false) {
		    return false;
		  }

		  if (typeof source == 'object' && 'breakWith' in source) {
		    source = override(source, { breakWith: mapBreakWith(source.breakWith) });
		  }

		  if (typeof source == 'object' && 'indentBy' in source) {
		    source = override(source, { indentBy: parseInt(source.indentBy) });
		  }

		  if (typeof source == 'object' && 'indentWith' in source) {
		    source = override(source, { indentWith: mapIndentWith(source.indentWith) });
		  }

		  if (typeof source == 'object') {
		    return remapBreaks(override(DEFAULTS, source));
		  }

		  if (typeof source == 'string' && source == BEAUTIFY_ALIAS) {
		    return remapBreaks(
		      override(DEFAULTS, {
		        breaks: breaks(true),
		        indentBy: 2,
		        spaces: spaces(true)
		      })
		    );
		  }

		  if (typeof source == 'string' && source == KEEP_BREAKS_ALIAS) {
		    return remapBreaks(
		      override(DEFAULTS, {
		        breaks: {
		          afterAtRule: true,
		          afterBlockBegins: true,
		          afterBlockEnds: true,
		          afterComment: true,
		          afterRuleEnds: true,
		          beforeBlockEnds: true
		        }
		      })
		    );
		  }

		  if (typeof source == 'string') {
		    return remapBreaks(override(DEFAULTS, toHash(source)));
		  }

		  return DEFAULTS;
		}

		function toHash(string) {
		  return string
		    .split(OPTION_SEPARATOR)
		    .reduce(function(accumulator, directive) {
		      var parts = directive.split(OPTION_NAME_VALUE_SEPARATOR);
		      var name = parts[0];
		      var value = parts[1];

		      if (name == 'breaks' || name == 'spaces') {
		        accumulator[name] = hashValuesToHash(value);
		      } else if (name == 'indentBy' || name == 'wrapAt') {
		        accumulator[name] = parseInt(value);
		      } else if (name == 'indentWith') {
		        accumulator[name] = mapIndentWith(value);
		      } else if (name == 'breakWith') {
		        accumulator[name] = mapBreakWith(value);
		      }

		      return accumulator;
		    }, {});
		}

		function hashValuesToHash(string) {
		  return string
		    .split(HASH_VALUES_OPTION_SEPARATOR)
		    .reduce(function(accumulator, directive) {
		      var parts = directive.split(HASH_VALUES_NAME_VALUE_SEPARATOR);
		      var name = parts[0];
		      var value = parts[1];

		      accumulator[name] = normalizeValue(value);

		      return accumulator;
		    }, {});
		}

		function normalizeValue(value) {
		  switch (value) {
		  case FALSE_KEYWORD_1:
		  case FALSE_KEYWORD_2:
		    return false;
		  case TRUE_KEYWORD_1:
		  case TRUE_KEYWORD_2:
		    return true;
		  default:
		    return value;
		  }
		}

		function mapBreakWith(value) {
		  switch (value) {
		  case 'windows':
		  case 'crlf':
		  case BreakWith.CarriageReturnLineFeed:
		    return BreakWith.CarriageReturnLineFeed;
		  case 'unix':
		  case 'lf':
		  case BreakWith.LineFeed:
		    return BreakWith.LineFeed;
		  default:
		    return BreakWith.System;
		  }
		}

		function mapIndentWith(value) {
		  switch (value) {
		  case 'space':
		    return IndentWith.Space;
		  case 'tab':
		    return IndentWith.Tab;
		  default:
		    return value;
		  }
		}

		function remapBreaks(source) {
		  for (var key in Breaks) {
		    var breakName = Breaks[key];
		    var breakValue = source.breaks[breakName];

		    if (breakValue === true) {
		      source.breaks[breakName] = source.breakWith;
		    } else if (breakValue === false) {
		      source.breaks[breakName] = '';
		    } else {
		      source.breaks[breakName] = source.breakWith.repeat(parseInt(breakValue));
		    }
		  }

		  return source;
		}

		format$3 = {
		  Breaks: Breaks,
		  Spaces: Spaces,
		  formatFrom: formatFrom
		};
		return format$3;
	}

	var marker;
	var hasRequiredMarker;

	function requireMarker () {
		if (hasRequiredMarker) return marker;
		hasRequiredMarker = 1;
		var Marker = {
		  ASTERISK: '*',
		  AT: '@',
		  BACK_SLASH: '\\',
		  CARRIAGE_RETURN: '\r',
		  CLOSE_CURLY_BRACKET: '}',
		  CLOSE_ROUND_BRACKET: ')',
		  CLOSE_SQUARE_BRACKET: ']',
		  COLON: ':',
		  COMMA: ',',
		  DOUBLE_QUOTE: '"',
		  EXCLAMATION: '!',
		  FORWARD_SLASH: '/',
		  INTERNAL: '-clean-css-',
		  NEW_LINE_NIX: '\n',
		  OPEN_CURLY_BRACKET: '{',
		  OPEN_ROUND_BRACKET: '(',
		  OPEN_SQUARE_BRACKET: '[',
		  SEMICOLON: ';',
		  SINGLE_QUOTE: '\'',
		  SPACE: ' ',
		  TAB: '\t',
		  UNDERSCORE: '_'
		};

		marker = Marker;
		return marker;
	}

	var formatPosition_1;
	var hasRequiredFormatPosition;

	function requireFormatPosition () {
		if (hasRequiredFormatPosition) return formatPosition_1;
		hasRequiredFormatPosition = 1;
		function formatPosition(metadata) {
		  var line = metadata[0];
		  var column = metadata[1];
		  var source = metadata[2];

		  return source
		    ? source + ':' + line + ':' + column
		    : line + ':' + column;
		}

		formatPosition_1 = formatPosition;
		return formatPosition_1;
	}

	var tidyRules_1;
	var hasRequiredTidyRules;

	function requireTidyRules () {
		if (hasRequiredTidyRules) return tidyRules_1;
		hasRequiredTidyRules = 1;
		var Spaces = requireFormat$1().Spaces;
		var Marker = requireMarker();
		var formatPosition = requireFormatPosition();

		var CASE_ATTRIBUTE_PATTERN = /[\s"'][iI]\s*\]/;
		var CASE_RESTORE_PATTERN = /([\d\w])([iI])\]/g;
		var DOUBLE_QUOTE_CASE_PATTERN = /="([a-zA-Z][a-zA-Z\d\-_]+)"([iI])/g;
		var DOUBLE_QUOTE_PATTERN = /="([a-zA-Z][a-zA-Z\d\-_]+)"(\s|\])/g;
		var HTML_COMMENT_PATTERN = /^(?:(?:<!--|-->)\s*)+/;
		var SINGLE_QUOTE_CASE_PATTERN = /='([a-zA-Z][a-zA-Z\d\-_]+)'([iI])/g;
		var SINGLE_QUOTE_PATTERN = /='([a-zA-Z][a-zA-Z\d\-_]+)'(\s|\])/g;
		var RELATION_PATTERN = /[>+~]/;
		var WHITESPACE_PATTERN = /\s/;

		var ASTERISK_PLUS_HTML_HACK = '*+html ';
		var ASTERISK_FIRST_CHILD_PLUS_HTML_HACK = '*:first-child+html ';
		var LESS_THAN = '<';

		var PSEUDO_CLASSES_WITH_SELECTORS = [
		  ':current',
		  ':future',
		  ':has',
		  ':host',
		  ':host-context',
		  ':is',
		  ':not',
		  ':past',
		  ':where'
		];

		function hasInvalidCharacters(value) {
		  var isEscaped;
		  var isInvalid = false;
		  var character;
		  var isQuote = false;
		  var i, l;

		  for (i = 0, l = value.length; i < l; i++) {
		    character = value[i];

		    if (isEscaped) ; else if (character == Marker.SINGLE_QUOTE || character == Marker.DOUBLE_QUOTE) {
		      isQuote = !isQuote;
		    } else if (!isQuote
		      && (character == Marker.CLOSE_CURLY_BRACKET
		        || character == Marker.EXCLAMATION
		        || character == LESS_THAN
		        || character == Marker.SEMICOLON)
		    ) {
		      isInvalid = true;
		      break;
		    } else if (!isQuote && i === 0 && RELATION_PATTERN.test(character)) {
		      isInvalid = true;
		      break;
		    }

		    isEscaped = character == Marker.BACK_SLASH;
		  }

		  return isInvalid;
		}

		function removeWhitespace(value, format) {
		  var stripped = [];
		  var character;
		  var isNewLineNix;
		  var isNewLineWin;
		  var isEscaped;
		  var wasEscaped;
		  var isQuoted;
		  var isSingleQuoted;
		  var isDoubleQuoted;
		  var isAttribute;
		  var isRelation;
		  var isWhitespace;
		  var isSpaceAwarePseudoClass;
		  var roundBracketLevel = 0;
		  var wasComma = false;
		  var wasRelation = false;
		  var wasWhitespace = false;
		  var withCaseAttribute = CASE_ATTRIBUTE_PATTERN.test(value);
		  var spaceAroundRelation = format && format.spaces[Spaces.AroundSelectorRelation];
		  var i, l;

		  for (i = 0, l = value.length; i < l; i++) {
		    character = value[i];

		    isNewLineNix = character == Marker.NEW_LINE_NIX;
		    isNewLineWin = character == Marker.NEW_LINE_NIX && value[i - 1] == Marker.CARRIAGE_RETURN;
		    isQuoted = isSingleQuoted || isDoubleQuoted;
		    isRelation = !isAttribute && !isEscaped && roundBracketLevel === 0 && RELATION_PATTERN.test(character);
		    isWhitespace = WHITESPACE_PATTERN.test(character);
		    isSpaceAwarePseudoClass = roundBracketLevel == 1 && character == Marker.CLOSE_ROUND_BRACKET
		      ? false
		      : isSpaceAwarePseudoClass
		        || (roundBracketLevel === 0 && character == Marker.COLON && isPseudoClassWithSelectors(value, i));

		    if (wasEscaped && isQuoted && isNewLineWin) {
		      // swallow escaped new windows lines in comments
		      stripped.pop();
		      stripped.pop();
		    } else if (isEscaped && isQuoted && isNewLineNix) {
		      // swallow escaped new *nix lines in comments
		      stripped.pop();
		    } else if (isEscaped) {
		      stripped.push(character);
		    } else if (character == Marker.OPEN_SQUARE_BRACKET && !isQuoted) {
		      stripped.push(character);
		      isAttribute = true;
		    } else if (character == Marker.CLOSE_SQUARE_BRACKET && !isQuoted) {
		      stripped.push(character);
		      isAttribute = false;
		    } else if (character == Marker.OPEN_ROUND_BRACKET && !isQuoted) {
		      stripped.push(character);
		      roundBracketLevel++;
		    } else if (character == Marker.CLOSE_ROUND_BRACKET && !isQuoted) {
		      stripped.push(character);
		      roundBracketLevel--;
		    } else if (character == Marker.SINGLE_QUOTE && !isQuoted) {
		      stripped.push(character);
		      isSingleQuoted = true;
		    } else if (character == Marker.DOUBLE_QUOTE && !isQuoted) {
		      stripped.push(character);
		      isDoubleQuoted = true;
		    } else if (character == Marker.SINGLE_QUOTE && isQuoted) {
		      stripped.push(character);
		      isSingleQuoted = false;
		    } else if (character == Marker.DOUBLE_QUOTE && isQuoted) {
		      stripped.push(character);
		      isDoubleQuoted = false;
		    } else if (isWhitespace && wasRelation && !spaceAroundRelation) {
		      continue;
		    } else if (!isWhitespace && wasRelation && spaceAroundRelation) {
		      stripped.push(Marker.SPACE);
		      stripped.push(character);
		    } else if (isWhitespace && !wasWhitespace && wasComma && roundBracketLevel > 0 && isSpaceAwarePseudoClass) ; else if (isWhitespace && !wasWhitespace && roundBracketLevel > 0 && isSpaceAwarePseudoClass) {
		      stripped.push(character);
		    } else if (isWhitespace && (isAttribute || roundBracketLevel > 0) && !isQuoted) ; else if (isWhitespace && wasWhitespace && !isQuoted) ; else if ((isNewLineWin || isNewLineNix) && (isAttribute || roundBracketLevel > 0) && isQuoted) ; else if (isRelation && wasWhitespace && !spaceAroundRelation) {
		      stripped.pop();
		      stripped.push(character);
		    } else if (isRelation && !wasWhitespace && spaceAroundRelation) {
		      stripped.push(Marker.SPACE);
		      stripped.push(character);
		    } else if (isWhitespace) {
		      stripped.push(Marker.SPACE);
		    } else {
		      stripped.push(character);
		    }

		    wasEscaped = isEscaped;
		    isEscaped = character == Marker.BACK_SLASH;
		    wasRelation = isRelation;
		    wasWhitespace = isWhitespace;
		    wasComma = character == Marker.COMMA;
		  }

		  return withCaseAttribute
		    ? stripped.join('').replace(CASE_RESTORE_PATTERN, '$1 $2]')
		    : stripped.join('');
		}

		function isPseudoClassWithSelectors(value, colonPosition) {
		  var pseudoClass = value.substring(colonPosition, value.indexOf(Marker.OPEN_ROUND_BRACKET, colonPosition));

		  return PSEUDO_CLASSES_WITH_SELECTORS.indexOf(pseudoClass) > -1;
		}

		function removeQuotes(value) {
		  if (value.indexOf('\'') == -1 && value.indexOf('"') == -1) {
		    return value;
		  }

		  return value
		    .replace(SINGLE_QUOTE_CASE_PATTERN, '=$1 $2')
		    .replace(SINGLE_QUOTE_PATTERN, '=$1$2')
		    .replace(DOUBLE_QUOTE_CASE_PATTERN, '=$1 $2')
		    .replace(DOUBLE_QUOTE_PATTERN, '=$1$2');
		}

		function replacePseudoClasses(value) {
		  return value
		    .replace('nth-child(1)', 'first-child')
		    .replace('nth-of-type(1)', 'first-of-type')
		    .replace('nth-of-type(even)', 'nth-of-type(2n)')
		    .replace('nth-child(even)', 'nth-child(2n)')
		    .replace('nth-of-type(2n+1)', 'nth-of-type(odd)')
		    .replace('nth-child(2n+1)', 'nth-child(odd)')
		    .replace('nth-last-child(1)', 'last-child')
		    .replace('nth-last-of-type(1)', 'last-of-type')
		    .replace('nth-last-of-type(even)', 'nth-last-of-type(2n)')
		    .replace('nth-last-child(even)', 'nth-last-child(2n)')
		    .replace('nth-last-of-type(2n+1)', 'nth-last-of-type(odd)')
		    .replace('nth-last-child(2n+1)', 'nth-last-child(odd)');
		}

		function tidyRules(rules, removeUnsupported, adjacentSpace, format, warnings) {
		  var list = [];
		  var repeated = [];

		  function removeHTMLComment(rule, match) {
		    warnings.push('HTML comment \'' + match + '\' at ' + formatPosition(rule[2][0]) + '. Removing.');
		    return '';
		  }

		  for (var i = 0, l = rules.length; i < l; i++) {
		    var rule = rules[i];
		    var reduced = rule[1];

		    reduced = reduced.replace(HTML_COMMENT_PATTERN, removeHTMLComment.bind(null, rule));

		    if (hasInvalidCharacters(reduced)) {
		      warnings.push('Invalid selector \'' + rule[1] + '\' at ' + formatPosition(rule[2][0]) + '. Ignoring.');
		      continue;
		    }

		    reduced = removeWhitespace(reduced, format);
		    reduced = removeQuotes(reduced);

		    if (adjacentSpace && reduced.indexOf('nav') > 0) {
		      reduced = reduced.replace(/\+nav(\S|$)/, '+ nav$1');
		    }

		    if (removeUnsupported && reduced.indexOf(ASTERISK_PLUS_HTML_HACK) > -1) {
		      continue;
		    }

		    if (removeUnsupported && reduced.indexOf(ASTERISK_FIRST_CHILD_PLUS_HTML_HACK) > -1) {
		      continue;
		    }

		    if (reduced.indexOf('*') > -1) {
		      reduced = reduced
		        .replace(/\*([:#.[])/g, '$1')
		        .replace(/^(:first-child)?\+html/, '*$1+html');
		    }

		    if (repeated.indexOf(reduced) > -1) {
		      continue;
		    }

		    reduced = replacePseudoClasses(reduced);

		    rule[1] = reduced;
		    repeated.push(reduced);
		    list.push(rule);
		  }

		  if (list.length == 1 && list[0][1].length === 0) {
		    warnings.push('Empty selector \'' + list[0][1] + '\' at ' + formatPosition(list[0][2][0]) + '. Ignoring.');
		    list = [];
		  }

		  return list;
		}

		tidyRules_1 = tidyRules;
		return tidyRules_1;
	}

	var tidyBlock_1;
	var hasRequiredTidyBlock;

	function requireTidyBlock () {
		if (hasRequiredTidyBlock) return tidyBlock_1;
		hasRequiredTidyBlock = 1;
		var SUPPORTED_COMPACT_BLOCK_MATCHER = /^@media\W/;
		var SUPPORTED_QUOTE_REMOVAL_MATCHER = /^@(?:keyframes|-moz-keyframes|-o-keyframes|-webkit-keyframes)\W/;

		function tidyBlock(values, spaceAfterClosingBrace) {
		  var withoutSpaceAfterClosingBrace;
		  var withoutQuotes;
		  var i;

		  for (i = values.length - 1; i >= 0; i--) {
		    withoutSpaceAfterClosingBrace = !spaceAfterClosingBrace && SUPPORTED_COMPACT_BLOCK_MATCHER.test(values[i][1]);
		    withoutQuotes = SUPPORTED_QUOTE_REMOVAL_MATCHER.test(values[i][1]);

		    values[i][1] = values[i][1]
		      .replace(/\n|\r\n/g, ' ')
		      .replace(/\s+/g, ' ')
		      .replace(/(,|:|\() /g, '$1')
		      .replace(/ \)/g, ')');

		    if (withoutQuotes) {
		      values[i][1] = values[i][1]
		        .replace(/'([a-zA-Z][a-zA-Z\d\-_]+)'/, '$1')
		        .replace(/"([a-zA-Z][a-zA-Z\d\-_]+)"/, '$1');
		    }

		    if (withoutSpaceAfterClosingBrace) {
		      values[i][1] = values[i][1]
		        .replace(/\) /g, ')');
		    }
		  }

		  return values;
		}

		tidyBlock_1 = tidyBlock;
		return tidyBlock_1;
	}

	var tidyAtRule_1;
	var hasRequiredTidyAtRule;

	function requireTidyAtRule () {
		if (hasRequiredTidyAtRule) return tidyAtRule_1;
		hasRequiredTidyAtRule = 1;
		function tidyAtRule(value) {
		  return value
		    .replace(/\s+/g, ' ')
		    .replace(/url\(\s+/g, 'url(')
		    .replace(/\s+\)/g, ')')
		    .trim();
		}

		tidyAtRule_1 = tidyAtRule;
		return tidyAtRule_1;
	}

	var hack;
	var hasRequiredHack;

	function requireHack () {
		if (hasRequiredHack) return hack;
		hasRequiredHack = 1;
		var Hack = {
		  ASTERISK: 'asterisk',
		  BANG: 'bang',
		  BACKSLASH: 'backslash',
		  UNDERSCORE: 'underscore'
		};

		hack = Hack;
		return hack;
	}

	var removeUnused_1;
	var hasRequiredRemoveUnused;

	function requireRemoveUnused () {
		if (hasRequiredRemoveUnused) return removeUnused_1;
		hasRequiredRemoveUnused = 1;
		function removeUnused(properties) {
		  for (var i = properties.length - 1; i >= 0; i--) {
		    var property = properties[i];

		    if (property.unused) {
		      property.all.splice(property.position, 1);
		    }
		  }
		}

		removeUnused_1 = removeUnused;
		return removeUnused_1;
	}

	var restoreFromOptimizing_1;
	var hasRequiredRestoreFromOptimizing;

	function requireRestoreFromOptimizing () {
		if (hasRequiredRestoreFromOptimizing) return restoreFromOptimizing_1;
		hasRequiredRestoreFromOptimizing = 1;
		var Hack = requireHack();

		var Marker = requireMarker();

		var ASTERISK_HACK = '*';
		var BACKSLASH_HACK = '\\';
		var IMPORTANT_TOKEN = '!important';
		var UNDERSCORE_HACK = '_';
		var BANG_HACK = '!ie';

		function restoreFromOptimizing(properties, restoreCallback) {
		  var property;
		  var restored;
		  var current;
		  var i;

		  for (i = properties.length - 1; i >= 0; i--) {
		    property = properties[i];

		    if (property.dynamic && property.important) {
		      restoreImportant(property);
		      continue;
		    }

		    if (property.dynamic) {
		      continue;
		    }

		    if (property.unused) {
		      continue;
		    }

		    if (!property.dirty && !property.important && !property.hack) {
		      continue;
		    }

		    if (property.optimizable && restoreCallback) {
		      restored = restoreCallback(property);
		      property.value = restored;
		    } else {
		      restored = property.value;
		    }

		    if (property.important) {
		      restoreImportant(property);
		    }

		    if (property.hack) {
		      restoreHack(property);
		    }

		    if ('all' in property) {
		      current = property.all[property.position];
		      current[1][1] = property.name;

		      current.splice(2, current.length - 1);
		      Array.prototype.push.apply(current, restored);
		    }
		  }
		}

		function restoreImportant(property) {
		  property.value[property.value.length - 1][1] += IMPORTANT_TOKEN;
		}

		function restoreHack(property) {
		  if (property.hack[0] == Hack.UNDERSCORE) {
		    property.name = UNDERSCORE_HACK + property.name;
		  } else if (property.hack[0] == Hack.ASTERISK) {
		    property.name = ASTERISK_HACK + property.name;
		  } else if (property.hack[0] == Hack.BACKSLASH) {
		    property.value[property.value.length - 1][1] += BACKSLASH_HACK + property.hack[1];
		  } else if (property.hack[0] == Hack.BANG) {
		    property.value[property.value.length - 1][1] += Marker.SPACE + BANG_HACK;
		  }
		}

		restoreFromOptimizing_1 = restoreFromOptimizing;
		return restoreFromOptimizing_1;
	}

	var token;
	var hasRequiredToken;

	function requireToken () {
		if (hasRequiredToken) return token;
		hasRequiredToken = 1;
		var Token = {
		  AT_RULE: 'at-rule', // e.g. `@import`, `@charset`
		  AT_RULE_BLOCK: 'at-rule-block', // e.g. `@font-face{...}`
		  AT_RULE_BLOCK_SCOPE: 'at-rule-block-scope', // e.g. `@font-face`
		  COMMENT: 'comment', // e.g. `/* comment */`
		  NESTED_BLOCK: 'nested-block', // e.g. `@media screen{...}`, `@keyframes animation {...}`
		  NESTED_BLOCK_SCOPE: 'nested-block-scope', // e.g. `@media`, `@keyframes`
		  PROPERTY: 'property', // e.g. `color:red`
		  PROPERTY_BLOCK: 'property-block', // e.g. `--var:{color:red}`
		  PROPERTY_NAME: 'property-name', // e.g. `color`
		  PROPERTY_VALUE: 'property-value', // e.g. `red`
		  RAW: 'raw', // e.g. anything between /* clean-css ignore:start */ and /* clean-css ignore:end */ comments
		  RULE: 'rule', // e.g `div > a{...}`
		  RULE_SCOPE: 'rule-scope' // e.g `div > a`
		};

		token = Token;
		return token;
	}

	var wrapForOptimizing;
	var hasRequiredWrapForOptimizing;

	function requireWrapForOptimizing () {
		if (hasRequiredWrapForOptimizing) return wrapForOptimizing;
		hasRequiredWrapForOptimizing = 1;
		var Hack = requireHack();

		var Marker = requireMarker();
		var Token = requireToken();

		var Match = {
		  ASTERISK: '*',
		  BACKSLASH: '\\',
		  BANG: '!',
		  BANG_SUFFIX_PATTERN: /!\w+$/,
		  IMPORTANT_TOKEN_PATTERN: new RegExp('!important$', 'i'),
		  IMPORTANT_WORD_PATTERN: new RegExp('important$', 'i'),
		  SUFFIX_BANG_PATTERN: /!$/,
		  UNDERSCORE: '_',
		  VARIABLE_REFERENCE_PATTERN: /var\(--.+\)$/
		};

		function wrapAll(properties, skipProperties) {
		  var wrapped = [];
		  var single;
		  var property;
		  var i;

		  for (i = properties.length - 1; i >= 0; i--) {
		    property = properties[i];

		    if (property[0] != Token.PROPERTY) {
		      continue;
		    }

		    if (skipProperties && skipProperties.indexOf(property[1][1]) > -1) {
		      continue;
		    }

		    single = wrapSingle(property);
		    single.all = properties;
		    single.position = i;
		    wrapped.unshift(single);
		  }

		  return wrapped;
		}

		function someVariableReferences(property) {
		  var i, l;
		  var value;

		  // skipping `property` and property name tokens
		  for (i = 2, l = property.length; i < l; i++) {
		    value = property[i];

		    if (value[0] != Token.PROPERTY_VALUE) {
		      continue;
		    }

		    if (isVariableReference(value[1])) {
		      return true;
		    }
		  }

		  return false;
		}

		function isVariableReference(value) {
		  return Match.VARIABLE_REFERENCE_PATTERN.test(value);
		}

		function isMultiplex(property) {
		  var value;
		  var i, l;

		  for (i = 3, l = property.length; i < l; i++) {
		    value = property[i];

		    if (value[0] == Token.PROPERTY_VALUE && (value[1] == Marker.COMMA || value[1] == Marker.FORWARD_SLASH)) {
		      return true;
		    }
		  }

		  return false;
		}

		function hackFrom(property) {
		  var match = false;
		  var name = property[1][1];
		  var lastValue = property[property.length - 1];

		  if (name[0] == Match.UNDERSCORE) {
		    match = [Hack.UNDERSCORE];
		  } else if (name[0] == Match.ASTERISK) {
		    match = [Hack.ASTERISK];
		  } else if (lastValue[1][0] == Match.BANG && !lastValue[1].match(Match.IMPORTANT_WORD_PATTERN)) {
		    match = [Hack.BANG];
		  } else if (lastValue[1].indexOf(Match.BANG) > 0
		    && !lastValue[1].match(Match.IMPORTANT_WORD_PATTERN)
		    && Match.BANG_SUFFIX_PATTERN.test(lastValue[1])) {
		    match = [Hack.BANG];
		  } else if (lastValue[1].indexOf(Match.BACKSLASH) > 0
		    && lastValue[1].indexOf(Match.BACKSLASH) == lastValue[1].length - Match.BACKSLASH.length - 1) {
		    match = [Hack.BACKSLASH, lastValue[1].substring(lastValue[1].indexOf(Match.BACKSLASH) + 1)];
		  } else if (lastValue[1].indexOf(Match.BACKSLASH) === 0 && lastValue[1].length == 2) {
		    match = [Hack.BACKSLASH, lastValue[1].substring(1)];
		  }

		  return match;
		}

		function isImportant(property) {
		  if (property.length < 3) { return false; }

		  var lastValue = property[property.length - 1];
		  if (Match.IMPORTANT_TOKEN_PATTERN.test(lastValue[1])) {
		    return true;
		  } if (Match.IMPORTANT_WORD_PATTERN.test(lastValue[1])
		    && Match.SUFFIX_BANG_PATTERN.test(property[property.length - 2][1])) {
		    return true;
		  }

		  return false;
		}

		function stripImportant(property) {
		  var lastValue = property[property.length - 1];
		  var oneButLastValue = property[property.length - 2];

		  if (Match.IMPORTANT_TOKEN_PATTERN.test(lastValue[1])) {
		    lastValue[1] = lastValue[1].replace(Match.IMPORTANT_TOKEN_PATTERN, '');
		  } else {
		    lastValue[1] = lastValue[1].replace(Match.IMPORTANT_WORD_PATTERN, '');
		    oneButLastValue[1] = oneButLastValue[1].replace(Match.SUFFIX_BANG_PATTERN, '');
		  }

		  if (lastValue[1].length === 0) {
		    property.pop();
		  }

		  if (oneButLastValue[1].length === 0) {
		    property.pop();
		  }
		}

		function stripPrefixHack(property) {
		  property[1][1] = property[1][1].substring(1);
		}

		function stripSuffixHack(property, hackFrom) {
		  var lastValue = property[property.length - 1];
		  lastValue[1] = lastValue[1]
		    .substring(0, lastValue[1].indexOf(hackFrom[0] == Hack.BACKSLASH ? Match.BACKSLASH : Match.BANG))
		    .trim();

		  if (lastValue[1].length === 0) {
		    property.pop();
		  }
		}

		function wrapSingle(property) {
		  var importantProperty = isImportant(property);
		  if (importantProperty) {
		    stripImportant(property);
		  }

		  var whichHack = hackFrom(property);
		  if (whichHack[0] == Hack.ASTERISK || whichHack[0] == Hack.UNDERSCORE) {
		    stripPrefixHack(property);
		  } else if (whichHack[0] == Hack.BACKSLASH || whichHack[0] == Hack.BANG) {
		    stripSuffixHack(property, whichHack);
		  }

		  return {
		    block: property[2] && property[2][0] == Token.PROPERTY_BLOCK,
		    components: [],
		    dirty: false,
		    dynamic: someVariableReferences(property),
		    hack: whichHack,
		    important: importantProperty,
		    name: property[1][1],
		    multiplex: property.length > 3 ? isMultiplex(property) : false,
		    optimizable: true,
		    position: 0,
		    shorthand: false,
		    unused: false,
		    value: property.slice(2)
		  };
		}

		wrapForOptimizing = {
		  all: wrapAll,
		  single: wrapSingle
		};
		return wrapForOptimizing;
	}

	var invalidPropertyError;
	var hasRequiredInvalidPropertyError;

	function requireInvalidPropertyError () {
		if (hasRequiredInvalidPropertyError) return invalidPropertyError;
		hasRequiredInvalidPropertyError = 1;
		function InvalidPropertyError(message) {
		  this.name = 'InvalidPropertyError';
		  this.message = message;
		  this.stack = (new Error()).stack;
		}

		InvalidPropertyError.prototype = Object.create(Error.prototype);
		InvalidPropertyError.prototype.constructor = InvalidPropertyError;

		invalidPropertyError = InvalidPropertyError;
		return invalidPropertyError;
	}

	var breakUp;
	var hasRequiredBreakUp;

	function requireBreakUp () {
		if (hasRequiredBreakUp) return breakUp;
		hasRequiredBreakUp = 1;
		var InvalidPropertyError = requireInvalidPropertyError();

		var wrapSingle = requireWrapForOptimizing().single;

		var Token = requireToken();
		var Marker = requireMarker();

		var formatPosition = requireFormatPosition();

		function _anyIsInherit(values) {
		  var i, l;

		  for (i = 0, l = values.length; i < l; i++) {
		    if (values[i][1] == 'inherit') {
		      return true;
		    }
		  }

		  return false;
		}

		function _colorFilter(validator) {
		  return function(value) {
		    return value[1] == 'invert' || validator.isColor(value[1]) || validator.isPrefixed(value[1]);
		  };
		}

		function _styleFilter(validator) {
		  return function(value) {
		    return value[1] != 'inherit' && validator.isStyleKeyword(value[1]) && !validator.isColorFunction(value[1]);
		  };
		}

		function _wrapDefault(name, property, configuration) {
		  var descriptor = configuration[name];
		  if (descriptor.doubleValues && descriptor.defaultValue.length == 2) {
		    return wrapSingle([
		      Token.PROPERTY,
		      [Token.PROPERTY_NAME, name],
		      [Token.PROPERTY_VALUE, descriptor.defaultValue[0]],
		      [Token.PROPERTY_VALUE, descriptor.defaultValue[1]]
		    ]);
		  } if (descriptor.doubleValues && descriptor.defaultValue.length == 1) {
		    return wrapSingle([
		      Token.PROPERTY,
		      [Token.PROPERTY_NAME, name],
		      [Token.PROPERTY_VALUE, descriptor.defaultValue[0]]
		    ]);
		  }
		  return wrapSingle([
		    Token.PROPERTY,
		    [Token.PROPERTY_NAME, name],
		    [Token.PROPERTY_VALUE, descriptor.defaultValue]
		  ]);
		}

		function _widthFilter(validator) {
		  return function(value) {
		    return value[1] != 'inherit'
		      && (validator.isWidth(value[1]) || validator.isUnit(value[1]) || validator.isDynamicUnit(value[1]))
		      && !validator.isStyleKeyword(value[1])
		      && !validator.isColorFunction(value[1]);
		  };
		}

		function animation(property, configuration, validator) {
		  var duration = _wrapDefault(property.name + '-duration', property, configuration);
		  var timing = _wrapDefault(property.name + '-timing-function', property, configuration);
		  var delay = _wrapDefault(property.name + '-delay', property, configuration);
		  var iteration = _wrapDefault(property.name + '-iteration-count', property, configuration);
		  var direction = _wrapDefault(property.name + '-direction', property, configuration);
		  var fill = _wrapDefault(property.name + '-fill-mode', property, configuration);
		  var play = _wrapDefault(property.name + '-play-state', property, configuration);
		  var name = _wrapDefault(property.name + '-name', property, configuration);
		  var components = [duration, timing, delay, iteration, direction, fill, play, name];
		  var values = property.value;
		  var value;
		  var durationSet = false;
		  var timingSet = false;
		  var delaySet = false;
		  var iterationSet = false;
		  var directionSet = false;
		  var fillSet = false;
		  var playSet = false;
		  var nameSet = false;
		  var i;
		  var l;

		  if (property.value.length == 1 && property.value[0][1] == 'inherit') {
		    // eslint-disable-next-line max-len
		    duration.value = timing.value = delay.value = iteration.value = direction.value = fill.value = play.value = name.value = property.value;
		    return components;
		  }

		  if (values.length > 1 && _anyIsInherit(values)) {
		    throw new InvalidPropertyError('Invalid animation values at ' + formatPosition(values[0][2][0]) + '. Ignoring.');
		  }

		  for (i = 0, l = values.length; i < l; i++) {
		    value = values[i];

		    if (validator.isTime(value[1]) && !durationSet) {
		      duration.value = [value];
		      durationSet = true;
		    } else if (validator.isTime(value[1]) && !delaySet) {
		      delay.value = [value];
		      delaySet = true;
		    } else if ((validator.isGlobal(value[1]) || validator.isTimingFunction(value[1])) && !timingSet) {
		      timing.value = [value];
		      timingSet = true;
		    } else if ((validator.isAnimationIterationCountKeyword(value[1])
		      || validator.isPositiveNumber(value[1]))
		      && !iterationSet) {
		      iteration.value = [value];
		      iterationSet = true;
		    } else if (validator.isAnimationDirectionKeyword(value[1]) && !directionSet) {
		      direction.value = [value];
		      directionSet = true;
		    } else if (validator.isAnimationFillModeKeyword(value[1]) && !fillSet) {
		      fill.value = [value];
		      fillSet = true;
		    } else if (validator.isAnimationPlayStateKeyword(value[1]) && !playSet) {
		      play.value = [value];
		      playSet = true;
		    } else if ((validator.isAnimationNameKeyword(value[1]) || validator.isIdentifier(value[1])) && !nameSet) {
		      name.value = [value];
		      nameSet = true;
		    } else {
		      throw new InvalidPropertyError('Invalid animation value at ' + formatPosition(value[2][0]) + '. Ignoring.');
		    }
		  }

		  return components;
		}

		function background(property, configuration, validator) {
		  var image = _wrapDefault('background-image', property, configuration);
		  var position = _wrapDefault('background-position', property, configuration);
		  var size = _wrapDefault('background-size', property, configuration);
		  var repeat = _wrapDefault('background-repeat', property, configuration);
		  var attachment = _wrapDefault('background-attachment', property, configuration);
		  var origin = _wrapDefault('background-origin', property, configuration);
		  var clip = _wrapDefault('background-clip', property, configuration);
		  var color = _wrapDefault('background-color', property, configuration);
		  var components = [image, position, size, repeat, attachment, origin, clip, color];
		  var values = property.value;

		  var positionSet = false;
		  var clipSet = false;
		  var originSet = false;
		  var repeatSet = false;

		  var anyValueSet = false;

		  if (property.value.length == 1 && property.value[0][1] == 'inherit') {
		    // NOTE: 'inherit' is not a valid value for background-attachment
		    color.value = image.value = repeat.value = position.value = size.value = origin.value = clip.value = property.value;
		    return components;
		  }

		  if (property.value.length == 1 && property.value[0][1] == '0 0') {
		    return components;
		  }

		  for (var i = values.length - 1; i >= 0; i--) {
		    var value = values[i];

		    if (validator.isBackgroundAttachmentKeyword(value[1])) {
		      attachment.value = [value];
		      anyValueSet = true;
		    } else if (validator.isBackgroundClipKeyword(value[1]) || validator.isBackgroundOriginKeyword(value[1])) {
		      if (clipSet) {
		        origin.value = [value];
		        originSet = true;
		      } else {
		        clip.value = [value];
		        clipSet = true;
		      }
		      anyValueSet = true;
		    } else if (validator.isBackgroundRepeatKeyword(value[1])) {
		      if (repeatSet) {
		        repeat.value.unshift(value);
		      } else {
		        repeat.value = [value];
		        repeatSet = true;
		      }
		      anyValueSet = true;
		    } else if (validator.isBackgroundPositionKeyword(value[1])
		    || validator.isBackgroundSizeKeyword(value[1])
		    || validator.isUnit(value[1])
		    || validator.isDynamicUnit(value[1])) {
		      if (i > 0) {
		        var previousValue = values[i - 1];

		        if (previousValue[1] == Marker.FORWARD_SLASH) {
		          size.value = [value];
		        } else if (i > 1 && values[i - 2][1] == Marker.FORWARD_SLASH) {
		          size.value = [previousValue, value];
		          i -= 2;
		        } else {
		          if (!positionSet) { position.value = []; }

		          position.value.unshift(value);
		          positionSet = true;
		        }
		      } else {
		        if (!positionSet) { position.value = []; }

		        position.value.unshift(value);
		        positionSet = true;
		      }
		      anyValueSet = true;
		    } else if ((color.value[0][1] == configuration[color.name].defaultValue || color.value[0][1] == 'none') && (validator.isColor(value[1]) || validator.isPrefixed(value[1]))) {
		      color.value = [value];
		      anyValueSet = true;
		    } else if (validator.isUrl(value[1]) || validator.isFunction(value[1])) {
		      image.value = [value];
		      anyValueSet = true;
		    }
		  }

		  if (clipSet && !originSet) { origin.value = clip.value.slice(0); }

		  if (!anyValueSet) {
		    throw new InvalidPropertyError('Invalid background value at ' + formatPosition(values[0][2][0]) + '. Ignoring.');
		  }

		  return components;
		}

		function borderRadius(property, configuration) {
		  var values = property.value;
		  var splitAt = -1;

		  for (var i = 0, l = values.length; i < l; i++) {
		    if (values[i][1] == Marker.FORWARD_SLASH) {
		      splitAt = i;
		      break;
		    }
		  }

		  if (splitAt === 0 || splitAt === values.length - 1) {
		    throw new InvalidPropertyError('Invalid border-radius value at ' + formatPosition(values[0][2][0]) + '. Ignoring.');
		  }

		  var target = _wrapDefault(property.name, property, configuration);
		  target.value = splitAt > -1
		    ? values.slice(0, splitAt)
		    : values.slice(0);
		  target.components = fourValues(target, configuration);

		  var remainder = _wrapDefault(property.name, property, configuration);
		  remainder.value = splitAt > -1
		    ? values.slice(splitAt + 1)
		    : values.slice(0);
		  remainder.components = fourValues(remainder, configuration);

		  for (var j = 0; j < 4; j++) {
		    target.components[j].multiplex = true;
		    target.components[j].value = target.components[j].value.concat(remainder.components[j].value);
		  }

		  return target.components;
		}

		function font(property, configuration, validator) {
		  var style = _wrapDefault('font-style', property, configuration);
		  var variant = _wrapDefault('font-variant', property, configuration);
		  var weight = _wrapDefault('font-weight', property, configuration);
		  var stretch = _wrapDefault('font-stretch', property, configuration);
		  var size = _wrapDefault('font-size', property, configuration);
		  var height = _wrapDefault('line-height', property, configuration);
		  var family = _wrapDefault('font-family', property, configuration);
		  var components = [style, variant, weight, stretch, size, height, family];
		  var values = property.value;
		  var fuzzyMatched = 4; // style, variant, weight, and stretch
		  var index = 0;
		  var isStretchSet = false;
		  var isStretchValid;
		  var isStyleSet = false;
		  var isStyleValid;
		  var isVariantSet = false;
		  var isVariantValid;
		  var isWeightSet = false;
		  var isWeightValid;
		  var appendableFamilyName = false;

		  if (!values[index]) {
		    throw new InvalidPropertyError('Missing font values at ' + formatPosition(property.all[property.position][1][2][0]) + '. Ignoring.');
		  }

		  if (values.length == 1 && values[0][1] == 'inherit') {
		    style.value = variant.value = weight.value = stretch.value = size.value = height.value = family.value = values;
		    return components;
		  }

		  if (values.length == 1
		    && (validator.isFontKeyword(values[0][1])
		    || validator.isGlobal(values[0][1])
		    || validator.isPrefixed(values[0][1]))
		  ) {
		    values[0][1] = Marker.INTERNAL + values[0][1];
		    style.value = variant.value = weight.value = stretch.value = size.value = height.value = family.value = values;
		    return components;
		  }

		  if (values.length < 2 || !_anyIsFontSize(values, validator) || !_anyIsFontFamily(values, validator)) {
		    throw new InvalidPropertyError('Invalid font values at ' + formatPosition(property.all[property.position][1][2][0]) + '. Ignoring.');
		  }

		  if (values.length > 1 && _anyIsInherit(values)) {
		    throw new InvalidPropertyError('Invalid font values at ' + formatPosition(values[0][2][0]) + '. Ignoring.');
		  }

		  // fuzzy match style, variant, weight, and stretch on first elements
		  while (index < fuzzyMatched) {
		    isStretchValid = validator.isFontStretchKeyword(values[index][1]) || validator.isGlobal(values[index][1]);
		    isStyleValid = validator.isFontStyleKeyword(values[index][1]) || validator.isGlobal(values[index][1]);
		    isVariantValid = validator.isFontVariantKeyword(values[index][1]) || validator.isGlobal(values[index][1]);
		    isWeightValid = validator.isFontWeightKeyword(values[index][1]) || validator.isGlobal(values[index][1]);

		    if (isStyleValid && !isStyleSet) {
		      style.value = [values[index]];
		      isStyleSet = true;
		    } else if (isVariantValid && !isVariantSet) {
		      variant.value = [values[index]];
		      isVariantSet = true;
		    } else if (isWeightValid && !isWeightSet) {
		      weight.value = [values[index]];
		      isWeightSet = true;
		    } else if (isStretchValid && !isStretchSet) {
		      stretch.value = [values[index]];
		      isStretchSet = true;
		    } else if (isStyleValid
		      && isStyleSet
		      || isVariantValid
		      && isVariantSet
		      || isWeightValid
		      && isWeightSet
		      || isStretchValid
		      && isStretchSet) {
		      throw new InvalidPropertyError('Invalid font style / variant / weight / stretch value at ' + formatPosition(values[0][2][0]) + '. Ignoring.');
		    } else {
		      break;
		    }

		    index++;
		  }

		  // now comes font-size ...
		  if (validator.isFontSizeKeyword(values[index][1])
		    || validator.isUnit(values[index][1])
		    && !validator.isDynamicUnit(values[index][1])) {
		    size.value = [values[index]];
		    index++;
		  } else {
		    throw new InvalidPropertyError('Missing font size at ' + formatPosition(values[0][2][0]) + '. Ignoring.');
		  }

		  if (!values[index]) {
		    throw new InvalidPropertyError('Missing font family at ' + formatPosition(values[0][2][0]) + '. Ignoring.');
		  }

		  // ... and perhaps line-height
		  if (values[index]
		    && values[index][1] == Marker.FORWARD_SLASH
		    && values[index + 1]
		    && (validator.isLineHeightKeyword(values[index + 1][1])
		    || validator.isUnit(values[index + 1][1])
		    || validator.isNumber(values[index + 1][1]))) {
		    height.value = [values[index + 1]];
		    index++;
		    index++;
		  }

		  // ... and whatever comes next is font-family
		  family.value = [];

		  while (values[index]) {
		    if (values[index][1] == Marker.COMMA) {
		      appendableFamilyName = false;
		    } else {
		      if (appendableFamilyName) {
		        family.value[family.value.length - 1][1] += Marker.SPACE + values[index][1];
		      } else {
		        family.value.push(values[index]);
		      }

		      appendableFamilyName = true;
		    }

		    index++;
		  }

		  if (family.value.length === 0) {
		    throw new InvalidPropertyError('Missing font family at ' + formatPosition(values[0][2][0]) + '. Ignoring.');
		  }

		  return components;
		}

		function _anyIsFontSize(values, validator) {
		  var value;
		  var i, l;

		  for (i = 0, l = values.length; i < l; i++) {
		    value = values[i];

		    if (validator.isFontSizeKeyword(value[1])
		      || validator.isUnit(value[1])
		      && !validator.isDynamicUnit(value[1])
		      || validator.isFunction(value[1])) {
		      return true;
		    }
		  }

		  return false;
		}

		function _anyIsFontFamily(values, validator) {
		  var value;
		  var i, l;

		  for (i = 0, l = values.length; i < l; i++) {
		    value = values[i];

		    if (validator.isIdentifier(value[1]) || validator.isQuotedText(value[1])) {
		      return true;
		    }
		  }

		  return false;
		}

		function fourValues(property, configuration) {
		  var componentNames = configuration[property.name].components;
		  var components = [];
		  var value = property.value;

		  if (value.length < 1) { return []; }

		  if (value.length < 2) { value[1] = value[0].slice(0); }
		  if (value.length < 3) { value[2] = value[0].slice(0); }
		  if (value.length < 4) { value[3] = value[1].slice(0); }

		  for (var i = componentNames.length - 1; i >= 0; i--) {
		    var component = wrapSingle([
		      Token.PROPERTY,
		      [Token.PROPERTY_NAME, componentNames[i]]
		    ]);
		    component.value = [value[i]];
		    components.unshift(component);
		  }

		  return components;
		}

		function multiplex(splitWith) {
		  return function(property, configuration, validator) {
		    var splitsAt = [];
		    var values = property.value;
		    var i, j, l, m;

		    // find split commas
		    for (i = 0, l = values.length; i < l; i++) {
		      if (values[i][1] == ',') { splitsAt.push(i); }
		    }

		    if (splitsAt.length === 0) { return splitWith(property, configuration, validator); }

		    var splitComponents = [];

		    // split over commas, and into components
		    for (i = 0, l = splitsAt.length; i <= l; i++) {
		      var from = i === 0 ? 0 : splitsAt[i - 1] + 1;
		      var to = i < l ? splitsAt[i] : values.length;

		      var _property = _wrapDefault(property.name, property, configuration);
		      _property.value = values.slice(from, to);

		      if (_property.value.length > 0) {
		        splitComponents.push(splitWith(_property, configuration, validator));
		      }
		    }

		    var components = splitComponents[0];

		    // group component values from each split
		    for (i = 0, l = components.length; i < l; i++) {
		      components[i].multiplex = true;

		      for (j = 1, m = splitComponents.length; j < m; j++) {
		        components[i].value.push([Token.PROPERTY_VALUE, Marker.COMMA]);
		        Array.prototype.push.apply(components[i].value, splitComponents[j][i].value);
		      }
		    }

		    return components;
		  };
		}

		function listStyle(property, configuration, validator) {
		  var type = _wrapDefault('list-style-type', property, configuration);
		  var position = _wrapDefault('list-style-position', property, configuration);
		  var image = _wrapDefault('list-style-image', property, configuration);
		  var components = [type, position, image];

		  if (property.value.length == 1 && property.value[0][1] == 'inherit') {
		    type.value = position.value = image.value = [property.value[0]];
		    return components;
		  }

		  var values = property.value.slice(0);
		  var total = values.length;
		  var index = 0;

		  // `image` first...
		  for (index = 0, total = values.length; index < total; index++) {
		    if (validator.isUrl(values[index][1]) || values[index][1] == '0') {
		      image.value = [values[index]];
		      values.splice(index, 1);
		      break;
		    }
		  }

		  // ... then `position`
		  for (index = 0, total = values.length; index < total; index++) {
		    if (validator.isListStylePositionKeyword(values[index][1])) {
		      position.value = [values[index]];
		      values.splice(index, 1);
		      break;
		    }
		  }

		  // ... and what's left is a `type`
		  if (values.length > 0 && (validator.isListStyleTypeKeyword(values[0][1]) || validator.isIdentifier(values[0][1]))) {
		    type.value = [values[0]];
		  }

		  return components;
		}

		function transition(property, configuration, validator) {
		  var prop = _wrapDefault(property.name + '-property', property, configuration);
		  var duration = _wrapDefault(property.name + '-duration', property, configuration);
		  var timing = _wrapDefault(property.name + '-timing-function', property, configuration);
		  var delay = _wrapDefault(property.name + '-delay', property, configuration);
		  var components = [prop, duration, timing, delay];
		  var values = property.value;
		  var value;
		  var durationSet = false;
		  var delaySet = false;
		  var propSet = false;
		  var timingSet = false;
		  var i;
		  var l;

		  if (property.value.length == 1 && property.value[0][1] == 'inherit') {
		    prop.value = duration.value = timing.value = delay.value = property.value;
		    return components;
		  }

		  if (values.length > 1 && _anyIsInherit(values)) {
		    throw new InvalidPropertyError('Invalid animation values at ' + formatPosition(values[0][2][0]) + '. Ignoring.');
		  }

		  for (i = 0, l = values.length; i < l; i++) {
		    value = values[i];

		    if (validator.isTime(value[1]) && !durationSet) {
		      duration.value = [value];
		      durationSet = true;
		    } else if (validator.isTime(value[1]) && !delaySet) {
		      delay.value = [value];
		      delaySet = true;
		    } else if ((validator.isGlobal(value[1]) || validator.isTimingFunction(value[1])) && !timingSet) {
		      timing.value = [value];
		      timingSet = true;
		    } else if (validator.isIdentifier(value[1]) && !propSet) {
		      prop.value = [value];
		      propSet = true;
		    } else {
		      throw new InvalidPropertyError('Invalid animation value at ' + formatPosition(value[2][0]) + '. Ignoring.');
		    }
		  }

		  return components;
		}

		function widthStyleColor(property, configuration, validator) {
		  var descriptor = configuration[property.name];
		  var components = [
		    _wrapDefault(descriptor.components[0], property, configuration),
		    _wrapDefault(descriptor.components[1], property, configuration),
		    _wrapDefault(descriptor.components[2], property, configuration)
		  ];
		  var color, style, width;

		  for (var i = 0; i < 3; i++) {
		    var component = components[i];

		    if (component.name.indexOf('color') > 0) { color = component; } else if (component.name.indexOf('style') > 0) { style = component; } else { width = component; }
		  }

		  if ((property.value.length == 1 && property.value[0][1] == 'inherit')
		      || (property.value.length == 3 && property.value[0][1] == 'inherit' && property.value[1][1] == 'inherit' && property.value[2][1] == 'inherit')) {
		    color.value = style.value = width.value = [property.value[0]];
		    return components;
		  }

		  var values = property.value.slice(0);
		  var match, matches;

		  // NOTE: usually users don't follow the required order of parts in this shorthand,
		  // so we'll try to parse it caring as little about order as possible

		  if (values.length > 0) {
		    matches = values.filter(_widthFilter(validator));
		    match = matches.length > 1 && (matches[0][1] == 'none' || matches[0][1] == 'auto') ? matches[1] : matches[0];
		    if (match) {
		      width.value = [match];
		      values.splice(values.indexOf(match), 1);
		    }
		  }

		  if (values.length > 0) {
		    match = values.filter(_styleFilter(validator))[0];
		    if (match) {
		      style.value = [match];
		      values.splice(values.indexOf(match), 1);
		    }
		  }

		  if (values.length > 0) {
		    match = values.filter(_colorFilter(validator))[0];
		    if (match) {
		      color.value = [match];
		      values.splice(values.indexOf(match), 1);
		    }
		  }

		  return components;
		}

		breakUp = {
		  animation: animation,
		  background: background,
		  border: widthStyleColor,
		  borderRadius: borderRadius,
		  font: font,
		  fourValues: fourValues,
		  listStyle: listStyle,
		  multiplex: multiplex,
		  outline: widthStyleColor,
		  transition: transition
		};
		return breakUp;
	}

	var vendorPrefixes;
	var hasRequiredVendorPrefixes;

	function requireVendorPrefixes () {
		if (hasRequiredVendorPrefixes) return vendorPrefixes;
		hasRequiredVendorPrefixes = 1;
		var VENDOR_PREFIX_PATTERN = /(?:^|\W)(-\w+-)/g;

		function unique(value) {
		  var prefixes = [];
		  var match;

		  // eslint-disable-next-line no-cond-assign
		  while ((match = VENDOR_PREFIX_PATTERN.exec(value)) !== null) {
		    if (prefixes.indexOf(match[0]) == -1) {
		      prefixes.push(match[0]);
		    }
		  }

		  return prefixes;
		}

		function same(value1, value2) {
		  return unique(value1).sort().join(',') == unique(value2).sort().join(',');
		}

		vendorPrefixes = {
		  unique: unique,
		  same: same
		};
		return vendorPrefixes;
	}

	var understandable_1;
	var hasRequiredUnderstandable;

	function requireUnderstandable () {
		if (hasRequiredUnderstandable) return understandable_1;
		hasRequiredUnderstandable = 1;
		var sameVendorPrefixes = requireVendorPrefixes().same;

		function understandable(validator, value1, value2, _position, isPaired) {
		  if (!sameVendorPrefixes(value1, value2)) {
		    return false;
		  }

		  if (isPaired && validator.isVariable(value1) !== validator.isVariable(value2)) {
		    return false;
		  }

		  return true;
		}

		understandable_1 = understandable;
		return understandable_1;
	}

	var canOverride;
	var hasRequiredCanOverride;

	function requireCanOverride () {
		if (hasRequiredCanOverride) return canOverride;
		hasRequiredCanOverride = 1;
		var understandable = requireUnderstandable();

		function animationIterationCount(validator, value1, value2) {
		  if (!understandable(validator, value1, value2, 0, true)
		    && !(validator.isAnimationIterationCountKeyword(value2) || validator.isPositiveNumber(value2))) {
		    return false;
		  } if (validator.isVariable(value1) && validator.isVariable(value2)) {
		    return true;
		  }

		  return validator.isAnimationIterationCountKeyword(value2) || validator.isPositiveNumber(value2);
		}

		function animationName(validator, value1, value2) {
		  if (!understandable(validator, value1, value2, 0, true)
		    && !(validator.isAnimationNameKeyword(value2) || validator.isIdentifier(value2))) {
		    return false;
		  } if (validator.isVariable(value1) && validator.isVariable(value2)) {
		    return true;
		  }

		  return validator.isAnimationNameKeyword(value2) || validator.isIdentifier(value2);
		}

		function areSameFunction(validator, value1, value2) {
		  if (!validator.isFunction(value1) || !validator.isFunction(value2)) {
		    return false;
		  }

		  var function1Name = value1.substring(0, value1.indexOf('('));
		  var function2Name = value2.substring(0, value2.indexOf('('));

		  var function1Value = value1.substring(function1Name.length + 1, value1.length - 1);
		  var function2Value = value2.substring(function2Name.length + 1, value2.length - 1);

		  if (validator.isFunction(function1Value) || validator.isFunction(function2Value)) {
		    return function1Name === function2Name && areSameFunction(validator, function1Value, function2Value);
		  }
		  return function1Name === function2Name;
		}

		function backgroundPosition(validator, value1, value2) {
		  if (!understandable(validator, value1, value2, 0, true)
		    && !(validator.isBackgroundPositionKeyword(value2) || validator.isGlobal(value2))) {
		    return false;
		  } if (validator.isVariable(value1) && validator.isVariable(value2)) {
		    return true;
		  } if (validator.isBackgroundPositionKeyword(value2) || validator.isGlobal(value2)) {
		    return true;
		  }

		  return unit(validator, value1, value2);
		}

		function backgroundSize(validator, value1, value2) {
		  if (!understandable(validator, value1, value2, 0, true)
		    && !(validator.isBackgroundSizeKeyword(value2) || validator.isGlobal(value2))) {
		    return false;
		  } if (validator.isVariable(value1) && validator.isVariable(value2)) {
		    return true;
		  } if (validator.isBackgroundSizeKeyword(value2) || validator.isGlobal(value2)) {
		    return true;
		  }

		  return unit(validator, value1, value2);
		}

		function color(validator, value1, value2) {
		  if (!understandable(validator, value1, value2, 0, true) && !validator.isColor(value2)) {
		    return false;
		  } if (validator.isVariable(value1) && validator.isVariable(value2)) {
		    return true;
		  } if (!validator.colorOpacity && (validator.isRgbColor(value1) || validator.isHslColor(value1))) {
		    return false;
		  } if (!validator.colorOpacity && (validator.isRgbColor(value2) || validator.isHslColor(value2))) {
		    return false;
		  } if (!validator.colorHexAlpha && (validator.isHexAlphaColor(value1) || validator.isHexAlphaColor(value2))) {
		    return false;
		  } if (validator.isColor(value1) && validator.isColor(value2)) {
		    return true;
		  }

		  return sameFunctionOrValue(validator, value1, value2);
		}

		function components(overrideCheckers) {
		  return function(validator, value1, value2, position) {
		    return overrideCheckers[position](validator, value1, value2);
		  };
		}

		function fontFamily(validator, value1, value2) {
		  return understandable(validator, value1, value2, 0, true);
		}

		function image(validator, value1, value2) {
		  if (!understandable(validator, value1, value2, 0, true) && !validator.isImage(value2)) {
		    return false;
		  } if (validator.isVariable(value1) && validator.isVariable(value2)) {
		    return true;
		  } if (validator.isImage(value2)) {
		    return true;
		  } if (validator.isImage(value1)) {
		    return false;
		  }

		  return sameFunctionOrValue(validator, value1, value2);
		}

		function keyword(propertyName) {
		  return function(validator, value1, value2) {
		    if (!understandable(validator, value1, value2, 0, true) && !validator.isKeyword(propertyName)(value2)) {
		      return false;
		    } if (validator.isVariable(value1) && validator.isVariable(value2)) {
		      return true;
		    }

		    return validator.isKeyword(propertyName)(value2);
		  };
		}

		function keywordWithGlobal(propertyName) {
		  return function(validator, value1, value2) {
		    if (!understandable(validator, value1, value2, 0, true)
		      && !(validator.isKeyword(propertyName)(value2) || validator.isGlobal(value2))) {
		      return false;
		    } if (validator.isVariable(value1) && validator.isVariable(value2)) {
		      return true;
		    }

		    return validator.isKeyword(propertyName)(value2) || validator.isGlobal(value2);
		  };
		}

		function propertyName(validator, value1, value2) {
		  if (!understandable(validator, value1, value2, 0, true) && !validator.isIdentifier(value2)) {
		    return false;
		  } if (validator.isVariable(value1) && validator.isVariable(value2)) {
		    return true;
		  }

		  return validator.isIdentifier(value2);
		}

		function sameFunctionOrValue(validator, value1, value2) {
		  return areSameFunction(validator, value1, value2)
		    ? true
		    : value1 === value2;
		}

		function textShadow(validator, value1, value2) {
		  if (!understandable(validator, value1, value2, 0, true)
		    && !(validator.isUnit(value2)
		    || validator.isColor(value2)
		    || validator.isGlobal(value2))) {
		    return false;
		  } if (validator.isVariable(value1) && validator.isVariable(value2)) {
		    return true;
		  }

		  return validator.isUnit(value2) || validator.isColor(value2) || validator.isGlobal(value2);
		}

		function time(validator, value1, value2) {
		  if (!understandable(validator, value1, value2, 0, true) && !validator.isTime(value2)) {
		    return false;
		  } if (validator.isVariable(value1) && validator.isVariable(value2)) {
		    return true;
		  } if (validator.isTime(value1) && !validator.isTime(value2)) {
		    return false;
		  } if (validator.isTime(value2)) {
		    return true;
		  } if (validator.isTime(value1)) {
		    return false;
		  } if (validator.isFunction(value1)
		    && !validator.isPrefixed(value1)
		    && validator.isFunction(value2)
		    && !validator.isPrefixed(value2)) {
		    return true;
		  }

		  return sameFunctionOrValue(validator, value1, value2);
		}

		function timingFunction(validator, value1, value2) {
		  if (!understandable(validator, value1, value2, 0, true)
		    && !(validator.isTimingFunction(value2) || validator.isGlobal(value2))) {
		    return false;
		  } if (validator.isVariable(value1) && validator.isVariable(value2)) {
		    return true;
		  }

		  return validator.isTimingFunction(value2) || validator.isGlobal(value2);
		}

		function unit(validator, value1, value2) {
		  if (!understandable(validator, value1, value2, 0, true) && !validator.isUnit(value2)) {
		    return false;
		  } if (validator.isVariable(value1) && validator.isVariable(value2)) {
		    return true;
		  } if (validator.isUnit(value1) && !validator.isUnit(value2)) {
		    return false;
		  } if (validator.isUnit(value2)) {
		    return true;
		  } if (validator.isUnit(value1)) {
		    return false;
		  } if (validator.isFunction(value1)
		    && !validator.isPrefixed(value1)
		    && validator.isFunction(value2)
		    && !validator.isPrefixed(value2)) {
		    return true;
		  }

		  return sameFunctionOrValue(validator, value1, value2);
		}

		function unitOrKeywordWithGlobal(propertyName) {
		  var byKeyword = keywordWithGlobal(propertyName);

		  return function(validator, value1, value2) {
		    return unit(validator, value1, value2) || byKeyword(validator, value1, value2);
		  };
		}

		function unitOrNumber(validator, value1, value2) {
		  if (!understandable(validator, value1, value2, 0, true)
		    && !(validator.isUnit(value2)
		    || validator.isNumber(value2))) {
		    return false;
		  } if (validator.isVariable(value1) && validator.isVariable(value2)) {
		    return true;
		  } if ((validator.isUnit(value1)
		    || validator.isNumber(value1))
		    && !(validator.isUnit(value2)
		    || validator.isNumber(value2))) {
		    return false;
		  } if (validator.isUnit(value2) || validator.isNumber(value2)) {
		    return true;
		  } if (validator.isUnit(value1) || validator.isNumber(value1)) {
		    return false;
		  } if (validator.isFunction(value1)
		    && !validator.isPrefixed(value1)
		    && validator.isFunction(value2)
		    && !validator.isPrefixed(value2)) {
		    return true;
		  }

		  return sameFunctionOrValue(validator, value1, value2);
		}

		function zIndex(validator, value1, value2) {
		  if (!understandable(validator, value1, value2, 0, true) && !validator.isZIndex(value2)) {
		    return false;
		  } if (validator.isVariable(value1) && validator.isVariable(value2)) {
		    return true;
		  }

		  return validator.isZIndex(value2);
		}

		canOverride = {
		  generic: {
		    color: color,
		    components: components,
		    image: image,
		    propertyName: propertyName,
		    time: time,
		    timingFunction: timingFunction,
		    unit: unit,
		    unitOrNumber: unitOrNumber
		  },
		  property: {
		    animationDirection: keywordWithGlobal('animation-direction'),
		    animationFillMode: keyword('animation-fill-mode'),
		    animationIterationCount: animationIterationCount,
		    animationName: animationName,
		    animationPlayState: keywordWithGlobal('animation-play-state'),
		    backgroundAttachment: keyword('background-attachment'),
		    backgroundClip: keywordWithGlobal('background-clip'),
		    backgroundOrigin: keyword('background-origin'),
		    backgroundPosition: backgroundPosition,
		    backgroundRepeat: keyword('background-repeat'),
		    backgroundSize: backgroundSize,
		    bottom: unitOrKeywordWithGlobal('bottom'),
		    borderCollapse: keyword('border-collapse'),
		    borderStyle: keywordWithGlobal('*-style'),
		    clear: keywordWithGlobal('clear'),
		    cursor: keywordWithGlobal('cursor'),
		    display: keywordWithGlobal('display'),
		    float: keywordWithGlobal('float'),
		    left: unitOrKeywordWithGlobal('left'),
		    fontFamily: fontFamily,
		    fontStretch: keywordWithGlobal('font-stretch'),
		    fontStyle: keywordWithGlobal('font-style'),
		    fontVariant: keywordWithGlobal('font-variant'),
		    fontWeight: keywordWithGlobal('font-weight'),
		    listStyleType: keywordWithGlobal('list-style-type'),
		    listStylePosition: keywordWithGlobal('list-style-position'),
		    outlineStyle: keywordWithGlobal('*-style'),
		    overflow: keywordWithGlobal('overflow'),
		    position: keywordWithGlobal('position'),
		    right: unitOrKeywordWithGlobal('right'),
		    textAlign: keywordWithGlobal('text-align'),
		    textDecoration: keywordWithGlobal('text-decoration'),
		    textOverflow: keywordWithGlobal('text-overflow'),
		    textShadow: textShadow,
		    top: unitOrKeywordWithGlobal('top'),
		    transform: sameFunctionOrValue,
		    verticalAlign: unitOrKeywordWithGlobal('vertical-align'),
		    visibility: keywordWithGlobal('visibility'),
		    whiteSpace: keywordWithGlobal('white-space'),
		    zIndex: zIndex
		  }
		};
		return canOverride;
	}

	var clone;
	var hasRequiredClone;

	function requireClone () {
		if (hasRequiredClone) return clone;
		hasRequiredClone = 1;
		var wrapSingle = requireWrapForOptimizing().single;

		var Token = requireToken();

		function deep(property) {
		  var cloned = shallow(property);
		  for (var i = property.components.length - 1; i >= 0; i--) {
		    var component = shallow(property.components[i]);
		    component.value = property.components[i].value.slice(0);
		    cloned.components.unshift(component);
		  }

		  cloned.dirty = true;
		  cloned.value = property.value.slice(0);

		  return cloned;
		}

		function shallow(property) {
		  var cloned = wrapSingle([
		    Token.PROPERTY,
		    [Token.PROPERTY_NAME, property.name]
		  ]);
		  cloned.important = property.important;
		  cloned.hack = property.hack;
		  cloned.unused = false;
		  return cloned;
		}

		clone = {
		  deep: deep,
		  shallow: shallow
		};
		return clone;
	}

	var restore;
	var hasRequiredRestore;

	function requireRestore () {
		if (hasRequiredRestore) return restore;
		hasRequiredRestore = 1;
		var shallowClone = requireClone().shallow;

		var Token = requireToken();
		var Marker = requireMarker();

		function isInheritOnly(values) {
		  for (var i = 0, l = values.length; i < l; i++) {
		    var value = values[i][1];

		    if (value != 'inherit' && value != Marker.COMMA && value != Marker.FORWARD_SLASH) { return false; }
		  }

		  return true;
		}

		function background(property, configuration, lastInMultiplex) {
		  var components = property.components;
		  var restored = [];
		  var needsOne, needsBoth;

		  function restoreValue(component) {
		    Array.prototype.unshift.apply(restored, component.value);
		  }

		  function isDefaultValue(component) {
		    var descriptor = configuration[component.name];

		    if (descriptor.doubleValues && descriptor.defaultValue.length == 1) {
		      return component.value[0][1] == descriptor.defaultValue[0]
		        && (component.value[1]
		          ? component.value[1][1] == descriptor.defaultValue[0]
		          : true);
		    } if (descriptor.doubleValues && descriptor.defaultValue.length != 1) {
		      return component.value[0][1] == descriptor.defaultValue[0]
		      && ((component.value[1] ? component.value[1][1] : component.value[0][1])
		        == descriptor.defaultValue[1]);
		    }
		    return component.value[0][1] == descriptor.defaultValue;
		  }

		  for (var i = components.length - 1; i >= 0; i--) {
		    var component = components[i];
		    var isDefault = isDefaultValue(component);

		    if (component.name == 'background-clip') {
		      var originComponent = components[i - 1];
		      var isOriginDefault = isDefaultValue(originComponent);

		      needsOne = component.value[0][1] == originComponent.value[0][1];

		      needsBoth = !needsOne && (
		        (isOriginDefault && !isDefault)
		        || (!isOriginDefault && !isDefault)
		        || (!isOriginDefault && isDefault && component.value[0][1] != originComponent.value[0][1]));

		      if (needsOne) {
		        restoreValue(originComponent);
		      } else if (needsBoth) {
		        restoreValue(component);
		        restoreValue(originComponent);
		      }

		      i--;
		    } else if (component.name == 'background-size') {
		      var positionComponent = components[i - 1];
		      var isPositionDefault = isDefaultValue(positionComponent);

		      needsOne = !isPositionDefault && isDefault;

		      needsBoth = !needsOne
		        && (isPositionDefault && !isDefault || !isPositionDefault && !isDefault);

		      if (needsOne) {
		        restoreValue(positionComponent);
		      } else if (needsBoth) {
		        restoreValue(component);
		        restored.unshift([Token.PROPERTY_VALUE, Marker.FORWARD_SLASH]);
		        restoreValue(positionComponent);
		      } else if (positionComponent.value.length == 1) {
		        restoreValue(positionComponent);
		      }

		      i--;
		    } else {
		      if (isDefault || configuration[component.name].multiplexLastOnly && !lastInMultiplex) { continue; }

		      restoreValue(component);
		    }
		  }

		  if (restored.length === 0 && property.value.length == 1 && property.value[0][1] == '0') { restored.push(property.value[0]); }

		  if (restored.length === 0) { restored.push([Token.PROPERTY_VALUE, configuration[property.name].defaultValue]); }

		  if (isInheritOnly(restored)) { return [restored[0]]; }

		  return restored;
		}

		function borderRadius(property) {
		  if (property.multiplex) {
		    var horizontal = shallowClone(property);
		    var vertical = shallowClone(property);

		    for (var i = 0; i < 4; i++) {
		      var component = property.components[i];

		      var horizontalComponent = shallowClone(property);
		      horizontalComponent.value = [component.value[0]];
		      horizontal.components.push(horizontalComponent);

		      var verticalComponent = shallowClone(property);
		      // FIXME: only shorthand compactor (see breakup#borderRadius) knows that border radius
		      // longhands have two values, whereas tokenizer does not care about populating 2nd value
		      // if it's missing, hence this fallback
		      verticalComponent.value = [component.value[1] || component.value[0]];
		      vertical.components.push(verticalComponent);
		    }

		    var horizontalValues = fourValues(horizontal);
		    var verticalValues = fourValues(vertical);

		    if (horizontalValues.length == verticalValues.length
		        && horizontalValues[0][1] == verticalValues[0][1]
		        && (horizontalValues.length > 1 ? horizontalValues[1][1] == verticalValues[1][1] : true)
		        && (horizontalValues.length > 2 ? horizontalValues[2][1] == verticalValues[2][1] : true)
		        && (horizontalValues.length > 3 ? horizontalValues[3][1] == verticalValues[3][1] : true)) {
		      return horizontalValues;
		    }
		    return horizontalValues.concat([[Token.PROPERTY_VALUE, Marker.FORWARD_SLASH]]).concat(verticalValues);
		  }
		  return fourValues(property);
		}

		function font(property, configuration) {
		  var components = property.components;
		  var restored = [];
		  var component;
		  var componentIndex = 0;
		  var fontFamilyIndex = 0;

		  if (property.value[0][1].indexOf(Marker.INTERNAL) === 0) {
		    property.value[0][1] = property.value[0][1].substring(Marker.INTERNAL.length);
		    return property.value;
		  }

		  // first four components are optional
		  while (componentIndex < 4) {
		    component = components[componentIndex];

		    if (component.value[0][1] != configuration[component.name].defaultValue) {
		      Array.prototype.push.apply(restored, component.value);
		    }

		    componentIndex++;
		  }

		  // then comes font-size
		  Array.prototype.push.apply(restored, components[componentIndex].value);
		  componentIndex++;

		  // then may come line-height
		  if (components[componentIndex].value[0][1] != configuration[components[componentIndex].name].defaultValue) {
		    Array.prototype.push.apply(restored, [[Token.PROPERTY_VALUE, Marker.FORWARD_SLASH]]);
		    Array.prototype.push.apply(restored, components[componentIndex].value);
		  }

		  componentIndex++;

		  // then comes font-family
		  while (components[componentIndex].value[fontFamilyIndex]) {
		    restored.push(components[componentIndex].value[fontFamilyIndex]);

		    if (components[componentIndex].value[fontFamilyIndex + 1]) {
		      restored.push([Token.PROPERTY_VALUE, Marker.COMMA]);
		    }

		    fontFamilyIndex++;
		  }

		  if (isInheritOnly(restored)) {
		    return [restored[0]];
		  }

		  return restored;
		}

		function fourValues(property) {
		  var components = property.components;
		  var value1 = components[0].value[0];
		  var value2 = components[1].value[0];
		  var value3 = components[2].value[0];
		  var value4 = components[3].value[0];

		  if (value1[1] == value2[1] && value1[1] == value3[1] && value1[1] == value4[1]) {
		    return [value1];
		  } if (value1[1] == value3[1] && value2[1] == value4[1]) {
		    return [value1, value2];
		  } if (value2[1] == value4[1]) {
		    return [value1, value2, value3];
		  }
		  return [value1, value2, value3, value4];
		}

		function multiplex(restoreWith) {
		  return function(property, configuration) {
		    if (!property.multiplex) { return restoreWith(property, configuration, true); }

		    var multiplexSize = 0;
		    var restored = [];
		    var componentMultiplexSoFar = {};
		    var i, l;

		    // At this point we don't know what's the multiplex size, e.g. how many background layers are there
		    for (i = 0, l = property.components[0].value.length; i < l; i++) {
		      if (property.components[0].value[i][1] == Marker.COMMA) { multiplexSize++; }
		    }

		    for (i = 0; i <= multiplexSize; i++) {
		      var _property = shallowClone(property);

		      // We split multiplex into parts and restore them one by one
		      for (var j = 0, m = property.components.length; j < m; j++) {
		        var componentToClone = property.components[j];
		        var _component = shallowClone(componentToClone);
		        _property.components.push(_component);

		        // The trick is some properties has more than one value, so we iterate over values looking for
		        // a multiplex separator - a comma
		        for (var k = componentMultiplexSoFar[_component.name] || 0, n = componentToClone.value.length; k < n; k++) {
		          if (componentToClone.value[k][1] == Marker.COMMA) {
		            componentMultiplexSoFar[_component.name] = k + 1;
		            break;
		          }

		          _component.value.push(componentToClone.value[k]);
		        }
		      }

		      // No we can restore shorthand value
		      var lastInMultiplex = i == multiplexSize;
		      var _restored = restoreWith(_property, configuration, lastInMultiplex);
		      Array.prototype.push.apply(restored, _restored);

		      if (i < multiplexSize) { restored.push([Token.PROPERTY_VALUE, Marker.COMMA]); }
		    }

		    return restored;
		  };
		}

		function withoutDefaults(property, configuration) {
		  var components = property.components;
		  var restored = [];

		  for (var i = components.length - 1; i >= 0; i--) {
		    var component = components[i];
		    var descriptor = configuration[component.name];

		    if (component.value[0][1] != descriptor.defaultValue || ('keepUnlessDefault' in descriptor) && !isDefault(components, configuration, descriptor.keepUnlessDefault)) {
		      restored.unshift(component.value[0]);
		    }
		  }

		  if (restored.length === 0) { restored.push([Token.PROPERTY_VALUE, configuration[property.name].defaultValue]); }

		  if (isInheritOnly(restored)) { return [restored[0]]; }

		  return restored;
		}

		function isDefault(components, configuration, propertyName) {
		  var component;
		  var i, l;

		  for (i = 0, l = components.length; i < l; i++) {
		    component = components[i];

		    if (component.name == propertyName && component.value[0][1] == configuration[propertyName].defaultValue) {
		      return true;
		    }
		  }

		  return false;
		}

		restore = {
		  background: background,
		  borderRadius: borderRadius,
		  font: font,
		  fourValues: fourValues,
		  multiplex: multiplex,
		  withoutDefaults: withoutDefaults
		};
		return restore;
	}

	var roundingPrecision;
	var hasRequiredRoundingPrecision;

	function requireRoundingPrecision () {
		if (hasRequiredRoundingPrecision) return roundingPrecision;
		hasRequiredRoundingPrecision = 1;
		var override = requireOverride();

		var INTEGER_PATTERN = /^\d+$/;

		var ALL_UNITS = ['*', 'all'];
		var DEFAULT_PRECISION = 'off'; // all precision changes are disabled
		var DIRECTIVES_SEPARATOR = ','; // e.g. *=5,px=3
		var DIRECTIVE_VALUE_SEPARATOR = '='; // e.g. *=5

		function roundingPrecisionFrom(source) {
		  return override(defaults(DEFAULT_PRECISION), buildPrecisionFrom(source));
		}

		function defaults(value) {
		  return {
		    ch: value,
		    cm: value,
		    em: value,
		    ex: value,
		    in: value,
		    mm: value,
		    pc: value,
		    pt: value,
		    px: value,
		    q: value,
		    rem: value,
		    vh: value,
		    vmax: value,
		    vmin: value,
		    vw: value,
		    '%': value
		  };
		}

		function buildPrecisionFrom(source) {
		  if (source === null || source === undefined) {
		    return {};
		  }

		  if (typeof source == 'boolean') {
		    return {};
		  }

		  if (typeof source == 'number' && source == -1) {
		    return defaults(DEFAULT_PRECISION);
		  }

		  if (typeof source == 'number') {
		    return defaults(source);
		  }

		  if (typeof source == 'string' && INTEGER_PATTERN.test(source)) {
		    return defaults(parseInt(source));
		  }

		  if (typeof source == 'string' && source == DEFAULT_PRECISION) {
		    return defaults(DEFAULT_PRECISION);
		  }

		  if (typeof source == 'object') {
		    return source;
		  }

		  return source
		    .split(DIRECTIVES_SEPARATOR)
		    .reduce(function(accumulator, directive) {
		      var directiveParts = directive.split(DIRECTIVE_VALUE_SEPARATOR);
		      var name = directiveParts[0];
		      var value = parseInt(directiveParts[1]);

		      if (Number.isNaN(value) || value == -1) {
		        value = DEFAULT_PRECISION;
		      }

		      if (ALL_UNITS.indexOf(name) > -1) {
		        accumulator = override(accumulator, defaults(value));
		      } else {
		        accumulator[name] = value;
		      }

		      return accumulator;
		    }, {});
		}

		roundingPrecision = {
		  DEFAULT: DEFAULT_PRECISION,
		  roundingPrecisionFrom: roundingPrecisionFrom
		};
		return roundingPrecision;
	}

	var optimizationLevel;
	var hasRequiredOptimizationLevel;

	function requireOptimizationLevel () {
		if (hasRequiredOptimizationLevel) return optimizationLevel;
		hasRequiredOptimizationLevel = 1;
		var roundingPrecisionFrom = requireRoundingPrecision().roundingPrecisionFrom;

		var override = requireOverride();

		var OptimizationLevel = {
		  Zero: '0',
		  One: '1',
		  Two: '2'
		};

		var DEFAULTS = {};

		DEFAULTS[OptimizationLevel.Zero] = {};
		DEFAULTS[OptimizationLevel.One] = {
		  cleanupCharsets: true,
		  normalizeUrls: true,
		  optimizeBackground: true,
		  optimizeBorderRadius: true,
		  optimizeFilter: true,
		  optimizeFontWeight: true,
		  optimizeOutline: true,
		  removeEmpty: true,
		  removeNegativePaddings: true,
		  removeQuotes: true,
		  removeWhitespace: true,
		  replaceMultipleZeros: true,
		  replaceTimeUnits: true,
		  replaceZeroUnits: true,
		  roundingPrecision: roundingPrecisionFrom(undefined),
		  selectorsSortingMethod: 'standard',
		  specialComments: 'all',
		  tidyAtRules: true,
		  tidyBlockScopes: true,
		  tidySelectors: true,
		  variableValueOptimizers: []
		};
		DEFAULTS[OptimizationLevel.Two] = {
		  mergeAdjacentRules: true,
		  mergeIntoShorthands: true,
		  mergeMedia: true,
		  mergeNonAdjacentRules: true,
		  mergeSemantically: false,
		  overrideProperties: true,
		  removeEmpty: true,
		  reduceNonAdjacentRules: true,
		  removeDuplicateFontRules: true,
		  removeDuplicateMediaBlocks: true,
		  removeDuplicateRules: true,
		  removeUnusedAtRules: false,
		  restructureRules: false,
		  skipProperties: []
		};

		var ALL_KEYWORD_1 = '*';
		var ALL_KEYWORD_2 = 'all';
		var FALSE_KEYWORD_1 = 'false';
		var FALSE_KEYWORD_2 = 'off';
		var TRUE_KEYWORD_1 = 'true';
		var TRUE_KEYWORD_2 = 'on';

		var LIST_VALUE_SEPARATOR = ',';
		var OPTION_SEPARATOR = ';';
		var OPTION_VALUE_SEPARATOR = ':';

		function optimizationLevelFrom(source) {
		  var level = override(DEFAULTS, {});
		  var Zero = OptimizationLevel.Zero;
		  var One = OptimizationLevel.One;
		  var Two = OptimizationLevel.Two;

		  if (undefined === source) {
		    delete level[Two];
		    return level;
		  }

		  if (typeof source == 'string') {
		    source = parseInt(source);
		  }

		  if (typeof source == 'number' && source === parseInt(Two)) {
		    return level;
		  }

		  if (typeof source == 'number' && source === parseInt(One)) {
		    delete level[Two];
		    return level;
		  }

		  if (typeof source == 'number' && source === parseInt(Zero)) {
		    delete level[Two];
		    delete level[One];
		    return level;
		  }

		  if (typeof source == 'object') {
		    source = covertValuesToHashes(source);
		  }

		  if (One in source && 'roundingPrecision' in source[One]) {
		    source[One].roundingPrecision = roundingPrecisionFrom(source[One].roundingPrecision);
		  }

		  if (Two in source && 'skipProperties' in source[Two] && typeof (source[Two].skipProperties) == 'string') {
		    source[Two].skipProperties = source[Two].skipProperties.split(LIST_VALUE_SEPARATOR);
		  }

		  if (Zero in source || One in source || Two in source) {
		    level[Zero] = override(level[Zero], source[Zero]);
		  }

		  if (One in source && ALL_KEYWORD_1 in source[One]) {
		    level[One] = override(level[One], defaults(One, normalizeValue(source[One][ALL_KEYWORD_1])));
		    delete source[One][ALL_KEYWORD_1];
		  }

		  if (One in source && ALL_KEYWORD_2 in source[One]) {
		    level[One] = override(level[One], defaults(One, normalizeValue(source[One][ALL_KEYWORD_2])));
		    delete source[One][ALL_KEYWORD_2];
		  }

		  if (One in source || Two in source) {
		    level[One] = override(level[One], source[One]);
		  } else {
		    delete level[One];
		  }

		  if (Two in source && ALL_KEYWORD_1 in source[Two]) {
		    level[Two] = override(level[Two], defaults(Two, normalizeValue(source[Two][ALL_KEYWORD_1])));
		    delete source[Two][ALL_KEYWORD_1];
		  }

		  if (Two in source && ALL_KEYWORD_2 in source[Two]) {
		    level[Two] = override(level[Two], defaults(Two, normalizeValue(source[Two][ALL_KEYWORD_2])));
		    delete source[Two][ALL_KEYWORD_2];
		  }

		  if (Two in source) {
		    level[Two] = override(level[Two], source[Two]);
		  } else {
		    delete level[Two];
		  }

		  return level;
		}

		function defaults(level, value) {
		  var options = override(DEFAULTS[level], {});
		  var key;

		  for (key in options) {
		    if (typeof options[key] == 'boolean') {
		      options[key] = value;
		    }
		  }

		  return options;
		}

		function normalizeValue(value) {
		  switch (value) {
		  case FALSE_KEYWORD_1:
		  case FALSE_KEYWORD_2:
		    return false;
		  case TRUE_KEYWORD_1:
		  case TRUE_KEYWORD_2:
		    return true;
		  default:
		    return value;
		  }
		}

		function covertValuesToHashes(source) {
		  var clonedSource = override(source, {});
		  var level;
		  var i;

		  for (i = 0; i <= 2; i++) {
		    level = '' + i;

		    if (level in clonedSource && (clonedSource[level] === undefined || clonedSource[level] === false)) {
		      delete clonedSource[level];
		    }

		    if (level in clonedSource && clonedSource[level] === true) {
		      clonedSource[level] = {};
		    }

		    if (level in clonedSource && typeof clonedSource[level] == 'string') {
		      clonedSource[level] = covertToHash(clonedSource[level], level);
		    }
		  }

		  return clonedSource;
		}

		function covertToHash(asString, level) {
		  return asString
		    .split(OPTION_SEPARATOR)
		    .reduce(function(accumulator, directive) {
		      var parts = directive.split(OPTION_VALUE_SEPARATOR);
		      var name = parts[0];
		      var value = parts[1];
		      var normalizedValue = normalizeValue(value);

		      if (ALL_KEYWORD_1 == name || ALL_KEYWORD_2 == name) {
		        accumulator = override(accumulator, defaults(level, normalizedValue));
		      } else {
		        accumulator[name] = normalizedValue;
		      }

		      return accumulator;
		    }, {});
		}

		optimizationLevel = {
		  OptimizationLevel: OptimizationLevel,
		  optimizationLevelFrom: optimizationLevelFrom
		};
		return optimizationLevel;
	}

	var background;
	var hasRequiredBackground;

	function requireBackground () {
		if (hasRequiredBackground) return background;
		hasRequiredBackground = 1;
		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;

		var plugin = {
		  level1: {
		    property: function background(_rule, property, options) {
		      var values = property.value;

		      if (!options.level[OptimizationLevel.One].optimizeBackground) {
		        return;
		      }

		      if (values.length == 1 && values[0][1] == 'none') {
		        values[0][1] = '0 0';
		      }

		      if (values.length == 1 && values[0][1] == 'transparent') {
		        values[0][1] = '0 0';
		      }
		    }
		  }
		};

		background = plugin;
		return background;
	}

	var boxShadow;
	var hasRequiredBoxShadow;

	function requireBoxShadow () {
		if (hasRequiredBoxShadow) return boxShadow;
		hasRequiredBoxShadow = 1;
		var plugin = {
		  level1: {
		    property: function boxShadow(_rule, property) {
		      var values = property.value;

		      // remove multiple zeros
		      if (values.length == 4 && values[0][1] === '0' && values[1][1] === '0' && values[2][1] === '0' && values[3][1] === '0') {
		        property.value.splice(2);
		        property.dirty = true;
		      }
		    }
		  }
		};

		boxShadow = plugin;
		return boxShadow;
	}

	var borderRadius;
	var hasRequiredBorderRadius;

	function requireBorderRadius () {
		if (hasRequiredBorderRadius) return borderRadius;
		hasRequiredBorderRadius = 1;
		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;

		var plugin = {
		  level1: {
		    property: function borderRadius(_rule, property, options) {
		      var values = property.value;

		      if (!options.level[OptimizationLevel.One].optimizeBorderRadius) {
		        return;
		      }

		      if (values.length == 3 && values[1][1] == '/' && values[0][1] == values[2][1]) {
		        property.value.splice(1);
		        property.dirty = true;
		      } else if (values.length == 5 && values[2][1] == '/' && values[0][1] == values[3][1] && values[1][1] == values[4][1]) {
		        property.value.splice(2);
		        property.dirty = true;
		      } else if (values.length == 7 && values[3][1] == '/' && values[0][1] == values[4][1] && values[1][1] == values[5][1] && values[2][1] == values[6][1]) {
		        property.value.splice(3);
		        property.dirty = true;
		      } else if (values.length == 9 && values[4][1] == '/' && values[0][1] == values[5][1] && values[1][1] == values[6][1] && values[2][1] == values[7][1] && values[3][1] == values[8][1]) {
		        property.value.splice(4);
		        property.dirty = true;
		      }
		    }
		  }
		};

		borderRadius = plugin;
		return borderRadius;
	}

	var filter$1;
	var hasRequiredFilter;

	function requireFilter () {
		if (hasRequiredFilter) return filter$1;
		hasRequiredFilter = 1;
		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;

		var ALPHA_OR_CHROMA_FILTER_PATTERN = /progid:DXImageTransform\.Microsoft\.(Alpha|Chroma)(\W)/;
		var NO_SPACE_AFTER_COMMA_PATTERN = /,(\S)/g;
		var WHITESPACE_AROUND_EQUALS_PATTERN = / ?= ?/g;

		var plugin = {
		  level1: {
		    property: function filter(_rule, property, options) {
		      if (!options.compatibility.properties.ieFilters) {
		        return;
		      }

		      if (!options.level[OptimizationLevel.One].optimizeFilter) {
		        return;
		      }

		      if (property.value.length == 1) {
		        property.value[0][1] = property.value[0][1].replace(
		          ALPHA_OR_CHROMA_FILTER_PATTERN,
		          function(match, filter, suffix) {
		            return filter.toLowerCase() + suffix;
		          }
		        );
		      }

		      property.value[0][1] = property.value[0][1]
		        .replace(NO_SPACE_AFTER_COMMA_PATTERN, ', $1')
		        .replace(WHITESPACE_AROUND_EQUALS_PATTERN, '=');
		    }
		  }
		};

		filter$1 = plugin;
		return filter$1;
	}

	var fontWeight;
	var hasRequiredFontWeight;

	function requireFontWeight () {
		if (hasRequiredFontWeight) return fontWeight;
		hasRequiredFontWeight = 1;
		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;

		var plugin = {
		  level1: {
		    property: function fontWeight(_rule, property, options) {
		      var value = property.value[0][1];

		      if (!options.level[OptimizationLevel.One].optimizeFontWeight) {
		        return;
		      }

		      if (value == 'normal') {
		        value = '400';
		      } else if (value == 'bold') {
		        value = '700';
		      }

		      property.value[0][1] = value;
		    }
		  }
		};

		fontWeight = plugin;
		return fontWeight;
	}

	var margin;
	var hasRequiredMargin;

	function requireMargin () {
		if (hasRequiredMargin) return margin;
		hasRequiredMargin = 1;
		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;

		var plugin = {
		  level1: {
		    property: function margin(_rule, property, options) {
		      var values = property.value;

		      if (!options.level[OptimizationLevel.One].replaceMultipleZeros) {
		        return;
		      }

		      // remove multiple zeros
		      if (values.length == 4 && values[0][1] === '0' && values[1][1] === '0' && values[2][1] === '0' && values[3][1] === '0') {
		        property.value.splice(1);
		        property.dirty = true;
		      }
		    }
		  }
		};

		margin = plugin;
		return margin;
	}

	var outline;
	var hasRequiredOutline;

	function requireOutline () {
		if (hasRequiredOutline) return outline;
		hasRequiredOutline = 1;
		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;

		var plugin = {
		  level1: {
		    property: function outline(_rule, property, options) {
		      var values = property.value;

		      if (!options.level[OptimizationLevel.One].optimizeOutline) {
		        return;
		      }

		      if (values.length == 1 && values[0][1] == 'none') {
		        values[0][1] = '0';
		      }
		    }
		  }
		};

		outline = plugin;
		return outline;
	}

	var padding;
	var hasRequiredPadding;

	function requirePadding () {
		if (hasRequiredPadding) return padding;
		hasRequiredPadding = 1;
		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;

		function isNegative(value) {
		  return value && value[1][0] == '-' && parseFloat(value[1]) < 0;
		}

		var plugin = {
		  level1: {
		    property: function padding(_rule, property, options) {
		      var values = property.value;

		      // remove multiple zeros
		      if (values.length == 4 && values[0][1] === '0' && values[1][1] === '0' && values[2][1] === '0' && values[3][1] === '0') {
		        property.value.splice(1);
		        property.dirty = true;
		      }

		      // remove negative paddings
		      if (options.level[OptimizationLevel.One].removeNegativePaddings
		        && (
		          isNegative(property.value[0])
		          || isNegative(property.value[1])
		          || isNegative(property.value[2])
		          || isNegative(property.value[3])
		        )) {
		        property.unused = true;
		      }
		    }
		  }
		};

		padding = plugin;
		return padding;
	}

	var propertyOptimizers;
	var hasRequiredPropertyOptimizers;

	function requirePropertyOptimizers () {
		if (hasRequiredPropertyOptimizers) return propertyOptimizers;
		hasRequiredPropertyOptimizers = 1;
		propertyOptimizers = {
		  background: requireBackground().level1.property,
		  boxShadow: requireBoxShadow().level1.property,
		  borderRadius: requireBorderRadius().level1.property,
		  filter: requireFilter().level1.property,
		  fontWeight: requireFontWeight().level1.property,
		  margin: requireMargin().level1.property,
		  outline: requireOutline().level1.property,
		  padding: requirePadding().level1.property
		};
		return propertyOptimizers;
	}

	var shortenHex_1;
	var hasRequiredShortenHex;

	function requireShortenHex () {
		if (hasRequiredShortenHex) return shortenHex_1;
		hasRequiredShortenHex = 1;
		var COLORS = {
		  aliceblue: '#f0f8ff',
		  antiquewhite: '#faebd7',
		  aqua: '#0ff',
		  aquamarine: '#7fffd4',
		  azure: '#f0ffff',
		  beige: '#f5f5dc',
		  bisque: '#ffe4c4',
		  black: '#000',
		  blanchedalmond: '#ffebcd',
		  blue: '#00f',
		  blueviolet: '#8a2be2',
		  brown: '#a52a2a',
		  burlywood: '#deb887',
		  cadetblue: '#5f9ea0',
		  chartreuse: '#7fff00',
		  chocolate: '#d2691e',
		  coral: '#ff7f50',
		  cornflowerblue: '#6495ed',
		  cornsilk: '#fff8dc',
		  crimson: '#dc143c',
		  cyan: '#0ff',
		  darkblue: '#00008b',
		  darkcyan: '#008b8b',
		  darkgoldenrod: '#b8860b',
		  darkgray: '#a9a9a9',
		  darkgreen: '#006400',
		  darkgrey: '#a9a9a9',
		  darkkhaki: '#bdb76b',
		  darkmagenta: '#8b008b',
		  darkolivegreen: '#556b2f',
		  darkorange: '#ff8c00',
		  darkorchid: '#9932cc',
		  darkred: '#8b0000',
		  darksalmon: '#e9967a',
		  darkseagreen: '#8fbc8f',
		  darkslateblue: '#483d8b',
		  darkslategray: '#2f4f4f',
		  darkslategrey: '#2f4f4f',
		  darkturquoise: '#00ced1',
		  darkviolet: '#9400d3',
		  deeppink: '#ff1493',
		  deepskyblue: '#00bfff',
		  dimgray: '#696969',
		  dimgrey: '#696969',
		  dodgerblue: '#1e90ff',
		  firebrick: '#b22222',
		  floralwhite: '#fffaf0',
		  forestgreen: '#228b22',
		  fuchsia: '#f0f',
		  gainsboro: '#dcdcdc',
		  ghostwhite: '#f8f8ff',
		  gold: '#ffd700',
		  goldenrod: '#daa520',
		  gray: '#808080',
		  green: '#008000',
		  greenyellow: '#adff2f',
		  grey: '#808080',
		  honeydew: '#f0fff0',
		  hotpink: '#ff69b4',
		  indianred: '#cd5c5c',
		  indigo: '#4b0082',
		  ivory: '#fffff0',
		  khaki: '#f0e68c',
		  lavender: '#e6e6fa',
		  lavenderblush: '#fff0f5',
		  lawngreen: '#7cfc00',
		  lemonchiffon: '#fffacd',
		  lightblue: '#add8e6',
		  lightcoral: '#f08080',
		  lightcyan: '#e0ffff',
		  lightgoldenrodyellow: '#fafad2',
		  lightgray: '#d3d3d3',
		  lightgreen: '#90ee90',
		  lightgrey: '#d3d3d3',
		  lightpink: '#ffb6c1',
		  lightsalmon: '#ffa07a',
		  lightseagreen: '#20b2aa',
		  lightskyblue: '#87cefa',
		  lightslategray: '#778899',
		  lightslategrey: '#778899',
		  lightsteelblue: '#b0c4de',
		  lightyellow: '#ffffe0',
		  lime: '#0f0',
		  limegreen: '#32cd32',
		  linen: '#faf0e6',
		  magenta: '#ff00ff',
		  maroon: '#800000',
		  mediumaquamarine: '#66cdaa',
		  mediumblue: '#0000cd',
		  mediumorchid: '#ba55d3',
		  mediumpurple: '#9370db',
		  mediumseagreen: '#3cb371',
		  mediumslateblue: '#7b68ee',
		  mediumspringgreen: '#00fa9a',
		  mediumturquoise: '#48d1cc',
		  mediumvioletred: '#c71585',
		  midnightblue: '#191970',
		  mintcream: '#f5fffa',
		  mistyrose: '#ffe4e1',
		  moccasin: '#ffe4b5',
		  navajowhite: '#ffdead',
		  navy: '#000080',
		  oldlace: '#fdf5e6',
		  olive: '#808000',
		  olivedrab: '#6b8e23',
		  orange: '#ffa500',
		  orangered: '#ff4500',
		  orchid: '#da70d6',
		  palegoldenrod: '#eee8aa',
		  palegreen: '#98fb98',
		  paleturquoise: '#afeeee',
		  palevioletred: '#db7093',
		  papayawhip: '#ffefd5',
		  peachpuff: '#ffdab9',
		  peru: '#cd853f',
		  pink: '#ffc0cb',
		  plum: '#dda0dd',
		  powderblue: '#b0e0e6',
		  purple: '#800080',
		  rebeccapurple: '#663399',
		  red: '#f00',
		  rosybrown: '#bc8f8f',
		  royalblue: '#4169e1',
		  saddlebrown: '#8b4513',
		  salmon: '#fa8072',
		  sandybrown: '#f4a460',
		  seagreen: '#2e8b57',
		  seashell: '#fff5ee',
		  sienna: '#a0522d',
		  silver: '#c0c0c0',
		  skyblue: '#87ceeb',
		  slateblue: '#6a5acd',
		  slategray: '#708090',
		  slategrey: '#708090',
		  snow: '#fffafa',
		  springgreen: '#00ff7f',
		  steelblue: '#4682b4',
		  tan: '#d2b48c',
		  teal: '#008080',
		  thistle: '#d8bfd8',
		  tomato: '#ff6347',
		  turquoise: '#40e0d0',
		  violet: '#ee82ee',
		  wheat: '#f5deb3',
		  white: '#fff',
		  whitesmoke: '#f5f5f5',
		  yellow: '#ff0',
		  yellowgreen: '#9acd32'
		};

		var toHex = {};
		var toName = {};

		for (var name in COLORS) {
		  var hex = COLORS[name];

		  if (name.length < hex.length) {
		    toName[hex] = name;
		  } else {
		    toHex[name] = hex;
		  }
		}

		var toHexPattern = new RegExp('(^| |,|\\))(' + Object.keys(toHex).join('|') + ')( |,|\\)|$)', 'ig');
		var toNamePattern = new RegExp('(' + Object.keys(toName).join('|') + ')([^a-f0-9]|$)', 'ig');

		function hexConverter(match, prefix, colorValue, suffix) {
		  return prefix + toHex[colorValue.toLowerCase()] + suffix;
		}

		function nameConverter(match, colorValue, suffix) {
		  return toName[colorValue.toLowerCase()] + suffix;
		}

		function shortenHex(value) {
		  var hasHex = value.indexOf('#') > -1;
		  var shortened = value.replace(toHexPattern, hexConverter);

		  if (shortened != value) {
		    shortened = shortened.replace(toHexPattern, hexConverter);
		  }

		  return hasHex
		    ? shortened.replace(toNamePattern, nameConverter)
		    : shortened;
		}

		shortenHex_1 = shortenHex;
		return shortenHex_1;
	}

	var shortenHsl_1;
	var hasRequiredShortenHsl;

	function requireShortenHsl () {
		if (hasRequiredShortenHsl) return shortenHsl_1;
		hasRequiredShortenHsl = 1;
		// HSL to RGB converter. Both methods adapted from:
		// http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript

		function hslToRgb(h, s, l) {
		  var r, g, b;

		  // normalize hue orientation b/w 0 and 360 degrees
		  h %= 360;
		  if (h < 0) { h += 360; }
		  h = ~~h / 360;

		  if (s < 0) { s = 0; } else if (s > 100) { s = 100; }
		  s = ~~s / 100;

		  if (l < 0) { l = 0; } else if (l > 100) { l = 100; }
		  l = ~~l / 100;

		  if (s === 0) {
		    r = g = b = l; // achromatic
		  } else {
		    var q = l < 0.5
		      ? l * (1 + s)
		      : l + s - l * s;
		    var p = 2 * l - q;
		    r = hueToRgb(p, q, h + 1 / 3);
		    g = hueToRgb(p, q, h);
		    b = hueToRgb(p, q, h - 1 / 3);
		  }

		  return [~~(r * 255), ~~(g * 255), ~~(b * 255)];
		}

		function hueToRgb(p, q, t) {
		  if (t < 0) { t += 1; }
		  if (t > 1) { t -= 1; }
		  if (t < 1 / 6) { return p + (q - p) * 6 * t; }
		  if (t < 1 / 2) { return q; }
		  if (t < 2 / 3) { return p + (q - p) * (2 / 3 - t) * 6; }
		  return p;
		}

		function shortenHsl(hue, saturation, lightness) {
		  var asRgb = hslToRgb(hue, saturation, lightness);
		  var redAsHex = asRgb[0].toString(16);
		  var greenAsHex = asRgb[1].toString(16);
		  var blueAsHex = asRgb[2].toString(16);

		  return '#'
		    + ((redAsHex.length == 1 ? '0' : '') + redAsHex)
		    + ((greenAsHex.length == 1 ? '0' : '') + greenAsHex)
		    + ((blueAsHex.length == 1 ? '0' : '') + blueAsHex);
		}

		shortenHsl_1 = shortenHsl;
		return shortenHsl_1;
	}

	var shortenRgb_1;
	var hasRequiredShortenRgb;

	function requireShortenRgb () {
		if (hasRequiredShortenRgb) return shortenRgb_1;
		hasRequiredShortenRgb = 1;
		function shortenRgb(red, green, blue) {
		  var normalizedRed = Math.max(0, Math.min(parseInt(red), 255));
		  var normalizedGreen = Math.max(0, Math.min(parseInt(green), 255));
		  var normalizedBlue = Math.max(0, Math.min(parseInt(blue), 255));

		  // Credit: Asen  http://jsbin.com/UPUmaGOc/2/edit?js,console
		  return '#' + ('00000' + (normalizedRed << 16 | normalizedGreen << 8 | normalizedBlue).toString(16)).slice(-6);
		}

		shortenRgb_1 = shortenRgb;
		return shortenRgb_1;
	}

	var split_1;
	var hasRequiredSplit;

	function requireSplit () {
		if (hasRequiredSplit) return split_1;
		hasRequiredSplit = 1;
		var Marker = requireMarker();

		function is(value, separator, isSeparatorRegex) {
		  return isSeparatorRegex
		    ? separator.test(value)
		    : value === separator;
		}

		function split(value, separator) {
		  var openLevel = Marker.OPEN_ROUND_BRACKET;
		  var closeLevel = Marker.CLOSE_ROUND_BRACKET;
		  var level = 0;
		  var cursor = 0;
		  var lastStart = 0;
		  var lastValue;
		  var lastCharacter;
		  var len = value.length;
		  var parts = [];
		  var isSeparatorRegex = typeof (separator) == 'object' && 'exec' in separator;

		  if (!isSeparatorRegex && value.indexOf(separator) == -1) {
		    return [value];
		  }

		  if (value.indexOf(openLevel) == -1) {
		    return value.split(separator);
		  }

		  while (cursor < len) {
		    if (value[cursor] == openLevel) {
		      level++;
		    } else if (value[cursor] == closeLevel) {
		      level--;
		    }

		    if (level === 0 && cursor > 0 && cursor + 1 < len && is(value[cursor], separator, isSeparatorRegex)) {
		      parts.push(value.substring(lastStart, cursor));

		      if (isSeparatorRegex && separator.exec(value[cursor]).length > 1) {
		        parts.push(value[cursor]);
		      }

		      lastStart = cursor + 1;
		    }

		    cursor++;
		  }

		  if (lastStart < cursor + 1) {
		    lastValue = value.substring(lastStart);
		    lastCharacter = lastValue[lastValue.length - 1];
		    if (is(lastCharacter, separator, isSeparatorRegex)) {
		      lastValue = lastValue.substring(0, lastValue.length - 1);
		    }

		    parts.push(lastValue);
		  }

		  return parts;
		}

		split_1 = split;
		return split_1;
	}

	var color;
	var hasRequiredColor;

	function requireColor () {
		if (hasRequiredColor) return color;
		hasRequiredColor = 1;
		var shortenHex = requireShortenHex();
		var shortenHsl = requireShortenHsl();
		var shortenRgb = requireShortenRgb();

		var split = requireSplit();

		var ANY_COLOR_FUNCTION_PATTERN = /(rgb|rgba|hsl|hsla)\(([^()]+)\)/gi;
		var COLOR_PREFIX_PATTERN = /#|rgb|hsl/gi;
		var HEX_LONG_PATTERN = /(^|[^='"])#([0-9a-f]{6})/gi;
		var HEX_SHORT_PATTERN = /(^|[^='"])#([0-9a-f]{3})/gi;
		var HEX_VALUE_PATTERN = /[0-9a-f]/i;
		var HSL_PATTERN = /hsl\((-?\d+),(-?\d+)%?,(-?\d+)%?\)/gi;
		var RGBA_HSLA_PATTERN = /(rgb|hsl)a?\((-?\d+),(-?\d+%?),(-?\d+%?),(0*[1-9]+[0-9]*(\.?\d*)?)\)/gi;
		var RGB_PATTERN = /rgb\((-?\d+),(-?\d+),(-?\d+)\)/gi;
		var TRANSPARENT_FUNCTION_PATTERN = /(?:rgba|hsla)\(0,0%?,0%?,0\)/g;

		var plugin = {
		  level1: {
		    value: function color(name, value, options) {
		      if (!options.compatibility.properties.colors) {
		        return value;
		      }

		      if (!value.match(COLOR_PREFIX_PATTERN)) {
		        return shortenHex(value);
		      }

		      value = value
		        .replace(RGBA_HSLA_PATTERN, function(match, colorFn, p1, p2, p3, alpha) {
		          return (parseInt(alpha) >= 1 ? colorFn + '(' + [p1, p2, p3].join(',') + ')' : match);
		        })
		        .replace(RGB_PATTERN, function(match, red, green, blue) {
		          return shortenRgb(red, green, blue);
		        })
		        .replace(HSL_PATTERN, function(match, hue, saturation, lightness) {
		          return shortenHsl(hue, saturation, lightness);
		        })
		        .replace(HEX_LONG_PATTERN, function(match, prefix, color, at, inputValue) {
		          var suffix = inputValue[at + match.length];

		          if (suffix && HEX_VALUE_PATTERN.test(suffix)) {
		            return match;
		          } if (color[0] == color[1] && color[2] == color[3] && color[4] == color[5]) {
		            return (prefix + '#' + color[0] + color[2] + color[4]).toLowerCase();
		          }
		          return (prefix + '#' + color).toLowerCase();
		        })
		        .replace(HEX_SHORT_PATTERN, function(match, prefix, color) {
		          return prefix + '#' + color.toLowerCase();
		        })
		        .replace(ANY_COLOR_FUNCTION_PATTERN, function(match, colorFunction, colorDef) {
		          var tokens = colorDef.split(',');
		          var colorFnLowercase = colorFunction && colorFunction.toLowerCase();
		          var applies = (colorFnLowercase == 'hsl' && tokens.length == 3)
		            || (colorFnLowercase == 'hsla' && tokens.length == 4)
		            || (colorFnLowercase == 'rgb' && tokens.length === 3 && colorDef.indexOf('%') > 0)
		            || (colorFnLowercase == 'rgba' && tokens.length == 4 && tokens[0].indexOf('%') > 0);

		          if (!applies) {
		            return match;
		          }

		          if (tokens[1].indexOf('%') == -1) {
		            tokens[1] += '%';
		          }

		          if (tokens[2].indexOf('%') == -1) {
		            tokens[2] += '%';
		          }

		          return colorFunction + '(' + tokens.join(',') + ')';
		        });

		      if (options.compatibility.colors.opacity && name.indexOf('background') == -1) {
		        value = value.replace(TRANSPARENT_FUNCTION_PATTERN, function(match) {
		          if (split(value, ',').pop().indexOf('gradient(') > -1) {
		            return match;
		          }

		          return 'transparent';
		        });
		      }

		      return shortenHex(value);
		    }
		  }
		};

		color = plugin;
		return color;
	}

	var degrees;
	var hasRequiredDegrees;

	function requireDegrees () {
		if (hasRequiredDegrees) return degrees;
		hasRequiredDegrees = 1;
		var ZERO_DEG_PATTERN = /\(0deg\)/g;

		var plugin = {
		  level1: {
		    value: function degrees(_name, value, options) {
		      if (!options.compatibility.properties.zeroUnits) {
		        return value;
		      }

		      if (value.indexOf('0deg') == -1) {
		        return value;
		      }

		      return value.replace(ZERO_DEG_PATTERN, '(0)');
		    }
		  }
		};

		degrees = plugin;
		return degrees;
	}

	var startsAsUrl_1;
	var hasRequiredStartsAsUrl;

	function requireStartsAsUrl () {
		if (hasRequiredStartsAsUrl) return startsAsUrl_1;
		hasRequiredStartsAsUrl = 1;
		var URL_PREFIX_PATTERN = /^url\(/i;

		function startsAsUrl(value) {
		  return URL_PREFIX_PATTERN.test(value);
		}

		startsAsUrl_1 = startsAsUrl;
		return startsAsUrl_1;
	}

	var fraction;
	var hasRequiredFraction;

	function requireFraction () {
		if (hasRequiredFraction) return fraction;
		hasRequiredFraction = 1;
		var split = requireSplit();
		var startsAsUrl = requireStartsAsUrl();

		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;

		var EXPRESSION_PATTERN = /^expression\(.*\)$/;
		var ANY_FUNCTION_PATTERN = /^(-(?:moz|ms|o|webkit)-[a-z-]+|[a-z-]+)\((.+)\)$/;
		var TOKEN_SEPARATOR_PATTERN = /([\s,/])/;

		var DOT_ZERO_PATTERN = /(^|\D)\.0+(\D|$)/g;
		var FRACTION_PATTERN = /\.([1-9]*)0+(\D|$)/g;
		var LEADING_ZERO_FRACTION_PATTERN = /(^|\D)0\.(\d)/g;
		var MINUS_ZERO_FRACTION_PATTERN = /([^\w\d-]|^)-0([^.]|$)/g;
		var ZERO_PREFIXED_UNIT_PATTERN = /(^|\s)0+([1-9])/g;

		function optimizeRecursively(value) {
		  var functionTokens;
		  var tokens;

		  if (startsAsUrl(value)) {
		    return value;
		  }

		  if (EXPRESSION_PATTERN.test(value)) {
		    return value;
		  }

		  functionTokens = ANY_FUNCTION_PATTERN.exec(value);

		  if (!functionTokens) {
		    return optimizeFractions(value);
		  }

		  tokens = split(functionTokens[2], TOKEN_SEPARATOR_PATTERN)
		    .map(function(token) { return optimizeRecursively(token); });

		  return functionTokens[1] + '(' + tokens.join('') + ')';
		}

		function optimizeFractions(value) {
		  if (value.indexOf('0') == -1) {
		    return value;
		  }

		  if (value.indexOf('-') > -1) {
		    value = value
		      .replace(MINUS_ZERO_FRACTION_PATTERN, '$10$2')
		      .replace(MINUS_ZERO_FRACTION_PATTERN, '$10$2');
		  }

		  return value
		    .replace(ZERO_PREFIXED_UNIT_PATTERN, '$1$2')
		    .replace(DOT_ZERO_PATTERN, '$10$2')
		    .replace(FRACTION_PATTERN, function(match, nonZeroPart, suffix) {
		      return (nonZeroPart.length > 0 ? '.' : '') + nonZeroPart + suffix;
		    })
		    .replace(LEADING_ZERO_FRACTION_PATTERN, '$1.$2');
		}

		var plugin = {
		  level1: {
		    value: function fraction(name, value, options) {
		      if (!options.level[OptimizationLevel.One].replaceZeroUnits) {
		        return value;
		      }

		      return optimizeRecursively(value);
		    }
		  }
		};

		fraction = plugin;
		return fraction;
	}

	var precision;
	var hasRequiredPrecision;

	function requirePrecision () {
		if (hasRequiredPrecision) return precision;
		hasRequiredPrecision = 1;
		var plugin = {
		  level1: {
		    value: function precision(_name, value, options) {
		      if (!options.precision.enabled || value.indexOf('.') === -1) {
		        return value;
		      }

		      return value
		        .replace(options.precision.decimalPointMatcher, '$1$2$3')
		        .replace(options.precision.zeroMatcher, function(match, integerPart, fractionPart, unit) {
		          var multiplier = options.precision.units[unit].multiplier;
		          var parsedInteger = parseInt(integerPart);
		          var integer = Number.isNaN(parsedInteger) ? 0 : parsedInteger;
		          var fraction = parseFloat(fractionPart);

		          return Math.round((integer + fraction) * multiplier) / multiplier + unit;
		        });
		    }
		  }
		};

		precision = plugin;
		return precision;
	}

	var textQuotes;
	var hasRequiredTextQuotes;

	function requireTextQuotes () {
		if (hasRequiredTextQuotes) return textQuotes;
		hasRequiredTextQuotes = 1;
		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;

		var LOCAL_PREFIX_PATTERN = /^local\(/i;
		var QUOTED_PATTERN = /^('.*'|".*")$/;
		var QUOTED_BUT_SAFE_PATTERN = /^['"][a-zA-Z][a-zA-Z\d\-_]+['"]$/;
		// eslint-disable-next-line max-len
		var GENERIC_FONT_FAMILY_PATTERN = /^['"](?:cursive|default|emoji|fangsong|fantasy|inherit|initial|math|monospace|revert|revert-layer|sans-serif|serif|system-ui|ui-monospace|ui-rounded|ui-sans-serif|ui-serif|unset)['"]$/;

		var plugin = {
		  level1: {
		    value: function textQuotes(name, value, options) {
		      if ((name == 'font-family' || name == 'font') && GENERIC_FONT_FAMILY_PATTERN.test(value)) {
		        return value;
		      }

		      if (!options.level[OptimizationLevel.One].removeQuotes) {
		        return value;
		      }

		      if (!QUOTED_PATTERN.test(value) && !LOCAL_PREFIX_PATTERN.test(value)) {
		        return value;
		      }

		      return QUOTED_BUT_SAFE_PATTERN.test(value)
		        ? value.substring(1, value.length - 1)
		        : value;
		    }
		  }
		};

		textQuotes = plugin;
		return textQuotes;
	}

	var time;
	var hasRequiredTime;

	function requireTime () {
		if (hasRequiredTime) return time;
		hasRequiredTime = 1;
		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;

		var TIME_VALUE = /^(-?[\d.]+)(m?s)$/;

		var plugin = {
		  level1: {
		    value: function time(name, value, options) {
		      if (!options.level[OptimizationLevel.One].replaceTimeUnits) {
		        return value;
		      }

		      if (!TIME_VALUE.test(value)) {
		        return value;
		      }

		      return value.replace(TIME_VALUE, function(match, val, unit) {
		        var newValue;

		        if (unit == 'ms') {
		          newValue = parseInt(val) / 1000 + 's';
		        } else if (unit == 's') {
		          newValue = parseFloat(val) * 1000 + 'ms';
		        }

		        return newValue.length < match.length ? newValue : match;
		      });
		    }
		  }
		};

		time = plugin;
		return time;
	}

	var unit;
	var hasRequiredUnit;

	function requireUnit () {
		if (hasRequiredUnit) return unit;
		hasRequiredUnit = 1;
		var WHOLE_PIXEL_VALUE = /(?:^|\s|\()(-?\d+)px/;

		var plugin = {
		  level1: {
		    value: function unit(_name, value, options) {
		      if (!WHOLE_PIXEL_VALUE.test(value)) {
		        return value;
		      }

		      return value.replace(WHOLE_PIXEL_VALUE, function(match, val) {
		        var newValue;
		        var intVal = parseInt(val);

		        if (intVal === 0) {
		          return match;
		        }

		        if (options.compatibility.properties.shorterLengthUnits
		          && options.compatibility.units.pt
		          && intVal * 3 % 4 === 0) {
		          newValue = intVal * 3 / 4 + 'pt';
		        }

		        if (options.compatibility.properties.shorterLengthUnits
		          && options.compatibility.units.pc
		          && intVal % 16 === 0) {
		          newValue = intVal / 16 + 'pc';
		        }

		        if (options.compatibility.properties.shorterLengthUnits
		          && options.compatibility.units.in
		          && intVal % 96 === 0) {
		          newValue = intVal / 96 + 'in';
		        }

		        if (newValue) {
		          newValue = match.substring(0, match.indexOf(val)) + newValue;
		        }

		        return newValue && newValue.length < match.length ? newValue : match;
		      });
		    }
		  }
		};

		unit = plugin;
		return unit;
	}

	var urlPrefix;
	var hasRequiredUrlPrefix;

	function requireUrlPrefix () {
		if (hasRequiredUrlPrefix) return urlPrefix;
		hasRequiredUrlPrefix = 1;
		var startsAsUrl = requireStartsAsUrl();

		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;

		var URL_PREFIX_PATTERN = /^url\(/i;

		var plugin = {
		  level1: {
		    value: function urlPrefix(_name, value, options) {
		      if (!options.level[OptimizationLevel.One].normalizeUrls) {
		        return value;
		      }

		      if (!startsAsUrl(value)) {
		        return value;
		      }

		      return value.replace(URL_PREFIX_PATTERN, 'url(');
		    }
		  }
		};

		urlPrefix = plugin;
		return urlPrefix;
	}

	var urlQuotes;
	var hasRequiredUrlQuotes;

	function requireUrlQuotes () {
		if (hasRequiredUrlQuotes) return urlQuotes;
		hasRequiredUrlQuotes = 1;
		var QUOTED_URL_PATTERN = /^url\(['"].+['"]\)$/;
		var QUOTED_URL_WITH_WHITESPACE_PATTERN = /^url\(['"].*[*\s()'"].*['"]\)$/;
		var QUOTES_PATTERN = /["']/g;
		var URL_DATA_PATTERN = /^url\(['"]data:[^;]+;charset/;

		var plugin = {
		  level1: {
		    value: function urlQuotes(_name, value, options) {
		      if (options.compatibility.properties.urlQuotes) {
		        return value;
		      }

		      return QUOTED_URL_PATTERN.test(value)
		        && !QUOTED_URL_WITH_WHITESPACE_PATTERN.test(value)
		        && !URL_DATA_PATTERN.test(value)
		        ? value.replace(QUOTES_PATTERN, '')
		        : value;
		    }
		  }
		};

		urlQuotes = plugin;
		return urlQuotes;
	}

	var urlWhitespace;
	var hasRequiredUrlWhitespace;

	function requireUrlWhitespace () {
		if (hasRequiredUrlWhitespace) return urlWhitespace;
		hasRequiredUrlWhitespace = 1;
		var startsAsUrl = requireStartsAsUrl();

		var WHITESPACE_PATTERN = /\\?\n|\\?\r\n/g;
		var WHITESPACE_PREFIX_PATTERN = /(\()\s+/g;
		var WHITESPACE_SUFFIX_PATTERN = /\s+(\))/g;

		var plugin = {
		  level1: {
		    value: function urlWhitespace(_name, value) {
		      if (!startsAsUrl(value)) {
		        return value;
		      }

		      return value
		        .replace(WHITESPACE_PATTERN, '')
		        .replace(WHITESPACE_PREFIX_PATTERN, '$1')
		        .replace(WHITESPACE_SUFFIX_PATTERN, '$1');
		    }
		  }
		};

		urlWhitespace = plugin;
		return urlWhitespace;
	}

	var whitespace;
	var hasRequiredWhitespace;

	function requireWhitespace () {
		if (hasRequiredWhitespace) return whitespace;
		hasRequiredWhitespace = 1;
		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;

		var Marker = requireMarker();

		var CALC_DIVISION_WHITESPACE_PATTERN = /\) ?\/ ?/g;
		var COMMA_AND_SPACE_PATTERN = /, /g;
		var LINE_BREAK_PATTERN = /\r?\n/g;
		var MULTI_WHITESPACE_PATTERN = /\s+/g;
		var FUNCTION_CLOSING_BRACE_WHITESPACE_PATTERN = /\s+(;?\))/g;
		var FUNCTION_OPENING_BRACE_WHITESPACE_PATTERN = /(\(;?)\s+/g;
		var VARIABLE_NAME_PATTERN = /^--\S+$/;
		var VARIABLE_VALUE_PATTERN = /^var\(\s*--\S+\s*\)$/;

		var plugin = {
		  level1: {
		    value: function whitespace(name, value, options) {
		      if (!options.level[OptimizationLevel.One].removeWhitespace) {
		        return value;
		      }

		      if (VARIABLE_NAME_PATTERN.test(name) && !VARIABLE_VALUE_PATTERN.test(value)) {
		        return value;
		      }

		      if ((value.indexOf(' ') == -1 && value.indexOf('\n') == -1) || value.indexOf('expression') === 0) {
		        return value;
		      }

		      if (value.indexOf(Marker.SINGLE_QUOTE) > -1 || value.indexOf(Marker.DOUBLE_QUOTE) > -1) {
		        return value;
		      }

		      value = value.replace(LINE_BREAK_PATTERN, '');
		      value = value.replace(MULTI_WHITESPACE_PATTERN, ' ');

		      if (value.indexOf('calc') > -1) {
		        value = value.replace(CALC_DIVISION_WHITESPACE_PATTERN, ')/ ');
		      }

		      return value
		        .replace(FUNCTION_OPENING_BRACE_WHITESPACE_PATTERN, '$1')
		        .replace(FUNCTION_CLOSING_BRACE_WHITESPACE_PATTERN, '$1')
		        .replace(COMMA_AND_SPACE_PATTERN, ',');
		    }
		  }
		};

		whitespace = plugin;
		return whitespace;
	}

	var zero;
	var hasRequiredZero;

	function requireZero () {
		if (hasRequiredZero) return zero;
		hasRequiredZero = 1;
		var split = requireSplit();

		var ANY_FUNCTION_PATTERN = /^(-(?:moz|ms|o|webkit)-[a-z-]+|[a-z-]+)\((.+)\)$/;
		var SKIP_FUNCTION_PATTERN = /^(?:-moz-calc|-webkit-calc|calc|rgb|hsl|rgba|hsla|min|max|clamp|expression)\(/;
		var TOKEN_SEPARATOR_PATTERN = /([\s,/])/;

		function removeRecursively(value, options) {
		  var functionTokens;
		  var tokens;

		  if (SKIP_FUNCTION_PATTERN.test(value)) {
		    return value;
		  }

		  functionTokens = ANY_FUNCTION_PATTERN.exec(value);

		  if (!functionTokens) {
		    return removeZeros(value, options);
		  }

		  tokens = split(functionTokens[2], TOKEN_SEPARATOR_PATTERN)
		    .map(function(token) { return removeRecursively(token, options); });

		  return functionTokens[1] + '(' + tokens.join('') + ')';
		}

		function removeZeros(value, options) {
		  return value
		    .replace(options.unitsRegexp, '$10$2')
		    .replace(options.unitsRegexp, '$10$2');
		}

		var plugin = {
		  level1: {
		    value: function zero(name, value, options) {
		      if (!options.compatibility.properties.zeroUnits) {
		        return value;
		      }

		      if (value.indexOf('%') > 0 && (name == 'height' || name == 'max-height' || name == 'width' || name == 'max-width')) {
		        return value;
		      }

		      return removeRecursively(value, options);
		    }
		  }
		};

		zero = plugin;
		return zero;
	}

	var valueOptimizers;
	var hasRequiredValueOptimizers;

	function requireValueOptimizers () {
		if (hasRequiredValueOptimizers) return valueOptimizers;
		hasRequiredValueOptimizers = 1;
		valueOptimizers = {
		  color: requireColor().level1.value,
		  degrees: requireDegrees().level1.value,
		  fraction: requireFraction().level1.value,
		  precision: requirePrecision().level1.value,
		  textQuotes: requireTextQuotes().level1.value,
		  time: requireTime().level1.value,
		  unit: requireUnit().level1.value,
		  urlPrefix: requireUrlPrefix().level1.value,
		  urlQuotes: requireUrlQuotes().level1.value,
		  urlWhiteSpace: requireUrlWhitespace().level1.value,
		  whiteSpace: requireWhitespace().level1.value,
		  zero: requireZero().level1.value
		};
		return valueOptimizers;
	}

	var configuration_1;
	var hasRequiredConfiguration;

	function requireConfiguration () {
		if (hasRequiredConfiguration) return configuration_1;
		hasRequiredConfiguration = 1;
		// Contains the interpretation of CSS properties, as used by the property optimizer

		var breakUp = requireBreakUp();
		var canOverride = requireCanOverride();
		var restore = requireRestore();

		var propertyOptimizers = requirePropertyOptimizers();
		var valueOptimizers = requireValueOptimizers();

		var override = requireOverride();

		// Properties to process
		// Extend this object in order to add support for more properties in the optimizer.
		//
		// Each key in this object represents a CSS property and should be an object.
		// Such an object contains properties that describe how the represented CSS property should be handled.
		// Possible options:
		//
		// * components: array (Only specify for shorthand properties.)
		//   Contains the names of the granular properties this shorthand compacts.
		//
		// * canOverride: function
		//   Returns whether two tokens of this property can be merged with each other.
		//   This property has no meaning for shorthands.
		//
		// * defaultValue: string
		//   Specifies the default value of the property according to the CSS standard.
		//   For shorthand, this is used when every component is set to its default value, therefore it should be the shortest possible default value of all the components.
		//
		// * shortestValue: string
		//   Specifies the shortest possible value the property can possibly have.
		//   (Falls back to defaultValue if unspecified.)
		//
		// * breakUp: function (Only specify for shorthand properties.)
		//   Breaks the shorthand up to its components.
		//
		// * restore: function (Only specify for shorthand properties.)
		//   Puts the shorthand together from its components.
		//
		var configuration = {
		  animation: {
		    canOverride: canOverride.generic.components([
		      canOverride.generic.time,
		      canOverride.generic.timingFunction,
		      canOverride.generic.time,
		      canOverride.property.animationIterationCount,
		      canOverride.property.animationDirection,
		      canOverride.property.animationFillMode,
		      canOverride.property.animationPlayState,
		      canOverride.property.animationName
		    ]),
		    components: [
		      'animation-duration',
		      'animation-timing-function',
		      'animation-delay',
		      'animation-iteration-count',
		      'animation-direction',
		      'animation-fill-mode',
		      'animation-play-state',
		      'animation-name'
		    ],
		    breakUp: breakUp.multiplex(breakUp.animation),
		    defaultValue: 'none',
		    restore: restore.multiplex(restore.withoutDefaults),
		    shorthand: true,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.textQuotes,
		      valueOptimizers.time,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ],
		    vendorPrefixes: [
		      '-moz-',
		      '-o-',
		      '-webkit-'
		    ]
		  },
		  'animation-delay': {
		    canOverride: canOverride.generic.time,
		    componentOf: [
		      'animation'
		    ],
		    defaultValue: '0s',
		    intoMultiplexMode: 'real',
		    valueOptimizers: [
		      valueOptimizers.time,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ],
		    vendorPrefixes: [
		      '-moz-',
		      '-o-',
		      '-webkit-'
		    ]
		  },
		  'animation-direction': {
		    canOverride: canOverride.property.animationDirection,
		    componentOf: [
		      'animation'
		    ],
		    defaultValue: 'normal',
		    intoMultiplexMode: 'real',
		    vendorPrefixes: [
		      '-moz-',
		      '-o-',
		      '-webkit-'
		    ]
		  },
		  'animation-duration': {
		    canOverride: canOverride.generic.time,
		    componentOf: [
		      'animation'
		    ],
		    defaultValue: '0s',
		    intoMultiplexMode: 'real',
		    keepUnlessDefault: 'animation-delay',
		    valueOptimizers: [
		      valueOptimizers.time,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ],
		    vendorPrefixes: [
		      '-moz-',
		      '-o-',
		      '-webkit-'
		    ]
		  },
		  'animation-fill-mode': {
		    canOverride: canOverride.property.animationFillMode,
		    componentOf: [
		      'animation'
		    ],
		    defaultValue: 'none',
		    intoMultiplexMode: 'real',
		    vendorPrefixes: [
		      '-moz-',
		      '-o-',
		      '-webkit-'
		    ]
		  },
		  'animation-iteration-count': {
		    canOverride: canOverride.property.animationIterationCount,
		    componentOf: [
		      'animation'
		    ],
		    defaultValue: '1',
		    intoMultiplexMode: 'real',
		    vendorPrefixes: [
		      '-moz-',
		      '-o-',
		      '-webkit-'
		    ]
		  },
		  'animation-name': {
		    canOverride: canOverride.property.animationName,
		    componentOf: [
		      'animation'
		    ],
		    defaultValue: 'none',
		    intoMultiplexMode: 'real',
		    valueOptimizers: [
		      valueOptimizers.textQuotes
		    ],
		    vendorPrefixes: [
		      '-moz-',
		      '-o-',
		      '-webkit-'
		    ]
		  },
		  'animation-play-state': {
		    canOverride: canOverride.property.animationPlayState,
		    componentOf: [
		      'animation'
		    ],
		    defaultValue: 'running',
		    intoMultiplexMode: 'real',
		    vendorPrefixes: [
		      '-moz-',
		      '-o-',
		      '-webkit-'
		    ]
		  },
		  'animation-timing-function': {
		    canOverride: canOverride.generic.timingFunction,
		    componentOf: [
		      'animation'
		    ],
		    defaultValue: 'ease',
		    intoMultiplexMode: 'real',
		    vendorPrefixes: [
		      '-moz-',
		      '-o-',
		      '-webkit-'
		    ]
		  },
		  background: {
		    canOverride: canOverride.generic.components([
		      canOverride.generic.image,
		      canOverride.property.backgroundPosition,
		      canOverride.property.backgroundSize,
		      canOverride.property.backgroundRepeat,
		      canOverride.property.backgroundAttachment,
		      canOverride.property.backgroundOrigin,
		      canOverride.property.backgroundClip,
		      canOverride.generic.color
		    ]),
		    components: [
		      'background-image',
		      'background-position',
		      'background-size',
		      'background-repeat',
		      'background-attachment',
		      'background-origin',
		      'background-clip',
		      'background-color'
		    ],
		    breakUp: breakUp.multiplex(breakUp.background),
		    defaultValue: '0 0',
		    propertyOptimizer: propertyOptimizers.background,
		    restore: restore.multiplex(restore.background),
		    shortestValue: '0',
		    shorthand: true,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.urlWhiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.zero,
		      valueOptimizers.color,
		      valueOptimizers.urlPrefix,
		      valueOptimizers.urlQuotes
		    ]
		  },
		  'background-attachment': {
		    canOverride: canOverride.property.backgroundAttachment,
		    componentOf: [
		      'background'
		    ],
		    defaultValue: 'scroll',
		    intoMultiplexMode: 'real'
		  },
		  'background-clip': {
		    canOverride: canOverride.property.backgroundClip,
		    componentOf: [
		      'background'
		    ],
		    defaultValue: 'border-box',
		    intoMultiplexMode: 'real',
		    shortestValue: 'border-box'
		  },
		  'background-color': {
		    canOverride: canOverride.generic.color,
		    componentOf: [
		      'background'
		    ],
		    defaultValue: 'transparent',
		    intoMultiplexMode: 'real', // otherwise real color will turn into default since color appears in last multiplex only
		    multiplexLastOnly: true,
		    nonMergeableValue: 'none',
		    shortestValue: 'red',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.color
		    ]
		  },
		  'background-image': {
		    canOverride: canOverride.generic.image,
		    componentOf: [
		      'background'
		    ],
		    defaultValue: 'none',
		    intoMultiplexMode: 'default',
		    valueOptimizers: [
		      valueOptimizers.urlWhiteSpace,
		      valueOptimizers.urlPrefix,
		      valueOptimizers.urlQuotes,
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero,
		      valueOptimizers.color
		    ]
		  },
		  'background-origin': {
		    canOverride: canOverride.property.backgroundOrigin,
		    componentOf: [
		      'background'
		    ],
		    defaultValue: 'padding-box',
		    intoMultiplexMode: 'real',
		    shortestValue: 'border-box'
		  },
		  'background-position': {
		    canOverride: canOverride.property.backgroundPosition,
		    componentOf: [
		      'background'
		    ],
		    defaultValue: ['0', '0'],
		    doubleValues: true,
		    intoMultiplexMode: 'real',
		    shortestValue: '0',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'background-repeat': {
		    canOverride: canOverride.property.backgroundRepeat,
		    componentOf: [
		      'background'
		    ],
		    defaultValue: ['repeat'],
		    doubleValues: true,
		    intoMultiplexMode: 'real'
		  },
		  'background-size': {
		    canOverride: canOverride.property.backgroundSize,
		    componentOf: [
		      'background'
		    ],
		    defaultValue: ['auto'],
		    doubleValues: true,
		    intoMultiplexMode: 'real',
		    shortestValue: '0 0',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  bottom: {
		    canOverride: canOverride.property.bottom,
		    defaultValue: 'auto',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  border: {
		    breakUp: breakUp.border,
		    canOverride: canOverride.generic.components([
		      canOverride.generic.unit,
		      canOverride.property.borderStyle,
		      canOverride.generic.color
		    ]),
		    components: [
		      'border-width',
		      'border-style',
		      'border-color'
		    ],
		    defaultValue: 'none',
		    overridesShorthands: [
		      'border-bottom',
		      'border-left',
		      'border-right',
		      'border-top'
		    ],
		    restore: restore.withoutDefaults,
		    shorthand: true,
		    shorthandComponents: true,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.zero,
		      valueOptimizers.color
		    ]
		  },
		  'border-bottom': {
		    breakUp: breakUp.border,
		    canOverride: canOverride.generic.components([
		      canOverride.generic.unit,
		      canOverride.property.borderStyle,
		      canOverride.generic.color
		    ]),
		    components: [
		      'border-bottom-width',
		      'border-bottom-style',
		      'border-bottom-color'
		    ],
		    defaultValue: 'none',
		    restore: restore.withoutDefaults,
		    shorthand: true,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.zero,
		      valueOptimizers.color
		    ]
		  },
		  'border-bottom-color': {
		    canOverride: canOverride.generic.color,
		    componentOf: [
		      'border-bottom',
		      'border-color'
		    ],
		    defaultValue: 'none',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.color
		    ]
		  },
		  'border-bottom-left-radius': {
		    canOverride: canOverride.generic.unit,
		    componentOf: [
		      'border-radius'
		    ],
		    defaultValue: '0',
		    propertyOptimizer: propertyOptimizers.borderRadius,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ],
		    vendorPrefixes: [
		      '-moz-',
		      '-o-'
		    ]
		  },
		  'border-bottom-right-radius': {
		    canOverride: canOverride.generic.unit,
		    componentOf: [
		      'border-radius'
		    ],
		    defaultValue: '0',
		    propertyOptimizer: propertyOptimizers.borderRadius,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ],
		    vendorPrefixes: [
		      '-moz-',
		      '-o-'
		    ]
		  },
		  'border-bottom-style': {
		    canOverride: canOverride.property.borderStyle,
		    componentOf: [
		      'border-bottom',
		      'border-style'
		    ],
		    defaultValue: 'none'
		  },
		  'border-bottom-width': {
		    canOverride: canOverride.generic.unit,
		    componentOf: [
		      'border-bottom',
		      'border-width'
		    ],
		    defaultValue: 'medium',
		    oppositeTo: 'border-top-width',
		    shortestValue: '0',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'border-collapse': {
		    canOverride: canOverride.property.borderCollapse,
		    defaultValue: 'separate'
		  },
		  'border-color': {
		    breakUp: breakUp.fourValues,
		    canOverride: canOverride.generic.components([
		      canOverride.generic.color,
		      canOverride.generic.color,
		      canOverride.generic.color,
		      canOverride.generic.color
		    ]),
		    componentOf: [
		      'border'
		    ],
		    components: [
		      'border-top-color',
		      'border-right-color',
		      'border-bottom-color',
		      'border-left-color'
		    ],
		    defaultValue: 'none',
		    restore: restore.fourValues,
		    shortestValue: 'red',
		    shorthand: true,
		    singleTypeComponents: true,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.color
		    ]
		  },
		  'border-left': {
		    breakUp: breakUp.border,
		    canOverride: canOverride.generic.components([
		      canOverride.generic.unit,
		      canOverride.property.borderStyle,
		      canOverride.generic.color
		    ]),
		    components: [
		      'border-left-width',
		      'border-left-style',
		      'border-left-color'
		    ],
		    defaultValue: 'none',
		    restore: restore.withoutDefaults,
		    shorthand: true,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.zero,
		      valueOptimizers.color
		    ]
		  },
		  'border-left-color': {
		    canOverride: canOverride.generic.color,
		    componentOf: [
		      'border-color',
		      'border-left'
		    ],
		    defaultValue: 'none',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.color
		    ]
		  },
		  'border-left-style': {
		    canOverride: canOverride.property.borderStyle,
		    componentOf: [
		      'border-left',
		      'border-style'
		    ],
		    defaultValue: 'none'
		  },
		  'border-left-width': {
		    canOverride: canOverride.generic.unit,
		    componentOf: [
		      'border-left',
		      'border-width'
		    ],
		    defaultValue: 'medium',
		    oppositeTo: 'border-right-width',
		    shortestValue: '0',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'border-radius': {
		    breakUp: breakUp.borderRadius,
		    canOverride: canOverride.generic.components([
		      canOverride.generic.unit,
		      canOverride.generic.unit,
		      canOverride.generic.unit,
		      canOverride.generic.unit
		    ]),
		    components: [
		      'border-top-left-radius',
		      'border-top-right-radius',
		      'border-bottom-right-radius',
		      'border-bottom-left-radius'
		    ],
		    defaultValue: '0',
		    propertyOptimizer: propertyOptimizers.borderRadius,
		    restore: restore.borderRadius,
		    shorthand: true,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ],
		    vendorPrefixes: [
		      '-moz-',
		      '-o-'
		    ]
		  },
		  'border-right': {
		    breakUp: breakUp.border,
		    canOverride: canOverride.generic.components([
		      canOverride.generic.unit,
		      canOverride.property.borderStyle,
		      canOverride.generic.color
		    ]),
		    components: [
		      'border-right-width',
		      'border-right-style',
		      'border-right-color'
		    ],
		    defaultValue: 'none',
		    restore: restore.withoutDefaults,
		    shorthand: true,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.color
		    ]
		  },
		  'border-right-color': {
		    canOverride: canOverride.generic.color,
		    componentOf: [
		      'border-color',
		      'border-right'
		    ],
		    defaultValue: 'none',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.color
		    ]
		  },
		  'border-right-style': {
		    canOverride: canOverride.property.borderStyle,
		    componentOf: [
		      'border-right',
		      'border-style'
		    ],
		    defaultValue: 'none'
		  },
		  'border-right-width': {
		    canOverride: canOverride.generic.unit,
		    componentOf: [
		      'border-right',
		      'border-width'
		    ],
		    defaultValue: 'medium',
		    oppositeTo: 'border-left-width',
		    shortestValue: '0',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'border-style': {
		    breakUp: breakUp.fourValues,
		    canOverride: canOverride.generic.components([
		      canOverride.property.borderStyle,
		      canOverride.property.borderStyle,
		      canOverride.property.borderStyle,
		      canOverride.property.borderStyle
		    ]),
		    componentOf: [
		      'border'
		    ],
		    components: [
		      'border-top-style',
		      'border-right-style',
		      'border-bottom-style',
		      'border-left-style'
		    ],
		    defaultValue: 'none',
		    restore: restore.fourValues,
		    shorthand: true,
		    singleTypeComponents: true
		  },
		  'border-top': {
		    breakUp: breakUp.border,
		    canOverride: canOverride.generic.components([
		      canOverride.generic.unit,
		      canOverride.property.borderStyle,
		      canOverride.generic.color
		    ]),
		    components: [
		      'border-top-width',
		      'border-top-style',
		      'border-top-color'
		    ],
		    defaultValue: 'none',
		    restore: restore.withoutDefaults,
		    shorthand: true,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.zero,
		      valueOptimizers.color,
		      valueOptimizers.unit
		    ]
		  },
		  'border-top-color': {
		    canOverride: canOverride.generic.color,
		    componentOf: [
		      'border-color',
		      'border-top'
		    ],
		    defaultValue: 'none',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.color
		    ]
		  },
		  'border-top-left-radius': {
		    canOverride: canOverride.generic.unit,
		    componentOf: [
		      'border-radius'
		    ],
		    defaultValue: '0',
		    propertyOptimizer: propertyOptimizers.borderRadius,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ],
		    vendorPrefixes: [
		      '-moz-',
		      '-o-'
		    ]
		  },
		  'border-top-right-radius': {
		    canOverride: canOverride.generic.unit,
		    componentOf: [
		      'border-radius'
		    ],
		    defaultValue: '0',
		    propertyOptimizer: propertyOptimizers.borderRadius,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ],
		    vendorPrefixes: [
		      '-moz-',
		      '-o-'
		    ]
		  },
		  'border-top-style': {
		    canOverride: canOverride.property.borderStyle,
		    componentOf: [
		      'border-style',
		      'border-top'
		    ],
		    defaultValue: 'none'
		  },
		  'border-top-width': {
		    canOverride: canOverride.generic.unit,
		    componentOf: [
		      'border-top',
		      'border-width'
		    ],
		    defaultValue: 'medium',
		    oppositeTo: 'border-bottom-width',
		    shortestValue: '0',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'border-width': {
		    breakUp: breakUp.fourValues,
		    canOverride: canOverride.generic.components([
		      canOverride.generic.unit,
		      canOverride.generic.unit,
		      canOverride.generic.unit,
		      canOverride.generic.unit
		    ]),
		    componentOf: [
		      'border'
		    ],
		    components: [
		      'border-top-width',
		      'border-right-width',
		      'border-bottom-width',
		      'border-left-width'
		    ],
		    defaultValue: 'medium',
		    restore: restore.fourValues,
		    shortestValue: '0',
		    shorthand: true,
		    singleTypeComponents: true,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'box-shadow': {
		    propertyOptimizer: propertyOptimizers.boxShadow,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero,
		      valueOptimizers.color
		    ],
		    vendorPrefixes: [
		      '-moz-',
		      '-ms-',
		      '-o-',
		      '-webkit-'
		    ]
		  },
		  clear: {
		    canOverride: canOverride.property.clear,
		    defaultValue: 'none'
		  },
		  clip: {
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  color: {
		    canOverride: canOverride.generic.color,
		    defaultValue: 'transparent',
		    shortestValue: 'red',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.color
		    ]
		  },
		  'column-gap': {
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  cursor: {
		    canOverride: canOverride.property.cursor,
		    defaultValue: 'auto'
		  },
		  display: { canOverride: canOverride.property.display },
		  filter: {
		    propertyOptimizer: propertyOptimizers.filter,
		    valueOptimizers: [
		      valueOptimizers.fraction
		    ]
		  },
		  float: {
		    canOverride: canOverride.property.float,
		    defaultValue: 'none'
		  },
		  font: {
		    breakUp: breakUp.font,
		    canOverride: canOverride.generic.components([
		      canOverride.property.fontStyle,
		      canOverride.property.fontVariant,
		      canOverride.property.fontWeight,
		      canOverride.property.fontStretch,
		      canOverride.generic.unit,
		      canOverride.generic.unit,
		      canOverride.property.fontFamily
		    ]),
		    components: [
		      'font-style',
		      'font-variant',
		      'font-weight',
		      'font-stretch',
		      'font-size',
		      'line-height',
		      'font-family'
		    ],
		    restore: restore.font,
		    shorthand: true,
		    valueOptimizers: [
		      valueOptimizers.textQuotes
		    ]
		  },
		  'font-family': {
		    canOverride: canOverride.property.fontFamily,
		    defaultValue: 'user|agent|specific',
		    valueOptimizers: [
		      valueOptimizers.textQuotes
		    ]
		  },
		  'font-size': {
		    canOverride: canOverride.generic.unit,
		    defaultValue: 'medium',
		    shortestValue: '0',
		    valueOptimizers: [
		      valueOptimizers.fraction
		    ]
		  },
		  'font-stretch': {
		    canOverride: canOverride.property.fontStretch,
		    defaultValue: 'normal'
		  },
		  'font-style': {
		    canOverride: canOverride.property.fontStyle,
		    defaultValue: 'normal'
		  },
		  'font-variant': {
		    canOverride: canOverride.property.fontVariant,
		    defaultValue: 'normal'
		  },
		  'font-weight': {
		    canOverride: canOverride.property.fontWeight,
		    defaultValue: 'normal',
		    propertyOptimizer: propertyOptimizers.fontWeight,
		    shortestValue: '400'
		  },
		  gap: {
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  height: {
		    canOverride: canOverride.generic.unit,
		    defaultValue: 'auto',
		    shortestValue: '0',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  left: {
		    canOverride: canOverride.property.left,
		    defaultValue: 'auto',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'letter-spacing': {
		    valueOptimizers: [
		      valueOptimizers.fraction,
		      valueOptimizers.zero
		    ]
		  },
		  'line-height': {
		    canOverride: canOverride.generic.unitOrNumber,
		    defaultValue: 'normal',
		    shortestValue: '0',
		    valueOptimizers: [
		      valueOptimizers.fraction,
		      valueOptimizers.zero
		    ]
		  },
		  'list-style': {
		    canOverride: canOverride.generic.components([
		      canOverride.property.listStyleType,
		      canOverride.property.listStylePosition,
		      canOverride.property.listStyleImage
		    ]),
		    components: [
		      'list-style-type',
		      'list-style-position',
		      'list-style-image'
		    ],
		    breakUp: breakUp.listStyle,
		    restore: restore.withoutDefaults,
		    defaultValue: 'outside', // can't use 'disc' because that'd override default 'decimal' for <ol>
		    shortestValue: 'none',
		    shorthand: true
		  },
		  'list-style-image': {
		    canOverride: canOverride.generic.image,
		    componentOf: [
		      'list-style'
		    ],
		    defaultValue: 'none'
		  },
		  'list-style-position': {
		    canOverride: canOverride.property.listStylePosition,
		    componentOf: [
		      'list-style'
		    ],
		    defaultValue: 'outside',
		    shortestValue: 'inside'
		  },
		  'list-style-type': {
		    canOverride: canOverride.property.listStyleType,
		    componentOf: [
		      'list-style'
		    ],
		    // NOTE: we can't tell the real default value here, it's 'disc' for <ul> and 'decimal' for <ol>
		    // this is a hack, but it doesn't matter because this value will be either overridden or
		    // it will disappear at the final step anyway
		    defaultValue: 'decimal|disc',
		    shortestValue: 'none'
		  },
		  margin: {
		    breakUp: breakUp.fourValues,
		    canOverride: canOverride.generic.components([
		      canOverride.generic.unit,
		      canOverride.generic.unit,
		      canOverride.generic.unit,
		      canOverride.generic.unit
		    ]),
		    components: [
		      'margin-top',
		      'margin-right',
		      'margin-bottom',
		      'margin-left'
		    ],
		    defaultValue: '0',
		    propertyOptimizer: propertyOptimizers.margin,
		    restore: restore.fourValues,
		    shorthand: true,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'margin-bottom': {
		    canOverride: canOverride.generic.unit,
		    componentOf: [
		      'margin'
		    ],
		    defaultValue: '0',
		    oppositeTo: 'margin-top',
		    propertyOptimizer: propertyOptimizers.margin,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'margin-inline-end': {
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'margin-inline-start': {
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'margin-left': {
		    canOverride: canOverride.generic.unit,
		    componentOf: [
		      'margin'
		    ],
		    defaultValue: '0',
		    oppositeTo: 'margin-right',
		    propertyOptimizer: propertyOptimizers.margin,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'margin-right': {
		    canOverride: canOverride.generic.unit,
		    componentOf: [
		      'margin'
		    ],
		    defaultValue: '0',
		    oppositeTo: 'margin-left',
		    propertyOptimizer: propertyOptimizers.margin,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'margin-top': {
		    canOverride: canOverride.generic.unit,
		    componentOf: [
		      'margin'
		    ],
		    defaultValue: '0',
		    oppositeTo: 'margin-bottom',
		    propertyOptimizer: propertyOptimizers.margin,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'max-height': {
		    canOverride: canOverride.generic.unit,
		    defaultValue: 'none',
		    shortestValue: '0',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'max-width': {
		    canOverride: canOverride.generic.unit,
		    defaultValue: 'none',
		    shortestValue: '0',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'min-height': {
		    canOverride: canOverride.generic.unit,
		    defaultValue: '0',
		    shortestValue: '0',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'min-width': {
		    canOverride: canOverride.generic.unit,
		    defaultValue: '0',
		    shortestValue: '0',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  opacity: {
		    valueOptimizers: [
		      valueOptimizers.fraction,
		      valueOptimizers.precision
		    ]
		  },
		  outline: {
		    canOverride: canOverride.generic.components([
		      canOverride.generic.color,
		      canOverride.property.outlineStyle,
		      canOverride.generic.unit
		    ]),
		    components: [
		      'outline-color',
		      'outline-style',
		      'outline-width'
		    ],
		    breakUp: breakUp.outline,
		    restore: restore.withoutDefaults,
		    defaultValue: '0',
		    propertyOptimizer: propertyOptimizers.outline,
		    shorthand: true,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'outline-color': {
		    canOverride: canOverride.generic.color,
		    componentOf: [
		      'outline'
		    ],
		    defaultValue: 'invert',
		    shortestValue: 'red',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.color
		    ]
		  },
		  'outline-style': {
		    canOverride: canOverride.property.outlineStyle,
		    componentOf: [
		      'outline'
		    ],
		    defaultValue: 'none'
		  },
		  'outline-width': {
		    canOverride: canOverride.generic.unit,
		    componentOf: [
		      'outline'
		    ],
		    defaultValue: 'medium',
		    shortestValue: '0',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  overflow: {
		    canOverride: canOverride.property.overflow,
		    defaultValue: 'visible'
		  },
		  'overflow-x': {
		    canOverride: canOverride.property.overflow,
		    defaultValue: 'visible'
		  },
		  'overflow-y': {
		    canOverride: canOverride.property.overflow,
		    defaultValue: 'visible'
		  },
		  padding: {
		    breakUp: breakUp.fourValues,
		    canOverride: canOverride.generic.components([
		      canOverride.generic.unit,
		      canOverride.generic.unit,
		      canOverride.generic.unit,
		      canOverride.generic.unit
		    ]),
		    components: [
		      'padding-top',
		      'padding-right',
		      'padding-bottom',
		      'padding-left'
		    ],
		    defaultValue: '0',
		    propertyOptimizer: propertyOptimizers.padding,
		    restore: restore.fourValues,
		    shorthand: true,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'padding-bottom': {
		    canOverride: canOverride.generic.unit,
		    componentOf: [
		      'padding'
		    ],
		    defaultValue: '0',
		    oppositeTo: 'padding-top',
		    propertyOptimizer: propertyOptimizers.padding,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'padding-left': {
		    canOverride: canOverride.generic.unit,
		    componentOf: [
		      'padding'
		    ],
		    defaultValue: '0',
		    oppositeTo: 'padding-right',
		    propertyOptimizer: propertyOptimizers.padding,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'padding-right': {
		    canOverride: canOverride.generic.unit,
		    componentOf: [
		      'padding'
		    ],
		    defaultValue: '0',
		    oppositeTo: 'padding-left',
		    propertyOptimizer: propertyOptimizers.padding,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'padding-top': {
		    canOverride: canOverride.generic.unit,
		    componentOf: [
		      'padding'
		    ],
		    defaultValue: '0',
		    oppositeTo: 'padding-bottom',
		    propertyOptimizer: propertyOptimizers.padding,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  position: {
		    canOverride: canOverride.property.position,
		    defaultValue: 'static'
		  },
		  right: {
		    canOverride: canOverride.property.right,
		    defaultValue: 'auto',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'row-gap': {
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  src: {
		    valueOptimizers: [
		      valueOptimizers.urlWhiteSpace,
		      valueOptimizers.urlPrefix,
		      valueOptimizers.urlQuotes
		    ]
		  },
		  'stroke-width': {
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'text-align': {
		    canOverride: canOverride.property.textAlign,
		    // NOTE: we can't tell the real default value here, as it depends on default text direction
		    // this is a hack, but it doesn't matter because this value will be either overridden or
		    // it will disappear anyway
		    defaultValue: 'left|right'
		  },
		  'text-decoration': {
		    canOverride: canOverride.property.textDecoration,
		    defaultValue: 'none'
		  },
		  'text-indent': {
		    canOverride: canOverride.property.textOverflow,
		    defaultValue: 'none',
		    valueOptimizers: [
		      valueOptimizers.fraction,
		      valueOptimizers.zero
		    ]
		  },
		  'text-overflow': {
		    canOverride: canOverride.property.textOverflow,
		    defaultValue: 'none'
		  },
		  'text-shadow': {
		    canOverride: canOverride.property.textShadow,
		    defaultValue: 'none',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.zero,
		      valueOptimizers.color
		    ]
		  },
		  top: {
		    canOverride: canOverride.property.top,
		    defaultValue: 'auto',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  transform: {
		    canOverride: canOverride.property.transform,
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.degrees,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ],
		    vendorPrefixes: [
		      '-moz-',
		      '-ms-',
		      '-o-',
		      '-webkit-'
		    ]
		  },
		  transition: {
		    breakUp: breakUp.multiplex(breakUp.transition),
		    canOverride: canOverride.generic.components([
		      canOverride.property.transitionProperty,
		      canOverride.generic.time,
		      canOverride.generic.timingFunction,
		      canOverride.generic.time
		    ]),
		    components: [
		      'transition-property',
		      'transition-duration',
		      'transition-timing-function',
		      'transition-delay'
		    ],
		    defaultValue: 'none',
		    restore: restore.multiplex(restore.withoutDefaults),
		    shorthand: true,
		    valueOptimizers: [
		      valueOptimizers.time,
		      valueOptimizers.fraction
		    ],
		    vendorPrefixes: [
		      '-moz-',
		      '-ms-',
		      '-o-',
		      '-webkit-'
		    ]
		  },
		  'transition-delay': {
		    canOverride: canOverride.generic.time,
		    componentOf: [
		      'transition'
		    ],
		    defaultValue: '0s',
		    intoMultiplexMode: 'real',
		    valueOptimizers: [
		      valueOptimizers.time
		    ],
		    vendorPrefixes: [
		      '-moz-',
		      '-ms-',
		      '-o-',
		      '-webkit-'
		    ]
		  },
		  'transition-duration': {
		    canOverride: canOverride.generic.time,
		    componentOf: [
		      'transition'
		    ],
		    defaultValue: '0s',
		    intoMultiplexMode: 'real',
		    keepUnlessDefault: 'transition-delay',
		    valueOptimizers: [
		      valueOptimizers.time,
		      valueOptimizers.fraction
		    ],
		    vendorPrefixes: [
		      '-moz-',
		      '-ms-',
		      '-o-',
		      '-webkit-'
		    ]
		  },
		  'transition-property': {
		    canOverride: canOverride.generic.propertyName,
		    componentOf: [
		      'transition'
		    ],
		    defaultValue: 'all',
		    intoMultiplexMode: 'placeholder',
		    placeholderValue: '_', // it's a short value that won't match any property and still be a valid `transition-property`
		    vendorPrefixes: [
		      '-moz-',
		      '-ms-',
		      '-o-',
		      '-webkit-'
		    ]
		  },
		  'transition-timing-function': {
		    canOverride: canOverride.generic.timingFunction,
		    componentOf: [
		      'transition'
		    ],
		    defaultValue: 'ease',
		    intoMultiplexMode: 'real',
		    vendorPrefixes: [
		      '-moz-',
		      '-ms-',
		      '-o-',
		      '-webkit-'
		    ]
		  },
		  'vertical-align': {
		    canOverride: canOverride.property.verticalAlign,
		    defaultValue: 'baseline',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  visibility: {
		    canOverride: canOverride.property.visibility,
		    defaultValue: 'visible'
		  },
		  '-webkit-tap-highlight-color': {
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.color
		    ]
		  },
		  '-webkit-margin-end': {
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'white-space': {
		    canOverride: canOverride.property.whiteSpace,
		    defaultValue: 'normal'
		  },
		  width: {
		    canOverride: canOverride.generic.unit,
		    defaultValue: 'auto',
		    shortestValue: '0',
		    valueOptimizers: [
		      valueOptimizers.whiteSpace,
		      valueOptimizers.fraction,
		      valueOptimizers.precision,
		      valueOptimizers.unit,
		      valueOptimizers.zero
		    ]
		  },
		  'z-index': {
		    canOverride: canOverride.property.zIndex,
		    defaultValue: 'auto'
		  }
		};

		// generate vendor-prefixed configuration
		var vendorPrefixedConfiguration = {};

		function cloneDescriptor(propertyName, prefix) {
		  var clonedDescriptor = override(configuration[propertyName], {});

		  if ('componentOf' in clonedDescriptor) {
		    clonedDescriptor.componentOf = clonedDescriptor.componentOf.map(function(shorthandName) {
		      return prefix + shorthandName;
		    });
		  }

		  if ('components' in clonedDescriptor) {
		    clonedDescriptor.components = clonedDescriptor.components.map(function(longhandName) {
		      return prefix + longhandName;
		    });
		  }

		  if ('keepUnlessDefault' in clonedDescriptor) {
		    clonedDescriptor.keepUnlessDefault = prefix + clonedDescriptor.keepUnlessDefault;
		  }

		  return clonedDescriptor;
		}

		for (var propertyName in configuration) {
		  var descriptor = configuration[propertyName];

		  if (!('vendorPrefixes' in descriptor)) {
		    continue;
		  }

		  for (var i = 0; i < descriptor.vendorPrefixes.length; i++) {
		    var prefix = descriptor.vendorPrefixes[i];
		    var clonedDescriptor = cloneDescriptor(propertyName, prefix);
		    delete clonedDescriptor.vendorPrefixes;

		    vendorPrefixedConfiguration[prefix + propertyName] = clonedDescriptor;
		  }

		  delete descriptor.vendorPrefixes;
		}

		configuration_1 = override(configuration, vendorPrefixedConfiguration);
		return configuration_1;
	}

	var helpers;
	var hasRequiredHelpers;

	function requireHelpers () {
		if (hasRequiredHelpers) return helpers;
		hasRequiredHelpers = 1;
		var emptyCharacter = '';

		var Breaks = requireFormat$1().Breaks;
		var Spaces = requireFormat$1().Spaces;

		var Marker = requireMarker();
		var Token = requireToken();

		function supportsAfterClosingBrace(token) {
		  return token[1][1] == 'background' || token[1][1] == 'transform' || token[1][1] == 'src';
		}

		function afterClosingBrace(token, valueIndex) {
		  return token[valueIndex][1][token[valueIndex][1].length - 1] == Marker.CLOSE_ROUND_BRACKET;
		}

		function afterComma(token, valueIndex) {
		  return token[valueIndex][1] == Marker.COMMA;
		}

		function afterSlash(token, valueIndex) {
		  return token[valueIndex][1] == Marker.FORWARD_SLASH;
		}

		function beforeComma(token, valueIndex) {
		  return token[valueIndex + 1] && token[valueIndex + 1][1] == Marker.COMMA;
		}

		function beforeSlash(token, valueIndex) {
		  return token[valueIndex + 1] && token[valueIndex + 1][1] == Marker.FORWARD_SLASH;
		}

		function inFilter(token) {
		  return token[1][1] == 'filter' || token[1][1] == '-ms-filter';
		}

		function disallowsSpace(context, token, valueIndex) {
		  return !context.spaceAfterClosingBrace
		    && supportsAfterClosingBrace(token)
		    && afterClosingBrace(token, valueIndex)
		    || beforeSlash(token, valueIndex)
		    || afterSlash(token, valueIndex)
		    || beforeComma(token, valueIndex)
		    || afterComma(token, valueIndex);
		}

		function rules(context, tokens) {
		  var store = context.store;

		  for (var i = 0, l = tokens.length; i < l; i++) {
		    store(context, tokens[i]);

		    if (i < l - 1) {
		      store(context, comma(context));
		    }
		  }
		}

		function body(context, tokens) {
		  var lastPropertyAt = lastPropertyIndex(tokens);

		  for (var i = 0, l = tokens.length; i < l; i++) {
		    property(context, tokens, i, lastPropertyAt);
		  }
		}

		function lastPropertyIndex(tokens) {
		  var index = tokens.length - 1;

		  for (; index >= 0; index--) {
		    if (tokens[index][0] != Token.COMMENT) {
		      break;
		    }
		  }

		  return index;
		}

		function property(context, tokens, position, lastPropertyAt) {
		  var store = context.store;
		  var token = tokens[position];

		  var propertyValue = token[2];
		  var isPropertyBlock = propertyValue && propertyValue[0] === Token.PROPERTY_BLOCK;

		  var needsSemicolon;
		  if (context.format) {
		    if (context.format.semicolonAfterLastProperty || isPropertyBlock) {
		      needsSemicolon = true;
		    } else if (position < lastPropertyAt) {
		      needsSemicolon = true;
		    } else {
		      needsSemicolon = false;
		    }
		  } else {
		    needsSemicolon = position < lastPropertyAt || isPropertyBlock;
		  }

		  var isLast = position === lastPropertyAt;

		  switch (token[0]) {
		  case Token.AT_RULE:
		    store(context, token);
		    store(context, semicolon(context, Breaks.AfterProperty, false));
		    break;
		  case Token.AT_RULE_BLOCK:
		    rules(context, token[1]);
		    store(context, openBrace(context, Breaks.AfterRuleBegins, true));
		    body(context, token[2]);
		    store(context, closeBrace(context, Breaks.AfterRuleEnds, false, isLast));
		    break;
		  case Token.COMMENT:
		    store(context, token);
		    store(context, breakFor(context, Breaks.AfterComment) + context.indentWith);
		    break;
		  case Token.PROPERTY:
		    store(context, token[1]);
		    store(context, colon(context));
		    if (propertyValue) {
		      value(context, token);
		    }
		    store(
		      context,
		      needsSemicolon ? semicolon(context, Breaks.AfterProperty, isLast) : emptyCharacter
		    );
		    break;
		  case Token.RAW:
		    store(context, token);
		  }
		}

		function value(context, token) {
		  var store = context.store;
		  var j, m;

		  if (token[2][0] == Token.PROPERTY_BLOCK) {
		    store(context, openBrace(context, Breaks.AfterBlockBegins, false));
		    body(context, token[2][1]);
		    store(context, closeBrace(context, Breaks.AfterBlockEnds, false, true));
		  } else {
		    for (j = 2, m = token.length; j < m; j++) {
		      store(context, token[j]);

		      if (j < m - 1 && (inFilter(token) || !disallowsSpace(context, token, j))) {
		        store(context, Marker.SPACE);
		      }
		    }
		  }
		}

		function breakFor(context, where) {
		  return context.format ? context.format.breaks[where] : emptyCharacter;
		}

		function allowsSpace(context, where) {
		  return context.format && context.format.spaces[where];
		}

		function openBrace(context, where, needsPrefixSpace) {
		  if (context.format) {
		    context.indentBy += context.format.indentBy;
		    context.indentWith = context.format.indentWith.repeat(context.indentBy);
		    return (
		      needsPrefixSpace
		      && allowsSpace(context, Spaces.BeforeBlockBegins) ? Marker.SPACE : emptyCharacter
		    ) + Marker.OPEN_CURLY_BRACKET
		      + breakFor(context, where)
		      + context.indentWith;
		  }
		  return Marker.OPEN_CURLY_BRACKET;
		}

		function closeBrace(context, where, beforeBlockEnd, isLast) {
		  if (context.format) {
		    context.indentBy -= context.format.indentBy;
		    context.indentWith = context.format.indentWith.repeat(context.indentBy);
		    return (
		      beforeBlockEnd
		        ? breakFor(context, Breaks.BeforeBlockEnds)
		        : breakFor(context, Breaks.AfterProperty)
		    ) + context.indentWith
		      + Marker.CLOSE_CURLY_BRACKET
		      + (isLast ? emptyCharacter : breakFor(context, where) + context.indentWith);
		  }
		  return Marker.CLOSE_CURLY_BRACKET;
		}

		function colon(context) {
		  return context.format
		    ? Marker.COLON + (allowsSpace(context, Spaces.BeforeValue) ? Marker.SPACE : emptyCharacter)
		    : Marker.COLON;
		}

		function semicolon(context, where, isLast) {
		  return context.format
		    ? Marker.SEMICOLON + (isLast ? emptyCharacter : (breakFor(context, where) + context.indentWith))
		    : Marker.SEMICOLON;
		}

		function comma(context) {
		  return context.format
		    ? Marker.COMMA + breakFor(context, Breaks.BetweenSelectors) + context.indentWith
		    : Marker.COMMA;
		}

		function all(context, tokens) {
		  var store = context.store;
		  var token;
		  var isLast;
		  var i, l;

		  for (i = 0, l = tokens.length; i < l; i++) {
		    token = tokens[i];
		    isLast = i == l - 1;

		    switch (token[0]) {
		    case Token.AT_RULE:
		      store(context, token);
		      store(context, semicolon(context, Breaks.AfterAtRule, isLast));
		      break;
		    case Token.AT_RULE_BLOCK:
		      rules(context, token[1]);
		      store(context, openBrace(context, Breaks.AfterRuleBegins, true));
		      body(context, token[2]);
		      store(context, closeBrace(context, Breaks.AfterRuleEnds, false, isLast));
		      break;
		    case Token.NESTED_BLOCK:
		      rules(context, token[1]);
		      store(context, openBrace(context, Breaks.AfterBlockBegins, true));
		      all(context, token[2]);
		      store(context, closeBrace(context, Breaks.AfterBlockEnds, true, isLast));
		      break;
		    case Token.COMMENT:
		      store(context, token);
		      store(context, breakFor(context, Breaks.AfterComment) + context.indentWith);
		      break;
		    case Token.RAW:
		      store(context, token);
		      break;
		    case Token.RULE:
		      rules(context, token[1]);
		      store(context, openBrace(context, Breaks.AfterRuleBegins, true));
		      body(context, token[2]);
		      store(context, closeBrace(context, Breaks.AfterRuleEnds, false, isLast));
		      break;
		    }
		  }
		}

		helpers = {
		  all: all,
		  body: body,
		  property: property,
		  rules: rules,
		  value: value
		};
		return helpers;
	}

	var oneTime;
	var hasRequiredOneTime;

	function requireOneTime () {
		if (hasRequiredOneTime) return oneTime;
		hasRequiredOneTime = 1;
		var helpers = requireHelpers();

		function store(serializeContext, token) {
		  serializeContext.output.push(typeof token == 'string' ? token : token[1]);
		}

		function context() {
		  var newContext = {
		    output: [],
		    store: store
		  };

		  return newContext;
		}

		function all(tokens) {
		  var oneTimeContext = context();
		  helpers.all(oneTimeContext, tokens);
		  return oneTimeContext.output.join('');
		}

		function body(tokens) {
		  var oneTimeContext = context();
		  helpers.body(oneTimeContext, tokens);
		  return oneTimeContext.output.join('');
		}

		function property(tokens, position) {
		  var oneTimeContext = context();
		  helpers.property(oneTimeContext, tokens, position, true);
		  return oneTimeContext.output.join('');
		}

		function rules(tokens) {
		  var oneTimeContext = context();
		  helpers.rules(oneTimeContext, tokens);
		  return oneTimeContext.output.join('');
		}

		function value(tokens) {
		  var oneTimeContext = context();
		  helpers.value(oneTimeContext, tokens);
		  return oneTimeContext.output.join('');
		}

		oneTime = {
		  all: all,
		  body: body,
		  property: property,
		  rules: rules,
		  value: value
		};
		return oneTime;
	}

	var optimize$2;
	var hasRequiredOptimize$2;

	function requireOptimize$2 () {
		if (hasRequiredOptimize$2) return optimize$2;
		hasRequiredOptimize$2 = 1;
		var sortSelectors = requireSortSelectors();
		var tidyRules = requireTidyRules();
		var tidyBlock = requireTidyBlock();
		var tidyAtRule = requireTidyAtRule();

		var Hack = requireHack();
		var removeUnused = requireRemoveUnused();
		var restoreFromOptimizing = requireRestoreFromOptimizing();
		var wrapForOptimizing = requireWrapForOptimizing().all;

		var configuration = requireConfiguration();
		var optimizers = requireValueOptimizers();

		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;

		var Token = requireToken();
		var Marker = requireMarker();

		var formatPosition = requireFormatPosition();

		var serializeRules = requireOneTime().rules;

		var CHARSET_TOKEN = '@charset';
		var CHARSET_REGEXP = new RegExp('^' + CHARSET_TOKEN, 'i');

		var DEFAULT_ROUNDING_PRECISION = requireRoundingPrecision().DEFAULT;

		var VARIABLE_PROPERTY_NAME_PATTERN = /^--\S+$/;
		var PROPERTY_NAME_PATTERN = /^(?:-chrome-|-[\w-]+\w|\w[\w-]+\w|\w{1,})$/;
		var IMPORT_PREFIX_PATTERN = /^@import/i;
		var URL_PREFIX_PATTERN = /^url\(/i;

		function startsAsUrl(value) {
		  return URL_PREFIX_PATTERN.test(value);
		}

		function isImport(token) {
		  return IMPORT_PREFIX_PATTERN.test(token[1]);
		}

		function isLegacyFilter(property) {
		  var value;

		  if (property.name == 'filter' || property.name == '-ms-filter') {
		    value = property.value[0][1];

		    return value.indexOf('progid') > -1
		      || value.indexOf('alpha') === 0
		      || value.indexOf('chroma') === 0;
		  }
		  return false;
		}

		function noop() {}

		function noopValueOptimizer(_name, value, _options) { return value; }

		function optimizeBody(rule, properties, context) {
		  var options = context.options;
		  var valueOptimizers;
		  var property, name, type, value;
		  var propertyToken;
		  var propertyOptimizer;
		  var serializedRule = serializeRules(rule);
		  var _properties = wrapForOptimizing(properties);
		  var pluginValueOptimizers = context.options.plugins.level1Value;
		  var pluginPropertyOptimizers = context.options.plugins.level1Property;
		  var isVariable;
		  var i, l;

		  for (i = 0, l = _properties.length; i < l; i++) {
		    var j, k, m, n;

		    property = _properties[i];
		    name = property.name;
		    propertyOptimizer = configuration[name] && configuration[name].propertyOptimizer || noop;
		    valueOptimizers = configuration[name] && configuration[name].valueOptimizers || [optimizers.whiteSpace];
		    isVariable = VARIABLE_PROPERTY_NAME_PATTERN.test(name);

		    if (isVariable) {
		      valueOptimizers = options.variableOptimizers.length > 0
		        ? options.variableOptimizers
		        : [optimizers.whiteSpace];
		    }

		    if (!isVariable && !PROPERTY_NAME_PATTERN.test(name)) {
		      propertyToken = property.all[property.position];
		      context.warnings.push('Invalid property name \'' + name + '\' at ' + formatPosition(propertyToken[1][2][0]) + '. Ignoring.');
		      property.unused = true;
		      continue;
		    }

		    if (property.value.length === 0) {
		      propertyToken = property.all[property.position];
		      context.warnings.push('Empty property \'' + name + '\' at ' + formatPosition(propertyToken[1][2][0]) + '. Ignoring.');
		      property.unused = true;
		      continue;
		    }

		    if (property.hack && (
		      (property.hack[0] == Hack.ASTERISK || property.hack[0] == Hack.UNDERSCORE)
		        && !options.compatibility.properties.iePrefixHack
		        || property.hack[0] == Hack.BACKSLASH && !options.compatibility.properties.ieSuffixHack
		        || property.hack[0] == Hack.BANG && !options.compatibility.properties.ieBangHack)) {
		      property.unused = true;
		      continue;
		    }

		    if (!options.compatibility.properties.ieFilters && isLegacyFilter(property)) {
		      property.unused = true;
		      continue;
		    }

		    if (property.block) {
		      optimizeBody(rule, property.value[0][1], context);
		      continue;
		    }

		    for (j = 0, m = property.value.length; j < m; j++) {
		      type = property.value[j][0];
		      value = property.value[j][1];

		      if (type == Token.PROPERTY_BLOCK) {
		        property.unused = true;
		        context.warnings.push('Invalid value token at ' + formatPosition(value[0][1][2][0]) + '. Ignoring.');
		        break;
		      }

		      if (startsAsUrl(value) && !context.validator.isUrl(value)) {
		        property.unused = true;
		        context.warnings.push('Broken URL \'' + value + '\' at ' + formatPosition(property.value[j][2][0]) + '. Ignoring.');
		        break;
		      }

		      for (k = 0, n = valueOptimizers.length; k < n; k++) {
		        value = valueOptimizers[k](name, value, options);
		      }

		      for (k = 0, n = pluginValueOptimizers.length; k < n; k++) {
		        value = pluginValueOptimizers[k](name, value, options);
		      }

		      property.value[j][1] = value;
		    }

		    propertyOptimizer(serializedRule, property, options);

		    for (j = 0, m = pluginPropertyOptimizers.length; j < m; j++) {
		      pluginPropertyOptimizers[j](serializedRule, property, options);
		    }
		  }

		  restoreFromOptimizing(_properties);
		  removeUnused(_properties);
		  removeComments(properties, options);
		}

		function removeComments(tokens, options) {
		  var token;
		  var i;

		  for (i = 0; i < tokens.length; i++) {
		    token = tokens[i];

		    if (token[0] != Token.COMMENT) {
		      continue;
		    }

		    optimizeComment(token, options);

		    if (token[1].length === 0) {
		      tokens.splice(i, 1);
		      i--;
		    }
		  }
		}

		function optimizeComment(token, options) {
		  if (token[1][2] == Marker.EXCLAMATION && (options.level[OptimizationLevel.One].specialComments == 'all' || options.commentsKept < options.level[OptimizationLevel.One].specialComments)) {
		    options.commentsKept++;
		    return;
		  }

		  token[1] = [];
		}

		function cleanupCharsets(tokens) {
		  var hasCharset = false;

		  for (var i = 0, l = tokens.length; i < l; i++) {
		    var token = tokens[i];

		    if (token[0] != Token.AT_RULE) { continue; }

		    if (!CHARSET_REGEXP.test(token[1])) { continue; }

		    if (hasCharset || token[1].indexOf(CHARSET_TOKEN) == -1) {
		      tokens.splice(i, 1);
		      i--;
		      l--;
		    } else {
		      hasCharset = true;
		      tokens.splice(i, 1);
		      tokens.unshift([Token.AT_RULE, token[1].replace(CHARSET_REGEXP, CHARSET_TOKEN)]);
		    }
		  }
		}

		function buildUnitRegexp(options) {
		  var units = ['px', 'em', 'ex', 'cm', 'mm', 'in', 'pt', 'pc', '%'];
		  var otherUnits = ['ch', 'rem', 'vh', 'vm', 'vmax', 'vmin', 'vw'];

		  otherUnits.forEach(function(unit) {
		    if (options.compatibility.units[unit]) {
		      units.push(unit);
		    }
		  });

		  return new RegExp('(^|\\s|\\(|,)0(?:' + units.join('|') + ')(\\W|$)', 'g');
		}

		function buildPrecisionOptions(roundingPrecision) {
		  var precisionOptions = {
		    matcher: null,
		    units: {}
		  };
		  var optimizable = [];
		  var unit;
		  var value;

		  for (unit in roundingPrecision) {
		    value = roundingPrecision[unit];

		    if (value != DEFAULT_ROUNDING_PRECISION) {
		      precisionOptions.units[unit] = {};
		      precisionOptions.units[unit].value = value;
		      precisionOptions.units[unit].multiplier = 10 ** value;

		      optimizable.push(unit);
		    }
		  }

		  if (optimizable.length > 0) {
		    precisionOptions.enabled = true;
		    precisionOptions.decimalPointMatcher = new RegExp('(\\d)\\.($|' + optimizable.join('|') + ')($|\\W)', 'g');
		    precisionOptions.zeroMatcher = new RegExp('(\\d*)(\\.\\d+)(' + optimizable.join('|') + ')', 'g');
		  }

		  return precisionOptions;
		}

		function buildVariableOptimizers(options) {
		  return options.level[OptimizationLevel.One].variableValueOptimizers.map(function(optimizer) {
		    if (typeof (optimizer) == 'string') {
		      return optimizers[optimizer] || noopValueOptimizer;
		    }

		    return optimizer;
		  });
		}

		function level1Optimize(tokens, context) {
		  var options = context.options;
		  var levelOptions = options.level[OptimizationLevel.One];
		  var ie7Hack = options.compatibility.selectors.ie7Hack;
		  var adjacentSpace = options.compatibility.selectors.adjacentSpace;
		  var spaceAfterClosingBrace = options.compatibility.properties.spaceAfterClosingBrace;
		  var format = options.format;
		  var mayHaveCharset = false;
		  var afterRules = false;

		  options.unitsRegexp = options.unitsRegexp || buildUnitRegexp(options);
		  options.precision = options.precision || buildPrecisionOptions(levelOptions.roundingPrecision);
		  options.commentsKept = options.commentsKept || 0;
		  options.variableOptimizers = options.variableOptimizers || buildVariableOptimizers(options);

		  for (var i = 0, l = tokens.length; i < l; i++) {
		    var token = tokens[i];

		    switch (token[0]) {
		    case Token.AT_RULE:
		      token[1] = isImport(token) && afterRules ? '' : token[1];
		      token[1] = levelOptions.tidyAtRules ? tidyAtRule(token[1]) : token[1];
		      mayHaveCharset = true;
		      break;
		    case Token.AT_RULE_BLOCK:
		      optimizeBody(token[1], token[2], context);
		      afterRules = true;
		      break;
		    case Token.NESTED_BLOCK:
		      token[1] = levelOptions.tidyBlockScopes ? tidyBlock(token[1], spaceAfterClosingBrace) : token[1];
		      level1Optimize(token[2], context);
		      afterRules = true;
		      break;
		    case Token.COMMENT:
		      optimizeComment(token, options);
		      break;
		    case Token.RULE:
		      token[1] = levelOptions.tidySelectors
		        ? tidyRules(token[1], !ie7Hack, adjacentSpace, format, context.warnings)
		        : token[1];
		      token[1] = token[1].length > 1 ? sortSelectors(token[1], levelOptions.selectorsSortingMethod) : token[1];
		      optimizeBody(token[1], token[2], context);
		      afterRules = true;
		      break;
		    }

		    if (token[0] == Token.COMMENT
		      && token[1].length === 0
		      || levelOptions.removeEmpty
		      && (token[1].length === 0 || (token[2] && token[2].length === 0))) {
		      tokens.splice(i, 1);
		      i--;
		      l--;
		    }
		  }

		  if (levelOptions.cleanupCharsets && mayHaveCharset) {
		    cleanupCharsets(tokens);
		  }

		  return tokens;
		}

		optimize$2 = level1Optimize;
		return optimize$2;
	}

	var isMergeable_1;
	var hasRequiredIsMergeable;

	function requireIsMergeable () {
		if (hasRequiredIsMergeable) return isMergeable_1;
		hasRequiredIsMergeable = 1;
		var Marker = requireMarker();
		var split = requireSplit();

		var DEEP_SELECTOR_PATTERN = /\/deep\//;
		var DOUBLE_COLON_PATTERN = /^::/;
		var VENDOR_PREFIXED_PATTERN = /:(-moz-|-ms-|-o-|-webkit-)/;

		var NOT_PSEUDO = ':not';
		var PSEUDO_CLASSES_WITH_ARGUMENTS = [
		  ':dir',
		  ':lang',
		  ':not',
		  ':nth-child',
		  ':nth-last-child',
		  ':nth-last-of-type',
		  ':nth-of-type'
		];
		var RELATION_PATTERN = /[>+~]/;
		var UNMIXABLE_PSEUDO_CLASSES = [
		  ':after',
		  ':before',
		  ':first-letter',
		  ':first-line',
		  ':lang'
		];
		var UNMIXABLE_PSEUDO_ELEMENTS = [
		  '::after',
		  '::before',
		  '::first-letter',
		  '::first-line'
		];

		var Level = {
		  DOUBLE_QUOTE: 'double-quote',
		  SINGLE_QUOTE: 'single-quote',
		  ROOT: 'root'
		};

		function isMergeable(selector, mergeablePseudoClasses, mergeablePseudoElements, multiplePseudoMerging) {
		  var singleSelectors = split(selector, Marker.COMMA);
		  var singleSelector;
		  var i, l;

		  for (i = 0, l = singleSelectors.length; i < l; i++) {
		    singleSelector = singleSelectors[i];

		    if (singleSelector.length === 0
		        || isDeepSelector(singleSelector)
		        || isVendorPrefixed(singleSelector)
		        || (singleSelector.indexOf(Marker.COLON) > -1
		          && !areMergeable(
		            singleSelector,
		            extractPseudoFrom(singleSelector),
		            mergeablePseudoClasses,
		            mergeablePseudoElements,
		            multiplePseudoMerging
		          ))) {
		      return false;
		    }
		  }

		  return true;
		}

		function isDeepSelector(selector) {
		  return DEEP_SELECTOR_PATTERN.test(selector);
		}

		function isVendorPrefixed(selector) {
		  return VENDOR_PREFIXED_PATTERN.test(selector);
		}

		function extractPseudoFrom(selector) {
		  var list = [];
		  var character;
		  var buffer = [];
		  var level = Level.ROOT;
		  var roundBracketLevel = 0;
		  var isQuoted;
		  var isEscaped;
		  var isPseudo = false;
		  var isRelation;
		  var wasColon = false;
		  var index;
		  var len;

		  for (index = 0, len = selector.length; index < len; index++) {
		    character = selector[index];

		    isRelation = !isEscaped && RELATION_PATTERN.test(character);
		    isQuoted = level == Level.DOUBLE_QUOTE || level == Level.SINGLE_QUOTE;

		    if (isEscaped) {
		      buffer.push(character);
		    } else if (character == Marker.DOUBLE_QUOTE && level == Level.ROOT) {
		      buffer.push(character);
		      level = Level.DOUBLE_QUOTE;
		    } else if (character == Marker.DOUBLE_QUOTE && level == Level.DOUBLE_QUOTE) {
		      buffer.push(character);
		      level = Level.ROOT;
		    } else if (character == Marker.SINGLE_QUOTE && level == Level.ROOT) {
		      buffer.push(character);
		      level = Level.SINGLE_QUOTE;
		    } else if (character == Marker.SINGLE_QUOTE && level == Level.SINGLE_QUOTE) {
		      buffer.push(character);
		      level = Level.ROOT;
		    } else if (isQuoted) {
		      buffer.push(character);
		    } else if (character == Marker.OPEN_ROUND_BRACKET) {
		      buffer.push(character);
		      roundBracketLevel++;
		    } else if (character == Marker.CLOSE_ROUND_BRACKET && roundBracketLevel == 1 && isPseudo) {
		      buffer.push(character);
		      list.push(buffer.join(''));
		      roundBracketLevel--;
		      buffer = [];
		      isPseudo = false;
		    } else if (character == Marker.CLOSE_ROUND_BRACKET) {
		      buffer.push(character);
		      roundBracketLevel--;
		    } else if (character == Marker.COLON && roundBracketLevel === 0 && isPseudo && !wasColon) {
		      list.push(buffer.join(''));
		      buffer = [];
		      buffer.push(character);
		    } else if (character == Marker.COLON && roundBracketLevel === 0 && !wasColon) {
		      buffer = [];
		      buffer.push(character);
		      isPseudo = true;
		    } else if (character == Marker.SPACE && roundBracketLevel === 0 && isPseudo) {
		      list.push(buffer.join(''));
		      buffer = [];
		      isPseudo = false;
		    } else if (isRelation && roundBracketLevel === 0 && isPseudo) {
		      list.push(buffer.join(''));
		      buffer = [];
		      isPseudo = false;
		    } else {
		      buffer.push(character);
		    }

		    isEscaped = character == Marker.BACK_SLASH;
		    wasColon = character == Marker.COLON;
		  }

		  if (buffer.length > 0 && isPseudo) {
		    list.push(buffer.join(''));
		  }

		  return list;
		}

		function areMergeable(selector, matches, mergeablePseudoClasses, mergeablePseudoElements, multiplePseudoMerging) {
		  return areAllowed(matches, mergeablePseudoClasses, mergeablePseudoElements)
		    && needArguments(matches)
		    && (matches.length < 2 || !someIncorrectlyChained(selector, matches))
		    && (matches.length < 2 || multiplePseudoMerging && allMixable(matches));
		}

		function areAllowed(matches, mergeablePseudoClasses, mergeablePseudoElements) {
		  var match;
		  var name;
		  var i, l;

		  for (i = 0, l = matches.length; i < l; i++) {
		    match = matches[i];
		    name = match.indexOf(Marker.OPEN_ROUND_BRACKET) > -1
		      ? match.substring(0, match.indexOf(Marker.OPEN_ROUND_BRACKET))
		      : match;

		    if (mergeablePseudoClasses.indexOf(name) === -1 && mergeablePseudoElements.indexOf(name) === -1) {
		      return false;
		    }
		  }

		  return true;
		}

		function needArguments(matches) {
		  var match;
		  var name;
		  var bracketOpensAt;
		  var hasArguments;
		  var i, l;

		  for (i = 0, l = matches.length; i < l; i++) {
		    match = matches[i];

		    bracketOpensAt = match.indexOf(Marker.OPEN_ROUND_BRACKET);
		    hasArguments = bracketOpensAt > -1;
		    name = hasArguments
		      ? match.substring(0, bracketOpensAt)
		      : match;

		    if (hasArguments && PSEUDO_CLASSES_WITH_ARGUMENTS.indexOf(name) == -1) {
		      return false;
		    }

		    if (!hasArguments && PSEUDO_CLASSES_WITH_ARGUMENTS.indexOf(name) > -1) {
		      return false;
		    }
		  }

		  return true;
		}

		function someIncorrectlyChained(selector, matches) {
		  var positionInSelector = 0;
		  var match;
		  var matchAt;
		  var nextMatch;
		  var nextMatchAt;
		  var name;
		  var nextName;
		  var areChained;
		  var i, l;

		  for (i = 0, l = matches.length; i < l; i++) {
		    match = matches[i];
		    nextMatch = matches[i + 1];

		    if (!nextMatch) {
		      break;
		    }

		    matchAt = selector.indexOf(match, positionInSelector);
		    nextMatchAt = selector.indexOf(match, matchAt + 1);
		    positionInSelector = nextMatchAt;
		    areChained = matchAt + match.length == nextMatchAt;

		    if (areChained) {
		      name = match.indexOf(Marker.OPEN_ROUND_BRACKET) > -1
		        ? match.substring(0, match.indexOf(Marker.OPEN_ROUND_BRACKET))
		        : match;
		      nextName = nextMatch.indexOf(Marker.OPEN_ROUND_BRACKET) > -1
		        ? nextMatch.substring(0, nextMatch.indexOf(Marker.OPEN_ROUND_BRACKET))
		        : nextMatch;

		      if (name != NOT_PSEUDO || nextName != NOT_PSEUDO) {
		        return true;
		      }
		    }
		  }

		  return false;
		}

		function allMixable(matches) {
		  var unmixableMatches = 0;
		  var match;
		  var i, l;

		  for (i = 0, l = matches.length; i < l; i++) {
		    match = matches[i];

		    if (isPseudoElement(match)) {
		      unmixableMatches += UNMIXABLE_PSEUDO_ELEMENTS.indexOf(match) > -1 ? 1 : 0;
		    } else {
		      unmixableMatches += UNMIXABLE_PSEUDO_CLASSES.indexOf(match) > -1 ? 1 : 0;
		    }

		    if (unmixableMatches > 1) {
		      return false;
		    }
		  }

		  return true;
		}

		function isPseudoElement(pseudo) {
		  return DOUBLE_COLON_PATTERN.test(pseudo);
		}

		isMergeable_1 = isMergeable;
		return isMergeable_1;
	}

	var everyValuesPair_1;
	var hasRequiredEveryValuesPair;

	function requireEveryValuesPair () {
		if (hasRequiredEveryValuesPair) return everyValuesPair_1;
		hasRequiredEveryValuesPair = 1;
		var Marker = requireMarker();

		function everyValuesPair(fn, left, right) {
		  var leftSize = left.value.length;
		  var rightSize = right.value.length;
		  var total = Math.max(leftSize, rightSize);
		  var lowerBound = Math.min(leftSize, rightSize) - 1;
		  var leftValue;
		  var rightValue;
		  var position;

		  for (position = 0; position < total; position++) {
		    leftValue = left.value[position] && left.value[position][1] || leftValue;
		    rightValue = right.value[position] && right.value[position][1] || rightValue;

		    if (leftValue == Marker.COMMA || rightValue == Marker.COMMA) {
		      continue;
		    }

		    if (!fn(leftValue, rightValue, position, position <= lowerBound)) {
		      return false;
		    }
		  }

		  return true;
		}

		everyValuesPair_1 = everyValuesPair;
		return everyValuesPair_1;
	}

	var hasInherit_1;
	var hasRequiredHasInherit;

	function requireHasInherit () {
		if (hasRequiredHasInherit) return hasInherit_1;
		hasRequiredHasInherit = 1;
		function hasInherit(property) {
		  for (var i = property.value.length - 1; i >= 0; i--) {
		    if (property.value[i][1] == 'inherit') { return true; }
		  }

		  return false;
		}

		hasInherit_1 = hasInherit;
		return hasInherit_1;
	}

	var hasSameValues_1;
	var hasRequiredHasSameValues;

	function requireHasSameValues () {
		if (hasRequiredHasSameValues) return hasSameValues_1;
		hasRequiredHasSameValues = 1;
		function hasSameValues(property) {
		  var firstValue = property.value[0][1];
		  var i, l;

		  for (i = 1, l = property.value.length; i < l; i++) {
		    if (property.value[i][1] != firstValue) {
		      return false;
		    }
		  }

		  return true;
		}

		hasSameValues_1 = hasSameValues;
		return hasSameValues_1;
	}

	var populateComponents_1;
	var hasRequiredPopulateComponents;

	function requirePopulateComponents () {
		if (hasRequiredPopulateComponents) return populateComponents_1;
		hasRequiredPopulateComponents = 1;
		var configuration = requireConfiguration();
		var InvalidPropertyError = requireInvalidPropertyError();

		function populateComponents(properties, validator, warnings) {
		  var component;
		  var j, m;

		  for (var i = properties.length - 1; i >= 0; i--) {
		    var property = properties[i];
		    var descriptor = configuration[property.name];

		    if (!property.dynamic && descriptor && descriptor.shorthand) {
		      if (onlyValueIsVariable(property, validator) || moreThanOneValueIsVariable(property, validator)) {
		        property.optimizable = false;
		        continue;
		      }

		      property.shorthand = true;
		      property.dirty = true;

		      try {
		        property.components = descriptor.breakUp(property, configuration, validator);

		        if (descriptor.shorthandComponents) {
		          for (j = 0, m = property.components.length; j < m; j++) {
		            component = property.components[j];
		            component.components = configuration[component.name].breakUp(component, configuration, validator);
		          }
		        }
		      } catch (e) {
		        if (e instanceof InvalidPropertyError) {
		          property.components = []; // this will set property.unused to true below
		          warnings.push(e.message);
		        } else {
		          throw e;
		        }
		      }

		      if (property.components.length > 0) {
		        property.multiplex = property.components[0].multiplex;
		      } else {
		        property.unused = true;
		      }
		    }
		  }
		}

		function onlyValueIsVariable(property, validator) {
		  return property.value.length == 1 && validator.isVariable(property.value[0][1]);
		}

		function moreThanOneValueIsVariable(property, validator) {
		  return property.value.length > 1
		    && property.value.filter(
		      function(value) {
		        return validator.isVariable(value[1]);
		      }
		    ).length > 1;
		}

		populateComponents_1 = populateComponents;
		return populateComponents_1;
	}

	var restoreWithComponents_1;
	var hasRequiredRestoreWithComponents;

	function requireRestoreWithComponents () {
		if (hasRequiredRestoreWithComponents) return restoreWithComponents_1;
		hasRequiredRestoreWithComponents = 1;
		var configuration = requireConfiguration();

		function restoreWithComponents(property) {
		  var descriptor = configuration[property.name];

		  if (descriptor && descriptor.shorthand) {
		    return descriptor.restore(property, configuration);
		  }
		  return property.value;
		}

		restoreWithComponents_1 = restoreWithComponents;
		return restoreWithComponents_1;
	}

	var mergeIntoShorthands_1;
	var hasRequiredMergeIntoShorthands;

	function requireMergeIntoShorthands () {
		if (hasRequiredMergeIntoShorthands) return mergeIntoShorthands_1;
		hasRequiredMergeIntoShorthands = 1;
		var everyValuesPair = requireEveryValuesPair();
		var hasInherit = requireHasInherit();
		var hasSameValues = requireHasSameValues();
		var populateComponents = requirePopulateComponents();

		var configuration = requireConfiguration();
		var deepClone = requireClone().deep;
		var restoreWithComponents = requireRestoreWithComponents();

		var restoreFromOptimizing = requireRestoreFromOptimizing();
		var wrapSingle = requireWrapForOptimizing().single;

		var serializeBody = requireOneTime().body;
		var Token = requireToken();

		function mergeIntoShorthands(properties, validator) {
		  var candidates = {};
		  var descriptor;
		  var componentOf;
		  var property;
		  var i, l;
		  var j, m;

		  // there is no shorthand property made up of less than 3 longhands
		  if (properties.length < 3) {
		    return;
		  }

		  for (i = 0, l = properties.length; i < l; i++) {
		    property = properties[i];
		    descriptor = configuration[property.name];

		    if (property.dynamic) {
		      continue;
		    }

		    if (property.unused) {
		      continue;
		    }

		    if (property.hack) {
		      continue;
		    }

		    if (property.block) {
		      continue;
		    }

		    if (descriptor && descriptor.singleTypeComponents && !hasSameValues(property)) {
		      continue;
		    }

		    invalidateOrCompact(properties, i, candidates, validator);

		    if (descriptor && descriptor.componentOf) {
		      for (j = 0, m = descriptor.componentOf.length; j < m; j++) {
		        componentOf = descriptor.componentOf[j];

		        candidates[componentOf] = candidates[componentOf] || {};
		        candidates[componentOf][property.name] = property;
		      }
		    }
		  }

		  invalidateOrCompact(properties, i, candidates, validator);
		}

		function invalidateOrCompact(properties, position, candidates, validator) {
		  var invalidatedBy = properties[position];
		  var shorthandName;
		  var shorthandDescriptor;
		  var candidateComponents;
		  var replacedCandidates = [];
		  var i;

		  for (shorthandName in candidates) {
		    if (undefined !== invalidatedBy && shorthandName == invalidatedBy.name) {
		      continue;
		    }

		    shorthandDescriptor = configuration[shorthandName];
		    candidateComponents = candidates[shorthandName];
		    if (invalidatedBy && invalidates(candidates, shorthandName, invalidatedBy)) {
		      delete candidates[shorthandName];
		      continue;
		    }

		    if (shorthandDescriptor.components.length > Object.keys(candidateComponents).length) {
		      continue;
		    }

		    if (mixedImportance(candidateComponents)) {
		      continue;
		    }

		    if (!overridable(candidateComponents, shorthandName, validator)) {
		      continue;
		    }

		    if (!mergeable(candidateComponents)) {
		      continue;
		    }

		    if (mixedInherit(candidateComponents)) {
		      replaceWithInheritBestFit(properties, candidateComponents, shorthandName, validator);
		    } else {
		      replaceWithShorthand(properties, candidateComponents, shorthandName, validator);
		    }

		    replacedCandidates.push(shorthandName);
		  }

		  for (i = replacedCandidates.length - 1; i >= 0; i--) {
		    delete candidates[replacedCandidates[i]];
		  }
		}

		function invalidates(candidates, shorthandName, invalidatedBy) {
		  var shorthandDescriptor = configuration[shorthandName];
		  var invalidatedByDescriptor = configuration[invalidatedBy.name];
		  var componentName;

		  if ('overridesShorthands' in shorthandDescriptor && shorthandDescriptor.overridesShorthands.indexOf(invalidatedBy.name) > -1) {
		    return true;
		  }

		  if (invalidatedByDescriptor && 'componentOf' in invalidatedByDescriptor) {
		    for (componentName in candidates[shorthandName]) {
		      if (invalidatedByDescriptor.componentOf.indexOf(componentName) > -1) {
		        return true;
		      }
		    }
		  }

		  return false;
		}

		function mixedImportance(components) {
		  var important;
		  var componentName;

		  for (componentName in components) {
		    if (undefined !== important && components[componentName].important != important) {
		      return true;
		    }

		    important = components[componentName].important;
		  }

		  return false;
		}

		function overridable(components, shorthandName, validator) {
		  var descriptor = configuration[shorthandName];
		  var newValuePlaceholder = [
		    Token.PROPERTY,
		    [Token.PROPERTY_NAME, shorthandName],
		    [Token.PROPERTY_VALUE, descriptor.defaultValue]
		  ];
		  var newProperty = wrapSingle(newValuePlaceholder);
		  var component;
		  var mayOverride;
		  var i, l;

		  populateComponents([newProperty], validator, []);

		  for (i = 0, l = descriptor.components.length; i < l; i++) {
		    component = components[descriptor.components[i]];
		    mayOverride = configuration[component.name].canOverride || sameValue;

		    if (!everyValuesPair(mayOverride.bind(null, validator), newProperty.components[i], component)) {
		      return false;
		    }
		  }

		  return true;
		}

		function sameValue(_validator, value1, value2) {
		  return value1 === value2;
		}

		function mergeable(components) {
		  var lastCount = null;
		  var currentCount;
		  var componentName;
		  var component;
		  var descriptor;
		  var values;

		  for (componentName in components) {
		    component = components[componentName];
		    descriptor = configuration[componentName];

		    if (!('restore' in descriptor)) {
		      continue;
		    }

		    restoreFromOptimizing([component.all[component.position]], restoreWithComponents);
		    values = descriptor.restore(component, configuration);

		    currentCount = values.length;

		    if (lastCount !== null && currentCount !== lastCount) {
		      return false;
		    }

		    lastCount = currentCount;
		  }

		  return true;
		}

		function mixedInherit(components) {
		  var componentName;
		  var lastValue = null;
		  var currentValue;

		  for (componentName in components) {
		    currentValue = hasInherit(components[componentName]);

		    if (lastValue !== null && lastValue !== currentValue) {
		      return true;
		    }

		    lastValue = currentValue;
		  }

		  return false;
		}

		function replaceWithInheritBestFit(properties, candidateComponents, shorthandName, validator) {
		  var viaLonghands = buildSequenceWithInheritLonghands(candidateComponents, shorthandName, validator);
		  var viaShorthand = buildSequenceWithInheritShorthand(candidateComponents, shorthandName, validator);
		  var longhandTokensSequence = viaLonghands[0];
		  var shorthandTokensSequence = viaShorthand[0];
		  var isLonghandsShorter = serializeBody(longhandTokensSequence).length < serializeBody(shorthandTokensSequence).length;
		  var newTokensSequence = isLonghandsShorter ? longhandTokensSequence : shorthandTokensSequence;
		  var newProperty = isLonghandsShorter ? viaLonghands[1] : viaShorthand[1];
		  var newComponents = isLonghandsShorter ? viaLonghands[2] : viaShorthand[2];
		  var lastComponent = candidateComponents[Object.keys(candidateComponents).pop()];
		  var all = lastComponent.all;
		  var insertAt = lastComponent.position;
		  var componentName;
		  var oldComponent;
		  var newComponent;
		  var newToken;

		  newProperty.position = insertAt;
		  newProperty.shorthand = true;
		  newProperty.important = lastComponent.important;
		  newProperty.multiplex = false;
		  newProperty.dirty = true;
		  newProperty.all = all;
		  newProperty.all[insertAt] = newTokensSequence[0];

		  properties.splice(insertAt, 1, newProperty);

		  for (componentName in candidateComponents) {
		    oldComponent = candidateComponents[componentName];
		    oldComponent.unused = true;

		    newProperty.multiplex = newProperty.multiplex || oldComponent.multiplex;

		    if (oldComponent.name in newComponents) {
		      newComponent = newComponents[oldComponent.name];
		      newToken = findTokenIn(newTokensSequence, componentName);

		      newComponent.position = all.length;
		      newComponent.all = all;
		      newComponent.all.push(newToken);

		      properties.push(newComponent);
		    }
		  }
		}

		function buildSequenceWithInheritLonghands(components, shorthandName, validator) {
		  var tokensSequence = [];
		  var inheritComponents = {};
		  var nonInheritComponents = {};
		  var descriptor = configuration[shorthandName];
		  var shorthandToken = [
		    Token.PROPERTY,
		    [Token.PROPERTY_NAME, shorthandName],
		    [Token.PROPERTY_VALUE, descriptor.defaultValue]
		  ];
		  var newProperty = wrapSingle(shorthandToken);
		  var component;
		  var longhandToken;
		  var newComponent;
		  var nameMetadata;
		  var i, l;

		  populateComponents([newProperty], validator, []);

		  for (i = 0, l = descriptor.components.length; i < l; i++) {
		    component = components[descriptor.components[i]];

		    if (hasInherit(component)) {
		      longhandToken = component.all[component.position].slice(0, 2);
		      Array.prototype.push.apply(longhandToken, component.value);
		      tokensSequence.push(longhandToken);

		      newComponent = deepClone(component);
		      newComponent.value = inferComponentValue(components, newComponent.name);

		      newProperty.components[i] = newComponent;
		      inheritComponents[component.name] = deepClone(component);
		    } else {
		      newComponent = deepClone(component);
		      newComponent.all = component.all;
		      newProperty.components[i] = newComponent;

		      nonInheritComponents[component.name] = component;
		    }
		  }

		  newProperty.important = components[Object.keys(components).pop()].important;

		  nameMetadata = joinMetadata(nonInheritComponents, 1);
		  shorthandToken[1].push(nameMetadata);

		  restoreFromOptimizing([newProperty], restoreWithComponents);

		  shorthandToken = shorthandToken.slice(0, 2);
		  Array.prototype.push.apply(shorthandToken, newProperty.value);

		  tokensSequence.unshift(shorthandToken);

		  return [tokensSequence, newProperty, inheritComponents];
		}

		function inferComponentValue(components, propertyName) {
		  var descriptor = configuration[propertyName];

		  if ('oppositeTo' in descriptor) {
		    return components[descriptor.oppositeTo].value;
		  }
		  return [[Token.PROPERTY_VALUE, descriptor.defaultValue]];
		}

		function joinMetadata(components, at) {
		  var metadata = [];
		  var component;
		  var originalValue;
		  var componentMetadata;
		  var componentName;

		  for (componentName in components) {
		    component = components[componentName];
		    originalValue = component.all[component.position];
		    componentMetadata = originalValue[at][originalValue[at].length - 1];

		    Array.prototype.push.apply(metadata, componentMetadata);
		  }

		  return metadata.sort(metadataSorter);
		}

		function metadataSorter(metadata1, metadata2) {
		  var line1 = metadata1[0];
		  var line2 = metadata2[0];
		  var column1 = metadata1[1];
		  var column2 = metadata2[1];

		  if (line1 < line2) {
		    return -1;
		  } if (line1 === line2) {
		    return column1 < column2 ? -1 : 1;
		  }
		  return 1;
		}

		function buildSequenceWithInheritShorthand(components, shorthandName, validator) {
		  var tokensSequence = [];
		  var inheritComponents = {};
		  var nonInheritComponents = {};
		  var descriptor = configuration[shorthandName];
		  var shorthandToken = [
		    Token.PROPERTY,
		    [Token.PROPERTY_NAME, shorthandName],
		    [Token.PROPERTY_VALUE, 'inherit']
		  ];
		  var newProperty = wrapSingle(shorthandToken);
		  var component;
		  var longhandToken;
		  var nameMetadata;
		  var valueMetadata;
		  var i, l;

		  populateComponents([newProperty], validator, []);

		  for (i = 0, l = descriptor.components.length; i < l; i++) {
		    component = components[descriptor.components[i]];

		    if (hasInherit(component)) {
		      inheritComponents[component.name] = component;
		    } else {
		      longhandToken = component.all[component.position].slice(0, 2);
		      Array.prototype.push.apply(longhandToken, component.value);
		      tokensSequence.push(longhandToken);

		      nonInheritComponents[component.name] = deepClone(component);
		    }
		  }

		  nameMetadata = joinMetadata(inheritComponents, 1);
		  shorthandToken[1].push(nameMetadata);

		  valueMetadata = joinMetadata(inheritComponents, 2);
		  shorthandToken[2].push(valueMetadata);

		  tokensSequence.unshift(shorthandToken);

		  return [tokensSequence, newProperty, nonInheritComponents];
		}

		function findTokenIn(tokens, componentName) {
		  var i, l;

		  for (i = 0, l = tokens.length; i < l; i++) {
		    if (tokens[i][1][1] == componentName) {
		      return tokens[i];
		    }
		  }
		}

		function replaceWithShorthand(properties, candidateComponents, shorthandName, validator) {
		  var descriptor = configuration[shorthandName];
		  var nameMetadata;
		  var valueMetadata;
		  var newValuePlaceholder = [
		    Token.PROPERTY,
		    [Token.PROPERTY_NAME, shorthandName],
		    [Token.PROPERTY_VALUE, descriptor.defaultValue]
		  ];
		  var all;
		  var insertAt = inferInsertAtFrom(properties, candidateComponents, shorthandName);

		  var newProperty = wrapSingle(newValuePlaceholder);
		  newProperty.shorthand = true;
		  newProperty.dirty = true;
		  newProperty.multiplex = false;

		  populateComponents([newProperty], validator, []);

		  for (var i = 0, l = descriptor.components.length; i < l; i++) {
		    var component = candidateComponents[descriptor.components[i]];

		    newProperty.components[i] = deepClone(component);
		    newProperty.important = component.important;
		    newProperty.multiplex = newProperty.multiplex || component.multiplex;

		    all = component.all;
		  }

		  for (var componentName in candidateComponents) {
		    candidateComponents[componentName].unused = true;
		  }

		  nameMetadata = joinMetadata(candidateComponents, 1);
		  newValuePlaceholder[1].push(nameMetadata);

		  valueMetadata = joinMetadata(candidateComponents, 2);
		  newValuePlaceholder[2].push(valueMetadata);

		  newProperty.position = insertAt;
		  newProperty.all = all;
		  newProperty.all[insertAt] = newValuePlaceholder;

		  properties.splice(insertAt, 1, newProperty);
		}

		function inferInsertAtFrom(properties, candidateComponents, shorthandName) {
		  var candidateComponentNames = Object.keys(candidateComponents);
		  var firstCandidatePosition = candidateComponents[candidateComponentNames[0]].position;
		  var lastCandidatePosition = candidateComponents[candidateComponentNames[candidateComponentNames.length - 1]].position;

		  if (shorthandName == 'border' && traversesVia(properties.slice(firstCandidatePosition, lastCandidatePosition), 'border-image')) {
		    return firstCandidatePosition;
		  }
		  return lastCandidatePosition;
		}

		function traversesVia(properties, propertyName) {
		  for (var i = properties.length - 1; i >= 0; i--) {
		    if (properties[i].name == propertyName) {
		      return true;
		    }
		  }

		  return false;
		}

		mergeIntoShorthands_1 = mergeIntoShorthands;
		return mergeIntoShorthands_1;
	}

	var hasUnset_1;
	var hasRequiredHasUnset;

	function requireHasUnset () {
		if (hasRequiredHasUnset) return hasUnset_1;
		hasRequiredHasUnset = 1;
		function hasUnset(property) {
		  for (var i = property.value.length - 1; i >= 0; i--) {
		    if (property.value[i][1] == 'unset') { return true; }
		  }

		  return false;
		}

		hasUnset_1 = hasUnset;
		return hasUnset_1;
	}

	var findComponentIn_1;
	var hasRequiredFindComponentIn;

	function requireFindComponentIn () {
		if (hasRequiredFindComponentIn) return findComponentIn_1;
		hasRequiredFindComponentIn = 1;
		var configuration = requireConfiguration();

		function findComponentIn(shorthand, longhand) {
		  var comparator = nameComparator(longhand);

		  return findInDirectComponents(shorthand, comparator) || findInSubComponents(shorthand, comparator);
		}

		function nameComparator(to) {
		  return function(property) {
		    return to.name === property.name;
		  };
		}

		function findInDirectComponents(shorthand, comparator) {
		  return shorthand.components.filter(comparator)[0];
		}

		function findInSubComponents(shorthand, comparator) {
		  var shorthandComponent;
		  var longhandMatch;
		  var i, l;

		  if (!configuration[shorthand.name].shorthandComponents) {
		    return;
		  }

		  for (i = 0, l = shorthand.components.length; i < l; i++) {
		    shorthandComponent = shorthand.components[i];
		    longhandMatch = findInDirectComponents(shorthandComponent, comparator);

		    if (longhandMatch) {
		      return longhandMatch;
		    }
		  }
		}

		findComponentIn_1 = findComponentIn;
		return findComponentIn_1;
	}

	var isComponentOf_1;
	var hasRequiredIsComponentOf;

	function requireIsComponentOf () {
		if (hasRequiredIsComponentOf) return isComponentOf_1;
		hasRequiredIsComponentOf = 1;
		var configuration = requireConfiguration();

		function isComponentOf(property1, property2, shallow) {
		  return isDirectComponentOf(property1, property2)
		    || !shallow && !!configuration[property1.name].shorthandComponents && isSubComponentOf(property1, property2);
		}

		function isDirectComponentOf(property1, property2) {
		  var descriptor = configuration[property1.name];

		  return 'components' in descriptor && descriptor.components.indexOf(property2.name) > -1;
		}

		function isSubComponentOf(property1, property2) {
		  return property1
		    .components
		    .some(function(component) {
		      return isDirectComponentOf(component, property2);
		    });
		}

		isComponentOf_1 = isComponentOf;
		return isComponentOf_1;
	}

	var isMergeableShorthand_1;
	var hasRequiredIsMergeableShorthand;

	function requireIsMergeableShorthand () {
		if (hasRequiredIsMergeableShorthand) return isMergeableShorthand_1;
		hasRequiredIsMergeableShorthand = 1;
		var Marker = requireMarker();

		function isMergeableShorthand(shorthand) {
		  if (shorthand.name != 'font') {
		    return true;
		  }

		  return shorthand.value[0][1].indexOf(Marker.INTERNAL) == -1;
		}

		isMergeableShorthand_1 = isMergeableShorthand;
		return isMergeableShorthand_1;
	}

	var overridesNonComponentShorthand_1;
	var hasRequiredOverridesNonComponentShorthand;

	function requireOverridesNonComponentShorthand () {
		if (hasRequiredOverridesNonComponentShorthand) return overridesNonComponentShorthand_1;
		hasRequiredOverridesNonComponentShorthand = 1;
		var configuration = requireConfiguration();

		function overridesNonComponentShorthand(property1, property2) {
		  return property1.name in configuration
		    && 'overridesShorthands' in configuration[property1.name]
		    && configuration[property1.name].overridesShorthands.indexOf(property2.name) > -1;
		}

		overridesNonComponentShorthand_1 = overridesNonComponentShorthand;
		return overridesNonComponentShorthand_1;
	}

	var overrideProperties_1;
	var hasRequiredOverrideProperties;

	function requireOverrideProperties () {
		if (hasRequiredOverrideProperties) return overrideProperties_1;
		hasRequiredOverrideProperties = 1;
		var hasInherit = requireHasInherit();
		var hasUnset = requireHasUnset();
		var everyValuesPair = requireEveryValuesPair();
		var findComponentIn = requireFindComponentIn();
		var isComponentOf = requireIsComponentOf();
		var isMergeableShorthand = requireIsMergeableShorthand();
		var overridesNonComponentShorthand = requireOverridesNonComponentShorthand();
		var sameVendorPrefixesIn = requireVendorPrefixes().same;

		var configuration = requireConfiguration();
		var deepClone = requireClone().deep;
		var restoreWithComponents = requireRestoreWithComponents();
		var shallowClone = requireClone().shallow;

		var restoreFromOptimizing = requireRestoreFromOptimizing();

		var Token = requireToken();
		var Marker = requireMarker();

		var serializeProperty = requireOneTime().property;

		function sameValue(_validator, value1, value2) {
		  return value1 === value2;
		}

		function wouldBreakCompatibility(property, validator) {
		  for (var i = 0; i < property.components.length; i++) {
		    var component = property.components[i];
		    var descriptor = configuration[component.name];
		    var canOverride = descriptor && descriptor.canOverride || sameValue;

		    var _component = shallowClone(component);
		    _component.value = [[Token.PROPERTY_VALUE, descriptor.defaultValue]];

		    if (!everyValuesPair(canOverride.bind(null, validator), _component, component)) {
		      return true;
		    }
		  }

		  return false;
		}

		function overrideIntoMultiplex(property, by) {
		  by.unused = true;

		  turnIntoMultiplex(by, multiplexSize(property));
		  property.value = by.value;
		}

		function overrideByMultiplex(property, by) {
		  by.unused = true;
		  property.multiplex = true;
		  property.value = by.value;
		}

		function overrideSimple(property, by) {
		  by.unused = true;
		  property.value = by.value;
		}

		function override(property, by) {
		  if (by.multiplex) {
		    overrideByMultiplex(property, by);
		  } else if (property.multiplex) {
		    overrideIntoMultiplex(property, by);
		  } else {
		    overrideSimple(property, by);
		  }
		}

		function overrideShorthand(property, by) {
		  by.unused = true;

		  for (var i = 0, l = property.components.length; i < l; i++) {
		    override(property.components[i], by.components[i]);
		  }
		}

		function turnIntoMultiplex(property, size) {
		  property.multiplex = true;

		  if (configuration[property.name].shorthand) {
		    turnShorthandValueIntoMultiplex(property, size);
		  } else {
		    turnLonghandValueIntoMultiplex(property, size);
		  }
		}

		function turnShorthandValueIntoMultiplex(property, size) {
		  var component;
		  var i, l;

		  for (i = 0, l = property.components.length; i < l; i++) {
		    component = property.components[i];

		    if (!component.multiplex) {
		      turnLonghandValueIntoMultiplex(component, size);
		    }
		  }
		}

		function turnLonghandValueIntoMultiplex(property, size) {
		  var descriptor = configuration[property.name];
		  var withRealValue = descriptor.intoMultiplexMode == 'real';
		  var withValue = descriptor.intoMultiplexMode == 'real'
		    ? property.value.slice(0)
		    : (descriptor.intoMultiplexMode == 'placeholder' ? descriptor.placeholderValue : descriptor.defaultValue);
		  var i = multiplexSize(property);
		  var j;
		  var m = withValue.length;

		  for (; i < size; i++) {
		    property.value.push([Token.PROPERTY_VALUE, Marker.COMMA]);

		    if (Array.isArray(withValue)) {
		      for (j = 0; j < m; j++) {
		        property.value.push(withRealValue ? withValue[j] : [Token.PROPERTY_VALUE, withValue[j]]);
		      }
		    } else {
		      property.value.push(withRealValue ? withValue : [Token.PROPERTY_VALUE, withValue]);
		    }
		  }
		}

		function multiplexSize(component) {
		  var size = 0;

		  for (var i = 0, l = component.value.length; i < l; i++) {
		    if (component.value[i][1] == Marker.COMMA) { size++; }
		  }

		  return size + 1;
		}

		function lengthOf(property) {
		  var fakeAsArray = [
		    Token.PROPERTY,
		    [Token.PROPERTY_NAME, property.name]
		  ].concat(property.value);
		  return serializeProperty([fakeAsArray], 0).length;
		}

		function moreSameShorthands(properties, startAt, name) {
		  // Since we run the main loop in `compactOverrides` backwards, at this point some
		  // properties may not be marked as unused.
		  // We should consider reverting the order if possible
		  var count = 0;

		  for (var i = startAt; i >= 0; i--) {
		    if (properties[i].name == name && !properties[i].unused) { count++; }
		    if (count > 1) { break; }
		  }

		  return count > 1;
		}

		function overridingFunction(shorthand, validator) {
		  for (var i = 0, l = shorthand.components.length; i < l; i++) {
		    if (!anyValue(validator.isUrl, shorthand.components[i])
		      && anyValue(validator.isFunction, shorthand.components[i])) { return true; }
		  }

		  return false;
		}

		function anyValue(fn, property) {
		  for (var i = 0, l = property.value.length; i < l; i++) {
		    if (property.value[i][1] == Marker.COMMA) { continue; }

		    if (fn(property.value[i][1])) { return true; }
		  }

		  return false;
		}

		function wouldResultInLongerValue(left, right) {
		  if (!left.multiplex && !right.multiplex || left.multiplex && right.multiplex) { return false; }

		  var multiplex = left.multiplex ? left : right;
		  var simple = left.multiplex ? right : left;
		  var component;

		  var multiplexClone = deepClone(multiplex);
		  restoreFromOptimizing([multiplexClone], restoreWithComponents);

		  var simpleClone = deepClone(simple);
		  restoreFromOptimizing([simpleClone], restoreWithComponents);

		  var lengthBefore = lengthOf(multiplexClone) + 1 + lengthOf(simpleClone);

		  if (left.multiplex) {
		    component = findComponentIn(multiplexClone, simpleClone);
		    overrideIntoMultiplex(component, simpleClone);
		  } else {
		    component = findComponentIn(simpleClone, multiplexClone);
		    turnIntoMultiplex(simpleClone, multiplexSize(multiplexClone));
		    overrideByMultiplex(component, multiplexClone);
		  }

		  restoreFromOptimizing([simpleClone], restoreWithComponents);

		  var lengthAfter = lengthOf(simpleClone);

		  return lengthBefore <= lengthAfter;
		}

		function isCompactable(property) {
		  return property.name in configuration;
		}

		function noneOverrideHack(left, right) {
		  return !left.multiplex
		    && (left.name == 'background' || left.name == 'background-image')
		    && right.multiplex
		    && (right.name == 'background' || right.name == 'background-image')
		    && anyLayerIsNone(right.value);
		}

		function anyLayerIsNone(values) {
		  var layers = intoLayers(values);

		  for (var i = 0, l = layers.length; i < l; i++) {
		    if (layers[i].length == 1 && layers[i][0][1] == 'none') { return true; }
		  }

		  return false;
		}

		function intoLayers(values) {
		  var layers = [];

		  for (var i = 0, layer = [], l = values.length; i < l; i++) {
		    var value = values[i];
		    if (value[1] == Marker.COMMA) {
		      layers.push(layer);
		      layer = [];
		    } else {
		      layer.push(value);
		    }
		  }

		  layers.push(layer);
		  return layers;
		}

		function overrideProperties(properties, withMerging, compatibility, validator) {
		  var mayOverride, right, left, component;
		  var overriddenComponents;
		  var overriddenComponent;
		  var overridingComponent;
		  var overridable;
		  var i, j, k;

		  propertyLoop:
		  for (i = properties.length - 1; i >= 0; i--) {
		    right = properties[i];

		    if (!isCompactable(right)) { continue; }

		    if (right.block) { continue; }

		    mayOverride = configuration[right.name].canOverride || sameValue;

		    traverseLoop:
		    for (j = i - 1; j >= 0; j--) {
		      left = properties[j];

		      if (!isCompactable(left)) { continue; }

		      if (left.block) { continue; }

		      if (left.dynamic || right.dynamic) { continue; }

		      if (left.unused || right.unused) { continue; }

		      if (left.hack && !right.hack && !right.important || !left.hack && !left.important && right.hack) { continue; }

		      if (left.important == right.important && left.hack[0] != right.hack[0]) { continue; }

		      if (left.important == right.important
		        && (left.hack[0] != right.hack[0] || (left.hack[1] && left.hack[1] != right.hack[1]))) { continue; }

		      if (hasInherit(right)) { continue; }

		      if (noneOverrideHack(left, right)) { continue; }

		      if (right.shorthand && isComponentOf(right, left)) {
		        // maybe `left` can be overridden by `right` which is a shorthand?
		        if (!right.important && left.important) { continue; }

		        if (!sameVendorPrefixesIn([left], right.components)) { continue; }

		        if (!anyValue(validator.isFunction, left) && overridingFunction(right, validator)) { continue; }

		        if (!isMergeableShorthand(right)) {
		          left.unused = true;
		          continue;
		        }

		        component = findComponentIn(right, left);
		        mayOverride = configuration[left.name].canOverride || sameValue;
		        if (everyValuesPair(mayOverride.bind(null, validator), left, component)) {
		          left.unused = true;
		        }
		      } else if (right.shorthand && overridesNonComponentShorthand(right, left)) {
		        // `right` is a shorthand while `left` can be overriden by it, think `border` and `border-top`
		        if (!right.important && left.important) {
		          continue;
		        }

		        if (!sameVendorPrefixesIn([left], right.components)) {
		          continue;
		        }

		        if (!anyValue(validator.isFunction, left) && overridingFunction(right, validator)) {
		          continue;
		        }

		        overriddenComponents = left.shorthand
		          ? left.components
		          : [left];

		        for (k = overriddenComponents.length - 1; k >= 0; k--) {
		          overriddenComponent = overriddenComponents[k];
		          overridingComponent = findComponentIn(right, overriddenComponent);
		          mayOverride = configuration[overriddenComponent.name].canOverride || sameValue;

		          if (!everyValuesPair(mayOverride.bind(null, validator), left, overridingComponent)) {
		            continue traverseLoop;
		          }
		        }

		        left.unused = true;
		      } else if (withMerging && left.shorthand && !right.shorthand && isComponentOf(left, right, true)) {
		        // maybe `right` can be pulled into `left` which is a shorthand?
		        if (right.important && !left.important) { continue; }

		        if (!right.important && left.important) {
		          right.unused = true;
		          continue;
		        }

		        // Pending more clever algorithm in #527
		        if (moreSameShorthands(properties, i - 1, left.name)) { continue; }

		        if (overridingFunction(left, validator)) { continue; }

		        if (!isMergeableShorthand(left)) { continue; }

		        if (hasUnset(left) || hasUnset(right)) { continue; }

		        component = findComponentIn(left, right);
		        if (everyValuesPair(mayOverride.bind(null, validator), component, right)) {
		          var disabledBackgroundMerging = !compatibility.properties.backgroundClipMerging && component.name.indexOf('background-clip') > -1
		            || !compatibility.properties.backgroundOriginMerging && component.name.indexOf('background-origin') > -1
		            || !compatibility.properties.backgroundSizeMerging && component.name.indexOf('background-size') > -1;
		          var nonMergeableValue = configuration[right.name].nonMergeableValue === right.value[0][1];

		          if (disabledBackgroundMerging || nonMergeableValue) { continue; }

		          if (!compatibility.properties.merging && wouldBreakCompatibility(left, validator)) { continue; }

		          if (component.value[0][1] != right.value[0][1] && (hasInherit(left) || hasInherit(right))) { continue; }

		          if (wouldResultInLongerValue(left, right)) { continue; }

		          if (!left.multiplex && right.multiplex) { turnIntoMultiplex(left, multiplexSize(right)); }

		          override(component, right);
		          left.dirty = true;
		        }
		      } else if (withMerging && left.shorthand && right.shorthand && left.name == right.name) {
		        // merge if all components can be merged

		        if (!left.multiplex && right.multiplex) { continue; }

		        if (!right.important && left.important) {
		          right.unused = true;
		          continue propertyLoop;
		        }

		        if (right.important && !left.important) {
		          left.unused = true;
		          continue;
		        }

		        if (!isMergeableShorthand(right)) {
		          left.unused = true;
		          continue;
		        }

		        for (k = left.components.length - 1; k >= 0; k--) {
		          var leftComponent = left.components[k];
		          var rightComponent = right.components[k];

		          mayOverride = configuration[leftComponent.name].canOverride || sameValue;
		          if (!everyValuesPair(mayOverride.bind(null, validator), leftComponent, rightComponent)) {
		            continue propertyLoop;
		          }
		        }

		        overrideShorthand(left, right);
		        left.dirty = true;
		      } else if (withMerging && left.shorthand && right.shorthand && isComponentOf(left, right)) {
		        // border is a shorthand but any of its components is a shorthand too

		        if (!left.important && right.important) { continue; }

		        component = findComponentIn(left, right);
		        mayOverride = configuration[right.name].canOverride || sameValue;
		        if (!everyValuesPair(mayOverride.bind(null, validator), component, right)) { continue; }

		        if (left.important && !right.important) {
		          right.unused = true;
		          continue;
		        }

		        var rightRestored = configuration[right.name].restore(right, configuration);
		        if (rightRestored.length > 1) { continue; }

		        component = findComponentIn(left, right);
		        override(component, right);
		        right.dirty = true;
		      } else if (left.name == right.name) {
		        // two non-shorthands should be merged based on understandability
		        overridable = true;

		        if (right.shorthand) {
		          for (k = right.components.length - 1; k >= 0 && overridable; k--) {
		            overriddenComponent = left.components[k];
		            overridingComponent = right.components[k];
		            mayOverride = configuration[overridingComponent.name].canOverride || sameValue;

		            overridable = everyValuesPair(mayOverride.bind(null, validator), overriddenComponent, overridingComponent);
		          }
		        } else {
		          mayOverride = configuration[right.name].canOverride || sameValue;
		          overridable = everyValuesPair(mayOverride.bind(null, validator), left, right);
		        }

		        if (left.important && !right.important && overridable) {
		          right.unused = true;
		          continue;
		        }

		        if (!left.important && right.important && overridable) {
		          left.unused = true;
		          continue;
		        }

		        if (!overridable) {
		          continue;
		        }

		        left.unused = true;
		      }
		    }
		  }
		}

		overrideProperties_1 = overrideProperties;
		return overrideProperties_1;
	}

	var optimize$1;
	var hasRequiredOptimize$1;

	function requireOptimize$1 () {
		if (hasRequiredOptimize$1) return optimize$1;
		hasRequiredOptimize$1 = 1;
		var mergeIntoShorthands = requireMergeIntoShorthands();
		var overrideProperties = requireOverrideProperties();
		var populateComponents = requirePopulateComponents();

		var restoreWithComponents = requireRestoreWithComponents();

		var wrapForOptimizing = requireWrapForOptimizing().all;
		var removeUnused = requireRemoveUnused();
		var restoreFromOptimizing = requireRestoreFromOptimizing();

		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;

		function optimizeProperties(properties, withOverriding, withMerging, context) {
		  var levelOptions = context.options.level[OptimizationLevel.Two];
		  var _properties = wrapForOptimizing(properties, levelOptions.skipProperties);
		  var _property;
		  var i, l;

		  populateComponents(_properties, context.validator, context.warnings);

		  for (i = 0, l = _properties.length; i < l; i++) {
		    _property = _properties[i];
		    if (_property.block) {
		      optimizeProperties(_property.value[0][1], withOverriding, withMerging, context);
		    }
		  }

		  if (withMerging && levelOptions.mergeIntoShorthands) {
		    mergeIntoShorthands(_properties, context.validator);
		  }

		  if (withOverriding && levelOptions.overrideProperties) {
		    overrideProperties(_properties, withMerging, context.options.compatibility, context.validator);
		  }

		  restoreFromOptimizing(_properties, restoreWithComponents);
		  removeUnused(_properties);
		}

		optimize$1 = optimizeProperties;
		return optimize$1;
	}

	var mergeAdjacent_1;
	var hasRequiredMergeAdjacent;

	function requireMergeAdjacent () {
		if (hasRequiredMergeAdjacent) return mergeAdjacent_1;
		hasRequiredMergeAdjacent = 1;
		var isMergeable = requireIsMergeable();

		var optimizeProperties = requireOptimize$1();

		var sortSelectors = requireSortSelectors();
		var tidyRules = requireTidyRules();

		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;

		var serializeBody = requireOneTime().body;
		var serializeRules = requireOneTime().rules;

		var Token = requireToken();

		function mergeAdjacent(tokens, context) {
		  var lastToken = [null, [], []];
		  var options = context.options;
		  var adjacentSpace = options.compatibility.selectors.adjacentSpace;
		  var selectorsSortingMethod = options.level[OptimizationLevel.One].selectorsSortingMethod;
		  var mergeablePseudoClasses = options.compatibility.selectors.mergeablePseudoClasses;
		  var mergeablePseudoElements = options.compatibility.selectors.mergeablePseudoElements;
		  var mergeLimit = options.compatibility.selectors.mergeLimit;
		  var multiplePseudoMerging = options.compatibility.selectors.multiplePseudoMerging;

		  for (var i = 0, l = tokens.length; i < l; i++) {
		    var token = tokens[i];

		    if (token[0] != Token.RULE) {
		      lastToken = [null, [], []];
		      continue;
		    }

		    if (lastToken[0] == Token.RULE && serializeRules(token[1]) == serializeRules(lastToken[1])) {
		      Array.prototype.push.apply(lastToken[2], token[2]);
		      optimizeProperties(lastToken[2], true, true, context);
		      token[2] = [];
		    } else if (lastToken[0] == Token.RULE && serializeBody(token[2]) == serializeBody(lastToken[2])
		        && isMergeable(serializeRules(token[1]), mergeablePseudoClasses, mergeablePseudoElements, multiplePseudoMerging)
		        && isMergeable(
		          serializeRules(lastToken[1]),
		          mergeablePseudoClasses,
		          mergeablePseudoElements,
		          multiplePseudoMerging
		        )
		        && lastToken[1].length < mergeLimit) {
		      lastToken[1] = tidyRules(lastToken[1].concat(token[1]), false, adjacentSpace, false, context.warnings);
		      lastToken[1] = lastToken.length > 1 ? sortSelectors(lastToken[1], selectorsSortingMethod) : lastToken[1];
		      token[2] = [];
		    } else {
		      lastToken = token;
		    }
		  }
		}

		mergeAdjacent_1 = mergeAdjacent;
		return mergeAdjacent_1;
	}

	var rulesOverlap_1;
	var hasRequiredRulesOverlap;

	function requireRulesOverlap () {
		if (hasRequiredRulesOverlap) return rulesOverlap_1;
		hasRequiredRulesOverlap = 1;
		var MODIFIER_PATTERN = /--.+$/;

		function rulesOverlap(rule1, rule2, bemMode) {
		  var scope1;
		  var scope2;
		  var i, l;
		  var j, m;

		  for (i = 0, l = rule1.length; i < l; i++) {
		    scope1 = rule1[i][1];

		    for (j = 0, m = rule2.length; j < m; j++) {
		      scope2 = rule2[j][1];

		      if (scope1 == scope2) {
		        return true;
		      }

		      if (bemMode && withoutModifiers(scope1) == withoutModifiers(scope2)) {
		        return true;
		      }
		    }
		  }

		  return false;
		}

		function withoutModifiers(scope) {
		  return scope.replace(MODIFIER_PATTERN, '');
		}

		rulesOverlap_1 = rulesOverlap;
		return rulesOverlap_1;
	}

	var specificity_1;
	var hasRequiredSpecificity;

	function requireSpecificity () {
		if (hasRequiredSpecificity) return specificity_1;
		hasRequiredSpecificity = 1;
		var Marker = requireMarker();

		var Selector = {
		  DOT: '.',
		  HASH: '#',
		  PSEUDO: ':'
		};

		var LETTER_PATTERN = /[a-zA-Z]/;
		var NOT_PREFIX = ':not(';
		var SEPARATOR_PATTERN = /[\s,(>~+]/;

		function specificity(selector) {
		  var result = [0, 0, 0];
		  var character;
		  var isEscaped;
		  var isSingleQuoted;
		  var isDoubleQuoted;
		  var roundBracketLevel = 0;
		  var couldIntroduceNewTypeSelector;
		  var withinNotPseudoClass = false;
		  var wasPseudoClass = false;
		  var i, l;

		  for (i = 0, l = selector.length; i < l; i++) {
		    character = selector[i];

		    if (isEscaped) ; else if (character == Marker.SINGLE_QUOTE && !isDoubleQuoted && !isSingleQuoted) {
		      isSingleQuoted = true;
		    } else if (character == Marker.SINGLE_QUOTE && !isDoubleQuoted && isSingleQuoted) {
		      isSingleQuoted = false;
		    } else if (character == Marker.DOUBLE_QUOTE && !isDoubleQuoted && !isSingleQuoted) {
		      isDoubleQuoted = true;
		    } else if (character == Marker.DOUBLE_QUOTE && isDoubleQuoted && !isSingleQuoted) {
		      isDoubleQuoted = false;
		    } else if (isSingleQuoted || isDoubleQuoted) {
		      continue;
		    } else if (roundBracketLevel > 0 && !withinNotPseudoClass) ; else if (character == Marker.OPEN_ROUND_BRACKET) {
		      roundBracketLevel++;
		    } else if (character == Marker.CLOSE_ROUND_BRACKET && roundBracketLevel == 1) {
		      roundBracketLevel--;
		      withinNotPseudoClass = false;
		    } else if (character == Marker.CLOSE_ROUND_BRACKET) {
		      roundBracketLevel--;
		    } else if (character == Selector.HASH) {
		      result[0]++;
		    } else if (character == Selector.DOT || character == Marker.OPEN_SQUARE_BRACKET) {
		      result[1]++;
		    } else if (character == Selector.PSEUDO && !wasPseudoClass && !isNotPseudoClass(selector, i)) {
		      result[1]++;
		      withinNotPseudoClass = false;
		    } else if (character == Selector.PSEUDO) {
		      withinNotPseudoClass = true;
		    } else if ((i === 0 || couldIntroduceNewTypeSelector) && LETTER_PATTERN.test(character)) {
		      result[2]++;
		    }

		    isEscaped = character == Marker.BACK_SLASH;
		    wasPseudoClass = character == Selector.PSEUDO;
		    couldIntroduceNewTypeSelector = !isEscaped && SEPARATOR_PATTERN.test(character);
		  }

		  return result;
		}

		function isNotPseudoClass(selector, index) {
		  return selector.indexOf(NOT_PREFIX, index) === index;
		}

		specificity_1 = specificity;
		return specificity_1;
	}

	var specificitiesOverlap_1;
	var hasRequiredSpecificitiesOverlap;

	function requireSpecificitiesOverlap () {
		if (hasRequiredSpecificitiesOverlap) return specificitiesOverlap_1;
		hasRequiredSpecificitiesOverlap = 1;
		var specificity = requireSpecificity();

		function specificitiesOverlap(selector1, selector2, cache) {
		  var specificity1;
		  var specificity2;
		  var i, l;
		  var j, m;

		  for (i = 0, l = selector1.length; i < l; i++) {
		    specificity1 = findSpecificity(selector1[i][1], cache);

		    for (j = 0, m = selector2.length; j < m; j++) {
		      specificity2 = findSpecificity(selector2[j][1], cache);

		      if (specificity1[0] === specificity2[0]
		        && specificity1[1] === specificity2[1]
		        && specificity1[2] === specificity2[2]) {
		        return true;
		      }
		    }
		  }

		  return false;
		}

		function findSpecificity(selector, cache) {
		  var value;

		  if (!(selector in cache)) {
		    cache[selector] = value = specificity(selector);
		  }

		  return value || cache[selector];
		}

		specificitiesOverlap_1 = specificitiesOverlap;
		return specificitiesOverlap_1;
	}

	var reorderable;
	var hasRequiredReorderable;

	function requireReorderable () {
		if (hasRequiredReorderable) return reorderable;
		hasRequiredReorderable = 1;
		// TODO: it'd be great to merge it with the other canReorder functionality

		var rulesOverlap = requireRulesOverlap();
		var specificitiesOverlap = requireSpecificitiesOverlap();

		var FLEX_PROPERTIES = /align-items|box-align|box-pack|flex|justify/;
		var BORDER_PROPERTIES = /^border-(top|right|bottom|left|color|style|width|radius)/;

		function canReorder(left, right, cache) {
		  for (var i = right.length - 1; i >= 0; i--) {
		    for (var j = left.length - 1; j >= 0; j--) {
		      if (!canReorderSingle(left[j], right[i], cache)) { return false; }
		    }
		  }

		  return true;
		}

		function canReorderSingle(left, right, cache) {
		  var leftName = left[0];
		  var leftValue = left[1];
		  var leftNameRoot = left[2];
		  var leftSelector = left[5];
		  var leftInSpecificSelector = left[6];
		  var rightName = right[0];
		  var rightValue = right[1];
		  var rightNameRoot = right[2];
		  var rightSelector = right[5];
		  var rightInSpecificSelector = right[6];

		  if (leftName == 'font' && rightName == 'line-height' || rightName == 'font' && leftName == 'line-height') { return false; }
		  if (FLEX_PROPERTIES.test(leftName) && FLEX_PROPERTIES.test(rightName)) { return false; }
		  if (leftNameRoot == rightNameRoot
		    && unprefixed(leftName) == unprefixed(rightName)
		    && (vendorPrefixed(leftName) ^ vendorPrefixed(rightName))) { return false; }
		  if (leftNameRoot == 'border' && BORDER_PROPERTIES.test(rightNameRoot) && (leftName == 'border' || leftName == rightNameRoot || (leftValue != rightValue && sameBorderComponent(leftName, rightName)))) { return false; }
		  if (rightNameRoot == 'border' && BORDER_PROPERTIES.test(leftNameRoot) && (rightName == 'border' || rightName == leftNameRoot || (leftValue != rightValue && sameBorderComponent(leftName, rightName)))) { return false; }
		  if (leftNameRoot == 'border' && rightNameRoot == 'border' && leftName != rightName && (isSideBorder(leftName) && isStyleBorder(rightName) || isStyleBorder(leftName) && isSideBorder(rightName))) { return false; }
		  if (leftNameRoot != rightNameRoot) { return true; }
		  if (leftName == rightName
		    && leftNameRoot == rightNameRoot
		    && (leftValue == rightValue || withDifferentVendorPrefix(leftValue, rightValue))) { return true; }
		  if (leftName != rightName
		    && leftNameRoot == rightNameRoot
		    && leftName != leftNameRoot
		    && rightName != rightNameRoot) { return true; }
		  if (leftName != rightName
		    && leftNameRoot == rightNameRoot
		    && leftValue == rightValue) { return true; }
		  if (rightInSpecificSelector
		    && leftInSpecificSelector
		    && !inheritable(leftNameRoot)
		    && !inheritable(rightNameRoot)
		    && !rulesOverlap(rightSelector, leftSelector, false)) { return true; }
		  if (!specificitiesOverlap(leftSelector, rightSelector, cache)) { return true; }

		  return false;
		}

		function vendorPrefixed(name) {
		  return /^-(?:moz|webkit|ms|o)-/.test(name);
		}

		function unprefixed(name) {
		  return name.replace(/^-(?:moz|webkit|ms|o)-/, '');
		}

		function sameBorderComponent(name1, name2) {
		  return name1.split('-').pop() == name2.split('-').pop();
		}

		function isSideBorder(name) {
		  return name == 'border-top' || name == 'border-right' || name == 'border-bottom' || name == 'border-left';
		}

		function isStyleBorder(name) {
		  return name == 'border-color' || name == 'border-style' || name == 'border-width';
		}

		function withDifferentVendorPrefix(value1, value2) {
		  return vendorPrefixed(value1) && vendorPrefixed(value2) && value1.split('-')[1] != value2.split('-')[2];
		}

		function inheritable(name) {
		  // According to http://www.w3.org/TR/CSS21/propidx.html
		  // Others will be catched by other, preceeding rules
		  return name == 'font' || name == 'line-height' || name == 'list-style';
		}

		reorderable = {
		  canReorder: canReorder,
		  canReorderSingle: canReorderSingle
		};
		return reorderable;
	}

	var extractProperties_1;
	var hasRequiredExtractProperties;

	function requireExtractProperties () {
		if (hasRequiredExtractProperties) return extractProperties_1;
		hasRequiredExtractProperties = 1;
		// This extractor is used in level 2 optimizations
		// IMPORTANT: Mind Token class and this code is not related!
		// Properties will be tokenized in one step, see #429

		var Token = requireToken();
		var serializeRules = requireOneTime().rules;
		var serializeValue = requireOneTime().value;

		function extractProperties(token) {
		  var properties = [];
		  var inSpecificSelector;
		  var property;
		  var name;
		  var value;
		  var i, l;

		  if (token[0] == Token.RULE) {
		    inSpecificSelector = !/[.+>~]/.test(serializeRules(token[1]));

		    for (i = 0, l = token[2].length; i < l; i++) {
		      property = token[2][i];

		      if (property[0] != Token.PROPERTY) { continue; }

		      name = property[1][1];
		      if (name.length === 0) { continue; }

		      value = serializeValue(property, i);

		      properties.push([
		        name,
		        value,
		        findNameRoot(name),
		        token[2][i],
		        name + ':' + value,
		        token[1],
		        inSpecificSelector
		      ]);
		    }
		  } else if (token[0] == Token.NESTED_BLOCK) {
		    for (i = 0, l = token[2].length; i < l; i++) {
		      properties = properties.concat(extractProperties(token[2][i]));
		    }
		  }

		  return properties;
		}

		function findNameRoot(name) {
		  if (name == 'list-style') { return name; }
		  if (name.indexOf('-radius') > 0) { return 'border-radius'; }
		  if (name == 'border-collapse' || name == 'border-spacing' || name == 'border-image') { return name; }
		  if (name.indexOf('border-') === 0 && /^border-\w+-\w+$/.test(name)) { return name.match(/border-\w+/)[0]; }
		  if (name.indexOf('border-') === 0 && /^border-\w+$/.test(name)) { return 'border'; }
		  if (name.indexOf('text-') === 0) { return name; }
		  if (name == '-chrome-') { return name; }

		  return name.replace(/^-\w+-/, '').match(/([a-zA-Z]+)/)[0].toLowerCase();
		}

		extractProperties_1 = extractProperties;
		return extractProperties_1;
	}

	var mergeMediaQueries_1;
	var hasRequiredMergeMediaQueries;

	function requireMergeMediaQueries () {
		if (hasRequiredMergeMediaQueries) return mergeMediaQueries_1;
		hasRequiredMergeMediaQueries = 1;
		var canReorder = requireReorderable().canReorder;
		var canReorderSingle = requireReorderable().canReorderSingle;
		var extractProperties = requireExtractProperties();
		var rulesOverlap = requireRulesOverlap();

		var serializeRules = requireOneTime().rules;
		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;
		var Token = requireToken();

		function mergeMediaQueries(tokens, context) {
		  var mergeSemantically = context.options.level[OptimizationLevel.Two].mergeSemantically;
		  var specificityCache = context.cache.specificity;
		  var candidates = {};
		  var reduced = [];

		  for (var i = tokens.length - 1; i >= 0; i--) {
		    var token = tokens[i];
		    if (token[0] != Token.NESTED_BLOCK) {
		      continue;
		    }

		    var key = serializeRules(token[1]);
		    var candidate = candidates[key];
		    if (!candidate) {
		      candidate = [];
		      candidates[key] = candidate;
		    }

		    candidate.push(i);
		  }

		  for (var name in candidates) {
		    var positions = candidates[name];

		    positionLoop:
		    for (var j = positions.length - 1; j > 0; j--) {
		      var positionOne = positions[j];
		      var tokenOne = tokens[positionOne];
		      var positionTwo = positions[j - 1];
		      var tokenTwo = tokens[positionTwo];

		      directionLoop:
		      for (var direction = 1; direction >= -1; direction -= 2) {
		        var topToBottom = direction == 1;
		        var from = topToBottom ? positionOne + 1 : positionTwo - 1;
		        var to = topToBottom ? positionTwo : positionOne;
		        var delta = topToBottom ? 1 : -1;
		        var source = topToBottom ? tokenOne : tokenTwo;
		        var target = topToBottom ? tokenTwo : tokenOne;
		        var movedProperties = extractProperties(source);

		        while (from != to) {
		          var traversedProperties = extractProperties(tokens[from]);
		          from += delta;

		          if (mergeSemantically
		            && allSameRulePropertiesCanBeReordered(movedProperties, traversedProperties, specificityCache)
		          ) {
		            continue;
		          }

		          if (!canReorder(movedProperties, traversedProperties, specificityCache)) { continue directionLoop; }
		        }

		        target[2] = topToBottom
		          ? source[2].concat(target[2])
		          : target[2].concat(source[2]);
		        source[2] = [];

		        reduced.push(target);
		        continue positionLoop;
		      }
		    }
		  }

		  return reduced;
		}

		function allSameRulePropertiesCanBeReordered(movedProperties, traversedProperties, specificityCache) {
		  var movedProperty;
		  var movedRule;
		  var traversedProperty;
		  var traversedRule;
		  var i, l;
		  var j, m;

		  for (i = 0, l = movedProperties.length; i < l; i++) {
		    movedProperty = movedProperties[i];
		    movedRule = movedProperty[5];

		    for (j = 0, m = traversedProperties.length; j < m; j++) {
		      traversedProperty = traversedProperties[j];
		      traversedRule = traversedProperty[5];

		      if (rulesOverlap(movedRule, traversedRule, true)
		        && !canReorderSingle(movedProperty, traversedProperty, specificityCache)) {
		        return false;
		      }
		    }
		  }

		  return true;
		}

		mergeMediaQueries_1 = mergeMediaQueries;
		return mergeMediaQueries_1;
	}

	var mergeNonAdjacentByBody_1;
	var hasRequiredMergeNonAdjacentByBody;

	function requireMergeNonAdjacentByBody () {
		if (hasRequiredMergeNonAdjacentByBody) return mergeNonAdjacentByBody_1;
		hasRequiredMergeNonAdjacentByBody = 1;
		var isMergeable = requireIsMergeable();

		var sortSelectors = requireSortSelectors();
		var tidyRules = requireTidyRules();

		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;

		var serializeBody = requireOneTime().body;
		var serializeRules = requireOneTime().rules;

		var Token = requireToken();

		function unsafeSelector(value) {
		  return /\.|\*| :/.test(value);
		}

		function isBemElement(token) {
		  var asString = serializeRules(token[1]);
		  return asString.indexOf('__') > -1 || asString.indexOf('--') > -1;
		}

		function withoutModifier(selector) {
		  return selector.replace(/--[^ ,>+~:]+/g, '');
		}

		function removeAnyUnsafeElements(left, candidates) {
		  var leftSelector = withoutModifier(serializeRules(left[1]));

		  for (var body in candidates) {
		    var right = candidates[body];
		    var rightSelector = withoutModifier(serializeRules(right[1]));

		    if (rightSelector.indexOf(leftSelector) > -1 || leftSelector.indexOf(rightSelector) > -1) {
		      delete candidates[body];
		    }
		  }
		}

		function mergeNonAdjacentByBody(tokens, context) {
		  var options = context.options;
		  var mergeSemantically = options.level[OptimizationLevel.Two].mergeSemantically;
		  var adjacentSpace = options.compatibility.selectors.adjacentSpace;
		  var selectorsSortingMethod = options.level[OptimizationLevel.One].selectorsSortingMethod;
		  var mergeablePseudoClasses = options.compatibility.selectors.mergeablePseudoClasses;
		  var mergeablePseudoElements = options.compatibility.selectors.mergeablePseudoElements;
		  var multiplePseudoMerging = options.compatibility.selectors.multiplePseudoMerging;
		  var candidates = {};

		  for (var i = tokens.length - 1; i >= 0; i--) {
		    var token = tokens[i];
		    if (token[0] != Token.RULE) { continue; }

		    if (token[2].length > 0 && (!mergeSemantically && unsafeSelector(serializeRules(token[1])))) { candidates = {}; }

		    if (token[2].length > 0 && mergeSemantically && isBemElement(token)) { removeAnyUnsafeElements(token, candidates); }

		    var candidateBody = serializeBody(token[2]);
		    var oldToken = candidates[candidateBody];
		    if (oldToken
		        && isMergeable(
		          serializeRules(token[1]),
		          mergeablePseudoClasses,
		          mergeablePseudoElements,
		          multiplePseudoMerging
		        )
		        && isMergeable(
		          serializeRules(oldToken[1]),
		          mergeablePseudoClasses,
		          mergeablePseudoElements,
		          multiplePseudoMerging
		        )
		    ) {
		      if (token[2].length > 0) {
		        token[1] = tidyRules(oldToken[1].concat(token[1]), false, adjacentSpace, false, context.warnings);
		        token[1] = token[1].length > 1 ? sortSelectors(token[1], selectorsSortingMethod) : token[1];
		      } else {
		        token[1] = oldToken[1].concat(token[1]);
		      }

		      oldToken[2] = [];
		      candidates[candidateBody] = null;
		    }

		    candidates[serializeBody(token[2])] = token;
		  }
		}

		mergeNonAdjacentByBody_1 = mergeNonAdjacentByBody;
		return mergeNonAdjacentByBody_1;
	}

	var mergeNonAdjacentBySelector_1;
	var hasRequiredMergeNonAdjacentBySelector;

	function requireMergeNonAdjacentBySelector () {
		if (hasRequiredMergeNonAdjacentBySelector) return mergeNonAdjacentBySelector_1;
		hasRequiredMergeNonAdjacentBySelector = 1;
		var canReorder = requireReorderable().canReorder;
		var extractProperties = requireExtractProperties();

		var optimizeProperties = requireOptimize$1();

		var serializeRules = requireOneTime().rules;

		var Token = requireToken();

		function mergeNonAdjacentBySelector(tokens, context) {
		  var specificityCache = context.cache.specificity;
		  var allSelectors = {};
		  var repeatedSelectors = [];
		  var i;

		  for (i = tokens.length - 1; i >= 0; i--) {
		    if (tokens[i][0] != Token.RULE) { continue; }
		    if (tokens[i][2].length === 0) { continue; }

		    var selector = serializeRules(tokens[i][1]);
		    allSelectors[selector] = [i].concat(allSelectors[selector] || []);

		    if (allSelectors[selector].length == 2) { repeatedSelectors.push(selector); }
		  }

		  for (i = repeatedSelectors.length - 1; i >= 0; i--) {
		    var positions = allSelectors[repeatedSelectors[i]];

		    selectorIterator:
		    for (var j = positions.length - 1; j > 0; j--) {
		      var positionOne = positions[j - 1];
		      var tokenOne = tokens[positionOne];
		      var positionTwo = positions[j];
		      var tokenTwo = tokens[positionTwo];

		      directionIterator:
		      for (var direction = 1; direction >= -1; direction -= 2) {
		        var topToBottom = direction == 1;
		        var from = topToBottom ? positionOne + 1 : positionTwo - 1;
		        var to = topToBottom ? positionTwo : positionOne;
		        var delta = topToBottom ? 1 : -1;
		        var moved = topToBottom ? tokenOne : tokenTwo;
		        var target = topToBottom ? tokenTwo : tokenOne;
		        var movedProperties = extractProperties(moved);

		        while (from != to) {
		          var traversedProperties = extractProperties(tokens[from]);
		          from += delta;

		          // traversed then moved as we move selectors towards the start
		          var reorderable = topToBottom
		            ? canReorder(movedProperties, traversedProperties, specificityCache)
		            : canReorder(traversedProperties, movedProperties, specificityCache);

		          if (!reorderable && !topToBottom) { continue selectorIterator; }
		          if (!reorderable && topToBottom) { continue directionIterator; }
		        }

		        if (topToBottom) {
		          Array.prototype.push.apply(moved[2], target[2]);
		          target[2] = moved[2];
		        } else {
		          Array.prototype.push.apply(target[2], moved[2]);
		        }

		        optimizeProperties(target[2], true, true, context);
		        moved[2] = [];
		      }
		    }
		  }
		}

		mergeNonAdjacentBySelector_1 = mergeNonAdjacentBySelector;
		return mergeNonAdjacentBySelector_1;
	}

	var cloneArray_1;
	var hasRequiredCloneArray;

	function requireCloneArray () {
		if (hasRequiredCloneArray) return cloneArray_1;
		hasRequiredCloneArray = 1;
		function cloneArray(array) {
		  var cloned = array.slice(0);

		  for (var i = 0, l = cloned.length; i < l; i++) {
		    if (Array.isArray(cloned[i])) { cloned[i] = cloneArray(cloned[i]); }
		  }

		  return cloned;
		}

		cloneArray_1 = cloneArray;
		return cloneArray_1;
	}

	var reduceNonAdjacent_1;
	var hasRequiredReduceNonAdjacent;

	function requireReduceNonAdjacent () {
		if (hasRequiredReduceNonAdjacent) return reduceNonAdjacent_1;
		hasRequiredReduceNonAdjacent = 1;
		var isMergeable = requireIsMergeable();

		var optimizeProperties = requireOptimize$1();

		var cloneArray = requireCloneArray();

		var Token = requireToken();

		var serializeBody = requireOneTime().body;
		var serializeRules = requireOneTime().rules;

		function reduceNonAdjacent(tokens, context) {
		  var options = context.options;
		  var mergeablePseudoClasses = options.compatibility.selectors.mergeablePseudoClasses;
		  var mergeablePseudoElements = options.compatibility.selectors.mergeablePseudoElements;
		  var multiplePseudoMerging = options.compatibility.selectors.multiplePseudoMerging;
		  var candidates = {};
		  var repeated = [];

		  for (var i = tokens.length - 1; i >= 0; i--) {
		    var token = tokens[i];

		    if (token[0] != Token.RULE) {
		      continue;
		    } else if (token[2].length === 0) {
		      continue;
		    }

		    var selectorAsString = serializeRules(token[1]);
		    var isComplexAndNotSpecial = token[1].length > 1
		      && isMergeable(selectorAsString, mergeablePseudoClasses, mergeablePseudoElements, multiplePseudoMerging);
		    var wrappedSelectors = wrappedSelectorsFrom(token[1]);
		    var selectors = isComplexAndNotSpecial
		      ? [selectorAsString].concat(wrappedSelectors)
		      : [selectorAsString];

		    for (var j = 0, m = selectors.length; j < m; j++) {
		      var selector = selectors[j];

		      if (!candidates[selector]) { candidates[selector] = []; } else { repeated.push(selector); }

		      candidates[selector].push({
		        where: i,
		        list: wrappedSelectors,
		        isPartial: isComplexAndNotSpecial && j > 0,
		        isComplex: isComplexAndNotSpecial && j === 0
		      });
		    }
		  }

		  reduceSimpleNonAdjacentCases(tokens, repeated, candidates, options, context);
		  reduceComplexNonAdjacentCases(tokens, candidates, options, context);
		}

		function wrappedSelectorsFrom(list) {
		  var wrapped = [];

		  for (var i = 0; i < list.length; i++) {
		    wrapped.push([list[i][1]]);
		  }

		  return wrapped;
		}

		function reduceSimpleNonAdjacentCases(tokens, repeated, candidates, options, context) {
		  function filterOut(idx, bodies) {
		    return data[idx].isPartial && bodies.length === 0;
		  }

		  function reduceBody(token, newBody, processedCount, tokenIdx) {
		    if (!data[processedCount - tokenIdx - 1].isPartial) { token[2] = newBody; }
		  }

		  for (var i = 0, l = repeated.length; i < l; i++) {
		    var selector = repeated[i];
		    var data = candidates[selector];

		    reduceSelector(tokens, data, {
		      filterOut: filterOut,
		      callback: reduceBody
		    }, options, context);
		  }
		}

		function reduceComplexNonAdjacentCases(tokens, candidates, options, context) {
		  var mergeablePseudoClasses = options.compatibility.selectors.mergeablePseudoClasses;
		  var mergeablePseudoElements = options.compatibility.selectors.mergeablePseudoElements;
		  var multiplePseudoMerging = options.compatibility.selectors.multiplePseudoMerging;
		  var localContext = {};

		  function filterOut(idx) {
		    return localContext.data[idx].where < localContext.intoPosition;
		  }

		  function collectReducedBodies(token, newBody, processedCount, tokenIdx) {
		    if (tokenIdx === 0) { localContext.reducedBodies.push(newBody); }
		  }

		  allSelectors:
		  for (var complexSelector in candidates) {
		    var into = candidates[complexSelector];
		    if (!into[0].isComplex) { continue; }

		    var intoPosition = into[into.length - 1].where;
		    var intoToken = tokens[intoPosition];
		    var reducedBodies = [];

		    var selectors = isMergeable(complexSelector, mergeablePseudoClasses, mergeablePseudoElements, multiplePseudoMerging)
		      ? into[0].list
		      : [complexSelector];

		    localContext.intoPosition = intoPosition;
		    localContext.reducedBodies = reducedBodies;

		    for (var j = 0, m = selectors.length; j < m; j++) {
		      var selector = selectors[j];
		      var data = candidates[selector];

		      if (data.length < 2) { continue allSelectors; }

		      localContext.data = data;

		      reduceSelector(tokens, data, {
		        filterOut: filterOut,
		        callback: collectReducedBodies
		      }, options, context);

		      if (serializeBody(reducedBodies[reducedBodies.length - 1]) != serializeBody(reducedBodies[0])) {
		        continue allSelectors;
		      }
		    }

		    intoToken[2] = reducedBodies[0];
		  }
		}

		function reduceSelector(tokens, data, context, options, outerContext) {
		  var bodies = [];
		  var bodiesAsList = [];
		  var processedTokens = [];

		  for (var j = data.length - 1; j >= 0; j--) {
		    if (context.filterOut(j, bodies)) { continue; }

		    var where = data[j].where;
		    var token = tokens[where];
		    var clonedBody = cloneArray(token[2]);

		    bodies = bodies.concat(clonedBody);
		    bodiesAsList.push(clonedBody);
		    processedTokens.push(where);
		  }

		  optimizeProperties(bodies, true, false, outerContext);

		  var processedCount = processedTokens.length;
		  var propertyIdx = bodies.length - 1;
		  var tokenIdx = processedCount - 1;

		  while (tokenIdx >= 0) {
		    if ((tokenIdx === 0
		      || (bodies[propertyIdx] && bodiesAsList[tokenIdx].indexOf(bodies[propertyIdx]) > -1)) && propertyIdx > -1) {
		      propertyIdx--;
		      continue;
		    }

		    var newBody = bodies.splice(propertyIdx + 1);
		    context.callback(tokens[processedTokens[tokenIdx]], newBody, processedCount, tokenIdx);

		    tokenIdx--;
		  }
		}

		reduceNonAdjacent_1 = reduceNonAdjacent;
		return reduceNonAdjacent_1;
	}

	var removeDuplicateFontAtRules_1;
	var hasRequiredRemoveDuplicateFontAtRules;

	function requireRemoveDuplicateFontAtRules () {
		if (hasRequiredRemoveDuplicateFontAtRules) return removeDuplicateFontAtRules_1;
		hasRequiredRemoveDuplicateFontAtRules = 1;
		var Token = requireToken();

		var serializeAll = requireOneTime().all;

		var FONT_FACE_SCOPE = '@font-face';

		function removeDuplicateFontAtRules(tokens) {
		  var fontAtRules = [];
		  var token;
		  var key;
		  var i, l;

		  for (i = 0, l = tokens.length; i < l; i++) {
		    token = tokens[i];

		    if (token[0] != Token.AT_RULE_BLOCK && token[1][0][1] != FONT_FACE_SCOPE) {
		      continue;
		    }

		    key = serializeAll([token]);

		    if (fontAtRules.indexOf(key) > -1) {
		      token[2] = [];
		    } else {
		      fontAtRules.push(key);
		    }
		  }
		}

		removeDuplicateFontAtRules_1 = removeDuplicateFontAtRules;
		return removeDuplicateFontAtRules_1;
	}

	var removeDuplicateMediaQueries_1;
	var hasRequiredRemoveDuplicateMediaQueries;

	function requireRemoveDuplicateMediaQueries () {
		if (hasRequiredRemoveDuplicateMediaQueries) return removeDuplicateMediaQueries_1;
		hasRequiredRemoveDuplicateMediaQueries = 1;
		var Token = requireToken();

		var serializeAll = requireOneTime().all;
		var serializeRules = requireOneTime().rules;

		function removeDuplicateMediaQueries(tokens) {
		  var candidates = {};
		  var candidate;
		  var token;
		  var key;
		  var i, l;

		  for (i = 0, l = tokens.length; i < l; i++) {
		    token = tokens[i];
		    if (token[0] != Token.NESTED_BLOCK) {
		      continue;
		    }

		    key = serializeRules(token[1]) + '%' + serializeAll(token[2]);
		    candidate = candidates[key];

		    if (candidate) {
		      candidate[2] = [];
		    }

		    candidates[key] = token;
		  }
		}

		removeDuplicateMediaQueries_1 = removeDuplicateMediaQueries;
		return removeDuplicateMediaQueries_1;
	}

	var removeDuplicates_1;
	var hasRequiredRemoveDuplicates;

	function requireRemoveDuplicates () {
		if (hasRequiredRemoveDuplicates) return removeDuplicates_1;
		hasRequiredRemoveDuplicates = 1;
		var Token = requireToken();

		var serializeBody = requireOneTime().body;
		var serializeRules = requireOneTime().rules;

		function removeDuplicates(tokens) {
		  var matched = {};
		  var moreThanOnce = [];
		  var id, token;
		  var body, bodies;

		  for (var i = 0, l = tokens.length; i < l; i++) {
		    token = tokens[i];
		    if (token[0] != Token.RULE) { continue; }

		    id = serializeRules(token[1]);

		    if (matched[id] && matched[id].length == 1) { moreThanOnce.push(id); } else { matched[id] = matched[id] || []; }

		    matched[id].push(i);
		  }

		  for (i = 0, l = moreThanOnce.length; i < l; i++) {
		    id = moreThanOnce[i];
		    bodies = [];

		    for (var j = matched[id].length - 1; j >= 0; j--) {
		      token = tokens[matched[id][j]];
		      body = serializeBody(token[2]);

		      if (bodies.indexOf(body) > -1) { token[2] = []; } else { bodies.push(body); }
		    }
		  }
		}

		removeDuplicates_1 = removeDuplicates;
		return removeDuplicates_1;
	}

	var removeUnusedAtRules_1;
	var hasRequiredRemoveUnusedAtRules;

	function requireRemoveUnusedAtRules () {
		if (hasRequiredRemoveUnusedAtRules) return removeUnusedAtRules_1;
		hasRequiredRemoveUnusedAtRules = 1;
		var populateComponents = requirePopulateComponents();

		var wrapForOptimizing = requireWrapForOptimizing().single;
		var restoreFromOptimizing = requireRestoreFromOptimizing();

		var Token = requireToken();

		var animationNameRegex = /^(-moz-|-o-|-webkit-)?animation-name$/;
		var animationRegex = /^(-moz-|-o-|-webkit-)?animation$/;
		var keyframeRegex = /^@(-moz-|-o-|-webkit-)?keyframes /;
		var importantRegex = /\s{0,31}!important$/;
		var optionalMatchingQuotesRegex = /^(['"]?)(.*)\1$/;

		function normalize(value) {
		  return value
		    .replace(optionalMatchingQuotesRegex, '$2')
		    .replace(importantRegex, '');
		}

		function removeUnusedAtRules(tokens, context) {
		  removeUnusedAtRule(tokens, matchCounterStyle, markCounterStylesAsUsed, context);
		  removeUnusedAtRule(tokens, matchFontFace, markFontFacesAsUsed, context);
		  removeUnusedAtRule(tokens, matchKeyframe, markKeyframesAsUsed, context);
		  removeUnusedAtRule(tokens, matchNamespace, markNamespacesAsUsed, context);
		}

		function removeUnusedAtRule(tokens, matchCallback, markCallback, context) {
		  var atRules = {};
		  var atRule;
		  var atRuleTokens;
		  var atRuleToken;
		  var zeroAt;
		  var i, l;

		  for (i = 0, l = tokens.length; i < l; i++) {
		    matchCallback(tokens[i], atRules);
		  }

		  if (Object.keys(atRules).length === 0) {
		    return;
		  }

		  markUsedAtRules(tokens, markCallback, atRules, context);

		  for (atRule in atRules) {
		    atRuleTokens = atRules[atRule];

		    for (i = 0, l = atRuleTokens.length; i < l; i++) {
		      atRuleToken = atRuleTokens[i];
		      zeroAt = atRuleToken[0] == Token.AT_RULE ? 1 : 2;
		      atRuleToken[zeroAt] = [];
		    }
		  }
		}

		function markUsedAtRules(tokens, markCallback, atRules, context) {
		  var boundMarkCallback = markCallback(atRules);
		  var i, l;

		  for (i = 0, l = tokens.length; i < l; i++) {
		    switch (tokens[i][0]) {
		    case Token.RULE:
		      boundMarkCallback(tokens[i], context);
		      break;
		    case Token.NESTED_BLOCK:
		      markUsedAtRules(tokens[i][2], markCallback, atRules, context);
		    }
		  }
		}

		function matchCounterStyle(token, atRules) {
		  var match;

		  if (token[0] == Token.AT_RULE_BLOCK && token[1][0][1].indexOf('@counter-style') === 0) {
		    match = token[1][0][1].split(' ')[1];
		    atRules[match] = atRules[match] || [];
		    atRules[match].push(token);
		  }
		}

		function markCounterStylesAsUsed(atRules) {
		  return function(token, context) {
		    var property;
		    var wrappedProperty;
		    var i, l;

		    for (i = 0, l = token[2].length; i < l; i++) {
		      property = token[2][i];

		      if (property[1][1] == 'list-style') {
		        wrappedProperty = wrapForOptimizing(property);
		        populateComponents([wrappedProperty], context.validator, context.warnings);

		        if (wrappedProperty.components[0].value[0][1] in atRules) {
		          delete atRules[property[2][1]];
		        }

		        restoreFromOptimizing([wrappedProperty]);
		      }

		      if (property[1][1] == 'list-style-type' && property[2][1] in atRules) {
		        delete atRules[property[2][1]];
		      }
		    }
		  };
		}

		function matchFontFace(token, atRules) {
		  var property;
		  var match;
		  var i, l;

		  if (token[0] == Token.AT_RULE_BLOCK && token[1][0][1] == '@font-face') {
		    for (i = 0, l = token[2].length; i < l; i++) {
		      property = token[2][i];

		      if (property[1][1] == 'font-family') {
		        match = normalize(property[2][1].toLowerCase());
		        atRules[match] = atRules[match] || [];
		        atRules[match].push(token);
		        break;
		      }
		    }
		  }
		}

		function markFontFacesAsUsed(atRules) {
		  return function(token, context) {
		    var property;
		    var wrappedProperty;
		    var component;
		    var normalizedMatch;
		    var i, l;
		    var j, m;

		    for (i = 0, l = token[2].length; i < l; i++) {
		      property = token[2][i];

		      if (property[1][1] == 'font') {
		        wrappedProperty = wrapForOptimizing(property);
		        populateComponents([wrappedProperty], context.validator, context.warnings);
		        component = wrappedProperty.components[6];

		        for (j = 0, m = component.value.length; j < m; j++) {
		          normalizedMatch = normalize(component.value[j][1].toLowerCase());

		          if (normalizedMatch in atRules) {
		            delete atRules[normalizedMatch];
		          }
		        }

		        restoreFromOptimizing([wrappedProperty]);
		      }

		      if (property[1][1] == 'font-family') {
		        for (j = 2, m = property.length; j < m; j++) {
		          normalizedMatch = normalize(property[j][1].toLowerCase());

		          if (normalizedMatch in atRules) {
		            delete atRules[normalizedMatch];
		          }
		        }
		      }
		    }
		  };
		}

		function matchKeyframe(token, atRules) {
		  var match;

		  if (token[0] == Token.NESTED_BLOCK && keyframeRegex.test(token[1][0][1])) {
		    match = token[1][0][1].split(' ')[1];
		    atRules[match] = atRules[match] || [];
		    atRules[match].push(token);
		  }
		}

		function markKeyframesAsUsed(atRules) {
		  return function(token, context) {
		    var property;
		    var wrappedProperty;
		    var component;
		    var i, l;
		    var j, m;

		    for (i = 0, l = token[2].length; i < l; i++) {
		      property = token[2][i];

		      if (animationRegex.test(property[1][1])) {
		        wrappedProperty = wrapForOptimizing(property);
		        populateComponents([wrappedProperty], context.validator, context.warnings);
		        component = wrappedProperty.components[7];

		        for (j = 0, m = component.value.length; j < m; j++) {
		          if (component.value[j][1] in atRules) {
		            delete atRules[component.value[j][1]];
		          }
		        }

		        restoreFromOptimizing([wrappedProperty]);
		      }

		      if (animationNameRegex.test(property[1][1])) {
		        for (j = 2, m = property.length; j < m; j++) {
		          if (property[j][1] in atRules) {
		            delete atRules[property[j][1]];
		          }
		        }
		      }
		    }
		  };
		}

		function matchNamespace(token, atRules) {
		  var match;

		  if (token[0] == Token.AT_RULE && token[1].indexOf('@namespace') === 0) {
		    match = token[1].split(' ')[1];
		    atRules[match] = atRules[match] || [];
		    atRules[match].push(token);
		  }
		}

		function markNamespacesAsUsed(atRules) {
		  var namespaceRegex = new RegExp(Object.keys(atRules).join('\\||') + '\\|', 'g');

		  return function(token) {
		    var match;
		    var scope;
		    var normalizedMatch;
		    var i, l;
		    var j, m;

		    for (i = 0, l = token[1].length; i < l; i++) {
		      scope = token[1][i];
		      match = scope[1].match(namespaceRegex);

		      for (j = 0, m = match.length; j < m; j++) {
		        normalizedMatch = match[j].substring(0, match[j].length - 1);

		        if (normalizedMatch in atRules) {
		          delete atRules[normalizedMatch];
		        }
		      }
		    }
		  };
		}

		removeUnusedAtRules_1 = removeUnusedAtRules;
		return removeUnusedAtRules_1;
	}

	var tidyRuleDuplicates_1;
	var hasRequiredTidyRuleDuplicates;

	function requireTidyRuleDuplicates () {
		if (hasRequiredTidyRuleDuplicates) return tidyRuleDuplicates_1;
		hasRequiredTidyRuleDuplicates = 1;
		function ruleSorter(s1, s2) {
		  return s1[1] > s2[1] ? 1 : -1;
		}

		function tidyRuleDuplicates(rules) {
		  var list = [];
		  var repeated = [];

		  for (var i = 0, l = rules.length; i < l; i++) {
		    var rule = rules[i];

		    if (repeated.indexOf(rule[1]) == -1) {
		      repeated.push(rule[1]);
		      list.push(rule);
		    }
		  }

		  return list.sort(ruleSorter);
		}

		tidyRuleDuplicates_1 = tidyRuleDuplicates;
		return tidyRuleDuplicates_1;
	}

	var restructure_1;
	var hasRequiredRestructure;

	function requireRestructure () {
		if (hasRequiredRestructure) return restructure_1;
		hasRequiredRestructure = 1;
		var canReorderSingle = requireReorderable().canReorderSingle;
		var extractProperties = requireExtractProperties();
		var isMergeable = requireIsMergeable();
		var tidyRuleDuplicates = requireTidyRuleDuplicates();

		var Token = requireToken();

		var cloneArray = requireCloneArray();

		var serializeBody = requireOneTime().body;
		var serializeRules = requireOneTime().rules;

		function naturalSorter(a, b) {
		  return a > b ? 1 : -1;
		}

		function cloneAndMergeSelectors(propertyA, propertyB) {
		  var cloned = cloneArray(propertyA);
		  cloned[5] = cloned[5].concat(propertyB[5]);

		  return cloned;
		}

		function restructure(tokens, context) {
		  var options = context.options;
		  var mergeablePseudoClasses = options.compatibility.selectors.mergeablePseudoClasses;
		  var mergeablePseudoElements = options.compatibility.selectors.mergeablePseudoElements;
		  var mergeLimit = options.compatibility.selectors.mergeLimit;
		  var multiplePseudoMerging = options.compatibility.selectors.multiplePseudoMerging;
		  var specificityCache = context.cache.specificity;
		  var movableTokens = {};
		  var movedProperties = [];
		  var multiPropertyMoveCache = {};
		  var movedToBeDropped = [];
		  var maxCombinationsLevel = 2;
		  var ID_JOIN_CHARACTER = '%';

		  function sendToMultiPropertyMoveCache(position, movedProperty, allFits) {
		    for (var i = allFits.length - 1; i >= 0; i--) {
		      var fit = allFits[i][0];
		      var id = addToCache(movedProperty, fit);

		      if (multiPropertyMoveCache[id].length > 1 && processMultiPropertyMove(position, multiPropertyMoveCache[id])) {
		        removeAllMatchingFromCache(id);
		        break;
		      }
		    }
		  }

		  function addToCache(movedProperty, fit) {
		    var id = cacheId(fit);
		    multiPropertyMoveCache[id] = multiPropertyMoveCache[id] || [];
		    multiPropertyMoveCache[id].push([movedProperty, fit]);
		    return id;
		  }

		  function removeAllMatchingFromCache(matchId) {
		    var matchSelectors = matchId.split(ID_JOIN_CHARACTER);
		    var forRemoval = [];
		    var i;

		    for (var id in multiPropertyMoveCache) {
		      var selectors = id.split(ID_JOIN_CHARACTER);
		      for (i = selectors.length - 1; i >= 0; i--) {
		        if (matchSelectors.indexOf(selectors[i]) > -1) {
		          forRemoval.push(id);
		          break;
		        }
		      }
		    }

		    for (i = forRemoval.length - 1; i >= 0; i--) {
		      delete multiPropertyMoveCache[forRemoval[i]];
		    }
		  }

		  function cacheId(cachedTokens) {
		    var id = [];
		    for (var i = 0, l = cachedTokens.length; i < l; i++) {
		      id.push(serializeRules(cachedTokens[i][1]));
		    }
		    return id.join(ID_JOIN_CHARACTER);
		  }

		  function tokensToMerge(sourceTokens) {
		    var uniqueTokensWithBody = [];
		    var mergeableTokens = [];

		    for (var i = sourceTokens.length - 1; i >= 0; i--) {
		      if (!isMergeable(
		        serializeRules(sourceTokens[i][1]),
		        mergeablePseudoClasses,
		        mergeablePseudoElements,
		        multiplePseudoMerging
		      )) {
		        continue;
		      }

		      mergeableTokens.unshift(sourceTokens[i]);
		      if (sourceTokens[i][2].length > 0
		        && uniqueTokensWithBody.indexOf(sourceTokens[i]) == -1) {
		        uniqueTokensWithBody.push(sourceTokens[i]);
		      }
		    }

		    return uniqueTokensWithBody.length > 1
		      ? mergeableTokens
		      : [];
		  }

		  function shortenIfPossible(position, movedProperty) {
		    var name = movedProperty[0];
		    var value = movedProperty[1];
		    var key = movedProperty[4];
		    var valueSize = name.length + value.length + 1;
		    var allSelectors = [];
		    var qualifiedTokens = [];

		    var mergeableTokens = tokensToMerge(movableTokens[key]);
		    if (mergeableTokens.length < 2) { return; }

		    var allFits = findAllFits(mergeableTokens, valueSize, 1);
		    var bestFit = allFits[0];
		    if (bestFit[1] > 0) { return sendToMultiPropertyMoveCache(position, movedProperty, allFits); }

		    for (var i = bestFit[0].length - 1; i >= 0; i--) {
		      allSelectors = bestFit[0][i][1].concat(allSelectors);
		      qualifiedTokens.unshift(bestFit[0][i]);
		    }

		    allSelectors = tidyRuleDuplicates(allSelectors);
		    dropAsNewTokenAt(position, [movedProperty], allSelectors, qualifiedTokens);
		  }

		  function fitSorter(fit1, fit2) {
		    return fit1[1] > fit2[1] ? 1 : (fit1[1] == fit2[1] ? 0 : -1);
		  }

		  function findAllFits(mergeableTokens, propertySize, propertiesCount) {
		    var combinations = allCombinations(mergeableTokens, propertySize, propertiesCount, maxCombinationsLevel - 1);
		    return combinations.sort(fitSorter);
		  }

		  function allCombinations(tokensVariant, propertySize, propertiesCount, level) {
		    var differenceVariants = [[tokensVariant, sizeDifference(tokensVariant, propertySize, propertiesCount)]];
		    if (tokensVariant.length > 2 && level > 0) {
		      for (var i = tokensVariant.length - 1; i >= 0; i--) {
		        var subVariant = Array.prototype.slice.call(tokensVariant, 0);
		        subVariant.splice(i, 1);
		        differenceVariants = differenceVariants.concat(
		          allCombinations(subVariant, propertySize, propertiesCount, level - 1)
		        );
		      }
		    }

		    return differenceVariants;
		  }

		  function sizeDifference(tokensVariant, propertySize, propertiesCount) {
		    var allSelectorsSize = 0;
		    for (var i = tokensVariant.length - 1; i >= 0; i--) {
		      allSelectorsSize += tokensVariant[i][2].length > propertiesCount
		        ? serializeRules(tokensVariant[i][1]).length
		        : -1;
		    }
		    return allSelectorsSize - (tokensVariant.length - 1) * propertySize + 1;
		  }

		  function dropAsNewTokenAt(position, properties, allSelectors, mergeableTokens) {
		    var i, j, k, m;
		    var allProperties = [];

		    for (i = mergeableTokens.length - 1; i >= 0; i--) {
		      var mergeableToken = mergeableTokens[i];

		      for (j = mergeableToken[2].length - 1; j >= 0; j--) {
		        var mergeableProperty = mergeableToken[2][j];

		        for (k = 0, m = properties.length; k < m; k++) {
		          var property = properties[k];

		          var mergeablePropertyName = mergeableProperty[1][1];
		          var propertyName = property[0];
		          var propertyBody = property[4];
		          if (mergeablePropertyName == propertyName && serializeBody([mergeableProperty]) == propertyBody) {
		            mergeableToken[2].splice(j, 1);
		            break;
		          }
		        }
		      }
		    }

		    for (i = properties.length - 1; i >= 0; i--) {
		      allProperties.unshift(properties[i][3]);
		    }

		    var newToken = [Token.RULE, allSelectors, allProperties];
		    tokens.splice(position, 0, newToken);
		  }

		  function dropPropertiesAt(position, movedProperty) {
		    var key = movedProperty[4];
		    var toMove = movableTokens[key];

		    if (toMove && toMove.length > 1) {
		      if (!shortenMultiMovesIfPossible(position, movedProperty)) { shortenIfPossible(position, movedProperty); }
		    }
		  }

		  function shortenMultiMovesIfPossible(position, movedProperty) {
		    var candidates = [];
		    var propertiesAndMergableTokens = [];
		    var key = movedProperty[4];
		    var j, k;

		    var mergeableTokens = tokensToMerge(movableTokens[key]);
		    if (mergeableTokens.length < 2) { return; }

		    movableLoop:
		    for (var value in movableTokens) {
		      var tokensList = movableTokens[value];

		      for (j = mergeableTokens.length - 1; j >= 0; j--) {
		        if (tokensList.indexOf(mergeableTokens[j]) == -1) { continue movableLoop; }
		      }

		      candidates.push(value);
		    }

		    if (candidates.length < 2) { return false; }

		    for (j = candidates.length - 1; j >= 0; j--) {
		      for (k = movedProperties.length - 1; k >= 0; k--) {
		        if (movedProperties[k][4] == candidates[j]) {
		          propertiesAndMergableTokens.unshift([movedProperties[k], mergeableTokens]);
		          break;
		        }
		      }
		    }

		    return processMultiPropertyMove(position, propertiesAndMergableTokens);
		  }

		  function processMultiPropertyMove(position, propertiesAndMergableTokens) {
		    var valueSize = 0;
		    var properties = [];
		    var property;

		    for (var i = propertiesAndMergableTokens.length - 1; i >= 0; i--) {
		      property = propertiesAndMergableTokens[i][0];
		      var fullValue = property[4];
		      valueSize += fullValue.length + (i > 0 ? 1 : 0);

		      properties.push(property);
		    }

		    var mergeableTokens = propertiesAndMergableTokens[0][1];
		    var bestFit = findAllFits(mergeableTokens, valueSize, properties.length)[0];
		    if (bestFit[1] > 0) { return false; }

		    var allSelectors = [];
		    var qualifiedTokens = [];
		    for (i = bestFit[0].length - 1; i >= 0; i--) {
		      allSelectors = bestFit[0][i][1].concat(allSelectors);
		      qualifiedTokens.unshift(bestFit[0][i]);
		    }

		    allSelectors = tidyRuleDuplicates(allSelectors);
		    dropAsNewTokenAt(position, properties, allSelectors, qualifiedTokens);

		    for (i = properties.length - 1; i >= 0; i--) {
		      property = properties[i];
		      var index = movedProperties.indexOf(property);

		      delete movableTokens[property[4]];

		      if (index > -1 && movedToBeDropped.indexOf(index) == -1) { movedToBeDropped.push(index); }
		    }

		    return true;
		  }

		  function boundToAnotherPropertyInCurrrentToken(property, movedProperty, token) {
		    var propertyName = property[0];
		    var movedPropertyName = movedProperty[0];
		    if (propertyName != movedPropertyName) { return false; }

		    var key = movedProperty[4];
		    var toMove = movableTokens[key];
		    return toMove && toMove.indexOf(token) > -1;
		  }

		  for (var i = tokens.length - 1; i >= 0; i--) {
		    var token = tokens[i];
		    var isRule;
		    var j, k, m;
		    var samePropertyAt;

		    if (token[0] == Token.RULE) {
		      isRule = true;
		    } else if (token[0] == Token.NESTED_BLOCK) {
		      isRule = false;
		    } else {
		      continue;
		    }

		    // We cache movedProperties.length as it may change in the loop
		    var movedCount = movedProperties.length;

		    var properties = extractProperties(token);
		    movedToBeDropped = [];

		    var unmovableInCurrentToken = [];
		    for (j = properties.length - 1; j >= 0; j--) {
		      for (k = j - 1; k >= 0; k--) {
		        if (!canReorderSingle(properties[j], properties[k], specificityCache)) {
		          unmovableInCurrentToken.push(j);
		          break;
		        }
		      }
		    }

		    for (j = properties.length - 1; j >= 0; j--) {
		      var property = properties[j];
		      var movedSameProperty = false;

		      for (k = 0; k < movedCount; k++) {
		        var movedProperty = movedProperties[k];

		        if (movedToBeDropped.indexOf(k) == -1 && (
		          !canReorderSingle(property, movedProperty, specificityCache)
		          && !boundToAnotherPropertyInCurrrentToken(property, movedProperty, token)
		          || movableTokens[movedProperty[4]] && movableTokens[movedProperty[4]].length === mergeLimit)
		        ) {
		          dropPropertiesAt(i + 1, movedProperty);

		          if (movedToBeDropped.indexOf(k) == -1) {
		            movedToBeDropped.push(k);
		            delete movableTokens[movedProperty[4]];
		          }
		        }

		        if (!movedSameProperty) {
		          movedSameProperty = property[0] == movedProperty[0] && property[1] == movedProperty[1];

		          if (movedSameProperty) {
		            samePropertyAt = k;
		          }
		        }
		      }

		      if (!isRule || unmovableInCurrentToken.indexOf(j) > -1) { continue; }

		      var key = property[4];

		      if (movedSameProperty && movedProperties[samePropertyAt][5].length + property[5].length > mergeLimit) {
		        dropPropertiesAt(i + 1, movedProperties[samePropertyAt]);
		        movedProperties.splice(samePropertyAt, 1);
		        movableTokens[key] = [token];
		        movedSameProperty = false;
		      } else {
		        movableTokens[key] = movableTokens[key] || [];
		        movableTokens[key].push(token);
		      }

		      if (movedSameProperty) {
		        movedProperties[samePropertyAt] = cloneAndMergeSelectors(movedProperties[samePropertyAt], property);
		      } else {
		        movedProperties.push(property);
		      }
		    }

		    movedToBeDropped = movedToBeDropped.sort(naturalSorter);
		    for (j = 0, m = movedToBeDropped.length; j < m; j++) {
		      var dropAt = movedToBeDropped[j] - j;
		      movedProperties.splice(dropAt, 1);
		    }
		  }

		  var position = tokens[0] && tokens[0][0] == Token.AT_RULE && tokens[0][1].indexOf('@charset') === 0 ? 1 : 0;
		  for (; position < tokens.length - 1; position++) {
		    var isImportRule = tokens[position][0] === Token.AT_RULE && tokens[position][1].indexOf('@import') === 0;
		    var isComment = tokens[position][0] === Token.COMMENT;
		    if (!(isImportRule || isComment)) { break; }
		  }

		  for (i = 0; i < movedProperties.length; i++) {
		    dropPropertiesAt(position, movedProperties[i]);
		  }
		}

		restructure_1 = restructure;
		return restructure_1;
	}

	var optimize;
	var hasRequiredOptimize;

	function requireOptimize () {
		if (hasRequiredOptimize) return optimize;
		hasRequiredOptimize = 1;
		var mergeAdjacent = requireMergeAdjacent();
		var mergeMediaQueries = requireMergeMediaQueries();
		var mergeNonAdjacentByBody = requireMergeNonAdjacentByBody();
		var mergeNonAdjacentBySelector = requireMergeNonAdjacentBySelector();
		var reduceNonAdjacent = requireReduceNonAdjacent();
		var removeDuplicateFontAtRules = requireRemoveDuplicateFontAtRules();
		var removeDuplicateMediaQueries = requireRemoveDuplicateMediaQueries();
		var removeDuplicates = requireRemoveDuplicates();
		var removeUnusedAtRules = requireRemoveUnusedAtRules();
		var restructure = requireRestructure();

		var optimizeProperties = requireOptimize$1();

		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;

		var Token = requireToken();

		function removeEmpty(tokens) {
		  for (var i = 0, l = tokens.length; i < l; i++) {
		    var token = tokens[i];
		    var isEmpty = false;

		    switch (token[0]) {
		    case Token.RULE:
		      isEmpty = token[1].length === 0 || token[2].length === 0;
		      break;
		    case Token.NESTED_BLOCK:
		      removeEmpty(token[2]);
		      isEmpty = token[2].length === 0;
		      break;
		    case Token.AT_RULE:
		      isEmpty = token[1].length === 0;
		      break;
		    case Token.AT_RULE_BLOCK:
		      isEmpty = token[2].length === 0;
		    }

		    if (isEmpty) {
		      tokens.splice(i, 1);
		      i--;
		      l--;
		    }
		  }
		}

		function recursivelyOptimizeBlocks(tokens, context) {
		  for (var i = 0, l = tokens.length; i < l; i++) {
		    var token = tokens[i];

		    if (token[0] == Token.NESTED_BLOCK) {
		      var isKeyframes = /@(-moz-|-o-|-webkit-)?keyframes/.test(token[1][0][1]);
		      level2Optimize(token[2], context, !isKeyframes);
		    }
		  }
		}

		function recursivelyOptimizeProperties(tokens, context) {
		  for (var i = 0, l = tokens.length; i < l; i++) {
		    var token = tokens[i];

		    switch (token[0]) {
		    case Token.RULE:
		      optimizeProperties(token[2], true, true, context);
		      break;
		    case Token.NESTED_BLOCK:
		      recursivelyOptimizeProperties(token[2], context);
		    }
		  }
		}

		function level2Optimize(tokens, context, withRestructuring) {
		  var levelOptions = context.options.level[OptimizationLevel.Two];
		  var level2Plugins = context.options.plugins.level2Block;
		  var reduced;
		  var i;

		  recursivelyOptimizeBlocks(tokens, context);
		  recursivelyOptimizeProperties(tokens, context);

		  if (levelOptions.removeDuplicateRules) {
		    removeDuplicates(tokens, context);
		  }

		  if (levelOptions.mergeAdjacentRules) {
		    mergeAdjacent(tokens, context);
		  }

		  if (levelOptions.reduceNonAdjacentRules) {
		    reduceNonAdjacent(tokens, context);
		  }

		  if (levelOptions.mergeNonAdjacentRules && levelOptions.mergeNonAdjacentRules != 'body') {
		    mergeNonAdjacentBySelector(tokens, context);
		  }

		  if (levelOptions.mergeNonAdjacentRules && levelOptions.mergeNonAdjacentRules != 'selector') {
		    mergeNonAdjacentByBody(tokens, context);
		  }

		  if (levelOptions.restructureRules && levelOptions.mergeAdjacentRules && withRestructuring) {
		    restructure(tokens, context);
		    mergeAdjacent(tokens, context);
		  }

		  if (levelOptions.restructureRules && !levelOptions.mergeAdjacentRules && withRestructuring) {
		    restructure(tokens, context);
		  }

		  if (levelOptions.removeDuplicateFontRules) {
		    removeDuplicateFontAtRules(tokens, context);
		  }

		  if (levelOptions.removeDuplicateMediaBlocks) {
		    removeDuplicateMediaQueries(tokens, context);
		  }

		  if (levelOptions.removeUnusedAtRules) {
		    removeUnusedAtRules(tokens, context);
		  }

		  if (levelOptions.mergeMedia) {
		    reduced = mergeMediaQueries(tokens, context);
		    for (i = reduced.length - 1; i >= 0; i--) {
		      level2Optimize(reduced[i][2], context, false);
		    }
		  }

		  for (i = 0; i < level2Plugins.length; i++) {
		    level2Plugins[i](tokens);
		  }

		  if (levelOptions.removeEmpty) {
		    removeEmpty(tokens);
		  }

		  return tokens;
		}

		optimize = level2Optimize;
		return optimize;
	}

	var validator_1;
	var hasRequiredValidator;

	function requireValidator () {
		if (hasRequiredValidator) return validator_1;
		hasRequiredValidator = 1;
		var functionNoVendorRegexStr = '[A-Z]+(\\-|[A-Z]|[0-9])+\\(.*?\\)';
		var functionVendorRegexStr = '\\-(\\-|[A-Z]|[0-9])+\\(.*?\\)';
		var variableRegexStr = 'var\\(\\-\\-[^\\)]+\\)';
		var functionAnyRegexStr = '(' + variableRegexStr + '|' + functionNoVendorRegexStr + '|' + functionVendorRegexStr + ')';

		var calcRegex = new RegExp('^(\\-moz\\-|\\-webkit\\-)?calc\\([^\\)]+\\)$', 'i');
		var decimalRegex = /[0-9]/;
		var functionAnyRegex = new RegExp('^' + functionAnyRegexStr + '$', 'i');
		var hexAlphaColorRegex = /^#(?:[0-9a-f]{4}|[0-9a-f]{8})$/i;
		// eslint-disable-next-line max-len
		var hslColorRegex = /^hsl\(\s{0,31}[-.]?\d+\s{0,31},\s{0,31}\d*\.?\d+%\s{0,31},\s{0,31}\d*\.?\d+%\s{0,31}\)|hsla\(\s{0,31}[-.]?\d+\s{0,31},\s{0,31}\d*\.?\d+%\s{0,31},\s{0,31}\d*\.?\d+%\s{0,31},\s{0,31}\.?\d+\s{0,31}\)$/;
		// eslint-disable-next-line max-len
		var hslColorWithSpacesRegex = /^hsl\(\s{0,31}[-.]?\d+(deg)?\s{1,31}\d*\.?\d+%\s{1,31}\d*\.?\d+%\s{0,31}\)|hsla\(\s{0,31}[-.]?\d+(deg)?\s{1,31}\d*\.?\d+%\s{1,31}\d*\.?\d+%\s{1,31}\/\s{1,31}\d*\.?\d+%?\s{0,31}\)$/;
		var identifierRegex = /^(-[a-z0-9_][a-z0-9\-_]*|[a-z_][a-z0-9\-_]*)$/i;
		var namedEntityRegex = /^[a-z]+$/i;
		var prefixRegex = /^-([a-z0-9]|-)*$/i;
		var quotedTextRegex = /^("[^"]*"|'[^']*')$/i;
		// eslint-disable-next-line max-len
		var rgbColorRegex = /^rgb\(\s{0,31}[\d]{1,3}\s{0,31},\s{0,31}[\d]{1,3}\s{0,31},\s{0,31}[\d]{1,3}\s{0,31}\)|rgba\(\s{0,31}[\d]{1,3}\s{0,31},\s{0,31}[\d]{1,3}\s{0,31},\s{0,31}[\d]{1,3}\s{0,31},\s{0,31}[.\d]+\s{0,31}\)$/i;
		// eslint-disable-next-line max-len
		var rgbColorWithSpacesRegex = /^rgb\(\s{0,31}[\d]{1,3}\s{1,31}[\d]{1,3}\s{1,31}[\d]{1,3}\s{0,31}\)|rgba\(\s{0,31}[\d]{1,3}\s{1,31}[\d]{1,3}\s{1,31}[\d]{1,3}\s{1,31}\/\s{1,31}[\d]*\.?[.\d]+%?\s{0,31}\)$/i;
		var timeUnitPattern = /\d+(s|ms)/;
		var timingFunctionRegex = /^(cubic-bezier|steps)\([^)]+\)$/;
		var validTimeUnits = ['ms', 's'];
		var urlRegex = /^url\([\s\S]+\)$/i;
		var variableRegex = new RegExp('^' + variableRegexStr + '$', 'i');

		var eightValueColorRegex = /^#[0-9a-f]{8}$/i;
		var fourValueColorRegex = /^#[0-9a-f]{4}$/i;
		var sixValueColorRegex = /^#[0-9a-f]{6}$/i;
		var threeValueColorRegex = /^#[0-9a-f]{3}$/i;

		var DECIMAL_DOT = '.';
		var MINUS_SIGN = '-';
		var PLUS_SIGN = '+';

		var Keywords = {
		  '^': [
		    'inherit',
		    'initial',
		    'unset'
		  ],
		  '*-style': [
		    'auto',
		    'dashed',
		    'dotted',
		    'double',
		    'groove',
		    'hidden',
		    'inset',
		    'none',
		    'outset',
		    'ridge',
		    'solid'
		  ],
		  '*-timing-function': [
		    'ease',
		    'ease-in',
		    'ease-in-out',
		    'ease-out',
		    'linear',
		    'step-end',
		    'step-start'
		  ],
		  'animation-direction': [
		    'alternate',
		    'alternate-reverse',
		    'normal',
		    'reverse'
		  ],
		  'animation-fill-mode': [
		    'backwards',
		    'both',
		    'forwards',
		    'none'
		  ],
		  'animation-iteration-count': [
		    'infinite'
		  ],
		  'animation-name': [
		    'none'
		  ],
		  'animation-play-state': [
		    'paused',
		    'running'
		  ],
		  'background-attachment': [
		    'fixed',
		    'inherit',
		    'local',
		    'scroll'
		  ],
		  'background-clip': [
		    'border-box',
		    'content-box',
		    'inherit',
		    'padding-box',
		    'text'
		  ],
		  'background-origin': [
		    'border-box',
		    'content-box',
		    'inherit',
		    'padding-box'
		  ],
		  'background-position': [
		    'bottom',
		    'center',
		    'left',
		    'right',
		    'top'
		  ],
		  'background-repeat': [
		    'no-repeat',
		    'inherit',
		    'repeat',
		    'repeat-x',
		    'repeat-y',
		    'round',
		    'space'
		  ],
		  'background-size': [
		    'auto',
		    'cover',
		    'contain'
		  ],
		  'border-collapse': [
		    'collapse',
		    'inherit',
		    'separate'
		  ],
		  bottom: [
		    'auto'
		  ],
		  clear: [
		    'both',
		    'left',
		    'none',
		    'right'
		  ],
		  color: [
		    'transparent'
		  ],
		  cursor: [
		    'all-scroll',
		    'auto',
		    'col-resize',
		    'crosshair',
		    'default',
		    'e-resize',
		    'help',
		    'move',
		    'n-resize',
		    'ne-resize',
		    'no-drop',
		    'not-allowed',
		    'nw-resize',
		    'pointer',
		    'progress',
		    'row-resize',
		    's-resize',
		    'se-resize',
		    'sw-resize',
		    'text',
		    'vertical-text',
		    'w-resize',
		    'wait'
		  ],
		  display: [
		    'block',
		    'inline',
		    'inline-block',
		    'inline-table',
		    'list-item',
		    'none',
		    'table',
		    'table-caption',
		    'table-cell',
		    'table-column',
		    'table-column-group',
		    'table-footer-group',
		    'table-header-group',
		    'table-row',
		    'table-row-group'
		  ],
		  float: [
		    'left',
		    'none',
		    'right'
		  ],
		  left: [
		    'auto'
		  ],
		  font: [
		    'caption',
		    'icon',
		    'menu',
		    'message-box',
		    'small-caption',
		    'status-bar',
		    'unset'
		  ],
		  'font-size': [
		    'large',
		    'larger',
		    'medium',
		    'small',
		    'smaller',
		    'x-large',
		    'x-small',
		    'xx-large',
		    'xx-small'
		  ],
		  'font-stretch': [
		    'condensed',
		    'expanded',
		    'extra-condensed',
		    'extra-expanded',
		    'normal',
		    'semi-condensed',
		    'semi-expanded',
		    'ultra-condensed',
		    'ultra-expanded'
		  ],
		  'font-style': [
		    'italic',
		    'normal',
		    'oblique'
		  ],
		  'font-variant': [
		    'normal',
		    'small-caps'
		  ],
		  'font-weight': [
		    '100',
		    '200',
		    '300',
		    '400',
		    '500',
		    '600',
		    '700',
		    '800',
		    '900',
		    'bold',
		    'bolder',
		    'lighter',
		    'normal'
		  ],
		  'line-height': [
		    'normal'
		  ],
		  'list-style-position': [
		    'inside',
		    'outside'
		  ],
		  'list-style-type': [
		    'armenian',
		    'circle',
		    'decimal',
		    'decimal-leading-zero',
		    'disc',
		    'decimal|disc', // this is the default value of list-style-type, see comment in configuration.js
		    'georgian',
		    'lower-alpha',
		    'lower-greek',
		    'lower-latin',
		    'lower-roman',
		    'none',
		    'square',
		    'upper-alpha',
		    'upper-latin',
		    'upper-roman'
		  ],
		  overflow: [
		    'auto',
		    'hidden',
		    'scroll',
		    'visible'
		  ],
		  position: [
		    'absolute',
		    'fixed',
		    'relative',
		    'static'
		  ],
		  right: [
		    'auto'
		  ],
		  'text-align': [
		    'center',
		    'justify',
		    'left',
		    'left|right', // this is the default value of list-style-type, see comment in configuration.js
		    'right'
		  ],
		  'text-decoration': [
		    'line-through',
		    'none',
		    'overline',
		    'underline'
		  ],
		  'text-overflow': [
		    'clip',
		    'ellipsis'
		  ],
		  top: [
		    'auto'
		  ],
		  'vertical-align': [
		    'baseline',
		    'bottom',
		    'middle',
		    'sub',
		    'super',
		    'text-bottom',
		    'text-top',
		    'top'
		  ],
		  visibility: [
		    'collapse',
		    'hidden',
		    'visible'
		  ],
		  'white-space': [
		    'normal',
		    'nowrap',
		    'pre'
		  ],
		  width: [
		    'inherit',
		    'initial',
		    'medium',
		    'thick',
		    'thin'
		  ]
		};

		var Units = [
		  '%',
		  'ch',
		  'cm',
		  'em',
		  'ex',
		  'in',
		  'mm',
		  'pc',
		  'pt',
		  'px',
		  'rem',
		  'vh',
		  'vm',
		  'vmax',
		  'vmin',
		  'vw'
		];

		function isColor(value) {
		  return value != 'auto'
		    && (
		      isKeyword('color')(value)
		      || isHexColor(value)
		      || isColorFunction(value)
		      || isNamedEntity(value)
		    );
		}

		function isColorFunction(value) {
		  return isRgbColor(value) || isHslColor(value);
		}

		function isDynamicUnit(value) {
		  return calcRegex.test(value);
		}

		function isFunction(value) {
		  return functionAnyRegex.test(value);
		}

		function isHexColor(value) {
		  return threeValueColorRegex.test(value)
		    || fourValueColorRegex.test(value)
		    || sixValueColorRegex.test(value)
		    || eightValueColorRegex.test(value);
		}

		function isHslColor(value) {
		  return hslColorRegex.test(value) || hslColorWithSpacesRegex.test(value);
		}

		function isHexAlphaColor(value) {
		  return hexAlphaColorRegex.test(value);
		}

		function isIdentifier(value) {
		  return identifierRegex.test(value);
		}

		function isQuotedText(value) {
		  return quotedTextRegex.test(value);
		}

		function isImage(value) {
		  return value == 'none' || value == 'inherit' || isUrl(value);
		}

		function isKeyword(propertyName) {
		  return function(value) {
		    return Keywords[propertyName].indexOf(value) > -1;
		  };
		}

		function isNamedEntity(value) {
		  return namedEntityRegex.test(value);
		}

		function isNumber(value) {
		  return scanForNumber(value) == value.length;
		}

		function isRgbColor(value) {
		  return rgbColorRegex.test(value) || rgbColorWithSpacesRegex.test(value);
		}

		function isPrefixed(value) {
		  return prefixRegex.test(value);
		}

		function isPositiveNumber(value) {
		  return isNumber(value)
		    && parseFloat(value) >= 0;
		}

		function isVariable(value) {
		  return variableRegex.test(value);
		}

		function isTime(value) {
		  var numberUpTo = scanForNumber(value);

		  return numberUpTo == value.length && parseInt(value) === 0
		    || numberUpTo > -1 && validTimeUnits.indexOf(value.slice(numberUpTo + 1)) > -1
		    || isCalculatedTime(value);
		}

		function isCalculatedTime(value) {
		  return isFunction(value) && timeUnitPattern.test(value);
		}

		function isTimingFunction() {
		  var isTimingFunctionKeyword = isKeyword('*-timing-function');

		  return function(value) {
		    return isTimingFunctionKeyword(value) || timingFunctionRegex.test(value);
		  };
		}

		function isUnit(validUnits, value) {
		  var numberUpTo = scanForNumber(value);

		  return numberUpTo == value.length && parseInt(value) === 0
		    || numberUpTo > -1 && validUnits.indexOf(value.slice(numberUpTo + 1).toLowerCase()) > -1
		    || value == 'auto'
		    || value == 'inherit';
		}

		function isUrl(value) {
		  return urlRegex.test(value);
		}

		function isZIndex(value) {
		  return value == 'auto'
		    || isNumber(value)
		    || isKeyword('^')(value);
		}

		function scanForNumber(value) {
		  var hasDot = false;
		  var hasSign = false;
		  var character;
		  var i, l;

		  for (i = 0, l = value.length; i < l; i++) {
		    character = value[i];

		    if (i === 0 && (character == PLUS_SIGN || character == MINUS_SIGN)) {
		      hasSign = true;
		    } else if (i > 0 && hasSign && (character == PLUS_SIGN || character == MINUS_SIGN)) {
		      return i - 1;
		    } else if (character == DECIMAL_DOT && !hasDot) {
		      hasDot = true;
		    } else if (character == DECIMAL_DOT && hasDot) {
		      return i - 1;
		    } else if (decimalRegex.test(character)) {
		      continue;
		    } else {
		      return i - 1;
		    }
		  }

		  return i;
		}

		function validator(compatibility) {
		  var validUnits = Units.slice(0).filter(function(value) {
		    return !(value in compatibility.units) || compatibility.units[value] === true;
		  });

		  if (compatibility.customUnits.rpx) {
		    validUnits.push('rpx');
		  }

		  return {
		    colorOpacity: compatibility.colors.opacity,
		    colorHexAlpha: compatibility.colors.hexAlpha,
		    isAnimationDirectionKeyword: isKeyword('animation-direction'),
		    isAnimationFillModeKeyword: isKeyword('animation-fill-mode'),
		    isAnimationIterationCountKeyword: isKeyword('animation-iteration-count'),
		    isAnimationNameKeyword: isKeyword('animation-name'),
		    isAnimationPlayStateKeyword: isKeyword('animation-play-state'),
		    isTimingFunction: isTimingFunction(),
		    isBackgroundAttachmentKeyword: isKeyword('background-attachment'),
		    isBackgroundClipKeyword: isKeyword('background-clip'),
		    isBackgroundOriginKeyword: isKeyword('background-origin'),
		    isBackgroundPositionKeyword: isKeyword('background-position'),
		    isBackgroundRepeatKeyword: isKeyword('background-repeat'),
		    isBackgroundSizeKeyword: isKeyword('background-size'),
		    isColor: isColor,
		    isColorFunction: isColorFunction,
		    isDynamicUnit: isDynamicUnit,
		    isFontKeyword: isKeyword('font'),
		    isFontSizeKeyword: isKeyword('font-size'),
		    isFontStretchKeyword: isKeyword('font-stretch'),
		    isFontStyleKeyword: isKeyword('font-style'),
		    isFontVariantKeyword: isKeyword('font-variant'),
		    isFontWeightKeyword: isKeyword('font-weight'),
		    isFunction: isFunction,
		    isGlobal: isKeyword('^'),
		    isHexAlphaColor: isHexAlphaColor,
		    isHslColor: isHslColor,
		    isIdentifier: isIdentifier,
		    isImage: isImage,
		    isKeyword: isKeyword,
		    isLineHeightKeyword: isKeyword('line-height'),
		    isListStylePositionKeyword: isKeyword('list-style-position'),
		    isListStyleTypeKeyword: isKeyword('list-style-type'),
		    isNumber: isNumber,
		    isPrefixed: isPrefixed,
		    isPositiveNumber: isPositiveNumber,
		    isQuotedText: isQuotedText,
		    isRgbColor: isRgbColor,
		    isStyleKeyword: isKeyword('*-style'),
		    isTime: isTime,
		    isUnit: isUnit.bind(null, validUnits),
		    isUrl: isUrl,
		    isVariable: isVariable,
		    isWidth: isKeyword('width'),
		    isZIndex: isZIndex
		  };
		}

		validator_1 = validator;
		return validator_1;
	}

	var compatibility;
	var hasRequiredCompatibility;

	function requireCompatibility () {
		if (hasRequiredCompatibility) return compatibility;
		hasRequiredCompatibility = 1;
		var DEFAULTS = {
		  '*': {
		    colors: {
		      hexAlpha: false, // 4- and 8-character hex notation
		      opacity: true // rgba / hsla
		    },
		    customUnits: { rpx: false },
		    properties: {
		      backgroundClipMerging: true, // background-clip to shorthand
		      backgroundOriginMerging: true, // background-origin to shorthand
		      backgroundSizeMerging: true, // background-size to shorthand
		      colors: true, // any kind of color transformations, like `#ff00ff` to `#f0f` or `#fff` into `red`
		      ieBangHack: false, // !ie suffix hacks on IE<8
		      ieFilters: false, // whether to preserve `filter` and `-ms-filter` properties
		      iePrefixHack: false, // underscore / asterisk prefix hacks on IE
		      ieSuffixHack: false, // \9 suffix hacks on IE6-9, \0 suffix hack on IE6-11
		      merging: true, // merging properties into one
		      shorterLengthUnits: false, // optimize pixel units into `pt`, `pc` or `in` units
		      spaceAfterClosingBrace: true, // 'url() no-repeat' to 'url()no-repeat'
		      urlQuotes: true, // whether to wrap content of `url()` into quotes or not
		      zeroUnits: true // 0[unit] -> 0
		    },
		    selectors: {
		      adjacentSpace: false, // div+ nav Android stock browser hack
		      ie7Hack: false, // *+html hack
		      mergeablePseudoClasses: [
		        ':active',
		        ':after',
		        ':before',
		        ':empty',
		        ':checked',
		        ':disabled',
		        ':empty',
		        ':enabled',
		        ':first-child',
		        ':first-letter',
		        ':first-line',
		        ':first-of-type',
		        ':focus',
		        ':hover',
		        ':lang',
		        ':last-child',
		        ':last-of-type',
		        ':link',
		        ':not',
		        ':nth-child',
		        ':nth-last-child',
		        ':nth-last-of-type',
		        ':nth-of-type',
		        ':only-child',
		        ':only-of-type',
		        ':root',
		        ':target',
		        ':visited'
		      ], // selectors with these pseudo-classes can be merged as these are universally supported
		      mergeablePseudoElements: [
		        '::after',
		        '::before',
		        '::first-letter',
		        '::first-line'
		      ], // selectors with these pseudo-elements can be merged as these are universally supported
		      mergeLimit: 8191, // number of rules that can be safely merged together
		      multiplePseudoMerging: true
		    },
		    units: {
		      ch: true,
		      in: true,
		      pc: true,
		      pt: true,
		      rem: true,
		      vh: true,
		      vm: true, // vm is vmin on IE9+ see https://developer.mozilla.org/en-US/docs/Web/CSS/length
		      vmax: true,
		      vmin: true,
		      vw: true
		    }
		  }
		};

		DEFAULTS.ie11 = merge(DEFAULTS['*'], { properties: { ieSuffixHack: true } });

		DEFAULTS.ie10 = merge(DEFAULTS['*'], { properties: { ieSuffixHack: true } });

		DEFAULTS.ie9 = merge(DEFAULTS['*'], {
		  properties: {
		    ieFilters: true,
		    ieSuffixHack: true
		  }
		});

		DEFAULTS.ie8 = merge(DEFAULTS.ie9, {
		  colors: { opacity: false },
		  properties: {
		    backgroundClipMerging: false,
		    backgroundOriginMerging: false,
		    backgroundSizeMerging: false,
		    iePrefixHack: true,
		    merging: false
		  },
		  selectors: {
		    mergeablePseudoClasses: [
		      ':after',
		      ':before',
		      ':first-child',
		      ':first-letter',
		      ':focus',
		      ':hover',
		      ':visited'
		    ],
		    mergeablePseudoElements: []
		  },
		  units: {
		    ch: false,
		    rem: false,
		    vh: false,
		    vm: false,
		    vmax: false,
		    vmin: false,
		    vw: false
		  }
		});

		DEFAULTS.ie7 = merge(DEFAULTS.ie8, {
		  properties: { ieBangHack: true },
		  selectors: {
		    ie7Hack: true,
		    mergeablePseudoClasses: [
		      ':first-child',
		      ':first-letter',
		      ':hover',
		      ':visited'
		    ]
		  }
		});

		function compatibilityFrom(source) {
		  return merge(DEFAULTS['*'], calculateSource(source));
		}

		function merge(source, target) {
		  for (var key in source) {
		    if (Object.prototype.hasOwnProperty.call(source, key)) {
		      var value = source[key];

		      if (Object.prototype.hasOwnProperty.call(target, key) && typeof value === 'object' && !Array.isArray(value)) {
		        target[key] = merge(value, target[key] || {});
		      } else {
		        target[key] = key in target ? target[key] : value;
		      }
		    }
		  }

		  return target;
		}

		function calculateSource(source) {
		  if (typeof source == 'object') { return source; }

		  if (!/[,+-]/.test(source)) { return DEFAULTS[source] || DEFAULTS['*']; }

		  var parts = source.split(',');
		  var template = parts[0] in DEFAULTS
		    ? DEFAULTS[parts.shift()]
		    : DEFAULTS['*'];

		  source = {};

		  parts.forEach(function(part) {
		    var isAdd = part[0] == '+';
		    var key = part.substring(1).split('.');
		    var group = key[0];
		    var option = key[1];

		    source[group] = source[group] || {};
		    source[group][option] = isAdd;
		  });

		  return merge(template, source);
		}

		compatibility = compatibilityFrom;
		return compatibility;
	}

	var lookup = [];
	var revLookup = [];
	var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;
	var inited = false;
	function init () {
	  inited = true;
	  var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
	  for (var i = 0, len = code.length; i < len; ++i) {
	    lookup[i] = code[i];
	    revLookup[code.charCodeAt(i)] = i;
	  }

	  revLookup['-'.charCodeAt(0)] = 62;
	  revLookup['_'.charCodeAt(0)] = 63;
	}

	function toByteArray (b64) {
	  if (!inited) {
	    init();
	  }
	  var i, j, l, tmp, placeHolders, arr;
	  var len = b64.length;

	  if (len % 4 > 0) {
	    throw new Error('Invalid string. Length must be a multiple of 4')
	  }

	  // the number of equal signs (place holders)
	  // if there are two placeholders, than the two characters before it
	  // represent one byte
	  // if there is only one, then the three characters before it represent 2 bytes
	  // this is just a cheap hack to not do indexOf twice
	  placeHolders = b64[len - 2] === '=' ? 2 : b64[len - 1] === '=' ? 1 : 0;

	  // base64 is 4/3 + up to two characters of the original data
	  arr = new Arr(len * 3 / 4 - placeHolders);

	  // if there are placeholders, only get up to the last complete 4 chars
	  l = placeHolders > 0 ? len - 4 : len;

	  var L = 0;

	  for (i = 0, j = 0; i < l; i += 4, j += 3) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 18) | (revLookup[b64.charCodeAt(i + 1)] << 12) | (revLookup[b64.charCodeAt(i + 2)] << 6) | revLookup[b64.charCodeAt(i + 3)];
	    arr[L++] = (tmp >> 16) & 0xFF;
	    arr[L++] = (tmp >> 8) & 0xFF;
	    arr[L++] = tmp & 0xFF;
	  }

	  if (placeHolders === 2) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 2) | (revLookup[b64.charCodeAt(i + 1)] >> 4);
	    arr[L++] = tmp & 0xFF;
	  } else if (placeHolders === 1) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 10) | (revLookup[b64.charCodeAt(i + 1)] << 4) | (revLookup[b64.charCodeAt(i + 2)] >> 2);
	    arr[L++] = (tmp >> 8) & 0xFF;
	    arr[L++] = tmp & 0xFF;
	  }

	  return arr
	}

	function tripletToBase64 (num) {
	  return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F]
	}

	function encodeChunk (uint8, start, end) {
	  var tmp;
	  var output = [];
	  for (var i = start; i < end; i += 3) {
	    tmp = (uint8[i] << 16) + (uint8[i + 1] << 8) + (uint8[i + 2]);
	    output.push(tripletToBase64(tmp));
	  }
	  return output.join('')
	}

	function fromByteArray (uint8) {
	  if (!inited) {
	    init();
	  }
	  var tmp;
	  var len = uint8.length;
	  var extraBytes = len % 3; // if we have 1 byte left, pad 2 bytes
	  var output = '';
	  var parts = [];
	  var maxChunkLength = 16383; // must be multiple of 3

	  // go through the array every three bytes, we'll deal with trailing stuff later
	  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
	    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)));
	  }

	  // pad the end with zeros, but make sure to not forget the extra bytes
	  if (extraBytes === 1) {
	    tmp = uint8[len - 1];
	    output += lookup[tmp >> 2];
	    output += lookup[(tmp << 4) & 0x3F];
	    output += '==';
	  } else if (extraBytes === 2) {
	    tmp = (uint8[len - 2] << 8) + (uint8[len - 1]);
	    output += lookup[tmp >> 10];
	    output += lookup[(tmp >> 4) & 0x3F];
	    output += lookup[(tmp << 2) & 0x3F];
	    output += '=';
	  }

	  parts.push(output);

	  return parts.join('')
	}

	function read (buffer, offset, isLE, mLen, nBytes) {
	  var e, m;
	  var eLen = nBytes * 8 - mLen - 1;
	  var eMax = (1 << eLen) - 1;
	  var eBias = eMax >> 1;
	  var nBits = -7;
	  var i = isLE ? (nBytes - 1) : 0;
	  var d = isLE ? -1 : 1;
	  var s = buffer[offset + i];

	  i += d;

	  e = s & ((1 << (-nBits)) - 1);
	  s >>= (-nBits);
	  nBits += eLen;
	  for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}

	  m = e & ((1 << (-nBits)) - 1);
	  e >>= (-nBits);
	  nBits += mLen;
	  for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}

	  if (e === 0) {
	    e = 1 - eBias;
	  } else if (e === eMax) {
	    return m ? NaN : ((s ? -1 : 1) * Infinity)
	  } else {
	    m = m + Math.pow(2, mLen);
	    e = e - eBias;
	  }
	  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
	}

	function write (buffer, value, offset, isLE, mLen, nBytes) {
	  var e, m, c;
	  var eLen = nBytes * 8 - mLen - 1;
	  var eMax = (1 << eLen) - 1;
	  var eBias = eMax >> 1;
	  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0);
	  var i = isLE ? 0 : (nBytes - 1);
	  var d = isLE ? 1 : -1;
	  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0;

	  value = Math.abs(value);

	  if (isNaN(value) || value === Infinity) {
	    m = isNaN(value) ? 1 : 0;
	    e = eMax;
	  } else {
	    e = Math.floor(Math.log(value) / Math.LN2);
	    if (value * (c = Math.pow(2, -e)) < 1) {
	      e--;
	      c *= 2;
	    }
	    if (e + eBias >= 1) {
	      value += rt / c;
	    } else {
	      value += rt * Math.pow(2, 1 - eBias);
	    }
	    if (value * c >= 2) {
	      e++;
	      c /= 2;
	    }

	    if (e + eBias >= eMax) {
	      m = 0;
	      e = eMax;
	    } else if (e + eBias >= 1) {
	      m = (value * c - 1) * Math.pow(2, mLen);
	      e = e + eBias;
	    } else {
	      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
	      e = 0;
	    }
	  }

	  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

	  e = (e << mLen) | m;
	  eLen += mLen;
	  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

	  buffer[offset + i - d] |= s * 128;
	}

	var toString = {}.toString;

	var isArray$2 = Array.isArray || function (arr) {
	  return toString.call(arr) == '[object Array]';
	};

	/*!
	 * The buffer module from node.js, for the browser.
	 *
	 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
	 * @license  MIT
	 */
	/* eslint-disable no-proto */


	var INSPECT_MAX_BYTES = 50;

	/**
	 * If `Buffer.TYPED_ARRAY_SUPPORT`:
	 *   === true    Use Uint8Array implementation (fastest)
	 *   === false   Use Object implementation (most compatible, even IE6)
	 *
	 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
	 * Opera 11.6+, iOS 4.2+.
	 *
	 * Due to various browser bugs, sometimes the Object implementation will be used even
	 * when the browser supports typed arrays.
	 *
	 * Note:
	 *
	 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
	 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
	 *
	 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
	 *
	 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
	 *     incorrect length in some situations.

	 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
	 * get the Object implementation, which is slower but behaves correctly.
	 */
	Buffer$1.TYPED_ARRAY_SUPPORT = global$1.TYPED_ARRAY_SUPPORT !== undefined
	  ? global$1.TYPED_ARRAY_SUPPORT
	  : true;

	/*
	 * Export kMaxLength after typed array support is determined.
	 */
	kMaxLength();

	function kMaxLength () {
	  return Buffer$1.TYPED_ARRAY_SUPPORT
	    ? 0x7fffffff
	    : 0x3fffffff
	}

	function createBuffer (that, length) {
	  if (kMaxLength() < length) {
	    throw new RangeError('Invalid typed array length')
	  }
	  if (Buffer$1.TYPED_ARRAY_SUPPORT) {
	    // Return an augmented `Uint8Array` instance, for best performance
	    that = new Uint8Array(length);
	    that.__proto__ = Buffer$1.prototype;
	  } else {
	    // Fallback: Return an object instance of the Buffer class
	    if (that === null) {
	      that = new Buffer$1(length);
	    }
	    that.length = length;
	  }

	  return that
	}

	/**
	 * The Buffer constructor returns instances of `Uint8Array` that have their
	 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
	 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
	 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
	 * returns a single octet.
	 *
	 * The `Uint8Array` prototype remains unmodified.
	 */

	function Buffer$1 (arg, encodingOrOffset, length) {
	  if (!Buffer$1.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer$1)) {
	    return new Buffer$1(arg, encodingOrOffset, length)
	  }

	  // Common case.
	  if (typeof arg === 'number') {
	    if (typeof encodingOrOffset === 'string') {
	      throw new Error(
	        'If encoding is specified then the first argument must be a string'
	      )
	    }
	    return allocUnsafe(this, arg)
	  }
	  return from(this, arg, encodingOrOffset, length)
	}

	Buffer$1.poolSize = 8192; // not used by this implementation

	// TODO: Legacy, not needed anymore. Remove in next major version.
	Buffer$1._augment = function (arr) {
	  arr.__proto__ = Buffer$1.prototype;
	  return arr
	};

	function from (that, value, encodingOrOffset, length) {
	  if (typeof value === 'number') {
	    throw new TypeError('"value" argument must not be a number')
	  }

	  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
	    return fromArrayBuffer(that, value, encodingOrOffset, length)
	  }

	  if (typeof value === 'string') {
	    return fromString(that, value, encodingOrOffset)
	  }

	  return fromObject(that, value)
	}

	/**
	 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
	 * if value is a number.
	 * Buffer.from(str[, encoding])
	 * Buffer.from(array)
	 * Buffer.from(buffer)
	 * Buffer.from(arrayBuffer[, byteOffset[, length]])
	 **/
	Buffer$1.from = function (value, encodingOrOffset, length) {
	  return from(null, value, encodingOrOffset, length)
	};

	if (Buffer$1.TYPED_ARRAY_SUPPORT) {
	  Buffer$1.prototype.__proto__ = Uint8Array.prototype;
	  Buffer$1.__proto__ = Uint8Array;
	  if (typeof Symbol !== 'undefined' && Symbol.species &&
	      Buffer$1[Symbol.species] === Buffer$1) ;
	}

	function assertSize (size) {
	  if (typeof size !== 'number') {
	    throw new TypeError('"size" argument must be a number')
	  } else if (size < 0) {
	    throw new RangeError('"size" argument must not be negative')
	  }
	}

	function alloc (that, size, fill, encoding) {
	  assertSize(size);
	  if (size <= 0) {
	    return createBuffer(that, size)
	  }
	  if (fill !== undefined) {
	    // Only pay attention to encoding if it's a string. This
	    // prevents accidentally sending in a number that would
	    // be interpretted as a start offset.
	    return typeof encoding === 'string'
	      ? createBuffer(that, size).fill(fill, encoding)
	      : createBuffer(that, size).fill(fill)
	  }
	  return createBuffer(that, size)
	}

	/**
	 * Creates a new filled Buffer instance.
	 * alloc(size[, fill[, encoding]])
	 **/
	Buffer$1.alloc = function (size, fill, encoding) {
	  return alloc(null, size, fill, encoding)
	};

	function allocUnsafe (that, size) {
	  assertSize(size);
	  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0);
	  if (!Buffer$1.TYPED_ARRAY_SUPPORT) {
	    for (var i = 0; i < size; ++i) {
	      that[i] = 0;
	    }
	  }
	  return that
	}

	/**
	 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
	 * */
	Buffer$1.allocUnsafe = function (size) {
	  return allocUnsafe(null, size)
	};
	/**
	 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
	 */
	Buffer$1.allocUnsafeSlow = function (size) {
	  return allocUnsafe(null, size)
	};

	function fromString (that, string, encoding) {
	  if (typeof encoding !== 'string' || encoding === '') {
	    encoding = 'utf8';
	  }

	  if (!Buffer$1.isEncoding(encoding)) {
	    throw new TypeError('"encoding" must be a valid string encoding')
	  }

	  var length = byteLength(string, encoding) | 0;
	  that = createBuffer(that, length);

	  var actual = that.write(string, encoding);

	  if (actual !== length) {
	    // Writing a hex string, for example, that contains invalid characters will
	    // cause everything after the first invalid character to be ignored. (e.g.
	    // 'abxxcd' will be treated as 'ab')
	    that = that.slice(0, actual);
	  }

	  return that
	}

	function fromArrayLike (that, array) {
	  var length = array.length < 0 ? 0 : checked(array.length) | 0;
	  that = createBuffer(that, length);
	  for (var i = 0; i < length; i += 1) {
	    that[i] = array[i] & 255;
	  }
	  return that
	}

	function fromArrayBuffer (that, array, byteOffset, length) {
	  array.byteLength; // this throws if `array` is not a valid ArrayBuffer

	  if (byteOffset < 0 || array.byteLength < byteOffset) {
	    throw new RangeError('\'offset\' is out of bounds')
	  }

	  if (array.byteLength < byteOffset + (length || 0)) {
	    throw new RangeError('\'length\' is out of bounds')
	  }

	  if (byteOffset === undefined && length === undefined) {
	    array = new Uint8Array(array);
	  } else if (length === undefined) {
	    array = new Uint8Array(array, byteOffset);
	  } else {
	    array = new Uint8Array(array, byteOffset, length);
	  }

	  if (Buffer$1.TYPED_ARRAY_SUPPORT) {
	    // Return an augmented `Uint8Array` instance, for best performance
	    that = array;
	    that.__proto__ = Buffer$1.prototype;
	  } else {
	    // Fallback: Return an object instance of the Buffer class
	    that = fromArrayLike(that, array);
	  }
	  return that
	}

	function fromObject (that, obj) {
	  if (internalIsBuffer(obj)) {
	    var len = checked(obj.length) | 0;
	    that = createBuffer(that, len);

	    if (that.length === 0) {
	      return that
	    }

	    obj.copy(that, 0, 0, len);
	    return that
	  }

	  if (obj) {
	    if ((typeof ArrayBuffer !== 'undefined' &&
	        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
	      if (typeof obj.length !== 'number' || isnan(obj.length)) {
	        return createBuffer(that, 0)
	      }
	      return fromArrayLike(that, obj)
	    }

	    if (obj.type === 'Buffer' && isArray$2(obj.data)) {
	      return fromArrayLike(that, obj.data)
	    }
	  }

	  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
	}

	function checked (length) {
	  // Note: cannot use `length < kMaxLength()` here because that fails when
	  // length is NaN (which is otherwise coerced to zero.)
	  if (length >= kMaxLength()) {
	    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
	                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
	  }
	  return length | 0
	}
	Buffer$1.isBuffer = isBuffer;
	function internalIsBuffer (b) {
	  return !!(b != null && b._isBuffer)
	}

	Buffer$1.compare = function compare (a, b) {
	  if (!internalIsBuffer(a) || !internalIsBuffer(b)) {
	    throw new TypeError('Arguments must be Buffers')
	  }

	  if (a === b) return 0

	  var x = a.length;
	  var y = b.length;

	  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
	    if (a[i] !== b[i]) {
	      x = a[i];
	      y = b[i];
	      break
	    }
	  }

	  if (x < y) return -1
	  if (y < x) return 1
	  return 0
	};

	Buffer$1.isEncoding = function isEncoding (encoding) {
	  switch (String(encoding).toLowerCase()) {
	    case 'hex':
	    case 'utf8':
	    case 'utf-8':
	    case 'ascii':
	    case 'latin1':
	    case 'binary':
	    case 'base64':
	    case 'ucs2':
	    case 'ucs-2':
	    case 'utf16le':
	    case 'utf-16le':
	      return true
	    default:
	      return false
	  }
	};

	Buffer$1.concat = function concat (list, length) {
	  if (!isArray$2(list)) {
	    throw new TypeError('"list" argument must be an Array of Buffers')
	  }

	  if (list.length === 0) {
	    return Buffer$1.alloc(0)
	  }

	  var i;
	  if (length === undefined) {
	    length = 0;
	    for (i = 0; i < list.length; ++i) {
	      length += list[i].length;
	    }
	  }

	  var buffer = Buffer$1.allocUnsafe(length);
	  var pos = 0;
	  for (i = 0; i < list.length; ++i) {
	    var buf = list[i];
	    if (!internalIsBuffer(buf)) {
	      throw new TypeError('"list" argument must be an Array of Buffers')
	    }
	    buf.copy(buffer, pos);
	    pos += buf.length;
	  }
	  return buffer
	};

	function byteLength (string, encoding) {
	  if (internalIsBuffer(string)) {
	    return string.length
	  }
	  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
	      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
	    return string.byteLength
	  }
	  if (typeof string !== 'string') {
	    string = '' + string;
	  }

	  var len = string.length;
	  if (len === 0) return 0

	  // Use a for loop to avoid recursion
	  var loweredCase = false;
	  for (;;) {
	    switch (encoding) {
	      case 'ascii':
	      case 'latin1':
	      case 'binary':
	        return len
	      case 'utf8':
	      case 'utf-8':
	      case undefined:
	        return utf8ToBytes(string).length
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return len * 2
	      case 'hex':
	        return len >>> 1
	      case 'base64':
	        return base64ToBytes(string).length
	      default:
	        if (loweredCase) return utf8ToBytes(string).length // assume utf8
	        encoding = ('' + encoding).toLowerCase();
	        loweredCase = true;
	    }
	  }
	}
	Buffer$1.byteLength = byteLength;

	function slowToString (encoding, start, end) {
	  var loweredCase = false;

	  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
	  // property of a typed array.

	  // This behaves neither like String nor Uint8Array in that we set start/end
	  // to their upper/lower bounds if the value passed is out of range.
	  // undefined is handled specially as per ECMA-262 6th Edition,
	  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
	  if (start === undefined || start < 0) {
	    start = 0;
	  }
	  // Return early if start > this.length. Done here to prevent potential uint32
	  // coercion fail below.
	  if (start > this.length) {
	    return ''
	  }

	  if (end === undefined || end > this.length) {
	    end = this.length;
	  }

	  if (end <= 0) {
	    return ''
	  }

	  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
	  end >>>= 0;
	  start >>>= 0;

	  if (end <= start) {
	    return ''
	  }

	  if (!encoding) encoding = 'utf8';

	  while (true) {
	    switch (encoding) {
	      case 'hex':
	        return hexSlice(this, start, end)

	      case 'utf8':
	      case 'utf-8':
	        return utf8Slice(this, start, end)

	      case 'ascii':
	        return asciiSlice(this, start, end)

	      case 'latin1':
	      case 'binary':
	        return latin1Slice(this, start, end)

	      case 'base64':
	        return base64Slice(this, start, end)

	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return utf16leSlice(this, start, end)

	      default:
	        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
	        encoding = (encoding + '').toLowerCase();
	        loweredCase = true;
	    }
	  }
	}

	// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
	// Buffer instances.
	Buffer$1.prototype._isBuffer = true;

	function swap (b, n, m) {
	  var i = b[n];
	  b[n] = b[m];
	  b[m] = i;
	}

	Buffer$1.prototype.swap16 = function swap16 () {
	  var len = this.length;
	  if (len % 2 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 16-bits')
	  }
	  for (var i = 0; i < len; i += 2) {
	    swap(this, i, i + 1);
	  }
	  return this
	};

	Buffer$1.prototype.swap32 = function swap32 () {
	  var len = this.length;
	  if (len % 4 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 32-bits')
	  }
	  for (var i = 0; i < len; i += 4) {
	    swap(this, i, i + 3);
	    swap(this, i + 1, i + 2);
	  }
	  return this
	};

	Buffer$1.prototype.swap64 = function swap64 () {
	  var len = this.length;
	  if (len % 8 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 64-bits')
	  }
	  for (var i = 0; i < len; i += 8) {
	    swap(this, i, i + 7);
	    swap(this, i + 1, i + 6);
	    swap(this, i + 2, i + 5);
	    swap(this, i + 3, i + 4);
	  }
	  return this
	};

	Buffer$1.prototype.toString = function toString () {
	  var length = this.length | 0;
	  if (length === 0) return ''
	  if (arguments.length === 0) return utf8Slice(this, 0, length)
	  return slowToString.apply(this, arguments)
	};

	Buffer$1.prototype.equals = function equals (b) {
	  if (!internalIsBuffer(b)) throw new TypeError('Argument must be a Buffer')
	  if (this === b) return true
	  return Buffer$1.compare(this, b) === 0
	};

	Buffer$1.prototype.inspect = function inspect () {
	  var str = '';
	  var max = INSPECT_MAX_BYTES;
	  if (this.length > 0) {
	    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ');
	    if (this.length > max) str += ' ... ';
	  }
	  return '<Buffer ' + str + '>'
	};

	Buffer$1.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
	  if (!internalIsBuffer(target)) {
	    throw new TypeError('Argument must be a Buffer')
	  }

	  if (start === undefined) {
	    start = 0;
	  }
	  if (end === undefined) {
	    end = target ? target.length : 0;
	  }
	  if (thisStart === undefined) {
	    thisStart = 0;
	  }
	  if (thisEnd === undefined) {
	    thisEnd = this.length;
	  }

	  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
	    throw new RangeError('out of range index')
	  }

	  if (thisStart >= thisEnd && start >= end) {
	    return 0
	  }
	  if (thisStart >= thisEnd) {
	    return -1
	  }
	  if (start >= end) {
	    return 1
	  }

	  start >>>= 0;
	  end >>>= 0;
	  thisStart >>>= 0;
	  thisEnd >>>= 0;

	  if (this === target) return 0

	  var x = thisEnd - thisStart;
	  var y = end - start;
	  var len = Math.min(x, y);

	  var thisCopy = this.slice(thisStart, thisEnd);
	  var targetCopy = target.slice(start, end);

	  for (var i = 0; i < len; ++i) {
	    if (thisCopy[i] !== targetCopy[i]) {
	      x = thisCopy[i];
	      y = targetCopy[i];
	      break
	    }
	  }

	  if (x < y) return -1
	  if (y < x) return 1
	  return 0
	};

	// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
	// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
	//
	// Arguments:
	// - buffer - a Buffer to search
	// - val - a string, Buffer, or number
	// - byteOffset - an index into `buffer`; will be clamped to an int32
	// - encoding - an optional encoding, relevant is val is a string
	// - dir - true for indexOf, false for lastIndexOf
	function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
	  // Empty buffer means no match
	  if (buffer.length === 0) return -1

	  // Normalize byteOffset
	  if (typeof byteOffset === 'string') {
	    encoding = byteOffset;
	    byteOffset = 0;
	  } else if (byteOffset > 0x7fffffff) {
	    byteOffset = 0x7fffffff;
	  } else if (byteOffset < -2147483648) {
	    byteOffset = -2147483648;
	  }
	  byteOffset = +byteOffset;  // Coerce to Number.
	  if (isNaN(byteOffset)) {
	    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
	    byteOffset = dir ? 0 : (buffer.length - 1);
	  }

	  // Normalize byteOffset: negative offsets start from the end of the buffer
	  if (byteOffset < 0) byteOffset = buffer.length + byteOffset;
	  if (byteOffset >= buffer.length) {
	    if (dir) return -1
	    else byteOffset = buffer.length - 1;
	  } else if (byteOffset < 0) {
	    if (dir) byteOffset = 0;
	    else return -1
	  }

	  // Normalize val
	  if (typeof val === 'string') {
	    val = Buffer$1.from(val, encoding);
	  }

	  // Finally, search either indexOf (if dir is true) or lastIndexOf
	  if (internalIsBuffer(val)) {
	    // Special case: looking for empty string/buffer always fails
	    if (val.length === 0) {
	      return -1
	    }
	    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
	  } else if (typeof val === 'number') {
	    val = val & 0xFF; // Search for a byte value [0-255]
	    if (Buffer$1.TYPED_ARRAY_SUPPORT &&
	        typeof Uint8Array.prototype.indexOf === 'function') {
	      if (dir) {
	        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
	      } else {
	        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
	      }
	    }
	    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
	  }

	  throw new TypeError('val must be string, number or Buffer')
	}

	function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
	  var indexSize = 1;
	  var arrLength = arr.length;
	  var valLength = val.length;

	  if (encoding !== undefined) {
	    encoding = String(encoding).toLowerCase();
	    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
	        encoding === 'utf16le' || encoding === 'utf-16le') {
	      if (arr.length < 2 || val.length < 2) {
	        return -1
	      }
	      indexSize = 2;
	      arrLength /= 2;
	      valLength /= 2;
	      byteOffset /= 2;
	    }
	  }

	  function read (buf, i) {
	    if (indexSize === 1) {
	      return buf[i]
	    } else {
	      return buf.readUInt16BE(i * indexSize)
	    }
	  }

	  var i;
	  if (dir) {
	    var foundIndex = -1;
	    for (i = byteOffset; i < arrLength; i++) {
	      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
	        if (foundIndex === -1) foundIndex = i;
	        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
	      } else {
	        if (foundIndex !== -1) i -= i - foundIndex;
	        foundIndex = -1;
	      }
	    }
	  } else {
	    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;
	    for (i = byteOffset; i >= 0; i--) {
	      var found = true;
	      for (var j = 0; j < valLength; j++) {
	        if (read(arr, i + j) !== read(val, j)) {
	          found = false;
	          break
	        }
	      }
	      if (found) return i
	    }
	  }

	  return -1
	}

	Buffer$1.prototype.includes = function includes (val, byteOffset, encoding) {
	  return this.indexOf(val, byteOffset, encoding) !== -1
	};

	Buffer$1.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
	  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
	};

	Buffer$1.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
	  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
	};

	function hexWrite (buf, string, offset, length) {
	  offset = Number(offset) || 0;
	  var remaining = buf.length - offset;
	  if (!length) {
	    length = remaining;
	  } else {
	    length = Number(length);
	    if (length > remaining) {
	      length = remaining;
	    }
	  }

	  // must be an even number of digits
	  var strLen = string.length;
	  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

	  if (length > strLen / 2) {
	    length = strLen / 2;
	  }
	  for (var i = 0; i < length; ++i) {
	    var parsed = parseInt(string.substr(i * 2, 2), 16);
	    if (isNaN(parsed)) return i
	    buf[offset + i] = parsed;
	  }
	  return i
	}

	function utf8Write (buf, string, offset, length) {
	  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
	}

	function asciiWrite (buf, string, offset, length) {
	  return blitBuffer(asciiToBytes(string), buf, offset, length)
	}

	function latin1Write (buf, string, offset, length) {
	  return asciiWrite(buf, string, offset, length)
	}

	function base64Write (buf, string, offset, length) {
	  return blitBuffer(base64ToBytes(string), buf, offset, length)
	}

	function ucs2Write (buf, string, offset, length) {
	  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
	}

	Buffer$1.prototype.write = function write (string, offset, length, encoding) {
	  // Buffer#write(string)
	  if (offset === undefined) {
	    encoding = 'utf8';
	    length = this.length;
	    offset = 0;
	  // Buffer#write(string, encoding)
	  } else if (length === undefined && typeof offset === 'string') {
	    encoding = offset;
	    length = this.length;
	    offset = 0;
	  // Buffer#write(string, offset[, length][, encoding])
	  } else if (isFinite(offset)) {
	    offset = offset | 0;
	    if (isFinite(length)) {
	      length = length | 0;
	      if (encoding === undefined) encoding = 'utf8';
	    } else {
	      encoding = length;
	      length = undefined;
	    }
	  // legacy write(string, encoding, offset, length) - remove in v0.13
	  } else {
	    throw new Error(
	      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
	    )
	  }

	  var remaining = this.length - offset;
	  if (length === undefined || length > remaining) length = remaining;

	  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
	    throw new RangeError('Attempt to write outside buffer bounds')
	  }

	  if (!encoding) encoding = 'utf8';

	  var loweredCase = false;
	  for (;;) {
	    switch (encoding) {
	      case 'hex':
	        return hexWrite(this, string, offset, length)

	      case 'utf8':
	      case 'utf-8':
	        return utf8Write(this, string, offset, length)

	      case 'ascii':
	        return asciiWrite(this, string, offset, length)

	      case 'latin1':
	      case 'binary':
	        return latin1Write(this, string, offset, length)

	      case 'base64':
	        // Warning: maxLength not taken into account in base64Write
	        return base64Write(this, string, offset, length)

	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return ucs2Write(this, string, offset, length)

	      default:
	        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
	        encoding = ('' + encoding).toLowerCase();
	        loweredCase = true;
	    }
	  }
	};

	Buffer$1.prototype.toJSON = function toJSON () {
	  return {
	    type: 'Buffer',
	    data: Array.prototype.slice.call(this._arr || this, 0)
	  }
	};

	function base64Slice (buf, start, end) {
	  if (start === 0 && end === buf.length) {
	    return fromByteArray(buf)
	  } else {
	    return fromByteArray(buf.slice(start, end))
	  }
	}

	function utf8Slice (buf, start, end) {
	  end = Math.min(buf.length, end);
	  var res = [];

	  var i = start;
	  while (i < end) {
	    var firstByte = buf[i];
	    var codePoint = null;
	    var bytesPerSequence = (firstByte > 0xEF) ? 4
	      : (firstByte > 0xDF) ? 3
	      : (firstByte > 0xBF) ? 2
	      : 1;

	    if (i + bytesPerSequence <= end) {
	      var secondByte, thirdByte, fourthByte, tempCodePoint;

	      switch (bytesPerSequence) {
	        case 1:
	          if (firstByte < 0x80) {
	            codePoint = firstByte;
	          }
	          break
	        case 2:
	          secondByte = buf[i + 1];
	          if ((secondByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F);
	            if (tempCodePoint > 0x7F) {
	              codePoint = tempCodePoint;
	            }
	          }
	          break
	        case 3:
	          secondByte = buf[i + 1];
	          thirdByte = buf[i + 2];
	          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F);
	            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
	              codePoint = tempCodePoint;
	            }
	          }
	          break
	        case 4:
	          secondByte = buf[i + 1];
	          thirdByte = buf[i + 2];
	          fourthByte = buf[i + 3];
	          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F);
	            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
	              codePoint = tempCodePoint;
	            }
	          }
	      }
	    }

	    if (codePoint === null) {
	      // we did not generate a valid codePoint so insert a
	      // replacement char (U+FFFD) and advance only 1 byte
	      codePoint = 0xFFFD;
	      bytesPerSequence = 1;
	    } else if (codePoint > 0xFFFF) {
	      // encode to utf16 (surrogate pair dance)
	      codePoint -= 0x10000;
	      res.push(codePoint >>> 10 & 0x3FF | 0xD800);
	      codePoint = 0xDC00 | codePoint & 0x3FF;
	    }

	    res.push(codePoint);
	    i += bytesPerSequence;
	  }

	  return decodeCodePointsArray(res)
	}

	// Based on http://stackoverflow.com/a/22747272/680742, the browser with
	// the lowest limit is Chrome, with 0x10000 args.
	// We go 1 magnitude less, for safety
	var MAX_ARGUMENTS_LENGTH = 0x1000;

	function decodeCodePointsArray (codePoints) {
	  var len = codePoints.length;
	  if (len <= MAX_ARGUMENTS_LENGTH) {
	    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
	  }

	  // Decode in chunks to avoid "call stack size exceeded".
	  var res = '';
	  var i = 0;
	  while (i < len) {
	    res += String.fromCharCode.apply(
	      String,
	      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
	    );
	  }
	  return res
	}

	function asciiSlice (buf, start, end) {
	  var ret = '';
	  end = Math.min(buf.length, end);

	  for (var i = start; i < end; ++i) {
	    ret += String.fromCharCode(buf[i] & 0x7F);
	  }
	  return ret
	}

	function latin1Slice (buf, start, end) {
	  var ret = '';
	  end = Math.min(buf.length, end);

	  for (var i = start; i < end; ++i) {
	    ret += String.fromCharCode(buf[i]);
	  }
	  return ret
	}

	function hexSlice (buf, start, end) {
	  var len = buf.length;

	  if (!start || start < 0) start = 0;
	  if (!end || end < 0 || end > len) end = len;

	  var out = '';
	  for (var i = start; i < end; ++i) {
	    out += toHex(buf[i]);
	  }
	  return out
	}

	function utf16leSlice (buf, start, end) {
	  var bytes = buf.slice(start, end);
	  var res = '';
	  for (var i = 0; i < bytes.length; i += 2) {
	    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256);
	  }
	  return res
	}

	Buffer$1.prototype.slice = function slice (start, end) {
	  var len = this.length;
	  start = ~~start;
	  end = end === undefined ? len : ~~end;

	  if (start < 0) {
	    start += len;
	    if (start < 0) start = 0;
	  } else if (start > len) {
	    start = len;
	  }

	  if (end < 0) {
	    end += len;
	    if (end < 0) end = 0;
	  } else if (end > len) {
	    end = len;
	  }

	  if (end < start) end = start;

	  var newBuf;
	  if (Buffer$1.TYPED_ARRAY_SUPPORT) {
	    newBuf = this.subarray(start, end);
	    newBuf.__proto__ = Buffer$1.prototype;
	  } else {
	    var sliceLen = end - start;
	    newBuf = new Buffer$1(sliceLen, undefined);
	    for (var i = 0; i < sliceLen; ++i) {
	      newBuf[i] = this[i + start];
	    }
	  }

	  return newBuf
	};

	/*
	 * Need to make sure that buffer isn't trying to write out of bounds.
	 */
	function checkOffset (offset, ext, length) {
	  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
	  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
	}

	Buffer$1.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
	  offset = offset | 0;
	  byteLength = byteLength | 0;
	  if (!noAssert) checkOffset(offset, byteLength, this.length);

	  var val = this[offset];
	  var mul = 1;
	  var i = 0;
	  while (++i < byteLength && (mul *= 0x100)) {
	    val += this[offset + i] * mul;
	  }

	  return val
	};

	Buffer$1.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
	  offset = offset | 0;
	  byteLength = byteLength | 0;
	  if (!noAssert) {
	    checkOffset(offset, byteLength, this.length);
	  }

	  var val = this[offset + --byteLength];
	  var mul = 1;
	  while (byteLength > 0 && (mul *= 0x100)) {
	    val += this[offset + --byteLength] * mul;
	  }

	  return val
	};

	Buffer$1.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 1, this.length);
	  return this[offset]
	};

	Buffer$1.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length);
	  return this[offset] | (this[offset + 1] << 8)
	};

	Buffer$1.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length);
	  return (this[offset] << 8) | this[offset + 1]
	};

	Buffer$1.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length);

	  return ((this[offset]) |
	      (this[offset + 1] << 8) |
	      (this[offset + 2] << 16)) +
	      (this[offset + 3] * 0x1000000)
	};

	Buffer$1.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length);

	  return (this[offset] * 0x1000000) +
	    ((this[offset + 1] << 16) |
	    (this[offset + 2] << 8) |
	    this[offset + 3])
	};

	Buffer$1.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
	  offset = offset | 0;
	  byteLength = byteLength | 0;
	  if (!noAssert) checkOffset(offset, byteLength, this.length);

	  var val = this[offset];
	  var mul = 1;
	  var i = 0;
	  while (++i < byteLength && (mul *= 0x100)) {
	    val += this[offset + i] * mul;
	  }
	  mul *= 0x80;

	  if (val >= mul) val -= Math.pow(2, 8 * byteLength);

	  return val
	};

	Buffer$1.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
	  offset = offset | 0;
	  byteLength = byteLength | 0;
	  if (!noAssert) checkOffset(offset, byteLength, this.length);

	  var i = byteLength;
	  var mul = 1;
	  var val = this[offset + --i];
	  while (i > 0 && (mul *= 0x100)) {
	    val += this[offset + --i] * mul;
	  }
	  mul *= 0x80;

	  if (val >= mul) val -= Math.pow(2, 8 * byteLength);

	  return val
	};

	Buffer$1.prototype.readInt8 = function readInt8 (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 1, this.length);
	  if (!(this[offset] & 0x80)) return (this[offset])
	  return ((0xff - this[offset] + 1) * -1)
	};

	Buffer$1.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length);
	  var val = this[offset] | (this[offset + 1] << 8);
	  return (val & 0x8000) ? val | 0xFFFF0000 : val
	};

	Buffer$1.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length);
	  var val = this[offset + 1] | (this[offset] << 8);
	  return (val & 0x8000) ? val | 0xFFFF0000 : val
	};

	Buffer$1.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length);

	  return (this[offset]) |
	    (this[offset + 1] << 8) |
	    (this[offset + 2] << 16) |
	    (this[offset + 3] << 24)
	};

	Buffer$1.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length);

	  return (this[offset] << 24) |
	    (this[offset + 1] << 16) |
	    (this[offset + 2] << 8) |
	    (this[offset + 3])
	};

	Buffer$1.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length);
	  return read(this, offset, true, 23, 4)
	};

	Buffer$1.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length);
	  return read(this, offset, false, 23, 4)
	};

	Buffer$1.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 8, this.length);
	  return read(this, offset, true, 52, 8)
	};

	Buffer$1.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 8, this.length);
	  return read(this, offset, false, 52, 8)
	};

	function checkInt (buf, value, offset, ext, max, min) {
	  if (!internalIsBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
	  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
	  if (offset + ext > buf.length) throw new RangeError('Index out of range')
	}

	Buffer$1.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  byteLength = byteLength | 0;
	  if (!noAssert) {
	    var maxBytes = Math.pow(2, 8 * byteLength) - 1;
	    checkInt(this, value, offset, byteLength, maxBytes, 0);
	  }

	  var mul = 1;
	  var i = 0;
	  this[offset] = value & 0xFF;
	  while (++i < byteLength && (mul *= 0x100)) {
	    this[offset + i] = (value / mul) & 0xFF;
	  }

	  return offset + byteLength
	};

	Buffer$1.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  byteLength = byteLength | 0;
	  if (!noAssert) {
	    var maxBytes = Math.pow(2, 8 * byteLength) - 1;
	    checkInt(this, value, offset, byteLength, maxBytes, 0);
	  }

	  var i = byteLength - 1;
	  var mul = 1;
	  this[offset + i] = value & 0xFF;
	  while (--i >= 0 && (mul *= 0x100)) {
	    this[offset + i] = (value / mul) & 0xFF;
	  }

	  return offset + byteLength
	};

	Buffer$1.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0);
	  if (!Buffer$1.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
	  this[offset] = (value & 0xff);
	  return offset + 1
	};

	function objectWriteUInt16 (buf, value, offset, littleEndian) {
	  if (value < 0) value = 0xffff + value + 1;
	  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
	    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
	      (littleEndian ? i : 1 - i) * 8;
	  }
	}

	Buffer$1.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
	  if (Buffer$1.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff);
	    this[offset + 1] = (value >>> 8);
	  } else {
	    objectWriteUInt16(this, value, offset, true);
	  }
	  return offset + 2
	};

	Buffer$1.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
	  if (Buffer$1.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 8);
	    this[offset + 1] = (value & 0xff);
	  } else {
	    objectWriteUInt16(this, value, offset, false);
	  }
	  return offset + 2
	};

	function objectWriteUInt32 (buf, value, offset, littleEndian) {
	  if (value < 0) value = 0xffffffff + value + 1;
	  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
	    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff;
	  }
	}

	Buffer$1.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
	  if (Buffer$1.TYPED_ARRAY_SUPPORT) {
	    this[offset + 3] = (value >>> 24);
	    this[offset + 2] = (value >>> 16);
	    this[offset + 1] = (value >>> 8);
	    this[offset] = (value & 0xff);
	  } else {
	    objectWriteUInt32(this, value, offset, true);
	  }
	  return offset + 4
	};

	Buffer$1.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
	  if (Buffer$1.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 24);
	    this[offset + 1] = (value >>> 16);
	    this[offset + 2] = (value >>> 8);
	    this[offset + 3] = (value & 0xff);
	  } else {
	    objectWriteUInt32(this, value, offset, false);
	  }
	  return offset + 4
	};

	Buffer$1.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) {
	    var limit = Math.pow(2, 8 * byteLength - 1);

	    checkInt(this, value, offset, byteLength, limit - 1, -limit);
	  }

	  var i = 0;
	  var mul = 1;
	  var sub = 0;
	  this[offset] = value & 0xFF;
	  while (++i < byteLength && (mul *= 0x100)) {
	    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
	      sub = 1;
	    }
	    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
	  }

	  return offset + byteLength
	};

	Buffer$1.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) {
	    var limit = Math.pow(2, 8 * byteLength - 1);

	    checkInt(this, value, offset, byteLength, limit - 1, -limit);
	  }

	  var i = byteLength - 1;
	  var mul = 1;
	  var sub = 0;
	  this[offset + i] = value & 0xFF;
	  while (--i >= 0 && (mul *= 0x100)) {
	    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
	      sub = 1;
	    }
	    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
	  }

	  return offset + byteLength
	};

	Buffer$1.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -128);
	  if (!Buffer$1.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
	  if (value < 0) value = 0xff + value + 1;
	  this[offset] = (value & 0xff);
	  return offset + 1
	};

	Buffer$1.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -32768);
	  if (Buffer$1.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff);
	    this[offset + 1] = (value >>> 8);
	  } else {
	    objectWriteUInt16(this, value, offset, true);
	  }
	  return offset + 2
	};

	Buffer$1.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -32768);
	  if (Buffer$1.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 8);
	    this[offset + 1] = (value & 0xff);
	  } else {
	    objectWriteUInt16(this, value, offset, false);
	  }
	  return offset + 2
	};

	Buffer$1.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -2147483648);
	  if (Buffer$1.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff);
	    this[offset + 1] = (value >>> 8);
	    this[offset + 2] = (value >>> 16);
	    this[offset + 3] = (value >>> 24);
	  } else {
	    objectWriteUInt32(this, value, offset, true);
	  }
	  return offset + 4
	};

	Buffer$1.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
	  value = +value;
	  offset = offset | 0;
	  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -2147483648);
	  if (value < 0) value = 0xffffffff + value + 1;
	  if (Buffer$1.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 24);
	    this[offset + 1] = (value >>> 16);
	    this[offset + 2] = (value >>> 8);
	    this[offset + 3] = (value & 0xff);
	  } else {
	    objectWriteUInt32(this, value, offset, false);
	  }
	  return offset + 4
	};

	function checkIEEE754 (buf, value, offset, ext, max, min) {
	  if (offset + ext > buf.length) throw new RangeError('Index out of range')
	  if (offset < 0) throw new RangeError('Index out of range')
	}

	function writeFloat (buf, value, offset, littleEndian, noAssert) {
	  if (!noAssert) {
	    checkIEEE754(buf, value, offset, 4);
	  }
	  write(buf, value, offset, littleEndian, 23, 4);
	  return offset + 4
	}

	Buffer$1.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
	  return writeFloat(this, value, offset, true, noAssert)
	};

	Buffer$1.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
	  return writeFloat(this, value, offset, false, noAssert)
	};

	function writeDouble (buf, value, offset, littleEndian, noAssert) {
	  if (!noAssert) {
	    checkIEEE754(buf, value, offset, 8);
	  }
	  write(buf, value, offset, littleEndian, 52, 8);
	  return offset + 8
	}

	Buffer$1.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
	  return writeDouble(this, value, offset, true, noAssert)
	};

	Buffer$1.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
	  return writeDouble(this, value, offset, false, noAssert)
	};

	// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
	Buffer$1.prototype.copy = function copy (target, targetStart, start, end) {
	  if (!start) start = 0;
	  if (!end && end !== 0) end = this.length;
	  if (targetStart >= target.length) targetStart = target.length;
	  if (!targetStart) targetStart = 0;
	  if (end > 0 && end < start) end = start;

	  // Copy 0 bytes; we're done
	  if (end === start) return 0
	  if (target.length === 0 || this.length === 0) return 0

	  // Fatal error conditions
	  if (targetStart < 0) {
	    throw new RangeError('targetStart out of bounds')
	  }
	  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
	  if (end < 0) throw new RangeError('sourceEnd out of bounds')

	  // Are we oob?
	  if (end > this.length) end = this.length;
	  if (target.length - targetStart < end - start) {
	    end = target.length - targetStart + start;
	  }

	  var len = end - start;
	  var i;

	  if (this === target && start < targetStart && targetStart < end) {
	    // descending copy from end
	    for (i = len - 1; i >= 0; --i) {
	      target[i + targetStart] = this[i + start];
	    }
	  } else if (len < 1000 || !Buffer$1.TYPED_ARRAY_SUPPORT) {
	    // ascending copy from start
	    for (i = 0; i < len; ++i) {
	      target[i + targetStart] = this[i + start];
	    }
	  } else {
	    Uint8Array.prototype.set.call(
	      target,
	      this.subarray(start, start + len),
	      targetStart
	    );
	  }

	  return len
	};

	// Usage:
	//    buffer.fill(number[, offset[, end]])
	//    buffer.fill(buffer[, offset[, end]])
	//    buffer.fill(string[, offset[, end]][, encoding])
	Buffer$1.prototype.fill = function fill (val, start, end, encoding) {
	  // Handle string cases:
	  if (typeof val === 'string') {
	    if (typeof start === 'string') {
	      encoding = start;
	      start = 0;
	      end = this.length;
	    } else if (typeof end === 'string') {
	      encoding = end;
	      end = this.length;
	    }
	    if (val.length === 1) {
	      var code = val.charCodeAt(0);
	      if (code < 256) {
	        val = code;
	      }
	    }
	    if (encoding !== undefined && typeof encoding !== 'string') {
	      throw new TypeError('encoding must be a string')
	    }
	    if (typeof encoding === 'string' && !Buffer$1.isEncoding(encoding)) {
	      throw new TypeError('Unknown encoding: ' + encoding)
	    }
	  } else if (typeof val === 'number') {
	    val = val & 255;
	  }

	  // Invalid ranges are not set to a default, so can range check early.
	  if (start < 0 || this.length < start || this.length < end) {
	    throw new RangeError('Out of range index')
	  }

	  if (end <= start) {
	    return this
	  }

	  start = start >>> 0;
	  end = end === undefined ? this.length : end >>> 0;

	  if (!val) val = 0;

	  var i;
	  if (typeof val === 'number') {
	    for (i = start; i < end; ++i) {
	      this[i] = val;
	    }
	  } else {
	    var bytes = internalIsBuffer(val)
	      ? val
	      : utf8ToBytes(new Buffer$1(val, encoding).toString());
	    var len = bytes.length;
	    for (i = 0; i < end - start; ++i) {
	      this[i + start] = bytes[i % len];
	    }
	  }

	  return this
	};

	// HELPER FUNCTIONS
	// ================

	var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g;

	function base64clean (str) {
	  // Node strips out invalid characters like \n and \t from the string, base64-js does not
	  str = stringtrim(str).replace(INVALID_BASE64_RE, '');
	  // Node converts strings with length < 2 to ''
	  if (str.length < 2) return ''
	  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
	  while (str.length % 4 !== 0) {
	    str = str + '=';
	  }
	  return str
	}

	function stringtrim (str) {
	  if (str.trim) return str.trim()
	  return str.replace(/^\s+|\s+$/g, '')
	}

	function toHex (n) {
	  if (n < 16) return '0' + n.toString(16)
	  return n.toString(16)
	}

	function utf8ToBytes (string, units) {
	  units = units || Infinity;
	  var codePoint;
	  var length = string.length;
	  var leadSurrogate = null;
	  var bytes = [];

	  for (var i = 0; i < length; ++i) {
	    codePoint = string.charCodeAt(i);

	    // is surrogate component
	    if (codePoint > 0xD7FF && codePoint < 0xE000) {
	      // last char was a lead
	      if (!leadSurrogate) {
	        // no lead yet
	        if (codePoint > 0xDBFF) {
	          // unexpected trail
	          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
	          continue
	        } else if (i + 1 === length) {
	          // unpaired lead
	          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
	          continue
	        }

	        // valid lead
	        leadSurrogate = codePoint;

	        continue
	      }

	      // 2 leads in a row
	      if (codePoint < 0xDC00) {
	        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
	        leadSurrogate = codePoint;
	        continue
	      }

	      // valid surrogate pair
	      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000;
	    } else if (leadSurrogate) {
	      // valid bmp char, but last char was a lead
	      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
	    }

	    leadSurrogate = null;

	    // encode utf8
	    if (codePoint < 0x80) {
	      if ((units -= 1) < 0) break
	      bytes.push(codePoint);
	    } else if (codePoint < 0x800) {
	      if ((units -= 2) < 0) break
	      bytes.push(
	        codePoint >> 0x6 | 0xC0,
	        codePoint & 0x3F | 0x80
	      );
	    } else if (codePoint < 0x10000) {
	      if ((units -= 3) < 0) break
	      bytes.push(
	        codePoint >> 0xC | 0xE0,
	        codePoint >> 0x6 & 0x3F | 0x80,
	        codePoint & 0x3F | 0x80
	      );
	    } else if (codePoint < 0x110000) {
	      if ((units -= 4) < 0) break
	      bytes.push(
	        codePoint >> 0x12 | 0xF0,
	        codePoint >> 0xC & 0x3F | 0x80,
	        codePoint >> 0x6 & 0x3F | 0x80,
	        codePoint & 0x3F | 0x80
	      );
	    } else {
	      throw new Error('Invalid code point')
	    }
	  }

	  return bytes
	}

	function asciiToBytes (str) {
	  var byteArray = [];
	  for (var i = 0; i < str.length; ++i) {
	    // Node's code seems to be doing this and not & 0x7F..
	    byteArray.push(str.charCodeAt(i) & 0xFF);
	  }
	  return byteArray
	}

	function utf16leToBytes (str, units) {
	  var c, hi, lo;
	  var byteArray = [];
	  for (var i = 0; i < str.length; ++i) {
	    if ((units -= 2) < 0) break

	    c = str.charCodeAt(i);
	    hi = c >> 8;
	    lo = c % 256;
	    byteArray.push(lo);
	    byteArray.push(hi);
	  }

	  return byteArray
	}


	function base64ToBytes (str) {
	  return toByteArray(base64clean(str))
	}

	function blitBuffer (src, dst, offset, length) {
	  for (var i = 0; i < length; ++i) {
	    if ((i + offset >= dst.length) || (i >= src.length)) break
	    dst[i + offset] = src[i];
	  }
	  return i
	}

	function isnan (val) {
	  return val !== val // eslint-disable-line no-self-compare
	}


	// the following is from is-buffer, also by Feross Aboukhadijeh and with same lisence
	// The _isBuffer check is for Safari 5-7 support, because it's missing
	// Object.prototype.constructor. Remove this eventually
	function isBuffer(obj) {
	  return obj != null && (!!obj._isBuffer || isFastBuffer(obj) || isSlowBuffer(obj))
	}

	function isFastBuffer (obj) {
	  return !!obj.constructor && typeof obj.constructor.isBuffer === 'function' && obj.constructor.isBuffer(obj)
	}

	// For Node v0.10 support. Remove this eventually.
	function isSlowBuffer (obj) {
	  return typeof obj.readFloatLE === 'function' && typeof obj.slice === 'function' && isFastBuffer(obj.slice(0, 0))
	}

	var hasFetch = isFunction$1(global$1.fetch) && isFunction$1(global$1.ReadableStream);

	var _blobConstructor;
	function blobConstructor() {
	  if (typeof _blobConstructor !== 'undefined') {
	    return _blobConstructor;
	  }
	  try {
	    new global$1.Blob([new ArrayBuffer(1)]);
	    _blobConstructor = true;
	  } catch (e) {
	    _blobConstructor = false;
	  }
	  return _blobConstructor
	}
	var xhr;

	function checkTypeSupport(type) {
	  if (!xhr) {
	    xhr = new global$1.XMLHttpRequest();
	    // If location.host is empty, e.g. if this page/worker was loaded
	    // from a Blob, then use example.com to avoid an error
	    xhr.open('GET', global$1.location.host ? '/' : 'https://example.com');
	  }
	  try {
	    xhr.responseType = type;
	    return xhr.responseType === type
	  } catch (e) {
	    return false
	  }

	}

	// For some strange reason, Safari 7.0 reports typeof global.ArrayBuffer === 'object'.
	// Safari 7.1 appears to have fixed this bug.
	var haveArrayBuffer = typeof global$1.ArrayBuffer !== 'undefined';
	var haveSlice = haveArrayBuffer && isFunction$1(global$1.ArrayBuffer.prototype.slice);

	var arraybuffer = haveArrayBuffer && checkTypeSupport('arraybuffer');
	  // These next two tests unavoidably show warnings in Chrome. Since fetch will always
	  // be used if it's available, just return false for these to avoid the warnings.
	var msstream = !hasFetch && haveSlice && checkTypeSupport('ms-stream');
	var mozchunkedarraybuffer = !hasFetch && haveArrayBuffer &&
	  checkTypeSupport('moz-chunked-arraybuffer');
	var overrideMimeType = isFunction$1(xhr.overrideMimeType);
	var vbArray = isFunction$1(global$1.VBArray);

	function isFunction$1(value) {
	  return typeof value === 'function'
	}

	xhr = null; // Help gc

	var inherits;
	if (typeof Object.create === 'function'){
	  inherits = function inherits(ctor, superCtor) {
	    // implementation from standard node.js 'util' module
	    ctor.super_ = superCtor;
	    ctor.prototype = Object.create(superCtor.prototype, {
	      constructor: {
	        value: ctor,
	        enumerable: false,
	        writable: true,
	        configurable: true
	      }
	    });
	  };
	} else {
	  inherits = function inherits(ctor, superCtor) {
	    ctor.super_ = superCtor;
	    var TempCtor = function () {};
	    TempCtor.prototype = superCtor.prototype;
	    ctor.prototype = new TempCtor();
	    ctor.prototype.constructor = ctor;
	  };
	}

	var formatRegExp = /%[sdj%]/g;
	function format$2(f) {
	  if (!isString(f)) {
	    var objects = [];
	    for (var i = 0; i < arguments.length; i++) {
	      objects.push(inspect(arguments[i]));
	    }
	    return objects.join(' ');
	  }

	  var i = 1;
	  var args = arguments;
	  var len = args.length;
	  var str = String(f).replace(formatRegExp, function(x) {
	    if (x === '%%') return '%';
	    if (i >= len) return x;
	    switch (x) {
	      case '%s': return String(args[i++]);
	      case '%d': return Number(args[i++]);
	      case '%j':
	        try {
	          return JSON.stringify(args[i++]);
	        } catch (_) {
	          return '[Circular]';
	        }
	      default:
	        return x;
	    }
	  });
	  for (var x = args[i]; i < len; x = args[++i]) {
	    if (isNull(x) || !isObject(x)) {
	      str += ' ' + x;
	    } else {
	      str += ' ' + inspect(x);
	    }
	  }
	  return str;
	}

	// Mark that a method should not be used.
	// Returns a modified function which warns once by default.
	// If --no-deprecation is set, then it is a no-op.
	function deprecate(fn, msg) {
	  // Allow for deprecating things in the process of starting up.
	  if (isUndefined(global$1.process)) {
	    return function() {
	      return deprecate(fn, msg).apply(this, arguments);
	    };
	  }

	  if (browser$1.noDeprecation === true) {
	    return fn;
	  }

	  var warned = false;
	  function deprecated() {
	    if (!warned) {
	      if (browser$1.throwDeprecation) {
	        throw new Error(msg);
	      } else if (browser$1.traceDeprecation) {
	        console.trace(msg);
	      } else {
	        console.error(msg);
	      }
	      warned = true;
	    }
	    return fn.apply(this, arguments);
	  }

	  return deprecated;
	}

	var debugs = {};
	var debugEnviron;
	function debuglog(set) {
	  if (isUndefined(debugEnviron))
	    debugEnviron = browser$1.env.NODE_DEBUG || '';
	  set = set.toUpperCase();
	  if (!debugs[set]) {
	    if (new RegExp('\\b' + set + '\\b', 'i').test(debugEnviron)) {
	      var pid = 0;
	      debugs[set] = function() {
	        var msg = format$2.apply(null, arguments);
	        console.error('%s %d: %s', set, pid, msg);
	      };
	    } else {
	      debugs[set] = function() {};
	    }
	  }
	  return debugs[set];
	}

	/**
	 * Echos the value of a value. Trys to print the value out
	 * in the best way possible given the different types.
	 *
	 * @param {Object} obj The object to print out.
	 * @param {Object} opts Optional options object that alters the output.
	 */
	/* legacy: obj, showHidden, depth, colors*/
	function inspect(obj, opts) {
	  // default options
	  var ctx = {
	    seen: [],
	    stylize: stylizeNoColor
	  };
	  // legacy...
	  if (arguments.length >= 3) ctx.depth = arguments[2];
	  if (arguments.length >= 4) ctx.colors = arguments[3];
	  if (isBoolean(opts)) {
	    // legacy...
	    ctx.showHidden = opts;
	  } else if (opts) {
	    // got an "options" object
	    _extend(ctx, opts);
	  }
	  // set default options
	  if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
	  if (isUndefined(ctx.depth)) ctx.depth = 2;
	  if (isUndefined(ctx.colors)) ctx.colors = false;
	  if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
	  if (ctx.colors) ctx.stylize = stylizeWithColor;
	  return formatValue(ctx, obj, ctx.depth);
	}

	// http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
	inspect.colors = {
	  'bold' : [1, 22],
	  'italic' : [3, 23],
	  'underline' : [4, 24],
	  'inverse' : [7, 27],
	  'white' : [37, 39],
	  'grey' : [90, 39],
	  'black' : [30, 39],
	  'blue' : [34, 39],
	  'cyan' : [36, 39],
	  'green' : [32, 39],
	  'magenta' : [35, 39],
	  'red' : [31, 39],
	  'yellow' : [33, 39]
	};

	// Don't use 'blue' not visible on cmd.exe
	inspect.styles = {
	  'special': 'cyan',
	  'number': 'yellow',
	  'boolean': 'yellow',
	  'undefined': 'grey',
	  'null': 'bold',
	  'string': 'green',
	  'date': 'magenta',
	  // "name": intentionally not styling
	  'regexp': 'red'
	};


	function stylizeWithColor(str, styleType) {
	  var style = inspect.styles[styleType];

	  if (style) {
	    return '\u001b[' + inspect.colors[style][0] + 'm' + str +
	           '\u001b[' + inspect.colors[style][1] + 'm';
	  } else {
	    return str;
	  }
	}


	function stylizeNoColor(str, styleType) {
	  return str;
	}


	function arrayToHash(array) {
	  var hash = {};

	  array.forEach(function(val, idx) {
	    hash[val] = true;
	  });

	  return hash;
	}


	function formatValue(ctx, value, recurseTimes) {
	  // Provide a hook for user-specified inspect functions.
	  // Check that value is an object with an inspect function on it
	  if (ctx.customInspect &&
	      value &&
	      isFunction(value.inspect) &&
	      // Filter out the util module, it's inspect function is special
	      value.inspect !== inspect &&
	      // Also filter out any prototype objects using the circular check.
	      !(value.constructor && value.constructor.prototype === value)) {
	    var ret = value.inspect(recurseTimes, ctx);
	    if (!isString(ret)) {
	      ret = formatValue(ctx, ret, recurseTimes);
	    }
	    return ret;
	  }

	  // Primitive types cannot have properties
	  var primitive = formatPrimitive(ctx, value);
	  if (primitive) {
	    return primitive;
	  }

	  // Look up the keys of the object.
	  var keys = Object.keys(value);
	  var visibleKeys = arrayToHash(keys);

	  if (ctx.showHidden) {
	    keys = Object.getOwnPropertyNames(value);
	  }

	  // IE doesn't make error fields non-enumerable
	  // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
	  if (isError(value)
	      && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
	    return formatError(value);
	  }

	  // Some type of object without properties can be shortcutted.
	  if (keys.length === 0) {
	    if (isFunction(value)) {
	      var name = value.name ? ': ' + value.name : '';
	      return ctx.stylize('[Function' + name + ']', 'special');
	    }
	    if (isRegExp(value)) {
	      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
	    }
	    if (isDate(value)) {
	      return ctx.stylize(Date.prototype.toString.call(value), 'date');
	    }
	    if (isError(value)) {
	      return formatError(value);
	    }
	  }

	  var base = '', array = false, braces = ['{', '}'];

	  // Make Array say that they are Array
	  if (isArray$1(value)) {
	    array = true;
	    braces = ['[', ']'];
	  }

	  // Make functions say that they are functions
	  if (isFunction(value)) {
	    var n = value.name ? ': ' + value.name : '';
	    base = ' [Function' + n + ']';
	  }

	  // Make RegExps say that they are RegExps
	  if (isRegExp(value)) {
	    base = ' ' + RegExp.prototype.toString.call(value);
	  }

	  // Make dates with properties first say the date
	  if (isDate(value)) {
	    base = ' ' + Date.prototype.toUTCString.call(value);
	  }

	  // Make error with message first say the error
	  if (isError(value)) {
	    base = ' ' + formatError(value);
	  }

	  if (keys.length === 0 && (!array || value.length == 0)) {
	    return braces[0] + base + braces[1];
	  }

	  if (recurseTimes < 0) {
	    if (isRegExp(value)) {
	      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
	    } else {
	      return ctx.stylize('[Object]', 'special');
	    }
	  }

	  ctx.seen.push(value);

	  var output;
	  if (array) {
	    output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
	  } else {
	    output = keys.map(function(key) {
	      return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
	    });
	  }

	  ctx.seen.pop();

	  return reduceToSingleString(output, base, braces);
	}


	function formatPrimitive(ctx, value) {
	  if (isUndefined(value))
	    return ctx.stylize('undefined', 'undefined');
	  if (isString(value)) {
	    var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
	                                             .replace(/'/g, "\\'")
	                                             .replace(/\\"/g, '"') + '\'';
	    return ctx.stylize(simple, 'string');
	  }
	  if (isNumber$1(value))
	    return ctx.stylize('' + value, 'number');
	  if (isBoolean(value))
	    return ctx.stylize('' + value, 'boolean');
	  // For some reason typeof null is "object", so special case here.
	  if (isNull(value))
	    return ctx.stylize('null', 'null');
	}


	function formatError(value) {
	  return '[' + Error.prototype.toString.call(value) + ']';
	}


	function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
	  var output = [];
	  for (var i = 0, l = value.length; i < l; ++i) {
	    if (hasOwnProperty$1(value, String(i))) {
	      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
	          String(i), true));
	    } else {
	      output.push('');
	    }
	  }
	  keys.forEach(function(key) {
	    if (!key.match(/^\d+$/)) {
	      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
	          key, true));
	    }
	  });
	  return output;
	}


	function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
	  var name, str, desc;
	  desc = Object.getOwnPropertyDescriptor(value, key) || { value: value[key] };
	  if (desc.get) {
	    if (desc.set) {
	      str = ctx.stylize('[Getter/Setter]', 'special');
	    } else {
	      str = ctx.stylize('[Getter]', 'special');
	    }
	  } else {
	    if (desc.set) {
	      str = ctx.stylize('[Setter]', 'special');
	    }
	  }
	  if (!hasOwnProperty$1(visibleKeys, key)) {
	    name = '[' + key + ']';
	  }
	  if (!str) {
	    if (ctx.seen.indexOf(desc.value) < 0) {
	      if (isNull(recurseTimes)) {
	        str = formatValue(ctx, desc.value, null);
	      } else {
	        str = formatValue(ctx, desc.value, recurseTimes - 1);
	      }
	      if (str.indexOf('\n') > -1) {
	        if (array) {
	          str = str.split('\n').map(function(line) {
	            return '  ' + line;
	          }).join('\n').substr(2);
	        } else {
	          str = '\n' + str.split('\n').map(function(line) {
	            return '   ' + line;
	          }).join('\n');
	        }
	      }
	    } else {
	      str = ctx.stylize('[Circular]', 'special');
	    }
	  }
	  if (isUndefined(name)) {
	    if (array && key.match(/^\d+$/)) {
	      return str;
	    }
	    name = JSON.stringify('' + key);
	    if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
	      name = name.substr(1, name.length - 2);
	      name = ctx.stylize(name, 'name');
	    } else {
	      name = name.replace(/'/g, "\\'")
	                 .replace(/\\"/g, '"')
	                 .replace(/(^"|"$)/g, "'");
	      name = ctx.stylize(name, 'string');
	    }
	  }

	  return name + ': ' + str;
	}


	function reduceToSingleString(output, base, braces) {
	  var length = output.reduce(function(prev, cur) {
	    if (cur.indexOf('\n') >= 0) ;
	    return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
	  }, 0);

	  if (length > 60) {
	    return braces[0] +
	           (base === '' ? '' : base + '\n ') +
	           ' ' +
	           output.join(',\n  ') +
	           ' ' +
	           braces[1];
	  }

	  return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
	}


	// NOTE: These type checking functions intentionally don't use `instanceof`
	// because it is fragile and can be easily faked with `Object.create()`.
	function isArray$1(ar) {
	  return Array.isArray(ar);
	}

	function isBoolean(arg) {
	  return typeof arg === 'boolean';
	}

	function isNull(arg) {
	  return arg === null;
	}

	function isNullOrUndefined(arg) {
	  return arg == null;
	}

	function isNumber$1(arg) {
	  return typeof arg === 'number';
	}

	function isString(arg) {
	  return typeof arg === 'string';
	}

	function isUndefined(arg) {
	  return arg === void 0;
	}

	function isRegExp(re) {
	  return isObject(re) && objectToString(re) === '[object RegExp]';
	}

	function isObject(arg) {
	  return typeof arg === 'object' && arg !== null;
	}

	function isDate(d) {
	  return isObject(d) && objectToString(d) === '[object Date]';
	}

	function isError(e) {
	  return isObject(e) &&
	      (objectToString(e) === '[object Error]' || e instanceof Error);
	}

	function isFunction(arg) {
	  return typeof arg === 'function';
	}

	function objectToString(o) {
	  return Object.prototype.toString.call(o);
	}

	function _extend(origin, add) {
	  // Don't do anything if add isn't an object
	  if (!add || !isObject(add)) return origin;

	  var keys = Object.keys(add);
	  var i = keys.length;
	  while (i--) {
	    origin[keys[i]] = add[keys[i]];
	  }
	  return origin;
	}
	function hasOwnProperty$1(obj, prop) {
	  return Object.prototype.hasOwnProperty.call(obj, prop);
	}

	var domain;

	// This constructor is used to store event handlers. Instantiating this is
	// faster than explicitly calling `Object.create(null)` to get a "clean" empty
	// object (tested with v8 v4.9).
	function EventHandlers() {}
	EventHandlers.prototype = Object.create(null);

	function EventEmitter() {
	  EventEmitter.init.call(this);
	}

	// nodejs oddity
	// require('events') === require('events').EventEmitter
	EventEmitter.EventEmitter = EventEmitter;

	EventEmitter.usingDomains = false;

	EventEmitter.prototype.domain = undefined;
	EventEmitter.prototype._events = undefined;
	EventEmitter.prototype._maxListeners = undefined;

	// By default EventEmitters will print a warning if more than 10 listeners are
	// added to it. This is a useful default which helps finding memory leaks.
	EventEmitter.defaultMaxListeners = 10;

	EventEmitter.init = function() {
	  this.domain = null;
	  if (EventEmitter.usingDomains) {
	    // if there is an active domain, then attach to it.
	    if (domain.active && !(this instanceof domain.Domain)) {
	      this.domain = domain.active;
	    }
	  }

	  if (!this._events || this._events === Object.getPrototypeOf(this)._events) {
	    this._events = new EventHandlers();
	    this._eventsCount = 0;
	  }

	  this._maxListeners = this._maxListeners || undefined;
	};

	// Obviously not all Emitters should be limited to 10. This function allows
	// that to be increased. Set to zero for unlimited.
	EventEmitter.prototype.setMaxListeners = function setMaxListeners(n) {
	  if (typeof n !== 'number' || n < 0 || isNaN(n))
	    throw new TypeError('"n" argument must be a positive number');
	  this._maxListeners = n;
	  return this;
	};

	function $getMaxListeners(that) {
	  if (that._maxListeners === undefined)
	    return EventEmitter.defaultMaxListeners;
	  return that._maxListeners;
	}

	EventEmitter.prototype.getMaxListeners = function getMaxListeners() {
	  return $getMaxListeners(this);
	};

	// These standalone emit* functions are used to optimize calling of event
	// handlers for fast cases because emit() itself often has a variable number of
	// arguments and can be deoptimized because of that. These functions always have
	// the same number of arguments and thus do not get deoptimized, so the code
	// inside them can execute faster.
	function emitNone(handler, isFn, self) {
	  if (isFn)
	    handler.call(self);
	  else {
	    var len = handler.length;
	    var listeners = arrayClone(handler, len);
	    for (var i = 0; i < len; ++i)
	      listeners[i].call(self);
	  }
	}
	function emitOne(handler, isFn, self, arg1) {
	  if (isFn)
	    handler.call(self, arg1);
	  else {
	    var len = handler.length;
	    var listeners = arrayClone(handler, len);
	    for (var i = 0; i < len; ++i)
	      listeners[i].call(self, arg1);
	  }
	}
	function emitTwo(handler, isFn, self, arg1, arg2) {
	  if (isFn)
	    handler.call(self, arg1, arg2);
	  else {
	    var len = handler.length;
	    var listeners = arrayClone(handler, len);
	    for (var i = 0; i < len; ++i)
	      listeners[i].call(self, arg1, arg2);
	  }
	}
	function emitThree(handler, isFn, self, arg1, arg2, arg3) {
	  if (isFn)
	    handler.call(self, arg1, arg2, arg3);
	  else {
	    var len = handler.length;
	    var listeners = arrayClone(handler, len);
	    for (var i = 0; i < len; ++i)
	      listeners[i].call(self, arg1, arg2, arg3);
	  }
	}

	function emitMany(handler, isFn, self, args) {
	  if (isFn)
	    handler.apply(self, args);
	  else {
	    var len = handler.length;
	    var listeners = arrayClone(handler, len);
	    for (var i = 0; i < len; ++i)
	      listeners[i].apply(self, args);
	  }
	}

	EventEmitter.prototype.emit = function emit(type) {
	  var er, handler, len, args, i, events, domain;
	  var doError = (type === 'error');

	  events = this._events;
	  if (events)
	    doError = (doError && events.error == null);
	  else if (!doError)
	    return false;

	  domain = this.domain;

	  // If there is no 'error' event listener then throw.
	  if (doError) {
	    er = arguments[1];
	    if (domain) {
	      if (!er)
	        er = new Error('Uncaught, unspecified "error" event');
	      er.domainEmitter = this;
	      er.domain = domain;
	      er.domainThrown = false;
	      domain.emit('error', er);
	    } else if (er instanceof Error) {
	      throw er; // Unhandled 'error' event
	    } else {
	      // At least give some kind of context to the user
	      var err = new Error('Uncaught, unspecified "error" event. (' + er + ')');
	      err.context = er;
	      throw err;
	    }
	    return false;
	  }

	  handler = events[type];

	  if (!handler)
	    return false;

	  var isFn = typeof handler === 'function';
	  len = arguments.length;
	  switch (len) {
	    // fast cases
	    case 1:
	      emitNone(handler, isFn, this);
	      break;
	    case 2:
	      emitOne(handler, isFn, this, arguments[1]);
	      break;
	    case 3:
	      emitTwo(handler, isFn, this, arguments[1], arguments[2]);
	      break;
	    case 4:
	      emitThree(handler, isFn, this, arguments[1], arguments[2], arguments[3]);
	      break;
	    // slower
	    default:
	      args = new Array(len - 1);
	      for (i = 1; i < len; i++)
	        args[i - 1] = arguments[i];
	      emitMany(handler, isFn, this, args);
	  }

	  return true;
	};

	function _addListener(target, type, listener, prepend) {
	  var m;
	  var events;
	  var existing;

	  if (typeof listener !== 'function')
	    throw new TypeError('"listener" argument must be a function');

	  events = target._events;
	  if (!events) {
	    events = target._events = new EventHandlers();
	    target._eventsCount = 0;
	  } else {
	    // To avoid recursion in the case that type === "newListener"! Before
	    // adding it to the listeners, first emit "newListener".
	    if (events.newListener) {
	      target.emit('newListener', type,
	                  listener.listener ? listener.listener : listener);

	      // Re-assign `events` because a newListener handler could have caused the
	      // this._events to be assigned to a new object
	      events = target._events;
	    }
	    existing = events[type];
	  }

	  if (!existing) {
	    // Optimize the case of one listener. Don't need the extra array object.
	    existing = events[type] = listener;
	    ++target._eventsCount;
	  } else {
	    if (typeof existing === 'function') {
	      // Adding the second element, need to change to array.
	      existing = events[type] = prepend ? [listener, existing] :
	                                          [existing, listener];
	    } else {
	      // If we've already got an array, just append.
	      if (prepend) {
	        existing.unshift(listener);
	      } else {
	        existing.push(listener);
	      }
	    }

	    // Check for listener leak
	    if (!existing.warned) {
	      m = $getMaxListeners(target);
	      if (m && m > 0 && existing.length > m) {
	        existing.warned = true;
	        var w = new Error('Possible EventEmitter memory leak detected. ' +
	                            existing.length + ' ' + type + ' listeners added. ' +
	                            'Use emitter.setMaxListeners() to increase limit');
	        w.name = 'MaxListenersExceededWarning';
	        w.emitter = target;
	        w.type = type;
	        w.count = existing.length;
	        emitWarning(w);
	      }
	    }
	  }

	  return target;
	}
	function emitWarning(e) {
	  typeof console.warn === 'function' ? console.warn(e) : console.log(e);
	}
	EventEmitter.prototype.addListener = function addListener(type, listener) {
	  return _addListener(this, type, listener, false);
	};

	EventEmitter.prototype.on = EventEmitter.prototype.addListener;

	EventEmitter.prototype.prependListener =
	    function prependListener(type, listener) {
	      return _addListener(this, type, listener, true);
	    };

	function _onceWrap(target, type, listener) {
	  var fired = false;
	  function g() {
	    target.removeListener(type, g);
	    if (!fired) {
	      fired = true;
	      listener.apply(target, arguments);
	    }
	  }
	  g.listener = listener;
	  return g;
	}

	EventEmitter.prototype.once = function once(type, listener) {
	  if (typeof listener !== 'function')
	    throw new TypeError('"listener" argument must be a function');
	  this.on(type, _onceWrap(this, type, listener));
	  return this;
	};

	EventEmitter.prototype.prependOnceListener =
	    function prependOnceListener(type, listener) {
	      if (typeof listener !== 'function')
	        throw new TypeError('"listener" argument must be a function');
	      this.prependListener(type, _onceWrap(this, type, listener));
	      return this;
	    };

	// emits a 'removeListener' event iff the listener was removed
	EventEmitter.prototype.removeListener =
	    function removeListener(type, listener) {
	      var list, events, position, i, originalListener;

	      if (typeof listener !== 'function')
	        throw new TypeError('"listener" argument must be a function');

	      events = this._events;
	      if (!events)
	        return this;

	      list = events[type];
	      if (!list)
	        return this;

	      if (list === listener || (list.listener && list.listener === listener)) {
	        if (--this._eventsCount === 0)
	          this._events = new EventHandlers();
	        else {
	          delete events[type];
	          if (events.removeListener)
	            this.emit('removeListener', type, list.listener || listener);
	        }
	      } else if (typeof list !== 'function') {
	        position = -1;

	        for (i = list.length; i-- > 0;) {
	          if (list[i] === listener ||
	              (list[i].listener && list[i].listener === listener)) {
	            originalListener = list[i].listener;
	            position = i;
	            break;
	          }
	        }

	        if (position < 0)
	          return this;

	        if (list.length === 1) {
	          list[0] = undefined;
	          if (--this._eventsCount === 0) {
	            this._events = new EventHandlers();
	            return this;
	          } else {
	            delete events[type];
	          }
	        } else {
	          spliceOne(list, position);
	        }

	        if (events.removeListener)
	          this.emit('removeListener', type, originalListener || listener);
	      }

	      return this;
	    };
	    
	// Alias for removeListener added in NodeJS 10.0
	// https://nodejs.org/api/events.html#events_emitter_off_eventname_listener
	EventEmitter.prototype.off = function(type, listener){
	    return this.removeListener(type, listener);
	};

	EventEmitter.prototype.removeAllListeners =
	    function removeAllListeners(type) {
	      var listeners, events;

	      events = this._events;
	      if (!events)
	        return this;

	      // not listening for removeListener, no need to emit
	      if (!events.removeListener) {
	        if (arguments.length === 0) {
	          this._events = new EventHandlers();
	          this._eventsCount = 0;
	        } else if (events[type]) {
	          if (--this._eventsCount === 0)
	            this._events = new EventHandlers();
	          else
	            delete events[type];
	        }
	        return this;
	      }

	      // emit removeListener for all listeners on all events
	      if (arguments.length === 0) {
	        var keys = Object.keys(events);
	        for (var i = 0, key; i < keys.length; ++i) {
	          key = keys[i];
	          if (key === 'removeListener') continue;
	          this.removeAllListeners(key);
	        }
	        this.removeAllListeners('removeListener');
	        this._events = new EventHandlers();
	        this._eventsCount = 0;
	        return this;
	      }

	      listeners = events[type];

	      if (typeof listeners === 'function') {
	        this.removeListener(type, listeners);
	      } else if (listeners) {
	        // LIFO order
	        do {
	          this.removeListener(type, listeners[listeners.length - 1]);
	        } while (listeners[0]);
	      }

	      return this;
	    };

	EventEmitter.prototype.listeners = function listeners(type) {
	  var evlistener;
	  var ret;
	  var events = this._events;

	  if (!events)
	    ret = [];
	  else {
	    evlistener = events[type];
	    if (!evlistener)
	      ret = [];
	    else if (typeof evlistener === 'function')
	      ret = [evlistener.listener || evlistener];
	    else
	      ret = unwrapListeners(evlistener);
	  }

	  return ret;
	};

	EventEmitter.listenerCount = function(emitter, type) {
	  if (typeof emitter.listenerCount === 'function') {
	    return emitter.listenerCount(type);
	  } else {
	    return listenerCount$1.call(emitter, type);
	  }
	};

	EventEmitter.prototype.listenerCount = listenerCount$1;
	function listenerCount$1(type) {
	  var events = this._events;

	  if (events) {
	    var evlistener = events[type];

	    if (typeof evlistener === 'function') {
	      return 1;
	    } else if (evlistener) {
	      return evlistener.length;
	    }
	  }

	  return 0;
	}

	EventEmitter.prototype.eventNames = function eventNames() {
	  return this._eventsCount > 0 ? Reflect.ownKeys(this._events) : [];
	};

	// About 1.5x faster than the two-arg version of Array#splice().
	function spliceOne(list, index) {
	  for (var i = index, k = i + 1, n = list.length; k < n; i += 1, k += 1)
	    list[i] = list[k];
	  list.pop();
	}

	function arrayClone(arr, i) {
	  var copy = new Array(i);
	  while (i--)
	    copy[i] = arr[i];
	  return copy;
	}

	function unwrapListeners(arr) {
	  var ret = new Array(arr.length);
	  for (var i = 0; i < ret.length; ++i) {
	    ret[i] = arr[i].listener || arr[i];
	  }
	  return ret;
	}

	function BufferList() {
	  this.head = null;
	  this.tail = null;
	  this.length = 0;
	}

	BufferList.prototype.push = function (v) {
	  var entry = { data: v, next: null };
	  if (this.length > 0) this.tail.next = entry;else this.head = entry;
	  this.tail = entry;
	  ++this.length;
	};

	BufferList.prototype.unshift = function (v) {
	  var entry = { data: v, next: this.head };
	  if (this.length === 0) this.tail = entry;
	  this.head = entry;
	  ++this.length;
	};

	BufferList.prototype.shift = function () {
	  if (this.length === 0) return;
	  var ret = this.head.data;
	  if (this.length === 1) this.head = this.tail = null;else this.head = this.head.next;
	  --this.length;
	  return ret;
	};

	BufferList.prototype.clear = function () {
	  this.head = this.tail = null;
	  this.length = 0;
	};

	BufferList.prototype.join = function (s) {
	  if (this.length === 0) return '';
	  var p = this.head;
	  var ret = '' + p.data;
	  while (p = p.next) {
	    ret += s + p.data;
	  }return ret;
	};

	BufferList.prototype.concat = function (n) {
	  if (this.length === 0) return Buffer$1.alloc(0);
	  if (this.length === 1) return this.head.data;
	  var ret = Buffer$1.allocUnsafe(n >>> 0);
	  var p = this.head;
	  var i = 0;
	  while (p) {
	    p.data.copy(ret, i);
	    i += p.data.length;
	    p = p.next;
	  }
	  return ret;
	};

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	var isBufferEncoding = Buffer$1.isEncoding
	  || function(encoding) {
	       switch (encoding && encoding.toLowerCase()) {
	         case 'hex': case 'utf8': case 'utf-8': case 'ascii': case 'binary': case 'base64': case 'ucs2': case 'ucs-2': case 'utf16le': case 'utf-16le': case 'raw': return true;
	         default: return false;
	       }
	     };


	function assertEncoding(encoding) {
	  if (encoding && !isBufferEncoding(encoding)) {
	    throw new Error('Unknown encoding: ' + encoding);
	  }
	}

	// StringDecoder provides an interface for efficiently splitting a series of
	// buffers into a series of JS strings without breaking apart multi-byte
	// characters. CESU-8 is handled as part of the UTF-8 encoding.
	//
	// @TODO Handling all encodings inside a single object makes it very difficult
	// to reason about this code, so it should be split up in the future.
	// @TODO There should be a utf8-strict encoding that rejects invalid UTF-8 code
	// points as used by CESU-8.
	function StringDecoder(encoding) {
	  this.encoding = (encoding || 'utf8').toLowerCase().replace(/[-_]/, '');
	  assertEncoding(encoding);
	  switch (this.encoding) {
	    case 'utf8':
	      // CESU-8 represents each of Surrogate Pair by 3-bytes
	      this.surrogateSize = 3;
	      break;
	    case 'ucs2':
	    case 'utf16le':
	      // UTF-16 represents each of Surrogate Pair by 2-bytes
	      this.surrogateSize = 2;
	      this.detectIncompleteChar = utf16DetectIncompleteChar;
	      break;
	    case 'base64':
	      // Base-64 stores 3 bytes in 4 chars, and pads the remainder.
	      this.surrogateSize = 3;
	      this.detectIncompleteChar = base64DetectIncompleteChar;
	      break;
	    default:
	      this.write = passThroughWrite;
	      return;
	  }

	  // Enough space to store all bytes of a single character. UTF-8 needs 4
	  // bytes, but CESU-8 may require up to 6 (3 bytes per surrogate).
	  this.charBuffer = new Buffer$1(6);
	  // Number of bytes received for the current incomplete multi-byte character.
	  this.charReceived = 0;
	  // Number of bytes expected for the current incomplete multi-byte character.
	  this.charLength = 0;
	}

	// write decodes the given buffer and returns it as JS string that is
	// guaranteed to not contain any partial multi-byte characters. Any partial
	// character found at the end of the buffer is buffered up, and will be
	// returned when calling write again with the remaining bytes.
	//
	// Note: Converting a Buffer containing an orphan surrogate to a String
	// currently works, but converting a String to a Buffer (via `new Buffer`, or
	// Buffer#write) will replace incomplete surrogates with the unicode
	// replacement character. See https://codereview.chromium.org/121173009/ .
	StringDecoder.prototype.write = function(buffer) {
	  var charStr = '';
	  // if our last write ended with an incomplete multibyte character
	  while (this.charLength) {
	    // determine how many remaining bytes this buffer has to offer for this char
	    var available = (buffer.length >= this.charLength - this.charReceived) ?
	        this.charLength - this.charReceived :
	        buffer.length;

	    // add the new bytes to the char buffer
	    buffer.copy(this.charBuffer, this.charReceived, 0, available);
	    this.charReceived += available;

	    if (this.charReceived < this.charLength) {
	      // still not enough chars in this buffer? wait for more ...
	      return '';
	    }

	    // remove bytes belonging to the current character from the buffer
	    buffer = buffer.slice(available, buffer.length);

	    // get the character that was split
	    charStr = this.charBuffer.slice(0, this.charLength).toString(this.encoding);

	    // CESU-8: lead surrogate (D800-DBFF) is also the incomplete character
	    var charCode = charStr.charCodeAt(charStr.length - 1);
	    if (charCode >= 0xD800 && charCode <= 0xDBFF) {
	      this.charLength += this.surrogateSize;
	      charStr = '';
	      continue;
	    }
	    this.charReceived = this.charLength = 0;

	    // if there are no more bytes in this buffer, just emit our char
	    if (buffer.length === 0) {
	      return charStr;
	    }
	    break;
	  }

	  // determine and set charLength / charReceived
	  this.detectIncompleteChar(buffer);

	  var end = buffer.length;
	  if (this.charLength) {
	    // buffer the incomplete character bytes we got
	    buffer.copy(this.charBuffer, 0, buffer.length - this.charReceived, end);
	    end -= this.charReceived;
	  }

	  charStr += buffer.toString(this.encoding, 0, end);

	  var end = charStr.length - 1;
	  var charCode = charStr.charCodeAt(end);
	  // CESU-8: lead surrogate (D800-DBFF) is also the incomplete character
	  if (charCode >= 0xD800 && charCode <= 0xDBFF) {
	    var size = this.surrogateSize;
	    this.charLength += size;
	    this.charReceived += size;
	    this.charBuffer.copy(this.charBuffer, size, 0, size);
	    buffer.copy(this.charBuffer, 0, 0, size);
	    return charStr.substring(0, end);
	  }

	  // or just emit the charStr
	  return charStr;
	};

	// detectIncompleteChar determines if there is an incomplete UTF-8 character at
	// the end of the given buffer. If so, it sets this.charLength to the byte
	// length that character, and sets this.charReceived to the number of bytes
	// that are available for this character.
	StringDecoder.prototype.detectIncompleteChar = function(buffer) {
	  // determine how many bytes we have to check at the end of this buffer
	  var i = (buffer.length >= 3) ? 3 : buffer.length;

	  // Figure out if one of the last i bytes of our buffer announces an
	  // incomplete char.
	  for (; i > 0; i--) {
	    var c = buffer[buffer.length - i];

	    // See http://en.wikipedia.org/wiki/UTF-8#Description

	    // 110XXXXX
	    if (i == 1 && c >> 5 == 0x06) {
	      this.charLength = 2;
	      break;
	    }

	    // 1110XXXX
	    if (i <= 2 && c >> 4 == 0x0E) {
	      this.charLength = 3;
	      break;
	    }

	    // 11110XXX
	    if (i <= 3 && c >> 3 == 0x1E) {
	      this.charLength = 4;
	      break;
	    }
	  }
	  this.charReceived = i;
	};

	StringDecoder.prototype.end = function(buffer) {
	  var res = '';
	  if (buffer && buffer.length)
	    res = this.write(buffer);

	  if (this.charReceived) {
	    var cr = this.charReceived;
	    var buf = this.charBuffer;
	    var enc = this.encoding;
	    res += buf.slice(0, cr).toString(enc);
	  }

	  return res;
	};

	function passThroughWrite(buffer) {
	  return buffer.toString(this.encoding);
	}

	function utf16DetectIncompleteChar(buffer) {
	  this.charReceived = buffer.length % 2;
	  this.charLength = this.charReceived ? 2 : 0;
	}

	function base64DetectIncompleteChar(buffer) {
	  this.charReceived = buffer.length % 3;
	  this.charLength = this.charReceived ? 3 : 0;
	}

	Readable.ReadableState = ReadableState;

	var debug = debuglog('stream');
	inherits(Readable, EventEmitter);

	function prependListener(emitter, event, fn) {
	  // Sadly this is not cacheable as some libraries bundle their own
	  // event emitter implementation with them.
	  if (typeof emitter.prependListener === 'function') {
	    return emitter.prependListener(event, fn);
	  } else {
	    // This is a hack to make sure that our error handler is attached before any
	    // userland ones.  NEVER DO THIS. This is here only because this code needs
	    // to continue to work with older versions of Node.js that do not include
	    // the prependListener() method. The goal is to eventually remove this hack.
	    if (!emitter._events || !emitter._events[event])
	      emitter.on(event, fn);
	    else if (Array.isArray(emitter._events[event]))
	      emitter._events[event].unshift(fn);
	    else
	      emitter._events[event] = [fn, emitter._events[event]];
	  }
	}
	function listenerCount (emitter, type) {
	  return emitter.listeners(type).length;
	}
	function ReadableState(options, stream) {

	  options = options || {};

	  // object stream flag. Used to make read(n) ignore n and to
	  // make all the buffer merging and length checks go away
	  this.objectMode = !!options.objectMode;

	  if (stream instanceof Duplex) this.objectMode = this.objectMode || !!options.readableObjectMode;

	  // the point at which it stops calling _read() to fill the buffer
	  // Note: 0 is a valid value, means "don't call _read preemptively ever"
	  var hwm = options.highWaterMark;
	  var defaultHwm = this.objectMode ? 16 : 16 * 1024;
	  this.highWaterMark = hwm || hwm === 0 ? hwm : defaultHwm;

	  // cast to ints.
	  this.highWaterMark = ~ ~this.highWaterMark;

	  // A linked list is used to store data chunks instead of an array because the
	  // linked list can remove elements from the beginning faster than
	  // array.shift()
	  this.buffer = new BufferList();
	  this.length = 0;
	  this.pipes = null;
	  this.pipesCount = 0;
	  this.flowing = null;
	  this.ended = false;
	  this.endEmitted = false;
	  this.reading = false;

	  // a flag to be able to tell if the onwrite cb is called immediately,
	  // or on a later tick.  We set this to true at first, because any
	  // actions that shouldn't happen until "later" should generally also
	  // not happen before the first write call.
	  this.sync = true;

	  // whenever we return null, then we set a flag to say
	  // that we're awaiting a 'readable' event emission.
	  this.needReadable = false;
	  this.emittedReadable = false;
	  this.readableListening = false;
	  this.resumeScheduled = false;

	  // Crypto is kind of old and crusty.  Historically, its default string
	  // encoding is 'binary' so we have to make this configurable.
	  // Everything else in the universe uses 'utf8', though.
	  this.defaultEncoding = options.defaultEncoding || 'utf8';

	  // when piping, we only care about 'readable' events that happen
	  // after read()ing all the bytes and not getting any pushback.
	  this.ranOut = false;

	  // the number of writers that are awaiting a drain event in .pipe()s
	  this.awaitDrain = 0;

	  // if true, a maybeReadMore has been scheduled
	  this.readingMore = false;

	  this.decoder = null;
	  this.encoding = null;
	  if (options.encoding) {
	    this.decoder = new StringDecoder(options.encoding);
	    this.encoding = options.encoding;
	  }
	}
	function Readable(options) {

	  if (!(this instanceof Readable)) return new Readable(options);

	  this._readableState = new ReadableState(options, this);

	  // legacy
	  this.readable = true;

	  if (options && typeof options.read === 'function') this._read = options.read;

	  EventEmitter.call(this);
	}

	// Manually shove something into the read() buffer.
	// This returns true if the highWaterMark has not been hit yet,
	// similar to how Writable.write() returns true if you should
	// write() some more.
	Readable.prototype.push = function (chunk, encoding) {
	  var state = this._readableState;

	  if (!state.objectMode && typeof chunk === 'string') {
	    encoding = encoding || state.defaultEncoding;
	    if (encoding !== state.encoding) {
	      chunk = Buffer$1.from(chunk, encoding);
	      encoding = '';
	    }
	  }

	  return readableAddChunk(this, state, chunk, encoding, false);
	};

	// Unshift should *always* be something directly out of read()
	Readable.prototype.unshift = function (chunk) {
	  var state = this._readableState;
	  return readableAddChunk(this, state, chunk, '', true);
	};

	Readable.prototype.isPaused = function () {
	  return this._readableState.flowing === false;
	};

	function readableAddChunk(stream, state, chunk, encoding, addToFront) {
	  var er = chunkInvalid(state, chunk);
	  if (er) {
	    stream.emit('error', er);
	  } else if (chunk === null) {
	    state.reading = false;
	    onEofChunk(stream, state);
	  } else if (state.objectMode || chunk && chunk.length > 0) {
	    if (state.ended && !addToFront) {
	      var e = new Error('stream.push() after EOF');
	      stream.emit('error', e);
	    } else if (state.endEmitted && addToFront) {
	      var _e = new Error('stream.unshift() after end event');
	      stream.emit('error', _e);
	    } else {
	      var skipAdd;
	      if (state.decoder && !addToFront && !encoding) {
	        chunk = state.decoder.write(chunk);
	        skipAdd = !state.objectMode && chunk.length === 0;
	      }

	      if (!addToFront) state.reading = false;

	      // Don't add to the buffer if we've decoded to an empty string chunk and
	      // we're not in object mode
	      if (!skipAdd) {
	        // if we want the data now, just emit it.
	        if (state.flowing && state.length === 0 && !state.sync) {
	          stream.emit('data', chunk);
	          stream.read(0);
	        } else {
	          // update the buffer info.
	          state.length += state.objectMode ? 1 : chunk.length;
	          if (addToFront) state.buffer.unshift(chunk);else state.buffer.push(chunk);

	          if (state.needReadable) emitReadable(stream);
	        }
	      }

	      maybeReadMore(stream, state);
	    }
	  } else if (!addToFront) {
	    state.reading = false;
	  }

	  return needMoreData(state);
	}

	// if it's past the high water mark, we can push in some more.
	// Also, if we have no data yet, we can stand some
	// more bytes.  This is to work around cases where hwm=0,
	// such as the repl.  Also, if the push() triggered a
	// readable event, and the user called read(largeNumber) such that
	// needReadable was set, then we ought to push more, so that another
	// 'readable' event will be triggered.
	function needMoreData(state) {
	  return !state.ended && (state.needReadable || state.length < state.highWaterMark || state.length === 0);
	}

	// backwards compatibility.
	Readable.prototype.setEncoding = function (enc) {
	  this._readableState.decoder = new StringDecoder(enc);
	  this._readableState.encoding = enc;
	  return this;
	};

	// Don't raise the hwm > 8MB
	var MAX_HWM = 0x800000;
	function computeNewHighWaterMark(n) {
	  if (n >= MAX_HWM) {
	    n = MAX_HWM;
	  } else {
	    // Get the next highest power of 2 to prevent increasing hwm excessively in
	    // tiny amounts
	    n--;
	    n |= n >>> 1;
	    n |= n >>> 2;
	    n |= n >>> 4;
	    n |= n >>> 8;
	    n |= n >>> 16;
	    n++;
	  }
	  return n;
	}

	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function howMuchToRead(n, state) {
	  if (n <= 0 || state.length === 0 && state.ended) return 0;
	  if (state.objectMode) return 1;
	  if (n !== n) {
	    // Only flow one buffer at a time
	    if (state.flowing && state.length) return state.buffer.head.data.length;else return state.length;
	  }
	  // If we're asking for more than the current hwm, then raise the hwm.
	  if (n > state.highWaterMark) state.highWaterMark = computeNewHighWaterMark(n);
	  if (n <= state.length) return n;
	  // Don't have enough
	  if (!state.ended) {
	    state.needReadable = true;
	    return 0;
	  }
	  return state.length;
	}

	// you can override either this method, or the async _read(n) below.
	Readable.prototype.read = function (n) {
	  debug('read', n);
	  n = parseInt(n, 10);
	  var state = this._readableState;
	  var nOrig = n;

	  if (n !== 0) state.emittedReadable = false;

	  // if we're doing read(0) to trigger a readable event, but we
	  // already have a bunch of data in the buffer, then just trigger
	  // the 'readable' event and move on.
	  if (n === 0 && state.needReadable && (state.length >= state.highWaterMark || state.ended)) {
	    debug('read: emitReadable', state.length, state.ended);
	    if (state.length === 0 && state.ended) endReadable(this);else emitReadable(this);
	    return null;
	  }

	  n = howMuchToRead(n, state);

	  // if we've ended, and we're now clear, then finish it up.
	  if (n === 0 && state.ended) {
	    if (state.length === 0) endReadable(this);
	    return null;
	  }

	  // All the actual chunk generation logic needs to be
	  // *below* the call to _read.  The reason is that in certain
	  // synthetic stream cases, such as passthrough streams, _read
	  // may be a completely synchronous operation which may change
	  // the state of the read buffer, providing enough data when
	  // before there was *not* enough.
	  //
	  // So, the steps are:
	  // 1. Figure out what the state of things will be after we do
	  // a read from the buffer.
	  //
	  // 2. If that resulting state will trigger a _read, then call _read.
	  // Note that this may be asynchronous, or synchronous.  Yes, it is
	  // deeply ugly to write APIs this way, but that still doesn't mean
	  // that the Readable class should behave improperly, as streams are
	  // designed to be sync/async agnostic.
	  // Take note if the _read call is sync or async (ie, if the read call
	  // has returned yet), so that we know whether or not it's safe to emit
	  // 'readable' etc.
	  //
	  // 3. Actually pull the requested chunks out of the buffer and return.

	  // if we need a readable event, then we need to do some reading.
	  var doRead = state.needReadable;
	  debug('need readable', doRead);

	  // if we currently have less than the highWaterMark, then also read some
	  if (state.length === 0 || state.length - n < state.highWaterMark) {
	    doRead = true;
	    debug('length less than watermark', doRead);
	  }

	  // however, if we've ended, then there's no point, and if we're already
	  // reading, then it's unnecessary.
	  if (state.ended || state.reading) {
	    doRead = false;
	    debug('reading or ended', doRead);
	  } else if (doRead) {
	    debug('do read');
	    state.reading = true;
	    state.sync = true;
	    // if the length is currently zero, then we *need* a readable event.
	    if (state.length === 0) state.needReadable = true;
	    // call internal read method
	    this._read(state.highWaterMark);
	    state.sync = false;
	    // If _read pushed data synchronously, then `reading` will be false,
	    // and we need to re-evaluate how much data we can return to the user.
	    if (!state.reading) n = howMuchToRead(nOrig, state);
	  }

	  var ret;
	  if (n > 0) ret = fromList(n, state);else ret = null;

	  if (ret === null) {
	    state.needReadable = true;
	    n = 0;
	  } else {
	    state.length -= n;
	  }

	  if (state.length === 0) {
	    // If we have nothing in the buffer, then we want to know
	    // as soon as we *do* get something into the buffer.
	    if (!state.ended) state.needReadable = true;

	    // If we tried to read() past the EOF, then emit end on the next tick.
	    if (nOrig !== n && state.ended) endReadable(this);
	  }

	  if (ret !== null) this.emit('data', ret);

	  return ret;
	};

	function chunkInvalid(state, chunk) {
	  var er = null;
	  if (!Buffer$1.isBuffer(chunk) && typeof chunk !== 'string' && chunk !== null && chunk !== undefined && !state.objectMode) {
	    er = new TypeError('Invalid non-string/buffer chunk');
	  }
	  return er;
	}

	function onEofChunk(stream, state) {
	  if (state.ended) return;
	  if (state.decoder) {
	    var chunk = state.decoder.end();
	    if (chunk && chunk.length) {
	      state.buffer.push(chunk);
	      state.length += state.objectMode ? 1 : chunk.length;
	    }
	  }
	  state.ended = true;

	  // emit 'readable' now to make sure it gets picked up.
	  emitReadable(stream);
	}

	// Don't emit readable right away in sync mode, because this can trigger
	// another read() call => stack overflow.  This way, it might trigger
	// a nextTick recursion warning, but that's not so bad.
	function emitReadable(stream) {
	  var state = stream._readableState;
	  state.needReadable = false;
	  if (!state.emittedReadable) {
	    debug('emitReadable', state.flowing);
	    state.emittedReadable = true;
	    if (state.sync) nextTick(emitReadable_, stream);else emitReadable_(stream);
	  }
	}

	function emitReadable_(stream) {
	  debug('emit readable');
	  stream.emit('readable');
	  flow(stream);
	}

	// at this point, the user has presumably seen the 'readable' event,
	// and called read() to consume some data.  that may have triggered
	// in turn another _read(n) call, in which case reading = true if
	// it's in progress.
	// However, if we're not ended, or reading, and the length < hwm,
	// then go ahead and try to read some more preemptively.
	function maybeReadMore(stream, state) {
	  if (!state.readingMore) {
	    state.readingMore = true;
	    nextTick(maybeReadMore_, stream, state);
	  }
	}

	function maybeReadMore_(stream, state) {
	  var len = state.length;
	  while (!state.reading && !state.flowing && !state.ended && state.length < state.highWaterMark) {
	    debug('maybeReadMore read 0');
	    stream.read(0);
	    if (len === state.length)
	      // didn't get any data, stop spinning.
	      break;else len = state.length;
	  }
	  state.readingMore = false;
	}

	// abstract method.  to be overridden in specific implementation classes.
	// call cb(er, data) where data is <= n in length.
	// for virtual (non-string, non-buffer) streams, "length" is somewhat
	// arbitrary, and perhaps not very meaningful.
	Readable.prototype._read = function (n) {
	  this.emit('error', new Error('not implemented'));
	};

	Readable.prototype.pipe = function (dest, pipeOpts) {
	  var src = this;
	  var state = this._readableState;

	  switch (state.pipesCount) {
	    case 0:
	      state.pipes = dest;
	      break;
	    case 1:
	      state.pipes = [state.pipes, dest];
	      break;
	    default:
	      state.pipes.push(dest);
	      break;
	  }
	  state.pipesCount += 1;
	  debug('pipe count=%d opts=%j', state.pipesCount, pipeOpts);

	  var doEnd = (!pipeOpts || pipeOpts.end !== false);

	  var endFn = doEnd ? onend : cleanup;
	  if (state.endEmitted) nextTick(endFn);else src.once('end', endFn);

	  dest.on('unpipe', onunpipe);
	  function onunpipe(readable) {
	    debug('onunpipe');
	    if (readable === src) {
	      cleanup();
	    }
	  }

	  function onend() {
	    debug('onend');
	    dest.end();
	  }

	  // when the dest drains, it reduces the awaitDrain counter
	  // on the source.  This would be more elegant with a .once()
	  // handler in flow(), but adding and removing repeatedly is
	  // too slow.
	  var ondrain = pipeOnDrain(src);
	  dest.on('drain', ondrain);

	  var cleanedUp = false;
	  function cleanup() {
	    debug('cleanup');
	    // cleanup event handlers once the pipe is broken
	    dest.removeListener('close', onclose);
	    dest.removeListener('finish', onfinish);
	    dest.removeListener('drain', ondrain);
	    dest.removeListener('error', onerror);
	    dest.removeListener('unpipe', onunpipe);
	    src.removeListener('end', onend);
	    src.removeListener('end', cleanup);
	    src.removeListener('data', ondata);

	    cleanedUp = true;

	    // if the reader is waiting for a drain event from this
	    // specific writer, then it would cause it to never start
	    // flowing again.
	    // So, if this is awaiting a drain, then we just call it now.
	    // If we don't know, then assume that we are waiting for one.
	    if (state.awaitDrain && (!dest._writableState || dest._writableState.needDrain)) ondrain();
	  }

	  // If the user pushes more data while we're writing to dest then we'll end up
	  // in ondata again. However, we only want to increase awaitDrain once because
	  // dest will only emit one 'drain' event for the multiple writes.
	  // => Introduce a guard on increasing awaitDrain.
	  var increasedAwaitDrain = false;
	  src.on('data', ondata);
	  function ondata(chunk) {
	    debug('ondata');
	    increasedAwaitDrain = false;
	    var ret = dest.write(chunk);
	    if (false === ret && !increasedAwaitDrain) {
	      // If the user unpiped during `dest.write()`, it is possible
	      // to get stuck in a permanently paused state if that write
	      // also returned false.
	      // => Check whether `dest` is still a piping destination.
	      if ((state.pipesCount === 1 && state.pipes === dest || state.pipesCount > 1 && indexOf(state.pipes, dest) !== -1) && !cleanedUp) {
	        debug('false write response, pause', src._readableState.awaitDrain);
	        src._readableState.awaitDrain++;
	        increasedAwaitDrain = true;
	      }
	      src.pause();
	    }
	  }

	  // if the dest has an error, then stop piping into it.
	  // however, don't suppress the throwing behavior for this.
	  function onerror(er) {
	    debug('onerror', er);
	    unpipe();
	    dest.removeListener('error', onerror);
	    if (listenerCount(dest, 'error') === 0) dest.emit('error', er);
	  }

	  // Make sure our error handler is attached before userland ones.
	  prependListener(dest, 'error', onerror);

	  // Both close and finish should trigger unpipe, but only once.
	  function onclose() {
	    dest.removeListener('finish', onfinish);
	    unpipe();
	  }
	  dest.once('close', onclose);
	  function onfinish() {
	    debug('onfinish');
	    dest.removeListener('close', onclose);
	    unpipe();
	  }
	  dest.once('finish', onfinish);

	  function unpipe() {
	    debug('unpipe');
	    src.unpipe(dest);
	  }

	  // tell the dest that it's being piped to
	  dest.emit('pipe', src);

	  // start the flow if it hasn't been started already.
	  if (!state.flowing) {
	    debug('pipe resume');
	    src.resume();
	  }

	  return dest;
	};

	function pipeOnDrain(src) {
	  return function () {
	    var state = src._readableState;
	    debug('pipeOnDrain', state.awaitDrain);
	    if (state.awaitDrain) state.awaitDrain--;
	    if (state.awaitDrain === 0 && src.listeners('data').length) {
	      state.flowing = true;
	      flow(src);
	    }
	  };
	}

	Readable.prototype.unpipe = function (dest) {
	  var state = this._readableState;

	  // if we're not piping anywhere, then do nothing.
	  if (state.pipesCount === 0) return this;

	  // just one destination.  most common case.
	  if (state.pipesCount === 1) {
	    // passed in one, but it's not the right one.
	    if (dest && dest !== state.pipes) return this;

	    if (!dest) dest = state.pipes;

	    // got a match.
	    state.pipes = null;
	    state.pipesCount = 0;
	    state.flowing = false;
	    if (dest) dest.emit('unpipe', this);
	    return this;
	  }

	  // slow case. multiple pipe destinations.

	  if (!dest) {
	    // remove all.
	    var dests = state.pipes;
	    var len = state.pipesCount;
	    state.pipes = null;
	    state.pipesCount = 0;
	    state.flowing = false;

	    for (var _i = 0; _i < len; _i++) {
	      dests[_i].emit('unpipe', this);
	    }return this;
	  }

	  // try to find the right one.
	  var i = indexOf(state.pipes, dest);
	  if (i === -1) return this;

	  state.pipes.splice(i, 1);
	  state.pipesCount -= 1;
	  if (state.pipesCount === 1) state.pipes = state.pipes[0];

	  dest.emit('unpipe', this);

	  return this;
	};

	// set up data events if they are asked for
	// Ensure readable listeners eventually get something
	Readable.prototype.on = function (ev, fn) {
	  var res = EventEmitter.prototype.on.call(this, ev, fn);

	  if (ev === 'data') {
	    // Start flowing on next tick if stream isn't explicitly paused
	    if (this._readableState.flowing !== false) this.resume();
	  } else if (ev === 'readable') {
	    var state = this._readableState;
	    if (!state.endEmitted && !state.readableListening) {
	      state.readableListening = state.needReadable = true;
	      state.emittedReadable = false;
	      if (!state.reading) {
	        nextTick(nReadingNextTick, this);
	      } else if (state.length) {
	        emitReadable(this);
	      }
	    }
	  }

	  return res;
	};
	Readable.prototype.addListener = Readable.prototype.on;

	function nReadingNextTick(self) {
	  debug('readable nexttick read 0');
	  self.read(0);
	}

	// pause() and resume() are remnants of the legacy readable stream API
	// If the user uses them, then switch into old mode.
	Readable.prototype.resume = function () {
	  var state = this._readableState;
	  if (!state.flowing) {
	    debug('resume');
	    state.flowing = true;
	    resume(this, state);
	  }
	  return this;
	};

	function resume(stream, state) {
	  if (!state.resumeScheduled) {
	    state.resumeScheduled = true;
	    nextTick(resume_, stream, state);
	  }
	}

	function resume_(stream, state) {
	  if (!state.reading) {
	    debug('resume read 0');
	    stream.read(0);
	  }

	  state.resumeScheduled = false;
	  state.awaitDrain = 0;
	  stream.emit('resume');
	  flow(stream);
	  if (state.flowing && !state.reading) stream.read(0);
	}

	Readable.prototype.pause = function () {
	  debug('call pause flowing=%j', this._readableState.flowing);
	  if (false !== this._readableState.flowing) {
	    debug('pause');
	    this._readableState.flowing = false;
	    this.emit('pause');
	  }
	  return this;
	};

	function flow(stream) {
	  var state = stream._readableState;
	  debug('flow', state.flowing);
	  while (state.flowing && stream.read() !== null) {}
	}

	// wrap an old-style stream as the async data source.
	// This is *not* part of the readable stream interface.
	// It is an ugly unfortunate mess of history.
	Readable.prototype.wrap = function (stream) {
	  var state = this._readableState;
	  var paused = false;

	  var self = this;
	  stream.on('end', function () {
	    debug('wrapped end');
	    if (state.decoder && !state.ended) {
	      var chunk = state.decoder.end();
	      if (chunk && chunk.length) self.push(chunk);
	    }

	    self.push(null);
	  });

	  stream.on('data', function (chunk) {
	    debug('wrapped data');
	    if (state.decoder) chunk = state.decoder.write(chunk);

	    // don't skip over falsy values in objectMode
	    if (state.objectMode && (chunk === null || chunk === undefined)) return;else if (!state.objectMode && (!chunk || !chunk.length)) return;

	    var ret = self.push(chunk);
	    if (!ret) {
	      paused = true;
	      stream.pause();
	    }
	  });

	  // proxy all the other methods.
	  // important when wrapping filters and duplexes.
	  for (var i in stream) {
	    if (this[i] === undefined && typeof stream[i] === 'function') {
	      this[i] = function (method) {
	        return function () {
	          return stream[method].apply(stream, arguments);
	        };
	      }(i);
	    }
	  }

	  // proxy certain important events.
	  var events = ['error', 'close', 'destroy', 'pause', 'resume'];
	  forEach(events, function (ev) {
	    stream.on(ev, self.emit.bind(self, ev));
	  });

	  // when we try to consume some more bytes, simply unpause the
	  // underlying stream.
	  self._read = function (n) {
	    debug('wrapped _read', n);
	    if (paused) {
	      paused = false;
	      stream.resume();
	    }
	  };

	  return self;
	};

	// exposed for testing purposes only.
	Readable._fromList = fromList;

	// Pluck off n bytes from an array of buffers.
	// Length is the combined lengths of all the buffers in the list.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function fromList(n, state) {
	  // nothing buffered
	  if (state.length === 0) return null;

	  var ret;
	  if (state.objectMode) ret = state.buffer.shift();else if (!n || n >= state.length) {
	    // read it all, truncate the list
	    if (state.decoder) ret = state.buffer.join('');else if (state.buffer.length === 1) ret = state.buffer.head.data;else ret = state.buffer.concat(state.length);
	    state.buffer.clear();
	  } else {
	    // read part of list
	    ret = fromListPartial(n, state.buffer, state.decoder);
	  }

	  return ret;
	}

	// Extracts only enough buffered data to satisfy the amount requested.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function fromListPartial(n, list, hasStrings) {
	  var ret;
	  if (n < list.head.data.length) {
	    // slice is the same for buffers and strings
	    ret = list.head.data.slice(0, n);
	    list.head.data = list.head.data.slice(n);
	  } else if (n === list.head.data.length) {
	    // first chunk is a perfect match
	    ret = list.shift();
	  } else {
	    // result spans more than one buffer
	    ret = hasStrings ? copyFromBufferString(n, list) : copyFromBuffer(n, list);
	  }
	  return ret;
	}

	// Copies a specified amount of characters from the list of buffered data
	// chunks.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function copyFromBufferString(n, list) {
	  var p = list.head;
	  var c = 1;
	  var ret = p.data;
	  n -= ret.length;
	  while (p = p.next) {
	    var str = p.data;
	    var nb = n > str.length ? str.length : n;
	    if (nb === str.length) ret += str;else ret += str.slice(0, n);
	    n -= nb;
	    if (n === 0) {
	      if (nb === str.length) {
	        ++c;
	        if (p.next) list.head = p.next;else list.head = list.tail = null;
	      } else {
	        list.head = p;
	        p.data = str.slice(nb);
	      }
	      break;
	    }
	    ++c;
	  }
	  list.length -= c;
	  return ret;
	}

	// Copies a specified amount of bytes from the list of buffered data chunks.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function copyFromBuffer(n, list) {
	  var ret = Buffer$1.allocUnsafe(n);
	  var p = list.head;
	  var c = 1;
	  p.data.copy(ret);
	  n -= p.data.length;
	  while (p = p.next) {
	    var buf = p.data;
	    var nb = n > buf.length ? buf.length : n;
	    buf.copy(ret, ret.length - n, 0, nb);
	    n -= nb;
	    if (n === 0) {
	      if (nb === buf.length) {
	        ++c;
	        if (p.next) list.head = p.next;else list.head = list.tail = null;
	      } else {
	        list.head = p;
	        p.data = buf.slice(nb);
	      }
	      break;
	    }
	    ++c;
	  }
	  list.length -= c;
	  return ret;
	}

	function endReadable(stream) {
	  var state = stream._readableState;

	  // If we get here before consuming all the bytes, then that is a
	  // bug in node.  Should never happen.
	  if (state.length > 0) throw new Error('"endReadable()" called on non-empty stream');

	  if (!state.endEmitted) {
	    state.ended = true;
	    nextTick(endReadableNT, state, stream);
	  }
	}

	function endReadableNT(state, stream) {
	  // Check that we didn't get one last unshift.
	  if (!state.endEmitted && state.length === 0) {
	    state.endEmitted = true;
	    stream.readable = false;
	    stream.emit('end');
	  }
	}

	function forEach(xs, f) {
	  for (var i = 0, l = xs.length; i < l; i++) {
	    f(xs[i], i);
	  }
	}

	function indexOf(xs, x) {
	  for (var i = 0, l = xs.length; i < l; i++) {
	    if (xs[i] === x) return i;
	  }
	  return -1;
	}

	// A bit simpler than readable streams.
	// Implement an async ._write(chunk, encoding, cb), and it'll handle all
	// the drain event emission and buffering.

	Writable.WritableState = WritableState;
	inherits(Writable, EventEmitter);

	function nop() {}

	function WriteReq(chunk, encoding, cb) {
	  this.chunk = chunk;
	  this.encoding = encoding;
	  this.callback = cb;
	  this.next = null;
	}

	function WritableState(options, stream) {
	  Object.defineProperty(this, 'buffer', {
	    get: deprecate(function () {
	      return this.getBuffer();
	    }, '_writableState.buffer is deprecated. Use _writableState.getBuffer ' + 'instead.')
	  });
	  options = options || {};

	  // object stream flag to indicate whether or not this stream
	  // contains buffers or objects.
	  this.objectMode = !!options.objectMode;

	  if (stream instanceof Duplex) this.objectMode = this.objectMode || !!options.writableObjectMode;

	  // the point at which write() starts returning false
	  // Note: 0 is a valid value, means that we always return false if
	  // the entire buffer is not flushed immediately on write()
	  var hwm = options.highWaterMark;
	  var defaultHwm = this.objectMode ? 16 : 16 * 1024;
	  this.highWaterMark = hwm || hwm === 0 ? hwm : defaultHwm;

	  // cast to ints.
	  this.highWaterMark = ~ ~this.highWaterMark;

	  this.needDrain = false;
	  // at the start of calling end()
	  this.ending = false;
	  // when end() has been called, and returned
	  this.ended = false;
	  // when 'finish' is emitted
	  this.finished = false;

	  // should we decode strings into buffers before passing to _write?
	  // this is here so that some node-core streams can optimize string
	  // handling at a lower level.
	  var noDecode = options.decodeStrings === false;
	  this.decodeStrings = !noDecode;

	  // Crypto is kind of old and crusty.  Historically, its default string
	  // encoding is 'binary' so we have to make this configurable.
	  // Everything else in the universe uses 'utf8', though.
	  this.defaultEncoding = options.defaultEncoding || 'utf8';

	  // not an actual buffer we keep track of, but a measurement
	  // of how much we're waiting to get pushed to some underlying
	  // socket or file.
	  this.length = 0;

	  // a flag to see when we're in the middle of a write.
	  this.writing = false;

	  // when true all writes will be buffered until .uncork() call
	  this.corked = 0;

	  // a flag to be able to tell if the onwrite cb is called immediately,
	  // or on a later tick.  We set this to true at first, because any
	  // actions that shouldn't happen until "later" should generally also
	  // not happen before the first write call.
	  this.sync = true;

	  // a flag to know if we're processing previously buffered items, which
	  // may call the _write() callback in the same tick, so that we don't
	  // end up in an overlapped onwrite situation.
	  this.bufferProcessing = false;

	  // the callback that's passed to _write(chunk,cb)
	  this.onwrite = function (er) {
	    onwrite(stream, er);
	  };

	  // the callback that the user supplies to write(chunk,encoding,cb)
	  this.writecb = null;

	  // the amount that is being written when _write is called.
	  this.writelen = 0;

	  this.bufferedRequest = null;
	  this.lastBufferedRequest = null;

	  // number of pending user-supplied write callbacks
	  // this must be 0 before 'finish' can be emitted
	  this.pendingcb = 0;

	  // emit prefinish if the only thing we're waiting for is _write cbs
	  // This is relevant for synchronous Transform streams
	  this.prefinished = false;

	  // True if the error was already emitted and should not be thrown again
	  this.errorEmitted = false;

	  // count buffered requests
	  this.bufferedRequestCount = 0;

	  // allocate the first CorkedRequest, there is always
	  // one allocated and free to use, and we maintain at most two
	  this.corkedRequestsFree = new CorkedRequest(this);
	}

	WritableState.prototype.getBuffer = function writableStateGetBuffer() {
	  var current = this.bufferedRequest;
	  var out = [];
	  while (current) {
	    out.push(current);
	    current = current.next;
	  }
	  return out;
	};
	function Writable(options) {

	  // Writable ctor is applied to Duplexes, though they're not
	  // instanceof Writable, they're instanceof Readable.
	  if (!(this instanceof Writable) && !(this instanceof Duplex)) return new Writable(options);

	  this._writableState = new WritableState(options, this);

	  // legacy.
	  this.writable = true;

	  if (options) {
	    if (typeof options.write === 'function') this._write = options.write;

	    if (typeof options.writev === 'function') this._writev = options.writev;
	  }

	  EventEmitter.call(this);
	}

	// Otherwise people can pipe Writable streams, which is just wrong.
	Writable.prototype.pipe = function () {
	  this.emit('error', new Error('Cannot pipe, not readable'));
	};

	function writeAfterEnd(stream, cb) {
	  var er = new Error('write after end');
	  // TODO: defer error events consistently everywhere, not just the cb
	  stream.emit('error', er);
	  nextTick(cb, er);
	}

	// If we get something that is not a buffer, string, null, or undefined,
	// and we're not in objectMode, then that's an error.
	// Otherwise stream chunks are all considered to be of length=1, and the
	// watermarks determine how many objects to keep in the buffer, rather than
	// how many bytes or characters.
	function validChunk(stream, state, chunk, cb) {
	  var valid = true;
	  var er = false;
	  // Always throw error if a null is written
	  // if we are not in object mode then throw
	  // if it is not a buffer, string, or undefined.
	  if (chunk === null) {
	    er = new TypeError('May not write null values to stream');
	  } else if (!Buffer$1.isBuffer(chunk) && typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
	    er = new TypeError('Invalid non-string/buffer chunk');
	  }
	  if (er) {
	    stream.emit('error', er);
	    nextTick(cb, er);
	    valid = false;
	  }
	  return valid;
	}

	Writable.prototype.write = function (chunk, encoding, cb) {
	  var state = this._writableState;
	  var ret = false;

	  if (typeof encoding === 'function') {
	    cb = encoding;
	    encoding = null;
	  }

	  if (Buffer$1.isBuffer(chunk)) encoding = 'buffer';else if (!encoding) encoding = state.defaultEncoding;

	  if (typeof cb !== 'function') cb = nop;

	  if (state.ended) writeAfterEnd(this, cb);else if (validChunk(this, state, chunk, cb)) {
	    state.pendingcb++;
	    ret = writeOrBuffer(this, state, chunk, encoding, cb);
	  }

	  return ret;
	};

	Writable.prototype.cork = function () {
	  var state = this._writableState;

	  state.corked++;
	};

	Writable.prototype.uncork = function () {
	  var state = this._writableState;

	  if (state.corked) {
	    state.corked--;

	    if (!state.writing && !state.corked && !state.finished && !state.bufferProcessing && state.bufferedRequest) clearBuffer(this, state);
	  }
	};

	Writable.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
	  // node::ParseEncoding() requires lower case.
	  if (typeof encoding === 'string') encoding = encoding.toLowerCase();
	  if (!(['hex', 'utf8', 'utf-8', 'ascii', 'binary', 'base64', 'ucs2', 'ucs-2', 'utf16le', 'utf-16le', 'raw'].indexOf((encoding + '').toLowerCase()) > -1)) throw new TypeError('Unknown encoding: ' + encoding);
	  this._writableState.defaultEncoding = encoding;
	  return this;
	};

	function decodeChunk(state, chunk, encoding) {
	  if (!state.objectMode && state.decodeStrings !== false && typeof chunk === 'string') {
	    chunk = Buffer$1.from(chunk, encoding);
	  }
	  return chunk;
	}

	// if we're already writing something, then just put this
	// in the queue, and wait our turn.  Otherwise, call _write
	// If we return false, then we need a drain event, so set that flag.
	function writeOrBuffer(stream, state, chunk, encoding, cb) {
	  chunk = decodeChunk(state, chunk, encoding);

	  if (Buffer$1.isBuffer(chunk)) encoding = 'buffer';
	  var len = state.objectMode ? 1 : chunk.length;

	  state.length += len;

	  var ret = state.length < state.highWaterMark;
	  // we must ensure that previous needDrain will not be reset to false.
	  if (!ret) state.needDrain = true;

	  if (state.writing || state.corked) {
	    var last = state.lastBufferedRequest;
	    state.lastBufferedRequest = new WriteReq(chunk, encoding, cb);
	    if (last) {
	      last.next = state.lastBufferedRequest;
	    } else {
	      state.bufferedRequest = state.lastBufferedRequest;
	    }
	    state.bufferedRequestCount += 1;
	  } else {
	    doWrite(stream, state, false, len, chunk, encoding, cb);
	  }

	  return ret;
	}

	function doWrite(stream, state, writev, len, chunk, encoding, cb) {
	  state.writelen = len;
	  state.writecb = cb;
	  state.writing = true;
	  state.sync = true;
	  if (writev) stream._writev(chunk, state.onwrite);else stream._write(chunk, encoding, state.onwrite);
	  state.sync = false;
	}

	function onwriteError(stream, state, sync, er, cb) {
	  --state.pendingcb;
	  if (sync) nextTick(cb, er);else cb(er);

	  stream._writableState.errorEmitted = true;
	  stream.emit('error', er);
	}

	function onwriteStateUpdate(state) {
	  state.writing = false;
	  state.writecb = null;
	  state.length -= state.writelen;
	  state.writelen = 0;
	}

	function onwrite(stream, er) {
	  var state = stream._writableState;
	  var sync = state.sync;
	  var cb = state.writecb;

	  onwriteStateUpdate(state);

	  if (er) onwriteError(stream, state, sync, er, cb);else {
	    // Check if we're actually ready to finish, but don't emit yet
	    var finished = needFinish(state);

	    if (!finished && !state.corked && !state.bufferProcessing && state.bufferedRequest) {
	      clearBuffer(stream, state);
	    }

	    if (sync) {
	      /*<replacement>*/
	        nextTick(afterWrite, stream, state, finished, cb);
	      /*</replacement>*/
	    } else {
	        afterWrite(stream, state, finished, cb);
	      }
	  }
	}

	function afterWrite(stream, state, finished, cb) {
	  if (!finished) onwriteDrain(stream, state);
	  state.pendingcb--;
	  cb();
	  finishMaybe(stream, state);
	}

	// Must force callback to be called on nextTick, so that we don't
	// emit 'drain' before the write() consumer gets the 'false' return
	// value, and has a chance to attach a 'drain' listener.
	function onwriteDrain(stream, state) {
	  if (state.length === 0 && state.needDrain) {
	    state.needDrain = false;
	    stream.emit('drain');
	  }
	}

	// if there's something in the buffer waiting, then process it
	function clearBuffer(stream, state) {
	  state.bufferProcessing = true;
	  var entry = state.bufferedRequest;

	  if (stream._writev && entry && entry.next) {
	    // Fast case, write everything using _writev()
	    var l = state.bufferedRequestCount;
	    var buffer = new Array(l);
	    var holder = state.corkedRequestsFree;
	    holder.entry = entry;

	    var count = 0;
	    while (entry) {
	      buffer[count] = entry;
	      entry = entry.next;
	      count += 1;
	    }

	    doWrite(stream, state, true, state.length, buffer, '', holder.finish);

	    // doWrite is almost always async, defer these to save a bit of time
	    // as the hot path ends with doWrite
	    state.pendingcb++;
	    state.lastBufferedRequest = null;
	    if (holder.next) {
	      state.corkedRequestsFree = holder.next;
	      holder.next = null;
	    } else {
	      state.corkedRequestsFree = new CorkedRequest(state);
	    }
	  } else {
	    // Slow case, write chunks one-by-one
	    while (entry) {
	      var chunk = entry.chunk;
	      var encoding = entry.encoding;
	      var cb = entry.callback;
	      var len = state.objectMode ? 1 : chunk.length;

	      doWrite(stream, state, false, len, chunk, encoding, cb);
	      entry = entry.next;
	      // if we didn't call the onwrite immediately, then
	      // it means that we need to wait until it does.
	      // also, that means that the chunk and cb are currently
	      // being processed, so move the buffer counter past them.
	      if (state.writing) {
	        break;
	      }
	    }

	    if (entry === null) state.lastBufferedRequest = null;
	  }

	  state.bufferedRequestCount = 0;
	  state.bufferedRequest = entry;
	  state.bufferProcessing = false;
	}

	Writable.prototype._write = function (chunk, encoding, cb) {
	  cb(new Error('not implemented'));
	};

	Writable.prototype._writev = null;

	Writable.prototype.end = function (chunk, encoding, cb) {
	  var state = this._writableState;

	  if (typeof chunk === 'function') {
	    cb = chunk;
	    chunk = null;
	    encoding = null;
	  } else if (typeof encoding === 'function') {
	    cb = encoding;
	    encoding = null;
	  }

	  if (chunk !== null && chunk !== undefined) this.write(chunk, encoding);

	  // .end() fully uncorks
	  if (state.corked) {
	    state.corked = 1;
	    this.uncork();
	  }

	  // ignore unnecessary end() calls.
	  if (!state.ending && !state.finished) endWritable(this, state, cb);
	};

	function needFinish(state) {
	  return state.ending && state.length === 0 && state.bufferedRequest === null && !state.finished && !state.writing;
	}

	function prefinish(stream, state) {
	  if (!state.prefinished) {
	    state.prefinished = true;
	    stream.emit('prefinish');
	  }
	}

	function finishMaybe(stream, state) {
	  var need = needFinish(state);
	  if (need) {
	    if (state.pendingcb === 0) {
	      prefinish(stream, state);
	      state.finished = true;
	      stream.emit('finish');
	    } else {
	      prefinish(stream, state);
	    }
	  }
	  return need;
	}

	function endWritable(stream, state, cb) {
	  state.ending = true;
	  finishMaybe(stream, state);
	  if (cb) {
	    if (state.finished) nextTick(cb);else stream.once('finish', cb);
	  }
	  state.ended = true;
	  stream.writable = false;
	}

	// It seems a linked list but it is not
	// there will be only 2 of these for each stream
	function CorkedRequest(state) {
	  var _this = this;

	  this.next = null;
	  this.entry = null;

	  this.finish = function (err) {
	    var entry = _this.entry;
	    _this.entry = null;
	    while (entry) {
	      var cb = entry.callback;
	      state.pendingcb--;
	      cb(err);
	      entry = entry.next;
	    }
	    if (state.corkedRequestsFree) {
	      state.corkedRequestsFree.next = _this;
	    } else {
	      state.corkedRequestsFree = _this;
	    }
	  };
	}

	inherits(Duplex, Readable);

	var keys = Object.keys(Writable.prototype);
	for (var v = 0; v < keys.length; v++) {
	  var method = keys[v];
	  if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable.prototype[method];
	}
	function Duplex(options) {
	  if (!(this instanceof Duplex)) return new Duplex(options);

	  Readable.call(this, options);
	  Writable.call(this, options);

	  if (options && options.readable === false) this.readable = false;

	  if (options && options.writable === false) this.writable = false;

	  this.allowHalfOpen = true;
	  if (options && options.allowHalfOpen === false) this.allowHalfOpen = false;

	  this.once('end', onend);
	}

	// the no-half-open enforcer
	function onend() {
	  // if we allow half-open state, or if the writable side ended,
	  // then we're ok.
	  if (this.allowHalfOpen || this._writableState.ended) return;

	  // no more data can be written.
	  // But allow more writes to happen in this tick.
	  nextTick(onEndNT, this);
	}

	function onEndNT(self) {
	  self.end();
	}

	// a transform stream is a readable/writable stream where you do
	// something with the data.  Sometimes it's called a "filter",
	// but that's not a great name for it, since that implies a thing where
	// some bits pass through, and others are simply ignored.  (That would
	// be a valid example of a transform, of course.)
	//
	// While the output is causally related to the input, it's not a
	// necessarily symmetric or synchronous transformation.  For example,
	// a zlib stream might take multiple plain-text writes(), and then
	// emit a single compressed chunk some time in the future.
	//
	// Here's how this works:
	//
	// The Transform stream has all the aspects of the readable and writable
	// stream classes.  When you write(chunk), that calls _write(chunk,cb)
	// internally, and returns false if there's a lot of pending writes
	// buffered up.  When you call read(), that calls _read(n) until
	// there's enough pending readable data buffered up.
	//
	// In a transform stream, the written data is placed in a buffer.  When
	// _read(n) is called, it transforms the queued up data, calling the
	// buffered _write cb's as it consumes chunks.  If consuming a single
	// written chunk would result in multiple output chunks, then the first
	// outputted bit calls the readcb, and subsequent chunks just go into
	// the read buffer, and will cause it to emit 'readable' if necessary.
	//
	// This way, back-pressure is actually determined by the reading side,
	// since _read has to be called to start processing a new chunk.  However,
	// a pathological inflate type of transform can cause excessive buffering
	// here.  For example, imagine a stream where every byte of input is
	// interpreted as an integer from 0-255, and then results in that many
	// bytes of output.  Writing the 4 bytes {ff,ff,ff,ff} would result in
	// 1kb of data being output.  In this case, you could write a very small
	// amount of input, and end up with a very large amount of output.  In
	// such a pathological inflating mechanism, there'd be no way to tell
	// the system to stop doing the transform.  A single 4MB write could
	// cause the system to run out of memory.
	//
	// However, even in such a pathological case, only a single written chunk
	// would be consumed, and then the rest would wait (un-transformed) until
	// the results of the previous transformed chunk were consumed.

	inherits(Transform, Duplex);

	function TransformState(stream) {
	  this.afterTransform = function (er, data) {
	    return afterTransform(stream, er, data);
	  };

	  this.needTransform = false;
	  this.transforming = false;
	  this.writecb = null;
	  this.writechunk = null;
	  this.writeencoding = null;
	}

	function afterTransform(stream, er, data) {
	  var ts = stream._transformState;
	  ts.transforming = false;

	  var cb = ts.writecb;

	  if (!cb) return stream.emit('error', new Error('no writecb in Transform class'));

	  ts.writechunk = null;
	  ts.writecb = null;

	  if (data !== null && data !== undefined) stream.push(data);

	  cb(er);

	  var rs = stream._readableState;
	  rs.reading = false;
	  if (rs.needReadable || rs.length < rs.highWaterMark) {
	    stream._read(rs.highWaterMark);
	  }
	}
	function Transform(options) {
	  if (!(this instanceof Transform)) return new Transform(options);

	  Duplex.call(this, options);

	  this._transformState = new TransformState(this);

	  // when the writable side finishes, then flush out anything remaining.
	  var stream = this;

	  // start out asking for a readable event once data is transformed.
	  this._readableState.needReadable = true;

	  // we have implemented the _read method, and done the other things
	  // that Readable wants before the first _read call, so unset the
	  // sync guard flag.
	  this._readableState.sync = false;

	  if (options) {
	    if (typeof options.transform === 'function') this._transform = options.transform;

	    if (typeof options.flush === 'function') this._flush = options.flush;
	  }

	  this.once('prefinish', function () {
	    if (typeof this._flush === 'function') this._flush(function (er) {
	      done(stream, er);
	    });else done(stream);
	  });
	}

	Transform.prototype.push = function (chunk, encoding) {
	  this._transformState.needTransform = false;
	  return Duplex.prototype.push.call(this, chunk, encoding);
	};

	// This is the part where you do stuff!
	// override this function in implementation classes.
	// 'chunk' is an input chunk.
	//
	// Call `push(newChunk)` to pass along transformed output
	// to the readable side.  You may call 'push' zero or more times.
	//
	// Call `cb(err)` when you are done with this chunk.  If you pass
	// an error, then that'll put the hurt on the whole operation.  If you
	// never call cb(), then you'll never get another chunk.
	Transform.prototype._transform = function (chunk, encoding, cb) {
	  throw new Error('Not implemented');
	};

	Transform.prototype._write = function (chunk, encoding, cb) {
	  var ts = this._transformState;
	  ts.writecb = cb;
	  ts.writechunk = chunk;
	  ts.writeencoding = encoding;
	  if (!ts.transforming) {
	    var rs = this._readableState;
	    if (ts.needTransform || rs.needReadable || rs.length < rs.highWaterMark) this._read(rs.highWaterMark);
	  }
	};

	// Doesn't matter what the args are here.
	// _transform does all the work.
	// That we got here means that the readable side wants more data.
	Transform.prototype._read = function (n) {
	  var ts = this._transformState;

	  if (ts.writechunk !== null && ts.writecb && !ts.transforming) {
	    ts.transforming = true;
	    this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
	  } else {
	    // mark that we need a transform, so that any data that comes in
	    // will get processed, now that we've asked for it.
	    ts.needTransform = true;
	  }
	};

	function done(stream, er) {
	  if (er) return stream.emit('error', er);

	  // if there's nothing in the write buffer, then that means
	  // that nothing more will ever be provided
	  var ws = stream._writableState;
	  var ts = stream._transformState;

	  if (ws.length) throw new Error('Calling transform done when ws.length != 0');

	  if (ts.transforming) throw new Error('Calling transform done when still transforming');

	  return stream.push(null);
	}

	inherits(PassThrough, Transform);
	function PassThrough(options) {
	  if (!(this instanceof PassThrough)) return new PassThrough(options);

	  Transform.call(this, options);
	}

	PassThrough.prototype._transform = function (chunk, encoding, cb) {
	  cb(null, chunk);
	};

	inherits(Stream, EventEmitter);
	Stream.Readable = Readable;
	Stream.Writable = Writable;
	Stream.Duplex = Duplex;
	Stream.Transform = Transform;
	Stream.PassThrough = PassThrough;

	// Backwards-compat with node 0.4.x
	Stream.Stream = Stream;

	// old-style streams.  Note that the pipe method (the only relevant
	// part of this class) is overridden in the Readable class.

	function Stream() {
	  EventEmitter.call(this);
	}

	Stream.prototype.pipe = function(dest, options) {
	  var source = this;

	  function ondata(chunk) {
	    if (dest.writable) {
	      if (false === dest.write(chunk) && source.pause) {
	        source.pause();
	      }
	    }
	  }

	  source.on('data', ondata);

	  function ondrain() {
	    if (source.readable && source.resume) {
	      source.resume();
	    }
	  }

	  dest.on('drain', ondrain);

	  // If the 'end' option is not supplied, dest.end() will be called when
	  // source gets the 'end' or 'close' events.  Only dest.end() once.
	  if (!dest._isStdio && (!options || options.end !== false)) {
	    source.on('end', onend);
	    source.on('close', onclose);
	  }

	  var didOnEnd = false;
	  function onend() {
	    if (didOnEnd) return;
	    didOnEnd = true;

	    dest.end();
	  }


	  function onclose() {
	    if (didOnEnd) return;
	    didOnEnd = true;

	    if (typeof dest.destroy === 'function') dest.destroy();
	  }

	  // don't leave dangling pipes when there are errors.
	  function onerror(er) {
	    cleanup();
	    if (EventEmitter.listenerCount(this, 'error') === 0) {
	      throw er; // Unhandled stream error in pipe.
	    }
	  }

	  source.on('error', onerror);
	  dest.on('error', onerror);

	  // remove all the event listeners that were added.
	  function cleanup() {
	    source.removeListener('data', ondata);
	    dest.removeListener('drain', ondrain);

	    source.removeListener('end', onend);
	    source.removeListener('close', onclose);

	    source.removeListener('error', onerror);
	    dest.removeListener('error', onerror);

	    source.removeListener('end', cleanup);
	    source.removeListener('close', cleanup);

	    dest.removeListener('close', cleanup);
	  }

	  source.on('end', cleanup);
	  source.on('close', cleanup);

	  dest.on('close', cleanup);

	  dest.emit('pipe', source);

	  // Allow for unix-like usage: A.pipe(B).pipe(C)
	  return dest;
	};

	var rStates = {
	  LOADING: 3,
	  DONE: 4
	};
	function IncomingMessage(xhr, response, mode) {
	  var self = this;
	  Readable.call(self);

	  self._mode = mode;
	  self.headers = {};
	  self.rawHeaders = [];
	  self.trailers = {};
	  self.rawTrailers = [];

	  // Fake the 'close' event, but only once 'end' fires
	  self.on('end', function() {
	    // The nextTick is necessary to prevent the 'request' module from causing an infinite loop
	    browser$1.nextTick(function() {
	      self.emit('close');
	    });
	  });
	  var read;
	  if (mode === 'fetch') {
	    self._fetchResponse = response;

	    self.url = response.url;
	    self.statusCode = response.status;
	    self.statusMessage = response.statusText;
	      // backwards compatible version of for (<item> of <iterable>):
	      // for (var <item>,_i,_it = <iterable>[Symbol.iterator](); <item> = (_i = _it.next()).value,!_i.done;)
	    for (var header, _i, _it = response.headers[Symbol.iterator](); header = (_i = _it.next()).value, !_i.done;) {
	      self.headers[header[0].toLowerCase()] = header[1];
	      self.rawHeaders.push(header[0], header[1]);
	    }

	    // TODO: this doesn't respect backpressure. Once WritableStream is available, this can be fixed
	    var reader = response.body.getReader();

	    read = function () {
	      reader.read().then(function(result) {
	        if (self._destroyed)
	          return
	        if (result.done) {
	          self.push(null);
	          return
	        }
	        self.push(new Buffer$1(result.value));
	        read();
	      });
	    };
	    read();

	  } else {
	    self._xhr = xhr;
	    self._pos = 0;

	    self.url = xhr.responseURL;
	    self.statusCode = xhr.status;
	    self.statusMessage = xhr.statusText;
	    var headers = xhr.getAllResponseHeaders().split(/\r?\n/);
	    headers.forEach(function(header) {
	      var matches = header.match(/^([^:]+):\s*(.*)/);
	      if (matches) {
	        var key = matches[1].toLowerCase();
	        if (key === 'set-cookie') {
	          if (self.headers[key] === undefined) {
	            self.headers[key] = [];
	          }
	          self.headers[key].push(matches[2]);
	        } else if (self.headers[key] !== undefined) {
	          self.headers[key] += ', ' + matches[2];
	        } else {
	          self.headers[key] = matches[2];
	        }
	        self.rawHeaders.push(matches[1], matches[2]);
	      }
	    });

	    self._charset = 'x-user-defined';
	    if (!overrideMimeType) {
	      var mimeType = self.rawHeaders['mime-type'];
	      if (mimeType) {
	        var charsetMatch = mimeType.match(/;\s*charset=([^;])(;|$)/);
	        if (charsetMatch) {
	          self._charset = charsetMatch[1].toLowerCase();
	        }
	      }
	      if (!self._charset)
	        self._charset = 'utf-8'; // best guess
	    }
	  }
	}

	inherits(IncomingMessage, Readable);

	IncomingMessage.prototype._read = function() {};

	IncomingMessage.prototype._onXHRProgress = function() {
	  var self = this;

	  var xhr = self._xhr;

	  var response = null;
	  switch (self._mode) {
	  case 'text:vbarray': // For IE9
	    if (xhr.readyState !== rStates.DONE)
	      break
	    try {
	      // This fails in IE8
	      response = new global$1.VBArray(xhr.responseBody).toArray();
	    } catch (e) {
	      // pass
	    }
	    if (response !== null) {
	      self.push(new Buffer$1(response));
	      break
	    }
	    // Falls through in IE8
	  case 'text':
	    try { // This will fail when readyState = 3 in IE9. Switch mode and wait for readyState = 4
	      response = xhr.responseText;
	    } catch (e) {
	      self._mode = 'text:vbarray';
	      break
	    }
	    if (response.length > self._pos) {
	      var newData = response.substr(self._pos);
	      if (self._charset === 'x-user-defined') {
	        var buffer = new Buffer$1(newData.length);
	        for (var i = 0; i < newData.length; i++)
	          buffer[i] = newData.charCodeAt(i) & 0xff;

	        self.push(buffer);
	      } else {
	        self.push(newData, self._charset);
	      }
	      self._pos = response.length;
	    }
	    break
	  case 'arraybuffer':
	    if (xhr.readyState !== rStates.DONE || !xhr.response)
	      break
	    response = xhr.response;
	    self.push(new Buffer$1(new Uint8Array(response)));
	    break
	  case 'moz-chunked-arraybuffer': // take whole
	    response = xhr.response;
	    if (xhr.readyState !== rStates.LOADING || !response)
	      break
	    self.push(new Buffer$1(new Uint8Array(response)));
	    break
	  case 'ms-stream':
	    response = xhr.response;
	    if (xhr.readyState !== rStates.LOADING)
	      break
	    var reader = new global$1.MSStreamReader();
	    reader.onprogress = function() {
	      if (reader.result.byteLength > self._pos) {
	        self.push(new Buffer$1(new Uint8Array(reader.result.slice(self._pos))));
	        self._pos = reader.result.byteLength;
	      }
	    };
	    reader.onload = function() {
	      self.push(null);
	    };
	      // reader.onerror = ??? // TODO: this
	    reader.readAsArrayBuffer(response);
	    break
	  }

	  // The ms-stream case handles end separately in reader.onload()
	  if (self._xhr.readyState === rStates.DONE && self._mode !== 'ms-stream') {
	    self.push(null);
	  }
	};

	// from https://github.com/jhiesey/to-arraybuffer/blob/6502d9850e70ba7935a7df4ad86b358fc216f9f0/index.js

	function toArrayBuffer (buf) {
	  // If the buffer is backed by a Uint8Array, a faster version will work
	  if (buf instanceof Uint8Array) {
	    // If the buffer isn't a subarray, return the underlying ArrayBuffer
	    if (buf.byteOffset === 0 && buf.byteLength === buf.buffer.byteLength) {
	      return buf.buffer
	    } else if (typeof buf.buffer.slice === 'function') {
	      // Otherwise we need to get a proper copy
	      return buf.buffer.slice(buf.byteOffset, buf.byteOffset + buf.byteLength)
	    }
	  }

	  if (isBuffer(buf)) {
	    // This is the slow version that will work with any Buffer
	    // implementation (even in old browsers)
	    var arrayCopy = new Uint8Array(buf.length);
	    var len = buf.length;
	    for (var i = 0; i < len; i++) {
	      arrayCopy[i] = buf[i];
	    }
	    return arrayCopy.buffer
	  } else {
	    throw new Error('Argument must be a Buffer')
	  }
	}

	function decideMode(preferBinary, useFetch) {
	  if (hasFetch && useFetch) {
	    return 'fetch'
	  } else if (mozchunkedarraybuffer) {
	    return 'moz-chunked-arraybuffer'
	  } else if (msstream) {
	    return 'ms-stream'
	  } else if (arraybuffer && preferBinary) {
	    return 'arraybuffer'
	  } else if (vbArray && preferBinary) {
	    return 'text:vbarray'
	  } else {
	    return 'text'
	  }
	}

	function ClientRequest(opts) {
	  var self = this;
	  Writable.call(self);

	  self._opts = opts;
	  self._body = [];
	  self._headers = {};
	  if (opts.auth)
	    self.setHeader('Authorization', 'Basic ' + new Buffer$1(opts.auth).toString('base64'));
	  Object.keys(opts.headers).forEach(function(name) {
	    self.setHeader(name, opts.headers[name]);
	  });

	  var preferBinary;
	  var useFetch = true;
	  if (opts.mode === 'disable-fetch') {
	    // If the use of XHR should be preferred and includes preserving the 'content-type' header
	    useFetch = false;
	    preferBinary = true;
	  } else if (opts.mode === 'prefer-streaming') {
	    // If streaming is a high priority but binary compatibility and
	    // the accuracy of the 'content-type' header aren't
	    preferBinary = false;
	  } else if (opts.mode === 'allow-wrong-content-type') {
	    // If streaming is more important than preserving the 'content-type' header
	    preferBinary = !overrideMimeType;
	  } else if (!opts.mode || opts.mode === 'default' || opts.mode === 'prefer-fast') {
	    // Use binary if text streaming may corrupt data or the content-type header, or for speed
	    preferBinary = true;
	  } else {
	    throw new Error('Invalid value for opts.mode')
	  }
	  self._mode = decideMode(preferBinary, useFetch);

	  self.on('finish', function() {
	    self._onFinish();
	  });
	}

	inherits(ClientRequest, Writable);
	// Taken from http://www.w3.org/TR/XMLHttpRequest/#the-setrequestheader%28%29-method
	var unsafeHeaders = [
	  'accept-charset',
	  'accept-encoding',
	  'access-control-request-headers',
	  'access-control-request-method',
	  'connection',
	  'content-length',
	  'cookie',
	  'cookie2',
	  'date',
	  'dnt',
	  'expect',
	  'host',
	  'keep-alive',
	  'origin',
	  'referer',
	  'te',
	  'trailer',
	  'transfer-encoding',
	  'upgrade',
	  'user-agent',
	  'via'
	];
	ClientRequest.prototype.setHeader = function(name, value) {
	  var self = this;
	  var lowerName = name.toLowerCase();
	    // This check is not necessary, but it prevents warnings from browsers about setting unsafe
	    // headers. To be honest I'm not entirely sure hiding these warnings is a good thing, but
	    // http-browserify did it, so I will too.
	  if (unsafeHeaders.indexOf(lowerName) !== -1)
	    return

	  self._headers[lowerName] = {
	    name: name,
	    value: value
	  };
	};

	ClientRequest.prototype.getHeader = function(name) {
	  var self = this;
	  return self._headers[name.toLowerCase()].value
	};

	ClientRequest.prototype.removeHeader = function(name) {
	  var self = this;
	  delete self._headers[name.toLowerCase()];
	};

	ClientRequest.prototype._onFinish = function() {
	  var self = this;

	  if (self._destroyed)
	    return
	  var opts = self._opts;

	  var headersObj = self._headers;
	  var body;
	  if (opts.method === 'POST' || opts.method === 'PUT' || opts.method === 'PATCH') {
	    if (blobConstructor()) {
	      body = new global$1.Blob(self._body.map(function(buffer) {
	        return toArrayBuffer(buffer)
	      }), {
	        type: (headersObj['content-type'] || {}).value || ''
	      });
	    } else {
	      // get utf8 string
	      body = Buffer$1.concat(self._body).toString();
	    }
	  }

	  if (self._mode === 'fetch') {
	    var headers = Object.keys(headersObj).map(function(name) {
	      return [headersObj[name].name, headersObj[name].value]
	    });

	    global$1.fetch(self._opts.url, {
	      method: self._opts.method,
	      headers: headers,
	      body: body,
	      mode: 'cors',
	      credentials: opts.withCredentials ? 'include' : 'same-origin'
	    }).then(function(response) {
	      self._fetchResponse = response;
	      self._connect();
	    }, function(reason) {
	      self.emit('error', reason);
	    });
	  } else {
	    var xhr = self._xhr = new global$1.XMLHttpRequest();
	    try {
	      xhr.open(self._opts.method, self._opts.url, true);
	    } catch (err) {
	      browser$1.nextTick(function() {
	        self.emit('error', err);
	      });
	      return
	    }

	    // Can't set responseType on really old browsers
	    if ('responseType' in xhr)
	      xhr.responseType = self._mode.split(':')[0];

	    if ('withCredentials' in xhr)
	      xhr.withCredentials = !!opts.withCredentials;

	    if (self._mode === 'text' && 'overrideMimeType' in xhr)
	      xhr.overrideMimeType('text/plain; charset=x-user-defined');

	    Object.keys(headersObj).forEach(function(name) {
	      xhr.setRequestHeader(headersObj[name].name, headersObj[name].value);
	    });

	    self._response = null;
	    xhr.onreadystatechange = function() {
	      switch (xhr.readyState) {
	      case rStates.LOADING:
	      case rStates.DONE:
	        self._onXHRProgress();
	        break
	      }
	    };
	      // Necessary for streaming in Firefox, since xhr.response is ONLY defined
	      // in onprogress, not in onreadystatechange with xhr.readyState = 3
	    if (self._mode === 'moz-chunked-arraybuffer') {
	      xhr.onprogress = function() {
	        self._onXHRProgress();
	      };
	    }

	    xhr.onerror = function() {
	      if (self._destroyed)
	        return
	      self.emit('error', new Error('XHR error'));
	    };

	    try {
	      xhr.send(body);
	    } catch (err) {
	      browser$1.nextTick(function() {
	        self.emit('error', err);
	      });
	      return
	    }
	  }
	};

	/**
	 * Checks if xhr.status is readable and non-zero, indicating no error.
	 * Even though the spec says it should be available in readyState 3,
	 * accessing it throws an exception in IE8
	 */
	function statusValid(xhr) {
	  try {
	    var status = xhr.status;
	    return (status !== null && status !== 0)
	  } catch (e) {
	    return false
	  }
	}

	ClientRequest.prototype._onXHRProgress = function() {
	  var self = this;

	  if (!statusValid(self._xhr) || self._destroyed)
	    return

	  if (!self._response)
	    self._connect();

	  self._response._onXHRProgress();
	};

	ClientRequest.prototype._connect = function() {
	  var self = this;

	  if (self._destroyed)
	    return

	  self._response = new IncomingMessage(self._xhr, self._fetchResponse, self._mode);
	  self.emit('response', self._response);
	};

	ClientRequest.prototype._write = function(chunk, encoding, cb) {
	  var self = this;

	  self._body.push(chunk);
	  cb();
	};

	ClientRequest.prototype.abort = ClientRequest.prototype.destroy = function() {
	  var self = this;
	  self._destroyed = true;
	  if (self._response)
	    self._response._destroyed = true;
	  if (self._xhr)
	    self._xhr.abort();
	    // Currently, there isn't a way to truly abort a fetch.
	    // If you like bikeshedding, see https://github.com/whatwg/fetch/issues/27
	};

	ClientRequest.prototype.end = function(data, encoding, cb) {
	  var self = this;
	  if (typeof data === 'function') {
	    cb = data;
	    data = undefined;
	  }

	  Writable.prototype.end.call(self, data, encoding, cb);
	};

	ClientRequest.prototype.flushHeaders = function() {};
	ClientRequest.prototype.setTimeout = function() {};
	ClientRequest.prototype.setNoDelay = function() {};
	ClientRequest.prototype.setSocketKeepAlive = function() {};

	/*! https://mths.be/punycode v1.4.1 by @mathias */


	/** Highest positive signed 32-bit float value */
	var maxInt = 2147483647; // aka. 0x7FFFFFFF or 2^31-1

	/** Bootstring parameters */
	var base = 36;
	var tMin = 1;
	var tMax = 26;
	var skew = 38;
	var damp = 700;
	var initialBias = 72;
	var initialN = 128; // 0x80
	var delimiter$1 = '-'; // '\x2D'
	var regexNonASCII = /[^\x20-\x7E]/; // unprintable ASCII chars + non-ASCII chars
	var regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g; // RFC 3490 separators

	/** Error messages */
	var errors = {
	  'overflow': 'Overflow: input needs wider integers to process',
	  'not-basic': 'Illegal input >= 0x80 (not a basic code point)',
	  'invalid-input': 'Invalid input'
	};

	/** Convenience shortcuts */
	var baseMinusTMin = base - tMin;
	var floor = Math.floor;
	var stringFromCharCode = String.fromCharCode;

	/*--------------------------------------------------------------------------*/

	/**
	 * A generic error utility function.
	 * @private
	 * @param {String} type The error type.
	 * @returns {Error} Throws a `RangeError` with the applicable error message.
	 */
	function error(type) {
	  throw new RangeError(errors[type]);
	}

	/**
	 * A generic `Array#map` utility function.
	 * @private
	 * @param {Array} array The array to iterate over.
	 * @param {Function} callback The function that gets called for every array
	 * item.
	 * @returns {Array} A new array of values returned by the callback function.
	 */
	function map$1(array, fn) {
	  var length = array.length;
	  var result = [];
	  while (length--) {
	    result[length] = fn(array[length]);
	  }
	  return result;
	}

	/**
	 * A simple `Array#map`-like wrapper to work with domain name strings or email
	 * addresses.
	 * @private
	 * @param {String} domain The domain name or email address.
	 * @param {Function} callback The function that gets called for every
	 * character.
	 * @returns {Array} A new string of characters returned by the callback
	 * function.
	 */
	function mapDomain(string, fn) {
	  var parts = string.split('@');
	  var result = '';
	  if (parts.length > 1) {
	    // In email addresses, only the domain name should be punycoded. Leave
	    // the local part (i.e. everything up to `@`) intact.
	    result = parts[0] + '@';
	    string = parts[1];
	  }
	  // Avoid `split(regex)` for IE8 compatibility. See #17.
	  string = string.replace(regexSeparators, '\x2E');
	  var labels = string.split('.');
	  var encoded = map$1(labels, fn).join('.');
	  return result + encoded;
	}

	/**
	 * Creates an array containing the numeric code points of each Unicode
	 * character in the string. While JavaScript uses UCS-2 internally,
	 * this function will convert a pair of surrogate halves (each of which
	 * UCS-2 exposes as separate characters) into a single code point,
	 * matching UTF-16.
	 * @see `punycode.ucs2.encode`
	 * @see <https://mathiasbynens.be/notes/javascript-encoding>
	 * @memberOf punycode.ucs2
	 * @name decode
	 * @param {String} string The Unicode input string (UCS-2).
	 * @returns {Array} The new array of code points.
	 */
	function ucs2decode(string) {
	  var output = [],
	    counter = 0,
	    length = string.length,
	    value,
	    extra;
	  while (counter < length) {
	    value = string.charCodeAt(counter++);
	    if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
	      // high surrogate, and there is a next character
	      extra = string.charCodeAt(counter++);
	      if ((extra & 0xFC00) == 0xDC00) { // low surrogate
	        output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
	      } else {
	        // unmatched surrogate; only append this code unit, in case the next
	        // code unit is the high surrogate of a surrogate pair
	        output.push(value);
	        counter--;
	      }
	    } else {
	      output.push(value);
	    }
	  }
	  return output;
	}

	/**
	 * Converts a digit/integer into a basic code point.
	 * @see `basicToDigit()`
	 * @private
	 * @param {Number} digit The numeric value of a basic code point.
	 * @returns {Number} The basic code point whose value (when used for
	 * representing integers) is `digit`, which needs to be in the range
	 * `0` to `base - 1`. If `flag` is non-zero, the uppercase form is
	 * used; else, the lowercase form is used. The behavior is undefined
	 * if `flag` is non-zero and `digit` has no uppercase form.
	 */
	function digitToBasic(digit, flag) {
	  //  0..25 map to ASCII a..z or A..Z
	  // 26..35 map to ASCII 0..9
	  return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
	}

	/**
	 * Bias adaptation function as per section 3.4 of RFC 3492.
	 * https://tools.ietf.org/html/rfc3492#section-3.4
	 * @private
	 */
	function adapt(delta, numPoints, firstTime) {
	  var k = 0;
	  delta = firstTime ? floor(delta / damp) : delta >> 1;
	  delta += floor(delta / numPoints);
	  for ( /* no initialization */ ; delta > baseMinusTMin * tMax >> 1; k += base) {
	    delta = floor(delta / baseMinusTMin);
	  }
	  return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
	}

	/**
	 * Converts a string of Unicode symbols (e.g. a domain name label) to a
	 * Punycode string of ASCII-only symbols.
	 * @memberOf punycode
	 * @param {String} input The string of Unicode symbols.
	 * @returns {String} The resulting Punycode string of ASCII-only symbols.
	 */
	function encode$1(input) {
	  var n,
	    delta,
	    handledCPCount,
	    basicLength,
	    bias,
	    j,
	    m,
	    q,
	    k,
	    t,
	    currentValue,
	    output = [],
	    /** `inputLength` will hold the number of code points in `input`. */
	    inputLength,
	    /** Cached calculation results */
	    handledCPCountPlusOne,
	    baseMinusT,
	    qMinusT;

	  // Convert the input in UCS-2 to Unicode
	  input = ucs2decode(input);

	  // Cache the length
	  inputLength = input.length;

	  // Initialize the state
	  n = initialN;
	  delta = 0;
	  bias = initialBias;

	  // Handle the basic code points
	  for (j = 0; j < inputLength; ++j) {
	    currentValue = input[j];
	    if (currentValue < 0x80) {
	      output.push(stringFromCharCode(currentValue));
	    }
	  }

	  handledCPCount = basicLength = output.length;

	  // `handledCPCount` is the number of code points that have been handled;
	  // `basicLength` is the number of basic code points.

	  // Finish the basic string - if it is not empty - with a delimiter
	  if (basicLength) {
	    output.push(delimiter$1);
	  }

	  // Main encoding loop:
	  while (handledCPCount < inputLength) {

	    // All non-basic code points < n have been handled already. Find the next
	    // larger one:
	    for (m = maxInt, j = 0; j < inputLength; ++j) {
	      currentValue = input[j];
	      if (currentValue >= n && currentValue < m) {
	        m = currentValue;
	      }
	    }

	    // Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,
	    // but guard against overflow
	    handledCPCountPlusOne = handledCPCount + 1;
	    if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
	      error('overflow');
	    }

	    delta += (m - n) * handledCPCountPlusOne;
	    n = m;

	    for (j = 0; j < inputLength; ++j) {
	      currentValue = input[j];

	      if (currentValue < n && ++delta > maxInt) {
	        error('overflow');
	      }

	      if (currentValue == n) {
	        // Represent delta as a generalized variable-length integer
	        for (q = delta, k = base; /* no condition */ ; k += base) {
	          t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);
	          if (q < t) {
	            break;
	          }
	          qMinusT = q - t;
	          baseMinusT = base - t;
	          output.push(
	            stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
	          );
	          q = floor(qMinusT / baseMinusT);
	        }

	        output.push(stringFromCharCode(digitToBasic(q, 0)));
	        bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
	        delta = 0;
	        ++handledCPCount;
	      }
	    }

	    ++delta;
	    ++n;

	  }
	  return output.join('');
	}

	/**
	 * Converts a Unicode string representing a domain name or an email address to
	 * Punycode. Only the non-ASCII parts of the domain name will be converted,
	 * i.e. it doesn't matter if you call it with a domain that's already in
	 * ASCII.
	 * @memberOf punycode
	 * @param {String} input The domain name or email address to convert, as a
	 * Unicode string.
	 * @returns {String} The Punycode representation of the given domain name or
	 * email address.
	 */
	function toASCII(input) {
	  return mapDomain(input, function(string) {
	    return regexNonASCII.test(string) ?
	      'xn--' + encode$1(string) :
	      string;
	  });
	}

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.


	// If obj.hasOwnProperty has been overridden, then calling
	// obj.hasOwnProperty(prop) will break.
	// See: https://github.com/joyent/node/issues/1707
	function hasOwnProperty(obj, prop) {
	  return Object.prototype.hasOwnProperty.call(obj, prop);
	}
	var isArray = Array.isArray || function (xs) {
	  return Object.prototype.toString.call(xs) === '[object Array]';
	};
	function stringifyPrimitive(v) {
	  switch (typeof v) {
	    case 'string':
	      return v;

	    case 'boolean':
	      return v ? 'true' : 'false';

	    case 'number':
	      return isFinite(v) ? v : '';

	    default:
	      return '';
	  }
	}

	function stringify (obj, sep, eq, name) {
	  sep = sep || '&';
	  eq = eq || '=';
	  if (obj === null) {
	    obj = undefined;
	  }

	  if (typeof obj === 'object') {
	    return map(objectKeys(obj), function(k) {
	      var ks = encodeURIComponent(stringifyPrimitive(k)) + eq;
	      if (isArray(obj[k])) {
	        return map(obj[k], function(v) {
	          return ks + encodeURIComponent(stringifyPrimitive(v));
	        }).join(sep);
	      } else {
	        return ks + encodeURIComponent(stringifyPrimitive(obj[k]));
	      }
	    }).join(sep);

	  }

	  if (!name) return '';
	  return encodeURIComponent(stringifyPrimitive(name)) + eq +
	         encodeURIComponent(stringifyPrimitive(obj));
	}
	function map (xs, f) {
	  if (xs.map) return xs.map(f);
	  var res = [];
	  for (var i = 0; i < xs.length; i++) {
	    res.push(f(xs[i], i));
	  }
	  return res;
	}

	var objectKeys = Object.keys || function (obj) {
	  var res = [];
	  for (var key in obj) {
	    if (Object.prototype.hasOwnProperty.call(obj, key)) res.push(key);
	  }
	  return res;
	};

	function parse$3(qs, sep, eq, options) {
	  sep = sep || '&';
	  eq = eq || '=';
	  var obj = {};

	  if (typeof qs !== 'string' || qs.length === 0) {
	    return obj;
	  }

	  var regexp = /\+/g;
	  qs = qs.split(sep);

	  var maxKeys = 1000;
	  if (options && typeof options.maxKeys === 'number') {
	    maxKeys = options.maxKeys;
	  }

	  var len = qs.length;
	  // maxKeys <= 0 means that we should not limit keys count
	  if (maxKeys > 0 && len > maxKeys) {
	    len = maxKeys;
	  }

	  for (var i = 0; i < len; ++i) {
	    var x = qs[i].replace(regexp, '%20'),
	        idx = x.indexOf(eq),
	        kstr, vstr, k, v;

	    if (idx >= 0) {
	      kstr = x.substr(0, idx);
	      vstr = x.substr(idx + 1);
	    } else {
	      kstr = x;
	      vstr = '';
	    }

	    k = decodeURIComponent(kstr);
	    v = decodeURIComponent(vstr);

	    if (!hasOwnProperty(obj, k)) {
	      obj[k] = v;
	    } else if (isArray(obj[k])) {
	      obj[k].push(v);
	    } else {
	      obj[k] = [obj[k], v];
	    }
	  }

	  return obj;
	}

	// WHATWG API
	const URL = global$1.URL;
	const URLSearchParams = global$1.URLSearchParams;
	var _polyfillNode_url = {
	  parse: urlParse,
	  resolve: urlResolve,
	  resolveObject: urlResolveObject,
	  fileURLToPath: urlFileURLToPath,
	  format: urlFormat,
	  Url: Url,

	  // WHATWG API
	  URL,
	  URLSearchParams,  
	};
	function Url() {
	  this.protocol = null;
	  this.slashes = null;
	  this.auth = null;
	  this.host = null;
	  this.port = null;
	  this.hostname = null;
	  this.hash = null;
	  this.search = null;
	  this.query = null;
	  this.pathname = null;
	  this.path = null;
	  this.href = null;
	}

	// Reference: RFC 3986, RFC 1808, RFC 2396

	// define these here so at least they only have to be
	// compiled once on the first module load.
	var protocolPattern = /^([a-z0-9.+-]+:)/i,
	  portPattern = /:[0-9]*$/,

	  // Special case for a simple path URL
	  simplePathPattern = /^(\/\/?(?!\/)[^\?\s]*)(\?[^\s]*)?$/,

	  // RFC 2396: characters reserved for delimiting URLs.
	  // We actually just auto-escape these.
	  delims = ['<', '>', '"', '`', ' ', '\r', '\n', '\t'],

	  // RFC 2396: characters not allowed for various reasons.
	  unwise = ['{', '}', '|', '\\', '^', '`'].concat(delims),

	  // Allowed by RFCs, but cause of XSS attacks.  Always escape these.
	  autoEscape = ['\''].concat(unwise),
	  // Characters that are never ever allowed in a hostname.
	  // Note that any invalid chars are also handled, but these
	  // are the ones that are *expected* to be seen, so we fast-path
	  // them.
	  nonHostChars = ['%', '/', '?', ';', '#'].concat(autoEscape),
	  hostEndingChars = ['/', '?', '#'],
	  hostnameMaxLen = 255,
	  hostnamePartPattern = /^[+a-z0-9A-Z_-]{0,63}$/,
	  hostnamePartStart = /^([+a-z0-9A-Z_-]{0,63})(.*)$/,
	  // protocols that can allow "unsafe" and "unwise" chars.
	  unsafeProtocol = {
	    'javascript': true,
	    'javascript:': true
	  },
	  // protocols that never have a hostname.
	  hostlessProtocol = {
	    'javascript': true,
	    'javascript:': true
	  },
	  // protocols that always contain a // bit.
	  slashedProtocol = {
	    'http': true,
	    'https': true,
	    'ftp': true,
	    'gopher': true,
	    'file': true,
	    'http:': true,
	    'https:': true,
	    'ftp:': true,
	    'gopher:': true,
	    'file:': true
	  };

	function urlParse(url, parseQueryString, slashesDenoteHost) {
	  if (url && isObject(url) && url instanceof Url) return url;

	  var u = new Url;
	  u.parse(url, parseQueryString, slashesDenoteHost);
	  return u;
	}
	Url.prototype.parse = function(url, parseQueryString, slashesDenoteHost) {
	  return parse$2(this, url, parseQueryString, slashesDenoteHost);
	};

	function parse$2(self, url, parseQueryString, slashesDenoteHost) {
	  if (!isString(url)) {
	    throw new TypeError('Parameter \'url\' must be a string, not ' + typeof url);
	  }

	  // Copy chrome, IE, opera backslash-handling behavior.
	  // Back slashes before the query string get converted to forward slashes
	  // See: https://code.google.com/p/chromium/issues/detail?id=25916
	  var queryIndex = url.indexOf('?'),
	    splitter =
	    (queryIndex !== -1 && queryIndex < url.indexOf('#')) ? '?' : '#',
	    uSplit = url.split(splitter),
	    slashRegex = /\\/g;
	  uSplit[0] = uSplit[0].replace(slashRegex, '/');
	  url = uSplit.join(splitter);

	  var rest = url;

	  // trim before proceeding.
	  // This is to support parse stuff like "  http://foo.com  \n"
	  rest = rest.trim();

	  if (!slashesDenoteHost && url.split('#').length === 1) {
	    // Try fast path regexp
	    var simplePath = simplePathPattern.exec(rest);
	    if (simplePath) {
	      self.path = rest;
	      self.href = rest;
	      self.pathname = simplePath[1];
	      if (simplePath[2]) {
	        self.search = simplePath[2];
	        if (parseQueryString) {
	          self.query = parse$3(self.search.substr(1));
	        } else {
	          self.query = self.search.substr(1);
	        }
	      } else if (parseQueryString) {
	        self.search = '';
	        self.query = {};
	      }
	      return self;
	    }
	  }

	  var proto = protocolPattern.exec(rest);
	  if (proto) {
	    proto = proto[0];
	    var lowerProto = proto.toLowerCase();
	    self.protocol = lowerProto;
	    rest = rest.substr(proto.length);
	  }

	  // figure out if it's got a host
	  // user@server is *always* interpreted as a hostname, and url
	  // resolution will treat //foo/bar as host=foo,path=bar because that's
	  // how the browser resolves relative URLs.
	  if (slashesDenoteHost || proto || rest.match(/^\/\/[^@\/]+@[^@\/]+/)) {
	    var slashes = rest.substr(0, 2) === '//';
	    if (slashes && !(proto && hostlessProtocol[proto])) {
	      rest = rest.substr(2);
	      self.slashes = true;
	    }
	  }
	  var i, hec, l, p;
	  if (!hostlessProtocol[proto] &&
	    (slashes || (proto && !slashedProtocol[proto]))) {

	    // there's a hostname.
	    // the first instance of /, ?, ;, or # ends the host.
	    //
	    // If there is an @ in the hostname, then non-host chars *are* allowed
	    // to the left of the last @ sign, unless some host-ending character
	    // comes *before* the @-sign.
	    // URLs are obnoxious.
	    //
	    // ex:
	    // http://a@b@c/ => user:a@b host:c
	    // http://a@b?@c => user:a host:c path:/?@c

	    // v0.12 TODO(isaacs): This is not quite how Chrome does things.
	    // Review our test case against browsers more comprehensively.

	    // find the first instance of any hostEndingChars
	    var hostEnd = -1;
	    for (i = 0; i < hostEndingChars.length; i++) {
	      hec = rest.indexOf(hostEndingChars[i]);
	      if (hec !== -1 && (hostEnd === -1 || hec < hostEnd))
	        hostEnd = hec;
	    }

	    // at this point, either we have an explicit point where the
	    // auth portion cannot go past, or the last @ char is the decider.
	    var auth, atSign;
	    if (hostEnd === -1) {
	      // atSign can be anywhere.
	      atSign = rest.lastIndexOf('@');
	    } else {
	      // atSign must be in auth portion.
	      // http://a@b/c@d => host:b auth:a path:/c@d
	      atSign = rest.lastIndexOf('@', hostEnd);
	    }

	    // Now we have a portion which is definitely the auth.
	    // Pull that off.
	    if (atSign !== -1) {
	      auth = rest.slice(0, atSign);
	      rest = rest.slice(atSign + 1);
	      self.auth = decodeURIComponent(auth);
	    }

	    // the host is the remaining to the left of the first non-host char
	    hostEnd = -1;
	    for (i = 0; i < nonHostChars.length; i++) {
	      hec = rest.indexOf(nonHostChars[i]);
	      if (hec !== -1 && (hostEnd === -1 || hec < hostEnd))
	        hostEnd = hec;
	    }
	    // if we still have not hit it, then the entire thing is a host.
	    if (hostEnd === -1)
	      hostEnd = rest.length;

	    self.host = rest.slice(0, hostEnd);
	    rest = rest.slice(hostEnd);

	    // pull out port.
	    parseHost(self);

	    // we've indicated that there is a hostname,
	    // so even if it's empty, it has to be present.
	    self.hostname = self.hostname || '';

	    // if hostname begins with [ and ends with ]
	    // assume that it's an IPv6 address.
	    var ipv6Hostname = self.hostname[0] === '[' &&
	      self.hostname[self.hostname.length - 1] === ']';

	    // validate a little.
	    if (!ipv6Hostname) {
	      var hostparts = self.hostname.split(/\./);
	      for (i = 0, l = hostparts.length; i < l; i++) {
	        var part = hostparts[i];
	        if (!part) continue;
	        if (!part.match(hostnamePartPattern)) {
	          var newpart = '';
	          for (var j = 0, k = part.length; j < k; j++) {
	            if (part.charCodeAt(j) > 127) {
	              // we replace non-ASCII char with a temporary placeholder
	              // we need this to make sure size of hostname is not
	              // broken by replacing non-ASCII by nothing
	              newpart += 'x';
	            } else {
	              newpart += part[j];
	            }
	          }
	          // we test again with ASCII char only
	          if (!newpart.match(hostnamePartPattern)) {
	            var validParts = hostparts.slice(0, i);
	            var notHost = hostparts.slice(i + 1);
	            var bit = part.match(hostnamePartStart);
	            if (bit) {
	              validParts.push(bit[1]);
	              notHost.unshift(bit[2]);
	            }
	            if (notHost.length) {
	              rest = '/' + notHost.join('.') + rest;
	            }
	            self.hostname = validParts.join('.');
	            break;
	          }
	        }
	      }
	    }

	    if (self.hostname.length > hostnameMaxLen) {
	      self.hostname = '';
	    } else {
	      // hostnames are always lower case.
	      self.hostname = self.hostname.toLowerCase();
	    }

	    if (!ipv6Hostname) {
	      // IDNA Support: Returns a punycoded representation of "domain".
	      // It only converts parts of the domain name that
	      // have non-ASCII characters, i.e. it doesn't matter if
	      // you call it with a domain that already is ASCII-only.
	      self.hostname = toASCII(self.hostname);
	    }

	    p = self.port ? ':' + self.port : '';
	    var h = self.hostname || '';
	    self.host = h + p;
	    self.href += self.host;

	    // strip [ and ] from the hostname
	    // the host field still retains them, though
	    if (ipv6Hostname) {
	      self.hostname = self.hostname.substr(1, self.hostname.length - 2);
	      if (rest[0] !== '/') {
	        rest = '/' + rest;
	      }
	    }
	  }

	  // now rest is set to the post-host stuff.
	  // chop off any delim chars.
	  if (!unsafeProtocol[lowerProto]) {

	    // First, make 100% sure that any "autoEscape" chars get
	    // escaped, even if encodeURIComponent doesn't think they
	    // need to be.
	    for (i = 0, l = autoEscape.length; i < l; i++) {
	      var ae = autoEscape[i];
	      if (rest.indexOf(ae) === -1)
	        continue;
	      var esc = encodeURIComponent(ae);
	      if (esc === ae) {
	        esc = escape(ae);
	      }
	      rest = rest.split(ae).join(esc);
	    }
	  }


	  // chop off from the tail first.
	  var hash = rest.indexOf('#');
	  if (hash !== -1) {
	    // got a fragment string.
	    self.hash = rest.substr(hash);
	    rest = rest.slice(0, hash);
	  }
	  var qm = rest.indexOf('?');
	  if (qm !== -1) {
	    self.search = rest.substr(qm);
	    self.query = rest.substr(qm + 1);
	    if (parseQueryString) {
	      self.query = parse$3(self.query);
	    }
	    rest = rest.slice(0, qm);
	  } else if (parseQueryString) {
	    // no query string, but parseQueryString still requested
	    self.search = '';
	    self.query = {};
	  }
	  if (rest) self.pathname = rest;
	  if (slashedProtocol[lowerProto] &&
	    self.hostname && !self.pathname) {
	    self.pathname = '/';
	  }

	  //to support http.request
	  if (self.pathname || self.search) {
	    p = self.pathname || '';
	    var s = self.search || '';
	    self.path = p + s;
	  }

	  // finally, reconstruct the href based on what has been validated.
	  self.href = format$1(self);
	  return self;
	}

	function urlFileURLToPath(path) {
	  if (typeof path === 'string')
	    path = new Url().parse(path);
	  else if (!(path instanceof Url))
	    throw new TypeError('The "path" argument must be of type string or an instance of URL. Received type ' + (typeof path) + String(path));
	  if (path.protocol !== 'file:')
	    throw new TypeError('The URL must be of scheme file');
	  return getPathFromURLPosix(path);
	}

	function getPathFromURLPosix(url) {
	  const pathname = url.pathname;
	  for (let n = 0; n < pathname.length; n++) {
	    if (pathname[n] === '%') {
	      const third = pathname.codePointAt(n + 2) | 0x20;
	      if (pathname[n + 1] === '2' && third === 102) {
	        throw new TypeError(
	          'must not include encoded / characters'
	        );
	      }
	    }
	  }
	  return decodeURIComponent(pathname);
	}

	// format a parsed object into a url string
	function urlFormat(obj) {
	  // ensure it's an object, and not a string url.
	  // If it's an obj, this is a no-op.
	  // this way, you can call url_format() on strings
	  // to clean up potentially wonky urls.
	  if (isString(obj)) obj = parse$2({}, obj);
	  return format$1(obj);
	}

	function format$1(self) {
	  var auth = self.auth || '';
	  if (auth) {
	    auth = encodeURIComponent(auth);
	    auth = auth.replace(/%3A/i, ':');
	    auth += '@';
	  }

	  var protocol = self.protocol || '',
	    pathname = self.pathname || '',
	    hash = self.hash || '',
	    host = false,
	    query = '';

	  if (self.host) {
	    host = auth + self.host;
	  } else if (self.hostname) {
	    host = auth + (self.hostname.indexOf(':') === -1 ?
	      self.hostname :
	      '[' + this.hostname + ']');
	    if (self.port) {
	      host += ':' + self.port;
	    }
	  }

	  if (self.query &&
	    isObject(self.query) &&
	    Object.keys(self.query).length) {
	    query = stringify(self.query);
	  }

	  var search = self.search || (query && ('?' + query)) || '';

	  if (protocol && protocol.substr(-1) !== ':') protocol += ':';

	  // only the slashedProtocols get the //.  Not mailto:, xmpp:, etc.
	  // unless they had them to begin with.
	  if (self.slashes ||
	    (!protocol || slashedProtocol[protocol]) && host !== false) {
	    host = '//' + (host || '');
	    if (pathname && pathname.charAt(0) !== '/') pathname = '/' + pathname;
	  } else if (!host) {
	    host = '';
	  }

	  if (hash && hash.charAt(0) !== '#') hash = '#' + hash;
	  if (search && search.charAt(0) !== '?') search = '?' + search;

	  pathname = pathname.replace(/[?#]/g, function(match) {
	    return encodeURIComponent(match);
	  });
	  search = search.replace('#', '%23');

	  return protocol + host + pathname + search + hash;
	}

	Url.prototype.format = function() {
	  return format$1(this);
	};

	function urlResolve(source, relative) {
	  return urlParse(source, false, true).resolve(relative);
	}

	Url.prototype.resolve = function(relative) {
	  return this.resolveObject(urlParse(relative, false, true)).format();
	};

	function urlResolveObject(source, relative) {
	  if (!source) return relative;
	  return urlParse(source, false, true).resolveObject(relative);
	}

	Url.prototype.resolveObject = function(relative) {
	  if (isString(relative)) {
	    var rel = new Url();
	    rel.parse(relative, false, true);
	    relative = rel;
	  }

	  var result = new Url();
	  var tkeys = Object.keys(this);
	  for (var tk = 0; tk < tkeys.length; tk++) {
	    var tkey = tkeys[tk];
	    result[tkey] = this[tkey];
	  }

	  // hash is always overridden, no matter what.
	  // even href="" will remove it.
	  result.hash = relative.hash;

	  // if the relative url is empty, then there's nothing left to do here.
	  if (relative.href === '') {
	    result.href = result.format();
	    return result;
	  }

	  // hrefs like //foo/bar always cut to the protocol.
	  if (relative.slashes && !relative.protocol) {
	    // take everything except the protocol from relative
	    var rkeys = Object.keys(relative);
	    for (var rk = 0; rk < rkeys.length; rk++) {
	      var rkey = rkeys[rk];
	      if (rkey !== 'protocol')
	        result[rkey] = relative[rkey];
	    }

	    //urlParse appends trailing / to urls like http://www.example.com
	    if (slashedProtocol[result.protocol] &&
	      result.hostname && !result.pathname) {
	      result.path = result.pathname = '/';
	    }

	    result.href = result.format();
	    return result;
	  }
	  var relPath;
	  if (relative.protocol && relative.protocol !== result.protocol) {
	    // if it's a known url protocol, then changing
	    // the protocol does weird things
	    // first, if it's not file:, then we MUST have a host,
	    // and if there was a path
	    // to begin with, then we MUST have a path.
	    // if it is file:, then the host is dropped,
	    // because that's known to be hostless.
	    // anything else is assumed to be absolute.
	    if (!slashedProtocol[relative.protocol]) {
	      var keys = Object.keys(relative);
	      for (var v = 0; v < keys.length; v++) {
	        var k = keys[v];
	        result[k] = relative[k];
	      }
	      result.href = result.format();
	      return result;
	    }

	    result.protocol = relative.protocol;
	    if (!relative.host && !hostlessProtocol[relative.protocol]) {
	      relPath = (relative.pathname || '').split('/');
	      while (relPath.length && !(relative.host = relPath.shift()));
	      if (!relative.host) relative.host = '';
	      if (!relative.hostname) relative.hostname = '';
	      if (relPath[0] !== '') relPath.unshift('');
	      if (relPath.length < 2) relPath.unshift('');
	      result.pathname = relPath.join('/');
	    } else {
	      result.pathname = relative.pathname;
	    }
	    result.search = relative.search;
	    result.query = relative.query;
	    result.host = relative.host || '';
	    result.auth = relative.auth;
	    result.hostname = relative.hostname || relative.host;
	    result.port = relative.port;
	    // to support http.request
	    if (result.pathname || result.search) {
	      var p = result.pathname || '';
	      var s = result.search || '';
	      result.path = p + s;
	    }
	    result.slashes = result.slashes || relative.slashes;
	    result.href = result.format();
	    return result;
	  }

	  var isSourceAbs = (result.pathname && result.pathname.charAt(0) === '/'),
	    isRelAbs = (
	      relative.host ||
	      relative.pathname && relative.pathname.charAt(0) === '/'
	    ),
	    mustEndAbs = (isRelAbs || isSourceAbs ||
	      (result.host && relative.pathname)),
	    removeAllDots = mustEndAbs,
	    srcPath = result.pathname && result.pathname.split('/') || [],
	    psychotic = result.protocol && !slashedProtocol[result.protocol];
	  relPath = relative.pathname && relative.pathname.split('/') || [];
	  // if the url is a non-slashed url, then relative
	  // links like ../.. should be able
	  // to crawl up to the hostname, as well.  This is strange.
	  // result.protocol has already been set by now.
	  // Later on, put the first path part into the host field.
	  if (psychotic) {
	    result.hostname = '';
	    result.port = null;
	    if (result.host) {
	      if (srcPath[0] === '') srcPath[0] = result.host;
	      else srcPath.unshift(result.host);
	    }
	    result.host = '';
	    if (relative.protocol) {
	      relative.hostname = null;
	      relative.port = null;
	      if (relative.host) {
	        if (relPath[0] === '') relPath[0] = relative.host;
	        else relPath.unshift(relative.host);
	      }
	      relative.host = null;
	    }
	    mustEndAbs = mustEndAbs && (relPath[0] === '' || srcPath[0] === '');
	  }
	  var authInHost;
	  if (isRelAbs) {
	    // it's absolute.
	    result.host = (relative.host || relative.host === '') ?
	      relative.host : result.host;
	    result.hostname = (relative.hostname || relative.hostname === '') ?
	      relative.hostname : result.hostname;
	    result.search = relative.search;
	    result.query = relative.query;
	    srcPath = relPath;
	    // fall through to the dot-handling below.
	  } else if (relPath.length) {
	    // it's relative
	    // throw away the existing file, and take the new path instead.
	    if (!srcPath) srcPath = [];
	    srcPath.pop();
	    srcPath = srcPath.concat(relPath);
	    result.search = relative.search;
	    result.query = relative.query;
	  } else if (!isNullOrUndefined(relative.search)) {
	    // just pull out the search.
	    // like href='?foo'.
	    // Put this after the other two cases because it simplifies the booleans
	    if (psychotic) {
	      result.hostname = result.host = srcPath.shift();
	      //occationaly the auth can get stuck only in host
	      //this especially happens in cases like
	      //url.resolveObject('mailto:local1@domain1', 'local2@domain2')
	      authInHost = result.host && result.host.indexOf('@') > 0 ?
	        result.host.split('@') : false;
	      if (authInHost) {
	        result.auth = authInHost.shift();
	        result.host = result.hostname = authInHost.shift();
	      }
	    }
	    result.search = relative.search;
	    result.query = relative.query;
	    //to support http.request
	    if (!isNull(result.pathname) || !isNull(result.search)) {
	      result.path = (result.pathname ? result.pathname : '') +
	        (result.search ? result.search : '');
	    }
	    result.href = result.format();
	    return result;
	  }

	  if (!srcPath.length) {
	    // no path at all.  easy.
	    // we've already handled the other stuff above.
	    result.pathname = null;
	    //to support http.request
	    if (result.search) {
	      result.path = '/' + result.search;
	    } else {
	      result.path = null;
	    }
	    result.href = result.format();
	    return result;
	  }

	  // if a url ENDs in . or .., then it must get a trailing slash.
	  // however, if it ends in anything else non-slashy,
	  // then it must NOT get a trailing slash.
	  var last = srcPath.slice(-1)[0];
	  var hasTrailingSlash = (
	    (result.host || relative.host || srcPath.length > 1) &&
	    (last === '.' || last === '..') || last === '');

	  // strip single dots, resolve double dots to parent dir
	  // if the path tries to go above the root, `up` ends up > 0
	  var up = 0;
	  for (var i = srcPath.length; i >= 0; i--) {
	    last = srcPath[i];
	    if (last === '.') {
	      srcPath.splice(i, 1);
	    } else if (last === '..') {
	      srcPath.splice(i, 1);
	      up++;
	    } else if (up) {
	      srcPath.splice(i, 1);
	      up--;
	    }
	  }

	  // if the path is allowed to go above the root, restore leading ..s
	  if (!mustEndAbs && !removeAllDots) {
	    for (; up--; up) {
	      srcPath.unshift('..');
	    }
	  }

	  if (mustEndAbs && srcPath[0] !== '' &&
	    (!srcPath[0] || srcPath[0].charAt(0) !== '/')) {
	    srcPath.unshift('');
	  }

	  if (hasTrailingSlash && (srcPath.join('/').substr(-1) !== '/')) {
	    srcPath.push('');
	  }

	  var isAbsolute = srcPath[0] === '' ||
	    (srcPath[0] && srcPath[0].charAt(0) === '/');

	  // put the host back
	  if (psychotic) {
	    result.hostname = result.host = isAbsolute ? '' :
	      srcPath.length ? srcPath.shift() : '';
	    //occationaly the auth can get stuck only in host
	    //this especially happens in cases like
	    //url.resolveObject('mailto:local1@domain1', 'local2@domain2')
	    authInHost = result.host && result.host.indexOf('@') > 0 ?
	      result.host.split('@') : false;
	    if (authInHost) {
	      result.auth = authInHost.shift();
	      result.host = result.hostname = authInHost.shift();
	    }
	  }

	  mustEndAbs = mustEndAbs || (result.host && srcPath.length);

	  if (mustEndAbs && !isAbsolute) {
	    srcPath.unshift('');
	  }

	  if (!srcPath.length) {
	    result.pathname = null;
	    result.path = null;
	  } else {
	    result.pathname = srcPath.join('/');
	  }

	  //to support request.http
	  if (!isNull(result.pathname) || !isNull(result.search)) {
	    result.path = (result.pathname ? result.pathname : '') +
	      (result.search ? result.search : '');
	  }
	  result.auth = relative.auth || result.auth;
	  result.slashes = result.slashes || relative.slashes;
	  result.href = result.format();
	  return result;
	};

	Url.prototype.parseHost = function() {
	  return parseHost(this);
	};

	function parseHost(self) {
	  var host = self.host;
	  var port = portPattern.exec(host);
	  if (port) {
	    port = port[0];
	    if (port !== ':') {
	      self.port = port.substr(1);
	    }
	    host = host.substr(0, host.length - port.length);
	  }
	  if (host) self.hostname = host;
	}

	var _polyfillNode_url$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		URL: URL,
		URLSearchParams: URLSearchParams,
		Url: Url,
		default: _polyfillNode_url,
		fileURLToPath: urlFileURLToPath,
		format: urlFormat,
		parse: urlParse,
		resolve: urlResolve,
		resolveObject: urlResolveObject
	});

	function request$1(opts, cb) {
	  if (typeof opts === 'string')
	    opts = urlParse(opts);


	  // Normally, the page is loaded from http or https, so not specifying a protocol
	  // will result in a (valid) protocol-relative url. However, this won't work if
	  // the protocol is something else, like 'file:'
	  var defaultProtocol = global$1.location.protocol.search(/^https?:$/) === -1 ? 'http:' : '';

	  var protocol = opts.protocol || defaultProtocol;
	  var host = opts.hostname || opts.host;
	  var port = opts.port;
	  var path = opts.path || '/';

	  // Necessary for IPv6 addresses
	  if (host && host.indexOf(':') !== -1)
	    host = '[' + host + ']';

	  // This may be a relative url. The browser should always be able to interpret it correctly.
	  opts.url = (host ? (protocol + '//' + host) : '') + (port ? ':' + port : '') + path;
	  opts.method = (opts.method || 'GET').toUpperCase();
	  opts.headers = opts.headers || {};

	  // Also valid opts.auth, opts.mode

	  var req = new ClientRequest(opts);
	  if (cb)
	    req.on('response', cb);
	  return req
	}

	function get$2(opts, cb) {
	  var req = request$1(opts, cb);
	  req.end();
	  return req
	}

	function Agent$1() {}
	Agent$1.defaultMaxSockets = 4;

	var METHODS$1 = [
	  'CHECKOUT',
	  'CONNECT',
	  'COPY',
	  'DELETE',
	  'GET',
	  'HEAD',
	  'LOCK',
	  'M-SEARCH',
	  'MERGE',
	  'MKACTIVITY',
	  'MKCOL',
	  'MOVE',
	  'NOTIFY',
	  'OPTIONS',
	  'PATCH',
	  'POST',
	  'PROPFIND',
	  'PROPPATCH',
	  'PURGE',
	  'PUT',
	  'REPORT',
	  'SEARCH',
	  'SUBSCRIBE',
	  'TRACE',
	  'UNLOCK',
	  'UNSUBSCRIBE'
	];
	var STATUS_CODES$1 = {
	  100: 'Continue',
	  101: 'Switching Protocols',
	  102: 'Processing', // RFC 2518, obsoleted by RFC 4918
	  200: 'OK',
	  201: 'Created',
	  202: 'Accepted',
	  203: 'Non-Authoritative Information',
	  204: 'No Content',
	  205: 'Reset Content',
	  206: 'Partial Content',
	  207: 'Multi-Status', // RFC 4918
	  300: 'Multiple Choices',
	  301: 'Moved Permanently',
	  302: 'Moved Temporarily',
	  303: 'See Other',
	  304: 'Not Modified',
	  305: 'Use Proxy',
	  307: 'Temporary Redirect',
	  400: 'Bad Request',
	  401: 'Unauthorized',
	  402: 'Payment Required',
	  403: 'Forbidden',
	  404: 'Not Found',
	  405: 'Method Not Allowed',
	  406: 'Not Acceptable',
	  407: 'Proxy Authentication Required',
	  408: 'Request Time-out',
	  409: 'Conflict',
	  410: 'Gone',
	  411: 'Length Required',
	  412: 'Precondition Failed',
	  413: 'Request Entity Too Large',
	  414: 'Request-URI Too Large',
	  415: 'Unsupported Media Type',
	  416: 'Requested Range Not Satisfiable',
	  417: 'Expectation Failed',
	  418: 'I\'m a teapot', // RFC 2324
	  422: 'Unprocessable Entity', // RFC 4918
	  423: 'Locked', // RFC 4918
	  424: 'Failed Dependency', // RFC 4918
	  425: 'Unordered Collection', // RFC 4918
	  426: 'Upgrade Required', // RFC 2817
	  428: 'Precondition Required', // RFC 6585
	  429: 'Too Many Requests', // RFC 6585
	  431: 'Request Header Fields Too Large', // RFC 6585
	  500: 'Internal Server Error',
	  501: 'Not Implemented',
	  502: 'Bad Gateway',
	  503: 'Service Unavailable',
	  504: 'Gateway Time-out',
	  505: 'HTTP Version Not Supported',
	  506: 'Variant Also Negotiates', // RFC 2295
	  507: 'Insufficient Storage', // RFC 4918
	  509: 'Bandwidth Limit Exceeded',
	  510: 'Not Extended', // RFC 2774
	  511: 'Network Authentication Required' // RFC 6585
	};

	var _polyfillNode_http = {
	  request: request$1,
	  get: get$2,
	  Agent: Agent$1,
	  METHODS: METHODS$1,
	  STATUS_CODES: STATUS_CODES$1
	};

	var _polyfillNode_http$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		Agent: Agent$1,
		METHODS: METHODS$1,
		STATUS_CODES: STATUS_CODES$1,
		default: _polyfillNode_http,
		get: get$2,
		request: request$1
	});

	var require$$0$2 = /*@__PURE__*/getAugmentedNamespace(_polyfillNode_http$1);

	function request(opts, cb) {
	  if (typeof opts === 'string')
	    opts = urlParse(opts);


	  // Normally, the page is loaded from http or https, so not specifying a protocol
	  // will result in a (valid) protocol-relative url. However, this won't work if
	  // the protocol is something else, like 'file:'
	  var defaultProtocol = global$1.location.protocol.search(/^https?:$/) === -1 ? 'http:' : '';

	  var protocol = opts.protocol || defaultProtocol;
	  var host = opts.hostname || opts.host;
	  var port = opts.port;
	  var path = opts.path || '/';

	  // Necessary for IPv6 addresses
	  if (host && host.indexOf(':') !== -1)
	    host = '[' + host + ']';

	  // This may be a relative url. The browser should always be able to interpret it correctly.
	  opts.url = (host ? (protocol + '//' + host) : '') + (port ? ':' + port : '') + path;
	  opts.method = (opts.method || 'GET').toUpperCase();
	  opts.headers = opts.headers || {};

	  // Also valid opts.auth, opts.mode

	  var req = new ClientRequest(opts);
	  if (cb)
	    req.on('response', cb);
	  return req
	}

	function get$1(opts, cb) {
	  var req = request(opts, cb);
	  req.end();
	  return req
	}

	function Agent() {}
	Agent.defaultMaxSockets = 4;

	var METHODS = [
	  'CHECKOUT',
	  'CONNECT',
	  'COPY',
	  'DELETE',
	  'GET',
	  'HEAD',
	  'LOCK',
	  'M-SEARCH',
	  'MERGE',
	  'MKACTIVITY',
	  'MKCOL',
	  'MOVE',
	  'NOTIFY',
	  'OPTIONS',
	  'PATCH',
	  'POST',
	  'PROPFIND',
	  'PROPPATCH',
	  'PURGE',
	  'PUT',
	  'REPORT',
	  'SEARCH',
	  'SUBSCRIBE',
	  'TRACE',
	  'UNLOCK',
	  'UNSUBSCRIBE'
	];
	var STATUS_CODES = {
	  100: 'Continue',
	  101: 'Switching Protocols',
	  102: 'Processing', // RFC 2518, obsoleted by RFC 4918
	  200: 'OK',
	  201: 'Created',
	  202: 'Accepted',
	  203: 'Non-Authoritative Information',
	  204: 'No Content',
	  205: 'Reset Content',
	  206: 'Partial Content',
	  207: 'Multi-Status', // RFC 4918
	  300: 'Multiple Choices',
	  301: 'Moved Permanently',
	  302: 'Moved Temporarily',
	  303: 'See Other',
	  304: 'Not Modified',
	  305: 'Use Proxy',
	  307: 'Temporary Redirect',
	  400: 'Bad Request',
	  401: 'Unauthorized',
	  402: 'Payment Required',
	  403: 'Forbidden',
	  404: 'Not Found',
	  405: 'Method Not Allowed',
	  406: 'Not Acceptable',
	  407: 'Proxy Authentication Required',
	  408: 'Request Time-out',
	  409: 'Conflict',
	  410: 'Gone',
	  411: 'Length Required',
	  412: 'Precondition Failed',
	  413: 'Request Entity Too Large',
	  414: 'Request-URI Too Large',
	  415: 'Unsupported Media Type',
	  416: 'Requested Range Not Satisfiable',
	  417: 'Expectation Failed',
	  418: 'I\'m a teapot', // RFC 2324
	  422: 'Unprocessable Entity', // RFC 4918
	  423: 'Locked', // RFC 4918
	  424: 'Failed Dependency', // RFC 4918
	  425: 'Unordered Collection', // RFC 4918
	  426: 'Upgrade Required', // RFC 2817
	  428: 'Precondition Required', // RFC 6585
	  429: 'Too Many Requests', // RFC 6585
	  431: 'Request Header Fields Too Large', // RFC 6585
	  500: 'Internal Server Error',
	  501: 'Not Implemented',
	  502: 'Bad Gateway',
	  503: 'Service Unavailable',
	  504: 'Gateway Time-out',
	  505: 'HTTP Version Not Supported',
	  506: 'Variant Also Negotiates', // RFC 2295
	  507: 'Insufficient Storage', // RFC 4918
	  509: 'Bandwidth Limit Exceeded',
	  510: 'Not Extended', // RFC 2774
	  511: 'Network Authentication Required' // RFC 6585
	};

	var _polyfillNode_https = {
	  request,
	  get: get$1,
	  Agent,
	  METHODS,
	  STATUS_CODES
	};

	var _polyfillNode_https$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		Agent: Agent,
		METHODS: METHODS,
		STATUS_CODES: STATUS_CODES,
		default: _polyfillNode_https,
		get: get$1,
		request: request
	});

	var require$$1$1 = /*@__PURE__*/getAugmentedNamespace(_polyfillNode_https$1);

	var require$$0$1 = /*@__PURE__*/getAugmentedNamespace(_polyfillNode_url$1);

	var isHttpResource_1;
	var hasRequiredIsHttpResource;

	function requireIsHttpResource () {
		if (hasRequiredIsHttpResource) return isHttpResource_1;
		hasRequiredIsHttpResource = 1;
		var HTTP_RESOURCE_PATTERN = /^http:\/\//;

		function isHttpResource(uri) {
		  return HTTP_RESOURCE_PATTERN.test(uri);
		}

		isHttpResource_1 = isHttpResource;
		return isHttpResource_1;
	}

	var isHttpsResource_1;
	var hasRequiredIsHttpsResource;

	function requireIsHttpsResource () {
		if (hasRequiredIsHttpsResource) return isHttpsResource_1;
		hasRequiredIsHttpsResource = 1;
		var HTTPS_RESOURCE_PATTERN = /^https:\/\//;

		function isHttpsResource(uri) {
		  return HTTPS_RESOURCE_PATTERN.test(uri);
		}

		isHttpsResource_1 = isHttpsResource;
		return isHttpsResource_1;
	}

	var loadRemoteResource_1;
	var hasRequiredLoadRemoteResource;

	function requireLoadRemoteResource () {
		if (hasRequiredLoadRemoteResource) return loadRemoteResource_1;
		hasRequiredLoadRemoteResource = 1;
		var http = require$$0$2;
		var https = require$$1$1;
		var url = require$$0$1;

		var isHttpResource = requireIsHttpResource();
		var isHttpsResource = requireIsHttpsResource();
		var override = requireOverride();

		var HTTP_PROTOCOL = 'http:';

		function loadRemoteResource(uri, inlineRequest, inlineTimeout, callback) {
		  var proxyProtocol = inlineRequest.protocol || inlineRequest.hostname;
		  var errorHandled = false;
		  var requestOptions;
		  var fetch;

		  requestOptions = override(
		    url.parse(uri),
		    inlineRequest || {}
		  );

		  if (inlineRequest.hostname !== undefined) {
		    // overwrite as we always expect a http proxy currently
		    requestOptions.protocol = inlineRequest.protocol || HTTP_PROTOCOL;
		    requestOptions.path = requestOptions.href;
		  }

		  fetch = (proxyProtocol && !isHttpsResource(proxyProtocol)) || isHttpResource(uri)
		    ? http.get
		    : https.get;

		  fetch(requestOptions, function(res) {
		    var chunks = [];
		    var movedUri;

		    if (errorHandled) {
		      return;
		    }

		    if (res.statusCode < 200 || res.statusCode > 399) {
		      return callback(res.statusCode, null);
		    } if (res.statusCode > 299) {
		      movedUri = url.resolve(uri, res.headers.location);
		      return loadRemoteResource(movedUri, inlineRequest, inlineTimeout, callback);
		    }

		    res.on('data', function(chunk) {
		      chunks.push(chunk.toString());
		    });
		    res.on('end', function() {
		      var body = chunks.join('');
		      callback(null, body);
		    });
		  })
		    .on('error', function(res) {
		      if (errorHandled) {
		        return;
		      }

		      errorHandled = true;
		      callback(res.message, null);
		    })
		    .on('timeout', function() {
		      if (errorHandled) {
		        return;
		      }

		      errorHandled = true;
		      callback('timeout', null);
		    })
		    .setTimeout(inlineTimeout);
		}

		loadRemoteResource_1 = loadRemoteResource;
		return loadRemoteResource_1;
	}

	var fetch;
	var hasRequiredFetch;

	function requireFetch () {
		if (hasRequiredFetch) return fetch;
		hasRequiredFetch = 1;
		var loadRemoteResource = requireLoadRemoteResource();

		function fetchFrom(callback) {
		  return callback || loadRemoteResource;
		}

		fetch = fetchFrom;
		return fetch;
	}

	var inline$1;
	var hasRequiredInline;

	function requireInline () {
		if (hasRequiredInline) return inline$1;
		hasRequiredInline = 1;
		function inlineOptionsFrom(rules) {
		  if (Array.isArray(rules)) {
		    return rules;
		  }

		  if (rules === false) {
		    return ['none'];
		  }

		  return undefined === rules
		    ? ['local']
		    : rules.split(',');
		}

		inline$1 = inlineOptionsFrom;
		return inline$1;
	}

	var inlineRequest;
	var hasRequiredInlineRequest;

	function requireInlineRequest () {
		if (hasRequiredInlineRequest) return inlineRequest;
		hasRequiredInlineRequest = 1;
		var url = require$$0$1;

		var override = requireOverride();

		function inlineRequestFrom(option) {
		  return override(
		    /* jshint camelcase: false */
		    proxyOptionsFrom(browser$1.env.HTTP_PROXY || browser$1.env.http_proxy),
		    option || {}
		  );
		}

		function proxyOptionsFrom(httpProxy) {
		  return httpProxy
		    ? {
		      hostname: url.parse(httpProxy).hostname,
		      port: parseInt(url.parse(httpProxy).port)
		    }
		    : {};
		}

		inlineRequest = inlineRequestFrom;
		return inlineRequest;
	}

	var inlineTimeout;
	var hasRequiredInlineTimeout;

	function requireInlineTimeout () {
		if (hasRequiredInlineTimeout) return inlineTimeout;
		hasRequiredInlineTimeout = 1;
		var DEFAULT_TIMEOUT = 5000;

		function inlineTimeoutFrom(option) {
		  return option || DEFAULT_TIMEOUT;
		}

		inlineTimeout = inlineTimeoutFrom;
		return inlineTimeout;
	}

	var plugins;
	var hasRequiredPlugins;

	function requirePlugins () {
		if (hasRequiredPlugins) return plugins;
		hasRequiredPlugins = 1;
		function pluginsFrom(plugins) {
		  var flatPlugins = {
		    level1Value: [],
		    level1Property: [],
		    level2Block: []
		  };

		  plugins = plugins || [];

		  flatPlugins.level1Value = plugins
		    .map(function(plugin) { return plugin.level1 && plugin.level1.value; })
		    .filter(function(plugin) { return plugin != null; });

		  flatPlugins.level1Property = plugins
		    .map(function(plugin) { return plugin.level1 && plugin.level1.property; })
		    .filter(function(plugin) { return plugin != null; });

		  flatPlugins.level2Block = plugins
		    .map(function(plugin) { return plugin.level2 && plugin.level2.block; })
		    .filter(function(plugin) { return plugin != null; });

		  return flatPlugins;
		}

		plugins = pluginsFrom;
		return plugins;
	}

	var rebase;
	var hasRequiredRebase$1;

	function requireRebase$1 () {
		if (hasRequiredRebase$1) return rebase;
		hasRequiredRebase$1 = 1;
		function rebaseFrom(rebaseOption, rebaseToOption) {
		  if (undefined !== rebaseToOption) {
		    return true;
		  } if (undefined === rebaseOption) {
		    return false;
		  }
		  return !!rebaseOption;
		}

		rebase = rebaseFrom;
		return rebase;
	}

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	// resolves . and .. elements in a path array with directory names there
	// must be no slashes, empty elements, or device names (c:\) in the array
	// (so also no leading and trailing slashes - it does not distinguish
	// relative and absolute paths)
	function normalizeArray(parts, allowAboveRoot) {
	  // if the path tries to go above the root, `up` ends up > 0
	  var up = 0;
	  for (var i = parts.length - 1; i >= 0; i--) {
	    var last = parts[i];
	    if (last === '.') {
	      parts.splice(i, 1);
	    } else if (last === '..') {
	      parts.splice(i, 1);
	      up++;
	    } else if (up) {
	      parts.splice(i, 1);
	      up--;
	    }
	  }

	  // if the path is allowed to go above the root, restore leading ..s
	  if (allowAboveRoot) {
	    for (; up--; up) {
	      parts.unshift('..');
	    }
	  }

	  return parts;
	}

	// Split a filename into [root, dir, basename, ext], unix version
	// 'root' is just a slash, or nothing.
	var splitPathRe =
	    /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
	var splitPath = function(filename) {
	  return splitPathRe.exec(filename).slice(1);
	};

	// path.resolve([from ...], to)
	// posix version
	function resolve$2() {
	  var resolvedPath = '',
	      resolvedAbsolute = false;

	  for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
	    var path = (i >= 0) ? arguments[i] : '/';

	    // Skip empty and invalid entries
	    if (typeof path !== 'string') {
	      throw new TypeError('Arguments to path.resolve must be strings');
	    } else if (!path) {
	      continue;
	    }

	    resolvedPath = path + '/' + resolvedPath;
	    resolvedAbsolute = path.charAt(0) === '/';
	  }

	  // At this point the path should be resolved to a full absolute path, but
	  // handle relative paths to be safe (might happen when process.cwd() fails)

	  // Normalize the path
	  resolvedPath = normalizeArray(filter(resolvedPath.split('/'), function(p) {
	    return !!p;
	  }), !resolvedAbsolute).join('/');

	  return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
	}
	// path.normalize(path)
	// posix version
	function normalize(path) {
	  var isPathAbsolute = isAbsolute(path),
	      trailingSlash = substr(path, -1) === '/';

	  // Normalize the path
	  path = normalizeArray(filter(path.split('/'), function(p) {
	    return !!p;
	  }), !isPathAbsolute).join('/');

	  if (!path && !isPathAbsolute) {
	    path = '.';
	  }
	  if (path && trailingSlash) {
	    path += '/';
	  }

	  return (isPathAbsolute ? '/' : '') + path;
	}
	// posix version
	function isAbsolute(path) {
	  return path.charAt(0) === '/';
	}

	// posix version
	function join() {
	  var paths = Array.prototype.slice.call(arguments, 0);
	  return normalize(filter(paths, function(p, index) {
	    if (typeof p !== 'string') {
	      throw new TypeError('Arguments to path.join must be strings');
	    }
	    return p;
	  }).join('/'));
	}


	// path.relative(from, to)
	// posix version
	function relative(from, to) {
	  from = resolve$2(from).substr(1);
	  to = resolve$2(to).substr(1);

	  function trim(arr) {
	    var start = 0;
	    for (; start < arr.length; start++) {
	      if (arr[start] !== '') break;
	    }

	    var end = arr.length - 1;
	    for (; end >= 0; end--) {
	      if (arr[end] !== '') break;
	    }

	    if (start > end) return [];
	    return arr.slice(start, end - start + 1);
	  }

	  var fromParts = trim(from.split('/'));
	  var toParts = trim(to.split('/'));

	  var length = Math.min(fromParts.length, toParts.length);
	  var samePartsLength = length;
	  for (var i = 0; i < length; i++) {
	    if (fromParts[i] !== toParts[i]) {
	      samePartsLength = i;
	      break;
	    }
	  }

	  var outputParts = [];
	  for (var i = samePartsLength; i < fromParts.length; i++) {
	    outputParts.push('..');
	  }

	  outputParts = outputParts.concat(toParts.slice(samePartsLength));

	  return outputParts.join('/');
	}

	var sep = '/';
	var delimiter = ':';

	function dirname(path) {
	  var result = splitPath(path),
	      root = result[0],
	      dir = result[1];

	  if (!root && !dir) {
	    // No dirname whatsoever
	    return '.';
	  }

	  if (dir) {
	    // It has a dirname, strip trailing slash
	    dir = dir.substr(0, dir.length - 1);
	  }

	  return root + dir;
	}

	function basename(path, ext) {
	  var f = splitPath(path)[2];
	  // TODO: make this comparison case-insensitive on windows?
	  if (ext && f.substr(-1 * ext.length) === ext) {
	    f = f.substr(0, f.length - ext.length);
	  }
	  return f;
	}


	function extname(path) {
	  return splitPath(path)[3];
	}
	var _polyfillNode_path = {
	  extname: extname,
	  basename: basename,
	  dirname: dirname,
	  sep: sep,
	  delimiter: delimiter,
	  relative: relative,
	  join: join,
	  isAbsolute: isAbsolute,
	  normalize: normalize,
	  resolve: resolve$2
	};
	function filter (xs, f) {
	    if (xs.filter) return xs.filter(f);
	    var res = [];
	    for (var i = 0; i < xs.length; i++) {
	        if (f(xs[i], i, xs)) res.push(xs[i]);
	    }
	    return res;
	}

	// String.prototype.substr - negative index don't work in IE8
	var substr = 'ab'.substr(-1) === 'b' ?
	    function (str, start, len) { return str.substr(start, len) } :
	    function (str, start, len) {
	        if (start < 0) start = str.length + start;
	        return str.substr(start, len);
	    }
	;

	var _polyfillNode_path$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		basename: basename,
		default: _polyfillNode_path,
		delimiter: delimiter,
		dirname: dirname,
		extname: extname,
		isAbsolute: isAbsolute,
		join: join,
		normalize: normalize,
		relative: relative,
		resolve: resolve$2,
		sep: sep
	});

	var require$$1 = /*@__PURE__*/getAugmentedNamespace(_polyfillNode_path$1);

	var rebaseTo;
	var hasRequiredRebaseTo;

	function requireRebaseTo () {
		if (hasRequiredRebaseTo) return rebaseTo;
		hasRequiredRebaseTo = 1;
		var path = require$$1;

		function rebaseToFrom(option) {
		  return option ? path.resolve(option) : browser$1.cwd();
		}

		rebaseTo = rebaseToFrom;
		return rebaseTo;
	}

	var sourceMap = {};

	var sourceMapGenerator = {};

	var base64Vlq = {};

	var base64 = {};

	/* -*- Mode: js; js-indent-level: 2; -*- */

	var hasRequiredBase64;

	function requireBase64 () {
		if (hasRequiredBase64) return base64;
		hasRequiredBase64 = 1;
		/*
		 * Copyright 2011 Mozilla Foundation and contributors
		 * Licensed under the New BSD license. See LICENSE or:
		 * http://opensource.org/licenses/BSD-3-Clause
		 */

		var intToCharMap = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'.split('');

		/**
		 * Encode an integer in the range of 0 to 63 to a single base 64 digit.
		 */
		base64.encode = function (number) {
		  if (0 <= number && number < intToCharMap.length) {
		    return intToCharMap[number];
		  }
		  throw new TypeError("Must be between 0 and 63: " + number);
		};

		/**
		 * Decode a single base 64 character code digit to an integer. Returns -1 on
		 * failure.
		 */
		base64.decode = function (charCode) {
		  var bigA = 65;     // 'A'
		  var bigZ = 90;     // 'Z'

		  var littleA = 97;  // 'a'
		  var littleZ = 122; // 'z'

		  var zero = 48;     // '0'
		  var nine = 57;     // '9'

		  var plus = 43;     // '+'
		  var slash = 47;    // '/'

		  var littleOffset = 26;
		  var numberOffset = 52;

		  // 0 - 25: ABCDEFGHIJKLMNOPQRSTUVWXYZ
		  if (bigA <= charCode && charCode <= bigZ) {
		    return (charCode - bigA);
		  }

		  // 26 - 51: abcdefghijklmnopqrstuvwxyz
		  if (littleA <= charCode && charCode <= littleZ) {
		    return (charCode - littleA + littleOffset);
		  }

		  // 52 - 61: 0123456789
		  if (zero <= charCode && charCode <= nine) {
		    return (charCode - zero + numberOffset);
		  }

		  // 62: +
		  if (charCode == plus) {
		    return 62;
		  }

		  // 63: /
		  if (charCode == slash) {
		    return 63;
		  }

		  // Invalid base64 digit.
		  return -1;
		};
		return base64;
	}

	/* -*- Mode: js; js-indent-level: 2; -*- */

	var hasRequiredBase64Vlq;

	function requireBase64Vlq () {
		if (hasRequiredBase64Vlq) return base64Vlq;
		hasRequiredBase64Vlq = 1;
		/*
		 * Copyright 2011 Mozilla Foundation and contributors
		 * Licensed under the New BSD license. See LICENSE or:
		 * http://opensource.org/licenses/BSD-3-Clause
		 *
		 * Based on the Base 64 VLQ implementation in Closure Compiler:
		 * https://code.google.com/p/closure-compiler/source/browse/trunk/src/com/google/debugging/sourcemap/Base64VLQ.java
		 *
		 * Copyright 2011 The Closure Compiler Authors. All rights reserved.
		 * Redistribution and use in source and binary forms, with or without
		 * modification, are permitted provided that the following conditions are
		 * met:
		 *
		 *  * Redistributions of source code must retain the above copyright
		 *    notice, this list of conditions and the following disclaimer.
		 *  * Redistributions in binary form must reproduce the above
		 *    copyright notice, this list of conditions and the following
		 *    disclaimer in the documentation and/or other materials provided
		 *    with the distribution.
		 *  * Neither the name of Google Inc. nor the names of its
		 *    contributors may be used to endorse or promote products derived
		 *    from this software without specific prior written permission.
		 *
		 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
		 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
		 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
		 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
		 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
		 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
		 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
		 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
		 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
		 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
		 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
		 */

		var base64 = requireBase64();

		// A single base 64 digit can contain 6 bits of data. For the base 64 variable
		// length quantities we use in the source map spec, the first bit is the sign,
		// the next four bits are the actual value, and the 6th bit is the
		// continuation bit. The continuation bit tells us whether there are more
		// digits in this value following this digit.
		//
		//   Continuation
		//   |    Sign
		//   |    |
		//   V    V
		//   101011

		var VLQ_BASE_SHIFT = 5;

		// binary: 100000
		var VLQ_BASE = 1 << VLQ_BASE_SHIFT;

		// binary: 011111
		var VLQ_BASE_MASK = VLQ_BASE - 1;

		// binary: 100000
		var VLQ_CONTINUATION_BIT = VLQ_BASE;

		/**
		 * Converts from a two-complement value to a value where the sign bit is
		 * placed in the least significant bit.  For example, as decimals:
		 *   1 becomes 2 (10 binary), -1 becomes 3 (11 binary)
		 *   2 becomes 4 (100 binary), -2 becomes 5 (101 binary)
		 */
		function toVLQSigned(aValue) {
		  return aValue < 0
		    ? ((-aValue) << 1) + 1
		    : (aValue << 1) + 0;
		}

		/**
		 * Converts to a two-complement value from a value where the sign bit is
		 * placed in the least significant bit.  For example, as decimals:
		 *   2 (10 binary) becomes 1, 3 (11 binary) becomes -1
		 *   4 (100 binary) becomes 2, 5 (101 binary) becomes -2
		 */
		function fromVLQSigned(aValue) {
		  var isNegative = (aValue & 1) === 1;
		  var shifted = aValue >> 1;
		  return isNegative
		    ? -shifted
		    : shifted;
		}

		/**
		 * Returns the base 64 VLQ encoded value.
		 */
		base64Vlq.encode = function base64VLQ_encode(aValue) {
		  var encoded = "";
		  var digit;

		  var vlq = toVLQSigned(aValue);

		  do {
		    digit = vlq & VLQ_BASE_MASK;
		    vlq >>>= VLQ_BASE_SHIFT;
		    if (vlq > 0) {
		      // There are still more digits in this value, so we must make sure the
		      // continuation bit is marked.
		      digit |= VLQ_CONTINUATION_BIT;
		    }
		    encoded += base64.encode(digit);
		  } while (vlq > 0);

		  return encoded;
		};

		/**
		 * Decodes the next base 64 VLQ value from the given string and returns the
		 * value and the rest of the string via the out parameter.
		 */
		base64Vlq.decode = function base64VLQ_decode(aStr, aIndex, aOutParam) {
		  var strLen = aStr.length;
		  var result = 0;
		  var shift = 0;
		  var continuation, digit;

		  do {
		    if (aIndex >= strLen) {
		      throw new Error("Expected more digits in base 64 VLQ value.");
		    }

		    digit = base64.decode(aStr.charCodeAt(aIndex++));
		    if (digit === -1) {
		      throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
		    }

		    continuation = !!(digit & VLQ_CONTINUATION_BIT);
		    digit &= VLQ_BASE_MASK;
		    result = result + (digit << shift);
		    shift += VLQ_BASE_SHIFT;
		  } while (continuation);

		  aOutParam.value = fromVLQSigned(result);
		  aOutParam.rest = aIndex;
		};
		return base64Vlq;
	}

	var util = {};

	/* -*- Mode: js; js-indent-level: 2; -*- */

	var hasRequiredUtil;

	function requireUtil () {
		if (hasRequiredUtil) return util;
		hasRequiredUtil = 1;
		(function (exports) {
			/*
			 * Copyright 2011 Mozilla Foundation and contributors
			 * Licensed under the New BSD license. See LICENSE or:
			 * http://opensource.org/licenses/BSD-3-Clause
			 */

			/**
			 * This is a helper function for getting values from parameter/options
			 * objects.
			 *
			 * @param args The object we are extracting values from
			 * @param name The name of the property we are getting.
			 * @param defaultValue An optional value to return if the property is missing
			 * from the object. If this is not specified and the property is missing, an
			 * error will be thrown.
			 */
			function getArg(aArgs, aName, aDefaultValue) {
			  if (aName in aArgs) {
			    return aArgs[aName];
			  } else if (arguments.length === 3) {
			    return aDefaultValue;
			  } else {
			    throw new Error('"' + aName + '" is a required argument.');
			  }
			}
			exports.getArg = getArg;

			var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/;
			var dataUrlRegexp = /^data:.+\,.+$/;

			function urlParse(aUrl) {
			  var match = aUrl.match(urlRegexp);
			  if (!match) {
			    return null;
			  }
			  return {
			    scheme: match[1],
			    auth: match[2],
			    host: match[3],
			    port: match[4],
			    path: match[5]
			  };
			}
			exports.urlParse = urlParse;

			function urlGenerate(aParsedUrl) {
			  var url = '';
			  if (aParsedUrl.scheme) {
			    url += aParsedUrl.scheme + ':';
			  }
			  url += '//';
			  if (aParsedUrl.auth) {
			    url += aParsedUrl.auth + '@';
			  }
			  if (aParsedUrl.host) {
			    url += aParsedUrl.host;
			  }
			  if (aParsedUrl.port) {
			    url += ":" + aParsedUrl.port;
			  }
			  if (aParsedUrl.path) {
			    url += aParsedUrl.path;
			  }
			  return url;
			}
			exports.urlGenerate = urlGenerate;

			/**
			 * Normalizes a path, or the path portion of a URL:
			 *
			 * - Replaces consecutive slashes with one slash.
			 * - Removes unnecessary '.' parts.
			 * - Removes unnecessary '<dir>/..' parts.
			 *
			 * Based on code in the Node.js 'path' core module.
			 *
			 * @param aPath The path or url to normalize.
			 */
			function normalize(aPath) {
			  var path = aPath;
			  var url = urlParse(aPath);
			  if (url) {
			    if (!url.path) {
			      return aPath;
			    }
			    path = url.path;
			  }
			  var isAbsolute = exports.isAbsolute(path);

			  var parts = path.split(/\/+/);
			  for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
			    part = parts[i];
			    if (part === '.') {
			      parts.splice(i, 1);
			    } else if (part === '..') {
			      up++;
			    } else if (up > 0) {
			      if (part === '') {
			        // The first part is blank if the path is absolute. Trying to go
			        // above the root is a no-op. Therefore we can remove all '..' parts
			        // directly after the root.
			        parts.splice(i + 1, up);
			        up = 0;
			      } else {
			        parts.splice(i, 2);
			        up--;
			      }
			    }
			  }
			  path = parts.join('/');

			  if (path === '') {
			    path = isAbsolute ? '/' : '.';
			  }

			  if (url) {
			    url.path = path;
			    return urlGenerate(url);
			  }
			  return path;
			}
			exports.normalize = normalize;

			/**
			 * Joins two paths/URLs.
			 *
			 * @param aRoot The root path or URL.
			 * @param aPath The path or URL to be joined with the root.
			 *
			 * - If aPath is a URL or a data URI, aPath is returned, unless aPath is a
			 *   scheme-relative URL: Then the scheme of aRoot, if any, is prepended
			 *   first.
			 * - Otherwise aPath is a path. If aRoot is a URL, then its path portion
			 *   is updated with the result and aRoot is returned. Otherwise the result
			 *   is returned.
			 *   - If aPath is absolute, the result is aPath.
			 *   - Otherwise the two paths are joined with a slash.
			 * - Joining for example 'http://' and 'www.example.com' is also supported.
			 */
			function join(aRoot, aPath) {
			  if (aRoot === "") {
			    aRoot = ".";
			  }
			  if (aPath === "") {
			    aPath = ".";
			  }
			  var aPathUrl = urlParse(aPath);
			  var aRootUrl = urlParse(aRoot);
			  if (aRootUrl) {
			    aRoot = aRootUrl.path || '/';
			  }

			  // `join(foo, '//www.example.org')`
			  if (aPathUrl && !aPathUrl.scheme) {
			    if (aRootUrl) {
			      aPathUrl.scheme = aRootUrl.scheme;
			    }
			    return urlGenerate(aPathUrl);
			  }

			  if (aPathUrl || aPath.match(dataUrlRegexp)) {
			    return aPath;
			  }

			  // `join('http://', 'www.example.com')`
			  if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
			    aRootUrl.host = aPath;
			    return urlGenerate(aRootUrl);
			  }

			  var joined = aPath.charAt(0) === '/'
			    ? aPath
			    : normalize(aRoot.replace(/\/+$/, '') + '/' + aPath);

			  if (aRootUrl) {
			    aRootUrl.path = joined;
			    return urlGenerate(aRootUrl);
			  }
			  return joined;
			}
			exports.join = join;

			exports.isAbsolute = function (aPath) {
			  return aPath.charAt(0) === '/' || urlRegexp.test(aPath);
			};

			/**
			 * Make a path relative to a URL or another path.
			 *
			 * @param aRoot The root path or URL.
			 * @param aPath The path or URL to be made relative to aRoot.
			 */
			function relative(aRoot, aPath) {
			  if (aRoot === "") {
			    aRoot = ".";
			  }

			  aRoot = aRoot.replace(/\/$/, '');

			  // It is possible for the path to be above the root. In this case, simply
			  // checking whether the root is a prefix of the path won't work. Instead, we
			  // need to remove components from the root one by one, until either we find
			  // a prefix that fits, or we run out of components to remove.
			  var level = 0;
			  while (aPath.indexOf(aRoot + '/') !== 0) {
			    var index = aRoot.lastIndexOf("/");
			    if (index < 0) {
			      return aPath;
			    }

			    // If the only part of the root that is left is the scheme (i.e. http://,
			    // file:///, etc.), one or more slashes (/), or simply nothing at all, we
			    // have exhausted all components, so the path is not relative to the root.
			    aRoot = aRoot.slice(0, index);
			    if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
			      return aPath;
			    }

			    ++level;
			  }

			  // Make sure we add a "../" for each component we removed from the root.
			  return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
			}
			exports.relative = relative;

			var supportsNullProto = (function () {
			  var obj = Object.create(null);
			  return !('__proto__' in obj);
			}());

			function identity (s) {
			  return s;
			}

			/**
			 * Because behavior goes wacky when you set `__proto__` on objects, we
			 * have to prefix all the strings in our set with an arbitrary character.
			 *
			 * See https://github.com/mozilla/source-map/pull/31 and
			 * https://github.com/mozilla/source-map/issues/30
			 *
			 * @param String aStr
			 */
			function toSetString(aStr) {
			  if (isProtoString(aStr)) {
			    return '$' + aStr;
			  }

			  return aStr;
			}
			exports.toSetString = supportsNullProto ? identity : toSetString;

			function fromSetString(aStr) {
			  if (isProtoString(aStr)) {
			    return aStr.slice(1);
			  }

			  return aStr;
			}
			exports.fromSetString = supportsNullProto ? identity : fromSetString;

			function isProtoString(s) {
			  if (!s) {
			    return false;
			  }

			  var length = s.length;

			  if (length < 9 /* "__proto__".length */) {
			    return false;
			  }

			  if (s.charCodeAt(length - 1) !== 95  /* '_' */ ||
			      s.charCodeAt(length - 2) !== 95  /* '_' */ ||
			      s.charCodeAt(length - 3) !== 111 /* 'o' */ ||
			      s.charCodeAt(length - 4) !== 116 /* 't' */ ||
			      s.charCodeAt(length - 5) !== 111 /* 'o' */ ||
			      s.charCodeAt(length - 6) !== 114 /* 'r' */ ||
			      s.charCodeAt(length - 7) !== 112 /* 'p' */ ||
			      s.charCodeAt(length - 8) !== 95  /* '_' */ ||
			      s.charCodeAt(length - 9) !== 95  /* '_' */) {
			    return false;
			  }

			  for (var i = length - 10; i >= 0; i--) {
			    if (s.charCodeAt(i) !== 36 /* '$' */) {
			      return false;
			    }
			  }

			  return true;
			}

			/**
			 * Comparator between two mappings where the original positions are compared.
			 *
			 * Optionally pass in `true` as `onlyCompareGenerated` to consider two
			 * mappings with the same original source/line/column, but different generated
			 * line and column the same. Useful when searching for a mapping with a
			 * stubbed out mapping.
			 */
			function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
			  var cmp = strcmp(mappingA.source, mappingB.source);
			  if (cmp !== 0) {
			    return cmp;
			  }

			  cmp = mappingA.originalLine - mappingB.originalLine;
			  if (cmp !== 0) {
			    return cmp;
			  }

			  cmp = mappingA.originalColumn - mappingB.originalColumn;
			  if (cmp !== 0 || onlyCompareOriginal) {
			    return cmp;
			  }

			  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
			  if (cmp !== 0) {
			    return cmp;
			  }

			  cmp = mappingA.generatedLine - mappingB.generatedLine;
			  if (cmp !== 0) {
			    return cmp;
			  }

			  return strcmp(mappingA.name, mappingB.name);
			}
			exports.compareByOriginalPositions = compareByOriginalPositions;

			/**
			 * Comparator between two mappings with deflated source and name indices where
			 * the generated positions are compared.
			 *
			 * Optionally pass in `true` as `onlyCompareGenerated` to consider two
			 * mappings with the same generated line and column, but different
			 * source/name/original line and column the same. Useful when searching for a
			 * mapping with a stubbed out mapping.
			 */
			function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
			  var cmp = mappingA.generatedLine - mappingB.generatedLine;
			  if (cmp !== 0) {
			    return cmp;
			  }

			  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
			  if (cmp !== 0 || onlyCompareGenerated) {
			    return cmp;
			  }

			  cmp = strcmp(mappingA.source, mappingB.source);
			  if (cmp !== 0) {
			    return cmp;
			  }

			  cmp = mappingA.originalLine - mappingB.originalLine;
			  if (cmp !== 0) {
			    return cmp;
			  }

			  cmp = mappingA.originalColumn - mappingB.originalColumn;
			  if (cmp !== 0) {
			    return cmp;
			  }

			  return strcmp(mappingA.name, mappingB.name);
			}
			exports.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;

			function strcmp(aStr1, aStr2) {
			  if (aStr1 === aStr2) {
			    return 0;
			  }

			  if (aStr1 === null) {
			    return 1; // aStr2 !== null
			  }

			  if (aStr2 === null) {
			    return -1; // aStr1 !== null
			  }

			  if (aStr1 > aStr2) {
			    return 1;
			  }

			  return -1;
			}

			/**
			 * Comparator between two mappings with inflated source and name strings where
			 * the generated positions are compared.
			 */
			function compareByGeneratedPositionsInflated(mappingA, mappingB) {
			  var cmp = mappingA.generatedLine - mappingB.generatedLine;
			  if (cmp !== 0) {
			    return cmp;
			  }

			  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
			  if (cmp !== 0) {
			    return cmp;
			  }

			  cmp = strcmp(mappingA.source, mappingB.source);
			  if (cmp !== 0) {
			    return cmp;
			  }

			  cmp = mappingA.originalLine - mappingB.originalLine;
			  if (cmp !== 0) {
			    return cmp;
			  }

			  cmp = mappingA.originalColumn - mappingB.originalColumn;
			  if (cmp !== 0) {
			    return cmp;
			  }

			  return strcmp(mappingA.name, mappingB.name);
			}
			exports.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;

			/**
			 * Strip any JSON XSSI avoidance prefix from the string (as documented
			 * in the source maps specification), and then parse the string as
			 * JSON.
			 */
			function parseSourceMapInput(str) {
			  return JSON.parse(str.replace(/^\)]}'[^\n]*\n/, ''));
			}
			exports.parseSourceMapInput = parseSourceMapInput;

			/**
			 * Compute the URL of a source given the the source root, the source's
			 * URL, and the source map's URL.
			 */
			function computeSourceURL(sourceRoot, sourceURL, sourceMapURL) {
			  sourceURL = sourceURL || '';

			  if (sourceRoot) {
			    // This follows what Chrome does.
			    if (sourceRoot[sourceRoot.length - 1] !== '/' && sourceURL[0] !== '/') {
			      sourceRoot += '/';
			    }
			    // The spec says:
			    //   Line 4: An optional source root, useful for relocating source
			    //   files on a server or removing repeated values in the
			    //   “sources” entry.  This value is prepended to the individual
			    //   entries in the “source” field.
			    sourceURL = sourceRoot + sourceURL;
			  }

			  // Historically, SourceMapConsumer did not take the sourceMapURL as
			  // a parameter.  This mode is still somewhat supported, which is why
			  // this code block is conditional.  However, it's preferable to pass
			  // the source map URL to SourceMapConsumer, so that this function
			  // can implement the source URL resolution algorithm as outlined in
			  // the spec.  This block is basically the equivalent of:
			  //    new URL(sourceURL, sourceMapURL).toString()
			  // ... except it avoids using URL, which wasn't available in the
			  // older releases of node still supported by this library.
			  //
			  // The spec says:
			  //   If the sources are not absolute URLs after prepending of the
			  //   “sourceRoot”, the sources are resolved relative to the
			  //   SourceMap (like resolving script src in a html document).
			  if (sourceMapURL) {
			    var parsed = urlParse(sourceMapURL);
			    if (!parsed) {
			      throw new Error("sourceMapURL could not be parsed");
			    }
			    if (parsed.path) {
			      // Strip the last path component, but keep the "/".
			      var index = parsed.path.lastIndexOf('/');
			      if (index >= 0) {
			        parsed.path = parsed.path.substring(0, index + 1);
			      }
			    }
			    sourceURL = join(urlGenerate(parsed), sourceURL);
			  }

			  return normalize(sourceURL);
			}
			exports.computeSourceURL = computeSourceURL; 
		} (util));
		return util;
	}

	var arraySet = {};

	/* -*- Mode: js; js-indent-level: 2; -*- */

	var hasRequiredArraySet;

	function requireArraySet () {
		if (hasRequiredArraySet) return arraySet;
		hasRequiredArraySet = 1;
		/*
		 * Copyright 2011 Mozilla Foundation and contributors
		 * Licensed under the New BSD license. See LICENSE or:
		 * http://opensource.org/licenses/BSD-3-Clause
		 */

		var util = requireUtil();
		var has = Object.prototype.hasOwnProperty;
		var hasNativeMap = typeof Map !== "undefined";

		/**
		 * A data structure which is a combination of an array and a set. Adding a new
		 * member is O(1), testing for membership is O(1), and finding the index of an
		 * element is O(1). Removing elements from the set is not supported. Only
		 * strings are supported for membership.
		 */
		function ArraySet() {
		  this._array = [];
		  this._set = hasNativeMap ? new Map() : Object.create(null);
		}

		/**
		 * Static method for creating ArraySet instances from an existing array.
		 */
		ArraySet.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
		  var set = new ArraySet();
		  for (var i = 0, len = aArray.length; i < len; i++) {
		    set.add(aArray[i], aAllowDuplicates);
		  }
		  return set;
		};

		/**
		 * Return how many unique items are in this ArraySet. If duplicates have been
		 * added, than those do not count towards the size.
		 *
		 * @returns Number
		 */
		ArraySet.prototype.size = function ArraySet_size() {
		  return hasNativeMap ? this._set.size : Object.getOwnPropertyNames(this._set).length;
		};

		/**
		 * Add the given string to this set.
		 *
		 * @param String aStr
		 */
		ArraySet.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
		  var sStr = hasNativeMap ? aStr : util.toSetString(aStr);
		  var isDuplicate = hasNativeMap ? this.has(aStr) : has.call(this._set, sStr);
		  var idx = this._array.length;
		  if (!isDuplicate || aAllowDuplicates) {
		    this._array.push(aStr);
		  }
		  if (!isDuplicate) {
		    if (hasNativeMap) {
		      this._set.set(aStr, idx);
		    } else {
		      this._set[sStr] = idx;
		    }
		  }
		};

		/**
		 * Is the given string a member of this set?
		 *
		 * @param String aStr
		 */
		ArraySet.prototype.has = function ArraySet_has(aStr) {
		  if (hasNativeMap) {
		    return this._set.has(aStr);
		  } else {
		    var sStr = util.toSetString(aStr);
		    return has.call(this._set, sStr);
		  }
		};

		/**
		 * What is the index of the given string in the array?
		 *
		 * @param String aStr
		 */
		ArraySet.prototype.indexOf = function ArraySet_indexOf(aStr) {
		  if (hasNativeMap) {
		    var idx = this._set.get(aStr);
		    if (idx >= 0) {
		        return idx;
		    }
		  } else {
		    var sStr = util.toSetString(aStr);
		    if (has.call(this._set, sStr)) {
		      return this._set[sStr];
		    }
		  }

		  throw new Error('"' + aStr + '" is not in the set.');
		};

		/**
		 * What is the element at the given index?
		 *
		 * @param Number aIdx
		 */
		ArraySet.prototype.at = function ArraySet_at(aIdx) {
		  if (aIdx >= 0 && aIdx < this._array.length) {
		    return this._array[aIdx];
		  }
		  throw new Error('No element indexed by ' + aIdx);
		};

		/**
		 * Returns the array representation of this set (which has the proper indices
		 * indicated by indexOf). Note that this is a copy of the internal array used
		 * for storing the members so that no one can mess with internal state.
		 */
		ArraySet.prototype.toArray = function ArraySet_toArray() {
		  return this._array.slice();
		};

		arraySet.ArraySet = ArraySet;
		return arraySet;
	}

	var mappingList = {};

	/* -*- Mode: js; js-indent-level: 2; -*- */

	var hasRequiredMappingList;

	function requireMappingList () {
		if (hasRequiredMappingList) return mappingList;
		hasRequiredMappingList = 1;
		/*
		 * Copyright 2014 Mozilla Foundation and contributors
		 * Licensed under the New BSD license. See LICENSE or:
		 * http://opensource.org/licenses/BSD-3-Clause
		 */

		var util = requireUtil();

		/**
		 * Determine whether mappingB is after mappingA with respect to generated
		 * position.
		 */
		function generatedPositionAfter(mappingA, mappingB) {
		  // Optimized for most common case
		  var lineA = mappingA.generatedLine;
		  var lineB = mappingB.generatedLine;
		  var columnA = mappingA.generatedColumn;
		  var columnB = mappingB.generatedColumn;
		  return lineB > lineA || lineB == lineA && columnB >= columnA ||
		         util.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
		}

		/**
		 * A data structure to provide a sorted view of accumulated mappings in a
		 * performance conscious manner. It trades a neglibable overhead in general
		 * case for a large speedup in case of mappings being added in order.
		 */
		function MappingList() {
		  this._array = [];
		  this._sorted = true;
		  // Serves as infimum
		  this._last = {generatedLine: -1, generatedColumn: 0};
		}

		/**
		 * Iterate through internal items. This method takes the same arguments that
		 * `Array.prototype.forEach` takes.
		 *
		 * NOTE: The order of the mappings is NOT guaranteed.
		 */
		MappingList.prototype.unsortedForEach =
		  function MappingList_forEach(aCallback, aThisArg) {
		    this._array.forEach(aCallback, aThisArg);
		  };

		/**
		 * Add the given source mapping.
		 *
		 * @param Object aMapping
		 */
		MappingList.prototype.add = function MappingList_add(aMapping) {
		  if (generatedPositionAfter(this._last, aMapping)) {
		    this._last = aMapping;
		    this._array.push(aMapping);
		  } else {
		    this._sorted = false;
		    this._array.push(aMapping);
		  }
		};

		/**
		 * Returns the flat, sorted array of mappings. The mappings are sorted by
		 * generated position.
		 *
		 * WARNING: This method returns internal data without copying, for
		 * performance. The return value must NOT be mutated, and should be treated as
		 * an immutable borrow. If you want to take ownership, you must make your own
		 * copy.
		 */
		MappingList.prototype.toArray = function MappingList_toArray() {
		  if (!this._sorted) {
		    this._array.sort(util.compareByGeneratedPositionsInflated);
		    this._sorted = true;
		  }
		  return this._array;
		};

		mappingList.MappingList = MappingList;
		return mappingList;
	}

	/* -*- Mode: js; js-indent-level: 2; -*- */

	var hasRequiredSourceMapGenerator;

	function requireSourceMapGenerator () {
		if (hasRequiredSourceMapGenerator) return sourceMapGenerator;
		hasRequiredSourceMapGenerator = 1;
		/*
		 * Copyright 2011 Mozilla Foundation and contributors
		 * Licensed under the New BSD license. See LICENSE or:
		 * http://opensource.org/licenses/BSD-3-Clause
		 */

		var base64VLQ = requireBase64Vlq();
		var util = requireUtil();
		var ArraySet = requireArraySet().ArraySet;
		var MappingList = requireMappingList().MappingList;

		/**
		 * An instance of the SourceMapGenerator represents a source map which is
		 * being built incrementally. You may pass an object with the following
		 * properties:
		 *
		 *   - file: The filename of the generated source.
		 *   - sourceRoot: A root for all relative URLs in this source map.
		 */
		function SourceMapGenerator(aArgs) {
		  if (!aArgs) {
		    aArgs = {};
		  }
		  this._file = util.getArg(aArgs, 'file', null);
		  this._sourceRoot = util.getArg(aArgs, 'sourceRoot', null);
		  this._skipValidation = util.getArg(aArgs, 'skipValidation', false);
		  this._sources = new ArraySet();
		  this._names = new ArraySet();
		  this._mappings = new MappingList();
		  this._sourcesContents = null;
		}

		SourceMapGenerator.prototype._version = 3;

		/**
		 * Creates a new SourceMapGenerator based on a SourceMapConsumer
		 *
		 * @param aSourceMapConsumer The SourceMap.
		 */
		SourceMapGenerator.fromSourceMap =
		  function SourceMapGenerator_fromSourceMap(aSourceMapConsumer) {
		    var sourceRoot = aSourceMapConsumer.sourceRoot;
		    var generator = new SourceMapGenerator({
		      file: aSourceMapConsumer.file,
		      sourceRoot: sourceRoot
		    });
		    aSourceMapConsumer.eachMapping(function (mapping) {
		      var newMapping = {
		        generated: {
		          line: mapping.generatedLine,
		          column: mapping.generatedColumn
		        }
		      };

		      if (mapping.source != null) {
		        newMapping.source = mapping.source;
		        if (sourceRoot != null) {
		          newMapping.source = util.relative(sourceRoot, newMapping.source);
		        }

		        newMapping.original = {
		          line: mapping.originalLine,
		          column: mapping.originalColumn
		        };

		        if (mapping.name != null) {
		          newMapping.name = mapping.name;
		        }
		      }

		      generator.addMapping(newMapping);
		    });
		    aSourceMapConsumer.sources.forEach(function (sourceFile) {
		      var sourceRelative = sourceFile;
		      if (sourceRoot !== null) {
		        sourceRelative = util.relative(sourceRoot, sourceFile);
		      }

		      if (!generator._sources.has(sourceRelative)) {
		        generator._sources.add(sourceRelative);
		      }

		      var content = aSourceMapConsumer.sourceContentFor(sourceFile);
		      if (content != null) {
		        generator.setSourceContent(sourceFile, content);
		      }
		    });
		    return generator;
		  };

		/**
		 * Add a single mapping from original source line and column to the generated
		 * source's line and column for this source map being created. The mapping
		 * object should have the following properties:
		 *
		 *   - generated: An object with the generated line and column positions.
		 *   - original: An object with the original line and column positions.
		 *   - source: The original source file (relative to the sourceRoot).
		 *   - name: An optional original token name for this mapping.
		 */
		SourceMapGenerator.prototype.addMapping =
		  function SourceMapGenerator_addMapping(aArgs) {
		    var generated = util.getArg(aArgs, 'generated');
		    var original = util.getArg(aArgs, 'original', null);
		    var source = util.getArg(aArgs, 'source', null);
		    var name = util.getArg(aArgs, 'name', null);

		    if (!this._skipValidation) {
		      this._validateMapping(generated, original, source, name);
		    }

		    if (source != null) {
		      source = String(source);
		      if (!this._sources.has(source)) {
		        this._sources.add(source);
		      }
		    }

		    if (name != null) {
		      name = String(name);
		      if (!this._names.has(name)) {
		        this._names.add(name);
		      }
		    }

		    this._mappings.add({
		      generatedLine: generated.line,
		      generatedColumn: generated.column,
		      originalLine: original != null && original.line,
		      originalColumn: original != null && original.column,
		      source: source,
		      name: name
		    });
		  };

		/**
		 * Set the source content for a source file.
		 */
		SourceMapGenerator.prototype.setSourceContent =
		  function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
		    var source = aSourceFile;
		    if (this._sourceRoot != null) {
		      source = util.relative(this._sourceRoot, source);
		    }

		    if (aSourceContent != null) {
		      // Add the source content to the _sourcesContents map.
		      // Create a new _sourcesContents map if the property is null.
		      if (!this._sourcesContents) {
		        this._sourcesContents = Object.create(null);
		      }
		      this._sourcesContents[util.toSetString(source)] = aSourceContent;
		    } else if (this._sourcesContents) {
		      // Remove the source file from the _sourcesContents map.
		      // If the _sourcesContents map is empty, set the property to null.
		      delete this._sourcesContents[util.toSetString(source)];
		      if (Object.keys(this._sourcesContents).length === 0) {
		        this._sourcesContents = null;
		      }
		    }
		  };

		/**
		 * Applies the mappings of a sub-source-map for a specific source file to the
		 * source map being generated. Each mapping to the supplied source file is
		 * rewritten using the supplied source map. Note: The resolution for the
		 * resulting mappings is the minimium of this map and the supplied map.
		 *
		 * @param aSourceMapConsumer The source map to be applied.
		 * @param aSourceFile Optional. The filename of the source file.
		 *        If omitted, SourceMapConsumer's file property will be used.
		 * @param aSourceMapPath Optional. The dirname of the path to the source map
		 *        to be applied. If relative, it is relative to the SourceMapConsumer.
		 *        This parameter is needed when the two source maps aren't in the same
		 *        directory, and the source map to be applied contains relative source
		 *        paths. If so, those relative source paths need to be rewritten
		 *        relative to the SourceMapGenerator.
		 */
		SourceMapGenerator.prototype.applySourceMap =
		  function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
		    var sourceFile = aSourceFile;
		    // If aSourceFile is omitted, we will use the file property of the SourceMap
		    if (aSourceFile == null) {
		      if (aSourceMapConsumer.file == null) {
		        throw new Error(
		          'SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, ' +
		          'or the source map\'s "file" property. Both were omitted.'
		        );
		      }
		      sourceFile = aSourceMapConsumer.file;
		    }
		    var sourceRoot = this._sourceRoot;
		    // Make "sourceFile" relative if an absolute Url is passed.
		    if (sourceRoot != null) {
		      sourceFile = util.relative(sourceRoot, sourceFile);
		    }
		    // Applying the SourceMap can add and remove items from the sources and
		    // the names array.
		    var newSources = new ArraySet();
		    var newNames = new ArraySet();

		    // Find mappings for the "sourceFile"
		    this._mappings.unsortedForEach(function (mapping) {
		      if (mapping.source === sourceFile && mapping.originalLine != null) {
		        // Check if it can be mapped by the source map, then update the mapping.
		        var original = aSourceMapConsumer.originalPositionFor({
		          line: mapping.originalLine,
		          column: mapping.originalColumn
		        });
		        if (original.source != null) {
		          // Copy mapping
		          mapping.source = original.source;
		          if (aSourceMapPath != null) {
		            mapping.source = util.join(aSourceMapPath, mapping.source);
		          }
		          if (sourceRoot != null) {
		            mapping.source = util.relative(sourceRoot, mapping.source);
		          }
		          mapping.originalLine = original.line;
		          mapping.originalColumn = original.column;
		          if (original.name != null) {
		            mapping.name = original.name;
		          }
		        }
		      }

		      var source = mapping.source;
		      if (source != null && !newSources.has(source)) {
		        newSources.add(source);
		      }

		      var name = mapping.name;
		      if (name != null && !newNames.has(name)) {
		        newNames.add(name);
		      }

		    }, this);
		    this._sources = newSources;
		    this._names = newNames;

		    // Copy sourcesContents of applied map.
		    aSourceMapConsumer.sources.forEach(function (sourceFile) {
		      var content = aSourceMapConsumer.sourceContentFor(sourceFile);
		      if (content != null) {
		        if (aSourceMapPath != null) {
		          sourceFile = util.join(aSourceMapPath, sourceFile);
		        }
		        if (sourceRoot != null) {
		          sourceFile = util.relative(sourceRoot, sourceFile);
		        }
		        this.setSourceContent(sourceFile, content);
		      }
		    }, this);
		  };

		/**
		 * A mapping can have one of the three levels of data:
		 *
		 *   1. Just the generated position.
		 *   2. The Generated position, original position, and original source.
		 *   3. Generated and original position, original source, as well as a name
		 *      token.
		 *
		 * To maintain consistency, we validate that any new mapping being added falls
		 * in to one of these categories.
		 */
		SourceMapGenerator.prototype._validateMapping =
		  function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource,
		                                              aName) {
		    // When aOriginal is truthy but has empty values for .line and .column,
		    // it is most likely a programmer error. In this case we throw a very
		    // specific error message to try to guide them the right way.
		    // For example: https://github.com/Polymer/polymer-bundler/pull/519
		    if (aOriginal && typeof aOriginal.line !== 'number' && typeof aOriginal.column !== 'number') {
		        throw new Error(
		            'original.line and original.column are not numbers -- you probably meant to omit ' +
		            'the original mapping entirely and only map the generated position. If so, pass ' +
		            'null for the original mapping instead of an object with empty or null values.'
		        );
		    }

		    if (aGenerated && 'line' in aGenerated && 'column' in aGenerated
		        && aGenerated.line > 0 && aGenerated.column >= 0
		        && !aOriginal && !aSource && !aName) {
		      // Case 1.
		      return;
		    }
		    else if (aGenerated && 'line' in aGenerated && 'column' in aGenerated
		             && aOriginal && 'line' in aOriginal && 'column' in aOriginal
		             && aGenerated.line > 0 && aGenerated.column >= 0
		             && aOriginal.line > 0 && aOriginal.column >= 0
		             && aSource) {
		      // Cases 2 and 3.
		      return;
		    }
		    else {
		      throw new Error('Invalid mapping: ' + JSON.stringify({
		        generated: aGenerated,
		        source: aSource,
		        original: aOriginal,
		        name: aName
		      }));
		    }
		  };

		/**
		 * Serialize the accumulated mappings in to the stream of base 64 VLQs
		 * specified by the source map format.
		 */
		SourceMapGenerator.prototype._serializeMappings =
		  function SourceMapGenerator_serializeMappings() {
		    var previousGeneratedColumn = 0;
		    var previousGeneratedLine = 1;
		    var previousOriginalColumn = 0;
		    var previousOriginalLine = 0;
		    var previousName = 0;
		    var previousSource = 0;
		    var result = '';
		    var next;
		    var mapping;
		    var nameIdx;
		    var sourceIdx;

		    var mappings = this._mappings.toArray();
		    for (var i = 0, len = mappings.length; i < len; i++) {
		      mapping = mappings[i];
		      next = '';

		      if (mapping.generatedLine !== previousGeneratedLine) {
		        previousGeneratedColumn = 0;
		        while (mapping.generatedLine !== previousGeneratedLine) {
		          next += ';';
		          previousGeneratedLine++;
		        }
		      }
		      else {
		        if (i > 0) {
		          if (!util.compareByGeneratedPositionsInflated(mapping, mappings[i - 1])) {
		            continue;
		          }
		          next += ',';
		        }
		      }

		      next += base64VLQ.encode(mapping.generatedColumn
		                                 - previousGeneratedColumn);
		      previousGeneratedColumn = mapping.generatedColumn;

		      if (mapping.source != null) {
		        sourceIdx = this._sources.indexOf(mapping.source);
		        next += base64VLQ.encode(sourceIdx - previousSource);
		        previousSource = sourceIdx;

		        // lines are stored 0-based in SourceMap spec version 3
		        next += base64VLQ.encode(mapping.originalLine - 1
		                                   - previousOriginalLine);
		        previousOriginalLine = mapping.originalLine - 1;

		        next += base64VLQ.encode(mapping.originalColumn
		                                   - previousOriginalColumn);
		        previousOriginalColumn = mapping.originalColumn;

		        if (mapping.name != null) {
		          nameIdx = this._names.indexOf(mapping.name);
		          next += base64VLQ.encode(nameIdx - previousName);
		          previousName = nameIdx;
		        }
		      }

		      result += next;
		    }

		    return result;
		  };

		SourceMapGenerator.prototype._generateSourcesContent =
		  function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
		    return aSources.map(function (source) {
		      if (!this._sourcesContents) {
		        return null;
		      }
		      if (aSourceRoot != null) {
		        source = util.relative(aSourceRoot, source);
		      }
		      var key = util.toSetString(source);
		      return Object.prototype.hasOwnProperty.call(this._sourcesContents, key)
		        ? this._sourcesContents[key]
		        : null;
		    }, this);
		  };

		/**
		 * Externalize the source map.
		 */
		SourceMapGenerator.prototype.toJSON =
		  function SourceMapGenerator_toJSON() {
		    var map = {
		      version: this._version,
		      sources: this._sources.toArray(),
		      names: this._names.toArray(),
		      mappings: this._serializeMappings()
		    };
		    if (this._file != null) {
		      map.file = this._file;
		    }
		    if (this._sourceRoot != null) {
		      map.sourceRoot = this._sourceRoot;
		    }
		    if (this._sourcesContents) {
		      map.sourcesContent = this._generateSourcesContent(map.sources, map.sourceRoot);
		    }

		    return map;
		  };

		/**
		 * Render the source map being generated to a string.
		 */
		SourceMapGenerator.prototype.toString =
		  function SourceMapGenerator_toString() {
		    return JSON.stringify(this.toJSON());
		  };

		sourceMapGenerator.SourceMapGenerator = SourceMapGenerator;
		return sourceMapGenerator;
	}

	var sourceMapConsumer = {};

	var binarySearch$1 = {};

	/* -*- Mode: js; js-indent-level: 2; -*- */

	var hasRequiredBinarySearch;

	function requireBinarySearch () {
		if (hasRequiredBinarySearch) return binarySearch$1;
		hasRequiredBinarySearch = 1;
		(function (exports) {
			/*
			 * Copyright 2011 Mozilla Foundation and contributors
			 * Licensed under the New BSD license. See LICENSE or:
			 * http://opensource.org/licenses/BSD-3-Clause
			 */

			exports.GREATEST_LOWER_BOUND = 1;
			exports.LEAST_UPPER_BOUND = 2;

			/**
			 * Recursive implementation of binary search.
			 *
			 * @param aLow Indices here and lower do not contain the needle.
			 * @param aHigh Indices here and higher do not contain the needle.
			 * @param aNeedle The element being searched for.
			 * @param aHaystack The non-empty array being searched.
			 * @param aCompare Function which takes two elements and returns -1, 0, or 1.
			 * @param aBias Either 'binarySearch.GREATEST_LOWER_BOUND' or
			 *     'binarySearch.LEAST_UPPER_BOUND'. Specifies whether to return the
			 *     closest element that is smaller than or greater than the one we are
			 *     searching for, respectively, if the exact element cannot be found.
			 */
			function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare, aBias) {
			  // This function terminates when one of the following is true:
			  //
			  //   1. We find the exact element we are looking for.
			  //
			  //   2. We did not find the exact element, but we can return the index of
			  //      the next-closest element.
			  //
			  //   3. We did not find the exact element, and there is no next-closest
			  //      element than the one we are searching for, so we return -1.
			  var mid = Math.floor((aHigh - aLow) / 2) + aLow;
			  var cmp = aCompare(aNeedle, aHaystack[mid], true);
			  if (cmp === 0) {
			    // Found the element we are looking for.
			    return mid;
			  }
			  else if (cmp > 0) {
			    // Our needle is greater than aHaystack[mid].
			    if (aHigh - mid > 1) {
			      // The element is in the upper half.
			      return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare, aBias);
			    }

			    // The exact needle element was not found in this haystack. Determine if
			    // we are in termination case (3) or (2) and return the appropriate thing.
			    if (aBias == exports.LEAST_UPPER_BOUND) {
			      return aHigh < aHaystack.length ? aHigh : -1;
			    } else {
			      return mid;
			    }
			  }
			  else {
			    // Our needle is less than aHaystack[mid].
			    if (mid - aLow > 1) {
			      // The element is in the lower half.
			      return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare, aBias);
			    }

			    // we are in termination case (3) or (2) and return the appropriate thing.
			    if (aBias == exports.LEAST_UPPER_BOUND) {
			      return mid;
			    } else {
			      return aLow < 0 ? -1 : aLow;
			    }
			  }
			}

			/**
			 * This is an implementation of binary search which will always try and return
			 * the index of the closest element if there is no exact hit. This is because
			 * mappings between original and generated line/col pairs are single points,
			 * and there is an implicit region between each of them, so a miss just means
			 * that you aren't on the very start of a region.
			 *
			 * @param aNeedle The element you are looking for.
			 * @param aHaystack The array that is being searched.
			 * @param aCompare A function which takes the needle and an element in the
			 *     array and returns -1, 0, or 1 depending on whether the needle is less
			 *     than, equal to, or greater than the element, respectively.
			 * @param aBias Either 'binarySearch.GREATEST_LOWER_BOUND' or
			 *     'binarySearch.LEAST_UPPER_BOUND'. Specifies whether to return the
			 *     closest element that is smaller than or greater than the one we are
			 *     searching for, respectively, if the exact element cannot be found.
			 *     Defaults to 'binarySearch.GREATEST_LOWER_BOUND'.
			 */
			exports.search = function search(aNeedle, aHaystack, aCompare, aBias) {
			  if (aHaystack.length === 0) {
			    return -1;
			  }

			  var index = recursiveSearch(-1, aHaystack.length, aNeedle, aHaystack,
			                              aCompare, aBias || exports.GREATEST_LOWER_BOUND);
			  if (index < 0) {
			    return -1;
			  }

			  // We have found either the exact element, or the next-closest element than
			  // the one we are searching for. However, there may be more than one such
			  // element. Make sure we always return the smallest of these.
			  while (index - 1 >= 0) {
			    if (aCompare(aHaystack[index], aHaystack[index - 1], true) !== 0) {
			      break;
			    }
			    --index;
			  }

			  return index;
			}; 
		} (binarySearch$1));
		return binarySearch$1;
	}

	var quickSort = {};

	/* -*- Mode: js; js-indent-level: 2; -*- */

	var hasRequiredQuickSort;

	function requireQuickSort () {
		if (hasRequiredQuickSort) return quickSort;
		hasRequiredQuickSort = 1;
		/*
		 * Copyright 2011 Mozilla Foundation and contributors
		 * Licensed under the New BSD license. See LICENSE or:
		 * http://opensource.org/licenses/BSD-3-Clause
		 */

		// It turns out that some (most?) JavaScript engines don't self-host
		// `Array.prototype.sort`. This makes sense because C++ will likely remain
		// faster than JS when doing raw CPU-intensive sorting. However, when using a
		// custom comparator function, calling back and forth between the VM's C++ and
		// JIT'd JS is rather slow *and* loses JIT type information, resulting in
		// worse generated code for the comparator function than would be optimal. In
		// fact, when sorting with a comparator, these costs outweigh the benefits of
		// sorting in C++. By using our own JS-implemented Quick Sort (below), we get
		// a ~3500ms mean speed-up in `bench/bench.html`.

		/**
		 * Swap the elements indexed by `x` and `y` in the array `ary`.
		 *
		 * @param {Array} ary
		 *        The array.
		 * @param {Number} x
		 *        The index of the first item.
		 * @param {Number} y
		 *        The index of the second item.
		 */
		function swap(ary, x, y) {
		  var temp = ary[x];
		  ary[x] = ary[y];
		  ary[y] = temp;
		}

		/**
		 * Returns a random integer within the range `low .. high` inclusive.
		 *
		 * @param {Number} low
		 *        The lower bound on the range.
		 * @param {Number} high
		 *        The upper bound on the range.
		 */
		function randomIntInRange(low, high) {
		  return Math.round(low + (Math.random() * (high - low)));
		}

		/**
		 * The Quick Sort algorithm.
		 *
		 * @param {Array} ary
		 *        An array to sort.
		 * @param {function} comparator
		 *        Function to use to compare two items.
		 * @param {Number} p
		 *        Start index of the array
		 * @param {Number} r
		 *        End index of the array
		 */
		function doQuickSort(ary, comparator, p, r) {
		  // If our lower bound is less than our upper bound, we (1) partition the
		  // array into two pieces and (2) recurse on each half. If it is not, this is
		  // the empty array and our base case.

		  if (p < r) {
		    // (1) Partitioning.
		    //
		    // The partitioning chooses a pivot between `p` and `r` and moves all
		    // elements that are less than or equal to the pivot to the before it, and
		    // all the elements that are greater than it after it. The effect is that
		    // once partition is done, the pivot is in the exact place it will be when
		    // the array is put in sorted order, and it will not need to be moved
		    // again. This runs in O(n) time.

		    // Always choose a random pivot so that an input array which is reverse
		    // sorted does not cause O(n^2) running time.
		    var pivotIndex = randomIntInRange(p, r);
		    var i = p - 1;

		    swap(ary, pivotIndex, r);
		    var pivot = ary[r];

		    // Immediately after `j` is incremented in this loop, the following hold
		    // true:
		    //
		    //   * Every element in `ary[p .. i]` is less than or equal to the pivot.
		    //
		    //   * Every element in `ary[i+1 .. j-1]` is greater than the pivot.
		    for (var j = p; j < r; j++) {
		      if (comparator(ary[j], pivot) <= 0) {
		        i += 1;
		        swap(ary, i, j);
		      }
		    }

		    swap(ary, i + 1, j);
		    var q = i + 1;

		    // (2) Recurse on each half.

		    doQuickSort(ary, comparator, p, q - 1);
		    doQuickSort(ary, comparator, q + 1, r);
		  }
		}

		/**
		 * Sort the given array in-place with the given comparator function.
		 *
		 * @param {Array} ary
		 *        An array to sort.
		 * @param {function} comparator
		 *        Function to use to compare two items.
		 */
		quickSort.quickSort = function (ary, comparator) {
		  doQuickSort(ary, comparator, 0, ary.length - 1);
		};
		return quickSort;
	}

	/* -*- Mode: js; js-indent-level: 2; -*- */

	var hasRequiredSourceMapConsumer;

	function requireSourceMapConsumer () {
		if (hasRequiredSourceMapConsumer) return sourceMapConsumer;
		hasRequiredSourceMapConsumer = 1;
		/*
		 * Copyright 2011 Mozilla Foundation and contributors
		 * Licensed under the New BSD license. See LICENSE or:
		 * http://opensource.org/licenses/BSD-3-Clause
		 */

		var util = requireUtil();
		var binarySearch = requireBinarySearch();
		var ArraySet = requireArraySet().ArraySet;
		var base64VLQ = requireBase64Vlq();
		var quickSort = requireQuickSort().quickSort;

		function SourceMapConsumer(aSourceMap, aSourceMapURL) {
		  var sourceMap = aSourceMap;
		  if (typeof aSourceMap === 'string') {
		    sourceMap = util.parseSourceMapInput(aSourceMap);
		  }

		  return sourceMap.sections != null
		    ? new IndexedSourceMapConsumer(sourceMap, aSourceMapURL)
		    : new BasicSourceMapConsumer(sourceMap, aSourceMapURL);
		}

		SourceMapConsumer.fromSourceMap = function(aSourceMap, aSourceMapURL) {
		  return BasicSourceMapConsumer.fromSourceMap(aSourceMap, aSourceMapURL);
		};

		/**
		 * The version of the source mapping spec that we are consuming.
		 */
		SourceMapConsumer.prototype._version = 3;

		// `__generatedMappings` and `__originalMappings` are arrays that hold the
		// parsed mapping coordinates from the source map's "mappings" attribute. They
		// are lazily instantiated, accessed via the `_generatedMappings` and
		// `_originalMappings` getters respectively, and we only parse the mappings
		// and create these arrays once queried for a source location. We jump through
		// these hoops because there can be many thousands of mappings, and parsing
		// them is expensive, so we only want to do it if we must.
		//
		// Each object in the arrays is of the form:
		//
		//     {
		//       generatedLine: The line number in the generated code,
		//       generatedColumn: The column number in the generated code,
		//       source: The path to the original source file that generated this
		//               chunk of code,
		//       originalLine: The line number in the original source that
		//                     corresponds to this chunk of generated code,
		//       originalColumn: The column number in the original source that
		//                       corresponds to this chunk of generated code,
		//       name: The name of the original symbol which generated this chunk of
		//             code.
		//     }
		//
		// All properties except for `generatedLine` and `generatedColumn` can be
		// `null`.
		//
		// `_generatedMappings` is ordered by the generated positions.
		//
		// `_originalMappings` is ordered by the original positions.

		SourceMapConsumer.prototype.__generatedMappings = null;
		Object.defineProperty(SourceMapConsumer.prototype, '_generatedMappings', {
		  configurable: true,
		  enumerable: true,
		  get: function () {
		    if (!this.__generatedMappings) {
		      this._parseMappings(this._mappings, this.sourceRoot);
		    }

		    return this.__generatedMappings;
		  }
		});

		SourceMapConsumer.prototype.__originalMappings = null;
		Object.defineProperty(SourceMapConsumer.prototype, '_originalMappings', {
		  configurable: true,
		  enumerable: true,
		  get: function () {
		    if (!this.__originalMappings) {
		      this._parseMappings(this._mappings, this.sourceRoot);
		    }

		    return this.__originalMappings;
		  }
		});

		SourceMapConsumer.prototype._charIsMappingSeparator =
		  function SourceMapConsumer_charIsMappingSeparator(aStr, index) {
		    var c = aStr.charAt(index);
		    return c === ";" || c === ",";
		  };

		/**
		 * Parse the mappings in a string in to a data structure which we can easily
		 * query (the ordered arrays in the `this.__generatedMappings` and
		 * `this.__originalMappings` properties).
		 */
		SourceMapConsumer.prototype._parseMappings =
		  function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
		    throw new Error("Subclasses must implement _parseMappings");
		  };

		SourceMapConsumer.GENERATED_ORDER = 1;
		SourceMapConsumer.ORIGINAL_ORDER = 2;

		SourceMapConsumer.GREATEST_LOWER_BOUND = 1;
		SourceMapConsumer.LEAST_UPPER_BOUND = 2;

		/**
		 * Iterate over each mapping between an original source/line/column and a
		 * generated line/column in this source map.
		 *
		 * @param Function aCallback
		 *        The function that is called with each mapping.
		 * @param Object aContext
		 *        Optional. If specified, this object will be the value of `this` every
		 *        time that `aCallback` is called.
		 * @param aOrder
		 *        Either `SourceMapConsumer.GENERATED_ORDER` or
		 *        `SourceMapConsumer.ORIGINAL_ORDER`. Specifies whether you want to
		 *        iterate over the mappings sorted by the generated file's line/column
		 *        order or the original's source/line/column order, respectively. Defaults to
		 *        `SourceMapConsumer.GENERATED_ORDER`.
		 */
		SourceMapConsumer.prototype.eachMapping =
		  function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
		    var context = aContext || null;
		    var order = aOrder || SourceMapConsumer.GENERATED_ORDER;

		    var mappings;
		    switch (order) {
		    case SourceMapConsumer.GENERATED_ORDER:
		      mappings = this._generatedMappings;
		      break;
		    case SourceMapConsumer.ORIGINAL_ORDER:
		      mappings = this._originalMappings;
		      break;
		    default:
		      throw new Error("Unknown order of iteration.");
		    }

		    var sourceRoot = this.sourceRoot;
		    mappings.map(function (mapping) {
		      var source = mapping.source === null ? null : this._sources.at(mapping.source);
		      source = util.computeSourceURL(sourceRoot, source, this._sourceMapURL);
		      return {
		        source: source,
		        generatedLine: mapping.generatedLine,
		        generatedColumn: mapping.generatedColumn,
		        originalLine: mapping.originalLine,
		        originalColumn: mapping.originalColumn,
		        name: mapping.name === null ? null : this._names.at(mapping.name)
		      };
		    }, this).forEach(aCallback, context);
		  };

		/**
		 * Returns all generated line and column information for the original source,
		 * line, and column provided. If no column is provided, returns all mappings
		 * corresponding to a either the line we are searching for or the next
		 * closest line that has any mappings. Otherwise, returns all mappings
		 * corresponding to the given line and either the column we are searching for
		 * or the next closest column that has any offsets.
		 *
		 * The only argument is an object with the following properties:
		 *
		 *   - source: The filename of the original source.
		 *   - line: The line number in the original source.  The line number is 1-based.
		 *   - column: Optional. the column number in the original source.
		 *    The column number is 0-based.
		 *
		 * and an array of objects is returned, each with the following properties:
		 *
		 *   - line: The line number in the generated source, or null.  The
		 *    line number is 1-based.
		 *   - column: The column number in the generated source, or null.
		 *    The column number is 0-based.
		 */
		SourceMapConsumer.prototype.allGeneratedPositionsFor =
		  function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
		    var line = util.getArg(aArgs, 'line');

		    // When there is no exact match, BasicSourceMapConsumer.prototype._findMapping
		    // returns the index of the closest mapping less than the needle. By
		    // setting needle.originalColumn to 0, we thus find the last mapping for
		    // the given line, provided such a mapping exists.
		    var needle = {
		      source: util.getArg(aArgs, 'source'),
		      originalLine: line,
		      originalColumn: util.getArg(aArgs, 'column', 0)
		    };

		    needle.source = this._findSourceIndex(needle.source);
		    if (needle.source < 0) {
		      return [];
		    }

		    var mappings = [];

		    var index = this._findMapping(needle,
		                                  this._originalMappings,
		                                  "originalLine",
		                                  "originalColumn",
		                                  util.compareByOriginalPositions,
		                                  binarySearch.LEAST_UPPER_BOUND);
		    if (index >= 0) {
		      var mapping = this._originalMappings[index];

		      if (aArgs.column === undefined) {
		        var originalLine = mapping.originalLine;

		        // Iterate until either we run out of mappings, or we run into
		        // a mapping for a different line than the one we found. Since
		        // mappings are sorted, this is guaranteed to find all mappings for
		        // the line we found.
		        while (mapping && mapping.originalLine === originalLine) {
		          mappings.push({
		            line: util.getArg(mapping, 'generatedLine', null),
		            column: util.getArg(mapping, 'generatedColumn', null),
		            lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
		          });

		          mapping = this._originalMappings[++index];
		        }
		      } else {
		        var originalColumn = mapping.originalColumn;

		        // Iterate until either we run out of mappings, or we run into
		        // a mapping for a different line than the one we were searching for.
		        // Since mappings are sorted, this is guaranteed to find all mappings for
		        // the line we are searching for.
		        while (mapping &&
		               mapping.originalLine === line &&
		               mapping.originalColumn == originalColumn) {
		          mappings.push({
		            line: util.getArg(mapping, 'generatedLine', null),
		            column: util.getArg(mapping, 'generatedColumn', null),
		            lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
		          });

		          mapping = this._originalMappings[++index];
		        }
		      }
		    }

		    return mappings;
		  };

		sourceMapConsumer.SourceMapConsumer = SourceMapConsumer;

		/**
		 * A BasicSourceMapConsumer instance represents a parsed source map which we can
		 * query for information about the original file positions by giving it a file
		 * position in the generated source.
		 *
		 * The first parameter is the raw source map (either as a JSON string, or
		 * already parsed to an object). According to the spec, source maps have the
		 * following attributes:
		 *
		 *   - version: Which version of the source map spec this map is following.
		 *   - sources: An array of URLs to the original source files.
		 *   - names: An array of identifiers which can be referrenced by individual mappings.
		 *   - sourceRoot: Optional. The URL root from which all sources are relative.
		 *   - sourcesContent: Optional. An array of contents of the original source files.
		 *   - mappings: A string of base64 VLQs which contain the actual mappings.
		 *   - file: Optional. The generated file this source map is associated with.
		 *
		 * Here is an example source map, taken from the source map spec[0]:
		 *
		 *     {
		 *       version : 3,
		 *       file: "out.js",
		 *       sourceRoot : "",
		 *       sources: ["foo.js", "bar.js"],
		 *       names: ["src", "maps", "are", "fun"],
		 *       mappings: "AA,AB;;ABCDE;"
		 *     }
		 *
		 * The second parameter, if given, is a string whose value is the URL
		 * at which the source map was found.  This URL is used to compute the
		 * sources array.
		 *
		 * [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit?pli=1#
		 */
		function BasicSourceMapConsumer(aSourceMap, aSourceMapURL) {
		  var sourceMap = aSourceMap;
		  if (typeof aSourceMap === 'string') {
		    sourceMap = util.parseSourceMapInput(aSourceMap);
		  }

		  var version = util.getArg(sourceMap, 'version');
		  var sources = util.getArg(sourceMap, 'sources');
		  // Sass 3.3 leaves out the 'names' array, so we deviate from the spec (which
		  // requires the array) to play nice here.
		  var names = util.getArg(sourceMap, 'names', []);
		  var sourceRoot = util.getArg(sourceMap, 'sourceRoot', null);
		  var sourcesContent = util.getArg(sourceMap, 'sourcesContent', null);
		  var mappings = util.getArg(sourceMap, 'mappings');
		  var file = util.getArg(sourceMap, 'file', null);

		  // Once again, Sass deviates from the spec and supplies the version as a
		  // string rather than a number, so we use loose equality checking here.
		  if (version != this._version) {
		    throw new Error('Unsupported version: ' + version);
		  }

		  if (sourceRoot) {
		    sourceRoot = util.normalize(sourceRoot);
		  }

		  sources = sources
		    .map(String)
		    // Some source maps produce relative source paths like "./foo.js" instead of
		    // "foo.js".  Normalize these first so that future comparisons will succeed.
		    // See bugzil.la/1090768.
		    .map(util.normalize)
		    // Always ensure that absolute sources are internally stored relative to
		    // the source root, if the source root is absolute. Not doing this would
		    // be particularly problematic when the source root is a prefix of the
		    // source (valid, but why??). See github issue #199 and bugzil.la/1188982.
		    .map(function (source) {
		      return sourceRoot && util.isAbsolute(sourceRoot) && util.isAbsolute(source)
		        ? util.relative(sourceRoot, source)
		        : source;
		    });

		  // Pass `true` below to allow duplicate names and sources. While source maps
		  // are intended to be compressed and deduplicated, the TypeScript compiler
		  // sometimes generates source maps with duplicates in them. See Github issue
		  // #72 and bugzil.la/889492.
		  this._names = ArraySet.fromArray(names.map(String), true);
		  this._sources = ArraySet.fromArray(sources, true);

		  this._absoluteSources = this._sources.toArray().map(function (s) {
		    return util.computeSourceURL(sourceRoot, s, aSourceMapURL);
		  });

		  this.sourceRoot = sourceRoot;
		  this.sourcesContent = sourcesContent;
		  this._mappings = mappings;
		  this._sourceMapURL = aSourceMapURL;
		  this.file = file;
		}

		BasicSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
		BasicSourceMapConsumer.prototype.consumer = SourceMapConsumer;

		/**
		 * Utility function to find the index of a source.  Returns -1 if not
		 * found.
		 */
		BasicSourceMapConsumer.prototype._findSourceIndex = function(aSource) {
		  var relativeSource = aSource;
		  if (this.sourceRoot != null) {
		    relativeSource = util.relative(this.sourceRoot, relativeSource);
		  }

		  if (this._sources.has(relativeSource)) {
		    return this._sources.indexOf(relativeSource);
		  }

		  // Maybe aSource is an absolute URL as returned by |sources|.  In
		  // this case we can't simply undo the transform.
		  var i;
		  for (i = 0; i < this._absoluteSources.length; ++i) {
		    if (this._absoluteSources[i] == aSource) {
		      return i;
		    }
		  }

		  return -1;
		};

		/**
		 * Create a BasicSourceMapConsumer from a SourceMapGenerator.
		 *
		 * @param SourceMapGenerator aSourceMap
		 *        The source map that will be consumed.
		 * @param String aSourceMapURL
		 *        The URL at which the source map can be found (optional)
		 * @returns BasicSourceMapConsumer
		 */
		BasicSourceMapConsumer.fromSourceMap =
		  function SourceMapConsumer_fromSourceMap(aSourceMap, aSourceMapURL) {
		    var smc = Object.create(BasicSourceMapConsumer.prototype);

		    var names = smc._names = ArraySet.fromArray(aSourceMap._names.toArray(), true);
		    var sources = smc._sources = ArraySet.fromArray(aSourceMap._sources.toArray(), true);
		    smc.sourceRoot = aSourceMap._sourceRoot;
		    smc.sourcesContent = aSourceMap._generateSourcesContent(smc._sources.toArray(),
		                                                            smc.sourceRoot);
		    smc.file = aSourceMap._file;
		    smc._sourceMapURL = aSourceMapURL;
		    smc._absoluteSources = smc._sources.toArray().map(function (s) {
		      return util.computeSourceURL(smc.sourceRoot, s, aSourceMapURL);
		    });

		    // Because we are modifying the entries (by converting string sources and
		    // names to indices into the sources and names ArraySets), we have to make
		    // a copy of the entry or else bad things happen. Shared mutable state
		    // strikes again! See github issue #191.

		    var generatedMappings = aSourceMap._mappings.toArray().slice();
		    var destGeneratedMappings = smc.__generatedMappings = [];
		    var destOriginalMappings = smc.__originalMappings = [];

		    for (var i = 0, length = generatedMappings.length; i < length; i++) {
		      var srcMapping = generatedMappings[i];
		      var destMapping = new Mapping;
		      destMapping.generatedLine = srcMapping.generatedLine;
		      destMapping.generatedColumn = srcMapping.generatedColumn;

		      if (srcMapping.source) {
		        destMapping.source = sources.indexOf(srcMapping.source);
		        destMapping.originalLine = srcMapping.originalLine;
		        destMapping.originalColumn = srcMapping.originalColumn;

		        if (srcMapping.name) {
		          destMapping.name = names.indexOf(srcMapping.name);
		        }

		        destOriginalMappings.push(destMapping);
		      }

		      destGeneratedMappings.push(destMapping);
		    }

		    quickSort(smc.__originalMappings, util.compareByOriginalPositions);

		    return smc;
		  };

		/**
		 * The version of the source mapping spec that we are consuming.
		 */
		BasicSourceMapConsumer.prototype._version = 3;

		/**
		 * The list of original sources.
		 */
		Object.defineProperty(BasicSourceMapConsumer.prototype, 'sources', {
		  get: function () {
		    return this._absoluteSources.slice();
		  }
		});

		/**
		 * Provide the JIT with a nice shape / hidden class.
		 */
		function Mapping() {
		  this.generatedLine = 0;
		  this.generatedColumn = 0;
		  this.source = null;
		  this.originalLine = null;
		  this.originalColumn = null;
		  this.name = null;
		}

		/**
		 * Parse the mappings in a string in to a data structure which we can easily
		 * query (the ordered arrays in the `this.__generatedMappings` and
		 * `this.__originalMappings` properties).
		 */
		BasicSourceMapConsumer.prototype._parseMappings =
		  function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
		    var generatedLine = 1;
		    var previousGeneratedColumn = 0;
		    var previousOriginalLine = 0;
		    var previousOriginalColumn = 0;
		    var previousSource = 0;
		    var previousName = 0;
		    var length = aStr.length;
		    var index = 0;
		    var cachedSegments = {};
		    var temp = {};
		    var originalMappings = [];
		    var generatedMappings = [];
		    var mapping, str, segment, end, value;

		    while (index < length) {
		      if (aStr.charAt(index) === ';') {
		        generatedLine++;
		        index++;
		        previousGeneratedColumn = 0;
		      }
		      else if (aStr.charAt(index) === ',') {
		        index++;
		      }
		      else {
		        mapping = new Mapping();
		        mapping.generatedLine = generatedLine;

		        // Because each offset is encoded relative to the previous one,
		        // many segments often have the same encoding. We can exploit this
		        // fact by caching the parsed variable length fields of each segment,
		        // allowing us to avoid a second parse if we encounter the same
		        // segment again.
		        for (end = index; end < length; end++) {
		          if (this._charIsMappingSeparator(aStr, end)) {
		            break;
		          }
		        }
		        str = aStr.slice(index, end);

		        segment = cachedSegments[str];
		        if (segment) {
		          index += str.length;
		        } else {
		          segment = [];
		          while (index < end) {
		            base64VLQ.decode(aStr, index, temp);
		            value = temp.value;
		            index = temp.rest;
		            segment.push(value);
		          }

		          if (segment.length === 2) {
		            throw new Error('Found a source, but no line and column');
		          }

		          if (segment.length === 3) {
		            throw new Error('Found a source and line, but no column');
		          }

		          cachedSegments[str] = segment;
		        }

		        // Generated column.
		        mapping.generatedColumn = previousGeneratedColumn + segment[0];
		        previousGeneratedColumn = mapping.generatedColumn;

		        if (segment.length > 1) {
		          // Original source.
		          mapping.source = previousSource + segment[1];
		          previousSource += segment[1];

		          // Original line.
		          mapping.originalLine = previousOriginalLine + segment[2];
		          previousOriginalLine = mapping.originalLine;
		          // Lines are stored 0-based
		          mapping.originalLine += 1;

		          // Original column.
		          mapping.originalColumn = previousOriginalColumn + segment[3];
		          previousOriginalColumn = mapping.originalColumn;

		          if (segment.length > 4) {
		            // Original name.
		            mapping.name = previousName + segment[4];
		            previousName += segment[4];
		          }
		        }

		        generatedMappings.push(mapping);
		        if (typeof mapping.originalLine === 'number') {
		          originalMappings.push(mapping);
		        }
		      }
		    }

		    quickSort(generatedMappings, util.compareByGeneratedPositionsDeflated);
		    this.__generatedMappings = generatedMappings;

		    quickSort(originalMappings, util.compareByOriginalPositions);
		    this.__originalMappings = originalMappings;
		  };

		/**
		 * Find the mapping that best matches the hypothetical "needle" mapping that
		 * we are searching for in the given "haystack" of mappings.
		 */
		BasicSourceMapConsumer.prototype._findMapping =
		  function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName,
		                                         aColumnName, aComparator, aBias) {
		    // To return the position we are searching for, we must first find the
		    // mapping for the given position and then return the opposite position it
		    // points to. Because the mappings are sorted, we can use binary search to
		    // find the best mapping.

		    if (aNeedle[aLineName] <= 0) {
		      throw new TypeError('Line must be greater than or equal to 1, got '
		                          + aNeedle[aLineName]);
		    }
		    if (aNeedle[aColumnName] < 0) {
		      throw new TypeError('Column must be greater than or equal to 0, got '
		                          + aNeedle[aColumnName]);
		    }

		    return binarySearch.search(aNeedle, aMappings, aComparator, aBias);
		  };

		/**
		 * Compute the last column for each generated mapping. The last column is
		 * inclusive.
		 */
		BasicSourceMapConsumer.prototype.computeColumnSpans =
		  function SourceMapConsumer_computeColumnSpans() {
		    for (var index = 0; index < this._generatedMappings.length; ++index) {
		      var mapping = this._generatedMappings[index];

		      // Mappings do not contain a field for the last generated columnt. We
		      // can come up with an optimistic estimate, however, by assuming that
		      // mappings are contiguous (i.e. given two consecutive mappings, the
		      // first mapping ends where the second one starts).
		      if (index + 1 < this._generatedMappings.length) {
		        var nextMapping = this._generatedMappings[index + 1];

		        if (mapping.generatedLine === nextMapping.generatedLine) {
		          mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
		          continue;
		        }
		      }

		      // The last mapping for each line spans the entire line.
		      mapping.lastGeneratedColumn = Infinity;
		    }
		  };

		/**
		 * Returns the original source, line, and column information for the generated
		 * source's line and column positions provided. The only argument is an object
		 * with the following properties:
		 *
		 *   - line: The line number in the generated source.  The line number
		 *     is 1-based.
		 *   - column: The column number in the generated source.  The column
		 *     number is 0-based.
		 *   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
		 *     'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
		 *     closest element that is smaller than or greater than the one we are
		 *     searching for, respectively, if the exact element cannot be found.
		 *     Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
		 *
		 * and an object is returned with the following properties:
		 *
		 *   - source: The original source file, or null.
		 *   - line: The line number in the original source, or null.  The
		 *     line number is 1-based.
		 *   - column: The column number in the original source, or null.  The
		 *     column number is 0-based.
		 *   - name: The original identifier, or null.
		 */
		BasicSourceMapConsumer.prototype.originalPositionFor =
		  function SourceMapConsumer_originalPositionFor(aArgs) {
		    var needle = {
		      generatedLine: util.getArg(aArgs, 'line'),
		      generatedColumn: util.getArg(aArgs, 'column')
		    };

		    var index = this._findMapping(
		      needle,
		      this._generatedMappings,
		      "generatedLine",
		      "generatedColumn",
		      util.compareByGeneratedPositionsDeflated,
		      util.getArg(aArgs, 'bias', SourceMapConsumer.GREATEST_LOWER_BOUND)
		    );

		    if (index >= 0) {
		      var mapping = this._generatedMappings[index];

		      if (mapping.generatedLine === needle.generatedLine) {
		        var source = util.getArg(mapping, 'source', null);
		        if (source !== null) {
		          source = this._sources.at(source);
		          source = util.computeSourceURL(this.sourceRoot, source, this._sourceMapURL);
		        }
		        var name = util.getArg(mapping, 'name', null);
		        if (name !== null) {
		          name = this._names.at(name);
		        }
		        return {
		          source: source,
		          line: util.getArg(mapping, 'originalLine', null),
		          column: util.getArg(mapping, 'originalColumn', null),
		          name: name
		        };
		      }
		    }

		    return {
		      source: null,
		      line: null,
		      column: null,
		      name: null
		    };
		  };

		/**
		 * Return true if we have the source content for every source in the source
		 * map, false otherwise.
		 */
		BasicSourceMapConsumer.prototype.hasContentsOfAllSources =
		  function BasicSourceMapConsumer_hasContentsOfAllSources() {
		    if (!this.sourcesContent) {
		      return false;
		    }
		    return this.sourcesContent.length >= this._sources.size() &&
		      !this.sourcesContent.some(function (sc) { return sc == null; });
		  };

		/**
		 * Returns the original source content. The only argument is the url of the
		 * original source file. Returns null if no original source content is
		 * available.
		 */
		BasicSourceMapConsumer.prototype.sourceContentFor =
		  function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
		    if (!this.sourcesContent) {
		      return null;
		    }

		    var index = this._findSourceIndex(aSource);
		    if (index >= 0) {
		      return this.sourcesContent[index];
		    }

		    var relativeSource = aSource;
		    if (this.sourceRoot != null) {
		      relativeSource = util.relative(this.sourceRoot, relativeSource);
		    }

		    var url;
		    if (this.sourceRoot != null
		        && (url = util.urlParse(this.sourceRoot))) {
		      // XXX: file:// URIs and absolute paths lead to unexpected behavior for
		      // many users. We can help them out when they expect file:// URIs to
		      // behave like it would if they were running a local HTTP server. See
		      // https://bugzilla.mozilla.org/show_bug.cgi?id=885597.
		      var fileUriAbsPath = relativeSource.replace(/^file:\/\//, "");
		      if (url.scheme == "file"
		          && this._sources.has(fileUriAbsPath)) {
		        return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)]
		      }

		      if ((!url.path || url.path == "/")
		          && this._sources.has("/" + relativeSource)) {
		        return this.sourcesContent[this._sources.indexOf("/" + relativeSource)];
		      }
		    }

		    // This function is used recursively from
		    // IndexedSourceMapConsumer.prototype.sourceContentFor. In that case, we
		    // don't want to throw if we can't find the source - we just want to
		    // return null, so we provide a flag to exit gracefully.
		    if (nullOnMissing) {
		      return null;
		    }
		    else {
		      throw new Error('"' + relativeSource + '" is not in the SourceMap.');
		    }
		  };

		/**
		 * Returns the generated line and column information for the original source,
		 * line, and column positions provided. The only argument is an object with
		 * the following properties:
		 *
		 *   - source: The filename of the original source.
		 *   - line: The line number in the original source.  The line number
		 *     is 1-based.
		 *   - column: The column number in the original source.  The column
		 *     number is 0-based.
		 *   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
		 *     'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
		 *     closest element that is smaller than or greater than the one we are
		 *     searching for, respectively, if the exact element cannot be found.
		 *     Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
		 *
		 * and an object is returned with the following properties:
		 *
		 *   - line: The line number in the generated source, or null.  The
		 *     line number is 1-based.
		 *   - column: The column number in the generated source, or null.
		 *     The column number is 0-based.
		 */
		BasicSourceMapConsumer.prototype.generatedPositionFor =
		  function SourceMapConsumer_generatedPositionFor(aArgs) {
		    var source = util.getArg(aArgs, 'source');
		    source = this._findSourceIndex(source);
		    if (source < 0) {
		      return {
		        line: null,
		        column: null,
		        lastColumn: null
		      };
		    }

		    var needle = {
		      source: source,
		      originalLine: util.getArg(aArgs, 'line'),
		      originalColumn: util.getArg(aArgs, 'column')
		    };

		    var index = this._findMapping(
		      needle,
		      this._originalMappings,
		      "originalLine",
		      "originalColumn",
		      util.compareByOriginalPositions,
		      util.getArg(aArgs, 'bias', SourceMapConsumer.GREATEST_LOWER_BOUND)
		    );

		    if (index >= 0) {
		      var mapping = this._originalMappings[index];

		      if (mapping.source === needle.source) {
		        return {
		          line: util.getArg(mapping, 'generatedLine', null),
		          column: util.getArg(mapping, 'generatedColumn', null),
		          lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
		        };
		      }
		    }

		    return {
		      line: null,
		      column: null,
		      lastColumn: null
		    };
		  };

		sourceMapConsumer.BasicSourceMapConsumer = BasicSourceMapConsumer;

		/**
		 * An IndexedSourceMapConsumer instance represents a parsed source map which
		 * we can query for information. It differs from BasicSourceMapConsumer in
		 * that it takes "indexed" source maps (i.e. ones with a "sections" field) as
		 * input.
		 *
		 * The first parameter is a raw source map (either as a JSON string, or already
		 * parsed to an object). According to the spec for indexed source maps, they
		 * have the following attributes:
		 *
		 *   - version: Which version of the source map spec this map is following.
		 *   - file: Optional. The generated file this source map is associated with.
		 *   - sections: A list of section definitions.
		 *
		 * Each value under the "sections" field has two fields:
		 *   - offset: The offset into the original specified at which this section
		 *       begins to apply, defined as an object with a "line" and "column"
		 *       field.
		 *   - map: A source map definition. This source map could also be indexed,
		 *       but doesn't have to be.
		 *
		 * Instead of the "map" field, it's also possible to have a "url" field
		 * specifying a URL to retrieve a source map from, but that's currently
		 * unsupported.
		 *
		 * Here's an example source map, taken from the source map spec[0], but
		 * modified to omit a section which uses the "url" field.
		 *
		 *  {
		 *    version : 3,
		 *    file: "app.js",
		 *    sections: [{
		 *      offset: {line:100, column:10},
		 *      map: {
		 *        version : 3,
		 *        file: "section.js",
		 *        sources: ["foo.js", "bar.js"],
		 *        names: ["src", "maps", "are", "fun"],
		 *        mappings: "AAAA,E;;ABCDE;"
		 *      }
		 *    }],
		 *  }
		 *
		 * The second parameter, if given, is a string whose value is the URL
		 * at which the source map was found.  This URL is used to compute the
		 * sources array.
		 *
		 * [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit#heading=h.535es3xeprgt
		 */
		function IndexedSourceMapConsumer(aSourceMap, aSourceMapURL) {
		  var sourceMap = aSourceMap;
		  if (typeof aSourceMap === 'string') {
		    sourceMap = util.parseSourceMapInput(aSourceMap);
		  }

		  var version = util.getArg(sourceMap, 'version');
		  var sections = util.getArg(sourceMap, 'sections');

		  if (version != this._version) {
		    throw new Error('Unsupported version: ' + version);
		  }

		  this._sources = new ArraySet();
		  this._names = new ArraySet();

		  var lastOffset = {
		    line: -1,
		    column: 0
		  };
		  this._sections = sections.map(function (s) {
		    if (s.url) {
		      // The url field will require support for asynchronicity.
		      // See https://github.com/mozilla/source-map/issues/16
		      throw new Error('Support for url field in sections not implemented.');
		    }
		    var offset = util.getArg(s, 'offset');
		    var offsetLine = util.getArg(offset, 'line');
		    var offsetColumn = util.getArg(offset, 'column');

		    if (offsetLine < lastOffset.line ||
		        (offsetLine === lastOffset.line && offsetColumn < lastOffset.column)) {
		      throw new Error('Section offsets must be ordered and non-overlapping.');
		    }
		    lastOffset = offset;

		    return {
		      generatedOffset: {
		        // The offset fields are 0-based, but we use 1-based indices when
		        // encoding/decoding from VLQ.
		        generatedLine: offsetLine + 1,
		        generatedColumn: offsetColumn + 1
		      },
		      consumer: new SourceMapConsumer(util.getArg(s, 'map'), aSourceMapURL)
		    }
		  });
		}

		IndexedSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
		IndexedSourceMapConsumer.prototype.constructor = SourceMapConsumer;

		/**
		 * The version of the source mapping spec that we are consuming.
		 */
		IndexedSourceMapConsumer.prototype._version = 3;

		/**
		 * The list of original sources.
		 */
		Object.defineProperty(IndexedSourceMapConsumer.prototype, 'sources', {
		  get: function () {
		    var sources = [];
		    for (var i = 0; i < this._sections.length; i++) {
		      for (var j = 0; j < this._sections[i].consumer.sources.length; j++) {
		        sources.push(this._sections[i].consumer.sources[j]);
		      }
		    }
		    return sources;
		  }
		});

		/**
		 * Returns the original source, line, and column information for the generated
		 * source's line and column positions provided. The only argument is an object
		 * with the following properties:
		 *
		 *   - line: The line number in the generated source.  The line number
		 *     is 1-based.
		 *   - column: The column number in the generated source.  The column
		 *     number is 0-based.
		 *
		 * and an object is returned with the following properties:
		 *
		 *   - source: The original source file, or null.
		 *   - line: The line number in the original source, or null.  The
		 *     line number is 1-based.
		 *   - column: The column number in the original source, or null.  The
		 *     column number is 0-based.
		 *   - name: The original identifier, or null.
		 */
		IndexedSourceMapConsumer.prototype.originalPositionFor =
		  function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
		    var needle = {
		      generatedLine: util.getArg(aArgs, 'line'),
		      generatedColumn: util.getArg(aArgs, 'column')
		    };

		    // Find the section containing the generated position we're trying to map
		    // to an original position.
		    var sectionIndex = binarySearch.search(needle, this._sections,
		      function(needle, section) {
		        var cmp = needle.generatedLine - section.generatedOffset.generatedLine;
		        if (cmp) {
		          return cmp;
		        }

		        return (needle.generatedColumn -
		                section.generatedOffset.generatedColumn);
		      });
		    var section = this._sections[sectionIndex];

		    if (!section) {
		      return {
		        source: null,
		        line: null,
		        column: null,
		        name: null
		      };
		    }

		    return section.consumer.originalPositionFor({
		      line: needle.generatedLine -
		        (section.generatedOffset.generatedLine - 1),
		      column: needle.generatedColumn -
		        (section.generatedOffset.generatedLine === needle.generatedLine
		         ? section.generatedOffset.generatedColumn - 1
		         : 0),
		      bias: aArgs.bias
		    });
		  };

		/**
		 * Return true if we have the source content for every source in the source
		 * map, false otherwise.
		 */
		IndexedSourceMapConsumer.prototype.hasContentsOfAllSources =
		  function IndexedSourceMapConsumer_hasContentsOfAllSources() {
		    return this._sections.every(function (s) {
		      return s.consumer.hasContentsOfAllSources();
		    });
		  };

		/**
		 * Returns the original source content. The only argument is the url of the
		 * original source file. Returns null if no original source content is
		 * available.
		 */
		IndexedSourceMapConsumer.prototype.sourceContentFor =
		  function IndexedSourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
		    for (var i = 0; i < this._sections.length; i++) {
		      var section = this._sections[i];

		      var content = section.consumer.sourceContentFor(aSource, true);
		      if (content) {
		        return content;
		      }
		    }
		    if (nullOnMissing) {
		      return null;
		    }
		    else {
		      throw new Error('"' + aSource + '" is not in the SourceMap.');
		    }
		  };

		/**
		 * Returns the generated line and column information for the original source,
		 * line, and column positions provided. The only argument is an object with
		 * the following properties:
		 *
		 *   - source: The filename of the original source.
		 *   - line: The line number in the original source.  The line number
		 *     is 1-based.
		 *   - column: The column number in the original source.  The column
		 *     number is 0-based.
		 *
		 * and an object is returned with the following properties:
		 *
		 *   - line: The line number in the generated source, or null.  The
		 *     line number is 1-based. 
		 *   - column: The column number in the generated source, or null.
		 *     The column number is 0-based.
		 */
		IndexedSourceMapConsumer.prototype.generatedPositionFor =
		  function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
		    for (var i = 0; i < this._sections.length; i++) {
		      var section = this._sections[i];

		      // Only consider this section if the requested source is in the list of
		      // sources of the consumer.
		      if (section.consumer._findSourceIndex(util.getArg(aArgs, 'source')) === -1) {
		        continue;
		      }
		      var generatedPosition = section.consumer.generatedPositionFor(aArgs);
		      if (generatedPosition) {
		        var ret = {
		          line: generatedPosition.line +
		            (section.generatedOffset.generatedLine - 1),
		          column: generatedPosition.column +
		            (section.generatedOffset.generatedLine === generatedPosition.line
		             ? section.generatedOffset.generatedColumn - 1
		             : 0)
		        };
		        return ret;
		      }
		    }

		    return {
		      line: null,
		      column: null
		    };
		  };

		/**
		 * Parse the mappings in a string in to a data structure which we can easily
		 * query (the ordered arrays in the `this.__generatedMappings` and
		 * `this.__originalMappings` properties).
		 */
		IndexedSourceMapConsumer.prototype._parseMappings =
		  function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
		    this.__generatedMappings = [];
		    this.__originalMappings = [];
		    for (var i = 0; i < this._sections.length; i++) {
		      var section = this._sections[i];
		      var sectionMappings = section.consumer._generatedMappings;
		      for (var j = 0; j < sectionMappings.length; j++) {
		        var mapping = sectionMappings[j];

		        var source = section.consumer._sources.at(mapping.source);
		        source = util.computeSourceURL(section.consumer.sourceRoot, source, this._sourceMapURL);
		        this._sources.add(source);
		        source = this._sources.indexOf(source);

		        var name = null;
		        if (mapping.name) {
		          name = section.consumer._names.at(mapping.name);
		          this._names.add(name);
		          name = this._names.indexOf(name);
		        }

		        // The mappings coming from the consumer for the section have
		        // generated positions relative to the start of the section, so we
		        // need to offset them to be relative to the start of the concatenated
		        // generated file.
		        var adjustedMapping = {
		          source: source,
		          generatedLine: mapping.generatedLine +
		            (section.generatedOffset.generatedLine - 1),
		          generatedColumn: mapping.generatedColumn +
		            (section.generatedOffset.generatedLine === mapping.generatedLine
		            ? section.generatedOffset.generatedColumn - 1
		            : 0),
		          originalLine: mapping.originalLine,
		          originalColumn: mapping.originalColumn,
		          name: name
		        };

		        this.__generatedMappings.push(adjustedMapping);
		        if (typeof adjustedMapping.originalLine === 'number') {
		          this.__originalMappings.push(adjustedMapping);
		        }
		      }
		    }

		    quickSort(this.__generatedMappings, util.compareByGeneratedPositionsDeflated);
		    quickSort(this.__originalMappings, util.compareByOriginalPositions);
		  };

		sourceMapConsumer.IndexedSourceMapConsumer = IndexedSourceMapConsumer;
		return sourceMapConsumer;
	}

	var sourceNode = {};

	/* -*- Mode: js; js-indent-level: 2; -*- */

	var hasRequiredSourceNode;

	function requireSourceNode () {
		if (hasRequiredSourceNode) return sourceNode;
		hasRequiredSourceNode = 1;
		/*
		 * Copyright 2011 Mozilla Foundation and contributors
		 * Licensed under the New BSD license. See LICENSE or:
		 * http://opensource.org/licenses/BSD-3-Clause
		 */

		var SourceMapGenerator = requireSourceMapGenerator().SourceMapGenerator;
		var util = requireUtil();

		// Matches a Windows-style `\r\n` newline or a `\n` newline used by all other
		// operating systems these days (capturing the result).
		var REGEX_NEWLINE = /(\r?\n)/;

		// Newline character code for charCodeAt() comparisons
		var NEWLINE_CODE = 10;

		// Private symbol for identifying `SourceNode`s when multiple versions of
		// the source-map library are loaded. This MUST NOT CHANGE across
		// versions!
		var isSourceNode = "$$$isSourceNode$$$";

		/**
		 * SourceNodes provide a way to abstract over interpolating/concatenating
		 * snippets of generated JavaScript source code while maintaining the line and
		 * column information associated with the original source code.
		 *
		 * @param aLine The original line number.
		 * @param aColumn The original column number.
		 * @param aSource The original source's filename.
		 * @param aChunks Optional. An array of strings which are snippets of
		 *        generated JS, or other SourceNodes.
		 * @param aName The original identifier.
		 */
		function SourceNode(aLine, aColumn, aSource, aChunks, aName) {
		  this.children = [];
		  this.sourceContents = {};
		  this.line = aLine == null ? null : aLine;
		  this.column = aColumn == null ? null : aColumn;
		  this.source = aSource == null ? null : aSource;
		  this.name = aName == null ? null : aName;
		  this[isSourceNode] = true;
		  if (aChunks != null) this.add(aChunks);
		}

		/**
		 * Creates a SourceNode from generated code and a SourceMapConsumer.
		 *
		 * @param aGeneratedCode The generated code
		 * @param aSourceMapConsumer The SourceMap for the generated code
		 * @param aRelativePath Optional. The path that relative sources in the
		 *        SourceMapConsumer should be relative to.
		 */
		SourceNode.fromStringWithSourceMap =
		  function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
		    // The SourceNode we want to fill with the generated code
		    // and the SourceMap
		    var node = new SourceNode();

		    // All even indices of this array are one line of the generated code,
		    // while all odd indices are the newlines between two adjacent lines
		    // (since `REGEX_NEWLINE` captures its match).
		    // Processed fragments are accessed by calling `shiftNextLine`.
		    var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
		    var remainingLinesIndex = 0;
		    var shiftNextLine = function() {
		      var lineContents = getNextLine();
		      // The last line of a file might not have a newline.
		      var newLine = getNextLine() || "";
		      return lineContents + newLine;

		      function getNextLine() {
		        return remainingLinesIndex < remainingLines.length ?
		            remainingLines[remainingLinesIndex++] : undefined;
		      }
		    };

		    // We need to remember the position of "remainingLines"
		    var lastGeneratedLine = 1, lastGeneratedColumn = 0;

		    // The generate SourceNodes we need a code range.
		    // To extract it current and last mapping is used.
		    // Here we store the last mapping.
		    var lastMapping = null;

		    aSourceMapConsumer.eachMapping(function (mapping) {
		      if (lastMapping !== null) {
		        // We add the code from "lastMapping" to "mapping":
		        // First check if there is a new line in between.
		        if (lastGeneratedLine < mapping.generatedLine) {
		          // Associate first line with "lastMapping"
		          addMappingWithCode(lastMapping, shiftNextLine());
		          lastGeneratedLine++;
		          lastGeneratedColumn = 0;
		          // The remaining code is added without mapping
		        } else {
		          // There is no new line in between.
		          // Associate the code between "lastGeneratedColumn" and
		          // "mapping.generatedColumn" with "lastMapping"
		          var nextLine = remainingLines[remainingLinesIndex] || '';
		          var code = nextLine.substr(0, mapping.generatedColumn -
		                                        lastGeneratedColumn);
		          remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn -
		                                              lastGeneratedColumn);
		          lastGeneratedColumn = mapping.generatedColumn;
		          addMappingWithCode(lastMapping, code);
		          // No more remaining code, continue
		          lastMapping = mapping;
		          return;
		        }
		      }
		      // We add the generated code until the first mapping
		      // to the SourceNode without any mapping.
		      // Each line is added as separate string.
		      while (lastGeneratedLine < mapping.generatedLine) {
		        node.add(shiftNextLine());
		        lastGeneratedLine++;
		      }
		      if (lastGeneratedColumn < mapping.generatedColumn) {
		        var nextLine = remainingLines[remainingLinesIndex] || '';
		        node.add(nextLine.substr(0, mapping.generatedColumn));
		        remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn);
		        lastGeneratedColumn = mapping.generatedColumn;
		      }
		      lastMapping = mapping;
		    }, this);
		    // We have processed all mappings.
		    if (remainingLinesIndex < remainingLines.length) {
		      if (lastMapping) {
		        // Associate the remaining code in the current line with "lastMapping"
		        addMappingWithCode(lastMapping, shiftNextLine());
		      }
		      // and add the remaining lines without any mapping
		      node.add(remainingLines.splice(remainingLinesIndex).join(""));
		    }

		    // Copy sourcesContent into SourceNode
		    aSourceMapConsumer.sources.forEach(function (sourceFile) {
		      var content = aSourceMapConsumer.sourceContentFor(sourceFile);
		      if (content != null) {
		        if (aRelativePath != null) {
		          sourceFile = util.join(aRelativePath, sourceFile);
		        }
		        node.setSourceContent(sourceFile, content);
		      }
		    });

		    return node;

		    function addMappingWithCode(mapping, code) {
		      if (mapping === null || mapping.source === undefined) {
		        node.add(code);
		      } else {
		        var source = aRelativePath
		          ? util.join(aRelativePath, mapping.source)
		          : mapping.source;
		        node.add(new SourceNode(mapping.originalLine,
		                                mapping.originalColumn,
		                                source,
		                                code,
		                                mapping.name));
		      }
		    }
		  };

		/**
		 * Add a chunk of generated JS to this source node.
		 *
		 * @param aChunk A string snippet of generated JS code, another instance of
		 *        SourceNode, or an array where each member is one of those things.
		 */
		SourceNode.prototype.add = function SourceNode_add(aChunk) {
		  if (Array.isArray(aChunk)) {
		    aChunk.forEach(function (chunk) {
		      this.add(chunk);
		    }, this);
		  }
		  else if (aChunk[isSourceNode] || typeof aChunk === "string") {
		    if (aChunk) {
		      this.children.push(aChunk);
		    }
		  }
		  else {
		    throw new TypeError(
		      "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
		    );
		  }
		  return this;
		};

		/**
		 * Add a chunk of generated JS to the beginning of this source node.
		 *
		 * @param aChunk A string snippet of generated JS code, another instance of
		 *        SourceNode, or an array where each member is one of those things.
		 */
		SourceNode.prototype.prepend = function SourceNode_prepend(aChunk) {
		  if (Array.isArray(aChunk)) {
		    for (var i = aChunk.length-1; i >= 0; i--) {
		      this.prepend(aChunk[i]);
		    }
		  }
		  else if (aChunk[isSourceNode] || typeof aChunk === "string") {
		    this.children.unshift(aChunk);
		  }
		  else {
		    throw new TypeError(
		      "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
		    );
		  }
		  return this;
		};

		/**
		 * Walk over the tree of JS snippets in this node and its children. The
		 * walking function is called once for each snippet of JS and is passed that
		 * snippet and the its original associated source's line/column location.
		 *
		 * @param aFn The traversal function.
		 */
		SourceNode.prototype.walk = function SourceNode_walk(aFn) {
		  var chunk;
		  for (var i = 0, len = this.children.length; i < len; i++) {
		    chunk = this.children[i];
		    if (chunk[isSourceNode]) {
		      chunk.walk(aFn);
		    }
		    else {
		      if (chunk !== '') {
		        aFn(chunk, { source: this.source,
		                     line: this.line,
		                     column: this.column,
		                     name: this.name });
		      }
		    }
		  }
		};

		/**
		 * Like `String.prototype.join` except for SourceNodes. Inserts `aStr` between
		 * each of `this.children`.
		 *
		 * @param aSep The separator.
		 */
		SourceNode.prototype.join = function SourceNode_join(aSep) {
		  var newChildren;
		  var i;
		  var len = this.children.length;
		  if (len > 0) {
		    newChildren = [];
		    for (i = 0; i < len-1; i++) {
		      newChildren.push(this.children[i]);
		      newChildren.push(aSep);
		    }
		    newChildren.push(this.children[i]);
		    this.children = newChildren;
		  }
		  return this;
		};

		/**
		 * Call String.prototype.replace on the very right-most source snippet. Useful
		 * for trimming whitespace from the end of a source node, etc.
		 *
		 * @param aPattern The pattern to replace.
		 * @param aReplacement The thing to replace the pattern with.
		 */
		SourceNode.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
		  var lastChild = this.children[this.children.length - 1];
		  if (lastChild[isSourceNode]) {
		    lastChild.replaceRight(aPattern, aReplacement);
		  }
		  else if (typeof lastChild === 'string') {
		    this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
		  }
		  else {
		    this.children.push(''.replace(aPattern, aReplacement));
		  }
		  return this;
		};

		/**
		 * Set the source content for a source file. This will be added to the SourceMapGenerator
		 * in the sourcesContent field.
		 *
		 * @param aSourceFile The filename of the source file
		 * @param aSourceContent The content of the source file
		 */
		SourceNode.prototype.setSourceContent =
		  function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
		    this.sourceContents[util.toSetString(aSourceFile)] = aSourceContent;
		  };

		/**
		 * Walk over the tree of SourceNodes. The walking function is called for each
		 * source file content and is passed the filename and source content.
		 *
		 * @param aFn The traversal function.
		 */
		SourceNode.prototype.walkSourceContents =
		  function SourceNode_walkSourceContents(aFn) {
		    for (var i = 0, len = this.children.length; i < len; i++) {
		      if (this.children[i][isSourceNode]) {
		        this.children[i].walkSourceContents(aFn);
		      }
		    }

		    var sources = Object.keys(this.sourceContents);
		    for (var i = 0, len = sources.length; i < len; i++) {
		      aFn(util.fromSetString(sources[i]), this.sourceContents[sources[i]]);
		    }
		  };

		/**
		 * Return the string representation of this source node. Walks over the tree
		 * and concatenates all the various snippets together to one string.
		 */
		SourceNode.prototype.toString = function SourceNode_toString() {
		  var str = "";
		  this.walk(function (chunk) {
		    str += chunk;
		  });
		  return str;
		};

		/**
		 * Returns the string representation of this source node along with a source
		 * map.
		 */
		SourceNode.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
		  var generated = {
		    code: "",
		    line: 1,
		    column: 0
		  };
		  var map = new SourceMapGenerator(aArgs);
		  var sourceMappingActive = false;
		  var lastOriginalSource = null;
		  var lastOriginalLine = null;
		  var lastOriginalColumn = null;
		  var lastOriginalName = null;
		  this.walk(function (chunk, original) {
		    generated.code += chunk;
		    if (original.source !== null
		        && original.line !== null
		        && original.column !== null) {
		      if(lastOriginalSource !== original.source
		         || lastOriginalLine !== original.line
		         || lastOriginalColumn !== original.column
		         || lastOriginalName !== original.name) {
		        map.addMapping({
		          source: original.source,
		          original: {
		            line: original.line,
		            column: original.column
		          },
		          generated: {
		            line: generated.line,
		            column: generated.column
		          },
		          name: original.name
		        });
		      }
		      lastOriginalSource = original.source;
		      lastOriginalLine = original.line;
		      lastOriginalColumn = original.column;
		      lastOriginalName = original.name;
		      sourceMappingActive = true;
		    } else if (sourceMappingActive) {
		      map.addMapping({
		        generated: {
		          line: generated.line,
		          column: generated.column
		        }
		      });
		      lastOriginalSource = null;
		      sourceMappingActive = false;
		    }
		    for (var idx = 0, length = chunk.length; idx < length; idx++) {
		      if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
		        generated.line++;
		        generated.column = 0;
		        // Mappings end at eol
		        if (idx + 1 === length) {
		          lastOriginalSource = null;
		          sourceMappingActive = false;
		        } else if (sourceMappingActive) {
		          map.addMapping({
		            source: original.source,
		            original: {
		              line: original.line,
		              column: original.column
		            },
		            generated: {
		              line: generated.line,
		              column: generated.column
		            },
		            name: original.name
		          });
		        }
		      } else {
		        generated.column++;
		      }
		    }
		  });
		  this.walkSourceContents(function (sourceFile, sourceContent) {
		    map.setSourceContent(sourceFile, sourceContent);
		  });

		  return { code: generated.code, map: map };
		};

		sourceNode.SourceNode = SourceNode;
		return sourceNode;
	}

	/*
	 * Copyright 2009-2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE.txt or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */

	var hasRequiredSourceMap;

	function requireSourceMap () {
		if (hasRequiredSourceMap) return sourceMap;
		hasRequiredSourceMap = 1;
		sourceMap.SourceMapGenerator = requireSourceMapGenerator().SourceMapGenerator;
		sourceMap.SourceMapConsumer = requireSourceMapConsumer().SourceMapConsumer;
		sourceMap.SourceNode = requireSourceNode().SourceNode;
		return sourceMap;
	}

	var inputSourceMapTracker_1;
	var hasRequiredInputSourceMapTracker;

	function requireInputSourceMapTracker () {
		if (hasRequiredInputSourceMapTracker) return inputSourceMapTracker_1;
		hasRequiredInputSourceMapTracker = 1;
		var SourceMapConsumer = requireSourceMap().SourceMapConsumer;

		function inputSourceMapTracker() {
		  var maps = {};

		  return {
		    all: all.bind(null, maps),
		    isTracking: isTracking.bind(null, maps),
		    originalPositionFor: originalPositionFor.bind(null, maps),
		    track: track.bind(null, maps)
		  };
		}

		function all(maps) {
		  return maps;
		}

		function isTracking(maps, source) {
		  return source in maps;
		}

		function originalPositionFor(maps, metadata, range, selectorFallbacks) {
		  var line = metadata[0];
		  var column = metadata[1];
		  var source = metadata[2];
		  var position = {
		    line: line,
		    column: column + range
		  };
		  var originalPosition;

		  while (!originalPosition && position.column > column) {
		    position.column--;
		    originalPosition = maps[source].originalPositionFor(position);
		  }

		  if (!originalPosition || originalPosition.column < 0) {
		    return metadata;
		  }

		  if (originalPosition.line === null && line > 1 && selectorFallbacks > 0) {
		    return originalPositionFor(maps, [line - 1, column, source], range, selectorFallbacks - 1);
		  }

		  return originalPosition.line !== null
		    ? toMetadata(originalPosition)
		    : metadata;
		}

		function toMetadata(asHash) {
		  return [asHash.line, asHash.column, asHash.source];
		}

		function track(maps, source, data) {
		  maps[source] = new SourceMapConsumer(data);
		}

		inputSourceMapTracker_1 = inputSourceMapTracker;
		return inputSourceMapTracker_1;
	}

	var _polyfillNode_fs = {};

	var _polyfillNode_fs$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		default: _polyfillNode_fs
	});

	var require$$0 = /*@__PURE__*/getAugmentedNamespace(_polyfillNode_fs$1);

	var isRemoteResource_1;
	var hasRequiredIsRemoteResource;

	function requireIsRemoteResource () {
		if (hasRequiredIsRemoteResource) return isRemoteResource_1;
		hasRequiredIsRemoteResource = 1;
		var REMOTE_RESOURCE_PATTERN = /^(\w+:\/\/|\/\/)/;
		var FILE_RESOURCE_PATTERN = /^file:\/\//;

		function isRemoteResource(uri) {
		  return REMOTE_RESOURCE_PATTERN.test(uri) && !FILE_RESOURCE_PATTERN.test(uri);
		}

		isRemoteResource_1 = isRemoteResource;
		return isRemoteResource_1;
	}

	var hasProtocol_1;
	var hasRequiredHasProtocol;

	function requireHasProtocol () {
		if (hasRequiredHasProtocol) return hasProtocol_1;
		hasRequiredHasProtocol = 1;
		var NO_PROTOCOL_RESOURCE_PATTERN = /^\/\//;

		function hasProtocol(uri) {
		  return !NO_PROTOCOL_RESOURCE_PATTERN.test(uri);
		}

		hasProtocol_1 = hasProtocol;
		return hasProtocol_1;
	}

	var isAllowedResource_1;
	var hasRequiredIsAllowedResource;

	function requireIsAllowedResource () {
		if (hasRequiredIsAllowedResource) return isAllowedResource_1;
		hasRequiredIsAllowedResource = 1;
		var path = require$$1;
		var url = require$$0$1;

		var isRemoteResource = requireIsRemoteResource();
		var hasProtocol = requireHasProtocol();

		var HTTP_PROTOCOL = 'http:';

		function isAllowedResource(uri, isRemote, rules) {
		  var match;
		  var absoluteUri;
		  var allowed = !isRemote;
		  var rule;
		  var isNegated;
		  var normalizedRule;
		  var i;

		  if (rules.length === 0) {
		    return false;
		  }

		  if (isRemote && !hasProtocol(uri)) {
		    uri = HTTP_PROTOCOL + uri;
		  }

		  match = isRemote
		    ? url.parse(uri).host
		    : uri;

		  absoluteUri = isRemote
		    ? uri
		    : path.resolve(uri);

		  for (i = 0; i < rules.length; i++) {
		    rule = rules[i];
		    isNegated = rule[0] == '!';
		    normalizedRule = rule.substring(1);

		    if (isNegated && isRemote && isRemoteRule(normalizedRule)) {
		      allowed = allowed && !isAllowedResource(uri, true, [normalizedRule]);
		    } else if (isNegated && !isRemote && !isRemoteRule(normalizedRule)) {
		      allowed = allowed && !isAllowedResource(uri, false, [normalizedRule]);
		    } else if (isNegated) {
		      allowed = allowed && true;
		    } else if (rule == 'all') {
		      allowed = true;
		    } else if (isRemote && rule == 'local') {
		      allowed = allowed || false;
		    } else if (isRemote && rule == 'remote') {
		      allowed = true;
		    } else if (!isRemote && rule == 'remote') {
		      allowed = false;
		    } else if (!isRemote && rule == 'local') {
		      allowed = true;
		    } else if (rule === match) {
		      allowed = true;
		    } else if (rule === uri) {
		      allowed = true;
		    } else if (isRemote && absoluteUri.indexOf(rule) === 0) {
		      allowed = true;
		    } else if (!isRemote && absoluteUri.indexOf(path.resolve(rule)) === 0) {
		      allowed = true;
		    } else if (isRemote != isRemoteRule(normalizedRule)) {
		      allowed = allowed && true;
		    } else {
		      allowed = false;
		    }
		  }

		  return allowed;
		}

		function isRemoteRule(rule) {
		  return isRemoteResource(rule) || url.parse(HTTP_PROTOCOL + '//' + rule).host == rule;
		}

		isAllowedResource_1 = isAllowedResource;
		return isAllowedResource_1;
	}

	var matchDataUri_1;
	var hasRequiredMatchDataUri;

	function requireMatchDataUri () {
		if (hasRequiredMatchDataUri) return matchDataUri_1;
		hasRequiredMatchDataUri = 1;
		var DATA_URI_PATTERN = /^data:(\S*?)?(;charset=(?:(?!;charset=)[^;])+)?(;[^,]+?)?,(.+)/;

		function matchDataUri(uri) {
		  return DATA_URI_PATTERN.exec(uri);
		}

		matchDataUri_1 = matchDataUri;
		return matchDataUri_1;
	}

	var rebaseLocalMap_1;
	var hasRequiredRebaseLocalMap;

	function requireRebaseLocalMap () {
		if (hasRequiredRebaseLocalMap) return rebaseLocalMap_1;
		hasRequiredRebaseLocalMap = 1;
		var path = require$$1;

		function rebaseLocalMap(sourceMap, sourceUri, rebaseTo) {
		  var currentPath = path.resolve('');
		  var absoluteUri = path.resolve(currentPath, sourceUri);
		  var absoluteUriDirectory = path.dirname(absoluteUri);

		  sourceMap.sources = sourceMap.sources.map(function(source) {
		    return path.relative(rebaseTo, path.resolve(absoluteUriDirectory, source));
		  });

		  return sourceMap;
		}

		rebaseLocalMap_1 = rebaseLocalMap;
		return rebaseLocalMap_1;
	}

	var rebaseRemoteMap_1;
	var hasRequiredRebaseRemoteMap;

	function requireRebaseRemoteMap () {
		if (hasRequiredRebaseRemoteMap) return rebaseRemoteMap_1;
		hasRequiredRebaseRemoteMap = 1;
		var path = require$$1;
		var url = require$$0$1;

		function rebaseRemoteMap(sourceMap, sourceUri) {
		  var sourceDirectory = path.dirname(sourceUri);

		  sourceMap.sources = sourceMap.sources.map(function(source) {
		    return url.resolve(sourceDirectory, source);
		  });

		  return sourceMap;
		}

		rebaseRemoteMap_1 = rebaseRemoteMap;
		return rebaseRemoteMap_1;
	}

	var isDataUriResource_1;
	var hasRequiredIsDataUriResource;

	function requireIsDataUriResource () {
		if (hasRequiredIsDataUriResource) return isDataUriResource_1;
		hasRequiredIsDataUriResource = 1;
		var DATA_URI_PATTERN = /^data:(\S{0,31}?)?(;charset=(?:(?!;charset=)[^;])+)?(;[^,]+?)?,(.+)/;

		function isDataUriResource(uri) {
		  return DATA_URI_PATTERN.test(uri);
		}

		isDataUriResource_1 = isDataUriResource;
		return isDataUriResource_1;
	}

	var applySourceMaps_1;
	var hasRequiredApplySourceMaps;

	function requireApplySourceMaps () {
		if (hasRequiredApplySourceMaps) return applySourceMaps_1;
		hasRequiredApplySourceMaps = 1;
		var fs = require$$0;
		var path = require$$1;

		var isAllowedResource = requireIsAllowedResource();
		var matchDataUri = requireMatchDataUri();
		var rebaseLocalMap = requireRebaseLocalMap();
		var rebaseRemoteMap = requireRebaseRemoteMap();

		var Token = requireToken();
		var hasProtocol = requireHasProtocol();
		var isDataUriResource = requireIsDataUriResource();
		var isRemoteResource = requireIsRemoteResource();

		var MAP_MARKER_PATTERN = /^\/\*# sourceMappingURL=(\S+) \*\/$/;

		function applySourceMaps(tokens, context, callback) {
		  var applyContext = {
		    callback: callback,
		    fetch: context.options.fetch,
		    index: 0,
		    inline: context.options.inline,
		    inlineRequest: context.options.inlineRequest,
		    inlineTimeout: context.options.inlineTimeout,
		    inputSourceMapTracker: context.inputSourceMapTracker,
		    localOnly: context.localOnly,
		    processedTokens: [],
		    rebaseTo: context.options.rebaseTo,
		    sourceTokens: tokens,
		    warnings: context.warnings
		  };

		  return context.options.sourceMap && tokens.length > 0
		    ? doApplySourceMaps(applyContext)
		    : callback(tokens);
		}

		function doApplySourceMaps(applyContext) {
		  var singleSourceTokens = [];
		  var lastSource = findTokenSource(applyContext.sourceTokens[0]);
		  var source;
		  var token;
		  var l;

		  for (l = applyContext.sourceTokens.length; applyContext.index < l; applyContext.index++) {
		    token = applyContext.sourceTokens[applyContext.index];
		    source = findTokenSource(token);

		    if (source != lastSource) {
		      singleSourceTokens = [];
		      lastSource = source;
		    }

		    singleSourceTokens.push(token);
		    applyContext.processedTokens.push(token);

		    if (token[0] == Token.COMMENT && MAP_MARKER_PATTERN.test(token[1])) {
		      return fetchAndApplySourceMap(token[1], source, singleSourceTokens, applyContext);
		    }
		  }

		  return applyContext.callback(applyContext.processedTokens);
		}

		function findTokenSource(token) {
		  var scope;
		  var metadata;

		  if (token[0] == Token.AT_RULE || token[0] == Token.COMMENT || token[0] == Token.RAW) {
		    metadata = token[2][0];
		  } else {
		    scope = token[1][0];
		    metadata = scope[2][0];
		  }

		  return metadata[2];
		}

		function fetchAndApplySourceMap(sourceMapComment, source, singleSourceTokens, applyContext) {
		  return extractInputSourceMapFrom(sourceMapComment, applyContext, function(inputSourceMap) {
		    if (inputSourceMap) {
		      applyContext.inputSourceMapTracker.track(source, inputSourceMap);
		      applySourceMapRecursively(singleSourceTokens, applyContext.inputSourceMapTracker);
		    }

		    applyContext.index++;
		    return doApplySourceMaps(applyContext);
		  });
		}

		function extractInputSourceMapFrom(sourceMapComment, applyContext, whenSourceMapReady) {
		  var uri = MAP_MARKER_PATTERN.exec(sourceMapComment)[1];
		  var absoluteUri;
		  var sourceMap;
		  var rebasedMap;

		  if (isDataUriResource(uri)) {
		    sourceMap = extractInputSourceMapFromDataUri(uri);
		    return whenSourceMapReady(sourceMap);
		  } if (isRemoteResource(uri)) {
		    return loadInputSourceMapFromRemoteUri(uri, applyContext, function(sourceMap) {
		      var parsedMap;

		      if (sourceMap) {
		        parsedMap = JSON.parse(sourceMap);
		        rebasedMap = rebaseRemoteMap(parsedMap, uri);
		        whenSourceMapReady(rebasedMap);
		      } else {
		        whenSourceMapReady(null);
		      }
		    });
		  }
		  // at this point `uri` is already rebased, see lib/reader/rebase.js#rebaseSourceMapComment
		  // it is rebased to be consistent with rebasing other URIs
		  // however here we need to resolve it back to read it from disk
		  absoluteUri = path.resolve(applyContext.rebaseTo, uri);
		  sourceMap = loadInputSourceMapFromLocalUri(absoluteUri, applyContext);

		  if (sourceMap) {
		    rebasedMap = rebaseLocalMap(sourceMap, absoluteUri, applyContext.rebaseTo);
		    return whenSourceMapReady(rebasedMap);
		  }
		  return whenSourceMapReady(null);
		}

		function extractInputSourceMapFromDataUri(uri) {
		  var dataUriMatch = matchDataUri(uri);
		  var charset = dataUriMatch[2] ? dataUriMatch[2].split(/[=;]/)[2] : 'us-ascii';
		  var encoding = dataUriMatch[3] ? dataUriMatch[3].split(';')[1] : 'utf8';
		  var data = encoding == 'utf8' ? commonjsGlobal.unescape(dataUriMatch[4]) : dataUriMatch[4];

		  var buffer = Buffer$1.from(data, encoding);
		  buffer.charset = charset;

		  return JSON.parse(buffer.toString());
		}

		function loadInputSourceMapFromRemoteUri(uri, applyContext, whenLoaded) {
		  var isAllowed = isAllowedResource(uri, true, applyContext.inline);
		  var isRuntimeResource = !hasProtocol(uri);

		  if (applyContext.localOnly) {
		    applyContext.warnings.push('Cannot fetch remote resource from "' + uri + '" as no callback given.');
		    return whenLoaded(null);
		  } if (isRuntimeResource) {
		    applyContext.warnings.push('Cannot fetch "' + uri + '" as no protocol given.');
		    return whenLoaded(null);
		  } if (!isAllowed) {
		    applyContext.warnings.push('Cannot fetch "' + uri + '" as resource is not allowed.');
		    return whenLoaded(null);
		  }

		  applyContext.fetch(uri, applyContext.inlineRequest, applyContext.inlineTimeout, function(error, body) {
		    if (error) {
		      applyContext.warnings.push('Missing source map at "' + uri + '" - ' + error);
		      return whenLoaded(null);
		    }

		    whenLoaded(body);
		  });
		}

		function loadInputSourceMapFromLocalUri(uri, applyContext) {
		  var isAllowed = isAllowedResource(uri, false, applyContext.inline);
		  var sourceMap;

		  if (!fs.existsSync(uri) || !fs.statSync(uri).isFile()) {
		    applyContext.warnings.push('Ignoring local source map at "' + uri + '" as resource is missing.');
		    return null;
		  } if (!isAllowed) {
		    applyContext.warnings.push('Cannot fetch "' + uri + '" as resource is not allowed.');
		    return null;
		  } if (!fs.statSync(uri).size) {
		    applyContext.warnings.push('Cannot fetch "' + uri + '" as resource is empty.');
		    return null;
		  }

		  sourceMap = fs.readFileSync(uri, 'utf-8');
		  return JSON.parse(sourceMap);
		}

		function applySourceMapRecursively(tokens, inputSourceMapTracker) {
		  var token;
		  var i, l;

		  for (i = 0, l = tokens.length; i < l; i++) {
		    token = tokens[i];

		    switch (token[0]) {
		    case Token.AT_RULE:
		      applySourceMapTo(token, inputSourceMapTracker);
		      break;
		    case Token.AT_RULE_BLOCK:
		      applySourceMapRecursively(token[1], inputSourceMapTracker);
		      applySourceMapRecursively(token[2], inputSourceMapTracker);
		      break;
		    case Token.AT_RULE_BLOCK_SCOPE:
		      applySourceMapTo(token, inputSourceMapTracker);
		      break;
		    case Token.NESTED_BLOCK:
		      applySourceMapRecursively(token[1], inputSourceMapTracker);
		      applySourceMapRecursively(token[2], inputSourceMapTracker);
		      break;
		    case Token.NESTED_BLOCK_SCOPE:
		      applySourceMapTo(token, inputSourceMapTracker);
		      break;
		    case Token.COMMENT:
		      applySourceMapTo(token, inputSourceMapTracker);
		      break;
		    case Token.PROPERTY:
		      applySourceMapRecursively(token, inputSourceMapTracker);
		      break;
		    case Token.PROPERTY_BLOCK:
		      applySourceMapRecursively(token[1], inputSourceMapTracker);
		      break;
		    case Token.PROPERTY_NAME:
		      applySourceMapTo(token, inputSourceMapTracker);
		      break;
		    case Token.PROPERTY_VALUE:
		      applySourceMapTo(token, inputSourceMapTracker);
		      break;
		    case Token.RULE:
		      applySourceMapRecursively(token[1], inputSourceMapTracker);
		      applySourceMapRecursively(token[2], inputSourceMapTracker);
		      break;
		    case Token.RULE_SCOPE:
		      applySourceMapTo(token, inputSourceMapTracker);
		    }
		  }

		  return tokens;
		}

		function applySourceMapTo(token, inputSourceMapTracker) {
		  var value = token[1];
		  var metadata = token[2];
		  var newMetadata = [];
		  var i, l;

		  for (i = 0, l = metadata.length; i < l; i++) {
		    newMetadata.push(inputSourceMapTracker.originalPositionFor(metadata[i], value.length));
		  }

		  token[2] = newMetadata;
		}

		applySourceMaps_1 = applySourceMaps;
		return applySourceMaps_1;
	}

	var extractImportUrlAndMedia_1;
	var hasRequiredExtractImportUrlAndMedia;

	function requireExtractImportUrlAndMedia () {
		if (hasRequiredExtractImportUrlAndMedia) return extractImportUrlAndMedia_1;
		hasRequiredExtractImportUrlAndMedia = 1;
		var split = requireSplit();

		var BRACE_PREFIX = /^\(/;
		var BRACE_SUFFIX = /\)$/;
		var IMPORT_PREFIX_PATTERN = /^@import/i;
		var QUOTE_PREFIX_PATTERN = /['"]\s{0,31}/;
		var QUOTE_SUFFIX_PATTERN = /\s{0,31}['"]/;
		var URL_PREFIX_PATTERN = /^url\(\s{0,31}/i;
		var URL_SUFFIX_PATTERN = /\s{0,31}\)/i;

		function extractImportUrlAndMedia(atRuleValue) {
		  var uri;
		  var mediaQuery;
		  var normalized;
		  var parts;

		  normalized = atRuleValue
		    .replace(IMPORT_PREFIX_PATTERN, '')
		    .trim()
		    .replace(URL_PREFIX_PATTERN, '(')
		    .replace(URL_SUFFIX_PATTERN, ') ')
		    .replace(QUOTE_PREFIX_PATTERN, '')
		    .replace(QUOTE_SUFFIX_PATTERN, '');

		  parts = split(normalized, ' ');

		  uri = parts[0]
		    .replace(BRACE_PREFIX, '')
		    .replace(BRACE_SUFFIX, '');
		  mediaQuery = parts.slice(1).join(' ');

		  return [uri, mediaQuery];
		}

		extractImportUrlAndMedia_1 = extractImportUrlAndMedia;
		return extractImportUrlAndMedia_1;
	}

	var loadOriginalSources_1;
	var hasRequiredLoadOriginalSources;

	function requireLoadOriginalSources () {
		if (hasRequiredLoadOriginalSources) return loadOriginalSources_1;
		hasRequiredLoadOriginalSources = 1;
		var fs = require$$0;
		var path = require$$1;

		var isAllowedResource = requireIsAllowedResource();

		var hasProtocol = requireHasProtocol();
		var isRemoteResource = requireIsRemoteResource();

		function loadOriginalSources(context, callback) {
		  var loadContext = {
		    callback: callback,
		    fetch: context.options.fetch,
		    index: 0,
		    inline: context.options.inline,
		    inlineRequest: context.options.inlineRequest,
		    inlineTimeout: context.options.inlineTimeout,
		    localOnly: context.localOnly,
		    rebaseTo: context.options.rebaseTo,
		    sourcesContent: context.sourcesContent,
		    uriToSource: uriToSourceMapping(context.inputSourceMapTracker.all()),
		    warnings: context.warnings
		  };

		  return context.options.sourceMap && context.options.sourceMapInlineSources
		    ? doLoadOriginalSources(loadContext)
		    : callback();
		}

		function uriToSourceMapping(allSourceMapConsumers) {
		  var mapping = {};
		  var consumer;
		  var uri;
		  var source;
		  var i, l;

		  for (source in allSourceMapConsumers) {
		    consumer = allSourceMapConsumers[source];

		    for (i = 0, l = consumer.sources.length; i < l; i++) {
		      uri = consumer.sources[i];
		      source = consumer.sourceContentFor(uri, true);

		      mapping[uri] = source;
		    }
		  }

		  return mapping;
		}

		function doLoadOriginalSources(loadContext) {
		  var uris = Object.keys(loadContext.uriToSource);
		  var uri;
		  var source;
		  var total;

		  for (total = uris.length; loadContext.index < total; loadContext.index++) {
		    uri = uris[loadContext.index];
		    source = loadContext.uriToSource[uri];

		    if (source) {
		      loadContext.sourcesContent[uri] = source;
		    } else {
		      return loadOriginalSource(uri, loadContext);
		    }
		  }

		  return loadContext.callback();
		}

		function loadOriginalSource(uri, loadContext) {
		  var content;

		  if (isRemoteResource(uri)) {
		    return loadOriginalSourceFromRemoteUri(uri, loadContext, function(content) {
		      loadContext.index++;
		      loadContext.sourcesContent[uri] = content;
		      return doLoadOriginalSources(loadContext);
		    });
		  }
		  content = loadOriginalSourceFromLocalUri(uri, loadContext);
		  loadContext.index++;
		  loadContext.sourcesContent[uri] = content;
		  return doLoadOriginalSources(loadContext);
		}

		function loadOriginalSourceFromRemoteUri(uri, loadContext, whenLoaded) {
		  var isAllowed = isAllowedResource(uri, true, loadContext.inline);
		  var isRuntimeResource = !hasProtocol(uri);

		  if (loadContext.localOnly) {
		    loadContext.warnings.push('Cannot fetch remote resource from "' + uri + '" as no callback given.');
		    return whenLoaded(null);
		  } if (isRuntimeResource) {
		    loadContext.warnings.push('Cannot fetch "' + uri + '" as no protocol given.');
		    return whenLoaded(null);
		  } if (!isAllowed) {
		    loadContext.warnings.push('Cannot fetch "' + uri + '" as resource is not allowed.');
		    return whenLoaded(null);
		  }

		  loadContext.fetch(uri, loadContext.inlineRequest, loadContext.inlineTimeout, function(error, content) {
		    if (error) {
		      loadContext.warnings.push('Missing original source at "' + uri + '" - ' + error);
		    }

		    whenLoaded(content);
		  });
		}

		function loadOriginalSourceFromLocalUri(relativeUri, loadContext) {
		  var isAllowed = isAllowedResource(relativeUri, false, loadContext.inline);
		  var absoluteUri = path.resolve(loadContext.rebaseTo, relativeUri);

		  if (!fs.existsSync(absoluteUri) || !fs.statSync(absoluteUri).isFile()) {
		    loadContext.warnings.push('Ignoring local source map at "' + absoluteUri + '" as resource is missing.');
		    return null;
		  } if (!isAllowed) {
		    loadContext.warnings.push('Cannot fetch "' + absoluteUri + '" as resource is not allowed.');
		    return null;
		  }

		  var result = fs.readFileSync(absoluteUri, 'utf8');
		  if (result.charCodeAt(0) === 65279) {
		    result = result.substring(1);
		  }
		  return result;
		}

		loadOriginalSources_1 = loadOriginalSources;
		return loadOriginalSources_1;
	}

	var normalizePath_1;
	var hasRequiredNormalizePath;

	function requireNormalizePath () {
		if (hasRequiredNormalizePath) return normalizePath_1;
		hasRequiredNormalizePath = 1;
		var UNIX_SEPARATOR = '/';
		var WINDOWS_SEPARATOR_PATTERN = /\\/g;

		function normalizePath(path) {
		  return path.replace(WINDOWS_SEPARATOR_PATTERN, UNIX_SEPARATOR);
		}

		normalizePath_1 = normalizePath;
		return normalizePath_1;
	}

	var restoreImport_1;
	var hasRequiredRestoreImport;

	function requireRestoreImport () {
		if (hasRequiredRestoreImport) return restoreImport_1;
		hasRequiredRestoreImport = 1;
		function restoreImport(uri, mediaQuery) {
		  return ('@import ' + uri + ' ' + mediaQuery).trim();
		}

		restoreImport_1 = restoreImport;
		return restoreImport_1;
	}

	var rewriteUrl_1;
	var hasRequiredRewriteUrl;

	function requireRewriteUrl () {
		if (hasRequiredRewriteUrl) return rewriteUrl_1;
		hasRequiredRewriteUrl = 1;
		var path = require$$1;
		var url = require$$0$1;

		var isDataUriResource = requireIsDataUriResource();

		var DOUBLE_QUOTE = '"';
		var SINGLE_QUOTE = '\'';
		var URL_PREFIX = 'url(';
		var URL_SUFFIX = ')';

		var PROTOCOL_LESS_PREFIX_PATTERN = /^[^\w\d]*\/\//;
		var QUOTE_PREFIX_PATTERN = /^["']/;
		var QUOTE_SUFFIX_PATTERN = /["']$/;
		var ROUND_BRACKETS_PATTERN = /[()]/;
		var URL_PREFIX_PATTERN = /^url\(/i;
		var URL_SUFFIX_PATTERN = /\)$/;
		var WHITESPACE_PATTERN = /\s/;

		function rebase(uri, rebaseConfig) {
		  if (!rebaseConfig) {
		    return uri;
		  }

		  if (isAbsolute(uri) && !isRemote(rebaseConfig.toBase)) {
		    return uri;
		  }

		  if (isRemote(uri) || isSVGMarker(uri) || isInternal(uri) || isDataUriResource(uri)) {
		    return uri;
		  }

		  if (isRemote(rebaseConfig.toBase)) {
		    return url.resolve(rebaseConfig.toBase, uri);
		  }

		  return rebaseConfig.absolute
		    ? normalize(absolute(uri, rebaseConfig))
		    : normalize(relative(uri, rebaseConfig));
		}

		function isAbsolute(uri) {
		  return path.isAbsolute(uri);
		}

		function isSVGMarker(uri) {
		  return uri[0] == '#';
		}

		function isInternal(uri) {
		  return /^\w+:\w+/.test(uri);
		}

		function isRemote(uri) {
		  return /^[^:]+?:\/\//.test(uri) || PROTOCOL_LESS_PREFIX_PATTERN.test(uri);
		}

		function absolute(uri, rebaseConfig) {
		  return path
		    .resolve(path.join(rebaseConfig.fromBase || '', uri))
		    .replace(rebaseConfig.toBase, '');
		}

		function relative(uri, rebaseConfig) {
		  return path.relative(rebaseConfig.toBase, path.join(rebaseConfig.fromBase || '', uri));
		}

		function normalize(uri) {
		  return uri;
		}

		function quoteFor(unquotedUrl) {
		  if (unquotedUrl.indexOf(SINGLE_QUOTE) > -1) {
		    return DOUBLE_QUOTE;
		  } if (unquotedUrl.indexOf(DOUBLE_QUOTE) > -1) {
		    return SINGLE_QUOTE;
		  } if (hasWhitespace(unquotedUrl) || hasRoundBrackets(unquotedUrl)) {
		    return SINGLE_QUOTE;
		  }
		  return '';
		}

		function hasWhitespace(url) {
		  return WHITESPACE_PATTERN.test(url);
		}

		function hasRoundBrackets(url) {
		  return ROUND_BRACKETS_PATTERN.test(url);
		}

		function rewriteUrl(originalUrl, rebaseConfig, pathOnly) {
		  var strippedUrl = originalUrl
		    .replace(URL_PREFIX_PATTERN, '')
		    .replace(URL_SUFFIX_PATTERN, '')
		    .trim();

		  var unquotedUrl = strippedUrl
		    .replace(QUOTE_PREFIX_PATTERN, '')
		    .replace(QUOTE_SUFFIX_PATTERN, '')
		    .trim();

		  var quote = strippedUrl[0] == SINGLE_QUOTE || strippedUrl[0] == DOUBLE_QUOTE
		    ? strippedUrl[0]
		    : quoteFor(unquotedUrl);

		  return pathOnly
		    ? rebase(unquotedUrl, rebaseConfig)
		    : URL_PREFIX + quote + rebase(unquotedUrl, rebaseConfig) + quote + URL_SUFFIX;
		}

		rewriteUrl_1 = rewriteUrl;
		return rewriteUrl_1;
	}

	var isImport_1;
	var hasRequiredIsImport;

	function requireIsImport () {
		if (hasRequiredIsImport) return isImport_1;
		hasRequiredIsImport = 1;
		var IMPORT_PREFIX_PATTERN = /^@import/i;

		function isImport(value) {
		  return IMPORT_PREFIX_PATTERN.test(value);
		}

		isImport_1 = isImport;
		return isImport_1;
	}

	var rebase_1;
	var hasRequiredRebase;

	function requireRebase () {
		if (hasRequiredRebase) return rebase_1;
		hasRequiredRebase = 1;
		var extractImportUrlAndMedia = requireExtractImportUrlAndMedia();
		var restoreImport = requireRestoreImport();
		var rewriteUrl = requireRewriteUrl();

		var Token = requireToken();
		var isImport = requireIsImport();

		var SOURCE_MAP_COMMENT_PATTERN = /^\/\*# sourceMappingURL=(\S+) \*\/$/;

		function rebase(tokens, rebaseAll, validator, rebaseConfig) {
		  return rebaseAll
		    ? rebaseEverything(tokens, validator, rebaseConfig)
		    : rebaseAtRules(tokens, validator, rebaseConfig);
		}

		function rebaseEverything(tokens, validator, rebaseConfig) {
		  var token;
		  var i, l;

		  for (i = 0, l = tokens.length; i < l; i++) {
		    token = tokens[i];

		    switch (token[0]) {
		    case Token.AT_RULE:
		      rebaseAtRule(token, validator, rebaseConfig);
		      break;
		    case Token.AT_RULE_BLOCK:
		      rebaseProperties(token[2], validator, rebaseConfig);
		      break;
		    case Token.COMMENT:
		      rebaseSourceMapComment(token, rebaseConfig);
		      break;
		    case Token.NESTED_BLOCK:
		      rebaseEverything(token[2], validator, rebaseConfig);
		      break;
		    case Token.RULE:
		      rebaseProperties(token[2], validator, rebaseConfig);
		      break;
		    }
		  }

		  return tokens;
		}

		function rebaseAtRules(tokens, validator, rebaseConfig) {
		  var token;
		  var i, l;

		  for (i = 0, l = tokens.length; i < l; i++) {
		    token = tokens[i];

		    switch (token[0]) {
		    case Token.AT_RULE:
		      rebaseAtRule(token, validator, rebaseConfig);
		      break;
		    }
		  }

		  return tokens;
		}

		function rebaseAtRule(token, validator, rebaseConfig) {
		  if (!isImport(token[1])) {
		    return;
		  }

		  var uriAndMediaQuery = extractImportUrlAndMedia(token[1]);
		  var newUrl = rewriteUrl(uriAndMediaQuery[0], rebaseConfig);
		  var mediaQuery = uriAndMediaQuery[1];

		  token[1] = restoreImport(newUrl, mediaQuery);
		}

		function rebaseSourceMapComment(token, rebaseConfig) {
		  var matches = SOURCE_MAP_COMMENT_PATTERN.exec(token[1]);

		  if (matches && matches[1].indexOf('data:') === -1) {
		    token[1] = token[1].replace(matches[1], rewriteUrl(matches[1], rebaseConfig, true));
		  }
		}

		function rebaseProperties(properties, validator, rebaseConfig) {
		  var property;
		  var value;
		  var i, l;
		  var j, m;

		  for (i = 0, l = properties.length; i < l; i++) {
		    property = properties[i];

		    for (j = 2 /* 0 is Token.PROPERTY, 1 is name */, m = property.length; j < m; j++) {
		      value = property[j][1];

		      if (validator.isUrl(value)) {
		        property[j][1] = rewriteUrl(value, rebaseConfig);
		      }
		    }
		  }
		}

		rebase_1 = rebase;
		return rebase_1;
	}

	var tokenize_1;
	var hasRequiredTokenize;

	function requireTokenize () {
		if (hasRequiredTokenize) return tokenize_1;
		hasRequiredTokenize = 1;
		var Marker = requireMarker();
		var Token = requireToken();

		var formatPosition = requireFormatPosition();

		var Level = {
		  BLOCK: 'block',
		  COMMENT: 'comment',
		  DOUBLE_QUOTE: 'double-quote',
		  RULE: 'rule',
		  SINGLE_QUOTE: 'single-quote'
		};

		var AT_RULES = [
		  '@charset',
		  '@import'
		];

		var BLOCK_RULES = [
		  '@-moz-document',
		  '@document',
		  '@-moz-keyframes',
		  '@-ms-keyframes',
		  '@-o-keyframes',
		  '@-webkit-keyframes',
		  '@keyframes',
		  '@media',
		  '@supports',
		  '@container',
		  '@layer'
		];

		var IGNORE_END_COMMENT_PATTERN = /\/\* clean-css ignore:end \*\/$/;
		var IGNORE_START_COMMENT_PATTERN = /^\/\* clean-css ignore:start \*\//;

		var PAGE_MARGIN_BOXES = [
		  '@bottom-center',
		  '@bottom-left',
		  '@bottom-left-corner',
		  '@bottom-right',
		  '@bottom-right-corner',
		  '@left-bottom',
		  '@left-middle',
		  '@left-top',
		  '@right-bottom',
		  '@right-middle',
		  '@right-top',
		  '@top-center',
		  '@top-left',
		  '@top-left-corner',
		  '@top-right',
		  '@top-right-corner'
		];

		var EXTRA_PAGE_BOXES = [
		  '@footnote',
		  '@footnotes',
		  '@left',
		  '@page-float-bottom',
		  '@page-float-top',
		  '@right'
		];

		var REPEAT_PATTERN = /^\[\s{0,31}\d+\s{0,31}\]$/;
		var TAIL_BROKEN_VALUE_PATTERN = /([^}])\}*$/;
		var RULE_WORD_SEPARATOR_PATTERN = /[\s(]/;

		function tokenize(source, externalContext) {
		  var internalContext = {
		    level: Level.BLOCK,
		    position: {
		      source: externalContext.source || undefined,
		      line: 1,
		      column: 0,
		      index: 0
		    }
		  };

		  return intoTokens(source, externalContext, internalContext, false);
		}

		function intoTokens(source, externalContext, internalContext, isNested) {
		  var allTokens = [];
		  var newTokens = allTokens;
		  var lastToken;
		  var ruleToken;
		  var ruleTokens = [];
		  var propertyToken;
		  var metadata;
		  var metadatas = [];
		  var level = internalContext.level;
		  var levels = [];
		  var buffer = [];
		  var buffers = [];
		  var isBufferEmpty = true;
		  var serializedBuffer;
		  var serializedBufferPart;
		  var roundBracketLevel = 0;
		  var isQuoted;
		  var isSpace;
		  var isNewLineNix;
		  var isNewLineWin;
		  var isCarriageReturn;
		  var isCommentStart;
		  var wasCommentStart = false;
		  var isCommentEnd;
		  var wasCommentEnd = false;
		  var isCommentEndMarker;
		  var isEscaped;
		  var wasEscaped = false;
		  var characterWithNoSpecialMeaning;
		  var isPreviousDash = false;
		  var isVariable = false;
		  var isRaw = false;
		  var seekingValue = false;
		  var seekingPropertyBlockClosing = false;
		  var position = internalContext.position;
		  var lastCommentStartAt;

		  for (; position.index < source.length; position.index++) {
		    var character = source[position.index];

		    isQuoted = level == Level.SINGLE_QUOTE || level == Level.DOUBLE_QUOTE;
		    isSpace = character == Marker.SPACE || character == Marker.TAB;
		    isNewLineNix = character == Marker.NEW_LINE_NIX;
		    isNewLineWin = character == Marker.NEW_LINE_NIX
		      && source[position.index - 1] == Marker.CARRIAGE_RETURN;
		    isCarriageReturn = character == Marker.CARRIAGE_RETURN
		      && source[position.index + 1] && source[position.index + 1] != Marker.NEW_LINE_NIX;
		    isCommentStart = !wasCommentEnd
		      && level != Level.COMMENT && !isQuoted
		      && character == Marker.ASTERISK && source[position.index - 1] == Marker.FORWARD_SLASH;
		    isCommentEndMarker = !wasCommentStart
		      && !isQuoted && character == Marker.FORWARD_SLASH
		      && source[position.index - 1] == Marker.ASTERISK;
		    isCommentEnd = level == Level.COMMENT && isCommentEndMarker;
		    characterWithNoSpecialMeaning = !isSpace && !isCarriageReturn && (character >= 'A' && character <= 'Z' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '-');
		    isVariable = isVariable || (level != Level.COMMENT && !seekingValue && isPreviousDash && character === '-' && buffer.length === 1);
		    isPreviousDash = character === '-';
		    roundBracketLevel = Math.max(roundBracketLevel, 0);

		    metadata = isBufferEmpty
		      ? [position.line, position.column, position.source]
		      : metadata;

		    if (isEscaped) {
		      // previous character was a backslash
		      buffer.push(character);
		      isBufferEmpty = false;
		    } else if (characterWithNoSpecialMeaning) {
		      // it's just an alphanumeric character or a hyphen (part of any rule or property name) so let's end it quickly
		      buffer.push(character);
		      isBufferEmpty = false;
		    } else if ((isSpace || isNewLineNix && !isNewLineWin) && (isQuoted || level == Level.COMMENT)) {
		      buffer.push(character);
		      isBufferEmpty = false;
		    } else if ((isSpace || isNewLineNix && !isNewLineWin) && isBufferEmpty) ; else if (!isCommentEnd && level == Level.COMMENT) {
		      buffer.push(character);
		      isBufferEmpty = false;
		    } else if (!isCommentStart && !isCommentEnd && isRaw) {
		      buffer.push(character);
		      isBufferEmpty = false;
		    } else if (isCommentStart
		        && isVariable
		        && (level == Level.BLOCK || level == Level.RULE) && buffer.length > 1) {
		      // comment start within a variable, e.g. var(/*<--
		      buffer.push(character);
		      isBufferEmpty = false;

		      levels.push(level);
		      level = Level.COMMENT;
		    } else if (isCommentStart && (level == Level.BLOCK || level == Level.RULE) && buffer.length > 1) {
		      // comment start within block preceded by some content, e.g. div/*<--
		      metadatas.push(metadata);
		      buffer.push(character);
		      buffers.push(buffer.slice(0, -2));
		      isBufferEmpty = false;

		      buffer = buffer.slice(-2);
		      metadata = [position.line, position.column - 1, position.source];

		      levels.push(level);
		      level = Level.COMMENT;
		    } else if (isCommentStart) {
		      // comment start, e.g. /*<--
		      levels.push(level);
		      level = Level.COMMENT;
		      buffer.push(character);
		      isBufferEmpty = false;
		    } else if (isCommentEnd && isVariable) {
		      // comment end within a variable, e.g. var(/*!*/<--
		      buffer.push(character);
		      level = levels.pop();
		    } else if (isCommentEnd && isIgnoreStartComment(buffer)) {
		      // ignore:start comment end, e.g. /* clean-css ignore:start */<--
		      serializedBuffer = buffer.join('').trim() + character;
		      lastToken = [
		        Token.COMMENT,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ];
		      newTokens.push(lastToken);

		      isRaw = true;
		      metadata = metadatas.pop() || null;
		      buffer = buffers.pop() || [];
		      isBufferEmpty = buffer.length === 0;
		    } else if (isCommentEnd && isIgnoreEndComment(buffer)) {
		      // ignore:start comment end, e.g. /* clean-css ignore:end */<--
		      serializedBuffer = buffer.join('') + character;
		      lastCommentStartAt = serializedBuffer.lastIndexOf(Marker.FORWARD_SLASH + Marker.ASTERISK);

		      serializedBufferPart = serializedBuffer.substring(0, lastCommentStartAt);
		      lastToken = [
		        Token.RAW,
		        serializedBufferPart,
		        [originalMetadata(metadata, serializedBufferPart, externalContext)]
		      ];
		      newTokens.push(lastToken);

		      serializedBufferPart = serializedBuffer.substring(lastCommentStartAt);
		      metadata = [position.line, position.column - serializedBufferPart.length + 1, position.source];
		      lastToken = [
		        Token.COMMENT,
		        serializedBufferPart,
		        [originalMetadata(metadata, serializedBufferPart, externalContext)]
		      ];
		      newTokens.push(lastToken);

		      isRaw = false;
		      level = levels.pop();
		      metadata = metadatas.pop() || null;
		      buffer = buffers.pop() || [];
		      isBufferEmpty = buffer.length === 0;
		    } else if (isCommentEnd) {
		      // comment end, e.g. /* comment */<--
		      serializedBuffer = buffer.join('').trim() + character;
		      lastToken = [
		        Token.COMMENT,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ];
		      newTokens.push(lastToken);

		      level = levels.pop();
		      metadata = metadatas.pop() || null;
		      buffer = buffers.pop() || [];
		      isBufferEmpty = buffer.length === 0;
		    } else if (isCommentEndMarker && source[position.index + 1] != Marker.ASTERISK) {
		      externalContext.warnings.push('Unexpected \'*/\' at ' + formatPosition([position.line, position.column, position.source]) + '.');
		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.SINGLE_QUOTE && !isQuoted) {
		      // single quotation start, e.g. a[href^='https<--
		      levels.push(level);
		      level = Level.SINGLE_QUOTE;
		      buffer.push(character);
		      isBufferEmpty = false;
		    } else if (character == Marker.SINGLE_QUOTE && level == Level.SINGLE_QUOTE) {
		      // single quotation end, e.g. a[href^='https'<--
		      level = levels.pop();
		      buffer.push(character);
		      isBufferEmpty = false;
		    } else if (character == Marker.DOUBLE_QUOTE && !isQuoted) {
		      // double quotation start, e.g. a[href^="<--
		      levels.push(level);
		      level = Level.DOUBLE_QUOTE;
		      buffer.push(character);
		      isBufferEmpty = false;
		    } else if (character == Marker.DOUBLE_QUOTE && level == Level.DOUBLE_QUOTE) {
		      // double quotation end, e.g. a[href^="https"<--
		      level = levels.pop();
		      buffer.push(character);
		      isBufferEmpty = false;
		    } else if (character != Marker.CLOSE_ROUND_BRACKET
		      && character != Marker.OPEN_ROUND_BRACKET
		      && level != Level.COMMENT && !isQuoted && roundBracketLevel > 0) {
		      // character inside any function, e.g. hsla(.<--
		      buffer.push(character);
		      isBufferEmpty = false;
		    } else if (character == Marker.OPEN_ROUND_BRACKET
		      && !isQuoted && level != Level.COMMENT
		      && !seekingValue) {
		      // round open bracket, e.g. @import url(<--
		      buffer.push(character);
		      isBufferEmpty = false;

		      roundBracketLevel++;
		    } else if (character == Marker.CLOSE_ROUND_BRACKET
		      && !isQuoted
		      && level != Level.COMMENT
		      && !seekingValue) {
		      // round open bracket, e.g. @import url(test.css)<--
		      buffer.push(character);
		      isBufferEmpty = false;

		      roundBracketLevel--;
		    } else if (character == Marker.SEMICOLON && level == Level.BLOCK && buffer[0] == Marker.AT) {
		      // semicolon ending rule at block level, e.g. @import '...';<--
		      serializedBuffer = buffer.join('').trim();
		      allTokens.push([
		        Token.AT_RULE,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ]);

		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.COMMA && level == Level.BLOCK && ruleToken) {
		      // comma separator at block level, e.g. a,div,<--
		      serializedBuffer = buffer.join('').trim();
		      ruleToken[1].push([
		        tokenScopeFrom(ruleToken[0]),
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext, ruleToken[1].length)]
		      ]);

		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.COMMA && level == Level.BLOCK && tokenTypeFrom(buffer) == Token.AT_RULE) {
		      // comma separator at block level, e.g. @import url(...) screen,<--
		      // keep iterating as end semicolon will create the token
		      buffer.push(character);
		      isBufferEmpty = false;
		    } else if (character == Marker.COMMA && level == Level.BLOCK) {
		      // comma separator at block level, e.g. a,<--
		      ruleToken = [tokenTypeFrom(buffer), [], []];
		      serializedBuffer = buffer.join('').trim();
		      ruleToken[1].push([
		        tokenScopeFrom(ruleToken[0]),
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext, 0)]
		      ]);

		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.OPEN_CURLY_BRACKET
		      && level == Level.BLOCK
		      && ruleToken
		      && ruleToken[0] == Token.NESTED_BLOCK) {
		      // open brace opening at-rule at block level, e.g. @media{<--
		      serializedBuffer = buffer.join('').trim();
		      ruleToken[1].push([
		        Token.NESTED_BLOCK_SCOPE,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ]);
		      allTokens.push(ruleToken);

		      levels.push(level);
		      position.column++;
		      position.index++;
		      buffer = [];
		      isBufferEmpty = true;

		      ruleToken[2] = intoTokens(source, externalContext, internalContext, true);
		      ruleToken = null;
		    } else if (character == Marker.OPEN_CURLY_BRACKET
		      && level == Level.BLOCK
		      && tokenTypeFrom(buffer) == Token.NESTED_BLOCK) {
		      // open brace opening at-rule at block level, e.g. @media{<--
		      serializedBuffer = buffer.join('').trim();
		      ruleToken = ruleToken || [Token.NESTED_BLOCK, [], []];
		      ruleToken[1].push([
		        Token.NESTED_BLOCK_SCOPE,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ]);
		      allTokens.push(ruleToken);

		      levels.push(level);
		      position.column++;
		      position.index++;
		      buffer = [];
		      isBufferEmpty = true;
		      isVariable = false;

		      ruleToken[2] = intoTokens(source, externalContext, internalContext, true);
		      ruleToken = null;
		    } else if (character == Marker.OPEN_CURLY_BRACKET && level == Level.BLOCK) {
		      // open brace opening rule at block level, e.g. div{<--
		      serializedBuffer = buffer.join('').trim();
		      ruleToken = ruleToken || [tokenTypeFrom(buffer), [], []];
		      ruleToken[1].push([
		        tokenScopeFrom(ruleToken[0]),
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext, ruleToken[1].length)]
		      ]);
		      newTokens = ruleToken[2];
		      allTokens.push(ruleToken);

		      levels.push(level);
		      level = Level.RULE;
		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.OPEN_CURLY_BRACKET && level == Level.RULE && seekingValue) {
		      // open brace opening rule at rule level, e.g. div{--variable:{<--
		      ruleTokens.push(ruleToken);
		      ruleToken = [Token.PROPERTY_BLOCK, []];
		      propertyToken.push(ruleToken);
		      newTokens = ruleToken[1];

		      levels.push(level);
		      level = Level.RULE;
		      seekingValue = false;
		    } else if (character == Marker.OPEN_CURLY_BRACKET && level == Level.RULE && isPageMarginBox(buffer)) {
		      // open brace opening page-margin box at rule level, e.g. @page{@top-center{<--
		      serializedBuffer = buffer.join('').trim();
		      ruleTokens.push(ruleToken);
		      ruleToken = [Token.AT_RULE_BLOCK, [], []];
		      ruleToken[1].push([
		        Token.AT_RULE_BLOCK_SCOPE,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ]);
		      newTokens.push(ruleToken);
		      newTokens = ruleToken[2];

		      levels.push(level);
		      level = Level.RULE;
		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.COLON && level == Level.RULE && !seekingValue) {
		      // colon at rule level, e.g. a{color:<--
		      serializedBuffer = buffer.join('').trim();
		      propertyToken = [
		        Token.PROPERTY,
		        [
		          Token.PROPERTY_NAME,
		          serializedBuffer,
		          [originalMetadata(metadata, serializedBuffer, externalContext)]
		        ]
		      ];
		      newTokens.push(propertyToken);

		      seekingValue = true;
		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.SEMICOLON
		      && level == Level.RULE
		      && propertyToken
		      && ruleTokens.length > 0
		      && !isBufferEmpty
		      && buffer[0] == Marker.AT) {
		      // semicolon at rule level for at-rule, e.g. a{--color:{@apply(--other-color);<--
		      serializedBuffer = buffer.join('').trim();
		      ruleToken[1].push([
		        Token.AT_RULE,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ]);

		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.SEMICOLON && level == Level.RULE && propertyToken && !isBufferEmpty) {
		      // semicolon at rule level, e.g. a{color:red;<--
		      serializedBuffer = buffer.join('').trim();
		      propertyToken.push([
		        Token.PROPERTY_VALUE,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ]);

		      propertyToken = null;
		      seekingValue = false;
		      buffer = [];
		      isBufferEmpty = true;
		      isVariable = false;
		    } else if (character == Marker.SEMICOLON
		      && level == Level.RULE
		      && propertyToken
		      && isBufferEmpty
		      && isVariable
		      && !propertyToken[2]) {
		      // semicolon after empty variable value at rule level, e.g. a{--color: ;<--
		      propertyToken.push([Token.PROPERTY_VALUE, ' ', [originalMetadata(metadata, ' ', externalContext)]]);
		      isVariable = false;
		      propertyToken = null;
		      seekingValue = false;
		    } else if (character == Marker.SEMICOLON && level == Level.RULE && propertyToken && isBufferEmpty) {
		      // semicolon after bracketed value at rule level, e.g. a{color:rgb(...);<--
		      propertyToken = null;
		      seekingValue = false;
		    } else if (character == Marker.SEMICOLON
		      && level == Level.RULE
		      && !isBufferEmpty
		      && buffer[0] == Marker.AT) {
		      // semicolon for at-rule at rule level, e.g. a{@apply(--variable);<--
		      serializedBuffer = buffer.join('');
		      newTokens.push([
		        Token.AT_RULE,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ]);

		      seekingValue = false;
		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.SEMICOLON && level == Level.RULE && seekingPropertyBlockClosing) {
		      // close brace after a property block at rule level, e.g. a{--custom:{color:red;};<--
		      seekingPropertyBlockClosing = false;
		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.SEMICOLON && level == Level.RULE && isBufferEmpty) ; else if (character == Marker.CLOSE_CURLY_BRACKET
		      && level == Level.RULE
		      && propertyToken
		      && seekingValue
		      && !isBufferEmpty && ruleTokens.length > 0) {
		      // close brace at rule level, e.g. a{--color:{color:red}<--
		      serializedBuffer = buffer.join('');
		      propertyToken.push([
		        Token.PROPERTY_VALUE,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ]);
		      propertyToken = null;
		      ruleToken = ruleTokens.pop();
		      newTokens = ruleToken[2];

		      level = levels.pop();
		      seekingValue = false;
		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.CLOSE_CURLY_BRACKET
		      && level == Level.RULE
		      && propertyToken
		      && !isBufferEmpty
		      && buffer[0] == Marker.AT
		      && ruleTokens.length > 0) {
		      // close brace at rule level for at-rule, e.g. a{--color:{@apply(--other-color)}<--
		      serializedBuffer = buffer.join('');
		      ruleToken[1].push([
		        Token.AT_RULE,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ]);
		      propertyToken = null;
		      ruleToken = ruleTokens.pop();
		      newTokens = ruleToken[2];

		      level = levels.pop();
		      seekingValue = false;
		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.CLOSE_CURLY_BRACKET
		      && level == Level.RULE
		      && propertyToken
		      && ruleTokens.length > 0) {
		      // close brace at rule level after space, e.g. a{--color:{color:red }<--
		      propertyToken = null;
		      ruleToken = ruleTokens.pop();
		      newTokens = ruleToken[2];

		      level = levels.pop();
		      seekingValue = false;
		    } else if (character == Marker.CLOSE_CURLY_BRACKET
		      && level == Level.RULE
		      && propertyToken
		      && !isBufferEmpty) {
		      // close brace at rule level, e.g. a{color:red}<--
		      serializedBuffer = buffer.join('');
		      propertyToken.push([
		        Token.PROPERTY_VALUE,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ]);
		      propertyToken = null;
		      ruleToken = ruleTokens.pop();
		      newTokens = allTokens;

		      level = levels.pop();
		      seekingValue = false;
		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.CLOSE_CURLY_BRACKET
		      && level == Level.RULE
		      && !isBufferEmpty
		      && buffer[0] == Marker.AT) {
		      // close brace after at-rule at rule level, e.g. a{@apply(--variable)}<--
		      propertyToken = null;
		      ruleToken = null;
		      serializedBuffer = buffer.join('').trim();
		      newTokens.push([
		        Token.AT_RULE,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ]);
		      newTokens = allTokens;

		      level = levels.pop();
		      seekingValue = false;
		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.CLOSE_CURLY_BRACKET
		      && level == Level.RULE
		      && levels[levels.length - 1] == Level.RULE) {
		      // close brace after a property block at rule level, e.g. a{--custom:{color:red;}<--
		      propertyToken = null;
		      ruleToken = ruleTokens.pop();
		      newTokens = ruleToken[2];

		      level = levels.pop();
		      seekingValue = false;
		      seekingPropertyBlockClosing = true;
		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.CLOSE_CURLY_BRACKET
		      && level == Level.RULE
		      && isVariable
		      && propertyToken
		      && !propertyToken[2]) {
		      // close brace after an empty variable declaration inside a rule, e.g. a{--color: }<--
		      propertyToken.push([Token.PROPERTY_VALUE, ' ', [originalMetadata(metadata, ' ', externalContext)]]);
		      isVariable = false;
		      propertyToken = null;
		      ruleToken = null;
		      newTokens = allTokens;

		      level = levels.pop();
		      seekingValue = false;
		      isVariable = false;
		    } else if (character == Marker.CLOSE_CURLY_BRACKET && level == Level.RULE) {
		      // close brace after a rule, e.g. a{color:red;}<--
		      propertyToken = null;
		      ruleToken = null;
		      newTokens = allTokens;

		      level = levels.pop();
		      seekingValue = false;
		      isVariable = false;
		    } else if (character == Marker.CLOSE_CURLY_BRACKET
		      && level == Level.BLOCK
		      && !isNested
		      && position.index <= source.length - 1) {
		      // stray close brace at block level, e.g. a{color:red}color:blue}<--
		      externalContext.warnings.push('Unexpected \'}\' at ' + formatPosition([position.line, position.column, position.source]) + '.');
		      buffer.push(character);
		      isBufferEmpty = false;
		    } else if (character == Marker.CLOSE_CURLY_BRACKET && level == Level.BLOCK) {
		      // close brace at block level, e.g. @media screen {...}<--
		      break;
		    } else if (character == Marker.OPEN_ROUND_BRACKET && level == Level.RULE && seekingValue) {
		      // round open bracket, e.g. a{color:hsla(<--
		      buffer.push(character);
		      isBufferEmpty = false;
		      roundBracketLevel++;
		    } else if (character == Marker.CLOSE_ROUND_BRACKET
		      && level == Level.RULE
		      && seekingValue
		      && roundBracketLevel == 1) {
		      // round close bracket, e.g. a{color:hsla(0,0%,0%)<--
		      buffer.push(character);
		      isBufferEmpty = false;
		      serializedBuffer = buffer.join('').trim();
		      propertyToken.push([
		        Token.PROPERTY_VALUE,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ]);

		      roundBracketLevel--;
		      buffer = [];
		      isBufferEmpty = true;
		      isVariable = false;
		    } else if (character == Marker.CLOSE_ROUND_BRACKET && level == Level.RULE && seekingValue) {
		      // round close bracket within other brackets, e.g. a{width:calc((10rem / 2)<--
		      buffer.push(character);
		      isBufferEmpty = false;
		      isVariable = false;
		      roundBracketLevel--;
		    } else if (character == Marker.FORWARD_SLASH
		      && source[position.index + 1] != Marker.ASTERISK
		      && level == Level.RULE
		      && seekingValue
		      && !isBufferEmpty) {
		      // forward slash within a property, e.g. a{background:url(image.png) 0 0/<--
		      serializedBuffer = buffer.join('').trim();
		      propertyToken.push([
		        Token.PROPERTY_VALUE,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ]);
		      propertyToken.push([
		        Token.PROPERTY_VALUE,
		        character,
		        [[position.line, position.column, position.source]]
		      ]);

		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.FORWARD_SLASH
		      && source[position.index + 1] != Marker.ASTERISK
		      && level == Level.RULE
		      && seekingValue) {
		      // forward slash within a property after space, e.g. a{background:url(image.png) 0 0 /<--
		      propertyToken.push([
		        Token.PROPERTY_VALUE,
		        character,
		        [[position.line, position.column, position.source]]
		      ]);

		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.COMMA && level == Level.RULE && seekingValue && !isBufferEmpty) {
		      // comma within a property, e.g. a{background:url(image.png),<--
		      serializedBuffer = buffer.join('').trim();
		      propertyToken.push([
		        Token.PROPERTY_VALUE,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ]);
		      propertyToken.push([
		        Token.PROPERTY_VALUE,
		        character,
		        [[position.line, position.column, position.source]]
		      ]);

		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.COMMA && level == Level.RULE && seekingValue) {
		      // comma within a property after space, e.g. a{background:url(image.png) ,<--
		      propertyToken.push([
		        Token.PROPERTY_VALUE,
		        character,
		        [[position.line, position.column, position.source]]
		      ]);

		      buffer = [];
		      isBufferEmpty = true;
		    } else if (character == Marker.CLOSE_SQUARE_BRACKET
		      && propertyToken
		      && propertyToken.length > 1
		      && !isBufferEmpty
		      && isRepeatToken(buffer)) {
		      buffer.push(character);
		      serializedBuffer = buffer.join('').trim();
		      propertyToken[propertyToken.length - 1][1] += serializedBuffer;

		      buffer = [];
		      isBufferEmpty = true;
		    } else if ((isSpace || (isNewLineNix && !isNewLineWin))
		      && level == Level.RULE
		      && seekingValue
		      && propertyToken
		      && !isBufferEmpty) {
		      // space or *nix newline within property, e.g. a{margin:0 <--
		      serializedBuffer = buffer.join('').trim();
		      propertyToken.push([
		        Token.PROPERTY_VALUE,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ]);

		      buffer = [];
		      isBufferEmpty = true;
		    } else if (isNewLineWin && level == Level.RULE && seekingValue && propertyToken && buffer.length > 1) {
		      // win newline within property, e.g. a{margin:0\r\n<--
		      serializedBuffer = buffer.join('').trim();
		      propertyToken.push([
		        Token.PROPERTY_VALUE,
		        serializedBuffer,
		        [originalMetadata(metadata, serializedBuffer, externalContext)]
		      ]);

		      buffer = [];
		      isBufferEmpty = true;
		    } else if (isNewLineWin && level == Level.RULE && seekingValue) {
		      // win newline
		      buffer = [];
		      isBufferEmpty = true;
		    } else if (isNewLineWin && buffer.length == 1) {
		      // ignore windows newline which is composed of two characters
		      buffer.pop();
		      isBufferEmpty = buffer.length === 0;
		    } else if (!isBufferEmpty || !isSpace && !isNewLineNix && !isNewLineWin && !isCarriageReturn) {
		      // any character
		      buffer.push(character);
		      isBufferEmpty = false;
		    }

		    wasEscaped = isEscaped;
		    isEscaped = !wasEscaped && character == Marker.BACK_SLASH;
		    wasCommentStart = isCommentStart;
		    wasCommentEnd = isCommentEnd;

		    position.line = (isNewLineWin || isNewLineNix || isCarriageReturn) ? position.line + 1 : position.line;
		    position.column = (isNewLineWin || isNewLineNix || isCarriageReturn) ? 0 : position.column + 1;
		  }

		  if (seekingValue) {
		    externalContext.warnings.push('Missing \'}\' at ' + formatPosition([position.line, position.column, position.source]) + '.');
		  }

		  if (seekingValue && buffer.length > 0) {
		    serializedBuffer = buffer.join('').trimRight().replace(TAIL_BROKEN_VALUE_PATTERN, '$1').trimRight();
		    propertyToken.push([
		      Token.PROPERTY_VALUE,
		      serializedBuffer,
		      [originalMetadata(metadata, serializedBuffer, externalContext)]
		    ]);

		    buffer = [];
		  }

		  if (buffer.length > 0) {
		    externalContext.warnings.push('Invalid character(s) \'' + buffer.join('') + '\' at ' + formatPosition(metadata) + '. Ignoring.');
		  }

		  return allTokens;
		}

		function isIgnoreStartComment(buffer) {
		  return IGNORE_START_COMMENT_PATTERN.test(buffer.join('') + Marker.FORWARD_SLASH);
		}

		function isIgnoreEndComment(buffer) {
		  return IGNORE_END_COMMENT_PATTERN.test(buffer.join('') + Marker.FORWARD_SLASH);
		}

		function originalMetadata(metadata, value, externalContext, selectorFallbacks) {
		  var source = metadata[2];

		  return externalContext.inputSourceMapTracker.isTracking(source)
		    ? externalContext.inputSourceMapTracker.originalPositionFor(metadata, value.length, selectorFallbacks)
		    : metadata;
		}

		function tokenTypeFrom(buffer) {
		  var isAtRule = buffer[0] == Marker.AT || buffer[0] == Marker.UNDERSCORE;
		  var ruleWord = buffer.join('').split(RULE_WORD_SEPARATOR_PATTERN)[0];

		  if (isAtRule && BLOCK_RULES.indexOf(ruleWord) > -1) {
		    return Token.NESTED_BLOCK;
		  } if (isAtRule && AT_RULES.indexOf(ruleWord) > -1) {
		    return Token.AT_RULE;
		  } if (isAtRule) {
		    return Token.AT_RULE_BLOCK;
		  }
		  return Token.RULE;
		}

		function tokenScopeFrom(tokenType) {
		  if (tokenType == Token.RULE) {
		    return Token.RULE_SCOPE;
		  } if (tokenType == Token.NESTED_BLOCK) {
		    return Token.NESTED_BLOCK_SCOPE;
		  } if (tokenType == Token.AT_RULE_BLOCK) {
		    return Token.AT_RULE_BLOCK_SCOPE;
		  }
		}

		function isPageMarginBox(buffer) {
		  var serializedBuffer = buffer.join('').trim();

		  return PAGE_MARGIN_BOXES.indexOf(serializedBuffer) > -1 || EXTRA_PAGE_BOXES.indexOf(serializedBuffer) > -1;
		}

		function isRepeatToken(buffer) {
		  return REPEAT_PATTERN.test(buffer.join('') + Marker.CLOSE_SQUARE_BRACKET);
		}

		tokenize_1 = tokenize;
		return tokenize_1;
	}

	var readSources_1;
	var hasRequiredReadSources;

	function requireReadSources () {
		if (hasRequiredReadSources) return readSources_1;
		hasRequiredReadSources = 1;
		var fs = require$$0;
		var path = require$$1;

		var applySourceMaps = requireApplySourceMaps();
		var extractImportUrlAndMedia = requireExtractImportUrlAndMedia();
		var isAllowedResource = requireIsAllowedResource();
		var loadOriginalSources = requireLoadOriginalSources();
		var normalizePath = requireNormalizePath();
		var rebase = requireRebase();
		var rebaseLocalMap = requireRebaseLocalMap();
		var rebaseRemoteMap = requireRebaseRemoteMap();
		var restoreImport = requireRestoreImport();

		var tokenize = requireTokenize();
		var Token = requireToken();
		var Marker = requireMarker();
		var hasProtocol = requireHasProtocol();
		var isImport = requireIsImport();
		var isRemoteResource = requireIsRemoteResource();

		var UNKNOWN_URI = 'uri:unknown';
		var FILE_RESOURCE_PROTOCOL = 'file://';

		function readSources(input, context, callback) {
		  return doReadSources(input, context, function(tokens) {
		    return applySourceMaps(tokens, context, function() {
		      return loadOriginalSources(context, function() { return callback(tokens); });
		    });
		  });
		}

		function doReadSources(input, context, callback) {
		  if (typeof input == 'string') {
		    return fromString(input, context, callback);
		  } if (Buffer$1.isBuffer(input)) {
		    return fromString(input.toString(), context, callback);
		  } if (Array.isArray(input)) {
		    return fromArray(input, context, callback);
		  } if (typeof input == 'object') {
		    return fromHash(input, context, callback);
		  }
		}

		function fromString(input, context, callback) {
		  context.source = undefined;
		  context.sourcesContent[undefined] = input;
		  context.stats.originalSize += input.length;

		  return fromStyles(input, context, { inline: context.options.inline }, callback);
		}

		function fromArray(input, context, callback) {
		  var inputAsImports = input.reduce(function(accumulator, uriOrHash) {
		    if (typeof uriOrHash === 'string') {
		      return addStringSource(uriOrHash, accumulator);
		    }
		    return addHashSource(uriOrHash, context, accumulator);
		  }, []);

		  return fromStyles(inputAsImports.join(''), context, { inline: ['all'] }, callback);
		}

		function fromHash(input, context, callback) {
		  var inputAsImports = addHashSource(input, context, []);
		  return fromStyles(inputAsImports.join(''), context, { inline: ['all'] }, callback);
		}

		function addStringSource(input, imports) {
		  imports.push(restoreAsImport(normalizeUri(input)));
		  return imports;
		}

		function addHashSource(input, context, imports) {
		  var uri;
		  var normalizedUri;
		  var source;

		  for (uri in input) {
		    source = input[uri];
		    normalizedUri = normalizeUri(uri);

		    imports.push(restoreAsImport(normalizedUri));

		    context.sourcesContent[normalizedUri] = source.styles;

		    if (source.sourceMap) {
		      trackSourceMap(source.sourceMap, normalizedUri, context);
		    }
		  }

		  return imports;
		}

		function normalizeUri(uri) {
		  var currentPath = path.resolve('');
		  var absoluteUri;
		  var relativeToCurrentPath;
		  var normalizedUri;

		  if (isRemoteResource(uri)) {
		    return uri;
		  }

		  absoluteUri = path.isAbsolute(uri)
		    ? uri
		    : path.resolve(uri);
		  relativeToCurrentPath = path.relative(currentPath, absoluteUri);
		  normalizedUri = normalizePath(relativeToCurrentPath);

		  return normalizedUri;
		}

		function trackSourceMap(sourceMap, uri, context) {
		  var parsedMap = typeof sourceMap == 'string'
		    ? JSON.parse(sourceMap)
		    : sourceMap;
		  var rebasedMap = isRemoteResource(uri)
		    ? rebaseRemoteMap(parsedMap, uri)
		    : rebaseLocalMap(parsedMap, uri || UNKNOWN_URI, context.options.rebaseTo);

		  context.inputSourceMapTracker.track(uri, rebasedMap);
		}

		function restoreAsImport(uri) {
		  return restoreImport('url(' + uri + ')', '') + Marker.SEMICOLON;
		}

		function fromStyles(styles, context, parentInlinerContext, callback) {
		  var tokens;
		  var rebaseConfig = {};

		  if (!context.source) {
		    rebaseConfig.fromBase = path.resolve('');
		    rebaseConfig.toBase = context.options.rebaseTo;
		  } else if (isRemoteResource(context.source)) {
		    rebaseConfig.fromBase = context.source;
		    rebaseConfig.toBase = context.source;
		  } else if (path.isAbsolute(context.source)) {
		    rebaseConfig.fromBase = path.dirname(context.source);
		    rebaseConfig.toBase = context.options.rebaseTo;
		  } else {
		    rebaseConfig.fromBase = path.dirname(path.resolve(context.source));
		    rebaseConfig.toBase = context.options.rebaseTo;
		  }

		  tokens = tokenize(styles, context);
		  tokens = rebase(tokens, context.options.rebase, context.validator, rebaseConfig);

		  return allowsAnyImports(parentInlinerContext.inline)
		    ? inline(tokens, context, parentInlinerContext, callback)
		    : callback(tokens);
		}

		function allowsAnyImports(inline) {
		  return !(inline.length == 1 && inline[0] == 'none');
		}

		function inline(tokens, externalContext, parentInlinerContext, callback) {
		  var inlinerContext = {
		    afterContent: false,
		    callback: callback,
		    errors: externalContext.errors,
		    externalContext: externalContext,
		    fetch: externalContext.options.fetch,
		    inlinedStylesheets: parentInlinerContext.inlinedStylesheets || externalContext.inlinedStylesheets,
		    inline: parentInlinerContext.inline,
		    inlineRequest: externalContext.options.inlineRequest,
		    inlineTimeout: externalContext.options.inlineTimeout,
		    isRemote: parentInlinerContext.isRemote || false,
		    localOnly: externalContext.localOnly,
		    outputTokens: [],
		    rebaseTo: externalContext.options.rebaseTo,
		    sourceTokens: tokens,
		    warnings: externalContext.warnings
		  };

		  return doInlineImports(inlinerContext);
		}

		function doInlineImports(inlinerContext) {
		  var token;
		  var i, l;

		  for (i = 0, l = inlinerContext.sourceTokens.length; i < l; i++) {
		    token = inlinerContext.sourceTokens[i];

		    if (token[0] == Token.AT_RULE && isImport(token[1])) {
		      inlinerContext.sourceTokens.splice(0, i);
		      return inlineStylesheet(token, inlinerContext);
		    } if (token[0] == Token.AT_RULE || token[0] == Token.COMMENT) {
		      inlinerContext.outputTokens.push(token);
		    } else {
		      inlinerContext.outputTokens.push(token);
		      inlinerContext.afterContent = true;
		    }
		  }

		  inlinerContext.sourceTokens = [];
		  return inlinerContext.callback(inlinerContext.outputTokens);
		}

		function inlineStylesheet(token, inlinerContext) {
		  var uriAndMediaQuery = extractImportUrlAndMedia(token[1]);
		  var uri = uriAndMediaQuery[0];
		  var mediaQuery = uriAndMediaQuery[1];
		  var metadata = token[2];

		  return isRemoteResource(uri)
		    ? inlineRemoteStylesheet(uri, mediaQuery, metadata, inlinerContext)
		    : inlineLocalStylesheet(uri, mediaQuery, metadata, inlinerContext);
		}

		function inlineRemoteStylesheet(uri, mediaQuery, metadata, inlinerContext) {
		  var isAllowed = isAllowedResource(uri, true, inlinerContext.inline);
		  var originalUri = uri;
		  var isLoaded = uri in inlinerContext.externalContext.sourcesContent;
		  var isRuntimeResource = !hasProtocol(uri);

		  if (inlinerContext.inlinedStylesheets.indexOf(uri) > -1) {
		    inlinerContext.warnings.push('Ignoring remote @import of "' + uri + '" as it has already been imported.');
		    inlinerContext.sourceTokens = inlinerContext.sourceTokens.slice(1);
		    return doInlineImports(inlinerContext);
		  } if (inlinerContext.localOnly && inlinerContext.afterContent) {
		    inlinerContext.warnings.push('Ignoring remote @import of "' + uri + '" as no callback given and after other content.');
		    inlinerContext.sourceTokens = inlinerContext.sourceTokens.slice(1);
		    return doInlineImports(inlinerContext);
		  } if (isRuntimeResource) {
		    inlinerContext.warnings.push('Skipping remote @import of "' + uri + '" as no protocol given.');
		    inlinerContext.outputTokens = inlinerContext.outputTokens.concat(inlinerContext.sourceTokens.slice(0, 1));
		    inlinerContext.sourceTokens = inlinerContext.sourceTokens.slice(1);
		    return doInlineImports(inlinerContext);
		  } if (inlinerContext.localOnly && !isLoaded) {
		    inlinerContext.warnings.push('Skipping remote @import of "' + uri + '" as no callback given.');
		    inlinerContext.outputTokens = inlinerContext.outputTokens.concat(inlinerContext.sourceTokens.slice(0, 1));
		    inlinerContext.sourceTokens = inlinerContext.sourceTokens.slice(1);
		    return doInlineImports(inlinerContext);
		  } if (!isAllowed && inlinerContext.afterContent) {
		    inlinerContext.warnings.push('Ignoring remote @import of "' + uri + '" as resource is not allowed and after other content.');
		    inlinerContext.sourceTokens = inlinerContext.sourceTokens.slice(1);
		    return doInlineImports(inlinerContext);
		  } if (!isAllowed) {
		    inlinerContext.warnings.push('Skipping remote @import of "' + uri + '" as resource is not allowed.');
		    inlinerContext.outputTokens = inlinerContext.outputTokens.concat(inlinerContext.sourceTokens.slice(0, 1));
		    inlinerContext.sourceTokens = inlinerContext.sourceTokens.slice(1);
		    return doInlineImports(inlinerContext);
		  }

		  inlinerContext.inlinedStylesheets.push(uri);

		  function whenLoaded(error, importedStyles) {
		    if (error) {
		      inlinerContext.errors.push('Broken @import declaration of "' + uri + '" - ' + error);

		      return browser$1.nextTick(function() {
		        inlinerContext.outputTokens = inlinerContext.outputTokens.concat(inlinerContext.sourceTokens.slice(0, 1));
		        inlinerContext.sourceTokens = inlinerContext.sourceTokens.slice(1);
		        doInlineImports(inlinerContext);
		      });
		    }

		    inlinerContext.inline = inlinerContext.externalContext.options.inline;
		    inlinerContext.isRemote = true;

		    inlinerContext.externalContext.source = originalUri;
		    inlinerContext.externalContext.sourcesContent[uri] = importedStyles;
		    inlinerContext.externalContext.stats.originalSize += importedStyles.length;

		    return fromStyles(importedStyles, inlinerContext.externalContext, inlinerContext, function(importedTokens) {
		      importedTokens = wrapInMedia(importedTokens, mediaQuery, metadata);

		      inlinerContext.outputTokens = inlinerContext.outputTokens.concat(importedTokens);
		      inlinerContext.sourceTokens = inlinerContext.sourceTokens.slice(1);

		      return doInlineImports(inlinerContext);
		    });
		  }

		  return isLoaded
		    ? whenLoaded(null, inlinerContext.externalContext.sourcesContent[uri])
		    : inlinerContext.fetch(uri, inlinerContext.inlineRequest, inlinerContext.inlineTimeout, whenLoaded);
		}

		function inlineLocalStylesheet(uri, mediaQuery, metadata, inlinerContext) {
		  var protocolLessUri = uri.replace(FILE_RESOURCE_PROTOCOL, '');
		  var currentPath = path.resolve('');
		  var absoluteUri = path.isAbsolute(protocolLessUri)
		    ? path.resolve(currentPath, protocolLessUri[0] == '/' ? protocolLessUri.substring(1) : protocolLessUri)
		    : path.resolve(inlinerContext.rebaseTo, protocolLessUri);
		  var relativeToCurrentPath = path.relative(currentPath, absoluteUri);
		  var importedStyles;
		  var isAllowed = isAllowedResource(protocolLessUri, false, inlinerContext.inline);
		  var normalizedPath = normalizePath(relativeToCurrentPath);
		  var isLoaded = normalizedPath in inlinerContext.externalContext.sourcesContent;

		  if (inlinerContext.inlinedStylesheets.indexOf(absoluteUri) > -1) {
		    inlinerContext.warnings.push('Ignoring local @import of "' + protocolLessUri + '" as it has already been imported.');
		  } else if (isAllowed && !isLoaded && (!fs.existsSync(absoluteUri) || !fs.statSync(absoluteUri).isFile())) {
		    inlinerContext.errors.push('Ignoring local @import of "' + protocolLessUri + '" as resource is missing.');
		  } else if (!isAllowed && inlinerContext.afterContent) {
		    inlinerContext.warnings.push('Ignoring local @import of "' + protocolLessUri + '" as resource is not allowed and after other content.');
		  } else if (inlinerContext.afterContent) {
		    inlinerContext.warnings.push('Ignoring local @import of "' + protocolLessUri + '" as after other content.');
		  } else if (!isAllowed) {
		    inlinerContext.warnings.push('Skipping local @import of "' + protocolLessUri + '" as resource is not allowed.');
		    inlinerContext.outputTokens = inlinerContext.outputTokens.concat(inlinerContext.sourceTokens.slice(0, 1));
		  } else {
		    importedStyles = isLoaded
		      ? inlinerContext.externalContext.sourcesContent[normalizedPath]
		      : fs.readFileSync(absoluteUri, 'utf-8');

		    if (importedStyles.charCodeAt(0) === 65279) {
		      importedStyles = importedStyles.substring(1);
		    }

		    inlinerContext.inlinedStylesheets.push(absoluteUri);
		    inlinerContext.inline = inlinerContext.externalContext.options.inline;

		    inlinerContext.externalContext.source = normalizedPath;
		    inlinerContext.externalContext.sourcesContent[normalizedPath] = importedStyles;
		    inlinerContext.externalContext.stats.originalSize += importedStyles.length;

		    return fromStyles(importedStyles, inlinerContext.externalContext, inlinerContext, function(importedTokens) {
		      importedTokens = wrapInMedia(importedTokens, mediaQuery, metadata);

		      inlinerContext.outputTokens = inlinerContext.outputTokens.concat(importedTokens);
		      inlinerContext.sourceTokens = inlinerContext.sourceTokens.slice(1);

		      return doInlineImports(inlinerContext);
		    });
		  }

		  inlinerContext.sourceTokens = inlinerContext.sourceTokens.slice(1);

		  return doInlineImports(inlinerContext);
		}

		function wrapInMedia(tokens, mediaQuery, metadata) {
		  if (mediaQuery) {
		    return [[Token.NESTED_BLOCK, [[Token.NESTED_BLOCK_SCOPE, '@media ' + mediaQuery, metadata]], tokens]];
		  }
		  return tokens;
		}

		readSources_1 = readSources;
		return readSources_1;
	}

	var simple;
	var hasRequiredSimple;

	function requireSimple () {
		if (hasRequiredSimple) return simple;
		hasRequiredSimple = 1;
		var all = requireHelpers().all;

		function store(serializeContext, token) {
		  var value = typeof token == 'string'
		    ? token
		    : token[1];
		  var wrap = serializeContext.wrap;

		  wrap(serializeContext, value);
		  track(serializeContext, value);
		  serializeContext.output.push(value);
		}

		function wrap(serializeContext, value) {
		  if (serializeContext.column + value.length > serializeContext.format.wrapAt) {
		    track(serializeContext, serializeContext.format.breakWith);
		    serializeContext.output.push(serializeContext.format.breakWith);
		  }
		}

		function track(serializeContext, value) {
		  var parts = value.split('\n');

		  serializeContext.line += parts.length - 1;
		  serializeContext.column = parts.length > 1 ? 0 : (serializeContext.column + parts.pop().length);
		}

		function serializeStyles(tokens, context) {
		  var serializeContext = {
		    column: 0,
		    format: context.options.format,
		    indentBy: 0,
		    indentWith: '',
		    line: 1,
		    output: [],
		    spaceAfterClosingBrace: context.options.compatibility.properties.spaceAfterClosingBrace,
		    store: store,
		    wrap: context.options.format.wrapAt
		      ? wrap
		      : function() { /* noop */ }
		  };

		  all(serializeContext, tokens);

		  return { styles: serializeContext.output.join('') };
		}

		simple = serializeStyles;
		return simple;
	}

	var sourceMaps;
	var hasRequiredSourceMaps;

	function requireSourceMaps () {
		if (hasRequiredSourceMaps) return sourceMaps;
		hasRequiredSourceMaps = 1;
		var SourceMapGenerator = requireSourceMap().SourceMapGenerator;
		var all = requireHelpers().all;

		requireIsRemoteResource();
		var UNKNOWN_SOURCE = '$stdin';

		function store(serializeContext, element) {
		  var fromString = typeof element == 'string';
		  var value = fromString ? element : element[1];
		  var mappings = fromString ? null : element[2];
		  var wrap = serializeContext.wrap;

		  wrap(serializeContext, value);
		  track(serializeContext, value, mappings);
		  serializeContext.output.push(value);
		}

		function wrap(serializeContext, value) {
		  if (serializeContext.column + value.length > serializeContext.format.wrapAt) {
		    track(serializeContext, serializeContext.format.breakWith, false);
		    serializeContext.output.push(serializeContext.format.breakWith);
		  }
		}

		function track(serializeContext, value, mappings) {
		  var parts = value.split('\n');

		  if (mappings) {
		    trackAllMappings(serializeContext, mappings);
		  }

		  serializeContext.line += parts.length - 1;
		  serializeContext.column = parts.length > 1 ? 0 : (serializeContext.column + parts.pop().length);
		}

		function trackAllMappings(serializeContext, mappings) {
		  for (var i = 0, l = mappings.length; i < l; i++) {
		    trackMapping(serializeContext, mappings[i]);
		  }
		}

		function trackMapping(serializeContext, mapping) {
		  var line = mapping[0];
		  var column = mapping[1];
		  var originalSource = mapping[2];
		  var source = originalSource;
		  var storedSource = source || UNKNOWN_SOURCE;

		  serializeContext.outputMap.addMapping({
		    generated: {
		      line: serializeContext.line,
		      column: serializeContext.column
		    },
		    source: storedSource,
		    original: {
		      line: line,
		      column: column
		    }
		  });

		  if (serializeContext.inlineSources && (originalSource in serializeContext.sourcesContent)) {
		    serializeContext.outputMap.setSourceContent(
		      storedSource,
		      serializeContext.sourcesContent[originalSource]
		    );
		  }
		}

		function serializeStylesAndSourceMap(tokens, context) {
		  var serializeContext = {
		    column: 0,
		    format: context.options.format,
		    indentBy: 0,
		    indentWith: '',
		    inlineSources: context.options.sourceMapInlineSources,
		    line: 1,
		    output: [],
		    outputMap: new SourceMapGenerator(),
		    sourcesContent: context.sourcesContent,
		    spaceAfterClosingBrace: context.options.compatibility.properties.spaceAfterClosingBrace,
		    store: store,
		    wrap: context.options.format.wrapAt
		      ? wrap
		      : function() { /* noop */ }
		  };

		  all(serializeContext, tokens);

		  return {
		    sourceMap: serializeContext.outputMap,
		    styles: serializeContext.output.join('')
		  };
		}

		sourceMaps = serializeStylesAndSourceMap;
		return sourceMaps;
	}

	var hasRequiredClean;

	function requireClean () {
		if (hasRequiredClean) return clean.exports;
		hasRequiredClean = 1;
		var level0Optimize = requireOptimize$3();
		var level1Optimize = requireOptimize$2();
		var level2Optimize = requireOptimize();
		var validator = requireValidator();

		var compatibilityFrom = requireCompatibility();
		var fetchFrom = requireFetch();
		var formatFrom = requireFormat$1().formatFrom;
		var inlineFrom = requireInline();
		var inlineRequestFrom = requireInlineRequest();
		var inlineTimeoutFrom = requireInlineTimeout();
		var OptimizationLevel = requireOptimizationLevel().OptimizationLevel;
		var optimizationLevelFrom = requireOptimizationLevel().optimizationLevelFrom;
		var pluginsFrom = requirePlugins();
		var rebaseFrom = requireRebase$1();
		var rebaseToFrom = requireRebaseTo();

		var inputSourceMapTracker = requireInputSourceMapTracker();
		var readSources = requireReadSources();

		var serializeStyles = requireSimple();
		var serializeStylesAndSourceMap = requireSourceMaps();

		var CleanCSS = clean.exports = function CleanCSS(options) {
		  options = options || {};

		  this.options = {
		    batch: !!options.batch,
		    compatibility: compatibilityFrom(options.compatibility),
		    explicitRebaseTo: 'rebaseTo' in options,
		    fetch: fetchFrom(options.fetch),
		    format: formatFrom(options.format),
		    inline: inlineFrom(options.inline),
		    inlineRequest: inlineRequestFrom(options.inlineRequest),
		    inlineTimeout: inlineTimeoutFrom(options.inlineTimeout),
		    level: optimizationLevelFrom(options.level),
		    plugins: pluginsFrom(options.plugins),
		    rebase: rebaseFrom(options.rebase, options.rebaseTo),
		    rebaseTo: rebaseToFrom(options.rebaseTo),
		    returnPromise: !!options.returnPromise,
		    sourceMap: !!options.sourceMap,
		    sourceMapInlineSources: !!options.sourceMapInlineSources
		  };
		};

		// for compatibility with optimize-css-assets-webpack-plugin
		CleanCSS.process = function(input, opts) {
		  var cleanCss;
		  var optsTo = opts.to;

		  delete opts.to;
		  cleanCss = new CleanCSS(Object.assign({
		    returnPromise: true, rebaseTo: optsTo
		  }, opts));

		  return cleanCss.minify(input)
		    .then(function(output) {
		      return { css: output.styles };
		    });
		};

		CleanCSS.prototype.minify = function(input, maybeSourceMap, maybeCallback) {
		  var options = this.options;

		  if (options.returnPromise) {
		    return new Promise(function(resolve, reject) {
		      minifyAll(input, options, maybeSourceMap, function(errors, output) {
		        return errors
		          ? reject(errors)
		          : resolve(output);
		      });
		    });
		  }
		  return minifyAll(input, options, maybeSourceMap, maybeCallback);
		};

		function minifyAll(input, options, maybeSourceMap, maybeCallback) {
		  if (options.batch && Array.isArray(input)) {
		    return minifyInBatchesFromArray(input, options, maybeSourceMap, maybeCallback);
		  } if (options.batch && (typeof input == 'object')) {
		    return minifyInBatchesFromHash(input, options, maybeSourceMap, maybeCallback);
		  }
		  return minify(input, options, maybeSourceMap, maybeCallback);
		}

		function minifyInBatchesFromArray(input, options, maybeSourceMap, maybeCallback) {
		  var callback = typeof maybeCallback == 'function'
		    ? maybeCallback
		    : (typeof maybeSourceMap == 'function' ? maybeSourceMap : null);
		  var errors = [];
		  var outputAsHash = {};
		  var inputValue;
		  var i, l;

		  function whenHashBatchDone(innerErrors, output) {
		    outputAsHash = Object.assign(outputAsHash, output);

		    if (innerErrors !== null) {
		      errors = errors.concat(innerErrors);
		    }
		  }

		  for (i = 0, l = input.length; i < l; i++) {
		    if (typeof input[i] == 'object') {
		      minifyInBatchesFromHash(input[i], options, whenHashBatchDone);
		    } else {
		      inputValue = input[i];

		      outputAsHash[inputValue] = minify([inputValue], options);
		      errors = errors.concat(outputAsHash[inputValue].errors);
		    }
		  }

		  return callback
		    ? callback(errors.length > 0 ? errors : null, outputAsHash)
		    : outputAsHash;
		}

		function minifyInBatchesFromHash(input, options, maybeSourceMap, maybeCallback) {
		  var callback = typeof maybeCallback == 'function'
		    ? maybeCallback
		    : (typeof maybeSourceMap == 'function' ? maybeSourceMap : null);
		  var errors = [];
		  var outputAsHash = {};
		  var inputKey;
		  var inputValue;

		  for (inputKey in input) {
		    inputValue = input[inputKey];

		    outputAsHash[inputKey] = minify(inputValue.styles, options, inputValue.sourceMap);
		    errors = errors.concat(outputAsHash[inputKey].errors);
		  }

		  return callback
		    ? callback(errors.length > 0 ? errors : null, outputAsHash)
		    : outputAsHash;
		}

		function minify(input, options, maybeSourceMap, maybeCallback) {
		  var sourceMap = typeof maybeSourceMap != 'function'
		    ? maybeSourceMap
		    : null;
		  var callback = typeof maybeCallback == 'function'
		    ? maybeCallback
		    : (typeof maybeSourceMap == 'function' ? maybeSourceMap : null);
		  var context = {
		    stats: {
		      efficiency: 0,
		      minifiedSize: 0,
		      originalSize: 0,
		      startedAt: Date.now(),
		      timeSpent: 0
		    },
		    cache: { specificity: {} },
		    errors: [],
		    inlinedStylesheets: [],
		    inputSourceMapTracker: inputSourceMapTracker(),
		    localOnly: !callback,
		    options: options,
		    source: null,
		    sourcesContent: {},
		    validator: validator(options.compatibility),
		    warnings: []
		  };
		  var implicitRebaseToWarning;

		  if (sourceMap) {
		    context.inputSourceMapTracker.track(undefined, sourceMap);
		  }

		  if (options.rebase && !options.explicitRebaseTo) {
		    implicitRebaseToWarning = 'You have set `rebase: true` without giving `rebaseTo` option, which, in this case, defaults to the current working directory. '
		      + 'You are then warned this can lead to unexpected URL rebasing (aka here be dragons)! '
		      + 'If you are OK with the clean-css output, then you can get rid of this warning by giving clean-css a `rebaseTo: process.cwd()` option.';
		    context.warnings.push(implicitRebaseToWarning);
		  }

		  return runner(context.localOnly)(function() {
		    return readSources(input, context, function(tokens) {
		      var serialize = context.options.sourceMap
		        ? serializeStylesAndSourceMap
		        : serializeStyles;

		      var optimizedTokens = optimize(tokens, context);
		      var optimizedStyles = serialize(optimizedTokens, context);
		      var output = withMetadata(optimizedStyles, context);

		      return callback
		        ? callback(context.errors.length > 0 ? context.errors : null, output)
		        : output;
		    });
		  });
		}

		function runner(localOnly) {
		  // to always execute code asynchronously when a callback is given
		  // more at blog.izs.me/post/59142742143/designing-apis-for-asynchrony
		  return localOnly
		    ? function(callback) { return callback(); }
		    : browser$1.nextTick;
		}

		function optimize(tokens, context) {
		  var optimized = level0Optimize(tokens, context);

		  optimized = OptimizationLevel.One in context.options.level
		    ? level1Optimize(tokens, context)
		    : tokens;
		  optimized = OptimizationLevel.Two in context.options.level
		    ? level2Optimize(tokens, context, true)
		    : optimized;

		  return optimized;
		}

		function withMetadata(output, context) {
		  output.stats = calculateStatsFrom(output.styles, context);
		  output.errors = context.errors;
		  output.inlinedStylesheets = context.inlinedStylesheets;
		  output.warnings = context.warnings;

		  return output;
		}

		function calculateStatsFrom(styles, context) {
		  var finishedAt = Date.now();
		  var timeSpent = finishedAt - context.stats.startedAt;

		  delete context.stats.startedAt;
		  context.stats.timeSpent = timeSpent;
		  context.stats.efficiency = 1 - styles.length / context.stats.originalSize;
		  context.stats.minifiedSize = styles.length;

		  return context.stats;
		}
		return clean.exports;
	}

	var cleanCss;
	var hasRequiredCleanCss;

	function requireCleanCss () {
		if (hasRequiredCleanCss) return cleanCss;
		hasRequiredCleanCss = 1;
		cleanCss = requireClean();
		return cleanCss;
	}

	var cleanCssExports = requireCleanCss();
	var CleanCSS = /*@__PURE__*/getDefaultExportFromCjs(cleanCssExports);

	// Generated using scripts/write-decode-map.ts
	const htmlDecodeTree = /* #__PURE__ */ new Uint16Array(
	// prettier-ignore
	/* #__PURE__ */ "\u1d41<\xd5\u0131\u028a\u049d\u057b\u05d0\u0675\u06de\u07a2\u07d6\u080f\u0a4a\u0a91\u0da1\u0e6d\u0f09\u0f26\u10ca\u1228\u12e1\u1415\u149d\u14c3\u14df\u1525\0\0\0\0\0\0\u156b\u16cd\u198d\u1c12\u1ddd\u1f7e\u2060\u21b0\u228d\u23c0\u23fb\u2442\u2824\u2912\u2d08\u2e48\u2fce\u3016\u32ba\u3639\u37ac\u38fe\u3a28\u3a71\u3ae0\u3b2e\u0800EMabcfglmnoprstu\\bfms\x7f\x84\x8b\x90\x95\x98\xa6\xb3\xb9\xc8\xcflig\u803b\xc6\u40c6P\u803b&\u4026cute\u803b\xc1\u40c1reve;\u4102\u0100iyx}rc\u803b\xc2\u40c2;\u4410r;\uc000\ud835\udd04rave\u803b\xc0\u40c0pha;\u4391acr;\u4100d;\u6a53\u0100gp\x9d\xa1on;\u4104f;\uc000\ud835\udd38plyFunction;\u6061ing\u803b\xc5\u40c5\u0100cs\xbe\xc3r;\uc000\ud835\udc9cign;\u6254ilde\u803b\xc3\u40c3ml\u803b\xc4\u40c4\u0400aceforsu\xe5\xfb\xfe\u0117\u011c\u0122\u0127\u012a\u0100cr\xea\xf2kslash;\u6216\u0176\xf6\xf8;\u6ae7ed;\u6306y;\u4411\u0180crt\u0105\u010b\u0114ause;\u6235noullis;\u612ca;\u4392r;\uc000\ud835\udd05pf;\uc000\ud835\udd39eve;\u42d8c\xf2\u0113mpeq;\u624e\u0700HOacdefhilorsu\u014d\u0151\u0156\u0180\u019e\u01a2\u01b5\u01b7\u01ba\u01dc\u0215\u0273\u0278\u027ecy;\u4427PY\u803b\xa9\u40a9\u0180cpy\u015d\u0162\u017aute;\u4106\u0100;i\u0167\u0168\u62d2talDifferentialD;\u6145leys;\u612d\u0200aeio\u0189\u018e\u0194\u0198ron;\u410cdil\u803b\xc7\u40c7rc;\u4108nint;\u6230ot;\u410a\u0100dn\u01a7\u01adilla;\u40b8terDot;\u40b7\xf2\u017fi;\u43a7rcle\u0200DMPT\u01c7\u01cb\u01d1\u01d6ot;\u6299inus;\u6296lus;\u6295imes;\u6297o\u0100cs\u01e2\u01f8kwiseContourIntegral;\u6232eCurly\u0100DQ\u0203\u020foubleQuote;\u601duote;\u6019\u0200lnpu\u021e\u0228\u0247\u0255on\u0100;e\u0225\u0226\u6237;\u6a74\u0180git\u022f\u0236\u023aruent;\u6261nt;\u622fourIntegral;\u622e\u0100fr\u024c\u024e;\u6102oduct;\u6210nterClockwiseContourIntegral;\u6233oss;\u6a2fcr;\uc000\ud835\udc9ep\u0100;C\u0284\u0285\u62d3ap;\u624d\u0580DJSZacefios\u02a0\u02ac\u02b0\u02b4\u02b8\u02cb\u02d7\u02e1\u02e6\u0333\u048d\u0100;o\u0179\u02a5trahd;\u6911cy;\u4402cy;\u4405cy;\u440f\u0180grs\u02bf\u02c4\u02c7ger;\u6021r;\u61a1hv;\u6ae4\u0100ay\u02d0\u02d5ron;\u410e;\u4414l\u0100;t\u02dd\u02de\u6207a;\u4394r;\uc000\ud835\udd07\u0100af\u02eb\u0327\u0100cm\u02f0\u0322ritical\u0200ADGT\u0300\u0306\u0316\u031ccute;\u40b4o\u0174\u030b\u030d;\u42d9bleAcute;\u42ddrave;\u4060ilde;\u42dcond;\u62c4ferentialD;\u6146\u0470\u033d\0\0\0\u0342\u0354\0\u0405f;\uc000\ud835\udd3b\u0180;DE\u0348\u0349\u034d\u40a8ot;\u60dcqual;\u6250ble\u0300CDLRUV\u0363\u0372\u0382\u03cf\u03e2\u03f8ontourIntegra\xec\u0239o\u0274\u0379\0\0\u037b\xbb\u0349nArrow;\u61d3\u0100eo\u0387\u03a4ft\u0180ART\u0390\u0396\u03a1rrow;\u61d0ightArrow;\u61d4e\xe5\u02cang\u0100LR\u03ab\u03c4eft\u0100AR\u03b3\u03b9rrow;\u67f8ightArrow;\u67faightArrow;\u67f9ight\u0100AT\u03d8\u03derrow;\u61d2ee;\u62a8p\u0241\u03e9\0\0\u03efrrow;\u61d1ownArrow;\u61d5erticalBar;\u6225n\u0300ABLRTa\u0412\u042a\u0430\u045e\u047f\u037crrow\u0180;BU\u041d\u041e\u0422\u6193ar;\u6913pArrow;\u61f5reve;\u4311eft\u02d2\u043a\0\u0446\0\u0450ightVector;\u6950eeVector;\u695eector\u0100;B\u0459\u045a\u61bdar;\u6956ight\u01d4\u0467\0\u0471eeVector;\u695fector\u0100;B\u047a\u047b\u61c1ar;\u6957ee\u0100;A\u0486\u0487\u62a4rrow;\u61a7\u0100ct\u0492\u0497r;\uc000\ud835\udc9frok;\u4110\u0800NTacdfglmopqstux\u04bd\u04c0\u04c4\u04cb\u04de\u04e2\u04e7\u04ee\u04f5\u0521\u052f\u0536\u0552\u055d\u0560\u0565G;\u414aH\u803b\xd0\u40d0cute\u803b\xc9\u40c9\u0180aiy\u04d2\u04d7\u04dcron;\u411arc\u803b\xca\u40ca;\u442dot;\u4116r;\uc000\ud835\udd08rave\u803b\xc8\u40c8ement;\u6208\u0100ap\u04fa\u04fecr;\u4112ty\u0253\u0506\0\0\u0512mallSquare;\u65fberySmallSquare;\u65ab\u0100gp\u0526\u052aon;\u4118f;\uc000\ud835\udd3csilon;\u4395u\u0100ai\u053c\u0549l\u0100;T\u0542\u0543\u6a75ilde;\u6242librium;\u61cc\u0100ci\u0557\u055ar;\u6130m;\u6a73a;\u4397ml\u803b\xcb\u40cb\u0100ip\u056a\u056fsts;\u6203onentialE;\u6147\u0280cfios\u0585\u0588\u058d\u05b2\u05ccy;\u4424r;\uc000\ud835\udd09lled\u0253\u0597\0\0\u05a3mallSquare;\u65fcerySmallSquare;\u65aa\u0370\u05ba\0\u05bf\0\0\u05c4f;\uc000\ud835\udd3dAll;\u6200riertrf;\u6131c\xf2\u05cb\u0600JTabcdfgorst\u05e8\u05ec\u05ef\u05fa\u0600\u0612\u0616\u061b\u061d\u0623\u066c\u0672cy;\u4403\u803b>\u403emma\u0100;d\u05f7\u05f8\u4393;\u43dcreve;\u411e\u0180eiy\u0607\u060c\u0610dil;\u4122rc;\u411c;\u4413ot;\u4120r;\uc000\ud835\udd0a;\u62d9pf;\uc000\ud835\udd3eeater\u0300EFGLST\u0635\u0644\u064e\u0656\u065b\u0666qual\u0100;L\u063e\u063f\u6265ess;\u62dbullEqual;\u6267reater;\u6aa2ess;\u6277lantEqual;\u6a7eilde;\u6273cr;\uc000\ud835\udca2;\u626b\u0400Aacfiosu\u0685\u068b\u0696\u069b\u069e\u06aa\u06be\u06caRDcy;\u442a\u0100ct\u0690\u0694ek;\u42c7;\u405eirc;\u4124r;\u610clbertSpace;\u610b\u01f0\u06af\0\u06b2f;\u610dizontalLine;\u6500\u0100ct\u06c3\u06c5\xf2\u06a9rok;\u4126mp\u0144\u06d0\u06d8ownHum\xf0\u012fqual;\u624f\u0700EJOacdfgmnostu\u06fa\u06fe\u0703\u0707\u070e\u071a\u071e\u0721\u0728\u0744\u0778\u078b\u078f\u0795cy;\u4415lig;\u4132cy;\u4401cute\u803b\xcd\u40cd\u0100iy\u0713\u0718rc\u803b\xce\u40ce;\u4418ot;\u4130r;\u6111rave\u803b\xcc\u40cc\u0180;ap\u0720\u072f\u073f\u0100cg\u0734\u0737r;\u412ainaryI;\u6148lie\xf3\u03dd\u01f4\u0749\0\u0762\u0100;e\u074d\u074e\u622c\u0100gr\u0753\u0758ral;\u622bsection;\u62c2isible\u0100CT\u076c\u0772omma;\u6063imes;\u6062\u0180gpt\u077f\u0783\u0788on;\u412ef;\uc000\ud835\udd40a;\u4399cr;\u6110ilde;\u4128\u01eb\u079a\0\u079ecy;\u4406l\u803b\xcf\u40cf\u0280cfosu\u07ac\u07b7\u07bc\u07c2\u07d0\u0100iy\u07b1\u07b5rc;\u4134;\u4419r;\uc000\ud835\udd0dpf;\uc000\ud835\udd41\u01e3\u07c7\0\u07ccr;\uc000\ud835\udca5rcy;\u4408kcy;\u4404\u0380HJacfos\u07e4\u07e8\u07ec\u07f1\u07fd\u0802\u0808cy;\u4425cy;\u440cppa;\u439a\u0100ey\u07f6\u07fbdil;\u4136;\u441ar;\uc000\ud835\udd0epf;\uc000\ud835\udd42cr;\uc000\ud835\udca6\u0580JTaceflmost\u0825\u0829\u082c\u0850\u0863\u09b3\u09b8\u09c7\u09cd\u0a37\u0a47cy;\u4409\u803b<\u403c\u0280cmnpr\u0837\u083c\u0841\u0844\u084dute;\u4139bda;\u439bg;\u67ealacetrf;\u6112r;\u619e\u0180aey\u0857\u085c\u0861ron;\u413ddil;\u413b;\u441b\u0100fs\u0868\u0970t\u0500ACDFRTUVar\u087e\u08a9\u08b1\u08e0\u08e6\u08fc\u092f\u095b\u0390\u096a\u0100nr\u0883\u088fgleBracket;\u67e8row\u0180;BR\u0899\u089a\u089e\u6190ar;\u61e4ightArrow;\u61c6eiling;\u6308o\u01f5\u08b7\0\u08c3bleBracket;\u67e6n\u01d4\u08c8\0\u08d2eeVector;\u6961ector\u0100;B\u08db\u08dc\u61c3ar;\u6959loor;\u630aight\u0100AV\u08ef\u08f5rrow;\u6194ector;\u694e\u0100er\u0901\u0917e\u0180;AV\u0909\u090a\u0910\u62a3rrow;\u61a4ector;\u695aiangle\u0180;BE\u0924\u0925\u0929\u62b2ar;\u69cfqual;\u62b4p\u0180DTV\u0937\u0942\u094cownVector;\u6951eeVector;\u6960ector\u0100;B\u0956\u0957\u61bfar;\u6958ector\u0100;B\u0965\u0966\u61bcar;\u6952ight\xe1\u039cs\u0300EFGLST\u097e\u098b\u0995\u099d\u09a2\u09adqualGreater;\u62daullEqual;\u6266reater;\u6276ess;\u6aa1lantEqual;\u6a7dilde;\u6272r;\uc000\ud835\udd0f\u0100;e\u09bd\u09be\u62d8ftarrow;\u61daidot;\u413f\u0180npw\u09d4\u0a16\u0a1bg\u0200LRlr\u09de\u09f7\u0a02\u0a10eft\u0100AR\u09e6\u09ecrrow;\u67f5ightArrow;\u67f7ightArrow;\u67f6eft\u0100ar\u03b3\u0a0aight\xe1\u03bfight\xe1\u03caf;\uc000\ud835\udd43er\u0100LR\u0a22\u0a2ceftArrow;\u6199ightArrow;\u6198\u0180cht\u0a3e\u0a40\u0a42\xf2\u084c;\u61b0rok;\u4141;\u626a\u0400acefiosu\u0a5a\u0a5d\u0a60\u0a77\u0a7c\u0a85\u0a8b\u0a8ep;\u6905y;\u441c\u0100dl\u0a65\u0a6fiumSpace;\u605flintrf;\u6133r;\uc000\ud835\udd10nusPlus;\u6213pf;\uc000\ud835\udd44c\xf2\u0a76;\u439c\u0480Jacefostu\u0aa3\u0aa7\u0aad\u0ac0\u0b14\u0b19\u0d91\u0d97\u0d9ecy;\u440acute;\u4143\u0180aey\u0ab4\u0ab9\u0aberon;\u4147dil;\u4145;\u441d\u0180gsw\u0ac7\u0af0\u0b0eative\u0180MTV\u0ad3\u0adf\u0ae8ediumSpace;\u600bhi\u0100cn\u0ae6\u0ad8\xeb\u0ad9eryThi\xee\u0ad9ted\u0100GL\u0af8\u0b06reaterGreate\xf2\u0673essLes\xf3\u0a48Line;\u400ar;\uc000\ud835\udd11\u0200Bnpt\u0b22\u0b28\u0b37\u0b3areak;\u6060BreakingSpace;\u40a0f;\u6115\u0680;CDEGHLNPRSTV\u0b55\u0b56\u0b6a\u0b7c\u0ba1\u0beb\u0c04\u0c5e\u0c84\u0ca6\u0cd8\u0d61\u0d85\u6aec\u0100ou\u0b5b\u0b64ngruent;\u6262pCap;\u626doubleVerticalBar;\u6226\u0180lqx\u0b83\u0b8a\u0b9bement;\u6209ual\u0100;T\u0b92\u0b93\u6260ilde;\uc000\u2242\u0338ists;\u6204reater\u0380;EFGLST\u0bb6\u0bb7\u0bbd\u0bc9\u0bd3\u0bd8\u0be5\u626fqual;\u6271ullEqual;\uc000\u2267\u0338reater;\uc000\u226b\u0338ess;\u6279lantEqual;\uc000\u2a7e\u0338ilde;\u6275ump\u0144\u0bf2\u0bfdownHump;\uc000\u224e\u0338qual;\uc000\u224f\u0338e\u0100fs\u0c0a\u0c27tTriangle\u0180;BE\u0c1a\u0c1b\u0c21\u62eaar;\uc000\u29cf\u0338qual;\u62ecs\u0300;EGLST\u0c35\u0c36\u0c3c\u0c44\u0c4b\u0c58\u626equal;\u6270reater;\u6278ess;\uc000\u226a\u0338lantEqual;\uc000\u2a7d\u0338ilde;\u6274ested\u0100GL\u0c68\u0c79reaterGreater;\uc000\u2aa2\u0338essLess;\uc000\u2aa1\u0338recedes\u0180;ES\u0c92\u0c93\u0c9b\u6280qual;\uc000\u2aaf\u0338lantEqual;\u62e0\u0100ei\u0cab\u0cb9verseElement;\u620cghtTriangle\u0180;BE\u0ccb\u0ccc\u0cd2\u62ebar;\uc000\u29d0\u0338qual;\u62ed\u0100qu\u0cdd\u0d0cuareSu\u0100bp\u0ce8\u0cf9set\u0100;E\u0cf0\u0cf3\uc000\u228f\u0338qual;\u62e2erset\u0100;E\u0d03\u0d06\uc000\u2290\u0338qual;\u62e3\u0180bcp\u0d13\u0d24\u0d4eset\u0100;E\u0d1b\u0d1e\uc000\u2282\u20d2qual;\u6288ceeds\u0200;EST\u0d32\u0d33\u0d3b\u0d46\u6281qual;\uc000\u2ab0\u0338lantEqual;\u62e1ilde;\uc000\u227f\u0338erset\u0100;E\u0d58\u0d5b\uc000\u2283\u20d2qual;\u6289ilde\u0200;EFT\u0d6e\u0d6f\u0d75\u0d7f\u6241qual;\u6244ullEqual;\u6247ilde;\u6249erticalBar;\u6224cr;\uc000\ud835\udca9ilde\u803b\xd1\u40d1;\u439d\u0700Eacdfgmoprstuv\u0dbd\u0dc2\u0dc9\u0dd5\u0ddb\u0de0\u0de7\u0dfc\u0e02\u0e20\u0e22\u0e32\u0e3f\u0e44lig;\u4152cute\u803b\xd3\u40d3\u0100iy\u0dce\u0dd3rc\u803b\xd4\u40d4;\u441eblac;\u4150r;\uc000\ud835\udd12rave\u803b\xd2\u40d2\u0180aei\u0dee\u0df2\u0df6cr;\u414cga;\u43a9cron;\u439fpf;\uc000\ud835\udd46enCurly\u0100DQ\u0e0e\u0e1aoubleQuote;\u601cuote;\u6018;\u6a54\u0100cl\u0e27\u0e2cr;\uc000\ud835\udcaaash\u803b\xd8\u40d8i\u016c\u0e37\u0e3cde\u803b\xd5\u40d5es;\u6a37ml\u803b\xd6\u40d6er\u0100BP\u0e4b\u0e60\u0100ar\u0e50\u0e53r;\u603eac\u0100ek\u0e5a\u0e5c;\u63deet;\u63b4arenthesis;\u63dc\u0480acfhilors\u0e7f\u0e87\u0e8a\u0e8f\u0e92\u0e94\u0e9d\u0eb0\u0efcrtialD;\u6202y;\u441fr;\uc000\ud835\udd13i;\u43a6;\u43a0usMinus;\u40b1\u0100ip\u0ea2\u0eadncareplan\xe5\u069df;\u6119\u0200;eio\u0eb9\u0eba\u0ee0\u0ee4\u6abbcedes\u0200;EST\u0ec8\u0ec9\u0ecf\u0eda\u627aqual;\u6aaflantEqual;\u627cilde;\u627eme;\u6033\u0100dp\u0ee9\u0eeeuct;\u620fortion\u0100;a\u0225\u0ef9l;\u621d\u0100ci\u0f01\u0f06r;\uc000\ud835\udcab;\u43a8\u0200Ufos\u0f11\u0f16\u0f1b\u0f1fOT\u803b\"\u4022r;\uc000\ud835\udd14pf;\u611acr;\uc000\ud835\udcac\u0600BEacefhiorsu\u0f3e\u0f43\u0f47\u0f60\u0f73\u0fa7\u0faa\u0fad\u1096\u10a9\u10b4\u10bearr;\u6910G\u803b\xae\u40ae\u0180cnr\u0f4e\u0f53\u0f56ute;\u4154g;\u67ebr\u0100;t\u0f5c\u0f5d\u61a0l;\u6916\u0180aey\u0f67\u0f6c\u0f71ron;\u4158dil;\u4156;\u4420\u0100;v\u0f78\u0f79\u611cerse\u0100EU\u0f82\u0f99\u0100lq\u0f87\u0f8eement;\u620builibrium;\u61cbpEquilibrium;\u696fr\xbb\u0f79o;\u43a1ght\u0400ACDFTUVa\u0fc1\u0feb\u0ff3\u1022\u1028\u105b\u1087\u03d8\u0100nr\u0fc6\u0fd2gleBracket;\u67e9row\u0180;BL\u0fdc\u0fdd\u0fe1\u6192ar;\u61e5eftArrow;\u61c4eiling;\u6309o\u01f5\u0ff9\0\u1005bleBracket;\u67e7n\u01d4\u100a\0\u1014eeVector;\u695dector\u0100;B\u101d\u101e\u61c2ar;\u6955loor;\u630b\u0100er\u102d\u1043e\u0180;AV\u1035\u1036\u103c\u62a2rrow;\u61a6ector;\u695biangle\u0180;BE\u1050\u1051\u1055\u62b3ar;\u69d0qual;\u62b5p\u0180DTV\u1063\u106e\u1078ownVector;\u694feeVector;\u695cector\u0100;B\u1082\u1083\u61bear;\u6954ector\u0100;B\u1091\u1092\u61c0ar;\u6953\u0100pu\u109b\u109ef;\u611dndImplies;\u6970ightarrow;\u61db\u0100ch\u10b9\u10bcr;\u611b;\u61b1leDelayed;\u69f4\u0680HOacfhimoqstu\u10e4\u10f1\u10f7\u10fd\u1119\u111e\u1151\u1156\u1161\u1167\u11b5\u11bb\u11bf\u0100Cc\u10e9\u10eeHcy;\u4429y;\u4428FTcy;\u442ccute;\u415a\u0280;aeiy\u1108\u1109\u110e\u1113\u1117\u6abcron;\u4160dil;\u415erc;\u415c;\u4421r;\uc000\ud835\udd16ort\u0200DLRU\u112a\u1134\u113e\u1149ownArrow\xbb\u041eeftArrow\xbb\u089aightArrow\xbb\u0fddpArrow;\u6191gma;\u43a3allCircle;\u6218pf;\uc000\ud835\udd4a\u0272\u116d\0\0\u1170t;\u621aare\u0200;ISU\u117b\u117c\u1189\u11af\u65a1ntersection;\u6293u\u0100bp\u118f\u119eset\u0100;E\u1197\u1198\u628fqual;\u6291erset\u0100;E\u11a8\u11a9\u6290qual;\u6292nion;\u6294cr;\uc000\ud835\udcaear;\u62c6\u0200bcmp\u11c8\u11db\u1209\u120b\u0100;s\u11cd\u11ce\u62d0et\u0100;E\u11cd\u11d5qual;\u6286\u0100ch\u11e0\u1205eeds\u0200;EST\u11ed\u11ee\u11f4\u11ff\u627bqual;\u6ab0lantEqual;\u627dilde;\u627fTh\xe1\u0f8c;\u6211\u0180;es\u1212\u1213\u1223\u62d1rset\u0100;E\u121c\u121d\u6283qual;\u6287et\xbb\u1213\u0580HRSacfhiors\u123e\u1244\u1249\u1255\u125e\u1271\u1276\u129f\u12c2\u12c8\u12d1ORN\u803b\xde\u40deADE;\u6122\u0100Hc\u124e\u1252cy;\u440by;\u4426\u0100bu\u125a\u125c;\u4009;\u43a4\u0180aey\u1265\u126a\u126fron;\u4164dil;\u4162;\u4422r;\uc000\ud835\udd17\u0100ei\u127b\u1289\u01f2\u1280\0\u1287efore;\u6234a;\u4398\u0100cn\u128e\u1298kSpace;\uc000\u205f\u200aSpace;\u6009lde\u0200;EFT\u12ab\u12ac\u12b2\u12bc\u623cqual;\u6243ullEqual;\u6245ilde;\u6248pf;\uc000\ud835\udd4bipleDot;\u60db\u0100ct\u12d6\u12dbr;\uc000\ud835\udcafrok;\u4166\u0ae1\u12f7\u130e\u131a\u1326\0\u132c\u1331\0\0\0\0\0\u1338\u133d\u1377\u1385\0\u13ff\u1404\u140a\u1410\u0100cr\u12fb\u1301ute\u803b\xda\u40dar\u0100;o\u1307\u1308\u619fcir;\u6949r\u01e3\u1313\0\u1316y;\u440eve;\u416c\u0100iy\u131e\u1323rc\u803b\xdb\u40db;\u4423blac;\u4170r;\uc000\ud835\udd18rave\u803b\xd9\u40d9acr;\u416a\u0100di\u1341\u1369er\u0100BP\u1348\u135d\u0100ar\u134d\u1350r;\u405fac\u0100ek\u1357\u1359;\u63dfet;\u63b5arenthesis;\u63ddon\u0100;P\u1370\u1371\u62c3lus;\u628e\u0100gp\u137b\u137fon;\u4172f;\uc000\ud835\udd4c\u0400ADETadps\u1395\u13ae\u13b8\u13c4\u03e8\u13d2\u13d7\u13f3rrow\u0180;BD\u1150\u13a0\u13a4ar;\u6912ownArrow;\u61c5ownArrow;\u6195quilibrium;\u696eee\u0100;A\u13cb\u13cc\u62a5rrow;\u61a5own\xe1\u03f3er\u0100LR\u13de\u13e8eftArrow;\u6196ightArrow;\u6197i\u0100;l\u13f9\u13fa\u43d2on;\u43a5ing;\u416ecr;\uc000\ud835\udcb0ilde;\u4168ml\u803b\xdc\u40dc\u0480Dbcdefosv\u1427\u142c\u1430\u1433\u143e\u1485\u148a\u1490\u1496ash;\u62abar;\u6aeby;\u4412ash\u0100;l\u143b\u143c\u62a9;\u6ae6\u0100er\u1443\u1445;\u62c1\u0180bty\u144c\u1450\u147aar;\u6016\u0100;i\u144f\u1455cal\u0200BLST\u1461\u1465\u146a\u1474ar;\u6223ine;\u407ceparator;\u6758ilde;\u6240ThinSpace;\u600ar;\uc000\ud835\udd19pf;\uc000\ud835\udd4dcr;\uc000\ud835\udcb1dash;\u62aa\u0280cefos\u14a7\u14ac\u14b1\u14b6\u14bcirc;\u4174dge;\u62c0r;\uc000\ud835\udd1apf;\uc000\ud835\udd4ecr;\uc000\ud835\udcb2\u0200fios\u14cb\u14d0\u14d2\u14d8r;\uc000\ud835\udd1b;\u439epf;\uc000\ud835\udd4fcr;\uc000\ud835\udcb3\u0480AIUacfosu\u14f1\u14f5\u14f9\u14fd\u1504\u150f\u1514\u151a\u1520cy;\u442fcy;\u4407cy;\u442ecute\u803b\xdd\u40dd\u0100iy\u1509\u150drc;\u4176;\u442br;\uc000\ud835\udd1cpf;\uc000\ud835\udd50cr;\uc000\ud835\udcb4ml;\u4178\u0400Hacdefos\u1535\u1539\u153f\u154b\u154f\u155d\u1560\u1564cy;\u4416cute;\u4179\u0100ay\u1544\u1549ron;\u417d;\u4417ot;\u417b\u01f2\u1554\0\u155boWidt\xe8\u0ad9a;\u4396r;\u6128pf;\u6124cr;\uc000\ud835\udcb5\u0be1\u1583\u158a\u1590\0\u15b0\u15b6\u15bf\0\0\0\0\u15c6\u15db\u15eb\u165f\u166d\0\u1695\u169b\u16b2\u16b9\0\u16becute\u803b\xe1\u40e1reve;\u4103\u0300;Ediuy\u159c\u159d\u15a1\u15a3\u15a8\u15ad\u623e;\uc000\u223e\u0333;\u623frc\u803b\xe2\u40e2te\u80bb\xb4\u0306;\u4430lig\u803b\xe6\u40e6\u0100;r\xb2\u15ba;\uc000\ud835\udd1erave\u803b\xe0\u40e0\u0100ep\u15ca\u15d6\u0100fp\u15cf\u15d4sym;\u6135\xe8\u15d3ha;\u43b1\u0100ap\u15dfc\u0100cl\u15e4\u15e7r;\u4101g;\u6a3f\u0264\u15f0\0\0\u160a\u0280;adsv\u15fa\u15fb\u15ff\u1601\u1607\u6227nd;\u6a55;\u6a5clope;\u6a58;\u6a5a\u0380;elmrsz\u1618\u1619\u161b\u161e\u163f\u164f\u1659\u6220;\u69a4e\xbb\u1619sd\u0100;a\u1625\u1626\u6221\u0461\u1630\u1632\u1634\u1636\u1638\u163a\u163c\u163e;\u69a8;\u69a9;\u69aa;\u69ab;\u69ac;\u69ad;\u69ae;\u69aft\u0100;v\u1645\u1646\u621fb\u0100;d\u164c\u164d\u62be;\u699d\u0100pt\u1654\u1657h;\u6222\xbb\xb9arr;\u637c\u0100gp\u1663\u1667on;\u4105f;\uc000\ud835\udd52\u0380;Eaeiop\u12c1\u167b\u167d\u1682\u1684\u1687\u168a;\u6a70cir;\u6a6f;\u624ad;\u624bs;\u4027rox\u0100;e\u12c1\u1692\xf1\u1683ing\u803b\xe5\u40e5\u0180cty\u16a1\u16a6\u16a8r;\uc000\ud835\udcb6;\u402amp\u0100;e\u12c1\u16af\xf1\u0288ilde\u803b\xe3\u40e3ml\u803b\xe4\u40e4\u0100ci\u16c2\u16c8onin\xf4\u0272nt;\u6a11\u0800Nabcdefiklnoprsu\u16ed\u16f1\u1730\u173c\u1743\u1748\u1778\u177d\u17e0\u17e6\u1839\u1850\u170d\u193d\u1948\u1970ot;\u6aed\u0100cr\u16f6\u171ek\u0200ceps\u1700\u1705\u170d\u1713ong;\u624cpsilon;\u43f6rime;\u6035im\u0100;e\u171a\u171b\u623dq;\u62cd\u0176\u1722\u1726ee;\u62bded\u0100;g\u172c\u172d\u6305e\xbb\u172drk\u0100;t\u135c\u1737brk;\u63b6\u0100oy\u1701\u1741;\u4431quo;\u601e\u0280cmprt\u1753\u175b\u1761\u1764\u1768aus\u0100;e\u010a\u0109ptyv;\u69b0s\xe9\u170cno\xf5\u0113\u0180ahw\u176f\u1771\u1773;\u43b2;\u6136een;\u626cr;\uc000\ud835\udd1fg\u0380costuvw\u178d\u179d\u17b3\u17c1\u17d5\u17db\u17de\u0180aiu\u1794\u1796\u179a\xf0\u0760rc;\u65efp\xbb\u1371\u0180dpt\u17a4\u17a8\u17adot;\u6a00lus;\u6a01imes;\u6a02\u0271\u17b9\0\0\u17becup;\u6a06ar;\u6605riangle\u0100du\u17cd\u17d2own;\u65bdp;\u65b3plus;\u6a04e\xe5\u1444\xe5\u14adarow;\u690d\u0180ako\u17ed\u1826\u1835\u0100cn\u17f2\u1823k\u0180lst\u17fa\u05ab\u1802ozenge;\u69ebriangle\u0200;dlr\u1812\u1813\u1818\u181d\u65b4own;\u65beeft;\u65c2ight;\u65b8k;\u6423\u01b1\u182b\0\u1833\u01b2\u182f\0\u1831;\u6592;\u65914;\u6593ck;\u6588\u0100eo\u183e\u184d\u0100;q\u1843\u1846\uc000=\u20e5uiv;\uc000\u2261\u20e5t;\u6310\u0200ptwx\u1859\u185e\u1867\u186cf;\uc000\ud835\udd53\u0100;t\u13cb\u1863om\xbb\u13cctie;\u62c8\u0600DHUVbdhmptuv\u1885\u1896\u18aa\u18bb\u18d7\u18db\u18ec\u18ff\u1905\u190a\u1910\u1921\u0200LRlr\u188e\u1890\u1892\u1894;\u6557;\u6554;\u6556;\u6553\u0280;DUdu\u18a1\u18a2\u18a4\u18a6\u18a8\u6550;\u6566;\u6569;\u6564;\u6567\u0200LRlr\u18b3\u18b5\u18b7\u18b9;\u655d;\u655a;\u655c;\u6559\u0380;HLRhlr\u18ca\u18cb\u18cd\u18cf\u18d1\u18d3\u18d5\u6551;\u656c;\u6563;\u6560;\u656b;\u6562;\u655fox;\u69c9\u0200LRlr\u18e4\u18e6\u18e8\u18ea;\u6555;\u6552;\u6510;\u650c\u0280;DUdu\u06bd\u18f7\u18f9\u18fb\u18fd;\u6565;\u6568;\u652c;\u6534inus;\u629flus;\u629eimes;\u62a0\u0200LRlr\u1919\u191b\u191d\u191f;\u655b;\u6558;\u6518;\u6514\u0380;HLRhlr\u1930\u1931\u1933\u1935\u1937\u1939\u193b\u6502;\u656a;\u6561;\u655e;\u653c;\u6524;\u651c\u0100ev\u0123\u1942bar\u803b\xa6\u40a6\u0200ceio\u1951\u1956\u195a\u1960r;\uc000\ud835\udcb7mi;\u604fm\u0100;e\u171a\u171cl\u0180;bh\u1968\u1969\u196b\u405c;\u69c5sub;\u67c8\u016c\u1974\u197el\u0100;e\u1979\u197a\u6022t\xbb\u197ap\u0180;Ee\u012f\u1985\u1987;\u6aae\u0100;q\u06dc\u06db\u0ce1\u19a7\0\u19e8\u1a11\u1a15\u1a32\0\u1a37\u1a50\0\0\u1ab4\0\0\u1ac1\0\0\u1b21\u1b2e\u1b4d\u1b52\0\u1bfd\0\u1c0c\u0180cpr\u19ad\u19b2\u19ddute;\u4107\u0300;abcds\u19bf\u19c0\u19c4\u19ca\u19d5\u19d9\u6229nd;\u6a44rcup;\u6a49\u0100au\u19cf\u19d2p;\u6a4bp;\u6a47ot;\u6a40;\uc000\u2229\ufe00\u0100eo\u19e2\u19e5t;\u6041\xee\u0693\u0200aeiu\u19f0\u19fb\u1a01\u1a05\u01f0\u19f5\0\u19f8s;\u6a4don;\u410ddil\u803b\xe7\u40e7rc;\u4109ps\u0100;s\u1a0c\u1a0d\u6a4cm;\u6a50ot;\u410b\u0180dmn\u1a1b\u1a20\u1a26il\u80bb\xb8\u01adptyv;\u69b2t\u8100\xa2;e\u1a2d\u1a2e\u40a2r\xe4\u01b2r;\uc000\ud835\udd20\u0180cei\u1a3d\u1a40\u1a4dy;\u4447ck\u0100;m\u1a47\u1a48\u6713ark\xbb\u1a48;\u43c7r\u0380;Ecefms\u1a5f\u1a60\u1a62\u1a6b\u1aa4\u1aaa\u1aae\u65cb;\u69c3\u0180;el\u1a69\u1a6a\u1a6d\u42c6q;\u6257e\u0261\u1a74\0\0\u1a88rrow\u0100lr\u1a7c\u1a81eft;\u61baight;\u61bb\u0280RSacd\u1a92\u1a94\u1a96\u1a9a\u1a9f\xbb\u0f47;\u64c8st;\u629birc;\u629aash;\u629dnint;\u6a10id;\u6aefcir;\u69c2ubs\u0100;u\u1abb\u1abc\u6663it\xbb\u1abc\u02ec\u1ac7\u1ad4\u1afa\0\u1b0aon\u0100;e\u1acd\u1ace\u403a\u0100;q\xc7\xc6\u026d\u1ad9\0\0\u1ae2a\u0100;t\u1ade\u1adf\u402c;\u4040\u0180;fl\u1ae8\u1ae9\u1aeb\u6201\xee\u1160e\u0100mx\u1af1\u1af6ent\xbb\u1ae9e\xf3\u024d\u01e7\u1afe\0\u1b07\u0100;d\u12bb\u1b02ot;\u6a6dn\xf4\u0246\u0180fry\u1b10\u1b14\u1b17;\uc000\ud835\udd54o\xe4\u0254\u8100\xa9;s\u0155\u1b1dr;\u6117\u0100ao\u1b25\u1b29rr;\u61b5ss;\u6717\u0100cu\u1b32\u1b37r;\uc000\ud835\udcb8\u0100bp\u1b3c\u1b44\u0100;e\u1b41\u1b42\u6acf;\u6ad1\u0100;e\u1b49\u1b4a\u6ad0;\u6ad2dot;\u62ef\u0380delprvw\u1b60\u1b6c\u1b77\u1b82\u1bac\u1bd4\u1bf9arr\u0100lr\u1b68\u1b6a;\u6938;\u6935\u0270\u1b72\0\0\u1b75r;\u62dec;\u62dfarr\u0100;p\u1b7f\u1b80\u61b6;\u693d\u0300;bcdos\u1b8f\u1b90\u1b96\u1ba1\u1ba5\u1ba8\u622arcap;\u6a48\u0100au\u1b9b\u1b9ep;\u6a46p;\u6a4aot;\u628dr;\u6a45;\uc000\u222a\ufe00\u0200alrv\u1bb5\u1bbf\u1bde\u1be3rr\u0100;m\u1bbc\u1bbd\u61b7;\u693cy\u0180evw\u1bc7\u1bd4\u1bd8q\u0270\u1bce\0\0\u1bd2re\xe3\u1b73u\xe3\u1b75ee;\u62ceedge;\u62cfen\u803b\xa4\u40a4earrow\u0100lr\u1bee\u1bf3eft\xbb\u1b80ight\xbb\u1bbde\xe4\u1bdd\u0100ci\u1c01\u1c07onin\xf4\u01f7nt;\u6231lcty;\u632d\u0980AHabcdefhijlorstuwz\u1c38\u1c3b\u1c3f\u1c5d\u1c69\u1c75\u1c8a\u1c9e\u1cac\u1cb7\u1cfb\u1cff\u1d0d\u1d7b\u1d91\u1dab\u1dbb\u1dc6\u1dcdr\xf2\u0381ar;\u6965\u0200glrs\u1c48\u1c4d\u1c52\u1c54ger;\u6020eth;\u6138\xf2\u1133h\u0100;v\u1c5a\u1c5b\u6010\xbb\u090a\u016b\u1c61\u1c67arow;\u690fa\xe3\u0315\u0100ay\u1c6e\u1c73ron;\u410f;\u4434\u0180;ao\u0332\u1c7c\u1c84\u0100gr\u02bf\u1c81r;\u61catseq;\u6a77\u0180glm\u1c91\u1c94\u1c98\u803b\xb0\u40b0ta;\u43b4ptyv;\u69b1\u0100ir\u1ca3\u1ca8sht;\u697f;\uc000\ud835\udd21ar\u0100lr\u1cb3\u1cb5\xbb\u08dc\xbb\u101e\u0280aegsv\u1cc2\u0378\u1cd6\u1cdc\u1ce0m\u0180;os\u0326\u1cca\u1cd4nd\u0100;s\u0326\u1cd1uit;\u6666amma;\u43ddin;\u62f2\u0180;io\u1ce7\u1ce8\u1cf8\u40f7de\u8100\xf7;o\u1ce7\u1cf0ntimes;\u62c7n\xf8\u1cf7cy;\u4452c\u026f\u1d06\0\0\u1d0arn;\u631eop;\u630d\u0280lptuw\u1d18\u1d1d\u1d22\u1d49\u1d55lar;\u4024f;\uc000\ud835\udd55\u0280;emps\u030b\u1d2d\u1d37\u1d3d\u1d42q\u0100;d\u0352\u1d33ot;\u6251inus;\u6238lus;\u6214quare;\u62a1blebarwedg\xe5\xfan\u0180adh\u112e\u1d5d\u1d67ownarrow\xf3\u1c83arpoon\u0100lr\u1d72\u1d76ef\xf4\u1cb4igh\xf4\u1cb6\u0162\u1d7f\u1d85karo\xf7\u0f42\u026f\u1d8a\0\0\u1d8ern;\u631fop;\u630c\u0180cot\u1d98\u1da3\u1da6\u0100ry\u1d9d\u1da1;\uc000\ud835\udcb9;\u4455l;\u69f6rok;\u4111\u0100dr\u1db0\u1db4ot;\u62f1i\u0100;f\u1dba\u1816\u65bf\u0100ah\u1dc0\u1dc3r\xf2\u0429a\xf2\u0fa6angle;\u69a6\u0100ci\u1dd2\u1dd5y;\u445fgrarr;\u67ff\u0900Dacdefglmnopqrstux\u1e01\u1e09\u1e19\u1e38\u0578\u1e3c\u1e49\u1e61\u1e7e\u1ea5\u1eaf\u1ebd\u1ee1\u1f2a\u1f37\u1f44\u1f4e\u1f5a\u0100Do\u1e06\u1d34o\xf4\u1c89\u0100cs\u1e0e\u1e14ute\u803b\xe9\u40e9ter;\u6a6e\u0200aioy\u1e22\u1e27\u1e31\u1e36ron;\u411br\u0100;c\u1e2d\u1e2e\u6256\u803b\xea\u40ealon;\u6255;\u444dot;\u4117\u0100Dr\u1e41\u1e45ot;\u6252;\uc000\ud835\udd22\u0180;rs\u1e50\u1e51\u1e57\u6a9aave\u803b\xe8\u40e8\u0100;d\u1e5c\u1e5d\u6a96ot;\u6a98\u0200;ils\u1e6a\u1e6b\u1e72\u1e74\u6a99nters;\u63e7;\u6113\u0100;d\u1e79\u1e7a\u6a95ot;\u6a97\u0180aps\u1e85\u1e89\u1e97cr;\u4113ty\u0180;sv\u1e92\u1e93\u1e95\u6205et\xbb\u1e93p\u01001;\u1e9d\u1ea4\u0133\u1ea1\u1ea3;\u6004;\u6005\u6003\u0100gs\u1eaa\u1eac;\u414bp;\u6002\u0100gp\u1eb4\u1eb8on;\u4119f;\uc000\ud835\udd56\u0180als\u1ec4\u1ece\u1ed2r\u0100;s\u1eca\u1ecb\u62d5l;\u69e3us;\u6a71i\u0180;lv\u1eda\u1edb\u1edf\u43b5on\xbb\u1edb;\u43f5\u0200csuv\u1eea\u1ef3\u1f0b\u1f23\u0100io\u1eef\u1e31rc\xbb\u1e2e\u0269\u1ef9\0\0\u1efb\xed\u0548ant\u0100gl\u1f02\u1f06tr\xbb\u1e5dess\xbb\u1e7a\u0180aei\u1f12\u1f16\u1f1als;\u403dst;\u625fv\u0100;D\u0235\u1f20D;\u6a78parsl;\u69e5\u0100Da\u1f2f\u1f33ot;\u6253rr;\u6971\u0180cdi\u1f3e\u1f41\u1ef8r;\u612fo\xf4\u0352\u0100ah\u1f49\u1f4b;\u43b7\u803b\xf0\u40f0\u0100mr\u1f53\u1f57l\u803b\xeb\u40ebo;\u60ac\u0180cip\u1f61\u1f64\u1f67l;\u4021s\xf4\u056e\u0100eo\u1f6c\u1f74ctatio\xee\u0559nential\xe5\u0579\u09e1\u1f92\0\u1f9e\0\u1fa1\u1fa7\0\0\u1fc6\u1fcc\0\u1fd3\0\u1fe6\u1fea\u2000\0\u2008\u205allingdotse\xf1\u1e44y;\u4444male;\u6640\u0180ilr\u1fad\u1fb3\u1fc1lig;\u8000\ufb03\u0269\u1fb9\0\0\u1fbdg;\u8000\ufb00ig;\u8000\ufb04;\uc000\ud835\udd23lig;\u8000\ufb01lig;\uc000fj\u0180alt\u1fd9\u1fdc\u1fe1t;\u666dig;\u8000\ufb02ns;\u65b1of;\u4192\u01f0\u1fee\0\u1ff3f;\uc000\ud835\udd57\u0100ak\u05bf\u1ff7\u0100;v\u1ffc\u1ffd\u62d4;\u6ad9artint;\u6a0d\u0100ao\u200c\u2055\u0100cs\u2011\u2052\u03b1\u201a\u2030\u2038\u2045\u2048\0\u2050\u03b2\u2022\u2025\u2027\u202a\u202c\0\u202e\u803b\xbd\u40bd;\u6153\u803b\xbc\u40bc;\u6155;\u6159;\u615b\u01b3\u2034\0\u2036;\u6154;\u6156\u02b4\u203e\u2041\0\0\u2043\u803b\xbe\u40be;\u6157;\u615c5;\u6158\u01b6\u204c\0\u204e;\u615a;\u615d8;\u615el;\u6044wn;\u6322cr;\uc000\ud835\udcbb\u0880Eabcdefgijlnorstv\u2082\u2089\u209f\u20a5\u20b0\u20b4\u20f0\u20f5\u20fa\u20ff\u2103\u2112\u2138\u0317\u213e\u2152\u219e\u0100;l\u064d\u2087;\u6a8c\u0180cmp\u2090\u2095\u209dute;\u41f5ma\u0100;d\u209c\u1cda\u43b3;\u6a86reve;\u411f\u0100iy\u20aa\u20aerc;\u411d;\u4433ot;\u4121\u0200;lqs\u063e\u0642\u20bd\u20c9\u0180;qs\u063e\u064c\u20c4lan\xf4\u0665\u0200;cdl\u0665\u20d2\u20d5\u20e5c;\u6aa9ot\u0100;o\u20dc\u20dd\u6a80\u0100;l\u20e2\u20e3\u6a82;\u6a84\u0100;e\u20ea\u20ed\uc000\u22db\ufe00s;\u6a94r;\uc000\ud835\udd24\u0100;g\u0673\u061bmel;\u6137cy;\u4453\u0200;Eaj\u065a\u210c\u210e\u2110;\u6a92;\u6aa5;\u6aa4\u0200Eaes\u211b\u211d\u2129\u2134;\u6269p\u0100;p\u2123\u2124\u6a8arox\xbb\u2124\u0100;q\u212e\u212f\u6a88\u0100;q\u212e\u211bim;\u62e7pf;\uc000\ud835\udd58\u0100ci\u2143\u2146r;\u610am\u0180;el\u066b\u214e\u2150;\u6a8e;\u6a90\u8300>;cdlqr\u05ee\u2160\u216a\u216e\u2173\u2179\u0100ci\u2165\u2167;\u6aa7r;\u6a7aot;\u62d7Par;\u6995uest;\u6a7c\u0280adels\u2184\u216a\u2190\u0656\u219b\u01f0\u2189\0\u218epro\xf8\u209er;\u6978q\u0100lq\u063f\u2196les\xf3\u2088i\xed\u066b\u0100en\u21a3\u21adrtneqq;\uc000\u2269\ufe00\xc5\u21aa\u0500Aabcefkosy\u21c4\u21c7\u21f1\u21f5\u21fa\u2218\u221d\u222f\u2268\u227dr\xf2\u03a0\u0200ilmr\u21d0\u21d4\u21d7\u21dbrs\xf0\u1484f\xbb\u2024il\xf4\u06a9\u0100dr\u21e0\u21e4cy;\u444a\u0180;cw\u08f4\u21eb\u21efir;\u6948;\u61adar;\u610firc;\u4125\u0180alr\u2201\u220e\u2213rts\u0100;u\u2209\u220a\u6665it\xbb\u220alip;\u6026con;\u62b9r;\uc000\ud835\udd25s\u0100ew\u2223\u2229arow;\u6925arow;\u6926\u0280amopr\u223a\u223e\u2243\u225e\u2263rr;\u61fftht;\u623bk\u0100lr\u2249\u2253eftarrow;\u61a9ightarrow;\u61aaf;\uc000\ud835\udd59bar;\u6015\u0180clt\u226f\u2274\u2278r;\uc000\ud835\udcbdas\xe8\u21f4rok;\u4127\u0100bp\u2282\u2287ull;\u6043hen\xbb\u1c5b\u0ae1\u22a3\0\u22aa\0\u22b8\u22c5\u22ce\0\u22d5\u22f3\0\0\u22f8\u2322\u2367\u2362\u237f\0\u2386\u23aa\u23b4cute\u803b\xed\u40ed\u0180;iy\u0771\u22b0\u22b5rc\u803b\xee\u40ee;\u4438\u0100cx\u22bc\u22bfy;\u4435cl\u803b\xa1\u40a1\u0100fr\u039f\u22c9;\uc000\ud835\udd26rave\u803b\xec\u40ec\u0200;ino\u073e\u22dd\u22e9\u22ee\u0100in\u22e2\u22e6nt;\u6a0ct;\u622dfin;\u69dcta;\u6129lig;\u4133\u0180aop\u22fe\u231a\u231d\u0180cgt\u2305\u2308\u2317r;\u412b\u0180elp\u071f\u230f\u2313in\xe5\u078ear\xf4\u0720h;\u4131f;\u62b7ed;\u41b5\u0280;cfot\u04f4\u232c\u2331\u233d\u2341are;\u6105in\u0100;t\u2338\u2339\u621eie;\u69dddo\xf4\u2319\u0280;celp\u0757\u234c\u2350\u235b\u2361al;\u62ba\u0100gr\u2355\u2359er\xf3\u1563\xe3\u234darhk;\u6a17rod;\u6a3c\u0200cgpt\u236f\u2372\u2376\u237by;\u4451on;\u412ff;\uc000\ud835\udd5aa;\u43b9uest\u803b\xbf\u40bf\u0100ci\u238a\u238fr;\uc000\ud835\udcben\u0280;Edsv\u04f4\u239b\u239d\u23a1\u04f3;\u62f9ot;\u62f5\u0100;v\u23a6\u23a7\u62f4;\u62f3\u0100;i\u0777\u23aelde;\u4129\u01eb\u23b8\0\u23bccy;\u4456l\u803b\xef\u40ef\u0300cfmosu\u23cc\u23d7\u23dc\u23e1\u23e7\u23f5\u0100iy\u23d1\u23d5rc;\u4135;\u4439r;\uc000\ud835\udd27ath;\u4237pf;\uc000\ud835\udd5b\u01e3\u23ec\0\u23f1r;\uc000\ud835\udcbfrcy;\u4458kcy;\u4454\u0400acfghjos\u240b\u2416\u2422\u2427\u242d\u2431\u2435\u243bppa\u0100;v\u2413\u2414\u43ba;\u43f0\u0100ey\u241b\u2420dil;\u4137;\u443ar;\uc000\ud835\udd28reen;\u4138cy;\u4445cy;\u445cpf;\uc000\ud835\udd5ccr;\uc000\ud835\udcc0\u0b80ABEHabcdefghjlmnoprstuv\u2470\u2481\u2486\u248d\u2491\u250e\u253d\u255a\u2580\u264e\u265e\u2665\u2679\u267d\u269a\u26b2\u26d8\u275d\u2768\u278b\u27c0\u2801\u2812\u0180art\u2477\u247a\u247cr\xf2\u09c6\xf2\u0395ail;\u691barr;\u690e\u0100;g\u0994\u248b;\u6a8bar;\u6962\u0963\u24a5\0\u24aa\0\u24b1\0\0\0\0\0\u24b5\u24ba\0\u24c6\u24c8\u24cd\0\u24f9ute;\u413amptyv;\u69b4ra\xee\u084cbda;\u43bbg\u0180;dl\u088e\u24c1\u24c3;\u6991\xe5\u088e;\u6a85uo\u803b\xab\u40abr\u0400;bfhlpst\u0899\u24de\u24e6\u24e9\u24eb\u24ee\u24f1\u24f5\u0100;f\u089d\u24e3s;\u691fs;\u691d\xeb\u2252p;\u61abl;\u6939im;\u6973l;\u61a2\u0180;ae\u24ff\u2500\u2504\u6aabil;\u6919\u0100;s\u2509\u250a\u6aad;\uc000\u2aad\ufe00\u0180abr\u2515\u2519\u251drr;\u690crk;\u6772\u0100ak\u2522\u252cc\u0100ek\u2528\u252a;\u407b;\u405b\u0100es\u2531\u2533;\u698bl\u0100du\u2539\u253b;\u698f;\u698d\u0200aeuy\u2546\u254b\u2556\u2558ron;\u413e\u0100di\u2550\u2554il;\u413c\xec\u08b0\xe2\u2529;\u443b\u0200cqrs\u2563\u2566\u256d\u257da;\u6936uo\u0100;r\u0e19\u1746\u0100du\u2572\u2577har;\u6967shar;\u694bh;\u61b2\u0280;fgqs\u258b\u258c\u0989\u25f3\u25ff\u6264t\u0280ahlrt\u2598\u25a4\u25b7\u25c2\u25e8rrow\u0100;t\u0899\u25a1a\xe9\u24f6arpoon\u0100du\u25af\u25b4own\xbb\u045ap\xbb\u0966eftarrows;\u61c7ight\u0180ahs\u25cd\u25d6\u25derrow\u0100;s\u08f4\u08a7arpoon\xf3\u0f98quigarro\xf7\u21f0hreetimes;\u62cb\u0180;qs\u258b\u0993\u25falan\xf4\u09ac\u0280;cdgs\u09ac\u260a\u260d\u261d\u2628c;\u6aa8ot\u0100;o\u2614\u2615\u6a7f\u0100;r\u261a\u261b\u6a81;\u6a83\u0100;e\u2622\u2625\uc000\u22da\ufe00s;\u6a93\u0280adegs\u2633\u2639\u263d\u2649\u264bppro\xf8\u24c6ot;\u62d6q\u0100gq\u2643\u2645\xf4\u0989gt\xf2\u248c\xf4\u099bi\xed\u09b2\u0180ilr\u2655\u08e1\u265asht;\u697c;\uc000\ud835\udd29\u0100;E\u099c\u2663;\u6a91\u0161\u2669\u2676r\u0100du\u25b2\u266e\u0100;l\u0965\u2673;\u696alk;\u6584cy;\u4459\u0280;acht\u0a48\u2688\u268b\u2691\u2696r\xf2\u25c1orne\xf2\u1d08ard;\u696bri;\u65fa\u0100io\u269f\u26a4dot;\u4140ust\u0100;a\u26ac\u26ad\u63b0che\xbb\u26ad\u0200Eaes\u26bb\u26bd\u26c9\u26d4;\u6268p\u0100;p\u26c3\u26c4\u6a89rox\xbb\u26c4\u0100;q\u26ce\u26cf\u6a87\u0100;q\u26ce\u26bbim;\u62e6\u0400abnoptwz\u26e9\u26f4\u26f7\u271a\u272f\u2741\u2747\u2750\u0100nr\u26ee\u26f1g;\u67ecr;\u61fdr\xeb\u08c1g\u0180lmr\u26ff\u270d\u2714eft\u0100ar\u09e6\u2707ight\xe1\u09f2apsto;\u67fcight\xe1\u09fdparrow\u0100lr\u2725\u2729ef\xf4\u24edight;\u61ac\u0180afl\u2736\u2739\u273dr;\u6985;\uc000\ud835\udd5dus;\u6a2dimes;\u6a34\u0161\u274b\u274fst;\u6217\xe1\u134e\u0180;ef\u2757\u2758\u1800\u65cange\xbb\u2758ar\u0100;l\u2764\u2765\u4028t;\u6993\u0280achmt\u2773\u2776\u277c\u2785\u2787r\xf2\u08a8orne\xf2\u1d8car\u0100;d\u0f98\u2783;\u696d;\u600eri;\u62bf\u0300achiqt\u2798\u279d\u0a40\u27a2\u27ae\u27bbquo;\u6039r;\uc000\ud835\udcc1m\u0180;eg\u09b2\u27aa\u27ac;\u6a8d;\u6a8f\u0100bu\u252a\u27b3o\u0100;r\u0e1f\u27b9;\u601arok;\u4142\u8400<;cdhilqr\u082b\u27d2\u2639\u27dc\u27e0\u27e5\u27ea\u27f0\u0100ci\u27d7\u27d9;\u6aa6r;\u6a79re\xe5\u25f2mes;\u62c9arr;\u6976uest;\u6a7b\u0100Pi\u27f5\u27f9ar;\u6996\u0180;ef\u2800\u092d\u181b\u65c3r\u0100du\u2807\u280dshar;\u694ahar;\u6966\u0100en\u2817\u2821rtneqq;\uc000\u2268\ufe00\xc5\u281e\u0700Dacdefhilnopsu\u2840\u2845\u2882\u288e\u2893\u28a0\u28a5\u28a8\u28da\u28e2\u28e4\u0a83\u28f3\u2902Dot;\u623a\u0200clpr\u284e\u2852\u2863\u287dr\u803b\xaf\u40af\u0100et\u2857\u2859;\u6642\u0100;e\u285e\u285f\u6720se\xbb\u285f\u0100;s\u103b\u2868to\u0200;dlu\u103b\u2873\u2877\u287bow\xee\u048cef\xf4\u090f\xf0\u13d1ker;\u65ae\u0100oy\u2887\u288cmma;\u6a29;\u443cash;\u6014asuredangle\xbb\u1626r;\uc000\ud835\udd2ao;\u6127\u0180cdn\u28af\u28b4\u28c9ro\u803b\xb5\u40b5\u0200;acd\u1464\u28bd\u28c0\u28c4s\xf4\u16a7ir;\u6af0ot\u80bb\xb7\u01b5us\u0180;bd\u28d2\u1903\u28d3\u6212\u0100;u\u1d3c\u28d8;\u6a2a\u0163\u28de\u28e1p;\u6adb\xf2\u2212\xf0\u0a81\u0100dp\u28e9\u28eeels;\u62a7f;\uc000\ud835\udd5e\u0100ct\u28f8\u28fdr;\uc000\ud835\udcc2pos\xbb\u159d\u0180;lm\u2909\u290a\u290d\u43bctimap;\u62b8\u0c00GLRVabcdefghijlmoprstuvw\u2942\u2953\u297e\u2989\u2998\u29da\u29e9\u2a15\u2a1a\u2a58\u2a5d\u2a83\u2a95\u2aa4\u2aa8\u2b04\u2b07\u2b44\u2b7f\u2bae\u2c34\u2c67\u2c7c\u2ce9\u0100gt\u2947\u294b;\uc000\u22d9\u0338\u0100;v\u2950\u0bcf\uc000\u226b\u20d2\u0180elt\u295a\u2972\u2976ft\u0100ar\u2961\u2967rrow;\u61cdightarrow;\u61ce;\uc000\u22d8\u0338\u0100;v\u297b\u0c47\uc000\u226a\u20d2ightarrow;\u61cf\u0100Dd\u298e\u2993ash;\u62afash;\u62ae\u0280bcnpt\u29a3\u29a7\u29ac\u29b1\u29ccla\xbb\u02deute;\u4144g;\uc000\u2220\u20d2\u0280;Eiop\u0d84\u29bc\u29c0\u29c5\u29c8;\uc000\u2a70\u0338d;\uc000\u224b\u0338s;\u4149ro\xf8\u0d84ur\u0100;a\u29d3\u29d4\u666el\u0100;s\u29d3\u0b38\u01f3\u29df\0\u29e3p\u80bb\xa0\u0b37mp\u0100;e\u0bf9\u0c00\u0280aeouy\u29f4\u29fe\u2a03\u2a10\u2a13\u01f0\u29f9\0\u29fb;\u6a43on;\u4148dil;\u4146ng\u0100;d\u0d7e\u2a0aot;\uc000\u2a6d\u0338p;\u6a42;\u443dash;\u6013\u0380;Aadqsx\u0b92\u2a29\u2a2d\u2a3b\u2a41\u2a45\u2a50rr;\u61d7r\u0100hr\u2a33\u2a36k;\u6924\u0100;o\u13f2\u13f0ot;\uc000\u2250\u0338ui\xf6\u0b63\u0100ei\u2a4a\u2a4ear;\u6928\xed\u0b98ist\u0100;s\u0ba0\u0b9fr;\uc000\ud835\udd2b\u0200Eest\u0bc5\u2a66\u2a79\u2a7c\u0180;qs\u0bbc\u2a6d\u0be1\u0180;qs\u0bbc\u0bc5\u2a74lan\xf4\u0be2i\xed\u0bea\u0100;r\u0bb6\u2a81\xbb\u0bb7\u0180Aap\u2a8a\u2a8d\u2a91r\xf2\u2971rr;\u61aear;\u6af2\u0180;sv\u0f8d\u2a9c\u0f8c\u0100;d\u2aa1\u2aa2\u62fc;\u62facy;\u445a\u0380AEadest\u2ab7\u2aba\u2abe\u2ac2\u2ac5\u2af6\u2af9r\xf2\u2966;\uc000\u2266\u0338rr;\u619ar;\u6025\u0200;fqs\u0c3b\u2ace\u2ae3\u2aeft\u0100ar\u2ad4\u2ad9rro\xf7\u2ac1ightarro\xf7\u2a90\u0180;qs\u0c3b\u2aba\u2aealan\xf4\u0c55\u0100;s\u0c55\u2af4\xbb\u0c36i\xed\u0c5d\u0100;r\u0c35\u2afei\u0100;e\u0c1a\u0c25i\xe4\u0d90\u0100pt\u2b0c\u2b11f;\uc000\ud835\udd5f\u8180\xac;in\u2b19\u2b1a\u2b36\u40acn\u0200;Edv\u0b89\u2b24\u2b28\u2b2e;\uc000\u22f9\u0338ot;\uc000\u22f5\u0338\u01e1\u0b89\u2b33\u2b35;\u62f7;\u62f6i\u0100;v\u0cb8\u2b3c\u01e1\u0cb8\u2b41\u2b43;\u62fe;\u62fd\u0180aor\u2b4b\u2b63\u2b69r\u0200;ast\u0b7b\u2b55\u2b5a\u2b5flle\xec\u0b7bl;\uc000\u2afd\u20e5;\uc000\u2202\u0338lint;\u6a14\u0180;ce\u0c92\u2b70\u2b73u\xe5\u0ca5\u0100;c\u0c98\u2b78\u0100;e\u0c92\u2b7d\xf1\u0c98\u0200Aait\u2b88\u2b8b\u2b9d\u2ba7r\xf2\u2988rr\u0180;cw\u2b94\u2b95\u2b99\u619b;\uc000\u2933\u0338;\uc000\u219d\u0338ghtarrow\xbb\u2b95ri\u0100;e\u0ccb\u0cd6\u0380chimpqu\u2bbd\u2bcd\u2bd9\u2b04\u0b78\u2be4\u2bef\u0200;cer\u0d32\u2bc6\u0d37\u2bc9u\xe5\u0d45;\uc000\ud835\udcc3ort\u026d\u2b05\0\0\u2bd6ar\xe1\u2b56m\u0100;e\u0d6e\u2bdf\u0100;q\u0d74\u0d73su\u0100bp\u2beb\u2bed\xe5\u0cf8\xe5\u0d0b\u0180bcp\u2bf6\u2c11\u2c19\u0200;Ees\u2bff\u2c00\u0d22\u2c04\u6284;\uc000\u2ac5\u0338et\u0100;e\u0d1b\u2c0bq\u0100;q\u0d23\u2c00c\u0100;e\u0d32\u2c17\xf1\u0d38\u0200;Ees\u2c22\u2c23\u0d5f\u2c27\u6285;\uc000\u2ac6\u0338et\u0100;e\u0d58\u2c2eq\u0100;q\u0d60\u2c23\u0200gilr\u2c3d\u2c3f\u2c45\u2c47\xec\u0bd7lde\u803b\xf1\u40f1\xe7\u0c43iangle\u0100lr\u2c52\u2c5ceft\u0100;e\u0c1a\u2c5a\xf1\u0c26ight\u0100;e\u0ccb\u2c65\xf1\u0cd7\u0100;m\u2c6c\u2c6d\u43bd\u0180;es\u2c74\u2c75\u2c79\u4023ro;\u6116p;\u6007\u0480DHadgilrs\u2c8f\u2c94\u2c99\u2c9e\u2ca3\u2cb0\u2cb6\u2cd3\u2ce3ash;\u62adarr;\u6904p;\uc000\u224d\u20d2ash;\u62ac\u0100et\u2ca8\u2cac;\uc000\u2265\u20d2;\uc000>\u20d2nfin;\u69de\u0180Aet\u2cbd\u2cc1\u2cc5rr;\u6902;\uc000\u2264\u20d2\u0100;r\u2cca\u2ccd\uc000<\u20d2ie;\uc000\u22b4\u20d2\u0100At\u2cd8\u2cdcrr;\u6903rie;\uc000\u22b5\u20d2im;\uc000\u223c\u20d2\u0180Aan\u2cf0\u2cf4\u2d02rr;\u61d6r\u0100hr\u2cfa\u2cfdk;\u6923\u0100;o\u13e7\u13e5ear;\u6927\u1253\u1a95\0\0\0\0\0\0\0\0\0\0\0\0\0\u2d2d\0\u2d38\u2d48\u2d60\u2d65\u2d72\u2d84\u1b07\0\0\u2d8d\u2dab\0\u2dc8\u2dce\0\u2ddc\u2e19\u2e2b\u2e3e\u2e43\u0100cs\u2d31\u1a97ute\u803b\xf3\u40f3\u0100iy\u2d3c\u2d45r\u0100;c\u1a9e\u2d42\u803b\xf4\u40f4;\u443e\u0280abios\u1aa0\u2d52\u2d57\u01c8\u2d5alac;\u4151v;\u6a38old;\u69bclig;\u4153\u0100cr\u2d69\u2d6dir;\u69bf;\uc000\ud835\udd2c\u036f\u2d79\0\0\u2d7c\0\u2d82n;\u42dbave\u803b\xf2\u40f2;\u69c1\u0100bm\u2d88\u0df4ar;\u69b5\u0200acit\u2d95\u2d98\u2da5\u2da8r\xf2\u1a80\u0100ir\u2d9d\u2da0r;\u69beoss;\u69bbn\xe5\u0e52;\u69c0\u0180aei\u2db1\u2db5\u2db9cr;\u414dga;\u43c9\u0180cdn\u2dc0\u2dc5\u01cdron;\u43bf;\u69b6pf;\uc000\ud835\udd60\u0180ael\u2dd4\u2dd7\u01d2r;\u69b7rp;\u69b9\u0380;adiosv\u2dea\u2deb\u2dee\u2e08\u2e0d\u2e10\u2e16\u6228r\xf2\u1a86\u0200;efm\u2df7\u2df8\u2e02\u2e05\u6a5dr\u0100;o\u2dfe\u2dff\u6134f\xbb\u2dff\u803b\xaa\u40aa\u803b\xba\u40bagof;\u62b6r;\u6a56lope;\u6a57;\u6a5b\u0180clo\u2e1f\u2e21\u2e27\xf2\u2e01ash\u803b\xf8\u40f8l;\u6298i\u016c\u2e2f\u2e34de\u803b\xf5\u40f5es\u0100;a\u01db\u2e3as;\u6a36ml\u803b\xf6\u40f6bar;\u633d\u0ae1\u2e5e\0\u2e7d\0\u2e80\u2e9d\0\u2ea2\u2eb9\0\0\u2ecb\u0e9c\0\u2f13\0\0\u2f2b\u2fbc\0\u2fc8r\u0200;ast\u0403\u2e67\u2e72\u0e85\u8100\xb6;l\u2e6d\u2e6e\u40b6le\xec\u0403\u0269\u2e78\0\0\u2e7bm;\u6af3;\u6afdy;\u443fr\u0280cimpt\u2e8b\u2e8f\u2e93\u1865\u2e97nt;\u4025od;\u402eil;\u6030enk;\u6031r;\uc000\ud835\udd2d\u0180imo\u2ea8\u2eb0\u2eb4\u0100;v\u2ead\u2eae\u43c6;\u43d5ma\xf4\u0a76ne;\u660e\u0180;tv\u2ebf\u2ec0\u2ec8\u43c0chfork\xbb\u1ffd;\u43d6\u0100au\u2ecf\u2edfn\u0100ck\u2ed5\u2eddk\u0100;h\u21f4\u2edb;\u610e\xf6\u21f4s\u0480;abcdemst\u2ef3\u2ef4\u1908\u2ef9\u2efd\u2f04\u2f06\u2f0a\u2f0e\u402bcir;\u6a23ir;\u6a22\u0100ou\u1d40\u2f02;\u6a25;\u6a72n\u80bb\xb1\u0e9dim;\u6a26wo;\u6a27\u0180ipu\u2f19\u2f20\u2f25ntint;\u6a15f;\uc000\ud835\udd61nd\u803b\xa3\u40a3\u0500;Eaceinosu\u0ec8\u2f3f\u2f41\u2f44\u2f47\u2f81\u2f89\u2f92\u2f7e\u2fb6;\u6ab3p;\u6ab7u\xe5\u0ed9\u0100;c\u0ece\u2f4c\u0300;acens\u0ec8\u2f59\u2f5f\u2f66\u2f68\u2f7eppro\xf8\u2f43urlye\xf1\u0ed9\xf1\u0ece\u0180aes\u2f6f\u2f76\u2f7approx;\u6ab9qq;\u6ab5im;\u62e8i\xed\u0edfme\u0100;s\u2f88\u0eae\u6032\u0180Eas\u2f78\u2f90\u2f7a\xf0\u2f75\u0180dfp\u0eec\u2f99\u2faf\u0180als\u2fa0\u2fa5\u2faalar;\u632eine;\u6312urf;\u6313\u0100;t\u0efb\u2fb4\xef\u0efbrel;\u62b0\u0100ci\u2fc0\u2fc5r;\uc000\ud835\udcc5;\u43c8ncsp;\u6008\u0300fiopsu\u2fda\u22e2\u2fdf\u2fe5\u2feb\u2ff1r;\uc000\ud835\udd2epf;\uc000\ud835\udd62rime;\u6057cr;\uc000\ud835\udcc6\u0180aeo\u2ff8\u3009\u3013t\u0100ei\u2ffe\u3005rnion\xf3\u06b0nt;\u6a16st\u0100;e\u3010\u3011\u403f\xf1\u1f19\xf4\u0f14\u0a80ABHabcdefhilmnoprstux\u3040\u3051\u3055\u3059\u30e0\u310e\u312b\u3147\u3162\u3172\u318e\u3206\u3215\u3224\u3229\u3258\u326e\u3272\u3290\u32b0\u32b7\u0180art\u3047\u304a\u304cr\xf2\u10b3\xf2\u03ddail;\u691car\xf2\u1c65ar;\u6964\u0380cdenqrt\u3068\u3075\u3078\u307f\u308f\u3094\u30cc\u0100eu\u306d\u3071;\uc000\u223d\u0331te;\u4155i\xe3\u116emptyv;\u69b3g\u0200;del\u0fd1\u3089\u308b\u308d;\u6992;\u69a5\xe5\u0fd1uo\u803b\xbb\u40bbr\u0580;abcfhlpstw\u0fdc\u30ac\u30af\u30b7\u30b9\u30bc\u30be\u30c0\u30c3\u30c7\u30cap;\u6975\u0100;f\u0fe0\u30b4s;\u6920;\u6933s;\u691e\xeb\u225d\xf0\u272el;\u6945im;\u6974l;\u61a3;\u619d\u0100ai\u30d1\u30d5il;\u691ao\u0100;n\u30db\u30dc\u6236al\xf3\u0f1e\u0180abr\u30e7\u30ea\u30eer\xf2\u17e5rk;\u6773\u0100ak\u30f3\u30fdc\u0100ek\u30f9\u30fb;\u407d;\u405d\u0100es\u3102\u3104;\u698cl\u0100du\u310a\u310c;\u698e;\u6990\u0200aeuy\u3117\u311c\u3127\u3129ron;\u4159\u0100di\u3121\u3125il;\u4157\xec\u0ff2\xe2\u30fa;\u4440\u0200clqs\u3134\u3137\u313d\u3144a;\u6937dhar;\u6969uo\u0100;r\u020e\u020dh;\u61b3\u0180acg\u314e\u315f\u0f44l\u0200;ips\u0f78\u3158\u315b\u109cn\xe5\u10bbar\xf4\u0fa9t;\u65ad\u0180ilr\u3169\u1023\u316esht;\u697d;\uc000\ud835\udd2f\u0100ao\u3177\u3186r\u0100du\u317d\u317f\xbb\u047b\u0100;l\u1091\u3184;\u696c\u0100;v\u318b\u318c\u43c1;\u43f1\u0180gns\u3195\u31f9\u31fcht\u0300ahlrst\u31a4\u31b0\u31c2\u31d8\u31e4\u31eerrow\u0100;t\u0fdc\u31ada\xe9\u30c8arpoon\u0100du\u31bb\u31bfow\xee\u317ep\xbb\u1092eft\u0100ah\u31ca\u31d0rrow\xf3\u0feaarpoon\xf3\u0551ightarrows;\u61c9quigarro\xf7\u30cbhreetimes;\u62ccg;\u42daingdotse\xf1\u1f32\u0180ahm\u320d\u3210\u3213r\xf2\u0feaa\xf2\u0551;\u600foust\u0100;a\u321e\u321f\u63b1che\xbb\u321fmid;\u6aee\u0200abpt\u3232\u323d\u3240\u3252\u0100nr\u3237\u323ag;\u67edr;\u61fer\xeb\u1003\u0180afl\u3247\u324a\u324er;\u6986;\uc000\ud835\udd63us;\u6a2eimes;\u6a35\u0100ap\u325d\u3267r\u0100;g\u3263\u3264\u4029t;\u6994olint;\u6a12ar\xf2\u31e3\u0200achq\u327b\u3280\u10bc\u3285quo;\u603ar;\uc000\ud835\udcc7\u0100bu\u30fb\u328ao\u0100;r\u0214\u0213\u0180hir\u3297\u329b\u32a0re\xe5\u31f8mes;\u62cai\u0200;efl\u32aa\u1059\u1821\u32ab\u65b9tri;\u69celuhar;\u6968;\u611e\u0d61\u32d5\u32db\u32df\u332c\u3338\u3371\0\u337a\u33a4\0\0\u33ec\u33f0\0\u3428\u3448\u345a\u34ad\u34b1\u34ca\u34f1\0\u3616\0\0\u3633cute;\u415bqu\xef\u27ba\u0500;Eaceinpsy\u11ed\u32f3\u32f5\u32ff\u3302\u330b\u330f\u331f\u3326\u3329;\u6ab4\u01f0\u32fa\0\u32fc;\u6ab8on;\u4161u\xe5\u11fe\u0100;d\u11f3\u3307il;\u415frc;\u415d\u0180Eas\u3316\u3318\u331b;\u6ab6p;\u6abaim;\u62e9olint;\u6a13i\xed\u1204;\u4441ot\u0180;be\u3334\u1d47\u3335\u62c5;\u6a66\u0380Aacmstx\u3346\u334a\u3357\u335b\u335e\u3363\u336drr;\u61d8r\u0100hr\u3350\u3352\xeb\u2228\u0100;o\u0a36\u0a34t\u803b\xa7\u40a7i;\u403bwar;\u6929m\u0100in\u3369\xf0nu\xf3\xf1t;\u6736r\u0100;o\u3376\u2055\uc000\ud835\udd30\u0200acoy\u3382\u3386\u3391\u33a0rp;\u666f\u0100hy\u338b\u338fcy;\u4449;\u4448rt\u026d\u3399\0\0\u339ci\xe4\u1464ara\xec\u2e6f\u803b\xad\u40ad\u0100gm\u33a8\u33b4ma\u0180;fv\u33b1\u33b2\u33b2\u43c3;\u43c2\u0400;deglnpr\u12ab\u33c5\u33c9\u33ce\u33d6\u33de\u33e1\u33e6ot;\u6a6a\u0100;q\u12b1\u12b0\u0100;E\u33d3\u33d4\u6a9e;\u6aa0\u0100;E\u33db\u33dc\u6a9d;\u6a9fe;\u6246lus;\u6a24arr;\u6972ar\xf2\u113d\u0200aeit\u33f8\u3408\u340f\u3417\u0100ls\u33fd\u3404lsetm\xe9\u336ahp;\u6a33parsl;\u69e4\u0100dl\u1463\u3414e;\u6323\u0100;e\u341c\u341d\u6aaa\u0100;s\u3422\u3423\u6aac;\uc000\u2aac\ufe00\u0180flp\u342e\u3433\u3442tcy;\u444c\u0100;b\u3438\u3439\u402f\u0100;a\u343e\u343f\u69c4r;\u633ff;\uc000\ud835\udd64a\u0100dr\u344d\u0402es\u0100;u\u3454\u3455\u6660it\xbb\u3455\u0180csu\u3460\u3479\u349f\u0100au\u3465\u346fp\u0100;s\u1188\u346b;\uc000\u2293\ufe00p\u0100;s\u11b4\u3475;\uc000\u2294\ufe00u\u0100bp\u347f\u348f\u0180;es\u1197\u119c\u3486et\u0100;e\u1197\u348d\xf1\u119d\u0180;es\u11a8\u11ad\u3496et\u0100;e\u11a8\u349d\xf1\u11ae\u0180;af\u117b\u34a6\u05b0r\u0165\u34ab\u05b1\xbb\u117car\xf2\u1148\u0200cemt\u34b9\u34be\u34c2\u34c5r;\uc000\ud835\udcc8tm\xee\xf1i\xec\u3415ar\xe6\u11be\u0100ar\u34ce\u34d5r\u0100;f\u34d4\u17bf\u6606\u0100an\u34da\u34edight\u0100ep\u34e3\u34eapsilo\xee\u1ee0h\xe9\u2eafs\xbb\u2852\u0280bcmnp\u34fb\u355e\u1209\u358b\u358e\u0480;Edemnprs\u350e\u350f\u3511\u3515\u351e\u3523\u352c\u3531\u3536\u6282;\u6ac5ot;\u6abd\u0100;d\u11da\u351aot;\u6ac3ult;\u6ac1\u0100Ee\u3528\u352a;\u6acb;\u628alus;\u6abfarr;\u6979\u0180eiu\u353d\u3552\u3555t\u0180;en\u350e\u3545\u354bq\u0100;q\u11da\u350feq\u0100;q\u352b\u3528m;\u6ac7\u0100bp\u355a\u355c;\u6ad5;\u6ad3c\u0300;acens\u11ed\u356c\u3572\u3579\u357b\u3326ppro\xf8\u32faurlye\xf1\u11fe\xf1\u11f3\u0180aes\u3582\u3588\u331bppro\xf8\u331aq\xf1\u3317g;\u666a\u0680123;Edehlmnps\u35a9\u35ac\u35af\u121c\u35b2\u35b4\u35c0\u35c9\u35d5\u35da\u35df\u35e8\u35ed\u803b\xb9\u40b9\u803b\xb2\u40b2\u803b\xb3\u40b3;\u6ac6\u0100os\u35b9\u35bct;\u6abeub;\u6ad8\u0100;d\u1222\u35c5ot;\u6ac4s\u0100ou\u35cf\u35d2l;\u67c9b;\u6ad7arr;\u697bult;\u6ac2\u0100Ee\u35e4\u35e6;\u6acc;\u628blus;\u6ac0\u0180eiu\u35f4\u3609\u360ct\u0180;en\u121c\u35fc\u3602q\u0100;q\u1222\u35b2eq\u0100;q\u35e7\u35e4m;\u6ac8\u0100bp\u3611\u3613;\u6ad4;\u6ad6\u0180Aan\u361c\u3620\u362drr;\u61d9r\u0100hr\u3626\u3628\xeb\u222e\u0100;o\u0a2b\u0a29war;\u692alig\u803b\xdf\u40df\u0be1\u3651\u365d\u3660\u12ce\u3673\u3679\0\u367e\u36c2\0\0\0\0\0\u36db\u3703\0\u3709\u376c\0\0\0\u3787\u0272\u3656\0\0\u365bget;\u6316;\u43c4r\xeb\u0e5f\u0180aey\u3666\u366b\u3670ron;\u4165dil;\u4163;\u4442lrec;\u6315r;\uc000\ud835\udd31\u0200eiko\u3686\u369d\u36b5\u36bc\u01f2\u368b\0\u3691e\u01004f\u1284\u1281a\u0180;sv\u3698\u3699\u369b\u43b8ym;\u43d1\u0100cn\u36a2\u36b2k\u0100as\u36a8\u36aeppro\xf8\u12c1im\xbb\u12acs\xf0\u129e\u0100as\u36ba\u36ae\xf0\u12c1rn\u803b\xfe\u40fe\u01ec\u031f\u36c6\u22e7es\u8180\xd7;bd\u36cf\u36d0\u36d8\u40d7\u0100;a\u190f\u36d5r;\u6a31;\u6a30\u0180eps\u36e1\u36e3\u3700\xe1\u2a4d\u0200;bcf\u0486\u36ec\u36f0\u36f4ot;\u6336ir;\u6af1\u0100;o\u36f9\u36fc\uc000\ud835\udd65rk;\u6ada\xe1\u3362rime;\u6034\u0180aip\u370f\u3712\u3764d\xe5\u1248\u0380adempst\u3721\u374d\u3740\u3751\u3757\u375c\u375fngle\u0280;dlqr\u3730\u3731\u3736\u3740\u3742\u65b5own\xbb\u1dbbeft\u0100;e\u2800\u373e\xf1\u092e;\u625cight\u0100;e\u32aa\u374b\xf1\u105aot;\u65ecinus;\u6a3alus;\u6a39b;\u69cdime;\u6a3bezium;\u63e2\u0180cht\u3772\u377d\u3781\u0100ry\u3777\u377b;\uc000\ud835\udcc9;\u4446cy;\u445brok;\u4167\u0100io\u378b\u378ex\xf4\u1777head\u0100lr\u3797\u37a0eftarro\xf7\u084fightarrow\xbb\u0f5d\u0900AHabcdfghlmoprstuw\u37d0\u37d3\u37d7\u37e4\u37f0\u37fc\u380e\u381c\u3823\u3834\u3851\u385d\u386b\u38a9\u38cc\u38d2\u38ea\u38f6r\xf2\u03edar;\u6963\u0100cr\u37dc\u37e2ute\u803b\xfa\u40fa\xf2\u1150r\u01e3\u37ea\0\u37edy;\u445eve;\u416d\u0100iy\u37f5\u37farc\u803b\xfb\u40fb;\u4443\u0180abh\u3803\u3806\u380br\xf2\u13adlac;\u4171a\xf2\u13c3\u0100ir\u3813\u3818sht;\u697e;\uc000\ud835\udd32rave\u803b\xf9\u40f9\u0161\u3827\u3831r\u0100lr\u382c\u382e\xbb\u0957\xbb\u1083lk;\u6580\u0100ct\u3839\u384d\u026f\u383f\0\0\u384arn\u0100;e\u3845\u3846\u631cr\xbb\u3846op;\u630fri;\u65f8\u0100al\u3856\u385acr;\u416b\u80bb\xa8\u0349\u0100gp\u3862\u3866on;\u4173f;\uc000\ud835\udd66\u0300adhlsu\u114b\u3878\u387d\u1372\u3891\u38a0own\xe1\u13b3arpoon\u0100lr\u3888\u388cef\xf4\u382digh\xf4\u382fi\u0180;hl\u3899\u389a\u389c\u43c5\xbb\u13faon\xbb\u389aparrows;\u61c8\u0180cit\u38b0\u38c4\u38c8\u026f\u38b6\0\0\u38c1rn\u0100;e\u38bc\u38bd\u631dr\xbb\u38bdop;\u630eng;\u416fri;\u65f9cr;\uc000\ud835\udcca\u0180dir\u38d9\u38dd\u38e2ot;\u62f0lde;\u4169i\u0100;f\u3730\u38e8\xbb\u1813\u0100am\u38ef\u38f2r\xf2\u38a8l\u803b\xfc\u40fcangle;\u69a7\u0780ABDacdeflnoprsz\u391c\u391f\u3929\u392d\u39b5\u39b8\u39bd\u39df\u39e4\u39e8\u39f3\u39f9\u39fd\u3a01\u3a20r\xf2\u03f7ar\u0100;v\u3926\u3927\u6ae8;\u6ae9as\xe8\u03e1\u0100nr\u3932\u3937grt;\u699c\u0380eknprst\u34e3\u3946\u394b\u3952\u395d\u3964\u3996app\xe1\u2415othin\xe7\u1e96\u0180hir\u34eb\u2ec8\u3959op\xf4\u2fb5\u0100;h\u13b7\u3962\xef\u318d\u0100iu\u3969\u396dgm\xe1\u33b3\u0100bp\u3972\u3984setneq\u0100;q\u397d\u3980\uc000\u228a\ufe00;\uc000\u2acb\ufe00setneq\u0100;q\u398f\u3992\uc000\u228b\ufe00;\uc000\u2acc\ufe00\u0100hr\u399b\u399fet\xe1\u369ciangle\u0100lr\u39aa\u39afeft\xbb\u0925ight\xbb\u1051y;\u4432ash\xbb\u1036\u0180elr\u39c4\u39d2\u39d7\u0180;be\u2dea\u39cb\u39cfar;\u62bbq;\u625alip;\u62ee\u0100bt\u39dc\u1468a\xf2\u1469r;\uc000\ud835\udd33tr\xe9\u39aesu\u0100bp\u39ef\u39f1\xbb\u0d1c\xbb\u0d59pf;\uc000\ud835\udd67ro\xf0\u0efbtr\xe9\u39b4\u0100cu\u3a06\u3a0br;\uc000\ud835\udccb\u0100bp\u3a10\u3a18n\u0100Ee\u3980\u3a16\xbb\u397en\u0100Ee\u3992\u3a1e\xbb\u3990igzag;\u699a\u0380cefoprs\u3a36\u3a3b\u3a56\u3a5b\u3a54\u3a61\u3a6airc;\u4175\u0100di\u3a40\u3a51\u0100bg\u3a45\u3a49ar;\u6a5fe\u0100;q\u15fa\u3a4f;\u6259erp;\u6118r;\uc000\ud835\udd34pf;\uc000\ud835\udd68\u0100;e\u1479\u3a66at\xe8\u1479cr;\uc000\ud835\udccc\u0ae3\u178e\u3a87\0\u3a8b\0\u3a90\u3a9b\0\0\u3a9d\u3aa8\u3aab\u3aaf\0\0\u3ac3\u3ace\0\u3ad8\u17dc\u17dftr\xe9\u17d1r;\uc000\ud835\udd35\u0100Aa\u3a94\u3a97r\xf2\u03c3r\xf2\u09f6;\u43be\u0100Aa\u3aa1\u3aa4r\xf2\u03b8r\xf2\u09eba\xf0\u2713is;\u62fb\u0180dpt\u17a4\u3ab5\u3abe\u0100fl\u3aba\u17a9;\uc000\ud835\udd69im\xe5\u17b2\u0100Aa\u3ac7\u3acar\xf2\u03cer\xf2\u0a01\u0100cq\u3ad2\u17b8r;\uc000\ud835\udccd\u0100pt\u17d6\u3adcr\xe9\u17d4\u0400acefiosu\u3af0\u3afd\u3b08\u3b0c\u3b11\u3b15\u3b1b\u3b21c\u0100uy\u3af6\u3afbte\u803b\xfd\u40fd;\u444f\u0100iy\u3b02\u3b06rc;\u4177;\u444bn\u803b\xa5\u40a5r;\uc000\ud835\udd36cy;\u4457pf;\uc000\ud835\udd6acr;\uc000\ud835\udcce\u0100cm\u3b26\u3b29y;\u444el\u803b\xff\u40ff\u0500acdefhiosw\u3b42\u3b48\u3b54\u3b58\u3b64\u3b69\u3b6d\u3b74\u3b7a\u3b80cute;\u417a\u0100ay\u3b4d\u3b52ron;\u417e;\u4437ot;\u417c\u0100et\u3b5d\u3b61tr\xe6\u155fa;\u43b6r;\uc000\ud835\udd37cy;\u4436grarr;\u61ddpf;\uc000\ud835\udd6bcr;\uc000\ud835\udccf\u0100jn\u3b85\u3b87;\u600dj;\u600c"
	    .split("")
	    .map((c) => c.charCodeAt(0)));

	// Adapted from https://github.com/mathiasbynens/he/blob/36afe179392226cf1b6ccdb16ebbb7a5a844d93a/src/he.js#L106-L134
	var _a;
	const decodeMap = new Map([
	    [0, 65533],
	    // C1 Unicode control character reference replacements
	    [128, 8364],
	    [130, 8218],
	    [131, 402],
	    [132, 8222],
	    [133, 8230],
	    [134, 8224],
	    [135, 8225],
	    [136, 710],
	    [137, 8240],
	    [138, 352],
	    [139, 8249],
	    [140, 338],
	    [142, 381],
	    [145, 8216],
	    [146, 8217],
	    [147, 8220],
	    [148, 8221],
	    [149, 8226],
	    [150, 8211],
	    [151, 8212],
	    [152, 732],
	    [153, 8482],
	    [154, 353],
	    [155, 8250],
	    [156, 339],
	    [158, 382],
	    [159, 376],
	]);
	/**
	 * Polyfill for `String.fromCodePoint`. It is used to create a string from a Unicode code point.
	 */
	const fromCodePoint = 
	// eslint-disable-next-line @typescript-eslint/no-unnecessary-condition, n/no-unsupported-features/es-builtins
	(_a = String.fromCodePoint) !== null && _a !== void 0 ? _a : function (codePoint) {
	    let output = "";
	    if (codePoint > 65535) {
	        codePoint -= 65536;
	        output += String.fromCharCode(((codePoint >>> 10) & 1023) | 55296);
	        codePoint = 56320 | (codePoint & 1023);
	    }
	    output += String.fromCharCode(codePoint);
	    return output;
	};
	/**
	 * Replace the given code point with a replacement character if it is a
	 * surrogate or is outside the valid range. Otherwise return the code
	 * point unchanged.
	 */
	function replaceCodePoint(codePoint) {
	    var _a;
	    if ((codePoint >= 55296 && codePoint <= 57343) ||
	        codePoint > 1114111) {
	        return 65533;
	    }
	    return (_a = decodeMap.get(codePoint)) !== null && _a !== void 0 ? _a : codePoint;
	}

	var CharCodes;
	(function (CharCodes) {
	    CharCodes[CharCodes["NUM"] = 35] = "NUM";
	    CharCodes[CharCodes["SEMI"] = 59] = "SEMI";
	    CharCodes[CharCodes["EQUALS"] = 61] = "EQUALS";
	    CharCodes[CharCodes["ZERO"] = 48] = "ZERO";
	    CharCodes[CharCodes["NINE"] = 57] = "NINE";
	    CharCodes[CharCodes["LOWER_A"] = 97] = "LOWER_A";
	    CharCodes[CharCodes["LOWER_F"] = 102] = "LOWER_F";
	    CharCodes[CharCodes["LOWER_X"] = 120] = "LOWER_X";
	    CharCodes[CharCodes["LOWER_Z"] = 122] = "LOWER_Z";
	    CharCodes[CharCodes["UPPER_A"] = 65] = "UPPER_A";
	    CharCodes[CharCodes["UPPER_F"] = 70] = "UPPER_F";
	    CharCodes[CharCodes["UPPER_Z"] = 90] = "UPPER_Z";
	})(CharCodes || (CharCodes = {}));
	/** Bit that needs to be set to convert an upper case ASCII character to lower case */
	const TO_LOWER_BIT = 32;
	var BinTrieFlags;
	(function (BinTrieFlags) {
	    BinTrieFlags[BinTrieFlags["VALUE_LENGTH"] = 49152] = "VALUE_LENGTH";
	    BinTrieFlags[BinTrieFlags["BRANCH_LENGTH"] = 16256] = "BRANCH_LENGTH";
	    BinTrieFlags[BinTrieFlags["JUMP_TABLE"] = 127] = "JUMP_TABLE";
	})(BinTrieFlags || (BinTrieFlags = {}));
	function isNumber(code) {
	    return code >= CharCodes.ZERO && code <= CharCodes.NINE;
	}
	function isHexadecimalCharacter(code) {
	    return ((code >= CharCodes.UPPER_A && code <= CharCodes.UPPER_F) ||
	        (code >= CharCodes.LOWER_A && code <= CharCodes.LOWER_F));
	}
	function isAsciiAlphaNumeric(code) {
	    return ((code >= CharCodes.UPPER_A && code <= CharCodes.UPPER_Z) ||
	        (code >= CharCodes.LOWER_A && code <= CharCodes.LOWER_Z) ||
	        isNumber(code));
	}
	/**
	 * Checks if the given character is a valid end character for an entity in an attribute.
	 *
	 * Attribute values that aren't terminated properly aren't parsed, and shouldn't lead to a parser error.
	 * See the example in https://html.spec.whatwg.org/multipage/parsing.html#named-character-reference-state
	 */
	function isEntityInAttributeInvalidEnd(code) {
	    return code === CharCodes.EQUALS || isAsciiAlphaNumeric(code);
	}
	var EntityDecoderState;
	(function (EntityDecoderState) {
	    EntityDecoderState[EntityDecoderState["EntityStart"] = 0] = "EntityStart";
	    EntityDecoderState[EntityDecoderState["NumericStart"] = 1] = "NumericStart";
	    EntityDecoderState[EntityDecoderState["NumericDecimal"] = 2] = "NumericDecimal";
	    EntityDecoderState[EntityDecoderState["NumericHex"] = 3] = "NumericHex";
	    EntityDecoderState[EntityDecoderState["NamedEntity"] = 4] = "NamedEntity";
	})(EntityDecoderState || (EntityDecoderState = {}));
	var DecodingMode;
	(function (DecodingMode) {
	    /** Entities in text nodes that can end with any character. */
	    DecodingMode[DecodingMode["Legacy"] = 0] = "Legacy";
	    /** Only allow entities terminated with a semicolon. */
	    DecodingMode[DecodingMode["Strict"] = 1] = "Strict";
	    /** Entities in attributes have limitations on ending characters. */
	    DecodingMode[DecodingMode["Attribute"] = 2] = "Attribute";
	})(DecodingMode || (DecodingMode = {}));
	/**
	 * Token decoder with support of writing partial entities.
	 */
	class EntityDecoder {
	    constructor(
	    /** The tree used to decode entities. */
	    decodeTree, 
	    /**
	     * The function that is called when a codepoint is decoded.
	     *
	     * For multi-byte named entities, this will be called multiple times,
	     * with the second codepoint, and the same `consumed` value.
	     *
	     * @param codepoint The decoded codepoint.
	     * @param consumed The number of bytes consumed by the decoder.
	     */
	    emitCodePoint, 
	    /** An object that is used to produce errors. */
	    errors) {
	        this.decodeTree = decodeTree;
	        this.emitCodePoint = emitCodePoint;
	        this.errors = errors;
	        /** The current state of the decoder. */
	        this.state = EntityDecoderState.EntityStart;
	        /** Characters that were consumed while parsing an entity. */
	        this.consumed = 1;
	        /**
	         * The result of the entity.
	         *
	         * Either the result index of a numeric entity, or the codepoint of a
	         * numeric entity.
	         */
	        this.result = 0;
	        /** The current index in the decode tree. */
	        this.treeIndex = 0;
	        /** The number of characters that were consumed in excess. */
	        this.excess = 1;
	        /** The mode in which the decoder is operating. */
	        this.decodeMode = DecodingMode.Strict;
	    }
	    /** Resets the instance to make it reusable. */
	    startEntity(decodeMode) {
	        this.decodeMode = decodeMode;
	        this.state = EntityDecoderState.EntityStart;
	        this.result = 0;
	        this.treeIndex = 0;
	        this.excess = 1;
	        this.consumed = 1;
	    }
	    /**
	     * Write an entity to the decoder. This can be called multiple times with partial entities.
	     * If the entity is incomplete, the decoder will return -1.
	     *
	     * Mirrors the implementation of `getDecoder`, but with the ability to stop decoding if the
	     * entity is incomplete, and resume when the next string is written.
	     *
	     * @param input The string containing the entity (or a continuation of the entity).
	     * @param offset The offset at which the entity begins. Should be 0 if this is not the first call.
	     * @returns The number of characters that were consumed, or -1 if the entity is incomplete.
	     */
	    write(input, offset) {
	        switch (this.state) {
	            case EntityDecoderState.EntityStart: {
	                if (input.charCodeAt(offset) === CharCodes.NUM) {
	                    this.state = EntityDecoderState.NumericStart;
	                    this.consumed += 1;
	                    return this.stateNumericStart(input, offset + 1);
	                }
	                this.state = EntityDecoderState.NamedEntity;
	                return this.stateNamedEntity(input, offset);
	            }
	            case EntityDecoderState.NumericStart: {
	                return this.stateNumericStart(input, offset);
	            }
	            case EntityDecoderState.NumericDecimal: {
	                return this.stateNumericDecimal(input, offset);
	            }
	            case EntityDecoderState.NumericHex: {
	                return this.stateNumericHex(input, offset);
	            }
	            case EntityDecoderState.NamedEntity: {
	                return this.stateNamedEntity(input, offset);
	            }
	        }
	    }
	    /**
	     * Switches between the numeric decimal and hexadecimal states.
	     *
	     * Equivalent to the `Numeric character reference state` in the HTML spec.
	     *
	     * @param input The string containing the entity (or a continuation of the entity).
	     * @param offset The current offset.
	     * @returns The number of characters that were consumed, or -1 if the entity is incomplete.
	     */
	    stateNumericStart(input, offset) {
	        if (offset >= input.length) {
	            return -1;
	        }
	        if ((input.charCodeAt(offset) | TO_LOWER_BIT) === CharCodes.LOWER_X) {
	            this.state = EntityDecoderState.NumericHex;
	            this.consumed += 1;
	            return this.stateNumericHex(input, offset + 1);
	        }
	        this.state = EntityDecoderState.NumericDecimal;
	        return this.stateNumericDecimal(input, offset);
	    }
	    addToNumericResult(input, start, end, base) {
	        if (start !== end) {
	            const digitCount = end - start;
	            this.result =
	                this.result * Math.pow(base, digitCount) +
	                    Number.parseInt(input.substr(start, digitCount), base);
	            this.consumed += digitCount;
	        }
	    }
	    /**
	     * Parses a hexadecimal numeric entity.
	     *
	     * Equivalent to the `Hexademical character reference state` in the HTML spec.
	     *
	     * @param input The string containing the entity (or a continuation of the entity).
	     * @param offset The current offset.
	     * @returns The number of characters that were consumed, or -1 if the entity is incomplete.
	     */
	    stateNumericHex(input, offset) {
	        const startIndex = offset;
	        while (offset < input.length) {
	            const char = input.charCodeAt(offset);
	            if (isNumber(char) || isHexadecimalCharacter(char)) {
	                offset += 1;
	            }
	            else {
	                this.addToNumericResult(input, startIndex, offset, 16);
	                return this.emitNumericEntity(char, 3);
	            }
	        }
	        this.addToNumericResult(input, startIndex, offset, 16);
	        return -1;
	    }
	    /**
	     * Parses a decimal numeric entity.
	     *
	     * Equivalent to the `Decimal character reference state` in the HTML spec.
	     *
	     * @param input The string containing the entity (or a continuation of the entity).
	     * @param offset The current offset.
	     * @returns The number of characters that were consumed, or -1 if the entity is incomplete.
	     */
	    stateNumericDecimal(input, offset) {
	        const startIndex = offset;
	        while (offset < input.length) {
	            const char = input.charCodeAt(offset);
	            if (isNumber(char)) {
	                offset += 1;
	            }
	            else {
	                this.addToNumericResult(input, startIndex, offset, 10);
	                return this.emitNumericEntity(char, 2);
	            }
	        }
	        this.addToNumericResult(input, startIndex, offset, 10);
	        return -1;
	    }
	    /**
	     * Validate and emit a numeric entity.
	     *
	     * Implements the logic from the `Hexademical character reference start
	     * state` and `Numeric character reference end state` in the HTML spec.
	     *
	     * @param lastCp The last code point of the entity. Used to see if the
	     *               entity was terminated with a semicolon.
	     * @param expectedLength The minimum number of characters that should be
	     *                       consumed. Used to validate that at least one digit
	     *                       was consumed.
	     * @returns The number of characters that were consumed.
	     */
	    emitNumericEntity(lastCp, expectedLength) {
	        var _a;
	        // Ensure we consumed at least one digit.
	        if (this.consumed <= expectedLength) {
	            (_a = this.errors) === null || _a === void 0 ? void 0 : _a.absenceOfDigitsInNumericCharacterReference(this.consumed);
	            return 0;
	        }
	        // Figure out if this is a legit end of the entity
	        if (lastCp === CharCodes.SEMI) {
	            this.consumed += 1;
	        }
	        else if (this.decodeMode === DecodingMode.Strict) {
	            return 0;
	        }
	        this.emitCodePoint(replaceCodePoint(this.result), this.consumed);
	        if (this.errors) {
	            if (lastCp !== CharCodes.SEMI) {
	                this.errors.missingSemicolonAfterCharacterReference();
	            }
	            this.errors.validateNumericCharacterReference(this.result);
	        }
	        return this.consumed;
	    }
	    /**
	     * Parses a named entity.
	     *
	     * Equivalent to the `Named character reference state` in the HTML spec.
	     *
	     * @param input The string containing the entity (or a continuation of the entity).
	     * @param offset The current offset.
	     * @returns The number of characters that were consumed, or -1 if the entity is incomplete.
	     */
	    stateNamedEntity(input, offset) {
	        const { decodeTree } = this;
	        let current = decodeTree[this.treeIndex];
	        // The mask is the number of bytes of the value, including the current byte.
	        let valueLength = (current & BinTrieFlags.VALUE_LENGTH) >> 14;
	        for (; offset < input.length; offset++, this.excess++) {
	            const char = input.charCodeAt(offset);
	            this.treeIndex = determineBranch(decodeTree, current, this.treeIndex + Math.max(1, valueLength), char);
	            if (this.treeIndex < 0) {
	                return this.result === 0 ||
	                    // If we are parsing an attribute
	                    (this.decodeMode === DecodingMode.Attribute &&
	                        // We shouldn't have consumed any characters after the entity,
	                        (valueLength === 0 ||
	                            // And there should be no invalid characters.
	                            isEntityInAttributeInvalidEnd(char)))
	                    ? 0
	                    : this.emitNotTerminatedNamedEntity();
	            }
	            current = decodeTree[this.treeIndex];
	            valueLength = (current & BinTrieFlags.VALUE_LENGTH) >> 14;
	            // If the branch is a value, store it and continue
	            if (valueLength !== 0) {
	                // If the entity is terminated by a semicolon, we are done.
	                if (char === CharCodes.SEMI) {
	                    return this.emitNamedEntityData(this.treeIndex, valueLength, this.consumed + this.excess);
	                }
	                // If we encounter a non-terminated (legacy) entity while parsing strictly, then ignore it.
	                if (this.decodeMode !== DecodingMode.Strict) {
	                    this.result = this.treeIndex;
	                    this.consumed += this.excess;
	                    this.excess = 0;
	                }
	            }
	        }
	        return -1;
	    }
	    /**
	     * Emit a named entity that was not terminated with a semicolon.
	     *
	     * @returns The number of characters consumed.
	     */
	    emitNotTerminatedNamedEntity() {
	        var _a;
	        const { result, decodeTree } = this;
	        const valueLength = (decodeTree[result] & BinTrieFlags.VALUE_LENGTH) >> 14;
	        this.emitNamedEntityData(result, valueLength, this.consumed);
	        (_a = this.errors) === null || _a === void 0 ? void 0 : _a.missingSemicolonAfterCharacterReference();
	        return this.consumed;
	    }
	    /**
	     * Emit a named entity.
	     *
	     * @param result The index of the entity in the decode tree.
	     * @param valueLength The number of bytes in the entity.
	     * @param consumed The number of characters consumed.
	     *
	     * @returns The number of characters consumed.
	     */
	    emitNamedEntityData(result, valueLength, consumed) {
	        const { decodeTree } = this;
	        this.emitCodePoint(valueLength === 1
	            ? decodeTree[result] & ~BinTrieFlags.VALUE_LENGTH
	            : decodeTree[result + 1], consumed);
	        if (valueLength === 3) {
	            // For multi-byte values, we need to emit the second byte.
	            this.emitCodePoint(decodeTree[result + 2], consumed);
	        }
	        return consumed;
	    }
	    /**
	     * Signal to the parser that the end of the input was reached.
	     *
	     * Remaining data will be emitted and relevant errors will be produced.
	     *
	     * @returns The number of characters consumed.
	     */
	    end() {
	        var _a;
	        switch (this.state) {
	            case EntityDecoderState.NamedEntity: {
	                // Emit a named entity if we have one.
	                return this.result !== 0 &&
	                    (this.decodeMode !== DecodingMode.Attribute ||
	                        this.result === this.treeIndex)
	                    ? this.emitNotTerminatedNamedEntity()
	                    : 0;
	            }
	            // Otherwise, emit a numeric entity if we have one.
	            case EntityDecoderState.NumericDecimal: {
	                return this.emitNumericEntity(0, 2);
	            }
	            case EntityDecoderState.NumericHex: {
	                return this.emitNumericEntity(0, 3);
	            }
	            case EntityDecoderState.NumericStart: {
	                (_a = this.errors) === null || _a === void 0 ? void 0 : _a.absenceOfDigitsInNumericCharacterReference(this.consumed);
	                return 0;
	            }
	            case EntityDecoderState.EntityStart: {
	                // Return 0 if we have no entity.
	                return 0;
	            }
	        }
	    }
	}
	/**
	 * Creates a function that decodes entities in a string.
	 *
	 * @param decodeTree The decode tree.
	 * @returns A function that decodes entities in a string.
	 */
	function getDecoder(decodeTree) {
	    let returnValue = "";
	    const decoder = new EntityDecoder(decodeTree, (data) => (returnValue += fromCodePoint(data)));
	    return function decodeWithTrie(input, decodeMode) {
	        let lastIndex = 0;
	        let offset = 0;
	        while ((offset = input.indexOf("&", offset)) >= 0) {
	            returnValue += input.slice(lastIndex, offset);
	            decoder.startEntity(decodeMode);
	            const length = decoder.write(input, 
	            // Skip the "&"
	            offset + 1);
	            if (length < 0) {
	                lastIndex = offset + decoder.end();
	                break;
	            }
	            lastIndex = offset + length;
	            // If `length` is 0, skip the current `&` and continue.
	            offset = length === 0 ? lastIndex + 1 : lastIndex;
	        }
	        const result = returnValue + input.slice(lastIndex);
	        // Make sure we don't keep a reference to the final string.
	        returnValue = "";
	        return result;
	    };
	}
	/**
	 * Determines the branch of the current node that is taken given the current
	 * character. This function is used to traverse the trie.
	 *
	 * @param decodeTree The trie.
	 * @param current The current node.
	 * @param nodeIdx The index right after the current node and its value.
	 * @param char The current character.
	 * @returns The index of the next node, or -1 if no branch is taken.
	 */
	function determineBranch(decodeTree, current, nodeIndex, char) {
	    const branchCount = (current & BinTrieFlags.BRANCH_LENGTH) >> 7;
	    const jumpOffset = current & BinTrieFlags.JUMP_TABLE;
	    // Case 1: Single branch encoded in jump offset
	    if (branchCount === 0) {
	        return jumpOffset !== 0 && char === jumpOffset ? nodeIndex : -1;
	    }
	    // Case 2: Multiple branches encoded in jump table
	    if (jumpOffset) {
	        const value = char - jumpOffset;
	        return value < 0 || value >= branchCount
	            ? -1
	            : decodeTree[nodeIndex + value] - 1;
	    }
	    // Case 3: Multiple branches encoded in dictionary
	    // Binary search for the character.
	    let lo = nodeIndex;
	    let hi = lo + branchCount - 1;
	    while (lo <= hi) {
	        const mid = (lo + hi) >>> 1;
	        const midValue = decodeTree[mid];
	        if (midValue < char) {
	            lo = mid + 1;
	        }
	        else if (midValue > char) {
	            hi = mid - 1;
	        }
	        else {
	            return decodeTree[mid + branchCount];
	        }
	    }
	    return -1;
	}
	const htmlDecoder = /* #__PURE__ */ getDecoder(htmlDecodeTree);
	/**
	 * Decodes an HTML string.
	 *
	 * @param htmlString The string to decode.
	 * @param mode The decoding mode.
	 * @returns The decoded string.
	 */
	function decodeHTML(htmlString, mode = DecodingMode.Legacy) {
	    return htmlDecoder(htmlString, mode);
	}
	/**
	 * Decodes an HTML string, requiring all entities to be terminated by a semicolon.
	 *
	 * @param htmlString The string to decode.
	 * @returns The decoded string.
	 */
	function decodeHTMLStrict(htmlString) {
	    return htmlDecoder(htmlString, DecodingMode.Strict);
	}

	var constants;
	var hasRequiredConstants;

	function requireConstants () {
		if (hasRequiredConstants) return constants;
		hasRequiredConstants = 1;

		constants =
		{
			// Output
			ABSOLUTE:      "absolute",
			PATH_RELATIVE: "pathRelative",
			ROOT_RELATIVE: "rootRelative",
			SHORTEST:      "shortest"
		};
		return constants;
	}

	var format;
	var hasRequiredFormat;

	function requireFormat () {
		if (hasRequiredFormat) return format;
		hasRequiredFormat = 1;

		var constants = requireConstants();



		function formatAuth(urlObj, options)
		{
			if (urlObj.auth && !options.removeAuth && (urlObj.extra.relation.maximumHost || options.output===constants.ABSOLUTE))
			{
				return urlObj.auth + "@";
			}
			
			return "";
		}



		function formatHash(urlObj, options)
		{
			return urlObj.hash ? urlObj.hash : "";
		}



		function formatHost(urlObj, options)
		{
			if (urlObj.host.full && (urlObj.extra.relation.maximumAuth || options.output===constants.ABSOLUTE))
			{
				return urlObj.host.full;
			}
			
			return "";
		}



		function formatPath(urlObj, options)
		{
			var str = "";
			
			var absolutePath = urlObj.path.absolute.string;
			var relativePath = urlObj.path.relative.string;
			var resource = showResource(urlObj, options);
			
			if (urlObj.extra.relation.maximumHost || options.output===constants.ABSOLUTE || options.output===constants.ROOT_RELATIVE)
			{
				str = absolutePath;
			}
			else if (relativePath.length<=absolutePath.length && options.output===constants.SHORTEST || options.output===constants.PATH_RELATIVE)
			{
				str = relativePath;
				
				if (str === "")
				{
					var query = showQuery(urlObj,options) && !!getQuery(urlObj,options);
					
					if (urlObj.extra.relation.maximumPath && !resource)
					{
						str = "./";
					}
					else if (urlObj.extra.relation.overridesQuery && !resource && !query)
					{
						str = "./";
					}
				}
			}
			else
			{
				str = absolutePath;
			}
			
			if ( str==="/" && !resource && options.removeRootTrailingSlash && (!urlObj.extra.relation.minimumPort || options.output===constants.ABSOLUTE) )
			{
				str = "";
			}
			
			return str;
		}



		function formatPort(urlObj, options)
		{
			if (urlObj.port && !urlObj.extra.portIsDefault && urlObj.extra.relation.maximumHost)
			{
				return ":" + urlObj.port;
			}
			
			return "";
		}



		function formatQuery(urlObj, options)
		{
			return showQuery(urlObj,options) ? getQuery(urlObj, options) : "";
		}



		function formatResource(urlObj, options)
		{
			return showResource(urlObj,options) ? urlObj.resource : "";
		}



		function formatScheme(urlObj, options)
		{
			var str = "";
			
			if (urlObj.extra.relation.maximumHost || options.output===constants.ABSOLUTE)
			{
				if (!urlObj.extra.relation.minimumScheme || !options.schemeRelative || options.output===constants.ABSOLUTE)
				{
					str += urlObj.scheme + "://";
				}
				else
				{
					str += "//";
				}
			}
			
			return str;
		}



		function formatUrl(urlObj, options)
		{
			var url = "";
			
			url += formatScheme(urlObj, options);
			url += formatAuth(urlObj, options);
			url += formatHost(urlObj, options);
			url += formatPort(urlObj);
			url += formatPath(urlObj, options);
			url += formatResource(urlObj, options);
			url += formatQuery(urlObj, options);
			url += formatHash(urlObj);
			
			return url;
		}



		function getQuery(urlObj, options)
		{
			var stripQuery = options.removeEmptyQueries && urlObj.extra.relation.minimumPort;
			
			return urlObj.query.string[ stripQuery ? "stripped" : "full" ];
		}



		function showQuery(urlObj, options)
		{
			return !urlObj.extra.relation.minimumQuery || options.output===constants.ABSOLUTE || options.output===constants.ROOT_RELATIVE;
		}



		function showResource(urlObj, options)
		{
			var removeIndex = options.removeDirectoryIndexes && urlObj.extra.resourceIsIndex;
			var removeMatchingResource = urlObj.extra.relation.minimumResource && options.output!==constants.ABSOLUTE && options.output!==constants.ROOT_RELATIVE;
			
			return !!urlObj.resource && !removeMatchingResource && !removeIndex;
		}



		format = formatUrl;
		return format;
	}

	var object;
	var hasRequiredObject;

	function requireObject () {
		if (hasRequiredObject) return object;
		hasRequiredObject = 1;

		/*
			Deep-clone an object.
		*/
		function clone(obj)
		{
			if (obj instanceof Object)
			{
				var clonedObj = (obj instanceof Array) ? [] : {};
				
				for (var i in obj)
				{
					if ( obj.hasOwnProperty(i) )
					{
						clonedObj[i] = clone( obj[i] );
					}
				}
				
				return clonedObj;
			}
			
			return obj;
		}



		/*
			https://github.com/jonschlinkert/is-plain-object
		*/
		function isPlainObject(obj)
		{
			return !!obj && typeof obj==="object" && obj.constructor===Object;
		}



		/*
			Shallow-merge two objects.
		*/
		function shallowMerge(target, source)
		{
			if (target instanceof Object && source instanceof Object)
			{
				for (var i in source)
				{
					if ( source.hasOwnProperty(i) )
					{
						target[i] = source[i];
					}
				}
			}
			
			return target;
		}



		object =
		{
			clone: clone,
			isPlainObject: isPlainObject,
			shallowMerge: shallowMerge
		};
		return object;
	}

	var options;
	var hasRequiredOptions;

	function requireOptions () {
		if (hasRequiredOptions) return options;
		hasRequiredOptions = 1;

		var objUtils = requireObject();



		function getOptions(options, defaults)
		{
			if ( objUtils.isPlainObject(options) )
			{
				var newOptions = {};
				
				for (var i in defaults)
				{
					if ( defaults.hasOwnProperty(i) )
					{
						if (options[i] !== undefined)
						{
							newOptions[i] = mergeOption(options[i], defaults[i]);
						}
						else
						{
							newOptions[i] = defaults[i];
						}
					}
				}
				
				return newOptions;
			}
			else
			{
				return defaults;
			}
		}



		function mergeOption(newValues, defaultValues)
		{
			if (defaultValues instanceof Object && newValues instanceof Object)
			{
				if (defaultValues instanceof Array && newValues instanceof Array)
				{
					return defaultValues.concat(newValues);
				}
				else
				{
					return objUtils.shallowMerge(newValues, defaultValues);
				}
			}
			
			return newValues;
		}



		options = getOptions;
		return options;
	}

	var hrefInfo_1;
	var hasRequiredHrefInfo;

	function requireHrefInfo () {
		if (hasRequiredHrefInfo) return hrefInfo_1;
		hasRequiredHrefInfo = 1;

		function hrefInfo(urlObj)
		{
			var minimumPathOnly     = (!urlObj.scheme && !urlObj.auth && !urlObj.host.full && !urlObj.port);
			var minimumResourceOnly = (minimumPathOnly && !urlObj.path.absolute.string);
			var minimumQueryOnly    = (minimumResourceOnly && !urlObj.resource);
			var minimumHashOnly     = (minimumQueryOnly && !urlObj.query.string.full.length);
			var empty               = (minimumHashOnly && !urlObj.hash);
			
			urlObj.extra.hrefInfo.minimumPathOnly     = minimumPathOnly;
			urlObj.extra.hrefInfo.minimumResourceOnly = minimumResourceOnly;
			urlObj.extra.hrefInfo.minimumQueryOnly    = minimumQueryOnly;
			urlObj.extra.hrefInfo.minimumHashOnly     = minimumHashOnly;
			urlObj.extra.hrefInfo.empty = empty;
		}



		hrefInfo_1 = hrefInfo;
		return hrefInfo_1;
	}

	var host;
	var hasRequiredHost;

	function requireHost () {
		if (hasRequiredHost) return host;
		hasRequiredHost = 1;

		function parseHost(urlObj, options)
		{
			// TWEAK :: condition only for speed optimization
			if (options.ignore_www)
			{
				var host = urlObj.host.full;
				
				if (host)
				{
					var stripped = host;
					
					if (host.indexOf("www.") === 0)
					{
						stripped = host.substr(4);
					}
					
					urlObj.host.stripped = stripped;
				}
			}
		}



		host = parseHost;
		return host;
	}

	var path$1;
	var hasRequiredPath$1;

	function requirePath$1 () {
		if (hasRequiredPath$1) return path$1;
		hasRequiredPath$1 = 1;

		function isDirectoryIndex(resource, options)
		{
			var verdict = false;
			
			options.directoryIndexes.every( function(index)
			{
				if (index === resource)
				{
					verdict = true;
					return false;
				}
				
				return true;
			});
			
			return verdict;
		}



		function parsePath(urlObj, options)
		{
			var path = urlObj.path.absolute.string;
			
			if (path)
			{
				var lastSlash = path.lastIndexOf("/");
				
				if (lastSlash > -1)
				{
					if (++lastSlash < path.length)
					{
						var resource = path.substr(lastSlash);
						
						if (resource!=="." && resource!=="..")
						{
							urlObj.resource = resource;
							path = path.substr(0, lastSlash);
						}
						else
						{
							path += "/";
						}
					}
					
					urlObj.path.absolute.string = path;
					urlObj.path.absolute.array = splitPath(path);
				}
				else if (path==="." || path==="..")
				{
					// "..?var", "..#anchor", etc ... not "..index.html"
					path += "/";
					
					urlObj.path.absolute.string = path;
					urlObj.path.absolute.array = splitPath(path);
				}
				else
				{
					// Resource-only
					urlObj.resource = path;
					urlObj.path.absolute.string = null;
				}
				
				urlObj.extra.resourceIsIndex = isDirectoryIndex(urlObj.resource, options);
			}
			// Else: query/hash-only or empty
		}



		function splitPath(path)
		{
			// TWEAK :: condition only for speed optimization
			if (path !== "/")
			{
				var cleaned = [];
				
				path.split("/").forEach( function(dir)
				{
					// Cleanup -- splitting "/dir/" becomes ["","dir",""]
					if (dir !== "")
					{
						cleaned.push(dir);
					}
				});
				
				return cleaned;
			}
			else
			{
				// Faster to skip the above block and just create an array
				return [];
			}
		}



		path$1 = parsePath;
		return path$1;
	}

	var port;
	var hasRequiredPort;

	function requirePort () {
		if (hasRequiredPort) return port;
		hasRequiredPort = 1;

		function parsePort(urlObj, options)
		{
			var defaultPort = -1;
			
			for (var i in options.defaultPorts)
			{
				if ( i===urlObj.scheme && options.defaultPorts.hasOwnProperty(i) )
				{
					defaultPort = options.defaultPorts[i];
					break;
				}
			}
			
			if (defaultPort > -1)
			{
				// Force same type as urlObj.port
				defaultPort = defaultPort.toString();
				
				if (urlObj.port === null)
				{
					urlObj.port = defaultPort;
				}
				
				urlObj.extra.portIsDefault = (urlObj.port === defaultPort);
			}
		}



		port = parsePort;
		return port;
	}

	var query;
	var hasRequiredQuery;

	function requireQuery () {
		if (hasRequiredQuery) return query;
		hasRequiredQuery = 1;
		var hasOwnProperty = Object.prototype.hasOwnProperty;



		function parseQuery(urlObj, options)
		{
			urlObj.query.string.full = stringify(urlObj.query.object, false);
			
			// TWEAK :: condition only for speed optimization
			if (options.removeEmptyQueries)
			{
				urlObj.query.string.stripped = stringify(urlObj.query.object, true);
			}
		}



		function stringify(queryObj, removeEmptyQueries)
		{
			var count = 0;
			var str = "";
			
			for (var i in queryObj)
			{
				if ( i!=="" && hasOwnProperty.call(queryObj, i)===true )
				{
					var value = queryObj[i];
					
					if (value !== "" || !removeEmptyQueries)
					{
						str += (++count===1) ? "?" : "&";
						
						i = encodeURIComponent(i);
						
						if (value !== "")
						{
							str += i +"="+ encodeURIComponent(value).replace(/%20/g,"+");
						}
						else
						{
							str += i;
						}
					}
				}
			}
			
			return str;
		}



		query = parseQuery;
		return query;
	}

	var urlstring;
	var hasRequiredUrlstring;

	function requireUrlstring () {
		if (hasRequiredUrlstring) return urlstring;
		hasRequiredUrlstring = 1;

		var _parseUrl = require$$0$1.parse;



		/*
			Customize the URL object that Node generates
			because:
			
			* necessary data for later
			* urlObj.host is useless
			* urlObj.hostname is too long
			* urlObj.path is useless
			* urlObj.pathname is too long
			* urlObj.protocol is inaccurate; should be called "scheme"
			* urlObj.search is mostly useless
		*/
		function clean(urlObj)
		{
			var scheme = urlObj.protocol;
			
			if (scheme)
			{
				// Remove ":" suffix
				if (scheme.indexOf(":") === scheme.length-1)
				{
					scheme = scheme.substr(0, scheme.length-1);
				}
			}
			
			urlObj.host =
			{
				// TODO :: unescape(encodeURIComponent(s)) ? ... http://ecmanaut.blogspot.ca/2006/07/encoding-decoding-utf8-in-javascript.html
				full: urlObj.hostname,
				stripped: null
			};
			
			urlObj.path =
			{
				absolute:
				{
					array: null,
					string: urlObj.pathname
				},
				relative:
				{
					array: null,
					string: null
				}
			};
			
			urlObj.query =
			{
				object: urlObj.query,
				string:
				{
					full: null,
					stripped: null
				}
			};
			
			urlObj.extra =
			{
				hrefInfo:
				{
					minimumPathOnly: null,
					minimumResourceOnly: null,
					minimumQueryOnly: null,
					minimumHashOnly: null,
					empty: null,
					
					separatorOnlyQuery: urlObj.search==="?"
				},
				portIsDefault: null,
				relation:
				{
					maximumScheme: null,
					maximumAuth: null,
					maximumHost: null,
					maximumPort: null,
					maximumPath: null,
					maximumResource: null,
					maximumQuery: null,
					maximumHash: null,
					
					minimumScheme: null,
					minimumAuth: null,
					minimumHost: null,
					minimumPort: null,
					minimumPath: null,
					minimumResource: null,
					minimumQuery: null,
					minimumHash: null,
					
					overridesQuery: null
				},
				resourceIsIndex: null,
				slashes: urlObj.slashes
			};
			
			urlObj.resource = null;
			urlObj.scheme = scheme;
			delete urlObj.hostname;
			delete urlObj.pathname;
			delete urlObj.protocol;
			delete urlObj.search;
			delete urlObj.slashes;
			
			return urlObj;
		}



		function validScheme(url, options)
		{
			var valid = true;
			
			options.rejectedSchemes.every( function(rejectedScheme)
			{
				valid = !(url.indexOf(rejectedScheme+":") === 0);
				
				// Break loop
				return valid;
			});
			
			return valid;
		}



		function parseUrlString(url, options)
		{
			if ( validScheme(url,options) )
			{
				return clean( _parseUrl(url, true, options.slashesDenoteHost) );
			}
			else
			{
				return {href:url, valid:false};
			}
		}



		urlstring = parseUrlString;
		return urlstring;
	}

	var path;
	var hasRequiredPath;

	function requirePath () {
		if (hasRequiredPath) return path;
		hasRequiredPath = 1;

		function joinPath(pathArray)
		{
			if (pathArray.length > 0)
			{
				return pathArray.join("/") + "/";
			}
			else
			{
				return "";
			}
		}



		function resolveDotSegments(pathArray)
		{
			var pathAbsolute = [];
			
			pathArray.forEach( function(dir)
			{
				if (dir !== "..")
				{
					if (dir !== ".")
					{
						pathAbsolute.push(dir);
					}
				}
				else
				{
					// Remove parent
					if (pathAbsolute.length > 0)
					{
						pathAbsolute.splice(pathAbsolute.length-1, 1);
					}
				}
			});
			
			return pathAbsolute;
		}



		path =
		{
			join: joinPath,
			resolveDotSegments: resolveDotSegments
		};
		return path;
	}

	var parse$1;
	var hasRequiredParse;

	function requireParse () {
		if (hasRequiredParse) return parse$1;
		hasRequiredParse = 1;

		var hrefInfo   = requireHrefInfo();
		var parseHost  = requireHost();
		var parsePath  = requirePath$1();
		var parsePort  = requirePort();
		var parseQuery = requireQuery();
		var parseUrlString = requireUrlstring();
		var pathUtils      = requirePath();



		function parseFromUrl(url, options, fallback)
		{
			if (url)
			{
				var urlObj = parseUrl(url, options);
				
				// Because the following occurs in the relate stage for "to" URLs,
				// such had to be mostly duplicated here
				
				var pathArray = pathUtils.resolveDotSegments(urlObj.path.absolute.array);
				
				urlObj.path.absolute.array  = pathArray;
				urlObj.path.absolute.string = "/" + pathUtils.join(pathArray);
				
				return urlObj;
			}
			else
			{
				return fallback;
			}
		}



		function parseUrl(url, options)
		{
			var urlObj = parseUrlString(url, options);
			
			if (urlObj.valid===false) return urlObj;
			
			parseHost(urlObj, options);
			parsePort(urlObj, options);
			parsePath(urlObj, options);
			parseQuery(urlObj, options);
			hrefInfo(urlObj);
			
			return urlObj;
		}



		parse$1 =
		{
			from: parseFromUrl,
			to:   parseUrl
		};
		return parse$1;
	}

	var findRelation;
	var hasRequiredFindRelation;

	function requireFindRelation () {
		if (hasRequiredFindRelation) return findRelation;
		hasRequiredFindRelation = 1;

		function findRelation_upToPath(urlObj, siteUrlObj, options)
		{
			// Path- or root-relative URL
			var pathOnly = urlObj.extra.hrefInfo.minimumPathOnly;
			
			// Matching scheme, scheme-relative or path-only
			var minimumScheme = (urlObj.scheme===siteUrlObj.scheme || !urlObj.scheme);
			
			// Matching auth, ignoring auth or path-only
			var minimumAuth = minimumScheme && (urlObj.auth===siteUrlObj.auth || options.removeAuth || pathOnly);
			
			// Matching host or path-only
			var www = options.ignore_www ? "stripped" : "full";
			var minimumHost = minimumAuth && (urlObj.host[www]===siteUrlObj.host[www] || pathOnly);
			
			// Matching port or path-only
			var minimumPort = minimumHost && (urlObj.port===siteUrlObj.port || pathOnly);
			
			urlObj.extra.relation.minimumScheme = minimumScheme;
			urlObj.extra.relation.minimumAuth   = minimumAuth;
			urlObj.extra.relation.minimumHost   = minimumHost;
			urlObj.extra.relation.minimumPort   = minimumPort;
			
			urlObj.extra.relation.maximumScheme = !minimumScheme || minimumScheme && !minimumAuth;
			urlObj.extra.relation.maximumAuth   = !minimumScheme || minimumScheme && !minimumHost;
			urlObj.extra.relation.maximumHost   = !minimumScheme || minimumScheme && !minimumPort;
		}



		function findRelation_pathOn(urlObj, siteUrlObj, options)
		{
			var queryOnly = urlObj.extra.hrefInfo.minimumQueryOnly;
			var hashOnly  = urlObj.extra.hrefInfo.minimumHashOnly;
			var empty     = urlObj.extra.hrefInfo.empty;	// not required, but self-documenting
			
			// From upToPath()
			var minimumPort   = urlObj.extra.relation.minimumPort;
			var minimumScheme = urlObj.extra.relation.minimumScheme;
			
			// Matching port and path
			var minimumPath = minimumPort && urlObj.path.absolute.string===siteUrlObj.path.absolute.string;
			
			// Matching resource or query/hash-only or empty
			var matchingResource = (urlObj.resource===siteUrlObj.resource || !urlObj.resource && siteUrlObj.extra.resourceIsIndex) || (options.removeDirectoryIndexes && urlObj.extra.resourceIsIndex && !siteUrlObj.resource);
			var minimumResource = minimumPath && (matchingResource || queryOnly || hashOnly || empty);
			
			// Matching query or hash-only/empty
			var query = options.removeEmptyQueries ? "stripped" : "full";
			var urlQuery = urlObj.query.string[query];
			var siteUrlQuery = siteUrlObj.query.string[query];
			var minimumQuery = (minimumResource && !!urlQuery && urlQuery===siteUrlQuery) || ((hashOnly || empty) && !urlObj.extra.hrefInfo.separatorOnlyQuery);
			
			var minimumHash = minimumQuery && urlObj.hash===siteUrlObj.hash;
			
			urlObj.extra.relation.minimumPath     = minimumPath;
			urlObj.extra.relation.minimumResource = minimumResource;
			urlObj.extra.relation.minimumQuery    = minimumQuery;
			urlObj.extra.relation.minimumHash     = minimumHash;
			
			urlObj.extra.relation.maximumPort     = !minimumScheme || minimumScheme && !minimumPath;
			urlObj.extra.relation.maximumPath     = !minimumScheme || minimumScheme && !minimumResource;
			urlObj.extra.relation.maximumResource = !minimumScheme || minimumScheme && !minimumQuery;
			urlObj.extra.relation.maximumQuery    = !minimumScheme || minimumScheme && !minimumHash;
			urlObj.extra.relation.maximumHash     = !minimumScheme || minimumScheme && !minimumHash;	// there's nothing after hash, so it's the same as maximumQuery
			
			// Matching path and/or resource with existing but non-matching site query
			urlObj.extra.relation.overridesQuery  = minimumPath && urlObj.extra.relation.maximumResource && !minimumQuery && !!siteUrlQuery;
		}



		findRelation =
		{
			pathOn:   findRelation_pathOn,
			upToPath: findRelation_upToPath
		};
		return findRelation;
	}

	var absolutize_1;
	var hasRequiredAbsolutize;

	function requireAbsolutize () {
		if (hasRequiredAbsolutize) return absolutize_1;
		hasRequiredAbsolutize = 1;

		var findRelation = requireFindRelation();
		var objUtils     = requireObject();
		var pathUtils    = requirePath();



		function absolutize(urlObj, siteUrlObj, options)
		{
			findRelation.upToPath(urlObj, siteUrlObj, options);
			
			// Fill in relative URLs
			if (urlObj.extra.relation.minimumScheme) urlObj.scheme = siteUrlObj.scheme;
			if (urlObj.extra.relation.minimumAuth)   urlObj.auth   = siteUrlObj.auth;
			if (urlObj.extra.relation.minimumHost)   urlObj.host   = objUtils.clone(siteUrlObj.host);
			if (urlObj.extra.relation.minimumPort)   copyPort(urlObj, siteUrlObj);
			if (urlObj.extra.relation.minimumScheme) copyPath(urlObj, siteUrlObj);
			
			// Check remaining relativeness now that path has been copied and/or resolved
			findRelation.pathOn(urlObj, siteUrlObj, options);
			
			// Fill in relative URLs
			if (urlObj.extra.relation.minimumResource) copyResource(urlObj, siteUrlObj);
			if (urlObj.extra.relation.minimumQuery)    urlObj.query = objUtils.clone(siteUrlObj.query);
			if (urlObj.extra.relation.minimumHash)     urlObj.hash  = siteUrlObj.hash;
		}



		/*
			Get an absolute path that's relative to site url.
		*/
		function copyPath(urlObj, siteUrlObj)
		{
			if (urlObj.extra.relation.maximumHost || !urlObj.extra.hrefInfo.minimumResourceOnly)
			{
				var pathArray = urlObj.path.absolute.array;
				var pathString = "/";
				
				// If not erroneous URL
				if (pathArray)
				{
					// If is relative path
					if (urlObj.extra.hrefInfo.minimumPathOnly && urlObj.path.absolute.string.indexOf("/")!==0)
					{
						// Append path to site path
						pathArray = siteUrlObj.path.absolute.array.concat(pathArray);
					}
					
					pathArray   = pathUtils.resolveDotSegments(pathArray);
					pathString += pathUtils.join(pathArray);
				}
				else
				{
					pathArray = [];
				}
				
				urlObj.path.absolute.array  = pathArray;
				urlObj.path.absolute.string = pathString;
			}
			else
			{
				// Resource-, query- or hash-only or empty
				urlObj.path = objUtils.clone(siteUrlObj.path);
			}
		}



		function copyPort(urlObj, siteUrlObj)
		{
			urlObj.port = siteUrlObj.port;
			
			urlObj.extra.portIsDefault = siteUrlObj.extra.portIsDefault;
		}



		function copyResource(urlObj, siteUrlObj)
		{
			urlObj.resource = siteUrlObj.resource;
			
			urlObj.extra.resourceIsIndex = siteUrlObj.extra.resourceIsIndex;
		}



		absolutize_1 = absolutize;
		return absolutize_1;
	}

	var relativize_1;
	var hasRequiredRelativize;

	function requireRelativize () {
		if (hasRequiredRelativize) return relativize_1;
		hasRequiredRelativize = 1;

		var pathUtils = requirePath();



		/*
			Get a path relative to the site path.
		*/
		function relatePath(absolutePath, siteAbsolutePath)
		{
			var relativePath = [];
			
			// At this point, it's related to the host/port
			var related = true;
			var parentIndex = -1;
			
			// Find parents
			siteAbsolutePath.forEach( function(siteAbsoluteDir, i)
			{
				if (related)
				{
					if (absolutePath[i] !== siteAbsoluteDir)
					{
						related = false;
					}
					else
					{
						parentIndex = i;
					}
				}
				
				if (!related)
				{
					// Up one level
					relativePath.push("..");
				}
			});
			
			// Form path
			absolutePath.forEach( function(dir, i)
			{
				if (i > parentIndex)
				{
					relativePath.push(dir);
				}
			});
			
			return relativePath;
		}



		function relativize(urlObj, siteUrlObj, options)
		{
			if (urlObj.extra.relation.minimumScheme)
			{
				var pathArray = relatePath(urlObj.path.absolute.array, siteUrlObj.path.absolute.array);
				
				urlObj.path.relative.array  = pathArray;
				urlObj.path.relative.string = pathUtils.join(pathArray);
			}
		}



		relativize_1 = relativize;
		return relativize_1;
	}

	var relate;
	var hasRequiredRelate;

	function requireRelate () {
		if (hasRequiredRelate) return relate;
		hasRequiredRelate = 1;

		var absolutize = requireAbsolutize();
		var relativize = requireRelativize();



		function relateUrl(siteUrlObj, urlObj, options)
		{
			absolutize(urlObj, siteUrlObj, options);
			relativize(urlObj, siteUrlObj, options);
			
			return urlObj;
		}



		relate = relateUrl;
		return relate;
	}

	var lib;
	var hasRequiredLib;

	function requireLib () {
		if (hasRequiredLib) return lib;
		hasRequiredLib = 1;

		var constants  = requireConstants();
		var formatUrl  = requireFormat();
		var getOptions = requireOptions();
		var objUtils   = requireObject();
		var parseUrl   = requireParse();
		var relateUrl  = requireRelate();



		function RelateUrl(from, options)
		{
			this.options = getOptions(options,
			{
				defaultPorts: {ftp:21, http:80, https:443},
				directoryIndexes: ["index.html"],
				ignore_www: false,
				output: RelateUrl.SHORTEST,
				rejectedSchemes: ["data","javascript","mailto"],
				removeAuth: false,
				removeDirectoryIndexes: true,
				removeEmptyQueries: false,
				removeRootTrailingSlash: true,
				schemeRelative: true,
				site: undefined,
				slashesDenoteHost: true
			});
			
			this.from = parseUrl.from(from, this.options, null);
		}



		/*
			Usage: instance=new RelateUrl(); instance.relate();
		*/
		RelateUrl.prototype.relate = function(from, to, options)
		{
			// relate(to,options)
			if ( objUtils.isPlainObject(to) )
			{
				options = to;
				to = from;
				from = null;
			}
			// relate(to)
			else if (!to)
			{
				to = from;
				from = null;
			}
			
			options = getOptions(options, this.options);
			from = from || options.site;
			from = parseUrl.from(from, options, this.from);
			
			if (!from || !from.href)
			{
				throw new Error("from value not defined.");
			}
			else if (from.extra.hrefInfo.minimumPathOnly)
			{
				throw new Error("from value supplied is not absolute: "+from.href);
			}
			
			to = parseUrl.to(to, options);
			
			if (to.valid===false) return to.href;
			
			to = relateUrl(from, to, options);
			to = formatUrl(to, options);
			
			return to;
		};



		/*
			Usage: RelateUrl.relate();
		*/
		RelateUrl.relate = function(from, to, options)
		{
			return new RelateUrl().relate(from, to, options);
		};



		// Make constants accessible from API
		objUtils.shallowMerge(RelateUrl, constants);



		lib = RelateUrl;
		return lib;
	}

	var libExports = requireLib();
	var RelateURL = /*@__PURE__*/getDefaultExportFromCjs(libExports);

	/***********************************************************************

	  A JavaScript tokenizer / parser / beautifier / compressor.
	  https://github.com/mishoo/UglifyJS2

	  -------------------------------- (C) ---------------------------------

	                           Author: Mihai Bazon
	                         <mihai.bazon@gmail.com>
	                       http://mihai.bazon.net/blog

	  Distributed under the BSD license:

	    Copyright 2012 (c) Mihai Bazon <mihai.bazon@gmail.com>

	    Redistribution and use in source and binary forms, with or without
	    modification, are permitted provided that the following conditions
	    are met:

	        * Redistributions of source code must retain the above
	          copyright notice, this list of conditions and the following
	          disclaimer.

	        * Redistributions in binary form must reproduce the above
	          copyright notice, this list of conditions and the following
	          disclaimer in the documentation and/or other materials
	          provided with the distribution.

	    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER “AS IS” AND ANY
	    EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
	    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	    PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE
	    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
	    OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
	    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
	    PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
	    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
	    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
	    THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
	    SUCH DAMAGE.

	 ***********************************************************************/


	function characters(str) {
	    return str.split("");
	}

	function member(name, array) {
	    return array.includes(name);
	}

	class DefaultsError extends Error {
	    constructor(msg, defs) {
	        super();

	        this.name = "DefaultsError";
	        this.message = msg;
	        this.defs = defs;
	    }
	}

	function defaults(args, defs, croak) {
	    if (args === true) {
	        args = {};
	    } else if (args != null && typeof args === "object") {
	        args = {...args};
	    }

	    const ret = args || {};

	    if (croak) for (const i in ret) if (HOP(ret, i) && !HOP(defs, i)) {
	        throw new DefaultsError("`" + i + "` is not a supported option", defs);
	    }

	    for (const i in defs) if (HOP(defs, i)) {
	        if (!args || !HOP(args, i)) {
	            ret[i] = defs[i];
	        } else if (i === "ecma") {
	            let ecma = args[i] | 0;
	            if (ecma > 5 && ecma < 2015) ecma += 2009;
	            ret[i] = ecma;
	        } else {
	            ret[i] = (args && HOP(args, i)) ? args[i] : defs[i];
	        }
	    }

	    return ret;
	}

	function noop() {}
	function return_false() { return false; }
	function return_true() { return true; }
	function return_this() { return this; }
	function return_null() { return null; }

	var MAP = (function() {
	    function MAP(a, tw, allow_splicing = true) {
	        const new_a = [];

	        for (let i = 0; i < a.length; ++i) {
	            let item = a[i];
	            let ret = item.transform(tw, allow_splicing);

	            if (ret instanceof AST_Node) {
	                new_a.push(ret);
	            } else if (ret instanceof Splice) {
	                new_a.push(...ret.v);
	            }
	        }

	        return new_a;
	    }

	    MAP.splice = function(val) { return new Splice(val); };
	    MAP.skip = {};
	    function Splice(val) { this.v = val; }
	    return MAP;
	})();

	function make_node(ctor, orig, props) {
	    if (!props) props = {};
	    if (orig) {
	        if (!props.start) props.start = orig.start;
	        if (!props.end) props.end = orig.end;
	    }
	    return new ctor(props);
	}

	function push_uniq(array, el) {
	    if (!array.includes(el))
	        array.push(el);
	}

	function string_template(text, props) {
	    return text.replace(/{(.+?)}/g, function(str, p) {
	        return props && props[p];
	    });
	}

	function remove(array, el) {
	    for (var i = array.length; --i >= 0;) {
	        if (array[i] === el) array.splice(i, 1);
	    }
	}

	function mergeSort(array, cmp) {
	    if (array.length < 2) return array.slice();
	    function merge(a, b) {
	        var r = [], ai = 0, bi = 0, i = 0;
	        while (ai < a.length && bi < b.length) {
	            cmp(a[ai], b[bi]) <= 0
	                ? r[i++] = a[ai++]
	                : r[i++] = b[bi++];
	        }
	        if (ai < a.length) r.push.apply(r, a.slice(ai));
	        if (bi < b.length) r.push.apply(r, b.slice(bi));
	        return r;
	    }
	    function _ms(a) {
	        if (a.length <= 1)
	            return a;
	        var m = Math.floor(a.length / 2), left = a.slice(0, m), right = a.slice(m);
	        left = _ms(left);
	        right = _ms(right);
	        return merge(left, right);
	    }
	    return _ms(array);
	}

	function makePredicate(words) {
	    if (!Array.isArray(words)) words = words.split(" ");

	    return new Set(words.sort());
	}

	function map_add(map, key, value) {
	    if (map.has(key)) {
	        map.get(key).push(value);
	    } else {
	        map.set(key, [ value ]);
	    }
	}

	function map_from_object(obj) {
	    var map = new Map();
	    for (var key in obj) {
	        if (HOP(obj, key) && key.charAt(0) === "$") {
	            map.set(key.substr(1), obj[key]);
	        }
	    }
	    return map;
	}

	function map_to_object(map) {
	    var obj = Object.create(null);
	    map.forEach(function (value, key) {
	        obj["$" + key] = value;
	    });
	    return obj;
	}

	function HOP(obj, prop) {
	    return Object.prototype.hasOwnProperty.call(obj, prop);
	}

	function keep_name(keep_setting, name) {
	    return keep_setting === true
	        || (keep_setting instanceof RegExp && keep_setting.test(name));
	}

	var lineTerminatorEscape = {
	    "\0": "0",
	    "\n": "n",
	    "\r": "r",
	    "\u2028": "u2028",
	    "\u2029": "u2029",
	};
	function regexp_source_fix(source) {
	    // V8 does not escape line terminators in regexp patterns in node 12
	    // We'll also remove literal \0
	    return source.replace(/[\0\n\r\u2028\u2029]/g, function (match, offset) {
	        var escaped = source[offset - 1] == "\\"
	            && (source[offset - 2] != "\\"
	            || /(?:^|[^\\])(?:\\{2})*$/.test(source.slice(0, offset - 1)));
	        return (escaped ? "" : "\\") + lineTerminatorEscape[match];
	    });
	}

	// Subset of regexps that is not going to cause regexp based DDOS
	// https://owasp.org/www-community/attacks/Regular_expression_Denial_of_Service_-_ReDoS
	const re_safe_regexp = /^[\\/|\0\s\w^$.[\]()]*$/;

	/** Check if the regexp is safe for Terser to create without risking a RegExp DOS */
	const regexp_is_safe = (source) => re_safe_regexp.test(source);

	const all_flags = "dgimsuyv";
	function sort_regexp_flags(flags) {
	    const existing_flags = new Set(flags.split(""));
	    let out = "";
	    for (const flag of all_flags) {
	        if (existing_flags.has(flag)) {
	            out += flag;
	            existing_flags.delete(flag);
	        }
	    }
	    if (existing_flags.size) {
	        // Flags Terser doesn't know about
	        existing_flags.forEach(flag => { out += flag; });
	    }
	    return out;
	}

	function has_annotation(node, annotation) {
	    return node._annotations & annotation;
	}

	function set_annotation(node, annotation) {
	    node._annotations |= annotation;
	}

	function clear_annotation(node, annotation) {
	    node._annotations &= -9;
	}

	/***********************************************************************

	  A JavaScript tokenizer / parser / beautifier / compressor.
	  https://github.com/mishoo/UglifyJS2

	  -------------------------------- (C) ---------------------------------

	                           Author: Mihai Bazon
	                         <mihai.bazon@gmail.com>
	                       http://mihai.bazon.net/blog

	  Distributed under the BSD license:

	    Copyright 2012 (c) Mihai Bazon <mihai.bazon@gmail.com>
	    Parser based on parse-js (http://marijn.haverbeke.nl/parse-js/).

	    Redistribution and use in source and binary forms, with or without
	    modification, are permitted provided that the following conditions
	    are met:

	        * Redistributions of source code must retain the above
	          copyright notice, this list of conditions and the following
	          disclaimer.

	        * Redistributions in binary form must reproduce the above
	          copyright notice, this list of conditions and the following
	          disclaimer in the documentation and/or other materials
	          provided with the distribution.

	    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER “AS IS” AND ANY
	    EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
	    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	    PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE
	    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
	    OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
	    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
	    PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
	    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
	    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
	    THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
	    SUCH DAMAGE.

	 ***********************************************************************/


	var LATEST_RAW = "";  // Only used for numbers and template strings
	var TEMPLATE_RAWS = new Map();  // Raw template strings

	var KEYWORDS = "break case catch class const continue debugger default delete do else export extends finally for function if in instanceof let new return switch throw try typeof var void while with";
	var KEYWORDS_ATOM = "false null true";
	var RESERVED_WORDS = "enum import super this " + KEYWORDS_ATOM + " " + KEYWORDS;
	var ALL_RESERVED_WORDS = "implements interface package private protected public static " + RESERVED_WORDS;
	var KEYWORDS_BEFORE_EXPRESSION = "return new delete throw else case yield await";

	KEYWORDS = makePredicate(KEYWORDS);
	RESERVED_WORDS = makePredicate(RESERVED_WORDS);
	KEYWORDS_BEFORE_EXPRESSION = makePredicate(KEYWORDS_BEFORE_EXPRESSION);
	KEYWORDS_ATOM = makePredicate(KEYWORDS_ATOM);
	ALL_RESERVED_WORDS = makePredicate(ALL_RESERVED_WORDS);

	var OPERATOR_CHARS = makePredicate(characters("+-*&%=<>!?|~^"));

	var RE_HEX_NUMBER = /^0x[0-9a-f]+$/i;
	var RE_OCT_NUMBER = /^0[0-7]+$/;
	var RE_ES6_OCT_NUMBER = /^0o[0-7]+$/i;
	var RE_BIN_NUMBER = /^0b[01]+$/i;
	var RE_DEC_NUMBER = /^\d*\.?\d*(?:e[+-]?\d*(?:\d\.?|\.?\d)\d*)?$/i;
	var RE_BIG_INT = /^(0[xob])?[0-9a-f]+n$/i;

	var OPERATORS = makePredicate([
	    "in",
	    "instanceof",
	    "typeof",
	    "new",
	    "void",
	    "delete",
	    "++",
	    "--",
	    "+",
	    "-",
	    "!",
	    "~",
	    "&",
	    "|",
	    "^",
	    "*",
	    "**",
	    "/",
	    "%",
	    ">>",
	    "<<",
	    ">>>",
	    "<",
	    ">",
	    "<=",
	    ">=",
	    "==",
	    "===",
	    "!=",
	    "!==",
	    "?",
	    "=",
	    "+=",
	    "-=",
	    "||=",
	    "&&=",
	    "??=",
	    "/=",
	    "*=",
	    "**=",
	    "%=",
	    ">>=",
	    "<<=",
	    ">>>=",
	    "|=",
	    "^=",
	    "&=",
	    "&&",
	    "??",
	    "||",
	]);

	var WHITESPACE_CHARS = makePredicate(characters(" \u00a0\n\r\t\f\u000b\u200b\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u2028\u2029\u202f\u205f\u3000\uFEFF"));

	var NEWLINE_CHARS = makePredicate(characters("\n\r\u2028\u2029"));

	var PUNC_AFTER_EXPRESSION = makePredicate(characters(";]),:"));

	var PUNC_BEFORE_EXPRESSION = makePredicate(characters("[{(,;:"));

	var PUNC_CHARS = makePredicate(characters("[]{}(),;:"));

	/* -----[ Tokenizer ]----- */

	// surrogate safe regexps adapted from https://github.com/mathiasbynens/unicode-8.0.0/tree/89b412d8a71ecca9ed593d9e9fa073ab64acfebe/Binary_Property
	var UNICODE = {
	    ID_Start: /[$A-Z_a-z\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0-\u08B4\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309B-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FD5\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AD\uA7B0-\uA7B7\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD40-\uDD74\uDE80-\uDE9C\uDEA0-\uDED0\uDF00-\uDF1F\uDF30-\uDF4A\uDF50-\uDF75\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDCE0-\uDCF2\uDCF4\uDCF5\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00\uDE10-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE4\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2]|\uD804[\uDC03-\uDC37\uDC83-\uDCAF\uDCD0-\uDCE8\uDD03-\uDD26\uDD50-\uDD72\uDD76\uDD83-\uDDB2\uDDC1-\uDDC4\uDDDA\uDDDC\uDE00-\uDE11\uDE13-\uDE2B\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEDE\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3D\uDF50\uDF5D-\uDF61]|\uD805[\uDC80-\uDCAF\uDCC4\uDCC5\uDCC7\uDD80-\uDDAE\uDDD8-\uDDDB\uDE00-\uDE2F\uDE44\uDE80-\uDEAA\uDF00-\uDF19]|\uD806[\uDCA0-\uDCDF\uDCFF\uDEC0-\uDEF8]|\uD808[\uDC00-\uDF99]|\uD809[\uDC00-\uDC6E\uDC80-\uDD43]|[\uD80C\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD811[\uDC00-\uDE46]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDED0-\uDEED\uDF00-\uDF2F\uDF40-\uDF43\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDF00-\uDF44\uDF50\uDF93-\uDF9F]|\uD82C[\uDC00\uDC01]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB]|\uD83A[\uDC00-\uDCC4]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1]|\uD87E[\uDC00-\uDE1D]/,
	    ID_Continue: /(?:[$0-9A-Z_a-z\xAA\xB5\xB7\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0300-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u0483-\u0487\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u05D0-\u05EA\u05F0-\u05F2\u0610-\u061A\u0620-\u0669\u066E-\u06D3\u06D5-\u06DC\u06DF-\u06E8\u06EA-\u06FC\u06FF\u0710-\u074A\u074D-\u07B1\u07C0-\u07F5\u07FA\u0800-\u082D\u0840-\u085B\u08A0-\u08B4\u08E3-\u0963\u0966-\u096F\u0971-\u0983\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BC-\u09C4\u09C7\u09C8\u09CB-\u09CE\u09D7\u09DC\u09DD\u09DF-\u09E3\u09E6-\u09F1\u0A01-\u0A03\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A59-\u0A5C\u0A5E\u0A66-\u0A75\u0A81-\u0A83\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABC-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AD0\u0AE0-\u0AE3\u0AE6-\u0AEF\u0AF9\u0B01-\u0B03\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3C-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B5C\u0B5D\u0B5F-\u0B63\u0B66-\u0B6F\u0B71\u0B82\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD0\u0BD7\u0BE6-\u0BEF\u0C00-\u0C03\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C58-\u0C5A\u0C60-\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBC-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CDE\u0CE0-\u0CE3\u0CE6-\u0CEF\u0CF1\u0CF2\u0D01-\u0D03\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D-\u0D44\u0D46-\u0D48\u0D4A-\u0D4E\u0D57\u0D5F-\u0D63\u0D66-\u0D6F\u0D7A-\u0D7F\u0D82\u0D83\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E01-\u0E3A\u0E40-\u0E4E\u0E50-\u0E59\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB9\u0EBB-\u0EBD\u0EC0-\u0EC4\u0EC6\u0EC8-\u0ECD\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E-\u0F47\u0F49-\u0F6C\u0F71-\u0F84\u0F86-\u0F97\u0F99-\u0FBC\u0FC6\u1000-\u1049\u1050-\u109D\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u135D-\u135F\u1369-\u1371\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1714\u1720-\u1734\u1740-\u1753\u1760-\u176C\u176E-\u1770\u1772\u1773\u1780-\u17D3\u17D7\u17DC\u17DD\u17E0-\u17E9\u180B-\u180D\u1810-\u1819\u1820-\u1877\u1880-\u18AA\u18B0-\u18F5\u1900-\u191E\u1920-\u192B\u1930-\u193B\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19DA\u1A00-\u1A1B\u1A20-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AA7\u1AB0-\u1ABD\u1B00-\u1B4B\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1BF3\u1C00-\u1C37\u1C40-\u1C49\u1C4D-\u1C7D\u1CD0-\u1CD2\u1CD4-\u1CF6\u1CF8\u1CF9\u1D00-\u1DF5\u1DFC-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u200C\u200D\u203F\u2040\u2054\u2071\u207F\u2090-\u209C\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D7F-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2DE0-\u2DFF\u3005-\u3007\u3021-\u302F\u3031-\u3035\u3038-\u303C\u3041-\u3096\u3099-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FD5\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA62B\uA640-\uA66F\uA674-\uA67D\uA67F-\uA6F1\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AD\uA7B0-\uA7B7\uA7F7-\uA827\uA840-\uA873\uA880-\uA8C4\uA8D0-\uA8D9\uA8E0-\uA8F7\uA8FB\uA8FD\uA900-\uA92D\uA930-\uA953\uA960-\uA97C\uA980-\uA9C0\uA9CF-\uA9D9\uA9E0-\uA9FE\uAA00-\uAA36\uAA40-\uAA4D\uAA50-\uAA59\uAA60-\uAA76\uAA7A-\uAAC2\uAADB-\uAADD\uAAE0-\uAAEF\uAAF2-\uAAF6\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABEA\uABEC\uABED\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE00-\uFE0F\uFE20-\uFE2F\uFE33\uFE34\uFE4D-\uFE4F\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\uFF21-\uFF3A\uFF3F\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD40-\uDD74\uDDFD\uDE80-\uDE9C\uDEA0-\uDED0\uDEE0\uDF00-\uDF1F\uDF30-\uDF4A\uDF50-\uDF7A\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDCA0-\uDCA9\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDCE0-\uDCF2\uDCF4\uDCF5\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00-\uDE03\uDE05\uDE06\uDE0C-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE38-\uDE3A\uDE3F\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE6\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2]|\uD804[\uDC00-\uDC46\uDC66-\uDC6F\uDC7F-\uDCBA\uDCD0-\uDCE8\uDCF0-\uDCF9\uDD00-\uDD34\uDD36-\uDD3F\uDD50-\uDD73\uDD76\uDD80-\uDDC4\uDDCA-\uDDCC\uDDD0-\uDDDA\uDDDC\uDE00-\uDE11\uDE13-\uDE37\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEEA\uDEF0-\uDEF9\uDF00-\uDF03\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3C-\uDF44\uDF47\uDF48\uDF4B-\uDF4D\uDF50\uDF57\uDF5D-\uDF63\uDF66-\uDF6C\uDF70-\uDF74]|\uD805[\uDC80-\uDCC5\uDCC7\uDCD0-\uDCD9\uDD80-\uDDB5\uDDB8-\uDDC0\uDDD8-\uDDDD\uDE00-\uDE40\uDE44\uDE50-\uDE59\uDE80-\uDEB7\uDEC0-\uDEC9\uDF00-\uDF19\uDF1D-\uDF2B\uDF30-\uDF39]|\uD806[\uDCA0-\uDCE9\uDCFF\uDEC0-\uDEF8]|\uD808[\uDC00-\uDF99]|\uD809[\uDC00-\uDC6E\uDC80-\uDD43]|[\uD80C\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD811[\uDC00-\uDE46]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDE60-\uDE69\uDED0-\uDEED\uDEF0-\uDEF4\uDF00-\uDF36\uDF40-\uDF43\uDF50-\uDF59\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDF00-\uDF44\uDF50-\uDF7E\uDF8F-\uDF9F]|\uD82C[\uDC00\uDC01]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99\uDC9D\uDC9E]|\uD834[\uDD65-\uDD69\uDD6D-\uDD72\uDD7B-\uDD82\uDD85-\uDD8B\uDDAA-\uDDAD\uDE42-\uDE44]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB\uDFCE-\uDFFF]|\uD836[\uDE00-\uDE36\uDE3B-\uDE6C\uDE75\uDE84\uDE9B-\uDE9F\uDEA1-\uDEAF]|\uD83A[\uDC00-\uDCC4\uDCD0-\uDCD6]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1]|\uD87E[\uDC00-\uDE1D]|\uDB40[\uDD00-\uDDEF])+/,
	};

	function get_full_char(str, pos) {
	    if (is_surrogate_pair_head(str.charCodeAt(pos))) {
	        if (is_surrogate_pair_tail(str.charCodeAt(pos + 1))) {
	            return str.charAt(pos) + str.charAt(pos + 1);
	        }
	    } else if (is_surrogate_pair_tail(str.charCodeAt(pos))) {
	        if (is_surrogate_pair_head(str.charCodeAt(pos - 1))) {
	            return str.charAt(pos - 1) + str.charAt(pos);
	        }
	    }
	    return str.charAt(pos);
	}

	function get_full_char_code(str, pos) {
	    // https://en.wikipedia.org/wiki/Universal_Character_Set_characters#Surrogates
	    if (is_surrogate_pair_head(str.charCodeAt(pos))) {
	        return 0x10000 + (str.charCodeAt(pos) - 0xd800 << 10) + str.charCodeAt(pos + 1) - 0xdc00;
	    }
	    return str.charCodeAt(pos);
	}

	function get_full_char_length(str) {
	    var surrogates = 0;

	    for (var i = 0; i < str.length; i++) {
	        if (is_surrogate_pair_head(str.charCodeAt(i)) && is_surrogate_pair_tail(str.charCodeAt(i + 1))) {
	            surrogates++;
	            i++;
	        }
	    }

	    return str.length - surrogates;
	}

	function from_char_code(code) {
	    // Based on https://github.com/mathiasbynens/String.fromCodePoint/blob/master/fromcodepoint.js
	    if (code > 0xFFFF) {
	        code -= 0x10000;
	        return (String.fromCharCode((code >> 10) + 0xD800) +
	            String.fromCharCode((code % 0x400) + 0xDC00));
	    }
	    return String.fromCharCode(code);
	}

	function is_surrogate_pair_head(code) {
	    return code >= 0xd800 && code <= 0xdbff;
	}

	function is_surrogate_pair_tail(code) {
	    return code >= 0xdc00 && code <= 0xdfff;
	}

	function is_digit(code) {
	    return code >= 48 && code <= 57;
	}

	function is_identifier_start(ch) {
	    return UNICODE.ID_Start.test(ch);
	}

	function is_identifier_char(ch) {
	    return UNICODE.ID_Continue.test(ch);
	}

	const BASIC_IDENT = /^[a-z_$][a-z0-9_$]*$/i;

	function is_basic_identifier_string(str) {
	    return BASIC_IDENT.test(str);
	}

	function is_identifier_string(str, allow_surrogates) {
	    if (BASIC_IDENT.test(str)) {
	        return true;
	    }
	    if (!allow_surrogates && /[\ud800-\udfff]/.test(str)) {
	        return false;
	    }
	    var match = UNICODE.ID_Start.exec(str);
	    if (!match || match.index !== 0) {
	        return false;
	    }

	    str = str.slice(match[0].length);
	    if (!str) {
	        return true;
	    }

	    match = UNICODE.ID_Continue.exec(str);
	    return !!match && match[0].length === str.length;
	}

	function parse_js_number(num, allow_e = true) {
	    if (!allow_e && num.includes("e")) {
	        return NaN;
	    }
	    if (RE_HEX_NUMBER.test(num)) {
	        return parseInt(num.substr(2), 16);
	    } else if (RE_OCT_NUMBER.test(num)) {
	        return parseInt(num.substr(1), 8);
	    } else if (RE_ES6_OCT_NUMBER.test(num)) {
	        return parseInt(num.substr(2), 8);
	    } else if (RE_BIN_NUMBER.test(num)) {
	        return parseInt(num.substr(2), 2);
	    } else if (RE_DEC_NUMBER.test(num)) {
	        return parseFloat(num);
	    } else {
	        var val = parseFloat(num);
	        if (val == num) return val;
	    }
	}

	class JS_Parse_Error extends Error {
	    constructor(message, filename, line, col, pos) {
	        super();

	        this.name = "SyntaxError";
	        this.message = message;
	        this.filename = filename;
	        this.line = line;
	        this.col = col;
	        this.pos = pos;
	    }
	}

	function js_error(message, filename, line, col, pos) {
	    throw new JS_Parse_Error(message, filename, line, col, pos);
	}

	function is_token(token, type, val) {
	    return token.type == type && (val == null || token.value == val);
	}

	var EX_EOF = {};

	function tokenizer($TEXT, filename, html5_comments, shebang) {
	    var S = {
	        text            : $TEXT,
	        filename        : filename,
	        pos             : 0,
	        tokpos          : 0,
	        line            : 1,
	        tokline         : 0,
	        col             : 0,
	        tokcol          : 0,
	        newline_before  : false,
	        regex_allowed   : false,
	        brace_counter   : 0,
	        template_braces : [],
	        comments_before : [],
	        directives      : {},
	        directive_stack : []
	    };

	    function peek() { return get_full_char(S.text, S.pos); }

	    // Used because parsing ?. involves a lookahead for a digit
	    function is_option_chain_op() {
	        const must_be_dot = S.text.charCodeAt(S.pos + 1) === 46;
	        if (!must_be_dot) return false;

	        const cannot_be_digit = S.text.charCodeAt(S.pos + 2);
	        return cannot_be_digit < 48 || cannot_be_digit > 57;
	    }

	    function next(signal_eof, in_string) {
	        var ch = get_full_char(S.text, S.pos++);
	        if (signal_eof && !ch)
	            throw EX_EOF;
	        if (NEWLINE_CHARS.has(ch)) {
	            S.newline_before = S.newline_before || !in_string;
	            ++S.line;
	            S.col = 0;
	            if (ch == "\r" && peek() == "\n") {
	                // treat a \r\n sequence as a single \n
	                ++S.pos;
	                ch = "\n";
	            }
	        } else {
	            if (ch.length > 1) {
	                ++S.pos;
	                ++S.col;
	            }
	            ++S.col;
	        }
	        return ch;
	    }

	    function forward(i) {
	        while (i--) next();
	    }

	    function looking_at(str) {
	        return S.text.substr(S.pos, str.length) == str;
	    }

	    function find_eol() {
	        var text = S.text;
	        for (var i = S.pos, n = S.text.length; i < n; ++i) {
	            var ch = text[i];
	            if (NEWLINE_CHARS.has(ch))
	                return i;
	        }
	        return -1;
	    }

	    function find(what, signal_eof) {
	        var pos = S.text.indexOf(what, S.pos);
	        if (pos == -1) throw EX_EOF;
	        return pos;
	    }

	    function start_token() {
	        S.tokline = S.line;
	        S.tokcol = S.col;
	        S.tokpos = S.pos;
	    }

	    var prev_was_dot = false;
	    var previous_token = null;
	    function token(type, value, is_comment) {
	        S.regex_allowed = ((type == "operator" && !UNARY_POSTFIX.has(value)) ||
	                           (type == "keyword" && KEYWORDS_BEFORE_EXPRESSION.has(value)) ||
	                           (type == "punc" && PUNC_BEFORE_EXPRESSION.has(value))) ||
	                           (type == "arrow");
	        if (type == "punc" && (value == "." || value == "?.")) {
	            prev_was_dot = true;
	        } else if (!is_comment) {
	            prev_was_dot = false;
	        }
	        const line     = S.tokline;
	        const col      = S.tokcol;
	        const pos      = S.tokpos;
	        const nlb      = S.newline_before;
	        const file     = filename;
	        let comments_before = [];
	        let comments_after  = [];

	        if (!is_comment) {
	            comments_before = S.comments_before;
	            comments_after = S.comments_before = [];
	        }
	        S.newline_before = false;
	        const tok = new AST_Token(type, value, line, col, pos, nlb, comments_before, comments_after, file);

	        if (!is_comment) previous_token = tok;
	        return tok;
	    }

	    function skip_whitespace() {
	        while (WHITESPACE_CHARS.has(peek()))
	            next();
	    }

	    function read_while(pred) {
	        var ret = "", ch, i = 0;
	        while ((ch = peek()) && pred(ch, i++))
	            ret += next();
	        return ret;
	    }

	    function parse_error(err) {
	        js_error(err, filename, S.tokline, S.tokcol, S.tokpos);
	    }

	    function read_num(prefix) {
	        var has_e = false, after_e = false, has_x = false, has_dot = prefix == ".", is_big_int = false, numeric_separator = false;
	        var num = read_while(function(ch, i) {
	            if (is_big_int) return false;

	            var code = ch.charCodeAt(0);
	            switch (code) {
	              case 95: // _
	                return (numeric_separator = true);
	              case 98: case 66: // bB
	                return (has_x = true); // Can occur in hex sequence, don't return false yet
	              case 111: case 79: // oO
	              case 120: case 88: // xX
	                return has_x ? false : (has_x = true);
	              case 101: case 69: // eE
	                return has_x ? true : has_e ? false : (has_e = after_e = true);
	              case 45: // -
	                return after_e || (i == 0 && !prefix);
	              case 43: // +
	                return after_e;
	              case (after_e = false, 46): // .
	                return (!has_dot && !has_x && !has_e) ? (has_dot = true) : false;
	              case 110: // n
	                is_big_int = true;
	                return true;
	            }

	            return (
	                code >= 48 && code <= 57 // 0-9
	                || code >= 97 && code <= 102 // a-f
	                || code >= 65 && code <= 70 // A-F
	            );
	        });
	        if (prefix) num = prefix + num;

	        LATEST_RAW = num;

	        if (RE_OCT_NUMBER.test(num) && next_token.has_directive("use strict")) {
	            parse_error("Legacy octal literals are not allowed in strict mode");
	        }
	        if (numeric_separator) {
	            if (num.endsWith("_")) {
	                parse_error("Numeric separators are not allowed at the end of numeric literals");
	            } else if (num.includes("__")) {
	                parse_error("Only one underscore is allowed as numeric separator");
	            }
	            num = num.replace(/_/g, "");
	        }
	        if (is_big_int) {
	            const without_n = num.slice(0, -1);
	            const allow_e = RE_HEX_NUMBER.test(without_n);
	            const valid = parse_js_number(without_n, allow_e);
	            if (!has_dot && RE_BIG_INT.test(num) && !isNaN(valid))
	                return token("big_int", without_n);
	            parse_error("Invalid or unexpected token");
	        }
	        var valid = parse_js_number(num);
	        if (!isNaN(valid)) {
	            return token("num", valid);
	        } else {
	            parse_error("Invalid syntax: " + num);
	        }
	    }

	    function is_octal(ch) {
	        return ch >= "0" && ch <= "7";
	    }

	    function read_escaped_char(in_string, strict_hex, template_string) {
	        var ch = next(true, in_string);
	        switch (ch.charCodeAt(0)) {
	          case 110 : return "\n";
	          case 114 : return "\r";
	          case 116 : return "\t";
	          case 98  : return "\b";
	          case 118 : return "\u000b"; // \v
	          case 102 : return "\f";
	          case 120 : return String.fromCharCode(hex_bytes(2, strict_hex)); // \x
	          case 117 : // \u
	            if (peek() == "{") {
	                next(true);
	                if (peek() === "}")
	                    parse_error("Expecting hex-character between {}");
	                while (peek() == "0") next(true); // No significance
	                var result, length = find("}") - S.pos;
	                // Avoid 32 bit integer overflow (1 << 32 === 1)
	                // We know first character isn't 0 and thus out of range anyway
	                if (length > 6 || (result = hex_bytes(length, strict_hex)) > 0x10FFFF) {
	                    parse_error("Unicode reference out of bounds");
	                }
	                next(true);
	                return from_char_code(result);
	            }
	            return String.fromCharCode(hex_bytes(4, strict_hex));
	          case 10  : return ""; // newline
	          case 13  :            // \r
	            if (peek() == "\n") { // DOS newline
	                next(true, in_string);
	                return "";
	            }
	        }
	        if (is_octal(ch)) {
	            if (template_string && strict_hex) {
	                const represents_null_character = ch === "0" && !is_octal(peek());
	                if (!represents_null_character) {
	                    parse_error("Octal escape sequences are not allowed in template strings");
	                }
	            }
	            return read_octal_escape_sequence(ch, strict_hex);
	        }
	        return ch;
	    }

	    function read_octal_escape_sequence(ch, strict_octal) {
	        // Read
	        var p = peek();
	        if (p >= "0" && p <= "7") {
	            ch += next(true);
	            if (ch[0] <= "3" && (p = peek()) >= "0" && p <= "7")
	                ch += next(true);
	        }

	        // Parse
	        if (ch === "0") return "\0";
	        if (ch.length > 0 && next_token.has_directive("use strict") && strict_octal)
	            parse_error("Legacy octal escape sequences are not allowed in strict mode");
	        return String.fromCharCode(parseInt(ch, 8));
	    }

	    function hex_bytes(n, strict_hex) {
	        var num = 0;
	        for (; n > 0; --n) {
	            if (!strict_hex && isNaN(parseInt(peek(), 16))) {
	                return parseInt(num, 16) || "";
	            }
	            var digit = next(true);
	            if (isNaN(parseInt(digit, 16)))
	                parse_error("Invalid hex-character pattern in string");
	            num += digit;
	        }
	        return parseInt(num, 16);
	    }

	    var read_string = with_eof_error("Unterminated string constant", function() {
	        const start_pos = S.pos;
	        var quote = next(), ret = [];
	        for (;;) {
	            var ch = next(true, true);
	            if (ch == "\\") ch = read_escaped_char(true, true);
	            else if (ch == "\r" || ch == "\n") parse_error("Unterminated string constant");
	            else if (ch == quote) break;
	            ret.push(ch);
	        }
	        var tok = token("string", ret.join(""));
	        LATEST_RAW = S.text.slice(start_pos, S.pos);
	        tok.quote = quote;
	        return tok;
	    });

	    var read_template_characters = with_eof_error("Unterminated template", function(begin) {
	        if (begin) {
	            S.template_braces.push(S.brace_counter);
	        }
	        var content = "", raw = "", ch, tok;
	        next(true, true);
	        while ((ch = next(true, true)) != "`") {
	            if (ch == "\r") {
	                if (peek() == "\n") ++S.pos;
	                ch = "\n";
	            } else if (ch == "$" && peek() == "{") {
	                next(true, true);
	                S.brace_counter++;
	                tok = token(begin ? "template_head" : "template_cont", content);
	                TEMPLATE_RAWS.set(tok, raw);
	                tok.template_end = false;
	                return tok;
	            }

	            raw += ch;
	            if (ch == "\\") {
	                var tmp = S.pos;
	                var prev_is_tag = previous_token && (previous_token.type === "name" || previous_token.type === "punc" && (previous_token.value === ")" || previous_token.value === "]"));
	                ch = read_escaped_char(true, !prev_is_tag, true);
	                raw += S.text.substr(tmp, S.pos - tmp);
	            }

	            content += ch;
	        }
	        S.template_braces.pop();
	        tok = token(begin ? "template_head" : "template_cont", content);
	        TEMPLATE_RAWS.set(tok, raw);
	        tok.template_end = true;
	        return tok;
	    });

	    function skip_line_comment(type) {
	        var regex_allowed = S.regex_allowed;
	        var i = find_eol(), ret;
	        if (i == -1) {
	            ret = S.text.substr(S.pos);
	            S.pos = S.text.length;
	        } else {
	            ret = S.text.substring(S.pos, i);
	            S.pos = i;
	        }
	        S.col = S.tokcol + (S.pos - S.tokpos);
	        S.comments_before.push(token(type, ret, true));
	        S.regex_allowed = regex_allowed;
	        return next_token;
	    }

	    var skip_multiline_comment = with_eof_error("Unterminated multiline comment", function() {
	        var regex_allowed = S.regex_allowed;
	        var i = find("*/", true);
	        var text = S.text.substring(S.pos, i).replace(/\r\n|\r|\u2028|\u2029/g, "\n");
	        // update stream position
	        forward(get_full_char_length(text) /* text length doesn't count \r\n as 2 char while S.pos - i does */ + 2);
	        S.comments_before.push(token("comment2", text, true));
	        S.newline_before = S.newline_before || text.includes("\n");
	        S.regex_allowed = regex_allowed;
	        return next_token;
	    });

	    var read_name = function () {
	        let start = S.pos, end = start - 1, ch = "c";

	        while (
	            (ch = S.text.charAt(++end))
	            && (ch >= "a" && ch <= "z" || ch >= "A" && ch <= "Z")
	        );

	        if (end > start + 1 && ch && ch !== "\\" && !is_identifier_char(ch)) {
	            S.pos += end - start;
	            S.col += end - start;
	            return S.text.slice(start, S.pos);
	        }

	        return read_name_hard();
	    };

	    var read_name_hard = with_eof_error("Unterminated identifier name", function() {
	        var name = [], ch, escaped = false;
	        var read_escaped_identifier_char = function() {
	            escaped = true;
	            next();
	            if (peek() !== "u") {
	                parse_error("Expecting UnicodeEscapeSequence -- uXXXX or u{XXXX}");
	            }
	            return read_escaped_char(false, true);
	        };

	        // Read first character (ID_Start)
	        if ((ch = peek()) === "\\") {
	            ch = read_escaped_identifier_char();
	            if (!is_identifier_start(ch)) {
	                parse_error("First identifier char is an invalid identifier char");
	            }
	        } else if (is_identifier_start(ch)) {
	            next();
	        } else {
	            return "";
	        }

	        name.push(ch);

	        // Read ID_Continue
	        while ((ch = peek()) != null) {
	            if ((ch = peek()) === "\\") {
	                ch = read_escaped_identifier_char();
	                if (!is_identifier_char(ch)) {
	                    parse_error("Invalid escaped identifier char");
	                }
	            } else {
	                if (!is_identifier_char(ch)) {
	                    break;
	                }
	                next();
	            }
	            name.push(ch);
	        }
	        const name_str = name.join("");
	        if (RESERVED_WORDS.has(name_str) && escaped) {
	            parse_error("Escaped characters are not allowed in keywords");
	        }
	        return name_str;
	    });

	    var read_regexp = with_eof_error("Unterminated regular expression", function(source) {
	        var prev_backslash = false, ch, in_class = false;
	        while ((ch = next(true))) if (NEWLINE_CHARS.has(ch)) {
	            parse_error("Unexpected line terminator");
	        } else if (prev_backslash) {
	            if (/^[\u0000-\u007F]$/.test(ch)) {
	                source += "\\" + ch;
	            } else {
	                // Remove the useless slash before the escape, but only for characters that won't be added to regexp syntax
	                source += ch;
	            }
	            prev_backslash = false;
	        } else if (ch == "[") {
	            in_class = true;
	            source += ch;
	        } else if (ch == "]" && in_class) {
	            in_class = false;
	            source += ch;
	        } else if (ch == "/" && !in_class) {
	            break;
	        } else if (ch == "\\") {
	            prev_backslash = true;
	        } else {
	            source += ch;
	        }
	        const flags = read_name();
	        return token("regexp", "/" + source + "/" + flags);
	    });

	    function read_operator(prefix) {
	        function grow(op) {
	            if (!peek()) return op;
	            var bigger = op + peek();
	            if (OPERATORS.has(bigger)) {
	                next();
	                return grow(bigger);
	            } else {
	                return op;
	            }
	        }
	        return token("operator", grow(prefix || next()));
	    }

	    function handle_slash() {
	        next();
	        switch (peek()) {
	          case "/":
	            next();
	            return skip_line_comment("comment1");
	          case "*":
	            next();
	            return skip_multiline_comment();
	        }
	        return S.regex_allowed ? read_regexp("") : read_operator("/");
	    }

	    function handle_eq_sign() {
	        next();
	        if (peek() === ">") {
	            next();
	            return token("arrow", "=>");
	        } else {
	            return read_operator("=");
	        }
	    }

	    function handle_dot() {
	        next();
	        if (is_digit(peek().charCodeAt(0))) {
	            return read_num(".");
	        }
	        if (peek() === ".") {
	            next();  // Consume second dot
	            next();  // Consume third dot
	            return token("expand", "...");
	        }

	        return token("punc", ".");
	    }

	    function read_word() {
	        var word = read_name();
	        if (prev_was_dot) return token("name", word);
	        return KEYWORDS_ATOM.has(word) ? token("atom", word)
	            : !KEYWORDS.has(word) ? token("name", word)
	            : OPERATORS.has(word) ? token("operator", word)
	            : token("keyword", word);
	    }

	    function read_private_word() {
	        next();
	        return token("privatename", read_name());
	    }

	    function with_eof_error(eof_error, cont) {
	        return function(x) {
	            try {
	                return cont(x);
	            } catch(ex) {
	                if (ex === EX_EOF) parse_error(eof_error);
	                else throw ex;
	            }
	        };
	    }

	    function next_token(force_regexp) {
	        if (force_regexp != null)
	            return read_regexp(force_regexp);
	        if (shebang && S.pos == 0 && looking_at("#!")) {
	            start_token();
	            forward(2);
	            skip_line_comment("comment5");
	        }
	        for (;;) {
	            skip_whitespace();
	            start_token();
	            if (html5_comments) {
	                if (looking_at("<!--")) {
	                    forward(4);
	                    skip_line_comment("comment3");
	                    continue;
	                }
	                if (looking_at("-->") && S.newline_before) {
	                    forward(3);
	                    skip_line_comment("comment4");
	                    continue;
	                }
	            }
	            var ch = peek();
	            if (!ch) return token("eof");
	            var code = ch.charCodeAt(0);
	            switch (code) {
	              case 34: case 39: return read_string();
	              case 46: return handle_dot();
	              case 47: {
	                  var tok = handle_slash();
	                  if (tok === next_token) continue;
	                  return tok;
	              }
	              case 61: return handle_eq_sign();
	              case 63: {
	                  if (!is_option_chain_op()) break;  // Handled below

	                  next(); // ?
	                  next(); // .

	                  return token("punc", "?.");
	              }
	              case 96: return read_template_characters(true);
	              case 123:
	                S.brace_counter++;
	                break;
	              case 125:
	                S.brace_counter--;
	                if (S.template_braces.length > 0
	                    && S.template_braces[S.template_braces.length - 1] === S.brace_counter)
	                    return read_template_characters(false);
	                break;
	            }
	            if (is_digit(code)) return read_num();
	            if (PUNC_CHARS.has(ch)) return token("punc", next());
	            if (OPERATOR_CHARS.has(ch)) return read_operator();
	            if (code == 92 || is_identifier_start(ch)) return read_word();
	            if (code == 35) return read_private_word();
	            break;
	        }
	        parse_error("Unexpected character '" + ch + "'");
	    }

	    next_token.next = next;
	    next_token.peek = peek;

	    next_token.context = function(nc) {
	        if (nc) S = nc;
	        return S;
	    };

	    next_token.add_directive = function(directive) {
	        S.directive_stack[S.directive_stack.length - 1].push(directive);

	        if (S.directives[directive] === undefined) {
	            S.directives[directive] = 1;
	        } else {
	            S.directives[directive]++;
	        }
	    };

	    next_token.push_directives_stack = function() {
	        S.directive_stack.push([]);
	    };

	    next_token.pop_directives_stack = function() {
	        var directives = S.directive_stack[S.directive_stack.length - 1];

	        for (var i = 0; i < directives.length; i++) {
	            S.directives[directives[i]]--;
	        }

	        S.directive_stack.pop();
	    };

	    next_token.has_directive = function(directive) {
	        return S.directives[directive] > 0;
	    };

	    return next_token;

	}

	/* -----[ Parser (constants) ]----- */

	var UNARY_PREFIX = makePredicate([
	    "typeof",
	    "void",
	    "delete",
	    "--",
	    "++",
	    "!",
	    "~",
	    "-",
	    "+"
	]);

	var UNARY_POSTFIX = makePredicate([ "--", "++" ]);

	var ASSIGNMENT = makePredicate([ "=", "+=", "-=", "??=", "&&=", "||=", "/=", "*=", "**=", "%=", ">>=", "<<=", ">>>=", "|=", "^=", "&=" ]);

	var LOGICAL_ASSIGNMENT = makePredicate([ "??=", "&&=", "||=" ]);

	var PRECEDENCE = (function(a, ret) {
	    for (var i = 0; i < a.length; ++i) {
	        for (const op of a[i]) {
	            ret[op] = i + 1;
	        }
	    }
	    return ret;
	})(
	    [
	        ["||"],
	        ["??"],
	        ["&&"],
	        ["|"],
	        ["^"],
	        ["&"],
	        ["==", "===", "!=", "!=="],
	        ["<", ">", "<=", ">=", "in", "instanceof"],
	        [">>", "<<", ">>>"],
	        ["+", "-"],
	        ["*", "/", "%"],
	        ["**"]
	    ],
	    {}
	);

	var ATOMIC_START_TOKEN = makePredicate([ "atom", "num", "big_int", "string", "regexp", "name"]);

	/* -----[ Parser ]----- */

	function parse($TEXT, options) {
	    // maps start tokens to count of comments found outside of their parens
	    // Example: /* I count */ ( /* I don't */ foo() )
	    // Useful because comments_before property of call with parens outside
	    // contains both comments inside and outside these parens. Used to find the
	    
	    const outer_comments_before_counts = new WeakMap();

	    options = defaults(options, {
	        bare_returns   : false,
	        ecma           : null,  // Legacy
	        expression     : false,
	        filename       : null,
	        html5_comments : true,
	        module         : false,
	        shebang        : true,
	        strict         : false,
	        toplevel       : null,
	    }, true);

	    var S = {
	        input         : (typeof $TEXT == "string"
	                         ? tokenizer($TEXT, options.filename,
	                                     options.html5_comments, options.shebang)
	                         : $TEXT),
	        token         : null,
	        prev          : null,
	        peeked        : null,
	        in_function   : 0,
	        in_async      : -1,
	        in_generator  : -1,
	        in_directives : true,
	        in_loop       : 0,
	        labels        : []
	    };

	    S.token = next();

	    function is(type, value) {
	        return is_token(S.token, type, value);
	    }

	    function peek() { return S.peeked || (S.peeked = S.input()); }

	    function next() {
	        S.prev = S.token;

	        if (!S.peeked) peek();
	        S.token = S.peeked;
	        S.peeked = null;
	        S.in_directives = S.in_directives && (
	            S.token.type == "string" || is("punc", ";")
	        );
	        return S.token;
	    }

	    function prev() {
	        return S.prev;
	    }

	    function croak(msg, line, col, pos) {
	        var ctx = S.input.context();
	        js_error(msg,
	                 ctx.filename,
	                 line != null ? line : ctx.tokline,
	                 col != null ? col : ctx.tokcol,
	                 pos != null ? pos : ctx.tokpos);
	    }

	    function token_error(token, msg) {
	        croak(msg, token.line, token.col);
	    }

	    function unexpected(token) {
	        if (token == null)
	            token = S.token;
	        token_error(token, "Unexpected token: " + token.type + " (" + token.value + ")");
	    }

	    function expect_token(type, val) {
	        if (is(type, val)) {
	            return next();
	        }
	        token_error(S.token, "Unexpected token " + S.token.type + " «" + S.token.value + "»" + ", expected " + type + " «" + val + "»");
	    }

	    function expect(punc) { return expect_token("punc", punc); }

	    function has_newline_before(token) {
	        return token.nlb || !token.comments_before.every((comment) => !comment.nlb);
	    }

	    function can_insert_semicolon() {
	        return !options.strict
	            && (is("eof") || is("punc", "}") || has_newline_before(S.token));
	    }

	    function is_in_generator() {
	        return S.in_generator === S.in_function;
	    }

	    function is_in_async() {
	        return S.in_async === S.in_function;
	    }

	    function can_await() {
	        return (
	            S.in_async === S.in_function
	            || S.in_function === 0 && S.input.has_directive("use strict")
	        );
	    }

	    function semicolon(optional) {
	        if (is("punc", ";")) next();
	        else if (!optional && !can_insert_semicolon()) unexpected();
	    }

	    function parenthesised() {
	        expect("(");
	        var exp = expression(true);
	        expect(")");
	        return exp;
	    }

	    function embed_tokens(parser) {
	        return function _embed_tokens_wrapper(...args) {
	            const start = S.token;
	            const expr = parser(...args);
	            expr.start = start;
	            expr.end = prev();
	            return expr;
	        };
	    }

	    function handle_regexp() {
	        if (is("operator", "/") || is("operator", "/=")) {
	            S.peeked = null;
	            S.token = S.input(S.token.value.substr(1)); // force regexp
	        }
	    }

	    var statement = embed_tokens(function statement(is_export_default, is_for_body, is_if_body) {
	        handle_regexp();
	        switch (S.token.type) {
	          case "string":
	            if (S.in_directives) {
	                var token = peek();
	                if (!LATEST_RAW.includes("\\")
	                    && (is_token(token, "punc", ";")
	                        || is_token(token, "punc", "}")
	                        || has_newline_before(token)
	                        || is_token(token, "eof"))) {
	                    S.input.add_directive(S.token.value);
	                } else {
	                    S.in_directives = false;
	                }
	            }
	            var dir = S.in_directives, stat = simple_statement();
	            return dir && stat.body instanceof AST_String ? new AST_Directive(stat.body) : stat;
	          case "template_head":
	          case "num":
	          case "big_int":
	          case "regexp":
	          case "operator":
	          case "atom":
	            return simple_statement();

	          case "name":
	          case "privatename":
	            if(is("privatename") && !S.in_class)
	                croak("Private field must be used in an enclosing class");

	            if (S.token.value == "async" && is_token(peek(), "keyword", "function")) {
	                next();
	                next();
	                if (is_for_body) {
	                    croak("functions are not allowed as the body of a loop");
	                }
	                return function_(AST_Defun, false, true, is_export_default);
	            }
	            if (S.token.value == "import" && !is_token(peek(), "punc", "(") && !is_token(peek(), "punc", ".")) {
	                next();
	                var node = import_statement();
	                semicolon();
	                return node;
	            }
	            return is_token(peek(), "punc", ":")
	                ? labeled_statement()
	                : simple_statement();

	          case "punc":
	            switch (S.token.value) {
	              case "{":
	                return new AST_BlockStatement({
	                    start : S.token,
	                    body  : block_(),
	                    end   : prev()
	                });
	              case "[":
	              case "(":
	                return simple_statement();
	              case ";":
	                S.in_directives = false;
	                next();
	                return new AST_EmptyStatement();
	              default:
	                unexpected();
	            }

	          case "keyword":
	            switch (S.token.value) {
	              case "break":
	                next();
	                return break_cont(AST_Break);

	              case "continue":
	                next();
	                return break_cont(AST_Continue);

	              case "debugger":
	                next();
	                semicolon();
	                return new AST_Debugger();

	              case "do":
	                next();
	                var body = in_loop(statement);
	                expect_token("keyword", "while");
	                var condition = parenthesised();
	                semicolon(true);
	                return new AST_Do({
	                    body      : body,
	                    condition : condition
	                });

	              case "while":
	                next();
	                return new AST_While({
	                    condition : parenthesised(),
	                    body      : in_loop(function() { return statement(false, true); })
	                });

	              case "for":
	                next();
	                return for_();

	              case "class":
	                next();
	                if (is_for_body) {
	                    croak("classes are not allowed as the body of a loop");
	                }
	                if (is_if_body) {
	                    croak("classes are not allowed as the body of an if");
	                }
	                return class_(AST_DefClass, is_export_default);

	              case "function":
	                next();
	                if (is_for_body) {
	                    croak("functions are not allowed as the body of a loop");
	                }
	                return function_(AST_Defun, false, false, is_export_default);

	              case "if":
	                next();
	                return if_();

	              case "return":
	                if (S.in_function == 0 && !options.bare_returns)
	                    croak("'return' outside of function");
	                next();
	                var value = null;
	                if (is("punc", ";")) {
	                    next();
	                } else if (!can_insert_semicolon()) {
	                    value = expression(true);
	                    semicolon();
	                }
	                return new AST_Return({
	                    value: value
	                });

	              case "switch":
	                next();
	                return new AST_Switch({
	                    expression : parenthesised(),
	                    body       : in_loop(switch_body_)
	                });

	              case "throw":
	                next();
	                if (has_newline_before(S.token))
	                    croak("Illegal newline after 'throw'");
	                var value = expression(true);
	                semicolon();
	                return new AST_Throw({
	                    value: value
	                });

	              case "try":
	                next();
	                return try_();

	              case "var":
	                next();
	                var node = var_();
	                semicolon();
	                return node;

	              case "let":
	                next();
	                var node = let_();
	                semicolon();
	                return node;

	              case "const":
	                next();
	                var node = const_();
	                semicolon();
	                return node;

	              case "with":
	                if (S.input.has_directive("use strict")) {
	                    croak("Strict mode may not include a with statement");
	                }
	                next();
	                return new AST_With({
	                    expression : parenthesised(),
	                    body       : statement()
	                });

	              case "export":
	                if (!is_token(peek(), "punc", "(")) {
	                    next();
	                    var node = export_statement();
	                    if (is("punc", ";")) semicolon();
	                    return node;
	                }
	            }
	        }
	        unexpected();
	    });

	    function labeled_statement() {
	        var label = as_symbol(AST_Label);
	        if (label.name === "await" && is_in_async()) {
	            token_error(S.prev, "await cannot be used as label inside async function");
	        }
	        if (S.labels.some((l) => l.name === label.name)) {
	            // ECMA-262, 12.12: An ECMAScript program is considered
	            // syntactically incorrect if it contains a
	            // LabelledStatement that is enclosed by a
	            // LabelledStatement with the same Identifier as label.
	            croak("Label " + label.name + " defined twice");
	        }
	        expect(":");
	        S.labels.push(label);
	        var stat = statement();
	        S.labels.pop();
	        if (!(stat instanceof AST_IterationStatement)) {
	            // check for `continue` that refers to this label.
	            // those should be reported as syntax errors.
	            // https://github.com/mishoo/UglifyJS2/issues/287
	            label.references.forEach(function(ref) {
	                if (ref instanceof AST_Continue) {
	                    ref = ref.label.start;
	                    croak("Continue label `" + label.name + "` refers to non-IterationStatement.",
	                          ref.line, ref.col, ref.pos);
	                }
	            });
	        }
	        return new AST_LabeledStatement({ body: stat, label: label });
	    }

	    function simple_statement(tmp) {
	        return new AST_SimpleStatement({ body: (tmp = expression(true), semicolon(), tmp) });
	    }

	    function break_cont(type) {
	        var label = null, ldef;
	        if (!can_insert_semicolon()) {
	            label = as_symbol(AST_LabelRef, true);
	        }
	        if (label != null) {
	            ldef = S.labels.find((l) => l.name === label.name);
	            if (!ldef)
	                croak("Undefined label " + label.name);
	            label.thedef = ldef;
	        } else if (S.in_loop == 0)
	            croak(type.TYPE + " not inside a loop or switch");
	        semicolon();
	        var stat = new type({ label: label });
	        if (ldef) ldef.references.push(stat);
	        return stat;
	    }

	    function for_() {
	        var for_await_error = "`for await` invalid in this context";
	        var await_tok = S.token;
	        if (await_tok.type == "name" && await_tok.value == "await") {
	            if (!can_await()) {
	                token_error(await_tok, for_await_error);
	            }
	            next();
	        } else {
	            await_tok = false;
	        }
	        expect("(");
	        var init = null;
	        if (!is("punc", ";")) {
	            init =
	                is("keyword", "var") ? (next(), var_(true)) :
	                is("keyword", "let") ? (next(), let_(true)) :
	                is("keyword", "const") ? (next(), const_(true)) :
	                                       expression(true, true);
	            var is_in = is("operator", "in");
	            var is_of = is("name", "of");
	            if (await_tok && !is_of) {
	                token_error(await_tok, for_await_error);
	            }
	            if (is_in || is_of) {
	                if (init instanceof AST_Definitions) {
	                    if (init.definitions.length > 1)
	                        token_error(init.start, "Only one variable declaration allowed in for..in loop");
	                } else if (!(is_assignable(init) || (init = to_destructuring(init)) instanceof AST_Destructuring)) {
	                    token_error(init.start, "Invalid left-hand side in for..in loop");
	                }
	                next();
	                if (is_in) {
	                    return for_in(init);
	                } else {
	                    return for_of(init, !!await_tok);
	                }
	            }
	        } else if (await_tok) {
	            token_error(await_tok, for_await_error);
	        }
	        return regular_for(init);
	    }

	    function regular_for(init) {
	        expect(";");
	        var test = is("punc", ";") ? null : expression(true);
	        expect(";");
	        var step = is("punc", ")") ? null : expression(true);
	        expect(")");
	        return new AST_For({
	            init      : init,
	            condition : test,
	            step      : step,
	            body      : in_loop(function() { return statement(false, true); })
	        });
	    }

	    function for_of(init, is_await) {
	        var lhs = init instanceof AST_Definitions ? init.definitions[0].name : null;
	        var obj = expression(true);
	        expect(")");
	        return new AST_ForOf({
	            await  : is_await,
	            init   : init,
	            name   : lhs,
	            object : obj,
	            body   : in_loop(function() { return statement(false, true); })
	        });
	    }

	    function for_in(init) {
	        var obj = expression(true);
	        expect(")");
	        return new AST_ForIn({
	            init   : init,
	            object : obj,
	            body   : in_loop(function() { return statement(false, true); })
	        });
	    }

	    var arrow_function = function(start, argnames, is_async) {
	        if (has_newline_before(S.token)) {
	            croak("Unexpected newline before arrow (=>)");
	        }

	        expect_token("arrow", "=>");

	        var body = _function_body(is("punc", "{"), false, is_async);

	        return new AST_Arrow({
	            start    : start,
	            end      : body.end,
	            async    : is_async,
	            argnames : argnames,
	            body     : body
	        });
	    };

	    var function_ = function(ctor, is_generator, is_async, is_export_default) {
	        var in_statement = ctor === AST_Defun;
	        if (is("operator", "*")) {
	            is_generator = true;
	            next();
	        }

	        var name = is("name") ? as_symbol(in_statement ? AST_SymbolDefun : AST_SymbolLambda) : null;
	        if (in_statement && !name) {
	            if (is_export_default) {
	                ctor = AST_Function;
	            } else {
	                unexpected();
	            }
	        }

	        if (name && ctor !== AST_Accessor && !(name instanceof AST_SymbolDeclaration))
	            unexpected(prev());

	        var args = [];
	        var body = _function_body(true, is_generator, is_async, name, args);
	        return new ctor({
	            start : args.start,
	            end   : body.end,
	            is_generator: is_generator,
	            async : is_async,
	            name  : name,
	            argnames: args,
	            body  : body
	        });
	    };

	    class UsedParametersTracker {
	        constructor(is_parameter, strict, duplicates_ok = false) {
	            this.is_parameter = is_parameter;
	            this.duplicates_ok = duplicates_ok;
	            this.parameters = new Set();
	            this.duplicate = null;
	            this.default_assignment = false;
	            this.spread = false;
	            this.strict_mode = !!strict;
	        }
	        add_parameter(token) {
	            if (this.parameters.has(token.value)) {
	                if (this.duplicate === null) {
	                    this.duplicate = token;
	                }
	                this.check_strict();
	            } else {
	                this.parameters.add(token.value);
	                if (this.is_parameter) {
	                    switch (token.value) {
	                      case "arguments":
	                      case "eval":
	                      case "yield":
	                        if (this.strict_mode) {
	                            token_error(token, "Unexpected " + token.value + " identifier as parameter inside strict mode");
	                        }
	                        break;
	                      default:
	                        if (RESERVED_WORDS.has(token.value)) {
	                            unexpected();
	                        }
	                    }
	                }
	            }
	        }
	        mark_default_assignment(token) {
	            if (this.default_assignment === false) {
	                this.default_assignment = token;
	            }
	        }
	        mark_spread(token) {
	            if (this.spread === false) {
	                this.spread = token;
	            }
	        }
	        mark_strict_mode() {
	            this.strict_mode = true;
	        }
	        is_strict() {
	            return this.default_assignment !== false || this.spread !== false || this.strict_mode;
	        }
	        check_strict() {
	            if (this.is_strict() && this.duplicate !== null && !this.duplicates_ok) {
	                token_error(this.duplicate, "Parameter " + this.duplicate.value + " was used already");
	            }
	        }
	    }

	    function parameters(params) {
	        var used_parameters = new UsedParametersTracker(true, S.input.has_directive("use strict"));

	        expect("(");

	        while (!is("punc", ")")) {
	            var param = parameter(used_parameters);
	            params.push(param);

	            if (!is("punc", ")")) {
	                expect(",");
	            }

	            if (param instanceof AST_Expansion) {
	                break;
	            }
	        }

	        next();
	    }

	    function parameter(used_parameters, symbol_type) {
	        var param;
	        var expand = false;
	        if (used_parameters === undefined) {
	            used_parameters = new UsedParametersTracker(true, S.input.has_directive("use strict"));
	        }
	        if (is("expand", "...")) {
	            expand = S.token;
	            used_parameters.mark_spread(S.token);
	            next();
	        }
	        param = binding_element(used_parameters, symbol_type);

	        if (is("operator", "=") && expand === false) {
	            used_parameters.mark_default_assignment(S.token);
	            next();
	            param = new AST_DefaultAssign({
	                start: param.start,
	                left: param,
	                operator: "=",
	                right: expression(false),
	                end: S.token
	            });
	        }

	        if (expand !== false) {
	            if (!is("punc", ")")) {
	                unexpected();
	            }
	            param = new AST_Expansion({
	                start: expand,
	                expression: param,
	                end: expand
	            });
	        }
	        used_parameters.check_strict();

	        return param;
	    }

	    function binding_element(used_parameters, symbol_type) {
	        var elements = [];
	        var first = true;
	        var is_expand = false;
	        var expand_token;
	        var first_token = S.token;
	        if (used_parameters === undefined) {
	            const strict = S.input.has_directive("use strict");
	            const duplicates_ok = symbol_type === AST_SymbolVar;
	            used_parameters = new UsedParametersTracker(false, strict, duplicates_ok);
	        }
	        symbol_type = symbol_type === undefined ? AST_SymbolFunarg : symbol_type;
	        if (is("punc", "[")) {
	            next();
	            while (!is("punc", "]")) {
	                if (first) {
	                    first = false;
	                } else {
	                    expect(",");
	                }

	                if (is("expand", "...")) {
	                    is_expand = true;
	                    expand_token = S.token;
	                    used_parameters.mark_spread(S.token);
	                    next();
	                }
	                if (is("punc")) {
	                    switch (S.token.value) {
	                      case ",":
	                        elements.push(new AST_Hole({
	                            start: S.token,
	                            end: S.token
	                        }));
	                        continue;
	                      case "]": // Trailing comma after last element
	                        break;
	                      case "[":
	                      case "{":
	                        elements.push(binding_element(used_parameters, symbol_type));
	                        break;
	                      default:
	                        unexpected();
	                    }
	                } else if (is("name")) {
	                    used_parameters.add_parameter(S.token);
	                    elements.push(as_symbol(symbol_type));
	                } else {
	                    croak("Invalid function parameter");
	                }
	                if (is("operator", "=") && is_expand === false) {
	                    used_parameters.mark_default_assignment(S.token);
	                    next();
	                    elements[elements.length - 1] = new AST_DefaultAssign({
	                        start: elements[elements.length - 1].start,
	                        left: elements[elements.length - 1],
	                        operator: "=",
	                        right: expression(false),
	                        end: S.token
	                    });
	                }
	                if (is_expand) {
	                    if (!is("punc", "]")) {
	                        croak("Rest element must be last element");
	                    }
	                    elements[elements.length - 1] = new AST_Expansion({
	                        start: expand_token,
	                        expression: elements[elements.length - 1],
	                        end: expand_token
	                    });
	                }
	            }
	            expect("]");
	            used_parameters.check_strict();
	            return new AST_Destructuring({
	                start: first_token,
	                names: elements,
	                is_array: true,
	                end: prev()
	            });
	        } else if (is("punc", "{")) {
	            next();
	            while (!is("punc", "}")) {
	                if (first) {
	                    first = false;
	                } else {
	                    expect(",");
	                }
	                if (is("expand", "...")) {
	                    is_expand = true;
	                    expand_token = S.token;
	                    used_parameters.mark_spread(S.token);
	                    next();
	                }
	                if (is("name") && (is_token(peek(), "punc") || is_token(peek(), "operator")) && [",", "}", "="].includes(peek().value)) {
	                    used_parameters.add_parameter(S.token);
	                    var start = prev();
	                    var value = as_symbol(symbol_type);
	                    if (is_expand) {
	                        elements.push(new AST_Expansion({
	                            start: expand_token,
	                            expression: value,
	                            end: value.end,
	                        }));
	                    } else {
	                        elements.push(new AST_ObjectKeyVal({
	                            start: start,
	                            key: value.name,
	                            value: value,
	                            end: value.end,
	                        }));
	                    }
	                } else if (is("punc", "}")) {
	                    continue; // Allow trailing hole
	                } else {
	                    var property_token = S.token;
	                    var property = as_property_name();
	                    if (property === null) {
	                        unexpected(prev());
	                    } else if (prev().type === "name" && !is("punc", ":")) {
	                        elements.push(new AST_ObjectKeyVal({
	                            start: prev(),
	                            key: property,
	                            value: new symbol_type({
	                                start: prev(),
	                                name: property,
	                                end: prev()
	                            }),
	                            end: prev()
	                        }));
	                    } else {
	                        expect(":");
	                        elements.push(new AST_ObjectKeyVal({
	                            start: property_token,
	                            quote: property_token.quote,
	                            key: property,
	                            value: binding_element(used_parameters, symbol_type),
	                            end: prev()
	                        }));
	                    }
	                }
	                if (is_expand) {
	                    if (!is("punc", "}")) {
	                        croak("Rest element must be last element");
	                    }
	                } else if (is("operator", "=")) {
	                    used_parameters.mark_default_assignment(S.token);
	                    next();
	                    elements[elements.length - 1].value = new AST_DefaultAssign({
	                        start: elements[elements.length - 1].value.start,
	                        left: elements[elements.length - 1].value,
	                        operator: "=",
	                        right: expression(false),
	                        end: S.token
	                    });
	                }
	            }
	            expect("}");
	            used_parameters.check_strict();
	            return new AST_Destructuring({
	                start: first_token,
	                names: elements,
	                is_array: false,
	                end: prev()
	            });
	        } else if (is("name")) {
	            used_parameters.add_parameter(S.token);
	            return as_symbol(symbol_type);
	        } else {
	            croak("Invalid function parameter");
	        }
	    }

	    function params_or_seq_(allow_arrows, maybe_sequence) {
	        var spread_token;
	        var invalid_sequence;
	        var trailing_comma;
	        var a = [];
	        expect("(");
	        while (!is("punc", ")")) {
	            if (spread_token) unexpected(spread_token);
	            if (is("expand", "...")) {
	                spread_token = S.token;
	                if (maybe_sequence) invalid_sequence = S.token;
	                next();
	                a.push(new AST_Expansion({
	                    start: prev(),
	                    expression: expression(),
	                    end: S.token,
	                }));
	            } else {
	                a.push(expression());
	            }
	            if (!is("punc", ")")) {
	                expect(",");
	                if (is("punc", ")")) {
	                    trailing_comma = prev();
	                    if (maybe_sequence) invalid_sequence = trailing_comma;
	                }
	            }
	        }
	        expect(")");
	        if (allow_arrows && is("arrow", "=>")) {
	            if (spread_token && trailing_comma) unexpected(trailing_comma);
	        } else if (invalid_sequence) {
	            unexpected(invalid_sequence);
	        }
	        return a;
	    }

	    function _function_body(block, generator, is_async, name, args) {
	        var loop = S.in_loop;
	        var labels = S.labels;
	        var current_generator = S.in_generator;
	        var current_async = S.in_async;
	        ++S.in_function;
	        if (generator)
	            S.in_generator = S.in_function;
	        if (is_async)
	            S.in_async = S.in_function;
	        if (args) parameters(args);
	        if (block)
	            S.in_directives = true;
	        S.in_loop = 0;
	        S.labels = [];
	        if (block) {
	            S.input.push_directives_stack();
	            var a = block_();
	            if (name) _verify_symbol(name);
	            if (args) args.forEach(_verify_symbol);
	            S.input.pop_directives_stack();
	        } else {
	            var a = [new AST_Return({
	                start: S.token,
	                value: expression(false),
	                end: S.token
	            })];
	        }
	        --S.in_function;
	        S.in_loop = loop;
	        S.labels = labels;
	        S.in_generator = current_generator;
	        S.in_async = current_async;
	        return a;
	    }

	    function _await_expression() {
	        // Previous token must be "await" and not be interpreted as an identifier
	        if (!can_await()) {
	            croak("Unexpected await expression outside async function",
	                S.prev.line, S.prev.col, S.prev.pos);
	        }
	        // the await expression is parsed as a unary expression in Babel
	        return new AST_Await({
	            start: prev(),
	            end: S.token,
	            expression : maybe_unary(true),
	        });
	    }

	    function _yield_expression() {
	        var start = S.token;
	        var star = false;
	        var has_expression = true;

	        // Attempt to get expression or star (and then the mandatory expression)
	        // behind yield on the same line.
	        //
	        // If nothing follows on the same line of the yieldExpression,
	        // it should default to the value `undefined` for yield to return.
	        // In that case, the `undefined` stored as `null` in ast.
	        //
	        // Note 1: It isn't allowed for yield* to close without an expression
	        // Note 2: If there is a nlb between yield and star, it is interpret as
	        //         yield <explicit undefined> <inserted automatic semicolon> *
	        if (
	            can_insert_semicolon()
	            || is("punc") && PUNC_AFTER_EXPRESSION.has(S.token.value)
	            || is("template_cont")
	        ) {
	            has_expression = false;
	        } else if (is("operator", "*")) {
	            star = true;
	            next();
	        }

	        return new AST_Yield({
	            start      : start,
	            is_star    : star,
	            expression : has_expression ? expression() : null,
	            end        : prev()
	        });
	    }

	    function if_() {
	        var cond = parenthesised(), body = statement(false, false, true), belse = null;
	        if (is("keyword", "else")) {
	            next();
	            belse = statement(false, false, true);
	        }
	        return new AST_If({
	            condition   : cond,
	            body        : body,
	            alternative : belse
	        });
	    }

	    function block_() {
	        expect("{");
	        var a = [];
	        while (!is("punc", "}")) {
	            if (is("eof")) unexpected();
	            a.push(statement());
	        }
	        next();
	        return a;
	    }

	    function switch_body_() {
	        expect("{");
	        var a = [], cur = null, branch = null, tmp;
	        while (!is("punc", "}")) {
	            if (is("eof")) unexpected();
	            if (is("keyword", "case")) {
	                if (branch) branch.end = prev();
	                cur = [];
	                branch = new AST_Case({
	                    start      : (tmp = S.token, next(), tmp),
	                    expression : expression(true),
	                    body       : cur
	                });
	                a.push(branch);
	                expect(":");
	            } else if (is("keyword", "default")) {
	                if (branch) branch.end = prev();
	                cur = [];
	                branch = new AST_Default({
	                    start : (tmp = S.token, next(), expect(":"), tmp),
	                    body  : cur
	                });
	                a.push(branch);
	            } else {
	                if (!cur) unexpected();
	                cur.push(statement());
	            }
	        }
	        if (branch) branch.end = prev();
	        next();
	        return a;
	    }

	    function try_() {
	        var body, bcatch = null, bfinally = null;
	        body = new AST_TryBlock({
	            start : S.token,
	            body  : block_(),
	            end   : prev(),
	        });
	        if (is("keyword", "catch")) {
	            var start = S.token;
	            next();
	            if (is("punc", "{")) {
	                var name = null;
	            } else {
	                expect("(");
	                var name = parameter(undefined, AST_SymbolCatch);
	                expect(")");
	            }
	            bcatch = new AST_Catch({
	                start   : start,
	                argname : name,
	                body    : block_(),
	                end     : prev()
	            });
	        }
	        if (is("keyword", "finally")) {
	            var start = S.token;
	            next();
	            bfinally = new AST_Finally({
	                start : start,
	                body  : block_(),
	                end   : prev()
	            });
	        }
	        if (!bcatch && !bfinally)
	            croak("Missing catch/finally blocks");
	        return new AST_Try({
	            body     : body,
	            bcatch   : bcatch,
	            bfinally : bfinally
	        });
	    }

	    /**
	     * var
	     *   vardef1 = 2,
	     *   vardef2 = 3;
	     */
	    function vardefs(no_in, kind) {
	        var var_defs = [];
	        var def;
	        for (;;) {
	            var sym_type =
	                kind === "var" ? AST_SymbolVar :
	                kind === "const" ? AST_SymbolConst :
	                kind === "let" ? AST_SymbolLet : null;
	            // var { a } = b
	            if (is("punc", "{") || is("punc", "[")) {
	                def = new AST_VarDef({
	                    start: S.token,
	                    name: binding_element(undefined, sym_type),
	                    value: is("operator", "=") ? (expect_token("operator", "="), expression(false, no_in)) : null,
	                    end: prev()
	                });
	            } else {
	                def = new AST_VarDef({
	                    start : S.token,
	                    name  : as_symbol(sym_type),
	                    value : is("operator", "=")
	                        ? (next(), expression(false, no_in))
	                        : !no_in && kind === "const"
	                            ? croak("Missing initializer in const declaration") : null,
	                    end   : prev()
	                });
	                if (def.name.name == "import") croak("Unexpected token: import");
	            }
	            var_defs.push(def);
	            if (!is("punc", ","))
	                break;
	            next();
	        }
	        return var_defs;
	    }

	    var var_ = function(no_in) {
	        return new AST_Var({
	            start       : prev(),
	            definitions : vardefs(no_in, "var"),
	            end         : prev()
	        });
	    };

	    var let_ = function(no_in) {
	        return new AST_Let({
	            start       : prev(),
	            definitions : vardefs(no_in, "let"),
	            end         : prev()
	        });
	    };

	    var const_ = function(no_in) {
	        return new AST_Const({
	            start       : prev(),
	            definitions : vardefs(no_in, "const"),
	            end         : prev()
	        });
	    };

	    var new_ = function(allow_calls) {
	        var start = S.token;
	        expect_token("operator", "new");
	        if (is("punc", ".")) {
	            next();
	            expect_token("name", "target");
	            return subscripts(new AST_NewTarget({
	                start : start,
	                end   : prev()
	            }), allow_calls);
	        }
	        var newexp = expr_atom(false), args;
	        if (is("punc", "(")) {
	            next();
	            args = expr_list(")", true);
	        } else {
	            args = [];
	        }
	        var call = new AST_New({
	            start      : start,
	            expression : newexp,
	            args       : args,
	            end        : prev()
	        });
	        annotate(call);
	        return subscripts(call, allow_calls);
	    };

	    function as_atom_node() {
	        var tok = S.token, ret;
	        switch (tok.type) {
	          case "name":
	            ret = _make_symbol(AST_SymbolRef);
	            break;
	          case "num":
	            ret = new AST_Number({
	                start: tok,
	                end: tok,
	                value: tok.value,
	                raw: LATEST_RAW
	            });
	            break;
	          case "big_int":
	            ret = new AST_BigInt({
	                start: tok,
	                end: tok,
	                value: tok.value,
	                raw: LATEST_RAW,
	            });
	            break;
	          case "string":
	            ret = new AST_String({
	                start : tok,
	                end   : tok,
	                value : tok.value,
	                quote : tok.quote
	            });
	            annotate(ret);
	            break;
	          case "regexp":
	            const [_, source, flags] = tok.value.match(/^\/(.*)\/(\w*)$/);

	            ret = new AST_RegExp({ start: tok, end: tok, value: { source, flags } });
	            break;
	          case "atom":
	            switch (tok.value) {
	              case "false":
	                ret = new AST_False({ start: tok, end: tok });
	                break;
	              case "true":
	                ret = new AST_True({ start: tok, end: tok });
	                break;
	              case "null":
	                ret = new AST_Null({ start: tok, end: tok });
	                break;
	            }
	            break;
	        }
	        next();
	        return ret;
	    }

	    function to_fun_args(ex, default_seen_above) {
	        var insert_default = function(ex, default_value) {
	            if (default_value) {
	                return new AST_DefaultAssign({
	                    start: ex.start,
	                    left: ex,
	                    operator: "=",
	                    right: default_value,
	                    end: default_value.end
	                });
	            }
	            return ex;
	        };
	        if (ex instanceof AST_Object) {
	            return insert_default(new AST_Destructuring({
	                start: ex.start,
	                end: ex.end,
	                is_array: false,
	                names: ex.properties.map(prop => to_fun_args(prop))
	            }), default_seen_above);
	        } else if (ex instanceof AST_ObjectKeyVal) {
	            ex.value = to_fun_args(ex.value);
	            return insert_default(ex, default_seen_above);
	        } else if (ex instanceof AST_Hole) {
	            return ex;
	        } else if (ex instanceof AST_Destructuring) {
	            ex.names = ex.names.map(name => to_fun_args(name));
	            return insert_default(ex, default_seen_above);
	        } else if (ex instanceof AST_SymbolRef) {
	            return insert_default(new AST_SymbolFunarg({
	                name: ex.name,
	                start: ex.start,
	                end: ex.end
	            }), default_seen_above);
	        } else if (ex instanceof AST_Expansion) {
	            ex.expression = to_fun_args(ex.expression);
	            return insert_default(ex, default_seen_above);
	        } else if (ex instanceof AST_Array) {
	            return insert_default(new AST_Destructuring({
	                start: ex.start,
	                end: ex.end,
	                is_array: true,
	                names: ex.elements.map(elm => to_fun_args(elm))
	            }), default_seen_above);
	        } else if (ex instanceof AST_Assign) {
	            return insert_default(to_fun_args(ex.left, ex.right), default_seen_above);
	        } else if (ex instanceof AST_DefaultAssign) {
	            ex.left = to_fun_args(ex.left);
	            return ex;
	        } else {
	            croak("Invalid function parameter", ex.start.line, ex.start.col);
	        }
	    }

	    var expr_atom = function(allow_calls, allow_arrows) {
	        if (is("operator", "new")) {
	            return new_(allow_calls);
	        }
	        if (is("name", "import") && is_token(peek(), "punc", ".")) {
	            return import_meta(allow_calls);
	        }
	        var start = S.token;
	        var peeked;
	        var async = is("name", "async")
	            && (peeked = peek()).value != "["
	            && peeked.type != "arrow"
	            && as_atom_node();
	        if (is("punc")) {
	            switch (S.token.value) {
	              case "(":
	                if (async && !allow_calls) break;
	                var exprs = params_or_seq_(allow_arrows, !async);
	                if (allow_arrows && is("arrow", "=>")) {
	                    return arrow_function(start, exprs.map(e => to_fun_args(e)), !!async);
	                }
	                var ex = async ? new AST_Call({
	                    expression: async,
	                    args: exprs
	                }) : to_expr_or_sequence(start, exprs);
	                if (ex.start) {
	                    const outer_comments_before = start.comments_before.length;
	                    outer_comments_before_counts.set(start, outer_comments_before);
	                    ex.start.comments_before.unshift(...start.comments_before);
	                    start.comments_before = ex.start.comments_before;
	                    if (outer_comments_before == 0 && start.comments_before.length > 0) {
	                        var comment = start.comments_before[0];
	                        if (!comment.nlb) {
	                            comment.nlb = start.nlb;
	                            start.nlb = false;
	                        }
	                    }
	                    start.comments_after = ex.start.comments_after;
	                }
	                ex.start = start;
	                var end = prev();
	                if (ex.end) {
	                    end.comments_before = ex.end.comments_before;
	                    ex.end.comments_after.push(...end.comments_after);
	                    end.comments_after = ex.end.comments_after;
	                }
	                ex.end = end;
	                if (ex instanceof AST_Call) annotate(ex);
	                return subscripts(ex, allow_calls);
	              case "[":
	                return subscripts(array_(), allow_calls);
	              case "{":
	                return subscripts(object_or_destructuring_(), allow_calls);
	            }
	            if (!async) unexpected();
	        }
	        if (allow_arrows && is("name") && is_token(peek(), "arrow")) {
	            var param = new AST_SymbolFunarg({
	                name: S.token.value,
	                start: start,
	                end: start,
	            });
	            next();
	            return arrow_function(start, [param], !!async);
	        }
	        if (is("keyword", "function")) {
	            next();
	            var func = function_(AST_Function, false, !!async);
	            func.start = start;
	            func.end = prev();
	            return subscripts(func, allow_calls);
	        }
	        if (async) return subscripts(async, allow_calls);
	        if (is("keyword", "class")) {
	            next();
	            var cls = class_(AST_ClassExpression);
	            cls.start = start;
	            cls.end = prev();
	            return subscripts(cls, allow_calls);
	        }
	        if (is("template_head")) {
	            return subscripts(template_string(), allow_calls);
	        }
	        if (ATOMIC_START_TOKEN.has(S.token.type)) {
	            return subscripts(as_atom_node(), allow_calls);
	        }
	        unexpected();
	    };

	    function template_string() {
	        var segments = [], start = S.token;

	        segments.push(new AST_TemplateSegment({
	            start: S.token,
	            raw: TEMPLATE_RAWS.get(S.token),
	            value: S.token.value,
	            end: S.token
	        }));

	        while (!S.token.template_end) {
	            next();
	            handle_regexp();
	            segments.push(expression(true));

	            segments.push(new AST_TemplateSegment({
	                start: S.token,
	                raw: TEMPLATE_RAWS.get(S.token),
	                value: S.token.value,
	                end: S.token
	            }));
	        }
	        next();

	        return new AST_TemplateString({
	            start: start,
	            segments: segments,
	            end: S.token
	        });
	    }

	    function expr_list(closing, allow_trailing_comma, allow_empty) {
	        var first = true, a = [];
	        while (!is("punc", closing)) {
	            if (first) first = false; else expect(",");
	            if (allow_trailing_comma && is("punc", closing)) break;
	            if (is("punc", ",") && allow_empty) {
	                a.push(new AST_Hole({ start: S.token, end: S.token }));
	            } else if (is("expand", "...")) {
	                next();
	                a.push(new AST_Expansion({start: prev(), expression: expression(),end: S.token}));
	            } else {
	                a.push(expression(false));
	            }
	        }
	        next();
	        return a;
	    }

	    var array_ = embed_tokens(function() {
	        expect("[");
	        return new AST_Array({
	            elements: expr_list("]", !options.strict, true)
	        });
	    });

	    var create_accessor = embed_tokens((is_generator, is_async) => {
	        return function_(AST_Accessor, is_generator, is_async);
	    });

	    var object_or_destructuring_ = embed_tokens(function object_or_destructuring_() {
	        var start = S.token, first = true, a = [];
	        expect("{");
	        while (!is("punc", "}")) {
	            if (first) first = false; else expect(",");
	            if (!options.strict && is("punc", "}"))
	                // allow trailing comma
	                break;

	            start = S.token;
	            if (start.type == "expand") {
	                next();
	                a.push(new AST_Expansion({
	                    start: start,
	                    expression: expression(false),
	                    end: prev(),
	                }));
	                continue;
	            }
	            if(is("privatename")) {
	                croak("private fields are not allowed in an object");
	            }
	            var name = as_property_name();
	            var value;

	            // Check property and fetch value
	            if (!is("punc", ":")) {
	                var concise = object_or_class_property(name, start);
	                if (concise) {
	                    a.push(concise);
	                    continue;
	                }

	                value = new AST_SymbolRef({
	                    start: prev(),
	                    name: name,
	                    end: prev()
	                });
	            } else if (name === null) {
	                unexpected(prev());
	            } else {
	                next(); // `:` - see first condition
	                value = expression(false);
	            }

	            // Check for default value and alter value accordingly if necessary
	            if (is("operator", "=")) {
	                next();
	                value = new AST_Assign({
	                    start: start,
	                    left: value,
	                    operator: "=",
	                    right: expression(false),
	                    logical: false,
	                    end: prev()
	                });
	            }

	            // Create property
	            const kv = new AST_ObjectKeyVal({
	                start: start,
	                quote: start.quote,
	                key: name,
	                value: value,
	                end: prev()
	            });
	            a.push(annotate(kv));
	        }
	        next();
	        return new AST_Object({ properties: a });
	    });

	    function class_(KindOfClass, is_export_default) {
	        var start, method, class_name, extends_, properties = [];

	        S.input.push_directives_stack(); // Push directive stack, but not scope stack
	        S.input.add_directive("use strict");

	        if (S.token.type == "name" && S.token.value != "extends") {
	            class_name = as_symbol(KindOfClass === AST_DefClass ? AST_SymbolDefClass : AST_SymbolClass);
	        }

	        if (KindOfClass === AST_DefClass && !class_name) {
	            if (is_export_default) {
	                KindOfClass = AST_ClassExpression;
	            } else {
	                unexpected();
	            }
	        }

	        if (S.token.value == "extends") {
	            next();
	            extends_ = expression(true);
	        }

	        expect("{");
	        // mark in class feild,
	        const save_in_class = S.in_class;
	        S.in_class = true;
	        while (is("punc", ";")) { next(); }  // Leading semicolons are okay in class bodies.
	        while (!is("punc", "}")) {
	            start = S.token;
	            method = object_or_class_property(as_property_name(), start, true);
	            if (!method) { unexpected(); }
	            properties.push(method);
	            while (is("punc", ";")) { next(); }
	        }
	        // mark in class feild,
	        S.in_class = save_in_class;

	        S.input.pop_directives_stack();

	        next();

	        return new KindOfClass({
	            start: start,
	            name: class_name,
	            extends: extends_,
	            properties: properties,
	            end: prev(),
	        });
	    }

	    function object_or_class_property(name, start, is_class) {
	        const get_symbol_ast = (name, SymbolClass) => {
	            if (typeof name === "string") {
	                return new SymbolClass({ start, name, end: prev() });
	            } else if (name === null) {
	                unexpected();
	            }
	            return name;
	        };

	        const is_not_method_start = () =>
	            !is("punc", "(") && !is("punc", ",") && !is("punc", "}") && !is("punc", ";") && !is("operator", "=");

	        var is_async = false;
	        var is_static = false;
	        var is_generator = false;
	        var is_private = false;
	        var accessor_type = null;

	        if (is_class && name === "static" && is_not_method_start()) {
	            const static_block = class_static_block();
	            if (static_block != null) {
	                return static_block;
	            }
	            is_static = true;
	            name = as_property_name();
	        }
	        if (name === "async" && is_not_method_start()) {
	            is_async = true;
	            name = as_property_name();
	        }
	        if (prev().type === "operator" && prev().value === "*") {
	            is_generator = true;
	            name = as_property_name();
	        }
	        if ((name === "get" || name === "set") && is_not_method_start()) {
	            accessor_type = name;
	            name = as_property_name();
	        }
	        if (prev().type === "privatename") {
	            is_private = true;
	        }

	        const property_token = prev();

	        if (accessor_type != null) {
	            if (!is_private) {
	                const AccessorClass = accessor_type === "get"
	                    ? AST_ObjectGetter
	                    : AST_ObjectSetter;

	                name = get_symbol_ast(name, AST_SymbolMethod);
	                return annotate(new AccessorClass({
	                    start,
	                    static: is_static,
	                    key: name,
	                    quote: name instanceof AST_SymbolMethod ? property_token.quote : undefined,
	                    value: create_accessor(),
	                    end: prev()
	                }));
	            } else {
	                const AccessorClass = accessor_type === "get"
	                    ? AST_PrivateGetter
	                    : AST_PrivateSetter;

	                return annotate(new AccessorClass({
	                    start,
	                    static: is_static,
	                    key: get_symbol_ast(name, AST_SymbolMethod),
	                    value: create_accessor(),
	                    end: prev(),
	                }));
	            }
	        }

	        if (is("punc", "(")) {
	            name = get_symbol_ast(name, AST_SymbolMethod);
	            const AST_MethodVariant = is_private
	                ? AST_PrivateMethod
	                : AST_ConciseMethod;
	            var node = new AST_MethodVariant({
	                start       : start,
	                static      : is_static,
	                key         : name,
	                quote       : name instanceof AST_SymbolMethod ?
	                              property_token.quote : undefined,
	                value       : create_accessor(is_generator, is_async),
	                end         : prev()
	            });
	            return annotate(node);
	        }

	        if (is_class) {
	            const AST_SymbolVariant = is_private
	                ? AST_SymbolPrivateProperty
	                : AST_SymbolClassProperty;
	            const AST_ClassPropertyVariant = is_private
	                ? AST_ClassPrivateProperty
	                : AST_ClassProperty;

	            const key = get_symbol_ast(name, AST_SymbolVariant);
	            const quote = key instanceof AST_SymbolClassProperty
	                ? property_token.quote
	                : undefined;
	            if (is("operator", "=")) {
	                next();
	                return annotate(
	                    new AST_ClassPropertyVariant({
	                        start,
	                        static: is_static,
	                        quote,
	                        key,
	                        value: expression(false),
	                        end: prev()
	                    })
	                );
	            } else if (
	                is("name")
	                || is("privatename")
	                || is("punc", "[")
	                || is("operator", "*")
	                || is("punc", ";")
	                || is("punc", "}")
	                || is("string")
	                || is("num")
	                || is("big_int")
	            ) {
	                return annotate(
	                    new AST_ClassPropertyVariant({
	                        start,
	                        static: is_static,
	                        quote,
	                        key,
	                        end: prev()
	                    })
	                );
	            }
	        }
	    }

	    function class_static_block() {
	        if (!is("punc", "{")) {
	            return null;
	        }

	        const start = S.token;
	        const body = [];

	        next();

	        while (!is("punc", "}")) {
	            body.push(statement());
	        }

	        next();

	        return new AST_ClassStaticBlock({ start, body, end: prev() });
	    }

	    function maybe_import_attributes() {
	        if (
	            (is("keyword", "with") || is("name", "assert"))
	            && !has_newline_before(S.token)
	        ) {
	            next();
	            return object_or_destructuring_();
	        }
	        return null;
	    }

	    function import_statement() {
	        var start = prev();

	        var imported_name;
	        var imported_names;
	        if (is("name")) {
	            imported_name = as_symbol(AST_SymbolImport);
	        }

	        if (is("punc", ",")) {
	            next();
	        }

	        imported_names = map_names(true);

	        if (imported_names || imported_name) {
	            expect_token("name", "from");
	        }
	        var mod_str = S.token;
	        if (mod_str.type !== "string") {
	            unexpected();
	        }
	        next();

	        const attributes = maybe_import_attributes();

	        return new AST_Import({
	            start,
	            imported_name,
	            imported_names,
	            module_name: new AST_String({
	                start: mod_str,
	                value: mod_str.value,
	                quote: mod_str.quote,
	                end: mod_str,
	            }),
	            attributes,
	            end: S.token,
	        });
	    }

	    function import_meta(allow_calls) {
	        var start = S.token;
	        expect_token("name", "import");
	        expect_token("punc", ".");
	        expect_token("name", "meta");
	        return subscripts(new AST_ImportMeta({
	            start: start,
	            end: prev()
	        }), allow_calls);
	    }

	    function map_name(is_import) {
	        function make_symbol(type, quote) {
	            return new type({
	                name: as_property_name(),
	                quote: quote || undefined,
	                start: prev(),
	                end: prev()
	            });
	        }

	        var foreign_type = is_import ? AST_SymbolImportForeign : AST_SymbolExportForeign;
	        var type = is_import ? AST_SymbolImport : AST_SymbolExport;
	        var start = S.token;
	        var foreign_name;
	        var name;

	        if (is_import) {
	            foreign_name = make_symbol(foreign_type, start.quote);
	        } else {
	            name = make_symbol(type, start.quote);
	        }
	        if (is("name", "as")) {
	            next();  // The "as" word
	            if (is_import) {
	                name = make_symbol(type);
	            } else {
	                foreign_name = make_symbol(foreign_type, S.token.quote);
	            }
	        } else {
	            if (is_import) {
	                name = new type(foreign_name);
	            } else {
	                foreign_name = new foreign_type(name);
	            }
	        }

	        return new AST_NameMapping({
	            start: start,
	            foreign_name: foreign_name,
	            name: name,
	            end: prev(),
	        });
	    }

	    function map_nameAsterisk(is_import, import_or_export_foreign_name) {
	        var foreign_type = is_import ? AST_SymbolImportForeign : AST_SymbolExportForeign;
	        var type = is_import ? AST_SymbolImport : AST_SymbolExport;
	        var start = S.token;
	        var name, foreign_name;
	        var end = prev();

	        if (is_import) {
	            name = import_or_export_foreign_name;
	        } else {
	            foreign_name = import_or_export_foreign_name;
	        }

	        name = name || new type({
	            start: start,
	            name: "*",
	            end: end,
	        });

	        foreign_name = foreign_name || new foreign_type({
	            start: start,
	            name: "*",
	            end: end,
	        });

	        return new AST_NameMapping({
	            start: start,
	            foreign_name: foreign_name,
	            name: name,
	            end: end,
	        });
	    }

	    function map_names(is_import) {
	        var names;
	        if (is("punc", "{")) {
	            next();
	            names = [];
	            while (!is("punc", "}")) {
	                names.push(map_name(is_import));
	                if (is("punc", ",")) {
	                    next();
	                }
	            }
	            next();
	        } else if (is("operator", "*")) {
	            var name;
	            next();
	            if (is("name", "as")) {
	                next();  // The "as" word
	                name = is_import ? as_symbol(AST_SymbolImport) : as_symbol_or_string(AST_SymbolExportForeign);
	            }
	            names = [map_nameAsterisk(is_import, name)];
	        }
	        return names;
	    }

	    function export_statement() {
	        var start = S.token;
	        var is_default;
	        var exported_names;

	        if (is("keyword", "default")) {
	            is_default = true;
	            next();
	        } else if (exported_names = map_names(false)) {
	            if (is("name", "from")) {
	                next();

	                var mod_str = S.token;
	                if (mod_str.type !== "string") {
	                    unexpected();
	                }
	                next();

	                const attributes = maybe_import_attributes();

	                return new AST_Export({
	                    start: start,
	                    is_default: is_default,
	                    exported_names: exported_names,
	                    module_name: new AST_String({
	                        start: mod_str,
	                        value: mod_str.value,
	                        quote: mod_str.quote,
	                        end: mod_str,
	                    }),
	                    end: prev(),
	                    attributes
	                });
	            } else {
	                return new AST_Export({
	                    start: start,
	                    is_default: is_default,
	                    exported_names: exported_names,
	                    end: prev(),
	                });
	            }
	        }

	        var node;
	        var exported_value;
	        var exported_definition;
	        if (is("punc", "{")
	            || is_default
	                && (is("keyword", "class") || is("keyword", "function"))
	                && is_token(peek(), "punc")) {
	            exported_value = expression(false);
	            semicolon();
	        } else if ((node = statement(is_default)) instanceof AST_Definitions && is_default) {
	            unexpected(node.start);
	        } else if (
	            node instanceof AST_Definitions
	            || node instanceof AST_Defun
	            || node instanceof AST_DefClass
	        ) {
	            exported_definition = node;
	        } else if (
	            node instanceof AST_ClassExpression
	            || node instanceof AST_Function
	        ) {
	            exported_value = node;
	        } else if (node instanceof AST_SimpleStatement) {
	            exported_value = node.body;
	        } else {
	            unexpected(node.start);
	        }

	        return new AST_Export({
	            start: start,
	            is_default: is_default,
	            exported_value: exported_value,
	            exported_definition: exported_definition,
	            end: prev(),
	            attributes: null
	        });
	    }

	    function as_property_name() {
	        var tmp = S.token;
	        switch (tmp.type) {
	          case "punc":
	            if (tmp.value === "[") {
	                next();
	                var ex = expression(false);
	                expect("]");
	                return ex;
	            } else unexpected(tmp);
	          case "operator":
	            if (tmp.value === "*") {
	                next();
	                return null;
	            }
	            if (!["delete", "in", "instanceof", "new", "typeof", "void"].includes(tmp.value)) {
	                unexpected(tmp);
	            }
	            /* falls through */
	          case "name":
	          case "privatename":
	          case "string":
	          case "keyword":
	          case "atom":
	            next();
	            return tmp.value;
	          case "num":
	          case "big_int":
	            next();
	            return "" + tmp.value;
	          default:
	            unexpected(tmp);
	        }
	    }

	    function as_name() {
	        var tmp = S.token;
	        if (tmp.type != "name" && tmp.type != "privatename") unexpected();
	        next();
	        return tmp.value;
	    }

	    function _make_symbol(type) {
	        var name = S.token.value;
	        return new (name == "this" ? AST_This :
	                    name == "super" ? AST_Super :
	                    type)({
	            name  : String(name),
	            start : S.token,
	            end   : S.token
	        });
	    }

	    function _verify_symbol(sym) {
	        var name = sym.name;
	        if (is_in_generator() && name == "yield") {
	            token_error(sym.start, "Yield cannot be used as identifier inside generators");
	        }
	        if (S.input.has_directive("use strict")) {
	            if (name == "yield") {
	                token_error(sym.start, "Unexpected yield identifier inside strict mode");
	            }
	            if (sym instanceof AST_SymbolDeclaration && (name == "arguments" || name == "eval")) {
	                token_error(sym.start, "Unexpected " + name + " in strict mode");
	            }
	        }
	    }

	    function as_symbol(type, noerror) {
	        if (!is("name")) {
	            if (!noerror) croak("Name expected");
	            return null;
	        }
	        var sym = _make_symbol(type);
	        _verify_symbol(sym);
	        next();
	        return sym;
	    }

	    function as_symbol_or_string(type) {
	        if (!is("name")) {
	            if (!is("string")) {
	                croak("Name or string expected");
	            }
	            var tok = S.token;
	            var ret = new type({
	                start : tok,
	                end   : tok,
	                name : tok.value,
	                quote : tok.quote
	            });
	            next();
	            return ret;
	        }
	        var sym = _make_symbol(type);
	        _verify_symbol(sym);
	        next();
	        return sym;
	    }

	    // Annotate AST_Call, AST_Lambda or AST_New with the special comments
	    function annotate(node, before_token = node.start) {
	        var comments = before_token.comments_before;
	        const comments_outside_parens = outer_comments_before_counts.get(before_token);
	        var i = comments_outside_parens != null ? comments_outside_parens : comments.length;
	        while (--i >= 0) {
	            var comment = comments[i];
	            if (/[@#]__/.test(comment.value)) {
	                if (/[@#]__PURE__/.test(comment.value)) {
	                    set_annotation(node, _PURE);
	                    break;
	                }
	                if (/[@#]__INLINE__/.test(comment.value)) {
	                    set_annotation(node, _INLINE);
	                    break;
	                }
	                if (/[@#]__NOINLINE__/.test(comment.value)) {
	                    set_annotation(node, _NOINLINE);
	                    break;
	                }
	                if (/[@#]__KEY__/.test(comment.value)) {
	                    set_annotation(node, _KEY);
	                    break;
	                }
	                if (/[@#]__MANGLE_PROP__/.test(comment.value)) {
	                    set_annotation(node, _MANGLEPROP);
	                    break;
	                }
	            }
	        }
	        return node;
	    }

	    var subscripts = function(expr, allow_calls, is_chain) {
	        var start = expr.start;
	        if (is("punc", ".")) {
	            next();
	            if(is("privatename") && !S.in_class) 
	                croak("Private field must be used in an enclosing class");
	            const AST_DotVariant = is("privatename") ? AST_DotHash : AST_Dot;
	            return annotate(subscripts(new AST_DotVariant({
	                start      : start,
	                expression : expr,
	                optional   : false,
	                property   : as_name(),
	                end        : prev()
	            }), allow_calls, is_chain));
	        }
	        if (is("punc", "[")) {
	            next();
	            var prop = expression(true);
	            expect("]");
	            return annotate(subscripts(new AST_Sub({
	                start      : start,
	                expression : expr,
	                optional   : false,
	                property   : prop,
	                end        : prev()
	            }), allow_calls, is_chain));
	        }
	        if (allow_calls && is("punc", "(")) {
	            next();
	            var call = new AST_Call({
	                start      : start,
	                expression : expr,
	                optional   : false,
	                args       : call_args(),
	                end        : prev()
	            });
	            annotate(call);
	            return subscripts(call, true, is_chain);
	        }

	        // Optional chain
	        if (is("punc", "?.")) {
	            next();

	            let chain_contents;

	            if (allow_calls && is("punc", "(")) {
	                next();

	                const call = new AST_Call({
	                    start,
	                    optional: true,
	                    expression: expr,
	                    args: call_args(),
	                    end: prev()
	                });
	                annotate(call);

	                chain_contents = subscripts(call, true, true);
	            } else if (is("name") || is("privatename")) {
	                if(is("privatename") && !S.in_class) 
	                    croak("Private field must be used in an enclosing class");
	                const AST_DotVariant = is("privatename") ? AST_DotHash : AST_Dot;
	                chain_contents = annotate(subscripts(new AST_DotVariant({
	                    start,
	                    expression: expr,
	                    optional: true,
	                    property: as_name(),
	                    end: prev()
	                }), allow_calls, true));
	            } else if (is("punc", "[")) {
	                next();
	                const property = expression(true);
	                expect("]");
	                chain_contents = annotate(subscripts(new AST_Sub({
	                    start,
	                    expression: expr,
	                    optional: true,
	                    property,
	                    end: prev()
	                }), allow_calls, true));
	            }

	            if (!chain_contents) unexpected();

	            if (chain_contents instanceof AST_Chain) return chain_contents;

	            return new AST_Chain({
	                start,
	                expression: chain_contents,
	                end: prev()
	            });
	        }

	        if (is("template_head")) {
	            if (is_chain) {
	                // a?.b`c` is a syntax error
	                unexpected();
	            }

	            return subscripts(new AST_PrefixedTemplateString({
	                start: start,
	                prefix: expr,
	                template_string: template_string(),
	                end: prev()
	            }), allow_calls);
	        }
	        return expr;
	    };

	    function call_args() {
	        var args = [];
	        while (!is("punc", ")")) {
	            if (is("expand", "...")) {
	                next();
	                args.push(new AST_Expansion({
	                    start: prev(),
	                    expression: expression(false),
	                    end: prev()
	                }));
	            } else {
	                args.push(expression(false));
	            }
	            if (!is("punc", ")")) {
	                expect(",");
	            }
	        }
	        next();
	        return args;
	    }

	    var maybe_unary = function(allow_calls, allow_arrows) {
	        var start = S.token;
	        if (start.type == "name" && start.value == "await" && can_await()) {
	            next();
	            return _await_expression();
	        }
	        if (is("operator") && UNARY_PREFIX.has(start.value)) {
	            next();
	            handle_regexp();
	            var ex = make_unary(AST_UnaryPrefix, start, maybe_unary(allow_calls));
	            ex.start = start;
	            ex.end = prev();
	            return ex;
	        }
	        var val = expr_atom(allow_calls, allow_arrows);
	        while (is("operator") && UNARY_POSTFIX.has(S.token.value) && !has_newline_before(S.token)) {
	            if (val instanceof AST_Arrow) unexpected();
	            val = make_unary(AST_UnaryPostfix, S.token, val);
	            val.start = start;
	            val.end = S.token;
	            next();
	        }
	        return val;
	    };

	    function make_unary(ctor, token, expr) {
	        var op = token.value;
	        switch (op) {
	          case "++":
	          case "--":
	            if (!is_assignable(expr))
	                croak("Invalid use of " + op + " operator", token.line, token.col, token.pos);
	            break;
	          case "delete":
	            if (expr instanceof AST_SymbolRef && S.input.has_directive("use strict"))
	                croak("Calling delete on expression not allowed in strict mode", expr.start.line, expr.start.col, expr.start.pos);
	            break;
	        }
	        return new ctor({ operator: op, expression: expr });
	    }

	    var expr_op = function(left, min_prec, no_in) {
	        var op = is("operator") ? S.token.value : null;
	        if (op == "in" && no_in) op = null;
	        if (op == "**" && left instanceof AST_UnaryPrefix
	            /* unary token in front not allowed - parenthesis required */
	            && !is_token(left.start, "punc", "(")
	            && left.operator !== "--" && left.operator !== "++")
	                unexpected(left.start);
	        var prec = op != null ? PRECEDENCE[op] : null;
	        if (prec != null && (prec > min_prec || (op === "**" && min_prec === prec))) {
	            next();
	            var right = expr_ops(no_in, prec, true);
	            return expr_op(new AST_Binary({
	                start    : left.start,
	                left     : left,
	                operator : op,
	                right    : right,
	                end      : right.end
	            }), min_prec, no_in);
	        }
	        return left;
	    };

	    function expr_ops(no_in, min_prec, allow_calls, allow_arrows) {
	        // maybe_unary won't return us a AST_SymbolPrivateProperty
	        if (!no_in && min_prec < PRECEDENCE["in"] && is("privatename")) {
	            if(!S.in_class) {
	                croak("Private field must be used in an enclosing class");
	            }

	            const start = S.token;
	            const key = new AST_SymbolPrivateProperty({
	                start,
	                name: start.value,
	                end: start
	            });
	            next();
	            expect_token("operator", "in");

	            const private_in = new AST_PrivateIn({
	                start,
	                key,
	                value: expr_ops(no_in, PRECEDENCE["in"], true),
	                end: prev()
	            });

	            return expr_op(private_in, 0, no_in);
	        } else {
	            return expr_op(maybe_unary(allow_calls, allow_arrows), min_prec, no_in);
	        }
	    }

	    var maybe_conditional = function(no_in) {
	        var start = S.token;
	        var expr = expr_ops(no_in, 0, true, true);
	        if (is("operator", "?")) {
	            next();
	            var yes = expression(false);
	            expect(":");
	            return new AST_Conditional({
	                start       : start,
	                condition   : expr,
	                consequent  : yes,
	                alternative : expression(false, no_in),
	                end         : prev()
	            });
	        }
	        return expr;
	    };

	    function is_assignable(expr) {
	        return expr instanceof AST_PropAccess || expr instanceof AST_SymbolRef;
	    }

	    function to_destructuring(node) {
	        if (node instanceof AST_Object) {
	            node = new AST_Destructuring({
	                start: node.start,
	                names: node.properties.map(to_destructuring),
	                is_array: false,
	                end: node.end
	            });
	        } else if (node instanceof AST_Array) {
	            var names = [];

	            for (var i = 0; i < node.elements.length; i++) {
	                // Only allow expansion as last element
	                if (node.elements[i] instanceof AST_Expansion) {
	                    if (i + 1 !== node.elements.length) {
	                        token_error(node.elements[i].start, "Spread must the be last element in destructuring array");
	                    }
	                    node.elements[i].expression = to_destructuring(node.elements[i].expression);
	                }

	                names.push(to_destructuring(node.elements[i]));
	            }

	            node = new AST_Destructuring({
	                start: node.start,
	                names: names,
	                is_array: true,
	                end: node.end
	            });
	        } else if (node instanceof AST_ObjectProperty) {
	            node.value = to_destructuring(node.value);
	        } else if (node instanceof AST_Assign) {
	            node = new AST_DefaultAssign({
	                start: node.start,
	                left: node.left,
	                operator: "=",
	                right: node.right,
	                end: node.end
	            });
	        }
	        return node;
	    }

	    // In ES6, AssignmentExpression can also be an ArrowFunction
	    var maybe_assign = function(no_in) {
	        handle_regexp();
	        var start = S.token;

	        if (start.type == "name" && start.value == "yield") {
	            if (is_in_generator()) {
	                next();
	                return _yield_expression();
	            } else if (S.input.has_directive("use strict")) {
	                token_error(S.token, "Unexpected yield identifier inside strict mode");
	            }
	        }

	        var left = maybe_conditional(no_in);
	        var val = S.token.value;

	        if (is("operator") && ASSIGNMENT.has(val)) {
	            if (is_assignable(left) || (left = to_destructuring(left)) instanceof AST_Destructuring) {
	                next();

	                return new AST_Assign({
	                    start    : start,
	                    left     : left,
	                    operator : val,
	                    right    : maybe_assign(no_in),
	                    logical  : LOGICAL_ASSIGNMENT.has(val),
	                    end      : prev()
	                });
	            }
	            croak("Invalid assignment");
	        }
	        return left;
	    };

	    var to_expr_or_sequence = function(start, exprs) {
	        if (exprs.length === 1) {
	            return exprs[0];
	        } else if (exprs.length > 1) {
	            return new AST_Sequence({ start, expressions: exprs, end: peek() });
	        } else {
	            croak("Invalid parenthesized expression");
	        }
	    };

	    var expression = function(commas, no_in) {
	        var start = S.token;
	        var exprs = [];
	        while (true) {
	            exprs.push(maybe_assign(no_in));
	            if (!commas || !is("punc", ",")) break;
	            next();
	            commas = true;
	        }
	        return to_expr_or_sequence(start, exprs);
	    };

	    function in_loop(cont) {
	        ++S.in_loop;
	        var ret = cont();
	        --S.in_loop;
	        return ret;
	    }

	    if (options.expression) {
	        return expression(true);
	    }

	    return (function parse_toplevel() {
	        var start = S.token;
	        var body = [];
	        S.input.push_directives_stack();
	        if (options.module) S.input.add_directive("use strict");
	        while (!is("eof")) {
	            body.push(statement());
	        }
	        S.input.pop_directives_stack();
	        var end = prev();
	        var toplevel = options.toplevel;
	        if (toplevel) {
	            toplevel.body = toplevel.body.concat(body);
	            toplevel.end = end;
	        } else {
	            toplevel = new AST_Toplevel({ start: start, body: body, end: end });
	        }
	        TEMPLATE_RAWS = new Map();
	        return toplevel;
	    })();

	}

	/***********************************************************************

	  A JavaScript tokenizer / parser / beautifier / compressor.
	  https://github.com/mishoo/UglifyJS2

	  -------------------------------- (C) ---------------------------------

	                           Author: Mihai Bazon
	                         <mihai.bazon@gmail.com>
	                       http://mihai.bazon.net/blog

	  Distributed under the BSD license:

	    Copyright 2012 (c) Mihai Bazon <mihai.bazon@gmail.com>

	    Redistribution and use in source and binary forms, with or without
	    modification, are permitted provided that the following conditions
	    are met:

	        * Redistributions of source code must retain the above
	          copyright notice, this list of conditions and the following
	          disclaimer.

	        * Redistributions in binary form must reproduce the above
	          copyright notice, this list of conditions and the following
	          disclaimer in the documentation and/or other materials
	          provided with the distribution.

	    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER “AS IS” AND ANY
	    EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
	    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
	    PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE
	    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
	    OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
	    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
	    PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
	    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
	    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
	    THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
	    SUCH DAMAGE.

	 ***********************************************************************/


	function DEFNODE(type, props, ctor, methods, base = AST_Node) {
	    if (!props) props = [];
	    else props = props.split(/\s+/);
	    var self_props = props;
	    if (base && base.PROPS)
	        props = props.concat(base.PROPS);
	    const proto = base && Object.create(base.prototype);
	    if (proto) {
	        ctor.prototype = proto;
	        ctor.BASE = base;
	    }
	    if (base) base.SUBCLASSES.push(ctor);
	    ctor.prototype.CTOR = ctor;
	    ctor.prototype.constructor = ctor;
	    ctor.PROPS = props || null;
	    ctor.SELF_PROPS = self_props;
	    ctor.SUBCLASSES = [];
	    if (type) {
	        ctor.prototype.TYPE = ctor.TYPE = type;
	    }
	    if (methods) for (let i in methods) if (HOP(methods, i)) {
	        if (i[0] === "$") {
	            ctor[i.substr(1)] = methods[i];
	        } else {
	            ctor.prototype[i] = methods[i];
	        }
	    }
	    ctor.DEFMETHOD = function(name, method) {
	        this.prototype[name] = method;
	    };
	    return ctor;
	}

	const has_tok_flag = (tok, flag) => Boolean(tok.flags & flag);
	const set_tok_flag = (tok, flag, truth) => {
	    if (truth) {
	        tok.flags |= flag;
	    } else {
	        tok.flags &= ~flag;
	    }
	};

	const TOK_FLAG_NLB          = 0b0001;
	const TOK_FLAG_QUOTE_SINGLE = 0b0010;
	const TOK_FLAG_QUOTE_EXISTS = 0b0100;
	const TOK_FLAG_TEMPLATE_END = 0b1000;

	class AST_Token {
	    constructor(type, value, line, col, pos, nlb, comments_before, comments_after, file) {
	        this.flags = (nlb ? 1 : 0);

	        this.type = type;
	        this.value = value;
	        this.line = line;
	        this.col = col;
	        this.pos = pos;
	        this.comments_before = comments_before;
	        this.comments_after = comments_after;
	        this.file = file;

	        Object.seal(this);
	    }

	    // Return a string summary of the token for node.js console.log
	    [Symbol.for("nodejs.util.inspect.custom")](_depth, options) {
	        const special = str => options.stylize(str, "special");
	        const quote = typeof this.value === "string" && this.value.includes("`") ? "'" : "`";
	        const value = `${quote}${this.value}${quote}`;
	        return `${special("[AST_Token")} ${value} at ${this.line}:${this.col}${special("]")}`;
	    }

	    get nlb() {
	        return has_tok_flag(this, TOK_FLAG_NLB);
	    }

	    set nlb(new_nlb) {
	        set_tok_flag(this, TOK_FLAG_NLB, new_nlb);
	    }

	    get quote() {
	        return !has_tok_flag(this, TOK_FLAG_QUOTE_EXISTS)
	            ? ""
	            : (has_tok_flag(this, TOK_FLAG_QUOTE_SINGLE) ? "'" : '"');
	    }

	    set quote(quote_type) {
	        set_tok_flag(this, TOK_FLAG_QUOTE_SINGLE, quote_type === "'");
	        set_tok_flag(this, TOK_FLAG_QUOTE_EXISTS, !!quote_type);
	    }

	    get template_end() {
	        return has_tok_flag(this, TOK_FLAG_TEMPLATE_END);
	    }

	    set template_end(new_template_end) {
	        set_tok_flag(this, TOK_FLAG_TEMPLATE_END, new_template_end);
	    }
	}

	var AST_Node = DEFNODE("Node", "start end", function AST_Node(props) {
	    if (props) {
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    _clone: function(deep) {
	        if (deep) {
	            var self = this.clone();
	            return self.transform(new TreeTransformer(function(node) {
	                if (node !== self) {
	                    return node.clone(true);
	                }
	            }));
	        }
	        return new this.CTOR(this);
	    },
	    clone: function(deep) {
	        return this._clone(deep);
	    },
	    $documentation: "Base class of all AST nodes",
	    $propdoc: {
	        start: "[AST_Token] The first token of this node",
	        end: "[AST_Token] The last token of this node"
	    },
	    _walk: function(visitor) {
	        return visitor._visit(this);
	    },
	    walk: function(visitor) {
	        return this._walk(visitor); // not sure the indirection will be any help
	    },
	    _children_backwards: () => {}
	}, null);

	/* -----[ statements ]----- */

	var AST_Statement = DEFNODE("Statement", null, function AST_Statement(props) {
	    if (props) {
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "Base class of all statements",
	});

	var AST_Debugger = DEFNODE("Debugger", null, function AST_Debugger(props) {
	    if (props) {
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "Represents a debugger statement",
	}, AST_Statement);

	var AST_Directive = DEFNODE("Directive", "value quote", function AST_Directive(props) {
	    if (props) {
	        this.value = props.value;
	        this.quote = props.quote;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "Represents a directive, like \"use strict\";",
	    $propdoc: {
	        value: "[string] The value of this directive as a plain string (it's not an AST_String!)",
	        quote: "[string] the original quote character"
	    },
	}, AST_Statement);

	var AST_SimpleStatement = DEFNODE("SimpleStatement", "body", function AST_SimpleStatement(props) {
	    if (props) {
	        this.body = props.body;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "A statement consisting of an expression, i.e. a = 1 + 2",
	    $propdoc: {
	        body: "[AST_Node] an expression node (should not be instanceof AST_Statement)"
	    },
	    _walk: function(visitor) {
	        return visitor._visit(this, function() {
	            this.body._walk(visitor);
	        });
	    },
	    _children_backwards(push) {
	        push(this.body);
	    }
	}, AST_Statement);

	function walk_body(node, visitor) {
	    const body = node.body;
	    for (var i = 0, len = body.length; i < len; i++) {
	        body[i]._walk(visitor);
	    }
	}

	function clone_block_scope(deep) {
	    var clone = this._clone(deep);
	    if (this.block_scope) {
	        clone.block_scope = this.block_scope.clone();
	    }
	    return clone;
	}

	var AST_Block = DEFNODE("Block", "body block_scope", function AST_Block(props) {
	    if (props) {
	        this.body = props.body;
	        this.block_scope = props.block_scope;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "A body of statements (usually braced)",
	    $propdoc: {
	        body: "[AST_Statement*] an array of statements",
	        block_scope: "[AST_Scope] the block scope"
	    },
	    _walk: function(visitor) {
	        return visitor._visit(this, function() {
	            walk_body(this, visitor);
	        });
	    },
	    _children_backwards(push) {
	        let i = this.body.length;
	        while (i--) push(this.body[i]);
	    },
	    clone: clone_block_scope
	}, AST_Statement);

	var AST_BlockStatement = DEFNODE("BlockStatement", null, function AST_BlockStatement(props) {
	    if (props) {
	        this.body = props.body;
	        this.block_scope = props.block_scope;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "A block statement",
	}, AST_Block);

	var AST_EmptyStatement = DEFNODE("EmptyStatement", null, function AST_EmptyStatement(props) {
	    if (props) {
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "The empty statement (empty block or simply a semicolon)"
	}, AST_Statement);

	var AST_StatementWithBody = DEFNODE("StatementWithBody", "body", function AST_StatementWithBody(props) {
	    if (props) {
	        this.body = props.body;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "Base class for all statements that contain one nested body: `For`, `ForIn`, `Do`, `While`, `With`",
	    $propdoc: {
	        body: "[AST_Statement] the body; this should always be present, even if it's an AST_EmptyStatement"
	    }
	}, AST_Statement);

	var AST_LabeledStatement = DEFNODE("LabeledStatement", "label", function AST_LabeledStatement(props) {
	    if (props) {
	        this.label = props.label;
	        this.body = props.body;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "Statement with a label",
	    $propdoc: {
	        label: "[AST_Label] a label definition"
	    },
	    _walk: function(visitor) {
	        return visitor._visit(this, function() {
	            this.label._walk(visitor);
	            this.body._walk(visitor);
	        });
	    },
	    _children_backwards(push) {
	        push(this.body);
	        push(this.label);
	    },
	    clone: function(deep) {
	        var node = this._clone(deep);
	        if (deep) {
	            var label = node.label;
	            var def = this.label;
	            node.walk(new TreeWalker(function(node) {
	                if (node instanceof AST_LoopControl
	                    && node.label && node.label.thedef === def) {
	                    node.label.thedef = label;
	                    label.references.push(node);
	                }
	            }));
	        }
	        return node;
	    }
	}, AST_StatementWithBody);

	var AST_IterationStatement = DEFNODE(
	    "IterationStatement",
	    "block_scope",
	    function AST_IterationStatement(props) {
	        if (props) {
	            this.block_scope = props.block_scope;
	            this.body = props.body;
	            this.start = props.start;
	            this.end = props.end;
	        }

	        this.flags = 0;
	    },
	    {
	        $documentation: "Internal class.  All loops inherit from it.",
	        $propdoc: {
	            block_scope: "[AST_Scope] the block scope for this iteration statement."
	        },
	        clone: clone_block_scope
	    },
	    AST_StatementWithBody
	);

	var AST_DWLoop = DEFNODE("DWLoop", "condition", function AST_DWLoop(props) {
	    if (props) {
	        this.condition = props.condition;
	        this.block_scope = props.block_scope;
	        this.body = props.body;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "Base class for do/while statements",
	    $propdoc: {
	        condition: "[AST_Node] the loop condition.  Should not be instanceof AST_Statement"
	    }
	}, AST_IterationStatement);

	var AST_Do = DEFNODE("Do", null, function AST_Do(props) {
	    if (props) {
	        this.condition = props.condition;
	        this.block_scope = props.block_scope;
	        this.body = props.body;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "A `do` statement",
	    _walk: function(visitor) {
	        return visitor._visit(this, function() {
	            this.body._walk(visitor);
	            this.condition._walk(visitor);
	        });
	    },
	    _children_backwards(push) {
	        push(this.condition);
	        push(this.body);
	    }
	}, AST_DWLoop);

	var AST_While = DEFNODE("While", null, function AST_While(props) {
	    if (props) {
	        this.condition = props.condition;
	        this.block_scope = props.block_scope;
	        this.body = props.body;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "A `while` statement",
	    _walk: function(visitor) {
	        return visitor._visit(this, function() {
	            this.condition._walk(visitor);
	            this.body._walk(visitor);
	        });
	    },
	    _children_backwards(push) {
	        push(this.body);
	        push(this.condition);
	    },
	}, AST_DWLoop);

	var AST_For = DEFNODE("For", "init condition step", function AST_For(props) {
	    if (props) {
	        this.init = props.init;
	        this.condition = props.condition;
	        this.step = props.step;
	        this.block_scope = props.block_scope;
	        this.body = props.body;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "A `for` statement",
	    $propdoc: {
	        init: "[AST_Node?] the `for` initialization code, or null if empty",
	        condition: "[AST_Node?] the `for` termination clause, or null if empty",
	        step: "[AST_Node?] the `for` update clause, or null if empty"
	    },
	    _walk: function(visitor) {
	        return visitor._visit(this, function() {
	            if (this.init) this.init._walk(visitor);
	            if (this.condition) this.condition._walk(visitor);
	            if (this.step) this.step._walk(visitor);
	            this.body._walk(visitor);
	        });
	    },
	    _children_backwards(push) {
	        push(this.body);
	        if (this.step) push(this.step);
	        if (this.condition) push(this.condition);
	        if (this.init) push(this.init);
	    },
	}, AST_IterationStatement);

	var AST_ForIn = DEFNODE("ForIn", "init object", function AST_ForIn(props) {
	    if (props) {
	        this.init = props.init;
	        this.object = props.object;
	        this.block_scope = props.block_scope;
	        this.body = props.body;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "A `for ... in` statement",
	    $propdoc: {
	        init: "[AST_Node] the `for/in` initialization code",
	        object: "[AST_Node] the object that we're looping through"
	    },
	    _walk: function(visitor) {
	        return visitor._visit(this, function() {
	            this.init._walk(visitor);
	            this.object._walk(visitor);
	            this.body._walk(visitor);
	        });
	    },
	    _children_backwards(push) {
	        push(this.body);
	        if (this.object) push(this.object);
	        if (this.init) push(this.init);
	    },
	}, AST_IterationStatement);

	var AST_ForOf = DEFNODE("ForOf", "await", function AST_ForOf(props) {
	    if (props) {
	        this.await = props.await;
	        this.init = props.init;
	        this.object = props.object;
	        this.block_scope = props.block_scope;
	        this.body = props.body;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "A `for ... of` statement",
	}, AST_ForIn);

	var AST_With = DEFNODE("With", "expression", function AST_With(props) {
	    if (props) {
	        this.expression = props.expression;
	        this.body = props.body;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "A `with` statement",
	    $propdoc: {
	        expression: "[AST_Node] the `with` expression"
	    },
	    _walk: function(visitor) {
	        return visitor._visit(this, function() {
	            this.expression._walk(visitor);
	            this.body._walk(visitor);
	        });
	    },
	    _children_backwards(push) {
	        push(this.body);
	        push(this.expression);
	    },
	}, AST_StatementWithBody);

	/* -----[ scope and functions ]----- */

	var AST_Scope = DEFNODE(
	    "Scope",
	    "variables uses_with uses_eval parent_scope enclosed cname",
	    function AST_Scope(props) {
	        if (props) {
	            this.variables = props.variables;
	            this.uses_with = props.uses_with;
	            this.uses_eval = props.uses_eval;
	            this.parent_scope = props.parent_scope;
	            this.enclosed = props.enclosed;
	            this.cname = props.cname;
	            this.body = props.body;
	            this.block_scope = props.block_scope;
	            this.start = props.start;
	            this.end = props.end;
	        }

	        this.flags = 0;
	    },
	    {
	        $documentation: "Base class for all statements introducing a lexical scope",
	        $propdoc: {
	            variables: "[Map/S] a map of name -> SymbolDef for all variables/functions defined in this scope",
	            uses_with: "[boolean/S] tells whether this scope uses the `with` statement",
	            uses_eval: "[boolean/S] tells whether this scope contains a direct call to the global `eval`",
	            parent_scope: "[AST_Scope?/S] link to the parent scope",
	            enclosed: "[SymbolDef*/S] a list of all symbol definitions that are accessed from this scope or any subscopes",
	            cname: "[integer/S] current index for mangling variables (used internally by the mangler)",
	        },
	        get_defun_scope: function() {
	            var self = this;
	            while (self.is_block_scope()) {
	                self = self.parent_scope;
	            }
	            return self;
	        },
	        clone: function(deep, toplevel) {
	            var node = this._clone(deep);
	            if (deep && this.variables && toplevel && !this._block_scope) {
	                node.figure_out_scope({}, {
	                    toplevel: toplevel,
	                    parent_scope: this.parent_scope
	                });
	            } else {
	                if (this.variables) node.variables = new Map(this.variables);
	                if (this.enclosed) node.enclosed = this.enclosed.slice();
	                if (this._block_scope) node._block_scope = this._block_scope;
	            }
	            return node;
	        },
	        pinned: function() {
	            return this.uses_eval || this.uses_with;
	        }
	    },
	    AST_Block
	);

	var AST_Toplevel = DEFNODE("Toplevel", "globals", function AST_Toplevel(props) {
	    if (props) {
	        this.globals = props.globals;
	        this.variables = props.variables;
	        this.uses_with = props.uses_with;
	        this.uses_eval = props.uses_eval;
	        this.parent_scope = props.parent_scope;
	        this.enclosed = props.enclosed;
	        this.cname = props.cname;
	        this.body = props.body;
	        this.block_scope = props.block_scope;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "The toplevel scope",
	    $propdoc: {
	        globals: "[Map/S] a map of name -> SymbolDef for all undeclared names",
	    },
	    wrap_commonjs: function(name) {
	        var body = this.body;
	        var wrapped_tl = "(function(exports){'$ORIG';})(typeof " + name + "=='undefined'?(" + name + "={}):" + name + ");";
	        wrapped_tl = parse(wrapped_tl);
	        wrapped_tl = wrapped_tl.transform(new TreeTransformer(function(node) {
	            if (node instanceof AST_Directive && node.value == "$ORIG") {
	                return MAP.splice(body);
	            }
	        }));
	        return wrapped_tl;
	    },
	    wrap_enclose: function(args_values) {
	        if (typeof args_values != "string") args_values = "";
	        var index = args_values.indexOf(":");
	        if (index < 0) index = args_values.length;
	        var body = this.body;
	        return parse([
	            "(function(",
	            args_values.slice(0, index),
	            '){"$ORIG"})(',
	            args_values.slice(index + 1),
	            ")"
	        ].join("")).transform(new TreeTransformer(function(node) {
	            if (node instanceof AST_Directive && node.value == "$ORIG") {
	                return MAP.splice(body);
	            }
	        }));
	    }
	}, AST_Scope);

	var AST_Expansion = DEFNODE("Expansion", "expression", function AST_Expansion(props) {
	    if (props) {
	        this.expression = props.expression;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "An expandible argument, such as ...rest, a splat, such as [1,2,...all], or an expansion in a variable declaration, such as var [first, ...rest] = list",
	    $propdoc: {
	        expression: "[AST_Node] the thing to be expanded"
	    },
	    _walk: function(visitor) {
	        return visitor._visit(this, function() {
	            this.expression.walk(visitor);
	        });
	    },
	    _children_backwards(push) {
	        push(this.expression);
	    },
	});

	var AST_Lambda = DEFNODE(
	    "Lambda",
	    "name argnames uses_arguments is_generator async",
	    function AST_Lambda(props) {
	        if (props) {
	            this.name = props.name;
	            this.argnames = props.argnames;
	            this.uses_arguments = props.uses_arguments;
	            this.is_generator = props.is_generator;
	            this.async = props.async;
	            this.variables = props.variables;
	            this.uses_with = props.uses_with;
	            this.uses_eval = props.uses_eval;
	            this.parent_scope = props.parent_scope;
	            this.enclosed = props.enclosed;
	            this.cname = props.cname;
	            this.body = props.body;
	            this.block_scope = props.block_scope;
	            this.start = props.start;
	            this.end = props.end;
	        }

	        this.flags = 0;
	    },
	    {
	        $documentation: "Base class for functions",
	        $propdoc: {
	            name: "[AST_SymbolDeclaration?] the name of this function",
	            argnames: "[AST_SymbolFunarg|AST_Destructuring|AST_Expansion|AST_DefaultAssign*] array of function arguments, destructurings, or expanding arguments",
	            uses_arguments: "[boolean/S] tells whether this function accesses the arguments array",
	            is_generator: "[boolean] is this a generator method",
	            async: "[boolean] is this method async",
	        },
	        args_as_names: function () {
	            var out = [];
	            for (var i = 0; i < this.argnames.length; i++) {
	                if (this.argnames[i] instanceof AST_Destructuring) {
	                    out.push(...this.argnames[i].all_symbols());
	                } else {
	                    out.push(this.argnames[i]);
	                }
	            }
	            return out;
	        },
	        _walk: function(visitor) {
	            return visitor._visit(this, function() {
	                if (this.name) this.name._walk(visitor);
	                var argnames = this.argnames;
	                for (var i = 0, len = argnames.length; i < len; i++) {
	                    argnames[i]._walk(visitor);
	                }
	                walk_body(this, visitor);
	            });
	        },
	        _children_backwards(push) {
	            let i = this.body.length;
	            while (i--) push(this.body[i]);

	            i = this.argnames.length;
	            while (i--) push(this.argnames[i]);

	            if (this.name) push(this.name);
	        },
	        is_braceless() {
	            return this.body[0] instanceof AST_Return && this.body[0].value;
	        },
	        // Default args and expansion don't count, so .argnames.length doesn't cut it
	        length_property() {
	            let length = 0;

	            for (const arg of this.argnames) {
	                if (arg instanceof AST_SymbolFunarg || arg instanceof AST_Destructuring) {
	                    length++;
	                }
	            }

	            return length;
	        }
	    },
	    AST_Scope
	);

	var AST_Accessor = DEFNODE("Accessor", null, function AST_Accessor(props) {
	    if (props) {
	        this.name = props.name;
	        this.argnames = props.argnames;
	        this.uses_arguments = props.uses_arguments;
	        this.is_generator = props.is_generator;
	        this.async = props.async;
	        this.variables = props.variables;
	        this.uses_with = props.uses_with;
	        this.uses_eval = props.uses_eval;
	        this.parent_scope = props.parent_scope;
	        this.enclosed = props.enclosed;
	        this.cname = props.cname;
	        this.body = props.body;
	        this.block_scope = props.block_scope;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "A setter/getter function.  The `name` property is always null."
	}, AST_Lambda);

	var AST_Function = DEFNODE("Function", null, function AST_Function(props) {
	    if (props) {
	        this.name = props.name;
	        this.argnames = props.argnames;
	        this.uses_arguments = props.uses_arguments;
	        this.is_generator = props.is_generator;
	        this.async = props.async;
	        this.variables = props.variables;
	        this.uses_with = props.uses_with;
	        this.uses_eval = props.uses_eval;
	        this.parent_scope = props.parent_scope;
	        this.enclosed = props.enclosed;
	        this.cname = props.cname;
	        this.body = props.body;
	        this.block_scope = props.block_scope;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "A function expression"
	}, AST_Lambda);

	var AST_Arrow = DEFNODE("Arrow", null, function AST_Arrow(props) {
	    if (props) {
	        this.name = props.name;
	        this.argnames = props.argnames;
	        this.uses_arguments = props.uses_arguments;
	        this.is_generator = props.is_generator;
	        this.async = props.async;
	        this.variables = props.variables;
	        this.uses_with = props.uses_with;
	        this.uses_eval = props.uses_eval;
	        this.parent_scope = props.parent_scope;
	        this.enclosed = props.enclosed;
	        this.cname = props.cname;
	        this.body = props.body;
	        this.block_scope = props.block_scope;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "An ES6 Arrow function ((a) => b)"
	}, AST_Lambda);

	var AST_Defun = DEFNODE("Defun", null, function AST_Defun(props) {
	    if (props) {
	        this.name = props.name;
	        this.argnames = props.argnames;
	        this.uses_arguments = props.uses_arguments;
	        this.is_generator = props.is_generator;
	        this.async = props.async;
	        this.variables = props.variables;
	        this.uses_with = props.uses_with;
	        this.uses_eval = props.uses_eval;
	        this.parent_scope = props.parent_scope;
	        this.enclosed = props.enclosed;
	        this.cname = props.cname;
	        this.body = props.body;
	        this.block_scope = props.block_scope;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "A function definition"
	}, AST_Lambda);

	/* -----[ DESTRUCTURING ]----- */
	var AST_Destructuring = DEFNODE("Destructuring", "names is_array", function AST_Destructuring(props) {
	    if (props) {
	        this.names = props.names;
	        this.is_array = props.is_array;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "A destructuring of several names. Used in destructuring assignment and with destructuring function argument names",
	    $propdoc: {
	        "names": "[AST_Node*] Array of properties or elements",
	        "is_array": "[Boolean] Whether the destructuring represents an object or array"
	    },
	    _walk: function(visitor) {
	        return visitor._visit(this, function() {
	            this.names.forEach(function(name) {
	                name._walk(visitor);
	            });
	        });
	    },
	    _children_backwards(push) {
	        let i = this.names.length;
	        while (i--) push(this.names[i]);
	    },
	    all_symbols: function() {
	        var out = [];
	        walk(this, node => {
	            if (node instanceof AST_SymbolDeclaration) {
	                out.push(node);
	            }
	            if (node instanceof AST_Lambda) {
	                return true;
	            }
	        });
	        return out;
	    }
	});

	var AST_PrefixedTemplateString = DEFNODE(
	    "PrefixedTemplateString",
	    "template_string prefix",
	    function AST_PrefixedTemplateString(props) {
	        if (props) {
	            this.template_string = props.template_string;
	            this.prefix = props.prefix;
	            this.start = props.start;
	            this.end = props.end;
	        }

	        this.flags = 0;
	    },
	    {
	        $documentation: "A templatestring with a prefix, such as String.raw`foobarbaz`",
	        $propdoc: {
	            template_string: "[AST_TemplateString] The template string",
	            prefix: "[AST_Node] The prefix, which will get called."
	        },
	        _walk: function(visitor) {
	            return visitor._visit(this, function () {
	                this.prefix._walk(visitor);
	                this.template_string._walk(visitor);
	            });
	        },
	        _children_backwards(push) {
	            push(this.template_string);
	            push(this.prefix);
	        },
	    }
	);

	var AST_TemplateString = DEFNODE("TemplateString", "segments", function AST_TemplateString(props) {
	    if (props) {
	        this.segments = props.segments;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "A template string literal",
	    $propdoc: {
	        segments: "[AST_Node*] One or more segments, starting with AST_TemplateSegment. AST_Node may follow AST_TemplateSegment, but each AST_Node must be followed by AST_TemplateSegment."
	    },
	    _walk: function(visitor) {
	        return visitor._visit(this, function() {
	            this.segments.forEach(function(seg) {
	                seg._walk(visitor);
	            });
	        });
	    },
	    _children_backwards(push) {
	        let i = this.segments.length;
	        while (i--) push(this.segments[i]);
	    }
	});

	var AST_TemplateSegment = DEFNODE("TemplateSegment", "value raw", function AST_TemplateSegment(props) {
	    if (props) {
	        this.value = props.value;
	        this.raw = props.raw;
	        this.start = props.start;
	        this.end = props.end;
	    }

	    this.flags = 0;
	}, {
	    $documentation: "A segment of a template string literal",
	    $propdoc: {
	        value: "Content of the segment",
	        raw: "Raw source of the segment",
	    }
	});

	/* -----[ JUMPS ]----- */

	var AST_Jump = DE